"""Generated from lda_c_rc04.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  AA = -0.655868

  BB = 4.88827

  CC = 3.177037

  DD = 0.897889

  phi = lambda z: 1 / 2 * (f.opz_pow_n(z, 2 / 3) + f.opz_pow_n(-z, 2 / 3))

  f_rc04 = lambda rs, zeta: phi(zeta) ** 3 * (AA * jnp.arctan(BB + CC * rs) + DD) / rs

  functional_body = lambda rs, zeta: f_rc04(rs, zeta)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  AA = -0.655868

  BB = 4.88827

  CC = 3.177037

  DD = 0.897889

  phi = lambda z: 1 / 2 * (f.opz_pow_n(z, 2 / 3) + f.opz_pow_n(-z, 2 / 3))

  f_rc04 = lambda rs, zeta: phi(zeta) ** 3 * (AA * jnp.arctan(BB + CC * rs) + DD) / rs

  functional_body = lambda rs, zeta: f_rc04(rs, zeta)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  AA = -0.655868

  BB = 4.88827

  CC = 3.177037

  DD = 0.897889

  phi = lambda z: 1 / 2 * (f.opz_pow_n(z, 2 / 3) + f.opz_pow_n(-z, 2 / 3))

  f_rc04 = lambda rs, zeta: phi(zeta) ** 3 * (AA * jnp.arctan(BB + CC * rs) + DD) / rs

  functional_body = lambda rs, zeta: f_rc04(rs, zeta)

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = 0.1e1 + t4
  t6 = t5 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = t5 ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t11 = f.my_piecewise3(t6, t8, t10)
  t12 = 0.1e1 - t4
  t13 = t12 <= f.p.zeta_threshold
  t14 = t12 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t16 = f.my_piecewise3(t13, t8, t15)
  t18 = t11 / 0.2e1 + t16 / 0.2e1
  t19 = t18 ** 2
  t20 = t19 * t18
  t21 = 3 ** (0.1e1 / 0.3e1)
  t23 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t25 = 4 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = t2 ** (0.1e1 / 0.3e1)
  t32 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t21 * t23 * t26 / t27
  t33 = jnp.arctan(t32)
  t35 = -0.655868e0 * t33 + 0.897889e0
  t37 = t21 ** 2
  t39 = 0.1e1 / t23
  t43 = 0.4e1 / 0.9e1 * t20 * t35 * t37 * t39 * t25 * t27
  t46 = t27 * t2 * t19 * t35
  t47 = t37 * t39
  t48 = 0.1e1 / t9
  t49 = t2 ** 2
  t51 = t1 / t49
  t52 = t3 - t51
  t55 = f.my_piecewise3(t6, 0, 0.2e1 / 0.3e1 * t48 * t52)
  t56 = 0.1e1 / t14
  t60 = f.my_piecewise3(t13, 0, -0.2e1 / 0.3e1 * t56 * t52)
  t66 = t32 ** 2
  t70 = 0.69457230103866666666666666666666666666666666666663e0 * t20 / (0.1e1 + t66)
  vrho_0_ = t43 + t46 * t47 * t25 * (t55 / 0.2e1 + t60 / 0.2e1) + t70
  t71 = -t3 - t51
  t74 = f.my_piecewise3(t6, 0, 0.2e1 / 0.3e1 * t48 * t71)
  t78 = f.my_piecewise3(t13, 0, -0.2e1 / 0.3e1 * t56 * t71)
  vrho_1_ = t43 + t46 * t47 * t25 * (t74 / 0.2e1 + t78 / 0.2e1) + t70
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  AA = -0.655868

  BB = 4.88827

  CC = 3.177037

  DD = 0.897889

  phi = lambda z: 1 / 2 * (f.opz_pow_n(z, 2 / 3) + f.opz_pow_n(-z, 2 / 3))

  f_rc04 = lambda rs, zeta: phi(zeta) ** 3 * (AA * jnp.arctan(BB + CC * rs) + DD) / rs

  functional_body = lambda rs, zeta: f_rc04(rs, zeta)

  t2 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t3, 1)
  t5 = t4 ** 2
  t6 = t5 * t4
  t7 = 3 ** (0.1e1 / 0.3e1)
  t9 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t11 = 4 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t13 = r0 ** (0.1e1 / 0.3e1)
  t18 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t7 * t9 * t12 / t13
  t19 = jnp.arctan(t18)
  t23 = t7 ** 2
  t30 = t18 ** 2
  vrho_0_ = 0.4e1 / 0.9e1 * t6 * (-0.655868e0 * t19 + 0.897889e0) * t23 / t9 * t11 * t13 + 0.69457230103866666666666666666666666666666666666663e0 * t6 / (0.1e1 + t30)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  res = {'vrho': vrho_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t5 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t6, 1)
  t8 = t7 ** 2
  t9 = t8 * t7
  t11 = 3 ** (0.1e1 / 0.3e1)
  t13 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t14 = t11 * t13
  t15 = 4 ** (0.1e1 / 0.3e1)
  t16 = t15 ** 2
  t21 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t14 * t16 / t1
  t22 = jnp.arctan(t21)
  t26 = t11 ** 2
  t34 = t21 ** 2
  t35 = 0.1e1 + t34
  t39 = t35 ** 2
  v2rho2_0_ = 0.4e1 / 0.27e2 / t2 * t9 * (-0.655868e0 * t22 + 0.897889e0) * t26 / t13 * t15 + 0.92609640138488888888888888888888888888888888888884e0 / r0 * t9 / t35 + 0.36778031659583040511111111111111111111111111111109e0 * t9 / t39 * t21 * t14 * t16 / t1 / r0
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t6 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t7 = t6 ** 2
  t8 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t7, 1)
  t9 = t8 ** 2
  t10 = t9 * t8
  t12 = 3 ** (0.1e1 / 0.3e1)
  t14 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t16 = 4 ** (0.1e1 / 0.3e1)
  t17 = t16 ** 2
  t22 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t12 * t14 * t17 / t1
  t23 = jnp.atan(t22)
  t27 = t12 ** 2
  t33 = r0 ** 2
  t36 = t22 ** 2
  t37 = 0.1e1 + t36
  t44 = t37 ** 2
  t45 = 0.1e1 / t44
  t56 = t14 ** 2
  t59 = 0.1e1 / t2 / t33
  v3rho3_0_ = -0.8e1 / 0.81e2 / t2 / r0 * t10 * (-0.655868e0 * t23 + 0.897889e0) * t27 / t14 * t16 - 0.61739760092325925925925925925925925925925925925923e0 / t33 * t10 / t37 - 0.1e-49 / t1 / t33 * t10 * t45 * t22 * t12 * t14 * t17 + 0.15579355649288896570173188148148148148148148148147e1 * t10 / t44 / t37 * t36 * t27 * t56 * t16 * t59 - 0.38948389123222241425432970370370370370370370370367e0 * t10 * t45 * t27 * t56 * t16 * t59

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** 2
  t2 = r0 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t7 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t8, 1)
  t10 = t9 ** 2
  t11 = t10 * t9
  t13 = 3 ** (0.1e1 / 0.3e1)
  t14 = 0.1e1 / jnp.pi
  t15 = t14 ** (0.1e1 / 0.3e1)
  t17 = 4 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t23 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t13 * t15 * t18 / t2
  t24 = jnp.atan(t23)
  t28 = t13 ** 2
  t34 = t1 * r0
  t37 = t23 ** 2
  t38 = 0.1e1 + t37
  t45 = t38 ** 2
  t46 = 0.1e1 / t45
  t55 = 0.1e1 / t3 / t34 * t11
  t57 = 0.1e1 / t45 / t38
  t60 = t15 ** 2
  t70 = t45 ** 2
  t75 = t1 ** 2
  t76 = 0.1e1 / t75
  v4rho4_0_ = 0.40e2 / 0.243e3 / t3 / t1 * t11 * (-0.655868e0 * t24 + 0.897889e0) * t28 / t15 * t17 + 0.10289960015387654320987654320987654320987654320988e1 / t34 * t11 / t38 - 0.32691583697407147120987654320987654320987654320984e0 / t2 / t34 * t11 * t46 * t23 * t13 * t15 * t18 - 0.41544948398103724187128501728395061728395061728392e1 * t55 * t57 * t37 * t28 * t60 * t17 + 0.10386237099525931046782125432098765432098765432098e1 * t55 * t46 * t28 * t60 * t17 + 0.29697713600369908855567989092776888888888888888887e2 * t11 / t70 * t37 * t23 * t14 * t76 - 0.14848856800184954427783994546388444444444444444443e2 * t11 * t57 * t23 * t14 * t76

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 + r1
  t2 = t1 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t5 = r0 - r1
  t6 = 0.1e1 / t1
  t7 = t5 * t6
  t8 = 0.1e1 + t7
  t9 = t8 <= f.p.zeta_threshold
  t10 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t11 = t10 ** 2
  t12 = t8 ** (0.1e1 / 0.3e1)
  t13 = t12 ** 2
  t14 = f.my_piecewise3(t9, t11, t13)
  t15 = 0.1e1 - t7
  t16 = t15 <= f.p.zeta_threshold
  t17 = t15 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t19 = f.my_piecewise3(t16, t11, t18)
  t21 = t14 / 0.2e1 + t19 / 0.2e1
  t22 = t21 ** 2
  t23 = t22 * t21
  t25 = 3 ** (0.1e1 / 0.3e1)
  t27 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t28 = t25 * t27
  t29 = 4 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t35 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t28 * t30 / t2
  t36 = jnp.arctan(t35)
  t38 = -0.655868e0 * t36 + 0.897889e0
  t40 = t25 ** 2
  t41 = 0.1e1 / t27
  t42 = t40 * t41
  t45 = 0.4e1 / 0.27e2 / t3 * t23 * t38 * t42 * t29
  t47 = t2 * t22 * t38
  t48 = 0.1e1 / t12
  t49 = t1 ** 2
  t50 = 0.1e1 / t49
  t51 = t5 * t50
  t52 = t6 - t51
  t55 = f.my_piecewise3(t9, 0, 0.2e1 / 0.3e1 * t48 * t52)
  t56 = 0.1e1 / t17
  t57 = -t52
  t60 = f.my_piecewise3(t16, 0, 0.2e1 / 0.3e1 * t56 * t57)
  t62 = t55 / 0.2e1 + t60 / 0.2e1
  t65 = t47 * t42 * t29 * t62
  t68 = t35 ** 2
  t69 = 0.1e1 + t68
  t70 = 0.1e1 / t69
  t72 = 0.92609640138488888888888888888888888888888888888884e0 * t6 * t23 * t70
  t73 = t2 * t1
  t74 = t73 * t21
  t75 = t74 * t38
  t76 = t62 ** 2
  t81 = t22 * t70
  t82 = t81 * t62
  t85 = t73 * t22 * t38
  t87 = 0.1e1 / t12 / t8
  t88 = t52 ** 2
  t92 = 0.1e1 / t49 / t1
  t93 = t5 * t92
  t95 = -0.2e1 * t50 + 0.2e1 * t93
  t99 = f.my_piecewise3(t9, 0, -0.2e1 / 0.9e1 * t87 * t88 + 0.2e1 / 0.3e1 * t48 * t95)
  t101 = 0.1e1 / t17 / t15
  t102 = t57 ** 2
  t109 = f.my_piecewise3(t16, 0, -0.2e1 / 0.9e1 * t101 * t102 - 0.2e1 / 0.3e1 * t56 * t95)
  t115 = t69 ** 2
  t123 = 0.36778031659583040511111111111111111111111111111109e0 * t23 / t115 * t35 * t28 * t30 / t73
  d11 = t45 + 0.8e1 / 0.3e1 * t65 + t72 + 0.2e1 * t75 * t42 * t29 * t76 + 0.41674338062319999999999999999999999999999999999998e1 * t82 + t85 * t42 * t29 * (t99 / 0.2e1 + t109 / 0.2e1) + t123
  t125 = -t6 - t51
  t128 = f.my_piecewise3(t9, 0, 0.2e1 / 0.3e1 * t48 * t125)
  t129 = -t125
  t132 = f.my_piecewise3(t16, 0, 0.2e1 / 0.3e1 * t56 * t129)
  t134 = t128 / 0.2e1 + t132 / 0.2e1
  t137 = t47 * t42 * t29 * t134
  t146 = t81 * t134
  t155 = f.my_piecewise3(t9, 0, -0.2e1 / 0.9e1 * t87 * t125 * t52 + 0.4e1 / 0.3e1 * t48 * t5 * t92)
  t163 = f.my_piecewise3(t16, 0, -0.2e1 / 0.9e1 * t101 * t129 * t57 - 0.4e1 / 0.3e1 * t56 * t5 * t92)
  d12 = t45 + 0.4e1 / 0.3e1 * t65 + t72 + 0.4e1 / 0.3e1 * t137 + 0.2e1 * t74 * t38 * t40 * t41 * t29 * t134 * t62 + 0.20837169031159999999999999999999999999999999999999e1 * t146 + t85 * t42 * t29 * (t155 / 0.2e1 + t163 / 0.2e1) + 0.20837169031159999999999999999999999999999999999999e1 * t82 + t123
  t171 = t134 ** 2
  t177 = t125 ** 2
  t181 = 0.2e1 * t50 + 0.2e1 * t93
  t185 = f.my_piecewise3(t9, 0, -0.2e1 / 0.9e1 * t87 * t177 + 0.2e1 / 0.3e1 * t48 * t181)
  t186 = t129 ** 2
  t193 = f.my_piecewise3(t16, 0, -0.2e1 / 0.9e1 * t101 * t186 - 0.2e1 / 0.3e1 * t56 * t181)
  d22 = t45 + 0.8e1 / 0.3e1 * t137 + t72 + 0.2e1 * t75 * t42 * t29 * t171 + 0.41674338062319999999999999999999999999999999999998e1 * t146 + t85 * t42 * t29 * (t185 / 0.2e1 + t193 / 0.2e1) + t123
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = r0 + r1
  t2 = 0.1e1 / t1
  t3 = r0 - r1
  t4 = t3 * t2
  t5 = 0.1e1 + t4
  t6 = t5 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = t5 ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t11 = f.my_piecewise3(t6, t8, t10)
  t12 = 0.1e1 - t4
  t13 = t12 <= f.p.zeta_threshold
  t14 = t12 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t16 = f.my_piecewise3(t13, t8, t15)
  t18 = t11 / 0.2e1 + t16 / 0.2e1
  t19 = t18 ** 2
  t21 = 3 ** (0.1e1 / 0.3e1)
  t23 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t24 = t21 * t23
  t25 = 4 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = t1 ** (0.1e1 / 0.3e1)
  t32 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t24 * t26 / t27
  t33 = t32 ** 2
  t34 = 0.1e1 + t33
  t35 = 0.1e1 / t34
  t36 = 0.1e1 / t9
  t37 = t1 ** 2
  t38 = 0.1e1 / t37
  t40 = -t3 * t38 + t2
  t43 = f.my_piecewise3(t6, 0, 0.2e1 / 0.3e1 * t36 * t40)
  t44 = 0.1e1 / t14
  t45 = -t40
  t48 = f.my_piecewise3(t13, 0, 0.2e1 / 0.3e1 * t44 * t45)
  t50 = t43 / 0.2e1 + t48 / 0.2e1
  t54 = t19 * t18
  t59 = t50 ** 2
  t64 = 0.1e1 / t9 / t5
  t65 = t40 ** 2
  t69 = 0.1e1 / t37 / t1
  t72 = 0.2e1 * t3 * t69 - 0.2e1 * t38
  t76 = f.my_piecewise3(t6, 0, -0.2e1 / 0.9e1 * t64 * t65 + 0.2e1 / 0.3e1 * t36 * t72)
  t78 = 0.1e1 / t14 / t12
  t79 = t45 ** 2
  t82 = -t72
  t86 = f.my_piecewise3(t13, 0, -0.2e1 / 0.9e1 * t78 * t79 + 0.2e1 / 0.3e1 * t44 * t82)
  t88 = t76 / 0.2e1 + t86 / 0.2e1
  t91 = t34 ** 2
  t92 = 0.1e1 / t91
  t94 = t21 ** 2
  t96 = t23 ** 2
  t98 = t27 ** 2
  t100 = 0.1e1 / t98 / t37
  t105 = jnp.atan(t32)
  t107 = -0.655868e0 * t105 + 0.897889e0
  t109 = 0.1e1 / t23
  t110 = t94 * t109
  t115 = t27 * t1
  t136 = t110 * t25
  t168 = t5 ** 2
  t177 = t37 ** 2
  t181 = 0.6e1 * t69 - 0.6e1 * t3 / t177
  t185 = f.my_piecewise3(t6, 0, 0.8e1 / 0.27e2 / t9 / t168 * t65 * t40 - 0.2e1 / 0.3e1 * t64 * t40 * t72 + 0.2e1 / 0.3e1 * t36 * t181)
  t186 = t12 ** 2
  t199 = f.my_piecewise3(t13, 0, 0.8e1 / 0.27e2 / t14 / t186 * t79 * t45 - 0.2e1 / 0.3e1 * t78 * t45 * t82 - 0.2e1 / 0.3e1 * t44 * t181)
  d111 = 0.83348676124639999999999999999999999999999999999996e1 * t2 * t19 * t35 * t50 - 0.61739760092325925925925925925925925925925925925923e0 * t38 * t54 * t35 + 0.12502301418695999999999999999999999999999999999999e2 * t18 * t35 * t59 + 0.62511507093479999999999999999999999999999999999997e1 * t19 * t35 * t88 - 0.38948389123222241425432970370370370370370370370367e0 * t54 * t92 * t94 * t96 * t25 * t100 + 0.8e1 * t27 * t18 * t107 * t110 * t25 * t59 + 0.6e1 * t115 * t18 * t107 * t94 * t109 * t25 * t50 * t88 + 0.33100228493624736459999999999999999999999999999998e1 * t19 * t92 * t50 * t32 * t24 * t26 / t115 - 0.8e1 / 0.81e2 / t98 / t1 * t54 * t107 * t136 + 0.4e1 / 0.3e1 / t98 * t19 * t107 * t110 * t25 * t50 + 0.4e1 * t27 * t19 * t107 * t110 * t25 * t88 - 0.1e-49 / t27 / t37 * t54 * t92 * t32 * t21 * t23 * t26 + 0.2e1 * t115 * t59 * t50 * t107 * t136 + t115 * t19 * t107 * t110 * t25 * (t185 / 0.2e1 + t199 / 0.2e1) + 0.15579355649288896570173188148148148148148148148147e1 * t54 / t91 / t34 * t33 * t94 * t96 * t25 * t100

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = 0.1e1 + t4
  t6 = t5 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = t5 ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t11 = f.my_piecewise3(t6, t8, t10)
  t12 = 0.1e1 - t4
  t13 = t12 <= f.p.zeta_threshold
  t14 = t12 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t16 = f.my_piecewise3(t13, t8, t15)
  t18 = t11 / 0.2e1 + t16 / 0.2e1
  t19 = t18 ** 2
  t20 = 3 ** (0.1e1 / 0.3e1)
  t21 = 0.1e1 / jnp.pi
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t20 * t22
  t24 = 4 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = t2 ** (0.1e1 / 0.3e1)
  t31 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t23 * t25 / t26
  t32 = t31 ** 2
  t33 = 0.1e1 + t32
  t34 = 0.1e1 / t33
  t36 = t5 ** 2
  t38 = 0.1e1 / t9 / t36
  t39 = t2 ** 2
  t40 = 0.1e1 / t39
  t42 = -t1 * t40 + t3
  t43 = t42 ** 2
  t48 = 0.1e1 / t9 / t5
  t49 = t48 * t42
  t50 = t39 * t2
  t51 = 0.1e1 / t50
  t54 = 0.2e1 * t1 * t51 - 0.2e1 * t40
  t57 = 0.1e1 / t9
  t58 = t39 ** 2
  t59 = 0.1e1 / t58
  t62 = -0.6e1 * t1 * t59 + 0.6e1 * t51
  t66 = f.my_piecewise3(t6, 0, 0.8e1 / 0.27e2 * t38 * t43 * t42 - 0.2e1 / 0.3e1 * t49 * t54 + 0.2e1 / 0.3e1 * t57 * t62)
  t67 = t12 ** 2
  t69 = 0.1e1 / t14 / t67
  t70 = -t42
  t71 = t70 ** 2
  t76 = 0.1e1 / t14 / t12
  t77 = t76 * t70
  t78 = -t54
  t81 = 0.1e1 / t14
  t82 = -t62
  t86 = f.my_piecewise3(t13, 0, 0.8e1 / 0.27e2 * t69 * t71 * t70 - 0.2e1 / 0.3e1 * t77 * t78 + 0.2e1 / 0.3e1 * t81 * t82)
  t88 = t66 / 0.2e1 + t86 / 0.2e1
  t91 = t19 * t18
  t95 = t33 ** 2
  t96 = t95 ** 2
  t105 = 0.1e1 / t95 / t33
  t113 = f.my_piecewise3(t6, 0, 0.2e1 / 0.3e1 * t57 * t42)
  t116 = f.my_piecewise3(t13, 0, 0.2e1 / 0.3e1 * t81 * t70)
  t118 = t113 / 0.2e1 + t116 / 0.2e1
  t119 = t118 ** 2
  t120 = t119 * t118
  t126 = 0.1e1 / t95
  t131 = t31 * t20 * t22 * t25
  t137 = t26 * t2
  t140 = t23 * t25 / t137
  t143 = t19 * t126
  t149 = f.my_piecewise3(t6, 0, -0.2e1 / 0.9e1 * t48 * t43 + 0.2e1 / 0.3e1 * t57 * t54)
  t155 = f.my_piecewise3(t13, 0, -0.2e1 / 0.9e1 * t76 * t71 + 0.2e1 / 0.3e1 * t81 * t78)
  t157 = t149 / 0.2e1 + t155 / 0.2e1
  t163 = jnp.atan(t31)
  t165 = -0.655868e0 * t163 + 0.897889e0
  t166 = t20 ** 2
  t167 = t165 * t166
  t169 = 0.1e1 / t22
  t170 = t169 * t24
  t171 = t118 * t157
  t175 = t137 * t18
  t184 = t22 ** 2
  t186 = t26 ** 2
  t188 = 0.1e1 / t186 / t39
  t205 = 0.83348676124639999999999999999999999999999999999996e1 * t19 * t34 * t88 + 0.10289960015387654320987654320987654320987654320988e1 * t51 * t91 * t34 + 0.29697713600369908855567989092776888888888888888887e2 * t91 / t96 * t32 * t31 * t21 * t59 - 0.14848856800184954427783994546388444444444444444443e2 * t91 * t105 * t21 * t59 * t31 + 0.16669735224927999999999999999999999999999999999999e2 * t120 * t34 - 0.3e-49 / t26 / t39 * t19 * t126 * t118 * t131 + 0.13240091397449894583999999999999999999999999999999e2 * t18 * t126 * t119 * t31 * t140 + 0.66200456987249472919999999999999999999999999999996e1 * t143 * t157 * t31 * t140 + 0.32e2 * t26 * t18 * t167 * t170 * t171 + 0.8e1 * t175 * t167 * t170 * t118 * t88 + 0.18695226779146675884207825777777777777777777777776e2 * t19 * t105 * t118 * t32 * t166 * t184 * t24 * t188 - 0.74087712110791111111111111111111111111111111111105e1 * t40 * t19 * t34 * t118 + 0.33339470449855999999999999999999999999999999999998e2 * t3 * t18 * t34 * t119 + 0.16669735224927999999999999999999999999999999999999e2 * t3 * t19 * t34 * t157
  t211 = t184 * t24
  t213 = 0.1e1 / t186 / t50
  t219 = t166 * t169
  t220 = t219 * t24
  t227 = 0.1e1 / t186
  t237 = t219 * t24 * t157
  t241 = t157 ** 2
  t286 = t43 ** 2
  t292 = t54 ** 2
  t301 = -0.24e2 * t59 + 0.24e2 * t1 / t58 / t2
  t305 = f.my_piecewise3(t6, 0, -0.56e2 / 0.81e2 / t9 / t36 / t5 * t286 + 0.16e2 / 0.9e1 * t38 * t43 * t54 - 0.2e1 / 0.3e1 * t48 * t292 - 0.8e1 / 0.9e1 * t49 * t62 + 0.2e1 / 0.3e1 * t57 * t301)
  t309 = t71 ** 2
  t315 = t78 ** 2
  t324 = f.my_piecewise3(t13, 0, -0.56e2 / 0.81e2 / t14 / t67 / t12 * t309 + 0.16e2 / 0.9e1 * t69 * t71 * t78 - 0.2e1 / 0.3e1 * t76 * t315 - 0.8e1 / 0.9e1 * t77 * t82 - 0.2e1 / 0.3e1 * t81 * t301)
  t330 = 0.50009205674783999999999999999999999999999999999996e2 * t18 * t34 * t171 + 0.10386237099525931046782125432098765432098765432098e1 * t91 * t126 * t166 * t211 * t213 + 0.32e2 / 0.3e1 * t26 * t120 * t165 * t220 + 0.40e2 / 0.243e3 * t188 * t91 * t165 * t220 + 0.16e2 / 0.3e1 * t227 * t18 * t165 * t219 * t24 * t119 + 0.12e2 * t137 * t119 * t165 * t237 + 0.6e1 * t175 * t165 * t219 * t24 * t241 - 0.32691583697407147120987654320987654320987654320984e0 / t26 / t50 * t91 * t126 * t131 - 0.46738066947866689710519564444444444444444444444440e1 * t143 * t166 * t211 * t188 * t118 - 0.32e2 / 0.27e2 / t186 / t2 * t19 * t165 * t219 * t24 * t118 + 0.8e1 / 0.3e1 * t227 * t19 * t165 * t237 + 0.16e2 / 0.3e1 * t26 * t19 * t165 * t219 * t24 * t88 - 0.41544948398103724187128501728395061728395061728392e1 * t213 * t91 * t105 * t32 * t166 * t211 + t137 * t19 * t165 * t219 * t24 * (t305 / 0.2e1 + t324 / 0.2e1)
  d1111 = t205 + t330

  res = {'v4rho4': d1111}
  return res
