"""Generated from lda_xc_zlp.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  a0 = 0.93222 * f.RS_FACTOR

  kk = 0.00947362 * f.RS_FACTOR

  functional_body = lambda rs, zeta=None: -a0 * (1 - kk * jnp.log(1 + rs / kk) / rs) / rs

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  a0 = 0.93222 * f.RS_FACTOR

  kk = 0.00947362 * f.RS_FACTOR

  functional_body = lambda rs, zeta=None: -a0 * (1 - kk * jnp.log(1 + rs / kk) / rs) / rs

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  a0 = 0.93222 * f.RS_FACTOR

  kk = 0.00947362 * f.RS_FACTOR

  functional_body = lambda rs, zeta=None: -a0 * (1 - kk * jnp.log(1 + rs / kk) / rs) / rs

  t1 = r0 + r1
  t2 = t1 ** (0.1e1 / 0.3e1)
  t5 = 0.1e1 + 0.10555627099250339363411240898410533671394883898658e3 / t2
  t6 = jnp.log(t5)
  t17 = t2 ** 2
  vrho_0_ = -0.12429600000000000000000000000000000000000000000000e1 * (0.1e1 - 0.94736200000000000000000000000000000000000000000000e-2 * t6 * t2) * t2 - 0.93222000000000000000000000000000000000000000000000e0 * t2 * t1 * (0.33333333333333333333333333333333333333333333333334e0 / t1 / t5 - 0.31578733333333333333333333333333333333333333333333e-2 * t6 / t17)
  vrho_1_ = vrho_0_
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  a0 = 0.93222 * f.RS_FACTOR

  kk = 0.00947362 * f.RS_FACTOR

  functional_body = lambda rs, zeta=None: -a0 * (1 - kk * jnp.log(1 + rs / kk) / rs) / rs

  t1 = r0 ** (0.1e1 / 0.3e1)
  t4 = 0.1e1 + 0.10555627099250339363411240898410533671394883898658e3 / t1
  t5 = jnp.log(t4)
  t16 = t1 ** 2
  vrho_0_ = -0.12429600000000000000000000000000000000000000000000e1 * (0.1e1 - 0.94736200000000000000000000000000000000000000000000e-2 * t5 * t1) * t1 - 0.93222000000000000000000000000000000000000000000000e0 * t1 * r0 * (0.33333333333333333333333333333333333333333333333334e0 / r0 / t4 - 0.31578733333333333333333333333333333333333333333333e-2 * t5 / t16)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  res = {'vrho': vrho_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t3 = 0.1e1 / t2
  t6 = 0.1e1 + 0.10555627099250339363411240898410533671394883898658e3 / t1
  t7 = jnp.log(t6)
  t14 = 0.1e1 / t6
  t23 = r0 ** 2
  t29 = t6 ** 2
  v2rho2_0_ = -0.41432000000000000000000000000000000000000000000000e0 * t3 * (0.1e1 - 0.94736200000000000000000000000000000000000000000000e-2 * t7 * t1) - 0.24859200000000000000000000000000000000000000000000e1 * t1 * (0.33333333333333333333333333333333333333333333333334e0 / r0 * t14 - 0.31578733333333333333333333333333333333333333333333e-2 * t7 * t3) - 0.93222000000000000000000000000000000000000000000000e0 * t1 * r0 * (-0.22222222222222222222222222222222222222222222222223e0 / t23 * t14 + 0.11728474554722599292679156553789481857105426554065e2 / t1 / t23 / t29 + 0.21052488888888888888888888888888888888888888888889e-2 * t7 / t2 / r0)
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t4 = 0.1e1 / t2 / r0
  t7 = 0.1e1 + 0.10555627099250339363411240898410533671394883898658e3 / t1
  t8 = jnp.log(t7)
  t14 = 0.1e1 / t2
  t16 = 0.1e1 / t7
  t24 = r0 ** 2
  t30 = t7 ** 2
  t31 = 0.1e1 / t30
  t40 = t24 * r0
  v3rho3_0_ = 0.27621333333333333333333333333333333333333333333333e0 * t4 * (0.1e1 - 0.94736200000000000000000000000000000000000000000000e-2 * t8 * t1) - 0.12429600000000000000000000000000000000000000000000e1 * t14 * (0.33333333333333333333333333333333333333333333333334e0 / r0 * t16 - 0.31578733333333333333333333333333333333333333333333e-2 * t8 * t14) - 0.37288800000000000000000000000000000000000000000000e1 * t1 * (-0.22222222222222222222222222222222222222222222222223e0 / t24 * t16 + 0.11728474554722599292679156553789481857105426554065e2 / t1 / t24 * t31 + 0.21052488888888888888888888888888888888888888888889e-2 * t8 * t4) - 0.93222000000000000000000000000000000000000000000000e0 * t1 * r0 * (0.37037037037037037037037037037037037037037037037038e0 / t40 * t16 - 0.35185423664167797878037469661368445571316279662195e2 / t1 / t40 * t31 + 0.82534269228465284250224353195430974693274070904719e3 / t2 / t40 / t30 / t7 - 0.35087481481481481481481481481481481481481481481482e-2 * t8 / t2 / t24)

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** 2
  t2 = r0 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t5 = 0.1e1 / t3 / t1
  t8 = 0.1e1 + 0.10555627099250339363411240898410533671394883898658e3 / t2
  t9 = jnp.log(t8)
  t16 = 0.1e1 / t3 / r0
  t18 = 0.1e1 / t8
  t21 = 0.1e1 / t3
  t32 = t8 ** 2
  t33 = 0.1e1 / t32
  t41 = t1 * r0
  t50 = 0.1e1 / t3 / t41
  t52 = 0.1e1 / t32 / t8
  t61 = t1 ** 2
  t75 = t32 ** 2
  v4rho4_0_ = -0.46035555555555555555555555555555555555555555555555e0 * t5 * (0.1e1 - 0.94736200000000000000000000000000000000000000000000e-2 * t9 * t2) + 0.11048533333333333333333333333333333333333333333333e1 * t16 * (0.33333333333333333333333333333333333333333333333334e0 / r0 * t18 - 0.31578733333333333333333333333333333333333333333333e-2 * t9 * t21) - 0.24859200000000000000000000000000000000000000000000e1 * t21 * (-0.22222222222222222222222222222222222222222222222223e0 / t1 * t18 + 0.11728474554722599292679156553789481857105426554065e2 / t2 / t1 * t33 + 0.21052488888888888888888888888888888888888888888889e-2 * t9 * t16) - 0.49718400000000000000000000000000000000000000000000e1 * t2 * (0.37037037037037037037037037037037037037037037037038e0 / t41 * t18 - 0.35185423664167797878037469661368445571316279662195e2 / t2 / t41 * t33 + 0.82534269228465284250224353195430974693274070904719e3 * t50 * t52 - 0.35087481481481481481481481481481481481481481481482e-2 * t9 * t5) - 0.93222000000000000000000000000000000000000000000000e0 * t2 * r0 * (-0.98765432098765432098765432098765432098765432098764e0 / t61 * t18 + 0.13031638394136221436310173948654979841228251726739e3 / t2 / t61 * t33 - 0.55022846152310189500149568796953983128849380603146e4 / t3 / t61 * t52 + 0.87120096888481155303067204717342446386148136514577e5 / t61 / r0 / t75 + 0.93566617283950617283950617283950617283950617283952e-2 * t9 * t50)

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 + r1
  t2 = t1 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = 0.1e1 / t3
  t7 = 0.1e1 + 0.10555627099250339363411240898410533671394883898658e3 / t2
  t8 = jnp.log(t7)
  t15 = 0.1e1 / t7
  t24 = t1 ** 2
  t30 = t7 ** 2
  d11 = -0.41432000000000000000000000000000000000000000000000e0 * t4 * (0.1e1 - 0.94736200000000000000000000000000000000000000000000e-2 * t8 * t2) - 0.24859200000000000000000000000000000000000000000000e1 * t2 * (0.33333333333333333333333333333333333333333333333334e0 / t1 * t15 - 0.31578733333333333333333333333333333333333333333333e-2 * t8 * t4) - 0.93222000000000000000000000000000000000000000000000e0 * t2 * t1 * (-0.22222222222222222222222222222222222222222222222223e0 / t24 * t15 + 0.11728474554722599292679156553789481857105426554065e2 / t2 / t24 / t30 + 0.21052488888888888888888888888888888888888888888889e-2 * t8 / t3 / t1)
  d12 = d11
  d22 = d12
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = r0 + r1
  t2 = t1 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t5 = 0.1e1 / t3 / t1
  t8 = 0.1e1 + 0.10555627099250339363411240898410533671394883898658e3 / t2
  t9 = jnp.log(t8)
  t15 = 0.1e1 / t3
  t17 = 0.1e1 / t8
  t25 = t1 ** 2
  t31 = t8 ** 2
  t32 = 0.1e1 / t31
  t41 = t25 * t1
  d111 = 0.27621333333333333333333333333333333333333333333333e0 * t5 * (0.1e1 - 0.94736200000000000000000000000000000000000000000000e-2 * t9 * t2) - 0.12429600000000000000000000000000000000000000000000e1 * t15 * (0.33333333333333333333333333333333333333333333333334e0 / t1 * t17 - 0.31578733333333333333333333333333333333333333333333e-2 * t9 * t15) - 0.37288800000000000000000000000000000000000000000000e1 * t2 * (-0.22222222222222222222222222222222222222222222222223e0 / t25 * t17 + 0.11728474554722599292679156553789481857105426554065e2 / t2 / t25 * t32 + 0.21052488888888888888888888888888888888888888888889e-2 * t9 * t5) - 0.93222000000000000000000000000000000000000000000000e0 * t2 * t1 * (0.37037037037037037037037037037037037037037037037038e0 / t41 * t17 - 0.35185423664167797878037469661368445571316279662195e2 / t2 / t41 * t32 + 0.82534269228465284250224353195430974693274070904719e3 / t3 / t41 / t31 / t8 - 0.35087481481481481481481481481481481481481481481482e-2 * t9 / t3 / t25)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = r0 + r1
  t2 = t1 ** 2
  t3 = t1 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t6 = 0.1e1 / t4 / t2
  t9 = 0.1e1 + 0.10555627099250339363411240898410533671394883898658e3 / t3
  t10 = jnp.log(t9)
  t17 = 0.1e1 / t4 / t1
  t19 = 0.1e1 / t9
  t22 = 0.1e1 / t4
  t33 = t9 ** 2
  t34 = 0.1e1 / t33
  t42 = t2 * t1
  t51 = 0.1e1 / t4 / t42
  t53 = 0.1e1 / t33 / t9
  t62 = t2 ** 2
  t76 = t33 ** 2
  d1111 = -0.46035555555555555555555555555555555555555555555555e0 * t6 * (0.1e1 - 0.94736200000000000000000000000000000000000000000000e-2 * t10 * t3) + 0.11048533333333333333333333333333333333333333333333e1 * t17 * (0.33333333333333333333333333333333333333333333333334e0 / t1 * t19 - 0.31578733333333333333333333333333333333333333333333e-2 * t10 * t22) - 0.24859200000000000000000000000000000000000000000000e1 * t22 * (-0.22222222222222222222222222222222222222222222222223e0 / t2 * t19 + 0.11728474554722599292679156553789481857105426554065e2 / t3 / t2 * t34 + 0.21052488888888888888888888888888888888888888888889e-2 * t10 * t17) - 0.49718400000000000000000000000000000000000000000000e1 * t3 * (0.37037037037037037037037037037037037037037037037038e0 / t42 * t19 - 0.35185423664167797878037469661368445571316279662195e2 / t3 / t42 * t34 + 0.82534269228465284250224353195430974693274070904719e3 * t51 * t53 - 0.35087481481481481481481481481481481481481481481482e-2 * t10 * t6) - 0.93222000000000000000000000000000000000000000000000e0 * t3 * t1 * (-0.98765432098765432098765432098765432098765432098764e0 / t62 * t19 + 0.13031638394136221436310173948654979841228251726739e3 / t3 / t62 * t34 - 0.55022846152310189500149568796953983128849380603146e4 / t4 / t62 * t53 + 0.87120096888481155303067204717342446386148136514577e5 / t62 / t1 / t76 + 0.93566617283950617283950617283950617283950617283952e-2 * t10 * t51)

  res = {'v4rho4': d1111}
  return res
