"""Generated from mgga_c_scan.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  beta_a = 0.06672455060314922

  beta_b = 0.1

  beta_c = 0.1778

  scan_alpha = lambda z, xt, ts0, ts1: (f.t_total(z, ts0, ts1) - xt ** 2 / 8) / (K_FACTOR_C * f.t_total(z, 1, 1))

  scan_b1c = 0.0285764

  scan_b2c = 0.0889

  scan_b3c = 0.125541

  scan_chi_infty = 0.12802585262625815

  scan_G_cnst = 2.363

  params_c1 = 0.64

  params_c2 = 1.5

  params_d = 0.7

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  mbeta = lambda rs, t=None: beta_a * (1 + beta_b * rs) / (1 + beta_c * rs)

  scan_eclda0 = lambda rs: -scan_b1c / (1 + scan_b2c * jnp.sqrt(rs) + scan_b3c * rs)

  scan_g_infty = lambda s: 1 / (1 + 4 * scan_chi_infty * s ** 2) ** (1 / 4)

  scan_Gc = lambda z: (1 - scan_G_cnst * (2 ** (1 / 3) - 1) * f.f_zeta(z)) * (1 - z ** 12)

  scan_f_alpha_left0 = lambda a: jnp.exp(-params_c1 * a / (1 - a))

  scan_f_alpha_left_cutoff = -jnp.log(DBL_EPSILON) / (-jnp.log(DBL_EPSILON) + params_c1)

  scan_f_alpha_right0 = lambda a: -params_d * jnp.exp(params_c2 / (1 - a))

  scan_f_alpha_right_cutoff = (-jnp.log(DBL_EPSILON / jnp.abs(params_d)) + params_c2) / -jnp.log(DBL_EPSILON / jnp.abs(params_d))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  scan_H0 = lambda rs, s: scan_b1c * jnp.log(1 + (jnp.exp(-scan_eclda0(rs) / scan_b1c) - 1) * (1 - scan_g_infty(s)))

  scan_f_alpha_left = lambda a: f.my_piecewise3(a > scan_f_alpha_left_cutoff, 0, scan_f_alpha_left0(jnp.minimum(scan_f_alpha_left_cutoff, a)))

  scan_f_alpha_right = lambda a: f.my_piecewise3(a < scan_f_alpha_right_cutoff, 0, scan_f_alpha_right0(jnp.maximum(scan_f_alpha_right_cutoff, a)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  scan_e0 = lambda rs, z, s: (scan_eclda0(rs) + scan_H0(rs, s)) * scan_Gc(z)

  scan_f_alpha = lambda a: f.my_piecewise3(a <= 1, scan_f_alpha_left(a), scan_f_alpha_right(a))

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  scan_e0_g = lambda rs, z, t: (1 + 4 * A(rs, z, t) * t ** 2) ** (-1 / 4)

  f2 = lambda rs, z, t: mbeta(rs, t) * (1 - scan_e0_g(rs, z, t)) / (mgamma * A(rs, z, t))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  scan_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: f_pbe(rs, z, xt, xs0, xs1) + scan_f_alpha(scan_alpha(z, xt, ts0, ts1)) * (+scan_e0(rs, z, X2S * 2 ** (1 / 3) * xt) - f_pbe(rs, z, xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: scan_f(rs, z, xt, xs0, xs1, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  beta_a = 0.06672455060314922

  beta_b = 0.1

  beta_c = 0.1778

  scan_alpha = lambda z, xt, ts0, ts1: (f.t_total(z, ts0, ts1) - xt ** 2 / 8) / (K_FACTOR_C * f.t_total(z, 1, 1))

  scan_b1c = 0.0285764

  scan_b2c = 0.0889

  scan_b3c = 0.125541

  scan_chi_infty = 0.12802585262625815

  scan_G_cnst = 2.363

  params_c1 = 0.64

  params_c2 = 1.5

  params_d = 0.7

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  mbeta = lambda rs, t=None: beta_a * (1 + beta_b * rs) / (1 + beta_c * rs)

  scan_eclda0 = lambda rs: -scan_b1c / (1 + scan_b2c * jnp.sqrt(rs) + scan_b3c * rs)

  scan_g_infty = lambda s: 1 / (1 + 4 * scan_chi_infty * s ** 2) ** (1 / 4)

  scan_Gc = lambda z: (1 - scan_G_cnst * (2 ** (1 / 3) - 1) * f.f_zeta(z)) * (1 - z ** 12)

  scan_f_alpha_left0 = lambda a: jnp.exp(-params_c1 * a / (1 - a))

  scan_f_alpha_left_cutoff = -jnp.log(DBL_EPSILON) / (-jnp.log(DBL_EPSILON) + params_c1)

  scan_f_alpha_right0 = lambda a: -params_d * jnp.exp(params_c2 / (1 - a))

  scan_f_alpha_right_cutoff = (-jnp.log(DBL_EPSILON / jnp.abs(params_d)) + params_c2) / -jnp.log(DBL_EPSILON / jnp.abs(params_d))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  scan_H0 = lambda rs, s: scan_b1c * jnp.log(1 + (jnp.exp(-scan_eclda0(rs) / scan_b1c) - 1) * (1 - scan_g_infty(s)))

  scan_f_alpha_left = lambda a: f.my_piecewise3(a > scan_f_alpha_left_cutoff, 0, scan_f_alpha_left0(jnp.minimum(scan_f_alpha_left_cutoff, a)))

  scan_f_alpha_right = lambda a: f.my_piecewise3(a < scan_f_alpha_right_cutoff, 0, scan_f_alpha_right0(jnp.maximum(scan_f_alpha_right_cutoff, a)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  scan_e0 = lambda rs, z, s: (scan_eclda0(rs) + scan_H0(rs, s)) * scan_Gc(z)

  scan_f_alpha = lambda a: f.my_piecewise3(a <= 1, scan_f_alpha_left(a), scan_f_alpha_right(a))

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  scan_e0_g = lambda rs, z, t: (1 + 4 * A(rs, z, t) * t ** 2) ** (-1 / 4)

  f2 = lambda rs, z, t: mbeta(rs, t) * (1 - scan_e0_g(rs, z, t)) / (mgamma * A(rs, z, t))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  scan_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: f_pbe(rs, z, xt, xs0, xs1) + scan_f_alpha(scan_alpha(z, xt, ts0, ts1)) * (+scan_e0(rs, z, X2S * 2 ** (1 / 3) * xt) - f_pbe(rs, z, xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: scan_f(rs, z, xt, xs0, xs1, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  beta_a = 0.06672455060314922

  beta_b = 0.1

  beta_c = 0.1778

  scan_alpha = lambda z, xt, ts0, ts1: (f.t_total(z, ts0, ts1) - xt ** 2 / 8) / (K_FACTOR_C * f.t_total(z, 1, 1))

  scan_b1c = 0.0285764

  scan_b2c = 0.0889

  scan_b3c = 0.125541

  scan_chi_infty = 0.12802585262625815

  scan_G_cnst = 2.363

  params_c1 = 0.64

  params_c2 = 1.5

  params_d = 0.7

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  mbeta = lambda rs, t=None: beta_a * (1 + beta_b * rs) / (1 + beta_c * rs)

  scan_eclda0 = lambda rs: -scan_b1c / (1 + scan_b2c * jnp.sqrt(rs) + scan_b3c * rs)

  scan_g_infty = lambda s: 1 / (1 + 4 * scan_chi_infty * s ** 2) ** (1 / 4)

  scan_Gc = lambda z: (1 - scan_G_cnst * (2 ** (1 / 3) - 1) * f.f_zeta(z)) * (1 - z ** 12)

  scan_f_alpha_left0 = lambda a: jnp.exp(-params_c1 * a / (1 - a))

  scan_f_alpha_left_cutoff = -jnp.log(DBL_EPSILON) / (-jnp.log(DBL_EPSILON) + params_c1)

  scan_f_alpha_right0 = lambda a: -params_d * jnp.exp(params_c2 / (1 - a))

  scan_f_alpha_right_cutoff = (-jnp.log(DBL_EPSILON / jnp.abs(params_d)) + params_c2) / -jnp.log(DBL_EPSILON / jnp.abs(params_d))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  scan_H0 = lambda rs, s: scan_b1c * jnp.log(1 + (jnp.exp(-scan_eclda0(rs) / scan_b1c) - 1) * (1 - scan_g_infty(s)))

  scan_f_alpha_left = lambda a: f.my_piecewise3(a > scan_f_alpha_left_cutoff, 0, scan_f_alpha_left0(jnp.minimum(scan_f_alpha_left_cutoff, a)))

  scan_f_alpha_right = lambda a: f.my_piecewise3(a < scan_f_alpha_right_cutoff, 0, scan_f_alpha_right0(jnp.maximum(scan_f_alpha_right_cutoff, a)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  scan_e0 = lambda rs, z, s: (scan_eclda0(rs) + scan_H0(rs, s)) * scan_Gc(z)

  scan_f_alpha = lambda a: f.my_piecewise3(a <= 1, scan_f_alpha_left(a), scan_f_alpha_right(a))

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  scan_e0_g = lambda rs, z, t: (1 + 4 * A(rs, z, t) * t ** 2) ** (-1 / 4)

  f2 = lambda rs, z, t: mbeta(rs, t) * (1 - scan_e0_g(rs, z, t)) / (mgamma * A(rs, z, t))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  scan_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: f_pbe(rs, z, xt, xs0, xs1) + scan_f_alpha(scan_alpha(z, xt, ts0, ts1)) * (+scan_e0(rs, z, X2S * 2 ** (1 / 3) * xt) - f_pbe(rs, z, xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: scan_f(rs, z, xt, xs0, xs1, ts0, ts1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t11 = t4 * t6 / t8
  t13 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t11
  t14 = jnp.sqrt(t11)
  t17 = t11 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t8 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.23615562999000000000000000000000000000000000000000e0 * t14 + 0.55770497660000000000000000000000000000000000000000e-1 * t11 + 0.12733196185000000000000000000000000000000000000000e-1 * t17 + 0.76629248290000000000000000000000000000000000000000e-2 * t25
  t29 = 0.1e1 + 0.1e1 / t27
  t30 = jnp.log(t29)
  t31 = t13 * t30
  t32 = r0 - r1
  t33 = t32 ** 2
  t34 = t33 ** 2
  t35 = t7 ** 2
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t38 = t34 * t37
  t39 = 0.1e1 / t7
  t40 = t32 * t39
  t41 = 0.1e1 + t40
  t42 = t41 <= f.p.zeta_threshold
  t43 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t44 = t43 * f.p.zeta_threshold
  t45 = t41 ** (0.1e1 / 0.3e1)
  t47 = f.my_piecewise3(t42, t44, t45 * t41)
  t48 = 0.1e1 - t40
  t49 = t48 <= f.p.zeta_threshold
  t50 = t48 ** (0.1e1 / 0.3e1)
  t52 = f.my_piecewise3(t49, t44, t50 * t48)
  t53 = t47 + t52 - 0.2e1
  t54 = 2 ** (0.1e1 / 0.3e1)
  t57 = 0.1e1 / (0.2e1 * t54 - 0.2e1)
  t58 = t53 * t57
  t60 = 0.3109070e-1 + 0.15971292590000000000000000000000000000000000000000e-2 * t11
  t65 = 0.21948324211500000000000000000000000000000000000000e0 * t14 + 0.48172707847500000000000000000000000000000000000000e-1 * t11 + 0.13082189292500000000000000000000000000000000000000e-1 * t17 + 0.48592432297500000000000000000000000000000000000000e-2 * t25
  t67 = 0.1e1 + 0.1e1 / t65
  t68 = jnp.log(t67)
  t71 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t11
  t76 = 0.17489762330000000000000000000000000000000000000000e0 * t14 + 0.30591463695000000000000000000000000000000000000000e-1 * t11 + 0.37162156485000000000000000000000000000000000000000e-2 * t17 + 0.41939460495000000000000000000000000000000000000000e-2 * t25
  t78 = 0.1e1 + 0.1e1 / t76
  t79 = jnp.log(t78)
  t80 = t71 * t79
  t82 = -t60 * t68 + t31 - 0.58482236226346462072622386637590534819724553404281e0 * t80
  t83 = t58 * t82
  t84 = t38 * t83
  t86 = 0.58482236226346462072622386637590534819724553404281e0 * t58 * t80
  t87 = jnp.log(0.2e1)
  t88 = 0.1e1 - t87
  t89 = jnp.pi ** 2
  t91 = t88 / t89
  t92 = t43 ** 2
  t93 = t45 ** 2
  t94 = f.my_piecewise3(t42, t92, t93)
  t95 = t50 ** 2
  t96 = f.my_piecewise3(t49, t92, t95)
  t98 = t94 / 0.2e1 + t96 / 0.2e1
  t99 = t98 ** 2
  t100 = t99 * t98
  t102 = 0.66724550603149220e-1 + 0.16681137650787305000000000000000000000000000000000e-2 * t11
  t104 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t11
  t105 = 0.1e1 / t104
  t106 = t102 * t105
  t107 = 0.1e1 / t88
  t108 = t106 * t107
  t110 = (-t31 + t84 + t86) * t107
  t111 = 0.1e1 / t100
  t112 = t89 * t111
  t114 = jnp.exp(-t110 * t112)
  t115 = t114 - 0.1e1
  t116 = 0.1e1 / t115
  t119 = s0 + 0.2e1 * s1 + s2
  t121 = t108 * t89 * t116 * t119
  t123 = 0.1e1 / t8 / t35
  t124 = t123 * t54
  t125 = 0.1e1 / t99
  t127 = 0.1e1 / t3
  t128 = t19 * t127
  t129 = t128 * t5
  t133 = 0.1e1 + t121 * t124 * t125 * t129 / 0.24e2
  t134 = t133 ** (0.1e1 / 0.4e1)
  t136 = 0.1e1 - 0.1e1 / t134
  t138 = t136 * t115 + 0.1e1
  t139 = jnp.log(t138)
  t141 = t91 * t100 * t139
  t142 = r0 ** (0.1e1 / 0.3e1)
  t143 = t142 ** 2
  t145 = 0.1e1 / t143 / r0
  t146 = tau0 * t145
  t147 = t41 / 0.2e1
  t148 = t147 ** (0.1e1 / 0.3e1)
  t149 = t148 ** 2
  t150 = t149 * t147
  t152 = r1 ** (0.1e1 / 0.3e1)
  t153 = t152 ** 2
  t155 = 0.1e1 / t153 / r1
  t156 = tau1 * t155
  t157 = t48 / 0.2e1
  t158 = t157 ** (0.1e1 / 0.3e1)
  t159 = t158 ** 2
  t160 = t159 * t157
  t163 = 0.1e1 / t22 / t35
  t167 = 6 ** (0.1e1 / 0.3e1)
  t168 = (t146 * t150 + t156 * t160 - t119 * t163 / 0.8e1) * t167
  t169 = t89 ** (0.1e1 / 0.3e1)
  t170 = t169 ** 2
  t171 = 0.1e1 / t170
  t172 = t150 + t160
  t173 = 0.1e1 / t172
  t174 = t171 * t173
  t176 = 0.5e1 / 0.9e1 * t168 * t174
  t177 = t176 <= 0.1e1
  t178 = jnp.log(DBL_EPSILON)
  t181 = t178 / (-t178 + 0.64e0)
  t182 = -t181 < t176
  t183 = t176 < -t181
  t184 = f.my_piecewise3(t183, t176, -t181)
  t185 = 0.1e1 - t184
  t186 = 0.1e1 / t185
  t189 = jnp.exp(-0.64e0 * t184 * t186)
  t190 = f.my_piecewise3(t182, 0, t189)
  t192 = jnp.log(0.14285714285714285714285714285714285714285714285714e1 * DBL_EPSILON)
  t195 = (-t192 + 0.15e1) / t192
  t196 = t176 < -t195
  t197 = f.my_piecewise3(t196, -t195, t176)
  t198 = 0.1e1 - t197
  t201 = jnp.exp(0.15e1 / t198)
  t203 = f.my_piecewise3(t196, 0, -0.7e0 * t201)
  t204 = f.my_piecewise3(t177, t190, t203)
  t207 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t14 + 0.31385250000000000000000000000000000000000000000000e-1 * t11
  t208 = 0.1e1 / t207
  t211 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t208)
  t212 = t211 - 0.1e1
  t213 = t167 * t171
  t214 = t54 ** 2
  t219 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t213 * t214 * t119 * t163
  t220 = t219 ** (0.1e1 / 0.4e1)
  t222 = 0.1e1 - 0.1e1 / t220
  t224 = t212 * t222 + 0.1e1
  t225 = jnp.log(t224)
  t227 = -0.285764e-1 * t208 + 0.285764e-1 * t225
  t229 = 0.2363e1 * t54 - 0.2363e1
  t232 = -t229 * t53 * t57 + 0.1e1
  t233 = t227 * t232
  t234 = t34 ** 2
  t235 = t234 * t34
  t236 = t36 ** 2
  t238 = 0.1e1 / t236 / t36
  t240 = -t235 * t238 + 0.1e1
  t242 = t233 * t240 - t141 + t31 - t84 - t86
  t243 = t204 * t242
  t245 = 0.1e1 / t8 / t7
  t246 = t6 * t245
  t249 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t246 * t30
  t250 = t27 ** 2
  t255 = t3 * t6
  t256 = t255 * t245
  t257 = 0.1e1 / t14 * t1 * t256
  t259 = t4 * t246
  t261 = t11 ** 0.5e0
  t263 = t261 * t1 * t256
  t268 = t21 * t5 / t22 / t7
  t273 = t13 / t250 * (-0.39359271665000000000000000000000000000000000000000e-1 * t257 - 0.18590165886666666666666666666666666666666666666667e-1 * t259 - 0.63665980925000000000000000000000000000000000000000e-2 * t263 - 0.51086165526666666666666666666666666666666666666667e-2 * t268) / t29
  t274 = t33 * t32
  t277 = 0.4e1 * t274 * t37 * t83
  t278 = t36 * t7
  t282 = 0.4e1 * t34 / t278 * t83
  t284 = t32 / t35
  t285 = t39 - t284
  t288 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t285)
  t289 = -t285
  t292 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t289)
  t294 = (t288 + t292) * t57
  t296 = t38 * t294 * t82
  t300 = t65 ** 2
  t314 = t76 ** 2
  t315 = 0.1e1 / t314
  t321 = -0.29149603883333333333333333333333333333333333333333e-1 * t257 - 0.10197154565000000000000000000000000000000000000000e-1 * t259 - 0.18581078242500000000000000000000000000000000000000e-2 * t263 - 0.27959640330000000000000000000000000000000000000000e-2 * t268
  t322 = 0.1e1 / t78
  t328 = t38 * t58 * (0.53237641966666666666666666666666666666666666666667e-3 * t4 * t246 * t68 + t60 / t300 * (-0.36580540352500000000000000000000000000000000000000e-1 * t257 - 0.16057569282500000000000000000000000000000000000000e-1 * t259 - 0.65410946462500000000000000000000000000000000000000e-2 * t263 - 0.32394954865000000000000000000000000000000000000000e-2 * t268) / t67 - t249 - t273 + 0.18311447306006545054854346104378990962041954983034e-3 * t4 * t246 * t79 + 0.58482236226346462072622386637590534819724553404281e0 * t71 * t315 * t321 * t322)
  t330 = 0.58482236226346462072622386637590534819724553404281e0 * t294 * t80
  t335 = 0.18311447306006545054854346104378990962041954983034e-3 * t58 * t1 * t255 * t245 * t79
  t340 = 0.58482236226346462072622386637590534819724553404281e0 * t58 * t71 * t315 * t321 * t322
  t341 = t99 * t139
  t342 = 0.1e1 / t45
  t345 = f.my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t342 * t285)
  t346 = 0.1e1 / t50
  t349 = f.my_piecewise3(t49, 0, 0.2e1 / 0.3e1 * t346 * t289)
  t351 = t345 / 0.2e1 + t349 / 0.2e1
  t354 = 0.3e1 * t91 * t341 * t351
  t356 = 0.1e1 / t134 / t133
  t357 = t35 * t7
  t359 = 0.1e1 / t22 / t357
  t361 = t107 * t89
  t363 = t116 * t119
  t364 = t54 * t125
  t367 = 0.27801896084645508333333333333333333333333333333333e-3 * t359 * t105 * t361 * t363 * t364
  t368 = t104 ** 2
  t376 = 0.74083333333333333333333333333333333333333333333333e-2 * t102 / t368 * t361 * t363 * t359 * t54 * t125
  t377 = t115 ** 2
  t382 = t108 * t89 / t377 * t119 * t123
  t383 = t364 * t19
  t384 = t127 * t5
  t388 = t99 ** 2
  t390 = t89 / t388
  t394 = -(t249 + t273 + t277 - t282 + t296 + t328 + t330 - t335 - t340) * t107 * t112 + 0.3e1 * t110 * t390 * t351
  t406 = 0.7e1 / 0.72e2 * t121 / t8 / t357 * t54 * t125 * t129
  t407 = t124 * t111
  t421 = 0.1e1 / t138
  t423 = t91 * t100 * (t356 * (-t367 + t376 - t382 * t383 * t384 * t394 * t114 / 0.24e2 - t406 - t121 * t407 * t128 * t5 * t351 / 0.12e2) * t115 / 0.4e1 + t136 * t394 * t114) * t421
  t424 = r0 ** 2
  t430 = t285 / 0.2e1
  t431 = t149 * t430
  t435 = -t159 * t430
  t438 = t119 * t359
  t439 = t438 / 0.3e1
  t443 = t172 ** 2
  t445 = t171 / t443
  t451 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau0 / t143 / t424 * t150 + 0.5e1 / 0.3e1 * t146 * t431 + 0.5e1 / 0.3e1 * t156 * t435 + t439) * t167 * t174 - 0.5e1 / 0.9e1 * t168 * t445 * (0.5e1 / 0.3e1 * t431 + 0.5e1 / 0.3e1 * t435)
  t452 = f.my_piecewise3(t183, t451, 0)
  t455 = t185 ** 2
  t457 = t184 / t455
  t462 = f.my_piecewise3(t182, 0, (-0.64e0 * t452 * t186 - 0.64e0 * t457 * t452) * t189)
  t463 = t198 ** 2
  t464 = 0.1e1 / t463
  t465 = f.my_piecewise3(t196, 0, t451)
  t469 = f.my_piecewise3(t196, 0, -0.105e1 * t464 * t465 * t201)
  t470 = f.my_piecewise3(t177, t462, t469)
  t472 = t207 ** 2
  t477 = 0.1e1 / t472 * (-0.74083333333333333333333333333333333333333333333333e-2 * t257 - 0.10461750000000000000000000000000000000000000000000e-1 * t259)
  t484 = t212 / t220 / t219
  t491 = 0.1e1 / t224
  t496 = (0.285764e-1 * t477 + 0.285764e-1 * (-0.10000000000000000000000000000000000000000000000000e1 * t477 * t211 * t222 - 0.14225094736250905555555555555555555555555555555555e-1 * t484 * t167 * t171 * t214 * t438) * t491) * t232 * t240
  t497 = t227 * t229
  t501 = t234 * t274 * t238
  t504 = t235 / t236 / t278
  t508 = t496 - t497 * t294 * t240 + t233 * (-0.12e2 * t501 + 0.12e2 * t504) - t249 - t273 - t277 + t282 - t296 - t328 - t330 + t335 + t340 - t354 - t423
  t510 = t204 * t508 + t470 * t242 + t249 + t273 + t277 - t282 + t296 + t328 + t330 - t335 - t340 + t354 + t423
  vrho_0_ = t7 * t510 + t141 + t243 - t31 + t84 + t86
  t512 = -t39 - t284
  t515 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t512)
  t516 = -t512
  t519 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t516)
  t521 = (t515 + t519) * t57
  t523 = t38 * t521 * t82
  t525 = 0.58482236226346462072622386637590534819724553404281e0 * t521 * t80
  t528 = f.my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t342 * t512)
  t531 = f.my_piecewise3(t49, 0, 0.2e1 / 0.3e1 * t346 * t516)
  t533 = t528 / 0.2e1 + t531 / 0.2e1
  t536 = 0.3e1 * t91 * t341 * t533
  t543 = -(t249 + t273 - t277 - t282 + t523 + t328 + t525 - t335 - t340) * t107 * t112 + 0.3e1 * t110 * t390 * t533
  t563 = t91 * t100 * (t356 * (-t367 + t376 - t382 * t383 * t384 * t543 * t114 / 0.24e2 - t406 - t121 * t407 * t128 * t5 * t533 / 0.12e2) * t115 / 0.4e1 + t136 * t543 * t114) * t421
  t564 = t512 / 0.2e1
  t565 = t149 * t564
  t568 = r1 ** 2
  t575 = -t159 * t564
  t586 = 0.5e1 / 0.9e1 * (0.5e1 / 0.3e1 * t146 * t565 - 0.5e1 / 0.3e1 * tau1 / t153 / t568 * t160 + 0.5e1 / 0.3e1 * t156 * t575 + t439) * t167 * t174 - 0.5e1 / 0.9e1 * t168 * t445 * (0.5e1 / 0.3e1 * t565 + 0.5e1 / 0.3e1 * t575)
  t587 = f.my_piecewise3(t183, t586, 0)
  t594 = f.my_piecewise3(t182, 0, (-0.64e0 * t587 * t186 - 0.64e0 * t457 * t587) * t189)
  t595 = f.my_piecewise3(t196, 0, t586)
  t599 = f.my_piecewise3(t196, 0, -0.105e1 * t464 * t595 * t201)
  t600 = f.my_piecewise3(t177, t594, t599)
  t607 = t496 - t497 * t521 * t240 + t233 * (0.12e2 * t501 + 0.12e2 * t504) - t249 - t273 + t277 + t282 - t523 - t328 - t525 + t335 + t340 - t536 - t563
  t609 = t204 * t607 + t600 * t242 + t249 + t273 - t277 - t282 + t328 - t335 - t340 + t523 + t525 + t536 + t563
  vrho_1_ = t7 * t609 + t141 + t243 - t31 + t84 + t86
  t617 = t98 * t356 * t106 * t123 * t54 * t19 * t384 * t421
  t618 = t617 / 0.96e2
  t620 = t163 * t167 * t174
  t621 = 0.5e1 / 0.72e2 * t620
  t622 = f.my_piecewise3(t183, -t621, 0)
  t629 = f.my_piecewise3(t182, 0, (-0.64e0 * t622 * t186 - 0.64e0 * t457 * t622) * t189)
  t630 = f.my_piecewise3(t196, 0, -t621)
  t634 = f.my_piecewise3(t196, 0, -0.105e1 * t464 * t630 * t201)
  t635 = f.my_piecewise3(t177, t629, t634)
  t642 = t484 * t213 * t214 * t163 * t491 * t232 * t240
  vsigma_0_ = t7 * (t618 + t635 * t242 + t204 * (0.15243824895787514156916666666666666666666666666666e-3 * t642 - t618))
  t647 = t617 / 0.48e2
  t648 = 0.5e1 / 0.36e2 * t620
  t649 = f.my_piecewise3(t183, -t648, 0)
  t656 = f.my_piecewise3(t182, 0, (-0.64e0 * t649 * t186 - 0.64e0 * t457 * t649) * t189)
  t657 = f.my_piecewise3(t196, 0, -t648)
  t661 = f.my_piecewise3(t196, 0, -0.105e1 * t464 * t657 * t201)
  t662 = f.my_piecewise3(t177, t656, t661)
  vsigma_1_ = t7 * (t647 + t662 * t242 + t204 * (0.30487649791575028313833333333333333333333333333331e-3 * t642 - t647))
  vsigma_2_ = vsigma_0_
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t669 = t213 * t173
  t671 = 0.5e1 / 0.9e1 * t145 * t150 * t669
  t672 = f.my_piecewise3(t183, t671, 0)
  t679 = f.my_piecewise3(t182, 0, (-0.64e0 * t672 * t186 - 0.64e0 * t457 * t672) * t189)
  t680 = f.my_piecewise3(t196, 0, t671)
  t684 = f.my_piecewise3(t196, 0, -0.105e1 * t464 * t680 * t201)
  t685 = f.my_piecewise3(t177, t679, t684)
  vtau_0_ = t7 * t685 * t242
  t689 = 0.5e1 / 0.9e1 * t155 * t160 * t669
  t690 = f.my_piecewise3(t183, t689, 0)
  t697 = f.my_piecewise3(t182, 0, (-0.64e0 * t690 * t186 - 0.64e0 * t457 * t690) * t189)
  t698 = f.my_piecewise3(t196, 0, t689)
  t702 = f.my_piecewise3(t196, 0, -0.105e1 * t464 * t698 * t201)
  t703 = f.my_piecewise3(t177, t697, t702)
  vtau_1_ = t7 * t703 * t242
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  beta_a = 0.06672455060314922

  beta_b = 0.1

  beta_c = 0.1778

  scan_alpha = lambda z, xt, ts0, ts1: (f.t_total(z, ts0, ts1) - xt ** 2 / 8) / (K_FACTOR_C * f.t_total(z, 1, 1))

  scan_b1c = 0.0285764

  scan_b2c = 0.0889

  scan_b3c = 0.125541

  scan_chi_infty = 0.12802585262625815

  scan_G_cnst = 2.363

  params_c1 = 0.64

  params_c2 = 1.5

  params_d = 0.7

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  mbeta = lambda rs, t=None: beta_a * (1 + beta_b * rs) / (1 + beta_c * rs)

  scan_eclda0 = lambda rs: -scan_b1c / (1 + scan_b2c * jnp.sqrt(rs) + scan_b3c * rs)

  scan_g_infty = lambda s: 1 / (1 + 4 * scan_chi_infty * s ** 2) ** (1 / 4)

  scan_Gc = lambda z: (1 - scan_G_cnst * (2 ** (1 / 3) - 1) * f.f_zeta(z)) * (1 - z ** 12)

  scan_f_alpha_left0 = lambda a: jnp.exp(-params_c1 * a / (1 - a))

  scan_f_alpha_left_cutoff = -jnp.log(DBL_EPSILON) / (-jnp.log(DBL_EPSILON) + params_c1)

  scan_f_alpha_right0 = lambda a: -params_d * jnp.exp(params_c2 / (1 - a))

  scan_f_alpha_right_cutoff = (-jnp.log(DBL_EPSILON / jnp.abs(params_d)) + params_c2) / -jnp.log(DBL_EPSILON / jnp.abs(params_d))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  scan_H0 = lambda rs, s: scan_b1c * jnp.log(1 + (jnp.exp(-scan_eclda0(rs) / scan_b1c) - 1) * (1 - scan_g_infty(s)))

  scan_f_alpha_left = lambda a: f.my_piecewise3(a > scan_f_alpha_left_cutoff, 0, scan_f_alpha_left0(jnp.minimum(scan_f_alpha_left_cutoff, a)))

  scan_f_alpha_right = lambda a: f.my_piecewise3(a < scan_f_alpha_right_cutoff, 0, scan_f_alpha_right0(jnp.maximum(scan_f_alpha_right_cutoff, a)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  scan_e0 = lambda rs, z, s: (scan_eclda0(rs) + scan_H0(rs, s)) * scan_Gc(z)

  scan_f_alpha = lambda a: f.my_piecewise3(a <= 1, scan_f_alpha_left(a), scan_f_alpha_right(a))

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  scan_e0_g = lambda rs, z, t: (1 + 4 * A(rs, z, t) * t ** 2) ** (-1 / 4)

  f2 = lambda rs, z, t: mbeta(rs, t) * (1 - scan_e0_g(rs, z, t)) / (mgamma * A(rs, z, t))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  scan_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: f_pbe(rs, z, xt, xs0, xs1) + scan_f_alpha(scan_alpha(z, xt, ts0, ts1)) * (+scan_e0(rs, z, X2S * 2 ** (1 / 3) * xt) - f_pbe(rs, z, xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: scan_f(rs, z, xt, xs0, xs1, ts0, ts1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t10 = t4 * t6 / t7
  t12 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t24 = t20 * t5 / t21
  t26 = 0.23615562999000000000000000000000000000000000000000e0 * t13 + 0.55770497660000000000000000000000000000000000000000e-1 * t10 + 0.12733196185000000000000000000000000000000000000000e-1 * t16 + 0.76629248290000000000000000000000000000000000000000e-2 * t24
  t28 = 0.1e1 + 0.1e1 / t26
  t29 = jnp.log(t28)
  t30 = t12 * t29
  t31 = 0.1e1 <= f.p.zeta_threshold
  t32 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t34 = f.my_piecewise3(t31, t32 * f.p.zeta_threshold, 1)
  t36 = 0.2e1 * t34 - 0.2e1
  t37 = 2 ** (0.1e1 / 0.3e1)
  t40 = 0.1e1 / (0.2e1 * t37 - 0.2e1)
  t41 = t36 * t40
  t43 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t10
  t48 = 0.17489762330000000000000000000000000000000000000000e0 * t13 + 0.30591463695000000000000000000000000000000000000000e-1 * t10 + 0.37162156485000000000000000000000000000000000000000e-2 * t16 + 0.41939460495000000000000000000000000000000000000000e-2 * t24
  t50 = 0.1e1 + 0.1e1 / t48
  t51 = jnp.log(t50)
  t54 = 0.58482236226346462072622386637590534819724553404281e0 * t41 * t43 * t51
  t55 = jnp.log(0.2e1)
  t56 = 0.1e1 - t55
  t57 = jnp.pi ** 2
  t59 = t56 / t57
  t60 = t32 ** 2
  t61 = f.my_piecewise3(t31, t60, 1)
  t62 = t61 ** 2
  t63 = t62 * t61
  t65 = 0.66724550603149220e-1 + 0.16681137650787305000000000000000000000000000000000e-2 * t10
  t67 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t10
  t68 = 0.1e1 / t67
  t69 = t65 * t68
  t70 = 0.1e1 / t56
  t75 = t57 / t63
  t77 = jnp.exp(-(-t30 + t54) * t70 * t75)
  t78 = t77 - 0.1e1
  t79 = 0.1e1 / t78
  t82 = t69 * t70 * t57 * t79 * s0
  t83 = r0 ** 2
  t85 = 0.1e1 / t7 / t83
  t87 = 0.1e1 / t62
  t89 = 0.1e1 / t3
  t91 = t18 * t89 * t5
  t95 = 0.1e1 + t82 * t85 * t37 * t87 * t91 / 0.24e2
  t96 = t95 ** (0.1e1 / 0.4e1)
  t98 = 0.1e1 - 0.1e1 / t96
  t100 = t98 * t78 + 0.1e1
  t101 = jnp.log(t100)
  t103 = t59 * t63 * t101
  t105 = 0.1e1 / t21 / r0
  t108 = 0.1e1 / t21 / t83
  t112 = 6 ** (0.1e1 / 0.3e1)
  t114 = t57 ** (0.1e1 / 0.3e1)
  t115 = t114 ** 2
  t116 = 0.1e1 / t115
  t117 = t37 ** 2
  t118 = t116 * t117
  t120 = 0.5e1 / 0.9e1 * (tau0 * t105 - s0 * t108 / 0.8e1) * t112 * t118
  t121 = t120 <= 0.1e1
  t122 = jnp.log(DBL_EPSILON)
  t125 = t122 / (-t122 + 0.64e0)
  t126 = -t125 < t120
  t127 = t120 < -t125
  t128 = f.my_piecewise3(t127, t120, -t125)
  t129 = 0.1e1 - t128
  t130 = 0.1e1 / t129
  t133 = jnp.exp(-0.64e0 * t128 * t130)
  t134 = f.my_piecewise3(t126, 0, t133)
  t136 = jnp.log(0.14285714285714285714285714285714285714285714285714e1 * DBL_EPSILON)
  t139 = (-t136 + 0.15e1) / t136
  t140 = t120 < -t139
  t141 = f.my_piecewise3(t140, -t139, t120)
  t142 = 0.1e1 - t141
  t145 = jnp.exp(0.15e1 / t142)
  t147 = f.my_piecewise3(t140, 0, -0.7e0 * t145)
  t148 = f.my_piecewise3(t121, t134, t147)
  t151 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t13 + 0.31385250000000000000000000000000000000000000000000e-1 * t10
  t152 = 0.1e1 / t151
  t155 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t152)
  t156 = t155 - 0.1e1
  t162 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t112 * t116 * t117 * s0 * t108
  t163 = t162 ** (0.1e1 / 0.4e1)
  t165 = 0.1e1 - 0.1e1 / t163
  t167 = t156 * t165 + 0.1e1
  t168 = jnp.log(t167)
  t175 = 0.1e1 - (0.2363e1 * t37 - 0.2363e1) * t36 * t40
  t177 = (-0.285764e-1 * t152 + 0.285764e-1 * t168) * t175 + t30 - t54 - t103
  t180 = 0.1e1 / t7 / r0
  t181 = t6 * t180
  t184 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t181 * t29
  t185 = t26 ** 2
  t190 = t3 * t6
  t191 = t190 * t180
  t192 = 0.1e1 / t13 * t1 * t191
  t194 = t4 * t181
  t196 = t10 ** 0.5e0
  t198 = t196 * t1 * t191
  t201 = t20 * t5 * t105
  t206 = t12 / t185 * (-0.39359271665000000000000000000000000000000000000000e-1 * t192 - 0.18590165886666666666666666666666666666666666666667e-1 * t194 - 0.63665980925000000000000000000000000000000000000000e-2 * t198 - 0.51086165526666666666666666666666666666666666666667e-2 * t201) / t28
  t211 = 0.18311447306006545054854346104378990962041954983034e-3 * t41 * t1 * t190 * t180 * t51
  t213 = t48 ** 2
  t224 = 0.58482236226346462072622386637590534819724553404281e0 * t41 * t43 / t213 * (-0.29149603883333333333333333333333333333333333333333e-1 * t192 - 0.10197154565000000000000000000000000000000000000000e-1 * t194 - 0.18581078242500000000000000000000000000000000000000e-2 * t198 - 0.27959640330000000000000000000000000000000000000000e-2 * t201) / t50
  t226 = 0.1e1 / t96 / t95
  t227 = t83 * r0
  t229 = 0.1e1 / t21 / t227
  t231 = t70 * t57
  t233 = t79 * s0
  t238 = t67 ** 2
  t247 = t56 ** 2
  t250 = t57 ** 2
  t251 = t78 ** 2
  t257 = t62 ** 2
  t262 = t89 * t5
  t263 = t184 + t206 - t211 - t224
  t286 = 0.1e1 / t100
  t288 = t59 * t63 * (t226 * (-0.27801896084645508333333333333333333333333333333333e-3 * t229 * t68 * t231 * t233 * t37 * t87 + 0.74083333333333333333333333333333333333333333333333e-2 * t65 / t238 * t231 * t233 * t229 * t37 * t87 + t69 / t247 * t250 / t251 * s0 * t85 * t37 / t257 / t61 * t18 * t262 * t263 * t77 / 0.24e2 - 0.7e1 / 0.72e2 * t82 / t7 / t227 * t37 * t87 * t91) * t78 / 0.4e1 - t98 * t263 * t70 * t75 * t77) * t286
  t291 = s0 * t229
  t296 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau0 * t108 + t291 / 0.3e1) * t112 * t118
  t297 = f.my_piecewise3(t127, t296, 0)
  t300 = t129 ** 2
  t302 = t128 / t300
  t307 = f.my_piecewise3(t126, 0, (-0.64e0 * t297 * t130 - 0.64e0 * t302 * t297) * t133)
  t308 = t142 ** 2
  t309 = 0.1e1 / t308
  t310 = f.my_piecewise3(t140, 0, t296)
  t314 = f.my_piecewise3(t140, 0, -0.105e1 * t309 * t310 * t145)
  t315 = f.my_piecewise3(t121, t307, t314)
  t317 = t151 ** 2
  t322 = 0.1e1 / t317 * (-0.74083333333333333333333333333333333333333333333333e-2 * t192 - 0.10461750000000000000000000000000000000000000000000e-1 * t194)
  t329 = t156 / t163 / t162
  t335 = 0.1e1 / t167
  vrho_0_ = -t30 + t54 + t103 + t148 * t177 + r0 * (t184 + t206 - t211 - t224 + t288 + t315 * t177 + t148 * ((0.285764e-1 * t322 + 0.285764e-1 * (-0.10000000000000000000000000000000000000000000000000e1 * t322 * t155 * t165 - 0.14225094736250905555555555555555555555555555555555e-1 * t329 * t112 * t118 * t291) * t335) * t175 - t184 - t206 + t211 + t224 - t288))
  t351 = t61 * t226 * t69 * t85 * t37 * t18 * t262 * t286 / 0.96e2
  t352 = t108 * t112
  t354 = 0.5e1 / 0.72e2 * t352 * t118
  t355 = f.my_piecewise3(t127, -t354, 0)
  t362 = f.my_piecewise3(t126, 0, (-0.64e0 * t355 * t130 - 0.64e0 * t302 * t355) * t133)
  t363 = f.my_piecewise3(t140, 0, -t354)
  t367 = f.my_piecewise3(t140, 0, -0.105e1 * t309 * t363 * t145)
  t368 = f.my_piecewise3(t121, t362, t367)
  vsigma_0_ = r0 * (t351 + t368 * t177 + t148 * (0.15243824895787514156916666666666666666666666666666e-3 * t329 * t352 * t118 * t335 * t175 - t351))
  vlapl_0_ = 0.0e0
  t380 = 0.5e1 / 0.9e1 * t105 * t112 * t118
  t381 = f.my_piecewise3(t127, t380, 0)
  t388 = f.my_piecewise3(t126, 0, (-0.64e0 * t381 * t130 - 0.64e0 * t302 * t381) * t133)
  t389 = f.my_piecewise3(t140, 0, t380)
  t393 = f.my_piecewise3(t140, 0, -0.105e1 * t309 * t389 * t145)
  t394 = f.my_piecewise3(t121, t388, t393)
  vtau_0_ = r0 * t394 * t177
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t7 / r0
  t10 = t6 * t9
  t13 = t4 * t6 / t7
  t14 = jnp.sqrt(t13)
  t17 = t13 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t7 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.37978500000000000000000000000000000000000000000000e1 * t14 + 0.89690000000000000000000000000000000000000000000000e0 * t13 + 0.20477500000000000000000000000000000000000000000000e0 * t17 + 0.12323500000000000000000000000000000000000000000000e0 * t25
  t30 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t27
  t31 = jnp.log(t30)
  t33 = t4 * t10 * t31
  t36 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t13
  t37 = t27 ** 2
  t38 = 0.1e1 / t37
  t39 = t36 * t38
  t41 = 0.1e1 / t14 * t1
  t42 = t3 * t6
  t43 = t42 * t9
  t44 = t41 * t43
  t46 = t4 * t10
  t48 = t13 ** 0.5e0
  t49 = t48 * t1
  t50 = t49 * t43
  t53 = 0.1e1 / t22 / r0
  t55 = t21 * t5 * t53
  t57 = -0.63297500000000000000000000000000000000000000000000e0 * t44 - 0.29896666666666666666666666666666666666666666666667e0 * t46 - 0.10238750000000000000000000000000000000000000000000e0 * t50 - 0.82156666666666666666666666666666666666666666666667e-1 * t55
  t58 = 0.1e1 / t30
  t59 = t57 * t58
  t60 = t39 * t59
  t62 = 0.1e1 <= f.p.zeta_threshold
  t63 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t65 = f.my_piecewise3(t62, t63 * f.p.zeta_threshold, 1)
  t67 = 0.2e1 * t65 - 0.2e1
  t68 = 2 ** (0.1e1 / 0.3e1)
  t69 = t68 - 0.1e1
  t71 = 0.1e1 / t69 / 0.2e1
  t72 = t67 * t71
  t73 = t72 * t1
  t78 = 0.51785000000000000000000000000000000000000000000000e1 * t14 + 0.90577500000000000000000000000000000000000000000000e0 * t13 + 0.11003250000000000000000000000000000000000000000000e0 * t17 + 0.12417750000000000000000000000000000000000000000000e0 * t25
  t81 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t78
  t82 = jnp.log(t81)
  t85 = t73 * t42 * t9 * t82
  t88 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t13
  t89 = t72 * t88
  t90 = t78 ** 2
  t91 = 0.1e1 / t90
  t96 = -0.86308333333333333333333333333333333333333333333334e0 * t44 - 0.30192500000000000000000000000000000000000000000000e0 * t46 - 0.55016250000000000000000000000000000000000000000000e-1 * t50 - 0.82785000000000000000000000000000000000000000000000e-1 * t55
  t98 = 0.1e1 / t81
  t99 = t91 * t96 * t98
  t100 = t89 * t99
  t102 = jnp.log(0.2e1)
  t103 = 0.1e1 - t102
  t104 = jnp.pi ** 2
  t106 = t103 / t104
  t107 = t63 ** 2
  t108 = f.my_piecewise3(t62, t107, 1)
  t109 = t108 ** 2
  t110 = t109 * t108
  t112 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e-1 * t13
  t114 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t13
  t115 = 0.1e1 / t114
  t116 = t112 * t115
  t117 = 0.1e1 / t103
  t120 = 0.621814e-1 * t36 * t31
  t123 = 0.19751673498613801407483339618206552048944131217655e-1 * t72 * t88 * t82
  t126 = 0.1e1 / t110
  t127 = t104 * t126
  t129 = jnp.exp(-(-t120 + t123) * t117 * t127)
  t130 = t129 - 0.1e1
  t131 = 0.1e1 / t130
  t133 = t104 * t131 * s0
  t134 = t116 * t117 * t133
  t135 = r0 ** 2
  t137 = 0.1e1 / t7 / t135
  t139 = 0.1e1 / t109
  t141 = 0.1e1 / t3
  t143 = t19 * t141 * t5
  t147 = 0.1e1 + 0.27801896084645508333333333333333333333333333333333e-2 * t134 * t137 * t68 * t139 * t143
  t148 = t147 ** (0.1e1 / 0.4e1)
  t150 = 0.1e1 / t148 / t147
  t151 = t135 * r0
  t153 = 0.1e1 / t22 / t151
  t154 = t153 * t115
  t155 = t117 * t104
  t157 = t131 * s0
  t159 = t157 * t68 * t139
  t162 = t114 ** 2
  t163 = 0.1e1 / t162
  t164 = t112 * t163
  t165 = t164 * t155
  t171 = t103 ** 2
  t172 = 0.1e1 / t171
  t173 = t116 * t172
  t174 = t104 ** 2
  t175 = t130 ** 2
  t176 = 0.1e1 / t175
  t177 = t174 * t176
  t178 = s0 * t137
  t180 = t173 * t177 * t178
  t181 = t109 ** 2
  t183 = 0.1e1 / t181 / t108
  t185 = t68 * t183 * t19
  t186 = t141 * t5
  t187 = 0.11073470983333333333333333333333333333333333333333e-2 * t33
  t188 = 0.10000000000000000000000000000000000000000000000000e1 * t60
  t189 = 0.18311447306006545054854346104378990962041954983034e-3 * t85
  t190 = 0.58482236226346462072622386637590534819724553404280e0 * t100
  t191 = t187 + t188 - t189 - t190
  t194 = t185 * t186 * t191 * t129
  t198 = 0.1e1 / t7 / t151
  t204 = -0.27801896084645508333333333333333333333333333333333e-3 * t154 * t155 * t159 + 0.49431771238499713816666666666666666666666666666666e-3 * t165 * t157 * t153 * t68 * t139 + 0.27801896084645508333333333333333333333333333333333e-2 * t180 * t194 - 0.64871090864172852777777777777777777777777777777777e-2 * t134 * t198 * t68 * t139 * t143
  t205 = t150 * t204
  t209 = 0.1e1 - 0.1e1 / t148
  t212 = t127 * t129
  t215 = 0.25000000000000000000000000000000000000000000000000e0 * t205 * t130 - 0.10000000000000000000000000000000000000000000000000e1 * t209 * t191 * t117 * t212
  t219 = 0.1e1 + 0.10000000000000000000000000000000000000000000000000e1 * t209 * t130
  t220 = 0.1e1 / t219
  t222 = t106 * t110 * t215 * t220
  t226 = 0.1e1 / t22 / t135
  t230 = 6 ** (0.1e1 / 0.3e1)
  t232 = t104 ** (0.1e1 / 0.3e1)
  t233 = t232 ** 2
  t234 = 0.1e1 / t233
  t235 = t68 ** 2
  t236 = t234 * t235
  t238 = 0.5e1 / 0.9e1 * (tau0 * t53 - s0 * t226 / 0.8e1) * t230 * t236
  t239 = t238 <= 0.1e1
  t240 = jnp.log(DBL_EPSILON)
  t243 = t240 / (-t240 + 0.64e0)
  t244 = -t243 < t238
  t245 = t238 < -t243
  t248 = s0 * t153
  t253 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau0 * t226 + t248 / 0.3e1) * t230 * t236
  t254 = f.my_piecewise3(t245, t253, 0)
  t255 = f.my_piecewise3(t245, t238, -t243)
  t256 = 0.1e1 - t255
  t257 = 0.1e1 / t256
  t260 = t256 ** 2
  t261 = 0.1e1 / t260
  t262 = t255 * t261
  t265 = -0.64e0 * t254 * t257 - 0.64e0 * t262 * t254
  t268 = jnp.exp(-0.64e0 * t255 * t257)
  t270 = f.my_piecewise3(t244, 0, t265 * t268)
  t272 = jnp.log(0.14285714285714285714285714285714285714285714285714e1 * DBL_EPSILON)
  t275 = (-t272 + 0.15e1) / t272
  t276 = t238 < -t275
  t277 = f.my_piecewise3(t276, -t275, t238)
  t278 = 0.1e1 - t277
  t279 = t278 ** 2
  t280 = 0.1e1 / t279
  t281 = f.my_piecewise3(t276, 0, t253)
  t285 = jnp.exp(0.15e1 / t278)
  t288 = f.my_piecewise3(t276, 0, -0.105e1 * t280 * t281 * t285)
  t289 = f.my_piecewise3(t239, t270, t288)
  t292 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t14 + 0.31385250000000000000000000000000000000000000000000e-1 * t13
  t293 = 0.1e1 / t292
  t296 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t293)
  t297 = t296 - 0.1e1
  t298 = t230 * t234
  t299 = t235 * s0
  t303 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t298 * t299 * t226
  t304 = t303 ** (0.1e1 / 0.4e1)
  t306 = 0.1e1 - 0.1e1 / t304
  t308 = t297 * t306 + 0.1e1
  t309 = jnp.log(t308)
  t315 = 0.1e1 - 0.2363e1 * t69 * t67 * t71
  t317 = jnp.log(t219)
  t320 = (-0.285764e-1 * t293 + 0.285764e-1 * t309) * t315 + t120 - t123 - t106 * t110 * t317
  t323 = f.my_piecewise3(t244, 0, t268)
  t325 = f.my_piecewise3(t276, 0, -0.7e0 * t285)
  t326 = f.my_piecewise3(t239, t323, t325)
  t327 = t292 ** 2
  t328 = 0.1e1 / t327
  t331 = -0.74083333333333333333333333333333333333333333333333e-2 * t44 - 0.10461750000000000000000000000000000000000000000000e-1 * t46
  t332 = t328 * t331
  t334 = t296 * t306
  t338 = 0.1e1 / t304 / t303
  t340 = t297 * t338 * t230
  t344 = -0.10000000000000000000000000000000000000000000000000e1 * t332 * t334 - 0.14225094736250905555555555555555555555555555555555e-1 * t340 * t236 * t248
  t345 = 0.1e1 / t308
  t350 = (0.285764e-1 * t332 + 0.285764e-1 * t344 * t345) * t315 - t187 - t188 + t189 + t190 - t222
  t353 = t6 * t137
  t356 = 0.14764627977777777777777777777777777777777777777777e-2 * t4 * t353 * t31
  t357 = t4 * t6
  t361 = 0.35616666666666666666666666666666666666666666666666e-1 * t357 * t9 * t38 * t59
  t365 = t57 ** 2
  t368 = 0.20000000000000000000000000000000000000000000000000e1 * t36 / t37 / t27 * t365 * t58
  t373 = t20 * t5 * t226
  t374 = 0.1e1 / t14 / t13 * t19 * t373
  t376 = t42 * t137
  t377 = t41 * t376
  t379 = t4 * t353
  t381 = t13 ** (-0.5e0)
  t383 = t381 * t19 * t373
  t385 = t49 * t376
  t388 = t21 * t5 * t226
  t393 = 0.10000000000000000000000000000000000000000000000000e1 * t39 * (-0.42198333333333333333333333333333333333333333333333e0 * t374 + 0.84396666666666666666666666666666666666666666666666e0 * t377 + 0.39862222222222222222222222222222222222222222222223e0 * t379 + 0.68258333333333333333333333333333333333333333333333e-1 * t383 + 0.13651666666666666666666666666666666666666666666667e0 * t385 + 0.13692777777777777777777777777777777777777777777778e0 * t388) * t58
  t394 = t37 ** 2
  t397 = t30 ** 2
  t401 = 0.16081979498692535066756296899072713062105388428051e2 * t36 / t394 * t365 / t397
  t405 = 0.24415263074675393406472461472505321282722606644045e-3 * t73 * t42 * t137 * t82
  t409 = 0.10843581300301739842632067522386578331157260943710e-1 * t72 * t4 * t10 * t99
  t412 = t96 ** 2
  t416 = 0.11696447245269292414524477327518106963944910680856e1 * t89 / t90 / t78 * t412 * t98
  t427 = 0.58482236226346462072622386637590534819724553404280e0 * t89 * t91 * (-0.57538888888888888888888888888888888888888888888889e0 * t374 + 0.11507777777777777777777777777777777777777777777778e1 * t377 + 0.40256666666666666666666666666666666666666666666667e0 * t379 + 0.36677500000000000000000000000000000000000000000000e-1 * t383 + 0.73355000000000000000000000000000000000000000000000e-1 * t385 + 0.13797500000000000000000000000000000000000000000000e0 * t388) * t98
  t428 = t90 ** 2
  t431 = t81 ** 2
  t435 = 0.17315859105681463759666483083807725165579399831905e2 * t89 / t428 * t412 / t431
  t436 = t147 ** 2
  t439 = t204 ** 2
  t443 = t135 ** 2
  t445 = 0.1e1 / t22 / t443
  t451 = 0.1e1 / t443 / r0
  t455 = s0 * t68
  t461 = t172 * t174 * t176
  t464 = t183 * t191 * t129
  t490 = t116 / t171 / t103
  t491 = t174 * t104
  t497 = t181 ** 2
  t500 = t68 / t497 * t19
  t501 = t191 ** 2
  t502 = t129 ** 2
  t513 = -t356 - t361 - t368 + t393 + t401 + t405 + t409 + t416 - t427 - t435
  t534 = 0.16681137650787305000000000000000000000000000000000e-2 * t445 * t115 * t155 * t159 - 0.82386285397499523027777777777777777777777777777777e-5 * t451 * t163 * t155 * t131 * t455 * t139 * t357 - 0.55603792169291016666666666666666666666666666666666e-3 * t154 * t461 * t455 * t464 + 0.14648281543675415194338888888888888888888888888889e-4 * t112 / t162 / t114 * t117 * t133 * t451 * t68 * t139 * t357 + 0.98863542476999427633333333333333333333333333333332e-3 * t164 * t461 * t248 * t68 * t464 - 0.29659062743099828290000000000000000000000000000000e-2 * t165 * t157 * t445 * t68 * t139 + 0.55603792169291016666666666666666666666666666666666e-2 * t490 * t491 / t175 / t130 * t178 * t500 * t186 * t501 * t502 - 0.12974218172834570555555555555555555555555555555555e-1 * t173 * t177 * s0 * t198 * t194 + 0.27801896084645508333333333333333333333333333333333e-2 * t180 * t185 * t186 * t513 * t129 - 0.27801896084645508333333333333333333333333333333333e-2 * t490 * t491 * t176 * t178 * t500 * t186 * t501 * t129 + 0.21623696954724284259259259259259259259259259259259e-1 * t134 / t7 / t443 * t68 * t139 * t143
  t558 = t106 * t110 * (-0.31250000000000000000000000000000000000000000000000e0 / t148 / t436 * t439 * t130 + 0.25000000000000000000000000000000000000000000000000e0 * t150 * t534 * t130 - 0.50000000000000000000000000000000000000000000000000e0 * t205 * t191 * t155 * t126 * t129 - 0.10000000000000000000000000000000000000000000000000e1 * t209 * t513 * t117 * t212 + 0.10000000000000000000000000000000000000000000000000e1 * t209 * t501 * t172 * t174 / t181 / t109 * t129) * t220
  t559 = t215 ** 2
  t561 = t219 ** 2
  t564 = t106 * t110 * t559 / t561
  t567 = s0 * t445
  t572 = 0.5e1 / 0.9e1 * (0.40e2 / 0.9e1 * tau0 * t153 - 0.11e2 / 0.9e1 * t567) * t230 * t236
  t573 = f.my_piecewise3(t245, t572, 0)
  t576 = t254 ** 2
  t588 = t265 ** 2
  t591 = f.my_piecewise3(t244, 0, (-0.64e0 * t573 * t257 - 0.128e1 * t576 * t261 - 0.128e1 * t255 / t260 / t256 * t576 - 0.64e0 * t262 * t573) * t268 + t588 * t268)
  t594 = t281 ** 2
  t598 = f.my_piecewise3(t276, 0, t572)
  t602 = t279 ** 2
  t608 = f.my_piecewise3(t276, 0, -0.210e1 / t279 / t278 * t594 * t285 - 0.105e1 * t280 * t598 * t285 - 0.1575e1 / t602 * t594 * t285)
  t609 = f.my_piecewise3(t239, t591, t608)
  t615 = t331 ** 2
  t616 = 0.1e1 / t327 / t292 * t615
  t622 = t328 * (-0.49388888888888888888888888888888888888888888888889e-2 * t374 + 0.98777777777777777777777777777777777777777777777777e-2 * t377 + 0.13949000000000000000000000000000000000000000000000e-1 * t379)
  t628 = t327 ** 2
  t639 = t303 ** 2
  t643 = t230 ** 2
  t648 = s0 ** 2
  t662 = t344 ** 2
  t663 = t308 ** 2
  t669 = (-0.571528e-1 * t616 + 0.285764e-1 * t622 + 0.285764e-1 * (0.20000000000000000000000000000000000000000000000000e1 * t616 * t334 - 0.10000000000000000000000000000000000000000000000000e1 * t622 * t334 + 0.10000000000000000000000000000000000000000000000000e1 / t628 * t615 * t334 + 0.28450189472501811111111111111111111111111111111110e-1 * t332 * t296 * t338 * t298 * t299 * t153 - 0.20235332025531322029119593137558641975308641975307e-2 * t297 / t304 / t639 * t643 / t232 / t104 * t68 * t648 / t7 / t443 / t151 + 0.52158680699586653703703703703703703703703703703702e-1 * t340 * t236 * t567) * t345 - 0.285764e-1 * t662 / t663) * t315 + t356 + t361 + t368 - t393 - t401 - t405 - t409 - t416 + t427 + t435 - t558 + t564
  t671 = 0.2e1 * t289 * t350 + t609 * t320 + t326 * t669 - t356 - t361 - t368 + t393 + t401 + t405 + t409 + t416 - t427 - t435 + t558 - t564
  v2rho2_0_ = 0.22146941966666666666666666666666666666666666666666e-2 * t33 + 0.20000000000000000000000000000000000000000000000000e1 * t60 - 0.36622894612013090109708692208757981924083909966068e-3 * t85 - 0.11696447245269292414524477327518106963944910680856e1 * t100 + 0.2e1 * t222 + 0.2e1 * t289 * t320 + 0.2e1 * t326 * t350 + r0 * t671
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = jnp.log(0.2e1)
  t2 = 0.1e1 - t1
  t3 = jnp.pi ** 2
  t5 = t2 / t3
  t6 = 0.1e1 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = f.my_piecewise3(t6, t8, 1)
  t10 = t9 ** 2
  t11 = t10 * t9
  t12 = 3 ** (0.1e1 / 0.3e1)
  t13 = 0.1e1 / jnp.pi
  t14 = t13 ** (0.1e1 / 0.3e1)
  t15 = t12 * t14
  t16 = 4 ** (0.1e1 / 0.3e1)
  t17 = t16 ** 2
  t18 = r0 ** (0.1e1 / 0.3e1)
  t21 = t15 * t17 / t18
  t23 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e-1 * t21
  t25 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t21
  t26 = 0.1e1 / t25
  t27 = t23 * t26
  t28 = 0.1e1 / t2
  t31 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t21
  t32 = jnp.sqrt(t21)
  t35 = t21 ** 0.15e1
  t37 = t12 ** 2
  t38 = t14 ** 2
  t39 = t37 * t38
  t40 = t18 ** 2
  t43 = t39 * t16 / t40
  t45 = 0.37978500000000000000000000000000000000000000000000e1 * t32 + 0.89690000000000000000000000000000000000000000000000e0 * t21 + 0.20477500000000000000000000000000000000000000000000e0 * t35 + 0.12323500000000000000000000000000000000000000000000e0 * t43
  t48 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t45
  t49 = jnp.log(t48)
  t51 = 0.621814e-1 * t31 * t49
  t53 = f.my_piecewise3(t6, t7 * f.p.zeta_threshold, 1)
  t55 = 0.2e1 * t53 - 0.2e1
  t56 = 2 ** (0.1e1 / 0.3e1)
  t57 = t56 - 0.1e1
  t59 = 0.1e1 / t57 / 0.2e1
  t60 = t55 * t59
  t62 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t21
  t67 = 0.51785000000000000000000000000000000000000000000000e1 * t32 + 0.90577500000000000000000000000000000000000000000000e0 * t21 + 0.11003250000000000000000000000000000000000000000000e0 * t35 + 0.12417750000000000000000000000000000000000000000000e0 * t43
  t70 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t67
  t71 = jnp.log(t70)
  t74 = 0.19751673498613801407483339618206552048944131217655e-1 * t60 * t62 * t71
  t77 = 0.1e1 / t11
  t78 = t3 * t77
  t80 = jnp.exp(-(-t51 + t74) * t28 * t78)
  t81 = t80 - 0.1e1
  t82 = 0.1e1 / t81
  t84 = t3 * t82 * s0
  t85 = t27 * t28 * t84
  t86 = r0 ** 2
  t88 = 0.1e1 / t18 / t86
  t90 = 0.1e1 / t10
  t92 = 0.1e1 / t14
  t93 = t37 * t92
  t94 = t93 * t16
  t98 = 0.1e1 + 0.27801896084645508333333333333333333333333333333333e-2 * t85 * t88 * t56 * t90 * t94
  t99 = t98 ** (0.1e1 / 0.4e1)
  t101 = 0.1e1 / t99 / t98
  t102 = t86 * r0
  t104 = 0.1e1 / t40 / t102
  t105 = t104 * t26
  t106 = t28 * t3
  t108 = t82 * s0
  t110 = t108 * t56 * t90
  t113 = t25 ** 2
  t114 = 0.1e1 / t113
  t115 = t23 * t114
  t116 = t115 * t106
  t122 = t2 ** 2
  t123 = 0.1e1 / t122
  t124 = t27 * t123
  t125 = t3 ** 2
  t126 = t81 ** 2
  t127 = 0.1e1 / t126
  t128 = t125 * t127
  t129 = s0 * t88
  t131 = t124 * t128 * t129
  t132 = t10 ** 2
  t134 = 0.1e1 / t132 / t9
  t135 = t56 * t134
  t136 = t135 * t37
  t137 = t92 * t16
  t139 = 0.1e1 / t18 / r0
  t140 = t17 * t139
  t143 = 0.11073470983333333333333333333333333333333333333333e-2 * t15 * t140 * t49
  t144 = t45 ** 2
  t145 = 0.1e1 / t144
  t146 = t31 * t145
  t148 = 0.1e1 / t32 * t12
  t149 = t14 * t17
  t150 = t149 * t139
  t151 = t148 * t150
  t153 = t15 * t140
  t155 = t21 ** 0.5e0
  t156 = t155 * t12
  t157 = t156 * t150
  t160 = 0.1e1 / t40 / r0
  t162 = t39 * t16 * t160
  t164 = -0.63297500000000000000000000000000000000000000000000e0 * t151 - 0.29896666666666666666666666666666666666666666666667e0 * t153 - 0.10238750000000000000000000000000000000000000000000e0 * t157 - 0.82156666666666666666666666666666666666666666666667e-1 * t162
  t165 = 0.1e1 / t48
  t166 = t164 * t165
  t168 = 0.10000000000000000000000000000000000000000000000000e1 * t146 * t166
  t169 = t60 * t12
  t173 = 0.18311447306006545054854346104378990962041954983034e-3 * t169 * t149 * t139 * t71
  t174 = t60 * t62
  t175 = t67 ** 2
  t176 = 0.1e1 / t175
  t181 = -0.86308333333333333333333333333333333333333333333334e0 * t151 - 0.30192500000000000000000000000000000000000000000000e0 * t153 - 0.55016250000000000000000000000000000000000000000000e-1 * t157 - 0.82785000000000000000000000000000000000000000000000e-1 * t162
  t183 = 0.1e1 / t70
  t184 = t176 * t181 * t183
  t186 = 0.58482236226346462072622386637590534819724553404280e0 * t174 * t184
  t187 = t143 + t168 - t173 - t186
  t188 = t187 * t80
  t190 = t136 * t137 * t188
  t194 = 0.1e1 / t18 / t102
  t200 = -0.27801896084645508333333333333333333333333333333333e-3 * t105 * t106 * t110 + 0.49431771238499713816666666666666666666666666666666e-3 * t116 * t108 * t104 * t56 * t90 + 0.27801896084645508333333333333333333333333333333333e-2 * t131 * t190 - 0.64871090864172852777777777777777777777777777777777e-2 * t85 * t194 * t56 * t90 * t94
  t201 = t101 * t200
  t205 = 0.1e1 - 0.1e1 / t99
  t208 = t78 * t80
  t211 = 0.25000000000000000000000000000000000000000000000000e0 * t201 * t81 - 0.10000000000000000000000000000000000000000000000000e1 * t205 * t187 * t28 * t208
  t212 = t211 ** 2
  t216 = 0.1e1 + 0.10000000000000000000000000000000000000000000000000e1 * t205 * t81
  t217 = t216 ** 2
  t218 = 0.1e1 / t217
  t220 = t5 * t11 * t212 * t218
  t224 = 0.1e1 / t40 / t86
  t228 = 6 ** (0.1e1 / 0.3e1)
  t230 = t3 ** (0.1e1 / 0.3e1)
  t231 = t230 ** 2
  t232 = 0.1e1 / t231
  t233 = t56 ** 2
  t234 = t232 * t233
  t236 = 0.5e1 / 0.9e1 * (tau0 * t160 - s0 * t224 / 0.8e1) * t228 * t234
  t237 = t236 <= 0.1e1
  t238 = jnp.log(DBL_EPSILON)
  t241 = t238 / (-t238 + 0.64e0)
  t242 = -t241 < t236
  t243 = t236 < -t241
  t246 = s0 * t104
  t251 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau0 * t224 + t246 / 0.3e1) * t228 * t234
  t252 = f.my_piecewise3(t243, t251, 0)
  t253 = f.my_piecewise3(t243, t236, -t241)
  t254 = 0.1e1 - t253
  t255 = 0.1e1 / t254
  t258 = t254 ** 2
  t259 = 0.1e1 / t258
  t260 = t253 * t259
  t263 = -0.64e0 * t252 * t255 - 0.64e0 * t260 * t252
  t266 = jnp.exp(-0.64e0 * t253 * t255)
  t268 = f.my_piecewise3(t242, 0, t263 * t266)
  t270 = jnp.log(0.14285714285714285714285714285714285714285714285714e1 * DBL_EPSILON)
  t273 = (-t270 + 0.15e1) / t270
  t274 = t236 < -t273
  t275 = f.my_piecewise3(t274, -t273, t236)
  t276 = 0.1e1 - t275
  t277 = t276 ** 2
  t278 = 0.1e1 / t277
  t279 = f.my_piecewise3(t274, 0, t251)
  t283 = jnp.exp(0.15e1 / t276)
  t286 = f.my_piecewise3(t274, 0, -0.105e1 * t278 * t279 * t283)
  t287 = f.my_piecewise3(t237, t268, t286)
  t290 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t32 + 0.31385250000000000000000000000000000000000000000000e-1 * t21
  t291 = t290 ** 2
  t292 = 0.1e1 / t291
  t295 = -0.74083333333333333333333333333333333333333333333333e-2 * t151 - 0.10461750000000000000000000000000000000000000000000e-1 * t153
  t296 = t292 * t295
  t298 = 0.1e1 / t290
  t300 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t298)
  t301 = t228 * t232
  t302 = t233 * s0
  t306 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t301 * t302 * t224
  t307 = t306 ** (0.1e1 / 0.4e1)
  t309 = 0.1e1 - 0.1e1 / t307
  t310 = t300 * t309
  t313 = t300 - 0.1e1
  t315 = 0.1e1 / t307 / t306
  t317 = t313 * t315 * t228
  t321 = -0.10000000000000000000000000000000000000000000000000e1 * t296 * t310 - 0.14225094736250905555555555555555555555555555555555e-1 * t317 * t234 * t246
  t323 = t313 * t309 + 0.1e1
  t324 = 0.1e1 / t323
  t331 = 0.1e1 - 0.2363e1 * t57 * t55 * t59
  t334 = 0.1e1 / t216
  t337 = (0.285764e-1 * t296 + 0.285764e-1 * t321 * t324) * t331 - t143 - t168 + t173 + t186 - t5 * t11 * t211 * t334
  t342 = t86 ** 2
  t344 = 0.1e1 / t40 / t342
  t345 = s0 * t344
  t350 = 0.5e1 / 0.9e1 * (0.40e2 / 0.9e1 * tau0 * t104 - 0.11e2 / 0.9e1 * t345) * t228 * t234
  t351 = f.my_piecewise3(t243, t350, 0)
  t354 = t252 ** 2
  t358 = 0.1e1 / t258 / t254
  t359 = t253 * t358
  t364 = -0.64e0 * t351 * t255 - 0.128e1 * t354 * t259 - 0.128e1 * t359 * t354 - 0.64e0 * t260 * t351
  t366 = t263 ** 2
  t369 = f.my_piecewise3(t242, 0, t364 * t266 + t366 * t266)
  t371 = 0.1e1 / t277 / t276
  t372 = t279 ** 2
  t376 = f.my_piecewise3(t274, 0, t350)
  t380 = t277 ** 2
  t381 = 0.1e1 / t380
  t386 = f.my_piecewise3(t274, 0, -0.210e1 * t371 * t372 * t283 - 0.105e1 * t278 * t376 * t283 - 0.1575e1 * t381 * t372 * t283)
  t387 = f.my_piecewise3(t237, t369, t386)
  t389 = jnp.log(t323)
  t393 = jnp.log(t216)
  t396 = (-0.285764e-1 * t298 + 0.285764e-1 * t389) * t331 + t51 - t74 - t5 * t11 * t393
  t399 = t144 ** 2
  t400 = 0.1e1 / t399
  t401 = t31 * t400
  t402 = t164 ** 2
  t403 = t48 ** 2
  t404 = 0.1e1 / t403
  t405 = t402 * t404
  t406 = t401 * t405
  t409 = 0.1e1 / t144 / t45
  t410 = t31 * t409
  t411 = t402 * t165
  t412 = t410 * t411
  t416 = 0.1e1 / t32 / t21 * t37
  t417 = t38 * t16
  t418 = t417 * t224
  t419 = t416 * t418
  t421 = t149 * t88
  t422 = t148 * t421
  t424 = t17 * t88
  t425 = t15 * t424
  t427 = t21 ** (-0.5e0)
  t428 = t427 * t37
  t429 = t428 * t418
  t431 = t156 * t421
  t434 = t39 * t16 * t224
  t436 = -0.42198333333333333333333333333333333333333333333333e0 * t419 + 0.84396666666666666666666666666666666666666666666666e0 * t422 + 0.39862222222222222222222222222222222222222222222223e0 * t425 + 0.68258333333333333333333333333333333333333333333333e-1 * t429 + 0.13651666666666666666666666666666666666666666666667e0 * t431 + 0.13692777777777777777777777777777777777777777777778e0 * t434
  t437 = t436 * t165
  t438 = t146 * t437
  t440 = t175 ** 2
  t441 = 0.1e1 / t440
  t442 = t181 ** 2
  t444 = t70 ** 2
  t445 = 0.1e1 / t444
  t446 = t441 * t442 * t445
  t447 = t174 * t446
  t450 = 0.1e1 / t175 / t67
  t452 = t450 * t442 * t183
  t453 = t174 * t452
  t461 = -0.57538888888888888888888888888888888888888888888889e0 * t419 + 0.11507777777777777777777777777777777777777777777778e1 * t422 + 0.40256666666666666666666666666666666666666666666667e0 * t425 + 0.36677500000000000000000000000000000000000000000000e-1 * t429 + 0.73355000000000000000000000000000000000000000000000e-1 * t431 + 0.13797500000000000000000000000000000000000000000000e0 * t434
  t463 = t176 * t461 * t183
  t464 = t174 * t463
  t466 = t60 * t15
  t468 = t466 * t140 * t184
  t470 = t98 ** 2
  t474 = t200 ** 2
  t480 = 0.1e1 / t99 / t470
  t482 = t344 * t26
  t486 = t342 * r0
  t487 = 0.1e1 / t486
  t488 = t487 * t114
  t489 = t106 * t82
  t491 = s0 * t56
  t492 = t491 * t90
  t493 = t15 * t17
  t494 = t492 * t493
  t497 = t123 * t125
  t498 = t497 * t127
  t499 = t105 * t498
  t501 = t134 * t187 * t80
  t502 = t491 * t501
  t506 = 0.1e1 / t113 / t25
  t507 = t23 * t506
  t509 = t507 * t28 * t84
  t515 = t115 * t498
  t516 = t246 * t56
  t526 = 0.1e1 / t122 / t2
  t527 = t27 * t526
  t528 = t125 * t3
  t530 = 0.1e1 / t126 / t81
  t531 = t528 * t530
  t533 = t527 * t531 * t129
  t534 = t132 ** 2
  t535 = 0.1e1 / t534
  t536 = t56 * t535
  t537 = t536 * t37
  t538 = t187 ** 2
  t539 = t80 ** 2
  t542 = t537 * t137 * t538 * t539
  t545 = s0 * t194
  t547 = t124 * t128 * t545
  t551 = t15 * t424 * t49
  t552 = 0.14764627977777777777777777777777777777777777777777e-2 * t551
  t553 = t139 * t145
  t555 = t493 * t553 * t166
  t556 = 0.35616666666666666666666666666666666666666666666666e-1 * t555
  t557 = 0.20000000000000000000000000000000000000000000000000e1 * t412
  t558 = 0.10000000000000000000000000000000000000000000000000e1 * t438
  t559 = 0.16081979498692535066756296899072713062105388428051e2 * t406
  t562 = t169 * t149 * t88 * t71
  t563 = 0.24415263074675393406472461472505321282722606644045e-3 * t562
  t564 = 0.10843581300301739842632067522386578331157260943710e-1 * t468
  t565 = 0.11696447245269292414524477327518106963944910680856e1 * t453
  t566 = 0.58482236226346462072622386637590534819724553404280e0 * t464
  t567 = 0.17315859105681463759666483083807725165579399831905e2 * t447
  t568 = -t552 - t556 - t557 + t558 + t559 + t563 + t564 + t565 - t566 - t567
  t571 = t136 * t137 * t568 * t80
  t574 = t528 * t127
  t576 = t527 * t574 * t129
  t579 = t537 * t137 * t538 * t80
  t583 = 0.1e1 / t18 / t342
  t589 = 0.16681137650787305000000000000000000000000000000000e-2 * t482 * t106 * t110 - 0.82386285397499523027777777777777777777777777777777e-5 * t488 * t489 * t494 - 0.55603792169291016666666666666666666666666666666666e-3 * t499 * t502 + 0.14648281543675415194338888888888888888888888888889e-4 * t509 * t487 * t56 * t90 * t493 + 0.98863542476999427633333333333333333333333333333332e-3 * t515 * t516 * t501 - 0.29659062743099828290000000000000000000000000000000e-2 * t116 * t108 * t344 * t56 * t90 + 0.55603792169291016666666666666666666666666666666666e-2 * t533 * t542 - 0.12974218172834570555555555555555555555555555555555e-1 * t547 * t190 + 0.27801896084645508333333333333333333333333333333333e-2 * t131 * t571 - 0.27801896084645508333333333333333333333333333333333e-2 * t576 * t579 + 0.21623696954724284259259259259259259259259259259259e-1 * t85 * t583 * t56 * t90 * t94
  t593 = t480 * t474
  t596 = t106 * t77 * t80
  t600 = 0.1e1 / t40 / t486
  t621 = t135 * t12 * t149 * t188
  t624 = t122 ** 2
  t626 = t27 / t624
  t627 = t125 ** 2
  t628 = t126 ** 2
  t636 = t56 / t534 / t11 * t37
  t637 = t538 * t187
  t662 = 0.51947577317044391278999449251423175496738199495715e2 * t174 * t441 * t461 * t445 * t181
  t663 = t442 * t181
  t667 = 0.35089341735807877243573431982554320891834732042568e1 * t174 * t441 * t663 * t183
  t672 = 0.35089341735807877243573431982554320891834732042568e1 * t174 * t450 * t181 * t183 * t461
  t675 = 0.32530743900905219527896202567159734993471782831130e-1 * t466 * t140 * t452
  t678 = 0.21687162600603479685264135044773156662314521887420e-1 * t466 * t424 * t184
  t681 = 0.16265371950452609763948101283579867496735891415565e-1 * t466 * t140 * t463
  t684 = 0.48159733137676571081572406076840235616767705782485e0 * t466 * t140 * t446
  t688 = t402 * t164
  t693 = 0.51726012919273400298984252201052768390886626637712e3 * t31 / t399 / t144 * t688 / t403 / t48
  t699 = 0.96491876992155210400537781394436278372632330568306e2 * t31 / t399 / t45 * t688 * t404
  t704 = 0.1e1 / t342
  t705 = 0.1e1 / t32 / t43 * t13 * t704 / 0.4e1
  t707 = t417 * t104
  t708 = t416 * t707
  t710 = t149 * t194
  t711 = t148 * t710
  t713 = t17 * t194
  t714 = t15 * t713
  t716 = t21 ** (-0.15e1)
  t718 = t716 * t13 * t704
  t720 = t428 * t707
  t722 = t156 * t710
  t725 = t39 * t16 * t104
  t730 = 0.10000000000000000000000000000000000000000000000000e1 * t146 * (-0.25319000000000000000000000000000000000000000000000e1 * t705 + 0.16879333333333333333333333333333333333333333333333e1 * t708 - 0.19692555555555555555555555555555555555555555555555e1 * t711 - 0.93011851851851851851851851851851851851851851851854e0 * t714 + 0.13651666666666666666666666666666666666666666666667e0 * t718 - 0.27303333333333333333333333333333333333333333333333e0 * t720 - 0.31853888888888888888888888888888888888888888888890e0 * t722 - 0.36514074074074074074074074074074074074074074074075e0 * t725) * t165
  t734 = 0.48245938496077605200268890697218139186316165284153e2 * t401 * t436 * t404 * t164
  t735 = -t662 - t667 + t672 - t675 - t678 + t681 + t684 + t693 - t699 + t730 + t734
  t738 = 0.60000000000000000000000000000000000000000000000000e1 * t401 * t688 * t165
  t741 = 0.60000000000000000000000000000000000000000000000000e1 * t410 * t166 * t436
  t749 = 0.10254018858216406658218194626490193680059335835414e4 * t174 / t440 / t175 * t663 / t444 / t70
  t762 = 0.58482236226346462072622386637590534819724553404280e0 * t174 * t176 * (-0.34523333333333333333333333333333333333333333333333e1 * t705 + 0.23015555555555555555555555555555555555555555555556e1 * t708 - 0.26851481481481481481481481481481481481481481481482e1 * t711 - 0.93932222222222222222222222222222222222222222222223e0 * t714 + 0.73355000000000000000000000000000000000000000000000e-1 * t718 - 0.14671000000000000000000000000000000000000000000000e0 * t720 - 0.17116166666666666666666666666666666666666666666667e0 * t722 - 0.36793333333333333333333333333333333333333333333333e0 * t725) * t183
  t768 = 0.10389515463408878255799889850284635099347639899143e3 * t174 / t440 / t67 * t663 * t445
  t771 = 0.34450798614814814814814814814814814814814814814813e-2 * t15 * t713 * t49
  t775 = 0.71233333333333333333333333333333333333333333333331e-1 * t493 * t88 * t145 * t166
  t778 = 0.53424999999999999999999999999999999999999999999999e-1 * t493 * t553 * t437
  t782 = 0.85917975471764868594145516183295969534298037676861e0 * t493 * t139 * t400 * t405
  t786 = 0.10685000000000000000000000000000000000000000000000e0 * t493 * t139 * t409 * t411
  t790 = 0.56968947174242584615102410102512416326352748836105e-3 * t169 * t149 * t194 * t71
  t791 = t738 - t741 - t749 - t762 + t768 + t771 + t775 - t778 - t782 + t786 - t790
  t792 = t735 + t791
  t807 = t134 * t568 * t80
  t811 = t526 * t528
  t812 = t811 * t530
  t814 = t535 * t538
  t815 = t814 * t539
  t819 = t811 * t127
  t821 = t814 * t80
  t825 = 0.17685589265329897609962962962962962962962962962963e-1 * t116 * t108 * t600 * t56 * t90 + 0.64871090864172852777777777777777777777777777777776e-1 * t124 * t128 * s0 * t583 * t190 - 0.38922654518503711666666666666666666666666666666665e-1 * t527 * t531 * t545 * t542 + 0.43944844631026245583016666666666666666666666666667e-4 * t507 * t123 * t128 * s0 * t487 * t621 + 0.16681137650787305000000000000000000000000000000000e-1 * t626 * t627 / t628 * t129 * t636 * t137 * t637 * t539 * t80 - 0.16681137650787305000000000000000000000000000000000e-1 * t626 * t627 * t530 * t129 * t636 * t137 * t637 * t539 - 0.19461327259251855833333333333333333333333333333333e-1 * t547 * t571 + 0.19461327259251855833333333333333333333333333333333e-1 * t527 * t574 * t545 * t579 + 0.27801896084645508333333333333333333333333333333333e-2 * t131 * t136 * t137 * t792 * t80 + 0.27801896084645508333333333333333333333333333333333e-2 * t626 * t627 * t127 * t129 * t636 * t137 * t637 * t80 - 0.83405688253936524999999999999999999999999999999999e-3 * t499 * t491 * t807 - 0.16681137650787305000000000000000000000000000000000e-2 * t105 * t812 * t491 * t815 + 0.83405688253936524999999999999999999999999999999999e-3 * t105 * t819 * t491 * t821
  t829 = t342 * t86
  t830 = 0.1e1 / t829
  t843 = t113 ** 2
  t849 = 0.1e1 / t18 / t829
  t852 = t39 * t16
  t856 = t536 * t93
  t901 = 0.50043412952361914999999999999999999999999999999999e-2 * t482 * t498 * t502 - 0.16113109698042956713772777777777777777777777777778e-3 * t509 * t830 * t56 * t90 * t493 - 0.93702686803805231790123456790123456790123456790122e-1 * t85 / t18 / t486 * t56 * t90 * t94 + 0.26044644584654888215534544444444444444444444444445e-5 * t23 / t843 * t28 * t84 * t849 * t56 * t90 * t852 + 0.16681137650787305000000000000000000000000000000000e-1 * t533 * t856 * t16 * t187 * t539 * t568 - 0.83405688253936524999999999999999999999999999999999e-2 * t576 * t856 * t16 * t568 * t188 + 0.14829531371549914145000000000000000000000000000000e-2 * t515 * t516 * t807 + 0.29659062743099828289999999999999999999999999999999e-2 * t115 * t812 * t516 * t815 - 0.14829531371549914145000000000000000000000000000000e-2 * t115 * t819 * t516 * t821 + 0.90624913937249475330555555555555555555555555555555e-4 * t830 * t114 * t489 * t494 - 0.14648281543675415194338888888888888888888888888889e-5 * t849 * t506 * t489 * t492 * t852 - 0.88977188229299484869999999999999999999999999999999e-2 * t515 * t345 * t56 * t501 - 0.99469005991731707592592592592592592592592592592592e-2 * t600 * t26 * t106 * t110 - 0.24715885619249856908333333333333333333333333333334e-4 * t488 * t123 * t128 * s0 * t621
  t906 = t101 * t589
  t915 = 0.1e1 / t132 / t10
  t924 = t205 * t568
  t926 = t125 * t915
  t941 = t5 * t11 * (0.70312500000000000000000000000000000000000000000000e0 / t99 / t470 / t98 * t474 * t200 * t81 - 0.93750000000000000000000000000000000000000000000000e0 * t480 * t200 * t81 * t589 + 0.93750000000000000000000000000000000000000000000000e0 * t593 * t187 * t596 + 0.25000000000000000000000000000000000000000000000000e0 * t101 * (t825 + t901) * t81 - 0.75000000000000000000000000000000000000000000000000e0 * t906 * t187 * t596 - 0.75000000000000000000000000000000000000000000000000e0 * t201 * t568 * t596 + 0.75000000000000000000000000000000000000000000000000e0 * t201 * t538 * t497 * t915 * t80 - 0.10000000000000000000000000000000000000000000000000e1 * t205 * t792 * t28 * t208 + 0.30000000000000000000000000000000000000000000000000e1 * t924 * t123 * t926 * t188 - 0.10000000000000000000000000000000000000000000000000e1 * t205 * t637 * t526 * t528 / t534 / t9 * t80) * t334
  t948 = 0.2e1 * t5 * t11 * t212 * t211 / t217 / t216
  t965 = -0.31250000000000000000000000000000000000000000000000e0 * t593 * t81 + 0.25000000000000000000000000000000000000000000000000e0 * t906 * t81 - 0.50000000000000000000000000000000000000000000000000e0 * t201 * t187 * t596 - 0.10000000000000000000000000000000000000000000000000e1 * t924 * t28 * t208 + 0.10000000000000000000000000000000000000000000000000e1 * t205 * t538 * t123 * t926 * t80
  t969 = 0.3e1 * t5 * t11 * t965 * t218 * t211
  t970 = t941 - t675 - t678 + t681 + t684 + t771 + t734 - t741 + t738 + t693 - t699 + t730 + t948 - t969
  t971 = f.my_piecewise3(t242, 0, t266)
  t973 = f.my_piecewise3(t274, 0, -0.7e0 * t283)
  t974 = f.my_piecewise3(t237, t971, t973)
  t975 = -t941 + t675 + t678 - t681 - t684 - t771 - t734 + t741 - t738 - t693 + t699 - t730 - t948
  t976 = t291 ** 2
  t977 = 0.1e1 / t976
  t978 = t295 ** 2
  t979 = t978 * t295
  t980 = t977 * t979
  t983 = 0.1e1 / t291 / t290
  t984 = t983 * t295
  t988 = -0.49388888888888888888888888888888888888888888888889e-2 * t419 + 0.98777777777777777777777777777777777777777777777777e-2 * t422 + 0.13949000000000000000000000000000000000000000000000e-1 * t425
  t996 = t292 * (-0.29633333333333333333333333333333333333333333333333e-1 * t705 + 0.19755555555555555555555555555555555555555555555555e-1 * t708 - 0.23048148148148148148148148148148148148148148148148e-1 * t711 - 0.32547666666666666666666666666666666666666666666667e-1 * t714)
  t1008 = t983 * t978
  t1009 = t300 * t315
  t1012 = t301 * t302 * t104
  t1022 = t292 * t988
  t1031 = t977 * t978
  t1035 = t306 ** 2
  t1037 = 0.1e1 / t307 / t1035
  t1040 = t228 ** 2
  t1042 = 0.1e1 / t230 / t3
  t1044 = s0 ** 2
  t1048 = 0.1e1 / t18 / t342 / t102
  t1053 = t296 * t1009
  t1065 = t342 ** 2
  t1072 = t313 * t1037 * t1040
  t1073 = t1042 * t56
  t1080 = s0 * t600
  t1084 = -0.60000000000000000000000000000000000000000000000000e1 * t980 * t310 + 0.60000000000000000000000000000000000000000000000000e1 * t984 * t310 * t988 - 0.60000000000000000000000000000000000000000000000000e1 / t976 / t290 * t979 * t310 - 0.85350568417505433333333333333333333333333333333330e-1 * t1008 * t1009 * t1012 - 0.10000000000000000000000000000000000000000000000000e1 * t996 * t310 + 0.30000000000000000000000000000000000000000000000000e1 * t977 * t988 * t295 * t300 * t309 + 0.42675284208752716666666666666666666666666666666665e-1 * t1022 * t1009 * t1012 - 0.10000000000000000000000000000000000000000000000000e1 / t976 / t291 * t979 * t310 - 0.42675284208752716666666666666666666666666666666665e-1 * t1031 * t1009 * t1012 + 0.60705996076593966087358779412675925925925925925921e-2 * t296 * t300 * t1037 * t1040 * t1042 * t56 * t1044 * t1048 - 0.15647604209875996111111111111111111111111111111110e0 * t1053 * t301 * t302 * t344 - 0.31087747628928898252912838668079770391184269901849e-2 * t313 / t307 / t1035 / t306 / t125 * t1044 * s0 / t1065 / t102 + 0.22258865228084454232031552451314506172839506172838e-1 * t1072 * t1073 * t1044 / t18 / t1065 - 0.24340717659807105061728395061728395061728395061728e0 * t317 * t234 * t1080
  t1102 = 0.20000000000000000000000000000000000000000000000000e1 * t1008 * t310 - 0.10000000000000000000000000000000000000000000000000e1 * t1022 * t310 + 0.10000000000000000000000000000000000000000000000000e1 * t1031 * t310 + 0.28450189472501811111111111111111111111111111111110e-1 * t1053 * t1012 - 0.20235332025531322029119593137558641975308641975307e-2 * t1072 * t1073 * t1044 * t1048 + 0.52158680699586653703703703703703703703703703703702e-1 * t317 * t234 * t345
  t1103 = t323 ** 2
  t1104 = 0.1e1 / t1103
  t1108 = t321 ** 2
  t1116 = t969 + (0.1714584e0 * t980 - 0.1714584e0 * t984 * t988 + 0.285764e-1 * t996 + 0.285764e-1 * t1084 * t324 - 0.857292e-1 * t1102 * t1104 * t321 + 0.571528e-1 * t1108 * t321 / t1103 / t323) * t331 + t667 + t662 - t672 - t775 + t778 + t782 - t786 + t790 + t749 + t762 - t768
  t1127 = 0.5e1 / 0.9e1 * (-0.440e3 / 0.27e2 * tau0 * t344 + 0.154e3 / 0.27e2 * t1080) * t228 * t234
  t1128 = f.my_piecewise3(t243, t1127, 0)
  t1134 = t354 * t252
  t1137 = t258 ** 2
  t1155 = f.my_piecewise3(t242, 0, (-0.64e0 * t1128 * t255 - 0.384e1 * t351 * t259 * t252 - 0.384e1 * t1134 * t358 - 0.384e1 * t253 / t1137 * t1134 - 0.384e1 * t359 * t252 * t351 - 0.64e0 * t260 * t1128) * t266 + 0.3e1 * t364 * t263 * t266 + t366 * t263 * t266)
  t1156 = t372 * t279
  t1169 = f.my_piecewise3(t274, 0, t1127)
  t1183 = f.my_piecewise3(t274, 0, -0.630e1 * t381 * t1156 * t283 - 0.630e1 * t371 * t279 * t283 * t376 - 0.9450e1 / t380 / t276 * t1156 * t283 - 0.105e1 * t278 * t1169 * t283 - 0.4725e1 * t381 * t376 * t279 * t283 - 0.23625e1 / t380 / t277 * t1156 * t283)
  t1184 = f.my_piecewise3(t237, t1155, t1183)
  t1196 = t5 * t11 * t965 * t334
  t1197 = (-0.571528e-1 * t1008 + 0.285764e-1 * t1022 + 0.285764e-1 * t1102 * t324 - 0.285764e-1 * t1108 * t1104) * t331 + t552 + t556 + t557 - t558 - t559 - t563 - t564 - t565 + t566 + t567 - t1196 + t220
  t1200 = t974 * (t975 + t1116) + 0.3e1 * t387 * t337 + t1184 * t396 + 0.3e1 * t287 * t1197 - t667 - t662 + t672 + t775 - t778 - t782 + t786 - t790 - t749 - t762 + t768
  v3rho3_0_ = -0.3e1 * t220 + 0.6e1 * t287 * t337 + 0.3e1 * t387 * t396 + 0.48245938496077605200268890697218139186316165284153e2 * t406 - 0.60000000000000000000000000000000000000000000000000e1 * t412 + 0.30000000000000000000000000000000000000000000000000e1 * t438 - 0.51947577317044391278999449251423175496738199495715e2 * t447 + 0.35089341735807877243573431982554320891834732042568e1 * t453 - 0.17544670867903938621786715991277160445917366021284e1 * t464 + 0.32530743900905219527896202567159734993471782831130e-1 * t468 + r0 * (t970 + t1200) + 0.3e1 * t974 * t1197 - 0.10685000000000000000000000000000000000000000000000e0 * t555 + 0.73245789224026180219417384417515963848167819932136e-3 * t562 + 0.3e1 * t1196 - 0.44293883933333333333333333333333333333333333333332e-2 * t551

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = jnp.log(0.2e1)
  t2 = 0.1e1 - t1
  t3 = jnp.pi ** 2
  t5 = t2 / t3
  t6 = 0.1e1 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = f.my_piecewise3(t6, t8, 1)
  t10 = t9 ** 2
  t11 = t10 * t9
  t12 = t5 * t11
  t13 = 3 ** (0.1e1 / 0.3e1)
  t14 = 0.1e1 / jnp.pi
  t15 = t14 ** (0.1e1 / 0.3e1)
  t16 = t13 * t15
  t17 = 4 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t22 = t16 * t18 / t19
  t24 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e-1 * t22
  t26 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t22
  t27 = 0.1e1 / t26
  t28 = t24 * t27
  t29 = 0.1e1 / t2
  t32 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t22
  t33 = jnp.sqrt(t22)
  t36 = t22 ** 0.15e1
  t38 = t13 ** 2
  t39 = t15 ** 2
  t40 = t38 * t39
  t41 = t19 ** 2
  t44 = t40 * t17 / t41
  t46 = 0.37978500000000000000000000000000000000000000000000e1 * t33 + 0.89690000000000000000000000000000000000000000000000e0 * t22 + 0.20477500000000000000000000000000000000000000000000e0 * t36 + 0.12323500000000000000000000000000000000000000000000e0 * t44
  t49 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t46
  t50 = jnp.log(t49)
  t52 = 0.621814e-1 * t32 * t50
  t54 = f.my_piecewise3(t6, t7 * f.p.zeta_threshold, 1)
  t56 = 0.2e1 * t54 - 0.2e1
  t57 = 2 ** (0.1e1 / 0.3e1)
  t58 = t57 - 0.1e1
  t60 = 0.1e1 / t58 / 0.2e1
  t61 = t56 * t60
  t63 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t22
  t68 = 0.51785000000000000000000000000000000000000000000000e1 * t33 + 0.90577500000000000000000000000000000000000000000000e0 * t22 + 0.11003250000000000000000000000000000000000000000000e0 * t36 + 0.12417750000000000000000000000000000000000000000000e0 * t44
  t71 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t68
  t72 = jnp.log(t71)
  t75 = 0.19751673498613801407483339618206552048944131217655e-1 * t61 * t63 * t72
  t78 = 0.1e1 / t11
  t79 = t3 * t78
  t81 = jnp.exp(-(-t52 + t75) * t29 * t79)
  t82 = t81 - 0.1e1
  t83 = 0.1e1 / t82
  t85 = t3 * t83 * s0
  t86 = t28 * t29 * t85
  t87 = r0 ** 2
  t89 = 0.1e1 / t19 / t87
  t91 = 0.1e1 / t10
  t93 = 0.1e1 / t15
  t94 = t38 * t93
  t95 = t94 * t17
  t99 = 0.1e1 + 0.27801896084645508333333333333333333333333333333333e-2 * t86 * t89 * t57 * t91 * t95
  t100 = t99 ** 2
  t101 = t99 ** (0.1e1 / 0.4e1)
  t103 = 0.1e1 / t101 / t100
  t104 = t87 * r0
  t106 = 0.1e1 / t41 / t104
  t107 = t106 * t27
  t108 = t29 * t3
  t110 = t83 * s0
  t112 = t110 * t57 * t91
  t115 = t26 ** 2
  t116 = 0.1e1 / t115
  t117 = t24 * t116
  t118 = t117 * t108
  t119 = t106 * t57
  t124 = t2 ** 2
  t125 = 0.1e1 / t124
  t126 = t28 * t125
  t127 = t3 ** 2
  t128 = t82 ** 2
  t129 = 0.1e1 / t128
  t130 = t127 * t129
  t131 = s0 * t89
  t133 = t126 * t130 * t131
  t134 = t10 ** 2
  t136 = 0.1e1 / t134 / t9
  t137 = t57 * t136
  t138 = t137 * t38
  t139 = t93 * t17
  t141 = 0.1e1 / t19 / r0
  t142 = t18 * t141
  t145 = 0.11073470983333333333333333333333333333333333333333e-2 * t16 * t142 * t50
  t146 = t46 ** 2
  t147 = 0.1e1 / t146
  t148 = t32 * t147
  t150 = 0.1e1 / t33 * t13
  t151 = t15 * t18
  t152 = t151 * t141
  t153 = t150 * t152
  t155 = t16 * t142
  t157 = t22 ** 0.5e0
  t158 = t157 * t13
  t159 = t158 * t152
  t162 = 0.1e1 / t41 / r0
  t164 = t40 * t17 * t162
  t166 = -0.63297500000000000000000000000000000000000000000000e0 * t153 - 0.29896666666666666666666666666666666666666666666667e0 * t155 - 0.10238750000000000000000000000000000000000000000000e0 * t159 - 0.82156666666666666666666666666666666666666666666667e-1 * t164
  t167 = 0.1e1 / t49
  t168 = t166 * t167
  t170 = 0.10000000000000000000000000000000000000000000000000e1 * t148 * t168
  t171 = t61 * t13
  t175 = 0.18311447306006545054854346104378990962041954983034e-3 * t171 * t151 * t141 * t72
  t176 = t61 * t63
  t177 = t68 ** 2
  t178 = 0.1e1 / t177
  t183 = -0.86308333333333333333333333333333333333333333333334e0 * t153 - 0.30192500000000000000000000000000000000000000000000e0 * t155 - 0.55016250000000000000000000000000000000000000000000e-1 * t159 - 0.82785000000000000000000000000000000000000000000000e-1 * t164
  t185 = 0.1e1 / t71
  t186 = t178 * t183 * t185
  t188 = 0.58482236226346462072622386637590534819724553404280e0 * t176 * t186
  t189 = t145 + t170 - t175 - t188
  t190 = t189 * t81
  t192 = t138 * t139 * t190
  t196 = 0.1e1 / t19 / t104
  t202 = -0.27801896084645508333333333333333333333333333333333e-3 * t107 * t108 * t112 + 0.49431771238499713816666666666666666666666666666666e-3 * t118 * t110 * t119 * t91 + 0.27801896084645508333333333333333333333333333333333e-2 * t133 * t192 - 0.64871090864172852777777777777777777777777777777777e-2 * t86 * t196 * t57 * t91 * t95
  t203 = t202 ** 2
  t204 = t103 * t203
  t208 = 0.1e1 / t101 / t99
  t209 = t87 ** 2
  t211 = 0.1e1 / t41 / t209
  t212 = t211 * t27
  t216 = t209 * r0
  t217 = 0.1e1 / t216
  t218 = t217 * t116
  t219 = t108 * t83
  t221 = s0 * t57
  t222 = t221 * t91
  t223 = t16 * t18
  t224 = t222 * t223
  t227 = t125 * t127
  t228 = t227 * t129
  t229 = t107 * t228
  t231 = t136 * t189 * t81
  t232 = t221 * t231
  t236 = 0.1e1 / t115 / t26
  t237 = t24 * t236
  t239 = t237 * t29 * t85
  t245 = t117 * t228
  t246 = s0 * t106
  t247 = t246 * t57
  t257 = 0.1e1 / t124 / t2
  t258 = t28 * t257
  t259 = t127 * t3
  t261 = 0.1e1 / t128 / t82
  t262 = t259 * t261
  t264 = t258 * t262 * t131
  t265 = t134 ** 2
  t266 = 0.1e1 / t265
  t267 = t57 * t266
  t268 = t267 * t38
  t269 = t189 ** 2
  t270 = t81 ** 2
  t271 = t269 * t270
  t273 = t268 * t139 * t271
  t276 = s0 * t196
  t278 = t126 * t130 * t276
  t281 = t18 * t89
  t284 = 0.14764627977777777777777777777777777777777777777777e-2 * t16 * t281 * t50
  t285 = t141 * t147
  t288 = 0.35616666666666666666666666666666666666666666666666e-1 * t223 * t285 * t168
  t289 = t146 * t46
  t290 = 0.1e1 / t289
  t291 = t32 * t290
  t292 = t166 ** 2
  t293 = t292 * t167
  t295 = 0.20000000000000000000000000000000000000000000000000e1 * t291 * t293
  t298 = 0.1e1 / t33 / t22 * t38
  t299 = t39 * t17
  t301 = 0.1e1 / t41 / t87
  t302 = t299 * t301
  t303 = t298 * t302
  t305 = t151 * t89
  t306 = t150 * t305
  t308 = t16 * t281
  t310 = t22 ** (-0.5e0)
  t311 = t310 * t38
  t312 = t311 * t302
  t314 = t158 * t305
  t317 = t40 * t17 * t301
  t319 = -0.42198333333333333333333333333333333333333333333333e0 * t303 + 0.84396666666666666666666666666666666666666666666666e0 * t306 + 0.39862222222222222222222222222222222222222222222223e0 * t308 + 0.68258333333333333333333333333333333333333333333333e-1 * t312 + 0.13651666666666666666666666666666666666666666666667e0 * t314 + 0.13692777777777777777777777777777777777777777777778e0 * t317
  t320 = t319 * t167
  t322 = 0.10000000000000000000000000000000000000000000000000e1 * t148 * t320
  t323 = t146 ** 2
  t324 = 0.1e1 / t323
  t325 = t32 * t324
  t326 = t49 ** 2
  t327 = 0.1e1 / t326
  t328 = t292 * t327
  t330 = 0.16081979498692535066756296899072713062105388428051e2 * t325 * t328
  t334 = 0.24415263074675393406472461472505321282722606644045e-3 * t171 * t151 * t89 * t72
  t335 = t61 * t16
  t338 = 0.10843581300301739842632067522386578331157260943710e-1 * t335 * t142 * t186
  t339 = t177 * t68
  t340 = 0.1e1 / t339
  t341 = t183 ** 2
  t343 = t340 * t341 * t185
  t345 = 0.11696447245269292414524477327518106963944910680856e1 * t176 * t343
  t352 = -0.57538888888888888888888888888888888888888888888889e0 * t303 + 0.11507777777777777777777777777777777777777777777778e1 * t306 + 0.40256666666666666666666666666666666666666666666667e0 * t308 + 0.36677500000000000000000000000000000000000000000000e-1 * t312 + 0.73355000000000000000000000000000000000000000000000e-1 * t314 + 0.13797500000000000000000000000000000000000000000000e0 * t317
  t354 = t178 * t352 * t185
  t356 = 0.58482236226346462072622386637590534819724553404280e0 * t176 * t354
  t357 = t177 ** 2
  t358 = 0.1e1 / t357
  t359 = t358 * t341
  t360 = t71 ** 2
  t361 = 0.1e1 / t360
  t362 = t359 * t361
  t364 = 0.17315859105681463759666483083807725165579399831905e2 * t176 * t362
  t365 = -t284 - t288 - t295 + t322 + t330 + t334 + t338 + t345 - t356 - t364
  t366 = t365 * t81
  t368 = t138 * t139 * t366
  t371 = t259 * t129
  t373 = t258 * t371 * t131
  t374 = t269 * t81
  t376 = t268 * t139 * t374
  t380 = 0.1e1 / t19 / t209
  t386 = 0.16681137650787305000000000000000000000000000000000e-2 * t212 * t108 * t112 - 0.82386285397499523027777777777777777777777777777777e-5 * t218 * t219 * t224 - 0.55603792169291016666666666666666666666666666666666e-3 * t229 * t232 + 0.14648281543675415194338888888888888888888888888889e-4 * t239 * t217 * t57 * t91 * t223 + 0.98863542476999427633333333333333333333333333333332e-3 * t245 * t247 * t231 - 0.29659062743099828290000000000000000000000000000000e-2 * t118 * t110 * t211 * t57 * t91 + 0.55603792169291016666666666666666666666666666666666e-2 * t264 * t273 - 0.12974218172834570555555555555555555555555555555555e-1 * t278 * t192 + 0.27801896084645508333333333333333333333333333333333e-2 * t133 * t368 - 0.27801896084645508333333333333333333333333333333333e-2 * t373 * t376 + 0.21623696954724284259259259259259259259259259259259e-1 * t86 * t380 * t57 * t91 * t95
  t387 = t208 * t386
  t390 = t208 * t202
  t393 = t108 * t78 * t81
  t397 = 0.1e1 - 0.1e1 / t101
  t398 = t397 * t365
  t400 = t79 * t81
  t405 = t134 * t10
  t406 = 0.1e1 / t405
  t407 = t127 * t406
  t408 = t407 * t81
  t411 = -0.31250000000000000000000000000000000000000000000000e0 * t204 * t82 + 0.25000000000000000000000000000000000000000000000000e0 * t387 * t82 - 0.50000000000000000000000000000000000000000000000000e0 * t390 * t189 * t393 - 0.10000000000000000000000000000000000000000000000000e1 * t398 * t29 * t400 + 0.10000000000000000000000000000000000000000000000000e1 * t397 * t269 * t125 * t408
  t414 = 0.1e1 + 0.10000000000000000000000000000000000000000000000000e1 * t397 * t82
  t415 = t414 ** 2
  t416 = 0.1e1 / t415
  t424 = 0.25000000000000000000000000000000000000000000000000e0 * t390 * t82 - 0.10000000000000000000000000000000000000000000000000e1 * t397 * t189 * t29 * t400
  t426 = t12 * t411 * t416 * t424
  t429 = t335 * t142 * t343
  t432 = t335 * t281 * t186
  t435 = t335 * t142 * t354
  t438 = t335 * t142 * t362
  t442 = t325 * t319 * t327 * t166
  t445 = t291 * t168 * t319
  t447 = t292 * t166
  t448 = t447 * t167
  t449 = t325 * t448
  t455 = 6 ** (0.1e1 / 0.3e1)
  t457 = t3 ** (0.1e1 / 0.3e1)
  t458 = t457 ** 2
  t459 = 0.1e1 / t458
  t460 = t57 ** 2
  t461 = t459 * t460
  t463 = 0.5e1 / 0.9e1 * (tau0 * t162 - s0 * t301 / 0.8e1) * t455 * t461
  t464 = t463 <= 0.1e1
  t465 = jnp.log(DBL_EPSILON)
  t468 = t465 / (-t465 + 0.64e0)
  t469 = -t468 < t463
  t470 = t463 < -t468
  t477 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau0 * t301 + t246 / 0.3e1) * t455 * t461
  t478 = f.my_piecewise3(t470, t477, 0)
  t479 = f.my_piecewise3(t470, t463, -t468)
  t480 = 0.1e1 - t479
  t481 = 0.1e1 / t480
  t484 = t480 ** 2
  t485 = 0.1e1 / t484
  t486 = t479 * t485
  t489 = -0.64e0 * t478 * t481 - 0.64e0 * t486 * t478
  t492 = jnp.exp(-0.64e0 * t479 * t481)
  t494 = f.my_piecewise3(t469, 0, t489 * t492)
  t496 = jnp.log(0.14285714285714285714285714285714285714285714285714e1 * DBL_EPSILON)
  t499 = (-t496 + 0.15e1) / t496
  t500 = t463 < -t499
  t501 = f.my_piecewise3(t500, -t499, t463)
  t502 = 0.1e1 - t501
  t503 = t502 ** 2
  t504 = 0.1e1 / t503
  t505 = f.my_piecewise3(t500, 0, t477)
  t509 = jnp.exp(0.15e1 / t502)
  t512 = f.my_piecewise3(t500, 0, -0.105e1 * t504 * t505 * t509)
  t513 = f.my_piecewise3(t464, t494, t512)
  t516 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t33 + 0.31385250000000000000000000000000000000000000000000e-1 * t22
  t517 = t516 ** 2
  t518 = t517 * t516
  t519 = 0.1e1 / t518
  t522 = -0.74083333333333333333333333333333333333333333333333e-2 * t153 - 0.10461750000000000000000000000000000000000000000000e-1 * t155
  t523 = t522 ** 2
  t524 = t519 * t523
  t526 = 0.1e1 / t517
  t530 = -0.49388888888888888888888888888888888888888888888889e-2 * t303 + 0.98777777777777777777777777777777777777777777777777e-2 * t306 + 0.13949000000000000000000000000000000000000000000000e-1 * t308
  t531 = t526 * t530
  t533 = 0.1e1 / t516
  t535 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t533)
  t536 = t455 * t459
  t537 = t460 * s0
  t541 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t536 * t537 * t301
  t542 = t541 ** (0.1e1 / 0.4e1)
  t544 = 0.1e1 - 0.1e1 / t542
  t545 = t535 * t544
  t550 = t517 ** 2
  t551 = 0.1e1 / t550
  t552 = t551 * t523
  t555 = t526 * t522
  t557 = 0.1e1 / t542 / t541
  t558 = t535 * t557
  t559 = t555 * t558
  t561 = t536 * t537 * t106
  t564 = t535 - 0.1e1
  t565 = t541 ** 2
  t567 = 0.1e1 / t542 / t565
  t569 = t455 ** 2
  t570 = t564 * t567 * t569
  t572 = 0.1e1 / t457 / t3
  t573 = t572 * t57
  t574 = s0 ** 2
  t575 = t209 * t104
  t577 = 0.1e1 / t19 / t575
  t583 = t564 * t557 * t455
  t584 = s0 * t211
  t588 = 0.20000000000000000000000000000000000000000000000000e1 * t524 * t545 - 0.10000000000000000000000000000000000000000000000000e1 * t531 * t545 + 0.10000000000000000000000000000000000000000000000000e1 * t552 * t545 + 0.28450189472501811111111111111111111111111111111110e-1 * t559 * t561 - 0.20235332025531322029119593137558641975308641975307e-2 * t570 * t573 * t574 * t577 + 0.52158680699586653703703703703703703703703703703702e-1 * t583 * t461 * t584
  t590 = t564 * t544 + 0.1e1
  t591 = 0.1e1 / t590
  t599 = -0.10000000000000000000000000000000000000000000000000e1 * t555 * t545 - 0.14225094736250905555555555555555555555555555555555e-1 * t583 * t461 * t246
  t600 = t599 ** 2
  t601 = t590 ** 2
  t602 = 0.1e1 / t601
  t609 = 0.1e1 - 0.2363e1 * t58 * t56 * t60
  t612 = 0.1e1 / t414
  t615 = t424 ** 2
  t619 = (-0.571528e-1 * t524 + 0.285764e-1 * t531 + 0.285764e-1 * t588 * t591 - 0.285764e-1 * t600 * t602) * t609 + t284 + t288 + t295 - t322 - t330 - t334 - t338 - t345 + t356 + t364 - t5 * t11 * t411 * t612 + t5 * t11 * t615 * t416
  t625 = 0.1e1 / t415 / t414
  t627 = t5 * t11 * t615 * t424 * t625
  t631 = 0.1e1 / t101 / t100 / t99
  t633 = t631 * t203 * t202
  t636 = t103 * t202
  t637 = t82 * t386
  t644 = 0.1e1 / t41 / t216
  t650 = t218 * t125
  t651 = t130 * s0
  t655 = t137 * t13 * t151 * t190
  t658 = t124 ** 2
  t659 = 0.1e1 / t658
  t660 = t28 * t659
  t661 = t127 ** 2
  t662 = t661 * t129
  t664 = t660 * t662 * t131
  t666 = 0.1e1 / t265 / t11
  t667 = t57 * t666
  t668 = t667 * t38
  t669 = t269 * t189
  t672 = t668 * t139 * t669 * t81
  t675 = s0 * t380
  t677 = t126 * t130 * t675
  t681 = t258 * t262 * t276
  t684 = t237 * t125
  t685 = s0 * t217
  t687 = t684 * t130 * t685
  t690 = t128 ** 2
  t691 = 0.1e1 / t690
  t692 = t661 * t691
  t694 = t660 * t692 * t131
  t695 = t270 * t81
  t698 = t668 * t139 * t669 * t695
  t701 = t661 * t261
  t703 = t660 * t701 * t131
  t706 = t668 * t139 * t669 * t270
  t712 = t258 * t371 * t276
  t715 = t212 * t228
  t719 = t136 * t365 * t81
  t720 = t221 * t719
  t723 = t257 * t259
  t724 = t723 * t261
  t725 = t107 * t724
  t726 = t266 * t269
  t727 = t726 * t270
  t728 = t221 * t727
  t731 = 0.17685589265329897609962962962962962962962962962963e-1 * t118 * t110 * t644 * t57 * t91 - 0.24715885619249856908333333333333333333333333333334e-4 * t650 * t651 * t655 + 0.27801896084645508333333333333333333333333333333333e-2 * t664 * t672 + 0.64871090864172852777777777777777777777777777777776e-1 * t677 * t192 - 0.38922654518503711666666666666666666666666666666665e-1 * t681 * t273 + 0.43944844631026245583016666666666666666666666666667e-4 * t687 * t655 + 0.16681137650787305000000000000000000000000000000000e-1 * t694 * t698 - 0.16681137650787305000000000000000000000000000000000e-1 * t703 * t706 - 0.19461327259251855833333333333333333333333333333333e-1 * t278 * t368 + 0.19461327259251855833333333333333333333333333333333e-1 * t712 * t376 + 0.50043412952361914999999999999999999999999999999999e-2 * t715 * t232 - 0.83405688253936524999999999999999999999999999999999e-3 * t229 * t720 - 0.16681137650787305000000000000000000000000000000000e-2 * t725 * t728
  t732 = t723 * t129
  t733 = t107 * t732
  t734 = t726 * t81
  t735 = t221 * t734
  t738 = t117 * t732
  t742 = t209 * t87
  t743 = 0.1e1 / t742
  t744 = t743 * t116
  t749 = 0.1e1 / t19 / t742
  t750 = t749 * t236
  t752 = t40 * t17
  t753 = t222 * t752
  t756 = t584 * t57
  t763 = t117 * t724
  t767 = t267 * t94
  t768 = t17 * t365
  t770 = t767 * t768 * t190
  t773 = t17 * t189
  t776 = t767 * t773 * t270 * t365
  t780 = t361 * t183
  t782 = t176 * t358 * t352 * t780
  t783 = 0.51947577317044391278999449251423175496738199495715e2 * t782
  t784 = t341 * t183
  t786 = t358 * t784 * t185
  t787 = t176 * t786
  t788 = 0.35089341735807877243573431982554320891834732042568e1 * t787
  t789 = t340 * t183
  t790 = t185 * t352
  t792 = t176 * t789 * t790
  t793 = 0.35089341735807877243573431982554320891834732042568e1 * t792
  t794 = 0.32530743900905219527896202567159734993471782831130e-1 * t429
  t795 = 0.21687162600603479685264135044773156662314521887420e-1 * t432
  t796 = 0.16265371950452609763948101283579867496735891415565e-1 * t435
  t797 = 0.48159733137676571081572406076840235616767705782485e0 * t438
  t799 = 0.1e1 / t323 / t146
  t800 = t32 * t799
  t802 = 0.1e1 / t326 / t49
  t803 = t447 * t802
  t804 = t800 * t803
  t805 = 0.51726012919273400298984252201052768390886626637712e3 * t804
  t807 = 0.1e1 / t323 / t46
  t808 = t32 * t807
  t809 = t447 * t327
  t810 = t808 * t809
  t811 = 0.96491876992155210400537781394436278372632330568306e2 * t810
  t815 = 0.1e1 / t33 / t44 * t14 / 0.4e1
  t816 = 0.1e1 / t209
  t817 = t815 * t816
  t819 = t299 * t106
  t820 = t298 * t819
  t822 = t151 * t196
  t823 = t150 * t822
  t825 = t18 * t196
  t826 = t16 * t825
  t828 = t22 ** (-0.15e1)
  t829 = t828 * t14
  t830 = t829 * t816
  t832 = t311 * t819
  t834 = t158 * t822
  t837 = t40 * t17 * t106
  t839 = -0.25319000000000000000000000000000000000000000000000e1 * t817 + 0.16879333333333333333333333333333333333333333333333e1 * t820 - 0.19692555555555555555555555555555555555555555555555e1 * t823 - 0.93011851851851851851851851851851851851851851851854e0 * t826 + 0.13651666666666666666666666666666666666666666666667e0 * t830 - 0.27303333333333333333333333333333333333333333333333e0 * t832 - 0.31853888888888888888888888888888888888888888888890e0 * t834 - 0.36514074074074074074074074074074074074074074074075e0 * t837
  t840 = t839 * t167
  t841 = t148 * t840
  t842 = 0.10000000000000000000000000000000000000000000000000e1 * t841
  t843 = 0.48245938496077605200268890697218139186316165284153e2 * t442
  t844 = -t783 - t788 + t793 - t794 - t795 + t796 + t797 + t805 - t811 + t842 + t843
  t845 = 0.60000000000000000000000000000000000000000000000000e1 * t445
  t846 = 0.60000000000000000000000000000000000000000000000000e1 * t449
  t848 = 0.1e1 / t357 / t177
  t851 = 0.1e1 / t360 / t71
  t852 = t848 * t784 * t851
  t853 = t176 * t852
  t854 = 0.10254018858216406658218194626490193680059335835414e4 * t853
  t863 = -0.34523333333333333333333333333333333333333333333333e1 * t817 + 0.23015555555555555555555555555555555555555555555556e1 * t820 - 0.26851481481481481481481481481481481481481481481482e1 * t823 - 0.93932222222222222222222222222222222222222222222223e0 * t826 + 0.73355000000000000000000000000000000000000000000000e-1 * t830 - 0.14671000000000000000000000000000000000000000000000e0 * t832 - 0.17116166666666666666666666666666666666666666666667e0 * t834 - 0.36793333333333333333333333333333333333333333333333e0 * t837
  t865 = t178 * t863 * t185
  t866 = t176 * t865
  t867 = 0.58482236226346462072622386637590534819724553404280e0 * t866
  t869 = 0.1e1 / t357 / t68
  t871 = t869 * t784 * t361
  t872 = t176 * t871
  t873 = 0.10389515463408878255799889850284635099347639899143e3 * t872
  t875 = t16 * t825 * t50
  t876 = 0.34450798614814814814814814814814814814814814814813e-2 * t875
  t877 = t89 * t147
  t879 = t223 * t877 * t168
  t880 = 0.71233333333333333333333333333333333333333333333331e-1 * t879
  t882 = t223 * t285 * t320
  t883 = 0.53424999999999999999999999999999999999999999999999e-1 * t882
  t884 = t141 * t324
  t886 = t223 * t884 * t328
  t887 = 0.85917975471764868594145516183295969534298037676861e0 * t886
  t890 = t223 * t141 * t290 * t293
  t891 = 0.10685000000000000000000000000000000000000000000000e0 * t890
  t894 = t171 * t151 * t196 * t72
  t895 = 0.56968947174242584615102410102512416326352748836105e-3 * t894
  t896 = -t845 + t846 - t854 - t867 + t873 + t876 + t880 - t883 - t887 + t891 - t895
  t897 = t844 + t896
  t900 = t138 * t139 * t897 * t81
  t903 = t644 * t27
  t907 = t115 ** 2
  t908 = 0.1e1 / t907
  t909 = t24 * t908
  t911 = t909 * t29 * t85
  t913 = t749 * t57 * t91
  t923 = 0.1e1 / t19 / t216
  t929 = 0.83405688253936524999999999999999999999999999999999e-3 * t733 * t735 - 0.14829531371549914145000000000000000000000000000000e-2 * t738 * t247 * t734 + 0.90624913937249475330555555555555555555555555555555e-4 * t744 * t219 * t224 - 0.14648281543675415194338888888888888888888888888889e-5 * t750 * t219 * t753 - 0.88977188229299484869999999999999999999999999999999e-2 * t245 * t756 * t231 + 0.14829531371549914145000000000000000000000000000000e-2 * t245 * t247 * t719 + 0.29659062743099828289999999999999999999999999999999e-2 * t763 * t247 * t727 - 0.83405688253936524999999999999999999999999999999999e-2 * t373 * t770 + 0.16681137650787305000000000000000000000000000000000e-1 * t264 * t776 + 0.27801896084645508333333333333333333333333333333333e-2 * t133 * t900 - 0.99469005991731707592592592592592592592592592592592e-2 * t903 * t108 * t112 + 0.26044644584654888215534544444444444444444444444445e-5 * t911 * t913 * t752 - 0.16113109698042956713772777777777777777777777777778e-3 * t239 * t743 * t57 * t91 * t223 - 0.93702686803805231790123456790123456790123456790122e-1 * t86 * t923 * t57 * t91 * t95
  t930 = t731 + t929
  t931 = t208 * t930
  t942 = t227 * t406 * t81
  t945 = t397 * t897
  t950 = t407 * t190
  t956 = 0.1e1 / t265 / t9
  t957 = t259 * t956
  t961 = 0.70312500000000000000000000000000000000000000000000e0 * t633 * t82 - 0.93750000000000000000000000000000000000000000000000e0 * t636 * t637 + 0.93750000000000000000000000000000000000000000000000e0 * t204 * t189 * t393 + 0.25000000000000000000000000000000000000000000000000e0 * t931 * t82 - 0.75000000000000000000000000000000000000000000000000e0 * t387 * t189 * t393 - 0.75000000000000000000000000000000000000000000000000e0 * t390 * t365 * t393 + 0.75000000000000000000000000000000000000000000000000e0 * t390 * t269 * t942 - 0.10000000000000000000000000000000000000000000000000e1 * t945 * t29 * t400 + 0.30000000000000000000000000000000000000000000000000e1 * t398 * t125 * t950 - 0.10000000000000000000000000000000000000000000000000e1 * t397 * t669 * t257 * t957 * t81
  t964 = t5 * t11 * t961 * t612
  t971 = s0 * t644
  t976 = 0.5e1 / 0.9e1 * (-0.440e3 / 0.27e2 * tau0 * t211 + 0.154e3 / 0.27e2 * t971) * t455 * t461
  t977 = f.my_piecewise3(t470, t976, 0)
  t986 = 0.5e1 / 0.9e1 * (0.40e2 / 0.9e1 * tau0 * t106 - 0.11e2 / 0.9e1 * t584) * t455 * t461
  t987 = f.my_piecewise3(t470, t986, 0)
  t991 = t478 ** 2
  t992 = t991 * t478
  t994 = 0.1e1 / t484 / t480
  t997 = t484 ** 2
  t998 = 0.1e1 / t997
  t999 = t479 * t998
  t1002 = t479 * t994
  t1008 = -0.64e0 * t977 * t481 - 0.384e1 * t987 * t485 * t478 - 0.384e1 * t992 * t994 - 0.384e1 * t999 * t992 - 0.384e1 * t1002 * t478 * t987 - 0.64e0 * t486 * t977
  t1018 = -0.64e0 * t987 * t481 - 0.128e1 * t991 * t485 - 0.128e1 * t1002 * t991 - 0.64e0 * t486 * t987
  t1022 = t489 ** 2
  t1026 = f.my_piecewise3(t469, 0, 0.3e1 * t1018 * t489 * t492 + t1022 * t489 * t492 + t1008 * t492)
  t1027 = t503 ** 2
  t1028 = 0.1e1 / t1027
  t1029 = t505 ** 2
  t1030 = t1029 * t505
  t1034 = t503 * t502
  t1035 = 0.1e1 / t1034
  t1036 = t1035 * t505
  t1037 = f.my_piecewise3(t500, 0, t986)
  t1038 = t509 * t1037
  t1042 = 0.1e1 / t1027 / t502
  t1046 = f.my_piecewise3(t500, 0, t976)
  t1051 = t505 * t509
  t1055 = 0.1e1 / t1027 / t503
  t1060 = f.my_piecewise3(t500, 0, -0.630e1 * t1028 * t1030 * t509 - 0.630e1 * t1036 * t1038 - 0.9450e1 * t1042 * t1030 * t509 - 0.105e1 * t504 * t1046 * t509 - 0.4725e1 * t1028 * t1037 * t1051 - 0.23625e1 * t1055 * t1030 * t509)
  t1061 = f.my_piecewise3(t464, t1026, t1060)
  t1063 = jnp.log(t590)
  t1067 = jnp.log(t414)
  t1070 = (-0.285764e-1 * t533 + 0.285764e-1 * t1063) * t609 + t52 - t75 - t5 * t11 * t1067
  t1073 = -0.12e2 * t426 - 0.13012297560362087811158481026863893997388713132452e0 * t429 - 0.86748650402413918741056540179092626649258087549680e-1 * t432 + 0.65061487801810439055792405134319469986943565662260e-1 * t435 + 0.19263893255070628432628962430736094246707082312994e1 * t438 + 0.19298375398431042080107556278887255674526466113661e3 * t442 - 0.24000000000000000000000000000000000000000000000000e2 * t445 + 0.24000000000000000000000000000000000000000000000000e2 * t449 + 0.12e2 * t513 * t619 + 0.8e1 * t627 + 0.4e1 * t964 + 0.20690405167709360119593700880421107356354650655085e4 * t804 - 0.38596750796862084160215112557774511349052932227323e3 * t810 + 0.13780319445925925925925925925925925925925925925925e-1 * t875 + 0.4e1 * t1061 * t1070
  t1077 = f.my_piecewise3(t469, 0, t1018 * t492 + t1022 * t492)
  t1084 = t1028 * t1029
  t1088 = f.my_piecewise3(t500, 0, -0.210e1 * t1035 * t1029 * t509 - 0.105e1 * t504 * t1037 * t509 - 0.1575e1 * t1084 * t509)
  t1089 = f.my_piecewise3(t464, t1077, t1088)
  t1098 = (0.285764e-1 * t555 + 0.285764e-1 * t599 * t591) * t609 - t145 - t170 + t175 + t188 - t5 * t11 * t424 * t612
  t1101 = f.my_piecewise3(t469, 0, t492)
  t1103 = f.my_piecewise3(t500, 0, -0.7e0 * t509)
  t1104 = f.my_piecewise3(t464, t1101, t1103)
  t1106 = t523 * t522
  t1107 = t551 * t1106
  t1109 = t519 * t522
  t1116 = -0.29633333333333333333333333333333333333333333333333e-1 * t817 + 0.19755555555555555555555555555555555555555555555555e-1 * t820 - 0.23048148148148148148148148148148148148148148148148e-1 * t823 - 0.32547666666666666666666666666666666666666666666667e-1 * t826
  t1117 = t526 * t1116
  t1121 = t545 * t530
  t1125 = 0.1e1 / t550 / t516
  t1126 = t1125 * t1106
  t1129 = t524 * t558
  t1134 = t551 * t530
  t1135 = t522 * t535
  t1136 = t1135 * t544
  t1139 = t531 * t558
  t1143 = 0.1e1 / t550 / t517
  t1144 = t1143 * t1106
  t1147 = t552 * t558
  t1150 = t535 * t567
  t1151 = t555 * t1150
  t1152 = t569 * t572
  t1153 = t57 * t574
  t1155 = t1152 * t1153 * t577
  t1159 = t536 * t537 * t211
  t1164 = 0.1e1 / t542 / t565 / t541
  t1165 = t564 * t1164
  t1166 = 0.1e1 / t127
  t1167 = t574 * s0
  t1168 = t1166 * t1167
  t1169 = t209 ** 2
  t1171 = 0.1e1 / t1169 / t104
  t1176 = 0.1e1 / t19 / t1169
  t1184 = -0.60000000000000000000000000000000000000000000000000e1 * t1107 * t545 + 0.60000000000000000000000000000000000000000000000000e1 * t1109 * t1121 - 0.60000000000000000000000000000000000000000000000000e1 * t1126 * t545 - 0.85350568417505433333333333333333333333333333333330e-1 * t1129 * t561 - 0.10000000000000000000000000000000000000000000000000e1 * t1117 * t545 + 0.30000000000000000000000000000000000000000000000000e1 * t1134 * t1136 + 0.42675284208752716666666666666666666666666666666665e-1 * t1139 * t561 - 0.10000000000000000000000000000000000000000000000000e1 * t1144 * t545 - 0.42675284208752716666666666666666666666666666666665e-1 * t1147 * t561 + 0.60705996076593966087358779412675925925925925925921e-2 * t1151 * t1155 - 0.15647604209875996111111111111111111111111111111110e0 * t559 * t1159 - 0.31087747628928898252912838668079770391184269901849e-2 * t1165 * t1168 * t1171 + 0.22258865228084454232031552451314506172839506172838e-1 * t570 * t573 * t574 * t1176 - 0.24340717659807105061728395061728395061728395061728e0 * t583 * t461 * t971
  t1192 = 0.1e1 / t601 / t590
  t1198 = 0.3e1 * t426 + t794 + t795 - t796 - t797 + (0.1714584e0 * t1107 - 0.1714584e0 * t1109 * t530 + 0.285764e-1 * t1117 + 0.285764e-1 * t1184 * t591 - 0.857292e-1 * t588 * t602 * t599 + 0.571528e-1 * t600 * t599 * t1192) * t609 - t843 + t845 - t846 - 0.2e1 * t627 - t964 - t805 + t811
  t1199 = -t876 - t842 + t783 - t793 - t880 + t883 + t887 - t891 + t895 - t873 + t788 + t854 + t867
  t1200 = t1198 + t1199
  t1215 = t292 ** 2
  t1218 = 0.57895126195293126240322668836661767023579398340984e3 * t800 * t1215 * t327
  t1219 = t615 ** 2
  t1221 = t415 ** 2
  t1225 = 0.6e1 * t5 * t11 * t1219 / t1221
  t1228 = 0.43374325201206959370528270089546313324629043774840e-1 * t335 * t281 * t354
  t1231 = 0.12842595503380418955085974953824062831138054875329e1 * t335 * t281 * t362
  t1234 = 0.21687162600603479685264135044773156662314521887420e-1 * t335 * t142 * t865
  t1237 = 0.38025319932552508024225805073234468230220037056326e2 * t335 * t142 * t852
  t1240 = 0.86748650402413918741056540179092626649258087549680e-1 * t335 * t281 * t343
  t1243 = 0.13012297560362087811158481026863893997388713132452e0 * t335 * t142 * t786
  t1246 = 0.38527786510141256865257924861472188493414164625988e1 * t335 * t142 * t871
  t1249 = 0.67471172535210825687488420139294265171645179205307e-1 * t335 * t825 * t186
  t1254 = 0.42740000000000000000000000000000000000000000000000e0 * t223 * t884 * t448
  t1258 = 0.28493333333333333333333333333333333333333333333333e0 * t223 * t89 * t290 * t293
  t1263 = 0.62337092780453269534799339101707810596085839394858e3 * t176 * t869 * t352 * t361 * t341
  t1264 = 0.4e1 * t513 * t1200 + t1218 - t1225 - t1228 - t1231 + t1234 + t1237 + t1240 + t1243 - t1246 + t1249 - t1254 - t1258 + t1263
  t1268 = 0.18989649058080861538367470034170805442117582945368e-2 * t171 * t151 * t380 * t72
  t1272 = 0.22911460125803964958438804315545591875812810047162e1 * t223 * t89 * t324 * t328
  t1276 = 0.22161481481481481481481481481481481481481481481481e0 * t223 * t196 * t147 * t168
  t1279 = 0.14246666666666666666666666666666666666666666666666e0 * t223 * t877 * t320
  t1283 = 0.68734380377411894875316412946636775627438430141488e1 * t223 * t141 * t807 * t809
  t1286 = 0.71233333333333333333333333333333333333333333333332e-1 * t223 * t285 * t840
  t1290 = 0.36846163202829085479643115651216588683774907041596e2 * t223 * t141 * t799 * t803
  t1294 = 0.46785788981077169658097909310072427855779642723424e1 * t176 * t789 * t185 * t863
  t1298 = 0.69263436422725855038665932335230900662317599327620e2 * t176 * t358 * t863 * t780
  t1303 = 0.61524113149298439949309167758941162080356015012483e4 * t176 * t848 * t352 * t851 * t341
  t1306 = 0.21053605041484726346144059189532592535100839225540e2 * t176 * t359 * t790
  t1311 = 0.34367190188705947437658206473318387813719215070744e1 * t155 * t324 * t319 * t327 * t166
  t1315 = 0.42740000000000000000000000000000000000000000000000e0 * t155 * t290 * t166 * t320
  t1316 = t319 ** 2
  t1319 = 0.48245938496077605200268890697218139186316165284153e2 * t325 * t1316 * t327
  t1320 = t1268 + t1272 - t1276 + t1279 + t1283 - t1286 - t1290 + t1294 - t1298 - t1303 - t1306 - t1311 + t1315 + t1319
  t1324 = 0.24000000000000000000000000000000000000000000000000e2 * t808 * t1215 * t167
  t1325 = t352 ** 2
  t1329 = 0.35089341735807877243573431982554320891834732042568e1 * t176 * t340 * t1325 * t185
  t1330 = t357 ** 2
  t1332 = t341 ** 2
  t1334 = t360 ** 2
  t1338 = 0.91082604192152556048340974007871726131433263376469e5 * t176 / t1330 * t1332 / t1334
  t1346 = 0.1e1 / t33 * r0 * t923 * t223 / 0.48e2
  t1348 = t815 * t217
  t1350 = t299 * t211
  t1351 = t298 * t1350
  t1353 = t151 * t380
  t1354 = t150 * t1353
  t1356 = t18 * t380
  t1357 = t16 * t1356
  t1359 = t22 ** (-0.25e1)
  t1362 = t1359 * t14 * t923 * t223
  t1364 = t829 * t217
  t1366 = t311 * t1350
  t1368 = t158 * t1353
  t1371 = t40 * t17 * t211
  t1377 = 0.58482236226346462072622386637590534819724553404280e0 * t176 * t178 * (-0.28769444444444444444444444444444444444444444444444e1 * t1346 + 0.27618666666666666666666666666666666666666666666667e2 * t1348 - 0.10229135802469135802469135802469135802469135802469e2 * t1351 + 0.89504938271604938271604938271604938271604938271607e1 * t1354 + 0.31310740740740740740740740740740740740740740740741e1 * t1357 + 0.36677500000000000000000000000000000000000000000000e-1 * t1362 - 0.58684000000000000000000000000000000000000000000000e0 * t1364 + 0.65204444444444444444444444444444444444444444444445e0 * t1366 + 0.57053888888888888888888888888888888888888888888890e0 * t1368 + 0.13490888888888888888888888888888888888888888888889e1 * t1371) * t185
  t1383 = 0.12304822629859687989861833551788232416071203002497e5 * t176 / t357 / t339 * t1332 * t851
  t1387 = 0.62337092780453269534799339101707810596085839394858e3 * t176 * t848 * t1332 * t361
  t1391 = 0.51947577317044391278999449251423175496738199495715e2 * t176 * t358 * t1325 * t361
  t1392 = t411 ** 2
  t1396 = 0.3e1 * t5 * t11 * t1392 * t416
  t1399 = 0.80000000000000000000000000000000000000000000000000e1 * t291 * t840 * t166
  t1402 = 0.11483599538271604938271604938271604938271604938271e-1 * t16 * t1356 * t50
  t1406 = 0.12e2 * t12 * t615 * t625 * t411
  t1409 = 0.60000000000000000000000000000000000000000000000000e1 * t291 * t1316 * t167
  t1412 = 0.36000000000000000000000000000000000000000000000000e2 * t325 * t293 * t319
  t1416 = 0.31035607751564040179390551320631661034531975982628e4 * t800 * t292 * t802 * t319
  t1417 = -t1324 + t1329 - t1338 - t1377 + t1383 - t1387 - t1391 - t1396 - t1399 - t1402 + t1406 - t1409 + t1412 + t1416
  t1420 = 0.57895126195293126240322668836661767023579398340984e3 * t808 * t328 * t319
  t1421 = t323 ** 2
  t1424 = t326 ** 2
  t1428 = 0.24955700379505800914252936827276051226357058527653e5 * t32 / t1421 * t1215 / t1424
  t1432 = 0.4e1 * t12 * t961 * t416 * t424
  t1436 = 0.64327917994770140267025187596290852248421553712204e2 * t325 * t839 * t327 * t166
  t1437 = t61 * t223
  t1442 = t1437 * t141 * t358 * t352 * t361 * t183
  t1443 = 0.19263893255070628432628962430736094246707082312995e1 * t1442
  t1449 = 0.13012297560362087811158481026863893997388713132452e0 * t1437 * t141 * t340 * t183 * t185 * t352
  t1453 = 0.14035736694323150897429372793021728356733892817027e2 * t176 * t869 * t1332 * t185
  t1461 = 0.62071215503128080358781102641263322069063951965254e4 * t32 / t323 / t289 * t1215 * t802
  t1475 = 0.10000000000000000000000000000000000000000000000000e1 * t148 * (-0.21099166666666666666666666666666666666666666666667e1 * t1346 + 0.20255200000000000000000000000000000000000000000000e2 * t1348 - 0.75019259259259259259259259259259259259259259259258e1 * t1351 + 0.65641851851851851851851851851851851851851851851850e1 * t1354 + 0.31003950617283950617283950617283950617283950617285e1 * t1357 + 0.68258333333333333333333333333333333333333333333335e-1 * t1362 - 0.10921333333333333333333333333333333333333333333333e1 * t1364 + 0.12134814814814814814814814814814814814814814814815e1 * t1366 + 0.10617962962962962962962962962962962962962962962963e1 * t1368 + 0.13388493827160493827160493827160493827160493827161e1 * t1371) * t167
  t1496 = 0.1e1 / t41 / t575
  t1498 = t29 * jnp.pi
  t1503 = 0.1e1 / t41 / t742
  t1510 = t28 / t658 / t2
  t1511 = t661 * t3
  t1518 = t57 / t265 / t405 * t38
  t1519 = t269 ** 2
  t1556 = t138 * t299 * t190
  t1564 = t270 ** 2
  t1582 = t365 ** 2
  t1593 = -0.10417857833861955286213817777777777777777777777778e-5 * t1496 * t908 * t1498 * t112 + 0.65736038742361824148148148148148148148148148148147e-1 * t1503 * t27 * t108 * t112 + 0.38922654518503711666666666666666666666666666666667e-1 * t1510 * t1511 * t261 * t131 * t1518 * t139 * t1519 * t270 - 0.27801896084645508333333333333333333333333333333333e-2 * t1510 * t1511 * t129 * t131 * t1518 * t139 * t1519 * t81 + 0.12974218172834570555555555555555555555555555555555e0 * t677 * t368 + 0.25948436345669141111111111111111111111111111111110e0 * t258 * t262 * t675 * t273 - 0.12974218172834570555555555555555555555555555555555e0 * t258 * t371 * t675 * t376 - 0.15569061807401484666666666666666666666666666666667e0 * t660 * t692 * t276 * t698 + 0.15569061807401484666666666666666666666666666666667e0 * t660 * t701 * t276 * t706 + 0.10417857833861955286213817777777777777777777777778e-4 * t909 * t125 * t130 * s0 * t749 * t1556 + 0.66724550603149220000000000000000000000000000000000e-1 * t1510 * t1511 / t690 / t82 * t131 * t1518 * t139 * t1519 * t1564 - 0.10008682590472383000000000000000000000000000000000e0 * t1510 * t1511 * t691 * t131 * t1518 * t139 * t1519 * t695 - 0.25948436345669141111111111111111111111111111111111e-1 * t660 * t662 * t276 * t672 - 0.83405688253936524999999999999999999999999999999999e-2 * t373 * t268 * t139 * t1582 * t81 + 0.16681137650787305000000000000000000000000000000000e-1 * t264 * t268 * t139 * t1582 * t270
  t1603 = t81 * t13 * t151
  t1607 = t237 * t257
  t1610 = t267 * t269
  t1620 = t667 * t94
  t1645 = t1218 - t1228 - t1231 + t1234 + t1237 + t1240 + t1243 - t1246 + t1249 - t1254 - t1258
  t1646 = t1263 + t1268 + t1272 - t1276 + t1279 + t1283 - t1286 - t1290 + t1294 - t1298 - t1303 - t1306
  t1648 = -t1311 + t1315 + t1319 - t1324 + t1329 - t1338 - t1377 + t1383 - t1387 - t1391 - t1399
  t1650 = -t1402 - t1409 + t1412 + t1416 - t1420 + t1428 + t1436 + 0.19263893255070628432628962430736094246707082312994e1 * t1442 - t1449 + t1453 - t1461 + t1475
  t1652 = t1645 + t1646 + t1648 + t1650
  t1664 = t223 * t218 * t257
  t1665 = t262 * s0
  t1670 = t371 * s0
  t1675 = -0.37481074721522092716049382716049382716049382716048e0 * t126 * t130 * s0 * t923 * t192 - 0.25948436345669141111111111111111111111111111111111e-1 * t278 * t900 + 0.87889689262052491166033333333333333333333333333335e-4 * t687 * t137 * t365 * t1603 + 0.17577937852410498233206666666666666666666666666667e-3 * t1607 * t262 * t685 * t1610 * t270 * t13 * t151 - 0.15569061807401484666666666666666666666666666666667e0 * t681 * t776 + 0.77845309037007423333333333333333333333333333333332e-1 * t712 * t770 + 0.10008682590472383000000000000000000000000000000000e0 * t694 * t1620 * t17 * t269 * t695 * t365 - 0.11120758433858203333333333333333333333333333333333e-1 * t373 * t767 * t17 * t897 * t190 - 0.10008682590472383000000000000000000000000000000000e0 * t703 * t1620 * t768 * t271 + 0.16681137650787305000000000000000000000000000000000e-1 * t664 * t1620 * t768 * t374 + 0.22241516867716406666666666666666666666666666666667e-1 * t264 * t767 * t773 * t270 * t897 + 0.27801896084645508333333333333333333333333333333333e-2 * t133 * t138 * t139 * t1652 * t81 - 0.49431771238499713816666666666666666666666666666668e-4 * t223 * t650 * t651 * t137 * t366 - 0.98863542476999427633333333333333333333333333333334e-4 * t1664 * t1665 * t267 * t271 + 0.49431771238499713816666666666666666666666666666668e-4 * t1664 * t1670 * t267 * t374
  t1693 = 0.1e1 / t575
  t1699 = t117 * t257
  t1701 = t119 * t266
  t1703 = t365 * t189 * t81
  t1709 = t189 * t270 * t365
  t1727 = t659 * t661
  t1728 = t1727 * t691
  t1730 = t666 * t669
  t1731 = t1730 * t695
  t1735 = t1727 * t261
  t1737 = t1730 * t270
  t1754 = 0.36249965574899790132222222222222222222222222222222e-3 * t744 * t125 * t651 * t655 - 0.58593126174701660777355555555555555555555555555558e-5 * t750 * t125 * t651 * t1556 + 0.49974766295362790288065843621399176954732510288065e0 * t86 * t913 * t95 - 0.45144050613401806240259877037037037037037037037037e-4 * t911 * t577 * t57 * t91 * t752 + 0.14908695437785200353349358024691358024691358024692e-2 * t239 * t1693 * t57 * t91 * t223 - 0.59318125486199656580000000000000000000000000000000e-2 * t1699 * t1670 * t1701 * t1703 + 0.11863625097239931316000000000000000000000000000000e-1 * t1699 * t1665 * t1701 * t1709 - 0.11687867688391932333540740740740740740740740740740e0 * t118 * t110 * t1503 * t57 * t91 + 0.18522951228606556498888168008888888888888888888889e-5 * t24 / t907 / t26 * t1498 * t110 * t1496 * t57 * t91 + 0.11863625097239931316000000000000000000000000000000e-1 * t117 * t1728 * t247 * t1731 - 0.11863625097239931316000000000000000000000000000000e-1 * t117 * t1735 * t247 * t1737 - 0.83850930471232847881604938271604938271604938271605e-3 * t1693 * t116 * t219 * t224 - 0.35590875291719793947999999999999999999999999999999e-1 * t763 * t756 * t727 + 0.17795437645859896974000000000000000000000000000000e-1 * t738 * t756 * t734 - 0.17795437645859896974000000000000000000000000000000e-1 * t245 * t756 * t719
  t1759 = t1727 * t129
  t1761 = t1730 * t81
  t1769 = t221 * t266
  t1777 = t136 * t897 * t81
  t1817 = 0.70742357061319590439851851851851851851851851851852e-1 * t245 * t971 * t57 * t231 + 0.19772708495399885526666666666666666666666666666667e-2 * t117 * t1759 * t247 * t1761 + 0.25390354675704053003520740740740740740740740740741e-4 * t577 * t236 * t219 * t753 + 0.33362275301574610000000000000000000000000000000000e-2 * t733 * t1769 * t1703 - 0.66724550603149220000000000000000000000000000000000e-2 * t725 * t1769 * t1709 + 0.19772708495399885526666666666666666666666666666667e-2 * t245 * t247 * t1777 - 0.87889689262052491166033333333333333333333333333335e-4 * t1607 * t371 * t685 * t1610 * t1603 - 0.64452438792171826855091111111111111111111111111112e-3 * t684 * t130 * s0 * t743 * t655 + 0.66724550603149220000000000000000000000000000000000e-2 * t107 * t1735 * t221 * t1737 - 0.11120758433858203333333333333333333333333333333333e-2 * t107 * t1759 * t221 * t1761 + 0.10008682590472383000000000000000000000000000000000e-1 * t715 * t720 + 0.20017365180944766000000000000000000000000000000000e-1 * t212 * t724 * t728 - 0.10008682590472383000000000000000000000000000000000e-1 * t212 * t732 * t735 - 0.11120758433858203333333333333333333333333333333333e-2 * t229 * t221 * t1777 - 0.39787602396692683037037037037037037037037037037037e-1 * t903 * t228 * t232 - 0.66724550603149220000000000000000000000000000000000e-2 * t107 * t1728 * t221 * t1731
  t1842 = t386 ** 2
  t1853 = t100 ** 2
  t1856 = t203 ** 2
  t1880 = 0.18750000000000000000000000000000000000000000000000e1 * t204 * t365 * t393 - 0.18750000000000000000000000000000000000000000000000e1 * t204 * t269 * t942 - 0.60000000000000000000000000000000000000000000000000e1 * t398 * t257 * t957 * t374 + 0.37500000000000000000000000000000000000000000000000e1 * t636 * t189 * t29 * t79 * t81 * t386 - 0.10000000000000000000000000000000000000000000000000e1 * t931 * t189 * t393 + 0.25000000000000000000000000000000000000000000000000e0 * t208 * (t1593 + t1675 + t1754 + t1817) * t82 - 0.10000000000000000000000000000000000000000000000000e1 * t390 * t669 * t723 * t956 * t81 - 0.10000000000000000000000000000000000000000000000000e1 * t397 * t1652 * t29 * t400 + 0.30000000000000000000000000000000000000000000000000e1 * t397 * t1582 * t125 * t408 + 0.42187500000000000000000000000000000000000000000000e1 * t631 * t203 * t637 - 0.28125000000000000000000000000000000000000000000000e1 * t633 * t189 * t393 - 0.93750000000000000000000000000000000000000000000000e0 * t103 * t1842 * t82 + 0.30000000000000000000000000000000000000000000000000e1 * t390 * t365 * t125 * t950 - 0.10000000000000000000000000000000000000000000000000e1 * t390 * t897 * t393 - 0.22851562500000000000000000000000000000000000000000e1 / t101 / t1853 * t1856 * t82 - 0.15000000000000000000000000000000000000000000000000e1 * t387 * t365 * t393 + 0.15000000000000000000000000000000000000000000000000e1 * t387 * t269 * t942 + 0.40000000000000000000000000000000000000000000000000e1 * t945 * t125 * t950 + 0.10000000000000000000000000000000000000000000000000e1 * t397 * t1519 * t659 * t661 / t265 / t134 * t81 - 0.12500000000000000000000000000000000000000000000000e1 * t636 * t82 * t930
  t1883 = t5 * t11 * t1880 * t612
  t1886 = s0 * t1503
  t1891 = 0.5e1 / 0.9e1 * (0.6160e4 / 0.81e2 * tau0 * t644 - 0.2618e4 / 0.81e2 * t1886) * t455 * t461
  t1892 = f.my_piecewise3(t470, t1891, 0)
  t1901 = t987 ** 2
  t1904 = t991 ** 2
  t1927 = t1018 ** 2
  t1933 = t1022 ** 2
  t1936 = f.my_piecewise3(t469, 0, (-0.64e0 * t1892 * t481 - 0.512e1 * t977 * t485 * t478 - 0.2304e2 * t987 * t994 * t991 - 0.384e1 * t1901 * t485 - 0.1536e2 * t1904 * t998 - 0.1536e2 * t479 / t997 / t480 * t1904 - 0.2304e2 * t999 * t991 * t987 - 0.384e1 * t1002 * t1901 - 0.512e1 * t1002 * t478 * t977 - 0.64e0 * t486 * t1892) * t492 + 0.4e1 * t1008 * t489 * t492 + 0.3e1 * t1927 * t492 + 0.6e1 * t1018 * t1022 * t492 + t1933 * t492)
  t1937 = t1029 ** 2
  t1946 = t1037 ** 2
  t1961 = f.my_piecewise3(t500, 0, t1891)
  t1975 = t1027 ** 2
  t1980 = -0.2520e2 * t1042 * t1937 * t509 - 0.3780e2 * t1084 * t1038 - 0.56700e2 * t1055 * t1937 * t509 - 0.630e1 * t1035 * t1946 * t509 - 0.56700e2 * t1042 * t1029 * t1038 - 0.840e1 * t1036 * t509 * t1046 - 0.283500e2 / t1027 / t1034 * t1937 * t509 - 0.105e1 * t504 * t1961 * t509 - 0.6300e1 * t1028 * t1046 * t1051 - 0.4725e1 * t1028 * t1946 * t509 - 0.141750e2 * t1055 * t1037 * t1029 * t509 - 0.354375e1 / t1975 * t1937 * t509
  t1981 = f.my_piecewise3(t500, 0, t1980)
  t1982 = f.my_piecewise3(t464, t1936, t1981)
  t1984 = -t1218 + t1225 + t1228 + t1231 - t1234 - t1237 - t1240 - t1243 + t1246 - t1249 + t1254 + t1258 - t1263
  t1985 = -t1268 - t1272 + t1276 - t1279 - t1283 + t1286 + t1290 - t1294 + t1298 + t1303 + t1306 + t1311 - t1315
  t1987 = -t1319 + t1324 - t1329 + t1338 + t1377 - t1383 + t1387 + t1391 + t1396 + t1399 + t1402 - t1406 + t1409
  t1988 = t523 ** 2
  t1989 = t1125 * t1988
  t1993 = t530 ** 2
  t1994 = t519 * t1993
  t2004 = t526 * (-0.24694444444444444444444444444444444444444444444444e-1 * t1346 + 0.23706666666666666666666666666666666666666666666666e0 * t1348 - 0.87802469135802469135802469135802469135802469135800e-1 * t1351 + 0.76827160493827160493827160493827160493827160493827e-1 * t1354 + 0.10849222222222222222222222222222222222222222222222e0 * t1357)
  t2025 = t565 ** 2
  t2029 = t574 ** 2
  t2069 = 0.80000000000000000000000000000000000000000000000000e1 * t1109 * t545 * t1116 - 0.36000000000000000000000000000000000000000000000000e2 * t1125 * t523 * t1121 - 0.60000000000000000000000000000000000000000000000000e1 * t1143 * t530 * t523 * t535 * t544 - 0.12141199215318793217471755882535185185185185185184e-1 * t552 * t1150 * t1155 + 0.34140227367002173333333333333333333333333333333332e0 * t1107 * t558 * t561 - 0.31295208419751992222222222222222222222222222222221e0 * t1139 * t1159 - 0.57489400170562495257927652663499439366228807233633e-3 * t564 / t542 / t2025 * t1166 * t2029 / t41 / t1169 / t742 * t455 * t461 + 0.12435099051571559301165135467231908156473707960740e-1 * t555 * t535 * t1164 * t1166 * t1167 * t1171 - 0.22011544503327960296120090757411011659807956104251e0 * t570 * t573 * t574 / t19 / t1169 / r0 + 0.13793073340557359534979423868312757201646090534979e1 * t583 * t461 * t1886 - 0.36000000000000000000000000000000000000000000000000e2 * t552 * t1121 + 0.40000000000000000000000000000000000000000000000000e1 * t551 * t1116 * t1136 + 0.68393044783643576156408245069775494860605393784069e-1 * t1165 * t1168 / t1169 / t209 + 0.31295208419751992222222222222222222222222222222221e0 * t1147 * t1159 + 0.62590416839503984444444444444444444444444444444441e0 * t1129 * t1159
  t2108 = t550 ** 2
  t2125 = -0.89035460912337816928126209805258024691358024691350e-1 * t1151 * t1152 * t1153 * t1176 + 0.97362870639228420246913580246913580246913580246908e0 * t559 * t536 * t537 * t644 + 0.34140227367002173333333333333333333333333333333332e0 * t1126 * t558 * t561 - 0.24282398430637586434943511765070370370370370370368e-1 * t524 * t1150 * t1155 + 0.56900378945003622222222222222222222222222222222220e-1 * t1117 * t558 * t561 + 0.12141199215318793217471755882535185185185185185184e-1 * t531 * t1150 * t1155 + 0.56900378945003622222222222222222222222222222222220e-1 * t1144 * t558 * t561 + 0.60000000000000000000000000000000000000000000000000e1 * t1994 * t545 + 0.36000000000000000000000000000000000000000000000000e2 * t1143 * t1988 * t545 + 0.30000000000000000000000000000000000000000000000000e1 * t551 * t1993 * t545 + 0.24000000000000000000000000000000000000000000000000e2 * t1989 * t545 + 0.12000000000000000000000000000000000000000000000000e2 / t550 / t518 * t1988 * t545 + 0.10000000000000000000000000000000000000000000000000e1 / t2108 * t1988 * t545 - 0.10000000000000000000000000000000000000000000000000e1 * t2004 * t545 - 0.34140227367002173333333333333333333333333333333332e0 * t1109 * t558 * t455 * t461 * t246 * t530 - 0.17070113683501086666666666666666666666666666666666e0 * t1134 * t1135 * t557 * t561
  t2135 = t588 ** 2
  t2138 = t600 ** 2
  t2139 = t601 ** 2
  t2145 = -t1412 - t1416 + t1420 - t1428 + t1432 - t1436 - t1443 + t1449 - t1453 + t1461 - t1475 - t1883 + (-0.6858336e0 * t1989 + 0.10287504e1 * t552 * t530 - 0.1714584e0 * t1994 - 0.2286112e0 * t1109 * t1116 + 0.285764e-1 * t2004 + 0.285764e-1 * (t2069 + t2125) * t591 - 0.1143056e0 * t1184 * t602 * t599 + 0.3429168e0 * t588 * t1192 * t600 - 0.857292e-1 * t2135 * t602 - 0.1714584e0 * t2138 / t2139) * t609
  t2151 = -t1420 + t1428 - t1432 + t1436 + t1443 - t1449 + t1453 + 0.4e1 * t1061 * t1098 - t1461 + t1475 + t1883 + t1982 * t1070 + t1104 * (t1984 + t1985 + t1987 + t2145) + 0.6e1 * t1089 * t619
  t2155 = 0.12e2 * t1089 * t1098 + 0.4e1 * t1104 * t1200 + 0.40000000000000000000000000000000000000000000000000e1 * t841 - 0.20779030926817756511599779700569270198695279798286e3 * t782 + 0.14035736694323150897429372793021728356733892817027e2 * t792 + 0.28493333333333333333333333333333333333333333333333e0 * t879 - 0.21370000000000000000000000000000000000000000000000e0 * t882 - 0.34367190188705947437658206473318387813719215070744e1 * t886 + 0.42740000000000000000000000000000000000000000000000e0 * t890 - 0.22787578869697033846040964041004966530541099534442e-2 * t894 + 0.41558061853635513023199559401138540397390559596572e3 * t872 - 0.14035736694323150897429372793021728356733892817027e2 * t787 - 0.41016075432865626632872778505960774720237343341655e4 * t853 - 0.23392894490538584829048954655036213927889821361712e1 * t866 + r0 * (t1264 + t1320 + t1417 + t2151)
  v4rho4_0_ = t1073 + t2155

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = jnp.log(0.2e1)
  t2 = 0.1e1 - t1
  t3 = jnp.pi ** 2
  t5 = t2 / t3
  t6 = r0 - r1
  t7 = r0 + r1
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t10 = 0.1e1 + t9
  t11 = t10 <= f.p.zeta_threshold
  t12 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t13 = t12 ** 2
  t14 = t10 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t16 = f.my_piecewise3(t11, t13, t15)
  t17 = 0.1e1 - t9
  t18 = t17 <= f.p.zeta_threshold
  t19 = t17 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = f.my_piecewise3(t18, t13, t20)
  t23 = t16 / 0.2e1 + t21 / 0.2e1
  t24 = t23 ** 2
  t25 = t24 * t23
  t26 = 3 ** (0.1e1 / 0.3e1)
  t28 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t29 = t26 * t28
  t30 = 4 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = t7 ** (0.1e1 / 0.3e1)
  t35 = t29 * t31 / t32
  t37 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e-1 * t35
  t39 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t35
  t40 = 0.1e1 / t39
  t42 = 0.1e1 / t2
  t43 = t37 * t40 * t42
  t45 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t35
  t46 = jnp.sqrt(t35)
  t49 = t35 ** 0.15e1
  t51 = t26 ** 2
  t52 = t28 ** 2
  t53 = t51 * t52
  t54 = t32 ** 2
  t57 = t53 * t30 / t54
  t59 = 0.37978500000000000000000000000000000000000000000000e1 * t46 + 0.89690000000000000000000000000000000000000000000000e0 * t35 + 0.20477500000000000000000000000000000000000000000000e0 * t49 + 0.12323500000000000000000000000000000000000000000000e0 * t57
  t62 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t59
  t63 = jnp.log(t62)
  t65 = 0.621814e-1 * t45 * t63
  t66 = t6 ** 2
  t67 = t66 ** 2
  t68 = t7 ** 2
  t69 = t68 ** 2
  t70 = 0.1e1 / t69
  t71 = t67 * t70
  t72 = t12 * f.p.zeta_threshold
  t73 = t14 * t10
  t74 = f.my_piecewise3(t11, t72, t73)
  t75 = t19 * t17
  t76 = f.my_piecewise3(t18, t72, t75)
  t77 = t74 + t76 - 0.2e1
  t78 = 2 ** (0.1e1 / 0.3e1)
  t79 = t78 - 0.1e1
  t81 = 0.1e1 / t79 / 0.2e1
  t82 = t77 * t81
  t84 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t35
  t89 = 0.70594500000000000000000000000000000000000000000000e1 * t46 + 0.15494250000000000000000000000000000000000000000000e1 * t35 + 0.42077500000000000000000000000000000000000000000000e0 * t49 + 0.15629250000000000000000000000000000000000000000000e0 * t57
  t92 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t89
  t93 = jnp.log(t92)
  t97 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t35
  t102 = 0.51785000000000000000000000000000000000000000000000e1 * t46 + 0.90577500000000000000000000000000000000000000000000e0 * t35 + 0.11003250000000000000000000000000000000000000000000e0 * t49 + 0.12417750000000000000000000000000000000000000000000e0 * t57
  t105 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t102
  t106 = jnp.log(t105)
  t107 = t97 * t106
  t109 = -0.3109070e-1 * t84 * t93 + t65 - 0.19751673498613801407483339618206552048944131217655e-1 * t107
  t110 = t82 * t109
  t111 = t71 * t110
  t113 = 0.19751673498613801407483339618206552048944131217655e-1 * t82 * t107
  t115 = (-t65 + t111 + t113) * t42
  t116 = 0.1e1 / t25
  t117 = t3 * t116
  t119 = jnp.exp(-t115 * t117)
  t120 = t119 - 0.1e1
  t121 = 0.1e1 / t120
  t122 = t3 * t121
  t124 = s0 + 0.2e1 * s1 + s2
  t125 = t122 * t124
  t126 = t43 * t125
  t128 = 0.1e1 / t32 / t68
  t129 = t128 * t78
  t130 = 0.1e1 / t24
  t132 = 0.1e1 / t28
  t133 = t51 * t132
  t134 = t133 * t30
  t138 = 0.1e1 + 0.27801896084645508333333333333333333333333333333333e-2 * t126 * t129 * t130 * t134
  t139 = t138 ** (0.1e1 / 0.4e1)
  t141 = 0.1e1 / t139 / t138
  t142 = t68 * t7
  t144 = 0.1e1 / t54 / t142
  t145 = t144 * t40
  t146 = t42 * t3
  t147 = t145 * t146
  t148 = t121 * t124
  t149 = t78 * t130
  t150 = t148 * t149
  t152 = 0.27801896084645508333333333333333333333333333333333e-3 * t147 * t150
  t153 = t39 ** 2
  t154 = 0.1e1 / t153
  t155 = t37 * t154
  t156 = t155 * t146
  t161 = 0.49431771238499713816666666666666666666666666666666e-3 * t156 * t148 * t144 * t78 * t130
  t162 = t120 ** 2
  t163 = 0.1e1 / t162
  t164 = t3 * t163
  t165 = t124 * t128
  t167 = t43 * t164 * t165
  t168 = t149 * t51
  t169 = t132 * t30
  t171 = 0.1e1 / t32 / t7
  t172 = t31 * t171
  t174 = t29 * t172 * t63
  t175 = 0.11073470983333333333333333333333333333333333333333e-2 * t174
  t176 = t59 ** 2
  t177 = 0.1e1 / t176
  t178 = t45 * t177
  t180 = 0.1e1 / t46 * t26
  t181 = t28 * t31
  t182 = t181 * t171
  t183 = t180 * t182
  t185 = t29 * t172
  t187 = t35 ** 0.5e0
  t188 = t187 * t26
  t189 = t188 * t182
  t194 = t53 * t30 / t54 / t7
  t196 = -0.63297500000000000000000000000000000000000000000000e0 * t183 - 0.29896666666666666666666666666666666666666666666667e0 * t185 - 0.10238750000000000000000000000000000000000000000000e0 * t189 - 0.82156666666666666666666666666666666666666666666667e-1 * t194
  t197 = 0.1e1 / t62
  t198 = t196 * t197
  t199 = t178 * t198
  t200 = 0.10000000000000000000000000000000000000000000000000e1 * t199
  t201 = t66 * t6
  t202 = t201 * t70
  t203 = t202 * t110
  t204 = 0.4e1 * t203
  t205 = t69 * t7
  t206 = 0.1e1 / t205
  t207 = t67 * t206
  t208 = t207 * t110
  t209 = 0.4e1 * t208
  t210 = 0.1e1 / t68
  t211 = t6 * t210
  t212 = t8 - t211
  t215 = f.my_piecewise3(t11, 0, 0.4e1 / 0.3e1 * t14 * t212)
  t216 = -t212
  t219 = f.my_piecewise3(t18, 0, 0.4e1 / 0.3e1 * t19 * t216)
  t221 = (t215 + t219) * t81
  t222 = t221 * t109
  t223 = t71 * t222
  t227 = t89 ** 2
  t228 = 0.1e1 / t227
  t229 = t84 * t228
  t234 = -0.11765750000000000000000000000000000000000000000000e1 * t183 - 0.51647500000000000000000000000000000000000000000000e0 * t185 - 0.21038750000000000000000000000000000000000000000000e0 * t189 - 0.10419500000000000000000000000000000000000000000000e0 * t194
  t235 = 0.1e1 / t92
  t236 = t234 * t235
  t242 = t102 ** 2
  t243 = 0.1e1 / t242
  t244 = t97 * t243
  t249 = -0.86308333333333333333333333333333333333333333333334e0 * t183 - 0.30192500000000000000000000000000000000000000000000e0 * t185 - 0.55016250000000000000000000000000000000000000000000e-1 * t189 - 0.82785000000000000000000000000000000000000000000000e-1 * t194
  t250 = 0.1e1 / t105
  t251 = t249 * t250
  t254 = 0.53237641966666666666666666666666666666666666666666e-3 * t29 * t172 * t93 + 0.10000000000000000000000000000000000000000000000000e1 * t229 * t236 - t175 - t200 + 0.18311447306006545054854346104378990962041954983034e-3 * t29 * t172 * t106 + 0.58482236226346462072622386637590534819724553404280e0 * t244 * t251
  t255 = t82 * t254
  t256 = t71 * t255
  t257 = t221 * t107
  t258 = 0.19751673498613801407483339618206552048944131217655e-1 * t257
  t259 = t82 * t26
  t261 = t181 * t171 * t106
  t262 = t259 * t261
  t263 = 0.18311447306006545054854346104378990962041954983034e-3 * t262
  t264 = t82 * t97
  t266 = t243 * t249 * t250
  t267 = t264 * t266
  t268 = 0.58482236226346462072622386637590534819724553404280e0 * t267
  t270 = (t175 + t200 + t204 - t209 + t223 + t256 + t258 - t263 - t268) * t42
  t272 = t24 ** 2
  t273 = 0.1e1 / t272
  t274 = t3 * t273
  t275 = 0.1e1 / t14
  t278 = f.my_piecewise3(t11, 0, 0.2e1 / 0.3e1 * t275 * t212)
  t279 = 0.1e1 / t19
  t282 = f.my_piecewise3(t18, 0, 0.2e1 / 0.3e1 * t279 * t216)
  t284 = t278 / 0.2e1 + t282 / 0.2e1
  t285 = t274 * t284
  t288 = 0.3e1 * t115 * t285 - t270 * t117
  t289 = t288 * t119
  t291 = t168 * t169 * t289
  t295 = 0.1e1 / t32 / t142
  t296 = t295 * t78
  t300 = 0.64871090864172852777777777777777777777777777777777e-2 * t126 * t296 * t130 * t134
  t301 = t129 * t116
  t303 = t133 * t30 * t284
  t307 = -t152 + t161 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t291 - t300 - 0.55603792169291016666666666666666666666666666666666e-2 * t126 * t301 * t303
  t308 = t141 * t307
  t312 = 0.1e1 - 0.1e1 / t139
  t316 = 0.25000000000000000000000000000000000000000000000000e0 * t308 * t120 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t288 * t119
  t320 = 0.1e1 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t120
  t321 = 0.1e1 / t320
  t323 = t5 * t25 * t316 * t321
  t325 = r0 ** (0.1e1 / 0.3e1)
  t326 = t325 ** 2
  t329 = tau0 / t326 / r0
  t330 = t10 / 0.2e1
  t331 = t330 ** (0.1e1 / 0.3e1)
  t332 = t331 ** 2
  t333 = t332 * t330
  t335 = r1 ** (0.1e1 / 0.3e1)
  t336 = t335 ** 2
  t339 = tau1 / t336 / r1
  t340 = t17 / 0.2e1
  t341 = t340 ** (0.1e1 / 0.3e1)
  t342 = t341 ** 2
  t343 = t342 * t340
  t346 = 0.1e1 / t54 / t68
  t350 = 6 ** (0.1e1 / 0.3e1)
  t351 = (t329 * t333 + t339 * t343 - t124 * t346 / 0.8e1) * t350
  t352 = t3 ** (0.1e1 / 0.3e1)
  t353 = t352 ** 2
  t354 = 0.1e1 / t353
  t355 = t333 + t343
  t357 = t354 / t355
  t359 = 0.5e1 / 0.9e1 * t351 * t357
  t360 = t359 <= 0.1e1
  t361 = jnp.log(DBL_EPSILON)
  t364 = t361 / (-t361 + 0.64e0)
  t365 = -t364 < t359
  t366 = t359 < -t364
  t367 = r0 ** 2
  t370 = tau0 / t326 / t367
  t373 = t212 / 0.2e1
  t374 = t332 * t373
  t377 = -t373
  t378 = t342 * t377
  t381 = t124 * t144
  t382 = t381 / 0.3e1
  t384 = (-0.5e1 / 0.3e1 * t370 * t333 + 0.5e1 / 0.3e1 * t329 * t374 + 0.5e1 / 0.3e1 * t339 * t378 + t382) * t350
  t386 = t355 ** 2
  t388 = t354 / t386
  t390 = 0.5e1 / 0.3e1 * t374 + 0.5e1 / 0.3e1 * t378
  t391 = t388 * t390
  t394 = -0.5e1 / 0.9e1 * t351 * t391 + 0.5e1 / 0.9e1 * t384 * t357
  t395 = f.my_piecewise3(t366, t394, 0)
  t396 = f.my_piecewise3(t366, t359, -t364)
  t397 = 0.1e1 - t396
  t398 = 0.1e1 / t397
  t401 = t397 ** 2
  t402 = 0.1e1 / t401
  t403 = t396 * t402
  t406 = -0.64e0 * t395 * t398 - 0.64e0 * t403 * t395
  t409 = jnp.exp(-0.64e0 * t396 * t398)
  t411 = f.my_piecewise3(t365, 0, t406 * t409)
  t413 = jnp.log(0.14285714285714285714285714285714285714285714285714e1 * DBL_EPSILON)
  t416 = (-t413 + 0.15e1) / t413
  t417 = t359 < -t416
  t418 = f.my_piecewise3(t417, -t416, t359)
  t419 = 0.1e1 - t418
  t420 = t419 ** 2
  t421 = 0.1e1 / t420
  t422 = f.my_piecewise3(t417, 0, t394)
  t426 = jnp.exp(0.15e1 / t419)
  t429 = f.my_piecewise3(t417, 0, -0.105e1 * t421 * t422 * t426)
  t430 = f.my_piecewise3(t360, t411, t429)
  t433 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t46 + 0.31385250000000000000000000000000000000000000000000e-1 * t35
  t434 = 0.1e1 / t433
  t437 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t434)
  t438 = t437 - 0.1e1
  t439 = t350 * t354
  t440 = t78 ** 2
  t441 = t440 * t124
  t445 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t439 * t441 * t346
  t446 = t445 ** (0.1e1 / 0.4e1)
  t448 = 0.1e1 - 0.1e1 / t446
  t450 = t438 * t448 + 0.1e1
  t451 = jnp.log(t450)
  t453 = -0.285764e-1 * t434 + 0.285764e-1 * t451
  t457 = 0.1e1 - 0.2363e1 * t79 * t77 * t81
  t458 = t453 * t457
  t459 = t67 ** 2
  t460 = t459 * t67
  t461 = t69 ** 2
  t463 = 0.1e1 / t461 / t69
  t465 = -t460 * t463 + 0.1e1
  t467 = jnp.log(t320)
  t470 = -t5 * t25 * t467 + t458 * t465 - t111 - t113 + t65
  t471 = t430 * t470
  t473 = t5 * t24
  t474 = t316 * t321
  t477 = 0.6e1 * t473 * t474 * t284
  t478 = t242 ** 2
  t479 = 0.1e1 / t478
  t480 = t249 ** 2
  t482 = t105 ** 2
  t483 = 0.1e1 / t482
  t486 = 0.17315859105681463759666483083807725165579399831905e2 * t264 * t479 * t480 * t483
  t488 = t221 * t97 * t266
  t489 = 0.11696447245269292414524477327518106963944910680856e1 * t488
  t494 = t52 * t30 * t346
  t495 = 0.1e1 / t46 / t35 * t51 * t494
  t497 = t181 * t128
  t498 = t180 * t497
  t500 = t31 * t128
  t501 = t29 * t500
  t503 = t35 ** (-0.5e0)
  t505 = t503 * t51 * t494
  t507 = t188 * t497
  t510 = t53 * t30 * t346
  t512 = -0.57538888888888888888888888888888888888888888888889e0 * t495 + 0.11507777777777777777777777777777777777777777777778e1 * t498 + 0.40256666666666666666666666666666666666666666666667e0 * t501 + 0.36677500000000000000000000000000000000000000000000e-1 * t505 + 0.73355000000000000000000000000000000000000000000000e-1 * t507 + 0.13797500000000000000000000000000000000000000000000e0 * t510
  t516 = 0.58482236226346462072622386637590534819724553404280e0 * t264 * t243 * t512 * t250
  t518 = 0.1e1 / t242 / t102
  t522 = 0.11696447245269292414524477327518106963944910680856e1 * t264 * t518 * t480 * t250
  t523 = 0.1e1 / t15
  t524 = t212 ** 2
  t527 = 0.1e1 / t142
  t528 = t6 * t527
  t529 = -t210 + t528
  t530 = 0.2e1 * t529
  t534 = f.my_piecewise3(t11, 0, 0.4e1 / 0.9e1 * t523 * t524 + 0.4e1 / 0.3e1 * t14 * t530)
  t535 = 0.1e1 / t20
  t536 = t216 ** 2
  t539 = -t530
  t543 = f.my_piecewise3(t18, 0, 0.4e1 / 0.9e1 * t535 * t536 + 0.4e1 / 0.3e1 * t19 * t539)
  t545 = (t534 + t543) * t81
  t547 = 0.19751673498613801407483339618206552048944131217655e-1 * t545 * t107
  t551 = t196 ** 2
  t554 = 0.20000000000000000000000000000000000000000000000000e1 * t45 / t176 / t59 * t551 * t197
  t556 = t71 * t545 * t109
  t558 = t221 * t26 * t261
  t559 = 0.36622894612013090109708692208757981924083909966068e-3 * t558
  t563 = 0.24415263074675393406472461472505321282722606644045e-3 * t259 * t181 * t128 * t106
  t564 = t29 * t31
  t568 = 0.35616666666666666666666666666666666666666666666666e-1 * t564 * t171 * t177 * t198
  t569 = f.my_piecewise3(t365, 0, t409)
  t571 = f.my_piecewise3(t417, 0, -0.7e0 * t426)
  t572 = f.my_piecewise3(t360, t569, t571)
  t573 = t433 ** 2
  t578 = -0.74083333333333333333333333333333333333333333333333e-2 * t183 - 0.10461750000000000000000000000000000000000000000000e-1 * t185
  t579 = t578 ** 2
  t580 = 0.1e1 / t573 / t433 * t579
  t582 = 0.1e1 / t573
  t587 = t582 * (-0.49388888888888888888888888888888888888888888888889e-2 * t495 + 0.98777777777777777777777777777777777777777777777777e-2 * t498 + 0.13949000000000000000000000000000000000000000000000e-1 * t501)
  t589 = t437 * t448
  t594 = t573 ** 2
  t599 = t582 * t578
  t601 = 0.1e1 / t446 / t445
  t608 = t445 ** 2
  t612 = t350 ** 2
  t617 = t124 ** 2
  t626 = t438 * t601 * t350
  t627 = t354 * t440
  t629 = 0.1e1 / t54 / t69
  t630 = t124 * t629
  t635 = 0.1e1 / t450
  t643 = -0.10000000000000000000000000000000000000000000000000e1 * t599 * t589 - 0.14225094736250905555555555555555555555555555555555e-1 * t626 * t627 * t381
  t644 = t643 ** 2
  t645 = t450 ** 2
  t651 = (-0.571528e-1 * t580 + 0.285764e-1 * t587 + 0.285764e-1 * (0.20000000000000000000000000000000000000000000000000e1 * t580 * t589 - 0.10000000000000000000000000000000000000000000000000e1 * t587 * t589 + 0.10000000000000000000000000000000000000000000000000e1 / t594 * t579 * t589 + 0.28450189472501811111111111111111111111111111111110e-1 * t599 * t437 * t601 * t439 * t441 * t144 - 0.20235332025531322029119593137558641975308641975307e-2 * t438 / t446 / t608 * t612 / t352 / t3 * t78 * t617 / t32 / t69 / t142 + 0.52158680699586653703703703703703703703703703703702e-1 * t626 * t627 * t630) * t635 - 0.285764e-1 * t644 / t645) * t457 * t465
  t655 = 0.285764e-1 * t599 + 0.285764e-1 * t643 * t635
  t656 = t655 * t457
  t657 = t459 * t201
  t658 = t657 * t463
  t660 = 0.1e1 / t461 / t205
  t661 = t460 * t660
  t663 = -0.12e2 * t658 + 0.12e2 * t661
  t664 = t656 * t663
  t668 = 0.132e3 * t459 * t66 * t463
  t670 = 0.288e3 * t657 * t660
  t671 = t69 * t68
  t675 = 0.156e3 * t460 / t461 / t671
  t681 = 0.10843581300301739842632067522386578331157260943710e-1 * t82 * t29 * t172 * t266
  t691 = 0.10000000000000000000000000000000000000000000000000e1 * t178 * (-0.42198333333333333333333333333333333333333333333333e0 * t495 + 0.84396666666666666666666666666666666666666666666666e0 * t498 + 0.39862222222222222222222222222222222222222222222223e0 * t501 + 0.68258333333333333333333333333333333333333333333333e-1 * t505 + 0.13651666666666666666666666666666666666666666666667e0 * t507 + 0.13692777777777777777777777777777777777777777777778e0 * t510) * t197
  t692 = t176 ** 2
  t695 = t62 ** 2
  t699 = 0.16081979498692535066756296899072713062105388428051e2 * t45 / t692 * t551 / t695
  t700 = -t477 + t486 + t489 + t516 - t522 - t547 + t554 - t556 + t559 - t563 + t568 + t651 + 0.2e1 * t664 + t458 * (-t668 + t670 - t675) - t681 - t691 - t699
  t701 = t453 * t79
  t708 = t655 * t79
  t709 = t221 * t465
  t710 = t708 * t709
  t714 = 0.12e2 * t66 * t70 * t110
  t717 = 0.32e2 * t201 * t206 * t110
  t718 = t202 * t222
  t719 = 0.8e1 * t718
  t721 = 0.8e1 * t202 * t255
  t723 = t71 * t221 * t254
  t724 = 0.2e1 * t723
  t725 = t207 * t222
  t726 = 0.8e1 * t725
  t728 = 0.8e1 * t207 * t255
  t729 = t138 ** 2
  t731 = 0.1e1 / t139 / t729
  t732 = t307 ** 2
  t736 = t288 ** 2
  t745 = 0.16681137650787305000000000000000000000000000000000e-2 * t629 * t40 * t146 * t150
  t746 = t78 * t116
  t747 = t746 * t284
  t749 = t147 * t148 * t747
  t760 = 0.14648281543675415194338888888888888888888888888889e-4 * t37 / t153 / t39 * t42 * t125 * t206 * t78 * t130 * t564
  t761 = t146 * t163
  t762 = t145 * t761
  t763 = t124 * t78
  t765 = t130 * t288 * t119
  t767 = t762 * t763 * t765
  t773 = 0.29659062743099828290000000000000000000000000000000e-2 * t156 * t148 * t629 * t78 * t130
  t774 = t146 * t121
  t775 = t155 * t774
  t777 = t775 * t381 * t747
  t779 = 0.1e1 / t73
  t785 = f.my_piecewise3(t11, 0, -0.2e1 / 0.9e1 * t779 * t524 + 0.2e1 / 0.3e1 * t275 * t530)
  t786 = 0.1e1 / t75
  t792 = f.my_piecewise3(t18, 0, -0.2e1 / 0.9e1 * t786 * t536 + 0.2e1 / 0.3e1 * t279 * t539)
  t794 = t785 / 0.2e1 + t792 / 0.2e1
  t806 = 0.21623696954724284259259259259259259259259259259259e-1 * t126 / t32 / t69 * t78 * t130 * t134
  t807 = t296 * t116
  t809 = t126 * t807 * t303
  t816 = 0.82386285397499523027777777777777777777777777777777e-5 * t206 * t154 * t774 * t763 * t130 * t564
  t817 = t155 * t761
  t818 = t381 * t78
  t820 = t817 * t818 * t765
  t824 = t43 * t164 * t124 * t295
  t825 = t824 * t291
  t827 = t746 * t133
  t829 = t119 * t284
  t838 = t43 * t3 / t162 / t120 * t165
  t839 = t119 ** 2
  t848 = 0.20e2 * t67 / t671 * t110
  t859 = t234 ** 2
  t873 = t227 ** 2
  t876 = t92 ** 2
  t883 = 0.14764627977777777777777777777777777777777777777777e-2 * t29 * t500 * t63
  t902 = -0.70983522622222222222222222222222222222222222222221e-3 * t29 * t500 * t93 - 0.34246666666666666666666666666666666666666666666666e-1 * t564 * t171 * t228 * t236 - 0.20000000000000000000000000000000000000000000000000e1 * t84 / t227 / t89 * t859 * t235 + 0.10000000000000000000000000000000000000000000000000e1 * t229 * (-0.78438333333333333333333333333333333333333333333333e0 * t495 + 0.15687666666666666666666666666666666666666666666667e1 * t498 + 0.68863333333333333333333333333333333333333333333333e0 * t501 + 0.14025833333333333333333333333333333333333333333333e0 * t505 + 0.28051666666666666666666666666666666666666666666667e0 * t507 + 0.17365833333333333333333333333333333333333333333333e0 * t510) * t235 + 0.32163958997385070133512593798145426124210776856102e2 * t84 / t873 * t859 / t876 + t883 + t568 + t554 - t691 - t699 - 0.24415263074675393406472461472505321282722606644045e-3 * t29 * t500 * t106 - 0.10843581300301739842632067522386578331157260943710e-1 * t564 * t171 * t243 * t251 - 0.11696447245269292414524477327518106963944910680856e1 * t97 * t518 * t480 * t250 + 0.58482236226346462072622386637590534819724553404280e0 * t244 * t512 * t250 + 0.17315859105681463759666483083807725165579399831905e2 * t97 * t479 * t480 * t483
  t904 = t71 * t82 * t902
  t905 = t699 + t691 + t547 - t486 - t489 - t516 + t848 + t904 + t556 + t724 - t726
  t906 = -t728 + t719 + t721 - t554 - t559 + t522 - t568 - t883 + t681 + t714 - t717 + t563
  t913 = 0.1e1 / t272 / t23
  t914 = t3 * t913
  t915 = t284 ** 2
  t922 = -(t905 + t906) * t42 * t117 + 0.6e1 * t270 * t285 - 0.12e2 * t115 * t914 * t915 + 0.3e1 * t115 * t274 * t794
  t928 = t129 * t273
  t934 = -0.27801896084645508333333333333333333333333333333333e-2 * t167 * t168 * t169 * t736 * t119 + t745 + 0.11120758433858203333333333333333333333333333333333e-2 * t749 + t760 + 0.55603792169291016666666666666666666666666666666666e-3 * t767 - t773 - 0.19772708495399885526666666666666666666666666666666e-2 * t777 - 0.55603792169291016666666666666666666666666666666666e-2 * t126 * t301 * t133 * t30 * t794 + t806 + 0.25948436345669141111111111111111111111111111111110e-1 * t809 - t816 - 0.98863542476999427633333333333333333333333333333332e-3 * t820 + 0.12974218172834570555555555555555555555555555555555e-1 * t825 + 0.11120758433858203333333333333333333333333333333333e-1 * t167 * t827 * t30 * t288 * t829 + 0.55603792169291016666666666666666666666666666666666e-2 * t838 * t168 * t169 * t736 * t839 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t168 * t169 * t922 * t119 + 0.16681137650787305000000000000000000000000000000000e-1 * t126 * t928 * t133 * t30 * t915
  t949 = t5 * t25 * (-0.31250000000000000000000000000000000000000000000000e0 * t731 * t732 * t120 + 0.25000000000000000000000000000000000000000000000000e0 * t141 * t934 * t120 + 0.50000000000000000000000000000000000000000000000000e0 * t308 * t289 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t922 * t119 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t736 * t119) * t321
  t950 = t316 ** 2
  t952 = t320 ** 2
  t953 = 0.1e1 / t952
  t955 = t5 * t25 * t950 * t953
  t956 = t23 * t467
  t959 = 0.6e1 * t5 * t956 * t915
  t960 = t24 * t467
  t963 = 0.3e1 * t5 * t960 * t794
  t964 = -0.2363e1 * t701 * t545 * t465 - 0.4726e1 * t701 * t221 * t663 - 0.4726e1 * t710 - t714 + t717 - t719 - t721 - t724 + t726 + t728 - t949 + t955 - t959 - t848 - t904 + t883 - t963
  t967 = t656 * t465
  t972 = t5 * t960 * t284
  t973 = 0.3e1 * t972
  t974 = t967 - 0.2363e1 * t701 * t709 + t458 * t663 - t175 - t200 - t204 + t209 - t223 - t256 - t258 + t263 + t268 - t973 - t323
  t977 = t477 - t486 - t489 - t516 + t522 + t547 - t554 + t556 - t559 + t563 - t568 + t572 * (t700 + t964) + 0.2e1 * t430 * t974 + t681 + t691
  t986 = 0.1e1 / t331
  t987 = t373 ** 2
  t988 = t986 * t987
  t991 = t332 * t529
  t994 = 0.1e1 / t341
  t995 = t377 ** 2
  t996 = t994 * t995
  t1000 = -t342 * t529
  t1003 = 0.11e2 / 0.9e1 * t630
  t1011 = 0.1e1 / t386 / t355
  t1012 = t354 * t1011
  t1013 = t390 ** 2
  t1025 = 0.5e1 / 0.9e1 * (0.40e2 / 0.9e1 * tau0 / t326 / t367 / r0 * t333 - 0.50e2 / 0.9e1 * t370 * t374 + 0.10e2 / 0.9e1 * t329 * t988 + 0.5e1 / 0.3e1 * t329 * t991 + 0.10e2 / 0.9e1 * t339 * t996 + 0.5e1 / 0.3e1 * t339 * t1000 - t1003) * t350 * t357 - 0.10e2 / 0.9e1 * t384 * t391 + 0.10e2 / 0.9e1 * t351 * t1012 * t1013 - 0.5e1 / 0.9e1 * t351 * t388 * (0.10e2 / 0.9e1 * t988 + 0.5e1 / 0.3e1 * t991 + 0.10e2 / 0.9e1 * t996 + 0.5e1 / 0.3e1 * t1000)
  t1026 = f.my_piecewise3(t366, t1025, 0)
  t1029 = t395 ** 2
  t1034 = t396 / t401 / t397
  t1041 = t406 ** 2
  t1044 = f.my_piecewise3(t365, 0, (-0.64e0 * t1026 * t398 - 0.128e1 * t1029 * t402 - 0.128e1 * t1034 * t1029 - 0.64e0 * t403 * t1026) * t409 + t1041 * t409)
  t1046 = 0.1e1 / t420 / t419
  t1047 = t422 ** 2
  t1051 = f.my_piecewise3(t417, 0, t1025)
  t1055 = t420 ** 2
  t1056 = 0.1e1 / t1055
  t1061 = f.my_piecewise3(t417, 0, -0.210e1 * t1046 * t1047 * t426 - 0.105e1 * t421 * t1051 * t426 - 0.1575e1 * t1056 * t1047 * t426)
  t1062 = f.my_piecewise3(t360, t1044, t1061)
  t1064 = t1062 * t470 + t699 + t714 - t717 + t719 + t721 + t724 - t726 - t728 + t848 - t883 + t904 + t949 - t955 + t959 + t963
  t1068 = 0.20000000000000000000000000000000000000000000000000e1 * t199
  t1069 = 0.36622894612013090109708692208757981924083909966068e-3 * t262
  t1071 = 0.2e1 * t256
  t1073 = 0.8e1 * t203
  t1074 = 0.8e1 * t208
  t1075 = 0.22146941966666666666666666666666666666666666666666e-2 * t174
  t1076 = t572 * t974
  t1078 = 0.11696447245269292414524477327518106963944910680856e1 * t267
  d11 = 0.2e1 * t323 + 0.2e1 * t471 + t7 * (t977 + t1064) + 0.39503346997227602814966679236413104097888262435310e-1 * t257 + t1068 - t1069 + 0.6e1 * t972 + t1071 + 0.2e1 * t223 + t1073 - t1074 + t1075 + 0.2e1 * t1076 - t1078
  t1079 = -t8 - t211
  t1082 = f.my_piecewise3(t11, 0, 0.4e1 / 0.3e1 * t14 * t1079)
  t1083 = -t1079
  t1086 = f.my_piecewise3(t18, 0, 0.4e1 / 0.3e1 * t19 * t1083)
  t1088 = (t1082 + t1086) * t81
  t1089 = t1088 * t107
  t1090 = 0.19751673498613801407483339618206552048944131217655e-1 * t1089
  t1093 = f.my_piecewise3(t11, 0, 0.2e1 / 0.3e1 * t275 * t1079)
  t1096 = f.my_piecewise3(t18, 0, 0.2e1 / 0.3e1 * t279 * t1083)
  t1098 = t1093 / 0.2e1 + t1096 / 0.2e1
  t1100 = t5 * t960 * t1098
  t1101 = 0.3e1 * t1100
  t1102 = t1079 / 0.2e1
  t1103 = t332 * t1102
  t1106 = r1 ** 2
  t1109 = tau1 / t336 / t1106
  t1112 = -t1102
  t1113 = t342 * t1112
  t1117 = (0.5e1 / 0.3e1 * t329 * t1103 - 0.5e1 / 0.3e1 * t1109 * t343 + 0.5e1 / 0.3e1 * t339 * t1113 + t382) * t350
  t1120 = 0.5e1 / 0.3e1 * t1103 + 0.5e1 / 0.3e1 * t1113
  t1121 = t388 * t1120
  t1124 = 0.5e1 / 0.9e1 * t1117 * t357 - 0.5e1 / 0.9e1 * t351 * t1121
  t1125 = f.my_piecewise3(t366, t1124, 0)
  t1130 = -0.64e0 * t1125 * t398 - 0.64e0 * t403 * t1125
  t1132 = f.my_piecewise3(t365, 0, t1130 * t409)
  t1133 = f.my_piecewise3(t417, 0, t1124)
  t1137 = f.my_piecewise3(t417, 0, -0.105e1 * t421 * t1133 * t426)
  t1138 = f.my_piecewise3(t360, t1132, t1137)
  t1139 = t1138 * t470
  t1140 = t1088 * t109
  t1141 = t71 * t1140
  t1143 = (t175 + t200 - t204 - t209 + t1141 + t256 + t1090 - t263 - t268) * t42
  t1145 = t274 * t1098
  t1148 = -t1143 * t117 + 0.3e1 * t115 * t1145
  t1149 = t1148 * t119
  t1151 = t168 * t169 * t1149
  t1154 = t30 * t1098
  t1155 = t133 * t1154
  t1159 = -t152 + t161 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t1151 - t300 - 0.55603792169291016666666666666666666666666666666666e-2 * t126 * t301 * t1155
  t1160 = t141 * t1159
  t1163 = t312 * t1148
  t1166 = 0.25000000000000000000000000000000000000000000000000e0 * t1160 * t120 + 0.10000000000000000000000000000000000000000000000000e1 * t1163 * t119
  t1169 = t5 * t25 * t1166 * t321
  t1170 = 0.58482236226346462072622386637590534819724553404280e0 * t488
  t1173 = 0.3e1 * t473 * t474 * t1098
  t1174 = t202 * t1140
  t1175 = 0.4e1 * t1174
  t1176 = t207 * t1140
  t1177 = 0.4e1 * t1176
  t1185 = f.my_piecewise3(t11, 0, -0.2e1 / 0.9e1 * t779 * t1079 * t212 + 0.4e1 / 0.3e1 * t275 * t6 * t527)
  t1193 = f.my_piecewise3(t18, 0, -0.2e1 / 0.9e1 * t786 * t1083 * t216 - 0.4e1 / 0.3e1 * t279 * t6 * t527)
  t1195 = t1185 / 0.2e1 + t1193 / 0.2e1
  t1198 = 0.3e1 * t5 * t960 * t1195
  t1203 = t149 * t133
  t1204 = t30 * t1148
  t1210 = t824 * t1151
  t1225 = t746 * t1098
  t1227 = t147 * t148 * t1225
  t1230 = t130 * t1148 * t119
  t1232 = t762 * t763 * t1230
  t1235 = t775 * t381 * t1225
  t1238 = 0.55603792169291016666666666666666666666666666666666e-2 * t838 * t1203 * t1204 * t839 * t288 + 0.64871090864172852777777777777777777777777777777777e-2 * t1210 + 0.55603792169291016666666666666666666666666666666666e-2 * t167 * t827 * t1204 * t829 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t1203 * t1204 * t289 + 0.55603792169291016666666666666666666666666666666666e-2 * t167 * t827 * t1154 * t289 + 0.55603792169291016666666666666666666666666666666666e-3 * t749 + 0.55603792169291016666666666666666666666666666666666e-3 * t1227 + t745 + t760 + 0.27801896084645508333333333333333333333333333333333e-3 * t1232 - 0.98863542476999427633333333333333333333333333333332e-3 * t1235 + 0.27801896084645508333333333333333333333333333333333e-3 * t767
  t1248 = t817 * t818 * t1230
  t1257 = f.my_piecewise3(t11, 0, 0.4e1 / 0.9e1 * t523 * t1079 * t212 + 0.8e1 / 0.3e1 * t14 * t6 * t527)
  t1265 = f.my_piecewise3(t18, 0, 0.4e1 / 0.9e1 * t535 * t1083 * t216 - 0.8e1 / 0.3e1 * t19 * t6 * t527)
  t1267 = (t1257 + t1265) * t81
  t1269 = t71 * t1267 * t109
  t1271 = t71 * t1088 * t254
  t1272 = 0.18311447306006545054854346104378990962041954983034e-3 * t558
  t1273 = -t486 - t1170 - t516 + t522 + t1175 - t1177 + t1269 + t1271 - t554 - t1272 + t563 - t568 + t681
  t1274 = 0.4e1 * t718
  t1275 = 0.4e1 * t725
  t1277 = t1088 * t26 * t261
  t1278 = 0.18311447306006545054854346104378990962041954983034e-3 * t1277
  t1280 = t1088 * t97 * t266
  t1281 = 0.58482236226346462072622386637590534819724553404280e0 * t1280
  t1283 = 0.19751673498613801407483339618206552048944131217655e-1 * t1267 * t107
  t1284 = t691 + t699 - t714 - t1274 + t723 - t1275 - t728 - t1278 - t1281 + t848 + t904 - t883 + t1283
  t1300 = -(t1273 + t1284) * t42 * t117 + 0.3e1 * t1143 * t285 + 0.3e1 * t270 * t1145 - 0.12e2 * t115 * t3 * t913 * t1098 * t284 + 0.3e1 * t115 * t274 * t1195
  t1308 = t126 * t807 * t1155
  t1319 = -t773 - 0.98863542476999427633333333333333333333333333333332e-3 * t777 - 0.55603792169291016666666666666666666666666666666666e-2 * t126 * t301 * t133 * t30 * t1195 + t806 + 0.12974218172834570555555555555555555555555555555555e-1 * t809 - t816 - 0.49431771238499713816666666666666666666666666666666e-3 * t820 - 0.49431771238499713816666666666666666666666666666666e-3 * t1248 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t168 * t169 * t1300 * t119 + 0.64871090864172852777777777777777777777777777777777e-2 * t825 + 0.12974218172834570555555555555555555555555555555555e-1 * t1308 + 0.16681137650787305000000000000000000000000000000000e-1 * t43 * t122 * t165 * t78 * t273 * t51 * t169 * t1098 * t284
  t1336 = t5 * t25 * (-0.31250000000000000000000000000000000000000000000000e0 * t731 * t1159 * t120 * t307 + 0.25000000000000000000000000000000000000000000000000e0 * t141 * (t1238 + t1319) * t120 + 0.25000000000000000000000000000000000000000000000000e0 * t1160 * t289 + 0.25000000000000000000000000000000000000000000000000e0 * t308 * t1149 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t1300 * t119 + 0.10000000000000000000000000000000000000000000000000e1 * t1163 * t289) * t321
  t1340 = t5 * t25 * t1166 * t953 * t316
  t1341 = -t486 - t1170 - t516 + t522 + t1173 + t1175 - t1177 + t1198 + t1336 + t1269 + t1271 - t554 - t1272 + t563 - t568 - t1340 + t681 + t691
  t1342 = t1166 * t321
  t1345 = 0.3e1 * t473 * t1342 * t284
  t1350 = 0.6e1 * t5 * t23 * t467 * t1098 * t284
  t1352 = 0.12e2 * t658 + 0.12e2 * t661
  t1356 = t1088 * t465
  t1357 = t708 * t1356
  t1365 = t486 + t1170 + t516 - t522 - t1173 - t1175 + t1177 - t1198 - t1336 - t1269 - t1271 - 0.2363e1 * t701 * t221 * t1352 - 0.2363e1 * t1357 - 0.2363e1 * t701 * t1267 * t465 - 0.2363e1 * t701 * t1088 * t663 + t554 + t1272 - t563 + t568 + t651
  t1370 = t656 * t1352
  t1371 = -t723 + t1275 + t728 + t1278 + t1281 - t848 - t904 + t883 - t1283 + t458 * (t668 - t675) + t1370
  t1378 = t967 - 0.2363e1 * t701 * t1356 + t458 * t1352 - t175 - t200 + t204 + t209 - t1141 - t256 - t1090 + t263 + t268 - t1101 - t1169
  t1384 = t986 * t1102 * t373
  t1388 = t332 * t6 * t527
  t1394 = t994 * t1112 * t377
  t1398 = t342 * t6 * t527
  t1422 = 0.5e1 / 0.9e1 * (-0.25e2 / 0.9e1 * t370 * t1103 + 0.10e2 / 0.9e1 * t329 * t1384 + 0.5e1 / 0.3e1 * t329 * t1388 - 0.25e2 / 0.9e1 * t1109 * t378 + 0.10e2 / 0.9e1 * t339 * t1394 - 0.5e1 / 0.3e1 * t339 * t1398 - t1003) * t350 * t357 - 0.5e1 / 0.9e1 * t1117 * t391 - 0.5e1 / 0.9e1 * t384 * t1121 + 0.10e2 / 0.9e1 * t351 * t354 * t1011 * t1120 * t390 - 0.5e1 / 0.9e1 * t351 * t388 * (0.10e2 / 0.9e1 * t1384 + 0.5e1 / 0.3e1 * t1388 + 0.10e2 / 0.9e1 * t1394 - 0.5e1 / 0.3e1 * t1398)
  t1423 = f.my_piecewise3(t366, t1422, 0)
  t1439 = f.my_piecewise3(t365, 0, (-0.64e0 * t1423 * t398 - 0.128e1 * t1125 * t402 * t395 - 0.128e1 * t1034 * t1125 * t395 - 0.64e0 * t403 * t1423) * t409 + t1130 * t406 * t409)
  t1441 = t426 * t422
  t1444 = f.my_piecewise3(t417, 0, t1422)
  t1452 = f.my_piecewise3(t417, 0, -0.210e1 * t1046 * t1133 * t1441 - 0.105e1 * t421 * t1444 * t426 - 0.1575e1 * t1056 * t1133 * t1441)
  t1453 = f.my_piecewise3(t360, t1439, t1452)
  t1455 = t699 + t1345 + t1350 - t714 - t1274 + t723 - t1275 - t728 + t572 * (t1365 + t664 + t1340 - t681 - t691 - t699 - 0.2363e1 * t710 - t1345 - t1350 + t714 + t1274 + t1371) - t1278 - t1281 + t430 * t1378 + t848 + t904 - t883 + t1283 + t1138 * t974 + t1453 * t470
  t1458 = t572 * t1378
  d12 = t258 + t1090 + t1068 + t973 + t1101 + t1139 + t1071 - t1074 + t1141 + t1075 + t223 + t1169 + t7 * (t1341 + t1455) + t471 + t1076 + t1458 - t1078 - t1069 + t323
  t1461 = t1079 ** 2
  t1464 = t210 + t528
  t1465 = 0.2e1 * t1464
  t1469 = f.my_piecewise3(t11, 0, 0.4e1 / 0.9e1 * t523 * t1461 + 0.4e1 / 0.3e1 * t14 * t1465)
  t1470 = t1083 ** 2
  t1473 = -t1465
  t1477 = f.my_piecewise3(t18, 0, 0.4e1 / 0.9e1 * t535 * t1470 + 0.4e1 / 0.3e1 * t19 * t1473)
  t1479 = (t1469 + t1477) * t81
  t1481 = t71 * t1479 * t109
  t1482 = 0.8e1 * t1174
  t1483 = 0.8e1 * t1176
  t1484 = 0.2e1 * t1271
  t1485 = t1102 ** 2
  t1486 = t986 * t1485
  t1489 = t332 * t1464
  t1500 = t1112 ** 2
  t1501 = t994 * t1500
  t1505 = -t342 * t1464
  t1514 = t1120 ** 2
  t1526 = 0.5e1 / 0.9e1 * (0.10e2 / 0.9e1 * t329 * t1486 + 0.5e1 / 0.3e1 * t329 * t1489 + 0.40e2 / 0.9e1 * tau1 / t336 / t1106 / r1 * t343 - 0.50e2 / 0.9e1 * t1109 * t1113 + 0.10e2 / 0.9e1 * t339 * t1501 + 0.5e1 / 0.3e1 * t339 * t1505 - t1003) * t350 * t357 - 0.10e2 / 0.9e1 * t1117 * t1121 + 0.10e2 / 0.9e1 * t351 * t1012 * t1514 - 0.5e1 / 0.9e1 * t351 * t388 * (0.10e2 / 0.9e1 * t1486 + 0.5e1 / 0.3e1 * t1489 + 0.10e2 / 0.9e1 * t1501 + 0.5e1 / 0.3e1 * t1505)
  t1527 = f.my_piecewise3(t366, t1526, 0)
  t1530 = t1125 ** 2
  t1539 = t1130 ** 2
  t1542 = f.my_piecewise3(t365, 0, (-0.64e0 * t1527 * t398 - 0.128e1 * t1530 * t402 - 0.128e1 * t1034 * t1530 - 0.64e0 * t403 * t1527) * t409 + t1539 * t409)
  t1543 = t1133 ** 2
  t1547 = f.my_piecewise3(t417, 0, t1526)
  t1555 = f.my_piecewise3(t417, 0, -0.210e1 * t1046 * t1543 * t426 - 0.105e1 * t421 * t1547 * t426 - 0.1575e1 * t1056 * t1543 * t426)
  t1556 = f.my_piecewise3(t360, t1542, t1555)
  t1558 = t1098 ** 2
  t1561 = 0.6e1 * t5 * t956 * t1558
  t1562 = t1556 * t470 + t1481 - t1482 - t1483 + t1484 + t1561 - t486 - t516 + t522 - t554 + t563 - t568 + t681 + t691 + t699
  t1568 = f.my_piecewise3(t11, 0, -0.2e1 / 0.9e1 * t779 * t1461 + 0.2e1 / 0.3e1 * t275 * t1465)
  t1574 = f.my_piecewise3(t18, 0, -0.2e1 / 0.9e1 * t786 * t1470 + 0.2e1 / 0.3e1 * t279 * t1473)
  t1576 = t1568 / 0.2e1 + t1574 / 0.2e1
  t1579 = 0.3e1 * t5 * t960 * t1576
  t1580 = t1159 ** 2
  t1584 = t1148 ** 2
  t1612 = 0.19751673498613801407483339618206552048944131217655e-1 * t1479 * t107
  t1613 = 0.36622894612013090109708692208757981924083909966068e-3 * t1277
  t1614 = t1481 + t1484 + t1612 - t568 + t699 + t691 + t714 - t1483 - t728 + t681 - t1613
  t1615 = 0.11696447245269292414524477327518106963944910680856e1 * t1280
  t1616 = t522 + t848 + t717 - t883 - t516 + t904 - t1615 - t1482 - t721 - t554 + t563 - t486
  t1628 = -(t1614 + t1616) * t42 * t117 + 0.6e1 * t1143 * t1145 - 0.12e2 * t115 * t914 * t1558 + 0.3e1 * t115 * t274 * t1576
  t1639 = 0.55603792169291016666666666666666666666666666666666e-2 * t838 * t168 * t169 * t1584 * t839 + 0.12974218172834570555555555555555555555555555555555e-1 * t1210 + 0.11120758433858203333333333333333333333333333333333e-1 * t167 * t827 * t1204 * t119 * t1098 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t168 * t169 * t1584 * t119 + t745 + 0.11120758433858203333333333333333333333333333333333e-2 * t1227 + t760 + 0.55603792169291016666666666666666666666666666666666e-3 * t1232 - t773 - 0.19772708495399885526666666666666666666666666666666e-2 * t1235 - 0.55603792169291016666666666666666666666666666666666e-2 * t126 * t301 * t133 * t30 * t1576 + t806 + 0.25948436345669141111111111111111111111111111111110e-1 * t1308 - t816 - 0.98863542476999427633333333333333333333333333333332e-3 * t1248 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t168 * t169 * t1628 * t119 + 0.16681137650787305000000000000000000000000000000000e-1 * t126 * t928 * t133 * t30 * t1558
  t1654 = t5 * t25 * (-0.31250000000000000000000000000000000000000000000000e0 * t731 * t1580 * t120 + 0.25000000000000000000000000000000000000000000000000e0 * t141 * t1639 * t120 + 0.50000000000000000000000000000000000000000000000000e0 * t1160 * t1149 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t1628 * t119 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t1584 * t119) * t321
  t1655 = t1166 ** 2
  t1658 = t5 * t25 * t1655 * t953
  t1661 = 0.6e1 * t473 * t1342 * t1098
  t1667 = t458 * (-t668 - t670 - t675) + t486 + t516 - t522 - t1481 + t1482 + t1483 - t1484 - 0.4726e1 * t1357 + t554 - t563 + t568 + t651 - t681 - t691 - t699 - t1561
  t1675 = -t1579 - t1654 - 0.2363e1 * t701 * t1479 * t465 - 0.4726e1 * t701 * t1088 * t1352 - t1612 - t714 - t717 + t721 + t728 + t1658 - t1661 + t1613 + t1615 - t848 - t904 + t883 + 0.2e1 * t1370
  t1678 = t1579 + t1654 + t1612 + t714 + t717 - t721 - t728 - t1658 + t1661 - t1613 + 0.2e1 * t1138 * t1378 - t1615 + t572 * (t1667 + t1675) + t848 + t904 - t883
  d22 = -t1069 + t1071 + 0.39503346997227602814966679236413104097888262435310e-1 * t1089 + t1068 + 0.6e1 * t1100 + t7 * (t1562 + t1678) + 0.2e1 * t1458 + 0.2e1 * t1139 + 0.2e1 * t1169 - t1074 + 0.2e1 * t1141 + t1075 - t1073 - t1078
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = jnp.log(0.2e1)
  t2 = 0.1e1 - t1
  t3 = jnp.pi ** 2
  t5 = t2 / t3
  t6 = r0 - r1
  t7 = r0 + r1
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t10 = 0.1e1 + t9
  t11 = t10 <= f.p.zeta_threshold
  t12 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t13 = t12 ** 2
  t14 = t10 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t16 = f.my_piecewise3(t11, t13, t15)
  t17 = 0.1e1 - t9
  t18 = t17 <= f.p.zeta_threshold
  t19 = t17 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = f.my_piecewise3(t18, t13, t20)
  t23 = t16 / 0.2e1 + t21 / 0.2e1
  t24 = t23 ** 2
  t25 = t24 * t23
  t26 = 3 ** (0.1e1 / 0.3e1)
  t28 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t29 = t26 * t28
  t30 = 4 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = t7 ** (0.1e1 / 0.3e1)
  t35 = t29 * t31 / t32
  t37 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e-1 * t35
  t39 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t35
  t40 = 0.1e1 / t39
  t42 = 0.1e1 / t2
  t43 = t37 * t40 * t42
  t45 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t35
  t46 = jnp.sqrt(t35)
  t49 = t35 ** 0.15e1
  t51 = t26 ** 2
  t52 = t28 ** 2
  t53 = t51 * t52
  t54 = t32 ** 2
  t57 = t53 * t30 / t54
  t59 = 0.37978500000000000000000000000000000000000000000000e1 * t46 + 0.89690000000000000000000000000000000000000000000000e0 * t35 + 0.20477500000000000000000000000000000000000000000000e0 * t49 + 0.12323500000000000000000000000000000000000000000000e0 * t57
  t62 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t59
  t63 = jnp.log(t62)
  t65 = 0.621814e-1 * t45 * t63
  t66 = t6 ** 2
  t67 = t66 ** 2
  t68 = t7 ** 2
  t69 = t68 ** 2
  t70 = 0.1e1 / t69
  t71 = t67 * t70
  t72 = t12 * f.p.zeta_threshold
  t73 = t14 * t10
  t74 = f.my_piecewise3(t11, t72, t73)
  t75 = t19 * t17
  t76 = f.my_piecewise3(t18, t72, t75)
  t77 = t74 + t76 - 0.2e1
  t78 = 2 ** (0.1e1 / 0.3e1)
  t79 = t78 - 0.1e1
  t81 = 0.1e1 / t79 / 0.2e1
  t82 = t77 * t81
  t84 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t35
  t89 = 0.70594500000000000000000000000000000000000000000000e1 * t46 + 0.15494250000000000000000000000000000000000000000000e1 * t35 + 0.42077500000000000000000000000000000000000000000000e0 * t49 + 0.15629250000000000000000000000000000000000000000000e0 * t57
  t92 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t89
  t93 = jnp.log(t92)
  t97 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t35
  t102 = 0.51785000000000000000000000000000000000000000000000e1 * t46 + 0.90577500000000000000000000000000000000000000000000e0 * t35 + 0.11003250000000000000000000000000000000000000000000e0 * t49 + 0.12417750000000000000000000000000000000000000000000e0 * t57
  t105 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t102
  t106 = jnp.log(t105)
  t107 = t97 * t106
  t109 = -0.3109070e-1 * t84 * t93 + t65 - 0.19751673498613801407483339618206552048944131217655e-1 * t107
  t110 = t82 * t109
  t111 = t71 * t110
  t113 = 0.19751673498613801407483339618206552048944131217655e-1 * t82 * t107
  t115 = (-t65 + t111 + t113) * t42
  t116 = 0.1e1 / t25
  t117 = t3 * t116
  t119 = jnp.exp(-t115 * t117)
  t120 = t119 - 0.1e1
  t121 = 0.1e1 / t120
  t122 = t3 * t121
  t124 = s0 + 0.2e1 * s1 + s2
  t125 = t122 * t124
  t126 = t43 * t125
  t128 = 0.1e1 / t32 / t68
  t129 = t128 * t78
  t130 = 0.1e1 / t24
  t132 = 0.1e1 / t28
  t133 = t51 * t132
  t134 = t133 * t30
  t138 = 0.1e1 + 0.27801896084645508333333333333333333333333333333333e-2 * t126 * t129 * t130 * t134
  t139 = t138 ** (0.1e1 / 0.4e1)
  t141 = 0.1e1 / t139 / t138
  t142 = t68 * t7
  t144 = 0.1e1 / t54 / t142
  t145 = t144 * t40
  t146 = t42 * t3
  t147 = t145 * t146
  t148 = t121 * t124
  t149 = t78 * t130
  t150 = t148 * t149
  t152 = 0.27801896084645508333333333333333333333333333333333e-3 * t147 * t150
  t153 = t39 ** 2
  t154 = 0.1e1 / t153
  t155 = t37 * t154
  t156 = t155 * t146
  t161 = 0.49431771238499713816666666666666666666666666666666e-3 * t156 * t148 * t144 * t78 * t130
  t162 = t120 ** 2
  t163 = 0.1e1 / t162
  t164 = t3 * t163
  t165 = t124 * t128
  t167 = t43 * t164 * t165
  t168 = t149 * t51
  t169 = t132 * t30
  t171 = 0.1e1 / t32 / t7
  t172 = t31 * t171
  t174 = t29 * t172 * t63
  t175 = 0.11073470983333333333333333333333333333333333333333e-2 * t174
  t176 = t59 ** 2
  t177 = 0.1e1 / t176
  t178 = t45 * t177
  t180 = 0.1e1 / t46 * t26
  t181 = t28 * t31
  t182 = t181 * t171
  t183 = t180 * t182
  t185 = t29 * t172
  t187 = t35 ** 0.5e0
  t188 = t187 * t26
  t189 = t188 * t182
  t194 = t53 * t30 / t54 / t7
  t196 = -0.63297500000000000000000000000000000000000000000000e0 * t183 - 0.29896666666666666666666666666666666666666666666667e0 * t185 - 0.10238750000000000000000000000000000000000000000000e0 * t189 - 0.82156666666666666666666666666666666666666666666667e-1 * t194
  t197 = 0.1e1 / t62
  t198 = t196 * t197
  t199 = t178 * t198
  t200 = 0.10000000000000000000000000000000000000000000000000e1 * t199
  t201 = t66 * t6
  t202 = t201 * t70
  t203 = t202 * t110
  t204 = 0.4e1 * t203
  t205 = t69 * t7
  t206 = 0.1e1 / t205
  t207 = t67 * t206
  t208 = t207 * t110
  t209 = 0.4e1 * t208
  t210 = 0.1e1 / t68
  t211 = t6 * t210
  t212 = t8 - t211
  t215 = f.my_piecewise3(t11, 0, 0.4e1 / 0.3e1 * t14 * t212)
  t216 = -t212
  t219 = f.my_piecewise3(t18, 0, 0.4e1 / 0.3e1 * t19 * t216)
  t221 = (t215 + t219) * t81
  t222 = t221 * t109
  t223 = t71 * t222
  t227 = t89 ** 2
  t228 = 0.1e1 / t227
  t229 = t84 * t228
  t234 = -0.11765750000000000000000000000000000000000000000000e1 * t183 - 0.51647500000000000000000000000000000000000000000000e0 * t185 - 0.21038750000000000000000000000000000000000000000000e0 * t189 - 0.10419500000000000000000000000000000000000000000000e0 * t194
  t235 = 0.1e1 / t92
  t236 = t234 * t235
  t242 = t102 ** 2
  t243 = 0.1e1 / t242
  t244 = t97 * t243
  t249 = -0.86308333333333333333333333333333333333333333333334e0 * t183 - 0.30192500000000000000000000000000000000000000000000e0 * t185 - 0.55016250000000000000000000000000000000000000000000e-1 * t189 - 0.82785000000000000000000000000000000000000000000000e-1 * t194
  t250 = 0.1e1 / t105
  t251 = t249 * t250
  t254 = 0.53237641966666666666666666666666666666666666666666e-3 * t29 * t172 * t93 + 0.10000000000000000000000000000000000000000000000000e1 * t229 * t236 - t175 - t200 + 0.18311447306006545054854346104378990962041954983034e-3 * t29 * t172 * t106 + 0.58482236226346462072622386637590534819724553404280e0 * t244 * t251
  t255 = t82 * t254
  t256 = t71 * t255
  t257 = t221 * t107
  t258 = 0.19751673498613801407483339618206552048944131217655e-1 * t257
  t259 = t82 * t26
  t261 = t181 * t171 * t106
  t262 = t259 * t261
  t263 = 0.18311447306006545054854346104378990962041954983034e-3 * t262
  t264 = t82 * t97
  t266 = t243 * t249 * t250
  t267 = t264 * t266
  t268 = 0.58482236226346462072622386637590534819724553404280e0 * t267
  t270 = (t175 + t200 + t204 - t209 + t223 + t256 + t258 - t263 - t268) * t42
  t272 = t24 ** 2
  t273 = 0.1e1 / t272
  t274 = t3 * t273
  t275 = 0.1e1 / t14
  t278 = f.my_piecewise3(t11, 0, 0.2e1 / 0.3e1 * t275 * t212)
  t279 = 0.1e1 / t19
  t282 = f.my_piecewise3(t18, 0, 0.2e1 / 0.3e1 * t279 * t216)
  t284 = t278 / 0.2e1 + t282 / 0.2e1
  t285 = t274 * t284
  t288 = 0.3e1 * t115 * t285 - t270 * t117
  t289 = t288 * t119
  t291 = t168 * t169 * t289
  t295 = 0.1e1 / t32 / t142
  t296 = t295 * t78
  t300 = 0.64871090864172852777777777777777777777777777777777e-2 * t126 * t296 * t130 * t134
  t301 = t129 * t116
  t303 = t133 * t30 * t284
  t307 = -t152 + t161 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t291 - t300 - 0.55603792169291016666666666666666666666666666666666e-2 * t126 * t301 * t303
  t308 = t141 * t307
  t312 = 0.1e1 - 0.1e1 / t139
  t316 = 0.25000000000000000000000000000000000000000000000000e0 * t308 * t120 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t288 * t119
  t320 = 0.1e1 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t120
  t321 = 0.1e1 / t320
  t323 = t5 * t25 * t316 * t321
  t325 = r0 ** (0.1e1 / 0.3e1)
  t326 = t325 ** 2
  t329 = tau0 / t326 / r0
  t330 = t10 / 0.2e1
  t331 = t330 ** (0.1e1 / 0.3e1)
  t332 = t331 ** 2
  t333 = t332 * t330
  t335 = r1 ** (0.1e1 / 0.3e1)
  t336 = t335 ** 2
  t339 = tau1 / t336 / r1
  t340 = t17 / 0.2e1
  t341 = t340 ** (0.1e1 / 0.3e1)
  t342 = t341 ** 2
  t343 = t342 * t340
  t346 = 0.1e1 / t54 / t68
  t350 = 6 ** (0.1e1 / 0.3e1)
  t351 = (t329 * t333 + t339 * t343 - t124 * t346 / 0.8e1) * t350
  t352 = t3 ** (0.1e1 / 0.3e1)
  t353 = t352 ** 2
  t354 = 0.1e1 / t353
  t355 = t333 + t343
  t357 = t354 / t355
  t359 = 0.5e1 / 0.9e1 * t351 * t357
  t360 = t359 <= 0.1e1
  t361 = jnp.log(DBL_EPSILON)
  t364 = t361 / (-t361 + 0.64e0)
  t365 = -t364 < t359
  t366 = t359 < -t364
  t367 = r0 ** 2
  t370 = tau0 / t326 / t367
  t373 = t212 / 0.2e1
  t374 = t332 * t373
  t377 = -t373
  t378 = t342 * t377
  t381 = t124 * t144
  t382 = t381 / 0.3e1
  t384 = (-0.5e1 / 0.3e1 * t370 * t333 + 0.5e1 / 0.3e1 * t329 * t374 + 0.5e1 / 0.3e1 * t339 * t378 + t382) * t350
  t386 = t355 ** 2
  t388 = t354 / t386
  t390 = 0.5e1 / 0.3e1 * t374 + 0.5e1 / 0.3e1 * t378
  t391 = t388 * t390
  t394 = -0.5e1 / 0.9e1 * t351 * t391 + 0.5e1 / 0.9e1 * t384 * t357
  t395 = f.my_piecewise3(t366, t394, 0)
  t396 = f.my_piecewise3(t366, t359, -t364)
  t397 = 0.1e1 - t396
  t398 = 0.1e1 / t397
  t401 = t397 ** 2
  t402 = 0.1e1 / t401
  t403 = t396 * t402
  t406 = -0.64e0 * t395 * t398 - 0.64e0 * t403 * t395
  t409 = jnp.exp(-0.64e0 * t396 * t398)
  t411 = f.my_piecewise3(t365, 0, t406 * t409)
  t413 = jnp.log(0.14285714285714285714285714285714285714285714285714e1 * DBL_EPSILON)
  t416 = (-t413 + 0.15e1) / t413
  t417 = t359 < -t416
  t418 = f.my_piecewise3(t417, -t416, t359)
  t419 = 0.1e1 - t418
  t420 = t419 ** 2
  t421 = 0.1e1 / t420
  t422 = f.my_piecewise3(t417, 0, t394)
  t426 = jnp.exp(0.15e1 / t419)
  t429 = f.my_piecewise3(t417, 0, -0.105e1 * t421 * t422 * t426)
  t430 = f.my_piecewise3(t360, t411, t429)
  t433 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t46 + 0.31385250000000000000000000000000000000000000000000e-1 * t35
  t434 = 0.1e1 / t433
  t437 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t434)
  t438 = t437 - 0.1e1
  t439 = t350 * t354
  t440 = t78 ** 2
  t441 = t440 * t124
  t445 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t439 * t441 * t346
  t446 = t445 ** (0.1e1 / 0.4e1)
  t448 = 0.1e1 - 0.1e1 / t446
  t450 = t438 * t448 + 0.1e1
  t451 = jnp.log(t450)
  t453 = -0.285764e-1 * t434 + 0.285764e-1 * t451
  t457 = 0.1e1 - 0.2363e1 * t79 * t77 * t81
  t458 = t453 * t457
  t459 = t67 ** 2
  t460 = t459 * t67
  t461 = t69 ** 2
  t463 = 0.1e1 / t461 / t69
  t465 = -t460 * t463 + 0.1e1
  t467 = jnp.log(t320)
  t470 = -t5 * t25 * t467 + t458 * t465 - t111 - t113 + t65
  t471 = t430 * t470
  t474 = 0.20000000000000000000000000000000000000000000000000e1 * t199
  t475 = 0.36622894612013090109708692208757981924083909966068e-3 * t262
  t476 = t24 * t467
  t478 = t5 * t476 * t284
  t480 = 0.2e1 * t256
  t482 = 0.8e1 * t203
  t483 = 0.8e1 * t208
  t484 = 0.22146941966666666666666666666666666666666666666666e-2 * t174
  t485 = t433 ** 2
  t486 = 0.1e1 / t485
  t489 = -0.74083333333333333333333333333333333333333333333333e-2 * t183 - 0.10461750000000000000000000000000000000000000000000e-1 * t185
  t490 = t486 * t489
  t492 = t437 * t448
  t496 = 0.1e1 / t446 / t445
  t498 = t438 * t496 * t350
  t499 = t354 * t440
  t503 = -0.10000000000000000000000000000000000000000000000000e1 * t490 * t492 - 0.14225094736250905555555555555555555555555555555555e-1 * t498 * t499 * t381
  t504 = 0.1e1 / t450
  t507 = 0.285764e-1 * t490 + 0.285764e-1 * t503 * t504
  t508 = t507 * t457
  t509 = t508 * t465
  t510 = t453 * t79
  t511 = t221 * t465
  t514 = t459 * t201
  t515 = t514 * t463
  t517 = 0.1e1 / t461 / t205
  t518 = t460 * t517
  t520 = -0.12e2 * t515 + 0.12e2 * t518
  t522 = 0.3e1 * t478
  t523 = t509 - 0.2363e1 * t510 * t511 + t458 * t520 - t175 - t200 - t204 + t209 - t223 - t256 - t258 + t263 + t268 - t522 - t323
  t526 = f.my_piecewise3(t365, 0, t409)
  t528 = f.my_piecewise3(t417, 0, -0.7e0 * t426)
  t529 = f.my_piecewise3(t360, t526, t528)
  t530 = 0.1e1 / t15
  t531 = t212 ** 2
  t534 = 0.1e1 / t142
  t535 = t6 * t534
  t536 = -t210 + t535
  t537 = 0.2e1 * t536
  t541 = f.my_piecewise3(t11, 0, 0.4e1 / 0.9e1 * t530 * t531 + 0.4e1 / 0.3e1 * t14 * t537)
  t542 = 0.1e1 / t20
  t543 = t216 ** 2
  t546 = -t537
  t550 = f.my_piecewise3(t18, 0, 0.4e1 / 0.9e1 * t542 * t543 + 0.4e1 / 0.3e1 * t19 * t546)
  t552 = (t541 + t550) * t81
  t559 = t507 * t79
  t560 = t559 * t511
  t564 = 0.12e2 * t66 * t70 * t110
  t567 = 0.32e2 * t201 * t206 * t110
  t569 = 0.8e1 * t202 * t255
  t571 = t221 * t26 * t261
  t572 = 0.36622894612013090109708692208757981924083909966068e-3 * t571
  t576 = 0.24415263074675393406472461472505321282722606644045e-3 * t259 * t181 * t128 * t106
  t577 = t29 * t31
  t581 = 0.35616666666666666666666666666666666666666666666666e-1 * t577 * t171 * t177 * t198
  t582 = t508 * t520
  t586 = 0.132e3 * t459 * t66 * t463
  t588 = 0.288e3 * t514 * t517
  t589 = t69 * t68
  t593 = 0.156e3 * t460 / t461 / t589
  t598 = t489 ** 2
  t599 = 0.1e1 / t485 / t433 * t598
  t605 = t52 * t30 * t346
  t606 = 0.1e1 / t46 / t35 * t51 * t605
  t608 = t181 * t128
  t609 = t180 * t608
  t611 = t31 * t128
  t612 = t29 * t611
  t615 = t486 * (-0.49388888888888888888888888888888888888888888888889e-2 * t606 + 0.98777777777777777777777777777777777777777777777777e-2 * t609 + 0.13949000000000000000000000000000000000000000000000e-1 * t612)
  t621 = t485 ** 2
  t632 = t445 ** 2
  t636 = t350 ** 2
  t641 = t124 ** 2
  t650 = 0.1e1 / t54 / t69
  t651 = t124 * t650
  t658 = t503 ** 2
  t659 = t450 ** 2
  t665 = (-0.571528e-1 * t599 + 0.285764e-1 * t615 + 0.285764e-1 * (0.20000000000000000000000000000000000000000000000000e1 * t599 * t492 - 0.10000000000000000000000000000000000000000000000000e1 * t615 * t492 + 0.10000000000000000000000000000000000000000000000000e1 / t621 * t598 * t492 + 0.28450189472501811111111111111111111111111111111110e-1 * t490 * t437 * t496 * t439 * t441 * t144 - 0.20235332025531322029119593137558641975308641975307e-2 * t438 / t446 / t632 * t636 / t352 / t3 * t78 * t641 / t32 / t69 / t142 + 0.52158680699586653703703703703703703703703703703702e-1 * t498 * t499 * t651) * t504 - 0.285764e-1 * t658 / t659) * t457 * t465
  t669 = 0.10843581300301739842632067522386578331157260943710e-1 * t82 * t29 * t172 * t266
  t673 = t35 ** (-0.5e0)
  t675 = t673 * t51 * t605
  t677 = t188 * t608
  t680 = t53 * t30 * t346
  t685 = 0.10000000000000000000000000000000000000000000000000e1 * t178 * (-0.42198333333333333333333333333333333333333333333333e0 * t606 + 0.84396666666666666666666666666666666666666666666666e0 * t609 + 0.39862222222222222222222222222222222222222222222223e0 * t612 + 0.68258333333333333333333333333333333333333333333333e-1 * t675 + 0.13651666666666666666666666666666666666666666666667e0 * t677 + 0.13692777777777777777777777777777777777777777777778e0 * t680) * t197
  t686 = t176 ** 2
  t689 = t196 ** 2
  t690 = t62 ** 2
  t694 = 0.16081979498692535066756296899072713062105388428051e2 * t45 / t686 * t689 / t690
  t695 = t316 ** 2
  t697 = t320 ** 2
  t698 = 0.1e1 / t697
  t700 = t5 * t25 * t695 * t698
  t701 = t23 * t467
  t702 = t284 ** 2
  t705 = 0.6e1 * t5 * t701 * t702
  t706 = -0.2363e1 * t510 * t552 * t465 - 0.4726e1 * t510 * t221 * t520 - 0.4726e1 * t560 - t564 + t567 - t569 + t572 - t576 + t581 + 0.2e1 * t582 + t458 * (-t586 + t588 - t593) + t665 - t669 - t685 - t694 + t700 - t705
  t712 = 0.20000000000000000000000000000000000000000000000000e1 * t45 / t176 / t59 * t689 * t197
  t714 = 0.19751673498613801407483339618206552048944131217655e-1 * t552 * t107
  t718 = 0.20e2 * t67 / t589 * t110
  t729 = t234 ** 2
  t743 = t227 ** 2
  t746 = t92 ** 2
  t753 = 0.14764627977777777777777777777777777777777777777777e-2 * t29 * t611 * t63
  t762 = 0.1e1 / t242 / t102
  t764 = t249 ** 2
  t774 = -0.57538888888888888888888888888888888888888888888889e0 * t606 + 0.11507777777777777777777777777777777777777777777778e1 * t609 + 0.40256666666666666666666666666666666666666666666667e0 * t612 + 0.36677500000000000000000000000000000000000000000000e-1 * t675 + 0.73355000000000000000000000000000000000000000000000e-1 * t677 + 0.13797500000000000000000000000000000000000000000000e0 * t680
  t778 = t242 ** 2
  t779 = 0.1e1 / t778
  t781 = t105 ** 2
  t782 = 0.1e1 / t781
  t786 = -0.70983522622222222222222222222222222222222222222221e-3 * t29 * t611 * t93 - 0.34246666666666666666666666666666666666666666666666e-1 * t577 * t171 * t228 * t236 - 0.20000000000000000000000000000000000000000000000000e1 * t84 / t227 / t89 * t729 * t235 + 0.10000000000000000000000000000000000000000000000000e1 * t229 * (-0.78438333333333333333333333333333333333333333333333e0 * t606 + 0.15687666666666666666666666666666666666666666666667e1 * t609 + 0.68863333333333333333333333333333333333333333333333e0 * t612 + 0.14025833333333333333333333333333333333333333333333e0 * t675 + 0.28051666666666666666666666666666666666666666666667e0 * t677 + 0.17365833333333333333333333333333333333333333333333e0 * t680) * t235 + 0.32163958997385070133512593798145426124210776856102e2 * t84 / t743 * t729 / t746 + t753 + t581 + t712 - t685 - t694 - 0.24415263074675393406472461472505321282722606644045e-3 * t29 * t611 * t106 - 0.10843581300301739842632067522386578331157260943710e-1 * t577 * t171 * t243 * t251 - 0.11696447245269292414524477327518106963944910680856e1 * t97 * t762 * t764 * t250 + 0.58482236226346462072622386637590534819724553404280e0 * t244 * t774 * t250 + 0.17315859105681463759666483083807725165579399831905e2 * t97 * t779 * t764 * t782
  t788 = t71 * t82 * t786
  t789 = t138 ** 2
  t791 = 0.1e1 / t139 / t789
  t792 = t307 ** 2
  t796 = t288 ** 2
  t805 = 0.16681137650787305000000000000000000000000000000000e-2 * t650 * t40 * t146 * t150
  t806 = t78 * t116
  t807 = t806 * t284
  t809 = t147 * t148 * t807
  t820 = 0.14648281543675415194338888888888888888888888888889e-4 * t37 / t153 / t39 * t42 * t125 * t206 * t78 * t130 * t577
  t821 = t146 * t163
  t822 = t145 * t821
  t823 = t124 * t78
  t825 = t130 * t288 * t119
  t827 = t822 * t823 * t825
  t833 = 0.29659062743099828290000000000000000000000000000000e-2 * t156 * t148 * t650 * t78 * t130
  t834 = t146 * t121
  t835 = t155 * t834
  t837 = t835 * t381 * t807
  t839 = 0.1e1 / t73
  t845 = f.my_piecewise3(t11, 0, -0.2e1 / 0.9e1 * t839 * t531 + 0.2e1 / 0.3e1 * t275 * t537)
  t846 = 0.1e1 / t75
  t852 = f.my_piecewise3(t18, 0, -0.2e1 / 0.9e1 * t846 * t543 + 0.2e1 / 0.3e1 * t279 * t546)
  t854 = t845 / 0.2e1 + t852 / 0.2e1
  t866 = 0.21623696954724284259259259259259259259259259259259e-1 * t126 / t32 / t69 * t78 * t130 * t134
  t867 = t296 * t116
  t869 = t126 * t867 * t303
  t876 = 0.82386285397499523027777777777777777777777777777777e-5 * t206 * t154 * t834 * t823 * t130 * t577
  t877 = t155 * t821
  t878 = t381 * t78
  t880 = t877 * t878 * t825
  t884 = t43 * t164 * t124 * t295
  t885 = t884 * t291
  t887 = t806 * t133
  t889 = t119 * t284
  t898 = t43 * t3 / t162 / t120 * t165
  t899 = t119 ** 2
  t908 = 0.17315859105681463759666483083807725165579399831905e2 * t264 * t779 * t764 * t782
  t910 = t221 * t97 * t266
  t911 = 0.11696447245269292414524477327518106963944910680856e1 * t910
  t915 = 0.58482236226346462072622386637590534819724553404280e0 * t264 * t243 * t774 * t250
  t917 = t71 * t552 * t109
  t919 = t71 * t221 * t254
  t920 = 0.2e1 * t919
  t921 = t207 * t222
  t922 = 0.8e1 * t921
  t923 = t694 + t685 + t714 - t908 - t911 - t915 + t718 + t788 + t917 + t920 - t922
  t925 = 0.8e1 * t207 * t255
  t926 = t202 * t222
  t927 = 0.8e1 * t926
  t931 = 0.11696447245269292414524477327518106963944910680856e1 * t264 * t762 * t764 * t250
  t932 = -t925 + t927 + t569 - t712 - t572 + t931 - t581 - t753 + t669 + t564 - t567 + t576
  t939 = 0.1e1 / t272 / t23
  t940 = t3 * t939
  t947 = -(t923 + t932) * t42 * t117 + 0.6e1 * t270 * t285 - 0.12e2 * t115 * t940 * t702 + 0.3e1 * t115 * t274 * t854
  t953 = t129 * t273
  t959 = -0.27801896084645508333333333333333333333333333333333e-2 * t167 * t168 * t169 * t796 * t119 + t805 + 0.11120758433858203333333333333333333333333333333333e-2 * t809 + t820 + 0.55603792169291016666666666666666666666666666666666e-3 * t827 - t833 - 0.19772708495399885526666666666666666666666666666666e-2 * t837 - 0.55603792169291016666666666666666666666666666666666e-2 * t126 * t301 * t133 * t30 * t854 + t866 + 0.25948436345669141111111111111111111111111111111110e-1 * t869 - t876 - 0.98863542476999427633333333333333333333333333333332e-3 * t880 + 0.12974218172834570555555555555555555555555555555555e-1 * t885 + 0.11120758433858203333333333333333333333333333333333e-1 * t167 * t887 * t30 * t288 * t889 + 0.55603792169291016666666666666666666666666666666666e-2 * t898 * t168 * t169 * t796 * t899 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t168 * t169 * t947 * t119 + 0.16681137650787305000000000000000000000000000000000e-1 * t126 * t953 * t133 * t30 * t702
  t974 = t5 * t25 * (-0.31250000000000000000000000000000000000000000000000e0 * t791 * t792 * t120 + 0.25000000000000000000000000000000000000000000000000e0 * t141 * t959 * t120 + 0.50000000000000000000000000000000000000000000000000e0 * t308 * t289 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t947 * t119 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t796 * t119) * t321
  t977 = 0.3e1 * t5 * t476 * t854
  t978 = t5 * t24
  t979 = t316 * t321
  t982 = 0.6e1 * t978 * t979 * t284
  t983 = t712 - t714 - t718 - t788 - t974 + t753 - t977 - t982 - t920 + t922 - t917 + t925 - t927 + t908 + t911 + t915 - t931
  t986 = 0.2e1 * t430 * t523 + t529 * (t706 + t983) + t564 - t567 + t569 - t572 + t576 - t581 + t669 + t685 + t694 - t700 + t705 - t712 + t714
  t995 = 0.1e1 / t331
  t996 = t373 ** 2
  t997 = t995 * t996
  t1000 = t332 * t536
  t1003 = 0.1e1 / t341
  t1004 = t377 ** 2
  t1005 = t1003 * t1004
  t1009 = -t342 * t536
  t1012 = 0.11e2 / 0.9e1 * t651
  t1020 = 0.1e1 / t386 / t355
  t1021 = t354 * t1020
  t1022 = t390 ** 2
  t1034 = 0.5e1 / 0.9e1 * (0.40e2 / 0.9e1 * tau0 / t326 / t367 / r0 * t333 - 0.50e2 / 0.9e1 * t370 * t374 + 0.10e2 / 0.9e1 * t329 * t997 + 0.5e1 / 0.3e1 * t329 * t1000 + 0.10e2 / 0.9e1 * t339 * t1005 + 0.5e1 / 0.3e1 * t339 * t1009 - t1012) * t350 * t357 - 0.10e2 / 0.9e1 * t384 * t391 + 0.10e2 / 0.9e1 * t351 * t1021 * t1022 - 0.5e1 / 0.9e1 * t351 * t388 * (0.10e2 / 0.9e1 * t997 + 0.5e1 / 0.3e1 * t1000 + 0.10e2 / 0.9e1 * t1005 + 0.5e1 / 0.3e1 * t1009)
  t1035 = f.my_piecewise3(t366, t1034, 0)
  t1038 = t395 ** 2
  t1043 = t396 / t401 / t397
  t1050 = t406 ** 2
  t1053 = f.my_piecewise3(t365, 0, (-0.64e0 * t1035 * t398 - 0.128e1 * t1038 * t402 - 0.128e1 * t1043 * t1038 - 0.64e0 * t403 * t1035) * t409 + t1050 * t409)
  t1055 = 0.1e1 / t420 / t419
  t1056 = t422 ** 2
  t1060 = f.my_piecewise3(t417, 0, t1034)
  t1064 = t420 ** 2
  t1065 = 0.1e1 / t1064
  t1070 = f.my_piecewise3(t417, 0, -0.210e1 * t1055 * t1056 * t426 - 0.105e1 * t421 * t1060 * t426 - 0.1575e1 * t1065 * t1056 * t426)
  t1071 = f.my_piecewise3(t360, t1053, t1070)
  t1073 = t1071 * t470 + t718 - t753 + t788 - t908 - t911 - t915 + t917 + t920 - t922 - t925 + t927 + t931 + t974 + t977 + t982
  t1076 = t529 * t523
  t1078 = 0.11696447245269292414524477327518106963944910680856e1 * t267
  d11 = 0.2e1 * t323 + 0.2e1 * t471 + 0.39503346997227602814966679236413104097888262435310e-1 * t257 + t474 - t475 + 0.6e1 * t478 + t480 + 0.2e1 * t223 + t482 - t483 + t484 + t7 * (t986 + t1073) + 0.2e1 * t1076 - t1078
  t1079 = -t8 - t211
  t1082 = f.my_piecewise3(t11, 0, 0.4e1 / 0.3e1 * t14 * t1079)
  t1083 = -t1079
  t1086 = f.my_piecewise3(t18, 0, 0.4e1 / 0.3e1 * t19 * t1083)
  t1088 = (t1082 + t1086) * t81
  t1089 = t1088 * t107
  t1090 = 0.19751673498613801407483339618206552048944131217655e-1 * t1089
  t1091 = t1088 * t109
  t1092 = t202 * t1091
  t1093 = 0.4e1 * t1092
  t1094 = t207 * t1091
  t1095 = 0.4e1 * t1094
  t1103 = f.my_piecewise3(t11, 0, 0.4e1 / 0.9e1 * t530 * t1079 * t212 + 0.8e1 / 0.3e1 * t14 * t6 * t534)
  t1111 = f.my_piecewise3(t18, 0, 0.4e1 / 0.9e1 * t542 * t1083 * t216 - 0.8e1 / 0.3e1 * t19 * t6 * t534)
  t1113 = (t1103 + t1111) * t81
  t1115 = t71 * t1113 * t109
  t1117 = t1088 * t26 * t261
  t1118 = 0.18311447306006545054854346104378990962041954983034e-3 * t1117
  t1119 = t71 * t1091
  t1121 = (t175 + t200 - t204 - t209 + t1119 + t256 + t1090 - t263 - t268) * t42
  t1125 = f.my_piecewise3(t11, 0, 0.2e1 / 0.3e1 * t275 * t1079)
  t1128 = f.my_piecewise3(t18, 0, 0.2e1 / 0.3e1 * t279 * t1083)
  t1130 = t1125 / 0.2e1 + t1128 / 0.2e1
  t1131 = t274 * t1130
  t1134 = -t1121 * t117 + 0.3e1 * t115 * t1131
  t1135 = t1134 * t119
  t1137 = t168 * t169 * t1135
  t1140 = t30 * t1130
  t1141 = t133 * t1140
  t1145 = -t152 + t161 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t1137 - t300 - 0.55603792169291016666666666666666666666666666666666e-2 * t126 * t301 * t1141
  t1146 = t141 * t1145
  t1149 = t312 * t1134
  t1152 = 0.25000000000000000000000000000000000000000000000000e0 * t1146 * t120 + 0.10000000000000000000000000000000000000000000000000e1 * t1149 * t119
  t1153 = t1152 * t321
  t1156 = 0.3e1 * t978 * t1153 * t284
  t1159 = 0.3e1 * t978 * t979 * t1130
  t1164 = 0.6e1 * t5 * t23 * t467 * t1130 * t284
  t1165 = 0.18311447306006545054854346104378990962041954983034e-3 * t571
  t1170 = t149 * t133
  t1171 = t30 * t1134
  t1177 = t884 * t1137
  t1192 = t806 * t1130
  t1194 = t147 * t148 * t1192
  t1197 = t130 * t1134 * t119
  t1199 = t822 * t823 * t1197
  t1202 = t835 * t381 * t1192
  t1205 = 0.55603792169291016666666666666666666666666666666666e-2 * t898 * t1170 * t1171 * t899 * t288 + 0.64871090864172852777777777777777777777777777777777e-2 * t1177 + 0.55603792169291016666666666666666666666666666666666e-2 * t167 * t887 * t1171 * t889 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t1170 * t1171 * t289 + 0.55603792169291016666666666666666666666666666666666e-2 * t167 * t887 * t1140 * t289 + 0.55603792169291016666666666666666666666666666666666e-3 * t809 + 0.55603792169291016666666666666666666666666666666666e-3 * t1194 + t805 + t820 + 0.27801896084645508333333333333333333333333333333333e-3 * t1199 - 0.98863542476999427633333333333333333333333333333332e-3 * t1202 + 0.27801896084645508333333333333333333333333333333333e-3 * t827
  t1214 = f.my_piecewise3(t11, 0, -0.2e1 / 0.9e1 * t839 * t1079 * t212 + 0.4e1 / 0.3e1 * t275 * t6 * t534)
  t1222 = f.my_piecewise3(t18, 0, -0.2e1 / 0.9e1 * t846 * t1083 * t216 - 0.4e1 / 0.3e1 * t279 * t6 * t534)
  t1224 = t1214 / 0.2e1 + t1222 / 0.2e1
  t1233 = t877 * t878 * t1197
  t1236 = t71 * t1088 * t254
  t1238 = t1088 * t97 * t266
  t1239 = 0.58482236226346462072622386637590534819724553404280e0 * t1238
  t1241 = 0.19751673498613801407483339618206552048944131217655e-1 * t1113 * t107
  t1242 = t1093 - t1095 + t1115 - t1118 - t564 - t1165 + t576 - t581 + t1236 - t1239 + t1241 + t669 + t685
  t1243 = 0.4e1 * t921
  t1244 = 0.4e1 * t926
  t1245 = 0.58482236226346462072622386637590534819724553404280e0 * t910
  t1246 = t694 - t712 + t718 + t788 - t753 + t919 - t1243 - t925 - t1244 - t908 - t1245 - t915 + t931
  t1262 = -(t1242 + t1246) * t42 * t117 + 0.3e1 * t1121 * t285 + 0.3e1 * t270 * t1131 - 0.12e2 * t115 * t3 * t939 * t1130 * t284 + 0.3e1 * t115 * t274 * t1224
  t1270 = t126 * t867 * t1141
  t1281 = -t833 - 0.98863542476999427633333333333333333333333333333332e-3 * t837 - 0.55603792169291016666666666666666666666666666666666e-2 * t126 * t301 * t133 * t30 * t1224 + t866 + 0.12974218172834570555555555555555555555555555555555e-1 * t869 - t876 - 0.49431771238499713816666666666666666666666666666666e-3 * t880 - 0.49431771238499713816666666666666666666666666666666e-3 * t1233 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t168 * t169 * t1262 * t119 + 0.64871090864172852777777777777777777777777777777777e-2 * t885 + 0.12974218172834570555555555555555555555555555555555e-1 * t1270 + 0.16681137650787305000000000000000000000000000000000e-1 * t43 * t122 * t165 * t78 * t273 * t51 * t169 * t1130 * t284
  t1298 = t5 * t25 * (-0.31250000000000000000000000000000000000000000000000e0 * t791 * t1145 * t120 * t307 + 0.25000000000000000000000000000000000000000000000000e0 * t141 * (t1205 + t1281) * t120 + 0.25000000000000000000000000000000000000000000000000e0 * t1146 * t289 + 0.25000000000000000000000000000000000000000000000000e0 * t308 * t1135 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t1262 * t119 + 0.10000000000000000000000000000000000000000000000000e1 * t1149 * t289) * t321
  t1301 = 0.3e1 * t5 * t476 * t1224
  t1305 = t5 * t25 * t1152 * t698 * t316
  t1306 = t1088 * t465
  t1310 = 0.12e2 * t515 + 0.12e2 * t518
  t1313 = t5 * t476 * t1130
  t1314 = 0.3e1 * t1313
  t1317 = t5 * t25 * t1152 * t321
  t1318 = t509 - 0.2363e1 * t510 * t1306 + t458 * t1310 - t175 - t200 + t204 + t209 - t1119 - t256 - t1090 + t263 + t268 - t1314 - t1317
  t1320 = t430 * t1318 + t1093 - t1095 + t1115 - t1118 + t1156 + t1159 + t1164 - t1165 + t1236 - t1239 + t1241 + t1298 + t1301 - t1305 - t564 + t576 - t581
  t1321 = t1079 / 0.2e1
  t1322 = t332 * t1321
  t1325 = r1 ** 2
  t1328 = tau1 / t336 / t1325
  t1331 = -t1321
  t1332 = t342 * t1331
  t1336 = (0.5e1 / 0.3e1 * t329 * t1322 - 0.5e1 / 0.3e1 * t1328 * t343 + 0.5e1 / 0.3e1 * t339 * t1332 + t382) * t350
  t1339 = 0.5e1 / 0.3e1 * t1322 + 0.5e1 / 0.3e1 * t1332
  t1340 = t388 * t1339
  t1343 = 0.5e1 / 0.9e1 * t1336 * t357 - 0.5e1 / 0.9e1 * t351 * t1340
  t1344 = f.my_piecewise3(t366, t1343, 0)
  t1349 = -0.64e0 * t1344 * t398 - 0.64e0 * t403 * t1344
  t1351 = f.my_piecewise3(t365, 0, t1349 * t409)
  t1352 = f.my_piecewise3(t417, 0, t1343)
  t1356 = f.my_piecewise3(t417, 0, -0.105e1 * t421 * t1352 * t426)
  t1357 = f.my_piecewise3(t360, t1351, t1356)
  t1362 = t995 * t1321 * t373
  t1366 = t332 * t6 * t534
  t1372 = t1003 * t1331 * t377
  t1376 = t342 * t6 * t534
  t1400 = 0.5e1 / 0.9e1 * (-0.25e2 / 0.9e1 * t370 * t1322 + 0.10e2 / 0.9e1 * t329 * t1362 + 0.5e1 / 0.3e1 * t329 * t1366 - 0.25e2 / 0.9e1 * t1328 * t378 + 0.10e2 / 0.9e1 * t339 * t1372 - 0.5e1 / 0.3e1 * t339 * t1376 - t1012) * t350 * t357 - 0.5e1 / 0.9e1 * t1336 * t391 - 0.5e1 / 0.9e1 * t384 * t1340 + 0.10e2 / 0.9e1 * t351 * t354 * t1020 * t1339 * t390 - 0.5e1 / 0.9e1 * t351 * t388 * (0.10e2 / 0.9e1 * t1362 + 0.5e1 / 0.3e1 * t1366 + 0.10e2 / 0.9e1 * t1372 - 0.5e1 / 0.3e1 * t1376)
  t1401 = f.my_piecewise3(t366, t1400, 0)
  t1417 = f.my_piecewise3(t365, 0, (-0.64e0 * t1401 * t398 - 0.128e1 * t1344 * t402 * t395 - 0.128e1 * t1043 * t1344 * t395 - 0.64e0 * t403 * t1401) * t409 + t1349 * t406 * t409)
  t1419 = t426 * t422
  t1422 = f.my_piecewise3(t417, 0, t1400)
  t1430 = f.my_piecewise3(t417, 0, -0.210e1 * t1055 * t1352 * t1419 - 0.105e1 * t421 * t1422 * t426 - 0.1575e1 * t1065 * t1352 * t1419)
  t1431 = f.my_piecewise3(t360, t1417, t1430)
  t1437 = t559 * t1306
  t1445 = -t1093 + t1095 - t1115 - 0.2363e1 * t560 + t1118 - t1156 + t564 - t1159 - t1164 + t1165 - t576 + t581 - t1298 - 0.2363e1 * t510 * t221 * t1310 - 0.2363e1 * t1437 - 0.2363e1 * t510 * t1113 * t465 - 0.2363e1 * t510 * t1088 * t520 + t582 + t665 - t1236
  t1448 = t508 * t1310
  t1450 = -t718 - t788 + t753 - t919 + t1243 + t925 + t1244 + t908 + t1245 + t915 - t931
  t1454 = t669 + t685 + t694 - t712 + t718 + t788 + t1357 * t523 - t753 + t919 - t1243 + t1431 * t470 + t529 * (t1445 - t1301 + t1239 + t1305 - t1241 - t669 - t685 - t694 + t712 + t458 * (t586 - t593) + t1448 + t1450) - t925 - t1244 - t908 - t1245 - t915 + t931
  t1457 = t529 * t1318
  t1458 = t1357 * t470
  d12 = -t475 + t1090 + t474 + t7 * (t1320 + t1454) + t1076 + t471 + t258 + t1317 + t1457 - t1078 + t323 + t1314 + t223 + t522 + t1458 + t484 - t483 + t1119 + t480
  t1461 = 0.8e1 * t1092
  t1462 = 0.8e1 * t1094
  t1463 = 0.36622894612013090109708692208757981924083909966068e-3 * t1117
  t1464 = t1152 ** 2
  t1467 = t5 * t25 * t1464 * t698
  t1468 = t1079 ** 2
  t1471 = t210 + t535
  t1472 = 0.2e1 * t1471
  t1476 = f.my_piecewise3(t11, 0, 0.4e1 / 0.9e1 * t530 * t1468 + 0.4e1 / 0.3e1 * t14 * t1472)
  t1477 = t1083 ** 2
  t1480 = -t1472
  t1484 = f.my_piecewise3(t18, 0, 0.4e1 / 0.9e1 * t542 * t1477 + 0.4e1 / 0.3e1 * t19 * t1480)
  t1486 = (t1476 + t1484) * t81
  t1488 = t71 * t1486 * t109
  t1489 = t1145 ** 2
  t1493 = t1134 ** 2
  t1518 = f.my_piecewise3(t11, 0, -0.2e1 / 0.9e1 * t839 * t1468 + 0.2e1 / 0.3e1 * t275 * t1472)
  t1524 = f.my_piecewise3(t18, 0, -0.2e1 / 0.9e1 * t846 * t1477 + 0.2e1 / 0.3e1 * t279 * t1480)
  t1526 = t1518 / 0.2e1 + t1524 / 0.2e1
  t1534 = 0.11696447245269292414524477327518106963944910680856e1 * t1238
  t1536 = 0.19751673498613801407483339618206552048944131217655e-1 * t1486 * t107
  t1537 = t694 + t685 - t1463 + t931 - t908 - t581 - t1534 + t1536 + t669 + t564 - t1461
  t1538 = 0.2e1 * t1236
  t1539 = -t569 - t915 + t788 + t1488 + t1538 - t1462 - t925 - t712 + t718 + t567 - t753 + t576
  t1545 = t1130 ** 2
  t1552 = -(t1537 + t1539) * t42 * t117 + 0.6e1 * t1121 * t1131 - 0.12e2 * t115 * t940 * t1545 + 0.3e1 * t115 * t274 * t1526
  t1563 = 0.55603792169291016666666666666666666666666666666666e-2 * t898 * t168 * t169 * t1493 * t899 + 0.12974218172834570555555555555555555555555555555555e-1 * t1177 + 0.11120758433858203333333333333333333333333333333333e-1 * t167 * t887 * t1171 * t119 * t1130 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t168 * t169 * t1493 * t119 + t805 + 0.11120758433858203333333333333333333333333333333333e-2 * t1194 + t820 + 0.55603792169291016666666666666666666666666666666666e-3 * t1199 - t833 - 0.19772708495399885526666666666666666666666666666666e-2 * t1202 - 0.55603792169291016666666666666666666666666666666666e-2 * t126 * t301 * t133 * t30 * t1526 + t866 + 0.25948436345669141111111111111111111111111111111110e-1 * t1270 - t876 - 0.98863542476999427633333333333333333333333333333332e-3 * t1233 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t168 * t169 * t1552 * t119 + 0.16681137650787305000000000000000000000000000000000e-1 * t126 * t953 * t133 * t30 * t1545
  t1578 = t5 * t25 * (-0.31250000000000000000000000000000000000000000000000e0 * t791 * t1489 * t120 + 0.25000000000000000000000000000000000000000000000000e0 * t141 * t1563 * t120 + 0.50000000000000000000000000000000000000000000000000e0 * t1146 * t1135 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t1552 * t119 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t1493 * t119) * t321
  t1581 = 0.6e1 * t5 * t701 * t1545
  t1584 = 0.3e1 * t5 * t476 * t1526
  t1585 = -t1461 - t1462 - t1463 - t1467 + t1488 + t1578 + t564 + t567 - t569 + t1581 + t1584 + t576 - t581 + t1538 - t1534
  t1597 = t1461 + t1462 + t1463 + t1467 - t1488 - t1578 - t564 - t567 + t569 - t1581 - 0.2363e1 * t510 * t1486 * t465 - 0.4726e1 * t510 * t1088 * t1310 - t1584 + t458 * (-t586 - t588 - t593) - t576 + t581 - 0.4726e1 * t1437
  t1601 = 0.6e1 * t978 * t1153 * t1130
  t1602 = t665 - t1538 + t1534 - t1536 - t669 - t685 - t694 + t712 + 0.2e1 * t1448 - t718 - t788 + t753 - t1601 + t925 + t908 + t915 - t931
  t1605 = t1321 ** 2
  t1606 = t995 * t1605
  t1609 = t332 * t1471
  t1620 = t1331 ** 2
  t1621 = t1003 * t1620
  t1625 = -t342 * t1471
  t1634 = t1339 ** 2
  t1646 = 0.5e1 / 0.9e1 * (0.10e2 / 0.9e1 * t329 * t1606 + 0.5e1 / 0.3e1 * t329 * t1609 + 0.40e2 / 0.9e1 * tau1 / t336 / t1325 / r1 * t343 - 0.50e2 / 0.9e1 * t1328 * t1332 + 0.10e2 / 0.9e1 * t339 * t1621 + 0.5e1 / 0.3e1 * t339 * t1625 - t1012) * t350 * t357 - 0.10e2 / 0.9e1 * t1336 * t1340 + 0.10e2 / 0.9e1 * t351 * t1021 * t1634 - 0.5e1 / 0.9e1 * t351 * t388 * (0.10e2 / 0.9e1 * t1606 + 0.5e1 / 0.3e1 * t1609 + 0.10e2 / 0.9e1 * t1621 + 0.5e1 / 0.3e1 * t1625)
  t1647 = f.my_piecewise3(t366, t1646, 0)
  t1650 = t1344 ** 2
  t1659 = t1349 ** 2
  t1662 = f.my_piecewise3(t365, 0, (-0.64e0 * t1647 * t398 - 0.128e1 * t1650 * t402 - 0.128e1 * t1043 * t1650 - 0.64e0 * t403 * t1647) * t409 + t1659 * t409)
  t1663 = t1352 ** 2
  t1667 = f.my_piecewise3(t417, 0, t1646)
  t1675 = f.my_piecewise3(t417, 0, -0.210e1 * t1055 * t1663 * t426 - 0.105e1 * t421 * t1667 * t426 - 0.1575e1 * t1065 * t1663 * t426)
  t1676 = f.my_piecewise3(t360, t1662, t1675)
  t1678 = 0.2e1 * t1357 * t1318 + t529 * (t1597 + t1602) + t1536 + t669 + t685 + t694 - t712 + t718 + t788 - t753 + t1676 * t470 + t1601 - t925 - t908 - t915 + t931
  d22 = -t1078 + t484 - t482 - t483 - t475 + 0.2e1 * t1458 + 0.2e1 * t1317 + t474 + t7 * (t1585 + t1678) + 0.39503346997227602814966679236413104097888262435310e-1 * t1089 + 0.2e1 * t1457 + 0.6e1 * t1313 + t480 + 0.2e1 * t1119
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

