"""Generated from mgga_x_br89.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_at_raw = params.at
  if isinstance(params_at_raw, (str, bytes, dict)):
    params_at = params_at_raw
  else:
    try:
      params_at_seq = list(params_at_raw)
    except TypeError:
      params_at = params_at_raw
    else:
      params_at_seq = np.asarray(params_at_seq, dtype=np.float64)
      params_at = np.concatenate((np.array([np.nan], dtype=np.float64), params_at_seq))
  params_gamma_raw = params.gamma
  if isinstance(params_gamma_raw, (str, bytes, dict)):
    params_gamma = params_gamma_raw
  else:
    try:
      params_gamma_seq = list(params_gamma_raw)
    except TypeError:
      params_gamma = params_gamma_raw
    else:
      params_gamma_seq = np.asarray(params_gamma_seq, dtype=np.float64)
      params_gamma = np.concatenate((np.array([np.nan], dtype=np.float64), params_gamma_seq))

  br89_Q = lambda x, u, t: (u - 4 * params_gamma * t + params_gamma * x ** 2 / 2) / 6

  br89_min_Q = 5e-13

  br89_v = lambda x: -2 * jnp.pi ** (1 / 3) / X_FACTOR_C * jnp.exp(x / 3) * (1 - jnp.exp(-x) * (1 + x / 2)) / x

  br89_mx = lambda Q: br89_x(Q)

  br89_cQ = lambda Q: f.my_piecewise3(jnp.abs(Q) < br89_min_Q, f.my_piecewise3(Q > 0, br89_min_Q, -br89_min_Q), Q)

  br89_f = lambda x, u, t: -br89_v(br89_mx(br89_cQ(br89_Q(x, u, t)))) / 2 * (1 + params_at * mgga_series_w(np.array([np.nan, 0, 1, 0, -2, 0, 1], dtype=np.float64), 6, t))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, br89_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_at_raw = params.at
  if isinstance(params_at_raw, (str, bytes, dict)):
    params_at = params_at_raw
  else:
    try:
      params_at_seq = list(params_at_raw)
    except TypeError:
      params_at = params_at_raw
    else:
      params_at_seq = np.asarray(params_at_seq, dtype=np.float64)
      params_at = np.concatenate((np.array([np.nan], dtype=np.float64), params_at_seq))
  params_gamma_raw = params.gamma
  if isinstance(params_gamma_raw, (str, bytes, dict)):
    params_gamma = params_gamma_raw
  else:
    try:
      params_gamma_seq = list(params_gamma_raw)
    except TypeError:
      params_gamma = params_gamma_raw
    else:
      params_gamma_seq = np.asarray(params_gamma_seq, dtype=np.float64)
      params_gamma = np.concatenate((np.array([np.nan], dtype=np.float64), params_gamma_seq))

  br89_Q = lambda x, u, t: (u - 4 * params_gamma * t + params_gamma * x ** 2 / 2) / 6

  br89_min_Q = 5e-13

  br89_v = lambda x: -2 * jnp.pi ** (1 / 3) / X_FACTOR_C * jnp.exp(x / 3) * (1 - jnp.exp(-x) * (1 + x / 2)) / x

  br89_mx = lambda Q: br89_x(Q)

  br89_cQ = lambda Q: f.my_piecewise3(jnp.abs(Q) < br89_min_Q, f.my_piecewise3(Q > 0, br89_min_Q, -br89_min_Q), Q)

  br89_f = lambda x, u, t: -br89_v(br89_mx(br89_cQ(br89_Q(x, u, t)))) / 2 * (1 + params_at * mgga_series_w(np.array([np.nan, 0, 1, 0, -2, 0, 1], dtype=np.float64), 6, t))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, br89_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_at_raw = params.at
  if isinstance(params_at_raw, (str, bytes, dict)):
    params_at = params_at_raw
  else:
    try:
      params_at_seq = list(params_at_raw)
    except TypeError:
      params_at = params_at_raw
    else:
      params_at_seq = np.asarray(params_at_seq, dtype=np.float64)
      params_at = np.concatenate((np.array([np.nan], dtype=np.float64), params_at_seq))
  params_gamma_raw = params.gamma
  if isinstance(params_gamma_raw, (str, bytes, dict)):
    params_gamma = params_gamma_raw
  else:
    try:
      params_gamma_seq = list(params_gamma_raw)
    except TypeError:
      params_gamma = params_gamma_raw
    else:
      params_gamma_seq = np.asarray(params_gamma_seq, dtype=np.float64)
      params_gamma = np.concatenate((np.array([np.nan], dtype=np.float64), params_gamma_seq))

  br89_Q = lambda x, u, t: (u - 4 * params_gamma * t + params_gamma * x ** 2 / 2) / 6

  br89_min_Q = 5e-13

  br89_v = lambda x: -2 * jnp.pi ** (1 / 3) / X_FACTOR_C * jnp.exp(x / 3) * (1 - jnp.exp(-x) * (1 + x / 2)) / x

  br89_mx = lambda Q: br89_x(Q)

  br89_cQ = lambda Q: f.my_piecewise3(jnp.abs(Q) < br89_min_Q, f.my_piecewise3(Q > 0, br89_min_Q, -br89_min_Q), Q)

  br89_f = lambda x, u, t: -br89_v(br89_mx(br89_cQ(br89_Q(x, u, t)))) / 2 * (1 + params_at * mgga_series_w(np.array([np.nan, 0, 1, 0, -2, 0, 1], dtype=np.float64), 6, t))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, br89_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 <= f.p.dens_threshold
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t6 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold - 0.1e1
  t10 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t11 = -t7
  t12 = r0 - r1
  t13 = t12 * t3
  t14 = f.my_piecewise5(t6, t7, t10, t11, t13)
  t15 = 0.1e1 + t14
  t16 = t15 <= f.p.zeta_threshold
  t17 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t18 = t17 * f.p.zeta_threshold
  t19 = t15 ** (0.1e1 / 0.3e1)
  t21 = f.my_piecewise3(t16, t18, t19 * t15)
  t22 = t2 ** (0.1e1 / 0.3e1)
  t23 = t21 * t22
  t25 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t26 = 0.1e1 / t25
  t27 = 4 ** (0.1e1 / 0.3e1)
  t28 = t26 * t27
  t29 = t23 * t28
  t30 = r0 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t33 = 0.1e1 / t31 / r0
  t36 = params.gamma * tau0
  t39 = params.gamma * s0
  t40 = r0 ** 2
  t42 = 0.1e1 / t31 / t40
  t45 = l0 * t33 / 0.6e1 - 0.2e1 / 0.3e1 * t36 * t33 + t39 * t42 / 0.12e2
  t46 = abs(t45)
  t47 = t46 < 0.50e-12
  t48 = 0.0e0 < t45
  t49 = f.my_piecewise3(t48, 0.50e-12, -0.50e-12)
  t50 = f.my_piecewise3(t47, t49, t45)
  t51 = br89_x(t50)
  t53 = jnp.exp(t51 / 0.3e1)
  t54 = jnp.exp(-t51)
  t57 = t54 * (0.1e1 + t51 / 0.2e1)
  t58 = 0.1e1 - t57
  t59 = t53 * t58
  t60 = 0.1e1 / t51
  t61 = 6 ** (0.1e1 / 0.3e1)
  t62 = t61 ** 2
  t63 = jnp.pi ** 2
  t64 = t63 ** (0.1e1 / 0.3e1)
  t65 = t64 ** 2
  t67 = 0.3e1 / 0.10e2 * t62 * t65
  t68 = tau0 * t33
  t69 = t67 - t68
  t70 = t67 + t68
  t71 = 0.1e1 / t70
  t73 = t69 ** 2
  t74 = t73 * t69
  t75 = t70 ** 2
  t77 = 0.1e1 / t75 / t70
  t80 = t73 ** 2
  t81 = t80 * t69
  t82 = t75 ** 2
  t84 = 0.1e1 / t82 / t70
  t88 = 0.1e1 + params.at * (t69 * t71 - 0.2e1 * t74 * t77 + t81 * t84)
  t89 = t60 * t88
  t90 = t59 * t89
  t93 = f.my_piecewise3(t1, 0, -t29 * t90 / 0.4e1)
  t94 = r1 <= f.p.dens_threshold
  t95 = f.my_piecewise5(t10, t7, t6, t11, -t13)
  t96 = 0.1e1 + t95
  t97 = t96 <= f.p.zeta_threshold
  t98 = t96 ** (0.1e1 / 0.3e1)
  t100 = f.my_piecewise3(t97, t18, t98 * t96)
  t101 = t100 * t22
  t102 = t101 * t28
  t103 = r1 ** (0.1e1 / 0.3e1)
  t104 = t103 ** 2
  t106 = 0.1e1 / t104 / r1
  t109 = params.gamma * tau1
  t112 = params.gamma * s2
  t113 = r1 ** 2
  t115 = 0.1e1 / t104 / t113
  t118 = l1 * t106 / 0.6e1 - 0.2e1 / 0.3e1 * t109 * t106 + t112 * t115 / 0.12e2
  t119 = abs(t118)
  t120 = t119 < 0.50e-12
  t121 = 0.0e0 < t118
  t122 = f.my_piecewise3(t121, 0.50e-12, -0.50e-12)
  t123 = f.my_piecewise3(t120, t122, t118)
  t124 = br89_x(t123)
  t126 = jnp.exp(t124 / 0.3e1)
  t127 = jnp.exp(-t124)
  t130 = t127 * (0.1e1 + t124 / 0.2e1)
  t131 = 0.1e1 - t130
  t132 = t126 * t131
  t133 = 0.1e1 / t124
  t134 = tau1 * t106
  t135 = t67 - t134
  t136 = t67 + t134
  t137 = 0.1e1 / t136
  t139 = t135 ** 2
  t140 = t139 * t135
  t141 = t136 ** 2
  t143 = 0.1e1 / t141 / t136
  t146 = t139 ** 2
  t147 = t146 * t135
  t148 = t141 ** 2
  t150 = 0.1e1 / t148 / t136
  t154 = 0.1e1 + params.at * (t135 * t137 - 0.2e1 * t140 * t143 + t147 * t150)
  t155 = t133 * t154
  t156 = t132 * t155
  t159 = f.my_piecewise3(t94, 0, -t102 * t156 / 0.4e1)
  t160 = t2 ** 2
  t162 = t12 / t160
  t163 = t3 - t162
  t164 = f.my_piecewise5(t6, 0, t10, 0, t163)
  t167 = f.my_piecewise3(t16, 0, 0.4e1 / 0.3e1 * t19 * t164)
  t172 = t22 ** 2
  t173 = 0.1e1 / t172
  t177 = t21 * t173 * t28 * t90 / 0.12e2
  t178 = t23 * t26
  t179 = jnp.pi ** (0.1e1 / 0.3e1)
  t180 = t179 ** 2
  t181 = t27 * t180
  t182 = f.my_piecewise3(t48, 0, 0)
  t193 = f.my_piecewise3(t47, t182, -0.5e1 / 0.18e2 * l0 * t42 + 0.10e2 / 0.9e1 * t36 * t42 - 0.2e1 / 0.9e1 * t39 / t31 / t40 / r0)
  t194 = t50 ** 2
  t195 = 0.1e1 / t194
  t200 = jnp.exp(-0.2e1 / 0.3e1 * t51)
  t201 = 0.1e1 / t200
  t202 = t51 ** 2
  t205 = 0.1e1 / (t202 - 0.2e1 * t51 + 0.3e1)
  t206 = t201 * t205
  t208 = (t51 - 0.2e1) ** 2
  t210 = t206 * t208 * t90
  t213 = t180 * t193
  t214 = t195 * t201
  t216 = t205 * t208
  t217 = t216 * t57
  t221 = t206 * t208 * t54
  t233 = t178 * t27 * t53 * t58 / t202
  t234 = t88 * t180
  t236 = t214 * t216
  t240 = t60 * params.at
  t241 = tau0 * t42
  t245 = t69 / t75
  t248 = t73 * t77
  t252 = t74 / t82
  t255 = t80 * t84
  t260 = t81 / t82 / t75
  t269 = f.my_piecewise3(t1, 0, -t167 * t22 * t28 * t90 / 0.4e1 - t177 - t178 * t181 * t193 * t195 * t210 / 0.12e2 - t29 * t53 * (t213 * t214 * t217 - t213 * t195 * t221 / 0.2e1) * t89 / 0.4e1 + t233 * t234 * t193 * t236 / 0.4e1 - t29 * t59 * t240 * (0.5e1 / 0.3e1 * t241 * t71 + 0.5e1 / 0.3e1 * t245 * t241 - 0.10e2 * t248 * t241 - 0.10e2 * t252 * t241 + 0.25e2 / 0.3e1 * t255 * t241 + 0.25e2 / 0.3e1 * t260 * t241) / 0.4e1)
  t271 = f.my_piecewise5(t10, 0, t6, 0, -t163)
  t274 = f.my_piecewise3(t97, 0, 0.4e1 / 0.3e1 * t98 * t271)
  t282 = t100 * t173 * t28 * t156 / 0.12e2
  t284 = f.my_piecewise3(t94, 0, -t274 * t22 * t28 * t156 / 0.4e1 - t282)
  vrho_0_ = t93 + t159 + t2 * (t269 + t284)
  t287 = -t3 - t162
  t288 = f.my_piecewise5(t6, 0, t10, 0, t287)
  t291 = f.my_piecewise3(t16, 0, 0.4e1 / 0.3e1 * t19 * t288)
  t297 = f.my_piecewise3(t1, 0, -t291 * t22 * t28 * t90 / 0.4e1 - t177)
  t299 = f.my_piecewise5(t10, 0, t6, 0, -t287)
  t302 = f.my_piecewise3(t97, 0, 0.4e1 / 0.3e1 * t98 * t299)
  t307 = t101 * t26
  t308 = f.my_piecewise3(t121, 0, 0)
  t319 = f.my_piecewise3(t120, t308, -0.5e1 / 0.18e2 * l1 * t115 + 0.10e2 / 0.9e1 * t109 * t115 - 0.2e1 / 0.9e1 * t112 / t104 / t113 / r1)
  t320 = t123 ** 2
  t321 = 0.1e1 / t320
  t326 = jnp.exp(-0.2e1 / 0.3e1 * t124)
  t327 = 0.1e1 / t326
  t328 = t124 ** 2
  t331 = 0.1e1 / (t328 - 0.2e1 * t124 + 0.3e1)
  t332 = t327 * t331
  t334 = (t124 - 0.2e1) ** 2
  t336 = t332 * t334 * t156
  t339 = t180 * t319
  t340 = t321 * t327
  t342 = t331 * t334
  t343 = t342 * t130
  t347 = t332 * t334 * t127
  t359 = t307 * t27 * t126 * t131 / t328
  t360 = t154 * t180
  t362 = t340 * t342
  t366 = t133 * params.at
  t367 = tau1 * t115
  t371 = t135 / t141
  t374 = t139 * t143
  t378 = t140 / t148
  t381 = t146 * t150
  t386 = t147 / t148 / t141
  t395 = f.my_piecewise3(t94, 0, -t302 * t22 * t28 * t156 / 0.4e1 - t282 - t307 * t181 * t319 * t321 * t336 / 0.12e2 - t102 * t126 * (t339 * t340 * t343 - t339 * t321 * t347 / 0.2e1) * t155 / 0.4e1 + t359 * t360 * t319 * t362 / 0.4e1 - t102 * t132 * t366 * (0.5e1 / 0.3e1 * t367 * t137 + 0.5e1 / 0.3e1 * t371 * t367 - 0.10e2 * t374 * t367 - 0.10e2 * t378 * t367 + 0.25e2 / 0.3e1 * t381 * t367 + 0.25e2 / 0.3e1 * t386 * t367) / 0.4e1)
  vrho_1_ = t93 + t159 + t2 * (t297 + t395)
  t400 = f.my_piecewise3(t47, t182, params.gamma * t42 / 0.12e2)
  t406 = t180 * t400
  t422 = f.my_piecewise3(t1, 0, -t178 * t181 * t400 * t195 * t210 / 0.12e2 - t29 * t53 * (t406 * t214 * t217 - t406 * t195 * t221 / 0.2e1) * t89 / 0.4e1 + t233 * t234 * t400 * t236 / 0.4e1)
  vsigma_0_ = t2 * t422
  vsigma_1_ = 0.0e0
  t425 = f.my_piecewise3(t120, t308, params.gamma * t115 / 0.12e2)
  t431 = t180 * t425
  t447 = f.my_piecewise3(t94, 0, -t307 * t181 * t425 * t321 * t336 / 0.12e2 - t102 * t126 * (t431 * t340 * t343 - t431 * t321 * t347 / 0.2e1) * t155 / 0.4e1 + t359 * t360 * t425 * t362 / 0.4e1)
  vsigma_2_ = t2 * t447
  t449 = f.my_piecewise3(t47, t182, t33 / 0.6e1)
  t455 = t180 * t449
  t471 = f.my_piecewise3(t1, 0, -t178 * t181 * t449 * t195 * t210 / 0.12e2 - t29 * t53 * (t455 * t214 * t217 - t455 * t195 * t221 / 0.2e1) * t89 / 0.4e1 + t233 * t234 * t449 * t236 / 0.4e1)
  vlapl_0_ = t2 * t471
  t473 = f.my_piecewise3(t120, t308, t106 / 0.6e1)
  t479 = t180 * t473
  t495 = f.my_piecewise3(t94, 0, -t307 * t181 * t473 * t321 * t336 / 0.12e2 - t102 * t126 * (t479 * t340 * t343 - t479 * t321 * t347 / 0.2e1) * t155 / 0.4e1 + t359 * t360 * t473 * t362 / 0.4e1)
  vlapl_1_ = t2 * t495
  t498 = f.my_piecewise3(t47, t182, -0.2e1 / 0.3e1 * params.gamma * t33)
  t504 = t180 * t498
  t535 = f.my_piecewise3(t1, 0, -t178 * t181 * t498 * t195 * t210 / 0.12e2 - t29 * t53 * (t504 * t214 * t217 - t504 * t195 * t221 / 0.2e1) * t89 / 0.4e1 + t233 * t234 * t498 * t236 / 0.4e1 - t29 * t59 * t240 * (-t245 * t33 + 0.6e1 * t248 * t33 + 0.6e1 * t252 * t33 - 0.5e1 * t255 * t33 - 0.5e1 * t260 * t33 - t33 * t71) / 0.4e1)
  vtau_0_ = t2 * t535
  t538 = f.my_piecewise3(t120, t308, -0.2e1 / 0.3e1 * params.gamma * t106)
  t544 = t180 * t538
  t575 = f.my_piecewise3(t94, 0, -t307 * t181 * t538 * t321 * t336 / 0.12e2 - t102 * t126 * (t544 * t340 * t343 - t544 * t321 * t347 / 0.2e1) * t155 / 0.4e1 + t359 * t360 * t538 * t362 / 0.4e1 - t102 * t132 * t366 * (-t106 * t137 - t371 * t106 + 0.6e1 * t374 * t106 + 0.6e1 * t378 * t106 - 0.5e1 * t381 * t106 - 0.5e1 * t386 * t106) / 0.4e1)
  vtau_1_ = t2 * t575
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_at_raw = params.at
  if isinstance(params_at_raw, (str, bytes, dict)):
    params_at = params_at_raw
  else:
    try:
      params_at_seq = list(params_at_raw)
    except TypeError:
      params_at = params_at_raw
    else:
      params_at_seq = np.asarray(params_at_seq, dtype=np.float64)
      params_at = np.concatenate((np.array([np.nan], dtype=np.float64), params_at_seq))
  params_gamma_raw = params.gamma
  if isinstance(params_gamma_raw, (str, bytes, dict)):
    params_gamma = params_gamma_raw
  else:
    try:
      params_gamma_seq = list(params_gamma_raw)
    except TypeError:
      params_gamma = params_gamma_raw
    else:
      params_gamma_seq = np.asarray(params_gamma_seq, dtype=np.float64)
      params_gamma = np.concatenate((np.array([np.nan], dtype=np.float64), params_gamma_seq))

  br89_Q = lambda x, u, t: (u - 4 * params_gamma * t + params_gamma * x ** 2 / 2) / 6

  br89_min_Q = 5e-13

  br89_v = lambda x: -2 * jnp.pi ** (1 / 3) / X_FACTOR_C * jnp.exp(x / 3) * (1 - jnp.exp(-x) * (1 + x / 2)) / x

  br89_mx = lambda Q: br89_x(Q)

  br89_cQ = lambda Q: f.my_piecewise3(jnp.abs(Q) < br89_min_Q, f.my_piecewise3(Q > 0, br89_min_Q, -br89_min_Q), Q)

  br89_f = lambda x, u, t: -br89_v(br89_mx(br89_cQ(br89_Q(x, u, t)))) / 2 * (1 + params_at * mgga_series_w(np.array([np.nan, 0, 1, 0, -2, 0, 1], dtype=np.float64), 6, t))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, br89_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 0.1e1 <= f.p.zeta_threshold
  t4 = f.p.zeta_threshold - 0.1e1
  t6 = f.my_piecewise5(t3, t4, t3, -t4, 0)
  t7 = 0.1e1 + t6
  t9 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t11 = t7 ** (0.1e1 / 0.3e1)
  t13 = f.my_piecewise3(t7 <= f.p.zeta_threshold, t9 * f.p.zeta_threshold, t11 * t7)
  t14 = r0 ** (0.1e1 / 0.3e1)
  t15 = t13 * t14
  t17 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t18 = 0.1e1 / t17
  t19 = 4 ** (0.1e1 / 0.3e1)
  t20 = t18 * t19
  t21 = t15 * t20
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = l0 * t23
  t25 = t14 ** 2
  t27 = 0.1e1 / t25 / r0
  t30 = params.gamma * tau0
  t31 = t23 * t27
  t34 = params.gamma * s0
  t35 = r0 ** 2
  t37 = 0.1e1 / t25 / t35
  t38 = t23 * t37
  t41 = t24 * t27 / 0.6e1 - 0.2e1 / 0.3e1 * t30 * t31 + t34 * t38 / 0.12e2
  t42 = abs(t41)
  t43 = t42 < 0.50e-12
  t44 = 0.0e0 < t41
  t45 = f.my_piecewise3(t44, 0.50e-12, -0.50e-12)
  t46 = f.my_piecewise3(t43, t45, t41)
  t47 = br89_x(t46)
  t49 = jnp.exp(t47 / 0.3e1)
  t50 = jnp.exp(-t47)
  t53 = t50 * (0.1e1 + t47 / 0.2e1)
  t54 = 0.1e1 - t53
  t55 = t49 * t54
  t56 = 0.1e1 / t47
  t57 = 6 ** (0.1e1 / 0.3e1)
  t58 = t57 ** 2
  t59 = jnp.pi ** 2
  t60 = t59 ** (0.1e1 / 0.3e1)
  t61 = t60 ** 2
  t63 = 0.3e1 / 0.10e2 * t58 * t61
  t64 = tau0 * t23
  t65 = t64 * t27
  t66 = t63 - t65
  t67 = t63 + t65
  t68 = 0.1e1 / t67
  t70 = t66 ** 2
  t71 = t70 * t66
  t72 = t67 ** 2
  t74 = 0.1e1 / t72 / t67
  t77 = t70 ** 2
  t78 = t77 * t66
  t79 = t72 ** 2
  t81 = 0.1e1 / t79 / t67
  t85 = 0.1e1 + params.at * (t66 * t68 - 0.2e1 * t71 * t74 + t78 * t81)
  t86 = t56 * t85
  t87 = t55 * t86
  t90 = f.my_piecewise3(t2, 0, -t21 * t87 / 0.4e1)
  t96 = t15 * t18
  t97 = jnp.pi ** (0.1e1 / 0.3e1)
  t98 = t97 ** 2
  t99 = t19 * t98
  t100 = f.my_piecewise3(t44, 0, 0)
  t112 = f.my_piecewise3(t43, t100, -0.5e1 / 0.18e2 * t24 * t37 + 0.10e2 / 0.9e1 * t30 * t38 - 0.2e1 / 0.9e1 * t34 * t23 / t25 / t35 / r0)
  t113 = t46 ** 2
  t114 = 0.1e1 / t113
  t119 = jnp.exp(-0.2e1 / 0.3e1 * t47)
  t120 = 0.1e1 / t119
  t121 = t47 ** 2
  t124 = 0.1e1 / (t121 - 0.2e1 * t47 + 0.3e1)
  t125 = t120 * t124
  t127 = (t47 - 0.2e1) ** 2
  t129 = t125 * t127 * t87
  t132 = t98 * t112
  t133 = t114 * t120
  t135 = t124 * t127
  t136 = t135 * t53
  t140 = t125 * t127 * t50
  t152 = t96 * t19 * t49 * t54 / t121
  t153 = t85 * t98
  t155 = t133 * t135
  t159 = t56 * params.at
  t164 = t66 / t72
  t165 = t64 * t37
  t168 = t70 * t74
  t172 = t71 / t79
  t175 = t77 * t81
  t180 = t78 / t79 / t72
  t189 = f.my_piecewise3(t2, 0, -t13 / t25 * t20 * t87 / 0.12e2 - t96 * t99 * t112 * t114 * t129 / 0.12e2 - t21 * t49 * (t132 * t133 * t136 - t132 * t114 * t140 / 0.2e1) * t86 / 0.4e1 + t152 * t153 * t112 * t155 / 0.4e1 - t21 * t55 * t159 * (0.5e1 / 0.3e1 * t64 * t37 * t68 + 0.5e1 / 0.3e1 * t164 * t165 - 0.10e2 * t168 * t165 - 0.10e2 * t172 * t165 + 0.25e2 / 0.3e1 * t175 * t165 + 0.25e2 / 0.3e1 * t180 * t165) / 0.4e1)
  vrho_0_ = 0.2e1 * r0 * t189 + 0.2e1 * t90
  t192 = params.gamma * t23
  t195 = f.my_piecewise3(t43, t100, t192 * t37 / 0.12e2)
  t201 = t98 * t195
  t217 = f.my_piecewise3(t2, 0, -t96 * t99 * t195 * t114 * t129 / 0.12e2 - t21 * t49 * (t201 * t133 * t136 - t201 * t114 * t140 / 0.2e1) * t86 / 0.4e1 + t152 * t153 * t195 * t155 / 0.4e1)
  vsigma_0_ = 0.2e1 * r0 * t217
  t220 = f.my_piecewise3(t43, t100, t31 / 0.6e1)
  t226 = t98 * t220
  t242 = f.my_piecewise3(t2, 0, -t96 * t99 * t220 * t114 * t129 / 0.12e2 - t21 * t49 * (t226 * t133 * t136 - t226 * t114 * t140 / 0.2e1) * t86 / 0.4e1 + t152 * t153 * t220 * t155 / 0.4e1)
  vlapl_0_ = 0.2e1 * r0 * t242
  t246 = f.my_piecewise3(t43, t100, -0.2e1 / 0.3e1 * t192 * t27)
  t252 = t98 * t246
  t283 = f.my_piecewise3(t2, 0, -t96 * t99 * t246 * t114 * t129 / 0.12e2 - t21 * t49 * (t252 * t133 * t136 - t252 * t114 * t140 / 0.2e1) * t86 / 0.4e1 + t152 * t153 * t246 * t155 / 0.4e1 - t21 * t55 * t159 * (-t164 * t31 + 0.6e1 * t168 * t31 + 0.6e1 * t172 * t31 - 0.5e1 * t175 * t31 - 0.5e1 * t180 * t31 - t31 * t68) / 0.4e1)
  vtau_0_ = 0.2e1 * r0 * t283
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 0.1e1 <= f.p.zeta_threshold
  t4 = f.p.zeta_threshold - 0.1e1
  t6 = f.my_piecewise5(t3, t4, t3, -t4, 0)
  t7 = 0.1e1 + t6
  t9 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t11 = t7 ** (0.1e1 / 0.3e1)
  t13 = f.my_piecewise3(t7 <= f.p.zeta_threshold, t9 * f.p.zeta_threshold, t11 * t7)
  t14 = r0 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = t13 / t15
  t19 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t20 = 0.1e1 / t19
  t21 = 4 ** (0.1e1 / 0.3e1)
  t22 = t20 * t21
  t23 = t17 * t22
  t24 = 2 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = l0 * t25
  t28 = 0.1e1 / t15 / r0
  t31 = tau0 * params.gamma
  t35 = s0 * params.gamma
  t36 = r0 ** 2
  t38 = 0.1e1 / t15 / t36
  t39 = t25 * t38
  t42 = t26 * t28 / 0.6e1 - 0.2e1 / 0.3e1 * t31 * t25 * t28 + t35 * t39 / 0.12e2
  t43 = abs(t42)
  t44 = t43 < 0.50e-12
  t45 = 0.0e0 < t42
  t46 = f.my_piecewise3(t45, 0.50e-12, -0.50e-12)
  t47 = f.my_piecewise3(t44, t46, t42)
  t48 = br89_x(t47)
  t50 = jnp.exp(t48 / 0.3e1)
  t51 = jnp.exp(-t48)
  t54 = t51 * (0.1e1 + t48 / 0.2e1)
  t55 = 0.1e1 - t54
  t56 = t50 * t55
  t57 = 0.1e1 / t48
  t58 = 6 ** (0.1e1 / 0.3e1)
  t59 = t58 ** 2
  t60 = jnp.pi ** 2
  t61 = t60 ** (0.1e1 / 0.3e1)
  t62 = t61 ** 2
  t64 = 0.3e1 / 0.10e2 * t59 * t62
  t65 = tau0 * t25
  t66 = t65 * t28
  t67 = t64 - t66
  t68 = t64 + t66
  t69 = 0.1e1 / t68
  t71 = t67 ** 2
  t72 = t71 * t67
  t73 = t68 ** 2
  t74 = t73 * t68
  t75 = 0.1e1 / t74
  t78 = t71 ** 2
  t79 = t78 * t67
  t80 = t73 ** 2
  t82 = 0.1e1 / t80 / t68
  t86 = 0.1e1 + params.at * (t67 * t69 - 0.2e1 * t72 * t75 + t79 * t82)
  t87 = t57 * t86
  t88 = t56 * t87
  t91 = t13 * t14
  t92 = t91 * t20
  t93 = jnp.pi ** (0.1e1 / 0.3e1)
  t94 = t93 ** 2
  t95 = t21 * t94
  t96 = f.my_piecewise3(t45, 0, 0)
  t103 = 0.1e1 / t15 / t36 / r0
  t104 = t25 * t103
  t108 = f.my_piecewise3(t44, t96, -0.5e1 / 0.18e2 * t26 * t38 + 0.10e2 / 0.9e1 * t31 * t39 - 0.2e1 / 0.9e1 * t35 * t104)
  t109 = t47 ** 2
  t110 = 0.1e1 / t109
  t111 = t108 * t110
  t112 = t95 * t111
  t113 = t92 * t112
  t115 = jnp.exp(-0.2e1 / 0.3e1 * t48)
  t116 = 0.1e1 / t115
  t117 = t48 ** 2
  t119 = t117 - 0.2e1 * t48 + 0.3e1
  t120 = 0.1e1 / t119
  t121 = t116 * t120
  t122 = t48 - 0.2e1
  t123 = t122 ** 2
  t124 = t121 * t123
  t125 = t124 * t88
  t128 = t91 * t22
  t129 = t94 * t108
  t130 = t110 * t116
  t131 = t129 * t130
  t132 = t120 * t123
  t133 = t132 * t54
  t135 = t129 * t110
  t137 = t121 * t123 * t51
  t140 = t131 * t133 - t135 * t137 / 0.2e1
  t141 = t50 * t140
  t142 = t141 * t87
  t145 = t21 * t50
  t146 = 0.1e1 / t117
  t148 = t145 * t55 * t146
  t149 = t92 * t148
  t150 = t86 * t94
  t152 = t130 * t132
  t153 = t150 * t108 * t152
  t156 = t57 * params.at
  t160 = 0.1e1 / t73
  t161 = t67 * t160
  t162 = t65 * t38
  t165 = t71 * t75
  t168 = 0.1e1 / t80
  t169 = t72 * t168
  t172 = t78 * t82
  t176 = 0.1e1 / t80 / t73
  t177 = t79 * t176
  t180 = 0.5e1 / 0.3e1 * t65 * t38 * t69 + 0.5e1 / 0.3e1 * t161 * t162 - 0.10e2 * t165 * t162 - 0.10e2 * t169 * t162 + 0.25e2 / 0.3e1 * t172 * t162 + 0.25e2 / 0.3e1 * t177 * t162
  t181 = t156 * t180
  t182 = t56 * t181
  t186 = f.my_piecewise3(t2, 0, -t23 * t88 / 0.12e2 - t113 * t125 / 0.12e2 - t128 * t142 / 0.4e1 + t149 * t153 / 0.4e1 - t128 * t182 / 0.4e1)
  t188 = t123 * t50
  t190 = t55 * t57
  t191 = params.at * t180
  t196 = t108 ** 2
  t199 = 0.1e1 / t109 / t47
  t200 = t199 * t116
  t206 = t119 ** 2
  t207 = 0.1e1 / t206
  t208 = t116 * t207
  t214 = 0.2e1 * t48 * t94 * t108 * t152 - 0.2e1 * t135 * t124
  t230 = tau0 ** 2
  t231 = t230 * t24
  t232 = t36 ** 2
  t235 = 0.1e1 / t14 / t232 / r0
  t240 = t231 * t235
  t243 = t65 * t103
  t268 = -0.40e2 / 0.9e1 * t65 * t103 * t69 + 0.100e3 / 0.9e1 * t231 * t235 * t160 - 0.500e3 / 0.9e1 * t67 * t75 * t240 - 0.40e2 / 0.9e1 * t161 * t243 - 0.200e3 * t71 * t168 * t240 + 0.80e2 / 0.3e1 * t165 * t243 - 0.200e3 / 0.9e1 * t72 * t82 * t240 + 0.80e2 / 0.3e1 * t169 * t243 + 0.2500e4 / 0.9e1 * t78 * t176 * t240 - 0.200e3 / 0.9e1 * t172 * t243 + 0.500e3 / 0.3e1 * t79 / t80 / t74 * t240 - 0.200e3 / 0.9e1 * t177 * t243
  t291 = f.my_piecewise3(t44, t96, 0.20e2 / 0.27e2 * t26 * t103 - 0.80e2 / 0.27e2 * t31 * t104 + 0.22e2 / 0.27e2 * t35 * t25 / t15 / t232)
  t292 = t94 * t291
  t295 = t94 * t196
  t299 = t93 * jnp.pi
  t300 = t299 * t196
  t301 = t109 ** 2
  t302 = 0.1e1 / t301
  t303 = t115 ** 2
  t304 = 0.1e1 / t303
  t305 = t302 * t304
  t306 = t300 * t305
  t307 = t123 ** 2
  t308 = t207 * t307
  t312 = t207 * t123
  t316 = t123 * t122
  t317 = t207 * t316
  t321 = t300 * t302
  t322 = t304 * t207
  t349 = -t113 * t121 * t188 * t190 * t191 / 0.6e1 - t149 * t150 * t196 * t200 * t132 / 0.2e1 - t149 * t150 * t111 * t208 * t123 * t214 / 0.4e1 + t149 * t191 * t129 * t152 / 0.2e1 - t128 * t141 * t181 / 0.2e1 - t128 * t56 * t156 * t268 / 0.4e1 + t13 * t28 * t22 * t88 / 0.18e2 - t23 * t182 / 0.6e1 - t23 * t142 / 0.6e1 - t128 * t50 * (t292 * t130 * t133 - 0.2e1 * t295 * t200 * t133 - t306 * t308 * t54 / 0.3e1 - t131 * t312 * t54 * t214 + 0.2e1 * t306 * t317 * t54 + 0.2e1 / 0.3e1 * t321 * t322 * t307 * t51 - t292 * t110 * t137 / 0.2e1 + t295 * t199 * t137 + t131 * t312 * t51 * t214 / 0.2e1 - t321 * t322 * t316 * t51) * t87 / 0.4e1 + t92 * t95 * t196 * t199 * t125 / 0.6e1
  t359 = t92 * t21 * t299 * t196 * t302
  t364 = t322 * t307
  t376 = t86 * t299 * t196
  t385 = t17 * t20
  t412 = t113 * t208 * t188 * t190 * t86 * t214 / 0.12e2 - t359 * t322 * t316 * t88 / 0.6e1 + t359 * t364 * t56 * t146 * t86 / 0.3e1 - t92 * t145 * t55 / t117 / t48 * t376 * t305 * t308 / 0.2e1 + t149 * t376 * t305 * t317 / 0.2e1 - t385 * t112 * t125 / 0.18e2 + t385 * t148 * t153 / 0.6e1 - t92 * t95 * t291 * t110 * t125 / 0.12e2 - t113 * t124 * t142 / 0.6e1 - t359 * t364 * t88 / 0.12e2 + t92 * t145 * t140 * t146 * t153 / 0.2e1 + t149 * t150 * t291 * t152 / 0.4e1
  t414 = f.my_piecewise3(t2, 0, t349 + t412)
  v2rho2_0_ = 0.2e1 * r0 * t414 + 0.4e1 * t186
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 0.1e1 <= f.p.zeta_threshold
  t4 = f.p.zeta_threshold - 0.1e1
  t6 = f.my_piecewise5(t3, t4, t3, -t4, 0)
  t7 = 0.1e1 + t6
  t9 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t11 = t7 ** (0.1e1 / 0.3e1)
  t13 = f.my_piecewise3(t7 <= f.p.zeta_threshold, t9 * f.p.zeta_threshold, t11 * t7)
  t14 = r0 ** (0.1e1 / 0.3e1)
  t15 = t13 * t14
  t17 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t18 = 0.1e1 / t17
  t19 = t15 * t18
  t20 = 4 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = t20 * t22
  t24 = 2 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = l0 * t25
  t27 = t14 ** 2
  t29 = 0.1e1 / t27 / r0
  t32 = params.gamma * tau0
  t36 = params.gamma * s0
  t37 = r0 ** 2
  t39 = 0.1e1 / t27 / t37
  t40 = t25 * t39
  t43 = t26 * t29 / 0.6e1 - 0.2e1 / 0.3e1 * t32 * t25 * t29 + t36 * t40 / 0.12e2
  t44 = abs(t43)
  t45 = t44 < 0.50e-12
  t46 = 0.0e0 < t43
  t47 = f.my_piecewise3(t46, 0, 0)
  t54 = 0.1e1 / t27 / t37 / r0
  t55 = t25 * t54
  t59 = f.my_piecewise3(t45, t47, -0.5e1 / 0.18e2 * t26 * t39 + 0.10e2 / 0.9e1 * t32 * t40 - 0.2e1 / 0.9e1 * t36 * t55)
  t60 = f.my_piecewise3(t46, 0.50e-12, -0.50e-12)
  t61 = f.my_piecewise3(t45, t60, t43)
  t62 = t61 ** 2
  t63 = 0.1e1 / t62
  t64 = t59 * t63
  t65 = t23 * t64
  t66 = t19 * t65
  t67 = br89_x(t61)
  t69 = jnp.exp(-0.2e1 / 0.3e1 * t67)
  t70 = 0.1e1 / t69
  t71 = t67 ** 2
  t73 = t71 - 0.2e1 * t67 + 0.3e1
  t74 = 0.1e1 / t73
  t75 = t70 * t74
  t76 = t67 - 0.2e1
  t77 = t76 ** 2
  t79 = jnp.exp(t67 / 0.3e1)
  t80 = t77 * t79
  t81 = t75 * t80
  t82 = jnp.exp(-t67)
  t85 = t82 * (0.1e1 + t67 / 0.2e1)
  t86 = 0.1e1 - t85
  t87 = 0.1e1 / t67
  t88 = t86 * t87
  t89 = tau0 * t25
  t90 = 6 ** (0.1e1 / 0.3e1)
  t91 = t90 ** 2
  t92 = jnp.pi ** 2
  t93 = t92 ** (0.1e1 / 0.3e1)
  t94 = t93 ** 2
  t96 = 0.3e1 / 0.10e2 * t91 * t94
  t97 = t89 * t29
  t98 = t96 + t97
  t99 = 0.1e1 / t98
  t103 = t96 - t97
  t104 = t98 ** 2
  t105 = 0.1e1 / t104
  t106 = t103 * t105
  t107 = t89 * t39
  t110 = t103 ** 2
  t111 = t104 * t98
  t112 = 0.1e1 / t111
  t113 = t110 * t112
  t116 = t110 * t103
  t117 = t104 ** 2
  t118 = 0.1e1 / t117
  t119 = t116 * t118
  t122 = t110 ** 2
  t124 = 0.1e1 / t117 / t98
  t125 = t122 * t124
  t128 = t122 * t103
  t130 = 0.1e1 / t117 / t104
  t131 = t128 * t130
  t134 = 0.5e1 / 0.3e1 * t89 * t39 * t99 + 0.5e1 / 0.3e1 * t106 * t107 - 0.10e2 * t113 * t107 - 0.10e2 * t119 * t107 + 0.25e2 / 0.3e1 * t125 * t107 + 0.25e2 / 0.3e1 * t131 * t107
  t135 = params.at * t134
  t136 = t88 * t135
  t137 = t81 * t136
  t140 = t20 * t79
  t141 = 0.1e1 / t71
  t142 = t86 * t141
  t143 = t140 * t142
  t144 = t19 * t143
  t151 = 0.1e1 + params.at * (t103 * t99 - 0.2e1 * t116 * t112 + t128 * t124)
  t152 = t151 * t22
  t153 = t59 ** 2
  t156 = 0.1e1 / t62 / t61
  t157 = t156 * t70
  t158 = t74 * t77
  t159 = t157 * t158
  t160 = t152 * t153 * t159
  t163 = t152 * t64
  t164 = t73 ** 2
  t165 = 0.1e1 / t164
  t166 = t70 * t165
  t167 = t67 * t22
  t169 = t63 * t70
  t170 = t169 * t158
  t172 = t22 * t59
  t173 = t172 * t63
  t174 = t75 * t77
  t177 = 0.2e1 * t167 * t59 * t170 - 0.2e1 * t173 * t174
  t179 = t166 * t77 * t177
  t180 = t163 * t179
  t184 = t135 * t172 * t170
  t187 = t18 * t20
  t188 = t15 * t187
  t189 = t172 * t169
  t190 = t158 * t85
  t193 = t75 * t77 * t82
  t196 = t189 * t190 - t173 * t193 / 0.2e1
  t197 = t79 * t196
  t198 = t87 * params.at
  t199 = t198 * t134
  t200 = t197 * t199
  t203 = t79 * t86
  t207 = tau0 ** 2
  t208 = t207 * t24
  t209 = t37 ** 2
  t210 = t209 * r0
  t212 = 0.1e1 / t14 / t210
  t216 = t103 * t112
  t217 = t208 * t212
  t220 = t89 * t54
  t223 = t110 * t118
  t228 = t116 * t124
  t233 = t122 * t130
  t239 = 0.1e1 / t117 / t111
  t240 = t128 * t239
  t245 = -0.40e2 / 0.9e1 * t89 * t54 * t99 + 0.100e3 / 0.9e1 * t208 * t212 * t105 - 0.500e3 / 0.9e1 * t216 * t217 - 0.40e2 / 0.9e1 * t106 * t220 - 0.200e3 * t223 * t217 + 0.80e2 / 0.3e1 * t113 * t220 - 0.200e3 / 0.9e1 * t228 * t217 + 0.80e2 / 0.3e1 * t119 * t220 + 0.2500e4 / 0.9e1 * t233 * t217 - 0.200e3 / 0.9e1 * t125 * t220 + 0.500e3 / 0.3e1 * t240 * t217 - 0.200e3 / 0.9e1 * t131 * t220
  t246 = t198 * t245
  t247 = t203 * t246
  t250 = t13 * t29
  t251 = t250 * t187
  t252 = t87 * t151
  t253 = t203 * t252
  t257 = t13 / t27
  t258 = t257 * t187
  t259 = t203 * t199
  t262 = t197 * t252
  t270 = 0.1e1 / t27 / t209
  t271 = t25 * t270
  t275 = f.my_piecewise3(t45, t47, 0.20e2 / 0.27e2 * t26 * t54 - 0.80e2 / 0.27e2 * t32 * t55 + 0.22e2 / 0.27e2 * t36 * t271)
  t276 = t22 * t275
  t277 = t276 * t169
  t279 = t22 * t153
  t280 = t279 * t157
  t283 = t21 * jnp.pi
  t284 = t283 * t153
  t285 = t62 ** 2
  t286 = 0.1e1 / t285
  t287 = t69 ** 2
  t288 = 0.1e1 / t287
  t289 = t286 * t288
  t290 = t284 * t289
  t291 = t77 ** 2
  t292 = t165 * t291
  t293 = t292 * t85
  t296 = t165 * t77
  t297 = t85 * t177
  t298 = t296 * t297
  t300 = t77 * t76
  t301 = t165 * t300
  t302 = t301 * t85
  t305 = t284 * t286
  t306 = t288 * t165
  t307 = t291 * t82
  t308 = t306 * t307
  t311 = t276 * t63
  t314 = t279 * t156
  t316 = t82 * t177
  t317 = t296 * t316
  t321 = t306 * t300 * t82
  t323 = t277 * t190 - 0.2e1 * t280 * t190 - t290 * t293 / 0.3e1 - t189 * t298 + 0.2e1 * t290 * t302 + 0.2e1 / 0.3e1 * t305 * t308 - t311 * t193 / 0.2e1 + t314 * t193 + t189 * t317 / 0.2e1 - t305 * t321
  t324 = t79 * t323
  t325 = t324 * t252
  t328 = t153 * t156
  t329 = t23 * t328
  t330 = t19 * t329
  t331 = t174 * t253
  t334 = -t66 * t137 / 0.6e1 - t144 * t160 / 0.2e1 - t144 * t180 / 0.4e1 + t144 * t184 / 0.2e1 - t188 * t200 / 0.2e1 - t188 * t247 / 0.4e1 + t251 * t253 / 0.18e2 - t258 * t259 / 0.6e1 - t258 * t262 / 0.6e1 - t188 * t325 / 0.4e1 + t330 * t331 / 0.6e1
  t335 = t166 * t80
  t336 = t151 * t177
  t337 = t88 * t336
  t338 = t335 * t337
  t341 = t20 * t283
  t342 = t153 * t286
  t343 = t341 * t342
  t344 = t19 * t343
  t345 = t306 * t300
  t346 = t345 * t253
  t349 = t306 * t291
  t350 = t141 * t151
  t351 = t203 * t350
  t352 = t349 * t351
  t356 = 0.1e1 / t71 / t67
  t358 = t140 * t86 * t356
  t359 = t19 * t358
  t360 = t151 * t283
  t361 = t360 * t153
  t362 = t289 * t292
  t363 = t361 * t362
  t366 = t289 * t301
  t367 = t361 * t366
  t370 = t257 * t18
  t371 = t370 * t65
  t374 = t370 * t143
  t376 = t152 * t59 * t170
  t379 = t275 * t63
  t380 = t23 * t379
  t381 = t19 * t380
  t384 = t174 * t262
  t387 = t349 * t253
  t391 = t140 * t196 * t141
  t392 = t19 * t391
  t396 = t152 * t275 * t170
  t399 = t66 * t338 / 0.12e2 - t344 * t346 / 0.6e1 + t344 * t352 / 0.3e1 - t359 * t363 / 0.2e1 + t144 * t367 / 0.2e1 - t371 * t331 / 0.18e2 + t374 * t376 / 0.6e1 - t381 * t331 / 0.12e2 - t66 * t384 / 0.6e1 - t344 * t387 / 0.12e2 + t392 * t376 / 0.2e1 + t144 * t396 / 0.4e1
  t401 = f.my_piecewise3(t2, 0, t334 + t399)
  t413 = f.my_piecewise3(t45, t47, -0.220e3 / 0.81e2 * t26 * t270 + 0.880e3 / 0.81e2 * t32 * t271 - 0.308e3 / 0.81e2 * t36 * t25 / t27 / t210)
  t425 = t153 * t59
  t427 = 0.1e1 / t285 / t62
  t430 = t19 * t20 * t92 * t425 * t427
  t432 = 0.1e1 / t287 / t69
  t434 = 0.1e1 / t164 / t73
  t435 = t432 * t434
  t436 = t291 * t77
  t437 = t435 * t436
  t441 = t250 * t18
  t463 = -t19 * t23 * t413 * t63 * t331 / 0.12e2 - t381 * t384 / 0.4e1 - t344 * t349 * t262 / 0.4e1 - 0.5e1 / 0.36e2 * t430 * t437 * t253 + t441 * t65 * t331 / 0.18e2 - t441 * t143 * t376 / 0.6e1 - t371 * t384 / 0.6e1 + t370 * t391 * t376 / 0.2e1 - t66 * t174 * t325 / 0.4e1 + 0.3e1 / 0.4e1 * t19 * t140 * t323 * t141 * t376 + t330 * t384 / 0.2e1
  t465 = 0.1e1 / t285 / t61
  t468 = t19 * t341 * t425 * t465
  t474 = t291 * t76
  t475 = t435 * t474
  t495 = t370 * t343
  t500 = t71 ** 2
  t506 = t151 * t92 * t425
  t507 = t427 * t432
  t508 = t434 * t436
  t513 = t434 * t474
  t518 = t468 * t387 / 0.2e1 - t344 * t345 * t262 / 0.2e1 - 0.11e2 / 0.18e2 * t430 * t475 * t253 + t344 * t349 * t197 * t350 + 0.23e2 / 0.36e2 * t430 * t437 * t351 - 0.3e1 / 0.2e1 * t19 * t140 * t196 * t356 * t363 + 0.3e1 / 0.2e1 * t392 * t367 - t370 * t380 * t331 / 0.12e2 - t495 * t387 / 0.12e2 + t374 * t396 / 0.4e1 + 0.3e1 / 0.2e1 * t19 * t140 * t86 / t500 * t506 * t507 * t508 - 0.3e1 * t359 * t506 * t507 * t513
  t538 = t286 * t70
  t545 = t360 * t425
  t546 = t465 * t288
  t556 = t374 * t367 / 0.2e1 - t370 * t358 * t363 / 0.2e1 - t495 * t346 / 0.6e1 + t495 * t352 / 0.3e1 - t19 * t23 * t425 * t286 * t331 / 0.2e1 + t370 * t329 * t331 / 0.6e1 + 0.3e1 / 0.2e1 * t144 * t152 * t425 * t538 * t158 - t374 * t160 / 0.2e1 + 0.3e1 * t359 * t545 * t546 * t292 - 0.3e1 * t144 * t545 * t546 * t301 + t468 * t346
  t567 = t434 * t291
  t584 = t196 * t87
  t589 = params.at * t245
  t594 = t291 * t79
  t595 = t306 * t594
  t601 = 0.3e1 / 0.4e1 * t392 * t396 + t144 * t152 * t413 * t170 / 0.4e1 - 0.3e1 / 0.2e1 * t392 * t160 - 0.2e1 * t468 * t352 + 0.3e1 / 0.2e1 * t144 * t506 * t507 * t567 - t430 * t435 * t291 * t253 / 0.2e1 + 0.7e1 / 0.3e1 * t430 * t475 * t351 - 0.3e1 / 0.2e1 * t430 * t437 * t203 * t356 * t151 - t66 * t81 * t584 * t135 / 0.2e1 - t66 * t81 * t88 * t589 / 0.4e1 - t344 * t595 * t136 / 0.4e1 + t371 * t338 / 0.12e2
  t604 = t70 * t434
  t606 = t177 ** 2
  t614 = t59 * t286
  t616 = t19 * t341 * t614
  t617 = t151 * t275
  t621 = t360 * t614
  t627 = t300 * t79
  t628 = t306 * t627
  t629 = t88 * t617
  t633 = t59 * t156
  t656 = t67 * t283 * t153
  t672 = 0.2e1 / 0.3e1 * t305 * t349 + 0.2e1 * t167 * t275 * t170 - 0.4e1 * t167 * t153 * t159 + 0.4e1 / 0.3e1 * t656 * t362 - 0.2e1 * t167 * t64 * t179 + 0.4e1 * t656 * t366 - 0.2e1 * t311 * t174 + 0.4e1 * t314 * t174 + 0.2e1 * t173 * t179 - 0.4e1 * t305 * t345
  t678 = t288 * t434
  t679 = t678 * t594
  t683 = -t66 * t604 * t80 * t88 * t151 * t606 / 0.6e1 + t374 * t184 / 0.2e1 + t616 * t595 * t142 * t617 - 0.3e1 / 0.2e1 * t359 * t621 * t306 * t291 * t275 - t616 * t628 * t629 / 0.2e1 + t19 * t23 * t633 * t81 * t629 / 0.2e1 - t330 * t338 / 0.3e1 + t381 * t338 / 0.6e1 + t66 * t335 * t584 * t336 / 0.4e1 + t66 * t335 * t88 * t151 * t672 / 0.12e2 + t344 * t679 * t337 / 0.4e1
  t726 = 0.3e1 / 0.2e1 * t392 * t184 - 0.3e1 / 0.2e1 * t144 * t135 * t279 * t159 - 0.3e1 / 0.4e1 * t392 * t180 - t144 * t152 * t379 * t179 / 0.2e1 - t144 * t163 * t166 * t77 * t672 / 0.4e1 - t344 * t679 * t142 * t336 - t381 * t137 / 0.4e1 + 0.3e1 / 0.4e1 * t144 * t135 * t276 * t170 - 0.3e1 / 0.2e1 * t144 * t152 * t633 * t75 * t77 * t275 + t144 * t152 * t328 * t179 + t344 * t678 * t627 * t337 / 0.2e1 - t344 * t628 * t136 / 0.2e1
  t731 = t360 * t342
  t742 = t135 * t284
  t777 = t344 * t595 * t142 * t135 + 0.3e1 / 0.2e1 * t359 * t731 * t678 * t291 * t177 - 0.3e1 / 0.2e1 * t144 * t731 * t678 * t300 * t177 - 0.3e1 / 0.2e1 * t359 * t742 * t362 + 0.3e1 / 0.2e1 * t144 * t742 * t366 - t374 * t180 / 0.4e1 + t144 * t163 * t604 * t77 * t606 / 0.2e1 - t371 * t137 / 0.6e1 + t330 * t137 / 0.2e1 - t19 * t341 * t275 * t286 * t595 * t88 * t151 * t59 / 0.4e1 + 0.3e1 / 0.2e1 * t144 * t621 * t306 * t300 * t275 + 0.3e1 / 0.4e1 * t144 * t589 * t172 * t170
  t792 = 0.1e1 / t14 / t209 / t37
  t793 = t208 * t792
  t801 = t209 ** 2
  t803 = t207 * tau0 / t801
  t815 = t117 ** 2
  t822 = t89 * t270
  t841 = 0.440e3 / 0.27e2 * t89 * t270 * t99 + 0.4000e4 / 0.9e1 * t216 * t793 - 0.800e3 / 0.9e1 * t208 * t792 * t105 - 0.17000e5 / 0.9e1 * t103 * t118 * t803 - 0.26000e5 / 0.9e1 * t110 * t124 * t803 + 0.10000e5 / 0.3e1 * t116 * t130 * t803 + 0.25000e5 / 0.3e1 * t122 * t239 * t803 + 0.35000e5 / 0.9e1 * t128 / t815 * t803 - 0.1000e4 / 0.9e1 * t803 * t112 + 0.440e3 / 0.27e2 * t106 * t822 + 0.1600e4 * t223 * t793 - 0.880e3 / 0.9e1 * t113 * t822 + 0.1600e4 / 0.9e1 * t228 * t793 - 0.880e3 / 0.9e1 * t119 * t822 - 0.20000e5 / 0.9e1 * t233 * t793 + 0.2200e4 / 0.27e2 * t125 * t822 - 0.4000e4 / 0.3e1 * t240 * t793 + 0.2200e4 / 0.27e2 * t131 * t822
  t864 = t22 * t425
  t868 = t283 * t425
  t869 = t868 * t465
  t872 = t92 * t425
  t873 = t872 * t427
  t882 = t22 * t413
  t894 = t283 * t275 * t289
  t895 = t85 * t59
  t903 = t434 * t77
  t908 = t434 * t300
  t917 = t276 * t157
  t921 = -0.3e1 * t864 * t286 * t193 - 0.4e1 * t869 * t308 + t873 * t435 * t436 * t82 / 0.18e2 + 0.10e2 / 0.3e1 * t873 * t435 * t474 * t82 - t882 * t63 * t193 / 0.2e1 + 0.6e1 * t869 * t321 - 0.3e1 * t873 * t435 * t307 - 0.2e1 * t277 * t298 - t894 * t292 * t895 + 0.4e1 * t280 * t298 + 0.6e1 * t894 * t301 * t895 + 0.2e1 * t189 * t903 * t85 * t606 - 0.6e1 * t290 * t908 * t297 + t290 * t567 * t297 - t189 * t296 * t85 * t672 - 0.6e1 * t917 * t158 * t895
  t924 = t868 * t546
  t927 = t872 * t507
  t940 = t82 * t59
  t968 = -0.2e1 * t280 * t317 + 0.2e1 * t924 * t293 - t927 * t508 * t85 / 0.9e1 - 0.2e1 * t290 * t567 * t316 - t189 * t903 * t82 * t606 + 0.6e1 * t864 * t538 * t190 + 0.2e1 * t894 * t292 * t940 + t882 * t169 * t190 - 0.3e1 * t894 * t301 * t940 - 0.12e2 * t924 * t302 - 0.2e1 / 0.3e1 * t927 * t513 * t85 + 0.6e1 * t927 * t567 * t85 + 0.3e1 * t290 * t908 * t316 + t189 * t296 * t82 * t672 / 0.2e1 + 0.3e1 * t917 * t158 * t940 + t277 * t317
  t982 = -0.3e1 / 0.4e1 * t188 * t197 * t246 - t258 * t200 / 0.2e1 - t258 * t247 / 0.4e1 + t251 * t259 / 0.6e1 - t188 * t203 * t198 * t841 / 0.4e1 - 0.3e1 / 0.4e1 * t188 * t324 * t199 - 0.3e1 / 0.4e1 * t188 * t203 * t141 * params.at * t134 * t22 * t64 * t179 + t188 * t189 * t296 * t203 * t198 * t134 * t177 / 0.4e1 - t188 * t79 * (t921 + t968) * t252 / 0.4e1 + t251 * t262 / 0.6e1 - t258 * t325 / 0.4e1 - 0.5e1 / 0.54e2 * t13 * t39 * t187 * t253
  t986 = f.my_piecewise3(t2, 0, t463 + t518 + t556 + t601 + t683 + t726 + t777 + t982)
  v3rho3_0_ = 0.2e1 * r0 * t986 + 0.6e1 * t401

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 0.1e1 <= f.p.zeta_threshold
  t4 = f.p.zeta_threshold - 0.1e1
  t6 = f.my_piecewise5(t3, t4, t3, -t4, 0)
  t7 = 0.1e1 + t6
  t9 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t11 = t7 ** (0.1e1 / 0.3e1)
  t13 = f.my_piecewise3(t7 <= f.p.zeta_threshold, t9 * f.p.zeta_threshold, t11 * t7)
  t14 = r0 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = 0.1e1 / t15 / r0
  t18 = t13 * t17
  t20 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t21 = 0.1e1 / t20
  t22 = 4 ** (0.1e1 / 0.3e1)
  t23 = t21 * t22
  t24 = t18 * t23
  t25 = 2 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = l0 * t26
  t30 = params.gamma * tau0
  t34 = params.gamma * s0
  t35 = r0 ** 2
  t37 = 0.1e1 / t15 / t35
  t38 = t26 * t37
  t41 = t27 * t17 / 0.6e1 - 0.2e1 / 0.3e1 * t30 * t26 * t17 + t34 * t38 / 0.12e2
  t42 = abs(t41)
  t43 = t42 < 0.50e-12
  t44 = 0.0e0 < t41
  t45 = f.my_piecewise3(t44, 0.50e-12, -0.50e-12)
  t46 = f.my_piecewise3(t43, t45, t41)
  t47 = br89_x(t46)
  t49 = jnp.exp(t47 / 0.3e1)
  t50 = jnp.exp(-t47)
  t52 = 0.1e1 + t47 / 0.2e1
  t53 = t50 * t52
  t54 = 0.1e1 - t53
  t55 = t49 * t54
  t56 = 0.1e1 / t47
  t57 = t56 * params.at
  t58 = tau0 * t26
  t59 = 6 ** (0.1e1 / 0.3e1)
  t60 = t59 ** 2
  t61 = jnp.pi ** 2
  t62 = t61 ** (0.1e1 / 0.3e1)
  t63 = t62 ** 2
  t65 = 0.3e1 / 0.10e2 * t60 * t63
  t66 = t58 * t17
  t67 = t65 + t66
  t68 = 0.1e1 / t67
  t72 = t65 - t66
  t73 = t67 ** 2
  t74 = 0.1e1 / t73
  t75 = t72 * t74
  t76 = t58 * t37
  t79 = t72 ** 2
  t80 = t73 * t67
  t81 = 0.1e1 / t80
  t82 = t79 * t81
  t85 = t79 * t72
  t86 = t73 ** 2
  t87 = 0.1e1 / t86
  t88 = t85 * t87
  t91 = t79 ** 2
  t93 = 0.1e1 / t86 / t67
  t94 = t91 * t93
  t97 = t91 * t72
  t99 = 0.1e1 / t86 / t73
  t100 = t97 * t99
  t103 = 0.5e1 / 0.3e1 * t58 * t37 * t68 + 0.5e1 / 0.3e1 * t75 * t76 - 0.10e2 * t82 * t76 - 0.10e2 * t88 * t76 + 0.25e2 / 0.3e1 * t94 * t76 + 0.25e2 / 0.3e1 * t100 * t76
  t104 = t57 * t103
  t105 = t55 * t104
  t108 = t13 * t14
  t109 = t108 * t23
  t110 = t35 ** 2
  t112 = 0.1e1 / t15 / t110
  t116 = t72 * t81
  t117 = tau0 ** 2
  t118 = t117 * t25
  t119 = t110 * t35
  t121 = 0.1e1 / t14 / t119
  t122 = t118 * t121
  t128 = t72 * t87
  t129 = t117 * tau0
  t130 = t110 ** 2
  t132 = t129 / t130
  t135 = t79 * t93
  t138 = t85 * t99
  t142 = 0.1e1 / t86 / t80
  t143 = t91 * t142
  t146 = t86 ** 2
  t147 = 0.1e1 / t146
  t148 = t97 * t147
  t153 = t58 * t112
  t156 = t79 * t87
  t161 = t85 * t93
  t166 = t91 * t99
  t171 = t97 * t142
  t176 = 0.440e3 / 0.27e2 * t58 * t112 * t68 + 0.4000e4 / 0.9e1 * t116 * t122 - 0.800e3 / 0.9e1 * t118 * t121 * t74 - 0.17000e5 / 0.9e1 * t128 * t132 - 0.26000e5 / 0.9e1 * t135 * t132 + 0.10000e5 / 0.3e1 * t138 * t132 + 0.25000e5 / 0.3e1 * t143 * t132 + 0.35000e5 / 0.9e1 * t148 * t132 - 0.1000e4 / 0.9e1 * t132 * t81 + 0.440e3 / 0.27e2 * t75 * t153 + 0.1600e4 * t156 * t122 - 0.880e3 / 0.9e1 * t82 * t153 + 0.1600e4 / 0.9e1 * t161 * t122 - 0.880e3 / 0.9e1 * t88 * t153 - 0.20000e5 / 0.9e1 * t166 * t122 + 0.2200e4 / 0.27e2 * t94 * t153 - 0.4000e4 / 0.3e1 * t171 * t122 + 0.2200e4 / 0.27e2 * t100 * t153
  t177 = t57 * t176
  t178 = t55 * t177
  t181 = jnp.pi ** (0.1e1 / 0.3e1)
  t182 = t181 ** 2
  t183 = f.my_piecewise3(t44, 0, 0)
  t184 = t35 * r0
  t186 = 0.1e1 / t15 / t184
  t189 = t26 * t186
  t192 = t26 * t112
  t196 = f.my_piecewise3(t43, t183, 0.20e2 / 0.27e2 * t27 * t186 - 0.80e2 / 0.27e2 * t30 * t189 + 0.22e2 / 0.27e2 * t34 * t192)
  t197 = t182 * t196
  t198 = t46 ** 2
  t199 = 0.1e1 / t198
  t201 = jnp.exp(-0.2e1 / 0.3e1 * t47)
  t202 = 0.1e1 / t201
  t203 = t199 * t202
  t204 = t197 * t203
  t205 = t47 ** 2
  t207 = t205 - 0.2e1 * t47 + 0.3e1
  t208 = 0.1e1 / t207
  t209 = t47 - 0.2e1
  t210 = t209 ** 2
  t211 = t208 * t210
  t212 = t211 * t53
  t221 = f.my_piecewise3(t43, t183, -0.5e1 / 0.18e2 * t27 * t37 + 0.10e2 / 0.9e1 * t30 * t38 - 0.2e1 / 0.9e1 * t34 * t189)
  t222 = t221 ** 2
  t223 = t182 * t222
  t224 = t198 * t46
  t225 = 0.1e1 / t224
  t226 = t225 * t202
  t227 = t223 * t226
  t230 = t181 * jnp.pi
  t231 = t230 * t222
  t232 = t198 ** 2
  t233 = 0.1e1 / t232
  t234 = t201 ** 2
  t235 = 0.1e1 / t234
  t236 = t233 * t235
  t237 = t231 * t236
  t238 = t207 ** 2
  t239 = 0.1e1 / t238
  t240 = t210 ** 2
  t241 = t239 * t240
  t242 = t241 * t53
  t245 = t182 * t221
  t246 = t245 * t203
  t247 = t239 * t210
  t248 = t47 * t182
  t250 = t203 * t211
  t252 = t245 * t199
  t253 = t202 * t208
  t254 = t253 * t210
  t257 = 0.2e1 * t248 * t221 * t250 - 0.2e1 * t252 * t254
  t258 = t53 * t257
  t259 = t247 * t258
  t261 = t210 * t209
  t262 = t239 * t261
  t263 = t262 * t53
  t266 = t231 * t233
  t267 = t235 * t239
  t268 = t240 * t50
  t269 = t267 * t268
  t272 = t197 * t199
  t273 = t210 * t50
  t274 = t253 * t273
  t277 = t223 * t225
  t279 = t50 * t257
  t280 = t247 * t279
  t283 = t261 * t50
  t284 = t267 * t283
  t286 = t204 * t212 - 0.2e1 * t227 * t212 - t237 * t242 / 0.3e1 - t246 * t259 + 0.2e1 * t237 * t263 + 0.2e1 / 0.3e1 * t266 * t269 - t272 * t274 / 0.2e1 + t277 * t274 + t246 * t280 / 0.2e1 - t266 * t284
  t287 = t49 * t286
  t288 = t287 * t104
  t294 = t246 * t212 - t252 * t274 / 0.2e1
  t295 = t49 * t294
  t299 = t110 * r0
  t301 = 0.1e1 / t14 / t299
  t305 = t118 * t301
  t308 = t58 * t186
  t327 = -0.40e2 / 0.9e1 * t58 * t186 * t68 + 0.100e3 / 0.9e1 * t118 * t301 * t74 - 0.500e3 / 0.9e1 * t116 * t305 - 0.40e2 / 0.9e1 * t75 * t308 - 0.200e3 * t156 * t305 + 0.80e2 / 0.3e1 * t82 * t308 - 0.200e3 / 0.9e1 * t161 * t305 + 0.80e2 / 0.3e1 * t88 * t308 + 0.2500e4 / 0.9e1 * t166 * t305 - 0.200e3 / 0.9e1 * t94 * t308 + 0.500e3 / 0.3e1 * t171 * t305 - 0.200e3 / 0.9e1 * t100 * t308
  t328 = t57 * t327
  t329 = t295 * t328
  t333 = t13 / t15
  t334 = t333 * t23
  t335 = t295 * t104
  t338 = t55 * t328
  t341 = t108 * t21
  t342 = t22 * t49
  t344 = 0.1e1 / t205 / t47
  t345 = t54 * t344
  t346 = t342 * t345
  t347 = t341 * t346
  t354 = 0.1e1 + params.at * (t72 * t68 - 0.2e1 * t85 * t81 + t97 * t93)
  t355 = t354 * t230
  t356 = t222 * t221
  t357 = t355 * t356
  t359 = 0.1e1 / t232 / t46
  t360 = t359 * t235
  t361 = t360 * t241
  t362 = t357 * t361
  t365 = 0.1e1 / t205
  t366 = t54 * t365
  t367 = t342 * t366
  t368 = t341 * t367
  t369 = t360 * t262
  t370 = t357 * t369
  t373 = t22 * t230
  t374 = t356 * t359
  t375 = t373 * t374
  t376 = t341 * t375
  t377 = t267 * t261
  t378 = t56 * t354
  t379 = t55 * t378
  t380 = t377 * t379
  t382 = t294 * t365
  t383 = t342 * t382
  t384 = t341 * t383
  t385 = t354 * t182
  t387 = t385 * t196 * t250
  t395 = 0.1e1 / t15 / t299
  t396 = t26 * t395
  t400 = f.my_piecewise3(t43, t183, -0.220e3 / 0.81e2 * t27 * t112 + 0.880e3 / 0.81e2 * t30 * t192 - 0.308e3 / 0.81e2 * t34 * t396)
  t402 = t385 * t400 * t250
  t405 = t24 * t105 / 0.6e1 - t109 * t178 / 0.4e1 - 0.3e1 / 0.4e1 * t109 * t288 - 0.3e1 / 0.4e1 * t109 * t329 - t334 * t335 / 0.2e1 - t334 * t338 / 0.4e1 + 0.3e1 * t347 * t362 - 0.3e1 * t368 * t370 + t376 * t380 + 0.3e1 / 0.4e1 * t384 * t387 + t368 * t402 / 0.4e1
  t407 = t226 * t211
  t408 = t385 * t222 * t407
  t411 = t267 * t240
  t412 = t365 * t354
  t413 = t55 * t412
  t414 = t411 * t413
  t417 = t18 * t21
  t418 = t22 * t182
  t419 = t221 * t199
  t420 = t418 * t419
  t421 = t417 * t420
  t422 = t254 * t379
  t425 = t417 * t367
  t427 = t385 * t221 * t250
  t430 = t333 * t21
  t431 = t430 * t420
  t432 = t295 * t378
  t433 = t254 * t432
  t436 = t354 * t61
  t437 = t436 * t356
  t439 = 0.1e1 / t232 / t198
  t441 = 0.1e1 / t234 / t201
  t442 = t439 * t441
  t444 = 0.1e1 / t238 / t207
  t445 = t444 * t240
  t446 = t442 * t445
  t447 = t437 * t446
  t450 = t22 * t61
  t451 = t356 * t439
  t452 = t450 * t451
  t453 = t341 * t452
  t454 = t441 * t444
  t455 = t454 * t240
  t456 = t455 * t379
  t459 = t240 * t209
  t460 = t454 * t459
  t461 = t460 * t413
  t464 = t240 * t210
  t465 = t454 * t464
  t466 = t344 * t354
  t467 = t55 * t466
  t468 = t465 * t467
  t471 = t205 ** 2
  t472 = 0.1e1 / t471
  t474 = t342 * t54 * t472
  t475 = t341 * t474
  t476 = t444 * t464
  t477 = t442 * t476
  t478 = t437 * t477
  t481 = t444 * t459
  t482 = t442 * t481
  t483 = t437 * t482
  t486 = t430 * t367
  t487 = t355 * t222
  t488 = t236 * t262
  t489 = t487 * t488
  t492 = -0.3e1 / 0.2e1 * t384 * t408 - 0.2e1 * t376 * t414 + t421 * t422 / 0.18e2 - t425 * t427 / 0.6e1 - t431 * t433 / 0.6e1 + 0.3e1 / 0.2e1 * t368 * t447 - t453 * t456 / 0.2e1 + 0.7e1 / 0.3e1 * t453 * t461 - 0.3e1 / 0.2e1 * t453 * t468 + 0.3e1 / 0.2e1 * t475 * t478 - 0.3e1 * t347 * t483 + t486 * t489 / 0.2e1
  t494 = t465 * t379
  t497 = t430 * t383
  t500 = t365 * params.at
  t501 = t55 * t500
  t502 = t109 * t501
  t503 = t103 * t182
  t504 = t503 * t419
  t505 = t202 * t239
  t507 = t505 * t210 * t257
  t508 = t504 * t507
  t511 = t109 * t246
  t512 = t247 * t55
  t513 = t103 * t257
  t514 = t57 * t513
  t515 = t512 * t514
  t518 = params.at * t103
  t519 = t518 * t231
  t520 = t236 * t241
  t521 = t519 * t520
  t524 = t519 * t488
  t527 = t385 * t419
  t536 = t47 * t230
  t537 = t536 * t222
  t540 = t248 * t419
  t553 = 0.2e1 / 0.3e1 * t266 * t411 + 0.2e1 * t248 * t196 * t250 - 0.4e1 * t248 * t222 * t407 + 0.4e1 / 0.3e1 * t537 * t520 - 0.2e1 * t540 * t507 + 0.4e1 * t537 * t488 - 0.2e1 * t272 * t254 + 0.4e1 * t277 * t254 + 0.2e1 * t252 * t507 - 0.4e1 * t266 * t377
  t555 = t505 * t210 * t553
  t556 = t527 * t555
  t559 = t222 * t233
  t560 = t373 * t559
  t561 = t341 * t560
  t562 = t235 * t444
  t563 = t240 * t49
  t564 = t562 * t563
  t565 = t354 * t257
  t566 = t366 * t565
  t567 = t564 * t566
  t569 = t196 * t199
  t570 = t418 * t569
  t571 = t341 * t570
  t572 = t210 * t49
  t573 = t253 * t572
  t574 = t54 * t56
  t575 = t574 * t518
  t576 = t573 * t575
  t579 = t341 * t420
  t580 = t294 * t56
  t581 = t580 * t518
  t582 = t573 * t581
  t585 = params.at * t327
  t586 = t574 * t585
  t587 = t573 * t586
  t590 = -0.5e1 / 0.36e2 * t453 * t494 + t497 * t427 / 0.2e1 - 0.3e1 / 0.4e1 * t502 * t508 + t511 * t515 / 0.4e1 - 0.3e1 / 0.2e1 * t347 * t521 + 0.3e1 / 0.2e1 * t368 * t524 - t368 * t556 / 0.4e1 - t561 * t567 - t571 * t576 / 0.4e1 - t579 * t582 / 0.2e1 - t579 * t587 / 0.4e1
  t591 = t267 * t563
  t592 = t591 * t575
  t595 = t505 * t572
  t596 = t574 * t565
  t597 = t595 * t596
  t600 = t202 * t444
  t601 = t600 * t572
  t602 = t257 ** 2
  t603 = t354 * t602
  t604 = t574 * t603
  t605 = t601 * t604
  t609 = t518 * t245 * t250
  t612 = t527 * t507
  t616 = t600 * t210 * t602
  t617 = t527 * t616
  t622 = t222 * t225
  t623 = t418 * t622
  t624 = t341 * t623
  t627 = t196 * t233
  t628 = t373 * t627
  t629 = t341 * t628
  t630 = t354 * t221
  t632 = t591 * t574 * t630
  t635 = t355 * t559
  t636 = t240 * t257
  t637 = t562 * t636
  t638 = t635 * t637
  t641 = t221 * t233
  t642 = t355 * t641
  t643 = t240 * t196
  t644 = t267 * t643
  t645 = t642 * t644
  t648 = t373 * t641
  t649 = t341 * t648
  t650 = t261 * t49
  t651 = t267 * t650
  t652 = t354 * t196
  t653 = t574 * t652
  t654 = t651 * t653
  t657 = -t561 * t592 / 0.4e1 + t431 * t597 / 0.12e2 - t579 * t605 / 0.6e1 + t486 * t609 / 0.2e1 - t486 * t612 / 0.4e1 + t368 * t617 / 0.2e1 - t431 * t576 / 0.6e1 + t624 * t576 / 0.2e1 - t629 * t632 / 0.4e1 + 0.3e1 / 0.2e1 * t347 * t638 - 0.3e1 / 0.2e1 * t347 * t645 - t649 * t654 / 0.2e1
  t660 = t221 * t225
  t661 = t418 * t660
  t662 = t341 * t661
  t663 = t573 * t653
  t670 = t580 * t565
  t671 = t595 * t670
  t674 = t354 * t553
  t675 = t574 * t674
  t676 = t595 * t675
  t679 = t564 * t596
  t685 = t585 * t245 * t250
  t689 = t518 * t197 * t250
  t692 = t385 * t660
  t694 = t253 * t210 * t196
  t695 = t692 * t694
  t698 = t385 * t622
  t699 = t698 * t507
  t701 = t662 * t663 / 0.2e1 - t624 * t597 / 0.3e1 + t571 * t597 / 0.6e1 + t579 * t671 / 0.4e1 + t579 * t676 / 0.12e2 + t561 * t679 / 0.4e1 + 0.3e1 / 0.2e1 * t384 * t609 + 0.3e1 / 0.4e1 * t368 * t685 + 0.3e1 / 0.4e1 * t368 * t689 - 0.3e1 / 0.2e1 * t368 * t695 + t368 * t699
  t703 = t562 * t261 * t257
  t704 = t635 * t703
  t708 = t518 * t223 * t407
  t713 = t385 * t569
  t714 = t713 * t507
  t718 = t267 * t261 * t196
  t719 = t642 * t718
  t722 = t366 * t652
  t723 = t591 * t722
  t725 = t562 * t650
  t726 = t725 * t596
  t729 = t651 * t575
  t732 = t366 * t518
  t733 = t591 * t732
  t735 = t287 * t378
  t736 = t254 * t735
  t740 = t342 * t286 * t365
  t741 = t341 * t740
  t746 = -0.3e1 / 0.2e1 * t368 * t704 - 0.3e1 / 0.2e1 * t368 * t708 - 0.3e1 / 0.4e1 * t384 * t612 - t368 * t714 / 0.2e1 + 0.3e1 / 0.2e1 * t368 * t719 + t649 * t723 + t561 * t726 / 0.2e1 - t561 * t729 / 0.2e1 + t561 * t733 - t579 * t736 / 0.4e1 + 0.3e1 / 0.4e1 * t741 * t427 + t624 * t433 / 0.2e1
  t748 = t411 * t379
  t751 = t377 * t432
  t754 = t460 * t379
  t757 = t295 * t412
  t758 = t411 * t757
  t760 = t465 * t413
  t764 = t342 * t294 * t344
  t765 = t341 * t764
  t766 = t487 * t520
  t771 = t430 * t570
  t774 = t430 * t560
  t779 = t400 * t199
  t780 = t418 * t779
  t781 = t341 * t780
  t786 = t376 * t748 / 0.2e1 - t561 * t751 / 0.2e1 - 0.11e2 / 0.18e2 * t453 * t754 + t561 * t758 + 0.23e2 / 0.36e2 * t453 * t760 - 0.3e1 / 0.2e1 * t765 * t766 + 0.3e1 / 0.2e1 * t384 * t489 - t771 * t422 / 0.12e2 - t774 * t748 / 0.12e2 + t486 * t387 / 0.4e1 - t781 * t422 / 0.12e2 - t571 * t433 / 0.4e1
  t787 = t411 * t432
  t790 = t430 * t346
  t797 = t356 * t233
  t798 = t418 * t797
  t799 = t341 * t798
  t802 = t430 * t623
  t807 = t13 * t37
  t808 = t807 * t23
  t811 = t444 * t210
  t812 = t53 * t602
  t813 = t811 * t812
  t816 = t444 * t261
  t817 = t816 * t258
  t820 = t445 * t258
  t822 = t53 * t553
  t823 = t247 * t822
  t825 = t197 * t226
  t826 = t53 * t221
  t827 = t211 * t826
  t832 = t230 * t196
  t833 = t832 * t236
  t834 = t241 * t826
  t838 = t262 * t826
  t841 = t230 * t356
  t842 = t841 * t359
  t845 = t61 * t356
  t846 = t845 * t439
  t847 = t454 * t268
  t852 = t464 * t50
  t853 = t454 * t852
  t856 = t459 * t50
  t857 = t454 * t856
  t860 = t182 * t400
  t861 = t860 * t199
  t864 = t182 * t356
  t865 = t864 * t233
  t868 = 0.2e1 * t246 * t813 - 0.6e1 * t237 * t817 + t237 * t820 - t246 * t823 - 0.6e1 * t825 * t827 - 0.2e1 * t204 * t259 - t833 * t834 + 0.4e1 * t227 * t259 + 0.6e1 * t833 * t838 + 0.6e1 * t842 * t284 - 0.3e1 * t846 * t847 - 0.4e1 * t842 * t269 + t846 * t853 / 0.18e2 + 0.10e2 / 0.3e1 * t846 * t857 - t861 * t274 / 0.2e1 - 0.3e1 * t865 * t274
  t869 = t845 * t442
  t870 = t481 * t53
  t873 = t445 * t53
  t876 = t816 * t279
  t879 = t50 * t602
  t880 = t811 * t879
  t882 = t233 * t202
  t883 = t864 * t882
  t888 = t50 * t553
  t889 = t247 * t888
  t892 = t445 * t279
  t895 = t50 * t221
  t896 = t211 * t895
  t900 = t860 * t203
  t902 = t241 * t895
  t905 = t841 * t360
  t908 = t476 * t53
  t911 = t262 * t895
  t916 = -0.2e1 / 0.3e1 * t869 * t870 + 0.6e1 * t869 * t873 + 0.3e1 * t237 * t876 - t246 * t880 + 0.6e1 * t883 * t212 - 0.2e1 * t227 * t280 + t246 * t889 / 0.2e1 - 0.2e1 * t237 * t892 + 0.3e1 * t825 * t896 + t204 * t280 + t900 * t212 + 0.2e1 * t833 * t902 + 0.2e1 * t905 * t242 - t869 * t908 / 0.9e1 - 0.3e1 * t833 * t911 - 0.12e2 * t905 * t263
  t917 = t868 + t916
  t918 = t49 * t917
  t919 = t918 * t378
  t925 = t882 * t211
  t926 = t385 * t356 * t925
  t931 = -t561 * t787 / 0.4e1 - t790 * t766 / 0.2e1 - t774 * t380 / 0.6e1 + t774 * t414 / 0.3e1 - t799 * t422 / 0.2e1 + t802 * t422 / 0.6e1 + t24 * t432 / 0.6e1 - 0.5e1 / 0.54e2 * t808 * t379 - t109 * t919 / 0.4e1 - t334 * t735 / 0.4e1 + 0.3e1 / 0.2e1 * t368 * t926 - t486 * t408 / 0.2e1
  t935 = f.my_piecewise3(t2, 0, t405 + t492 + t590 + t657 + t701 + t746 + t786 + t931)
  t944 = t417 * t560
  t949 = t430 * t452
  t962 = f.my_piecewise3(t43, t183, 0.3080e4 / 0.243e3 * t27 * t395 - 0.12320e5 / 0.243e3 * t30 * t396 + 0.5236e4 / 0.243e3 * t34 * t26 / t15 / t119)
  t986 = t196 ** 2
  t996 = t222 ** 2
  t997 = t436 * t996
  t999 = 0.1e1 / t232 / t224
  t1000 = t999 * t441
  t1005 = 0.2e1 * t486 * t926 + 0.2e1 / 0.3e1 * t417 * t346 * t766 + 0.4e1 * t790 * t362 + 0.2e1 / 0.9e1 * t944 * t380 + 0.2e1 * t486 * t447 - 0.5e1 / 0.27e2 * t949 * t494 - t341 * t418 * t962 * t199 * t422 / 0.12e2 - t781 * t433 / 0.3e1 - 0.22e2 / 0.27e2 * t949 * t754 + 0.4e1 / 0.3e1 * t774 * t758 + 0.23e2 / 0.27e2 * t949 * t760 - 0.2e1 * t799 * t433 + 0.2e1 * t497 * t489 - 0.2e1 * t430 * t764 * t766 + t486 * t402 / 0.3e1 + t497 * t387 + t341 * t418 * t986 * t225 * t422 / 0.2e1 - 0.2e1 / 0.3e1 * t425 * t489 - 0.4e1 * t486 * t370 - 0.18e2 * t475 * t997 * t1000 * t476
  t1012 = t182 * t61
  t1014 = t232 ** 2
  t1015 = 0.1e1 / t1014
  t1018 = t341 * t22 * t1012 * t996 * t1015
  t1019 = t234 ** 2
  t1020 = 0.1e1 / t1019
  t1021 = t238 ** 2
  t1022 = 0.1e1 / t1021
  t1023 = t1020 * t1022
  t1024 = t240 * t261
  t1025 = t1023 * t1024
  t1036 = t341 * t450 * t996 * t999
  t1054 = t1023 * t464
  t1071 = t240 ** 2
  t1072 = t1023 * t1071
  t1083 = -0.4e1 * t790 * t483 + 0.36e2 * t347 * t997 * t1000 * t481 - 0.61e2 / 0.27e2 * t1018 * t1025 * t379 + 0.23e2 / 0.9e1 * t453 * t465 * t757 - 0.2e1 * t949 * t468 + 0.18e2 * t1036 * t468 + 0.2e1 * t430 * t474 * t478 + 0.2e1 * t376 * t787 - t561 * t411 * t735 / 0.2e1 + 0.28e2 / 0.9e1 * t949 * t461 - 0.28e2 * t1036 * t461 - 0.2e1 * t453 * t455 * t432 - 0.38e2 / 0.9e1 * t1018 * t1054 * t379 - 0.2e1 / 0.9e1 * t417 * t623 * t422 + 0.28e2 / 0.3e1 * t453 * t460 * t757 + 0.89e2 / 0.9e1 * t1018 * t1025 * t413 - 0.6e1 * t453 * t465 * t295 * t466 - 0.43e2 / 0.9e1 * t1018 * t1072 * t467 + 0.6e1 * t341 * t342 * t294 * t472 * t478 - 0.12e2 * t765 * t483
  t1093 = t430 * t375
  t1104 = t807 * t21
  t1136 = -0.2e1 / 0.3e1 * t430 * t798 * t422 + 0.2e1 * t341 * t418 * t996 * t359 * t422 + 0.4e1 / 0.3e1 * t1093 * t380 - 0.4e1 / 0.9e1 * t944 * t414 - 0.8e1 / 0.3e1 * t1093 * t414 - t431 * t736 / 0.3e1 + t430 * t740 * t427 - 0.10e2 / 0.81e2 * t1104 * t420 * t422 + 0.10e2 / 0.27e2 * t1104 * t367 * t427 + 0.2e1 / 0.9e1 * t421 * t433 - t771 * t433 / 0.3e1 + 0.44e2 / 0.27e2 * t1018 * t1072 * t413 - 0.18e2 * t368 * t997 * t1000 * t445 - 0.2e1 / 0.3e1 * t949 * t456 + 0.6e1 * t1036 * t456 + t624 * t736 + 0.5e1 / 0.3e1 * t1036 * t494 - 0.22e2 / 0.9e1 * t453 * t460 * t432 - 0.2e1 * t497 * t408 + 0.12e2 * t765 * t362
  t1139 = t341 * t373 * t996 * t439
  t1159 = t222 * t359
  t1161 = t341 * t373 * t1159
  t1170 = t354 * t222
  t1171 = t574 * t1170
  t1187 = t580 * t652
  t1191 = t354 * t400
  t1192 = t574 * t1191
  t1200 = -0.2e1 * t790 * t645 + 0.3e1 * t341 * t373 * t196 * t359 * t591 * t1171 - 0.3e1 / 0.2e1 * t741 * t612 - 0.2e1 * t384 * t714 - t384 * t556 - 0.3e1 / 0.4e1 * t368 * t385 * t779 * t507 - 0.3e1 / 0.4e1 * t368 * t713 * t555 + 0.2e1 * t662 * t573 * t1187 + 0.2e1 / 0.3e1 * t662 * t573 * t1192 - 0.4e1 / 0.3e1 * t624 * t671 - t624 * t676 / 0.2e1
  t1208 = t235 * t1022
  t1218 = t47 * t61 * t356
  t1223 = t536 * t356
  t1237 = t230 * t221
  t1250 = t267 * t261 * t221
  t1255 = t253 * t210 * t221
  t1262 = 0.12e2 * t1218 * t446 + 0.12e2 * t266 * t703 - 0.24e2 * t1223 * t369 + 0.32e2 / 0.3e1 * t1218 * t482 - 0.4e1 * t252 * t616 + 0.2e1 * t252 * t555 + 0.12e2 * t248 * t356 * t925 + 0.16e2 / 0.9e1 * t1218 * t477 + 0.2e1 * t1237 * t233 * t644 - 0.2e1 * t266 * t637 + 0.2e1 * t248 * t400 * t250 - 0.8e1 * t1223 * t361 - 0.12e2 * t832 * t233 * t1250 + 0.12e2 * t197 * t225 * t1255 + 0.4e1 * t272 * t507 - 0.8e1 * t277 * t507
  t1265 = t196 * t225
  t1272 = t536 * t627
  t1293 = t536 * t559
  t1303 = -0.2e1 * t540 * t555 - 0.12e2 * t248 * t1265 * t1255 - 0.4e1 * t248 * t569 * t507 + 0.4e1 * t1272 * t267 * t240 * t221 - 0.4e1 * t842 * t411 - 0.12e2 * t846 * t455 + 0.4e1 / 0.3e1 * t846 * t460 + 0.24e2 * t842 * t377 - 0.12e2 * t865 * t254 + 0.20e2 / 0.9e1 * t846 * t465 - 0.2e1 * t861 * t254 + 0.4e1 * t540 * t616 - 0.12e2 * t1293 * t703 + 0.12e2 * t1272 * t1250 + 0.8e1 * t248 * t622 * t507 - 0.4e1 * t1293 * t637
  t1304 = t1262 + t1303
  t1313 = t518 * t841
  t1342 = t430 * t648
  t1349 = -t486 * t556 / 0.3e1 - 0.14e2 / 0.3e1 * t376 * t726 - 0.11e2 / 0.6e1 * t561 * t1208 * t650 * t604 - 0.2e1 / 0.3e1 * t774 * t729 + t561 * t564 * t670 + t579 * t595 * t574 * t354 * t1304 / 0.12e2 + t561 * t564 * t675 / 0.3e1 - 0.12e2 * t368 * t1313 * t369 + 0.2e1 / 0.3e1 * t774 * t726 + 0.11e2 / 0.2e1 * t368 * t635 * t1208 * t261 * t602 - 0.2e1 * t790 * t521 + 0.12e2 * t347 * t1313 * t361 - 0.9e1 / 0.2e1 * t368 * t385 * t797 * t507 - 0.3e1 * t368 * t698 * t616 - 0.2e1 * t486 * t704 + 0.4e1 / 0.3e1 * t486 * t699 - t771 * t576 / 0.3e1 - 0.2e1 / 0.3e1 * t1342 * t654 + 0.6e1 * t1161 * t654 + 0.4e1 / 0.3e1 * t1342 * t723
  t1359 = t286 * t56
  t1366 = t436 * t451
  t1367 = t441 * t1022
  t1377 = t518 * t845
  t1385 = t222 * t439
  t1387 = t341 * t450 * t1385
  t1388 = t459 * t49
  t1389 = t454 * t1388
  t1408 = params.at * t176
  t1423 = t436 * t1385
  t1429 = -0.12e2 * t347 * t1377 * t482 + 0.14e2 * t1387 * t1389 * t722 + 0.4e1 * t649 * t591 * t382 * t652 + 0.4e1 / 0.3e1 * t649 * t591 * t366 * t1191 - 0.6e1 * t384 * t695 - 0.2e1 * t368 * t692 * t253 * t210 * t400 + t368 * t1408 * t245 * t250 + 0.3e1 / 0.2e1 * t368 * t585 * t197 * t250 + t368 * t518 * t860 * t250 + t579 * t595 * t580 * t674 / 0.3e1 + 0.9e1 * t475 * t1423 * t454 * t464 * t196
  t1432 = t454 * t563
  t1443 = t341 * t450 * t196 * t439
  t1447 = t464 * t49
  t1448 = t454 * t1447
  t1468 = t355 * t374
  t1478 = t354 * t1012 * t996
  t1479 = t1015 * t1020
  t1480 = t1022 * t1024
  t1485 = t1022 * t464
  t1490 = t1022 * t459
  t1511 = -0.3e1 * t1387 * t1432 * t653 - 0.9e1 * t475 * t1366 * t1367 * t464 * t257 - 0.11e2 / 0.3e1 * t1443 * t1389 * t1171 + 0.23e2 / 0.6e1 * t1443 * t1448 * t366 * t1170 - 0.18e2 * t347 * t1423 * t454 * t459 * t196 + 0.6e1 * t368 * t1377 * t446 + 0.3e1 * t453 * t1367 * t563 * t596 - 0.2e1 * t453 * t1432 * t575 - 0.14e2 * t347 * t1468 * t637 + 0.14e2 * t368 * t1468 * t703 - 0.10e2 / 0.27e2 * t808 * t432 + 0.18e2 * t475 * t1478 * t1479 * t1480 - 0.18e2 * t347 * t1478 * t1479 * t1485 + 0.6e1 * t368 * t1478 * t1479 * t1490 - 0.2e1 * t1018 * t1023 * t459 * t379 - 0.62e2 / 0.3e1 * t1018 * t1025 * t467 + t944 * t748 / 0.9e1 - t425 * t387 / 0.3e1 - 0.2e1 / 0.3e1 * t417 * t383 * t427 - 0.8e1 * t376 * t758
  t1524 = t359 * t202
  t1545 = t355 * t996
  t1546 = t439 * t235
  t1569 = t1022 * t1071
  t1585 = -0.18e2 * t347 * t1545 * t1546 * t241 + 0.18e2 * t368 * t1545 * t1546 * t262 - 0.6e1 * t1139 * t380 + 0.12e2 * t1139 * t414 + 0.8e1 * t1018 * t1072 * t55 * t472 * t354 - 0.6e1 * t341 * t342 * t54 / t471 / t47 * t1478 * t1479 * t1569 + t384 * t402 + t368 * t385 * t962 * t250 / 0.4e1 - 0.3e1 * t741 * t408 - 0.12e2 * t384 * t370 + 0.4e1 * t376 * t751
  t1596 = t341 * t373 * t986 * t233
  t1599 = t355 * t986
  t1633 = t109 * t413
  t1634 = t553 * t257
  t1639 = t109 * t237
  t1640 = t445 * t55
  t1645 = t1237 * t236
  t1646 = t109 * t1645
  t1647 = t816 * t55
  t1648 = t257 * t196
  t1649 = t378 * t1648
  t1661 = t109 * t55 * t344 * params.at
  t1662 = t103 * t230
  t1663 = t1662 * t559
  t1667 = 0.22e2 / 0.3e1 * t1036 * t754 + 0.3e1 / 0.2e1 * t741 * t387 - t1596 * t748 / 0.4e1 - 0.3e1 / 0.2e1 * t347 * t1599 * t520 - t1596 * t380 / 0.2e1 + 0.3e1 / 0.2e1 * t368 * t1599 * t488 + t1596 * t414 - t579 * t254 * t919 / 0.3e1 + t341 * t342 * t917 * t365 * t427 + 0.6e1 * t384 * t447 + 0.47e2 / 0.3e1 * t1018 * t1054 * t413 - 0.3e1 / 0.2e1 * t368 * t385 * t986 * t407 - 0.6e1 * t502 * t503 * t1265 * t1255 - 0.2e1 * t502 * t503 * t569 * t507 + 0.3e1 / 0.2e1 * t1633 * t246 * t811 * t1634 - 0.4e1 * t1639 * t1640 * t500 * t513 + 0.7e1 / 0.3e1 * t1646 * t1647 * t1649 + 0.2e1 * t1639 * t1647 * t514 + 0.2e1 * t502 * t504 * t616 + 0.6e1 * t1661 * t1663 * t637
  t1668 = t1662 * t641
  t1684 = t245 * t226
  t1695 = t811 * t55
  t1712 = t103 * t196
  t1713 = t57 * t1712
  t1717 = t241 * t55
  t1742 = t355 * t1159
  t1746 = 0.6e1 * t502 * t1668 * t718 - 0.7e1 * t1633 * t1645 * t816 * t1648 + t24 * t735 / 0.3e1 - 0.6e1 * t502 * t1663 * t703 - 0.6e1 * t1661 * t1668 * t644 + 0.9e1 / 0.2e1 * t1633 * t1684 * t247 * t1648 + 0.4e1 * t502 * t503 * t622 * t507 - t502 * t504 * t555 - 0.2e1 / 0.3e1 * t511 * t1695 * t57 * t103 * t602 - t334 * t501 * t508 + t334 * t246 * t515 / 0.3e1 + 0.7e1 * t109 * t467 * t1645 * t445 * t1648 - 0.2e1 * t1646 * t262 * t55 * t1713 + 0.4e1 * t1646 * t1717 * t500 * t1712 + t511 * t512 * t57 * t327 * t257 / 0.2e1 - 0.3e1 / 0.2e1 * t502 * t327 * t182 * t419 * t507 + 0.20e2 / 0.81e2 * t13 * t186 * t23 * t379 + t579 * t595 * t1359 * t565 / 0.2e1 + 0.2e1 * t486 * t719 - 0.18e2 * t368 * t1742 * t718
  t1764 = t1367 * t1447
  t1801 = 0.2e1 / 0.3e1 * t802 * t576 - 0.2e1 * t799 * t576 - t430 * t628 * t632 / 0.3e1 + 0.2e1 * t790 * t638 - 0.11e2 / 0.2e1 * t347 * t635 * t1208 * t240 * t602 + 0.4e1 * t376 * t729 + 0.9e1 * t453 * t1764 * t345 * t565 - t421 * t597 / 0.9e1 - 0.5e1 / 0.9e1 * t453 * t1448 * t575 - t561 * t591 * t581 - t579 * t573 * t574 * t1408 / 0.3e1 - t561 * t591 * t586 / 0.2e1 + 0.5e1 / 0.6e1 * t453 * t1764 * t596 + 0.3e1 * t741 * t609 + 0.3e1 * t384 * t685 + 0.3e1 * t384 * t689 + 0.2e1 / 0.3e1 * t571 * t671 + t571 * t676 / 0.4e1 - t109 * t918 * t104 - 0.3e1 / 0.2e1 * t109 * t287 * t328
  t1809 = 0.1e1 / t14 / t110 / t184
  t1810 = t118 * t1809
  t1813 = t58 * t395
  t1825 = t129 / t130 / r0
  t1828 = t117 ** 2
  t1832 = 0.1e1 / t15 / t130 / t35
  t1842 = t1828 * t1832 * t26
  t1850 = -0.272000e6 / 0.81e2 * t116 * t1810 - 0.6160e4 / 0.81e2 * t75 * t1813 - 0.108800e6 / 0.9e1 * t156 * t1810 + 0.12320e5 / 0.27e2 * t82 * t1813 + 0.54400e5 / 0.81e2 * t118 * t1809 * t74 + 0.272000e6 / 0.9e1 * t128 * t1825 - 0.100000e6 / 0.27e2 * t1828 * t26 * t1832 * t87 + 0.16000e5 / 0.9e1 * t1825 * t81 - 0.160000e6 / 0.3e1 * t138 * t1825 + 0.800000e6 / 0.9e1 * t85 * t142 * t1842 - 0.400000e6 / 0.3e1 * t143 * t1825 + 0.3500000e7 / 0.27e2 * t91 * t147 * t1842
  t1881 = -0.560000e6 / 0.9e1 * t148 * t1825 + 0.1400000e7 / 0.27e2 * t97 / t146 / t67 * t1842 - 0.6160e4 / 0.81e2 * t58 * t395 * t68 - 0.200000e6 / 0.9e1 * t72 * t93 * t1842 + 0.416000e6 / 0.9e1 * t135 * t1825 - 0.200000e6 / 0.27e2 * t79 * t99 * t1842 - 0.108800e6 / 0.81e2 * t161 * t1810 + 0.12320e5 / 0.27e2 * t88 * t1813 + 0.1360000e7 / 0.81e2 * t166 * t1810 - 0.30800e5 / 0.81e2 * t94 * t1813 + 0.272000e6 / 0.27e2 * t171 * t1810 - 0.30800e5 / 0.81e2 * t100 * t1813
  t1893 = t1022 * t210
  t1894 = t602 * t257
  t1899 = t182 * t996
  t1903 = t182 * t962
  t1907 = t230 * t400 * t236
  t1911 = t61 * t196 * t442
  t1912 = t50 * t222
  t1918 = t61 * t996
  t1919 = t1918 * t1000
  t1925 = t1022 * t240
  t1932 = t1012 * t996
  t1933 = t1932 * t1479
  t1942 = t860 * t226
  t1945 = t832 * t360
  t1955 = t1918 * t999
  t1958 = -0.3e1 * t204 * t880 + 0.22e2 / 0.3e1 * t237 * t1925 * t879 - t869 * t1485 * t279 / 0.3e1 + 0.8e1 / 0.3e1 * t1933 * t1485 * t53 - 0.4e1 * t1907 * t911 + 0.20e2 * t1911 * t481 * t1912 + 0.4e1 * t1942 * t896 - 0.24e2 * t1945 * t241 * t1912 - 0.8e1 / 0.3e1 * t237 * t445 * t888 - t1933 * t1569 * t53 / 0.9e1 - 0.40e2 * t1955 * t857
  t1960 = t1932 * t1015
  t1968 = t230 * t986
  t1969 = t1968 * t233
  t1984 = t1968 * t236
  t1987 = t182 * t986
  t1995 = 0.50e2 / 0.3e1 * t1960 * t1023 * t852 + 0.10e2 / 0.3e1 * t1960 * t1023 * t1024 * t50 + 0.2e1 * t1969 * t269 + 0.4e1 * t237 * t816 * t888 - 0.4e1 / 0.3e1 * t1933 * t1480 * t53 - 0.18e2 * t1911 * t445 * t1912 - 0.20e2 * t869 * t1490 * t279 + 0.6e1 * t1984 * t263 - 0.6e1 * t1987 * t226 * t212 - t1984 * t242 + 0.24e2 * t1933 * t1490 * t53
  t2001 = t1022 * t261
  t2005 = t230 * t996
  t2006 = t2005 * t1546
  t2021 = t2005 * t439
  t2026 = 0.4e1 * t869 * t1490 * t258 + 0.12e2 * t1899 * t359 * t274 + 0.18e2 * t869 * t1925 * t279 - 0.11e2 * t237 * t2001 * t879 + 0.8e1 * t1919 * t870 - 0.72e2 * t1919 * t873 + 0.36e2 * t1955 * t847 + 0.72e2 * t2006 * t263 - 0.36e2 * t2021 * t284 - 0.18e2 * t883 * t259 - 0.28e2 * t905 * t876
  t2052 = t61 * t222 * t442
  t2053 = t53 * t196
  t2057 = t279 * t196
  t2061 = t231 * t360
  t2067 = -0.12e2 * t1960 * t1023 * t856 - 0.3e1 * t1969 * t284 + 0.3e1 * t1987 * t225 * t274 + 0.24e2 * t2021 * t269 + 0.6e1 * t245 * t203 * t444 * t273 * t52 * t553 * t257 - 0.11e2 / 0.3e1 * t237 * t1925 * t812 + 0.6e1 * t227 * t823 - 0.4e1 * t2052 * t481 * t2053 - 0.9e1 * t1684 * t247 * t2057 + 0.12e2 * t2061 * t241 * t2053 - 0.28e2 / 0.3e1 * t905 * t820
  t2099 = -0.3e1 * t246 * t811 * t279 * t553 + 0.6e1 * t204 * t813 + 0.22e2 * t237 * t2001 * t812 + t246 * t247 * t50 * t1304 / 0.2e1 + 0.36e2 * t1945 * t262 * t1912 - 0.18e2 * t197 * t882 * t211 * t1912 + 0.9e1 * t883 * t280 - 0.12e2 * t2006 * t242 + 0.6e1 * t227 * t880 - 0.72e2 * t2061 * t262 * t2053 + 0.56e2 * t905 * t817
  t2132 = -0.8e1 * t1942 * t827 - 0.3e1 * t900 * t259 - 0.4e1 / 0.3e1 * t1907 * t834 - 0.2e1 / 0.3e1 * t2052 * t476 * t2053 + 0.2e1 / 0.3e1 * t869 * t1485 * t258 + 0.14e2 * t833 * t816 * t895 * t257 + 0.36e2 * t223 * t882 * t211 * t2053 + 0.8e1 * t1907 * t838 - 0.28e2 / 0.3e1 * t1645 * t445 * t2057 + 0.36e2 * t2052 * t445 * t2053 - 0.36e2 * t869 * t1925 * t258
  t2161 = t1237 * t236 * t444
  t2163 = t52 * t257 * t196
  t2172 = -0.8e1 * t237 * t816 * t822 - t1903 * t199 * t274 / 0.2e1 + 0.4e1 / 0.3e1 * t237 * t445 * t822 - 0.3e1 * t204 * t823 - t246 * t247 * t53 * t1304 - 0.12e2 * t227 * t813 - 0.6e1 * t246 * t1893 * t53 * t1894 + 0.18e2 * t197 * t226 * t239 * t273 * t52 * t221 * t257 - 0.28e2 * t2161 * t283 * t2163 + 0.14e2 / 0.3e1 * t2161 * t268 * t2163 - 0.2e1 / 0.3e1 * t1955 * t853
  t2206 = t1208 * t563
  t2225 = -0.3e1 * t368 * t585 * t223 * t407 + t486 * t689 + 0.2e1 * t497 * t609 - 0.6e1 * t384 * t708 + t486 * t685 + t774 * t679 / 0.3e1 - 0.11e2 / 0.12e2 * t561 * t2206 * t604 - 0.2e1 / 0.3e1 * t579 * t601 * t580 * t603 - t341 * t373 * t400 * t233 * t632 / 0.3e1 - t629 * t591 * t580 * t630 - 0.5e1 / 0.6e1 * t1443 * t1448 * t1171
  t2257 = t202 * t1022
  t2276 = t1367 * t1388
  t2286 = 0.2e1 * t561 * t591 * t366 * t585 + 0.2e1 * t561 * t725 * t670 - t368 * t527 * t505 * t210 * t1304 / 0.4e1 - 0.7e1 / 0.3e1 * t376 * t679 + t781 * t597 / 0.4e1 - 0.4e1 / 0.3e1 * t774 * t567 + 0.11e2 / 0.3e1 * t561 * t2206 * t366 * t603 - 0.2e1 / 0.3e1 * t425 * t609 + t425 * t612 / 0.3e1 - 0.2e1 / 0.9e1 * t431 * t605 + t579 * t2257 * t572 * t574 * t354 * t1894 / 0.2e1 + t624 * t587 + 0.2e1 * t376 * t592 + 0.28e2 / 0.3e1 * t376 * t567 - 0.6e1 * t384 * t704 - 0.2e1 * t368 * t635 * t562 * t261 * t553 - 0.14e2 * t453 * t2276 * t566 - 0.6e1 * t765 * t521 + 0.4e1 * t384 * t699 - t431 * t587 / 0.3e1
  t2317 = t585 * t231
  t2354 = -0.3e1 * t347 * t2317 * t520 - 0.6e1 * t453 * t1448 * t345 * t518 + 0.6e1 * t384 * t524 + 0.3e1 * t368 * t2317 * t488 + 0.28e2 / 0.3e1 * t453 * t1389 * t732 - 0.4e1 * t561 * t564 * t382 * t565 - 0.4e1 / 0.3e1 * t561 * t564 * t366 * t674 - 0.23e2 / 0.6e1 * t453 * t1764 * t566 + 0.9e1 * t368 * t1423 * t454 * t643 + 0.3e1 / 0.2e1 * t368 * t698 * t555 - 0.2e1 * t649 * t651 * t1187
  t2411 = -0.2e1 / 0.3e1 * t649 * t651 * t1192 + 0.6e1 * t384 * t719 + 0.2e1 * t368 * t642 * t267 * t261 * t400 + 0.2e1 * t624 * t582 + 0.2e1 / 0.3e1 * t486 * t617 - 0.9e1 * t1387 * t1448 * t345 * t652 + t1639 * t1640 * t514 - 0.3e1 * t109 * t295 * t500 * t508 + t511 * t512 * t57 * t103 * t553 / 0.3e1 - 0.3e1 / 0.2e1 * t368 * t527 * t2257 * t210 * t1894 + 0.2e1 / 0.9e1 * t421 * t576 + 0.2e1 * t486 * t524 + t431 * t676 / 0.9e1 - t571 * t605 / 0.2e1 + t431 * t671 / 0.3e1 - 0.4e1 / 0.9e1 * t802 * t597 + 0.3e1 / 0.2e1 * t799 * t597 + t624 * t605 + 0.2e1 / 0.9e1 * t771 * t597 + 0.2e1 / 0.3e1 * t430 * t661 * t663
  t2454 = t109 * t1684
  t2462 = t109 * t833
  t2479 = 0.6e1 * t765 * t638 + 0.2e1 * t347 * t635 * t562 * t240 * t553 + t511 * t247 * t295 * t514 - t511 * t1695 * t378 * t1634 / 0.2e1 + 0.2e1 / 0.3e1 * t109 * t204 * t515 - 0.3e1 / 0.2e1 * t2454 * t512 * t1649 - 0.14e2 / 0.3e1 * t1646 * t1640 * t412 * t1648 + 0.7e1 / 0.6e1 * t2462 * t1640 * t378 * t221 * t257 - t2462 * t1717 * t57 * t103 * t221 + 0.2e1 * t2454 * t211 * t55 * t1713 - 0.4e1 / 0.3e1 * t109 * t227 * t515
  t2485 = f.my_piecewise3(t2, 0, -t109 * t55 * t57 * (t1850 + t1881) / 0.4e1 - t109 * t49 * (-0.3e1 * t227 * t889 + 0.56e2 / 0.3e1 * t905 * t892 + 0.3e1 / 0.2e1 * t204 * t889 + 0.3e1 * t246 * t1893 * t50 * t1894 - 0.24e2 * t1899 * t1524 * t212 + t1903 * t203 * t212 + 0.8e1 / 0.3e1 * t1907 * t902 + t1911 * t476 * t1912 / 0.3e1 + 0.3e1 / 0.2e1 * t900 * t280 + 0.4e1 / 0.3e1 * t1919 * t908 + t1958 + t1995 + t2026 + t2067 + t2099 + t2132 + t2172) * t378 / 0.4e1 + 0.6e1 * t368 * t518 * t864 * t925 + 0.9e1 * t368 * t385 * t559 * t694 + 0.4e1 * t561 * t591 * t382 * t518 + t1801 - t579 * t573 * t1359 * t518 - t579 * t573 * t580 * t585 - 0.9e1 * t368 * t1366 * t1367 * t636 + 0.2e1 * t561 * t411 * t287 * t412 - 0.3e1 * t341 * t418 * t559 * t663 + 0.18e2 * t347 * t1366 * t1367 * t459 * t257 - 0.6e1 * t368 * t385 * t996 * t1524 * t211 - 0.3e1 * t341 * t342 * t286 * t344 * t766 - 0.2e1 * t347 * t642 * t267 * t240 * t400 + t1585 - t334 * t329 + t24 * t338 / 0.3e1 - 0.23e2 / 0.3e1 * t1036 * t760 + 0.4e1 / 0.3e1 * t774 * t733 - 0.8e1 * t376 * t733 - t781 * t576 / 0.3e1 - t571 * t582 - t571 * t587 / 0.2e1 - 0.3e1 * t1139 * t748 + 0.2e1 / 0.3e1 * t802 * t433 + 0.2e1 / 0.3e1 * t1093 * t748 + 0.6e1 * t384 * t926 - t571 * t736 / 0.2e1 - t774 * t787 / 0.3e1 - t774 * t592 / 0.3e1 + 0.2e1 * t384 * t617 - 0.2e1 / 0.3e1 * t486 * t714 - t334 * t288 - 0.10e2 / 0.27e2 * t808 * t105 + 0.2e1 / 0.3e1 * t24 * t335 - t334 * t178 / 0.3e1 + 0.3e1 * t741 * t489 - 0.2e1 * t486 * t708 - t497 * t612 - 0.2e1 * t486 * t695 - t334 * t919 / 0.3e1 - 0.12e2 * t1161 * t723 + 0.2e1 / 0.3e1 * t425 * t408 - 0.2e1 / 0.3e1 * t774 * t751 - 0.2e1 / 0.3e1 * t431 * t582 - 0.6e1 * t765 * t645 + t1746 + t1005 + t1511 + t2354 + t1429 - t109 * t295 * t177 + 0.6e1 * t475 * t1377 * t477 + t417 * t570 * t422 / 0.9e1 - 0.5e1 / 0.9e1 * t453 * t465 * t432 - 0.35e2 / 0.108e3 * t1018 * t1072 * t379 - t430 * t780 * t422 / 0.9e1 - t561 * t377 * t735 + t1136 + 0.3e1 / 0.2e1 * t368 * t713 * t616 + 0.23e2 / 0.9e1 * t453 * t1448 * t732 + 0.2e1 / 0.3e1 * t561 * t725 * t675 + 0.11e2 / 0.3e1 * t453 * t2276 * t596 - 0.2e1 * t561 * t651 * t581 - t561 * t651 * t586 - 0.22e2 / 0.9e1 * t453 * t1389 * t575 + 0.18e2 * t347 * t1742 * t644 + t2411 + t1200 + t2286 + t2225 + t1667 + t1083 + t2479 + t1349)
  v4rho4_0_ = 0.2e1 * r0 * t2485 + 0.8e1 * t935

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t6 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold - 0.1e1
  t10 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t11 = -t7
  t12 = r0 - r1
  t13 = t12 * t3
  t14 = f.my_piecewise5(t6, t7, t10, t11, t13)
  t15 = 0.1e1 + t14
  t16 = t15 <= f.p.zeta_threshold
  t17 = t15 ** (0.1e1 / 0.3e1)
  t18 = t2 ** 2
  t19 = 0.1e1 / t18
  t20 = t12 * t19
  t21 = t3 - t20
  t22 = f.my_piecewise5(t6, 0, t10, 0, t21)
  t25 = f.my_piecewise3(t16, 0, 0.4e1 / 0.3e1 * t17 * t22)
  t26 = t2 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t29 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t30 = 0.1e1 / t29
  t31 = 4 ** (0.1e1 / 0.3e1)
  t32 = t30 * t31
  t33 = t27 * t32
  t34 = r0 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t37 = 0.1e1 / t35 / r0
  t40 = params.gamma * tau0
  t43 = params.gamma * s0
  t44 = r0 ** 2
  t46 = 0.1e1 / t35 / t44
  t49 = l0 * t37 / 0.6e1 - 0.2e1 / 0.3e1 * t40 * t37 + t43 * t46 / 0.12e2
  t50 = abs(t49)
  t51 = t50 < 0.50e-12
  t52 = 0.0e0 < t49
  t53 = f.my_piecewise3(t52, 0.50e-12, -0.50e-12)
  t54 = f.my_piecewise3(t51, t53, t49)
  t55 = br89_x(t54)
  t57 = jnp.exp(t55 / 0.3e1)
  t58 = jnp.exp(-t55)
  t61 = t58 * (0.1e1 + t55 / 0.2e1)
  t62 = 0.1e1 - t61
  t63 = t57 * t62
  t64 = 0.1e1 / t55
  t65 = 6 ** (0.1e1 / 0.3e1)
  t66 = t65 ** 2
  t67 = jnp.pi ** 2
  t68 = t67 ** (0.1e1 / 0.3e1)
  t69 = t68 ** 2
  t71 = 0.3e1 / 0.10e2 * t66 * t69
  t72 = tau0 * t37
  t73 = t71 - t72
  t74 = t71 + t72
  t75 = 0.1e1 / t74
  t77 = t73 ** 2
  t78 = t77 * t73
  t79 = t74 ** 2
  t80 = t79 * t74
  t81 = 0.1e1 / t80
  t84 = t77 ** 2
  t85 = t84 * t73
  t86 = t79 ** 2
  t88 = 0.1e1 / t86 / t74
  t92 = 0.1e1 + params.at * (t73 * t75 - 0.2e1 * t78 * t81 + t85 * t88)
  t93 = t64 * t92
  t94 = t63 * t93
  t97 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t98 = t97 * f.p.zeta_threshold
  t100 = f.my_piecewise3(t16, t98, t17 * t15)
  t101 = t26 ** 2
  t102 = 0.1e1 / t101
  t103 = t100 * t102
  t104 = t103 * t32
  t106 = t104 * t94 / 0.12e2
  t107 = t100 * t26
  t108 = t107 * t30
  t109 = jnp.pi ** (0.1e1 / 0.3e1)
  t110 = t109 ** 2
  t111 = t31 * t110
  t112 = f.my_piecewise3(t52, 0, 0)
  t119 = 0.1e1 / t35 / t44 / r0
  t123 = f.my_piecewise3(t51, t112, -0.5e1 / 0.18e2 * l0 * t46 + 0.10e2 / 0.9e1 * t40 * t46 - 0.2e1 / 0.9e1 * t43 * t119)
  t124 = t54 ** 2
  t125 = 0.1e1 / t124
  t126 = t123 * t125
  t127 = t111 * t126
  t128 = t108 * t127
  t130 = jnp.exp(-0.2e1 / 0.3e1 * t55)
  t131 = 0.1e1 / t130
  t132 = t55 ** 2
  t134 = t132 - 0.2e1 * t55 + 0.3e1
  t135 = 0.1e1 / t134
  t136 = t131 * t135
  t137 = t55 - 0.2e1
  t138 = t137 ** 2
  t139 = t136 * t138
  t140 = t139 * t94
  t143 = t107 * t32
  t144 = t110 * t123
  t145 = t125 * t131
  t146 = t144 * t145
  t147 = t135 * t138
  t148 = t147 * t61
  t150 = t144 * t125
  t152 = t136 * t138 * t58
  t155 = t146 * t148 - t150 * t152 / 0.2e1
  t156 = t57 * t155
  t157 = t156 * t93
  t160 = t31 * t57
  t161 = 0.1e1 / t132
  t163 = t160 * t62 * t161
  t164 = t108 * t163
  t165 = t92 * t110
  t167 = t145 * t147
  t168 = t165 * t123 * t167
  t171 = t64 * params.at
  t172 = tau0 * t46
  t175 = 0.1e1 / t79
  t176 = t73 * t175
  t179 = t77 * t81
  t182 = 0.1e1 / t86
  t183 = t78 * t182
  t186 = t84 * t88
  t190 = 0.1e1 / t86 / t79
  t191 = t85 * t190
  t194 = 0.5e1 / 0.3e1 * t172 * t75 + 0.5e1 / 0.3e1 * t176 * t172 - 0.10e2 * t179 * t172 - 0.10e2 * t183 * t172 + 0.25e2 / 0.3e1 * t186 * t172 + 0.25e2 / 0.3e1 * t191 * t172
  t195 = t171 * t194
  t196 = t63 * t195
  t200 = f.my_piecewise3(t1, 0, -t33 * t94 / 0.4e1 - t106 - t128 * t140 / 0.12e2 - t143 * t157 / 0.4e1 + t164 * t168 / 0.4e1 - t143 * t196 / 0.4e1)
  t202 = r1 <= f.p.dens_threshold
  t203 = f.my_piecewise5(t10, t7, t6, t11, -t13)
  t204 = 0.1e1 + t203
  t205 = t204 <= f.p.zeta_threshold
  t206 = t204 ** (0.1e1 / 0.3e1)
  t208 = f.my_piecewise5(t10, 0, t6, 0, -t21)
  t211 = f.my_piecewise3(t205, 0, 0.4e1 / 0.3e1 * t206 * t208)
  t212 = t211 * t26
  t213 = t212 * t32
  t214 = r1 ** (0.1e1 / 0.3e1)
  t215 = t214 ** 2
  t217 = 0.1e1 / t215 / r1
  t220 = params.gamma * tau1
  t223 = params.gamma * s2
  t224 = r1 ** 2
  t226 = 0.1e1 / t215 / t224
  t229 = l1 * t217 / 0.6e1 - 0.2e1 / 0.3e1 * t220 * t217 + t223 * t226 / 0.12e2
  t230 = abs(t229)
  t231 = t230 < 0.50e-12
  t232 = 0.0e0 < t229
  t233 = f.my_piecewise3(t232, 0.50e-12, -0.50e-12)
  t234 = f.my_piecewise3(t231, t233, t229)
  t235 = br89_x(t234)
  t237 = jnp.exp(t235 / 0.3e1)
  t238 = jnp.exp(-t235)
  t241 = t238 * (0.1e1 + t235 / 0.2e1)
  t242 = 0.1e1 - t241
  t243 = t237 * t242
  t244 = 0.1e1 / t235
  t245 = tau1 * t217
  t246 = t71 - t245
  t247 = t71 + t245
  t248 = 0.1e1 / t247
  t250 = t246 ** 2
  t251 = t250 * t246
  t252 = t247 ** 2
  t253 = t252 * t247
  t254 = 0.1e1 / t253
  t257 = t250 ** 2
  t258 = t257 * t246
  t259 = t252 ** 2
  t261 = 0.1e1 / t259 / t247
  t265 = 0.1e1 + params.at * (t246 * t248 - 0.2e1 * t251 * t254 + t258 * t261)
  t266 = t244 * t265
  t267 = t243 * t266
  t271 = f.my_piecewise3(t205, t98, t206 * t204)
  t272 = t271 * t102
  t273 = t272 * t32
  t275 = t273 * t267 / 0.12e2
  t277 = f.my_piecewise3(t202, 0, -t213 * t267 / 0.4e1 - t275)
  t279 = t109 * jnp.pi
  t281 = t123 ** 2
  t282 = t92 * t279 * t281
  t283 = t124 ** 2
  t284 = 0.1e1 / t283
  t285 = t130 ** 2
  t286 = 0.1e1 / t285
  t287 = t284 * t286
  t288 = t134 ** 2
  t289 = 0.1e1 / t288
  t290 = t138 * t137
  t291 = t289 * t290
  t296 = t27 * t30
  t303 = t103 * t30
  t305 = t303 * t127 * t140
  t308 = t303 * t163 * t168
  t314 = t44 ** 2
  t320 = f.my_piecewise3(t51, t112, 0.20e2 / 0.27e2 * l0 * t119 - 0.80e2 / 0.27e2 * t40 * t119 + 0.22e2 / 0.27e2 * t43 / t35 / t314)
  t329 = t31 * t279
  t332 = t108 * t329 * t281 * t284
  t333 = t286 * t289
  t334 = t138 ** 2
  t335 = t333 * t334
  t350 = 0.1e1 / t124 / t54
  t351 = t350 * t131
  t370 = t164 * t282 * t287 * t291 / 0.2e1 - t296 * t127 * t140 / 0.6e1 + t296 * t163 * t168 / 0.2e1 - t305 / 0.18e2 + t308 / 0.6e1 - t108 * t111 * t320 * t125 * t140 / 0.12e2 - t128 * t139 * t157 / 0.6e1 - t332 * t335 * t94 / 0.12e2 + t108 * t160 * t155 * t161 * t168 / 0.2e1 + t164 * t165 * t320 * t167 / 0.4e1 - t164 * t165 * t281 * t351 * t147 / 0.2e1 + t108 * t111 * t281 * t350 * t140 / 0.6e1 - t332 * t333 * t290 * t94 / 0.6e1 + t332 * t335 * t63 * t161 * t92 / 0.3e1
  t376 = t289 * t334
  t381 = params.at * t194
  t386 = t131 * t289
  t387 = t138 * t57
  t389 = t62 * t64
  t395 = 0.2e1 * t55 * t110 * t123 * t167 - 0.2e1 * t150 * t139
  t412 = t110 * t320
  t415 = t110 * t281
  t419 = t279 * t281
  t420 = t419 * t287
  t424 = t289 * t138
  t431 = t419 * t284
  t453 = t17 ** 2
  t454 = 0.1e1 / t453
  t455 = t22 ** 2
  t460 = t12 / t18 / t2
  t462 = -0.2e1 * t19 + 0.2e1 * t460
  t463 = f.my_piecewise5(t6, 0, t10, 0, t462)
  t467 = f.my_piecewise3(t16, 0, 0.4e1 / 0.9e1 * t454 * t455 + 0.4e1 / 0.3e1 * t17 * t463)
  t476 = t25 * t102 * t32 * t94
  t479 = 0.1e1 / t101 / t2
  t483 = t100 * t479 * t32 * t94 / 0.18e2
  t484 = t104 * t157
  t488 = t104 * t196
  t493 = tau0 * t119
  t496 = tau0 ** 2
  t500 = t496 / t34 / t314 / r0
  t530 = -0.40e2 / 0.9e1 * t493 * t75 + 0.50e2 / 0.9e1 * t500 * t175 - 0.250e3 / 0.9e1 * t73 * t81 * t500 - 0.40e2 / 0.9e1 * t176 * t493 - 0.100e3 * t77 * t182 * t500 + 0.80e2 / 0.3e1 * t179 * t493 - 0.100e3 / 0.9e1 * t78 * t88 * t500 + 0.80e2 / 0.3e1 * t183 * t493 + 0.1250e4 / 0.9e1 * t84 * t190 * t500 - 0.200e3 / 0.9e1 * t186 * t493 + 0.250e3 / 0.3e1 * t85 / t86 / t80 * t500 - 0.200e3 / 0.9e1 * t191 * t493
  t535 = -t108 * t160 * t62 / t132 / t55 * t282 * t287 * t376 / 0.2e1 + t164 * t381 * t144 * t167 / 0.2e1 + t128 * t386 * t387 * t389 * t92 * t395 / 0.12e2 - t128 * t136 * t387 * t389 * t381 / 0.6e1 - t164 * t165 * t126 * t386 * t138 * t395 / 0.4e1 - t143 * t57 * (t412 * t145 * t148 - 0.2e1 * t415 * t351 * t148 - t420 * t376 * t61 / 0.3e1 - t146 * t424 * t61 * t395 + 0.2e1 * t420 * t291 * t61 + 0.2e1 / 0.3e1 * t431 * t333 * t334 * t58 - t412 * t125 * t152 / 0.2e1 + t415 * t350 * t152 + t146 * t424 * t58 * t395 / 0.2e1 - t431 * t333 * t290 * t58) * t93 / 0.4e1 - t467 * t26 * t32 * t94 / 0.4e1 - t33 * t157 / 0.2e1 - t476 / 0.6e1 + t483 - t484 / 0.6e1 - t33 * t196 / 0.2e1 - t488 / 0.6e1 - t143 * t156 * t195 / 0.2e1 - t143 * t63 * t171 * t530 / 0.4e1
  t537 = f.my_piecewise3(t1, 0, t370 + t535)
  t538 = t206 ** 2
  t539 = 0.1e1 / t538
  t540 = t208 ** 2
  t544 = f.my_piecewise5(t10, 0, t6, 0, -t462)
  t548 = f.my_piecewise3(t205, 0, 0.4e1 / 0.9e1 * t539 * t540 + 0.4e1 / 0.3e1 * t206 * t544)
  t555 = t211 * t102 * t32 * t267
  t560 = t271 * t479 * t32 * t267 / 0.18e2
  t562 = f.my_piecewise3(t202, 0, -t548 * t26 * t32 * t267 / 0.4e1 - t555 / 0.6e1 + t560)
  d11 = 0.2e1 * t200 + 0.2e1 * t277 + t2 * (t537 + t562)
  t565 = -t3 - t20
  t566 = f.my_piecewise5(t6, 0, t10, 0, t565)
  t569 = f.my_piecewise3(t16, 0, 0.4e1 / 0.3e1 * t17 * t566)
  t570 = t569 * t26
  t571 = t570 * t32
  t575 = f.my_piecewise3(t1, 0, -t571 * t94 / 0.4e1 - t106)
  t577 = f.my_piecewise5(t10, 0, t6, 0, -t565)
  t580 = f.my_piecewise3(t205, 0, 0.4e1 / 0.3e1 * t206 * t577)
  t581 = t580 * t26
  t582 = t581 * t32
  t585 = t271 * t26
  t586 = t585 * t30
  t587 = f.my_piecewise3(t232, 0, 0)
  t594 = 0.1e1 / t215 / t224 / r1
  t598 = f.my_piecewise3(t231, t587, -0.5e1 / 0.18e2 * l1 * t226 + 0.10e2 / 0.9e1 * t220 * t226 - 0.2e1 / 0.9e1 * t223 * t594)
  t599 = t234 ** 2
  t600 = 0.1e1 / t599
  t601 = t598 * t600
  t602 = t111 * t601
  t603 = t586 * t602
  t605 = jnp.exp(-0.2e1 / 0.3e1 * t235)
  t606 = 0.1e1 / t605
  t607 = t235 ** 2
  t609 = t607 - 0.2e1 * t235 + 0.3e1
  t610 = 0.1e1 / t609
  t611 = t606 * t610
  t612 = t235 - 0.2e1
  t613 = t612 ** 2
  t614 = t611 * t613
  t615 = t614 * t267
  t618 = t585 * t32
  t619 = t110 * t598
  t620 = t600 * t606
  t621 = t619 * t620
  t622 = t610 * t613
  t623 = t622 * t241
  t625 = t619 * t600
  t627 = t611 * t613 * t238
  t630 = t621 * t623 - t625 * t627 / 0.2e1
  t631 = t237 * t630
  t632 = t631 * t266
  t635 = t31 * t237
  t636 = 0.1e1 / t607
  t638 = t635 * t242 * t636
  t639 = t586 * t638
  t640 = t265 * t110
  t642 = t620 * t622
  t643 = t640 * t598 * t642
  t646 = t244 * params.at
  t647 = tau1 * t226
  t650 = 0.1e1 / t252
  t651 = t246 * t650
  t654 = t250 * t254
  t657 = 0.1e1 / t259
  t658 = t251 * t657
  t661 = t257 * t261
  t665 = 0.1e1 / t259 / t252
  t666 = t258 * t665
  t669 = 0.5e1 / 0.3e1 * t647 * t248 + 0.5e1 / 0.3e1 * t651 * t647 - 0.10e2 * t654 * t647 - 0.10e2 * t658 * t647 + 0.25e2 / 0.3e1 * t661 * t647 + 0.25e2 / 0.3e1 * t666 * t647
  t670 = t646 * t669
  t671 = t243 * t670
  t675 = f.my_piecewise3(t202, 0, -t582 * t267 / 0.4e1 - t275 - t603 * t615 / 0.12e2 - t618 * t632 / 0.4e1 + t639 * t643 / 0.4e1 - t618 * t671 / 0.4e1)
  t679 = 0.2e1 * t460
  t680 = f.my_piecewise5(t6, 0, t10, 0, t679)
  t684 = f.my_piecewise3(t16, 0, 0.4e1 / 0.9e1 * t454 * t566 * t22 + 0.4e1 / 0.3e1 * t17 * t680)
  t691 = t569 * t102 * t32 * t94
  t693 = t570 * t30
  t709 = -t684 * t26 * t32 * t94 / 0.4e1 - t691 / 0.12e2 - t693 * t127 * t140 / 0.12e2 - t571 * t157 / 0.4e1 + t693 * t163 * t168 / 0.4e1 - t571 * t196 / 0.4e1 - t476 / 0.12e2 + t483 - t305 / 0.36e2 - t484 / 0.12e2 + t308 / 0.12e2 - t488 / 0.12e2
  t710 = f.my_piecewise3(t1, 0, t709)
  t714 = f.my_piecewise5(t10, 0, t6, 0, -t679)
  t718 = f.my_piecewise3(t205, 0, 0.4e1 / 0.9e1 * t539 * t577 * t208 + 0.4e1 / 0.3e1 * t206 * t714)
  t725 = t580 * t102 * t32 * t267
  t728 = t212 * t30
  t732 = t272 * t30
  t734 = t732 * t602 * t615
  t738 = t273 * t632
  t744 = t732 * t638 * t643
  t748 = t273 * t671
  t750 = -t718 * t26 * t32 * t267 / 0.4e1 - t725 / 0.12e2 - t555 / 0.12e2 + t560 - t728 * t602 * t615 / 0.12e2 - t734 / 0.36e2 - t213 * t632 / 0.4e1 - t738 / 0.12e2 + t728 * t638 * t643 / 0.4e1 + t744 / 0.12e2 - t213 * t671 / 0.4e1 - t748 / 0.12e2
  t751 = f.my_piecewise3(t202, 0, t750)
  d12 = t200 + t277 + t575 + t675 + t2 * (t710 + t751)
  t756 = t566 ** 2
  t760 = 0.2e1 * t19 + 0.2e1 * t460
  t761 = f.my_piecewise5(t6, 0, t10, 0, t760)
  t765 = f.my_piecewise3(t16, 0, 0.4e1 / 0.9e1 * t454 * t756 + 0.4e1 / 0.3e1 * t17 * t761)
  t772 = f.my_piecewise3(t1, 0, -t765 * t26 * t32 * t94 / 0.4e1 - t691 / 0.6e1 + t483)
  t777 = t224 ** 2
  t783 = f.my_piecewise3(t231, t587, 0.20e2 / 0.27e2 * l1 * t594 - 0.80e2 / 0.27e2 * t220 * t594 + 0.22e2 / 0.27e2 * t223 / t215 / t777)
  t790 = t598 ** 2
  t793 = 0.1e1 / t599 / t234
  t794 = t793 * t606
  t810 = t265 * t279 * t790
  t811 = t599 ** 2
  t812 = 0.1e1 / t811
  t813 = t605 ** 2
  t814 = 0.1e1 / t813
  t815 = t812 * t814
  t816 = t609 ** 2
  t817 = 0.1e1 / t816
  t818 = t613 ** 2
  t819 = t817 * t818
  t824 = t613 * t612
  t825 = t817 * t824
  t832 = t586 * t329 * t790 * t812
  t833 = t814 * t817
  t838 = t833 * t818
  t844 = t581 * t30
  t862 = t639 * t640 * t783 * t642 / 0.4e1 - t734 / 0.18e2 + t744 / 0.6e1 - t639 * t640 * t790 * t794 * t622 / 0.2e1 + t586 * t111 * t790 * t793 * t615 / 0.6e1 - t586 * t635 * t242 / t607 / t235 * t810 * t815 * t819 / 0.2e1 + t639 * t810 * t815 * t825 / 0.2e1 - t832 * t833 * t824 * t267 / 0.6e1 + t832 * t838 * t243 * t636 * t265 / 0.3e1 - t844 * t602 * t615 / 0.6e1 + t844 * t638 * t643 / 0.2e1 - t586 * t111 * t783 * t600 * t615 / 0.12e2 - t603 * t614 * t632 / 0.6e1 - t832 * t838 * t267 / 0.12e2
  t868 = t110 * t783
  t871 = t110 * t790
  t875 = t279 * t790
  t876 = t875 * t815
  t880 = t817 * t613
  t886 = 0.2e1 * t235 * t110 * t598 * t642 - 0.2e1 * t625 * t614
  t893 = t875 * t812
  t915 = t577 ** 2
  t919 = f.my_piecewise5(t10, 0, t6, 0, -t760)
  t923 = f.my_piecewise3(t205, 0, 0.4e1 / 0.9e1 * t539 * t915 + 0.4e1 / 0.3e1 * t206 * t919)
  t930 = t613 * t237
  t932 = t242 * t244
  t933 = params.at * t669
  t939 = t606 * t817
  t963 = tau1 * t594
  t966 = tau1 ** 2
  t970 = t966 / t214 / t777 / r1
  t1000 = -0.40e2 / 0.9e1 * t963 * t248 + 0.50e2 / 0.9e1 * t970 * t650 - 0.250e3 / 0.9e1 * t246 * t254 * t970 - 0.40e2 / 0.9e1 * t651 * t963 - 0.100e3 * t250 * t657 * t970 + 0.80e2 / 0.3e1 * t654 * t963 - 0.100e3 / 0.9e1 * t251 * t261 * t970 + 0.80e2 / 0.3e1 * t658 * t963 + 0.1250e4 / 0.9e1 * t257 * t665 * t970 - 0.200e3 / 0.9e1 * t661 * t963 + 0.250e3 / 0.3e1 * t258 / t259 / t253 * t970 - 0.200e3 / 0.9e1 * t666 * t963
  t1005 = t586 * t635 * t630 * t636 * t643 / 0.2e1 - t618 * t237 * (t868 * t620 * t623 - 0.2e1 * t871 * t794 * t623 - t876 * t819 * t241 / 0.3e1 - t621 * t880 * t241 * t886 + 0.2e1 * t876 * t825 * t241 + 0.2e1 / 0.3e1 * t893 * t833 * t818 * t238 - t868 * t600 * t627 / 0.2e1 + t871 * t793 * t627 + t621 * t880 * t238 * t886 / 0.2e1 - t893 * t833 * t824 * t238) * t266 / 0.4e1 - t923 * t26 * t32 * t267 / 0.4e1 - t582 * t632 / 0.2e1 - t603 * t611 * t930 * t932 * t933 / 0.6e1 - t639 * t640 * t601 * t939 * t613 * t886 / 0.4e1 + t639 * t933 * t619 * t642 / 0.2e1 + t603 * t939 * t930 * t932 * t265 * t886 / 0.12e2 - t725 / 0.6e1 - t738 / 0.6e1 + t560 - t748 / 0.6e1 - t582 * t671 / 0.2e1 - t618 * t631 * t670 / 0.2e1 - t618 * t243 * t646 * t1000 / 0.4e1
  t1007 = f.my_piecewise3(t202, 0, t862 + t1005)
  d22 = 0.2e1 * t575 + 0.2e1 * t675 + t2 * (t772 + t1007)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t6 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold - 0.1e1
  t10 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t11 = -t7
  t12 = r0 - r1
  t13 = t12 * t3
  t14 = f.my_piecewise5(t6, t7, t10, t11, t13)
  t15 = 0.1e1 + t14
  t16 = t15 <= f.p.zeta_threshold
  t17 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t18 = t17 * f.p.zeta_threshold
  t19 = t15 ** (0.1e1 / 0.3e1)
  t21 = f.my_piecewise3(t16, t18, t19 * t15)
  t22 = t2 ** (0.1e1 / 0.3e1)
  t23 = t21 * t22
  t25 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t26 = 0.1e1 / t25
  t27 = 4 ** (0.1e1 / 0.3e1)
  t28 = t26 * t27
  t29 = t23 * t28
  t30 = r0 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t33 = 0.1e1 / t31 / r0
  t36 = params.gamma * tau0
  t39 = params.gamma * s0
  t40 = r0 ** 2
  t42 = 0.1e1 / t31 / t40
  t45 = l0 * t33 / 0.6e1 - 0.2e1 / 0.3e1 * t36 * t33 + t39 * t42 / 0.12e2
  t46 = abs(t45)
  t47 = t46 < 0.50e-12
  t48 = 0.0e0 < t45
  t49 = f.my_piecewise3(t48, 0.50e-12, -0.50e-12)
  t50 = f.my_piecewise3(t47, t49, t45)
  t51 = br89_x(t50)
  t53 = jnp.exp(t51 / 0.3e1)
  t54 = jnp.pi ** (0.1e1 / 0.3e1)
  t55 = t54 ** 2
  t56 = f.my_piecewise3(t48, 0, 0)
  t59 = 0.1e1 / t31 / t40 / r0
  t64 = t40 ** 2
  t66 = 0.1e1 / t31 / t64
  t70 = f.my_piecewise3(t47, t56, 0.20e2 / 0.27e2 * l0 * t59 - 0.80e2 / 0.27e2 * t36 * t59 + 0.22e2 / 0.27e2 * t39 * t66)
  t71 = t55 * t70
  t72 = t50 ** 2
  t73 = 0.1e1 / t72
  t75 = jnp.exp(-0.2e1 / 0.3e1 * t51)
  t76 = 0.1e1 / t75
  t77 = t73 * t76
  t78 = t71 * t77
  t79 = t51 ** 2
  t81 = t79 - 0.2e1 * t51 + 0.3e1
  t82 = 0.1e1 / t81
  t83 = t51 - 0.2e1
  t84 = t83 ** 2
  t85 = t82 * t84
  t86 = jnp.exp(-t51)
  t89 = t86 * (0.1e1 + t51 / 0.2e1)
  t90 = t85 * t89
  t99 = f.my_piecewise3(t47, t56, -0.5e1 / 0.18e2 * l0 * t42 + 0.10e2 / 0.9e1 * t36 * t42 - 0.2e1 / 0.9e1 * t39 * t59)
  t100 = t99 ** 2
  t101 = t55 * t100
  t103 = 0.1e1 / t72 / t50
  t104 = t103 * t76
  t105 = t101 * t104
  t108 = t54 * jnp.pi
  t109 = t108 * t100
  t110 = t72 ** 2
  t111 = 0.1e1 / t110
  t112 = t75 ** 2
  t113 = 0.1e1 / t112
  t114 = t111 * t113
  t115 = t109 * t114
  t116 = t81 ** 2
  t117 = 0.1e1 / t116
  t118 = t84 ** 2
  t119 = t117 * t118
  t120 = t119 * t89
  t123 = t55 * t99
  t124 = t123 * t77
  t125 = t117 * t84
  t126 = t51 * t55
  t128 = t77 * t85
  t130 = t123 * t73
  t131 = t76 * t82
  t132 = t131 * t84
  t135 = 0.2e1 * t126 * t99 * t128 - 0.2e1 * t130 * t132
  t136 = t89 * t135
  t137 = t125 * t136
  t139 = t84 * t83
  t140 = t117 * t139
  t141 = t140 * t89
  t144 = t109 * t111
  t145 = t113 * t117
  t146 = t118 * t86
  t147 = t145 * t146
  t150 = t71 * t73
  t152 = t131 * t84 * t86
  t155 = t101 * t103
  t157 = t86 * t135
  t158 = t125 * t157
  t162 = t145 * t139 * t86
  t164 = t78 * t90 - 0.2e1 * t105 * t90 - t115 * t120 / 0.3e1 - t124 * t137 + 0.2e1 * t115 * t141 + 0.2e1 / 0.3e1 * t144 * t147 - t150 * t152 / 0.2e1 + t155 * t152 + t124 * t158 / 0.2e1 - t144 * t162
  t165 = t53 * t164
  t166 = 0.1e1 / t51
  t167 = 6 ** (0.1e1 / 0.3e1)
  t168 = t167 ** 2
  t169 = jnp.pi ** 2
  t170 = t169 ** (0.1e1 / 0.3e1)
  t171 = t170 ** 2
  t173 = 0.3e1 / 0.10e2 * t168 * t171
  t174 = tau0 * t33
  t175 = t173 - t174
  t176 = t173 + t174
  t177 = 0.1e1 / t176
  t179 = t175 ** 2
  t180 = t179 * t175
  t181 = t176 ** 2
  t182 = t181 * t176
  t183 = 0.1e1 / t182
  t186 = t179 ** 2
  t187 = t186 * t175
  t188 = t181 ** 2
  t190 = 0.1e1 / t188 / t176
  t194 = 0.1e1 + params.at * (t175 * t177 - 0.2e1 * t180 * t183 + t187 * t190)
  t195 = t166 * t194
  t196 = t165 * t195
  t199 = t19 ** 2
  t200 = 0.1e1 / t199
  t201 = t2 ** 2
  t202 = 0.1e1 / t201
  t204 = -t12 * t202 + t3
  t205 = f.my_piecewise5(t6, 0, t10, 0, t204)
  t206 = t205 ** 2
  t210 = 0.1e1 / t201 / t2
  t213 = 0.2e1 * t12 * t210 - 0.2e1 * t202
  t214 = f.my_piecewise5(t6, 0, t10, 0, t213)
  t218 = f.my_piecewise3(t16, 0, 0.4e1 / 0.9e1 * t200 * t206 + 0.4e1 / 0.3e1 * t19 * t214)
  t219 = t218 * t22
  t220 = t219 * t28
  t221 = 0.1e1 - t89
  t222 = t53 * t221
  t223 = t222 * t195
  t228 = f.my_piecewise3(t16, 0, 0.4e1 / 0.3e1 * t19 * t205)
  t229 = t22 ** 2
  t230 = 0.1e1 / t229
  t231 = t228 * t230
  t232 = t231 * t28
  t236 = 0.1e1 / t229 / t2
  t237 = t21 * t236
  t238 = t237 * t28
  t241 = t228 * t22
  t242 = t241 * t28
  t246 = t124 * t90 - t130 * t152 / 0.2e1
  t247 = t53 * t246
  t248 = t247 * t195
  t251 = t21 * t230
  t252 = t251 * t28
  t255 = t23 * t26
  t256 = t27 * t55
  t257 = t99 * t73
  t258 = t256 * t257
  t259 = t255 * t258
  t260 = t84 * t53
  t261 = t131 * t260
  t262 = t221 * t166
  t263 = tau0 * t42
  t266 = 0.1e1 / t181
  t267 = t175 * t266
  t270 = t179 * t183
  t273 = 0.1e1 / t188
  t274 = t180 * t273
  t277 = t186 * t190
  t281 = 0.1e1 / t188 / t181
  t282 = t187 * t281
  t285 = 0.5e1 / 0.3e1 * t263 * t177 + 0.5e1 / 0.3e1 * t267 * t263 - 0.10e2 * t270 * t263 - 0.10e2 * t274 * t263 + 0.25e2 / 0.3e1 * t277 * t263 + 0.25e2 / 0.3e1 * t282 * t263
  t286 = params.at * t285
  t287 = t262 * t286
  t288 = t261 * t287
  t291 = t27 * t53
  t292 = 0.1e1 / t79
  t293 = t221 * t292
  t294 = t291 * t293
  t295 = t255 * t294
  t296 = t194 * t55
  t297 = t296 * t257
  t298 = t76 * t117
  t300 = t298 * t84 * t135
  t301 = t297 * t300
  t305 = t286 * t123 * t128
  t308 = t298 * t260
  t309 = t194 * t135
  t310 = t262 * t309
  t311 = t308 * t310
  t314 = t241 * t26
  t315 = t314 * t258
  t316 = t132 * t223
  t319 = t314 * t294
  t321 = t296 * t99 * t128
  t324 = t251 * t26
  t325 = t324 * t258
  t328 = t324 * t294
  t331 = -t29 * t196 / 0.4e1 - t220 * t223 / 0.4e1 - t232 * t223 / 0.6e1 + t238 * t223 / 0.18e2 - t242 * t248 / 0.2e1 - t252 * t248 / 0.6e1 - t259 * t288 / 0.6e1 - t295 * t301 / 0.4e1 + t295 * t305 / 0.2e1 + t259 * t311 / 0.12e2 - t315 * t316 / 0.6e1 + t319 * t321 / 0.2e1 - t325 * t316 / 0.18e2 + t328 * t321 / 0.6e1
  t332 = t70 * t73
  t333 = t256 * t332
  t334 = t255 * t333
  t337 = t132 * t248
  t340 = t27 * t108
  t341 = t100 * t111
  t342 = t340 * t341
  t343 = t255 * t342
  t344 = t145 * t118
  t345 = t344 * t223
  t349 = t291 * t246 * t292
  t350 = t255 * t349
  t354 = t296 * t70 * t128
  t358 = t104 * t85
  t359 = t296 * t100 * t358
  t362 = t100 * t103
  t363 = t256 * t362
  t364 = t255 * t363
  t367 = t145 * t139
  t368 = t367 * t223
  t371 = t292 * t194
  t372 = t222 * t371
  t373 = t344 * t372
  t377 = 0.1e1 / t79 / t51
  t379 = t291 * t221 * t377
  t380 = t255 * t379
  t381 = t194 * t108
  t382 = t381 * t100
  t383 = t114 * t119
  t384 = t382 * t383
  t387 = t114 * t140
  t388 = t382 * t387
  t391 = t166 * params.at
  t392 = t391 * t285
  t393 = t222 * t392
  t398 = t247 * t392
  t401 = tau0 * t59
  t404 = tau0 ** 2
  t405 = t64 * r0
  t408 = t404 / t30 / t405
  t411 = t175 * t183
  t416 = t179 * t273
  t421 = t180 * t190
  t426 = t186 * t281
  t432 = 0.1e1 / t188 / t182
  t433 = t187 * t432
  t438 = -0.40e2 / 0.9e1 * t401 * t177 + 0.50e2 / 0.9e1 * t408 * t266 - 0.250e3 / 0.9e1 * t411 * t408 - 0.40e2 / 0.9e1 * t267 * t401 - 0.100e3 * t416 * t408 + 0.80e2 / 0.3e1 * t270 * t401 - 0.100e3 / 0.9e1 * t421 * t408 + 0.80e2 / 0.3e1 * t274 * t401 + 0.1250e4 / 0.9e1 * t426 * t408 - 0.200e3 / 0.9e1 * t277 * t401 + 0.250e3 / 0.3e1 * t433 * t408 - 0.200e3 / 0.9e1 * t282 * t401
  t439 = t391 * t438
  t440 = t222 * t439
  t443 = -t334 * t316 / 0.12e2 - t259 * t337 / 0.6e1 - t343 * t345 / 0.12e2 + t350 * t321 / 0.2e1 + t295 * t354 / 0.4e1 - t295 * t359 / 0.2e1 + t364 * t316 / 0.6e1 - t343 * t368 / 0.6e1 + t343 * t373 / 0.3e1 - t380 * t384 / 0.2e1 + t295 * t388 / 0.2e1 - t242 * t393 / 0.2e1 - t252 * t393 / 0.6e1 - t29 * t398 / 0.2e1 - t29 * t440 / 0.4e1
  t445 = f.my_piecewise3(t1, 0, t331 + t443)
  t447 = r1 <= f.p.dens_threshold
  t448 = f.my_piecewise5(t10, t7, t6, t11, -t13)
  t449 = 0.1e1 + t448
  t450 = t449 <= f.p.zeta_threshold
  t451 = t449 ** (0.1e1 / 0.3e1)
  t452 = t451 ** 2
  t453 = 0.1e1 / t452
  t455 = f.my_piecewise5(t10, 0, t6, 0, -t204)
  t456 = t455 ** 2
  t460 = f.my_piecewise5(t10, 0, t6, 0, -t213)
  t464 = f.my_piecewise3(t450, 0, 0.4e1 / 0.9e1 * t453 * t456 + 0.4e1 / 0.3e1 * t451 * t460)
  t467 = r1 ** (0.1e1 / 0.3e1)
  t468 = t467 ** 2
  t470 = 0.1e1 / t468 / r1
  t477 = r1 ** 2
  t482 = l1 * t470 / 0.6e1 - 0.2e1 / 0.3e1 * params.gamma * tau1 * t470 + params.gamma * s2 / t468 / t477 / 0.12e2
  t483 = abs(t482)
  t486 = f.my_piecewise3(0.0e0 < t482, 0.50e-12, -0.50e-12)
  t487 = f.my_piecewise3(t483 < 0.50e-12, t486, t482)
  t488 = br89_x(t487)
  t490 = jnp.exp(t488 / 0.3e1)
  t491 = jnp.exp(-t488)
  t498 = tau1 * t470
  t499 = t173 - t498
  t500 = t173 + t498
  t503 = t499 ** 2
  t505 = t500 ** 2
  t510 = t503 ** 2
  t512 = t505 ** 2
  t520 = t490 * (0.1e1 - t491 * (0.1e1 + t488 / 0.2e1)) / t488 * (0.1e1 + params.at * (t499 / t500 - 0.2e1 * t503 * t499 / t505 / t500 + t510 * t499 / t512 / t500))
  t525 = f.my_piecewise3(t450, 0, 0.4e1 / 0.3e1 * t451 * t455)
  t531 = f.my_piecewise3(t450, t18, t451 * t449)
  t537 = f.my_piecewise3(t447, 0, -t464 * t22 * t28 * t520 / 0.4e1 - t525 * t230 * t28 * t520 / 0.6e1 + t531 * t236 * t28 * t520 / 0.18e2)
  t540 = 0.1e1 / t116 / t81
  t541 = t540 * t139
  t557 = t51 * t108 * t100
  t573 = 0.2e1 / 0.3e1 * t144 * t344 + 0.2e1 * t126 * t70 * t128 - 0.4e1 * t126 * t100 * t358 + 0.4e1 / 0.3e1 * t557 * t383 - 0.2e1 * t126 * t257 * t300 + 0.4e1 * t557 * t387 - 0.2e1 * t150 * t132 + 0.4e1 * t155 * t132 + 0.2e1 * t130 * t300 - 0.4e1 * t144 * t367
  t578 = t540 * t118
  t582 = t71 * t104
  t583 = t86 * t99
  t596 = f.my_piecewise3(t47, t56, -0.220e3 / 0.81e2 * l0 * t66 + 0.880e3 / 0.81e2 * t36 * t66 - 0.308e3 / 0.81e2 * t39 / t31 / t405)
  t597 = t55 * t596
  t601 = t108 * t70 * t114
  t605 = t100 * t99
  t606 = t108 * t605
  t608 = 0.1e1 / t110 / t50
  t609 = t608 * t113
  t610 = t606 * t609
  t613 = t169 * t605
  t615 = 0.1e1 / t110 / t72
  t617 = 0.1e1 / t112 / t75
  t618 = t615 * t617
  t619 = t613 * t618
  t620 = t118 * t84
  t621 = t540 * t620
  t628 = t55 * t605
  t629 = t111 * t76
  t633 = t540 * t84
  t634 = t135 ** 2
  t640 = t118 * t83
  t641 = t540 * t640
  t648 = 0.3e1 * t115 * t541 * t157 + t78 * t158 - 0.2e1 * t105 * t158 + t124 * t125 * t86 * t573 / 0.2e1 - 0.2e1 * t115 * t578 * t157 + 0.3e1 * t582 * t85 * t583 + t597 * t77 * t90 + 0.2e1 * t601 * t119 * t583 + 0.2e1 * t610 * t120 - t619 * t621 * t89 / 0.9e1 - 0.3e1 * t601 * t140 * t583 + 0.6e1 * t628 * t629 * t90 - t124 * t633 * t86 * t634 - 0.12e2 * t610 * t141 - 0.2e1 / 0.3e1 * t619 * t641 * t89 + 0.6e1 * t619 * t578 * t89
  t649 = t606 * t608
  t652 = t613 * t615
  t653 = t617 * t540
  t680 = t89 * t99
  t698 = 0.6e1 * t649 * t162 - 0.3e1 * t652 * t653 * t146 - 0.3e1 * t628 * t111 * t152 + 0.10e2 / 0.3e1 * t652 * t653 * t640 * t86 - t597 * t73 * t152 / 0.2e1 + t652 * t653 * t620 * t86 / 0.18e2 - 0.4e1 * t649 * t147 + 0.2e1 * t124 * t633 * t89 * t634 - 0.6e1 * t115 * t541 * t136 - 0.6e1 * t582 * t85 * t680 - 0.2e1 * t78 * t137 - t601 * t119 * t680 + 0.4e1 * t105 * t137 + t115 * t578 * t136 - t124 * t125 * t89 * t573 + 0.6e1 * t601 * t140 * t680
  t712 = t201 ** 2
  t716 = 0.6e1 * t210 - 0.6e1 * t12 / t712
  t717 = f.my_piecewise5(t6, 0, t10, 0, t716)
  t721 = f.my_piecewise3(t16, 0, -0.8e1 / 0.27e2 / t199 / t15 * t206 * t205 + 0.4e1 / 0.3e1 * t200 * t205 * t214 + 0.4e1 / 0.3e1 * t19 * t717)
  t739 = 0.1e1 / t229 / t201
  t765 = t246 * t166
  t775 = t113 * t540
  t776 = t118 * t53
  t777 = t775 * t776
  t781 = -t29 * t53 * (t648 + t698) * t195 / 0.4e1 - t721 * t22 * t28 * t223 / 0.4e1 - 0.3e1 / 0.4e1 * t220 * t248 + t238 * t248 / 0.6e1 - t252 * t196 / 0.4e1 - t232 * t248 / 0.2e1 + t228 * t236 * t28 * t223 / 0.6e1 - 0.5e1 / 0.54e2 * t21 * t739 * t28 * t223 - t218 * t230 * t28 * t223 / 0.4e1 - 0.3e1 / 0.4e1 * t29 * t222 * t292 * params.at * t285 * t55 * t257 * t300 + t29 * t124 * t125 * t222 * t391 * t285 * t135 / 0.4e1 + t334 * t311 / 0.6e1 + t259 * t308 * t765 * t309 / 0.4e1 + t259 * t308 * t262 * t194 * t573 / 0.12e2 + t343 * t777 * t310 / 0.4e1
  t789 = params.at * t438
  t806 = t76 * t540
  t812 = t286 * t109
  t819 = t139 * t53
  t828 = t145 * t776
  t834 = -t343 * t777 * t293 * t309 + 0.3e1 / 0.2e1 * t319 * t305 + 0.3e1 / 0.2e1 * t350 * t305 + 0.3e1 / 0.4e1 * t295 * t789 * t123 * t128 + 0.3e1 / 0.4e1 * t295 * t286 * t71 * t128 - t315 * t288 / 0.2e1 - t334 * t288 / 0.4e1 - t259 * t261 * t765 * t286 / 0.2e1 + t295 * t297 * t806 * t84 * t634 / 0.2e1 - 0.3e1 / 0.2e1 * t380 * t812 * t383 + 0.3e1 / 0.2e1 * t295 * t812 * t387 + t343 * t775 * t819 * t310 / 0.2e1 - t259 * t261 * t262 * t789 / 0.4e1 - t343 * t828 * t287 / 0.4e1 - t325 * t288 / 0.6e1
  t846 = t99 * t111
  t847 = t381 * t846
  t859 = t255 * t340 * t846
  t860 = t194 * t70
  t864 = t99 * t103
  t867 = t262 * t860
  t871 = t145 * t819
  t901 = t364 * t288 / 0.2e1 - t255 * t340 * t70 * t111 * t828 * t262 * t194 * t99 / 0.4e1 + 0.3e1 / 0.2e1 * t295 * t847 * t145 * t139 * t70 - 0.3e1 / 0.2e1 * t380 * t847 * t145 * t118 * t70 + t859 * t828 * t293 * t860 + t255 * t256 * t864 * t261 * t867 / 0.2e1 - t859 * t871 * t867 / 0.2e1 - 0.3e1 / 0.2e1 * t295 * t296 * t864 * t131 * t84 * t70 + t315 * t311 / 0.4e1 - t364 * t311 / 0.3e1 - t259 * t806 * t260 * t262 * t194 * t634 / 0.6e1 + t328 * t305 / 0.2e1 - 0.3e1 / 0.2e1 * t295 * t286 * t101 * t358 - 0.3e1 / 0.4e1 * t319 * t301 - 0.3e1 / 0.4e1 * t350 * t301
  t924 = t381 * t341
  t938 = t324 * t342
  t947 = t255 * t340 * t605 * t608
  t955 = -t295 * t296 * t332 * t300 / 0.2e1 - t295 * t297 * t298 * t84 * t573 / 0.4e1 + t325 * t311 / 0.12e2 - t328 * t301 / 0.4e1 + t295 * t296 * t362 * t300 - t343 * t871 * t287 / 0.2e1 + t343 * t828 * t293 * t286 + 0.3e1 / 0.2e1 * t380 * t924 * t775 * t118 * t135 - 0.3e1 / 0.2e1 * t295 * t924 * t775 * t139 * t135 - t324 * t333 * t316 / 0.12e2 - t938 * t345 / 0.12e2 - 0.3e1 / 0.2e1 * t319 * t359 - 0.3e1 / 0.2e1 * t350 * t359 - 0.2e1 * t947 * t373 + t314 * t363 * t316 / 0.2e1 + t364 * t337 / 0.2e1
  t960 = t314 * t342
  t969 = t255 * t27 * t169 * t605 * t615
  t970 = t653 * t640
  t991 = t194 * t169 * t605
  t1003 = t653 * t620
  t1009 = t79 ** 2
  t1018 = t947 * t345 / 0.2e1 - t960 * t368 / 0.2e1 - t343 * t367 * t248 / 0.2e1 - 0.11e2 / 0.18e2 * t969 * t970 * t223 + t960 * t373 + t343 * t344 * t247 * t371 - 0.3e1 / 0.2e1 * t255 * t291 * t246 * t377 * t384 + 0.3e1 / 0.2e1 * t319 * t388 + 0.3e1 / 0.2e1 * t350 * t388 - t314 * t333 * t316 / 0.4e1 + 0.3e1 / 0.2e1 * t295 * t991 * t618 * t578 - t969 * t653 * t118 * t223 / 0.2e1 + 0.7e1 / 0.3e1 * t969 * t970 * t372 - 0.3e1 / 0.2e1 * t969 * t1003 * t222 * t377 * t194 + 0.3e1 / 0.2e1 * t255 * t291 * t221 / t1009 * t991 * t618 * t621
  t1044 = t381 * t605
  t1063 = -0.3e1 * t380 * t991 * t618 * t641 - t324 * t379 * t384 / 0.2e1 + t328 * t388 / 0.2e1 + t938 * t373 / 0.3e1 - t255 * t256 * t605 * t111 * t316 / 0.2e1 - t938 * t368 / 0.6e1 - t960 * t345 / 0.4e1 + 0.3e1 / 0.4e1 * t319 * t354 + t324 * t363 * t316 / 0.6e1 + 0.3e1 * t380 * t1044 * t609 * t119 - 0.3e1 * t295 * t1044 * t609 * t140 + t947 * t368 + t328 * t354 / 0.4e1 - t255 * t256 * t596 * t73 * t316 / 0.12e2 - t334 * t337 / 0.4e1
  t1077 = t219 * t26
  t1103 = t231 * t26
  t1110 = t237 * t26
  t1114 = -t343 * t344 * t248 / 0.4e1 - 0.5e1 / 0.36e2 * t969 * t1003 * t223 + 0.3e1 / 0.4e1 * t350 * t354 + t295 * t296 * t596 * t128 / 0.4e1 - t1077 * t258 * t316 / 0.4e1 + 0.3e1 / 0.4e1 * t1077 * t294 * t321 - t259 * t132 * t196 / 0.4e1 + 0.3e1 / 0.4e1 * t255 * t291 * t164 * t292 * t321 + 0.23e2 / 0.36e2 * t969 * t1003 * t372 - 0.3e1 / 0.2e1 * t314 * t379 * t384 - t315 * t337 / 0.2e1 + 0.3e1 / 0.2e1 * t314 * t349 * t321 - t1103 * t258 * t316 / 0.6e1 + t1103 * t294 * t321 / 0.2e1 + t1110 * t258 * t316 / 0.18e2
  t1154 = t64 ** 2
  t1156 = t404 * tau0 / t1154
  t1168 = t188 ** 2
  t1173 = tau0 * t66
  t1179 = t404 / t30 / t64 / t40
  t1204 = -0.4250e4 / 0.9e1 * t175 * t273 * t1156 - 0.6500e4 / 0.9e1 * t179 * t190 * t1156 + 0.2500e4 / 0.3e1 * t180 * t281 * t1156 + 0.6250e4 / 0.3e1 * t186 * t432 * t1156 + 0.8750e4 / 0.9e1 * t187 / t1168 * t1156 + 0.440e3 / 0.27e2 * t1173 * t177 + 0.2000e4 / 0.9e1 * t411 * t1179 + 0.440e3 / 0.27e2 * t267 * t1173 + 0.800e3 * t416 * t1179 - 0.880e3 / 0.9e1 * t270 * t1173 + 0.800e3 / 0.9e1 * t421 * t1179 - 0.880e3 / 0.9e1 * t274 * t1173 - 0.10000e5 / 0.9e1 * t426 * t1179 + 0.2200e4 / 0.27e2 * t277 * t1173 - 0.2000e4 / 0.3e1 * t433 * t1179 + 0.2200e4 / 0.27e2 * t282 * t1173 - 0.400e3 / 0.9e1 * t1179 * t266 - 0.250e3 / 0.9e1 * t1156 * t183
  t1209 = -t1110 * t294 * t321 / 0.6e1 - t325 * t337 / 0.6e1 + t324 * t349 * t321 / 0.2e1 - t328 * t359 / 0.2e1 + 0.3e1 / 0.2e1 * t295 * t296 * t605 * t629 * t85 - 0.3e1 / 0.4e1 * t242 * t196 - 0.3e1 / 0.4e1 * t220 * t393 - 0.3e1 / 0.4e1 * t29 * t165 * t392 - 0.3e1 / 0.2e1 * t242 * t398 - t232 * t393 / 0.2e1 + t238 * t393 / 0.6e1 - t252 * t398 / 0.2e1 - 0.3e1 / 0.4e1 * t242 * t440 - t252 * t440 / 0.4e1 - 0.3e1 / 0.4e1 * t29 * t247 * t439 - t29 * t222 * t391 * t1204 / 0.4e1
  t1213 = f.my_piecewise3(t1, 0, t781 + t834 + t901 + t955 + t1018 + t1063 + t1114 + t1209)
  t1223 = f.my_piecewise5(t10, 0, t6, 0, -t716)
  t1227 = f.my_piecewise3(t450, 0, -0.8e1 / 0.27e2 / t452 / t449 * t456 * t455 + 0.4e1 / 0.3e1 * t453 * t455 * t460 + 0.4e1 / 0.3e1 * t451 * t1223)
  t1245 = f.my_piecewise3(t447, 0, -t1227 * t22 * t28 * t520 / 0.4e1 - t464 * t230 * t28 * t520 / 0.4e1 + t525 * t236 * t28 * t520 / 0.6e1 - 0.5e1 / 0.54e2 * t531 * t739 * t28 * t520)
  d111 = 0.3e1 * t445 + 0.3e1 * t537 + t2 * (t1213 + t1245)

  res = {'v3rho3': d111}
  return res
