"""Generated from mgga_x_edmgga.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  b98_q = lambda x, u, t: 1 - (t - x ** 2 / 8 - u / 4) / K_FACTOR_C

  edmgga_mu = 0.21

  edmgga_a = 0.704

  edmgga_fminf = 1 / 3 * (4 * jnp.pi ** 2 / 3) ** (1 / 3)

  edmgga_b = 2 * jnp.pi / 9 * jnp.sqrt(6 / 5)

  edmgga_x_large = lambda y: -1 / (2 * y) + 1 / (8 * y ** 3)

  edmgga_c1 = edmgga_fminf

  edmgga_x = lambda Qb: f.my_piecewise3(Qb < -10000.0 / edmgga_a, edmgga_x_large(jnp.minimum(edmgga_a * Qb, -0.0001 / edmgga_a)), edmgga_a * Qb + jnp.sqrt(1 + (edmgga_a * Qb) ** 2))

  edmgga_c2 = 1 - edmgga_c1

  edmgga_c3 = edmgga_c2 * jnp.sqrt(2 * edmgga_a) / (2 * edmgga_b)

  edmgga_c4 = 1 / edmgga_c3 ** 3 * (edmgga_c3 ** 2 - 0.09834 * edmgga_mu)

  edmgga_f_x = lambda x: edmgga_c1 + edmgga_c2 * x / (1 + edmgga_c3 * jnp.sqrt(x) * jnp.arcsinh(edmgga_c4 * (x - 1)))

  edmgga_f = lambda x, u, t: edmgga_f_x(edmgga_x(b98_q(x, u, t)))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, edmgga_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  b98_q = lambda x, u, t: 1 - (t - x ** 2 / 8 - u / 4) / K_FACTOR_C

  edmgga_mu = 0.21

  edmgga_a = 0.704

  edmgga_fminf = 1 / 3 * (4 * jnp.pi ** 2 / 3) ** (1 / 3)

  edmgga_b = 2 * jnp.pi / 9 * jnp.sqrt(6 / 5)

  edmgga_x_large = lambda y: -1 / (2 * y) + 1 / (8 * y ** 3)

  edmgga_c1 = edmgga_fminf

  edmgga_x = lambda Qb: f.my_piecewise3(Qb < -10000.0 / edmgga_a, edmgga_x_large(jnp.minimum(edmgga_a * Qb, -0.0001 / edmgga_a)), edmgga_a * Qb + jnp.sqrt(1 + (edmgga_a * Qb) ** 2))

  edmgga_c2 = 1 - edmgga_c1

  edmgga_c3 = edmgga_c2 * jnp.sqrt(2 * edmgga_a) / (2 * edmgga_b)

  edmgga_c4 = 1 / edmgga_c3 ** 3 * (edmgga_c3 ** 2 - 0.09834 * edmgga_mu)

  edmgga_f_x = lambda x: edmgga_c1 + edmgga_c2 * x / (1 + edmgga_c3 * jnp.sqrt(x) * jnp.arcsinh(edmgga_c4 * (x - 1)))

  edmgga_f = lambda x, u, t: edmgga_f_x(edmgga_x(b98_q(x, u, t)))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, edmgga_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  b98_q = lambda x, u, t: 1 - (t - x ** 2 / 8 - u / 4) / K_FACTOR_C

  edmgga_mu = 0.21

  edmgga_a = 0.704

  edmgga_fminf = 1 / 3 * (4 * jnp.pi ** 2 / 3) ** (1 / 3)

  edmgga_b = 2 * jnp.pi / 9 * jnp.sqrt(6 / 5)

  edmgga_x_large = lambda y: -1 / (2 * y) + 1 / (8 * y ** 3)

  edmgga_c1 = edmgga_fminf

  edmgga_x = lambda Qb: f.my_piecewise3(Qb < -10000.0 / edmgga_a, edmgga_x_large(jnp.minimum(edmgga_a * Qb, -0.0001 / edmgga_a)), edmgga_a * Qb + jnp.sqrt(1 + (edmgga_a * Qb) ** 2))

  edmgga_c2 = 1 - edmgga_c1

  edmgga_c3 = edmgga_c2 * jnp.sqrt(2 * edmgga_a) / (2 * edmgga_b)

  edmgga_c4 = 1 / edmgga_c3 ** 3 * (edmgga_c3 ** 2 - 0.09834 * edmgga_mu)

  edmgga_f_x = lambda x: edmgga_c1 + edmgga_c2 * x / (1 + edmgga_c3 * jnp.sqrt(x) * jnp.arcsinh(edmgga_c4 * (x - 1)))

  edmgga_f = lambda x, u, t: edmgga_f_x(edmgga_x(b98_q(x, u, t)))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, edmgga_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = 4 ** (0.1e1 / 0.3e1)
  t29 = t2 ** 2
  t31 = jnp.pi ** 2
  t32 = t31 ** (0.1e1 / 0.3e1)
  t33 = t28 * t29 * t32
  t34 = t33 / 0.9e1
  t35 = 0.1e1 - t34
  t36 = r0 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t39 = 0.1e1 / t37 / r0
  t41 = r0 ** 2
  t43 = 0.1e1 / t37 / t41
  t49 = 6 ** (0.1e1 / 0.3e1)
  t51 = t32 ** 2
  t52 = 0.1e1 / t51
  t53 = (tau0 * t39 - s0 * t43 / 0.8e1 - l0 * t39 / 0.4e1) * t49 * t52
  t55 = -0.5e1 / 0.9e1 * t53 < -0.14205545454545454545454545454545454545454545454545e5
  t56 = 0.39111111111111111111111111111111111111111111111111e0 * t53
  t58 = 0.0e0 < 0.70414204545454545454545454545454545454545454545455e0 - t56
  t59 = 0.704e0 - t56
  t60 = f.my_piecewise3(t58, -0.14204545454545454545454545454545454545454545454545e-3, t59)
  t63 = t60 ** 2
  t68 = t59 ** 2
  t70 = jnp.sqrt(0.1e1 + t68)
  t72 = f.my_piecewise3(t55, -0.1e1 / t60 / 0.2e1 + 0.1e1 / t63 / t60 / 0.8e1, 0.704e0 - t56 + t70)
  t73 = t35 * t72
  t75 = 0.11865917579353060717938235905281140897567846910556e1 - 0.13184352865947845242153595450312378775075385456173e0 * t33
  t77 = t75 / jnp.pi
  t78 = jnp.sqrt(0.30e2)
  t79 = jnp.sqrt(t72)
  t81 = t75 ** 2
  t85 = 0.1e1 / t81 / t75 * t31 * jnp.pi
  t89 = 0.135e3 / 0.32e2 * t81 / t31 - 0.206514e-1
  t90 = t78 * t89
  t91 = t72 - 0.1e1
  t95 = jnp.arcsinh(0.128e3 / 0.6075e4 * t85 * t90 * t91)
  t99 = 0.1e1 + 0.3e1 / 0.8e1 * t77 * t78 * t79 * t95
  t100 = 0.1e1 / t99
  t102 = t73 * t100 + t34
  t106 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t102)
  t107 = r1 <= f.p.dens_threshold
  t108 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t109 = 0.1e1 + t108
  t110 = t109 <= f.p.zeta_threshold
  t111 = t109 ** (0.1e1 / 0.3e1)
  t113 = f.my_piecewise3(t110, t22, t111 * t109)
  t114 = t113 * t26
  t115 = r1 ** (0.1e1 / 0.3e1)
  t116 = t115 ** 2
  t118 = 0.1e1 / t116 / r1
  t120 = r1 ** 2
  t122 = 0.1e1 / t116 / t120
  t129 = (tau1 * t118 - s2 * t122 / 0.8e1 - l1 * t118 / 0.4e1) * t49 * t52
  t131 = -0.5e1 / 0.9e1 * t129 < -0.14205545454545454545454545454545454545454545454545e5
  t132 = 0.39111111111111111111111111111111111111111111111111e0 * t129
  t134 = 0.0e0 < 0.70414204545454545454545454545454545454545454545455e0 - t132
  t135 = 0.704e0 - t132
  t136 = f.my_piecewise3(t134, -0.14204545454545454545454545454545454545454545454545e-3, t135)
  t139 = t136 ** 2
  t144 = t135 ** 2
  t146 = jnp.sqrt(0.1e1 + t144)
  t148 = f.my_piecewise3(t131, -0.1e1 / t136 / 0.2e1 + 0.1e1 / t139 / t136 / 0.8e1, 0.704e0 - t132 + t146)
  t149 = t35 * t148
  t150 = jnp.sqrt(t148)
  t152 = t148 - 0.1e1
  t156 = jnp.arcsinh(0.128e3 / 0.6075e4 * t85 * t90 * t152)
  t160 = 0.1e1 + 0.3e1 / 0.8e1 * t77 * t78 * t150 * t156
  t161 = 0.1e1 / t160
  t163 = t149 * t161 + t34
  t167 = f.my_piecewise3(t107, 0, -0.3e1 / 0.8e1 * t5 * t114 * t163)
  t168 = t6 ** 2
  t170 = t16 / t168
  t171 = t7 - t170
  t172 = f.my_piecewise5(t10, 0, t14, 0, t171)
  t175 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t172)
  t180 = t26 ** 2
  t181 = 0.1e1 / t180
  t185 = t5 * t25 * t181 * t102 / 0.8e1
  t186 = 0.1e1 / t63
  t198 = (-0.5e1 / 0.3e1 * tau0 * t43 + s0 / t37 / t41 / r0 / 0.3e1 + 0.5e1 / 0.12e2 * l0 * t43) * t49 * t52
  t199 = 0.39111111111111111111111111111111111111111111111111e0 * t198
  t200 = f.my_piecewise3(t58, 0, -t199)
  t203 = t63 ** 2
  t204 = 0.1e1 / t203
  t209 = 0.1e1 / t70 * t59
  t213 = f.my_piecewise3(t55, t186 * t200 / 0.2e1 - 0.3e1 / 0.8e1 * t204 * t200, -t199 - 0.39111111111111111111111111111111111111111111111111e0 * t209 * t198)
  t216 = t99 ** 2
  t217 = 0.1e1 / t216
  t218 = t77 * t78
  t220 = 0.1e1 / t79 * t95
  t225 = 0.1e1 / t81 * t31
  t226 = t225 * t79
  t228 = t81 ** 2
  t231 = t31 ** 2
  t233 = 0.1e1 / t228 / t81 * t231 * t31
  t234 = t89 ** 2
  t235 = t91 ** 2
  t240 = jnp.sqrt(0.491520e6 * t233 * t234 * t235 + 0.36905625e8)
  t241 = 0.1e1 / t240
  t253 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t175 * t26 * t102 - t185 - 0.3e1 / 0.8e1 * t5 * t27 * (t35 * t213 * t100 - t73 * t217 * (0.3e1 / 0.16e2 * t218 * t220 * t213 + 0.1440e4 * t226 * t89 * t213 * t241)))
  t255 = f.my_piecewise5(t14, 0, t10, 0, -t171)
  t258 = f.my_piecewise3(t110, 0, 0.4e1 / 0.3e1 * t111 * t255)
  t266 = t5 * t113 * t181 * t163 / 0.8e1
  t268 = f.my_piecewise3(t107, 0, -0.3e1 / 0.8e1 * t5 * t258 * t26 * t163 - t266)
  vrho_0_ = t106 + t167 + t6 * (t253 + t268)
  t271 = -t7 - t170
  t272 = f.my_piecewise5(t10, 0, t14, 0, t271)
  t275 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t272)
  t281 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t275 * t26 * t102 - t185)
  t283 = f.my_piecewise5(t14, 0, t10, 0, -t271)
  t286 = f.my_piecewise3(t110, 0, 0.4e1 / 0.3e1 * t111 * t283)
  t291 = 0.1e1 / t139
  t303 = (-0.5e1 / 0.3e1 * tau1 * t122 + s2 / t116 / t120 / r1 / 0.3e1 + 0.5e1 / 0.12e2 * l1 * t122) * t49 * t52
  t304 = 0.39111111111111111111111111111111111111111111111111e0 * t303
  t305 = f.my_piecewise3(t134, 0, -t304)
  t308 = t139 ** 2
  t309 = 0.1e1 / t308
  t314 = 0.1e1 / t146 * t135
  t318 = f.my_piecewise3(t131, t291 * t305 / 0.2e1 - 0.3e1 / 0.8e1 * t309 * t305, -t304 - 0.39111111111111111111111111111111111111111111111111e0 * t314 * t303)
  t321 = t160 ** 2
  t322 = 0.1e1 / t321
  t324 = 0.1e1 / t150 * t156
  t328 = t225 * t150
  t330 = t152 ** 2
  t335 = jnp.sqrt(0.491520e6 * t233 * t234 * t330 + 0.36905625e8)
  t336 = 0.1e1 / t335
  t348 = f.my_piecewise3(t107, 0, -0.3e1 / 0.8e1 * t5 * t286 * t26 * t163 - t266 - 0.3e1 / 0.8e1 * t5 * t114 * (t35 * t318 * t161 - t149 * t322 * (0.3e1 / 0.16e2 * t218 * t324 * t318 + 0.1440e4 * t328 * t89 * t318 * t336)))
  vrho_1_ = t106 + t167 + t6 * (t281 + t348)
  t352 = t43 * t49 * t52
  t353 = 0.48888888888888888888888888888888888888888888888889e-1 * t352
  t354 = f.my_piecewise3(t58, 0, t353)
  t363 = f.my_piecewise3(t55, t186 * t354 / 0.2e1 - 0.3e1 / 0.8e1 * t204 * t354, t353 + 0.48888888888888888888888888888888888888888888888889e-1 * t209 * t352)
  t380 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (t35 * t363 * t100 - t73 * t217 * (0.3e1 / 0.16e2 * t218 * t220 * t363 + 0.1440e4 * t226 * t89 * t363 * t241)))
  vsigma_0_ = t6 * t380
  vsigma_1_ = 0.0e0
  t382 = t122 * t49 * t52
  t383 = 0.48888888888888888888888888888888888888888888888889e-1 * t382
  t384 = f.my_piecewise3(t134, 0, t383)
  t393 = f.my_piecewise3(t131, t291 * t384 / 0.2e1 - 0.3e1 / 0.8e1 * t309 * t384, t383 + 0.48888888888888888888888888888888888888888888888889e-1 * t314 * t382)
  t410 = f.my_piecewise3(t107, 0, -0.3e1 / 0.8e1 * t5 * t114 * (t35 * t393 * t161 - t149 * t322 * (0.3e1 / 0.16e2 * t218 * t324 * t393 + 0.1440e4 * t328 * t89 * t393 * t336)))
  vsigma_2_ = t6 * t410
  t412 = t39 * t49 * t52
  t413 = 0.97777777777777777777777777777777777777777777777778e-1 * t412
  t414 = f.my_piecewise3(t58, 0, t413)
  t420 = t209 * t412
  t423 = f.my_piecewise3(t55, t186 * t414 / 0.2e1 - 0.3e1 / 0.8e1 * t204 * t414, t413 + 0.97777777777777777777777777777777777777777777777780e-1 * t420)
  t440 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (t35 * t423 * t100 - t73 * t217 * (0.3e1 / 0.16e2 * t218 * t220 * t423 + 0.1440e4 * t226 * t89 * t423 * t241)))
  vlapl_0_ = t6 * t440
  t442 = t118 * t49 * t52
  t443 = 0.97777777777777777777777777777777777777777777777778e-1 * t442
  t444 = f.my_piecewise3(t134, 0, t443)
  t450 = t314 * t442
  t453 = f.my_piecewise3(t131, t291 * t444 / 0.2e1 - 0.3e1 / 0.8e1 * t309 * t444, t443 + 0.97777777777777777777777777777777777777777777777780e-1 * t450)
  t470 = f.my_piecewise3(t107, 0, -0.3e1 / 0.8e1 * t5 * t114 * (t35 * t453 * t161 - t149 * t322 * (0.3e1 / 0.16e2 * t218 * t324 * t453 + 0.1440e4 * t328 * t89 * t453 * t336)))
  vlapl_1_ = t6 * t470
  t471 = 0.39111111111111111111111111111111111111111111111111e0 * t412
  t472 = f.my_piecewise3(t58, 0, -t471)
  t480 = f.my_piecewise3(t55, t186 * t472 / 0.2e1 - 0.3e1 / 0.8e1 * t204 * t472, -t471 - 0.39111111111111111111111111111111111111111111111111e0 * t420)
  t497 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (t35 * t480 * t100 - t73 * t217 * (0.3e1 / 0.16e2 * t218 * t220 * t480 + 0.1440e4 * t226 * t89 * t480 * t241)))
  vtau_0_ = t6 * t497
  t498 = 0.39111111111111111111111111111111111111111111111111e0 * t442
  t499 = f.my_piecewise3(t134, 0, -t498)
  t507 = f.my_piecewise3(t131, t291 * t499 / 0.2e1 - 0.3e1 / 0.8e1 * t309 * t499, -t498 - 0.39111111111111111111111111111111111111111111111111e0 * t450)
  t524 = f.my_piecewise3(t107, 0, -0.3e1 / 0.8e1 * t5 * t114 * (t35 * t507 * t161 - t149 * t322 * (0.3e1 / 0.16e2 * t218 * t324 * t507 + 0.1440e4 * t328 * t89 * t507 * t336)))
  vtau_1_ = t6 * t524
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  b98_q = lambda x, u, t: 1 - (t - x ** 2 / 8 - u / 4) / K_FACTOR_C

  edmgga_mu = 0.21

  edmgga_a = 0.704

  edmgga_fminf = 1 / 3 * (4 * jnp.pi ** 2 / 3) ** (1 / 3)

  edmgga_b = 2 * jnp.pi / 9 * jnp.sqrt(6 / 5)

  edmgga_x_large = lambda y: -1 / (2 * y) + 1 / (8 * y ** 3)

  edmgga_c1 = edmgga_fminf

  edmgga_x = lambda Qb: f.my_piecewise3(Qb < -10000.0 / edmgga_a, edmgga_x_large(jnp.minimum(edmgga_a * Qb, -0.0001 / edmgga_a)), edmgga_a * Qb + jnp.sqrt(1 + (edmgga_a * Qb) ** 2))

  edmgga_c2 = 1 - edmgga_c1

  edmgga_c3 = edmgga_c2 * jnp.sqrt(2 * edmgga_a) / (2 * edmgga_b)

  edmgga_c4 = 1 / edmgga_c3 ** 3 * (edmgga_c3 ** 2 - 0.09834 * edmgga_mu)

  edmgga_f_x = lambda x: edmgga_c1 + edmgga_c2 * x / (1 + edmgga_c3 * jnp.sqrt(x) * jnp.arcsinh(edmgga_c4 * (x - 1)))

  edmgga_f = lambda x, u, t: edmgga_f_x(edmgga_x(b98_q(x, u, t)))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, edmgga_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = 4 ** (0.1e1 / 0.3e1)
  t21 = t3 ** 2
  t23 = jnp.pi ** 2
  t24 = t23 ** (0.1e1 / 0.3e1)
  t25 = t20 * t21 * t24
  t26 = t25 / 0.9e1
  t27 = 0.1e1 - t26
  t28 = 2 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = tau0 * t29
  t31 = t18 ** 2
  t33 = 0.1e1 / t31 / r0
  t35 = s0 * t29
  t36 = r0 ** 2
  t38 = 0.1e1 / t31 / t36
  t41 = l0 * t29
  t45 = 6 ** (0.1e1 / 0.3e1)
  t47 = t24 ** 2
  t48 = 0.1e1 / t47
  t49 = (t30 * t33 - t35 * t38 / 0.8e1 - t41 * t33 / 0.4e1) * t45 * t48
  t51 = -0.5e1 / 0.9e1 * t49 < -0.14205545454545454545454545454545454545454545454545e5
  t52 = 0.39111111111111111111111111111111111111111111111111e0 * t49
  t54 = 0.0e0 < 0.70414204545454545454545454545454545454545454545455e0 - t52
  t55 = 0.704e0 - t52
  t56 = f.my_piecewise3(t54, -0.14204545454545454545454545454545454545454545454545e-3, t55)
  t59 = t56 ** 2
  t64 = t55 ** 2
  t66 = jnp.sqrt(0.1e1 + t64)
  t68 = f.my_piecewise3(t51, -0.1e1 / t56 / 0.2e1 + 0.1e1 / t59 / t56 / 0.8e1, 0.704e0 - t52 + t66)
  t69 = t27 * t68
  t71 = 0.11865917579353060717938235905281140897567846910556e1 - 0.13184352865947845242153595450312378775075385456173e0 * t25
  t73 = t71 / jnp.pi
  t74 = jnp.sqrt(0.30e2)
  t75 = jnp.sqrt(t68)
  t77 = t71 ** 2
  t85 = 0.135e3 / 0.32e2 * t77 / t23 - 0.206514e-1
  t87 = t68 - 0.1e1
  t91 = jnp.arcsinh(0.128e3 / 0.6075e4 / t77 / t71 * t23 * jnp.pi * t74 * t85 * t87)
  t95 = 0.1e1 + 0.3e1 / 0.8e1 * t73 * t74 * t75 * t91
  t96 = 0.1e1 / t95
  t98 = t69 * t96 + t26
  t102 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t98)
  t108 = 0.1e1 / t59
  t120 = (-0.5e1 / 0.3e1 * t30 * t38 + t35 / t31 / t36 / r0 / 0.3e1 + 0.5e1 / 0.12e2 * t41 * t38) * t45 * t48
  t121 = 0.39111111111111111111111111111111111111111111111111e0 * t120
  t122 = f.my_piecewise3(t54, 0, -t121)
  t125 = t59 ** 2
  t126 = 0.1e1 / t125
  t131 = 0.1e1 / t66 * t55
  t135 = f.my_piecewise3(t51, t108 * t122 / 0.2e1 - 0.3e1 / 0.8e1 * t126 * t122, -t121 - 0.39111111111111111111111111111111111111111111111111e0 * t131 * t120)
  t138 = t95 ** 2
  t139 = 0.1e1 / t138
  t140 = t73 * t74
  t142 = 0.1e1 / t75 * t91
  t148 = 0.1e1 / t77 * t23 * t75
  t150 = t77 ** 2
  t153 = t23 ** 2
  t156 = t85 ** 2
  t157 = t87 ** 2
  t162 = jnp.sqrt(0.36905625e8 + 0.491520e6 / t150 / t77 * t153 * t23 * t156 * t157)
  t163 = 0.1e1 / t162
  t175 = f.my_piecewise3(t2, 0, -t6 * t17 / t31 * t98 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (t27 * t135 * t96 - t69 * t139 * (0.3e1 / 0.16e2 * t140 * t142 * t135 + 0.1440e4 * t148 * t85 * t135 * t163)))
  vrho_0_ = 0.2e1 * r0 * t175 + 0.2e1 * t102
  t179 = t45 * t48
  t181 = 0.48888888888888888888888888888888888888888888888889e-1 * t29 * t38 * t179
  t182 = f.my_piecewise3(t54, 0, t181)
  t188 = t131 * t29
  t194 = f.my_piecewise3(t51, t108 * t182 / 0.2e1 - 0.3e1 / 0.8e1 * t126 * t182, t181 + 0.48888888888888888888888888888888888888888888888889e-1 * t188 * t38 * t45 * t48)
  t211 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t27 * t194 * t96 - t69 * t139 * (0.3e1 / 0.16e2 * t140 * t142 * t194 + 0.1440e4 * t148 * t85 * t194 * t163)))
  vsigma_0_ = 0.2e1 * r0 * t211
  t214 = t29 * t33 * t179
  t215 = 0.97777777777777777777777777777777777777777777777778e-1 * t214
  t216 = f.my_piecewise3(t54, 0, t215)
  t224 = t188 * t33 * t45 * t48
  t227 = f.my_piecewise3(t51, t108 * t216 / 0.2e1 - 0.3e1 / 0.8e1 * t126 * t216, t215 + 0.97777777777777777777777777777777777777777777777780e-1 * t224)
  t244 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t27 * t227 * t96 - t69 * t139 * (0.3e1 / 0.16e2 * t140 * t142 * t227 + 0.1440e4 * t148 * t85 * t227 * t163)))
  vlapl_0_ = 0.2e1 * r0 * t244
  t246 = 0.39111111111111111111111111111111111111111111111111e0 * t214
  t247 = f.my_piecewise3(t54, 0, -t246)
  t255 = f.my_piecewise3(t51, t108 * t247 / 0.2e1 - 0.3e1 / 0.8e1 * t126 * t247, -t246 - 0.39111111111111111111111111111111111111111111111111e0 * t224)
  t272 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t27 * t255 * t96 - t69 * t139 * (0.3e1 / 0.16e2 * t140 * t142 * t255 + 0.1440e4 * t148 * t85 * t255 * t163)))
  vtau_0_ = 0.2e1 * r0 * t272
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t22 = 4 ** (0.1e1 / 0.3e1)
  t23 = t3 ** 2
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t28 = t22 * t23 * t26 / 0.9e1
  t29 = 0.1e1 - t28
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = tau0 * t31
  t34 = 0.1e1 / t19 / r0
  t36 = s0 * t31
  t37 = r0 ** 2
  t39 = 0.1e1 / t19 / t37
  t42 = l0 * t31
  t46 = 6 ** (0.1e1 / 0.3e1)
  t48 = t26 ** 2
  t49 = 0.1e1 / t48
  t50 = (t32 * t34 - t36 * t39 / 0.8e1 - t42 * t34 / 0.4e1) * t46 * t49
  t51 = 0.5e1 / 0.9e1 * t50
  t52 = -t51 < -0.14205545454545454545454545454545454545454545454545e5
  t53 = 0.39111111111111111111111111111111111111111111111111e0 * t50
  t55 = 0.0e0 < 0.70414204545454545454545454545454545454545454545455e0 - t53
  t57 = f.my_piecewise3(t55, -0.14204545454545454545454545454545454545454545454545e-3, 0.704e0 - t53)
  t60 = t57 ** 2
  t62 = 0.1e1 / t60 / t57
  t65 = 0.1e1 - t51
  t66 = t65 ** 2
  t68 = 0.1e1 + 0.495616e0 * t66
  t69 = jnp.sqrt(t68)
  t71 = f.my_piecewise3(t52, -0.1e1 / t57 / 0.2e1 + t62 / 0.8e1, 0.704e0 - t53 + t69)
  t72 = t29 * t71
  t74 = t29 / jnp.pi
  t75 = jnp.sqrt(0.30e2)
  t76 = jnp.sqrt(t71)
  t78 = t29 ** 2
  t86 = 0.59400000000000000000000000000000000000000000000000e1 * t78 / t25 - 0.206514e-1
  t88 = t71 - 0.1e1
  t92 = jnp.arcsinh(0.12611295594149683618527696903038317622317287894258e-1 / t78 / t29 * t25 * jnp.pi * t75 * t86 * t88)
  t96 = 0.1e1 + 0.44497190922573977692268384644804278365879425914585e0 * t74 * t75 * t76 * t92
  t97 = 0.1e1 / t96
  t99 = t72 * t97 + t28
  t103 = t17 * t18
  t104 = 0.1e1 / t60
  t109 = 0.1e1 / t19 / t37 / r0
  t114 = -0.5e1 / 0.3e1 * t32 * t39 + t36 * t109 / 0.3e1 + 0.5e1 / 0.12e2 * t42 * t39
  t116 = t114 * t46 * t49
  t117 = 0.39111111111111111111111111111111111111111111111111e0 * t116
  t118 = f.my_piecewise3(t55, 0, -t117)
  t121 = t60 ** 2
  t122 = 0.1e1 / t121
  t126 = 0.1e1 / t69
  t127 = t126 * t65
  t131 = f.my_piecewise3(t52, t104 * t118 / 0.2e1 - 0.3e1 / 0.8e1 * t122 * t118, -t117 - 0.27534222222222222222222222222222222222222222222222e0 * t127 * t116)
  t132 = t29 * t131
  t134 = t96 ** 2
  t135 = 0.1e1 / t134
  t136 = t74 * t75
  t137 = 0.1e1 / t76
  t138 = t137 * t92
  t143 = 0.1e1 / t78 * t25
  t144 = t143 * t76
  t146 = t78 ** 2
  t149 = t25 ** 2
  t152 = t86 ** 2
  t153 = t88 ** 2
  t157 = 0.1e1 + 0.47713432968905766466106113987849411672377582885579e-2 / t146 / t78 * t149 * t25 * t152 * t153
  t158 = jnp.sqrt(t157)
  t159 = 0.1e1 / t158
  t163 = 0.22248595461286988846134192322402139182939712957292e0 * t136 * t138 * t131 + 0.16835016835016835016835016835016835016835016835017e0 * t144 * t86 * t131 * t159
  t164 = t135 * t163
  t166 = t132 * t97 - t72 * t164
  t171 = f.my_piecewise3(t2, 0, -t6 * t21 * t99 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t103 * t166)
  t180 = t118 ** 2
  t184 = t37 ** 2
  t193 = (0.40e2 / 0.9e1 * t32 * t109 - 0.11e2 / 0.9e1 * t36 / t19 / t184 - 0.10e2 / 0.9e1 * t42 * t109) * t46 * t49
  t194 = 0.39111111111111111111111111111111111111111111111111e0 * t193
  t195 = f.my_piecewise3(t55, 0, -t194)
  t208 = t114 ** 2
  t209 = t46 ** 2
  t212 = 0.1e1 / t26 / t25
  t223 = f.my_piecewise3(t52, -t62 * t180 + t104 * t195 / 0.2e1 + 0.3e1 / 0.2e1 / t121 / t57 * t180 - 0.3e1 / 0.8e1 * t122 * t195, -t194 - 0.75813339338271604938271604938271604938271604938270e-1 / t69 / t68 * t66 * t208 * t209 * t212 + 0.15296790123456790123456790123456790123456790123457e0 * t126 * t208 * t209 * t212 - 0.27534222222222222222222222222222222222222222222222e0 * t127 * t193)
  t230 = t163 ** 2
  t237 = t131 ** 2
  t253 = t146 ** 2
  t255 = t149 ** 2
  t274 = f.my_piecewise3(t2, 0, t6 * t17 * t34 * t99 / 0.12e2 - t6 * t21 * t166 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t103 * (t29 * t223 * t97 - 0.2e1 * t132 * t164 + 0.2e1 * t72 / t134 / t96 * t230 - t72 * t135 * (-0.11124297730643494423067096161201069591469856478646e0 * t136 / t76 / t71 * t92 * t237 + 0.16835016835016835016835016835016835016835016835017e0 * t143 * t137 * t86 * t237 * t159 + 0.22248595461286988846134192322402139182939712957292e0 * t136 * t138 * t223 + 0.16835016835016835016835016835016835016835016835017e0 * t144 * t86 * t223 * t159 - 0.80325644728797586643276286174830659381107041894915e-3 / t253 * t255 * t76 * t152 * t86 * t237 / t158 / t157 * t88)))
  v2rho2_0_ = 0.2e1 * r0 * t274 + 0.4e1 * t171
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = 0.1e1 / t19 / r0
  t22 = t17 * t21
  t23 = 4 ** (0.1e1 / 0.3e1)
  t24 = t3 ** 2
  t26 = jnp.pi ** 2
  t27 = t26 ** (0.1e1 / 0.3e1)
  t29 = t23 * t24 * t27 / 0.9e1
  t30 = 0.1e1 - t29
  t31 = 2 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t33 = tau0 * t32
  t35 = s0 * t32
  t36 = r0 ** 2
  t38 = 0.1e1 / t19 / t36
  t41 = l0 * t32
  t45 = 6 ** (0.1e1 / 0.3e1)
  t47 = t27 ** 2
  t48 = 0.1e1 / t47
  t49 = (t33 * t21 - t35 * t38 / 0.8e1 - t41 * t21 / 0.4e1) * t45 * t48
  t50 = 0.5e1 / 0.9e1 * t49
  t51 = -t50 < -0.14205545454545454545454545454545454545454545454545e5
  t52 = 0.39111111111111111111111111111111111111111111111111e0 * t49
  t54 = 0.0e0 < 0.70414204545454545454545454545454545454545454545455e0 - t52
  t56 = f.my_piecewise3(t54, -0.14204545454545454545454545454545454545454545454545e-3, 0.704e0 - t52)
  t59 = t56 ** 2
  t61 = 0.1e1 / t59 / t56
  t64 = 0.1e1 - t50
  t65 = t64 ** 2
  t67 = 0.1e1 + 0.495616e0 * t65
  t68 = jnp.sqrt(t67)
  t70 = f.my_piecewise3(t51, -0.1e1 / t56 / 0.2e1 + t61 / 0.8e1, 0.704e0 - t52 + t68)
  t71 = t30 * t70
  t73 = t30 / jnp.pi
  t74 = jnp.sqrt(0.30e2)
  t75 = jnp.sqrt(t70)
  t77 = t30 ** 2
  t85 = 0.59400000000000000000000000000000000000000000000000e1 * t77 / t26 - 0.206514e-1
  t87 = t70 - 0.1e1
  t91 = jnp.asinh(0.12611295594149683618527696903038317622317287894258e-1 / t77 / t30 * t26 * jnp.pi * t74 * t85 * t87)
  t95 = 0.1e1 + 0.44497190922573977692268384644804278365879425914585e0 * t73 * t74 * t75 * t91
  t96 = 0.1e1 / t95
  t98 = t71 * t96 + t29
  t103 = t17 / t19
  t104 = 0.1e1 / t59
  t109 = 0.1e1 / t19 / t36 / r0
  t114 = -0.5e1 / 0.3e1 * t33 * t38 + t35 * t109 / 0.3e1 + 0.5e1 / 0.12e2 * t41 * t38
  t116 = t114 * t45 * t48
  t117 = 0.39111111111111111111111111111111111111111111111111e0 * t116
  t118 = f.my_piecewise3(t54, 0, -t117)
  t121 = t59 ** 2
  t122 = 0.1e1 / t121
  t126 = 0.1e1 / t68
  t127 = t126 * t64
  t131 = f.my_piecewise3(t51, t104 * t118 / 0.2e1 - 0.3e1 / 0.8e1 * t122 * t118, -t117 - 0.27534222222222222222222222222222222222222222222222e0 * t127 * t116)
  t132 = t30 * t131
  t134 = t95 ** 2
  t135 = 0.1e1 / t134
  t136 = t73 * t74
  t137 = 0.1e1 / t75
  t138 = t137 * t91
  t143 = 0.1e1 / t77 * t26
  t144 = t143 * t75
  t145 = t85 * t131
  t146 = t77 ** 2
  t147 = t146 * t77
  t149 = t26 ** 2
  t150 = t149 * t26
  t152 = t85 ** 2
  t153 = t87 ** 2
  t157 = 0.1e1 + 0.47713432968905766466106113987849411672377582885579e-2 / t147 * t150 * t152 * t153
  t158 = jnp.sqrt(t157)
  t159 = 0.1e1 / t158
  t163 = 0.22248595461286988846134192322402139182939712957292e0 * t136 * t138 * t131 + 0.16835016835016835016835016835016835016835016835017e0 * t144 * t145 * t159
  t164 = t135 * t163
  t166 = t132 * t96 - t71 * t164
  t170 = t17 * t18
  t171 = t118 ** 2
  t175 = t36 ** 2
  t177 = 0.1e1 / t19 / t175
  t182 = 0.40e2 / 0.9e1 * t33 * t109 - 0.11e2 / 0.9e1 * t35 * t177 - 0.10e2 / 0.9e1 * t41 * t109
  t184 = t182 * t45 * t48
  t185 = 0.39111111111111111111111111111111111111111111111111e0 * t184
  t186 = f.my_piecewise3(t54, 0, -t185)
  t190 = 0.1e1 / t121 / t56
  t197 = 0.1e1 / t68 / t67
  t198 = t197 * t65
  t199 = t114 ** 2
  t200 = t45 ** 2
  t203 = 0.1e1 / t27 / t26
  t208 = t200 * t203
  t214 = f.my_piecewise3(t51, -t61 * t171 + t104 * t186 / 0.2e1 + 0.3e1 / 0.2e1 * t190 * t171 - 0.3e1 / 0.8e1 * t122 * t186, -t185 - 0.75813339338271604938271604938271604938271604938270e-1 * t198 * t199 * t200 * t203 + 0.15296790123456790123456790123456790123456790123457e0 * t126 * t199 * t208 - 0.27534222222222222222222222222222222222222222222222e0 * t127 * t184)
  t215 = t30 * t214
  t220 = 0.1e1 / t134 / t95
  t221 = t163 ** 2
  t222 = t220 * t221
  t226 = 0.1e1 / t75 / t70
  t227 = t226 * t91
  t228 = t131 ** 2
  t232 = t143 * t137
  t244 = t146 ** 2
  t246 = t149 ** 2
  t247 = 0.1e1 / t244 * t246
  t248 = t247 * t75
  t249 = t152 * t85
  t252 = 0.1e1 / t158 / t157
  t253 = t252 * t87
  t257 = -0.11124297730643494423067096161201069591469856478646e0 * t136 * t227 * t228 + 0.16835016835016835016835016835016835016835016835017e0 * t232 * t85 * t228 * t159 + 0.22248595461286988846134192322402139182939712957292e0 * t136 * t138 * t214 + 0.16835016835016835016835016835016835016835016835017e0 * t144 * t85 * t214 * t159 - 0.80325644728797586643276286174830659381107041894915e-3 * t248 * t249 * t228 * t253
  t258 = t135 * t257
  t260 = -0.2e1 * t132 * t164 + t215 * t96 + 0.2e1 * t71 * t222 - t71 * t258
  t265 = f.my_piecewise3(t2, 0, t6 * t22 * t98 / 0.12e2 - t6 * t103 * t166 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t170 * t260)
  t277 = t171 * t118
  t294 = (-0.440e3 / 0.27e2 * t33 * t177 + 0.154e3 / 0.27e2 * t35 / t19 / t175 / r0 + 0.110e3 / 0.27e2 * t41 * t177) * t45 * t48
  t295 = 0.39111111111111111111111111111111111111111111111111e0 * t294
  t296 = f.my_piecewise3(t54, 0, -t295)
  t309 = t67 ** 2
  t316 = t199 * t114 / t149
  t323 = t208 * t182
  t332 = f.my_piecewise3(t51, 0.3e1 * t122 * t277 - 0.3e1 * t61 * t118 * t186 + t104 * t296 / 0.2e1 - 0.15e2 / 0.2e1 / t121 / t59 * t277 + 0.9e1 / 0.2e1 * t190 * t118 * t186 - 0.3e1 / 0.8e1 * t122 * t296, -t295 - 0.37574303989476819753086419753086419753086419753085e0 / t68 / t309 * t65 * t64 * t316 + 0.75813339338271604938271604938271604938271604938270e0 * t197 * t64 * t316 - 0.22744001801481481481481481481481481481481481481481e0 * t198 * t114 * t323 + 0.45890370370370370370370370370370370370370370370371e0 * t126 * t114 * t323 - 0.27534222222222222222222222222222222222222222222222e0 * t127 * t294)
  t341 = t134 ** 2
  t351 = t70 ** 2
  t355 = t228 * t131
  t373 = t249 * t355
  t396 = t152 ** 2
  t399 = t157 ** 2
  t417 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t38 * t98 + t6 * t22 * t166 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t103 * t260 - 0.3e1 / 0.8e1 * t6 * t170 * (t30 * t332 * t96 - 0.3e1 * t215 * t164 + 0.6e1 * t132 * t222 - 0.3e1 * t132 * t258 - 0.6e1 * t71 / t341 * t221 * t163 + 0.6e1 * t71 * t220 * t163 * t257 - t71 * t135 * (0.16686446595965241634600644241801604387204784717969e0 * t136 / t75 / t351 * t91 * t355 - 0.12626262626262626262626262626262626262626262626262e0 * t143 * t226 * t85 * t355 * t159 - 0.33372893191930483269201288483603208774409569435938e0 * t136 * t227 * t131 * t214 + 0.50505050505050505050505050505050505050505050505050e0 * t232 * t145 * t159 * t214 - 0.12048846709319637996491442926224598907166056284237e-2 * t247 * t137 * t373 * t253 + 0.22248595461286988846134192322402139182939712957292e0 * t136 * t138 * t332 + 0.16835016835016835016835016835016835016835016835017e0 * t144 * t85 * t332 * t159 - 0.24097693418639275992982885852449197814332112568474e-2 * t247 * t75 * t249 * t214 * t252 * t87 * t131 + 0.11497836796354867394723500203836174236141391281180e-4 / t244 / t147 * t246 * t150 * t75 * t396 * t85 * t355 / t158 / t399 * t153 - 0.80325644728797586643276286174830659381107041894915e-3 * t248 * t373 * t252)))
  v3rho3_0_ = 0.2e1 * r0 * t417 + 0.6e1 * t265

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t23 = t17 * t22
  t24 = 4 ** (0.1e1 / 0.3e1)
  t25 = t3 ** 2
  t27 = jnp.pi ** 2
  t28 = t27 ** (0.1e1 / 0.3e1)
  t30 = t24 * t25 * t28 / 0.9e1
  t31 = 0.1e1 - t30
  t32 = 2 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t34 = tau0 * t33
  t36 = 0.1e1 / t20 / r0
  t38 = s0 * t33
  t41 = l0 * t33
  t45 = 6 ** (0.1e1 / 0.3e1)
  t47 = t28 ** 2
  t48 = 0.1e1 / t47
  t49 = (t34 * t36 - t38 * t22 / 0.8e1 - t41 * t36 / 0.4e1) * t45 * t48
  t50 = 0.5e1 / 0.9e1 * t49
  t51 = -t50 < -0.14205545454545454545454545454545454545454545454545e5
  t52 = 0.39111111111111111111111111111111111111111111111111e0 * t49
  t54 = 0.0e0 < 0.70414204545454545454545454545454545454545454545455e0 - t52
  t56 = f.my_piecewise3(t54, -0.14204545454545454545454545454545454545454545454545e-3, 0.704e0 - t52)
  t59 = t56 ** 2
  t60 = t59 * t56
  t61 = 0.1e1 / t60
  t64 = 0.1e1 - t50
  t65 = t64 ** 2
  t67 = 0.1e1 + 0.495616e0 * t65
  t68 = jnp.sqrt(t67)
  t70 = f.my_piecewise3(t51, -0.1e1 / t56 / 0.2e1 + t61 / 0.8e1, 0.704e0 - t52 + t68)
  t71 = t31 * t70
  t73 = t31 / jnp.pi
  t74 = jnp.sqrt(0.30e2)
  t75 = jnp.sqrt(t70)
  t77 = t31 ** 2
  t85 = 0.59400000000000000000000000000000000000000000000000e1 * t77 / t27 - 0.206514e-1
  t87 = t70 - 0.1e1
  t91 = jnp.asinh(0.12611295594149683618527696903038317622317287894258e-1 / t77 / t31 * t27 * jnp.pi * t74 * t85 * t87)
  t95 = 0.1e1 + 0.44497190922573977692268384644804278365879425914585e0 * t73 * t74 * t75 * t91
  t96 = 0.1e1 / t95
  t98 = t71 * t96 + t30
  t102 = t17 * t36
  t103 = 0.1e1 / t59
  t108 = 0.1e1 / t20 / t18 / r0
  t113 = -0.5e1 / 0.3e1 * t34 * t22 + t38 * t108 / 0.3e1 + 0.5e1 / 0.12e2 * t41 * t22
  t115 = t113 * t45 * t48
  t116 = 0.39111111111111111111111111111111111111111111111111e0 * t115
  t117 = f.my_piecewise3(t54, 0, -t116)
  t120 = t59 ** 2
  t121 = 0.1e1 / t120
  t125 = 0.1e1 / t68
  t126 = t125 * t64
  t130 = f.my_piecewise3(t51, t103 * t117 / 0.2e1 - 0.3e1 / 0.8e1 * t121 * t117, -t116 - 0.27534222222222222222222222222222222222222222222222e0 * t126 * t115)
  t131 = t31 * t130
  t133 = t95 ** 2
  t134 = 0.1e1 / t133
  t135 = t73 * t74
  t136 = 0.1e1 / t75
  t137 = t136 * t91
  t142 = 0.1e1 / t77 * t27
  t143 = t142 * t75
  t144 = t85 * t130
  t145 = t77 ** 2
  t146 = t145 * t77
  t148 = t27 ** 2
  t149 = t148 * t27
  t151 = t85 ** 2
  t152 = t87 ** 2
  t156 = 0.1e1 + 0.47713432968905766466106113987849411672377582885579e-2 / t146 * t149 * t151 * t152
  t157 = jnp.sqrt(t156)
  t158 = 0.1e1 / t157
  t162 = 0.22248595461286988846134192322402139182939712957292e0 * t135 * t137 * t130 + 0.16835016835016835016835016835016835016835016835017e0 * t143 * t144 * t158
  t163 = t134 * t162
  t165 = t131 * t96 - t71 * t163
  t170 = t17 / t20
  t171 = t117 ** 2
  t175 = t18 ** 2
  t177 = 0.1e1 / t20 / t175
  t182 = 0.40e2 / 0.9e1 * t34 * t108 - 0.11e2 / 0.9e1 * t38 * t177 - 0.10e2 / 0.9e1 * t41 * t108
  t184 = t182 * t45 * t48
  t185 = 0.39111111111111111111111111111111111111111111111111e0 * t184
  t186 = f.my_piecewise3(t54, 0, -t185)
  t190 = 0.1e1 / t120 / t56
  t197 = 0.1e1 / t68 / t67
  t198 = t197 * t65
  t199 = t113 ** 2
  t200 = t45 ** 2
  t203 = 0.1e1 / t28 / t27
  t208 = t200 * t203
  t214 = f.my_piecewise3(t51, -t61 * t171 + t103 * t186 / 0.2e1 + 0.3e1 / 0.2e1 * t190 * t171 - 0.3e1 / 0.8e1 * t121 * t186, -t185 - 0.75813339338271604938271604938271604938271604938270e-1 * t198 * t199 * t200 * t203 + 0.15296790123456790123456790123456790123456790123457e0 * t125 * t199 * t208 - 0.27534222222222222222222222222222222222222222222222e0 * t126 * t184)
  t215 = t31 * t214
  t220 = 0.1e1 / t133 / t95
  t221 = t162 ** 2
  t222 = t220 * t221
  t226 = 0.1e1 / t75 / t70
  t227 = t226 * t91
  t228 = t130 ** 2
  t232 = t142 * t136
  t233 = t85 * t228
  t244 = t145 ** 2
  t246 = t148 ** 2
  t247 = 0.1e1 / t244 * t246
  t248 = t247 * t75
  t249 = t151 * t85
  t252 = 0.1e1 / t157 / t156
  t253 = t252 * t87
  t257 = -0.11124297730643494423067096161201069591469856478646e0 * t135 * t227 * t228 + 0.16835016835016835016835016835016835016835016835017e0 * t232 * t233 * t158 + 0.22248595461286988846134192322402139182939712957292e0 * t135 * t137 * t214 + 0.16835016835016835016835016835016835016835016835017e0 * t143 * t85 * t214 * t158 - 0.80325644728797586643276286174830659381107041894915e-3 * t248 * t249 * t228 * t253
  t258 = t134 * t257
  t260 = -0.2e1 * t131 * t163 + t215 * t96 + 0.2e1 * t71 * t222 - t71 * t258
  t264 = t17 * t19
  t265 = t171 * t117
  t268 = t61 * t117
  t275 = 0.1e1 / t20 / t175 / r0
  t280 = -0.440e3 / 0.27e2 * t34 * t177 + 0.154e3 / 0.27e2 * t38 * t275 + 0.110e3 / 0.27e2 * t41 * t177
  t282 = t280 * t45 * t48
  t283 = 0.39111111111111111111111111111111111111111111111111e0 * t282
  t284 = f.my_piecewise3(t54, 0, -t283)
  t288 = 0.1e1 / t120 / t59
  t291 = t190 * t117
  t297 = t67 ** 2
  t299 = 0.1e1 / t68 / t297
  t301 = t299 * t65 * t64
  t303 = 0.1e1 / t148
  t304 = t199 * t113 * t303
  t307 = t197 * t64
  t310 = t198 * t113
  t311 = t208 * t182
  t314 = t125 * t113
  t320 = f.my_piecewise3(t51, 0.3e1 * t121 * t265 - 0.3e1 * t268 * t186 + t103 * t284 / 0.2e1 - 0.15e2 / 0.2e1 * t288 * t265 + 0.9e1 / 0.2e1 * t291 * t186 - 0.3e1 / 0.8e1 * t121 * t284, -t283 - 0.37574303989476819753086419753086419753086419753085e0 * t301 * t304 + 0.75813339338271604938271604938271604938271604938270e0 * t307 * t304 - 0.22744001801481481481481481481481481481481481481481e0 * t310 * t311 + 0.45890370370370370370370370370370370370370370370371e0 * t314 * t311 - 0.27534222222222222222222222222222222222222222222222e0 * t126 * t282)
  t321 = t31 * t320
  t329 = t133 ** 2
  t330 = 0.1e1 / t329
  t332 = t330 * t221 * t162
  t335 = t220 * t162
  t336 = t335 * t257
  t339 = t70 ** 2
  t341 = 0.1e1 / t75 / t339
  t342 = t341 * t91
  t343 = t228 * t130
  t347 = t142 * t226
  t356 = t158 * t214
  t360 = t247 * t136
  t361 = t249 * t343
  t373 = t247 * t75 * t249
  t375 = t87 * t130
  t382 = 0.1e1 / t244 / t146 * t246 * t149
  t383 = t382 * t75
  t384 = t151 ** 2
  t385 = t384 * t85
  t387 = t156 ** 2
  t389 = 0.1e1 / t157 / t387
  t390 = t389 * t152
  t397 = 0.16686446595965241634600644241801604387204784717969e0 * t135 * t342 * t343 - 0.12626262626262626262626262626262626262626262626262e0 * t347 * t85 * t343 * t158 - 0.33372893191930483269201288483603208774409569435938e0 * t135 * t227 * t130 * t214 + 0.50505050505050505050505050505050505050505050505050e0 * t232 * t144 * t356 - 0.12048846709319637996491442926224598907166056284237e-2 * t360 * t361 * t253 + 0.22248595461286988846134192322402139182939712957292e0 * t135 * t137 * t320 + 0.16835016835016835016835016835016835016835016835017e0 * t143 * t85 * t320 * t158 - 0.24097693418639275992982885852449197814332112568474e-2 * t373 * t214 * t252 * t375 + 0.11497836796354867394723500203836174236141391281180e-4 * t383 * t385 * t343 * t390 - 0.80325644728797586643276286174830659381107041894915e-3 * t248 * t361 * t252
  t398 = t134 * t397
  t400 = 0.6e1 * t131 * t222 - 0.3e1 * t131 * t258 - 0.3e1 * t215 * t163 + t321 * t96 - 0.6e1 * t71 * t332 + 0.6e1 * t71 * t336 - t71 * t398
  t405 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t23 * t98 + t6 * t102 * t165 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t170 * t260 - 0.3e1 / 0.8e1 * t6 * t264 * t400)
  t420 = t171 ** 2
  t426 = t186 ** 2
  t442 = (0.6160e4 / 0.81e2 * t34 * t275 - 0.2618e4 / 0.81e2 * t38 / t20 / t175 / t18 - 0.1540e4 / 0.81e2 * t41 * t275) * t45 * t48
  t443 = 0.39111111111111111111111111111111111111111111111111e0 * t442
  t444 = f.my_piecewise3(t54, 0, -t443)
  t464 = t65 ** 2
  t466 = t199 ** 2
  t469 = t303 * t45 * t48
  t477 = t199 * t303 * t182
  t485 = t182 ** 2
  t490 = t208 * t280
  t500 = -t443 - 0.51728961794579287496515775034293552812071330589847e0 / t68 / t297 / t67 * t464 * t466 * t469 + 0.12524767996492273251028806584362139917695473251028e1 * t299 * t65 * t466 * t469 - 0.22544582393686091851851851851851851851851851851851e1 * t301 * t477 - 0.42118521854595336076817558299039780521262002743483e0 * t197 * t466 * t469 + 0.45488003602962962962962962962962962962962962962962e1 * t307 * t477 - 0.22744001801481481481481481481481481481481481481481e0 * t198 * t485 * t200 * t203 - 0.30325335735308641975308641975308641975308641975308e0 * t310 * t490 + 0.45890370370370370370370370370370370370370370370371e0 * t125 * t485 * t208 + 0.61187160493827160493827160493827160493827160493828e0 * t314 * t490 - 0.27534222222222222222222222222222222222222222222222e0 * t126 * t442
  t501 = f.my_piecewise3(t51, -0.12e2 * t190 * t420 + 0.18e2 * t121 * t171 * t186 - 0.3e1 * t61 * t426 - 0.4e1 * t268 * t284 + t103 * t444 / 0.2e1 + 0.45e2 / t120 / t60 * t420 - 0.45e2 * t288 * t171 * t186 + 0.9e1 / 0.2e1 * t190 * t426 + 0.6e1 * t291 * t284 - 0.3e1 / 0.8e1 * t121 * t444, t500)
  t518 = t221 ** 2
  t526 = t257 ** 2
  t534 = t228 ** 2
  t539 = t244 ** 2
  t542 = t246 ** 2
  t556 = t249 * t534
  t561 = t385 * t534
  t572 = t214 ** 2
  t601 = t228 * t252
  t636 = 0.25252525252525252525252525252525252525252525252524e0 * t142 * t341 * t85 * t534 * t158 - 0.27430063263514809359078385755309594326225327911474e-6 / t539 / t145 * t542 * t148 * t75 * t384 * t249 * t534 / t157 / t387 / t156 * t152 * t87 - 0.16065128945759517328655257234966131876221408378983e-2 * t360 * t556 * t252 + 0.22995673592709734789447000407672348472282782562360e-4 * t382 * t136 * t561 * t390 - 0.75757575757575757575757575757575757575757575757573e0 * t347 * t233 * t356 + 0.12048846709319637996491442926224598907166056284237e-2 * t247 * t226 * t556 * t253 - 0.33372893191930483269201288483603208774409569435938e0 * t135 * t227 * t572 - 0.44497190922573977692268384644804278365879425914584e0 * t135 * t227 * t130 * t320 + 0.50505050505050505050505050505050505050505050505050e0 * t232 * t85 * t572 * t158 + 0.67340067340067340067340067340067340067340067340066e0 * t232 * t144 * t158 * t320 - 0.41716116489913104086501610604504010968011961794922e0 * t135 / t75 / t339 / t70 * t91 * t534 + 0.10011867957579144980760386545080962632322870830781e1 * t135 * t342 * t228 * t214 - 0.72293080255917827978948657557347593442996337705422e-2 * t247 * t136 * t249 * t601 * t214 * t87 - 0.32130257891519034657310514469932263752442816757966e-2 * t373 * t320 * t252 * t375 - 0.48195386837278551985965771704898395628664225136948e-2 * t248 * t249 * t214 * t601 - 0.24097693418639275992982885852449197814332112568474e-2 * t248 * t249 * t572 * t253 + 0.68987020778129204368341001223017045416848347687080e-4 * t382 * t75 * t385 * t214 * t389 * t152 * t228 + 0.34493510389064602184170500611508522708424173843540e-4 * t383 * t561 * t389 * t87 + 0.22248595461286988846134192322402139182939712957292e0 * t135 * t137 * t501 + 0.16835016835016835016835016835016835016835016835017e0 * t143 * t85 * t501 * t158
  t639 = t31 * t501 * t96 - 0.4e1 * t321 * t163 + 0.12e2 * t215 * t222 - 0.6e1 * t215 * t258 - 0.24e2 * t131 * t332 + 0.24e2 * t131 * t336 - 0.4e1 * t131 * t398 + 0.24e2 * t71 / t329 / t95 * t518 - 0.36e2 * t71 * t330 * t221 * t257 + 0.6e1 * t71 * t220 * t526 + 0.8e1 * t71 * t335 * t397 - t71 * t134 * t636
  t644 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t17 * t108 * t98 - 0.5e1 / 0.9e1 * t6 * t23 * t165 + t6 * t102 * t260 / 0.2e1 - t6 * t170 * t400 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t264 * t639)
  v4rho4_0_ = 0.2e1 * r0 * t644 + 0.8e1 * t405

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = 4 ** (0.1e1 / 0.3e1)
  t33 = t2 ** 2
  t35 = jnp.pi ** 2
  t36 = t35 ** (0.1e1 / 0.3e1)
  t38 = t32 * t33 * t36 / 0.9e1
  t39 = 0.1e1 - t38
  t40 = r0 ** (0.1e1 / 0.3e1)
  t41 = t40 ** 2
  t43 = 0.1e1 / t41 / r0
  t45 = r0 ** 2
  t47 = 0.1e1 / t41 / t45
  t53 = 6 ** (0.1e1 / 0.3e1)
  t55 = t36 ** 2
  t56 = 0.1e1 / t55
  t57 = (tau0 * t43 - s0 * t47 / 0.8e1 - l0 * t43 / 0.4e1) * t53 * t56
  t58 = 0.5e1 / 0.9e1 * t57
  t59 = -t58 < -0.14205545454545454545454545454545454545454545454545e5
  t60 = 0.39111111111111111111111111111111111111111111111111e0 * t57
  t62 = 0.0e0 < 0.70414204545454545454545454545454545454545454545455e0 - t60
  t64 = f.my_piecewise3(t62, -0.14204545454545454545454545454545454545454545454545e-3, 0.704e0 - t60)
  t67 = t64 ** 2
  t69 = 0.1e1 / t67 / t64
  t72 = 0.1e1 - t58
  t73 = t72 ** 2
  t75 = 0.1e1 + 0.495616e0 * t73
  t76 = jnp.sqrt(t75)
  t78 = f.my_piecewise3(t59, -0.1e1 / t64 / 0.2e1 + t69 / 0.8e1, 0.704e0 - t60 + t76)
  t79 = t39 * t78
  t81 = t39 / jnp.pi
  t82 = jnp.sqrt(0.30e2)
  t83 = jnp.sqrt(t78)
  t85 = t39 ** 2
  t89 = 0.1e1 / t85 / t39 * t35 * jnp.pi
  t93 = 0.59400000000000000000000000000000000000000000000000e1 * t85 / t35 - 0.206514e-1
  t94 = t82 * t93
  t95 = t78 - 0.1e1
  t99 = jnp.arcsinh(0.12611295594149683618527696903038317622317287894258e-1 * t89 * t94 * t95)
  t103 = 0.1e1 + 0.44497190922573977692268384644804278365879425914585e0 * t81 * t82 * t83 * t99
  t104 = 0.1e1 / t103
  t106 = t79 * t104 + t38
  t110 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t111 = t110 * f.p.zeta_threshold
  t113 = f.my_piecewise3(t20, t111, t21 * t19)
  t114 = t30 ** 2
  t115 = 0.1e1 / t114
  t116 = t113 * t115
  t119 = t5 * t116 * t106 / 0.8e1
  t120 = t113 * t30
  t121 = 0.1e1 / t67
  t126 = 0.1e1 / t41 / t45 / r0
  t131 = -0.5e1 / 0.3e1 * tau0 * t47 + s0 * t126 / 0.3e1 + 0.5e1 / 0.12e2 * l0 * t47
  t133 = t131 * t53 * t56
  t134 = 0.39111111111111111111111111111111111111111111111111e0 * t133
  t135 = f.my_piecewise3(t62, 0, -t134)
  t138 = t67 ** 2
  t139 = 0.1e1 / t138
  t143 = 0.1e1 / t76
  t144 = t143 * t72
  t148 = f.my_piecewise3(t59, t121 * t135 / 0.2e1 - 0.3e1 / 0.8e1 * t139 * t135, -t134 - 0.27534222222222222222222222222222222222222222222222e0 * t144 * t133)
  t149 = t39 * t148
  t151 = t103 ** 2
  t152 = 0.1e1 / t151
  t153 = t81 * t82
  t154 = 0.1e1 / t83
  t155 = t154 * t99
  t160 = 0.1e1 / t85 * t35
  t161 = t160 * t83
  t163 = t85 ** 2
  t166 = t35 ** 2
  t168 = 0.1e1 / t163 / t85 * t166 * t35
  t169 = t93 ** 2
  t170 = t95 ** 2
  t174 = 0.1e1 + 0.47713432968905766466106113987849411672377582885579e-2 * t168 * t169 * t170
  t175 = jnp.sqrt(t174)
  t176 = 0.1e1 / t175
  t180 = 0.22248595461286988846134192322402139182939712957292e0 * t153 * t155 * t148 + 0.16835016835016835016835016835016835016835016835017e0 * t161 * t93 * t148 * t176
  t181 = t152 * t180
  t183 = t149 * t104 - t79 * t181
  t188 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t106 - t119 - 0.3e1 / 0.8e1 * t5 * t120 * t183)
  t190 = r1 <= f.p.dens_threshold
  t191 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t192 = 0.1e1 + t191
  t193 = t192 <= f.p.zeta_threshold
  t194 = t192 ** (0.1e1 / 0.3e1)
  t196 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t199 = f.my_piecewise3(t193, 0, 0.4e1 / 0.3e1 * t194 * t196)
  t200 = t199 * t30
  t201 = r1 ** (0.1e1 / 0.3e1)
  t202 = t201 ** 2
  t204 = 0.1e1 / t202 / r1
  t206 = r1 ** 2
  t208 = 0.1e1 / t202 / t206
  t215 = (tau1 * t204 - s2 * t208 / 0.8e1 - l1 * t204 / 0.4e1) * t53 * t56
  t216 = 0.5e1 / 0.9e1 * t215
  t217 = -t216 < -0.14205545454545454545454545454545454545454545454545e5
  t218 = 0.39111111111111111111111111111111111111111111111111e0 * t215
  t220 = 0.0e0 < 0.70414204545454545454545454545454545454545454545455e0 - t218
  t222 = f.my_piecewise3(t220, -0.14204545454545454545454545454545454545454545454545e-3, 0.704e0 - t218)
  t225 = t222 ** 2
  t227 = 0.1e1 / t225 / t222
  t230 = 0.1e1 - t216
  t231 = t230 ** 2
  t233 = 0.1e1 + 0.495616e0 * t231
  t234 = jnp.sqrt(t233)
  t236 = f.my_piecewise3(t217, -0.1e1 / t222 / 0.2e1 + t227 / 0.8e1, 0.704e0 - t218 + t234)
  t237 = t39 * t236
  t238 = jnp.sqrt(t236)
  t240 = t236 - 0.1e1
  t244 = jnp.arcsinh(0.12611295594149683618527696903038317622317287894258e-1 * t89 * t94 * t240)
  t248 = 0.1e1 + 0.44497190922573977692268384644804278365879425914585e0 * t81 * t82 * t238 * t244
  t249 = 0.1e1 / t248
  t251 = t237 * t249 + t38
  t256 = f.my_piecewise3(t193, t111, t194 * t192)
  t257 = t256 * t115
  t260 = t5 * t257 * t251 / 0.8e1
  t262 = f.my_piecewise3(t190, 0, -0.3e1 / 0.8e1 * t5 * t200 * t251 - t260)
  t264 = t21 ** 2
  t265 = 0.1e1 / t264
  t266 = t26 ** 2
  t271 = t16 / t22 / t6
  t273 = -0.2e1 * t23 + 0.2e1 * t271
  t274 = f.my_piecewise5(t10, 0, t14, 0, t273)
  t278 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t265 * t266 + 0.4e1 / 0.3e1 * t21 * t274)
  t285 = t5 * t29 * t115 * t106
  t291 = 0.1e1 / t114 / t6
  t295 = t5 * t113 * t291 * t106 / 0.12e2
  t297 = t5 * t116 * t183
  t299 = t135 ** 2
  t303 = t45 ** 2
  t312 = (0.40e2 / 0.9e1 * tau0 * t126 - 0.11e2 / 0.9e1 * s0 / t41 / t303 - 0.10e2 / 0.9e1 * l0 * t126) * t53 * t56
  t313 = 0.39111111111111111111111111111111111111111111111111e0 * t312
  t314 = f.my_piecewise3(t62, 0, -t313)
  t327 = t131 ** 2
  t328 = t53 ** 2
  t331 = 0.1e1 / t36 / t35
  t336 = t328 * t331
  t342 = f.my_piecewise3(t59, -t69 * t299 + t121 * t314 / 0.2e1 + 0.3e1 / 0.2e1 / t138 / t64 * t299 - 0.3e1 / 0.8e1 * t139 * t314, -t313 - 0.75813339338271604938271604938271604938271604938270e-1 / t76 / t75 * t73 * t327 * t328 * t331 + 0.15296790123456790123456790123456790123456790123457e0 * t143 * t327 * t336 - 0.27534222222222222222222222222222222222222222222222e0 * t144 * t312)
  t349 = t180 ** 2
  t356 = t148 ** 2
  t372 = t163 ** 2
  t374 = t166 ** 2
  t375 = 0.1e1 / t372 * t374
  t377 = t169 * t93
  t393 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t278 * t30 * t106 - t285 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t183 + t295 - t297 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t120 * (t39 * t342 * t104 - 0.2e1 * t149 * t181 + 0.2e1 * t79 / t151 / t103 * t349 - t79 * t152 * (-0.11124297730643494423067096161201069591469856478646e0 * t153 / t83 / t78 * t99 * t356 + 0.16835016835016835016835016835016835016835016835017e0 * t160 * t154 * t93 * t356 * t176 + 0.22248595461286988846134192322402139182939712957292e0 * t153 * t155 * t342 + 0.16835016835016835016835016835016835016835016835017e0 * t161 * t93 * t342 * t176 - 0.80325644728797586643276286174830659381107041894915e-3 * t375 * t83 * t377 * t356 / t175 / t174 * t95)))
  t394 = t194 ** 2
  t395 = 0.1e1 / t394
  t396 = t196 ** 2
  t400 = f.my_piecewise5(t14, 0, t10, 0, -t273)
  t404 = f.my_piecewise3(t193, 0, 0.4e1 / 0.9e1 * t395 * t396 + 0.4e1 / 0.3e1 * t194 * t400)
  t411 = t5 * t199 * t115 * t251
  t416 = t5 * t256 * t291 * t251 / 0.12e2
  t418 = f.my_piecewise3(t190, 0, -0.3e1 / 0.8e1 * t5 * t404 * t30 * t251 - t411 / 0.4e1 + t416)
  d11 = 0.2e1 * t188 + 0.2e1 * t262 + t6 * (t393 + t418)
  t421 = -t7 - t24
  t422 = f.my_piecewise5(t10, 0, t14, 0, t421)
  t425 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t422)
  t426 = t425 * t30
  t431 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t426 * t106 - t119)
  t433 = f.my_piecewise5(t14, 0, t10, 0, -t421)
  t436 = f.my_piecewise3(t193, 0, 0.4e1 / 0.3e1 * t194 * t433)
  t437 = t436 * t30
  t441 = t256 * t30
  t442 = 0.1e1 / t225
  t447 = 0.1e1 / t202 / t206 / r1
  t452 = -0.5e1 / 0.3e1 * tau1 * t208 + s2 * t447 / 0.3e1 + 0.5e1 / 0.12e2 * l1 * t208
  t454 = t452 * t53 * t56
  t455 = 0.39111111111111111111111111111111111111111111111111e0 * t454
  t456 = f.my_piecewise3(t220, 0, -t455)
  t459 = t225 ** 2
  t460 = 0.1e1 / t459
  t464 = 0.1e1 / t234
  t465 = t464 * t230
  t469 = f.my_piecewise3(t217, t442 * t456 / 0.2e1 - 0.3e1 / 0.8e1 * t460 * t456, -t455 - 0.27534222222222222222222222222222222222222222222222e0 * t465 * t454)
  t470 = t39 * t469
  t472 = t248 ** 2
  t473 = 0.1e1 / t472
  t474 = 0.1e1 / t238
  t475 = t474 * t244
  t479 = t160 * t238
  t481 = t240 ** 2
  t485 = 0.1e1 + 0.47713432968905766466106113987849411672377582885579e-2 * t168 * t169 * t481
  t486 = jnp.sqrt(t485)
  t487 = 0.1e1 / t486
  t491 = 0.22248595461286988846134192322402139182939712957292e0 * t153 * t475 * t469 + 0.16835016835016835016835016835016835016835016835017e0 * t479 * t93 * t469 * t487
  t492 = t473 * t491
  t494 = -t237 * t492 + t470 * t249
  t499 = f.my_piecewise3(t190, 0, -0.3e1 / 0.8e1 * t5 * t437 * t251 - t260 - 0.3e1 / 0.8e1 * t5 * t441 * t494)
  t503 = 0.2e1 * t271
  t504 = f.my_piecewise5(t10, 0, t14, 0, t503)
  t508 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t265 * t422 * t26 + 0.4e1 / 0.3e1 * t21 * t504)
  t515 = t5 * t425 * t115 * t106
  t523 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t508 * t30 * t106 - t515 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t426 * t183 - t285 / 0.8e1 + t295 - t297 / 0.8e1)
  t527 = f.my_piecewise5(t14, 0, t10, 0, -t503)
  t531 = f.my_piecewise3(t193, 0, 0.4e1 / 0.9e1 * t395 * t433 * t196 + 0.4e1 / 0.3e1 * t194 * t527)
  t538 = t5 * t436 * t115 * t251
  t545 = t5 * t257 * t494
  t548 = f.my_piecewise3(t190, 0, -0.3e1 / 0.8e1 * t5 * t531 * t30 * t251 - t538 / 0.8e1 - t411 / 0.8e1 + t416 - 0.3e1 / 0.8e1 * t5 * t200 * t494 - t545 / 0.8e1)
  d12 = t188 + t262 + t431 + t499 + t6 * (t523 + t548)
  t553 = t422 ** 2
  t557 = 0.2e1 * t23 + 0.2e1 * t271
  t558 = f.my_piecewise5(t10, 0, t14, 0, t557)
  t562 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t265 * t553 + 0.4e1 / 0.3e1 * t21 * t558)
  t569 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t562 * t30 * t106 - t515 / 0.4e1 + t295)
  t570 = t433 ** 2
  t574 = f.my_piecewise5(t14, 0, t10, 0, -t557)
  t578 = f.my_piecewise3(t193, 0, 0.4e1 / 0.9e1 * t395 * t570 + 0.4e1 / 0.3e1 * t194 * t574)
  t588 = t456 ** 2
  t592 = t206 ** 2
  t601 = (0.40e2 / 0.9e1 * tau1 * t447 - 0.11e2 / 0.9e1 * s2 / t202 / t592 - 0.10e2 / 0.9e1 * l1 * t447) * t53 * t56
  t602 = 0.39111111111111111111111111111111111111111111111111e0 * t601
  t603 = f.my_piecewise3(t220, 0, -t602)
  t616 = t452 ** 2
  t627 = f.my_piecewise3(t217, -t227 * t588 + t442 * t603 / 0.2e1 + 0.3e1 / 0.2e1 / t459 / t222 * t588 - 0.3e1 / 0.8e1 * t460 * t603, -t602 - 0.75813339338271604938271604938271604938271604938270e-1 / t234 / t233 * t231 * t616 * t328 * t331 + 0.15296790123456790123456790123456790123456790123457e0 * t464 * t616 * t336 - 0.27534222222222222222222222222222222222222222222222e0 * t465 * t601)
  t634 = t491 ** 2
  t641 = t469 ** 2
  t673 = f.my_piecewise3(t190, 0, -0.3e1 / 0.8e1 * t5 * t578 * t30 * t251 - t538 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t437 * t494 + t416 - t545 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t441 * (t39 * t627 * t249 - 0.2e1 * t470 * t492 + 0.2e1 * t237 / t472 / t248 * t634 - t237 * t473 * (-0.11124297730643494423067096161201069591469856478646e0 * t153 / t238 / t236 * t244 * t641 + 0.16835016835016835016835016835016835016835016835017e0 * t160 * t474 * t93 * t641 * t487 + 0.22248595461286988846134192322402139182939712957292e0 * t153 * t475 * t627 + 0.16835016835016835016835016835016835016835016835017e0 * t479 * t93 * t627 * t487 - 0.80325644728797586643276286174830659381107041894915e-3 * t375 * t238 * t377 * t641 / t486 / t485 * t240)))
  d22 = 0.2e1 * t431 + 0.2e1 * t499 + t6 * (t569 + t673)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 4 ** (0.1e1 / 0.3e1)
  t45 = t2 ** 2
  t47 = jnp.pi ** 2
  t48 = t47 ** (0.1e1 / 0.3e1)
  t50 = t44 * t45 * t48 / 0.9e1
  t51 = 0.1e1 - t50
  t52 = r0 ** (0.1e1 / 0.3e1)
  t53 = t52 ** 2
  t55 = 0.1e1 / t53 / r0
  t57 = r0 ** 2
  t59 = 0.1e1 / t53 / t57
  t65 = 6 ** (0.1e1 / 0.3e1)
  t67 = t48 ** 2
  t68 = 0.1e1 / t67
  t69 = (tau0 * t55 - s0 * t59 / 0.8e1 - l0 * t55 / 0.4e1) * t65 * t68
  t70 = 0.5e1 / 0.9e1 * t69
  t71 = -t70 < -0.14205545454545454545454545454545454545454545454545e5
  t72 = 0.39111111111111111111111111111111111111111111111111e0 * t69
  t74 = 0.0e0 < 0.70414204545454545454545454545454545454545454545455e0 - t72
  t76 = f.my_piecewise3(t74, -0.14204545454545454545454545454545454545454545454545e-3, 0.704e0 - t72)
  t79 = t76 ** 2
  t81 = 0.1e1 / t79 / t76
  t84 = 0.1e1 - t70
  t85 = t84 ** 2
  t87 = 0.1e1 + 0.495616e0 * t85
  t88 = jnp.sqrt(t87)
  t90 = f.my_piecewise3(t71, -0.1e1 / t76 / 0.2e1 + t81 / 0.8e1, 0.704e0 - t72 + t88)
  t91 = t51 * t90
  t93 = t51 / jnp.pi
  t94 = jnp.sqrt(0.30e2)
  t95 = jnp.sqrt(t90)
  t97 = t51 ** 2
  t101 = 0.1e1 / t97 / t51 * t47 * jnp.pi
  t105 = 0.59400000000000000000000000000000000000000000000000e1 * t97 / t47 - 0.206514e-1
  t106 = t94 * t105
  t107 = t90 - 0.1e1
  t111 = jnp.asinh(0.12611295594149683618527696903038317622317287894258e-1 * t101 * t106 * t107)
  t115 = 0.1e1 + 0.44497190922573977692268384644804278365879425914585e0 * t93 * t94 * t95 * t111
  t116 = 0.1e1 / t115
  t118 = t91 * t116 + t50
  t124 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t125 = t42 ** 2
  t126 = 0.1e1 / t125
  t127 = t124 * t126
  t131 = t124 * t42
  t132 = 0.1e1 / t79
  t137 = 0.1e1 / t53 / t57 / r0
  t142 = -0.5e1 / 0.3e1 * tau0 * t59 + s0 * t137 / 0.3e1 + 0.5e1 / 0.12e2 * l0 * t59
  t144 = t142 * t65 * t68
  t145 = 0.39111111111111111111111111111111111111111111111111e0 * t144
  t146 = f.my_piecewise3(t74, 0, -t145)
  t149 = t79 ** 2
  t150 = 0.1e1 / t149
  t154 = 0.1e1 / t88
  t155 = t154 * t84
  t159 = f.my_piecewise3(t71, t132 * t146 / 0.2e1 - 0.3e1 / 0.8e1 * t150 * t146, -t145 - 0.27534222222222222222222222222222222222222222222222e0 * t155 * t144)
  t160 = t51 * t159
  t162 = t115 ** 2
  t163 = 0.1e1 / t162
  t164 = t93 * t94
  t165 = 0.1e1 / t95
  t166 = t165 * t111
  t171 = 0.1e1 / t97 * t47
  t172 = t171 * t95
  t173 = t105 * t159
  t174 = t97 ** 2
  t175 = t174 * t97
  t177 = t47 ** 2
  t178 = t177 * t47
  t180 = t105 ** 2
  t181 = t107 ** 2
  t185 = 0.1e1 + 0.47713432968905766466106113987849411672377582885579e-2 / t175 * t178 * t180 * t181
  t186 = jnp.sqrt(t185)
  t187 = 0.1e1 / t186
  t191 = 0.22248595461286988846134192322402139182939712957292e0 * t164 * t166 * t159 + 0.16835016835016835016835016835016835016835016835017e0 * t172 * t173 * t187
  t192 = t163 * t191
  t194 = t160 * t116 - t91 * t192
  t198 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t199 = t198 * f.p.zeta_threshold
  t201 = f.my_piecewise3(t20, t199, t21 * t19)
  t203 = 0.1e1 / t125 / t6
  t204 = t201 * t203
  t208 = t201 * t126
  t212 = t201 * t42
  t213 = t146 ** 2
  t217 = t57 ** 2
  t219 = 0.1e1 / t53 / t217
  t224 = 0.40e2 / 0.9e1 * tau0 * t137 - 0.11e2 / 0.9e1 * s0 * t219 - 0.10e2 / 0.9e1 * l0 * t137
  t226 = t224 * t65 * t68
  t227 = 0.39111111111111111111111111111111111111111111111111e0 * t226
  t228 = f.my_piecewise3(t74, 0, -t227)
  t232 = 0.1e1 / t149 / t76
  t239 = 0.1e1 / t88 / t87
  t240 = t239 * t85
  t241 = t142 ** 2
  t242 = t65 ** 2
  t245 = 0.1e1 / t48 / t47
  t250 = t242 * t245
  t256 = f.my_piecewise3(t71, -t81 * t213 + t132 * t228 / 0.2e1 + 0.3e1 / 0.2e1 * t232 * t213 - 0.3e1 / 0.8e1 * t150 * t228, -t227 - 0.75813339338271604938271604938271604938271604938270e-1 * t240 * t241 * t242 * t245 + 0.15296790123456790123456790123456790123456790123457e0 * t154 * t241 * t250 - 0.27534222222222222222222222222222222222222222222222e0 * t155 * t226)
  t257 = t51 * t256
  t262 = 0.1e1 / t162 / t115
  t263 = t191 ** 2
  t264 = t262 * t263
  t268 = 0.1e1 / t95 / t90
  t269 = t268 * t111
  t270 = t159 ** 2
  t274 = t171 * t165
  t286 = t174 ** 2
  t288 = t177 ** 2
  t289 = 0.1e1 / t286 * t288
  t290 = t289 * t95
  t291 = t180 * t105
  t294 = 0.1e1 / t186 / t185
  t295 = t294 * t107
  t299 = -0.11124297730643494423067096161201069591469856478646e0 * t164 * t269 * t270 + 0.16835016835016835016835016835016835016835016835017e0 * t274 * t105 * t270 * t187 + 0.22248595461286988846134192322402139182939712957292e0 * t164 * t166 * t256 + 0.16835016835016835016835016835016835016835016835017e0 * t172 * t105 * t256 * t187 - 0.80325644728797586643276286174830659381107041894915e-3 * t290 * t291 * t270 * t295
  t300 = t163 * t299
  t302 = t257 * t116 - 0.2e1 * t160 * t192 + 0.2e1 * t91 * t264 - t91 * t300
  t307 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t118 - t5 * t127 * t118 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t131 * t194 + t5 * t204 * t118 / 0.12e2 - t5 * t208 * t194 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t212 * t302)
  t309 = r1 <= f.p.dens_threshold
  t310 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t311 = 0.1e1 + t310
  t312 = t311 <= f.p.zeta_threshold
  t313 = t311 ** (0.1e1 / 0.3e1)
  t314 = t313 ** 2
  t315 = 0.1e1 / t314
  t317 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t318 = t317 ** 2
  t322 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t326 = f.my_piecewise3(t312, 0, 0.4e1 / 0.9e1 * t315 * t318 + 0.4e1 / 0.3e1 * t313 * t322)
  t328 = r1 ** (0.1e1 / 0.3e1)
  t329 = t328 ** 2
  t331 = 0.1e1 / t329 / r1
  t333 = r1 ** 2
  t342 = (tau1 * t331 - s2 / t329 / t333 / 0.8e1 - l1 * t331 / 0.4e1) * t65 * t68
  t343 = 0.5e1 / 0.9e1 * t342
  t345 = 0.39111111111111111111111111111111111111111111111111e0 * t342
  t349 = f.my_piecewise3(0.0e0 < 0.70414204545454545454545454545454545454545454545455e0 - t345, -0.14204545454545454545454545454545454545454545454545e-3, 0.704e0 - t345)
  t352 = t349 ** 2
  t358 = (0.1e1 - t343) ** 2
  t361 = jnp.sqrt(0.1e1 + 0.495616e0 * t358)
  t363 = f.my_piecewise3(-t343 < -0.14205545454545454545454545454545454545454545454545e5, -0.1e1 / t349 / 0.2e1 + 0.1e1 / t352 / t349 / 0.8e1, 0.704e0 - t345 + t361)
  t365 = jnp.sqrt(t363)
  t371 = jnp.asinh(0.12611295594149683618527696903038317622317287894258e-1 * t101 * t106 * (t363 - 0.1e1))
  t378 = t50 + t51 * t363 / (0.1e1 + 0.44497190922573977692268384644804278365879425914585e0 * t93 * t94 * t365 * t371)
  t384 = f.my_piecewise3(t312, 0, 0.4e1 / 0.3e1 * t313 * t317)
  t390 = f.my_piecewise3(t312, t199, t313 * t311)
  t396 = f.my_piecewise3(t309, 0, -0.3e1 / 0.8e1 * t5 * t326 * t42 * t378 - t5 * t384 * t126 * t378 / 0.4e1 + t5 * t390 * t203 * t378 / 0.12e2)
  t406 = t24 ** 2
  t410 = 0.6e1 * t33 - 0.6e1 * t16 / t406
  t411 = f.my_piecewise5(t10, 0, t14, 0, t410)
  t415 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t411)
  t438 = 0.1e1 / t125 / t24
  t449 = t213 * t146
  t466 = (-0.440e3 / 0.27e2 * tau0 * t219 + 0.154e3 / 0.27e2 * s0 / t53 / t217 / r0 + 0.110e3 / 0.27e2 * l0 * t219) * t65 * t68
  t467 = 0.39111111111111111111111111111111111111111111111111e0 * t466
  t468 = f.my_piecewise3(t74, 0, -t467)
  t481 = t87 ** 2
  t488 = t241 * t142 / t177
  t495 = t250 * t224
  t504 = f.my_piecewise3(t71, 0.3e1 * t150 * t449 - 0.3e1 * t81 * t146 * t228 + t132 * t468 / 0.2e1 - 0.15e2 / 0.2e1 / t149 / t79 * t449 + 0.9e1 / 0.2e1 * t232 * t146 * t228 - 0.3e1 / 0.8e1 * t150 * t468, -t467 - 0.37574303989476819753086419753086419753086419753085e0 / t88 / t481 * t85 * t84 * t488 + 0.75813339338271604938271604938271604938271604938270e0 * t239 * t84 * t488 - 0.22744001801481481481481481481481481481481481481481e0 * t240 * t142 * t495 + 0.45890370370370370370370370370370370370370370370371e0 * t154 * t142 * t495 - 0.27534222222222222222222222222222222222222222222222e0 * t155 * t466)
  t513 = t162 ** 2
  t523 = t90 ** 2
  t527 = t270 * t159
  t545 = t291 * t527
  t568 = t180 ** 2
  t571 = t185 ** 2
  t589 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t415 * t42 * t118 - 0.3e1 / 0.8e1 * t5 * t41 * t126 * t118 - 0.9e1 / 0.8e1 * t5 * t43 * t194 + t5 * t124 * t203 * t118 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t127 * t194 - 0.9e1 / 0.8e1 * t5 * t131 * t302 - 0.5e1 / 0.36e2 * t5 * t201 * t438 * t118 + t5 * t204 * t194 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t208 * t302 - 0.3e1 / 0.8e1 * t5 * t212 * (t51 * t504 * t116 - 0.3e1 * t257 * t192 + 0.6e1 * t160 * t264 - 0.3e1 * t160 * t300 - 0.6e1 * t91 / t513 * t263 * t191 + 0.6e1 * t91 * t262 * t191 * t299 - t91 * t163 * (0.16686446595965241634600644241801604387204784717969e0 * t164 / t95 / t523 * t111 * t527 - 0.12626262626262626262626262626262626262626262626262e0 * t171 * t268 * t105 * t527 * t187 - 0.33372893191930483269201288483603208774409569435938e0 * t164 * t269 * t159 * t256 + 0.50505050505050505050505050505050505050505050505050e0 * t274 * t173 * t187 * t256 - 0.12048846709319637996491442926224598907166056284237e-2 * t289 * t165 * t545 * t295 + 0.22248595461286988846134192322402139182939712957292e0 * t164 * t166 * t504 + 0.16835016835016835016835016835016835016835016835017e0 * t172 * t105 * t504 * t187 - 0.24097693418639275992982885852449197814332112568474e-2 * t289 * t95 * t291 * t256 * t294 * t107 * t159 + 0.11497836796354867394723500203836174236141391281180e-4 / t286 / t175 * t288 * t178 * t95 * t568 * t105 * t527 / t186 / t571 * t181 - 0.80325644728797586643276286174830659381107041894915e-3 * t290 * t545 * t294)))
  t599 = f.my_piecewise5(t14, 0, t10, 0, -t410)
  t603 = f.my_piecewise3(t312, 0, -0.8e1 / 0.27e2 / t314 / t311 * t318 * t317 + 0.4e1 / 0.3e1 * t315 * t317 * t322 + 0.4e1 / 0.3e1 * t313 * t599)
  t621 = f.my_piecewise3(t309, 0, -0.3e1 / 0.8e1 * t5 * t603 * t42 * t378 - 0.3e1 / 0.8e1 * t5 * t326 * t126 * t378 + t5 * t384 * t203 * t378 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t390 * t438 * t378)
  d111 = 0.3e1 * t307 + 0.3e1 * t396 + t6 * (t589 + t621)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 0.1e1 / t22 / t19
  t25 = t6 ** 2
  t26 = 0.1e1 / t25
  t28 = -t16 * t26 + t7
  t29 = f.my_piecewise5(t10, 0, t14, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t6
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t16 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t10, 0, t14, 0, t40)
  t44 = t25 ** 2
  t45 = 0.1e1 / t44
  t48 = -0.6e1 * t16 * t45 + 0.6e1 * t37
  t49 = f.my_piecewise5(t10, 0, t14, 0, t48)
  t53 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t24 * t30 * t29 + 0.4e1 / 0.3e1 * t35 * t41 + 0.4e1 / 0.3e1 * t21 * t49)
  t54 = t6 ** (0.1e1 / 0.3e1)
  t55 = t53 * t54
  t56 = 4 ** (0.1e1 / 0.3e1)
  t57 = t2 ** 2
  t59 = jnp.pi ** 2
  t60 = t59 ** (0.1e1 / 0.3e1)
  t62 = t56 * t57 * t60 / 0.9e1
  t63 = 0.1e1 - t62
  t64 = r0 ** (0.1e1 / 0.3e1)
  t65 = t64 ** 2
  t67 = 0.1e1 / t65 / r0
  t69 = r0 ** 2
  t71 = 0.1e1 / t65 / t69
  t77 = 6 ** (0.1e1 / 0.3e1)
  t79 = t60 ** 2
  t80 = 0.1e1 / t79
  t81 = (tau0 * t67 - s0 * t71 / 0.8e1 - l0 * t67 / 0.4e1) * t77 * t80
  t82 = 0.5e1 / 0.9e1 * t81
  t83 = -t82 < -0.14205545454545454545454545454545454545454545454545e5
  t84 = 0.39111111111111111111111111111111111111111111111111e0 * t81
  t86 = 0.0e0 < 0.70414204545454545454545454545454545454545454545455e0 - t84
  t88 = f.my_piecewise3(t86, -0.14204545454545454545454545454545454545454545454545e-3, 0.704e0 - t84)
  t91 = t88 ** 2
  t92 = t91 * t88
  t93 = 0.1e1 / t92
  t96 = 0.1e1 - t82
  t97 = t96 ** 2
  t99 = 0.1e1 + 0.495616e0 * t97
  t100 = jnp.sqrt(t99)
  t102 = f.my_piecewise3(t83, -0.1e1 / t88 / 0.2e1 + t93 / 0.8e1, 0.704e0 - t84 + t100)
  t103 = t63 * t102
  t105 = t63 / jnp.pi
  t106 = jnp.sqrt(0.30e2)
  t107 = jnp.sqrt(t102)
  t109 = t63 ** 2
  t113 = 0.1e1 / t109 / t63 * t59 * jnp.pi
  t117 = 0.59400000000000000000000000000000000000000000000000e1 * t109 / t59 - 0.206514e-1
  t118 = t106 * t117
  t119 = t102 - 0.1e1
  t123 = jnp.asinh(0.12611295594149683618527696903038317622317287894258e-1 * t113 * t118 * t119)
  t127 = 0.1e1 + 0.44497190922573977692268384644804278365879425914585e0 * t105 * t106 * t107 * t123
  t128 = 0.1e1 / t127
  t130 = t103 * t128 + t62
  t139 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t34 * t30 + 0.4e1 / 0.3e1 * t21 * t41)
  t140 = t54 ** 2
  t141 = 0.1e1 / t140
  t142 = t139 * t141
  t146 = t139 * t54
  t147 = 0.1e1 / t91
  t152 = 0.1e1 / t65 / t69 / r0
  t157 = -0.5e1 / 0.3e1 * tau0 * t71 + s0 * t152 / 0.3e1 + 0.5e1 / 0.12e2 * l0 * t71
  t159 = t157 * t77 * t80
  t160 = 0.39111111111111111111111111111111111111111111111111e0 * t159
  t161 = f.my_piecewise3(t86, 0, -t160)
  t164 = t91 ** 2
  t165 = 0.1e1 / t164
  t169 = 0.1e1 / t100
  t170 = t169 * t96
  t174 = f.my_piecewise3(t83, t147 * t161 / 0.2e1 - 0.3e1 / 0.8e1 * t165 * t161, -t160 - 0.27534222222222222222222222222222222222222222222222e0 * t170 * t159)
  t175 = t63 * t174
  t177 = t127 ** 2
  t178 = 0.1e1 / t177
  t179 = t105 * t106
  t180 = 0.1e1 / t107
  t181 = t180 * t123
  t186 = 0.1e1 / t109 * t59
  t187 = t186 * t107
  t188 = t117 * t174
  t189 = t109 ** 2
  t190 = t189 * t109
  t192 = t59 ** 2
  t193 = t192 * t59
  t195 = t117 ** 2
  t196 = t119 ** 2
  t200 = 0.1e1 + 0.47713432968905766466106113987849411672377582885579e-2 / t190 * t193 * t195 * t196
  t201 = jnp.sqrt(t200)
  t202 = 0.1e1 / t201
  t206 = 0.22248595461286988846134192322402139182939712957292e0 * t179 * t181 * t174 + 0.16835016835016835016835016835016835016835016835017e0 * t187 * t188 * t202
  t207 = t178 * t206
  t209 = -t103 * t207 + t175 * t128
  t215 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t29)
  t217 = 0.1e1 / t140 / t6
  t218 = t215 * t217
  t222 = t215 * t141
  t226 = t215 * t54
  t227 = t161 ** 2
  t231 = t69 ** 2
  t233 = 0.1e1 / t65 / t231
  t238 = 0.40e2 / 0.9e1 * tau0 * t152 - 0.11e2 / 0.9e1 * s0 * t233 - 0.10e2 / 0.9e1 * l0 * t152
  t240 = t238 * t77 * t80
  t241 = 0.39111111111111111111111111111111111111111111111111e0 * t240
  t242 = f.my_piecewise3(t86, 0, -t241)
  t246 = 0.1e1 / t164 / t88
  t253 = 0.1e1 / t100 / t99
  t254 = t253 * t97
  t255 = t157 ** 2
  t256 = t77 ** 2
  t259 = 0.1e1 / t60 / t59
  t264 = t256 * t259
  t270 = f.my_piecewise3(t83, -t93 * t227 + t147 * t242 / 0.2e1 + 0.3e1 / 0.2e1 * t246 * t227 - 0.3e1 / 0.8e1 * t165 * t242, -t241 - 0.75813339338271604938271604938271604938271604938270e-1 * t254 * t255 * t256 * t259 + 0.15296790123456790123456790123456790123456790123457e0 * t169 * t255 * t264 - 0.27534222222222222222222222222222222222222222222222e0 * t170 * t240)
  t271 = t63 * t270
  t276 = 0.1e1 / t177 / t127
  t277 = t206 ** 2
  t278 = t276 * t277
  t282 = 0.1e1 / t107 / t102
  t283 = t282 * t123
  t284 = t174 ** 2
  t288 = t186 * t180
  t289 = t117 * t284
  t300 = t189 ** 2
  t302 = t192 ** 2
  t303 = 0.1e1 / t300 * t302
  t304 = t303 * t107
  t305 = t195 * t117
  t308 = 0.1e1 / t201 / t200
  t309 = t308 * t119
  t313 = -0.11124297730643494423067096161201069591469856478646e0 * t179 * t283 * t284 + 0.16835016835016835016835016835016835016835016835017e0 * t288 * t289 * t202 + 0.22248595461286988846134192322402139182939712957292e0 * t179 * t181 * t270 + 0.16835016835016835016835016835016835016835016835017e0 * t187 * t117 * t270 * t202 - 0.80325644728797586643276286174830659381107041894915e-3 * t304 * t305 * t284 * t309
  t314 = t178 * t313
  t316 = 0.2e1 * t103 * t278 - t103 * t314 + t271 * t128 - 0.2e1 * t175 * t207
  t320 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t321 = t320 * f.p.zeta_threshold
  t323 = f.my_piecewise3(t20, t321, t21 * t19)
  t325 = 0.1e1 / t140 / t25
  t326 = t323 * t325
  t330 = t323 * t217
  t334 = t323 * t141
  t338 = t323 * t54
  t339 = t227 * t161
  t342 = t93 * t161
  t349 = 0.1e1 / t65 / t231 / r0
  t354 = -0.440e3 / 0.27e2 * tau0 * t233 + 0.154e3 / 0.27e2 * s0 * t349 + 0.110e3 / 0.27e2 * l0 * t233
  t356 = t354 * t77 * t80
  t357 = 0.39111111111111111111111111111111111111111111111111e0 * t356
  t358 = f.my_piecewise3(t86, 0, -t357)
  t362 = 0.1e1 / t164 / t91
  t365 = t246 * t161
  t371 = t99 ** 2
  t373 = 0.1e1 / t100 / t371
  t375 = t373 * t97 * t96
  t377 = 0.1e1 / t192
  t378 = t255 * t157 * t377
  t381 = t253 * t96
  t384 = t254 * t157
  t385 = t264 * t238
  t388 = t169 * t157
  t394 = f.my_piecewise3(t83, 0.3e1 * t165 * t339 - 0.3e1 * t342 * t242 + t147 * t358 / 0.2e1 - 0.15e2 / 0.2e1 * t362 * t339 + 0.9e1 / 0.2e1 * t365 * t242 - 0.3e1 / 0.8e1 * t165 * t358, -t357 - 0.37574303989476819753086419753086419753086419753085e0 * t375 * t378 + 0.75813339338271604938271604938271604938271604938270e0 * t381 * t378 - 0.22744001801481481481481481481481481481481481481481e0 * t384 * t385 + 0.45890370370370370370370370370370370370370370370371e0 * t388 * t385 - 0.27534222222222222222222222222222222222222222222222e0 * t170 * t356)
  t395 = t63 * t394
  t403 = t177 ** 2
  t404 = 0.1e1 / t403
  t406 = t404 * t277 * t206
  t409 = t276 * t206
  t410 = t409 * t313
  t413 = t102 ** 2
  t415 = 0.1e1 / t107 / t413
  t416 = t415 * t123
  t417 = t284 * t174
  t421 = t186 * t282
  t430 = t202 * t270
  t434 = t303 * t180
  t435 = t305 * t417
  t447 = t303 * t107 * t305
  t449 = t119 * t174
  t456 = 0.1e1 / t300 / t190 * t302 * t193
  t457 = t456 * t107
  t458 = t195 ** 2
  t459 = t458 * t117
  t461 = t200 ** 2
  t463 = 0.1e1 / t201 / t461
  t464 = t463 * t196
  t471 = 0.16686446595965241634600644241801604387204784717969e0 * t179 * t416 * t417 - 0.12626262626262626262626262626262626262626262626262e0 * t421 * t117 * t417 * t202 - 0.33372893191930483269201288483603208774409569435938e0 * t179 * t283 * t174 * t270 + 0.50505050505050505050505050505050505050505050505050e0 * t288 * t188 * t430 - 0.12048846709319637996491442926224598907166056284237e-2 * t434 * t435 * t309 + 0.22248595461286988846134192322402139182939712957292e0 * t179 * t181 * t394 + 0.16835016835016835016835016835016835016835016835017e0 * t187 * t117 * t394 * t202 - 0.24097693418639275992982885852449197814332112568474e-2 * t447 * t270 * t308 * t449 + 0.11497836796354867394723500203836174236141391281180e-4 * t457 * t459 * t417 * t464 - 0.80325644728797586643276286174830659381107041894915e-3 * t304 * t435 * t308
  t472 = t178 * t471
  t474 = -0.6e1 * t103 * t406 + 0.6e1 * t103 * t410 - t103 * t472 + t395 * t128 + 0.6e1 * t175 * t278 - 0.3e1 * t175 * t314 - 0.3e1 * t271 * t207
  t479 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t55 * t130 - 0.3e1 / 0.8e1 * t5 * t142 * t130 - 0.9e1 / 0.8e1 * t5 * t146 * t209 + t5 * t218 * t130 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t222 * t209 - 0.9e1 / 0.8e1 * t5 * t226 * t316 - 0.5e1 / 0.36e2 * t5 * t326 * t130 + t5 * t330 * t209 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t334 * t316 - 0.3e1 / 0.8e1 * t5 * t338 * t474)
  t481 = r1 <= f.p.dens_threshold
  t482 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t483 = 0.1e1 + t482
  t484 = t483 <= f.p.zeta_threshold
  t485 = t483 ** (0.1e1 / 0.3e1)
  t486 = t485 ** 2
  t488 = 0.1e1 / t486 / t483
  t490 = f.my_piecewise5(t14, 0, t10, 0, -t28)
  t491 = t490 ** 2
  t495 = 0.1e1 / t486
  t496 = t495 * t490
  t498 = f.my_piecewise5(t14, 0, t10, 0, -t40)
  t502 = f.my_piecewise5(t14, 0, t10, 0, -t48)
  t506 = f.my_piecewise3(t484, 0, -0.8e1 / 0.27e2 * t488 * t491 * t490 + 0.4e1 / 0.3e1 * t496 * t498 + 0.4e1 / 0.3e1 * t485 * t502)
  t508 = r1 ** (0.1e1 / 0.3e1)
  t509 = t508 ** 2
  t511 = 0.1e1 / t509 / r1
  t513 = r1 ** 2
  t522 = (tau1 * t511 - s2 / t509 / t513 / 0.8e1 - l1 * t511 / 0.4e1) * t77 * t80
  t523 = 0.5e1 / 0.9e1 * t522
  t525 = 0.39111111111111111111111111111111111111111111111111e0 * t522
  t529 = f.my_piecewise3(0.0e0 < 0.70414204545454545454545454545454545454545454545455e0 - t525, -0.14204545454545454545454545454545454545454545454545e-3, 0.704e0 - t525)
  t532 = t529 ** 2
  t538 = (0.1e1 - t523) ** 2
  t541 = jnp.sqrt(0.1e1 + 0.495616e0 * t538)
  t543 = f.my_piecewise3(-t523 < -0.14205545454545454545454545454545454545454545454545e5, -0.1e1 / t529 / 0.2e1 + 0.1e1 / t532 / t529 / 0.8e1, 0.704e0 - t525 + t541)
  t545 = jnp.sqrt(t543)
  t551 = jnp.asinh(0.12611295594149683618527696903038317622317287894258e-1 * t113 * t118 * (t543 - 0.1e1))
  t558 = t62 + t63 * t543 / (0.1e1 + 0.44497190922573977692268384644804278365879425914585e0 * t105 * t106 * t545 * t551)
  t567 = f.my_piecewise3(t484, 0, 0.4e1 / 0.9e1 * t495 * t491 + 0.4e1 / 0.3e1 * t485 * t498)
  t574 = f.my_piecewise3(t484, 0, 0.4e1 / 0.3e1 * t485 * t490)
  t580 = f.my_piecewise3(t484, t321, t485 * t483)
  t586 = f.my_piecewise3(t481, 0, -0.3e1 / 0.8e1 * t5 * t506 * t54 * t558 - 0.3e1 / 0.8e1 * t5 * t567 * t141 * t558 + t5 * t574 * t217 * t558 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t580 * t325 * t558)
  t606 = t19 ** 2
  t609 = t30 ** 2
  t615 = t41 ** 2
  t624 = -0.24e2 * t45 + 0.24e2 * t16 / t44 / t6
  t625 = f.my_piecewise5(t10, 0, t14, 0, t624)
  t629 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t22 / t606 * t609 - 0.16e2 / 0.9e1 * t24 * t30 * t41 + 0.4e1 / 0.3e1 * t34 * t615 + 0.16e2 / 0.9e1 * t35 * t49 + 0.4e1 / 0.3e1 * t21 * t625)
  t645 = 0.1e1 / t140 / t36
  t650 = t227 ** 2
  t656 = t242 ** 2
  t672 = (0.6160e4 / 0.81e2 * tau0 * t349 - 0.2618e4 / 0.81e2 * s0 / t65 / t231 / t69 - 0.1540e4 / 0.81e2 * l0 * t349) * t77 * t80
  t673 = 0.39111111111111111111111111111111111111111111111111e0 * t672
  t674 = f.my_piecewise3(t86, 0, -t673)
  t694 = t97 ** 2
  t696 = t255 ** 2
  t699 = t377 * t77 * t80
  t707 = t255 * t377 * t238
  t715 = t238 ** 2
  t720 = t264 * t354
  t730 = -t673 - 0.51728961794579287496515775034293552812071330589847e0 / t100 / t371 / t99 * t694 * t696 * t699 + 0.12524767996492273251028806584362139917695473251028e1 * t373 * t97 * t696 * t699 - 0.22544582393686091851851851851851851851851851851851e1 * t375 * t707 - 0.42118521854595336076817558299039780521262002743483e0 * t253 * t696 * t699 + 0.45488003602962962962962962962962962962962962962962e1 * t381 * t707 - 0.22744001801481481481481481481481481481481481481481e0 * t254 * t715 * t256 * t259 - 0.30325335735308641975308641975308641975308641975308e0 * t384 * t720 + 0.45890370370370370370370370370370370370370370370371e0 * t169 * t715 * t264 + 0.61187160493827160493827160493827160493827160493828e0 * t388 * t720 - 0.27534222222222222222222222222222222222222222222222e0 * t170 * t672
  t731 = f.my_piecewise3(t83, -0.12e2 * t246 * t650 + 0.18e2 * t165 * t227 * t242 - 0.3e1 * t93 * t656 - 0.4e1 * t342 * t358 + t147 * t674 / 0.2e1 + 0.45e2 / t164 / t92 * t650 - 0.45e2 * t362 * t227 * t242 + 0.9e1 / 0.2e1 * t246 * t656 + 0.6e1 * t365 * t358 - 0.3e1 / 0.8e1 * t165 * t674, t730)
  t748 = t277 ** 2
  t756 = t313 ** 2
  t763 = t300 ** 2
  t766 = t302 ** 2
  t771 = t284 ** 2
  t781 = t305 * t771
  t786 = t459 * t771
  t797 = t270 ** 2
  t833 = t308 * t284
  t866 = -0.27430063263514809359078385755309594326225327911474e-6 / t763 / t189 * t766 * t192 * t107 * t458 * t305 * t771 / t201 / t461 / t200 * t196 * t119 - 0.16065128945759517328655257234966131876221408378983e-2 * t434 * t781 * t308 + 0.22995673592709734789447000407672348472282782562360e-4 * t456 * t180 * t786 * t464 - 0.75757575757575757575757575757575757575757575757573e0 * t421 * t289 * t430 + 0.12048846709319637996491442926224598907166056284237e-2 * t303 * t282 * t781 * t309 - 0.33372893191930483269201288483603208774409569435938e0 * t179 * t283 * t797 - 0.44497190922573977692268384644804278365879425914584e0 * t179 * t283 * t174 * t394 + 0.50505050505050505050505050505050505050505050505050e0 * t288 * t117 * t797 * t202 + 0.67340067340067340067340067340067340067340067340066e0 * t288 * t188 * t202 * t394 - 0.41716116489913104086501610604504010968011961794922e0 * t179 / t107 / t413 / t102 * t123 * t771 + 0.10011867957579144980760386545080962632322870830781e1 * t179 * t416 * t284 * t270 + 0.34493510389064602184170500611508522708424173843540e-4 * t457 * t786 * t463 * t119 - 0.32130257891519034657310514469932263752442816757966e-2 * t447 * t394 * t308 * t449 - 0.48195386837278551985965771704898395628664225136948e-2 * t304 * t305 * t270 * t833 - 0.24097693418639275992982885852449197814332112568474e-2 * t304 * t305 * t797 * t309 + 0.68987020778129204368341001223017045416848347687080e-4 * t456 * t107 * t459 * t270 * t463 * t196 * t284 + 0.22248595461286988846134192322402139182939712957292e0 * t179 * t181 * t731 + 0.16835016835016835016835016835016835016835016835017e0 * t187 * t117 * t731 * t202 + 0.25252525252525252525252525252525252525252525252524e0 * t186 * t415 * t117 * t771 * t202 - 0.72293080255917827978948657557347593442996337705422e-2 * t303 * t180 * t305 * t833 * t270 * t119
  t869 = t63 * t731 * t128 - 0.4e1 * t395 * t207 + 0.12e2 * t271 * t278 - 0.6e1 * t271 * t314 - 0.24e2 * t175 * t406 + 0.24e2 * t175 * t410 - 0.4e1 * t175 * t472 + 0.24e2 * t103 / t403 / t127 * t748 - 0.36e2 * t103 * t404 * t277 * t313 + 0.6e1 * t103 * t276 * t756 + 0.8e1 * t103 * t409 * t471 - t103 * t178 * t866
  t883 = t5 * t139 * t217 * t130 / 0.2e1 - t5 * t334 * t474 / 0.2e1 - 0.3e1 / 0.2e1 * t5 * t226 * t474 - 0.3e1 / 0.2e1 * t5 * t222 * t316 + t5 * t218 * t209 - 0.9e1 / 0.4e1 * t5 * t146 * t316 - 0.3e1 / 0.8e1 * t5 * t629 * t54 * t130 - 0.3e1 / 0.2e1 * t5 * t55 * t209 - 0.3e1 / 0.2e1 * t5 * t142 * t209 - t5 * t53 * t141 * t130 / 0.2e1 + 0.10e2 / 0.27e2 * t5 * t323 * t645 * t130 - 0.3e1 / 0.8e1 * t5 * t338 * t869 - 0.5e1 / 0.9e1 * t5 * t326 * t209 + t5 * t330 * t316 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t215 * t325 * t130
  t884 = f.my_piecewise3(t1, 0, t883)
  t885 = t483 ** 2
  t888 = t491 ** 2
  t894 = t498 ** 2
  t900 = f.my_piecewise5(t14, 0, t10, 0, -t624)
  t904 = f.my_piecewise3(t484, 0, 0.40e2 / 0.81e2 / t486 / t885 * t888 - 0.16e2 / 0.9e1 * t488 * t491 * t498 + 0.4e1 / 0.3e1 * t495 * t894 + 0.16e2 / 0.9e1 * t496 * t502 + 0.4e1 / 0.3e1 * t485 * t900)
  t926 = f.my_piecewise3(t481, 0, -0.3e1 / 0.8e1 * t5 * t904 * t54 * t558 - t5 * t506 * t141 * t558 / 0.2e1 + t5 * t567 * t217 * t558 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t574 * t325 * t558 + 0.10e2 / 0.27e2 * t5 * t580 * t645 * t558)
  d1111 = 0.4e1 * t479 + 0.4e1 * t586 + t6 * (t884 + t926)

  res = {'v4rho4': d1111}
  return res
