"""Generated from mgga_x_lak.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  lak_h0x = 1.174

  lak_bx = 4.9479

  lak_ax = 1.1

  lak_anum = 5

  lak_fx_taylor = lambda a: 0.9999999998 - 0.3359715472 * a - 0.645213936 * a ** 2 - 0.5894205272 * a ** 3 - 0.1336260624 * a ** 4 + 0.4596061922 * a ** 5 + 0.8255440178 * a ** 6 + 0.6915383116 * a ** 7 - 0.001350990235 * a ** 8

  lak_alpha = lambda x, t: t / K_FACTOR_C * jnp.maximum(1 - x ** 2 / (8 * t), 1e-10)

  lak_mu_ax = -(97 + 3 * lak_h0x + jnp.sqrt((3 * lak_h0x) ** 2 + 74166 * lak_h0x - 64175)) / 1200

  lak_gx = lambda s: 1 - f.m_recexp(jnp.sqrt(s) / lak_bx)

  lak_kx = lambda s: f.m_recexp((s / lak_ax) ** 2 * (1 + s ** 2))

  lak_gnum = lambda s: 1 - f.m_recexp((s / lak_anum) ** 2)

  lak_nu_a = (73 - 50 * lak_mu_ax) / 5000

  lak_mu_sx = (10 + 60 * lak_mu_ax) / 81

  lak_nu_s = -(1606 - 50 * lak_mu_ax) / 18225

  lak_c1 = lak_mu_ax / (lak_h0x - 1)

  lak_c2 = (lak_mu_ax + lak_nu_a) / (lak_h0x - 1)

  lak_hx_ge4 = lambda s: 1 + lak_mu_sx * s ** 2 + lak_nu_s * s ** 4 + lak_h0x * (1 - lak_gx(s))

  lak_fx0 = lambda a: 2 / jnp.pi * jnp.arctan(jnp.pi / 2 * (lak_c1 * (a - 1) / a + lak_c2 * (a - 1) ** 2))

  lak_h1x = lambda s: lak_hx_ge4(s) + lak_kx(s) * (lak_ax - lak_hx_ge4(s))

  lak_fx = lambda a: f.my_piecewise3(a <= DBL_EPSILON, lak_fx_taylor(a), lak_fx0(jnp.maximum(a, DBL_EPSILON)))

  lak_fsa = lambda s, a: lak_h0x * lak_gx(s) + (1 - lak_fx(a)) * (lak_h1x(s) - lak_h0x) * lak_gnum(s)

  lak_f = lambda x, u, t: lak_fsa(x * X2S, lak_alpha(x, t))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, lak_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  lak_h0x = 1.174

  lak_bx = 4.9479

  lak_ax = 1.1

  lak_anum = 5

  lak_fx_taylor = lambda a: 0.9999999998 - 0.3359715472 * a - 0.645213936 * a ** 2 - 0.5894205272 * a ** 3 - 0.1336260624 * a ** 4 + 0.4596061922 * a ** 5 + 0.8255440178 * a ** 6 + 0.6915383116 * a ** 7 - 0.001350990235 * a ** 8

  lak_alpha = lambda x, t: t / K_FACTOR_C * jnp.maximum(1 - x ** 2 / (8 * t), 1e-10)

  lak_mu_ax = -(97 + 3 * lak_h0x + jnp.sqrt((3 * lak_h0x) ** 2 + 74166 * lak_h0x - 64175)) / 1200

  lak_gx = lambda s: 1 - f.m_recexp(jnp.sqrt(s) / lak_bx)

  lak_kx = lambda s: f.m_recexp((s / lak_ax) ** 2 * (1 + s ** 2))

  lak_gnum = lambda s: 1 - f.m_recexp((s / lak_anum) ** 2)

  lak_nu_a = (73 - 50 * lak_mu_ax) / 5000

  lak_mu_sx = (10 + 60 * lak_mu_ax) / 81

  lak_nu_s = -(1606 - 50 * lak_mu_ax) / 18225

  lak_c1 = lak_mu_ax / (lak_h0x - 1)

  lak_c2 = (lak_mu_ax + lak_nu_a) / (lak_h0x - 1)

  lak_hx_ge4 = lambda s: 1 + lak_mu_sx * s ** 2 + lak_nu_s * s ** 4 + lak_h0x * (1 - lak_gx(s))

  lak_fx0 = lambda a: 2 / jnp.pi * jnp.arctan(jnp.pi / 2 * (lak_c1 * (a - 1) / a + lak_c2 * (a - 1) ** 2))

  lak_h1x = lambda s: lak_hx_ge4(s) + lak_kx(s) * (lak_ax - lak_hx_ge4(s))

  lak_fx = lambda a: f.my_piecewise3(a <= DBL_EPSILON, lak_fx_taylor(a), lak_fx0(jnp.maximum(a, DBL_EPSILON)))

  lak_fsa = lambda s, a: lak_h0x * lak_gx(s) + (1 - lak_fx(a)) * (lak_h1x(s) - lak_h0x) * lak_gnum(s)

  lak_f = lambda x, u, t: lak_fsa(x * X2S, lak_alpha(x, t))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, lak_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  lak_h0x = 1.174

  lak_bx = 4.9479

  lak_ax = 1.1

  lak_anum = 5

  lak_fx_taylor = lambda a: 0.9999999998 - 0.3359715472 * a - 0.645213936 * a ** 2 - 0.5894205272 * a ** 3 - 0.1336260624 * a ** 4 + 0.4596061922 * a ** 5 + 0.8255440178 * a ** 6 + 0.6915383116 * a ** 7 - 0.001350990235 * a ** 8

  lak_alpha = lambda x, t: t / K_FACTOR_C * jnp.maximum(1 - x ** 2 / (8 * t), 1e-10)

  lak_mu_ax = -(97 + 3 * lak_h0x + jnp.sqrt((3 * lak_h0x) ** 2 + 74166 * lak_h0x - 64175)) / 1200

  lak_gx = lambda s: 1 - f.m_recexp(jnp.sqrt(s) / lak_bx)

  lak_kx = lambda s: f.m_recexp((s / lak_ax) ** 2 * (1 + s ** 2))

  lak_gnum = lambda s: 1 - f.m_recexp((s / lak_anum) ** 2)

  lak_nu_a = (73 - 50 * lak_mu_ax) / 5000

  lak_mu_sx = (10 + 60 * lak_mu_ax) / 81

  lak_nu_s = -(1606 - 50 * lak_mu_ax) / 18225

  lak_c1 = lak_mu_ax / (lak_h0x - 1)

  lak_c2 = (lak_mu_ax + lak_nu_a) / (lak_h0x - 1)

  lak_hx_ge4 = lambda s: 1 + lak_mu_sx * s ** 2 + lak_nu_s * s ** 4 + lak_h0x * (1 - lak_gx(s))

  lak_fx0 = lambda a: 2 / jnp.pi * jnp.arctan(jnp.pi / 2 * (lak_c1 * (a - 1) / a + lak_c2 * (a - 1) ** 2))

  lak_h1x = lambda s: lak_hx_ge4(s) + lak_kx(s) * (lak_ax - lak_hx_ge4(s))

  lak_fx = lambda a: f.my_piecewise3(a <= DBL_EPSILON, lak_fx_taylor(a), lak_fx0(jnp.maximum(a, DBL_EPSILON)))

  lak_fsa = lambda s, a: lak_h0x * lak_gx(s) + (1 - lak_fx(a)) * (lak_h1x(s) - lak_h0x) * lak_gnum(s)

  lak_f = lambda x, u, t: lak_fsa(x * X2S, lak_alpha(x, t))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, lak_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = jnp.sqrt(0.3e1)
  t29 = jnp.sqrt(s0)
  t30 = r0 ** (0.1e1 / 0.3e1)
  t32 = 0.1e1 / t30 / r0
  t34 = 6 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t36 = jnp.pi ** 2
  t37 = t36 ** (0.1e1 / 0.3e1)
  t38 = 0.1e1 / t37
  t39 = t35 * t38
  t41 = jnp.sqrt(t29 * t32 * t39)
  t43 = 0.33684323989301858700997729676563121054723552753020e-1 * t28 * t41
  t44 = jnp.log(DBL_EPSILON)
  t45 = 0.1e1 / t44
  t46 = t43 <= -t45
  t47 = t43 < -t45
  t48 = f.my_piecewise3(t47, -t45, t43)
  t50 = jnp.exp(-0.1e1 / t48)
  t51 = f.my_piecewise3(t46, 0, t50)
  t52 = 0.1174e1 * t51
  t53 = t30 ** 2
  t55 = 0.1e1 / t53 / r0
  t56 = tau0 * t55
  t57 = t37 ** 2
  t58 = 0.1e1 / t57
  t59 = t34 * t58
  t60 = 0.1e1 / r0
  t61 = s0 * t60
  t62 = 0.1e1 / tau0
  t64 = t61 * t62 / 0.8e1
  t66 = 0.0e0 < 0.9999999999e0 - t64
  t68 = f.my_piecewise3(t66, 0.1e1 - t64, 0.1e-9)
  t69 = t59 * t68
  t70 = t56 * t69
  t71 = 0.5e1 / 0.9e1 * t70
  t72 = t71 <= DBL_EPSILON
  t74 = tau0 ** 2
  t75 = r0 ** 2
  t76 = t75 * r0
  t78 = 0.1e1 / t30 / t76
  t79 = t74 * t78
  t81 = 0.1e1 / t37 / t36
  t82 = t35 * t81
  t83 = t68 ** 2
  t84 = t82 * t83
  t87 = t74 * tau0
  t88 = t75 ** 2
  t89 = t88 * r0
  t90 = 0.1e1 / t89
  t91 = t87 * t90
  t92 = t36 ** 2
  t93 = 0.1e1 / t92
  t94 = t83 * t68
  t95 = t93 * t94
  t98 = t74 ** 2
  t99 = t88 * t75
  t101 = 0.1e1 / t53 / t99
  t102 = t98 * t101
  t104 = 0.1e1 / t57 / t92
  t105 = t34 * t104
  t106 = t83 ** 2
  t107 = t105 * t106
  t110 = t98 * tau0
  t111 = t88 ** 2
  t113 = 0.1e1 / t30 / t111
  t114 = t110 * t113
  t117 = 0.1e1 / t37 / t92 / t36
  t118 = t35 * t117
  t119 = t106 * t68
  t120 = t118 * t119
  t123 = t98 * t74
  t125 = 0.1e1 / t111 / t75
  t126 = t123 * t125
  t127 = t92 ** 2
  t128 = 0.1e1 / t127
  t129 = t106 * t83
  t130 = t128 * t129
  t133 = t98 * t87
  t134 = t111 * t76
  t136 = 0.1e1 / t53 / t134
  t137 = t133 * t136
  t139 = 0.1e1 / t57 / t127
  t140 = t34 * t139
  t141 = t106 * t94
  t142 = t140 * t141
  t145 = t98 ** 2
  t148 = 0.1e1 / t30 / t111 / t89
  t149 = t145 * t148
  t152 = 0.1e1 / t37 / t127 / t36
  t153 = t35 * t152
  t154 = t106 ** 2
  t155 = t153 * t154
  t159 = 0.1e1 / jnp.pi
  t160 = DBL_EPSILON < t71
  t161 = f.my_piecewise3(t160, t71, DBL_EPSILON)
  t163 = -0.12063067191025636561756297344054915325509498465082e1 * t161 + 0.12063067191025636561756297344054915325509498465082e1
  t164 = 0.1e1 / t161
  t166 = t161 - 0.1e1
  t167 = t166 ** 2
  t169 = t163 * t164 - 0.11103356059345265253609998738430458126277391986178e1 * t167
  t172 = jnp.arctan(jnp.pi * t169 / 0.2e1)
  t175 = f.my_piecewise3(t72, 0.10000000000000000000000000000000000000000000000000e1 - 0.18665085944258768548480312698291741183874251568800e0 * t70 - 0.19914010358223149895830444419972096970737867899790e0 * t79 * t84 - 0.60639971965846678503023596624343652890052150377469e0 * t91 * t95 - 0.76375207387723991077566056665447164522292648877806e-1 * t102 * t107 + 0.14594008525673758618635093453857443622481897843672e0 * t114 * t120 + 0.87379127649768217956886118366110753128149506595882e0 * t126 * t130 + 0.40664104271070688990929332974004665519976822489071e0 * t137 * t142 - 0.44134118356287122526486193965041092672803237476953e-3 * t149 * t155, 0.2e1 * t159 * t172)
  t176 = 0.1e1 - t175
  t178 = 0.1e1 / t53 / t75
  t179 = s0 * t178
  t180 = t179 * t59
  t181 = 0.13342809400364015280213860222187919752221792168441e-2 * t180
  t182 = s0 ** 2
  t184 = 0.1e1 / t30 / t89
  t187 = 0.15398708928290202558763221866801247678833192955195e-3 * t182 * t184 * t82
  t189 = 0.1e1 + t180 / 0.24e2
  t190 = t59 * t189
  t192 = 0.34435261707988980716253443526170798898071625344353e-1 * t179 * t190
  t193 = t192 <= -t45
  t194 = t192 < -t45
  t195 = f.my_piecewise3(t194, -t45, t192)
  t197 = jnp.exp(-0.1e1 / t195)
  t198 = f.my_piecewise3(t193, 0, t197)
  t199 = 0.1e0 + t181 + t187 - t52
  t201 = -0.174e0 - t181 - t187 + t52 + t198 * t199
  t202 = t176 * t201
  t203 = t180 / 0.600e3
  t204 = t203 <= -t45
  t205 = t203 < -t45
  t206 = f.my_piecewise3(t205, -t45, t203)
  t208 = jnp.exp(-0.1e1 / t206)
  t209 = f.my_piecewise3(t204, 0, t208)
  t210 = 0.1e1 - t209
  t212 = 0.1174e1 - t52 + t202 * t210
  t216 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t212)
  t217 = r1 <= f.p.dens_threshold
  t218 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t219 = 0.1e1 + t218
  t220 = t219 <= f.p.zeta_threshold
  t221 = t219 ** (0.1e1 / 0.3e1)
  t223 = f.my_piecewise3(t220, t22, t221 * t219)
  t224 = t223 * t26
  t225 = jnp.sqrt(s2)
  t226 = r1 ** (0.1e1 / 0.3e1)
  t228 = 0.1e1 / t226 / r1
  t231 = jnp.sqrt(t225 * t228 * t39)
  t233 = 0.33684323989301858700997729676563121054723552753020e-1 * t28 * t231
  t234 = t233 <= -t45
  t235 = t233 < -t45
  t236 = f.my_piecewise3(t235, -t45, t233)
  t238 = jnp.exp(-0.1e1 / t236)
  t239 = f.my_piecewise3(t234, 0, t238)
  t240 = 0.1174e1 * t239
  t241 = t226 ** 2
  t243 = 0.1e1 / t241 / r1
  t244 = tau1 * t243
  t245 = 0.1e1 / r1
  t246 = s2 * t245
  t247 = 0.1e1 / tau1
  t249 = t246 * t247 / 0.8e1
  t251 = 0.0e0 < 0.9999999999e0 - t249
  t253 = f.my_piecewise3(t251, 0.1e1 - t249, 0.1e-9)
  t254 = t59 * t253
  t255 = t244 * t254
  t256 = 0.5e1 / 0.9e1 * t255
  t257 = t256 <= DBL_EPSILON
  t259 = tau1 ** 2
  t260 = r1 ** 2
  t261 = t260 * r1
  t263 = 0.1e1 / t226 / t261
  t264 = t259 * t263
  t265 = t253 ** 2
  t266 = t82 * t265
  t269 = t259 * tau1
  t270 = t260 ** 2
  t271 = t270 * r1
  t272 = 0.1e1 / t271
  t273 = t269 * t272
  t274 = t265 * t253
  t275 = t93 * t274
  t278 = t259 ** 2
  t279 = t270 * t260
  t281 = 0.1e1 / t241 / t279
  t282 = t278 * t281
  t283 = t265 ** 2
  t284 = t105 * t283
  t287 = t278 * tau1
  t288 = t270 ** 2
  t290 = 0.1e1 / t226 / t288
  t291 = t287 * t290
  t292 = t283 * t253
  t293 = t118 * t292
  t296 = t278 * t259
  t298 = 0.1e1 / t288 / t260
  t299 = t296 * t298
  t300 = t283 * t265
  t301 = t128 * t300
  t304 = t278 * t269
  t305 = t288 * t261
  t307 = 0.1e1 / t241 / t305
  t308 = t304 * t307
  t309 = t283 * t274
  t310 = t140 * t309
  t313 = t278 ** 2
  t316 = 0.1e1 / t226 / t288 / t271
  t317 = t313 * t316
  t318 = t283 ** 2
  t319 = t153 * t318
  t323 = DBL_EPSILON < t256
  t324 = f.my_piecewise3(t323, t256, DBL_EPSILON)
  t326 = -0.12063067191025636561756297344054915325509498465082e1 * t324 + 0.12063067191025636561756297344054915325509498465082e1
  t327 = 0.1e1 / t324
  t329 = t324 - 0.1e1
  t330 = t329 ** 2
  t332 = t326 * t327 - 0.11103356059345265253609998738430458126277391986178e1 * t330
  t335 = jnp.arctan(jnp.pi * t332 / 0.2e1)
  t338 = f.my_piecewise3(t257, 0.10000000000000000000000000000000000000000000000000e1 - 0.18665085944258768548480312698291741183874251568800e0 * t255 - 0.19914010358223149895830444419972096970737867899790e0 * t264 * t266 - 0.60639971965846678503023596624343652890052150377469e0 * t273 * t275 - 0.76375207387723991077566056665447164522292648877806e-1 * t282 * t284 + 0.14594008525673758618635093453857443622481897843672e0 * t291 * t293 + 0.87379127649768217956886118366110753128149506595882e0 * t299 * t301 + 0.40664104271070688990929332974004665519976822489071e0 * t308 * t310 - 0.44134118356287122526486193965041092672803237476953e-3 * t317 * t319, 0.2e1 * t159 * t335)
  t339 = 0.1e1 - t338
  t341 = 0.1e1 / t241 / t260
  t342 = s2 * t341
  t343 = t342 * t59
  t344 = 0.13342809400364015280213860222187919752221792168441e-2 * t343
  t345 = s2 ** 2
  t347 = 0.1e1 / t226 / t271
  t350 = 0.15398708928290202558763221866801247678833192955195e-3 * t345 * t347 * t82
  t352 = 0.1e1 + t343 / 0.24e2
  t353 = t59 * t352
  t355 = 0.34435261707988980716253443526170798898071625344353e-1 * t342 * t353
  t356 = t355 <= -t45
  t357 = t355 < -t45
  t358 = f.my_piecewise3(t357, -t45, t355)
  t360 = jnp.exp(-0.1e1 / t358)
  t361 = f.my_piecewise3(t356, 0, t360)
  t362 = 0.1e0 + t344 + t350 - t240
  t364 = -0.174e0 - t344 - t350 + t240 + t361 * t362
  t365 = t339 * t364
  t366 = t343 / 0.600e3
  t367 = t366 <= -t45
  t368 = t366 < -t45
  t369 = f.my_piecewise3(t368, -t45, t366)
  t371 = jnp.exp(-0.1e1 / t369)
  t372 = f.my_piecewise3(t367, 0, t371)
  t373 = 0.1e1 - t372
  t375 = 0.1174e1 - t240 + t365 * t373
  t379 = f.my_piecewise3(t217, 0, -0.3e1 / 0.8e1 * t5 * t224 * t375)
  t380 = t6 ** 2
  t382 = t16 / t380
  t383 = t7 - t382
  t384 = f.my_piecewise5(t10, 0, t14, 0, t383)
  t387 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t384)
  t392 = t26 ** 2
  t393 = 0.1e1 / t392
  t397 = t5 * t25 * t393 * t212 / 0.8e1
  t398 = t48 ** 2
  t399 = 0.1e1 / t398
  t401 = t28 / t41
  t409 = f.my_piecewise3(t47, 0, -0.22456215992867905800665153117708747369815701835347e-1 * t401 * t29 / t30 / t75 * t35 * t38)
  t412 = f.my_piecewise3(t46, 0, t399 * t409 * t50)
  t413 = 0.1174e1 * t412
  t415 = tau0 * t178 * t69
  t421 = f.my_piecewise3(t66, s0 / t75 * t62 / 0.8e1, 0)
  t423 = t56 * t59 * t421
  t430 = t79 * t35
  t431 = t81 * t68
  t439 = t93 * t83
  t449 = t102 * t34
  t450 = t104 * t94
  t460 = t114 * t35
  t461 = t117 * t106
  t469 = t128 * t119
  t479 = t137 * t34
  t480 = t139 * t129
  t490 = t149 * t35
  t491 = t152 * t141
  t495 = 0.31108476573764614247467187830486235306457085948000e0 * t415 - 0.18665085944258768548480312698291741183874251568800e0 * t423 + 0.66380034527410499652768148066573656569126226332633e0 * t74 / t30 / t88 * t84 - 0.39828020716446299791660888839944193941475735799580e0 * t430 * t431 * t421 + 0.30319985982923339251511798312171826445026075188734e1 * t87 / t99 * t95 - 0.18191991589754003550907078987303095867015645113241e1 * t91 * t439 * t421 + 0.50916804925149327385044037776964776348195099251871e0 * t98 / t53 / t88 / t76 * t107 - 0.30550082955089596431026422666178865808917059551122e0 * t449 * t450 * t421 - 0.12161673771394798848862577878214536352068248203060e1 * t110 / t30 / t111 / r0 * t120 + 0.72970042628368793093175467269287218112409489218360e0 * t460 * t461 * t421 - 0.87379127649768217956886118366110753128149506595882e1 * t123 / t134 * t130 + 0.52427476589860930774131671019666451876889703957529e1 * t126 * t469 * t421 - 0.47441454982915803822750888469672109773306292903916e1 * t133 / t53 / t111 / t88 * t142 + 0.28464872989749482293650533081803265863983775742350e1 * t479 * t480 * t421 + 0.58845491141716163368648258620054790230404316635937e-2 * t145 / t30 / t111 / t99 * t155 - 0.35307294685029698021188955172032874138242589981562e-2 * t490 * t491 * t421
  t499 = f.my_piecewise3(t160, -0.25e2 / 0.27e2 * t415 + 0.5e1 / 0.9e1 * t423, 0)
  t502 = t161 ** 2
  t504 = t163 / t502
  t509 = t169 ** 2
  t513 = 0.1e1 / (0.1e1 + t36 * t509 / 0.4e1)
  t515 = f.my_piecewise3(t72, t495, (-0.12063067191025636561756297344054915325509498465082e1 * t499 * t164 - t504 * t499 - 0.22206712118690530507219997476860916252554783972356e1 * t166 * t499) * t513)
  t520 = s0 / t53 / t76
  t521 = t520 * t59
  t522 = 0.35580825067637374080570293925834452672591445782509e-2 * t521
  t526 = t182 / t30 / t99 * t82
  t527 = 0.82126447617547746980070516622939987620443695761040e-3 * t526
  t528 = t195 ** 2
  t529 = 0.1e1 / t528
  t534 = f.my_piecewise3(t194, 0, -0.91827364554637281910009182736455463728191000918275e-1 * t520 * t190 - 0.38261401897765534129170492806856443220079583715948e-2 * t526)
  t537 = f.my_piecewise3(t193, 0, t529 * t534 * t197)
  t544 = t206 ** 2
  t545 = 0.1e1 / t544
  t547 = f.my_piecewise3(t205, 0, -t521 / 0.225e3)
  t550 = f.my_piecewise3(t204, 0, t545 * t547 * t208)
  t557 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t387 * t26 * t212 - t397 - 0.3e1 / 0.8e1 * t5 * t27 * (-t413 - t515 * t201 * t210 + t176 * (t522 + t527 + t413 + t537 * t199 + t198 * (-t522 - t527 - t413)) * t210 - t202 * t550))
  t559 = f.my_piecewise5(t14, 0, t10, 0, -t383)
  t562 = f.my_piecewise3(t220, 0, 0.4e1 / 0.3e1 * t221 * t559)
  t570 = t5 * t223 * t393 * t375 / 0.8e1
  t572 = f.my_piecewise3(t217, 0, -0.3e1 / 0.8e1 * t5 * t562 * t26 * t375 - t570)
  vrho_0_ = t216 + t379 + t6 * (t557 + t572)
  t575 = -t7 - t382
  t576 = f.my_piecewise5(t10, 0, t14, 0, t575)
  t579 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t576)
  t585 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t579 * t26 * t212 - t397)
  t587 = f.my_piecewise5(t14, 0, t10, 0, -t575)
  t590 = f.my_piecewise3(t220, 0, 0.4e1 / 0.3e1 * t221 * t587)
  t595 = t236 ** 2
  t596 = 0.1e1 / t595
  t598 = t28 / t231
  t606 = f.my_piecewise3(t235, 0, -0.22456215992867905800665153117708747369815701835347e-1 * t598 * t225 / t226 / t260 * t35 * t38)
  t609 = f.my_piecewise3(t234, 0, t596 * t606 * t238)
  t610 = 0.1174e1 * t609
  t612 = tau1 * t341 * t254
  t618 = f.my_piecewise3(t251, s2 / t260 * t247 / 0.8e1, 0)
  t620 = t244 * t59 * t618
  t627 = t264 * t35
  t628 = t81 * t253
  t636 = t93 * t265
  t646 = t282 * t34
  t647 = t104 * t274
  t657 = t291 * t35
  t658 = t117 * t283
  t666 = t128 * t292
  t676 = t308 * t34
  t677 = t139 * t300
  t687 = t317 * t35
  t688 = t152 * t309
  t692 = 0.31108476573764614247467187830486235306457085948000e0 * t612 - 0.18665085944258768548480312698291741183874251568800e0 * t620 + 0.66380034527410499652768148066573656569126226332633e0 * t259 / t226 / t270 * t266 - 0.39828020716446299791660888839944193941475735799580e0 * t627 * t628 * t618 + 0.30319985982923339251511798312171826445026075188734e1 * t269 / t279 * t275 - 0.18191991589754003550907078987303095867015645113241e1 * t273 * t636 * t618 + 0.50916804925149327385044037776964776348195099251871e0 * t278 / t241 / t270 / t261 * t284 - 0.30550082955089596431026422666178865808917059551122e0 * t646 * t647 * t618 - 0.12161673771394798848862577878214536352068248203060e1 * t287 / t226 / t288 / r1 * t293 + 0.72970042628368793093175467269287218112409489218360e0 * t657 * t658 * t618 - 0.87379127649768217956886118366110753128149506595882e1 * t296 / t305 * t301 + 0.52427476589860930774131671019666451876889703957529e1 * t299 * t666 * t618 - 0.47441454982915803822750888469672109773306292903916e1 * t304 / t241 / t288 / t270 * t310 + 0.28464872989749482293650533081803265863983775742350e1 * t676 * t677 * t618 + 0.58845491141716163368648258620054790230404316635937e-2 * t313 / t226 / t288 / t279 * t319 - 0.35307294685029698021188955172032874138242589981562e-2 * t687 * t688 * t618
  t696 = f.my_piecewise3(t323, -0.25e2 / 0.27e2 * t612 + 0.5e1 / 0.9e1 * t620, 0)
  t699 = t324 ** 2
  t701 = t326 / t699
  t706 = t332 ** 2
  t710 = 0.1e1 / (0.1e1 + t36 * t706 / 0.4e1)
  t712 = f.my_piecewise3(t257, t692, (-0.12063067191025636561756297344054915325509498465082e1 * t696 * t327 - t701 * t696 - 0.22206712118690530507219997476860916252554783972356e1 * t329 * t696) * t710)
  t717 = s2 / t241 / t261
  t718 = t717 * t59
  t719 = 0.35580825067637374080570293925834452672591445782509e-2 * t718
  t723 = t345 / t226 / t279 * t82
  t724 = 0.82126447617547746980070516622939987620443695761040e-3 * t723
  t725 = t358 ** 2
  t726 = 0.1e1 / t725
  t731 = f.my_piecewise3(t357, 0, -0.91827364554637281910009182736455463728191000918275e-1 * t717 * t353 - 0.38261401897765534129170492806856443220079583715948e-2 * t723)
  t734 = f.my_piecewise3(t356, 0, t726 * t731 * t360)
  t741 = t369 ** 2
  t742 = 0.1e1 / t741
  t744 = f.my_piecewise3(t368, 0, -t718 / 0.225e3)
  t747 = f.my_piecewise3(t367, 0, t742 * t744 * t371)
  t754 = f.my_piecewise3(t217, 0, -0.3e1 / 0.8e1 * t5 * t590 * t26 * t375 - t570 - 0.3e1 / 0.8e1 * t5 * t224 * (-t610 - t712 * t364 * t373 + t339 * (t719 + t724 + t610 + t734 * t362 + t361 * (-t719 - t724 - t610)) * t373 - t365 * t747))
  vrho_1_ = t216 + t379 + t6 * (t585 + t754)
  t763 = f.my_piecewise3(t47, 0, 0.84210809973254646752494324191407802636808881882550e-2 * t401 / t29 * t32 * t35 * t38)
  t766 = f.my_piecewise3(t46, 0, t399 * t763 * t50)
  t767 = 0.1174e1 * t766
  t770 = f.my_piecewise3(t66, -t60 * t62 / 0.8e1, 0)
  t772 = t56 * t59 * t770
  t797 = f.my_piecewise3(t160, 0.5e1 / 0.9e1 * t772, 0)
  t805 = f.my_piecewise3(t72, -0.18665085944258768548480312698291741183874251568800e0 * t772 - 0.39828020716446299791660888839944193941475735799580e0 * t430 * t431 * t770 - 0.18191991589754003550907078987303095867015645113241e1 * t91 * t439 * t770 - 0.30550082955089596431026422666178865808917059551122e0 * t449 * t450 * t770 + 0.72970042628368793093175467269287218112409489218360e0 * t460 * t461 * t770 + 0.52427476589860930774131671019666451876889703957529e1 * t126 * t469 * t770 + 0.28464872989749482293650533081803265863983775742350e1 * t479 * t480 * t770 - 0.35307294685029698021188955172032874138242589981562e-2 * t490 * t491 * t770, (-0.12063067191025636561756297344054915325509498465082e1 * t797 * t164 - t504 * t797 - 0.22206712118690530507219997476860916252554783972356e1 * t166 * t797) * t513)
  t808 = t178 * t34
  t809 = t808 * t58
  t810 = 0.13342809400364015280213860222187919752221792168441e-2 * t809
  t812 = s0 * t184 * t82
  t813 = 0.30797417856580405117526443733602495357666385910390e-3 * t812
  t819 = f.my_piecewise3(t194, 0, 0.34435261707988980716253443526170798898071625344353e-1 * t808 * t58 * t189 + 0.14348025711662075298438934802571166207529843893480e-2 * t812)
  t822 = f.my_piecewise3(t193, 0, t529 * t819 * t197)
  t830 = f.my_piecewise3(t205, 0, t809 / 0.600e3)
  t833 = f.my_piecewise3(t204, 0, t545 * t830 * t208)
  t839 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (-t767 - t805 * t201 * t210 + t176 * (-t810 - t813 + t767 + t822 * t199 + t198 * (t810 + t813 - t767)) * t210 - t202 * t833))
  vsigma_0_ = t6 * t839
  vsigma_1_ = 0.0e0
  t846 = f.my_piecewise3(t235, 0, 0.84210809973254646752494324191407802636808881882550e-2 * t598 / t225 * t228 * t35 * t38)
  t849 = f.my_piecewise3(t234, 0, t596 * t846 * t238)
  t850 = 0.1174e1 * t849
  t853 = f.my_piecewise3(t251, -t245 * t247 / 0.8e1, 0)
  t855 = t244 * t59 * t853
  t880 = f.my_piecewise3(t323, 0.5e1 / 0.9e1 * t855, 0)
  t888 = f.my_piecewise3(t257, -0.18665085944258768548480312698291741183874251568800e0 * t855 - 0.39828020716446299791660888839944193941475735799580e0 * t627 * t628 * t853 - 0.18191991589754003550907078987303095867015645113241e1 * t273 * t636 * t853 - 0.30550082955089596431026422666178865808917059551122e0 * t646 * t647 * t853 + 0.72970042628368793093175467269287218112409489218360e0 * t657 * t658 * t853 + 0.52427476589860930774131671019666451876889703957529e1 * t299 * t666 * t853 + 0.28464872989749482293650533081803265863983775742350e1 * t676 * t677 * t853 - 0.35307294685029698021188955172032874138242589981562e-2 * t687 * t688 * t853, (-0.12063067191025636561756297344054915325509498465082e1 * t880 * t327 - t701 * t880 - 0.22206712118690530507219997476860916252554783972356e1 * t329 * t880) * t710)
  t891 = t341 * t34
  t892 = t891 * t58
  t893 = 0.13342809400364015280213860222187919752221792168441e-2 * t892
  t895 = s2 * t347 * t82
  t896 = 0.30797417856580405117526443733602495357666385910390e-3 * t895
  t902 = f.my_piecewise3(t357, 0, 0.34435261707988980716253443526170798898071625344353e-1 * t891 * t58 * t352 + 0.14348025711662075298438934802571166207529843893480e-2 * t895)
  t905 = f.my_piecewise3(t356, 0, t726 * t902 * t360)
  t913 = f.my_piecewise3(t368, 0, t892 / 0.600e3)
  t916 = f.my_piecewise3(t367, 0, t742 * t913 * t371)
  t922 = f.my_piecewise3(t217, 0, -0.3e1 / 0.8e1 * t5 * t224 * (-t850 - t888 * t364 * t373 + t339 * (-t893 - t896 + t850 + t905 * t362 + t361 * (t893 + t896 - t850)) * t373 - t365 * t916))
  vsigma_2_ = t6 * t922
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t926 = t55 * t34 * t58 * t68
  t931 = f.my_piecewise3(t66, t61 / t74 / 0.8e1, 0)
  t933 = t56 * t59 * t931
  t977 = -0.18665085944258768548480312698291741183874251568800e0 * t926 - 0.18665085944258768548480312698291741183874251568800e0 * t933 - 0.39828020716446299791660888839944193941475735799580e0 * tau0 * t78 * t84 - 0.39828020716446299791660888839944193941475735799580e0 * t430 * t431 * t931 - 0.18191991589754003550907078987303095867015645113241e1 * t74 * t90 * t95 - 0.18191991589754003550907078987303095867015645113241e1 * t91 * t439 * t931 - 0.30550082955089596431026422666178865808917059551122e0 * t87 * t101 * t107 - 0.30550082955089596431026422666178865808917059551122e0 * t449 * t450 * t931 + 0.72970042628368793093175467269287218112409489218360e0 * t98 * t113 * t120 + 0.72970042628368793093175467269287218112409489218360e0 * t460 * t461 * t931 + 0.52427476589860930774131671019666451876889703957529e1 * t110 * t125 * t130 + 0.52427476589860930774131671019666451876889703957529e1 * t126 * t469 * t931 + 0.28464872989749482293650533081803265863983775742350e1 * t123 * t136 * t142 + 0.28464872989749482293650533081803265863983775742350e1 * t479 * t480 * t931 - 0.35307294685029698021188955172032874138242589981562e-2 * t133 * t148 * t155 - 0.35307294685029698021188955172032874138242589981562e-2 * t490 * t491 * t931
  t980 = f.my_piecewise3(t160, 0.5e1 / 0.9e1 * t926 + 0.5e1 / 0.9e1 * t933, 0)
  t988 = f.my_piecewise3(t72, t977, (-0.12063067191025636561756297344054915325509498465082e1 * t980 * t164 - t504 * t980 - 0.22206712118690530507219997476860916252554783972356e1 * t166 * t980) * t513)
  t994 = f.my_piecewise3(t1, 0, 0.3e1 / 0.8e1 * t5 * t25 * t26 * t988 * t201 * t210)
  vtau_0_ = t6 * t994
  t998 = t243 * t34 * t58 * t253
  t1003 = f.my_piecewise3(t251, t246 / t259 / 0.8e1, 0)
  t1005 = t244 * t59 * t1003
  t1049 = -0.18665085944258768548480312698291741183874251568800e0 * t998 - 0.18665085944258768548480312698291741183874251568800e0 * t1005 - 0.39828020716446299791660888839944193941475735799580e0 * tau1 * t263 * t266 - 0.39828020716446299791660888839944193941475735799580e0 * t627 * t628 * t1003 - 0.18191991589754003550907078987303095867015645113241e1 * t259 * t272 * t275 - 0.18191991589754003550907078987303095867015645113241e1 * t273 * t636 * t1003 - 0.30550082955089596431026422666178865808917059551122e0 * t269 * t281 * t284 - 0.30550082955089596431026422666178865808917059551122e0 * t646 * t647 * t1003 + 0.72970042628368793093175467269287218112409489218360e0 * t278 * t290 * t293 + 0.72970042628368793093175467269287218112409489218360e0 * t657 * t658 * t1003 + 0.52427476589860930774131671019666451876889703957529e1 * t287 * t298 * t301 + 0.52427476589860930774131671019666451876889703957529e1 * t299 * t666 * t1003 + 0.28464872989749482293650533081803265863983775742350e1 * t296 * t307 * t310 + 0.28464872989749482293650533081803265863983775742350e1 * t676 * t677 * t1003 - 0.35307294685029698021188955172032874138242589981562e-2 * t304 * t316 * t319 - 0.35307294685029698021188955172032874138242589981562e-2 * t687 * t688 * t1003
  t1052 = f.my_piecewise3(t323, 0.5e1 / 0.9e1 * t998 + 0.5e1 / 0.9e1 * t1005, 0)
  t1060 = f.my_piecewise3(t257, t1049, (-0.12063067191025636561756297344054915325509498465082e1 * t1052 * t327 - t701 * t1052 - 0.22206712118690530507219997476860916252554783972356e1 * t329 * t1052) * t710)
  t1066 = f.my_piecewise3(t217, 0, 0.3e1 / 0.8e1 * t5 * t223 * t26 * t1060 * t364 * t373)
  vtau_1_ = t6 * t1066
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  lak_h0x = 1.174

  lak_bx = 4.9479

  lak_ax = 1.1

  lak_anum = 5

  lak_fx_taylor = lambda a: 0.9999999998 - 0.3359715472 * a - 0.645213936 * a ** 2 - 0.5894205272 * a ** 3 - 0.1336260624 * a ** 4 + 0.4596061922 * a ** 5 + 0.8255440178 * a ** 6 + 0.6915383116 * a ** 7 - 0.001350990235 * a ** 8

  lak_alpha = lambda x, t: t / K_FACTOR_C * jnp.maximum(1 - x ** 2 / (8 * t), 1e-10)

  lak_mu_ax = -(97 + 3 * lak_h0x + jnp.sqrt((3 * lak_h0x) ** 2 + 74166 * lak_h0x - 64175)) / 1200

  lak_gx = lambda s: 1 - f.m_recexp(jnp.sqrt(s) / lak_bx)

  lak_kx = lambda s: f.m_recexp((s / lak_ax) ** 2 * (1 + s ** 2))

  lak_gnum = lambda s: 1 - f.m_recexp((s / lak_anum) ** 2)

  lak_nu_a = (73 - 50 * lak_mu_ax) / 5000

  lak_mu_sx = (10 + 60 * lak_mu_ax) / 81

  lak_nu_s = -(1606 - 50 * lak_mu_ax) / 18225

  lak_c1 = lak_mu_ax / (lak_h0x - 1)

  lak_c2 = (lak_mu_ax + lak_nu_a) / (lak_h0x - 1)

  lak_hx_ge4 = lambda s: 1 + lak_mu_sx * s ** 2 + lak_nu_s * s ** 4 + lak_h0x * (1 - lak_gx(s))

  lak_fx0 = lambda a: 2 / jnp.pi * jnp.arctan(jnp.pi / 2 * (lak_c1 * (a - 1) / a + lak_c2 * (a - 1) ** 2))

  lak_h1x = lambda s: lak_hx_ge4(s) + lak_kx(s) * (lak_ax - lak_hx_ge4(s))

  lak_fx = lambda a: f.my_piecewise3(a <= DBL_EPSILON, lak_fx_taylor(a), lak_fx0(jnp.maximum(a, DBL_EPSILON)))

  lak_fsa = lambda s, a: lak_h0x * lak_gx(s) + (1 - lak_fx(a)) * (lak_h1x(s) - lak_h0x) * lak_gnum(s)

  lak_f = lambda x, u, t: lak_fsa(x * X2S, lak_alpha(x, t))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, lak_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = jnp.sqrt(0.3e1)
  t21 = jnp.sqrt(s0)
  t22 = 2 ** (0.1e1 / 0.3e1)
  t25 = 0.1e1 / t18 / r0
  t26 = 6 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t29 = jnp.pi ** 2
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = 0.1e1 / t30
  t34 = jnp.sqrt(t21 * t22 * t25 * t27 * t31)
  t36 = 0.33684323989301858700997729676563121054723552753020e-1 * t20 * t34
  t37 = jnp.log(DBL_EPSILON)
  t38 = 0.1e1 / t37
  t39 = t36 <= -t38
  t40 = t36 < -t38
  t41 = f.my_piecewise3(t40, -t38, t36)
  t43 = jnp.exp(-0.1e1 / t41)
  t44 = f.my_piecewise3(t39, 0, t43)
  t45 = 0.1174e1 * t44
  t46 = t22 ** 2
  t47 = tau0 * t46
  t48 = t18 ** 2
  t50 = 0.1e1 / t48 / r0
  t51 = t47 * t50
  t52 = t30 ** 2
  t53 = 0.1e1 / t52
  t54 = t26 * t53
  t55 = 0.1e1 / r0
  t56 = s0 * t55
  t57 = 0.1e1 / tau0
  t59 = t56 * t57 / 0.8e1
  t61 = 0.0e0 < 0.9999999999e0 - t59
  t63 = f.my_piecewise3(t61, 0.1e1 - t59, 0.1e-9)
  t64 = t54 * t63
  t65 = t51 * t64
  t66 = 0.5e1 / 0.9e1 * t65
  t67 = t66 <= DBL_EPSILON
  t69 = tau0 ** 2
  t70 = t69 * t22
  t71 = r0 ** 2
  t72 = t71 * r0
  t74 = 0.1e1 / t18 / t72
  t75 = t70 * t74
  t77 = 0.1e1 / t30 / t29
  t78 = t27 * t77
  t79 = t63 ** 2
  t80 = t78 * t79
  t83 = t69 * tau0
  t84 = t71 ** 2
  t85 = t84 * r0
  t86 = 0.1e1 / t85
  t87 = t83 * t86
  t88 = t29 ** 2
  t89 = 0.1e1 / t88
  t90 = t79 * t63
  t91 = t89 * t90
  t94 = t69 ** 2
  t95 = t94 * t46
  t96 = t84 * t71
  t98 = 0.1e1 / t48 / t96
  t99 = t95 * t98
  t102 = t26 / t52 / t88
  t103 = t79 ** 2
  t104 = t102 * t103
  t107 = t94 * tau0
  t108 = t107 * t22
  t109 = t84 ** 2
  t111 = 0.1e1 / t18 / t109
  t112 = t108 * t111
  t116 = t27 / t30 / t88 / t29
  t117 = t103 * t63
  t118 = t116 * t117
  t121 = t94 * t69
  t123 = 0.1e1 / t109 / t71
  t124 = t121 * t123
  t125 = t88 ** 2
  t126 = 0.1e1 / t125
  t127 = t103 * t79
  t128 = t126 * t127
  t131 = t94 * t83
  t132 = t131 * t46
  t133 = t109 * t72
  t135 = 0.1e1 / t48 / t133
  t136 = t132 * t135
  t139 = t26 / t52 / t125
  t140 = t103 * t90
  t141 = t139 * t140
  t144 = t94 ** 2
  t145 = t144 * t22
  t148 = 0.1e1 / t18 / t109 / t85
  t149 = t145 * t148
  t153 = t27 / t30 / t125 / t29
  t154 = t103 ** 2
  t155 = t153 * t154
  t160 = DBL_EPSILON < t66
  t161 = f.my_piecewise3(t160, t66, DBL_EPSILON)
  t163 = -0.12063067191025636561756297344054915325509498465082e1 * t161 + 0.12063067191025636561756297344054915325509498465082e1
  t164 = 0.1e1 / t161
  t166 = t161 - 0.1e1
  t167 = t166 ** 2
  t169 = t163 * t164 - 0.11103356059345265253609998738430458126277391986178e1 * t167
  t172 = jnp.arctan(jnp.pi * t169 / 0.2e1)
  t175 = f.my_piecewise3(t67, 0.10000000000000000000000000000000000000000000000000e1 - 0.18665085944258768548480312698291741183874251568800e0 * t65 - 0.39828020716446299791660888839944193941475735799580e0 * t75 * t80 - 0.24255988786338671401209438649737461156020860150988e1 * t87 * t91 - 0.30550082955089596431026422666178865808917059551123e0 * t99 * t104 + 0.11675206820539006894908074763085954897985518274938e1 * t112 * t118 + 0.13980660423962914873101778938577720500503921055341e2 * t124 * t128 + 0.65062566833713102385486932758407464831962915982514e1 * t136 * t141 - 0.14122917874011879208475582068813149655297035992625e-1 * t149 * t155, 0.2e1 / jnp.pi * t172)
  t176 = 0.1e1 - t175
  t177 = s0 * t46
  t179 = 0.1e1 / t48 / t71
  t182 = t177 * t179 * t26 * t53
  t183 = 0.13342809400364015280213860222187919752221792168441e-2 * t182
  t184 = s0 ** 2
  t185 = t184 * t22
  t189 = 0.1e1 / t18 / t85 * t27 * t77
  t191 = 0.30797417856580405117526443733602495357666385910391e-3 * t185 * t189
  t195 = t54 * (0.1e1 + t182 / 0.24e2)
  t197 = 0.34435261707988980716253443526170798898071625344353e-1 * t177 * t179 * t195
  t198 = t197 <= -t38
  t199 = t197 < -t38
  t200 = f.my_piecewise3(t199, -t38, t197)
  t202 = jnp.exp(-0.1e1 / t200)
  t203 = f.my_piecewise3(t198, 0, t202)
  t204 = 0.1e0 + t183 + t191 - t45
  t206 = -0.174e0 - t183 - t191 + t45 + t203 * t204
  t207 = t176 * t206
  t208 = t182 / 0.600e3
  t209 = t208 <= -t38
  t210 = t208 < -t38
  t211 = f.my_piecewise3(t210, -t38, t208)
  t213 = jnp.exp(-0.1e1 / t211)
  t214 = f.my_piecewise3(t209, 0, t213)
  t215 = 0.1e1 - t214
  t217 = 0.1174e1 - t45 + t207 * t215
  t221 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t217)
  t227 = t41 ** 2
  t228 = 0.1e1 / t227
  t230 = t20 / t34
  t235 = t27 * t31
  t239 = f.my_piecewise3(t40, 0, -0.22456215992867905800665153117708747369815701835347e-1 * t230 * t21 * t22 / t18 / t71 * t235)
  t242 = f.my_piecewise3(t39, 0, t228 * t239 * t43)
  t243 = 0.1174e1 * t242
  t245 = t47 * t179 * t64
  t251 = f.my_piecewise3(t61, s0 / t71 * t57 / 0.8e1, 0)
  t253 = t51 * t54 * t251
  t268 = t89 * t79
  t296 = t126 * t117
  t320 = 0.31108476573764614247467187830486235306457085948000e0 * t245 - 0.18665085944258768548480312698291741183874251568800e0 * t253 + 0.13276006905482099930553629613314731313825245266527e1 * t70 / t18 / t84 * t80 - 0.79656041432892599583321777679888387882951471599160e0 * t75 * t78 * t63 * t251 + 0.12127994393169335700604719324868730578010430075494e2 * t83 / t96 * t91 - 0.72767966359016014203628315949212383468062580452964e1 * t87 * t268 * t251 + 0.20366721970059730954017615110785910539278039700749e1 * t95 / t48 / t84 / t72 * t104 - 0.12220033182035838572410569066471546323566823820449e1 * t99 * t102 * t90 * t251 - 0.97293390171158390790900623025716290816545985624483e1 * t108 / t18 / t109 / r0 * t118 + 0.58376034102695034474540373815429774489927591374690e1 * t112 * t116 * t103 * t251 - 0.13980660423962914873101778938577720500503921055341e3 * t121 / t133 * t128 + 0.83883962543777489238610673631466323003023526332046e2 * t124 * t296 * t251 - 0.75906327972665286116401421551475375637290068646267e2 * t132 / t48 / t109 / t84 * t141 + 0.45543796783599171669840852930885225382374041187760e2 * t136 * t139 * t127 * t251 + 0.18830557165349172277967442758417532873729381323500e0 * t145 / t18 / t109 / t96 * t155 - 0.11298334299209503366780465655050519724237628794100e0 * t149 * t153 * t140 * t251
  t324 = f.my_piecewise3(t160, -0.25e2 / 0.27e2 * t245 + 0.5e1 / 0.9e1 * t253, 0)
  t327 = t161 ** 2
  t329 = t163 / t327
  t334 = t169 ** 2
  t338 = 0.1e1 / (0.1e1 + t29 * t334 / 0.4e1)
  t340 = f.my_piecewise3(t67, t320, (-0.12063067191025636561756297344054915325509498465082e1 * t324 * t164 - t329 * t324 - 0.22206712118690530507219997476860916252554783972356e1 * t166 * t324) * t338)
  t344 = 0.1e1 / t48 / t72
  t347 = t177 * t344 * t26 * t53
  t348 = 0.35580825067637374080570293925834452672591445782509e-2 * t347
  t353 = t185 / t18 / t96 * t27 * t77
  t354 = 0.16425289523509549396014103324587997524088739152209e-2 * t353
  t355 = t200 ** 2
  t356 = 0.1e1 / t355
  t362 = f.my_piecewise3(t199, 0, -0.91827364554637281910009182736455463728191000918275e-1 * t177 * t344 * t195 - 0.76522803795531068258340985613712886440159167431895e-2 * t353)
  t365 = f.my_piecewise3(t198, 0, t356 * t362 * t202)
  t372 = t211 ** 2
  t373 = 0.1e1 / t372
  t375 = f.my_piecewise3(t210, 0, -t347 / 0.225e3)
  t378 = f.my_piecewise3(t209, 0, t373 * t375 * t213)
  t385 = f.my_piecewise3(t2, 0, -t6 * t17 / t48 * t217 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (-t243 - t340 * t206 * t215 + t176 * (t348 + t354 + t243 + t365 * t204 + t203 * (-t348 - t354 - t243)) * t215 - t207 * t378))
  vrho_0_ = 0.2e1 * r0 * t385 + 0.2e1 * t221
  t394 = f.my_piecewise3(t40, 0, 0.84210809973254646752494324191407802636808881882550e-2 * t230 / t21 * t22 * t25 * t235)
  t397 = f.my_piecewise3(t39, 0, t228 * t394 * t43)
  t398 = 0.1174e1 * t397
  t401 = f.my_piecewise3(t61, -t55 * t57 / 0.8e1, 0)
  t403 = t51 * t54 * t401
  t433 = f.my_piecewise3(t160, 0.5e1 / 0.9e1 * t403, 0)
  t441 = f.my_piecewise3(t67, -0.18665085944258768548480312698291741183874251568800e0 * t403 - 0.79656041432892599583321777679888387882951471599160e0 * t75 * t78 * t63 * t401 - 0.72767966359016014203628315949212383468062580452964e1 * t87 * t268 * t401 - 0.12220033182035838572410569066471546323566823820449e1 * t99 * t102 * t90 * t401 + 0.58376034102695034474540373815429774489927591374690e1 * t112 * t116 * t103 * t401 + 0.83883962543777489238610673631466323003023526332046e2 * t124 * t296 * t401 + 0.45543796783599171669840852930885225382374041187760e2 * t136 * t139 * t127 * t401 - 0.11298334299209503366780465655050519724237628794100e0 * t149 * t153 * t140 * t401, (-0.12063067191025636561756297344054915325509498465082e1 * t433 * t164 - t329 * t433 - 0.22206712118690530507219997476860916252554783972356e1 * t166 * t433) * t338)
  t444 = t46 * t179
  t445 = t444 * t54
  t446 = 0.13342809400364015280213860222187919752221792168441e-2 * t445
  t448 = s0 * t22 * t189
  t449 = 0.61594835713160810235052887467204990715332771820782e-3 * t448
  t454 = f.my_piecewise3(t199, 0, 0.34435261707988980716253443526170798898071625344353e-1 * t444 * t195 + 0.28696051423324150596877869605142332415059687786961e-2 * t448)
  t457 = f.my_piecewise3(t198, 0, t356 * t454 * t202)
  t465 = f.my_piecewise3(t210, 0, t445 / 0.600e3)
  t468 = f.my_piecewise3(t209, 0, t373 * t465 * t213)
  t474 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (-t398 - t441 * t206 * t215 + t176 * (-t446 - t449 + t398 + t457 * t204 + t203 * (t446 + t449 - t398)) * t215 - t207 * t468))
  vsigma_0_ = 0.2e1 * r0 * t474
  vlapl_0_ = 0.0e0
  t478 = t46 * t50 * t64
  t483 = f.my_piecewise3(t61, t56 / t69 / 0.8e1, 0)
  t485 = t51 * t54 * t483
  t539 = -0.18665085944258768548480312698291741183874251568800e0 * t478 - 0.18665085944258768548480312698291741183874251568800e0 * t485 - 0.79656041432892599583321777679888387882951471599160e0 * tau0 * t22 * t74 * t80 - 0.79656041432892599583321777679888387882951471599160e0 * t75 * t78 * t63 * t483 - 0.72767966359016014203628315949212383468062580452964e1 * t69 * t86 * t91 - 0.72767966359016014203628315949212383468062580452964e1 * t87 * t268 * t483 - 0.12220033182035838572410569066471546323566823820449e1 * t83 * t46 * t98 * t104 - 0.12220033182035838572410569066471546323566823820449e1 * t99 * t102 * t90 * t483 + 0.58376034102695034474540373815429774489927591374690e1 * t94 * t22 * t111 * t118 + 0.58376034102695034474540373815429774489927591374690e1 * t112 * t116 * t103 * t483 + 0.83883962543777489238610673631466323003023526332046e2 * t107 * t123 * t128 + 0.83883962543777489238610673631466323003023526332046e2 * t124 * t296 * t483 + 0.45543796783599171669840852930885225382374041187760e2 * t121 * t46 * t135 * t141 + 0.45543796783599171669840852930885225382374041187760e2 * t136 * t139 * t127 * t483 - 0.11298334299209503366780465655050519724237628794100e0 * t131 * t22 * t148 * t155 - 0.11298334299209503366780465655050519724237628794100e0 * t149 * t153 * t140 * t483
  t542 = f.my_piecewise3(t160, 0.5e1 / 0.9e1 * t478 + 0.5e1 / 0.9e1 * t485, 0)
  t550 = f.my_piecewise3(t67, t539, (-0.12063067191025636561756297344054915325509498465082e1 * t542 * t164 - t329 * t542 - 0.22206712118690530507219997476860916252554783972356e1 * t166 * t542) * t338)
  t556 = f.my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t6 * t17 * t18 * t550 * t206 * t215)
  vtau_0_ = 0.2e1 * r0 * t556
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t22 = jnp.sqrt(0.3e1)
  t23 = jnp.sqrt(s0)
  t24 = 2 ** (0.1e1 / 0.3e1)
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t31 = jnp.pi ** 2
  t32 = t31 ** (0.1e1 / 0.3e1)
  t33 = 0.1e1 / t32
  t35 = t23 * t24 / t18 / r0 * t29 * t33
  t36 = jnp.sqrt(t35)
  t38 = 0.33684323989301858700997729676563121054723552753020e-1 * t22 * t36
  t39 = jnp.log(DBL_EPSILON)
  t40 = 0.1e1 / t39
  t41 = t38 <= -t40
  t42 = t38 < -t40
  t43 = f.my_piecewise3(t42, -t40, t38)
  t45 = jnp.exp(-0.1e1 / t43)
  t46 = f.my_piecewise3(t41, 0, t45)
  t47 = 0.1174e1 * t46
  t48 = t24 ** 2
  t49 = tau0 * t48
  t51 = 0.1e1 / t19 / r0
  t52 = t49 * t51
  t53 = t32 ** 2
  t54 = 0.1e1 / t53
  t55 = t28 * t54
  t58 = 0.1e1 / tau0
  t60 = s0 / r0 * t58 / 0.8e1
  t62 = 0.0e0 < 0.9999999999e0 - t60
  t64 = f.my_piecewise3(t62, 0.1e1 - t60, 0.1e-9)
  t65 = t55 * t64
  t66 = t52 * t65
  t67 = 0.5e1 / 0.9e1 * t66
  t68 = t67 <= DBL_EPSILON
  t70 = tau0 ** 2
  t71 = t70 * t24
  t72 = r0 ** 2
  t73 = t72 * r0
  t75 = 0.1e1 / t18 / t73
  t76 = t71 * t75
  t78 = 0.1e1 / t32 / t31
  t79 = t29 * t78
  t80 = t64 ** 2
  t81 = t79 * t80
  t84 = t70 * tau0
  t85 = t72 ** 2
  t86 = t85 * r0
  t88 = t84 / t86
  t89 = t31 ** 2
  t90 = 0.1e1 / t89
  t91 = t80 * t64
  t92 = t90 * t91
  t95 = t70 ** 2
  t96 = t95 * t48
  t97 = t85 * t72
  t100 = t96 / t19 / t97
  t103 = t28 / t53 / t89
  t104 = t80 ** 2
  t105 = t103 * t104
  t109 = t95 * tau0 * t24
  t110 = t85 ** 2
  t113 = t109 / t18 / t110
  t117 = t29 / t32 / t89 / t31
  t118 = t104 * t64
  t119 = t117 * t118
  t122 = t95 * t70
  t123 = t110 * t72
  t125 = t122 / t123
  t126 = t89 ** 2
  t127 = 0.1e1 / t126
  t128 = t104 * t80
  t129 = t127 * t128
  t133 = t95 * t84 * t48
  t134 = t110 * t73
  t137 = t133 / t19 / t134
  t140 = t28 / t53 / t126
  t141 = t104 * t91
  t142 = t140 * t141
  t145 = t95 ** 2
  t146 = t145 * t24
  t147 = t110 * t86
  t150 = t146 / t18 / t147
  t154 = t29 / t32 / t126 / t31
  t155 = t104 ** 2
  t156 = t154 * t155
  t161 = DBL_EPSILON < t67
  t162 = f.my_piecewise3(t161, t67, DBL_EPSILON)
  t163 = t162 - 0.1e1
  t164 = 0.1e1 / t162
  t167 = t163 ** 2
  t169 = -0.12063067191025636561756297344054915325509498465082e1 * t163 * t164 - 0.11103356059345265253609998738430458126277391986178e1 * t167
  t172 = jnp.arctan(jnp.pi * t169 / 0.2e1)
  t175 = f.my_piecewise3(t68, 0.10000000000000000000000000000000000000000000000000e1 - 0.18665085944258768548480312698291741183874251568800e0 * t66 - 0.39828020716446299791660888839944193941475735799580e0 * t76 * t81 - 0.24255988786338671401209438649737461156020860150988e1 * t88 * t92 - 0.30550082955089596431026422666178865808917059551123e0 * t100 * t105 + 0.11675206820539006894908074763085954897985518274938e1 * t113 * t119 + 0.13980660423962914873101778938577720500503921055341e2 * t125 * t129 + 0.65062566833713102385486932758407464831962915982514e1 * t137 * t142 - 0.14122917874011879208475582068813149655297035992625e-1 * t150 * t156, 0.2e1 / jnp.pi * t172)
  t176 = 0.1e1 - t175
  t177 = s0 * t48
  t179 = 0.1e1 / t19 / t72
  t182 = t177 * t179 * t28 * t54
  t183 = 0.13342809400364015280213860222187919752221792168441e-2 * t182
  t184 = s0 ** 2
  t185 = t184 * t24
  t187 = 0.1e1 / t18 / t86
  t191 = 0.30797417856580405117526443733602495357666385910391e-3 * t185 * t187 * t29 * t78
  t195 = t55 * (0.1e1 + t182 / 0.24e2)
  t197 = 0.34435261707988980716253443526170798898071625344353e-1 * t177 * t179 * t195
  t198 = t197 <= -t40
  t199 = t197 < -t40
  t200 = f.my_piecewise3(t199, -t40, t197)
  t202 = jnp.exp(-0.1e1 / t200)
  t203 = f.my_piecewise3(t198, 0, t202)
  t204 = 0.1e0 + t183 + t191 - t47
  t206 = -0.174e0 - t183 - t191 + t47 + t203 * t204
  t207 = t176 * t206
  t208 = t182 / 0.600e3
  t209 = t208 <= -t40
  t210 = t208 < -t40
  t211 = f.my_piecewise3(t210, -t40, t208)
  t213 = jnp.exp(-0.1e1 / t211)
  t214 = f.my_piecewise3(t209, 0, t213)
  t215 = 0.1e1 - t214
  t217 = 0.1174e1 - t47 + t207 * t215
  t221 = t17 * t18
  t222 = t43 ** 2
  t223 = 0.1e1 / t222
  t226 = t22 / t36 * t23
  t230 = t29 * t33
  t234 = f.my_piecewise3(t42, 0, -0.22456215992867905800665153117708747369815701835347e-1 * t226 * t24 / t18 / t72 * t230)
  t237 = f.my_piecewise3(t41, 0, t223 * t234 * t45)
  t238 = 0.1174e1 * t237
  t239 = t49 * t179
  t240 = t239 * t65
  t246 = f.my_piecewise3(t62, s0 / t72 * t58 / 0.8e1, 0)
  t247 = t55 * t246
  t248 = t52 * t247
  t252 = t71 / t18 / t85
  t256 = t79 * t64 * t246
  t260 = t84 / t97
  t263 = t90 * t80
  t264 = t263 * t246
  t267 = t85 * t73
  t270 = t96 / t19 / t267
  t274 = t103 * t91 * t246
  t280 = t109 / t18 / t110 / r0
  t284 = t117 * t104 * t246
  t288 = t122 / t134
  t291 = t127 * t118
  t292 = t291 * t246
  t295 = t110 * t85
  t298 = t133 / t19 / t295
  t302 = t140 * t128 * t246
  t308 = t146 / t18 / t110 / t97
  t312 = t154 * t141 * t246
  t315 = 0.31108476573764614247467187830486235306457085948000e0 * t240 - 0.18665085944258768548480312698291741183874251568800e0 * t248 + 0.13276006905482099930553629613314731313825245266527e1 * t252 * t81 - 0.79656041432892599583321777679888387882951471599160e0 * t76 * t256 + 0.12127994393169335700604719324868730578010430075494e2 * t260 * t92 - 0.72767966359016014203628315949212383468062580452964e1 * t88 * t264 + 0.20366721970059730954017615110785910539278039700749e1 * t270 * t105 - 0.12220033182035838572410569066471546323566823820449e1 * t100 * t274 - 0.97293390171158390790900623025716290816545985624483e1 * t280 * t119 + 0.58376034102695034474540373815429774489927591374690e1 * t113 * t284 - 0.13980660423962914873101778938577720500503921055341e3 * t288 * t129 + 0.83883962543777489238610673631466323003023526332046e2 * t125 * t292 - 0.75906327972665286116401421551475375637290068646267e2 * t298 * t142 + 0.45543796783599171669840852930885225382374041187760e2 * t137 * t302 + 0.18830557165349172277967442758417532873729381323500e0 * t308 * t156 - 0.11298334299209503366780465655050519724237628794100e0 * t150 * t312
  t319 = f.my_piecewise3(t161, -0.25e2 / 0.27e2 * t240 + 0.5e1 / 0.9e1 * t248, 0)
  t322 = t162 ** 2
  t323 = 0.1e1 / t322
  t324 = t163 * t323
  t329 = -0.12063067191025636561756297344054915325509498465082e1 * t319 * t164 + 0.12063067191025636561756297344054915325509498465082e1 * t324 * t319 - 0.22206712118690530507219997476860916252554783972356e1 * t163 * t319
  t330 = t169 ** 2
  t333 = 0.1e1 + t31 * t330 / 0.4e1
  t334 = 0.1e1 / t333
  t336 = f.my_piecewise3(t68, t315, t329 * t334)
  t337 = t336 * t206
  t340 = 0.1e1 / t19 / t73
  t343 = t177 * t340 * t28 * t54
  t344 = 0.35580825067637374080570293925834452672591445782509e-2 * t343
  t349 = t185 / t18 / t97 * t29 * t78
  t350 = 0.16425289523509549396014103324587997524088739152209e-2 * t349
  t351 = t200 ** 2
  t352 = 0.1e1 / t351
  t358 = f.my_piecewise3(t199, 0, -0.91827364554637281910009182736455463728191000918275e-1 * t177 * t340 * t195 - 0.76522803795531068258340985613712886440159167431895e-2 * t349)
  t361 = f.my_piecewise3(t198, 0, t352 * t358 * t202)
  t363 = -t344 - t350 - t238
  t365 = t203 * t363 + t361 * t204 + t238 + t344 + t350
  t366 = t176 * t365
  t368 = t211 ** 2
  t369 = 0.1e1 / t368
  t371 = f.my_piecewise3(t210, 0, -t343 / 0.225e3)
  t374 = f.my_piecewise3(t209, 0, t369 * t371 * t213)
  t376 = -t207 * t374 - t337 * t215 + t366 * t215 - t238
  t381 = f.my_piecewise3(t2, 0, -t6 * t21 * t217 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t221 * t376)
  t392 = t234 ** 2
  t401 = 0.1e1 / t19 / t85
  t411 = f.my_piecewise3(t42, 0, -0.89824863971471623202660612470834989479262807341388e-1 * t22 / t36 / t35 * s0 * t48 * t401 * t55 + 0.52397837316691780201552023941320410529569970949143e-1 * t226 * t24 * t75 * t230)
  t414 = t222 ** 2
  t419 = f.my_piecewise3(t41, 0, -0.2e1 / t222 / t43 * t392 * t45 + t223 * t411 * t45 + 0.1e1 / t414 * t392 * t45)
  t420 = 0.1174e1 * t419
  t422 = t246 ** 2
  t432 = f.my_piecewise3(t62, -s0 / t73 * t58 / 0.4e1, 0)
  t473 = t49 * t340 * t65
  t475 = t239 * t247
  t478 = t52 * t55 * t432
  t480 = 0.41941981271888744619305336815733161501511763166023e3 * t125 * t127 * t104 * t422 + 0.72767966359016014203628315949212383468062580452964e2 * t260 * t264 - 0.72767966359016014203628315949212383468062580452964e1 * t88 * t263 * t432 - 0.16776792508755497847722134726293264600604705266409e4 * t288 * t292 + 0.83883962543777489238610673631466323003023526332046e2 * t125 * t291 * t432 - 0.14553593271803202840725663189842476693612516090593e2 * t88 * t90 * t64 * t422 + 0.96148015432042695747441800631868809140567420285272e3 * t133 / t19 / t147 * t142 - 0.26990465270333813598420001287065130452345446563683e1 * t146 / t18 / t110 / t267 * t156 - 0.57529363257089099699065728324363835693242729488284e1 * t71 * t187 * t81 - 0.79656041432892599583321777679888387882951471599160e0 * t76 * t79 * t422 - 0.15614486843712460398080171584935864746779830437241e2 * t96 / t19 / t110 * t105 + 0.90807164159747831404840581490668538095442919916184e2 * t109 / t18 / t123 * t119 - 0.82955937530038971326579167547963294150552229194667e0 * t473 + 0.62216953147529228494934375660972470612914171896000e0 * t475 - 0.18665085944258768548480312698291741183874251568800e0 * t478
  t535 = -0.72767966359016014203628315949212383468062580452964e2 * t84 / t267 * t92 + 0.15378726466359206360411956832435492550554313160875e4 * t122 / t295 * t129 + 0.58376034102695034474540373815429774489927591374690e1 * t113 * t117 * t104 * t432 - 0.10626885916173140056296199017206552589220609610477e4 * t298 * t302 + 0.45543796783599171669840852930885225382374041187760e2 * t137 * t140 * t128 * t432 + 0.30128891464558675644747908413468052597967010117600e1 * t308 * t312 - 0.11298334299209503366780465655050519724237628794100e0 * t150 * t154 * t141 * t432 + 0.53104027621928399722214518453258925255300981066107e1 * t252 * t256 + 0.23350413641078013789816149526171909795971036549876e2 * t113 * t117 * t91 * t422 + 0.27326278070159503001904511758531135229424424712656e3 * t137 * t140 * t118 * t422 - 0.79088340094466523567463259585353638069663401558700e0 * t150 * t154 * t128 * t422 - 0.36660099546107515717231707199414638970700471461347e1 * t100 * t103 * t80 * t422 - 0.79656041432892599583321777679888387882951471599160e0 * t76 * t79 * t64 * t432 + 0.16293377576047784763214092088628728431422431760599e2 * t270 * t274 - 0.12220033182035838572410569066471546323566823820449e1 * t100 * t103 * t91 * t432 - 0.97293390171158390790900623025716290816545985624484e2 * t280 * t284
  t541 = f.my_piecewise3(t161, 0.200e3 / 0.81e2 * t473 - 0.50e2 / 0.27e2 * t475 + 0.5e1 / 0.9e1 * t478, 0)
  t544 = t319 ** 2
  t559 = t329 ** 2
  t560 = t333 ** 2
  t567 = f.my_piecewise3(t68, t480 + t535, (-0.12063067191025636561756297344054915325509498465082e1 * t541 * t164 + 0.24126134382051273123512594688109830651018996930164e1 * t544 * t323 - 0.24126134382051273123512594688109830651018996930164e1 * t163 / t322 / t162 * t544 + 0.12063067191025636561756297344054915325509498465082e1 * t324 * t541 - 0.22206712118690530507219997476860916252554783972356e1 * t544 - 0.22206712118690530507219997476860916252554783972356e1 * t163 * t541) * t334 - t559 / t560 * t31 * t169 / 0.2e1)
  t577 = t177 * t401 * t28 * t54
  t578 = 0.13046302524800370496209107772805965979950196786920e-1 * t577
  t583 = t185 / t18 / t267 * t29 * t78
  t584 = 0.10402683364889381284142265438905731765256201463066e-1 * t583
  t587 = t358 ** 2
  t596 = f.my_piecewise3(t199, 0, 0.33670033670033670033670033670033670033670033670034e0 * t177 * t401 * t195 + 0.68870523415977961432506887052341597796143250688706e-1 * t583)
  t599 = t351 ** 2
  t604 = f.my_piecewise3(t198, 0, -0.2e1 / t351 / t200 * t587 * t202 + t352 * t596 * t202 + 0.1e1 / t599 * t587 * t202)
  t617 = t371 ** 2
  t622 = f.my_piecewise3(t210, 0, 0.11e2 / 0.675e3 * t577)
  t625 = t368 ** 2
  t630 = f.my_piecewise3(t209, 0, -0.2e1 / t368 / t211 * t617 * t213 + t369 * t622 * t213 + 0.1e1 / t625 * t617 * t213)
  t637 = f.my_piecewise3(t2, 0, t6 * t17 * t51 * t217 / 0.12e2 - t6 * t21 * t376 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t221 * (-t420 - t567 * t206 * t215 - 0.2e1 * t336 * t365 * t215 + 0.2e1 * t337 * t374 + t176 * (-t578 - t584 + t420 + t604 * t204 + 0.2e1 * t361 * t363 + t203 * (t578 + t584 - t420)) * t215 - 0.2e1 * t366 * t374 - t207 * t630))
  v2rho2_0_ = 0.2e1 * r0 * t637 + 0.4e1 * t381
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = 0.1e1 / t19 / r0
  t22 = t17 * t21
  t23 = jnp.sqrt(0.3e1)
  t24 = jnp.sqrt(s0)
  t25 = 2 ** (0.1e1 / 0.3e1)
  t29 = 6 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t32 = jnp.pi ** 2
  t33 = t32 ** (0.1e1 / 0.3e1)
  t34 = 0.1e1 / t33
  t36 = t24 * t25 / t18 / r0 * t30 * t34
  t37 = jnp.sqrt(t36)
  t39 = 0.33684323989301858700997729676563121054723552753020e-1 * t23 * t37
  t40 = jnp.log(DBL_EPSILON)
  t41 = 0.1e1 / t40
  t42 = t39 <= -t41
  t43 = t39 < -t41
  t44 = f.my_piecewise3(t43, -t41, t39)
  t46 = jnp.exp(-0.1e1 / t44)
  t47 = f.my_piecewise3(t42, 0, t46)
  t48 = 0.1174e1 * t47
  t49 = t25 ** 2
  t50 = tau0 * t49
  t51 = t50 * t21
  t52 = t33 ** 2
  t53 = 0.1e1 / t52
  t54 = t29 * t53
  t57 = 0.1e1 / tau0
  t59 = s0 / r0 * t57 / 0.8e1
  t61 = 0.0e0 < 0.9999999999e0 - t59
  t63 = f.my_piecewise3(t61, 0.1e1 - t59, 0.1e-9)
  t64 = t54 * t63
  t65 = t51 * t64
  t66 = 0.5e1 / 0.9e1 * t65
  t67 = t66 <= DBL_EPSILON
  t69 = tau0 ** 2
  t70 = t69 * t25
  t71 = r0 ** 2
  t72 = t71 * r0
  t74 = 0.1e1 / t18 / t72
  t75 = t70 * t74
  t77 = 0.1e1 / t33 / t32
  t78 = t30 * t77
  t79 = t63 ** 2
  t80 = t78 * t79
  t83 = t69 * tau0
  t84 = t71 ** 2
  t85 = t84 * r0
  t87 = t83 / t85
  t88 = t32 ** 2
  t89 = 0.1e1 / t88
  t90 = t79 * t63
  t91 = t89 * t90
  t94 = t69 ** 2
  t95 = t94 * t49
  t96 = t84 * t71
  t98 = 0.1e1 / t19 / t96
  t99 = t95 * t98
  t101 = 0.1e1 / t52 / t88
  t102 = t29 * t101
  t103 = t79 ** 2
  t104 = t102 * t103
  t108 = t94 * tau0 * t25
  t109 = t84 ** 2
  t111 = 0.1e1 / t18 / t109
  t112 = t108 * t111
  t115 = 0.1e1 / t33 / t88 / t32
  t116 = t30 * t115
  t117 = t103 * t63
  t118 = t116 * t117
  t121 = t94 * t69
  t122 = t109 * t71
  t124 = t121 / t122
  t125 = t88 ** 2
  t126 = 0.1e1 / t125
  t127 = t103 * t79
  t128 = t126 * t127
  t132 = t94 * t83 * t49
  t133 = t109 * t72
  t135 = 0.1e1 / t19 / t133
  t136 = t132 * t135
  t138 = 0.1e1 / t52 / t125
  t139 = t29 * t138
  t140 = t103 * t90
  t141 = t139 * t140
  t144 = t94 ** 2
  t145 = t144 * t25
  t146 = t109 * t85
  t148 = 0.1e1 / t18 / t146
  t149 = t145 * t148
  t152 = 0.1e1 / t33 / t125 / t32
  t153 = t30 * t152
  t154 = t103 ** 2
  t155 = t153 * t154
  t160 = DBL_EPSILON < t66
  t161 = f.my_piecewise3(t160, t66, DBL_EPSILON)
  t162 = t161 - 0.1e1
  t163 = 0.1e1 / t161
  t166 = t162 ** 2
  t168 = -0.12063067191025636561756297344054915325509498465082e1 * t162 * t163 - 0.11103356059345265253609998738430458126277391986178e1 * t166
  t171 = jnp.atan(jnp.pi * t168 / 0.2e1)
  t174 = f.my_piecewise3(t67, 0.10000000000000000000000000000000000000000000000000e1 - 0.18665085944258768548480312698291741183874251568800e0 * t65 - 0.39828020716446299791660888839944193941475735799580e0 * t75 * t80 - 0.24255988786338671401209438649737461156020860150988e1 * t87 * t91 - 0.30550082955089596431026422666178865808917059551123e0 * t99 * t104 + 0.11675206820539006894908074763085954897985518274938e1 * t112 * t118 + 0.13980660423962914873101778938577720500503921055341e2 * t124 * t128 + 0.65062566833713102385486932758407464831962915982514e1 * t136 * t141 - 0.14122917874011879208475582068813149655297035992625e-1 * t149 * t155, 0.2e1 / jnp.pi * t171)
  t175 = 0.1e1 - t174
  t176 = s0 * t49
  t178 = 0.1e1 / t19 / t71
  t181 = t176 * t178 * t29 * t53
  t182 = 0.13342809400364015280213860222187919752221792168441e-2 * t181
  t183 = s0 ** 2
  t184 = t183 * t25
  t186 = 0.1e1 / t18 / t85
  t190 = 0.30797417856580405117526443733602495357666385910391e-3 * t184 * t186 * t30 * t77
  t194 = t54 * (0.1e1 + t181 / 0.24e2)
  t196 = 0.34435261707988980716253443526170798898071625344353e-1 * t176 * t178 * t194
  t197 = t196 <= -t41
  t198 = t196 < -t41
  t199 = f.my_piecewise3(t198, -t41, t196)
  t201 = jnp.exp(-0.1e1 / t199)
  t202 = f.my_piecewise3(t197, 0, t201)
  t203 = 0.1e0 + t182 + t190 - t48
  t205 = -0.174e0 - t182 - t190 + t48 + t202 * t203
  t206 = t175 * t205
  t207 = t181 / 0.600e3
  t208 = t207 <= -t41
  t209 = t207 < -t41
  t210 = f.my_piecewise3(t209, -t41, t207)
  t212 = jnp.exp(-0.1e1 / t210)
  t213 = f.my_piecewise3(t208, 0, t212)
  t214 = 0.1e1 - t213
  t216 = 0.1174e1 - t48 + t206 * t214
  t221 = t17 / t19
  t222 = t44 ** 2
  t223 = 0.1e1 / t222
  t226 = t23 / t37 * t24
  t230 = t30 * t34
  t234 = f.my_piecewise3(t43, 0, -0.22456215992867905800665153117708747369815701835347e-1 * t226 * t25 / t18 / t71 * t230)
  t237 = f.my_piecewise3(t42, 0, t223 * t234 * t46)
  t238 = 0.1174e1 * t237
  t239 = t50 * t178
  t240 = t239 * t64
  t246 = f.my_piecewise3(t61, s0 / t71 * t57 / 0.8e1, 0)
  t247 = t54 * t246
  t248 = t51 * t247
  t251 = 0.1e1 / t18 / t84
  t252 = t70 * t251
  t255 = t63 * t246
  t256 = t78 * t255
  t260 = t83 / t96
  t263 = t89 * t79
  t264 = t263 * t246
  t267 = t84 * t72
  t270 = t95 / t19 / t267
  t274 = t102 * t90 * t246
  t277 = t109 * r0
  t280 = t108 / t18 / t277
  t283 = t103 * t246
  t284 = t116 * t283
  t288 = t121 / t133
  t291 = t126 * t117
  t292 = t291 * t246
  t295 = t109 * t84
  t298 = t132 / t19 / t295
  t302 = t139 * t127 * t246
  t305 = t109 * t96
  t308 = t145 / t18 / t305
  t312 = t153 * t140 * t246
  t315 = 0.31108476573764614247467187830486235306457085948000e0 * t240 - 0.18665085944258768548480312698291741183874251568800e0 * t248 + 0.13276006905482099930553629613314731313825245266527e1 * t252 * t80 - 0.79656041432892599583321777679888387882951471599160e0 * t75 * t256 + 0.12127994393169335700604719324868730578010430075494e2 * t260 * t91 - 0.72767966359016014203628315949212383468062580452964e1 * t87 * t264 + 0.20366721970059730954017615110785910539278039700749e1 * t270 * t104 - 0.12220033182035838572410569066471546323566823820449e1 * t99 * t274 - 0.97293390171158390790900623025716290816545985624483e1 * t280 * t118 + 0.58376034102695034474540373815429774489927591374690e1 * t112 * t284 - 0.13980660423962914873101778938577720500503921055341e3 * t288 * t128 + 0.83883962543777489238610673631466323003023526332046e2 * t124 * t292 - 0.75906327972665286116401421551475375637290068646267e2 * t298 * t141 + 0.45543796783599171669840852930885225382374041187760e2 * t136 * t302 + 0.18830557165349172277967442758417532873729381323500e0 * t308 * t155 - 0.11298334299209503366780465655050519724237628794100e0 * t149 * t312
  t319 = f.my_piecewise3(t160, -0.25e2 / 0.27e2 * t240 + 0.5e1 / 0.9e1 * t248, 0)
  t322 = t161 ** 2
  t323 = 0.1e1 / t322
  t324 = t162 * t323
  t329 = -0.12063067191025636561756297344054915325509498465082e1 * t319 * t163 + 0.12063067191025636561756297344054915325509498465082e1 * t324 * t319 - 0.22206712118690530507219997476860916252554783972356e1 * t162 * t319
  t330 = t168 ** 2
  t333 = 0.1e1 + t32 * t330 / 0.4e1
  t334 = 0.1e1 / t333
  t336 = f.my_piecewise3(t67, t315, t329 * t334)
  t337 = t336 * t205
  t340 = 0.1e1 / t19 / t72
  t343 = t176 * t340 * t29 * t53
  t344 = 0.35580825067637374080570293925834452672591445782509e-2 * t343
  t346 = 0.1e1 / t18 / t96
  t349 = t184 * t346 * t30 * t77
  t350 = 0.16425289523509549396014103324587997524088739152209e-2 * t349
  t351 = t199 ** 2
  t352 = 0.1e1 / t351
  t358 = f.my_piecewise3(t198, 0, -0.91827364554637281910009182736455463728191000918275e-1 * t176 * t340 * t194 - 0.76522803795531068258340985613712886440159167431895e-2 * t349)
  t361 = f.my_piecewise3(t197, 0, t352 * t358 * t201)
  t363 = -t344 - t350 - t238
  t365 = t202 * t363 + t361 * t203 + t238 + t344 + t350
  t366 = t175 * t365
  t368 = t210 ** 2
  t369 = 0.1e1 / t368
  t371 = f.my_piecewise3(t209, 0, -t343 / 0.225e3)
  t374 = f.my_piecewise3(t208, 0, t369 * t371 * t212)
  t376 = -t206 * t374 - t337 * t214 + t366 * t214 - t238
  t380 = t17 * t18
  t382 = 0.1e1 / t222 / t44
  t383 = t234 ** 2
  t390 = t23 / t37 / t36 * s0
  t392 = 0.1e1 / t19 / t84
  t402 = f.my_piecewise3(t43, 0, -0.89824863971471623202660612470834989479262807341388e-1 * t390 * t49 * t392 * t54 + 0.52397837316691780201552023941320410529569970949143e-1 * t226 * t25 * t74 * t230)
  t405 = t222 ** 2
  t406 = 0.1e1 / t405
  t410 = f.my_piecewise3(t42, 0, t223 * t402 * t46 - 0.2e1 * t382 * t383 * t46 + t406 * t383 * t46)
  t411 = 0.1174e1 * t410
  t413 = t246 ** 2
  t414 = t89 * t63 * t413
  t418 = t126 * t103 * t413
  t427 = f.my_piecewise3(t61, -s0 / t72 * t57 / 0.4e1, 0)
  t428 = t263 * t427
  t433 = t291 * t427
  t437 = t102 * t90 * t427
  t443 = t116 * t103 * t427
  t449 = t139 * t127 * t427
  t455 = t153 * t140 * t427
  t461 = t102 * t79 * t413
  t464 = -0.14553593271803202840725663189842476693612516090593e2 * t87 * t414 + 0.41941981271888744619305336815733161501511763166023e3 * t124 * t418 + 0.72767966359016014203628315949212383468062580452964e2 * t260 * t264 - 0.72767966359016014203628315949212383468062580452964e1 * t87 * t428 - 0.16776792508755497847722134726293264600604705266409e4 * t288 * t292 + 0.83883962543777489238610673631466323003023526332046e2 * t124 * t433 - 0.12220033182035838572410569066471546323566823820449e1 * t99 * t437 - 0.97293390171158390790900623025716290816545985624484e2 * t280 * t284 + 0.58376034102695034474540373815429774489927591374690e1 * t112 * t443 - 0.10626885916173140056296199017206552589220609610477e4 * t298 * t302 + 0.45543796783599171669840852930885225382374041187760e2 * t136 * t449 + 0.30128891464558675644747908413468052597967010117600e1 * t308 * t312 - 0.11298334299209503366780465655050519724237628794100e0 * t149 * t455 + 0.53104027621928399722214518453258925255300981066107e1 * t252 * t256 - 0.36660099546107515717231707199414638970700471461347e1 * t99 * t461
  t466 = t116 * t90 * t413
  t470 = t139 * t117 * t413
  t474 = t153 * t127 * t413
  t478 = t78 * t63 * t427
  t485 = t95 / t19 / t109
  t490 = t108 / t18 / t122
  t495 = t132 / t19 / t146
  t501 = t145 / t18 / t109 / t267
  t504 = t70 * t186
  t507 = t78 * t413
  t510 = t50 * t340
  t511 = t510 * t64
  t513 = t239 * t247
  t515 = t54 * t427
  t516 = t51 * t515
  t518 = 0.1e1 / t267
  t519 = t83 * t518
  t523 = t121 / t295
  t526 = 0.23350413641078013789816149526171909795971036549876e2 * t112 * t466 + 0.27326278070159503001904511758531135229424424712656e3 * t136 * t470 - 0.79088340094466523567463259585353638069663401558700e0 * t149 * t474 - 0.79656041432892599583321777679888387882951471599160e0 * t75 * t478 + 0.16293377576047784763214092088628728431422431760599e2 * t270 * t274 - 0.15614486843712460398080171584935864746779830437241e2 * t485 * t104 + 0.90807164159747831404840581490668538095442919916184e2 * t490 * t118 + 0.96148015432042695747441800631868809140567420285272e3 * t495 * t141 - 0.26990465270333813598420001287065130452345446563683e1 * t501 * t155 - 0.57529363257089099699065728324363835693242729488284e1 * t504 * t80 - 0.79656041432892599583321777679888387882951471599160e0 * t75 * t507 - 0.82955937530038971326579167547963294150552229194667e0 * t511 + 0.62216953147529228494934375660972470612914171896000e0 * t513 - 0.18665085944258768548480312698291741183874251568800e0 * t516 - 0.72767966359016014203628315949212383468062580452964e2 * t519 * t91 + 0.15378726466359206360411956832435492550554313160875e4 * t523 * t128
  t532 = f.my_piecewise3(t160, 0.200e3 / 0.81e2 * t511 - 0.50e2 / 0.27e2 * t513 + 0.5e1 / 0.9e1 * t516, 0)
  t535 = t319 ** 2
  t539 = 0.1e1 / t322 / t161
  t540 = t162 * t539
  t548 = -0.12063067191025636561756297344054915325509498465082e1 * t532 * t163 + 0.24126134382051273123512594688109830651018996930164e1 * t535 * t323 - 0.24126134382051273123512594688109830651018996930164e1 * t540 * t535 + 0.12063067191025636561756297344054915325509498465082e1 * t324 * t532 - 0.22206712118690530507219997476860916252554783972356e1 * t535 - 0.22206712118690530507219997476860916252554783972356e1 * t162 * t532
  t550 = t329 ** 2
  t551 = t333 ** 2
  t552 = 0.1e1 / t551
  t554 = t32 * t168
  t558 = f.my_piecewise3(t67, t464 + t526, t548 * t334 - t550 * t552 * t554 / 0.2e1)
  t559 = t558 * t205
  t561 = t336 * t365
  t568 = t176 * t392 * t29 * t53
  t569 = 0.13046302524800370496209107772805965979950196786920e-1 * t568
  t574 = t184 / t18 / t267 * t30 * t77
  t575 = 0.10402683364889381284142265438905731765256201463066e-1 * t574
  t577 = 0.1e1 / t351 / t199
  t578 = t358 ** 2
  t587 = f.my_piecewise3(t198, 0, 0.33670033670033670033670033670033670033670033670034e0 * t176 * t392 * t194 + 0.68870523415977961432506887052341597796143250688706e-1 * t574)
  t590 = t351 ** 2
  t591 = 0.1e1 / t590
  t595 = f.my_piecewise3(t197, 0, t352 * t587 * t201 - 0.2e1 * t577 * t578 * t201 + t591 * t578 * t201)
  t599 = t569 + t575 - t411
  t601 = t202 * t599 + t595 * t203 + 0.2e1 * t361 * t363 + t411 - t569 - t575
  t602 = t175 * t601
  t607 = 0.1e1 / t368 / t210
  t608 = t371 ** 2
  t613 = f.my_piecewise3(t209, 0, 0.11e2 / 0.675e3 * t568)
  t616 = t368 ** 2
  t617 = 0.1e1 / t616
  t621 = f.my_piecewise3(t208, 0, t369 * t613 * t212 - 0.2e1 * t607 * t608 * t212 + t617 * t608 * t212)
  t623 = -t206 * t621 - t559 * t214 - 0.2e1 * t561 * t214 + t602 * t214 + 0.2e1 * t337 * t374 - 0.2e1 * t366 * t374 - t411
  t628 = f.my_piecewise3(t2, 0, t6 * t22 * t216 / 0.12e2 - t6 * t221 * t376 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t380 * t623)
  t640 = t383 * t234
  t664 = 0.1e1 / t19 / t85
  t674 = f.my_piecewise3(t43, 0, -0.35929945588588649281064244988333995791705122936555e0 * t23 / t37 / t181 * t24 * s0 * t518 / t32 + 0.62877404780030136241862428729584492635483965138971e0 * t390 * t49 * t664 * t54 - 0.17465945772230593400517341313773470176523323649714e0 * t226 * t25 * t251 * t230)
  t686 = f.my_piecewise3(t42, 0, 0.6e1 * t406 * t640 * t46 - 0.6e1 * t382 * t234 * t46 * t402 - 0.6e1 / t405 / t44 * t640 * t46 + t223 * t674 * t46 + 0.3e1 * t406 * t402 * t234 * t46 + 0.1e1 / t405 / t222 * t640 * t46)
  t687 = 0.1174e1 * t686
  t696 = f.my_piecewise3(t61, 0.3e1 / 0.4e1 * s0 / t84 * t57, 0)
  t710 = t413 * t246
  t719 = t246 * t427
  t723 = t111 * t30
  t741 = 0.27681707639446571448741522298383886590997763689575e5 * t523 * t292 + 0.10915194953852402130544247392381857520209387067945e3 * t260 * t428 - 0.72767966359016014203628315949212383468062580452964e1 * t87 * t263 * t696 - 0.25165188763133246771583202089439896900907057899614e4 * t288 * t433 + 0.83883962543777489238610673631466323003023526332046e2 * t124 * t291 * t696 + 0.21830389907704804261088494784763715040418774135890e3 * t260 * t414 - 0.12582594381566623385791601044719948450453528949807e5 * t288 * t418 + 0.16776792508755497847722134726293264600604705266409e4 * t124 * t126 * t90 * t710 - 0.65491169723114412783265484354291145121256322407667e3 * t519 * t264 - 0.10998029863832254715169512159824391691210141438404e2 * t95 * t98 * t29 * t101 * t79 * t719 + 0.70051240923234041369448448578515729387913109649628e2 * t108 * t723 * t115 * t90 * t719 + 0.81978834210478509005713535275593405688273274137968e3 * t132 * t135 * t29 * t138 * t117 * t719 - 0.23726502028339957070238977875606091420899020467610e1 * t145 * t148 * t30 * t152 * t127 * t719
  t780 = -0.73320199092215031434463414398829277941400942922694e1 * t99 * t102 * t63 * t710 - 0.58376034102695034474540373815429774489927591374691e3 * t280 * t466 + 0.70051240923234041369448448578515729387913109649628e2 * t112 * t116 * t79 * t710 - 0.95641973245558260506665791154858973302985486494294e4 * t298 * t470 + 0.13663139035079751500952255879265567614712212356328e4 * t136 * t139 * t103 * t710 + 0.31635336037786609426985303834141455227865360623480e2 * t308 * t474 - 0.47453004056679914140477955751212182841798040935220e1 * t149 * t153 * t117 * t710 + 0.79656041432892599583321777679888387882951471599160e1 * t252 * t478 + 0.73320199092215031434463414398829277941400942922695e2 * t270 * t461 - 0.79656041432892599583321777679888387882951471599160e0 * t75 * t78 * t63 * t696 + 0.24440066364071677144821138132943092647133647640898e2 * t270 * t437 - 0.12220033182035838572410569066471546323566823820449e1 * t99 * t102 * t90 * t696 - 0.14594008525673758618635093453857443622481897843673e3 * t280 * t443
  t819 = 0.58376034102695034474540373815429774489927591374690e1 * t112 * t116 * t103 * t696 - 0.15940328874259710084444298525809828883830914415716e4 * t298 * t449 + 0.45543796783599171669840852930885225382374041187760e2 * t136 * t139 * t127 * t696 + 0.45193337196838013467121862620202078896950515176400e1 * t308 * t455 - 0.11298334299209503366780465655050519724237628794100e0 * t149 * t153 * t140 * t696 + 0.13621074623962174710726087223600280714316437987428e4 * t490 * t284 + 0.20191083240728966106962778132692449919519158259907e5 * t495 * t302 - 0.64777116648801152636208003088956313085629071752839e2 * t501 * t312 - 0.34517617954253459819439436994618301415945637692970e2 * t504 * t256 - 0.23896812429867779874996533303966516364885441479748e1 * t75 * t78 * t719 - 0.18737384212454952477696205901923037696135796524689e3 * t485 * t274 - 0.43660779815409608522176989569527430080837548271779e2 * t87 * t89 * t255 * t427 + 0.12582594381566623385791601044719948450453528949807e4 * t124 * t126 * t283 * t427
  t826 = t50 * t392 * t64
  t828 = t510 * t247
  t830 = t239 * t515
  t833 = t51 * t54 * t696
  t845 = t109 ** 2
  t867 = 0.13532555264550799011669482040277749447209186378942e3 * t95 / t19 / t277 * t104 + 0.30417177094347622819745694767586541188535817371378e1 * t826 - 0.24886781259011691397973750264388988245165668758400e1 * t828 + 0.93325429721293842742401563491458705919371257844000e0 * t830 - 0.18665085944258768548480312698291741183874251568800e0 * t833 - 0.93834069631739425785001934207024156031957683913390e3 * t108 / t18 / t133 * t118 - 0.13140228775712501752150379419688737249210880772321e5 * t132 / t19 / t305 * t141 + 0.41385380081178514184244001973499866693596351397647e2 * t145 / t18 / t845 * t155 + 0.30682327070447519839501721772994045703062789060418e2 * t70 * t346 * t80 + 0.79656041432892599583321777679888387882951471599160e1 * t252 * t507 - 0.14553593271803202840725663189842476693612516090593e2 * t87 * t89 * t710 + 0.50937576451311209942539821164448668427643806317075e3 * t83 / t109 * t91 - 0.18454471759631047632494348198922591060665175793050e5 * t121 / t146 * t128
  t875 = f.my_piecewise3(t160, -0.2200e4 / 0.243e3 * t826 + 0.200e3 / 0.27e2 * t828 - 0.25e2 / 0.9e1 * t830 + 0.5e1 / 0.9e1 * t833, 0)
  t881 = t535 * t319
  t884 = t322 ** 2
  t889 = t319 * t532
  t903 = t550 * t329
  t914 = f.my_piecewise3(t67, t741 + t780 + t819 + t867, (-0.12063067191025636561756297344054915325509498465082e1 * t875 * t163 + 0.72378403146153819370537784064329491953056990790492e1 * t532 * t323 * t319 - 0.72378403146153819370537784064329491953056990790492e1 * t881 * t539 + 0.72378403146153819370537784064329491953056990790492e1 * t162 / t884 * t881 - 0.72378403146153819370537784064329491953056990790492e1 * t540 * t889 + 0.12063067191025636561756297344054915325509498465082e1 * t324 * t875 - 0.66620136356071591521659992430582748757664351917068e1 * t889 - 0.22206712118690530507219997476860916252554783972356e1 * t162 * t875) * t334 - 0.3e1 / 0.2e1 * t548 * t552 * t554 * t329 + t903 / t551 / t333 * t88 * t330 / 0.2e1 - t903 * t552 * t32 / 0.2e1)
  t931 = t176 * t664 * t29 * t53
  t932 = 0.60882745115735062315642502939761174573100918338960e-1 * t931
  t934 = t184 * t723 * t77
  t935 = 0.76286344675855462750376613218642032945212144062484e-1 * t934
  t936 = t578 * t358
  t954 = f.my_piecewise3(t198, 0, -0.15712682379349046015712682379349046015712682379349e1 * t176 * t664 * t194 - 0.57987280209502431724653946876169098391320613542836e0 * t934)
  t966 = f.my_piecewise3(t197, 0, 0.6e1 * t591 * t936 * t201 - 0.6e1 * t577 * t358 * t201 * t587 - 0.6e1 / t590 / t199 * t936 * t201 + t352 * t954 * t201 + 0.3e1 * t591 * t587 * t358 * t201 + 0.1e1 / t590 / t351 * t936 * t201)
  t981 = t608 * t371
  t995 = f.my_piecewise3(t209, 0, -0.154e3 / 0.2025e4 * t931)
  t1007 = f.my_piecewise3(t208, 0, 0.6e1 * t617 * t981 * t212 - 0.6e1 * t607 * t371 * t212 * t613 - 0.6e1 / t616 / t210 * t981 * t212 + t369 * t995 * t212 + 0.3e1 * t617 * t613 * t371 * t212 + 0.1e1 / t616 / t368 * t981 * t212)
  t1009 = -t687 - t914 * t205 * t214 - 0.3e1 * t558 * t365 * t214 + 0.3e1 * t559 * t374 - 0.3e1 * t336 * t601 * t214 + 0.6e1 * t561 * t374 + 0.3e1 * t337 * t621 + t175 * (t932 + t935 + t687 + t966 * t203 + 0.3e1 * t595 * t363 + 0.3e1 * t361 * t599 + t202 * (-t932 - t935 - t687)) * t214 - 0.3e1 * t602 * t374 - 0.3e1 * t366 * t621 - t206 * t1007
  t1014 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t178 * t216 + t6 * t22 * t376 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t221 * t623 - 0.3e1 / 0.8e1 * t6 * t380 * t1009)
  v3rho3_0_ = 0.2e1 * r0 * t1014 + 0.6e1 * t628

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t23 = t17 * t22
  t24 = jnp.sqrt(0.3e1)
  t25 = jnp.sqrt(s0)
  t26 = 2 ** (0.1e1 / 0.3e1)
  t30 = 6 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = 0.1e1 / t34
  t37 = t25 * t26 / t19 / r0 * t31 * t35
  t38 = jnp.sqrt(t37)
  t40 = 0.33684323989301858700997729676563121054723552753020e-1 * t24 * t38
  t41 = jnp.log(DBL_EPSILON)
  t42 = 0.1e1 / t41
  t43 = t40 <= -t42
  t44 = t40 < -t42
  t45 = f.my_piecewise3(t44, -t42, t40)
  t47 = jnp.exp(-0.1e1 / t45)
  t48 = f.my_piecewise3(t43, 0, t47)
  t49 = 0.1174e1 * t48
  t50 = t26 ** 2
  t51 = tau0 * t50
  t53 = 0.1e1 / t20 / r0
  t54 = t51 * t53
  t55 = t34 ** 2
  t56 = 0.1e1 / t55
  t57 = t30 * t56
  t60 = 0.1e1 / tau0
  t62 = s0 / r0 * t60 / 0.8e1
  t64 = 0.0e0 < 0.9999999999e0 - t62
  t66 = f.my_piecewise3(t64, 0.1e1 - t62, 0.1e-9)
  t67 = t57 * t66
  t68 = t54 * t67
  t69 = 0.5e1 / 0.9e1 * t68
  t70 = t69 <= DBL_EPSILON
  t72 = tau0 ** 2
  t73 = t72 * t26
  t74 = t18 * r0
  t76 = 0.1e1 / t19 / t74
  t77 = t73 * t76
  t79 = 0.1e1 / t34 / t33
  t80 = t31 * t79
  t81 = t66 ** 2
  t82 = t80 * t81
  t85 = t72 * tau0
  t86 = t18 ** 2
  t87 = t86 * r0
  t88 = 0.1e1 / t87
  t89 = t85 * t88
  t90 = t33 ** 2
  t91 = 0.1e1 / t90
  t92 = t81 * t66
  t93 = t91 * t92
  t96 = t72 ** 2
  t97 = t96 * t50
  t98 = t86 * t18
  t100 = 0.1e1 / t20 / t98
  t101 = t97 * t100
  t103 = 0.1e1 / t55 / t90
  t104 = t30 * t103
  t105 = t81 ** 2
  t106 = t104 * t105
  t110 = t96 * tau0 * t26
  t111 = t86 ** 2
  t113 = 0.1e1 / t19 / t111
  t114 = t110 * t113
  t115 = t90 * t33
  t117 = 0.1e1 / t34 / t115
  t118 = t31 * t117
  t119 = t105 * t66
  t120 = t118 * t119
  t123 = t96 * t72
  t124 = t111 * t18
  t126 = t123 / t124
  t127 = t90 ** 2
  t128 = 0.1e1 / t127
  t129 = t105 * t81
  t130 = t128 * t129
  t134 = t96 * t85 * t50
  t135 = t111 * t74
  t137 = 0.1e1 / t20 / t135
  t138 = t134 * t137
  t140 = 0.1e1 / t55 / t127
  t141 = t30 * t140
  t142 = t105 * t92
  t143 = t141 * t142
  t146 = t96 ** 2
  t147 = t146 * t26
  t148 = t111 * t87
  t150 = 0.1e1 / t19 / t148
  t151 = t147 * t150
  t154 = 0.1e1 / t34 / t127 / t33
  t155 = t31 * t154
  t156 = t105 ** 2
  t157 = t155 * t156
  t162 = DBL_EPSILON < t69
  t163 = f.my_piecewise3(t162, t69, DBL_EPSILON)
  t164 = t163 - 0.1e1
  t165 = 0.1e1 / t163
  t168 = t164 ** 2
  t170 = -0.12063067191025636561756297344054915325509498465082e1 * t164 * t165 - 0.11103356059345265253609998738430458126277391986178e1 * t168
  t173 = jnp.atan(jnp.pi * t170 / 0.2e1)
  t176 = f.my_piecewise3(t70, 0.10000000000000000000000000000000000000000000000000e1 - 0.18665085944258768548480312698291741183874251568800e0 * t68 - 0.39828020716446299791660888839944193941475735799580e0 * t77 * t82 - 0.24255988786338671401209438649737461156020860150988e1 * t89 * t93 - 0.30550082955089596431026422666178865808917059551123e0 * t101 * t106 + 0.11675206820539006894908074763085954897985518274938e1 * t114 * t120 + 0.13980660423962914873101778938577720500503921055341e2 * t126 * t130 + 0.65062566833713102385486932758407464831962915982514e1 * t138 * t143 - 0.14122917874011879208475582068813149655297035992625e-1 * t151 * t157, 0.2e1 / jnp.pi * t173)
  t177 = 0.1e1 - t176
  t178 = s0 * t50
  t181 = t178 * t22 * t30 * t56
  t182 = 0.13342809400364015280213860222187919752221792168441e-2 * t181
  t183 = s0 ** 2
  t184 = t183 * t26
  t186 = 0.1e1 / t19 / t87
  t190 = 0.30797417856580405117526443733602495357666385910391e-3 * t184 * t186 * t31 * t79
  t194 = t57 * (0.1e1 + t181 / 0.24e2)
  t196 = 0.34435261707988980716253443526170798898071625344353e-1 * t178 * t22 * t194
  t197 = t196 <= -t42
  t198 = t196 < -t42
  t199 = f.my_piecewise3(t198, -t42, t196)
  t201 = jnp.exp(-0.1e1 / t199)
  t202 = f.my_piecewise3(t197, 0, t201)
  t203 = 0.1e0 + t182 + t190 - t49
  t205 = -0.174e0 - t182 - t190 + t49 + t202 * t203
  t206 = t177 * t205
  t207 = t181 / 0.600e3
  t208 = t207 <= -t42
  t209 = t207 < -t42
  t210 = f.my_piecewise3(t209, -t42, t207)
  t212 = jnp.exp(-0.1e1 / t210)
  t213 = f.my_piecewise3(t208, 0, t212)
  t214 = 0.1e1 - t213
  t216 = 0.1174e1 - t49 + t206 * t214
  t220 = t17 * t53
  t221 = t45 ** 2
  t222 = 0.1e1 / t221
  t225 = t24 / t38 * t25
  t229 = t31 * t35
  t233 = f.my_piecewise3(t44, 0, -0.22456215992867905800665153117708747369815701835347e-1 * t225 * t26 / t19 / t18 * t229)
  t236 = f.my_piecewise3(t43, 0, t222 * t233 * t47)
  t237 = 0.1174e1 * t236
  t238 = t51 * t22
  t239 = t238 * t67
  t245 = f.my_piecewise3(t64, s0 / t18 * t60 / 0.8e1, 0)
  t246 = t57 * t245
  t247 = t54 * t246
  t250 = 0.1e1 / t19 / t86
  t251 = t73 * t250
  t254 = t66 * t245
  t255 = t80 * t254
  t259 = t85 / t98
  t262 = t91 * t81
  t263 = t262 * t245
  t266 = t86 * t74
  t268 = 0.1e1 / t20 / t266
  t269 = t97 * t268
  t273 = t104 * t92 * t245
  t276 = t111 * r0
  t278 = 0.1e1 / t19 / t276
  t279 = t110 * t278
  t282 = t105 * t245
  t283 = t118 * t282
  t287 = t123 / t135
  t290 = t128 * t119
  t291 = t290 * t245
  t294 = t111 * t86
  t296 = 0.1e1 / t20 / t294
  t297 = t134 * t296
  t301 = t141 * t129 * t245
  t304 = t111 * t98
  t306 = 0.1e1 / t19 / t304
  t307 = t147 * t306
  t311 = t155 * t142 * t245
  t314 = 0.31108476573764614247467187830486235306457085948000e0 * t239 - 0.18665085944258768548480312698291741183874251568800e0 * t247 + 0.13276006905482099930553629613314731313825245266527e1 * t251 * t82 - 0.79656041432892599583321777679888387882951471599160e0 * t77 * t255 + 0.12127994393169335700604719324868730578010430075494e2 * t259 * t93 - 0.72767966359016014203628315949212383468062580452964e1 * t89 * t263 + 0.20366721970059730954017615110785910539278039700749e1 * t269 * t106 - 0.12220033182035838572410569066471546323566823820449e1 * t101 * t273 - 0.97293390171158390790900623025716290816545985624483e1 * t279 * t120 + 0.58376034102695034474540373815429774489927591374690e1 * t114 * t283 - 0.13980660423962914873101778938577720500503921055341e3 * t287 * t130 + 0.83883962543777489238610673631466323003023526332046e2 * t126 * t291 - 0.75906327972665286116401421551475375637290068646267e2 * t297 * t143 + 0.45543796783599171669840852930885225382374041187760e2 * t138 * t301 + 0.18830557165349172277967442758417532873729381323500e0 * t307 * t157 - 0.11298334299209503366780465655050519724237628794100e0 * t151 * t311
  t318 = f.my_piecewise3(t162, -0.25e2 / 0.27e2 * t239 + 0.5e1 / 0.9e1 * t247, 0)
  t321 = t163 ** 2
  t322 = 0.1e1 / t321
  t323 = t164 * t322
  t328 = -0.12063067191025636561756297344054915325509498465082e1 * t318 * t165 + 0.12063067191025636561756297344054915325509498465082e1 * t323 * t318 - 0.22206712118690530507219997476860916252554783972356e1 * t164 * t318
  t329 = t170 ** 2
  t332 = 0.1e1 + t33 * t329 / 0.4e1
  t333 = 0.1e1 / t332
  t335 = f.my_piecewise3(t70, t314, t328 * t333)
  t336 = t335 * t205
  t339 = 0.1e1 / t20 / t74
  t342 = t178 * t339 * t30 * t56
  t343 = 0.35580825067637374080570293925834452672591445782509e-2 * t342
  t345 = 0.1e1 / t19 / t98
  t348 = t184 * t345 * t31 * t79
  t349 = 0.16425289523509549396014103324587997524088739152209e-2 * t348
  t350 = t199 ** 2
  t351 = 0.1e1 / t350
  t357 = f.my_piecewise3(t198, 0, -0.91827364554637281910009182736455463728191000918275e-1 * t178 * t339 * t194 - 0.76522803795531068258340985613712886440159167431895e-2 * t348)
  t360 = f.my_piecewise3(t197, 0, t351 * t357 * t201)
  t362 = -t343 - t349 - t237
  t364 = t202 * t362 + t360 * t203 + t237 + t343 + t349
  t365 = t177 * t364
  t367 = t210 ** 2
  t368 = 0.1e1 / t367
  t370 = f.my_piecewise3(t209, 0, -t342 / 0.225e3)
  t373 = f.my_piecewise3(t208, 0, t368 * t370 * t212)
  t375 = -t206 * t373 - t336 * t214 + t365 * t214 - t237
  t380 = t17 / t20
  t381 = t221 * t45
  t382 = 0.1e1 / t381
  t383 = t233 ** 2
  t390 = t24 / t38 / t37 * s0
  t392 = 0.1e1 / t20 / t86
  t402 = f.my_piecewise3(t44, 0, -0.89824863971471623202660612470834989479262807341388e-1 * t390 * t50 * t392 * t57 + 0.52397837316691780201552023941320410529569970949143e-1 * t225 * t26 * t76 * t229)
  t405 = t221 ** 2
  t406 = 0.1e1 / t405
  t407 = t406 * t383
  t410 = f.my_piecewise3(t43, 0, t222 * t402 * t47 - 0.2e1 * t382 * t383 * t47 + t407 * t47)
  t411 = 0.1174e1 * t410
  t414 = t110 / t19 / t124
  t419 = t134 / t20 / t148
  t422 = t111 * t266
  t425 = t147 / t19 / t422
  t428 = t73 * t186
  t431 = t245 ** 2
  t432 = t80 * t431
  t435 = t51 * t339
  t436 = t435 * t67
  t438 = t238 * t246
  t444 = f.my_piecewise3(t64, -s0 / t74 * t60 / 0.4e1, 0)
  t445 = t57 * t444
  t446 = t54 * t445
  t450 = t97 / t20 / t111
  t453 = t91 * t66
  t454 = t453 * t431
  t457 = t128 * t105
  t458 = t457 * t431
  t463 = t262 * t444
  t468 = t290 * t444
  t471 = 0.90807164159747831404840581490668538095442919916184e2 * t414 * t120 + 0.96148015432042695747441800631868809140567420285272e3 * t419 * t143 - 0.26990465270333813598420001287065130452345446563683e1 * t425 * t157 - 0.57529363257089099699065728324363835693242729488284e1 * t428 * t82 - 0.79656041432892599583321777679888387882951471599160e0 * t77 * t432 - 0.82955937530038971326579167547963294150552229194667e0 * t436 + 0.62216953147529228494934375660972470612914171896000e0 * t438 - 0.18665085944258768548480312698291741183874251568800e0 * t446 - 0.15614486843712460398080171584935864746779830437241e2 * t450 * t106 - 0.14553593271803202840725663189842476693612516090593e2 * t89 * t454 + 0.41941981271888744619305336815733161501511763166023e3 * t126 * t458 + 0.72767966359016014203628315949212383468062580452964e2 * t259 * t263 - 0.72767966359016014203628315949212383468062580452964e1 * t89 * t463 - 0.16776792508755497847722134726293264600604705266409e4 * t287 * t291 + 0.83883962543777489238610673631466323003023526332046e2 * t126 * t468
  t473 = t80 * t66 * t444
  t479 = t104 * t92 * t444
  t485 = t118 * t105 * t444
  t491 = t141 * t129 * t444
  t495 = t123 / t294
  t498 = 0.1e1 / t266
  t499 = t85 * t498
  t505 = t155 * t142 * t444
  t511 = t141 * t119 * t431
  t515 = t155 * t129 * t431
  t519 = t104 * t81 * t431
  t522 = t92 * t431
  t523 = t118 * t522
  t526 = -0.79656041432892599583321777679888387882951471599160e0 * t77 * t473 + 0.16293377576047784763214092088628728431422431760599e2 * t269 * t273 - 0.12220033182035838572410569066471546323566823820449e1 * t101 * t479 - 0.97293390171158390790900623025716290816545985624484e2 * t279 * t283 + 0.58376034102695034474540373815429774489927591374690e1 * t114 * t485 - 0.10626885916173140056296199017206552589220609610477e4 * t297 * t301 + 0.45543796783599171669840852930885225382374041187760e2 * t138 * t491 + 0.15378726466359206360411956832435492550554313160875e4 * t495 * t130 - 0.72767966359016014203628315949212383468062580452964e2 * t499 * t93 + 0.30128891464558675644747908413468052597967010117600e1 * t307 * t311 - 0.11298334299209503366780465655050519724237628794100e0 * t151 * t505 + 0.53104027621928399722214518453258925255300981066107e1 * t251 * t255 + 0.27326278070159503001904511758531135229424424712656e3 * t138 * t511 - 0.79088340094466523567463259585353638069663401558700e0 * t151 * t515 - 0.36660099546107515717231707199414638970700471461347e1 * t101 * t519 + 0.23350413641078013789816149526171909795971036549876e2 * t114 * t523
  t532 = f.my_piecewise3(t162, 0.200e3 / 0.81e2 * t436 - 0.50e2 / 0.27e2 * t438 + 0.5e1 / 0.9e1 * t446, 0)
  t535 = t318 ** 2
  t539 = 0.1e1 / t321 / t163
  t540 = t164 * t539
  t548 = -0.12063067191025636561756297344054915325509498465082e1 * t532 * t165 + 0.24126134382051273123512594688109830651018996930164e1 * t535 * t322 - 0.24126134382051273123512594688109830651018996930164e1 * t540 * t535 + 0.12063067191025636561756297344054915325509498465082e1 * t323 * t532 - 0.22206712118690530507219997476860916252554783972356e1 * t535 - 0.22206712118690530507219997476860916252554783972356e1 * t164 * t532
  t550 = t328 ** 2
  t551 = t332 ** 2
  t552 = 0.1e1 / t551
  t554 = t33 * t170
  t558 = f.my_piecewise3(t70, t471 + t526, t548 * t333 - t550 * t552 * t554 / 0.2e1)
  t559 = t558 * t205
  t561 = t335 * t364
  t568 = t178 * t392 * t30 * t56
  t569 = 0.13046302524800370496209107772805965979950196786920e-1 * t568
  t571 = 0.1e1 / t19 / t266
  t574 = t184 * t571 * t31 * t79
  t575 = 0.10402683364889381284142265438905731765256201463066e-1 * t574
  t576 = t350 * t199
  t577 = 0.1e1 / t576
  t578 = t357 ** 2
  t587 = f.my_piecewise3(t198, 0, 0.33670033670033670033670033670033670033670033670034e0 * t178 * t392 * t194 + 0.68870523415977961432506887052341597796143250688706e-1 * t574)
  t590 = t350 ** 2
  t591 = 0.1e1 / t590
  t592 = t591 * t578
  t595 = f.my_piecewise3(t197, 0, t351 * t587 * t201 - 0.2e1 * t577 * t578 * t201 + t592 * t201)
  t599 = t569 + t575 - t411
  t601 = t202 * t599 + t595 * t203 + 0.2e1 * t360 * t362 + t411 - t569 - t575
  t602 = t177 * t601
  t606 = t367 * t210
  t607 = 0.1e1 / t606
  t608 = t370 ** 2
  t613 = f.my_piecewise3(t209, 0, 0.11e2 / 0.675e3 * t568)
  t616 = t367 ** 2
  t617 = 0.1e1 / t616
  t618 = t617 * t608
  t621 = f.my_piecewise3(t208, 0, t368 * t613 * t212 - 0.2e1 * t607 * t608 * t212 + t618 * t212)
  t623 = -t206 * t621 - t559 * t214 - 0.2e1 * t561 * t214 + t602 * t214 + 0.2e1 * t336 * t373 - 0.2e1 * t365 * t373 - t411
  t627 = t17 * t19
  t628 = t383 * t233
  t632 = t382 * t233
  t633 = t47 * t402
  t637 = 0.1e1 / t405 / t45
  t644 = t24 / t38 / t181 / 0.6e1
  t645 = t25 * s0
  t647 = 0.1e1 / t33
  t652 = 0.1e1 / t20 / t87
  t662 = f.my_piecewise3(t44, 0, -0.21557967353153189568638546993000397475023073761933e1 * t644 * t645 * t498 * t647 + 0.62877404780030136241862428729584492635483965138971e0 * t390 * t50 * t652 * t57 - 0.17465945772230593400517341313773470176523323649714e0 * t225 * t26 * t250 * t229)
  t666 = t233 * t47
  t670 = 0.1e1 / t405 / t221
  t674 = f.my_piecewise3(t43, 0, t222 * t662 * t47 + 0.3e1 * t406 * t402 * t666 + 0.6e1 * t406 * t628 * t47 - 0.6e1 * t637 * t628 * t47 + t670 * t628 * t47 - 0.6e1 * t632 * t633)
  t675 = 0.1174e1 * t674
  t678 = t97 / t20 / t276
  t683 = t110 / t19 / t135
  t688 = t134 / t20 / t304
  t691 = t111 ** 2
  t694 = t147 / t19 / t691
  t697 = t73 * t345
  t700 = t89 * t91
  t701 = t254 * t444
  t704 = t126 * t128
  t705 = t282 * t444
  t710 = t51 * t392
  t711 = t710 * t67
  t713 = t435 * t246
  t715 = t238 * t445
  t717 = 0.1e1 / t86
  t721 = f.my_piecewise3(t64, 0.3e1 / 0.4e1 * s0 * t717 * t60, 0)
  t722 = t57 * t721
  t723 = t54 * t722
  t727 = 0.13532555264550799011669482040277749447209186378942e3 * t678 * t106 - 0.93834069631739425785001934207024156031957683913390e3 * t683 * t120 - 0.13140228775712501752150379419688737249210880772321e5 * t688 * t143 + 0.41385380081178514184244001973499866693596351397647e2 * t694 * t157 + 0.30682327070447519839501721772994045703062789060418e2 * t697 * t82 - 0.43660779815409608522176989569527430080837548271779e2 * t700 * t701 + 0.12582594381566623385791601044719948450453528949807e4 * t704 * t705 + 0.79656041432892599583321777679888387882951471599160e1 * t251 * t432 + 0.30417177094347622819745694767586541188535817371378e1 * t711 - 0.24886781259011691397973750264388988245165668758400e1 * t713 + 0.93325429721293842742401563491458705919371257844000e0 * t715 - 0.18665085944258768548480312698291741183874251568800e0 * t723 - 0.25165188763133246771583202089439896900907057899614e4 * t287 * t468
  t728 = t290 * t721
  t736 = t431 * t245
  t737 = t128 * t92 * t736
  t746 = t262 * t721
  t752 = t155 * t142 * t721
  t761 = 0.83883962543777489238610673631466323003023526332046e2 * t126 * t728 + 0.21830389907704804261088494784763715040418774135890e3 * t259 * t454 - 0.12582594381566623385791601044719948450453528949807e5 * t287 * t458 + 0.16776792508755497847722134726293264600604705266409e4 * t126 * t737 - 0.65491169723114412783265484354291145121256322407667e3 * t499 * t263 + 0.27681707639446571448741522298383886590997763689575e5 * t495 * t291 + 0.10915194953852402130544247392381857520209387067945e3 * t259 * t463 - 0.72767966359016014203628315949212383468062580452964e1 * t89 * t746 + 0.45193337196838013467121862620202078896950515176400e1 * t307 * t505 - 0.11298334299209503366780465655050519724237628794100e0 * t151 * t752 - 0.18737384212454952477696205901923037696135796524689e3 * t450 * t273 + 0.13621074623962174710726087223600280714316437987428e4 * t414 * t283 + 0.20191083240728966106962778132692449919519158259907e5 * t419 * t301
  t767 = t245 * t444
  t768 = t80 * t767
  t772 = t118 * t81 * t736
  t780 = t141 * t105 * t736
  t786 = t155 * t119 * t736
  t792 = t104 * t66 * t736
  t797 = t66 * t721
  t798 = t80 * t797
  t801 = -0.64777116648801152636208003088956313085629071752839e2 * t425 * t311 - 0.34517617954253459819439436994618301415945637692970e2 * t428 * t255 - 0.23896812429867779874996533303966516364885441479748e1 * t77 * t768 + 0.70051240923234041369448448578515729387913109649628e2 * t114 * t772 + 0.79656041432892599583321777679888387882951471599160e1 * t251 * t473 - 0.95641973245558260506665791154858973302985486494294e4 * t297 * t511 + 0.13663139035079751500952255879265567614712212356328e4 * t138 * t780 + 0.31635336037786609426985303834141455227865360623480e2 * t307 * t515 - 0.47453004056679914140477955751212182841798040935220e1 * t151 * t786 + 0.73320199092215031434463414398829277941400942922695e2 * t269 * t519 - 0.73320199092215031434463414398829277941400942922694e1 * t101 * t792 - 0.58376034102695034474540373815429774489927591374691e3 * t279 * t523 - 0.79656041432892599583321777679888387882951471599160e0 * t77 * t798
  t804 = t113 * t31
  t805 = t110 * t804
  t806 = t117 * t92
  t807 = t806 * t767
  t811 = t134 * t137 * t30
  t812 = t140 * t119
  t813 = t812 * t767
  t817 = t147 * t150 * t31
  t818 = t154 * t129
  t819 = t818 * t767
  t822 = t100 * t30
  t823 = t97 * t822
  t824 = t103 * t81
  t825 = t824 * t767
  t828 = t91 * t736
  t831 = 0.1e1 / t111
  t832 = t85 * t831
  t836 = t123 / t148
  t840 = t104 * t92 * t721
  t845 = t105 * t721
  t846 = t118 * t845
  t852 = t141 * t129 * t721
  t855 = 0.24440066364071677144821138132943092647133647640898e2 * t269 * t479 + 0.70051240923234041369448448578515729387913109649628e2 * t805 * t807 + 0.81978834210478509005713535275593405688273274137968e3 * t811 * t813 - 0.23726502028339957070238977875606091420899020467610e1 * t817 * t819 - 0.10998029863832254715169512159824391691210141438404e2 * t823 * t825 - 0.14553593271803202840725663189842476693612516090593e2 * t89 * t828 + 0.50937576451311209942539821164448668427643806317075e3 * t832 * t93 - 0.18454471759631047632494348198922591060665175793050e5 * t836 * t130 - 0.12220033182035838572410569066471546323566823820449e1 * t101 * t840 - 0.14594008525673758618635093453857443622481897843673e3 * t279 * t485 + 0.58376034102695034474540373815429774489927591374690e1 * t114 * t846 - 0.15940328874259710084444298525809828883830914415716e4 * t297 * t491 + 0.45543796783599171669840852930885225382374041187760e2 * t138 * t852
  t863 = f.my_piecewise3(t162, -0.2200e4 / 0.243e3 * t711 + 0.200e3 / 0.27e2 * t713 - 0.25e2 / 0.9e1 * t715 + 0.5e1 / 0.9e1 * t723, 0)
  t869 = t535 * t318
  t872 = t321 ** 2
  t873 = 0.1e1 / t872
  t874 = t164 * t873
  t877 = t318 * t532
  t885 = -0.12063067191025636561756297344054915325509498465082e1 * t863 * t165 + 0.72378403146153819370537784064329491953056990790492e1 * t532 * t322 * t318 - 0.72378403146153819370537784064329491953056990790492e1 * t869 * t539 + 0.72378403146153819370537784064329491953056990790492e1 * t874 * t869 - 0.72378403146153819370537784064329491953056990790492e1 * t540 * t877 + 0.12063067191025636561756297344054915325509498465082e1 * t323 * t863 - 0.66620136356071591521659992430582748757664351917068e1 * t877 - 0.22206712118690530507219997476860916252554783972356e1 * t164 * t863
  t887 = t548 * t552
  t888 = t554 * t328
  t891 = t550 * t328
  t893 = 0.1e1 / t551 / t332
  t895 = t90 * t329
  t902 = f.my_piecewise3(t70, t727 + t761 + t801 + t855, t885 * t333 - 0.3e1 / 0.2e1 * t887 * t888 + t891 * t893 * t895 / 0.2e1 - t891 * t552 * t33 / 0.2e1)
  t903 = t902 * t205
  t905 = t558 * t364
  t910 = t335 * t601
  t919 = t178 * t652 * t30 * t56
  t920 = 0.60882745115735062315642502939761174573100918338960e-1 * t919
  t922 = t184 * t804 * t79
  t923 = 0.76286344675855462750376613218642032945212144062484e-1 * t922
  t924 = t578 * t357
  t928 = t577 * t357
  t929 = t201 * t587
  t933 = 0.1e1 / t590 / t199
  t942 = f.my_piecewise3(t198, 0, -0.15712682379349046015712682379349046015712682379349e1 * t178 * t652 * t194 - 0.57987280209502431724653946876169098391320613542836e0 * t922)
  t946 = t357 * t201
  t950 = 0.1e1 / t590 / t350
  t954 = f.my_piecewise3(t197, 0, t351 * t942 * t201 + 0.6e1 * t591 * t924 * t201 - 0.6e1 * t933 * t924 * t201 + t950 * t924 * t201 + 0.3e1 * t591 * t587 * t946 - 0.6e1 * t928 * t929)
  t960 = -t920 - t923 - t675
  t962 = t202 * t960 + t954 * t203 + 0.3e1 * t360 * t599 + 0.3e1 * t595 * t362 + t675 + t920 + t923
  t963 = t177 * t962
  t969 = t608 * t370
  t973 = t607 * t370
  t974 = t212 * t613
  t978 = 0.1e1 / t616 / t210
  t983 = f.my_piecewise3(t209, 0, -0.154e3 / 0.2025e4 * t919)
  t987 = t370 * t212
  t991 = 0.1e1 / t616 / t367
  t995 = f.my_piecewise3(t208, 0, t368 * t983 * t212 + 0.6e1 * t617 * t969 * t212 - 0.6e1 * t978 * t969 * t212 + t991 * t969 * t212 + 0.3e1 * t617 * t613 * t987 - 0.6e1 * t973 * t974)
  t997 = -t206 * t995 - t903 * t214 - 0.3e1 * t905 * t214 - 0.3e1 * t910 * t214 + t963 * t214 + 0.3e1 * t336 * t621 - 0.3e1 * t365 * t621 + 0.3e1 * t559 * t373 + 0.6e1 * t561 * t373 - 0.3e1 * t602 * t373 - t675
  t1002 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t23 * t216 + t6 * t220 * t375 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t380 * t623 - 0.3e1 / 0.8e1 * t6 * t627 * t997)
  t1017 = t383 ** 2
  t1026 = t402 ** 2
  t1066 = f.my_piecewise3(t44, 0, -0.99805404412746248002956236078705543865847563712653e-1 * t24 / t38 / t645 / t717 * t183 * t278 * t26 * t229 + 0.30181154294414465396093965790200556465032303266706e2 * t644 * t645 * t831 * t647 - 0.42616907684242647897262312805607267230716909705303e1 * t390 * t50 * t100 * t57 + 0.75685765012999238068908479026351704098267735815427e0 * t225 * t26 * t186 * t229)
  t1079 = t405 ** 2
  t1083 = -0.24e2 * t637 * t1017 * t47 + 0.36e2 * t407 * t633 + 0.36e2 * t670 * t1017 * t47 - 0.6e1 * t382 * t1026 * t47 - 0.36e2 * t637 * t383 * t633 - 0.8e1 * t632 * t47 * t662 - 0.12e2 / t405 / t381 * t1017 * t47 + t222 * t1066 * t47 + 0.4e1 * t406 * t662 * t666 + 0.3e1 * t406 * t1026 * t47 + 0.6e1 * t670 * t402 * t383 * t47 + 0.1e1 / t1079 * t1017 * t47
  t1084 = f.my_piecewise3(t43, 0, t1083)
  t1085 = 0.1174e1 * t1084
  t1090 = t444 ** 2
  t1099 = t245 * t721
  t1106 = f.my_piecewise3(t64, -0.3e1 * s0 * t88 * t60, 0)
  t1150 = -0.21253771832346280112592398034413105178441219220955e4 * t297 * t852 + 0.45543796783599171669840852930885225382374041187760e2 * t138 * t141 * t129 * t1106 + 0.60257782929117351289495816826936105195934020235200e1 * t307 * t752 - 0.11298334299209503366780465655050519724237628794100e0 * t151 * t155 * t142 * t1106 - 0.37474768424909904955392411803846075392271593049377e3 * t450 * t479 + 0.27242149247924349421452174447200561428632875974856e4 * t414 * t485 + 0.40382166481457932213925556265384899839038316519814e5 * t419 * t491 - 0.36792640571995004906021062375128464297790466162498e6 * t688 * t301 + 0.13243321625977124538958080631519957341950832447247e4 * t694 * t311 + 0.24545861656358015871601377418395236562450231248335e3 * t697 * t255 + 0.31862416573157039833328711071955355153180588639664e2 * t251 * t768
  t1152 = t431 ** 2
  t1208 = 0.10620805524385679944442903690651785051060196213221e2 * t251 * t798 - 0.23726502028339957070238977875606091420899020467610e1 * t151 * t155 * t129 * t1090 - 0.10998029863832254715169512159824391691210141438404e2 * t101 * t104 * t81 * t1090 + 0.24229299888874759328355333759230939903422989911888e6 * t419 * t511 - 0.63761315497038840337777194103239315535323657662863e5 * t297 * t780 + 0.54652556140319006003809023517062270458848849425312e4 * t138 * t141 * t92 * t1152 - 0.43660779815409608522176989569527430080837548271779e2 * t89 * t453 * t1090 + 0.12582594381566623385791601044719948450453528949807e4 * t126 * t457 * t1090 - 0.44290732223114514317986435677414218545596421903320e6 * t836 * t291 + 0.27681707639446571448741522298383886590997763689576e6 * t495 * t458 - 0.13098233944622882556653096870858229024251264481534e4 * t499 * t463
  t1239 = t431 * t444
  t1279 = 0.42030744553940424821669069147109437632747865789776e3 * t805 * t117 * t81 * t1239 - 0.38256789298223304202666316461943589321194194597719e5 * t134 * t296 * t30 * t813 + 0.81978834210478509005713535275593405688273274137968e4 * t811 * t140 * t105 * t1239 + 0.12654134415114643770794121533656582091146144249392e3 * t147 * t306 * t31 * t819 - 0.28471802434007948484286773450727309705078824561132e2 * t817 * t154 * t119 * t1239 + 0.10930511228063801200761804703412454091769769885062e4 * t811 * t812 * t1099 - 0.31635336037786609426985303834141455227865360623480e1 * t817 * t818 * t1099 - 0.14664039818443006286892682879765855588280188584539e2 * t823 * t824 * t1099 + 0.93401654564312055159264598104687639183884146199504e2 * t805 * t806 * t1099 + 0.29328079636886012573785365759531711176560377169077e3 * t97 * t268 * t30 * t825 - 0.43992119455329018860678048639297566764840565753616e2 * t823 * t103 * t66 * t1239
  t1281 = t278 * t31
  t1320 = t51 * t652 * t67
  t1322 = t710 * t246
  t1324 = -0.23350413641078013789816149526171909795971036549876e4 * t110 * t1281 * t807 - 0.40750061161048967954031856931558934742115045053660e4 * t85 / t276 * t93 + 0.23990813287520361922242652658599368378864728530965e6 * t123 / t304 * t130 + 0.29107186543606405681451326379684953387225032181186e3 * t259 * t828 - 0.13081470089065772377947165972268491132302213499644e4 * t97 / t20 / t124 * t106 + 0.10634527891597134922300219210129404350288537510184e5 * t110 / t19 / t294 * t120 + 0.19272335537711669236487223148876814632175958466071e6 * t134 / t20 / t422 * t143 - 0.67596120799258239834265203223383115599540707282823e3 * t147 / t19 / t691 / r0 * t157 - 0.73320199092215031434463414398829277941400942922694e1 * t101 * t104 * t1152 - 0.14194682644028890649214657558207052554650048106643e2 * t1320 + 0.12166870837739049127898277907034616475414326948551e2 * t1322
  t1325 = t435 * t445
  t1327 = t238 * t722
  t1330 = t54 * t57 * t1106
  t1355 = -0.49773562518023382795947500528777976490331337516800e1 * t1325 + 0.12443390629505845698986875132194494122582834379200e1 * t1327 - 0.18665085944258768548480312698291741183874251568800e0 * t1330 + 0.87321559630819217044353979139054860161675096543560e3 * t259 * t91 * t701 - 0.58214373087212811362902652759369906774450064362372e2 * t700 * t797 * t245 - 0.50330377526266493543166404178879793801814115799228e5 * t287 * t128 * t705 + 0.16776792508755497847722134726293264600604705266409e4 * t704 * t845 * t245 + 0.10066075505253298708633280835775958760362823159846e5 * t704 * t522 * t444 - 0.19432140477950095898351090456229562278606433071598e3 * t73 * t571 * t82 - 0.69035235908506919638878873989236602831891275385939e2 * t428 * t432 - 0.23896812429867779874996533303966516364885441479748e1 * t77 * t80 * t1090
  t1365 = f.my_piecewise3(t162, 0.30800e5 / 0.729e3 * t1320 - 0.8800e4 / 0.243e3 * t1322 + 0.400e3 / 0.27e2 * t1325 - 0.100e3 / 0.27e2 * t1327 + 0.5e1 / 0.9e1 * t1330, 0)
  t1374 = t532 ** 2
  t1377 = t535 ** 2
  t1390 = t318 * t863
  t1399 = -0.12063067191025636561756297344054915325509498465082e1 * t1365 * t165 + 0.96504537528205092494050378752439322604075987720656e1 * t863 * t322 * t318 - 0.43427041887692291622322670438597695171834194474295e2 * t532 * t539 * t535 + 0.72378403146153819370537784064329491953056990790492e1 * t1374 * t322 + 0.28951361258461527748215113625731796781222796316197e2 * t1377 * t873 - 0.28951361258461527748215113625731796781222796316197e2 * t164 / t872 / t163 * t1377 + 0.43427041887692291622322670438597695171834194474296e2 * t874 * t535 * t532 - 0.72378403146153819370537784064329491953056990790492e1 * t540 * t1374 - 0.96504537528205092494050378752439322604075987720656e1 * t540 * t1390 + 0.12063067191025636561756297344054915325509498465082e1 * t323 * t1365 - 0.66620136356071591521659992430582748757664351917068e1 * t1374 - 0.88826848474762122028879989907443665010219135889424e1 * t1390 - 0.22206712118690530507219997476860916252554783972356e1 * t164 * t1365
  t1411 = t548 ** 2
  t1415 = t550 ** 2
  t1416 = t551 ** 2
  t1428 = f.my_piecewise3(t70, t1208 + 0.61125091741573451931047785397338402113172567580489e4 * t832 * t263 - 0.26196467889245765113306193741716458048502528963067e4 * t499 * t454 - 0.67107170035021991390888538905173058402418821065637e5 * t287 * t737 + 0.55363415278893142897483044596767773181995527379150e5 * t495 * t468 + 0.14553593271803202840725663189842476693612516090593e3 * t259 * t746 - 0.33553585017510995695444269452586529201209410532819e4 * t287 * t728 - 0.23350413641078013789816149526171909795971036549876e4 * t279 * t772 - 0.12955423329760230527241600617791262617125814350568e3 * t425 * t505 + 0.21652088423281278418671171264444399115534698206307e4 * t678 * t273 - 0.18766813926347885157000386841404831206391536782678e5 * t683 * t283 - 0.69035235908506919638878873989236602831891275385939e2 * t428 * t473 - 0.11242430527472971486617723541153822617681477914813e4 * t450 * t519 + 0.19552053091257341715856910506354474117706918112719e3 * t269 * t792 + 0.10896859699169739768580869778880224571453150389942e5 * t414 * t523 + 0.32586755152095569526428184177257456862844863521197e2 * t269 * t840 - 0.19458678034231678158180124605143258163309197124897e3 * t279 * t846 - 0.90687963308321613690691204324538838319880700453975e3 * t425 * t515 + 0.25308268830229287541588243067313164182292288498784e3 * t307 * t786 + t1150 + t1279 + t1355 + t1324 + 0.50330377526266493543166404178879793801814115799227e4 * t126 * t128 * t81 * t1152 - 0.87321559630819217044353979139054860161675096543558e2 * t89 * t91 * t431 * t444 + 0.70051240923234041369448448578515729387913109649628e2 * t114 * t118 * t92 * t1090 + 0.81978834210478509005713535275593405688273274137968e3 * t138 * t141 * t119 * t1090 - 0.79656041432892599583321777679888387882951471599160e0 * t77 * t80 * t66 * t1106 - 0.12220033182035838572410569066471546323566823820449e1 * t101 * t104 * t92 * t1106 + 0.58376034102695034474540373815429774489927591374690e1 * t114 * t118 * t105 * t1106 + 0.14010248184646808273889689715703145877582621929926e3 * t114 * t118 * t66 * t1152 - 0.23726502028339957070238977875606091420899020467610e2 * t151 * t155 * t105 * t1152 - 0.31862416573157039833328711071955355153180588639664e1 * t77 * t80 * t1099 - 0.72767966359016014203628315949212383468062580452964e1 * t89 * t262 * t1106 + 0.83883962543777489238610673631466323003023526332046e2 * t126 * t290 * t1106, t1399 * t333 - 0.2e1 * t885 * t552 * t888 + 0.3e1 * t548 * t893 * t895 * t550 - 0.3e1 * t887 * t33 * t550 - 0.3e1 / 0.2e1 * t1411 * t552 * t554 - 0.3e1 / 0.4e1 * t1415 / t1416 * t115 * t329 * t170 + 0.3e1 / 0.2e1 * t1415 * t893 * t90 * t170)
  t1453 = t178 * t822 * t56
  t1454 = 0.34500222232249868645530751665864665591423853725411e0 * t1453
  t1456 = t184 * t1281 * t79
  t1457 = 0.63571953896546218958647177682201694121010120052070e0 * t1456
  t1458 = t578 ** 2
  t1467 = t587 ** 2
  t1487 = f.my_piecewise3(t198, 0, 0.89038533482977927422371866816311260755705200149644e1 * t178 * t100 * t194 + 0.51814440703329592218481107369996258885147774036663e1 * t1456)
  t1500 = t590 ** 2
  t1504 = -0.24e2 * t933 * t1458 * t201 + 0.36e2 * t592 * t929 + 0.36e2 * t950 * t1458 * t201 - 0.6e1 * t577 * t1467 * t201 - 0.36e2 * t933 * t578 * t929 - 0.8e1 * t928 * t201 * t942 - 0.12e2 / t590 / t576 * t1458 * t201 + t351 * t1487 * t201 + 0.4e1 * t591 * t942 * t946 + 0.3e1 * t591 * t1467 * t201 + 0.6e1 * t950 * t587 * t578 * t201 + 0.1e1 / t1500 * t1458 * t201
  t1505 = f.my_piecewise3(t197, 0, t1504)
  t1524 = t608 ** 2
  t1533 = t613 ** 2
  t1549 = f.my_piecewise3(t209, 0, 0.2618e4 / 0.6075e4 * t1453)
  t1562 = t616 ** 2
  t1566 = -0.24e2 * t978 * t1524 * t212 + 0.36e2 * t618 * t974 + 0.36e2 * t991 * t1524 * t212 - 0.6e1 * t607 * t1533 * t212 - 0.36e2 * t978 * t608 * t974 - 0.8e1 * t973 * t212 * t983 - 0.12e2 / t616 / t606 * t1524 * t212 + t368 * t1549 * t212 + 0.4e1 * t617 * t983 * t987 + 0.3e1 * t617 * t1533 * t212 + 0.6e1 * t991 * t613 * t608 * t212 + 0.1e1 / t1562 * t1524 * t212
  t1567 = f.my_piecewise3(t208, 0, t1566)
  t1569 = -t1085 - t1428 * t205 * t214 - 0.4e1 * t902 * t364 * t214 + 0.4e1 * t903 * t373 - 0.6e1 * t558 * t601 * t214 + 0.12e2 * t905 * t373 + 0.6e1 * t559 * t621 - 0.4e1 * t335 * t962 * t214 + 0.12e2 * t910 * t373 + 0.12e2 * t561 * t621 + 0.4e1 * t336 * t995 + t177 * (-t1454 - t1457 + t1085 + t1505 * t203 + 0.4e1 * t954 * t362 + 0.6e1 * t595 * t599 + 0.4e1 * t360 * t960 + t202 * (t1454 + t1457 - t1085)) * t214 - 0.4e1 * t963 * t373 - 0.6e1 * t602 * t621 - 0.4e1 * t365 * t995 - t206 * t1567
  t1574 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t17 * t339 * t216 - 0.5e1 / 0.9e1 * t6 * t23 * t375 + t6 * t220 * t623 / 0.2e1 - t6 * t380 * t997 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t627 * t1569)
  v4rho4_0_ = 0.2e1 * r0 * t1574 + 0.8e1 * t1002

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = jnp.sqrt(0.3e1)
  t33 = jnp.sqrt(s0)
  t34 = r0 ** (0.1e1 / 0.3e1)
  t38 = 6 ** (0.1e1 / 0.3e1)
  t39 = t38 ** 2
  t40 = jnp.pi ** 2
  t41 = t40 ** (0.1e1 / 0.3e1)
  t42 = 0.1e1 / t41
  t43 = t39 * t42
  t44 = t33 / t34 / r0 * t43
  t45 = jnp.sqrt(t44)
  t47 = 0.33684323989301858700997729676563121054723552753020e-1 * t32 * t45
  t48 = jnp.log(DBL_EPSILON)
  t49 = 0.1e1 / t48
  t50 = t47 <= -t49
  t51 = t47 < -t49
  t52 = f.my_piecewise3(t51, -t49, t47)
  t54 = jnp.exp(-0.1e1 / t52)
  t55 = f.my_piecewise3(t50, 0, t54)
  t56 = 0.1174e1 * t55
  t57 = t34 ** 2
  t60 = tau0 / t57 / r0
  t61 = t41 ** 2
  t62 = 0.1e1 / t61
  t63 = t38 * t62
  t66 = 0.1e1 / tau0
  t68 = s0 / r0 * t66 / 0.8e1
  t70 = 0.0e0 < 0.9999999999e0 - t68
  t72 = f.my_piecewise3(t70, 0.1e1 - t68, 0.1e-9)
  t73 = t63 * t72
  t74 = t60 * t73
  t75 = 0.5e1 / 0.9e1 * t74
  t76 = t75 <= DBL_EPSILON
  t78 = tau0 ** 2
  t79 = r0 ** 2
  t80 = t79 * r0
  t82 = 0.1e1 / t34 / t80
  t83 = t78 * t82
  t85 = 0.1e1 / t41 / t40
  t86 = t39 * t85
  t87 = t72 ** 2
  t88 = t86 * t87
  t91 = t78 * tau0
  t92 = t79 ** 2
  t93 = t92 * r0
  t95 = t91 / t93
  t96 = t40 ** 2
  t97 = 0.1e1 / t96
  t98 = t87 * t72
  t99 = t97 * t98
  t102 = t78 ** 2
  t103 = t92 * t79
  t106 = t102 / t57 / t103
  t108 = 0.1e1 / t61 / t96
  t109 = t38 * t108
  t110 = t87 ** 2
  t111 = t109 * t110
  t114 = t102 * tau0
  t115 = t92 ** 2
  t118 = t114 / t34 / t115
  t121 = 0.1e1 / t41 / t96 / t40
  t122 = t39 * t121
  t123 = t110 * t72
  t124 = t122 * t123
  t127 = t102 * t78
  t128 = t115 * t79
  t130 = t127 / t128
  t131 = t96 ** 2
  t132 = 0.1e1 / t131
  t133 = t110 * t87
  t134 = t132 * t133
  t137 = t102 * t91
  t138 = t115 * t80
  t141 = t137 / t57 / t138
  t143 = 0.1e1 / t61 / t131
  t144 = t38 * t143
  t145 = t110 * t98
  t146 = t144 * t145
  t149 = t102 ** 2
  t150 = t115 * t93
  t153 = t149 / t34 / t150
  t156 = 0.1e1 / t41 / t131 / t40
  t157 = t39 * t156
  t158 = t110 ** 2
  t159 = t157 * t158
  t163 = 0.1e1 / jnp.pi
  t164 = DBL_EPSILON < t75
  t165 = f.my_piecewise3(t164, t75, DBL_EPSILON)
  t166 = t165 - 0.1e1
  t167 = 0.1e1 / t165
  t170 = t166 ** 2
  t172 = -0.12063067191025636561756297344054915325509498465082e1 * t166 * t167 - 0.11103356059345265253609998738430458126277391986178e1 * t170
  t175 = jnp.arctan(jnp.pi * t172 / 0.2e1)
  t178 = f.my_piecewise3(t76, 0.10000000000000000000000000000000000000000000000000e1 - 0.18665085944258768548480312698291741183874251568800e0 * t74 - 0.19914010358223149895830444419972096970737867899790e0 * t83 * t88 - 0.60639971965846678503023596624343652890052150377469e0 * t95 * t99 - 0.76375207387723991077566056665447164522292648877806e-1 * t106 * t111 + 0.14594008525673758618635093453857443622481897843672e0 * t118 * t124 + 0.87379127649768217956886118366110753128149506595882e0 * t130 * t134 + 0.40664104271070688990929332974004665519976822489071e0 * t141 * t146 - 0.44134118356287122526486193965041092672803237476953e-3 * t153 * t159, 0.2e1 * t163 * t175)
  t179 = 0.1e1 - t178
  t181 = 0.1e1 / t57 / t79
  t182 = s0 * t181
  t183 = t182 * t63
  t184 = 0.13342809400364015280213860222187919752221792168441e-2 * t183
  t185 = s0 ** 2
  t187 = 0.1e1 / t34 / t93
  t190 = 0.15398708928290202558763221866801247678833192955196e-3 * t185 * t187 * t86
  t193 = t63 * (0.1e1 + t183 / 0.24e2)
  t195 = 0.34435261707988980716253443526170798898071625344353e-1 * t182 * t193
  t196 = t195 <= -t49
  t197 = t195 < -t49
  t198 = f.my_piecewise3(t197, -t49, t195)
  t200 = jnp.exp(-0.1e1 / t198)
  t201 = f.my_piecewise3(t196, 0, t200)
  t202 = 0.1e0 + t184 + t190 - t56
  t204 = -0.174e0 - t184 - t190 + t56 + t201 * t202
  t205 = t179 * t204
  t206 = t183 / 0.600e3
  t207 = t206 <= -t49
  t208 = t206 < -t49
  t209 = f.my_piecewise3(t208, -t49, t206)
  t211 = jnp.exp(-0.1e1 / t209)
  t212 = f.my_piecewise3(t207, 0, t211)
  t213 = 0.1e1 - t212
  t215 = 0.1174e1 - t56 + t205 * t213
  t219 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t220 = t219 * f.p.zeta_threshold
  t222 = f.my_piecewise3(t20, t220, t21 * t19)
  t223 = t30 ** 2
  t224 = 0.1e1 / t223
  t225 = t222 * t224
  t228 = t5 * t225 * t215 / 0.8e1
  t229 = t222 * t30
  t230 = t52 ** 2
  t231 = 0.1e1 / t230
  t234 = t32 / t45 * t33
  t241 = f.my_piecewise3(t51, 0, -0.22456215992867905800665153117708747369815701835347e-1 * t234 / t34 / t79 * t39 * t42)
  t244 = f.my_piecewise3(t50, 0, t231 * t241 * t54)
  t245 = 0.1174e1 * t244
  t246 = tau0 * t181
  t247 = t246 * t73
  t253 = f.my_piecewise3(t70, s0 / t79 * t66 / 0.8e1, 0)
  t254 = t63 * t253
  t255 = t60 * t254
  t259 = t78 / t34 / t92
  t262 = t83 * t39
  t263 = t85 * t72
  t264 = t263 * t253
  t268 = t91 / t103
  t271 = t97 * t87
  t272 = t271 * t253
  t275 = t92 * t80
  t278 = t102 / t57 / t275
  t281 = t106 * t38
  t282 = t108 * t98
  t283 = t282 * t253
  t289 = t114 / t34 / t115 / r0
  t292 = t118 * t39
  t293 = t121 * t110
  t294 = t293 * t253
  t298 = t127 / t138
  t301 = t132 * t123
  t302 = t301 * t253
  t305 = t115 * t92
  t308 = t137 / t57 / t305
  t311 = t141 * t38
  t312 = t143 * t133
  t313 = t312 * t253
  t319 = t149 / t34 / t115 / t103
  t322 = t153 * t39
  t323 = t156 * t145
  t324 = t323 * t253
  t327 = 0.31108476573764614247467187830486235306457085948000e0 * t247 - 0.18665085944258768548480312698291741183874251568800e0 * t255 + 0.66380034527410499652768148066573656569126226332633e0 * t259 * t88 - 0.39828020716446299791660888839944193941475735799580e0 * t262 * t264 + 0.30319985982923339251511798312171826445026075188734e1 * t268 * t99 - 0.18191991589754003550907078987303095867015645113241e1 * t95 * t272 + 0.50916804925149327385044037776964776348195099251871e0 * t278 * t111 - 0.30550082955089596431026422666178865808917059551122e0 * t281 * t283 - 0.12161673771394798848862577878214536352068248203060e1 * t289 * t124 + 0.72970042628368793093175467269287218112409489218360e0 * t292 * t294 - 0.87379127649768217956886118366110753128149506595882e1 * t298 * t134 + 0.52427476589860930774131671019666451876889703957529e1 * t130 * t302 - 0.47441454982915803822750888469672109773306292903916e1 * t308 * t146 + 0.28464872989749482293650533081803265863983775742350e1 * t311 * t313 + 0.58845491141716163368648258620054790230404316635937e-2 * t319 * t159 - 0.35307294685029698021188955172032874138242589981562e-2 * t322 * t324
  t331 = f.my_piecewise3(t164, -0.25e2 / 0.27e2 * t247 + 0.5e1 / 0.9e1 * t255, 0)
  t334 = t165 ** 2
  t335 = 0.1e1 / t334
  t336 = t166 * t335
  t341 = -0.12063067191025636561756297344054915325509498465082e1 * t331 * t167 + 0.12063067191025636561756297344054915325509498465082e1 * t336 * t331 - 0.22206712118690530507219997476860916252554783972356e1 * t166 * t331
  t342 = t172 ** 2
  t345 = 0.1e1 + t40 * t342 / 0.4e1
  t346 = 0.1e1 / t345
  t348 = f.my_piecewise3(t76, t327, t341 * t346)
  t349 = t348 * t204
  t352 = 0.1e1 / t57 / t80
  t353 = s0 * t352
  t354 = t353 * t63
  t355 = 0.35580825067637374080570293925834452672591445782509e-2 * t354
  t359 = t185 / t34 / t103 * t86
  t360 = 0.82126447617547746980070516622939987620443695761045e-3 * t359
  t361 = t198 ** 2
  t362 = 0.1e1 / t361
  t367 = f.my_piecewise3(t197, 0, -0.91827364554637281910009182736455463728191000918275e-1 * t353 * t193 - 0.38261401897765534129170492806856443220079583715948e-2 * t359)
  t370 = f.my_piecewise3(t196, 0, t362 * t367 * t200)
  t372 = -t355 - t360 - t245
  t374 = t201 * t372 + t202 * t370 + t245 + t355 + t360
  t375 = t179 * t374
  t377 = t209 ** 2
  t378 = 0.1e1 / t377
  t380 = f.my_piecewise3(t208, 0, -t354 / 0.225e3)
  t383 = f.my_piecewise3(t207, 0, t378 * t380 * t211)
  t385 = -t205 * t383 - t213 * t349 + t213 * t375 - t245
  t390 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t215 - t228 - 0.3e1 / 0.8e1 * t5 * t229 * t385)
  t392 = r1 <= f.p.dens_threshold
  t393 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t394 = 0.1e1 + t393
  t395 = t394 <= f.p.zeta_threshold
  t396 = t394 ** (0.1e1 / 0.3e1)
  t398 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t401 = f.my_piecewise3(t395, 0, 0.4e1 / 0.3e1 * t396 * t398)
  t402 = t401 * t30
  t403 = jnp.sqrt(s2)
  t404 = r1 ** (0.1e1 / 0.3e1)
  t408 = t403 / t404 / r1 * t43
  t409 = jnp.sqrt(t408)
  t411 = 0.33684323989301858700997729676563121054723552753020e-1 * t32 * t409
  t412 = t411 <= -t49
  t413 = t411 < -t49
  t414 = f.my_piecewise3(t413, -t49, t411)
  t416 = jnp.exp(-0.1e1 / t414)
  t417 = f.my_piecewise3(t412, 0, t416)
  t418 = 0.1174e1 * t417
  t419 = t404 ** 2
  t422 = tau1 / t419 / r1
  t425 = 0.1e1 / tau1
  t427 = s2 / r1 * t425 / 0.8e1
  t429 = 0.0e0 < 0.9999999999e0 - t427
  t431 = f.my_piecewise3(t429, 0.1e1 - t427, 0.1e-9)
  t432 = t63 * t431
  t433 = t422 * t432
  t434 = 0.5e1 / 0.9e1 * t433
  t435 = t434 <= DBL_EPSILON
  t437 = tau1 ** 2
  t438 = r1 ** 2
  t439 = t438 * r1
  t441 = 0.1e1 / t404 / t439
  t442 = t437 * t441
  t443 = t431 ** 2
  t444 = t86 * t443
  t447 = t437 * tau1
  t448 = t438 ** 2
  t449 = t448 * r1
  t451 = t447 / t449
  t452 = t443 * t431
  t453 = t97 * t452
  t456 = t437 ** 2
  t457 = t448 * t438
  t460 = t456 / t419 / t457
  t461 = t443 ** 2
  t462 = t109 * t461
  t465 = t456 * tau1
  t466 = t448 ** 2
  t469 = t465 / t404 / t466
  t470 = t461 * t431
  t471 = t122 * t470
  t474 = t456 * t437
  t475 = t466 * t438
  t477 = t474 / t475
  t478 = t461 * t443
  t479 = t132 * t478
  t482 = t456 * t447
  t483 = t466 * t439
  t486 = t482 / t419 / t483
  t487 = t461 * t452
  t488 = t144 * t487
  t491 = t456 ** 2
  t492 = t466 * t449
  t495 = t491 / t404 / t492
  t496 = t461 ** 2
  t497 = t157 * t496
  t501 = DBL_EPSILON < t434
  t502 = f.my_piecewise3(t501, t434, DBL_EPSILON)
  t503 = t502 - 0.1e1
  t504 = 0.1e1 / t502
  t507 = t503 ** 2
  t509 = -0.12063067191025636561756297344054915325509498465082e1 * t503 * t504 - 0.11103356059345265253609998738430458126277391986178e1 * t507
  t512 = jnp.arctan(jnp.pi * t509 / 0.2e1)
  t515 = f.my_piecewise3(t435, 0.10000000000000000000000000000000000000000000000000e1 - 0.18665085944258768548480312698291741183874251568800e0 * t433 - 0.19914010358223149895830444419972096970737867899790e0 * t442 * t444 - 0.60639971965846678503023596624343652890052150377469e0 * t451 * t453 - 0.76375207387723991077566056665447164522292648877806e-1 * t460 * t462 + 0.14594008525673758618635093453857443622481897843672e0 * t469 * t471 + 0.87379127649768217956886118366110753128149506595882e0 * t477 * t479 + 0.40664104271070688990929332974004665519976822489071e0 * t486 * t488 - 0.44134118356287122526486193965041092672803237476953e-3 * t495 * t497, 0.2e1 * t163 * t512)
  t516 = 0.1e1 - t515
  t518 = 0.1e1 / t419 / t438
  t519 = s2 * t518
  t520 = t519 * t63
  t521 = 0.13342809400364015280213860222187919752221792168441e-2 * t520
  t522 = s2 ** 2
  t524 = 0.1e1 / t404 / t449
  t527 = 0.15398708928290202558763221866801247678833192955196e-3 * t522 * t524 * t86
  t530 = t63 * (0.1e1 + t520 / 0.24e2)
  t532 = 0.34435261707988980716253443526170798898071625344353e-1 * t519 * t530
  t533 = t532 <= -t49
  t534 = t532 < -t49
  t535 = f.my_piecewise3(t534, -t49, t532)
  t537 = jnp.exp(-0.1e1 / t535)
  t538 = f.my_piecewise3(t533, 0, t537)
  t539 = 0.1e0 + t521 + t527 - t418
  t541 = -0.174e0 - t521 - t527 + t418 + t538 * t539
  t542 = t516 * t541
  t543 = t520 / 0.600e3
  t544 = t543 <= -t49
  t545 = t543 < -t49
  t546 = f.my_piecewise3(t545, -t49, t543)
  t548 = jnp.exp(-0.1e1 / t546)
  t549 = f.my_piecewise3(t544, 0, t548)
  t550 = 0.1e1 - t549
  t552 = 0.1174e1 - t418 + t542 * t550
  t557 = f.my_piecewise3(t395, t220, t396 * t394)
  t558 = t557 * t224
  t561 = t5 * t558 * t552 / 0.8e1
  t563 = f.my_piecewise3(t392, 0, -0.3e1 / 0.8e1 * t5 * t402 * t552 - t561)
  t565 = t21 ** 2
  t566 = 0.1e1 / t565
  t567 = t26 ** 2
  t572 = t16 / t22 / t6
  t574 = -0.2e1 * t23 + 0.2e1 * t572
  t575 = f.my_piecewise5(t10, 0, t14, 0, t574)
  t579 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t566 * t567 + 0.4e1 / 0.3e1 * t21 * t575)
  t586 = t5 * t29 * t224 * t215
  t592 = 0.1e1 / t223 / t6
  t596 = t5 * t222 * t592 * t215 / 0.12e2
  t598 = t5 * t225 * t385
  t602 = t241 ** 2
  t611 = 0.1e1 / t57 / t92
  t621 = f.my_piecewise3(t51, 0, -0.89824863971471623202660612470834989479262807341388e-1 * t32 / t45 / t44 * s0 * t611 * t38 * t62 + 0.52397837316691780201552023941320410529569970949143e-1 * t234 * t82 * t39 * t42)
  t624 = t230 ** 2
  t629 = f.my_piecewise3(t50, 0, -0.2e1 / t230 / t52 * t602 * t54 + t231 * t621 * t54 + 0.1e1 / t624 * t602 * t54)
  t630 = 0.1174e1 * t629
  t643 = t253 ** 2
  t663 = f.my_piecewise3(t70, -s0 / t80 * t66 / 0.4e1, 0)
  t688 = -0.18191991589754003550907078987303095867015645113240e2 * t91 / t275 * t99 + 0.96117040414745039752574730202721828440964457255470e2 * t127 / t305 * t134 + 0.94152785826745861389837213792087664368646906617499e-1 * t319 * t39 * t324 - 0.91650248865268789293079267998536597426751178653366e0 * t281 * t108 * t87 * t643 + 0.29188017051347517237270186907714887244963795687344e1 * t292 * t121 * t98 * t643 + 0.17078923793849689376190319849081959518390265445410e2 * t311 * t143 * t123 * t643 - 0.24715106279520788614832268620423011896769812987093e-1 * t322 * t156 * t133 * t643 - 0.35307294685029698021188955172032874138242589981562e-2 * t322 * t323 * t663 + 0.26552013810964199861107259226629462627650490533054e1 * t259 * t39 * t264 - 0.39828020716446299791660888839944193941475735799580e0 * t262 * t263 * t663 + 0.40733443940119461908035230221571821078556079401496e1 * t278 * t38 * t283 - 0.30550082955089596431026422666178865808917059551122e0 * t281 * t282 * t663 - 0.12161673771394798848862577878214536352068248203060e2 * t289 * t39 * t294 + 0.72970042628368793093175467269287218112409489218360e0 * t292 * t293 * t663 - 0.66418036976082125351851243857540953682628810065483e2 * t308 * t38 * t313
  t738 = tau0 * t352 * t73
  t740 = t246 * t254
  t743 = t60 * t63 * t663
  t745 = 0.28464872989749482293650533081803265863983775742350e1 * t311 * t312 * t663 - 0.39036217109281150995200428962339661866949576093101e1 * t102 / t57 / t115 * t111 + 0.11350895519968478925605072686333567261930364989523e2 * t114 / t34 / t128 * t124 + 0.26213738294930465387065835509833225938444851978764e2 * t130 * t132 * t110 * t643 + 0.60092509645026684842151125394918005712854637678294e2 * t137 / t57 / t150 * t146 - 0.84345203969793167495062504022078532663579520511510e-1 * t149 / t34 / t115 / t275 * t159 + 0.18191991589754003550907078987303095867015645113241e2 * t268 * t272 - 0.18191991589754003550907078987303095867015645113241e1 * t95 * t271 * t663 - 0.10485495317972186154826334203933290375377940791506e3 * t298 * t302 + 0.52427476589860930774131671019666451876889703957529e1 * t130 * t301 * t663 - 0.28764681628544549849532864162181917846621364744141e1 * t78 * t187 * t88 - 0.39828020716446299791660888839944193941475735799580e0 * t83 * t86 * t643 - 0.36383983179508007101814157974606191734031290226482e1 * t95 * t97 * t72 * t643 - 0.82955937530038971326579167547963294150552229194667e0 * t738 + 0.62216953147529228494934375660972470612914171896000e0 * t740 - 0.18665085944258768548480312698291741183874251568800e0 * t743
  t751 = f.my_piecewise3(t164, 0.200e3 / 0.81e2 * t738 - 0.50e2 / 0.27e2 * t740 + 0.5e1 / 0.9e1 * t743, 0)
  t754 = t331 ** 2
  t769 = t341 ** 2
  t770 = t345 ** 2
  t777 = f.my_piecewise3(t76, t688 + t745, (-0.12063067191025636561756297344054915325509498465082e1 * t751 * t167 + 0.24126134382051273123512594688109830651018996930164e1 * t754 * t335 - 0.24126134382051273123512594688109830651018996930164e1 * t166 / t334 / t165 * t754 + 0.12063067191025636561756297344054915325509498465082e1 * t336 * t751 - 0.22206712118690530507219997476860916252554783972356e1 * t754 - 0.22206712118690530507219997476860916252554783972356e1 * t166 * t751) * t346 - t769 / t770 * t40 * t172 / 0.2e1)
  t785 = s0 * t611
  t786 = t785 * t63
  t787 = 0.13046302524800370496209107772805965979950196786920e-1 * t786
  t791 = t185 / t34 / t275 * t86
  t792 = 0.52013416824446906420711327194528658826281007315328e-2 * t791
  t795 = t367 ** 2
  t803 = f.my_piecewise3(t197, 0, 0.33670033670033670033670033670033670033670033670034e0 * t785 * t193 + 0.34435261707988980716253443526170798898071625344353e-1 * t791)
  t806 = t361 ** 2
  t811 = f.my_piecewise3(t196, 0, -0.2e1 / t361 / t198 * t795 * t200 + t362 * t803 * t200 + 0.1e1 / t806 * t795 * t200)
  t824 = t380 ** 2
  t829 = f.my_piecewise3(t208, 0, 0.11e2 / 0.675e3 * t786)
  t832 = t377 ** 2
  t837 = f.my_piecewise3(t207, 0, -0.2e1 / t377 / t209 * t824 * t211 + t378 * t829 * t211 + 0.1e1 / t832 * t824 * t211)
  t844 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t579 * t30 * t215 - t586 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t385 + t596 - t598 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t229 * (-t630 - t777 * t204 * t213 - 0.2e1 * t348 * t374 * t213 + 0.2e1 * t349 * t383 + t179 * (-t787 - t792 + t630 + t811 * t202 + 0.2e1 * t370 * t372 + t201 * (t787 + t792 - t630)) * t213 - 0.2e1 * t375 * t383 - t205 * t837))
  t845 = t396 ** 2
  t846 = 0.1e1 / t845
  t847 = t398 ** 2
  t851 = f.my_piecewise5(t14, 0, t10, 0, -t574)
  t855 = f.my_piecewise3(t395, 0, 0.4e1 / 0.9e1 * t846 * t847 + 0.4e1 / 0.3e1 * t396 * t851)
  t862 = t5 * t401 * t224 * t552
  t867 = t5 * t557 * t592 * t552 / 0.12e2
  t869 = f.my_piecewise3(t392, 0, -0.3e1 / 0.8e1 * t5 * t855 * t30 * t552 - t862 / 0.4e1 + t867)
  d11 = 0.2e1 * t390 + 0.2e1 * t563 + t6 * (t844 + t869)
  t872 = -t7 - t24
  t873 = f.my_piecewise5(t10, 0, t14, 0, t872)
  t876 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t873)
  t877 = t876 * t30
  t882 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t877 * t215 - t228)
  t884 = f.my_piecewise5(t14, 0, t10, 0, -t872)
  t887 = f.my_piecewise3(t395, 0, 0.4e1 / 0.3e1 * t396 * t884)
  t888 = t887 * t30
  t892 = t557 * t30
  t893 = t414 ** 2
  t894 = 0.1e1 / t893
  t897 = t32 / t409 * t403
  t904 = f.my_piecewise3(t413, 0, -0.22456215992867905800665153117708747369815701835347e-1 * t897 / t404 / t438 * t39 * t42)
  t907 = f.my_piecewise3(t412, 0, t894 * t904 * t416)
  t908 = 0.1174e1 * t907
  t909 = tau1 * t518
  t910 = t909 * t432
  t916 = f.my_piecewise3(t429, s2 / t438 * t425 / 0.8e1, 0)
  t917 = t63 * t916
  t918 = t422 * t917
  t922 = t437 / t404 / t448
  t925 = t442 * t39
  t926 = t85 * t431
  t927 = t926 * t916
  t931 = t447 / t457
  t934 = t97 * t443
  t935 = t934 * t916
  t938 = t448 * t439
  t941 = t456 / t419 / t938
  t944 = t460 * t38
  t945 = t108 * t452
  t946 = t945 * t916
  t952 = t465 / t404 / t466 / r1
  t955 = t469 * t39
  t956 = t121 * t461
  t957 = t956 * t916
  t961 = t474 / t483
  t964 = t132 * t470
  t965 = t964 * t916
  t968 = t466 * t448
  t971 = t482 / t419 / t968
  t974 = t486 * t38
  t975 = t143 * t478
  t976 = t975 * t916
  t982 = t491 / t404 / t466 / t457
  t985 = t495 * t39
  t986 = t156 * t487
  t987 = t986 * t916
  t990 = 0.31108476573764614247467187830486235306457085948000e0 * t910 - 0.18665085944258768548480312698291741183874251568800e0 * t918 + 0.66380034527410499652768148066573656569126226332633e0 * t922 * t444 - 0.39828020716446299791660888839944193941475735799580e0 * t925 * t927 + 0.30319985982923339251511798312171826445026075188734e1 * t931 * t453 - 0.18191991589754003550907078987303095867015645113241e1 * t451 * t935 + 0.50916804925149327385044037776964776348195099251871e0 * t941 * t462 - 0.30550082955089596431026422666178865808917059551122e0 * t944 * t946 - 0.12161673771394798848862577878214536352068248203060e1 * t952 * t471 + 0.72970042628368793093175467269287218112409489218360e0 * t955 * t957 - 0.87379127649768217956886118366110753128149506595882e1 * t961 * t479 + 0.52427476589860930774131671019666451876889703957529e1 * t477 * t965 - 0.47441454982915803822750888469672109773306292903916e1 * t971 * t488 + 0.28464872989749482293650533081803265863983775742350e1 * t974 * t976 + 0.58845491141716163368648258620054790230404316635937e-2 * t982 * t497 - 0.35307294685029698021188955172032874138242589981562e-2 * t985 * t987
  t994 = f.my_piecewise3(t501, -0.25e2 / 0.27e2 * t910 + 0.5e1 / 0.9e1 * t918, 0)
  t997 = t502 ** 2
  t998 = 0.1e1 / t997
  t999 = t503 * t998
  t1004 = -0.12063067191025636561756297344054915325509498465082e1 * t994 * t504 + 0.12063067191025636561756297344054915325509498465082e1 * t999 * t994 - 0.22206712118690530507219997476860916252554783972356e1 * t503 * t994
  t1005 = t509 ** 2
  t1008 = 0.1e1 + t40 * t1005 / 0.4e1
  t1009 = 0.1e1 / t1008
  t1011 = f.my_piecewise3(t435, t990, t1004 * t1009)
  t1012 = t1011 * t541
  t1015 = 0.1e1 / t419 / t439
  t1016 = s2 * t1015
  t1017 = t1016 * t63
  t1018 = 0.35580825067637374080570293925834452672591445782509e-2 * t1017
  t1022 = t522 / t404 / t457 * t86
  t1023 = 0.82126447617547746980070516622939987620443695761045e-3 * t1022
  t1024 = t535 ** 2
  t1025 = 0.1e1 / t1024
  t1030 = f.my_piecewise3(t534, 0, -0.91827364554637281910009182736455463728191000918275e-1 * t1016 * t530 - 0.38261401897765534129170492806856443220079583715948e-2 * t1022)
  t1033 = f.my_piecewise3(t533, 0, t1025 * t1030 * t537)
  t1035 = -t1018 - t1023 - t908
  t1037 = t1033 * t539 + t1035 * t538 + t1018 + t1023 + t908
  t1038 = t516 * t1037
  t1040 = t546 ** 2
  t1041 = 0.1e1 / t1040
  t1043 = f.my_piecewise3(t545, 0, -t1017 / 0.225e3)
  t1046 = f.my_piecewise3(t544, 0, t1041 * t1043 * t548)
  t1048 = -t1012 * t550 + t1038 * t550 - t1046 * t542 - t908
  t1053 = f.my_piecewise3(t392, 0, -0.3e1 / 0.8e1 * t5 * t888 * t552 - t561 - 0.3e1 / 0.8e1 * t5 * t892 * t1048)
  t1057 = 0.2e1 * t572
  t1058 = f.my_piecewise5(t10, 0, t14, 0, t1057)
  t1062 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t566 * t873 * t26 + 0.4e1 / 0.3e1 * t21 * t1058)
  t1069 = t5 * t876 * t224 * t215
  t1077 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1062 * t30 * t215 - t1069 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t877 * t385 - t586 / 0.8e1 + t596 - t598 / 0.8e1)
  t1081 = f.my_piecewise5(t14, 0, t10, 0, -t1057)
  t1085 = f.my_piecewise3(t395, 0, 0.4e1 / 0.9e1 * t846 * t884 * t398 + 0.4e1 / 0.3e1 * t396 * t1081)
  t1092 = t5 * t887 * t224 * t552
  t1099 = t5 * t558 * t1048
  t1102 = f.my_piecewise3(t392, 0, -0.3e1 / 0.8e1 * t5 * t1085 * t30 * t552 - t1092 / 0.8e1 - t862 / 0.8e1 + t867 - 0.3e1 / 0.8e1 * t5 * t402 * t1048 - t1099 / 0.8e1)
  d12 = t390 + t563 + t882 + t1053 + t6 * (t1077 + t1102)
  t1107 = t873 ** 2
  t1111 = 0.2e1 * t23 + 0.2e1 * t572
  t1112 = f.my_piecewise5(t10, 0, t14, 0, t1111)
  t1116 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t566 * t1107 + 0.4e1 / 0.3e1 * t21 * t1112)
  t1123 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1116 * t30 * t215 - t1069 / 0.4e1 + t596)
  t1124 = t884 ** 2
  t1128 = f.my_piecewise5(t14, 0, t10, 0, -t1111)
  t1132 = f.my_piecewise3(t395, 0, 0.4e1 / 0.9e1 * t846 * t1124 + 0.4e1 / 0.3e1 * t396 * t1128)
  t1144 = t904 ** 2
  t1153 = 0.1e1 / t419 / t448
  t1163 = f.my_piecewise3(t413, 0, -0.89824863971471623202660612470834989479262807341388e-1 * t32 / t409 / t408 * s2 * t1153 * t38 * t62 + 0.52397837316691780201552023941320410529569970949143e-1 * t897 * t441 * t39 * t42)
  t1166 = t893 ** 2
  t1171 = f.my_piecewise3(t412, 0, -0.2e1 / t893 / t414 * t1144 * t416 + t894 * t1163 * t416 + 0.1e1 / t1166 * t1144 * t416)
  t1172 = 0.1174e1 * t1171
  t1185 = f.my_piecewise3(t429, -s2 / t439 * t425 / 0.4e1, 0)
  t1199 = t916 ** 2
  t1230 = -0.18191991589754003550907078987303095867015645113240e2 * t447 / t938 * t453 + 0.96117040414745039752574730202721828440964457255470e2 * t474 / t968 * t479 + 0.28464872989749482293650533081803265863983775742350e1 * t974 * t975 * t1185 + 0.94152785826745861389837213792087664368646906617499e-1 * t982 * t39 * t987 - 0.35307294685029698021188955172032874138242589981562e-2 * t985 * t986 * t1185 + 0.26552013810964199861107259226629462627650490533054e1 * t922 * t39 * t927 - 0.91650248865268789293079267998536597426751178653366e0 * t944 * t108 * t443 * t1199 + 0.29188017051347517237270186907714887244963795687344e1 * t955 * t121 * t452 * t1199 + 0.17078923793849689376190319849081959518390265445410e2 * t974 * t143 * t470 * t1199 - 0.24715106279520788614832268620423011896769812987093e-1 * t985 * t156 * t478 * t1199 - 0.39828020716446299791660888839944193941475735799580e0 * t925 * t926 * t1185 + 0.40733443940119461908035230221571821078556079401496e1 * t941 * t38 * t946 - 0.30550082955089596431026422666178865808917059551122e0 * t944 * t945 * t1185 - 0.12161673771394798848862577878214536352068248203060e2 * t952 * t39 * t957 + 0.72970042628368793093175467269287218112409489218360e0 * t955 * t956 * t1185
  t1280 = tau1 * t1015 * t432
  t1282 = t909 * t917
  t1285 = t422 * t63 * t1185
  t1287 = -0.66418036976082125351851243857540953682628810065483e2 * t971 * t38 * t976 - 0.28764681628544549849532864162181917846621364744141e1 * t437 * t524 * t444 + 0.18191991589754003550907078987303095867015645113241e2 * t931 * t935 - 0.18191991589754003550907078987303095867015645113241e1 * t451 * t934 * t1185 - 0.10485495317972186154826334203933290375377940791506e3 * t961 * t965 + 0.52427476589860930774131671019666451876889703957529e1 * t477 * t964 * t1185 - 0.39828020716446299791660888839944193941475735799580e0 * t442 * t86 * t1199 - 0.36383983179508007101814157974606191734031290226482e1 * t451 * t97 * t431 * t1199 - 0.39036217109281150995200428962339661866949576093101e1 * t456 / t419 / t466 * t462 + 0.11350895519968478925605072686333567261930364989523e2 * t465 / t404 / t475 * t471 + 0.26213738294930465387065835509833225938444851978764e2 * t477 * t132 * t461 * t1199 + 0.60092509645026684842151125394918005712854637678294e2 * t482 / t419 / t492 * t488 - 0.84345203969793167495062504022078532663579520511510e-1 * t491 / t404 / t466 / t938 * t497 - 0.82955937530038971326579167547963294150552229194667e0 * t1280 + 0.62216953147529228494934375660972470612914171896000e0 * t1282 - 0.18665085944258768548480312698291741183874251568800e0 * t1285
  t1293 = f.my_piecewise3(t501, 0.200e3 / 0.81e2 * t1280 - 0.50e2 / 0.27e2 * t1282 + 0.5e1 / 0.9e1 * t1285, 0)
  t1296 = t994 ** 2
  t1311 = t1004 ** 2
  t1312 = t1008 ** 2
  t1319 = f.my_piecewise3(t435, t1230 + t1287, (-0.12063067191025636561756297344054915325509498465082e1 * t1293 * t504 + 0.24126134382051273123512594688109830651018996930164e1 * t1296 * t998 - 0.24126134382051273123512594688109830651018996930164e1 * t503 / t997 / t502 * t1296 + 0.12063067191025636561756297344054915325509498465082e1 * t999 * t1293 - 0.22206712118690530507219997476860916252554783972356e1 * t1296 - 0.22206712118690530507219997476860916252554783972356e1 * t503 * t1293) * t1009 - t1311 / t1312 * t40 * t509 / 0.2e1)
  t1327 = s2 * t1153
  t1328 = t1327 * t63
  t1329 = 0.13046302524800370496209107772805965979950196786920e-1 * t1328
  t1333 = t522 / t404 / t938 * t86
  t1334 = 0.52013416824446906420711327194528658826281007315328e-2 * t1333
  t1337 = t1030 ** 2
  t1345 = f.my_piecewise3(t534, 0, 0.33670033670033670033670033670033670033670033670034e0 * t1327 * t530 + 0.34435261707988980716253443526170798898071625344353e-1 * t1333)
  t1348 = t1024 ** 2
  t1353 = f.my_piecewise3(t533, 0, -0.2e1 / t1024 / t535 * t1337 * t537 + t1025 * t1345 * t537 + 0.1e1 / t1348 * t1337 * t537)
  t1366 = t1043 ** 2
  t1371 = f.my_piecewise3(t545, 0, 0.11e2 / 0.675e3 * t1328)
  t1374 = t1040 ** 2
  t1379 = f.my_piecewise3(t544, 0, -0.2e1 / t1040 / t546 * t1366 * t548 + t1041 * t1371 * t548 + 0.1e1 / t1374 * t1366 * t548)
  t1386 = f.my_piecewise3(t392, 0, -0.3e1 / 0.8e1 * t5 * t1132 * t30 * t552 - t1092 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t888 * t1048 + t867 - t1099 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t892 * (-t1172 - t1319 * t541 * t550 - 0.2e1 * t1011 * t1037 * t550 + 0.2e1 * t1012 * t1046 + t516 * (-t1329 - t1334 + t1172 + t1353 * t539 + 0.2e1 * t1033 * t1035 + t538 * (t1329 + t1334 - t1172)) * t550 - 0.2e1 * t1038 * t1046 - t542 * t1379))
  d22 = 0.2e1 * t882 + 0.2e1 * t1053 + t6 * (t1123 + t1386)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = jnp.sqrt(0.3e1)
  t45 = jnp.sqrt(s0)
  t46 = r0 ** (0.1e1 / 0.3e1)
  t50 = 6 ** (0.1e1 / 0.3e1)
  t51 = t50 ** 2
  t52 = jnp.pi ** 2
  t53 = t52 ** (0.1e1 / 0.3e1)
  t54 = 0.1e1 / t53
  t55 = t51 * t54
  t56 = t45 / t46 / r0 * t55
  t57 = jnp.sqrt(t56)
  t59 = 0.33684323989301858700997729676563121054723552753020e-1 * t44 * t57
  t60 = jnp.log(DBL_EPSILON)
  t61 = 0.1e1 / t60
  t62 = t59 <= -t61
  t63 = t59 < -t61
  t64 = f.my_piecewise3(t63, -t61, t59)
  t66 = jnp.exp(-0.1e1 / t64)
  t67 = f.my_piecewise3(t62, 0, t66)
  t68 = 0.1174e1 * t67
  t69 = t46 ** 2
  t72 = tau0 / t69 / r0
  t73 = t53 ** 2
  t74 = 0.1e1 / t73
  t75 = t50 * t74
  t78 = 0.1e1 / tau0
  t80 = s0 / r0 * t78 / 0.8e1
  t82 = 0.0e0 < 0.9999999999e0 - t80
  t84 = f.my_piecewise3(t82, 0.1e1 - t80, 0.1e-9)
  t85 = t75 * t84
  t86 = t72 * t85
  t87 = 0.5e1 / 0.9e1 * t86
  t88 = t87 <= DBL_EPSILON
  t90 = tau0 ** 2
  t91 = r0 ** 2
  t92 = t91 * r0
  t94 = 0.1e1 / t46 / t92
  t95 = t90 * t94
  t97 = 0.1e1 / t53 / t52
  t98 = t51 * t97
  t99 = t84 ** 2
  t100 = t98 * t99
  t103 = t90 * tau0
  t104 = t91 ** 2
  t105 = t104 * r0
  t107 = t103 / t105
  t108 = t52 ** 2
  t109 = 0.1e1 / t108
  t110 = t99 * t84
  t111 = t109 * t110
  t114 = t90 ** 2
  t115 = t104 * t91
  t118 = t114 / t69 / t115
  t120 = 0.1e1 / t73 / t108
  t121 = t50 * t120
  t122 = t99 ** 2
  t123 = t121 * t122
  t126 = t114 * tau0
  t127 = t104 ** 2
  t129 = 0.1e1 / t46 / t127
  t130 = t126 * t129
  t133 = 0.1e1 / t53 / t108 / t52
  t134 = t51 * t133
  t135 = t122 * t84
  t136 = t134 * t135
  t139 = t114 * t90
  t140 = t127 * t91
  t142 = t139 / t140
  t143 = t108 ** 2
  t144 = 0.1e1 / t143
  t145 = t122 * t99
  t146 = t144 * t145
  t149 = t114 * t103
  t150 = t127 * t92
  t153 = t149 / t69 / t150
  t155 = 0.1e1 / t73 / t143
  t156 = t50 * t155
  t157 = t122 * t110
  t158 = t156 * t157
  t161 = t114 ** 2
  t162 = t127 * t105
  t165 = t161 / t46 / t162
  t168 = 0.1e1 / t53 / t143 / t52
  t169 = t51 * t168
  t170 = t122 ** 2
  t171 = t169 * t170
  t175 = 0.1e1 / jnp.pi
  t176 = DBL_EPSILON < t87
  t177 = f.my_piecewise3(t176, t87, DBL_EPSILON)
  t178 = t177 - 0.1e1
  t179 = 0.1e1 / t177
  t182 = t178 ** 2
  t184 = -0.12063067191025636561756297344054915325509498465082e1 * t178 * t179 - 0.11103356059345265253609998738430458126277391986178e1 * t182
  t187 = jnp.atan(jnp.pi * t184 / 0.2e1)
  t190 = f.my_piecewise3(t88, 0.10000000000000000000000000000000000000000000000000e1 - 0.18665085944258768548480312698291741183874251568800e0 * t86 - 0.19914010358223149895830444419972096970737867899790e0 * t95 * t100 - 0.60639971965846678503023596624343652890052150377469e0 * t107 * t111 - 0.76375207387723991077566056665447164522292648877806e-1 * t118 * t123 + 0.14594008525673758618635093453857443622481897843672e0 * t130 * t136 + 0.87379127649768217956886118366110753128149506595882e0 * t142 * t146 + 0.40664104271070688990929332974004665519976822489071e0 * t153 * t158 - 0.44134118356287122526486193965041092672803237476953e-3 * t165 * t171, 0.2e1 * t175 * t187)
  t191 = 0.1e1 - t190
  t193 = 0.1e1 / t69 / t91
  t194 = s0 * t193
  t195 = t194 * t75
  t196 = 0.13342809400364015280213860222187919752221792168441e-2 * t195
  t197 = s0 ** 2
  t199 = 0.1e1 / t46 / t105
  t202 = 0.15398708928290202558763221866801247678833192955196e-3 * t197 * t199 * t98
  t205 = t75 * (0.1e1 + t195 / 0.24e2)
  t207 = 0.34435261707988980716253443526170798898071625344353e-1 * t194 * t205
  t208 = t207 <= -t61
  t209 = t207 < -t61
  t210 = f.my_piecewise3(t209, -t61, t207)
  t212 = jnp.exp(-0.1e1 / t210)
  t213 = f.my_piecewise3(t208, 0, t212)
  t214 = 0.1e0 + t196 + t202 - t68
  t216 = -0.174e0 - t196 - t202 + t68 + t213 * t214
  t217 = t191 * t216
  t218 = t195 / 0.600e3
  t219 = t218 <= -t61
  t220 = t218 < -t61
  t221 = f.my_piecewise3(t220, -t61, t218)
  t223 = jnp.exp(-0.1e1 / t221)
  t224 = f.my_piecewise3(t219, 0, t223)
  t225 = 0.1e1 - t224
  t227 = 0.1174e1 - t68 + t217 * t225
  t233 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t234 = t42 ** 2
  t235 = 0.1e1 / t234
  t236 = t233 * t235
  t240 = t233 * t42
  t241 = t64 ** 2
  t242 = 0.1e1 / t241
  t245 = t44 / t57 * t45
  t252 = f.my_piecewise3(t63, 0, -0.22456215992867905800665153117708747369815701835347e-1 * t245 / t46 / t91 * t51 * t54)
  t255 = f.my_piecewise3(t62, 0, t242 * t252 * t66)
  t256 = 0.1174e1 * t255
  t257 = tau0 * t193
  t258 = t257 * t85
  t264 = f.my_piecewise3(t82, s0 / t91 * t78 / 0.8e1, 0)
  t265 = t75 * t264
  t266 = t72 * t265
  t269 = 0.1e1 / t46 / t104
  t270 = t90 * t269
  t273 = t95 * t51
  t274 = t97 * t84
  t275 = t274 * t264
  t279 = t103 / t115
  t282 = t109 * t99
  t283 = t282 * t264
  t286 = t104 * t92
  t289 = t114 / t69 / t286
  t292 = t118 * t50
  t293 = t120 * t110
  t294 = t293 * t264
  t297 = t127 * r0
  t300 = t126 / t46 / t297
  t303 = t130 * t51
  t304 = t133 * t122
  t305 = t304 * t264
  t309 = t139 / t150
  t312 = t144 * t135
  t313 = t312 * t264
  t316 = t127 * t104
  t319 = t149 / t69 / t316
  t322 = t153 * t50
  t323 = t155 * t145
  t324 = t323 * t264
  t327 = t127 * t115
  t330 = t161 / t46 / t327
  t333 = t165 * t51
  t334 = t168 * t157
  t335 = t334 * t264
  t338 = 0.31108476573764614247467187830486235306457085948000e0 * t258 - 0.18665085944258768548480312698291741183874251568800e0 * t266 + 0.66380034527410499652768148066573656569126226332633e0 * t270 * t100 - 0.39828020716446299791660888839944193941475735799580e0 * t273 * t275 + 0.30319985982923339251511798312171826445026075188734e1 * t279 * t111 - 0.18191991589754003550907078987303095867015645113241e1 * t107 * t283 + 0.50916804925149327385044037776964776348195099251871e0 * t289 * t123 - 0.30550082955089596431026422666178865808917059551122e0 * t292 * t294 - 0.12161673771394798848862577878214536352068248203060e1 * t300 * t136 + 0.72970042628368793093175467269287218112409489218360e0 * t303 * t305 - 0.87379127649768217956886118366110753128149506595882e1 * t309 * t146 + 0.52427476589860930774131671019666451876889703957529e1 * t142 * t313 - 0.47441454982915803822750888469672109773306292903916e1 * t319 * t158 + 0.28464872989749482293650533081803265863983775742350e1 * t322 * t324 + 0.58845491141716163368648258620054790230404316635937e-2 * t330 * t171 - 0.35307294685029698021188955172032874138242589981562e-2 * t333 * t335
  t342 = f.my_piecewise3(t176, -0.25e2 / 0.27e2 * t258 + 0.5e1 / 0.9e1 * t266, 0)
  t345 = t177 ** 2
  t346 = 0.1e1 / t345
  t347 = t178 * t346
  t352 = -0.12063067191025636561756297344054915325509498465082e1 * t342 * t179 + 0.12063067191025636561756297344054915325509498465082e1 * t347 * t342 - 0.22206712118690530507219997476860916252554783972356e1 * t178 * t342
  t353 = t184 ** 2
  t356 = 0.1e1 + t52 * t353 / 0.4e1
  t357 = 0.1e1 / t356
  t359 = f.my_piecewise3(t88, t338, t352 * t357)
  t360 = t359 * t216
  t363 = 0.1e1 / t69 / t92
  t364 = s0 * t363
  t365 = t364 * t75
  t366 = 0.35580825067637374080570293925834452672591445782509e-2 * t365
  t368 = 0.1e1 / t46 / t115
  t370 = t197 * t368 * t98
  t371 = 0.82126447617547746980070516622939987620443695761045e-3 * t370
  t372 = t210 ** 2
  t373 = 0.1e1 / t372
  t378 = f.my_piecewise3(t209, 0, -0.91827364554637281910009182736455463728191000918275e-1 * t364 * t205 - 0.38261401897765534129170492806856443220079583715948e-2 * t370)
  t381 = f.my_piecewise3(t208, 0, t373 * t378 * t212)
  t383 = -t366 - t371 - t256
  t385 = t213 * t383 + t381 * t214 + t256 + t366 + t371
  t386 = t191 * t385
  t388 = t221 ** 2
  t389 = 0.1e1 / t388
  t391 = f.my_piecewise3(t220, 0, -t365 / 0.225e3)
  t394 = f.my_piecewise3(t219, 0, t389 * t391 * t223)
  t396 = -t217 * t394 - t360 * t225 + t386 * t225 - t256
  t400 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t401 = t400 * f.p.zeta_threshold
  t403 = f.my_piecewise3(t20, t401, t21 * t19)
  t405 = 0.1e1 / t234 / t6
  t406 = t403 * t405
  t410 = t403 * t235
  t414 = t403 * t42
  t416 = 0.1e1 / t241 / t64
  t417 = t252 ** 2
  t424 = t44 / t57 / t56 * s0
  t426 = 0.1e1 / t69 / t104
  t436 = f.my_piecewise3(t63, 0, -0.89824863971471623202660612470834989479262807341388e-1 * t424 * t426 * t50 * t74 + 0.52397837316691780201552023941320410529569970949143e-1 * t245 * t94 * t51 * t54)
  t439 = t241 ** 2
  t440 = 0.1e1 / t439
  t444 = f.my_piecewise3(t62, 0, t242 * t436 * t66 - 0.2e1 * t416 * t417 * t66 + t440 * t417 * t66)
  t445 = 0.1174e1 * t444
  t446 = 0.1e1 / t286
  t447 = t103 * t446
  t451 = t139 / t316
  t458 = f.my_piecewise3(t82, -s0 / t92 * t78 / 0.4e1, 0)
  t459 = t282 * t458
  t464 = t312 * t458
  t467 = t90 * t199
  t470 = tau0 * t363
  t471 = t470 * t85
  t473 = t257 * t265
  t475 = t75 * t458
  t476 = t72 * t475
  t478 = t264 ** 2
  t479 = t98 * t478
  t483 = t109 * t84 * t478
  t488 = t114 / t69 / t127
  t493 = t126 / t46 / t140
  t497 = t144 * t122 * t478
  t502 = t149 / t69 / t162
  t505 = -0.18191991589754003550907078987303095867015645113240e2 * t447 * t111 + 0.96117040414745039752574730202721828440964457255470e2 * t451 * t146 - 0.18191991589754003550907078987303095867015645113241e1 * t107 * t459 - 0.10485495317972186154826334203933290375377940791506e3 * t309 * t313 + 0.52427476589860930774131671019666451876889703957529e1 * t142 * t464 - 0.28764681628544549849532864162181917846621364744141e1 * t467 * t100 - 0.82955937530038971326579167547963294150552229194667e0 * t471 + 0.62216953147529228494934375660972470612914171896000e0 * t473 - 0.18665085944258768548480312698291741183874251568800e0 * t476 - 0.39828020716446299791660888839944193941475735799580e0 * t95 * t479 - 0.36383983179508007101814157974606191734031290226482e1 * t107 * t483 - 0.39036217109281150995200428962339661866949576093101e1 * t488 * t123 + 0.11350895519968478925605072686333567261930364989523e2 * t493 * t136 + 0.26213738294930465387065835509833225938444851978764e2 * t142 * t497 + 0.60092509645026684842151125394918005712854637678294e2 * t502 * t158
  t509 = t161 / t46 / t127 / t286
  t514 = t293 * t458
  t517 = t300 * t51
  t520 = t304 * t458
  t523 = t319 * t50
  t526 = t323 * t458
  t529 = t120 * t99
  t530 = t529 * t478
  t533 = t133 * t110
  t534 = t533 * t478
  t537 = t155 * t135
  t538 = t537 * t478
  t541 = t168 * t145
  t542 = t541 * t478
  t545 = t330 * t51
  t548 = t334 * t458
  t551 = t270 * t51
  t554 = t274 * t458
  t557 = t289 * t50
  t560 = -0.84345203969793167495062504022078532663579520511510e-1 * t509 * t171 + 0.18191991589754003550907078987303095867015645113241e2 * t279 * t283 - 0.30550082955089596431026422666178865808917059551122e0 * t292 * t514 - 0.12161673771394798848862577878214536352068248203060e2 * t517 * t305 + 0.72970042628368793093175467269287218112409489218360e0 * t303 * t520 - 0.66418036976082125351851243857540953682628810065483e2 * t523 * t324 + 0.28464872989749482293650533081803265863983775742350e1 * t322 * t526 - 0.91650248865268789293079267998536597426751178653366e0 * t292 * t530 + 0.29188017051347517237270186907714887244963795687344e1 * t303 * t534 + 0.17078923793849689376190319849081959518390265445410e2 * t322 * t538 - 0.24715106279520788614832268620423011896769812987093e-1 * t333 * t542 + 0.94152785826745861389837213792087664368646906617499e-1 * t545 * t335 - 0.35307294685029698021188955172032874138242589981562e-2 * t333 * t548 + 0.26552013810964199861107259226629462627650490533054e1 * t551 * t275 - 0.39828020716446299791660888839944193941475735799580e0 * t273 * t554 + 0.40733443940119461908035230221571821078556079401496e1 * t557 * t294
  t566 = f.my_piecewise3(t176, 0.200e3 / 0.81e2 * t471 - 0.50e2 / 0.27e2 * t473 + 0.5e1 / 0.9e1 * t476, 0)
  t569 = t342 ** 2
  t573 = 0.1e1 / t345 / t177
  t574 = t178 * t573
  t582 = -0.12063067191025636561756297344054915325509498465082e1 * t566 * t179 + 0.24126134382051273123512594688109830651018996930164e1 * t569 * t346 - 0.24126134382051273123512594688109830651018996930164e1 * t574 * t569 + 0.12063067191025636561756297344054915325509498465082e1 * t347 * t566 - 0.22206712118690530507219997476860916252554783972356e1 * t569 - 0.22206712118690530507219997476860916252554783972356e1 * t178 * t566
  t584 = t352 ** 2
  t585 = t356 ** 2
  t586 = 0.1e1 / t585
  t588 = t52 * t184
  t592 = f.my_piecewise3(t88, t505 + t560, t582 * t357 - t584 * t586 * t588 / 0.2e1)
  t593 = t592 * t216
  t595 = t359 * t385
  t600 = s0 * t426
  t601 = t600 * t75
  t602 = 0.13046302524800370496209107772805965979950196786920e-1 * t601
  t606 = t197 / t46 / t286 * t98
  t607 = 0.52013416824446906420711327194528658826281007315328e-2 * t606
  t609 = 0.1e1 / t372 / t210
  t610 = t378 ** 2
  t618 = f.my_piecewise3(t209, 0, 0.33670033670033670033670033670033670033670033670034e0 * t600 * t205 + 0.34435261707988980716253443526170798898071625344353e-1 * t606)
  t621 = t372 ** 2
  t622 = 0.1e1 / t621
  t626 = f.my_piecewise3(t208, 0, t373 * t618 * t212 - 0.2e1 * t609 * t610 * t212 + t622 * t610 * t212)
  t630 = t602 + t607 - t445
  t632 = t213 * t630 + t626 * t214 + 0.2e1 * t381 * t383 + t445 - t602 - t607
  t633 = t191 * t632
  t638 = 0.1e1 / t388 / t221
  t639 = t391 ** 2
  t644 = f.my_piecewise3(t220, 0, 0.11e2 / 0.675e3 * t601)
  t647 = t388 ** 2
  t648 = 0.1e1 / t647
  t652 = f.my_piecewise3(t219, 0, t389 * t644 * t223 - 0.2e1 * t638 * t639 * t223 + t648 * t639 * t223)
  t654 = -t217 * t652 - t593 * t225 - 0.2e1 * t595 * t225 + t633 * t225 + 0.2e1 * t360 * t394 - 0.2e1 * t386 * t394 - t445
  t659 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t227 - t5 * t236 * t227 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t240 * t396 + t5 * t406 * t227 / 0.12e2 - t5 * t410 * t396 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t414 * t654)
  t661 = r1 <= f.p.dens_threshold
  t662 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t663 = 0.1e1 + t662
  t664 = t663 <= f.p.zeta_threshold
  t665 = t663 ** (0.1e1 / 0.3e1)
  t666 = t665 ** 2
  t667 = 0.1e1 / t666
  t669 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t670 = t669 ** 2
  t674 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t678 = f.my_piecewise3(t664, 0, 0.4e1 / 0.9e1 * t667 * t670 + 0.4e1 / 0.3e1 * t665 * t674)
  t680 = jnp.sqrt(s2)
  t681 = r1 ** (0.1e1 / 0.3e1)
  t686 = jnp.sqrt(t680 / t681 / r1 * t55)
  t688 = 0.33684323989301858700997729676563121054723552753020e-1 * t44 * t686
  t691 = f.my_piecewise3(t688 < -t61, -t61, t688)
  t693 = jnp.exp(-0.1e1 / t691)
  t694 = f.my_piecewise3(t688 <= -t61, 0, t693)
  t695 = 0.1174e1 * t694
  t696 = t681 ** 2
  t704 = s2 / r1 / tau1 / 0.8e1
  t708 = f.my_piecewise3(0.0e0 < 0.9999999999e0 - t704, 0.1e1 - t704, 0.1e-9)
  t710 = tau1 / t696 / r1 * t75 * t708
  t711 = 0.5e1 / 0.9e1 * t710
  t714 = tau1 ** 2
  t715 = r1 ** 2
  t716 = t715 * r1
  t720 = t708 ** 2
  t724 = t714 * tau1
  t725 = t715 ** 2
  t726 = t725 * r1
  t729 = t720 * t708
  t733 = t714 ** 2
  t738 = t720 ** 2
  t743 = t725 ** 2
  t768 = t733 ** 2
  t773 = t738 ** 2
  t779 = f.my_piecewise3(DBL_EPSILON < t711, t711, DBL_EPSILON)
  t780 = t779 - 0.1e1
  t784 = t780 ** 2
  t789 = jnp.atan(jnp.pi * (-0.12063067191025636561756297344054915325509498465082e1 * t780 / t779 - 0.11103356059345265253609998738430458126277391986178e1 * t784) / 0.2e1)
  t792 = f.my_piecewise3(t711 <= DBL_EPSILON, 0.10000000000000000000000000000000000000000000000000e1 - 0.18665085944258768548480312698291741183874251568800e0 * t710 - 0.19914010358223149895830444419972096970737867899790e0 * t714 / t681 / t716 * t98 * t720 - 0.60639971965846678503023596624343652890052150377469e0 * t724 / t726 * t109 * t729 - 0.76375207387723991077566056665447164522292648877806e-1 * t733 / t696 / t725 / t715 * t121 * t738 + 0.14594008525673758618635093453857443622481897843672e0 * t733 * tau1 / t681 / t743 * t134 * t738 * t708 + 0.87379127649768217956886118366110753128149506595882e0 * t733 * t714 / t743 / t715 * t144 * t738 * t720 + 0.40664104271070688990929332974004665519976822489071e0 * t733 * t724 / t696 / t743 / t716 * t156 * t738 * t729 - 0.44134118356287122526486193965041092672803237476953e-3 * t768 / t681 / t743 / t726 * t169 * t773, 0.2e1 * t175 * t789)
  t796 = s2 / t696 / t715
  t797 = t796 * t75
  t798 = 0.13342809400364015280213860222187919752221792168441e-2 * t797
  t799 = s2 ** 2
  t804 = 0.15398708928290202558763221866801247678833192955196e-3 * t799 / t681 / t726 * t98
  t809 = 0.34435261707988980716253443526170798898071625344353e-1 * t796 * t75 * (0.1e1 + t797 / 0.24e2)
  t812 = f.my_piecewise3(t809 < -t61, -t61, t809)
  t814 = jnp.exp(-0.1e1 / t812)
  t815 = f.my_piecewise3(t809 <= -t61, 0, t814)
  t820 = t797 / 0.600e3
  t823 = f.my_piecewise3(t820 < -t61, -t61, t820)
  t825 = jnp.exp(-0.1e1 / t823)
  t826 = f.my_piecewise3(t820 <= -t61, 0, t825)
  t829 = 0.1174e1 - t695 + (0.1e1 - t792) * (-0.174e0 - t798 - t804 + t695 + t815 * (0.1e0 + t798 + t804 - t695)) * (0.1e1 - t826)
  t835 = f.my_piecewise3(t664, 0, 0.4e1 / 0.3e1 * t665 * t669)
  t841 = f.my_piecewise3(t664, t401, t665 * t663)
  t847 = f.my_piecewise3(t661, 0, -0.3e1 / 0.8e1 * t5 * t678 * t42 * t829 - t5 * t835 * t235 * t829 / 0.4e1 + t5 * t841 * t405 * t829 / 0.12e2)
  t857 = t24 ** 2
  t861 = 0.6e1 * t33 - 0.6e1 * t16 / t857
  t862 = f.my_piecewise5(t10, 0, t14, 0, t861)
  t866 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t862)
  t889 = 0.1e1 / t234 / t24
  t900 = t417 * t252
  t924 = 0.1e1 / t69 / t105
  t934 = f.my_piecewise3(t63, 0, -0.17964972794294324640532122494166997895852561468278e0 * t44 / t57 / t195 * t45 * s0 * t446 / t52 + 0.62877404780030136241862428729584492635483965138971e0 * t424 * t924 * t50 * t74 - 0.17465945772230593400517341313773470176523323649714e0 * t245 * t269 * t51 * t54)
  t946 = f.my_piecewise3(t62, 0, 0.6e1 * t440 * t900 * t66 - 0.6e1 * t416 * t252 * t66 * t436 - 0.6e1 / t439 / t64 * t900 * t66 + t242 * t934 * t66 + 0.3e1 * t440 * t436 * t252 * t66 + 0.1e1 / t439 / t241 * t900 * t66)
  t947 = 0.1174e1 * t946
  t954 = f.my_piecewise3(t82, 0.3e1 / 0.4e1 * s0 / t104 * t78, 0)
  t992 = t478 * t264
  t996 = -0.18242510657092198273293866817321804528102372304590e2 * t517 * t520 + 0.72970042628368793093175467269287218112409489218360e0 * t303 * t304 * t954 - 0.99627055464123188027776865786311430523943215098225e2 * t523 * t526 + 0.28464872989749482293650533081803265863983775742350e1 * t322 * t323 * t954 - 0.11948406214933889937498266651983258182442720739874e1 * t273 * t97 * t264 * t458 - 0.10915194953852402130544247392381857520209387067945e2 * t107 * t109 * t84 * t264 * t458 - 0.46843460531137381194240514754807594240339491311720e2 * t488 * t50 * t294 + 0.17026343279952718388407609029500350892895547484284e3 * t493 * t51 * t305 + 0.78641214884791396161197506529499677815334555936292e2 * t142 * t144 * t122 * t264 * t458 + 0.12619427025455603816851736332932781199699473912442e4 * t502 * t50 * t324 - 0.20242848952750360198815000965298847839259084922762e1 * t509 * t51 * t335 + 0.98860425118083154459329074481692047587079251948373e0 * t545 * t542 - 0.14829063767712473168899361172253807138061887792256e0 * t333 * t168 * t135 * t992
  t1033 = -0.72970042628368793093175467269287218112409489218360e2 * t517 * t534 - 0.59776233278473912816666119471786858314365929058935e3 * t523 * t538 + 0.18330049773053757858615853599707319485350235730673e2 * t557 * t530 - 0.18330049773053757858615853599707319485350235730673e1 * t292 * t120 * t84 * t992 + 0.87564051154042551711810560723144661734891387062032e1 * t303 * t133 * t99 * t992 + 0.85394618969248446880951599245409797591951327227050e2 * t322 * t155 * t122 * t992 + 0.14122917874011879208475582068813149655297035992625e0 * t545 * t548 - 0.35307294685029698021188955172032874138242589981562e-2 * t333 * t334 * t954 + 0.39828020716446299791660888839944193941475735799581e1 * t551 * t554 - 0.39828020716446299791660888839944193941475735799580e0 * t273 * t274 * t954 + 0.61100165910179192862052845332357731617834119102244e1 * t557 * t514 - 0.30550082955089596431026422666178865808917059551122e0 * t292 * t293 * t954 - 0.17258808977126729909719718497309150707972818846485e2 * t467 * t51 * t275
  t1047 = t72 * t75 * t954
  t1070 = -0.36383983179508007101814157974606191734031290226482e1 * t107 * t109 * t992 + 0.12734394112827802485634955291112167106910951579268e3 * t103 / t127 * t111 - 0.11534044849769404770308967624326619412915734870656e4 * t139 / t162 * t146 - 0.18665085944258768548480312698291741183874251568800e0 * t1047 + 0.27287987384631005326360618480954643800523467669862e2 * t279 * t459 - 0.18191991589754003550907078987303095867015645113241e1 * t107 * t282 * t954 - 0.15728242976958279232239501305899935563066911187259e3 * t309 * t464 + 0.52427476589860930774131671019666451876889703957529e1 * t142 * t312 * t954 - 0.16372792430778603195816371088572786280314080601917e3 * t447 * t283 + 0.17301067274654107155463451436489929119373602305985e4 * t451 * t313 + 0.15341163535223759919750860886497022851531394530209e2 * t90 * t368 * t100 + 0.39828020716446299791660888839944193941475735799581e1 * t270 * t479 + 0.54575974769262010652721236961909287601046935339723e2 * t279 * t483
  t1092 = t127 ** 2
  t1099 = tau0 * t426 * t85
  t1101 = t470 * t265
  t1103 = t257 * t475
  t1105 = t264 * t458
  t1118 = 0.33831388161376997529173705100694373618022965947354e2 * t114 / t69 / t297 * t123 - 0.11729258703967428223125241775878019503994710489174e3 * t126 / t46 / t150 * t136 - 0.78641214884791396161197506529499677815334555936294e3 * t309 * t497 + 0.10485495317972186154826334203933290375377940791506e3 * t142 * t144 * t110 * t992 - 0.82126429848203135950939871373054607807568004827002e3 * t149 / t69 / t327 * t158 + 0.12932931275368285682576250616718708341748859811765e1 * t161 / t46 / t1092 * t171 + 0.30417177094347622819745694767586541188535817371378e1 * t1099 - 0.24886781259011691397973750264388988245165668758400e1 * t1101 + 0.93325429721293842742401563491458705919371257844000e0 * t1103 - 0.27495074659580636787923780399560979228025353596010e1 * t292 * t529 * t1105 - 0.74145318838562365844496805861269035690309438961279e-1 * t333 * t541 * t1105 + 0.87564051154042551711810560723144661734891387062032e1 * t303 * t533 * t1105 + 0.51236771381549068128570959547245878555170796336230e2 * t322 * t537 * t1105
  t1126 = f.my_piecewise3(t176, -0.2200e4 / 0.243e3 * t1099 + 0.200e3 / 0.27e2 * t1101 - 0.25e2 / 0.9e1 * t1103 + 0.5e1 / 0.9e1 * t1047, 0)
  t1132 = t569 * t342
  t1135 = t345 ** 2
  t1140 = t342 * t566
  t1154 = t584 * t352
  t1165 = f.my_piecewise3(t88, t996 + t1033 + t1070 + t1118, (-0.12063067191025636561756297344054915325509498465082e1 * t1126 * t179 + 0.72378403146153819370537784064329491953056990790492e1 * t566 * t346 * t342 - 0.72378403146153819370537784064329491953056990790492e1 * t1132 * t573 + 0.72378403146153819370537784064329491953056990790492e1 * t178 / t1135 * t1132 - 0.72378403146153819370537784064329491953056990790492e1 * t574 * t1140 + 0.12063067191025636561756297344054915325509498465082e1 * t347 * t1126 - 0.66620136356071591521659992430582748757664351917068e1 * t1140 - 0.22206712118690530507219997476860916252554783972356e1 * t178 * t1126) * t357 - 0.3e1 / 0.2e1 * t582 * t586 * t588 * t352 + t1154 / t585 / t356 * t108 * t353 / 0.2e1 - t1154 * t586 * t52 / 0.2e1)
  t1180 = s0 * t924
  t1181 = t1180 * t75
  t1182 = 0.60882745115735062315642502939761174573100918338960e-1 * t1181
  t1184 = t197 * t129 * t98
  t1185 = 0.38143172337927731375188306609321016472606072031241e-1 * t1184
  t1186 = t610 * t378
  t1203 = f.my_piecewise3(t209, 0, -0.15712682379349046015712682379349046015712682379349e1 * t1180 * t205 - 0.28993640104751215862326973438084549195660306771419e0 * t1184)
  t1215 = f.my_piecewise3(t208, 0, 0.6e1 * t622 * t1186 * t212 - 0.6e1 * t609 * t378 * t212 * t618 - 0.6e1 / t621 / t210 * t1186 * t212 + t373 * t1203 * t212 + 0.3e1 * t622 * t618 * t378 * t212 + 0.1e1 / t621 / t372 * t1186 * t212)
  t1230 = t639 * t391
  t1244 = f.my_piecewise3(t220, 0, -0.154e3 / 0.2025e4 * t1181)
  t1256 = f.my_piecewise3(t219, 0, 0.6e1 * t648 * t1230 * t223 - 0.6e1 * t638 * t391 * t223 * t644 - 0.6e1 / t647 / t221 * t1230 * t223 + t389 * t1244 * t223 + 0.3e1 * t648 * t644 * t391 * t223 + 0.1e1 / t647 / t388 * t1230 * t223)
  t1258 = -t947 - t1165 * t216 * t225 - 0.3e1 * t592 * t385 * t225 + 0.3e1 * t593 * t394 - 0.3e1 * t359 * t632 * t225 + 0.6e1 * t595 * t394 + 0.3e1 * t360 * t652 + t191 * (t1182 + t1185 + t947 + t1215 * t214 + 0.3e1 * t626 * t383 + 0.3e1 * t381 * t630 + t213 * (-t1182 - t1185 - t947)) * t225 - 0.3e1 * t633 * t394 - 0.3e1 * t386 * t652 - t217 * t1256
  t1263 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t866 * t42 * t227 - 0.3e1 / 0.8e1 * t5 * t41 * t235 * t227 - 0.9e1 / 0.8e1 * t5 * t43 * t396 + t5 * t233 * t405 * t227 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t236 * t396 - 0.9e1 / 0.8e1 * t5 * t240 * t654 - 0.5e1 / 0.36e2 * t5 * t403 * t889 * t227 + t5 * t406 * t396 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t410 * t654 - 0.3e1 / 0.8e1 * t5 * t414 * t1258)
  t1273 = f.my_piecewise5(t14, 0, t10, 0, -t861)
  t1277 = f.my_piecewise3(t664, 0, -0.8e1 / 0.27e2 / t666 / t663 * t670 * t669 + 0.4e1 / 0.3e1 * t667 * t669 * t674 + 0.4e1 / 0.3e1 * t665 * t1273)
  t1295 = f.my_piecewise3(t661, 0, -0.3e1 / 0.8e1 * t5 * t1277 * t42 * t829 - 0.3e1 / 0.8e1 * t5 * t678 * t235 * t829 + t5 * t835 * t405 * t829 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t841 * t889 * t829)
  d111 = 0.3e1 * t659 + 0.3e1 * t847 + t6 * (t1263 + t1295)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 0.1e1 / t22 / t19
  t25 = t6 ** 2
  t26 = 0.1e1 / t25
  t28 = -t16 * t26 + t7
  t29 = f.my_piecewise5(t10, 0, t14, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t6
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t16 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t10, 0, t14, 0, t40)
  t44 = t25 ** 2
  t45 = 0.1e1 / t44
  t48 = -0.6e1 * t16 * t45 + 0.6e1 * t37
  t49 = f.my_piecewise5(t10, 0, t14, 0, t48)
  t53 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t24 * t30 * t29 + 0.4e1 / 0.3e1 * t35 * t41 + 0.4e1 / 0.3e1 * t21 * t49)
  t54 = t6 ** (0.1e1 / 0.3e1)
  t55 = t53 * t54
  t56 = jnp.sqrt(0.3e1)
  t57 = jnp.sqrt(s0)
  t58 = r0 ** (0.1e1 / 0.3e1)
  t62 = 6 ** (0.1e1 / 0.3e1)
  t63 = t62 ** 2
  t64 = jnp.pi ** 2
  t65 = t64 ** (0.1e1 / 0.3e1)
  t66 = 0.1e1 / t65
  t67 = t63 * t66
  t68 = t57 / t58 / r0 * t67
  t69 = jnp.sqrt(t68)
  t71 = 0.33684323989301858700997729676563121054723552753020e-1 * t56 * t69
  t72 = jnp.log(DBL_EPSILON)
  t73 = 0.1e1 / t72
  t74 = t71 <= -t73
  t75 = t71 < -t73
  t76 = f.my_piecewise3(t75, -t73, t71)
  t78 = jnp.exp(-0.1e1 / t76)
  t79 = f.my_piecewise3(t74, 0, t78)
  t80 = 0.1174e1 * t79
  t81 = t58 ** 2
  t84 = tau0 / t81 / r0
  t85 = t65 ** 2
  t86 = 0.1e1 / t85
  t87 = t62 * t86
  t90 = 0.1e1 / tau0
  t92 = s0 / r0 * t90 / 0.8e1
  t94 = 0.0e0 < 0.9999999999e0 - t92
  t96 = f.my_piecewise3(t94, 0.1e1 - t92, 0.1e-9)
  t97 = t87 * t96
  t98 = t84 * t97
  t99 = 0.5e1 / 0.9e1 * t98
  t100 = t99 <= DBL_EPSILON
  t102 = tau0 ** 2
  t103 = r0 ** 2
  t104 = t103 * r0
  t106 = 0.1e1 / t58 / t104
  t107 = t102 * t106
  t109 = 0.1e1 / t65 / t64
  t110 = t63 * t109
  t111 = t96 ** 2
  t112 = t110 * t111
  t115 = t102 * tau0
  t116 = t103 ** 2
  t117 = t116 * r0
  t118 = 0.1e1 / t117
  t119 = t115 * t118
  t120 = t64 ** 2
  t121 = 0.1e1 / t120
  t122 = t111 * t96
  t123 = t121 * t122
  t126 = t102 ** 2
  t127 = t116 * t103
  t129 = 0.1e1 / t81 / t127
  t130 = t126 * t129
  t132 = 0.1e1 / t85 / t120
  t133 = t62 * t132
  t134 = t111 ** 2
  t135 = t133 * t134
  t138 = t126 * tau0
  t139 = t116 ** 2
  t141 = 0.1e1 / t58 / t139
  t142 = t138 * t141
  t143 = t120 * t64
  t145 = 0.1e1 / t65 / t143
  t146 = t63 * t145
  t147 = t134 * t96
  t148 = t146 * t147
  t151 = t126 * t102
  t152 = t139 * t103
  t154 = t151 / t152
  t155 = t120 ** 2
  t156 = 0.1e1 / t155
  t157 = t134 * t111
  t158 = t156 * t157
  t161 = t126 * t115
  t162 = t139 * t104
  t165 = t161 / t81 / t162
  t167 = 0.1e1 / t85 / t155
  t168 = t62 * t167
  t169 = t134 * t122
  t170 = t168 * t169
  t173 = t126 ** 2
  t174 = t139 * t117
  t177 = t173 / t58 / t174
  t180 = 0.1e1 / t65 / t155 / t64
  t181 = t63 * t180
  t182 = t134 ** 2
  t183 = t181 * t182
  t187 = 0.1e1 / jnp.pi
  t188 = DBL_EPSILON < t99
  t189 = f.my_piecewise3(t188, t99, DBL_EPSILON)
  t190 = t189 - 0.1e1
  t191 = 0.1e1 / t189
  t194 = t190 ** 2
  t196 = -0.12063067191025636561756297344054915325509498465082e1 * t190 * t191 - 0.11103356059345265253609998738430458126277391986178e1 * t194
  t199 = jnp.atan(jnp.pi * t196 / 0.2e1)
  t202 = f.my_piecewise3(t100, 0.10000000000000000000000000000000000000000000000000e1 - 0.18665085944258768548480312698291741183874251568800e0 * t98 - 0.19914010358223149895830444419972096970737867899790e0 * t107 * t112 - 0.60639971965846678503023596624343652890052150377469e0 * t119 * t123 - 0.76375207387723991077566056665447164522292648877806e-1 * t130 * t135 + 0.14594008525673758618635093453857443622481897843672e0 * t142 * t148 + 0.87379127649768217956886118366110753128149506595882e0 * t154 * t158 + 0.40664104271070688990929332974004665519976822489071e0 * t165 * t170 - 0.44134118356287122526486193965041092672803237476953e-3 * t177 * t183, 0.2e1 * t187 * t199)
  t203 = 0.1e1 - t202
  t205 = 0.1e1 / t81 / t103
  t206 = s0 * t205
  t207 = t206 * t87
  t208 = 0.13342809400364015280213860222187919752221792168441e-2 * t207
  t209 = s0 ** 2
  t211 = 0.1e1 / t58 / t117
  t214 = 0.15398708928290202558763221866801247678833192955196e-3 * t209 * t211 * t110
  t217 = t87 * (0.1e1 + t207 / 0.24e2)
  t219 = 0.34435261707988980716253443526170798898071625344353e-1 * t206 * t217
  t220 = t219 <= -t73
  t221 = t219 < -t73
  t222 = f.my_piecewise3(t221, -t73, t219)
  t224 = jnp.exp(-0.1e1 / t222)
  t225 = f.my_piecewise3(t220, 0, t224)
  t226 = 0.1e0 + t208 + t214 - t80
  t228 = -0.174e0 - t208 - t214 + t80 + t225 * t226
  t229 = t203 * t228
  t230 = t207 / 0.600e3
  t231 = t230 <= -t73
  t232 = t230 < -t73
  t233 = f.my_piecewise3(t232, -t73, t230)
  t235 = jnp.exp(-0.1e1 / t233)
  t236 = f.my_piecewise3(t231, 0, t235)
  t237 = 0.1e1 - t236
  t239 = 0.1174e1 - t80 + t229 * t237
  t248 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t34 * t30 + 0.4e1 / 0.3e1 * t21 * t41)
  t249 = t54 ** 2
  t250 = 0.1e1 / t249
  t251 = t248 * t250
  t255 = t248 * t54
  t256 = t76 ** 2
  t257 = 0.1e1 / t256
  t260 = t56 / t69 * t57
  t267 = f.my_piecewise3(t75, 0, -0.22456215992867905800665153117708747369815701835347e-1 * t260 / t58 / t103 * t63 * t66)
  t270 = f.my_piecewise3(t74, 0, t257 * t267 * t78)
  t271 = 0.1174e1 * t270
  t272 = tau0 * t205
  t273 = t272 * t97
  t279 = f.my_piecewise3(t94, s0 / t103 * t90 / 0.8e1, 0)
  t280 = t87 * t279
  t281 = t84 * t280
  t284 = 0.1e1 / t58 / t116
  t285 = t102 * t284
  t288 = t107 * t63
  t289 = t109 * t96
  t290 = t289 * t279
  t294 = t115 / t127
  t297 = t121 * t111
  t298 = t297 * t279
  t301 = t116 * t104
  t304 = t126 / t81 / t301
  t307 = t130 * t62
  t308 = t132 * t122
  t309 = t308 * t279
  t312 = t139 * r0
  t314 = 0.1e1 / t58 / t312
  t315 = t138 * t314
  t318 = t142 * t63
  t319 = t145 * t134
  t320 = t319 * t279
  t324 = t151 / t162
  t327 = t156 * t147
  t328 = t327 * t279
  t331 = t139 * t116
  t334 = t161 / t81 / t331
  t337 = t165 * t62
  t338 = t167 * t157
  t339 = t338 * t279
  t342 = t139 * t127
  t345 = t173 / t58 / t342
  t348 = t177 * t63
  t349 = t180 * t169
  t350 = t349 * t279
  t353 = 0.31108476573764614247467187830486235306457085948000e0 * t273 - 0.18665085944258768548480312698291741183874251568800e0 * t281 + 0.66380034527410499652768148066573656569126226332633e0 * t285 * t112 - 0.39828020716446299791660888839944193941475735799580e0 * t288 * t290 + 0.30319985982923339251511798312171826445026075188734e1 * t294 * t123 - 0.18191991589754003550907078987303095867015645113241e1 * t119 * t298 + 0.50916804925149327385044037776964776348195099251871e0 * t304 * t135 - 0.30550082955089596431026422666178865808917059551122e0 * t307 * t309 - 0.12161673771394798848862577878214536352068248203060e1 * t315 * t148 + 0.72970042628368793093175467269287218112409489218360e0 * t318 * t320 - 0.87379127649768217956886118366110753128149506595882e1 * t324 * t158 + 0.52427476589860930774131671019666451876889703957529e1 * t154 * t328 - 0.47441454982915803822750888469672109773306292903916e1 * t334 * t170 + 0.28464872989749482293650533081803265863983775742350e1 * t337 * t339 + 0.58845491141716163368648258620054790230404316635937e-2 * t345 * t183 - 0.35307294685029698021188955172032874138242589981562e-2 * t348 * t350
  t357 = f.my_piecewise3(t188, -0.25e2 / 0.27e2 * t273 + 0.5e1 / 0.9e1 * t281, 0)
  t360 = t189 ** 2
  t361 = 0.1e1 / t360
  t362 = t190 * t361
  t367 = -0.12063067191025636561756297344054915325509498465082e1 * t357 * t191 + 0.12063067191025636561756297344054915325509498465082e1 * t362 * t357 - 0.22206712118690530507219997476860916252554783972356e1 * t190 * t357
  t368 = t196 ** 2
  t371 = 0.1e1 + t64 * t368 / 0.4e1
  t372 = 0.1e1 / t371
  t374 = f.my_piecewise3(t100, t353, t367 * t372)
  t375 = t374 * t228
  t378 = 0.1e1 / t81 / t104
  t379 = s0 * t378
  t380 = t379 * t87
  t381 = 0.35580825067637374080570293925834452672591445782509e-2 * t380
  t383 = 0.1e1 / t58 / t127
  t385 = t209 * t383 * t110
  t386 = 0.82126447617547746980070516622939987620443695761045e-3 * t385
  t387 = t222 ** 2
  t388 = 0.1e1 / t387
  t393 = f.my_piecewise3(t221, 0, -0.91827364554637281910009182736455463728191000918275e-1 * t379 * t217 - 0.38261401897765534129170492806856443220079583715948e-2 * t385)
  t396 = f.my_piecewise3(t220, 0, t388 * t393 * t224)
  t398 = -t381 - t386 - t271
  t400 = t225 * t398 + t396 * t226 + t271 + t381 + t386
  t401 = t203 * t400
  t403 = t233 ** 2
  t404 = 0.1e1 / t403
  t406 = f.my_piecewise3(t232, 0, -t380 / 0.225e3)
  t409 = f.my_piecewise3(t231, 0, t404 * t406 * t235)
  t411 = -t229 * t409 - t375 * t237 + t401 * t237 - t271
  t417 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t29)
  t419 = 0.1e1 / t249 / t6
  t420 = t417 * t419
  t424 = t417 * t250
  t428 = t417 * t54
  t429 = t256 * t76
  t430 = 0.1e1 / t429
  t431 = t267 ** 2
  t438 = t56 / t69 / t68 * s0
  t440 = 0.1e1 / t81 / t116
  t450 = f.my_piecewise3(t75, 0, -0.89824863971471623202660612470834989479262807341388e-1 * t438 * t440 * t62 * t86 + 0.52397837316691780201552023941320410529569970949143e-1 * t260 * t106 * t63 * t66)
  t453 = t256 ** 2
  t454 = 0.1e1 / t453
  t455 = t454 * t431
  t458 = f.my_piecewise3(t74, 0, t257 * t450 * t78 - 0.2e1 * t430 * t431 * t78 + t455 * t78)
  t459 = 0.1174e1 * t458
  t462 = t161 / t81 / t174
  t465 = t139 * t301
  t468 = t173 / t58 / t465
  t477 = f.my_piecewise3(t94, -s0 / t104 * t90 / 0.4e1, 0)
  t478 = t297 * t477
  t483 = t327 * t477
  t486 = t102 * t211
  t489 = tau0 * t378
  t490 = t489 * t97
  t492 = t272 * t280
  t494 = t87 * t477
  t495 = t84 * t494
  t497 = t279 ** 2
  t498 = t110 * t497
  t501 = t121 * t96
  t502 = t501 * t497
  t507 = t126 / t81 / t139
  t512 = t138 / t58 / t152
  t515 = t156 * t134
  t516 = t515 * t497
  t519 = 0.60092509645026684842151125394918005712854637678294e2 * t462 * t170 - 0.84345203969793167495062504022078532663579520511510e-1 * t468 * t183 + 0.18191991589754003550907078987303095867015645113241e2 * t294 * t298 - 0.18191991589754003550907078987303095867015645113241e1 * t119 * t478 - 0.10485495317972186154826334203933290375377940791506e3 * t324 * t328 + 0.52427476589860930774131671019666451876889703957529e1 * t154 * t483 - 0.28764681628544549849532864162181917846621364744141e1 * t486 * t112 - 0.82955937530038971326579167547963294150552229194667e0 * t490 + 0.62216953147529228494934375660972470612914171896000e0 * t492 - 0.18665085944258768548480312698291741183874251568800e0 * t495 - 0.39828020716446299791660888839944193941475735799580e0 * t107 * t498 - 0.36383983179508007101814157974606191734031290226482e1 * t119 * t502 - 0.39036217109281150995200428962339661866949576093101e1 * t507 * t135 + 0.11350895519968478925605072686333567261930364989523e2 * t512 * t148 + 0.26213738294930465387065835509833225938444851978764e2 * t154 * t516
  t520 = t308 * t477
  t523 = t315 * t63
  t526 = t319 * t477
  t529 = t334 * t62
  t532 = t338 * t477
  t535 = t132 * t111
  t536 = t535 * t497
  t539 = t145 * t122
  t540 = t539 * t497
  t543 = t167 * t147
  t544 = t543 * t497
  t547 = t180 * t157
  t548 = t547 * t497
  t551 = t345 * t63
  t554 = t349 * t477
  t557 = t285 * t63
  t560 = t289 * t477
  t563 = t304 * t62
  t566 = 0.1e1 / t301
  t567 = t115 * t566
  t571 = t151 / t331
  t574 = -0.30550082955089596431026422666178865808917059551122e0 * t307 * t520 - 0.12161673771394798848862577878214536352068248203060e2 * t523 * t320 + 0.72970042628368793093175467269287218112409489218360e0 * t318 * t526 - 0.66418036976082125351851243857540953682628810065483e2 * t529 * t339 + 0.28464872989749482293650533081803265863983775742350e1 * t337 * t532 - 0.91650248865268789293079267998536597426751178653366e0 * t307 * t536 + 0.29188017051347517237270186907714887244963795687344e1 * t318 * t540 + 0.17078923793849689376190319849081959518390265445410e2 * t337 * t544 - 0.24715106279520788614832268620423011896769812987093e-1 * t348 * t548 + 0.94152785826745861389837213792087664368646906617499e-1 * t551 * t350 - 0.35307294685029698021188955172032874138242589981562e-2 * t348 * t554 + 0.26552013810964199861107259226629462627650490533054e1 * t557 * t290 - 0.39828020716446299791660888839944193941475735799580e0 * t288 * t560 + 0.40733443940119461908035230221571821078556079401496e1 * t563 * t309 - 0.18191991589754003550907078987303095867015645113240e2 * t567 * t123 + 0.96117040414745039752574730202721828440964457255470e2 * t571 * t158
  t580 = f.my_piecewise3(t188, 0.200e3 / 0.81e2 * t490 - 0.50e2 / 0.27e2 * t492 + 0.5e1 / 0.9e1 * t495, 0)
  t583 = t357 ** 2
  t587 = 0.1e1 / t360 / t189
  t588 = t190 * t587
  t596 = -0.12063067191025636561756297344054915325509498465082e1 * t580 * t191 + 0.24126134382051273123512594688109830651018996930164e1 * t583 * t361 - 0.24126134382051273123512594688109830651018996930164e1 * t588 * t583 + 0.12063067191025636561756297344054915325509498465082e1 * t362 * t580 - 0.22206712118690530507219997476860916252554783972356e1 * t583 - 0.22206712118690530507219997476860916252554783972356e1 * t190 * t580
  t598 = t367 ** 2
  t599 = t371 ** 2
  t600 = 0.1e1 / t599
  t602 = t64 * t196
  t606 = f.my_piecewise3(t100, t519 + t574, t596 * t372 - t598 * t600 * t602 / 0.2e1)
  t607 = t606 * t228
  t609 = t374 * t400
  t614 = s0 * t440
  t615 = t614 * t87
  t616 = 0.13046302524800370496209107772805965979950196786920e-1 * t615
  t618 = 0.1e1 / t58 / t301
  t620 = t209 * t618 * t110
  t621 = 0.52013416824446906420711327194528658826281007315328e-2 * t620
  t622 = t387 * t222
  t623 = 0.1e1 / t622
  t624 = t393 ** 2
  t632 = f.my_piecewise3(t221, 0, 0.33670033670033670033670033670033670033670033670034e0 * t614 * t217 + 0.34435261707988980716253443526170798898071625344353e-1 * t620)
  t635 = t387 ** 2
  t636 = 0.1e1 / t635
  t637 = t636 * t624
  t640 = f.my_piecewise3(t220, 0, t388 * t632 * t224 - 0.2e1 * t623 * t624 * t224 + t637 * t224)
  t644 = t616 + t621 - t459
  t646 = t225 * t644 + t640 * t226 + 0.2e1 * t396 * t398 + t459 - t616 - t621
  t647 = t203 * t646
  t651 = t403 * t233
  t652 = 0.1e1 / t651
  t653 = t406 ** 2
  t658 = f.my_piecewise3(t232, 0, 0.11e2 / 0.675e3 * t615)
  t661 = t403 ** 2
  t662 = 0.1e1 / t661
  t663 = t662 * t653
  t666 = f.my_piecewise3(t231, 0, t404 * t658 * t235 - 0.2e1 * t652 * t653 * t235 + t663 * t235)
  t668 = -t229 * t666 - t607 * t237 - 0.2e1 * t609 * t237 + t647 * t237 + 0.2e1 * t375 * t409 - 0.2e1 * t401 * t409 - t459
  t672 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t673 = t672 * f.p.zeta_threshold
  t675 = f.my_piecewise3(t20, t673, t21 * t19)
  t677 = 0.1e1 / t249 / t25
  t678 = t675 * t677
  t682 = t675 * t419
  t686 = t675 * t250
  t690 = t675 * t54
  t691 = t431 * t267
  t695 = t430 * t267
  t696 = t78 * t450
  t700 = 0.1e1 / t453 / t76
  t707 = t56 / t69 / t207 / 0.6e1
  t708 = t57 * s0
  t710 = 0.1e1 / t64
  t715 = 0.1e1 / t81 / t117
  t725 = f.my_piecewise3(t75, 0, -0.10778983676576594784319273496500198737511536880967e1 * t707 * t708 * t566 * t710 + 0.62877404780030136241862428729584492635483965138971e0 * t438 * t715 * t62 * t86 - 0.17465945772230593400517341313773470176523323649714e0 * t260 * t284 * t63 * t66)
  t729 = t267 * t78
  t733 = 0.1e1 / t453 / t256
  t737 = f.my_piecewise3(t74, 0, t257 * t725 * t78 + 0.3e1 * t454 * t450 * t729 + 0.6e1 * t454 * t691 * t78 - 0.6e1 * t700 * t691 * t78 + t733 * t691 * t78 - 0.6e1 * t695 * t696)
  t738 = 0.1174e1 * t737
  t741 = tau0 * t440
  t742 = t741 * t97
  t744 = t489 * t280
  t746 = t272 * t494
  t748 = 0.1e1 / t116
  t752 = f.my_piecewise3(t94, 0.3e1 / 0.4e1 * s0 * t748 * t90, 0)
  t753 = t87 * t752
  t754 = t84 * t753
  t757 = t497 * t279
  t758 = t156 * t122 * t757
  t763 = t161 / t81 / t342
  t766 = t139 ** 2
  t769 = t173 / t58 / t766
  t774 = t297 * t752
  t779 = t327 * t752
  t784 = -0.78641214884791396161197506529499677815334555936294e3 * t324 * t516 + 0.30417177094347622819745694767586541188535817371378e1 * t742 - 0.24886781259011691397973750264388988245165668758400e1 * t744 + 0.93325429721293842742401563491458705919371257844000e0 * t746 - 0.18665085944258768548480312698291741183874251568800e0 * t754 + 0.10485495317972186154826334203933290375377940791506e3 * t154 * t758 - 0.82126429848203135950939871373054607807568004827002e3 * t763 * t170 + 0.12932931275368285682576250616718708341748859811765e1 * t769 * t183 + 0.27287987384631005326360618480954643800523467669862e2 * t294 * t478 - 0.18191991589754003550907078987303095867015645113241e1 * t119 * t774 - 0.15728242976958279232239501305899935563066911187259e3 * t324 * t483 + 0.52427476589860930774131671019666451876889703957529e1 * t154 * t779 - 0.16372792430778603195816371088572786280314080601917e3 * t567 * t298
  t787 = t102 * t383
  t796 = t126 / t81 / t312
  t801 = t138 / t58 / t162
  t804 = t121 * t757
  t807 = 0.1e1 / t139
  t808 = t115 * t807
  t812 = t151 / t174
  t815 = t477 * t279
  t816 = t535 * t815
  t819 = t539 * t815
  t822 = t543 * t815
  t825 = t547 * t815
  t828 = 0.17301067274654107155463451436489929119373602305985e4 * t571 * t328 + 0.15341163535223759919750860886497022851531394530209e2 * t787 * t112 + 0.39828020716446299791660888839944193941475735799581e1 * t285 * t498 + 0.54575974769262010652721236961909287601046935339723e2 * t294 * t502 + 0.33831388161376997529173705100694373618022965947354e2 * t796 * t135 - 0.11729258703967428223125241775878019503994710489174e3 * t801 * t148 - 0.36383983179508007101814157974606191734031290226482e1 * t119 * t804 + 0.12734394112827802485634955291112167106910951579268e3 * t808 * t123 - 0.11534044849769404770308967624326619412915734870656e4 * t812 * t158 - 0.27495074659580636787923780399560979228025353596010e1 * t307 * t816 + 0.87564051154042551711810560723144661734891387062032e1 * t318 * t819 + 0.51236771381549068128570959547245878555170796336230e2 * t337 * t822 - 0.74145318838562365844496805861269035690309438961279e-1 * t348 * t825
  t830 = t512 * t63
  t833 = t154 * t156
  t835 = t134 * t279 * t477
  t838 = t462 * t62
  t841 = t468 * t63
  t844 = t167 * t134
  t845 = t844 * t757
  t850 = t180 * t147
  t851 = t850 * t757
  t860 = t132 * t96
  t861 = t860 * t757
  t864 = t145 * t111
  t865 = t864 * t757
  t870 = 0.17026343279952718388407609029500350892895547484284e3 * t830 * t320 + 0.78641214884791396161197506529499677815334555936292e2 * t833 * t835 + 0.12619427025455603816851736332932781199699473912442e4 * t838 * t339 - 0.20242848952750360198815000965298847839259084922762e1 * t841 * t350 + 0.85394618969248446880951599245409797591951327227050e2 * t337 * t845 + 0.98860425118083154459329074481692047587079251948373e0 * t551 * t548 - 0.14829063767712473168899361172253807138061887792256e0 * t348 * t851 - 0.72970042628368793093175467269287218112409489218360e2 * t523 * t540 - 0.59776233278473912816666119471786858314365929058935e3 * t529 * t544 + 0.18330049773053757858615853599707319485350235730673e2 * t563 * t536 - 0.18330049773053757858615853599707319485350235730673e1 * t307 * t861 + 0.87564051154042551711810560723144661734891387062032e1 * t318 * t865 + 0.61100165910179192862052845332357731617834119102244e1 * t563 * t520
  t871 = t338 * t752
  t876 = t349 * t752
  t881 = t289 * t752
  t884 = t486 * t63
  t887 = t308 * t752
  t892 = t319 * t752
  t897 = t109 * t279
  t898 = t897 * t477
  t901 = t119 * t121
  t903 = t96 * t279 * t477
  t906 = t507 * t62
  t909 = 0.28464872989749482293650533081803265863983775742350e1 * t337 * t871 + 0.14122917874011879208475582068813149655297035992625e0 * t551 * t554 - 0.35307294685029698021188955172032874138242589981562e-2 * t348 * t876 + 0.39828020716446299791660888839944193941475735799581e1 * t557 * t560 - 0.39828020716446299791660888839944193941475735799580e0 * t288 * t881 - 0.17258808977126729909719718497309150707972818846485e2 * t884 * t290 - 0.30550082955089596431026422666178865808917059551122e0 * t307 * t887 - 0.18242510657092198273293866817321804528102372304590e2 * t523 * t526 + 0.72970042628368793093175467269287218112409489218360e0 * t318 * t892 - 0.99627055464123188027776865786311430523943215098225e2 * t529 * t532 - 0.11948406214933889937498266651983258182442720739874e1 * t288 * t898 - 0.10915194953852402130544247392381857520209387067945e2 * t901 * t903 - 0.46843460531137381194240514754807594240339491311720e2 * t906 * t309
  t917 = f.my_piecewise3(t188, -0.2200e4 / 0.243e3 * t742 + 0.200e3 / 0.27e2 * t744 - 0.25e2 / 0.9e1 * t746 + 0.5e1 / 0.9e1 * t754, 0)
  t923 = t583 * t357
  t926 = t360 ** 2
  t927 = 0.1e1 / t926
  t928 = t190 * t927
  t931 = t357 * t580
  t939 = -0.12063067191025636561756297344054915325509498465082e1 * t917 * t191 + 0.72378403146153819370537784064329491953056990790492e1 * t580 * t361 * t357 - 0.72378403146153819370537784064329491953056990790492e1 * t923 * t587 + 0.72378403146153819370537784064329491953056990790492e1 * t928 * t923 - 0.72378403146153819370537784064329491953056990790492e1 * t588 * t931 + 0.12063067191025636561756297344054915325509498465082e1 * t362 * t917 - 0.66620136356071591521659992430582748757664351917068e1 * t931 - 0.22206712118690530507219997476860916252554783972356e1 * t190 * t917
  t941 = t596 * t600
  t942 = t602 * t367
  t945 = t598 * t367
  t947 = 0.1e1 / t599 / t371
  t949 = t120 * t368
  t956 = f.my_piecewise3(t100, t784 + t828 + t870 + t909, t939 * t372 - 0.3e1 / 0.2e1 * t941 * t942 + t945 * t947 * t949 / 0.2e1 - t945 * t600 * t64 / 0.2e1)
  t957 = t956 * t228
  t959 = t606 * t400
  t964 = t374 * t646
  t971 = s0 * t715
  t972 = t971 * t87
  t973 = 0.60882745115735062315642502939761174573100918338960e-1 * t972
  t975 = t209 * t141 * t110
  t976 = 0.38143172337927731375188306609321016472606072031241e-1 * t975
  t977 = t624 * t393
  t981 = t623 * t393
  t982 = t224 * t632
  t986 = 0.1e1 / t635 / t222
  t994 = f.my_piecewise3(t221, 0, -0.15712682379349046015712682379349046015712682379349e1 * t971 * t217 - 0.28993640104751215862326973438084549195660306771419e0 * t975)
  t998 = t393 * t224
  t1002 = 0.1e1 / t635 / t387
  t1006 = f.my_piecewise3(t220, 0, t1002 * t977 * t224 + t388 * t994 * t224 + 0.6e1 * t636 * t977 * t224 - 0.6e1 * t986 * t977 * t224 + 0.3e1 * t636 * t632 * t998 - 0.6e1 * t981 * t982)
  t1012 = -t973 - t976 - t738
  t1014 = t1006 * t226 + t225 * t1012 + 0.3e1 * t396 * t644 + 0.3e1 * t640 * t398 + t738 + t973 + t976
  t1015 = t203 * t1014
  t1021 = t653 * t406
  t1025 = t652 * t406
  t1026 = t235 * t658
  t1030 = 0.1e1 / t661 / t233
  t1035 = f.my_piecewise3(t232, 0, -0.154e3 / 0.2025e4 * t972)
  t1039 = t406 * t235
  t1043 = 0.1e1 / t661 / t403
  t1047 = f.my_piecewise3(t231, 0, -0.6e1 * t1030 * t1021 * t235 + t1043 * t1021 * t235 + 0.6e1 * t662 * t1021 * t235 + t404 * t1035 * t235 + 0.3e1 * t662 * t658 * t1039 - 0.6e1 * t1025 * t1026)
  t1049 = t1015 * t237 - t229 * t1047 - t957 * t237 - 0.3e1 * t959 * t237 - 0.3e1 * t964 * t237 + 0.3e1 * t375 * t666 - 0.3e1 * t401 * t666 + 0.3e1 * t607 * t409 + 0.6e1 * t609 * t409 - 0.3e1 * t647 * t409 - t738
  t1054 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t55 * t239 - 0.3e1 / 0.8e1 * t5 * t251 * t239 - 0.9e1 / 0.8e1 * t5 * t255 * t411 + t5 * t420 * t239 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t424 * t411 - 0.9e1 / 0.8e1 * t5 * t428 * t668 - 0.5e1 / 0.36e2 * t5 * t678 * t239 + t5 * t682 * t411 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t686 * t668 - 0.3e1 / 0.8e1 * t5 * t690 * t1049)
  t1056 = r1 <= f.p.dens_threshold
  t1057 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t1058 = 0.1e1 + t1057
  t1059 = t1058 <= f.p.zeta_threshold
  t1060 = t1058 ** (0.1e1 / 0.3e1)
  t1061 = t1060 ** 2
  t1063 = 0.1e1 / t1061 / t1058
  t1065 = f.my_piecewise5(t14, 0, t10, 0, -t28)
  t1066 = t1065 ** 2
  t1070 = 0.1e1 / t1061
  t1071 = t1070 * t1065
  t1073 = f.my_piecewise5(t14, 0, t10, 0, -t40)
  t1077 = f.my_piecewise5(t14, 0, t10, 0, -t48)
  t1081 = f.my_piecewise3(t1059, 0, -0.8e1 / 0.27e2 * t1063 * t1066 * t1065 + 0.4e1 / 0.3e1 * t1071 * t1073 + 0.4e1 / 0.3e1 * t1060 * t1077)
  t1083 = jnp.sqrt(s2)
  t1084 = r1 ** (0.1e1 / 0.3e1)
  t1089 = jnp.sqrt(t1083 / t1084 / r1 * t67)
  t1091 = 0.33684323989301858700997729676563121054723552753020e-1 * t56 * t1089
  t1094 = f.my_piecewise3(t1091 < -t73, -t73, t1091)
  t1096 = jnp.exp(-0.1e1 / t1094)
  t1097 = f.my_piecewise3(t1091 <= -t73, 0, t1096)
  t1098 = 0.1174e1 * t1097
  t1099 = t1084 ** 2
  t1107 = s2 / r1 / tau1 / 0.8e1
  t1111 = f.my_piecewise3(0.0e0 < 0.9999999999e0 - t1107, 0.1e1 - t1107, 0.1e-9)
  t1113 = tau1 / t1099 / r1 * t87 * t1111
  t1114 = 0.5e1 / 0.9e1 * t1113
  t1117 = tau1 ** 2
  t1118 = r1 ** 2
  t1119 = t1118 * r1
  t1123 = t1111 ** 2
  t1127 = t1117 * tau1
  t1128 = t1118 ** 2
  t1129 = t1128 * r1
  t1132 = t1123 * t1111
  t1136 = t1117 ** 2
  t1141 = t1123 ** 2
  t1146 = t1128 ** 2
  t1171 = t1136 ** 2
  t1176 = t1141 ** 2
  t1182 = f.my_piecewise3(DBL_EPSILON < t1114, t1114, DBL_EPSILON)
  t1183 = t1182 - 0.1e1
  t1187 = t1183 ** 2
  t1192 = jnp.atan(jnp.pi * (-0.12063067191025636561756297344054915325509498465082e1 * t1183 / t1182 - 0.11103356059345265253609998738430458126277391986178e1 * t1187) / 0.2e1)
  t1195 = f.my_piecewise3(t1114 <= DBL_EPSILON, 0.10000000000000000000000000000000000000000000000000e1 - 0.18665085944258768548480312698291741183874251568800e0 * t1113 - 0.19914010358223149895830444419972096970737867899790e0 * t1117 / t1084 / t1119 * t110 * t1123 - 0.60639971965846678503023596624343652890052150377469e0 * t1127 / t1129 * t121 * t1132 - 0.76375207387723991077566056665447164522292648877806e-1 * t1136 / t1099 / t1128 / t1118 * t133 * t1141 + 0.14594008525673758618635093453857443622481897843672e0 * t1136 * tau1 / t1084 / t1146 * t146 * t1141 * t1111 + 0.87379127649768217956886118366110753128149506595882e0 * t1136 * t1117 / t1146 / t1118 * t156 * t1141 * t1123 + 0.40664104271070688990929332974004665519976822489071e0 * t1136 * t1127 / t1099 / t1146 / t1119 * t168 * t1141 * t1132 - 0.44134118356287122526486193965041092672803237476953e-3 * t1171 / t1084 / t1146 / t1129 * t181 * t1176, 0.2e1 * t187 * t1192)
  t1199 = s2 / t1099 / t1118
  t1200 = t1199 * t87
  t1201 = 0.13342809400364015280213860222187919752221792168441e-2 * t1200
  t1202 = s2 ** 2
  t1207 = 0.15398708928290202558763221866801247678833192955196e-3 * t1202 / t1084 / t1129 * t110
  t1212 = 0.34435261707988980716253443526170798898071625344353e-1 * t1199 * t87 * (0.1e1 + t1200 / 0.24e2)
  t1215 = f.my_piecewise3(t1212 < -t73, -t73, t1212)
  t1217 = jnp.exp(-0.1e1 / t1215)
  t1218 = f.my_piecewise3(t1212 <= -t73, 0, t1217)
  t1223 = t1200 / 0.600e3
  t1226 = f.my_piecewise3(t1223 < -t73, -t73, t1223)
  t1228 = jnp.exp(-0.1e1 / t1226)
  t1229 = f.my_piecewise3(t1223 <= -t73, 0, t1228)
  t1232 = 0.1174e1 - t1098 + (0.1e1 - t1195) * (-0.174e0 - t1201 - t1207 + t1098 + t1218 * (0.1e0 + t1201 + t1207 - t1098)) * (0.1e1 - t1229)
  t1241 = f.my_piecewise3(t1059, 0, 0.4e1 / 0.9e1 * t1070 * t1066 + 0.4e1 / 0.3e1 * t1060 * t1073)
  t1248 = f.my_piecewise3(t1059, 0, 0.4e1 / 0.3e1 * t1060 * t1065)
  t1254 = f.my_piecewise3(t1059, t673, t1060 * t1058)
  t1260 = f.my_piecewise3(t1056, 0, -0.3e1 / 0.8e1 * t5 * t1081 * t54 * t1232 - 0.3e1 / 0.8e1 * t5 * t1241 * t250 * t1232 + t5 * t1248 * t419 * t1232 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t1254 * t677 * t1232)
  t1270 = 0.1e1 / t249 / t36
  t1275 = s0 * t129
  t1276 = t1275 * t87
  t1277 = 0.34500222232249868645530751665864665591423853725411e0 * t1276
  t1279 = t209 * t314 * t110
  t1280 = 0.31785976948273109479323588841100847060505060026034e0 * t1279
  t1281 = t431 ** 2
  t1290 = t450 ** 2
  t1329 = f.my_piecewise3(t75, 0, -0.99805404412746248002956236078705543865847563712658e-1 * t56 / t69 / t708 / t748 * t209 * t314 * t67 + 0.15090577147207232698046982895100278232516151633353e2 * t707 * t708 * t807 * t710 - 0.42616907684242647897262312805607267230716909705303e1 * t438 * t129 * t62 * t86 + 0.75685765012999238068908479026351704098267735815427e0 * t260 * t211 * t63 * t66)
  t1342 = t453 ** 2
  t1346 = -0.24e2 * t700 * t1281 * t78 + 0.36e2 * t455 * t696 + 0.36e2 * t733 * t1281 * t78 - 0.6e1 * t430 * t1290 * t78 - 0.36e2 * t700 * t431 * t696 - 0.8e1 * t695 * t78 * t725 - 0.12e2 / t453 / t429 * t1281 * t78 + t257 * t1329 * t78 + 0.4e1 * t454 * t725 * t729 + 0.3e1 * t454 * t1290 * t78 + 0.6e1 * t733 * t450 * t431 * t78 + 0.1e1 / t1342 * t1281 * t78
  t1347 = f.my_piecewise3(t74, 0, t1346)
  t1348 = 0.1174e1 * t1347
  t1349 = t624 ** 2
  t1358 = t632 ** 2
  t1377 = f.my_piecewise3(t221, 0, 0.89038533482977927422371866816311260755705200149644e1 * t1275 * t217 + 0.25907220351664796109240553684998129442573887018333e1 * t1279)
  t1390 = t635 ** 2
  t1394 = -0.24e2 * t986 * t1349 * t224 + 0.36e2 * t637 * t982 + 0.36e2 * t1002 * t1349 * t224 - 0.6e1 * t623 * t1358 * t224 - 0.36e2 * t986 * t624 * t982 - 0.8e1 * t981 * t224 * t994 - 0.12e2 / t635 / t622 * t1349 * t224 + t388 * t1377 * t224 + 0.4e1 * t636 * t994 * t998 + 0.3e1 * t636 * t1358 * t224 + 0.6e1 * t1002 * t632 * t624 * t224 + 0.1e1 / t1390 * t1349 * t224
  t1395 = f.my_piecewise3(t220, 0, t1394)
  t1414 = t653 ** 2
  t1423 = t658 ** 2
  t1439 = f.my_piecewise3(t232, 0, 0.2618e4 / 0.6075e4 * t1276)
  t1452 = t661 ** 2
  t1456 = -0.24e2 * t1030 * t1414 * t235 + 0.36e2 * t663 * t1026 + 0.36e2 * t1043 * t1414 * t235 - 0.6e1 * t652 * t1423 * t235 - 0.36e2 * t1030 * t653 * t1026 - 0.8e1 * t1025 * t235 * t1035 - 0.12e2 / t661 / t651 * t1414 * t235 + t404 * t1439 * t235 + 0.4e1 * t662 * t1035 * t1039 + 0.3e1 * t662 * t1423 * t235 + 0.6e1 * t1043 * t658 * t653 * t235 + 0.1e1 / t1452 * t1414 * t235
  t1457 = f.my_piecewise3(t231, 0, t1456)
  t1471 = t477 ** 2
  t1481 = f.my_piecewise3(t94, -0.3e1 * s0 * t118 * t90, 0)
  t1506 = tau0 * t715 * t97
  t1508 = t741 * t280
  t1510 = t489 * t494
  t1512 = t272 * t753
  t1515 = t84 * t87 * t1481
  t1520 = t497 ** 2
  t1524 = -0.32745584861557206391632742177145572560628161203834e3 * t567 * t478 + 0.34602134549308214310926902872979858238747204611970e4 * t571 * t483 - 0.11948406214933889937498266651983258182442720739874e1 * t107 * t110 * t1471 - 0.10915194953852402130544247392381857520209387067945e2 * t119 * t501 * t1471 - 0.14194682644028890649214657558207052554650048106643e2 * t1506 + 0.12166870837739049127898277907034616475414326948551e2 * t1508 - 0.49773562518023382795947500528777976490331337516800e1 * t1510 + 0.12443390629505845698986875132194494122582834379200e1 * t1512 - 0.18665085944258768548480312698291741183874251568800e0 * t1515 + 0.78641214884791396161197506529499677815334555936292e2 * t154 * t515 * t1471 - 0.18330049773053757858615853599707319485350235730673e1 * t130 * t133 * t1520
  t1571 = t497 * t477
  t1590 = -0.97160702389750479491755452281147811393032165357990e2 * t102 * t618 * t112 - 0.34517617954253459819439436994618301415945637692970e2 * t486 * t498 + 0.36383983179508007101814157974606191734031290226482e2 * t294 * t774 + 0.39544170047233261783731629792676819034831700779350e1 * t551 * t825 - 0.88974382606274839013396167033522842828371326753535e0 * t348 * t850 * t1571 + 0.73320199092215031434463414398829277941400942922692e2 * t563 * t816 - 0.10998029863832254715169512159824391691210141438404e2 * t307 * t860 * t1571 - 0.29188017051347517237270186907714887244963795687344e3 * t523 * t819 + 0.52538430692425531027086336433886797040934832237220e2 * t318 * t864 * t1571 - 0.23910493311389565126666447788714743325746371623574e4 * t529 * t822 + 0.51236771381549068128570959547245878555170796336230e3 * t337 * t844 * t1571
  t1593 = t752 * t279
  t1653 = -0.27495074659580636787923780399560979228025353596010e1 * t307 * t535 * t1471 - 0.14553593271803202840725663189842476693612516090593e2 * t901 * t96 * t752 * t279 + 0.10485495317972186154826334203933290375377940791506e3 * t833 * t134 * t752 * t279 + 0.34052686559905436776815218059000701785791094968568e3 * t830 * t526 + 0.25238854050911207633703472665865562399398947824884e4 * t838 * t532 - 0.40485697905500720397630001930597695678518169845524e1 * t841 * t554 + 0.15931208286578519916664355535977677576590294319832e2 * t557 * t898 + 0.21830389907704804261088494784763715040418774135890e3 * t294 * t121 * t903 + 0.54130221058203196046677928161110997788836745515766e3 * t796 * t62 * t309 - 0.23458517407934856446250483551756039007989420978347e4 * t801 * t63 * t320 - 0.31456485953916558464479002611799871126133822374517e4 * t324 * t156 * t835
  t1685 = 0.62912971907833116928958005223599742252267644749035e3 * t833 * t122 * t497 * t477 - 0.22995400357496878066263163984455290186119041351561e5 * t763 * t62 * t339 + 0.41385380081178514184244001973499866693596351397647e2 * t769 * t63 * t350 + 0.12272930828179007935800688709197618281225115624167e3 * t787 * t63 * t290 + 0.17512810230808510342362112144628932346978277412406e2 * t318 * t145 * t96 * t1520 - 0.93686921062274762388481029509615188480678982623440e2 * t906 * t520 - 0.13283607395216425070370248771508190736525762013097e3 * t529 * t871 - 0.34517617954253459819439436994618301415945637692970e2 * t884 * t560 + 0.81466887880238923816070460443143642157112158802992e1 * t563 * t887 + 0.28464872989749482293650533081803265863983775742350e1 * t337 * t338 * t1481 + 0.18830557165349172277967442758417532873729381323500e0 * t551 * t876
  t1715 = -0.35307294685029698021188955172032874138242589981562e-2 * t348 * t349 * t1481 + 0.53104027621928399722214518453258925255300981066108e1 * t557 * t881 - 0.15931208286578519916664355535977677576590294319832e1 * t288 * t897 * t752 - 0.39828020716446299791660888839944193941475735799580e0 * t288 * t289 * t1481 - 0.30550082955089596431026422666178865808917059551122e0 * t307 * t308 * t1481 - 0.24323347542789597697725155756429072704136496406120e2 * t523 * t892 + 0.72970042628368793093175467269287218112409489218360e0 * t318 * t319 * t1481 + 0.79088340094466523567463259585353638069663401558699e1 * t551 * t851 - 0.74145318838562365844496805861269035690309438961280e0 * t348 * t180 * t134 * t1520 - 0.29188017051347517237270186907714887244963795687344e3 * t523 * t865 - 0.28106076318682428716544308852884556544203694787032e3 * t906 * t536
  t1725 = f.my_piecewise3(t188, 0.30800e5 / 0.729e3 * t1506 - 0.8800e4 / 0.243e3 * t1508 + 0.400e3 / 0.27e2 * t1510 - 0.100e3 / 0.27e2 * t1512 + 0.5e1 / 0.9e1 * t1515, 0)
  t1734 = t580 ** 2
  t1737 = t583 ** 2
  t1750 = t357 * t917
  t1759 = -0.12063067191025636561756297344054915325509498465082e1 * t1725 * t191 + 0.96504537528205092494050378752439322604075987720656e1 * t917 * t361 * t357 - 0.43427041887692291622322670438597695171834194474295e2 * t580 * t587 * t583 + 0.72378403146153819370537784064329491953056990790492e1 * t1734 * t361 + 0.28951361258461527748215113625731796781222796316197e2 * t1737 * t927 - 0.28951361258461527748215113625731796781222796316197e2 * t190 / t926 / t189 * t1737 + 0.43427041887692291622322670438597695171834194474296e2 * t928 * t583 * t580 - 0.72378403146153819370537784064329491953056990790492e1 * t588 * t1734 - 0.96504537528205092494050378752439322604075987720656e1 * t588 * t1750 + 0.12063067191025636561756297344054915325509498465082e1 * t362 * t1725 - 0.66620136356071591521659992430582748757664351917068e1 * t1734 - 0.88826848474762122028879989907443665010219135889424e1 * t1750 - 0.22206712118690530507219997476860916252554783972356e1 * t190 * t1725
  t1771 = t596 ** 2
  t1775 = t598 ** 2
  t1776 = t599 ** 2
  t1788 = f.my_piecewise3(t100, -0.21123787749768199948207876007307223624856471025883e2 * t173 / t58 / t766 / r0 * t183 + t1685 - 0.21830389907704804261088494784763715040418774135890e2 * t119 * t121 * t497 * t477 - 0.32703675222664430944867914930671227830755533749109e3 * t126 / t81 / t152 * t135 + 0.13293159864496418652875274012661755437860671887730e4 * t138 / t58 / t331 * t148 + 0.31456485953916558464479002611799871126133822374518e3 * t154 * t156 * t111 * t1520 + 0.12045209711069793272804514468048009145109974041294e5 * t161 / t81 / t465 * t170 + 0.34157847587699378752380639698163919036780530890820e3 * t337 * t167 * t122 * t1520 + t1653 + t1590 + 0.13621074623962174710726087223600280714316437987427e4 * t830 * t540 + 0.15143312430546724580222083599519337439639368694930e5 * t838 * t544 - 0.28339988533850504278341001351418386974962718891866e2 * t841 * t548 - 0.39850822185649275211110746314524572209577286039290e4 * t529 * t845 + 0.15281272935393362982761946349334600528293141895122e4 * t808 * t298 - 0.65491169723114412783265484354291145121256322407668e3 * t567 * t502 - 0.27681707639446571448741522298383886590997763689576e5 * t812 * t328 + 0.17301067274654107155463451436489929119373602305985e5 * t571 * t516 - 0.41941981271888744619305336815733161501511763166024e4 * t324 * t758 - 0.20970990635944372309652668407866580750755881583012e3 * t324 * t779 + 0.72767966359016014203628315949212383468062580452964e2 * t294 * t804 + 0.48880132728143354289642276265886185294267295281795e2 * t563 * t861 + t1524 + t1715 - 0.10187515290262241988507964232889733685528761263414e4 * t115 / t312 * t123 + 0.14994258304700226201401657911624605236790455331853e5 * t151 / t342 * t158 + 0.87564051154042551711810560723144661734891387062032e1 * t318 * t539 * t1471 + 0.51236771381549068128570959547245878555170796336230e2 * t337 * t543 * t1471 - 0.18191991589754003550907078987303095867015645113241e1 * t119 * t297 * t1481 + 0.52427476589860930774131671019666451876889703957529e1 * t154 * t327 * t1481 + 0.11675206820539006894908074763085954897985518274938e2 * t318 * t539 * t1593 + 0.68315695175398757504761279396327838073561061781640e2 * t337 * t543 * t1593 - 0.98860425118083154459329074481692047587079251948372e-1 * t348 * t547 * t1593 - 0.36660099546107515717231707199414638970700471461347e1 * t307 * t535 * t1593 - 0.74145318838562365844496805861269035690309438961279e-1 * t348 * t547 * t1471, t1759 * t372 - 0.2e1 * t939 * t600 * t942 + 0.3e1 * t596 * t947 * t949 * t598 - 0.3e1 * t941 * t64 * t598 - 0.3e1 / 0.2e1 * t1771 * t600 * t602 - 0.3e1 / 0.4e1 * t1775 / t1776 * t143 * t368 * t196 + 0.3e1 / 0.2e1 * t1775 * t947 * t120 * t196)
  t1812 = t203 * (-t1277 - t1280 + t1348 + t1395 * t226 + 0.4e1 * t1006 * t398 + 0.6e1 * t640 * t644 + 0.4e1 * t396 * t1012 + t225 * (t1277 + t1280 - t1348)) * t237 + 0.12e2 * t609 * t666 - 0.4e1 * t1015 * t409 + 0.4e1 * t375 * t1047 - t229 * t1457 - t1348 - t1788 * t228 * t237 + 0.12e2 * t959 * t409 - 0.6e1 * t606 * t646 * t237 + 0.4e1 * t957 * t409 - 0.4e1 * t956 * t400 * t237 + 0.12e2 * t964 * t409 - 0.4e1 * t374 * t1014 * t237 + 0.6e1 * t607 * t666 - 0.4e1 * t401 * t1047 - 0.6e1 * t647 * t666
  t1844 = t19 ** 2
  t1847 = t30 ** 2
  t1853 = t41 ** 2
  t1862 = -0.24e2 * t45 + 0.24e2 * t16 / t44 / t6
  t1863 = f.my_piecewise5(t10, 0, t14, 0, t1862)
  t1867 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t22 / t1844 * t1847 - 0.16e2 / 0.9e1 * t24 * t30 * t41 + 0.4e1 / 0.3e1 * t34 * t1853 + 0.16e2 / 0.9e1 * t35 * t49 + 0.4e1 / 0.3e1 * t21 * t1863)
  t1875 = -0.5e1 / 0.9e1 * t5 * t678 * t411 - 0.5e1 / 0.9e1 * t5 * t417 * t677 * t239 + 0.10e2 / 0.27e2 * t5 * t675 * t1270 * t239 - 0.3e1 / 0.8e1 * t5 * t690 * t1812 - t5 * t686 * t1049 / 0.2e1 - 0.3e1 / 0.2e1 * t5 * t428 * t1049 + t5 * t248 * t419 * t239 / 0.2e1 + t5 * t682 * t668 / 0.2e1 - t5 * t53 * t250 * t239 / 0.2e1 - 0.3e1 / 0.2e1 * t5 * t424 * t668 + t5 * t420 * t411 - 0.9e1 / 0.4e1 * t5 * t255 * t668 - 0.3e1 / 0.2e1 * t5 * t251 * t411 - 0.3e1 / 0.8e1 * t5 * t1867 * t54 * t239 - 0.3e1 / 0.2e1 * t5 * t55 * t411
  t1876 = f.my_piecewise3(t1, 0, t1875)
  t1877 = t1058 ** 2
  t1880 = t1066 ** 2
  t1886 = t1073 ** 2
  t1892 = f.my_piecewise5(t14, 0, t10, 0, -t1862)
  t1896 = f.my_piecewise3(t1059, 0, 0.40e2 / 0.81e2 / t1061 / t1877 * t1880 - 0.16e2 / 0.9e1 * t1063 * t1066 * t1073 + 0.4e1 / 0.3e1 * t1070 * t1886 + 0.16e2 / 0.9e1 * t1071 * t1077 + 0.4e1 / 0.3e1 * t1060 * t1892)
  t1918 = f.my_piecewise3(t1056, 0, -0.3e1 / 0.8e1 * t5 * t1896 * t54 * t1232 - t5 * t1081 * t250 * t1232 / 0.2e1 + t5 * t1241 * t419 * t1232 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t1248 * t677 * t1232 + 0.10e2 / 0.27e2 * t5 * t1254 * t1270 * t1232)
  d1111 = 0.4e1 * t1054 + 0.4e1 * t1260 + t6 * (t1876 + t1918)

  res = {'v4rho4': d1111}
  return res
