"""Generated from mgga_x_mbeef.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  mbeef_n = 8

  mbeef_coefs = [None, np.array([np.nan, 1.1802933, 0.0085302786, -0.102312143, 0.068575749, -0.00661294786, -0.0284176163, 0.00554283363, 0.00395434277], dtype=np.float64), np.array([np.nan, -0.00198479086, 0.100339208, -0.043464346, -0.0182177954, 0.0162638575, -0.00884148272, -0.00957417512, 0.00940675747], dtype=np.float64), np.array([np.nan, 0.00637590839, -0.00879090772, -0.0150103636, 0.0280678872, -0.0182911291, -0.0188495102, 1.69805915e-07, -2.7652468e-07], dtype=np.float64), np.array([np.nan, 0.00144642135, -0.00303347141, 0.00293253041, -0.00845508103, 0.00631891628, -0.00896771404, -2.65114646e-08, 5.05920757e-08], dtype=np.float64), np.array([np.nan, 0.000665511484, 0.00119130546, 0.00182906057, 0.00339308972, -7.90811707e-08, 1.62238741e-07, -4.16393106e-08, 5.54588743e-08], dtype=np.float64), np.array([np.nan, -0.000116063796, 0.000822139896, -0.00035104103, 0.000896739466, 2.09603871e-08, -3.76702959e-08, 2.36391411e-08, -3.38128188e-08], dtype=np.float64), np.array([np.nan, -5.54173599e-06, -5.14204676e-05, 6.68980219e-09, -2.16860568e-08, 9.12223751e-09, -1.38472194e-08, 6.94482484e-09, -7.74224962e-09], dtype=np.float64), np.array([np.nan, 7.3606257e-07, -9.40351563e-06, -2.23014657e-09, 6.74910119e-09, -4.93824365e-09, 8.50272392e-09, -6.91592964e-09, 8.88525527e-09], dtype=np.float64)]

  mbeef_k = 6.5124

  mbeef_xj0 = lambda a: -(1 - a ** 2) ** 3 / (1 + a ** 3 * (1 + a ** 3))

  mbeef_xi = lambda p: 2 * p / (mbeef_k + p) - 1

  mbeef_xj = lambda a: apply_piecewise(a, lambda _aval: _aval >= 10000.0, lambda _aval: 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 4 - 1 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 3 - 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 2 + 1, lambda _aval: mbeef_xj0(jnp.minimum(_aval, 10000.0)))

  mbeef_expansion = lambda x, t: jnp.sum(jnp.array([jnp.sum(jnp.array([+mbeef_coefs[i][j] * P(j - 1, mbeef_xi(X2S ** 2 * x ** 2)) * P(i - 1, mbeef_xj((t - x ** 2 / 8) / K_FACTOR_C)) for i in range(1, mbeef_n + 1)]), axis=0) for j in range(1, mbeef_n + 1)]), axis=0)

  mbeef_f = lambda x, u, t: mbeef_expansion(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, mbeef_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  mbeef_n = 8

  mbeef_coefs = [None, np.array([np.nan, 1.1802933, 0.0085302786, -0.102312143, 0.068575749, -0.00661294786, -0.0284176163, 0.00554283363, 0.00395434277], dtype=np.float64), np.array([np.nan, -0.00198479086, 0.100339208, -0.043464346, -0.0182177954, 0.0162638575, -0.00884148272, -0.00957417512, 0.00940675747], dtype=np.float64), np.array([np.nan, 0.00637590839, -0.00879090772, -0.0150103636, 0.0280678872, -0.0182911291, -0.0188495102, 1.69805915e-07, -2.7652468e-07], dtype=np.float64), np.array([np.nan, 0.00144642135, -0.00303347141, 0.00293253041, -0.00845508103, 0.00631891628, -0.00896771404, -2.65114646e-08, 5.05920757e-08], dtype=np.float64), np.array([np.nan, 0.000665511484, 0.00119130546, 0.00182906057, 0.00339308972, -7.90811707e-08, 1.62238741e-07, -4.16393106e-08, 5.54588743e-08], dtype=np.float64), np.array([np.nan, -0.000116063796, 0.000822139896, -0.00035104103, 0.000896739466, 2.09603871e-08, -3.76702959e-08, 2.36391411e-08, -3.38128188e-08], dtype=np.float64), np.array([np.nan, -5.54173599e-06, -5.14204676e-05, 6.68980219e-09, -2.16860568e-08, 9.12223751e-09, -1.38472194e-08, 6.94482484e-09, -7.74224962e-09], dtype=np.float64), np.array([np.nan, 7.3606257e-07, -9.40351563e-06, -2.23014657e-09, 6.74910119e-09, -4.93824365e-09, 8.50272392e-09, -6.91592964e-09, 8.88525527e-09], dtype=np.float64)]

  mbeef_k = 6.5124

  mbeef_xj0 = lambda a: -(1 - a ** 2) ** 3 / (1 + a ** 3 * (1 + a ** 3))

  mbeef_xi = lambda p: 2 * p / (mbeef_k + p) - 1

  mbeef_xj = lambda a: apply_piecewise(a, lambda _aval: _aval >= 10000.0, lambda _aval: 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 4 - 1 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 3 - 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 2 + 1, lambda _aval: mbeef_xj0(jnp.minimum(_aval, 10000.0)))

  mbeef_expansion = lambda x, t: jnp.sum(jnp.array([jnp.sum(jnp.array([+mbeef_coefs[i][j] * P(j - 1, mbeef_xi(X2S ** 2 * x ** 2)) * P(i - 1, mbeef_xj((t - x ** 2 / 8) / K_FACTOR_C)) for i in range(1, mbeef_n + 1)]), axis=0) for j in range(1, mbeef_n + 1)]), axis=0)

  mbeef_f = lambda x, u, t: mbeef_expansion(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, mbeef_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  mbeef_n = 8

  mbeef_coefs = [None, np.array([np.nan, 1.1802933, 0.0085302786, -0.102312143, 0.068575749, -0.00661294786, -0.0284176163, 0.00554283363, 0.00395434277], dtype=np.float64), np.array([np.nan, -0.00198479086, 0.100339208, -0.043464346, -0.0182177954, 0.0162638575, -0.00884148272, -0.00957417512, 0.00940675747], dtype=np.float64), np.array([np.nan, 0.00637590839, -0.00879090772, -0.0150103636, 0.0280678872, -0.0182911291, -0.0188495102, 1.69805915e-07, -2.7652468e-07], dtype=np.float64), np.array([np.nan, 0.00144642135, -0.00303347141, 0.00293253041, -0.00845508103, 0.00631891628, -0.00896771404, -2.65114646e-08, 5.05920757e-08], dtype=np.float64), np.array([np.nan, 0.000665511484, 0.00119130546, 0.00182906057, 0.00339308972, -7.90811707e-08, 1.62238741e-07, -4.16393106e-08, 5.54588743e-08], dtype=np.float64), np.array([np.nan, -0.000116063796, 0.000822139896, -0.00035104103, 0.000896739466, 2.09603871e-08, -3.76702959e-08, 2.36391411e-08, -3.38128188e-08], dtype=np.float64), np.array([np.nan, -5.54173599e-06, -5.14204676e-05, 6.68980219e-09, -2.16860568e-08, 9.12223751e-09, -1.38472194e-08, 6.94482484e-09, -7.74224962e-09], dtype=np.float64), np.array([np.nan, 7.3606257e-07, -9.40351563e-06, -2.23014657e-09, 6.74910119e-09, -4.93824365e-09, 8.50272392e-09, -6.91592964e-09, 8.88525527e-09], dtype=np.float64)]

  mbeef_k = 6.5124

  mbeef_xj0 = lambda a: -(1 - a ** 2) ** 3 / (1 + a ** 3 * (1 + a ** 3))

  mbeef_xi = lambda p: 2 * p / (mbeef_k + p) - 1

  mbeef_xj = lambda a: apply_piecewise(a, lambda _aval: _aval >= 10000.0, lambda _aval: 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 4 - 1 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 3 - 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 2 + 1, lambda _aval: mbeef_xj0(jnp.minimum(_aval, 10000.0)))

  mbeef_expansion = lambda x, t: jnp.sum(jnp.array([jnp.sum(jnp.array([+mbeef_coefs[i][j] * P(j - 1, mbeef_xi(X2S ** 2 * x ** 2)) * P(i - 1, mbeef_xj((t - x ** 2 / 8) / K_FACTOR_C)) for i in range(1, mbeef_n + 1)]), axis=0) for j in range(1, mbeef_n + 1)]), axis=0)

  mbeef_f = lambda x, u, t: mbeef_expansion(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, mbeef_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = jnp.pi ** 2
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = 0.1e1 / t31
  t33 = t28 * t32
  t34 = r0 ** 2
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / t34
  t39 = s0 * t38
  t42 = 0.65124e1 + t33 * t39 / 0.24e2
  t43 = 0.1e1 / t42
  t45 = t33 * t39 * t43
  t47 = t45 / 0.12e2 - 0.1e1
  t48 = t47 ** 2
  t49 = t48 * t47
  t50 = t48 ** 2
  t51 = t50 * t49
  t53 = t50 * t47
  t57 = 0.1e1 / t36 / r0
  t63 = 0.5e1 / 0.9e1 * (tau0 * t57 - t39 / 0.8e1) * t28 * t32
  t64 = 0.1e5 <= t63
  t65 = 0.1e5 < t63
  t66 = f.my_piecewise3(t65, t63, 0.1e5)
  t67 = t66 ** 2
  t71 = 0.1e1 / t67 / t66
  t72 = t67 ** 2
  t73 = 0.1e1 / t72
  t76 = f.my_piecewise3(t65, 0.1e5, t63)
  t77 = t76 ** 2
  t78 = 0.1e1 - t77
  t79 = t78 ** 2
  t80 = t79 * t78
  t81 = t77 * t76
  t82 = 0.1e1 + t81
  t84 = t81 * t82 + 0.1e1
  t85 = 0.1e1 / t84
  t87 = f.my_piecewise3(t64, 0.1e1 - 0.3e1 / t67 - t71 + 0.3e1 * t73, -t80 * t85)
  t88 = t87 ** 2
  t89 = t88 * t87
  t90 = t88 ** 2
  t91 = t90 * t89
  t94 = t90 * t87
  t97 = t50 * t48
  t101 = t90 * t88
  t106 = -0.73257564333333333333333333333333333333333333333333e-3 * t45 + 0.879090772e-2
  t108 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t88
  t111 = -0.25278928416666666666666666666666666666666666666667e-3 * t45 + 0.303347141e-2
  t114 = 0.5e1 / 0.2e1 * t89 - 0.3e1 / 0.2e1 * t87
  t118 = 0.70169718000000000000000000000000000000000000000000e-1 * t49 - 0.35084859000000000000000000000000000000000000000000e-2 * t45 + 0.42101830800000000000000000000000000000000000000000e-1
  t120 = 0.10602581552062500000000000000000000000000000000000e0 * t51 - 0.39506119958812500000000000000000000000000000000000e0 * t53 + 0.49794463840937500000000000000000000000000000000000e0 * t49 + 0.19735677658125000000000000000000000000000000000000e-4 * t91 - 0.43736526393718750000000000000000000000000000000000e-2 * t87 - 0.94588310356312500000000000000000000000000000000000e-3 * t94 + 0.46461028218468750000000000000000000000000000000000e-2 * t89 + 0.80024660533125000000000000000000000000000000000000e-1 * t97 - 0.13805618397812500000000000000000000000000000000000e0 * t50 - 0.92294814328125000000000000000000000000000000000000e-1 * t48 - 0.80008813355625000000000000000000000000000000000000e-4 * t101 + 0.30207156698031250000000000000000000000000000000000e-2 * t90 + 0.70318268775656250000000000000000000000000000000000e-2 * t88 + t106 * t108 + t111 * t114 + t118 * t108
  t123 = -0.45544488500000000000000000000000000000000000000000e-1 * t49 + 0.22772244250000000000000000000000000000000000000000e-2 * t45 - 0.27326693100000000000000000000000000000000000000000e-1
  t126 = 0.11150732850000000000000000000000000000000000000000e-8 - 0.33452198550000000000000000000000000000000000000000e-8 * t48
  t131 = 0.429e3 / 0.16e2 * t91 - 0.693e3 / 0.16e2 * t94 + 0.315e3 / 0.16e2 * t89 - 0.35e2 / 0.16e2 * t87
  t134 = -0.33449010950000000000000000000000000000000000000000e-8 + 0.10034703285000000000000000000000000000000000000000e-7 * t48
  t138 = -0.5e1 / 0.16e2 + 0.231e3 / 0.16e2 * t101 - 0.315e3 / 0.16e2 * t90 + 0.105e3 / 0.16e2 * t88
  t141 = 0.17552051500000000000000000000000000000000000000000e-3 - 0.52656154500000000000000000000000000000000000000000e-3 * t48
  t145 = 0.63e2 / 0.8e1 * t94 - 0.35e2 / 0.4e1 * t89 + 0.15e2 / 0.8e1 * t87
  t148 = -0.91453028500000000000000000000000000000000000000000e-3 + 0.27435908550000000000000000000000000000000000000000e-2 * t48
  t151 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t90 - 0.15e2 / 0.4e1 * t88
  t154 = -0.14662652050000000000000000000000000000000000000000e-2 + 0.43987956150000000000000000000000000000000000000000e-2 * t48
  t157 = 0.75051818000000000000000000000000000000000000000000e-2 - 0.22515545400000000000000000000000000000000000000000e-1 * t48
  t160 = 0.21732173000000000000000000000000000000000000000000e-1 - 0.65196519000000000000000000000000000000000000000000e-1 * t48
  t163 = -0.78362630250000000000000000000000000000000000000000e-6 * t45 + 0.940351563e-5
  t166 = -0.42850389666666666666666666666666666666666666666667e-5 * t45 + 0.514204676e-4
  t169 = 0.68511658000000000000000000000000000000000000000000e-4 * t45 - 0.822139896e-3
  t172 = 0.99275455000000000000000000000000000000000000000000e-4 * t45 - 0.119130546e-2
  t175 = 0.83616006666666666666666666666666666666666666666667e-2 * t45 - 0.100339208e0
  t179 = 0.34208390662500000000000000000000000000000000000000e-8 + 0.39909789106250000000000000000000000000000000000000e-7 * t50 - 0.34208390662500000000000000000000000000000000000000e-7 * t48
  t183 = 0.78601451625000000000000000000000000000000000000000e-8 + 0.91701693562500000000000000000000000000000000000000e-7 * t50 - 0.78601451625000000000000000000000000000000000000000e-7 * t48
  t187 = -0.29655439012500000000000000000000000000000000000000e-7 - 0.34598012181250000000000000000000000000000000000000e-6 * t50 + 0.29655439012500000000000000000000000000000000000000e-6 * t48
  t189 = t157 * t108 + t154 * t114 + t123 * t87 + t126 * t131 + t163 * t131 + t134 * t138 + t166 * t138 + t179 * t138 + t141 * t145 + t169 * t145 + t183 * t145 + t148 * t151 + t172 * t151 + t187 * t151 + t160 * t87 + t175 * t87
  t193 = 0.23695936050000000000000000000000000000000000000000e-2 + 0.27645258725000000000000000000000000000000000000000e-1 * t50 - 0.23695936050000000000000000000000000000000000000000e-1 * t48
  t197 = -0.68591734125000000000000000000000000000000000000000e-2 - 0.80023689812500000000000000000000000000000000000000e-1 * t50 + 0.68591734125000000000000000000000000000000000000000e-1 * t48
  t201 = 0.60989465625000000000000000000000000000000000000000e-2 + 0.71154376562500000000000000000000000000000000000000e-1 * t50 - 0.60989465625000000000000000000000000000000000000000e-1 * t48
  t205 = 0.16872752975000000000000000000000000000000000000000e-7 * t49 - 0.84363764875000000000000000000000000000000000000000e-9 * t45 + 0.10123651785000000000000000000000000000000000000000e-7
  t209 = -0.54215142000000000000000000000000000000000000000000e-7 * t49 + 0.27107571000000000000000000000000000000000000000000e-8 * t45 - 0.32529085200000000000000000000000000000000000000000e-7
  t213 = 0.22418486650000000000000000000000000000000000000000e-2 * t49 - 0.11209243325000000000000000000000000000000000000000e-3 * t45 + 0.13451091990000000000000000000000000000000000000000e-2
  t217 = 0.84827243000000000000000000000000000000000000000000e-2 * t49 - 0.42413621500000000000000000000000000000000000000000e-3 * t45 + 0.50896345800000000000000000000000000000000000000000e-2
  t221 = -0.21137702575000000000000000000000000000000000000000e-1 * t49 + 0.10568851287500000000000000000000000000000000000000e-2 * t45 - 0.12682621545000000000000000000000000000000000000000e-1
  t226 = 0.29919297250000000000000000000000000000000000000000e-2 - 0.13822715329500000000000000000000000000000000000000e0 * t97 + 0.18849157267500000000000000000000000000000000000000e0 * t50 - 0.62830524225000000000000000000000000000000000000000e-1 * t48
  t231 = 0.66958950870000000000000000000000000000000000000000e-7 * t53 - 0.74398834300000000000000000000000000000000000000000e-7 * t49 + 0.13285506125000000000000000000000000000000000000000e-8 * t45 - 0.15942607350000000000000000000000000000000000000000e-7
  t236 = -0.10904685277500000000000000000000000000000000000000e-6 * t53 + 0.12116316975000000000000000000000000000000000000000e-6 * t49 - 0.21636280312500000000000000000000000000000000000000e-8 * t45 + 0.25963536375000000000000000000000000000000000000000e-7
  t241 = -0.29665358021250000000000000000000000000000000000000e-6 * t53 + 0.32961508912500000000000000000000000000000000000000e-6 * t49 - 0.58859837343750000000000000000000000000000000000000e-8 * t45 + 0.70631804812500000000000000000000000000000000000000e-7
  t246 = 0.12776300853750000000000000000000000000000000000000e-5 * t53 - 0.14195889837500000000000000000000000000000000000000e-5 * t49 + 0.25349803281250000000000000000000000000000000000000e-7 * t45 - 0.30419763937500000000000000000000000000000000000000e-6
  t251 = -0.70620748065000000000000000000000000000000000000000e-1 * t53 + 0.78467497850000000000000000000000000000000000000000e-1 * t49 - 0.14012053187500000000000000000000000000000000000000e-2 * t45 + 0.16814463825000000000000000000000000000000000000000e-1
  t256 = -0.14843989282500000000000000000000000000000000000000e0 * t53 + 0.16493321425000000000000000000000000000000000000000e0 * t49 - 0.29452359687500000000000000000000000000000000000000e-2 * t45 + 0.35342831625000000000000000000000000000000000000000e-1
  t261 = -0.69626676420000000000000000000000000000000000000000e-1 * t53 + 0.77362973800000000000000000000000000000000000000000e-1 * t49 - 0.13814816750000000000000000000000000000000000000000e-2 * t45 + 0.16577780100000000000000000000000000000000000000000e-1
  t263 = t197 * t108 + t256 * t108 + t193 * t114 + t221 * t114 + t251 * t114 + t205 * t131 + t231 * t131 + t209 * t138 + t236 * t138 + t213 * t145 + t241 * t145 + t217 * t151 + t246 * t151 + t201 * t87 + t226 * t87 + t261 * t87
  t266 = -0.18518413687500000000000000000000000000000000000000e-8 - 0.21604815968750000000000000000000000000000000000000e-7 * t50 + 0.18518413687500000000000000000000000000000000000000e-7 * t48
  t272 = -0.74143179825000000000000000000000000000000000000000e-5 * t51 + 0.11976975202500000000000000000000000000000000000000e-4 * t53 - 0.54440796375000000000000000000000000000000000000000e-5 * t49 + 0.50408144791666666666666666666666666666666666666667e-7 * t45 - 0.60489773750000000000000000000000000000000000000000e-6
  t278 = 0.25221868466437500000000000000000000000000000000000e0 * t51 - 0.40743018291937500000000000000000000000000000000000e0 * t53 + 0.18519553769062500000000000000000000000000000000000e0 * t49 - 0.17147734971354166666666666666666666666666666666667e-2 * t45 + 0.20577281965625000000000000000000000000000000000000e-1
  t283 = 0.21612280125000000000000000000000000000000000000000e-8 - 0.99848734177500000000000000000000000000000000000000e-7 * t97 + 0.13615736478750000000000000000000000000000000000000e-6 * t50 - 0.45385788262500000000000000000000000000000000000000e-7 * t48
  t288 = -0.21702577625000000000000000000000000000000000000000e-8 + 0.10026590862750000000000000000000000000000000000000e-6 * t97 - 0.13672623903750000000000000000000000000000000000000e-6 * t50 + 0.45575413012500000000000000000000000000000000000000e-7 * t48
  t293 = -0.73872315937500000000000000000000000000000000000000e-8 + 0.34129009963125000000000000000000000000000000000000e-6 * t97 - 0.46539559040625000000000000000000000000000000000000e-6 * t50 + 0.15513186346875000000000000000000000000000000000000e-6 * t48
  t298 = 0.13012284562500000000000000000000000000000000000000e-7 - 0.60116754678750000000000000000000000000000000000000e-6 * t97 + 0.81977392743750000000000000000000000000000000000000e-6 * t50 - 0.27325797581250000000000000000000000000000000000000e-6 * t48
  t303 = 0.82848326875000000000000000000000000000000000000000e-8 - 0.38275927016250000000000000000000000000000000000000e-6 * t97 + 0.52194445931250000000000000000000000000000000000000e-6 * t50 - 0.17398148643750000000000000000000000000000000000000e-6 * t48
  t308 = -0.53064348437500000000000000000000000000000000000000e-7 + 0.24515728978125000000000000000000000000000000000000e-5 * t97 - 0.33430539515625000000000000000000000000000000000000e-5 * t50 + 0.11143513171875000000000000000000000000000000000000e-5 * t48
  t314 = 0.23823590692687500000000000000000000000000000000000e-6 * t51 - 0.38484261888187500000000000000000000000000000000000e-6 * t53 + 0.17492846312812500000000000000000000000000000000000e-6 * t49 - 0.16197079919270833333333333333333333333333333333333e-8 * t45 + 0.19436495903125000000000000000000000000000000000000e-7
  t320 = -0.20758906793625000000000000000000000000000000000000e-6 * t51 + 0.33533618666625000000000000000000000000000000000000e-6 * t53 - 0.15242553939375000000000000000000000000000000000000e-6 * t49 + 0.14113475869791666666666666666666666666666666666667e-8 * t45 - 0.16936171043750000000000000000000000000000000000000e-7
  t326 = -0.90660620407500000000000000000000000000000000000000e-6 * t51 + 0.14645177142750000000000000000000000000000000000000e-5 * t53 - 0.66568987012500000000000000000000000000000000000000e-6 * t49 + 0.61637950937500000000000000000000000000000000000000e-8 * t45 - 0.73965541125000000000000000000000000000000000000000e-7
  t332 = 0.14869910671687500000000000000000000000000000000000e-5 * t51 - 0.24020624931187500000000000000000000000000000000000e-5 * t53 + 0.10918465877812500000000000000000000000000000000000e-5 * t49 - 0.10109690627604166666666666666666666666666666666667e-7 * t45 + 0.12131628753125000000000000000000000000000000000000e-6
  t338 = 0.13565000297062500000000000000000000000000000000000e-5 * t51 - 0.21912692787562500000000000000000000000000000000000e-5 * t53 + 0.99603149034375000000000000000000000000000000000000e-6 * t49 - 0.92225137994791666666666666666666666666666666666667e-8 * t45 + 0.11067016559375000000000000000000000000000000000000e-6
  t341 = 0.13805672252189968750000000000000000000000000000000e1 + t266 * t131 + t272 * t108 + t278 * t87 + t283 * t131 + t288 * t138 + t293 * t145 + t298 * t151 + t303 * t114 + t308 * t108 + t314 * t131 + t320 * t138 + t326 * t145 + t332 * t151 + t338 * t114 - 0.13022208355989583333333333333333333333333333333333e-1 * t45
  t343 = t120 + t189 + t263 + t341
  t347 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t343)
  t348 = r1 <= f.p.dens_threshold
  t349 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t350 = 0.1e1 + t349
  t351 = t350 <= f.p.zeta_threshold
  t352 = t350 ** (0.1e1 / 0.3e1)
  t354 = f.my_piecewise3(t351, t22, t352 * t350)
  t355 = t354 * t26
  t356 = r1 ** 2
  t357 = r1 ** (0.1e1 / 0.3e1)
  t358 = t357 ** 2
  t360 = 0.1e1 / t358 / t356
  t361 = s2 * t360
  t364 = 0.65124e1 + t33 * t361 / 0.24e2
  t365 = 0.1e1 / t364
  t367 = t33 * t361 * t365
  t369 = t367 / 0.12e2 - 0.1e1
  t370 = t369 ** 2
  t374 = 0.1e1 / t358 / r1
  t380 = 0.5e1 / 0.9e1 * (tau1 * t374 - t361 / 0.8e1) * t28 * t32
  t381 = 0.1e5 <= t380
  t382 = 0.1e5 < t380
  t383 = f.my_piecewise3(t382, t380, 0.1e5)
  t384 = t383 ** 2
  t388 = 0.1e1 / t384 / t383
  t389 = t384 ** 2
  t390 = 0.1e1 / t389
  t393 = f.my_piecewise3(t382, 0.1e5, t380)
  t394 = t393 ** 2
  t395 = 0.1e1 - t394
  t396 = t395 ** 2
  t397 = t396 * t395
  t398 = t394 * t393
  t399 = 0.1e1 + t398
  t401 = t398 * t399 + 0.1e1
  t402 = 0.1e1 / t401
  t404 = f.my_piecewise3(t381, 0.1e1 - 0.3e1 / t384 - t388 + 0.3e1 * t390, -t397 * t402)
  t406 = t404 ** 2
  t407 = t406 ** 2
  t408 = t407 * t404
  t410 = t406 * t404
  t412 = t407 * t406
  t416 = t370 * t369
  t417 = t370 ** 2
  t418 = t417 * t416
  t420 = t417 * t369
  t424 = 0.68511658000000000000000000000000000000000000000000e-4 * t367 - 0.822139896e-3
  t428 = 0.63e2 / 0.8e1 * t408 - 0.35e2 / 0.4e1 * t410 + 0.15e2 / 0.8e1 * t404
  t431 = 0.99275455000000000000000000000000000000000000000000e-4 * t367 - 0.119130546e-2
  t434 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t407 - 0.15e2 / 0.4e1 * t406
  t437 = -0.25278928416666666666666666666666666666666666666667e-3 * t367 + 0.303347141e-2
  t440 = 0.5e1 / 0.2e1 * t410 - 0.3e1 / 0.2e1 * t404
  t443 = -0.73257564333333333333333333333333333333333333333333e-3 * t367 + 0.879090772e-2
  t445 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t406
  t448 = 0.83616006666666666666666666666666666666666666666667e-2 * t367 - 0.100339208e0
  t450 = -0.92294814328125000000000000000000000000000000000000e-1 * t370 - 0.13022208355989583333333333333333333333333333333333e-1 * t367 - 0.43736526393718750000000000000000000000000000000000e-2 * t404 - 0.94588310356312500000000000000000000000000000000000e-3 * t408 + 0.46461028218468750000000000000000000000000000000000e-2 * t410 - 0.80008813355625000000000000000000000000000000000000e-4 * t412 + 0.30207156698031250000000000000000000000000000000000e-2 * t407 + 0.70318268775656250000000000000000000000000000000000e-2 * t406 + 0.10602581552062500000000000000000000000000000000000e0 * t418 - 0.39506119958812500000000000000000000000000000000000e0 * t420 + 0.49794463840937500000000000000000000000000000000000e0 * t416 + t424 * t428 + t431 * t434 + t437 * t440 + t443 * t445 + t448 * t404
  t453 = 0.84827243000000000000000000000000000000000000000000e-2 * t416 - 0.42413621500000000000000000000000000000000000000000e-3 * t367 + 0.50896345800000000000000000000000000000000000000000e-2
  t457 = -0.21137702575000000000000000000000000000000000000000e-1 * t416 + 0.10568851287500000000000000000000000000000000000000e-2 * t367 - 0.12682621545000000000000000000000000000000000000000e-1
  t461 = 0.70169718000000000000000000000000000000000000000000e-1 * t416 - 0.35084859000000000000000000000000000000000000000000e-2 * t367 + 0.42101830800000000000000000000000000000000000000000e-1
  t465 = -0.45544488500000000000000000000000000000000000000000e-1 * t416 + 0.22772244250000000000000000000000000000000000000000e-2 * t367 - 0.27326693100000000000000000000000000000000000000000e-1
  t468 = 0.11150732850000000000000000000000000000000000000000e-8 - 0.33452198550000000000000000000000000000000000000000e-8 * t370
  t469 = t407 * t410
  t474 = 0.429e3 / 0.16e2 * t469 - 0.693e3 / 0.16e2 * t408 + 0.315e3 / 0.16e2 * t410 - 0.35e2 / 0.16e2 * t404
  t477 = -0.33449010950000000000000000000000000000000000000000e-8 + 0.10034703285000000000000000000000000000000000000000e-7 * t370
  t481 = -0.5e1 / 0.16e2 + 0.231e3 / 0.16e2 * t412 - 0.315e3 / 0.16e2 * t407 + 0.105e3 / 0.16e2 * t406
  t484 = 0.17552051500000000000000000000000000000000000000000e-3 - 0.52656154500000000000000000000000000000000000000000e-3 * t370
  t487 = -0.91453028500000000000000000000000000000000000000000e-3 + 0.27435908550000000000000000000000000000000000000000e-2 * t370
  t490 = -0.14662652050000000000000000000000000000000000000000e-2 + 0.43987956150000000000000000000000000000000000000000e-2 * t370
  t493 = 0.75051818000000000000000000000000000000000000000000e-2 - 0.22515545400000000000000000000000000000000000000000e-1 * t370
  t496 = 0.21732173000000000000000000000000000000000000000000e-1 - 0.65196519000000000000000000000000000000000000000000e-1 * t370
  t499 = -0.78362630250000000000000000000000000000000000000000e-6 * t367 + 0.940351563e-5
  t502 = -0.42850389666666666666666666666666666666666666666667e-5 * t367 + 0.514204676e-4
  t507 = -0.69626676420000000000000000000000000000000000000000e-1 * t420 + 0.77362973800000000000000000000000000000000000000000e-1 * t416 - 0.13814816750000000000000000000000000000000000000000e-2 * t367 + 0.16577780100000000000000000000000000000000000000000e-1
  t511 = -0.18518413687500000000000000000000000000000000000000e-8 - 0.21604815968750000000000000000000000000000000000000e-7 * t417 + 0.18518413687500000000000000000000000000000000000000e-7 * t370
  t515 = 0.34208390662500000000000000000000000000000000000000e-8 + 0.39909789106250000000000000000000000000000000000000e-7 * t417 - 0.34208390662500000000000000000000000000000000000000e-7 * t370
  t517 = t465 * t404 + t496 * t404 + t507 * t404 + t484 * t428 + t453 * t434 + t487 * t434 + t457 * t440 + t490 * t440 + t461 * t445 + t493 * t445 + t468 * t474 + t499 * t474 + t511 * t474 + t477 * t481 + t502 * t481 + t515 * t481
  t521 = 0.78601451625000000000000000000000000000000000000000e-8 + 0.91701693562500000000000000000000000000000000000000e-7 * t417 - 0.78601451625000000000000000000000000000000000000000e-7 * t370
  t525 = -0.29655439012500000000000000000000000000000000000000e-7 - 0.34598012181250000000000000000000000000000000000000e-6 * t417 + 0.29655439012500000000000000000000000000000000000000e-6 * t370
  t529 = 0.23695936050000000000000000000000000000000000000000e-2 + 0.27645258725000000000000000000000000000000000000000e-1 * t417 - 0.23695936050000000000000000000000000000000000000000e-1 * t370
  t533 = -0.68591734125000000000000000000000000000000000000000e-2 - 0.80023689812500000000000000000000000000000000000000e-1 * t417 + 0.68591734125000000000000000000000000000000000000000e-1 * t370
  t537 = 0.60989465625000000000000000000000000000000000000000e-2 + 0.71154376562500000000000000000000000000000000000000e-1 * t417 - 0.60989465625000000000000000000000000000000000000000e-1 * t370
  t541 = 0.16872752975000000000000000000000000000000000000000e-7 * t416 - 0.84363764875000000000000000000000000000000000000000e-9 * t367 + 0.10123651785000000000000000000000000000000000000000e-7
  t545 = -0.54215142000000000000000000000000000000000000000000e-7 * t416 + 0.27107571000000000000000000000000000000000000000000e-8 * t367 - 0.32529085200000000000000000000000000000000000000000e-7
  t549 = 0.22418486650000000000000000000000000000000000000000e-2 * t416 - 0.11209243325000000000000000000000000000000000000000e-3 * t367 + 0.13451091990000000000000000000000000000000000000000e-2
  t551 = t417 * t370
  t555 = 0.82848326875000000000000000000000000000000000000000e-8 - 0.38275927016250000000000000000000000000000000000000e-6 * t551 + 0.52194445931250000000000000000000000000000000000000e-6 * t417 - 0.17398148643750000000000000000000000000000000000000e-6 * t370
  t560 = -0.53064348437500000000000000000000000000000000000000e-7 + 0.24515728978125000000000000000000000000000000000000e-5 * t551 - 0.33430539515625000000000000000000000000000000000000e-5 * t417 + 0.11143513171875000000000000000000000000000000000000e-5 * t370
  t565 = 0.29919297250000000000000000000000000000000000000000e-2 - 0.13822715329500000000000000000000000000000000000000e0 * t551 + 0.18849157267500000000000000000000000000000000000000e0 * t417 - 0.62830524225000000000000000000000000000000000000000e-1 * t370
  t570 = 0.66958950870000000000000000000000000000000000000000e-7 * t420 - 0.74398834300000000000000000000000000000000000000000e-7 * t416 + 0.13285506125000000000000000000000000000000000000000e-8 * t367 - 0.15942607350000000000000000000000000000000000000000e-7
  t575 = -0.10904685277500000000000000000000000000000000000000e-6 * t420 + 0.12116316975000000000000000000000000000000000000000e-6 * t416 - 0.21636280312500000000000000000000000000000000000000e-8 * t367 + 0.25963536375000000000000000000000000000000000000000e-7
  t580 = -0.29665358021250000000000000000000000000000000000000e-6 * t420 + 0.32961508912500000000000000000000000000000000000000e-6 * t416 - 0.58859837343750000000000000000000000000000000000000e-8 * t367 + 0.70631804812500000000000000000000000000000000000000e-7
  t585 = 0.12776300853750000000000000000000000000000000000000e-5 * t420 - 0.14195889837500000000000000000000000000000000000000e-5 * t416 + 0.25349803281250000000000000000000000000000000000000e-7 * t367 - 0.30419763937500000000000000000000000000000000000000e-6
  t590 = -0.70620748065000000000000000000000000000000000000000e-1 * t420 + 0.78467497850000000000000000000000000000000000000000e-1 * t416 - 0.14012053187500000000000000000000000000000000000000e-2 * t367 + 0.16814463825000000000000000000000000000000000000000e-1
  t592 = t537 * t404 + t565 * t404 + t521 * t428 + t549 * t428 + t580 * t428 + t525 * t434 + t585 * t434 + t529 * t440 + t555 * t440 + t590 * t440 + t533 * t445 + t560 * t445 + t541 * t474 + t570 * t474 + t545 * t481 + t575 * t481
  t596 = -0.14843989282500000000000000000000000000000000000000e0 * t420 + 0.16493321425000000000000000000000000000000000000000e0 * t416 - 0.29452359687500000000000000000000000000000000000000e-2 * t367 + 0.35342831625000000000000000000000000000000000000000e-1
  t602 = 0.13565000297062500000000000000000000000000000000000e-5 * t418 - 0.21912692787562500000000000000000000000000000000000e-5 * t420 + 0.99603149034375000000000000000000000000000000000000e-6 * t416 - 0.92225137994791666666666666666666666666666666666667e-8 * t367 + 0.11067016559375000000000000000000000000000000000000e-6
  t608 = -0.74143179825000000000000000000000000000000000000000e-5 * t418 + 0.11976975202500000000000000000000000000000000000000e-4 * t420 - 0.54440796375000000000000000000000000000000000000000e-5 * t416 + 0.50408144791666666666666666666666666666666666666667e-7 * t367 - 0.60489773750000000000000000000000000000000000000000e-6
  t614 = 0.25221868466437500000000000000000000000000000000000e0 * t418 - 0.40743018291937500000000000000000000000000000000000e0 * t420 + 0.18519553769062500000000000000000000000000000000000e0 * t416 - 0.17147734971354166666666666666666666666666666666667e-2 * t367 + 0.20577281965625000000000000000000000000000000000000e-1
  t619 = 0.21612280125000000000000000000000000000000000000000e-8 - 0.99848734177500000000000000000000000000000000000000e-7 * t551 + 0.13615736478750000000000000000000000000000000000000e-6 * t417 - 0.45385788262500000000000000000000000000000000000000e-7 * t370
  t624 = -0.21702577625000000000000000000000000000000000000000e-8 + 0.10026590862750000000000000000000000000000000000000e-6 * t551 - 0.13672623903750000000000000000000000000000000000000e-6 * t417 + 0.45575413012500000000000000000000000000000000000000e-7 * t370
  t629 = -0.73872315937500000000000000000000000000000000000000e-8 + 0.34129009963125000000000000000000000000000000000000e-6 * t551 - 0.46539559040625000000000000000000000000000000000000e-6 * t417 + 0.15513186346875000000000000000000000000000000000000e-6 * t370
  t634 = 0.13012284562500000000000000000000000000000000000000e-7 - 0.60116754678750000000000000000000000000000000000000e-6 * t551 + 0.81977392743750000000000000000000000000000000000000e-6 * t417 - 0.27325797581250000000000000000000000000000000000000e-6 * t370
  t640 = 0.23823590692687500000000000000000000000000000000000e-6 * t418 - 0.38484261888187500000000000000000000000000000000000e-6 * t420 + 0.17492846312812500000000000000000000000000000000000e-6 * t416 - 0.16197079919270833333333333333333333333333333333333e-8 * t367 + 0.19436495903125000000000000000000000000000000000000e-7
  t646 = -0.20758906793625000000000000000000000000000000000000e-6 * t418 + 0.33533618666625000000000000000000000000000000000000e-6 * t420 - 0.15242553939375000000000000000000000000000000000000e-6 * t416 + 0.14113475869791666666666666666666666666666666666667e-8 * t367 - 0.16936171043750000000000000000000000000000000000000e-7
  t652 = -0.90660620407500000000000000000000000000000000000000e-6 * t418 + 0.14645177142750000000000000000000000000000000000000e-5 * t420 - 0.66568987012500000000000000000000000000000000000000e-6 * t416 + 0.61637950937500000000000000000000000000000000000000e-8 * t367 - 0.73965541125000000000000000000000000000000000000000e-7
  t658 = 0.14869910671687500000000000000000000000000000000000e-5 * t418 - 0.24020624931187500000000000000000000000000000000000e-5 * t420 + 0.10918465877812500000000000000000000000000000000000e-5 * t416 - 0.10109690627604166666666666666666666666666666666667e-7 * t367 + 0.12131628753125000000000000000000000000000000000000e-6
  t663 = 0.13805672252189968750000000000000000000000000000000e1 + t596 * t445 + t602 * t440 + t608 * t445 + t614 * t404 + t619 * t474 + t624 * t481 + t629 * t428 + t634 * t434 + t640 * t474 + t646 * t481 + t652 * t428 + t658 * t434 + 0.19735677658125000000000000000000000000000000000000e-4 * t469 + 0.80024660533125000000000000000000000000000000000000e-1 * t551 - 0.13805618397812500000000000000000000000000000000000e0 * t417
  t665 = t450 + t517 + t592 + t663
  t669 = f.my_piecewise3(t348, 0, -0.3e1 / 0.8e1 * t5 * t355 * t665)
  t670 = t6 ** 2
  t672 = t16 / t670
  t673 = t7 - t672
  t674 = f.my_piecewise5(t10, 0, t14, 0, t673)
  t677 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t674)
  t682 = t26 ** 2
  t683 = 0.1e1 / t682
  t687 = t5 * t25 * t683 * t343 / 0.8e1
  t691 = s0 / t36 / t34 / r0
  t693 = t33 * t691 * t43
  t695 = t28 ** 2
  t698 = t695 / t30 / t29
  t699 = s0 ** 2
  t700 = t34 ** 2
  t705 = t42 ** 2
  t706 = 0.1e1 / t705
  t708 = t698 * t699 / t35 / t700 / t34 * t706
  t716 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau0 * t38 + t691 / 0.3e1) * t28 * t32
  t717 = f.my_piecewise3(t65, t716, 0)
  t723 = 0.1e1 / t72 / t66
  t727 = t79 * t85
  t728 = f.my_piecewise3(t65, 0, t716)
  t732 = t84 ** 2
  t734 = t80 / t732
  t735 = t77 * t82
  t737 = t77 ** 2
  t738 = t737 * t76
  t744 = f.my_piecewise3(t64, 0.6e1 * t71 * t717 - 0.12e2 * t723 * t717 + 0.3e1 * t73 * t717, 0.6e1 * t727 * t76 * t728 + t734 * (0.3e1 * t735 * t728 + 0.3e1 * t738 * t728))
  t746 = t101 * t744
  t748 = t90 * t744
  t750 = t88 * t744
  t753 = 0.3003e4 / 0.16e2 * t746 - 0.3465e4 / 0.16e2 * t748 + 0.945e3 / 0.16e2 * t750 - 0.35e2 / 0.16e2 * t744
  t755 = t94 * t744
  t757 = t89 * t744
  t759 = t87 * t744
  t761 = 0.693e3 / 0.8e1 * t755 - 0.315e3 / 0.4e1 * t757 + 0.105e3 / 0.8e1 * t759
  t765 = -0.2e1 / 0.9e1 * t693 + t708 / 0.108e3
  t766 = t97 * t765
  t768 = t50 * t765
  t770 = t48 * t765
  t785 = 0.15e2 / 0.2e1 * t750 - 0.3e1 / 0.2e1 * t744
  t797 = 0.315e3 / 0.8e1 * t748 - 0.105e3 / 0.4e1 * t750 + 0.15e2 / 0.8e1 * t744
  t808 = 0.35e2 / 0.2e1 * t757 - 0.15e2 / 0.2e1 * t759
  t818 = 0.34725888949305555555555555555555555555555555555555e-1 * t693 - 0.14469120395543981481481481481481481481481481481481e-2 * t708 - 0.43736526393718750000000000000000000000000000000000e-2 * t744 + t314 * t753 + t320 * t761 + (-0.63462434285250000000000000000000000000000000000000e-5 * t766 + 0.73225885713750000000000000000000000000000000000000e-5 * t768 - 0.19970696103750000000000000000000000000000000000000e-5 * t770 - 0.16436786916666666666666666666666666666666666666667e-7 * t693 + 0.68486612152777777777777777777777777777777777777778e-9 * t708) * t145 + (0.16676513484881250000000000000000000000000000000000e-5 * t766 - 0.19242130944093750000000000000000000000000000000000e-5 * t768 + 0.52478538938437500000000000000000000000000000000000e-6 * t770 + 0.43192213118055555555555555555555555555555555555555e-8 * t693 - 0.17996755465856481481481481481481481481481481481481e-9 * t708) * t131 + t338 * t785 + (-0.51900225877500000000000000000000000000000000000000e-4 * t766 + 0.59884876012500000000000000000000000000000000000000e-4 * t768 - 0.16332238912500000000000000000000000000000000000000e-4 * t770 - 0.13442171944444444444444444444444444444444444444445e-6 * t693 + 0.56009049768518518518518518518518518518518518518519e-8 * t708) * t108 + t326 * t797 + (0.10408937470181250000000000000000000000000000000000e-4 * t766 - 0.12010312465593750000000000000000000000000000000000e-4 * t768 + 0.32755397633437500000000000000000000000000000000000e-5 * t770 + 0.26959175006944444444444444444444444444444444444445e-7 * t693 - 0.11232989586226851851851851851851851851851851851852e-8 * t708) * t151 + t332 * t808 + (-0.14531234755537500000000000000000000000000000000000e-5 * t766 + 0.16766809333312500000000000000000000000000000000000e-5 * t768 - 0.45727661818125000000000000000000000000000000000000e-6 * t770 - 0.37635935652777777777777777777777777777777777777779e-8 * t693 + 0.15681639855324074074074074074074074074074074074074e-9 * t708) * t138 + t278 * t744
  t819 = t53 * t765
  t821 = t49 * t765
  t823 = t47 * t765
  t873 = (-0.59909240506500000000000000000000000000000000000000e-6 * t819 + 0.54462945915000000000000000000000000000000000000000e-6 * t821 - 0.90771576525000000000000000000000000000000000000000e-7 * t823) * t131 + t283 * t753 + (0.94955002079437500000000000000000000000000000000000e-5 * t766 - 0.10956346393781250000000000000000000000000000000000e-4 * t768 + 0.29880944710312500000000000000000000000000000000000e-5 * t770 + 0.24593370131944444444444444444444444444444444444445e-7 * t693 - 0.10247237554976851851851851851851851851851851851852e-8 * t708) * t114 + (0.20477405977875000000000000000000000000000000000000e-5 * t819 - 0.18615823616250000000000000000000000000000000000000e-5 * t821 + 0.31026372693750000000000000000000000000000000000000e-6 * t823) * t145 + t293 * t797 + (0.60159545176500000000000000000000000000000000000000e-6 * t819 - 0.54690495615000000000000000000000000000000000000000e-6 * t821 + 0.91150826025000000000000000000000000000000000000000e-7 * t823) * t138 + t288 * t761 + (0.17655307926506250000000000000000000000000000000000e1 * t766 - 0.20371509145968750000000000000000000000000000000000e1 * t768 + 0.55558661307187500000000000000000000000000000000000e0 * t770 + 0.45727293256944444444444444444444444444444444444445e-2 * t693 - 0.19053038857060185185185185185185185185185185185186e-3 * t708) * t87 + 0.74218070864437500000000000000000000000000000000000e0 * t766 + t303 * t785 + (-0.82936291977000000000000000000000000000000000000000e0 * t819 + 0.75396629070000000000000000000000000000000000000000e0 * t821 - 0.12566104845000000000000000000000000000000000000000e0 * t823) * t87 + t226 * t744 + (0.33479475435000000000000000000000000000000000000000e-6 * t768 - 0.22319650290000000000000000000000000000000000000000e-6 * t770 - 0.35428016333333333333333333333333333333333333333333e-8 * t693 + 0.14761673472222222222222222222222222222222222222222e-9 * t708) * t131 + (-0.36070052807250000000000000000000000000000000000000e-5 * t819 + 0.32790957097500000000000000000000000000000000000000e-5 * t821 - 0.54651595162500000000000000000000000000000000000000e-6 * t823) * t151
  t920 = t298 * t808 + (-0.22965556209750000000000000000000000000000000000000e-5 * t819 + 0.20877778372500000000000000000000000000000000000000e-5 * t821 - 0.34796297287500000000000000000000000000000000000000e-6 * t823) * t114 + t251 * t785 + (-0.14832679010625000000000000000000000000000000000000e-5 * t768 + 0.98884526737500000000000000000000000000000000000000e-6 * t770 + 0.15695956625000000000000000000000000000000000000000e-7 * t693 - 0.65399819270833333333333333333333333333333333333333e-9 * t708) * t145 + t241 * t797 + t231 * t753 + (-0.54523426387500000000000000000000000000000000000000e-6 * t768 + 0.36348950925000000000000000000000000000000000000000e-6 * t770 + 0.57696747500000000000000000000000000000000000000000e-8 * t693 - 0.24040311458333333333333333333333333333333333333333e-9 * t708) * t138 + t236 * t761 + (0.14709437386875000000000000000000000000000000000000e-4 * t819 - 0.13372215806250000000000000000000000000000000000000e-4 * t821 + 0.22287026343750000000000000000000000000000000000000e-5 * t823) * t108 + 0.48014796319875000000000000000000000000000000000000e0 * t819 + (0.15963915642500000000000000000000000000000000000000e-6 * t821 - 0.68416781325000000000000000000000000000000000000000e-7 * t823) * t138 + (-0.74219946412500000000000000000000000000000000000000e0 * t768 + 0.49479964275000000000000000000000000000000000000000e0 * t770 + 0.78539625833333333333333333333333333333333333333333e-2 * t693 - 0.32724844097222222222222222222222222222222222222222e-3 * t708) * t108 - 0.19753059979406250000000000000000000000000000000000e1 * t768 + (-0.34813338210000000000000000000000000000000000000000e0 * t768 + 0.23208892140000000000000000000000000000000000000000e0 * t770 + 0.36839511333333333333333333333333333333333333333333e-2 * t693 - 0.15349796388888888888888888888888888888888888888889e-3 * t708) * t87
  t962 = t261 * t744 + (0.63881504268750000000000000000000000000000000000000e-5 * t768 - 0.42587669512500000000000000000000000000000000000000e-5 * t770 - 0.67599475416666666666666666666666666666666666666667e-7 * t693 + 0.28166448090277777777777777777777777777777777777778e-8 * t708) * t151 + t246 * t808 + (-0.35310374032500000000000000000000000000000000000000e0 * t768 + 0.23540249355000000000000000000000000000000000000000e0 * t770 + 0.37365475166666666666666666666666666666666666666667e-2 * t693 - 0.15568947986111111111111111111111111111111111111111e-3 * t708) * t114 + t187 * t808 + (0.11058103490000000000000000000000000000000000000000e0 * t821 - 0.47391872100000000000000000000000000000000000000000e-1 * t823) * t114 + t179 * t761 + (0.36680677425000000000000000000000000000000000000000e-6 * t821 - 0.15720290325000000000000000000000000000000000000000e-6 * t823) * t145 + t183 * t797 + (-0.86419263875000000000000000000000000000000000000000e-7 * t821 + 0.37036827375000000000000000000000000000000000000000e-7 * t823) * t131 + t266 * t753 + (0.67255459950000000000000000000000000000000000000000e-2 * t770 + 0.29891315533333333333333333333333333333333333333333e-3 * t693 - 0.12454714805555555555555555555555555555555555555556e-4 * t708) * t145 + t213 * t797 + (0.50618258925000000000000000000000000000000000000000e-7 * t770 + 0.22497003966666666666666666666666666666666666666667e-8 * t693 - 0.93737516527777777777777777777777777777777777777778e-10 * t708) * t131
  t996 = t205 * t753 + t193 * t785 + (-0.32009475925000000000000000000000000000000000000000e0 * t821 + 0.13718346825000000000000000000000000000000000000000e0 * t823) * t108 - 0.55222473591250000000000000000000000000000000000000e0 * t821 - 0.18458962865625000000000000000000000000000000000000e0 * t823 + (0.28461750625000000000000000000000000000000000000000e0 * t821 - 0.12197893125000000000000000000000000000000000000000e0 * t823) * t87 + t201 * t744 + (-0.13839204872500000000000000000000000000000000000000e-5 * t821 + 0.59310878025000000000000000000000000000000000000000e-6 * t823) * t151 + t126 * t753 + t134 * t761 + (0.21050915400000000000000000000000000000000000000000e0 * t770 + 0.93559624000000000000000000000000000000000000000000e-2 * t693 - 0.38983176666666666666666666666666666666666666666667e-3 * t708) * t108 + 0.14938339152281250000000000000000000000000000000000e1 * t770 + (-0.13663346550000000000000000000000000000000000000000e0 * t770 - 0.60725984666666666666666666666666666666666666666667e-2 * t693 + 0.25302493611111111111111111111111111111111111111111e-3 * t708) * t87 + t123 * t744
  t1035 = (0.25448172900000000000000000000000000000000000000000e-1 * t770 + 0.11310299066666666666666666666666666666666666666667e-2 * t693 - 0.47126246111111111111111111111111111111111111111111e-4 * t708) * t151 + t217 * t808 + (-0.63413107725000000000000000000000000000000000000000e-1 * t770 - 0.28183603433333333333333333333333333333333333333333e-2 * t693 + 0.11743168097222222222222222222222222222222222222222e-3 * t708) * t114 + t221 * t785 + (-0.16264542600000000000000000000000000000000000000000e-6 * t770 - 0.72286856000000000000000000000000000000000000000000e-8 * t693 + 0.30119523333333333333333333333333333333333333333333e-9 * t708) * t138 + t209 * t761 + (-0.22297601777777777777777777777777777777777777777778e-1 * t693 + 0.92906674074074074074074074074074074074074074074074e-3 * t708) * t87 + t175 * t744 + (0.19535350488888888888888888888888888888888888888889e-2 * t693 - 0.81397293703703703703703703703703703703703703703703e-4 * t708) * t108 + (-0.26473454666666666666666666666666666666666666666667e-3 * t693 + 0.11030606111111111111111111111111111111111111111111e-4 * t708) * t151 + t172 * t808 + 0.12082862679212500000000000000000000000000000000000e-1 * t757 + 0.14063653755131250000000000000000000000000000000000e-1 * t759 + (-0.18269775466666666666666666666666666666666666666667e-3 * t693 + 0.76124064444444444444444444444444444444444444444444e-5 * t708) * t145
  t1060 = t169 * t797 - 0.47294155178156250000000000000000000000000000000000e-2 * t748 + (0.11426770577777777777777777777777777777777777777778e-4 * t693 - 0.47611544074074074074074074074074074074074074074074e-6 * t708) * t138 + t166 * t761 - 0.48005288013375000000000000000000000000000000000000e-3 * t755 + t160 * t744 + (0.20896701400000000000000000000000000000000000000000e-5 * t693 - 0.87069589166666666666666666666666666666666666666667e-7 * t708) * t131 + t163 * t753 + 0.13814974360687500000000000000000000000000000000000e-3 * t746 + t148 * t808 + t154 * t785 + t141 * t797 + (0.67410475777777777777777777777777777777777777777779e-3 * t693 - 0.28087698240740740740740740740740740740740740740741e-4 * t708) * t114 + t111 * t785
  t1072 = t157 * t87
  t1077 = t118 * t87
  t1082 = t197 * t87
  t1085 = t256 * t87
  t1088 = t308 * t87
  t1091 = t272 * t87
  t1094 = t106 * t87
  t1097 = 0.13938308465540625000000000000000000000000000000000e-1 * t750 + 0.20069406570000000000000000000000000000000000000000e-7 * t823 * t138 - 0.10531230900000000000000000000000000000000000000000e-2 * t823 * t145 + 0.54871817100000000000000000000000000000000000000000e-2 * t823 * t151 + 0.87975912300000000000000000000000000000000000000000e-2 * t823 * t114 - 0.45031090800000000000000000000000000000000000000000e-1 * t823 * t108 + 0.3e1 * t1072 * t744 - 0.13039303800000000000000000000000000000000000000000e0 * t823 * t87 + 0.3e1 * t1077 * t744 - 0.66904397100000000000000000000000000000000000000000e-8 * t823 * t131 + 0.3e1 * t1082 * t744 + 0.3e1 * t1085 * t744 + 0.3e1 * t1088 * t744 + 0.3e1 * t1091 * t744 + 0.3e1 * t1094 * t744
  t1105 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t677 * t26 * t343 - t687 - 0.3e1 / 0.8e1 * t5 * t27 * (t818 + t873 + t920 + t962 + t996 + t1035 + t1060 + t1097))
  t1107 = f.my_piecewise5(t14, 0, t10, 0, -t673)
  t1110 = f.my_piecewise3(t351, 0, 0.4e1 / 0.3e1 * t352 * t1107)
  t1118 = t5 * t354 * t683 * t665 / 0.8e1
  t1120 = f.my_piecewise3(t348, 0, -0.3e1 / 0.8e1 * t5 * t1110 * t26 * t665 - t1118)
  vrho_0_ = t347 + t669 + t6 * (t1105 + t1120)
  t1123 = -t7 - t672
  t1124 = f.my_piecewise5(t10, 0, t14, 0, t1123)
  t1127 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t1124)
  t1133 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1127 * t26 * t343 - t687)
  t1135 = f.my_piecewise5(t14, 0, t10, 0, -t1123)
  t1138 = f.my_piecewise3(t351, 0, 0.4e1 / 0.3e1 * t352 * t1135)
  t1148 = s2 / t358 / t356 / r1
  t1153 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau1 * t360 + t1148 / 0.3e1) * t28 * t32
  t1154 = f.my_piecewise3(t382, t1153, 0)
  t1160 = 0.1e1 / t389 / t383
  t1164 = t396 * t402
  t1165 = f.my_piecewise3(t382, 0, t1153)
  t1169 = t401 ** 2
  t1171 = t397 / t1169
  t1172 = t394 * t399
  t1174 = t394 ** 2
  t1175 = t1174 * t393
  t1181 = f.my_piecewise3(t381, -0.12e2 * t1160 * t1154 + 0.6e1 * t388 * t1154 + 0.3e1 * t390 * t1154, 0.6e1 * t1164 * t393 * t1165 + t1171 * (0.3e1 * t1172 * t1165 + 0.3e1 * t1175 * t1165))
  t1182 = t408 * t1181
  t1184 = t410 * t1181
  t1186 = t404 * t1181
  t1188 = 0.693e3 / 0.8e1 * t1182 - 0.315e3 / 0.4e1 * t1184 + 0.105e3 / 0.8e1 * t1186
  t1191 = t33 * t1148 * t365
  t1193 = s2 ** 2
  t1194 = t356 ** 2
  t1199 = t364 ** 2
  t1200 = 0.1e1 / t1199
  t1202 = t698 * t1193 / t357 / t1194 / t356 * t1200
  t1204 = -0.2e1 / 0.9e1 * t1191 + t1202 / 0.108e3
  t1205 = t551 * t1204
  t1207 = t417 * t1204
  t1209 = t370 * t1204
  t1215 = t407 * t1181
  t1217 = t406 * t1181
  t1220 = 0.315e3 / 0.8e1 * t1215 - 0.105e3 / 0.4e1 * t1217 + 0.15e2 / 0.8e1 * t1181
  t1231 = 0.35e2 / 0.2e1 * t1184 - 0.15e2 / 0.2e1 * t1186
  t1247 = t412 * t1181
  t1252 = 0.3003e4 / 0.16e2 * t1247 - 0.3465e4 / 0.16e2 * t1215 + 0.945e3 / 0.16e2 * t1217 - 0.35e2 / 0.16e2 * t1181
  t1261 = t420 * t1204
  t1263 = t416 * t1204
  t1265 = t369 * t1204
  t1272 = 0.15e2 / 0.2e1 * t1217 - 0.3e1 / 0.2e1 * t1181
  t1282 = t646 * t1188 + (-0.63462434285250000000000000000000000000000000000000e-5 * t1205 + 0.73225885713750000000000000000000000000000000000000e-5 * t1207 - 0.19970696103750000000000000000000000000000000000000e-5 * t1209 - 0.16436786916666666666666666666666666666666666666667e-7 * t1191 + 0.68486612152777777777777777777777777777777777777778e-9 * t1202) * t428 + t652 * t1220 + (0.10408937470181250000000000000000000000000000000000e-4 * t1205 - 0.12010312465593750000000000000000000000000000000000e-4 * t1207 + 0.32755397633437500000000000000000000000000000000000e-5 * t1209 + 0.26959175006944444444444444444444444444444444444445e-7 * t1191 - 0.11232989586226851851851851851851851851851851851852e-8 * t1202) * t434 + t658 * t1231 + (0.94955002079437500000000000000000000000000000000000e-5 * t1205 - 0.10956346393781250000000000000000000000000000000000e-4 * t1207 + 0.29880944710312500000000000000000000000000000000000e-5 * t1209 + 0.24593370131944444444444444444444444444444444444445e-7 * t1191 - 0.10247237554976851851851851851851851851851851851852e-8 * t1202) * t440 + (0.16676513484881250000000000000000000000000000000000e-5 * t1205 - 0.19242130944093750000000000000000000000000000000000e-5 * t1207 + 0.52478538938437500000000000000000000000000000000000e-6 * t1209 + 0.43192213118055555555555555555555555555555555555555e-8 * t1191 - 0.17996755465856481481481481481481481481481481481481e-9 * t1202) * t474 + t640 * t1252 + (-0.14531234755537500000000000000000000000000000000000e-5 * t1205 + 0.16766809333312500000000000000000000000000000000000e-5 * t1207 - 0.45727661818125000000000000000000000000000000000000e-6 * t1209 - 0.37635935652777777777777777777777777777777777777779e-8 * t1191 + 0.15681639855324074074074074074074074074074074074074e-9 * t1202) * t481 + (-0.59909240506500000000000000000000000000000000000000e-6 * t1261 + 0.54462945915000000000000000000000000000000000000000e-6 * t1263 - 0.90771576525000000000000000000000000000000000000000e-7 * t1265) * t474 + t619 * t1252 + t602 * t1272 + (-0.51900225877500000000000000000000000000000000000000e-4 * t1205 + 0.59884876012500000000000000000000000000000000000000e-4 * t1207 - 0.16332238912500000000000000000000000000000000000000e-4 * t1209 - 0.13442171944444444444444444444444444444444444444445e-6 * t1191 + 0.56009049768518518518518518518518518518518518518519e-8 * t1202) * t445 + 0.74218070864437500000000000000000000000000000000000e0 * t1205
  t1328 = (0.17655307926506250000000000000000000000000000000000e1 * t1205 - 0.20371509145968750000000000000000000000000000000000e1 * t1207 + 0.55558661307187500000000000000000000000000000000000e0 * t1209 + 0.45727293256944444444444444444444444444444444444445e-2 * t1191 - 0.19053038857060185185185185185185185185185185185186e-3 * t1202) * t404 + t629 * t1220 + (-0.36070052807250000000000000000000000000000000000000e-5 * t1261 + 0.32790957097500000000000000000000000000000000000000e-5 * t1263 - 0.54651595162500000000000000000000000000000000000000e-6 * t1265) * t434 + t634 * t1231 + (0.60159545176500000000000000000000000000000000000000e-6 * t1261 - 0.54690495615000000000000000000000000000000000000000e-6 * t1263 + 0.91150826025000000000000000000000000000000000000000e-7 * t1265) * t481 + t624 * t1188 + t614 * t1181 + (0.33479475435000000000000000000000000000000000000000e-6 * t1207 - 0.22319650290000000000000000000000000000000000000000e-6 * t1209 - 0.35428016333333333333333333333333333333333333333333e-8 * t1191 + 0.14761673472222222222222222222222222222222222222222e-9 * t1202) * t474 + t570 * t1252 + (-0.22965556209750000000000000000000000000000000000000e-5 * t1261 + 0.20877778372500000000000000000000000000000000000000e-5 * t1263 - 0.34796297287500000000000000000000000000000000000000e-6 * t1265) * t440 + t555 * t1272 + (0.14709437386875000000000000000000000000000000000000e-4 * t1261 - 0.13372215806250000000000000000000000000000000000000e-4 * t1263 + 0.22287026343750000000000000000000000000000000000000e-5 * t1265) * t445 + (0.20477405977875000000000000000000000000000000000000e-5 * t1261 - 0.18615823616250000000000000000000000000000000000000e-5 * t1263 + 0.31026372693750000000000000000000000000000000000000e-6 * t1265) * t428 + t590 * t1272
  t1376 = (-0.14832679010625000000000000000000000000000000000000e-5 * t1207 + 0.98884526737500000000000000000000000000000000000000e-6 * t1209 + 0.15695956625000000000000000000000000000000000000000e-7 * t1191 - 0.65399819270833333333333333333333333333333333333333e-9 * t1202) * t428 + t580 * t1220 + (-0.54523426387500000000000000000000000000000000000000e-6 * t1207 + 0.36348950925000000000000000000000000000000000000000e-6 * t1209 + 0.57696747500000000000000000000000000000000000000000e-8 * t1191 - 0.24040311458333333333333333333333333333333333333333e-9 * t1202) * t481 + t575 * t1188 + (-0.82936291977000000000000000000000000000000000000000e0 * t1261 + 0.75396629070000000000000000000000000000000000000000e0 * t1263 - 0.12566104845000000000000000000000000000000000000000e0 * t1265) * t404 + 0.48014796319875000000000000000000000000000000000000e0 * t1261 + t565 * t1181 + (-0.34813338210000000000000000000000000000000000000000e0 * t1207 + 0.23208892140000000000000000000000000000000000000000e0 * t1209 + 0.36839511333333333333333333333333333333333333333333e-2 * t1191 - 0.15349796388888888888888888888888888888888888888889e-3 * t1202) * t404 + t507 * t1181 + (-0.86419263875000000000000000000000000000000000000000e-7 * t1263 + 0.37036827375000000000000000000000000000000000000000e-7 * t1265) * t474 + t511 * t1252 + (0.63881504268750000000000000000000000000000000000000e-5 * t1207 - 0.42587669512500000000000000000000000000000000000000e-5 * t1209 - 0.67599475416666666666666666666666666666666666666667e-7 * t1191 + 0.28166448090277777777777777777777777777777777777778e-8 * t1202) * t434 + t585 * t1231 + (-0.35310374032500000000000000000000000000000000000000e0 * t1207 + 0.23540249355000000000000000000000000000000000000000e0 * t1209 + 0.37365475166666666666666666666666666666666666666667e-2 * t1191 - 0.15568947986111111111111111111111111111111111111111e-3 * t1202) * t440
  t1412 = (0.11058103490000000000000000000000000000000000000000e0 * t1263 - 0.47391872100000000000000000000000000000000000000000e-1 * t1265) * t440 + t529 * t1272 + (0.36680677425000000000000000000000000000000000000000e-6 * t1263 - 0.15720290325000000000000000000000000000000000000000e-6 * t1265) * t428 + t521 * t1220 + (0.15963915642500000000000000000000000000000000000000e-6 * t1263 - 0.68416781325000000000000000000000000000000000000000e-7 * t1265) * t481 + t515 * t1188 + (-0.74219946412500000000000000000000000000000000000000e0 * t1207 + 0.49479964275000000000000000000000000000000000000000e0 * t1209 + 0.78539625833333333333333333333333333333333333333333e-2 * t1191 - 0.32724844097222222222222222222222222222222222222222e-3 * t1202) * t445 - 0.19753059979406250000000000000000000000000000000000e1 * t1207 + t541 * t1252 + (-0.16264542600000000000000000000000000000000000000000e-6 * t1209 - 0.72286856000000000000000000000000000000000000000000e-8 * t1191 + 0.30119523333333333333333333333333333333333333333333e-9 * t1202) * t481 + t545 * t1188 + (-0.32009475925000000000000000000000000000000000000000e0 * t1263 + 0.13718346825000000000000000000000000000000000000000e0 * t1265) * t445 - 0.55222473591250000000000000000000000000000000000000e0 * t1263 - 0.18458962865625000000000000000000000000000000000000e0 * t1265
  t1455 = (0.28461750625000000000000000000000000000000000000000e0 * t1263 - 0.12197893125000000000000000000000000000000000000000e0 * t1265) * t404 + t537 * t1181 + (-0.13839204872500000000000000000000000000000000000000e-5 * t1263 + 0.59310878025000000000000000000000000000000000000000e-6 * t1265) * t434 + t525 * t1231 + (0.21050915400000000000000000000000000000000000000000e0 * t1209 + 0.93559624000000000000000000000000000000000000000000e-2 * t1191 - 0.38983176666666666666666666666666666666666666666667e-3 * t1202) * t445 + 0.14938339152281250000000000000000000000000000000000e1 * t1209 + (-0.13663346550000000000000000000000000000000000000000e0 * t1209 - 0.60725984666666666666666666666666666666666666666667e-2 * t1191 + 0.25302493611111111111111111111111111111111111111111e-3 * t1202) * t404 + t465 * t1181 + t468 * t1252 + (0.25448172900000000000000000000000000000000000000000e-1 * t1209 + 0.11310299066666666666666666666666666666666666666667e-2 * t1191 - 0.47126246111111111111111111111111111111111111111111e-4 * t1202) * t434 + t453 * t1231 + (-0.63413107725000000000000000000000000000000000000000e-1 * t1209 - 0.28183603433333333333333333333333333333333333333333e-2 * t1191 + 0.11743168097222222222222222222222222222222222222222e-3 * t1202) * t440 + t457 * t1272 + (0.67255459950000000000000000000000000000000000000000e-2 * t1209 + 0.29891315533333333333333333333333333333333333333333e-3 * t1191 - 0.12454714805555555555555555555555555555555555555556e-4 * t1202) * t428
  t1483 = t549 * t1220 + (0.50618258925000000000000000000000000000000000000000e-7 * t1209 + 0.22497003966666666666666666666666666666666666666667e-8 * t1191 - 0.93737516527777777777777777777777777777777777777778e-10 * t1202) * t474 + t431 * t1231 + 0.12082862679212500000000000000000000000000000000000e-1 * t1184 + 0.14063653755131250000000000000000000000000000000000e-1 * t1186 + (0.67410475777777777777777777777777777777777777777779e-3 * t1191 - 0.28087698240740740740740740740740740740740740740741e-4 * t1202) * t440 + t437 * t1272 + 0.13938308465540625000000000000000000000000000000000e-1 * t1217 + (-0.18269775466666666666666666666666666666666666666667e-3 * t1191 + 0.76124064444444444444444444444444444444444444444444e-5 * t1202) * t428 + t424 * t1220 - 0.47294155178156250000000000000000000000000000000000e-2 * t1215 + (0.20896701400000000000000000000000000000000000000000e-5 * t1191 - 0.87069589166666666666666666666666666666666666666667e-7 * t1202) * t474 + t499 * t1252 + 0.13814974360687500000000000000000000000000000000000e-3 * t1247
  t1511 = (0.11426770577777777777777777777777777777777777777778e-4 * t1191 - 0.47611544074074074074074074074074074074074074074074e-6 * t1202) * t481 + t502 * t1188 - 0.48005288013375000000000000000000000000000000000000e-3 * t1182 + t496 * t1181 + t487 * t1231 + t490 * t1272 + t484 * t1220 + t477 * t1188 + (0.19535350488888888888888888888888888888888888888889e-2 * t1191 - 0.81397293703703703703703703703703703703703703703703e-4 * t1202) * t445 + (-0.22297601777777777777777777777777777777777777777778e-1 * t1191 + 0.92906674074074074074074074074074074074074074074074e-3 * t1202) * t404 + t448 * t1181 + (-0.26473454666666666666666666666666666666666666666667e-3 * t1191 + 0.11030606111111111111111111111111111111111111111111e-4 * t1202) * t434 + 0.34725888949305555555555555555555555555555555555555e-1 * t1191 - 0.14469120395543981481481481481481481481481481481481e-2 * t1202
  t1512 = t443 * t404
  t1519 = t493 * t404
  t1532 = t461 * t404
  t1535 = t533 * t404
  t1538 = t596 * t404
  t1541 = t560 * t404
  t1544 = t608 * t404
  t1548 = 0.3e1 * t1512 * t1181 + 0.87975912300000000000000000000000000000000000000000e-2 * t1265 * t440 - 0.45031090800000000000000000000000000000000000000000e-1 * t1265 * t445 + 0.3e1 * t1519 * t1181 - 0.13039303800000000000000000000000000000000000000000e0 * t1265 * t404 - 0.66904397100000000000000000000000000000000000000000e-8 * t1265 * t474 + 0.20069406570000000000000000000000000000000000000000e-7 * t1265 * t481 - 0.10531230900000000000000000000000000000000000000000e-2 * t1265 * t428 + 0.54871817100000000000000000000000000000000000000000e-2 * t1265 * t434 + 0.3e1 * t1532 * t1181 + 0.3e1 * t1535 * t1181 + 0.3e1 * t1538 * t1181 + 0.3e1 * t1541 * t1181 + 0.3e1 * t1544 * t1181 - 0.43736526393718750000000000000000000000000000000000e-2 * t1181
  t1556 = f.my_piecewise3(t348, 0, -0.3e1 / 0.8e1 * t5 * t1138 * t26 * t665 - t1118 - 0.3e1 / 0.8e1 * t5 * t355 * (t1282 + t1328 + t1376 + t1412 + t1455 + t1483 + t1511 + t1548))
  vrho_1_ = t347 + t669 + t6 * (t1133 + t1556)
  t1560 = 0.5e1 / 0.72e2 * t33 * t38
  t1561 = f.my_piecewise3(t65, -t1560, 0)
  t1569 = f.my_piecewise3(t65, 0, -t1560)
  t1579 = f.my_piecewise3(t64, 0.6e1 * t71 * t1561 - 0.12e2 * t723 * t1561 + 0.3e1 * t73 * t1561, 0.6e1 * t727 * t76 * t1569 + t734 * (0.3e1 * t735 * t1569 + 0.3e1 * t738 * t1569))
  t1581 = t90 * t1579
  t1583 = t88 * t1579
  t1586 = 0.315e3 / 0.8e1 * t1581 - 0.105e3 / 0.4e1 * t1583 + 0.15e2 / 0.8e1 * t1579
  t1590 = t33 * t38 * t43
  t1597 = t698 * s0 / t35 / t700 / r0 * t706
  t1601 = t101 * t1579
  t1606 = 0.3003e4 / 0.16e2 * t1601 - 0.3465e4 / 0.16e2 * t1581 + 0.945e3 / 0.16e2 * t1583 - 0.35e2 / 0.16e2 * t1579
  t1615 = 0.15e2 / 0.2e1 * t1583 - 0.3e1 / 0.2e1 * t1579
  t1618 = t89 * t1579
  t1620 = t87 * t1579
  t1622 = 0.35e2 / 0.2e1 * t1618 - 0.15e2 / 0.2e1 * t1620
  t1624 = t94 * t1579
  t1628 = 0.693e3 / 0.8e1 * t1624 - 0.315e3 / 0.4e1 * t1618 + 0.105e3 / 0.8e1 * t1620
  t1633 = -0.43736526393718750000000000000000000000000000000000e-2 * t1579 + t169 * t1586 - 0.47294155178156250000000000000000000000000000000000e-2 * t1581 + (-0.78362630250000000000000000000000000000000000000000e-6 * t1590 + 0.32651095937500000000000000000000000000000000000000e-7 * t1597) * t131 + t163 * t1606 + 0.13814974360687500000000000000000000000000000000000e-3 * t1601 + (-0.42850389666666666666666666666666666666666666666667e-5 * t1590 + 0.17854329027777777777777777777777777777777777777778e-6 * t1597) * t138 + t154 * t1615 + t160 * t1579 + t148 * t1622 + t134 * t1628 + t141 * t1586 + t123 * t1579 + t126 * t1606
  t1636 = t1590 / 0.12e2 - t1597 / 0.288e3
  t1637 = t48 * t1636
  t1668 = (-0.63413107725000000000000000000000000000000000000000e-1 * t1637 + 0.10568851287500000000000000000000000000000000000000e-2 * t1590 - 0.44036880364583333333333333333333333333333333333333e-4 * t1597) * t114 + 0.14938339152281250000000000000000000000000000000000e1 * t1637 + t221 * t1615 + (-0.25278928416666666666666666666666666666666666666667e-3 * t1590 + 0.10532886840277777777777777777777777777777777777778e-4 * t1597) * t114 + t111 * t1615 + 0.13938308465540625000000000000000000000000000000000e-1 * t1583 + (0.83616006666666666666666666666666666666666666666667e-2 * t1590 - 0.34840002777777777777777777777777777777777777777778e-3 * t1597) * t87 + t175 * t1579 + (-0.73257564333333333333333333333333333333333333333333e-3 * t1590 + 0.30523985138888888888888888888888888888888888888889e-4 * t1597) * t108 + (0.99275455000000000000000000000000000000000000000000e-4 * t1590 - 0.41364772916666666666666666666666666666666666666667e-5 * t1597) * t151 + t172 * t1622 + 0.12082862679212500000000000000000000000000000000000e-1 * t1618 + 0.14063653755131250000000000000000000000000000000000e-1 * t1620 + t166 * t1628
  t1704 = t49 * t1636
  t1706 = t47 * t1636
  t1712 = -0.48005288013375000000000000000000000000000000000000e-3 * t1624 + (0.68511658000000000000000000000000000000000000000000e-4 * t1590 - 0.28546524166666666666666666666666666666666666666667e-5 * t1597) * t145 - 0.13022208355989583333333333333333333333333333333333e-1 * t1590 + (0.21050915400000000000000000000000000000000000000000e0 * t1637 - 0.35084859000000000000000000000000000000000000000000e-2 * t1590 + 0.14618691250000000000000000000000000000000000000000e-3 * t1597) * t108 + (-0.13663346550000000000000000000000000000000000000000e0 * t1637 + 0.22772244250000000000000000000000000000000000000000e-2 * t1590 - 0.94884351041666666666666666666666666666666666666667e-4 * t1597) * t87 + (0.67255459950000000000000000000000000000000000000000e-2 * t1637 - 0.11209243325000000000000000000000000000000000000000e-3 * t1590 + 0.46705180520833333333333333333333333333333333333333e-5 * t1597) * t145 + t213 * t1586 + (0.25448172900000000000000000000000000000000000000000e-1 * t1637 - 0.42413621500000000000000000000000000000000000000000e-3 * t1590 + 0.17672342291666666666666666666666666666666666666667e-4 * t1597) * t151 + t217 * t1622 + (-0.16264542600000000000000000000000000000000000000000e-6 * t1637 + 0.27107571000000000000000000000000000000000000000000e-8 * t1590 - 0.11294821250000000000000000000000000000000000000000e-9 * t1597) * t138 + t209 * t1628 + (0.28461750625000000000000000000000000000000000000000e0 * t1704 - 0.12197893125000000000000000000000000000000000000000e0 * t1706) * t87 - 0.55222473591250000000000000000000000000000000000000e0 * t1704 - 0.18458962865625000000000000000000000000000000000000e0 * t1706
  t1744 = t50 * t1636
  t1752 = t201 * t1579 + (0.50618258925000000000000000000000000000000000000000e-7 * t1637 - 0.84363764875000000000000000000000000000000000000000e-9 * t1590 + 0.35151568697916666666666666666666666666666666666667e-10 * t1597) * t131 + t205 * t1606 + (0.11058103490000000000000000000000000000000000000000e0 * t1704 - 0.47391872100000000000000000000000000000000000000000e-1 * t1706) * t114 + t193 * t1615 + (-0.32009475925000000000000000000000000000000000000000e0 * t1704 + 0.13718346825000000000000000000000000000000000000000e0 * t1706) * t108 + t183 * t1586 + (-0.13839204872500000000000000000000000000000000000000e-5 * t1704 + 0.59310878025000000000000000000000000000000000000000e-6 * t1706) * t151 + t187 * t1622 + (0.15963915642500000000000000000000000000000000000000e-6 * t1704 - 0.68416781325000000000000000000000000000000000000000e-7 * t1706) * t138 + t179 * t1628 + (0.36680677425000000000000000000000000000000000000000e-6 * t1704 - 0.15720290325000000000000000000000000000000000000000e-6 * t1706) * t145 + (-0.34813338210000000000000000000000000000000000000000e0 * t1744 + 0.23208892140000000000000000000000000000000000000000e0 * t1637 - 0.13814816750000000000000000000000000000000000000000e-2 * t1590 + 0.57561736458333333333333333333333333333333333333333e-4 * t1597) * t87 - 0.19753059979406250000000000000000000000000000000000e1 * t1744
  t1802 = t261 * t1579 + (-0.86419263875000000000000000000000000000000000000000e-7 * t1704 + 0.37036827375000000000000000000000000000000000000000e-7 * t1706) * t131 + t266 * t1606 + (-0.35310374032500000000000000000000000000000000000000e0 * t1744 + 0.23540249355000000000000000000000000000000000000000e0 * t1637 - 0.14012053187500000000000000000000000000000000000000e-2 * t1590 + 0.58383554947916666666666666666666666666666666666667e-4 * t1597) * t114 + t251 * t1615 + (-0.74219946412500000000000000000000000000000000000000e0 * t1744 + 0.49479964275000000000000000000000000000000000000000e0 * t1637 - 0.29452359687500000000000000000000000000000000000000e-2 * t1590 + 0.12271816536458333333333333333333333333333333333333e-3 * t1597) * t108 + (0.63881504268750000000000000000000000000000000000000e-5 * t1744 - 0.42587669512500000000000000000000000000000000000000e-5 * t1637 + 0.25349803281250000000000000000000000000000000000000e-7 * t1590 - 0.10562418033854166666666666666666666666666666666667e-8 * t1597) * t151 + t246 * t1622 + (-0.54523426387500000000000000000000000000000000000000e-6 * t1744 + 0.36348950925000000000000000000000000000000000000000e-6 * t1637 - 0.21636280312500000000000000000000000000000000000000e-8 * t1590 + 0.90151167968750000000000000000000000000000000000000e-10 * t1597) * t138 + t236 * t1628 + (-0.14832679010625000000000000000000000000000000000000e-5 * t1744 + 0.98884526737500000000000000000000000000000000000000e-6 * t1637 - 0.58859837343750000000000000000000000000000000000000e-8 * t1590 + 0.24524932226562500000000000000000000000000000000000e-9 * t1597) * t145 + t241 * t1586 + (0.33479475435000000000000000000000000000000000000000e-6 * t1744 - 0.22319650290000000000000000000000000000000000000000e-6 * t1637 + 0.13285506125000000000000000000000000000000000000000e-8 * t1590 - 0.55356275520833333333333333333333333333333333333333e-10 * t1597) * t131 + t231 * t1606
  t1804 = t53 * t1636
  t1840 = t97 * t1636
  t1849 = t303 * t1615 + (0.14709437386875000000000000000000000000000000000000e-4 * t1804 - 0.13372215806250000000000000000000000000000000000000e-4 * t1704 + 0.22287026343750000000000000000000000000000000000000e-5 * t1706) * t108 + 0.48014796319875000000000000000000000000000000000000e0 * t1804 + (-0.82936291977000000000000000000000000000000000000000e0 * t1804 + 0.75396629070000000000000000000000000000000000000000e0 * t1704 - 0.12566104845000000000000000000000000000000000000000e0 * t1706) * t87 + t226 * t1579 + (-0.36070052807250000000000000000000000000000000000000e-5 * t1804 + 0.32790957097500000000000000000000000000000000000000e-5 * t1704 - 0.54651595162500000000000000000000000000000000000000e-6 * t1706) * t151 + t298 * t1622 + (-0.22965556209750000000000000000000000000000000000000e-5 * t1804 + 0.20877778372500000000000000000000000000000000000000e-5 * t1704 - 0.34796297287500000000000000000000000000000000000000e-6 * t1706) * t114 + (0.20477405977875000000000000000000000000000000000000e-5 * t1804 - 0.18615823616250000000000000000000000000000000000000e-5 * t1704 + 0.31026372693750000000000000000000000000000000000000e-6 * t1706) * t145 + t293 * t1586 + (0.60159545176500000000000000000000000000000000000000e-6 * t1804 - 0.54690495615000000000000000000000000000000000000000e-6 * t1704 + 0.91150826025000000000000000000000000000000000000000e-7 * t1706) * t138 + t288 * t1628 + (-0.51900225877500000000000000000000000000000000000000e-4 * t1840 + 0.59884876012500000000000000000000000000000000000000e-4 * t1744 - 0.16332238912500000000000000000000000000000000000000e-4 * t1637 + 0.50408144791666666666666666666666666666666666666667e-7 * t1590 - 0.21003393663194444444444444444444444444444444444445e-8 * t1597) * t108 + 0.74218070864437500000000000000000000000000000000000e0 * t1840
  t1905 = (0.17655307926506250000000000000000000000000000000000e1 * t1840 - 0.20371509145968750000000000000000000000000000000000e1 * t1744 + 0.55558661307187500000000000000000000000000000000000e0 * t1637 - 0.17147734971354166666666666666666666666666666666667e-2 * t1590 + 0.71448895713975694444444444444444444444444444444446e-4 * t1597) * t87 + t278 * t1579 + (-0.59909240506500000000000000000000000000000000000000e-6 * t1804 + 0.54462945915000000000000000000000000000000000000000e-6 * t1704 - 0.90771576525000000000000000000000000000000000000000e-7 * t1706) * t131 + t283 * t1606 + t332 * t1622 + (0.94955002079437500000000000000000000000000000000000e-5 * t1840 - 0.10956346393781250000000000000000000000000000000000e-4 * t1744 + 0.29880944710312500000000000000000000000000000000000e-5 * t1637 - 0.92225137994791666666666666666666666666666666666667e-8 * t1590 + 0.38427140831163194444444444444444444444444444444445e-9 * t1597) * t114 + t338 * t1615 + (-0.63462434285250000000000000000000000000000000000000e-5 * t1840 + 0.73225885713750000000000000000000000000000000000000e-5 * t1744 - 0.19970696103750000000000000000000000000000000000000e-5 * t1637 + 0.61637950937500000000000000000000000000000000000000e-8 * t1590 - 0.25682479557291666666666666666666666666666666666667e-9 * t1597) * t145 + t326 * t1586 + (0.10408937470181250000000000000000000000000000000000e-4 * t1840 - 0.12010312465593750000000000000000000000000000000000e-4 * t1744 + 0.32755397633437500000000000000000000000000000000000e-5 * t1637 - 0.10109690627604166666666666666666666666666666666667e-7 * t1590 + 0.42123710948350694444444444444444444444444444444446e-9 * t1597) * t151 + (-0.14531234755537500000000000000000000000000000000000e-5 * t1840 + 0.16766809333312500000000000000000000000000000000000e-5 * t1744 - 0.45727661818125000000000000000000000000000000000000e-6 * t1637 + 0.14113475869791666666666666666666666666666666666667e-8 * t1590 - 0.58806149457465277777777777777777777777777777777779e-10 * t1597) * t138 + t320 * t1628 + (0.16676513484881250000000000000000000000000000000000e-5 * t1840 - 0.19242130944093750000000000000000000000000000000000e-5 * t1744 + 0.52478538938437500000000000000000000000000000000000e-6 * t1637 - 0.16197079919270833333333333333333333333333333333333e-8 * t1590 + 0.67487832996961805555555555555555555555555555555554e-10 * t1597) * t131 + t314 * t1606
  t1935 = 0.54259201483289930555555555555555555555555555555554e-3 * t1597 + 0.3e1 * t1094 * t1579 - 0.10531230900000000000000000000000000000000000000000e-2 * t1706 * t145 + 0.54871817100000000000000000000000000000000000000000e-2 * t1706 * t151 + 0.87975912300000000000000000000000000000000000000000e-2 * t1706 * t114 - 0.45031090800000000000000000000000000000000000000000e-1 * t1706 * t108 + 0.3e1 * t1072 * t1579 - 0.13039303800000000000000000000000000000000000000000e0 * t1706 * t87 + 0.3e1 * t1077 * t1579 - 0.66904397100000000000000000000000000000000000000000e-8 * t1706 * t131 + 0.20069406570000000000000000000000000000000000000000e-7 * t1706 * t138 + 0.3e1 * t1082 * t1579 + 0.3e1 * t1085 * t1579 + 0.3e1 * t1088 * t1579 + 0.3e1 * t1091 * t1579
  t1942 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (t1633 + t1668 + t1712 + t1752 + t1802 + t1849 + t1905 + t1935))
  vsigma_0_ = t6 * t1942
  vsigma_1_ = 0.0e0
  t1944 = 0.5e1 / 0.72e2 * t33 * t360
  t1945 = f.my_piecewise3(t382, -t1944, 0)
  t1953 = f.my_piecewise3(t382, 0, -t1944)
  t1963 = f.my_piecewise3(t381, -0.12e2 * t1160 * t1945 + 0.6e1 * t388 * t1945 + 0.3e1 * t390 * t1945, 0.6e1 * t1164 * t393 * t1953 + t1171 * (0.3e1 * t1172 * t1953 + 0.3e1 * t1175 * t1953))
  t1970 = t698 * s2 / t357 / t1194 / r1 * t1200
  t1972 = t406 * t1963
  t1975 = 0.15e2 / 0.2e1 * t1972 - 0.3e1 / 0.2e1 * t1963
  t1978 = t33 * t360 * t365
  t1981 = t1978 / 0.12e2 - t1970 / 0.288e3
  t1982 = t416 * t1981
  t1984 = t369 * t1981
  t1993 = t370 * t1981
  t1999 = t412 * t1963
  t2001 = t407 * t1963
  t2005 = 0.3003e4 / 0.16e2 * t1999 - 0.3465e4 / 0.16e2 * t2001 + 0.945e3 / 0.16e2 * t1972 - 0.35e2 / 0.16e2 * t1963
  t2012 = t408 * t1963
  t2014 = t410 * t1963
  t2016 = t404 * t1963
  t2018 = 0.693e3 / 0.8e1 * t2012 - 0.315e3 / 0.4e1 * t2014 + 0.105e3 / 0.8e1 * t2016
  t2028 = 0.315e3 / 0.8e1 * t2001 - 0.105e3 / 0.4e1 * t1972 + 0.15e2 / 0.8e1 * t1963
  t2037 = 0.35e2 / 0.2e1 * t2014 - 0.15e2 / 0.2e1 * t2016
  t2039 = -0.43736526393718750000000000000000000000000000000000e-2 * t1963 + 0.54259201483289930555555555555555555555555555555554e-3 * t1970 + t529 * t1975 + (-0.32009475925000000000000000000000000000000000000000e0 * t1982 + 0.13718346825000000000000000000000000000000000000000e0 * t1984) * t445 + (0.28461750625000000000000000000000000000000000000000e0 * t1982 - 0.12197893125000000000000000000000000000000000000000e0 * t1984) * t404 + t537 * t1963 + (0.50618258925000000000000000000000000000000000000000e-7 * t1993 - 0.84363764875000000000000000000000000000000000000000e-9 * t1978 + 0.35151568697916666666666666666666666666666666666667e-10 * t1970) * t474 + t541 * t2005 + (-0.16264542600000000000000000000000000000000000000000e-6 * t1993 + 0.27107571000000000000000000000000000000000000000000e-8 * t1978 - 0.11294821250000000000000000000000000000000000000000e-9 * t1970) * t481 + t545 * t2018 + (0.67255459950000000000000000000000000000000000000000e-2 * t1993 - 0.11209243325000000000000000000000000000000000000000e-3 * t1978 + 0.46705180520833333333333333333333333333333333333333e-5 * t1970) * t428 + t549 * t2028 + (0.25448172900000000000000000000000000000000000000000e-1 * t1993 - 0.42413621500000000000000000000000000000000000000000e-3 * t1978 + 0.17672342291666666666666666666666666666666666666667e-4 * t1970) * t434 + t453 * t2037
  t2072 = (-0.63413107725000000000000000000000000000000000000000e-1 * t1993 + 0.10568851287500000000000000000000000000000000000000e-2 * t1978 - 0.44036880364583333333333333333333333333333333333333e-4 * t1970) * t440 + t457 * t1975 + (0.21050915400000000000000000000000000000000000000000e0 * t1993 - 0.35084859000000000000000000000000000000000000000000e-2 * t1978 + 0.14618691250000000000000000000000000000000000000000e-3 * t1970) * t445 + (-0.13663346550000000000000000000000000000000000000000e0 * t1993 + 0.22772244250000000000000000000000000000000000000000e-2 * t1978 - 0.94884351041666666666666666666666666666666666666667e-4 * t1970) * t404 + t465 * t1963 + t468 * t2005 + t477 * t2018 + t484 * t2028 + t487 * t2037 + t490 * t1975 + t496 * t1963 + (-0.78362630250000000000000000000000000000000000000000e-6 * t1978 + 0.32651095937500000000000000000000000000000000000000e-7 * t1970) * t474 + t499 * t2005 + (-0.42850389666666666666666666666666666666666666666667e-5 * t1978 + 0.17854329027777777777777777777777777777777777777778e-6 * t1970) * t481
  t2099 = t551 * t1981
  t2101 = t417 * t1981
  t2117 = t502 * t2018 + (0.68511658000000000000000000000000000000000000000000e-4 * t1978 - 0.28546524166666666666666666666666666666666666666667e-5 * t1970) * t428 + t424 * t2028 + (0.99275455000000000000000000000000000000000000000000e-4 * t1978 - 0.41364772916666666666666666666666666666666666666667e-5 * t1970) * t434 + t431 * t2037 + (-0.25278928416666666666666666666666666666666666666667e-3 * t1978 + 0.10532886840277777777777777777777777777777777777778e-4 * t1970) * t440 + t437 * t1975 + (-0.73257564333333333333333333333333333333333333333333e-3 * t1978 + 0.30523985138888888888888888888888888888888888888889e-4 * t1970) * t445 + (0.83616006666666666666666666666666666666666666666667e-2 * t1978 - 0.34840002777777777777777777777777777777777777777778e-3 * t1970) * t404 + t448 * t1963 + (0.16676513484881250000000000000000000000000000000000e-5 * t2099 - 0.19242130944093750000000000000000000000000000000000e-5 * t2101 + 0.52478538938437500000000000000000000000000000000000e-6 * t1993 - 0.16197079919270833333333333333333333333333333333333e-8 * t1978 + 0.67487832996961805555555555555555555555555555555554e-10 * t1970) * t474 + 0.74218070864437500000000000000000000000000000000000e0 * t2099 + t640 * t2005 + (-0.14531234755537500000000000000000000000000000000000e-5 * t2099 + 0.16766809333312500000000000000000000000000000000000e-5 * t2101 - 0.45727661818125000000000000000000000000000000000000e-6 * t1993 + 0.14113475869791666666666666666666666666666666666667e-8 * t1978 - 0.58806149457465277777777777777777777777777777777779e-10 * t1970) * t481
  t2158 = t420 * t1981
  t2171 = t646 * t2018 + (-0.63462434285250000000000000000000000000000000000000e-5 * t2099 + 0.73225885713750000000000000000000000000000000000000e-5 * t2101 - 0.19970696103750000000000000000000000000000000000000e-5 * t1993 + 0.61637950937500000000000000000000000000000000000000e-8 * t1978 - 0.25682479557291666666666666666666666666666666666667e-9 * t1970) * t428 + t652 * t2028 + (0.10408937470181250000000000000000000000000000000000e-4 * t2099 - 0.12010312465593750000000000000000000000000000000000e-4 * t2101 + 0.32755397633437500000000000000000000000000000000000e-5 * t1993 - 0.10109690627604166666666666666666666666666666666667e-7 * t1978 + 0.42123710948350694444444444444444444444444444444446e-9 * t1970) * t434 + t658 * t2037 + (0.94955002079437500000000000000000000000000000000000e-5 * t2099 - 0.10956346393781250000000000000000000000000000000000e-4 * t2101 + 0.29880944710312500000000000000000000000000000000000e-5 * t1993 - 0.92225137994791666666666666666666666666666666666667e-8 * t1978 + 0.38427140831163194444444444444444444444444444444445e-9 * t1970) * t440 + t602 * t1975 + (-0.51900225877500000000000000000000000000000000000000e-4 * t2099 + 0.59884876012500000000000000000000000000000000000000e-4 * t2101 - 0.16332238912500000000000000000000000000000000000000e-4 * t1993 + 0.50408144791666666666666666666666666666666666666667e-7 * t1978 - 0.21003393663194444444444444444444444444444444444445e-8 * t1970) * t445 + (0.17655307926506250000000000000000000000000000000000e1 * t2099 - 0.20371509145968750000000000000000000000000000000000e1 * t2101 + 0.55558661307187500000000000000000000000000000000000e0 * t1993 - 0.17147734971354166666666666666666666666666666666667e-2 * t1978 + 0.71448895713975694444444444444444444444444444444446e-4 * t1970) * t404 + t614 * t1963 + (-0.59909240506500000000000000000000000000000000000000e-6 * t2158 + 0.54462945915000000000000000000000000000000000000000e-6 * t1982 - 0.90771576525000000000000000000000000000000000000000e-7 * t1984) * t474 + 0.48014796319875000000000000000000000000000000000000e0 * t2158 + t619 * t2005 + (0.60159545176500000000000000000000000000000000000000e-6 * t2158 - 0.54690495615000000000000000000000000000000000000000e-6 * t1982 + 0.91150826025000000000000000000000000000000000000000e-7 * t1984) * t481
  t2218 = t624 * t2018 + (0.20477405977875000000000000000000000000000000000000e-5 * t2158 - 0.18615823616250000000000000000000000000000000000000e-5 * t1982 + 0.31026372693750000000000000000000000000000000000000e-6 * t1984) * t428 + t629 * t2028 + (-0.36070052807250000000000000000000000000000000000000e-5 * t2158 + 0.32790957097500000000000000000000000000000000000000e-5 * t1982 - 0.54651595162500000000000000000000000000000000000000e-6 * t1984) * t434 + t634 * t2037 + (-0.22965556209750000000000000000000000000000000000000e-5 * t2158 + 0.20877778372500000000000000000000000000000000000000e-5 * t1982 - 0.34796297287500000000000000000000000000000000000000e-6 * t1984) * t440 + t555 * t1975 + (0.14709437386875000000000000000000000000000000000000e-4 * t2158 - 0.13372215806250000000000000000000000000000000000000e-4 * t1982 + 0.22287026343750000000000000000000000000000000000000e-5 * t1984) * t445 + (-0.82936291977000000000000000000000000000000000000000e0 * t2158 + 0.75396629070000000000000000000000000000000000000000e0 * t1982 - 0.12566104845000000000000000000000000000000000000000e0 * t1984) * t404 + t565 * t1963 + (0.33479475435000000000000000000000000000000000000000e-6 * t2101 - 0.22319650290000000000000000000000000000000000000000e-6 * t1993 + 0.13285506125000000000000000000000000000000000000000e-8 * t1978 - 0.55356275520833333333333333333333333333333333333333e-10 * t1970) * t474 + t570 * t2005 + (-0.54523426387500000000000000000000000000000000000000e-6 * t2101 + 0.36348950925000000000000000000000000000000000000000e-6 * t1993 - 0.21636280312500000000000000000000000000000000000000e-8 * t1978 + 0.90151167968750000000000000000000000000000000000000e-10 * t1970) * t481 + t575 * t2018
  t2261 = (-0.14832679010625000000000000000000000000000000000000e-5 * t2101 + 0.98884526737500000000000000000000000000000000000000e-6 * t1993 - 0.58859837343750000000000000000000000000000000000000e-8 * t1978 + 0.24524932226562500000000000000000000000000000000000e-9 * t1970) * t428 + t580 * t2028 + (0.63881504268750000000000000000000000000000000000000e-5 * t2101 - 0.42587669512500000000000000000000000000000000000000e-5 * t1993 + 0.25349803281250000000000000000000000000000000000000e-7 * t1978 - 0.10562418033854166666666666666666666666666666666667e-8 * t1970) * t434 + t585 * t2037 + (-0.35310374032500000000000000000000000000000000000000e0 * t2101 + 0.23540249355000000000000000000000000000000000000000e0 * t1993 - 0.14012053187500000000000000000000000000000000000000e-2 * t1978 + 0.58383554947916666666666666666666666666666666666667e-4 * t1970) * t440 + t590 * t1975 + (-0.74219946412500000000000000000000000000000000000000e0 * t2101 + 0.49479964275000000000000000000000000000000000000000e0 * t1993 - 0.29452359687500000000000000000000000000000000000000e-2 * t1978 + 0.12271816536458333333333333333333333333333333333333e-3 * t1970) * t445 + (-0.34813338210000000000000000000000000000000000000000e0 * t2101 + 0.23208892140000000000000000000000000000000000000000e0 * t1993 - 0.13814816750000000000000000000000000000000000000000e-2 * t1978 + 0.57561736458333333333333333333333333333333333333333e-4 * t1970) * t404 - 0.19753059979406250000000000000000000000000000000000e1 * t2101 + 0.14938339152281250000000000000000000000000000000000e1 * t1993 + t507 * t1963 + (-0.86419263875000000000000000000000000000000000000000e-7 * t1982 + 0.37036827375000000000000000000000000000000000000000e-7 * t1984) * t474 - 0.55222473591250000000000000000000000000000000000000e0 * t1982 - 0.18458962865625000000000000000000000000000000000000e0 * t1984
  t2289 = t511 * t2005 + 0.13814974360687500000000000000000000000000000000000e-3 * t1999 - 0.47294155178156250000000000000000000000000000000000e-2 * t2001 + 0.13938308465540625000000000000000000000000000000000e-1 * t1972 + (0.15963915642500000000000000000000000000000000000000e-6 * t1982 - 0.68416781325000000000000000000000000000000000000000e-7 * t1984) * t481 + t515 * t2018 - 0.48005288013375000000000000000000000000000000000000e-3 * t2012 + 0.12082862679212500000000000000000000000000000000000e-1 * t2014 + 0.14063653755131250000000000000000000000000000000000e-1 * t2016 + (0.36680677425000000000000000000000000000000000000000e-6 * t1982 - 0.15720290325000000000000000000000000000000000000000e-6 * t1984) * t428 + t521 * t2028 + (-0.13839204872500000000000000000000000000000000000000e-5 * t1982 + 0.59310878025000000000000000000000000000000000000000e-6 * t1984) * t434 + t525 * t2037 + (0.11058103490000000000000000000000000000000000000000e0 * t1982 - 0.47391872100000000000000000000000000000000000000000e-1 * t1984) * t440
  t2319 = -0.13022208355989583333333333333333333333333333333333e-1 * t1978 + 0.3e1 * t1544 * t1963 + 0.3e1 * t1541 * t1963 + 0.3e1 * t1538 * t1963 + 0.3e1 * t1535 * t1963 + 0.3e1 * t1532 * t1963 - 0.66904397100000000000000000000000000000000000000000e-8 * t1984 * t474 + 0.20069406570000000000000000000000000000000000000000e-7 * t1984 * t481 - 0.10531230900000000000000000000000000000000000000000e-2 * t1984 * t428 + 0.54871817100000000000000000000000000000000000000000e-2 * t1984 * t434 + 0.87975912300000000000000000000000000000000000000000e-2 * t1984 * t440 - 0.45031090800000000000000000000000000000000000000000e-1 * t1984 * t445 + 0.3e1 * t1519 * t1963 - 0.13039303800000000000000000000000000000000000000000e0 * t1984 * t404 + 0.3e1 * t1512 * t1963
  t2326 = f.my_piecewise3(t348, 0, -0.3e1 / 0.8e1 * t5 * t355 * (t2039 + t2072 + t2117 + t2171 + t2218 + t2261 + t2289 + t2319))
  vsigma_2_ = t6 * t2326
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t2329 = 0.5e1 / 0.9e1 * t57 * t28 * t32
  t2330 = f.my_piecewise3(t65, t2329, 0)
  t2338 = f.my_piecewise3(t65, 0, t2329)
  t2348 = f.my_piecewise3(t64, 0.6e1 * t71 * t2330 - 0.12e2 * t723 * t2330 + 0.3e1 * t73 * t2330, 0.6e1 * t727 * t76 * t2338 + t734 * (0.3e1 * t735 * t2338 + 0.3e1 * t738 * t2338))
  t2350 = t88 * t2348
  t2353 = 0.15e2 / 0.2e1 * t2350 - 0.3e1 / 0.2e1 * t2348
  t2357 = t101 * t2348
  t2359 = t90 * t2348
  t2363 = 0.3003e4 / 0.16e2 * t2357 - 0.3465e4 / 0.16e2 * t2359 + 0.945e3 / 0.16e2 * t2350 - 0.35e2 / 0.16e2 * t2348
  t2367 = t94 * t2348
  t2369 = t89 * t2348
  t2371 = t87 * t2348
  t2373 = 0.693e3 / 0.8e1 * t2367 - 0.315e3 / 0.4e1 * t2369 + 0.105e3 / 0.8e1 * t2371
  t2381 = 0.315e3 / 0.8e1 * t2359 - 0.105e3 / 0.4e1 * t2350 + 0.15e2 / 0.8e1 * t2348
  t2385 = 0.35e2 / 0.2e1 * t2369 - 0.15e2 / 0.2e1 * t2371
  t2388 = -0.43736526393718750000000000000000000000000000000000e-2 * t2348 + t111 * t2353 + 0.13938308465540625000000000000000000000000000000000e-1 * t2350 + t160 * t2348 + t163 * t2363 + 0.13814974360687500000000000000000000000000000000000e-3 * t2357 - 0.47294155178156250000000000000000000000000000000000e-2 * t2359 + t288 * t2373 - 0.48005288013375000000000000000000000000000000000000e-3 * t2367 + 0.12082862679212500000000000000000000000000000000000e-1 * t2369 + 0.14063653755131250000000000000000000000000000000000e-1 * t2371 + t293 * t2381 + t298 * t2385 + t303 * t2353
  t2403 = t179 * t2373 + t183 * t2381 + t187 * t2385 + t193 * t2353 + t201 * t2348 + t205 * t2363 + t226 * t2348 + t231 * t2363 + t261 * t2348 + t251 * t2353 + t236 * t2373 + t266 * t2363 + t241 * t2381 + t246 * t2385
  t2419 = t123 * t2348 + t126 * t2363 + t134 * t2373 + t141 * t2381 + t166 * t2373 + t169 * t2381 + t172 * t2385 + t175 * t2348 + t209 * t2373 + t213 * t2381 + t217 * t2385 + t221 * t2353 + t314 * t2363 + t320 * t2373
  t2441 = 0.3e1 * t1072 * t2348 + 0.3e1 * t1077 * t2348 + 0.3e1 * t1082 * t2348 + 0.3e1 * t1085 * t2348 + 0.3e1 * t1088 * t2348 + 0.3e1 * t1091 * t2348 + 0.3e1 * t1094 * t2348 + t148 * t2385 + t154 * t2353 + t278 * t2348 + t338 * t2353 + t283 * t2363 + t326 * t2381 + t332 * t2385
  t2447 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (t2388 + t2403 + t2419 + t2441))
  vtau_0_ = t6 * t2447
  t2450 = 0.5e1 / 0.9e1 * t374 * t28 * t32
  t2451 = f.my_piecewise3(t382, t2450, 0)
  t2459 = f.my_piecewise3(t382, 0, t2450)
  t2469 = f.my_piecewise3(t381, -0.12e2 * t1160 * t2451 + 0.6e1 * t388 * t2451 + 0.3e1 * t390 * t2451, 0.6e1 * t1164 * t393 * t2459 + t1171 * (0.3e1 * t1172 * t2459 + 0.3e1 * t1175 * t2459))
  t2470 = t406 * t2469
  t2472 = t407 * t2469
  t2476 = 0.315e3 / 0.8e1 * t2472 - 0.105e3 / 0.4e1 * t2470 + 0.15e2 / 0.8e1 * t2469
  t2479 = t408 * t2469
  t2481 = t410 * t2469
  t2483 = t404 * t2469
  t2485 = 0.693e3 / 0.8e1 * t2479 - 0.315e3 / 0.4e1 * t2481 + 0.105e3 / 0.8e1 * t2483
  t2489 = t412 * t2469
  t2494 = 0.3003e4 / 0.16e2 * t2489 - 0.3465e4 / 0.16e2 * t2472 + 0.945e3 / 0.16e2 * t2470 - 0.35e2 / 0.16e2 * t2469
  t2499 = 0.35e2 / 0.2e1 * t2481 - 0.15e2 / 0.2e1 * t2483
  t2503 = 0.15e2 / 0.2e1 * t2470 - 0.3e1 / 0.2e1 * t2469
  t2509 = 0.13938308465540625000000000000000000000000000000000e-1 * t2470 + t424 * t2476 - 0.47294155178156250000000000000000000000000000000000e-2 * t2472 + t502 * t2485 - 0.48005288013375000000000000000000000000000000000000e-3 * t2479 + t496 * t2469 + t499 * t2494 + 0.13814974360687500000000000000000000000000000000000e-3 * t2489 + t487 * t2499 + t490 * t2503 + t484 * t2476 + t468 * t2494 + t477 * t2485 + t457 * t2503
  t2524 = t465 * t2469 + t507 * t2469 + t537 * t2469 + t521 * t2476 + t549 * t2476 + t515 * t2485 + t545 * t2485 + t511 * t2494 + t541 * t2494 + t453 * t2499 + t525 * t2499 + t585 * t2499 + t529 * t2503 + t590 * t2503
  t2540 = -0.43736526393718750000000000000000000000000000000000e-2 * t2469 + t575 * t2485 + t580 * t2476 + t565 * t2469 + t570 * t2494 + t634 * t2499 + t555 * t2503 + t629 * t2476 + t624 * t2485 + t602 * t2503 + t614 * t2469 + t619 * t2494 + t658 * t2499 + t646 * t2485
  t2562 = t652 * t2476 + t640 * t2494 + t448 * t2469 + t431 * t2499 + 0.12082862679212500000000000000000000000000000000000e-1 * t2481 + 0.14063653755131250000000000000000000000000000000000e-1 * t2483 + t437 * t2503 + 0.3e1 * t1512 * t2469 + 0.3e1 * t1532 * t2469 + 0.3e1 * t1541 * t2469 + 0.3e1 * t1538 * t2469 + 0.3e1 * t1544 * t2469 + 0.3e1 * t1535 * t2469 + 0.3e1 * t1519 * t2469
  t2568 = f.my_piecewise3(t348, 0, -0.3e1 / 0.8e1 * t5 * t355 * (t2509 + t2524 + t2540 + t2562))
  vtau_1_ = t6 * t2568
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  mbeef_n = 8

  mbeef_coefs = [None, np.array([np.nan, 1.1802933, 0.0085302786, -0.102312143, 0.068575749, -0.00661294786, -0.0284176163, 0.00554283363, 0.00395434277], dtype=np.float64), np.array([np.nan, -0.00198479086, 0.100339208, -0.043464346, -0.0182177954, 0.0162638575, -0.00884148272, -0.00957417512, 0.00940675747], dtype=np.float64), np.array([np.nan, 0.00637590839, -0.00879090772, -0.0150103636, 0.0280678872, -0.0182911291, -0.0188495102, 1.69805915e-07, -2.7652468e-07], dtype=np.float64), np.array([np.nan, 0.00144642135, -0.00303347141, 0.00293253041, -0.00845508103, 0.00631891628, -0.00896771404, -2.65114646e-08, 5.05920757e-08], dtype=np.float64), np.array([np.nan, 0.000665511484, 0.00119130546, 0.00182906057, 0.00339308972, -7.90811707e-08, 1.62238741e-07, -4.16393106e-08, 5.54588743e-08], dtype=np.float64), np.array([np.nan, -0.000116063796, 0.000822139896, -0.00035104103, 0.000896739466, 2.09603871e-08, -3.76702959e-08, 2.36391411e-08, -3.38128188e-08], dtype=np.float64), np.array([np.nan, -5.54173599e-06, -5.14204676e-05, 6.68980219e-09, -2.16860568e-08, 9.12223751e-09, -1.38472194e-08, 6.94482484e-09, -7.74224962e-09], dtype=np.float64), np.array([np.nan, 7.3606257e-07, -9.40351563e-06, -2.23014657e-09, 6.74910119e-09, -4.93824365e-09, 8.50272392e-09, -6.91592964e-09, 8.88525527e-09], dtype=np.float64)]

  mbeef_k = 6.5124

  mbeef_xj0 = lambda a: -(1 - a ** 2) ** 3 / (1 + a ** 3 * (1 + a ** 3))

  mbeef_xi = lambda p: 2 * p / (mbeef_k + p) - 1

  mbeef_xj = lambda a: apply_piecewise(a, lambda _aval: _aval >= 10000.0, lambda _aval: 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 4 - 1 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 3 - 3 * (1.0 / jnp.maximum(_aval, 10000.0)) ** 2 + 1, lambda _aval: mbeef_xj0(jnp.minimum(_aval, 10000.0)))

  mbeef_expansion = lambda x, t: jnp.sum(jnp.array([jnp.sum(jnp.array([+mbeef_coefs[i][j] * P(j - 1, mbeef_xi(X2S ** 2 * x ** 2)) * P(i - 1, mbeef_xj((t - x ** 2 / 8) / K_FACTOR_C)) for i in range(1, mbeef_n + 1)]), axis=0) for j in range(1, mbeef_n + 1)]), axis=0)

  mbeef_f = lambda x, u, t: mbeef_expansion(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, mbeef_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** 2
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = 0.1e1 / t23
  t25 = t20 * t24
  t26 = t25 * s0
  t27 = 2 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t29 = r0 ** 2
  t30 = t18 ** 2
  t32 = 0.1e1 / t30 / t29
  t33 = t28 * t32
  t34 = s0 * t28
  t35 = t34 * t32
  t38 = 0.65124e1 + t25 * t35 / 0.24e2
  t39 = 0.1e1 / t38
  t40 = t33 * t39
  t41 = t26 * t40
  t43 = t41 / 0.12e2 - 0.1e1
  t44 = t43 ** 2
  t46 = t44 ** 2
  t47 = t46 * t44
  t50 = t44 * t43
  t52 = tau0 * t28
  t54 = 0.1e1 / t30 / r0
  t60 = 0.5e1 / 0.9e1 * (t52 * t54 - t35 / 0.8e1) * t20 * t24
  t61 = 0.1e5 <= t60
  t62 = 0.1e5 < t60
  t63 = f.my_piecewise3(t62, t60, 0.1e5)
  t64 = t63 ** 2
  t68 = 0.1e1 / t64 / t63
  t69 = t64 ** 2
  t70 = 0.1e1 / t69
  t73 = f.my_piecewise3(t62, 0.1e5, t60)
  t74 = t73 ** 2
  t75 = 0.1e1 - t74
  t76 = t75 ** 2
  t77 = t76 * t75
  t78 = t74 * t73
  t79 = 0.1e1 + t78
  t81 = t78 * t79 + 0.1e1
  t82 = 0.1e1 / t81
  t84 = f.my_piecewise3(t61, 0.1e1 - 0.3e1 / t64 - t68 + 0.3e1 * t70, -t77 * t82)
  t85 = t84 ** 2
  t87 = t46 * t50
  t89 = t46 * t43
  t92 = t85 * t84
  t93 = t85 ** 2
  t94 = t93 * t92
  t96 = t93 * t84
  t99 = t93 * t85
  t106 = -0.10904685277500000000000000000000000000000000000000e-6 * t89 + 0.12116316975000000000000000000000000000000000000000e-6 * t50 - 0.21636280312500000000000000000000000000000000000000e-8 * t41 + 0.25963536375000000000000000000000000000000000000000e-7
  t110 = -0.5e1 / 0.16e2 + 0.231e3 / 0.16e2 * t99 - 0.315e3 / 0.16e2 * t93 + 0.105e3 / 0.16e2 * t85
  t115 = -0.29665358021250000000000000000000000000000000000000e-6 * t89 + 0.32961508912500000000000000000000000000000000000000e-6 * t50 - 0.58859837343750000000000000000000000000000000000000e-8 * t41 + 0.70631804812500000000000000000000000000000000000000e-7
  t119 = 0.63e2 / 0.8e1 * t96 - 0.35e2 / 0.4e1 * t92 + 0.15e2 / 0.8e1 * t84
  t121 = -0.92294814328125000000000000000000000000000000000000e-1 * t44 + 0.80024660533125000000000000000000000000000000000000e-1 * t47 - 0.13805618397812500000000000000000000000000000000000e0 * t46 + 0.49794463840937500000000000000000000000000000000000e0 * t50 + 0.70318268775656250000000000000000000000000000000000e-2 * t85 + 0.10602581552062500000000000000000000000000000000000e0 * t87 - 0.39506119958812500000000000000000000000000000000000e0 * t89 - 0.43736526393718750000000000000000000000000000000000e-2 * t84 + 0.19735677658125000000000000000000000000000000000000e-4 * t94 - 0.94588310356312500000000000000000000000000000000000e-3 * t96 + 0.46461028218468750000000000000000000000000000000000e-2 * t92 - 0.80008813355625000000000000000000000000000000000000e-4 * t99 + 0.30207156698031250000000000000000000000000000000000e-2 * t93 - 0.13022208355989583333333333333333333333333333333333e-1 * t41 + t106 * t110 + t115 * t119
  t125 = 0.12776300853750000000000000000000000000000000000000e-5 * t89 - 0.14195889837500000000000000000000000000000000000000e-5 * t50 + 0.25349803281250000000000000000000000000000000000000e-7 * t41 - 0.30419763937500000000000000000000000000000000000000e-6
  t128 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t93 - 0.15e2 / 0.4e1 * t85
  t133 = -0.70620748065000000000000000000000000000000000000000e-1 * t89 + 0.78467497850000000000000000000000000000000000000000e-1 * t50 - 0.14012053187500000000000000000000000000000000000000e-2 * t41 + 0.16814463825000000000000000000000000000000000000000e-1
  t136 = 0.5e1 / 0.2e1 * t92 - 0.3e1 / 0.2e1 * t84
  t141 = -0.14843989282500000000000000000000000000000000000000e0 * t89 + 0.16493321425000000000000000000000000000000000000000e0 * t50 - 0.29452359687500000000000000000000000000000000000000e-2 * t41 + 0.35342831625000000000000000000000000000000000000000e-1
  t143 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t85
  t149 = 0.25221868466437500000000000000000000000000000000000e0 * t87 - 0.40743018291937500000000000000000000000000000000000e0 * t89 + 0.18519553769062500000000000000000000000000000000000e0 * t50 - 0.17147734971354166666666666666666666666666666666667e-2 * t41 + 0.20577281965625000000000000000000000000000000000000e-1
  t154 = 0.21612280125000000000000000000000000000000000000000e-8 - 0.99848734177500000000000000000000000000000000000000e-7 * t47 + 0.13615736478750000000000000000000000000000000000000e-6 * t46 - 0.45385788262500000000000000000000000000000000000000e-7 * t44
  t159 = 0.429e3 / 0.16e2 * t94 - 0.693e3 / 0.16e2 * t96 + 0.315e3 / 0.16e2 * t92 - 0.35e2 / 0.16e2 * t84
  t164 = -0.21702577625000000000000000000000000000000000000000e-8 + 0.10026590862750000000000000000000000000000000000000e-6 * t47 - 0.13672623903750000000000000000000000000000000000000e-6 * t46 + 0.45575413012500000000000000000000000000000000000000e-7 * t44
  t169 = -0.73872315937500000000000000000000000000000000000000e-8 + 0.34129009963125000000000000000000000000000000000000e-6 * t47 - 0.46539559040625000000000000000000000000000000000000e-6 * t46 + 0.15513186346875000000000000000000000000000000000000e-6 * t44
  t174 = 0.13012284562500000000000000000000000000000000000000e-7 - 0.60116754678750000000000000000000000000000000000000e-6 * t47 + 0.81977392743750000000000000000000000000000000000000e-6 * t46 - 0.27325797581250000000000000000000000000000000000000e-6 * t44
  t179 = 0.82848326875000000000000000000000000000000000000000e-8 - 0.38275927016250000000000000000000000000000000000000e-6 * t47 + 0.52194445931250000000000000000000000000000000000000e-6 * t46 - 0.17398148643750000000000000000000000000000000000000e-6 * t44
  t184 = -0.53064348437500000000000000000000000000000000000000e-7 + 0.24515728978125000000000000000000000000000000000000e-5 * t47 - 0.33430539515625000000000000000000000000000000000000e-5 * t46 + 0.11143513171875000000000000000000000000000000000000e-5 * t44
  t189 = 0.29919297250000000000000000000000000000000000000000e-2 - 0.13822715329500000000000000000000000000000000000000e0 * t47 + 0.18849157267500000000000000000000000000000000000000e0 * t46 - 0.62830524225000000000000000000000000000000000000000e-1 * t44
  t194 = 0.66958950870000000000000000000000000000000000000000e-7 * t89 - 0.74398834300000000000000000000000000000000000000000e-7 * t50 + 0.13285506125000000000000000000000000000000000000000e-8 * t41 - 0.15942607350000000000000000000000000000000000000000e-7
  t197 = 0.99275455000000000000000000000000000000000000000000e-4 * t41 - 0.119130546e-2
  t200 = -0.25278928416666666666666666666666666666666666666667e-3 * t41 + 0.303347141e-2
  t203 = -0.73257564333333333333333333333333333333333333333333e-3 * t41 + 0.879090772e-2
  t206 = 0.83616006666666666666666666666666666666666666666667e-2 * t41 - 0.100339208e0
  t208 = t164 * t110 + t169 * t119 + t125 * t128 + t174 * t128 + t197 * t128 + t133 * t136 + t179 * t136 + t200 * t136 + t141 * t143 + t184 * t143 + t203 * t143 + t149 * t84 + t154 * t159 + t194 * t159 + t189 * t84 + t206 * t84
  t214 = 0.23823590692687500000000000000000000000000000000000e-6 * t87 - 0.38484261888187500000000000000000000000000000000000e-6 * t89 + 0.17492846312812500000000000000000000000000000000000e-6 * t50 - 0.16197079919270833333333333333333333333333333333333e-8 * t41 + 0.19436495903125000000000000000000000000000000000000e-7
  t220 = -0.20758906793625000000000000000000000000000000000000e-6 * t87 + 0.33533618666625000000000000000000000000000000000000e-6 * t89 - 0.15242553939375000000000000000000000000000000000000e-6 * t50 + 0.14113475869791666666666666666666666666666666666667e-8 * t41 - 0.16936171043750000000000000000000000000000000000000e-7
  t226 = -0.90660620407500000000000000000000000000000000000000e-6 * t87 + 0.14645177142750000000000000000000000000000000000000e-5 * t89 - 0.66568987012500000000000000000000000000000000000000e-6 * t50 + 0.61637950937500000000000000000000000000000000000000e-8 * t41 - 0.73965541125000000000000000000000000000000000000000e-7
  t232 = 0.14869910671687500000000000000000000000000000000000e-5 * t87 - 0.24020624931187500000000000000000000000000000000000e-5 * t89 + 0.10918465877812500000000000000000000000000000000000e-5 * t50 - 0.10109690627604166666666666666666666666666666666667e-7 * t41 + 0.12131628753125000000000000000000000000000000000000e-6
  t238 = 0.13565000297062500000000000000000000000000000000000e-5 * t87 - 0.21912692787562500000000000000000000000000000000000e-5 * t89 + 0.99603149034375000000000000000000000000000000000000e-6 * t50 - 0.92225137994791666666666666666666666666666666666667e-8 * t41 + 0.11067016559375000000000000000000000000000000000000e-6
  t244 = -0.74143179825000000000000000000000000000000000000000e-5 * t87 + 0.11976975202500000000000000000000000000000000000000e-4 * t89 - 0.54440796375000000000000000000000000000000000000000e-5 * t50 + 0.50408144791666666666666666666666666666666666666667e-7 * t41 - 0.60489773750000000000000000000000000000000000000000e-6
  t248 = 0.84827243000000000000000000000000000000000000000000e-2 * t50 - 0.42413621500000000000000000000000000000000000000000e-3 * t41 + 0.50896345800000000000000000000000000000000000000000e-2
  t252 = -0.21137702575000000000000000000000000000000000000000e-1 * t50 + 0.10568851287500000000000000000000000000000000000000e-2 * t41 - 0.12682621545000000000000000000000000000000000000000e-1
  t256 = 0.70169718000000000000000000000000000000000000000000e-1 * t50 - 0.35084859000000000000000000000000000000000000000000e-2 * t41 + 0.42101830800000000000000000000000000000000000000000e-1
  t260 = -0.45544488500000000000000000000000000000000000000000e-1 * t50 + 0.22772244250000000000000000000000000000000000000000e-2 * t41 - 0.27326693100000000000000000000000000000000000000000e-1
  t263 = 0.11150732850000000000000000000000000000000000000000e-8 - 0.33452198550000000000000000000000000000000000000000e-8 * t44
  t266 = -0.33449010950000000000000000000000000000000000000000e-8 + 0.10034703285000000000000000000000000000000000000000e-7 * t44
  t269 = 0.17552051500000000000000000000000000000000000000000e-3 - 0.52656154500000000000000000000000000000000000000000e-3 * t44
  t272 = -0.91453028500000000000000000000000000000000000000000e-3 + 0.27435908550000000000000000000000000000000000000000e-2 * t44
  t275 = -0.14662652050000000000000000000000000000000000000000e-2 + 0.43987956150000000000000000000000000000000000000000e-2 * t44
  t278 = 0.75051818000000000000000000000000000000000000000000e-2 - 0.22515545400000000000000000000000000000000000000000e-1 * t44
  t280 = t220 * t110 + t266 * t110 + t226 * t119 + t269 * t119 + t232 * t128 + t248 * t128 + t272 * t128 + t238 * t136 + t252 * t136 + t275 * t136 + t244 * t143 + t256 * t143 + t278 * t143 + t214 * t159 + t263 * t159 + t260 * t84
  t282 = 0.21732173000000000000000000000000000000000000000000e-1 - 0.65196519000000000000000000000000000000000000000000e-1 * t44
  t285 = -0.78362630250000000000000000000000000000000000000000e-6 * t41 + 0.940351563e-5
  t288 = -0.42850389666666666666666666666666666666666666666667e-5 * t41 + 0.514204676e-4
  t291 = 0.68511658000000000000000000000000000000000000000000e-4 * t41 - 0.822139896e-3
  t296 = -0.69626676420000000000000000000000000000000000000000e-1 * t89 + 0.77362973800000000000000000000000000000000000000000e-1 * t50 - 0.13814816750000000000000000000000000000000000000000e-2 * t41 + 0.16577780100000000000000000000000000000000000000000e-1
  t300 = -0.18518413687500000000000000000000000000000000000000e-8 - 0.21604815968750000000000000000000000000000000000000e-7 * t46 + 0.18518413687500000000000000000000000000000000000000e-7 * t44
  t304 = 0.34208390662500000000000000000000000000000000000000e-8 + 0.39909789106250000000000000000000000000000000000000e-7 * t46 - 0.34208390662500000000000000000000000000000000000000e-7 * t44
  t308 = 0.78601451625000000000000000000000000000000000000000e-8 + 0.91701693562500000000000000000000000000000000000000e-7 * t46 - 0.78601451625000000000000000000000000000000000000000e-7 * t44
  t312 = -0.29655439012500000000000000000000000000000000000000e-7 - 0.34598012181250000000000000000000000000000000000000e-6 * t46 + 0.29655439012500000000000000000000000000000000000000e-6 * t44
  t316 = 0.23695936050000000000000000000000000000000000000000e-2 + 0.27645258725000000000000000000000000000000000000000e-1 * t46 - 0.23695936050000000000000000000000000000000000000000e-1 * t44
  t320 = -0.68591734125000000000000000000000000000000000000000e-2 - 0.80023689812500000000000000000000000000000000000000e-1 * t46 + 0.68591734125000000000000000000000000000000000000000e-1 * t44
  t324 = 0.60989465625000000000000000000000000000000000000000e-2 + 0.71154376562500000000000000000000000000000000000000e-1 * t46 - 0.60989465625000000000000000000000000000000000000000e-1 * t44
  t328 = 0.16872752975000000000000000000000000000000000000000e-7 * t50 - 0.84363764875000000000000000000000000000000000000000e-9 * t41 + 0.10123651785000000000000000000000000000000000000000e-7
  t332 = -0.54215142000000000000000000000000000000000000000000e-7 * t50 + 0.27107571000000000000000000000000000000000000000000e-8 * t41 - 0.32529085200000000000000000000000000000000000000000e-7
  t336 = 0.22418486650000000000000000000000000000000000000000e-2 * t50 - 0.11209243325000000000000000000000000000000000000000e-3 * t41 + 0.13451091990000000000000000000000000000000000000000e-2
  t338 = 0.13805672252189968750000000000000000000000000000000e1 + t282 * t84 + t285 * t159 + t288 * t110 + t291 * t119 + t296 * t84 + t300 * t159 + t304 * t110 + t308 * t119 + t312 * t128 + t316 * t136 + t320 * t143 + t324 * t84 + t328 * t159 + t332 * t110 + t336 * t119
  t340 = t121 + t208 + t280 + t338
  t344 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t340)
  t350 = t203 * t84
  t355 = 0.1e1 / t30 / t29 / r0
  t361 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * t52 * t32 + t34 * t355 / 0.3e1) * t20 * t24
  t362 = f.my_piecewise3(t62, t361, 0)
  t368 = 0.1e1 / t69 / t63
  t372 = t76 * t82
  t373 = f.my_piecewise3(t62, 0, t361)
  t377 = t81 ** 2
  t379 = t77 / t377
  t380 = t74 * t79
  t382 = t74 ** 2
  t383 = t382 * t73
  t389 = f.my_piecewise3(t61, -0.12e2 * t368 * t362 + 0.6e1 * t68 * t362 + 0.3e1 * t70 * t362, 0.6e1 * t372 * t73 * t373 + t379 * (0.3e1 * t380 * t373 + 0.3e1 * t383 * t373))
  t394 = t26 * t28 * t355 * t39
  t396 = t20 ** 2
  t399 = t396 / t22 / t21
  t400 = s0 ** 2
  t402 = t29 ** 2
  t407 = t38 ** 2
  t408 = 0.1e1 / t407
  t410 = t399 * t400 * t27 / t18 / t402 / t29 * t408
  t412 = -0.2e1 / 0.9e1 * t394 + t410 / 0.54e2
  t413 = t43 * t412
  t428 = t278 * t84
  t431 = t256 * t84
  t434 = t320 * t84
  t437 = t141 * t84
  t440 = t184 * t84
  t443 = t244 * t84
  t446 = 0.3e1 * t350 * t389 - 0.13039303800000000000000000000000000000000000000000e0 * t413 * t84 - 0.66904397100000000000000000000000000000000000000000e-8 * t413 * t159 + 0.20069406570000000000000000000000000000000000000000e-7 * t413 * t110 - 0.10531230900000000000000000000000000000000000000000e-2 * t413 * t119 + 0.54871817100000000000000000000000000000000000000000e-2 * t413 * t128 + 0.87975912300000000000000000000000000000000000000000e-2 * t413 * t136 - 0.45031090800000000000000000000000000000000000000000e-1 * t413 * t143 + 0.3e1 * t428 * t389 + 0.3e1 * t431 * t389 + 0.3e1 * t434 * t389 + 0.3e1 * t437 * t389 + 0.3e1 * t440 * t389 + 0.3e1 * t443 * t389
  t450 = t99 * t389
  t452 = t93 * t389
  t454 = t85 * t389
  t457 = 0.3003e4 / 0.16e2 * t450 - 0.3465e4 / 0.16e2 * t452 + 0.945e3 / 0.16e2 * t454 - 0.35e2 / 0.16e2 * t389
  t459 = t47 * t412
  t461 = t46 * t412
  t463 = t44 * t412
  t469 = t96 * t389
  t471 = t92 * t389
  t473 = t84 * t389
  t475 = 0.693e3 / 0.8e1 * t469 - 0.315e3 / 0.4e1 * t471 + 0.105e3 / 0.8e1 * t473
  t490 = 0.15e2 / 0.2e1 * t454 - 0.3e1 / 0.2e1 * t389
  t505 = 0.35e2 / 0.2e1 * t471 - 0.15e2 / 0.2e1 * t473
  t521 = 0.34725888949305555555555555555555555555555555555555e-1 * t394 - 0.28938240791087962962962962962962962962962962962962e-2 * t410 - 0.43736526393718750000000000000000000000000000000000e-2 * t389 + t214 * t457 + (-0.14531234755537500000000000000000000000000000000000e-5 * t459 + 0.16766809333312500000000000000000000000000000000000e-5 * t461 - 0.45727661818125000000000000000000000000000000000000e-6 * t463 - 0.37635935652777777777777777777777777777777777777779e-8 * t394 + 0.31363279710648148148148148148148148148148148148149e-9 * t410) * t110 + t220 * t475 + (0.16676513484881250000000000000000000000000000000000e-5 * t459 - 0.19242130944093750000000000000000000000000000000000e-5 * t461 + 0.52478538938437500000000000000000000000000000000000e-6 * t463 + 0.43192213118055555555555555555555555555555555555555e-8 * t394 - 0.35993510931712962962962962962962962962962962962962e-9 * t410) * t159 + (0.67410475777777777777777777777777777777777777777779e-3 * t394 - 0.56175396481481481481481481481481481481481481481482e-4 * t410) * t136 + t200 * t490 + (0.19535350488888888888888888888888888888888888888889e-2 * t394 - 0.16279458740740740740740740740740740740740740740741e-3 * t410) * t143 + (0.10408937470181250000000000000000000000000000000000e-4 * t459 - 0.12010312465593750000000000000000000000000000000000e-4 * t461 + 0.32755397633437500000000000000000000000000000000000e-5 * t463 + 0.26959175006944444444444444444444444444444444444445e-7 * t394 - 0.22465979172453703703703703703703703703703703703704e-8 * t410) * t128 + t232 * t505 + (0.94955002079437500000000000000000000000000000000000e-5 * t459 - 0.10956346393781250000000000000000000000000000000000e-4 * t461 + 0.29880944710312500000000000000000000000000000000000e-5 * t463 + 0.24593370131944444444444444444444444444444444444445e-7 * t394 - 0.20494475109953703703703703703703703703703703703704e-8 * t410) * t136 + (-0.63462434285250000000000000000000000000000000000000e-5 * t459 + 0.73225885713750000000000000000000000000000000000000e-5 * t461 - 0.19970696103750000000000000000000000000000000000000e-5 * t463 - 0.16436786916666666666666666666666666666666666666667e-7 * t394 + 0.13697322430555555555555555555555555555555555555556e-8 * t410) * t119
  t526 = 0.315e3 / 0.8e1 * t452 - 0.105e3 / 0.4e1 * t454 + 0.15e2 / 0.8e1 * t389
  t529 = t89 * t412
  t531 = t50 * t412
  t567 = t226 * t526 + t149 * t389 + (-0.59909240506500000000000000000000000000000000000000e-6 * t529 + 0.54462945915000000000000000000000000000000000000000e-6 * t531 - 0.90771576525000000000000000000000000000000000000000e-7 * t413) * t159 + t154 * t457 + t238 * t490 + (-0.51900225877500000000000000000000000000000000000000e-4 * t459 + 0.59884876012500000000000000000000000000000000000000e-4 * t461 - 0.16332238912500000000000000000000000000000000000000e-4 * t463 - 0.13442171944444444444444444444444444444444444444445e-6 * t394 + 0.11201809953703703703703703703703703703703703703704e-7 * t410) * t143 + 0.74218070864437500000000000000000000000000000000000e0 * t459 + (0.17655307926506250000000000000000000000000000000000e1 * t459 - 0.20371509145968750000000000000000000000000000000000e1 * t461 + 0.55558661307187500000000000000000000000000000000000e0 * t463 + 0.45727293256944444444444444444444444444444444444445e-2 * t394 - 0.38106077714120370370370370370370370370370370370371e-3 * t410) * t84 + t169 * t526 + (-0.36070052807250000000000000000000000000000000000000e-5 * t529 + 0.32790957097500000000000000000000000000000000000000e-5 * t531 - 0.54651595162500000000000000000000000000000000000000e-6 * t413) * t128 + t174 * t505 + (0.60159545176500000000000000000000000000000000000000e-6 * t529 - 0.54690495615000000000000000000000000000000000000000e-6 * t531 + 0.91150826025000000000000000000000000000000000000000e-7 * t413) * t110 + t164 * t475 + t189 * t389
  t613 = (0.33479475435000000000000000000000000000000000000000e-6 * t461 - 0.22319650290000000000000000000000000000000000000000e-6 * t463 - 0.35428016333333333333333333333333333333333333333333e-8 * t394 + 0.29523346944444444444444444444444444444444444444444e-9 * t410) * t159 + t194 * t457 + (-0.22965556209750000000000000000000000000000000000000e-5 * t529 + 0.20877778372500000000000000000000000000000000000000e-5 * t531 - 0.34796297287500000000000000000000000000000000000000e-6 * t413) * t136 + t179 * t490 + (0.14709437386875000000000000000000000000000000000000e-4 * t529 - 0.13372215806250000000000000000000000000000000000000e-4 * t531 + 0.22287026343750000000000000000000000000000000000000e-5 * t413) * t143 + (0.20477405977875000000000000000000000000000000000000e-5 * t529 - 0.18615823616250000000000000000000000000000000000000e-5 * t531 + 0.31026372693750000000000000000000000000000000000000e-6 * t413) * t119 + t133 * t490 + (-0.14832679010625000000000000000000000000000000000000e-5 * t461 + 0.98884526737500000000000000000000000000000000000000e-6 * t463 + 0.15695956625000000000000000000000000000000000000000e-7 * t394 - 0.13079963854166666666666666666666666666666666666667e-8 * t410) * t119 + t115 * t526 + (-0.54523426387500000000000000000000000000000000000000e-6 * t461 + 0.36348950925000000000000000000000000000000000000000e-6 * t463 + 0.57696747500000000000000000000000000000000000000000e-8 * t394 - 0.48080622916666666666666666666666666666666666666667e-9 * t410) * t110 + t106 * t475 + (-0.82936291977000000000000000000000000000000000000000e0 * t529 + 0.75396629070000000000000000000000000000000000000000e0 * t531 - 0.12566104845000000000000000000000000000000000000000e0 * t413) * t84 + 0.48014796319875000000000000000000000000000000000000e0 * t529 + 0.12082862679212500000000000000000000000000000000000e-1 * t471
  t653 = 0.14063653755131250000000000000000000000000000000000e-1 * t473 + (-0.74219946412500000000000000000000000000000000000000e0 * t461 + 0.49479964275000000000000000000000000000000000000000e0 * t463 + 0.78539625833333333333333333333333333333333333333333e-2 * t394 - 0.65449688194444444444444444444444444444444444444444e-3 * t410) * t143 - 0.19753059979406250000000000000000000000000000000000e1 * t461 + 0.14938339152281250000000000000000000000000000000000e1 * t463 + (-0.34813338210000000000000000000000000000000000000000e0 * t461 + 0.23208892140000000000000000000000000000000000000000e0 * t463 + 0.36839511333333333333333333333333333333333333333333e-2 * t394 - 0.30699592777777777777777777777777777777777777777778e-3 * t410) * t84 + t296 * t389 + (-0.86419263875000000000000000000000000000000000000000e-7 * t531 + 0.37036827375000000000000000000000000000000000000000e-7 * t413) * t159 + t300 * t457 + 0.13814974360687500000000000000000000000000000000000e-3 * t450 + (0.63881504268750000000000000000000000000000000000000e-5 * t461 - 0.42587669512500000000000000000000000000000000000000e-5 * t463 - 0.67599475416666666666666666666666666666666666666667e-7 * t394 + 0.56332896180555555555555555555555555555555555555555e-8 * t410) * t128 + t125 * t505 + (-0.35310374032500000000000000000000000000000000000000e0 * t461 + 0.23540249355000000000000000000000000000000000000000e0 * t463 + 0.37365475166666666666666666666666666666666666666667e-2 * t394 - 0.31137895972222222222222222222222222222222222222222e-3 * t410) * t136 + t308 * t526 - 0.47294155178156250000000000000000000000000000000000e-2 * t452
  t687 = 0.13938308465540625000000000000000000000000000000000e-1 * t454 + (0.15963915642500000000000000000000000000000000000000e-6 * t531 - 0.68416781325000000000000000000000000000000000000000e-7 * t413) * t110 - 0.55222473591250000000000000000000000000000000000000e0 * t531 - 0.18458962865625000000000000000000000000000000000000e0 * t413 + t304 * t475 - 0.48005288013375000000000000000000000000000000000000e-3 * t469 + t316 * t490 + (0.36680677425000000000000000000000000000000000000000e-6 * t531 - 0.15720290325000000000000000000000000000000000000000e-6 * t413) * t119 + (-0.32009475925000000000000000000000000000000000000000e0 * t531 + 0.13718346825000000000000000000000000000000000000000e0 * t413) * t143 + (0.28461750625000000000000000000000000000000000000000e0 * t531 - 0.12197893125000000000000000000000000000000000000000e0 * t413) * t84 + t324 * t389 + (0.50618258925000000000000000000000000000000000000000e-7 * t463 + 0.22497003966666666666666666666666666666666666666667e-8 * t394 - 0.18747503305555555555555555555555555555555555555556e-9 * t410) * t159 + t328 * t457 + (-0.13839204872500000000000000000000000000000000000000e-5 * t531 + 0.59310878025000000000000000000000000000000000000000e-6 * t413) * t128
  t729 = t312 * t505 + (0.11058103490000000000000000000000000000000000000000e0 * t531 - 0.47391872100000000000000000000000000000000000000000e-1 * t413) * t136 + (-0.13663346550000000000000000000000000000000000000000e0 * t463 - 0.60725984666666666666666666666666666666666666666667e-2 * t394 + 0.50604987222222222222222222222222222222222222222222e-3 * t410) * t84 + t260 * t389 + t263 * t457 + (0.25448172900000000000000000000000000000000000000000e-1 * t463 + 0.11310299066666666666666666666666666666666666666667e-2 * t394 - 0.94252492222222222222222222222222222222222222222222e-4 * t410) * t128 + t248 * t505 + (-0.63413107725000000000000000000000000000000000000000e-1 * t463 - 0.28183603433333333333333333333333333333333333333333e-2 * t394 + 0.23486336194444444444444444444444444444444444444444e-3 * t410) * t136 + t252 * t490 + (0.67255459950000000000000000000000000000000000000000e-2 * t463 + 0.29891315533333333333333333333333333333333333333333e-3 * t394 - 0.24909429611111111111111111111111111111111111111111e-4 * t410) * t119 + t336 * t526 + (-0.16264542600000000000000000000000000000000000000000e-6 * t463 - 0.72286856000000000000000000000000000000000000000000e-8 * t394 + 0.60239046666666666666666666666666666666666666666667e-9 * t410) * t110 + t332 * t475 + (-0.22297601777777777777777777777777777777777777777778e-1 * t394 + 0.18581334814814814814814814814814814814814814814815e-2 * t410) * t84
  t761 = t206 * t389 + (-0.26473454666666666666666666666666666666666666666667e-3 * t394 + 0.22061212222222222222222222222222222222222222222222e-4 * t410) * t128 + t197 * t505 + (0.11426770577777777777777777777777777777777777777778e-4 * t394 - 0.95223088148148148148148148148148148148148148148149e-6 * t410) * t110 + t288 * t475 + (-0.18269775466666666666666666666666666666666666666667e-3 * t394 + 0.15224812888888888888888888888888888888888888888889e-4 * t410) * t119 + t291 * t526 + t282 * t389 + (0.20896701400000000000000000000000000000000000000000e-5 * t394 - 0.17413917833333333333333333333333333333333333333333e-6 * t410) * t159 + t285 * t457 + t272 * t505 + t275 * t490 + t269 * t526 + t266 * t475 + (0.21050915400000000000000000000000000000000000000000e0 * t463 + 0.93559624000000000000000000000000000000000000000000e-2 * t394 - 0.77966353333333333333333333333333333333333333333333e-3 * t410) * t143
  t769 = f.my_piecewise3(t2, 0, -t6 * t17 / t30 * t340 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (t446 + t521 + t567 + t613 + t653 + t687 + t729 + t761))
  vrho_0_ = 0.2e1 * r0 * t769 + 0.2e1 * t344
  t773 = 0.5e1 / 0.72e2 * t25 * t33
  t774 = f.my_piecewise3(t62, -t773, 0)
  t782 = f.my_piecewise3(t62, 0, -t773)
  t792 = f.my_piecewise3(t61, -0.12e2 * t368 * t774 + 0.6e1 * t68 * t774 + 0.3e1 * t70 * t774, 0.6e1 * t372 * t73 * t782 + t379 * (0.3e1 * t380 * t782 + 0.3e1 * t383 * t782))
  t801 = t25 * t40
  t809 = t399 * s0 * t27 / t18 / t402 / r0 * t408
  t811 = t801 / 0.12e2 - t809 / 0.144e3
  t812 = t43 * t811
  t833 = 0.3e1 * t437 * t792 + 0.3e1 * t440 * t792 + 0.3e1 * t443 * t792 + 0.3e1 * t350 * t792 + 0.54871817100000000000000000000000000000000000000000e-2 * t812 * t128 + 0.87975912300000000000000000000000000000000000000000e-2 * t812 * t136 - 0.45031090800000000000000000000000000000000000000000e-1 * t812 * t143 + 0.3e1 * t428 * t792 - 0.13039303800000000000000000000000000000000000000000e0 * t812 * t84 + 0.3e1 * t431 * t792 - 0.66904397100000000000000000000000000000000000000000e-8 * t812 * t159 + 0.20069406570000000000000000000000000000000000000000e-7 * t812 * t110 - 0.10531230900000000000000000000000000000000000000000e-2 * t812 * t119 + 0.3e1 * t434 * t792
  t835 = t99 * t792
  t837 = t93 * t792
  t839 = t85 * t792
  t842 = 0.3003e4 / 0.16e2 * t835 - 0.3465e4 / 0.16e2 * t837 + 0.945e3 / 0.16e2 * t839 - 0.35e2 / 0.16e2 * t792
  t844 = t50 * t811
  t854 = t44 * t811
  t866 = t92 * t792
  t868 = t84 * t792
  t870 = 0.35e2 / 0.2e1 * t866 - 0.15e2 / 0.2e1 * t868
  t882 = t96 * t792
  t886 = 0.693e3 / 0.8e1 * t882 - 0.315e3 / 0.4e1 * t866 + 0.105e3 / 0.8e1 * t868
  t896 = 0.315e3 / 0.8e1 * t837 - 0.105e3 / 0.4e1 * t839 + 0.15e2 / 0.8e1 * t792
  t898 = -0.43736526393718750000000000000000000000000000000000e-2 * t792 + t328 * t842 + (0.11058103490000000000000000000000000000000000000000e0 * t844 - 0.47391872100000000000000000000000000000000000000000e-1 * t812) * t136 + (-0.32009475925000000000000000000000000000000000000000e0 * t844 + 0.13718346825000000000000000000000000000000000000000e0 * t812) * t143 + 0.10851840296657986111111111111111111111111111111111e-2 * t809 + (-0.13663346550000000000000000000000000000000000000000e0 * t854 + 0.22772244250000000000000000000000000000000000000000e-2 * t801 - 0.18976870208333333333333333333333333333333333333333e-3 * t809) * t84 + t260 * t792 + (0.25448172900000000000000000000000000000000000000000e-1 * t854 - 0.42413621500000000000000000000000000000000000000000e-3 * t801 + 0.35344684583333333333333333333333333333333333333333e-4 * t809) * t128 + t248 * t870 + (-0.63413107725000000000000000000000000000000000000000e-1 * t854 + 0.10568851287500000000000000000000000000000000000000e-2 * t801 - 0.88073760729166666666666666666666666666666666666667e-4 * t809) * t136 + (-0.16264542600000000000000000000000000000000000000000e-6 * t854 + 0.27107571000000000000000000000000000000000000000000e-8 * t801 - 0.22589642500000000000000000000000000000000000000000e-9 * t809) * t110 + t332 * t886 + (0.67255459950000000000000000000000000000000000000000e-2 * t854 - 0.11209243325000000000000000000000000000000000000000e-3 * t801 + 0.93410361041666666666666666666666666666666666666667e-5 * t809) * t119 + t336 * t896
  t924 = 0.15e2 / 0.2e1 * t839 - 0.3e1 / 0.2e1 * t792
  t930 = (0.50618258925000000000000000000000000000000000000000e-7 * t854 - 0.84363764875000000000000000000000000000000000000000e-9 * t801 + 0.70303137395833333333333333333333333333333333333333e-10 * t809) * t159 + (0.68511658000000000000000000000000000000000000000000e-4 * t801 - 0.57093048333333333333333333333333333333333333333333e-5 * t809) * t119 + t291 * t896 + (-0.42850389666666666666666666666666666666666666666667e-5 * t801 + 0.35708658055555555555555555555555555555555555555556e-6 * t809) * t110 + t288 * t886 + t282 * t792 + (-0.78362630250000000000000000000000000000000000000000e-6 * t801 + 0.65302191875000000000000000000000000000000000000000e-7 * t809) * t159 + t285 * t842 + t272 * t870 + t275 * t924 + t266 * t886 + t269 * t896 + t263 * t842 + t252 * t924
  t937 = t47 * t811
  t939 = t46 * t811
  t981 = (0.21050915400000000000000000000000000000000000000000e0 * t854 - 0.35084859000000000000000000000000000000000000000000e-2 * t801 + 0.29237382500000000000000000000000000000000000000000e-3 * t809) * t143 + t226 * t896 + (0.16676513484881250000000000000000000000000000000000e-5 * t937 - 0.19242130944093750000000000000000000000000000000000e-5 * t939 + 0.52478538938437500000000000000000000000000000000000e-6 * t854 - 0.16197079919270833333333333333333333333333333333333e-8 * t801 + 0.13497566599392361111111111111111111111111111111111e-9 * t809) * t159 + t214 * t842 + (0.83616006666666666666666666666666666666666666666667e-2 * t801 - 0.69680005555555555555555555555555555555555555555556e-3 * t809) * t84 + t206 * t792 + (0.99275455000000000000000000000000000000000000000000e-4 * t801 - 0.82729545833333333333333333333333333333333333333333e-5 * t809) * t128 + t197 * t870 + (-0.25278928416666666666666666666666666666666666666667e-3 * t801 + 0.21065773680555555555555555555555555555555555555556e-4 * t809) * t136 + t200 * t924 + (-0.73257564333333333333333333333333333333333333333333e-3 * t801 + 0.61047970277777777777777777777777777777777777777777e-4 * t809) * t143 + (0.10408937470181250000000000000000000000000000000000e-4 * t937 - 0.12010312465593750000000000000000000000000000000000e-4 * t939 + 0.32755397633437500000000000000000000000000000000000e-5 * t854 - 0.10109690627604166666666666666666666666666666666667e-7 * t801 + 0.84247421896701388888888888888888888888888888888892e-9 * t809) * t128 + t232 * t870 + (-0.14531234755537500000000000000000000000000000000000e-5 * t937 + 0.16766809333312500000000000000000000000000000000000e-5 * t939 - 0.45727661818125000000000000000000000000000000000000e-6 * t854 + 0.14113475869791666666666666666666666666666666666667e-8 * t801 - 0.11761229891493055555555555555555555555555555555556e-9 * t809) * t110
  t993 = t89 * t811
  t1035 = t220 * t886 + (-0.63462434285250000000000000000000000000000000000000e-5 * t937 + 0.73225885713750000000000000000000000000000000000000e-5 * t939 - 0.19970696103750000000000000000000000000000000000000e-5 * t854 + 0.61637950937500000000000000000000000000000000000000e-8 * t801 - 0.51364959114583333333333333333333333333333333333333e-9 * t809) * t119 + t149 * t792 + (-0.59909240506500000000000000000000000000000000000000e-6 * t993 + 0.54462945915000000000000000000000000000000000000000e-6 * t844 - 0.90771576525000000000000000000000000000000000000000e-7 * t812) * t159 + t154 * t842 + (0.94955002079437500000000000000000000000000000000000e-5 * t937 - 0.10956346393781250000000000000000000000000000000000e-4 * t939 + 0.29880944710312500000000000000000000000000000000000e-5 * t854 - 0.92225137994791666666666666666666666666666666666667e-8 * t801 + 0.76854281662326388888888888888888888888888888888889e-9 * t809) * t136 + t238 * t924 + (-0.51900225877500000000000000000000000000000000000000e-4 * t937 + 0.59884876012500000000000000000000000000000000000000e-4 * t939 - 0.16332238912500000000000000000000000000000000000000e-4 * t854 + 0.50408144791666666666666666666666666666666666666667e-7 * t801 - 0.42006787326388888888888888888888888888888888888889e-8 * t809) * t143 + t179 * t924 + (0.20477405977875000000000000000000000000000000000000e-5 * t993 - 0.18615823616250000000000000000000000000000000000000e-5 * t844 + 0.31026372693750000000000000000000000000000000000000e-6 * t812) * t119 + t169 * t896 + (0.60159545176500000000000000000000000000000000000000e-6 * t993 - 0.54690495615000000000000000000000000000000000000000e-6 * t844 + 0.91150826025000000000000000000000000000000000000000e-7 * t812) * t110 + t164 * t886 + (0.17655307926506250000000000000000000000000000000000e1 * t937 - 0.20371509145968750000000000000000000000000000000000e1 * t939 + 0.55558661307187500000000000000000000000000000000000e0 * t854 - 0.17147734971354166666666666666666666666666666666667e-2 * t801 + 0.14289779142795138888888888888888888888888888888889e-3 * t809) * t84
  t1077 = 0.74218070864437500000000000000000000000000000000000e0 * t937 + t189 * t792 + (0.33479475435000000000000000000000000000000000000000e-6 * t939 - 0.22319650290000000000000000000000000000000000000000e-6 * t854 + 0.13285506125000000000000000000000000000000000000000e-8 * t801 - 0.11071255104166666666666666666666666666666666666667e-9 * t809) * t159 + t194 * t842 + (-0.36070052807250000000000000000000000000000000000000e-5 * t993 + 0.32790957097500000000000000000000000000000000000000e-5 * t844 - 0.54651595162500000000000000000000000000000000000000e-6 * t812) * t128 + t174 * t870 + (-0.22965556209750000000000000000000000000000000000000e-5 * t993 + 0.20877778372500000000000000000000000000000000000000e-5 * t844 - 0.34796297287500000000000000000000000000000000000000e-6 * t812) * t136 + t133 * t924 + (-0.14832679010625000000000000000000000000000000000000e-5 * t939 + 0.98884526737500000000000000000000000000000000000000e-6 * t854 - 0.58859837343750000000000000000000000000000000000000e-8 * t801 + 0.49049864453125000000000000000000000000000000000000e-9 * t809) * t119 + t115 * t896 + (-0.54523426387500000000000000000000000000000000000000e-6 * t939 + 0.36348950925000000000000000000000000000000000000000e-6 * t854 - 0.21636280312500000000000000000000000000000000000000e-8 * t801 + 0.18030233593750000000000000000000000000000000000000e-9 * t809) * t110 + t106 * t886 + (0.14709437386875000000000000000000000000000000000000e-4 * t993 - 0.13372215806250000000000000000000000000000000000000e-4 * t844 + 0.22287026343750000000000000000000000000000000000000e-5 * t812) * t143 + 0.48014796319875000000000000000000000000000000000000e0 * t993
  t1120 = (-0.82936291977000000000000000000000000000000000000000e0 * t993 + 0.75396629070000000000000000000000000000000000000000e0 * t844 - 0.12566104845000000000000000000000000000000000000000e0 * t812) * t84 + (0.15963915642500000000000000000000000000000000000000e-6 * t844 - 0.68416781325000000000000000000000000000000000000000e-7 * t812) * t110 + (-0.74219946412500000000000000000000000000000000000000e0 * t939 + 0.49479964275000000000000000000000000000000000000000e0 * t854 - 0.29452359687500000000000000000000000000000000000000e-2 * t801 + 0.24543633072916666666666666666666666666666666666667e-3 * t809) * t143 - 0.19753059979406250000000000000000000000000000000000e1 * t939 + 0.14938339152281250000000000000000000000000000000000e1 * t854 + (-0.34813338210000000000000000000000000000000000000000e0 * t939 + 0.23208892140000000000000000000000000000000000000000e0 * t854 - 0.13814816750000000000000000000000000000000000000000e-2 * t801 + 0.11512347291666666666666666666666666666666666666667e-3 * t809) * t84 + t296 * t792 + (0.63881504268750000000000000000000000000000000000000e-5 * t939 - 0.42587669512500000000000000000000000000000000000000e-5 * t854 + 0.25349803281250000000000000000000000000000000000000e-7 * t801 - 0.21124836067708333333333333333333333333333333333333e-8 * t809) * t128 + t125 * t870 + (-0.35310374032500000000000000000000000000000000000000e0 * t939 + 0.23540249355000000000000000000000000000000000000000e0 * t854 - 0.14012053187500000000000000000000000000000000000000e-2 * t801 + 0.11676710989583333333333333333333333333333333333333e-3 * t809) * t136 + t312 * t870 + 0.12082862679212500000000000000000000000000000000000e-1 * t866 + 0.14063653755131250000000000000000000000000000000000e-1 * t868 + t304 * t886
  t1148 = -0.48005288013375000000000000000000000000000000000000e-3 * t882 + (0.36680677425000000000000000000000000000000000000000e-6 * t844 - 0.15720290325000000000000000000000000000000000000000e-6 * t812) * t119 + t308 * t896 - 0.47294155178156250000000000000000000000000000000000e-2 * t837 + 0.13938308465540625000000000000000000000000000000000e-1 * t839 + (-0.86419263875000000000000000000000000000000000000000e-7 * t844 + 0.37036827375000000000000000000000000000000000000000e-7 * t812) * t159 + t300 * t842 + 0.13814974360687500000000000000000000000000000000000e-3 * t835 + t316 * t924 + (0.28461750625000000000000000000000000000000000000000e0 * t844 - 0.12197893125000000000000000000000000000000000000000e0 * t812) * t84 - 0.55222473591250000000000000000000000000000000000000e0 * t844 - 0.18458962865625000000000000000000000000000000000000e0 * t812 + t324 * t792 + (-0.13839204872500000000000000000000000000000000000000e-5 * t844 + 0.59310878025000000000000000000000000000000000000000e-6 * t812) * t128 - 0.13022208355989583333333333333333333333333333333333e-1 * t801
  t1155 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t833 + t898 + t930 + t981 + t1035 + t1077 + t1120 + t1148))
  vsigma_0_ = 0.2e1 * r0 * t1155
  vlapl_0_ = 0.0e0
  t1159 = 0.5e1 / 0.9e1 * t28 * t54 * t25
  t1160 = f.my_piecewise3(t62, t1159, 0)
  t1168 = f.my_piecewise3(t62, 0, t1159)
  t1178 = f.my_piecewise3(t61, -0.12e2 * t368 * t1160 + 0.6e1 * t68 * t1160 + 0.3e1 * t70 * t1160, 0.6e1 * t372 * t73 * t1168 + t379 * (0.3e1 * t380 * t1168 + 0.3e1 * t383 * t1168))
  t1193 = t96 * t1178
  t1195 = t92 * t1178
  t1197 = t84 * t1178
  t1202 = 0.693e3 / 0.8e1 * t1193 - 0.315e3 / 0.4e1 * t1195 + 0.105e3 / 0.8e1 * t1197
  t1204 = t93 * t1178
  t1206 = t85 * t1178
  t1211 = 0.315e3 / 0.8e1 * t1204 - 0.105e3 / 0.4e1 * t1206 + 0.15e2 / 0.8e1 * t1178
  t1213 = 0.3e1 * t350 * t1178 + 0.3e1 * t428 * t1178 + 0.3e1 * t431 * t1178 + 0.3e1 * t434 * t1178 + 0.3e1 * t437 * t1178 + 0.3e1 * t440 * t1178 + 0.3e1 * t443 * t1178 - 0.48005288013375000000000000000000000000000000000000e-3 * t1193 + 0.12082862679212500000000000000000000000000000000000e-1 * t1195 + 0.14063653755131250000000000000000000000000000000000e-1 * t1197 + t288 * t1202 - 0.47294155178156250000000000000000000000000000000000e-2 * t1204 + 0.13938308465540625000000000000000000000000000000000e-1 * t1206 + t291 * t1211
  t1215 = t99 * t1178
  t1221 = 0.3003e4 / 0.16e2 * t1215 - 0.3465e4 / 0.16e2 * t1204 + 0.945e3 / 0.16e2 * t1206 - 0.35e2 / 0.16e2 * t1178
  t1225 = 0.35e2 / 0.2e1 * t1195 - 0.15e2 / 0.2e1 * t1197
  t1229 = 0.15e2 / 0.2e1 * t1206 - 0.3e1 / 0.2e1 * t1178
  t1240 = t282 * t1178 + 0.13814974360687500000000000000000000000000000000000e-3 * t1215 + t285 * t1221 + t272 * t1225 + t275 * t1229 + t269 * t1211 + t266 * t1202 + t252 * t1229 + t260 * t1178 + t263 * t1221 + t248 * t1225 + t332 * t1202 + t336 * t1211 + t324 * t1178
  t1256 = t106 * t1202 + t115 * t1211 + t206 * t1178 + t296 * t1178 + t304 * t1202 + t308 * t1211 + t300 * t1221 + t328 * t1221 + t125 * t1225 + t197 * t1225 + t312 * t1225 + t133 * t1229 + t200 * t1229 + t316 * t1229
  t1271 = t189 * t1178 + t194 * t1221 + t174 * t1225 + t179 * t1229 + t169 * t1211 + t154 * t1221 + t164 * t1202 + t238 * t1229 + t149 * t1178 + t226 * t1211 + t232 * t1225 + t220 * t1202 + t214 * t1221 - 0.43736526393718750000000000000000000000000000000000e-2 * t1178
  t1277 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t1213 + t1240 + t1256 + t1271))
  vtau_0_ = 0.2e1 * r0 * t1277
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t22 = 6 ** (0.1e1 / 0.3e1)
  t23 = jnp.pi ** 2
  t24 = t23 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = 0.1e1 / t25
  t27 = t22 * t26
  t28 = t27 * s0
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = r0 ** 2
  t33 = 0.1e1 / t19 / t31
  t35 = s0 * t30
  t36 = t35 * t33
  t39 = 0.65124e1 + t27 * t36 / 0.24e2
  t40 = 0.1e1 / t39
  t42 = t28 * t30 * t33 * t40
  t44 = t42 / 0.12e2 - 0.1e1
  t45 = t44 ** 2
  t46 = t45 * t44
  t47 = t45 ** 2
  t48 = t47 * t46
  t50 = t47 * t44
  t54 = 0.429e3 / 0.16e2 * t48 - 0.693e3 / 0.16e2 * t50 + 0.315e3 / 0.16e2 * t46 - 0.35e2 / 0.192e3 * t42 + 0.35e2 / 0.16e2
  t55 = tau0 * t30
  t57 = 0.1e1 / t19 / r0
  t63 = 0.5e1 / 0.9e1 * (t55 * t57 - t36 / 0.8e1) * t22 * t26
  t64 = 0.1e5 <= t63
  t65 = 0.1e5 < t63
  t66 = f.my_piecewise3(t65, t63, 0.1e5)
  t67 = t66 ** 2
  t71 = 0.1e1 / t67 / t66
  t72 = t67 ** 2
  t73 = 0.1e1 / t72
  t76 = f.my_piecewise3(t65, 0.1e5, t63)
  t77 = t76 ** 2
  t78 = 0.1e1 - t77
  t79 = t78 ** 2
  t80 = t79 * t78
  t81 = t77 * t76
  t82 = 0.1e1 + t81
  t84 = t81 * t82 + 0.1e1
  t85 = 0.1e1 / t84
  t87 = f.my_piecewise3(t64, 0.1e1 - 0.3e1 / t67 - t71 + 0.3e1 * t73, -t80 * t85)
  t88 = t87 ** 2
  t89 = t88 ** 2
  t90 = t89 * t88
  t94 = -0.5e1 / 0.16e2 + 0.231e3 / 0.16e2 * t90 - 0.315e3 / 0.16e2 * t89 + 0.105e3 / 0.16e2 * t88
  t97 = t89 * t87
  t99 = t88 * t87
  t102 = 0.63e2 / 0.8e1 * t97 - 0.35e2 / 0.4e1 * t99 + 0.15e2 / 0.8e1 * t87
  t107 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t89 - 0.15e2 / 0.4e1 * t88
  t112 = 0.5e1 / 0.2e1 * t99 - 0.3e1 / 0.2e1 * t87
  t115 = t54 * t87
  t118 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t88
  t121 = t47 * t45
  t125 = -0.5e1 / 0.16e2 + 0.231e3 / 0.16e2 * t121 - 0.315e3 / 0.16e2 * t47 + 0.105e3 / 0.16e2 * t45
  t126 = t89 * t99
  t131 = 0.429e3 / 0.16e2 * t126 - 0.693e3 / 0.16e2 * t97 + 0.315e3 / 0.16e2 * t99 - 0.35e2 / 0.16e2 * t87
  t136 = 0.3e1 / 0.8e1 + 0.35e2 / 0.8e1 * t47 - 0.15e2 / 0.4e1 * t45
  t137 = t136 * t87
  t141 = 0.5e1 / 0.2e1 * t46 - t42 / 0.8e1 + 0.3e1 / 0.2e1
  t154 = t141 * t87
  t157 = -0.1e1 / 0.2e1 + 0.3e1 / 0.2e1 * t45
  t160 = -0.774224962e-8 * t54 * t94 - 0.338128188e-7 * t54 * t102 + 0.554588743e-7 * t54 * t107 + 0.505920757e-7 * t54 * t112 + 0.940675747e-2 * t115 - 0.276524680e-6 * t54 * t118 - 0.691592964e-8 * t125 * t131 + 0.162638575e-1 * t137 + 0.674910119e-8 * t141 * t131 + 0.896739466e-3 * t141 * t102 - 0.216860568e-7 * t141 * t94 + 0.339308972e-2 * t141 * t107 - 0.845508103e-2 * t141 * t112 + 0.280678872e-1 * t141 * t118 - 0.182177954e-1 * t154 - 0.223014657e-8 * t157 * t131
  t180 = t157 * t87
  t182 = t44 * t87
  t186 = 0.668980219e-8 * t157 * t94 + 0.182906057e-2 * t157 * t107 - 0.351041030e-3 * t157 * t102 + 0.293253041e-2 * t157 * t112 - 0.150103636e-1 * t157 * t118 - 0.13022208355989583333333333333333333333333333333333e-1 * t42 + 0.19735677658125000000000000000000000000000000000000e-4 * t126 + 0.49794463840937500000000000000000000000000000000000e0 * t46 + 0.888525527e-8 * t54 * t131 - 0.80008813355625000000000000000000000000000000000000e-4 * t90 + 0.30207156698031250000000000000000000000000000000000e-2 * t89 + 0.70318268775656250000000000000000000000000000000000e-2 * t88 + 0.10602581552062500000000000000000000000000000000000e0 * t48 - 0.434643460e-1 * t180 + 0.100339208e0 * t182 - 0.879090772e-2 * t44 * t118
  t201 = 0.63e2 / 0.8e1 * t50 - 0.35e2 / 0.4e1 * t46 + 0.5e1 / 0.32e2 * t42 - 0.15e2 / 0.8e1
  t208 = t201 * t87
  t223 = -0.303347141e-2 * t44 * t112 + 0.119130546e-2 * t44 * t107 + 0.822139896e-3 * t44 * t102 - 0.514204676e-4 * t44 * t94 - 0.940351563e-5 * t44 * t131 - 0.896771404e-2 * t201 * t112 + 0.162238741e-6 * t201 * t107 - 0.188495102e-1 * t201 * t118 - 0.884148272e-2 * t208 + 0.912223751e-8 * t136 * t94 - 0.493824365e-8 * t136 * t131 + 0.209603871e-7 * t136 * t102 - 0.790811707e-7 * t136 * t107 - 0.182911291e-1 * t136 * t118 + 0.631891628e-2 * t136 * t112 + 0.80024660533125000000000000000000000000000000000000e-1 * t121
  t238 = t125 * t87
  t248 = 0.13805672252189968750000000000000000000000000000000e1 - 0.43736526393718750000000000000000000000000000000000e-2 * t87 - 0.94588310356312500000000000000000000000000000000000e-3 * t97 + 0.46461028218468750000000000000000000000000000000000e-2 * t99 - 0.39506119958812500000000000000000000000000000000000e0 * t50 + 0.236391411e-7 * t125 * t102 + 0.694482484e-8 * t125 * t94 - 0.416393106e-7 * t125 * t107 - 0.265114646e-7 * t125 * t112 + 0.169805915e-6 * t125 * t118 - 0.957417512e-2 * t238 + 0.850272392e-8 * t201 * t131 - 0.138472194e-7 * t201 * t94 - 0.376702959e-7 * t201 * t102 - 0.92294814328125000000000000000000000000000000000000e-1 * t45 - 0.13805618397812500000000000000000000000000000000000e0 * t47
  t250 = t160 + t186 + t223 + t248
  t254 = t17 * t18
  t257 = t31 * r0
  t259 = 0.1e1 / t19 / t257
  t265 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * t55 * t33 + t35 * t259 / 0.3e1) * t22 * t26
  t266 = f.my_piecewise3(t65, t265, 0)
  t272 = 0.1e1 / t72 / t66
  t276 = t79 * t85
  t277 = f.my_piecewise3(t65, 0, t265)
  t278 = t76 * t277
  t281 = t84 ** 2
  t282 = 0.1e1 / t281
  t283 = t80 * t282
  t284 = t77 * t82
  t286 = t77 ** 2
  t287 = t286 * t76
  t290 = 0.3e1 * t284 * t277 + 0.3e1 * t287 * t277
  t293 = f.my_piecewise3(t64, -0.12e2 * t272 * t266 + 0.6e1 * t71 * t266 + 0.3e1 * t73 * t266, 0.6e1 * t276 * t278 + t283 * t290)
  t295 = t88 * t293
  t298 = 0.15e2 / 0.2e1 * t295 - 0.3e1 / 0.2e1 * t293
  t303 = t28 * t30 * t259 * t40
  t305 = t22 ** 2
  t309 = s0 ** 2
  t310 = t305 / t24 / t23 * t309
  t311 = t31 ** 2
  t316 = t39 ** 2
  t317 = 0.1e1 / t316
  t319 = t310 * t29 / t18 / t311 / t31 * t317
  t321 = -0.2e1 / 0.9e1 * t303 + t319 / 0.54e2
  t322 = t45 * t321
  t327 = 0.15e2 / 0.2e1 * t322 + t303 / 0.3e1 - t319 / 0.36e2
  t330 = t90 * t293
  t332 = t89 * t293
  t336 = 0.3003e4 / 0.16e2 * t330 - 0.3465e4 / 0.16e2 * t332 + 0.945e3 / 0.16e2 * t295 - 0.35e2 / 0.16e2 * t293
  t339 = t97 * t293
  t342 = t99 * t293
  t344 = t87 * t293
  t346 = 0.693e3 / 0.8e1 * t339 - 0.315e3 / 0.4e1 * t342 + 0.105e3 / 0.8e1 * t344
  t359 = t47 * t321
  t365 = 0.315e3 / 0.8e1 * t359 - 0.105e3 / 0.4e1 * t322 - 0.5e1 / 0.12e2 * t303 + 0.5e1 / 0.144e3 * t319
  t368 = -0.43736526393718750000000000000000000000000000000000e-2 * t293 + 0.631891628e-2 * t136 * t298 + 0.14938339152281250000000000000000000000000000000000e1 * t322 + 0.674910119e-8 * t327 * t131 + 0.850272392e-8 * t201 * t336 - 0.48005288013375000000000000000000000000000000000000e-3 * t339 + 0.694482484e-8 * t125 * t346 + 0.940675747e-2 * t54 * t293 - 0.182177954e-1 * t141 * t293 - 0.940351563e-5 * t44 * t336 + 0.912223751e-8 * t136 * t346 + 0.293253041e-2 * t157 * t298 - 0.19753059979406250000000000000000000000000000000000e1 * t359 - 0.188495102e-1 * t365 * t118
  t374 = 0.315e3 / 0.8e1 * t332 - 0.105e3 / 0.4e1 * t295 + 0.15e2 / 0.8e1 * t293
  t379 = t50 * t321
  t382 = t46 * t321
  t384 = t44 * t321
  t386 = 0.693e3 / 0.8e1 * t379 - 0.315e3 / 0.4e1 * t382 + 0.105e3 / 0.8e1 * t384
  t387 = t386 * t87
  t403 = 0.35e2 / 0.2e1 * t342 - 0.15e2 / 0.2e1 * t344
  t408 = 0.674910119e-8 * t141 * t336 - 0.376702959e-7 * t201 * t374 - 0.884148272e-2 * t201 * t293 + 0.48014796319875000000000000000000000000000000000000e0 * t379 - 0.957417512e-2 * t387 + 0.280678872e-1 * t327 * t118 - 0.957417512e-2 * t125 * t293 + 0.694482484e-8 * t386 * t94 - 0.338128188e-7 * t54 * t374 + 0.888525527e-8 * t54 * t336 + 0.14063653755131250000000000000000000000000000000000e-1 * t344 + 0.12082862679212500000000000000000000000000000000000e-1 * t342 - 0.416393106e-7 * t125 * t403 + 0.162638575e-1 * t136 * t293
  t414 = 0.35e2 / 0.2e1 * t382 - 0.15e2 / 0.2e1 * t384
  t434 = -0.55222473591250000000000000000000000000000000000000e0 * t382 - 0.18458962865625000000000000000000000000000000000000e0 * t384 - 0.493824365e-8 * t414 * t131 - 0.303347141e-2 * t321 * t112 - 0.790811707e-7 * t136 * t403 + 0.13814974360687500000000000000000000000000000000000e-3 * t330 - 0.47294155178156250000000000000000000000000000000000e-2 * t332 + 0.13938308465540625000000000000000000000000000000000e-1 * t295 - 0.691592964e-8 * t125 * t336 + 0.34725888949305555555555555555555555555555555555555e-1 * t303 - 0.28938240791087962962962962962962962962962962962962e-2 * t319 - 0.223014657e-8 * t157 * t336 - 0.514204676e-4 * t44 * t346 - 0.351041030e-3 * t157 * t374
  t437 = t121 * t321
  t444 = 0.3003e4 / 0.16e2 * t437 - 0.3465e4 / 0.16e2 * t359 + 0.945e3 / 0.16e2 * t322 + 0.35e2 / 0.72e2 * t303 - 0.35e2 / 0.864e3 * t319
  t453 = t321 * t87
  t469 = 0.850272392e-8 * t365 * t131 + 0.74218070864437500000000000000000000000000000000000e0 * t437 - 0.338128188e-7 * t444 * t102 + 0.554588743e-7 * t444 * t107 + 0.339308972e-2 * t327 * t107 - 0.896771404e-2 * t365 * t112 + 0.100339208e0 * t453 + 0.822139896e-3 * t321 * t102 + 0.162238741e-6 * t201 * t403 - 0.790811707e-7 * t414 * t107 - 0.1303930380e0 * t384 * t87 - 0.450310908e-1 * t384 * t118 - 0.2637272316e-1 * t182 * t293 - 0.829574040e-6 * t115 * t293
  t500 = -0.669043971e-8 * t384 * t131 + 0.842036616e-1 * t154 * t293 + 0.548718171e-2 * t384 * t107 - 0.1053123090e-2 * t384 * t102 + 0.2006940657e-7 * t384 * t94 + 0.879759123e-2 * t384 * t112 + 0.509417745e-6 * t238 * t293 - 0.548733873e-1 * t137 * t293 - 0.450310908e-1 * t180 * t293 - 0.565485306e-1 * t208 * t293 - 0.940351563e-5 * t321 * t131 - 0.265114646e-7 * t386 * t112 + 0.236391411e-7 * t125 * t374 - 0.138472194e-7 * t201 * t346
  t505 = t327 * t87
  t529 = -0.265114646e-7 * t125 * t298 - 0.774224962e-8 * t444 * t94 - 0.182177954e-1 * t505 - 0.774224962e-8 * t54 * t346 - 0.303347141e-2 * t44 * t298 - 0.138472194e-7 * t365 * t94 + 0.209603871e-7 * t414 * t102 - 0.493824365e-8 * t136 * t336 + 0.554588743e-7 * t54 * t403 + 0.162238741e-6 * t365 * t107 + 0.896739466e-3 * t327 * t102 + 0.236391411e-7 * t386 * t102 - 0.376702959e-7 * t365 * t102 - 0.845508103e-2 * t141 * t298
  t531 = t444 * t87
  t559 = 0.940675747e-2 * t531 + 0.505920757e-7 * t444 * t112 - 0.216860568e-7 * t327 * t94 + 0.119130546e-2 * t321 * t107 - 0.879090772e-2 * t321 * t118 + 0.119130546e-2 * t44 * t403 - 0.514204676e-4 * t321 * t94 + 0.182906057e-2 * t157 * t403 + 0.668980219e-8 * t157 * t346 + 0.631891628e-2 * t414 * t112 + 0.822139896e-3 * t44 * t374 - 0.896771404e-2 * t201 * t298 - 0.216860568e-7 * t141 * t346 + 0.339308972e-2 * t141 * t403
  t562 = t414 * t87
  t564 = t365 * t87
  t590 = 0.896739466e-3 * t141 * t374 + 0.162638575e-1 * t562 - 0.884148272e-2 * t564 + 0.209603871e-7 * t136 * t374 + 0.888525527e-8 * t444 * t131 - 0.434643460e-1 * t157 * t293 - 0.276524680e-6 * t444 * t118 - 0.416393106e-7 * t386 * t107 + 0.169805915e-6 * t386 * t118 - 0.691592964e-8 * t386 * t131 - 0.845508103e-2 * t327 * t112 + 0.100339208e0 * t44 * t293 - 0.182911291e-1 * t414 * t118 + 0.505920757e-7 * t54 * t298 + 0.912223751e-8 * t414 * t94
  t593 = t368 + t408 + t434 + t469 + t500 + t529 + t559 + t590
  t598 = f.my_piecewise3(t2, 0, -t6 * t21 * t250 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t254 * t593)
  t607 = t321 ** 2
  t609 = t293 ** 2
  t611 = t266 ** 2
  t617 = 0.1e1 / t19 / t311
  t623 = 0.5e1 / 0.9e1 * (0.40e2 / 0.9e1 * t55 * t259 - 0.11e2 / 0.9e1 * t35 * t617) * t22 * t26
  t624 = f.my_piecewise3(t65, t623, 0)
  t639 = t277 ** 2
  t649 = f.my_piecewise3(t65, 0, t623)
  t656 = t290 ** 2
  t671 = f.my_piecewise3(t64, -0.18e2 * t73 * t611 + 0.6e1 * t71 * t624 - 0.12e2 * t272 * t611 + 0.3e1 * t73 * t624 + 0.60e2 / t72 / t67 * t611 - 0.12e2 * t272 * t624, -0.24e2 * t78 * t85 * t77 * t639 - 0.12e2 * t79 * t282 * t278 * t290 + 0.6e1 * t276 * t639 + 0.6e1 * t276 * t76 * t649 - 0.2e1 * t80 / t281 / t84 * t656 + t283 * (0.6e1 * t639 * t76 * t82 + 0.3e1 * t284 * t649 + 0.24e2 * t286 * t639 + 0.3e1 * t287 * t649))
  t675 = t28 * t30 * t617 * t40
  t682 = t310 * t29 / t18 / t311 / t257 * t317
  t686 = t47 * t607
  t690 = t23 ** 2
  t694 = t311 ** 2
  t700 = 0.1e1 / t690 * t309 * s0 / t694 / t31 / t316 / t39
  t702 = 0.22e2 / 0.27e2 * t675 - t682 / 0.6e1 + 0.4e1 / 0.81e2 * t700
  t703 = t50 * t702
  t705 = t45 * t607
  t707 = t46 * t702
  t710 = t44 * t702
  t712 = 0.3465e4 / 0.8e1 * t686 + 0.693e3 / 0.8e1 * t703 - 0.945e3 / 0.4e1 * t705 - 0.315e3 / 0.4e1 * t707 + 0.105e3 / 0.8e1 * t607 + 0.105e3 / 0.8e1 * t710
  t715 = t46 * t607
  t717 = t47 * t702
  t719 = t44 * t607
  t721 = t45 * t702
  t726 = 0.315e3 / 0.2e1 * t715 + 0.315e3 / 0.8e1 * t717 - 0.105e3 / 0.2e1 * t719 - 0.105e3 / 0.4e1 * t721 + 0.55e2 / 0.36e2 * t675 - 0.5e1 / 0.16e2 * t682 + 0.5e1 / 0.54e2 * t700
  t729 = t97 * t609
  t731 = t90 * t671
  t733 = t99 * t609
  t735 = t89 * t671
  t737 = t87 * t609
  t739 = t88 * t671
  t742 = 0.9009e4 / 0.8e1 * t729 + 0.3003e4 / 0.16e2 * t731 - 0.3465e4 / 0.4e1 * t733 - 0.3465e4 / 0.16e2 * t735 + 0.945e3 / 0.8e1 * t737 + 0.945e3 / 0.16e2 * t739 - 0.35e2 / 0.16e2 * t671
  t745 = t50 * t607
  t747 = t121 * t702
  t756 = 0.9009e4 / 0.8e1 * t745 + 0.3003e4 / 0.16e2 * t747 - 0.3465e4 / 0.4e1 * t715 - 0.3465e4 / 0.16e2 * t717 + 0.945e3 / 0.8e1 * t719 + 0.945e3 / 0.16e2 * t721 - 0.385e3 / 0.216e3 * t675 + 0.35e2 / 0.96e2 * t682 - 0.35e2 / 0.324e3 * t700
  t761 = -0.18458962865625000000000000000000000000000000000000e0 * t607 + 0.14063653755131250000000000000000000000000000000000e-1 * t609 - 0.43736526393718750000000000000000000000000000000000e-2 * t671 - 0.12732825948078703703703703703703703703703703703704e0 * t675 + 0.26044416711979166666666666666666666666666666666666e-1 * t682 + 0.1388964968e-7 * t386 * t346 - 0.957417512e-2 * t712 * t87 - 0.138472194e-7 * t726 * t94 - 0.691592964e-8 * t125 * t742 + 0.940675747e-2 * t756 * t87 - 0.879090772e-2 * t702 * t118
  t765 = 0.15e2 * t737 + 0.15e2 / 0.2e1 * t739 - 0.3e1 / 0.2e1 * t671
  t773 = 0.315e3 / 0.2e1 * t733 + 0.315e3 / 0.8e1 * t735 - 0.105e3 / 0.2e1 * t737 - 0.105e3 / 0.4e1 * t739 + 0.15e2 / 0.8e1 * t671
  t782 = t88 * t609
  t784 = t99 * t671
  t787 = t87 * t671
  t789 = 0.105e3 / 0.2e1 * t782 + 0.35e2 / 0.2e1 * t784 - 0.15e2 / 0.2e1 * t609 - 0.15e2 / 0.2e1 * t787
  t797 = 0.15e2 * t719 + 0.15e2 / 0.2e1 * t721 - 0.11e2 / 0.9e1 * t675 + t682 / 0.4e1 - 0.2e1 / 0.27e2 * t700
  t810 = 0.293253041e-2 * t157 * t765 - 0.376702959e-7 * t201 * t773 - 0.1053123090e-2 * t607 * t102 - 0.829574040e-6 * t54 * t609 + 0.505920757e-7 * t54 * t765 + 0.119130546e-2 * t44 * t789 + 0.280678872e-1 * t797 * t118 - 0.884148272e-2 * t201 * t671 + 0.548718171e-2 * t607 * t107 + 0.850272392e-8 * t726 * t131 + 0.2006940657e-7 * t607 * t94 + 0.879759123e-2 * t607 * t112
  t822 = 0.105e3 / 0.2e1 * t705 + 0.35e2 / 0.2e1 * t707 - 0.15e2 / 0.2e1 * t607 - 0.15e2 / 0.2e1 * t710
  t841 = 0.509417745e-6 * t125 * t609 + 0.674910119e-8 * t141 * t742 - 0.1691016206e-1 * t327 * t298 + 0.162638575e-1 * t822 * t87 - 0.790811707e-7 * t136 * t789 - 0.182177954e-1 * t141 * t671 - 0.565485306e-1 * t201 * t609 + 0.896739466e-3 * t141 * t773 - 0.493824365e-8 * t136 * t742 - 0.338128188e-7 * t54 * t773 - 0.416393106e-7 * t712 * t107 - 0.676256376e-7 * t444 * t374
  t850 = t89 * t609
  t852 = t97 * t671
  t858 = 0.3465e4 / 0.8e1 * t850 + 0.693e3 / 0.8e1 * t852 - 0.945e3 / 0.4e1 * t782 - 0.315e3 / 0.4e1 * t784 + 0.105e3 / 0.8e1 * t609 + 0.105e3 / 0.8e1 * t787
  t875 = 0.694482484e-8 * t712 * t94 + 0.100339208e0 * t702 * t87 + 0.200678416e0 * t321 * t293 - 0.1383185928e-7 * t386 * t336 - 0.216860568e-7 * t141 * t858 + 0.1349820238e-7 * t327 * t336 - 0.303347141e-2 * t44 * t765 - 0.790811707e-7 * t822 * t107 - 0.1028409352e-3 * t321 * t346 - 0.1581623414e-6 * t414 * t403 + 0.325277150e-1 * t414 * t293 - 0.303347141e-2 * t702 * t112
  t900 = -0.845508103e-2 * t141 * t765 + 0.674910119e-8 * t797 * t131 - 0.940351563e-5 * t702 * t131 + 0.1793478932e-2 * t327 * t374 + 0.419207742e-7 * t414 * t374 + 0.1700544784e-7 * t365 * t336 - 0.434643460e-1 * t157 * t671 - 0.188495102e-1 * t726 * t118 + 0.1824447502e-7 * t414 * t346 - 0.832786212e-7 * t386 * t403 - 0.493824365e-8 * t822 * t131
  t925 = 0.842036616e-1 * t141 * t609 + 0.822139896e-3 * t44 * t773 + 0.888525527e-8 * t756 * t131 - 0.691592964e-8 * t712 * t131 + 0.162238741e-6 * t726 * t107 - 0.987648730e-8 * t414 * t336 - 0.351041030e-3 * t157 * t773 - 0.182911291e-1 * t822 * t118 - 0.606694282e-2 * t321 * t298 - 0.669043971e-8 * t607 * t131 + 0.554588743e-7 * t756 * t107 + 0.912223751e-8 * t136 * t858
  t951 = -0.548733873e-1 * t136 * t609 + 0.888525527e-8 * t54 * t742 - 0.216860568e-7 * t797 * t94 + 0.119130546e-2 * t702 * t107 - 0.896771404e-2 * t201 * t765 - 0.1793542808e-1 * t365 * t298 + 0.162238741e-6 * t201 * t789 - 0.1303930380e0 * t607 * t87 + 0.678617944e-2 * t327 * t403 + 0.339308972e-2 * t797 * t107 - 0.1914835024e-1 * t386 * t293 + 0.822139896e-3 * t702 * t102
  t976 = -0.1768296544e-1 * t365 * t293 + 0.169805915e-6 * t712 * t118 + 0.1263783256e-1 * t414 * t298 + 0.505920757e-7 * t756 * t112 + 0.1011841514e-6 * t444 * t298 - 0.884148272e-2 * t726 * t87 - 0.774224962e-8 * t54 * t858 + 0.1777051054e-7 * t444 * t336 - 0.530229292e-7 * t386 * t298 - 0.138472194e-7 * t201 * t858 - 0.338128188e-7 * t756 * t102 - 0.1880703126e-4 * t321 * t336
  t1002 = 0.668980219e-8 * t157 * t858 - 0.265114646e-7 * t125 * t765 + 0.631891628e-2 * t136 * t765 - 0.845508103e-2 * t797 * t112 - 0.433721136e-7 * t327 * t346 + 0.850272392e-8 * t201 * t742 - 0.450310908e-1 * t157 * t609 + 0.209603871e-7 * t136 * t773 + 0.472782822e-7 * t386 * t374 - 0.940351563e-5 * t44 * t742 - 0.276524680e-6 * t756 * t118
  t1027 = 0.236391411e-7 * t712 * t102 + 0.209603871e-7 * t822 * t102 + 0.339308972e-2 * t141 * t789 + 0.1644279792e-2 * t321 * t374 - 0.276944388e-7 * t365 * t346 + 0.1109177486e-6 * t444 * t403 - 0.774224962e-8 * t756 * t94 + 0.162638575e-1 * t136 * t671 - 0.514204676e-4 * t702 * t94 + 0.694482484e-8 * t125 * t858 - 0.416393106e-7 * t125 * t789 + 0.1881351494e-1 * t444 * t293
  t1051 = 0.896739466e-3 * t797 * t102 + 0.554588743e-7 * t54 * t789 + 0.100339208e0 * t44 * t671 - 0.1548449924e-7 * t444 * t346 + 0.44530842518662500000000000000000000000000000000000e1 * t745 + 0.74218070864437500000000000000000000000000000000000e0 * t747 - 0.265114646e-7 * t712 * t112 + 0.912223751e-8 * t822 * t94 + 0.182906057e-2 * t157 * t789 - 0.753405918e-7 * t365 * t374 - 0.450310908e-1 * t607 * t118 - 0.2637272316e-1 * t44 * t609
  t1069 = 0.238261092e-2 * t321 * t403 - 0.957417512e-2 * t125 * t671 + 0.324477482e-6 * t365 * t403 - 0.16566742077375000000000000000000000000000000000000e1 * t705 - 0.55222473591250000000000000000000000000000000000000e0 * t707 - 0.18458962865625000000000000000000000000000000000000e0 * t710 + 0.631891628e-2 * t822 * t112 - 0.24002644006687500000000000000000000000000000000000e-2 * t850 + 0.12082862679212500000000000000000000000000000000000e-1 * t784 + 0.14063653755131250000000000000000000000000000000000e-1 * t787 - 0.514204676e-4 * t44 * t858 + 0.24007398159937500000000000000000000000000000000000e1 * t686
  t1090 = 0.48014796319875000000000000000000000000000000000000e0 * t703 + 0.29876678304562500000000000000000000000000000000000e1 * t719 + 0.14938339152281250000000000000000000000000000000000e1 * t721 - 0.376702959e-7 * t726 * t102 - 0.48005288013375000000000000000000000000000000000000e-3 * t852 + 0.82889846164125000000000000000000000000000000000000e-3 * t729 + 0.13814974360687500000000000000000000000000000000000e-3 * t731 - 0.223014657e-8 * t157 * t742 + 0.940675747e-2 * t54 * t671 - 0.182177954e-1 * t797 * t87 - 0.364355908e-1 * t327 * t293 - 0.896771404e-2 * t726 * t112
  t1108 = -0.18917662071262500000000000000000000000000000000000e-1 * t733 - 0.47294155178156250000000000000000000000000000000000e-2 * t735 + 0.27876616931081250000000000000000000000000000000000e-1 * t737 + 0.13938308465540625000000000000000000000000000000000e-1 * t739 + 0.236391411e-7 * t125 * t773 + 0.36248588037637500000000000000000000000000000000000e-1 * t782 - 0.79012239917625000000000000000000000000000000000000e1 * t715 - 0.19753059979406250000000000000000000000000000000000e1 * t717 - 0.548733873e-1 * t137 * t671 + 0.4013881314e-7 * t384 * t346 + 0.1684073232e0 * t505 * t293 - 0.1338087942e-7 * t384 * t336
  t1133 = -0.450310908e-1 * t180 * t671 - 0.2637272316e-1 * t182 * t671 + 0.842036616e-1 * t154 * t671 - 0.77168642109567901234567901234567901234567901234565e-2 * t700 - 0.2701865448e0 * t384 * t344 + 0.1018835490e-5 * t387 * t293 - 0.2607860760e0 * t384 * t293 - 0.1303930380e0 * t710 * t87 - 0.829574040e-6 * t115 * t671 + 0.1759518246e-1 * t384 * t298 + 0.1097436342e-1 * t384 * t403 - 0.1097467746e0 * t562 * t293
  t1158 = -0.565485306e-1 * t208 * t671 + 0.2006940657e-7 * t710 * t94 + 0.879759123e-2 * t710 * t112 - 0.2106246180e-2 * t384 * t374 - 0.1053123090e-2 * t710 * t102 - 0.5274544632e-1 * t453 * t293 - 0.669043971e-8 * t710 * t131 - 0.450310908e-1 * t710 * t118 - 0.1659148080e-5 * t531 * t293 - 0.1130970612e0 * t564 * t293 + 0.548718171e-2 * t710 * t107 + 0.509417745e-6 * t238 * t671
  t1167 = f.my_piecewise3(t2, 0, t6 * t17 * t57 * t250 / 0.12e2 - t6 * t21 * t593 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t254 * (t761 + t810 + t841 + t875 + t900 + t925 + t951 + t976 + t1002 + t1027 + t1051 + t1069 + t1090 + t1108 + t1133 + t1158))
  v2rho2_0_ = 0.2e1 * r0 * t1167 + 0.4e1 * t598

  res = {'v2rho2': v2rho2_0_}
  return res
