"""Generated from gga_c_am05.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_alpha_raw = params.alpha
  if isinstance(params_alpha_raw, (str, bytes, dict)):
    params_alpha = params_alpha_raw
  else:
    try:
      params_alpha_seq = list(params_alpha_raw)
    except TypeError:
      params_alpha = params_alpha_raw
    else:
      params_alpha_seq = np.asarray(params_alpha_seq, dtype=np.float64)
      params_alpha = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_seq))
  params_gamma_raw = params.gamma
  if isinstance(params_gamma_raw, (str, bytes, dict)):
    params_gamma = params_gamma_raw
  else:
    try:
      params_gamma_seq = list(params_gamma_raw)
    except TypeError:
      params_gamma = params_gamma_raw
    else:
      params_gamma_seq = np.asarray(params_gamma_seq, dtype=np.float64)
      params_gamma = np.concatenate((np.array([np.nan], dtype=np.float64), params_gamma_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  XX = lambda s: 1 / (1 + params_alpha * s ** 2)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  ff = lambda s: XX(s) + params_gamma * (1 - XX(s))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  functional_body = lambda rs, z, xt, xs0, xs1: f_pw(rs, z) * (+f.opz_pow_n(z, 1) / 2 * ff(X2S * xs0) + f.opz_pow_n(-z, 1) / 2 * ff(X2S * xs1))

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_alpha_raw = params.alpha
  if isinstance(params_alpha_raw, (str, bytes, dict)):
    params_alpha = params_alpha_raw
  else:
    try:
      params_alpha_seq = list(params_alpha_raw)
    except TypeError:
      params_alpha = params_alpha_raw
    else:
      params_alpha_seq = np.asarray(params_alpha_seq, dtype=np.float64)
      params_alpha = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_seq))
  params_gamma_raw = params.gamma
  if isinstance(params_gamma_raw, (str, bytes, dict)):
    params_gamma = params_gamma_raw
  else:
    try:
      params_gamma_seq = list(params_gamma_raw)
    except TypeError:
      params_gamma = params_gamma_raw
    else:
      params_gamma_seq = np.asarray(params_gamma_seq, dtype=np.float64)
      params_gamma = np.concatenate((np.array([np.nan], dtype=np.float64), params_gamma_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  XX = lambda s: 1 / (1 + params_alpha * s ** 2)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  ff = lambda s: XX(s) + params_gamma * (1 - XX(s))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  functional_body = lambda rs, z, xt, xs0, xs1: f_pw(rs, z) * (+f.opz_pow_n(z, 1) / 2 * ff(X2S * xs0) + f.opz_pow_n(-z, 1) / 2 * ff(X2S * xs1))

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_alpha_raw = params.alpha
  if isinstance(params_alpha_raw, (str, bytes, dict)):
    params_alpha = params_alpha_raw
  else:
    try:
      params_alpha_seq = list(params_alpha_raw)
    except TypeError:
      params_alpha = params_alpha_raw
    else:
      params_alpha_seq = np.asarray(params_alpha_seq, dtype=np.float64)
      params_alpha = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_seq))
  params_gamma_raw = params.gamma
  if isinstance(params_gamma_raw, (str, bytes, dict)):
    params_gamma = params_gamma_raw
  else:
    try:
      params_gamma_seq = list(params_gamma_raw)
    except TypeError:
      params_gamma = params_gamma_raw
    else:
      params_gamma_seq = np.asarray(params_gamma_seq, dtype=np.float64)
      params_gamma = np.concatenate((np.array([np.nan], dtype=np.float64), params_gamma_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  XX = lambda s: 1 / (1 + params_alpha * s ** 2)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  ff = lambda s: XX(s) + params_gamma * (1 - XX(s))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  functional_body = lambda rs, z, xt, xs0, xs1: f_pw(rs, z) * (+f.opz_pow_n(z, 1) / 2 * ff(X2S * xs0) + f.opz_pow_n(-z, 1) / 2 * ff(X2S * xs1))

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t11 = t4 * t6 / t8
  t13 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t11
  t14 = jnp.sqrt(t11)
  t17 = t11 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t8 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.23615562999000000000000000000000000000000000000000e0 * t14 + 0.55770497660000000000000000000000000000000000000000e-1 * t11 + 0.12733196185000000000000000000000000000000000000000e-1 * t17 + 0.76629248290000000000000000000000000000000000000000e-2 * t25
  t29 = 0.1e1 + 0.1e1 / t27
  t30 = jnp.log(t29)
  t31 = t13 * t30
  t32 = r0 - r1
  t33 = t32 ** 2
  t34 = t33 ** 2
  t35 = t7 ** 2
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t38 = t34 * t37
  t39 = 0.1e1 / t7
  t40 = t32 * t39
  t41 = 0.1e1 + t40
  t42 = t41 <= f.p.zeta_threshold
  t43 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t44 = t43 * f.p.zeta_threshold
  t45 = t41 ** (0.1e1 / 0.3e1)
  t47 = f.my_piecewise3(t42, t44, t45 * t41)
  t48 = 0.1e1 - t40
  t49 = t48 <= f.p.zeta_threshold
  t50 = t48 ** (0.1e1 / 0.3e1)
  t52 = f.my_piecewise3(t49, t44, t50 * t48)
  t54 = 2 ** (0.1e1 / 0.3e1)
  t57 = 0.1e1 / (0.2e1 * t54 - 0.2e1)
  t58 = (t47 + t52 - 0.2e1) * t57
  t60 = 0.3109070e-1 + 0.15971292590000000000000000000000000000000000000000e-2 * t11
  t65 = 0.21948324211500000000000000000000000000000000000000e0 * t14 + 0.48172707847500000000000000000000000000000000000000e-1 * t11 + 0.13082189292500000000000000000000000000000000000000e-1 * t17 + 0.48592432297500000000000000000000000000000000000000e-2 * t25
  t67 = 0.1e1 + 0.1e1 / t65
  t68 = jnp.log(t67)
  t71 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t11
  t76 = 0.17489762330000000000000000000000000000000000000000e0 * t14 + 0.30591463695000000000000000000000000000000000000000e-1 * t11 + 0.37162156485000000000000000000000000000000000000000e-2 * t17 + 0.41939460495000000000000000000000000000000000000000e-2 * t25
  t78 = 0.1e1 + 0.1e1 / t76
  t79 = jnp.log(t78)
  t80 = t71 * t79
  t82 = -t60 * t68 + t31 - 0.58482236226346462072622386637590534819724553404281e0 * t80
  t83 = t58 * t82
  t87 = -t31 + t38 * t83 + 0.58482236226346462072622386637590534819724553404281e0 * t58 * t80
  t88 = f.my_piecewise3(t42, f.p.zeta_threshold, t41)
  t89 = 6 ** (0.1e1 / 0.3e1)
  t90 = params.alpha * t89
  t91 = jnp.pi ** 2
  t92 = t91 ** (0.1e1 / 0.3e1)
  t93 = t92 ** 2
  t94 = 0.1e1 / t93
  t95 = t94 * s0
  t96 = r0 ** 2
  t97 = r0 ** (0.1e1 / 0.3e1)
  t98 = t97 ** 2
  t100 = 0.1e1 / t98 / t96
  t104 = 0.1e1 + t90 * t95 * t100 / 0.24e2
  t105 = 0.1e1 / t104
  t108 = t105 + params.gamma * (0.1e1 - t105)
  t110 = f.my_piecewise3(t49, f.p.zeta_threshold, t48)
  t111 = t94 * s2
  t112 = r1 ** 2
  t113 = r1 ** (0.1e1 / 0.3e1)
  t114 = t113 ** 2
  t116 = 0.1e1 / t114 / t112
  t120 = 0.1e1 + t90 * t111 * t116 / 0.24e2
  t121 = 0.1e1 / t120
  t124 = t121 + params.gamma * (0.1e1 - t121)
  t127 = t88 * t108 / 0.2e1 + t110 * t124 / 0.2e1
  t128 = t87 * t127
  t130 = 0.1e1 / t8 / t7
  t131 = t6 * t130
  t134 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t131 * t30
  t135 = t27 ** 2
  t140 = t3 * t6
  t141 = t140 * t130
  t142 = 0.1e1 / t14 * t1 * t141
  t144 = t4 * t131
  t146 = t11 ** 0.5e0
  t148 = t146 * t1 * t141
  t153 = t21 * t5 / t22 / t7
  t158 = t13 / t135 * (-0.39359271665000000000000000000000000000000000000000e-1 * t142 - 0.18590165886666666666666666666666666666666666666667e-1 * t144 - 0.63665980925000000000000000000000000000000000000000e-2 * t148 - 0.51086165526666666666666666666666666666666666666667e-2 * t153) / t29
  t162 = 0.4e1 * t33 * t32 * t37 * t83
  t167 = 0.4e1 * t34 / t36 / t7 * t83
  t169 = t32 / t35
  t170 = t39 - t169
  t173 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t170)
  t174 = -t170
  t177 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t174)
  t179 = (t173 + t177) * t57
  t185 = t65 ** 2
  t199 = t76 ** 2
  t200 = 0.1e1 / t199
  t206 = -0.29149603883333333333333333333333333333333333333333e-1 * t142 - 0.10197154565000000000000000000000000000000000000000e-1 * t144 - 0.18581078242500000000000000000000000000000000000000e-2 * t148 - 0.27959640330000000000000000000000000000000000000000e-2 * t153
  t207 = 0.1e1 / t78
  t213 = t38 * t58 * (0.53237641966666666666666666666666666666666666666667e-3 * t4 * t131 * t68 + t60 / t185 * (-0.36580540352500000000000000000000000000000000000000e-1 * t142 - 0.16057569282500000000000000000000000000000000000000e-1 * t144 - 0.65410946462500000000000000000000000000000000000000e-2 * t148 - 0.32394954865000000000000000000000000000000000000000e-2 * t153) / t67 - t134 - t158 + 0.18311447306006545054854346104378990962041954983034e-3 * t4 * t131 * t79 + 0.58482236226346462072622386637590534819724553404281e0 * t71 * t200 * t206 * t207)
  t220 = 0.18311447306006545054854346104378990962041954983034e-3 * t58 * t1 * t140 * t130 * t79
  t225 = 0.58482236226346462072622386637590534819724553404281e0 * t58 * t71 * t200 * t206 * t207
  t229 = t7 * t87
  t230 = f.my_piecewise3(t42, 0, t170)
  t232 = t104 ** 2
  t233 = 0.1e1 / t232
  t234 = t233 * params.alpha
  t238 = 0.1e1 / t98 / t96 / r0
  t242 = params.gamma * t233 * params.alpha
  t243 = t89 * t94
  t250 = f.my_piecewise3(t49, 0, t174)
  vrho_0_ = t128 + t7 * (t134 + t158 + t162 - t167 + t38 * t179 * t82 + t213 + 0.58482236226346462072622386637590534819724553404281e0 * t179 * t80 - t220 - t225) * t127 + t229 * (t230 * t108 / 0.2e1 + t88 * (-t242 * t243 * s0 * t238 / 0.9e1 + t234 * t89 * t95 * t238 / 0.9e1) / 0.2e1 + t250 * t124 / 0.2e1)
  t255 = -t39 - t169
  t258 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t255)
  t259 = -t255
  t262 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t259)
  t264 = (t258 + t262) * t57
  t272 = f.my_piecewise3(t42, 0, t255)
  t274 = f.my_piecewise3(t49, 0, t259)
  t276 = t120 ** 2
  t277 = 0.1e1 / t276
  t278 = t277 * params.alpha
  t282 = 0.1e1 / t114 / t112 / r1
  t286 = params.gamma * t277 * params.alpha
  vrho_1_ = t128 + t7 * (t134 + t158 - t162 - t167 + t38 * t264 * t82 + t213 + 0.58482236226346462072622386637590534819724553404281e0 * t264 * t80 - t220 - t225) * t127 + t229 * (t272 * t108 / 0.2e1 + t274 * t124 / 0.2e1 + t110 * (-t286 * t243 * s2 * t282 / 0.9e1 + t278 * t89 * t111 * t282 / 0.9e1) / 0.2e1)
  t296 = t243 * t100
  vsigma_0_ = t229 * t88 * (-t234 * t296 / 0.24e2 + t242 * t296 / 0.24e2) / 0.2e1
  vsigma_1_ = 0.0e0
  t303 = t243 * t116
  vsigma_2_ = t229 * t110 * (-t278 * t303 / 0.24e2 + t286 * t303 / 0.24e2) / 0.2e1
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_alpha_raw = params.alpha
  if isinstance(params_alpha_raw, (str, bytes, dict)):
    params_alpha = params_alpha_raw
  else:
    try:
      params_alpha_seq = list(params_alpha_raw)
    except TypeError:
      params_alpha = params_alpha_raw
    else:
      params_alpha_seq = np.asarray(params_alpha_seq, dtype=np.float64)
      params_alpha = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_seq))
  params_gamma_raw = params.gamma
  if isinstance(params_gamma_raw, (str, bytes, dict)):
    params_gamma = params_gamma_raw
  else:
    try:
      params_gamma_seq = list(params_gamma_raw)
    except TypeError:
      params_gamma = params_gamma_raw
    else:
      params_gamma_seq = np.asarray(params_gamma_seq, dtype=np.float64)
      params_gamma = np.concatenate((np.array([np.nan], dtype=np.float64), params_gamma_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  XX = lambda s: 1 / (1 + params_alpha * s ** 2)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  ff = lambda s: XX(s) + params_gamma * (1 - XX(s))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  functional_body = lambda rs, z, xt, xs0, xs1: f_pw(rs, z) * (+f.opz_pow_n(z, 1) / 2 * ff(X2S * xs0) + f.opz_pow_n(-z, 1) / 2 * ff(X2S * xs1))

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t10 = t4 * t6 / t7
  t12 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t24 = t20 * t5 / t21
  t26 = 0.23615562999000000000000000000000000000000000000000e0 * t13 + 0.55770497660000000000000000000000000000000000000000e-1 * t10 + 0.12733196185000000000000000000000000000000000000000e-1 * t16 + 0.76629248290000000000000000000000000000000000000000e-2 * t24
  t28 = 0.1e1 + 0.1e1 / t26
  t29 = jnp.log(t28)
  t31 = 0.1e1 <= f.p.zeta_threshold
  t32 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t34 = f.my_piecewise3(t31, t32 * f.p.zeta_threshold, 1)
  t37 = 2 ** (0.1e1 / 0.3e1)
  t41 = (0.2e1 * t34 - 0.2e1) / (0.2e1 * t37 - 0.2e1)
  t43 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t10
  t48 = 0.17489762330000000000000000000000000000000000000000e0 * t13 + 0.30591463695000000000000000000000000000000000000000e-1 * t10 + 0.37162156485000000000000000000000000000000000000000e-2 * t16 + 0.41939460495000000000000000000000000000000000000000e-2 * t24
  t50 = 0.1e1 + 0.1e1 / t48
  t51 = jnp.log(t50)
  t55 = -t12 * t29 + 0.58482236226346462072622386637590534819724553404281e0 * t41 * t43 * t51
  t56 = f.my_piecewise3(t31, f.p.zeta_threshold, 1)
  t58 = 6 ** (0.1e1 / 0.3e1)
  t59 = params.alpha * t58
  t60 = jnp.pi ** 2
  t61 = t60 ** (0.1e1 / 0.3e1)
  t62 = t61 ** 2
  t63 = 0.1e1 / t62
  t65 = t37 ** 2
  t67 = r0 ** 2
  t69 = 0.1e1 / t21 / t67
  t73 = 0.1e1 + t59 * t63 * s0 * t65 * t69 / 0.24e2
  t74 = 0.1e1 / t73
  t77 = t74 + params.gamma * (0.1e1 - t74)
  t80 = 0.1e1 / t7 / r0
  t81 = t6 * t80
  t85 = t26 ** 2
  t90 = t3 * t6
  t91 = t90 * t80
  t92 = 0.1e1 / t13 * t1 * t91
  t94 = t4 * t81
  t96 = t10 ** 0.5e0
  t98 = t96 * t1 * t91
  t103 = t20 * t5 / t21 / r0
  t115 = t48 ** 2
  t131 = r0 * t55
  t132 = t73 ** 2
  t133 = 0.1e1 / t132
  t135 = t133 * params.alpha * t58
  t141 = t63 * s0 * t65 / t21 / t67 / r0
  t143 = params.gamma * t133
  vrho_0_ = t55 * t56 * t77 + r0 * (0.11073470983333333333333333333333333333333333333333e-2 * t4 * t81 * t29 + t12 / t85 * (-0.39359271665000000000000000000000000000000000000000e-1 * t92 - 0.18590165886666666666666666666666666666666666666667e-1 * t94 - 0.63665980925000000000000000000000000000000000000000e-2 * t98 - 0.51086165526666666666666666666666666666666666666667e-2 * t103) / t28 - 0.18311447306006545054854346104378990962041954983034e-3 * t41 * t1 * t90 * t80 * t51 - 0.58482236226346462072622386637590534819724553404281e0 * t41 * t43 / t115 * (-0.29149603883333333333333333333333333333333333333333e-1 * t92 - 0.10197154565000000000000000000000000000000000000000e-1 * t94 - 0.18581078242500000000000000000000000000000000000000e-2 * t98 - 0.27959640330000000000000000000000000000000000000000e-2 * t103) / t50) * t56 * t77 + t131 * t56 * (-t143 * t59 * t141 / 0.9e1 + t135 * t141 / 0.9e1)
  vsigma_0_ = t131 * t56 * (t143 * params.alpha * t58 * t63 * t65 * t69 / 0.24e2 - t135 * t63 * t65 * t69 / 0.24e2)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t7 / r0
  t10 = t6 * t9
  t13 = t4 * t6 / t7
  t14 = jnp.sqrt(t13)
  t17 = t13 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t7 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.37978500000000000000000000000000000000000000000000e1 * t14 + 0.89690000000000000000000000000000000000000000000000e0 * t13 + 0.20477500000000000000000000000000000000000000000000e0 * t17 + 0.12323500000000000000000000000000000000000000000000e0 * t25
  t30 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t27
  t31 = jnp.log(t30)
  t36 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t13
  t37 = t27 ** 2
  t38 = 0.1e1 / t37
  t39 = t36 * t38
  t41 = 0.1e1 / t14 * t1
  t42 = t3 * t6
  t43 = t42 * t9
  t44 = t41 * t43
  t46 = t4 * t10
  t48 = t13 ** 0.5e0
  t49 = t48 * t1
  t50 = t49 * t43
  t55 = t21 * t5 / t22 / r0
  t57 = -0.63297500000000000000000000000000000000000000000000e0 * t44 - 0.29896666666666666666666666666666666666666666666667e0 * t46 - 0.10238750000000000000000000000000000000000000000000e0 * t50 - 0.82156666666666666666666666666666666666666666666667e-1 * t55
  t58 = 0.1e1 / t30
  t59 = t57 * t58
  t62 = 0.1e1 <= f.p.zeta_threshold
  t63 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t65 = f.my_piecewise3(t62, t63 * f.p.zeta_threshold, 1)
  t68 = 2 ** (0.1e1 / 0.3e1)
  t72 = (0.2e1 * t65 - 0.2e1) / (0.2e1 * t68 - 0.2e1)
  t73 = t72 * t1
  t78 = 0.51785000000000000000000000000000000000000000000000e1 * t14 + 0.90577500000000000000000000000000000000000000000000e0 * t13 + 0.11003250000000000000000000000000000000000000000000e0 * t17 + 0.12417750000000000000000000000000000000000000000000e0 * t25
  t81 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t78
  t82 = jnp.log(t81)
  t88 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t13
  t89 = t72 * t88
  t90 = t78 ** 2
  t91 = 0.1e1 / t90
  t96 = -0.86308333333333333333333333333333333333333333333334e0 * t44 - 0.30192500000000000000000000000000000000000000000000e0 * t46 - 0.55016250000000000000000000000000000000000000000000e-1 * t50 - 0.82785000000000000000000000000000000000000000000000e-1 * t55
  t98 = 0.1e1 / t81
  t99 = t91 * t96 * t98
  t102 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t10 * t31 + 0.10000000000000000000000000000000000000000000000000e1 * t39 * t59 - 0.18311447306006545054854346104378990962041954983034e-3 * t73 * t42 * t9 * t82 - 0.58482236226346462072622386637590534819724553404280e0 * t89 * t99
  t103 = f.my_piecewise3(t62, f.p.zeta_threshold, 1)
  t105 = 6 ** (0.1e1 / 0.3e1)
  t106 = params.alpha * t105
  t107 = jnp.pi ** 2
  t108 = t107 ** (0.1e1 / 0.3e1)
  t109 = t108 ** 2
  t110 = 0.1e1 / t109
  t112 = t68 ** 2
  t114 = r0 ** 2
  t116 = 0.1e1 / t22 / t114
  t120 = 0.1e1 + t106 * t110 * s0 * t112 * t116 / 0.24e2
  t121 = 0.1e1 / t120
  t124 = t121 + params.gamma * (0.1e1 - t121)
  t132 = -0.621814e-1 * t36 * t31 + 0.19751673498613801407483339618206552048944131217655e-1 * t72 * t88 * t82
  t133 = t132 * t103
  t134 = t120 ** 2
  t135 = 0.1e1 / t134
  t137 = t135 * params.alpha * t105
  t138 = t110 * s0
  t139 = t114 * r0
  t141 = 0.1e1 / t22 / t139
  t142 = t112 * t141
  t143 = t138 * t142
  t145 = params.gamma * t135
  t146 = t145 * t106
  t149 = t137 * t143 / 0.9e1 - t146 * t143 / 0.9e1
  t153 = 0.1e1 / t7 / t114
  t154 = t6 * t153
  t166 = t57 ** 2
  t174 = t20 * t5 * t116
  t175 = 0.1e1 / t14 / t13 * t19 * t174
  t177 = t42 * t153
  t178 = t41 * t177
  t180 = t4 * t154
  t182 = t13 ** (-0.5e0)
  t184 = t182 * t19 * t174
  t186 = t49 * t177
  t189 = t21 * t5 * t116
  t195 = t37 ** 2
  t198 = t30 ** 2
  t213 = t96 ** 2
  t229 = t90 ** 2
  t232 = t81 ** 2
  t241 = r0 * t102
  t245 = r0 * t132
  t247 = 0.1e1 / t134 / t120
  t248 = params.alpha ** 2
  t250 = t105 ** 2
  t251 = t247 * t248 * t250
  t253 = 0.1e1 / t108 / t107
  t254 = s0 ** 2
  t256 = t114 ** 2
  t261 = t253 * t254 * t68 / t7 / t256 / t139
  t267 = t138 * t112 / t22 / t256
  t270 = params.gamma * t247
  t272 = t270 * t248 * t250
  v2rho2_0_ = 0.2e1 * t102 * t103 * t124 + 0.2e1 * t133 * t149 + r0 * (-0.14764627977777777777777777777777777777777777777777e-2 * t4 * t154 * t31 - 0.35616666666666666666666666666666666666666666666666e-1 * t4 * t6 * t9 * t38 * t59 - 0.20000000000000000000000000000000000000000000000000e1 * t36 / t37 / t27 * t166 * t58 + 0.10000000000000000000000000000000000000000000000000e1 * t39 * (-0.42198333333333333333333333333333333333333333333333e0 * t175 + 0.84396666666666666666666666666666666666666666666666e0 * t178 + 0.39862222222222222222222222222222222222222222222223e0 * t180 + 0.68258333333333333333333333333333333333333333333333e-1 * t184 + 0.13651666666666666666666666666666666666666666666667e0 * t186 + 0.13692777777777777777777777777777777777777777777778e0 * t189) * t58 + 0.16081979498692535066756296899072713062105388428051e2 * t36 / t195 * t166 / t198 + 0.24415263074675393406472461472505321282722606644045e-3 * t73 * t42 * t153 * t82 + 0.10843581300301739842632067522386578331157260943710e-1 * t72 * t4 * t10 * t99 + 0.11696447245269292414524477327518106963944910680856e1 * t89 / t90 / t78 * t213 * t98 - 0.58482236226346462072622386637590534819724553404280e0 * t89 * t91 * (-0.57538888888888888888888888888888888888888888888889e0 * t175 + 0.11507777777777777777777777777777777777777777777778e1 * t178 + 0.40256666666666666666666666666666666666666666666667e0 * t180 + 0.36677500000000000000000000000000000000000000000000e-1 * t184 + 0.73355000000000000000000000000000000000000000000000e-1 * t186 + 0.13797500000000000000000000000000000000000000000000e0 * t189) * t98 - 0.17315859105681463759666483083807725165579399831905e2 * t89 / t229 * t213 / t232) * t103 * t124 + 0.2e1 * t241 * t103 * t149 + t245 * t103 * (0.4e1 / 0.81e2 * t251 * t261 - 0.11e2 / 0.27e2 * t137 * t267 - 0.4e1 / 0.81e2 * t272 * t261 + 0.11e2 / 0.27e2 * t146 * t267)
  t280 = t110 * t112
  t283 = t145 * params.alpha
  t284 = t105 * t110
  t289 = t283 * t284 * t112 * t116 / 0.24e2 - t137 * t280 * t116 / 0.24e2
  t293 = t253 * t68
  t298 = t293 / t7 / t256 / t114 * s0
  v2rhosigma_0_ = t133 * t289 + t241 * t103 * t289 + t245 * t103 * (-t251 * t298 / 0.54e2 + t137 * t280 * t141 / 0.9e1 + t272 * t298 / 0.54e2 - t283 * t284 * t142 / 0.9e1)
  t314 = 0.1e1 / t7 / t256 / r0
  v2sigma2_0_ = t245 * t103 * (-t270 * t248 * t250 * t253 * t68 * t314 / 0.144e3 + t251 * t293 * t314 / 0.144e3)
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** 2
  t8 = r0 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t14 = t4 * t6 / t8
  t15 = jnp.sqrt(t14)
  t18 = t14 ** 0.15e1
  t20 = t1 ** 2
  t21 = t3 ** 2
  t22 = t20 * t21
  t23 = t8 ** 2
  t26 = t22 * t5 / t23
  t28 = 0.37978500000000000000000000000000000000000000000000e1 * t15 + 0.89690000000000000000000000000000000000000000000000e0 * t14 + 0.20477500000000000000000000000000000000000000000000e0 * t18 + 0.12323500000000000000000000000000000000000000000000e0 * t26
  t31 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t28
  t32 = jnp.log(t31)
  t36 = t4 * t6
  t38 = 0.1e1 / t8 / r0
  t39 = t28 ** 2
  t40 = 0.1e1 / t39
  t41 = t38 * t40
  t43 = 0.1e1 / t15 * t1
  t44 = t3 * t6
  t45 = t44 * t38
  t46 = t43 * t45
  t48 = t6 * t38
  t49 = t4 * t48
  t51 = t14 ** 0.5e0
  t52 = t51 * t1
  t53 = t52 * t45
  t58 = t22 * t5 / t23 / r0
  t60 = -0.63297500000000000000000000000000000000000000000000e0 * t46 - 0.29896666666666666666666666666666666666666666666667e0 * t49 - 0.10238750000000000000000000000000000000000000000000e0 * t53 - 0.82156666666666666666666666666666666666666666666667e-1 * t58
  t61 = 0.1e1 / t31
  t62 = t60 * t61
  t67 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t14
  t69 = 0.1e1 / t39 / t28
  t70 = t67 * t69
  t71 = t60 ** 2
  t72 = t71 * t61
  t75 = t67 * t40
  t78 = 0.1e1 / t15 / t14 * t20
  t79 = t21 * t5
  t81 = 0.1e1 / t23 / t7
  t82 = t79 * t81
  t83 = t78 * t82
  t85 = t44 * t10
  t86 = t43 * t85
  t88 = t4 * t11
  t90 = t14 ** (-0.5e0)
  t91 = t90 * t20
  t92 = t91 * t82
  t94 = t52 * t85
  t97 = t22 * t5 * t81
  t99 = -0.42198333333333333333333333333333333333333333333333e0 * t83 + 0.84396666666666666666666666666666666666666666666666e0 * t86 + 0.39862222222222222222222222222222222222222222222223e0 * t88 + 0.68258333333333333333333333333333333333333333333333e-1 * t92 + 0.13651666666666666666666666666666666666666666666667e0 * t94 + 0.13692777777777777777777777777777777777777777777778e0 * t97
  t100 = t99 * t61
  t103 = t39 ** 2
  t104 = 0.1e1 / t103
  t105 = t67 * t104
  t106 = t31 ** 2
  t107 = 0.1e1 / t106
  t108 = t71 * t107
  t111 = 0.1e1 <= f.p.zeta_threshold
  t112 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t114 = f.my_piecewise3(t111, t112 * f.p.zeta_threshold, 1)
  t117 = 2 ** (0.1e1 / 0.3e1)
  t121 = (0.2e1 * t114 - 0.2e1) / (0.2e1 * t117 - 0.2e1)
  t122 = t121 * t1
  t127 = 0.51785000000000000000000000000000000000000000000000e1 * t15 + 0.90577500000000000000000000000000000000000000000000e0 * t14 + 0.11003250000000000000000000000000000000000000000000e0 * t18 + 0.12417750000000000000000000000000000000000000000000e0 * t26
  t130 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t127
  t131 = jnp.log(t130)
  t136 = t121 * t4
  t137 = t127 ** 2
  t138 = 0.1e1 / t137
  t143 = -0.86308333333333333333333333333333333333333333333334e0 * t46 - 0.30192500000000000000000000000000000000000000000000e0 * t49 - 0.55016250000000000000000000000000000000000000000000e-1 * t53 - 0.82785000000000000000000000000000000000000000000000e-1 * t58
  t145 = 0.1e1 / t130
  t146 = t138 * t143 * t145
  t151 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t14
  t152 = t121 * t151
  t154 = 0.1e1 / t137 / t127
  t155 = t143 ** 2
  t157 = t154 * t155 * t145
  t166 = -0.57538888888888888888888888888888888888888888888889e0 * t83 + 0.11507777777777777777777777777777777777777777777778e1 * t86 + 0.40256666666666666666666666666666666666666666666667e0 * t88 + 0.36677500000000000000000000000000000000000000000000e-1 * t92 + 0.73355000000000000000000000000000000000000000000000e-1 * t94 + 0.13797500000000000000000000000000000000000000000000e0 * t97
  t168 = t138 * t166 * t145
  t171 = t137 ** 2
  t172 = 0.1e1 / t171
  t174 = t130 ** 2
  t175 = 0.1e1 / t174
  t176 = t172 * t155 * t175
  t179 = -0.14764627977777777777777777777777777777777777777777e-2 * t4 * t11 * t32 - 0.35616666666666666666666666666666666666666666666666e-1 * t36 * t41 * t62 - 0.20000000000000000000000000000000000000000000000000e1 * t70 * t72 + 0.10000000000000000000000000000000000000000000000000e1 * t75 * t100 + 0.16081979498692535066756296899072713062105388428051e2 * t105 * t108 + 0.24415263074675393406472461472505321282722606644045e-3 * t122 * t44 * t10 * t131 + 0.10843581300301739842632067522386578331157260943710e-1 * t136 * t48 * t146 + 0.11696447245269292414524477327518106963944910680856e1 * t152 * t157 - 0.58482236226346462072622386637590534819724553404280e0 * t152 * t168 - 0.17315859105681463759666483083807725165579399831905e2 * t152 * t176
  t180 = f.my_piecewise3(t111, f.p.zeta_threshold, 1)
  t182 = 6 ** (0.1e1 / 0.3e1)
  t183 = params.alpha * t182
  t184 = jnp.pi ** 2
  t185 = t184 ** (0.1e1 / 0.3e1)
  t186 = t185 ** 2
  t187 = 0.1e1 / t186
  t189 = t117 ** 2
  t194 = 0.1e1 + t183 * t187 * s0 * t189 * t81 / 0.24e2
  t195 = 0.1e1 / t194
  t198 = t195 + params.gamma * (0.1e1 - t195)
  t212 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t48 * t32 + 0.10000000000000000000000000000000000000000000000000e1 * t75 * t62 - 0.18311447306006545054854346104378990962041954983034e-3 * t122 * t44 * t38 * t131 - 0.58482236226346462072622386637590534819724553404280e0 * t152 * t146
  t214 = t194 ** 2
  t215 = 0.1e1 / t214
  t217 = t215 * params.alpha * t182
  t218 = t187 * s0
  t219 = t7 * r0
  t221 = 0.1e1 / t23 / t219
  t223 = t218 * t189 * t221
  t226 = params.gamma * t215 * t183
  t229 = t217 * t223 / 0.9e1 - t226 * t223 / 0.9e1
  t237 = -0.621814e-1 * t67 * t32 + 0.19751673498613801407483339618206552048944131217655e-1 * t121 * t151 * t131
  t240 = 0.1e1 / t214 / t194
  t241 = params.alpha ** 2
  t243 = t182 ** 2
  t244 = t240 * t241 * t243
  t247 = s0 ** 2
  t248 = 0.1e1 / t185 / t184 * t247
  t249 = t7 ** 2
  t254 = t248 * t117 / t8 / t249 / t219
  t260 = t218 * t189 / t23 / t249
  t265 = params.gamma * t240 * t241 * t243
  t270 = 0.4e1 / 0.81e2 * t244 * t254 - 0.11e2 / 0.27e2 * t217 * t260 - 0.4e1 / 0.81e2 * t265 * t254 + 0.11e2 / 0.27e2 * t226 * t260
  t288 = t71 * t60
  t304 = 0.1e1 / t249
  t305 = 0.1e1 / t15 / t26 * t2 * t304 / 0.4e1
  t307 = t79 * t221
  t308 = t78 * t307
  t311 = 0.1e1 / t8 / t219
  t312 = t44 * t311
  t313 = t43 * t312
  t315 = t6 * t311
  t316 = t4 * t315
  t318 = t14 ** (-0.15e1)
  t320 = t318 * t2 * t304
  t322 = t91 * t307
  t324 = t52 * t312
  t327 = t22 * t5 * t221
  t348 = -0.32530743900905219527896202567159734993471782831130e-1 * t136 * t48 * t157 - 0.21687162600603479685264135044773156662314521887420e-1 * t136 * t11 * t146 + 0.16265371950452609763948101283579867496735891415565e-1 * t136 * t48 * t168 + 0.48159733137676571081572406076840235616767705782485e0 * t136 * t48 * t176 + 0.51726012919273400298984252201052768390886626637712e3 * t67 / t103 / t39 * t288 / t106 / t31 - 0.96491876992155210400537781394436278372632330568306e2 * t67 / t103 / t28 * t288 * t107 + 0.10000000000000000000000000000000000000000000000000e1 * t75 * (-0.25319000000000000000000000000000000000000000000000e1 * t305 + 0.16879333333333333333333333333333333333333333333333e1 * t308 - 0.19692555555555555555555555555555555555555555555555e1 * t313 - 0.93011851851851851851851851851851851851851851851854e0 * t316 + 0.13651666666666666666666666666666666666666666666667e0 * t320 - 0.27303333333333333333333333333333333333333333333333e0 * t322 - 0.31853888888888888888888888888888888888888888888890e0 * t324 - 0.36514074074074074074074074074074074074074074074075e0 * t327) * t61 + 0.48245938496077605200268890697218139186316165284153e2 * t105 * t99 * t107 * t60 + 0.60000000000000000000000000000000000000000000000000e1 * t105 * t288 * t61 - 0.60000000000000000000000000000000000000000000000000e1 * t70 * t62 * t99 - 0.51947577317044391278999449251423175496738199495715e2 * t152 * t172 * t166 * t175 * t143
  t349 = t155 * t143
  t408 = -0.35089341735807877243573431982554320891834732042568e1 * t152 * t172 * t349 * t145 + 0.35089341735807877243573431982554320891834732042568e1 * t152 * t154 * t143 * t145 * t166 - 0.53424999999999999999999999999999999999999999999999e-1 * t36 * t41 * t100 - 0.85917975471764868594145516183295969534298037676861e0 * t36 * t38 * t104 * t108 + 0.71233333333333333333333333333333333333333333333331e-1 * t36 * t10 * t40 * t62 + 0.34450798614814814814814814814814814814814814814813e-2 * t4 * t315 * t32 + 0.10389515463408878255799889850284635099347639899143e3 * t152 / t171 / t127 * t349 * t175 - 0.58482236226346462072622386637590534819724553404280e0 * t152 * t138 * (-0.34523333333333333333333333333333333333333333333333e1 * t305 + 0.23015555555555555555555555555555555555555555555556e1 * t308 - 0.26851481481481481481481481481481481481481481481482e1 * t313 - 0.93932222222222222222222222222222222222222222222223e0 * t316 + 0.73355000000000000000000000000000000000000000000000e-1 * t320 - 0.14671000000000000000000000000000000000000000000000e0 * t322 - 0.17116166666666666666666666666666666666666666666667e0 * t324 - 0.36793333333333333333333333333333333333333333333333e0 * t327) * t145 - 0.10254018858216406658218194626490193680059335835414e4 * t152 / t171 / t137 * t349 / t174 / t130 + 0.10685000000000000000000000000000000000000000000000e0 * t36 * t38 * t69 * t72 - 0.56968947174242584615102410102512416326352748836105e-3 * t122 * t44 * t311 * t131
  t422 = t214 ** 2
  t423 = 0.1e1 / t422
  t424 = t241 * params.alpha
  t426 = t184 ** 2
  t430 = t249 ** 2
  t433 = 0.1e1 / t426 * t247 * s0 / t430 / t219
  t439 = t248 * t117 / t8 / t430
  t446 = t218 * t189 / t23 / t249 / r0
  v3rho3_0_ = 0.3e1 * t179 * t180 * t198 + 0.6e1 * t212 * t180 * t229 + 0.3e1 * t237 * t180 * t270 + r0 * (t348 + t408) * t180 * t198 + 0.3e1 * r0 * t179 * t180 * t229 + 0.3e1 * r0 * t212 * t180 * t270 + r0 * t237 * t180 * (0.16e2 / 0.81e2 * t423 * t424 * t433 - 0.44e2 / 0.81e2 * t244 * t439 + 0.154e3 / 0.81e2 * t217 * t446 - 0.16e2 / 0.81e2 * params.gamma * t423 * t424 * t433 + 0.44e2 / 0.81e2 * t265 * t439 - 0.154e3 / 0.81e2 * t226 * t446)

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 0.1e1 <= f.p.zeta_threshold
  t2 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t4 = f.my_piecewise3(t1, t2 * f.p.zeta_threshold, 1)
  t7 = 2 ** (0.1e1 / 0.3e1)
  t11 = (0.2e1 * t4 - 0.2e1) / (0.2e1 * t7 - 0.2e1)
  t12 = 3 ** (0.1e1 / 0.3e1)
  t13 = 0.1e1 / jnp.pi
  t14 = t13 ** (0.1e1 / 0.3e1)
  t15 = t12 * t14
  t16 = t11 * t15
  t17 = 4 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t21 = 0.1e1 / t19 / r0
  t22 = t18 * t21
  t25 = t15 * t18 / t19
  t26 = jnp.sqrt(t25)
  t29 = t25 ** 0.15e1
  t31 = t12 ** 2
  t32 = t14 ** 2
  t33 = t31 * t32
  t34 = t19 ** 2
  t37 = t33 * t17 / t34
  t39 = 0.51785000000000000000000000000000000000000000000000e1 * t26 + 0.90577500000000000000000000000000000000000000000000e0 * t25 + 0.11003250000000000000000000000000000000000000000000e0 * t29 + 0.12417750000000000000000000000000000000000000000000e0 * t37
  t40 = t39 ** 2
  t41 = t40 * t39
  t42 = 0.1e1 / t41
  t44 = 0.1e1 / t26 * t12
  t45 = t14 * t18
  t46 = t45 * t21
  t47 = t44 * t46
  t49 = t15 * t22
  t51 = t25 ** 0.5e0
  t52 = t51 * t12
  t53 = t52 * t46
  t58 = t33 * t17 / t34 / r0
  t60 = -0.86308333333333333333333333333333333333333333333334e0 * t47 - 0.30192500000000000000000000000000000000000000000000e0 * t49 - 0.55016250000000000000000000000000000000000000000000e-1 * t53 - 0.82785000000000000000000000000000000000000000000000e-1 * t58
  t61 = t60 ** 2
  t65 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t39
  t66 = 0.1e1 / t65
  t67 = t42 * t61 * t66
  t71 = r0 ** 2
  t73 = 0.1e1 / t19 / t71
  t74 = t18 * t73
  t75 = 0.1e1 / t40
  t77 = t75 * t60 * t66
  t83 = 0.1e1 / t26 / t25 * t31
  t84 = t32 * t17
  t86 = 0.1e1 / t34 / t71
  t87 = t84 * t86
  t88 = t83 * t87
  t90 = t45 * t73
  t91 = t44 * t90
  t93 = t15 * t74
  t95 = t25 ** (-0.5e0)
  t96 = t95 * t31
  t97 = t96 * t87
  t99 = t52 * t90
  t102 = t33 * t17 * t86
  t104 = -0.57538888888888888888888888888888888888888888888889e0 * t88 + 0.11507777777777777777777777777777777777777777777778e1 * t91 + 0.40256666666666666666666666666666666666666666666667e0 * t93 + 0.36677500000000000000000000000000000000000000000000e-1 * t97 + 0.73355000000000000000000000000000000000000000000000e-1 * t99 + 0.13797500000000000000000000000000000000000000000000e0 * t102
  t106 = t75 * t104 * t66
  t110 = t40 ** 2
  t111 = 0.1e1 / t110
  t112 = t111 * t61
  t113 = t65 ** 2
  t114 = 0.1e1 / t113
  t115 = t112 * t114
  t120 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t25
  t125 = 0.37978500000000000000000000000000000000000000000000e1 * t26 + 0.89690000000000000000000000000000000000000000000000e0 * t25 + 0.20477500000000000000000000000000000000000000000000e0 * t29 + 0.12323500000000000000000000000000000000000000000000e0 * t37
  t126 = t125 ** 2
  t127 = t126 ** 2
  t129 = 0.1e1 / t127 / t126
  t130 = t120 * t129
  t135 = -0.63297500000000000000000000000000000000000000000000e0 * t47 - 0.29896666666666666666666666666666666666666666666667e0 * t49 - 0.10238750000000000000000000000000000000000000000000e0 * t53 - 0.82156666666666666666666666666666666666666666666667e-1 * t58
  t136 = t135 ** 2
  t137 = t136 * t135
  t140 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t125
  t141 = t140 ** 2
  t143 = 0.1e1 / t141 / t140
  t144 = t137 * t143
  t148 = 0.1e1 / t127 / t125
  t149 = t120 * t148
  t150 = 0.1e1 / t141
  t151 = t137 * t150
  t154 = 0.1e1 / t126
  t155 = t120 * t154
  t159 = 0.1e1 / t26 / t37 * t13 / 0.4e1
  t160 = t71 ** 2
  t161 = 0.1e1 / t160
  t162 = t159 * t161
  t164 = t71 * r0
  t166 = 0.1e1 / t34 / t164
  t167 = t84 * t166
  t168 = t83 * t167
  t171 = 0.1e1 / t19 / t164
  t172 = t45 * t171
  t173 = t44 * t172
  t175 = t18 * t171
  t176 = t15 * t175
  t178 = t25 ** (-0.15e1)
  t179 = t178 * t13
  t180 = t179 * t161
  t182 = t96 * t167
  t184 = t52 * t172
  t187 = t33 * t17 * t166
  t189 = -0.25319000000000000000000000000000000000000000000000e1 * t162 + 0.16879333333333333333333333333333333333333333333333e1 * t168 - 0.19692555555555555555555555555555555555555555555555e1 * t173 - 0.93011851851851851851851851851851851851851851851854e0 * t176 + 0.13651666666666666666666666666666666666666666666667e0 * t180 - 0.27303333333333333333333333333333333333333333333333e0 * t182 - 0.31853888888888888888888888888888888888888888888890e0 * t184 - 0.36514074074074074074074074074074074074074074074075e0 * t187
  t190 = 0.1e1 / t140
  t191 = t189 * t190
  t194 = 0.1e1 / t127
  t195 = t120 * t194
  t202 = -0.42198333333333333333333333333333333333333333333333e0 * t88 + 0.84396666666666666666666666666666666666666666666666e0 * t91 + 0.39862222222222222222222222222222222222222222222223e0 * t93 + 0.68258333333333333333333333333333333333333333333333e-1 * t97 + 0.13651666666666666666666666666666666666666666666667e0 * t99 + 0.13692777777777777777777777777777777777777777777778e0 * t102
  t207 = t137 * t190
  t210 = t126 * t125
  t211 = 0.1e1 / t210
  t212 = t120 * t211
  t213 = t135 * t190
  t218 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t25
  t219 = t11 * t218
  t221 = t114 * t60
  t225 = -0.32530743900905219527896202567159734993471782831130e-1 * t16 * t22 * t67 - 0.21687162600603479685264135044773156662314521887420e-1 * t16 * t74 * t77 + 0.16265371950452609763948101283579867496735891415565e-1 * t16 * t22 * t106 + 0.48159733137676571081572406076840235616767705782485e0 * t16 * t22 * t115 + 0.51726012919273400298984252201052768390886626637712e3 * t130 * t144 - 0.96491876992155210400537781394436278372632330568306e2 * t149 * t151 + 0.10000000000000000000000000000000000000000000000000e1 * t155 * t191 + 0.48245938496077605200268890697218139186316165284153e2 * t195 * t202 * t150 * t135 + 0.60000000000000000000000000000000000000000000000000e1 * t195 * t207 - 0.60000000000000000000000000000000000000000000000000e1 * t212 * t213 * t202 - 0.51947577317044391278999449251423175496738199495715e2 * t219 * t111 * t104 * t221
  t226 = t61 * t60
  t228 = t111 * t226 * t66
  t231 = t42 * t60
  t232 = t66 * t104
  t236 = t15 * t18
  t237 = t21 * t154
  t238 = t202 * t190
  t242 = t21 * t194
  t243 = t136 * t150
  t247 = t73 * t154
  t251 = jnp.log(t140)
  t256 = 0.1e1 / t110 / t39
  t258 = t256 * t226 * t114
  t269 = -0.34523333333333333333333333333333333333333333333333e1 * t162 + 0.23015555555555555555555555555555555555555555555556e1 * t168 - 0.26851481481481481481481481481481481481481481481482e1 * t173 - 0.93932222222222222222222222222222222222222222222223e0 * t176 + 0.73355000000000000000000000000000000000000000000000e-1 * t180 - 0.14671000000000000000000000000000000000000000000000e0 * t182 - 0.17116166666666666666666666666666666666666666666667e0 * t184 - 0.36793333333333333333333333333333333333333333333333e0 * t187
  t271 = t75 * t269 * t66
  t275 = 0.1e1 / t110 / t40
  t278 = 0.1e1 / t113 / t65
  t279 = t275 * t226 * t278
  t283 = t136 * t190
  t287 = t11 * t12
  t288 = jnp.log(t65)
  t293 = -0.35089341735807877243573431982554320891834732042568e1 * t219 * t228 + 0.35089341735807877243573431982554320891834732042568e1 * t219 * t231 * t232 - 0.53424999999999999999999999999999999999999999999999e-1 * t236 * t237 * t238 - 0.85917975471764868594145516183295969534298037676861e0 * t236 * t242 * t243 + 0.71233333333333333333333333333333333333333333333331e-1 * t236 * t247 * t213 + 0.34450798614814814814814814814814814814814814814813e-2 * t15 * t175 * t251 + 0.10389515463408878255799889850284635099347639899143e3 * t219 * t258 - 0.58482236226346462072622386637590534819724553404280e0 * t219 * t271 - 0.10254018858216406658218194626490193680059335835414e4 * t219 * t279 + 0.10685000000000000000000000000000000000000000000000e0 * t236 * t21 * t211 * t283 - 0.56968947174242584615102410102512416326352748836105e-3 * t287 * t45 * t171 * t288
  t294 = t225 + t293
  t295 = f.my_piecewise3(t1, f.p.zeta_threshold, 1)
  t297 = 6 ** (0.1e1 / 0.3e1)
  t298 = params.alpha * t297
  t299 = jnp.pi ** 2
  t300 = t299 ** (0.1e1 / 0.3e1)
  t301 = t300 ** 2
  t302 = 0.1e1 / t301
  t304 = t7 ** 2
  t309 = 0.1e1 + t298 * t302 * s0 * t304 * t86 / 0.24e2
  t310 = 0.1e1 / t309
  t313 = t310 + params.gamma * (0.1e1 - t310)
  t341 = -0.14764627977777777777777777777777777777777777777777e-2 * t15 * t74 * t251 - 0.35616666666666666666666666666666666666666666666666e-1 * t236 * t237 * t213 - 0.20000000000000000000000000000000000000000000000000e1 * t212 * t283 + 0.10000000000000000000000000000000000000000000000000e1 * t155 * t238 + 0.16081979498692535066756296899072713062105388428051e2 * t195 * t243 + 0.24415263074675393406472461472505321282722606644045e-3 * t287 * t45 * t73 * t288 + 0.10843581300301739842632067522386578331157260943710e-1 * t16 * t22 * t77 + 0.11696447245269292414524477327518106963944910680856e1 * t219 * t67 - 0.58482236226346462072622386637590534819724553404280e0 * t219 * t106 - 0.17315859105681463759666483083807725165579399831905e2 * t219 * t115
  t343 = t309 ** 2
  t344 = 0.1e1 / t343
  t346 = t344 * params.alpha * t297
  t347 = t302 * s0
  t349 = t347 * t304 * t166
  t352 = params.gamma * t344 * t298
  t355 = t346 * t349 / 0.9e1 - t352 * t349 / 0.9e1
  t369 = 0.11073470983333333333333333333333333333333333333333e-2 * t15 * t22 * t251 + 0.10000000000000000000000000000000000000000000000000e1 * t155 * t213 - 0.18311447306006545054854346104378990962041954983034e-3 * t287 * t45 * t21 * t288 - 0.58482236226346462072622386637590534819724553404280e0 * t219 * t77
  t372 = 0.1e1 / t343 / t309
  t373 = params.alpha ** 2
  t375 = t297 ** 2
  t376 = t372 * t373 * t375
  t379 = s0 ** 2
  t380 = 0.1e1 / t300 / t299 * t379
  t385 = t380 * t7 / t19 / t160 / t164
  t389 = 0.1e1 / t34 / t160
  t391 = t347 * t304 * t389
  t396 = params.gamma * t372 * t373 * t375
  t401 = 0.4e1 / 0.81e2 * t376 * t385 - 0.11e2 / 0.27e2 * t346 * t391 - 0.4e1 / 0.81e2 * t396 * t385 + 0.11e2 / 0.27e2 * t352 * t391
  t409 = -0.621814e-1 * t120 * t251 + 0.19751673498613801407483339618206552048944131217655e-1 * t11 * t218 * t288
  t411 = t343 ** 2
  t412 = 0.1e1 / t411
  t413 = t373 * params.alpha
  t414 = t412 * t413
  t415 = t299 ** 2
  t416 = 0.1e1 / t415
  t418 = t416 * t379 * s0
  t419 = t160 ** 2
  t422 = t418 / t419 / t164
  t428 = t380 * t7 / t19 / t419
  t431 = t160 * r0
  t435 = t347 * t304 / t34 / t431
  t439 = params.gamma * t412 * t413
  t446 = 0.16e2 / 0.81e2 * t414 * t422 - 0.44e2 / 0.81e2 * t376 * t428 + 0.154e3 / 0.81e2 * t346 * t435 - 0.16e2 / 0.81e2 * t439 * t422 + 0.44e2 / 0.81e2 * t396 * t428 - 0.154e3 / 0.81e2 * t352 * t435
  t459 = 0.1e1 / t19 / t160
  t495 = -0.34367190188705947437658206473318387813719215070744e1 * t49 * t194 * t202 * t150 * t135 + 0.42740000000000000000000000000000000000000000000000e0 * t49 * t211 * t135 * t238 + 0.18989649058080861538367470034170805442117582945368e-2 * t287 * t45 * t459 * t288 + 0.62337092780453269534799339101707810596085839394858e3 * t219 * t256 * t104 * t114 * t61 + 0.14246666666666666666666666666666666666666666666666e0 * t236 * t247 * t238 + 0.22911460125803964958438804315545591875812810047162e1 * t236 * t73 * t194 * t243 - 0.22161481481481481481481481481481481481481481481481e0 * t236 * t171 * t154 * t213 - 0.28493333333333333333333333333333333333333333333333e0 * t236 * t73 * t211 * t283 - 0.21053605041484726346144059189532592535100839225540e2 * t219 * t112 * t232 + 0.46785788981077169658097909310072427855779642723424e1 * t219 * t231 * t66 * t269 - 0.69263436422725855038665932335230900662317599327620e2 * t219 * t111 * t269 * t221
  t522 = t18 * t459
  t539 = t136 ** 2
  t543 = -0.61524113149298439949309167758941162080356015012483e4 * t219 * t275 * t104 * t278 * t61 - 0.42740000000000000000000000000000000000000000000000e0 * t236 * t242 * t207 - 0.71233333333333333333333333333333333333333333333332e-1 * t236 * t237 * t191 - 0.36846163202829085479643115651216588683774907041596e2 * t236 * t21 * t129 * t144 + 0.68734380377411894875316412946636775627438430141488e1 * t236 * t21 * t148 * t151 - 0.80000000000000000000000000000000000000000000000000e1 * t212 * t191 * t135 + 0.31035607751564040179390551320631661034531975982628e4 * t130 * t136 * t143 * t202 - 0.11483599538271604938271604938271604938271604938271e-1 * t15 * t522 * t251 + 0.36000000000000000000000000000000000000000000000000e2 * t195 * t283 * t202 + 0.64327917994770140267025187596290852248421553712204e2 * t195 * t189 * t150 * t135 - 0.57895126195293126240322668836661767023579398340984e3 * t149 * t243 * t202 - 0.62071215503128080358781102641263322069063951965254e4 * t120 / t127 / t210 * t539 * t143
  t548 = t202 ** 2
  t555 = t127 ** 2
  t558 = t141 ** 2
  t570 = 0.1e1 / t19 / t431
  t572 = 0.1e1 / t26 * r0 * t570 * t236 / 0.48e2
  t574 = 0.1e1 / t431
  t575 = t159 * t574
  t577 = t84 * t389
  t578 = t83 * t577
  t580 = t45 * t459
  t581 = t44 * t580
  t583 = t15 * t522
  t585 = t25 ** (-0.25e1)
  t588 = t585 * t13 * t570 * t236
  t590 = t179 * t574
  t592 = t96 * t577
  t594 = t52 * t580
  t597 = t33 * t17 * t389
  t608 = t61 ** 2
  t628 = t104 ** 2
  t641 = 0.57895126195293126240322668836661767023579398340984e3 * t130 * t539 * t150 + 0.48245938496077605200268890697218139186316165284153e2 * t195 * t548 * t150 - 0.24000000000000000000000000000000000000000000000000e2 * t149 * t539 * t190 + 0.24955700379505800914252936827276051226357058527653e5 * t120 / t555 * t539 / t558 + 0.10000000000000000000000000000000000000000000000000e1 * t155 * (-0.21099166666666666666666666666666666666666666666667e1 * t572 + 0.20255200000000000000000000000000000000000000000000e2 * t575 - 0.75019259259259259259259259259259259259259259259258e1 * t578 + 0.65641851851851851851851851851851851851851851851850e1 * t581 + 0.31003950617283950617283950617283950617283950617285e1 * t583 + 0.68258333333333333333333333333333333333333333333335e-1 * t588 - 0.10921333333333333333333333333333333333333333333333e1 * t590 + 0.12134814814814814814814814814814814814814814814815e1 * t592 + 0.10617962962962962962962962962962962962962962962963e1 * t594 + 0.13388493827160493827160493827160493827160493827161e1 * t597) * t190 - 0.60000000000000000000000000000000000000000000000000e1 * t212 * t548 * t190 + 0.12304822629859687989861833551788232416071203002497e5 * t219 / t110 / t41 * t608 * t278 - 0.58482236226346462072622386637590534819724553404280e0 * t219 * t75 * (-0.28769444444444444444444444444444444444444444444444e1 * t572 + 0.27618666666666666666666666666666666666666666666667e2 * t575 - 0.10229135802469135802469135802469135802469135802469e2 * t578 + 0.89504938271604938271604938271604938271604938271607e1 * t581 + 0.31310740740740740740740740740740740740740740740741e1 * t583 + 0.36677500000000000000000000000000000000000000000000e-1 * t588 - 0.58684000000000000000000000000000000000000000000000e0 * t590 + 0.65204444444444444444444444444444444444444444444445e0 * t592 + 0.57053888888888888888888888888888888888888888888890e0 * t594 + 0.13490888888888888888888888888888888888888888888889e1 * t597) * t66 + 0.35089341735807877243573431982554320891834732042568e1 * t219 * t42 * t628 * t66 - 0.51947577317044391278999449251423175496738199495715e2 * t219 * t111 * t628 * t114 + 0.14035736694323150897429372793021728356733892817027e2 * t219 * t256 * t608 * t66
  t646 = t110 ** 2
  t649 = t113 ** 2
  t654 = t11 * t236
  t691 = -0.62337092780453269534799339101707810596085839394858e3 * t219 * t275 * t608 * t114 - 0.91082604192152556048340974007871726131433263376469e5 * t219 / t646 * t608 / t649 - 0.13012297560362087811158481026863893997388713132452e0 * t654 * t21 * t42 * t60 * t66 * t104 + 0.19263893255070628432628962430736094246707082312995e1 * t654 * t21 * t111 * t104 * t114 * t60 + 0.67471172535210825687488420139294265171645179205307e-1 * t16 * t175 * t77 - 0.38527786510141256865257924861472188493414164625988e1 * t16 * t22 * t258 - 0.43374325201206959370528270089546313324629043774840e-1 * t16 * t74 * t106 - 0.12842595503380418955085974953824062831138054875329e1 * t16 * t74 * t115 + 0.21687162600603479685264135044773156662314521887420e-1 * t16 * t22 * t271 + 0.38025319932552508024225805073234468230220037056326e2 * t16 * t22 * t279 + 0.86748650402413918741056540179092626649258087549680e-1 * t16 * t74 * t67 + 0.13012297560362087811158481026863893997388713132452e0 * t16 * t22 * t228
  t711 = 0.1e1 / t411 / t309
  t712 = t373 ** 2
  t714 = t379 ** 2
  t717 = t160 * t71
  t720 = 0.1e1 / t34 / t419 / t717
  t728 = t418 / t419 / t160
  t735 = t380 * t7 / t19 / t419 / r0
  t741 = t347 * t304 / t34 / t717
  v4rho4_0_ = 0.4e1 * t294 * t295 * t313 + 0.12e2 * t341 * t295 * t355 + 0.12e2 * t369 * t295 * t401 + 0.4e1 * t409 * t295 * t446 + r0 * (t495 + t543 + t641 + t691) * t295 * t313 + 0.4e1 * r0 * t294 * t295 * t355 + 0.6e1 * r0 * t341 * t295 * t401 + 0.4e1 * r0 * t369 * t295 * t446 + r0 * t409 * t295 * (0.64e2 / 0.729e3 * t711 * t712 * t416 * t714 * t720 * t297 * t302 * t304 - 0.352e3 / 0.81e2 * t414 * t728 + 0.3916e4 / 0.729e3 * t376 * t735 - 0.2618e4 / 0.243e3 * t346 * t741 - 0.64e2 / 0.729e3 * params.gamma * t711 * t712 * t416 * t714 * t720 * t297 * t302 * t304 + 0.352e3 / 0.81e2 * t439 * t728 - 0.3916e4 / 0.729e3 * t396 * t735 + 0.2618e4 / 0.243e3 * t352 * t741)

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t14 = t4 * t6 / t8
  t15 = jnp.sqrt(t14)
  t18 = t14 ** 0.15e1
  t20 = t1 ** 2
  t21 = t3 ** 2
  t22 = t20 * t21
  t23 = t8 ** 2
  t26 = t22 * t5 / t23
  t28 = 0.37978500000000000000000000000000000000000000000000e1 * t15 + 0.89690000000000000000000000000000000000000000000000e0 * t14 + 0.20477500000000000000000000000000000000000000000000e0 * t18 + 0.12323500000000000000000000000000000000000000000000e0 * t26
  t31 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t28
  t32 = jnp.log(t31)
  t35 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t11 * t32
  t37 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t14
  t38 = t28 ** 2
  t39 = 0.1e1 / t38
  t40 = t37 * t39
  t42 = 0.1e1 / t15 * t1
  t43 = t3 * t6
  t44 = t43 * t10
  t45 = t42 * t44
  t47 = t4 * t11
  t49 = t14 ** 0.5e0
  t50 = t49 * t1
  t51 = t50 * t44
  t56 = t22 * t5 / t23 / t7
  t58 = -0.63297500000000000000000000000000000000000000000000e0 * t45 - 0.29896666666666666666666666666666666666666666666667e0 * t47 - 0.10238750000000000000000000000000000000000000000000e0 * t51 - 0.82156666666666666666666666666666666666666666666667e-1 * t56
  t59 = 0.1e1 / t31
  t60 = t58 * t59
  t62 = 0.10000000000000000000000000000000000000000000000000e1 * t40 * t60
  t63 = r0 - r1
  t64 = t63 ** 2
  t65 = t64 * t63
  t66 = t7 ** 2
  t67 = t66 ** 2
  t68 = 0.1e1 / t67
  t69 = t65 * t68
  t70 = 0.1e1 / t7
  t71 = t63 * t70
  t72 = 0.1e1 + t71
  t73 = t72 <= f.p.zeta_threshold
  t74 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t75 = t74 * f.p.zeta_threshold
  t76 = t72 ** (0.1e1 / 0.3e1)
  t78 = f.my_piecewise3(t73, t75, t76 * t72)
  t79 = 0.1e1 - t71
  t80 = t79 <= f.p.zeta_threshold
  t81 = t79 ** (0.1e1 / 0.3e1)
  t83 = f.my_piecewise3(t80, t75, t81 * t79)
  t85 = 2 ** (0.1e1 / 0.3e1)
  t88 = 0.1e1 / (0.2e1 * t85 - 0.2e1)
  t89 = (t78 + t83 - 0.2e1) * t88
  t91 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t14
  t96 = 0.70594500000000000000000000000000000000000000000000e1 * t15 + 0.15494250000000000000000000000000000000000000000000e1 * t14 + 0.42077500000000000000000000000000000000000000000000e0 * t18 + 0.15629250000000000000000000000000000000000000000000e0 * t26
  t99 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t96
  t100 = jnp.log(t99)
  t104 = 0.621814e-1 * t37 * t32
  t106 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t14
  t111 = 0.51785000000000000000000000000000000000000000000000e1 * t15 + 0.90577500000000000000000000000000000000000000000000e0 * t14 + 0.11003250000000000000000000000000000000000000000000e0 * t18 + 0.12417750000000000000000000000000000000000000000000e0 * t26
  t114 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t111
  t115 = jnp.log(t114)
  t116 = t106 * t115
  t118 = -0.3109070e-1 * t91 * t100 + t104 - 0.19751673498613801407483339618206552048944131217655e-1 * t116
  t119 = t89 * t118
  t121 = 0.4e1 * t69 * t119
  t122 = t64 ** 2
  t124 = 0.1e1 / t67 / t7
  t125 = t122 * t124
  t127 = 0.4e1 * t125 * t119
  t128 = t122 * t68
  t129 = 0.1e1 / t66
  t130 = t63 * t129
  t131 = t70 - t130
  t134 = f.my_piecewise3(t73, 0, 0.4e1 / 0.3e1 * t76 * t131)
  t135 = -t131
  t138 = f.my_piecewise3(t80, 0, 0.4e1 / 0.3e1 * t81 * t135)
  t140 = (t134 + t138) * t88
  t141 = t140 * t118
  t146 = t96 ** 2
  t147 = 0.1e1 / t146
  t148 = t91 * t147
  t153 = -0.11765750000000000000000000000000000000000000000000e1 * t45 - 0.51647500000000000000000000000000000000000000000000e0 * t47 - 0.21038750000000000000000000000000000000000000000000e0 * t51 - 0.10419500000000000000000000000000000000000000000000e0 * t56
  t154 = 0.1e1 / t99
  t155 = t153 * t154
  t161 = t111 ** 2
  t162 = 0.1e1 / t161
  t163 = t106 * t162
  t168 = -0.86308333333333333333333333333333333333333333333334e0 * t45 - 0.30192500000000000000000000000000000000000000000000e0 * t47 - 0.55016250000000000000000000000000000000000000000000e-1 * t51 - 0.82785000000000000000000000000000000000000000000000e-1 * t56
  t169 = 0.1e1 / t114
  t170 = t168 * t169
  t173 = 0.53237641966666666666666666666666666666666666666666e-3 * t4 * t11 * t100 + 0.10000000000000000000000000000000000000000000000000e1 * t148 * t155 - t35 - t62 + 0.18311447306006545054854346104378990962041954983034e-3 * t4 * t11 * t115 + 0.58482236226346462072622386637590534819724553404280e0 * t163 * t170
  t174 = t89 * t173
  t175 = t128 * t174
  t178 = t89 * t1
  t180 = t43 * t10 * t115
  t182 = 0.18311447306006545054854346104378990962041954983034e-3 * t178 * t180
  t183 = t89 * t106
  t185 = t162 * t168 * t169
  t187 = 0.58482236226346462072622386637590534819724553404280e0 * t183 * t185
  t188 = t35 + t62 + t121 - t127 + t128 * t141 + t175 + 0.19751673498613801407483339618206552048944131217655e-1 * t140 * t116 - t182 - t187
  t189 = f.my_piecewise3(t73, f.p.zeta_threshold, t72)
  t190 = 6 ** (0.1e1 / 0.3e1)
  t191 = params.alpha * t190
  t192 = jnp.pi ** 2
  t193 = t192 ** (0.1e1 / 0.3e1)
  t194 = t193 ** 2
  t195 = 0.1e1 / t194
  t196 = t195 * s0
  t197 = r0 ** 2
  t198 = r0 ** (0.1e1 / 0.3e1)
  t199 = t198 ** 2
  t205 = 0.1e1 + t191 * t196 / t199 / t197 / 0.24e2
  t206 = 0.1e1 / t205
  t209 = t206 + params.gamma * (0.1e1 - t206)
  t211 = f.my_piecewise3(t80, f.p.zeta_threshold, t79)
  t212 = t195 * s2
  t213 = r1 ** 2
  t214 = r1 ** (0.1e1 / 0.3e1)
  t215 = t214 ** 2
  t221 = 0.1e1 + t191 * t212 / t215 / t213 / 0.24e2
  t222 = 0.1e1 / t221
  t225 = t222 + params.gamma * (0.1e1 - t222)
  t228 = t189 * t209 / 0.2e1 + t211 * t225 / 0.2e1
  t229 = t188 * t228
  t234 = -t104 + t128 * t119 + 0.19751673498613801407483339618206552048944131217655e-1 * t89 * t116
  t235 = f.my_piecewise3(t73, 0, t131)
  t237 = t205 ** 2
  t238 = 0.1e1 / t237
  t240 = t238 * params.alpha * t190
  t241 = t197 * r0
  t243 = 0.1e1 / t199 / t241
  t247 = params.gamma * t238 * params.alpha
  t248 = t190 * t195
  t253 = -t247 * t248 * s0 * t243 / 0.9e1 + t240 * t196 * t243 / 0.9e1
  t255 = f.my_piecewise3(t80, 0, t135)
  t258 = t189 * t253 / 0.2e1 + t235 * t209 / 0.2e1 + t255 * t225 / 0.2e1
  t259 = t234 * t258
  t262 = t140 * t1 * t180
  t265 = 0.1e1 / t161 / t111
  t266 = t168 ** 2
  t270 = 0.11696447245269292414524477327518106963944910680856e1 * t183 * t265 * t266 * t169
  t271 = t4 * t6
  t275 = 0.35616666666666666666666666666666666666666666666666e-1 * t271 * t10 * t39 * t60
  t279 = 0.10843581300301739842632067522386578331157260943710e-1 * t89 * t4 * t11 * t185
  t285 = 0.1e1 / t23 / t66
  t286 = t21 * t5 * t285
  t287 = 0.1e1 / t15 / t14 * t20 * t286
  t290 = 0.1e1 / t8 / t66
  t291 = t43 * t290
  t292 = t42 * t291
  t294 = t6 * t290
  t295 = t4 * t294
  t297 = t14 ** (-0.5e0)
  t299 = t297 * t20 * t286
  t301 = t50 * t291
  t304 = t22 * t5 * t285
  t309 = 0.10000000000000000000000000000000000000000000000000e1 * t40 * (-0.42198333333333333333333333333333333333333333333333e0 * t287 + 0.84396666666666666666666666666666666666666666666666e0 * t292 + 0.39862222222222222222222222222222222222222222222223e0 * t295 + 0.68258333333333333333333333333333333333333333333333e-1 * t299 + 0.13651666666666666666666666666666666666666666666667e0 * t301 + 0.13692777777777777777777777777777777777777777777778e0 * t304) * t59
  t310 = t38 ** 2
  t313 = t58 ** 2
  t314 = t31 ** 2
  t318 = 0.16081979498692535066756296899072713062105388428051e2 * t37 / t310 * t313 / t314
  t319 = t76 ** 2
  t320 = 0.1e1 / t319
  t321 = t131 ** 2
  t325 = 0.1e1 / t66 / t7
  t326 = t63 * t325
  t328 = -0.2e1 * t129 + 0.2e1 * t326
  t332 = f.my_piecewise3(t73, 0, 0.4e1 / 0.9e1 * t320 * t321 + 0.4e1 / 0.3e1 * t76 * t328)
  t333 = t81 ** 2
  t334 = 0.1e1 / t333
  t335 = t135 ** 2
  t338 = -t328
  t342 = f.my_piecewise3(t80, 0, 0.4e1 / 0.9e1 * t334 * t335 + 0.4e1 / 0.3e1 * t81 * t338)
  t344 = (t332 + t342) * t88
  t350 = 0.24415263074675393406472461472505321282722606644045e-3 * t178 * t43 * t290 * t115
  t353 = 0.14764627977777777777777777777777777777777777777777e-2 * t4 * t294 * t32
  t356 = 0.12e2 * t64 * t68 * t119
  t359 = 0.32e2 * t65 * t124 * t119
  t360 = -0.36622894612013090109708692208757981924083909966068e-3 * t262 + t270 - t275 + t279 + t309 + t318 + 0.19751673498613801407483339618206552048944131217655e-1 * t344 * t116 + t350 - t353 + t356 - t359
  t365 = 0.20e2 * t122 / t67 / t66 * t119
  t367 = t140 * t106 * t185
  t375 = -0.57538888888888888888888888888888888888888888888889e0 * t287 + 0.11507777777777777777777777777777777777777777777778e1 * t292 + 0.40256666666666666666666666666666666666666666666667e0 * t295 + 0.36677500000000000000000000000000000000000000000000e-1 * t299 + 0.73355000000000000000000000000000000000000000000000e-1 * t301 + 0.13797500000000000000000000000000000000000000000000e0 * t304
  t379 = 0.58482236226346462072622386637590534819724553404280e0 * t183 * t162 * t375 * t169
  t380 = t161 ** 2
  t381 = 0.1e1 / t380
  t383 = t114 ** 2
  t384 = 0.1e1 / t383
  t387 = 0.17315859105681463759666483083807725165579399831905e2 * t183 * t381 * t266 * t384
  t393 = 0.20000000000000000000000000000000000000000000000000e1 * t37 / t38 / t28 * t313 * t59
  t394 = t69 * t141
  t397 = 0.8e1 * t69 * t174
  t398 = t125 * t141
  t401 = 0.8e1 * t125 * t174
  t405 = t128 * t140 * t173
  t417 = t153 ** 2
  t431 = t146 ** 2
  t434 = t99 ** 2
  t457 = -0.70983522622222222222222222222222222222222222222221e-3 * t4 * t294 * t100 - 0.34246666666666666666666666666666666666666666666666e-1 * t271 * t10 * t147 * t155 - 0.20000000000000000000000000000000000000000000000000e1 * t91 / t146 / t96 * t417 * t154 + 0.10000000000000000000000000000000000000000000000000e1 * t148 * (-0.78438333333333333333333333333333333333333333333333e0 * t287 + 0.15687666666666666666666666666666666666666666666667e1 * t292 + 0.68863333333333333333333333333333333333333333333333e0 * t295 + 0.14025833333333333333333333333333333333333333333333e0 * t299 + 0.28051666666666666666666666666666666666666666666667e0 * t301 + 0.17365833333333333333333333333333333333333333333333e0 * t304) * t154 + 0.32163958997385070133512593798145426124210776856102e2 * t91 / t431 * t417 / t434 + t353 + t275 + t393 - t309 - t318 - 0.24415263074675393406472461472505321282722606644045e-3 * t4 * t294 * t115 - 0.10843581300301739842632067522386578331157260943710e-1 * t271 * t10 * t162 * t170 - 0.11696447245269292414524477327518106963944910680856e1 * t106 * t265 * t266 * t169 + 0.58482236226346462072622386637590534819724553404280e0 * t163 * t375 * t169 + 0.17315859105681463759666483083807725165579399831905e2 * t106 * t381 * t266 * t384
  t459 = t128 * t89 * t457
  t460 = t365 - 0.11696447245269292414524477327518106963944910680856e1 * t367 - t379 - t387 - t393 + 0.8e1 * t394 + t397 - 0.8e1 * t398 - t401 + t128 * t344 * t118 + 0.2e1 * t405 + t459
  t464 = t7 * t188
  t467 = t7 * t234
  t468 = f.my_piecewise3(t73, 0, t328)
  t473 = 0.1e1 / t237 / t205
  t474 = params.alpha ** 2
  t476 = t190 ** 2
  t479 = 0.1e1 / t193 / t192
  t480 = s0 ** 2
  t482 = t197 ** 2
  t485 = 0.1e1 / t198 / t482 / t241
  t490 = 0.1e1 / t199 / t482
  t496 = t476 * t479
  t508 = f.my_piecewise3(t80, 0, t338)
  d11 = 0.2e1 * t229 + 0.2e1 * t259 + t7 * (t360 + t460) * t228 + 0.2e1 * t464 * t258 + t467 * (t468 * t209 / 0.2e1 + t235 * t253 + t189 * (0.2e1 / 0.81e2 * t473 * t474 * t476 * t479 * t480 * t485 - 0.11e2 / 0.27e2 * t240 * t196 * t490 - 0.2e1 / 0.81e2 * params.gamma * t473 * t474 * t496 * t480 * t485 + 0.11e2 / 0.27e2 * t247 * t248 * s0 * t490) / 0.2e1 + t508 * t225 / 0.2e1)
  t513 = -t70 - t130
  t516 = f.my_piecewise3(t73, 0, 0.4e1 / 0.3e1 * t76 * t513)
  t517 = -t513
  t520 = f.my_piecewise3(t80, 0, 0.4e1 / 0.3e1 * t81 * t517)
  t522 = (t516 + t520) * t88
  t523 = t522 * t118
  t527 = t35 + t62 - t121 - t127 + t128 * t523 + t175 + 0.19751673498613801407483339618206552048944131217655e-1 * t522 * t116 - t182 - t187
  t528 = t527 * t228
  t536 = f.my_piecewise3(t73, 0, 0.4e1 / 0.9e1 * t320 * t513 * t131 + 0.8e1 / 0.3e1 * t76 * t63 * t325)
  t544 = f.my_piecewise3(t80, 0, 0.4e1 / 0.9e1 * t334 * t517 * t135 - 0.8e1 / 0.3e1 * t81 * t63 * t325)
  t546 = (t536 + t544) * t88
  t552 = t128 * t522 * t173
  t553 = t69 * t523
  t555 = t125 * t523
  t559 = 0.19751673498613801407483339618206552048944131217655e-1 * t546 * t116 + t128 * t546 * t118 + t552 + 0.4e1 * t553 - 0.4e1 * t555 + t405 + t459 - t401 - 0.4e1 * t394 - 0.4e1 * t398 - t356 + t365 - t353
  t561 = t522 * t106 * t185
  t565 = t522 * t1 * t180
  t568 = -t393 + t309 + t318 - 0.58482236226346462072622386637590534819724553404280e0 * t561 - 0.58482236226346462072622386637590534819724553404280e0 * t367 - t379 - t387 + t270 + t279 - 0.18311447306006545054854346104378990962041954983034e-3 * t565 - 0.18311447306006545054854346104378990962041954983034e-3 * t262 - t275 + t350
  t572 = t7 * t527
  t574 = f.my_piecewise3(t73, 0, t513)
  t576 = f.my_piecewise3(t80, 0, t517)
  t578 = t221 ** 2
  t579 = 0.1e1 / t578
  t581 = t579 * params.alpha * t190
  t582 = t213 * r1
  t584 = 0.1e1 / t215 / t582
  t588 = params.gamma * t579 * params.alpha
  t593 = -t588 * t248 * s2 * t584 / 0.9e1 + t581 * t212 * t584 / 0.9e1
  t596 = t574 * t209 / 0.2e1 + t211 * t593 / 0.2e1 + t576 * t225 / 0.2e1
  t597 = t234 * t596
  t599 = 0.2e1 * t326
  t600 = f.my_piecewise3(t73, 0, t599)
  t603 = f.my_piecewise3(t80, 0, -t599)
  d12 = t229 + t259 + t528 + t7 * (t559 + t568) * t228 + t572 * t258 + t597 + t464 * t596 + t467 * (t600 * t209 / 0.2e1 + t603 * t225 / 0.2e1 + t574 * t253 / 0.2e1 + t255 * t593 / 0.2e1)
  t612 = t513 ** 2
  t616 = 0.2e1 * t129 + 0.2e1 * t326
  t620 = f.my_piecewise3(t73, 0, 0.4e1 / 0.9e1 * t320 * t612 + 0.4e1 / 0.3e1 * t76 * t616)
  t621 = t517 ** 2
  t624 = -t616
  t628 = f.my_piecewise3(t80, 0, 0.4e1 / 0.9e1 * t334 * t621 + 0.4e1 / 0.3e1 * t81 * t624)
  t630 = (t620 + t628) * t88
  t637 = -t387 - 0.11696447245269292414524477327518106963944910680856e1 * t561 - t379 + 0.19751673498613801407483339618206552048944131217655e-1 * t630 * t116 + t459 + t128 * t630 * t118 + 0.2e1 * t552 + t356 - 0.8e1 * t555 - t401 + t309
  t640 = t318 - 0.8e1 * t553 - t397 - t393 + t365 + t359 - t353 + t279 - 0.36622894612013090109708692208757981924083909966068e-3 * t565 + t270 - t275 + t350
  t646 = f.my_piecewise3(t73, 0, t616)
  t649 = f.my_piecewise3(t80, 0, t624)
  t654 = 0.1e1 / t578 / t221
  t657 = s2 ** 2
  t659 = t213 ** 2
  t662 = 0.1e1 / t214 / t659 / t582
  t667 = 0.1e1 / t215 / t659
  d22 = 0.2e1 * t528 + 0.2e1 * t597 + t7 * (t637 + t640) * t228 + 0.2e1 * t572 * t596 + t467 * (t646 * t209 / 0.2e1 + t649 * t225 / 0.2e1 + t576 * t593 + t211 * (0.2e1 / 0.81e2 * t654 * t474 * t476 * t479 * t657 * t662 - 0.11e2 / 0.27e2 * t581 * t212 * t667 - 0.2e1 / 0.81e2 * params.gamma * t654 * t474 * t496 * t657 * t662 + 0.11e2 / 0.27e2 * t588 * t248 * s2 * t667) / 0.2e1)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = 0.1e1 + t4
  t6 = t5 <= f.p.zeta_threshold
  t7 = t5 ** (0.1e1 / 0.3e1)
  t8 = t2 ** 2
  t9 = 0.1e1 / t8
  t11 = -t1 * t9 + t3
  t14 = f.my_piecewise3(t6, 0, 0.4e1 / 0.3e1 * t7 * t11)
  t15 = 0.1e1 - t4
  t16 = t15 <= f.p.zeta_threshold
  t17 = t15 ** (0.1e1 / 0.3e1)
  t18 = -t11
  t21 = f.my_piecewise3(t16, 0, 0.4e1 / 0.3e1 * t17 * t18)
  t23 = 2 ** (0.1e1 / 0.3e1)
  t26 = 0.1e1 / (0.2e1 * t23 - 0.2e1)
  t27 = (t14 + t21) * t26
  t28 = 3 ** (0.1e1 / 0.3e1)
  t29 = t27 * t28
  t30 = 0.1e1 / jnp.pi
  t31 = t30 ** (0.1e1 / 0.3e1)
  t32 = 4 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t34 = t31 * t33
  t35 = t2 ** (0.1e1 / 0.3e1)
  t37 = 0.1e1 / t35 / t2
  t38 = t28 * t31
  t41 = t38 * t33 / t35
  t42 = jnp.sqrt(t41)
  t45 = t41 ** 0.15e1
  t47 = t28 ** 2
  t48 = t31 ** 2
  t49 = t47 * t48
  t50 = t35 ** 2
  t53 = t49 * t32 / t50
  t55 = 0.51785000000000000000000000000000000000000000000000e1 * t42 + 0.90577500000000000000000000000000000000000000000000e0 * t41 + 0.11003250000000000000000000000000000000000000000000e0 * t45 + 0.12417750000000000000000000000000000000000000000000e0 * t53
  t58 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t55
  t59 = jnp.log(t58)
  t61 = t34 * t37 * t59
  t64 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t65 = t64 * f.p.zeta_threshold
  t67 = f.my_piecewise3(t6, t65, t7 * t5)
  t69 = f.my_piecewise3(t16, t65, t17 * t15)
  t71 = (t67 + t69 - 0.2e1) * t26
  t73 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t41
  t74 = t71 * t73
  t75 = t55 ** 2
  t77 = 0.1e1 / t75 / t55
  t79 = 0.1e1 / t42 * t28
  t80 = t34 * t37
  t81 = t79 * t80
  t83 = t33 * t37
  t84 = t38 * t83
  t86 = t41 ** 0.5e0
  t87 = t86 * t28
  t88 = t87 * t80
  t93 = t49 * t32 / t50 / t2
  t95 = -0.86308333333333333333333333333333333333333333333334e0 * t81 - 0.30192500000000000000000000000000000000000000000000e0 * t84 - 0.55016250000000000000000000000000000000000000000000e-1 * t88 - 0.82785000000000000000000000000000000000000000000000e-1 * t93
  t96 = t95 ** 2
  t98 = 0.1e1 / t58
  t99 = t77 * t96 * t98
  t102 = t38 * t33
  t107 = 0.37978500000000000000000000000000000000000000000000e1 * t42 + 0.89690000000000000000000000000000000000000000000000e0 * t41 + 0.20477500000000000000000000000000000000000000000000e0 * t45 + 0.12323500000000000000000000000000000000000000000000e0 * t53
  t108 = t107 ** 2
  t109 = 0.1e1 / t108
  t110 = t37 * t109
  t115 = -0.63297500000000000000000000000000000000000000000000e0 * t81 - 0.29896666666666666666666666666666666666666666666667e0 * t84 - 0.10238750000000000000000000000000000000000000000000e0 * t88 - 0.82156666666666666666666666666666666666666666666667e-1 * t93
  t118 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t107
  t119 = 0.1e1 / t118
  t120 = t115 * t119
  t123 = 0.35616666666666666666666666666666666666666666666666e-1 * t102 * t110 * t120
  t124 = t71 * t38
  t125 = 0.1e1 / t75
  t127 = t125 * t95 * t98
  t128 = t83 * t127
  t132 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t41
  t133 = t132 * t109
  t136 = 0.1e1 / t42 / t41 * t47
  t137 = t48 * t32
  t139 = 0.1e1 / t50 / t8
  t140 = t137 * t139
  t141 = t136 * t140
  t144 = 0.1e1 / t35 / t8
  t145 = t34 * t144
  t146 = t79 * t145
  t148 = t33 * t144
  t149 = t38 * t148
  t151 = t41 ** (-0.5e0)
  t152 = t151 * t47
  t153 = t152 * t140
  t155 = t87 * t145
  t158 = t49 * t32 * t139
  t160 = -0.42198333333333333333333333333333333333333333333333e0 * t141 + 0.84396666666666666666666666666666666666666666666666e0 * t146 + 0.39862222222222222222222222222222222222222222222223e0 * t149 + 0.68258333333333333333333333333333333333333333333333e-1 * t153 + 0.13651666666666666666666666666666666666666666666667e0 * t155 + 0.13692777777777777777777777777777777777777777777778e0 * t158
  t161 = t160 * t119
  t163 = 0.10000000000000000000000000000000000000000000000000e1 * t133 * t161
  t164 = t108 ** 2
  t165 = 0.1e1 / t164
  t166 = t132 * t165
  t167 = t115 ** 2
  t168 = t118 ** 2
  t169 = 0.1e1 / t168
  t170 = t167 * t169
  t172 = 0.16081979498692535066756296899072713062105388428051e2 * t166 * t170
  t173 = t7 ** 2
  t174 = 0.1e1 / t173
  t175 = t11 ** 2
  t178 = t8 * t2
  t179 = 0.1e1 / t178
  t182 = 0.2e1 * t1 * t179 - 0.2e1 * t9
  t186 = f.my_piecewise3(t6, 0, 0.4e1 / 0.9e1 * t174 * t175 + 0.4e1 / 0.3e1 * t7 * t182)
  t187 = t17 ** 2
  t188 = 0.1e1 / t187
  t189 = t18 ** 2
  t192 = -t182
  t196 = f.my_piecewise3(t16, 0, 0.4e1 / 0.9e1 * t188 * t189 + 0.4e1 / 0.3e1 * t17 * t192)
  t198 = (t186 + t196) * t26
  t199 = t73 * t59
  t202 = jnp.log(t118)
  t205 = 0.14764627977777777777777777777777777777777777777777e-2 * t38 * t148 * t202
  t206 = t1 ** 2
  t207 = t8 ** 2
  t208 = 0.1e1 / t207
  t209 = t206 * t208
  t211 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t41
  t216 = 0.70594500000000000000000000000000000000000000000000e1 * t42 + 0.15494250000000000000000000000000000000000000000000e1 * t41 + 0.42077500000000000000000000000000000000000000000000e0 * t45 + 0.15629250000000000000000000000000000000000000000000e0 * t53
  t219 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t216
  t220 = jnp.log(t219)
  t224 = 0.621814e-1 * t132 * t202
  t226 = -0.3109070e-1 * t211 * t220 + t224 - 0.19751673498613801407483339618206552048944131217655e-1 * t199
  t227 = t71 * t226
  t230 = t206 * t1
  t232 = 0.1e1 / t207 / t2
  t233 = t230 * t232
  t236 = t206 ** 2
  t238 = 0.1e1 / t207 / t8
  t239 = t236 * t238
  t242 = -0.36622894612013090109708692208757981924083909966068e-3 * t29 * t61 + 0.11696447245269292414524477327518106963944910680856e1 * t74 * t99 - t123 + 0.10843581300301739842632067522386578331157260943710e-1 * t124 * t128 + t163 + t172 + 0.19751673498613801407483339618206552048944131217655e-1 * t198 * t199 - t205 + 0.12e2 * t209 * t227 - 0.32e2 * t233 * t227 + 0.20e2 * t239 * t227
  t243 = t27 * t73
  t252 = -0.57538888888888888888888888888888888888888888888889e0 * t141 + 0.11507777777777777777777777777777777777777777777778e1 * t146 + 0.40256666666666666666666666666666666666666666666667e0 * t149 + 0.36677500000000000000000000000000000000000000000000e-1 * t153 + 0.73355000000000000000000000000000000000000000000000e-1 * t155 + 0.13797500000000000000000000000000000000000000000000e0 * t158
  t254 = t125 * t252 * t98
  t257 = t75 ** 2
  t258 = 0.1e1 / t257
  t260 = t58 ** 2
  t261 = 0.1e1 / t260
  t262 = t258 * t96 * t261
  t265 = t71 * t28
  t267 = t34 * t144 * t59
  t271 = 0.1e1 / t108 / t107
  t272 = t132 * t271
  t273 = t167 * t119
  t275 = 0.20000000000000000000000000000000000000000000000000e1 * t272 * t273
  t276 = t230 * t208
  t277 = t27 * t226
  t283 = t216 ** 2
  t284 = 0.1e1 / t283
  t285 = t211 * t284
  t290 = -0.11765750000000000000000000000000000000000000000000e1 * t81 - 0.51647500000000000000000000000000000000000000000000e0 * t84 - 0.21038750000000000000000000000000000000000000000000e0 * t88 - 0.10419500000000000000000000000000000000000000000000e0 * t93
  t291 = 0.1e1 / t219
  t292 = t290 * t291
  t297 = 0.11073470983333333333333333333333333333333333333333e-2 * t38 * t83 * t202
  t299 = 0.10000000000000000000000000000000000000000000000000e1 * t133 * t120
  t303 = t73 * t125
  t304 = t95 * t98
  t307 = 0.53237641966666666666666666666666666666666666666666e-3 * t38 * t83 * t220 + 0.10000000000000000000000000000000000000000000000000e1 * t285 * t292 - t297 - t299 + 0.18311447306006545054854346104378990962041954983034e-3 * t38 * t83 * t59 + 0.58482236226346462072622386637590534819724553404280e0 * t303 * t304
  t308 = t71 * t307
  t311 = t236 * t232
  t316 = t236 * t208
  t317 = t198 * t226
  t319 = t27 * t307
  t325 = t37 * t284
  t330 = 0.1e1 / t283 / t216
  t331 = t211 * t330
  t332 = t290 ** 2
  t333 = t332 * t291
  t342 = -0.78438333333333333333333333333333333333333333333333e0 * t141 + 0.15687666666666666666666666666666666666666666666667e1 * t146 + 0.68863333333333333333333333333333333333333333333333e0 * t149 + 0.14025833333333333333333333333333333333333333333333e0 * t153 + 0.28051666666666666666666666666666666666666666666667e0 * t155 + 0.17365833333333333333333333333333333333333333333333e0 * t158
  t343 = t342 * t291
  t346 = t283 ** 2
  t347 = 0.1e1 / t346
  t348 = t211 * t347
  t349 = t219 ** 2
  t350 = 0.1e1 / t349
  t351 = t332 * t350
  t357 = t37 * t125
  t361 = t73 * t77
  t362 = t96 * t98
  t365 = t252 * t98
  t368 = t73 * t258
  t369 = t96 * t261
  t372 = -0.70983522622222222222222222222222222222222222222221e-3 * t38 * t148 * t220 - 0.34246666666666666666666666666666666666666666666666e-1 * t102 * t325 * t292 - 0.20000000000000000000000000000000000000000000000000e1 * t331 * t333 + 0.10000000000000000000000000000000000000000000000000e1 * t285 * t343 + 0.32163958997385070133512593798145426124210776856102e2 * t348 * t351 + t205 + t123 + t275 - t163 - t172 - 0.24415263074675393406472461472505321282722606644045e-3 * t38 * t148 * t59 - 0.10843581300301739842632067522386578331157260943710e-1 * t102 * t357 * t304 - 0.11696447245269292414524477327518106963944910680856e1 * t361 * t362 + 0.58482236226346462072622386637590534819724553404280e0 * t303 * t365 + 0.17315859105681463759666483083807725165579399831905e2 * t368 * t369
  t373 = t71 * t372
  t375 = -0.11696447245269292414524477327518106963944910680856e1 * t243 * t127 - 0.58482236226346462072622386637590534819724553404280e0 * t74 * t254 - 0.17315859105681463759666483083807725165579399831905e2 * t74 * t262 + 0.24415263074675393406472461472505321282722606644045e-3 * t265 * t267 - t275 + 0.8e1 * t276 * t277 + 0.8e1 * t276 * t308 - 0.8e1 * t311 * t277 - 0.8e1 * t311 * t308 + t316 * t317 + 0.2e1 * t316 * t319 + t316 * t373
  t376 = t242 + t375
  t377 = f.my_piecewise3(t6, f.p.zeta_threshold, t5)
  t378 = 6 ** (0.1e1 / 0.3e1)
  t379 = params.alpha * t378
  t380 = jnp.pi ** 2
  t381 = t380 ** (0.1e1 / 0.3e1)
  t382 = t381 ** 2
  t383 = 0.1e1 / t382
  t384 = t383 * s0
  t385 = r0 ** 2
  t386 = r0 ** (0.1e1 / 0.3e1)
  t387 = t386 ** 2
  t393 = 0.1e1 + t379 * t384 / t387 / t385 / 0.24e2
  t394 = 0.1e1 / t393
  t397 = t394 + params.gamma * (0.1e1 - t394)
  t399 = f.my_piecewise3(t16, f.p.zeta_threshold, t15)
  t401 = r1 ** 2
  t402 = r1 ** (0.1e1 / 0.3e1)
  t403 = t402 ** 2
  t410 = 0.1e1 / (0.1e1 + t379 * t383 * s2 / t403 / t401 / 0.24e2)
  t413 = t410 + params.gamma * (0.1e1 - t410)
  t416 = t377 * t397 / 0.2e1 + t399 * t413 / 0.2e1
  t431 = t297 + t299 + 0.4e1 * t276 * t227 - 0.4e1 * t311 * t227 + t316 * t277 + t316 * t308 + 0.19751673498613801407483339618206552048944131217655e-1 * t27 * t199 - 0.18311447306006545054854346104378990962041954983034e-3 * t265 * t61 - 0.58482236226346462072622386637590534819724553404280e0 * t74 * t127
  t432 = f.my_piecewise3(t6, 0, t11)
  t434 = t393 ** 2
  t435 = 0.1e1 / t434
  t437 = t435 * params.alpha * t378
  t438 = t385 * r0
  t440 = 0.1e1 / t387 / t438
  t444 = params.gamma * t435 * params.alpha
  t445 = t378 * t383
  t450 = -t444 * t445 * s0 * t440 / 0.9e1 + t437 * t384 * t440 / 0.9e1
  t452 = f.my_piecewise3(t16, 0, t18)
  t455 = t377 * t450 / 0.2e1 + t432 * t397 / 0.2e1 + t452 * t413 / 0.2e1
  t461 = -t224 + t316 * t227 + 0.19751673498613801407483339618206552048944131217655e-1 * t71 * t199
  t462 = f.my_piecewise3(t6, 0, t182)
  t467 = 0.1e1 / t434 / t393
  t468 = params.alpha ** 2
  t470 = t378 ** 2
  t471 = t467 * t468 * t470
  t473 = 0.1e1 / t381 / t380
  t474 = s0 ** 2
  t475 = t473 * t474
  t476 = t385 ** 2
  t479 = 0.1e1 / t386 / t476 / t438
  t484 = 0.1e1 / t387 / t476
  t489 = params.gamma * t467 * t468
  t490 = t470 * t473
  t499 = 0.2e1 / 0.81e2 * t471 * t475 * t479 - 0.11e2 / 0.27e2 * t437 * t384 * t484 - 0.2e1 / 0.81e2 * t489 * t490 * t474 * t479 + 0.11e2 / 0.27e2 * t444 * t445 * s0 * t484
  t502 = f.my_piecewise3(t16, 0, t192)
  t505 = t462 * t397 / 0.2e1 + t432 * t450 + t377 * t499 / 0.2e1 + t502 * t413 / 0.2e1
  t508 = t96 * t95
  t516 = 0.1e1 / t257 / t55
  t522 = 0.1e1 / t257 / t75
  t525 = 0.1e1 / t260 / t58
  t535 = 0.1e1 / t42 / t53 * t30 * t208 / 0.4e1
  t538 = 0.1e1 / t50 / t178
  t539 = t137 * t538
  t540 = t136 * t539
  t543 = 0.1e1 / t35 / t178
  t544 = t34 * t543
  t545 = t79 * t544
  t547 = t33 * t543
  t548 = t38 * t547
  t550 = t41 ** (-0.15e1)
  t552 = t550 * t30 * t208
  t554 = t152 * t539
  t556 = t87 * t544
  t559 = t49 * t32 * t538
  t561 = -0.34523333333333333333333333333333333333333333333333e1 * t535 + 0.23015555555555555555555555555555555555555555555556e1 * t540 - 0.26851481481481481481481481481481481481481481481482e1 * t545 - 0.93932222222222222222222222222222222222222222222223e0 * t548 + 0.73355000000000000000000000000000000000000000000000e-1 * t552 - 0.14671000000000000000000000000000000000000000000000e0 * t554 - 0.17116166666666666666666666666666666666666666666667e0 * t556 - 0.36793333333333333333333333333333333333333333333333e0 * t559
  t579 = -0.35089341735807877243573431982554320891834732042568e1 * t74 * t258 * t508 * t98 + 0.35089341735807877243573431982554320891834732042568e1 * t243 * t99 + 0.10389515463408878255799889850284635099347639899143e3 * t74 * t516 * t508 * t261 - 0.10254018858216406658218194626490193680059335835414e4 * t74 * t522 * t508 * t525 - 0.51947577317044391278999449251423175496738199495715e2 * t243 * t262 - 0.58482236226346462072622386637590534819724553404280e0 * t74 * t125 * t561 * t98 - 0.17544670867903938621786715991277160445917366021284e1 * t243 * t254 - 0.17544670867903938621786715991277160445917366021284e1 * t198 * t73 * t127 - 0.96e2 * t233 * t308 + 0.60e2 * t239 * t308 - 0.96e2 * t233 * t277 - 0.12e2 * t311 * t373
  t600 = t1 * t208
  t602 = 0.6e1 * t179 - 0.6e1 * t600
  t606 = f.my_piecewise3(t6, 0, -0.8e1 / 0.27e2 / t173 / t5 * t175 * t11 + 0.4e1 / 0.3e1 * t174 * t11 * t182 + 0.4e1 / 0.3e1 * t7 * t602)
  t615 = -t602
  t619 = f.my_piecewise3(t16, 0, -0.8e1 / 0.27e2 / t187 / t15 * t189 * t18 + 0.4e1 / 0.3e1 * t188 * t18 * t192 + 0.4e1 / 0.3e1 * t17 * t615)
  t621 = (t606 + t619) * t26
  t624 = t167 * t115
  t627 = 0.60000000000000000000000000000000000000000000000000e1 * t166 * t624 * t119
  t633 = 0.96491876992155210400537781394436278372632330568306e2 * t132 / t164 / t107 * t624 * t169
  t641 = 0.51726012919273400298984252201052768390886626637712e3 * t132 / t164 / t108 * t624 / t168 / t118
  t655 = 0.10000000000000000000000000000000000000000000000000e1 * t133 * (-0.25319000000000000000000000000000000000000000000000e1 * t535 + 0.16879333333333333333333333333333333333333333333333e1 * t540 - 0.19692555555555555555555555555555555555555555555555e1 * t545 - 0.93011851851851851851851851851851851851851851851854e0 * t548 + 0.13651666666666666666666666666666666666666666666667e0 * t552 - 0.27303333333333333333333333333333333333333333333333e0 * t554 - 0.31853888888888888888888888888888888888888888888890e0 * t556 - 0.36514074074074074074074074074074074074074074074075e0 * t559) * t119
  t661 = 0.60e2 * t239 * t277 + 0.3e1 * t316 * t27 * t372 - 0.24e2 * t311 * t319 + 0.3e1 * t316 * t198 * t307 - 0.12e2 * t311 * t317 + t316 * t621 * t226 + t627 - t633 + t641 + 0.19751673498613801407483339618206552048944131217655e-1 * t621 * t199 + t655 + 0.24e2 * t600 * t227 - 0.144e3 * t206 * t232 * t227
  t684 = t332 * t290
  t723 = -t627 + t633 - t641 - t655 + 0.58482236226346462072622386637590534819724553404280e0 * t303 * t561 * t98 - 0.10389515463408878255799889850284635099347639899143e3 * t73 * t516 * t508 * t261 + 0.10254018858216406658218194626490193680059335835414e4 * t73 * t522 * t508 * t525 + 0.35089341735807877243573431982554320891834732042568e1 * t368 * t508 * t98 + 0.20690405167709360119593700880421107356354650655085e4 * t211 / t346 / t283 * t684 / t349 / t219 + 0.60000000000000000000000000000000000000000000000000e1 * t348 * t684 * t291 - 0.19298375398431042080107556278887255674526466113661e3 * t211 / t346 / t216 * t684 * t350 + 0.10000000000000000000000000000000000000000000000000e1 * t285 * (-0.47063000000000000000000000000000000000000000000000e1 * t535 + 0.31375333333333333333333333333333333333333333333334e1 * t540 - 0.36604555555555555555555555555555555555555555555556e1 * t545 - 0.16068111111111111111111111111111111111111111111111e1 * t548 + 0.28051666666666666666666666666666666666666666666666e0 * t552 - 0.56103333333333333333333333333333333333333333333332e0 * t554 - 0.65453888888888888888888888888888888888888888888890e0 * t556 - 0.46308888888888888888888888888888888888888888888888e0 * t559) * t291 - 0.35089341735807877243573431982554320891834732042568e1 * t361 * t304 * t252 + 0.56968947174242584615102410102512416326352748836105e-3 * t38 * t547 * t59 + 0.16562821945185185185185185185185185185185185185185e-2 * t38 * t547 * t220 - 0.60000000000000000000000000000000000000000000000000e1 * t331 * t292 * t342
  t734 = 0.34450798614814814814814814814814814814814814814813e-2 * t38 * t547 * t202
  t738 = 0.48245938496077605200268890697218139186316165284153e2 * t166 * t160 * t169 * t115
  t741 = 0.60000000000000000000000000000000000000000000000000e1 * t272 * t161 * t115
  t774 = 0.53424999999999999999999999999999999999999999999999e-1 * t102 * t110 * t161
  t778 = 0.71233333333333333333333333333333333333333333333331e-1 * t102 * t144 * t109 * t120
  t782 = 0.10685000000000000000000000000000000000000000000000e0 * t102 * t37 * t271 * t273
  t786 = 0.85917975471764868594145516183295969534298037676861e0 * t102 * t37 * t165 * t170
  t787 = 0.96491876992155210400537781394436278372632330568306e2 * t348 * t342 * t350 * t290 + 0.51947577317044391278999449251423175496738199495715e2 * t368 * t252 * t261 * t95 - t734 - t738 + t741 + 0.68493333333333333333333333333333333333333333333332e-1 * t102 * t144 * t284 * t292 - 0.51369999999999999999999999999999999999999999999999e-1 * t102 * t325 * t343 - 0.16522625736956710527585419434107305400007076070979e1 * t102 * t37 * t347 * t351 - 0.48159733137676571081572406076840235616767705782485e0 * t102 * t37 * t258 * t369 + 0.21687162600603479685264135044773156662314521887420e-1 * t102 * t144 * t125 * t304 - 0.16265371950452609763948101283579867496735891415565e-1 * t102 * t357 * t365 + 0.10274000000000000000000000000000000000000000000000e0 * t102 * t37 * t330 * t333 + 0.32530743900905219527896202567159734993471782831130e-1 * t102 * t37 * t77 * t362 + t774 - t778 - t782 + t786
  t808 = 0.12e2 * t276 * t317 + 0.24e2 * t276 * t319 + t316 * t71 * (t723 + t787) + 0.36e2 * t209 * t277 + 0.36e2 * t209 * t308 - 0.120e3 * t236 / t207 / t178 * t227 + 0.240e3 * t230 * t238 * t227 + 0.12e2 * t276 * t373 + t734 + t738 - t741 - 0.54934341918019635164563038313136972886125864949102e-3 * t198 * t28 * t61
  t839 = 0.35089341735807877243573431982554320891834732042568e1 * t74 * t77 * t95 * t365 + 0.73245789224026180219417384417515963848167819932136e-3 * t29 * t267 - 0.56968947174242584615102410102512416326352748836105e-3 * t265 * t34 * t543 * t59 - 0.51947577317044391278999449251423175496738199495715e2 * t74 * t258 * t252 * t261 * t95 - t774 + t778 + t782 - t786 - 0.21687162600603479685264135044773156662314521887420e-1 * t124 * t148 * t127 + 0.32530743900905219527896202567159734993471782831130e-1 * t27 * t38 * t128 - 0.32530743900905219527896202567159734993471782831130e-1 * t124 * t83 * t99 + 0.16265371950452609763948101283579867496735891415565e-1 * t124 * t83 * t254 + 0.48159733137676571081572406076840235616767705782485e0 * t124 * t83 * t262
  t851 = f.my_piecewise3(t6, 0, t602)
  t858 = t434 ** 2
  t859 = 0.1e1 / t858
  t860 = t468 * params.alpha
  t862 = t380 ** 2
  t866 = t476 ** 2
  t869 = 0.1e1 / t862 * t474 * s0 / t866 / t438
  t873 = 0.1e1 / t386 / t866
  t879 = 0.1e1 / t387 / t476 / r0
  t898 = f.my_piecewise3(t16, 0, t615)
  d111 = 0.3e1 * t376 * t416 + 0.6e1 * t431 * t455 + 0.3e1 * t461 * t505 + t2 * (t579 + t661 + t808 + t839) * t416 + 0.3e1 * t2 * t376 * t455 + 0.3e1 * t2 * t431 * t505 + t2 * t461 * (t851 * t397 / 0.2e1 + 0.3e1 / 0.2e1 * t462 * t450 + 0.3e1 / 0.2e1 * t432 * t499 + t377 * (0.4e1 / 0.81e2 * t859 * t860 * t869 - 0.22e2 / 0.81e2 * t471 * t475 * t873 + 0.154e3 / 0.81e2 * t437 * t384 * t879 - 0.4e1 / 0.81e2 * params.gamma * t859 * t860 * t869 + 0.22e2 / 0.81e2 * t489 * t490 * t474 * t873 - 0.154e3 / 0.81e2 * t444 * t445 * s0 * t879) / 0.2e1 + t898 * t413 / 0.2e1)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 - r1
  t2 = t1 ** 2
  t3 = t2 ** 2
  t4 = r0 + r1
  t5 = t4 ** 2
  t6 = t5 ** 2
  t7 = 0.1e1 / t6
  t8 = t3 * t7
  t9 = 0.1e1 / t4
  t10 = t1 * t9
  t11 = 0.1e1 + t10
  t12 = t11 <= f.p.zeta_threshold
  t13 = t11 ** (0.1e1 / 0.3e1)
  t14 = 0.1e1 / t5
  t16 = -t1 * t14 + t9
  t19 = f.my_piecewise3(t12, 0, 0.4e1 / 0.3e1 * t13 * t16)
  t20 = 0.1e1 - t10
  t21 = t20 <= f.p.zeta_threshold
  t22 = t20 ** (0.1e1 / 0.3e1)
  t23 = -t16
  t26 = f.my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t22 * t23)
  t28 = 2 ** (0.1e1 / 0.3e1)
  t31 = 0.1e1 / (0.2e1 * t28 - 0.2e1)
  t32 = (t19 + t26) * t31
  t33 = 3 ** (0.1e1 / 0.3e1)
  t34 = 0.1e1 / jnp.pi
  t35 = t34 ** (0.1e1 / 0.3e1)
  t36 = t33 * t35
  t37 = 4 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t39 = t4 ** (0.1e1 / 0.3e1)
  t41 = 0.1e1 / t39 / t5
  t42 = t38 * t41
  t45 = t36 * t38 / t39
  t46 = jnp.sqrt(t45)
  t49 = t45 ** 0.15e1
  t51 = t33 ** 2
  t52 = t35 ** 2
  t53 = t51 * t52
  t54 = t39 ** 2
  t57 = t53 * t37 / t54
  t59 = 0.70594500000000000000000000000000000000000000000000e1 * t46 + 0.15494250000000000000000000000000000000000000000000e1 * t45 + 0.42077500000000000000000000000000000000000000000000e0 * t49 + 0.15629250000000000000000000000000000000000000000000e0 * t57
  t62 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t59
  t63 = jnp.log(t62)
  t67 = t36 * t38
  t69 = 0.1e1 / t39 / t4
  t70 = t59 ** 2
  t71 = 0.1e1 / t70
  t72 = t69 * t71
  t74 = 0.1e1 / t46 * t33
  t75 = t35 * t38
  t76 = t75 * t69
  t77 = t74 * t76
  t79 = t38 * t69
  t80 = t36 * t79
  t82 = t45 ** 0.5e0
  t83 = t82 * t33
  t84 = t83 * t76
  t89 = t53 * t37 / t54 / t4
  t91 = -0.11765750000000000000000000000000000000000000000000e1 * t77 - 0.51647500000000000000000000000000000000000000000000e0 * t80 - 0.21038750000000000000000000000000000000000000000000e0 * t84 - 0.10419500000000000000000000000000000000000000000000e0 * t89
  t92 = 0.1e1 / t62
  t93 = t91 * t92
  t98 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t45
  t99 = t70 * t59
  t100 = 0.1e1 / t99
  t101 = t98 * t100
  t102 = t91 ** 2
  t103 = t102 * t92
  t106 = t98 * t71
  t109 = 0.1e1 / t46 / t45 * t51
  t110 = t52 * t37
  t112 = 0.1e1 / t54 / t5
  t113 = t110 * t112
  t114 = t109 * t113
  t116 = t75 * t41
  t117 = t74 * t116
  t119 = t36 * t42
  t121 = t45 ** (-0.5e0)
  t122 = t121 * t51
  t123 = t122 * t113
  t125 = t83 * t116
  t128 = t53 * t37 * t112
  t130 = -0.78438333333333333333333333333333333333333333333333e0 * t114 + 0.15687666666666666666666666666666666666666666666667e1 * t117 + 0.68863333333333333333333333333333333333333333333333e0 * t119 + 0.14025833333333333333333333333333333333333333333333e0 * t123 + 0.28051666666666666666666666666666666666666666666667e0 * t125 + 0.17365833333333333333333333333333333333333333333333e0 * t128
  t131 = t130 * t92
  t134 = t70 ** 2
  t135 = 0.1e1 / t134
  t136 = t98 * t135
  t137 = t62 ** 2
  t138 = 0.1e1 / t137
  t139 = t102 * t138
  t146 = 0.37978500000000000000000000000000000000000000000000e1 * t46 + 0.89690000000000000000000000000000000000000000000000e0 * t45 + 0.20477500000000000000000000000000000000000000000000e0 * t49 + 0.12323500000000000000000000000000000000000000000000e0 * t57
  t149 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t146
  t150 = jnp.log(t149)
  t153 = 0.14764627977777777777777777777777777777777777777777e-2 * t36 * t42 * t150
  t154 = t146 ** 2
  t155 = 0.1e1 / t154
  t156 = t69 * t155
  t161 = -0.63297500000000000000000000000000000000000000000000e0 * t77 - 0.29896666666666666666666666666666666666666666666667e0 * t80 - 0.10238750000000000000000000000000000000000000000000e0 * t84 - 0.82156666666666666666666666666666666666666666666667e-1 * t89
  t162 = 0.1e1 / t149
  t163 = t161 * t162
  t166 = 0.35616666666666666666666666666666666666666666666666e-1 * t67 * t156 * t163
  t168 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t45
  t169 = t154 * t146
  t170 = 0.1e1 / t169
  t171 = t168 * t170
  t172 = t161 ** 2
  t173 = t172 * t162
  t175 = 0.20000000000000000000000000000000000000000000000000e1 * t171 * t173
  t176 = t168 * t155
  t183 = -0.42198333333333333333333333333333333333333333333333e0 * t114 + 0.84396666666666666666666666666666666666666666666666e0 * t117 + 0.39862222222222222222222222222222222222222222222223e0 * t119 + 0.68258333333333333333333333333333333333333333333333e-1 * t123 + 0.13651666666666666666666666666666666666666666666667e0 * t125 + 0.13692777777777777777777777777777777777777777777778e0 * t128
  t184 = t183 * t162
  t186 = 0.10000000000000000000000000000000000000000000000000e1 * t176 * t184
  t187 = t154 ** 2
  t188 = 0.1e1 / t187
  t189 = t168 * t188
  t190 = t149 ** 2
  t191 = 0.1e1 / t190
  t192 = t172 * t191
  t194 = 0.16081979498692535066756296899072713062105388428051e2 * t189 * t192
  t199 = 0.51785000000000000000000000000000000000000000000000e1 * t46 + 0.90577500000000000000000000000000000000000000000000e0 * t45 + 0.11003250000000000000000000000000000000000000000000e0 * t49 + 0.12417750000000000000000000000000000000000000000000e0 * t57
  t202 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t199
  t203 = jnp.log(t202)
  t207 = t199 ** 2
  t208 = 0.1e1 / t207
  t209 = t69 * t208
  t214 = -0.86308333333333333333333333333333333333333333333334e0 * t77 - 0.30192500000000000000000000000000000000000000000000e0 * t80 - 0.55016250000000000000000000000000000000000000000000e-1 * t84 - 0.82785000000000000000000000000000000000000000000000e-1 * t89
  t215 = 0.1e1 / t202
  t216 = t214 * t215
  t221 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t45
  t222 = t207 * t199
  t223 = 0.1e1 / t222
  t224 = t221 * t223
  t225 = t214 ** 2
  t226 = t225 * t215
  t229 = t221 * t208
  t236 = -0.57538888888888888888888888888888888888888888888889e0 * t114 + 0.11507777777777777777777777777777777777777777777778e1 * t117 + 0.40256666666666666666666666666666666666666666666667e0 * t119 + 0.36677500000000000000000000000000000000000000000000e-1 * t123 + 0.73355000000000000000000000000000000000000000000000e-1 * t125 + 0.13797500000000000000000000000000000000000000000000e0 * t128
  t237 = t236 * t215
  t240 = t207 ** 2
  t241 = 0.1e1 / t240
  t242 = t221 * t241
  t243 = t202 ** 2
  t244 = 0.1e1 / t243
  t245 = t225 * t244
  t248 = -0.70983522622222222222222222222222222222222222222221e-3 * t36 * t42 * t63 - 0.34246666666666666666666666666666666666666666666666e-1 * t67 * t72 * t93 - 0.20000000000000000000000000000000000000000000000000e1 * t101 * t103 + 0.10000000000000000000000000000000000000000000000000e1 * t106 * t131 + 0.32163958997385070133512593798145426124210776856102e2 * t136 * t139 + t153 + t166 + t175 - t186 - t194 - 0.24415263074675393406472461472505321282722606644045e-3 * t36 * t42 * t203 - 0.10843581300301739842632067522386578331157260943710e-1 * t67 * t209 * t216 - 0.11696447245269292414524477327518106963944910680856e1 * t224 * t226 + 0.58482236226346462072622386637590534819724553404280e0 * t229 * t237 + 0.17315859105681463759666483083807725165579399831905e2 * t242 * t245
  t249 = t32 * t248
  t252 = t13 ** 2
  t254 = 0.1e1 / t252 / t11
  t255 = t16 ** 2
  t259 = 0.1e1 / t252
  t260 = t259 * t16
  t261 = t5 * t4
  t262 = 0.1e1 / t261
  t265 = 0.2e1 * t1 * t262 - 0.2e1 * t14
  t268 = t1 * t7
  t270 = 0.6e1 * t262 - 0.6e1 * t268
  t274 = f.my_piecewise3(t12, 0, -0.8e1 / 0.27e2 * t254 * t255 * t16 + 0.4e1 / 0.3e1 * t260 * t265 + 0.4e1 / 0.3e1 * t13 * t270)
  t275 = t22 ** 2
  t277 = 0.1e1 / t275 / t20
  t278 = t23 ** 2
  t282 = 0.1e1 / t275
  t283 = t282 * t23
  t284 = -t265
  t287 = -t270
  t291 = f.my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t277 * t278 * t23 + 0.4e1 / 0.3e1 * t283 * t284 + 0.4e1 / 0.3e1 * t22 * t287)
  t293 = (t274 + t291) * t31
  t297 = 0.621814e-1 * t168 * t150
  t298 = t221 * t203
  t300 = -0.3109070e-1 * t98 * t63 + t297 - 0.19751673498613801407483339618206552048944131217655e-1 * t298
  t301 = t293 * t300
  t303 = t6 * t4
  t304 = 0.1e1 / t303
  t305 = t3 * t304
  t313 = 0.11073470983333333333333333333333333333333333333333e-2 * t36 * t79 * t150
  t315 = 0.10000000000000000000000000000000000000000000000000e1 * t176 * t163
  t321 = 0.53237641966666666666666666666666666666666666666666e-3 * t36 * t79 * t63 + 0.10000000000000000000000000000000000000000000000000e1 * t106 * t93 - t313 - t315 + 0.18311447306006545054854346104378990962041954983034e-3 * t36 * t79 * t203 + 0.58482236226346462072622386637590534819724553404280e0 * t229 * t216
  t322 = t32 * t321
  t325 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t326 = t325 * f.p.zeta_threshold
  t328 = f.my_piecewise3(t12, t326, t13 * t11)
  t330 = f.my_piecewise3(t21, t326, t22 * t20)
  t331 = t328 + t330 - 0.2e1
  t332 = t331 * t31
  t333 = t332 * t248
  t341 = f.my_piecewise3(t12, 0, 0.4e1 / 0.9e1 * t259 * t255 + 0.4e1 / 0.3e1 * t13 * t265)
  t347 = f.my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t282 * t278 + 0.4e1 / 0.3e1 * t22 * t284)
  t349 = (t341 + t347) * t31
  t350 = t349 * t300
  t353 = t349 * t321
  t356 = t2 * t1
  t357 = t356 * t7
  t361 = 0.1e1 / t39 / t261
  t362 = t38 * t361
  t365 = 0.34450798614814814814814814814814814814814814814813e-2 * t36 * t362 * t150
  t366 = t183 * t191
  t369 = 0.48245938496077605200268890697218139186316165284153e2 * t189 * t366 * t161
  t372 = 0.60000000000000000000000000000000000000000000000000e1 * t171 * t184 * t161
  t373 = t356 * t304
  t374 = t332 * t321
  t378 = 0.1e1 / t6 / t5
  t379 = t3 * t378
  t380 = t32 * t300
  t383 = 0.3e1 * t8 * t249 + t8 * t301 - 0.24e2 * t305 * t322 - 0.12e2 * t305 * t333 - 0.12e2 * t305 * t350 + 0.12e2 * t357 * t333 + 0.3e1 * t8 * t353 - 0.96e2 * t373 * t374 + 0.60e2 * t379 * t380 + t365 + t369 - t372
  t388 = t332 * t221
  t390 = 0.1e1 / t240 / t207
  t391 = t225 * t214
  t394 = 0.1e1 / t243 / t202
  t395 = t390 * t391 * t394
  t398 = t32 * t221
  t399 = t241 * t225
  t400 = t399 * t244
  t403 = t332 * t300
  t406 = t2 * t304
  t413 = t216 * t236
  t425 = t130 * t138
  t429 = t236 * t244
  t430 = t429 * t214
  t433 = t41 * t71
  t440 = t69 * t135
  t444 = t69 * t241
  t448 = t41 * t208
  t459 = -t365 - t369 + t372 - 0.35089341735807877243573431982554320891834732042568e1 * t224 * t413 + 0.56968947174242584615102410102512416326352748836105e-3 * t36 * t362 * t203 + 0.16562821945185185185185185185185185185185185185185e-2 * t36 * t362 * t63 - 0.60000000000000000000000000000000000000000000000000e1 * t101 * t93 * t130 + 0.96491876992155210400537781394436278372632330568306e2 * t136 * t425 * t91 + 0.51947577317044391278999449251423175496738199495715e2 * t242 * t430 + 0.68493333333333333333333333333333333333333333333332e-1 * t67 * t433 * t93 - 0.51369999999999999999999999999999999999999999999999e-1 * t67 * t72 * t131 - 0.16522625736956710527585419434107305400007076070979e1 * t67 * t440 * t139 - 0.48159733137676571081572406076840235616767705782485e0 * t67 * t444 * t245 + 0.21687162600603479685264135044773156662314521887420e-1 * t67 * t448 * t216 - 0.16265371950452609763948101283579867496735891415565e-1 * t67 * t209 * t237 + 0.10274000000000000000000000000000000000000000000000e0 * t67 * t69 * t100 * t103
  t460 = t69 * t223
  t464 = t69 * t188
  t467 = 0.85917975471764868594145516183295969534298037676861e0 * t67 * t464 * t192
  t470 = 0.53424999999999999999999999999999999999999999999999e-1 * t67 * t156 * t184
  t471 = t41 * t155
  t474 = 0.71233333333333333333333333333333333333333333333331e-1 * t67 * t471 * t163
  t478 = 0.10685000000000000000000000000000000000000000000000e0 * t67 * t69 * t170 * t173
  t482 = 0.1e1 / t46 / t57 * t34 / 0.4e1
  t483 = t482 * t7
  t486 = 0.1e1 / t54 / t261
  t487 = t110 * t486
  t488 = t109 * t487
  t490 = t75 * t361
  t491 = t74 * t490
  t493 = t36 * t362
  t495 = t45 ** (-0.15e1)
  t496 = t495 * t34
  t497 = t496 * t7
  t499 = t122 * t487
  t501 = t83 * t490
  t504 = t53 * t37 * t486
  t506 = -0.34523333333333333333333333333333333333333333333333e1 * t483 + 0.23015555555555555555555555555555555555555555555556e1 * t488 - 0.26851481481481481481481481481481481481481481481482e1 * t491 - 0.93932222222222222222222222222222222222222222222223e0 * t493 + 0.73355000000000000000000000000000000000000000000000e-1 * t497 - 0.14671000000000000000000000000000000000000000000000e0 * t499 - 0.17116166666666666666666666666666666666666666666667e0 * t501 - 0.36793333333333333333333333333333333333333333333333e0 * t504
  t507 = t506 * t215
  t511 = 0.1e1 / t240 / t199
  t512 = t221 * t511
  t513 = t391 * t244
  t516 = t221 * t390
  t517 = t391 * t394
  t520 = t102 * t91
  t521 = t520 * t92
  t525 = 0.1e1 / t134 / t59
  t526 = t98 * t525
  t527 = t520 * t138
  t538 = -0.47063000000000000000000000000000000000000000000000e1 * t483 + 0.31375333333333333333333333333333333333333333333334e1 * t488 - 0.36604555555555555555555555555555555555555555555556e1 * t491 - 0.16068111111111111111111111111111111111111111111111e1 * t493 + 0.28051666666666666666666666666666666666666666666666e0 * t497 - 0.56103333333333333333333333333333333333333333333332e0 * t499 - 0.65453888888888888888888888888888888888888888888890e0 * t501 - 0.46308888888888888888888888888888888888888888888888e0 * t504
  t539 = t538 * t92
  t543 = 0.1e1 / t187 / t154
  t544 = t168 * t543
  t545 = t172 * t161
  t547 = 0.1e1 / t190 / t149
  t548 = t545 * t547
  t550 = 0.51726012919273400298984252201052768390886626637712e3 * t544 * t548
  t551 = t545 * t162
  t553 = 0.60000000000000000000000000000000000000000000000000e1 * t189 * t551
  t554 = t391 * t215
  t558 = 0.1e1 / t134 / t70
  t559 = t98 * t558
  t561 = 0.1e1 / t137 / t62
  t562 = t520 * t561
  t566 = 0.1e1 / t187 / t146
  t567 = t168 * t566
  t568 = t545 * t191
  t570 = 0.96491876992155210400537781394436278372632330568306e2 * t567 * t568
  t579 = -0.25319000000000000000000000000000000000000000000000e1 * t483 + 0.16879333333333333333333333333333333333333333333333e1 * t488 - 0.19692555555555555555555555555555555555555555555555e1 * t491 - 0.93011851851851851851851851851851851851851851851854e0 * t493 + 0.13651666666666666666666666666666666666666666666667e0 * t497 - 0.27303333333333333333333333333333333333333333333333e0 * t499 - 0.31853888888888888888888888888888888888888888888890e0 * t501 - 0.36514074074074074074074074074074074074074074074075e0 * t504
  t580 = t579 * t162
  t582 = 0.10000000000000000000000000000000000000000000000000e1 * t176 * t580
  t583 = 0.32530743900905219527896202567159734993471782831130e-1 * t67 * t460 * t226 + t467 + t470 - t474 - t478 + 0.58482236226346462072622386637590534819724553404280e0 * t229 * t507 - 0.10389515463408878255799889850284635099347639899143e3 * t512 * t513 + 0.10254018858216406658218194626490193680059335835414e4 * t516 * t517 + 0.60000000000000000000000000000000000000000000000000e1 * t136 * t521 - 0.19298375398431042080107556278887255674526466113661e3 * t526 * t527 + 0.10000000000000000000000000000000000000000000000000e1 * t106 * t539 - t550 - t553 + 0.35089341735807877243573431982554320891834732042568e1 * t242 * t554 + 0.20690405167709360119593700880421107356354650655085e4 * t559 * t562 + t570 - t582
  t584 = t459 + t583
  t585 = t332 * t584
  t587 = t2 * t7
  t593 = 0.1e1 / t6 / t261
  t594 = t3 * t593
  t597 = t356 * t378
  t600 = 0.60e2 * t379 * t374 - 0.96e2 * t373 * t380 - 0.10254018858216406658218194626490193680059335835414e4 * t388 * t395 - 0.51947577317044391278999449251423175496738199495715e2 * t398 * t400 + 0.24e2 * t268 * t403 - 0.144e3 * t406 * t403 + 0.12e2 * t357 * t350 + 0.24e2 * t357 * t322 + t8 * t585 + 0.36e2 * t587 * t380 + 0.36e2 * t587 * t374 - 0.120e3 * t594 * t403 + 0.240e3 * t597 * t403
  t602 = t349 * t33
  t604 = t75 * t69 * t203
  t607 = t223 * t214
  t608 = t607 * t237
  t611 = t32 * t33
  t613 = t75 * t41 * t203
  t616 = t332 * t33
  t618 = t75 * t361 * t203
  t622 = t244 * t214
  t623 = t241 * t236 * t622
  t629 = t511 * t391 * t244
  t633 = t223 * t225 * t215
  t636 = -t467 - 0.54934341918019635164563038313136972886125864949102e-3 * t602 * t604 + 0.35089341735807877243573431982554320891834732042568e1 * t388 * t608 + 0.73245789224026180219417384417515963848167819932136e-3 * t611 * t613 - 0.56968947174242584615102410102512416326352748836105e-3 * t616 * t618 - 0.51947577317044391278999449251423175496738199495715e2 * t388 * t623 - t470 + t474 + t478 + 0.19751673498613801407483339618206552048944131217655e-1 * t293 * t298 + 0.10389515463408878255799889850284635099347639899143e3 * t388 * t629 + 0.35089341735807877243573431982554320891834732042568e1 * t398 * t633
  t638 = t241 * t391 * t215
  t642 = t208 * t506 * t215
  t646 = t208 * t236 * t215
  t649 = t349 * t221
  t651 = t208 * t214 * t215
  t654 = t332 * t36
  t655 = t42 * t651
  t658 = t32 * t36
  t659 = t79 * t651
  t662 = t79 * t633
  t665 = t79 * t646
  t668 = t79 * t400
  t671 = -0.35089341735807877243573431982554320891834732042568e1 * t388 * t638 - 0.58482236226346462072622386637590534819724553404280e0 * t388 * t642 - 0.17544670867903938621786715991277160445917366021284e1 * t398 * t646 - 0.17544670867903938621786715991277160445917366021284e1 * t649 * t651 - 0.21687162600603479685264135044773156662314521887420e-1 * t654 * t655 + 0.32530743900905219527896202567159734993471782831130e-1 * t658 * t659 - 0.32530743900905219527896202567159734993471782831130e-1 * t654 * t662 + 0.16265371950452609763948101283579867496735891415565e-1 * t654 * t665 + 0.48159733137676571081572406076840235616767705782485e0 * t654 * t668 + t550 + t553 - t570 + t582
  t673 = t383 + t600 + t636 + t671
  t674 = f.my_piecewise3(t12, f.p.zeta_threshold, t11)
  t675 = 6 ** (0.1e1 / 0.3e1)
  t676 = params.alpha * t675
  t677 = jnp.pi ** 2
  t678 = t677 ** (0.1e1 / 0.3e1)
  t679 = t678 ** 2
  t680 = 0.1e1 / t679
  t681 = t680 * s0
  t682 = r0 ** 2
  t683 = r0 ** (0.1e1 / 0.3e1)
  t684 = t683 ** 2
  t690 = 0.1e1 + t676 * t681 / t684 / t682 / 0.24e2
  t691 = 0.1e1 / t690
  t694 = t691 + params.gamma * (0.1e1 - t691)
  t696 = f.my_piecewise3(t21, f.p.zeta_threshold, t20)
  t698 = r1 ** 2
  t699 = r1 ** (0.1e1 / 0.3e1)
  t700 = t699 ** 2
  t707 = 0.1e1 / (0.1e1 + t676 * t680 * s2 / t700 / t698 / 0.24e2)
  t710 = t707 + params.gamma * (0.1e1 - t707)
  t713 = t674 * t694 / 0.2e1 + t696 * t710 / 0.2e1
  t730 = -0.36622894612013090109708692208757981924083909966068e-3 * t611 * t604 + 0.11696447245269292414524477327518106963944910680856e1 * t388 * t633 - t166 + 0.10843581300301739842632067522386578331157260943710e-1 * t654 * t659 + t186 + t194 + 0.19751673498613801407483339618206552048944131217655e-1 * t349 * t298 - t153 + 0.12e2 * t587 * t403 - 0.32e2 * t373 * t403 + 0.20e2 * t379 * t403
  t751 = -0.11696447245269292414524477327518106963944910680856e1 * t398 * t651 - 0.58482236226346462072622386637590534819724553404280e0 * t388 * t646 - 0.17315859105681463759666483083807725165579399831905e2 * t388 * t400 + 0.24415263074675393406472461472505321282722606644045e-3 * t616 * t613 - t175 + 0.8e1 * t357 * t380 + 0.8e1 * t357 * t374 - 0.8e1 * t305 * t380 - 0.8e1 * t305 * t374 + t8 * t350 + 0.2e1 * t8 * t322 + t8 * t333
  t752 = t730 + t751
  t753 = f.my_piecewise3(t12, 0, t16)
  t755 = t690 ** 2
  t756 = 0.1e1 / t755
  t758 = t756 * params.alpha * t675
  t759 = t682 * r0
  t761 = 0.1e1 / t684 / t759
  t765 = params.gamma * t756 * params.alpha
  t766 = t675 * t680
  t771 = -t765 * t766 * s0 * t761 / 0.9e1 + t758 * t681 * t761 / 0.9e1
  t773 = f.my_piecewise3(t21, 0, t23)
  t776 = t674 * t771 / 0.2e1 + t753 * t694 / 0.2e1 + t773 * t710 / 0.2e1
  t791 = t313 + t315 + 0.4e1 * t357 * t403 - 0.4e1 * t305 * t403 + t8 * t380 + t8 * t374 + 0.19751673498613801407483339618206552048944131217655e-1 * t32 * t298 - 0.18311447306006545054854346104378990962041954983034e-3 * t616 * t604 - 0.58482236226346462072622386637590534819724553404280e0 * t388 * t651
  t792 = f.my_piecewise3(t12, 0, t265)
  t797 = 0.1e1 / t755 / t690
  t798 = params.alpha ** 2
  t800 = t675 ** 2
  t801 = t797 * t798 * t800
  t803 = 0.1e1 / t678 / t677
  t804 = s0 ** 2
  t805 = t803 * t804
  t806 = t682 ** 2
  t809 = 0.1e1 / t683 / t806 / t759
  t814 = 0.1e1 / t684 / t806
  t819 = params.gamma * t797 * t798
  t820 = t800 * t803
  t829 = 0.2e1 / 0.81e2 * t801 * t805 * t809 - 0.11e2 / 0.27e2 * t758 * t681 * t814 - 0.2e1 / 0.81e2 * t819 * t820 * t804 * t809 + 0.11e2 / 0.27e2 * t765 * t766 * s0 * t814
  t832 = f.my_piecewise3(t21, 0, t284)
  t835 = t792 * t694 / 0.2e1 + t753 * t771 + t674 * t829 / 0.2e1 + t832 * t710 / 0.2e1
  t841 = -t297 + t8 * t403 + 0.19751673498613801407483339618206552048944131217655e-1 * t332 * t298
  t842 = f.my_piecewise3(t12, 0, t270)
  t849 = t755 ** 2
  t850 = 0.1e1 / t849
  t851 = t798 * params.alpha
  t852 = t850 * t851
  t853 = t677 ** 2
  t854 = 0.1e1 / t853
  t856 = t854 * t804 * s0
  t857 = t806 ** 2
  t860 = t856 / t857 / t759
  t864 = 0.1e1 / t683 / t857
  t870 = 0.1e1 / t684 / t806 / r0
  t875 = params.gamma * t850 * t851
  t886 = 0.4e1 / 0.81e2 * t852 * t860 - 0.22e2 / 0.81e2 * t801 * t805 * t864 + 0.154e3 / 0.81e2 * t758 * t681 * t870 - 0.4e1 / 0.81e2 * t875 * t860 + 0.22e2 / 0.81e2 * t819 * t820 * t804 * t864 - 0.154e3 / 0.81e2 * t765 * t766 * s0 * t870
  t889 = f.my_piecewise3(t21, 0, t287)
  t892 = t842 * t694 / 0.2e1 + 0.3e1 / 0.2e1 * t792 * t771 + 0.3e1 / 0.2e1 * t753 * t829 + t674 * t886 / 0.2e1 + t889 * t710 / 0.2e1
  t898 = t1 * t304
  t904 = 0.31035607751564040179390551320631661034531975982628e4 * t544 * t183 * t547 * t172
  t908 = 0.64327917994770140267025187596290852248421553712204e2 * t189 * t579 * t191 * t161
  t911 = 0.36000000000000000000000000000000000000000000000000e2 * t189 * t173 * t183
  t938 = 0.42740000000000000000000000000000000000000000000000e0 * t67 * t464 * t551
  t942 = 0.36846163202829085479643115651216588683774907041596e2 * t67 * t69 * t543 * t548
  t946 = 0.68734380377411894875316412946636775627438430141488e1 * t67 * t69 * t566 * t568
  t949 = 0.71233333333333333333333333333333333333333333333332e-1 * t67 * t156 * t580
  t953 = 0.22911460125803964958438804315545591875812810047162e1 * t67 * t41 * t188 * t192
  t957 = 0.22161481481481481481481481481481481481481481481481e0 * t67 * t361 * t155 * t163
  t962 = -t904 - t908 - t911 + 0.13698666666666666666666666666666666666666666666666e0 * t67 * t433 * t131 + 0.44060335298551228073561118490952814400018869522611e1 * t67 * t41 * t135 * t139 - 0.68493333333333333333333333333333333333333333333332e-1 * t67 * t72 * t539 - 0.41096000000000000000000000000000000000000000000000e0 * t67 * t440 * t521 - 0.13012297560362087811158481026863893997388713132452e0 * t67 * t444 * t554 - 0.67471172535210825687488420139294265171645179205307e-1 * t67 * t361 * t208 * t216 - 0.21309037037037037037037037037037037037037037037036e0 * t67 * t361 * t71 * t93 + t938 + t942 - t946 + t949 - t953 + t957 - 0.27397333333333333333333333333333333333333333333333e0 * t67 * t41 * t100 * t103
  t995 = 0.14246666666666666666666666666666666666666666666666e0 * t67 * t471 * t184
  t999 = 0.28493333333333333333333333333333333333333333333333e0 * t67 * t41 * t170 * t173
  t1000 = t130 ** 2
  t1010 = 0.1e1 / t39 / t303
  t1012 = 0.1e1 / t46 / t9 * t1010 * t67 / 0.48e2
  t1014 = t482 * t304
  t1017 = 0.1e1 / t54 / t6
  t1018 = t110 * t1017
  t1019 = t109 * t1018
  t1022 = 0.1e1 / t39 / t6
  t1023 = t75 * t1022
  t1024 = t74 * t1023
  t1026 = t38 * t1022
  t1027 = t36 * t1026
  t1029 = t45 ** (-0.25e1)
  t1032 = t1029 * t34 * t1010 * t67
  t1034 = t496 * t304
  t1036 = t122 * t1018
  t1038 = t83 * t1023
  t1041 = t53 * t37 * t1017
  t1043 = -0.28769444444444444444444444444444444444444444444444e1 * t1012 + 0.27618666666666666666666666666666666666666666666667e2 * t1014 - 0.10229135802469135802469135802469135802469135802469e2 * t1019 + 0.89504938271604938271604938271604938271604938271607e1 * t1024 + 0.31310740740740740740740740740740740740740740740741e1 * t1027 + 0.36677500000000000000000000000000000000000000000000e-1 * t1032 - 0.58684000000000000000000000000000000000000000000000e0 * t1034 + 0.65204444444444444444444444444444444444444444444445e0 * t1036 + 0.57053888888888888888888888888888888888888888888890e0 * t1038 + 0.13490888888888888888888888888888888888888888888889e1 * t1041
  t1047 = t102 ** 2
  t1068 = t225 ** 2
  t1073 = 0.1e1 / t240 / t222
  t1078 = 0.13218100589565368422068335547285844320005660856783e2 * t67 * t69 * t525 * t527 + 0.12842595503380418955085974953824062831138054875329e1 * t67 * t41 * t241 * t245 + 0.38527786510141256865257924861472188493414164625988e1 * t67 * t69 * t511 * t513 - 0.86748650402413918741056540179092626649258087549680e-1 * t67 * t41 * t223 * t226 - 0.21687162600603479685264135044773156662314521887420e-1 * t67 * t209 * t507 - 0.14171548179536397724580378856363097131945845388689e3 * t67 * t69 * t558 * t562 - 0.38025319932552508024225805073234468230220037056326e2 * t67 * t69 * t390 * t517 + 0.43374325201206959370528270089546313324629043774840e-1 * t67 * t448 * t237 - t995 + t999 + 0.96491876992155210400537781394436278372632330568306e2 * t136 * t1000 * t138 + 0.58482236226346462072622386637590534819724553404280e0 * t229 * t1043 * t215 - 0.24000000000000000000000000000000000000000000000000e2 * t526 * t1047 * t92 + 0.11579025239058625248064533767332353404715879668197e4 * t559 * t1047 * t138 + 0.10000000000000000000000000000000000000000000000000e1 * t106 * (-0.39219166666666666666666666666666666666666666666667e1 * t1012 + 0.37650400000000000000000000000000000000000000000000e2 * t1014 - 0.13944592592592592592592592592592592592592592592593e2 * t1019 + 0.12201518518518518518518518518518518518518518518519e2 * t1024 + 0.53560370370370370370370370370370370370370370370370e1 * t1027 + 0.14025833333333333333333333333333333333333333333333e0 * t1032 - 0.22441333333333333333333333333333333333333333333332e1 * t1034 + 0.24934814814814814814814814814814814814814814814815e1 * t1036 + 0.21817962962962962962962962962962962962962962962963e1 * t1038 + 0.16979925925925925925925925925925925925925925925926e1 * t1041) * t92 + 0.62337092780453269534799339101707810596085839394858e3 * t516 * t1068 * t244 - 0.12304822629859687989861833551788232416071203002497e5 * t221 * t1073 * t1068 * t394
  t1080 = t236 ** 2
  t1087 = t172 ** 2
  t1090 = 0.62071215503128080358781102641263322069063951965254e4 * t168 / t187 / t169 * t1087 * t547
  t1091 = t187 ** 2
  t1094 = t190 ** 2
  t1098 = 0.24955700379505800914252936827276051226357058527653e5 * t168 / t1091 * t1087 / t1094
  t1121 = 0.10000000000000000000000000000000000000000000000000e1 * t176 * (-0.21099166666666666666666666666666666666666666666667e1 * t1012 + 0.20255200000000000000000000000000000000000000000000e2 * t1014 - 0.75019259259259259259259259259259259259259259259258e1 * t1019 + 0.65641851851851851851851851851851851851851851851850e1 * t1024 + 0.31003950617283950617283950617283950617283950617285e1 * t1027 + 0.68258333333333333333333333333333333333333333333335e-1 * t1032 - 0.10921333333333333333333333333333333333333333333333e1 * t1034 + 0.12134814814814814814814814814814814814814814814815e1 * t1036 + 0.10617962962962962962962962962962962962962962962963e1 * t1038 + 0.13388493827160493827160493827160493827160493827161e1 * t1041) * t162
  t1126 = t240 ** 2
  t1127 = 0.1e1 / t1126
  t1129 = t243 ** 2
  t1130 = 0.1e1 / t1129
  t1137 = t134 ** 2
  t1140 = t137 ** 2
  t1150 = 0.24000000000000000000000000000000000000000000000000e2 * t567 * t1087 * t162
  t1153 = 0.57895126195293126240322668836661767023579398340984e3 * t567 * t366 * t172
  t1156 = 0.11483599538271604938271604938271604938271604938271e-1 * t36 * t1026 * t150
  t1159 = 0.80000000000000000000000000000000000000000000000000e1 * t171 * t580 * t161
  t1166 = -0.35089341735807877243573431982554320891834732042568e1 * t224 * t1080 * t215 + t1090 - t1098 - 0.14035736694323150897429372793021728356733892817027e2 * t512 * t1068 * t215 - 0.24828486201251232143512441056505328827625580786102e5 * t98 / t134 / t99 * t1047 * t561 - t1121 + 0.41096000000000000000000000000000000000000000000000e0 * t80 * t100 * t91 * t131 + 0.91082604192152556048340974007871726131433263376469e5 * t221 * t1127 * t1068 * t1130 + 0.51947577317044391278999449251423175496738199495715e2 * t242 * t1080 * t244 + 0.19964560303604640731402349461820840981085646822122e6 * t98 / t1137 * t1047 / t1140 - 0.60000000000000000000000000000000000000000000000000e1 * t101 * t1000 * t92 + t1150 + t1153 + t1156 + t1159 + 0.21053605041484726346144059189532592535100839225540e2 * t242 * t226 * t236 - 0.11579025239058625248064533767332353404715879668197e4 * t526 * t425 * t102
  t1203 = 0.57895126195293126240322668836661767023579398340984e3 * t544 * t1087 * t191
  t1204 = t183 ** 2
  t1207 = 0.48245938496077605200268890697218139186316165284153e2 * t189 * t1204 * t191
  t1210 = 0.60000000000000000000000000000000000000000000000000e1 * t171 * t1204 * t162
  t1215 = 0.34367190188705947437658206473318387813719215070744e1 * t80 * t188 * t183 * t191 * t161
  t1219 = 0.42740000000000000000000000000000000000000000000000e0 * t80 * t170 * t183 * t163
  t1229 = -0.62337092780453269534799339101707810596085839394858e3 * t512 * t429 * t225 - 0.55209406483950617283950617283950617283950617283950e-2 * t36 * t1026 * t63 + 0.36000000000000000000000000000000000000000000000000e2 * t136 * t103 * t130 - 0.18989649058080861538367470034170805442117582945368e-2 * t36 * t1026 * t203 + 0.69263436422725855038665932335230900662317599327620e2 * t242 * t506 * t244 * t214 - 0.80000000000000000000000000000000000000000000000000e1 * t101 * t93 * t538 + 0.12865583598954028053405037519258170449684310742441e3 * t136 * t538 * t138 * t91 + 0.61524113149298439949309167758941162080356015012483e4 * t516 * t236 * t394 * t225 - 0.46785788981077169658097909310072427855779642723424e1 * t224 * t216 * t506 + 0.12414243100625616071756220528252664413812790393051e5 * t559 * t130 * t561 * t102 - t1203 - t1207 + t1210 + t1215 - t1219 - 0.19263893255070628432628962430736094246707082312994e1 * t80 * t623 - 0.66090502947826842110341677736429221600028304283916e1 * t80 * t135 * t130 * t138 * t91 + 0.13012297560362087811158481026863893997388713132452e0 * t80 * t608
  t1246 = 0.6e1 * t8 * t349 * t248 - 0.384e3 * t898 * t403 + t904 + t908 + t911 + t8 * t332 * (t962 + t1078 + t1166 + t1229) + 0.96e2 * t268 * t374 - 0.576e3 * t406 * t374 - 0.576e3 * t406 * t380 + 0.960e3 * t597 * t380 + 0.120e3 * t379 * t333 - 0.48e2 * t305 * t353
  t1268 = 0.4e1 * t8 * t293 * t321 - t938 - t942 + t946 - t949 + t953 - t957 + 0.14649157844805236043883476883503192769633563986427e-2 * t602 * t613 - 0.21053605041484726346144059189532592535100839225540e2 * t388 * t399 * t237 - 0.22787578869697033846040964041004966530541099534442e-2 * t611 * t618 + 0.18989649058080861538367470034170805442117582945368e-2 * t616 * t75 * t1022 * t203 - 0.61524113149298439949309167758941162080356015012483e4 * t388 * t390 * t236 * t394 * t225 - 0.20779030926817756511599779700569270198695279798286e3 * t398 * t623
  t1307 = -0.69263436422725855038665932335230900662317599327620e2 * t388 * t241 * t506 * t622 + 0.62337092780453269534799339101707810596085839394858e3 * t388 * t511 * t225 * t429 - 0.73245789224026180219417384417515963848167819932136e-3 * t293 * t33 * t604 + 0.14035736694323150897429372793021728356733892817027e2 * t398 * t608 + 0.46785788981077169658097909310072427855779642723424e1 * t388 * t607 * t507 - 0.58482236226346462072622386637590534819724553404280e0 * t388 * t208 * t1043 * t215 - 0.91082604192152556048340974007871726131433263376469e5 * t388 * t1127 * t1068 * t1130 - 0.10389515463408878255799889850284635099347639899143e3 * t649 * t400 + 0.12304822629859687989861833551788232416071203002497e5 * t388 * t1073 * t1068 * t394 + 0.41558061853635513023199559401138540397390559596572e3 * t398 * t629 - 0.23392894490538584829048954655036213927889821361712e1 * t293 * t221 * t651 - 0.14035736694323150897429372793021728356733892817027e2 * t398 * t638
  t1335 = t11 ** 2
  t1338 = t255 ** 2
  t1344 = t265 ** 2
  t1350 = -0.24e2 * t7 + 0.24e2 * t898
  t1354 = f.my_piecewise3(t12, 0, 0.40e2 / 0.81e2 / t252 / t1335 * t1338 - 0.16e2 / 0.9e1 * t254 * t255 * t265 + 0.4e1 / 0.3e1 * t259 * t1344 + 0.16e2 / 0.9e1 * t260 * t270 + 0.4e1 / 0.3e1 * t13 * t1350)
  t1355 = t20 ** 2
  t1358 = t278 ** 2
  t1364 = t284 ** 2
  t1369 = -t1350
  t1373 = f.my_piecewise3(t21, 0, 0.40e2 / 0.81e2 / t275 / t1355 * t1358 - 0.16e2 / 0.9e1 * t277 * t278 * t284 + 0.4e1 / 0.3e1 * t282 * t1364 + 0.16e2 / 0.9e1 * t283 * t287 + 0.4e1 / 0.3e1 * t22 * t1369)
  t1375 = (t1354 + t1373) * t31
  t1385 = 0.14035736694323150897429372793021728356733892817027e2 * t388 * t511 * t1068 * t215 - 0.51947577317044391278999449251423175496738199495715e2 * t388 * t241 * t1080 * t244 + 0.35089341735807877243573431982554320891834732042568e1 * t388 * t223 * t1080 * t215 - 0.41016075432865626632872778505960774720237343341655e4 * t398 * t395 + 0.70178683471615754487146863965108641783669464085136e1 * t649 * t633 - 0.62337092780453269534799339101707810596085839394858e3 * t388 * t390 * t1068 * t244 - 0.35089341735807877243573431982554320891834732042568e1 * t649 * t646 - 0.23392894490538584829048954655036213927889821361712e1 * t398 * t642 + 0.4e1 * t8 * t32 * t584 + t8 * t1375 * t300 - 0.48e2 * t305 * t249 + 0.1440e4 * t2 * t378 * t403 + 0.72e2 * t587 * t350
  t1394 = t6 ** 2
  t1405 = t995 - t999 - t1090 + t1098 + t1121 - 0.480e3 * t594 * t374 + 0.16e2 * t357 * t301 - 0.16e2 * t305 * t301 + 0.840e3 * t3 / t1394 * t403 - 0.480e3 * t594 * t380 + 0.960e3 * t597 * t374 + 0.144e3 * t587 * t322
  t1411 = t332 * t67
  t1431 = -0.1920e4 * t356 * t593 * t403 - t1150 - t1153 - t1156 - t1159 - 0.192e3 * t373 * t333 + 0.19263893255070628432628962430736094246707082312994e1 * t1411 * t444 * t430 - 0.13012297560362087811158481026863893997388713132452e0 * t1411 * t460 * t413 + 0.86748650402413918741056540179092626649258087549680e-1 * t654 * t42 * t633 - 0.13012297560362087811158481026863893997388713132452e0 * t658 * t662 + 0.13012297560362087811158481026863893997388713132452e0 * t654 * t79 * t638 + 0.65061487801810439055792405134319469986943565662260e-1 * t349 * t36 * t659 - 0.86748650402413918741056540179092626649258087549680e-1 * t658 * t655
  t1457 = 0.67471172535210825687488420139294265171645179205307e-1 * t654 * t362 * t651 - 0.43374325201206959370528270089546313324629043774840e-1 * t654 * t42 * t646 - 0.12842595503380418955085974953824062831138054875329e1 * t654 * t42 * t400 + 0.65061487801810439055792405134319469986943565662260e-1 * t658 * t665 + 0.19263893255070628432628962430736094246707082312995e1 * t658 * t668 - 0.38527786510141256865257924861472188493414164625988e1 * t654 * t79 * t629 + 0.21687162600603479685264135044773156662314521887420e-1 * t654 * t79 * t642 + 0.38025319932552508024225805073234468230220037056326e2 * t654 * t79 * t395 + 0.16e2 * t357 * t585 + t1203 + t1207 - t1210
  t1482 = 0.19751673498613801407483339618206552048944131217655e-1 * t1375 * t298 + 0.24e2 * t7 * t331 * t31 * t300 + 0.48e2 * t357 * t249 + 0.120e3 * t379 * t350 - 0.16e2 * t305 * t585 + 0.72e2 * t587 * t333 + 0.48e2 * t357 * t353 - 0.192e3 * t373 * t350 - 0.384e3 * t373 * t322 + 0.96e2 * t268 * t380 + 0.240e3 * t379 * t322 - t1215 + t1219
  t1498 = f.my_piecewise3(t12, 0, t1350)
  t1508 = 0.1e1 / t849 / t690
  t1509 = t798 ** 2
  t1512 = t804 ** 2
  t1513 = t806 * t682
  t1518 = t1512 / t684 / t857 / t1513 * t766
  t1523 = t856 / t857 / t806
  t1528 = 0.1e1 / t683 / t857 / r0
  t1533 = 0.1e1 / t684 / t1513
  t1555 = f.my_piecewise3(t21, 0, t1369)
  d1111 = 0.4e1 * t673 * t713 + 0.12e2 * t752 * t776 + 0.12e2 * t791 * t835 + 0.4e1 * t841 * t892 + t4 * (t1246 + t1268 + t1307 + t1385 + t1405 + t1431 + t1457 + t1482) * t713 + 0.4e1 * t4 * t673 * t776 + 0.6e1 * t4 * t752 * t835 + 0.4e1 * t4 * t791 * t892 + t4 * t841 * (t1498 * t694 / 0.2e1 + 0.2e1 * t842 * t771 + 0.3e1 * t792 * t829 + 0.2e1 * t753 * t886 + t674 * (0.16e2 / 0.729e3 * t1508 * t1509 * t854 * t1518 - 0.88e2 / 0.81e2 * t852 * t1523 + 0.1958e4 / 0.729e3 * t801 * t805 * t1528 - 0.2618e4 / 0.243e3 * t758 * t681 * t1533 - 0.16e2 / 0.729e3 * params.gamma * t1508 * t1509 * t854 * t1518 + 0.88e2 / 0.81e2 * t875 * t1523 - 0.1958e4 / 0.729e3 * t819 * t820 * t804 * t1528 + 0.2618e4 / 0.243e3 * t765 * t766 * s0 * t1533) / 0.2e1 + t1555 * t710 / 0.2e1)

  res = {'v4rho4': d1111}
  return res
