"""Generated from gga_c_op_b88.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_beta = 0.0042

  params_gamma = 6

  op_a1 = 1.5214

  op_a2 = 0.5764

  op_b1 = 1.1284

  op_b2 = 0.3183

  op_qab = 2.367

  b88_f = lambda x: 1 + params_beta / X_FACTOR_C * x ** 2 / (1 + params_gamma * params_beta * x * jnp.arcsinh(x))

  op_enhancement = lambda xs: b88_f(xs)

  op_b88_zab = lambda f_x, rs, z, xs0, xs1: f.my_piecewise3(b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1) == 0, DBL_EPSILON, b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1))

  op_beta = lambda rs, z, xs0, xs1: op_qab / op_b88_zab(op_enhancement, rs, z, xs0, xs1)

  op_f_s = lambda rs, z, xt, xs0, xs1: -(1 - z ** 2) * f.n_total(rs) / 4.0 * (op_a1 * op_beta(rs, z, xs0, xs1) + op_a2) / (op_beta(rs, z, xs0, xs1) ** 4 + op_b1 * op_beta(rs, z, xs0, xs1) ** 3 + op_b2 * op_beta(rs, z, xs0, xs1) ** 2)

  op_f = lambda rs, z, xt, xs0, xs1: f.my_piecewise3(jnp.logical_or(1 - jnp.abs(z) <= f.p.zeta_threshold, jnp.logical_and(f.screen_dens(rs, z), f.screen_dens(rs, -z))), 0, op_f_s(rs, f.z_thr(z), xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1: op_f(rs, z, xt, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_beta = 0.0042

  params_gamma = 6

  op_a1 = 1.5214

  op_a2 = 0.5764

  op_b1 = 1.1284

  op_b2 = 0.3183

  op_qab = 2.367

  b88_f = lambda x: 1 + params_beta / X_FACTOR_C * x ** 2 / (1 + params_gamma * params_beta * x * jnp.arcsinh(x))

  op_enhancement = lambda xs: b88_f(xs)

  op_b88_zab = lambda f_x, rs, z, xs0, xs1: f.my_piecewise3(b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1) == 0, DBL_EPSILON, b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1))

  op_beta = lambda rs, z, xs0, xs1: op_qab / op_b88_zab(op_enhancement, rs, z, xs0, xs1)

  op_f_s = lambda rs, z, xt, xs0, xs1: -(1 - z ** 2) * f.n_total(rs) / 4.0 * (op_a1 * op_beta(rs, z, xs0, xs1) + op_a2) / (op_beta(rs, z, xs0, xs1) ** 4 + op_b1 * op_beta(rs, z, xs0, xs1) ** 3 + op_b2 * op_beta(rs, z, xs0, xs1) ** 2)

  op_f = lambda rs, z, xt, xs0, xs1: f.my_piecewise3(jnp.logical_or(1 - jnp.abs(z) <= f.p.zeta_threshold, jnp.logical_and(f.screen_dens(rs, z), f.screen_dens(rs, -z))), 0, op_f_s(rs, f.z_thr(z), xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1: op_f(rs, z, xt, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_beta = 0.0042

  params_gamma = 6

  op_a1 = 1.5214

  op_a2 = 0.5764

  op_b1 = 1.1284

  op_b2 = 0.3183

  op_qab = 2.367

  b88_f = lambda x: 1 + params_beta / X_FACTOR_C * x ** 2 / (1 + params_gamma * params_beta * x * jnp.arcsinh(x))

  op_enhancement = lambda xs: b88_f(xs)

  op_b88_zab = lambda f_x, rs, z, xs0, xs1: f.my_piecewise3(b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1) == 0, DBL_EPSILON, b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1))

  op_beta = lambda rs, z, xs0, xs1: op_qab / op_b88_zab(op_enhancement, rs, z, xs0, xs1)

  op_f_s = lambda rs, z, xt, xs0, xs1: -(1 - z ** 2) * f.n_total(rs) / 4.0 * (op_a1 * op_beta(rs, z, xs0, xs1) + op_a2) / (op_beta(rs, z, xs0, xs1) ** 4 + op_b1 * op_beta(rs, z, xs0, xs1) ** 3 + op_b2 * op_beta(rs, z, xs0, xs1) ** 2)

  op_f = lambda rs, z, xt, xs0, xs1: f.my_piecewise3(jnp.logical_or(1 - jnp.abs(z) <= f.p.zeta_threshold, jnp.logical_and(f.screen_dens(rs, z), f.screen_dens(rs, -z))), 0, op_f_s(rs, f.z_thr(z), xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1: op_f(rs, z, xt, xs0, xs1)

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = abs(t4)
  t11 = 0.1e1 - t5 <= f.p.zeta_threshold or r0 <= f.p.dens_threshold and r1 <= f.p.dens_threshold
  t13 = 0.1e1 + t4 <= f.p.zeta_threshold
  t14 = f.p.zeta_threshold - 0.1e1
  t16 = 0.1e1 - t4 <= f.p.zeta_threshold
  t17 = -t14
  t18 = f.my_piecewise5(t13, t14, t16, t17, t4)
  t19 = t18 ** 2
  t20 = 0.1e1 - t19
  t21 = t20 * t2
  t24 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t27 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t28 = f.my_piecewise5(t24, t14, t27, t17, t4)
  t29 = 0.1e1 + t28
  t32 = t29 * t2 / 0.2e1 <= f.p.dens_threshold
  t33 = 3 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t36 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t38 = t34 / t36
  t39 = 4 ** (0.1e1 / 0.3e1)
  t40 = t38 * t39
  t41 = 2 ** (0.1e1 / 0.3e1)
  t42 = t29 <= f.p.zeta_threshold
  t43 = 0.1e1 - t28
  t44 = t43 <= f.p.zeta_threshold
  t45 = f.my_piecewise5(t42, t14, t44, t17, t28)
  t47 = (0.1e1 + t45) * t2
  t48 = t47 ** (0.1e1 / 0.3e1)
  t50 = t41 / t48
  t51 = r0 ** 2
  t52 = r0 ** (0.1e1 / 0.3e1)
  t53 = t52 ** 2
  t55 = 0.1e1 / t53 / t51
  t56 = s0 * t55
  t57 = jnp.sqrt(s0)
  t59 = 0.1e1 / t52 / r0
  t60 = t57 * t59
  t61 = jnp.arcsinh(t60)
  t64 = 0.1e1 + 0.2520e-1 * t60 * t61
  t65 = 0.1e1 / t64
  t69 = 0.1e1 + 0.93333333333333333333333333333333333333333333333333e-3 * t40 * t56 * t65
  t70 = 0.1e1 / t69
  t74 = f.my_piecewise3(t32, 0, t40 * t50 * t70 / 0.9e1)
  t78 = t43 * t2 / 0.2e1 <= f.p.dens_threshold
  t79 = f.my_piecewise5(t44, t14, t42, t17, -t28)
  t81 = (0.1e1 + t79) * t2
  t82 = t81 ** (0.1e1 / 0.3e1)
  t84 = t41 / t82
  t85 = r1 ** 2
  t86 = r1 ** (0.1e1 / 0.3e1)
  t87 = t86 ** 2
  t89 = 0.1e1 / t87 / t85
  t90 = s2 * t89
  t91 = jnp.sqrt(s2)
  t93 = 0.1e1 / t86 / r1
  t94 = t91 * t93
  t95 = jnp.arcsinh(t94)
  t98 = 0.1e1 + 0.2520e-1 * t94 * t95
  t99 = 0.1e1 / t98
  t103 = 0.1e1 + 0.93333333333333333333333333333333333333333333333333e-3 * t40 * t90 * t99
  t104 = 0.1e1 / t103
  t108 = f.my_piecewise3(t78, 0, t40 * t84 * t104 / 0.9e1)
  t109 = t74 + t108
  t110 = t109 == 0.0e0
  t111 = f.my_piecewise3(t110, DBL_EPSILON, t109)
  t114 = 0.360115380e1 / t111 + 0.5764e0
  t115 = t111 ** 2
  t116 = t115 ** 2
  t117 = 0.1e1 / t116
  t120 = 0.1e1 / t115 / t111
  t122 = 0.1e1 / t115
  t124 = 0.313901240307210000e2 * t117 + 0.149643497914092000e2 * t120 + 0.1783335908700e1 * t122
  t125 = 0.1e1 / t124
  t129 = f.my_piecewise3(t11, 0, -0.25000000000000000000000000000000000000000000000000e0 * t21 * t114 * t125)
  t130 = t2 ** 2
  t132 = t1 / t130
  t133 = t3 - t132
  t134 = f.my_piecewise5(t13, 0, t16, 0, t133)
  t137 = t2 * t114 * t125
  t142 = 0.25000000000000000000000000000000000000000000000000e0 * t20 * t114 * t125
  t145 = t41 / t48 / t47
  t146 = f.my_piecewise5(t24, 0, t27, 0, t133)
  t147 = f.my_piecewise5(t42, 0, t44, 0, t146)
  t154 = t69 ** 2
  t155 = 0.1e1 / t154
  t159 = s0 / t53 / t51 / r0
  t163 = t64 ** 2
  t164 = 0.1e1 / t163
  t171 = jnp.sqrt(0.1e1 + t56)
  t172 = 0.1e1 / t171
  t186 = f.my_piecewise3(t32, 0, -t40 * t145 * t70 * (t147 * t2 + t45 + 0.1e1) / 0.27e2 - t40 * t50 * t155 * (-0.24888888888888888888888888888888888888888888888889e-2 * t40 * t159 * t65 - 0.93333333333333333333333333333333333333333333333333e-3 * t40 * t56 * t164 * (-0.33600000000000000000000000000000000000000000000000e-1 * t57 / t52 / t51 * t61 - 0.33600000000000000000000000000000000000000000000000e-1 * t159 * t172)) / 0.9e1)
  t189 = t41 / t82 / t81
  t190 = f.my_piecewise5(t44, 0, t42, 0, -t146)
  t197 = f.my_piecewise3(t78, 0, -t40 * t189 * t104 * (t190 * t2 + t79 + 0.1e1) / 0.27e2)
  t199 = f.my_piecewise3(t110, 0, t186 + t197)
  t204 = t124 ** 2
  t206 = t114 / t204
  t208 = 0.1e1 / t116 / t111
  t220 = f.my_piecewise3(t11, 0, 0.50000000000000000000000000000000000000000000000000e0 * t18 * t134 * t137 - t142 + 0.90028845000000000000000000000000000000000000000000e0 * t21 * t122 * t199 * t125 + 0.25000000000000000000000000000000000000000000000000e0 * t21 * t206 * (-0.1255604961228840000e3 * t208 * t199 - 0.448930493742276000e2 * t117 * t199 - 0.3566671817400e1 * t120 * t199))
  vrho_0_ = t2 * t220 + t129
  t222 = -t3 - t132
  t223 = f.my_piecewise5(t13, 0, t16, 0, t222)
  t227 = f.my_piecewise5(t24, 0, t27, 0, t222)
  t228 = f.my_piecewise5(t42, 0, t44, 0, t227)
  t235 = f.my_piecewise3(t32, 0, -t40 * t145 * t70 * (t228 * t2 + t45 + 0.1e1) / 0.27e2)
  t236 = f.my_piecewise5(t44, 0, t42, 0, -t227)
  t243 = t103 ** 2
  t244 = 0.1e1 / t243
  t248 = s2 / t87 / t85 / r1
  t252 = t98 ** 2
  t253 = 0.1e1 / t252
  t260 = jnp.sqrt(0.1e1 + t90)
  t261 = 0.1e1 / t260
  t275 = f.my_piecewise3(t78, 0, -t40 * t189 * t104 * (t236 * t2 + t79 + 0.1e1) / 0.27e2 - t40 * t84 * t244 * (-0.24888888888888888888888888888888888888888888888889e-2 * t40 * t248 * t99 - 0.93333333333333333333333333333333333333333333333333e-3 * t40 * t90 * t253 * (-0.33600000000000000000000000000000000000000000000000e-1 * t91 / t86 / t85 * t95 - 0.33600000000000000000000000000000000000000000000000e-1 * t248 * t261)) / 0.9e1)
  t277 = f.my_piecewise3(t110, 0, t235 + t275)
  t293 = f.my_piecewise3(t11, 0, 0.50000000000000000000000000000000000000000000000000e0 * t18 * t223 * t137 - t142 + 0.90028845000000000000000000000000000000000000000000e0 * t21 * t122 * t277 * t125 + 0.25000000000000000000000000000000000000000000000000e0 * t21 * t206 * (-0.1255604961228840000e3 * t208 * t277 - 0.448930493742276000e2 * t117 * t277 - 0.3566671817400e1 * t120 * t277))
  vrho_1_ = t2 * t293 + t129
  t315 = f.my_piecewise3(t32, 0, -t40 * t50 * t155 * (0.93333333333333333333333333333333333333333333333333e-3 * t38 * t39 * t55 * t65 - 0.93333333333333333333333333333333333333333333333333e-3 * t40 * t56 * t164 * (0.12600000000000000000000000000000000000000000000000e-1 / t57 * t59 * t61 + 0.12600000000000000000000000000000000000000000000000e-1 * t55 * t172)) / 0.9e1)
  t316 = f.my_piecewise3(t110, 0, t315)
  t332 = f.my_piecewise3(t11, 0, 0.90028845000000000000000000000000000000000000000000e0 * t21 * t122 * t316 * t125 + 0.25000000000000000000000000000000000000000000000000e0 * t21 * t206 * (-0.1255604961228840000e3 * t208 * t316 - 0.448930493742276000e2 * t117 * t316 - 0.3566671817400e1 * t120 * t316))
  vsigma_0_ = t2 * t332
  vsigma_1_ = 0.0e0
  t353 = f.my_piecewise3(t78, 0, -t40 * t84 * t244 * (0.93333333333333333333333333333333333333333333333333e-3 * t38 * t39 * t89 * t99 - 0.93333333333333333333333333333333333333333333333333e-3 * t40 * t90 * t253 * (0.12600000000000000000000000000000000000000000000000e-1 / t91 * t93 * t95 + 0.12600000000000000000000000000000000000000000000000e-1 * t89 * t261)) / 0.9e1)
  t354 = f.my_piecewise3(t110, 0, t353)
  t370 = f.my_piecewise3(t11, 0, 0.90028845000000000000000000000000000000000000000000e0 * t21 * t122 * t354 * t125 + 0.25000000000000000000000000000000000000000000000000e0 * t21 * t206 * (-0.1255604961228840000e3 * t208 * t354 - 0.448930493742276000e2 * t117 * t354 - 0.3566671817400e1 * t120 * t354))
  vsigma_2_ = t2 * t370
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_beta = 0.0042

  params_gamma = 6

  op_a1 = 1.5214

  op_a2 = 0.5764

  op_b1 = 1.1284

  op_b2 = 0.3183

  op_qab = 2.367

  b88_f = lambda x: 1 + params_beta / X_FACTOR_C * x ** 2 / (1 + params_gamma * params_beta * x * jnp.arcsinh(x))

  op_enhancement = lambda xs: b88_f(xs)

  op_b88_zab = lambda f_x, rs, z, xs0, xs1: f.my_piecewise3(b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1) == 0, DBL_EPSILON, b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1))

  op_beta = lambda rs, z, xs0, xs1: op_qab / op_b88_zab(op_enhancement, rs, z, xs0, xs1)

  op_f_s = lambda rs, z, xt, xs0, xs1: -(1 - z ** 2) * f.n_total(rs) / 4.0 * (op_a1 * op_beta(rs, z, xs0, xs1) + op_a2) / (op_beta(rs, z, xs0, xs1) ** 4 + op_b1 * op_beta(rs, z, xs0, xs1) ** 3 + op_b2 * op_beta(rs, z, xs0, xs1) ** 2)

  op_f = lambda rs, z, xt, xs0, xs1: f.my_piecewise3(jnp.logical_or(1 - jnp.abs(z) <= f.p.zeta_threshold, jnp.logical_and(f.screen_dens(rs, z), f.screen_dens(rs, -z))), 0, op_f_s(rs, f.z_thr(z), xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1: op_f(rs, z, xt, xs0, xs1)

  t1 = 0.1e1 <= f.p.zeta_threshold
  t4 = t1 or r0 / 0.2e1 <= f.p.dens_threshold
  t5 = f.p.zeta_threshold - 0.1e1
  t6 = -t5
  t7 = f.my_piecewise5(t1, t5, t1, t6, 0)
  t8 = t7 ** 2
  t9 = 0.1e1 - t8
  t10 = t9 * r0
  t11 = 0.1e1 + t7
  t14 = t11 * r0 / 0.2e1 <= f.p.dens_threshold
  t15 = 3 ** (0.1e1 / 0.3e1)
  t16 = t15 ** 2
  t18 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t20 = t16 / t18
  t21 = 4 ** (0.1e1 / 0.3e1)
  t22 = t20 * t21
  t23 = 2 ** (0.1e1 / 0.3e1)
  t24 = t11 <= f.p.zeta_threshold
  t25 = 0.1e1 - t7
  t26 = t25 <= f.p.zeta_threshold
  t27 = f.my_piecewise5(t24, t5, t26, t6, t7)
  t28 = 0.1e1 + t27
  t29 = t28 * r0
  t30 = t29 ** (0.1e1 / 0.3e1)
  t32 = t23 / t30
  t33 = t23 ** 2
  t34 = s0 * t33
  t35 = r0 ** 2
  t36 = r0 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t39 = 0.1e1 / t37 / t35
  t40 = jnp.sqrt(s0)
  t41 = t40 * t23
  t43 = 0.1e1 / t36 / r0
  t45 = jnp.arcsinh(t41 * t43)
  t46 = t43 * t45
  t49 = 0.1e1 + 0.2520e-1 * t41 * t46
  t50 = 0.1e1 / t49
  t55 = 0.1e1 + 0.93333333333333333333333333333333333333333333333333e-3 * t22 * t34 * t39 * t50
  t56 = 0.1e1 / t55
  t60 = f.my_piecewise3(t14, 0, t22 * t32 * t56 / 0.9e1)
  t64 = t25 * r0 / 0.2e1 <= f.p.dens_threshold
  t65 = f.my_piecewise5(t26, t5, t24, t6, -t7)
  t66 = 0.1e1 + t65
  t67 = t66 * r0
  t68 = t67 ** (0.1e1 / 0.3e1)
  t70 = t23 / t68
  t74 = f.my_piecewise3(t64, 0, t22 * t70 * t56 / 0.9e1)
  t75 = t60 + t74
  t76 = t75 == 0.0e0
  t77 = f.my_piecewise3(t76, DBL_EPSILON, t75)
  t80 = 0.360115380e1 / t77 + 0.5764e0
  t81 = t77 ** 2
  t82 = t81 ** 2
  t83 = 0.1e1 / t82
  t86 = 0.1e1 / t81 / t77
  t88 = 0.1e1 / t81
  t90 = 0.313901240307210000e2 * t83 + 0.149643497914092000e2 * t86 + 0.1783335908700e1 * t88
  t91 = 0.1e1 / t90
  t95 = f.my_piecewise3(t4, 0, -0.25000000000000000000000000000000000000000000000000e0 * t10 * t80 * t91)
  t106 = t55 ** 2
  t107 = 0.1e1 / t106
  t110 = 0.1e1 / t37 / t35 / r0
  t116 = t20 * t21 * s0
  t117 = t33 * t39
  t118 = t49 ** 2
  t119 = 0.1e1 / t118
  t127 = jnp.sqrt(t34 * t39 + 0.1e1)
  t128 = 0.1e1 / t127
  t138 = t107 * (-0.24888888888888888888888888888888888888888888888889e-2 * t22 * t34 * t110 * t50 - 0.93333333333333333333333333333333333333333333333333e-3 * t116 * t117 * t119 * (-0.33600000000000000000000000000000000000000000000000e-1 * t41 / t36 / t35 * t45 - 0.33600000000000000000000000000000000000000000000000e-1 * t34 * t110 * t128))
  t143 = f.my_piecewise3(t14, 0, -t22 * t23 / t30 / t29 * t56 * t28 / 0.27e2 - t22 * t32 * t138 / 0.9e1)
  t155 = f.my_piecewise3(t64, 0, -t22 * t23 / t68 / t67 * t56 * t66 / 0.27e2 - t22 * t70 * t138 / 0.9e1)
  t157 = f.my_piecewise3(t76, 0, t143 + t155)
  t162 = t90 ** 2
  t164 = t80 / t162
  t166 = 0.1e1 / t82 / t77
  t178 = f.my_piecewise3(t4, 0, -0.25000000000000000000000000000000000000000000000000e0 * t9 * t80 * t91 + 0.90028845000000000000000000000000000000000000000000e0 * t10 * t88 * t157 * t91 + 0.25000000000000000000000000000000000000000000000000e0 * t10 * t164 * (-0.1255604961228840000e3 * t166 * t157 - 0.448930493742276000e2 * t83 * t157 - 0.3566671817400e1 * t86 * t157))
  vrho_0_ = r0 * t178 + t95
  t195 = t107 * (0.93333333333333333333333333333333333333333333333333e-3 * t22 * t117 * t50 - 0.93333333333333333333333333333333333333333333333333e-3 * t116 * t117 * t119 * (0.12600000000000000000000000000000000000000000000000e-1 / t40 * t23 * t46 + 0.12600000000000000000000000000000000000000000000000e-1 * t117 * t128))
  t199 = f.my_piecewise3(t14, 0, -t22 * t32 * t195 / 0.9e1)
  t203 = f.my_piecewise3(t64, 0, -t22 * t70 * t195 / 0.9e1)
  t205 = f.my_piecewise3(t76, 0, t199 + t203)
  t221 = f.my_piecewise3(t4, 0, 0.90028845000000000000000000000000000000000000000000e0 * t10 * t88 * t205 * t91 + 0.25000000000000000000000000000000000000000000000000e0 * t10 * t164 * (-0.1255604961228840000e3 * t166 * t205 - 0.448930493742276000e2 * t83 * t205 - 0.3566671817400e1 * t86 * t205))
  vsigma_0_ = r0 * t221
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 0.1e1 <= f.p.zeta_threshold
  t4 = t1 or r0 / 0.2e1 <= f.p.dens_threshold
  t5 = f.p.zeta_threshold - 0.1e1
  t6 = -t5
  t7 = f.my_piecewise5(t1, t5, t1, t6, 0)
  t8 = t7 ** 2
  t9 = 0.1e1 - t8
  t10 = 0.1e1 + t7
  t13 = t10 * r0 / 0.2e1 <= f.p.dens_threshold
  t14 = 3 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t19 = t15 / t17
  t20 = 4 ** (0.1e1 / 0.3e1)
  t21 = t19 * t20
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = t10 <= f.p.zeta_threshold
  t24 = 0.1e1 - t7
  t25 = t24 <= f.p.zeta_threshold
  t26 = f.my_piecewise5(t23, t5, t25, t6, t7)
  t27 = 0.1e1 + t26
  t28 = t27 * r0
  t29 = t28 ** (0.1e1 / 0.3e1)
  t30 = 0.1e1 / t29
  t31 = t22 * t30
  t32 = t22 ** 2
  t33 = s0 * t32
  t34 = r0 ** 2
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / t34
  t39 = jnp.sqrt(s0)
  t40 = t39 * t22
  t42 = 0.1e1 / t35 / r0
  t44 = jnp.arcsinh(t40 * t42)
  t45 = t42 * t44
  t48 = 0.1e1 + 0.2520e-1 * t40 * t45
  t49 = 0.1e1 / t48
  t54 = 0.1e1 + 0.93333333333333333333333333333333333333333333333332e-3 * t21 * t33 * t38 * t49
  t55 = 0.1e1 / t54
  t59 = f.my_piecewise3(t13, 0, t21 * t31 * t55 / 0.9e1)
  t63 = t24 * r0 / 0.2e1 <= f.p.dens_threshold
  t64 = f.my_piecewise5(t25, t5, t23, t6, -t7)
  t65 = 0.1e1 + t64
  t66 = t65 * r0
  t67 = t66 ** (0.1e1 / 0.3e1)
  t68 = 0.1e1 / t67
  t69 = t22 * t68
  t73 = f.my_piecewise3(t63, 0, t21 * t69 * t55 / 0.9e1)
  t74 = t59 + t73
  t75 = t74 == 0.0e0
  t76 = f.my_piecewise3(t75, DBL_EPSILON, t74)
  t79 = 0.360115380e1 / t76 + 0.5764e0
  t80 = t9 * t79
  t81 = t76 ** 2
  t82 = t81 ** 2
  t83 = 0.1e1 / t82
  t86 = 0.1e1 / t81 / t76
  t88 = 0.1e1 / t81
  t90 = 0.313901240307210000e2 * t83 + 0.149643497914092000e2 * t86 + 0.1783335908700e1 * t88
  t91 = 0.1e1 / t90
  t94 = t9 * r0
  t96 = 0.1e1 / t29 / t28
  t102 = t54 ** 2
  t103 = 0.1e1 / t102
  t104 = t34 * r0
  t106 = 0.1e1 / t36 / t104
  t112 = t19 * t20 * s0
  t113 = t32 * t38
  t114 = t48 ** 2
  t115 = 0.1e1 / t114
  t118 = 0.1e1 / t35 / t34 * t44
  t122 = t33 * t38 + 0.1e1
  t123 = jnp.sqrt(t122)
  t124 = 0.1e1 / t123
  t128 = -0.33600000000000000000000000000000000000000000000000e-1 * t40 * t118 - 0.33600000000000000000000000000000000000000000000000e-1 * t33 * t106 * t124
  t129 = t115 * t128
  t130 = t113 * t129
  t133 = -0.24888888888888888888888888888888888888888888888889e-2 * t21 * t33 * t106 * t49 - 0.93333333333333333333333333333333333333333333333332e-3 * t112 * t130
  t134 = t103 * t133
  t139 = f.my_piecewise3(t13, 0, -t21 * t22 * t96 * t55 * t27 / 0.27e2 - t21 * t31 * t134 / 0.9e1)
  t141 = 0.1e1 / t67 / t66
  t151 = f.my_piecewise3(t63, 0, -t21 * t22 * t141 * t55 * t65 / 0.27e2 - t21 * t69 * t134 / 0.9e1)
  t153 = f.my_piecewise3(t75, 0, t139 + t151)
  t158 = t90 ** 2
  t159 = 0.1e1 / t158
  t160 = t79 * t159
  t162 = 0.1e1 / t82 / t76
  t169 = -0.1255604961228840000e3 * t162 * t153 - 0.448930493742276000e2 * t83 * t153 - 0.3566671817400e1 * t86 * t153
  t174 = f.my_piecewise3(t4, 0, -0.25000000000000000000000000000000000000000000000000e0 * t80 * t91 + 0.90028845000000000000000000000000000000000000000000e0 * t94 * t88 * t153 * t91 + 0.25000000000000000000000000000000000000000000000000e0 * t94 * t160 * t169)
  t176 = t9 * t88
  t183 = t153 ** 2
  t188 = t27 ** 2
  t198 = t19 * t20 * t22
  t199 = t96 * t103
  t205 = 0.1e1 / t102 / t54
  t206 = t133 ** 2
  t207 = t205 * t206
  t211 = t34 ** 2
  t213 = 0.1e1 / t36 / t211
  t218 = t32 * t106
  t223 = 0.1e1 / t114 / t48
  t224 = t128 ** 2
  t237 = s0 ** 2
  t243 = 0.1e1 / t123 / t122
  t253 = t103 * (0.91259259259259259259259259259259259259259259259260e-2 * t21 * t33 * t213 * t49 + 0.49777777777777777777777777777777777777777777777778e-2 * t112 * t218 * t129 + 0.18666666666666666666666666666666666666666666666666e-2 * t112 * t113 * t223 * t224 - 0.93333333333333333333333333333333333333333333333332e-3 * t112 * t113 * t115 * (0.78400000000000000000000000000000000000000000000000e-1 * t40 / t35 / t104 * t44 + 0.16800000000000000000000000000000000000000000000000e0 * t33 * t213 * t124 - 0.89600000000000000000000000000000000000000000000000e-1 * t237 * t22 / t35 / t211 / t104 * t243))
  t258 = f.my_piecewise3(t13, 0, 0.4e1 / 0.81e2 * t21 * t22 / t29 / t34 * t55 + 0.2e1 / 0.27e2 * t198 * t199 * t27 * t133 + 0.2e1 / 0.9e1 * t21 * t31 * t207 - t21 * t31 * t253 / 0.9e1)
  t259 = t65 ** 2
  t268 = t141 * t103
  t280 = f.my_piecewise3(t63, 0, 0.4e1 / 0.81e2 * t21 * t22 / t67 / t34 * t55 + 0.2e1 / 0.27e2 * t198 * t268 * t65 * t133 + 0.2e1 / 0.9e1 * t21 * t69 * t207 - t21 * t69 * t253 / 0.9e1)
  t282 = f.my_piecewise3(t75, 0, t258 + t280)
  t287 = t94 * t88
  t288 = t153 * t159
  t293 = 0.1e1 / t158 / t90
  t294 = t79 * t293
  t295 = t169 ** 2
  t300 = 0.1e1 / t82 / t81
  t318 = f.my_piecewise3(t4, 0, 0.18005769000000000000000000000000000000000000000000e1 * t176 * t153 * t91 + 0.50000000000000000000000000000000000000000000000000e0 * t80 * t159 * t169 - 0.18005769000000000000000000000000000000000000000000e1 * t94 * t86 * t183 * t91 + 0.90028845000000000000000000000000000000000000000000e0 * t94 * t88 * t282 * t91 - 0.18005769000000000000000000000000000000000000000000e1 * t287 * t288 * t169 - 0.50000000000000000000000000000000000000000000000000e0 * t94 * t294 * t295 + 0.25000000000000000000000000000000000000000000000000e0 * t94 * t160 * (0.6278024806144200000e3 * t300 * t183 - 0.1255604961228840000e3 * t162 * t282 + 0.1795721974969104000e3 * t162 * t183 - 0.448930493742276000e2 * t83 * t282 + 0.10700015452200e2 * t83 * t183 - 0.3566671817400e1 * t86 * t282))
  v2rho2_0_ = r0 * t318 + 0.2e1 * t174
  t324 = 0.1e1 / t39 * t22
  t329 = 0.12600000000000000000000000000000000000000000000000e-1 * t324 * t45 + 0.12600000000000000000000000000000000000000000000000e-1 * t113 * t124
  t330 = t115 * t329
  t331 = t113 * t330
  t334 = 0.93333333333333333333333333333333333333333333333332e-3 * t21 * t113 * t49 - 0.93333333333333333333333333333333333333333333333332e-3 * t112 * t331
  t335 = t103 * t334
  t339 = f.my_piecewise3(t13, 0, -t21 * t31 * t335 / 0.9e1)
  t343 = f.my_piecewise3(t63, 0, -t21 * t69 * t335 / 0.9e1)
  t345 = f.my_piecewise3(t75, 0, t339 + t343)
  t350 = t162 * t345
  t352 = t83 * t345
  t356 = -0.1255604961228840000e3 * t350 - 0.448930493742276000e2 * t352 - 0.3566671817400e1 * t86 * t345
  t361 = f.my_piecewise3(t4, 0, 0.90028845000000000000000000000000000000000000000000e0 * t94 * t88 * t345 * t91 + 0.25000000000000000000000000000000000000000000000000e0 * t94 * t160 * t356)
  t362 = t345 * t91
  t374 = t334 * t133
  t408 = t103 * (-0.24888888888888888888888888888888888888888888888889e-2 * t21 * t218 * t49 - 0.93333333333333333333333333333333333333333333333332e-3 * t21 * t130 + 0.24888888888888888888888888888888888888888888888889e-2 * t112 * t218 * t330 + 0.18666666666666666666666666666666666666666666666666e-2 * t112 * t113 * t223 * t329 * t128 - 0.93333333333333333333333333333333333333333333333332e-3 * t112 * t113 * t115 * (-0.16800000000000000000000000000000000000000000000000e-1 * t324 * t118 - 0.50400000000000000000000000000000000000000000000000e-1 * t218 * t124 + 0.33600000000000000000000000000000000000000000000000e-1 * t22 / t35 / t211 / t34 * t243 * s0))
  t413 = f.my_piecewise3(t13, 0, t198 * t199 * t334 * t27 / 0.27e2 + 0.2e1 / 0.9e1 * t198 * t30 * t205 * t374 - t21 * t31 * t408 / 0.9e1)
  t426 = f.my_piecewise3(t63, 0, t198 * t268 * t334 * t65 / 0.27e2 + 0.2e1 / 0.9e1 * t198 * t68 * t205 * t374 - t21 * t69 * t408 / 0.9e1)
  t428 = f.my_piecewise3(t75, 0, t413 + t426)
  t433 = t345 * t159
  t466 = f.my_piecewise3(t4, 0, 0.90028845000000000000000000000000000000000000000000e0 * t176 * t362 - 0.18005769000000000000000000000000000000000000000000e1 * t94 * t86 * t362 * t153 + 0.90028845000000000000000000000000000000000000000000e0 * t94 * t88 * t428 * t91 - 0.90028845000000000000000000000000000000000000000000e0 * t287 * t433 * t169 + 0.25000000000000000000000000000000000000000000000000e0 * t80 * t159 * t356 - 0.90028845000000000000000000000000000000000000000000e0 * t287 * t288 * t356 - 0.50000000000000000000000000000000000000000000000000e0 * t94 * t79 * t293 * t356 * t169 + 0.25000000000000000000000000000000000000000000000000e0 * t94 * t160 * (0.6278024806144200000e3 * t300 * t345 * t153 - 0.1255604961228840000e3 * t162 * t428 + 0.1795721974969104000e3 * t350 * t153 - 0.448930493742276000e2 * t83 * t428 + 0.10700015452200e2 * t352 * t153 - 0.3566671817400e1 * t86 * t428))
  v2rhosigma_0_ = r0 * t466 + t361
  t468 = t345 ** 2
  t473 = t334 ** 2
  t474 = t205 * t473
  t480 = t329 ** 2
  t507 = t103 * (-0.18666666666666666666666666666666666666666666666666e-2 * t21 * t331 + 0.18666666666666666666666666666666666666666666666666e-2 * t112 * t113 * t223 * t480 - 0.93333333333333333333333333333333333333333333333332e-3 * t112 * t113 * t115 * (-0.63000000000000000000000000000000000000000000000000e-2 / t39 / s0 * t22 * t45 + 0.63000000000000000000000000000000000000000000000000e-2 / s0 * t32 * t38 * t124 - 0.12600000000000000000000000000000000000000000000000e-1 * t22 / t35 / t211 / r0 * t243))
  t512 = f.my_piecewise3(t13, 0, 0.2e1 / 0.9e1 * t21 * t31 * t474 - t21 * t31 * t507 / 0.9e1)
  t520 = f.my_piecewise3(t63, 0, 0.2e1 / 0.9e1 * t21 * t69 * t474 - t21 * t69 * t507 / 0.9e1)
  t522 = f.my_piecewise3(t75, 0, t512 + t520)
  t530 = t356 ** 2
  t551 = f.my_piecewise3(t4, 0, -0.18005769000000000000000000000000000000000000000000e1 * t94 * t86 * t468 * t91 + 0.90028845000000000000000000000000000000000000000000e0 * t94 * t88 * t522 * t91 - 0.18005769000000000000000000000000000000000000000000e1 * t287 * t433 * t356 - 0.50000000000000000000000000000000000000000000000000e0 * t94 * t294 * t530 + 0.25000000000000000000000000000000000000000000000000e0 * t94 * t160 * (0.6278024806144200000e3 * t300 * t468 - 0.1255604961228840000e3 * t162 * t522 + 0.1795721974969104000e3 * t162 * t468 - 0.448930493742276000e2 * t83 * t522 + 0.10700015452200e2 * t83 * t468 - 0.3566671817400e1 * t86 * t522))
  v2sigma2_0_ = r0 * t551
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 0.1e1 <= f.p.zeta_threshold
  t4 = t1 or r0 / 0.2e1 <= f.p.dens_threshold
  t5 = f.p.zeta_threshold - 0.1e1
  t6 = -t5
  t7 = f.my_piecewise5(t1, t5, t1, t6, 0)
  t8 = t7 ** 2
  t9 = 0.1e1 - t8
  t10 = 0.1e1 + t7
  t13 = t10 * r0 / 0.2e1 <= f.p.dens_threshold
  t14 = 3 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t19 = t15 / t17
  t20 = 4 ** (0.1e1 / 0.3e1)
  t21 = t19 * t20
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = t10 <= f.p.zeta_threshold
  t24 = 0.1e1 - t7
  t25 = t24 <= f.p.zeta_threshold
  t26 = f.my_piecewise5(t23, t5, t25, t6, t7)
  t27 = 0.1e1 + t26
  t28 = t27 * r0
  t29 = t28 ** (0.1e1 / 0.3e1)
  t30 = 0.1e1 / t29
  t31 = t22 * t30
  t32 = t22 ** 2
  t33 = s0 * t32
  t34 = r0 ** 2
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / t34
  t39 = jnp.sqrt(s0)
  t40 = t39 * t22
  t42 = 0.1e1 / t35 / r0
  t44 = jnp.asinh(t40 * t42)
  t48 = 0.1e1 + 0.2520e-1 * t40 * t42 * t44
  t49 = 0.1e1 / t48
  t54 = 0.1e1 + 0.93333333333333333333333333333333333333333333333332e-3 * t21 * t33 * t38 * t49
  t55 = 0.1e1 / t54
  t59 = f.my_piecewise3(t13, 0, t21 * t31 * t55 / 0.9e1)
  t63 = t24 * r0 / 0.2e1 <= f.p.dens_threshold
  t64 = f.my_piecewise5(t25, t5, t23, t6, -t7)
  t65 = 0.1e1 + t64
  t66 = t65 * r0
  t67 = t66 ** (0.1e1 / 0.3e1)
  t68 = 0.1e1 / t67
  t69 = t22 * t68
  t73 = f.my_piecewise3(t63, 0, t21 * t69 * t55 / 0.9e1)
  t74 = t59 + t73
  t75 = t74 == 0.0e0
  t76 = f.my_piecewise3(t75, DBL_EPSILON, t74)
  t77 = t76 ** 2
  t78 = 0.1e1 / t77
  t79 = t9 * t78
  t81 = 0.1e1 / t29 / t28
  t87 = t54 ** 2
  t88 = 0.1e1 / t87
  t89 = t34 * r0
  t91 = 0.1e1 / t36 / t89
  t97 = t19 * t20 * s0
  t98 = t32 * t38
  t99 = t48 ** 2
  t100 = 0.1e1 / t99
  t107 = t33 * t38 + 0.1e1
  t108 = jnp.sqrt(t107)
  t109 = 0.1e1 / t108
  t113 = -0.33600000000000000000000000000000000000000000000000e-1 * t40 / t35 / t34 * t44 - 0.33600000000000000000000000000000000000000000000000e-1 * t33 * t91 * t109
  t114 = t100 * t113
  t118 = -0.24888888888888888888888888888888888888888888888889e-2 * t21 * t33 * t91 * t49 - 0.93333333333333333333333333333333333333333333333332e-3 * t97 * t98 * t114
  t119 = t88 * t118
  t124 = f.my_piecewise3(t13, 0, -t21 * t22 * t81 * t55 * t27 / 0.27e2 - t21 * t31 * t119 / 0.9e1)
  t126 = 0.1e1 / t67 / t66
  t136 = f.my_piecewise3(t63, 0, -t21 * t22 * t126 * t55 * t65 / 0.27e2 - t21 * t69 * t119 / 0.9e1)
  t138 = f.my_piecewise3(t75, 0, t124 + t136)
  t139 = t77 ** 2
  t140 = 0.1e1 / t139
  t142 = t77 * t76
  t143 = 0.1e1 / t142
  t146 = 0.313901240307210000e2 * t140 + 0.149643497914092000e2 * t143 + 0.1783335908700e1 * t78
  t147 = 0.1e1 / t146
  t148 = t138 * t147
  t153 = 0.360115380e1 / t76 + 0.5764e0
  t154 = t9 * t153
  t155 = t146 ** 2
  t156 = 0.1e1 / t155
  t158 = 0.1e1 / t139 / t76
  t159 = t158 * t138
  t161 = t140 * t138
  t165 = -0.1255604961228840000e3 * t159 - 0.448930493742276000e2 * t161 - 0.3566671817400e1 * t143 * t138
  t169 = t9 * r0
  t170 = t138 ** 2
  t175 = t27 ** 2
  t178 = 0.1e1 / t29 / t175 / t34
  t185 = t19 * t20 * t22
  t186 = t81 * t88
  t192 = 0.1e1 / t87 / t54
  t193 = t118 ** 2
  t194 = t192 * t193
  t198 = t34 ** 2
  t200 = 0.1e1 / t36 / t198
  t205 = t32 * t91
  t210 = 0.1e1 / t99 / t48
  t211 = t113 ** 2
  t212 = t210 * t211
  t224 = s0 ** 2
  t225 = t224 * t22
  t230 = 0.1e1 / t108 / t107
  t234 = 0.78400000000000000000000000000000000000000000000000e-1 * t40 / t35 / t89 * t44 + 0.16800000000000000000000000000000000000000000000000e0 * t33 * t200 * t109 - 0.89600000000000000000000000000000000000000000000000e-1 * t225 / t35 / t198 / t89 * t230
  t235 = t100 * t234
  t239 = 0.91259259259259259259259259259259259259259259259260e-2 * t21 * t33 * t200 * t49 + 0.49777777777777777777777777777777777777777777777778e-2 * t97 * t205 * t114 + 0.18666666666666666666666666666666666666666666666666e-2 * t97 * t98 * t212 - 0.93333333333333333333333333333333333333333333333332e-3 * t97 * t98 * t235
  t240 = t88 * t239
  t245 = f.my_piecewise3(t13, 0, 0.4e1 / 0.81e2 * t21 * t22 * t178 * t55 * t175 + 0.2e1 / 0.27e2 * t185 * t186 * t27 * t118 + 0.2e1 / 0.9e1 * t21 * t31 * t194 - t21 * t31 * t240 / 0.9e1)
  t246 = t65 ** 2
  t249 = 0.1e1 / t67 / t246 / t34
  t255 = t126 * t88
  t267 = f.my_piecewise3(t63, 0, 0.4e1 / 0.81e2 * t21 * t22 * t249 * t55 * t246 + 0.2e1 / 0.27e2 * t185 * t255 * t65 * t118 + 0.2e1 / 0.9e1 * t21 * t69 * t194 - t21 * t69 * t240 / 0.9e1)
  t269 = f.my_piecewise3(t75, 0, t245 + t267)
  t274 = t169 * t78
  t275 = t138 * t156
  t276 = t275 * t165
  t280 = 0.1e1 / t155 / t146
  t282 = t165 ** 2
  t286 = t153 * t156
  t288 = 0.1e1 / t139 / t77
  t301 = 0.6278024806144200000e3 * t288 * t170 - 0.1255604961228840000e3 * t158 * t269 + 0.1795721974969104000e3 * t158 * t170 - 0.448930493742276000e2 * t140 * t269 + 0.10700015452200e2 * t140 * t170 - 0.3566671817400e1 * t143 * t269
  t306 = f.my_piecewise3(t4, 0, 0.18005769000000000000000000000000000000000000000000e1 * t79 * t148 + 0.50000000000000000000000000000000000000000000000000e0 * t154 * t156 * t165 - 0.18005769000000000000000000000000000000000000000000e1 * t169 * t143 * t170 * t147 + 0.90028845000000000000000000000000000000000000000000e0 * t169 * t78 * t269 * t147 - 0.18005769000000000000000000000000000000000000000000e1 * t274 * t276 - 0.50000000000000000000000000000000000000000000000000e0 * t169 * t153 * t280 * t282 + 0.25000000000000000000000000000000000000000000000000e0 * t169 * t286 * t301)
  t312 = t175 * t27
  t335 = t87 ** 2
  t338 = 0.1e1 / t335 * t193 * t118
  t343 = t118 * t239
  t349 = 0.1e1 / t36 / t198 / r0
  t364 = t99 ** 2
  t384 = t198 ** 2
  t394 = t107 ** 2
  t405 = t88 * (-0.42587654320987654320987654320987654320987654320988e-1 * t21 * t33 * t349 * t49 - 0.27377777777777777777777777777777777777777777777778e-1 * t97 * t32 * t200 * t114 - 0.14933333333333333333333333333333333333333333333333e-1 * t97 * t205 * t212 + 0.74666666666666666666666666666666666666666666666667e-2 * t97 * t205 * t235 - 0.55999999999999999999999999999999999999999999999998e-2 * t97 * t98 / t364 * t211 * t113 + 0.55999999999999999999999999999999999999999999999998e-2 * t97 * t98 * t210 * t113 * t234 - 0.93333333333333333333333333333333333333333333333332e-3 * t97 * t98 * t100 * (-0.26133333333333333333333333333333333333333333333333e0 * t40 / t35 / t198 * t44 - 0.88853333333333333333333333333333333333333333333333e0 * t33 * t349 * t109 + 0.11050666666666666666666666666666666666666666666667e1 * t225 / t35 / t384 * t230 - 0.71680000000000000000000000000000000000000000000000e0 * t224 * s0 / t384 / t89 / t108 / t394))
  t410 = f.my_piecewise3(t13, 0, -0.28e2 / 0.243e3 * t21 * t22 / t29 / t89 * t55 - 0.4e1 / 0.27e2 * t185 * t178 * t88 * t175 * t118 - 0.2e1 / 0.9e1 * t185 * t81 * t192 * t27 * t193 + t185 * t186 * t27 * t239 / 0.9e1 - 0.2e1 / 0.3e1 * t21 * t31 * t338 + 0.2e1 / 0.3e1 * t185 * t30 * t192 * t343 - t21 * t31 * t405 / 0.9e1)
  t411 = t246 * t65
  t445 = f.my_piecewise3(t63, 0, -0.28e2 / 0.243e3 * t21 * t22 / t67 / t89 * t55 - 0.4e1 / 0.27e2 * t185 * t249 * t88 * t246 * t118 - 0.2e1 / 0.9e1 * t185 * t126 * t192 * t65 * t193 + t185 * t255 * t65 * t239 / 0.9e1 - 0.2e1 / 0.3e1 * t21 * t69 * t338 + 0.2e1 / 0.3e1 * t185 * t68 * t192 * t343 - t21 * t69 * t405 / 0.9e1)
  t447 = f.my_piecewise3(t75, 0, t410 + t445)
  t463 = t170 * t138
  t500 = t155 ** 2
  t516 = t169 * t143
  t524 = 0.54017307000000000000000000000000000000000000000000e1 * t274 * t138 * t280 * t282 + 0.90028845000000000000000000000000000000000000000000e0 * t169 * t78 * t447 * t147 - 0.15000000000000000000000000000000000000000000000000e1 * t154 * t280 * t282 - 0.54017307000000000000000000000000000000000000000000e1 * t79 * t276 - 0.54017307000000000000000000000000000000000000000000e1 * t9 * t143 * t170 * t147 + 0.25000000000000000000000000000000000000000000000000e0 * t169 * t286 * (-0.37668148836865200000e4 / t139 / t142 * t463 + 0.18834074418432600000e4 * t288 * t138 * t269 - 0.1255604961228840000e3 * t158 * t447 - 0.8978609874845520000e3 * t288 * t463 + 0.5387165924907312000e3 * t159 * t269 - 0.448930493742276000e2 * t140 * t447 - 0.42800061808800e2 * t158 * t463 + 0.32100046356600e2 * t161 * t269 - 0.3566671817400e1 * t143 * t447) - 0.27008653500000000000000000000000000000000000000000e1 * t274 * t269 * t156 * t165 - 0.27008653500000000000000000000000000000000000000000e1 * t274 * t275 * t301 + 0.27008653500000000000000000000000000000000000000000e1 * t79 * t269 * t147 + 0.75000000000000000000000000000000000000000000000000e0 * t154 * t156 * t301 + 0.15000000000000000000000000000000000000000000000000e1 * t169 * t153 / t500 * t282 * t165 - 0.15000000000000000000000000000000000000000000000000e1 * t169 * t153 * t280 * t165 * t301 + 0.54017307000000000000000000000000000000000000000000e1 * t169 * t140 * t463 * t147 - 0.54017307000000000000000000000000000000000000000000e1 * t516 * t148 * t269 + 0.54017307000000000000000000000000000000000000000000e1 * t516 * t170 * t156 * t165
  t525 = f.my_piecewise3(t4, 0, t524)
  v3rho3_0_ = r0 * t525 + 0.3e1 * t306

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 0.1e1 <= f.p.zeta_threshold
  t4 = t1 or r0 / 0.2e1 <= f.p.dens_threshold
  t5 = f.p.zeta_threshold - 0.1e1
  t6 = -t5
  t7 = f.my_piecewise5(t1, t5, t1, t6, 0)
  t8 = t7 ** 2
  t9 = 0.1e1 - t8
  t10 = t9 * r0
  t11 = 0.1e1 + t7
  t14 = t11 * r0 / 0.2e1 <= f.p.dens_threshold
  t15 = 3 ** (0.1e1 / 0.3e1)
  t16 = t15 ** 2
  t18 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t20 = t16 / t18
  t21 = 4 ** (0.1e1 / 0.3e1)
  t22 = t20 * t21
  t23 = 2 ** (0.1e1 / 0.3e1)
  t24 = t11 <= f.p.zeta_threshold
  t25 = 0.1e1 - t7
  t26 = t25 <= f.p.zeta_threshold
  t27 = f.my_piecewise5(t24, t5, t26, t6, t7)
  t28 = 0.1e1 + t27
  t29 = t28 * r0
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = 0.1e1 / t30
  t32 = t23 * t31
  t33 = t23 ** 2
  t34 = s0 * t33
  t35 = r0 ** 2
  t36 = r0 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t39 = 0.1e1 / t37 / t35
  t40 = jnp.sqrt(s0)
  t41 = t40 * t23
  t43 = 0.1e1 / t36 / r0
  t45 = jnp.asinh(t41 * t43)
  t49 = 0.1e1 + 0.2520e-1 * t41 * t43 * t45
  t50 = 0.1e1 / t49
  t55 = 0.1e1 + 0.93333333333333333333333333333333333333333333333332e-3 * t22 * t34 * t39 * t50
  t56 = 0.1e1 / t55
  t60 = f.my_piecewise3(t14, 0, t22 * t32 * t56 / 0.9e1)
  t64 = t25 * r0 / 0.2e1 <= f.p.dens_threshold
  t65 = f.my_piecewise5(t26, t5, t24, t6, -t7)
  t66 = 0.1e1 + t65
  t67 = t66 * r0
  t68 = t67 ** (0.1e1 / 0.3e1)
  t69 = 0.1e1 / t68
  t70 = t23 * t69
  t74 = f.my_piecewise3(t64, 0, t22 * t70 * t56 / 0.9e1)
  t75 = t60 + t74
  t76 = t75 == 0.0e0
  t77 = f.my_piecewise3(t76, DBL_EPSILON, t75)
  t78 = t77 ** 2
  t79 = 0.1e1 / t78
  t80 = t10 * t79
  t82 = 0.1e1 / t30 / t29
  t88 = t55 ** 2
  t89 = 0.1e1 / t88
  t90 = t35 * r0
  t92 = 0.1e1 / t37 / t90
  t98 = t20 * t21 * s0
  t99 = t33 * t39
  t100 = t49 ** 2
  t101 = 0.1e1 / t100
  t108 = t34 * t39 + 0.1e1
  t109 = jnp.sqrt(t108)
  t110 = 0.1e1 / t109
  t114 = -0.33600000000000000000000000000000000000000000000000e-1 * t41 / t36 / t35 * t45 - 0.33600000000000000000000000000000000000000000000000e-1 * t34 * t92 * t110
  t115 = t101 * t114
  t119 = -0.24888888888888888888888888888888888888888888888889e-2 * t22 * t34 * t92 * t50 - 0.93333333333333333333333333333333333333333333333332e-3 * t98 * t99 * t115
  t120 = t89 * t119
  t125 = f.my_piecewise3(t14, 0, -t22 * t23 * t82 * t56 * t28 / 0.27e2 - t22 * t32 * t120 / 0.9e1)
  t127 = 0.1e1 / t68 / t67
  t137 = f.my_piecewise3(t64, 0, -t22 * t23 * t127 * t56 * t66 / 0.27e2 - t22 * t70 * t120 / 0.9e1)
  t139 = f.my_piecewise3(t76, 0, t125 + t137)
  t140 = t78 ** 2
  t141 = 0.1e1 / t140
  t143 = t78 * t77
  t144 = 0.1e1 / t143
  t147 = 0.313901240307210000e2 * t141 + 0.149643497914092000e2 * t144 + 0.1783335908700e1 * t79
  t148 = t147 ** 2
  t150 = 0.1e1 / t148 / t147
  t151 = t139 * t150
  t153 = 0.1e1 / t140 / t77
  t154 = t153 * t139
  t156 = t141 * t139
  t160 = -0.1255604961228840000e3 * t154 - 0.448930493742276000e2 * t156 - 0.3566671817400e1 * t144 * t139
  t161 = t160 ** 2
  t162 = t151 * t161
  t167 = 0.360115380e1 / t77 + 0.5764e0
  t168 = 0.1e1 / t148
  t169 = t167 * t168
  t171 = 0.1e1 / t140 / t143
  t172 = t139 ** 2
  t173 = t172 * t139
  t177 = 0.1e1 / t140 / t78
  t178 = t177 * t139
  t179 = t28 ** 2
  t182 = 0.1e1 / t30 / t179 / t35
  t189 = t20 * t21 * t23
  t190 = t82 * t89
  t191 = t28 * t119
  t196 = 0.1e1 / t88 / t55
  t197 = t119 ** 2
  t198 = t196 * t197
  t202 = t35 ** 2
  t204 = 0.1e1 / t37 / t202
  t209 = t33 * t92
  t214 = 0.1e1 / t100 / t49
  t215 = t114 ** 2
  t216 = t214 * t215
  t228 = s0 ** 2
  t229 = t228 * t23
  t234 = 0.1e1 / t109 / t108
  t238 = 0.78400000000000000000000000000000000000000000000000e-1 * t41 / t36 / t90 * t45 + 0.16800000000000000000000000000000000000000000000000e0 * t34 * t204 * t110 - 0.89600000000000000000000000000000000000000000000000e-1 * t229 / t36 / t202 / t90 * t234
  t239 = t101 * t238
  t243 = 0.91259259259259259259259259259259259259259259259260e-2 * t22 * t34 * t204 * t50 + 0.49777777777777777777777777777777777777777777777778e-2 * t98 * t209 * t115 + 0.18666666666666666666666666666666666666666666666666e-2 * t98 * t99 * t216 - 0.93333333333333333333333333333333333333333333333332e-3 * t98 * t99 * t239
  t244 = t89 * t243
  t249 = f.my_piecewise3(t14, 0, 0.4e1 / 0.81e2 * t22 * t23 * t182 * t56 * t179 + 0.2e1 / 0.27e2 * t189 * t190 * t191 + 0.2e1 / 0.9e1 * t22 * t32 * t198 - t22 * t32 * t244 / 0.9e1)
  t250 = t66 ** 2
  t253 = 0.1e1 / t68 / t250 / t35
  t259 = t127 * t89
  t260 = t66 * t119
  t271 = f.my_piecewise3(t64, 0, 0.4e1 / 0.81e2 * t22 * t23 * t253 * t56 * t250 + 0.2e1 / 0.27e2 * t189 * t259 * t260 + 0.2e1 / 0.9e1 * t22 * t70 * t198 - t22 * t70 * t244 / 0.9e1)
  t273 = f.my_piecewise3(t76, 0, t249 + t271)
  t276 = t179 * t28
  t279 = 0.1e1 / t30 / t276 / t90
  t285 = t182 * t89
  t290 = t82 * t196
  t299 = t88 ** 2
  t300 = 0.1e1 / t299
  t301 = t197 * t119
  t302 = t300 * t301
  t306 = t31 * t196
  t307 = t119 * t243
  t311 = t202 * r0
  t313 = 0.1e1 / t37 / t311
  t318 = t33 * t204
  t328 = t100 ** 2
  t329 = 0.1e1 / t328
  t331 = t329 * t215 * t114
  t335 = t214 * t114
  t336 = t335 * t238
  t348 = t202 ** 2
  t354 = t228 * s0
  t358 = t108 ** 2
  t360 = 0.1e1 / t109 / t358
  t363 = -0.26133333333333333333333333333333333333333333333333e0 * t41 / t36 / t202 * t45 - 0.88853333333333333333333333333333333333333333333333e0 * t34 * t313 * t110 + 0.11050666666666666666666666666666666666666666666667e1 * t229 / t36 / t348 * t234 - 0.71680000000000000000000000000000000000000000000000e0 * t354 / t348 / t90 * t360
  t364 = t101 * t363
  t368 = -0.42587654320987654320987654320987654320987654320988e-1 * t22 * t34 * t313 * t50 - 0.27377777777777777777777777777777777777777777777778e-1 * t98 * t318 * t115 - 0.14933333333333333333333333333333333333333333333333e-1 * t98 * t209 * t216 + 0.74666666666666666666666666666666666666666666666667e-2 * t98 * t209 * t239 - 0.55999999999999999999999999999999999999999999999998e-2 * t98 * t99 * t331 + 0.55999999999999999999999999999999999999999999999998e-2 * t98 * t99 * t336 - 0.93333333333333333333333333333333333333333333333332e-3 * t98 * t99 * t364
  t369 = t89 * t368
  t374 = f.my_piecewise3(t14, 0, -0.28e2 / 0.243e3 * t22 * t23 * t279 * t56 * t276 - 0.4e1 / 0.27e2 * t189 * t285 * t179 * t119 - 0.2e1 / 0.9e1 * t189 * t290 * t28 * t197 + t189 * t190 * t28 * t243 / 0.9e1 - 0.2e1 / 0.3e1 * t22 * t32 * t302 + 0.2e1 / 0.3e1 * t189 * t306 * t307 - t22 * t32 * t369 / 0.9e1)
  t375 = t250 * t66
  t378 = 0.1e1 / t68 / t375 / t90
  t384 = t253 * t89
  t389 = t127 * t196
  t401 = t69 * t196
  t409 = f.my_piecewise3(t64, 0, -0.28e2 / 0.243e3 * t22 * t23 * t378 * t56 * t375 - 0.4e1 / 0.27e2 * t189 * t384 * t250 * t119 - 0.2e1 / 0.9e1 * t189 * t389 * t66 * t197 + t189 * t259 * t66 * t243 / 0.9e1 - 0.2e1 / 0.3e1 * t22 * t70 * t302 + 0.2e1 / 0.3e1 * t189 * t401 * t307 - t22 * t70 * t369 / 0.9e1)
  t411 = f.my_piecewise3(t76, 0, t374 + t409)
  t426 = -0.37668148836865200000e4 * t171 * t173 + 0.18834074418432600000e4 * t178 * t273 - 0.1255604961228840000e3 * t153 * t411 - 0.8978609874845520000e3 * t177 * t173 + 0.5387165924907312000e3 * t154 * t273 - 0.448930493742276000e2 * t141 * t411 - 0.42800061808800e2 * t153 * t173 + 0.32100046356600e2 * t156 * t273 - 0.3566671817400e1 * t144 * t411
  t431 = 0.1e1 / t147
  t435 = t9 * t167
  t439 = t9 * t79
  t440 = t139 * t168
  t444 = t9 * t144
  t445 = t172 * t431
  t448 = t273 * t168
  t449 = t448 * t160
  t452 = t177 * t172
  t456 = t153 * t172
  t464 = 0.6278024806144200000e3 * t452 - 0.1255604961228840000e3 * t153 * t273 + 0.1795721974969104000e3 * t456 - 0.448930493742276000e2 * t141 * t273 + 0.10700015452200e2 * t141 * t172 - 0.3566671817400e1 * t144 * t273
  t465 = t440 * t464
  t474 = t148 ** 2
  t475 = 0.1e1 / t474
  t477 = t161 * t160
  t481 = t10 * t167
  t483 = t150 * t160 * t464
  t490 = t10 * t144
  t492 = t139 * t431 * t273
  t495 = t172 * t168
  t496 = t495 * t160
  t499 = 0.54017307000000000000000000000000000000000000000000e1 * t80 * t162 + 0.25000000000000000000000000000000000000000000000000e0 * t10 * t169 * t426 + 0.90028845000000000000000000000000000000000000000000e0 * t10 * t79 * t411 * t431 - 0.15000000000000000000000000000000000000000000000000e1 * t435 * t150 * t161 - 0.54017307000000000000000000000000000000000000000000e1 * t439 * t440 * t160 - 0.54017307000000000000000000000000000000000000000000e1 * t444 * t445 - 0.27008653500000000000000000000000000000000000000000e1 * t80 * t449 - 0.27008653500000000000000000000000000000000000000000e1 * t80 * t465 + 0.27008653500000000000000000000000000000000000000000e1 * t439 * t273 * t431 + 0.75000000000000000000000000000000000000000000000000e0 * t435 * t168 * t464 + 0.15000000000000000000000000000000000000000000000000e1 * t10 * t167 * t475 * t477 - 0.15000000000000000000000000000000000000000000000000e1 * t481 * t483 + 0.54017307000000000000000000000000000000000000000000e1 * t10 * t141 * t173 * t431 - 0.54017307000000000000000000000000000000000000000000e1 * t490 * t492 + 0.54017307000000000000000000000000000000000000000000e1 * t490 * t496
  t500 = f.my_piecewise3(t4, 0, t499)
  t509 = t411 * t431
  t519 = t179 ** 2
  t557 = t197 ** 2
  t558 = 0.1e1 / t299 / t55 * t557
  t563 = t197 * t243
  t567 = t243 ** 2
  t568 = t196 * t567
  t572 = t119 * t368
  t576 = t202 * t35
  t578 = 0.1e1 / t37 / t576
  t604 = t215 ** 2
  t614 = t238 ** 2
  t642 = t228 ** 2
  t658 = 0.24133004115226337448559670781893004115226337448560e0 * t22 * t34 * t578 * t50 + 0.17035061728395061728395061728395061728395061728395e0 * t98 * t33 * t313 * t115 + 0.10951111111111111111111111111111111111111111111111e0 * t98 * t318 * t216 - 0.54755555555555555555555555555555555555555555555556e-1 * t98 * t318 * t239 + 0.59733333333333333333333333333333333333333333333332e-1 * t98 * t209 * t331 - 0.59733333333333333333333333333333333333333333333332e-1 * t98 * t209 * t336 + 0.99555555555555555555555555555555555555555555555556e-2 * t98 * t209 * t364 + 0.22399999999999999999999999999999999999999999999999e-1 * t98 * t99 / t328 / t49 * t604 - 0.33599999999999999999999999999999999999999999999998e-1 * t98 * t99 * t329 * t215 * t238 + 0.55999999999999999999999999999999999999999999999998e-2 * t98 * t99 * t214 * t614 + 0.74666666666666666666666666666666666666666666666664e-2 * t98 * t99 * t335 * t363 - 0.93333333333333333333333333333333333333333333333332e-3 * t98 * t99 * t101 * (0.11324444444444444444444444444444444444444444444444e1 * t41 / t36 / t311 * t45 + 0.53834666666666666666666666666666666666666666666666e1 * t34 * t578 * t110 - 0.11578311111111111111111111111111111111111111111111e2 * t229 / t36 / t348 / r0 * t234 + 0.16725333333333333333333333333333333333333333333334e2 * t354 / t348 / t202 * t360 - 0.47786666666666666666666666666666666666666666666667e1 * t642 / t37 / t348 / t576 / t109 / t358 / t108 * t33)
  t659 = t89 * t658
  t663 = 0.280e3 / 0.729e3 * t22 * t23 / t30 / t202 * t56 + 0.112e3 / 0.243e3 * t189 * t279 * t89 * t276 * t119 + 0.16e2 / 0.27e2 * t189 * t182 * t196 * t179 * t197 - 0.8e1 / 0.27e2 * t189 * t285 * t179 * t243 + 0.8e1 / 0.9e1 * t189 * t82 * t300 * t28 * t301 - 0.8e1 / 0.9e1 * t189 * t290 * t191 * t243 + 0.4e1 / 0.27e2 * t189 * t190 * t28 * t368 + 0.8e1 / 0.3e1 * t22 * t32 * t558 - 0.4e1 * t189 * t31 * t300 * t563 + 0.2e1 / 0.3e1 * t22 * t32 * t568 + 0.8e1 / 0.9e1 * t189 * t306 * t572 - t22 * t32 * t659 / 0.9e1
  t664 = f.my_piecewise3(t14, 0, t663)
  t665 = t250 ** 2
  t717 = 0.280e3 / 0.729e3 * t22 * t23 / t68 / t202 * t56 + 0.112e3 / 0.243e3 * t189 * t378 * t89 * t375 * t119 + 0.16e2 / 0.27e2 * t189 * t253 * t196 * t250 * t197 - 0.8e1 / 0.27e2 * t189 * t384 * t250 * t243 + 0.8e1 / 0.9e1 * t189 * t127 * t300 * t66 * t301 - 0.8e1 / 0.9e1 * t189 * t389 * t260 * t243 + 0.4e1 / 0.27e2 * t189 * t259 * t66 * t368 + 0.8e1 / 0.3e1 * t22 * t70 * t558 - 0.4e1 * t189 * t69 * t300 * t563 + 0.2e1 / 0.3e1 * t22 * t70 * t568 + 0.8e1 / 0.9e1 * t189 * t401 * t572 - t22 * t70 * t659 / 0.9e1
  t718 = f.my_piecewise3(t64, 0, t717)
  t720 = f.my_piecewise3(t76, 0, t664 + t718)
  t727 = t140 ** 2
  t729 = t172 ** 2
  t735 = t273 ** 2
  t762 = 0.263677041858056400000e5 / t727 * t729 - 0.226008893021191200000e5 * t171 * t172 * t273 + 0.18834074418432600000e4 * t177 * t735 + 0.25112099224576800000e4 * t178 * t411 - 0.1255604961228840000e3 * t153 * t720 + 0.53871659249073120000e4 * t171 * t729 - 0.53871659249073120000e4 * t452 * t273 + 0.5387165924907312000e3 * t153 * t735 + 0.7182887899876416000e3 * t154 * t411 - 0.448930493742276000e2 * t141 * t720 + 0.214000309044000e3 * t177 * t729 - 0.256800370852800e3 * t456 * t273 + 0.32100046356600e2 * t141 * t735 + 0.42800061808800e2 * t156 * t411 - 0.3566671817400e1 * t144 * t720
  t783 = t10 * t141
  t791 = 0.21606922800000000000000000000000000000000000000000e2 * t9 * t141 * t173 * t431 + 0.60000000000000000000000000000000000000000000000000e1 * t435 * t475 * t477 + 0.36011538000000000000000000000000000000000000000000e1 * t439 * t509 + 0.21606922800000000000000000000000000000000000000000e2 * t80 * t151 * t160 * t464 + 0.10000000000000000000000000000000000000000000000000e1 * t435 * t168 * t426 + 0.90028845000000000000000000000000000000000000000000e0 * t10 * t79 * t720 * t431 - 0.10803461400000000000000000000000000000000000000000e2 * t439 * t449 + 0.25000000000000000000000000000000000000000000000000e0 * t10 * t169 * t762 - 0.60000000000000000000000000000000000000000000000000e1 * t435 * t483 - 0.36011538000000000000000000000000000000000000000000e1 * t80 * t440 * t426 - 0.36011538000000000000000000000000000000000000000000e1 * t80 * t411 * t168 * t160 + 0.10803461400000000000000000000000000000000000000000e2 * t80 * t273 * t150 * t161 - 0.21606922800000000000000000000000000000000000000000e2 * t80 * t139 * t475 * t477 - 0.21606922800000000000000000000000000000000000000000e2 * t783 * t173 * t168 * t160 + 0.32410384200000000000000000000000000000000000000000e2 * t783 * t445 * t273
  t820 = t464 ** 2
  t827 = t161 ** 2
  t845 = -0.54017307000000000000000000000000000000000000000000e1 * t80 * t448 * t464 + 0.90000000000000000000000000000000000000000000000000e1 * t481 * t475 * t161 * t464 - 0.72023076000000000000000000000000000000000000000000e1 * t490 * t509 * t139 - 0.20000000000000000000000000000000000000000000000000e1 * t481 * t150 * t426 * t160 - 0.21606922800000000000000000000000000000000000000000e2 * t490 * t172 * t150 * t161 + 0.10803461400000000000000000000000000000000000000000e2 * t490 * t495 * t464 + 0.21606922800000000000000000000000000000000000000000e2 * t439 * t162 - 0.10803461400000000000000000000000000000000000000000e2 * t439 * t465 - 0.21606922800000000000000000000000000000000000000000e2 * t444 * t492 - 0.15000000000000000000000000000000000000000000000000e1 * t10 * t167 * t150 * t820 - 0.60000000000000000000000000000000000000000000000000e1 * t10 * t167 / t474 / t147 * t827 - 0.21606922800000000000000000000000000000000000000000e2 * t10 * t153 * t729 * t431 - 0.54017307000000000000000000000000000000000000000000e1 * t10 * t144 * t735 * t431 + 0.21606922800000000000000000000000000000000000000000e2 * t444 * t496 + 0.21606922800000000000000000000000000000000000000000e2 * t490 * t448 * t160 * t139
  t847 = f.my_piecewise3(t4, 0, t791 + t845)
  v4rho4_0_ = r0 * t847 + 0.4e1 * t500

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = abs(t4)
  t11 = 0.1e1 - t5 <= f.p.zeta_threshold or r0 <= f.p.dens_threshold and r1 <= f.p.dens_threshold
  t13 = 0.1e1 + t4 <= f.p.zeta_threshold
  t14 = f.p.zeta_threshold - 0.1e1
  t16 = 0.1e1 - t4 <= f.p.zeta_threshold
  t17 = -t14
  t18 = f.my_piecewise5(t13, t14, t16, t17, t4)
  t19 = t2 ** 2
  t20 = 0.1e1 / t19
  t21 = t1 * t20
  t22 = t3 - t21
  t23 = f.my_piecewise5(t13, 0, t16, 0, t22)
  t24 = t18 * t23
  t27 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t30 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t31 = f.my_piecewise5(t27, t14, t30, t17, t4)
  t32 = 0.1e1 + t31
  t35 = t32 * t2 / 0.2e1 <= f.p.dens_threshold
  t36 = 3 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t39 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t41 = t37 / t39
  t42 = 4 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 2 ** (0.1e1 / 0.3e1)
  t45 = t32 <= f.p.zeta_threshold
  t46 = 0.1e1 - t31
  t47 = t46 <= f.p.zeta_threshold
  t48 = f.my_piecewise5(t45, t14, t47, t17, t31)
  t49 = 0.1e1 + t48
  t50 = t49 * t2
  t51 = t50 ** (0.1e1 / 0.3e1)
  t53 = t44 / t51
  t54 = r0 ** 2
  t55 = r0 ** (0.1e1 / 0.3e1)
  t56 = t55 ** 2
  t59 = s0 / t56 / t54
  t60 = jnp.sqrt(s0)
  t63 = t60 / t55 / r0
  t64 = jnp.arcsinh(t63)
  t67 = 0.1e1 + 0.2520e-1 * t63 * t64
  t68 = 0.1e1 / t67
  t72 = 0.1e1 + 0.93333333333333333333333333333333333333333333333332e-3 * t43 * t59 * t68
  t73 = 0.1e1 / t72
  t77 = f.my_piecewise3(t35, 0, t43 * t53 * t73 / 0.9e1)
  t81 = t46 * t2 / 0.2e1 <= f.p.dens_threshold
  t82 = f.my_piecewise5(t47, t14, t45, t17, -t31)
  t83 = 0.1e1 + t82
  t84 = t83 * t2
  t85 = t84 ** (0.1e1 / 0.3e1)
  t87 = t44 / t85
  t88 = r1 ** 2
  t89 = r1 ** (0.1e1 / 0.3e1)
  t90 = t89 ** 2
  t93 = s2 / t90 / t88
  t94 = jnp.sqrt(s2)
  t97 = t94 / t89 / r1
  t98 = jnp.arcsinh(t97)
  t101 = 0.1e1 + 0.2520e-1 * t97 * t98
  t102 = 0.1e1 / t101
  t106 = 0.1e1 + 0.93333333333333333333333333333333333333333333333332e-3 * t43 * t93 * t102
  t107 = 0.1e1 / t106
  t111 = f.my_piecewise3(t81, 0, t43 * t87 * t107 / 0.9e1)
  t112 = t77 + t111
  t113 = t112 == 0.0e0
  t114 = f.my_piecewise3(t113, DBL_EPSILON, t112)
  t117 = 0.360115380e1 / t114 + 0.5764e0
  t119 = t114 ** 2
  t120 = t119 ** 2
  t121 = 0.1e1 / t120
  t124 = 0.1e1 / t119 / t114
  t126 = 0.1e1 / t119
  t128 = 0.313901240307210000e2 * t121 + 0.149643497914092000e2 * t124 + 0.1783335908700e1 * t126
  t129 = 0.1e1 / t128
  t130 = t2 * t117 * t129
  t133 = t18 ** 2
  t134 = 0.1e1 - t133
  t135 = t134 * t117
  t137 = 0.25000000000000000000000000000000000000000000000000e0 * t135 * t129
  t138 = t134 * t2
  t140 = 0.1e1 / t51 / t50
  t141 = t44 * t140
  t142 = f.my_piecewise5(t27, 0, t30, 0, t22)
  t143 = f.my_piecewise5(t45, 0, t47, 0, t142)
  t145 = t143 * t2 + t48 + 0.1e1
  t150 = t72 ** 2
  t151 = 0.1e1 / t150
  t152 = t54 * r0
  t155 = s0 / t56 / t152
  t159 = t67 ** 2
  t160 = 0.1e1 / t159
  t166 = 0.1e1 + t59
  t167 = jnp.sqrt(t166)
  t168 = 0.1e1 / t167
  t171 = -0.33600000000000000000000000000000000000000000000000e-1 * t60 / t55 / t54 * t64 - 0.33600000000000000000000000000000000000000000000000e-1 * t155 * t168
  t172 = t160 * t171
  t176 = -0.24888888888888888888888888888888888888888888888889e-2 * t43 * t155 * t68 - 0.93333333333333333333333333333333333333333333333332e-3 * t43 * t59 * t172
  t182 = f.my_piecewise3(t35, 0, -t43 * t141 * t73 * t145 / 0.27e2 - t43 * t53 * t151 * t176 / 0.9e1)
  t184 = 0.1e1 / t85 / t84
  t185 = t44 * t184
  t186 = f.my_piecewise5(t47, 0, t45, 0, -t142)
  t188 = t186 * t2 + t82 + 0.1e1
  t193 = f.my_piecewise3(t81, 0, -t43 * t185 * t107 * t188 / 0.27e2)
  t195 = f.my_piecewise3(t113, 0, t182 + t193)
  t197 = t126 * t195 * t129
  t200 = t128 ** 2
  t201 = 0.1e1 / t200
  t202 = t117 * t201
  t204 = 0.1e1 / t120 / t114
  t211 = -0.1255604961228840000e3 * t204 * t195 - 0.448930493742276000e2 * t121 * t195 - 0.3566671817400e1 * t124 * t195
  t212 = t202 * t211
  t216 = f.my_piecewise3(t11, 0, 0.50000000000000000000000000000000000000000000000000e0 * t24 * t130 - t137 + 0.90028845000000000000000000000000000000000000000000e0 * t138 * t197 + 0.25000000000000000000000000000000000000000000000000e0 * t138 * t212)
  t218 = t23 ** 2
  t220 = t117 * t129
  t225 = t1 / t19 / t2
  t227 = -0.2e1 * t20 + 0.2e1 * t225
  t228 = f.my_piecewise5(t13, 0, t16, 0, t227)
  t232 = t24 * t220
  t234 = t24 * t2
  t239 = t134 * t126
  t241 = t239 * t195 * t129
  t244 = t135 * t201 * t211
  t246 = t195 ** 2
  t251 = t49 ** 2
  t254 = 0.1e1 / t51 / t251 / t19
  t255 = t44 * t254
  t256 = t145 ** 2
  t262 = t41 * t42 * t44
  t263 = t140 * t151
  t268 = f.my_piecewise5(t27, 0, t30, 0, t227)
  t269 = f.my_piecewise5(t45, 0, t47, 0, t268)
  t279 = t176 ** 2
  t284 = t54 ** 2
  t287 = s0 / t56 / t284
  t296 = t171 ** 2
  t308 = s0 ** 2
  t328 = f.my_piecewise3(t35, 0, 0.4e1 / 0.81e2 * t43 * t255 * t73 * t256 + 0.2e1 / 0.27e2 * t262 * t263 * t145 * t176 - t43 * t141 * t73 * (t269 * t2 + 0.2e1 * t143) / 0.27e2 + 0.2e1 / 0.9e1 * t43 * t53 / t150 / t72 * t279 - t43 * t53 * t151 * (0.91259259259259259259259259259259259259259259259260e-2 * t43 * t287 * t68 + 0.49777777777777777777777777777777777777777777777778e-2 * t43 * t155 * t172 + 0.18666666666666666666666666666666666666666666666666e-2 * t43 * t59 / t159 / t67 * t296 - 0.93333333333333333333333333333333333333333333333332e-3 * t43 * t59 * t160 * (0.78400000000000000000000000000000000000000000000000e-1 * t60 / t55 / t152 * t64 + 0.16800000000000000000000000000000000000000000000000e0 * t287 * t168 - 0.44800000000000000000000000000000000000000000000000e-1 * t308 / t55 / t284 / t152 / t167 / t166)) / 0.9e1)
  t329 = t83 ** 2
  t332 = 0.1e1 / t85 / t329 / t19
  t333 = t44 * t332
  t334 = t188 ** 2
  t339 = f.my_piecewise5(t47, 0, t45, 0, -t268)
  t348 = f.my_piecewise3(t81, 0, 0.4e1 / 0.81e2 * t43 * t333 * t107 * t334 - t43 * t185 * t107 * (t339 * t2 + 0.2e1 * t186) / 0.27e2)
  t350 = f.my_piecewise3(t113, 0, t328 + t348)
  t355 = t138 * t126
  t356 = t195 * t201
  t361 = 0.1e1 / t200 / t128
  t362 = t117 * t361
  t363 = t211 ** 2
  t368 = 0.1e1 / t120 / t119
  t385 = 0.50000000000000000000000000000000000000000000000000e0 * t218 * t2 * t220 + 0.50000000000000000000000000000000000000000000000000e0 * t18 * t228 * t130 + 0.10000000000000000000000000000000000000000000000000e1 * t232 - 0.36011538000000000000000000000000000000000000000000e1 * t234 * t197 - 0.10000000000000000000000000000000000000000000000000e1 * t234 * t212 + 0.18005769000000000000000000000000000000000000000000e1 * t241 + 0.50000000000000000000000000000000000000000000000000e0 * t244 - 0.18005769000000000000000000000000000000000000000000e1 * t138 * t124 * t246 * t129 + 0.90028845000000000000000000000000000000000000000000e0 * t138 * t126 * t350 * t129 - 0.18005769000000000000000000000000000000000000000000e1 * t355 * t356 * t211 - 0.50000000000000000000000000000000000000000000000000e0 * t138 * t362 * t363 + 0.25000000000000000000000000000000000000000000000000e0 * t138 * t202 * (0.6278024806144200000e3 * t368 * t246 - 0.1255604961228840000e3 * t204 * t350 + 0.1795721974969104000e3 * t204 * t246 - 0.448930493742276000e2 * t121 * t350 + 0.10700015452200e2 * t121 * t246 - 0.3566671817400e1 * t124 * t350)
  t386 = f.my_piecewise3(t11, 0, t385)
  d11 = t2 * t386 + 0.2e1 * t216
  t388 = -t3 - t21
  t389 = f.my_piecewise5(t13, 0, t16, 0, t388)
  t390 = t18 * t389
  t393 = f.my_piecewise5(t27, 0, t30, 0, t388)
  t394 = f.my_piecewise5(t45, 0, t47, 0, t393)
  t396 = t394 * t2 + t48 + 0.1e1
  t401 = f.my_piecewise3(t35, 0, -t43 * t141 * t73 * t396 / 0.27e2)
  t402 = f.my_piecewise5(t47, 0, t45, 0, -t393)
  t404 = t402 * t2 + t82 + 0.1e1
  t409 = t106 ** 2
  t410 = 0.1e1 / t409
  t411 = t88 * r1
  t414 = s2 / t90 / t411
  t418 = t101 ** 2
  t419 = 0.1e1 / t418
  t425 = 0.1e1 + t93
  t426 = jnp.sqrt(t425)
  t427 = 0.1e1 / t426
  t430 = -0.33600000000000000000000000000000000000000000000000e-1 * t94 / t89 / t88 * t98 - 0.33600000000000000000000000000000000000000000000000e-1 * t414 * t427
  t431 = t419 * t430
  t435 = -0.24888888888888888888888888888888888888888888888889e-2 * t43 * t414 * t102 - 0.93333333333333333333333333333333333333333333333332e-3 * t43 * t93 * t431
  t441 = f.my_piecewise3(t81, 0, -t43 * t185 * t107 * t404 / 0.27e2 - t43 * t87 * t410 * t435 / 0.9e1)
  t443 = f.my_piecewise3(t113, 0, t401 + t441)
  t445 = t126 * t443 * t129
  t448 = t204 * t443
  t450 = t121 * t443
  t454 = -0.1255604961228840000e3 * t448 - 0.448930493742276000e2 * t450 - 0.3566671817400e1 * t124 * t443
  t455 = t202 * t454
  t459 = f.my_piecewise3(t11, 0, 0.50000000000000000000000000000000000000000000000000e0 * t390 * t130 - t137 + 0.90028845000000000000000000000000000000000000000000e0 * t138 * t445 + 0.25000000000000000000000000000000000000000000000000e0 * t138 * t455)
  t463 = 0.2e1 * t225
  t464 = f.my_piecewise5(t13, 0, t16, 0, t463)
  t468 = t390 * t220
  t470 = t390 * t2
  t480 = t443 * t129
  t481 = t239 * t480
  t496 = f.my_piecewise5(t27, 0, t30, 0, t463)
  t497 = f.my_piecewise5(t45, 0, t47, 0, t496)
  t505 = f.my_piecewise3(t35, 0, 0.4e1 / 0.81e2 * t262 * t254 * t73 * t396 * t145 + t262 * t263 * t396 * t176 / 0.27e2 - t43 * t141 * t73 * (t497 * t2 + t143 + t394) / 0.27e2)
  t511 = f.my_piecewise5(t47, 0, t45, 0, -t496)
  t518 = t184 * t410
  t524 = f.my_piecewise3(t81, 0, 0.4e1 / 0.81e2 * t262 * t332 * t107 * t404 * t188 - t43 * t185 * t107 * (t511 * t2 + t186 + t402) / 0.27e2 + t262 * t518 * t435 * t188 / 0.27e2)
  t526 = f.my_piecewise3(t113, 0, t505 + t524)
  t531 = t443 * t201
  t538 = t135 * t201 * t454
  t565 = 0.50000000000000000000000000000000000000000000000000e0 * t23 * t389 * t130 + 0.50000000000000000000000000000000000000000000000000e0 * t18 * t464 * t130 + 0.50000000000000000000000000000000000000000000000000e0 * t468 - 0.18005769000000000000000000000000000000000000000000e1 * t470 * t197 - 0.50000000000000000000000000000000000000000000000000e0 * t470 * t212 + 0.50000000000000000000000000000000000000000000000000e0 * t232 + 0.90028845000000000000000000000000000000000000000000e0 * t241 + 0.25000000000000000000000000000000000000000000000000e0 * t244 - 0.18005769000000000000000000000000000000000000000000e1 * t234 * t445 + 0.90028845000000000000000000000000000000000000000000e0 * t481 - 0.18005769000000000000000000000000000000000000000000e1 * t138 * t124 * t480 * t195 + 0.90028845000000000000000000000000000000000000000000e0 * t138 * t126 * t526 * t129 - 0.90028845000000000000000000000000000000000000000000e0 * t355 * t531 * t211 - 0.50000000000000000000000000000000000000000000000000e0 * t234 * t455 + 0.25000000000000000000000000000000000000000000000000e0 * t538 - 0.90028845000000000000000000000000000000000000000000e0 * t355 * t356 * t454 - 0.50000000000000000000000000000000000000000000000000e0 * t138 * t117 * t361 * t454 * t211 + 0.25000000000000000000000000000000000000000000000000e0 * t138 * t202 * (0.6278024806144200000e3 * t368 * t443 * t195 - 0.1255604961228840000e3 * t204 * t526 + 0.1795721974969104000e3 * t448 * t195 - 0.448930493742276000e2 * t121 * t526 + 0.10700015452200e2 * t450 * t195 - 0.3566671817400e1 * t124 * t526)
  t566 = f.my_piecewise3(t11, 0, t565)
  d12 = t2 * t566 + t216 + t459
  t569 = t389 ** 2
  t574 = 0.2e1 * t20 + 0.2e1 * t225
  t575 = f.my_piecewise5(t13, 0, t16, 0, t574)
  t586 = t443 ** 2
  t591 = t396 ** 2
  t596 = f.my_piecewise5(t27, 0, t30, 0, t574)
  t597 = f.my_piecewise5(t45, 0, t47, 0, t596)
  t606 = f.my_piecewise3(t35, 0, 0.4e1 / 0.81e2 * t43 * t255 * t73 * t591 - t43 * t141 * t73 * (t597 * t2 + 0.2e1 * t394) / 0.27e2)
  t607 = t404 ** 2
  t616 = f.my_piecewise5(t47, 0, t45, 0, -t596)
  t626 = t435 ** 2
  t631 = t88 ** 2
  t634 = s2 / t90 / t631
  t643 = t430 ** 2
  t655 = s2 ** 2
  t675 = f.my_piecewise3(t81, 0, 0.4e1 / 0.81e2 * t43 * t333 * t107 * t607 + 0.2e1 / 0.27e2 * t262 * t518 * t404 * t435 - t43 * t185 * t107 * (t616 * t2 + 0.2e1 * t402) / 0.27e2 + 0.2e1 / 0.9e1 * t43 * t87 / t409 / t106 * t626 - t43 * t87 * t410 * (0.91259259259259259259259259259259259259259259259260e-2 * t43 * t634 * t102 + 0.49777777777777777777777777777777777777777777777778e-2 * t43 * t414 * t431 + 0.18666666666666666666666666666666666666666666666666e-2 * t43 * t93 / t418 / t101 * t643 - 0.93333333333333333333333333333333333333333333333332e-3 * t43 * t93 * t419 * (0.78400000000000000000000000000000000000000000000000e-1 * t94 / t89 / t411 * t98 + 0.16800000000000000000000000000000000000000000000000e0 * t634 * t427 - 0.44800000000000000000000000000000000000000000000000e-1 * t655 / t89 / t631 / t411 / t426 / t425)) / 0.9e1)
  t677 = f.my_piecewise3(t113, 0, t606 + t675)
  t685 = t454 ** 2
  t705 = 0.50000000000000000000000000000000000000000000000000e0 * t569 * t2 * t220 + 0.50000000000000000000000000000000000000000000000000e0 * t18 * t575 * t130 + 0.10000000000000000000000000000000000000000000000000e1 * t468 - 0.36011538000000000000000000000000000000000000000000e1 * t470 * t445 - 0.10000000000000000000000000000000000000000000000000e1 * t470 * t455 + 0.18005769000000000000000000000000000000000000000000e1 * t481 + 0.50000000000000000000000000000000000000000000000000e0 * t538 - 0.18005769000000000000000000000000000000000000000000e1 * t138 * t124 * t586 * t129 + 0.90028845000000000000000000000000000000000000000000e0 * t138 * t126 * t677 * t129 - 0.18005769000000000000000000000000000000000000000000e1 * t355 * t531 * t454 - 0.50000000000000000000000000000000000000000000000000e0 * t138 * t362 * t685 + 0.25000000000000000000000000000000000000000000000000e0 * t138 * t202 * (0.6278024806144200000e3 * t368 * t586 - 0.1255604961228840000e3 * t204 * t677 + 0.1795721974969104000e3 * t204 * t586 - 0.448930493742276000e2 * t121 * t677 + 0.10700015452200e2 * t121 * t586 - 0.3566671817400e1 * t124 * t677)
  t706 = f.my_piecewise3(t11, 0, t705)
  d22 = t2 * t706 + 0.2e1 * t459
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = abs(t4)
  t11 = 0.1e1 - t5 <= f.p.zeta_threshold or r0 <= f.p.dens_threshold and r1 <= f.p.dens_threshold
  t13 = 0.1e1 + t4 <= f.p.zeta_threshold
  t15 = 0.1e1 - t4 <= f.p.zeta_threshold
  t16 = t2 ** 2
  t17 = 0.1e1 / t16
  t19 = -t1 * t17 + t3
  t20 = f.my_piecewise5(t13, 0, t15, 0, t19)
  t21 = t20 ** 2
  t22 = t21 * t2
  t25 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t26 = f.p.zeta_threshold - 0.1e1
  t29 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t30 = -t26
  t31 = f.my_piecewise5(t25, t26, t29, t30, t4)
  t32 = 0.1e1 + t31
  t35 = t32 * t2 / 0.2e1 <= f.p.dens_threshold
  t36 = 3 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t39 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t41 = t37 / t39
  t42 = 4 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 2 ** (0.1e1 / 0.3e1)
  t45 = t32 <= f.p.zeta_threshold
  t46 = 0.1e1 - t31
  t47 = t46 <= f.p.zeta_threshold
  t48 = f.my_piecewise5(t45, t26, t47, t30, t31)
  t49 = 0.1e1 + t48
  t50 = t49 * t2
  t51 = t50 ** (0.1e1 / 0.3e1)
  t52 = 0.1e1 / t51
  t53 = t44 * t52
  t54 = r0 ** 2
  t55 = r0 ** (0.1e1 / 0.3e1)
  t56 = t55 ** 2
  t58 = 0.1e1 / t56 / t54
  t59 = s0 * t58
  t60 = jnp.sqrt(s0)
  t63 = t60 / t55 / r0
  t64 = jnp.asinh(t63)
  t67 = 0.1e1 + 0.2520e-1 * t63 * t64
  t68 = 0.1e1 / t67
  t72 = 0.1e1 + 0.93333333333333333333333333333333333333333333333332e-3 * t43 * t59 * t68
  t73 = 0.1e1 / t72
  t77 = f.my_piecewise3(t35, 0, t43 * t53 * t73 / 0.9e1)
  t81 = t46 * t2 / 0.2e1 <= f.p.dens_threshold
  t82 = f.my_piecewise5(t47, t26, t45, t30, -t31)
  t83 = 0.1e1 + t82
  t84 = t83 * t2
  t85 = t84 ** (0.1e1 / 0.3e1)
  t88 = r1 ** 2
  t89 = r1 ** (0.1e1 / 0.3e1)
  t90 = t89 ** 2
  t94 = jnp.sqrt(s2)
  t97 = t94 / t89 / r1
  t98 = jnp.asinh(t97)
  t107 = 0.1e1 / (0.1e1 + 0.93333333333333333333333333333333333333333333333332e-3 * t43 * s2 / t90 / t88 / (0.1e1 + 0.2520e-1 * t97 * t98))
  t111 = f.my_piecewise3(t81, 0, t43 * t44 / t85 * t107 / 0.9e1)
  t112 = t77 + t111
  t113 = t112 == 0.0e0
  t114 = f.my_piecewise3(t113, DBL_EPSILON, t112)
  t117 = 0.360115380e1 / t114 + 0.5764e0
  t118 = t114 ** 2
  t119 = t118 ** 2
  t120 = 0.1e1 / t119
  t122 = t118 * t114
  t123 = 0.1e1 / t122
  t125 = 0.1e1 / t118
  t127 = 0.313901240307210000e2 * t120 + 0.149643497914092000e2 * t123 + 0.1783335908700e1 * t125
  t128 = 0.1e1 / t127
  t129 = t117 * t128
  t132 = f.my_piecewise5(t13, t26, t15, t30, t4)
  t133 = t16 * t2
  t134 = 0.1e1 / t133
  t137 = 0.2e1 * t1 * t134 - 0.2e1 * t17
  t138 = f.my_piecewise5(t13, 0, t15, 0, t137)
  t139 = t132 * t138
  t141 = t2 * t117 * t128
  t144 = t132 * t20
  t147 = t144 * t2
  t149 = 0.1e1 / t51 / t50
  t150 = t44 * t149
  t151 = f.my_piecewise5(t25, 0, t29, 0, t19)
  t152 = f.my_piecewise5(t45, 0, t47, 0, t151)
  t154 = t152 * t2 + t48 + 0.1e1
  t159 = t72 ** 2
  t160 = 0.1e1 / t159
  t161 = t54 * r0
  t164 = s0 / t56 / t161
  t168 = t67 ** 2
  t169 = 0.1e1 / t168
  t175 = 0.1e1 + t59
  t176 = jnp.sqrt(t175)
  t177 = 0.1e1 / t176
  t180 = -0.33600000000000000000000000000000000000000000000000e-1 * t60 / t55 / t54 * t64 - 0.33600000000000000000000000000000000000000000000000e-1 * t164 * t177
  t181 = t169 * t180
  t185 = -0.24888888888888888888888888888888888888888888888889e-2 * t43 * t164 * t68 - 0.93333333333333333333333333333333333333333333333332e-3 * t43 * t59 * t181
  t191 = f.my_piecewise3(t35, 0, -t43 * t150 * t73 * t154 / 0.27e2 - t43 * t53 * t160 * t185 / 0.9e1)
  t194 = t44 / t85 / t84
  t195 = f.my_piecewise5(t47, 0, t45, 0, -t151)
  t197 = t195 * t2 + t82 + 0.1e1
  t202 = f.my_piecewise3(t81, 0, -t43 * t194 * t107 * t197 / 0.27e2)
  t204 = f.my_piecewise3(t113, 0, t191 + t202)
  t205 = t125 * t204
  t206 = t205 * t128
  t209 = t127 ** 2
  t210 = 0.1e1 / t209
  t211 = t117 * t210
  t213 = 0.1e1 / t119 / t114
  t214 = t213 * t204
  t216 = t120 * t204
  t220 = -0.1255604961228840000e3 * t214 - 0.448930493742276000e2 * t216 - 0.3566671817400e1 * t123 * t204
  t221 = t211 * t220
  t224 = t132 ** 2
  t225 = 0.1e1 - t224
  t226 = t225 * t125
  t227 = t204 * t128
  t230 = t225 * t117
  t231 = t210 * t220
  t234 = t225 * t2
  t235 = t204 ** 2
  t237 = t123 * t235 * t128
  t240 = t49 ** 2
  t243 = 0.1e1 / t51 / t240 / t16
  t245 = t154 ** 2
  t251 = t41 * t42 * t44
  t252 = t149 * t160
  t257 = f.my_piecewise5(t25, 0, t29, 0, t137)
  t258 = f.my_piecewise5(t45, 0, t47, 0, t257)
  t261 = t258 * t2 + 0.2e1 * t152
  t267 = 0.1e1 / t159 / t72
  t268 = t185 ** 2
  t273 = t54 ** 2
  t276 = s0 / t56 / t273
  t284 = 0.1e1 / t168 / t67
  t285 = t180 ** 2
  t286 = t284 * t285
  t297 = s0 ** 2
  t303 = 0.1e1 / t176 / t175
  t306 = 0.78400000000000000000000000000000000000000000000000e-1 * t60 / t55 / t161 * t64 + 0.16800000000000000000000000000000000000000000000000e0 * t276 * t177 - 0.44800000000000000000000000000000000000000000000000e-1 * t297 / t55 / t273 / t161 * t303
  t307 = t169 * t306
  t311 = 0.91259259259259259259259259259259259259259259259260e-2 * t43 * t276 * t68 + 0.49777777777777777777777777777777777777777777777778e-2 * t43 * t164 * t181 + 0.18666666666666666666666666666666666666666666666666e-2 * t43 * t59 * t286 - 0.93333333333333333333333333333333333333333333333332e-3 * t43 * t59 * t307
  t317 = f.my_piecewise3(t35, 0, 0.4e1 / 0.81e2 * t43 * t44 * t243 * t73 * t245 + 0.2e1 / 0.27e2 * t251 * t252 * t154 * t185 - t43 * t150 * t73 * t261 / 0.27e2 + 0.2e1 / 0.9e1 * t43 * t53 * t267 * t268 - t43 * t53 * t160 * t311 / 0.9e1)
  t318 = t83 ** 2
  t321 = 0.1e1 / t85 / t318 / t16
  t323 = t197 ** 2
  t328 = f.my_piecewise5(t47, 0, t45, 0, -t257)
  t331 = t328 * t2 + 0.2e1 * t195
  t337 = f.my_piecewise3(t81, 0, 0.4e1 / 0.81e2 * t43 * t44 * t321 * t107 * t323 - t43 * t194 * t107 * t331 / 0.27e2)
  t339 = f.my_piecewise3(t113, 0, t317 + t337)
  t341 = t125 * t339 * t128
  t344 = t234 * t125
  t345 = t204 * t210
  t346 = t345 * t220
  t350 = 0.1e1 / t209 / t127
  t352 = t220 ** 2
  t353 = t117 * t350 * t352
  t357 = 0.1e1 / t119 / t118
  t370 = 0.6278024806144200000e3 * t357 * t235 - 0.1255604961228840000e3 * t213 * t339 + 0.1795721974969104000e3 * t213 * t235 - 0.448930493742276000e2 * t120 * t339 + 0.10700015452200e2 * t120 * t235 - 0.3566671817400e1 * t123 * t339
  t371 = t211 * t370
  t374 = 0.50000000000000000000000000000000000000000000000000e0 * t22 * t129 + 0.50000000000000000000000000000000000000000000000000e0 * t139 * t141 + 0.10000000000000000000000000000000000000000000000000e1 * t144 * t129 - 0.36011538000000000000000000000000000000000000000000e1 * t147 * t206 - 0.10000000000000000000000000000000000000000000000000e1 * t147 * t221 + 0.18005769000000000000000000000000000000000000000000e1 * t226 * t227 + 0.50000000000000000000000000000000000000000000000000e0 * t230 * t231 - 0.18005769000000000000000000000000000000000000000000e1 * t234 * t237 + 0.90028845000000000000000000000000000000000000000000e0 * t234 * t341 - 0.18005769000000000000000000000000000000000000000000e1 * t344 * t346 - 0.50000000000000000000000000000000000000000000000000e0 * t234 * t353 + 0.25000000000000000000000000000000000000000000000000e0 * t234 * t371
  t375 = f.my_piecewise3(t11, 0, t374)
  t391 = t139 * t2
  t394 = t234 * t123
  t420 = t235 * t204
  t425 = 0.10803461400000000000000000000000000000000000000000e2 * t147 * t205 * t231 - 0.27008653500000000000000000000000000000000000000000e1 * t344 * t339 * t210 * t220 - 0.15000000000000000000000000000000000000000000000000e1 * t234 * t117 * t350 * t220 * t370 - 0.54017307000000000000000000000000000000000000000000e1 * t147 * t341 - 0.15000000000000000000000000000000000000000000000000e1 * t391 * t221 + 0.54017307000000000000000000000000000000000000000000e1 * t394 * t235 * t210 * t220 - 0.54017307000000000000000000000000000000000000000000e1 * t394 * t227 * t339 - 0.54017307000000000000000000000000000000000000000000e1 * t391 * t206 + 0.30000000000000000000000000000000000000000000000000e1 * t147 * t353 + 0.54017307000000000000000000000000000000000000000000e1 * t344 * t204 * t350 * t352 - 0.27008653500000000000000000000000000000000000000000e1 * t344 * t345 * t370 - 0.15000000000000000000000000000000000000000000000000e1 * t147 * t371 + 0.10803461400000000000000000000000000000000000000000e2 * t147 * t237 + 0.15000000000000000000000000000000000000000000000000e1 * t21 * t117 * t128 + 0.54017307000000000000000000000000000000000000000000e1 * t234 * t120 * t420 * t128
  t426 = t209 ** 2
  t443 = t16 ** 2
  t447 = 0.6e1 * t134 - 0.6e1 * t1 / t443
  t448 = f.my_piecewise5(t13, 0, t15, 0, t447)
  t489 = f.my_piecewise5(t25, 0, t29, 0, t447)
  t490 = f.my_piecewise5(t45, 0, t47, 0, t489)
  t498 = t159 ** 2
  t513 = s0 / t56 / t273 / r0
  t526 = t168 ** 2
  t547 = t273 ** 2
  t557 = t175 ** 2
  t573 = f.my_piecewise3(t35, 0, -0.28e2 / 0.243e3 * t43 * t44 / t51 / t240 / t49 / t133 * t73 * t245 * t154 - 0.4e1 / 0.27e2 * t251 * t243 * t160 * t245 * t185 + 0.4e1 / 0.27e2 * t251 * t243 * t73 * t154 * t261 - 0.2e1 / 0.9e1 * t251 * t149 * t267 * t154 * t268 + t251 * t252 * t261 * t185 / 0.9e1 + t251 * t252 * t154 * t311 / 0.9e1 - t43 * t150 * t73 * (t490 * t2 + 0.3e1 * t258) / 0.27e2 - 0.2e1 / 0.3e1 * t43 * t53 / t498 * t268 * t185 + 0.2e1 / 0.3e1 * t251 * t52 * t267 * t185 * t311 - t43 * t53 * t160 * (-0.42587654320987654320987654320987654320987654320988e-1 * t43 * t513 * t68 - 0.27377777777777777777777777777777777777777777777778e-1 * t43 * t276 * t181 - 0.14933333333333333333333333333333333333333333333333e-1 * t43 * t164 * t286 + 0.74666666666666666666666666666666666666666666666667e-2 * t43 * t164 * t307 - 0.55999999999999999999999999999999999999999999999998e-2 * t43 * t59 / t526 * t285 * t180 + 0.55999999999999999999999999999999999999999999999998e-2 * t41 * t42 * s0 * t58 * t284 * t180 * t306 - 0.93333333333333333333333333333333333333333333333332e-3 * t43 * t59 * t169 * (-0.26133333333333333333333333333333333333333333333333e0 * t60 / t55 / t273 * t64 - 0.88853333333333333333333333333333333333333333333333e0 * t513 * t177 + 0.55253333333333333333333333333333333333333333333333e0 * t297 / t55 / t547 * t303 - 0.17920000000000000000000000000000000000000000000000e0 * t297 * s0 / t547 / t161 / t176 / t557)) / 0.9e1)
  t589 = f.my_piecewise5(t47, 0, t45, 0, -t489)
  t598 = f.my_piecewise3(t81, 0, -0.28e2 / 0.243e3 * t43 * t44 / t85 / t318 / t83 / t133 * t107 * t323 * t197 + 0.4e1 / 0.27e2 * t251 * t321 * t107 * t197 * t331 - t43 * t194 * t107 * (t589 * t2 + 0.3e1 * t328) / 0.27e2)
  t600 = f.my_piecewise3(t113, 0, t573 + t598)
  t645 = 0.15000000000000000000000000000000000000000000000000e1 * t234 * t117 / t426 * t352 * t220 - 0.54017307000000000000000000000000000000000000000000e1 * t226 * t346 + 0.15000000000000000000000000000000000000000000000000e1 * t20 * t2 * t129 * t138 - 0.15000000000000000000000000000000000000000000000000e1 * t22 * t221 - 0.54017307000000000000000000000000000000000000000000e1 * t22 * t206 + 0.50000000000000000000000000000000000000000000000000e0 * t132 * t448 * t141 - 0.30000000000000000000000000000000000000000000000000e1 * t144 * t221 - 0.10803461400000000000000000000000000000000000000000e2 * t144 * t206 + 0.90028845000000000000000000000000000000000000000000e0 * t234 * t125 * t600 * t128 + 0.25000000000000000000000000000000000000000000000000e0 * t234 * t211 * (-0.37668148836865200000e4 / t119 / t122 * t420 + 0.18834074418432600000e4 * t357 * t204 * t339 - 0.1255604961228840000e3 * t213 * t600 - 0.8978609874845520000e3 * t357 * t420 + 0.5387165924907312000e3 * t214 * t339 - 0.448930493742276000e2 * t120 * t600 - 0.42800061808800e2 * t213 * t420 + 0.32100046356600e2 * t216 * t339 - 0.3566671817400e1 * t123 * t600) - 0.54017307000000000000000000000000000000000000000000e1 * t225 * t123 * t235 * t128 - 0.15000000000000000000000000000000000000000000000000e1 * t230 * t350 * t352 + 0.15000000000000000000000000000000000000000000000000e1 * t139 * t129 + 0.75000000000000000000000000000000000000000000000000e0 * t230 * t210 * t370 + 0.27008653500000000000000000000000000000000000000000e1 * t226 * t339 * t128
  t647 = f.my_piecewise3(t11, 0, t425 + t645)
  d111 = t2 * t647 + 0.3e1 * t375

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = abs(t4)
  t11 = 0.1e1 - t5 <= f.p.zeta_threshold or r0 <= f.p.dens_threshold and r1 <= f.p.dens_threshold
  t13 = 0.1e1 + t4 <= f.p.zeta_threshold
  t14 = f.p.zeta_threshold - 0.1e1
  t16 = 0.1e1 - t4 <= f.p.zeta_threshold
  t17 = -t14
  t18 = f.my_piecewise5(t13, t14, t16, t17, t4)
  t19 = t18 ** 2
  t20 = 0.1e1 - t19
  t21 = t20 * t2
  t24 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t27 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t28 = f.my_piecewise5(t24, t14, t27, t17, t4)
  t29 = 0.1e1 + t28
  t32 = t29 * t2 / 0.2e1 <= f.p.dens_threshold
  t33 = 3 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t36 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t38 = t34 / t36
  t39 = 4 ** (0.1e1 / 0.3e1)
  t40 = t38 * t39
  t41 = 2 ** (0.1e1 / 0.3e1)
  t42 = t29 <= f.p.zeta_threshold
  t43 = 0.1e1 - t28
  t44 = t43 <= f.p.zeta_threshold
  t45 = f.my_piecewise5(t42, t14, t44, t17, t28)
  t46 = 0.1e1 + t45
  t47 = t46 * t2
  t48 = t47 ** (0.1e1 / 0.3e1)
  t49 = 0.1e1 / t48
  t50 = t41 * t49
  t51 = r0 ** 2
  t52 = r0 ** (0.1e1 / 0.3e1)
  t53 = t52 ** 2
  t55 = 0.1e1 / t53 / t51
  t56 = s0 * t55
  t57 = jnp.sqrt(s0)
  t60 = t57 / t52 / r0
  t61 = jnp.asinh(t60)
  t64 = 0.1e1 + 0.2520e-1 * t60 * t61
  t65 = 0.1e1 / t64
  t69 = 0.1e1 + 0.93333333333333333333333333333333333333333333333332e-3 * t40 * t56 * t65
  t70 = 0.1e1 / t69
  t74 = f.my_piecewise3(t32, 0, t40 * t50 * t70 / 0.9e1)
  t78 = t43 * t2 / 0.2e1 <= f.p.dens_threshold
  t79 = f.my_piecewise5(t44, t14, t42, t17, -t28)
  t80 = 0.1e1 + t79
  t81 = t80 * t2
  t82 = t81 ** (0.1e1 / 0.3e1)
  t85 = r1 ** 2
  t86 = r1 ** (0.1e1 / 0.3e1)
  t87 = t86 ** 2
  t91 = jnp.sqrt(s2)
  t94 = t91 / t86 / r1
  t95 = jnp.asinh(t94)
  t104 = 0.1e1 / (0.1e1 + 0.93333333333333333333333333333333333333333333333332e-3 * t40 * s2 / t87 / t85 / (0.1e1 + 0.2520e-1 * t94 * t95))
  t108 = f.my_piecewise3(t78, 0, t40 * t41 / t82 * t104 / 0.9e1)
  t109 = t74 + t108
  t110 = t109 == 0.0e0
  t111 = f.my_piecewise3(t110, DBL_EPSILON, t109)
  t112 = t111 ** 2
  t113 = t112 ** 2
  t114 = 0.1e1 / t113
  t116 = 0.1e1 / t48 / t47
  t117 = t41 * t116
  t118 = t2 ** 2
  t119 = 0.1e1 / t118
  t121 = -t1 * t119 + t3
  t122 = f.my_piecewise5(t24, 0, t27, 0, t121)
  t123 = f.my_piecewise5(t42, 0, t44, 0, t122)
  t125 = t123 * t2 + t45 + 0.1e1
  t130 = t69 ** 2
  t131 = 0.1e1 / t130
  t132 = t51 * r0
  t134 = 0.1e1 / t53 / t132
  t135 = s0 * t134
  t139 = t64 ** 2
  t140 = 0.1e1 / t139
  t146 = 0.1e1 + t56
  t147 = jnp.sqrt(t146)
  t148 = 0.1e1 / t147
  t151 = -0.33600000000000000000000000000000000000000000000000e-1 * t57 / t52 / t51 * t61 - 0.33600000000000000000000000000000000000000000000000e-1 * t135 * t148
  t152 = t140 * t151
  t156 = -0.24888888888888888888888888888888888888888888888889e-2 * t40 * t135 * t65 - 0.93333333333333333333333333333333333333333333333332e-3 * t40 * t56 * t152
  t162 = f.my_piecewise3(t32, 0, -t40 * t117 * t70 * t125 / 0.27e2 - t40 * t50 * t131 * t156 / 0.9e1)
  t165 = t41 / t82 / t81
  t166 = f.my_piecewise5(t44, 0, t42, 0, -t122)
  t168 = t166 * t2 + t79 + 0.1e1
  t173 = f.my_piecewise3(t78, 0, -t40 * t165 * t104 * t168 / 0.27e2)
  t175 = f.my_piecewise3(t110, 0, t162 + t173)
  t176 = t175 ** 2
  t177 = t176 * t175
  t180 = t112 * t111
  t181 = 0.1e1 / t180
  t183 = 0.1e1 / t112
  t185 = 0.313901240307210000e2 * t114 + 0.149643497914092000e2 * t181 + 0.1783335908700e1 * t183
  t186 = 0.1e1 / t185
  t187 = t114 * t177 * t186
  t190 = t20 * t183
  t191 = t185 ** 2
  t192 = 0.1e1 / t191
  t193 = t175 * t192
  t195 = 0.1e1 / t113 / t111
  t196 = t195 * t175
  t198 = t114 * t175
  t200 = t181 * t175
  t202 = -0.1255604961228840000e3 * t196 - 0.448930493742276000e2 * t198 - 0.3566671817400e1 * t200
  t203 = t193 * t202
  t206 = f.my_piecewise5(t13, 0, t16, 0, t121)
  t207 = t206 ** 2
  t208 = t207 * t2
  t209 = t183 * t175
  t210 = t209 * t186
  t213 = t18 * t206
  t216 = t46 ** 2
  t218 = t118 * t2
  t221 = 0.1e1 / t48 / t216 / t46 / t218
  t223 = t125 ** 2
  t224 = t223 * t125
  t230 = t38 * t39 * t41
  t233 = 0.1e1 / t48 / t216 / t118
  t234 = t233 * t131
  t239 = t233 * t70
  t240 = 0.1e1 / t218
  t243 = 0.2e1 * t1 * t240 - 0.2e1 * t119
  t244 = f.my_piecewise5(t24, 0, t27, 0, t243)
  t245 = f.my_piecewise5(t42, 0, t44, 0, t244)
  t248 = t245 * t2 + 0.2e1 * t123
  t254 = 0.1e1 / t130 / t69
  t255 = t116 * t254
  t256 = t156 ** 2
  t261 = t116 * t131
  t266 = t51 ** 2
  t269 = s0 / t53 / t266
  t277 = 0.1e1 / t139 / t64
  t278 = t151 ** 2
  t279 = t277 * t278
  t290 = s0 ** 2
  t296 = 0.1e1 / t147 / t146
  t299 = 0.78400000000000000000000000000000000000000000000000e-1 * t57 / t52 / t132 * t61 + 0.16800000000000000000000000000000000000000000000000e0 * t269 * t148 - 0.44800000000000000000000000000000000000000000000000e-1 * t290 / t52 / t266 / t132 * t296
  t300 = t140 * t299
  t304 = 0.91259259259259259259259259259259259259259259259260e-2 * t40 * t269 * t65 + 0.49777777777777777777777777777777777777777777777778e-2 * t40 * t135 * t152 + 0.18666666666666666666666666666666666666666666666666e-2 * t40 * t56 * t279 - 0.93333333333333333333333333333333333333333333333332e-3 * t40 * t56 * t300
  t309 = t118 ** 2
  t310 = 0.1e1 / t309
  t313 = -0.6e1 * t1 * t310 + 0.6e1 * t240
  t314 = f.my_piecewise5(t24, 0, t27, 0, t313)
  t315 = f.my_piecewise5(t42, 0, t44, 0, t314)
  t318 = t315 * t2 + 0.3e1 * t245
  t323 = t130 ** 2
  t324 = 0.1e1 / t323
  t325 = t256 * t156
  t330 = t49 * t254
  t335 = t266 * r0
  t338 = s0 / t53 / t335
  t351 = t139 ** 2
  t352 = 0.1e1 / t351
  t354 = t352 * t278 * t151
  t359 = t38 * t39 * s0
  t360 = t55 * t277
  t361 = t151 * t299
  t372 = t266 ** 2
  t378 = t290 * s0
  t382 = t146 ** 2
  t384 = 0.1e1 / t147 / t382
  t387 = -0.26133333333333333333333333333333333333333333333333e0 * t57 / t52 / t266 * t61 - 0.88853333333333333333333333333333333333333333333333e0 * t338 * t148 + 0.55253333333333333333333333333333333333333333333333e0 * t290 / t52 / t372 * t296 - 0.17920000000000000000000000000000000000000000000000e0 * t378 / t372 / t132 * t384
  t388 = t140 * t387
  t392 = -0.42587654320987654320987654320987654320987654320988e-1 * t40 * t338 * t65 - 0.27377777777777777777777777777777777777777777777778e-1 * t40 * t269 * t152 - 0.14933333333333333333333333333333333333333333333333e-1 * t40 * t135 * t279 + 0.74666666666666666666666666666666666666666666666667e-2 * t40 * t135 * t300 - 0.55999999999999999999999999999999999999999999999998e-2 * t40 * t56 * t354 + 0.55999999999999999999999999999999999999999999999998e-2 * t359 * t360 * t361 - 0.93333333333333333333333333333333333333333333333332e-3 * t40 * t56 * t388
  t398 = f.my_piecewise3(t32, 0, -0.28e2 / 0.243e3 * t40 * t41 * t221 * t70 * t224 - 0.4e1 / 0.27e2 * t230 * t234 * t223 * t156 + 0.4e1 / 0.27e2 * t230 * t239 * t125 * t248 - 0.2e1 / 0.9e1 * t230 * t255 * t125 * t256 + t230 * t261 * t248 * t156 / 0.9e1 + t230 * t261 * t125 * t304 / 0.9e1 - t40 * t117 * t70 * t318 / 0.27e2 - 0.2e1 / 0.3e1 * t40 * t50 * t324 * t325 + 0.2e1 / 0.3e1 * t230 * t330 * t156 * t304 - t40 * t50 * t131 * t392 / 0.9e1)
  t399 = t80 ** 2
  t403 = 0.1e1 / t82 / t399 / t80 / t218
  t405 = t168 ** 2
  t413 = 0.1e1 / t82 / t399 / t118
  t414 = t413 * t104
  t415 = f.my_piecewise5(t44, 0, t42, 0, -t244)
  t418 = t415 * t2 + 0.2e1 * t166
  t423 = f.my_piecewise5(t44, 0, t42, 0, -t314)
  t426 = t423 * t2 + 0.3e1 * t415
  t432 = f.my_piecewise3(t78, 0, -0.28e2 / 0.243e3 * t40 * t41 * t403 * t104 * t405 * t168 + 0.4e1 / 0.27e2 * t230 * t414 * t168 * t418 - t40 * t165 * t104 * t426 / 0.27e2)
  t434 = f.my_piecewise3(t110, 0, t398 + t432)
  t436 = t183 * t434 * t186
  t441 = 0.360115380e1 / t111 + 0.5764e0
  t442 = t441 * t192
  t444 = 0.1e1 / t113 / t180
  t448 = 0.1e1 / t113 / t112
  t449 = t448 * t175
  t450 = t41 * t233
  t455 = t125 * t156
  t472 = f.my_piecewise3(t32, 0, 0.4e1 / 0.81e2 * t40 * t450 * t70 * t223 + 0.2e1 / 0.27e2 * t230 * t261 * t455 - t40 * t117 * t70 * t248 / 0.27e2 + 0.2e1 / 0.9e1 * t40 * t50 * t254 * t256 - t40 * t50 * t131 * t304 / 0.9e1)
  t473 = t41 * t413
  t483 = f.my_piecewise3(t78, 0, 0.4e1 / 0.81e2 * t40 * t473 * t104 * t405 - t40 * t165 * t104 * t418 / 0.27e2)
  t485 = f.my_piecewise3(t110, 0, t472 + t483)
  t502 = -0.37668148836865200000e4 * t444 * t177 + 0.18834074418432600000e4 * t449 * t485 - 0.1255604961228840000e3 * t195 * t434 - 0.8978609874845520000e3 * t448 * t177 + 0.5387165924907312000e3 * t196 * t485 - 0.448930493742276000e2 * t114 * t434 - 0.42800061808800e2 * t195 * t177 + 0.32100046356600e2 * t198 * t485 - 0.3566671817400e1 * t181 * t434
  t503 = t442 * t502
  t506 = t191 ** 2
  t507 = 0.1e1 / t506
  t509 = t202 ** 2
  t510 = t509 * t202
  t511 = t441 * t507 * t510
  t514 = t206 * t2
  t515 = t441 * t186
  t516 = f.my_piecewise5(t13, 0, t16, 0, t243)
  t520 = t442 * t202
  t523 = f.my_piecewise5(t13, 0, t16, 0, t313)
  t524 = t18 * t523
  t526 = t2 * t441 * t186
  t531 = t18 * t516
  t532 = t531 * t2
  t535 = t213 * t2
  t536 = t181 * t176
  t537 = t536 * t186
  t540 = t21 * t181
  t541 = t176 * t192
  t542 = t541 * t202
  t545 = t175 * t186
  t546 = t545 * t485
  t549 = 0.54017307000000000000000000000000000000000000000000e1 * t21 * t187 - 0.54017307000000000000000000000000000000000000000000e1 * t190 * t203 - 0.54017307000000000000000000000000000000000000000000e1 * t208 * t210 - 0.10803461400000000000000000000000000000000000000000e2 * t213 * t210 + 0.90028845000000000000000000000000000000000000000000e0 * t21 * t436 + 0.25000000000000000000000000000000000000000000000000e0 * t21 * t503 + 0.15000000000000000000000000000000000000000000000000e1 * t21 * t511 + 0.15000000000000000000000000000000000000000000000000e1 * t514 * t515 * t516 - 0.15000000000000000000000000000000000000000000000000e1 * t208 * t520 + 0.50000000000000000000000000000000000000000000000000e0 * t524 * t526 - 0.30000000000000000000000000000000000000000000000000e1 * t213 * t520 - 0.15000000000000000000000000000000000000000000000000e1 * t532 * t520 + 0.10803461400000000000000000000000000000000000000000e2 * t535 * t537 + 0.54017307000000000000000000000000000000000000000000e1 * t540 * t542 - 0.54017307000000000000000000000000000000000000000000e1 * t540 * t546
  t550 = t207 * t441
  t553 = t21 * t183
  t554 = t448 * t176
  t558 = t195 * t176
  t566 = 0.6278024806144200000e3 * t554 - 0.1255604961228840000e3 * t195 * t485 + 0.1795721974969104000e3 * t558 - 0.448930493742276000e2 * t114 * t485 + 0.10700015452200e2 * t114 * t176 - 0.3566671817400e1 * t181 * t485
  t567 = t193 * t566
  t570 = t485 * t192
  t571 = t570 * t202
  t575 = 0.1e1 / t191 / t185
  t576 = t175 * t575
  t577 = t576 * t509
  t582 = t442 * t566
  t585 = t183 * t485
  t586 = t585 * t186
  t589 = t441 * t575
  t590 = t589 * t509
  t593 = t21 * t441
  t594 = t575 * t202
  t595 = t594 * t566
  t598 = t20 * t181
  t599 = t176 * t186
  t602 = t485 * t186
  t605 = t20 * t441
  t606 = t575 * t509
  t611 = t192 * t566
  t614 = t192 * t202
  t615 = t209 * t614
  t618 = 0.15000000000000000000000000000000000000000000000000e1 * t550 * t186 - 0.27008653500000000000000000000000000000000000000000e1 * t553 * t567 - 0.27008653500000000000000000000000000000000000000000e1 * t553 * t571 + 0.54017307000000000000000000000000000000000000000000e1 * t553 * t577 - 0.54017307000000000000000000000000000000000000000000e1 * t532 * t210 - 0.15000000000000000000000000000000000000000000000000e1 * t535 * t582 - 0.54017307000000000000000000000000000000000000000000e1 * t535 * t586 + 0.30000000000000000000000000000000000000000000000000e1 * t535 * t590 - 0.15000000000000000000000000000000000000000000000000e1 * t593 * t595 - 0.54017307000000000000000000000000000000000000000000e1 * t598 * t599 + 0.27008653500000000000000000000000000000000000000000e1 * t190 * t602 - 0.15000000000000000000000000000000000000000000000000e1 * t605 * t606 + 0.15000000000000000000000000000000000000000000000000e1 * t531 * t515 + 0.75000000000000000000000000000000000000000000000000e0 * t605 * t611 + 0.10803461400000000000000000000000000000000000000000e2 * t535 * t615
  t620 = f.my_piecewise3(t11, 0, t549 + t618)
  t628 = t566 ** 2
  t635 = t509 ** 2
  t639 = t176 ** 2
  t653 = -0.24e2 * t310 + 0.24e2 * t1 / t309 / t2
  t654 = f.my_piecewise5(t13, 0, t16, 0, t653)
  t660 = t256 ** 2
  t682 = t216 ** 2
  t687 = t223 ** 2
  t706 = t248 ** 2
  t719 = t304 ** 2
  t728 = f.my_piecewise5(t24, 0, t27, 0, t653)
  t729 = f.my_piecewise5(t42, 0, t44, 0, t728)
  t737 = t266 * t51
  t740 = s0 / t53 / t737
  t765 = t278 ** 2
  t775 = t299 ** 2
  t802 = t290 ** 2
  t817 = 0.24133004115226337448559670781893004115226337448560e0 * t40 * t740 * t65 + 0.17035061728395061728395061728395061728395061728395e0 * t40 * t338 * t152 + 0.10951111111111111111111111111111111111111111111111e0 * t40 * t269 * t279 - 0.54755555555555555555555555555555555555555555555556e-1 * t40 * t269 * t300 + 0.59733333333333333333333333333333333333333333333332e-1 * t40 * t135 * t354 - 0.59733333333333333333333333333333333333333333333332e-1 * t359 * t134 * t277 * t361 + 0.99555555555555555555555555555555555555555555555556e-2 * t40 * t135 * t388 + 0.22399999999999999999999999999999999999999999999999e-1 * t40 * t56 / t351 / t64 * t765 - 0.33599999999999999999999999999999999999999999999998e-1 * t359 * t55 * t352 * t278 * t299 + 0.55999999999999999999999999999999999999999999999998e-2 * t40 * t56 * t277 * t775 + 0.74666666666666666666666666666666666666666666666664e-2 * t359 * t360 * t151 * t387 - 0.93333333333333333333333333333333333333333333333332e-3 * t40 * t56 * t140 * (0.11324444444444444444444444444444444444444444444444e1 * t57 / t52 / t335 * t61 + 0.53834666666666666666666666666666666666666666666666e1 * t740 * t148 - 0.57891555555555555555555555555555555555555555555555e1 * t290 / t52 / t372 / r0 * t296 + 0.41813333333333333333333333333333333333333333333333e1 * t378 / t372 / t266 * t384 - 0.11946666666666666666666666666666666666666666666667e1 * t802 / t53 / t372 / t737 / t147 / t382 / t146)
  t840 = 0.8e1 / 0.3e1 * t40 * t50 / t323 / t69 * t660 - 0.4e1 * t230 * t49 * t324 * t256 * t304 + 0.4e1 / 0.27e2 * t230 * t261 * t318 * t156 + 0.2e1 / 0.9e1 * t230 * t261 * t248 * t304 + 0.4e1 / 0.27e2 * t230 * t261 * t125 * t392 + 0.280e3 / 0.729e3 * t40 * t41 / t48 / t682 / t309 * t70 * t687 + 0.112e3 / 0.243e3 * t230 * t221 * t131 * t224 * t156 - 0.56e2 / 0.81e2 * t230 * t221 * t70 * t223 * t248 - 0.8e1 / 0.27e2 * t230 * t234 * t223 * t304 + 0.4e1 / 0.27e2 * t40 * t450 * t70 * t706 + 0.16e2 / 0.81e2 * t230 * t239 * t125 * t318 - 0.4e1 / 0.9e1 * t230 * t255 * t248 * t256 + 0.2e1 / 0.3e1 * t40 * t50 * t254 * t719 + 0.8e1 / 0.9e1 * t230 * t330 * t156 * t392 - t40 * t117 * t70 * (t729 * t2 + 0.4e1 * t315) / 0.27e2 - t40 * t50 * t131 * t817 / 0.9e1 + 0.16e2 / 0.27e2 * t230 * t233 * t254 * t223 * t256 - 0.16e2 / 0.27e2 * t230 * t234 * t455 * t248 + 0.8e1 / 0.9e1 * t230 * t116 * t324 * t125 * t325 - 0.8e1 / 0.9e1 * t230 * t255 * t455 * t304
  t841 = f.my_piecewise3(t32, 0, t840)
  t842 = t399 ** 2
  t847 = t405 ** 2
  t857 = t418 ** 2
  t866 = f.my_piecewise5(t44, 0, t42, 0, -t728)
  t875 = f.my_piecewise3(t78, 0, 0.280e3 / 0.729e3 * t40 * t41 / t82 / t842 / t309 * t104 * t847 - 0.56e2 / 0.81e2 * t230 * t403 * t104 * t405 * t418 + 0.4e1 / 0.27e2 * t40 * t473 * t104 * t857 + 0.16e2 / 0.81e2 * t230 * t414 * t168 * t426 - t40 * t165 * t104 * (t866 * t2 + 0.4e1 * t423) / 0.27e2)
  t877 = f.my_piecewise3(t110, 0, t841 + t875)
  t884 = t113 ** 2
  t891 = t485 ** 2
  t918 = 0.263677041858056400000e5 / t884 * t639 - 0.226008893021191200000e5 * t444 * t176 * t485 + 0.18834074418432600000e4 * t448 * t891 + 0.25112099224576800000e4 * t449 * t434 - 0.1255604961228840000e3 * t195 * t877 + 0.53871659249073120000e4 * t444 * t639 - 0.53871659249073120000e4 * t554 * t485 + 0.5387165924907312000e3 * t195 * t891 + 0.7182887899876416000e3 * t196 * t434 - 0.448930493742276000e2 * t114 * t877 + 0.214000309044000e3 * t448 * t639 - 0.256800370852800e3 * t558 * t485 + 0.32100046356600e2 * t114 * t891 + 0.42800061808800e2 * t198 * t434 - 0.3566671817400e1 * t181 * t877
  t932 = -0.60000000000000000000000000000000000000000000000000e1 * t531 * t520 + 0.21606922800000000000000000000000000000000000000000e2 * t190 * t577 - 0.21606922800000000000000000000000000000000000000000e2 * t531 * t210 - 0.15000000000000000000000000000000000000000000000000e1 * t21 * t589 * t628 - 0.60000000000000000000000000000000000000000000000000e1 * t21 * t441 / t506 / t185 * t635 - 0.21606922800000000000000000000000000000000000000000e2 * t21 * t195 * t639 * t186 + 0.60000000000000000000000000000000000000000000000000e1 * t208 * t590 + 0.20000000000000000000000000000000000000000000000000e1 * t514 * t515 * t523 + 0.50000000000000000000000000000000000000000000000000e0 * t18 * t654 * t526 + 0.90028845000000000000000000000000000000000000000000e0 * t21 * t183 * t877 * t186 - 0.10803461400000000000000000000000000000000000000000e2 * t208 * t586 + 0.25000000000000000000000000000000000000000000000000e0 * t21 * t442 * t918 - 0.10803461400000000000000000000000000000000000000000e2 * t190 * t571 - 0.21606922800000000000000000000000000000000000000000e2 * t213 * t586 - 0.60000000000000000000000000000000000000000000000000e1 * t605 * t595 - 0.10803461400000000000000000000000000000000000000000e2 * t190 * t567 + 0.12000000000000000000000000000000000000000000000000e2 * t213 * t590
  t968 = t21 * t114
  t976 = t206 * t516
  t977 = t976 * t2
  t980 = -0.30000000000000000000000000000000000000000000000000e1 * t208 * t582 - 0.60000000000000000000000000000000000000000000000000e1 * t213 * t582 + 0.21606922800000000000000000000000000000000000000000e2 * t598 * t542 - 0.21606922800000000000000000000000000000000000000000e2 * t598 * t546 - 0.54017307000000000000000000000000000000000000000000e1 * t21 * t181 * t891 * t186 + 0.43213845600000000000000000000000000000000000000000e2 * t213 * t537 + 0.21606922800000000000000000000000000000000000000000e2 * t208 * t537 - 0.43213845600000000000000000000000000000000000000000e2 * t535 * t187 + 0.90000000000000000000000000000000000000000000000000e1 * t593 * t507 * t509 * t566 - 0.10803461400000000000000000000000000000000000000000e2 * t532 * t586 - 0.36011538000000000000000000000000000000000000000000e1 * t553 * t434 * t192 * t202 - 0.12000000000000000000000000000000000000000000000000e2 * t535 * t511 - 0.36011538000000000000000000000000000000000000000000e1 * t553 * t193 * t502 + 0.60000000000000000000000000000000000000000000000000e1 * t532 * t590 + 0.32410384200000000000000000000000000000000000000000e2 * t968 * t599 * t485 + 0.10803461400000000000000000000000000000000000000000e2 * t553 * t485 * t575 * t509 - 0.21606922800000000000000000000000000000000000000000e2 * t977 * t210
  t1008 = t524 * t2
  t1029 = -0.20000000000000000000000000000000000000000000000000e1 * t593 * t594 * t502 - 0.54017307000000000000000000000000000000000000000000e1 * t553 * t570 * t566 + 0.21606922800000000000000000000000000000000000000000e2 * t532 * t537 + 0.21606922800000000000000000000000000000000000000000e2 * t208 * t183 * t203 - 0.21606922800000000000000000000000000000000000000000e2 * t540 * t176 * t575 * t509 + 0.43213845600000000000000000000000000000000000000000e2 * t213 * t183 * t203 - 0.20000000000000000000000000000000000000000000000000e1 * t535 * t503 - 0.30000000000000000000000000000000000000000000000000e1 * t532 * t582 - 0.60000000000000000000000000000000000000000000000000e1 * t977 * t520 - 0.72023076000000000000000000000000000000000000000000e1 * t535 * t436 - 0.20000000000000000000000000000000000000000000000000e1 * t1008 * t520 - 0.72023076000000000000000000000000000000000000000000e1 * t540 * t545 * t434 - 0.72023076000000000000000000000000000000000000000000e1 * t1008 * t210 - 0.21606922800000000000000000000000000000000000000000e2 * t553 * t175 * t507 * t510 + 0.10803461400000000000000000000000000000000000000000e2 * t540 * t541 * t566 - 0.43213845600000000000000000000000000000000000000000e2 * t535 * t209 * t606 + 0.43213845600000000000000000000000000000000000000000e2 * t535 * t200 * t602
  t1042 = t202 * t566
  t1064 = t516 ** 2
  t1082 = -0.21606922800000000000000000000000000000000000000000e2 * t968 * t177 * t192 * t202 + 0.21606922800000000000000000000000000000000000000000e2 * t535 * t209 * t611 + 0.21606922800000000000000000000000000000000000000000e2 * t535 * t585 * t614 + 0.21606922800000000000000000000000000000000000000000e2 * t532 * t615 + 0.12000000000000000000000000000000000000000000000000e2 * t535 * t589 * t1042 - 0.43213845600000000000000000000000000000000000000000e2 * t535 * t536 * t614 + 0.21606922800000000000000000000000000000000000000000e2 * t553 * t576 * t1042 + 0.21606922800000000000000000000000000000000000000000e2 * t540 * t193 * t485 * t202 + 0.36011538000000000000000000000000000000000000000000e1 * t190 * t434 * t186 - 0.60000000000000000000000000000000000000000000000000e1 * t550 * t614 - 0.21606922800000000000000000000000000000000000000000e2 * t207 * t183 * t545 + 0.15000000000000000000000000000000000000000000000000e1 * t1064 * t2 * t515 + 0.60000000000000000000000000000000000000000000000000e1 * t605 * t507 * t510 + 0.60000000000000000000000000000000000000000000000000e1 * t976 * t515 + 0.20000000000000000000000000000000000000000000000000e1 * t524 * t515 + 0.21606922800000000000000000000000000000000000000000e2 * t20 * t114 * t177 * t186 + 0.10000000000000000000000000000000000000000000000000e1 * t605 * t192 * t502
  t1085 = f.my_piecewise3(t11, 0, t932 + t980 + t1029 + t1082)
  d1111 = t2 * t1085 + 0.4e1 * t620

  res = {'v4rho4': d1111}
  return res
