"""Generated from gga_k_meyer.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  meyer_feta = lambda y: 1 / 2 * (1 + (1 - y ** 2) * jnp.log((1 + y) / jnp.abs(1 - y)) / (2 * y))

  meyer_lambda = lambda y: (1 - meyer_feta(y)) / (3 * y ** 2 * meyer_feta(y))

  meyer_f = lambda x: 1 + meyer_lambda(X2S * x / 6) * x ** 2 / (8 * K_FACTOR_C)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_kinetic(f, params, meyer_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  meyer_feta = lambda y: 1 / 2 * (1 + (1 - y ** 2) * jnp.log((1 + y) / jnp.abs(1 - y)) / (2 * y))

  meyer_lambda = lambda y: (1 - meyer_feta(y)) / (3 * y ** 2 * meyer_feta(y))

  meyer_f = lambda x: 1 + meyer_lambda(X2S * x / 6) * x ** 2 / (8 * K_FACTOR_C)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_kinetic(f, params, meyer_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  meyer_feta = lambda y: 1 / 2 * (1 + (1 - y ** 2) * jnp.log((1 + y) / jnp.abs(1 - y)) / (2 * y))

  meyer_lambda = lambda y: (1 - meyer_feta(y)) / (3 * y ** 2 * meyer_feta(y))

  meyer_f = lambda x: 1 + meyer_lambda(X2S * x / 6) * x ** 2 / (8 * K_FACTOR_C)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_kinetic(f, params, meyer_f, rs, zeta, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 * t4 * jnp.pi
  t7 = r0 + r1
  t8 = 0.1e1 / t7
  t11 = 0.2e1 * r0 * t8 <= f.p.zeta_threshold
  t12 = f.p.zeta_threshold - 0.1e1
  t15 = 0.2e1 * r1 * t8 <= f.p.zeta_threshold
  t16 = -t12
  t17 = r0 - r1
  t18 = t17 * t8
  t19 = f.my_piecewise5(t11, t12, t15, t16, t18)
  t20 = 0.1e1 + t19
  t21 = t20 <= f.p.zeta_threshold
  t22 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = t23 * f.p.zeta_threshold
  t25 = t20 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t28 = f.my_piecewise3(t21, t24, t26 * t20)
  t29 = t7 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = t28 * t30
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t37 = t32 / t35
  t38 = r0 ** 2
  t39 = r0 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t46 = 0.1e1 - t37 * s0 / t40 / t38 / 0.864e3
  t47 = t32 ** 2
  t49 = t47 / t34
  t50 = jnp.sqrt(s0)
  t51 = t39 * r0
  t52 = 0.1e1 / t51
  t55 = t49 * t50 * t52 / 0.72e2
  t56 = 0.1e1 + t55
  t57 = 0.1e1 - t55
  t58 = abs(t57)
  t59 = 0.1e1 / t58
  t61 = jnp.log(t56 * t59)
  t63 = t46 * t61 * t32
  t64 = 0.1e1 / t50
  t65 = t34 * t64
  t68 = 0.3e1 * t63 * t65 * t51
  t69 = 0.1e1 / 0.2e1 - t68
  t70 = 0.1e1 / 0.2e1 + t68
  t71 = 0.1e1 / t70
  t74 = 0.20e2 * t69 * t71 + 0.1e1
  t78 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t31 * t74)
  t79 = r1 <= f.p.dens_threshold
  t80 = f.my_piecewise5(t15, t12, t11, t16, -t18)
  t81 = 0.1e1 + t80
  t82 = t81 <= f.p.zeta_threshold
  t83 = t81 ** (0.1e1 / 0.3e1)
  t84 = t83 ** 2
  t86 = f.my_piecewise3(t82, t24, t84 * t81)
  t87 = t86 * t30
  t88 = r1 ** 2
  t89 = r1 ** (0.1e1 / 0.3e1)
  t90 = t89 ** 2
  t96 = 0.1e1 - t37 * s2 / t90 / t88 / 0.864e3
  t97 = jnp.sqrt(s2)
  t98 = t89 * r1
  t99 = 0.1e1 / t98
  t102 = t49 * t97 * t99 / 0.72e2
  t103 = 0.1e1 + t102
  t104 = 0.1e1 - t102
  t105 = abs(t104)
  t106 = 0.1e1 / t105
  t108 = jnp.log(t103 * t106)
  t110 = t96 * t108 * t32
  t111 = 0.1e1 / t97
  t112 = t34 * t111
  t115 = 0.3e1 * t110 * t112 * t98
  t116 = 0.1e1 / 0.2e1 - t115
  t117 = 0.1e1 / 0.2e1 + t115
  t118 = 0.1e1 / t117
  t121 = 0.20e2 * t116 * t118 + 0.1e1
  t125 = f.my_piecewise3(t79, 0, 0.3e1 / 0.20e2 * t6 * t87 * t121)
  t126 = t7 ** 2
  t128 = t17 / t126
  t129 = t8 - t128
  t130 = f.my_piecewise5(t11, 0, t15, 0, t129)
  t133 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t130)
  t138 = 0.1e1 / t29
  t142 = t6 * t28 * t138 * t74 / 0.10e2
  t145 = t50 / t39 / t38
  t151 = t58 ** 2
  t154 = jnp.abs(1 - t57)
  t155 = t56 / t151 * t154
  t162 = 0.1e1 / t56 * t58
  t164 = t32 * t34
  t166 = t164 * t64 * t51
  t172 = -t49 * t145 * t61 / 0.108e3 - 0.3e1 * t46 * (-t155 * t49 * t145 / 0.54e2 - t49 * t145 * t59 / 0.54e2) * t162 * t166 - 0.4e1 * t63 * t65 * t39
  t174 = t70 ** 2
  t176 = t69 / t174
  t185 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t133 * t30 * t74 + t142 + 0.3e1 / 0.20e2 * t6 * t31 * (0.20e2 * t176 * t172 + 0.20e2 * t172 * t71))
  t187 = f.my_piecewise5(t15, 0, t11, 0, -t129)
  t190 = f.my_piecewise3(t82, 0, 0.5e1 / 0.3e1 * t84 * t187)
  t198 = t6 * t86 * t138 * t121 / 0.10e2
  t200 = f.my_piecewise3(t79, 0, 0.3e1 / 0.20e2 * t6 * t190 * t30 * t121 + t198)
  vrho_0_ = t78 + t125 + t7 * (t185 + t200)
  t203 = -t8 - t128
  t204 = f.my_piecewise5(t11, 0, t15, 0, t203)
  t207 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t26 * t204)
  t213 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t207 * t30 * t74 + t142)
  t215 = f.my_piecewise5(t15, 0, t11, 0, -t203)
  t218 = f.my_piecewise3(t82, 0, 0.5e1 / 0.3e1 * t84 * t215)
  t225 = t97 / t89 / t88
  t231 = t105 ** 2
  t234 = jnp.abs(1 - t104)
  t235 = t103 / t231 * t234
  t242 = 0.1e1 / t103 * t105
  t245 = t164 * t111 * t98
  t251 = -t49 * t225 * t108 / 0.108e3 - 0.3e1 * t96 * (-t49 * t225 * t106 / 0.54e2 - t235 * t49 * t225 / 0.54e2) * t242 * t245 - 0.4e1 * t110 * t112 * t89
  t253 = t117 ** 2
  t255 = t116 / t253
  t264 = f.my_piecewise3(t79, 0, 0.3e1 / 0.20e2 * t6 * t218 * t30 * t121 + t198 + 0.3e1 / 0.20e2 * t6 * t87 * (0.20e2 * t251 * t118 + 0.20e2 * t255 * t251))
  vrho_1_ = t78 + t125 + t7 * (t213 + t264)
  t271 = t64 * t52
  t288 = t49 * t52 * t61 * t64 / 0.288e3 - 0.3e1 * t46 * (t155 * t49 * t271 / 0.144e3 + t49 * t271 * t59 / 0.144e3) * t162 * t166 + 0.3e1 / 0.2e1 * t63 * t34 / t50 / s0 * t51
  t297 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t31 * (0.20e2 * t176 * t288 + 0.20e2 * t288 * t71))
  vsigma_0_ = t7 * t297
  vsigma_1_ = 0.0e0
  t302 = t111 * t99
  t319 = t49 * t99 * t108 * t111 / 0.288e3 - 0.3e1 * t96 * (t49 * t302 * t106 / 0.144e3 + t235 * t49 * t302 / 0.144e3) * t242 * t245 + 0.3e1 / 0.2e1 * t110 * t34 / t97 / s2 * t98
  t328 = f.my_piecewise3(t79, 0, 0.3e1 / 0.20e2 * t6 * t87 * (0.20e2 * t319 * t118 + 0.20e2 * t255 * t319))
  vsigma_2_ = t7 * t328
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  meyer_feta = lambda y: 1 / 2 * (1 + (1 - y ** 2) * jnp.log((1 + y) / jnp.abs(1 - y)) / (2 * y))

  meyer_lambda = lambda y: (1 - meyer_feta(y)) / (3 * y ** 2 * meyer_feta(y))

  meyer_f = lambda x: 1 + meyer_lambda(X2S * x / 6) * x ** 2 / (8 * K_FACTOR_C)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_kinetic(f, params, meyer_f, rs, zeta, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = t4 * t5 * jnp.pi
  t8 = 0.1e1 <= f.p.zeta_threshold
  t9 = f.p.zeta_threshold - 0.1e1
  t11 = f.my_piecewise5(t8, t9, t8, -t9, 0)
  t12 = 0.1e1 + t11
  t14 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = t12 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t20 = f.my_piecewise3(t12 <= f.p.zeta_threshold, t15 * f.p.zeta_threshold, t18 * t12)
  t21 = r0 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = t20 * t22
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t33 = r0 ** 2
  t39 = 0.1e1 - t24 / t27 * s0 * t31 / t22 / t33 / 0.864e3
  t40 = t24 ** 2
  t41 = 0.1e1 / t26
  t42 = t40 * t41
  t43 = jnp.sqrt(s0)
  t45 = t21 * r0
  t46 = 0.1e1 / t45
  t49 = t42 * t43 * t30 * t46 / 0.72e2
  t50 = 0.1e1 + t49
  t51 = 0.1e1 - t49
  t52 = abs(t51)
  t53 = 0.1e1 / t52
  t55 = jnp.log(t50 * t53)
  t57 = t39 * t55 * t24
  t58 = 0.1e1 / t43
  t59 = t26 * t58
  t60 = t31 * t45
  t63 = 0.3e1 / 0.2e1 * t57 * t59 * t60
  t64 = 0.1e1 / 0.2e1 - t63
  t65 = 0.1e1 / 0.2e1 + t63
  t66 = 0.1e1 / t65
  t69 = 0.20e2 * t64 * t66 + 0.1e1
  t73 = f.my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t23 * t69)
  t79 = t42 * t43
  t82 = t30 / t21 / t33
  t88 = t52 ** 2
  t91 = jnp.abs(1 - t51)
  t93 = t50 / t88 * t91 * t40
  t101 = 0.1e1 / t50 * t52
  t106 = t24 * t26 * t58 * t31 * t45
  t113 = -t79 * t82 * t55 / 0.108e3 - 0.3e1 / 0.2e1 * t39 * (-t93 * t41 * t43 * t82 / 0.54e2 - t79 * t82 * t53 / 0.54e2) * t101 * t106 - 0.2e1 * t57 * t59 * t31 * t21
  t115 = t65 ** 2
  t117 = t64 / t115
  t126 = f.my_piecewise3(t2, 0, t7 * t20 / t21 * t69 / 0.10e2 + 0.3e1 / 0.20e2 * t7 * t23 * (0.20e2 * t117 * t113 + 0.20e2 * t113 * t66))
  vrho_0_ = 0.2e1 * r0 * t126 + 0.2e1 * t73
  t135 = t30 * t46
  t153 = t42 * t30 * t46 * t55 * t58 / 0.288e3 - 0.3e1 / 0.2e1 * t39 * (t93 * t41 * t58 * t135 / 0.144e3 + t42 * t58 * t135 * t53 / 0.144e3) * t101 * t106 + 0.3e1 / 0.4e1 * t57 * t26 / t43 / s0 * t60
  t162 = f.my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t23 * (0.20e2 * t117 * t153 + 0.20e2 * t153 * t66))
  vsigma_0_ = 0.2e1 * r0 * t162
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = t4 * t5 * jnp.pi
  t8 = 0.1e1 <= f.p.zeta_threshold
  t9 = f.p.zeta_threshold - 0.1e1
  t11 = f.my_piecewise5(t8, t9, t8, -t9, 0)
  t12 = 0.1e1 + t11
  t14 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = t12 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t20 = f.my_piecewise3(t12 <= f.p.zeta_threshold, t15 * f.p.zeta_threshold, t18 * t12)
  t21 = r0 ** (0.1e1 / 0.3e1)
  t23 = t20 / t21
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = 0.1e1 / t27
  t29 = t24 * t28
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t33 = r0 ** 2
  t34 = t21 ** 2
  t36 = 0.1e1 / t34 / t33
  t40 = 0.1e1 - t29 * s0 * t31 * t36 / 0.864e3
  t41 = t24 ** 2
  t42 = 0.1e1 / t26
  t43 = t41 * t42
  t44 = jnp.sqrt(s0)
  t45 = t44 * t30
  t46 = t21 * r0
  t47 = 0.1e1 / t46
  t50 = t43 * t45 * t47 / 0.72e2
  t51 = 0.1e1 + t50
  t52 = 0.1e1 - t50
  t53 = abs(t52)
  t54 = 0.1e1 / t53
  t56 = jnp.log(t51 * t54)
  t58 = t40 * t56 * t24
  t59 = 0.1e1 / t44
  t60 = t26 * t59
  t61 = t31 * t46
  t64 = 0.3e1 / 0.2e1 * t58 * t60 * t61
  t65 = 0.1e1 / 0.2e1 - t64
  t66 = 0.1e1 / 0.2e1 + t64
  t67 = 0.1e1 / t66
  t70 = 0.20e2 * t65 * t67 + 0.1e1
  t74 = t20 * t34
  t75 = t43 * t44
  t77 = 0.1e1 / t21 / t33
  t78 = t30 * t77
  t82 = t78 * t54
  t84 = t53 ** 2
  t85 = 0.1e1 / t84
  t86 = t51 * t85
  t87 = jnp.abs(1 - t52)
  t89 = t86 * t87 * t41
  t90 = t42 * t44
  t91 = t90 * t78
  t94 = -t75 * t82 / 0.54e2 - t89 * t91 / 0.54e2
  t95 = t40 * t94
  t96 = 0.1e1 / t51
  t97 = t96 * t53
  t98 = t95 * t97
  t99 = t24 * t26
  t100 = t59 * t31
  t102 = t99 * t100 * t46
  t105 = t31 * t21
  t109 = -t75 * t78 * t56 / 0.108e3 - 0.3e1 / 0.2e1 * t98 * t102 - 0.2e1 * t58 * t60 * t105
  t111 = t66 ** 2
  t112 = 0.1e1 / t111
  t113 = t65 * t112
  t114 = -t109
  t117 = 0.20e2 * t109 * t67 - 0.20e2 * t113 * t114
  t122 = f.my_piecewise3(t2, 0, t7 * t23 * t70 / 0.10e2 + 0.3e1 / 0.20e2 * t7 * t74 * t117)
  t131 = t33 * r0
  t134 = t30 / t21 / t131
  t138 = t43 * t45
  t147 = t33 ** 2
  t150 = t31 / t34 / t147
  t151 = t85 * t87
  t157 = t51 / t84 / t53
  t158 = t87 ** 2
  t160 = t157 * t158 * t24
  t165 = signum(1, t52)
  t167 = t86 * t165 * t41
  t178 = t51 ** 2
  t180 = 0.1e1 / t178 * t53
  t181 = 0.1e1 / r0
  t182 = t180 * t181
  t185 = t96 * t87
  t186 = t185 * t181
  t190 = t99 * t100 * t21
  t198 = t75 * t134 * t56 / 0.108e3 - t138 * t77 * t94 * t97 / 0.54e2 - 0.3e1 / 0.2e1 * t40 * (0.7e1 / 0.162e3 * t75 * t134 * t54 + t29 * s0 * t150 * t151 / 0.243e3 + t160 * t28 * s0 * t150 / 0.243e3 - t167 * t91 / 0.54e2 + 0.7e1 / 0.162e3 * t89 * t90 * t134) * t97 * t102 - t95 * t182 / 0.3e1 - t95 * t186 / 0.3e1 - 0.4e1 * t98 * t190 - 0.2e1 / 0.3e1 * t58 * t60 * t31 / t34
  t201 = t109 * t112
  t206 = t65 / t111 / t66
  t207 = t114 ** 2
  t218 = f.my_piecewise3(t2, 0, -t7 * t20 * t47 * t70 / 0.30e2 + t7 * t23 * t117 / 0.5e1 + 0.3e1 / 0.20e2 * t7 * t74 * (0.20e2 * t113 * t198 - 0.40e2 * t201 * t114 + 0.20e2 * t198 * t67 + 0.40e2 * t206 * t207))
  v2rho2_0_ = 0.2e1 * r0 * t218 + 0.4e1 * t122
  t221 = t43 * t30
  t222 = t47 * t56
  t226 = t43 * t59
  t227 = t30 * t47
  t228 = t227 * t54
  t230 = t42 * t59
  t231 = t230 * t227
  t234 = t226 * t228 / 0.144e3 + t89 * t231 / 0.144e3
  t235 = t40 * t234
  t236 = t235 * t97
  t240 = 0.1e1 / t44 / s0
  t241 = t26 * t240
  t245 = t221 * t222 * t59 / 0.288e3 - 0.3e1 / 0.2e1 * t236 * t102 + 0.3e1 / 0.4e1 * t58 * t241 * t61
  t247 = -t245
  t250 = -0.20e2 * t113 * t247 + 0.20e2 * t245 * t67
  t254 = f.my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t74 * t250)
  t258 = t43 * t227
  t260 = t53 * t59
  t272 = 0.1e1 / t34 / t131
  t283 = t167 * t231 / 0.144e3
  t300 = t99 * t240 * t31 * t46
  t305 = t258 * t94 * t96 * t260 / 0.288e3 - t138 * t77 * t234 * t97 / 0.108e3 - 0.3e1 / 0.2e1 * t40 * (-t226 * t82 / 0.108e3 - t29 * t31 * t272 * t85 * t87 / 0.648e3 - t157 * t158 * t29 * t31 * t272 / 0.648e3 + t283 - t89 * t230 * t78 / 0.108e3) * t97 * t102 - t235 * t182 / 0.3e1 - t235 * t186 / 0.3e1 - 0.2e1 * t236 * t190 + 0.3e1 / 0.4e1 * t98 * t300 + t58 * t241 * t105
  t308 = t245 * t112
  t324 = f.my_piecewise3(t2, 0, t7 * t23 * t250 / 0.10e2 + 0.3e1 / 0.20e2 * t7 * t74 * (0.40e2 * t206 * t247 * t114 + 0.20e2 * t113 * t305 - 0.20e2 * t308 * t114 - 0.20e2 * t201 * t247 + 0.20e2 * t305 * t67))
  v2rhosigma_0_ = 0.2e1 * r0 * t324 + 0.2e1 * t254
  t337 = 0.1e1 / s0
  t339 = t31 * t36
  t364 = s0 ** 2
  t371 = t258 * t234 * t96 * t260 / 0.144e3 - t221 * t222 * t240 / 0.288e3 - 0.3e1 / 0.2e1 * t40 * (-t43 * t240 * t228 / 0.288e3 + t29 * t337 * t339 * t151 / 0.1728e4 + t160 * t28 * t337 * t339 / 0.1728e4 + t283 - t89 * t42 * t240 * t227 / 0.288e3) * t97 * t102 + t235 * t180 * t337 / 0.8e1 + t235 * t185 * t337 / 0.8e1 + 0.3e1 / 0.2e1 * t236 * t300 - 0.9e1 / 0.8e1 * t58 * t26 / t44 / t364 * t61
  t376 = t247 ** 2
  t386 = f.my_piecewise3(t2, 0, 0.3e1 / 0.20e2 * t7 * t74 * (0.20e2 * t113 * t371 + 0.40e2 * t206 * t376 - 0.40e2 * t308 * t247 + 0.20e2 * t371 * t67))
  v2sigma2_0_ = 0.2e1 * r0 * t386
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = t4 * t5 * jnp.pi
  t8 = 0.1e1 <= f.p.zeta_threshold
  t9 = f.p.zeta_threshold - 0.1e1
  t11 = f.my_piecewise5(t8, t9, t8, -t9, 0)
  t12 = 0.1e1 + t11
  t14 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = t12 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t20 = f.my_piecewise3(t12 <= f.p.zeta_threshold, t15 * f.p.zeta_threshold, t18 * t12)
  t21 = r0 ** (0.1e1 / 0.3e1)
  t22 = t21 * r0
  t23 = 0.1e1 / t22
  t24 = t20 * t23
  t25 = 6 ** (0.1e1 / 0.3e1)
  t26 = jnp.pi ** 2
  t27 = t26 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t29 = 0.1e1 / t28
  t30 = t25 * t29
  t31 = 2 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t33 = s0 * t32
  t34 = r0 ** 2
  t35 = t21 ** 2
  t41 = 0.1e1 - t30 * t33 / t35 / t34 / 0.864e3
  t42 = t25 ** 2
  t43 = 0.1e1 / t27
  t44 = t42 * t43
  t45 = jnp.sqrt(s0)
  t46 = t45 * t31
  t49 = t44 * t46 * t23 / 0.72e2
  t50 = 0.1e1 + t49
  t51 = 0.1e1 - t49
  t52 = abs(t51)
  t53 = 0.1e1 / t52
  t55 = jnp.log(t50 * t53)
  t57 = t41 * t55 * t25
  t58 = 0.1e1 / t45
  t59 = t27 * t58
  t63 = 0.3e1 / 0.2e1 * t57 * t59 * t32 * t22
  t64 = 0.1e1 / 0.2e1 - t63
  t65 = 0.1e1 / 0.2e1 + t63
  t66 = 0.1e1 / t65
  t69 = 0.20e2 * t64 * t66 + 0.1e1
  t74 = t20 / t21
  t75 = t44 * t45
  t77 = 0.1e1 / t21 / t34
  t78 = t31 * t77
  t84 = t52 ** 2
  t85 = 0.1e1 / t84
  t86 = t50 * t85
  t87 = abs(1, t51)
  t89 = t86 * t87 * t42
  t90 = t43 * t45
  t91 = t90 * t78
  t94 = -t75 * t78 * t53 / 0.54e2 - t89 * t91 / 0.54e2
  t95 = t41 * t94
  t96 = 0.1e1 / t50
  t97 = t96 * t52
  t98 = t95 * t97
  t99 = t25 * t27
  t100 = t58 * t32
  t102 = t99 * t100 * t22
  t109 = -t75 * t78 * t55 / 0.108e3 - 0.3e1 / 0.2e1 * t98 * t102 - 0.2e1 * t57 * t59 * t32 * t21
  t111 = t65 ** 2
  t112 = 0.1e1 / t111
  t113 = t64 * t112
  t114 = -t109
  t117 = 0.20e2 * t109 * t66 - 0.20e2 * t113 * t114
  t121 = t20 * t35
  t122 = t34 * r0
  t124 = 0.1e1 / t21 / t122
  t125 = t31 * t124
  t129 = t44 * t46
  t137 = t30 * s0
  t138 = t34 ** 2
  t140 = 0.1e1 / t35 / t138
  t141 = t32 * t140
  t142 = t85 * t87
  t147 = 0.1e1 / t84 / t52
  t148 = t50 * t147
  t149 = t87 ** 2
  t151 = t148 * t149 * t25
  t152 = t29 * s0
  t156 = signum(1, t51)
  t158 = t86 * t156 * t42
  t160 = t158 * t91 / 0.54e2
  t161 = t90 * t125
  t164 = 0.7e1 / 0.162e3 * t75 * t125 * t53 + t137 * t141 * t142 / 0.243e3 + t151 * t152 * t141 / 0.243e3 - t160 + 0.7e1 / 0.162e3 * t89 * t161
  t165 = t41 * t164
  t166 = t165 * t97
  t169 = t50 ** 2
  t170 = 0.1e1 / t169
  t171 = t170 * t52
  t172 = 0.1e1 / r0
  t173 = t171 * t172
  t176 = t96 * t87
  t177 = t176 * t172
  t181 = t99 * t100 * t21
  t184 = 0.1e1 / t35
  t189 = t75 * t125 * t55 / 0.108e3 - t129 * t77 * t94 * t97 / 0.54e2 - 0.3e1 / 0.2e1 * t166 * t102 - t95 * t173 / 0.3e1 - t95 * t177 / 0.3e1 - 0.4e1 * t98 * t181 - 0.2e1 / 0.3e1 * t57 * t59 * t32 * t184
  t192 = t109 * t112
  t196 = 0.1e1 / t111 / t65
  t197 = t64 * t196
  t198 = t114 ** 2
  t201 = -t189
  t204 = -0.20e2 * t113 * t201 - 0.40e2 * t192 * t114 + 0.20e2 * t189 * t66 + 0.40e2 * t197 * t198
  t209 = f.my_piecewise3(t2, 0, -t7 * t24 * t69 / 0.30e2 + t7 * t74 * t117 / 0.5e1 + 0.3e1 / 0.20e2 * t7 * t121 * t204)
  t227 = t30 * t33
  t228 = t140 * t94
  t263 = t124 * t42 * t90 * t31
  t272 = t31 / t21 / t138
  t279 = t32 / t35 / t138 / r0
  t285 = 0.1e1 / t26 * t45 * s0
  t287 = 0.1e1 / t138 / t122
  t296 = t84 ** 2
  t326 = 0.1e1 / t34
  t333 = 0.4e1 / 0.9e1 * t57 * t59 * t32 / t35 / r0 - t227 * t228 * t171 / 0.324e3 - t227 * t228 * t176 / 0.324e3 + t129 * t124 * t94 * t97 / 0.36e2 - t129 * t77 * t164 * t97 / 0.36e2 - 0.2e1 / 0.3e1 * t165 * t173 - 0.2e1 / 0.3e1 * t165 * t177 - t95 * t96 * t156 * t172 / 0.3e1 - 0.2e1 * t98 * t99 * t100 * t184 - 0.6e1 * t166 * t181 - t95 / t169 / t50 * t52 * t263 / 0.81e2 - t95 * t170 * t87 * t263 / 0.81e2 - 0.3e1 / 0.2e1 * t41 * (-0.35e2 / 0.243e3 * t75 * t272 * t53 - 0.7e1 / 0.243e3 * t137 * t279 * t142 - 0.2e1 / 0.729e3 * t285 * t287 * t147 * t149 + t137 * t141 * t85 * t156 / 0.162e3 - 0.2e1 / 0.729e3 * t50 / t296 * t149 * t87 * t285 * t287 + t148 * t87 * t25 * t152 * t141 * t156 / 0.81e2 - 0.7e1 / 0.243e3 * t151 * t152 * t279 - t160 + 0.7e1 / 0.81e2 * t158 * t161 - 0.35e2 / 0.243e3 * t89 * t90 * t272) * t97 * t102 - 0.17e2 / 0.486e3 * t75 * t272 * t55 - 0.5e1 / 0.9e1 * t95 * t171 * t326 - 0.5e1 / 0.9e1 * t95 * t176 * t326
  t344 = t111 ** 2
  t361 = f.my_piecewise3(t2, 0, 0.2e1 / 0.45e2 * t7 * t20 * t77 * t69 - t7 * t24 * t117 / 0.10e2 + 0.3e1 / 0.10e2 * t7 * t74 * t204 + 0.3e1 / 0.20e2 * t7 * t121 * (0.20e2 * t333 * t66 - 0.60e2 * t189 * t112 * t114 + 0.120e3 * t109 * t196 * t198 - 0.60e2 * t192 * t201 - 0.120e3 * t64 / t344 * t198 * t114 + 0.120e3 * t197 * t114 * t201 + 0.20e2 * t113 * t333))
  v3rho3_0_ = 0.2e1 * r0 * t361 + 0.6e1 * t209

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = t4 * t5 * jnp.pi
  t8 = 0.1e1 <= f.p.zeta_threshold
  t9 = f.p.zeta_threshold - 0.1e1
  t11 = f.my_piecewise5(t8, t9, t8, -t9, 0)
  t12 = 0.1e1 + t11
  t14 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = t12 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t20 = f.my_piecewise3(t12 <= f.p.zeta_threshold, t15 * f.p.zeta_threshold, t18 * t12)
  t21 = r0 ** 2
  t22 = r0 ** (0.1e1 / 0.3e1)
  t24 = 0.1e1 / t22 / t21
  t25 = t20 * t24
  t26 = 6 ** (0.1e1 / 0.3e1)
  t27 = jnp.pi ** 2
  t28 = t27 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = 0.1e1 / t29
  t31 = t26 * t30
  t32 = 2 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t34 = s0 * t33
  t35 = t22 ** 2
  t37 = 0.1e1 / t35 / t21
  t41 = 0.1e1 - t31 * t34 * t37 / 0.864e3
  t42 = t26 ** 2
  t43 = 0.1e1 / t28
  t44 = t42 * t43
  t45 = jnp.sqrt(s0)
  t46 = t45 * t32
  t47 = t22 * r0
  t48 = 0.1e1 / t47
  t51 = t44 * t46 * t48 / 0.72e2
  t52 = 0.1e1 + t51
  t53 = 0.1e1 - t51
  t54 = abs(t53)
  t55 = 0.1e1 / t54
  t57 = jnp.log(t52 * t55)
  t59 = t41 * t57 * t26
  t60 = 0.1e1 / t45
  t61 = t28 * t60
  t65 = 0.3e1 / 0.2e1 * t59 * t61 * t33 * t47
  t66 = 0.1e1 / 0.2e1 - t65
  t67 = 0.1e1 / 0.2e1 + t65
  t68 = 0.1e1 / t67
  t71 = 0.20e2 * t66 * t68 + 0.1e1
  t75 = t20 * t48
  t76 = t44 * t45
  t77 = t32 * t24
  t83 = t54 ** 2
  t84 = 0.1e1 / t83
  t85 = t52 * t84
  t86 = abs(1, t53)
  t88 = t85 * t86 * t42
  t89 = t43 * t45
  t90 = t89 * t77
  t93 = -t76 * t77 * t55 / 0.54e2 - t88 * t90 / 0.54e2
  t94 = t41 * t93
  t95 = 0.1e1 / t52
  t96 = t95 * t54
  t97 = t94 * t96
  t98 = t26 * t28
  t99 = t60 * t33
  t101 = t98 * t99 * t47
  t108 = -t76 * t77 * t57 / 0.108e3 - 0.3e1 / 0.2e1 * t97 * t101 - 0.2e1 * t59 * t61 * t33 * t22
  t110 = t67 ** 2
  t111 = 0.1e1 / t110
  t112 = t66 * t111
  t113 = -t108
  t116 = 0.20e2 * t108 * t68 - 0.20e2 * t112 * t113
  t121 = t20 / t22
  t122 = t21 * r0
  t124 = 0.1e1 / t22 / t122
  t125 = t32 * t124
  t129 = t44 * t46
  t137 = t31 * s0
  t138 = t21 ** 2
  t140 = 0.1e1 / t35 / t138
  t141 = t33 * t140
  t142 = t84 * t86
  t147 = 0.1e1 / t83 / t54
  t148 = t52 * t147
  t149 = t86 ** 2
  t151 = t148 * t149 * t26
  t152 = t30 * s0
  t153 = t152 * t141
  t156 = signum(1, t53)
  t158 = t85 * t156 * t42
  t160 = t158 * t90 / 0.54e2
  t161 = t89 * t125
  t164 = 0.7e1 / 0.162e3 * t76 * t125 * t55 + t137 * t141 * t142 / 0.243e3 + t151 * t153 / 0.243e3 - t160 + 0.7e1 / 0.162e3 * t88 * t161
  t165 = t41 * t164
  t166 = t165 * t96
  t169 = t52 ** 2
  t170 = 0.1e1 / t169
  t171 = t170 * t54
  t172 = 0.1e1 / r0
  t173 = t171 * t172
  t176 = t95 * t86
  t177 = t176 * t172
  t181 = t98 * t99 * t22
  t184 = 0.1e1 / t35
  t189 = t76 * t125 * t57 / 0.108e3 - t129 * t24 * t93 * t96 / 0.54e2 - 0.3e1 / 0.2e1 * t166 * t101 - t94 * t173 / 0.3e1 - t94 * t177 / 0.3e1 - 0.4e1 * t97 * t181 - 0.2e1 / 0.3e1 * t59 * t61 * t33 * t184
  t192 = t108 * t111
  t196 = 0.1e1 / t110 / t67
  t197 = t66 * t196
  t198 = t113 ** 2
  t201 = -t189
  t204 = -0.20e2 * t112 * t201 - 0.40e2 * t192 * t113 + 0.20e2 * t189 * t68 + 0.40e2 * t197 * t198
  t208 = t20 * t35
  t210 = 0.1e1 / t35 / r0
  t223 = t31 * t34
  t224 = t140 * t93
  t235 = t95 * t156
  t236 = t235 * t172
  t238 = t94 * t236 / 0.3e1
  t240 = t98 * t99 * t184
  t246 = 0.1e1 / t169 / t52
  t247 = t246 * t54
  t248 = t94 * t247
  t251 = t124 * t42 * t89 * t32
  t254 = t170 * t86
  t255 = t94 * t254
  t259 = 0.1e1 / t22 / t138
  t260 = t32 * t259
  t264 = t138 * r0
  t266 = 0.1e1 / t35 / t264
  t267 = t33 * t266
  t271 = 0.1e1 / t27
  t273 = t271 * t45 * s0
  t275 = 0.1e1 / t138 / t122
  t280 = t84 * t156
  t282 = t137 * t141 * t280
  t284 = t83 ** 2
  t285 = 0.1e1 / t284
  t286 = t52 * t285
  t287 = t149 * t86
  t288 = t286 * t287
  t289 = t273 * t275
  t293 = t148 * t86 * t26
  t296 = t293 * t152 * t141 * t156
  t301 = t158 * t161
  t303 = t89 * t260
  t306 = -0.35e2 / 0.243e3 * t76 * t260 * t55 - 0.7e1 / 0.243e3 * t137 * t267 * t142 - 0.2e1 / 0.729e3 * t273 * t275 * t147 * t149 + t282 / 0.162e3 - 0.2e1 / 0.729e3 * t288 * t289 + t296 / 0.81e2 - 0.7e1 / 0.243e3 * t151 * t152 * t267 - t160 + 0.7e1 / 0.81e2 * t301 - 0.35e2 / 0.243e3 * t88 * t303
  t307 = t41 * t306
  t308 = t307 * t96
  t314 = 0.1e1 / t21
  t315 = t171 * t314
  t318 = t176 * t314
  t321 = 0.4e1 / 0.9e1 * t59 * t61 * t33 * t210 + t129 * t124 * t93 * t96 / 0.36e2 - t129 * t24 * t164 * t96 / 0.36e2 - t223 * t224 * t171 / 0.324e3 - t223 * t224 * t176 / 0.324e3 - 0.2e1 / 0.3e1 * t165 * t173 - 0.2e1 / 0.3e1 * t165 * t177 - t238 - 0.2e1 * t97 * t240 - 0.6e1 * t166 * t181 - t248 * t251 / 0.81e2 - t255 * t251 / 0.81e2 - 0.3e1 / 0.2e1 * t308 * t101 - 0.17e2 / 0.486e3 * t76 * t260 * t57 - 0.5e1 / 0.9e1 * t94 * t315 - 0.5e1 / 0.9e1 * t94 * t318
  t324 = t189 * t111
  t327 = t108 * t196
  t332 = t110 ** 2
  t333 = 0.1e1 / t332
  t334 = t66 * t333
  t335 = t198 * t113
  t338 = t113 * t201
  t341 = -t321
  t344 = -0.20e2 * t112 * t341 - 0.60e2 * t324 * t113 - 0.60e2 * t192 * t201 + 0.120e3 * t197 * t338 + 0.120e3 * t327 * t198 + 0.20e2 * t321 * t68 - 0.120e3 * t334 * t335
  t349 = f.my_piecewise3(t2, 0, 0.2e1 / 0.45e2 * t7 * t25 * t71 - t7 * t75 * t116 / 0.10e2 + 0.3e1 / 0.10e2 * t7 * t121 * t204 + 0.3e1 / 0.20e2 * t7 * t208 * t344)
  t378 = 0.1e1 / t122
  t387 = t32 / t22 / t264
  t399 = t140 * t164
  t413 = -0.20e2 / 0.27e2 * t59 * t61 * t33 * t37 - t307 * t177 - 0.11e2 / 0.9e1 * t165 * t318 - 0.2e1 / 0.9e1 * t94 * t235 * t314 - t307 * t173 - 0.11e2 / 0.9e1 * t165 * t315 - t165 * t236 + 0.2e1 / 0.3e1 * t94 * t171 * t378 + 0.2e1 / 0.3e1 * t94 * t176 * t378 + 0.25e2 / 0.162e3 * t76 * t387 * t57 - 0.4e1 / 0.2187e4 * t289 * t93 * t246 * t54 - 0.4e1 / 0.2187e4 * t289 * t93 * t170 * t86 - 0.2e1 / 0.243e3 * t223 * t399 * t171 - 0.2e1 / 0.243e3 * t223 * t399 * t176 - t223 * t224 * t235 / 0.243e3 - 0.34e2 / 0.243e3 * t129 * t259 * t93 * t96
  t418 = t266 * t93
  t429 = t169 ** 2
  t435 = t266 * t26 * t152 * t33
  t464 = t33 / t35 / t138 / t21
  t476 = t138 ** 2
  t477 = 0.1e1 / t476
  t481 = s0 ** 2
  t485 = 0.1e1 / t22 / t476 / r0
  t496 = t149 ** 2
  t504 = t156 ** 2
  t516 = -0.8e1 / 0.729e3 * t289 * t147 * t86 * t156 + 0.7e1 / 0.54e2 * t301 - t160 - 0.98e2 / 0.729e3 * t293 * t152 * t267 * t156 + 0.4e1 / 0.243e3 * t296 - 0.35e2 / 0.81e2 * t158 * t303 + 0.455e3 / 0.729e3 * t88 * t89 * t387 + 0.2e1 / 0.243e3 * t282 + 0.455e3 / 0.729e3 * t76 * t387 * t55 + 0.427e3 / 0.2187e4 * t137 * t464 * t142 - 0.49e2 / 0.729e3 * t137 * t267 * t280 - 0.4e1 / 0.243e3 * t286 * t149 * t273 * t275 * t156 + 0.28e2 / 0.729e3 * t288 * t273 * t477 + 0.4e1 / 0.19683e5 * t271 * t481 * t485 * t285 * t287 * t42 * t43 * t32 + 0.4e1 / 0.19683e5 * t52 / t284 / t54 * t496 * t271 * t481 * t485 * t44 * t32 + t148 * t504 * t26 * t153 / 0.81e2 + 0.427e3 / 0.2187e4 * t151 * t152 * t464 + 0.28e2 / 0.729e3 * t273 * t477 * t147 * t149
  t526 = t44 * t46 * t259
  t545 = t129 * t124 * t164 * t96 / 0.18e2 + 0.23e2 / 0.1458e4 * t223 * t418 * t171 + 0.23e2 / 0.1458e4 * t223 * t418 * t176 - t129 * t24 * t306 * t96 / 0.27e2 - t238 - t94 / t429 * t54 * t435 / 0.243e3 - t94 * t246 * t86 * t435 / 0.243e3 - 0.3e1 / 0.2e1 * t41 * t516 * t96 * t101 + 0.16e2 / 0.9e1 * t97 * t98 * t99 * t210 + 0.5e1 / 0.243e3 * t255 * t526 + 0.5e1 / 0.243e3 * t248 * t526 - t165 * t247 * t251 / 0.27e2 - t165 * t254 * t251 / 0.27e2 - t94 * t170 * t156 * t251 / 0.54e2 - 0.4e1 * t166 * t240 - 0.8e1 * t308 * t181
  t546 = t413 + t545
  t567 = t198 ** 2
  t573 = t201 ** 2
  t582 = 0.20e2 * t546 * t68 - 0.80e2 * t321 * t111 * t113 + 0.240e3 * t189 * t196 * t198 - 0.120e3 * t324 * t201 - 0.480e3 * t108 * t333 * t335 + 0.480e3 * t327 * t338 - 0.80e2 * t192 * t341 + 0.480e3 * t66 / t332 / t67 * t567 - 0.720e3 * t334 * t198 * t201 + 0.120e3 * t197 * t573 + 0.160e3 * t197 * t113 * t341 + 0.20e2 * t112 * t546
  t587 = f.my_piecewise3(t2, 0, -0.14e2 / 0.135e3 * t7 * t20 * t124 * t71 + 0.8e1 / 0.45e2 * t7 * t25 * t116 - t7 * t75 * t204 / 0.5e1 + 0.2e1 / 0.5e1 * t7 * t121 * t344 + 0.3e1 / 0.20e2 * t7 * t208 * t582)
  v4rho4_0_ = 0.2e1 * r0 * t587 + 0.8e1 * t349

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 * t4 * jnp.pi
  t7 = r0 + r1
  t8 = 0.1e1 / t7
  t11 = 0.2e1 * r0 * t8 <= f.p.zeta_threshold
  t12 = f.p.zeta_threshold - 0.1e1
  t15 = 0.2e1 * r1 * t8 <= f.p.zeta_threshold
  t16 = -t12
  t17 = r0 - r1
  t18 = t17 * t8
  t19 = f.my_piecewise5(t11, t12, t15, t16, t18)
  t20 = 0.1e1 + t19
  t21 = t20 <= f.p.zeta_threshold
  t22 = t20 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = t7 ** 2
  t25 = 0.1e1 / t24
  t26 = t17 * t25
  t27 = t8 - t26
  t28 = f.my_piecewise5(t11, 0, t15, 0, t27)
  t31 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t23 * t28)
  t32 = t7 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t34 = t31 * t33
  t35 = 6 ** (0.1e1 / 0.3e1)
  t36 = jnp.pi ** 2
  t37 = t36 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t40 = t35 / t38
  t41 = r0 ** 2
  t42 = r0 ** (0.1e1 / 0.3e1)
  t43 = t42 ** 2
  t49 = 0.1e1 - t40 * s0 / t43 / t41 / 0.864e3
  t50 = t35 ** 2
  t52 = t50 / t37
  t53 = jnp.sqrt(s0)
  t54 = t42 * r0
  t58 = t52 * t53 / t54 / 0.72e2
  t59 = 0.1e1 + t58
  t60 = 0.1e1 - t58
  t61 = abs(t60)
  t62 = 0.1e1 / t61
  t64 = jnp.log(t59 * t62)
  t66 = t49 * t64 * t35
  t67 = 0.1e1 / t53
  t68 = t37 * t67
  t71 = 0.3e1 * t66 * t68 * t54
  t72 = 0.1e1 / 0.2e1 - t71
  t73 = 0.1e1 / 0.2e1 + t71
  t74 = 0.1e1 / t73
  t77 = 0.20e2 * t72 * t74 + 0.1e1
  t81 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t82 = t81 ** 2
  t83 = t82 * f.p.zeta_threshold
  t85 = f.my_piecewise3(t21, t83, t23 * t20)
  t86 = 0.1e1 / t32
  t87 = t85 * t86
  t90 = t6 * t87 * t77 / 0.10e2
  t91 = t85 * t33
  t93 = 0.1e1 / t42 / t41
  t94 = t53 * t93
  t100 = t61 ** 2
  t101 = 0.1e1 / t100
  t102 = t59 * t101
  t103 = jnp.abs(1 - t60)
  t104 = t102 * t103
  t105 = t52 * t94
  t108 = -t52 * t94 * t62 / 0.54e2 - t104 * t105 / 0.54e2
  t109 = t49 * t108
  t110 = 0.1e1 / t59
  t111 = t110 * t61
  t112 = t109 * t111
  t113 = t35 * t37
  t115 = t113 * t67 * t54
  t121 = -t52 * t94 * t64 / 0.108e3 - 0.3e1 * t112 * t115 - 0.4e1 * t66 * t68 * t42
  t123 = t73 ** 2
  t124 = 0.1e1 / t123
  t125 = t72 * t124
  t126 = -t121
  t129 = 0.20e2 * t121 * t74 - 0.20e2 * t125 * t126
  t134 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t34 * t77 + t90 + 0.3e1 / 0.20e2 * t6 * t91 * t129)
  t136 = r1 <= f.p.dens_threshold
  t137 = f.my_piecewise5(t15, t12, t11, t16, -t18)
  t138 = 0.1e1 + t137
  t139 = t138 <= f.p.zeta_threshold
  t140 = t138 ** (0.1e1 / 0.3e1)
  t141 = t140 ** 2
  t143 = f.my_piecewise5(t15, 0, t11, 0, -t27)
  t146 = f.my_piecewise3(t139, 0, 0.5e1 / 0.3e1 * t141 * t143)
  t147 = t146 * t33
  t148 = r1 ** 2
  t149 = r1 ** (0.1e1 / 0.3e1)
  t150 = t149 ** 2
  t156 = 0.1e1 - t40 * s2 / t150 / t148 / 0.864e3
  t157 = jnp.sqrt(s2)
  t158 = t149 * r1
  t162 = t52 * t157 / t158 / 0.72e2
  t163 = 0.1e1 + t162
  t164 = 0.1e1 - t162
  t165 = abs(t164)
  t166 = 0.1e1 / t165
  t168 = jnp.log(t163 * t166)
  t170 = t156 * t168 * t35
  t171 = 0.1e1 / t157
  t172 = t37 * t171
  t175 = 0.3e1 * t170 * t172 * t158
  t176 = 0.1e1 / 0.2e1 - t175
  t177 = 0.1e1 / 0.2e1 + t175
  t178 = 0.1e1 / t177
  t181 = 0.20e2 * t176 * t178 + 0.1e1
  t186 = f.my_piecewise3(t139, t83, t141 * t138)
  t187 = t186 * t86
  t190 = t6 * t187 * t181 / 0.10e2
  t192 = f.my_piecewise3(t136, 0, 0.3e1 / 0.20e2 * t6 * t147 * t181 + t190)
  t194 = 0.1e1 / t22
  t195 = t28 ** 2
  t200 = t17 / t24 / t7
  t202 = -0.2e1 * t25 + 0.2e1 * t200
  t203 = f.my_piecewise5(t11, 0, t15, 0, t202)
  t207 = f.my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t194 * t195 + 0.5e1 / 0.3e1 * t23 * t203)
  t214 = t6 * t31 * t86 * t77
  t220 = 0.1e1 / t32 / t7
  t224 = t6 * t85 * t220 * t77 / 0.30e2
  t226 = t6 * t87 * t129
  t231 = t53 / t42 / t41 / r0
  t244 = t41 ** 2
  t246 = 0.1e1 / t43 / t244
  t254 = t103 ** 2
  t260 = signum(1, t60)
  t272 = t59 ** 2
  t275 = 0.1e1 / r0
  t291 = t52 * t231 * t64 / 0.108e3 - t52 * t53 * t93 * t108 * t111 / 0.54e2 - 0.3e1 * t49 * (0.7e1 / 0.162e3 * t52 * t231 * t62 + t40 * s0 * t246 * t101 * t103 / 0.243e3 + t59 / t100 / t61 * t254 * t40 * s0 * t246 / 0.243e3 - t102 * t260 * t105 / 0.54e2 + 0.7e1 / 0.162e3 * t104 * t52 * t231) * t111 * t115 - t109 / t272 * t61 * t275 / 0.3e1 - t109 * t110 * t103 * t275 / 0.3e1 - 0.8e1 * t112 * t113 * t67 * t42 - 0.4e1 / 0.3e1 * t66 * t68 / t43
  t300 = t126 ** 2
  t311 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t207 * t33 * t77 + t214 / 0.5e1 + 0.3e1 / 0.10e2 * t6 * t34 * t129 - t224 + t226 / 0.5e1 + 0.3e1 / 0.20e2 * t6 * t91 * (0.20e2 * t291 * t74 - 0.40e2 * t121 * t124 * t126 + 0.40e2 * t72 / t123 / t73 * t300 + 0.20e2 * t125 * t291))
  t312 = 0.1e1 / t140
  t313 = t143 ** 2
  t317 = f.my_piecewise5(t15, 0, t11, 0, -t202)
  t321 = f.my_piecewise3(t139, 0, 0.10e2 / 0.9e1 * t312 * t313 + 0.5e1 / 0.3e1 * t141 * t317)
  t328 = t6 * t146 * t86 * t181
  t333 = t6 * t186 * t220 * t181 / 0.30e2
  t335 = f.my_piecewise3(t136, 0, 0.3e1 / 0.20e2 * t6 * t321 * t33 * t181 + t328 / 0.5e1 - t333)
  d11 = 0.2e1 * t134 + 0.2e1 * t192 + t7 * (t311 + t335)
  t338 = -t8 - t26
  t339 = f.my_piecewise5(t11, 0, t15, 0, t338)
  t342 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t23 * t339)
  t343 = t342 * t33
  t348 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t343 * t77 + t90)
  t350 = f.my_piecewise5(t15, 0, t11, 0, -t338)
  t353 = f.my_piecewise3(t139, 0, 0.5e1 / 0.3e1 * t141 * t350)
  t354 = t353 * t33
  t358 = t186 * t33
  t360 = 0.1e1 / t149 / t148
  t361 = t157 * t360
  t367 = t165 ** 2
  t368 = 0.1e1 / t367
  t369 = t163 * t368
  t370 = jnp.abs(1 - t164)
  t371 = t369 * t370
  t372 = t52 * t361
  t375 = -t52 * t361 * t166 / 0.54e2 - t371 * t372 / 0.54e2
  t376 = t156 * t375
  t377 = 0.1e1 / t163
  t378 = t377 * t165
  t379 = t376 * t378
  t381 = t113 * t171 * t158
  t387 = -t52 * t361 * t168 / 0.108e3 - 0.3e1 * t379 * t381 - 0.4e1 * t170 * t172 * t149
  t389 = t177 ** 2
  t390 = 0.1e1 / t389
  t391 = t176 * t390
  t392 = -t387
  t395 = 0.20e2 * t387 * t178 - 0.20e2 * t391 * t392
  t400 = f.my_piecewise3(t136, 0, 0.3e1 / 0.20e2 * t6 * t354 * t181 + t190 + 0.3e1 / 0.20e2 * t6 * t358 * t395)
  t404 = 0.2e1 * t200
  t405 = f.my_piecewise5(t11, 0, t15, 0, t404)
  t409 = f.my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t194 * t339 * t28 + 0.5e1 / 0.3e1 * t23 * t405)
  t416 = t6 * t342 * t86 * t77
  t424 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t409 * t33 * t77 + t416 / 0.10e2 + 0.3e1 / 0.20e2 * t6 * t343 * t129 + t214 / 0.10e2 - t224 + t226 / 0.10e2)
  t428 = f.my_piecewise5(t15, 0, t11, 0, -t404)
  t432 = f.my_piecewise3(t139, 0, 0.10e2 / 0.9e1 * t312 * t350 * t143 + 0.5e1 / 0.3e1 * t141 * t428)
  t439 = t6 * t353 * t86 * t181
  t446 = t6 * t187 * t395
  t449 = f.my_piecewise3(t136, 0, 0.3e1 / 0.20e2 * t6 * t432 * t33 * t181 + t439 / 0.10e2 + t328 / 0.10e2 - t333 + 0.3e1 / 0.20e2 * t6 * t147 * t395 + t446 / 0.10e2)
  d12 = t134 + t192 + t348 + t400 + t7 * (t424 + t449)
  t454 = t339 ** 2
  t458 = 0.2e1 * t25 + 0.2e1 * t200
  t459 = f.my_piecewise5(t11, 0, t15, 0, t458)
  t463 = f.my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t194 * t454 + 0.5e1 / 0.3e1 * t23 * t459)
  t470 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t463 * t33 * t77 + t416 / 0.5e1 - t224)
  t471 = t350 ** 2
  t475 = f.my_piecewise5(t15, 0, t11, 0, -t458)
  t479 = f.my_piecewise3(t139, 0, 0.10e2 / 0.9e1 * t312 * t471 + 0.5e1 / 0.3e1 * t141 * t475)
  t492 = t157 / t149 / t148 / r1
  t505 = t148 ** 2
  t507 = 0.1e1 / t150 / t505
  t515 = t370 ** 2
  t521 = signum(1, t164)
  t533 = t163 ** 2
  t536 = 0.1e1 / r1
  t552 = t52 * t492 * t168 / 0.108e3 - t52 * t157 * t360 * t375 * t378 / 0.54e2 - 0.3e1 * t156 * (0.7e1 / 0.162e3 * t52 * t492 * t166 + t40 * s2 * t507 * t368 * t370 / 0.243e3 + t163 / t367 / t165 * t515 * t40 * s2 * t507 / 0.243e3 - t369 * t521 * t372 / 0.54e2 + 0.7e1 / 0.162e3 * t371 * t52 * t492) * t378 * t381 - t376 / t533 * t165 * t536 / 0.3e1 - t376 * t377 * t370 * t536 / 0.3e1 - 0.8e1 * t379 * t113 * t171 * t149 - 0.4e1 / 0.3e1 * t170 * t172 / t150
  t561 = t392 ** 2
  t572 = f.my_piecewise3(t136, 0, 0.3e1 / 0.20e2 * t6 * t479 * t33 * t181 + t439 / 0.5e1 + 0.3e1 / 0.10e2 * t6 * t354 * t395 - t333 + t446 / 0.5e1 + 0.3e1 / 0.20e2 * t6 * t358 * (0.20e2 * t552 * t178 - 0.40e2 * t387 * t390 * t392 + 0.40e2 * t176 / t389 / t177 * t561 + 0.20e2 * t391 * t552))
  d22 = 0.2e1 * t348 + 0.2e1 * t400 + t7 * (t470 + t572)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 * t4 * jnp.pi
  t7 = r0 + r1
  t8 = 0.1e1 / t7
  t11 = 0.2e1 * r0 * t8 <= f.p.zeta_threshold
  t12 = f.p.zeta_threshold - 0.1e1
  t15 = 0.2e1 * r1 * t8 <= f.p.zeta_threshold
  t16 = -t12
  t17 = r0 - r1
  t18 = t17 * t8
  t19 = f.my_piecewise5(t11, t12, t15, t16, t18)
  t20 = 0.1e1 + t19
  t21 = t20 <= f.p.zeta_threshold
  t22 = t20 ** (0.1e1 / 0.3e1)
  t23 = 0.1e1 / t22
  t24 = t7 ** 2
  t25 = 0.1e1 / t24
  t27 = -t17 * t25 + t8
  t28 = f.my_piecewise5(t11, 0, t15, 0, t27)
  t29 = t28 ** 2
  t32 = t22 ** 2
  t34 = 0.1e1 / t24 / t7
  t37 = 0.2e1 * t17 * t34 - 0.2e1 * t25
  t38 = f.my_piecewise5(t11, 0, t15, 0, t37)
  t42 = f.my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t23 * t29 + 0.5e1 / 0.3e1 * t32 * t38)
  t43 = t7 ** (0.1e1 / 0.3e1)
  t44 = t43 ** 2
  t45 = t42 * t44
  t46 = 6 ** (0.1e1 / 0.3e1)
  t47 = jnp.pi ** 2
  t48 = t47 ** (0.1e1 / 0.3e1)
  t49 = t48 ** 2
  t50 = 0.1e1 / t49
  t51 = t46 * t50
  t52 = r0 ** 2
  t53 = r0 ** (0.1e1 / 0.3e1)
  t54 = t53 ** 2
  t60 = 0.1e1 - t51 * s0 / t54 / t52 / 0.864e3
  t61 = t46 ** 2
  t63 = t61 / t48
  t64 = jnp.sqrt(s0)
  t65 = t53 * r0
  t69 = t63 * t64 / t65 / 0.72e2
  t70 = 0.1e1 + t69
  t71 = 0.1e1 - t69
  t72 = abs(t71)
  t73 = 0.1e1 / t72
  t75 = jnp.log(t70 * t73)
  t77 = t60 * t75 * t46
  t78 = 0.1e1 / t64
  t79 = t48 * t78
  t82 = 0.3e1 * t77 * t79 * t65
  t83 = 0.1e1 / 0.2e1 - t82
  t84 = 0.1e1 / 0.2e1 + t82
  t85 = 0.1e1 / t84
  t88 = 0.20e2 * t83 * t85 + 0.1e1
  t94 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t32 * t28)
  t95 = 0.1e1 / t43
  t96 = t94 * t95
  t100 = t94 * t44
  t102 = 0.1e1 / t53 / t52
  t103 = t64 * t102
  t109 = t72 ** 2
  t110 = 0.1e1 / t109
  t111 = t70 * t110
  t112 = abs(1, t71)
  t113 = t111 * t112
  t114 = t63 * t103
  t117 = -t63 * t103 * t73 / 0.54e2 - t113 * t114 / 0.54e2
  t118 = t60 * t117
  t119 = 0.1e1 / t70
  t120 = t119 * t72
  t121 = t118 * t120
  t122 = t46 * t48
  t124 = t122 * t78 * t65
  t130 = -t63 * t103 * t75 / 0.108e3 - 0.3e1 * t121 * t124 - 0.4e1 * t77 * t79 * t53
  t132 = t84 ** 2
  t133 = 0.1e1 / t132
  t134 = t83 * t133
  t135 = -t130
  t138 = 0.20e2 * t130 * t85 - 0.20e2 * t134 * t135
  t142 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t143 = t142 ** 2
  t144 = t143 * f.p.zeta_threshold
  t146 = f.my_piecewise3(t21, t144, t32 * t20)
  t148 = 0.1e1 / t43 / t7
  t149 = t146 * t148
  t153 = t146 * t95
  t157 = t146 * t44
  t158 = t52 * r0
  t160 = 0.1e1 / t53 / t158
  t161 = t64 * t160
  t165 = t63 * t64
  t173 = t51 * s0
  t174 = t52 ** 2
  t176 = 0.1e1 / t54 / t174
  t177 = t176 * t110
  t182 = 0.1e1 / t109 / t72
  t183 = t70 * t182
  t184 = t112 ** 2
  t185 = t183 * t184
  t190 = signum(1, t71)
  t191 = t111 * t190
  t193 = t191 * t114 / 0.54e2
  t194 = t63 * t161
  t197 = 0.7e1 / 0.162e3 * t63 * t161 * t73 + t173 * t177 * t112 / 0.243e3 + t185 * t51 * s0 * t176 / 0.243e3 - t193 + 0.7e1 / 0.162e3 * t113 * t194
  t198 = t60 * t197
  t199 = t198 * t120
  t202 = t70 ** 2
  t203 = 0.1e1 / t202
  t204 = t203 * t72
  t205 = 0.1e1 / r0
  t206 = t204 * t205
  t209 = t119 * t112
  t210 = t209 * t205
  t214 = t122 * t78 * t53
  t217 = 0.1e1 / t54
  t221 = t63 * t161 * t75 / 0.108e3 - t165 * t102 * t117 * t120 / 0.54e2 - 0.3e1 * t199 * t124 - t118 * t206 / 0.3e1 - t118 * t210 / 0.3e1 - 0.8e1 * t121 * t214 - 0.4e1 / 0.3e1 * t77 * t79 * t217
  t224 = t130 * t133
  t228 = 0.1e1 / t132 / t84
  t229 = t83 * t228
  t230 = t135 ** 2
  t233 = -t221
  t236 = -0.20e2 * t134 * t233 - 0.40e2 * t224 * t135 + 0.20e2 * t221 * t85 + 0.40e2 * t229 * t230
  t241 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t45 * t88 + t6 * t96 * t88 / 0.5e1 + 0.3e1 / 0.10e2 * t6 * t100 * t138 - t6 * t149 * t88 / 0.30e2 + t6 * t153 * t138 / 0.5e1 + 0.3e1 / 0.20e2 * t6 * t157 * t236)
  t243 = r1 <= f.p.dens_threshold
  t244 = f.my_piecewise5(t15, t12, t11, t16, -t18)
  t245 = 0.1e1 + t244
  t246 = t245 <= f.p.zeta_threshold
  t247 = t245 ** (0.1e1 / 0.3e1)
  t248 = 0.1e1 / t247
  t250 = f.my_piecewise5(t15, 0, t11, 0, -t27)
  t251 = t250 ** 2
  t254 = t247 ** 2
  t256 = f.my_piecewise5(t15, 0, t11, 0, -t37)
  t260 = f.my_piecewise3(t246, 0, 0.10e2 / 0.9e1 * t248 * t251 + 0.5e1 / 0.3e1 * t254 * t256)
  t262 = r1 ** 2
  t263 = r1 ** (0.1e1 / 0.3e1)
  t264 = t263 ** 2
  t271 = jnp.sqrt(s2)
  t272 = t263 * r1
  t276 = t63 * t271 / t272 / 0.72e2
  t279 = abs(0.1e1 - t276)
  t282 = jnp.log((0.1e1 + t276) / t279)
  t289 = 0.3e1 * (0.1e1 - t51 * s2 / t264 / t262 / 0.864e3) * t282 * t46 * t48 / t271 * t272
  t295 = 0.1e1 + 0.20e2 * (0.1e1 / 0.2e1 - t289) / (0.1e1 / 0.2e1 + t289)
  t301 = f.my_piecewise3(t246, 0, 0.5e1 / 0.3e1 * t254 * t250)
  t307 = f.my_piecewise3(t246, t144, t254 * t245)
  t313 = f.my_piecewise3(t243, 0, 0.3e1 / 0.20e2 * t6 * t260 * t44 * t295 + t6 * t301 * t95 * t295 / 0.5e1 - t6 * t307 * t148 * t295 / 0.30e2)
  t323 = t24 ** 2
  t327 = 0.6e1 * t34 - 0.6e1 * t17 / t323
  t328 = f.my_piecewise5(t11, 0, t15, 0, t327)
  t332 = f.my_piecewise3(t21, 0, -0.10e2 / 0.27e2 / t22 / t20 * t29 * t28 + 0.10e2 / 0.3e1 * t23 * t28 * t38 + 0.5e1 / 0.3e1 * t32 * t328)
  t355 = 0.1e1 / t43 / t24
  t378 = t64 / t53 / t174
  t384 = 0.1e1 / t54 / t174 / r0
  t391 = 0.1e1 / t47 * t64 * s0
  t393 = 0.1e1 / t174 / t158
  t401 = t109 ** 2
  t457 = t176 * t117
  t467 = 0.1e1 / t52
  t474 = -t118 / t202 / t70 * t72 * t194 / 0.81e2 - t118 * t203 * t112 * t194 / 0.81e2 - 0.3e1 * t60 * (-0.35e2 / 0.243e3 * t63 * t378 * t73 - 0.7e1 / 0.243e3 * t173 * t384 * t110 * t112 - t391 * t393 * t182 * t184 / 0.729e3 + t173 * t177 * t190 / 0.162e3 - t70 / t401 * t184 * t112 * t391 * t393 / 0.729e3 + t183 * t112 * t46 * t50 * s0 * t176 * t190 / 0.81e2 - 0.7e1 / 0.243e3 * t185 * t51 * s0 * t384 - t193 + 0.7e1 / 0.81e2 * t191 * t194 - 0.35e2 / 0.243e3 * t113 * t63 * t378) * t120 * t124 - 0.2e1 / 0.3e1 * t198 * t206 - 0.2e1 / 0.3e1 * t198 * t210 - t118 * t119 * t190 * t205 / 0.3e1 - 0.12e2 * t199 * t214 - 0.4e1 * t121 * t122 * t78 * t217 + 0.8e1 / 0.9e1 * t77 * t79 / t54 / r0 + t165 * t160 * t117 * t120 / 0.36e2 - t165 * t102 * t197 * t120 / 0.36e2 - t173 * t457 * t204 / 0.324e3 - t173 * t457 * t209 / 0.324e3 - 0.17e2 / 0.486e3 * t63 * t378 * t75 - 0.5e1 / 0.9e1 * t118 * t204 * t467 - 0.5e1 / 0.9e1 * t118 * t209 * t467
  t485 = t132 ** 2
  t502 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t332 * t44 * t88 + 0.3e1 / 0.10e2 * t6 * t42 * t95 * t88 + 0.9e1 / 0.20e2 * t6 * t45 * t138 - t6 * t94 * t148 * t88 / 0.10e2 + 0.3e1 / 0.5e1 * t6 * t96 * t138 + 0.9e1 / 0.20e2 * t6 * t100 * t236 + 0.2e1 / 0.45e2 * t6 * t146 * t355 * t88 - t6 * t149 * t138 / 0.10e2 + 0.3e1 / 0.10e2 * t6 * t153 * t236 + 0.3e1 / 0.20e2 * t6 * t157 * (0.20e2 * t474 * t85 - 0.60e2 * t221 * t133 * t135 + 0.120e3 * t130 * t228 * t230 - 0.60e2 * t224 * t233 - 0.120e3 * t83 / t485 * t230 * t135 + 0.120e3 * t229 * t135 * t233 + 0.20e2 * t134 * t474))
  t512 = f.my_piecewise5(t15, 0, t11, 0, -t327)
  t516 = f.my_piecewise3(t246, 0, -0.10e2 / 0.27e2 / t247 / t245 * t251 * t250 + 0.10e2 / 0.3e1 * t248 * t250 * t256 + 0.5e1 / 0.3e1 * t254 * t512)
  t534 = f.my_piecewise3(t243, 0, 0.3e1 / 0.20e2 * t6 * t516 * t44 * t295 + 0.3e1 / 0.10e2 * t6 * t260 * t95 * t295 - t6 * t301 * t148 * t295 / 0.10e2 + 0.2e1 / 0.45e2 * t6 * t307 * t355 * t295)
  d111 = 0.3e1 * t241 + 0.3e1 * t313 + t7 * (t502 + t534)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 * t4 * jnp.pi
  t7 = r0 + r1
  t8 = 0.1e1 / t7
  t11 = 0.2e1 * r0 * t8 <= f.p.zeta_threshold
  t12 = f.p.zeta_threshold - 0.1e1
  t15 = 0.2e1 * r1 * t8 <= f.p.zeta_threshold
  t16 = -t12
  t17 = r0 - r1
  t18 = t17 * t8
  t19 = f.my_piecewise5(t11, t12, t15, t16, t18)
  t20 = 0.1e1 + t19
  t21 = t20 <= f.p.zeta_threshold
  t22 = t20 ** (0.1e1 / 0.3e1)
  t24 = 0.1e1 / t22 / t20
  t25 = t7 ** 2
  t26 = 0.1e1 / t25
  t28 = -t17 * t26 + t8
  t29 = f.my_piecewise5(t11, 0, t15, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t7
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t17 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t11, 0, t15, 0, t40)
  t44 = t22 ** 2
  t45 = t25 ** 2
  t46 = 0.1e1 / t45
  t49 = -0.6e1 * t17 * t46 + 0.6e1 * t37
  t50 = f.my_piecewise5(t11, 0, t15, 0, t49)
  t54 = f.my_piecewise3(t21, 0, -0.10e2 / 0.27e2 * t24 * t30 * t29 + 0.10e2 / 0.3e1 * t35 * t41 + 0.5e1 / 0.3e1 * t44 * t50)
  t55 = t7 ** (0.1e1 / 0.3e1)
  t56 = t55 ** 2
  t57 = t54 * t56
  t58 = 6 ** (0.1e1 / 0.3e1)
  t59 = jnp.pi ** 2
  t60 = t59 ** (0.1e1 / 0.3e1)
  t61 = t60 ** 2
  t62 = 0.1e1 / t61
  t63 = t58 * t62
  t64 = r0 ** 2
  t65 = r0 ** (0.1e1 / 0.3e1)
  t66 = t65 ** 2
  t68 = 0.1e1 / t66 / t64
  t72 = 0.1e1 - t63 * s0 * t68 / 0.864e3
  t73 = t58 ** 2
  t75 = t73 / t60
  t76 = jnp.sqrt(s0)
  t77 = t65 * r0
  t81 = t75 * t76 / t77 / 0.72e2
  t82 = 0.1e1 + t81
  t83 = 0.1e1 - t81
  t84 = abs(t83)
  t85 = 0.1e1 / t84
  t87 = jnp.log(t82 * t85)
  t89 = t72 * t87 * t58
  t90 = 0.1e1 / t76
  t91 = t60 * t90
  t94 = 0.3e1 * t89 * t91 * t77
  t95 = 0.1e1 / 0.2e1 - t94
  t96 = 0.1e1 / 0.2e1 + t94
  t97 = 0.1e1 / t96
  t100 = 0.20e2 * t95 * t97 + 0.1e1
  t109 = f.my_piecewise3(t21, 0, 0.10e2 / 0.9e1 * t34 * t30 + 0.5e1 / 0.3e1 * t44 * t41)
  t110 = 0.1e1 / t55
  t111 = t109 * t110
  t115 = t109 * t56
  t117 = 0.1e1 / t65 / t64
  t118 = t76 * t117
  t124 = t84 ** 2
  t125 = 0.1e1 / t124
  t126 = t82 * t125
  t127 = abs(1, t83)
  t128 = t126 * t127
  t129 = t75 * t118
  t132 = -t75 * t118 * t85 / 0.54e2 - t128 * t129 / 0.54e2
  t133 = t72 * t132
  t134 = 0.1e1 / t82
  t135 = t134 * t84
  t136 = t133 * t135
  t137 = t58 * t60
  t139 = t137 * t90 * t77
  t145 = -t75 * t118 * t87 / 0.108e3 - 0.3e1 * t136 * t139 - 0.4e1 * t89 * t91 * t65
  t147 = t96 ** 2
  t148 = 0.1e1 / t147
  t149 = t95 * t148
  t150 = -t145
  t153 = 0.20e2 * t145 * t97 - 0.20e2 * t149 * t150
  t159 = f.my_piecewise3(t21, 0, 0.5e1 / 0.3e1 * t44 * t29)
  t161 = 0.1e1 / t55 / t7
  t162 = t159 * t161
  t166 = t159 * t110
  t170 = t159 * t56
  t171 = t64 * r0
  t173 = 0.1e1 / t65 / t171
  t174 = t76 * t173
  t178 = t75 * t76
  t186 = t63 * s0
  t187 = t64 ** 2
  t189 = 0.1e1 / t66 / t187
  t190 = t189 * t125
  t195 = 0.1e1 / t124 / t84
  t196 = t82 * t195
  t197 = t127 ** 2
  t198 = t196 * t197
  t200 = t63 * s0 * t189
  t203 = signum(1, t83)
  t204 = t126 * t203
  t206 = t204 * t129 / 0.54e2
  t207 = t75 * t174
  t210 = 0.7e1 / 0.162e3 * t75 * t174 * t85 + t186 * t190 * t127 / 0.243e3 + t198 * t200 / 0.243e3 - t206 + 0.7e1 / 0.162e3 * t128 * t207
  t211 = t72 * t210
  t212 = t211 * t135
  t215 = t82 ** 2
  t216 = 0.1e1 / t215
  t217 = t216 * t84
  t218 = 0.1e1 / r0
  t219 = t217 * t218
  t222 = t134 * t127
  t223 = t222 * t218
  t227 = t137 * t90 * t65
  t230 = 0.1e1 / t66
  t234 = t75 * t174 * t87 / 0.108e3 - t178 * t117 * t132 * t135 / 0.54e2 - 0.3e1 * t212 * t139 - t133 * t219 / 0.3e1 - t133 * t223 / 0.3e1 - 0.8e1 * t136 * t227 - 0.4e1 / 0.3e1 * t89 * t91 * t230
  t237 = t145 * t148
  t241 = 0.1e1 / t147 / t96
  t242 = t95 * t241
  t243 = t150 ** 2
  t246 = -t234
  t249 = -0.20e2 * t149 * t246 - 0.40e2 * t237 * t150 + 0.20e2 * t234 * t97 + 0.40e2 * t242 * t243
  t253 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t254 = t253 ** 2
  t255 = t254 * f.p.zeta_threshold
  t257 = f.my_piecewise3(t21, t255, t44 * t20)
  t259 = 0.1e1 / t55 / t25
  t260 = t257 * t259
  t264 = t257 * t161
  t268 = t257 * t110
  t272 = t257 * t56
  t274 = 0.1e1 / t215 / t82
  t275 = t274 * t84
  t276 = t133 * t275
  t279 = t216 * t127
  t280 = t133 * t279
  t284 = 0.1e1 / t65 / t187
  t285 = t76 * t284
  t289 = t187 * r0
  t291 = 0.1e1 / t66 / t289
  t292 = t291 * t125
  t296 = 0.1e1 / t59
  t298 = t296 * t76 * s0
  t300 = 0.1e1 / t187 / t171
  t306 = t186 * t190 * t203
  t308 = t124 ** 2
  t309 = 0.1e1 / t308
  t310 = t82 * t309
  t311 = t197 * t127
  t312 = t310 * t311
  t313 = t298 * t300
  t317 = t196 * t127 * t58
  t318 = t62 * s0
  t321 = t317 * t318 * t189 * t203
  t324 = t63 * s0 * t291
  t327 = t204 * t207
  t329 = t75 * t285
  t332 = -0.35e2 / 0.243e3 * t75 * t285 * t85 - 0.7e1 / 0.243e3 * t186 * t292 * t127 - t298 * t300 * t195 * t197 / 0.729e3 + t306 / 0.162e3 - t312 * t313 / 0.729e3 + t321 / 0.81e2 - 0.7e1 / 0.243e3 * t198 * t324 - t206 + 0.7e1 / 0.81e2 * t327 - 0.35e2 / 0.243e3 * t128 * t329
  t333 = t72 * t332
  t334 = t333 * t135
  t341 = t134 * t203
  t342 = t341 * t218
  t344 = t133 * t342 / 0.3e1
  t348 = t137 * t90 * t230
  t352 = 0.1e1 / t66 / r0
  t364 = t189 * t132
  t374 = 0.1e1 / t64
  t375 = t217 * t374
  t378 = t222 * t374
  t381 = -t276 * t207 / 0.81e2 - t280 * t207 / 0.81e2 - 0.3e1 * t334 * t139 - 0.2e1 / 0.3e1 * t211 * t219 - 0.2e1 / 0.3e1 * t211 * t223 - t344 - 0.12e2 * t212 * t227 - 0.4e1 * t136 * t348 + 0.8e1 / 0.9e1 * t89 * t91 * t352 + t178 * t173 * t132 * t135 / 0.36e2 - t178 * t117 * t210 * t135 / 0.36e2 - t186 * t364 * t217 / 0.324e3 - t186 * t364 * t222 / 0.324e3 - 0.17e2 / 0.486e3 * t75 * t285 * t87 - 0.5e1 / 0.9e1 * t133 * t375 - 0.5e1 / 0.9e1 * t133 * t378
  t384 = t234 * t148
  t387 = t145 * t241
  t392 = t147 ** 2
  t393 = 0.1e1 / t392
  t394 = t95 * t393
  t395 = t243 * t150
  t398 = t150 * t246
  t401 = -t381
  t404 = -0.20e2 * t149 * t401 - 0.60e2 * t384 * t150 - 0.60e2 * t237 * t246 + 0.120e3 * t242 * t398 + 0.120e3 * t387 * t243 + 0.20e2 * t381 * t97 - 0.120e3 * t394 * t395
  t409 = f.my_piecewise3(t1, 0, 0.3e1 / 0.20e2 * t6 * t57 * t100 + 0.3e1 / 0.10e2 * t6 * t111 * t100 + 0.9e1 / 0.20e2 * t6 * t115 * t153 - t6 * t162 * t100 / 0.10e2 + 0.3e1 / 0.5e1 * t6 * t166 * t153 + 0.9e1 / 0.20e2 * t6 * t170 * t249 + 0.2e1 / 0.45e2 * t6 * t260 * t100 - t6 * t264 * t153 / 0.10e2 + 0.3e1 / 0.10e2 * t6 * t268 * t249 + 0.3e1 / 0.20e2 * t6 * t272 * t404)
  t411 = r1 <= f.p.dens_threshold
  t412 = f.my_piecewise5(t15, t12, t11, t16, -t18)
  t413 = 0.1e1 + t412
  t414 = t413 <= f.p.zeta_threshold
  t415 = t413 ** (0.1e1 / 0.3e1)
  t417 = 0.1e1 / t415 / t413
  t419 = f.my_piecewise5(t15, 0, t11, 0, -t28)
  t420 = t419 ** 2
  t424 = 0.1e1 / t415
  t425 = t424 * t419
  t427 = f.my_piecewise5(t15, 0, t11, 0, -t40)
  t430 = t415 ** 2
  t432 = f.my_piecewise5(t15, 0, t11, 0, -t49)
  t436 = f.my_piecewise3(t414, 0, -0.10e2 / 0.27e2 * t417 * t420 * t419 + 0.10e2 / 0.3e1 * t425 * t427 + 0.5e1 / 0.3e1 * t430 * t432)
  t438 = r1 ** 2
  t439 = r1 ** (0.1e1 / 0.3e1)
  t440 = t439 ** 2
  t447 = jnp.sqrt(s2)
  t448 = t439 * r1
  t452 = t75 * t447 / t448 / 0.72e2
  t455 = abs(0.1e1 - t452)
  t458 = jnp.log((0.1e1 + t452) / t455)
  t465 = 0.3e1 * (0.1e1 - t63 * s2 / t440 / t438 / 0.864e3) * t458 * t58 * t60 / t447 * t448
  t471 = 0.1e1 + 0.20e2 * (0.1e1 / 0.2e1 - t465) / (0.1e1 / 0.2e1 + t465)
  t480 = f.my_piecewise3(t414, 0, 0.10e2 / 0.9e1 * t424 * t420 + 0.5e1 / 0.3e1 * t430 * t427)
  t487 = f.my_piecewise3(t414, 0, 0.5e1 / 0.3e1 * t430 * t419)
  t493 = f.my_piecewise3(t414, t255, t430 * t413)
  t499 = f.my_piecewise3(t411, 0, 0.3e1 / 0.20e2 * t6 * t436 * t56 * t471 + 0.3e1 / 0.10e2 * t6 * t480 * t110 * t471 - t6 * t487 * t161 * t471 / 0.10e2 + 0.2e1 / 0.45e2 * t6 * t493 * t259 * t471)
  t534 = t215 ** 2
  t551 = t187 ** 2
  t552 = 0.1e1 / t551
  t563 = t76 / t65 / t289
  t569 = 0.1e1 / t66 / t187 / t64
  t578 = s0 ** 2
  t582 = 0.1e1 / t65 / t551 / r0
  t599 = t197 ** 2
  t606 = t203 ** 2
  t625 = 0.14e2 / 0.729e3 * t298 * t552 * t195 * t197 - 0.4e1 / 0.729e3 * t313 * t195 * t127 * t203 + 0.455e3 / 0.729e3 * t75 * t563 * t85 + 0.427e3 / 0.2187e4 * t186 * t569 * t125 * t127 - 0.49e2 / 0.729e3 * t186 * t292 * t203 + 0.2e1 / 0.243e3 * t306 + 0.2e1 / 0.19683e5 * t296 * t578 * t582 * t309 * t311 * t75 - 0.2e1 / 0.243e3 * t310 * t197 * t298 * t300 * t203 + 0.14e2 / 0.729e3 * t312 * t298 * t552 + 0.2e1 / 0.19683e5 * t82 / t308 / t84 * t599 * t296 * t578 * t582 * t75 + t196 * t606 * t200 / 0.81e2 + 0.4e1 / 0.243e3 * t321 - 0.98e2 / 0.729e3 * t317 * t318 * t291 * t203 - t206 + 0.7e1 / 0.54e2 * t327 + 0.427e3 / 0.2187e4 * t198 * t63 * s0 * t569 - 0.35e2 / 0.81e2 * t204 * t329 + 0.455e3 / 0.729e3 * t128 * t75 * t563
  t630 = 0.1e1 / t171
  t642 = -t344 + 0.32e2 / 0.9e1 * t136 * t137 * t90 * t352 - 0.16e2 * t334 * t227 - 0.8e1 * t212 * t348 + 0.5e1 / 0.243e3 * t276 * t329 + 0.5e1 / 0.243e3 * t280 * t329 - t211 * t275 * t207 / 0.27e2 - t133 / t534 * t84 * t324 / 0.243e3 - t133 * t274 * t127 * t324 / 0.243e3 - t211 * t279 * t207 / 0.27e2 - t133 * t216 * t203 * t207 / 0.54e2 - 0.3e1 * t72 * t625 * t135 * t139 + 0.2e1 / 0.3e1 * t133 * t217 * t630 + 0.2e1 / 0.3e1 * t133 * t222 * t630 + 0.25e2 / 0.162e3 * t75 * t563 * t87 - 0.11e2 / 0.9e1 * t211 * t375
  t651 = t189 * t210
  t666 = t291 * t132
  t691 = -0.11e2 / 0.9e1 * t211 * t378 - 0.2e1 / 0.9e1 * t133 * t341 * t374 - t333 * t219 - t333 * t223 - t211 * t342 - 0.2e1 / 0.243e3 * t186 * t651 * t222 - t186 * t364 * t341 / 0.243e3 + t178 * t173 * t210 * t135 / 0.18e2 - 0.34e2 / 0.243e3 * t178 * t284 * t132 * t135 + 0.23e2 / 0.1458e4 * t186 * t666 * t217 + 0.23e2 / 0.1458e4 * t186 * t666 * t222 - t178 * t117 * t332 * t135 / 0.27e2 - 0.2e1 / 0.243e3 * t186 * t651 * t217 - 0.2e1 / 0.2187e4 * t313 * t132 * t216 * t127 - 0.40e2 / 0.27e2 * t89 * t91 * t68 - 0.2e1 / 0.2187e4 * t313 * t132 * t274 * t84
  t692 = t642 + t691
  t713 = t243 ** 2
  t719 = t246 ** 2
  t728 = 0.20e2 * t692 * t97 - 0.80e2 * t381 * t148 * t150 + 0.240e3 * t234 * t241 * t243 - 0.120e3 * t384 * t246 - 0.480e3 * t145 * t393 * t395 + 0.480e3 * t387 * t398 - 0.80e2 * t237 * t401 + 0.480e3 * t95 / t392 / t96 * t713 - 0.720e3 * t394 * t243 * t246 + 0.120e3 * t242 * t719 + 0.160e3 * t242 * t150 * t401 + 0.20e2 * t149 * t692
  t732 = t20 ** 2
  t735 = t30 ** 2
  t741 = t41 ** 2
  t750 = -0.24e2 * t46 + 0.24e2 * t17 / t45 / t7
  t751 = f.my_piecewise5(t11, 0, t15, 0, t750)
  t755 = f.my_piecewise3(t21, 0, 0.40e2 / 0.81e2 / t22 / t732 * t735 - 0.20e2 / 0.9e1 * t24 * t30 * t41 + 0.10e2 / 0.3e1 * t34 * t741 + 0.40e2 / 0.9e1 * t35 * t50 + 0.5e1 / 0.3e1 * t44 * t751)
  t778 = 0.1e1 / t55 / t36
  t787 = -0.2e1 / 0.5e1 * t6 * t162 * t153 + 0.6e1 / 0.5e1 * t6 * t166 * t249 + 0.3e1 / 0.5e1 * t6 * t170 * t404 + 0.8e1 / 0.45e2 * t6 * t260 * t153 - t6 * t264 * t249 / 0.5e1 + 0.2e1 / 0.5e1 * t6 * t268 * t404 + 0.3e1 / 0.20e2 * t6 * t272 * t728 + 0.3e1 / 0.20e2 * t6 * t755 * t56 * t100 + 0.3e1 / 0.5e1 * t6 * t57 * t153 + 0.6e1 / 0.5e1 * t6 * t111 * t153 + 0.9e1 / 0.10e2 * t6 * t115 * t249 - t6 * t109 * t161 * t100 / 0.5e1 + 0.8e1 / 0.45e2 * t6 * t159 * t259 * t100 - 0.14e2 / 0.135e3 * t6 * t257 * t778 * t100 + 0.2e1 / 0.5e1 * t6 * t54 * t110 * t100
  t788 = f.my_piecewise3(t1, 0, t787)
  t789 = t413 ** 2
  t792 = t420 ** 2
  t798 = t427 ** 2
  t804 = f.my_piecewise5(t15, 0, t11, 0, -t750)
  t808 = f.my_piecewise3(t414, 0, 0.40e2 / 0.81e2 / t415 / t789 * t792 - 0.20e2 / 0.9e1 * t417 * t420 * t427 + 0.10e2 / 0.3e1 * t424 * t798 + 0.40e2 / 0.9e1 * t425 * t432 + 0.5e1 / 0.3e1 * t430 * t804)
  t830 = f.my_piecewise3(t411, 0, 0.3e1 / 0.20e2 * t6 * t808 * t56 * t471 + 0.2e1 / 0.5e1 * t6 * t436 * t110 * t471 - t6 * t480 * t161 * t471 / 0.5e1 + 0.8e1 / 0.45e2 * t6 * t487 * t259 * t471 - 0.14e2 / 0.135e3 * t6 * t493 * t778 * t471)
  d1111 = 0.4e1 * t409 + 0.4e1 * t499 + t7 * (t788 + t830)

  res = {'v4rho4': d1111}
  return res
