"""Generated from gga_x_gg99.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  gg99_a = 3 ** (1 / 4) / (2 * jnp.sqrt(2) * jnp.pi ** (3 / 2))

  gg99_b = 4 * jnp.sqrt(3) * jnp.pi ** 3

  gg99_f0 = lambda r: (jnp.pi ** 2 - 12 * r * jnp.log(1 + jnp.exp(-2 * r)) + 12 * my_dilog(-jnp.exp(-2 * r))) / (2 * 3 ** (1 / 3) * jnp.pi * r * sech(r) ** (2 / 3)) / X_FACTOR_C

  gg99_r_branch1 = lambda x: jnp.arcsinh(gg99_a * x * jnp.sqrt(x ** 2 + (gg99_b + jnp.sqrt(gg99_b ** 2 - x ** 6)) ** (2 / 3)) / (gg99_b + jnp.sqrt(gg99_b ** 2 - x ** 6)) ** (1 / 6))

  gg99_r_branch2 = lambda x: jnp.arcsinh(jnp.sqrt(x ** 3 * (3 / gg99_b) * jnp.cos(jnp.arctan(jnp.sqrt(1 / gg99_b ** 2 * x ** 6 - 1)) / 3)))

  gg99_r = lambda x: f.my_piecewise3(x < gg99_b ** (1 / 3), gg99_r_branch1(jnp.minimum(x, gg99_b ** (1 / 3) - 1e-10)), gg99_r_branch2(jnp.maximum(x, gg99_b ** (1 / 3) + 1e-10)))

  gg99_f = lambda x: gg99_f0(gg99_r(x))

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, gg99_f, rs, zeta, xs0, xs1)

  my_dilog = lambda value: dilog(value)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  gg99_a = 3 ** (1 / 4) / (2 * jnp.sqrt(2) * jnp.pi ** (3 / 2))

  gg99_b = 4 * jnp.sqrt(3) * jnp.pi ** 3

  gg99_f0 = lambda r: (jnp.pi ** 2 - 12 * r * jnp.log(1 + jnp.exp(-2 * r)) + 12 * my_dilog(-jnp.exp(-2 * r))) / (2 * 3 ** (1 / 3) * jnp.pi * r * sech(r) ** (2 / 3)) / X_FACTOR_C

  gg99_r_branch1 = lambda x: jnp.arcsinh(gg99_a * x * jnp.sqrt(x ** 2 + (gg99_b + jnp.sqrt(gg99_b ** 2 - x ** 6)) ** (2 / 3)) / (gg99_b + jnp.sqrt(gg99_b ** 2 - x ** 6)) ** (1 / 6))

  gg99_r_branch2 = lambda x: jnp.arcsinh(jnp.sqrt(x ** 3 * (3 / gg99_b) * jnp.cos(jnp.arctan(jnp.sqrt(1 / gg99_b ** 2 * x ** 6 - 1)) / 3)))

  gg99_r = lambda x: f.my_piecewise3(x < gg99_b ** (1 / 3), gg99_r_branch1(jnp.minimum(x, gg99_b ** (1 / 3) - 1e-10)), gg99_r_branch2(jnp.maximum(x, gg99_b ** (1 / 3) + 1e-10)))

  gg99_f = lambda x: gg99_f0(gg99_r(x))

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, gg99_f, rs, zeta, xs0, xs1)

  my_dilog = lambda value: dilog(value)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  gg99_a = 3 ** (1 / 4) / (2 * jnp.sqrt(2) * jnp.pi ** (3 / 2))

  gg99_b = 4 * jnp.sqrt(3) * jnp.pi ** 3

  gg99_f0 = lambda r: (jnp.pi ** 2 - 12 * r * jnp.log(1 + jnp.exp(-2 * r)) + 12 * my_dilog(-jnp.exp(-2 * r))) / (2 * 3 ** (1 / 3) * jnp.pi * r * sech(r) ** (2 / 3)) / X_FACTOR_C

  gg99_r_branch1 = lambda x: jnp.arcsinh(gg99_a * x * jnp.sqrt(x ** 2 + (gg99_b + jnp.sqrt(gg99_b ** 2 - x ** 6)) ** (2 / 3)) / (gg99_b + jnp.sqrt(gg99_b ** 2 - x ** 6)) ** (1 / 6))

  gg99_r_branch2 = lambda x: jnp.arcsinh(jnp.sqrt(x ** 3 * (3 / gg99_b) * jnp.cos(jnp.arctan(jnp.sqrt(1 / gg99_b ** 2 * x ** 6 - 1)) / 3)))

  gg99_r = lambda x: f.my_piecewise3(x < gg99_b ** (1 / 3), gg99_r_branch1(jnp.minimum(x, gg99_b ** (1 / 3) - 1e-10)), gg99_r_branch2(jnp.maximum(x, gg99_b ** (1 / 3) + 1e-10)))

  gg99_f = lambda x: gg99_f0(gg99_r(x))

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, gg99_f, rs, zeta, xs0, xs1)

  my_dilog = lambda value: dilog(value)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = t3 / t4 / jnp.pi
  t8 = r0 + r1
  t9 = 0.1e1 / t8
  t12 = 0.2e1 * r0 * t9 <= f.p.zeta_threshold
  t13 = f.p.zeta_threshold - 0.1e1
  t16 = 0.2e1 * r1 * t9 <= f.p.zeta_threshold
  t17 = -t13
  t18 = r0 - r1
  t19 = t18 * t9
  t20 = f.my_piecewise5(t12, t13, t16, t17, t19)
  t21 = 0.1e1 + t20
  t22 = t21 <= f.p.zeta_threshold
  t23 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t24 = t23 * f.p.zeta_threshold
  t25 = t21 ** (0.1e1 / 0.3e1)
  t27 = f.my_piecewise3(t22, t24, t25 * t21)
  t28 = t8 ** (0.1e1 / 0.3e1)
  t29 = t27 * t28
  t30 = t7 * t29
  t31 = jnp.pi ** 2
  t32 = jnp.sqrt(s0)
  t33 = r0 ** (0.1e1 / 0.3e1)
  t35 = 0.1e1 / t33 / r0
  t36 = t32 * t35
  t37 = 4 ** (0.1e1 / 0.3e1)
  t38 = jnp.sqrt(0.3e1)
  t39 = t31 * jnp.pi
  t40 = t38 * t39
  t41 = t40 ** (0.1e1 / 0.3e1)
  t42 = t37 * t41
  t43 = t36 < t42
  t44 = 3 ** (0.1e1 / 0.4e1)
  t45 = jnp.sqrt(0.2e1)
  t46 = t44 * t45
  t47 = jnp.sqrt(jnp.pi)
  t49 = 0.1e1 / t47 / jnp.pi
  t50 = t46 * t49
  t51 = t42 - 0.1e-9
  t52 = t51 < t36
  t53 = f.my_piecewise3(t52, t51, t36)
  t54 = t53 ** 2
  t55 = 0.4e1 * t40
  t56 = t31 ** 2
  t57 = t56 * t31
  t58 = 0.48e2 * t57
  t59 = t54 ** 2
  t60 = t59 * t54
  t62 = jnp.sqrt(t58 - t60)
  t63 = t55 + t62
  t64 = t63 ** (0.1e1 / 0.3e1)
  t65 = t64 ** 2
  t66 = t54 + t65
  t67 = jnp.sqrt(t66)
  t69 = t63 ** (0.1e1 / 0.6e1)
  t70 = 0.1e1 / t69
  t74 = jnp.arcsinh(t50 * t53 * t67 * t70 / 0.4e1)
  t75 = 0.1e1 / jnp.pi
  t76 = t42 + 0.1e-9
  t77 = t76 < t36
  t78 = f.my_piecewise3(t77, t36, t76)
  t79 = t78 ** 2
  t81 = t79 * t78 * t38
  t82 = 0.1e1 / t57
  t83 = t79 ** 2
  t88 = jnp.sqrt(0.3e1 * t82 * t83 * t79 - 0.144e3)
  t90 = jnp.arctan(t88 / 0.12e2)
  t91 = t90 / 0.3e1
  t92 = jnp.cos(t91)
  t93 = t75 * t92
  t95 = jnp.sqrt(t81 * t93)
  t98 = jnp.arcsinh(t75 * t95 / 0.2e1)
  t99 = f.my_piecewise3(t43, t74, t98)
  t101 = jnp.exp(-0.2e1 * t99)
  t102 = 0.1e1 + t101
  t103 = jnp.log(t102)
  t106 = my_dilog(-t101)
  t108 = -0.12e2 * t99 * t103 + 0.12e2 * t106 + t31
  t109 = 0.1e1 / t99
  t111 = 0.1e1 / jnp.cosh(t99)
  t112 = t111 ** (0.1e1 / 0.3e1)
  t113 = t112 ** 2
  t114 = 0.1e1 / t113
  t115 = t75 ** (0.1e1 / 0.3e1)
  t116 = 0.1e1 / t115
  t118 = t114 * t116 * t37
  t119 = t108 * t109 * t118
  t122 = f.my_piecewise3(t1, 0, -t30 * t119 / 0.24e2)
  t123 = r1 <= f.p.dens_threshold
  t124 = f.my_piecewise5(t16, t13, t12, t17, -t19)
  t125 = 0.1e1 + t124
  t126 = t125 <= f.p.zeta_threshold
  t127 = t125 ** (0.1e1 / 0.3e1)
  t129 = f.my_piecewise3(t126, t24, t127 * t125)
  t130 = t129 * t28
  t131 = t7 * t130
  t132 = jnp.sqrt(s2)
  t133 = r1 ** (0.1e1 / 0.3e1)
  t135 = 0.1e1 / t133 / r1
  t136 = t132 * t135
  t137 = t136 < t42
  t138 = t51 < t136
  t139 = f.my_piecewise3(t138, t51, t136)
  t140 = t139 ** 2
  t141 = t140 ** 2
  t142 = t141 * t140
  t144 = jnp.sqrt(t58 - t142)
  t145 = t55 + t144
  t146 = t145 ** (0.1e1 / 0.3e1)
  t147 = t146 ** 2
  t148 = t140 + t147
  t149 = jnp.sqrt(t148)
  t151 = t145 ** (0.1e1 / 0.6e1)
  t152 = 0.1e1 / t151
  t156 = jnp.arcsinh(t50 * t139 * t149 * t152 / 0.4e1)
  t157 = t76 < t136
  t158 = f.my_piecewise3(t157, t136, t76)
  t159 = t158 ** 2
  t161 = t159 * t158 * t38
  t162 = t159 ** 2
  t167 = jnp.sqrt(0.3e1 * t82 * t162 * t159 - 0.144e3)
  t169 = jnp.arctan(t167 / 0.12e2)
  t170 = t169 / 0.3e1
  t171 = jnp.cos(t170)
  t172 = t75 * t171
  t174 = jnp.sqrt(t161 * t172)
  t177 = jnp.arcsinh(t75 * t174 / 0.2e1)
  t178 = f.my_piecewise3(t137, t156, t177)
  t180 = jnp.exp(-0.2e1 * t178)
  t181 = 0.1e1 + t180
  t182 = jnp.log(t181)
  t185 = my_dilog(-t180)
  t187 = -0.12e2 * t178 * t182 + 0.12e2 * t185 + t31
  t188 = 0.1e1 / t178
  t190 = 0.1e1 / jnp.cosh(t178)
  t191 = t190 ** (0.1e1 / 0.3e1)
  t192 = t191 ** 2
  t193 = 0.1e1 / t192
  t195 = t193 * t116 * t37
  t196 = t187 * t188 * t195
  t199 = f.my_piecewise3(t123, 0, -t131 * t196 / 0.24e2)
  t200 = t8 ** 2
  t202 = t18 / t200
  t203 = t9 - t202
  t204 = f.my_piecewise5(t12, 0, t16, 0, t203)
  t207 = f.my_piecewise3(t22, 0, 0.4e1 / 0.3e1 * t25 * t204)
  t212 = t28 ** 2
  t213 = 0.1e1 / t212
  t217 = t7 * t27 * t213 * t119 / 0.72e2
  t218 = r0 ** 2
  t222 = 0.4e1 / 0.3e1 * t32 / t33 / t218
  t223 = f.my_piecewise3(t52, 0, -t222)
  t229 = t53 / t67
  t231 = 0.1e1 / t64
  t232 = 0.1e1 / t62
  t233 = t231 * t232
  t234 = t59 * t53
  t244 = t46 * t49 * t60
  t247 = t67 / t69 / t63
  t253 = 0.1e1 / t39
  t254 = t38 * t253
  t260 = jnp.sqrt(0.2e1 * t254 * t54 * t66 * t231 + 0.16e2)
  t261 = 0.1e1 / t260
  t265 = t75 / t95
  t266 = t79 * t38
  t267 = f.my_piecewise3(t77, -t222, 0)
  t271 = t266 * t75
  t272 = jnp.sin(t91)
  t274 = t272 / t88
  t282 = jnp.sqrt(t81 * t253 * t92 + 0.4e1)
  t283 = 0.1e1 / t282
  t287 = f.my_piecewise3(t43, 0.4e1 * (t50 * t223 * t67 * t70 / 0.4e1 + t50 * t229 * t70 * (-0.2e1 * t233 * t234 * t223 + 0.2e1 * t53 * t223) / 0.8e1 + t244 * t247 * t232 * t223 / 0.8e1) * t261, t265 * (0.3e1 * t266 * t93 * t267 - 0.12e2 * t271 * t274 * t267) * t283 / 0.2e1)
  t292 = t101 / t102
  t301 = t7 * t29 * t108
  t302 = t99 ** 2
  t304 = 0.1e1 / t302 * t114
  t305 = t116 * t37
  t311 = t109 * t114 * t116
  t312 = jnp.tanh(t99)
  t313 = t37 * t312
  t319 = f.my_piecewise3(t1, 0, -t7 * t207 * t28 * t119 / 0.24e2 - t217 - t30 * (0.24e2 * t99 * t287 * t292 + 0.12e2 * t287 * t103) * t109 * t118 / 0.24e2 + t301 * t304 * t305 * t287 / 0.24e2 - t301 * t311 * t313 * t287 / 0.36e2)
  t321 = f.my_piecewise5(t16, 0, t12, 0, -t203)
  t324 = f.my_piecewise3(t126, 0, 0.4e1 / 0.3e1 * t127 * t321)
  t332 = t7 * t129 * t213 * t196 / 0.72e2
  t334 = f.my_piecewise3(t123, 0, -t7 * t324 * t28 * t196 / 0.24e2 - t332)
  vrho_0_ = t122 + t199 + t8 * (t319 + t334)
  t337 = -t9 - t202
  t338 = f.my_piecewise5(t12, 0, t16, 0, t337)
  t341 = f.my_piecewise3(t22, 0, 0.4e1 / 0.3e1 * t25 * t338)
  t347 = f.my_piecewise3(t1, 0, -t7 * t341 * t28 * t119 / 0.24e2 - t217)
  t349 = f.my_piecewise5(t16, 0, t12, 0, -t337)
  t352 = f.my_piecewise3(t126, 0, 0.4e1 / 0.3e1 * t127 * t349)
  t357 = r1 ** 2
  t361 = 0.4e1 / 0.3e1 * t132 / t133 / t357
  t362 = f.my_piecewise3(t138, 0, -t361)
  t368 = t139 / t149
  t370 = 0.1e1 / t146
  t371 = 0.1e1 / t144
  t372 = t370 * t371
  t373 = t141 * t139
  t383 = t46 * t49 * t142
  t386 = t149 / t151 / t145
  t397 = jnp.sqrt(0.2e1 * t254 * t140 * t148 * t370 + 0.16e2)
  t398 = 0.1e1 / t397
  t402 = t75 / t174
  t403 = t159 * t38
  t404 = f.my_piecewise3(t157, -t361, 0)
  t408 = t403 * t75
  t409 = jnp.sin(t170)
  t411 = t409 / t167
  t419 = jnp.sqrt(t161 * t253 * t171 + 0.4e1)
  t420 = 0.1e1 / t419
  t424 = f.my_piecewise3(t137, 0.4e1 * (t50 * t362 * t149 * t152 / 0.4e1 + t50 * t368 * t152 * (-0.2e1 * t372 * t373 * t362 + 0.2e1 * t139 * t362) / 0.8e1 + t383 * t386 * t371 * t362 / 0.8e1) * t398, t402 * (0.3e1 * t403 * t172 * t404 - 0.12e2 * t408 * t411 * t404) * t420 / 0.2e1)
  t429 = t180 / t181
  t438 = t7 * t130 * t187
  t439 = t178 ** 2
  t441 = 0.1e1 / t439 * t193
  t447 = t188 * t193 * t116
  t448 = jnp.tanh(t178)
  t449 = t37 * t448
  t455 = f.my_piecewise3(t123, 0, -t7 * t352 * t28 * t196 / 0.24e2 - t332 - t131 * (0.24e2 * t178 * t424 * t429 + 0.12e2 * t424 * t182) * t188 * t195 / 0.24e2 + t438 * t441 * t305 * t424 / 0.24e2 - t438 * t447 * t449 * t424 / 0.36e2)
  vrho_1_ = t122 + t199 + t8 * (t347 + t455)
  t460 = 0.1e1 / t32 * t35 / 0.2e1
  t461 = f.my_piecewise3(t52, 0, t460)
  t482 = f.my_piecewise3(t77, t460, 0)
  t493 = f.my_piecewise3(t43, 0.4e1 * (t50 * t461 * t67 * t70 / 0.4e1 + t50 * t229 * t70 * (-0.2e1 * t233 * t234 * t461 + 0.2e1 * t53 * t461) / 0.8e1 + t244 * t247 * t232 * t461 / 0.8e1) * t261, t265 * (0.3e1 * t266 * t93 * t482 - 0.12e2 * t271 * t274 * t482) * t283 / 0.2e1)
  t513 = f.my_piecewise3(t1, 0, -t30 * (0.24e2 * t99 * t493 * t292 + 0.12e2 * t493 * t103) * t109 * t118 / 0.24e2 + t301 * t304 * t305 * t493 / 0.24e2 - t301 * t311 * t313 * t493 / 0.36e2)
  vsigma_0_ = t8 * t513
  vsigma_1_ = 0.0e0
  t516 = 0.1e1 / t132 * t135 / 0.2e1
  t517 = f.my_piecewise3(t138, 0, t516)
  t538 = f.my_piecewise3(t157, t516, 0)
  t549 = f.my_piecewise3(t137, 0.4e1 * (t50 * t517 * t149 * t152 / 0.4e1 + t50 * t368 * t152 * (-0.2e1 * t372 * t373 * t517 + 0.2e1 * t139 * t517) / 0.8e1 + t383 * t386 * t371 * t517 / 0.8e1) * t398, t402 * (0.3e1 * t403 * t172 * t538 - 0.12e2 * t408 * t411 * t538) * t420 / 0.2e1)
  t569 = f.my_piecewise3(t123, 0, -t131 * (0.24e2 * t178 * t549 * t429 + 0.12e2 * t549 * t182) * t188 * t195 / 0.24e2 + t438 * t441 * t305 * t549 / 0.24e2 - t438 * t447 * t449 * t549 / 0.36e2)
  vsigma_2_ = t8 * t569
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  gg99_a = 3 ** (1 / 4) / (2 * jnp.sqrt(2) * jnp.pi ** (3 / 2))

  gg99_b = 4 * jnp.sqrt(3) * jnp.pi ** 3

  gg99_f0 = lambda r: (jnp.pi ** 2 - 12 * r * jnp.log(1 + jnp.exp(-2 * r)) + 12 * my_dilog(-jnp.exp(-2 * r))) / (2 * 3 ** (1 / 3) * jnp.pi * r * sech(r) ** (2 / 3)) / X_FACTOR_C

  gg99_r_branch1 = lambda x: jnp.arcsinh(gg99_a * x * jnp.sqrt(x ** 2 + (gg99_b + jnp.sqrt(gg99_b ** 2 - x ** 6)) ** (2 / 3)) / (gg99_b + jnp.sqrt(gg99_b ** 2 - x ** 6)) ** (1 / 6))

  gg99_r_branch2 = lambda x: jnp.arcsinh(jnp.sqrt(x ** 3 * (3 / gg99_b) * jnp.cos(jnp.arctan(jnp.sqrt(1 / gg99_b ** 2 * x ** 6 - 1)) / 3)))

  gg99_r = lambda x: f.my_piecewise3(x < gg99_b ** (1 / 3), gg99_r_branch1(jnp.minimum(x, gg99_b ** (1 / 3) - 1e-10)), gg99_r_branch2(jnp.maximum(x, gg99_b ** (1 / 3) + 1e-10)))

  gg99_f = lambda x: gg99_f0(gg99_r(x))

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, gg99_f, rs, zeta, xs0, xs1)

  my_dilog = lambda value: dilog(value)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = jnp.pi ** (0.1e1 / 0.3e1)
  t8 = t4 / t5 / jnp.pi
  t9 = 0.1e1 <= f.p.zeta_threshold
  t10 = f.p.zeta_threshold - 0.1e1
  t12 = f.my_piecewise5(t9, t10, t9, -t10, 0)
  t13 = 0.1e1 + t12
  t15 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t17 = t13 ** (0.1e1 / 0.3e1)
  t19 = f.my_piecewise3(t13 <= f.p.zeta_threshold, t15 * f.p.zeta_threshold, t17 * t13)
  t20 = r0 ** (0.1e1 / 0.3e1)
  t21 = t19 * t20
  t22 = t8 * t21
  t23 = jnp.pi ** 2
  t24 = jnp.sqrt(s0)
  t25 = 2 ** (0.1e1 / 0.3e1)
  t26 = t24 * t25
  t28 = 0.1e1 / t20 / r0
  t29 = t26 * t28
  t30 = 4 ** (0.1e1 / 0.3e1)
  t31 = jnp.sqrt(0.3e1)
  t32 = t23 * jnp.pi
  t33 = t31 * t32
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t30 * t34
  t36 = t29 < t35
  t37 = 3 ** (0.1e1 / 0.4e1)
  t38 = jnp.sqrt(0.2e1)
  t39 = t37 * t38
  t40 = jnp.sqrt(jnp.pi)
  t42 = 0.1e1 / t40 / jnp.pi
  t43 = t39 * t42
  t44 = t35 - 0.1e-9
  t45 = t44 < t29
  t46 = f.my_piecewise3(t45, t44, t29)
  t47 = t46 ** 2
  t49 = t23 ** 2
  t50 = t49 * t23
  t52 = t47 ** 2
  t53 = t52 * t47
  t55 = jnp.sqrt(0.48e2 * t50 - t53)
  t56 = 0.4e1 * t33 + t55
  t57 = t56 ** (0.1e1 / 0.3e1)
  t58 = t57 ** 2
  t59 = t47 + t58
  t60 = jnp.sqrt(t59)
  t62 = t56 ** (0.1e1 / 0.6e1)
  t63 = 0.1e1 / t62
  t67 = jnp.arcsinh(t43 * t46 * t60 * t63 / 0.4e1)
  t68 = 0.1e1 / jnp.pi
  t69 = t35 + 0.1e-9
  t70 = t69 < t29
  t71 = f.my_piecewise3(t70, t29, t69)
  t72 = t71 ** 2
  t74 = t72 * t71 * t31
  t76 = t72 ** 2
  t81 = jnp.sqrt(0.3e1 / t50 * t76 * t72 - 0.144e3)
  t83 = jnp.arctan(t81 / 0.12e2)
  t84 = t83 / 0.3e1
  t85 = jnp.cos(t84)
  t86 = t68 * t85
  t88 = jnp.sqrt(t74 * t86)
  t91 = jnp.arcsinh(t68 * t88 / 0.2e1)
  t92 = f.my_piecewise3(t36, t67, t91)
  t94 = jnp.exp(-0.2e1 * t92)
  t95 = 0.1e1 + t94
  t96 = jnp.log(t95)
  t99 = my_dilog(-t94)
  t101 = -0.12e2 * t92 * t96 + t23 + 0.12e2 * t99
  t102 = 0.1e1 / t92
  t104 = 0.1e1 / jnp.cosh(t92)
  t105 = t104 ** (0.1e1 / 0.3e1)
  t106 = t105 ** 2
  t107 = 0.1e1 / t106
  t108 = t68 ** (0.1e1 / 0.3e1)
  t109 = 0.1e1 / t108
  t111 = t107 * t109 * t30
  t112 = t101 * t102 * t111
  t115 = f.my_piecewise3(t2, 0, -t22 * t112 / 0.24e2)
  t116 = t20 ** 2
  t122 = r0 ** 2
  t126 = 0.4e1 / 0.3e1 * t26 / t20 / t122
  t127 = f.my_piecewise3(t45, 0, -t126)
  t133 = t46 / t60
  t135 = 0.1e1 / t57
  t136 = 0.1e1 / t55
  t137 = t135 * t136
  t138 = t52 * t46
  t148 = t39 * t42 * t53
  t151 = t60 / t62 / t56
  t157 = 0.1e1 / t32
  t164 = jnp.sqrt(0.2e1 * t31 * t157 * t47 * t59 * t135 + 0.16e2)
  t165 = 0.1e1 / t164
  t169 = t68 / t88
  t170 = t72 * t31
  t171 = f.my_piecewise3(t70, -t126, 0)
  t175 = t170 * t68
  t176 = jnp.sin(t84)
  t178 = t176 / t81
  t186 = jnp.sqrt(t74 * t157 * t85 + 0.4e1)
  t187 = 0.1e1 / t186
  t191 = f.my_piecewise3(t36, 0.4e1 * (t43 * t127 * t60 * t63 / 0.4e1 + t43 * t133 * t63 * (-0.2e1 * t137 * t138 * t127 + 0.2e1 * t46 * t127) / 0.8e1 + t148 * t151 * t136 * t127 / 0.8e1) * t165, t169 * (0.3e1 * t170 * t86 * t171 - 0.12e2 * t175 * t178 * t171) * t187 / 0.2e1)
  t196 = t94 / t95
  t205 = t8 * t21 * t101
  t206 = t92 ** 2
  t208 = 0.1e1 / t206 * t107
  t209 = t109 * t30
  t215 = t102 * t107 * t109
  t216 = jnp.tanh(t92)
  t217 = t30 * t216
  t223 = f.my_piecewise3(t2, 0, -t8 * t19 / t116 * t112 / 0.72e2 - t22 * (0.24e2 * t92 * t191 * t196 + 0.12e2 * t191 * t96) * t102 * t111 / 0.24e2 + t205 * t208 * t209 * t191 / 0.24e2 - t205 * t215 * t217 * t191 / 0.36e2)
  vrho_0_ = 0.2e1 * r0 * t223 + 0.2e1 * t115
  t229 = 0.1e1 / t24 * t25 * t28 / 0.2e1
  t230 = f.my_piecewise3(t45, 0, t229)
  t251 = f.my_piecewise3(t70, t229, 0)
  t262 = f.my_piecewise3(t36, 0.4e1 * (t43 * t230 * t60 * t63 / 0.4e1 + t43 * t133 * t63 * (-0.2e1 * t137 * t138 * t230 + 0.2e1 * t46 * t230) / 0.8e1 + t148 * t151 * t136 * t230 / 0.8e1) * t165, t169 * (0.3e1 * t170 * t86 * t251 - 0.12e2 * t175 * t178 * t251) * t187 / 0.2e1)
  t282 = f.my_piecewise3(t2, 0, -t22 * (0.24e2 * t92 * t262 * t196 + 0.12e2 * t262 * t96) * t102 * t111 / 0.24e2 + t205 * t208 * t209 * t262 / 0.24e2 - t205 * t215 * t217 * t262 / 0.36e2)
  vsigma_0_ = 0.2e1 * r0 * t282
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = jnp.pi ** (0.1e1 / 0.3e1)
  t8 = t4 / t5 / jnp.pi
  t9 = 0.1e1 <= f.p.zeta_threshold
  t10 = f.p.zeta_threshold - 0.1e1
  t12 = f.my_piecewise5(t9, t10, t9, -t10, 0)
  t13 = 0.1e1 + t12
  t15 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t17 = t13 ** (0.1e1 / 0.3e1)
  t19 = f.my_piecewise3(t13 <= f.p.zeta_threshold, t15 * f.p.zeta_threshold, t17 * t13)
  t20 = r0 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t23 = t19 / t21
  t24 = t8 * t23
  t25 = jnp.pi ** 2
  t26 = jnp.sqrt(s0)
  t27 = 2 ** (0.1e1 / 0.3e1)
  t28 = t26 * t27
  t30 = 0.1e1 / t20 / r0
  t31 = t28 * t30
  t32 = 4 ** (0.1e1 / 0.3e1)
  t33 = jnp.sqrt(0.3e1)
  t34 = t25 * jnp.pi
  t35 = t33 * t34
  t36 = t35 ** (0.1e1 / 0.3e1)
  t37 = t32 * t36
  t38 = t31 < t37
  t39 = 3 ** (0.1e1 / 0.4e1)
  t40 = jnp.sqrt(0.2e1)
  t41 = t39 * t40
  t42 = jnp.sqrt(jnp.pi)
  t44 = 0.1e1 / t42 / jnp.pi
  t45 = t41 * t44
  t46 = t37 - 0.1e-9
  t47 = t46 < t31
  t48 = f.my_piecewise3(t47, t46, t31)
  t49 = t48 ** 2
  t51 = t25 ** 2
  t52 = t51 * t25
  t54 = t49 ** 2
  t55 = t54 * t49
  t56 = 0.48e2 * t52 - t55
  t57 = jnp.sqrt(t56)
  t58 = 0.4e1 * t35 + t57
  t59 = t58 ** (0.1e1 / 0.3e1)
  t60 = t59 ** 2
  t61 = t49 + t60
  t62 = jnp.sqrt(t61)
  t64 = t58 ** (0.1e1 / 0.6e1)
  t65 = 0.1e1 / t64
  t69 = jnp.arcsinh(t45 * t48 * t62 * t65 / 0.4e1)
  t70 = 0.1e1 / jnp.pi
  t71 = t37 + 0.1e-9
  t72 = t71 < t31
  t73 = f.my_piecewise3(t72, t31, t71)
  t74 = t73 ** 2
  t75 = t74 * t73
  t76 = t75 * t33
  t78 = t74 ** 2
  t82 = 0.3e1 / t52 * t78 * t74 - 0.144e3
  t83 = jnp.sqrt(t82)
  t85 = jnp.arctan(t83 / 0.12e2)
  t86 = t85 / 0.3e1
  t87 = jnp.cos(t86)
  t88 = t70 * t87
  t89 = t76 * t88
  t90 = jnp.sqrt(t89)
  t93 = jnp.arcsinh(t70 * t90 / 0.2e1)
  t94 = f.my_piecewise3(t38, t69, t93)
  t96 = jnp.exp(-0.2e1 * t94)
  t97 = 0.1e1 + t96
  t98 = jnp.log(t97)
  t101 = my_dilog(-t96)
  t103 = -0.12e2 * t94 * t98 + 0.12e2 * t101 + t25
  t104 = 0.1e1 / t94
  t106 = 0.1e1 / jnp.cosh(t94)
  t107 = t106 ** (0.1e1 / 0.3e1)
  t108 = t107 ** 2
  t109 = 0.1e1 / t108
  t110 = t70 ** (0.1e1 / 0.3e1)
  t111 = 0.1e1 / t110
  t113 = t109 * t111 * t32
  t114 = t103 * t104 * t113
  t117 = t19 * t20
  t118 = t8 * t117
  t119 = r0 ** 2
  t121 = 0.1e1 / t20 / t119
  t123 = 0.4e1 / 0.3e1 * t28 * t121
  t124 = f.my_piecewise3(t47, 0, -t123)
  t129 = 0.1e1 / t62
  t130 = t48 * t129
  t132 = 0.1e1 / t59
  t133 = 0.1e1 / t57
  t134 = t132 * t133
  t135 = t54 * t48
  t139 = -0.2e1 * t134 * t135 * t124 + 0.2e1 * t48 * t124
  t140 = t65 * t139
  t145 = t41 * t44 * t55
  t147 = 0.1e1 / t64 / t58
  t148 = t62 * t147
  t149 = t133 * t124
  t153 = t45 * t124 * t62 * t65 / 0.4e1 + t45 * t130 * t140 / 0.8e1 + t145 * t148 * t149 / 0.8e1
  t154 = 0.1e1 / t34
  t155 = t33 * t154
  t160 = 0.2e1 * t155 * t49 * t61 * t132 + 0.16e2
  t161 = jnp.sqrt(t160)
  t162 = 0.1e1 / t161
  t166 = t70 / t90
  t167 = t74 * t33
  t168 = f.my_piecewise3(t72, -t123, 0)
  t172 = t167 * t70
  t173 = jnp.sin(t86)
  t175 = t173 / t83
  t176 = t175 * t168
  t179 = 0.3e1 * t167 * t88 * t168 - 0.12e2 * t172 * t176
  t182 = t76 * t154 * t87 + 0.4e1
  t183 = jnp.sqrt(t182)
  t184 = 0.1e1 / t183
  t188 = f.my_piecewise3(t38, 0.4e1 * t153 * t162, t166 * t179 * t184 / 0.2e1)
  t192 = 0.1e1 / t97
  t193 = t96 * t192
  t196 = 0.24e2 * t94 * t188 * t193 + 0.12e2 * t188 * t98
  t198 = t196 * t104 * t113
  t202 = t8 * t117 * t103
  t203 = t94 ** 2
  t204 = 0.1e1 / t203
  t205 = t204 * t109
  t206 = t111 * t32
  t208 = t205 * t206 * t188
  t212 = t104 * t109 * t111
  t213 = jnp.tanh(t94)
  t214 = t32 * t213
  t216 = t212 * t214 * t188
  t220 = f.my_piecewise3(t2, 0, -t24 * t114 / 0.72e2 - t118 * t198 / 0.24e2 + t202 * t208 / 0.24e2 - t202 * t216 / 0.36e2)
  t231 = t8 * t23 * t103
  t240 = 0.28e2 / 0.9e1 * t28 / t20 / t119 / r0
  t241 = f.my_piecewise3(t47, 0, t240)
  t246 = t124 * t129
  t250 = t124 ** 2
  t253 = t133 * t135
  t254 = t148 * t253
  t258 = 0.1e1 / t62 / t61
  t259 = t48 * t258
  t260 = t139 ** 2
  t265 = t129 * t147
  t275 = 0.1e1 / t59 / t58
  t276 = 0.1e1 / t56
  t277 = t275 * t276
  t278 = t54 ** 2
  t279 = t278 * t49
  t280 = t279 * t250
  t284 = 0.1e1 / t57 / t56
  t285 = t132 * t284
  t299 = t49 * t48
  t302 = t41 * t44 * t278 * t299
  t303 = t58 ** 2
  t306 = t62 / t64 / t303
  t323 = 0.1e1 / t161 / t160
  t325 = t155 * t48
  t326 = t61 * t132
  t335 = t155 * t54 * t299
  t336 = t61 * t275
  t340 = 0.2e1 * t155 * t49 * t139 * t132 + 0.4e1 * t325 * t326 * t124 + 0.2e1 * t335 * t336 * t149
  t346 = t70 / t90 / t89
  t347 = t179 ** 2
  t351 = t73 * t33
  t352 = t168 ** 2
  t356 = t351 * t70
  t360 = f.my_piecewise3(t72, t240, 0)
  t365 = t87 / t82
  t373 = t78 * t75 * t33 / t51 / t34
  t376 = t173 / t83 / t82
  t388 = 0.1e1 / t183 / t182
  t390 = t154 * t74
  t391 = t33 * t87
  t395 = t390 * t33
  t398 = 0.3e1 * t390 * t391 * t168 - 0.12e2 * t395 * t176
  t403 = f.my_piecewise3(t38, 0.4e1 * (t45 * t241 * t62 * t65 / 0.4e1 + t45 * t246 * t140 / 0.4e1 + 0.7e1 / 0.8e1 * t41 * t44 * t250 * t254 - t45 * t259 * t65 * t260 / 0.16e2 + t145 * t265 * t139 * t133 * t124 / 0.8e1 + t45 * t130 * t65 * (-0.2e1 * t134 * t135 * t241 - 0.10e2 * t134 * t54 * t250 + 0.2e1 * t48 * t241 - 0.2e1 * t277 * t280 - 0.6e1 * t285 * t280 + 0.2e1 * t250) / 0.8e1 + 0.7e1 / 0.16e2 * t302 * t306 * t276 * t250 + 0.3e1 / 0.8e1 * t302 * t148 * t284 * t250 + t145 * t148 * t133 * t241 / 0.8e1) * t162 - 0.2e1 * t153 * t323 * t340, -t346 * t347 * t184 / 0.4e1 + t166 * (0.3e1 * t167 * t88 * t360 - 0.12e2 * t172 * t175 * t360 - 0.60e2 * t356 * t175 * t352 + 0.6e1 * t351 * t88 * t352 - 0.144e3 * t356 * t365 * t352 + 0.108e3 * t373 * t376 * t352) * t184 / 0.2e1 - t166 * t179 * t388 * t398 / 0.4e1)
  t409 = t188 ** 2
  t410 = t94 * t409
  t413 = t96 ** 2
  t414 = t97 ** 2
  t416 = t413 / t414
  t425 = t8 * t117 * t196
  t432 = 0.1e1 / t203 / t94 * t109
  t437 = t205 * t111
  t447 = t213 ** 2
  t448 = t32 * t447
  t453 = 0.1e1 - t447
  t454 = t32 * t453
  t463 = t8 * t19 / t21 / r0 * t114 / 0.108e3 - t24 * t198 / 0.36e2 + t231 * t208 / 0.36e2 - t231 * t216 / 0.54e2 - t118 * (0.24e2 * t94 * t403 * t193 - 0.48e2 * t410 * t193 + 0.12e2 * t403 * t98 + 0.48e2 * t410 * t416) * t104 * t113 / 0.24e2 + t425 * t208 / 0.12e2 - t425 * t216 / 0.18e2 - t202 * t432 * t206 * t409 / 0.12e2 + t202 * t437 * t32 * t409 * t213 / 0.18e2 + t202 * t205 * t206 * t403 / 0.24e2 - t202 * t212 * t448 * t409 / 0.54e2 - t202 * t212 * t454 * t409 / 0.36e2 - t202 * t212 * t214 * t403 / 0.36e2
  t464 = f.my_piecewise3(t2, 0, t463)
  v2rho2_0_ = 0.2e1 * r0 * t464 + 0.4e1 * t220
  t468 = 0.1e1 / t26 * t27
  t470 = t468 * t30 / 0.2e1
  t471 = f.my_piecewise3(t47, 0, t470)
  t480 = -0.2e1 * t134 * t135 * t471 + 0.2e1 * t48 * t471
  t481 = t65 * t480
  t485 = t133 * t471
  t489 = t45 * t471 * t62 * t65 / 0.4e1 + t45 * t130 * t481 / 0.8e1 + t145 * t148 * t485 / 0.8e1
  t492 = f.my_piecewise3(t72, t470, 0)
  t496 = t175 * t492
  t499 = 0.3e1 * t167 * t88 * t492 - 0.12e2 * t172 * t496
  t500 = t499 * t184
  t503 = f.my_piecewise3(t38, 0.4e1 * t489 * t162, t166 * t500 / 0.2e1)
  t506 = t94 * t503
  t509 = 0.24e2 * t506 * t193 + 0.12e2 * t503 * t98
  t511 = t509 * t104 * t113
  t515 = t205 * t206 * t503
  t519 = t212 * t214 * t503
  t523 = f.my_piecewise3(t2, 0, -t118 * t511 / 0.24e2 + t202 * t515 / 0.24e2 - t202 * t519 / 0.36e2)
  t527 = 0.2e1 / 0.3e1 * t468 * t121
  t528 = f.my_piecewise3(t47, 0, -t527)
  t533 = t471 * t129
  t553 = t480 * t133
  t563 = t279 * t471 * t124
  t598 = t45 * t528 * t62 * t65 / 0.4e1 + t45 * t533 * t140 / 0.8e1 + 0.7e1 / 0.8e1 * t41 * t44 * t471 * t148 * t253 * t124 + t45 * t246 * t481 / 0.8e1 - t41 * t44 * t48 * t258 * t65 * t480 * t139 / 0.16e2 + t145 * t265 * t553 * t124 / 0.16e2 + t45 * t130 * t65 * (-0.10e2 * t134 * t54 * t471 * t124 - 0.2e1 * t134 * t135 * t528 + 0.2e1 * t124 * t471 - 0.2e1 * t277 * t563 - 0.6e1 * t285 * t563 + 0.2e1 * t48 * t528) / 0.8e1 + t145 * t265 * t485 * t139 / 0.16e2 + 0.7e1 / 0.16e2 * t302 * t306 * t276 * t471 * t124 + 0.3e1 / 0.8e1 * t302 * t148 * t284 * t471 * t124 + t145 * t148 * t133 * t528 / 0.8e1
  t601 = t489 * t323
  t612 = t168 * t492
  t616 = f.my_piecewise3(t72, -t527, 0)
  t633 = t499 * t388
  t638 = f.my_piecewise3(t38, 0.4e1 * t598 * t162 - 0.2e1 * t601 * t340, -t346 * t500 * t179 / 0.4e1 + t166 * (0.6e1 * t356 * t87 * t492 * t168 + 0.3e1 * t167 * t88 * t616 - 0.12e2 * t172 * t175 * t616 - 0.60e2 * t356 * t175 * t612 - 0.144e3 * t356 * t365 * t612 + 0.108e3 * t373 * t376 * t612) * t184 / 0.2e1 - t166 * t633 * t398 / 0.4e1)
  t657 = t8 * t117 * t509
  t672 = t8 * t19
  t673 = t20 * t103
  t690 = t672 * t673 * t104
  t705 = -t24 * t511 / 0.72e2 - t118 * (-0.48e2 * t506 * t188 * t96 * t192 + 0.48e2 * t506 * t416 * t188 + 0.24e2 * t94 * t638 * t193 + 0.12e2 * t638 * t98) * t104 * t113 / 0.24e2 + t657 * t208 / 0.24e2 - t657 * t216 / 0.36e2 + t231 * t515 / 0.72e2 + t425 * t515 / 0.24e2 - t202 * t432 * t111 * t32 * t503 * t188 / 0.12e2 + t672 * t673 * t204 * t113 * t503 * t213 * t188 / 0.18e2 + t202 * t205 * t206 * t638 / 0.24e2 - t231 * t519 / 0.108e3 - t425 * t519 / 0.36e2 - t690 * t113 * t447 * t503 * t188 / 0.54e2 - t690 * t113 * t453 * t188 * t503 / 0.36e2 - t202 * t212 * t214 * t638 / 0.36e2
  t706 = f.my_piecewise3(t2, 0, t705)
  v2rhosigma_0_ = 0.2e1 * r0 * t706 + 0.2e1 * t523
  t713 = 0.1e1 / t26 / s0 * t27 * t30 / 0.4e1
  t714 = f.my_piecewise3(t47, 0, -t713)
  t722 = t471 ** 2
  t727 = t480 ** 2
  t739 = t279 * t722
  t784 = t499 ** 2
  t788 = t492 ** 2
  t795 = f.my_piecewise3(t72, -t713, 0)
  t822 = f.my_piecewise3(t38, 0.4e1 * (t45 * t714 * t62 * t65 / 0.4e1 + t45 * t533 * t481 / 0.4e1 + 0.7e1 / 0.8e1 * t41 * t44 * t722 * t254 - t45 * t259 * t65 * t727 / 0.16e2 + t145 * t265 * t553 * t471 / 0.8e1 + t45 * t130 * t65 * (-0.2e1 * t134 * t135 * t714 - 0.10e2 * t134 * t54 * t722 - 0.2e1 * t277 * t739 - 0.6e1 * t285 * t739 + 0.2e1 * t48 * t714 + 0.2e1 * t722) / 0.8e1 + 0.7e1 / 0.16e2 * t302 * t306 * t276 * t722 + 0.3e1 / 0.8e1 * t302 * t148 * t284 * t722 + t145 * t148 * t133 * t714 / 0.8e1) * t162 - 0.2e1 * t601 * (0.2e1 * t155 * t49 * t480 * t132 + 0.4e1 * t325 * t326 * t471 + 0.2e1 * t335 * t336 * t485), -t346 * t784 * t184 / 0.4e1 + t166 * (0.3e1 * t167 * t88 * t795 - 0.12e2 * t172 * t175 * t795 - 0.60e2 * t356 * t175 * t788 + 0.6e1 * t351 * t88 * t788 - 0.144e3 * t356 * t365 * t788 + 0.108e3 * t373 * t376 * t788) * t184 / 0.2e1 - t166 * t633 * (0.3e1 * t390 * t391 * t492 - 0.12e2 * t395 * t496) / 0.4e1)
  t828 = t503 ** 2
  t829 = t94 * t828
  t869 = f.my_piecewise3(t2, 0, -t118 * (0.24e2 * t94 * t822 * t193 - 0.48e2 * t829 * t193 + 0.48e2 * t829 * t416 + 0.12e2 * t822 * t98) * t104 * t113 / 0.24e2 + t657 * t515 / 0.12e2 - t657 * t519 / 0.18e2 - t202 * t432 * t206 * t828 / 0.12e2 + t202 * t437 * t32 * t828 * t213 / 0.18e2 + t202 * t205 * t206 * t822 / 0.24e2 - t202 * t212 * t448 * t828 / 0.54e2 - t202 * t212 * t454 * t828 / 0.36e2 - t202 * t212 * t214 * t822 / 0.36e2)
  v2sigma2_0_ = 0.2e1 * r0 * t869
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = jnp.pi ** (0.1e1 / 0.3e1)
  t8 = t4 / t5 / jnp.pi
  t9 = 0.1e1 <= f.p.zeta_threshold
  t10 = f.p.zeta_threshold - 0.1e1
  t12 = f.my_piecewise5(t9, t10, t9, -t10, 0)
  t13 = 0.1e1 + t12
  t15 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t17 = t13 ** (0.1e1 / 0.3e1)
  t19 = f.my_piecewise3(t13 <= f.p.zeta_threshold, t15 * f.p.zeta_threshold, t17 * t13)
  t20 = r0 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t24 = t19 / t21 / r0
  t25 = t8 * t24
  t26 = jnp.pi ** 2
  t27 = jnp.sqrt(s0)
  t28 = 2 ** (0.1e1 / 0.3e1)
  t29 = t27 * t28
  t32 = t29 / t20 / r0
  t33 = 4 ** (0.1e1 / 0.3e1)
  t34 = jnp.sqrt(0.3e1)
  t35 = t26 * jnp.pi
  t36 = t34 * t35
  t37 = t36 ** (0.1e1 / 0.3e1)
  t38 = t33 * t37
  t39 = t32 < t38
  t40 = 3 ** (0.1e1 / 0.4e1)
  t41 = jnp.sqrt(0.2e1)
  t42 = t40 * t41
  t43 = jnp.sqrt(jnp.pi)
  t45 = 0.1e1 / t43 / jnp.pi
  t46 = t42 * t45
  t47 = t38 - 0.1e-9
  t48 = t47 < t32
  t49 = f.my_piecewise3(t48, t47, t32)
  t50 = t49 ** 2
  t52 = t26 ** 2
  t53 = t52 * t26
  t55 = t50 ** 2
  t56 = t55 * t50
  t57 = 0.48e2 * t53 - t56
  t58 = jnp.sqrt(t57)
  t59 = 0.4e1 * t36 + t58
  t60 = t59 ** (0.1e1 / 0.3e1)
  t61 = t60 ** 2
  t62 = t50 + t61
  t63 = jnp.sqrt(t62)
  t65 = t59 ** (0.1e1 / 0.6e1)
  t66 = 0.1e1 / t65
  t70 = jnp.asinh(t46 * t49 * t63 * t66 / 0.4e1)
  t71 = 0.1e1 / jnp.pi
  t72 = t38 + 0.1e-9
  t73 = t72 < t32
  t74 = f.my_piecewise3(t73, t32, t72)
  t75 = t74 ** 2
  t76 = t75 * t74
  t77 = t76 * t34
  t79 = t75 ** 2
  t80 = t79 * t75
  t83 = 0.3e1 / t53 * t80 - 0.144e3
  t84 = jnp.sqrt(t83)
  t86 = jnp.atan(t84 / 0.12e2)
  t87 = t86 / 0.3e1
  t88 = jnp.cos(t87)
  t89 = t71 * t88
  t90 = t77 * t89
  t91 = jnp.sqrt(t90)
  t94 = jnp.asinh(t71 * t91 / 0.2e1)
  t95 = f.my_piecewise3(t39, t70, t94)
  t97 = jnp.exp(-0.2e1 * t95)
  t98 = 0.1e1 + t97
  t99 = jnp.log(t98)
  t102 = my_dilog(-t97)
  t104 = -0.12e2 * t95 * t99 + 0.12e2 * t102 + t26
  t105 = 0.1e1 / t95
  t107 = 0.1e1 / jnp.cosh(t95)
  t108 = t107 ** (0.1e1 / 0.3e1)
  t109 = t108 ** 2
  t110 = 0.1e1 / t109
  t111 = t71 ** (0.1e1 / 0.3e1)
  t112 = 0.1e1 / t111
  t114 = t110 * t112 * t33
  t115 = t104 * t105 * t114
  t119 = t19 / t21
  t120 = t8 * t119
  t121 = r0 ** 2
  t125 = 0.4e1 / 0.3e1 * t29 / t20 / t121
  t126 = f.my_piecewise3(t48, 0, -t125)
  t131 = 0.1e1 / t63
  t132 = t49 * t131
  t134 = 0.1e1 / t60
  t135 = 0.1e1 / t58
  t136 = t134 * t135
  t137 = t55 * t49
  t141 = -0.2e1 * t136 * t137 * t126 + 0.2e1 * t49 * t126
  t142 = t66 * t141
  t147 = t42 * t45 * t56
  t149 = 0.1e1 / t65 / t59
  t150 = t63 * t149
  t151 = t135 * t126
  t155 = t46 * t126 * t63 * t66 / 0.4e1 + t46 * t132 * t142 / 0.8e1 + t147 * t150 * t151 / 0.8e1
  t156 = 0.1e1 / t35
  t157 = t34 * t156
  t162 = 0.2e1 * t157 * t50 * t62 * t134 + 0.16e2
  t163 = jnp.sqrt(t162)
  t164 = 0.1e1 / t163
  t168 = t71 / t91
  t169 = t75 * t34
  t170 = f.my_piecewise3(t73, -t125, 0)
  t174 = t169 * t71
  t175 = jnp.sin(t87)
  t177 = t175 / t84
  t178 = t177 * t170
  t181 = 0.3e1 * t169 * t89 * t170 - 0.12e2 * t174 * t178
  t184 = t77 * t156 * t88 + 0.4e1
  t185 = jnp.sqrt(t184)
  t186 = 0.1e1 / t185
  t187 = t181 * t186
  t190 = f.my_piecewise3(t39, 0.4e1 * t155 * t164, t168 * t187 / 0.2e1)
  t194 = 0.1e1 / t98
  t195 = t97 * t194
  t198 = 0.24e2 * t95 * t190 * t195 + 0.12e2 * t190 * t99
  t200 = t198 * t105 * t114
  t204 = t8 * t119 * t104
  t205 = t95 ** 2
  t206 = 0.1e1 / t205
  t207 = t206 * t110
  t208 = t112 * t33
  t210 = t207 * t208 * t190
  t214 = t105 * t110 * t112
  t215 = jnp.tanh(t95)
  t216 = t33 * t215
  t218 = t214 * t216 * t190
  t221 = t19 * t20
  t222 = t8 * t221
  t227 = 0.28e2 / 0.9e1 * t29 / t20 / t121 / r0
  t228 = f.my_piecewise3(t48, 0, t227)
  t233 = t126 * t131
  t237 = t126 ** 2
  t239 = t42 * t45 * t237
  t240 = t135 * t137
  t245 = 0.1e1 / t63 / t62
  t247 = t141 ** 2
  t248 = t66 * t247
  t252 = t131 * t149
  t253 = t141 * t135
  t262 = 0.1e1 / t60 / t59
  t263 = 0.1e1 / t57
  t264 = t262 * t263
  t265 = t55 ** 2
  t266 = t265 * t50
  t267 = t266 * t237
  t271 = 0.1e1 / t58 / t57
  t272 = t134 * t271
  t281 = -0.2e1 * t136 * t137 * t228 - 0.10e2 * t136 * t55 * t237 + 0.2e1 * t49 * t228 - 0.2e1 * t264 * t267 - 0.6e1 * t272 * t267 + 0.2e1 * t237
  t282 = t66 * t281
  t286 = t50 * t49
  t289 = t42 * t45 * t265 * t286
  t290 = t59 ** 2
  t292 = 0.1e1 / t65 / t290
  t293 = t63 * t292
  t294 = t263 * t237
  t298 = t271 * t237
  t302 = t135 * t228
  t306 = t46 * t228 * t63 * t66 / 0.4e1 + t46 * t233 * t142 / 0.4e1 + 0.7e1 / 0.8e1 * t239 * t150 * t240 - t46 * t49 * t245 * t248 / 0.16e2 + t147 * t252 * t253 * t126 / 0.8e1 + t46 * t132 * t282 / 0.8e1 + 0.7e1 / 0.16e2 * t289 * t293 * t294 + 0.3e1 / 0.8e1 * t289 * t150 * t298 + t147 * t150 * t302 / 0.8e1
  t310 = 0.1e1 / t163 / t162
  t311 = t155 * t310
  t312 = t157 * t49
  t313 = t62 * t134
  t321 = t55 * t286
  t322 = t157 * t321
  t323 = t62 * t262
  t327 = 0.2e1 * t157 * t50 * t141 * t134 + 0.4e1 * t312 * t313 * t126 + 0.2e1 * t322 * t323 * t151
  t333 = t71 / t91 / t90
  t334 = t181 ** 2
  t338 = t74 * t34
  t339 = t170 ** 2
  t343 = t338 * t71
  t344 = t177 * t339
  t347 = f.my_piecewise3(t73, t227, 0)
  t352 = t88 / t83
  t353 = t352 * t339
  t356 = t79 * t76
  t359 = 0.1e1 / t52 / t35
  t360 = t356 * t34 * t359
  t363 = t175 / t84 / t83
  t364 = t363 * t339
  t367 = t177 * t347
  t370 = 0.3e1 * t169 * t89 * t347 + 0.6e1 * t338 * t89 * t339 - 0.12e2 * t174 * t367 - 0.60e2 * t343 * t344 - 0.144e3 * t343 * t353 + 0.108e3 * t360 * t364
  t375 = 0.1e1 / t185 / t184
  t376 = t181 * t375
  t377 = t156 * t75
  t378 = t34 * t88
  t382 = t377 * t34
  t385 = 0.3e1 * t377 * t378 * t170 - 0.12e2 * t382 * t178
  t390 = f.my_piecewise3(t39, 0.4e1 * t306 * t164 - 0.2e1 * t311 * t327, -t333 * t334 * t186 / 0.4e1 + t168 * t370 * t186 / 0.2e1 - t168 * t376 * t385 / 0.4e1)
  t393 = t95 * t390
  t396 = t190 ** 2
  t397 = t95 * t396
  t400 = t97 ** 2
  t401 = t98 ** 2
  t402 = 0.1e1 / t401
  t403 = t400 * t402
  t406 = 0.24e2 * t393 * t195 - 0.48e2 * t397 * t195 + 0.12e2 * t390 * t99 + 0.48e2 * t397 * t403
  t408 = t406 * t105 * t114
  t412 = t8 * t221 * t198
  t418 = t8 * t221 * t104
  t421 = 0.1e1 / t205 / t95 * t110
  t423 = t421 * t208 * t396
  t426 = t207 * t112
  t429 = t426 * t33 * t396 * t215
  t433 = t207 * t208 * t390
  t436 = t215 ** 2
  t439 = t214 * t33 * t436 * t396
  t442 = 0.1e1 - t436
  t445 = t214 * t33 * t442 * t396
  t449 = t214 * t216 * t390
  t452 = t25 * t115 / 0.108e3 - t120 * t200 / 0.36e2 + t204 * t210 / 0.36e2 - t204 * t218 / 0.54e2 - t222 * t408 / 0.24e2 + t412 * t210 / 0.12e2 - t412 * t218 / 0.18e2 - t418 * t423 / 0.12e2 + t418 * t429 / 0.18e2 + t418 * t433 / 0.24e2 - t418 * t439 / 0.54e2 - t418 * t445 / 0.36e2 - t418 * t449 / 0.36e2
  t453 = f.my_piecewise3(t2, 0, t452)
  t455 = t421 * t112
  t461 = t396 * t190
  t462 = t33 * t461
  t481 = t121 ** 2
  t485 = 0.280e3 / 0.27e2 * t29 / t20 / t481
  t486 = f.my_piecewise3(t48, 0, -t485)
  t503 = 0.1e1 / t60 / t290
  t506 = t237 * t126
  t507 = t265 * t321 * t506
  t510 = t57 ** 2
  t511 = 0.1e1 / t510
  t516 = t265 * t49 * t506
  t520 = t266 * t126 * t228
  t524 = 0.1e1 / t58 / t510
  t542 = -0.30e2 * t136 * t55 * t126 * t228 - 0.54e2 * t134 * t524 * t507 - 0.2e1 * t136 * t137 * t486 - 0.40e2 * t136 * t286 * t506 - 0.18e2 * t262 * t511 * t507 - 0.8e1 * t503 * t271 * t507 + 0.6e1 * t126 * t228 - 0.30e2 * t264 * t516 - 0.6e1 * t264 * t520 - 0.90e2 * t272 * t516 - 0.18e2 * t272 * t520 + 0.2e1 * t49 * t486
  t553 = t42 * t45 * t506
  t579 = -0.3e1 / 0.16e2 * t46 * t126 * t245 * t248 + t46 * t486 * t63 * t66 / 0.4e1 + 0.3e1 / 0.8e1 * t46 * t228 * t131 * t142 + 0.3e1 / 0.8e1 * t46 * t233 * t282 + t46 * t132 * t66 * t542 / 0.8e1 + 0.9e1 / 0.8e1 * t289 * t150 * t271 * t126 * t228 + 0.35e2 / 0.8e1 * t553 * t150 * t135 * t55 - 0.3e1 / 0.32e2 * t147 * t245 * t149 * t247 * t135 * t126 + 0.3e1 / 0.16e2 * t147 * t252 * t281 * t135 * t126 + 0.3e1 / 0.16e2 * t147 * t252 * t253 * t228 + 0.21e2 / 0.32e2 * t289 * t131 * t292 * t141 * t263 * t237
  t608 = t62 ** 2
  t624 = t265 ** 2
  t626 = t42 * t45 * t624
  t647 = 0.9e1 / 0.16e2 * t289 * t252 * t141 * t271 * t237 + 0.21e2 / 0.16e2 * t289 * t293 * t263 * t126 * t228 + 0.21e2 / 0.8e1 * t42 * t45 * t228 * t150 * t240 * t126 + 0.21e2 / 0.16e2 * t239 * t252 * t253 * t137 + 0.63e2 / 0.8e1 * t553 * t293 * t263 * t266 + 0.27e2 / 0.4e1 * t553 * t150 * t271 * t266 + 0.3e1 / 0.32e2 * t46 * t49 / t63 / t608 * t66 * t247 * t141 - 0.3e1 / 0.16e2 * t42 * t45 * t49 * t245 * t66 * t141 * t281 + 0.91e2 / 0.32e2 * t626 * t63 / t65 / t290 / t59 * t271 * t506 + 0.63e2 / 0.16e2 * t626 * t293 * t511 * t506 + 0.27e2 / 0.8e1 * t626 * t150 * t524 * t506 + t147 * t150 * t135 * t486 / 0.8e1
  t654 = t162 ** 2
  t658 = t327 ** 2
  t686 = t157 * t265 * t55
  t703 = t88 ** 2
  t720 = t339 * t170
  t724 = t34 * t71
  t736 = t80 * t34 * t359
  t737 = t363 * t720
  t740 = t170 * t347
  t744 = f.my_piecewise3(t73, -t485, 0)
  t750 = t83 ** 2
  t759 = t79 ** 2
  t763 = t52 ** 2
  t779 = 0.6e1 * t720 * t34 * t89 - 0.132e3 * t724 * t177 * t720 + 0.18e2 * t343 * t88 * t170 * t347 - 0.864e3 * t724 * t352 * t720 + 0.1296e4 * t736 * t737 - 0.180e3 * t343 * t177 * t740 + 0.3e1 * t169 * t89 * t744 + 0.1728e4 * t724 * t737 + 0.3888e4 * t736 * t88 / t750 * t720 - 0.432e3 * t343 * t352 * t740 - 0.2916e4 * t759 * t79 * t34 / t763 / t52 / jnp.pi * t175 / t84 / t750 * t720 + 0.324e3 * t360 * t363 * t740 - 0.12e2 * t174 * t177 * t744
  t787 = t184 ** 2
  t791 = t385 ** 2
  t795 = t156 * t74
  t799 = t795 * t34
  t820 = f.my_piecewise3(t39, 0.4e1 * (t579 + t647) * t164 - 0.4e1 * t306 * t310 * t327 + 0.3e1 * t155 / t163 / t654 * t658 - 0.2e1 * t311 * (0.18e2 * t157 * t56 * t323 * t237 * t135 + 0.8e1 * t312 * t141 * t134 * t126 + 0.4e1 * t157 * t237 * t62 * t134 + 0.2e1 * t157 * t50 * t281 * t134 + 0.4e1 * t322 * t141 * t262 * t151 + 0.8e1 * t686 * t62 * t503 * t294 + 0.4e1 * t312 * t313 * t228 + 0.6e1 * t686 * t323 * t298 + 0.2e1 * t322 * t323 * t302), t71 / t91 / t80 * t26 / t703 * t334 * t181 * t186 / 0.8e1 - 0.3e1 / 0.4e1 * t333 * t187 * t370 + t333 * t334 * t375 * t385 / 0.4e1 + t168 * t779 * t186 / 0.2e1 - t168 * t370 * t375 * t385 / 0.2e1 + 0.3e1 / 0.8e1 * t168 * t181 / t185 / t787 * t791 - t168 * t376 * (0.6e1 * t795 * t378 * t339 - 0.60e2 * t799 * t344 + 0.3e1 * t377 * t378 * t347 - 0.144e3 * t799 * t353 + 0.108e3 / t763 / jnp.pi * t356 * t34 * t364 - 0.12e2 * t382 * t367) / 0.4e1)
  t834 = t8 * t24 * t104
  t838 = t8 * t119 * t198
  t848 = t8 * t221 * t406
  t855 = -t418 * t455 * t33 * t190 * t390 / 0.4e1 - t418 * t455 * t462 * t215 / 0.6e1 + t418 * t426 * t462 * t436 / 0.18e2 - t418 * t214 * t33 * t436 * t215 * t461 / 0.81e2 - t418 * t214 * t216 * t820 / 0.36e2 + t418 * t426 * t462 * t442 / 0.12e2 - t412 * t445 / 0.12e2 - t204 * t445 / 0.36e2 + t834 * t218 / 0.54e2 - t838 * t218 / 0.18e2 + t204 * t429 / 0.18e2 - t204 * t449 / 0.36e2 - t204 * t439 / 0.54e2 - t848 * t218 / 0.12e2 + t412 * t429 / 0.6e1 - t412 * t449 / 0.12e2
  t879 = t95 * t461
  t902 = t8 * t19
  t903 = t20 * t104
  t905 = t902 * t903 * t105
  t927 = t205 ** 2
  t948 = -t412 * t439 / 0.18e2 - 0.5e1 / 0.324e3 * t8 * t19 / t21 / t121 * t115 - t222 * (0.12e2 * t820 * t99 + 0.24e2 * t95 * t820 * t195 - 0.144e3 * t393 * t190 * t97 * t194 + 0.144e3 * t393 * t403 * t190 - 0.48e2 * t461 * t97 * t194 + 0.96e2 * t879 * t195 - 0.288e3 * t879 * t403 + 0.48e2 * t461 * t400 * t402 + 0.192e3 * t879 * t400 * t97 / t401 / t98) * t105 * t114 / 0.24e2 + t25 * t200 / 0.36e2 - t120 * t408 / 0.24e2 - t905 * t114 * t436 * t190 * t390 / 0.18e2 - t905 * t114 * t442 * t190 * t390 / 0.12e2 + t902 * t903 * t206 * t114 * t190 * t215 * t390 / 0.6e1 - t204 * t423 / 0.12e2 - t412 * t423 / 0.4e1 + t418 / t927 * t110 * t208 * t461 / 0.4e1 + t418 * t207 * t208 * t820 / 0.24e2 + t412 * t433 / 0.8e1 + t848 * t210 / 0.8e1 + t204 * t433 / 0.24e2 + t838 * t210 / 0.12e2 - t834 * t210 / 0.36e2
  t950 = f.my_piecewise3(t2, 0, t855 + t948)
  v3rho3_0_ = 0.2e1 * r0 * t950 + 0.6e1 * t453

  res = {'v3rho3': v3rho3_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = t3 / t4 / jnp.pi
  t8 = r0 + r1
  t9 = 0.1e1 / t8
  t12 = 0.2e1 * r0 * t9 <= f.p.zeta_threshold
  t13 = f.p.zeta_threshold - 0.1e1
  t16 = 0.2e1 * r1 * t9 <= f.p.zeta_threshold
  t17 = -t13
  t18 = r0 - r1
  t19 = t18 * t9
  t20 = f.my_piecewise5(t12, t13, t16, t17, t19)
  t21 = 0.1e1 + t20
  t22 = t21 <= f.p.zeta_threshold
  t23 = t21 ** (0.1e1 / 0.3e1)
  t24 = t8 ** 2
  t25 = 0.1e1 / t24
  t26 = t18 * t25
  t27 = t9 - t26
  t28 = f.my_piecewise5(t12, 0, t16, 0, t27)
  t31 = f.my_piecewise3(t22, 0, 0.4e1 / 0.3e1 * t23 * t28)
  t32 = t8 ** (0.1e1 / 0.3e1)
  t33 = t31 * t32
  t34 = t7 * t33
  t35 = jnp.pi ** 2
  t36 = jnp.sqrt(s0)
  t37 = r0 ** (0.1e1 / 0.3e1)
  t40 = t36 / t37 / r0
  t41 = 4 ** (0.1e1 / 0.3e1)
  t42 = jnp.sqrt(0.3e1)
  t43 = t35 * jnp.pi
  t44 = t42 * t43
  t45 = t44 ** (0.1e1 / 0.3e1)
  t46 = t41 * t45
  t47 = t40 < t46
  t48 = 3 ** (0.1e1 / 0.4e1)
  t49 = jnp.sqrt(0.2e1)
  t50 = t48 * t49
  t51 = jnp.sqrt(jnp.pi)
  t53 = 0.1e1 / t51 / jnp.pi
  t54 = t50 * t53
  t55 = t46 - 0.1e-9
  t56 = t55 < t40
  t57 = f.my_piecewise3(t56, t55, t40)
  t58 = t57 ** 2
  t59 = 0.4e1 * t44
  t60 = t35 ** 2
  t61 = t60 * t35
  t62 = 0.48e2 * t61
  t63 = t58 ** 2
  t64 = t63 * t58
  t65 = t62 - t64
  t66 = jnp.sqrt(t65)
  t67 = t59 + t66
  t68 = t67 ** (0.1e1 / 0.3e1)
  t69 = t68 ** 2
  t70 = t58 + t69
  t71 = jnp.sqrt(t70)
  t73 = t67 ** (0.1e1 / 0.6e1)
  t74 = 0.1e1 / t73
  t78 = jnp.arcsinh(t54 * t57 * t71 * t74 / 0.4e1)
  t79 = 0.1e1 / jnp.pi
  t80 = t46 + 0.1e-9
  t81 = t80 < t40
  t82 = f.my_piecewise3(t81, t40, t80)
  t83 = t82 ** 2
  t84 = t83 * t82
  t85 = t84 * t42
  t86 = 0.1e1 / t61
  t87 = t83 ** 2
  t91 = 0.3e1 * t86 * t87 * t83 - 0.144e3
  t92 = jnp.sqrt(t91)
  t94 = jnp.arctan(t92 / 0.12e2)
  t95 = t94 / 0.3e1
  t96 = jnp.cos(t95)
  t97 = t79 * t96
  t98 = t85 * t97
  t99 = jnp.sqrt(t98)
  t102 = jnp.arcsinh(t79 * t99 / 0.2e1)
  t103 = f.my_piecewise3(t47, t78, t102)
  t105 = jnp.exp(-0.2e1 * t103)
  t106 = 0.1e1 + t105
  t107 = jnp.log(t106)
  t110 = my_dilog(-t105)
  t112 = -0.12e2 * t103 * t107 + 0.12e2 * t110 + t35
  t113 = 0.1e1 / t103
  t115 = 0.1e1 / jnp.cosh(t103)
  t116 = t115 ** (0.1e1 / 0.3e1)
  t117 = t116 ** 2
  t118 = 0.1e1 / t117
  t119 = t79 ** (0.1e1 / 0.3e1)
  t120 = 0.1e1 / t119
  t122 = t118 * t120 * t41
  t123 = t112 * t113 * t122
  t126 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t127 = t126 * f.p.zeta_threshold
  t129 = f.my_piecewise3(t22, t127, t23 * t21)
  t130 = t32 ** 2
  t131 = 0.1e1 / t130
  t132 = t129 * t131
  t133 = t7 * t132
  t135 = t133 * t123 / 0.72e2
  t136 = t129 * t32
  t137 = t7 * t136
  t138 = r0 ** 2
  t142 = 0.4e1 / 0.3e1 * t36 / t37 / t138
  t143 = f.my_piecewise3(t56, 0, -t142)
  t148 = 0.1e1 / t71
  t149 = t57 * t148
  t151 = 0.1e1 / t68
  t152 = 0.1e1 / t66
  t153 = t151 * t152
  t154 = t63 * t57
  t158 = -0.2e1 * t153 * t154 * t143 + 0.2e1 * t57 * t143
  t159 = t74 * t158
  t164 = t50 * t53 * t64
  t166 = 0.1e1 / t73 / t67
  t167 = t71 * t166
  t168 = t152 * t143
  t172 = t54 * t143 * t71 * t74 / 0.4e1 + t54 * t149 * t159 / 0.8e1 + t164 * t167 * t168 / 0.8e1
  t173 = 0.1e1 / t43
  t174 = t42 * t173
  t179 = 0.2e1 * t174 * t58 * t70 * t151 + 0.16e2
  t180 = jnp.sqrt(t179)
  t181 = 0.1e1 / t180
  t185 = t79 / t99
  t186 = t83 * t42
  t187 = f.my_piecewise3(t81, -t142, 0)
  t191 = t186 * t79
  t192 = jnp.sin(t95)
  t194 = t192 / t92
  t195 = t194 * t187
  t198 = 0.3e1 * t186 * t97 * t187 - 0.12e2 * t191 * t195
  t201 = t85 * t173 * t96 + 0.4e1
  t202 = jnp.sqrt(t201)
  t203 = 0.1e1 / t202
  t207 = f.my_piecewise3(t47, 0.4e1 * t172 * t181, t185 * t198 * t203 / 0.2e1)
  t212 = t105 / t106
  t215 = 0.24e2 * t103 * t207 * t212 + 0.12e2 * t207 * t107
  t217 = t215 * t113 * t122
  t221 = t7 * t136 * t112
  t222 = t103 ** 2
  t224 = 0.1e1 / t222 * t118
  t225 = t120 * t41
  t227 = t224 * t225 * t207
  t231 = t113 * t118 * t120
  t232 = jnp.tanh(t103)
  t233 = t41 * t232
  t235 = t231 * t233 * t207
  t239 = f.my_piecewise3(t1, 0, -t34 * t123 / 0.24e2 - t135 - t137 * t217 / 0.24e2 + t221 * t227 / 0.24e2 - t221 * t235 / 0.36e2)
  t241 = r1 <= f.p.dens_threshold
  t242 = f.my_piecewise5(t16, t13, t12, t17, -t19)
  t243 = 0.1e1 + t242
  t244 = t243 <= f.p.zeta_threshold
  t245 = t243 ** (0.1e1 / 0.3e1)
  t247 = f.my_piecewise5(t16, 0, t12, 0, -t27)
  t250 = f.my_piecewise3(t244, 0, 0.4e1 / 0.3e1 * t245 * t247)
  t251 = t250 * t32
  t252 = t7 * t251
  t253 = jnp.sqrt(s2)
  t254 = r1 ** (0.1e1 / 0.3e1)
  t257 = t253 / t254 / r1
  t258 = t257 < t46
  t259 = t55 < t257
  t260 = f.my_piecewise3(t259, t55, t257)
  t261 = t260 ** 2
  t262 = t261 ** 2
  t263 = t262 * t261
  t264 = t62 - t263
  t265 = jnp.sqrt(t264)
  t266 = t59 + t265
  t267 = t266 ** (0.1e1 / 0.3e1)
  t268 = t267 ** 2
  t269 = t261 + t268
  t270 = jnp.sqrt(t269)
  t272 = t266 ** (0.1e1 / 0.6e1)
  t273 = 0.1e1 / t272
  t277 = jnp.arcsinh(t54 * t260 * t270 * t273 / 0.4e1)
  t278 = t80 < t257
  t279 = f.my_piecewise3(t278, t257, t80)
  t280 = t279 ** 2
  t281 = t280 * t279
  t282 = t281 * t42
  t283 = t280 ** 2
  t287 = 0.3e1 * t86 * t283 * t280 - 0.144e3
  t288 = jnp.sqrt(t287)
  t290 = jnp.arctan(t288 / 0.12e2)
  t291 = t290 / 0.3e1
  t292 = jnp.cos(t291)
  t293 = t79 * t292
  t294 = t282 * t293
  t295 = jnp.sqrt(t294)
  t298 = jnp.arcsinh(t79 * t295 / 0.2e1)
  t299 = f.my_piecewise3(t258, t277, t298)
  t301 = jnp.exp(-0.2e1 * t299)
  t302 = 0.1e1 + t301
  t303 = jnp.log(t302)
  t306 = my_dilog(-t301)
  t308 = -0.12e2 * t299 * t303 + 0.12e2 * t306 + t35
  t309 = 0.1e1 / t299
  t311 = 0.1e1 / jnp.cosh(t299)
  t312 = t311 ** (0.1e1 / 0.3e1)
  t313 = t312 ** 2
  t314 = 0.1e1 / t313
  t316 = t314 * t120 * t41
  t317 = t308 * t309 * t316
  t321 = f.my_piecewise3(t244, t127, t245 * t243)
  t322 = t321 * t131
  t323 = t7 * t322
  t325 = t323 * t317 / 0.72e2
  t327 = f.my_piecewise3(t241, 0, -t252 * t317 / 0.24e2 - t325)
  t333 = 0.28e2 / 0.9e1 * t36 / t37 / t138 / r0
  t334 = f.my_piecewise3(t56, 0, t333)
  t343 = t143 ** 2
  t353 = t158 ** 2
  t368 = 0.1e1 / t68 / t67
  t369 = 0.1e1 / t65
  t371 = t63 ** 2
  t373 = t371 * t58 * t343
  t377 = 0.1e1 / t66 / t65
  t392 = t58 * t57
  t395 = t50 * t53 * t371 * t392
  t396 = t67 ** 2
  t440 = t198 ** 2
  t444 = t82 * t42
  t445 = t187 ** 2
  t449 = t444 * t79
  t453 = f.my_piecewise3(t81, t333, 0)
  t465 = 0.1e1 / t60 / t43
  t483 = t173 * t83
  t496 = f.my_piecewise3(t47, 0.4e1 * (t54 * t334 * t71 * t74 / 0.4e1 + t54 * t143 * t148 * t159 / 0.4e1 + 0.7e1 / 0.8e1 * t50 * t53 * t343 * t167 * t152 * t154 - t54 * t57 / t71 / t70 * t74 * t353 / 0.16e2 + t164 * t148 * t166 * t158 * t152 * t143 / 0.8e1 + t54 * t149 * t74 * (-0.6e1 * t151 * t377 * t373 - 0.2e1 * t153 * t154 * t334 - 0.10e2 * t153 * t63 * t343 - 0.2e1 * t368 * t369 * t373 + 0.2e1 * t57 * t334 + 0.2e1 * t343) / 0.8e1 + 0.7e1 / 0.16e2 * t395 * t71 / t73 / t396 * t369 * t343 + 0.3e1 / 0.8e1 * t395 * t167 * t377 * t343 + t164 * t167 * t152 * t334 / 0.8e1) * t181 - 0.2e1 * t172 / t180 / t179 * (0.2e1 * t174 * t63 * t392 * t70 * t368 * t168 + 0.4e1 * t174 * t57 * t70 * t151 * t143 + 0.2e1 * t174 * t58 * t158 * t151), -t79 / t99 / t98 * t440 * t203 / 0.4e1 + t185 * (0.6e1 * t444 * t97 * t445 - 0.60e2 * t449 * t194 * t445 + 0.3e1 * t186 * t97 * t453 - 0.144e3 * t449 * t96 / t91 * t445 + 0.108e3 * t87 * t84 * t42 * t465 * t192 / t92 / t91 * t445 - 0.12e2 * t191 * t194 * t453) * t203 / 0.2e1 - t185 * t198 / t202 / t201 * (0.3e1 * t483 * t42 * t96 * t187 - 0.12e2 * t483 * t42 * t195) / 0.4e1)
  t502 = t7 * t136 * t215
  t507 = t7 * t31 * t131 * t123
  t510 = t7 * t33 * t112
  t514 = 0.1e1 / t130 / t8
  t518 = t7 * t129 * t514 * t123 / 0.108e3
  t520 = t7 * t132 * t112
  t521 = t520 * t227
  t524 = t207 ** 2
  t534 = t232 ** 2
  t542 = t520 * t235
  t559 = t23 ** 2
  t560 = 0.1e1 / t559
  t561 = t28 ** 2
  t566 = t18 / t24 / t8
  t568 = -0.2e1 * t25 + 0.2e1 * t566
  t569 = f.my_piecewise5(t12, 0, t16, 0, t568)
  t573 = f.my_piecewise3(t22, 0, 0.4e1 / 0.9e1 * t560 * t561 + 0.4e1 / 0.3e1 * t23 * t569)
  t580 = t133 * t217
  t587 = t103 * t524
  t590 = t105 ** 2
  t591 = t106 ** 2
  t601 = t221 * t224 * t225 * t496 / 0.24e2 + t502 * t227 / 0.12e2 - t507 / 0.36e2 + t510 * t227 / 0.12e2 + t518 + t521 / 0.36e2 + t221 * t224 * t120 * t41 * t524 * t232 / 0.18e2 - t221 * t231 * t233 * t496 / 0.36e2 - t221 * t231 * t41 * t534 * t524 / 0.54e2 - t510 * t235 / 0.18e2 - t542 / 0.54e2 - t502 * t235 / 0.18e2 - t221 / t222 / t103 * t118 * t225 * t524 / 0.12e2 - t221 * t231 * t41 * (0.1e1 - t534) * t524 / 0.36e2 - t7 * t573 * t32 * t123 / 0.24e2 - t34 * t217 / 0.12e2 - t580 / 0.36e2 - t137 * (0.12e2 * t496 * t107 + 0.24e2 * t103 * t496 * t212 - 0.48e2 * t587 * t212 + 0.48e2 * t587 * t590 / t591) * t113 * t122 / 0.24e2
  t602 = f.my_piecewise3(t1, 0, t601)
  t603 = t245 ** 2
  t604 = 0.1e1 / t603
  t605 = t247 ** 2
  t609 = f.my_piecewise5(t16, 0, t12, 0, -t568)
  t613 = f.my_piecewise3(t244, 0, 0.4e1 / 0.9e1 * t604 * t605 + 0.4e1 / 0.3e1 * t245 * t609)
  t620 = t7 * t250 * t131 * t317
  t625 = t7 * t321 * t514 * t317 / 0.108e3
  t627 = f.my_piecewise3(t241, 0, -t7 * t613 * t32 * t317 / 0.24e2 - t620 / 0.36e2 + t625)
  d11 = 0.2e1 * t239 + 0.2e1 * t327 + t8 * (t602 + t627)
  t630 = -t9 - t26
  t631 = f.my_piecewise5(t12, 0, t16, 0, t630)
  t634 = f.my_piecewise3(t22, 0, 0.4e1 / 0.3e1 * t23 * t631)
  t635 = t634 * t32
  t636 = t7 * t635
  t640 = f.my_piecewise3(t1, 0, -t636 * t123 / 0.24e2 - t135)
  t642 = f.my_piecewise5(t16, 0, t12, 0, -t630)
  t645 = f.my_piecewise3(t244, 0, 0.4e1 / 0.3e1 * t245 * t642)
  t646 = t645 * t32
  t647 = t7 * t646
  t650 = t321 * t32
  t651 = t7 * t650
  t652 = r1 ** 2
  t656 = 0.4e1 / 0.3e1 * t253 / t254 / t652
  t657 = f.my_piecewise3(t259, 0, -t656)
  t662 = 0.1e1 / t270
  t663 = t260 * t662
  t665 = 0.1e1 / t267
  t666 = 0.1e1 / t265
  t667 = t665 * t666
  t668 = t262 * t260
  t672 = -0.2e1 * t667 * t668 * t657 + 0.2e1 * t260 * t657
  t673 = t273 * t672
  t678 = t50 * t53 * t263
  t680 = 0.1e1 / t272 / t266
  t681 = t270 * t680
  t682 = t666 * t657
  t686 = t54 * t657 * t270 * t273 / 0.4e1 + t54 * t663 * t673 / 0.8e1 + t678 * t681 * t682 / 0.8e1
  t691 = 0.2e1 * t174 * t261 * t269 * t665 + 0.16e2
  t692 = jnp.sqrt(t691)
  t693 = 0.1e1 / t692
  t697 = t79 / t295
  t698 = t280 * t42
  t699 = f.my_piecewise3(t278, -t656, 0)
  t703 = t698 * t79
  t704 = jnp.sin(t291)
  t706 = t704 / t288
  t707 = t706 * t699
  t710 = 0.3e1 * t698 * t293 * t699 - 0.12e2 * t703 * t707
  t713 = t282 * t173 * t292 + 0.4e1
  t714 = jnp.sqrt(t713)
  t715 = 0.1e1 / t714
  t719 = f.my_piecewise3(t258, 0.4e1 * t686 * t693, t697 * t710 * t715 / 0.2e1)
  t724 = t301 / t302
  t727 = 0.24e2 * t299 * t719 * t724 + 0.12e2 * t719 * t303
  t729 = t727 * t309 * t316
  t733 = t7 * t650 * t308
  t734 = t299 ** 2
  t736 = 0.1e1 / t734 * t314
  t738 = t736 * t225 * t719
  t742 = t309 * t314 * t120
  t743 = jnp.tanh(t299)
  t744 = t41 * t743
  t746 = t742 * t744 * t719
  t750 = f.my_piecewise3(t241, 0, -t647 * t317 / 0.24e2 - t325 - t651 * t729 / 0.24e2 + t733 * t738 / 0.24e2 - t733 * t746 / 0.36e2)
  t754 = 0.2e1 * t566
  t755 = f.my_piecewise5(t12, 0, t16, 0, t754)
  t759 = f.my_piecewise3(t22, 0, 0.4e1 / 0.9e1 * t560 * t631 * t28 + 0.4e1 / 0.3e1 * t23 * t755)
  t766 = t7 * t634 * t131 * t123
  t771 = t7 * t635 * t112
  t781 = f.my_piecewise3(t1, 0, -t7 * t759 * t32 * t123 / 0.24e2 - t766 / 0.72e2 - t636 * t217 / 0.24e2 + t771 * t227 / 0.24e2 - t771 * t235 / 0.36e2 - t507 / 0.72e2 + t518 - t580 / 0.72e2 + t521 / 0.72e2 - t542 / 0.108e3)
  t785 = f.my_piecewise5(t16, 0, t12, 0, -t754)
  t789 = f.my_piecewise3(t244, 0, 0.4e1 / 0.9e1 * t604 * t642 * t247 + 0.4e1 / 0.3e1 * t245 * t785)
  t796 = t7 * t645 * t131 * t317
  t801 = t323 * t729
  t804 = t7 * t251 * t308
  t808 = t7 * t322 * t308
  t809 = t808 * t738
  t813 = t808 * t746
  t816 = f.my_piecewise3(t241, 0, -t7 * t789 * t32 * t317 / 0.24e2 - t796 / 0.72e2 - t620 / 0.72e2 + t625 - t252 * t729 / 0.24e2 - t801 / 0.72e2 + t804 * t738 / 0.24e2 + t809 / 0.72e2 - t804 * t746 / 0.36e2 - t813 / 0.108e3)
  d12 = t239 + t327 + t640 + t750 + t8 * (t781 + t816)
  t821 = t631 ** 2
  t825 = 0.2e1 * t25 + 0.2e1 * t566
  t826 = f.my_piecewise5(t12, 0, t16, 0, t825)
  t830 = f.my_piecewise3(t22, 0, 0.4e1 / 0.9e1 * t560 * t821 + 0.4e1 / 0.3e1 * t23 * t826)
  t837 = f.my_piecewise3(t1, 0, -t7 * t830 * t32 * t123 / 0.24e2 - t766 / 0.36e2 + t518)
  t839 = t719 ** 2
  t849 = 0.28e2 / 0.9e1 * t253 / t254 / t652 / r1
  t850 = f.my_piecewise3(t259, 0, t849)
  t859 = t657 ** 2
  t869 = t672 ** 2
  t884 = 0.1e1 / t267 / t266
  t885 = 0.1e1 / t264
  t887 = t262 ** 2
  t889 = t887 * t261 * t859
  t893 = 0.1e1 / t265 / t264
  t908 = t261 * t260
  t911 = t50 * t53 * t887 * t908
  t912 = t266 ** 2
  t956 = t710 ** 2
  t960 = t279 * t42
  t961 = t699 ** 2
  t965 = t960 * t79
  t969 = f.my_piecewise3(t278, t849, 0)
  t997 = t173 * t280
  t1010 = f.my_piecewise3(t258, 0.4e1 * (t54 * t850 * t270 * t273 / 0.4e1 + t54 * t657 * t662 * t673 / 0.4e1 + 0.7e1 / 0.8e1 * t50 * t53 * t859 * t681 * t666 * t668 - t54 * t260 / t270 / t269 * t273 * t869 / 0.16e2 + t678 * t662 * t680 * t672 * t666 * t657 / 0.8e1 + t54 * t663 * t273 * (-0.10e2 * t667 * t262 * t859 - 0.6e1 * t665 * t893 * t889 - 0.2e1 * t667 * t668 * t850 - 0.2e1 * t884 * t885 * t889 + 0.2e1 * t260 * t850 + 0.2e1 * t859) / 0.8e1 + 0.7e1 / 0.16e2 * t911 * t270 / t272 / t912 * t885 * t859 + 0.3e1 / 0.8e1 * t911 * t681 * t893 * t859 + t678 * t681 * t666 * t850 / 0.8e1) * t693 - 0.2e1 * t686 / t692 / t691 * (0.2e1 * t174 * t262 * t908 * t269 * t884 * t682 + 0.4e1 * t174 * t260 * t269 * t665 * t657 + 0.2e1 * t174 * t261 * t672 * t665), -t79 / t295 / t294 * t956 * t715 / 0.4e1 + t697 * (0.6e1 * t960 * t293 * t961 - 0.60e2 * t965 * t706 * t961 + 0.3e1 * t698 * t293 * t969 - 0.144e3 * t965 * t292 / t287 * t961 + 0.108e3 * t283 * t281 * t42 * t465 * t704 / t288 / t287 * t961 - 0.12e2 * t703 * t706 * t969) * t715 / 0.2e1 - t697 * t710 / t714 / t713 * (0.3e1 * t997 * t42 * t292 * t699 - 0.12e2 * t997 * t42 * t707) / 0.4e1)
  t1015 = t743 ** 2
  t1022 = t7 * t646 * t308
  t1027 = t7 * t650 * t727
  t1053 = t642 ** 2
  t1057 = f.my_piecewise5(t16, 0, t12, 0, -t825)
  t1061 = f.my_piecewise3(t244, 0, 0.4e1 / 0.9e1 * t604 * t1053 + 0.4e1 / 0.3e1 * t245 * t1057)
  t1074 = t299 * t839
  t1077 = t301 ** 2
  t1078 = t302 ** 2
  t1088 = t733 * t736 * t120 * t41 * t839 * t743 / 0.18e2 - t733 * t742 * t744 * t1010 / 0.36e2 - t733 * t742 * t41 * t1015 * t839 / 0.54e2 - t1022 * t746 / 0.18e2 - t813 / 0.54e2 - t1027 * t746 / 0.18e2 - t733 / t734 / t299 * t314 * t225 * t839 / 0.12e2 + t1027 * t738 / 0.12e2 + t733 * t736 * t225 * t1010 / 0.24e2 + t625 + t809 / 0.36e2 - t796 / 0.36e2 + t1022 * t738 / 0.12e2 - t733 * t742 * t41 * (0.1e1 - t1015) * t839 / 0.36e2 - t7 * t1061 * t32 * t317 / 0.24e2 - t647 * t729 / 0.12e2 - t801 / 0.36e2 - t651 * (0.12e2 * t1010 * t303 + 0.24e2 * t299 * t1010 * t724 - 0.48e2 * t1074 * t724 + 0.48e2 * t1074 * t1077 / t1078) * t309 * t316 / 0.24e2
  t1089 = f.my_piecewise3(t241, 0, t1088)
  d22 = 0.2e1 * t640 + 0.2e1 * t750 + t8 * (t837 + t1089)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = t3 / t4 / jnp.pi
  t8 = r0 + r1
  t9 = 0.1e1 / t8
  t12 = 0.2e1 * r0 * t9 <= f.p.zeta_threshold
  t13 = f.p.zeta_threshold - 0.1e1
  t16 = 0.2e1 * r1 * t9 <= f.p.zeta_threshold
  t17 = -t13
  t18 = r0 - r1
  t19 = t18 * t9
  t20 = f.my_piecewise5(t12, t13, t16, t17, t19)
  t21 = 0.1e1 + t20
  t22 = t21 <= f.p.zeta_threshold
  t23 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t24 = t23 * f.p.zeta_threshold
  t25 = t21 ** (0.1e1 / 0.3e1)
  t27 = f.my_piecewise3(t22, t24, t25 * t21)
  t28 = t8 ** (0.1e1 / 0.3e1)
  t29 = t27 * t28
  t30 = jnp.pi ** 2
  t31 = jnp.sqrt(s0)
  t32 = r0 ** (0.1e1 / 0.3e1)
  t35 = t31 / t32 / r0
  t36 = 4 ** (0.1e1 / 0.3e1)
  t37 = jnp.sqrt(0.3e1)
  t38 = t30 * jnp.pi
  t39 = t37 * t38
  t40 = t39 ** (0.1e1 / 0.3e1)
  t41 = t36 * t40
  t42 = t35 < t41
  t43 = 3 ** (0.1e1 / 0.4e1)
  t44 = jnp.sqrt(0.2e1)
  t45 = t43 * t44
  t46 = jnp.sqrt(jnp.pi)
  t48 = 0.1e1 / t46 / jnp.pi
  t49 = t45 * t48
  t50 = t41 - 0.1e-9
  t51 = t50 < t35
  t52 = f.my_piecewise3(t51, t50, t35)
  t53 = t52 ** 2
  t54 = 0.4e1 * t39
  t55 = t30 ** 2
  t56 = t55 * t30
  t57 = 0.48e2 * t56
  t58 = t53 ** 2
  t59 = t58 * t53
  t60 = t57 - t59
  t61 = jnp.sqrt(t60)
  t62 = t54 + t61
  t63 = t62 ** (0.1e1 / 0.3e1)
  t64 = t63 ** 2
  t65 = t53 + t64
  t66 = jnp.sqrt(t65)
  t68 = t62 ** (0.1e1 / 0.6e1)
  t69 = 0.1e1 / t68
  t73 = jnp.asinh(t49 * t52 * t66 * t69 / 0.4e1)
  t74 = 0.1e1 / jnp.pi
  t75 = t41 + 0.1e-9
  t76 = t75 < t35
  t77 = f.my_piecewise3(t76, t35, t75)
  t78 = t77 ** 2
  t79 = t78 * t77
  t80 = t79 * t37
  t81 = 0.1e1 / t56
  t82 = t78 ** 2
  t83 = t82 * t78
  t86 = 0.3e1 * t81 * t83 - 0.144e3
  t87 = jnp.sqrt(t86)
  t89 = jnp.atan(t87 / 0.12e2)
  t90 = t89 / 0.3e1
  t91 = jnp.cos(t90)
  t92 = t74 * t91
  t93 = t80 * t92
  t94 = jnp.sqrt(t93)
  t97 = jnp.asinh(t74 * t94 / 0.2e1)
  t98 = f.my_piecewise3(t42, t73, t97)
  t100 = jnp.exp(-0.2e1 * t98)
  t101 = 0.1e1 + t100
  t102 = jnp.log(t101)
  t105 = my_dilog(-t100)
  t107 = -0.12e2 * t98 * t102 + 0.12e2 * t105 + t30
  t109 = t7 * t29 * t107
  t110 = t98 ** 2
  t111 = 0.1e1 / t110
  t112 = 0.1e1 / jnp.cosh(t98)
  t113 = t112 ** (0.1e1 / 0.3e1)
  t114 = t113 ** 2
  t115 = 0.1e1 / t114
  t116 = t111 * t115
  t117 = t74 ** (0.1e1 / 0.3e1)
  t118 = 0.1e1 / t117
  t119 = t118 * t36
  t120 = r0 ** 2
  t125 = 0.28e2 / 0.9e1 * t31 / t32 / t120 / r0
  t126 = f.my_piecewise3(t51, 0, t125)
  t134 = 0.4e1 / 0.3e1 * t31 / t32 / t120
  t135 = f.my_piecewise3(t51, 0, -t134)
  t136 = 0.1e1 / t66
  t137 = t135 * t136
  t139 = 0.1e1 / t63
  t140 = 0.1e1 / t61
  t141 = t139 * t140
  t142 = t58 * t52
  t146 = -0.2e1 * t141 * t142 * t135 + 0.2e1 * t52 * t135
  t147 = t69 * t146
  t151 = t135 ** 2
  t153 = t45 * t48 * t151
  t155 = 0.1e1 / t68 / t62
  t156 = t66 * t155
  t157 = t140 * t142
  t162 = 0.1e1 / t66 / t65
  t164 = t146 ** 2
  t165 = t69 * t164
  t170 = t45 * t48 * t59
  t171 = t136 * t155
  t172 = t146 * t140
  t177 = t52 * t136
  t182 = 0.1e1 / t63 / t62
  t183 = 0.1e1 / t60
  t184 = t182 * t183
  t185 = t58 ** 2
  t186 = t185 * t53
  t187 = t186 * t151
  t191 = 0.1e1 / t61 / t60
  t192 = t139 * t191
  t201 = -0.2e1 * t141 * t142 * t126 - 0.10e2 * t141 * t58 * t151 + 0.2e1 * t52 * t126 - 0.2e1 * t184 * t187 - 0.6e1 * t192 * t187 + 0.2e1 * t151
  t202 = t69 * t201
  t206 = t53 * t52
  t209 = t45 * t48 * t185 * t206
  t210 = t62 ** 2
  t212 = 0.1e1 / t68 / t210
  t213 = t66 * t212
  t214 = t183 * t151
  t218 = t191 * t151
  t222 = t140 * t126
  t226 = t49 * t126 * t66 * t69 / 0.4e1 + t49 * t137 * t147 / 0.4e1 + 0.7e1 / 0.8e1 * t153 * t156 * t157 - t49 * t52 * t162 * t165 / 0.16e2 + t170 * t171 * t172 * t135 / 0.8e1 + t49 * t177 * t202 / 0.8e1 + 0.7e1 / 0.16e2 * t209 * t213 * t214 + 0.3e1 / 0.8e1 * t209 * t156 * t218 + t170 * t156 * t222 / 0.8e1
  t227 = 0.1e1 / t38
  t228 = t37 * t227
  t233 = 0.2e1 * t228 * t53 * t65 * t139 + 0.16e2
  t234 = jnp.sqrt(t233)
  t235 = 0.1e1 / t234
  t245 = t140 * t135
  t249 = t49 * t135 * t66 * t69 / 0.4e1 + t49 * t177 * t147 / 0.8e1 + t170 * t156 * t245 / 0.8e1
  t251 = 0.1e1 / t234 / t233
  t252 = t249 * t251
  t253 = t228 * t52
  t254 = t65 * t139
  t262 = t58 * t206
  t263 = t228 * t262
  t264 = t65 * t182
  t268 = 0.2e1 * t228 * t53 * t146 * t139 + 0.4e1 * t253 * t254 * t135 + 0.2e1 * t263 * t264 * t245
  t274 = t74 / t94 / t93
  t275 = t78 * t37
  t276 = f.my_piecewise3(t76, -t134, 0)
  t280 = t275 * t74
  t281 = jnp.sin(t90)
  t283 = t281 / t87
  t284 = t283 * t276
  t287 = 0.3e1 * t275 * t92 * t276 - 0.12e2 * t280 * t284
  t288 = t287 ** 2
  t291 = t80 * t227 * t91 + 0.4e1
  t292 = jnp.sqrt(t291)
  t293 = 0.1e1 / t292
  t298 = t74 / t94
  t299 = t77 * t37
  t300 = t276 ** 2
  t304 = t299 * t74
  t305 = t283 * t300
  t308 = f.my_piecewise3(t76, t125, 0)
  t313 = t91 / t86
  t314 = t313 * t300
  t317 = t82 * t79
  t320 = 0.1e1 / t55 / t38
  t321 = t317 * t37 * t320
  t324 = t281 / t87 / t86
  t325 = t324 * t300
  t328 = t283 * t308
  t331 = 0.3e1 * t275 * t92 * t308 + 0.6e1 * t299 * t92 * t300 - 0.12e2 * t280 * t328 - 0.60e2 * t304 * t305 - 0.144e3 * t304 * t314 + 0.108e3 * t321 * t325
  t336 = 0.1e1 / t292 / t291
  t337 = t287 * t336
  t338 = t227 * t78
  t339 = t37 * t91
  t343 = t338 * t37
  t346 = 0.3e1 * t338 * t339 * t276 - 0.12e2 * t343 * t284
  t351 = f.my_piecewise3(t42, 0.4e1 * t226 * t235 - 0.2e1 * t252 * t268, -t274 * t288 * t293 / 0.4e1 + t298 * t331 * t293 / 0.2e1 - t298 * t337 * t346 / 0.4e1)
  t353 = t116 * t119 * t351
  t358 = t287 * t293
  t361 = f.my_piecewise3(t42, 0.4e1 * t249 * t235, t298 * t358 / 0.2e1)
  t365 = 0.1e1 / t101
  t366 = t100 * t365
  t369 = 0.24e2 * t98 * t361 * t366 + 0.12e2 * t361 * t102
  t371 = t7 * t29 * t369
  t373 = t116 * t119 * t361
  t376 = t8 ** 2
  t377 = 0.1e1 / t376
  t379 = -t18 * t377 + t9
  t380 = f.my_piecewise5(t12, 0, t16, 0, t379)
  t383 = f.my_piecewise3(t22, 0, 0.4e1 / 0.3e1 * t25 * t380)
  t384 = t28 ** 2
  t385 = 0.1e1 / t384
  t386 = t383 * t385
  t387 = t7 * t386
  t388 = 0.1e1 / t98
  t391 = t115 * t118 * t36
  t392 = t107 * t388 * t391
  t395 = t383 * t28
  t397 = t7 * t395 * t107
  t401 = 0.1e1 / t384 / t8
  t402 = t27 * t401
  t403 = t7 * t402
  t406 = t27 * t385
  t408 = t7 * t406 * t107
  t411 = t116 * t118
  t412 = t361 ** 2
  t414 = jnp.tanh(t98)
  t416 = t411 * t36 * t412 * t414
  t420 = t388 * t115 * t118
  t421 = t36 * t414
  t423 = t420 * t421 * t351
  t426 = t414 ** 2
  t429 = t420 * t36 * t426 * t412
  t433 = t420 * t421 * t361
  t442 = 0.1e1 / t110 / t98 * t115
  t444 = t442 * t119 * t412
  t447 = 0.1e1 - t426
  t450 = t420 * t36 * t447 * t412
  t453 = t25 ** 2
  t454 = 0.1e1 / t453
  t455 = t380 ** 2
  t459 = 0.1e1 / t376 / t8
  t462 = 0.2e1 * t18 * t459 - 0.2e1 * t377
  t463 = f.my_piecewise5(t12, 0, t16, 0, t462)
  t467 = f.my_piecewise3(t22, 0, 0.4e1 / 0.9e1 * t454 * t455 + 0.4e1 / 0.3e1 * t25 * t463)
  t468 = t467 * t28
  t469 = t7 * t468
  t472 = t7 * t395
  t474 = t369 * t388 * t391
  t477 = t7 * t406
  t480 = t7 * t29
  t483 = t98 * t351
  t486 = t98 * t412
  t489 = t100 ** 2
  t490 = t101 ** 2
  t491 = 0.1e1 / t490
  t492 = t489 * t491
  t495 = 0.12e2 * t351 * t102 + 0.24e2 * t483 * t366 - 0.48e2 * t486 * t366 + 0.48e2 * t486 * t492
  t497 = t495 * t388 * t391
  t500 = t109 * t353 / 0.24e2 + t371 * t373 / 0.12e2 - t387 * t392 / 0.36e2 + t397 * t373 / 0.12e2 + t403 * t392 / 0.108e3 + t408 * t373 / 0.36e2 + t109 * t416 / 0.18e2 - t109 * t423 / 0.36e2 - t109 * t429 / 0.54e2 - t397 * t433 / 0.18e2 - t408 * t433 / 0.54e2 - t371 * t433 / 0.18e2 - t109 * t444 / 0.12e2 - t109 * t450 / 0.36e2 - t469 * t392 / 0.24e2 - t472 * t474 / 0.12e2 - t477 * t474 / 0.36e2 - t480 * t497 / 0.24e2
  t501 = f.my_piecewise3(t1, 0, t500)
  t503 = r1 <= f.p.dens_threshold
  t504 = f.my_piecewise5(t16, t13, t12, t17, -t19)
  t505 = 0.1e1 + t504
  t506 = t505 <= f.p.zeta_threshold
  t507 = t505 ** (0.1e1 / 0.3e1)
  t508 = t507 ** 2
  t509 = 0.1e1 / t508
  t511 = f.my_piecewise5(t16, 0, t12, 0, -t379)
  t512 = t511 ** 2
  t516 = f.my_piecewise5(t16, 0, t12, 0, -t462)
  t520 = f.my_piecewise3(t506, 0, 0.4e1 / 0.9e1 * t509 * t512 + 0.4e1 / 0.3e1 * t507 * t516)
  t523 = jnp.sqrt(s2)
  t524 = r1 ** (0.1e1 / 0.3e1)
  t527 = t523 / t524 / r1
  t530 = f.my_piecewise3(t50 < t527, t50, t527)
  t531 = t530 ** 2
  t532 = t531 ** 2
  t535 = jnp.sqrt(-t532 * t531 + t57)
  t536 = t54 + t535
  t537 = t536 ** (0.1e1 / 0.3e1)
  t538 = t537 ** 2
  t540 = jnp.sqrt(t531 + t538)
  t542 = t536 ** (0.1e1 / 0.6e1)
  t547 = jnp.asinh(t49 * t530 * t540 / t542 / 0.4e1)
  t549 = f.my_piecewise3(t75 < t527, t527, t75)
  t550 = t549 ** 2
  t553 = t550 ** 2
  t558 = jnp.sqrt(0.3e1 * t81 * t553 * t550 - 0.144e3)
  t560 = jnp.atan(t558 / 0.12e2)
  t562 = jnp.cos(t560 / 0.3e1)
  t565 = jnp.sqrt(t550 * t549 * t37 * t74 * t562)
  t568 = jnp.asinh(t74 * t565 / 0.2e1)
  t569 = f.my_piecewise3(t527 < t41, t547, t568)
  t571 = jnp.exp(-0.2e1 * t569)
  t573 = jnp.log(0.1e1 + t571)
  t576 = my_dilog(-t571)
  t581 = 0.1e1 / jnp.cosh(t569)
  t582 = t581 ** (0.1e1 / 0.3e1)
  t583 = t582 ** 2
  t587 = (-0.12e2 * t569 * t573 + t30 + 0.12e2 * t576) / t569 / t583 * t118 * t36
  t592 = f.my_piecewise3(t506, 0, 0.4e1 / 0.3e1 * t507 * t511)
  t598 = f.my_piecewise3(t506, t24, t507 * t505)
  t604 = f.my_piecewise3(t503, 0, -t7 * t520 * t28 * t587 / 0.24e2 - t7 * t592 * t385 * t587 / 0.36e2 + t7 * t598 * t401 * t587 / 0.108e3)
  t607 = t7 * t468 * t107
  t611 = t7 * t395 * t369
  t615 = t7 * t29 * t495
  t624 = t120 ** 2
  t628 = 0.280e3 / 0.27e2 * t31 / t32 / t624
  t629 = f.my_piecewise3(t51, 0, -t628)
  t633 = 0.1e1 / t63 / t210
  t636 = t151 * t135
  t637 = t185 * t262 * t636
  t640 = t60 ** 2
  t641 = 0.1e1 / t640
  t646 = t185 * t52 * t636
  t650 = t186 * t135 * t126
  t654 = 0.1e1 / t61 / t640
  t672 = -0.30e2 * t141 * t58 * t135 * t126 - 0.54e2 * t139 * t654 * t637 - 0.2e1 * t141 * t142 * t629 - 0.40e2 * t141 * t206 * t636 - 0.18e2 * t182 * t641 * t637 - 0.8e1 * t633 * t191 * t637 + 0.6e1 * t135 * t126 - 0.30e2 * t184 * t646 - 0.6e1 * t184 * t650 - 0.90e2 * t192 * t646 - 0.18e2 * t192 * t650 + 0.2e1 * t52 * t629
  t677 = t185 ** 2
  t679 = t45 * t48 * t677
  t693 = t45 * t48 * t636
  t702 = t65 ** 2
  t734 = t49 * t177 * t69 * t672 / 0.8e1 + 0.27e2 / 0.8e1 * t679 * t156 * t654 * t636 + t170 * t156 * t140 * t629 / 0.8e1 - 0.3e1 / 0.16e2 * t49 * t135 * t162 * t165 + 0.63e2 / 0.8e1 * t693 * t213 * t183 * t186 + 0.27e2 / 0.4e1 * t693 * t156 * t191 * t186 + 0.3e1 / 0.32e2 * t49 * t52 / t66 / t702 * t69 * t164 * t146 - 0.3e1 / 0.16e2 * t45 * t48 * t52 * t162 * t69 * t146 * t201 + 0.91e2 / 0.32e2 * t679 * t66 / t68 / t210 / t62 * t191 * t636 + 0.63e2 / 0.16e2 * t679 * t213 * t641 * t636 + t49 * t629 * t66 * t69 / 0.4e1
  t792 = 0.3e1 / 0.8e1 * t49 * t126 * t136 * t147 + 0.3e1 / 0.8e1 * t49 * t137 * t202 + 0.21e2 / 0.8e1 * t45 * t48 * t126 * t156 * t157 * t135 + 0.21e2 / 0.16e2 * t153 * t171 * t172 * t142 + 0.35e2 / 0.8e1 * t693 * t156 * t140 * t58 - 0.3e1 / 0.32e2 * t170 * t162 * t155 * t164 * t140 * t135 + 0.3e1 / 0.16e2 * t170 * t171 * t201 * t140 * t135 + 0.3e1 / 0.16e2 * t170 * t171 * t172 * t126 + 0.21e2 / 0.32e2 * t209 * t136 * t212 * t146 * t183 * t151 + 0.9e1 / 0.16e2 * t209 * t171 * t146 * t191 * t151 + 0.21e2 / 0.16e2 * t209 * t213 * t183 * t135 * t126 + 0.9e1 / 0.8e1 * t209 * t156 * t191 * t135 * t126
  t799 = t233 ** 2
  t803 = t268 ** 2
  t831 = t228 * t185 * t58
  t848 = t91 ** 2
  t865 = t300 * t276
  t869 = t37 * t74
  t881 = t83 * t37 * t320
  t882 = t324 * t865
  t885 = t276 * t308
  t889 = f.my_piecewise3(t76, -t628, 0)
  t895 = t86 ** 2
  t904 = t82 ** 2
  t908 = t55 ** 2
  t924 = 0.6e1 * t865 * t37 * t92 - 0.132e3 * t869 * t283 * t865 + 0.18e2 * t304 * t91 * t276 * t308 - 0.864e3 * t869 * t313 * t865 + 0.1296e4 * t881 * t882 - 0.180e3 * t304 * t283 * t885 + 0.3e1 * t275 * t92 * t889 + 0.1728e4 * t869 * t882 + 0.3888e4 * t881 * t91 / t895 * t865 - 0.432e3 * t304 * t313 * t885 - 0.2916e4 * t904 * t82 * t37 / t908 / t55 / jnp.pi * t281 / t87 / t895 * t865 + 0.324e3 * t321 * t324 * t885 - 0.12e2 * t280 * t283 * t889
  t932 = t291 ** 2
  t936 = t346 ** 2
  t940 = t227 * t77
  t944 = t940 * t37
  t965 = f.my_piecewise3(t42, 0.4e1 * (t734 + t792) * t235 - 0.4e1 * t226 * t251 * t268 + 0.3e1 * t249 / t234 / t799 * t803 - 0.2e1 * t252 * (0.18e2 * t228 * t59 * t264 * t151 * t140 + 0.8e1 * t253 * t146 * t139 * t135 + 0.4e1 * t228 * t151 * t65 * t139 + 0.2e1 * t228 * t53 * t201 * t139 + 0.4e1 * t263 * t146 * t182 * t245 + 0.8e1 * t831 * t65 * t633 * t214 + 0.4e1 * t253 * t254 * t126 + 0.6e1 * t831 * t264 * t218 + 0.2e1 * t263 * t264 * t222), t74 / t94 / t83 * t30 / t848 * t288 * t287 * t293 / 0.8e1 - 0.3e1 / 0.4e1 * t274 * t358 * t331 + t274 * t288 * t336 * t346 / 0.4e1 + t298 * t924 * t293 / 0.2e1 - t298 * t331 * t336 * t346 / 0.2e1 + 0.3e1 / 0.8e1 * t298 * t287 / t292 / t932 * t936 - t298 * t337 * (0.6e1 * t940 * t339 * t300 - 0.60e2 * t944 * t305 + 0.3e1 * t338 * t339 * t308 - 0.144e3 * t944 * t314 + 0.108e3 / t908 / jnp.pi * t317 * t37 * t325 - 0.12e2 * t343 * t328) / 0.4e1)
  t973 = t7 * t406 * t369
  t978 = t110 ** 2
  t981 = t412 * t361
  t990 = t607 * t373 / 0.8e1 + t611 * t373 / 0.4e1 + t615 * t373 / 0.8e1 + t397 * t353 / 0.8e1 + t371 * t353 / 0.8e1 + t109 * t116 * t119 * t965 / 0.24e2 - t371 * t444 / 0.4e1 + t973 * t373 / 0.12e2 + t408 * t353 / 0.24e2 + t109 / t978 * t115 * t119 * t981 / 0.4e1 - t408 * t444 / 0.12e2 - t397 * t444 / 0.4e1
  t992 = t7 * t402 * t107
  t996 = t7 * t386 * t107
  t999 = t36 * t981
  t1030 = -t992 * t373 / 0.36e2 + t996 * t373 / 0.12e2 + t109 * t411 * t999 * t447 / 0.12e2 - t408 * t423 / 0.36e2 - t973 * t433 / 0.18e2 - t615 * t433 / 0.12e2 - t397 * t429 / 0.18e2 - t371 * t429 / 0.18e2 - t109 * t420 * t36 * t426 * t414 * t981 / 0.81e2 - t607 * t433 / 0.12e2 - t611 * t433 / 0.6e1 + t408 * t416 / 0.18e2 + t109 * t411 * t999 * t426 / 0.18e2
  t1048 = t442 * t118
  t1066 = -t397 * t423 / 0.12e2 - t371 * t423 / 0.12e2 - t109 * t420 * t421 * t965 / 0.36e2 + t371 * t416 / 0.6e1 - t996 * t433 / 0.18e2 + t397 * t416 / 0.6e1 + t992 * t433 / 0.54e2 - t109 * t1048 * t36 * t351 * t361 / 0.4e1 - t371 * t450 / 0.12e2 - t397 * t450 / 0.12e2 - t408 * t450 / 0.36e2 - t408 * t429 / 0.54e2 - t109 * t1048 * t999 * t414 / 0.6e1
  t1067 = t7 * t27
  t1068 = t28 * t107
  t1070 = t1067 * t1068 * t388
  t1089 = 0.1e1 / t384 / t376
  t1116 = t376 ** 2
  t1120 = 0.6e1 * t459 - 0.6e1 * t18 / t1116
  t1121 = f.my_piecewise5(t12, 0, t16, 0, t1120)
  t1125 = f.my_piecewise3(t22, 0, -0.8e1 / 0.27e2 / t453 / t21 * t455 * t380 + 0.4e1 / 0.3e1 * t454 * t380 * t463 + 0.4e1 / 0.3e1 * t25 * t1121)
  t1149 = t98 * t981
  t1168 = -t1070 * t391 * t426 * t351 * t361 / 0.18e2 - t1070 * t391 * t447 * t361 * t351 / 0.12e2 + t1067 * t1068 * t111 * t391 * t351 * t414 * t361 / 0.6e1 - 0.5e1 / 0.324e3 * t7 * t27 * t1089 * t392 + t7 * t383 * t401 * t392 / 0.36e2 - t7 * t467 * t385 * t392 / 0.24e2 - t387 * t474 / 0.12e2 + t403 * t474 / 0.36e2 - t477 * t497 / 0.24e2 - t7 * t1125 * t28 * t392 / 0.24e2 - t469 * t474 / 0.8e1 - t472 * t497 / 0.8e1 - t480 * (0.12e2 * t965 * t102 + 0.24e2 * t98 * t965 * t366 - 0.144e3 * t483 * t361 * t100 * t365 + 0.144e3 * t483 * t492 * t361 - 0.48e2 * t981 * t100 * t365 + 0.96e2 * t1149 * t366 - 0.288e3 * t1149 * t492 + 0.48e2 * t981 * t489 * t491 + 0.192e3 * t1149 * t489 * t100 / t490 / t101) * t388 * t391 / 0.24e2
  t1171 = f.my_piecewise3(t1, 0, t990 + t1030 + t1066 + t1168)
  t1181 = f.my_piecewise5(t16, 0, t12, 0, -t1120)
  t1185 = f.my_piecewise3(t506, 0, -0.8e1 / 0.27e2 / t508 / t505 * t512 * t511 + 0.4e1 / 0.3e1 * t509 * t511 * t516 + 0.4e1 / 0.3e1 * t507 * t1181)
  t1203 = f.my_piecewise3(t503, 0, -t7 * t1185 * t28 * t587 / 0.24e2 - t7 * t520 * t385 * t587 / 0.24e2 + t7 * t592 * t401 * t587 / 0.36e2 - 0.5e1 / 0.324e3 * t7 * t598 * t1089 * t587)
  d111 = 0.3e1 * t501 + 0.3e1 * t604 + t8 * (t1171 + t1203)

  res = {'v3rho3': d111}
  return res
