"""Generated from lda_c_pmgb06.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  alpha = (4 / (9 * jnp.pi)) ** (1 / 3)

  g0_C = 0.08193

  g0_D = -0.01277

  g0_E = 0.001859

  g0_dd = 0.7524

  pmgb_phi = lambda n, z: (f.opz_pow_n(z, n / 3) + f.opz_pow_n(-z, n / 3)) / 2

  pmgb_Q_a = 5.84605

  pmgb_Q_c = 3.91744

  pmgb_Q_d = 3.44851

  pmgb_b0 = lambda rs: 0.784949 * rs

  pmgb_D2 = lambda rs: (-0.388 * rs + 0.676 * rs ** 2) * jnp.exp(-0.547 * rs) / rs ** 2

  pmgb_D3 = lambda rs: (-4.95 * rs + rs ** 2) * jnp.exp(-0.31 * rs) / rs ** 3

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g0_aHD = -alpha * (jnp.pi ** 2 + 6 * jnp.log(2) - 3) / (5 * jnp.pi)

  pmgb_gpp1 = lambda rs: 2 ** (5 / 3) / (5 * alpha ** 2 * rs ** 2) * (1 - 0.02267 * rs) / (1 + 0.4319 * rs + 0.04 * rs ** 2)

  pmgb_Q_b = pmgb_Q_d - 3 * jnp.pi * alpha / (4 * jnp.log(2) - 4)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  g0_B = -2 * g0_aHD - g0_dd

  pmgb_cc4 = lambda rs, z: +(f.opz_pow_n(z, 2) / 4) * pmgb_gpp1(rs * (2 / (1 + z)) ** (1 / 3)) + f.opz_pow_n(-z, 2) / 4 * pmgb_gpp1(rs * (2 / (1 - z)) ** (1 / 3)) + (1 - z ** 2) * pmgb_D2(rs) - pmgb_phi(8, z) / (5 * alpha ** 2 * rs ** 2)

  pmgb_cc5 = lambda rs, z: +(f.opz_pow_n(z, 2) / 4) * pmgb_gpp1(rs * (2 / (1 + z)) ** (1 / 3)) + f.opz_pow_n(-z, 2) / 4 * pmgb_gpp1(rs * (2 / (1 - z)) ** (1 / 3)) + (1 - z ** 2) * pmgb_D3(rs)

  pmgb_Q = lambda x: (2 * jnp.log(2) - 2) / jnp.pi ** 2 * jnp.log((1 + pmgb_Q_a * x + pmgb_Q_b * x ** 2 + pmgb_Q_c * x ** 3) / (1 + pmgb_Q_a * x + pmgb_Q_d * x ** 2))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  pmgb_g0 = lambda rs: (1 - g0_B * rs + g0_C * rs ** 2 + g0_D * rs ** 3 + g0_E * rs ** 4) * jnp.exp(-g0_dd * rs) / 2

  pmgb_C4 = lambda rs, z: -9 * pmgb_cc4(rs, z) / (64 * rs ** 3)

  pmgb_C5 = lambda rs, z: -9 * pmgb_cc5(rs, z) / (40 * jnp.sqrt(2 * jnp.pi) * rs ** 3)

  pmgb_a5 = lambda rs, z: pmgb_b0(rs) ** 8 * f_pw(rs, z)

  pmgb_gc0 = lambda rs, z: pmgb_g0(rs) - 1 / 2 * (1 - z ** 2)

  pmgb_C3 = lambda rs, z: -(1 - z ** 2) * pmgb_g0(rs) / (jnp.sqrt(2 * jnp.pi) * rs ** 3)

  pmgb_C2 = lambda rs, z: -3 * (1 - z ** 2) * pmgb_gc0(rs, z) / (8 * rs ** 3)

  pmgb_a1 = lambda rs, z: 4 * pmgb_b0(rs) ** 6 * pmgb_C3(rs, z) + pmgb_b0(rs) ** 8 * pmgb_C5(rs, z)

  pmgb_a3 = lambda rs, z: pmgb_b0(rs) ** 8 * pmgb_C3(rs, z)

  pmgb_a2 = lambda rs, z: 4 * pmgb_b0(rs) ** 6 * pmgb_C2(rs, z) + pmgb_b0(rs) ** 8 * pmgb_C4(rs, z) + 6 * pmgb_b0(rs) ** 4 * f_pw(rs, z)

  pmgb_a4 = lambda rs, z: pmgb_b0(rs) ** 8 * pmgb_C2(rs, z) + 4 * pmgb_b0(rs) ** 6 * f_pw(rs, z)

  pmgb_ec_LR = lambda rs, z: (+pmgb_phi(2, z) ** 3 * pmgb_Q(f.p.cam_omega * jnp.sqrt(rs) / pmgb_phi(2, z)) + pmgb_a1(rs, z) * f.p.cam_omega ** 3 + pmgb_a2(rs, z) * f.p.cam_omega ** 4 + pmgb_a3(rs, z) * f.p.cam_omega ** 5 + pmgb_a4(rs, z) * f.p.cam_omega ** 6 + pmgb_a5(rs, z) * f.p.cam_omega ** 8) / (1 + pmgb_b0(rs) ** 2 * f.p.cam_omega ** 2) ** 4

  functional_body = lambda rs, z: pmgb_ec_LR(rs, z)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  alpha = (4 / (9 * jnp.pi)) ** (1 / 3)

  g0_C = 0.08193

  g0_D = -0.01277

  g0_E = 0.001859

  g0_dd = 0.7524

  pmgb_phi = lambda n, z: (f.opz_pow_n(z, n / 3) + f.opz_pow_n(-z, n / 3)) / 2

  pmgb_Q_a = 5.84605

  pmgb_Q_c = 3.91744

  pmgb_Q_d = 3.44851

  pmgb_b0 = lambda rs: 0.784949 * rs

  pmgb_D2 = lambda rs: (-0.388 * rs + 0.676 * rs ** 2) * jnp.exp(-0.547 * rs) / rs ** 2

  pmgb_D3 = lambda rs: (-4.95 * rs + rs ** 2) * jnp.exp(-0.31 * rs) / rs ** 3

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g0_aHD = -alpha * (jnp.pi ** 2 + 6 * jnp.log(2) - 3) / (5 * jnp.pi)

  pmgb_gpp1 = lambda rs: 2 ** (5 / 3) / (5 * alpha ** 2 * rs ** 2) * (1 - 0.02267 * rs) / (1 + 0.4319 * rs + 0.04 * rs ** 2)

  pmgb_Q_b = pmgb_Q_d - 3 * jnp.pi * alpha / (4 * jnp.log(2) - 4)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  g0_B = -2 * g0_aHD - g0_dd

  pmgb_cc4 = lambda rs, z: +(f.opz_pow_n(z, 2) / 4) * pmgb_gpp1(rs * (2 / (1 + z)) ** (1 / 3)) + f.opz_pow_n(-z, 2) / 4 * pmgb_gpp1(rs * (2 / (1 - z)) ** (1 / 3)) + (1 - z ** 2) * pmgb_D2(rs) - pmgb_phi(8, z) / (5 * alpha ** 2 * rs ** 2)

  pmgb_cc5 = lambda rs, z: +(f.opz_pow_n(z, 2) / 4) * pmgb_gpp1(rs * (2 / (1 + z)) ** (1 / 3)) + f.opz_pow_n(-z, 2) / 4 * pmgb_gpp1(rs * (2 / (1 - z)) ** (1 / 3)) + (1 - z ** 2) * pmgb_D3(rs)

  pmgb_Q = lambda x: (2 * jnp.log(2) - 2) / jnp.pi ** 2 * jnp.log((1 + pmgb_Q_a * x + pmgb_Q_b * x ** 2 + pmgb_Q_c * x ** 3) / (1 + pmgb_Q_a * x + pmgb_Q_d * x ** 2))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  pmgb_g0 = lambda rs: (1 - g0_B * rs + g0_C * rs ** 2 + g0_D * rs ** 3 + g0_E * rs ** 4) * jnp.exp(-g0_dd * rs) / 2

  pmgb_C4 = lambda rs, z: -9 * pmgb_cc4(rs, z) / (64 * rs ** 3)

  pmgb_C5 = lambda rs, z: -9 * pmgb_cc5(rs, z) / (40 * jnp.sqrt(2 * jnp.pi) * rs ** 3)

  pmgb_a5 = lambda rs, z: pmgb_b0(rs) ** 8 * f_pw(rs, z)

  pmgb_gc0 = lambda rs, z: pmgb_g0(rs) - 1 / 2 * (1 - z ** 2)

  pmgb_C3 = lambda rs, z: -(1 - z ** 2) * pmgb_g0(rs) / (jnp.sqrt(2 * jnp.pi) * rs ** 3)

  pmgb_C2 = lambda rs, z: -3 * (1 - z ** 2) * pmgb_gc0(rs, z) / (8 * rs ** 3)

  pmgb_a1 = lambda rs, z: 4 * pmgb_b0(rs) ** 6 * pmgb_C3(rs, z) + pmgb_b0(rs) ** 8 * pmgb_C5(rs, z)

  pmgb_a3 = lambda rs, z: pmgb_b0(rs) ** 8 * pmgb_C3(rs, z)

  pmgb_a2 = lambda rs, z: 4 * pmgb_b0(rs) ** 6 * pmgb_C2(rs, z) + pmgb_b0(rs) ** 8 * pmgb_C4(rs, z) + 6 * pmgb_b0(rs) ** 4 * f_pw(rs, z)

  pmgb_a4 = lambda rs, z: pmgb_b0(rs) ** 8 * pmgb_C2(rs, z) + 4 * pmgb_b0(rs) ** 6 * f_pw(rs, z)

  pmgb_ec_LR = lambda rs, z: (+pmgb_phi(2, z) ** 3 * pmgb_Q(f.p.cam_omega * jnp.sqrt(rs) / pmgb_phi(2, z)) + pmgb_a1(rs, z) * f.p.cam_omega ** 3 + pmgb_a2(rs, z) * f.p.cam_omega ** 4 + pmgb_a3(rs, z) * f.p.cam_omega ** 5 + pmgb_a4(rs, z) * f.p.cam_omega ** 6 + pmgb_a5(rs, z) * f.p.cam_omega ** 8) / (1 + pmgb_b0(rs) ** 2 * f.p.cam_omega ** 2) ** 4

  functional_body = lambda rs, z: pmgb_ec_LR(rs, z)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  alpha = (4 / (9 * jnp.pi)) ** (1 / 3)

  g0_C = 0.08193

  g0_D = -0.01277

  g0_E = 0.001859

  g0_dd = 0.7524

  pmgb_phi = lambda n, z: (f.opz_pow_n(z, n / 3) + f.opz_pow_n(-z, n / 3)) / 2

  pmgb_Q_a = 5.84605

  pmgb_Q_c = 3.91744

  pmgb_Q_d = 3.44851

  pmgb_b0 = lambda rs: 0.784949 * rs

  pmgb_D2 = lambda rs: (-0.388 * rs + 0.676 * rs ** 2) * jnp.exp(-0.547 * rs) / rs ** 2

  pmgb_D3 = lambda rs: (-4.95 * rs + rs ** 2) * jnp.exp(-0.31 * rs) / rs ** 3

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g0_aHD = -alpha * (jnp.pi ** 2 + 6 * jnp.log(2) - 3) / (5 * jnp.pi)

  pmgb_gpp1 = lambda rs: 2 ** (5 / 3) / (5 * alpha ** 2 * rs ** 2) * (1 - 0.02267 * rs) / (1 + 0.4319 * rs + 0.04 * rs ** 2)

  pmgb_Q_b = pmgb_Q_d - 3 * jnp.pi * alpha / (4 * jnp.log(2) - 4)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  g0_B = -2 * g0_aHD - g0_dd

  pmgb_cc4 = lambda rs, z: +(f.opz_pow_n(z, 2) / 4) * pmgb_gpp1(rs * (2 / (1 + z)) ** (1 / 3)) + f.opz_pow_n(-z, 2) / 4 * pmgb_gpp1(rs * (2 / (1 - z)) ** (1 / 3)) + (1 - z ** 2) * pmgb_D2(rs) - pmgb_phi(8, z) / (5 * alpha ** 2 * rs ** 2)

  pmgb_cc5 = lambda rs, z: +(f.opz_pow_n(z, 2) / 4) * pmgb_gpp1(rs * (2 / (1 + z)) ** (1 / 3)) + f.opz_pow_n(-z, 2) / 4 * pmgb_gpp1(rs * (2 / (1 - z)) ** (1 / 3)) + (1 - z ** 2) * pmgb_D3(rs)

  pmgb_Q = lambda x: (2 * jnp.log(2) - 2) / jnp.pi ** 2 * jnp.log((1 + pmgb_Q_a * x + pmgb_Q_b * x ** 2 + pmgb_Q_c * x ** 3) / (1 + pmgb_Q_a * x + pmgb_Q_d * x ** 2))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  pmgb_g0 = lambda rs: (1 - g0_B * rs + g0_C * rs ** 2 + g0_D * rs ** 3 + g0_E * rs ** 4) * jnp.exp(-g0_dd * rs) / 2

  pmgb_C4 = lambda rs, z: -9 * pmgb_cc4(rs, z) / (64 * rs ** 3)

  pmgb_C5 = lambda rs, z: -9 * pmgb_cc5(rs, z) / (40 * jnp.sqrt(2 * jnp.pi) * rs ** 3)

  pmgb_a5 = lambda rs, z: pmgb_b0(rs) ** 8 * f_pw(rs, z)

  pmgb_gc0 = lambda rs, z: pmgb_g0(rs) - 1 / 2 * (1 - z ** 2)

  pmgb_C3 = lambda rs, z: -(1 - z ** 2) * pmgb_g0(rs) / (jnp.sqrt(2 * jnp.pi) * rs ** 3)

  pmgb_C2 = lambda rs, z: -3 * (1 - z ** 2) * pmgb_gc0(rs, z) / (8 * rs ** 3)

  pmgb_a1 = lambda rs, z: 4 * pmgb_b0(rs) ** 6 * pmgb_C3(rs, z) + pmgb_b0(rs) ** 8 * pmgb_C5(rs, z)

  pmgb_a3 = lambda rs, z: pmgb_b0(rs) ** 8 * pmgb_C3(rs, z)

  pmgb_a2 = lambda rs, z: 4 * pmgb_b0(rs) ** 6 * pmgb_C2(rs, z) + pmgb_b0(rs) ** 8 * pmgb_C4(rs, z) + 6 * pmgb_b0(rs) ** 4 * f_pw(rs, z)

  pmgb_a4 = lambda rs, z: pmgb_b0(rs) ** 8 * pmgb_C2(rs, z) + 4 * pmgb_b0(rs) ** 6 * f_pw(rs, z)

  pmgb_ec_LR = lambda rs, z: (+pmgb_phi(2, z) ** 3 * pmgb_Q(f.p.cam_omega * jnp.sqrt(rs) / pmgb_phi(2, z)) + pmgb_a1(rs, z) * f.p.cam_omega ** 3 + pmgb_a2(rs, z) * f.p.cam_omega ** 4 + pmgb_a3(rs, z) * f.p.cam_omega ** 5 + pmgb_a4(rs, z) * f.p.cam_omega ** 6 + pmgb_a5(rs, z) * f.p.cam_omega ** 8) / (1 + pmgb_b0(rs) ** 2 * f.p.cam_omega ** 2) ** 4

  functional_body = lambda rs, z: pmgb_ec_LR(rs, z)

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = 0.1e1 + t4
  t6 = t5 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = t5 ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t11 = f.my_piecewise3(t6, t8, t10)
  t12 = 0.1e1 - t4
  t13 = t12 <= f.p.zeta_threshold
  t14 = t12 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t16 = f.my_piecewise3(t13, t8, t15)
  t18 = t11 / 0.2e1 + t16 / 0.2e1
  t19 = t18 ** 2
  t20 = t19 * t18
  t21 = jnp.log(0.2e1)
  t22 = t21 - 0.1e1
  t23 = 0.2e1 * t22
  t24 = t20 * t23
  t25 = jnp.pi ** 2
  t26 = 0.1e1 / t25
  t27 = 3 ** (0.1e1 / 0.3e1)
  t28 = 0.1e1 / jnp.pi
  t29 = t28 ** (0.1e1 / 0.3e1)
  t30 = t27 * t29
  t31 = 4 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t33 = t2 ** (0.1e1 / 0.3e1)
  t34 = 0.1e1 / t33
  t35 = t32 * t34
  t36 = t30 * t35
  t37 = jnp.sqrt(t36)
  t38 = f.p.cam_omega * t37
  t39 = 0.1e1 / t18
  t41 = 0.29230250000000000000000000000000000000000000000000e1 * t38 * t39
  t43 = 9 ** (0.1e1 / 0.3e1)
  t44 = t43 ** 2
  t52 = f.p.cam_omega ** 2
  t53 = (0.344851e1 - jnp.pi * t31 * t44 * t29 / t22 / 0.12e2) * t52
  t54 = t53 * t27
  t55 = t29 * t32
  t56 = 0.1e1 / t19
  t61 = t52 * f.p.cam_omega
  t63 = t61 * t37 * t36
  t64 = 0.1e1 / t20
  t67 = 0.1e1 + t41 + t54 * t55 * t34 * t56 / 0.4e1 + 0.48968000000000000000000000000000000000000000000000e0 * t63 * t64
  t69 = t52 * t27 * t29
  t73 = 0.1e1 + t41 + 0.86212750000000000000000000000000000000000000000000e0 * t69 * t35 * t56
  t74 = 0.1e1 / t73
  t76 = jnp.log(t67 * t74)
  t77 = t26 * t76
  t79 = jnp.sqrt(jnp.pi)
  t81 = 0.1e1 / t79 / jnp.pi
  t82 = t81 * t3
  t83 = t1 ** 2
  t84 = t2 ** 2
  t85 = 0.1e1 / t84
  t86 = t83 * t85
  t87 = 0.1e1 - t86
  t88 = t82 * t87
  t97 = (0.2e1 / 0.45e2 * t31 * t44 * t29 * (t25 + 0.6e1 * t21 - 0.3e1) * t28 - 0.7524e0) * t27
  t101 = t27 ** 2
  t102 = t29 ** 2
  t103 = t101 * t102
  t104 = t33 ** 2
  t105 = 0.1e1 / t104
  t106 = t31 * t105
  t107 = t103 * t106
  t109 = t28 * t3
  t111 = t29 * t28
  t112 = t27 * t111
  t114 = 0.1e1 / t33 / t2
  t115 = t32 * t114
  t118 = 0.1e1 - t97 * t55 * t34 / 0.4e1 + 0.20482500000000000000000000000000000000000000000000e-1 * t107 - 0.95775000000000000000000000000000000000000000000000e-2 * t109 + 0.34856250000000000000000000000000000000000000000000e-3 * t112 * t115
  t120 = jnp.exp(-0.18810000000000000000000000000000000000000000000000e0 * t36)
  t121 = t118 * t120
  t122 = jnp.sqrt(0.2e1)
  t123 = t121 * t122
  t127 = t101 * t102 * t26
  t128 = t127 * t31
  t130 = 0.1e1 / t104 / t2
  t131 = f.p.zeta_threshold ** 2
  t132 = t5 ** 2
  t133 = f.my_piecewise3(t6, t131, t132)
  t134 = t133 * t44
  t136 = 0.1e1 / t111 * t27
  t137 = t134 * t136
  t138 = 0.1e1 / t5
  t139 = t138 ** (0.1e1 / 0.3e1)
  t140 = t139 ** 2
  t141 = 0.1e1 / t140
  t142 = t104 * t141
  t143 = t30 * t32
  t144 = 2 ** (0.1e1 / 0.3e1)
  t145 = t34 * t144
  t147 = t143 * t145 * t139
  t149 = 0.1e1 - 0.56675000000000000000000000000000000000000000000000e-2 * t147
  t151 = t103 * t31
  t152 = t144 ** 2
  t153 = t105 * t152
  t157 = 0.1e1 + 0.10797500000000000000000000000000000000000000000000e0 * t147 + 0.10000000000000000000000000000000000000000000000000e-1 * t151 * t153 * t140
  t158 = 0.1e1 / t157
  t159 = t149 * t158
  t160 = t142 * t159
  t162 = 0.3e1 / 0.10e2 * t137 * t160
  t163 = t12 ** 2
  t164 = f.my_piecewise3(t13, t131, t163)
  t165 = t164 * t44
  t166 = t165 * t136
  t167 = 0.1e1 / t12
  t168 = t167 ** (0.1e1 / 0.3e1)
  t169 = t168 ** 2
  t170 = 0.1e1 / t169
  t171 = t104 * t170
  t173 = t143 * t145 * t168
  t175 = 0.1e1 - 0.56675000000000000000000000000000000000000000000000e-2 * t173
  t180 = 0.1e1 + 0.10797500000000000000000000000000000000000000000000e0 * t173 + 0.10000000000000000000000000000000000000000000000000e-1 * t151 * t153 * t169
  t181 = 0.1e1 / t180
  t182 = t175 * t181
  t183 = t171 * t182
  t185 = 0.3e1 / 0.10e2 * t166 * t183
  t188 = -0.12375000000000000000000000000000000000000000000000e1 * t36 + t107 / 0.4e1
  t189 = t87 * t188
  t191 = jnp.exp(-0.77500000000000000000000000000000000000000000000000e-1 * t36)
  t192 = t191 * jnp.pi
  t193 = t192 * t2
  t196 = 0.12e2 * t189 * t193 + t162 + t185
  t198 = t122 * t79
  t204 = 0.3e1 * t87
  t206 = t121 / 0.2e1 - 0.1e1 / 0.2e1 + t86 / 0.2e1
  t207 = t204 * t206
  t212 = -0.97000000000000000000000000000000000000000000000000e-1 * t36 + 0.16900000000000000000000000000000000000000000000000e0 * t107
  t213 = t87 * t212
  t215 = jnp.exp(-0.13675000000000000000000000000000000000000000000000e0 * t36)
  t216 = t213 * t215
  t218 = t27 / t102
  t220 = t218 * t32 * t104
  t223 = t8 * t131
  t225 = f.my_piecewise3(t6, t223, t10 * t132)
  t227 = f.my_piecewise3(t13, t223, t15 * t163)
  t230 = (t225 / 0.2e1 + t227 / 0.2e1) * t44
  t231 = t136 * t104
  t234 = t162 + t185 + 0.3e1 * t216 * t220 - 0.3e1 / 0.5e1 * t230 * t231
  t240 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t36
  t243 = t36 ** 0.15e1
  t246 = 0.23615562999000000000000000000000000000000000000000e0 * t37 + 0.55770497660000000000000000000000000000000000000000e-1 * t36 + 0.12733196185000000000000000000000000000000000000000e-1 * t243 + 0.76629248290000000000000000000000000000000000000000e-2 * t107
  t248 = 0.1e1 + 0.1e1 / t246
  t249 = jnp.log(t248)
  t250 = t240 * t249
  t251 = t83 ** 2
  t252 = t84 ** 2
  t253 = 0.1e1 / t252
  t254 = t251 * t253
  t255 = t7 * f.p.zeta_threshold
  t257 = f.my_piecewise3(t6, t255, t9 * t5)
  t259 = f.my_piecewise3(t13, t255, t14 * t12)
  t263 = 0.1e1 / (0.2e1 * t144 - 0.2e1)
  t264 = (t257 + t259 - 0.2e1) * t263
  t266 = 0.3109070e-1 + 0.15971292590000000000000000000000000000000000000000e-2 * t36
  t271 = 0.21948324211500000000000000000000000000000000000000e0 * t37 + 0.48172707847500000000000000000000000000000000000000e-1 * t36 + 0.13082189292500000000000000000000000000000000000000e-1 * t243 + 0.48592432297500000000000000000000000000000000000000e-2 * t107
  t273 = 0.1e1 + 0.1e1 / t271
  t274 = jnp.log(t273)
  t277 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t36
  t282 = 0.17489762330000000000000000000000000000000000000000e0 * t37 + 0.30591463695000000000000000000000000000000000000000e-1 * t36 + 0.37162156485000000000000000000000000000000000000000e-2 * t243 + 0.41939460495000000000000000000000000000000000000000e-2 * t107
  t284 = 0.1e1 + 0.1e1 / t282
  t285 = jnp.log(t284)
  t286 = t277 * t285
  t288 = -t266 * t274 + t250 - 0.58482236226346462072622386637590534819724553404281e0 * t286
  t289 = t264 * t288
  t293 = -t250 + t254 * t289 + 0.58482236226346462072622386637590534819724553404281e0 * t264 * t286
  t298 = t52 ** 2
  t300 = t31 * t130
  t302 = t127 * t300 * t87
  t303 = t298 * f.p.cam_omega
  t304 = t198 * t303
  t305 = t121 * t304
  t308 = t130 * t204
  t309 = t206 * jnp.pi
  t313 = t26 * t85
  t317 = t298 * t52
  t320 = 0.1e1 / t104 / t84
  t322 = t298 ** 2
  t326 = t24 * t77 + (-0.17543244109220059985638668152930835075000000000000e0 * t88 * t123 - 0.33778690497744637945401606928209295430939130562735e-3 * t128 * t130 * t196 * t198) * t61 + (-0.87716220546100299928193340764654175375000000000000e-1 * t109 * t207 - 0.42223363122180797431752008660261619288673913203419e-3 * t128 * t130 * t234 * jnp.pi + 0.42708890021612718670335112500000000000000000000000e0 * t112 * t115 * t293) * t298 - 0.67557380995489275890803213856418590861878261125470e-2 * t302 * t305 + (-0.33778690497744637945401606928209295430939130562735e-2 * t128 * t308 * t309 + 0.52629732327660179956916004458792505225000000000000e0 * t313 * t293) * t317 + 0.20267214298646782767240964156925577258563478337641e-1 * t128 * t320 * t293 * t322
  t330 = 0.1e1 + 0.15403623315025000000000000000000000000000000000000e0 * t103 * t106 * t52
  t331 = t330 ** 2
  t332 = t331 ** 2
  t333 = 0.1e1 / t332
  t334 = t326 * t333
  t335 = t19 * t23
  t336 = 0.1e1 / t9
  t337 = t1 * t85
  t338 = t3 - t337
  t341 = f.my_piecewise3(t6, 0, 0.2e1 / 0.3e1 * t336 * t338)
  t342 = 0.1e1 / t14
  t343 = -t338
  t346 = f.my_piecewise3(t13, 0, 0.2e1 / 0.3e1 * t342 * t343)
  t348 = t341 / 0.2e1 + t346 / 0.2e1
  t352 = t24 * t26
  t353 = 0.1e1 / t37
  t356 = t30 * t115
  t358 = 0.48717083333333333333333333333333333333333333333333e0 * f.p.cam_omega * t353 * t39 * t356
  t361 = 0.29230250000000000000000000000000000000000000000000e1 * t38 * t56 * t348
  t365 = t54 * t55 * t114 * t56 / 0.12e2
  t366 = t53 * t30
  t368 = t35 * t64 * t348
  t374 = 0.24484000000000000000000000000000000000000000000000e0 * t61 * t37 * t64 * t356
  t375 = t19 ** 2
  t376 = 0.1e1 / t375
  t382 = t73 ** 2
  t384 = t67 / t382
  t387 = 0.28737583333333333333333333333333333333333333333333e0 * t69 * t115 * t56
  t393 = 0.1e1 / t67
  t400 = 0.17543244109220059985638668152930835075000000000000e0 * t81 * t85 * t87 * t123
  t401 = t84 * t2
  t402 = 0.1e1 / t401
  t403 = t83 * t402
  t404 = -t337 + t403
  t405 = 0.2e1 * t404
  t409 = t55 * t114
  t412 = t103 * t300
  t414 = t28 * t85
  t417 = 0.1e1 / t33 / t84
  t418 = t32 * t417
  t422 = (t97 * t409 / 0.12e2 - 0.13655000000000000000000000000000000000000000000000e-1 * t412 + 0.95775000000000000000000000000000000000000000000000e-2 * t414 - 0.46475000000000000000000000000000000000000000000000e-3 * t112 * t418) * t120
  t425 = 0.17543244109220059985638668152930835075000000000000e0 * t88 * t422 * t122
  t433 = 0.10999614056480977610995444931887633592025000000000e-1 * t81 * t417 * t87 * t118 * t30 * t32 * t120 * t122
  t437 = 0.56297817496241063242336011547015492384898550937892e-3 * t128 * t320 * t196 * t198
  t440 = f.my_piecewise3(t6, 0, 0.2e1 * t5 * t338)
  t444 = 0.3e1 / 0.10e2 * t440 * t44 * t136 * t160
  t448 = t137 * t34 * t141 * t159 / 0.5e1
  t449 = t134 * t231
  t452 = 0.1e1 / t140 / t138 * t149
  t453 = 0.1e1 / t132
  t454 = t158 * t453
  t458 = t449 * t452 * t454 * t338 / 0.5e1
  t459 = t114 * t144
  t461 = t143 * t459 * t139
  t462 = 0.18891666666666666666666666666666666666666666666667e-2 * t461
  t463 = t144 * t141
  t464 = t453 * t338
  t466 = t36 * t463 * t464
  t472 = 0.3e1 / 0.10e2 * t137 * t142 * (t462 + 0.18891666666666666666666666666666666666666666666667e-2 * t466) * t158
  t473 = t157 ** 2
  t475 = t149 / t473
  t476 = 0.35991666666666666666666666666666666666666666666667e-1 * t461
  t478 = t130 * t152
  t481 = 0.66666666666666666666666666666666666666666666666667e-2 * t151 * t478 * t140
  t483 = t152 / t139
  t491 = 0.3e1 / 0.10e2 * t137 * t142 * t475 * (-t476 - 0.35991666666666666666666666666666666666666666666667e-1 * t466 - t481 - 0.66666666666666666666666666666666666666666666666667e-2 * t107 * t483 * t464)
  t494 = f.my_piecewise3(t13, 0, 0.2e1 * t12 * t343)
  t498 = 0.3e1 / 0.10e2 * t494 * t44 * t136 * t183
  t502 = t166 * t34 * t170 * t182 / 0.5e1
  t503 = t165 * t231
  t506 = 0.1e1 / t169 / t167 * t175
  t507 = 0.1e1 / t163
  t508 = t181 * t507
  t512 = t503 * t506 * t508 * t343 / 0.5e1
  t514 = t143 * t459 * t168
  t515 = 0.18891666666666666666666666666666666666666666666667e-2 * t514
  t516 = t144 * t170
  t517 = t507 * t343
  t519 = t36 * t516 * t517
  t525 = 0.3e1 / 0.10e2 * t166 * t171 * (t515 + 0.18891666666666666666666666666666666666666666666667e-2 * t519) * t181
  t526 = t180 ** 2
  t528 = t175 / t526
  t529 = 0.35991666666666666666666666666666666666666666666667e-1 * t514
  t533 = 0.66666666666666666666666666666666666666666666666667e-2 * t151 * t478 * t169
  t535 = t152 / t168
  t543 = 0.3e1 / 0.10e2 * t166 * t171 * t528 * (-t529 - 0.35991666666666666666666666666666666666666666666667e-1 * t519 - t533 - 0.66666666666666666666666666666666666666666666666667e-2 * t107 * t535 * t517)
  t552 = 0.12e2 * t87 * (0.41250000000000000000000000000000000000000000000000e0 * t356 - t412 / 0.6e1) * t193
  t556 = 0.31000000000000000000000000000000000000000000000000e0 * t189 * t30 * t35 * t192
  t558 = 0.12e2 * t189 * t192
  t559 = 0.12e2 * t405 * t188 * t193 + t444 + t448 + t458 + t472 - t491 + t498 + t502 + t512 + t525 - t543 + t552 + t556 + t558
  t567 = 0.87716220546100299928193340764654175375000000000000e-1 * t414 * t207
  t568 = 0.6e1 * t404
  t572 = t422 / 0.2e1
  t577 = 0.31350000000000000000000000000000000000000000000000e-1 * t118 * t27 * t29 * t115 * t120
  t578 = t572 + t577 + t337 - t403
  t585 = 0.70372271870301329052920014433769365481123188672365e-3 * t128 * t320 * t234 * jnp.pi
  t596 = 0.3e1 * t87 * (0.32333333333333333333333333333333333333333333333333e-1 * t356 - 0.11266666666666666666666666666666666666666666666667e0 * t412) * t215 * t220
  t603 = 0.54699999999999999999999999999999999999999999999999e0 * t213 * t101 / t29 * t31 * t105 * t215
  t606 = 0.2e1 * t216 * t218 * t35
  t607 = t10 * t5
  t610 = f.my_piecewise3(t6, 0, 0.8e1 / 0.3e1 * t607 * t338)
  t611 = t15 * t12
  t614 = f.my_piecewise3(t13, 0, 0.8e1 / 0.3e1 * t611 * t343)
  t622 = 0.2e1 / 0.5e1 * t230 * t136 * t34
  t623 = t444 + t448 + t458 + t472 - t491 + t498 + t502 + t512 + t525 - t543 + 0.3e1 * t405 * t212 * t215 * t220 + t596 + t603 + t606 - 0.3e1 / 0.5e1 * (t610 / 0.2e1 + t614 / 0.2e1) * t44 * t231 - t622
  t630 = 0.56945186695483624893780150000000000000000000000000e0 * t112 * t418 * t293
  t633 = 0.11073470983333333333333333333333333333333333333333e-2 * t30 * t115 * t249
  t634 = t246 ** 2
  t638 = t353 * t27 * t409
  t641 = t36 ** 0.5e0
  t643 = t641 * t27 * t409
  t649 = t240 / t634 * (-0.39359271665000000000000000000000000000000000000000e-1 * t638 - 0.18590165886666666666666666666666666666666666666667e-1 * t356 - 0.63665980925000000000000000000000000000000000000000e-2 * t643 - 0.51086165526666666666666666666666666666666666666667e-2 * t412) / t248
  t653 = 0.4e1 * t83 * t1 * t253 * t289
  t658 = 0.4e1 * t251 / t252 / t2 * t289
  t661 = f.my_piecewise3(t6, 0, 0.4e1 / 0.3e1 * t9 * t338)
  t664 = f.my_piecewise3(t13, 0, 0.4e1 / 0.3e1 * t14 * t343)
  t666 = (t661 + t664) * t263
  t672 = t271 ** 2
  t686 = t282 ** 2
  t687 = 0.1e1 / t686
  t693 = -0.29149603883333333333333333333333333333333333333333e-1 * t638 - 0.10197154565000000000000000000000000000000000000000e-1 * t356 - 0.18581078242500000000000000000000000000000000000000e-2 * t643 - 0.27959640330000000000000000000000000000000000000000e-2 * t412
  t694 = 0.1e1 / t284
  t700 = t254 * t264 * (0.53237641966666666666666666666666666666666666666667e-3 * t30 * t115 * t274 + t266 / t672 * (-0.36580540352500000000000000000000000000000000000000e-1 * t638 - 0.16057569282500000000000000000000000000000000000000e-1 * t356 - 0.65410946462500000000000000000000000000000000000000e-2 * t643 - 0.32394954865000000000000000000000000000000000000000e-2 * t412) / t273 - t633 - t649 + 0.18311447306006545054854346104378990962041954983034e-3 * t30 * t115 * t285 + 0.58482236226346462072622386637590534819724553404281e0 * t277 * t687 * t693 * t694)
  t707 = 0.18311447306006545054854346104378990962041954983034e-3 * t264 * t27 * t55 * t114 * t285
  t712 = 0.58482236226346462072622386637590534819724553404281e0 * t264 * t277 * t687 * t693 * t694
  t713 = t633 + t649 + t653 - t658 + t254 * t666 * t288 + t700 + 0.58482236226346462072622386637590534819724553404281e0 * t666 * t286 - t707 - t712
  t723 = 0.11259563499248212648467202309403098476979710187578e-1 * t127 * t31 * t320 * t87 * t305
  t730 = 0.67557380995489275890803213856418590861878261125470e-2 * t302 * t422 * t304
  t738 = 0.50830173461006131180240338105569347764477203670804e-2 / t79 / t25 * t402 * t87 * t121 * t122 * t303
  t742 = 0.56297817496241063242336011547015492384898550937892e-2 * t128 * t320 * t204 * t309
  t753 = 0.10525946465532035991383200891758501045000000000000e1 * t26 * t402 * t293
  t763 = 0.54045904796391420712642571085134872689502608900376e-1 * t128 / t104 / t401 * t293 * t322
  t768 = 0.3e1 * t335 * t77 * t348 + t352 * ((-t358 - t361 - t365 - t366 * t368 / 0.2e1 - t374 - 0.14690400000000000000000000000000000000000000000000e1 * t63 * t376 * t348) * t74 - t384 * (-t358 - t361 - t387 - 0.17242550000000000000000000000000000000000000000000e1 * t69 * t368)) * t393 * t73 + (t400 - 0.17543244109220059985638668152930835075000000000000e0 * t82 * t405 * t123 - t425 - t433 + t437 - 0.33778690497744637945401606928209295430939130562735e-3 * t128 * t130 * t559 * t198) * t61 + (t567 - 0.87716220546100299928193340764654175375000000000000e-1 * t109 * t568 * t206 - 0.87716220546100299928193340764654175375000000000000e-1 * t109 * t204 * t578 + t585 - 0.42223363122180797431752008660261619288673913203419e-3 * t128 * t130 * t623 * jnp.pi - t630 + 0.42708890021612718670335112500000000000000000000000e0 * t112 * t115 * t713) * t298 + t723 - 0.67557380995489275890803213856418590861878261125470e-2 * t127 * t300 * t405 * t305 - t730 - t738 + (t742 - 0.33778690497744637945401606928209295430939130562735e-2 * t128 * t130 * t568 * t309 - 0.33778690497744637945401606928209295430939130562735e-2 * t128 * t308 * t578 * jnp.pi - t753 + 0.52629732327660179956916004458792505225000000000000e0 * t313 * t713) * t317 - t763 + 0.20267214298646782767240964156925577258563478337641e-1 * t128 * t320 * t713 * t322
  t778 = 0.41076328840066666666666666666666666666666666666668e0 * t105 * t326 / t332 / t330 * t103 * t31 * t52
  vrho_0_ = t2 * t768 * t333 + t334 + t778
  t779 = -t3 - t337
  t782 = f.my_piecewise3(t6, 0, 0.2e1 / 0.3e1 * t336 * t779)
  t783 = -t779
  t786 = f.my_piecewise3(t13, 0, 0.2e1 / 0.3e1 * t342 * t783)
  t788 = t782 / 0.2e1 + t786 / 0.2e1
  t794 = 0.29230250000000000000000000000000000000000000000000e1 * t38 * t56 * t788
  t796 = t35 * t64 * t788
  t812 = t337 + t403
  t813 = 0.2e1 * t812
  t819 = f.my_piecewise3(t6, 0, 0.2e1 * t5 * t779)
  t823 = 0.3e1 / 0.10e2 * t819 * t44 * t136 * t160
  t827 = t449 * t452 * t454 * t779 / 0.5e1
  t828 = t453 * t779
  t830 = t36 * t463 * t828
  t836 = 0.3e1 / 0.10e2 * t137 * t142 * (t462 + 0.18891666666666666666666666666666666666666666666667e-2 * t830) * t158
  t845 = 0.3e1 / 0.10e2 * t137 * t142 * t475 * (-t476 - 0.35991666666666666666666666666666666666666666666667e-1 * t830 - t481 - 0.66666666666666666666666666666666666666666666666667e-2 * t107 * t483 * t828)
  t848 = f.my_piecewise3(t13, 0, 0.2e1 * t12 * t783)
  t852 = 0.3e1 / 0.10e2 * t848 * t44 * t136 * t183
  t856 = t503 * t506 * t508 * t783 / 0.5e1
  t857 = t507 * t783
  t859 = t36 * t516 * t857
  t865 = 0.3e1 / 0.10e2 * t166 * t171 * (t515 + 0.18891666666666666666666666666666666666666666666667e-2 * t859) * t181
  t874 = 0.3e1 / 0.10e2 * t166 * t171 * t528 * (-t529 - 0.35991666666666666666666666666666666666666666666667e-1 * t859 - t533 - 0.66666666666666666666666666666666666666666666666667e-2 * t107 * t535 * t857)
  t878 = 0.12e2 * t813 * t188 * t193 + t448 + t502 + t552 + t556 + t558 + t823 + t827 + t836 - t845 + t852 + t856 + t865 - t874
  t885 = 0.6e1 * t812
  t889 = t572 + t577 - t337 - t403
  t899 = f.my_piecewise3(t6, 0, 0.8e1 / 0.3e1 * t607 * t779)
  t902 = f.my_piecewise3(t13, 0, 0.8e1 / 0.3e1 * t611 * t783)
  t908 = t823 + t448 + t827 + t836 - t845 + t852 + t502 + t856 + t865 - t874 + 0.3e1 * t813 * t212 * t215 * t220 + t596 + t603 + t606 - 0.3e1 / 0.5e1 * (t899 / 0.2e1 + t902 / 0.2e1) * t44 * t231 - t622
  t915 = f.my_piecewise3(t6, 0, 0.4e1 / 0.3e1 * t9 * t779)
  t918 = f.my_piecewise3(t13, 0, 0.4e1 / 0.3e1 * t14 * t783)
  t920 = (t915 + t918) * t263
  t925 = t633 + t649 - t653 - t658 + t254 * t920 * t288 + t700 + 0.58482236226346462072622386637590534819724553404281e0 * t920 * t286 - t707 - t712
  t951 = 0.3e1 * t335 * t77 * t788 + t352 * ((-t358 - t794 - t365 - t366 * t796 / 0.2e1 - t374 - 0.14690400000000000000000000000000000000000000000000e1 * t63 * t376 * t788) * t74 - t384 * (-t358 - t794 - t387 - 0.17242550000000000000000000000000000000000000000000e1 * t69 * t796)) * t393 * t73 + (t400 - 0.17543244109220059985638668152930835075000000000000e0 * t82 * t813 * t123 - t425 - t433 + t437 - 0.33778690497744637945401606928209295430939130562735e-3 * t128 * t130 * t878 * t198) * t61 + (t567 - 0.87716220546100299928193340764654175375000000000000e-1 * t109 * t885 * t206 - 0.87716220546100299928193340764654175375000000000000e-1 * t109 * t204 * t889 + t585 - 0.42223363122180797431752008660261619288673913203419e-3 * t128 * t130 * t908 * jnp.pi - t630 + 0.42708890021612718670335112500000000000000000000000e0 * t112 * t115 * t925) * t298 + t723 - 0.67557380995489275890803213856418590861878261125470e-2 * t127 * t300 * t813 * t305 - t730 - t738 + (t742 - 0.33778690497744637945401606928209295430939130562735e-2 * t128 * t130 * t885 * t309 - 0.33778690497744637945401606928209295430939130562735e-2 * t128 * t308 * t889 * jnp.pi - t753 + 0.52629732327660179956916004458792505225000000000000e0 * t313 * t925) * t317 - t763 + 0.20267214298646782767240964156925577258563478337641e-1 * t128 * t320 * t925 * t322
  vrho_1_ = t2 * t951 * t333 + t334 + t778
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  alpha = (4 / (9 * jnp.pi)) ** (1 / 3)

  g0_C = 0.08193

  g0_D = -0.01277

  g0_E = 0.001859

  g0_dd = 0.7524

  pmgb_phi = lambda n, z: (f.opz_pow_n(z, n / 3) + f.opz_pow_n(-z, n / 3)) / 2

  pmgb_Q_a = 5.84605

  pmgb_Q_c = 3.91744

  pmgb_Q_d = 3.44851

  pmgb_b0 = lambda rs: 0.784949 * rs

  pmgb_D2 = lambda rs: (-0.388 * rs + 0.676 * rs ** 2) * jnp.exp(-0.547 * rs) / rs ** 2

  pmgb_D3 = lambda rs: (-4.95 * rs + rs ** 2) * jnp.exp(-0.31 * rs) / rs ** 3

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g0_aHD = -alpha * (jnp.pi ** 2 + 6 * jnp.log(2) - 3) / (5 * jnp.pi)

  pmgb_gpp1 = lambda rs: 2 ** (5 / 3) / (5 * alpha ** 2 * rs ** 2) * (1 - 0.02267 * rs) / (1 + 0.4319 * rs + 0.04 * rs ** 2)

  pmgb_Q_b = pmgb_Q_d - 3 * jnp.pi * alpha / (4 * jnp.log(2) - 4)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  g0_B = -2 * g0_aHD - g0_dd

  pmgb_cc4 = lambda rs, z: +(f.opz_pow_n(z, 2) / 4) * pmgb_gpp1(rs * (2 / (1 + z)) ** (1 / 3)) + f.opz_pow_n(-z, 2) / 4 * pmgb_gpp1(rs * (2 / (1 - z)) ** (1 / 3)) + (1 - z ** 2) * pmgb_D2(rs) - pmgb_phi(8, z) / (5 * alpha ** 2 * rs ** 2)

  pmgb_cc5 = lambda rs, z: +(f.opz_pow_n(z, 2) / 4) * pmgb_gpp1(rs * (2 / (1 + z)) ** (1 / 3)) + f.opz_pow_n(-z, 2) / 4 * pmgb_gpp1(rs * (2 / (1 - z)) ** (1 / 3)) + (1 - z ** 2) * pmgb_D3(rs)

  pmgb_Q = lambda x: (2 * jnp.log(2) - 2) / jnp.pi ** 2 * jnp.log((1 + pmgb_Q_a * x + pmgb_Q_b * x ** 2 + pmgb_Q_c * x ** 3) / (1 + pmgb_Q_a * x + pmgb_Q_d * x ** 2))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  pmgb_g0 = lambda rs: (1 - g0_B * rs + g0_C * rs ** 2 + g0_D * rs ** 3 + g0_E * rs ** 4) * jnp.exp(-g0_dd * rs) / 2

  pmgb_C4 = lambda rs, z: -9 * pmgb_cc4(rs, z) / (64 * rs ** 3)

  pmgb_C5 = lambda rs, z: -9 * pmgb_cc5(rs, z) / (40 * jnp.sqrt(2 * jnp.pi) * rs ** 3)

  pmgb_a5 = lambda rs, z: pmgb_b0(rs) ** 8 * f_pw(rs, z)

  pmgb_gc0 = lambda rs, z: pmgb_g0(rs) - 1 / 2 * (1 - z ** 2)

  pmgb_C3 = lambda rs, z: -(1 - z ** 2) * pmgb_g0(rs) / (jnp.sqrt(2 * jnp.pi) * rs ** 3)

  pmgb_C2 = lambda rs, z: -3 * (1 - z ** 2) * pmgb_gc0(rs, z) / (8 * rs ** 3)

  pmgb_a1 = lambda rs, z: 4 * pmgb_b0(rs) ** 6 * pmgb_C3(rs, z) + pmgb_b0(rs) ** 8 * pmgb_C5(rs, z)

  pmgb_a3 = lambda rs, z: pmgb_b0(rs) ** 8 * pmgb_C3(rs, z)

  pmgb_a2 = lambda rs, z: 4 * pmgb_b0(rs) ** 6 * pmgb_C2(rs, z) + pmgb_b0(rs) ** 8 * pmgb_C4(rs, z) + 6 * pmgb_b0(rs) ** 4 * f_pw(rs, z)

  pmgb_a4 = lambda rs, z: pmgb_b0(rs) ** 8 * pmgb_C2(rs, z) + 4 * pmgb_b0(rs) ** 6 * f_pw(rs, z)

  pmgb_ec_LR = lambda rs, z: (+pmgb_phi(2, z) ** 3 * pmgb_Q(f.p.cam_omega * jnp.sqrt(rs) / pmgb_phi(2, z)) + pmgb_a1(rs, z) * f.p.cam_omega ** 3 + pmgb_a2(rs, z) * f.p.cam_omega ** 4 + pmgb_a3(rs, z) * f.p.cam_omega ** 5 + pmgb_a4(rs, z) * f.p.cam_omega ** 6 + pmgb_a5(rs, z) * f.p.cam_omega ** 8) / (1 + pmgb_b0(rs) ** 2 * f.p.cam_omega ** 2) ** 4

  functional_body = lambda rs, z: pmgb_ec_LR(rs, z)

  t1 = 0.1e1 <= f.p.zeta_threshold
  t2 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = f.my_piecewise3(t1, t3, 1)
  t5 = t4 ** 2
  t6 = t5 * t4
  t7 = jnp.log(0.2e1)
  t8 = t7 - 0.1e1
  t10 = 0.2e1 * t6 * t8
  t11 = jnp.pi ** 2
  t12 = 0.1e1 / t11
  t13 = 3 ** (0.1e1 / 0.3e1)
  t14 = 0.1e1 / jnp.pi
  t15 = t14 ** (0.1e1 / 0.3e1)
  t16 = t13 * t15
  t17 = 4 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = 0.1e1 / t19
  t21 = t18 * t20
  t22 = t16 * t21
  t23 = jnp.sqrt(t22)
  t25 = 0.1e1 / t4
  t27 = 0.29230250000000000000000000000000000000000000000000e1 * f.p.cam_omega * t23 * t25
  t29 = 9 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t38 = f.p.cam_omega ** 2
  t40 = (0.344851e1 - jnp.pi * t17 * t30 * t15 / t8 / 0.12e2) * t38 * t13
  t41 = t15 * t18
  t42 = 0.1e1 / t5
  t47 = t38 * f.p.cam_omega
  t50 = 0.1e1 / t6
  t53 = 0.1e1 + t27 + t40 * t41 * t20 * t42 / 0.4e1 + 0.48968000000000000000000000000000000000000000000000e0 * t47 * t23 * t22 * t50
  t55 = t38 * t13 * t15
  t59 = 0.1e1 + t27 + 0.86212750000000000000000000000000000000000000000000e0 * t55 * t21 * t42
  t60 = 0.1e1 / t59
  t62 = jnp.log(t53 * t60)
  t65 = jnp.sqrt(jnp.pi)
  t67 = 0.1e1 / t65 / jnp.pi
  t68 = 0.1e1 / r0
  t69 = t67 * t68
  t78 = (0.2e1 / 0.45e2 * t17 * t30 * t15 * (t11 + 0.6e1 * t7 - 0.3e1) * t14 - 0.7524e0) * t13
  t82 = t13 ** 2
  t83 = t15 ** 2
  t84 = t82 * t83
  t85 = t19 ** 2
  t86 = 0.1e1 / t85
  t87 = t17 * t86
  t88 = t84 * t87
  t90 = t14 * t68
  t92 = t15 * t14
  t93 = t13 * t92
  t95 = 0.1e1 / t19 / r0
  t96 = t18 * t95
  t99 = 0.1e1 - t78 * t41 * t20 / 0.4e1 + 0.20482500000000000000000000000000000000000000000000e-1 * t88 - 0.95775000000000000000000000000000000000000000000000e-2 * t90 + 0.34856250000000000000000000000000000000000000000000e-3 * t93 * t96
  t101 = jnp.exp(-0.18810000000000000000000000000000000000000000000000e0 * t22)
  t102 = t99 * t101
  t103 = jnp.sqrt(0.2e1)
  t104 = t102 * t103
  t108 = t82 * t83 * t12
  t109 = t108 * t17
  t111 = 0.1e1 / t85 / r0
  t112 = f.p.zeta_threshold ** 2
  t113 = f.my_piecewise3(t1, t112, 1)
  t114 = t113 * t30
  t115 = 0.1e1 / t92
  t116 = t114 * t115
  t118 = 2 ** (0.1e1 / 0.3e1)
  t120 = t16 * t21 * t118
  t122 = 0.1e1 - 0.56675000000000000000000000000000000000000000000000e-2 * t120
  t124 = t118 ** 2
  t128 = 0.1e1 + 0.10797500000000000000000000000000000000000000000000e0 * t120 + 0.10000000000000000000000000000000000000000000000000e-1 * t84 * t87 * t124
  t129 = 0.1e1 / t128
  t130 = t122 * t129
  t133 = 0.3e1 / 0.5e1 * t116 * t13 * t85 * t130
  t136 = -0.12375000000000000000000000000000000000000000000000e1 * t22 + t88 / 0.4e1
  t138 = jnp.exp(-0.77500000000000000000000000000000000000000000000000e-1 * t22)
  t139 = t136 * t138
  t140 = jnp.pi * r0
  t143 = 0.12e2 * t139 * t140 + t133
  t145 = t103 * t65
  t152 = 0.3e1 / 0.2e1 * t102 - 0.3e1 / 0.2e1
  t157 = -0.97000000000000000000000000000000000000000000000000e-1 * t22 + 0.16900000000000000000000000000000000000000000000000e0 * t88
  t159 = jnp.exp(-0.13675000000000000000000000000000000000000000000000e0 * t22)
  t161 = t157 * t159 * t13
  t163 = 0.1e1 / t83 * t18
  t164 = t163 * t85
  t168 = f.my_piecewise3(t1, t3 * t112, 1)
  t169 = t168 * t30
  t170 = t115 * t13
  t174 = t133 + 0.3e1 * t161 * t164 - 0.3e1 / 0.5e1 * t169 * t170 * t85
  t180 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t22
  t183 = t22 ** 0.15e1
  t186 = 0.23615562999000000000000000000000000000000000000000e0 * t23 + 0.55770497660000000000000000000000000000000000000000e-1 * t22 + 0.12733196185000000000000000000000000000000000000000e-1 * t183 + 0.76629248290000000000000000000000000000000000000000e-2 * t88
  t188 = 0.1e1 + 0.1e1 / t186
  t189 = jnp.log(t188)
  t192 = f.my_piecewise3(t1, t2 * f.p.zeta_threshold, 1)
  t198 = (0.2e1 * t192 - 0.2e1) / (0.2e1 * t118 - 0.2e1)
  t200 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t22
  t205 = 0.17489762330000000000000000000000000000000000000000e0 * t23 + 0.30591463695000000000000000000000000000000000000000e-1 * t22 + 0.37162156485000000000000000000000000000000000000000e-2 * t183 + 0.41939460495000000000000000000000000000000000000000e-2 * t88
  t207 = 0.1e1 + 0.1e1 / t205
  t208 = jnp.log(t207)
  t212 = -t180 * t189 + 0.58482236226346462072622386637590534819724553404281e0 * t198 * t200 * t208
  t217 = t38 ** 2
  t219 = t17 * t111
  t220 = t108 * t219
  t221 = t217 * f.p.cam_omega
  t222 = t145 * t221
  t223 = t102 * t222
  t230 = r0 ** 2
  t231 = 0.1e1 / t230
  t232 = t12 * t231
  t236 = t217 * t38
  t239 = 0.1e1 / t85 / t230
  t241 = t217 ** 2
  t245 = t10 * t12 * t62 + (-0.17543244109220059985638668152930835075000000000000e0 * t69 * t104 - 0.33778690497744637945401606928209295430939130562735e-3 * t109 * t111 * t143 * t145) * t47 + (-0.87716220546100299928193340764654175375000000000000e-1 * t90 * t152 - 0.42223363122180797431752008660261619288673913203419e-3 * t109 * t111 * t174 * jnp.pi + 0.42708890021612718670335112500000000000000000000000e0 * t93 * t96 * t212) * t217 - 0.67557380995489275890803213856418590861878261125470e-2 * t220 * t223 + (-0.33778690497744637945401606928209295430939130562735e-2 * t109 * t111 * t152 * jnp.pi + 0.52629732327660179956916004458792505225000000000000e0 * t232 * t212) * t236 + 0.20267214298646782767240964156925577258563478337641e-1 * t109 * t239 * t212 * t241
  t249 = 0.1e1 + 0.15403623315025000000000000000000000000000000000000e0 * t84 * t87 * t38
  t250 = t249 ** 2
  t251 = t250 ** 2
  t252 = 0.1e1 / t251
  t255 = 0.1e1 / t23
  t258 = t16 * t96
  t260 = 0.48717083333333333333333333333333333333333333333333e0 * f.p.cam_omega * t255 * t25 * t258
  t271 = t59 ** 2
  t287 = t41 * t95
  t290 = t84 * t219
  t292 = t14 * t231
  t295 = 0.1e1 / t19 / t230
  t296 = t18 * t295
  t300 = (t78 * t287 / 0.12e2 - 0.13655000000000000000000000000000000000000000000000e-1 * t290 + 0.95775000000000000000000000000000000000000000000000e-2 * t292 - 0.46475000000000000000000000000000000000000000000000e-3 * t93 * t296) * t101
  t305 = t99 * t13
  t307 = t101 * t103
  t318 = 0.2e1 / 0.5e1 * t116 * t13 * t20 * t130
  t325 = 0.11335000000000000000000000000000000000000000000000e-2 * t114 * jnp.pi * t82 * t86 * t18 * t118 * t129
  t328 = t128 ** 2
  t340 = 0.3e1 / 0.5e1 * t114 * t170 * t85 * t122 / t328 * (-0.35991666666666666666666666666666666666666666666667e-1 * t16 * t96 * t118 - 0.66666666666666666666666666666666666666666666666667e-2 * t84 * t219 * t124)
  t369 = 0.3e1 / 0.2e1 * t300 + 0.94050000000000000000000000000000000000000000000000e-1 * t305 * t15 * t96 * t101
  t406 = t186 ** 2
  t410 = t255 * t13 * t287
  t413 = t22 ** 0.5e0
  t415 = t413 * t13 * t287
  t428 = t205 ** 2
  t440 = 0.11073470983333333333333333333333333333333333333333e-2 * t16 * t96 * t189 + t180 / t406 * (-0.39359271665000000000000000000000000000000000000000e-1 * t410 - 0.18590165886666666666666666666666666666666666666667e-1 * t258 - 0.63665980925000000000000000000000000000000000000000e-2 * t415 - 0.51086165526666666666666666666666666666666666666667e-2 * t290) / t188 - 0.18311447306006545054854346104378990962041954983034e-3 * t198 * t13 * t41 * t95 * t208 - 0.58482236226346462072622386637590534819724553404281e0 * t198 * t200 / t428 * (-0.29149603883333333333333333333333333333333333333333e-1 * t410 - 0.10197154565000000000000000000000000000000000000000e-1 * t258 - 0.18581078242500000000000000000000000000000000000000e-2 * t415 - 0.27959640330000000000000000000000000000000000000000e-2 * t290) / t207
  t455 = t230 * r0
  t456 = 0.1e1 / t455
  vrho_0_ = t245 * t252 + r0 * (t10 * t12 * ((-t260 - t40 * t41 * t95 * t42 / 0.12e2 - 0.24484000000000000000000000000000000000000000000000e0 * t47 * t23 * t50 * t258) * t60 - t53 / t271 * (-t260 - 0.28737583333333333333333333333333333333333333333333e0 * t55 * t96 * t42)) / t53 * t59 + (0.17543244109220059985638668152930835075000000000000e0 * t67 * t231 * t104 - 0.17543244109220059985638668152930835075000000000000e0 * t69 * t300 * t103 - 0.10999614056480977610995444931887633592025000000000e-1 * t67 * t295 * t305 * t41 * t307 + 0.56297817496241063242336011547015492384898550937892e-3 * t109 * t239 * t143 * t145 - 0.33778690497744637945401606928209295430939130562735e-3 * t109 * t111 * (t318 + t325 - t340 + 0.12e2 * (0.41250000000000000000000000000000000000000000000000e0 * t258 - t290 / 0.6e1) * t138 * t140 + 0.31000000000000000000000000000000000000000000000000e0 * t136 * t13 * t15 * t21 * t138 * jnp.pi + 0.12e2 * t139 * jnp.pi) * t145) * t47 + (0.87716220546100299928193340764654175375000000000000e-1 * t292 * t152 - 0.87716220546100299928193340764654175375000000000000e-1 * t90 * t369 + 0.70372271870301329052920014433769365481123188672365e-3 * t109 * t239 * t174 * jnp.pi - 0.42223363122180797431752008660261619288673913203419e-3 * t109 * t111 * (t318 + t325 - t340 + 0.3e1 * (0.32333333333333333333333333333333333333333333333333e-1 * t258 - 0.11266666666666666666666666666666666666666666666667e0 * t290) * t159 * t13 * t164 + 0.54699999999999999999999999999999999999999999999999e0 * t157 * t82 / t15 * t87 * t159 + 0.2e1 * t161 * t163 * t20 - 0.2e1 / 0.5e1 * t169 * t170 * t20) * jnp.pi - 0.56945186695483624893780150000000000000000000000000e0 * t93 * t296 * t212 + 0.42708890021612718670335112500000000000000000000000e0 * t93 * t96 * t440) * t217 + 0.11259563499248212648467202309403098476979710187578e-1 * t108 * t17 * t239 * t223 - 0.67557380995489275890803213856418590861878261125470e-2 * t220 * t300 * t222 - 0.50830173461006131180240338105569347764477203670804e-2 / t65 / t11 * t456 * t99 * t307 * t221 + (0.56297817496241063242336011547015492384898550937892e-2 * t109 * t239 * t152 * jnp.pi - 0.33778690497744637945401606928209295430939130562735e-2 * t109 * t111 * t369 * jnp.pi - 0.10525946465532035991383200891758501045000000000000e1 * t12 * t456 * t212 + 0.52629732327660179956916004458792505225000000000000e0 * t232 * t440) * t236 - 0.54045904796391420712642571085134872689502608900376e-1 * t109 / t85 / t455 * t212 * t241 + 0.20267214298646782767240964156925577258563478337641e-1 * t109 * t239 * t440 * t241) * t252 + 0.41076328840066666666666666666666666666666666666668e0 * t86 * t245 / t251 / t249 * t84 * t17 * t38
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  res = {'vrho': vrho_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 0.1e1 <= f.p.zeta_threshold
  t2 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = f.my_piecewise3(t1, t3, 1)
  t5 = t4 ** 2
  t6 = t5 * t4
  t7 = jnp.log(0.2e1)
  t8 = t7 - 0.1e1
  t10 = 0.2e1 * t6 * t8
  t11 = jnp.pi ** 2
  t12 = 0.1e1 / t11
  t13 = t10 * t12
  t14 = 3 ** (0.1e1 / 0.3e1)
  t15 = 0.1e1 / jnp.pi
  t16 = t15 ** (0.1e1 / 0.3e1)
  t17 = t14 * t16
  t18 = 4 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t20 = r0 ** (0.1e1 / 0.3e1)
  t21 = 0.1e1 / t20
  t22 = t19 * t21
  t23 = t17 * t22
  t24 = jnp.sqrt(t23)
  t25 = 0.1e1 / t24
  t27 = 0.1e1 / t4
  t28 = f.p.cam_omega * t25 * t27
  t30 = 0.1e1 / t20 / r0
  t31 = t19 * t30
  t32 = t17 * t31
  t34 = 0.48717083333333333333333333333333333333333333333333e0 * t28 * t32
  t36 = 9 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t45 = f.p.cam_omega ** 2
  t47 = (0.344851e1 - jnp.pi * t18 * t37 * t16 / t8 / 0.12e2) * t45 * t14
  t48 = t16 * t19
  t49 = 0.1e1 / t5
  t54 = t45 * f.p.cam_omega
  t56 = 0.1e1 / t6
  t57 = t54 * t24 * t56
  t60 = -t34 - t47 * t48 * t30 * t49 / 0.12e2 - 0.24484000000000000000000000000000000000000000000000e0 * t57 * t32
  t63 = 0.29230250000000000000000000000000000000000000000000e1 * f.p.cam_omega * t24 * t27
  t65 = t45 * t14 * t16
  t69 = 0.1e1 + t63 + 0.86212750000000000000000000000000000000000000000000e0 * t65 * t22 * t49
  t70 = 0.1e1 / t69
  t76 = t24 * t23
  t80 = 0.1e1 + t63 + t47 * t48 * t21 * t49 / 0.4e1 + 0.48968000000000000000000000000000000000000000000000e0 * t54 * t76 * t56
  t81 = t69 ** 2
  t82 = 0.1e1 / t81
  t83 = t80 * t82
  t87 = -t34 - 0.28737583333333333333333333333333333333333333333333e0 * t65 * t31 * t49
  t89 = t60 * t70 - t83 * t87
  t90 = 0.1e1 / t80
  t91 = t89 * t90
  t94 = jnp.sqrt(jnp.pi)
  t96 = 0.1e1 / t94 / jnp.pi
  t97 = r0 ** 2
  t98 = 0.1e1 / t97
  t99 = t96 * t98
  t108 = (0.2e1 / 0.45e2 * t18 * t37 * t16 * (t11 + 0.6e1 * t7 - 0.3e1) * t15 - 0.7524e0) * t14
  t112 = t14 ** 2
  t113 = t16 ** 2
  t114 = t112 * t113
  t115 = t20 ** 2
  t116 = 0.1e1 / t115
  t117 = t18 * t116
  t118 = t114 * t117
  t120 = 0.1e1 / r0
  t121 = t15 * t120
  t123 = t16 * t15
  t124 = t14 * t123
  t127 = 0.1e1 - t108 * t48 * t21 / 0.4e1 + 0.20482500000000000000000000000000000000000000000000e-1 * t118 - 0.95775000000000000000000000000000000000000000000000e-2 * t121 + 0.34856250000000000000000000000000000000000000000000e-3 * t124 * t31
  t129 = jnp.exp(-0.18810000000000000000000000000000000000000000000000e0 * t23)
  t130 = t127 * t129
  t131 = jnp.sqrt(0.2e1)
  t132 = t130 * t131
  t135 = t96 * t120
  t136 = t48 * t30
  t140 = 0.1e1 / t115 / r0
  t141 = t18 * t140
  t142 = t114 * t141
  t144 = t15 * t98
  t147 = 0.1e1 / t20 / t97
  t148 = t19 * t147
  t151 = t108 * t136 / 0.12e2 - 0.13655000000000000000000000000000000000000000000000e-1 * t142 + 0.95775000000000000000000000000000000000000000000000e-2 * t144 - 0.46475000000000000000000000000000000000000000000000e-3 * t124 * t148
  t152 = t151 * t129
  t153 = t152 * t131
  t156 = t96 * t147
  t157 = t127 * t14
  t159 = t129 * t131
  t160 = t48 * t159
  t164 = t112 * t113 * t12
  t165 = t164 * t18
  t167 = 0.1e1 / t115 / t97
  t168 = f.p.zeta_threshold ** 2
  t169 = f.my_piecewise3(t1, t168, 1)
  t170 = t169 * t37
  t171 = 0.1e1 / t123
  t172 = t170 * t171
  t174 = 2 ** (0.1e1 / 0.3e1)
  t176 = t17 * t22 * t174
  t178 = 0.1e1 - 0.56675000000000000000000000000000000000000000000000e-2 * t176
  t180 = t174 ** 2
  t184 = 0.1e1 + 0.10797500000000000000000000000000000000000000000000e0 * t176 + 0.10000000000000000000000000000000000000000000000000e-1 * t114 * t117 * t180
  t185 = 0.1e1 / t184
  t186 = t178 * t185
  t189 = t172 * t14 * t115 * t186 / 0.15e2
  t192 = -0.12375000000000000000000000000000000000000000000000e1 * t23 + t118 / 0.4e1
  t194 = jnp.exp(-0.77500000000000000000000000000000000000000000000000e-1 * t23)
  t195 = t192 * t194
  t196 = jnp.pi * r0
  t199 = t189 + 0.4e1 / 0.3e1 * t195 * t196
  t201 = t131 * t94
  t208 = 0.2e1 / 0.45e2 * t172 * t14 * t21 * t186
  t210 = t170 * jnp.pi * t112
  t211 = t116 * t19
  t212 = t174 * t185
  t215 = 0.12594444444444444444444444444444444444444444444445e-3 * t210 * t211 * t212
  t216 = t171 * t14
  t217 = t170 * t216
  t218 = t115 * t178
  t219 = t184 ** 2
  t220 = 0.1e1 / t219
  t227 = -0.35991666666666666666666666666666666666666666666667e-1 * t17 * t31 * t174 - 0.66666666666666666666666666666666666666666666666667e-2 * t114 * t141 * t180
  t228 = t220 * t227
  t231 = t217 * t218 * t228 / 0.15e2
  t234 = 0.41250000000000000000000000000000000000000000000000e0 * t32 - t142 / 0.6e1
  t235 = t234 * t194
  t239 = t192 * t14 * t16
  t240 = t194 * jnp.pi
  t241 = t22 * t240
  t246 = t208 + t215 - t231 + 0.4e1 / 0.3e1 * t235 * t196 + 0.34444444444444444444444444444444444444444444444444e-1 * t239 * t241 + 0.4e1 / 0.3e1 * t195 * jnp.pi
  t254 = t130 / 0.2e1 - 0.1e1 / 0.2e1
  t258 = t157 * t16
  t259 = t31 * t129
  t262 = t152 / 0.2e1 + 0.31350000000000000000000000000000000000000000000000e-1 * t258 * t259
  t267 = -0.97000000000000000000000000000000000000000000000000e-1 * t23 + 0.16900000000000000000000000000000000000000000000000e0 * t118
  t269 = jnp.exp(-0.13675000000000000000000000000000000000000000000000e0 * t23)
  t271 = t267 * t269 * t14
  t273 = 0.1e1 / t113 * t19
  t274 = t273 * t115
  t278 = f.my_piecewise3(t1, t3 * t168, 1)
  t279 = t278 * t37
  t283 = t189 + t271 * t274 / 0.3e1 - t279 * t216 * t115 / 0.15e2
  t290 = 0.32333333333333333333333333333333333333333333333333e-1 * t32 - 0.11266666666666666666666666666666666666666666666667e0 * t142
  t292 = t290 * t269 * t14
  t296 = 0.1e1 / t16
  t298 = t117 * t269
  t301 = t273 * t21
  t307 = t208 + t215 - t231 + t292 * t274 / 0.3e1 + 0.60777777777777777777777777777777777777777777777777e-1 * t267 * t112 * t296 * t298 + 0.2e1 / 0.9e1 * t271 * t301 - 0.2e1 / 0.45e2 * t279 * t216 * t21
  t313 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t23
  t316 = t23 ** 0.15e1
  t319 = 0.37978500000000000000000000000000000000000000000000e1 * t24 + 0.89690000000000000000000000000000000000000000000000e0 * t23 + 0.20477500000000000000000000000000000000000000000000e0 * t316 + 0.12323500000000000000000000000000000000000000000000e0 * t118
  t322 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t319
  t323 = jnp.log(t322)
  t327 = f.my_piecewise3(t1, t2 * f.p.zeta_threshold, 1)
  t333 = (0.2e1 * t327 - 0.2e1) / (0.2e1 * t174 - 0.2e1)
  t335 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t23
  t340 = 0.51785000000000000000000000000000000000000000000000e1 * t24 + 0.90577500000000000000000000000000000000000000000000e0 * t23 + 0.11003250000000000000000000000000000000000000000000e0 * t316 + 0.12417750000000000000000000000000000000000000000000e0 * t118
  t343 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t340
  t344 = jnp.log(t343)
  t348 = -0.621814e-1 * t313 * t323 + 0.19751673498613801407483339618206552048944131217655e-1 * t333 * t335 * t344
  t355 = t319 ** 2
  t356 = 0.1e1 / t355
  t357 = t313 * t356
  t358 = t25 * t14
  t359 = t358 * t136
  t362 = t23 ** 0.5e0
  t363 = t362 * t14
  t364 = t363 * t136
  t367 = -0.63297500000000000000000000000000000000000000000000e0 * t359 - 0.29896666666666666666666666666666666666666666666667e0 * t32 - 0.10238750000000000000000000000000000000000000000000e0 * t364 - 0.82156666666666666666666666666666666666666666666667e-1 * t142
  t368 = 0.1e1 / t322
  t369 = t367 * t368
  t372 = t333 * t14
  t377 = t333 * t335
  t378 = t340 ** 2
  t379 = 0.1e1 / t378
  t384 = -0.86308333333333333333333333333333333333333333333334e0 * t359 - 0.30192500000000000000000000000000000000000000000000e0 * t32 - 0.55016250000000000000000000000000000000000000000000e-1 * t364 - 0.82785000000000000000000000000000000000000000000000e-1 * t142
  t386 = 0.1e1 / t343
  t387 = t379 * t384 * t386
  t390 = 0.11073470983333333333333333333333333333333333333333e-2 * t17 * t31 * t323 + 0.10000000000000000000000000000000000000000000000000e1 * t357 * t369 - 0.18311447306006545054854346104378990962041954983034e-3 * t372 * t48 * t30 * t344 - 0.58482236226346462072622386637590534819724553404280e0 * t377 * t387
  t395 = t45 ** 2
  t397 = t18 * t167
  t398 = t164 * t397
  t399 = t395 * f.p.cam_omega
  t400 = t201 * t399
  t401 = t130 * t400
  t404 = t164 * t141
  t405 = t152 * t400
  t409 = 0.1e1 / t94 / t11
  t410 = t97 * r0
  t411 = 0.1e1 / t410
  t412 = t409 * t411
  t414 = t159 * t399
  t425 = t12 * t411
  t428 = t12 * t98
  t432 = t395 * t45
  t435 = 0.1e1 / t115 / t410
  t437 = t395 ** 2
  t445 = t13 * t91 * t69 + (0.17543244109220059985638668152930835075000000000000e0 * t99 * t132 - 0.17543244109220059985638668152930835075000000000000e0 * t135 * t153 - 0.10999614056480977610995444931887633592025000000000e-1 * t156 * t157 * t160 + 0.50668035746616956918102410392313943146408695844103e-2 * t165 * t167 * t199 * t201 - 0.30400821447970174150861446235388365887845217506462e-2 * t165 * t140 * t246 * t201) * t54 + (0.26314866163830089978458002229396252612500000000000e0 * t144 * t254 - 0.26314866163830089978458002229396252612500000000000e0 * t121 * t262 + 0.63335044683271196147628012990392428933010869805128e-2 * t165 * t167 * t283 * jnp.pi - 0.38001026809962717688576807794235457359806521883077e-2 * t165 * t140 * t307 * jnp.pi - 0.56945186695483624893780150000000000000000000000000e0 * t124 * t148 * t348 + 0.42708890021612718670335112500000000000000000000000e0 * t124 * t31 * t390) * t395 + 0.11259563499248212648467202309403098476979710187578e-1 * t398 * t401 - 0.67557380995489275890803213856418590861878261125470e-2 * t404 * t405 - 0.50830173461006131180240338105569347764477203670804e-2 * t412 * t127 * t414 + (0.16889345248872318972700803464104647715469565281367e-1 * t165 * t167 * t254 * jnp.pi - 0.10133607149323391383620482078462788629281739168820e-1 * t165 * t140 * t262 * jnp.pi - 0.10525946465532035991383200891758501045000000000000e1 * t425 * t348 + 0.52629732327660179956916004458792505225000000000000e0 * t428 * t390) * t432 - 0.54045904796391420712642571085134872689502608900376e-1 * t165 * t435 * t348 * t437 + 0.20267214298646782767240964156925577258563478337641e-1 * t165 * t167 * t390 * t437
  t449 = 0.1e1 + 0.15403623315025000000000000000000000000000000000000e0 * t114 * t117 * t45
  t450 = t449 ** 2
  t451 = t450 ** 2
  t452 = 0.1e1 / t451
  t456 = jnp.log(t80 * t70)
  t492 = t10 * t12 * t456 + (-0.17543244109220059985638668152930835075000000000000e0 * t135 * t132 - 0.30400821447970174150861446235388365887845217506462e-2 * t165 * t140 * t199 * t201) * t54 + (-0.26314866163830089978458002229396252612500000000000e0 * t121 * t254 - 0.38001026809962717688576807794235457359806521883077e-2 * t165 * t140 * t283 * jnp.pi + 0.42708890021612718670335112500000000000000000000000e0 * t124 * t31 * t348) * t395 - 0.67557380995489275890803213856418590861878261125470e-2 * t404 * t401 + (-0.10133607149323391383620482078462788629281739168820e-1 * t165 * t140 * t254 * jnp.pi + 0.52629732327660179956916004458792505225000000000000e0 * t428 * t348) * t432 + 0.20267214298646782767240964156925577258563478337641e-1 * t165 * t167 * t348 * t437
  t494 = 0.1e1 / t451 / t449
  t497 = t113 * t18
  t502 = 0.1e1 / t76
  t505 = t114 * t397
  t507 = 0.32478055555555555555555555555555555555555555555555e0 * f.p.cam_omega * t502 * t27 * t505
  t508 = t17 * t148
  t510 = 0.64956111111111111111111111111111111111111111111111e0 * t28 * t508
  t529 = t87 ** 2
  t541 = t80 ** 2
  t555 = 0.1e1 / t20 / t410
  t560 = t48 * t147
  t564 = t15 * t411
  t566 = t19 * t555
  t570 = (-t108 * t560 / 0.9e1 + 0.22758333333333333333333333333333333333333333333333e-1 * t505 - 0.19155000000000000000000000000000000000000000000000e-1 * t564 + 0.10844166666666666666666666666666666666666666666667e-2 * t124 * t566) * t129
  t574 = t151 * t14
  t579 = t127 * t112
  t595 = 0.2e1 / 0.135e3 * t172 * t14 * t30 * t186
  t599 = 0.3e-53 * t210 * t140 * t19 * t212
  t603 = 0.4e1 / 0.45e2 * t217 * t21 * t178 * t228
  t608 = 0.25188888888888888888888888888888888888888888888890e-3 * t210 * t211 * t174 * t220 * t227
  t611 = t227 ** 2
  t615 = 0.2e1 / 0.15e2 * t217 * t218 / t219 / t184 * t611
  t626 = t217 * t218 * t220 * (0.47988888888888888888888888888888888888888888888889e-1 * t17 * t148 * t174 + 0.11111111111111111111111111111111111111111111111111e-1 * t114 * t397 * t180) / 0.15e2
  t647 = -t595 - t599 - t603 - t608 + t615 - t626 + 0.4e1 / 0.3e1 * (-0.55000000000000000000000000000000000000000000000000e0 * t508 + 0.5e1 / 0.18e2 * t505) * t194 * t196 + 0.68888888888888888888888888888888888888888888888888e-1 * t234 * t14 * t16 * t241 + 0.8e1 / 0.3e1 * t235 * jnp.pi + 0.22962962962962962962962962962962962962962962962963e-1 * t239 * t31 * t240 + 0.35592592592592592592592592592592592592592592592591e-2 * t192 * t112 * t113 * t141 * t240
  t669 = t570 / 0.2e1 + 0.62700000000000000000000000000000000000000000000000e-1 * t574 * t16 * t259 - 0.41800000000000000000000000000000000000000000000000e-1 * t258 * t148 * t129 + 0.78625800000000000000000000000000000000000000000000e-2 * t579 * t113 * t397 * t129
  t702 = -t595 - t599 - t603 - t608 + t615 - t626 + (-0.43111111111111111111111111111111111111111111111111e-1 * t508 + 0.18777777777777777777777777777777777777777777777778e0 * t505) * t269 * t14 * t274 / 0.3e1 + 0.12155555555555555555555555555555555555555555555555e0 * t290 * t112 * t296 * t298 + 0.4e1 / 0.9e1 * t292 * t301 + 0.33245444444444444444444444444444444444444444444444e-1 * t267 * t98 * t269 - 0.2e1 / 0.27e2 * t271 * t273 * t30 + 0.2e1 / 0.135e3 * t279 * t216 * t30
  t724 = t367 ** 2
  t729 = t497 * t167
  t730 = t502 * t112 * t729
  t732 = t358 * t560
  t735 = t23 ** (-0.5e0)
  t737 = t735 * t112 * t729
  t739 = t363 * t560
  t746 = t355 ** 2
  t749 = t322 ** 2
  t764 = t384 ** 2
  t780 = t378 ** 2
  t783 = t343 ** 2
  t788 = -0.14764627977777777777777777777777777777777777777777e-2 * t17 * t148 * t323 - 0.35616666666666666666666666666666666666666666666666e-1 * t17 * t19 * t30 * t356 * t369 - 0.20000000000000000000000000000000000000000000000000e1 * t313 / t355 / t319 * t724 * t368 + 0.10000000000000000000000000000000000000000000000000e1 * t357 * (-0.42198333333333333333333333333333333333333333333333e0 * t730 + 0.84396666666666666666666666666666666666666666666666e0 * t732 + 0.39862222222222222222222222222222222222222222222223e0 * t508 + 0.68258333333333333333333333333333333333333333333333e-1 * t737 + 0.13651666666666666666666666666666666666666666666667e0 * t739 + 0.13692777777777777777777777777777777777777777777778e0 * t505) * t368 + 0.16081979498692535066756296899072713062105388428051e2 * t313 / t746 * t724 / t749 + 0.24415263074675393406472461472505321282722606644045e-3 * t372 * t48 * t147 * t344 + 0.10843581300301739842632067522386578331157260943710e-1 * t333 * t17 * t31 * t387 + 0.11696447245269292414524477327518106963944910680856e1 * t377 / t378 / t340 * t764 * t386 - 0.58482236226346462072622386637590534819724553404280e0 * t377 * t379 * (-0.57538888888888888888888888888888888888888888888889e0 * t730 + 0.11507777777777777777777777777777777777777777777778e1 * t732 + 0.40256666666666666666666666666666666666666666666667e0 * t508 + 0.36677500000000000000000000000000000000000000000000e-1 * t737 + 0.73355000000000000000000000000000000000000000000000e-1 * t739 + 0.13797500000000000000000000000000000000000000000000e0 * t505) * t386 - 0.17315859105681463759666483083807725165579399831905e2 * t377 / t780 * t764 / t783
  t800 = t97 ** 2
  t801 = 0.1e1 / t800
  t854 = t13 * ((-t507 + t510 + t47 * t48 * t147 * t49 / 0.9e1 + 0.16322666666666666666666666666666666666666666666667e0 * t54 * t25 * t56 * t505 + 0.32645333333333333333333333333333333333333333333333e0 * t57 * t508) * t70 - 0.2e1 * t60 * t82 * t87 + 0.2e1 * t80 / t81 / t69 * t529 - t83 * (-t507 + t510 + 0.38316777777777777777777777777777777777777777777777e0 * t65 * t148 * t49)) * t90 * t69 - t13 * t89 / t541 * t69 * t60 + t13 * t91 * t87 + (-0.35086488218440119971277336305861670150000000000000e0 * t96 * t411 * t132 + 0.35086488218440119971277336305861670150000000000000e0 * t99 * t153 + 0.36665380188269925369984816439625445306750000000000e-1 * t96 * t555 * t157 * t160 - 0.17543244109220059985638668152930835075000000000000e0 * t135 * t570 * t131 - 0.21999228112961955221990889863775267184050000000000e-1 * t156 * t574 * t160 - 0.27587032053654291848376575889174185048798700000000e-2 * t96 * t435 * t579 * t497 * t159 - 0.13511476199097855178160642771283718172375652225094e-1 * t165 * t435 * t199 * t201 + 0.10133607149323391383620482078462788629281739168821e-1 * t165 * t167 * t246 * t201 - 0.30400821447970174150861446235388365887845217506462e-2 * t165 * t140 * t647 * t201) * t54 + (-0.52629732327660179956916004458792505225000000000000e0 * t564 * t254 + 0.52629732327660179956916004458792505225000000000000e0 * t144 * t262 - 0.26314866163830089978458002229396252612500000000000e0 * t121 * t669 - 0.16889345248872318972700803464104647715469565281367e-1 * t165 * t435 * t283 * jnp.pi + 0.12667008936654239229525602598078485786602173961026e-1 * t165 * t167 * t307 * jnp.pi - 0.38001026809962717688576807794235457359806521883077e-2 * t165 * t140 * t702 * jnp.pi + 0.13287210228946179141882035000000000000000000000000e1 * t124 * t566 * t348 - 0.11389037339096724978756030000000000000000000000000e1 * t124 * t148 * t390 + 0.42708890021612718670335112500000000000000000000000e0 * t124 * t31 * t788) * t395 - 0.30025502664661900395912539491741595938612560500208e-1 * t164 * t18 * t435 * t401 + 0.22519126998496425296934404618806196953959420375156e-1 * t398 * t405 + 0.23720747615136194550778824449265695623422695046375e-1 * t409 * t801 * t127 * t414 - 0.67557380995489275890803213856418590861878261125470e-2 * t404 * t570 * t400 - 0.10166034692201226236048067621113869552895440734161e-1 * t412 * t151 * t414 - 0.31870518760050844250010691992191981048327206701594e-3 * t409 / t20 / t800 * t157 * t48 * t414 + (-0.45038253996992850593868809237612393907918840750312e-1 * t165 * t435 * t254 * jnp.pi + 0.33778690497744637945401606928209295430939130562734e-1 * t165 * t167 * t262 * jnp.pi - 0.10133607149323391383620482078462788629281739168820e-1 * t165 * t140 * t669 * jnp.pi + 0.31577839396596107974149602675275503135000000000000e1 * t12 * t801 * t348 - 0.21051892931064071982766401783517002090000000000000e1 * t425 * t390 + 0.52629732327660179956916004458792505225000000000000e0 * t428 * t788) * t432 + 0.19816831758676854261302276064549453319484289930138e0 * t165 / t115 / t800 * t348 * t437 - 0.10809180959278284142528514217026974537900521780075e0 * t165 * t435 * t390 * t437 + 0.20267214298646782767240964156925577258563478337641e-1 * t165 * t167 * t788 * t437
  v2rho2_0_ = 0.2e1 * t445 * t452 + 0.13692109613355555555555555555555555555555555555556e0 * t492 * t494 * t112 * t497 * t140 * t45 + r0 * t854 * t452 + 0.82152657680133333333333333333333333333333333333336e0 * t116 * t445 * t494 * t114 * t18 * t45 + 0.63272429661648472104200166666666666666666666666669e0 * t147 * t492 / t451 / t450 * t124 * t19 * t395
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 0.1e1 <= f.p.zeta_threshold
  t2 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = f.my_piecewise3(t1, t3, 1)
  t5 = t4 ** 2
  t6 = t5 * t4
  t7 = jnp.log(0.2e1)
  t8 = t7 - 0.1e1
  t10 = 0.2e1 * t6 * t8
  t11 = jnp.pi ** 2
  t12 = 0.1e1 / t11
  t13 = t10 * t12
  t14 = 3 ** (0.1e1 / 0.3e1)
  t15 = 0.1e1 / jnp.pi
  t16 = t15 ** (0.1e1 / 0.3e1)
  t17 = t14 * t16
  t18 = 4 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t20 = r0 ** (0.1e1 / 0.3e1)
  t21 = 0.1e1 / t20
  t22 = t19 * t21
  t23 = t17 * t22
  t24 = jnp.sqrt(t23)
  t25 = t24 * t23
  t26 = 0.1e1 / t25
  t28 = 0.1e1 / t4
  t29 = f.p.cam_omega * t26 * t28
  t30 = t14 ** 2
  t31 = t16 ** 2
  t32 = t30 * t31
  t33 = r0 ** 2
  t34 = t20 ** 2
  t36 = 0.1e1 / t34 / t33
  t37 = t18 * t36
  t38 = t32 * t37
  t40 = 0.32478055555555555555555555555555555555555555555555e0 * t29 * t38
  t41 = 0.1e1 / t24
  t43 = f.p.cam_omega * t41 * t28
  t45 = 0.1e1 / t20 / t33
  t46 = t19 * t45
  t47 = t17 * t46
  t49 = 0.64956111111111111111111111111111111111111111111111e0 * t43 * t47
  t51 = 9 ** (0.1e1 / 0.3e1)
  t52 = t51 ** 2
  t60 = f.p.cam_omega ** 2
  t62 = (0.344851e1 - jnp.pi * t18 * t52 * t16 / t8 / 0.12e2) * t60 * t14
  t63 = t16 * t19
  t64 = 0.1e1 / t5
  t69 = t60 * f.p.cam_omega
  t71 = 0.1e1 / t6
  t72 = t69 * t41 * t71
  t76 = t69 * t24 * t71
  t79 = -t40 + t49 + t62 * t63 * t45 * t64 / 0.9e1 + 0.16322666666666666666666666666666666666666666666667e0 * t72 * t38 + 0.32645333333333333333333333333333333333333333333333e0 * t76 * t47
  t82 = 0.29230250000000000000000000000000000000000000000000e1 * f.p.cam_omega * t24 * t28
  t84 = t60 * t14 * t16
  t88 = 0.1e1 + t82 + 0.86212750000000000000000000000000000000000000000000e0 * t84 * t22 * t64
  t89 = 0.1e1 / t88
  t92 = 0.1e1 / t20 / r0
  t93 = t19 * t92
  t94 = t17 * t93
  t96 = 0.48717083333333333333333333333333333333333333333333e0 * t43 * t94
  t103 = -t96 - t62 * t63 * t92 * t64 / 0.12e2 - 0.24484000000000000000000000000000000000000000000000e0 * t76 * t94
  t104 = t88 ** 2
  t105 = 0.1e1 / t104
  t106 = t103 * t105
  t110 = -t96 - 0.28737583333333333333333333333333333333333333333333e0 * t84 * t93 * t64
  t120 = 0.1e1 + t82 + t62 * t63 * t21 * t64 / 0.4e1 + 0.48968000000000000000000000000000000000000000000000e0 * t69 * t25 * t71
  t122 = 0.1e1 / t104 / t88
  t123 = t120 * t122
  t124 = t110 ** 2
  t127 = t120 * t105
  t131 = -t40 + t49 + 0.38316777777777777777777777777777777777777777777777e0 * t84 * t46 * t64
  t133 = -0.2e1 * t106 * t110 + 0.2e1 * t123 * t124 - t127 * t131 + t79 * t89
  t134 = 0.1e1 / t120
  t135 = t133 * t134
  t140 = t103 * t89 - t127 * t110
  t141 = t120 ** 2
  t142 = 0.1e1 / t141
  t143 = t140 * t142
  t144 = t88 * t103
  t147 = t140 * t134
  t150 = jnp.sqrt(jnp.pi)
  t152 = 0.1e1 / t150 / jnp.pi
  t153 = t33 * r0
  t154 = 0.1e1 / t153
  t155 = t152 * t154
  t164 = (0.2e1 / 0.45e2 * t18 * t52 * t16 * (t11 + 0.6e1 * t7 - 0.3e1) * t15 - 0.7524e0) * t14
  t168 = 0.1e1 / t34
  t169 = t18 * t168
  t170 = t32 * t169
  t172 = 0.1e1 / r0
  t173 = t15 * t172
  t175 = t16 * t15
  t176 = t14 * t175
  t179 = 0.1e1 - t164 * t63 * t21 / 0.4e1 + 0.20482500000000000000000000000000000000000000000000e-1 * t170 - 0.95775000000000000000000000000000000000000000000000e-2 * t173 + 0.34856250000000000000000000000000000000000000000000e-3 * t176 * t93
  t181 = jnp.exp(-0.18810000000000000000000000000000000000000000000000e0 * t23)
  t182 = t179 * t181
  t183 = jnp.sqrt(0.2e1)
  t184 = t182 * t183
  t187 = 0.1e1 / t33
  t188 = t152 * t187
  t189 = t63 * t92
  t193 = 0.1e1 / t34 / r0
  t194 = t18 * t193
  t195 = t32 * t194
  t197 = t15 * t187
  t201 = t164 * t189 / 0.12e2 - 0.13655000000000000000000000000000000000000000000000e-1 * t195 + 0.95775000000000000000000000000000000000000000000000e-2 * t197 - 0.46475000000000000000000000000000000000000000000000e-3 * t176 * t46
  t202 = t201 * t181
  t203 = t202 * t183
  t207 = 0.1e1 / t20 / t153
  t208 = t152 * t207
  t209 = t179 * t14
  t211 = t181 * t183
  t212 = t63 * t211
  t215 = t152 * t172
  t216 = t63 * t45
  t220 = t15 * t154
  t222 = t19 * t207
  t225 = -t164 * t216 / 0.9e1 + 0.22758333333333333333333333333333333333333333333333e-1 * t38 - 0.19155000000000000000000000000000000000000000000000e-1 * t220 + 0.10844166666666666666666666666666666666666666666667e-2 * t176 * t222
  t226 = t225 * t181
  t227 = t226 * t183
  t230 = t152 * t45
  t231 = t201 * t14
  t236 = 0.1e1 / t34 / t153
  t237 = t152 * t236
  t238 = t179 * t30
  t240 = t31 * t18
  t241 = t240 * t211
  t245 = t30 * t31 * t12
  t246 = t245 * t18
  t247 = f.p.zeta_threshold ** 2
  t248 = f.my_piecewise3(t1, t247, 1)
  t249 = t248 * t52
  t250 = 0.1e1 / t175
  t251 = t249 * t250
  t253 = 2 ** (0.1e1 / 0.3e1)
  t255 = t17 * t22 * t253
  t257 = 0.1e1 - 0.56675000000000000000000000000000000000000000000000e-2 * t255
  t259 = t253 ** 2
  t263 = 0.1e1 + 0.10797500000000000000000000000000000000000000000000e0 * t255 + 0.10000000000000000000000000000000000000000000000000e-1 * t32 * t169 * t259
  t264 = 0.1e1 / t263
  t265 = t257 * t264
  t268 = t251 * t14 * t34 * t265 / 0.15e2
  t271 = -0.12375000000000000000000000000000000000000000000000e1 * t23 + t170 / 0.4e1
  t273 = jnp.exp(-0.77500000000000000000000000000000000000000000000000e-1 * t23)
  t274 = t271 * t273
  t275 = jnp.pi * r0
  t278 = t268 + 0.4e1 / 0.3e1 * t274 * t275
  t280 = t183 * t150
  t287 = 0.2e1 / 0.45e2 * t251 * t14 * t21 * t265
  t289 = t249 * jnp.pi * t30
  t290 = t168 * t19
  t291 = t253 * t264
  t294 = 0.12594444444444444444444444444444444444444444444445e-3 * t289 * t290 * t291
  t295 = t250 * t14
  t296 = t249 * t295
  t297 = t34 * t257
  t298 = t263 ** 2
  t299 = 0.1e1 / t298
  t306 = -0.35991666666666666666666666666666666666666666666667e-1 * t17 * t93 * t253 - 0.66666666666666666666666666666666666666666666666667e-2 * t32 * t194 * t259
  t307 = t299 * t306
  t310 = t296 * t297 * t307 / 0.15e2
  t313 = 0.41250000000000000000000000000000000000000000000000e0 * t94 - t195 / 0.6e1
  t314 = t313 * t273
  t318 = t271 * t14 * t16
  t319 = t273 * jnp.pi
  t320 = t22 * t319
  t325 = t287 + t294 - t310 + 0.4e1 / 0.3e1 * t314 * t275 + 0.34444444444444444444444444444444444444444444444444e-1 * t318 * t320 + 0.4e1 / 0.3e1 * t274 * jnp.pi
  t333 = 0.2e1 / 0.135e3 * t251 * t14 * t92 * t265
  t337 = 0.3e-53 * t289 * t193 * t19 * t291
  t338 = t21 * t257
  t341 = 0.4e1 / 0.45e2 * t296 * t338 * t307
  t342 = t253 * t299
  t346 = 0.25188888888888888888888888888888888888888888888890e-3 * t289 * t290 * t342 * t306
  t348 = 0.1e1 / t298 / t263
  t349 = t306 ** 2
  t350 = t348 * t349
  t353 = 0.2e1 / 0.15e2 * t296 * t297 * t350
  t360 = 0.47988888888888888888888888888888888888888888888889e-1 * t17 * t46 * t253 + 0.11111111111111111111111111111111111111111111111111e-1 * t32 * t37 * t259
  t361 = t299 * t360
  t364 = t296 * t297 * t361 / 0.15e2
  t367 = -0.55000000000000000000000000000000000000000000000000e0 * t47 + 0.5e1 / 0.18e2 * t38
  t368 = t367 * t273
  t372 = t313 * t14 * t16
  t377 = t93 * t319
  t381 = t271 * t30 * t31
  t382 = t194 * t319
  t385 = -t333 - t337 - t341 - t346 + t353 - t364 + 0.4e1 / 0.3e1 * t368 * t275 + 0.68888888888888888888888888888888888888888888888888e-1 * t372 * t320 + 0.8e1 / 0.3e1 * t314 * jnp.pi + 0.22962962962962962962962962962962962962962962962963e-1 * t318 * t377 + 0.35592592592592592592592592592592592592592592592591e-2 * t381 * t382
  t393 = t182 / 0.2e1 - 0.1e1 / 0.2e1
  t397 = t209 * t16
  t398 = t93 * t181
  t401 = t202 / 0.2e1 + 0.31350000000000000000000000000000000000000000000000e-1 * t397 * t398
  t405 = t231 * t16
  t408 = t46 * t181
  t411 = t238 * t31
  t412 = t37 * t181
  t415 = t226 / 0.2e1 + 0.62700000000000000000000000000000000000000000000000e-1 * t405 * t398 - 0.41800000000000000000000000000000000000000000000000e-1 * t397 * t408 + 0.78625800000000000000000000000000000000000000000000e-2 * t411 * t412
  t420 = -0.97000000000000000000000000000000000000000000000000e-1 * t23 + 0.16900000000000000000000000000000000000000000000000e0 * t170
  t422 = jnp.exp(-0.13675000000000000000000000000000000000000000000000e0 * t23)
  t424 = t420 * t422 * t14
  t426 = 0.1e1 / t31 * t19
  t427 = t426 * t34
  t431 = f.my_piecewise3(t1, t3 * t247, 1)
  t432 = t431 * t52
  t436 = t268 + t424 * t427 / 0.3e1 - t432 * t295 * t34 / 0.15e2
  t443 = 0.32333333333333333333333333333333333333333333333333e-1 * t94 - 0.11266666666666666666666666666666666666666666666667e0 * t195
  t445 = t443 * t422 * t14
  t449 = 0.1e1 / t16
  t450 = t420 * t30 * t449
  t451 = t169 * t422
  t454 = t426 * t21
  t460 = t287 + t294 - t310 + t445 * t427 / 0.3e1 + 0.60777777777777777777777777777777777777777777777777e-1 * t450 * t451 + 0.2e1 / 0.9e1 * t424 * t454 - 0.2e1 / 0.45e2 * t432 * t295 * t21
  t467 = -0.43111111111111111111111111111111111111111111111111e-1 * t47 + 0.18777777777777777777777777777777777777777777777778e0 * t38
  t469 = t467 * t422 * t14
  t473 = t443 * t30 * t449
  t481 = t426 * t92
  t487 = -t333 - t337 - t341 - t346 + t353 - t364 + t469 * t427 / 0.3e1 + 0.12155555555555555555555555555555555555555555555555e0 * t473 * t451 + 0.4e1 / 0.9e1 * t445 * t454 + 0.33245444444444444444444444444444444444444444444444e-1 * t420 * t187 * t422 - 0.2e1 / 0.27e2 * t424 * t481 + 0.2e1 / 0.135e3 * t432 * t295 * t92
  t493 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t23
  t496 = t23 ** 0.15e1
  t499 = 0.37978500000000000000000000000000000000000000000000e1 * t24 + 0.89690000000000000000000000000000000000000000000000e0 * t23 + 0.20477500000000000000000000000000000000000000000000e0 * t496 + 0.12323500000000000000000000000000000000000000000000e0 * t170
  t502 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t499
  t503 = jnp.log(t502)
  t507 = f.my_piecewise3(t1, t2 * f.p.zeta_threshold, 1)
  t513 = (0.2e1 * t507 - 0.2e1) / (0.2e1 * t253 - 0.2e1)
  t515 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t23
  t520 = 0.51785000000000000000000000000000000000000000000000e1 * t24 + 0.90577500000000000000000000000000000000000000000000e0 * t23 + 0.11003250000000000000000000000000000000000000000000e0 * t496 + 0.12417750000000000000000000000000000000000000000000e0 * t170
  t523 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t520
  t524 = jnp.log(t523)
  t528 = -0.621814e-1 * t493 * t503 + 0.19751673498613801407483339618206552048944131217655e-1 * t513 * t515 * t524
  t535 = t499 ** 2
  t536 = 0.1e1 / t535
  t537 = t493 * t536
  t538 = t41 * t14
  t539 = t538 * t189
  t542 = t23 ** 0.5e0
  t543 = t542 * t14
  t544 = t543 * t189
  t547 = -0.63297500000000000000000000000000000000000000000000e0 * t539 - 0.29896666666666666666666666666666666666666666666667e0 * t94 - 0.10238750000000000000000000000000000000000000000000e0 * t544 - 0.82156666666666666666666666666666666666666666666667e-1 * t195
  t548 = 0.1e1 / t502
  t549 = t547 * t548
  t552 = t513 * t14
  t557 = t513 * t515
  t558 = t520 ** 2
  t559 = 0.1e1 / t558
  t564 = -0.86308333333333333333333333333333333333333333333334e0 * t539 - 0.30192500000000000000000000000000000000000000000000e0 * t94 - 0.55016250000000000000000000000000000000000000000000e-1 * t544 - 0.82785000000000000000000000000000000000000000000000e-1 * t195
  t566 = 0.1e1 / t523
  t567 = t559 * t564 * t566
  t570 = 0.11073470983333333333333333333333333333333333333333e-2 * t17 * t93 * t503 + 0.10000000000000000000000000000000000000000000000000e1 * t537 * t549 - 0.18311447306006545054854346104378990962041954983034e-3 * t552 * t63 * t92 * t524 - 0.58482236226346462072622386637590534819724553404280e0 * t557 * t567
  t577 = t17 * t19
  t578 = t92 * t536
  t583 = 0.1e1 / t535 / t499
  t584 = t493 * t583
  t585 = t547 ** 2
  t586 = t585 * t548
  t589 = t26 * t30
  t590 = t240 * t36
  t591 = t589 * t590
  t593 = t538 * t216
  t596 = t23 ** (-0.5e0)
  t597 = t596 * t30
  t598 = t597 * t590
  t600 = t543 * t216
  t603 = -0.42198333333333333333333333333333333333333333333333e0 * t591 + 0.84396666666666666666666666666666666666666666666666e0 * t593 + 0.39862222222222222222222222222222222222222222222223e0 * t47 + 0.68258333333333333333333333333333333333333333333333e-1 * t598 + 0.13651666666666666666666666666666666666666666666667e0 * t600 + 0.13692777777777777777777777777777777777777777777778e0 * t38
  t604 = t603 * t548
  t607 = t535 ** 2
  t608 = 0.1e1 / t607
  t609 = t493 * t608
  t610 = t502 ** 2
  t611 = 0.1e1 / t610
  t612 = t585 * t611
  t619 = t513 * t17
  t624 = 0.1e1 / t558 / t520
  t625 = t564 ** 2
  t627 = t624 * t625 * t566
  t636 = -0.57538888888888888888888888888888888888888888888889e0 * t591 + 0.11507777777777777777777777777777777777777777777778e1 * t593 + 0.40256666666666666666666666666666666666666666666667e0 * t47 + 0.36677500000000000000000000000000000000000000000000e-1 * t598 + 0.73355000000000000000000000000000000000000000000000e-1 * t600 + 0.13797500000000000000000000000000000000000000000000e0 * t38
  t638 = t559 * t636 * t566
  t641 = t558 ** 2
  t642 = 0.1e1 / t641
  t644 = t523 ** 2
  t645 = 0.1e1 / t644
  t646 = t642 * t625 * t645
  t649 = -0.14764627977777777777777777777777777777777777777777e-2 * t17 * t46 * t503 - 0.35616666666666666666666666666666666666666666666666e-1 * t577 * t578 * t549 - 0.20000000000000000000000000000000000000000000000000e1 * t584 * t586 + 0.10000000000000000000000000000000000000000000000000e1 * t537 * t604 + 0.16081979498692535066756296899072713062105388428051e2 * t609 * t612 + 0.24415263074675393406472461472505321282722606644045e-3 * t552 * t63 * t45 * t524 + 0.10843581300301739842632067522386578331157260943710e-1 * t619 * t93 * t567 + 0.11696447245269292414524477327518106963944910680856e1 * t557 * t627 - 0.58482236226346462072622386637590534819724553404280e0 * t557 * t638 - 0.17315859105681463759666483083807725165579399831905e2 * t557 * t646
  t654 = t60 ** 2
  t656 = t18 * t236
  t657 = t245 * t656
  t658 = t654 * f.p.cam_omega
  t659 = t280 * t658
  t660 = t182 * t659
  t663 = t245 * t37
  t664 = t202 * t659
  t668 = 0.1e1 / t150 / t11
  t669 = t33 ** 2
  t670 = 0.1e1 / t669
  t671 = t668 * t670
  t673 = t211 * t658
  t676 = t245 * t194
  t677 = t226 * t659
  t680 = t668 * t154
  t685 = 0.1e1 / t20 / t669
  t686 = t668 * t685
  t688 = t63 * t673
  t703 = t12 * t670
  t706 = t12 * t154
  t709 = t12 * t187
  t713 = t654 * t60
  t716 = 0.1e1 / t34 / t669
  t718 = t654 ** 2
  t730 = t13 * t135 * t88 - t13 * t143 * t144 + t13 * t147 * t110 + (-0.35086488218440119971277336305861670150000000000000e0 * t155 * t184 + 0.35086488218440119971277336305861670150000000000000e0 * t188 * t203 + 0.36665380188269925369984816439625445306750000000000e-1 * t208 * t209 * t212 - 0.17543244109220059985638668152930835075000000000000e0 * t215 * t227 - 0.21999228112961955221990889863775267184050000000000e-1 * t230 * t231 * t212 - 0.27587032053654291848376575889174185048798700000000e-2 * t237 * t238 * t241 - 0.13511476199097855178160642771283718172375652225094e-1 * t246 * t236 * t278 * t280 + 0.10133607149323391383620482078462788629281739168821e-1 * t246 * t36 * t325 * t280 - 0.30400821447970174150861446235388365887845217506462e-2 * t246 * t193 * t385 * t280) * t69 + (-0.52629732327660179956916004458792505225000000000000e0 * t220 * t393 + 0.52629732327660179956916004458792505225000000000000e0 * t197 * t401 - 0.26314866163830089978458002229396252612500000000000e0 * t173 * t415 - 0.16889345248872318972700803464104647715469565281367e-1 * t246 * t236 * t436 * jnp.pi + 0.12667008936654239229525602598078485786602173961026e-1 * t246 * t36 * t460 * jnp.pi - 0.38001026809962717688576807794235457359806521883077e-2 * t246 * t193 * t487 * jnp.pi + 0.13287210228946179141882035000000000000000000000000e1 * t176 * t222 * t528 - 0.11389037339096724978756030000000000000000000000000e1 * t176 * t46 * t570 + 0.42708890021612718670335112500000000000000000000000e0 * t176 * t93 * t649) * t654 - 0.30025502664661900395912539491741595938612560500208e-1 * t657 * t660 + 0.22519126998496425296934404618806196953959420375156e-1 * t663 * t664 + 0.23720747615136194550778824449265695623422695046375e-1 * t671 * t179 * t673 - 0.67557380995489275890803213856418590861878261125470e-2 * t676 * t677 - 0.10166034692201226236048067621113869552895440734161e-1 * t680 * t201 * t673 - 0.31870518760050844250010691992191981048327206701594e-3 * t686 * t209 * t688 + (-0.45038253996992850593868809237612393907918840750312e-1 * t246 * t236 * t393 * jnp.pi + 0.33778690497744637945401606928209295430939130562734e-1 * t246 * t36 * t401 * jnp.pi - 0.10133607149323391383620482078462788629281739168820e-1 * t246 * t193 * t415 * jnp.pi + 0.31577839396596107974149602675275503135000000000000e1 * t703 * t528 - 0.21051892931064071982766401783517002090000000000000e1 * t706 * t570 + 0.52629732327660179956916004458792505225000000000000e0 * t709 * t649) * t713 + 0.19816831758676854261302276064549453319484289930138e0 * t246 * t716 * t528 * t718 - 0.10809180959278284142528514217026974537900521780075e0 * t246 * t236 * t570 * t718 + 0.20267214298646782767240964156925577258563478337641e-1 * t246 * t36 * t649 * t718
  t734 = 0.1e1 + 0.15403623315025000000000000000000000000000000000000e0 * t32 * t169 * t60
  t735 = t734 ** 2
  t736 = t735 ** 2
  t737 = 0.1e1 / t736
  t808 = t13 * t147 * t88 + (0.17543244109220059985638668152930835075000000000000e0 * t188 * t184 - 0.17543244109220059985638668152930835075000000000000e0 * t215 * t203 - 0.10999614056480977610995444931887633592025000000000e-1 * t230 * t209 * t212 + 0.50668035746616956918102410392313943146408695844103e-2 * t246 * t36 * t278 * t280 - 0.30400821447970174150861446235388365887845217506462e-2 * t246 * t193 * t325 * t280) * t69 + (0.26314866163830089978458002229396252612500000000000e0 * t197 * t393 - 0.26314866163830089978458002229396252612500000000000e0 * t173 * t401 + 0.63335044683271196147628012990392428933010869805128e-2 * t246 * t36 * t436 * jnp.pi - 0.38001026809962717688576807794235457359806521883077e-2 * t246 * t193 * t460 * jnp.pi - 0.56945186695483624893780150000000000000000000000000e0 * t176 * t46 * t528 + 0.42708890021612718670335112500000000000000000000000e0 * t176 * t93 * t570) * t654 + 0.11259563499248212648467202309403098476979710187578e-1 * t663 * t660 - 0.67557380995489275890803213856418590861878261125470e-2 * t676 * t664 - 0.50830173461006131180240338105569347764477203670804e-2 * t680 * t179 * t673 + (0.16889345248872318972700803464104647715469565281367e-1 * t246 * t36 * t393 * jnp.pi - 0.10133607149323391383620482078462788629281739168820e-1 * t246 * t193 * t401 * jnp.pi - 0.10525946465532035991383200891758501045000000000000e1 * t706 * t528 + 0.52629732327660179956916004458792505225000000000000e0 * t709 * t570) * t713 - 0.54045904796391420712642571085134872689502608900376e-1 * t246 * t236 * t528 * t718 + 0.20267214298646782767240964156925577258563478337641e-1 * t246 * t36 * t570 * t718
  t810 = 0.1e1 / t736 / t734
  t818 = jnp.log(t120 * t89)
  t854 = t10 * t12 * t818 + (-0.17543244109220059985638668152930835075000000000000e0 * t215 * t184 - 0.30400821447970174150861446235388365887845217506462e-2 * t246 * t193 * t278 * t280) * t69 + (-0.26314866163830089978458002229396252612500000000000e0 * t173 * t393 - 0.38001026809962717688576807794235457359806521883077e-2 * t246 * t193 * t436 * jnp.pi + 0.42708890021612718670335112500000000000000000000000e0 * t176 * t93 * t528) * t654 - 0.67557380995489275890803213856418590861878261125470e-2 * t676 * t660 + (-0.10133607149323391383620482078462788629281739168820e-1 * t246 * t193 * t393 * jnp.pi + 0.52629732327660179956916004458792505225000000000000e0 * t709 * t528) * t713 + 0.20267214298646782767240964156925577258563478337641e-1 * t246 * t36 * t528 * t718
  t856 = 0.1e1 / t736 / t735
  t880 = t625 * t564
  t895 = 0.1e1 / t24 / t170 / 0.4e1
  t897 = t895 * t15 * t670
  t899 = t240 * t236
  t900 = t589 * t899
  t902 = t63 * t207
  t903 = t538 * t902
  t905 = t17 * t222
  t907 = t23 ** (-0.15e1)
  t909 = t907 * t15 * t670
  t911 = t597 * t899
  t913 = t543 * t902
  t915 = t32 * t656
  t925 = t585 * t547
  t959 = 0.34450798614814814814814814814814814814814814814813e-2 * t17 * t222 * t503 - 0.51947577317044391278999449251423175496738199495715e2 * t557 * t642 * t636 * t645 * t564 - 0.10254018858216406658218194626490193680059335835414e4 * t557 / t641 / t558 * t880 / t644 / t523 + 0.10389515463408878255799889850284635099347639899143e3 * t557 / t641 / t520 * t880 * t645 - 0.58482236226346462072622386637590534819724553404280e0 * t557 * t559 * (-0.34523333333333333333333333333333333333333333333333e1 * t897 + 0.23015555555555555555555555555555555555555555555556e1 * t900 - 0.26851481481481481481481481481481481481481481481482e1 * t903 - 0.93932222222222222222222222222222222222222222222223e0 * t905 + 0.73355000000000000000000000000000000000000000000000e-1 * t909 - 0.14671000000000000000000000000000000000000000000000e0 * t911 - 0.17116166666666666666666666666666666666666666666667e0 * t913 - 0.36793333333333333333333333333333333333333333333333e0 * t915) * t566 + 0.51726012919273400298984252201052768390886626637712e3 * t493 / t607 / t535 * t925 / t610 / t502 - 0.96491876992155210400537781394436278372632330568306e2 * t493 / t607 / t499 * t925 * t611 + 0.10000000000000000000000000000000000000000000000000e1 * t537 * (-0.25319000000000000000000000000000000000000000000000e1 * t897 + 0.16879333333333333333333333333333333333333333333333e1 * t900 - 0.19692555555555555555555555555555555555555555555555e1 * t903 - 0.93011851851851851851851851851851851851851851851854e0 * t905 + 0.13651666666666666666666666666666666666666666666667e0 * t909 - 0.27303333333333333333333333333333333333333333333333e0 * t911 - 0.31853888888888888888888888888888888888888888888890e0 * t913 - 0.36514074074074074074074074074074074074074074074075e0 * t915) * t548 + 0.48245938496077605200268890697218139186316165284153e2 * t609 * t603 * t611 * t547 + 0.60000000000000000000000000000000000000000000000000e1 * t609 * t925 * t548 - 0.60000000000000000000000000000000000000000000000000e1 * t584 * t549 * t603
  t1000 = -0.35089341735807877243573431982554320891834732042568e1 * t557 * t642 * t880 * t566 + 0.35089341735807877243573431982554320891834732042568e1 * t557 * t624 * t564 * t566 * t636 - 0.85917975471764868594145516183295969534298037676861e0 * t577 * t92 * t608 * t612 + 0.71233333333333333333333333333333333333333333333331e-1 * t577 * t45 * t536 * t549 - 0.53424999999999999999999999999999999999999999999999e-1 * t577 * t578 * t604 - 0.32530743900905219527896202567159734993471782831130e-1 * t619 * t93 * t627 - 0.21687162600603479685264135044773156662314521887420e-1 * t619 * t46 * t567 + 0.16265371950452609763948101283579867496735891415565e-1 * t619 * t93 * t638 + 0.48159733137676571081572406076840235616767705782485e0 * t619 * t93 * t646 + 0.10685000000000000000000000000000000000000000000000e0 * t577 * t92 * t583 * t586 - 0.56968947174242584615102410102512416326352748836105e-3 * t552 * t63 * t207 * t524
  t1001 = t959 + t1000
  t1014 = t669 * r0
  t1016 = 0.1e1 / t34 / t1014
  t1021 = 0.1e1 / t1014
  t1022 = t668 * t1021
  t1047 = t15 * t670
  t1049 = t19 * t685
  t1053 = (0.7e1 / 0.27e2 * t164 * t902 - 0.60688888888888888888888888888888888888888888888888e-1 * t915 + 0.57465000000000000000000000000000000000000000000000e-1 * t1047 - 0.36147222222222222222222222222222222222222222222223e-2 * t176 * t1049) * t181
  t1055 = t225 * t14
  t1061 = t201 * t30
  t1075 = t1053 / 0.2e1 + 0.94050000000000000000000000000000000000000000000000e-1 * t1055 * t16 * t398 - 0.12540000000000000000000000000000000000000000000000e0 * t405 * t408 + 0.23587740000000000000000000000000000000000000000000e-1 * t1061 * t31 * t412 + 0.97533333333333333333333333333333333333333333333333e-1 * t397 * t222 * t181 - 0.31450320000000000000000000000000000000000000000000e-1 * t411 * t656 * t181 + 0.59158051920000000000000000000000000000000000000000e-2 * t179 * t15 * t670 * t181
  t1144 = 0.75566666666666666666666666666666666666666666666669e-3 * t289 * t290 * t253 * t348 * t349
  t1147 = 0.4e1 / 0.15e2 * t296 * t338 * t350
  t1151 = 0.37783333333333333333333333333333333333333333333335e-3 * t289 * t290 * t342 * t360
  t1152 = t298 ** 2
  t1158 = 0.2e1 / 0.5e1 * t296 * t297 / t1152 * t349 * t306
  t1163 = 0.2e1 / 0.5e1 * t296 * t297 * t348 * t306 * t360
  t1181 = 0.8e1 / 0.405e3 * t251 * t14 * t45 * t265
  t1185 = 0.2e1 / 0.45e2 * t296 * t92 * t257 * t307
  t1189 = 0.27987654320987654320987654320987654320987654320983e-4 * t289 * t36 * t19 * t291
  t1192 = 0.2e1 / 0.15e2 * t296 * t338 * t361
  t1203 = t296 * t297 * t299 * (-0.11197407407407407407407407407407407407407407407407e0 * t17 * t222 * t253 - 0.29629629629629629629629629629629629629629629629629e-1 * t32 * t656 * t259) / 0.15e2
  t1209 = 0.4e1 / 0.3e1 * (0.12833333333333333333333333333333333333333333333333e1 * t905 - 0.20e2 / 0.27e2 * t915) * t273 * t275 + 0.4e1 * t368 * jnp.pi + t1144 + t1147 - t1151 - t1158 + t1163 + 0.11033703703703703703703703703703703703703703703703e-2 * t271 * t154 * t273 + 0.10333333333333333333333333333333333333333333333333e0 * t367 * t14 * t16 * t320 + 0.10677777777777777777777777777777777777777777777777e-1 * t313 * t30 * t31 * t382 - 0.35592592592592592592592592592592592592592592592590e-2 * t381 * t37 * t319 + t1181 + t1185 - t1189 - t1192 - t1203 + 0.68888888888888888888888888888888888888888888888888e-1 * t372 * t377 - 0.30617283950617283950617283950617283950617283950617e-1 * t318 * t46 * t319
  t1214 = 0.10525946465532035991383200891758501045000000000000e1 * t152 * t670 * t184 - 0.10525946465532035991383200891758501045000000000000e1 * t155 * t203 - 0.14421716207386170645527361132919341820655000000000e0 * t152 * t685 * t209 * t212 + 0.52629732327660179956916004458792505225000000000000e0 * t188 * t227 + 0.10999614056480977610995444931887633592025000000000e0 * t208 * t231 * t212 + 0.19310922437558004293863603122421929534159090000000e-1 * t152 * t716 * t238 * t241 - 0.17543244109220059985638668152930835075000000000000e0 * t215 * t1053 * t183 - 0.32998842169442932832986334795662900776075000000000e-1 * t230 * t1055 * t212 - 0.82761096160962875545129727667522555146396100000000e-2 * t237 * t1061 * t241 - 0.20756482917169489186718535699014656830716141880000e-2 * t1022 * t184 + 0.49542079396692135653255690161373633298710724825345e-1 * t246 * t716 * t278 * t280 - 0.40534428597293565534481928313851154517126956675283e-1 * t246 * t236 * t325 * t280 + 0.15200410723985087075430723117694182943922608753231e-1 * t246 * t36 * t385 * t280 - 0.30400821447970174150861446235388365887845217506462e-2 * t246 * t193 * t1209 * t280
  t1275 = t1163 + 0.99736333333333333333333333333333333333333333333330e-1 * t443 * t187 * t422 + 0.2e1 / 0.3e1 * t469 * t454 + 0.2e-50 * t473 * t194 * t422 - 0.2e1 / 0.9e1 * t445 * t481 + 0.8e1 / 0.81e2 * t424 * t426 * t45 + t1181 + t1185 - t1189 - t1192 - t1203
  t1293 = 0.15788919698298053987074801337637751567500000000000e1 * t1047 * t393 - 0.15788919698298053987074801337637751567500000000000e1 * t220 * t401 + 0.78944598491490269935374006688188757837500000000000e0 * t197 * t415 - 0.26314866163830089978458002229396252612500000000000e0 * t173 * t1075 + 0.61927599245865169566569612701717041623388406031679e-1 * t246 * t716 * t436 * jnp.pi - 0.50668035746616956918102410392313943146408695844103e-1 * t246 * t236 * t460 * jnp.pi + 0.19000513404981358844288403897117728679903260941539e-1 * t246 * t36 * t487 * jnp.pi - 0.38001026809962717688576807794235457359806521883077e-2 * t246 * t193 * (-0.66490888888888888888888888888888888888888888888888e-1 * t420 * t154 * t422 - 0.8e1 / 0.405e3 * t432 * t295 * t45 + 0.18233333333333333333333333333333333333333333333333e0 * t467 * t30 * t449 * t451 + 0.15154381759259259259259259259259259259259259259259e-2 * t420 * t207 * t14 * t63 * t422 - 0.13506172839506172839506172839506172839506172839506e-1 * t450 * t37 * t422 + (0.10059259259259259259259259259259259259259259259259e0 * t905 - 0.50074074074074074074074074074074074074074074074075e0 * t915) * t422 * t14 * t427 / 0.3e1 + t1144 + t1147 - t1151 - t1158 + t1275) * jnp.pi - 0.44290700763153930472940116666666666666666666666667e1 * t176 * t1049 * t528 + 0.39861630686838537425646105000000000000000000000000e1 * t176 * t222 * t570 - 0.17083556008645087468134045000000000000000000000000e1 * t176 * t46 * t649 + 0.42708890021612718670335112500000000000000000000000e0 * t176 * t93 * t1001
  t1302 = 0.20267214298646782767240964156925577258563478337641e-1 * t246 * t36 * t1001 * t718 + 0.59450495276030562783906828193648359958452869790413e0 * t246 * t716 * t570 * t718 - 0.16213771438917426213792771325540461806850782670113e0 * t246 * t236 * t649 * t718 - 0.92478548207158653219410621634564115490926686340644e0 * t246 * t1016 * t528 * t718 - 0.11747417866543639206099989251064915927790287070586e0 * t1022 * t179 * t673 + 0.71162242845408583652336473347797086870268085139125e-1 * t671 * t201 * t673 - 0.15249052038301839354072101431670804329343161101241e-1 * t680 * t225 * t673 + (0.16514026465564045217751896720457877766236908275114e0 * t246 * t716 * t393 * jnp.pi - 0.13511476199097855178160642771283718172375652225094e0 * t246 * t236 * t401 * jnp.pi + 0.50668035746616956918102410392313943146408695844101e-1 * t246 * t36 * t415 * jnp.pi - 0.10133607149323391383620482078462788629281739168820e-1 * t246 * t193 * t1075 * jnp.pi - 0.12631135758638443189659841070110201254000000000000e2 * t12 * t1021 * t528 + 0.94733518189788323922448808025826509405000000000000e1 * t703 * t570 - 0.31577839396596107974149602675275503135000000000000e1 * t706 * t649 + 0.52629732327660179956916004458792505225000000000000e0 * t709 * t1001) * t713 + t1214 * t69 + t1293 * t654 - 0.2e1 * t13 * t143 * t110 * t103 - t13 * t143 * t88 * t79
  t1310 = t103 ** 2
  t1324 = 0.19486833333333333333333333333333333333333333333333e1 * f.p.cam_omega * t895 * t28 * t15 * t670
  t1326 = 0.12991222222222222222222222222222222222222222222222e1 * t29 * t915
  t1328 = 0.15156425925925925925925925925925925925925925925926e1 * t43 * t905
  t1352 = t104 ** 2
  t1395 = -0.2e1 * t13 * t133 * t142 * t144 + 0.2e1 * t13 * t140 / t141 / t120 * t88 * t1310 + t13 * t147 * t131 + 0.2e1 * t13 * t135 * t110 + t13 * ((-t1324 + t1326 - t1328 - 0.7e1 / 0.27e2 * t62 * t63 * t207 * t64 + 0.32645333333333333333333333333333333333333333333334e0 * t69 * t26 * t71 * t15 * t670 - 0.65290666666666666666666666666666666666666666666667e0 * t72 * t915 - 0.76172444444444444444444444444444444444444444444444e0 * t76 * t905) * t89 - 0.3e1 * t79 * t105 * t110 + 0.6e1 * t103 * t122 * t124 - 0.3e1 * t106 * t131 - 0.6e1 * t120 / t1352 * t124 * t110 + 0.6e1 * t123 * t110 * t131 - t127 * (-t1324 + t1326 - t1328 - 0.89405814814814814814814814814814814814814814814813e0 * t84 * t222 * t64)) * t134 * t88 + 0.11009350977042696811834597813638585177491272183410e0 * t245 * t18 * t716 * t660 + 0.33778690497744637945401606928209295430939130562734e-1 * t663 * t677 + 0.28683466884045759825009622792972782943494486031434e-2 * t668 / t20 / t1014 * t209 * t688 - 0.67557380995489275890803213856418590861878261125470e-2 * t676 * t1053 * t659 - 0.95611556280152532750032075976575943144981620104783e-3 * t686 * t231 * t688 - 0.79931261050207517379026815516417488469204634407598e-4 * t668 * t1016 * t238 * t240 * t673 - 0.90076507993985701187737618475224787815837681500624e-1 * t657 * t664
  v3rho3_0_ = 0.3e1 * t730 * t737 + 0.41076328840066666666666666666666666666666666666668e0 * t808 * t810 * t30 * t240 * t193 * t60 - 0.12654485932329694420840033333333333333333333333334e1 * t854 * t856 * t14 * t175 * t19 * t207 * t654 - 0.22820182688925925925925925925925925925925925925927e0 * t854 * t810 * t30 * t240 * t36 * t60 + r0 * (t1302 + t1395) * t737 + 0.12322898652020000000000000000000000000000000000000e1 * t168 * t730 * t810 * t32 * t18 * t60 + 0.18981728898494541631260050000000000000000000000001e1 * t45 * t808 * t856 * t176 * t19 * t654 + 0.46781984291253493295036448407815560200000000000002e1 * t670 * t854 / t736 / t735 / t734 * t12 * t713

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t3 = jnp.pi ** 2
  t4 = 0.1e1 / t3
  t5 = 0.1e1 / jnp.pi
  t6 = t5 ** (0.1e1 / 0.3e1)
  t7 = t6 ** 2
  t9 = t2 * t7 * t4
  t10 = 4 ** (0.1e1 / 0.3e1)
  t11 = t9 * t10
  t12 = r0 ** 2
  t13 = r0 ** (0.1e1 / 0.3e1)
  t14 = t13 ** 2
  t16 = 0.1e1 / t14 / t12
  t17 = t1 * t6
  t18 = t10 ** 2
  t19 = t12 * r0
  t21 = 0.1e1 / t13 / t19
  t22 = t18 * t21
  t23 = 0.1e1 / t13
  t24 = t18 * t23
  t25 = t17 * t24
  t26 = jnp.sqrt(t25)
  t29 = t25 ** 0.15e1
  t31 = t2 * t7
  t32 = 0.1e1 / t14
  t33 = t10 * t32
  t34 = t31 * t33
  t36 = 0.37978500000000000000000000000000000000000000000000e1 * t26 + 0.89690000000000000000000000000000000000000000000000e0 * t25 + 0.20477500000000000000000000000000000000000000000000e0 * t29 + 0.12323500000000000000000000000000000000000000000000e0 * t34
  t39 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t36
  t40 = jnp.log(t39)
  t44 = 0.1e1 <= f.p.zeta_threshold
  t45 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t47 = f.my_piecewise3(t44, t45 * f.p.zeta_threshold, 1)
  t50 = 2 ** (0.1e1 / 0.3e1)
  t54 = (0.2e1 * t47 - 0.2e1) / (0.2e1 * t50 - 0.2e1)
  t56 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t25
  t57 = t54 * t56
  t62 = 0.51785000000000000000000000000000000000000000000000e1 * t26 + 0.90577500000000000000000000000000000000000000000000e0 * t25 + 0.11003250000000000000000000000000000000000000000000e0 * t29 + 0.12417750000000000000000000000000000000000000000000e0 * t34
  t63 = t62 ** 2
  t64 = t63 ** 2
  t65 = 0.1e1 / t64
  t66 = t26 * t25
  t67 = 0.1e1 / t66
  t68 = t67 * t2
  t69 = t7 * t10
  t70 = t69 * t16
  t71 = t68 * t70
  t73 = 0.1e1 / t26
  t74 = t73 * t1
  t75 = t6 * t18
  t77 = 0.1e1 / t13 / t12
  t78 = t75 * t77
  t79 = t74 * t78
  t81 = t18 * t77
  t82 = t17 * t81
  t84 = t25 ** (-0.5e0)
  t85 = t84 * t2
  t86 = t85 * t70
  t88 = t25 ** 0.5e0
  t89 = t88 * t1
  t90 = t89 * t78
  t92 = t10 * t16
  t93 = t31 * t92
  t95 = -0.57538888888888888888888888888888888888888888888889e0 * t71 + 0.11507777777777777777777777777777777777777777777778e1 * t79 + 0.40256666666666666666666666666666666666666666666667e0 * t82 + 0.36677500000000000000000000000000000000000000000000e-1 * t86 + 0.73355000000000000000000000000000000000000000000000e-1 * t90 + 0.13797500000000000000000000000000000000000000000000e0 * t93
  t99 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t62
  t100 = t99 ** 2
  t101 = 0.1e1 / t100
  t103 = 0.1e1 / t13 / r0
  t104 = t75 * t103
  t105 = t74 * t104
  t107 = t18 * t103
  t108 = t17 * t107
  t110 = t89 * t104
  t113 = 0.1e1 / t14 / r0
  t114 = t10 * t113
  t115 = t31 * t114
  t117 = -0.86308333333333333333333333333333333333333333333334e0 * t105 - 0.30192500000000000000000000000000000000000000000000e0 * t108 - 0.55016250000000000000000000000000000000000000000000e-1 * t110 - 0.82785000000000000000000000000000000000000000000000e-1 * t115
  t118 = t101 * t117
  t123 = 0.1e1 / t64 / t63
  t124 = t117 ** 2
  t125 = t124 * t117
  t128 = 0.1e1 / t100 / t99
  t129 = t123 * t125 * t128
  t133 = 0.1e1 / t64 / t62
  t135 = t133 * t125 * t101
  t138 = 0.1e1 / t63
  t141 = 0.1e1 / t26 / t34 / 0.4e1
  t142 = t141 * t5
  t143 = t12 ** 2
  t144 = 0.1e1 / t143
  t145 = t142 * t144
  t148 = 0.1e1 / t14 / t19
  t149 = t69 * t148
  t150 = t68 * t149
  t152 = t75 * t21
  t153 = t74 * t152
  t155 = t17 * t22
  t157 = t25 ** (-0.15e1)
  t158 = t157 * t5
  t159 = t158 * t144
  t161 = t85 * t149
  t163 = t89 * t152
  t165 = t10 * t148
  t166 = t31 * t165
  t168 = -0.34523333333333333333333333333333333333333333333333e1 * t145 + 0.23015555555555555555555555555555555555555555555556e1 * t150 - 0.26851481481481481481481481481481481481481481481482e1 * t153 - 0.93932222222222222222222222222222222222222222222223e0 * t155 + 0.73355000000000000000000000000000000000000000000000e-1 * t159 - 0.14671000000000000000000000000000000000000000000000e0 * t161 - 0.17116166666666666666666666666666666666666666666667e0 * t163 - 0.36793333333333333333333333333333333333333333333333e0 * t166
  t170 = 0.1e1 / t99
  t171 = t138 * t168 * t170
  t175 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t25
  t176 = t36 ** 2
  t177 = t176 ** 2
  t179 = 0.1e1 / t177 / t176
  t180 = t175 * t179
  t185 = -0.63297500000000000000000000000000000000000000000000e0 * t105 - 0.29896666666666666666666666666666666666666666666667e0 * t108 - 0.10238750000000000000000000000000000000000000000000e0 * t110 - 0.82156666666666666666666666666666666666666666666667e-1 * t115
  t186 = t185 ** 2
  t187 = t186 * t185
  t188 = t39 ** 2
  t190 = 0.1e1 / t188 / t39
  t191 = t187 * t190
  t195 = 0.1e1 / t177 / t36
  t196 = t175 * t195
  t197 = 0.1e1 / t188
  t198 = t187 * t197
  t201 = 0.1e1 / t176
  t202 = t175 * t201
  t211 = -0.25319000000000000000000000000000000000000000000000e1 * t145 + 0.16879333333333333333333333333333333333333333333333e1 * t150 - 0.19692555555555555555555555555555555555555555555555e1 * t153 - 0.93011851851851851851851851851851851851851851851854e0 * t155 + 0.13651666666666666666666666666666666666666666666667e0 * t159 - 0.27303333333333333333333333333333333333333333333333e0 * t161 - 0.31853888888888888888888888888888888888888888888890e0 * t163 - 0.36514074074074074074074074074074074074074074074075e0 * t166
  t212 = 0.1e1 / t39
  t213 = t211 * t212
  t216 = 0.1e1 / t177
  t217 = t175 * t216
  t224 = -0.42198333333333333333333333333333333333333333333333e0 * t71 + 0.84396666666666666666666666666666666666666666666666e0 * t79 + 0.39862222222222222222222222222222222222222222222223e0 * t82 + 0.68258333333333333333333333333333333333333333333333e-1 * t86 + 0.13651666666666666666666666666666666666666666666667e0 * t90 + 0.13692777777777777777777777777777777777777777777778e0 * t93
  t229 = t187 * t212
  t232 = t176 * t36
  t233 = 0.1e1 / t232
  t234 = t175 * t233
  t235 = t185 * t212
  t239 = 0.34450798614814814814814814814814814814814814814813e-2 * t17 * t22 * t40 - 0.51947577317044391278999449251423175496738199495715e2 * t57 * t65 * t95 * t118 - 0.10254018858216406658218194626490193680059335835414e4 * t57 * t129 + 0.10389515463408878255799889850284635099347639899143e3 * t57 * t135 - 0.58482236226346462072622386637590534819724553404280e0 * t57 * t171 + 0.51726012919273400298984252201052768390886626637712e3 * t180 * t191 - 0.96491876992155210400537781394436278372632330568306e2 * t196 * t198 + 0.10000000000000000000000000000000000000000000000000e1 * t202 * t213 + 0.48245938496077605200268890697218139186316165284153e2 * t217 * t224 * t197 * t185 + 0.60000000000000000000000000000000000000000000000000e1 * t217 * t229 - 0.60000000000000000000000000000000000000000000000000e1 * t234 * t235 * t224
  t241 = t65 * t125 * t170
  t244 = t63 * t62
  t245 = 0.1e1 / t244
  t247 = t170 * t95
  t251 = t17 * t18
  t252 = t103 * t216
  t253 = t186 * t197
  t257 = t77 * t201
  t261 = t103 * t201
  t262 = t224 * t212
  t266 = t54 * t17
  t268 = t245 * t124 * t170
  t273 = t138 * t117 * t170
  t278 = t138 * t95 * t170
  t282 = t65 * t124
  t283 = t282 * t101
  t288 = t186 * t212
  t292 = t54 * t1
  t293 = jnp.log(t99)
  t298 = -0.35089341735807877243573431982554320891834732042568e1 * t57 * t241 + 0.35089341735807877243573431982554320891834732042568e1 * t57 * t245 * t117 * t247 - 0.85917975471764868594145516183295969534298037676861e0 * t251 * t252 * t253 + 0.71233333333333333333333333333333333333333333333331e-1 * t251 * t257 * t235 - 0.53424999999999999999999999999999999999999999999999e-1 * t251 * t261 * t262 - 0.32530743900905219527896202567159734993471782831130e-1 * t266 * t107 * t268 - 0.21687162600603479685264135044773156662314521887420e-1 * t266 * t81 * t273 + 0.16265371950452609763948101283579867496735891415565e-1 * t266 * t107 * t278 + 0.48159733137676571081572406076840235616767705782485e0 * t266 * t107 * t283 + 0.10685000000000000000000000000000000000000000000000e0 * t251 * t103 * t233 * t288 - 0.56968947174242584615102410102512416326352748836105e-3 * t292 * t75 * t21 * t293
  t299 = t239 + t298
  t301 = f.p.cam_omega ** 2
  t302 = t301 ** 2
  t303 = t302 ** 2
  t308 = 0.1e1 / t14 / t143
  t320 = 0.11073470983333333333333333333333333333333333333333e-2 * t17 * t107 * t40 + 0.10000000000000000000000000000000000000000000000000e1 * t202 * t235 - 0.18311447306006545054854346104378990962041954983034e-3 * t292 * t75 * t103 * t293 - 0.58482236226346462072622386637590534819724553404280e0 * t57 * t273
  t350 = -0.14764627977777777777777777777777777777777777777777e-2 * t17 * t81 * t40 - 0.35616666666666666666666666666666666666666666666666e-1 * t251 * t261 * t235 - 0.20000000000000000000000000000000000000000000000000e1 * t234 * t288 + 0.10000000000000000000000000000000000000000000000000e1 * t202 * t262 + 0.16081979498692535066756296899072713062105388428051e2 * t217 * t253 + 0.24415263074675393406472461472505321282722606644045e-3 * t292 * t75 * t77 * t293 + 0.10843581300301739842632067522386578331157260943710e-1 * t266 * t107 * t273 + 0.11696447245269292414524477327518106963944910680856e1 * t57 * t268 - 0.58482236226346462072622386637590534819724553404280e0 * t57 * t278 - 0.17315859105681463759666483083807725165579399831905e2 * t57 * t283
  t355 = t143 * r0
  t357 = 0.1e1 / t14 / t355
  t363 = -0.621814e-1 * t175 * t40 + 0.19751673498613801407483339618206552048944131217655e-1 * t54 * t56 * t293
  t368 = jnp.sqrt(jnp.pi)
  t370 = 0.1e1 / t368 / t3
  t371 = 0.1e1 / t355
  t372 = t370 * t371
  t373 = 9 ** (0.1e1 / 0.3e1)
  t374 = t373 ** 2
  t376 = jnp.log(0.2e1)
  t384 = (0.2e1 / 0.45e2 * t10 * t374 * t6 * (t3 + 0.6e1 * t376 - 0.3e1) * t5 - 0.7524e0) * t1
  t389 = 0.1e1 / r0
  t390 = t5 * t389
  t392 = t6 * t5
  t393 = t1 * t392
  t396 = 0.1e1 - t384 * t75 * t23 / 0.4e1 + 0.20482500000000000000000000000000000000000000000000e-1 * t34 - 0.95775000000000000000000000000000000000000000000000e-2 * t390 + 0.34856250000000000000000000000000000000000000000000e-3 * t393 * t107
  t399 = jnp.exp(-0.18810000000000000000000000000000000000000000000000e0 * t25)
  t400 = jnp.sqrt(0.2e1)
  t401 = t399 * t400
  t402 = t302 * f.p.cam_omega
  t403 = t401 * t402
  t406 = t370 * t144
  t410 = 0.1e1 / t12
  t411 = t5 * t410
  t415 = t384 * t104 / 0.12e2 - 0.13655000000000000000000000000000000000000000000000e-1 * t115 + 0.95775000000000000000000000000000000000000000000000e-2 * t411 - 0.46475000000000000000000000000000000000000000000000e-3 * t393 * t81
  t419 = 0.1e1 / t19
  t420 = t370 * t419
  t424 = t5 * t419
  t428 = -t384 * t78 / 0.9e1 + 0.22758333333333333333333333333333333333333333333333e-1 * t93 - 0.19155000000000000000000000000000000000000000000000e-1 * t424 + 0.10844166666666666666666666666666666666666666666667e-2 * t393 * t22
  t432 = t396 * t399
  t434 = t432 / 0.2e1 - 0.1e1 / 0.2e1
  t439 = t415 * t399
  t441 = t396 * t1
  t442 = t441 * t6
  t443 = t107 * t399
  t446 = t439 / 0.2e1 + 0.31350000000000000000000000000000000000000000000000e-1 * t442 * t443
  t451 = t428 * t399
  t453 = t415 * t1
  t454 = t453 * t6
  t457 = t81 * t399
  t460 = t396 * t2
  t461 = t460 * t7
  t462 = t92 * t399
  t465 = t451 / 0.2e1 + 0.62700000000000000000000000000000000000000000000000e-1 * t454 * t443 - 0.41800000000000000000000000000000000000000000000000e-1 * t442 * t457 + 0.78625800000000000000000000000000000000000000000000e-2 * t461 * t462
  t473 = t5 * t144
  t476 = 0.1e1 / t13 / t143
  t477 = t18 * t476
  t480 = 0.7e1 / 0.27e2 * t384 * t152 - 0.60688888888888888888888888888888888888888888888888e-1 * t166 + 0.57465000000000000000000000000000000000000000000000e-1 * t473 - 0.36147222222222222222222222222222222222222222222223e-2 * t393 * t477
  t481 = t480 * t399
  t483 = t428 * t1
  t484 = t483 * t6
  t489 = t415 * t2
  t490 = t489 * t7
  t493 = t22 * t399
  t496 = t165 * t399
  t499 = t396 * t5
  t500 = t144 * t399
  t503 = t481 / 0.2e1 + 0.94050000000000000000000000000000000000000000000000e-1 * t484 * t443 - 0.12540000000000000000000000000000000000000000000000e0 * t454 * t457 + 0.23587740000000000000000000000000000000000000000000e-1 * t490 * t462 + 0.97533333333333333333333333333333333333333333333333e-1 * t442 * t493 - 0.31450320000000000000000000000000000000000000000000e-1 * t461 * t496 + 0.59158051920000000000000000000000000000000000000000e-2 * t499 * t500
  t508 = t4 * t371
  t511 = t4 * t144
  t514 = t4 * t419
  t517 = t4 * t410
  t521 = t302 * t301
  t531 = f.p.zeta_threshold ** 2
  t532 = f.my_piecewise3(t44, t531, 1)
  t533 = t532 * t374
  t534 = 0.1e1 / t392
  t535 = t533 * t534
  t538 = t17 * t24 * t50
  t540 = 0.1e1 - 0.56675000000000000000000000000000000000000000000000e-2 * t538
  t542 = t50 ** 2
  t546 = 0.1e1 + 0.10797500000000000000000000000000000000000000000000e0 * t538 + 0.10000000000000000000000000000000000000000000000000e-1 * t31 * t33 * t542
  t547 = 0.1e1 / t546
  t548 = t540 * t547
  t551 = t535 * t1 * t14 * t548 / 0.15e2
  t554 = -0.97000000000000000000000000000000000000000000000000e-1 * t25 + 0.16900000000000000000000000000000000000000000000000e0 * t34
  t556 = jnp.exp(-0.13675000000000000000000000000000000000000000000000e0 * t25)
  t558 = t554 * t556 * t1
  t560 = 0.1e1 / t7 * t18
  t561 = t560 * t14
  t564 = t45 ** 2
  t566 = f.my_piecewise3(t44, t564 * t531, 1)
  t567 = t566 * t374
  t568 = t534 * t1
  t572 = t551 + t558 * t561 / 0.3e1 - t567 * t568 * t14 / 0.15e2
  t580 = 0.2e1 / 0.45e2 * t535 * t1 * t23 * t548
  t581 = jnp.pi * t2
  t582 = t533 * t581
  t583 = t32 * t18
  t584 = t50 * t547
  t587 = 0.12594444444444444444444444444444444444444444444445e-3 * t582 * t583 * t584
  t588 = t533 * t568
  t589 = t14 * t540
  t590 = t546 ** 2
  t591 = 0.1e1 / t590
  t598 = -0.35991666666666666666666666666666666666666666666667e-1 * t17 * t107 * t50 - 0.66666666666666666666666666666666666666666666666667e-2 * t31 * t114 * t542
  t599 = t591 * t598
  t602 = t588 * t589 * t599 / 0.15e2
  t605 = 0.32333333333333333333333333333333333333333333333333e-1 * t108 - 0.11266666666666666666666666666666666666666666666667e0 * t115
  t607 = t605 * t556 * t1
  t611 = 0.1e1 / t6
  t612 = t554 * t2 * t611
  t613 = t33 * t556
  t616 = t560 * t23
  t622 = t580 + t587 - t602 + t607 * t561 / 0.3e1 + 0.60777777777777777777777777777777777777777777777777e-1 * t612 * t613 + 0.2e1 / 0.9e1 * t558 * t616 - 0.2e1 / 0.45e2 * t567 * t568 * t23
  t630 = 0.2e1 / 0.135e3 * t535 * t1 * t103 * t548
  t631 = t113 * t18
  t634 = 0.3e-53 * t582 * t631 * t584
  t635 = t23 * t540
  t638 = 0.4e1 / 0.45e2 * t588 * t635 * t599
  t639 = t50 * t591
  t640 = t639 * t598
  t643 = 0.25188888888888888888888888888888888888888888888890e-3 * t582 * t583 * t640
  t645 = 0.1e1 / t590 / t546
  t646 = t598 ** 2
  t647 = t645 * t646
  t650 = 0.2e1 / 0.15e2 * t588 * t589 * t647
  t657 = 0.47988888888888888888888888888888888888888888888889e-1 * t17 * t81 * t50 + 0.11111111111111111111111111111111111111111111111111e-1 * t31 * t92 * t542
  t658 = t591 * t657
  t661 = t588 * t589 * t658 / 0.15e2
  t664 = -0.43111111111111111111111111111111111111111111111111e-1 * t82 + 0.18777777777777777777777777777777777777777777777778e0 * t93
  t666 = t664 * t556 * t1
  t670 = t605 * t2 * t611
  t678 = t560 * t103
  t684 = -t630 - t634 - t638 - t643 + t650 - t661 + t666 * t561 / 0.3e1 + 0.12155555555555555555555555555555555555555555555555e0 * t670 * t613 + 0.4e1 / 0.9e1 * t607 * t616 + 0.33245444444444444444444444444444444444444444444444e-1 * t554 * t410 * t556 - 0.2e1 / 0.27e2 * t558 * t678 + 0.2e1 / 0.135e3 * t567 * t568 * t103
  t697 = 0.10059259259259259259259259259259259259259259259259e0 * t155 - 0.50074074074074074074074074074074074074074074074075e0 * t166
  t699 = t697 * t556 * t1
  t703 = t664 * t2 * t611
  t708 = t75 * t556
  t711 = t92 * t556
  t718 = 0.75566666666666666666666666666666666666666666666669e-3 * t582 * t583 * t50 * t645 * t646
  t721 = 0.4e1 / 0.15e2 * t588 * t635 * t647
  t722 = t639 * t657
  t725 = 0.37783333333333333333333333333333333333333333333335e-3 * t582 * t583 * t722
  t726 = t590 ** 2
  t727 = 0.1e1 / t726
  t728 = t646 * t598
  t729 = t727 * t728
  t732 = 0.2e1 / 0.5e1 * t588 * t589 * t729
  t734 = t645 * t598
  t735 = t734 * t657
  t738 = 0.2e1 / 0.5e1 * t588 * t589 * t735
  t744 = t114 * t556
  t749 = t560 * t77
  t755 = 0.8e1 / 0.405e3 * t535 * t1 * t77 * t548
  t756 = t103 * t540
  t759 = 0.2e1 / 0.45e2 * t588 * t756 * t599
  t760 = t16 * t18
  t763 = 0.27987654320987654320987654320987654320987654320983e-4 * t582 * t760 * t584
  t766 = 0.2e1 / 0.15e2 * t588 * t635 * t658
  t773 = -0.11197407407407407407407407407407407407407407407407e0 * t17 * t22 * t50 - 0.29629629629629629629629629629629629629629629629629e-1 * t31 * t165 * t542
  t774 = t591 * t773
  t777 = t588 * t589 * t774 / 0.15e2
  t778 = t738 + 0.99736333333333333333333333333333333333333333333330e-1 * t605 * t410 * t556 + 0.2e1 / 0.3e1 * t666 * t616 + 0.2e-50 * t670 * t744 - 0.2e1 / 0.9e1 * t607 * t678 + 0.8e1 / 0.81e2 * t558 * t749 + t755 + t759 - t763 - t766 - t777
  t779 = -0.66490888888888888888888888888888888888888888888888e-1 * t554 * t419 * t556 - 0.8e1 / 0.405e3 * t567 * t568 * t77 + t699 * t561 / 0.3e1 + 0.18233333333333333333333333333333333333333333333333e0 * t703 * t613 + 0.15154381759259259259259259259259259259259259259259e-2 * t554 * t21 * t1 * t708 - 0.13506172839506172839506172839506172839506172839506e-1 * t612 * t711 + t718 + t721 - t725 - t732 + t778
  t796 = 0.15788919698298053987074801337637751567500000000000e1 * t473 * t434 - 0.15788919698298053987074801337637751567500000000000e1 * t424 * t446 + 0.78944598491490269935374006688188757837500000000000e0 * t411 * t465 - 0.26314866163830089978458002229396252612500000000000e0 * t390 * t503 + 0.61927599245865169566569612701717041623388406031679e-1 * t11 * t308 * t572 * jnp.pi - 0.50668035746616956918102410392313943146408695844103e-1 * t11 * t148 * t622 * jnp.pi + 0.19000513404981358844288403897117728679903260941539e-1 * t11 * t16 * t684 * jnp.pi - 0.38001026809962717688576807794235457359806521883077e-2 * t11 * t113 * t779 * jnp.pi - 0.44290700763153930472940116666666666666666666666667e1 * t393 * t477 * t363 + 0.39861630686838537425646105000000000000000000000000e1 * t393 * t22 * t320 - 0.17083556008645087468134045000000000000000000000000e1 * t393 * t81 * t350 + 0.42708890021612718670335112500000000000000000000000e0 * t393 * t107 * t299
  t799 = 0.1e1 / t368 / jnp.pi
  t800 = t799 * t144
  t801 = t432 * t400
  t804 = t799 * t419
  t805 = t439 * t400
  t808 = t799 * t476
  t810 = t75 * t401
  t813 = t799 * t410
  t814 = t451 * t400
  t817 = t799 * t21
  t821 = t799 * t308
  t823 = t69 * t401
  t826 = t799 * t389
  t827 = t481 * t400
  t830 = t799 * t77
  t834 = t799 * t148
  t842 = -0.12375000000000000000000000000000000000000000000000e1 * t25 + t34 / 0.4e1
  t844 = jnp.exp(-0.77500000000000000000000000000000000000000000000000e-1 * t25)
  t845 = t842 * t844
  t846 = jnp.pi * r0
  t849 = t551 + 0.4e1 / 0.3e1 * t845 * t846
  t851 = t400 * t368
  t857 = 0.41250000000000000000000000000000000000000000000000e0 * t108 - t115 / 0.6e1
  t858 = t857 * t844
  t862 = t842 * t1 * t6
  t863 = t844 * jnp.pi
  t864 = t24 * t863
  t869 = t580 + t587 - t602 + 0.4e1 / 0.3e1 * t858 * t846 + 0.34444444444444444444444444444444444444444444444444e-1 * t862 * t864 + 0.4e1 / 0.3e1 * t845 * jnp.pi
  t876 = -0.55000000000000000000000000000000000000000000000000e0 * t82 + 0.5e1 / 0.18e2 * t93
  t877 = t876 * t844
  t881 = t857 * t1 * t6
  t886 = t107 * t863
  t890 = t842 * t2 * t7
  t891 = t114 * t863
  t894 = -t630 - t634 - t638 - t643 + t650 - t661 + 0.4e1 / 0.3e1 * t877 * t846 + 0.68888888888888888888888888888888888888888888888888e-1 * t881 * t864 + 0.8e1 / 0.3e1 * t858 * jnp.pi + 0.22962962962962962962962962962962962962962962962963e-1 * t862 * t886 + 0.35592592592592592592592592592592592592592592592591e-2 * t890 * t891
  t901 = 0.12833333333333333333333333333333333333333333333333e1 * t155 - 0.20e2 / 0.27e2 * t166
  t902 = t901 * t844
  t911 = t876 * t1 * t6
  t915 = t857 * t2 * t7
  t918 = t92 * t863
  t923 = t81 * t863
  t926 = 0.4e1 / 0.3e1 * t902 * t846 + 0.4e1 * t877 * jnp.pi + t718 + t721 - t725 - t732 + t738 + 0.11033703703703703703703703703703703703703703703703e-2 * t842 * t419 * t844 + 0.10333333333333333333333333333333333333333333333333e0 * t911 * t864 + 0.10677777777777777777777777777777777777777777777777e-1 * t915 * t891 - 0.35592592592592592592592592592592592592592592592590e-2 * t890 * t918 + t755 + t759 - t763 - t766 - t777 + 0.68888888888888888888888888888888888888888888888888e-1 * t881 * t886 - 0.30617283950617283950617283950617283950617283950617e-1 * t862 * t923
  t931 = 0.10525946465532035991383200891758501045000000000000e1 * t800 * t801 - 0.10525946465532035991383200891758501045000000000000e1 * t804 * t805 - 0.14421716207386170645527361132919341820655000000000e0 * t808 * t441 * t810 + 0.52629732327660179956916004458792505225000000000000e0 * t813 * t814 + 0.10999614056480977610995444931887633592025000000000e0 * t817 * t453 * t810 + 0.19310922437558004293863603122421929534159090000000e-1 * t821 * t460 * t823 - 0.17543244109220059985638668152930835075000000000000e0 * t826 * t827 - 0.32998842169442932832986334795662900776075000000000e-1 * t830 * t483 * t810 - 0.82761096160962875545129727667522555146396100000000e-2 * t834 * t489 * t823 - 0.20756482917169489186718535699014656830716141880000e-2 * t372 * t801 + 0.49542079396692135653255690161373633298710724825345e-1 * t11 * t308 * t849 * t851 - 0.40534428597293565534481928313851154517126956675283e-1 * t11 * t148 * t869 * t851 + 0.15200410723985087075430723117694182943922608753231e-1 * t11 * t16 * t894 * t851 - 0.30400821447970174150861446235388365887845217506462e-2 * t11 * t113 * t926 * t851
  t932 = t301 * f.p.cam_omega
  t934 = f.my_piecewise3(t44, t564, 1)
  t935 = t934 ** 2
  t936 = t935 * t934
  t937 = t376 - 0.1e1
  t939 = 0.2e1 * t936 * t937
  t940 = t939 * t4
  t942 = 0.1e1 / t934
  t943 = f.p.cam_omega * t73 * t942
  t945 = 0.48717083333333333333333333333333333333333333333333e0 * t943 * t108
  t955 = (0.344851e1 - jnp.pi * t10 * t374 * t6 / t937 / 0.12e2) * t301 * t1
  t956 = 0.1e1 / t935
  t962 = 0.1e1 / t936
  t963 = t932 * t26 * t962
  t966 = -t945 - t955 * t75 * t103 * t956 / 0.12e2 - 0.24484000000000000000000000000000000000000000000000e0 * t963 * t108
  t969 = 0.29230250000000000000000000000000000000000000000000e1 * f.p.cam_omega * t26 * t942
  t971 = t301 * t1 * t6
  t975 = 0.1e1 + t969 + 0.86212750000000000000000000000000000000000000000000e0 * t971 * t24 * t956
  t976 = 0.1e1 / t975
  t985 = 0.1e1 + t969 + t955 * t75 * t23 * t956 / 0.4e1 + 0.48968000000000000000000000000000000000000000000000e0 * t932 * t66 * t962
  t986 = t975 ** 2
  t987 = 0.1e1 / t986
  t988 = t985 * t987
  t992 = -t945 - 0.28737583333333333333333333333333333333333333333333e0 * t971 * t107 * t956
  t994 = t966 * t976 - t988 * t992
  t995 = t985 ** 2
  t996 = 0.1e1 / t995
  t997 = t994 * t996
  t998 = t992 * t966
  t1003 = f.p.cam_omega * t67 * t942
  t1005 = 0.32478055555555555555555555555555555555555555555555e0 * t1003 * t93
  t1007 = 0.64956111111111111111111111111111111111111111111111e0 * t943 * t82
  t1013 = t932 * t73 * t962
  t1018 = -t1005 + t1007 + t955 * t75 * t77 * t956 / 0.9e1 + 0.16322666666666666666666666666666666666666666666667e0 * t1013 * t93 + 0.32645333333333333333333333333333333333333333333333e0 * t963 * t82
  t1019 = t975 * t1018
  t1022 = 0.20267214298646782767240964156925577258563478337641e-1 * t11 * t16 * t299 * t303 + 0.59450495276030562783906828193648359958452869790413e0 * t11 * t308 * t320 * t303 - 0.16213771438917426213792771325540461806850782670113e0 * t11 * t148 * t350 * t303 - 0.92478548207158653219410621634564115490926686340644e0 * t11 * t357 * t363 * t303 - 0.11747417866543639206099989251064915927790287070586e0 * t372 * t396 * t403 + 0.71162242845408583652336473347797086870268085139125e-1 * t406 * t415 * t403 - 0.15249052038301839354072101431670804329343161101241e-1 * t420 * t428 * t403 + (0.16514026465564045217751896720457877766236908275114e0 * t11 * t308 * t434 * jnp.pi - 0.13511476199097855178160642771283718172375652225094e0 * t11 * t148 * t446 * jnp.pi + 0.50668035746616956918102410392313943146408695844101e-1 * t11 * t16 * t465 * jnp.pi - 0.10133607149323391383620482078462788629281739168820e-1 * t11 * t113 * t503 * jnp.pi - 0.12631135758638443189659841070110201254000000000000e2 * t508 * t363 + 0.94733518189788323922448808025826509405000000000000e1 * t511 * t320 - 0.31577839396596107974149602675275503135000000000000e1 * t514 * t350 + 0.52629732327660179956916004458792505225000000000000e0 * t517 * t299) * t521 + t796 * t302 + t931 * t932 - 0.2e1 * t940 * t997 * t998 - t940 * t997 * t1019
  t1024 = t966 * t987
  t1028 = 0.1e1 / t986 / t975
  t1029 = t985 * t1028
  t1030 = t992 ** 2
  t1036 = -t1005 + t1007 + 0.38316777777777777777777777777777777777777777777777e0 * t971 * t81 * t956
  t1038 = t1018 * t976 - 0.2e1 * t1024 * t992 + 0.2e1 * t1029 * t1030 - t988 * t1036
  t1039 = t1038 * t996
  t1040 = t975 * t966
  t1045 = 0.1e1 / t995 / t985
  t1046 = t994 * t1045
  t1047 = t966 ** 2
  t1048 = t975 * t1047
  t1052 = 0.1e1 / t985
  t1053 = t994 * t1052
  t1056 = t1038 * t1052
  t1060 = f.p.cam_omega * t141
  t1061 = t942 * t5
  t1064 = 0.19486833333333333333333333333333333333333333333333e1 * t1060 * t1061 * t144
  t1066 = 0.12991222222222222222222222222222222222222222222222e1 * t1003 * t166
  t1068 = 0.15156425925925925925925925925925925925925925925926e1 * t943 * t155
  t1073 = t932 * t67
  t1074 = t962 * t5
  t1082 = -t1064 + t1066 - t1068 - 0.7e1 / 0.27e2 * t955 * t75 * t21 * t956 + 0.32645333333333333333333333333333333333333333333334e0 * t1073 * t1074 * t144 - 0.65290666666666666666666666666666666666666666666667e0 * t1013 * t166 - 0.76172444444444444444444444444444444444444444444444e0 * t963 * t155
  t1084 = t1018 * t987
  t1087 = t966 * t1028
  t1092 = t986 ** 2
  t1093 = 0.1e1 / t1092
  t1094 = t985 * t1093
  t1095 = t1030 * t992
  t1098 = t992 * t1036
  t1104 = -t1064 + t1066 - t1068 - 0.89405814814814814814814814814814814814814814814813e0 * t971 * t22 * t956
  t1106 = -0.3e1 * t1024 * t1036 + 0.6e1 * t1029 * t1098 + 0.6e1 * t1087 * t1030 + t1082 * t976 - 0.3e1 * t1084 * t992 - 0.6e1 * t1094 * t1095 - t988 * t1104
  t1107 = t1106 * t1052
  t1110 = t10 * t308
  t1111 = t9 * t1110
  t1112 = t851 * t402
  t1113 = t432 * t1112
  t1116 = t9 * t92
  t1117 = t451 * t1112
  t1121 = 0.1e1 / t13 / t355
  t1122 = t370 * t1121
  t1124 = t75 * t403
  t1127 = t9 * t114
  t1128 = t481 * t1112
  t1131 = t370 * t476
  t1135 = t370 * t357
  t1137 = t69 * t403
  t1140 = t9 * t165
  t1141 = t439 * t1112
  t1144 = -0.2e1 * t940 * t1039 * t1040 + 0.2e1 * t940 * t1046 * t1048 + t940 * t1053 * t1036 + 0.2e1 * t940 * t1056 * t992 + t940 * t1107 * t975 + 0.11009350977042696811834597813638585177491272183410e0 * t1111 * t1113 + 0.33778690497744637945401606928209295430939130562734e-1 * t1116 * t1117 + 0.28683466884045759825009622792972782943494486031434e-2 * t1122 * t441 * t1124 - 0.67557380995489275890803213856418590861878261125470e-2 * t1127 * t1128 - 0.95611556280152532750032075976575943144981620104783e-3 * t1131 * t453 * t1124 - 0.79931261050207517379026815516417488469204634407598e-4 * t1135 * t460 * t1137 - 0.90076507993985701187737618475224787815837681500624e-1 * t1140 * t1141
  t1145 = t1022 + t1144
  t1149 = 0.1e1 + 0.15403623315025000000000000000000000000000000000000e0 * t31 * t33 * t301
  t1150 = t1149 ** 2
  t1151 = t1150 ** 2
  t1152 = 0.1e1 / t1151
  t1266 = t940 * t1056 * t975 - t940 * t997 * t1040 + t940 * t1053 * t992 + (-0.35086488218440119971277336305861670150000000000000e0 * t804 * t801 + 0.35086488218440119971277336305861670150000000000000e0 * t813 * t805 + 0.36665380188269925369984816439625445306750000000000e-1 * t817 * t441 * t810 - 0.17543244109220059985638668152930835075000000000000e0 * t826 * t814 - 0.21999228112961955221990889863775267184050000000000e-1 * t830 * t453 * t810 - 0.27587032053654291848376575889174185048798700000000e-2 * t834 * t460 * t823 - 0.13511476199097855178160642771283718172375652225094e-1 * t11 * t148 * t849 * t851 + 0.10133607149323391383620482078462788629281739168821e-1 * t11 * t16 * t869 * t851 - 0.30400821447970174150861446235388365887845217506462e-2 * t11 * t113 * t894 * t851) * t932 + (-0.52629732327660179956916004458792505225000000000000e0 * t424 * t434 + 0.52629732327660179956916004458792505225000000000000e0 * t411 * t446 - 0.26314866163830089978458002229396252612500000000000e0 * t390 * t465 - 0.16889345248872318972700803464104647715469565281367e-1 * t11 * t148 * t572 * jnp.pi + 0.12667008936654239229525602598078485786602173961026e-1 * t11 * t16 * t622 * jnp.pi - 0.38001026809962717688576807794235457359806521883077e-2 * t11 * t113 * t684 * jnp.pi + 0.13287210228946179141882035000000000000000000000000e1 * t393 * t22 * t363 - 0.11389037339096724978756030000000000000000000000000e1 * t393 * t81 * t320 + 0.42708890021612718670335112500000000000000000000000e0 * t393 * t107 * t350) * t302 - 0.30025502664661900395912539491741595938612560500208e-1 * t1140 * t1113 + 0.22519126998496425296934404618806196953959420375156e-1 * t1116 * t1141 + 0.23720747615136194550778824449265695623422695046375e-1 * t406 * t396 * t403 - 0.67557380995489275890803213856418590861878261125470e-2 * t1127 * t1117 - 0.10166034692201226236048067621113869552895440734161e-1 * t420 * t415 * t403 - 0.31870518760050844250010691992191981048327206701594e-3 * t1131 * t441 * t1124 + (-0.45038253996992850593868809237612393907918840750312e-1 * t11 * t148 * t434 * jnp.pi + 0.33778690497744637945401606928209295430939130562734e-1 * t11 * t16 * t446 * jnp.pi - 0.10133607149323391383620482078462788629281739168820e-1 * t11 * t113 * t465 * jnp.pi + 0.31577839396596107974149602675275503135000000000000e1 * t511 * t363 - 0.21051892931064071982766401783517002090000000000000e1 * t514 * t320 + 0.52629732327660179956916004458792505225000000000000e0 * t517 * t350) * t521 + 0.19816831758676854261302276064549453319484289930138e0 * t11 * t308 * t363 * t303 - 0.10809180959278284142528514217026974537900521780075e0 * t11 * t148 * t320 * t303 + 0.20267214298646782767240964156925577258563478337641e-1 * t11 * t16 * t350 * t303
  t1268 = 0.1e1 / t1151 / t1149
  t1343 = t940 * t1053 * t975 + (0.17543244109220059985638668152930835075000000000000e0 * t813 * t801 - 0.17543244109220059985638668152930835075000000000000e0 * t826 * t805 - 0.10999614056480977610995444931887633592025000000000e-1 * t830 * t441 * t810 + 0.50668035746616956918102410392313943146408695844103e-2 * t11 * t16 * t849 * t851 - 0.30400821447970174150861446235388365887845217506462e-2 * t11 * t113 * t869 * t851) * t932 + (0.26314866163830089978458002229396252612500000000000e0 * t411 * t434 - 0.26314866163830089978458002229396252612500000000000e0 * t390 * t446 + 0.63335044683271196147628012990392428933010869805128e-2 * t11 * t16 * t572 * jnp.pi - 0.38001026809962717688576807794235457359806521883077e-2 * t11 * t113 * t622 * jnp.pi - 0.56945186695483624893780150000000000000000000000000e0 * t393 * t81 * t363 + 0.42708890021612718670335112500000000000000000000000e0 * t393 * t107 * t320) * t302 + 0.11259563499248212648467202309403098476979710187578e-1 * t1116 * t1113 - 0.67557380995489275890803213856418590861878261125470e-2 * t1127 * t1141 - 0.50830173461006131180240338105569347764477203670804e-2 * t420 * t396 * t403 + (0.16889345248872318972700803464104647715469565281367e-1 * t11 * t16 * t434 * jnp.pi - 0.10133607149323391383620482078462788629281739168820e-1 * t11 * t113 * t446 * jnp.pi - 0.10525946465532035991383200891758501045000000000000e1 * t514 * t363 + 0.52629732327660179956916004458792505225000000000000e0 * t517 * t320) * t521 - 0.54045904796391420712642571085134872689502608900376e-1 * t11 * t148 * t363 * t303 + 0.20267214298646782767240964156925577258563478337641e-1 * t11 * t16 * t320 * t303
  t1345 = 0.1e1 / t1151 / t1150
  t1348 = t392 * t18
  t1360 = jnp.log(t985 * t976)
  t1396 = t939 * t4 * t1360 + (-0.17543244109220059985638668152930835075000000000000e0 * t826 * t801 - 0.30400821447970174150861446235388365887845217506462e-2 * t11 * t113 * t849 * t851) * t932 + (-0.26314866163830089978458002229396252612500000000000e0 * t390 * t434 - 0.38001026809962717688576807794235457359806521883077e-2 * t11 * t113 * t572 * jnp.pi + 0.42708890021612718670335112500000000000000000000000e0 * t393 * t107 * t363) * t302 - 0.67557380995489275890803213856418590861878261125470e-2 * t1127 * t1113 + (-0.10133607149323391383620482078462788629281739168820e-1 * t11 * t113 * t434 * jnp.pi + 0.52629732327660179956916004458792505225000000000000e0 * t517 * t363) * t521 + 0.20267214298646782767240964156925577258563478337641e-1 * t11 * t16 * t363 * t303
  t1399 = 0.1e1 / t1151 / t1150 / t1149
  t1422 = t143 * t12
  t1426 = t370 / t13 / t1422 * t441
  t1440 = 0.1e1 / t14 / t1422
  t1445 = t75 * t476
  t1448 = t31 * t1110
  t1450 = t5 * t371
  t1452 = t18 * t1121
  t1456 = (-0.70e2 / 0.81e2 * t384 * t1445 + 0.22252592592592592592592592592592592592592592592592e0 * t1448 - 0.22986000000000000000000000000000000000000000000000e0 * t1450 + 0.15663796296296296296296296296296296296296296296297e-1 * t393 * t1452) * t399
  t1481 = t54 * t251
  t1483 = t117 * t170
  t1520 = t124 ** 2
  t1525 = -0.13012297560362087811158481026863893997388713132452e0 * t1481 * t103 * t245 * t1483 * t95 + 0.19263893255070628432628962430736094246707082312994e1 * t1481 * t103 * t65 * t95 * t101 * t117 + 0.86748650402413918741056540179092626649258087549680e-1 * t266 * t81 * t268 + 0.67471172535210825687488420139294265171645179205307e-1 * t266 * t22 * t273 + 0.38025319932552508024225805073234468230220037056326e2 * t266 * t107 * t129 - 0.38527786510141256865257924861472188493414164625988e1 * t266 * t107 * t135 + 0.21687162600603479685264135044773156662314521887420e-1 * t266 * t107 * t171 + 0.13012297560362087811158481026863893997388713132452e0 * t266 * t107 * t241 - 0.43374325201206959370528270089546313324629043774840e-1 * t266 * t81 * t278 - 0.12842595503380418955085974953824062831138054875329e1 * t266 * t81 * t283 + 0.12304822629859687989861833551788232416071203002497e5 * t57 / t64 / t244 * t1520 * t128
  t1530 = t95 ** 2
  t1545 = 0.1e1 / t26 / t390 / 0.48e2
  t1548 = t1545 * t5 * t1121 * t251
  t1550 = t142 * t371
  t1552 = t69 * t308
  t1553 = t68 * t1552
  t1555 = t74 * t1445
  t1557 = t17 * t477
  t1559 = t25 ** (-0.25e1)
  t1562 = t1559 * t5 * t1121 * t251
  t1564 = t158 * t371
  t1566 = t85 * t1552
  t1568 = t89 * t1445
  t1576 = t64 ** 2
  t1579 = t100 ** 2
  t1584 = t186 ** 2
  t1597 = t224 ** 2
  t1615 = t177 ** 2
  t1618 = t188 ** 2
  t1623 = -0.62337092780453269534799339101707810596085839394858e3 * t57 * t123 * t1520 * t101 - 0.51947577317044391278999449251423175496738199495715e2 * t57 * t65 * t1530 * t101 + 0.14035736694323150897429372793021728356733892817027e2 * t57 * t133 * t1520 * t170 + 0.35089341735807877243573431982554320891834732042568e1 * t57 * t245 * t1530 * t170 - 0.58482236226346462072622386637590534819724553404280e0 * t57 * t138 * (-0.28769444444444444444444444444444444444444444444444e1 * t1548 + 0.27618666666666666666666666666666666666666666666667e2 * t1550 - 0.10229135802469135802469135802469135802469135802469e2 * t1553 + 0.89504938271604938271604938271604938271604938271607e1 * t1555 + 0.31310740740740740740740740740740740740740740740741e1 * t1557 + 0.36677500000000000000000000000000000000000000000000e-1 * t1562 - 0.58684000000000000000000000000000000000000000000000e0 * t1564 + 0.65204444444444444444444444444444444444444444444445e0 * t1566 + 0.57053888888888888888888888888888888888888888888890e0 * t1568 + 0.13490888888888888888888888888888888888888888888889e1 * t1448) * t170 - 0.91082604192152556048340974007871726131433263376469e5 * t57 / t1576 * t1520 / t1579 - 0.24000000000000000000000000000000000000000000000000e2 * t196 * t1584 * t212 + 0.57895126195293126240322668836661767023579398340984e3 * t180 * t1584 * t197 - 0.62071215503128080358781102641263322069063951965254e4 * t175 / t177 / t232 * t1584 * t190 + 0.48245938496077605200268890697218139186316165284153e2 * t217 * t1597 * t197 + 0.10000000000000000000000000000000000000000000000000e1 * t202 * (-0.21099166666666666666666666666666666666666666666667e1 * t1548 + 0.20255200000000000000000000000000000000000000000000e2 * t1550 - 0.75019259259259259259259259259259259259259259259258e1 * t1553 + 0.65641851851851851851851851851851851851851851851850e1 * t1555 + 0.31003950617283950617283950617283950617283950617285e1 * t1557 + 0.68258333333333333333333333333333333333333333333335e-1 * t1562 - 0.10921333333333333333333333333333333333333333333333e1 * t1564 + 0.12134814814814814814814814814814814814814814814815e1 * t1566 + 0.10617962962962962962962962962962962962962962962963e1 * t1568 + 0.13388493827160493827160493827160493827160493827161e1 * t1448) * t212 + 0.24955700379505800914252936827276051226357058527653e5 * t175 / t1615 * t1584 / t1618
  t1666 = -0.60000000000000000000000000000000000000000000000000e1 * t234 * t1597 * t212 - 0.28493333333333333333333333333333333333333333333333e0 * t251 * t77 * t233 * t288 + 0.62337092780453269534799339101707810596085839394858e3 * t57 * t133 * t95 * t101 * t124 + 0.46785788981077169658097909310072427855779642723424e1 * t57 * t245 * t168 * t1483 - 0.22161481481481481481481481481481481481481481481481e0 * t251 * t21 * t201 * t235 - 0.69263436422725855038665932335230900662317599327620e2 * t57 * t65 * t168 * t118 - 0.61524113149298439949309167758941162080356015012483e4 * t57 * t123 * t95 * t128 * t124 + 0.14246666666666666666666666666666666666666666666666e0 * t251 * t257 * t262 - 0.21053605041484726346144059189532592535100839225540e2 * t57 * t282 * t247 - 0.42740000000000000000000000000000000000000000000000e0 * t251 * t252 * t229 - 0.71233333333333333333333333333333333333333333333332e-1 * t251 * t261 * t213
  t1712 = -0.36846163202829085479643115651216588683774907041596e2 * t251 * t103 * t179 * t191 + 0.68734380377411894875316412946636775627438430141488e1 * t251 * t103 * t195 * t198 + 0.18989649058080861538367470034170805442117582945368e-2 * t292 * t75 * t476 * t293 + 0.22911460125803964958438804315545591875812810047162e1 * t251 * t77 * t216 * t253 + 0.64327917994770140267025187596290852248421553712204e2 * t217 * t211 * t197 * t185 - 0.80000000000000000000000000000000000000000000000000e1 * t234 * t213 * t185 + 0.31035607751564040179390551320631661034531975982628e4 * t180 * t186 * t190 * t224 - 0.57895126195293126240322668836661767023579398340984e3 * t196 * t253 * t224 + 0.36000000000000000000000000000000000000000000000000e2 * t217 * t288 * t224 - 0.11483599538271604938271604938271604938271604938271e-1 * t17 * t477 * t40 - 0.34367190188705947437658206473318387813719215070744e1 * t108 * t216 * t224 * t197 * t185 + 0.42740000000000000000000000000000000000000000000000e0 * t108 * t233 * t185 * t262
  t1714 = t1525 + t1623 + t1666 + t1712
  t1722 = t1121 * t1 * t75
  t1724 = 0.16239027777777777777777777777777777777777777777777e1 * f.p.cam_omega * t1545 * t1061 * t1722
  t1727 = 0.15589466666666666666666666666666666666666666666666e2 * t1060 * t1061 * t371
  t1729 = 0.57738765432098765432098765432098765432098765432098e1 * t1003 * t1448
  t1731 = 0.50521419753086419753086419753086419753086419753087e1 * t943 * t1557
  t1767 = t1030 ** 2
  t1773 = t1036 ** 2
  t1784 = (-t1724 + t1727 - t1729 + t1731 + 0.70e2 / 0.81e2 * t955 * t75 * t476 * t956 + 0.16322666666666666666666666666666666666666666666667e0 * t932 * t141 * t1074 * t1722 - 0.26116266666666666666666666666666666666666666666667e1 * t1073 * t1074 * t371 + 0.29018074074074074074074074074074074074074074074074e1 * t1013 * t1448 + 0.25390814814814814814814814814814814814814814814815e1 * t963 * t1557) * t976 - 0.4e1 * t1082 * t987 * t992 + 0.12e2 * t1018 * t1028 * t1030 - 0.6e1 * t1084 * t1036 - 0.24e2 * t966 * t1093 * t1095 + 0.24e2 * t1087 * t1098 - 0.4e1 * t1024 * t1104 + 0.24e2 * t985 / t1092 / t975 * t1767 - 0.36e2 * t1094 * t1030 * t1036 + 0.6e1 * t1029 * t1773 + 0.8e1 * t1029 * t992 * t1104 - t988 * (-t1724 + t1727 - t1729 + t1731 + 0.29801938271604938271604938271604938271604938271604e1 * t971 * t477 * t956)
  t1791 = -0.51376971226199251788561456463646730828292603522580e0 * t9 * t10 * t357 * t1113 - 0.18015301598797140237547523695044957563167536300125e0 * t1140 * t1117 - 0.22663480007147267022229825416669853189921569210022e-1 * t1426 * t1124 + 0.11473386753618303930003849117189113177397794412574e-1 * t1122 * t453 * t1124 - 0.19122311256030506550006415195315188628996324020956e-2 * t1131 * t483 * t1124 + 0.44037403908170787247338391254554340709965088733639e0 * t1111 * t1141 + 0.45038253996992850593868809237612393907918840750312e-1 * t1116 * t1128 + 0.11723251620697102548923932942407898308816679713114e-2 * t370 * t1440 * t460 * t1137 - 0.67557380995489275890803213856418590861878261125470e-2 * t1127 * t1456 * t1112 - 0.31972504420083006951610726206566995387681853763040e-3 * t1135 * t489 * t1137 + 0.6e1 * t940 * t1038 * t1045 * t1048 - 0.6e1 * t940 * t1039 * t998 - 0.3e1 * t940 * t1039 * t1019 - 0.3e1 * t940 * t1106 * t996 * t1040 - 0.3e1 * t940 * t997 * t992 * t1018 + 0.20267214298646782767240964156925577258563478337641e-1 * t11 * t16 * t1714 * t303 + t940 * t1784 * t1052 * t975 + 0.3e1 * t940 * t1056 * t1036
  t1803 = t995 ** 2
  t1834 = t480 * t1
  t1840 = t428 * t2
  t1865 = t1456 / 0.2e1 + 0.12540000000000000000000000000000000000000000000000e0 * t1834 * t6 * t443 - 0.25080000000000000000000000000000000000000000000000e0 * t484 * t457 + 0.47175480000000000000000000000000000000000000000000e-1 * t1840 * t7 * t462 + 0.39013333333333333333333333333333333333333333333333e0 * t454 * t493 - 0.12580128000000000000000000000000000000000000000000e0 * t490 * t496 + 0.23663220768000000000000000000000000000000000000000e-1 * t415 * t5 * t500 - 0.32511111111111111111111111111111111111111111111111e0 * t442 * t477 * t399 + 0.13977920000000000000000000000000000000000000000000e0 * t461 * t1110 * t399 - 0.47326441536000000000000000000000000000000000000000e-1 * t499 * t371 * t399 + 0.37092098553840000000000000000000000000000000000000e-3 * t499 * t1121 * t17 * t18 * t399
  t1870 = 0.1e1 / t1422
  t1905 = t370 * t1870
  t1931 = 0.30226666666666666666666666666666666666666666666668e-2 * t533 * t581 * t32 * t18 * t50 * t735
  t1936 = 0.30226666666666666666666666666666666666666666666668e-2 * t582 * t583 * t50 * t727 * t728
  t1939 = 0.1e-52 * t582 * t631 * t722
  t1944 = 0.12e2 / 0.5e1 * t588 * t589 * t727 * t646 * t657
  t1948 = 0.8e1 / 0.15e2 * t588 * t589 * t734 * t773
  t1951 = 0.11195061728395061728395061728395061728395061728395e-3 * t582 * t760 * t640
  t1954 = 0.16e2 / 0.15e2 * t588 * t635 * t735
  t1958 = 0.50377777777777777777777777777777777777777777777780e-3 * t582 * t583 * t639 * t773
  t1976 = 0.56e2 / 0.1215e4 * t535 * t1 * t21 * t548
  t1979 = 0.28503734567901234567901234567901234567901234567899e-4 * t842 * t476 * t1 * t75 * t844 + t1931 - t1936 + t1939 - t1944 + t1948 + t1951 + t1954 - t1958 + 0.44134814814814814814814814814814814814814814814812e-2 * t857 * t419 * t844 + 0.16e2 / 0.3e1 * t902 * jnp.pi - 0.44134814814814814814814814814814814814814814814812e-2 * t842 * t144 * t844 + 0.4e1 / 0.3e1 * (-0.42777777777777777777777777777777777777777777777777e1 * t1557 + 0.220e3 / 0.81e2 * t1448) * t844 * t846 - t1976 + 0.13777777777777777777777777777777777777777777777778e0 * t911 * t886
  t2000 = 0.8e1 / 0.45e2 * t588 * t635 * t774
  t2011 = t588 * t589 * t591 * (0.37324691358024691358024691358024691358024691358023e0 * t17 * t477 * t50 + 0.10864197530864197530864197530864197530864197530864e0 * t31 * t1110 * t542) / 0.15e2
  t2015 = 0.32e2 / 0.405e3 * t588 * t77 * t540 * t599
  t2019 = 0.11195061728395061728395061728395061728395061728394e-3 * t582 * t148 * t18 * t584
  t2022 = 0.4e1 / 0.45e2 * t588 * t756 * t658
  t2025 = t646 ** 2
  t2029 = 0.8e1 / 0.5e1 * t588 * t589 / t726 / t546 * t2025
  t2030 = t657 ** 2
  t2034 = 0.2e1 / 0.5e1 * t588 * t589 * t645 * t2030
  t2037 = 0.8e1 / 0.45e2 * t588 * t756 * t647
  t2040 = 0.16e2 / 0.15e2 * t588 * t635 * t729
  t2041 = 0.21355555555555555555555555555555555555555555555554e-1 * t876 * t2 * t7 * t891 - 0.12246913580246913580246913580246913580246913580247e0 * t881 * t923 + 0.71440329218106995884773662551440329218106995884773e-1 * t862 * t22 * t863 - 0.14237037037037037037037037037037037037037037037036e-1 * t915 * t918 + 0.63275720164609053497942386831275720164609053497937e-2 * t890 * t165 * t863 + 0.13777777777777777777777777777777777777777777777777e0 * t901 * t1 * t6 * t864 - t2000 - t2011 - t2015 + t2019 + t2022 + t2029 + t2034 - t2037 - t2040
  t2104 = -0.30400821447970174150861446235388365887845217506462e-2 * t11 * t113 * (t1979 + t2041) * t851 - 0.23119637051789663304852655408641028872731671585161e0 * t11 * t357 * t849 * t851 + 0.69093871999228659363882498535116394711386666666667e0 * t799 * t1121 * t441 * t810 - 0.57686864829544682582109444531677367282620000000000e0 * t808 * t453 * t810 - 0.12628730229006186935034610295933071377894516000000e0 * t799 * t357 * t460 * t823 + 0.21999228112961955221990889863775267184050000000000e0 * t817 * t483 * t810 + 0.77243689750232017175454412489687718136636360000000e-1 * t821 * t489 * t823 - 0.43998456225923910443981779727550534368100000000000e-1 * t830 * t1834 * t810 - 0.16552219232192575109025945533504511029279220000000e-1 * t834 * t1840 * t823 - 0.13014314789065269720072521883282189832859020958760e-3 * t1426 * t810 - 0.83025931668677956746874142796058627322864567520000e-2 * t372 * t805 + 0.19816831758676854261302276064549453319484289930138e0 * t11 * t308 * t869 * t851 - 0.81068857194587131068963856627702309034253913350566e-1 * t11 * t148 * t894 * t851 + 0.20267214298646782767240964156925577258563478337641e-1 * t11 * t16 * t926 * t851 - 0.42103785862128143965532803567034004180000000000000e1 * t799 * t371 * t801 + 0.42103785862128143965532803567034004180000000000000e1 * t800 * t805 - 0.21051892931064071982766401783517002090000000000000e1 * t804 * t814 + 0.70172976436880239942554672611723340300000000000000e0 * t813 * t827 + 0.24907779500603387024062242838817588196859370256000e-1 * t1905 * t801 - 0.17543244109220059985638668152930835075000000000000e0 * t826 * t1456 * t400
  t2182 = t1931 - 0.54024691358024691358024691358024691358024691358027e-1 * t670 * t711 - 0.80823369382716049382716049382716049382716049382715e-2 * t554 * t476 * t1 * t708 + (-0.33530864197530864197530864197530864197530864197530e0 * t1557 + 0.18360493827160493827160493827160493827160493827161e1 * t1448) * t556 * t1 * t561 / 0.3e1 + 0.24311111111111111111111111111111111111111111111111e0 * t697 * t2 * t611 * t613 + 0.60617527037037037037037037037037037037037037037035e-2 * t605 * t21 * t1 * t708 - 0.56e2 / 0.243e3 * t558 * t560 * t21 + 0.8e1 / 0.9e1 * t699 * t616 + 0.2e-50 * t703 * t744 + 0.54024691358024691358024691358024691358024691358024e-1 * t612 * t165 * t556 - 0.4e1 / 0.9e1 * t666 * t678 + 0.32e2 / 0.81e2 * t607 * t749 + 0.27631489407716049382716049382716049382716049382715e-3 * t554 * t308 * t2 * t69 * t556 + 0.56e2 / 0.1215e4 * t567 * t568 * t21 - t1936 + t1939 - t1944
  t2192 = t1948 + t1951 + t1954 - t1958 + 0.19208479012345679012345679012345679012345679012345e0 * t554 * t144 * t556 - 0.26596355555555555555555555555555555555555555555555e0 * t605 * t419 * t556 + 0.19947266666666666666666666666666666666666666666666e0 * t664 * t410 * t556 - t1976 - t2000 - t2011 - t2015 + t2019 + t2022 + t2029 + t2034 - t2037 - t2040
  t2213 = -0.63155678793192215948299205350551006270000000000000e1 * t1450 * t434 + 0.63155678793192215948299205350551006270000000000000e1 * t473 * t446 - 0.31577839396596107974149602675275503135000000000000e1 * t424 * t465 + 0.10525946465532035991383200891758501045000000000000e1 * t411 * t503 - 0.26314866163830089978458002229396252612500000000000e0 * t390 * t1865 - 0.28899546314737079131065819260801286090914589481450e0 * t11 * t357 * t572 * jnp.pi + 0.24771039698346067826627845080686816649355362412672e0 * t11 * t308 * t622 * jnp.pi - 0.10133607149323391383620482078462788629281739168821e0 * t11 * t148 * t684 * jnp.pi + 0.25334017873308478459051205196156971573204347922052e-1 * t11 * t16 * t779 * jnp.pi - 0.38001026809962717688576807794235457359806521883077e-2 * t11 * t113 * (t2182 + t2192) * jnp.pi + 0.19192636997366703204940717222222222222222222222222e2 * t393 * t1452 * t363 - 0.17716280305261572189176046666666666666666666666667e2 * t393 * t477 * t320 + 0.79723261373677074851292210000000000000000000000000e1 * t393 * t22 * t350 - 0.22778074678193449957512060000000000000000000000000e1 * t393 * t81 * t299 + 0.42708890021612718670335112500000000000000000000000e0 * t393 * t107 * t1714
  t2215 = 0.6e1 * t940 * t1046 * t992 * t1047 - 0.3e1 * t940 * t997 * t1036 * t966 - t940 * t997 * t975 * t1082 - 0.6e1 * t940 * t994 / t1803 * t975 * t1047 * t966 + 0.11890099055206112556781365638729671991690573958083e1 * t11 * t308 * t350 * t303 + t940 * t1053 * t1104 + (-0.77065456839298877682842184695470096242438905283865e0 * t11 * t357 * t434 * jnp.pi + 0.66056105862256180871007586881831511064947633100459e0 * t11 * t308 * t446 * jnp.pi - 0.27022952398195710356321285542567436344751304450188e0 * t11 * t148 * t465 * jnp.pi + 0.67557380995489275890803213856418590861878261125468e-1 * t11 * t16 * t503 * jnp.pi - 0.10133607149323391383620482078462788629281739168820e-1 * t11 * t113 * t1865 * jnp.pi + 0.63155678793192215948299205350551006270000000000000e2 * t4 * t1870 * t363 - 0.50524543034553772758639364280440805016000000000000e2 * t508 * t320 + 0.18946703637957664784489761605165301881000000000000e2 * t511 * t350 - 0.42103785862128143965532803567034004180000000000000e1 * t514 * t299 + 0.52629732327660179956916004458792505225000000000000e0 * t517 * t1714) * t521 - 0.21618361918556568285057028434053949075801043560151e0 * t11 * t148 * t299 * t303 - 0.60140280814176136075979775994552518324229566928277e-4 / t368 / t3 / jnp.pi / t143 / t19 * t396 * t403 - 0.36991419282863461287764248653825646196370674536257e1 * t11 * t357 * t320 * t303 + 0.52404510650723236824332685592919665444858455593032e1 * t11 * t1440 * t363 * t303 + 0.67020525007845121111724297650306251126495868543728e0 * t1905 * t396 * t403 - 0.46989671466174556824399957004259663711161148282343e0 * t372 * t415 * t403 + 0.14232448569081716730467294669559417374053617027825e0 * t406 * t428 * t403 - 0.20332069384402452472096135242227739105790881468321e-1 * t420 * t480 * t403 + 0.3e1 * t940 * t1107 * t992 + t2104 * t932 + 0.6e1 * t939 * t4 * t994 * t1045 * t975 * t1018 * t966 + t2213 * t302
  t2237 = t1151 ** 2
  v4rho4_0_ = 0.4e1 * t1145 * t1152 + 0.82152657680133333333333333333333333333333333333335e0 * t1266 * t1268 * t2 * t69 * t113 * t301 - 0.50617943729318777683360133333333333333333333333336e1 * t1343 * t1345 * t1 * t1348 * t21 * t302 - 0.91280730755703703703703703703703703703703703703707e0 * t1343 * t1268 * t2 * t69 * t16 * t301 - 0.28069190574752095977021869044689336120000000000002e2 * t1396 * t1399 * t508 * t521 + 0.38666484793229621841455657407407407407407407407410e1 * t1396 * t1345 * t1 * t1348 * t476 * t302 + 0.60853820503802469135802469135802469135802469135805e0 * t1396 * t1268 * t2 * t69 * t148 * t301 + r0 * (t1791 + t2215) * t1152 + 0.16430531536026666666666666666666666666666666666667e1 * t32 * t1145 * t1268 * t31 * t10 * t301 + 0.37963457796989083262520100000000000000000000000001e1 * t77 * t1266 * t1345 * t393 * t18 * t302 + 0.18712793716501397318014579363126224080000000000001e2 * t144 * t1343 * t1399 * t4 * t521 + 0.33628562984421328443422044230750587451246067760236e1 * t357 * t1396 / t2237 * t4 * t303 * t2 * t69

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = 0.1e1 + t4
  t6 = t5 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = t5 ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t11 = f.my_piecewise3(t6, t8, t10)
  t12 = 0.1e1 - t4
  t13 = t12 <= f.p.zeta_threshold
  t14 = t12 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t16 = f.my_piecewise3(t13, t8, t15)
  t18 = t11 / 0.2e1 + t16 / 0.2e1
  t19 = t18 ** 2
  t20 = jnp.log(0.2e1)
  t21 = t20 - 0.1e1
  t22 = 0.2e1 * t21
  t23 = t19 * t22
  t24 = jnp.pi ** 2
  t25 = 0.1e1 / t24
  t26 = 3 ** (0.1e1 / 0.3e1)
  t27 = 0.1e1 / jnp.pi
  t28 = t27 ** (0.1e1 / 0.3e1)
  t29 = t26 * t28
  t30 = 4 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = t2 ** (0.1e1 / 0.3e1)
  t33 = 0.1e1 / t32
  t34 = t31 * t33
  t35 = t29 * t34
  t36 = jnp.sqrt(t35)
  t37 = f.p.cam_omega * t36
  t38 = 0.1e1 / t18
  t40 = 0.29230250000000000000000000000000000000000000000000e1 * t37 * t38
  t42 = 9 ** (0.1e1 / 0.3e1)
  t43 = t42 ** 2
  t51 = f.p.cam_omega ** 2
  t52 = (0.344851e1 - jnp.pi * t30 * t43 * t28 / t21 / 0.12e2) * t51
  t53 = t52 * t26
  t54 = t28 * t31
  t55 = 0.1e1 / t19
  t60 = t51 * f.p.cam_omega
  t61 = t36 * t35
  t62 = t60 * t61
  t63 = t19 * t18
  t64 = 0.1e1 / t63
  t67 = 0.1e1 + t40 + t53 * t54 * t33 * t55 / 0.4e1 + 0.48968000000000000000000000000000000000000000000000e0 * t62 * t64
  t68 = t51 * t26
  t69 = t68 * t28
  t73 = 0.1e1 + t40 + 0.86212750000000000000000000000000000000000000000000e0 * t69 * t34 * t55
  t74 = 0.1e1 / t73
  t76 = jnp.log(t67 * t74)
  t77 = t25 * t76
  t78 = 0.1e1 / t9
  t79 = t2 ** 2
  t80 = 0.1e1 / t79
  t81 = t1 * t80
  t82 = t3 - t81
  t85 = f.my_piecewise3(t6, 0, 0.2e1 / 0.3e1 * t78 * t82)
  t86 = 0.1e1 / t14
  t87 = -t82
  t90 = f.my_piecewise3(t13, 0, 0.2e1 / 0.3e1 * t86 * t87)
  t92 = t85 / 0.2e1 + t90 / 0.2e1
  t96 = t63 * t22
  t97 = t96 * t25
  t98 = 0.1e1 / t36
  t99 = f.p.cam_omega * t98
  t100 = t99 * t38
  t102 = 0.1e1 / t32 / t2
  t103 = t31 * t102
  t104 = t29 * t103
  t106 = 0.48717083333333333333333333333333333333333333333333e0 * t100 * t104
  t109 = 0.29230250000000000000000000000000000000000000000000e1 * t37 * t55 * t92
  t113 = t53 * t54 * t102 * t55 / 0.12e2
  t114 = t52 * t29
  t115 = t64 * t92
  t116 = t34 * t115
  t119 = t60 * t36
  t120 = t119 * t64
  t122 = 0.24484000000000000000000000000000000000000000000000e0 * t120 * t104
  t123 = t19 ** 2
  t124 = 0.1e1 / t123
  t128 = -t106 - t109 - t113 - t114 * t116 / 0.2e1 - t122 - 0.14690400000000000000000000000000000000000000000000e1 * t62 * t124 * t92
  t130 = t73 ** 2
  t131 = 0.1e1 / t130
  t132 = t67 * t131
  t135 = 0.28737583333333333333333333333333333333333333333333e0 * t69 * t103 * t55
  t138 = -t106 - t109 - t135 - 0.17242550000000000000000000000000000000000000000000e1 * t69 * t116
  t140 = t128 * t74 - t132 * t138
  t141 = 0.1e1 / t67
  t142 = t140 * t141
  t145 = jnp.sqrt(jnp.pi)
  t147 = 0.1e1 / t145 / jnp.pi
  t148 = t147 * t80
  t149 = t1 ** 2
  t150 = t149 * t80
  t151 = 0.1e1 - t150
  t152 = t148 * t151
  t161 = (0.2e1 / 0.45e2 * t30 * t43 * t28 * (t24 + 0.6e1 * t20 - 0.3e1) * t27 - 0.7524e0) * t26
  t165 = t26 ** 2
  t166 = t28 ** 2
  t167 = t165 * t166
  t168 = t32 ** 2
  t169 = 0.1e1 / t168
  t170 = t30 * t169
  t171 = t167 * t170
  t173 = t27 * t3
  t175 = t28 * t27
  t176 = t26 * t175
  t179 = 0.1e1 - t161 * t54 * t33 / 0.4e1 + 0.20482500000000000000000000000000000000000000000000e-1 * t171 - 0.95775000000000000000000000000000000000000000000000e-2 * t173 + 0.34856250000000000000000000000000000000000000000000e-3 * t176 * t103
  t181 = jnp.exp(-0.18810000000000000000000000000000000000000000000000e0 * t35)
  t182 = t179 * t181
  t183 = jnp.sqrt(0.2e1)
  t184 = t182 * t183
  t186 = 0.17543244109220059985638668152930835075000000000000e0 * t152 * t184
  t187 = t147 * t3
  t188 = t79 * t2
  t189 = 0.1e1 / t188
  t190 = t149 * t189
  t192 = -0.2e1 * t81 + 0.2e1 * t190
  t193 = t187 * t192
  t196 = t187 * t151
  t197 = t54 * t102
  t201 = 0.1e1 / t168 / t2
  t202 = t30 * t201
  t203 = t167 * t202
  t205 = t27 * t80
  t208 = 0.1e1 / t32 / t79
  t209 = t31 * t208
  t212 = t161 * t197 / 0.12e2 - 0.13655000000000000000000000000000000000000000000000e-1 * t203 + 0.95775000000000000000000000000000000000000000000000e-2 * t205 - 0.46475000000000000000000000000000000000000000000000e-3 * t176 * t209
  t213 = t212 * t181
  t214 = t213 * t183
  t216 = 0.17543244109220059985638668152930835075000000000000e0 * t196 * t214
  t217 = t147 * t208
  t218 = t151 * t179
  t222 = t29 * t31 * t181 * t183
  t224 = 0.10999614056480977610995444931887633592025000000000e-1 * t217 * t218 * t222
  t226 = t165 * t166 * t25
  t227 = t226 * t30
  t229 = 0.1e1 / t168 / t79
  t230 = f.p.zeta_threshold ** 2
  t231 = t5 ** 2
  t232 = f.my_piecewise3(t6, t230, t231)
  t233 = t232 * t43
  t235 = 0.1e1 / t175 * t26
  t236 = t233 * t235
  t237 = 0.1e1 / t5
  t238 = t237 ** (0.1e1 / 0.3e1)
  t239 = t238 ** 2
  t240 = 0.1e1 / t239
  t241 = t168 * t240
  t242 = t29 * t31
  t243 = 2 ** (0.1e1 / 0.3e1)
  t244 = t33 * t243
  t246 = t242 * t244 * t238
  t248 = 0.1e1 - 0.56675000000000000000000000000000000000000000000000e-2 * t246
  t250 = t167 * t30
  t251 = t243 ** 2
  t252 = t169 * t251
  t256 = 0.1e1 + 0.10797500000000000000000000000000000000000000000000e0 * t246 + 0.10000000000000000000000000000000000000000000000000e-1 * t250 * t252 * t239
  t257 = 0.1e1 / t256
  t258 = t248 * t257
  t259 = t241 * t258
  t261 = t236 * t259 / 0.30e2
  t262 = t12 ** 2
  t263 = f.my_piecewise3(t13, t230, t262)
  t264 = t263 * t43
  t265 = t264 * t235
  t266 = 0.1e1 / t12
  t267 = t266 ** (0.1e1 / 0.3e1)
  t268 = t267 ** 2
  t269 = 0.1e1 / t268
  t270 = t168 * t269
  t272 = t242 * t244 * t267
  t274 = 0.1e1 - 0.56675000000000000000000000000000000000000000000000e-2 * t272
  t279 = 0.1e1 + 0.10797500000000000000000000000000000000000000000000e0 * t272 + 0.10000000000000000000000000000000000000000000000000e-1 * t250 * t252 * t268
  t280 = 0.1e1 / t279
  t281 = t274 * t280
  t282 = t270 * t281
  t284 = t265 * t282 / 0.30e2
  t287 = -0.12375000000000000000000000000000000000000000000000e1 * t35 + t171 / 0.4e1
  t288 = t151 * t287
  t290 = jnp.exp(-0.77500000000000000000000000000000000000000000000000e-1 * t35)
  t291 = t290 * jnp.pi
  t292 = t291 * t2
  t295 = t261 + t284 + 0.4e1 / 0.3e1 * t288 * t292
  t297 = t183 * t145
  t300 = 0.50668035746616956918102410392313943146408695844103e-2 * t227 * t229 * t295 * t297
  t303 = f.my_piecewise3(t6, 0, 0.2e1 * t5 * t82)
  t304 = t303 * t43
  t305 = t304 * t235
  t307 = t305 * t259 / 0.30e2
  t308 = t33 * t240
  t309 = t308 * t258
  t311 = t236 * t309 / 0.45e2
  t312 = t235 * t168
  t313 = t233 * t312
  t315 = 0.1e1 / t239 / t237
  t316 = t315 * t248
  t317 = 0.1e1 / t231
  t318 = t257 * t317
  t319 = t318 * t82
  t320 = t316 * t319
  t322 = t313 * t320 / 0.45e2
  t323 = t102 * t243
  t325 = t242 * t323 * t238
  t326 = 0.18891666666666666666666666666666666666666666666667e-2 * t325
  t327 = t243 * t240
  t328 = t317 * t82
  t329 = t327 * t328
  t330 = t35 * t329
  t332 = t326 + 0.18891666666666666666666666666666666666666666666667e-2 * t330
  t333 = t332 * t257
  t334 = t241 * t333
  t336 = t236 * t334 / 0.30e2
  t337 = t256 ** 2
  t338 = 0.1e1 / t337
  t339 = t248 * t338
  t340 = 0.35991666666666666666666666666666666666666666666667e-1 * t325
  t342 = t201 * t251
  t345 = 0.66666666666666666666666666666666666666666666666667e-2 * t250 * t342 * t239
  t347 = t251 / t238
  t348 = t347 * t328
  t351 = -t340 - 0.35991666666666666666666666666666666666666666666667e-1 * t330 - t345 - 0.66666666666666666666666666666666666666666666666667e-2 * t171 * t348
  t352 = t339 * t351
  t353 = t241 * t352
  t355 = t236 * t353 / 0.30e2
  t358 = f.my_piecewise3(t13, 0, 0.2e1 * t12 * t87)
  t359 = t358 * t43
  t360 = t359 * t235
  t362 = t360 * t282 / 0.30e2
  t363 = t33 * t269
  t364 = t363 * t281
  t366 = t265 * t364 / 0.45e2
  t367 = t264 * t312
  t369 = 0.1e1 / t268 / t266
  t370 = t369 * t274
  t371 = 0.1e1 / t262
  t372 = t280 * t371
  t373 = t372 * t87
  t374 = t370 * t373
  t376 = t367 * t374 / 0.45e2
  t378 = t242 * t323 * t267
  t379 = 0.18891666666666666666666666666666666666666666666667e-2 * t378
  t380 = t243 * t269
  t381 = t371 * t87
  t382 = t380 * t381
  t383 = t35 * t382
  t385 = t379 + 0.18891666666666666666666666666666666666666666666667e-2 * t383
  t386 = t385 * t280
  t387 = t270 * t386
  t389 = t265 * t387 / 0.30e2
  t390 = t279 ** 2
  t391 = 0.1e1 / t390
  t392 = t274 * t391
  t393 = 0.35991666666666666666666666666666666666666666666667e-1 * t378
  t397 = 0.66666666666666666666666666666666666666666666666667e-2 * t250 * t342 * t268
  t399 = t251 / t267
  t400 = t399 * t381
  t403 = -t393 - 0.35991666666666666666666666666666666666666666666667e-1 * t383 - t397 - 0.66666666666666666666666666666666666666666666666667e-2 * t171 * t400
  t404 = t392 * t403
  t405 = t270 * t404
  t407 = t265 * t405 / 0.30e2
  t408 = t192 * t287
  t413 = 0.41250000000000000000000000000000000000000000000000e0 * t104 - t203 / 0.6e1
  t414 = t151 * t413
  t416 = 0.4e1 / 0.3e1 * t414 * t292
  t417 = t288 * t29
  t418 = t34 * t291
  t420 = 0.34444444444444444444444444444444444444444444444444e-1 * t417 * t418
  t422 = 0.4e1 / 0.3e1 * t288 * t291
  t423 = t307 + t311 + t322 + t336 - t355 + t362 + t366 + t376 + t389 - t407 + 0.4e1 / 0.3e1 * t408 * t292 + t416 + t420 + t422
  t431 = t182 / 0.2e1 - 0.1e1 / 0.2e1 + t150 / 0.2e1
  t432 = t151 * t431
  t434 = 0.26314866163830089978458002229396252612500000000000e0 * t205 * t432
  t435 = t192 * t431
  t438 = t213 / 0.2e1
  t440 = t179 * t26 * t28
  t441 = t103 * t181
  t443 = 0.31350000000000000000000000000000000000000000000000e-1 * t440 * t441
  t444 = t438 + t443 + t81 - t190
  t445 = t151 * t444
  t450 = -0.97000000000000000000000000000000000000000000000000e-1 * t35 + 0.16900000000000000000000000000000000000000000000000e0 * t171
  t451 = t151 * t450
  t453 = jnp.exp(-0.13675000000000000000000000000000000000000000000000e0 * t35)
  t454 = t451 * t453
  t456 = t26 / t166
  t458 = t456 * t31 * t168
  t461 = t8 * t230
  t463 = f.my_piecewise3(t6, t461, t10 * t231)
  t465 = f.my_piecewise3(t13, t461, t15 * t262)
  t468 = (t463 / 0.2e1 + t465 / 0.2e1) * t43
  t471 = t261 + t284 + t454 * t458 / 0.3e1 - t468 * t312 / 0.15e2
  t475 = 0.63335044683271196147628012990392428933010869805128e-2 * t227 * t229 * t471 * jnp.pi
  t476 = t192 * t450
  t477 = t476 * t453
  t482 = 0.32333333333333333333333333333333333333333333333333e-1 * t104 - 0.11266666666666666666666666666666666666666666666667e0 * t203
  t483 = t151 * t482
  t484 = t483 * t453
  t486 = t484 * t458 / 0.3e1
  t491 = 0.1e1 / t28 * t30 * t169 * t453
  t493 = 0.60777777777777777777777777777777777777777777777777e-1 * t451 * t165 * t491
  t494 = t456 * t34
  t496 = 0.2e1 / 0.9e1 * t454 * t494
  t497 = t10 * t5
  t500 = f.my_piecewise3(t6, 0, 0.8e1 / 0.3e1 * t497 * t82)
  t501 = t15 * t12
  t504 = f.my_piecewise3(t13, 0, 0.8e1 / 0.3e1 * t501 * t87)
  t507 = (t500 / 0.2e1 + t504 / 0.2e1) * t43
  t510 = t235 * t33
  t512 = 0.2e1 / 0.45e2 * t468 * t510
  t513 = t307 + t311 + t322 + t336 - t355 + t362 + t366 + t376 + t389 - t407 + t477 * t458 / 0.3e1 + t486 + t493 + t496 - t507 * t312 / 0.15e2 - t512
  t519 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t35
  t522 = t35 ** 0.15e1
  t525 = 0.37978500000000000000000000000000000000000000000000e1 * t36 + 0.89690000000000000000000000000000000000000000000000e0 * t35 + 0.20477500000000000000000000000000000000000000000000e0 * t522 + 0.12323500000000000000000000000000000000000000000000e0 * t171
  t528 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t525
  t529 = jnp.log(t528)
  t531 = 0.621814e-1 * t519 * t529
  t532 = t149 ** 2
  t533 = t79 ** 2
  t534 = 0.1e1 / t533
  t535 = t532 * t534
  t536 = t7 * f.p.zeta_threshold
  t537 = t9 * t5
  t538 = f.my_piecewise3(t6, t536, t537)
  t539 = t14 * t12
  t540 = f.my_piecewise3(t13, t536, t539)
  t544 = 0.1e1 / (0.2e1 * t243 - 0.2e1)
  t545 = (t538 + t540 - 0.2e1) * t544
  t547 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t35
  t552 = 0.70594500000000000000000000000000000000000000000000e1 * t36 + 0.15494250000000000000000000000000000000000000000000e1 * t35 + 0.42077500000000000000000000000000000000000000000000e0 * t522 + 0.15629250000000000000000000000000000000000000000000e0 * t171
  t555 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t552
  t556 = jnp.log(t555)
  t560 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t35
  t565 = 0.51785000000000000000000000000000000000000000000000e1 * t36 + 0.90577500000000000000000000000000000000000000000000e0 * t35 + 0.11003250000000000000000000000000000000000000000000e0 * t522 + 0.12417750000000000000000000000000000000000000000000e0 * t171
  t568 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t565
  t569 = jnp.log(t568)
  t570 = t560 * t569
  t572 = -0.3109070e-1 * t547 * t556 + t531 - 0.19751673498613801407483339618206552048944131217655e-1 * t570
  t573 = t545 * t572
  t577 = -t531 + t535 * t573 + 0.19751673498613801407483339618206552048944131217655e-1 * t545 * t570
  t580 = 0.56945186695483624893780150000000000000000000000000e0 * t176 * t209 * t577
  t583 = 0.11073470983333333333333333333333333333333333333333e-2 * t29 * t103 * t529
  t584 = t525 ** 2
  t585 = 0.1e1 / t584
  t586 = t519 * t585
  t587 = t98 * t26
  t588 = t587 * t197
  t591 = t35 ** 0.5e0
  t592 = t591 * t26
  t593 = t592 * t197
  t596 = -0.63297500000000000000000000000000000000000000000000e0 * t588 - 0.29896666666666666666666666666666666666666666666667e0 * t104 - 0.10238750000000000000000000000000000000000000000000e0 * t593 - 0.82156666666666666666666666666666666666666666666667e-1 * t203
  t597 = 0.1e1 / t528
  t598 = t596 * t597
  t600 = 0.10000000000000000000000000000000000000000000000000e1 * t586 * t598
  t601 = t149 * t1
  t602 = t601 * t534
  t604 = 0.4e1 * t602 * t573
  t606 = 0.1e1 / t533 / t2
  t607 = t532 * t606
  t609 = 0.4e1 * t607 * t573
  t612 = f.my_piecewise3(t6, 0, 0.4e1 / 0.3e1 * t9 * t82)
  t615 = f.my_piecewise3(t13, 0, 0.4e1 / 0.3e1 * t14 * t87)
  t617 = (t612 + t615) * t544
  t618 = t617 * t572
  t623 = t552 ** 2
  t624 = 0.1e1 / t623
  t625 = t547 * t624
  t630 = -0.11765750000000000000000000000000000000000000000000e1 * t588 - 0.51647500000000000000000000000000000000000000000000e0 * t104 - 0.21038750000000000000000000000000000000000000000000e0 * t593 - 0.10419500000000000000000000000000000000000000000000e0 * t203
  t631 = 0.1e1 / t555
  t632 = t630 * t631
  t638 = t565 ** 2
  t639 = 0.1e1 / t638
  t640 = t560 * t639
  t645 = -0.86308333333333333333333333333333333333333333333334e0 * t588 - 0.30192500000000000000000000000000000000000000000000e0 * t104 - 0.55016250000000000000000000000000000000000000000000e-1 * t593 - 0.82785000000000000000000000000000000000000000000000e-1 * t203
  t646 = 0.1e1 / t568
  t647 = t645 * t646
  t650 = 0.53237641966666666666666666666666666666666666666666e-3 * t29 * t103 * t556 + 0.10000000000000000000000000000000000000000000000000e1 * t625 * t632 - t583 - t600 + 0.18311447306006545054854346104378990962041954983034e-3 * t29 * t103 * t569 + 0.58482236226346462072622386637590534819724553404280e0 * t640 * t647
  t651 = t545 * t650
  t652 = t535 * t651
  t655 = t545 * t26
  t657 = t54 * t102 * t569
  t659 = 0.18311447306006545054854346104378990962041954983034e-3 * t655 * t657
  t660 = t545 * t560
  t662 = t639 * t645 * t646
  t664 = 0.58482236226346462072622386637590534819724553404280e0 * t660 * t662
  t665 = t583 + t600 + t604 - t609 + t535 * t618 + t652 + 0.19751673498613801407483339618206552048944131217655e-1 * t617 * t570 - t659 - t664
  t670 = t51 ** 2
  t672 = t30 * t229
  t674 = t226 * t672 * t151
  t675 = t670 * f.p.cam_omega
  t676 = t297 * t675
  t677 = t182 * t676
  t679 = 0.11259563499248212648467202309403098476979710187578e-1 * t674 * t677
  t681 = t226 * t202 * t192
  t685 = t226 * t202 * t151
  t686 = t213 * t676
  t688 = 0.67557380995489275890803213856418590861878261125470e-2 * t685 * t686
  t690 = 0.1e1 / t145 / t24
  t691 = t690 * t189
  t692 = t691 * t151
  t693 = t183 * t675
  t694 = t182 * t693
  t696 = 0.50830173461006131180240338105569347764477203670804e-2 * t692 * t694
  t697 = t229 * t151
  t698 = t431 * jnp.pi
  t701 = 0.16889345248872318972700803464104647715469565281367e-1 * t227 * t697 * t698
  t702 = t201 * t192
  t706 = t201 * t151
  t707 = t444 * jnp.pi
  t711 = t25 * t189
  t713 = 0.10525946465532035991383200891758501045000000000000e1 * t711 * t577
  t714 = t25 * t80
  t718 = t670 * t51
  t721 = 0.1e1 / t168 / t188
  t723 = t670 ** 2
  t726 = 0.54045904796391420712642571085134872689502608900376e-1 * t227 * t721 * t577 * t723
  t731 = 0.3e1 * t23 * t77 * t92 + t97 * t142 * t73 + (t186 - 0.17543244109220059985638668152930835075000000000000e0 * t193 * t184 - t216 - t224 + t300 - 0.30400821447970174150861446235388365887845217506462e-2 * t227 * t201 * t423 * t297) * t60 + (t434 - 0.26314866163830089978458002229396252612500000000000e0 * t173 * t435 - 0.26314866163830089978458002229396252612500000000000e0 * t173 * t445 + t475 - 0.38001026809962717688576807794235457359806521883077e-2 * t227 * t201 * t513 * jnp.pi - t580 + 0.42708890021612718670335112500000000000000000000000e0 * t176 * t103 * t665) * t670 + t679 - 0.67557380995489275890803213856418590861878261125470e-2 * t681 * t677 - t688 - t696 + (t701 - 0.10133607149323391383620482078462788629281739168820e-1 * t227 * t702 * t698 - 0.10133607149323391383620482078462788629281739168820e-1 * t227 * t706 * t707 - t713 + 0.52629732327660179956916004458792505225000000000000e0 * t714 * t665) * t718 - t726 + 0.20267214298646782767240964156925577258563478337641e-1 * t227 * t229 * t665 * t723
  t735 = 0.1e1 + 0.15403623315025000000000000000000000000000000000000e0 * t167 * t170 * t51
  t736 = t735 ** 2
  t737 = t736 ** 2
  t738 = 0.1e1 / t737
  t739 = t731 * t738
  t774 = t96 * t77 + (-0.17543244109220059985638668152930835075000000000000e0 * t196 * t184 - 0.30400821447970174150861446235388365887845217506462e-2 * t227 * t201 * t295 * t297) * t60 + (-0.26314866163830089978458002229396252612500000000000e0 * t173 * t432 - 0.38001026809962717688576807794235457359806521883077e-2 * t227 * t201 * t471 * jnp.pi + 0.42708890021612718670335112500000000000000000000000e0 * t176 * t103 * t577) * t670 - 0.67557380995489275890803213856418590861878261125470e-2 * t685 * t677 + (-0.10133607149323391383620482078462788629281739168820e-1 * t227 * t706 * t698 + 0.52629732327660179956916004458792505225000000000000e0 * t714 * t577) * t718 + 0.20267214298646782767240964156925577258563478337641e-1 * t227 * t229 * t577 * t723
  t776 = 0.1e1 / t737 / t735
  t779 = t166 * t30
  t783 = 0.13692109613355555555555555555555555555555555555556e0 * t774 * t776 * t165 * t779 * t201 * t51
  t787 = 0.23720747615136194550778824449265695623422695046375e-1 * t690 * t534 * t151 * t694
  t789 = t691 * t192 * t694
  t793 = 0.10166034692201226236048067621113869552895440734161e-1 * t692 * t213 * t693
  t797 = 0.45038253996992850593868809237612393907918840750312e-1 * t227 * t721 * t151 * t698
  t800 = t227 * t229 * t192 * t698
  t803 = t227 * t697 * t707
  t805 = 0.2e1 * t80
  t806 = t1 * t189
  t807 = 0.8e1 * t806
  t808 = t149 * t534
  t809 = 0.6e1 * t808
  t810 = -t805 + t807 - t809
  t818 = t54 * t208
  t821 = t167 * t672
  t823 = t27 * t189
  t826 = 0.1e1 / t32 / t188
  t827 = t31 * t826
  t831 = (-t161 * t818 / 0.9e1 + 0.22758333333333333333333333333333333333333333333333e-1 * t821 - 0.19155000000000000000000000000000000000000000000000e-1 * t823 + 0.10844166666666666666666666666666666666666666666667e-2 * t176 * t827) * t181
  t832 = t831 / 0.2e1
  t836 = 0.62700000000000000000000000000000000000000000000000e-1 * t212 * t26 * t28 * t441
  t839 = 0.41800000000000000000000000000000000000000000000000e-1 * t440 * t209 * t181
  t844 = 0.78625800000000000000000000000000000000000000000000e-2 * t179 * t165 * t166 * t672 * t181
  t845 = 0.4e1 * t806
  t846 = 0.3e1 * t808
  t847 = t832 + t836 - t839 + t844 + t80 - t845 + t846
  t854 = 0.31577839396596107974149602675275503135000000000000e1 * t25 * t534 * t577
  t855 = t711 * t665
  t858 = t617 * t26 * t657
  t861 = 0.1e1 / t638 / t565
  t862 = t645 ** 2
  t866 = 0.11696447245269292414524477327518106963944910680856e1 * t660 * t861 * t862 * t646
  t870 = 0.35616666666666666666666666666666666666666666666666e-1 * t242 * t102 * t585 * t598
  t873 = 0.14764627977777777777777777777777777777777777777777e-2 * t29 * t209 * t529
  t874 = t584 ** 2
  t877 = t596 ** 2
  t878 = t528 ** 2
  t882 = 0.16081979498692535066756296899072713062105388428051e2 * t519 / t874 * t877 / t878
  t883 = 0.1e1 / t61
  t885 = t779 * t229
  t886 = t883 * t165 * t885
  t888 = t587 * t818
  t890 = t29 * t209
  t892 = t35 ** (-0.5e0)
  t894 = t892 * t165 * t885
  t896 = t592 * t818
  t902 = 0.10000000000000000000000000000000000000000000000000e1 * t586 * (-0.42198333333333333333333333333333333333333333333333e0 * t886 + 0.84396666666666666666666666666666666666666666666666e0 * t888 + 0.39862222222222222222222222222222222222222222222223e0 * t890 + 0.68258333333333333333333333333333333333333333333333e-1 * t894 + 0.13651666666666666666666666666666666666666666666667e0 * t896 + 0.13692777777777777777777777777777777777777777777778e0 * t821) * t597
  t906 = 0.10843581300301739842632067522386578331157260943710e-1 * t545 * t29 * t103 * t662
  t907 = 0.1e1 / t10
  t908 = t82 ** 2
  t912 = -0.2e1 * t80 + 0.2e1 * t806
  t916 = f.my_piecewise3(t6, 0, 0.4e1 / 0.9e1 * t907 * t908 + 0.4e1 / 0.3e1 * t9 * t912)
  t917 = 0.1e1 / t15
  t918 = t87 ** 2
  t921 = -t912
  t925 = f.my_piecewise3(t13, 0, 0.4e1 / 0.9e1 * t917 * t918 + 0.4e1 / 0.3e1 * t14 * t921)
  t927 = (t916 + t925) * t544
  t934 = 0.20e2 * t532 / t533 / t79 * t573
  t936 = 0.12e2 * t808 * t573
  t939 = 0.32e2 * t601 * t606 * t573
  t940 = -0.36622894612013090109708692208757981924083909966068e-3 * t858 + t866 - t870 - t873 + t882 + t902 + t906 + 0.19751673498613801407483339618206552048944131217655e-1 * t927 * t570 + t934 + t936 - t939
  t944 = 0.24415263074675393406472461472505321282722606644045e-3 * t655 * t54 * t208 * t569
  t950 = 0.20000000000000000000000000000000000000000000000000e1 * t519 / t584 / t525 * t877 * t597
  t952 = t617 * t560 * t662
  t960 = -0.57538888888888888888888888888888888888888888888889e0 * t886 + 0.11507777777777777777777777777777777777777777777778e1 * t888 + 0.40256666666666666666666666666666666666666666666667e0 * t890 + 0.36677500000000000000000000000000000000000000000000e-1 * t894 + 0.73355000000000000000000000000000000000000000000000e-1 * t896 + 0.13797500000000000000000000000000000000000000000000e0 * t821
  t964 = 0.58482236226346462072622386637590534819724553404280e0 * t660 * t639 * t960 * t646
  t965 = t638 ** 2
  t966 = 0.1e1 / t965
  t968 = t568 ** 2
  t969 = 0.1e1 / t968
  t972 = 0.17315859105681463759666483083807725165579399831905e2 * t660 * t966 * t862 * t969
  t973 = t602 * t618
  t976 = 0.8e1 * t602 * t651
  t977 = t607 * t618
  t980 = 0.8e1 * t607 * t651
  t984 = t535 * t617 * t650
  t996 = t630 ** 2
  t1010 = t623 ** 2
  t1013 = t555 ** 2
  t1036 = -0.70983522622222222222222222222222222222222222222221e-3 * t29 * t209 * t556 - 0.34246666666666666666666666666666666666666666666666e-1 * t242 * t102 * t624 * t632 - 0.20000000000000000000000000000000000000000000000000e1 * t547 / t623 / t552 * t996 * t631 + 0.10000000000000000000000000000000000000000000000000e1 * t625 * (-0.78438333333333333333333333333333333333333333333333e0 * t886 + 0.15687666666666666666666666666666666666666666666667e1 * t888 + 0.68863333333333333333333333333333333333333333333333e0 * t890 + 0.14025833333333333333333333333333333333333333333333e0 * t894 + 0.28051666666666666666666666666666666666666666666667e0 * t896 + 0.17365833333333333333333333333333333333333333333333e0 * t821) * t631 + 0.32163958997385070133512593798145426124210776856102e2 * t547 / t1010 * t996 / t1013 + t873 + t870 + t950 - t902 - t882 - 0.24415263074675393406472461472505321282722606644045e-3 * t29 * t209 * t569 - 0.10843581300301739842632067522386578331157260943710e-1 * t242 * t102 * t639 * t647 - 0.11696447245269292414524477327518106963944910680856e1 * t560 * t861 * t862 * t646 + 0.58482236226346462072622386637590534819724553404280e0 * t640 * t960 * t646 + 0.17315859105681463759666483083807725165579399831905e2 * t560 * t966 * t862 * t969
  t1038 = t535 * t545 * t1036
  t1039 = t944 - t950 - 0.11696447245269292414524477327518106963944910680856e1 * t952 - t964 - t972 + 0.8e1 * t973 + t976 - 0.8e1 * t977 - t980 + t535 * t927 * t572 + 0.2e1 * t984 + t1038
  t1040 = t940 + t1039
  t1046 = 0.52629732327660179956916004458792505225000000000000e0 * t823 * t432
  t1047 = t205 * t435
  t1049 = t205 * t445
  t1063 = 0.16889345248872318972700803464104647715469565281367e-1 * t227 * t721 * t471 * jnp.pi
  t1066 = t227 * t229 * t513 * jnp.pi
  t1068 = t370 * t391
  t1072 = 0.2e1 / 0.45e2 * t367 * t1068 * t381 * t403
  t1073 = t316 * t338
  t1077 = 0.2e1 / 0.45e2 * t313 * t1073 * t328 * t351
  t1080 = 0.33245444444444444444444444444444444444444444444444e-1 * t451 * t80 * t453
  t1081 = t264 * t510
  t1082 = t1081 * t374
  t1083 = 0.4e1 / 0.135e3 * t1082
  t1084 = t369 * t385
  t1087 = 0.2e1 / 0.45e2 * t367 * t1084 * t373
  t1091 = t367 * t370 * t372 * t921 / 0.45e2
  t1094 = 0.1e1 / t268 / t371 * t274
  t1095 = t262 ** 2
  t1096 = 0.1e1 / t1095
  t1097 = t280 * t1096
  t1101 = t367 * t1094 * t1097 * t918 / 0.27e2
  t1102 = t233 * t510
  t1103 = t1102 * t320
  t1104 = 0.4e1 / 0.135e3 * t1103
  t1105 = t315 * t332
  t1108 = 0.2e1 / 0.45e2 * t313 * t1105 * t319
  t1112 = t313 * t316 * t318 * t912 / 0.45e2
  t1115 = 0.1e1 / t239 / t317 * t248
  t1116 = t231 ** 2
  t1117 = 0.1e1 / t1116
  t1118 = t257 * t1117
  t1122 = t313 * t1115 * t1118 * t908 / 0.27e2
  t1123 = t304 * t312
  t1125 = 0.2e1 / 0.45e2 * t1123 * t320
  t1126 = -t1072 - t1077 + t1080 + t1083 + t1087 + t1091 + t1101 + t1104 + t1108 + t1112 + t1122 + t1125
  t1128 = 0.1e1 / t262 / t12
  t1129 = t280 * t1128
  t1133 = 0.2e1 / 0.45e2 * t367 * t370 * t1129 * t918
  t1135 = 0.1e1 / t231 / t5
  t1136 = t257 * t1135
  t1140 = 0.2e1 / 0.45e2 * t313 * t316 * t1136 * t908
  t1141 = t359 * t312
  t1143 = 0.2e1 / 0.45e2 * t1141 * t374
  t1144 = t208 * t243
  t1146 = t242 * t1144 * t267
  t1147 = 0.47988888888888888888888888888888888888888888888889e-1 * t1146
  t1148 = t104 * t382
  t1150 = t243 * t369
  t1151 = t1096 * t918
  t1153 = t35 * t1150 * t1151
  t1155 = t1128 * t918
  t1157 = t35 * t380 * t1155
  t1159 = t371 * t921
  t1161 = t35 * t380 * t1159
  t1163 = t229 * t251
  t1166 = 0.11111111111111111111111111111111111111111111111111e-1 * t250 * t1163 * t268
  t1167 = t203 * t400
  t1171 = t251 / t267 / t266
  t1185 = t265 * t270 * t392 * (t1147 + 0.23994444444444444444444444444444444444444444444444e-1 * t1148 - 0.23994444444444444444444444444444444444444444444445e-1 * t1153 + 0.71983333333333333333333333333333333333333333333334e-1 * t1157 - 0.35991666666666666666666666666666666666666666666667e-1 * t1161 + t1166 + 0.88888888888888888888888888888888888888888888888890e-2 * t1167 - 0.22222222222222222222222222222222222222222222222222e-2 * t171 * t1171 * t1151 + 0.13333333333333333333333333333333333333333333333333e-1 * t171 * t399 * t1155 - 0.66666666666666666666666666666666666666666666666667e-2 * t171 * t399 * t1159) / 0.30e2
  t1187 = t360 * t405 / 0.15e2
  t1189 = 0.1e1 / t390 / t279
  t1190 = t274 * t1189
  t1191 = t403 ** 2
  t1195 = t265 * t270 * t1190 * t1191 / 0.15e2
  t1197 = 0.1e1 / t337 / t256
  t1198 = t248 * t1197
  t1199 = t351 ** 2
  t1203 = t236 * t241 * t1198 * t1199 / 0.15e2
  t1204 = t385 * t391
  t1208 = t265 * t270 * t1204 * t403 / 0.15e2
  t1214 = f.my_piecewise3(t6, 0, 0.40e2 / 0.9e1 * t10 * t908 + 0.8e1 / 0.3e1 * t497 * t912)
  t1220 = f.my_piecewise3(t13, 0, 0.40e2 / 0.9e1 * t15 * t918 + 0.8e1 / 0.3e1 * t501 * t921)
  t1226 = t507 * t510
  t1230 = 0.2e1 / 0.135e3 * t468 * t235 * t102
  t1231 = 0.25188888888888888888888888888888888888888888888889e-2 * t1146
  t1240 = t265 * t270 * (-t1231 - 0.12594444444444444444444444444444444444444444444445e-2 * t1148 + 0.12594444444444444444444444444444444444444444444445e-2 * t1153 - 0.37783333333333333333333333333333333333333333333334e-2 * t1157 + 0.18891666666666666666666666666666666666666666666667e-2 * t1161) * t280 / 0.30e2
  t1241 = -t1133 - t1140 + t1143 - t1185 - t1187 + t1195 + t1203 - t1208 - (t1214 / 0.2e1 + t1220 / 0.2e1) * t43 * t312 / 0.15e2 - 0.4e1 / 0.45e2 * t1226 + t1230 + t1240
  t1243 = t305 * t309
  t1244 = 0.2e1 / 0.45e2 * t1243
  t1246 = t305 * t334 / 0.15e2
  t1248 = t236 * t308 * t333
  t1249 = 0.2e1 / 0.45e2 * t1248
  t1251 = t242 * t1144 * t238
  t1252 = 0.25188888888888888888888888888888888888888888888889e-2 * t1251
  t1253 = t104 * t329
  t1255 = t243 * t315
  t1256 = t1117 * t908
  t1258 = t35 * t1255 * t1256
  t1260 = t1135 * t908
  t1262 = t35 * t327 * t1260
  t1264 = t317 * t912
  t1266 = t35 * t327 * t1264
  t1272 = t236 * t241 * (-t1252 - 0.12594444444444444444444444444444444444444444444445e-2 * t1253 + 0.12594444444444444444444444444444444444444444444445e-2 * t1258 - 0.37783333333333333333333333333333333333333333333334e-2 * t1262 + 0.18891666666666666666666666666666666666666666666667e-2 * t1266) * t257 / 0.30e2
  t1276 = f.my_piecewise3(t13, 0, 0.2e1 * t12 * t921 + 0.2e1 * t918)
  t1280 = t1276 * t43 * t235 * t282 / 0.30e2
  t1282 = t360 * t387 / 0.15e2
  t1284 = t265 * t363 * t386
  t1285 = 0.2e1 / 0.45e2 * t1284
  t1289 = t265 * t102 * t269 * t281 / 0.135e3
  t1290 = t360 * t364
  t1291 = 0.2e1 / 0.45e2 * t1290
  t1295 = t236 * t102 * t240 * t258 / 0.135e3
  t1299 = f.my_piecewise3(t6, 0, 0.2e1 * t5 * t912 + 0.2e1 * t908)
  t1303 = t1299 * t43 * t235 * t259 / 0.30e2
  t1305 = 0.4e1 / 0.9e1 * t484 * t494
  t1306 = t1244 + t1246 + t1249 + t1272 + t1280 + t1282 + t1285 - t1289 + t1291 - t1295 + t1303 + t1305
  t1309 = 0.2e1 / 0.27e2 * t454 * t456 * t103
  t1316 = t192 * t482 * t453 * t458
  t1319 = t476 * t165 * t491
  t1327 = t151 * (-0.43111111111111111111111111111111111111111111111111e-1 * t890 + 0.18777777777777777777777777777777777777777777777778e0 * t821) * t453 * t458 / 0.3e1
  t1330 = 0.12155555555555555555555555555555555555555555555555e0 * t483 * t165 * t491
  t1331 = t477 * t494
  t1334 = t265 * t363 * t404
  t1335 = 0.2e1 / 0.45e2 * t1334
  t1336 = 0.47988888888888888888888888888888888888888888888889e-1 * t1251
  t1343 = 0.11111111111111111111111111111111111111111111111111e-1 * t250 * t1163 * t239
  t1344 = t203 * t348
  t1348 = t251 / t238 / t237
  t1362 = t236 * t241 * t339 * (t1336 + 0.23994444444444444444444444444444444444444444444444e-1 * t1253 - 0.23994444444444444444444444444444444444444444444445e-1 * t1258 + 0.71983333333333333333333333333333333333333333333334e-1 * t1262 - 0.35991666666666666666666666666666666666666666666667e-1 * t1266 + t1343 + 0.88888888888888888888888888888888888888888888888890e-2 * t1344 - 0.22222222222222222222222222222222222222222222222222e-2 * t171 * t1348 * t1256 + 0.13333333333333333333333333333333333333333333333333e-1 * t171 * t347 * t1260 - 0.66666666666666666666666666666666666666666666666667e-2 * t171 * t347 * t1264) / 0.30e2
  t1364 = t236 * t308 * t352
  t1365 = 0.2e1 / 0.45e2 * t1364
  t1366 = t332 * t338
  t1370 = t236 * t241 * t1366 * t351 / 0.15e2
  t1372 = t305 * t353 / 0.15e2
  t1373 = -t1309 + t810 * t450 * t453 * t458 / 0.3e1 + 0.2e1 / 0.3e1 * t1316 + 0.12155555555555555555555555555555555555555555555555e0 * t1319 + t1327 + t1330 + 0.4e1 / 0.9e1 * t1331 - t1335 - t1362 - t1365 - t1370 - t1372
  t1382 = 0.13287210228946179141882035000000000000000000000000e1 * t176 * t827 * t577
  t1384 = t176 * t209 * t665
  t1389 = -t1046 + 0.52629732327660179956916004458792505225000000000000e0 * t1047 + 0.52629732327660179956916004458792505225000000000000e0 * t1049 - 0.26314866163830089978458002229396252612500000000000e0 * t173 * t810 * t431 - 0.52629732327660179956916004458792505225000000000000e0 * t173 * t192 * t444 - 0.26314866163830089978458002229396252612500000000000e0 * t173 * t151 * t847 - t1063 + 0.12667008936654239229525602598078485786602173961026e-1 * t1066 - 0.38001026809962717688576807794235457359806521883077e-2 * t227 * t201 * (t1126 + t1241 + t1306 + t1373) * jnp.pi + t1382 - 0.11389037339096724978756030000000000000000000000000e1 * t1384 + 0.42708890021612718670335112500000000000000000000000e0 * t176 * t103 * t1040
  t1394 = 0.35086488218440119971277336305861670150000000000000e0 * t147 * t189 * t151 * t184
  t1396 = t148 * t192 * t184
  t1399 = 0.35086488218440119971277336305861670150000000000000e0 * t152 * t214
  t1403 = 0.36665380188269925369984816439625445306750000000000e-1 * t147 * t826 * t218 * t222
  t1407 = t193 * t214
  t1411 = t217 * t192 * t179 * t222
  t1415 = 0.17543244109220059985638668152930835075000000000000e0 * t196 * t831 * t183
  t1419 = 0.21999228112961955221990889863775267184050000000000e-1 * t217 * t151 * t212 * t222
  t1426 = 0.27587032053654291848376575889174185048798700000000e-2 * t147 * t721 * t218 * t167 * t30 * t181 * t183
  t1430 = 0.13511476199097855178160642771283718172375652225094e-1 * t227 * t721 * t295 * t297
  t1433 = t227 * t229 * t423 * t297
  t1439 = t192 * t413 * t292
  t1446 = 0.4e1 / 0.3e1 * t151 * (-0.55000000000000000000000000000000000000000000000000e0 * t890 + 0.5e1 / 0.18e2 * t821) * t292
  t1448 = t408 * t29 * t418
  t1452 = 0.68888888888888888888888888888888888888888888888888e-1 * t414 * t29 * t418
  t1456 = 0.35592592592592592592592592592592592592592592592591e-2 * t288 * t167 * t202 * t291
  t1459 = 0.22962962962962962962962962962962962962962962962963e-1 * t417 * t103 * t291
  t1461 = 0.8e1 / 0.3e1 * t414 * t291
  t1462 = t408 * t291
  t1464 = 0.4e1 / 0.3e1 * t810 * t287 * t292 + 0.8e1 / 0.3e1 * t1439 + t1446 - t1072 - t1077 + 0.68888888888888888888888888888888888888888888888888e-1 * t1448 + t1452 + t1456 + t1459 + t1461 + 0.8e1 / 0.3e1 * t1462
  t1465 = t1083 + t1087 + t1091 + t1101 + t1104 + t1108 + t1112 + t1122 + t1125 - t1133 - t1140
  t1467 = t1143 - t1185 - t1187 + t1195 + t1203 - t1208 + t1240 + t1244 + t1246 + t1249 + t1272
  t1468 = t1280 + t1282 + t1285 - t1289 + t1291 - t1295 + t1303 - t1335 - t1362 - t1365 - t1370 - t1372
  t1475 = -t1394 + 0.35086488218440119971277336305861670150000000000000e0 * t1396 + t1399 + t1403 - 0.17543244109220059985638668152930835075000000000000e0 * t187 * t810 * t184 - 0.35086488218440119971277336305861670150000000000000e0 * t1407 - 0.21999228112961955221990889863775267184050000000000e-1 * t1411 - t1415 - t1419 - t1426 - t1430 + 0.10133607149323391383620482078462788629281739168821e-1 * t1433 - 0.30400821447970174150861446235388365887845217506462e-2 * t227 * t201 * (t1464 + t1465 + t1467 + t1468) * t297
  t1477 = t30 * t721
  t1481 = 0.30025502664661900395912539491741595938612560500208e-1 * t226 * t1477 * t151 * t677
  t1484 = t18 * t22
  t1485 = t92 ** 2
  t1492 = 0.32478055555555555555555555555555555555555555555555e0 * f.p.cam_omega * t883 * t38 * t821
  t1496 = t54 * t102 * t92
  t1497 = t99 * t55 * t26 * t1496
  t1498 = 0.97434166666666666666666666666666666666666666666666e0 * t1497
  t1500 = 0.64956111111111111111111111111111111111111111111111e0 * t100 * t890
  t1503 = 0.58460500000000000000000000000000000000000000000000e1 * t37 * t64 * t1485
  t1504 = 0.1e1 / t537
  t1510 = f.my_piecewise3(t6, 0, -0.2e1 / 0.9e1 * t1504 * t908 + 0.2e1 / 0.3e1 * t78 * t912)
  t1511 = 0.1e1 / t539
  t1517 = f.my_piecewise3(t13, 0, -0.2e1 / 0.9e1 * t1511 * t918 + 0.2e1 / 0.3e1 * t86 * t921)
  t1519 = t1510 / 0.2e1 + t1517 / 0.2e1
  t1522 = 0.29230250000000000000000000000000000000000000000000e1 * t37 * t55 * t1519
  t1526 = t53 * t54 * t208 * t55 / 0.9e1
  t1527 = t103 * t115
  t1528 = t114 * t1527
  t1531 = t34 * t124 * t1485
  t1535 = t34 * t64 * t1519
  t1541 = 0.16322666666666666666666666666666666666666666666667e0 * t60 * t98 * t64 * t821
  t1544 = t119 * t124 * t26 * t1496
  t1547 = 0.32645333333333333333333333333333333333333333333333e0 * t120 * t890
  t1549 = 0.1e1 / t123 / t18
  t1556 = -t1492 + t1498 + t1500 + t1503 - t1522 + t1526 + t1528 / 0.3e1 + 0.3e1 / 0.2e1 * t114 * t1531 - t114 * t1535 / 0.2e1 + t1541 + 0.14690400000000000000000000000000000000000000000000e1 * t1544 + t1547 + 0.58761600000000000000000000000000000000000000000000e1 * t62 * t1549 * t1485 - 0.14690400000000000000000000000000000000000000000000e1 * t62 * t124 * t1519
  t1558 = t128 * t131
  t1563 = t67 / t130 / t73
  t1564 = t138 ** 2
  t1569 = 0.38316777777777777777777777777777777777777777777777e0 * t69 * t209 * t55
  t1570 = t69 * t1527
  t1584 = 0.67557380995489275890803213856418590861878261125470e-2 * t685 * t831 * t676
  t1585 = t787 - 0.10166034692201226236048067621113869552895440734161e-1 * t789 - t793 + (-t797 + 0.33778690497744637945401606928209295430939130562734e-1 * t800 + 0.33778690497744637945401606928209295430939130562734e-1 * t803 - 0.10133607149323391383620482078462788629281739168820e-1 * t227 * t201 * t810 * t698 - 0.20267214298646782767240964156925577258563478337640e-1 * t227 * t702 * t707 - 0.10133607149323391383620482078462788629281739168820e-1 * t227 * t706 * t847 * jnp.pi + t854 - 0.21051892931064071982766401783517002090000000000000e1 * t855 + 0.52629732327660179956916004458792505225000000000000e0 * t714 * t1040) * t718 + t1389 * t670 + t1475 * t60 - t1481 + t97 * t142 * t138 + 0.6e1 * t1484 * t77 * t1485 + t97 * (t1556 * t74 - 0.2e1 * t1558 * t138 + 0.2e1 * t1563 * t1564 - t132 * (-t1492 + t1498 + t1500 + t1503 - t1522 + t1569 + 0.11495033333333333333333333333333333333333333333333e1 * t1570 + 0.51727650000000000000000000000000000000000000000000e1 * t69 * t1531 - 0.17242550000000000000000000000000000000000000000000e1 * t69 * t1535)) * t141 * t73 - t1584
  t1595 = 0.31870518760050844250010691992191981048327206701594e-3 * t690 / t32 / t533 * t218 * t26 * t54 * t181 * t183 * t675
  t1598 = t226 * t672 * t192 * t677
  t1601 = 0.22519126998496425296934404618806196953959420375156e-1 * t674 * t686
  t1606 = t681 * t686
  t1617 = t227 * t721 * t665 * t723
  t1624 = 0.19816831758676854261302276064549453319484289930138e0 * t227 / t168 / t533 * t577 * t723
  t1625 = t67 ** 2
  t1626 = 0.1e1 / t1625
  t1628 = t73 * t128
  t1631 = t23 * t25
  t1632 = t73 * t92
  t1636 = -t1595 + 0.22519126998496425296934404618806196953959420375156e-1 * t1598 + t1601 - 0.67557380995489275890803213856418590861878261125470e-2 * t226 * t202 * t810 * t677 - 0.13511476199097855178160642771283718172375652225094e-1 * t1606 + 0.3e1 * t23 * t77 * t1519 + 0.20267214298646782767240964156925577258563478337641e-1 * t227 * t229 * t1040 * t723 - 0.10809180959278284142528514217026974537900521780075e0 * t1617 + t1624 - t97 * t140 * t1626 * t1628 + 0.6e1 * t1631 * t142 * t1632
  t1643 = t167 * t30 * t51
  t1644 = t169 * t731 * t776 * t1643
  t1653 = 0.63272429661648472104200166666666666666666666666669e0 * t208 * t774 / t737 / t736 * t176 * t31 * t670
  d11 = 0.2e1 * t739 + t783 + t2 * (t1585 + t1636) * t738 + 0.82152657680133333333333333333333333333333333333336e0 * t1644 + t1653
  t1654 = -t3 - t81
  t1657 = f.my_piecewise3(t6, 0, 0.2e1 / 0.3e1 * t78 * t1654)
  t1658 = -t1654
  t1661 = f.my_piecewise3(t13, 0, 0.2e1 / 0.3e1 * t86 * t1658)
  t1663 = t1657 / 0.2e1 + t1661 / 0.2e1
  t1667 = t55 * t1663
  t1669 = 0.29230250000000000000000000000000000000000000000000e1 * t37 * t1667
  t1670 = t64 * t1663
  t1671 = t34 * t1670
  t1674 = t124 * t1663
  t1677 = -t106 - t1669 - t113 - t114 * t1671 / 0.2e1 - t122 - 0.14690400000000000000000000000000000000000000000000e1 * t62 * t1674
  t1681 = -t106 - t1669 - t135 - 0.17242550000000000000000000000000000000000000000000e1 * t69 * t1671
  t1683 = -t132 * t1681 + t1677 * t74
  t1684 = t1683 * t141
  t1688 = 0.2e1 * t81 + 0.2e1 * t190
  t1689 = t187 * t1688
  t1694 = f.my_piecewise3(t6, 0, 0.2e1 * t5 * t1654)
  t1695 = t1694 * t43
  t1696 = t1695 * t235
  t1698 = t1696 * t259 / 0.30e2
  t1699 = t318 * t1654
  t1700 = t316 * t1699
  t1702 = t313 * t1700 / 0.45e2
  t1703 = t317 * t1654
  t1704 = t327 * t1703
  t1705 = t35 * t1704
  t1707 = t326 + 0.18891666666666666666666666666666666666666666666667e-2 * t1705
  t1708 = t1707 * t257
  t1709 = t241 * t1708
  t1711 = t236 * t1709 / 0.30e2
  t1713 = t347 * t1703
  t1716 = -t340 - 0.35991666666666666666666666666666666666666666666667e-1 * t1705 - t345 - 0.66666666666666666666666666666666666666666666666667e-2 * t171 * t1713
  t1717 = t339 * t1716
  t1718 = t241 * t1717
  t1720 = t236 * t1718 / 0.30e2
  t1723 = f.my_piecewise3(t13, 0, 0.2e1 * t12 * t1658)
  t1724 = t1723 * t43
  t1725 = t1724 * t235
  t1727 = t1725 * t282 / 0.30e2
  t1728 = t372 * t1658
  t1729 = t370 * t1728
  t1731 = t367 * t1729 / 0.45e2
  t1732 = t371 * t1658
  t1733 = t380 * t1732
  t1734 = t35 * t1733
  t1736 = t379 + 0.18891666666666666666666666666666666666666666666667e-2 * t1734
  t1737 = t1736 * t280
  t1738 = t270 * t1737
  t1740 = t265 * t1738 / 0.30e2
  t1742 = t399 * t1732
  t1745 = -t393 - 0.35991666666666666666666666666666666666666666666667e-1 * t1734 - t397 - 0.66666666666666666666666666666666666666666666666667e-2 * t171 * t1742
  t1746 = t392 * t1745
  t1747 = t270 * t1746
  t1749 = t265 * t1747 / 0.30e2
  t1750 = t1688 * t287
  t1753 = t1698 + t311 + t1702 + t1711 - t1720 + t1727 + t366 + t1731 + t1740 - t1749 + 0.4e1 / 0.3e1 * t1750 * t292 + t416 + t420 + t422
  t1760 = t1688 * t431
  t1763 = t438 + t443 - t81 - t190
  t1764 = t151 * t1763
  t1767 = t1688 * t450
  t1768 = t1767 * t453
  t1773 = f.my_piecewise3(t6, 0, 0.8e1 / 0.3e1 * t497 * t1654)
  t1776 = f.my_piecewise3(t13, 0, 0.8e1 / 0.3e1 * t501 * t1658)
  t1779 = (t1773 / 0.2e1 + t1776 / 0.2e1) * t43
  t1782 = t1698 + t311 + t1702 + t1711 - t1720 + t1727 + t366 + t1731 + t1740 - t1749 + t1768 * t458 / 0.3e1 + t486 + t493 + t496 - t1779 * t312 / 0.15e2 - t512
  t1789 = f.my_piecewise3(t6, 0, 0.4e1 / 0.3e1 * t9 * t1654)
  t1792 = f.my_piecewise3(t13, 0, 0.4e1 / 0.3e1 * t14 * t1658)
  t1794 = (t1789 + t1792) * t544
  t1795 = t1794 * t572
  t1799 = t583 + t600 - t604 - t609 + t535 * t1795 + t652 + 0.19751673498613801407483339618206552048944131217655e-1 * t1794 * t570 - t659 - t664
  t1806 = t226 * t202 * t1688
  t1809 = t201 * t1688
  t1813 = t1763 * jnp.pi
  t1825 = 0.3e1 * t23 * t77 * t1663 + t97 * t1684 * t73 + (t186 - 0.17543244109220059985638668152930835075000000000000e0 * t1689 * t184 - t216 - t224 + t300 - 0.30400821447970174150861446235388365887845217506462e-2 * t227 * t201 * t1753 * t297) * t60 + (t434 - 0.26314866163830089978458002229396252612500000000000e0 * t173 * t1760 - 0.26314866163830089978458002229396252612500000000000e0 * t173 * t1764 + t475 - 0.38001026809962717688576807794235457359806521883077e-2 * t227 * t201 * t1782 * jnp.pi - t580 + 0.42708890021612718670335112500000000000000000000000e0 * t176 * t103 * t1799) * t670 + t679 - 0.67557380995489275890803213856418590861878261125470e-2 * t1806 * t677 - t688 - t696 + (t701 - 0.10133607149323391383620482078462788629281739168820e-1 * t227 * t1809 * t698 - 0.10133607149323391383620482078462788629281739168820e-1 * t227 * t706 * t1813 - t713 + 0.52629732327660179956916004458792505225000000000000e0 * t714 * t1799) * t718 - t726 + 0.20267214298646782767240964156925577258563478337641e-1 * t227 * t229 * t1799 * t723
  t1826 = t1825 * t738
  t1834 = f.my_piecewise3(t6, 0, -0.2e1 / 0.9e1 * t1504 * t1654 * t82 + 0.4e1 / 0.3e1 * t78 * t1 * t189)
  t1842 = f.my_piecewise3(t13, 0, -0.2e1 / 0.9e1 * t1511 * t1658 * t87 - 0.4e1 / 0.3e1 * t86 * t1 * t189)
  t1844 = t1834 / 0.2e1 + t1842 / 0.2e1
  t1852 = t227 * t229 * t1688 * t698
  t1854 = t805 - t809
  t1863 = t227 * t697 * t1813
  t1868 = t832 + t836 - t839 + t844 - t80 + t846
  t1874 = t711 * t1799
  t1879 = t535 * t1794 * t650
  t1881 = t1794 * t26 * t657
  t1883 = t602 * t1795
  t1885 = t607 * t1795
  t1894 = f.my_piecewise3(t6, 0, 0.4e1 / 0.9e1 * t907 * t1654 * t82 + 0.8e1 / 0.3e1 * t9 * t1 * t189)
  t1902 = f.my_piecewise3(t13, 0, 0.4e1 / 0.9e1 * t917 * t1658 * t87 - 0.8e1 / 0.3e1 * t14 * t1 * t189)
  t1904 = (t1894 + t1902) * t544
  t1907 = -t980 + t984 + t1038 - 0.4e1 * t977 - 0.4e1 * t973 + t934 - t936 - t873 + t1879 - 0.18311447306006545054854346104378990962041954983034e-3 * t1881 + 0.4e1 * t1883 - 0.4e1 * t1885 + t535 * t1904 * t572
  t1909 = t1794 * t560 * t662
  t1915 = -t950 + t882 + t902 - 0.58482236226346462072622386637590534819724553404280e0 * t1909 + t866 - 0.58482236226346462072622386637590534819724553404280e0 * t952 - t964 - t972 + t906 - 0.18311447306006545054854346104378990962041954983034e-3 * t858 + 0.19751673498613801407483339618206552048944131217655e-1 * t1904 * t570 - t870 + t944
  t1916 = t1907 + t1915
  t1919 = -t797 + 0.16889345248872318972700803464104647715469565281367e-1 * t800 + 0.16889345248872318972700803464104647715469565281367e-1 * t803 + 0.16889345248872318972700803464104647715469565281367e-1 * t1852 - 0.10133607149323391383620482078462788629281739168820e-1 * t227 * t201 * t1854 * t698 - 0.10133607149323391383620482078462788629281739168820e-1 * t227 * t1809 * t707 + 0.16889345248872318972700803464104647715469565281367e-1 * t1863 - 0.10133607149323391383620482078462788629281739168820e-1 * t227 * t702 * t1813 - 0.10133607149323391383620482078462788629281739168820e-1 * t227 * t706 * t1868 * jnp.pi + t854 - 0.10525946465532035991383200891758501045000000000000e1 * t855 - 0.10525946465532035991383200891758501045000000000000e1 * t1874 + 0.52629732327660179956916004458792505225000000000000e0 * t714 * t1916
  t1924 = t148 * t1688 * t184
  t1929 = t1689 * t214
  t1933 = t217 * t1688 * t179 * t222
  t1940 = t227 * t229 * t1753 * t297
  t1943 = t1750 * t29 * t418
  t1945 = t1750 * t291
  t1951 = t1688 * t413 * t292
  t1956 = t1135 * t1654 * t82
  t1959 = 0.2e1 / 0.45e2 * t313 * t316 * t257 * t1956
  t1962 = t1117 * t1654 * t82
  t1965 = t313 * t1115 * t257 * t1962 / 0.27e2
  t1970 = t313 * t1073 * t1716 * t317 * t82 / 0.45e2
  t1974 = t367 * t1068 * t1732 * t403 / 0.45e2
  t1977 = t1128 * t1658 * t87
  t1980 = 0.2e1 / 0.45e2 * t367 * t370 * t280 * t1977
  t1983 = t1096 * t1658 * t87
  t1986 = t367 * t1094 * t280 * t1983 / 0.27e2
  t1991 = t367 * t1068 * t1745 * t371 * t87 / 0.45e2
  t1995 = t313 * t1073 * t1703 * t351 / 0.45e2
  t1997 = 0.34444444444444444444444444444444444444444444444444e-1 * t1943 + 0.4e1 / 0.3e1 * t1945 + 0.4e1 / 0.3e1 * t1854 * t287 * t292 + 0.4e1 / 0.3e1 * t1951 + 0.4e1 / 0.3e1 * t1439 + t1446 - t1959 + t1965 - t1970 - t1974 - t1980 + t1986 - t1991 - t1995 + 0.34444444444444444444444444444444444444444444444444e-1 * t1448 + t1452 + t1456
  t1998 = t1707 * t338
  t2002 = t236 * t241 * t1998 * t351 / 0.30e2
  t2003 = t1736 * t391
  t2007 = t265 * t270 * t2003 * t403 / 0.30e2
  t2009 = t360 * t1747 / 0.30e2
  t2013 = t265 * t270 * t1204 * t1745 / 0.30e2
  t2015 = t104 * t1733
  t2018 = t35 * t1150 * t1983
  t2021 = t35 * t380 * t1977
  t2023 = t29 * t827
  t2024 = t371 * t1
  t2026 = t2023 * t380 * t2024
  t2029 = t203 * t1742
  t2037 = t167 * t1477
  t2041 = t1147 + 0.11997222222222222222222222222222222222222222222222e-1 * t1148 + 0.11997222222222222222222222222222222222222222222222e-1 * t2015 - 0.23994444444444444444444444444444444444444444444445e-1 * t2018 + 0.71983333333333333333333333333333333333333333333334e-1 * t2021 + 0.71983333333333333333333333333333333333333333333334e-1 * t2026 + t1166 + 0.44444444444444444444444444444444444444444444444445e-2 * t1167 + 0.44444444444444444444444444444444444444444444444445e-2 * t2029 - 0.22222222222222222222222222222222222222222222222222e-2 * t171 * t1171 * t1983 + 0.13333333333333333333333333333333333333333333333333e-1 * t171 * t399 * t1977 + 0.13333333333333333333333333333333333333333333333333e-1 * t2037 * t399 * t2024
  t2045 = t265 * t270 * t392 * t2041 / 0.30e2
  t2047 = t1725 * t405 / 0.30e2
  t2049 = t305 * t1718 / 0.30e2
  t2053 = t236 * t241 * t1366 * t1716 / 0.30e2
  t2055 = t104 * t1704
  t2058 = t35 * t1255 * t1962
  t2061 = t35 * t327 * t1956
  t2063 = t317 * t1
  t2065 = t2023 * t327 * t2063
  t2068 = t203 * t1713
  t2079 = t1336 + 0.11997222222222222222222222222222222222222222222222e-1 * t1253 + 0.11997222222222222222222222222222222222222222222222e-1 * t2055 - 0.23994444444444444444444444444444444444444444444445e-1 * t2058 + 0.71983333333333333333333333333333333333333333333334e-1 * t2061 - 0.71983333333333333333333333333333333333333333333334e-1 * t2065 + t1343 + 0.44444444444444444444444444444444444444444444444445e-2 * t1344 + 0.44444444444444444444444444444444444444444444444445e-2 * t2068 - 0.22222222222222222222222222222222222222222222222222e-2 * t171 * t1348 * t1962 + 0.13333333333333333333333333333333333333333333333333e-1 * t171 * t347 * t1956 - 0.13333333333333333333333333333333333333333333333333e-1 * t2037 * t347 * t2063
  t2083 = t236 * t241 * t339 * t2079 / 0.30e2
  t2085 = t1696 * t353 / 0.30e2
  t2087 = t265 * t363 * t1746
  t2088 = t2087 / 0.45e2
  t2090 = t236 * t308 * t1717
  t2091 = t2090 / 0.45e2
  t2094 = t367 * t1084 * t1728 / 0.45e2
  t2095 = t235 * t208
  t2100 = 0.2e1 / 0.45e2 * t264 * t2095 * t370 * t372 * t1
  t2101 = t315 * t1707
  t2104 = t313 * t2101 * t319 / 0.45e2
  t2110 = t313 * t240 * t248 * t1197 * t1716 * t351 / 0.15e2
  t2111 = t1459 - t2002 - t2007 - t2009 - t2013 - t2045 - t2047 - t2049 - t2053 - t2083 - t2085 - t2088 - t2091 + t2094 - t2100 + t2104 + t2110
  t2113 = t1081 * t1729
  t2114 = 0.2e1 / 0.135e3 * t2113
  t2115 = t1102 * t1700
  t2116 = 0.2e1 / 0.135e3 * t2115
  t2117 = t1695 * t312
  t2119 = t2117 * t320 / 0.45e2
  t2121 = t1123 * t1700 / 0.45e2
  t2124 = t313 * t1105 * t1699 / 0.45e2
  t2129 = 0.2e1 / 0.45e2 * t233 * t2095 * t316 * t318 * t1
  t2130 = t369 * t1736
  t2133 = t367 * t2130 * t373 / 0.45e2
  t2139 = t367 * t269 * t274 * t1189 * t1745 * t403 / 0.15e2
  t2140 = t1724 * t312
  t2142 = t2140 * t374 / 0.45e2
  t2144 = t1141 * t1729 / 0.45e2
  t2146 = t1725 * t364
  t2147 = t2146 / 0.45e2
  t2149 = t236 * t308 * t1708
  t2150 = t2149 / 0.45e2
  t2151 = t1696 * t309
  t2152 = t2151 / 0.45e2
  t2154 = t305 * t1709 / 0.30e2
  t2164 = t236 * t241 * (-t1252 - 0.62972222222222222222222222222222222222222222222223e-3 * t1253 - 0.62972222222222222222222222222222222222222222222223e-3 * t2055 + 0.12594444444444444444444444444444444444444444444445e-2 * t2058 - 0.37783333333333333333333333333333333333333333333334e-2 * t2061 + 0.37783333333333333333333333333333333333333333333334e-2 * t2065) * t257 / 0.30e2
  t2165 = t2114 + t2116 + t2119 + t2121 + t2124 + t2129 + t2133 + t2139 + t2142 + t2144 + t1461 + 0.4e1 / 0.3e1 * t1462 + t2147 + t2150 + t2152 + t2154 + t2164
  t2172 = f.my_piecewise3(t13, 0, -0.4e1 * t12 * t1 * t189 + 0.2e1 * t87 * t1658)
  t2176 = t2172 * t43 * t235 * t282 / 0.30e2
  t2178 = t1725 * t387 / 0.30e2
  t2180 = t360 * t1738 / 0.30e2
  t2190 = t265 * t270 * (-t1231 - 0.62972222222222222222222222222222222222222222222223e-3 * t1148 - 0.62972222222222222222222222222222222222222222222223e-3 * t2015 + 0.12594444444444444444444444444444444444444444444445e-2 * t2018 - 0.37783333333333333333333333333333333333333333333334e-2 * t2021 - 0.37783333333333333333333333333333333333333333333334e-2 * t2026) * t280 / 0.30e2
  t2197 = f.my_piecewise3(t6, 0, 0.4e1 * t5 * t1 * t189 + 0.2e1 * t82 * t1654)
  t2201 = t2197 * t43 * t235 * t259 / 0.30e2
  t2203 = t1696 * t334 / 0.30e2
  t2205 = t265 * t363 * t1737
  t2206 = t2205 / 0.45e2
  t2207 = 0.2e1 / 0.135e3 * t1082
  t2208 = 0.2e1 / 0.135e3 * t1103
  t2209 = t1243 / 0.45e2
  t2210 = t1248 / 0.45e2
  t2211 = t1284 / 0.45e2
  t2212 = t1290 / 0.45e2
  t2213 = t1334 / 0.45e2
  t2214 = t1364 / 0.45e2
  t2215 = t2176 + t2178 + t2180 + t2190 + t2201 + t2203 + t2206 + t2207 + t2208 + t2209 + t2210 + t2211 - t1289 + t2212 - t1295 - t2213 - t2214
  t2222 = -t1394 + 0.17543244109220059985638668152930835075000000000000e0 * t1396 + t1399 + t1403 + 0.17543244109220059985638668152930835075000000000000e0 * t1924 - 0.17543244109220059985638668152930835075000000000000e0 * t187 * t1854 * t184 - 0.17543244109220059985638668152930835075000000000000e0 * t1929 - 0.10999614056480977610995444931887633592025000000000e-1 * t1933 - 0.17543244109220059985638668152930835075000000000000e0 * t1407 - t1415 - t1419 - 0.10999614056480977610995444931887633592025000000000e-1 * t1411 - t1426 - t1430 + 0.50668035746616956918102410392313943146408695844103e-2 * t1433 + 0.50668035746616956918102410392313943146408695844103e-2 * t1940 - 0.30400821447970174150861446235388365887845217506462e-2 * t227 * t201 * (t1997 + t2111 + t2165 + t2215) * t297
  t2224 = t73 * t1663
  t2232 = t691 * t1688 * t694
  t2240 = 0.48717083333333333333333333333333333333333333333333e0 * t1497
  t2242 = t99 * t1667 * t104
  t2243 = 0.48717083333333333333333333333333333333333333333333e0 * t2242
  t2246 = 0.58460500000000000000000000000000000000000000000000e1 * t37 * t1670 * t92
  t2249 = 0.29230250000000000000000000000000000000000000000000e1 * t37 * t55 * t1844
  t2251 = t103 * t1670
  t2252 = t114 * t2251
  t2259 = t34 * t64 * t1844
  t2264 = t119 * t1674 * t104
  t2273 = -t1492 + t2240 + t1500 + t2243 + t2246 - t2249 + t1526 + t1528 / 0.6e1 + t2252 / 0.6e1 + 0.3e1 / 0.2e1 * t114 * t34 * t1674 * t92 - t114 * t2259 / 0.2e1 + t1541 + 0.73452000000000000000000000000000000000000000000000e0 * t1544 + t1547 + 0.73452000000000000000000000000000000000000000000000e0 * t2264 + 0.58761600000000000000000000000000000000000000000000e1 * t62 * t1549 * t1663 * t92 - 0.14690400000000000000000000000000000000000000000000e1 * t62 * t124 * t1844
  t2275 = t1677 * t131
  t2282 = t69 * t2251
  t2292 = -t1492 + t2240 + t1500 + t2243 + t2246 - t2249 + t1569 + 0.57475166666666666666666666666666666666666666666666e0 * t1570 + 0.57475166666666666666666666666666666666666666666667e0 * t2282 + 0.51727650000000000000000000000000000000000000000000e1 * t68 * t54 * t33 * t124 * t1663 * t92 - 0.17242550000000000000000000000000000000000000000000e1 * t69 * t2259
  t2302 = t1806 * t686
  t2304 = 0.3e1 * t23 * t77 * t1844 + t1919 * t718 - 0.54045904796391420712642571085134872689502608900376e-1 * t1617 + t1624 + t2222 * t60 + 0.3e1 * t1631 * t142 * t2224 + 0.3e1 * t1631 * t1684 * t1632 - 0.50830173461006131180240338105569347764477203670804e-2 * t2232 + 0.20267214298646782767240964156925577258563478337641e-1 * t227 * t229 * t1916 * t723 + t97 * t1684 * t138 + t97 * (0.2e1 * t1563 * t1681 * t138 - t132 * t2292 - t2275 * t138 - t1558 * t1681 + t2273 * t74) * t141 * t73 - 0.67557380995489275890803213856418590861878261125470e-2 * t226 * t202 * t1854 * t677 - 0.67557380995489275890803213856418590861878261125470e-2 * t2302
  t2307 = t226 * t672 * t1688 * t677
  t2316 = t227 * t721 * t1799 * t723
  t2322 = t205 * t1760
  t2330 = t205 * t1764
  t2341 = t227 * t229 * t1782 * jnp.pi
  t2343 = -t1959 + t1965 - t1970 - t1974 - t1980 + t1986 - t1991 - t1995 - t2002 - t2007 - t2009 - t2013 - t2045 - t2047 - t2049 - t2053 - t2083 - t2085
  t2344 = t1768 * t494
  t2347 = t1767 * t165 * t491
  t2355 = t1688 * t482 * t453 * t458
  t2357 = -t2088 - t2091 + 0.2e1 / 0.9e1 * t2344 + 0.60777777777777777777777777777777777777777777777777e-1 * t2347 + t1854 * t450 * t453 * t458 / 0.3e1 + t2355 / 0.3e1 + t1080 + t2094 - t2100 + t2104 + t2110 + t2114 + t2116 + t2119 + t2121 + t2124 + t2129 + t2133
  t2360 = t2139 + t2142 + t2144 + t2147 + t2150 + t2152 + t2154 + t2164 + t2176 + t2178 + t2180 + t2190 + t2201 + t2203 + t2206 + t2207 + t2208 - 0.2e1 / 0.45e2 * t1226
  t2364 = t1779 * t510
  t2373 = f.my_piecewise3(t6, 0, 0.40e2 / 0.9e1 * t10 * t1654 * t82 + 0.16e2 / 0.3e1 * t497 * t1 * t189)
  t2381 = f.my_piecewise3(t13, 0, 0.40e2 / 0.9e1 * t15 * t1658 * t87 - 0.16e2 / 0.3e1 * t501 * t1 * t189)
  t2387 = t1230 + t2209 + t2210 + t2211 - t1289 + t2212 - t1295 + t1305 - t1309 + t1316 / 0.3e1 + 0.60777777777777777777777777777777777777777777777777e-1 * t1319 + t1327 + t1330 + 0.2e1 / 0.9e1 * t1331 - t2213 - t2214 - 0.2e1 / 0.45e2 * t2364 - (t2373 / 0.2e1 + t2381 / 0.2e1) * t43 * t312 / 0.15e2
  t2396 = t176 * t209 * t1799
  t2401 = -t1046 + 0.26314866163830089978458002229396252612500000000000e0 * t1047 + 0.26314866163830089978458002229396252612500000000000e0 * t1049 + 0.26314866163830089978458002229396252612500000000000e0 * t2322 - 0.26314866163830089978458002229396252612500000000000e0 * t173 * t1854 * t431 - 0.26314866163830089978458002229396252612500000000000e0 * t173 * t1688 * t444 + 0.26314866163830089978458002229396252612500000000000e0 * t2330 - 0.26314866163830089978458002229396252612500000000000e0 * t173 * t192 * t1763 - 0.26314866163830089978458002229396252612500000000000e0 * t173 * t151 * t1868 - t1063 + 0.63335044683271196147628012990392428933010869805128e-2 * t1066 + 0.63335044683271196147628012990392428933010869805128e-2 * t2341 - 0.38001026809962717688576807794235457359806521883077e-2 * t227 * t201 * (t2343 + t2357 + t2360 + t2387) * jnp.pi + t1382 - 0.56945186695483624893780150000000000000000000000000e0 * t1384 - 0.56945186695483624893780150000000000000000000000000e0 * t2396 + 0.42708890021612718670335112500000000000000000000000e0 * t176 * t103 * t1916
  t2404 = t1683 * t1626
  t2407 = 0.11259563499248212648467202309403098476979710187578e-1 * t2307 + 0.6e1 * t1484 * t25 * t76 * t1663 * t92 - 0.54045904796391420712642571085134872689502608900376e-1 * t2316 - t1595 + 0.11259563499248212648467202309403098476979710187578e-1 * t1598 + t1601 - 0.67557380995489275890803213856418590861878261125470e-2 * t1606 - t1481 - t1584 + t2401 * t670 + t787 - 0.50830173461006131180240338105569347764477203670804e-2 * t789 - t793 - t97 * t2404 * t1628
  t2413 = t169 * t1825 * t776 * t1643
  d12 = t739 + t783 + t1826 + t2 * (t2304 + t2407) * t738 + 0.41076328840066666666666666666666666666666666666668e0 * t2413 + 0.41076328840066666666666666666666666666666666666668e0 * t1644 + t1653
  t2419 = -t805 - t807 - t809
  t2427 = t832 + t836 - t839 + t844 + t80 + t845 + t846
  t2435 = t1654 ** 2
  t2439 = 0.2e1 * t80 + 0.2e1 * t806
  t2443 = f.my_piecewise3(t6, 0, 0.4e1 / 0.9e1 * t907 * t2435 + 0.4e1 / 0.3e1 * t9 * t2439)
  t2444 = t1658 ** 2
  t2447 = -t2439
  t2451 = f.my_piecewise3(t13, 0, 0.4e1 / 0.9e1 * t917 * t2444 + 0.4e1 / 0.3e1 * t14 * t2447)
  t2453 = (t2443 + t2451) * t544
  t2459 = t936 - 0.8e1 * t1885 - t980 - 0.8e1 * t1883 - t976 - t950 + t1038 + t535 * t2453 * t572 + 0.2e1 * t1879 + 0.19751673498613801407483339618206552048944131217655e-1 * t2453 * t570 + t934
  t2462 = t939 - t873 + t882 + t902 - t972 - t964 + t906 + t944 - 0.36622894612013090109708692208757981924083909966068e-3 * t1881 + t866 - t870 - 0.11696447245269292414524477327518106963944910680856e1 * t1909
  t2463 = t2459 + t2462
  t2485 = f.my_piecewise3(t6, 0, 0.40e2 / 0.9e1 * t10 * t2435 + 0.8e1 / 0.3e1 * t497 * t2439)
  t2491 = f.my_piecewise3(t13, 0, 0.40e2 / 0.9e1 * t15 * t2444 + 0.8e1 / 0.3e1 * t501 * t2447)
  t2500 = 0.2e1 / 0.45e2 * t313 * t1073 * t1703 * t1716
  t2504 = 0.2e1 / 0.45e2 * t367 * t1068 * t1732 * t1745
  t2505 = 0.2e1 / 0.45e2 * t2087
  t2506 = 0.2e1 / 0.45e2 * t2090
  t2510 = 0.4e1 / 0.135e3 * t2113
  t2511 = 0.4e1 / 0.135e3 * t2115
  t2512 = t1745 ** 2
  t2516 = t265 * t270 * t1190 * t2512 / 0.15e2
  t2517 = -(t2485 / 0.2e1 + t2491 / 0.2e1) * t43 * t312 / 0.15e2 - t2500 - t2504 - t2505 - t2506 + 0.4e1 / 0.9e1 * t2344 + 0.12155555555555555555555555555555555555555555555555e0 * t2347 + 0.2e1 / 0.3e1 * t2355 + t1080 + t2510 + t2511 + t2516
  t2518 = t1716 ** 2
  t2522 = t236 * t241 * t1198 * t2518 / 0.15e2
  t2524 = t1725 * t1747 / 0.15e2
  t2528 = t236 * t241 * t1998 * t1716 / 0.15e2
  t2530 = t1696 * t1718 / 0.15e2
  t2532 = t1096 * t2444
  t2534 = t35 * t1150 * t2532
  t2536 = t1128 * t2444
  t2538 = t35 * t380 * t2536
  t2540 = t371 * t2447
  t2542 = t35 * t380 * t2540
  t2558 = t265 * t270 * t392 * (t1147 + 0.23994444444444444444444444444444444444444444444444e-1 * t2015 - 0.23994444444444444444444444444444444444444444444445e-1 * t2534 + 0.71983333333333333333333333333333333333333333333334e-1 * t2538 - 0.35991666666666666666666666666666666666666666666667e-1 * t2542 + t1166 + 0.88888888888888888888888888888888888888888888888890e-2 * t2029 - 0.22222222222222222222222222222222222222222222222222e-2 * t171 * t1171 * t2532 + 0.13333333333333333333333333333333333333333333333333e-1 * t171 * t399 * t2536 - 0.66666666666666666666666666666666666666666666666667e-2 * t171 * t399 * t2540) / 0.30e2
  t2562 = t265 * t270 * t2003 * t1745 / 0.15e2
  t2564 = t1117 * t2435
  t2566 = t35 * t1255 * t2564
  t2568 = t1135 * t2435
  t2570 = t35 * t327 * t2568
  t2572 = t317 * t2439
  t2574 = t35 * t327 * t2572
  t2590 = t236 * t241 * t339 * (t1336 + 0.23994444444444444444444444444444444444444444444444e-1 * t2055 - 0.23994444444444444444444444444444444444444444444445e-1 * t2566 + 0.71983333333333333333333333333333333333333333333334e-1 * t2570 - 0.35991666666666666666666666666666666666666666666667e-1 * t2574 + t1343 + 0.88888888888888888888888888888888888888888888888890e-2 * t2068 - 0.22222222222222222222222222222222222222222222222222e-2 * t171 * t1348 * t2564 + 0.13333333333333333333333333333333333333333333333333e-1 * t171 * t347 * t2568 - 0.66666666666666666666666666666666666666666666666667e-2 * t171 * t347 * t2572) / 0.30e2
  t2591 = 0.2e1 / 0.45e2 * t2146
  t2592 = 0.2e1 / 0.45e2 * t2149
  t2593 = 0.2e1 / 0.45e2 * t2151
  t2594 = 0.2e1 / 0.45e2 * t2205
  t2598 = t367 * t1094 * t1097 * t2444 / 0.27e2
  t2599 = t2522 - t2524 - t2528 - t2530 - t2558 - t2562 - t2590 + t2591 + t2592 + t2593 + t2594 + t2598
  t2602 = 0.2e1 / 0.45e2 * t2117 * t1700
  t2605 = 0.2e1 / 0.45e2 * t313 * t2101 * t1699
  t2609 = t313 * t316 * t318 * t2439 / 0.45e2
  t2613 = t313 * t1115 * t1118 * t2435 / 0.27e2
  t2617 = 0.2e1 / 0.45e2 * t313 * t316 * t1136 * t2435
  t2621 = 0.2e1 / 0.45e2 * t367 * t370 * t1129 * t2444
  t2623 = 0.2e1 / 0.45e2 * t2140 * t1729
  t2626 = 0.2e1 / 0.45e2 * t367 * t2130 * t1728
  t2630 = t367 * t370 * t372 * t2447 / 0.45e2
  t2631 = t2602 + t2605 + t2609 + t2613 - t2617 - t2621 + t2623 + t2626 + t2630 + t1230 - t1289 - t1295
  t2640 = f.my_piecewise3(t13, 0, 0.2e1 * t12 * t2447 + 0.2e1 * t2444)
  t2644 = t2640 * t43 * t235 * t282 / 0.30e2
  t2646 = t1725 * t1738 / 0.15e2
  t2655 = t236 * t241 * (-t1252 - 0.12594444444444444444444444444444444444444444444445e-2 * t2055 + 0.12594444444444444444444444444444444444444444444445e-2 * t2566 - 0.37783333333333333333333333333333333333333333333334e-2 * t2570 + 0.18891666666666666666666666666666666666666666666667e-2 * t2574) * t257 / 0.30e2
  t2659 = f.my_piecewise3(t6, 0, 0.2e1 * t5 * t2439 + 0.2e1 * t2435)
  t2663 = t2659 * t43 * t235 * t259 / 0.30e2
  t2665 = t1696 * t1709 / 0.15e2
  t2674 = t265 * t270 * (-t1231 - 0.12594444444444444444444444444444444444444444444445e-2 * t2015 + 0.12594444444444444444444444444444444444444444444445e-2 * t2534 - 0.37783333333333333333333333333333333333333333333334e-2 * t2538 + 0.18891666666666666666666666666666666666666666666667e-2 * t2542) * t280 / 0.30e2
  t2675 = t1305 - t1309 + t1327 + t1330 + t2419 * t450 * t453 * t458 / 0.3e1 - 0.4e1 / 0.45e2 * t2364 + t2644 + t2646 + t2655 + t2663 + t2665 + t2674
  t2686 = -t1046 + 0.52629732327660179956916004458792505225000000000000e0 * t2322 + 0.52629732327660179956916004458792505225000000000000e0 * t2330 - 0.26314866163830089978458002229396252612500000000000e0 * t173 * t2419 * t431 - 0.52629732327660179956916004458792505225000000000000e0 * t173 * t1688 * t1763 - 0.26314866163830089978458002229396252612500000000000e0 * t173 * t151 * t2427 - t1063 + 0.12667008936654239229525602598078485786602173961026e-1 * t2341 - 0.38001026809962717688576807794235457359806521883077e-2 * t227 * t201 * (t2517 + t2599 + t2631 + t2675) * jnp.pi + t1382 - 0.11389037339096724978756030000000000000000000000000e1 * t2396 + 0.42708890021612718670335112500000000000000000000000e0 * t176 * t103 * t2463
  t2698 = 0.68888888888888888888888888888888888888888888888888e-1 * t1943 + 0.8e1 / 0.3e1 * t1945 + 0.8e1 / 0.3e1 * t1951 + t1446 - t2500 - t2504 + t1452 + t1456 + t1459 - t2505 - t2506
  t2702 = 0.4e1 / 0.3e1 * t2419 * t287 * t292 + t2510 + t2511 + t2516 + t2522 - t2524 - t2528 - t2530 - t2558 - t2562 - t2590
  t2704 = t1461 + t2591 + t2592 + t2593 + t2594 + t2598 + t2602 + t2605 + t2609 + t2613 - t2617
  t2705 = -t2621 + t2623 + t2626 + t2630 - t1289 - t1295 + t2644 + t2646 + t2655 + t2663 + t2665 + t2674
  t2712 = -t1394 + 0.35086488218440119971277336305861670150000000000000e0 * t1924 + t1399 + t1403 - 0.17543244109220059985638668152930835075000000000000e0 * t187 * t2419 * t184 - 0.35086488218440119971277336305861670150000000000000e0 * t1929 - 0.21999228112961955221990889863775267184050000000000e-1 * t1933 - t1415 - t1419 - t1426 - t1430 + 0.10133607149323391383620482078462788629281739168821e-1 * t1940 - 0.30400821447970174150861446235388365887845217506462e-2 * t227 * t201 * (t2698 + t2702 + t2704 + t2705) * t297
  t2719 = f.my_piecewise3(t6, 0, -0.2e1 / 0.9e1 * t1504 * t2435 + 0.2e1 / 0.3e1 * t78 * t2439)
  t2725 = f.my_piecewise3(t13, 0, -0.2e1 / 0.9e1 * t1511 * t2444 + 0.2e1 / 0.3e1 * t86 * t2447)
  t2727 = t2719 / 0.2e1 + t2725 / 0.2e1
  t2746 = (-t797 + 0.33778690497744637945401606928209295430939130562734e-1 * t1852 + 0.33778690497744637945401606928209295430939130562734e-1 * t1863 - 0.10133607149323391383620482078462788629281739168820e-1 * t227 * t201 * t2419 * t698 - 0.20267214298646782767240964156925577258563478337640e-1 * t227 * t1809 * t1813 - 0.10133607149323391383620482078462788629281739168820e-1 * t227 * t706 * t2427 * jnp.pi + t854 - 0.21051892931064071982766401783517002090000000000000e1 * t1874 + 0.52629732327660179956916004458792505225000000000000e0 * t714 * t2463) * t718 - t1481 + t2686 * t670 + t2712 * t60 + 0.3e1 * t23 * t77 * t2727 + 0.20267214298646782767240964156925577258563478337641e-1 * t227 * t229 * t2463 * t723 - t97 * t2404 * t73 * t1677 + 0.6e1 * t1631 * t1684 * t2224 - 0.67557380995489275890803213856418590861878261125470e-2 * t226 * t202 * t2419 * t677 - 0.13511476199097855178160642771283718172375652225094e-1 * t2302 - t1584
  t2750 = t1663 ** 2
  t2754 = 0.97434166666666666666666666666666666666666666666666e0 * t2242
  t2757 = 0.58460500000000000000000000000000000000000000000000e1 * t37 * t64 * t2750
  t2760 = 0.29230250000000000000000000000000000000000000000000e1 * t37 * t55 * t2727
  t2763 = t34 * t124 * t2750
  t2767 = t34 * t64 * t2727
  t2777 = -t1492 + t2754 + t1500 + t2757 - t2760 + t1526 + t2252 / 0.3e1 + 0.3e1 / 0.2e1 * t114 * t2763 - t114 * t2767 / 0.2e1 + t1541 + 0.14690400000000000000000000000000000000000000000000e1 * t2264 + t1547 + 0.58761600000000000000000000000000000000000000000000e1 * t62 * t1549 * t2750 - 0.14690400000000000000000000000000000000000000000000e1 * t62 * t124 * t2727
  t2781 = t1681 ** 2
  t2797 = -t1595 + 0.22519126998496425296934404618806196953959420375156e-1 * t2307 + t1601 - 0.10809180959278284142528514217026974537900521780075e0 * t2316 + t1624 - 0.10166034692201226236048067621113869552895440734161e-1 * t2232 - t793 + t787 + 0.6e1 * t1484 * t77 * t2750 + t97 * (t2777 * t74 - 0.2e1 * t2275 * t1681 + 0.2e1 * t1563 * t2781 - t132 * (-t1492 + t2754 + t1500 + t2757 - t2760 + t1569 + 0.11495033333333333333333333333333333333333333333333e1 * t2282 + 0.51727650000000000000000000000000000000000000000000e1 * t69 * t2763 - 0.17242550000000000000000000000000000000000000000000e1 * t69 * t2767)) * t141 * t73 + t97 * t1684 * t1681
  d22 = 0.2e1 * t1826 + t783 + t2 * (t2746 + t2797) * t738 + 0.82152657680133333333333333333333333333333333333336e0 * t2413 + t1653
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = jnp.pi ** 2
  t2 = jnp.sqrt(jnp.pi)
  t4 = 0.1e1 / t2 / t1
  t5 = r0 + r1
  t6 = t5 ** 2
  t7 = t6 ** 2
  t8 = 0.1e1 / t7
  t9 = t4 * t8
  t10 = r0 - r1
  t11 = t10 ** 2
  t12 = 0.1e1 / t6
  t13 = t11 * t12
  t14 = 0.1e1 - t13
  t15 = t9 * t14
  t16 = 4 ** (0.1e1 / 0.3e1)
  t17 = 9 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t20 = 0.1e1 / jnp.pi
  t21 = t20 ** (0.1e1 / 0.3e1)
  t22 = jnp.log(0.2e1)
  t30 = 3 ** (0.1e1 / 0.3e1)
  t31 = (0.2e1 / 0.45e2 * t16 * t18 * t21 * (t1 + 0.6e1 * t22 - 0.3e1) * t20 - 0.7524e0) * t30
  t32 = t16 ** 2
  t33 = t21 * t32
  t34 = t5 ** (0.1e1 / 0.3e1)
  t35 = 0.1e1 / t34
  t39 = t30 ** 2
  t40 = t21 ** 2
  t41 = t39 * t40
  t42 = t34 ** 2
  t43 = 0.1e1 / t42
  t44 = t16 * t43
  t45 = t41 * t44
  t47 = 0.1e1 / t5
  t48 = t20 * t47
  t50 = t21 * t20
  t51 = t30 * t50
  t53 = 0.1e1 / t34 / t5
  t54 = t32 * t53
  t57 = 0.1e1 - t31 * t33 * t35 / 0.4e1 + 0.20482500000000000000000000000000000000000000000000e-1 * t45 - 0.95775000000000000000000000000000000000000000000000e-2 * t48 + 0.34856250000000000000000000000000000000000000000000e-3 * t51 * t54
  t58 = t30 * t21
  t59 = t32 * t35
  t60 = t58 * t59
  t62 = jnp.exp(-0.18810000000000000000000000000000000000000000000000e0 * t60)
  t63 = t57 * t62
  t64 = jnp.sqrt(0.2e1)
  t65 = f.p.cam_omega ** 2
  t66 = t65 ** 2
  t67 = t66 * f.p.cam_omega
  t68 = t64 * t67
  t69 = t63 * t68
  t72 = t6 * t5
  t73 = 0.1e1 / t72
  t74 = t4 * t73
  t75 = t10 * t12
  t76 = t11 * t73
  t78 = -0.2e1 * t75 + 0.2e1 * t76
  t79 = t74 * t78
  t82 = t74 * t14
  t83 = t33 * t53
  t87 = 0.1e1 / t42 / t5
  t88 = t16 * t87
  t89 = t41 * t88
  t91 = t20 * t12
  t94 = 0.1e1 / t34 / t6
  t95 = t32 * t94
  t98 = t31 * t83 / 0.12e2 - 0.13655000000000000000000000000000000000000000000000e-1 * t89 + 0.95775000000000000000000000000000000000000000000000e-2 * t91 - 0.46475000000000000000000000000000000000000000000000e-3 * t51 * t95
  t99 = t98 * t62
  t100 = t99 * t68
  t103 = 0.1e1 / t1
  t105 = t39 * t40 * t103
  t106 = t105 * t16
  t108 = 0.1e1 / t42 / t72
  t109 = t108 * t14
  t111 = t63 / 0.2e1 - 0.1e1 / 0.2e1 + t13 / 0.2e1
  t112 = t111 * jnp.pi
  t117 = 0.1e1 / t42 / t6
  t118 = t117 * t78
  t122 = t117 * t14
  t125 = t57 * t30 * t21
  t126 = t54 * t62
  t129 = t99 / 0.2e1 + 0.31350000000000000000000000000000000000000000000000e-1 * t125 * t126 + t75 - t76
  t130 = t129 * jnp.pi
  t135 = t10 * t73
  t137 = t11 * t8
  t139 = -0.2e1 * t12 + 0.8e1 * t135 - 0.6e1 * t137
  t140 = t87 * t139
  t144 = t87 * t78
  t148 = t87 * t14
  t149 = t33 * t94
  t152 = t16 * t117
  t153 = t41 * t152
  t155 = t20 * t73
  t158 = 0.1e1 / t34 / t72
  t159 = t32 * t158
  t162 = -t31 * t149 / 0.9e1 + 0.22758333333333333333333333333333333333333333333333e-1 * t153 - 0.19155000000000000000000000000000000000000000000000e-1 * t155 + 0.10844166666666666666666666666666666666666666666667e-2 * t51 * t159
  t163 = t162 * t62
  t166 = t98 * t30 * t21
  t169 = t95 * t62
  t173 = t57 * t39 * t40
  t174 = t152 * t62
  t179 = t163 / 0.2e1 + 0.62700000000000000000000000000000000000000000000000e-1 * t166 * t126 - 0.41800000000000000000000000000000000000000000000000e-1 * t125 * t169 + 0.78625800000000000000000000000000000000000000000000e-2 * t173 * t174 + t12 - 0.4e1 * t135 + 0.3e1 * t137
  t180 = t179 * jnp.pi
  t184 = t103 * t8
  t186 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t60
  t187 = jnp.sqrt(t60)
  t190 = t60 ** 0.15e1
  t193 = 0.37978500000000000000000000000000000000000000000000e1 * t187 + 0.89690000000000000000000000000000000000000000000000e0 * t60 + 0.20477500000000000000000000000000000000000000000000e0 * t190 + 0.12323500000000000000000000000000000000000000000000e0 * t45
  t196 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t193
  t197 = jnp.log(t196)
  t199 = 0.621814e-1 * t186 * t197
  t200 = t11 ** 2
  t201 = t200 * t8
  t202 = t10 * t47
  t203 = 0.1e1 + t202
  t204 = t203 <= f.p.zeta_threshold
  t205 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t206 = t205 * f.p.zeta_threshold
  t207 = t203 ** (0.1e1 / 0.3e1)
  t208 = t207 * t203
  t209 = f.my_piecewise3(t204, t206, t208)
  t210 = 0.1e1 - t202
  t211 = t210 <= f.p.zeta_threshold
  t212 = t210 ** (0.1e1 / 0.3e1)
  t213 = t212 * t210
  t214 = f.my_piecewise3(t211, t206, t213)
  t216 = 2 ** (0.1e1 / 0.3e1)
  t219 = 0.1e1 / (0.2e1 * t216 - 0.2e1)
  t220 = (t209 + t214 - 0.2e1) * t219
  t222 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t60
  t227 = 0.70594500000000000000000000000000000000000000000000e1 * t187 + 0.15494250000000000000000000000000000000000000000000e1 * t60 + 0.42077500000000000000000000000000000000000000000000e0 * t190 + 0.15629250000000000000000000000000000000000000000000e0 * t45
  t230 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t227
  t231 = jnp.log(t230)
  t235 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t60
  t240 = 0.51785000000000000000000000000000000000000000000000e1 * t187 + 0.90577500000000000000000000000000000000000000000000e0 * t60 + 0.11003250000000000000000000000000000000000000000000e0 * t190 + 0.12417750000000000000000000000000000000000000000000e0 * t45
  t243 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t240
  t244 = jnp.log(t243)
  t245 = t235 * t244
  t247 = -0.3109070e-1 * t222 * t231 + t199 - 0.19751673498613801407483339618206552048944131217655e-1 * t245
  t248 = t220 * t247
  t252 = -t199 + t201 * t248 + 0.19751673498613801407483339618206552048944131217655e-1 * t220 * t245
  t255 = t103 * t73
  t258 = 0.11073470983333333333333333333333333333333333333333e-2 * t58 * t54 * t197
  t259 = t193 ** 2
  t260 = 0.1e1 / t259
  t261 = t186 * t260
  t262 = 0.1e1 / t187
  t263 = t262 * t30
  t264 = t263 * t83
  t266 = t58 * t54
  t268 = t60 ** 0.5e0
  t269 = t268 * t30
  t270 = t269 * t83
  t273 = -0.63297500000000000000000000000000000000000000000000e0 * t264 - 0.29896666666666666666666666666666666666666666666667e0 * t266 - 0.10238750000000000000000000000000000000000000000000e0 * t270 - 0.82156666666666666666666666666666666666666666666667e-1 * t89
  t274 = 0.1e1 / t196
  t275 = t273 * t274
  t277 = 0.10000000000000000000000000000000000000000000000000e1 * t261 * t275
  t278 = t11 * t10
  t279 = t278 * t8
  t282 = t7 * t5
  t283 = 0.1e1 / t282
  t284 = t200 * t283
  t287 = t47 - t75
  t290 = f.my_piecewise3(t204, 0, 0.4e1 / 0.3e1 * t207 * t287)
  t291 = -t287
  t294 = f.my_piecewise3(t211, 0, 0.4e1 / 0.3e1 * t212 * t291)
  t296 = (t290 + t294) * t219
  t297 = t296 * t247
  t302 = t227 ** 2
  t303 = 0.1e1 / t302
  t304 = t222 * t303
  t309 = -0.11765750000000000000000000000000000000000000000000e1 * t264 - 0.51647500000000000000000000000000000000000000000000e0 * t266 - 0.21038750000000000000000000000000000000000000000000e0 * t270 - 0.10419500000000000000000000000000000000000000000000e0 * t89
  t310 = 0.1e1 / t230
  t311 = t309 * t310
  t317 = t240 ** 2
  t318 = 0.1e1 / t317
  t319 = t235 * t318
  t324 = -0.86308333333333333333333333333333333333333333333334e0 * t264 - 0.30192500000000000000000000000000000000000000000000e0 * t266 - 0.55016250000000000000000000000000000000000000000000e-1 * t270 - 0.82785000000000000000000000000000000000000000000000e-1 * t89
  t325 = 0.1e1 / t243
  t326 = t324 * t325
  t329 = 0.53237641966666666666666666666666666666666666666666e-3 * t58 * t54 * t231 + 0.10000000000000000000000000000000000000000000000000e1 * t304 * t311 - t258 - t277 + 0.18311447306006545054854346104378990962041954983034e-3 * t58 * t54 * t244 + 0.58482236226346462072622386637590534819724553404280e0 * t319 * t326
  t330 = t220 * t329
  t334 = t220 * t30
  t336 = t33 * t53 * t244
  t339 = t220 * t235
  t341 = t318 * t324 * t325
  t344 = t258 + t277 + 0.4e1 * t279 * t248 - 0.4e1 * t284 * t248 + t201 * t297 + t201 * t330 + 0.19751673498613801407483339618206552048944131217655e-1 * t296 * t245 - 0.18311447306006545054854346104378990962041954983034e-3 * t334 * t336 - 0.58482236226346462072622386637590534819724553404280e0 * t339 * t341
  t347 = t103 * t12
  t348 = t296 * t30
  t352 = 0.1e1 / t317 / t240
  t353 = t324 ** 2
  t355 = t352 * t353 * t325
  t358 = t58 * t32
  t359 = t53 * t260
  t362 = 0.35616666666666666666666666666666666666666666666666e-1 * t358 * t359 * t275
  t365 = t278 * t283
  t368 = t259 ** 2
  t369 = 0.1e1 / t368
  t370 = t186 * t369
  t371 = t273 ** 2
  t372 = t196 ** 2
  t373 = 0.1e1 / t372
  t374 = t371 * t373
  t376 = 0.16081979498692535066756296899072713062105388428051e2 * t370 * t374
  t377 = t187 * t60
  t378 = 0.1e1 / t377
  t379 = t378 * t39
  t380 = t40 * t16
  t381 = t380 * t117
  t382 = t379 * t381
  t384 = t263 * t149
  t386 = t58 * t95
  t388 = t60 ** (-0.5e0)
  t389 = t388 * t39
  t390 = t389 * t381
  t392 = t269 * t149
  t395 = -0.42198333333333333333333333333333333333333333333333e0 * t382 + 0.84396666666666666666666666666666666666666666666666e0 * t384 + 0.39862222222222222222222222222222222222222222222223e0 * t386 + 0.68258333333333333333333333333333333333333333333333e-1 * t390 + 0.13651666666666666666666666666666666666666666666667e0 * t392 + 0.13692777777777777777777777777777777777777777777778e0 * t153
  t396 = t395 * t274
  t398 = 0.10000000000000000000000000000000000000000000000000e1 * t261 * t396
  t399 = t220 * t58
  t400 = t54 * t341
  t403 = t207 ** 2
  t404 = 0.1e1 / t403
  t405 = t287 ** 2
  t409 = -0.2e1 * t12 + 0.2e1 * t135
  t413 = f.my_piecewise3(t204, 0, 0.4e1 / 0.9e1 * t404 * t405 + 0.4e1 / 0.3e1 * t207 * t409)
  t414 = t212 ** 2
  t415 = 0.1e1 / t414
  t416 = t291 ** 2
  t419 = -t409
  t423 = f.my_piecewise3(t211, 0, 0.4e1 / 0.9e1 * t415 * t416 + 0.4e1 / 0.3e1 * t212 * t419)
  t425 = (t413 + t423) * t219
  t428 = t317 ** 2
  t429 = 0.1e1 / t428
  t431 = t243 ** 2
  t432 = 0.1e1 / t431
  t433 = t429 * t353 * t432
  t436 = t296 * t235
  t439 = -0.36622894612013090109708692208757981924083909966068e-3 * t348 * t336 + 0.11696447245269292414524477327518106963944910680856e1 * t339 * t355 - t362 + 0.12e2 * t137 * t248 - 0.32e2 * t365 * t248 + t376 + t398 + 0.10843581300301739842632067522386578331157260943710e-1 * t399 * t400 + 0.19751673498613801407483339618206552048944131217655e-1 * t425 * t245 - 0.17315859105681463759666483083807725165579399831905e2 * t339 * t433 - 0.11696447245269292414524477327518106963944910680856e1 * t436 * t341
  t446 = -0.57538888888888888888888888888888888888888888888889e0 * t382 + 0.11507777777777777777777777777777777777777777777778e1 * t384 + 0.40256666666666666666666666666666666666666666666667e0 * t386 + 0.36677500000000000000000000000000000000000000000000e-1 * t390 + 0.73355000000000000000000000000000000000000000000000e-1 * t392 + 0.13797500000000000000000000000000000000000000000000e0 * t153
  t448 = t318 * t446 * t325
  t453 = 0.14764627977777777777777777777777777777777777777777e-2 * t58 * t95 * t197
  t457 = t53 * t303
  t462 = 0.1e1 / t302 / t227
  t463 = t222 * t462
  t464 = t309 ** 2
  t465 = t464 * t310
  t474 = -0.78438333333333333333333333333333333333333333333333e0 * t382 + 0.15687666666666666666666666666666666666666666666667e1 * t384 + 0.68863333333333333333333333333333333333333333333333e0 * t386 + 0.14025833333333333333333333333333333333333333333333e0 * t390 + 0.28051666666666666666666666666666666666666666666667e0 * t392 + 0.17365833333333333333333333333333333333333333333333e0 * t153
  t475 = t474 * t310
  t478 = t302 ** 2
  t479 = 0.1e1 / t478
  t480 = t222 * t479
  t481 = t230 ** 2
  t482 = 0.1e1 / t481
  t483 = t464 * t482
  t487 = 0.1e1 / t259 / t193
  t488 = t186 * t487
  t489 = t371 * t274
  t491 = 0.20000000000000000000000000000000000000000000000000e1 * t488 * t489
  t495 = t53 * t318
  t499 = t235 * t352
  t500 = t353 * t325
  t503 = t446 * t325
  t506 = t235 * t429
  t507 = t353 * t432
  t510 = -0.70983522622222222222222222222222222222222222222221e-3 * t58 * t95 * t231 - 0.34246666666666666666666666666666666666666666666666e-1 * t358 * t457 * t311 - 0.20000000000000000000000000000000000000000000000000e1 * t463 * t465 + 0.10000000000000000000000000000000000000000000000000e1 * t304 * t475 + 0.32163958997385070133512593798145426124210776856102e2 * t480 * t483 + t453 + t362 + t491 - t398 - t376 - 0.24415263074675393406472461472505321282722606644045e-3 * t58 * t95 * t244 - 0.10843581300301739842632067522386578331157260943710e-1 * t358 * t495 * t326 - 0.11696447245269292414524477327518106963944910680856e1 * t499 * t500 + 0.58482236226346462072622386637590534819724553404280e0 * t319 * t503 + 0.17315859105681463759666483083807725165579399831905e2 * t506 * t507
  t511 = t220 * t510
  t514 = t33 * t94 * t244
  t525 = t425 * t247
  t527 = t296 * t329
  t531 = 0.1e1 / t7 / t6
  t532 = t200 * t531
  t535 = -0.58482236226346462072622386637590534819724553404280e0 * t339 * t448 - t453 + t201 * t511 + 0.24415263074675393406472461472505321282722606644045e-3 * t334 * t514 - t491 + 0.8e1 * t279 * t297 + 0.8e1 * t279 * t330 - 0.8e1 * t284 * t297 - 0.8e1 * t284 * t330 + t201 * t525 + 0.2e1 * t201 * t527 + 0.20e2 * t532 * t248
  t536 = t439 + t535
  t540 = t66 * t65
  t542 = t14 * t111
  t545 = t78 * t111
  t548 = t14 * t129
  t551 = t139 * t111
  t554 = t78 * t129
  t557 = t14 * t179
  t560 = f.p.zeta_threshold ** 2
  t561 = t203 ** 2
  t562 = f.my_piecewise3(t204, t560, t561)
  t563 = t562 * t18
  t565 = 0.1e1 / t50 * t30
  t566 = t563 * t565
  t567 = 0.1e1 / t203
  t568 = t567 ** (0.1e1 / 0.3e1)
  t569 = t568 ** 2
  t570 = 0.1e1 / t569
  t571 = t42 * t570
  t572 = t35 * t216
  t574 = t358 * t572 * t568
  t576 = 0.1e1 - 0.56675000000000000000000000000000000000000000000000e-2 * t574
  t578 = t41 * t16
  t579 = t216 ** 2
  t580 = t43 * t579
  t584 = 0.1e1 + 0.10797500000000000000000000000000000000000000000000e0 * t574 + 0.10000000000000000000000000000000000000000000000000e-1 * t578 * t580 * t569
  t585 = 0.1e1 / t584
  t586 = t576 * t585
  t587 = t571 * t586
  t589 = t566 * t587 / 0.30e2
  t590 = t210 ** 2
  t591 = f.my_piecewise3(t211, t560, t590)
  t592 = t591 * t18
  t593 = t592 * t565
  t594 = 0.1e1 / t210
  t595 = t594 ** (0.1e1 / 0.3e1)
  t596 = t595 ** 2
  t597 = 0.1e1 / t596
  t598 = t42 * t597
  t600 = t358 * t572 * t595
  t602 = 0.1e1 - 0.56675000000000000000000000000000000000000000000000e-2 * t600
  t607 = 0.1e1 + 0.10797500000000000000000000000000000000000000000000e0 * t600 + 0.10000000000000000000000000000000000000000000000000e-1 * t578 * t580 * t596
  t608 = 0.1e1 / t607
  t609 = t602 * t608
  t610 = t598 * t609
  t612 = t593 * t610 / 0.30e2
  t615 = -0.97000000000000000000000000000000000000000000000000e-1 * t60 + 0.16900000000000000000000000000000000000000000000000e0 * t45
  t616 = t14 * t615
  t618 = jnp.exp(-0.13675000000000000000000000000000000000000000000000e0 * t60)
  t619 = t616 * t618
  t621 = t30 / t40
  t623 = t621 * t32 * t42
  t626 = t205 ** 2
  t627 = t626 * t560
  t629 = f.my_piecewise3(t204, t627, t403 * t561)
  t631 = f.my_piecewise3(t211, t627, t414 * t590)
  t634 = (t629 / 0.2e1 + t631 / 0.2e1) * t18
  t635 = t565 * t42
  t638 = t589 + t612 + t619 * t623 / 0.3e1 - t634 * t635 / 0.15e2
  t645 = f.my_piecewise3(t204, 0, 0.2e1 * t203 * t287)
  t646 = t645 * t18
  t647 = t646 * t565
  t649 = t647 * t587 / 0.30e2
  t650 = t35 * t570
  t651 = t650 * t586
  t653 = t566 * t651 / 0.45e2
  t654 = t563 * t635
  t656 = 0.1e1 / t569 / t567
  t657 = t656 * t576
  t658 = 0.1e1 / t561
  t659 = t585 * t658
  t660 = t659 * t287
  t661 = t657 * t660
  t663 = t654 * t661 / 0.45e2
  t664 = t53 * t216
  t666 = t358 * t664 * t568
  t668 = t216 * t570
  t669 = t658 * t287
  t670 = t668 * t669
  t671 = t60 * t670
  t673 = 0.18891666666666666666666666666666666666666666666667e-2 * t666 + 0.18891666666666666666666666666666666666666666666667e-2 * t671
  t674 = t673 * t585
  t675 = t571 * t674
  t677 = t566 * t675 / 0.30e2
  t678 = t584 ** 2
  t679 = 0.1e1 / t678
  t680 = t576 * t679
  t683 = t87 * t579
  t688 = t579 / t568
  t689 = t688 * t669
  t692 = -0.35991666666666666666666666666666666666666666666667e-1 * t666 - 0.35991666666666666666666666666666666666666666666667e-1 * t671 - 0.66666666666666666666666666666666666666666666666667e-2 * t578 * t683 * t569 - 0.66666666666666666666666666666666666666666666666667e-2 * t45 * t689
  t693 = t680 * t692
  t694 = t571 * t693
  t696 = t566 * t694 / 0.30e2
  t699 = f.my_piecewise3(t211, 0, 0.2e1 * t210 * t291)
  t700 = t699 * t18
  t701 = t700 * t565
  t703 = t701 * t610 / 0.30e2
  t704 = t35 * t597
  t705 = t704 * t609
  t707 = t593 * t705 / 0.45e2
  t708 = t592 * t635
  t710 = 0.1e1 / t596 / t594
  t711 = t710 * t602
  t712 = 0.1e1 / t590
  t713 = t608 * t712
  t714 = t713 * t291
  t715 = t711 * t714
  t717 = t708 * t715 / 0.45e2
  t719 = t358 * t664 * t595
  t721 = t216 * t597
  t722 = t712 * t291
  t723 = t721 * t722
  t724 = t60 * t723
  t726 = 0.18891666666666666666666666666666666666666666666667e-2 * t719 + 0.18891666666666666666666666666666666666666666666667e-2 * t724
  t727 = t726 * t608
  t728 = t598 * t727
  t730 = t593 * t728 / 0.30e2
  t731 = t607 ** 2
  t732 = 0.1e1 / t731
  t733 = t602 * t732
  t740 = t579 / t595
  t741 = t740 * t722
  t744 = -0.35991666666666666666666666666666666666666666666667e-1 * t719 - 0.35991666666666666666666666666666666666666666666667e-1 * t724 - 0.66666666666666666666666666666666666666666666666667e-2 * t578 * t683 * t596 - 0.66666666666666666666666666666666666666666666666667e-2 * t45 * t741
  t745 = t733 * t744
  t746 = t598 * t745
  t748 = t593 * t746 / 0.30e2
  t749 = t78 * t615
  t750 = t749 * t618
  t755 = 0.32333333333333333333333333333333333333333333333333e-1 * t266 - 0.11266666666666666666666666666666666666666666666667e0 * t89
  t756 = t14 * t755
  t757 = t756 * t618
  t760 = t616 * t39
  t762 = 0.1e1 / t21 * t16
  t764 = t762 * t43 * t618
  t767 = t621 * t59
  t770 = t403 * t203
  t773 = f.my_piecewise3(t204, 0, 0.8e1 / 0.3e1 * t770 * t287)
  t774 = t414 * t210
  t777 = f.my_piecewise3(t211, 0, 0.8e1 / 0.3e1 * t774 * t291)
  t780 = (t773 / 0.2e1 + t777 / 0.2e1) * t18
  t783 = t565 * t35
  t786 = t649 + t653 + t663 + t677 - t696 + t703 + t707 + t717 + t730 - t748 + t750 * t623 / 0.3e1 + t757 * t623 / 0.3e1 + 0.60777777777777777777777777777777777777777777777777e-1 * t760 * t764 + 0.2e1 / 0.9e1 * t619 * t767 - t780 * t635 / 0.15e2 - 0.2e1 / 0.45e2 * t634 * t783
  t791 = t711 * t732
  t792 = t722 * t744
  t793 = t791 * t792
  t795 = 0.2e1 / 0.45e2 * t708 * t793
  t796 = t657 * t679
  t797 = t669 * t692
  t798 = t796 * t797
  t800 = 0.2e1 / 0.45e2 * t654 * t798
  t801 = t749 * t39
  t806 = -0.43111111111111111111111111111111111111111111111111e-1 * t386 + 0.18777777777777777777777777777777777777777777777778e0 * t153
  t807 = t14 * t806
  t808 = t807 * t618
  t811 = t139 * t615
  t812 = t811 * t618
  t815 = t78 * t755
  t816 = t815 * t618
  t820 = 0.1e1 / t731 / t607
  t822 = t744 ** 2
  t823 = t602 * t820 * t822
  t824 = t598 * t823
  t826 = t593 * t824 / 0.15e2
  t828 = 0.1e1 / t678 / t584
  t830 = t692 ** 2
  t831 = t576 * t828 * t830
  t832 = t571 * t831
  t834 = t566 * t832 / 0.15e2
  t835 = t726 * t732
  t836 = t835 * t744
  t837 = t598 * t836
  t839 = t593 * t837 / 0.15e2
  t840 = t94 * t216
  t842 = t358 * t840 * t595
  t844 = t266 * t723
  t846 = t216 * t710
  t847 = t590 ** 2
  t848 = 0.1e1 / t847
  t849 = t848 * t416
  t850 = t846 * t849
  t851 = t60 * t850
  t854 = 0.1e1 / t590 / t210
  t855 = t854 * t416
  t856 = t721 * t855
  t857 = t60 * t856
  t859 = t712 * t419
  t860 = t721 * t859
  t861 = t60 * t860
  t863 = t117 * t579
  t871 = t579 / t595 / t594
  t872 = t871 * t849
  t875 = t740 * t855
  t878 = t740 * t859
  t881 = 0.47988888888888888888888888888888888888888888888889e-1 * t842 + 0.23994444444444444444444444444444444444444444444444e-1 * t844 - 0.23994444444444444444444444444444444444444444444445e-1 * t851 + 0.71983333333333333333333333333333333333333333333334e-1 * t857 - 0.35991666666666666666666666666666666666666666666667e-1 * t861 + 0.11111111111111111111111111111111111111111111111111e-1 * t578 * t863 * t596 + 0.88888888888888888888888888888888888888888888888890e-2 * t89 * t741 - 0.22222222222222222222222222222222222222222222222222e-2 * t45 * t872 + 0.13333333333333333333333333333333333333333333333333e-1 * t45 * t875 - 0.66666666666666666666666666666666666666666666666667e-2 * t45 * t878
  t882 = t733 * t881
  t883 = t598 * t882
  t885 = t593 * t883 / 0.30e2
  t887 = t701 * t746 / 0.15e2
  t888 = t756 * t39
  t891 = -t795 - t800 + 0.12155555555555555555555555555555555555555555555555e0 * t801 * t764 + t808 * t623 / 0.3e1 + t812 * t623 / 0.3e1 + 0.2e1 / 0.3e1 * t816 * t623 + t826 + t834 - t839 - t885 - t887 + 0.12155555555555555555555555555555555555555555555555e0 * t888 * t764
  t896 = t621 * t54
  t899 = t12 * t618
  t903 = t608 * t854 * t416
  t904 = t711 * t903
  t906 = 0.2e1 / 0.45e2 * t708 * t904
  t908 = 0.1e1 / t561 / t203
  t910 = t585 * t908 * t405
  t911 = t657 * t910
  t913 = 0.2e1 / 0.45e2 * t654 * t911
  t914 = t700 * t635
  t916 = 0.2e1 / 0.45e2 * t914 * t715
  t917 = t592 * t783
  t919 = 0.4e1 / 0.135e3 * t917 * t715
  t920 = t710 * t726
  t921 = t920 * t714
  t923 = 0.2e1 / 0.45e2 * t708 * t921
  t924 = t713 * t419
  t925 = t711 * t924
  t927 = t708 * t925 / 0.45e2
  t929 = 0.1e1 / t596 / t712
  t930 = t929 * t602
  t931 = t608 * t848
  t932 = t931 * t416
  t933 = t930 * t932
  t935 = t708 * t933 / 0.27e2
  t936 = t563 * t783
  t938 = 0.4e1 / 0.135e3 * t936 * t661
  t939 = 0.4e1 / 0.9e1 * t750 * t767 + 0.4e1 / 0.9e1 * t757 * t767 - 0.2e1 / 0.27e2 * t619 * t896 + 0.33245444444444444444444444444444444444444444444444e-1 * t616 * t899 - t906 - t913 + t916 + t919 + t923 + t927 + t935 + t938
  t941 = t656 * t673
  t942 = t941 * t660
  t944 = 0.2e1 / 0.45e2 * t654 * t942
  t945 = t659 * t409
  t946 = t657 * t945
  t948 = t654 * t946 / 0.45e2
  t950 = 0.1e1 / t569 / t658
  t951 = t950 * t576
  t952 = t561 ** 2
  t953 = 0.1e1 / t952
  t954 = t585 * t953
  t955 = t954 * t405
  t956 = t951 * t955
  t958 = t654 * t956 / 0.27e2
  t959 = t646 * t635
  t961 = 0.2e1 / 0.45e2 * t959 * t661
  t964 = t565 * t53
  t972 = f.my_piecewise3(t204, 0, 0.40e2 / 0.9e1 * t403 * t405 + 0.8e1 / 0.3e1 * t770 * t409)
  t978 = f.my_piecewise3(t211, 0, 0.40e2 / 0.9e1 * t414 * t416 + 0.8e1 / 0.3e1 * t774 * t419)
  t981 = (t972 / 0.2e1 + t978 / 0.2e1) * t18
  t985 = 0.2e1 / 0.45e2 * t647 * t651
  t989 = f.my_piecewise3(t204, 0, 0.2e1 * t203 * t409 + 0.2e1 * t405)
  t990 = t989 * t18
  t991 = t990 * t565
  t993 = t991 * t587 / 0.30e2
  t995 = t647 * t675 / 0.15e2
  t996 = t650 * t674
  t998 = 0.2e1 / 0.45e2 * t566 * t996
  t1000 = t358 * t840 * t568
  t1002 = t266 * t670
  t1004 = t216 * t656
  t1005 = t953 * t405
  t1006 = t1004 * t1005
  t1007 = t60 * t1006
  t1009 = t908 * t405
  t1010 = t668 * t1009
  t1011 = t60 * t1010
  t1013 = t658 * t409
  t1014 = t668 * t1013
  t1015 = t60 * t1014
  t1017 = -0.25188888888888888888888888888888888888888888888889e-2 * t1000 - 0.12594444444444444444444444444444444444444444444445e-2 * t1002 + 0.12594444444444444444444444444444444444444444444445e-2 * t1007 - 0.37783333333333333333333333333333333333333333333334e-2 * t1011 + 0.18891666666666666666666666666666666666666666666667e-2 * t1015
  t1018 = t1017 * t585
  t1019 = t571 * t1018
  t1021 = t566 * t1019 / 0.30e2
  t1022 = t944 + t948 + t958 + t961 - 0.4e1 / 0.45e2 * t780 * t783 + 0.2e1 / 0.135e3 * t634 * t964 - t981 * t635 / 0.15e2 + t985 + t993 + t995 + t998 + t1021
  t1026 = f.my_piecewise3(t211, 0, 0.2e1 * t210 * t419 + 0.2e1 * t416)
  t1027 = t1026 * t18
  t1028 = t1027 * t565
  t1033 = t704 * t727
  t1041 = -0.25188888888888888888888888888888888888888888888889e-2 * t842 - 0.12594444444444444444444444444444444444444444444445e-2 * t844 + 0.12594444444444444444444444444444444444444444444445e-2 * t851 - 0.37783333333333333333333333333333333333333333333334e-2 * t857 + 0.18891666666666666666666666666666666666666666666667e-2 * t861
  t1042 = t1041 * t608
  t1043 = t598 * t1042
  t1046 = t53 * t597
  t1047 = t1046 * t609
  t1052 = t53 * t570
  t1053 = t1052 * t586
  t1056 = t704 * t745
  t1071 = t579 / t568 / t567
  t1072 = t1071 * t1005
  t1075 = t688 * t1009
  t1078 = t688 * t1013
  t1081 = 0.47988888888888888888888888888888888888888888888889e-1 * t1000 + 0.23994444444444444444444444444444444444444444444444e-1 * t1002 - 0.23994444444444444444444444444444444444444444444445e-1 * t1007 + 0.71983333333333333333333333333333333333333333333334e-1 * t1011 - 0.35991666666666666666666666666666666666666666666667e-1 * t1015 + 0.11111111111111111111111111111111111111111111111111e-1 * t578 * t863 * t569 + 0.88888888888888888888888888888888888888888888888890e-2 * t89 * t689 - 0.22222222222222222222222222222222222222222222222222e-2 * t45 * t1072 + 0.13333333333333333333333333333333333333333333333333e-1 * t45 * t1075 - 0.66666666666666666666666666666666666666666666666667e-2 * t45 * t1078
  t1082 = t680 * t1081
  t1083 = t571 * t1082
  t1086 = t650 * t693
  t1089 = t673 * t679
  t1090 = t1089 * t692
  t1091 = t571 * t1090
  t1096 = t1028 * t610 / 0.30e2 + t701 * t728 / 0.15e2 + 0.2e1 / 0.45e2 * t593 * t1033 + t593 * t1043 / 0.30e2 - t593 * t1047 / 0.135e3 + 0.2e1 / 0.45e2 * t701 * t705 - t566 * t1053 / 0.135e3 - 0.2e1 / 0.45e2 * t593 * t1056 - t566 * t1083 / 0.30e2 - 0.2e1 / 0.45e2 * t566 * t1086 - t566 * t1091 / 0.15e2 - t647 * t694 / 0.15e2
  t1098 = t891 + t939 + t1022 + t1096
  t1112 = -0.52629732327660179956916004458792505225000000000000e0 * t155 * t542 + 0.52629732327660179956916004458792505225000000000000e0 * t91 * t545 + 0.52629732327660179956916004458792505225000000000000e0 * t91 * t548 - 0.26314866163830089978458002229396252612500000000000e0 * t48 * t551 - 0.52629732327660179956916004458792505225000000000000e0 * t48 * t554 - 0.26314866163830089978458002229396252612500000000000e0 * t48 * t557 - 0.16889345248872318972700803464104647715469565281367e-1 * t106 * t108 * t638 * jnp.pi + 0.12667008936654239229525602598078485786602173961026e-1 * t106 * t117 * t786 * jnp.pi - 0.38001026809962717688576807794235457359806521883077e-2 * t106 * t87 * t1098 * jnp.pi + 0.13287210228946179141882035000000000000000000000000e1 * t51 * t159 * t252 - 0.11389037339096724978756030000000000000000000000000e1 * t51 * t95 * t344 + 0.42708890021612718670335112500000000000000000000000e0 * t51 * t54 * t536
  t1115 = 0.1e1 / t2 / jnp.pi
  t1116 = t1115 * t73
  t1117 = t1116 * t14
  t1118 = t63 * t64
  t1121 = t1115 * t12
  t1122 = t1121 * t78
  t1125 = t1121 * t14
  t1126 = t99 * t64
  t1129 = t1115 * t158
  t1130 = t14 * t57
  t1134 = t58 * t32 * t62 * t64
  t1137 = t1115 * t47
  t1138 = t1137 * t139
  t1141 = t1137 * t78
  t1144 = t1115 * t94
  t1145 = t78 * t57
  t1149 = t1137 * t14
  t1150 = t163 * t64
  t1153 = t14 * t98
  t1157 = t1115 * t108
  t1161 = t41 * t16 * t62 * t64
  t1166 = -0.12375000000000000000000000000000000000000000000000e1 * t60 + t45 / 0.4e1
  t1167 = t14 * t1166
  t1169 = jnp.exp(-0.77500000000000000000000000000000000000000000000000e-1 * t60)
  t1170 = t1169 * jnp.pi
  t1171 = t1170 * t5
  t1174 = t589 + t612 + 0.4e1 / 0.3e1 * t1167 * t1171
  t1176 = t64 * t2
  t1180 = t78 * t1166
  t1185 = 0.41250000000000000000000000000000000000000000000000e0 * t266 - t89 / 0.6e1
  t1186 = t14 * t1185
  t1189 = t1167 * t58
  t1190 = t59 * t1170
  t1195 = t649 + t653 + t663 + t677 - t696 + t703 + t707 + t717 + t730 - t748 + 0.4e1 / 0.3e1 * t1180 * t1171 + 0.4e1 / 0.3e1 * t1186 * t1171 + 0.34444444444444444444444444444444444444444444444444e-1 * t1189 * t1190 + 0.4e1 / 0.3e1 * t1167 * t1170
  t1204 = t139 * t1166
  t1207 = t78 * t1185
  t1210 = -t795 - t800 + 0.8e1 / 0.3e1 * t1186 * t1170 + 0.8e1 / 0.3e1 * t1180 * t1170 + t826 + t834 - t839 - t885 - t887 + 0.4e1 / 0.3e1 * t1204 * t1171 + 0.8e1 / 0.3e1 * t1207 * t1171
  t1213 = -0.55000000000000000000000000000000000000000000000000e0 * t386 + 0.5e1 / 0.18e2 * t153
  t1214 = t14 * t1213
  t1217 = t1180 * t58
  t1220 = t1186 * t58
  t1223 = t1167 * t41
  t1224 = t88 * t1170
  t1227 = t54 * t1170
  t1230 = 0.4e1 / 0.3e1 * t1214 * t1171 + 0.68888888888888888888888888888888888888888888888888e-1 * t1217 * t1190 + 0.68888888888888888888888888888888888888888888888888e-1 * t1220 * t1190 + 0.35592592592592592592592592592592592592592592592591e-2 * t1223 * t1224 + 0.22962962962962962962962962962962962962962962962963e-1 * t1189 * t1227 - t906 - t913 + t916 + t919 + t923 + t927
  t1232 = t935 + t938 + t944 + t948 + t958 + t961 + t985 + t993 + t995 + t998 + t1021
  t1234 = t1210 + t1230 + t1232 + t1096
  t1239 = -0.35086488218440119971277336305861670150000000000000e0 * t1117 * t1118 + 0.35086488218440119971277336305861670150000000000000e0 * t1122 * t1118 + 0.35086488218440119971277336305861670150000000000000e0 * t1125 * t1126 + 0.36665380188269925369984816439625445306750000000000e-1 * t1129 * t1130 * t1134 - 0.17543244109220059985638668152930835075000000000000e0 * t1138 * t1118 - 0.35086488218440119971277336305861670150000000000000e0 * t1141 * t1126 - 0.21999228112961955221990889863775267184050000000000e-1 * t1144 * t1145 * t1134 - 0.17543244109220059985638668152930835075000000000000e0 * t1149 * t1150 - 0.21999228112961955221990889863775267184050000000000e-1 * t1144 * t1153 * t1134 - 0.27587032053654291848376575889174185048798700000000e-2 * t1157 * t1130 * t1161 - 0.13511476199097855178160642771283718172375652225094e-1 * t106 * t108 * t1174 * t1176 + 0.10133607149323391383620482078462788629281739168821e-1 * t106 * t117 * t1195 * t1176 - 0.30400821447970174150861446235388365887845217506462e-2 * t106 * t87 * t1234 * t1176
  t1240 = t65 * f.p.cam_omega
  t1242 = t16 * t108
  t1244 = t105 * t1242 * t14
  t1245 = t1176 * t67
  t1246 = t63 * t1245
  t1249 = f.my_piecewise3(t204, t626, t403)
  t1250 = f.my_piecewise3(t211, t626, t414)
  t1252 = t1249 / 0.2e1 + t1250 / 0.2e1
  t1253 = t1252 ** 2
  t1254 = t1253 * t1252
  t1255 = t22 - 0.1e1
  t1256 = 0.2e1 * t1255
  t1257 = t1254 * t1256
  t1258 = t1257 * t103
  t1259 = f.p.cam_omega * t262
  t1260 = 0.1e1 / t1252
  t1261 = t1259 * t1260
  t1263 = 0.48717083333333333333333333333333333333333333333333e0 * t1261 * t266
  t1264 = f.p.cam_omega * t187
  t1265 = 0.1e1 / t1253
  t1266 = 0.1e1 / t207
  t1269 = f.my_piecewise3(t204, 0, 0.2e1 / 0.3e1 * t1266 * t287)
  t1270 = 0.1e1 / t212
  t1273 = f.my_piecewise3(t211, 0, 0.2e1 / 0.3e1 * t1270 * t291)
  t1275 = t1269 / 0.2e1 + t1273 / 0.2e1
  t1278 = 0.29230250000000000000000000000000000000000000000000e1 * t1264 * t1265 * t1275
  t1287 = (0.344851e1 - jnp.pi * t16 * t18 * t21 / t1255 / 0.12e2) * t65
  t1288 = t1287 * t30
  t1293 = t1287 * t58
  t1294 = 0.1e1 / t1254
  t1295 = t1294 * t1275
  t1296 = t59 * t1295
  t1299 = t1240 * t187
  t1300 = t1299 * t1294
  t1303 = t1240 * t377
  t1304 = t1253 ** 2
  t1305 = 0.1e1 / t1304
  t1306 = t1305 * t1275
  t1309 = -t1263 - t1278 - t1288 * t33 * t53 * t1265 / 0.12e2 - t1293 * t1296 / 0.2e1 - 0.24484000000000000000000000000000000000000000000000e0 * t1300 * t266 - 0.14690400000000000000000000000000000000000000000000e1 * t1303 * t1306
  t1311 = 0.29230250000000000000000000000000000000000000000000e1 * t1264 * t1260
  t1312 = t65 * t30
  t1313 = t1312 * t21
  t1317 = 0.1e1 + t1311 + 0.86212750000000000000000000000000000000000000000000e0 * t1313 * t59 * t1265
  t1318 = 0.1e1 / t1317
  t1326 = 0.1e1 + t1311 + t1288 * t33 * t35 * t1265 / 0.4e1 + 0.48968000000000000000000000000000000000000000000000e0 * t1303 * t1294
  t1327 = t1317 ** 2
  t1328 = 0.1e1 / t1327
  t1329 = t1326 * t1328
  t1335 = -t1263 - t1278 - 0.28737583333333333333333333333333333333333333333333e0 * t1313 * t54 * t1265 - 0.17242550000000000000000000000000000000000000000000e1 * t1313 * t1296
  t1337 = t1309 * t1318 - t1329 * t1335
  t1338 = 0.1e1 / t1326
  t1339 = t1337 * t1338
  t1342 = t1252 * t1256
  t1344 = jnp.log(t1326 * t1318)
  t1345 = t103 * t1344
  t1346 = t1275 ** 2
  t1350 = f.p.cam_omega * t378
  t1351 = t1350 * t1260
  t1353 = 0.32478055555555555555555555555555555555555555555555e0 * t1351 * t153
  t1355 = t1259 * t1265 * t30
  t1357 = t33 * t53 * t1275
  t1359 = 0.97434166666666666666666666666666666666666666666666e0 * t1355 * t1357
  t1361 = 0.64956111111111111111111111111111111111111111111111e0 * t1261 * t386
  t1364 = 0.58460500000000000000000000000000000000000000000000e1 * t1264 * t1294 * t1346
  t1365 = 0.1e1 / t208
  t1371 = f.my_piecewise3(t204, 0, -0.2e1 / 0.9e1 * t1365 * t405 + 0.2e1 / 0.3e1 * t1266 * t409)
  t1372 = 0.1e1 / t213
  t1378 = f.my_piecewise3(t211, 0, -0.2e1 / 0.9e1 * t1372 * t416 + 0.2e1 / 0.3e1 * t1270 * t419)
  t1380 = t1371 / 0.2e1 + t1378 / 0.2e1
  t1383 = 0.29230250000000000000000000000000000000000000000000e1 * t1264 * t1265 * t1380
  t1388 = t54 * t1295
  t1391 = t1305 * t1346
  t1392 = t59 * t1391
  t1395 = t1294 * t1380
  t1396 = t59 * t1395
  t1399 = t1240 * t262
  t1400 = t1399 * t1294
  t1404 = t1299 * t1305 * t30
  t1410 = 0.1e1 / t1304 / t1252
  t1417 = -t1353 + t1359 + t1361 + t1364 - t1383 + t1288 * t33 * t94 * t1265 / 0.9e1 + t1293 * t1388 / 0.3e1 + 0.3e1 / 0.2e1 * t1293 * t1392 - t1293 * t1396 / 0.2e1 + 0.16322666666666666666666666666666666666666666666667e0 * t1400 * t153 + 0.14690400000000000000000000000000000000000000000000e1 * t1404 * t1357 + 0.32645333333333333333333333333333333333333333333333e0 * t1300 * t386 + 0.58761600000000000000000000000000000000000000000000e1 * t1303 * t1410 * t1346 - 0.14690400000000000000000000000000000000000000000000e1 * t1303 * t1305 * t1380
  t1419 = t1309 * t1328
  t1423 = 0.1e1 / t1327 / t1317
  t1424 = t1326 * t1423
  t1425 = t1335 ** 2
  t1437 = -t1353 + t1359 + t1361 + t1364 - t1383 + 0.38316777777777777777777777777777777777777777777777e0 * t1313 * t95 * t1265 + 0.11495033333333333333333333333333333333333333333333e1 * t1313 * t1388 + 0.51727650000000000000000000000000000000000000000000e1 * t1313 * t1392 - 0.17242550000000000000000000000000000000000000000000e1 * t1313 * t1396
  t1439 = t1417 * t1318 - t1329 * t1437 - 0.2e1 * t1419 * t1335 + 0.2e1 * t1424 * t1425
  t1440 = t1439 * t1338
  t1444 = t105 * t88 * t14
  t1445 = t163 * t1245
  t1448 = 0.23720747615136194550778824449265695623422695046375e-1 * t15 * t69 - 0.10166034692201226236048067621113869552895440734161e-1 * t79 * t69 - 0.10166034692201226236048067621113869552895440734161e-1 * t82 * t100 + (-0.45038253996992850593868809237612393907918840750312e-1 * t106 * t109 * t112 + 0.33778690497744637945401606928209295430939130562734e-1 * t106 * t118 * t112 + 0.33778690497744637945401606928209295430939130562734e-1 * t106 * t122 * t130 - 0.10133607149323391383620482078462788629281739168820e-1 * t106 * t140 * t112 - 0.20267214298646782767240964156925577258563478337640e-1 * t106 * t144 * t130 - 0.10133607149323391383620482078462788629281739168820e-1 * t106 * t148 * t180 + 0.31577839396596107974149602675275503135000000000000e1 * t184 * t252 - 0.21051892931064071982766401783517002090000000000000e1 * t255 * t344 + 0.52629732327660179956916004458792505225000000000000e0 * t347 * t536) * t540 + t1112 * t66 + t1239 * t1240 - 0.30025502664661900395912539491741595938612560500208e-1 * t1244 * t1246 + t1258 * t1339 * t1335 + 0.6e1 * t1342 * t1345 * t1346 + t1258 * t1440 * t1317 - 0.67557380995489275890803213856418590861878261125470e-2 * t1444 * t1445
  t1450 = 0.1e1 / t34 / t7
  t1451 = t4 * t1450
  t1452 = t1130 * t30
  t1455 = t62 * t64 * t67
  t1456 = t33 * t1455
  t1460 = t105 * t152 * t78
  t1464 = t105 * t152 * t14
  t1465 = t99 * t1245
  t1469 = t105 * t88 * t139
  t1473 = t105 * t88 * t78
  t1476 = t1253 * t1256
  t1481 = t66 ** 2
  t1490 = 0.1e1 / t42 / t7
  t1495 = t1326 ** 2
  t1496 = 0.1e1 / t1495
  t1497 = t1337 * t1496
  t1498 = t1317 * t1309
  t1501 = t1476 * t103
  t1502 = t1317 * t1275
  t1506 = -0.31870518760050844250010691992191981048327206701594e-3 * t1451 * t1452 * t1456 + 0.22519126998496425296934404618806196953959420375156e-1 * t1460 * t1246 + 0.22519126998496425296934404618806196953959420375156e-1 * t1464 * t1465 - 0.67557380995489275890803213856418590861878261125470e-2 * t1469 * t1246 - 0.13511476199097855178160642771283718172375652225094e-1 * t1473 * t1465 + 0.3e1 * t1476 * t1345 * t1380 + 0.20267214298646782767240964156925577258563478337641e-1 * t106 * t117 * t536 * t1481 - 0.10809180959278284142528514217026974537900521780075e0 * t106 * t108 * t344 * t1481 + 0.19816831758676854261302276064549453319484289930138e0 * t106 * t1490 * t252 * t1481 - t1258 * t1497 * t1498 + 0.6e1 * t1501 * t1339 * t1502
  t1507 = t1448 + t1506
  t1511 = 0.1e1 + 0.15403623315025000000000000000000000000000000000000e0 * t41 * t44 * t65
  t1512 = t1511 ** 2
  t1513 = t1512 ** 2
  t1514 = 0.1e1 / t1513
  t1594 = 0.3e1 * t1476 * t1345 * t1275 + t1258 * t1339 * t1317 + (0.17543244109220059985638668152930835075000000000000e0 * t1125 * t1118 - 0.17543244109220059985638668152930835075000000000000e0 * t1141 * t1118 - 0.17543244109220059985638668152930835075000000000000e0 * t1149 * t1126 - 0.10999614056480977610995444931887633592025000000000e-1 * t1144 * t1130 * t1134 + 0.50668035746616956918102410392313943146408695844103e-2 * t106 * t117 * t1174 * t1176 - 0.30400821447970174150861446235388365887845217506462e-2 * t106 * t87 * t1195 * t1176) * t1240 + (0.26314866163830089978458002229396252612500000000000e0 * t91 * t542 - 0.26314866163830089978458002229396252612500000000000e0 * t48 * t545 - 0.26314866163830089978458002229396252612500000000000e0 * t48 * t548 + 0.63335044683271196147628012990392428933010869805128e-2 * t106 * t117 * t638 * jnp.pi - 0.38001026809962717688576807794235457359806521883077e-2 * t106 * t87 * t786 * jnp.pi - 0.56945186695483624893780150000000000000000000000000e0 * t51 * t95 * t252 + 0.42708890021612718670335112500000000000000000000000e0 * t51 * t54 * t344) * t66 + 0.11259563499248212648467202309403098476979710187578e-1 * t1464 * t1246 - 0.67557380995489275890803213856418590861878261125470e-2 * t1473 * t1246 - 0.67557380995489275890803213856418590861878261125470e-2 * t1444 * t1465 - 0.50830173461006131180240338105569347764477203670804e-2 * t82 * t69 + (0.16889345248872318972700803464104647715469565281367e-1 * t106 * t122 * t112 - 0.10133607149323391383620482078462788629281739168820e-1 * t106 * t144 * t112 - 0.10133607149323391383620482078462788629281739168820e-1 * t106 * t148 * t130 - 0.10525946465532035991383200891758501045000000000000e1 * t255 * t252 + 0.52629732327660179956916004458792505225000000000000e0 * t347 * t344) * t540 - 0.54045904796391420712642571085134872689502608900376e-1 * t106 * t108 * t252 * t1481 + 0.20267214298646782767240964156925577258563478337641e-1 * t106 * t117 * t344 * t1481
  t1596 = 0.1e1 / t1513 / t1511
  t1636 = t1257 * t1345 + (-0.17543244109220059985638668152930835075000000000000e0 * t1149 * t1118 - 0.30400821447970174150861446235388365887845217506462e-2 * t106 * t87 * t1174 * t1176) * t1240 + (-0.26314866163830089978458002229396252612500000000000e0 * t48 * t542 - 0.38001026809962717688576807794235457359806521883077e-2 * t106 * t87 * t638 * jnp.pi + 0.42708890021612718670335112500000000000000000000000e0 * t51 * t54 * t252) * t66 - 0.67557380995489275890803213856418590861878261125470e-2 * t1444 * t1246 + (-0.10133607149323391383620482078462788629281739168820e-1 * t106 * t148 * t112 + 0.52629732327660179956916004458792505225000000000000e0 * t347 * t252) * t540 + 0.20267214298646782767240964156925577258563478337641e-1 * t106 * t117 * t252 * t1481
  t1638 = 0.1e1 / t1513 / t1512
  t1665 = t4 * t283 * t14
  t1684 = t405 * t287
  t1690 = t10 * t8
  t1692 = 0.6e1 * t73 - 0.6e1 * t1690
  t1696 = f.my_piecewise3(t204, 0, -0.8e1 / 0.27e2 / t770 * t1684 + 0.4e1 / 0.3e1 * t404 * t287 * t409 + 0.4e1 / 0.3e1 * t207 * t1692)
  t1698 = t416 * t291
  t1704 = -t1692
  t1708 = f.my_piecewise3(t211, 0, -0.8e1 / 0.27e2 / t774 * t1698 + 0.4e1 / 0.3e1 * t415 * t291 * t419 + 0.4e1 / 0.3e1 * t212 * t1704)
  t1710 = (t1696 + t1708) * t219
  t1722 = t11 * t283
  t1728 = t371 * t273
  t1731 = 0.96491876992155210400537781394436278372632330568306e2 * t186 / t368 / t193 * t1728 * t373
  t1734 = 0.60000000000000000000000000000000000000000000000000e1 * t488 * t396 * t273
  t1735 = -0.32530743900905219527896202567159734993471782831130e-1 * t399 * t54 * t355 + 0.16265371950452609763948101283579867496735891415565e-1 * t399 * t54 * t448 + 0.48159733137676571081572406076840235616767705782485e0 * t399 * t54 * t433 - 0.21687162600603479685264135044773156662314521887420e-1 * t399 * t95 * t341 + 0.32530743900905219527896202567159734993471782831130e-1 * t296 * t58 * t400 + 0.19751673498613801407483339618206552048944131217655e-1 * t1710 * t245 - 0.24e2 * t284 * t527 - 0.120e3 * t200 / t7 / t72 * t248 + 0.24e2 * t1690 * t248 - 0.144e3 * t1722 * t248 - t1731 - t1734
  t1739 = 0.48245938496077605200268890697218139186316165284153e2 * t370 * t273 * t373 * t395
  t1765 = t432 * t446
  t1772 = t1739 - 0.12e2 * t284 * t525 - 0.12e2 * t284 * t511 + 0.60e2 * t532 * t330 + 0.60e2 * t532 * t297 + 0.12e2 * t279 * t525 + 0.3e1 * t201 * t425 * t329 + 0.240e3 * t278 * t531 * t248 + t201 * t1710 * t247 - 0.56968947174242584615102410102512416326352748836105e-3 * t334 * t33 * t158 * t244 + 0.73245789224026180219417384417515963848167819932136e-3 * t348 * t514 - 0.51947577317044391278999449251423175496738199495715e2 * t339 * t429 * t324 * t1765 - 0.54934341918019635164563038313136972886125864949102e-3 * t425 * t30 * t336
  t1781 = 0.71233333333333333333333333333333333333333333333331e-1 * t358 * t94 * t260 * t275
  t1785 = 0.10685000000000000000000000000000000000000000000000e0 * t358 * t53 * t487 * t489
  t1789 = 0.85917975471764868594145516183295969534298037676861e0 * t358 * t53 * t369 * t374
  t1792 = 0.53424999999999999999999999999999999999999999999999e-1 * t358 * t359 * t396
  t1795 = t353 * t324
  t1819 = 0.1e1 / t428 / t317
  t1822 = 0.1e1 / t431 / t243
  t1826 = t464 * t309
  t1832 = 0.1e1 / t187 / t45 / 0.4e1
  t1834 = t1832 * t20 * t8
  t1836 = t380 * t108
  t1837 = t379 * t1836
  t1839 = t33 * t158
  t1840 = t263 * t1839
  t1842 = t58 * t159
  t1844 = t60 ** (-0.15e1)
  t1846 = t1844 * t20 * t8
  t1848 = t389 * t1836
  t1850 = t269 * t1839
  t1852 = t41 * t1242
  t1859 = 0.1e1 / t428 / t240
  t1872 = -0.34523333333333333333333333333333333333333333333333e1 * t1834 + 0.23015555555555555555555555555555555555555555555556e1 * t1837 - 0.26851481481481481481481481481481481481481481481482e1 * t1840 - 0.93932222222222222222222222222222222222222222222223e0 * t1842 + 0.73355000000000000000000000000000000000000000000000e-1 * t1846 - 0.14671000000000000000000000000000000000000000000000e0 * t1848 - 0.17116166666666666666666666666666666666666666666667e0 * t1850 - 0.36793333333333333333333333333333333333333333333333e0 * t1852
  t1890 = 0.35089341735807877243573431982554320891834732042568e1 * t506 * t1795 * t325 - 0.35089341735807877243573431982554320891834732042568e1 * t499 * t326 * t446 + 0.56968947174242584615102410102512416326352748836105e-3 * t58 * t159 * t244 - 0.60000000000000000000000000000000000000000000000000e1 * t463 * t311 * t474 + 0.51947577317044391278999449251423175496738199495715e2 * t506 * t1765 * t324 + 0.96491876992155210400537781394436278372632330568306e2 * t480 * t474 * t482 * t309 + 0.16562821945185185185185185185185185185185185185185e-2 * t58 * t159 * t231 + 0.10254018858216406658218194626490193680059335835414e4 * t235 * t1819 * t1795 * t1822 + 0.60000000000000000000000000000000000000000000000000e1 * t480 * t1826 * t310 + 0.10000000000000000000000000000000000000000000000000e1 * t304 * (-0.47063000000000000000000000000000000000000000000000e1 * t1834 + 0.31375333333333333333333333333333333333333333333334e1 * t1837 - 0.36604555555555555555555555555555555555555555555556e1 * t1840 - 0.16068111111111111111111111111111111111111111111111e1 * t1842 + 0.28051666666666666666666666666666666666666666666666e0 * t1846 - 0.56103333333333333333333333333333333333333333333332e0 * t1848 - 0.65453888888888888888888888888888888888888888888890e0 * t1850 - 0.46308888888888888888888888888888888888888888888888e0 * t1852) * t310 - 0.10389515463408878255799889850284635099347639899143e3 * t235 * t1859 * t1795 * t432 + 0.58482236226346462072622386637590534819724553404280e0 * t319 * t1872 * t325 + 0.20690405167709360119593700880421107356354650655085e4 * t222 / t478 / t302 * t1826 / t481 / t230 - 0.19298375398431042080107556278887255674526466113661e3 * t222 / t478 / t227 * t1826 * t482 + t1731 + t1734
  t1923 = 0.34450798614814814814814814814814814814814814814813e-2 * t58 * t159 * t197
  t1935 = 0.10000000000000000000000000000000000000000000000000e1 * t261 * (-0.25319000000000000000000000000000000000000000000000e1 * t1834 + 0.16879333333333333333333333333333333333333333333333e1 * t1837 - 0.19692555555555555555555555555555555555555555555555e1 * t1840 - 0.93011851851851851851851851851851851851851851851854e0 * t1842 + 0.13651666666666666666666666666666666666666666666667e0 * t1846 - 0.27303333333333333333333333333333333333333333333333e0 * t1848 - 0.31853888888888888888888888888888888888888888888890e0 * t1850 - 0.36514074074074074074074074074074074074074074074075e0 * t1852) * t274
  t1943 = 0.51726012919273400298984252201052768390886626637712e3 * t186 / t368 / t259 * t1728 / t372 / t196
  t1946 = 0.60000000000000000000000000000000000000000000000000e1 * t370 * t1728 * t274
  t1947 = -t1739 - 0.51369999999999999999999999999999999999999999999999e-1 * t358 * t457 * t475 - 0.16522625736956710527585419434107305400007076070979e1 * t358 * t53 * t479 * t483 - t1781 - t1785 + t1789 + t1792 + 0.21687162600603479685264135044773156662314521887420e-1 * t358 * t94 * t318 * t326 - 0.16265371950452609763948101283579867496735891415565e-1 * t358 * t495 * t503 - 0.48159733137676571081572406076840235616767705782485e0 * t358 * t53 * t429 * t507 + 0.10274000000000000000000000000000000000000000000000e0 * t358 * t53 * t462 * t465 + 0.32530743900905219527896202567159734993471782831130e-1 * t358 * t53 * t352 * t500 + 0.68493333333333333333333333333333333333333333333332e-1 * t358 * t94 * t303 * t311 - t1923 - t1935 - t1943 - t1946
  t1961 = 0.35089341735807877243573431982554320891834732042568e1 * t339 * t352 * t324 * t503 + t1781 + t1785 - t1789 - t1792 + 0.12e2 * t279 * t511 + t201 * t220 * (t1890 + t1947) + 0.36e2 * t137 * t330 - 0.96e2 * t365 * t330 + 0.36e2 * t137 * t297 - 0.96e2 * t365 * t297 + 0.24e2 * t279 * t527
  t1990 = 0.10389515463408878255799889850284635099347639899143e3 * t339 * t1859 * t1795 * t432 + 0.35089341735807877243573431982554320891834732042568e1 * t436 * t355 + 0.3e1 * t201 * t296 * t510 + t1923 + t1935 + t1943 + t1946 - 0.35089341735807877243573431982554320891834732042568e1 * t339 * t429 * t1795 * t325 - 0.58482236226346462072622386637590534819724553404280e0 * t339 * t318 * t1872 * t325 - 0.17544670867903938621786715991277160445917366021284e1 * t425 * t235 * t341 - 0.51947577317044391278999449251423175496738199495715e2 * t436 * t433 - 0.10254018858216406658218194626490193680059335835414e4 * t339 * t1819 * t1795 * t1822 - 0.17544670867903938621786715991277160445917366021284e1 * t436 * t448
  t1992 = t1735 + t1772 + t1961 + t1990
  t1999 = t1342 * t103
  t2009 = 0.12991222222222222222222222222222222222222222222222e1 * t1351 * t1852
  t2011 = 0.15156425925925925925925925925925925925925925925926e1 * t1261 * t1842
  t2024 = 0.19486833333333333333333333333333333333333333333333e1 * f.p.cam_omega * t1832 * t1260 * t20 * t8
  t2027 = 0.17538150000000000000000000000000000000000000000000e2 * t1264 * t1295 * t1380
  t2033 = t1346 * t1275
  t2036 = 0.17538150000000000000000000000000000000000000000000e2 * t1264 * t1305 * t2033
  t2052 = f.my_piecewise3(t204, 0, 0.8e1 / 0.27e2 / t207 / t561 * t1684 - 0.2e1 / 0.3e1 * t1365 * t287 * t409 + 0.2e1 / 0.3e1 * t1266 * t1692)
  t2063 = f.my_piecewise3(t211, 0, 0.8e1 / 0.27e2 / t212 / t590 * t1698 - 0.2e1 / 0.3e1 * t1372 * t291 * t419 + 0.2e1 / 0.3e1 * t1270 * t1704)
  t2065 = t2052 / 0.2e1 + t2063 / 0.2e1
  t2068 = 0.29230250000000000000000000000000000000000000000000e1 * t1264 * t1265 * t2065
  t2072 = -0.65290666666666666666666666666666666666666666666667e0 * t1400 * t1852 - 0.76172444444444444444444444444444444444444444444444e0 * t1300 * t1842 + t2009 - t2011 - 0.7e1 / 0.27e2 * t1288 * t33 * t158 * t1265 + 0.9e1 / 0.2e1 * t1293 * t59 * t1306 * t1380 - t2024 + t2027 + 0.32645333333333333333333333333333333333333333333334e0 * t1240 * t378 * t1294 * t20 * t8 - t2036 - 0.29380800000000000000000000000000000000000000000000e2 * t1303 / t1304 / t1253 * t2033 - t2068 - 0.14690400000000000000000000000000000000000000000000e1 * t1303 * t1305 * t2065
  t2078 = t33 * t94 * t1275
  t2081 = t95 * t1295
  t2084 = t54 * t1395
  t2088 = t59 * t1294 * t2065
  t2094 = t380 * t117 * t1275
  t2098 = t33 * t53 * t1380
  t2104 = 0.97434166666666666666666666666666666666666666666666e0 * t1350 * t1265 * t39 * t2094
  t2106 = 0.14615125000000000000000000000000000000000000000000e1 * t1355 * t2098
  t2107 = t54 * t1391
  t2111 = t59 * t1410 * t2033
  t2117 = t33 * t53 * t1346
  t2123 = 0.29230250000000000000000000000000000000000000000000e1 * t1259 * t1294 * t30 * t2117
  t2125 = 0.19486833333333333333333333333333333333333333333333e1 * t1355 * t2078
  t2126 = 0.17628480000000000000000000000000000000000000000000e2 * t1303 * t1410 * t1275 * t1380 - 0.29380800000000000000000000000000000000000000000000e1 * t1404 * t2078 - 0.2e1 / 0.3e1 * t1293 * t2081 + t1293 * t2084 / 0.2e1 - t1293 * t2088 / 0.2e1 - 0.14690400000000000000000000000000000000000000000000e1 * t1399 * t1305 * t39 * t2094 + 0.22035600000000000000000000000000000000000000000000e1 * t1404 * t2098 + t2104 + t2106 - 0.3e1 / 0.2e1 * t1293 * t2107 - 0.6e1 * t1293 * t2111 - 0.88142400000000000000000000000000000000000000000000e1 * t1299 * t1410 * t30 * t2117 - t2123 - t2125
  t2137 = t1327 ** 2
  t2165 = -t2024 - t2036 + t2027 - t2068 - 0.89405814814814814814814814814814814814814814814813e0 * t1313 * t159 * t1265 - 0.22990066666666666666666666666666666666666666666666e1 * t1313 * t2081 + 0.17242550000000000000000000000000000000000000000000e1 * t1313 * t2084 - 0.17242550000000000000000000000000000000000000000000e1 * t1313 * t2088 + t2104 + t2009 + t2106 - t2011 - t2123 - t2125 - 0.51727649999999999999999999999999999999999999999999e1 * t1313 * t2107 - 0.20691060000000000000000000000000000000000000000000e2 * t1313 * t2111 + 0.15518295000000000000000000000000000000000000000000e2 * t1312 * t33 * t35 * t1305 * t1275 * t1380
  t2213 = 0.1e1 / t42 / t282
  t2221 = 0.28683466884045759825009622792972782943494486031434e-2 * t4 / t34 / t282 * t1452 * t1456 - 0.95611556280152532750032075976575943144981620104783e-3 * t1451 * t1145 * t30 * t1456 - 0.95611556280152532750032075976575943144981620104783e-3 * t1451 * t1153 * t30 * t1456 + 0.33778690497744637945401606928209295430939130562734e-1 * t1464 * t1445 + 0.11009350977042696811834597813638585177491272183410e0 * t105 * t16 * t1490 * t14 * t1246 - 0.90076507993985701187737618475224787815837681500624e-1 * t105 * t1242 * t78 * t1246 - 0.90076507993985701187737618475224787815837681500624e-1 * t1244 * t1465 + 0.2e1 * t1258 * t1440 * t1335 + 0.59450495276030562783906828193648359958452869790413e0 * t106 * t1490 * t344 * t1481 - 0.92478548207158653219410621634564115490926686340644e0 * t106 * t2213 * t252 * t1481 + 0.6e1 * t2033 * t1256 * t1345
  t2226 = t1309 ** 2
  t2262 = 0.12e2 * t73 - 0.36e2 * t1690 + 0.24e2 * t1722
  t2276 = t20 * t8
  t2278 = t32 * t1450
  t2282 = (0.7e1 / 0.27e2 * t31 * t1839 - 0.60688888888888888888888888888888888888888888888888e-1 * t1852 + 0.57465000000000000000000000000000000000000000000000e-1 * t2276 - 0.36147222222222222222222222222222222222222222222223e-2 * t51 * t2278) * t62
  t2307 = t2282 / 0.2e1 + 0.94050000000000000000000000000000000000000000000000e-1 * t162 * t30 * t21 * t126 - 0.12540000000000000000000000000000000000000000000000e0 * t166 * t169 + 0.23587740000000000000000000000000000000000000000000e-1 * t98 * t39 * t40 * t174 + 0.97533333333333333333333333333333333333333333333333e-1 * t125 * t159 * t62 - 0.31450320000000000000000000000000000000000000000000e-1 * t173 * t1242 * t62 + 0.59158051920000000000000000000000000000000000000000e-2 * t57 * t20 * t8 * t62 - 0.6e1 * t73 + 0.18e2 * t1690 - 0.12e2 * t1722
  t2321 = 0.16514026465564045217751896720457877766236908275114e0 * t106 * t1490 * t14 * t112 - 0.13511476199097855178160642771283718172375652225094e0 * t106 * t108 * t78 * t112 - 0.13511476199097855178160642771283718172375652225094e0 * t106 * t109 * t130 + 0.50668035746616956918102410392313943146408695844101e-1 * t106 * t117 * t139 * t112 + 0.10133607149323391383620482078462788629281739168820e0 * t106 * t118 * t130 + 0.50668035746616956918102410392313943146408695844101e-1 * t106 * t122 * t180 - 0.10133607149323391383620482078462788629281739168820e-1 * t106 * t87 * t2262 * t112 - 0.30400821447970174150861446235388365887845217506460e-1 * t106 * t140 * t130 - 0.30400821447970174150861446235388365887845217506460e-1 * t106 * t144 * t180 - 0.10133607149323391383620482078462788629281739168820e-1 * t106 * t148 * t2307 * jnp.pi - 0.12631135758638443189659841070110201254000000000000e2 * t103 * t283 * t252 + 0.94733518189788323922448808025826509405000000000000e1 * t184 * t344 - 0.31577839396596107974149602675275503135000000000000e1 * t255 * t536 + 0.52629732327660179956916004458792505225000000000000e0 * t347 * t1992
  t2385 = f.my_piecewise3(t204, 0, 0.80e2 / 0.27e2 * t1266 * t1684 + 0.40e2 / 0.3e1 * t403 * t287 * t409 + 0.8e1 / 0.3e1 * t770 * t1692)
  t2394 = f.my_piecewise3(t211, 0, 0.80e2 / 0.27e2 * t1270 * t1698 + 0.40e2 / 0.3e1 * t414 * t291 * t419 + 0.8e1 / 0.3e1 * t774 * t1704)
  t2403 = 0.2e1 / 0.15e2 * t654 * t657 * t954 * t1684
  t2406 = 0.2e1 / 0.15e2 * t654 * t941 * t910
  t2410 = t708 * t929 * t726 * t932 / 0.9e1
  t2414 = t708 * t711 * t713 * t1704 / 0.45e2
  t2419 = 0.1e1 / t847 / t590
  t2424 = 0.8e1 / 0.81e2 * t708 / t596 / t854 * t602 * t608 * t2419 * t1698
  t2427 = 0.4e1 / 0.45e2 * t646 * t783 * t661
  t2429 = 0.4e1 / 0.45e2 * t936 * t942
  t2431 = 0.2e1 / 0.45e2 * t936 * t946
  t2433 = 0.2e1 / 0.27e2 * t936 * t956
  t2435 = t762 * t87 * t618
  t2444 = 0.2e1 / 0.45e2 * t780 * t964 - 0.8e1 / 0.405e3 * t634 * t565 * t94 - 0.2e1 / 0.15e2 * t981 * t783 - (t2385 / 0.2e1 + t2394 / 0.2e1) * t18 * t635 / 0.15e2 + t2403 - t2406 + t2410 + t2414 + t2424 + t2427 + t2429 + t2431 + t2433 + 0.2e-50 * t801 * t2435 + 0.2e1 / 0.3e1 * t808 * t767 - 0.13506172839506172839506172839506172839506172839506e-1 * t760 * t762 * t117 * t618
  t2463 = 0.1e1 / t847 / t210
  t2464 = t2463 * t1698
  t2469 = t848 * t291 * t419
  t2473 = t848 * t1698
  t2478 = t854 * t291 * t419
  t2483 = t60 * t846 * t2464
  t2486 = t60 * t846 * t2469
  t2489 = t60 * t721 * t2473
  t2492 = t60 * t721 * t2478
  t2494 = t266 * t856
  t2496 = t386 * t723
  t2498 = -0.26666666666666666666666666666666666666666666666667e-1 * t89 * t875 + 0.13333333333333333333333333333333333333333333333333e-1 * t45 * t871 * t2464 - 0.66666666666666666666666666666666666666666666666666e-2 * t45 * t871 * t2469 - 0.39999999999999999999999999999999999999999999999999e-1 * t45 * t740 * t2473 + 0.39999999999999999999999999999999999999999999999999e-1 * t45 * t740 * t2478 + 0.14396666666666666666666666666666666666666666666667e0 * t2483 - 0.71983333333333333333333333333333333333333333333335e-1 * t2486 - 0.21595000000000000000000000000000000000000000000000e0 * t2489 + 0.21595000000000000000000000000000000000000000000000e0 * t2492 - 0.71983333333333333333333333333333333333333333333333e-1 * t2494 - 0.47988888888888888888888888888888888888888888888888e-1 * t2496
  t2499 = t266 * t860
  t2501 = t266 * t850
  t2504 = t2419 * t1698
  t2506 = t60 * t216 * t929 * t2504
  t2508 = t712 * t1704
  t2510 = t60 * t721 * t2508
  t2527 = t158 * t216
  t2529 = t358 * t2527 * t595
  t2531 = t108 * t579
  t2535 = 0.35991666666666666666666666666666666666666666666666e-1 * t2499 + 0.23994444444444444444444444444444444444444444444444e-1 * t2501 - 0.39990740740740740740740740740740740740740740740742e-1 * t2506 - 0.35991666666666666666666666666666666666666666666667e-1 * t2510 - 0.22222222222222222222222222222222222222222222222222e-1 * t153 * t741 + 0.13333333333333333333333333333333333333333333333334e-1 * t89 * t878 + 0.44444444444444444444444444444444444444444444444445e-2 * t89 * t872 - 0.29629629629629629629629629629629629629629629629629e-2 * t45 * t579 / t595 / t712 * t2504 - 0.66666666666666666666666666666666666666666666666667e-2 * t45 * t740 * t2508 - 0.11197407407407407407407407407407407407407407407407e0 * t2529 - 0.29629629629629629629629629629629629629629629629629e-1 * t578 * t2531 * t596
  t2540 = t593 * t598 * t733 * (t2498 + t2535) / 0.30e2
  t2541 = t731 ** 2
  t2548 = t593 * t598 * t602 / t2541 * t822 * t744 / 0.5e1
  t2549 = t678 ** 2
  t2556 = t566 * t571 * t576 / t2549 * t830 * t692 / 0.5e1
  t2561 = t593 * t598 * t1041 * t732 * t744 / 0.10e2
  t2565 = t593 * t598 * t835 * t881 / 0.10e2
  t2568 = t566 * t1052 * t693 / 0.45e2
  t2571 = 0.2e1 / 0.15e2 * t566 * t650 * t831
  t2576 = t566 * t571 * t673 * t828 * t830 / 0.5e1
  t2578 = t647 * t1083 / 0.10e2
  t2580 = t1028 * t746 / 0.10e2
  t2582 = t701 * t837 / 0.5e1
  t2584 = t701 * t883 / 0.10e2
  t2586 = t953 * t287 * t409
  t2590 = t953 * t1684
  t2595 = t908 * t287 * t409
  t2600 = t60 * t668 * t2590
  t2603 = t60 * t668 * t2595
  t2608 = 0.1e1 / t952 / t203
  t2609 = t2608 * t1684
  t2613 = t266 * t1010
  t2616 = t60 * t1004 * t2609
  t2619 = t60 * t1004 * t2586
  t2621 = t386 * t670
  t2623 = -0.66666666666666666666666666666666666666666666666666e-2 * t45 * t1071 * t2586 - 0.39999999999999999999999999999999999999999999999999e-1 * t45 * t688 * t2590 + 0.39999999999999999999999999999999999999999999999999e-1 * t45 * t688 * t2595 - 0.21595000000000000000000000000000000000000000000000e0 * t2600 + 0.21595000000000000000000000000000000000000000000000e0 * t2603 - 0.26666666666666666666666666666666666666666666666667e-1 * t89 * t1075 + 0.13333333333333333333333333333333333333333333333333e-1 * t45 * t1071 * t2609 - 0.71983333333333333333333333333333333333333333333333e-1 * t2613 + 0.14396666666666666666666666666666666666666666666667e0 * t2616 - 0.71983333333333333333333333333333333333333333333335e-1 * t2619 - 0.47988888888888888888888888888888888888888888888888e-1 * t2621
  t2624 = t266 * t1014
  t2626 = t266 * t1006
  t2630 = 0.1e1 / t952 / t561
  t2631 = t2630 * t1684
  t2633 = t60 * t216 * t950 * t2631
  t2635 = t658 * t1692
  t2637 = t60 * t668 * t2635
  t2658 = t358 * t2527 * t568
  t2660 = 0.35991666666666666666666666666666666666666666666666e-1 * t2624 + 0.23994444444444444444444444444444444444444444444444e-1 * t2626 - 0.39990740740740740740740740740740740740740740740742e-1 * t2633 - 0.35991666666666666666666666666666666666666666666667e-1 * t2637 - 0.22222222222222222222222222222222222222222222222222e-1 * t153 * t689 + 0.13333333333333333333333333333333333333333333333334e-1 * t89 * t1078 + 0.44444444444444444444444444444444444444444444444445e-2 * t89 * t1072 - 0.29629629629629629629629629629629629629629629629629e-2 * t45 * t579 / t568 / t658 * t2631 - 0.66666666666666666666666666666666666666666666666667e-2 * t45 * t688 * t2635 - 0.29629629629629629629629629629629629629629629629629e-1 * t578 * t2531 * t569 - 0.11197407407407407407407407407407407407407407407407e0 * t2658
  t2665 = t566 * t571 * t680 * (t2623 + t2660) / 0.30e2
  t2666 = 0.15154381759259259259259259259259259259259259259259e-2 * t616 * t158 * t58 * t32 * t618 + t2262 * t615 * t618 * t623 / 0.3e1 + t139 * t755 * t618 * t623 + 0.18233333333333333333333333333333333333333333333333e0 * t811 * t39 * t764 - t2540 - t2548 - t2556 - t2561 - t2565 + t2568 + t2571 + t2576 - t2578 - t2580 - t2582 - t2584 - t2665
  t2670 = 0.2e1 / 0.15e2 * t593 * t704 * t836
  t2673 = t593 * t704 * t882 / 0.15e2
  t2675 = 0.2e1 / 0.15e2 * t647 * t1086
  t2678 = 0.2e1 / 0.15e2 * t566 * t650 * t1090
  t2682 = t566 * t571 * t1089 * t1081 / 0.10e2
  t2685 = t593 * t1046 * t745 / 0.45e2
  t2688 = 0.2e1 / 0.15e2 * t593 * t704 * t823
  t2693 = t593 * t598 * t726 * t820 * t822 / 0.5e1
  t2695 = t991 * t694 / 0.10e2
  t2697 = t647 * t1091 / 0.5e1
  t2702 = t566 * t571 * t1017 * t679 * t692 / 0.10e2
  t2704 = t647 * t832 / 0.5e1
  t2707 = t566 * t650 * t1082 / 0.15e2
  t2709 = 0.2e1 / 0.15e2 * t701 * t1056
  t2711 = t701 * t824 / 0.5e1
  t2716 = t708 * t930 * t732 * t849 * t744 / 0.9e1
  t2717 = -t2670 - t2673 - t2675 - t2678 - t2682 + t2685 + t2688 + t2693 - t2695 - t2697 - t2702 + t2704 - t2707 - t2709 + t2711 - t2716
  t2719 = 0.2e1 / 0.15e2 * t959 * t798
  t2723 = 0.2e1 / 0.15e2 * t654 * t941 * t679 * t797
  t2727 = t654 * t796 * t1013 * t692 / 0.15e2
  t2729 = 0.2e1 / 0.15e2 * t959 * t942
  t2733 = t654 * t656 * t1017 * t660 / 0.15e2
  t2736 = t1027 * t635 * t715 / 0.15e2
  t2738 = 0.2e1 / 0.15e2 * t914 * t921
  t2740 = t914 * t925 / 0.15e2
  t2742 = t914 * t933 / 0.9e1
  t2744 = 0.4e1 / 0.45e2 * t917 * t921
  t2746 = 0.2e1 / 0.45e2 * t917 * t925
  t2748 = 0.2e1 / 0.27e2 * t917 * t933
  t2752 = t708 * t710 * t1041 * t714 / 0.15e2
  t2758 = t708 * t597 * t602 * t820 * t744 * t881 / 0.5e1
  t2764 = t654 * t570 * t576 * t828 * t1081 * t692 / 0.5e1
  t2767 = 0.2e1 / 0.135e3 * t563 * t964 * t661
  t2769 = 0.4e1 / 0.45e2 * t936 * t911
  t2770 = -t2719 - t2723 - t2727 + t2729 + t2733 + t2736 + t2738 + t2740 + t2742 + t2744 + t2746 + t2748 + t2752 + t2758 + t2764 - t2767 - t2769
  t2775 = 0.2e1 / 0.15e2 * t708 * t920 * t903
  t2780 = 0.2e1 / 0.9e1 * t708 * t930 * t608 * t2463 * t1698
  t2783 = 0.4e1 / 0.45e2 * t700 * t783 * t715
  t2785 = 0.2e1 / 0.15e2 * t914 * t904
  t2788 = 0.2e1 / 0.135e3 * t592 * t964 * t715
  t2790 = 0.4e1 / 0.45e2 * t917 * t904
  t2794 = 0.2e1 / 0.15e2 * t708 * t711 * t931 * t1698
  t2799 = 0.2e1 / 0.9e1 * t654 * t951 * t585 * t2608 * t1684
  t2801 = 0.2e1 / 0.15e2 * t959 * t911
  t2804 = t654 * t941 * t945 / 0.15e2
  t2808 = t654 * t950 * t673 * t955 / 0.9e1
  t2810 = t959 * t946 / 0.15e2
  t2814 = t654 * t657 * t659 * t1692 / 0.45e2
  t2816 = t959 * t956 / 0.9e1
  t2824 = 0.8e1 / 0.81e2 * t654 / t569 / t908 * t576 * t585 * t2630 * t1684
  t2827 = t990 * t635 * t661 / 0.15e2
  t2828 = -t2775 - t2780 + t2783 - t2785 - t2788 - t2790 + t2794 - t2799 - t2801 + t2804 + t2808 + t2810 + t2814 + t2816 + t2824 + t2827
  t2831 = t708 * t920 * t924 / 0.15e2
  t2851 = t708 * t930 * t608 * t2469 / 0.9e1
  t2853 = 0.2e1 / 0.15e2 * t914 * t793
  t2857 = 0.2e1 / 0.15e2 * t708 * t920 * t732 * t792
  t2861 = t708 * t791 * t859 * t744 / 0.15e2
  t2865 = t708 * t791 * t722 * t881 / 0.15e2
  t2882 = t2831 + t78 * t806 * t618 * t623 + 0.36466666666666666666666666666666666666666666666665e0 * t815 * t39 * t764 + t14 * (0.10059259259259259259259259259259259259259259259259e0 * t1842 - 0.50074074074074074074074074074074074074074074074075e0 * t1852) * t618 * t623 / 0.3e1 + 0.18233333333333333333333333333333333333333333333333e0 * t807 * t39 * t764 + t2851 - t2853 - t2857 - t2861 - t2865 + 0.99736333333333333333333333333333333333333333333330e-1 * t756 * t899 + 0.99736333333333333333333333333333333333333333333330e-1 * t749 * t899 - 0.66490888888888888888888888888888888888888888888888e-1 * t616 * t73 * t618 + 0.2e-50 * t888 * t2435 - 0.2e1 / 0.9e1 * t750 * t896 - 0.2e1 / 0.9e1 * t757 * t896 + 0.8e1 / 0.81e2 * t619 * t621 * t95
  t2891 = t654 * t796 * t669 * t1081 / 0.15e2
  t2896 = t654 * t951 * t679 * t1005 * t692 / 0.9e1
  t2900 = 0.2e1 / 0.15e2 * t654 * t657 * t585 * t2595
  t2904 = t654 * t951 * t585 * t2586 / 0.9e1
  t2906 = 0.4e1 / 0.45e2 * t917 * t793
  t2911 = 0.2e1 / 0.15e2 * t708 * t711 * t820 * t722 * t822
  t2915 = 0.2e1 / 0.15e2 * t708 * t791 * t855 * t744
  t2917 = 0.4e1 / 0.45e2 * t936 * t798
  t2922 = 0.2e1 / 0.15e2 * t654 * t657 * t828 * t669 * t830
  t2926 = 0.2e1 / 0.15e2 * t654 * t796 * t1009 * t692
  t2930 = 0.2e1 / 0.15e2 * t708 * t711 * t608 * t2478
  t2932 = t1028 * t705 / 0.15e2
  t2938 = f.my_piecewise3(t211, 0, 0.2e1 * t210 * t1704 + 0.6e1 * t291 * t419)
  t2942 = t2938 * t18 * t565 * t610 / 0.30e2
  t2944 = t1028 * t728 / 0.10e2
  t2945 = 0.2e1 / 0.3e1 * t812 * t767 + 0.4e1 / 0.3e1 * t816 * t767 - t2891 - t2896 - t2900 + t2904 - t2906 + t2911 + t2915 - t2917 + t2922 + t2926 - t2930 + t2932 + t2942 + t2944
  t2947 = t701 * t1047 / 0.45e2
  t2950 = t593 * t1046 * t727 / 0.45e2
  t2952 = t647 * t1053 / 0.45e2
  t2955 = t566 * t1052 * t674 / 0.45e2
  t2957 = 0.2e1 / 0.15e2 * t701 * t1033
  t2959 = t647 * t1019 / 0.10e2
  t2971 = 0.58774074074074074074074074074074074074074074074074e-2 * t2658 + 0.25188888888888888888888888888888888888888888888889e-2 * t2621 - 0.12594444444444444444444444444444444444444444444445e-2 * t2626 + 0.37783333333333333333333333333333333333333333333335e-2 * t2613 - 0.18891666666666666666666666666666666666666666666667e-2 * t2624 + 0.20990740740740740740740740740740740740740740740742e-2 * t2633 - 0.75566666666666666666666666666666666666666666666669e-2 * t2616 + 0.37783333333333333333333333333333333333333333333335e-2 * t2619 + 0.11335000000000000000000000000000000000000000000000e-1 * t2600 - 0.11335000000000000000000000000000000000000000000000e-1 * t2603 + 0.18891666666666666666666666666666666666666666666667e-2 * t2637
  t2975 = t566 * t571 * t2971 * t585 / 0.30e2
  t2977 = t701 * t1043 / 0.10e2
  t2989 = 0.58774074074074074074074074074074074074074074074074e-2 * t2529 + 0.25188888888888888888888888888888888888888888888889e-2 * t2496 - 0.12594444444444444444444444444444444444444444444445e-2 * t2501 + 0.37783333333333333333333333333333333333333333333335e-2 * t2494 - 0.18891666666666666666666666666666666666666666666667e-2 * t2499 + 0.20990740740740740740740740740740740740740740740742e-2 * t2506 - 0.75566666666666666666666666666666666666666666666669e-2 * t2483 + 0.37783333333333333333333333333333333333333333333335e-2 * t2486 + 0.11335000000000000000000000000000000000000000000000e-1 * t2489 - 0.11335000000000000000000000000000000000000000000000e-1 * t2492 + 0.18891666666666666666666666666666666666666666666667e-2 * t2510
  t2993 = t593 * t598 * t2989 * t608 / 0.30e2
  t2996 = t593 * t704 * t1042 / 0.15e2
  t3000 = 0.4e1 / 0.405e3 * t593 * t94 * t597 * t609
  t3004 = 0.4e1 / 0.405e3 * t566 * t94 * t570 * t586
  t3010 = f.my_piecewise3(t204, 0, 0.2e1 * t203 * t1692 + 0.6e1 * t287 * t409)
  t3014 = t3010 * t18 * t565 * t587 / 0.30e2
  t3016 = t991 * t675 / 0.10e2
  t3019 = t566 * t650 * t1018 / 0.15e2
  t3021 = t991 * t651 / 0.15e2
  t3023 = 0.2e1 / 0.15e2 * t647 * t996
  t3024 = -t2947 - t2950 - t2952 - t2955 + t2957 + t2959 + t2975 + t2977 + t2993 + t2996 + t3000 + t3004 + t3014 + t3016 + t3019 + t3021 + t3023
  t3058 = 0.78944598491490269935374006688188757837500000000000e0 * t91 * t557 - 0.26314866163830089978458002229396252612500000000000e0 * t48 * t2262 * t111 - 0.78944598491490269935374006688188757837500000000000e0 * t48 * t139 * t129 - 0.78944598491490269935374006688188757837500000000000e0 * t48 * t78 * t179 - 0.26314866163830089978458002229396252612500000000000e0 * t48 * t14 * t2307 - 0.15788919698298053987074801337637751567500000000000e1 * t155 * t545 - 0.15788919698298053987074801337637751567500000000000e1 * t155 * t548 + 0.78944598491490269935374006688188757837500000000000e0 * t91 * t551 + 0.15788919698298053987074801337637751567500000000000e1 * t91 * t554 - 0.38001026809962717688576807794235457359806521883077e-2 * t106 * t87 * (t2444 + t2666 + t2717 + t2770 + t2828 + t2882 + t2945 + t3024) * jnp.pi + 0.61927599245865169566569612701717041623388406031679e-1 * t106 * t1490 * t638 * jnp.pi - 0.50668035746616956918102410392313943146408695844103e-1 * t106 * t108 * t786 * jnp.pi + 0.19000513404981358844288403897117728679903260941539e-1 * t106 * t117 * t1098 * jnp.pi + 0.15788919698298053987074801337637751567500000000000e1 * t2276 * t542 + 0.42708890021612718670335112500000000000000000000000e0 * t51 * t54 * t1992 - 0.44290700763153930472940116666666666666666666666667e1 * t51 * t2278 * t252 - 0.17083556008645087468134045000000000000000000000000e1 * t51 * t95 * t536 + 0.39861630686838537425646105000000000000000000000000e1 * t51 * t159 * t344
  t3116 = 0.10525946465532035991383200891758501045000000000000e1 * t1115 * t8 * t14 * t1118 - 0.14421716207386170645527361132919341820655000000000e0 * t1115 * t1450 * t1130 * t1134 + 0.10999614056480977610995444931887633592025000000000e0 * t1129 * t1145 * t1134 + 0.10999614056480977610995444931887633592025000000000e0 * t1129 * t1153 * t1134 + 0.19310922437558004293863603122421929534159090000000e-1 * t1115 * t1490 * t1130 * t1161 - 0.32998842169442932832986334795662900776075000000000e-1 * t1144 * t139 * t57 * t1134 - 0.65997684338885865665972669591325801552150000000000e-1 * t1144 * t78 * t98 * t1134 - 0.82761096160962875545129727667522555146396100000000e-2 * t1157 * t1145 * t1161 - 0.32998842169442932832986334795662900776075000000000e-1 * t1144 * t14 * t162 * t1134 - 0.82761096160962875545129727667522555146396100000000e-2 * t1157 * t1153 * t1161 - 0.20756482917169489186718535699014656830716141880000e-2 * t1665 * t1118 - 0.52629732327660179956916004458792505225000000000000e0 * t1141 * t1150
  t3137 = t2403 - t2406 + t2410 + t2414 + t2424 + t2427 + t2429 + t2431 + t2433 - t2540 - t2548 - t2556 - t2561 - t2565 + t2568
  t3138 = t2571 + t2576 - t2578 - t2580 - t2582 - t2584 - t2665 - t2670 - t2673 - t2675 - t2678 - t2682 + t2685 + t2688 + t2693 - t2695
  t3140 = -t2697 - t2702 + t2704 - t2707 - t2709 + t2711 - t2716 - t2719 - t2723 - t2727 + t2729 + t2733 + t2736 + t2738 + t2740
  t3141 = t2742 + t2744 + t2746 + t2748 + t2752 + t2758 + t2764 - t2767 - t2769 - t2775 - t2780 + t2783 - t2785 - t2788 - t2790 + t2794
  t3144 = -t2799 - t2801 + t2804 + t2808 + t2810 + t2814 + t2816 + t2824 + t2827 + t2831 + t2851 - t2853 - t2857 - t2861 - t2865
  t3169 = 0.11033703703703703703703703703703703703703703703703e-2 * t1167 * t73 * t1169 + 0.8e1 * t1207 * t1170 + 0.4e1 * t1214 * t1170 + 0.4e1 * t1204 * t1170 + 0.4e1 / 0.3e1 * t14 * (0.12833333333333333333333333333333333333333333333333e1 * t1842 - 0.20e2 / 0.27e2 * t1852) * t1171 + 0.4e1 / 0.3e1 * t2262 * t1166 * t1171 + 0.4e1 * t139 * t1185 * t1171 + 0.4e1 * t78 * t1213 * t1171 - t2891 - t2896 - t2900 + t2904 - t2906 + t2911 + t2915 - t2917
  t3180 = t2922 + t2926 - t2930 + t2932 + t2942 + t2944 - t2947 - t2950 - t2952 - t2955 + t2957 + 0.20666666666666666666666666666666666666666666666667e0 * t1207 * t58 * t1190 + t2959 + 0.10333333333333333333333333333333333333333333333333e0 * t1214 * t58 * t1190 + 0.10333333333333333333333333333333333333333333333333e0 * t1204 * t58 * t1190 + t2975
  t3197 = 0.10677777777777777777777777777777777777777777777777e-1 * t1186 * t41 * t1224 + 0.10677777777777777777777777777777777777777777777777e-1 * t1180 * t41 * t1224 - 0.35592592592592592592592592592592592592592592592590e-2 * t1223 * t152 * t1170 - 0.30617283950617283950617283950617283950617283950617e-1 * t1189 * t95 * t1170 + t2977 + t2993 + 0.68888888888888888888888888888888888888888888888888e-1 * t1220 * t1227 + 0.68888888888888888888888888888888888888888888888888e-1 * t1217 * t1227 + t2996 + t3000 + t3004 + t3014 + t3016 + t3019 + t3021 + t3023
  t3217 = -0.17543244109220059985638668152930835075000000000000e0 * t1149 * t2282 * t64 - 0.17543244109220059985638668152930835075000000000000e0 * t1137 * t2262 * t1118 - 0.52629732327660179956916004458792505225000000000000e0 * t1138 * t1126 - 0.10525946465532035991383200891758501045000000000000e1 * t1116 * t78 * t1118 - 0.10525946465532035991383200891758501045000000000000e1 * t1117 * t1126 + 0.52629732327660179956916004458792505225000000000000e0 * t1121 * t139 * t1118 + 0.10525946465532035991383200891758501045000000000000e1 * t1122 * t1126 + 0.52629732327660179956916004458792505225000000000000e0 * t1125 * t1150 - 0.30400821447970174150861446235388365887845217506462e-2 * t106 * t87 * (t3137 + t3138 + t3140 + t3141 + t3144 + t3169 + t3180 + t3197) * t1176 + 0.15200410723985087075430723117694182943922608753231e-1 * t106 * t117 * t1234 * t1176 - 0.40534428597293565534481928313851154517126956675283e-1 * t106 * t108 * t1195 * t1176 + 0.49542079396692135653255690161373633298710724825345e-1 * t106 * t1490 * t1174 * t1176
  t3231 = t3058 * t66 + 0.9e1 * t1501 * t1440 * t1502 + 0.71162242845408583652336473347797086870268085139125e-1 * t9 * t78 * t69 + 0.71162242845408583652336473347797086870268085139125e-1 * t15 * t100 - 0.15249052038301839354072101431670804329343161101241e-1 * t74 * t139 * t69 - 0.30498104076603678708144202863341608658686322202483e-1 * t79 * t100 - 0.15249052038301839354072101431670804329343161101241e-1 * t82 * t163 * t68 + (t3116 + t3217) * t1240 + 0.3e1 * t1476 * t1345 * t2065 - 0.2e1 * t1258 * t1497 * t1335 * t1309 + 0.18e2 * t1999 * t1339 * t1317 * t1346
  d111 = 0.3e1 * t1507 * t1514 + 0.41076328840066666666666666666666666666666666666668e0 * t1594 * t1596 * t39 * t380 * t87 * t65 - 0.12654485932329694420840033333333333333333333333334e1 * t1636 * t1638 * t30 * t50 * t32 * t158 * t66 - 0.22820182688925925925925925925925925925925925925927e0 * t1636 * t1596 * t39 * t380 * t117 * t65 + t5 * (-0.2e1 * t1258 * t1439 * t1496 * t1498 + 0.9e1 * t1501 * t1339 * t1335 * t1275 - 0.16213771438917426213792771325540461806850782670113e0 * t106 * t108 * t536 * t1481 - 0.11747417866543639206099989251064915927790287070586e0 * t1665 * t69 + 0.20267214298646782767240964156925577258563478337641e-1 * t106 * t117 * t1992 * t1481 + t1258 * t1339 * t1437 + 0.18e2 * t1999 * t1344 * t1275 * t1380 + t1258 * ((t2072 + t2126) * t1318 - 0.3e1 * t1417 * t1328 * t1335 + 0.6e1 * t1309 * t1423 * t1425 - 0.3e1 * t1419 * t1437 - 0.6e1 * t1326 / t2137 * t1425 * t1335 + 0.6e1 * t1424 * t1335 * t1437 - t1329 * t2165) * t1338 * t1317 + 0.33778690497744637945401606928209295430939130562734e-1 * t105 * t152 * t139 * t1246 + 0.67557380995489275890803213856418590861878261125469e-1 * t1460 * t1465 + t2221 + 0.2e1 * t1258 * t1337 / t1495 / t1326 * t1317 * t2226 + 0.9e1 * t1501 * t1339 * t1317 * t1380 - t1258 * t1497 * t1317 * t1417 + t2321 * t540 - 0.9e1 * t1476 * t103 * t1337 * t1496 * t1317 * t1309 * t1275 - 0.67557380995489275890803213856418590861878261125470e-2 * t105 * t88 * t2262 * t1246 - 0.20267214298646782767240964156925577258563478337641e-1 * t1469 * t1465 - 0.20267214298646782767240964156925577258563478337641e-1 * t1473 * t1445 - 0.67557380995489275890803213856418590861878261125470e-2 * t1444 * t2282 * t1245 - 0.79931261050207517379026815516417488469204634407598e-4 * t4 * t2213 * t1130 * t39 * t380 * t1455 + t3231) * t1514 + 0.12322898652020000000000000000000000000000000000000e1 * t43 * t1507 * t1596 * t41 * t16 * t65 + 0.18981728898494541631260050000000000000000000000001e1 * t94 * t1594 * t1638 * t51 * t32 * t66 + 0.46781984291253493295036448407815560200000000000002e1 * t8 * t1636 / t1513 / t1512 / t1511 * t103 * t540

  res = {'v3rho3': d111}
  return res
