"""Generated from lda_c_pw_erf.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import jax.scipy.special as jsp_special
import scipy.special as sp_special
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  lda_c_pw_erf_mu = f.p.cam_omega

  lda_c_pw_erf_b0 = lambda rs: 0.784949 * rs

  lda_c_pw_erf_alpha = (4 / (9 * jnp.pi)) ** (1 / 3)

  lda_c_pw_erf_ac = 5.84605

  lda_c_pw_erf_c = 3.91744

  lda_c_pw_erf_d = 3.44851

  lda_c_pw_erf_phin = lambda n, z: 1 / 2 * ((1 + z) ** (n / 3) + (1 - z) ** (n / 3))

  lda_c_pw_erf_g0 = lambda rs: 1 / 2 * (1 + 0.0207 * rs + 0.08193 * rs ** 2 - 0.01277 * rs ** 3 + 0.001859 * rs ** 4) * jnp.exp(-0.7524 * rs)

  lda_c_pw_erf_D2 = lambda rs: jnp.exp(-0.547 * rs) * (-0.388 * rs + 0.676 * rs ** 2) / rs ** 2

  lda_c_pw_erf_D3 = lambda rs: jnp.exp(-0.31 * rs) * (-4.95 * rs + rs ** 2) / rs ** 3

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  lda_c_pw_erf_g1 = lambda rs: 2 ** (5 / 3) * (1 - 0.02267 * rs) / (5 * lda_c_pw_erf_alpha ** 2 * rs ** 2 * (1 + 0.4319 * rs + 0.04 * rs ** 2))

  lda_c_pw_erf_bc = lda_c_pw_erf_d - 3 * jnp.pi * lda_c_pw_erf_alpha / (4 * jnp.log(2) - 4)

  lda_c_pw_erf_g0c = lambda rs: lda_c_pw_erf_g0(rs) - 1 / 2

  lda_c_pw_erf_C3 = lambda rs, z: -(1 - z ** 2) * lda_c_pw_erf_g0(rs) / (jnp.sqrt(2 * jnp.pi) * rs ** 3)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  lda_c_pw_erf_c4_l = lambda rs, z: ((1 + z) / 2) ** 2 * lda_c_pw_erf_g1(rs * (2 / (1 + z)) ** (1 / 3)) + ((1 - z) / 2) ** 2 * lda_c_pw_erf_g1(rs * (2 / (1 - z)) ** (1 / 3)) + (1 - z ** 2) * lda_c_pw_erf_D2(rs) - lda_c_pw_erf_phin(8, z) / (5 * lda_c_pw_erf_alpha ** 2 * rs ** 2)

  lda_c_pw_erf_c5_l = lambda rs, z: ((1 + z) / 2) ** 2 * lda_c_pw_erf_g1(rs * (2 / (1 + z)) ** (1 / 3)) + ((1 - z) / 2) ** 2 * lda_c_pw_erf_g1(rs * (2 / (1 - z)) ** (1 / 3)) + (1 - z ** 2) * lda_c_pw_erf_D3(rs)

  lda_c_pw_erf_Q = lambda x: (2 * jnp.log(2) - 2) * jnp.log((1 + lda_c_pw_erf_ac * x + lda_c_pw_erf_bc * x ** 2 + lda_c_pw_erf_c * x ** 3) / (1 + lda_c_pw_erf_ac * x + lda_c_pw_erf_d * x ** 2)) / jnp.pi ** 2

  lda_c_pw_erf_C2 = lambda rs, z: -3 * (1 - z ** 2) * lda_c_pw_erf_g0c(rs) / (8 * rs ** 3)

  lda_c_pw_erf_a3 = lambda rs, z: lda_c_pw_erf_b0(rs) ** 8 * lda_c_pw_erf_C3(rs, z)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  lda_c_pw_erf_C4 = lambda rs, z: -9 * lda_c_pw_erf_c4_l(rs, z) / (64 * rs ** 3)

  lda_c_pw_erf_C5 = lambda rs, z: -9 * lda_c_pw_erf_c5_l(rs, z) / (40 * jnp.sqrt(2 * jnp.pi) * rs ** 3)

  lda_c_pw_erf_a4 = lambda rs, z: lda_c_pw_erf_b0(rs) ** 8 * lda_c_pw_erf_C2(rs, z) + 4 * lda_c_pw_erf_b0(rs) ** 6 * f_pw(rs, z)

  lda_c_pw_erf_a5 = lambda rs, z: lda_c_pw_erf_b0(rs) ** 8 * f_pw(rs, z)

  lda_c_pw_erf_a2 = lambda rs, z: 4 * lda_c_pw_erf_b0(rs) ** 6 * lda_c_pw_erf_C2(rs, z) + lda_c_pw_erf_b0(rs) ** 8 * lda_c_pw_erf_C4(rs, z) + 6 * lda_c_pw_erf_b0(rs) ** 4 * f_pw(rs, z)

  lda_c_pw_erf_a1 = lambda rs, z: 4 * lda_c_pw_erf_b0(rs) ** 6 * lda_c_pw_erf_C3(rs, z) + lda_c_pw_erf_b0(rs) ** 8 * lda_c_pw_erf_C5(rs, z)

  lda_c_pw_erf_f = lambda rs, z: f_pw(rs, z) - (lda_c_pw_erf_phin(2, z) ** 3 * lda_c_pw_erf_Q(lda_c_pw_erf_mu * jnp.sqrt(rs) / lda_c_pw_erf_phin(2, z)) + lda_c_pw_erf_a1(rs, z) * lda_c_pw_erf_mu ** 3 + lda_c_pw_erf_a2(rs, z) * lda_c_pw_erf_mu ** 4 + lda_c_pw_erf_a3(rs, z) * lda_c_pw_erf_mu ** 5 + lda_c_pw_erf_a4(rs, z) * lda_c_pw_erf_mu ** 6 + lda_c_pw_erf_a5(rs, z) * lda_c_pw_erf_mu ** 8) / (1 + lda_c_pw_erf_b0(rs) ** 2 * lda_c_pw_erf_mu ** 2) ** 4

  functional_body = lambda rs, z: lda_c_pw_erf_f(rs, z)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  lda_c_pw_erf_mu = f.p.cam_omega

  lda_c_pw_erf_b0 = lambda rs: 0.784949 * rs

  lda_c_pw_erf_alpha = (4 / (9 * jnp.pi)) ** (1 / 3)

  lda_c_pw_erf_ac = 5.84605

  lda_c_pw_erf_c = 3.91744

  lda_c_pw_erf_d = 3.44851

  lda_c_pw_erf_phin = lambda n, z: 1 / 2 * ((1 + z) ** (n / 3) + (1 - z) ** (n / 3))

  lda_c_pw_erf_g0 = lambda rs: 1 / 2 * (1 + 0.0207 * rs + 0.08193 * rs ** 2 - 0.01277 * rs ** 3 + 0.001859 * rs ** 4) * jnp.exp(-0.7524 * rs)

  lda_c_pw_erf_D2 = lambda rs: jnp.exp(-0.547 * rs) * (-0.388 * rs + 0.676 * rs ** 2) / rs ** 2

  lda_c_pw_erf_D3 = lambda rs: jnp.exp(-0.31 * rs) * (-4.95 * rs + rs ** 2) / rs ** 3

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  lda_c_pw_erf_g1 = lambda rs: 2 ** (5 / 3) * (1 - 0.02267 * rs) / (5 * lda_c_pw_erf_alpha ** 2 * rs ** 2 * (1 + 0.4319 * rs + 0.04 * rs ** 2))

  lda_c_pw_erf_bc = lda_c_pw_erf_d - 3 * jnp.pi * lda_c_pw_erf_alpha / (4 * jnp.log(2) - 4)

  lda_c_pw_erf_g0c = lambda rs: lda_c_pw_erf_g0(rs) - 1 / 2

  lda_c_pw_erf_C3 = lambda rs, z: -(1 - z ** 2) * lda_c_pw_erf_g0(rs) / (jnp.sqrt(2 * jnp.pi) * rs ** 3)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  lda_c_pw_erf_c4_l = lambda rs, z: ((1 + z) / 2) ** 2 * lda_c_pw_erf_g1(rs * (2 / (1 + z)) ** (1 / 3)) + ((1 - z) / 2) ** 2 * lda_c_pw_erf_g1(rs * (2 / (1 - z)) ** (1 / 3)) + (1 - z ** 2) * lda_c_pw_erf_D2(rs) - lda_c_pw_erf_phin(8, z) / (5 * lda_c_pw_erf_alpha ** 2 * rs ** 2)

  lda_c_pw_erf_c5_l = lambda rs, z: ((1 + z) / 2) ** 2 * lda_c_pw_erf_g1(rs * (2 / (1 + z)) ** (1 / 3)) + ((1 - z) / 2) ** 2 * lda_c_pw_erf_g1(rs * (2 / (1 - z)) ** (1 / 3)) + (1 - z ** 2) * lda_c_pw_erf_D3(rs)

  lda_c_pw_erf_Q = lambda x: (2 * jnp.log(2) - 2) * jnp.log((1 + lda_c_pw_erf_ac * x + lda_c_pw_erf_bc * x ** 2 + lda_c_pw_erf_c * x ** 3) / (1 + lda_c_pw_erf_ac * x + lda_c_pw_erf_d * x ** 2)) / jnp.pi ** 2

  lda_c_pw_erf_C2 = lambda rs, z: -3 * (1 - z ** 2) * lda_c_pw_erf_g0c(rs) / (8 * rs ** 3)

  lda_c_pw_erf_a3 = lambda rs, z: lda_c_pw_erf_b0(rs) ** 8 * lda_c_pw_erf_C3(rs, z)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  lda_c_pw_erf_C4 = lambda rs, z: -9 * lda_c_pw_erf_c4_l(rs, z) / (64 * rs ** 3)

  lda_c_pw_erf_C5 = lambda rs, z: -9 * lda_c_pw_erf_c5_l(rs, z) / (40 * jnp.sqrt(2 * jnp.pi) * rs ** 3)

  lda_c_pw_erf_a4 = lambda rs, z: lda_c_pw_erf_b0(rs) ** 8 * lda_c_pw_erf_C2(rs, z) + 4 * lda_c_pw_erf_b0(rs) ** 6 * f_pw(rs, z)

  lda_c_pw_erf_a5 = lambda rs, z: lda_c_pw_erf_b0(rs) ** 8 * f_pw(rs, z)

  lda_c_pw_erf_a2 = lambda rs, z: 4 * lda_c_pw_erf_b0(rs) ** 6 * lda_c_pw_erf_C2(rs, z) + lda_c_pw_erf_b0(rs) ** 8 * lda_c_pw_erf_C4(rs, z) + 6 * lda_c_pw_erf_b0(rs) ** 4 * f_pw(rs, z)

  lda_c_pw_erf_a1 = lambda rs, z: 4 * lda_c_pw_erf_b0(rs) ** 6 * lda_c_pw_erf_C3(rs, z) + lda_c_pw_erf_b0(rs) ** 8 * lda_c_pw_erf_C5(rs, z)

  lda_c_pw_erf_f = lambda rs, z: f_pw(rs, z) - (lda_c_pw_erf_phin(2, z) ** 3 * lda_c_pw_erf_Q(lda_c_pw_erf_mu * jnp.sqrt(rs) / lda_c_pw_erf_phin(2, z)) + lda_c_pw_erf_a1(rs, z) * lda_c_pw_erf_mu ** 3 + lda_c_pw_erf_a2(rs, z) * lda_c_pw_erf_mu ** 4 + lda_c_pw_erf_a3(rs, z) * lda_c_pw_erf_mu ** 5 + lda_c_pw_erf_a4(rs, z) * lda_c_pw_erf_mu ** 6 + lda_c_pw_erf_a5(rs, z) * lda_c_pw_erf_mu ** 8) / (1 + lda_c_pw_erf_b0(rs) ** 2 * lda_c_pw_erf_mu ** 2) ** 4

  functional_body = lambda rs, z: lda_c_pw_erf_f(rs, z)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  lda_c_pw_erf_mu = f.p.cam_omega

  lda_c_pw_erf_b0 = lambda rs: 0.784949 * rs

  lda_c_pw_erf_alpha = (4 / (9 * jnp.pi)) ** (1 / 3)

  lda_c_pw_erf_ac = 5.84605

  lda_c_pw_erf_c = 3.91744

  lda_c_pw_erf_d = 3.44851

  lda_c_pw_erf_phin = lambda n, z: 1 / 2 * ((1 + z) ** (n / 3) + (1 - z) ** (n / 3))

  lda_c_pw_erf_g0 = lambda rs: 1 / 2 * (1 + 0.0207 * rs + 0.08193 * rs ** 2 - 0.01277 * rs ** 3 + 0.001859 * rs ** 4) * jnp.exp(-0.7524 * rs)

  lda_c_pw_erf_D2 = lambda rs: jnp.exp(-0.547 * rs) * (-0.388 * rs + 0.676 * rs ** 2) / rs ** 2

  lda_c_pw_erf_D3 = lambda rs: jnp.exp(-0.31 * rs) * (-4.95 * rs + rs ** 2) / rs ** 3

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  lda_c_pw_erf_g1 = lambda rs: 2 ** (5 / 3) * (1 - 0.02267 * rs) / (5 * lda_c_pw_erf_alpha ** 2 * rs ** 2 * (1 + 0.4319 * rs + 0.04 * rs ** 2))

  lda_c_pw_erf_bc = lda_c_pw_erf_d - 3 * jnp.pi * lda_c_pw_erf_alpha / (4 * jnp.log(2) - 4)

  lda_c_pw_erf_g0c = lambda rs: lda_c_pw_erf_g0(rs) - 1 / 2

  lda_c_pw_erf_C3 = lambda rs, z: -(1 - z ** 2) * lda_c_pw_erf_g0(rs) / (jnp.sqrt(2 * jnp.pi) * rs ** 3)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  lda_c_pw_erf_c4_l = lambda rs, z: ((1 + z) / 2) ** 2 * lda_c_pw_erf_g1(rs * (2 / (1 + z)) ** (1 / 3)) + ((1 - z) / 2) ** 2 * lda_c_pw_erf_g1(rs * (2 / (1 - z)) ** (1 / 3)) + (1 - z ** 2) * lda_c_pw_erf_D2(rs) - lda_c_pw_erf_phin(8, z) / (5 * lda_c_pw_erf_alpha ** 2 * rs ** 2)

  lda_c_pw_erf_c5_l = lambda rs, z: ((1 + z) / 2) ** 2 * lda_c_pw_erf_g1(rs * (2 / (1 + z)) ** (1 / 3)) + ((1 - z) / 2) ** 2 * lda_c_pw_erf_g1(rs * (2 / (1 - z)) ** (1 / 3)) + (1 - z ** 2) * lda_c_pw_erf_D3(rs)

  lda_c_pw_erf_Q = lambda x: (2 * jnp.log(2) - 2) * jnp.log((1 + lda_c_pw_erf_ac * x + lda_c_pw_erf_bc * x ** 2 + lda_c_pw_erf_c * x ** 3) / (1 + lda_c_pw_erf_ac * x + lda_c_pw_erf_d * x ** 2)) / jnp.pi ** 2

  lda_c_pw_erf_C2 = lambda rs, z: -3 * (1 - z ** 2) * lda_c_pw_erf_g0c(rs) / (8 * rs ** 3)

  lda_c_pw_erf_a3 = lambda rs, z: lda_c_pw_erf_b0(rs) ** 8 * lda_c_pw_erf_C3(rs, z)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  lda_c_pw_erf_C4 = lambda rs, z: -9 * lda_c_pw_erf_c4_l(rs, z) / (64 * rs ** 3)

  lda_c_pw_erf_C5 = lambda rs, z: -9 * lda_c_pw_erf_c5_l(rs, z) / (40 * jnp.sqrt(2 * jnp.pi) * rs ** 3)

  lda_c_pw_erf_a4 = lambda rs, z: lda_c_pw_erf_b0(rs) ** 8 * lda_c_pw_erf_C2(rs, z) + 4 * lda_c_pw_erf_b0(rs) ** 6 * f_pw(rs, z)

  lda_c_pw_erf_a5 = lambda rs, z: lda_c_pw_erf_b0(rs) ** 8 * f_pw(rs, z)

  lda_c_pw_erf_a2 = lambda rs, z: 4 * lda_c_pw_erf_b0(rs) ** 6 * lda_c_pw_erf_C2(rs, z) + lda_c_pw_erf_b0(rs) ** 8 * lda_c_pw_erf_C4(rs, z) + 6 * lda_c_pw_erf_b0(rs) ** 4 * f_pw(rs, z)

  lda_c_pw_erf_a1 = lambda rs, z: 4 * lda_c_pw_erf_b0(rs) ** 6 * lda_c_pw_erf_C3(rs, z) + lda_c_pw_erf_b0(rs) ** 8 * lda_c_pw_erf_C5(rs, z)

  lda_c_pw_erf_f = lambda rs, z: f_pw(rs, z) - (lda_c_pw_erf_phin(2, z) ** 3 * lda_c_pw_erf_Q(lda_c_pw_erf_mu * jnp.sqrt(rs) / lda_c_pw_erf_phin(2, z)) + lda_c_pw_erf_a1(rs, z) * lda_c_pw_erf_mu ** 3 + lda_c_pw_erf_a2(rs, z) * lda_c_pw_erf_mu ** 4 + lda_c_pw_erf_a3(rs, z) * lda_c_pw_erf_mu ** 5 + lda_c_pw_erf_a4(rs, z) * lda_c_pw_erf_mu ** 6 + lda_c_pw_erf_a5(rs, z) * lda_c_pw_erf_mu ** 8) / (1 + lda_c_pw_erf_b0(rs) ** 2 * lda_c_pw_erf_mu ** 2) ** 4

  functional_body = lambda rs, z: lda_c_pw_erf_f(rs, z)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t8
  t10 = t6 * t9
  t11 = t4 * t10
  t13 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t11
  t14 = jnp.sqrt(t11)
  t17 = t11 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t8 ** 2
  t23 = 0.1e1 / t22
  t24 = t5 * t23
  t25 = t21 * t24
  t27 = 0.23615790870000000000000000000000000000000000000000e0 * t14 + 0.55771035800000000000000000000000000000000000000000e-1 * t11 + 0.12733319050000000000000000000000000000000000000000e-1 * t17 + 0.76629987700000000000000000000000000000000000000000e-2 * t25
  t29 = 0.1e1 + 0.1e1 / t27
  t30 = jnp.log(t29)
  t31 = t13 * t30
  t32 = r0 - r1
  t33 = t32 ** 2
  t34 = t33 ** 2
  t35 = t7 ** 2
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t38 = t34 * t37
  t39 = 0.1e1 / t7
  t40 = t32 * t39
  t41 = 0.1e1 + t40
  t42 = t41 <= f.p.zeta_threshold
  t43 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t44 = t43 * f.p.zeta_threshold
  t45 = t41 ** (0.1e1 / 0.3e1)
  t47 = f.my_piecewise3(t42, t44, t45 * t41)
  t48 = 0.1e1 - t40
  t49 = t48 <= f.p.zeta_threshold
  t50 = t48 ** (0.1e1 / 0.3e1)
  t52 = f.my_piecewise3(t49, t44, t50 * t48)
  t54 = 2 ** (0.1e1 / 0.3e1)
  t57 = 0.1e1 / (0.2e1 * t54 - 0.2e1)
  t58 = (t47 + t52 - 0.2e1) * t57
  t60 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t11
  t65 = 0.21947830050000000000000000000000000000000000000000e0 * t14 + 0.48171623250000000000000000000000000000000000000000e-1 * t11 + 0.13081894750000000000000000000000000000000000000000e-1 * t17 + 0.48591338250000000000000000000000000000000000000000e-2 * t25
  t67 = 0.1e1 + 0.1e1 / t65
  t68 = jnp.log(t67)
  t71 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t11
  t76 = 0.17489865900000000000000000000000000000000000000000e0 * t14 + 0.30591644850000000000000000000000000000000000000000e-1 * t11 + 0.37162376550000000000000000000000000000000000000000e-2 * t17 + 0.41939708850000000000000000000000000000000000000000e-2 * t25
  t78 = 0.1e1 + 0.1e1 / t76
  t79 = jnp.log(t78)
  t80 = t71 * t79
  t82 = -t60 * t68 + t31 - 0.58482233974552040708313425006184496242808878304904e0 * t80
  t83 = t58 * t82
  t84 = t38 * t83
  t86 = 0.58482233974552040708313425006184496242808878304904e0 * t58 * t80
  t87 = t45 ** 2
  t88 = t50 ** 2
  t90 = t87 / 0.2e1 + t88 / 0.2e1
  t91 = t90 ** 2
  t92 = t91 * t90
  t93 = jnp.log(0.2e1)
  t94 = t93 - 0.1e1
  t95 = 0.2e1 * t94
  t96 = t92 * t95
  t97 = f.p.cam_omega * t14
  t98 = 0.1e1 / t90
  t100 = 0.29230250000000000000000000000000000000000000000000e1 * t97 * t98
  t102 = 9 ** (0.1e1 / 0.3e1)
  t103 = t102 ** 2
  t111 = f.p.cam_omega ** 2
  t112 = (0.344851e1 - jnp.pi * t5 * t103 * t3 / t94 / 0.12e2) * t111
  t113 = t112 * t1
  t114 = t3 * t6
  t115 = 0.1e1 / t91
  t120 = t111 * f.p.cam_omega
  t122 = t120 * t14 * t11
  t123 = 0.1e1 / t92
  t126 = 0.1e1 + t100 + t113 * t114 * t9 * t115 / 0.4e1 + 0.48968000000000000000000000000000000000000000000000e0 * t122 * t123
  t128 = t111 * t1 * t3
  t132 = 0.1e1 + t100 + 0.86212750000000000000000000000000000000000000000000e0 * t128 * t10 * t115
  t133 = 0.1e1 / t132
  t135 = jnp.log(t126 * t133)
  t136 = jnp.pi ** 2
  t137 = 0.1e1 / t136
  t138 = t135 * t137
  t140 = jnp.sqrt(jnp.pi)
  t142 = 0.1e1 / t140 / jnp.pi
  t143 = t142 * t39
  t144 = 0.1e1 / t35
  t146 = -t33 * t144 + 0.1e1
  t147 = t143 * t146
  t150 = t2 * t39
  t152 = t3 * t2
  t153 = t1 * t152
  t155 = 0.1e1 / t8 / t7
  t156 = t6 * t155
  t159 = 0.1e1 / 0.2e1 + 0.25875000000000000000000000000000000000000000000000e-2 * t11 + 0.10241250000000000000000000000000000000000000000000e-1 * t25 - 0.47887500000000000000000000000000000000000000000000e-2 * t150 + 0.17428125000000000000000000000000000000000000000000e-3 * t153 * t156
  t161 = jnp.exp(-0.18810000000000000000000000000000000000000000000000e0 * t11)
  t162 = t159 * t161
  t163 = jnp.sqrt(0.2e1)
  t164 = t162 * t163
  t168 = t19 * t20 * t137
  t169 = t168 * t5
  t171 = 0.1e1 / t22 / t7
  t172 = t41 / 0.2e1
  t173 = t172 ** 2
  t174 = t4 * t6
  t175 = t9 * t54
  t176 = 0.1e1 / t41
  t177 = t176 ** (0.1e1 / 0.3e1)
  t179 = t174 * t175 * t177
  t181 = 0.1e1 - 0.56675000000000000000000000000000000000000000000000e-2 * t179
  t182 = t173 * t181
  t183 = 0.1e1 / t152
  t184 = t103 * t183
  t185 = t182 * t184
  t186 = t1 * t22
  t187 = t177 ** 2
  t188 = 0.1e1 / t187
  t190 = t21 * t5
  t191 = t54 ** 2
  t192 = t23 * t191
  t196 = 0.1e1 + 0.10797500000000000000000000000000000000000000000000e0 * t179 + 0.10000000000000000000000000000000000000000000000000e-1 * t190 * t192 * t187
  t197 = 0.1e1 / t196
  t198 = t188 * t197
  t199 = t186 * t198
  t201 = 0.6e1 / 0.5e1 * t185 * t199
  t202 = t48 / 0.2e1
  t203 = t202 ** 2
  t204 = 0.1e1 / t48
  t205 = t204 ** (0.1e1 / 0.3e1)
  t207 = t174 * t175 * t205
  t209 = 0.1e1 - 0.56675000000000000000000000000000000000000000000000e-2 * t207
  t210 = t203 * t209
  t211 = t210 * t184
  t212 = t205 ** 2
  t213 = 0.1e1 / t212
  t218 = 0.1e1 + 0.10797500000000000000000000000000000000000000000000e0 * t207 + 0.10000000000000000000000000000000000000000000000000e-1 * t190 * t192 * t212
  t219 = 0.1e1 / t218
  t220 = t213 * t219
  t221 = t186 * t220
  t223 = 0.6e1 / 0.5e1 * t211 * t221
  t225 = jnp.exp(-0.77500000000000000000000000000000000000000000000000e-1 * t11)
  t226 = t146 * t225
  t230 = (-0.12375000000000000000000000000000000000000000000000e1 * t11 + t25 / 0.4e1) * jnp.pi
  t231 = t230 * t7
  t234 = 0.12e2 * t226 * t231 + t201 + t223
  t236 = t163 * t140
  t242 = 0.3e1 * t146
  t243 = t162 - 0.1e1 / 0.2e1
  t244 = t242 * t243
  t248 = jnp.exp(-0.13675000000000000000000000000000000000000000000000e0 * t11)
  t249 = t146 * t248
  t252 = -0.97000000000000000000000000000000000000000000000000e-1 * t11 + 0.16900000000000000000000000000000000000000000000000e0 * t25
  t253 = t249 * t252
  t255 = t1 / t20
  t257 = t255 * t6 * t22
  t260 = t41 ** 2
  t262 = t48 ** 2
  t266 = (t87 * t260 / 0.2e1 + t88 * t262 / 0.2e1) * t103
  t267 = t183 * t1
  t268 = t267 * t22
  t271 = t201 + t223 + 0.3e1 * t253 * t257 - 0.3e1 / 0.5e1 * t266 * t268
  t276 = -t31 + t84 + t86
  t281 = t111 ** 2
  t283 = t5 * t171
  t285 = t168 * t283 * t146
  t286 = t281 * f.p.cam_omega
  t287 = t236 * t286
  t288 = t162 * t287
  t291 = t171 * t242
  t292 = t243 * jnp.pi
  t296 = t137 * t144
  t300 = t281 * t111
  t303 = 0.1e1 / t22 / t35
  t305 = t281 ** 2
  t309 = t96 * t138 + (-0.35086488218440119971277336305861670150000000000000e0 * t147 * t164 - 0.33778690497744637945401606928209295430939130562735e-3 * t169 * t171 * t234 * t236) * t120 + (-0.87716220546100299928193340764654175375000000000000e-1 * t150 * t244 - 0.42223363122180797431752008660261619288673913203419e-3 * t169 * t171 * t271 * jnp.pi + 0.42708890021612718670335112500000000000000000000000e0 * t153 * t156 * t276) * t281 - 0.13511476199097855178160642771283718172375652225094e-1 * t285 * t288 + (-0.33778690497744637945401606928209295430939130562735e-2 * t169 * t291 * t292 + 0.52629732327660179956916004458792505225000000000000e0 * t296 * t276) * t300 + 0.20267214298646782767240964156925577258563478337641e-1 * t169 * t303 * t276 * t305
  t313 = 0.1e1 + 0.15403623315025000000000000000000000000000000000000e0 * t21 * t24 * t111
  t314 = t313 ** 2
  t315 = t314 ** 2
  t316 = 0.1e1 / t315
  t317 = t309 * t316
  t320 = 0.11073577833333333333333333333333333333333333333333e-2 * t4 * t156 * t30
  t321 = t27 ** 2
  t324 = 0.1e1 / t14
  t326 = t114 * t155
  t327 = t324 * t1 * t326
  t329 = t4 * t156
  t331 = t11 ** 0.5e0
  t333 = t331 * t1 * t326
  t335 = t21 * t283
  t340 = t13 / t321 * (-0.39359651450000000000000000000000000000000000000000e-1 * t327 - 0.18590345266666666666666666666666666666666666666667e-1 * t329 - 0.63666595250000000000000000000000000000000000000000e-2 * t333 - 0.51086658466666666666666666666666666666666666666667e-2 * t335) / t29
  t344 = 0.4e1 * t33 * t32 * t37 * t83
  t349 = 0.4e1 * t34 / t36 / t7 * t83
  t350 = t32 * t144
  t351 = t39 - t350
  t354 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t351)
  t355 = -t351
  t358 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t355)
  t360 = (t354 + t358) * t57
  t362 = t38 * t360 * t82
  t366 = t65 ** 2
  t380 = t76 ** 2
  t381 = 0.1e1 / t380
  t387 = -0.29149776500000000000000000000000000000000000000000e-1 * t327 - 0.10197214950000000000000000000000000000000000000000e-1 * t329 - 0.18581188275000000000000000000000000000000000000000e-2 * t333 - 0.27959805900000000000000000000000000000000000000000e-2 * t335
  t388 = 0.1e1 / t78
  t394 = t38 * t58 * (0.53236443333333333333333333333333333333333333333333e-3 * t4 * t156 * t68 + t60 / t366 * (-0.36579716750000000000000000000000000000000000000000e-1 * t327 - 0.16057207750000000000000000000000000000000000000000e-1 * t329 - 0.65409473750000000000000000000000000000000000000000e-2 * t333 - 0.32394225500000000000000000000000000000000000000000e-2 * t335) / t67 - t320 - t340 + 0.18311555036753159941307229983139571945136646663793e-3 * t4 * t156 * t79 + 0.58482233974552040708313425006184496242808878304904e0 * t71 * t381 * t387 * t388)
  t396 = 0.58482233974552040708313425006184496242808878304904e0 * t360 * t80
  t401 = 0.18311555036753159941307229983139571945136646663793e-3 * t58 * t1 * t114 * t155 * t79
  t406 = 0.58482233974552040708313425006184496242808878304904e0 * t58 * t71 * t381 * t387 * t388
  t407 = t91 * t95
  t408 = 0.1e1 / t45
  t410 = 0.1e1 / t50
  t413 = t408 * t351 / 0.3e1 + t410 * t355 / 0.3e1
  t420 = 0.48717083333333333333333333333333333333333333333333e0 * f.p.cam_omega * t324 * t98 * t329
  t423 = 0.29230250000000000000000000000000000000000000000000e1 * t97 * t115 * t413
  t427 = t113 * t114 * t155 * t115 / 0.12e2
  t428 = t112 * t4
  t430 = t10 * t123 * t413
  t436 = 0.24484000000000000000000000000000000000000000000000e0 * t120 * t14 * t123 * t329
  t437 = t91 ** 2
  t438 = 0.1e1 / t437
  t444 = t132 ** 2
  t446 = t126 / t444
  t449 = 0.28737583333333333333333333333333333333333333333333e0 * t128 * t156 * t115
  t458 = 0.1e1 / t126 * t132 * t137
  t463 = 0.35086488218440119971277336305861670150000000000000e0 * t142 * t144 * t146 * t164
  t464 = t35 * t7
  t465 = 0.1e1 / t464
  t466 = t33 * t465
  t467 = -t350 + t466
  t468 = 0.2e1 * t467
  t474 = t2 * t144
  t477 = 0.1e1 / t8 / t35
  t478 = t6 * t477
  t482 = (-0.86250000000000000000000000000000000000000000000000e-3 * t329 - 0.68275000000000000000000000000000000000000000000000e-2 * t335 + 0.47887500000000000000000000000000000000000000000000e-2 * t474 - 0.23237500000000000000000000000000000000000000000000e-3 * t153 * t478) * t161
  t485 = 0.35086488218440119971277336305861670150000000000000e0 * t147 * t482 * t163
  t493 = 0.21999228112961955221990889863775267184050000000000e-1 * t142 * t477 * t146 * t159 * t4 * t6 * t161 * t163
  t497 = 0.56297817496241063242336011547015492384898550937892e-3 * t169 * t303 * t234 * t236
  t499 = t172 * t181 * t184
  t500 = t351 / 0.2e1
  t504 = 0.12e2 / 0.5e1 * t499 * t186 * t198 * t500
  t505 = t155 * t54
  t507 = t174 * t505 * t177
  t508 = 0.18891666666666666666666666666666666666666666666667e-2 * t507
  t509 = t54 * t188
  t510 = 0.1e1 / t260
  t511 = t510 * t351
  t513 = t11 * t509 * t511
  t519 = 0.6e1 / 0.5e1 * t173 * (t508 + 0.18891666666666666666666666666666666666666666666667e-2 * t513) * t184 * t199
  t520 = t1 * t9
  t523 = 0.4e1 / 0.5e1 * t185 * t520 * t198
  t524 = t184 * t1
  t525 = t182 * t524
  t528 = t22 / t187 / t176
  t529 = t197 * t510
  t533 = 0.4e1 / 0.5e1 * t525 * t528 * t529 * t351
  t534 = t196 ** 2
  t536 = t188 / t534
  t537 = 0.35991666666666666666666666666666666666666666666667e-1 * t507
  t539 = t171 * t191
  t542 = 0.66666666666666666666666666666666666666666666666667e-2 * t190 * t539 * t187
  t544 = t191 / t177
  t552 = 0.6e1 / 0.5e1 * t185 * t186 * t536 * (-t537 - 0.35991666666666666666666666666666666666666666666667e-1 * t513 - t542 - 0.66666666666666666666666666666666666666666666666667e-2 * t25 * t544 * t511)
  t554 = t202 * t209 * t184
  t559 = -0.12e2 / 0.5e1 * t554 * t186 * t220 * t500
  t561 = t174 * t505 * t205
  t562 = 0.18891666666666666666666666666666666666666666666667e-2 * t561
  t563 = t54 * t213
  t564 = 0.1e1 / t262
  t565 = t564 * t355
  t567 = t11 * t563 * t565
  t573 = 0.6e1 / 0.5e1 * t203 * (t562 + 0.18891666666666666666666666666666666666666666666667e-2 * t567) * t184 * t221
  t576 = 0.4e1 / 0.5e1 * t211 * t520 * t220
  t577 = t210 * t524
  t580 = t22 / t212 / t204
  t581 = t219 * t564
  t585 = 0.4e1 / 0.5e1 * t577 * t580 * t581 * t355
  t586 = t218 ** 2
  t588 = t213 / t586
  t589 = 0.35991666666666666666666666666666666666666666666667e-1 * t561
  t593 = 0.66666666666666666666666666666666666666666666666667e-2 * t190 * t539 * t212
  t595 = t191 / t205
  t603 = 0.6e1 / 0.5e1 * t211 * t186 * t588 * (-t589 - 0.35991666666666666666666666666666666666666666666667e-1 * t567 - t593 - 0.66666666666666666666666666666666666666666666666667e-2 * t25 * t595 * t565)
  t612 = 0.31000000000000000000000000000000000000000000000000e0 * t146 * t1 * t114 * t9 * t225 * t230
  t619 = 0.12e2 * t226 * (0.41250000000000000000000000000000000000000000000000e0 * t329 - t335 / 0.6e1) * jnp.pi * t7
  t621 = 0.12e2 * t226 * t230
  t622 = 0.12e2 * t468 * t225 * t231 + t504 + t519 + t523 + t533 - t552 + t559 + t573 + t576 + t585 - t603 + t612 + t619 + t621
  t630 = 0.87716220546100299928193340764654175375000000000000e-1 * t474 * t244
  t631 = 0.6e1 * t467
  t640 = t482 + 0.62700000000000000000000000000000000000000000000000e-1 * t159 * t1 * t3 * t156 * t161
  t643 = 0.87716220546100299928193340764654175375000000000000e-1 * t150 * t242 * t640
  t647 = 0.70372271870301329052920014433769365481123188672365e-3 * t169 * t303 * t271 * jnp.pi
  t658 = 0.54699999999999999999999999999999999999999999999999e0 * t146 * t19 / t3 * t24 * t248 * t252
  t664 = 0.3e1 * t249 * (0.32333333333333333333333333333333333333333333333333e-1 * t329 - 0.11266666666666666666666666666666666666666666666667e0 * t335) * t257
  t667 = 0.2e1 * t253 * t255 * t10
  t668 = t87 * t41
  t670 = t88 * t48
  t679 = 0.2e1 / 0.5e1 * t266 * t267 * t9
  t680 = t504 + t519 + t523 + t533 - t552 + t559 + t573 + t576 + t585 - t603 + 0.3e1 * t468 * t248 * t252 * t257 + t658 + t664 + t667 - 0.3e1 / 0.5e1 * (0.4e1 / 0.3e1 * t668 * t351 + 0.4e1 / 0.3e1 * t670 * t355) * t103 * t268 - t679
  t687 = 0.56945186695483624893780150000000000000000000000000e0 * t153 * t478 * t276
  t688 = t320 + t340 + t344 - t349 + t362 + t394 + t396 - t401 - t406
  t698 = 0.22519126998496425296934404618806196953959420375157e-1 * t168 * t5 * t303 * t146 * t288
  t705 = 0.13511476199097855178160642771283718172375652225094e-1 * t285 * t482 * t287
  t713 = 0.10166034692201226236048067621113869552895440734161e-1 / t140 / t136 * t465 * t146 * t162 * t163 * t286
  t717 = 0.56297817496241063242336011547015492384898550937892e-2 * t169 * t303 * t242 * t292
  t725 = 0.33778690497744637945401606928209295430939130562735e-2 * t169 * t291 * t640 * jnp.pi
  t728 = 0.10525946465532035991383200891758501045000000000000e1 * t137 * t465 * t276
  t738 = 0.54045904796391420712642571085134872689502608900376e-1 * t169 / t22 / t464 * t276 * t305
  t743 = 0.3e1 * t407 * t138 * t413 + t96 * ((-t420 - t423 - t427 - t428 * t430 / 0.2e1 - t436 - 0.14690400000000000000000000000000000000000000000000e1 * t122 * t438 * t413) * t133 - t446 * (-t420 - t423 - t449 - 0.17242550000000000000000000000000000000000000000000e1 * t128 * t430)) * t458 + (t463 - 0.35086488218440119971277336305861670150000000000000e0 * t143 * t468 * t164 - t485 - t493 + t497 - 0.33778690497744637945401606928209295430939130562735e-3 * t169 * t171 * t622 * t236) * t120 + (t630 - 0.87716220546100299928193340764654175375000000000000e-1 * t150 * t631 * t243 - t643 + t647 - 0.42223363122180797431752008660261619288673913203419e-3 * t169 * t171 * t680 * jnp.pi - t687 + 0.42708890021612718670335112500000000000000000000000e0 * t153 * t156 * t688) * t281 + t698 - 0.13511476199097855178160642771283718172375652225094e-1 * t168 * t283 * t468 * t288 - t705 - t713 + (t717 - 0.33778690497744637945401606928209295430939130562735e-2 * t169 * t171 * t631 * t292 - t725 - t728 + 0.52629732327660179956916004458792505225000000000000e0 * t296 * t688) * t300 - t738 + 0.20267214298646782767240964156925577258563478337641e-1 * t169 * t303 * t688 * t305
  t753 = 0.41076328840066666666666666666666666666666666666668e0 * t309 / t315 / t313 * t19 * t20 * t5 * t171 * t111
  t754 = -t743 * t316 + t320 + t340 + t344 - t349 + t362 + t394 + t396 - t401 - t406 - t753
  vrho_0_ = t7 * t754 - t31 - t317 + t84 + t86
  t756 = -t39 - t350
  t759 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t756)
  t760 = -t756
  t763 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t760)
  t765 = (t759 + t763) * t57
  t767 = t38 * t765 * t82
  t769 = 0.58482233974552040708313425006184496242808878304904e0 * t765 * t80
  t773 = t408 * t756 / 0.3e1 + t410 * t760 / 0.3e1
  t779 = 0.29230250000000000000000000000000000000000000000000e1 * t97 * t115 * t773
  t781 = t10 * t123 * t773
  t796 = t350 + t466
  t797 = 0.2e1 * t796
  t801 = t756 / 0.2e1
  t805 = 0.12e2 / 0.5e1 * t499 * t186 * t198 * t801
  t806 = t510 * t756
  t808 = t11 * t509 * t806
  t814 = 0.6e1 / 0.5e1 * t173 * (t508 + 0.18891666666666666666666666666666666666666666666667e-2 * t808) * t184 * t199
  t818 = 0.4e1 / 0.5e1 * t525 * t528 * t529 * t756
  t827 = 0.6e1 / 0.5e1 * t185 * t186 * t536 * (-t537 - 0.35991666666666666666666666666666666666666666666667e-1 * t808 - t542 - 0.66666666666666666666666666666666666666666666666667e-2 * t25 * t544 * t806)
  t832 = -0.12e2 / 0.5e1 * t554 * t186 * t220 * t801
  t833 = t564 * t760
  t835 = t11 * t563 * t833
  t841 = 0.6e1 / 0.5e1 * t203 * (t562 + 0.18891666666666666666666666666666666666666666666667e-2 * t835) * t184 * t221
  t845 = 0.4e1 / 0.5e1 * t577 * t580 * t581 * t760
  t854 = 0.6e1 / 0.5e1 * t211 * t186 * t588 * (-t589 - 0.35991666666666666666666666666666666666666666666667e-1 * t835 - t593 - 0.66666666666666666666666666666666666666666666666667e-2 * t25 * t595 * t833)
  t858 = 0.12e2 * t797 * t225 * t231 + t523 + t576 + t612 + t619 + t621 + t805 + t814 + t818 - t827 + t832 + t841 + t845 - t854
  t865 = 0.6e1 * t796
  t880 = t805 + t814 + t523 + t818 - t827 + t832 + t841 + t576 + t845 - t854 + 0.3e1 * t797 * t248 * t252 * t257 + t658 + t664 + t667 - 0.3e1 / 0.5e1 * (0.4e1 / 0.3e1 * t668 * t756 + 0.4e1 / 0.3e1 * t670 * t760) * t103 * t268 - t679
  t885 = t320 + t340 - t344 - t349 + t767 + t394 + t769 - t401 - t406
  t907 = 0.3e1 * t407 * t138 * t773 + t96 * ((-t420 - t779 - t427 - t428 * t781 / 0.2e1 - t436 - 0.14690400000000000000000000000000000000000000000000e1 * t122 * t438 * t773) * t133 - t446 * (-t420 - t779 - t449 - 0.17242550000000000000000000000000000000000000000000e1 * t128 * t781)) * t458 + (t463 - 0.35086488218440119971277336305861670150000000000000e0 * t143 * t797 * t164 - t485 - t493 + t497 - 0.33778690497744637945401606928209295430939130562735e-3 * t169 * t171 * t858 * t236) * t120 + (t630 - 0.87716220546100299928193340764654175375000000000000e-1 * t150 * t865 * t243 - t643 + t647 - 0.42223363122180797431752008660261619288673913203419e-3 * t169 * t171 * t880 * jnp.pi - t687 + 0.42708890021612718670335112500000000000000000000000e0 * t153 * t156 * t885) * t281 + t698 - 0.13511476199097855178160642771283718172375652225094e-1 * t168 * t283 * t797 * t288 - t705 - t713 + (t717 - 0.33778690497744637945401606928209295430939130562735e-2 * t169 * t171 * t865 * t292 - t725 - t728 + 0.52629732327660179956916004458792505225000000000000e0 * t296 * t885) * t300 - t738 + 0.20267214298646782767240964156925577258563478337641e-1 * t169 * t303 * t885 * t305
  t909 = -t907 * t316 + t320 + t340 - t344 - t349 + t394 - t401 - t406 - t753 + t767 + t769
  vrho_1_ = t7 * t909 - t31 - t317 + t84 + t86
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  lda_c_pw_erf_mu = f.p.cam_omega

  lda_c_pw_erf_b0 = lambda rs: 0.784949 * rs

  lda_c_pw_erf_alpha = (4 / (9 * jnp.pi)) ** (1 / 3)

  lda_c_pw_erf_ac = 5.84605

  lda_c_pw_erf_c = 3.91744

  lda_c_pw_erf_d = 3.44851

  lda_c_pw_erf_phin = lambda n, z: 1 / 2 * ((1 + z) ** (n / 3) + (1 - z) ** (n / 3))

  lda_c_pw_erf_g0 = lambda rs: 1 / 2 * (1 + 0.0207 * rs + 0.08193 * rs ** 2 - 0.01277 * rs ** 3 + 0.001859 * rs ** 4) * jnp.exp(-0.7524 * rs)

  lda_c_pw_erf_D2 = lambda rs: jnp.exp(-0.547 * rs) * (-0.388 * rs + 0.676 * rs ** 2) / rs ** 2

  lda_c_pw_erf_D3 = lambda rs: jnp.exp(-0.31 * rs) * (-4.95 * rs + rs ** 2) / rs ** 3

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  lda_c_pw_erf_g1 = lambda rs: 2 ** (5 / 3) * (1 - 0.02267 * rs) / (5 * lda_c_pw_erf_alpha ** 2 * rs ** 2 * (1 + 0.4319 * rs + 0.04 * rs ** 2))

  lda_c_pw_erf_bc = lda_c_pw_erf_d - 3 * jnp.pi * lda_c_pw_erf_alpha / (4 * jnp.log(2) - 4)

  lda_c_pw_erf_g0c = lambda rs: lda_c_pw_erf_g0(rs) - 1 / 2

  lda_c_pw_erf_C3 = lambda rs, z: -(1 - z ** 2) * lda_c_pw_erf_g0(rs) / (jnp.sqrt(2 * jnp.pi) * rs ** 3)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  lda_c_pw_erf_c4_l = lambda rs, z: ((1 + z) / 2) ** 2 * lda_c_pw_erf_g1(rs * (2 / (1 + z)) ** (1 / 3)) + ((1 - z) / 2) ** 2 * lda_c_pw_erf_g1(rs * (2 / (1 - z)) ** (1 / 3)) + (1 - z ** 2) * lda_c_pw_erf_D2(rs) - lda_c_pw_erf_phin(8, z) / (5 * lda_c_pw_erf_alpha ** 2 * rs ** 2)

  lda_c_pw_erf_c5_l = lambda rs, z: ((1 + z) / 2) ** 2 * lda_c_pw_erf_g1(rs * (2 / (1 + z)) ** (1 / 3)) + ((1 - z) / 2) ** 2 * lda_c_pw_erf_g1(rs * (2 / (1 - z)) ** (1 / 3)) + (1 - z ** 2) * lda_c_pw_erf_D3(rs)

  lda_c_pw_erf_Q = lambda x: (2 * jnp.log(2) - 2) * jnp.log((1 + lda_c_pw_erf_ac * x + lda_c_pw_erf_bc * x ** 2 + lda_c_pw_erf_c * x ** 3) / (1 + lda_c_pw_erf_ac * x + lda_c_pw_erf_d * x ** 2)) / jnp.pi ** 2

  lda_c_pw_erf_C2 = lambda rs, z: -3 * (1 - z ** 2) * lda_c_pw_erf_g0c(rs) / (8 * rs ** 3)

  lda_c_pw_erf_a3 = lambda rs, z: lda_c_pw_erf_b0(rs) ** 8 * lda_c_pw_erf_C3(rs, z)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  lda_c_pw_erf_C4 = lambda rs, z: -9 * lda_c_pw_erf_c4_l(rs, z) / (64 * rs ** 3)

  lda_c_pw_erf_C5 = lambda rs, z: -9 * lda_c_pw_erf_c5_l(rs, z) / (40 * jnp.sqrt(2 * jnp.pi) * rs ** 3)

  lda_c_pw_erf_a4 = lambda rs, z: lda_c_pw_erf_b0(rs) ** 8 * lda_c_pw_erf_C2(rs, z) + 4 * lda_c_pw_erf_b0(rs) ** 6 * f_pw(rs, z)

  lda_c_pw_erf_a5 = lambda rs, z: lda_c_pw_erf_b0(rs) ** 8 * f_pw(rs, z)

  lda_c_pw_erf_a2 = lambda rs, z: 4 * lda_c_pw_erf_b0(rs) ** 6 * lda_c_pw_erf_C2(rs, z) + lda_c_pw_erf_b0(rs) ** 8 * lda_c_pw_erf_C4(rs, z) + 6 * lda_c_pw_erf_b0(rs) ** 4 * f_pw(rs, z)

  lda_c_pw_erf_a1 = lambda rs, z: 4 * lda_c_pw_erf_b0(rs) ** 6 * lda_c_pw_erf_C3(rs, z) + lda_c_pw_erf_b0(rs) ** 8 * lda_c_pw_erf_C5(rs, z)

  lda_c_pw_erf_f = lambda rs, z: f_pw(rs, z) - (lda_c_pw_erf_phin(2, z) ** 3 * lda_c_pw_erf_Q(lda_c_pw_erf_mu * jnp.sqrt(rs) / lda_c_pw_erf_phin(2, z)) + lda_c_pw_erf_a1(rs, z) * lda_c_pw_erf_mu ** 3 + lda_c_pw_erf_a2(rs, z) * lda_c_pw_erf_mu ** 4 + lda_c_pw_erf_a3(rs, z) * lda_c_pw_erf_mu ** 5 + lda_c_pw_erf_a4(rs, z) * lda_c_pw_erf_mu ** 6 + lda_c_pw_erf_a5(rs, z) * lda_c_pw_erf_mu ** 8) / (1 + lda_c_pw_erf_b0(rs) ** 2 * lda_c_pw_erf_mu ** 2) ** 4

  functional_body = lambda rs, z: lda_c_pw_erf_f(rs, z)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t10 = t4 * t9
  t12 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t22 = 0.1e1 / t21
  t23 = t5 * t22
  t24 = t20 * t23
  t26 = 0.23615790870000000000000000000000000000000000000000e0 * t13 + 0.55771035800000000000000000000000000000000000000000e-1 * t10 + 0.12733319050000000000000000000000000000000000000000e-1 * t16 + 0.76629987700000000000000000000000000000000000000000e-2 * t24
  t28 = 0.1e1 + 0.1e1 / t26
  t29 = jnp.log(t28)
  t30 = t12 * t29
  t32 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t34 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t32 * f.p.zeta_threshold, 1)
  t37 = 2 ** (0.1e1 / 0.3e1)
  t41 = (0.2e1 * t34 - 0.2e1) / (0.2e1 * t37 - 0.2e1)
  t43 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t10
  t48 = 0.17489865900000000000000000000000000000000000000000e0 * t13 + 0.30591644850000000000000000000000000000000000000000e-1 * t10 + 0.37162376550000000000000000000000000000000000000000e-2 * t16 + 0.41939708850000000000000000000000000000000000000000e-2 * t24
  t50 = 0.1e1 + 0.1e1 / t48
  t51 = jnp.log(t50)
  t54 = 0.58482233974552040708313425006184496242808878304904e0 * t41 * t43 * t51
  t55 = jnp.log(0.2e1)
  t56 = t55 - 0.1e1
  t57 = 0.2e1 * t56
  t59 = 0.29230250000000000000000000000000000000000000000000e1 * f.p.cam_omega * t13
  t61 = 9 ** (0.1e1 / 0.3e1)
  t62 = t61 ** 2
  t70 = f.p.cam_omega ** 2
  t72 = (0.344851e1 - jnp.pi * t5 * t62 * t3 / t56 / 0.12e2) * t70 * t1
  t73 = t3 * t6
  t74 = t73 * t8
  t77 = t70 * f.p.cam_omega
  t81 = 0.1e1 + t59 + t72 * t74 / 0.4e1 + 0.48968000000000000000000000000000000000000000000000e0 * t77 * t13 * t10
  t82 = t70 * t1
  t85 = 0.1e1 + t59 + 0.86212750000000000000000000000000000000000000000000e0 * t82 * t74
  t86 = 0.1e1 / t85
  t88 = jnp.log(t81 * t86)
  t90 = jnp.pi ** 2
  t91 = 0.1e1 / t90
  t93 = jnp.sqrt(jnp.pi)
  t95 = 0.1e1 / t93 / jnp.pi
  t96 = 0.1e1 / r0
  t97 = t95 * t96
  t100 = t2 * t96
  t102 = t3 * t2
  t103 = t1 * t102
  t105 = 0.1e1 / t7 / r0
  t106 = t6 * t105
  t109 = 0.1e1 / 0.2e1 + 0.25875000000000000000000000000000000000000000000000e-2 * t10 + 0.10241250000000000000000000000000000000000000000000e-1 * t24 - 0.47887500000000000000000000000000000000000000000000e-2 * t100 + 0.17428125000000000000000000000000000000000000000000e-3 * t103 * t106
  t111 = jnp.exp(-0.18810000000000000000000000000000000000000000000000e0 * t10)
  t112 = t109 * t111
  t113 = jnp.sqrt(0.2e1)
  t114 = t112 * t113
  t118 = t18 * t19 * t91
  t119 = t118 * t5
  t121 = 0.1e1 / t21 / r0
  t123 = t4 * t9 * t37
  t127 = 0.1e1 / t102
  t128 = (0.1e1 - 0.56675000000000000000000000000000000000000000000000e-2 * t123) * t62 * t127
  t129 = t1 * t21
  t131 = t37 ** 2
  t135 = 0.1e1 + 0.10797500000000000000000000000000000000000000000000e0 * t123 + 0.10000000000000000000000000000000000000000000000000e-1 * t20 * t23 * t131
  t136 = 0.1e1 / t135
  t139 = 0.3e1 / 0.5e1 * t128 * t129 * t136
  t141 = jnp.exp(-0.77500000000000000000000000000000000000000000000000e-1 * t10)
  t144 = -0.12375000000000000000000000000000000000000000000000e1 * t10 + t24 / 0.4e1
  t145 = t141 * t144
  t146 = jnp.pi * r0
  t149 = 0.12e2 * t145 * t146 + t139
  t151 = t113 * t93
  t158 = 0.3e1 * t112 - 0.3e1 / 0.2e1
  t162 = jnp.exp(-0.13675000000000000000000000000000000000000000000000e0 * t10)
  t165 = -0.97000000000000000000000000000000000000000000000000e-1 * t10 + 0.16900000000000000000000000000000000000000000000000e0 * t24
  t167 = t162 * t165 * t1
  t169 = 0.1e1 / t19 * t6
  t170 = t169 * t21
  t173 = t62 * t127
  t176 = t139 + 0.3e1 * t167 * t170 - 0.3e1 / 0.5e1 * t173 * t129
  t181 = -t30 + t54
  t186 = t70 ** 2
  t188 = t5 * t121
  t189 = t118 * t188
  t190 = t186 * f.p.cam_omega
  t191 = t151 * t190
  t192 = t112 * t191
  t199 = r0 ** 2
  t200 = 0.1e1 / t199
  t201 = t91 * t200
  t205 = t186 * t70
  t208 = 0.1e1 / t21 / t199
  t210 = t186 ** 2
  t214 = t57 * t88 * t91 + (-0.35086488218440119971277336305861670150000000000000e0 * t97 * t114 - 0.33778690497744637945401606928209295430939130562735e-3 * t119 * t121 * t149 * t151) * t77 + (-0.87716220546100299928193340764654175375000000000000e-1 * t100 * t158 - 0.42223363122180797431752008660261619288673913203419e-3 * t119 * t121 * t176 * jnp.pi + 0.42708890021612718670335112500000000000000000000000e0 * t103 * t106 * t181) * t186 - 0.13511476199097855178160642771283718172375652225094e-1 * t189 * t192 + (-0.33778690497744637945401606928209295430939130562735e-2 * t119 * t121 * t158 * jnp.pi + 0.52629732327660179956916004458792505225000000000000e0 * t201 * t181) * t205 + 0.20267214298646782767240964156925577258563478337641e-1 * t119 * t208 * t181 * t210
  t218 = 0.1e1 + 0.15403623315025000000000000000000000000000000000000e0 * t20 * t23 * t70
  t219 = t218 ** 2
  t220 = t219 ** 2
  t221 = 0.1e1 / t220
  t225 = 0.11073577833333333333333333333333333333333333333333e-2 * t4 * t106 * t29
  t226 = t26 ** 2
  t229 = 0.1e1 / t13
  t231 = t73 * t105
  t232 = t229 * t1 * t231
  t234 = t4 * t106
  t236 = t10 ** 0.5e0
  t238 = t236 * t1 * t231
  t240 = t20 * t188
  t245 = t12 / t226 * (-0.39359651450000000000000000000000000000000000000000e-1 * t232 - 0.18590345266666666666666666666666666666666666666667e-1 * t234 - 0.63666595250000000000000000000000000000000000000000e-2 * t238 - 0.51086658466666666666666666666666666666666666666667e-2 * t240) / t28
  t250 = 0.18311555036753159941307229983139571945136646663793e-3 * t41 * t1 * t73 * t105 * t51
  t252 = t48 ** 2
  t263 = 0.58482233974552040708313425006184496242808878304904e0 * t41 * t43 / t252 * (-0.29149776500000000000000000000000000000000000000000e-1 * t232 - 0.10197214950000000000000000000000000000000000000000e-1 * t234 - 0.18581188275000000000000000000000000000000000000000e-2 * t238 - 0.27959805900000000000000000000000000000000000000000e-2 * t240) / t50
  t267 = 0.48717083333333333333333333333333333333333333333333e0 * f.p.cam_omega * t229 * t1 * t231
  t276 = t85 ** 2
  t294 = t2 * t200
  t297 = 0.1e1 / t7 / t199
  t298 = t6 * t297
  t302 = (-0.86250000000000000000000000000000000000000000000000e-3 * t234 - 0.68275000000000000000000000000000000000000000000000e-2 * t240 + 0.47887500000000000000000000000000000000000000000000e-2 * t294 - 0.23237500000000000000000000000000000000000000000000e-3 * t103 * t298) * t111
  t307 = t109 * t1
  t309 = t111 * t113
  t323 = 0.11335000000000000000000000000000000000000000000000e-2 * t18 * jnp.pi * t6 * t22 * t37 * t62 * t136
  t324 = t1 * t8
  t327 = 0.2e1 / 0.5e1 * t128 * t324 * t136
  t328 = t135 ** 2
  t340 = 0.3e1 / 0.5e1 * t128 * t129 / t328 * (-0.35991666666666666666666666666666666666666666666667e-1 * t4 * t106 * t37 - 0.66666666666666666666666666666666666666666666666667e-2 * t20 * t188 * t131)
  t369 = 0.3e1 * t302 + 0.18810000000000000000000000000000000000000000000000e0 * t307 * t3 * t106 * t111
  t403 = t225 + t245 - t250 - t263
  t418 = t199 * r0
  t419 = 0.1e1 / t418
  vrho_0_ = -t30 + t54 - t214 * t221 + r0 * (t225 + t245 - t250 - t263 - (t57 * ((-t267 - t72 * t231 / 0.12e2 - 0.24484000000000000000000000000000000000000000000000e0 * t77 * t13 * t1 * t231) * t86 - t81 / t276 * (-t267 - 0.28737583333333333333333333333333333333333333333333e0 * t82 * t231)) / t81 * t85 * t91 + (0.35086488218440119971277336305861670150000000000000e0 * t95 * t200 * t114 - 0.35086488218440119971277336305861670150000000000000e0 * t97 * t302 * t113 - 0.21999228112961955221990889863775267184050000000000e-1 * t95 * t297 * t307 * t73 * t309 + 0.56297817496241063242336011547015492384898550937892e-3 * t119 * t208 * t149 * t151 - 0.33778690497744637945401606928209295430939130562735e-3 * t119 * t121 * (t323 + t327 - t340 + 0.31000000000000000000000000000000000000000000000000e0 * t4 * t6 * t8 * t141 * t144 * jnp.pi + 0.12e2 * t141 * (0.41250000000000000000000000000000000000000000000000e0 * t234 - t240 / 0.6e1) * t146 + 0.12e2 * t145 * jnp.pi) * t151) * t77 + (0.87716220546100299928193340764654175375000000000000e-1 * t294 * t158 - 0.87716220546100299928193340764654175375000000000000e-1 * t100 * t369 + 0.70372271870301329052920014433769365481123188672365e-3 * t119 * t208 * t176 * jnp.pi - 0.42223363122180797431752008660261619288673913203419e-3 * t119 * t121 * (t323 + t327 - t340 + 0.54699999999999999999999999999999999999999999999999e0 * t18 / t3 * t5 * t22 * t162 * t165 + 0.3e1 * t162 * (0.32333333333333333333333333333333333333333333333333e-1 * t234 - 0.11266666666666666666666666666666666666666666666667e0 * t240) * t1 * t170 + 0.2e1 * t167 * t169 * t8 - 0.2e1 / 0.5e1 * t173 * t324) * jnp.pi - 0.56945186695483624893780150000000000000000000000000e0 * t103 * t298 * t181 + 0.42708890021612718670335112500000000000000000000000e0 * t103 * t106 * t403) * t186 + 0.22519126998496425296934404618806196953959420375157e-1 * t118 * t5 * t208 * t192 - 0.13511476199097855178160642771283718172375652225094e-1 * t189 * t302 * t191 - 0.10166034692201226236048067621113869552895440734161e-1 / t93 / t90 * t419 * t109 * t309 * t190 + (0.56297817496241063242336011547015492384898550937892e-2 * t119 * t208 * t158 * jnp.pi - 0.33778690497744637945401606928209295430939130562735e-2 * t119 * t121 * t369 * jnp.pi - 0.10525946465532035991383200891758501045000000000000e1 * t91 * t419 * t181 + 0.52629732327660179956916004458792505225000000000000e0 * t201 * t403) * t205 - 0.54045904796391420712642571085134872689502608900376e-1 * t119 / t21 / t418 * t181 * t210 + 0.20267214298646782767240964156925577258563478337641e-1 * t119 * t208 * t403 * t210) * t221 - 0.41076328840066666666666666666666666666666666666668e0 * t214 / t220 / t218 * t18 * t19 * t5 * t121 * t70)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  res = {'vrho': vrho_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t7 / r0
  t10 = t6 * t9
  t11 = 0.1e1 / t7
  t12 = t6 * t11
  t13 = t4 * t12
  t14 = jnp.sqrt(t13)
  t17 = t13 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t7 ** 2
  t23 = 0.1e1 / t22
  t24 = t5 * t23
  t25 = t21 * t24
  t27 = 0.37978500000000000000000000000000000000000000000000e1 * t14 + 0.89690000000000000000000000000000000000000000000000e0 * t13 + 0.20477500000000000000000000000000000000000000000000e0 * t17 + 0.12323500000000000000000000000000000000000000000000e0 * t25
  t30 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t27
  t31 = jnp.log(t30)
  t33 = t4 * t10 * t31
  t36 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t13
  t37 = t27 ** 2
  t38 = 0.1e1 / t37
  t39 = t36 * t38
  t40 = 0.1e1 / t14
  t41 = t40 * t1
  t42 = t3 * t6
  t43 = t42 * t9
  t44 = t41 * t43
  t46 = t4 * t10
  t48 = t13 ** 0.5e0
  t49 = t48 * t1
  t50 = t49 * t43
  t53 = 0.1e1 / t22 / r0
  t54 = t5 * t53
  t55 = t21 * t54
  t57 = -0.63297500000000000000000000000000000000000000000000e0 * t44 - 0.29896666666666666666666666666666666666666666666667e0 * t46 - 0.10238750000000000000000000000000000000000000000000e0 * t50 - 0.82156666666666666666666666666666666666666666666667e-1 * t55
  t58 = 0.1e1 / t30
  t59 = t57 * t58
  t60 = t39 * t59
  t63 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t65 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t63 * f.p.zeta_threshold, 1)
  t68 = 2 ** (0.1e1 / 0.3e1)
  t72 = (0.2e1 * t65 - 0.2e1) / (0.2e1 * t68 - 0.2e1)
  t73 = t72 * t1
  t78 = 0.51785000000000000000000000000000000000000000000000e1 * t14 + 0.90577500000000000000000000000000000000000000000000e0 * t13 + 0.11003250000000000000000000000000000000000000000000e0 * t17 + 0.12417750000000000000000000000000000000000000000000e0 * t25
  t81 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t78
  t82 = jnp.log(t81)
  t85 = t73 * t42 * t9 * t82
  t88 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t13
  t89 = t72 * t88
  t90 = t78 ** 2
  t91 = 0.1e1 / t90
  t96 = -0.86308333333333333333333333333333333333333333333334e0 * t44 - 0.30192500000000000000000000000000000000000000000000e0 * t46 - 0.55016250000000000000000000000000000000000000000000e-1 * t50 - 0.82785000000000000000000000000000000000000000000000e-1 * t55
  t98 = 0.1e1 / t81
  t99 = t91 * t96 * t98
  t100 = t89 * t99
  t102 = jnp.log(0.2e1)
  t103 = t102 - 0.1e1
  t104 = 0.2e1 * t103
  t106 = f.p.cam_omega * t40 * t1
  t108 = 0.48717083333333333333333333333333333333333333333333e0 * t106 * t43
  t110 = 9 ** (0.1e1 / 0.3e1)
  t111 = t110 ** 2
  t119 = f.p.cam_omega ** 2
  t121 = (0.344851e1 - jnp.pi * t5 * t111 * t3 / t103 / 0.12e2) * t119 * t1
  t124 = t119 * f.p.cam_omega
  t126 = t124 * t14 * t1
  t129 = -t108 - t121 * t43 / 0.12e2 - 0.24484000000000000000000000000000000000000000000000e0 * t126 * t43
  t131 = 0.29230250000000000000000000000000000000000000000000e1 * f.p.cam_omega * t14
  t132 = t119 * t1
  t133 = t42 * t11
  t136 = 0.1e1 + t131 + 0.86212750000000000000000000000000000000000000000000e0 * t132 * t133
  t137 = 0.1e1 / t136
  t141 = t14 * t13
  t144 = 0.1e1 + t131 + t121 * t133 / 0.4e1 + 0.48968000000000000000000000000000000000000000000000e0 * t124 * t141
  t145 = t136 ** 2
  t146 = 0.1e1 / t145
  t147 = t144 * t146
  t150 = -t108 - 0.28737583333333333333333333333333333333333333333333e0 * t132 * t43
  t153 = t104 * (t129 * t137 - t147 * t150)
  t154 = 0.1e1 / t144
  t156 = jnp.pi ** 2
  t157 = 0.1e1 / t156
  t158 = t154 * t136 * t157
  t160 = jnp.sqrt(jnp.pi)
  t162 = 0.1e1 / t160 / jnp.pi
  t163 = r0 ** 2
  t164 = 0.1e1 / t163
  t165 = t162 * t164
  t168 = 0.1e1 / r0
  t169 = t2 * t168
  t171 = t3 * t2
  t172 = t1 * t171
  t175 = 0.1e1 + 0.51750000000000000000000000000000000000000000000000e-2 * t13 + 0.20482500000000000000000000000000000000000000000000e-1 * t25 - 0.95775000000000000000000000000000000000000000000000e-2 * t169 + 0.34856250000000000000000000000000000000000000000000e-3 * t172 * t10
  t177 = jnp.exp(-0.18810000000000000000000000000000000000000000000000e0 * t13)
  t178 = t175 * t177
  t179 = jnp.sqrt(0.2e1)
  t180 = t178 * t179
  t183 = t162 * t168
  t186 = t2 * t164
  t189 = 0.1e1 / t7 / t163
  t190 = t6 * t189
  t193 = -0.17250000000000000000000000000000000000000000000000e-2 * t46 - 0.13655000000000000000000000000000000000000000000000e-1 * t55 + 0.95775000000000000000000000000000000000000000000000e-2 * t186 - 0.46475000000000000000000000000000000000000000000000e-3 * t172 * t190
  t194 = t193 * t177
  t195 = t194 * t179
  t198 = t162 * t189
  t199 = t175 * t1
  t201 = t177 * t179
  t202 = t42 * t201
  t206 = t19 * t20 * t157
  t207 = t206 * t5
  t209 = 0.1e1 / t22 / t163
  t211 = t4 * t12 * t68
  t215 = 0.1e1 / t171
  t216 = (0.1e1 - 0.56675000000000000000000000000000000000000000000000e-2 * t211) * t111 * t215
  t217 = t1 * t22
  t219 = t68 ** 2
  t223 = 0.1e1 + 0.10797500000000000000000000000000000000000000000000e0 * t211 + 0.10000000000000000000000000000000000000000000000000e-1 * t21 * t24 * t219
  t224 = 0.1e1 / t223
  t227 = t216 * t217 * t224 / 0.15e2
  t229 = jnp.exp(-0.77500000000000000000000000000000000000000000000000e-1 * t13)
  t232 = -0.12375000000000000000000000000000000000000000000000e1 * t13 + t25 / 0.4e1
  t233 = t229 * t232
  t234 = jnp.pi * r0
  t237 = t227 + 0.4e1 / 0.3e1 * t233 * t234
  t239 = t179 * t160
  t243 = t19 * jnp.pi
  t244 = t243 * t6
  t246 = t111 * t224
  t249 = 0.12594444444444444444444444444444444444444444444445e-3 * t244 * t23 * t68 * t246
  t250 = t1 * t11
  t253 = 0.2e1 / 0.45e2 * t216 * t250 * t224
  t254 = t223 ** 2
  t255 = 0.1e1 / t254
  t262 = -0.35991666666666666666666666666666666666666666666667e-1 * t4 * t10 * t68 - 0.66666666666666666666666666666666666666666666666667e-2 * t21 * t54 * t219
  t263 = t255 * t262
  t266 = t216 * t217 * t263 / 0.15e2
  t267 = t4 * t6
  t268 = t11 * t229
  t269 = t232 * jnp.pi
  t275 = 0.41250000000000000000000000000000000000000000000000e0 * t46 - t55 / 0.6e1
  t276 = t229 * t275
  t281 = t249 + t253 - t266 + 0.34444444444444444444444444444444444444444444444444e-1 * t267 * t268 * t269 + 0.4e1 / 0.3e1 * t276 * t234 + 0.4e1 / 0.3e1 * t233 * jnp.pi
  t289 = t178 / 0.2e1 - 0.1e1 / 0.2e1
  t293 = t199 * t3
  t294 = t10 * t177
  t297 = t194 / 0.2e1 + 0.31350000000000000000000000000000000000000000000000e-1 * t293 * t294
  t301 = jnp.exp(-0.13675000000000000000000000000000000000000000000000e0 * t13)
  t304 = -0.97000000000000000000000000000000000000000000000000e-1 * t13 + 0.16900000000000000000000000000000000000000000000000e0 * t25
  t306 = t301 * t304 * t1
  t308 = 0.1e1 / t20 * t6
  t309 = t308 * t22
  t312 = t111 * t215
  t315 = t227 + t306 * t309 / 0.3e1 - t312 * t217 / 0.15e2
  t322 = t19 / t3 * t5
  t323 = t23 * t301
  t329 = 0.32333333333333333333333333333333333333333333333333e-1 * t46 - 0.11266666666666666666666666666666666666666666666667e0 * t55
  t331 = t301 * t329 * t1
  t334 = t308 * t11
  t339 = t249 + t253 - t266 + 0.60777777777777777777777777777777777777777777777777e-1 * t322 * t323 * t304 + t331 * t309 / 0.3e1 + 0.2e1 / 0.9e1 * t306 * t334 - 0.2e1 / 0.45e2 * t312 * t250
  t349 = -0.62182e-1 * t36 * t31 + 0.19751789702565206228825776161588751761046270558698e-1 * t72 * t88 * t82
  t357 = 0.11073577833333333333333333333333333333333333333333e-2 * t33 + 0.10000000000000000000000000000000000000000000000000e1 * t60 - 0.18311555036753159941307229983139571945136646663793e-3 * t85 - 0.58482233974552040708313425006184496242808878304903e0 * t100
  t362 = t119 ** 2
  t364 = t5 * t209
  t365 = t206 * t364
  t366 = t362 * f.p.cam_omega
  t367 = t239 * t366
  t368 = t178 * t367
  t371 = t206 * t54
  t372 = t194 * t367
  t376 = 0.1e1 / t160 / t156
  t377 = t163 * r0
  t378 = 0.1e1 / t377
  t379 = t376 * t378
  t381 = t201 * t366
  t392 = t157 * t378
  t395 = t157 * t164
  t399 = t362 * t119
  t402 = 0.1e1 / t22 / t377
  t404 = t362 ** 2
  t412 = t153 * t158 + (0.17543244109220059985638668152930835075000000000000e0 * t165 * t180 - 0.17543244109220059985638668152930835075000000000000e0 * t183 * t195 - 0.10999614056480977610995444931887633592025000000000e-1 * t198 * t199 * t202 + 0.50668035746616956918102410392313943146408695844103e-2 * t207 * t209 * t237 * t239 - 0.30400821447970174150861446235388365887845217506462e-2 * t207 * t53 * t281 * t239) * t124 + (0.26314866163830089978458002229396252612500000000000e0 * t186 * t289 - 0.26314866163830089978458002229396252612500000000000e0 * t169 * t297 + 0.63335044683271196147628012990392428933010869805128e-2 * t207 * t209 * t315 * jnp.pi - 0.38001026809962717688576807794235457359806521883077e-2 * t207 * t53 * t339 * jnp.pi - 0.56945186695483624893780150000000000000000000000000e0 * t172 * t190 * t349 + 0.42708890021612718670335112500000000000000000000000e0 * t172 * t10 * t357) * t362 + 0.11259563499248212648467202309403098476979710187578e-1 * t365 * t368 - 0.67557380995489275890803213856418590861878261125470e-2 * t371 * t372 - 0.50830173461006131180240338105569347764477203670804e-2 * t379 * t175 * t381 + (0.16889345248872318972700803464104647715469565281367e-1 * t207 * t209 * t289 * jnp.pi - 0.10133607149323391383620482078462788629281739168820e-1 * t207 * t53 * t297 * jnp.pi - 0.10525946465532035991383200891758501045000000000000e1 * t392 * t349 + 0.52629732327660179956916004458792505225000000000000e0 * t395 * t357) * t399 - 0.54045904796391420712642571085134872689502608900376e-1 * t207 * t402 * t349 * t404 + 0.20267214298646782767240964156925577258563478337641e-1 * t207 * t209 * t357 * t404
  t416 = 0.1e1 + 0.15403623315025000000000000000000000000000000000000e0 * t21 * t24 * t119
  t417 = t416 ** 2
  t418 = t417 ** 2
  t419 = 0.1e1 / t418
  t423 = jnp.log(t144 * t137)
  t459 = t104 * t423 * t157 + (-0.17543244109220059985638668152930835075000000000000e0 * t183 * t180 - 0.30400821447970174150861446235388365887845217506462e-2 * t207 * t53 * t237 * t239) * t124 + (-0.26314866163830089978458002229396252612500000000000e0 * t169 * t289 - 0.38001026809962717688576807794235457359806521883077e-2 * t207 * t53 * t315 * jnp.pi + 0.42708890021612718670335112500000000000000000000000e0 * t172 * t10 * t349) * t362 - 0.67557380995489275890803213856418590861878261125470e-2 * t371 * t368 + (-0.10133607149323391383620482078462788629281739168820e-1 * t207 * t53 * t289 * jnp.pi + 0.52629732327660179956916004458792505225000000000000e0 * t395 * t349) * t399 + 0.20267214298646782767240964156925577258563478337641e-1 * t207 * t209 * t349 * t404
  t461 = 0.1e1 / t418 / t416
  t463 = t459 * t461 * t19
  t464 = t20 * t5
  t466 = t464 * t53 * t119
  t471 = 0.14764770444444444444444444444444444444444444444444e-2 * t4 * t190 * t31
  t475 = 0.35616666666666666666666666666666666666666666666666e-1 * t267 * t9 * t38 * t59
  t479 = t57 ** 2
  t482 = 0.20000000000000000000000000000000000000000000000000e1 * t36 / t37 / t27 * t479 * t58
  t483 = 0.1e1 / t141
  t485 = t464 * t209
  t486 = t483 * t19 * t485
  t488 = t42 * t189
  t489 = t41 * t488
  t491 = t4 * t190
  t493 = t13 ** (-0.5e0)
  t495 = t493 * t19 * t485
  t497 = t49 * t488
  t499 = t21 * t364
  t504 = 0.10000000000000000000000000000000000000000000000000e1 * t39 * (-0.42198333333333333333333333333333333333333333333333e0 * t486 + 0.84396666666666666666666666666666666666666666666666e0 * t489 + 0.39862222222222222222222222222222222222222222222223e0 * t491 + 0.68258333333333333333333333333333333333333333333333e-1 * t495 + 0.13651666666666666666666666666666666666666666666667e0 * t497 + 0.13692777777777777777777777777777777777777777777778e0 * t499) * t58
  t505 = t37 ** 2
  t508 = t30 ** 2
  t512 = 0.16081824322151104821330931780901225435013347914188e2 * t36 / t505 * t479 / t508
  t516 = 0.24415406715670879921742973310852762593515528885057e-3 * t73 * t42 * t189 * t82
  t520 = 0.10843580882781524214666447553230042011687479519034e-1 * t72 * t4 * t10 * t99
  t523 = t96 ** 2
  t527 = 0.11696446794910408141662685001236899248561775660981e1 * t89 / t90 / t78 * t523 * t98
  t538 = 0.58482233974552040708313425006184496242808878304903e0 * t89 * t91 * (-0.57538888888888888888888888888888888888888888888889e0 * t486 + 0.11507777777777777777777777777777777777777777777778e1 * t489 + 0.40256666666666666666666666666666666666666666666667e0 * t491 + 0.36677500000000000000000000000000000000000000000000e-1 * t495 + 0.73355000000000000000000000000000000000000000000000e-1 * t497 + 0.13797500000000000000000000000000000000000000000000e0 * t499) * t98
  t539 = t90 ** 2
  t542 = t81 ** 2
  t546 = 0.17315755899375863299672358916972966258900005419821e2 * t89 / t539 * t523 / t542
  t550 = 0.32478055555555555555555555555555555555555555555555e0 * f.p.cam_omega * t483 * t19 * t485
  t552 = 0.64956111111111111111111111111111111111111111111111e0 * t106 * t488
  t569 = t150 ** 2
  t579 = t144 ** 2
  t594 = 0.1e1 / t7 / t377
  t601 = t2 * t378
  t603 = t6 * t594
  t607 = (0.23000000000000000000000000000000000000000000000000e-2 * t491 + 0.22758333333333333333333333333333333333333333333333e-1 * t499 - 0.19155000000000000000000000000000000000000000000000e-1 * t601 + 0.10844166666666666666666666666666666666666666666667e-2 * t172 * t603) * t177
  t611 = t193 * t1
  t616 = t175 * t19
  t632 = 0.3e-53 * t244 * t53 * t68 * t246
  t638 = 0.25188888888888888888888888888888888888888888888890e-3 * t243 * t6 * t23 * t68 * t111 * t263
  t639 = t1 * t9
  t642 = 0.2e1 / 0.135e3 * t216 * t639 * t224
  t645 = 0.4e1 / 0.45e2 * t216 * t250 * t263
  t648 = t262 ** 2
  t652 = 0.2e1 / 0.15e2 * t216 * t217 / t254 / t223 * t648
  t663 = t216 * t217 * t255 * (0.47988888888888888888888888888888888888888888888889e-1 * t4 * t190 * t68 + 0.11111111111111111111111111111111111111111111111111e-1 * t21 * t364 * t219) / 0.15e2
  t685 = -t632 - t638 - t642 - t645 + t652 - t663 + 0.22962962962962962962962962962962962962962962962963e-1 * t267 * t9 * t229 * t269 + 0.35592592592592592592592592592592592592592592592591e-2 * t21 * t5 * t53 * t229 * t269 + 0.68888888888888888888888888888888888888888888888888e-1 * t267 * t268 * t275 * jnp.pi + 0.4e1 / 0.3e1 * t229 * (-0.55000000000000000000000000000000000000000000000000e0 * t491 + 0.5e1 / 0.18e2 * t499) * t234 + 0.8e1 / 0.3e1 * t276 * jnp.pi
  t707 = t607 / 0.2e1 + 0.62700000000000000000000000000000000000000000000000e-1 * t611 * t3 * t294 - 0.41800000000000000000000000000000000000000000000000e-1 * t293 * t190 * t177 + 0.78625800000000000000000000000000000000000000000000e-2 * t616 * t20 * t364 * t177
  t738 = -t632 - t638 - t642 - t645 + t652 - t663 + 0.33245444444444444444444444444444444444444444444444e-1 * t164 * t301 * t304 + 0.12155555555555555555555555555555555555555555555555e0 * t322 * t323 * t329 + t301 * (-0.43111111111111111111111111111111111111111111111111e-1 * t491 + 0.18777777777777777777777777777777777777777777777778e0 * t499) * t1 * t309 / 0.3e1 + 0.4e1 / 0.9e1 * t331 * t334 - 0.2e1 / 0.27e2 * t306 * t308 * t9 + 0.2e1 / 0.135e3 * t312 * t639
  t749 = -t471 - t475 - t482 + t504 + t512 + t516 + t520 + t527 - t538 - t546
  t761 = t163 ** 2
  t762 = 0.1e1 / t761
  t815 = t104 * ((-t550 + t552 + t121 * t488 / 0.9e1 + 0.16322666666666666666666666666666666666666666666667e0 * t124 * t40 * t19 * t485 + 0.32645333333333333333333333333333333333333333333333e0 * t126 * t488) * t137 - 0.2e1 * t129 * t146 * t150 + 0.2e1 * t144 / t145 / t136 * t569 - t147 * (-t550 + t552 + 0.38316777777777777777777777777777777777777777777777e0 * t132 * t488)) * t158 - t153 / t579 * t136 * t157 * t129 + t153 * t154 * t150 * t157 + (-0.35086488218440119971277336305861670150000000000000e0 * t162 * t378 * t180 + 0.35086488218440119971277336305861670150000000000000e0 * t165 * t195 + 0.36665380188269925369984816439625445306750000000000e-1 * t162 * t594 * t199 * t202 - 0.17543244109220059985638668152930835075000000000000e0 * t183 * t607 * t179 - 0.21999228112961955221990889863775267184050000000000e-1 * t198 * t611 * t202 - 0.27587032053654291848376575889174185048798700000000e-2 * t162 * t402 * t616 * t464 * t201 - 0.13511476199097855178160642771283718172375652225094e-1 * t207 * t402 * t237 * t239 + 0.10133607149323391383620482078462788629281739168821e-1 * t207 * t209 * t281 * t239 - 0.30400821447970174150861446235388365887845217506462e-2 * t207 * t53 * t685 * t239) * t124 + (-0.52629732327660179956916004458792505225000000000000e0 * t601 * t289 + 0.52629732327660179956916004458792505225000000000000e0 * t186 * t297 - 0.26314866163830089978458002229396252612500000000000e0 * t169 * t707 - 0.16889345248872318972700803464104647715469565281367e-1 * t207 * t402 * t315 * jnp.pi + 0.12667008936654239229525602598078485786602173961026e-1 * t207 * t209 * t339 * jnp.pi - 0.38001026809962717688576807794235457359806521883077e-2 * t207 * t53 * t738 * jnp.pi + 0.13287210228946179141882035000000000000000000000000e1 * t172 * t603 * t349 - 0.11389037339096724978756030000000000000000000000000e1 * t172 * t190 * t357 + 0.42708890021612718670335112500000000000000000000000e0 * t172 * t10 * t749) * t362 - 0.30025502664661900395912539491741595938612560500208e-1 * t206 * t5 * t402 * t368 + 0.22519126998496425296934404618806196953959420375156e-1 * t365 * t372 + 0.23720747615136194550778824449265695623422695046375e-1 * t376 * t762 * t175 * t381 - 0.67557380995489275890803213856418590861878261125470e-2 * t371 * t607 * t367 - 0.10166034692201226236048067621113869552895440734161e-1 * t379 * t193 * t381 - 0.31870518760050844250010691992191981048327206701594e-3 * t376 / t7 / t761 * t199 * t42 * t381 + (-0.45038253996992850593868809237612393907918840750312e-1 * t207 * t402 * t289 * jnp.pi + 0.33778690497744637945401606928209295430939130562734e-1 * t207 * t209 * t297 * jnp.pi - 0.10133607149323391383620482078462788629281739168820e-1 * t207 * t53 * t707 * jnp.pi + 0.31577839396596107974149602675275503135000000000000e1 * t157 * t762 * t349 - 0.21051892931064071982766401783517002090000000000000e1 * t392 * t357 + 0.52629732327660179956916004458792505225000000000000e0 * t395 * t749) * t399 + 0.19816831758676854261302276064549453319484289930138e0 * t207 / t22 / t761 * t349 * t404 - 0.10809180959278284142528514217026974537900521780075e0 * t207 * t402 * t357 * t404 + 0.20267214298646782767240964156925577258563478337641e-1 * t207 * t209 * t749 * t404
  t834 = -t471 - t475 - t482 + t504 + t512 + t516 + t520 + t527 - t538 - t546 - t815 * t419 - 0.82152657680133333333333333333333333333333333333336e0 * t412 * t461 * t19 * t466 - 0.63272429661648472104200166666666666666666666666669e0 * t459 / t418 / t417 * t1 * t171 * t6 * t594 * t362 + 0.68460548066777777777777777777777777777777777777780e0 * t463 * t464 * t209 * t119
  v2rho2_0_ = 0.22147155666666666666666666666666666666666666666666e-2 * t33 + 0.20000000000000000000000000000000000000000000000000e1 * t60 - 0.36623110073506319882614459966279143890273293327586e-3 * t85 - 0.11696446794910408141662685001236899248561775660981e1 * t100 - 0.2e1 * t412 * t419 - 0.82152657680133333333333333333333333333333333333336e0 * t463 * t466 + r0 * t834
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = jnp.log(0.2e1)
  t2 = t1 - 0.1e1
  t3 = 0.2e1 * t2
  t4 = 3 ** (0.1e1 / 0.3e1)
  t5 = 0.1e1 / jnp.pi
  t6 = t5 ** (0.1e1 / 0.3e1)
  t7 = t4 * t6
  t8 = 4 ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t10 = r0 ** (0.1e1 / 0.3e1)
  t11 = 0.1e1 / t10
  t12 = t9 * t11
  t13 = t7 * t12
  t14 = jnp.sqrt(t13)
  t15 = t14 * t13
  t16 = 0.1e1 / t15
  t18 = t4 ** 2
  t19 = f.p.cam_omega * t16 * t18
  t20 = t6 ** 2
  t21 = t20 * t8
  t22 = r0 ** 2
  t23 = t10 ** 2
  t25 = 0.1e1 / t23 / t22
  t26 = t21 * t25
  t28 = 0.32478055555555555555555555555555555555555555555555e0 * t19 * t26
  t29 = 0.1e1 / t14
  t31 = f.p.cam_omega * t29 * t4
  t32 = t6 * t9
  t34 = 0.1e1 / t10 / t22
  t35 = t32 * t34
  t37 = 0.64956111111111111111111111111111111111111111111111e0 * t31 * t35
  t39 = 9 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t48 = f.p.cam_omega ** 2
  t50 = (0.344851e1 - jnp.pi * t8 * t40 * t6 / t2 / 0.12e2) * t48 * t4
  t53 = t48 * f.p.cam_omega
  t55 = t53 * t29 * t18
  t59 = t53 * t14 * t4
  t62 = -t28 + t37 + t50 * t35 / 0.9e1 + 0.16322666666666666666666666666666666666666666666667e0 * t55 * t26 + 0.32645333333333333333333333333333333333333333333333e0 * t59 * t35
  t64 = 0.29230250000000000000000000000000000000000000000000e1 * f.p.cam_omega * t14
  t65 = t48 * t4
  t66 = t32 * t11
  t69 = 0.1e1 + t64 + 0.86212750000000000000000000000000000000000000000000e0 * t65 * t66
  t70 = 0.1e1 / t69
  t73 = 0.1e1 / t10 / r0
  t74 = t32 * t73
  t76 = 0.48717083333333333333333333333333333333333333333333e0 * t31 * t74
  t81 = -t76 - t50 * t74 / 0.12e2 - 0.24484000000000000000000000000000000000000000000000e0 * t59 * t74
  t82 = t69 ** 2
  t83 = 0.1e1 / t82
  t84 = t81 * t83
  t87 = -t76 - 0.28737583333333333333333333333333333333333333333333e0 * t65 * t74
  t94 = 0.1e1 + t64 + t50 * t66 / 0.4e1 + 0.48968000000000000000000000000000000000000000000000e0 * t53 * t15
  t96 = 0.1e1 / t82 / t69
  t97 = t94 * t96
  t98 = t87 ** 2
  t101 = t94 * t83
  t104 = -t28 + t37 + 0.38316777777777777777777777777777777777777777777777e0 * t65 * t35
  t107 = t3 * (-t101 * t104 + t62 * t70 - 0.2e1 * t84 * t87 + 0.2e1 * t97 * t98)
  t108 = 0.1e1 / t94
  t110 = jnp.pi ** 2
  t111 = 0.1e1 / t110
  t112 = t108 * t69 * t111
  t117 = t3 * (-t101 * t87 + t81 * t70)
  t118 = t94 ** 2
  t119 = 0.1e1 / t118
  t120 = t117 * t119
  t121 = t69 * t111
  t122 = t121 * t81
  t125 = t108 * t87 * t111
  t127 = jnp.sqrt(jnp.pi)
  t129 = 0.1e1 / t127 / jnp.pi
  t130 = t22 * r0
  t131 = 0.1e1 / t130
  t132 = t129 * t131
  t134 = t18 * t20
  t135 = 0.1e1 / t23
  t136 = t8 * t135
  t137 = t134 * t136
  t139 = 0.1e1 / r0
  t140 = t5 * t139
  t142 = t6 * t5
  t143 = t4 * t142
  t144 = t9 * t73
  t147 = 0.1e1 + 0.51750000000000000000000000000000000000000000000000e-2 * t13 + 0.20482500000000000000000000000000000000000000000000e-1 * t137 - 0.95775000000000000000000000000000000000000000000000e-2 * t140 + 0.34856250000000000000000000000000000000000000000000e-3 * t143 * t144
  t149 = jnp.exp(-0.18810000000000000000000000000000000000000000000000e0 * t13)
  t150 = t147 * t149
  t151 = jnp.sqrt(0.2e1)
  t152 = t150 * t151
  t155 = 0.1e1 / t22
  t156 = t129 * t155
  t157 = t7 * t144
  t160 = 0.1e1 / t23 / r0
  t161 = t8 * t160
  t162 = t134 * t161
  t164 = t5 * t155
  t166 = t9 * t34
  t169 = -0.17250000000000000000000000000000000000000000000000e-2 * t157 - 0.13655000000000000000000000000000000000000000000000e-1 * t162 + 0.95775000000000000000000000000000000000000000000000e-2 * t164 - 0.46475000000000000000000000000000000000000000000000e-3 * t143 * t166
  t170 = t169 * t149
  t171 = t170 * t151
  t175 = 0.1e1 / t10 / t130
  t176 = t129 * t175
  t177 = t147 * t4
  t179 = t149 * t151
  t180 = t32 * t179
  t183 = t129 * t139
  t184 = t7 * t166
  t186 = t8 * t25
  t187 = t134 * t186
  t189 = t5 * t131
  t191 = t9 * t175
  t194 = 0.23000000000000000000000000000000000000000000000000e-2 * t184 + 0.22758333333333333333333333333333333333333333333333e-1 * t187 - 0.19155000000000000000000000000000000000000000000000e-1 * t189 + 0.10844166666666666666666666666666666666666666666667e-2 * t143 * t191
  t195 = t194 * t149
  t196 = t195 * t151
  t199 = t129 * t34
  t200 = t169 * t4
  t205 = 0.1e1 / t23 / t130
  t206 = t129 * t205
  t207 = t147 * t18
  t209 = t21 * t179
  t213 = t18 * t20 * t111
  t214 = t213 * t8
  t215 = 2 ** (0.1e1 / 0.3e1)
  t217 = t7 * t12 * t215
  t220 = (0.1e1 - 0.56675000000000000000000000000000000000000000000000e-2 * t217) * t40
  t221 = 0.1e1 / t142
  t222 = t220 * t221
  t223 = t4 * t23
  t225 = t215 ** 2
  t229 = 0.1e1 + 0.10797500000000000000000000000000000000000000000000e0 * t217 + 0.10000000000000000000000000000000000000000000000000e-1 * t134 * t136 * t225
  t230 = 0.1e1 / t229
  t233 = t222 * t223 * t230 / 0.15e2
  t235 = jnp.exp(-0.77500000000000000000000000000000000000000000000000e-1 * t13)
  t238 = -0.12375000000000000000000000000000000000000000000000e1 * t13 + t137 / 0.4e1
  t239 = t235 * t238
  t240 = jnp.pi * r0
  t243 = t233 + 0.4e1 / 0.3e1 * t239 * t240
  t245 = t151 * t127
  t249 = t18 * jnp.pi
  t250 = t249 * t9
  t252 = t40 * t230
  t255 = 0.12594444444444444444444444444444444444444444444445e-3 * t250 * t135 * t215 * t252
  t256 = t4 * t11
  t259 = 0.2e1 / 0.45e2 * t222 * t256 * t230
  t260 = t229 ** 2
  t261 = 0.1e1 / t260
  t268 = -0.35991666666666666666666666666666666666666666666667e-1 * t7 * t144 * t215 - 0.66666666666666666666666666666666666666666666666667e-2 * t134 * t161 * t225
  t269 = t261 * t268
  t272 = t222 * t223 * t269 / 0.15e2
  t273 = t7 * t9
  t274 = t11 * t235
  t275 = t238 * jnp.pi
  t281 = 0.41250000000000000000000000000000000000000000000000e0 * t157 - t162 / 0.6e1
  t282 = t235 * t281
  t287 = t255 + t259 - t272 + 0.34444444444444444444444444444444444444444444444444e-1 * t273 * t274 * t275 + 0.4e1 / 0.3e1 * t282 * t240 + 0.4e1 / 0.3e1 * t239 * jnp.pi
  t295 = 0.3e-53 * t250 * t160 * t215 * t252
  t297 = t249 * t9 * t135
  t298 = t215 * t40
  t301 = 0.25188888888888888888888888888888888888888888888890e-3 * t297 * t298 * t269
  t302 = t4 * t73
  t305 = 0.2e1 / 0.135e3 * t222 * t302 * t230
  t308 = 0.4e1 / 0.45e2 * t222 * t256 * t269
  t310 = 0.1e1 / t260 / t229
  t311 = t268 ** 2
  t312 = t310 * t311
  t315 = 0.2e1 / 0.15e2 * t222 * t223 * t312
  t322 = 0.47988888888888888888888888888888888888888888888889e-1 * t7 * t166 * t215 + 0.11111111111111111111111111111111111111111111111111e-1 * t134 * t186 * t225
  t323 = t261 * t322
  t326 = t222 * t223 * t323 / 0.15e2
  t327 = t73 * t235
  t331 = t134 * t8
  t332 = t160 * t235
  t336 = t281 * jnp.pi
  t342 = -0.55000000000000000000000000000000000000000000000000e0 * t184 + 0.5e1 / 0.18e2 * t187
  t343 = t235 * t342
  t348 = -t295 - t301 - t305 - t308 + t315 - t326 + 0.22962962962962962962962962962962962962962962962963e-1 * t273 * t327 * t275 + 0.35592592592592592592592592592592592592592592592591e-2 * t331 * t332 * t275 + 0.68888888888888888888888888888888888888888888888888e-1 * t273 * t274 * t336 + 0.4e1 / 0.3e1 * t343 * t240 + 0.8e1 / 0.3e1 * t282 * jnp.pi
  t356 = t150 / 0.2e1 - 0.1e1 / 0.2e1
  t360 = t177 * t6
  t361 = t144 * t149
  t364 = t170 / 0.2e1 + 0.31350000000000000000000000000000000000000000000000e-1 * t360 * t361
  t368 = t200 * t6
  t371 = t166 * t149
  t374 = t207 * t20
  t375 = t186 * t149
  t378 = t195 / 0.2e1 + 0.62700000000000000000000000000000000000000000000000e-1 * t368 * t361 - 0.41800000000000000000000000000000000000000000000000e-1 * t360 * t371 + 0.78625800000000000000000000000000000000000000000000e-2 * t374 * t375
  t382 = jnp.exp(-0.13675000000000000000000000000000000000000000000000e0 * t13)
  t385 = -0.97000000000000000000000000000000000000000000000000e-1 * t13 + 0.16900000000000000000000000000000000000000000000000e0 * t137
  t387 = t382 * t385 * t4
  t389 = 0.1e1 / t20 * t9
  t390 = t389 * t23
  t393 = t40 * t221
  t396 = t233 + t387 * t390 / 0.3e1 - t393 * t223 / 0.15e2
  t403 = t18 / t6 * t8
  t404 = t135 * t382
  t410 = 0.32333333333333333333333333333333333333333333333333e-1 * t157 - 0.11266666666666666666666666666666666666666666666667e0 * t162
  t412 = t382 * t410 * t4
  t415 = t389 * t11
  t420 = t255 + t259 - t272 + 0.60777777777777777777777777777777777777777777777777e-1 * t403 * t404 * t385 + t412 * t390 / 0.3e1 + 0.2e1 / 0.9e1 * t387 * t415 - 0.2e1 / 0.45e2 * t393 * t256
  t425 = t155 * t382
  t433 = -0.43111111111111111111111111111111111111111111111111e-1 * t184 + 0.18777777777777777777777777777777777777777777777778e0 * t187
  t435 = t382 * t433 * t4
  t440 = t389 * t73
  t445 = -t295 - t301 - t305 - t308 + t315 - t326 + 0.33245444444444444444444444444444444444444444444444e-1 * t425 * t385 + 0.12155555555555555555555555555555555555555555555555e0 * t403 * t404 * t410 + t435 * t390 / 0.3e1 + 0.4e1 / 0.9e1 * t412 * t415 - 0.2e1 / 0.27e2 * t387 * t440 + 0.2e1 / 0.135e3 * t393 * t302
  t451 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t13
  t454 = t13 ** 0.15e1
  t457 = 0.37978500000000000000000000000000000000000000000000e1 * t14 + 0.89690000000000000000000000000000000000000000000000e0 * t13 + 0.20477500000000000000000000000000000000000000000000e0 * t454 + 0.12323500000000000000000000000000000000000000000000e0 * t137
  t460 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t457
  t461 = jnp.log(t460)
  t465 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t467 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t465 * f.p.zeta_threshold, 1)
  t473 = (0.2e1 * t467 - 0.2e1) / (0.2e1 * t215 - 0.2e1)
  t475 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t13
  t480 = 0.51785000000000000000000000000000000000000000000000e1 * t14 + 0.90577500000000000000000000000000000000000000000000e0 * t13 + 0.11003250000000000000000000000000000000000000000000e0 * t454 + 0.12417750000000000000000000000000000000000000000000e0 * t137
  t483 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t480
  t484 = jnp.log(t483)
  t488 = -0.62182e-1 * t451 * t461 + 0.19751789702565206228825776161588751761046270558698e-1 * t473 * t475 * t484
  t495 = t457 ** 2
  t496 = 0.1e1 / t495
  t497 = t451 * t496
  t498 = t29 * t4
  t499 = t498 * t74
  t502 = t13 ** 0.5e0
  t503 = t502 * t4
  t504 = t503 * t74
  t507 = -0.63297500000000000000000000000000000000000000000000e0 * t499 - 0.29896666666666666666666666666666666666666666666667e0 * t157 - 0.10238750000000000000000000000000000000000000000000e0 * t504 - 0.82156666666666666666666666666666666666666666666667e-1 * t162
  t508 = 0.1e1 / t460
  t509 = t507 * t508
  t512 = t473 * t4
  t517 = t473 * t475
  t518 = t480 ** 2
  t519 = 0.1e1 / t518
  t524 = -0.86308333333333333333333333333333333333333333333334e0 * t499 - 0.30192500000000000000000000000000000000000000000000e0 * t157 - 0.55016250000000000000000000000000000000000000000000e-1 * t504 - 0.82785000000000000000000000000000000000000000000000e-1 * t162
  t526 = 0.1e1 / t483
  t527 = t519 * t524 * t526
  t530 = 0.11073577833333333333333333333333333333333333333333e-2 * t7 * t144 * t461 + 0.10000000000000000000000000000000000000000000000000e1 * t497 * t509 - 0.18311555036753159941307229983139571945136646663793e-3 * t512 * t32 * t73 * t484 - 0.58482233974552040708313425006184496242808878304903e0 * t517 * t527
  t535 = t7 * t166 * t461
  t537 = t73 * t496
  t539 = t273 * t537 * t509
  t542 = 0.1e1 / t495 / t457
  t543 = t451 * t542
  t544 = t507 ** 2
  t545 = t544 * t508
  t546 = t543 * t545
  t548 = t16 * t18
  t549 = t548 * t26
  t551 = t498 * t35
  t554 = t13 ** (-0.5e0)
  t555 = t554 * t18
  t556 = t555 * t26
  t558 = t503 * t35
  t561 = -0.42198333333333333333333333333333333333333333333333e0 * t549 + 0.84396666666666666666666666666666666666666666666666e0 * t551 + 0.39862222222222222222222222222222222222222222222223e0 * t184 + 0.68258333333333333333333333333333333333333333333333e-1 * t556 + 0.13651666666666666666666666666666666666666666666667e0 * t558 + 0.13692777777777777777777777777777777777777777777778e0 * t187
  t562 = t561 * t508
  t563 = t497 * t562
  t565 = t495 ** 2
  t566 = 0.1e1 / t565
  t567 = t451 * t566
  t568 = t460 ** 2
  t569 = 0.1e1 / t568
  t570 = t544 * t569
  t571 = t567 * t570
  t575 = t512 * t32 * t34 * t484
  t577 = t473 * t7
  t579 = t577 * t144 * t527
  t582 = 0.1e1 / t518 / t480
  t583 = t524 ** 2
  t585 = t582 * t583 * t526
  t586 = t517 * t585
  t594 = -0.57538888888888888888888888888888888888888888888889e0 * t549 + 0.11507777777777777777777777777777777777777777777778e1 * t551 + 0.40256666666666666666666666666666666666666666666667e0 * t184 + 0.36677500000000000000000000000000000000000000000000e-1 * t556 + 0.73355000000000000000000000000000000000000000000000e-1 * t558 + 0.13797500000000000000000000000000000000000000000000e0 * t187
  t596 = t519 * t594 * t526
  t597 = t517 * t596
  t599 = t518 ** 2
  t600 = 0.1e1 / t599
  t602 = t483 ** 2
  t603 = 0.1e1 / t602
  t604 = t600 * t583 * t603
  t605 = t517 * t604
  t607 = -0.14764770444444444444444444444444444444444444444444e-2 * t535 - 0.35616666666666666666666666666666666666666666666666e-1 * t539 - 0.20000000000000000000000000000000000000000000000000e1 * t546 + 0.10000000000000000000000000000000000000000000000000e1 * t563 + 0.16081824322151104821330931780901225435013347914188e2 * t571 + 0.24415406715670879921742973310852762593515528885057e-3 * t575 + 0.10843580882781524214666447553230042011687479519034e-1 * t579 + 0.11696446794910408141662685001236899248561775660981e1 * t586 - 0.58482233974552040708313425006184496242808878304903e0 * t597 - 0.17315755899375863299672358916972966258900005419821e2 * t605
  t612 = t48 ** 2
  t614 = t8 * t205
  t615 = t213 * t614
  t616 = t612 * f.p.cam_omega
  t617 = t245 * t616
  t618 = t150 * t617
  t621 = t213 * t186
  t622 = t170 * t617
  t626 = 0.1e1 / t127 / t110
  t627 = t22 ** 2
  t628 = 0.1e1 / t627
  t629 = t626 * t628
  t631 = t179 * t616
  t634 = t213 * t161
  t635 = t195 * t617
  t638 = t626 * t131
  t643 = 0.1e1 / t10 / t627
  t644 = t626 * t643
  t646 = t32 * t631
  t661 = t111 * t628
  t664 = t111 * t131
  t667 = t111 * t155
  t671 = t612 * t48
  t674 = 0.1e1 / t23 / t627
  t676 = t612 ** 2
  t688 = t107 * t112 - t120 * t122 + t117 * t125 + (-0.35086488218440119971277336305861670150000000000000e0 * t132 * t152 + 0.35086488218440119971277336305861670150000000000000e0 * t156 * t171 + 0.36665380188269925369984816439625445306750000000000e-1 * t176 * t177 * t180 - 0.17543244109220059985638668152930835075000000000000e0 * t183 * t196 - 0.21999228112961955221990889863775267184050000000000e-1 * t199 * t200 * t180 - 0.27587032053654291848376575889174185048798700000000e-2 * t206 * t207 * t209 - 0.13511476199097855178160642771283718172375652225094e-1 * t214 * t205 * t243 * t245 + 0.10133607149323391383620482078462788629281739168821e-1 * t214 * t25 * t287 * t245 - 0.30400821447970174150861446235388365887845217506462e-2 * t214 * t160 * t348 * t245) * t53 + (-0.52629732327660179956916004458792505225000000000000e0 * t189 * t356 + 0.52629732327660179956916004458792505225000000000000e0 * t164 * t364 - 0.26314866163830089978458002229396252612500000000000e0 * t140 * t378 - 0.16889345248872318972700803464104647715469565281367e-1 * t214 * t205 * t396 * jnp.pi + 0.12667008936654239229525602598078485786602173961026e-1 * t214 * t25 * t420 * jnp.pi - 0.38001026809962717688576807794235457359806521883077e-2 * t214 * t160 * t445 * jnp.pi + 0.13287210228946179141882035000000000000000000000000e1 * t143 * t191 * t488 - 0.11389037339096724978756030000000000000000000000000e1 * t143 * t166 * t530 + 0.42708890021612718670335112500000000000000000000000e0 * t143 * t144 * t607) * t612 - 0.30025502664661900395912539491741595938612560500208e-1 * t615 * t618 + 0.22519126998496425296934404618806196953959420375156e-1 * t621 * t622 + 0.23720747615136194550778824449265695623422695046375e-1 * t629 * t147 * t631 - 0.67557380995489275890803213856418590861878261125470e-2 * t634 * t635 - 0.10166034692201226236048067621113869552895440734161e-1 * t638 * t169 * t631 - 0.31870518760050844250010691992191981048327206701594e-3 * t644 * t177 * t646 + (-0.45038253996992850593868809237612393907918840750312e-1 * t214 * t205 * t356 * jnp.pi + 0.33778690497744637945401606928209295430939130562734e-1 * t214 * t25 * t364 * jnp.pi - 0.10133607149323391383620482078462788629281739168820e-1 * t214 * t160 * t378 * jnp.pi + 0.31577839396596107974149602675275503135000000000000e1 * t661 * t488 - 0.21051892931064071982766401783517002090000000000000e1 * t664 * t530 + 0.52629732327660179956916004458792505225000000000000e0 * t667 * t607) * t671 + 0.19816831758676854261302276064549453319484289930138e0 * t214 * t674 * t488 * t676 - 0.10809180959278284142528514217026974537900521780075e0 * t214 * t205 * t530 * t676 + 0.20267214298646782767240964156925577258563478337641e-1 * t214 * t25 * t607 * t676
  t692 = 0.1e1 + 0.15403623315025000000000000000000000000000000000000e0 * t134 * t136 * t48
  t693 = t692 ** 2
  t694 = t693 ** 2
  t695 = 0.1e1 / t694
  t703 = 0.1e1 / t14 / t137 / 0.4e1
  t705 = t703 * t5 * t628
  t707 = t21 * t205
  t708 = t548 * t707
  t710 = t32 * t175
  t711 = t498 * t710
  t713 = t7 * t191
  t715 = t13 ** (-0.15e1)
  t717 = t715 * t5 * t628
  t719 = t555 * t707
  t721 = t503 * t710
  t723 = t134 * t614
  t729 = 0.58482233974552040708313425006184496242808878304903e0 * t517 * t519 * (-0.34523333333333333333333333333333333333333333333333e1 * t705 + 0.23015555555555555555555555555555555555555555555556e1 * t708 - 0.26851481481481481481481481481481481481481481481482e1 * t711 - 0.93932222222222222222222222222222222222222222222223e0 * t713 + 0.73355000000000000000000000000000000000000000000000e-1 * t717 - 0.14671000000000000000000000000000000000000000000000e0 * t719 - 0.17116166666666666666666666666666666666666666666667e0 * t721 - 0.36793333333333333333333333333333333333333333333333e0 * t723) * t526
  t732 = t583 * t524
  t736 = 0.10389453539625517979803415350183779755340003251893e3 * t517 / t599 / t480 * t732 * t603
  t740 = 0.35089340384731224424988055003710697745685326982943e1 * t517 * t600 * t732 * t526
  t748 = 0.10253897021007794930818001372045340355835853271641e4 * t517 / t599 / t518 * t732 / t602 / t483
  t751 = 0.32530742648344572643999342659690126035062438557102e-1 * t577 * t144 * t585
  t754 = 0.21687161765563048429332895106460084023374959038068e-1 * t577 * t166 * t527
  t757 = 0.16265371324172286321999671329845063017531219278551e-1 * t577 * t144 * t596
  t760 = 0.48159446095139119802213748237831062407565640073877e0 * t577 * t144 * t604
  t762 = jnp.log(t94 * t70)
  t798 = t3 * t762 * t111 + (-0.17543244109220059985638668152930835075000000000000e0 * t183 * t152 - 0.30400821447970174150861446235388365887845217506462e-2 * t214 * t160 * t243 * t245) * t53 + (-0.26314866163830089978458002229396252612500000000000e0 * t140 * t356 - 0.38001026809962717688576807794235457359806521883077e-2 * t214 * t160 * t396 * jnp.pi + 0.42708890021612718670335112500000000000000000000000e0 * t143 * t144 * t488) * t612 - 0.67557380995489275890803213856418590861878261125470e-2 * t634 * t618 + (-0.10133607149323391383620482078462788629281739168820e-1 * t214 * t160 * t356 * jnp.pi + 0.52629732327660179956916004458792505225000000000000e0 * t667 * t488) * t671 + 0.20267214298646782767240964156925577258563478337641e-1 * t214 * t25 * t488 * t676
  t800 = 0.1e1 / t694 / t692
  t802 = t798 * t800 * t18
  t810 = t21 * t160 * t48
  t814 = 0.1e1 / t694 / t693
  t816 = t798 * t814 * t4
  t817 = t142 * t9
  t889 = t117 * t112 + (0.17543244109220059985638668152930835075000000000000e0 * t156 * t152 - 0.17543244109220059985638668152930835075000000000000e0 * t183 * t171 - 0.10999614056480977610995444931887633592025000000000e-1 * t199 * t177 * t180 + 0.50668035746616956918102410392313943146408695844103e-2 * t214 * t25 * t243 * t245 - 0.30400821447970174150861446235388365887845217506462e-2 * t214 * t160 * t287 * t245) * t53 + (0.26314866163830089978458002229396252612500000000000e0 * t164 * t356 - 0.26314866163830089978458002229396252612500000000000e0 * t140 * t364 + 0.63335044683271196147628012990392428933010869805128e-2 * t214 * t25 * t396 * jnp.pi - 0.38001026809962717688576807794235457359806521883077e-2 * t214 * t160 * t420 * jnp.pi - 0.56945186695483624893780150000000000000000000000000e0 * t143 * t166 * t488 + 0.42708890021612718670335112500000000000000000000000e0 * t143 * t144 * t530) * t612 + 0.11259563499248212648467202309403098476979710187578e-1 * t621 * t618 - 0.67557380995489275890803213856418590861878261125470e-2 * t634 * t622 - 0.50830173461006131180240338105569347764477203670804e-2 * t638 * t147 * t631 + (0.16889345248872318972700803464104647715469565281367e-1 * t214 * t25 * t356 * jnp.pi - 0.10133607149323391383620482078462788629281739168820e-1 * t214 * t160 * t364 * jnp.pi - 0.10525946465532035991383200891758501045000000000000e1 * t664 * t488 + 0.52629732327660179956916004458792505225000000000000e0 * t667 * t530) * t671 - 0.54045904796391420712642571085134872689502608900376e-1 * t214 * t205 * t488 * t676 + 0.20267214298646782767240964156925577258563478337641e-1 * t214 * t25 * t530 * t676
  t893 = t817 * t175 * t612
  t897 = t889 * t800 * t18
  t899 = t21 * t25 * t48
  t905 = 0.56969282336565386484066937725323112718202900731800e-3 * t512 * t32 * t175 * t484
  t906 = -t729 + t736 - t740 - t748 - t751 - t754 + t757 + t760 - 0.18256146151140740740740740740740740740740740740741e1 * t802 * t21 * t205 * t48 - 0.12322898652020000000000000000000000000000000000000e1 * t688 * t800 * t18 * t810 + 0.31636214830824236052100083333333333333333333333334e1 * t816 * t817 * t643 * t612 - 0.18981728898494541631260050000000000000000000000001e1 * t889 * t814 * t4 * t893 + 0.20538164420033333333333333333333333333333333333334e1 * t897 * t899 - t905
  t910 = 0.10685000000000000000000000000000000000000000000000e0 * t273 * t73 * t542 * t545
  t914 = 0.71233333333333333333333333333333333333333333333333e-1 * t273 * t34 * t496 * t509
  t917 = 0.53424999999999999999999999999999999999999999999999e-1 * t273 * t537 * t562
  t921 = 0.85917146441092277507960503039464796886558811231548e0 * t273 * t73 * t566 * t570
  t926 = 0.35089340384731224424988055003710697745685326982943e1 * t517 * t582 * t524 * t526 * t594
  t931 = 0.51947267698127589899017076750918898776700016259463e2 * t517 * t600 * t594 * t603 * t524
  t934 = 0.34451131037037037037037037037037037037037037037036e-2 * t7 * t191 * t461
  t938 = 0.48245472966453314463992795342703676305040043742564e2 * t567 * t561 * t569 * t507
  t941 = 0.60000000000000000000000000000000000000000000000000e1 * t543 * t509 * t561
  t946 = t627 * r0
  t947 = 0.1e1 / t946
  t948 = t111 * t947
  t955 = t544 * t507
  t958 = 0.96490945932906628927985590685407352610080087485128e2 * t451 / t565 / t457 * t955 * t569
  t961 = 0.60000000000000000000000000000000000000000000000000e1 * t567 * t955 * t508
  t973 = 0.10000000000000000000000000000000000000000000000000e1 * t497 * (-0.25319000000000000000000000000000000000000000000000e1 * t705 + 0.16879333333333333333333333333333333333333333333333e1 * t708 - 0.19692555555555555555555555555555555555555555555555e1 * t711 - 0.93011851851851851851851851851851851851851851851854e0 * t713 + 0.13651666666666666666666666666666666666666666666667e0 * t717 - 0.27303333333333333333333333333333333333333333333333e0 * t719 - 0.31853888888888888888888888888888888888888888888890e0 * t721 - 0.36514074074074074074074074074074074074074074074075e0 * t723) * t508
  t981 = 0.51725014705706168413145063783413931475389495076352e3 * t451 / t565 / t495 * t955 / t568 / t460
  t982 = t938 + t961 - t941 + t934 - t748 - t729 + t736 + t981 - t958 + t973 - t905
  t983 = t910 - t751 - t754 + t757 + t760 + t914 - t917 - t921 - t740 + t926 - t931
  t984 = t982 + t983
  t997 = t626 * t947
  t1008 = 0.1e1 / t23 / t946
  t1027 = 0.20267214298646782767240964156925577258563478337641e-1 * t214 * t25 * t984 * t676 - 0.16213771438917426213792771325540461806850782670113e0 * t214 * t205 * t607 * t676 + 0.59450495276030562783906828193648359958452869790413e0 * t214 * t674 * t530 * t676 - 0.11747417866543639206099989251064915927790287070586e0 * t997 * t147 * t631 + 0.71162242845408583652336473347797086870268085139125e-1 * t629 * t169 * t631 - 0.15249052038301839354072101431670804329343161101241e-1 * t638 * t194 * t631 - 0.92478548207158653219410621634564115490926686340644e0 * t214 * t1008 * t488 * t676 - t120 * t121 * t62 - 0.2e1 * t120 * t87 * t111 * t81 - 0.2e1 * t107 * t119 * t122 + t117 * t108 * t104 * t111 + 0.2e1 * t107 * t125
  t1029 = t5 * t628
  t1031 = 0.19486833333333333333333333333333333333333333333333e1 * f.p.cam_omega * t703 * t1029
  t1033 = 0.12991222222222222222222222222222222222222222222222e1 * t19 * t707
  t1035 = 0.15156425925925925925925925925925925925925925925926e1 * t31 * t710
  t1055 = t82 ** 2
  t1086 = t9 * t643
  t1090 = (-0.53666666666666666666666666666666666666666666666667e-2 * t713 - 0.60688888888888888888888888888888888888888888888888e-1 * t723 + 0.57465000000000000000000000000000000000000000000000e-1 * t1029 - 0.36147222222222222222222222222222222222222222222223e-2 * t143 * t1086) * t149
  t1092 = t194 * t4
  t1098 = t169 * t18
  t1112 = t1090 / 0.2e1 + 0.94050000000000000000000000000000000000000000000000e-1 * t1092 * t6 * t361 - 0.12540000000000000000000000000000000000000000000000e0 * t368 * t371 + 0.23587740000000000000000000000000000000000000000000e-1 * t1098 * t20 * t375 + 0.97533333333333333333333333333333333333333333333333e-1 * t360 * t191 * t149 - 0.31450320000000000000000000000000000000000000000000e-1 * t374 * t614 * t149 + 0.59158051920000000000000000000000000000000000000000e-2 * t147 * t5 * t628 * t149
  t1158 = t4 * t34
  t1161 = 0.8e1 / 0.405e3 * t222 * t1158 * t230
  t1164 = 0.2e1 / 0.45e2 * t222 * t302 * t269
  t1167 = 0.2e1 / 0.15e2 * t222 * t256 * t323
  t1178 = t222 * t223 * t261 * (-0.11197407407407407407407407407407407407407407407407e0 * t7 * t191 * t215 - 0.29629629629629629629629629629629629629629629629629e-1 * t134 * t614 * t225) / 0.15e2
  t1207 = 0.4e1 / 0.15e2 * t222 * t256 * t312
  t1208 = t260 ** 2
  t1214 = 0.2e1 / 0.5e1 * t222 * t223 / t1208 * t311 * t268
  t1221 = 0.2e1 / 0.5e1 * t220 * t221 * t4 * t23 * t310 * t268 * t322
  t1225 = 0.27987654320987654320987654320987654320987654320983e-4 * t250 * t25 * t215 * t252
  t1228 = 0.37783333333333333333333333333333333333333333333335e-3 * t297 * t298 * t323
  t1231 = 0.75566666666666666666666666666666666666666666666669e-3 * t297 * t298 * t312
  t1234 = -0.13506172839506172839506172839506172839506172839506e-1 * t403 * t25 * t382 * t385 + 0.15154381759259259259259259259259259259259259259259e-2 * t175 * t4 * t6 * t9 * t382 * t385 + 0.18233333333333333333333333333333333333333333333333e0 * t403 * t404 * t433 + t382 * (0.10059259259259259259259259259259259259259259259259e0 * t713 - 0.50074074074074074074074074074074074074074074074075e0 * t723) * t4 * t390 / 0.3e1 + t1207 - t1214 + t1221 - t1225 - t1228 + t1231 + 0.99736333333333333333333333333333333333333333333330e-1 * t425 * t410
  t1252 = 0.15788919698298053987074801337637751567500000000000e1 * t1029 * t356 - 0.15788919698298053987074801337637751567500000000000e1 * t189 * t364 + 0.78944598491490269935374006688188757837500000000000e0 * t164 * t378 - 0.26314866163830089978458002229396252612500000000000e0 * t140 * t1112 + 0.61927599245865169566569612701717041623388406031679e-1 * t214 * t674 * t396 * jnp.pi - 0.50668035746616956918102410392313943146408695844103e-1 * t214 * t205 * t420 * jnp.pi + 0.19000513404981358844288403897117728679903260941539e-1 * t214 * t25 * t445 * jnp.pi - 0.38001026809962717688576807794235457359806521883077e-2 * t214 * t160 * (-0.2e1 / 0.9e1 * t412 * t440 + 0.8e1 / 0.81e2 * t387 * t389 * t34 + 0.2e-50 * t403 * t160 * t382 * t410 + 0.2e1 / 0.3e1 * t435 * t415 + t1161 + t1164 - t1167 - t1178 - 0.8e1 / 0.405e3 * t393 * t1158 - 0.66490888888888888888888888888888888888888888888888e-1 * t131 * t382 * t385 + t1234) * jnp.pi - 0.44290700763153930472940116666666666666666666666667e1 * t143 * t1086 * t488 + 0.39861630686838537425646105000000000000000000000000e1 * t143 * t191 * t530 - 0.17083556008645087468134045000000000000000000000000e1 * t143 * t166 * t607 + 0.42708890021612718670335112500000000000000000000000e0 * t143 * t144 * t984
  t1324 = t1161 + t1164 - t1167 - t1178 + 0.68888888888888888888888888888888888888888888888888e-1 * t273 * t327 * t336 - 0.35592592592592592592592592592592592592592592592590e-2 * t331 * t25 * t235 * t275 + 0.10677777777777777777777777777777777777777777777777e-1 * t331 * t332 * t336 + 0.10333333333333333333333333333333333333333333333333e0 * t273 * t274 * t342 * jnp.pi + 0.4e1 / 0.3e1 * t235 * (0.12833333333333333333333333333333333333333333333333e1 * t713 - 0.20e2 / 0.27e2 * t723) * t240 + 0.4e1 * t343 * jnp.pi + t1207 - t1214 + t1221 - 0.30617283950617283950617283950617283950617283950617e-1 * t273 * t34 * t235 * t275 - t1225 - t1228 + t1231 + 0.11033703703703703703703703703703703703703703703703e-2 * t131 * t235 * t238
  t1329 = 0.10525946465532035991383200891758501045000000000000e1 * t129 * t628 * t152 - 0.10525946465532035991383200891758501045000000000000e1 * t132 * t171 - 0.14421716207386170645527361132919341820655000000000e0 * t129 * t643 * t177 * t180 + 0.52629732327660179956916004458792505225000000000000e0 * t156 * t196 + 0.10999614056480977610995444931887633592025000000000e0 * t176 * t200 * t180 + 0.19310922437558004293863603122421929534159090000000e-1 * t129 * t674 * t207 * t209 - 0.17543244109220059985638668152930835075000000000000e0 * t183 * t1090 * t151 - 0.32998842169442932832986334795662900776075000000000e-1 * t199 * t1092 * t180 - 0.82761096160962875545129727667522555146396100000000e-2 * t206 * t1098 * t209 - 0.20756482917169489186718535699014656830716141880000e-2 * t997 * t152 + 0.49542079396692135653255690161373633298710724825345e-1 * t214 * t674 * t243 * t245 - 0.40534428597293565534481928313851154517126956675283e-1 * t214 * t205 * t287 * t245 + 0.15200410723985087075430723117694182943922608753231e-1 * t214 * t25 * t348 * t245 - 0.30400821447970174150861446235388365887845217506462e-2 * t214 * t160 * t1324 * t245
  t1334 = t81 ** 2
  t1363 = t3 * ((-t1031 + t1033 - t1035 - 0.7e1 / 0.27e2 * t50 * t710 + 0.32645333333333333333333333333333333333333333333334e0 * t53 * t16 * t1029 - 0.65290666666666666666666666666666666666666666666667e0 * t55 * t707 - 0.76172444444444444444444444444444444444444444444444e0 * t59 * t710) * t70 - 0.3e1 * t62 * t83 * t87 + 0.6e1 * t81 * t96 * t98 - 0.3e1 * t84 * t104 - 0.6e1 * t94 / t1055 * t98 * t87 + 0.6e1 * t97 * t87 * t104 - t101 * (-t1031 + t1033 - t1035 - 0.89405814814814814814814814814814814814814814814813e0 * t65 * t710)) * t112 + (0.16514026465564045217751896720457877766236908275114e0 * t214 * t674 * t356 * jnp.pi - 0.13511476199097855178160642771283718172375652225094e0 * t214 * t205 * t364 * jnp.pi + 0.50668035746616956918102410392313943146408695844101e-1 * t214 * t25 * t378 * jnp.pi - 0.10133607149323391383620482078462788629281739168820e-1 * t214 * t160 * t1112 * jnp.pi - 0.12631135758638443189659841070110201254000000000000e2 * t948 * t488 + 0.94733518189788323922448808025826509405000000000000e1 * t661 * t530 - 0.31577839396596107974149602675275503135000000000000e1 * t664 * t607 + 0.52629732327660179956916004458792505225000000000000e0 * t667 * t984) * t671 + t1252 * t612 + t1329 * t53 + 0.2e1 * t117 / t118 / t94 * t121 * t1334 + 0.11009350977042696811834597813638585177491272183410e0 * t213 * t8 * t674 * t618 - 0.90076507993985701187737618475224787815837681500624e-1 * t615 * t622 + 0.33778690497744637945401606928209295430939130562734e-1 * t621 * t635 + 0.28683466884045759825009622792972782943494486031434e-2 * t626 / t10 / t946 * t177 * t646 - 0.67557380995489275890803213856418590861878261125470e-2 * t634 * t1090 * t617 - 0.95611556280152532750032075976575943144981620104783e-3 * t644 * t200 * t646 - 0.79931261050207517379026815516417488469204634407598e-4 * t626 * t1008 * t207 * t21 * t631
  t1366 = t910 + t914 - t917 - t921 + t926 - t931 + t934 + t938 - t941 - 0.46781984291253493295036448407815560200000000000002e1 * t798 / t694 / t693 / t692 * t948 * t671 - t958 + t961 + t973 + t981 - (t1027 + t1363) * t695
  v3rho3_0_ = -0.3e1 * t688 * t695 - 0.51947267698127589899017076750918898776700016259464e2 * t605 + 0.35089340384731224424988055003710697745685326982943e1 * t586 - 0.17544670192365612212494027501855348872842663491471e1 * t597 + r0 * (t906 + t1366) + 0.48245472966453314463992795342703676305040043742564e2 * t571 - 0.60000000000000000000000000000000000000000000000000e1 * t546 + 0.30000000000000000000000000000000000000000000000000e1 * t563 - 0.18981728898494541631260050000000000000000000000001e1 * t816 * t893 + 0.20538164420033333333333333333333333333333333333334e1 * t802 * t899 - 0.24645797304040000000000000000000000000000000000001e1 * t897 * t810 - 0.10685000000000000000000000000000000000000000000000e0 * t539 + 0.73246220147012639765228919932558287780546586655172e-3 * t575 - 0.44294311333333333333333333333333333333333333333332e-2 * t535 + 0.32530742648344572643999342659690126035062438557102e-1 * t579

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t10 = t4 * t9
  t12 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t22 = 0.1e1 / t21
  t23 = t5 * t22
  t24 = t20 * t23
  t26 = 0.37978500000000000000000000000000000000000000000000e1 * t13 + 0.89690000000000000000000000000000000000000000000000e0 * t10 + 0.20477500000000000000000000000000000000000000000000e0 * t16 + 0.12323500000000000000000000000000000000000000000000e0 * t24
  t27 = t26 ** 2
  t28 = t27 ** 2
  t29 = 0.1e1 / t28
  t30 = t12 * t29
  t31 = 0.1e1 / t13
  t32 = t31 * t1
  t33 = t3 * t6
  t35 = 0.1e1 / t7 / r0
  t36 = t33 * t35
  t37 = t32 * t36
  t39 = t6 * t35
  t40 = t4 * t39
  t42 = t10 ** 0.5e0
  t43 = t42 * t1
  t44 = t43 * t36
  t47 = 0.1e1 / t21 / r0
  t48 = t5 * t47
  t49 = t20 * t48
  t51 = -0.63297500000000000000000000000000000000000000000000e0 * t37 - 0.29896666666666666666666666666666666666666666666667e0 * t40 - 0.10238750000000000000000000000000000000000000000000e0 * t44 - 0.82156666666666666666666666666666666666666666666667e-1 * t49
  t52 = t51 ** 2
  t53 = t52 * t51
  t56 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t26
  t57 = 0.1e1 / t56
  t58 = t53 * t57
  t59 = t30 * t58
  t62 = 0.1e1 / t28 / t27
  t63 = t12 * t62
  t64 = t56 ** 2
  t66 = 0.1e1 / t64 / t56
  t67 = t53 * t66
  t68 = t63 * t67
  t71 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t73 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t71 * f.p.zeta_threshold, 1)
  t76 = 2 ** (0.1e1 / 0.3e1)
  t80 = (0.2e1 * t73 - 0.2e1) / (0.2e1 * t76 - 0.2e1)
  t81 = t80 * t1
  t82 = r0 ** 2
  t83 = t82 * r0
  t85 = 0.1e1 / t7 / t83
  t90 = 0.51785000000000000000000000000000000000000000000000e1 * t13 + 0.90577500000000000000000000000000000000000000000000e0 * t10 + 0.11003250000000000000000000000000000000000000000000e0 * t16 + 0.12417750000000000000000000000000000000000000000000e0 * t24
  t93 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t90
  t94 = jnp.log(t93)
  t97 = t81 * t33 * t85 * t94
  t99 = t4 * t6
  t100 = t27 * t26
  t101 = 0.1e1 / t100
  t103 = t52 * t57
  t105 = t99 * t35 * t101 * t103
  t108 = 0.1e1 / t7 / t82
  t109 = 0.1e1 / t27
  t110 = t108 * t109
  t111 = t51 * t57
  t113 = t99 * t110 * t111
  t115 = t35 * t109
  t116 = t13 * t10
  t117 = 0.1e1 / t116
  t118 = t117 * t18
  t119 = t19 * t5
  t121 = 0.1e1 / t21 / t82
  t122 = t119 * t121
  t123 = t118 * t122
  t125 = t33 * t108
  t126 = t32 * t125
  t128 = t6 * t108
  t129 = t4 * t128
  t131 = t10 ** (-0.5e0)
  t132 = t131 * t18
  t133 = t132 * t122
  t135 = t43 * t125
  t137 = t5 * t121
  t138 = t20 * t137
  t140 = -0.42198333333333333333333333333333333333333333333333e0 * t123 + 0.84396666666666666666666666666666666666666666666666e0 * t126 + 0.39862222222222222222222222222222222222222222222223e0 * t129 + 0.68258333333333333333333333333333333333333333333333e-1 * t133 + 0.13651666666666666666666666666666666666666666666667e0 * t135 + 0.13692777777777777777777777777777777777777777777778e0 * t138
  t141 = t140 * t57
  t143 = t99 * t115 * t141
  t145 = t35 * t29
  t146 = 0.1e1 / t64
  t147 = t52 * t146
  t149 = t99 * t145 * t147
  t152 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t10
  t153 = t80 * t152
  t154 = t90 ** 2
  t155 = t154 * t90
  t156 = 0.1e1 / t155
  t161 = -0.86308333333333333333333333333333333333333333333334e0 * t37 - 0.30192500000000000000000000000000000000000000000000e0 * t40 - 0.55016250000000000000000000000000000000000000000000e-1 * t44 - 0.82785000000000000000000000000000000000000000000000e-1 * t49
  t162 = t156 * t161
  t163 = 0.1e1 / t93
  t170 = -0.57538888888888888888888888888888888888888888888889e0 * t123 + 0.11507777777777777777777777777777777777777777777778e1 * t126 + 0.40256666666666666666666666666666666666666666666667e0 * t129 + 0.36677500000000000000000000000000000000000000000000e-1 * t133 + 0.73355000000000000000000000000000000000000000000000e-1 * t135 + 0.13797500000000000000000000000000000000000000000000e0 * t138
  t171 = t163 * t170
  t173 = t153 * t162 * t171
  t175 = t154 ** 2
  t176 = 0.1e1 / t175
  t178 = t93 ** 2
  t179 = 0.1e1 / t178
  t180 = t179 * t161
  t182 = t153 * t176 * t170 * t180
  t184 = jnp.log(0.2e1)
  t185 = t184 - 0.1e1
  t186 = 0.2e1 * t185
  t188 = 0.29230250000000000000000000000000000000000000000000e1 * f.p.cam_omega * t13
  t190 = 9 ** (0.1e1 / 0.3e1)
  t191 = t190 ** 2
  t199 = f.p.cam_omega ** 2
  t201 = (0.344851e1 - jnp.pi * t5 * t191 * t3 / t185 / 0.12e2) * t199 * t1
  t202 = t33 * t8
  t205 = t199 * f.p.cam_omega
  t208 = 0.1e1 + t188 + t201 * t202 / 0.4e1 + 0.48968000000000000000000000000000000000000000000000e0 * t205 * t116
  t209 = t199 * t1
  t212 = 0.1e1 + t188 + 0.86212750000000000000000000000000000000000000000000e0 * t209 * t202
  t213 = 0.1e1 / t212
  t215 = jnp.log(t208 * t213)
  t217 = jnp.pi ** 2
  t218 = 0.1e1 / t217
  t220 = jnp.sqrt(jnp.pi)
  t222 = 0.1e1 / t220 / jnp.pi
  t223 = 0.1e1 / r0
  t224 = t222 * t223
  t227 = t2 * t223
  t229 = t3 * t2
  t230 = t1 * t229
  t233 = 0.1e1 + 0.51750000000000000000000000000000000000000000000000e-2 * t10 + 0.20482500000000000000000000000000000000000000000000e-1 * t24 - 0.95775000000000000000000000000000000000000000000000e-2 * t227 + 0.34856250000000000000000000000000000000000000000000e-3 * t230 * t39
  t235 = jnp.exp(-0.18810000000000000000000000000000000000000000000000e0 * t10)
  t236 = t233 * t235
  t237 = jnp.sqrt(0.2e1)
  t238 = t236 * t237
  t242 = t18 * t19 * t218
  t243 = t242 * t5
  t245 = t4 * t9 * t76
  t248 = (0.1e1 - 0.56675000000000000000000000000000000000000000000000e-2 * t245) * t191
  t249 = 0.1e1 / t229
  t250 = t248 * t249
  t251 = t1 * t21
  t253 = t76 ** 2
  t257 = 0.1e1 + 0.10797500000000000000000000000000000000000000000000e0 * t245 + 0.10000000000000000000000000000000000000000000000000e-1 * t20 * t23 * t253
  t258 = 0.1e1 / t257
  t261 = t250 * t251 * t258 / 0.15e2
  t263 = jnp.exp(-0.77500000000000000000000000000000000000000000000000e-1 * t10)
  t266 = -0.12375000000000000000000000000000000000000000000000e1 * t10 + t24 / 0.4e1
  t267 = t263 * t266
  t268 = jnp.pi * r0
  t271 = t261 + 0.4e1 / 0.3e1 * t267 * t268
  t273 = t237 * t220
  t280 = t236 / 0.2e1 - 0.1e1 / 0.2e1
  t284 = jnp.exp(-0.13675000000000000000000000000000000000000000000000e0 * t10)
  t287 = -0.97000000000000000000000000000000000000000000000000e-1 * t10 + 0.16900000000000000000000000000000000000000000000000e0 * t24
  t289 = t284 * t287 * t1
  t291 = 0.1e1 / t19 * t6
  t292 = t291 * t21
  t295 = t191 * t249
  t298 = t261 + t289 * t292 / 0.3e1 - t295 * t251 / 0.15e2
  t303 = jnp.log(t56)
  t309 = -0.62182e-1 * t12 * t303 + 0.19751789702565206228825776161588751761046270558698e-1 * t80 * t152 * t94
  t314 = t199 ** 2
  t316 = t242 * t48
  t317 = t314 * f.p.cam_omega
  t318 = t273 * t317
  t319 = t236 * t318
  t326 = 0.1e1 / t82
  t327 = t218 * t326
  t331 = t314 * t199
  t334 = t314 ** 2
  t338 = t186 * t215 * t218 + (-0.17543244109220059985638668152930835075000000000000e0 * t224 * t238 - 0.30400821447970174150861446235388365887845217506462e-2 * t243 * t47 * t271 * t273) * t205 + (-0.26314866163830089978458002229396252612500000000000e0 * t227 * t280 - 0.38001026809962717688576807794235457359806521883077e-2 * t243 * t47 * t298 * jnp.pi + 0.42708890021612718670335112500000000000000000000000e0 * t230 * t39 * t309) * t314 - 0.67557380995489275890803213856418590861878261125470e-2 * t316 * t319 + (-0.10133607149323391383620482078462788629281739168820e-1 * t243 * t47 * t280 * jnp.pi + 0.52629732327660179956916004458792505225000000000000e0 * t327 * t309) * t331 + 0.20267214298646782767240964156925577258563478337641e-1 * t243 * t121 * t309 * t334
  t342 = 0.1e1 + 0.15403623315025000000000000000000000000000000000000e0 * t20 * t23 * t199
  t343 = t342 ** 2
  t345 = t343 ** 2
  t347 = 0.1e1 / t345 / t343 / t342
  t348 = t338 * t347
  t349 = t82 ** 2
  t350 = t349 * r0
  t351 = 0.1e1 / t350
  t352 = t218 * t351
  t353 = t352 * t331
  t357 = f.p.cam_omega * t117 * t18
  t359 = 0.32478055555555555555555555555555555555555555555555e0 * t357 * t122
  t361 = f.p.cam_omega * t31 * t1
  t363 = 0.64956111111111111111111111111111111111111111111111e0 * t361 * t125
  t367 = t205 * t31 * t18
  t371 = t205 * t13 * t1
  t374 = -t359 + t363 + t201 * t125 / 0.9e1 + 0.16322666666666666666666666666666666666666666666667e0 * t367 * t122 + 0.32645333333333333333333333333333333333333333333333e0 * t371 * t125
  t377 = 0.48717083333333333333333333333333333333333333333333e0 * t361 * t36
  t382 = -t377 - t201 * t36 / 0.12e2 - 0.24484000000000000000000000000000000000000000000000e0 * t371 * t36
  t383 = t212 ** 2
  t384 = 0.1e1 / t383
  t385 = t382 * t384
  t388 = -t377 - 0.28737583333333333333333333333333333333333333333333e0 * t209 * t36
  t392 = 0.1e1 / t383 / t212
  t393 = t208 * t392
  t394 = t388 ** 2
  t397 = t208 * t384
  t400 = -t359 + t363 + 0.38316777777777777777777777777777777777777777777777e0 * t209 * t125
  t403 = t186 * (t374 * t213 - 0.2e1 * t385 * t388 + 0.2e1 * t393 * t394 - t397 * t400)
  t404 = 0.1e1 / t208
  t406 = t404 * t212 * t218
  t411 = t186 * (t382 * t213 - t397 * t388)
  t412 = t208 ** 2
  t413 = 0.1e1 / t412
  t414 = t411 * t413
  t415 = t212 * t218
  t416 = t415 * t382
  t419 = t404 * t388 * t218
  t421 = 0.1e1 / t83
  t422 = t222 * t421
  t425 = t222 * t326
  t428 = t2 * t326
  t432 = -0.17250000000000000000000000000000000000000000000000e-2 * t40 - 0.13655000000000000000000000000000000000000000000000e-1 * t49 + 0.95775000000000000000000000000000000000000000000000e-2 * t428 - 0.46475000000000000000000000000000000000000000000000e-3 * t230 * t128
  t433 = t432 * t235
  t434 = t433 * t237
  t437 = t222 * t85
  t438 = t233 * t1
  t440 = t235 * t237
  t441 = t33 * t440
  t446 = t2 * t421
  t448 = t6 * t85
  t451 = 0.23000000000000000000000000000000000000000000000000e-2 * t129 + 0.22758333333333333333333333333333333333333333333333e-1 * t138 - 0.19155000000000000000000000000000000000000000000000e-1 * t446 + 0.10844166666666666666666666666666666666666666666667e-2 * t230 * t448
  t452 = t451 * t235
  t453 = t452 * t237
  t456 = t222 * t108
  t457 = t432 * t1
  t462 = 0.1e1 / t21 / t83
  t463 = t222 * t462
  t464 = t233 * t18
  t466 = t119 * t440
  t473 = t18 * jnp.pi
  t474 = t473 * t6
  t476 = t191 * t258
  t479 = 0.12594444444444444444444444444444444444444444444445e-3 * t474 * t22 * t76 * t476
  t480 = t1 * t8
  t483 = 0.2e1 / 0.45e2 * t250 * t480 * t258
  t484 = t257 ** 2
  t485 = 0.1e1 / t484
  t492 = -0.35991666666666666666666666666666666666666666666667e-1 * t4 * t39 * t76 - 0.66666666666666666666666666666666666666666666666667e-2 * t20 * t48 * t253
  t493 = t485 * t492
  t496 = t250 * t251 * t493 / 0.15e2
  t497 = t8 * t263
  t498 = t266 * jnp.pi
  t504 = 0.41250000000000000000000000000000000000000000000000e0 * t40 - t49 / 0.6e1
  t505 = t263 * t504
  t510 = t479 + t483 - t496 + 0.34444444444444444444444444444444444444444444444444e-1 * t99 * t497 * t498 + 0.4e1 / 0.3e1 * t505 * t268 + 0.4e1 / 0.3e1 * t267 * jnp.pi
  t518 = 0.3e-53 * t474 * t47 * t76 * t476
  t520 = t473 * t6 * t22
  t521 = t76 * t191
  t522 = t521 * t493
  t524 = 0.25188888888888888888888888888888888888888888888890e-3 * t520 * t522
  t525 = t1 * t35
  t528 = 0.2e1 / 0.135e3 * t250 * t525 * t258
  t531 = 0.4e1 / 0.45e2 * t250 * t480 * t493
  t533 = 0.1e1 / t484 / t257
  t534 = t492 ** 2
  t535 = t533 * t534
  t538 = 0.2e1 / 0.15e2 * t250 * t251 * t535
  t545 = 0.47988888888888888888888888888888888888888888888889e-1 * t4 * t128 * t76 + 0.11111111111111111111111111111111111111111111111111e-1 * t20 * t137 * t253
  t546 = t485 * t545
  t549 = t250 * t251 * t546 / 0.15e2
  t550 = t35 * t263
  t554 = t20 * t5
  t555 = t47 * t263
  t559 = t504 * jnp.pi
  t565 = -0.55000000000000000000000000000000000000000000000000e0 * t129 + 0.5e1 / 0.18e2 * t138
  t566 = t263 * t565
  t571 = -t518 - t524 - t528 - t531 + t538 - t549 + 0.22962962962962962962962962962962962962962962962963e-1 * t99 * t550 * t498 + 0.35592592592592592592592592592592592592592592592591e-2 * t554 * t555 * t498 + 0.68888888888888888888888888888888888888888888888888e-1 * t99 * t497 * t559 + 0.4e1 / 0.3e1 * t566 * t268 + 0.8e1 / 0.3e1 * t505 * jnp.pi
  t581 = t438 * t3
  t582 = t39 * t235
  t585 = t433 / 0.2e1 + 0.31350000000000000000000000000000000000000000000000e-1 * t581 * t582
  t589 = t457 * t3
  t592 = t128 * t235
  t595 = t464 * t19
  t596 = t137 * t235
  t599 = t452 / 0.2e1 + 0.62700000000000000000000000000000000000000000000000e-1 * t589 * t582 - 0.41800000000000000000000000000000000000000000000000e-1 * t581 * t592 + 0.78625800000000000000000000000000000000000000000000e-2 * t595 * t596
  t608 = t18 / t3 * t5
  t609 = t22 * t284
  t615 = 0.32333333333333333333333333333333333333333333333333e-1 * t40 - 0.11266666666666666666666666666666666666666666666667e0 * t49
  t617 = t284 * t615 * t1
  t620 = t291 * t8
  t625 = t479 + t483 - t496 + 0.60777777777777777777777777777777777777777777777777e-1 * t608 * t609 * t287 + t617 * t292 / 0.3e1 + 0.2e1 / 0.9e1 * t289 * t620 - 0.2e1 / 0.45e2 * t295 * t480
  t630 = t326 * t284
  t638 = -0.43111111111111111111111111111111111111111111111111e-1 * t129 + 0.18777777777777777777777777777777777777777777777778e0 * t138
  t640 = t284 * t638 * t1
  t645 = t291 * t35
  t650 = -t518 - t524 - t528 - t531 + t538 - t549 + 0.33245444444444444444444444444444444444444444444444e-1 * t630 * t287 + 0.12155555555555555555555555555555555555555555555555e0 * t608 * t609 * t615 + t640 * t292 / 0.3e1 + 0.4e1 / 0.9e1 * t617 * t620 - 0.2e1 / 0.27e2 * t289 * t645 + 0.2e1 / 0.135e3 * t295 * t525
  t661 = t12 * t109
  t668 = 0.1e1 / t154
  t670 = t668 * t161 * t163
  t673 = 0.11073577833333333333333333333333333333333333333333e-2 * t4 * t39 * t303 + 0.10000000000000000000000000000000000000000000000000e1 * t661 * t111 - 0.18311555036753159941307229983139571945136646663793e-3 * t81 * t33 * t35 * t94 - 0.58482233974552040708313425006184496242808878304903e0 * t153 * t670
  t683 = t12 * t101
  t694 = t80 * t4
  t698 = t161 ** 2
  t700 = t156 * t698 * t163
  t704 = t668 * t170 * t163
  t707 = t176 * t698
  t708 = t707 * t179
  t711 = -0.14764770444444444444444444444444444444444444444444e-2 * t4 * t128 * t303 - 0.35616666666666666666666666666666666666666666666666e-1 * t99 * t115 * t111 - 0.20000000000000000000000000000000000000000000000000e1 * t683 * t103 + 0.10000000000000000000000000000000000000000000000000e1 * t661 * t141 + 0.16081824322151104821330931780901225435013347914188e2 * t30 * t147 + 0.24415406715670879921742973310852762593515528885057e-3 * t81 * t33 * t108 * t94 + 0.10843580882781524214666447553230042011687479519034e-1 * t694 * t39 * t670 + 0.11696446794910408141662685001236899248561775660981e1 * t153 * t700 - 0.58482233974552040708313425006184496242808878304903e0 * t153 * t704 - 0.17315755899375863299672358916972966258900005419821e2 * t153 * t708
  t717 = t5 * t462
  t718 = t242 * t717
  t721 = t242 * t137
  t722 = t433 * t318
  t726 = 0.1e1 / t220 / t217
  t727 = 0.1e1 / t349
  t728 = t726 * t727
  t730 = t440 * t317
  t733 = t452 * t318
  t736 = t726 * t421
  t741 = 0.1e1 / t7 / t349
  t742 = t726 * t741
  t744 = t33 * t730
  t759 = t218 * t727
  t762 = t218 * t421
  t770 = 0.1e1 / t21 / t349
  t783 = t403 * t406 - t414 * t416 + t411 * t419 + (-0.35086488218440119971277336305861670150000000000000e0 * t422 * t238 + 0.35086488218440119971277336305861670150000000000000e0 * t425 * t434 + 0.36665380188269925369984816439625445306750000000000e-1 * t437 * t438 * t441 - 0.17543244109220059985638668152930835075000000000000e0 * t224 * t453 - 0.21999228112961955221990889863775267184050000000000e-1 * t456 * t457 * t441 - 0.27587032053654291848376575889174185048798700000000e-2 * t463 * t464 * t466 - 0.13511476199097855178160642771283718172375652225094e-1 * t243 * t462 * t271 * t273 + 0.10133607149323391383620482078462788629281739168821e-1 * t243 * t121 * t510 * t273 - 0.30400821447970174150861446235388365887845217506462e-2 * t243 * t47 * t571 * t273) * t205 + (-0.52629732327660179956916004458792505225000000000000e0 * t446 * t280 + 0.52629732327660179956916004458792505225000000000000e0 * t428 * t585 - 0.26314866163830089978458002229396252612500000000000e0 * t227 * t599 - 0.16889345248872318972700803464104647715469565281367e-1 * t243 * t462 * t298 * jnp.pi + 0.12667008936654239229525602598078485786602173961026e-1 * t243 * t121 * t625 * jnp.pi - 0.38001026809962717688576807794235457359806521883077e-2 * t243 * t47 * t650 * jnp.pi + 0.13287210228946179141882035000000000000000000000000e1 * t230 * t448 * t309 - 0.11389037339096724978756030000000000000000000000000e1 * t230 * t128 * t673 + 0.42708890021612718670335112500000000000000000000000e0 * t230 * t39 * t711) * t314 - 0.30025502664661900395912539491741595938612560500208e-1 * t718 * t319 + 0.22519126998496425296934404618806196953959420375156e-1 * t721 * t722 + 0.23720747615136194550778824449265695623422695046375e-1 * t728 * t233 * t730 - 0.67557380995489275890803213856418590861878261125470e-2 * t316 * t733 - 0.10166034692201226236048067621113869552895440734161e-1 * t736 * t432 * t730 - 0.31870518760050844250010691992191981048327206701594e-3 * t742 * t438 * t744 + (-0.45038253996992850593868809237612393907918840750312e-1 * t243 * t462 * t280 * jnp.pi + 0.33778690497744637945401606928209295430939130562734e-1 * t243 * t121 * t585 * jnp.pi - 0.10133607149323391383620482078462788629281739168820e-1 * t243 * t47 * t599 * jnp.pi + 0.31577839396596107974149602675275503135000000000000e1 * t759 * t309 - 0.21051892931064071982766401783517002090000000000000e1 * t762 * t673 + 0.52629732327660179956916004458792505225000000000000e0 * t327 * t711) * t331 + 0.19816831758676854261302276064549453319484289930138e0 * t243 * t770 * t309 * t334 - 0.10809180959278284142528514217026974537900521780075e0 * t243 * t462 * t673 * t334 + 0.20267214298646782767240964156925577258563478337641e-1 * t243 * t121 * t711 * t334
  t785 = 0.1e1 / t345 / t342
  t787 = t783 * t785 * t18
  t789 = t119 * t47 * t199
  t793 = t338 * t785 * t18
  t795 = t119 * t462 * t199
  t799 = 0.1e1 / t345 / t343
  t801 = t338 * t799 * t1
  t802 = t229 * t6
  t804 = t802 * t741 * t314
  t808 = 0.1e1 / t175 / t154
  t809 = t698 * t161
  t812 = 0.1e1 / t178 / t93
  t813 = t808 * t809 * t812
  t814 = t153 * t813
  t818 = 0.1e1 / t13 / t24 / 0.4e1
  t819 = t818 * t2
  t820 = t819 * t727
  t822 = t119 * t462
  t823 = t118 * t822
  t825 = t33 * t85
  t826 = t32 * t825
  t828 = t4 * t448
  t830 = t10 ** (-0.15e1)
  t831 = t830 * t2
  t832 = t831 * t727
  t834 = t132 * t822
  t836 = t43 * t825
  t838 = t20 * t717
  t840 = -0.34523333333333333333333333333333333333333333333333e1 * t820 + 0.23015555555555555555555555555555555555555555555556e1 * t823 - 0.26851481481481481481481481481481481481481481481482e1 * t826 - 0.93932222222222222222222222222222222222222222222223e0 * t828 + 0.73355000000000000000000000000000000000000000000000e-1 * t832 - 0.14671000000000000000000000000000000000000000000000e0 * t834 - 0.17116166666666666666666666666666666666666666666667e0 * t836 - 0.36793333333333333333333333333333333333333333333333e0 * t838
  t842 = t668 * t840 * t163
  t843 = t153 * t842
  t845 = 0.24000000000000000000000000000000000000000000000000e2 * t59 + 0.20690005882282467365258025513365572590155798030541e4 * t68 - 0.22787712934626154593626775090129245087281160292720e-2 * t97 + 0.42740000000000000000000000000000000000000000000000e0 * t105 + 0.28493333333333333333333333333333333333333333333333e0 * t113 - 0.21370000000000000000000000000000000000000000000000e0 * t143 - 0.34366858576436911003184201215785918754623524492620e1 * t149 + 0.14035736153892489769995222001484279098274130793177e2 * t173 - 0.20778907079251035959606830700367559510680006503785e3 * t182 - 0.18712793716501397318014579363126224080000000000001e2 * t348 * t353 - 0.49291594608080000000000000000000000000000000000001e1 * t787 * t789 - 0.73024584604562962962962962962962962962962962962965e1 * t793 * t795 + 0.12654485932329694420840033333333333333333333333334e2 * t801 * t804 - 0.41015588084031179723272005488181361423343413086566e4 * t814 - 0.23392893589820816283325370002473798497123551321961e1 * t843
  t847 = 0.1e1 / t175 / t90
  t849 = t847 * t809 * t179
  t850 = t153 * t849
  t853 = t176 * t809 * t163
  t854 = t153 * t853
  t858 = t30 * t140 * t146 * t51
  t861 = t683 * t111 * t140
  t864 = t4 * t448 * t303
  t933 = t411 * t406 + (0.17543244109220059985638668152930835075000000000000e0 * t425 * t238 - 0.17543244109220059985638668152930835075000000000000e0 * t224 * t434 - 0.10999614056480977610995444931887633592025000000000e-1 * t456 * t438 * t441 + 0.50668035746616956918102410392313943146408695844103e-2 * t243 * t121 * t271 * t273 - 0.30400821447970174150861446235388365887845217506462e-2 * t243 * t47 * t510 * t273) * t205 + (0.26314866163830089978458002229396252612500000000000e0 * t428 * t280 - 0.26314866163830089978458002229396252612500000000000e0 * t227 * t585 + 0.63335044683271196147628012990392428933010869805128e-2 * t243 * t121 * t298 * jnp.pi - 0.38001026809962717688576807794235457359806521883077e-2 * t243 * t47 * t625 * jnp.pi - 0.56945186695483624893780150000000000000000000000000e0 * t230 * t128 * t309 + 0.42708890021612718670335112500000000000000000000000e0 * t230 * t39 * t673) * t314 + 0.11259563499248212648467202309403098476979710187578e-1 * t721 * t319 - 0.67557380995489275890803213856418590861878261125470e-2 * t316 * t722 - 0.50830173461006131180240338105569347764477203670804e-2 * t736 * t233 * t730 + (0.16889345248872318972700803464104647715469565281367e-1 * t243 * t121 * t280 * jnp.pi - 0.10133607149323391383620482078462788629281739168820e-1 * t243 * t47 * t585 * jnp.pi - 0.10525946465532035991383200891758501045000000000000e1 * t762 * t309 + 0.52629732327660179956916004458792505225000000000000e0 * t327 * t673) * t331 - 0.54045904796391420712642571085134872689502608900376e-1 * t243 * t462 * t309 * t334 + 0.20267214298646782767240964156925577258563478337641e-1 * t243 * t121 * t673 * t334
  t935 = t933 * t785 * t18
  t937 = t119 * t121 * t199
  t941 = t933 * t799 * t1
  t943 = t802 * t85 * t314
  t947 = 0.1e1 / t28 / t26
  t948 = t12 * t947
  t949 = t53 * t146
  t950 = t948 * t949
  t960 = -0.25319000000000000000000000000000000000000000000000e1 * t820 + 0.16879333333333333333333333333333333333333333333333e1 * t823 - 0.19692555555555555555555555555555555555555555555555e1 * t826 - 0.93011851851851851851851851851851851851851851851854e0 * t828 + 0.13651666666666666666666666666666666666666666666667e0 * t832 - 0.27303333333333333333333333333333333333333333333333e0 * t834 - 0.31853888888888888888888888888888888888888888888890e0 * t836 - 0.36514074074074074074074074074074074074074074074075e0 * t838
  t961 = t960 * t57
  t962 = t661 * t961
  t975 = 0.60000000000000000000000000000000000000000000000000e1 * t59 - 0.60000000000000000000000000000000000000000000000000e1 * t861 + 0.34451131037037037037037037037037037037037037037036e-2 * t864 - 0.10253897021007794930818001372045340355835853271641e4 * t814 - 0.58482233974552040708313425006184496242808878304903e0 * t843 + 0.10389453539625517979803415350183779755340003251893e3 * t850 + 0.48245472966453314463992795342703676305040043742564e2 * t858 + 0.51725014705706168413145063783413931475389495076352e3 * t68 - 0.96490945932906628927985590685407352610080087485128e2 * t950 + 0.10000000000000000000000000000000000000000000000000e1 * t962 - 0.56969282336565386484066937725323112718202900731800e-3 * t97
  t978 = t694 * t39 * t700
  t981 = t694 * t128 * t670
  t984 = t694 * t39 * t704
  t987 = t694 * t39 * t708
  t995 = 0.10685000000000000000000000000000000000000000000000e0 * t105 - 0.32530742648344572643999342659690126035062438557102e-1 * t978 - 0.21687161765563048429332895106460084023374959038068e-1 * t981 + 0.16265371324172286321999671329845063017531219278551e-1 * t984 + 0.48159446095139119802213748237831062407565640073877e0 * t987 + 0.71233333333333333333333333333333333333333333333333e-1 * t113 - 0.53424999999999999999999999999999999999999999999999e-1 * t143 - 0.85917146441092277507960503039464796886558811231548e0 * t149 - 0.35089340384731224424988055003710697745685326982943e1 * t854 + 0.35089340384731224424988055003710697745685326982943e1 * t173 - 0.51947267698127589899017076750918898776700016259463e2 * t182
  t996 = t975 + t995
  t1009 = t726 * t351
  t1020 = 0.1e1 / t21 / t350
  t1025 = t415 * t374
  t1027 = t388 * t218
  t1028 = t1027 * t382
  t1031 = t403 * t413
  t1035 = t404 * t400 * t218
  t1039 = 0.20267214298646782767240964156925577258563478337641e-1 * t243 * t121 * t996 * t334 - 0.16213771438917426213792771325540461806850782670113e0 * t243 * t462 * t711 * t334 + 0.59450495276030562783906828193648359958452869790413e0 * t243 * t770 * t673 * t334 - 0.11747417866543639206099989251064915927790287070586e0 * t1009 * t233 * t730 + 0.71162242845408583652336473347797086870268085139125e-1 * t728 * t432 * t730 - 0.15249052038301839354072101431670804329343161101241e-1 * t736 * t451 * t730 - 0.92478548207158653219410621634564115490926686340644e0 * t243 * t1020 * t309 * t334 - t414 * t1025 - 0.2e1 * t414 * t1028 - 0.2e1 * t1031 * t416 + t411 * t1035 + 0.2e1 * t403 * t419
  t1040 = f.p.cam_omega * t818
  t1041 = t2 * t727
  t1043 = 0.19486833333333333333333333333333333333333333333333e1 * t1040 * t1041
  t1045 = 0.12991222222222222222222222222222222222222222222222e1 * t357 * t822
  t1047 = 0.15156425925925925925925925925925925925925925925926e1 * t361 * t825
  t1050 = t205 * t117
  t1057 = -t1043 + t1045 - t1047 - 0.7e1 / 0.27e2 * t201 * t825 + 0.32645333333333333333333333333333333333333333333334e0 * t1050 * t1041 - 0.65290666666666666666666666666666666666666666666667e0 * t367 * t822 - 0.76172444444444444444444444444444444444444444444444e0 * t371 * t825
  t1059 = t374 * t384
  t1062 = t382 * t392
  t1067 = t383 ** 2
  t1068 = 0.1e1 / t1067
  t1069 = t208 * t1068
  t1070 = t394 * t388
  t1073 = t388 * t400
  t1078 = -t1043 + t1045 - t1047 - 0.89405814814814814814814814814814814814814814814813e0 * t209 * t825
  t1081 = t186 * (t1057 * t213 - 0.3e1 * t1059 * t388 + 0.6e1 * t1062 * t394 - 0.6e1 * t1069 * t1070 + 0.6e1 * t393 * t1073 - t397 * t1078 - 0.3e1 * t385 * t400)
  t1098 = t6 * t741
  t1101 = -0.53666666666666666666666666666666666666666666666667e-2 * t828 - 0.60688888888888888888888888888888888888888888888888e-1 * t838 + 0.57465000000000000000000000000000000000000000000000e-1 * t1041 - 0.36147222222222222222222222222222222222222222222223e-2 * t230 * t1098
  t1102 = t1101 * t235
  t1104 = t451 * t1
  t1105 = t1104 * t3
  t1110 = t432 * t18
  t1111 = t1110 * t19
  t1114 = t448 * t235
  t1117 = t717 * t235
  t1120 = t233 * t2
  t1121 = t727 * t235
  t1124 = t1102 / 0.2e1 + 0.94050000000000000000000000000000000000000000000000e-1 * t1105 * t582 - 0.12540000000000000000000000000000000000000000000000e0 * t589 * t592 + 0.23587740000000000000000000000000000000000000000000e-1 * t1111 * t596 + 0.97533333333333333333333333333333333333333333333333e-1 * t581 * t1114 - 0.31450320000000000000000000000000000000000000000000e-1 * t595 * t1117 + 0.59158051920000000000000000000000000000000000000000e-2 * t1120 * t1121
  t1139 = t222 * t727
  t1144 = t222 * t741
  t1153 = t222 * t770
  t1157 = t1102 * t237
  t1180 = t1 * t108
  t1183 = 0.8e1 / 0.405e3 * t250 * t1180 * t258
  t1186 = 0.2e1 / 0.45e2 * t250 * t525 * t493
  t1189 = 0.2e1 / 0.15e2 * t250 * t480 * t546
  t1196 = -0.11197407407407407407407407407407407407407407407407e0 * t4 * t448 * t76 - 0.29629629629629629629629629629629629629629629629629e-1 * t20 * t717 * t253
  t1197 = t485 * t1196
  t1200 = t250 * t251 * t1197 / 0.15e2
  t1204 = t121 * t263
  t1211 = t565 * jnp.pi
  t1217 = 0.12833333333333333333333333333333333333333333333333e1 * t828 - 0.20e2 / 0.27e2 * t838
  t1218 = t263 * t1217
  t1223 = t484 ** 2
  t1224 = 0.1e1 / t1223
  t1226 = t1224 * t534 * t492
  t1229 = 0.2e1 / 0.5e1 * t250 * t251 * t1226
  t1231 = t248 * t249 * t1
  t1232 = t21 * t533
  t1233 = t492 * t545
  t1236 = 0.2e1 / 0.5e1 * t1231 * t1232 * t1233
  t1237 = t108 * t263
  t1244 = 0.27987654320987654320987654320987654320987654320983e-4 * t474 * t121 * t76 * t476
  t1245 = t521 * t546
  t1247 = 0.37783333333333333333333333333333333333333333333335e-3 * t520 * t1245
  t1250 = 0.4e1 / 0.15e2 * t250 * t480 * t535
  t1253 = 0.75566666666666666666666666666666666666666666666669e-3 * t520 * t521 * t535
  t1254 = t421 * t263
  t1257 = t1183 + t1186 - t1189 - t1200 + 0.68888888888888888888888888888888888888888888888888e-1 * t99 * t550 * t559 - 0.35592592592592592592592592592592592592592592592590e-2 * t554 * t1204 * t498 + 0.10677777777777777777777777777777777777777777777777e-1 * t554 * t555 * t559 + 0.10333333333333333333333333333333333333333333333333e0 * t99 * t497 * t1211 + 0.4e1 / 0.3e1 * t1218 * t268 + 0.4e1 * t566 * jnp.pi - t1229 + t1236 - 0.30617283950617283950617283950617283950617283950617e-1 * t99 * t1237 * t498 - t1244 - t1247 + t1250 + t1253 + 0.11033703703703703703703703703703703703703703703703e-2 * t1254 * t266
  t1262 = 0.10525946465532035991383200891758501045000000000000e1 * t1139 * t238 - 0.10525946465532035991383200891758501045000000000000e1 * t422 * t434 - 0.14421716207386170645527361132919341820655000000000e0 * t1144 * t438 * t441 + 0.52629732327660179956916004458792505225000000000000e0 * t425 * t453 + 0.10999614056480977610995444931887633592025000000000e0 * t437 * t457 * t441 + 0.19310922437558004293863603122421929534159090000000e-1 * t1153 * t464 * t466 - 0.17543244109220059985638668152930835075000000000000e0 * t224 * t1157 - 0.32998842169442932832986334795662900776075000000000e-1 * t456 * t1104 * t441 - 0.82761096160962875545129727667522555146396100000000e-2 * t463 * t1110 * t466 - 0.20756482917169489186718535699014656830716141880000e-2 * t1009 * t238 + 0.49542079396692135653255690161373633298710724825345e-1 * t243 * t770 * t271 * t273 - 0.40534428597293565534481928313851154517126956675283e-1 * t243 * t462 * t510 * t273 + 0.15200410723985087075430723117694182943922608753231e-1 * t243 * t121 * t571 * t273 - 0.30400821447970174150861446235388365887845217506462e-2 * t243 * t47 * t1257 * t273
  t1286 = t291 * t108
  t1297 = t421 * t284
  t1303 = 0.10059259259259259259259259259259259259259259259259e0 * t828 - 0.50074074074074074074074074074074074074074074074075e0 * t838
  t1305 = t284 * t1303 * t1
  t1308 = t121 * t284
  t1312 = t85 * t1
  t1313 = t1312 * t3
  t1314 = t6 * t284
  t1315 = t1314 * t287
  t1323 = t1305 * t292 / 0.3e1 - 0.13506172839506172839506172839506172839506172839506e-1 * t608 * t1308 * t287 + 0.15154381759259259259259259259259259259259259259259e-2 * t1313 * t1315 + 0.18233333333333333333333333333333333333333333333333e0 * t608 * t609 * t638 - t1229 + t1236 - t1244 - t1247 + t1250 + t1253 + 0.99736333333333333333333333333333333333333333333330e-1 * t630 * t615
  t1324 = -0.2e1 / 0.9e1 * t617 * t645 + 0.8e1 / 0.81e2 * t289 * t1286 + 0.2e-50 * t608 * t47 * t284 * t615 + 0.2e1 / 0.3e1 * t640 * t620 + t1183 + t1186 - t1189 - t1200 - 0.8e1 / 0.405e3 * t295 * t1180 - 0.66490888888888888888888888888888888888888888888888e-1 * t1297 * t287 + t1323
  t1341 = 0.15788919698298053987074801337637751567500000000000e1 * t1041 * t280 - 0.15788919698298053987074801337637751567500000000000e1 * t446 * t585 + 0.78944598491490269935374006688188757837500000000000e0 * t428 * t599 - 0.26314866163830089978458002229396252612500000000000e0 * t227 * t1124 + 0.61927599245865169566569612701717041623388406031679e-1 * t243 * t770 * t298 * jnp.pi - 0.50668035746616956918102410392313943146408695844103e-1 * t243 * t462 * t625 * jnp.pi + 0.19000513404981358844288403897117728679903260941539e-1 * t243 * t121 * t650 * jnp.pi - 0.38001026809962717688576807794235457359806521883077e-2 * t243 * t47 * t1324 * jnp.pi - 0.44290700763153930472940116666666666666666666666667e1 * t230 * t1098 * t309 + 0.39861630686838537425646105000000000000000000000000e1 * t230 * t448 * t673 - 0.17083556008645087468134045000000000000000000000000e1 * t230 * t128 * t711 + 0.42708890021612718670335112500000000000000000000000e0 * t230 * t39 * t996
  t1344 = 0.1e1 / t412 / t208
  t1345 = t411 * t1344
  t1346 = t382 ** 2
  t1347 = t415 * t1346
  t1350 = t5 * t770
  t1351 = t242 * t1350
  t1359 = 0.1e1 / t7 / t350
  t1360 = t726 * t1359
  t1364 = t1102 * t318
  t1370 = t726 * t1020
  t1372 = t119 * t730
  t1375 = t1081 * t406 + (0.16514026465564045217751896720457877766236908275114e0 * t243 * t770 * t280 * jnp.pi - 0.13511476199097855178160642771283718172375652225094e0 * t243 * t462 * t585 * jnp.pi + 0.50668035746616956918102410392313943146408695844101e-1 * t243 * t121 * t599 * jnp.pi - 0.10133607149323391383620482078462788629281739168820e-1 * t243 * t47 * t1124 * jnp.pi - 0.12631135758638443189659841070110201254000000000000e2 * t352 * t309 + 0.94733518189788323922448808025826509405000000000000e1 * t759 * t673 - 0.31577839396596107974149602675275503135000000000000e1 * t762 * t711 + 0.52629732327660179956916004458792505225000000000000e0 * t327 * t996) * t331 + t1262 * t205 + t1341 * t314 + 0.2e1 * t1345 * t1347 + 0.11009350977042696811834597813638585177491272183410e0 * t1351 * t319 - 0.90076507993985701187737618475224787815837681500624e-1 * t718 * t722 + 0.33778690497744637945401606928209295430939130562734e-1 * t721 * t733 + 0.28683466884045759825009622792972782943494486031434e-2 * t1360 * t438 * t744 - 0.67557380995489275890803213856418590861878261125470e-2 * t316 * t1364 - 0.95611556280152532750032075976575943144981620104783e-3 * t742 * t457 * t744 - 0.79931261050207517379026815516417488469204634407598e-4 * t1370 * t464 * t1372
  t1376 = t1039 + t1375
  t1377 = 0.1e1 / t345
  t1383 = 0.42740000000000000000000000000000000000000000000000e0 * t40 * t101 * t51 * t141
  t1388 = 0.34366858576436911003184201215785918754623524492620e1 * t40 * t29 * t140 * t146 * t51
  t1401 = 0.1e1 / t13 / t227 / 0.48e2
  t1404 = t1401 * t2 * t1359 * t99
  t1406 = t819 * t351
  t1408 = t119 * t770
  t1409 = t118 * t1408
  t1411 = t33 * t741
  t1412 = t32 * t1411
  t1414 = t4 * t1098
  t1416 = t10 ** (-0.25e1)
  t1419 = t1416 * t2 * t1359 * t99
  t1421 = t831 * t351
  t1423 = t132 * t1408
  t1425 = t43 * t1411
  t1427 = t20 * t1350
  t1432 = 0.10000000000000000000000000000000000000000000000000e1 * t661 * (-0.21099166666666666666666666666666666666666666666667e1 * t1404 + 0.20255200000000000000000000000000000000000000000000e2 * t1406 - 0.75019259259259259259259259259259259259259259259258e1 * t1409 + 0.65641851851851851851851851851851851851851851851850e1 * t1412 + 0.31003950617283950617283950617283950617283950617285e1 * t1414 + 0.68258333333333333333333333333333333333333333333335e-1 * t1419 - 0.10921333333333333333333333333333333333333333333333e1 * t1421 + 0.12134814814814814814814814814814814814814814814815e1 * t1423 + 0.10617962962962962962962962962962962962962962962963e1 * t1425 + 0.13388493827160493827160493827160493827160493827161e1 * t1427) * t57
  t1433 = t52 ** 2
  t1436 = 0.57894567559743977356791354411244411566048052491077e3 * t63 * t1433 * t146
  t1439 = 0.24000000000000000000000000000000000000000000000000e2 * t948 * t1433 * t57
  t1442 = 0.36000000000000000000000000000000000000000000000000e2 * t30 * t103 * t140
  t1446 = 0.64327297288604419285323727123604901740053391656752e2 * t30 * t960 * t146 * t51
  t1449 = 0.11483710345679012345679012345679012345679012345679e-1 * t4 * t1098 * t303
  t1452 = 0.57894567559743977356791354411244411566048052491077e3 * t948 * t147 * t140
  t1455 = 0.80000000000000000000000000000000000000000000000000e1 * t683 * t961 * t51
  t1456 = t80 * t99
  t1458 = t170 * t179
  t1462 = 0.19263778438055647920885499295132424963026256029551e1 * t1456 * t35 * t176 * t1458 * t161
  t1463 = t1383 - t1388 + t1432 + t1436 - t1439 + t1442 + t1446 - t1449 - t1452 - t1455 + t1462
  t1469 = 0.13012297059337829057599737063876050414024975422841e0 * t1456 * t35 * t156 * t161 * t163 * t170
  t1484 = 0.58482233974552040708313425006184496242808878304903e0 * t153 * t668 * (-0.28769444444444444444444444444444444444444444444444e1 * t1404 + 0.27618666666666666666666666666666666666666666666667e2 * t1406 - 0.10229135802469135802469135802469135802469135802469e2 * t1409 + 0.89504938271604938271604938271604938271604938271607e1 * t1412 + 0.31310740740740740740740740740740740740740740740741e1 * t1414 + 0.36677500000000000000000000000000000000000000000000e-1 * t1419 - 0.58684000000000000000000000000000000000000000000000e0 * t1421 + 0.65204444444444444444444444444444444444444444444445e0 * t1423 + 0.57053888888888888888888888888888888888888888888890e0 * t1425 + 0.13490888888888888888888888888888888888888888888889e1 * t1427) * t163
  t1485 = t698 ** 2
  t1489 = 0.62336721237753107878820492101102678532040019511358e3 * t153 * t808 * t1485 * t179
  t1495 = 0.12304676425209353916981601646454408427003023925970e5 * t153 / t175 / t155 * t1485 * t812
  t1496 = t170 ** 2
  t1500 = 0.51947267698127589899017076750918898776700016259463e2 * t153 * t176 * t1496 * t179
  t1504 = 0.35089340384731224424988055003710697745685326982943e1 * t153 * t156 * t1496 * t163
  t1505 = t140 ** 2
  t1508 = 0.60000000000000000000000000000000000000000000000000e1 * t683 * t1505 * t57
  t1509 = t28 ** 2
  t1512 = t64 ** 2
  t1516 = 0.24954977986735470914321699422701391789612506067521e5 * t12 / t1509 * t1433 / t1512
  t1519 = 0.48245472966453314463992795342703676305040043742564e2 * t30 * t1505 * t146
  t1525 = 0.62070017646847402095774076540096717770467394091622e4 * t12 / t28 / t100 * t1433 * t66
  t1529 = 0.31035008823423701047887038270048358885233697045812e4 * t63 * t52 * t66 * t140
  t1533 = 0.14035736153892489769995222001484279098274130793177e2 * t153 * t847 * t1485 * t163
  t1534 = -t1469 - t1484 - t1489 + t1495 - t1500 + t1504 - t1508 + t1516 + t1519 - t1525 + t1529 + t1533
  t1536 = t175 ** 2
  t1539 = t178 ** 2
  t1543 = 0.91080982599109921218848830805163797795664001346962e5 * t153 / t1536 * t1485 / t1539
  t1547 = 0.22911239050957940668789467477190612503082349661746e1 * t99 * t108 * t29 * t147
  t1550 = 0.71233333333333333333333333333333333333333333333332e-1 * t99 * t115 * t961
  t1554 = 0.68733717152873822006368402431571837509247048985239e1 * t99 * t35 * t947 * t949
  t1557 = 0.42740000000000000000000000000000000000000000000000e0 * t99 * t145 * t58
  t1561 = 0.22161481481481481481481481481481481481481481481481e0 * t99 * t85 * t109 * t111
  t1564 = 0.21053604230838734654992833002226418647411196189766e2 * t153 * t707 * t171
  t1568 = 0.18989760778855128828022312575107704239400966910600e-2 * t81 * t33 * t741 * t94
  t1572 = 0.28493333333333333333333333333333333333333333333334e0 * t99 * t108 * t101 * t103
  t1577 = 0.61523382126046769584908008232272042135015119629847e4 * t153 * t808 * t170 * t812 * t698
  t1581 = 0.36845452142031360632963667101718523854302450326054e2 * t99 * t35 * t62 * t67
  t1582 = -t1543 + t1547 - t1550 + t1554 - t1557 - t1561 - t1564 + t1568 - t1572 - t1577 - t1581
  t1586 = 0.46785787179641632566650740004947596994247102643924e1 * t153 * t162 * t163 * t840
  t1590 = 0.62336721237753107878820492101102678532040019511357e3 * t153 * t847 * t698 * t1458
  t1594 = 0.69263023597503453198689435667891865035600021679284e2 * t153 * t176 * t840 * t180
  t1597 = 0.14246666666666666666666666666666666666666666666666e0 * t99 * t110 * t141
  t1600 = 0.38024868119570572868450088421334803819557955882337e2 * t694 * t39 * t813
  t1603 = 0.21687161765563048429332895106460084023374959038068e-1 * t694 * t39 * t842
  t1606 = 0.38527556876111295841770998590264849926052512059102e1 * t694 * t39 * t849
  t1609 = 0.43374323531126096858665790212920168046749918076136e-1 * t694 * t128 * t704
  t1612 = 0.12842518958703765280590332863421616642017504019700e1 * t694 * t128 * t708
  t1615 = 0.67471169937307261780146784775653594739388761451767e-1 * t694 * t448 * t670
  t1618 = 0.86748647062252193717331580425840336093499836152272e-1 * t694 * t128 * t700
  t1621 = 0.13012297059337829057599737063876050414024975422841e0 * t694 * t39 * t853
  t1622 = t1586 + t1590 - t1594 + t1597 + t1600 + t1603 - t1606 - t1609 - t1612 + t1615 + t1618 + t1621
  t1624 = t1463 + t1534 + t1582 + t1622
  t1637 = t1359 * t1 * t33
  t1639 = 0.16239027777777777777777777777777777777777777777777e1 * f.p.cam_omega * t1401 * t2 * t1637
  t1640 = t2 * t351
  t1642 = 0.15589466666666666666666666666666666666666666666666e2 * t1040 * t1640
  t1644 = 0.57738765432098765432098765432098765432098765432098e1 * t357 * t1408
  t1646 = 0.50521419753086419753086419753086419753086419753087e1 * t361 * t1411
  t1679 = t394 ** 2
  t1685 = t400 ** 2
  t1695 = (-t1639 + t1642 - t1644 + t1646 + 0.70e2 / 0.81e2 * t201 * t1411 + 0.16322666666666666666666666666666666666666666666667e0 * t205 * t818 * t2 * t1637 - 0.26116266666666666666666666666666666666666666666667e1 * t1050 * t1640 + 0.29018074074074074074074074074074074074074074074074e1 * t367 * t1408 + 0.25390814814814814814814814814814814814814814814815e1 * t371 * t1411) * t213 - 0.4e1 * t1057 * t384 * t388 + 0.12e2 * t374 * t392 * t394 - 0.6e1 * t1059 * t400 - 0.24e2 * t382 * t1068 * t1070 + 0.24e2 * t1062 * t1073 - 0.4e1 * t385 * t1078 + 0.24e2 * t208 / t1067 / t212 * t1679 - 0.36e2 * t1069 * t394 * t400 + 0.6e1 * t393 * t1685 + 0.8e1 * t393 * t388 * t1078 - t397 * (-t1639 + t1642 - t1644 + t1646 + 0.29801938271604938271604938271604938271604938271604e1 * t209 * t1411)
  t1698 = t412 ** 2
  t1705 = t349 * t82
  t1707 = 0.1e1 / t21 / t1705
  t1712 = 0.1e1 / t1705
  t1713 = t726 * t1712
  t1746 = t6 * t1359
  t1750 = (0.17888888888888888888888888888888888888888888888889e-1 * t1414 + 0.22252592592592592592592592592592592592592592592592e0 * t1427 - 0.22986000000000000000000000000000000000000000000000e0 * t1640 + 0.15663796296296296296296296296296296296296296296297e-1 * t230 * t1746) * t235
  t1770 = 0.16e2 / 0.15e2 * t250 * t480 * t1226
  t1773 = t534 ** 2
  t1777 = 0.8e1 / 0.5e1 * t250 * t251 / t1223 / t257 * t1773
  t1780 = 0.56e2 / 0.1215e4 * t250 * t1312 * t258
  t1812 = t545 ** 2
  t1816 = 0.2e1 / 0.5e1 * t250 * t251 * t533 * t1812
  t1817 = 0.4e1 / 0.3e1 * t263 * (-0.42777777777777777777777777777777777777777777777777e1 * t1414 + 0.220e3 / 0.81e2 * t1427) * t268 - t1770 + t1777 - t1780 - 0.44134814814814814814814814814814814814814814814812e-2 * t727 * t263 * t266 + 0.44134814814814814814814814814814814814814814814812e-2 * t1254 * t504 + 0.16e2 / 0.3e1 * t1218 * jnp.pi + 0.21355555555555555555555555555555555555555555555554e-1 * t554 * t555 * t1211 + 0.13777777777777777777777777777777777777777777777777e0 * t99 * t497 * t1217 * jnp.pi - 0.12246913580246913580246913580246913580246913580247e0 * t99 * t1237 * t559 + 0.63275720164609053497942386831275720164609053497937e-2 * t554 * t462 * t263 * t498 + 0.71440329218106995884773662551440329218106995884773e-1 * t99 * t85 * t263 * t498 + 0.13777777777777777777777777777777777777777777777778e0 * t99 * t550 * t1211 - 0.14237037037037037037037037037037037037037037037036e-1 * t554 * t1204 * t559 + t1816
  t1820 = 0.32e2 / 0.405e3 * t250 * t1180 * t493
  t1824 = 0.11195061728395061728395061728395061728395061728394e-3 * t474 * t462 * t76 * t476
  t1827 = 0.4e1 / 0.45e2 * t250 * t525 * t546
  t1830 = 0.8e1 / 0.45e2 * t250 * t480 * t1197
  t1841 = t250 * t251 * t485 * (0.37324691358024691358024691358024691358024691358023e0 * t4 * t1098 * t76 + 0.10864197530864197530864197530864197530864197530864e0 * t20 * t1350 * t253) / 0.15e2
  t1844 = 0.8e1 / 0.45e2 * t250 * t525 * t535
  t1848 = 0.16e2 / 0.15e2 * t1231 * t8 * t533 * t1233
  t1852 = 0.1e-52 * t473 * t6 * t47 * t1245
  t1856 = 0.8e1 / 0.15e2 * t1231 * t1232 * t1196 * t492
  t1859 = 0.50377777777777777777777777777777777777777777777780e-3 * t520 * t521 * t1197
  t1864 = 0.12e2 / 0.5e1 * t1231 * t21 * t1224 * t534 * t545
  t1867 = 0.30226666666666666666666666666666666666666666666668e-2 * t520 * t521 * t1226
  t1871 = 0.11195061728395061728395061728395061728395061728395e-3 * t473 * t6 * t121 * t522
  t1873 = t741 * t1 * t3
  t1882 = 0.30226666666666666666666666666666666666666666666668e-2 * t520 * t521 * t533 * t492 * t545
  t1883 = -t1820 + t1824 + t1827 - t1830 - t1841 - t1844 + t1848 + t1852 + t1856 - t1859 - t1864 - t1867 + t1871 + 0.28503734567901234567901234567901234567901234567899e-4 * t1873 * t6 * t263 * t266 + t1882
  t1906 = t1101 * t1
  t1910 = t451 * t18
  t1917 = t726 / t7 / t1705 * t438
  t1924 = 0.19816831758676854261302276064549453319484289930138e0 * t243 * t770 * t510 * t273 - 0.81068857194587131068963856627702309034253913350566e-1 * t243 * t462 * t571 * t273 + 0.20267214298646782767240964156925577258563478337641e-1 * t243 * t121 * t1257 * t273 - 0.42103785862128143965532803567034004180000000000000e1 * t222 * t351 * t238 + 0.24907779500603387024062242838817588196859370256000e-1 * t1713 * t238 - 0.17543244109220059985638668152930835075000000000000e0 * t224 * t1750 * t237 - 0.83025931668677956746874142796058627322864567520000e-2 * t1009 * t434 + 0.42103785862128143965532803567034004180000000000000e1 * t1139 * t434 - 0.21051892931064071982766401783517002090000000000000e1 * t422 * t453 + 0.70172976436880239942554672611723340300000000000000e0 * t425 * t1157 - 0.30400821447970174150861446235388365887845217506462e-2 * t243 * t47 * (t1817 + t1883) * t273 + 0.69093871999228659363882498535116394711386666666667e0 * t222 * t1359 * t438 * t441 - 0.57686864829544682582109444531677367282620000000000e0 * t1144 * t457 * t441 - 0.12628730229006186935034610295933071377894516000000e0 * t222 * t1020 * t464 * t466 + 0.21999228112961955221990889863775267184050000000000e0 * t437 * t1104 * t441 + 0.77243689750232017175454412489687718136636360000000e-1 * t1153 * t1110 * t466 - 0.43998456225923910443981779727550534368100000000000e-1 * t456 * t1906 * t441 - 0.16552219232192575109025945533504511029279220000000e-1 * t463 * t1910 * t466 - 0.13014314789065269720072521883282189832859020958760e-3 * t1917 * t441 - 0.23119637051789663304852655408641028872731671585161e0 * t243 * t1020 * t271 * t273
  t1952 = 0.20267214298646782767240964156925577258563478337641e-1 * t243 * t121 * t1624 * t334 + t411 * t404 * t1078 * t218 + 0.3e1 * t403 * t1035 + t186 * t1695 * t406 - 0.6e1 * t411 / t1698 * t415 * t1346 * t382 + 0.52404510650723236824332685592919665444858455593032e1 * t243 * t1707 * t309 * t334 + 0.67020525007845121111724297650306251126495868543728e0 * t1713 * t233 * t730 - 0.36991419282863461287764248653825646196370674536257e1 * t243 * t1020 * t673 * t334 - 0.3e1 * t1081 * t413 * t416 - 0.3e1 * t1031 * t1025 + t1924 * t205 - 0.3e1 * t414 * t400 * t218 * t382 - 0.60140280814176136075979775994552518324229566928277e-4 / t220 / t217 / jnp.pi / t349 / t83 * t233 * t730 - 0.6e1 * t1031 * t1028 - 0.3e1 * t414 * t1027 * t374 - t414 * t415 * t1057 - 0.46989671466174556824399957004259663711161148282343e0 * t1009 * t432 * t730 + 0.14232448569081716730467294669559417374053617027825e0 * t728 * t451 * t730
  t2020 = t1750 / 0.2e1 + 0.12540000000000000000000000000000000000000000000000e0 * t1906 * t3 * t582 - 0.25080000000000000000000000000000000000000000000000e0 * t1105 * t592 + 0.47175480000000000000000000000000000000000000000000e-1 * t1910 * t19 * t596 + 0.39013333333333333333333333333333333333333333333333e0 * t589 * t1114 - 0.12580128000000000000000000000000000000000000000000e0 * t1111 * t1117 + 0.23663220768000000000000000000000000000000000000000e-1 * t432 * t2 * t1121 - 0.32511111111111111111111111111111111111111111111111e0 * t581 * t1098 * t235 + 0.13977920000000000000000000000000000000000000000000e0 * t595 * t1350 * t235 - 0.47326441536000000000000000000000000000000000000000e-1 * t1120 * t351 * t235 + 0.37092098553840000000000000000000000000000000000000e-3 * t1120 * t1359 * t4 * t6 * t235
  t2025 = t218 * t1712
  t2106 = -t1770 + t1777 + 0.32e2 / 0.81e2 * t617 * t1286 - 0.56e2 / 0.243e3 * t289 * t291 * t85 - t1780 - 0.4e1 / 0.9e1 * t640 * t645 - 0.54024691358024691358024691358024691358024691358027e-1 * t608 * t1308 * t615 + 0.54024691358024691358024691358024691358024691358024e-1 * t608 * t462 * t284 * t287 + 0.8e1 / 0.9e1 * t1305 * t620 - 0.80823369382716049382716049382716049382716049382715e-2 * t1873 * t1315 + t284 * (-0.33530864197530864197530864197530864197530864197530e0 * t1414 + 0.18360493827160493827160493827160493827160493827161e1 * t1427) * t1 * t292 / 0.3e1 + 0.24311111111111111111111111111111111111111111111111e0 * t608 * t609 * t1303 + 0.60617527037037037037037037037037037037037037037035e-2 * t1313 * t1314 * t615 + 0.27631489407716049382716049382716049382716049382715e-3 * t770 * t18 * t19 * t5 * t284 * t287 + 0.19208479012345679012345679012345679012345679012345e0 * t727 * t284 * t287 + 0.19947266666666666666666666666666666666666666666666e0 * t630 * t638
  t2111 = -0.26596355555555555555555555555555555555555555555555e0 * t1297 * t615 + t1816 - t1820 + t1824 + t1827 - t1830 - t1841 - t1844 + t1848 + t1852 + t1856 - t1859 - t1864 - t1867 + t1871 + 0.56e2 / 0.1215e4 * t295 * t1312 + t1882
  t2132 = -0.63155678793192215948299205350551006270000000000000e1 * t1640 * t280 + 0.63155678793192215948299205350551006270000000000000e1 * t1041 * t585 - 0.31577839396596107974149602675275503135000000000000e1 * t446 * t599 + 0.10525946465532035991383200891758501045000000000000e1 * t428 * t1124 - 0.26314866163830089978458002229396252612500000000000e0 * t227 * t2020 - 0.28899546314737079131065819260801286090914589481450e0 * t243 * t1020 * t298 * jnp.pi + 0.24771039698346067826627845080686816649355362412672e0 * t243 * t770 * t625 * jnp.pi - 0.10133607149323391383620482078462788629281739168821e0 * t243 * t462 * t650 * jnp.pi + 0.25334017873308478459051205196156971573204347922052e-1 * t243 * t121 * t1324 * jnp.pi - 0.38001026809962717688576807794235457359806521883077e-2 * t243 * t47 * (t2106 + t2111) * jnp.pi + 0.19192636997366703204940717222222222222222222222222e2 * t230 * t1746 * t309 - 0.17716280305261572189176046666666666666666666666667e2 * t230 * t1098 * t673 + 0.79723261373677074851292210000000000000000000000000e1 * t230 * t448 * t711 - 0.22778074678193449957512060000000000000000000000000e1 * t230 * t128 * t996 + 0.42708890021612718670335112500000000000000000000000e0 * t230 * t39 * t1624
  t2164 = -0.20332069384402452472096135242227739105790881468321e-1 * t736 * t1101 * t730 + 0.11890099055206112556781365638729671991690573958083e1 * t243 * t770 * t711 * t334 - 0.21618361918556568285057028434053949075801043560151e0 * t243 * t462 * t996 * t334 + 0.6e1 * t1345 * t1027 * t1346 + 0.6e1 * t403 * t1344 * t1347 + 0.6e1 * t1345 * t415 * t374 * t382 + (-0.77065456839298877682842184695470096242438905283865e0 * t243 * t1020 * t280 * jnp.pi + 0.66056105862256180871007586881831511064947633100459e0 * t243 * t770 * t585 * jnp.pi - 0.27022952398195710356321285542567436344751304450188e0 * t243 * t462 * t599 * jnp.pi + 0.67557380995489275890803213856418590861878261125468e-1 * t243 * t121 * t1124 * jnp.pi - 0.10133607149323391383620482078462788629281739168820e-1 * t243 * t47 * t2020 * jnp.pi + 0.63155678793192215948299205350551006270000000000000e2 * t2025 * t309 - 0.50524543034553772758639364280440805016000000000000e2 * t352 * t673 + 0.18946703637957664784489761605165301881000000000000e2 * t759 * t711 - 0.42103785862128143965532803567034004180000000000000e1 * t762 * t996 + 0.52629732327660179956916004458792505225000000000000e0 * t327 * t1624) * t331 + t2132 * t314 - 0.51376971226199251788561456463646730828292603522580e0 * t242 * t5 * t1020 * t319 - 0.22663480007147267022229825416669853189921569210022e-1 * t1917 * t744 + 0.11473386753618303930003849117189113177397794412574e-1 * t1360 * t457 * t744 - 0.19122311256030506550006415195315188628996324020956e-2 * t742 * t1104 * t744 + 0.11723251620697102548923932942407898308816679713114e-2 * t726 * t1707 * t464 * t1372 - 0.67557380995489275890803213856418590861878261125470e-2 * t316 * t1750 * t318 - 0.31972504420083006951610726206566995387681853763040e-3 * t1370 * t1110 * t1372 + 0.44037403908170787247338391254554340709965088733639e0 * t1351 * t722 - 0.18015301598797140237547523695044957563167536300125e0 * t718 * t733 + 0.45038253996992850593868809237612393907918840750312e-1 * t721 * t1364 + 0.3e1 * t1081 * t419
  t2172 = t1383 - t1388 - 0.16521134411652656604985599074074074074074074074075e2 * t801 * t802 * t1359 * t314 - 0.16430531536026666666666666666666666666666666666667e1 * t1376 * t785 * t18 * t789 - 0.73024584604562962962962962962962962962962962962965e1 * t935 * t795 - (t1952 + t2164) * t1377 + 0.46781984291253493295036448407815560200000000000001e2 * t348 * t2025 * t331 + 0.41076328840066666666666666666666666666666666666667e1 * t787 * t937 + t1432 + t1436 - t1439 + t1442 + t1446 - t1449
  t2186 = -t1452 - t1455 - 0.37963457796989083262520100000000000000000000000001e1 * t783 * t799 * t1 * t943 + 0.12654485932329694420840033333333333333333333333334e2 * t941 * t804 + 0.66939202554182716049382716049382716049382716049384e1 * t793 * t119 * t770 * t199 - 0.18712793716501397318014579363126224080000000000001e2 * t933 * t347 * t353 + t1462 - t1469 - t1484 - t1489 + t1495 - t1500 + t1504 - t1508
  t2188 = t1516 + t1519 - t1525 + t1529 + t1533 - t1543 + t1547 - t1550 + t1554 - t1557 - t1561 - t1564 + t1568 - t1572
  t2189 = t345 ** 2
  t2198 = -t1577 - t1581 + t1586 + t1590 - t1594 + t1597 - 0.33628562984421328443422044230750587451246067760236e1 * t338 / t2189 * t218 * t1707 * t334 * t18 * t119 + t1600 + t1603 - t1606 - t1609 - t1612 + t1615 + t1618 + t1621
  t2206 = 0.41557814158502071919213661400735119021360013007572e3 * t850 - 0.14035736153892489769995222001484279098274130793177e2 * t854 + 0.19298189186581325785597118137081470522016017497025e3 * t858 - 0.24000000000000000000000000000000000000000000000000e2 * t861 + 0.13780452414814814814814814814814814814814814814815e-1 * t864 + 0.82152657680133333333333333333333333333333333333336e1 * t935 * t937 - 0.75926915593978166525040200000000000000000000000004e1 * t941 * t943 - 0.38596378373162651571194236274162941044032034994052e3 * t950 + 0.40000000000000000000000000000000000000000000000000e1 * t962 - 0.4e1 * t1376 * t1377 + r0 * (t2172 + t2186 + t2188 + t2198) - 0.13012297059337829057599737063876050414024975422841e0 * t978 - 0.86748647062252193717331580425840336093499836152272e-1 * t981 + 0.65061485296689145287998685319380252070124877114204e-1 * t984 + 0.19263778438055647920885499295132424963026256029551e1 * t987
  v4rho4_0_ = t845 + t2206

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t12 = 0.1e1 / t8
  t13 = t6 * t12
  t14 = t4 * t13
  t15 = jnp.sqrt(t14)
  t18 = t14 ** 0.15e1
  t20 = t1 ** 2
  t21 = t3 ** 2
  t22 = t20 * t21
  t23 = t8 ** 2
  t24 = 0.1e1 / t23
  t25 = t5 * t24
  t26 = t22 * t25
  t28 = 0.37978500000000000000000000000000000000000000000000e1 * t15 + 0.89690000000000000000000000000000000000000000000000e0 * t14 + 0.20477500000000000000000000000000000000000000000000e0 * t18 + 0.12323500000000000000000000000000000000000000000000e0 * t26
  t31 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t28
  t32 = jnp.log(t31)
  t34 = t4 * t11 * t32
  t35 = 0.22147155666666666666666666666666666666666666666666e-2 * t34
  t37 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t14
  t38 = t28 ** 2
  t39 = 0.1e1 / t38
  t40 = t37 * t39
  t41 = 0.1e1 / t15
  t42 = t41 * t1
  t43 = t3 * t6
  t44 = t43 * t10
  t45 = t42 * t44
  t47 = t4 * t11
  t49 = t14 ** 0.5e0
  t50 = t49 * t1
  t51 = t50 * t44
  t54 = 0.1e1 / t23 / t7
  t55 = t5 * t54
  t56 = t22 * t55
  t58 = -0.63297500000000000000000000000000000000000000000000e0 * t45 - 0.29896666666666666666666666666666666666666666666667e0 * t47 - 0.10238750000000000000000000000000000000000000000000e0 * t51 - 0.82156666666666666666666666666666666666666666666667e-1 * t56
  t59 = 0.1e1 / t31
  t60 = t58 * t59
  t61 = t40 * t60
  t62 = 0.20000000000000000000000000000000000000000000000000e1 * t61
  t63 = r0 - r1
  t64 = t63 ** 2
  t65 = t64 * t63
  t66 = t7 ** 2
  t67 = t66 ** 2
  t68 = 0.1e1 / t67
  t69 = t65 * t68
  t70 = 0.1e1 / t7
  t71 = t63 * t70
  t72 = 0.1e1 + t71
  t73 = t72 <= f.p.zeta_threshold
  t74 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t75 = t74 * f.p.zeta_threshold
  t76 = t72 ** (0.1e1 / 0.3e1)
  t77 = t76 * t72
  t78 = f.my_piecewise3(t73, t75, t77)
  t79 = 0.1e1 - t71
  t80 = t79 <= f.p.zeta_threshold
  t81 = t79 ** (0.1e1 / 0.3e1)
  t82 = t81 * t79
  t83 = f.my_piecewise3(t80, t75, t82)
  t85 = 2 ** (0.1e1 / 0.3e1)
  t88 = 0.1e1 / (0.2e1 * t85 - 0.2e1)
  t89 = (t78 + t83 - 0.2e1) * t88
  t91 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t14
  t96 = 0.70594500000000000000000000000000000000000000000000e1 * t15 + 0.15494250000000000000000000000000000000000000000000e1 * t14 + 0.42077500000000000000000000000000000000000000000000e0 * t18 + 0.15629250000000000000000000000000000000000000000000e0 * t26
  t99 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t96
  t100 = jnp.log(t99)
  t104 = 0.62182e-1 * t37 * t32
  t106 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t14
  t111 = 0.51785000000000000000000000000000000000000000000000e1 * t15 + 0.90577500000000000000000000000000000000000000000000e0 * t14 + 0.11003250000000000000000000000000000000000000000000e0 * t18 + 0.12417750000000000000000000000000000000000000000000e0 * t26
  t114 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t111
  t115 = jnp.log(t114)
  t116 = t106 * t115
  t118 = -0.31090e-1 * t91 * t100 + t104 - 0.19751789702565206228825776161588751761046270558698e-1 * t116
  t119 = t89 * t118
  t120 = t69 * t119
  t121 = 0.8e1 * t120
  t122 = t64 ** 2
  t124 = 0.1e1 / t67 / t7
  t125 = t122 * t124
  t126 = t125 * t119
  t127 = 0.8e1 * t126
  t128 = t122 * t68
  t129 = 0.1e1 / t66
  t130 = t63 * t129
  t131 = t70 - t130
  t134 = f.my_piecewise3(t73, 0, 0.4e1 / 0.3e1 * t76 * t131)
  t135 = -t131
  t138 = f.my_piecewise3(t80, 0, 0.4e1 / 0.3e1 * t81 * t135)
  t140 = (t134 + t138) * t88
  t141 = t140 * t118
  t142 = t128 * t141
  t147 = t96 ** 2
  t148 = 0.1e1 / t147
  t149 = t91 * t148
  t154 = -0.11765750000000000000000000000000000000000000000000e1 * t45 - 0.51647500000000000000000000000000000000000000000000e0 * t47 - 0.21038750000000000000000000000000000000000000000000e0 * t51 - 0.10419500000000000000000000000000000000000000000000e0 * t56
  t155 = 0.1e1 / t99
  t156 = t154 * t155
  t159 = 0.11073577833333333333333333333333333333333333333333e-2 * t34
  t160 = 0.10000000000000000000000000000000000000000000000000e1 * t61
  t164 = t111 ** 2
  t165 = 0.1e1 / t164
  t166 = t106 * t165
  t171 = -0.86308333333333333333333333333333333333333333333334e0 * t45 - 0.30192500000000000000000000000000000000000000000000e0 * t47 - 0.55016250000000000000000000000000000000000000000000e-1 * t51 - 0.82785000000000000000000000000000000000000000000000e-1 * t56
  t172 = 0.1e1 / t114
  t173 = t171 * t172
  t176 = 0.53236443333333333333333333333333333333333333333332e-3 * t4 * t11 * t100 + 0.99999999999999999999999999999999999999999999999999e0 * t149 * t156 - t159 - t160 + 0.18311555036753159941307229983139571945136646663793e-3 * t4 * t11 * t115 + 0.58482233974552040708313425006184496242808878304903e0 * t166 * t173
  t177 = t89 * t176
  t178 = t128 * t177
  t179 = 0.2e1 * t178
  t180 = t140 * t116
  t182 = t89 * t1
  t184 = t43 * t10 * t115
  t185 = t182 * t184
  t186 = 0.36623110073506319882614459966279143890273293327586e-3 * t185
  t187 = t89 * t106
  t189 = t165 * t171 * t172
  t190 = t187 * t189
  t191 = 0.11696446794910408141662685001236899248561775660981e1 * t190
  t192 = t76 ** 2
  t193 = t81 ** 2
  t195 = t192 / 0.2e1 + t193 / 0.2e1
  t196 = t195 ** 2
  t197 = jnp.log(0.2e1)
  t198 = t197 - 0.1e1
  t199 = 0.2e1 * t198
  t200 = t196 * t199
  t201 = f.p.cam_omega * t15
  t202 = 0.1e1 / t195
  t204 = 0.29230250000000000000000000000000000000000000000000e1 * t201 * t202
  t206 = 9 ** (0.1e1 / 0.3e1)
  t207 = t206 ** 2
  t215 = f.p.cam_omega ** 2
  t216 = (0.344851e1 - jnp.pi * t5 * t207 * t3 / t198 / 0.12e2) * t215
  t217 = t216 * t1
  t218 = 0.1e1 / t196
  t223 = t215 * f.p.cam_omega
  t224 = t15 * t14
  t225 = t223 * t224
  t226 = t196 * t195
  t227 = 0.1e1 / t226
  t230 = 0.1e1 + t204 + t217 * t43 * t12 * t218 / 0.4e1 + 0.48968000000000000000000000000000000000000000000000e0 * t225 * t227
  t231 = t215 * t1
  t232 = t231 * t3
  t236 = 0.1e1 + t204 + 0.86212750000000000000000000000000000000000000000000e0 * t232 * t13 * t218
  t237 = 0.1e1 / t236
  t239 = jnp.log(t230 * t237)
  t240 = jnp.pi ** 2
  t241 = 0.1e1 / t240
  t242 = t239 * t241
  t243 = 0.1e1 / t76
  t245 = 0.1e1 / t81
  t248 = t243 * t131 / 0.3e1 + t245 * t135 / 0.3e1
  t252 = t226 * t199
  t253 = f.p.cam_omega * t41
  t254 = t253 * t202
  t256 = 0.48717083333333333333333333333333333333333333333333e0 * t254 * t47
  t259 = 0.29230250000000000000000000000000000000000000000000e1 * t201 * t218 * t248
  t263 = t217 * t43 * t10 * t218 / 0.12e2
  t264 = t216 * t4
  t265 = t227 * t248
  t266 = t13 * t265
  t269 = t223 * t15
  t270 = t269 * t227
  t272 = 0.24484000000000000000000000000000000000000000000000e0 * t270 * t47
  t273 = t196 ** 2
  t274 = 0.1e1 / t273
  t278 = -t256 - t259 - t263 - t264 * t266 / 0.2e1 - t272 - 0.14690400000000000000000000000000000000000000000000e1 * t225 * t274 * t248
  t280 = t236 ** 2
  t281 = 0.1e1 / t280
  t282 = t230 * t281
  t285 = 0.28737583333333333333333333333333333333333333333333e0 * t232 * t11 * t218
  t288 = -t256 - t259 - t285 - 0.17242550000000000000000000000000000000000000000000e1 * t232 * t266
  t290 = t278 * t237 - t282 * t288
  t291 = t252 * t290
  t292 = 0.1e1 / t230
  t293 = t292 * t236
  t294 = t293 * t241
  t296 = jnp.sqrt(jnp.pi)
  t298 = 0.1e1 / t296 / jnp.pi
  t299 = t298 * t129
  t301 = -t64 * t129 + 0.1e1
  t302 = t299 * t301
  t305 = t2 * t70
  t307 = t3 * t2
  t308 = t1 * t307
  t311 = 0.1e1 + 0.51750000000000000000000000000000000000000000000000e-2 * t14 + 0.20482500000000000000000000000000000000000000000000e-1 * t26 - 0.95775000000000000000000000000000000000000000000000e-2 * t305 + 0.34856250000000000000000000000000000000000000000000e-3 * t308 * t11
  t313 = jnp.exp(-0.18810000000000000000000000000000000000000000000000e0 * t14)
  t314 = t311 * t313
  t315 = jnp.sqrt(0.2e1)
  t316 = t314 * t315
  t318 = 0.17543244109220059985638668152930835075000000000000e0 * t302 * t316
  t319 = t298 * t70
  t320 = t66 * t7
  t321 = 0.1e1 / t320
  t322 = t64 * t321
  t324 = -0.2e1 * t130 + 0.2e1 * t322
  t325 = t319 * t324
  t328 = t319 * t301
  t331 = t2 * t129
  t334 = 0.1e1 / t8 / t66
  t335 = t6 * t334
  t338 = -0.17250000000000000000000000000000000000000000000000e-2 * t47 - 0.13655000000000000000000000000000000000000000000000e-1 * t56 + 0.95775000000000000000000000000000000000000000000000e-2 * t331 - 0.46475000000000000000000000000000000000000000000000e-3 * t308 * t335
  t339 = t338 * t313
  t340 = t339 * t315
  t342 = 0.17543244109220059985638668152930835075000000000000e0 * t328 * t340
  t343 = t298 * t334
  t344 = t301 * t311
  t348 = t4 * t6 * t313 * t315
  t350 = 0.10999614056480977610995444931887633592025000000000e-1 * t343 * t344 * t348
  t352 = t20 * t21 * t241
  t353 = t352 * t5
  t355 = 0.1e1 / t23 / t66
  t356 = t72 / 0.2e1
  t357 = t356 ** 2
  t358 = t4 * t6
  t359 = t12 * t85
  t360 = 0.1e1 / t72
  t361 = t360 ** (0.1e1 / 0.3e1)
  t363 = t358 * t359 * t361
  t365 = 0.1e1 - 0.56675000000000000000000000000000000000000000000000e-2 * t363
  t366 = t357 * t365
  t367 = 0.1e1 / t307
  t368 = t207 * t367
  t369 = t366 * t368
  t370 = t1 * t23
  t371 = t361 ** 2
  t372 = 0.1e1 / t371
  t374 = t22 * t5
  t375 = t85 ** 2
  t376 = t24 * t375
  t380 = 0.1e1 + 0.10797500000000000000000000000000000000000000000000e0 * t363 + 0.10000000000000000000000000000000000000000000000000e-1 * t374 * t376 * t371
  t381 = 0.1e1 / t380
  t382 = t372 * t381
  t383 = t370 * t382
  t385 = 0.2e1 / 0.15e2 * t369 * t383
  t386 = t79 / 0.2e1
  t387 = t386 ** 2
  t388 = 0.1e1 / t79
  t389 = t388 ** (0.1e1 / 0.3e1)
  t391 = t358 * t359 * t389
  t393 = 0.1e1 - 0.56675000000000000000000000000000000000000000000000e-2 * t391
  t394 = t387 * t393
  t395 = t394 * t368
  t396 = t389 ** 2
  t397 = 0.1e1 / t396
  t402 = 0.1e1 + 0.10797500000000000000000000000000000000000000000000e0 * t391 + 0.10000000000000000000000000000000000000000000000000e-1 * t374 * t376 * t396
  t403 = 0.1e1 / t402
  t404 = t397 * t403
  t405 = t370 * t404
  t407 = 0.2e1 / 0.15e2 * t395 * t405
  t409 = jnp.exp(-0.77500000000000000000000000000000000000000000000000e-1 * t14)
  t410 = t301 * t409
  t414 = (-0.12375000000000000000000000000000000000000000000000e1 * t14 + t26 / 0.4e1) * jnp.pi
  t415 = t414 * t7
  t418 = t385 + t407 + 0.4e1 / 0.3e1 * t410 * t415
  t420 = t315 * t296
  t423 = 0.50668035746616956918102410392313943146408695844103e-2 * t353 * t355 * t418 * t420
  t424 = t356 * t365
  t425 = t424 * t368
  t426 = t131 / 0.2e1
  t427 = t382 * t426
  t428 = t370 * t427
  t430 = 0.4e1 / 0.15e2 * t425 * t428
  t431 = t10 * t85
  t433 = t358 * t431 * t361
  t434 = 0.18891666666666666666666666666666666666666666666667e-2 * t433
  t435 = t85 * t372
  t436 = t72 ** 2
  t437 = 0.1e1 / t436
  t438 = t437 * t131
  t439 = t435 * t438
  t440 = t14 * t439
  t442 = t434 + 0.18891666666666666666666666666666666666666666666667e-2 * t440
  t443 = t357 * t442
  t444 = t443 * t368
  t446 = 0.2e1 / 0.15e2 * t444 * t383
  t447 = t1 * t12
  t448 = t447 * t382
  t450 = 0.4e1 / 0.45e2 * t369 * t448
  t451 = t368 * t1
  t452 = t366 * t451
  t454 = 0.1e1 / t371 / t360
  t455 = t23 * t454
  t456 = t381 * t437
  t457 = t456 * t131
  t458 = t455 * t457
  t460 = 0.4e1 / 0.45e2 * t452 * t458
  t461 = t380 ** 2
  t462 = 0.1e1 / t461
  t463 = t372 * t462
  t464 = 0.35991666666666666666666666666666666666666666666667e-1 * t433
  t466 = t54 * t375
  t469 = 0.66666666666666666666666666666666666666666666666667e-2 * t374 * t466 * t371
  t471 = t375 / t361
  t472 = t471 * t438
  t475 = -t464 - 0.35991666666666666666666666666666666666666666666667e-1 * t440 - t469 - 0.66666666666666666666666666666666666666666666666667e-2 * t26 * t472
  t476 = t463 * t475
  t477 = t370 * t476
  t479 = 0.2e1 / 0.15e2 * t369 * t477
  t480 = t386 * t393
  t481 = t480 * t368
  t482 = -t426
  t483 = t404 * t482
  t484 = t370 * t483
  t486 = 0.4e1 / 0.15e2 * t481 * t484
  t488 = t358 * t431 * t389
  t489 = 0.18891666666666666666666666666666666666666666666667e-2 * t488
  t490 = t85 * t397
  t491 = t79 ** 2
  t492 = 0.1e1 / t491
  t493 = t492 * t135
  t494 = t490 * t493
  t495 = t14 * t494
  t497 = t489 + 0.18891666666666666666666666666666666666666666666667e-2 * t495
  t498 = t387 * t497
  t499 = t498 * t368
  t501 = 0.2e1 / 0.15e2 * t499 * t405
  t502 = t447 * t404
  t504 = 0.4e1 / 0.45e2 * t395 * t502
  t505 = t394 * t451
  t507 = 0.1e1 / t396 / t388
  t508 = t23 * t507
  t509 = t403 * t492
  t510 = t509 * t135
  t511 = t508 * t510
  t513 = 0.4e1 / 0.45e2 * t505 * t511
  t514 = t402 ** 2
  t515 = 0.1e1 / t514
  t516 = t397 * t515
  t517 = 0.35991666666666666666666666666666666666666666666667e-1 * t488
  t521 = 0.66666666666666666666666666666666666666666666666667e-2 * t374 * t466 * t396
  t523 = t375 / t389
  t524 = t523 * t493
  t527 = -t517 - 0.35991666666666666666666666666666666666666666666667e-1 * t495 - t521 - 0.66666666666666666666666666666666666666666666666667e-2 * t26 * t524
  t528 = t516 * t527
  t529 = t370 * t528
  t531 = 0.2e1 / 0.15e2 * t395 * t529
  t532 = t324 * t409
  t536 = t301 * t1 * t43
  t537 = t12 * t409
  t538 = t537 * t414
  t540 = 0.34444444444444444444444444444444444444444444444444e-1 * t536 * t538
  t544 = (0.41250000000000000000000000000000000000000000000000e0 * t47 - t56 / 0.6e1) * jnp.pi
  t545 = t544 * t7
  t547 = 0.4e1 / 0.3e1 * t410 * t545
  t549 = 0.4e1 / 0.3e1 * t410 * t414
  t550 = t430 + t446 + t450 + t460 - t479 + t486 + t501 + t504 + t513 - t531 + 0.4e1 / 0.3e1 * t532 * t415 + t540 + t547 + t549
  t558 = t314 / 0.2e1 - 0.1e1 / 0.2e1
  t559 = t301 * t558
  t561 = 0.26314866163830089978458002229396252612500000000000e0 * t331 * t559
  t562 = t324 * t558
  t567 = t311 * t1 * t3
  t568 = t11 * t313
  t571 = t339 / 0.2e1 + 0.31350000000000000000000000000000000000000000000000e-1 * t567 * t568
  t572 = t301 * t571
  t574 = 0.26314866163830089978458002229396252612500000000000e0 * t305 * t572
  t576 = jnp.exp(-0.13675000000000000000000000000000000000000000000000e0 * t14)
  t577 = t301 * t576
  t580 = -0.97000000000000000000000000000000000000000000000000e-1 * t14 + 0.16900000000000000000000000000000000000000000000000e0 * t26
  t581 = t577 * t580
  t583 = t1 / t21
  t585 = t583 * t6 * t23
  t592 = (t192 * t436 / 0.2e1 + t193 * t491 / 0.2e1) * t207
  t593 = t367 * t1
  t594 = t593 * t23
  t597 = t385 + t407 + t581 * t585 / 0.3e1 - t592 * t594 / 0.15e2
  t601 = 0.63335044683271196147628012990392428933010869805128e-2 * t353 * t355 * t597 * jnp.pi
  t602 = t324 * t576
  t603 = t602 * t580
  t606 = t301 * t20
  t607 = 0.1e1 / t3
  t608 = t606 * t607
  t609 = t576 * t580
  t610 = t25 * t609
  t612 = 0.60777777777777777777777777777777777777777777777777e-1 * t608 * t610
  t615 = 0.32333333333333333333333333333333333333333333333333e-1 * t47 - 0.11266666666666666666666666666666666666666666666667e0 * t56
  t616 = t577 * t615
  t618 = t616 * t585 / 0.3e1
  t619 = t583 * t13
  t621 = 0.2e1 / 0.9e1 * t581 * t619
  t622 = t192 * t72
  t624 = t193 * t79
  t628 = (0.4e1 / 0.3e1 * t622 * t131 + 0.4e1 / 0.3e1 * t624 * t135) * t207
  t631 = t593 * t12
  t633 = 0.2e1 / 0.45e2 * t592 * t631
  t634 = t430 + t446 + t450 + t460 - t479 + t486 + t501 + t504 + t513 - t531 + t603 * t585 / 0.3e1 + t612 + t618 + t621 - t628 * t594 / 0.15e2 - t633
  t642 = -t104 + t128 * t119 + 0.19751789702565206228825776161588751761046270558698e-1 * t89 * t116
  t645 = 0.56945186695483624893780150000000000000000000000000e0 * t308 * t335 * t642
  t646 = 0.4e1 * t120
  t647 = 0.4e1 * t126
  t648 = 0.19751789702565206228825776161588751761046270558698e-1 * t180
  t649 = 0.18311555036753159941307229983139571945136646663793e-3 * t185
  t650 = 0.58482233974552040708313425006184496242808878304903e0 * t190
  t651 = t159 + t160 + t646 - t647 + t142 + t178 + t648 - t649 - t650
  t656 = t215 ** 2
  t658 = t5 * t355
  t660 = t352 * t658 * t301
  t661 = t656 * f.p.cam_omega
  t662 = t420 * t661
  t663 = t314 * t662
  t665 = 0.11259563499248212648467202309403098476979710187578e-1 * t660 * t663
  t667 = t352 * t55 * t324
  t671 = t352 * t55 * t301
  t672 = t339 * t662
  t674 = 0.67557380995489275890803213856418590861878261125470e-2 * t671 * t672
  t676 = 0.1e1 / t296 / t240
  t677 = t676 * t321
  t678 = t677 * t301
  t679 = t315 * t661
  t680 = t314 * t679
  t682 = 0.50830173461006131180240338105569347764477203670804e-2 * t678 * t680
  t683 = t355 * t301
  t684 = t558 * jnp.pi
  t687 = 0.16889345248872318972700803464104647715469565281367e-1 * t353 * t683 * t684
  t688 = t54 * t324
  t692 = t54 * t301
  t693 = t571 * jnp.pi
  t696 = 0.10133607149323391383620482078462788629281739168820e-1 * t353 * t692 * t693
  t697 = t241 * t321
  t699 = 0.10525946465532035991383200891758501045000000000000e1 * t697 * t642
  t700 = t241 * t129
  t704 = t656 * t215
  t707 = 0.1e1 / t23 / t320
  t709 = t656 ** 2
  t712 = 0.54045904796391420712642571085134872689502608900376e-1 * t353 * t707 * t642 * t709
  t717 = 0.3e1 * t200 * t242 * t248 + t291 * t294 + (t318 - 0.17543244109220059985638668152930835075000000000000e0 * t325 * t316 - t342 - t350 + t423 - 0.30400821447970174150861446235388365887845217506462e-2 * t353 * t54 * t550 * t420) * t223 + (t561 - 0.26314866163830089978458002229396252612500000000000e0 * t305 * t562 - t574 + t601 - 0.38001026809962717688576807794235457359806521883077e-2 * t353 * t54 * t634 * jnp.pi - t645 + 0.42708890021612718670335112500000000000000000000000e0 * t308 * t11 * t651) * t656 + t665 - 0.67557380995489275890803213856418590861878261125470e-2 * t667 * t663 - t674 - t682 + (t687 - 0.10133607149323391383620482078462788629281739168820e-1 * t353 * t688 * t684 - t696 - t699 + 0.52629732327660179956916004458792505225000000000000e0 * t700 * t651) * t704 - t712 + 0.20267214298646782767240964156925577258563478337641e-1 * t353 * t355 * t651 * t709
  t721 = 0.1e1 + 0.15403623315025000000000000000000000000000000000000e0 * t22 * t25 * t215
  t722 = t721 ** 2
  t723 = t722 ** 2
  t724 = 0.1e1 / t723
  t725 = t717 * t724
  t760 = t252 * t242 + (-0.17543244109220059985638668152930835075000000000000e0 * t328 * t316 - 0.30400821447970174150861446235388365887845217506462e-2 * t353 * t54 * t418 * t420) * t223 + (-0.26314866163830089978458002229396252612500000000000e0 * t305 * t559 - 0.38001026809962717688576807794235457359806521883077e-2 * t353 * t54 * t597 * jnp.pi + 0.42708890021612718670335112500000000000000000000000e0 * t308 * t11 * t642) * t656 - 0.67557380995489275890803213856418590861878261125470e-2 * t671 * t663 + (-0.10133607149323391383620482078462788629281739168820e-1 * t353 * t692 * t684 + 0.52629732327660179956916004458792505225000000000000e0 * t700 * t642) * t704 + 0.20267214298646782767240964156925577258563478337641e-1 * t353 * t355 * t642 * t709
  t762 = 0.1e1 / t723 / t721
  t764 = t760 * t762 * t20
  t765 = t21 * t5
  t767 = t765 * t54 * t215
  t769 = 0.82152657680133333333333333333333333333333333333336e0 * t764 * t767
  t770 = t38 ** 2
  t773 = t58 ** 2
  t774 = t31 ** 2
  t778 = 0.16081824322151104821330931780901225435013347914188e2 * t37 / t770 * t773 / t774
  t784 = 0.20000000000000000000000000000000000000000000000000e1 * t37 / t38 / t28 * t773 * t59
  t785 = t64 * t68
  t787 = 0.12e2 * t785 * t119
  t790 = 0.32e2 * t65 * t124 * t119
  t793 = 0.14764770444444444444444444444444444444444444444444e-2 * t4 * t335 * t32
  t795 = 0.1e1 / t164 / t111
  t796 = t171 ** 2
  t800 = 0.11696446794910408141662685001236899248561775660981e1 * t187 * t795 * t796 * t172
  t801 = 0.1e1 / t224
  t803 = t765 * t355
  t804 = t801 * t20 * t803
  t806 = t43 * t334
  t807 = t42 * t806
  t809 = t4 * t335
  t811 = t14 ** (-0.5e0)
  t813 = t811 * t20 * t803
  t815 = t50 * t806
  t817 = t22 * t658
  t822 = 0.10000000000000000000000000000000000000000000000000e1 * t40 * (-0.42198333333333333333333333333333333333333333333333e0 * t804 + 0.84396666666666666666666666666666666666666666666666e0 * t807 + 0.39862222222222222222222222222222222222222222222223e0 * t809 + 0.68258333333333333333333333333333333333333333333333e-1 * t813 + 0.13651666666666666666666666666666666666666666666667e0 * t815 + 0.13692777777777777777777777777777777777777777777778e0 * t817) * t59
  t829 = -0.57538888888888888888888888888888888888888888888889e0 * t804 + 0.11507777777777777777777777777777777777777777777778e1 * t807 + 0.40256666666666666666666666666666666666666666666667e0 * t809 + 0.36677500000000000000000000000000000000000000000000e-1 * t813 + 0.73355000000000000000000000000000000000000000000000e-1 * t815 + 0.13797500000000000000000000000000000000000000000000e0 * t817
  t833 = 0.58482233974552040708313425006184496242808878304903e0 * t187 * t165 * t829 * t172
  t834 = t164 ** 2
  t835 = 0.1e1 / t834
  t837 = t114 ** 2
  t838 = 0.1e1 / t837
  t841 = 0.17315755899375863299672358916972966258900005419821e2 * t187 * t835 * t796 * t838
  t843 = t140 * t106 * t189
  t844 = 0.11696446794910408141662685001236899248561775660981e1 * t843
  t846 = t128 * t140 * t176
  t847 = 0.2e1 * t846
  t858 = t154 ** 2
  t872 = t147 ** 2
  t875 = t99 ** 2
  t883 = 0.35616666666666666666666666666666666666666666666666e-1 * t358 * t10 * t39 * t60
  t902 = -0.70981924444444444444444444444444444444444444444442e-3 * t4 * t335 * t100 - 0.34246666666666666666666666666666666666666666666666e-1 * t358 * t10 * t148 * t156 - 0.20000000000000000000000000000000000000000000000000e1 * t91 / t147 / t96 * t858 * t155 + 0.99999999999999999999999999999999999999999999999999e0 * t149 * (-0.78438333333333333333333333333333333333333333333333e0 * t804 + 0.15687666666666666666666666666666666666666666666667e1 * t807 + 0.68863333333333333333333333333333333333333333333333e0 * t809 + 0.14025833333333333333333333333333333333333333333333e0 * t813 + 0.28051666666666666666666666666666666666666666666667e0 * t815 + 0.17365833333333333333333333333333333333333333333333e0 * t817) * t155 + 0.32164683177870697973624959794146027661627532968800e2 * t91 / t872 * t858 / t875 + t793 + t883 + t784 - t822 - t778 - 0.24415406715670879921742973310852762593515528885057e-3 * t4 * t335 * t115 - 0.10843580882781524214666447553230042011687479519034e-1 * t358 * t10 * t165 * t173 - 0.11696446794910408141662685001236899248561775660981e1 * t106 * t795 * t796 * t172 + 0.58482233974552040708313425006184496242808878304903e0 * t166 * t829 * t172 + 0.17315755899375863299672358916972966258900005419821e2 * t106 * t835 * t796 * t838
  t904 = t128 * t89 * t902
  t906 = 0.8e1 * t125 * t177
  t907 = t778 - t784 + t787 - t790 - t793 + t800 + t822 - t833 - t841 - t844 + t847 + t904 - t906
  t908 = 0.1e1 / t192
  t909 = t131 ** 2
  t912 = t63 * t321
  t913 = -t129 + t912
  t914 = 0.2e1 * t913
  t918 = f.my_piecewise3(t73, 0, 0.4e1 / 0.9e1 * t908 * t909 + 0.4e1 / 0.3e1 * t76 * t914)
  t919 = 0.1e1 / t193
  t920 = t135 ** 2
  t923 = -t914
  t927 = f.my_piecewise3(t80, 0, 0.4e1 / 0.9e1 * t919 * t920 + 0.4e1 / 0.3e1 * t81 * t923)
  t929 = (t918 + t927) * t88
  t931 = t128 * t929 * t118
  t932 = t69 * t141
  t933 = 0.8e1 * t932
  t935 = 0.8e1 * t69 * t177
  t936 = t125 * t141
  t937 = 0.8e1 * t936
  t942 = 0.20e2 * t122 / t67 / t66 * t119
  t944 = t140 * t1 * t184
  t945 = 0.36623110073506319882614459966279143890273293327586e-3 * t944
  t949 = 0.24415406715670879921742973310852762593515528885057e-3 * t182 * t43 * t334 * t115
  t956 = 0.1e1 / t8 / t320
  t960 = 0.63272429661648472104200166666666666666666666666669e0 * t760 / t723 / t722 * t1 * t307 * t6 * t956 * t656
  t964 = 0.10843580882781524214666447553230042011687479519034e-1 * t89 * t4 * t11 * t189
  t966 = 0.19751789702565206228825776161588751761046270558698e-1 * t929 * t116
  t970 = 0.35086488218440119971277336305861670150000000000000e0 * t298 * t321 * t301 * t316
  t972 = t299 * t324 * t316
  t975 = 0.35086488218440119971277336305861670150000000000000e0 * t302 * t340
  t979 = 0.36665380188269925369984816439625445306750000000000e-1 * t298 * t956 * t344 * t348
  t980 = 0.2e1 * t129
  t981 = 0.8e1 * t912
  t982 = 0.6e1 * t785
  t983 = -t980 + t981 - t982
  t987 = t325 * t340
  t991 = t343 * t324 * t311 * t348
  t995 = t2 * t321
  t997 = t6 * t956
  t1001 = (0.23000000000000000000000000000000000000000000000000e-2 * t809 + 0.22758333333333333333333333333333333333333333333333e-1 * t817 - 0.19155000000000000000000000000000000000000000000000e-1 * t995 + 0.10844166666666666666666666666666666666666666666667e-2 * t308 * t997) * t313
  t1004 = 0.17543244109220059985638668152930835075000000000000e0 * t328 * t1001 * t315
  t1008 = 0.21999228112961955221990889863775267184050000000000e-1 * t343 * t301 * t338 * t348
  t1015 = 0.27587032053654291848376575889174185048798700000000e-2 * t298 * t707 * t344 * t22 * t5 * t313 * t315
  t1019 = 0.13511476199097855178160642771283718172375652225094e-1 * t353 * t707 * t418 * t420
  t1022 = t353 * t355 * t550 * t420
  t1027 = t532 * t545
  t1035 = 0.4e1 / 0.3e1 * t410 * (-0.55000000000000000000000000000000000000000000000000e0 * t809 + 0.5e1 / 0.18e2 * t817) * jnp.pi * t7
  t1036 = t334 * t85
  t1038 = t358 * t1036 * t361
  t1039 = 0.47988888888888888888888888888888888888888888888889e-1 * t1038
  t1040 = t47 * t439
  t1042 = t85 * t454
  t1043 = t436 ** 2
  t1044 = 0.1e1 / t1043
  t1045 = t1044 * t909
  t1047 = t14 * t1042 * t1045
  t1050 = 0.1e1 / t436 / t72
  t1051 = t1050 * t909
  t1053 = t14 * t435 * t1051
  t1055 = t437 * t914
  t1057 = t14 * t435 * t1055
  t1059 = t355 * t375
  t1062 = 0.11111111111111111111111111111111111111111111111111e-1 * t374 * t1059 * t371
  t1063 = t56 * t472
  t1067 = t375 / t361 / t360
  t1081 = 0.2e1 / 0.15e2 * t369 * t370 * t463 * (t1039 + 0.23994444444444444444444444444444444444444444444444e-1 * t1040 - 0.23994444444444444444444444444444444444444444444445e-1 * t1047 + 0.71983333333333333333333333333333333333333333333334e-1 * t1053 - 0.35991666666666666666666666666666666666666666666667e-1 * t1057 + t1062 + 0.88888888888888888888888888888888888888888888888890e-2 * t1063 - 0.22222222222222222222222222222222222222222222222222e-2 * t26 * t1067 * t1045 + 0.13333333333333333333333333333333333333333333333333e-1 * t26 * t471 * t1051 - 0.66666666666666666666666666666666666666666666666667e-2 * t26 * t471 * t1055)
  t1083 = t356 * t442 * t368
  t1085 = 0.8e1 / 0.15e2 * t1083 * t428
  t1089 = 0.4e1 / 0.15e2 * t425 * t370 * t382 * t913
  t1091 = 0.1e1 / t514 / t402
  t1092 = t397 * t1091
  t1093 = t527 ** 2
  t1097 = 0.4e1 / 0.15e2 * t395 * t370 * t1092 * t1093
  t1099 = t481 * t447 * t483
  t1100 = 0.16e2 / 0.45e2 * t1099
  t1102 = t358 * t1036 * t389
  t1103 = 0.47988888888888888888888888888888888888888888888889e-1 * t1102
  t1104 = t47 * t494
  t1106 = t85 * t507
  t1107 = t491 ** 2
  t1108 = 0.1e1 / t1107
  t1109 = t1108 * t920
  t1111 = t14 * t1106 * t1109
  t1114 = 0.1e1 / t491 / t79
  t1115 = t1114 * t920
  t1117 = t14 * t490 * t1115
  t1119 = t492 * t923
  t1121 = t14 * t490 * t1119
  t1125 = 0.11111111111111111111111111111111111111111111111111e-1 * t374 * t1059 * t396
  t1126 = t56 * t524
  t1130 = t375 / t389 / t388
  t1144 = 0.2e1 / 0.15e2 * t395 * t370 * t516 * (t1103 + 0.23994444444444444444444444444444444444444444444444e-1 * t1104 - 0.23994444444444444444444444444444444444444444444445e-1 * t1111 + 0.71983333333333333333333333333333333333333333333334e-1 * t1117 - 0.35991666666666666666666666666666666666666666666667e-1 * t1121 + t1125 + 0.88888888888888888888888888888888888888888888888890e-2 * t1126 - 0.22222222222222222222222222222222222222222222222222e-2 * t26 * t1130 * t1109 + 0.13333333333333333333333333333333333333333333333333e-1 * t26 * t523 * t1115 - 0.66666666666666666666666666666666666666666666666667e-2 * t26 * t523 * t1119)
  t1146 = 0.4e1 / 0.15e2 * t499 * t529
  t1148 = t395 * t447 * t528
  t1149 = 0.8e1 / 0.45e2 * t1148
  t1150 = 0.4e1 / 0.3e1 * t983 * t409 * t415 + 0.8e1 / 0.3e1 * t1027 + t1035 - t1081 + t1085 + t1089 + t1097 + t1100 - t1144 - t1146 - t1149
  t1152 = t386 * t497 * t368
  t1154 = 0.8e1 / 0.15e2 * t1152 * t484
  t1159 = -0.4e1 / 0.15e2 * t481 * t370 * t404 * t913
  t1161 = 0.4e1 / 0.15e2 * t444 * t477
  t1163 = t369 * t447 * t476
  t1164 = 0.8e1 / 0.45e2 * t1163
  t1166 = 0.1e1 / t461 / t380
  t1167 = t372 * t1166
  t1168 = t475 ** 2
  t1172 = 0.4e1 / 0.15e2 * t369 * t370 * t1167 * t1168
  t1174 = t425 * t447 * t427
  t1175 = 0.16e2 / 0.45e2 * t1174
  t1176 = t508 * t515
  t1180 = 0.8e1 / 0.45e2 * t505 * t1176 * t493 * t527
  t1181 = t455 * t462
  t1185 = 0.8e1 / 0.45e2 * t452 * t1181 * t438 * t475
  t1186 = t480 * t451
  t1187 = t508 * t403
  t1192 = 0.16e2 / 0.45e2 * t1186 * t1187 * t482 * t492 * t135
  t1193 = t424 * t451
  t1194 = t455 * t381
  t1199 = 0.16e2 / 0.45e2 * t1193 * t1194 * t426 * t437 * t131
  t1200 = t532 * t414
  t1203 = 0.8e1 / 0.3e1 * t410 * t544
  t1204 = t1154 + t1159 - t1161 - t1164 + t1172 + t1175 - t1180 - t1185 + t1192 + t1199 + 0.8e1 / 0.3e1 * t1200 + t1203
  t1206 = t403 * t1114
  t1210 = 0.8e1 / 0.45e2 * t505 * t508 * t1206 * t920
  t1211 = t381 * t1050
  t1215 = 0.8e1 / 0.45e2 * t452 * t455 * t1211 * t909
  t1216 = t23 * t397
  t1221 = 0.8e1 / 0.15e2 * t1186 * t1216 * t515 * t482 * t527
  t1222 = t498 * t451
  t1224 = 0.8e1 / 0.45e2 * t1222 * t511
  t1225 = t12 * t507
  t1227 = t505 * t1225 * t510
  t1228 = 0.16e2 / 0.135e3 * t1227
  t1232 = 0.4e1 / 0.45e2 * t505 * t508 * t509 * t923
  t1235 = t23 / t396 / t492
  t1236 = t403 * t1108
  t1240 = 0.4e1 / 0.27e2 * t505 * t1235 * t1236 * t920
  t1241 = t443 * t451
  t1243 = 0.8e1 / 0.45e2 * t1241 * t458
  t1244 = t12 * t454
  t1246 = t452 * t1244 * t457
  t1247 = 0.16e2 / 0.135e3 * t1246
  t1251 = 0.4e1 / 0.45e2 * t452 * t455 * t456 * t914
  t1254 = t23 / t371 / t437
  t1255 = t381 * t1044
  t1259 = 0.4e1 / 0.27e2 * t452 * t1254 * t1255 * t909
  t1260 = t23 * t372
  t1265 = 0.8e1 / 0.15e2 * t1193 * t1260 * t462 * t426 * t475
  t1266 = -t1210 - t1215 - t1221 + t1224 + t1228 + t1232 + t1240 + t1243 + t1247 + t1251 + t1259 - t1265
  t1267 = 0.25188888888888888888888888888888888888888888888889e-2 * t1038
  t1276 = 0.2e1 / 0.15e2 * t357 * (-t1267 - 0.12594444444444444444444444444444444444444444444445e-2 * t1040 + 0.12594444444444444444444444444444444444444444444445e-2 * t1047 - 0.37783333333333333333333333333333333333333333333334e-2 * t1053 + 0.18891666666666666666666666666666666666666666666667e-2 * t1057) * t368 * t383
  t1280 = 0.22962962962962962962962962962962962962962962962963e-1 * t536 * t10 * t409 * t414
  t1281 = t499 * t502
  t1282 = 0.8e1 / 0.45e2 * t1281
  t1283 = t1 * t10
  t1286 = 0.4e1 / 0.135e3 * t395 * t1283 * t404
  t1287 = t482 ** 2
  t1291 = 0.4e1 / 0.15e2 * t1287 * t393 * t368 * t405
  t1294 = 0.4e1 / 0.135e3 * t369 * t1283 * t382
  t1295 = t426 ** 2
  t1299 = 0.4e1 / 0.15e2 * t1295 * t365 * t368 * t383
  t1300 = t444 * t448
  t1301 = 0.8e1 / 0.45e2 * t1300
  t1304 = t324 * t1 * t43 * t538
  t1308 = 0.68888888888888888888888888888888888888888888888888e-1 * t536 * t537 * t544
  t1313 = 0.35592592592592592592592592592592592592592592592591e-2 * t606 * t765 * t54 * t409 * t414
  t1314 = 0.25188888888888888888888888888888888888888888888889e-2 * t1102
  t1323 = 0.2e1 / 0.15e2 * t387 * (-t1314 - 0.12594444444444444444444444444444444444444444444445e-2 * t1104 + 0.12594444444444444444444444444444444444444444444445e-2 * t1111 - 0.37783333333333333333333333333333333333333333333334e-2 * t1117 + 0.18891666666666666666666666666666666666666666666667e-2 * t1121) * t368 * t405
  t1324 = t1276 + t1280 + t1282 - t1286 + t1291 - t1294 + t1299 + t1301 + 0.68888888888888888888888888888888888888888888888888e-1 * t1304 + t1308 + t1313 + t1323
  t1331 = -t970 + 0.35086488218440119971277336305861670150000000000000e0 * t972 + t975 + t979 - 0.17543244109220059985638668152930835075000000000000e0 * t319 * t983 * t316 - 0.35086488218440119971277336305861670150000000000000e0 * t987 - 0.21999228112961955221990889863775267184050000000000e-1 * t991 - t1004 - t1008 - t1015 - t1019 + 0.10133607149323391383620482078462788629281739168821e-1 * t1022 - 0.30400821447970174150861446235388365887845217506462e-2 * t353 * t54 * (t1150 + t1204 + t1266 + t1324) * t420
  t1333 = t5 * t707
  t1337 = 0.30025502664661900395912539491741595938612560500208e-1 * t352 * t1333 * t301 * t663
  t1340 = 0.67557380995489275890803213856418590861878261125470e-2 * t671 * t1001 * t662
  t1350 = 0.31870518760050844250010691992191981048327206701594e-3 * t676 / t8 / t67 * t344 * t1 * t43 * t313 * t315 * t661
  t1353 = t352 * t658 * t324 * t663
  t1356 = 0.22519126998496425296934404618806196953959420375156e-1 * t660 * t672
  t1361 = t667 * t672
  t1363 = t787 - t790 - t793 + t966 + t964 - t841 - t844 - t833 - t945 + t822 + t778
  t1364 = -t784 + t933 + t935 - t937 - t906 + t931 + t847 + t904 + t942 + t800 - t883 + t949
  t1365 = t1363 + t1364
  t1372 = t353 * t707 * t651 * t709
  t1379 = 0.19816831758676854261302276064549453319484289930138e0 * t353 / t23 / t67 * t642 * t709
  t1380 = t1331 * t223 - t1337 - t1340 - t1350 + 0.22519126998496425296934404618806196953959420375156e-1 * t1353 + t1356 - 0.67557380995489275890803213856418590861878261125470e-2 * t352 * t55 * t983 * t663 - 0.13511476199097855178160642771283718172375652225094e-1 * t1361 + 0.20267214298646782767240964156925577258563478337641e-1 * t353 * t355 * t1365 * t709 - 0.10809180959278284142528514217026974537900521780075e0 * t1372 + t1379
  t1384 = 0.23720747615136194550778824449265695623422695046375e-1 * t676 * t68 * t301 * t680
  t1386 = t677 * t324 * t680
  t1390 = 0.10166034692201226236048067621113869552895440734161e-1 * t678 * t339 * t679
  t1394 = 0.45038253996992850593868809237612393907918840750312e-1 * t353 * t707 * t301 * t684
  t1397 = t353 * t355 * t324 * t684
  t1401 = 0.33778690497744637945401606928209295430939130562734e-1 * t353 * t683 * t693
  t1407 = t353 * t688 * t693
  t1422 = t1001 / 0.2e1 + 0.62700000000000000000000000000000000000000000000000e-1 * t338 * t1 * t3 * t568 - 0.41800000000000000000000000000000000000000000000000e-1 * t567 * t335 * t313 + 0.78625800000000000000000000000000000000000000000000e-2 * t311 * t20 * t21 * t658 * t313
  t1426 = 0.10133607149323391383620482078462788629281739168820e-1 * t353 * t692 * t1422 * jnp.pi
  t1429 = 0.31577839396596107974149602675275503135000000000000e1 * t241 * t68 * t642
  t1430 = t697 * t651
  t1437 = 0.52629732327660179956916004458792505225000000000000e0 * t995 * t559
  t1438 = t331 * t562
  t1441 = 0.52629732327660179956916004458792505225000000000000e0 * t331 * t572
  t1446 = t305 * t324 * t571
  t1450 = 0.26314866163830089978458002229396252612500000000000e0 * t305 * t301 * t1422
  t1454 = 0.16889345248872318972700803464104647715469565281367e-1 * t353 * t707 * t597 * jnp.pi
  t1457 = t353 * t355 * t634 * jnp.pi
  t1461 = 0.33245444444444444444444444444444444444444444444444e-1 * t301 * t129 * t609
  t1462 = t1461 - t1081 + t1085 + t1089 + t1097 + t1100 - t1144 - t1146 - t1149 + t1154 + t1159 - t1161
  t1464 = 0.4e1 / 0.9e1 * t616 * t619
  t1467 = 0.2e1 / 0.27e2 * t581 * t583 * t11
  t1468 = t603 * t619
  t1475 = t602 * t615 * t585
  t1479 = t324 * t20 * t607 * t610
  t1484 = 0.12155555555555555555555555555555555555555555555555e0 * t608 * t25 * t576 * t615
  t1490 = t577 * (-0.43111111111111111111111111111111111111111111111111e-1 * t809 + 0.18777777777777777777777777777777777777777777777778e0 * t817) * t585 / 0.3e1
  t1491 = -t1164 + t1172 + t1175 + t1464 - t1467 + 0.4e1 / 0.9e1 * t1468 + t983 * t576 * t580 * t585 / 0.3e1 + 0.2e1 / 0.3e1 * t1475 + 0.12155555555555555555555555555555555555555555555555e0 * t1479 + t1484 + t1490 - t1180 - t1185
  t1493 = t628 * t631
  t1497 = 0.2e1 / 0.135e3 * t592 * t593 * t10
  t1510 = t1192 + t1199 - 0.4e1 / 0.45e2 * t1493 + t1497 - (0.20e2 / 0.9e1 * t192 * t909 + 0.4e1 / 0.3e1 * t622 * t914 + 0.20e2 / 0.9e1 * t193 * t920 + 0.4e1 / 0.3e1 * t624 * t923) * t207 * t594 / 0.15e2 - t1210 - t1215 - t1221 + t1224 + t1228 + t1232 + t1240
  t1511 = t1243 + t1247 + t1251 + t1259 - t1265 + t1276 + t1282 - t1286 + t1291 - t1294 + t1299 + t1301 + t1323
  t1520 = 0.13287210228946179141882035000000000000000000000000e1 * t308 * t997 * t642
  t1522 = t308 * t335 * t651
  t1527 = -t1437 + 0.52629732327660179956916004458792505225000000000000e0 * t1438 + t1441 - 0.26314866163830089978458002229396252612500000000000e0 * t305 * t983 * t558 - 0.52629732327660179956916004458792505225000000000000e0 * t1446 - t1450 - t1454 + 0.12667008936654239229525602598078485786602173961026e-1 * t1457 - 0.38001026809962717688576807794235457359806521883077e-2 * t353 * t54 * (t1462 + t1491 + t1510 + t1511) * jnp.pi + t1520 - 0.11389037339096724978756030000000000000000000000000e1 * t1522 + 0.42708890021612718670335112500000000000000000000000e0 * t308 * t11 * t1365
  t1532 = 0.32478055555555555555555555555555555555555555555555e0 * f.p.cam_omega * t801 * t202 * t817
  t1536 = t43 * t10 * t248
  t1537 = t253 * t218 * t1 * t1536
  t1538 = 0.97434166666666666666666666666666666666666666666666e0 * t1537
  t1540 = 0.64956111111111111111111111111111111111111111111111e0 * t254 * t809
  t1541 = t248 ** 2
  t1544 = 0.58460500000000000000000000000000000000000000000000e1 * t201 * t227 * t1541
  t1545 = 0.1e1 / t77
  t1550 = 0.1e1 / t82
  t1555 = -t1545 * t909 / 0.9e1 + t243 * t914 / 0.3e1 - t1550 * t920 / 0.9e1 + t245 * t923 / 0.3e1
  t1558 = 0.29230250000000000000000000000000000000000000000000e1 * t201 * t218 * t1555
  t1562 = t217 * t43 * t334 * t218 / 0.9e1
  t1563 = t11 * t265
  t1564 = t264 * t1563
  t1567 = t13 * t274 * t1541
  t1571 = t13 * t227 * t1555
  t1577 = 0.16322666666666666666666666666666666666666666666667e0 * t223 * t41 * t227 * t817
  t1580 = t269 * t274 * t1 * t1536
  t1583 = 0.32645333333333333333333333333333333333333333333333e0 * t270 * t809
  t1585 = 0.1e1 / t273 / t195
  t1592 = -t1532 + t1538 + t1540 + t1544 - t1558 + t1562 + t1564 / 0.3e1 + 0.3e1 / 0.2e1 * t264 * t1567 - t264 * t1571 / 0.2e1 + t1577 + 0.14690400000000000000000000000000000000000000000000e1 * t1580 + t1583 + 0.58761600000000000000000000000000000000000000000000e1 * t225 * t1585 * t1541 - 0.14690400000000000000000000000000000000000000000000e1 * t225 * t274 * t1555
  t1594 = t278 * t281
  t1599 = t230 / t280 / t236
  t1600 = t288 ** 2
  t1605 = 0.38316777777777777777777777777777777777777777777777e0 * t232 * t335 * t218
  t1606 = t232 * t1563
  t1618 = t292 * t288 * t241
  t1620 = t195 * t199
  t1624 = t200 * t290
  t1626 = t293 * t241 * t248
  t1629 = t230 ** 2
  t1631 = 0.1e1 / t1629 * t236
  t1633 = t1631 * t241 * t278
  t1638 = t1384 - 0.10166034692201226236048067621113869552895440734161e-1 * t1386 - t1390 + (-t1394 + 0.33778690497744637945401606928209295430939130562734e-1 * t1397 + t1401 - 0.10133607149323391383620482078462788629281739168820e-1 * t353 * t54 * t983 * t684 - 0.20267214298646782767240964156925577258563478337640e-1 * t1407 - t1426 + t1429 - 0.21051892931064071982766401783517002090000000000000e1 * t1430 + 0.52629732327660179956916004458792505225000000000000e0 * t700 * t1365) * t704 + t1527 * t656 + t252 * (t1592 * t237 - 0.2e1 * t1594 * t288 + 0.2e1 * t1599 * t1600 - t282 * (-t1532 + t1538 + t1540 + t1544 - t1558 + t1605 + 0.11495033333333333333333333333333333333333333333333e1 * t1606 + 0.51727650000000000000000000000000000000000000000000e1 * t232 * t1567 - 0.17242550000000000000000000000000000000000000000000e1 * t232 * t1571)) * t294 + t291 * t1618 + 0.6e1 * t1620 * t242 * t1541 + 0.6e1 * t1624 * t1626 - t291 * t1633 + 0.3e1 * t200 * t242 * t1555
  t1644 = 0.68460548066777777777777777777777777777777777777780e0 * t764 * t765 * t355 * t215
  t1647 = t717 * t762 * t20 * t767
  t1649 = t931 + t933 + t935 - t937 + t942 - t945 - t883 + t949 - t960 + t964 + t966 - (t1380 + t1638) * t724 + t1644 - 0.82152657680133333333333333333333333333333333333336e0 * t1647
  d11 = t35 + t62 + t121 - t127 + 0.2e1 * t142 + t179 + 0.39503579405130412457651552323177503522092541117396e-1 * t180 - t186 - t191 - 0.2e1 * t725 - t769 + t7 * (t907 + t1649)
  t1652 = -t70 - t130
  t1655 = f.my_piecewise3(t73, 0, 0.4e1 / 0.3e1 * t76 * t1652)
  t1656 = -t1652
  t1659 = f.my_piecewise3(t80, 0, 0.4e1 / 0.3e1 * t81 * t1656)
  t1661 = (t1655 + t1659) * t88
  t1662 = t1661 * t118
  t1663 = t128 * t1662
  t1664 = t1661 * t116
  t1665 = 0.19751789702565206228825776161588751761046270558698e-1 * t1664
  t1669 = t243 * t1652 / 0.3e1 + t245 * t1656 / 0.3e1
  t1673 = t218 * t1669
  t1675 = 0.29230250000000000000000000000000000000000000000000e1 * t201 * t1673
  t1676 = t227 * t1669
  t1677 = t13 * t1676
  t1680 = t274 * t1669
  t1683 = -t256 - t1675 - t263 - t264 * t1677 / 0.2e1 - t272 - 0.14690400000000000000000000000000000000000000000000e1 * t225 * t1680
  t1687 = -t256 - t1675 - t285 - 0.17242550000000000000000000000000000000000000000000e1 * t232 * t1677
  t1689 = t1683 * t237 - t282 * t1687
  t1690 = t252 * t1689
  t1693 = 0.2e1 * t130 + 0.2e1 * t322
  t1694 = t319 * t1693
  t1697 = t1652 / 0.2e1
  t1698 = t382 * t1697
  t1699 = t370 * t1698
  t1701 = 0.4e1 / 0.15e2 * t425 * t1699
  t1702 = t437 * t1652
  t1703 = t435 * t1702
  t1704 = t14 * t1703
  t1706 = t434 + 0.18891666666666666666666666666666666666666666666667e-2 * t1704
  t1707 = t357 * t1706
  t1708 = t1707 * t368
  t1710 = 0.2e1 / 0.15e2 * t1708 * t383
  t1711 = t456 * t1652
  t1712 = t455 * t1711
  t1714 = 0.4e1 / 0.45e2 * t452 * t1712
  t1716 = t471 * t1702
  t1719 = -t464 - 0.35991666666666666666666666666666666666666666666667e-1 * t1704 - t469 - 0.66666666666666666666666666666666666666666666666667e-2 * t26 * t1716
  t1720 = t463 * t1719
  t1721 = t370 * t1720
  t1723 = 0.2e1 / 0.15e2 * t369 * t1721
  t1724 = -t1697
  t1725 = t404 * t1724
  t1726 = t370 * t1725
  t1728 = 0.4e1 / 0.15e2 * t481 * t1726
  t1729 = t492 * t1656
  t1730 = t490 * t1729
  t1731 = t14 * t1730
  t1733 = t489 + 0.18891666666666666666666666666666666666666666666667e-2 * t1731
  t1734 = t387 * t1733
  t1735 = t1734 * t368
  t1737 = 0.2e1 / 0.15e2 * t1735 * t405
  t1738 = t509 * t1656
  t1739 = t508 * t1738
  t1741 = 0.4e1 / 0.45e2 * t505 * t1739
  t1743 = t523 * t1729
  t1746 = -t517 - 0.35991666666666666666666666666666666666666666666667e-1 * t1731 - t521 - 0.66666666666666666666666666666666666666666666666667e-2 * t26 * t1743
  t1747 = t516 * t1746
  t1748 = t370 * t1747
  t1750 = 0.2e1 / 0.15e2 * t395 * t1748
  t1751 = t1693 * t409
  t1754 = t1701 + t1710 + t450 + t1714 - t1723 + t1728 + t1737 + t504 + t1741 - t1750 + 0.4e1 / 0.3e1 * t1751 * t415 + t540 + t547 + t549
  t1761 = t1693 * t558
  t1764 = t1693 * t576
  t1765 = t1764 * t580
  t1772 = (0.4e1 / 0.3e1 * t622 * t1652 + 0.4e1 / 0.3e1 * t624 * t1656) * t207
  t1775 = t1701 + t1710 + t450 + t1714 - t1723 + t1728 + t1737 + t504 + t1741 - t1750 + t1765 * t585 / 0.3e1 + t612 + t618 + t621 - t1772 * t594 / 0.15e2 - t633
  t1780 = t159 + t160 - t646 - t647 + t1663 + t178 + t1665 - t649 - t650
  t1787 = t352 * t55 * t1693
  t1790 = t54 * t1693
  t1802 = 0.3e1 * t200 * t242 * t1669 + t1690 * t294 + (t318 - 0.17543244109220059985638668152930835075000000000000e0 * t1694 * t316 - t342 - t350 + t423 - 0.30400821447970174150861446235388365887845217506462e-2 * t353 * t54 * t1754 * t420) * t223 + (t561 - 0.26314866163830089978458002229396252612500000000000e0 * t305 * t1761 - t574 + t601 - 0.38001026809962717688576807794235457359806521883077e-2 * t353 * t54 * t1775 * jnp.pi - t645 + 0.42708890021612718670335112500000000000000000000000e0 * t308 * t11 * t1780) * t656 + t665 - 0.67557380995489275890803213856418590861878261125470e-2 * t1787 * t663 - t674 - t682 + (t687 - 0.10133607149323391383620482078462788629281739168820e-1 * t353 * t1790 * t684 - t696 - t699 + 0.52629732327660179956916004458792505225000000000000e0 * t700 * t1780) * t704 - t712 + 0.20267214298646782767240964156925577258563478337641e-1 * t353 * t355 * t1780 * t709
  t1803 = t1802 * t724
  t1811 = f.my_piecewise3(t73, 0, 0.4e1 / 0.9e1 * t908 * t1652 * t131 + 0.8e1 / 0.3e1 * t76 * t63 * t321)
  t1819 = f.my_piecewise3(t80, 0, 0.4e1 / 0.9e1 * t919 * t1656 * t135 - 0.8e1 / 0.3e1 * t81 * t63 * t321)
  t1821 = (t1811 + t1819) * t88
  t1823 = 0.19751789702565206228825776161588751761046270558698e-1 * t1821 * t116
  t1825 = t1661 * t106 * t189
  t1826 = 0.58482233974552040708313425006184496242808878304903e0 * t1825
  t1827 = 0.58482233974552040708313425006184496242808878304903e0 * t843
  t1828 = 0.4e1 * t932
  t1829 = t1823 - t1826 + t778 - t784 - t787 - t793 + t800 + t822 - t833 - t841 - t1827 + t846 + t904 - t906 - t1828
  t1830 = 0.4e1 * t936
  t1832 = t128 * t1821 * t118
  t1834 = t128 * t1661 * t176
  t1835 = 0.18311555036753159941307229983139571945136646663793e-3 * t944
  t1838 = t1802 * t762 * t20 * t767
  t1842 = t241 * t1669
  t1846 = 0.48717083333333333333333333333333333333333333333333e0 * t1537
  t1848 = t253 * t1673 * t47
  t1849 = 0.48717083333333333333333333333333333333333333333333e0 * t1848
  t1852 = 0.58460500000000000000000000000000000000000000000000e1 * t201 * t1676 * t248
  t1865 = -t1545 * t1652 * t131 / 0.9e1 + 0.2e1 / 0.3e1 * t243 * t63 * t321 - t1550 * t1656 * t135 / 0.9e1 - 0.2e1 / 0.3e1 * t245 * t63 * t321
  t1868 = 0.29230250000000000000000000000000000000000000000000e1 * t201 * t218 * t1865
  t1870 = t11 * t1676
  t1871 = t264 * t1870
  t1878 = t13 * t227 * t1865
  t1883 = t269 * t1680 * t47
  t1892 = -t1532 + t1846 + t1540 + t1849 + t1852 - t1868 + t1562 + t1564 / 0.6e1 + t1871 / 0.6e1 + 0.3e1 / 0.2e1 * t264 * t13 * t1680 * t248 - t264 * t1878 / 0.2e1 + t1577 + 0.73452000000000000000000000000000000000000000000000e0 * t1580 + t1583 + 0.73452000000000000000000000000000000000000000000000e0 * t1883 + 0.58761600000000000000000000000000000000000000000000e1 * t225 * t1585 * t1669 * t248 - 0.14690400000000000000000000000000000000000000000000e1 * t225 * t274 * t1865
  t1894 = t1683 * t281
  t1901 = t232 * t1870
  t1911 = -t1532 + t1846 + t1540 + t1849 + t1852 - t1868 + t1605 + 0.57475166666666666666666666666666666666666666666666e0 * t1606 + 0.57475166666666666666666666666666666666666666666667e0 * t1901 + 0.51727650000000000000000000000000000000000000000000e1 * t231 * t43 * t12 * t274 * t1669 * t248 - 0.17242550000000000000000000000000000000000000000000e1 * t232 * t1878
  t1917 = t331 * t1761
  t1919 = t980 - t982
  t1924 = t305 * t1693 * t571
  t1930 = t353 * t355 * t1775 * jnp.pi
  t1932 = t1724 * t492
  t1936 = 0.8e1 / 0.45e2 * t1186 * t1187 * t1932 * t135
  t1937 = t1697 * t437
  t1941 = 0.8e1 / 0.45e2 * t1193 * t1194 * t1937 * t131
  t1945 = 0.8e1 / 0.45e2 * t1193 * t1194 * t1702 * t426
  t1949 = 0.8e1 / 0.45e2 * t1186 * t1187 * t1729 * t482
  t1953 = 0.4e1 / 0.45e2 * t505 * t1176 * t1729 * t527
  t1955 = t1114 * t1656 * t135
  t1958 = 0.8e1 / 0.45e2 * t505 * t1187 * t1955
  t1961 = t1108 * t1656 * t135
  t1964 = 0.4e1 / 0.27e2 * t505 * t1235 * t403 * t1961
  t1969 = 0.4e1 / 0.45e2 * t505 * t1176 * t1746 * t492 * t135
  t1973 = 0.4e1 / 0.45e2 * t452 * t1181 * t1702 * t475
  t1975 = t1050 * t1652 * t131
  t1978 = 0.8e1 / 0.45e2 * t452 * t1194 * t1975
  t1981 = t1044 * t1652 * t131
  t1984 = 0.4e1 / 0.27e2 * t452 * t1254 * t381 * t1981
  t1989 = 0.4e1 / 0.45e2 * t452 * t1181 * t1719 * t437 * t131
  t1995 = t1764 * t615 * t585
  t1999 = t1693 * t20 * t607 * t610
  t2001 = t1765 * t619
  t2003 = 0.8e1 / 0.45e2 * t1099
  t2004 = t1461 + t1936 + t1941 + t1945 + t1949 - t1953 - t1958 + t1964 - t1969 - t1973 - t1978 + t1984 - t1989 + t1919 * t576 * t580 * t585 / 0.3e1 + t1995 / 0.3e1 + 0.60777777777777777777777777777777777777777777777777e-1 * t1999 + 0.2e1 / 0.9e1 * t2001 + t2003
  t2005 = 0.4e1 / 0.45e2 * t1148
  t2006 = 0.4e1 / 0.45e2 * t1163
  t2007 = 0.8e1 / 0.45e2 * t1174
  t2009 = 0.4e1 / 0.15e2 * t1152 * t1726
  t2010 = t1 * t334
  t2014 = 0.4e1 / 0.15e2 * t481 * t2010 * t404 * t63
  t2016 = t386 * t1733 * t368
  t2018 = 0.4e1 / 0.15e2 * t2016 * t484
  t2020 = 0.2e1 / 0.15e2 * t444 * t1721
  t2022 = t47 * t1703
  t2025 = t14 * t1042 * t1981
  t2028 = t14 * t435 * t1975
  t2030 = t4 * t997
  t2031 = t437 * t63
  t2033 = t2030 * t435 * t2031
  t2036 = t56 * t1716
  t2044 = t22 * t1333
  t2048 = t1039 + 0.11997222222222222222222222222222222222222222222222e-1 * t1040 + 0.11997222222222222222222222222222222222222222222222e-1 * t2022 - 0.23994444444444444444444444444444444444444444444445e-1 * t2025 + 0.71983333333333333333333333333333333333333333333334e-1 * t2028 - 0.71983333333333333333333333333333333333333333333334e-1 * t2033 + t1062 + 0.44444444444444444444444444444444444444444444444445e-2 * t1063 + 0.44444444444444444444444444444444444444444444444445e-2 * t2036 - 0.22222222222222222222222222222222222222222222222222e-2 * t26 * t1067 * t1981 + 0.13333333333333333333333333333333333333333333333333e-1 * t26 * t471 * t1975 - 0.13333333333333333333333333333333333333333333333333e-1 * t2044 * t471 * t2031
  t2052 = 0.2e1 / 0.15e2 * t369 * t370 * t463 * t2048
  t2056 = t1772 * t631
  t2075 = -t2005 - t2006 + t2007 + t2009 - t2014 + t2018 - t2020 - t2052 + t1464 - t1467 + 0.2e1 / 0.9e1 * t1468 + t1475 / 0.3e1 + 0.60777777777777777777777777777777777777777777777777e-1 * t1479 + t1484 + t1490 - 0.2e1 / 0.45e2 * t2056 - (0.20e2 / 0.9e1 * t192 * t1652 * t131 + 0.8e1 / 0.3e1 * t622 * t63 * t321 + 0.20e2 / 0.9e1 * t193 * t1656 * t135 - 0.8e1 / 0.3e1 * t624 * t63 * t321) * t207 * t594 / 0.15e2 - 0.2e1 / 0.45e2 * t1493 + t1497
  t2078 = t47 * t1730
  t2081 = t14 * t1106 * t1961
  t2084 = t14 * t490 * t1955
  t2086 = t492 * t63
  t2088 = t2030 * t490 * t2086
  t2094 = 0.2e1 / 0.15e2 * t387 * (-t1314 - 0.62972222222222222222222222222222222222222222222223e-3 * t1104 - 0.62972222222222222222222222222222222222222222222223e-3 * t2078 + 0.12594444444444444444444444444444444444444444444445e-2 * t2081 - 0.37783333333333333333333333333333333333333333333334e-2 * t2084 - 0.37783333333333333333333333333333333333333333333334e-2 * t2088) * t368 * t405
  t2104 = 0.2e1 / 0.15e2 * t357 * (-t1267 - 0.62972222222222222222222222222222222222222222222223e-3 * t1040 - 0.62972222222222222222222222222222222222222222222223e-3 * t2022 + 0.12594444444444444444444444444444444444444444444445e-2 * t2025 - 0.37783333333333333333333333333333333333333333333334e-2 * t2028 + 0.37783333333333333333333333333333333333333333333334e-2 * t2033) * t368 * t383
  t2105 = t1708 * t448
  t2106 = 0.4e1 / 0.45e2 * t2105
  t2107 = t1735 * t502
  t2108 = 0.4e1 / 0.45e2 * t2107
  t2109 = 0.8e1 / 0.135e3 * t1227
  t2110 = 0.8e1 / 0.135e3 * t1246
  t2117 = t56 * t1743
  t2128 = t1103 + 0.11997222222222222222222222222222222222222222222222e-1 * t1104 + 0.11997222222222222222222222222222222222222222222222e-1 * t2078 - 0.23994444444444444444444444444444444444444444444445e-1 * t2081 + 0.71983333333333333333333333333333333333333333333334e-1 * t2084 + 0.71983333333333333333333333333333333333333333333334e-1 * t2088 + t1125 + 0.44444444444444444444444444444444444444444444444445e-2 * t1126 + 0.44444444444444444444444444444444444444444444444445e-2 * t2117 - 0.22222222222222222222222222222222222222222222222222e-2 * t26 * t1130 * t1961 + 0.13333333333333333333333333333333333333333333333333e-1 * t26 * t523 * t1955 + 0.13333333333333333333333333333333333333333333333333e-1 * t2044 * t523 * t2086
  t2132 = 0.2e1 / 0.15e2 * t395 * t370 * t516 * t2128
  t2134 = 0.2e1 / 0.15e2 * t1735 * t529
  t2138 = 0.4e1 / 0.15e2 * t482 * t393 * t368 * t1726
  t2142 = 0.4e1 / 0.15e2 * t426 * t365 * t368 * t1699
  t2144 = 0.4e1 / 0.15e2 * t1083 * t1699
  t2146 = t356 * t1706 * t368
  t2148 = 0.4e1 / 0.15e2 * t2146 * t428
  t2150 = 0.2e1 / 0.15e2 * t1708 * t477
  t2152 = t395 * t447 * t1747
  t2153 = 0.4e1 / 0.45e2 * t2152
  t2155 = t481 * t447 * t1725
  t2156 = 0.8e1 / 0.45e2 * t2155
  t2158 = t369 * t447 * t1720
  t2159 = 0.4e1 / 0.45e2 * t2158
  t2161 = t425 * t447 * t1698
  t2162 = 0.8e1 / 0.45e2 * t2161
  t2166 = 0.4e1 / 0.15e2 * t425 * t2010 * t382 * t63
  t2167 = t2094 + t2104 + t2106 + t2108 + t2109 + t2110 - t2132 - t2134 + t2138 + t2142 + t2144 + t2148 - t2150 - t2153 + t2156 - t2159 + t2162 + t2166
  t2169 = 0.2e1 / 0.15e2 * t499 * t1748
  t2170 = t1734 * t451
  t2172 = 0.4e1 / 0.45e2 * t2170 * t511
  t2173 = t515 * t1724
  t2177 = 0.4e1 / 0.15e2 * t1186 * t1216 * t2173 * t527
  t2182 = 0.4e1 / 0.15e2 * t452 * t1260 * t1166 * t1719 * t475
  t2183 = t1707 * t451
  t2185 = 0.4e1 / 0.45e2 * t2183 * t458
  t2187 = 0.4e1 / 0.45e2 * t1241 * t1712
  t2192 = 0.8e1 / 0.45e2 * t452 * t334 * t454 * t456 * t63
  t2197 = 0.4e1 / 0.15e2 * t1193 * t1260 * t462 * t1719 * t426
  t2198 = t462 * t1697
  t2202 = 0.4e1 / 0.15e2 * t1193 * t1260 * t2198 * t475
  t2204 = t505 * t1225 * t1738
  t2205 = 0.8e1 / 0.135e3 * t2204
  t2207 = t452 * t1244 * t1711
  t2208 = 0.8e1 / 0.135e3 * t2207
  t2210 = 0.4e1 / 0.45e2 * t1222 * t1739
  t2215 = 0.8e1 / 0.45e2 * t505 * t334 * t507 * t509 * t63
  t2220 = 0.4e1 / 0.15e2 * t1186 * t1216 * t515 * t1746 * t482
  t2225 = 0.4e1 / 0.15e2 * t505 * t1216 * t1091 * t1746 * t527
  t2226 = 0.4e1 / 0.45e2 * t1281
  t2227 = 0.4e1 / 0.45e2 * t1300
  t2228 = -t2169 + t2172 - t2177 + t2182 + t2185 + t2187 + t2192 - t2197 - t2202 + t2205 + t2208 + t2210 - t2215 - t2220 + t2225 + t2226 - t1286 - t1294 + t2227
  t2237 = t308 * t335 * t1780
  t2239 = t1823 - t1826 + t778 - t784 - t787 - t793 + t800 + t822 - t833 - t841 - t1827 + t846 + t904
  t2241 = t1661 * t1 * t184
  t2242 = 0.18311555036753159941307229983139571945136646663793e-3 * t2241
  t2243 = t125 * t1662
  t2244 = 0.4e1 * t2243
  t2245 = t69 * t1662
  t2246 = 0.4e1 * t2245
  t2247 = -t906 - t1828 - t1830 + t1832 + t1834 + t942 - t1835 - t883 + t949 + t964 - t2242 - t2244 + t2246
  t2248 = t2239 + t2247
  t2252 = -t1437 + 0.26314866163830089978458002229396252612500000000000e0 * t1438 + t1441 + 0.26314866163830089978458002229396252612500000000000e0 * t1917 - 0.26314866163830089978458002229396252612500000000000e0 * t305 * t1919 * t558 - 0.26314866163830089978458002229396252612500000000000e0 * t1924 - 0.26314866163830089978458002229396252612500000000000e0 * t1446 - t1450 - t1454 + 0.63335044683271196147628012990392428933010869805128e-2 * t1457 + 0.63335044683271196147628012990392428933010869805128e-2 * t1930 - 0.38001026809962717688576807794235457359806521883077e-2 * t353 * t54 * (t2004 + t2075 + t2167 + t2228) * jnp.pi + t1520 - 0.56945186695483624893780150000000000000000000000000e0 * t1522 - 0.56945186695483624893780150000000000000000000000000e0 * t2237 + 0.42708890021612718670335112500000000000000000000000e0 * t308 * t11 * t2248
  t2257 = t299 * t1693 * t316
  t2262 = t1694 * t340
  t2266 = t343 * t1693 * t311 * t348
  t2273 = t353 * t355 * t1754 * t420
  t2276 = t1751 * t414
  t2278 = 0.4e1 / 0.3e1 * t1027 + t1035 + 0.4e1 / 0.3e1 * t2276 + t1936 + t1941 + t1945 + t1949 - t1953 - t1958 + t1964 - t1969 - t1973 - t1978 + t1984 - t1989 + t2003 - t2005
  t2282 = t1751 * t545
  t2285 = -t2006 + t2007 + t2009 - t2014 + t2018 - t2020 - t2052 + 0.4e1 / 0.3e1 * t1919 * t409 * t415 + 0.4e1 / 0.3e1 * t2282 + t2094 + t2104 + t2106 + t2108 + 0.4e1 / 0.3e1 * t1200 + t1203 + t2109 + t2110 - t2132
  t2287 = -t2134 + t2138 + t2142 + t2144 + t2148 - t2150 - t2153 + t2156 - t2159 + t2162 + t2166 - t2169 + t2172 - t2177 + t2182 + t2185 + t2187
  t2290 = t1693 * t1 * t43 * t538
  t2293 = t2192 - t2197 - t2202 + t2205 + t2208 + t2210 - t2215 - t2220 + t2225 + 0.34444444444444444444444444444444444444444444444444e-1 * t2290 + t1280 + t2226 - t1286 - t1294 + t2227 + 0.34444444444444444444444444444444444444444444444444e-1 * t1304 + t1308 + t1313
  t2300 = -t970 + 0.17543244109220059985638668152930835075000000000000e0 * t972 + t975 + t979 + 0.17543244109220059985638668152930835075000000000000e0 * t2257 - 0.17543244109220059985638668152930835075000000000000e0 * t319 * t1919 * t316 - 0.17543244109220059985638668152930835075000000000000e0 * t2262 - 0.10999614056480977610995444931887633592025000000000e-1 * t2266 - 0.17543244109220059985638668152930835075000000000000e0 * t987 - t1004 - t1008 - 0.10999614056480977610995444931887633592025000000000e-1 * t991 - t1015 - t1019 + 0.50668035746616956918102410392313943146408695844103e-2 * t1022 + 0.50668035746616956918102410392313943146408695844103e-2 * t2273 - 0.30400821447970174150861446235388365887845217506462e-2 * t353 * t54 * (t2278 + t2285 + t2287 + t2293) * t420
  t2304 = t353 * t707 * t1780 * t709
  t2316 = t353 * t355 * t1693 * t684
  t2323 = t353 * t1790 * t693
  t2327 = t697 * t1780
  t2331 = -t1394 + 0.16889345248872318972700803464104647715469565281367e-1 * t1397 + t1401 + 0.16889345248872318972700803464104647715469565281367e-1 * t2316 - 0.10133607149323391383620482078462788629281739168820e-1 * t353 * t54 * t1919 * t684 - 0.10133607149323391383620482078462788629281739168820e-1 * t2323 - 0.10133607149323391383620482078462788629281739168820e-1 * t1407 - t1426 + t1429 - 0.10525946465532035991383200891758501045000000000000e1 * t1430 - 0.10525946465532035991383200891758501045000000000000e1 * t2327 + 0.52629732327660179956916004458792505225000000000000e0 * t700 * t2248
  t2334 = t1690 * t1618 + 0.6e1 * t1620 * t239 * t1842 * t248 + t252 * (0.2e1 * t1599 * t1687 * t288 - t1594 * t1687 + t1892 * t237 - t1894 * t288 - t282 * t1911) * t294 + t2252 * t656 + t1384 - 0.50830173461006131180240338105569347764477203670804e-2 * t1386 - t1390 + t2300 * t223 - 0.54045904796391420712642571085134872689502608900376e-1 * t2304 + 0.20267214298646782767240964156925577258563478337641e-1 * t353 * t355 * t2248 * t709 + 0.3e1 * t200 * t242 * t1865 + t2331 * t704 + 0.11259563499248212648467202309403098476979710187578e-1 * t1353
  t2338 = t352 * t658 * t1693 * t663
  t2344 = t1787 * t672
  t2347 = t200 * t1689
  t2352 = t677 * t1693 * t680
  t2354 = t293 * t1842
  t2357 = t1356 - 0.67557380995489275890803213856418590861878261125470e-2 * t1361 - t1337 - t1340 - t1350 + 0.11259563499248212648467202309403098476979710187578e-1 * t2338 - 0.67557380995489275890803213856418590861878261125470e-2 * t352 * t55 * t1919 * t663 - 0.67557380995489275890803213856418590861878261125470e-2 * t2344 - 0.54045904796391420712642571085134872689502608900376e-1 * t1372 + t1379 + 0.3e1 * t2347 * t1626 - t1690 * t1633 - 0.50830173461006131180240338105569347764477203670804e-2 * t2352 + 0.3e1 * t1624 * t2354
  t2361 = -t1830 + t1832 + t1834 + t942 - t1835 - t883 + t949 - 0.41076328840066666666666666666666666666666666666668e0 * t1838 - t960 + t964 - (t2334 + t2357) * t724 - t2242 - t2244 + t2246 + t1644 - 0.41076328840066666666666666666666666666666666666668e0 * t1647
  d12 = t35 + t62 - t127 + t142 + t179 + t648 - t186 - t191 - t725 - t769 + t1663 + t1665 - t1803 + t7 * (t1829 + t2361)
  t2367 = 0.11696446794910408141662685001236899248561775660981e1 * t1825
  t2368 = -t2367 + t778 - t784 + t787 + t790 - t793 + t800 + t822 - t833 - t841 + t904 - t906 - t935
  t2369 = 0.2e1 * t1834
  t2371 = t1652 ** 2
  t2374 = t129 + t912
  t2375 = 0.2e1 * t2374
  t2379 = f.my_piecewise3(t73, 0, 0.4e1 / 0.9e1 * t908 * t2371 + 0.4e1 / 0.3e1 * t76 * t2375)
  t2380 = t1656 ** 2
  t2383 = -t2375
  t2387 = f.my_piecewise3(t80, 0, 0.4e1 / 0.9e1 * t919 * t2380 + 0.4e1 / 0.3e1 * t81 * t2383)
  t2389 = (t2379 + t2387) * t88
  t2391 = t128 * t2389 * t118
  t2393 = 0.19751789702565206228825776161588751761046270558698e-1 * t2389 * t116
  t2394 = 0.36623110073506319882614459966279143890273293327586e-3 * t2241
  t2395 = 0.8e1 * t2243
  t2396 = 0.8e1 * t2245
  t2397 = -t841 - t784 + t942 + t2393 + t778 + t790 - t793 + t822 + t949 - t833 - t2367
  t2398 = t964 + t904 + t2391 + t2369 + t800 - t883 - t2394 - t2396 - t935 + t787 - t2395 - t906
  t2399 = t2397 + t2398
  t2413 = -t1545 * t2371 / 0.9e1 + t243 * t2375 / 0.3e1 - t1550 * t2380 / 0.9e1 + t245 * t2383 / 0.3e1
  t2420 = t1669 ** 2
  t2424 = 0.97434166666666666666666666666666666666666666666666e0 * t1848
  t2427 = 0.58460500000000000000000000000000000000000000000000e1 * t201 * t227 * t2420
  t2430 = 0.29230250000000000000000000000000000000000000000000e1 * t201 * t218 * t2413
  t2433 = t13 * t274 * t2420
  t2437 = t13 * t227 * t2413
  t2447 = -t1532 + t2424 + t1540 + t2427 - t2430 + t1562 + t1871 / 0.3e1 + 0.3e1 / 0.2e1 * t264 * t2433 - t264 * t2437 / 0.2e1 + t1577 + 0.14690400000000000000000000000000000000000000000000e1 * t1883 + t1583 + 0.58761600000000000000000000000000000000000000000000e1 * t225 * t1585 * t2420 - 0.14690400000000000000000000000000000000000000000000e1 * t225 * t274 * t2413
  t2451 = t1687 ** 2
  t2466 = -t980 - t981 - t982
  t2475 = 0.4e1 / 0.45e2 * t452 * t455 * t456 * t2375
  t2479 = 0.8e1 / 0.45e2 * t452 * t455 * t1211 * t2371
  t2483 = 0.8e1 / 0.45e2 * t505 * t508 * t1206 * t2380
  t2485 = 0.8e1 / 0.45e2 * t2170 * t1739
  t2489 = 0.4e1 / 0.45e2 * t505 * t508 * t509 * t2383
  t2493 = 0.4e1 / 0.27e2 * t505 * t1235 * t1236 * t2380
  t2497 = 0.4e1 / 0.27e2 * t452 * t1254 * t1255 * t2371
  t2501 = 0.8e1 / 0.15e2 * t1186 * t1216 * t2173 * t1746
  t2505 = 0.8e1 / 0.15e2 * t1193 * t1260 * t2198 * t1719
  t2507 = 0.8e1 / 0.45e2 * t2183 * t1712
  t2511 = 0.16e2 / 0.45e2 * t1193 * t1194 * t1937 * t1652
  t2512 = t2475 - t2479 - t2483 + t2485 + t2489 + t2493 + t2497 - t2501 - t2505 + t2507 + t1461 + t2511
  t2516 = 0.8e1 / 0.45e2 * t452 * t1181 * t1702 * t1719
  t2520 = 0.16e2 / 0.45e2 * t1186 * t1187 * t1932 * t1656
  t2524 = 0.8e1 / 0.45e2 * t505 * t1176 * t1729 * t1746
  t2545 = -t2516 + t2520 - t2524 + t2466 * t576 * t580 * t585 / 0.3e1 + 0.2e1 / 0.3e1 * t1995 + 0.12155555555555555555555555555555555555555555555555e0 * t1999 + 0.4e1 / 0.9e1 * t2001 + t1464 - t1467 + t1484 + t1490 - 0.4e1 / 0.45e2 * t2056 - (0.20e2 / 0.9e1 * t192 * t2371 + 0.4e1 / 0.3e1 * t622 * t2375 + 0.20e2 / 0.9e1 * t193 * t2380 + 0.4e1 / 0.3e1 * t624 * t2383) * t207 * t594 / 0.15e2
  t2548 = 0.4e1 / 0.15e2 * t1708 * t1721
  t2550 = t1108 * t2380
  t2552 = t14 * t1106 * t2550
  t2554 = t1114 * t2380
  t2556 = t14 * t490 * t2554
  t2558 = t492 * t2383
  t2560 = t14 * t490 * t2558
  t2576 = 0.2e1 / 0.15e2 * t395 * t370 * t516 * (t1103 + 0.23994444444444444444444444444444444444444444444444e-1 * t2078 - 0.23994444444444444444444444444444444444444444444445e-1 * t2552 + 0.71983333333333333333333333333333333333333333333334e-1 * t2556 - 0.35991666666666666666666666666666666666666666666667e-1 * t2560 + t1125 + 0.88888888888888888888888888888888888888888888888890e-2 * t2117 - 0.22222222222222222222222222222222222222222222222222e-2 * t26 * t1130 * t2550 + 0.13333333333333333333333333333333333333333333333333e-1 * t26 * t523 * t2554 - 0.66666666666666666666666666666666666666666666666667e-2 * t26 * t523 * t2558)
  t2577 = t1746 ** 2
  t2581 = 0.4e1 / 0.15e2 * t395 * t370 * t1092 * t2577
  t2582 = t1719 ** 2
  t2586 = 0.4e1 / 0.15e2 * t369 * t370 * t1167 * t2582
  t2588 = t1044 * t2371
  t2590 = t14 * t1042 * t2588
  t2592 = t1050 * t2371
  t2594 = t14 * t435 * t2592
  t2596 = t437 * t2375
  t2598 = t14 * t435 * t2596
  t2614 = 0.2e1 / 0.15e2 * t369 * t370 * t463 * (t1039 + 0.23994444444444444444444444444444444444444444444444e-1 * t2022 - 0.23994444444444444444444444444444444444444444444445e-1 * t2590 + 0.71983333333333333333333333333333333333333333333334e-1 * t2594 - 0.35991666666666666666666666666666666666666666666667e-1 * t2598 + t1062 + 0.88888888888888888888888888888888888888888888888890e-2 * t2036 - 0.22222222222222222222222222222222222222222222222222e-2 * t26 * t1067 * t2588 + 0.13333333333333333333333333333333333333333333333333e-1 * t26 * t471 * t2592 - 0.66666666666666666666666666666666666666666666666667e-2 * t26 * t471 * t2596)
  t2616 = 0.8e1 / 0.15e2 * t2146 * t1699
  t2620 = 0.4e1 / 0.15e2 * t425 * t370 * t382 * t2374
  t2622 = 0.8e1 / 0.15e2 * t2016 * t1726
  t2627 = -0.4e1 / 0.15e2 * t481 * t370 * t404 * t2374
  t2629 = 0.4e1 / 0.15e2 * t1735 * t1748
  t2630 = 0.8e1 / 0.45e2 * t2105
  t2631 = t1497 - t2548 - t2576 + t2581 + t2586 - t2614 + t2616 + t2620 + t2622 + t2627 - t2629 + t2630
  t2632 = 0.8e1 / 0.45e2 * t2107
  t2633 = 0.8e1 / 0.45e2 * t2152
  t2634 = 0.16e2 / 0.45e2 * t2155
  t2635 = 0.8e1 / 0.45e2 * t2158
  t2636 = 0.16e2 / 0.45e2 * t2161
  t2637 = 0.16e2 / 0.135e3 * t2204
  t2638 = 0.16e2 / 0.135e3 * t2207
  t2639 = t1697 ** 2
  t2643 = 0.4e1 / 0.15e2 * t2639 * t365 * t368 * t383
  t2644 = t1724 ** 2
  t2648 = 0.4e1 / 0.15e2 * t2644 * t393 * t368 * t405
  t2657 = 0.2e1 / 0.15e2 * t357 * (-t1267 - 0.12594444444444444444444444444444444444444444444445e-2 * t2022 + 0.12594444444444444444444444444444444444444444444445e-2 * t2590 - 0.37783333333333333333333333333333333333333333333334e-2 * t2594 + 0.18891666666666666666666666666666666666666666666667e-2 * t2598) * t368 * t383
  t2666 = 0.2e1 / 0.15e2 * t387 * (-t1314 - 0.12594444444444444444444444444444444444444444444445e-2 * t2078 + 0.12594444444444444444444444444444444444444444444445e-2 * t2552 - 0.37783333333333333333333333333333333333333333333334e-2 * t2556 + 0.18891666666666666666666666666666666666666666666667e-2 * t2560) * t368 * t405
  t2667 = t2632 - t2633 + t2634 - t2635 + t2636 + t2637 + t2638 + t2643 + t2648 + t2657 + t2666 - t1286 - t1294
  t2678 = -t1437 + 0.52629732327660179956916004458792505225000000000000e0 * t1917 + t1441 - 0.26314866163830089978458002229396252612500000000000e0 * t305 * t2466 * t558 - 0.52629732327660179956916004458792505225000000000000e0 * t1924 - t1450 - t1454 + 0.12667008936654239229525602598078485786602173961026e-1 * t1930 - 0.38001026809962717688576807794235457359806521883077e-2 * t353 * t54 * (t2512 + t2545 + t2631 + t2667) * jnp.pi + t1520 - 0.11389037339096724978756030000000000000000000000000e1 * t2237 + 0.42708890021612718670335112500000000000000000000000e0 * t308 * t11 * t2399
  t2680 = 0.20267214298646782767240964156925577258563478337641e-1 * t353 * t355 * t2399 * t709 - 0.10809180959278284142528514217026974537900521780075e0 * t2304 + 0.3e1 * t200 * t242 * t2413 - t1337 + t1690 * t292 * t1687 * t241 + 0.6e1 * t1620 * t242 * t2420 + t252 * (t2447 * t237 - 0.2e1 * t1894 * t1687 + 0.2e1 * t1599 * t2451 - t282 * (-t1532 + t2424 + t1540 + t2427 - t2430 + t1605 + 0.11495033333333333333333333333333333333333333333333e1 * t1901 + 0.51727650000000000000000000000000000000000000000000e1 * t232 * t2433 - 0.17242550000000000000000000000000000000000000000000e1 * t232 * t2437)) * t294 + t1384 - 0.10166034692201226236048067621113869552895440734161e-1 * t2352 - t1390 + t2678 * t656
  t2688 = t1035 + t2475 - t2479 - t2483 + t2485 + t2489 + t2493 + t2497 - t2501 - t2505 + t2507
  t2694 = 0.8e1 / 0.3e1 * t2276 + t2511 - t2516 + t2520 - t2524 + 0.8e1 / 0.3e1 * t2282 + 0.4e1 / 0.3e1 * t2466 * t409 * t415 - t2548 - t2576 + t2581 + t2586 - t2614
  t2696 = t2616 + t2620 + t2622 + t2627 - t2629 + t2630 + t2632 + t1203 - t2633 + t2634 - t2635 + t2636
  t2698 = t2637 + t2638 + 0.68888888888888888888888888888888888888888888888888e-1 * t2290 + t2643 + t2648 + t2657 + t2666 + t1280 - t1286 - t1294 + t1308 + t1313
  t2705 = -t970 + 0.35086488218440119971277336305861670150000000000000e0 * t2257 + t975 + t979 - 0.17543244109220059985638668152930835075000000000000e0 * t319 * t2466 * t316 - 0.35086488218440119971277336305861670150000000000000e0 * t2262 - 0.21999228112961955221990889863775267184050000000000e-1 * t2266 - t1004 - t1008 - t1015 - t1019 + 0.10133607149323391383620482078462788629281739168821e-1 * t2273 - 0.30400821447970174150861446235388365887845217506462e-2 * t353 * t54 * (t2688 + t2694 + t2696 + t2698) * t420
  t2729 = t2705 * t223 + 0.22519126998496425296934404618806196953959420375156e-1 * t2338 + t1356 - 0.67557380995489275890803213856418590861878261125470e-2 * t352 * t55 * t2466 * t663 - 0.13511476199097855178160642771283718172375652225094e-1 * t2344 - t1340 - t1350 + (-t1394 + 0.33778690497744637945401606928209295430939130562734e-1 * t2316 + t1401 - 0.10133607149323391383620482078462788629281739168820e-1 * t353 * t54 * t2466 * t684 - 0.20267214298646782767240964156925577258563478337640e-1 * t2323 - t1426 + t1429 - 0.21051892931064071982766401783517002090000000000000e1 * t2327 + 0.52629732327660179956916004458792505225000000000000e0 * t700 * t2399) * t704 + 0.6e1 * t2347 * t2354 + t1379 - t1690 * t1631 * t241 * t1683
  t2732 = t2369 + t942 - t883 + t949 - 0.82152657680133333333333333333333333333333333333336e0 * t1838 - t960 + t964 + t2391 + t2393 - t2394 - t2395 - t2396 - (t2680 + t2729) * t724 + t1644
  d22 = t35 + t62 - t121 - t127 + 0.2e1 * t1663 + t179 + 0.39503579405130412457651552323177503522092541117396e-1 * t1664 - t186 - t191 - 0.2e1 * t1803 - t769 + t7 * (t2368 + t2732)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t3 = jnp.pi ** 2
  t4 = 0.1e1 / t3
  t5 = 0.1e1 / jnp.pi
  t6 = t5 ** (0.1e1 / 0.3e1)
  t7 = t6 ** 2
  t9 = t2 * t7 * t4
  t10 = 4 ** (0.1e1 / 0.3e1)
  t11 = r0 + r1
  t12 = t11 ** 2
  t13 = t12 * t11
  t14 = t11 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = 0.1e1 / t15 / t13
  t18 = t10 * t17
  t19 = r0 - r1
  t20 = t19 ** 2
  t21 = 0.1e1 / t12
  t23 = -t20 * t21 + 0.1e1
  t25 = t9 * t18 * t23
  t26 = t1 * t6
  t27 = t10 ** 2
  t28 = 0.1e1 / t14
  t29 = t27 * t28
  t30 = t26 * t29
  t32 = t2 * t7
  t33 = 0.1e1 / t15
  t34 = t10 * t33
  t35 = t32 * t34
  t37 = 0.1e1 / t11
  t38 = t5 * t37
  t40 = t6 * t5
  t41 = t1 * t40
  t43 = 0.1e1 / t14 / t11
  t44 = t27 * t43
  t47 = 0.1e1 + 0.51750000000000000000000000000000000000000000000000e-2 * t30 + 0.20482500000000000000000000000000000000000000000000e-1 * t35 - 0.95775000000000000000000000000000000000000000000000e-2 * t38 + 0.34856250000000000000000000000000000000000000000000e-3 * t41 * t44
  t49 = jnp.exp(-0.18810000000000000000000000000000000000000000000000e0 * t30)
  t50 = t47 * t49
  t51 = jnp.sqrt(0.2e1)
  t52 = jnp.sqrt(jnp.pi)
  t53 = t51 * t52
  t54 = f.p.cam_omega ** 2
  t55 = t54 ** 2
  t56 = t55 * f.p.cam_omega
  t57 = t53 * t56
  t58 = t50 * t57
  t62 = 0.1e1 / t15 / t11
  t63 = t10 * t62
  t65 = t9 * t63 * t23
  t67 = 0.1e1 / t14 / t12
  t68 = t27 * t67
  t69 = t26 * t68
  t72 = 0.1e1 / t15 / t12
  t73 = t10 * t72
  t74 = t32 * t73
  t76 = 0.1e1 / t13
  t77 = t5 * t76
  t80 = 0.1e1 / t14 / t13
  t81 = t27 * t80
  t84 = 0.23000000000000000000000000000000000000000000000000e-2 * t69 + 0.22758333333333333333333333333333333333333333333333e-1 * t74 - 0.19155000000000000000000000000000000000000000000000e-1 * t77 + 0.10844166666666666666666666666666666666666666666667e-2 * t41 * t81
  t85 = t84 * t49
  t86 = t85 * t57
  t90 = 0.1e1 / t52 / t3
  t91 = t12 ** 2
  t93 = 0.1e1 / t14 / t91
  t94 = t90 * t93
  t95 = t23 * t47
  t96 = t95 * t1
  t98 = t6 * t27
  t100 = t49 * t51 * t56
  t101 = t98 * t100
  t104 = t19 * t21
  t107 = 0.2e1 * t20 * t76 - 0.2e1 * t104
  t109 = t9 * t73 * t107
  t113 = t9 * t73 * t23
  t114 = t26 * t44
  t116 = t32 * t63
  t118 = t5 * t21
  t122 = -0.17250000000000000000000000000000000000000000000000e-2 * t114 - 0.13655000000000000000000000000000000000000000000000e-1 * t116 + 0.95775000000000000000000000000000000000000000000000e-2 * t118 - 0.46475000000000000000000000000000000000000000000000e-3 * t41 * t68
  t123 = t122 * t49
  t124 = t123 * t57
  t128 = t19 * t76
  t130 = 0.1e1 / t91
  t131 = t20 * t130
  t133 = -0.2e1 * t21 + 0.8e1 * t128 - 0.6e1 * t131
  t135 = t9 * t63 * t133
  t139 = t9 * t63 * t107
  t142 = t9 * t10
  t143 = t19 * t37
  t144 = 0.1e1 + t143
  t145 = t144 <= f.p.zeta_threshold
  t146 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t147 = t146 * f.p.zeta_threshold
  t148 = t144 ** (0.1e1 / 0.3e1)
  t149 = t148 * t144
  t150 = f.my_piecewise3(t145, t147, t149)
  t151 = 0.1e1 - t143
  t152 = t151 <= f.p.zeta_threshold
  t153 = t151 ** (0.1e1 / 0.3e1)
  t154 = t153 * t151
  t155 = f.my_piecewise3(t152, t147, t154)
  t157 = 2 ** (0.1e1 / 0.3e1)
  t160 = 0.1e1 / (0.2e1 * t157 - 0.2e1)
  t161 = (t150 + t155 - 0.2e1) * t160
  t163 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t30
  t164 = jnp.sqrt(t30)
  t167 = t30 ** 0.15e1
  t170 = 0.70594500000000000000000000000000000000000000000000e1 * t164 + 0.15494250000000000000000000000000000000000000000000e1 * t30 + 0.42077500000000000000000000000000000000000000000000e0 * t167 + 0.15629250000000000000000000000000000000000000000000e0 * t35
  t173 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t170
  t174 = jnp.log(t173)
  t178 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t30
  t183 = 0.37978500000000000000000000000000000000000000000000e1 * t164 + 0.89690000000000000000000000000000000000000000000000e0 * t30 + 0.20477500000000000000000000000000000000000000000000e0 * t167 + 0.12323500000000000000000000000000000000000000000000e0 * t35
  t186 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t183
  t187 = jnp.log(t186)
  t189 = 0.62182e-1 * t178 * t187
  t191 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t30
  t196 = 0.51785000000000000000000000000000000000000000000000e1 * t164 + 0.90577500000000000000000000000000000000000000000000e0 * t30 + 0.11003250000000000000000000000000000000000000000000e0 * t167 + 0.12417750000000000000000000000000000000000000000000e0 * t35
  t199 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t196
  t200 = jnp.log(t199)
  t201 = t191 * t200
  t203 = -0.31090e-1 * t163 * t174 + t189 - 0.19751789702565206228825776161588751761046270558698e-1 * t201
  t204 = t161 * t203
  t205 = t131 * t204
  t207 = t20 * t19
  t208 = t91 * t11
  t209 = 0.1e1 / t208
  t210 = t207 * t209
  t211 = t210 * t204
  t214 = t26 * t68 * t187
  t215 = 0.14764770444444444444444444444444444444444444444444e-2 * t214
  t216 = t148 ** 2
  t217 = 0.1e1 / t216
  t218 = t37 - t104
  t219 = t218 ** 2
  t222 = -t21 + t128
  t223 = 0.2e1 * t222
  t227 = f.my_piecewise3(t145, 0, 0.4e1 / 0.9e1 * t217 * t219 + 0.4e1 / 0.3e1 * t148 * t223)
  t228 = t153 ** 2
  t229 = 0.1e1 / t228
  t230 = -t218
  t231 = t230 ** 2
  t234 = -t223
  t238 = f.my_piecewise3(t152, 0, 0.4e1 / 0.9e1 * t229 * t231 + 0.4e1 / 0.3e1 * t153 * t234)
  t240 = (t227 + t238) * t160
  t241 = t240 * t201
  t243 = t161 * t26
  t244 = t196 ** 2
  t245 = 0.1e1 / t244
  t246 = 0.1e1 / t164
  t247 = t246 * t1
  t248 = t98 * t43
  t249 = t247 * t248
  t252 = t30 ** 0.5e0
  t253 = t252 * t1
  t254 = t253 * t248
  t257 = -0.86308333333333333333333333333333333333333333333334e0 * t249 - 0.30192500000000000000000000000000000000000000000000e0 * t114 - 0.55016250000000000000000000000000000000000000000000e-1 * t254 - 0.82785000000000000000000000000000000000000000000000e-1 * t116
  t259 = 0.1e1 / t199
  t260 = t245 * t257 * t259
  t261 = t44 * t260
  t262 = t243 * t261
  t264 = t161 * t191
  t265 = t244 ** 2
  t266 = 0.1e1 / t265
  t267 = t257 ** 2
  t269 = t199 ** 2
  t270 = 0.1e1 / t269
  t271 = t266 * t267 * t270
  t272 = t264 * t271
  t276 = f.my_piecewise3(t145, 0, 0.4e1 / 0.3e1 * t148 * t218)
  t279 = f.my_piecewise3(t152, 0, 0.4e1 / 0.3e1 * t153 * t230)
  t281 = (t276 + t279) * t160
  t282 = t281 * t191
  t283 = t282 * t260
  t285 = t164 * t30
  t286 = 0.1e1 / t285
  t287 = t286 * t2
  t288 = t7 * t10
  t289 = t288 * t72
  t290 = t287 * t289
  t292 = t98 * t67
  t293 = t247 * t292
  t296 = t30 ** (-0.5e0)
  t297 = t296 * t2
  t298 = t297 * t289
  t300 = t253 * t292
  t303 = -0.57538888888888888888888888888888888888888888888889e0 * t290 + 0.11507777777777777777777777777777777777777777777778e1 * t293 + 0.40256666666666666666666666666666666666666666666667e0 * t69 + 0.36677500000000000000000000000000000000000000000000e-1 * t298 + 0.73355000000000000000000000000000000000000000000000e-1 * t300 + 0.13797500000000000000000000000000000000000000000000e0 * t74
  t305 = t245 * t303 * t259
  t306 = t264 * t305
  t308 = t281 * t1
  t310 = t98 * t43 * t200
  t311 = t308 * t310
  t313 = t183 ** 2
  t314 = 0.1e1 / t313
  t315 = t178 * t314
  t322 = -0.42198333333333333333333333333333333333333333333333e0 * t290 + 0.84396666666666666666666666666666666666666666666666e0 * t293 + 0.39862222222222222222222222222222222222222222222223e0 * t69 + 0.68258333333333333333333333333333333333333333333333e-1 * t298 + 0.13651666666666666666666666666666666666666666666667e0 * t300 + 0.13692777777777777777777777777777777777777777777778e0 * t74
  t323 = 0.1e1 / t186
  t324 = t322 * t323
  t325 = t315 * t324
  t326 = 0.10000000000000000000000000000000000000000000000000e1 * t325
  t327 = t313 ** 2
  t328 = 0.1e1 / t327
  t329 = t178 * t328
  t334 = -0.63297500000000000000000000000000000000000000000000e0 * t249 - 0.29896666666666666666666666666666666666666666666667e0 * t114 - 0.10238750000000000000000000000000000000000000000000e0 * t254 - 0.82156666666666666666666666666666666666666666666667e-1 * t116
  t335 = t334 ** 2
  t336 = t186 ** 2
  t337 = 0.1e1 / t336
  t338 = t335 * t337
  t339 = t329 * t338
  t340 = 0.16081824322151104821330931780901225435013347914188e2 * t339
  t341 = 0.12e2 * t205 - 0.32e2 * t211 - t215 + 0.19751789702565206228825776161588751761046270558698e-1 * t241 + 0.10843580882781524214666447553230042011687479519034e-1 * t262 - 0.17315755899375863299672358916972966258900005419821e2 * t272 - 0.11696446794910408141662685001236899248561775660981e1 * t283 - 0.58482233974552040708313425006184496242808878304903e0 * t306 - 0.36623110073506319882614459966279143890273293327586e-3 * t311 + t326 + t340
  t342 = t20 ** 2
  t343 = t342 * t130
  t347 = t26 * t27
  t348 = t170 ** 2
  t349 = 0.1e1 / t348
  t350 = t43 * t349
  t355 = -0.11765750000000000000000000000000000000000000000000e1 * t249 - 0.51647500000000000000000000000000000000000000000000e0 * t114 - 0.21038750000000000000000000000000000000000000000000e0 * t254 - 0.10419500000000000000000000000000000000000000000000e0 * t116
  t356 = 0.1e1 / t173
  t357 = t355 * t356
  t362 = 0.1e1 / t348 / t170
  t363 = t163 * t362
  t364 = t355 ** 2
  t365 = t364 * t356
  t368 = t163 * t349
  t375 = -0.78438333333333333333333333333333333333333333333333e0 * t290 + 0.15687666666666666666666666666666666666666666666667e1 * t293 + 0.68863333333333333333333333333333333333333333333333e0 * t69 + 0.14025833333333333333333333333333333333333333333333e0 * t298 + 0.28051666666666666666666666666666666666666666666667e0 * t300 + 0.17365833333333333333333333333333333333333333333333e0 * t74
  t376 = t375 * t356
  t379 = t348 ** 2
  t380 = 0.1e1 / t379
  t381 = t163 * t380
  t382 = t173 ** 2
  t383 = 0.1e1 / t382
  t384 = t364 * t383
  t387 = t43 * t314
  t388 = t334 * t323
  t390 = t347 * t387 * t388
  t391 = 0.35616666666666666666666666666666666666666666666666e-1 * t390
  t393 = 0.1e1 / t313 / t183
  t394 = t178 * t393
  t395 = t335 * t323
  t396 = t394 * t395
  t397 = 0.20000000000000000000000000000000000000000000000000e1 * t396
  t401 = t43 * t245
  t402 = t257 * t259
  t407 = 0.1e1 / t244 / t196
  t408 = t191 * t407
  t409 = t267 * t259
  t412 = t191 * t245
  t413 = t303 * t259
  t416 = t191 * t266
  t417 = t267 * t270
  t420 = -0.70981924444444444444444444444444444444444444444442e-3 * t26 * t68 * t174 - 0.34246666666666666666666666666666666666666666666666e-1 * t347 * t350 * t357 - 0.20000000000000000000000000000000000000000000000000e1 * t363 * t365 + 0.99999999999999999999999999999999999999999999999999e0 * t368 * t376 + 0.32164683177870697973624959794146027661627532968800e2 * t381 * t384 + t215 + t391 + t397 - t326 - t340 - 0.24415406715670879921742973310852762593515528885057e-3 * t26 * t68 * t200 - 0.10843580882781524214666447553230042011687479519034e-1 * t347 * t401 * t402 - 0.11696446794910408141662685001236899248561775660981e1 * t408 * t409 + 0.58482233974552040708313425006184496242808878304903e0 * t412 * t413 + 0.17315755899375863299672358916972966258900005419821e2 * t416 * t417
  t421 = t161 * t420
  t422 = t343 * t421
  t423 = t240 * t203
  t424 = t343 * t423
  t432 = 0.11073577833333333333333333333333333333333333333333e-2 * t26 * t44 * t187
  t434 = 0.10000000000000000000000000000000000000000000000000e1 * t315 * t388
  t440 = 0.53236443333333333333333333333333333333333333333332e-3 * t26 * t44 * t174 + 0.99999999999999999999999999999999999999999999999999e0 * t368 * t357 - t432 - t434 + 0.18311555036753159941307229983139571945136646663793e-3 * t26 * t44 * t200 + 0.58482233974552040708313425006184496242808878304903e0 * t412 * t402
  t441 = t281 * t440
  t442 = t343 * t441
  t444 = t342 * t209
  t445 = t281 * t203
  t446 = t444 * t445
  t448 = t161 * t440
  t449 = t444 * t448
  t451 = t207 * t130
  t452 = t451 * t445
  t454 = t451 * t448
  t457 = 0.1e1 / t91 / t12
  t458 = t342 * t457
  t459 = t458 * t204
  t462 = t407 * t267 * t259
  t463 = t264 * t462
  t465 = t161 * t1
  t467 = t98 * t67 * t200
  t468 = t465 * t467
  t470 = t422 + t424 + 0.2e1 * t442 - 0.8e1 * t446 - 0.8e1 * t449 + 0.8e1 * t452 + 0.8e1 * t454 - t397 + 0.20e2 * t459 + 0.11696446794910408141662685001236899248561775660981e1 * t463 - t391 + 0.24415406715670879921742973310852762593515528885057e-3 * t468
  t471 = t341 + t470
  t473 = t55 ** 2
  t489 = t432 + t434 + 0.4e1 * t451 * t204 - 0.4e1 * t444 * t204 + t343 * t445 + t343 * t448 + 0.19751789702565206228825776161588751761046270558698e-1 * t281 * t201 - 0.18311555036753159941307229983139571945136646663793e-3 * t465 * t310 - 0.58482233974552040708313425006184496242808878304903e0 * t264 * t260
  t495 = 0.1e1 / t15 / t91
  t499 = -t189 + t343 * t204 + 0.19751789702565206228825776161588751761046270558698e-1 * t161 * t201
  t504 = t90 * t130
  t505 = t504 * t23
  t506 = t51 * t56
  t507 = t50 * t506
  t510 = -0.30025502664661900395912539491741595938612560500208e-1 * t25 * t58 - 0.67557380995489275890803213856418590861878261125470e-2 * t65 * t86 - 0.31870518760050844250010691992191981048327206701594e-3 * t94 * t96 * t101 + 0.22519126998496425296934404618806196953959420375156e-1 * t109 * t58 + 0.22519126998496425296934404618806196953959420375156e-1 * t113 * t124 - 0.67557380995489275890803213856418590861878261125470e-2 * t135 * t58 - 0.13511476199097855178160642771283718172375652225094e-1 * t139 * t124 + 0.20267214298646782767240964156925577258563478337641e-1 * t142 * t72 * t471 * t473 - 0.10809180959278284142528514217026974537900521780075e0 * t142 * t17 * t489 * t473 + 0.19816831758676854261302276064549453319484289930138e0 * t142 * t495 * t499 * t473 + 0.23720747615136194550778824449265695623422695046375e-1 * t505 * t507
  t511 = t90 * t76
  t512 = t511 * t107
  t515 = t511 * t23
  t516 = t123 * t506
  t519 = t17 * t23
  t521 = t50 / 0.2e1 - 0.1e1 / 0.2e1
  t522 = t521 * jnp.pi
  t526 = t72 * t107
  t530 = t72 * t23
  t533 = t47 * t1 * t6
  t534 = t44 * t49
  t537 = t123 / 0.2e1 + 0.31350000000000000000000000000000000000000000000000e-1 * t533 * t534
  t538 = t537 * jnp.pi
  t542 = t62 * t133
  t546 = t62 * t107
  t550 = t62 * t23
  t553 = t122 * t1 * t6
  t556 = t68 * t49
  t560 = t47 * t2 * t7
  t561 = t73 * t49
  t564 = t85 / 0.2e1 + 0.62700000000000000000000000000000000000000000000000e-1 * t553 * t534 - 0.41800000000000000000000000000000000000000000000000e-1 * t533 * t556 + 0.78625800000000000000000000000000000000000000000000e-2 * t560 * t561
  t565 = t564 * jnp.pi
  t569 = t4 * t130
  t572 = t4 * t76
  t575 = t4 * t21
  t579 = t55 * t54
  t581 = t23 * t521
  t584 = t107 * t521
  t587 = t23 * t537
  t590 = t133 * t521
  t593 = t107 * t537
  t596 = t23 * t564
  t599 = t144 / 0.2e1
  t600 = t599 ** 2
  t601 = t28 * t157
  t602 = 0.1e1 / t144
  t603 = t602 ** (0.1e1 / 0.3e1)
  t605 = t347 * t601 * t603
  t607 = 0.1e1 - 0.56675000000000000000000000000000000000000000000000e-2 * t605
  t608 = t600 * t607
  t609 = 9 ** (0.1e1 / 0.3e1)
  t610 = t609 ** 2
  t611 = 0.1e1 / t40
  t612 = t610 * t611
  t613 = t608 * t612
  t614 = t1 * t15
  t615 = t603 ** 2
  t616 = 0.1e1 / t615
  t618 = t32 * t10
  t619 = t157 ** 2
  t620 = t33 * t619
  t624 = 0.1e1 + 0.10797500000000000000000000000000000000000000000000e0 * t605 + 0.10000000000000000000000000000000000000000000000000e-1 * t618 * t620 * t615
  t625 = 0.1e1 / t624
  t626 = t616 * t625
  t627 = t614 * t626
  t629 = 0.2e1 / 0.15e2 * t613 * t627
  t630 = t151 / 0.2e1
  t631 = t630 ** 2
  t632 = 0.1e1 / t151
  t633 = t632 ** (0.1e1 / 0.3e1)
  t635 = t347 * t601 * t633
  t637 = 0.1e1 - 0.56675000000000000000000000000000000000000000000000e-2 * t635
  t638 = t631 * t637
  t639 = t638 * t612
  t640 = t633 ** 2
  t641 = 0.1e1 / t640
  t646 = 0.1e1 + 0.10797500000000000000000000000000000000000000000000e0 * t635 + 0.10000000000000000000000000000000000000000000000000e-1 * t618 * t620 * t640
  t647 = 0.1e1 / t646
  t648 = t641 * t647
  t649 = t614 * t648
  t651 = 0.2e1 / 0.15e2 * t639 * t649
  t653 = jnp.exp(-0.13675000000000000000000000000000000000000000000000e0 * t30)
  t654 = t23 * t653
  t657 = -0.97000000000000000000000000000000000000000000000000e-1 * t30 + 0.16900000000000000000000000000000000000000000000000e0 * t35
  t658 = t654 * t657
  t660 = t1 / t7
  t662 = t660 * t27 * t15
  t665 = t144 ** 2
  t667 = t151 ** 2
  t671 = (t216 * t665 / 0.2e1 + t228 * t667 / 0.2e1) * t610
  t672 = t611 * t1
  t673 = t672 * t15
  t676 = t629 + t651 + t658 * t662 / 0.3e1 - t671 * t673 / 0.15e2
  t681 = t599 * t607
  t682 = t681 * t612
  t683 = t218 / 0.2e1
  t684 = t626 * t683
  t685 = t614 * t684
  t687 = 0.4e1 / 0.15e2 * t682 * t685
  t688 = t43 * t157
  t690 = t347 * t688 * t603
  t692 = t157 * t616
  t693 = 0.1e1 / t665
  t694 = t693 * t218
  t695 = t692 * t694
  t696 = t30 * t695
  t698 = 0.18891666666666666666666666666666666666666666666667e-2 * t690 + 0.18891666666666666666666666666666666666666666666667e-2 * t696
  t699 = t600 * t698
  t700 = t699 * t612
  t702 = 0.2e1 / 0.15e2 * t700 * t627
  t703 = t1 * t28
  t704 = t703 * t626
  t706 = 0.4e1 / 0.45e2 * t613 * t704
  t707 = t612 * t1
  t708 = t608 * t707
  t710 = 0.1e1 / t615 / t602
  t711 = t15 * t710
  t712 = t625 * t693
  t713 = t712 * t218
  t714 = t711 * t713
  t716 = 0.4e1 / 0.45e2 * t708 * t714
  t717 = t624 ** 2
  t718 = 0.1e1 / t717
  t719 = t616 * t718
  t722 = t62 * t619
  t727 = t619 / t603
  t728 = t727 * t694
  t731 = -0.35991666666666666666666666666666666666666666666667e-1 * t690 - 0.35991666666666666666666666666666666666666666666667e-1 * t696 - 0.66666666666666666666666666666666666666666666666667e-2 * t618 * t722 * t615 - 0.66666666666666666666666666666666666666666666666667e-2 * t35 * t728
  t732 = t719 * t731
  t733 = t614 * t732
  t735 = 0.2e1 / 0.15e2 * t613 * t733
  t736 = t630 * t637
  t737 = t736 * t612
  t738 = -t683
  t739 = t648 * t738
  t740 = t614 * t739
  t742 = 0.4e1 / 0.15e2 * t737 * t740
  t744 = t347 * t688 * t633
  t746 = t157 * t641
  t747 = 0.1e1 / t667
  t748 = t747 * t230
  t749 = t746 * t748
  t750 = t30 * t749
  t752 = 0.18891666666666666666666666666666666666666666666667e-2 * t744 + 0.18891666666666666666666666666666666666666666666667e-2 * t750
  t753 = t631 * t752
  t754 = t753 * t612
  t756 = 0.2e1 / 0.15e2 * t754 * t649
  t757 = t703 * t648
  t759 = 0.4e1 / 0.45e2 * t639 * t757
  t760 = t638 * t707
  t762 = 0.1e1 / t640 / t632
  t763 = t15 * t762
  t764 = t647 * t747
  t765 = t764 * t230
  t766 = t763 * t765
  t768 = 0.4e1 / 0.45e2 * t760 * t766
  t769 = t646 ** 2
  t770 = 0.1e1 / t769
  t771 = t641 * t770
  t778 = t619 / t633
  t779 = t778 * t748
  t782 = -0.35991666666666666666666666666666666666666666666667e-1 * t744 - 0.35991666666666666666666666666666666666666666666667e-1 * t750 - 0.66666666666666666666666666666666666666666666666667e-2 * t618 * t722 * t640 - 0.66666666666666666666666666666666666666666666666667e-2 * t35 * t779
  t783 = t771 * t782
  t784 = t614 * t783
  t786 = 0.2e1 / 0.15e2 * t639 * t784
  t787 = t107 * t653
  t788 = t787 * t657
  t791 = t23 * t2
  t792 = 0.1e1 / t6
  t793 = t791 * t792
  t794 = t653 * t657
  t795 = t34 * t794
  t800 = 0.32333333333333333333333333333333333333333333333333e-1 * t114 - 0.11266666666666666666666666666666666666666666666667e0 * t116
  t801 = t654 * t800
  t804 = t660 * t29
  t807 = t216 * t144
  t809 = t228 * t151
  t813 = (0.4e1 / 0.3e1 * t807 * t218 + 0.4e1 / 0.3e1 * t809 * t230) * t610
  t816 = t672 * t28
  t819 = t687 + t702 + t706 + t716 - t735 + t742 + t756 + t759 + t768 - t786 + t788 * t662 / 0.3e1 + 0.60777777777777777777777777777777777777777777777777e-1 * t793 * t795 + t801 * t662 / 0.3e1 + 0.2e1 / 0.9e1 * t658 * t804 - t813 * t673 / 0.15e2 - 0.2e1 / 0.45e2 * t671 * t816
  t824 = t23 * t21
  t831 = t660 * t44
  t834 = t133 * t653
  t835 = t834 * t657
  t838 = t787 * t800
  t841 = t107 * t2
  t842 = t841 * t792
  t845 = t653 * t800
  t846 = t34 * t845
  t851 = -0.43111111111111111111111111111111111111111111111111e-1 * t69 + 0.18777777777777777777777777777777777777777777777778e0 * t74
  t852 = t654 * t851
  t857 = t672 * t43
  t869 = (0.20e2 / 0.9e1 * t216 * t219 + 0.4e1 / 0.3e1 * t807 * t223 + 0.20e2 / 0.9e1 * t228 * t231 + 0.4e1 / 0.3e1 * t809 * t234) * t610
  t872 = 0.33245444444444444444444444444444444444444444444444e-1 * t824 * t794 + 0.4e1 / 0.9e1 * t788 * t804 + 0.4e1 / 0.9e1 * t801 * t804 - 0.2e1 / 0.27e2 * t658 * t831 + t835 * t662 / 0.3e1 + 0.2e1 / 0.3e1 * t838 * t662 + 0.12155555555555555555555555555555555555555555555555e0 * t842 * t795 + 0.12155555555555555555555555555555555555555555555555e0 * t793 * t846 + t852 * t662 / 0.3e1 - 0.4e1 / 0.45e2 * t813 * t816 + 0.2e1 / 0.135e3 * t671 * t857 - t869 * t673 / 0.15e2
  t873 = t703 * t732
  t875 = 0.8e1 / 0.45e2 * t613 * t873
  t876 = t67 * t157
  t878 = t347 * t876 * t603
  t880 = t114 * t695
  t882 = t157 * t710
  t883 = t665 ** 2
  t884 = 0.1e1 / t883
  t885 = t884 * t219
  t886 = t882 * t885
  t887 = t30 * t886
  t890 = 0.1e1 / t665 / t144
  t891 = t890 * t219
  t892 = t692 * t891
  t893 = t30 * t892
  t895 = t693 * t223
  t896 = t692 * t895
  t897 = t30 * t896
  t899 = t72 * t619
  t907 = t619 / t603 / t602
  t908 = t907 * t885
  t911 = t727 * t891
  t914 = t727 * t895
  t917 = 0.47988888888888888888888888888888888888888888888889e-1 * t878 + 0.23994444444444444444444444444444444444444444444444e-1 * t880 - 0.23994444444444444444444444444444444444444444444445e-1 * t887 + 0.71983333333333333333333333333333333333333333333334e-1 * t893 - 0.35991666666666666666666666666666666666666666666667e-1 * t897 + 0.11111111111111111111111111111111111111111111111111e-1 * t618 * t899 * t615 + 0.88888888888888888888888888888888888888888888888890e-2 * t116 * t728 - 0.22222222222222222222222222222222222222222222222222e-2 * t35 * t908 + 0.13333333333333333333333333333333333333333333333333e-1 * t35 * t911 - 0.66666666666666666666666666666666666666666666666667e-2 * t35 * t914
  t918 = t719 * t917
  t919 = t614 * t918
  t921 = 0.2e1 / 0.15e2 * t613 * t919
  t922 = t599 * t698
  t923 = t922 * t612
  t925 = 0.8e1 / 0.15e2 * t923 * t685
  t926 = t626 * t222
  t927 = t614 * t926
  t929 = 0.4e1 / 0.15e2 * t682 * t927
  t930 = t681 * t707
  t931 = t15 * t616
  t933 = t718 * t683 * t731
  t934 = t931 * t933
  t936 = 0.8e1 / 0.15e2 * t930 * t934
  t938 = 0.1e1 / t667 / t151
  t940 = t647 * t938 * t231
  t941 = t763 * t940
  t943 = 0.8e1 / 0.45e2 * t760 * t941
  t945 = t625 * t890 * t219
  t946 = t711 * t945
  t948 = 0.8e1 / 0.45e2 * t708 * t946
  t949 = t736 * t707
  t950 = t15 * t641
  t952 = t770 * t738 * t782
  t953 = t950 * t952
  t955 = 0.8e1 / 0.15e2 * t949 * t953
  t956 = t753 * t707
  t958 = 0.8e1 / 0.45e2 * t956 * t766
  t959 = t28 * t762
  t960 = t959 * t765
  t962 = 0.16e2 / 0.135e3 * t760 * t960
  t963 = t764 * t234
  t964 = t763 * t963
  t966 = 0.4e1 / 0.45e2 * t760 * t964
  t968 = 0.1e1 / t640 / t747
  t969 = t15 * t968
  t970 = t667 ** 2
  t971 = 0.1e1 / t970
  t972 = t647 * t971
  t973 = t972 * t231
  t974 = t969 * t973
  t976 = 0.4e1 / 0.27e2 * t760 * t974
  t977 = t699 * t707
  t979 = 0.8e1 / 0.45e2 * t977 * t714
  t980 = -t875 - t921 + t925 + t929 - t936 - t943 - t948 - t955 + t958 + t962 + t966 + t976 + t979
  t982 = t28 * t710
  t983 = t982 * t713
  t985 = 0.16e2 / 0.135e3 * t708 * t983
  t986 = t763 * t770
  t987 = t748 * t782
  t988 = t986 * t987
  t990 = 0.8e1 / 0.45e2 * t760 * t988
  t991 = t711 * t718
  t992 = t694 * t731
  t993 = t991 * t992
  t995 = 0.8e1 / 0.45e2 * t708 * t993
  t996 = t763 * t647
  t997 = t738 * t747
  t998 = t997 * t230
  t999 = t996 * t998
  t1001 = 0.16e2 / 0.45e2 * t949 * t999
  t1002 = t711 * t625
  t1003 = t683 * t693
  t1004 = t1003 * t218
  t1005 = t1002 * t1004
  t1007 = 0.16e2 / 0.45e2 * t930 * t1005
  t1008 = t738 ** 2
  t1009 = t1008 * t637
  t1010 = t1009 * t612
  t1012 = 0.4e1 / 0.15e2 * t1010 * t649
  t1013 = t1 * t43
  t1014 = t1013 * t626
  t1016 = 0.4e1 / 0.135e3 * t613 * t1014
  t1017 = t683 ** 2
  t1018 = t1017 * t607
  t1019 = t1018 * t612
  t1021 = 0.4e1 / 0.15e2 * t1019 * t627
  t1023 = 0.8e1 / 0.45e2 * t700 * t704
  t1025 = t347 * t876 * t633
  t1027 = t114 * t749
  t1029 = t157 * t762
  t1030 = t971 * t231
  t1031 = t1029 * t1030
  t1032 = t30 * t1031
  t1034 = t938 * t231
  t1035 = t746 * t1034
  t1036 = t30 * t1035
  t1038 = t747 * t234
  t1039 = t746 * t1038
  t1040 = t30 * t1039
  t1042 = -0.25188888888888888888888888888888888888888888888889e-2 * t1025 - 0.12594444444444444444444444444444444444444444444445e-2 * t1027 + 0.12594444444444444444444444444444444444444444444445e-2 * t1032 - 0.37783333333333333333333333333333333333333333333334e-2 * t1036 + 0.18891666666666666666666666666666666666666666666667e-2 * t1040
  t1043 = t631 * t1042
  t1044 = t1043 * t612
  t1046 = 0.2e1 / 0.15e2 * t1044 * t649
  t1048 = 0.8e1 / 0.45e2 * t754 * t757
  t1054 = -0.25188888888888888888888888888888888888888888888889e-2 * t878 - 0.12594444444444444444444444444444444444444444444445e-2 * t880 + 0.12594444444444444444444444444444444444444444444445e-2 * t887 - 0.37783333333333333333333333333333333333333333333334e-2 * t893 + 0.18891666666666666666666666666666666666666666666667e-2 * t897
  t1055 = t600 * t1054
  t1056 = t1055 * t612
  t1058 = 0.2e1 / 0.15e2 * t1056 * t627
  t1059 = t985 - t990 - t995 + t1001 + t1007 + t1012 - t1016 + t1021 + t1023 + t1046 + t1048 + t1058
  t1060 = t1013 * t648
  t1062 = 0.4e1 / 0.135e3 * t639 * t1060
  t1064 = 0.1e1 / t717 / t624
  t1066 = t731 ** 2
  t1067 = t616 * t1064 * t1066
  t1068 = t614 * t1067
  t1070 = 0.4e1 / 0.15e2 * t613 * t1068
  t1071 = t703 * t684
  t1073 = 0.16e2 / 0.45e2 * t682 * t1071
  t1086 = t619 / t633 / t632
  t1087 = t1086 * t1030
  t1090 = t778 * t1034
  t1093 = t778 * t1038
  t1096 = 0.47988888888888888888888888888888888888888888888889e-1 * t1025 + 0.23994444444444444444444444444444444444444444444444e-1 * t1027 - 0.23994444444444444444444444444444444444444444444445e-1 * t1032 + 0.71983333333333333333333333333333333333333333333334e-1 * t1036 - 0.35991666666666666666666666666666666666666666666667e-1 * t1040 + 0.11111111111111111111111111111111111111111111111111e-1 * t618 * t899 * t640 + 0.88888888888888888888888888888888888888888888888890e-2 * t116 * t779 - 0.22222222222222222222222222222222222222222222222222e-2 * t35 * t1087 + 0.13333333333333333333333333333333333333333333333333e-1 * t35 * t1090 - 0.66666666666666666666666666666666666666666666666667e-2 * t35 * t1093
  t1097 = t771 * t1096
  t1098 = t614 * t1097
  t1100 = 0.2e1 / 0.15e2 * t639 * t1098
  t1102 = 0.4e1 / 0.15e2 * t754 * t784
  t1103 = t703 * t783
  t1105 = 0.8e1 / 0.45e2 * t639 * t1103
  t1106 = t630 * t752
  t1107 = t1106 * t612
  t1109 = 0.8e1 / 0.15e2 * t1107 * t740
  t1110 = -t222
  t1111 = t648 * t1110
  t1112 = t614 * t1111
  t1114 = 0.4e1 / 0.15e2 * t737 * t1112
  t1116 = 0.4e1 / 0.15e2 * t700 * t733
  t1118 = 0.1e1 / t769 / t646
  t1120 = t782 ** 2
  t1121 = t641 * t1118 * t1120
  t1122 = t614 * t1121
  t1124 = 0.4e1 / 0.15e2 * t639 * t1122
  t1125 = t703 * t739
  t1127 = 0.16e2 / 0.45e2 * t737 * t1125
  t1128 = t712 * t223
  t1129 = t711 * t1128
  t1131 = 0.4e1 / 0.45e2 * t708 * t1129
  t1133 = 0.1e1 / t615 / t693
  t1134 = t15 * t1133
  t1135 = t625 * t884
  t1136 = t1135 * t219
  t1137 = t1134 * t1136
  t1139 = 0.4e1 / 0.27e2 * t708 * t1137
  t1140 = -t1062 + t1070 + t1073 - t1100 - t1102 - t1105 + t1109 + t1114 - t1116 + t1124 + t1127 + t1131 + t1139
  t1142 = t872 + t980 + t1059 + t1140
  t1156 = -0.52629732327660179956916004458792505225000000000000e0 * t77 * t581 + 0.52629732327660179956916004458792505225000000000000e0 * t118 * t584 + 0.52629732327660179956916004458792505225000000000000e0 * t118 * t587 - 0.26314866163830089978458002229396252612500000000000e0 * t38 * t590 - 0.52629732327660179956916004458792505225000000000000e0 * t38 * t593 - 0.26314866163830089978458002229396252612500000000000e0 * t38 * t596 - 0.16889345248872318972700803464104647715469565281367e-1 * t142 * t17 * t676 * jnp.pi + 0.12667008936654239229525602598078485786602173961026e-1 * t142 * t72 * t819 * jnp.pi - 0.38001026809962717688576807794235457359806521883077e-2 * t142 * t62 * t1142 * jnp.pi + 0.13287210228946179141882035000000000000000000000000e1 * t41 * t81 * t499 - 0.11389037339096724978756030000000000000000000000000e1 * t41 * t68 * t489 + 0.42708890021612718670335112500000000000000000000000e0 * t41 * t44 * t471
  t1159 = 0.1e1 / t52 / jnp.pi
  t1160 = t1159 * t76
  t1161 = t1160 * t23
  t1162 = t50 * t51
  t1165 = t1159 * t21
  t1166 = t1165 * t107
  t1169 = t1165 * t23
  t1170 = t123 * t51
  t1173 = t1159 * t80
  t1177 = t26 * t27 * t49 * t51
  t1180 = t1159 * t37
  t1181 = t1180 * t133
  t1184 = t1180 * t107
  t1187 = t1159 * t67
  t1188 = t107 * t47
  t1192 = t1180 * t23
  t1193 = t85 * t51
  t1196 = t23 * t122
  t1200 = t1159 * t17
  t1204 = t32 * t10 * t49 * t51
  t1208 = jnp.exp(-0.77500000000000000000000000000000000000000000000000e-1 * t30)
  t1209 = t23 * t1208
  t1212 = -0.12375000000000000000000000000000000000000000000000e1 * t30 + t35 / 0.4e1
  t1213 = t1212 * jnp.pi
  t1214 = t1213 * t11
  t1217 = t629 + t651 + 0.4e1 / 0.3e1 * t1209 * t1214
  t1222 = t107 * t1208
  t1226 = t23 * t1 * t98
  t1227 = t28 * t1208
  t1228 = t1227 * t1213
  t1234 = (0.41250000000000000000000000000000000000000000000000e0 * t114 - t116 / 0.6e1) * jnp.pi
  t1235 = t1234 * t11
  t1240 = t687 + t702 + t706 + t716 - t735 + t742 + t756 + t759 + t768 - t786 + 0.4e1 / 0.3e1 * t1222 * t1214 + 0.34444444444444444444444444444444444444444444444444e-1 * t1226 * t1228 + 0.4e1 / 0.3e1 * t1209 * t1235 + 0.4e1 / 0.3e1 * t1209 * t1213
  t1248 = (-0.55000000000000000000000000000000000000000000000000e0 * t69 + 0.5e1 / 0.18e2 * t74) * jnp.pi
  t1249 = t1248 * t11
  t1252 = t133 * t1208
  t1257 = t791 * t288
  t1258 = t62 * t1208
  t1259 = t1258 * t1213
  t1262 = t43 * t1208
  t1263 = t1262 * t1213
  t1266 = 0.4e1 / 0.3e1 * t1209 * t1249 + 0.4e1 / 0.3e1 * t1252 * t1214 + 0.8e1 / 0.3e1 * t1222 * t1235 - t875 - t921 + t925 + t929 + 0.35592592592592592592592592592592592592592592592591e-2 * t1257 * t1259 + 0.22962962962962962962962962962962962962962962962963e-1 * t1226 * t1263 - t936 - t943
  t1267 = -t948 - t955 + t958 + t962 + t966 + t976 + t979 + t985 - t990 - t995 + t1001 + t1007
  t1270 = t107 * t1 * t98
  t1273 = t1227 * t1234
  t1280 = 0.68888888888888888888888888888888888888888888888888e-1 * t1270 * t1228 + 0.68888888888888888888888888888888888888888888888888e-1 * t1226 * t1273 + t1012 - t1016 + t1021 + t1023 + t1046 + t1048 + t1058 - t1062 + 0.8e1 / 0.3e1 * t1209 * t1234 + 0.8e1 / 0.3e1 * t1222 * t1213
  t1281 = t1070 + t1073 - t1100 - t1102 - t1105 + t1109 + t1114 - t1116 + t1124 + t1127 + t1131 + t1139
  t1283 = t1266 + t1267 + t1280 + t1281
  t1288 = -0.35086488218440119971277336305861670150000000000000e0 * t1161 * t1162 + 0.35086488218440119971277336305861670150000000000000e0 * t1166 * t1162 + 0.35086488218440119971277336305861670150000000000000e0 * t1169 * t1170 + 0.36665380188269925369984816439625445306750000000000e-1 * t1173 * t95 * t1177 - 0.17543244109220059985638668152930835075000000000000e0 * t1181 * t1162 - 0.35086488218440119971277336305861670150000000000000e0 * t1184 * t1170 - 0.21999228112961955221990889863775267184050000000000e-1 * t1187 * t1188 * t1177 - 0.17543244109220059985638668152930835075000000000000e0 * t1192 * t1193 - 0.21999228112961955221990889863775267184050000000000e-1 * t1187 * t1196 * t1177 - 0.27587032053654291848376575889174185048798700000000e-2 * t1200 * t95 * t1204 - 0.13511476199097855178160642771283718172375652225094e-1 * t142 * t17 * t1217 * t53 + 0.10133607149323391383620482078462788629281739168821e-1 * t142 * t72 * t1240 * t53 - 0.30400821447970174150861446235388365887845217506462e-2 * t142 * t62 * t1283 * t53
  t1289 = t54 * f.p.cam_omega
  t1292 = t216 / 0.2e1 + t228 / 0.2e1
  t1293 = t1292 ** 2
  t1294 = t1293 * t1292
  t1295 = jnp.log(0.2e1)
  t1296 = t1295 - 0.1e1
  t1297 = 0.2e1 * t1296
  t1298 = t1294 * t1297
  t1299 = f.p.cam_omega * t286
  t1300 = 0.1e1 / t1292
  t1301 = t1299 * t1300
  t1303 = 0.32478055555555555555555555555555555555555555555555e0 * t1301 * t74
  t1304 = f.p.cam_omega * t246
  t1305 = 0.1e1 / t1293
  t1307 = t1304 * t1305 * t1
  t1308 = 0.1e1 / t148
  t1310 = 0.1e1 / t153
  t1313 = t1308 * t218 / 0.3e1 + t1310 * t230 / 0.3e1
  t1315 = t98 * t43 * t1313
  t1317 = 0.97434166666666666666666666666666666666666666666666e0 * t1307 * t1315
  t1318 = t1304 * t1300
  t1320 = 0.64956111111111111111111111111111111111111111111111e0 * t1318 * t69
  t1321 = f.p.cam_omega * t164
  t1322 = 0.1e1 / t1294
  t1323 = t1313 ** 2
  t1326 = 0.58460500000000000000000000000000000000000000000000e1 * t1321 * t1322 * t1323
  t1327 = 0.1e1 / t149
  t1332 = 0.1e1 / t154
  t1337 = -t1327 * t219 / 0.9e1 + t1308 * t223 / 0.3e1 - t1332 * t231 / 0.9e1 + t1310 * t234 / 0.3e1
  t1340 = 0.29230250000000000000000000000000000000000000000000e1 * t1321 * t1305 * t1337
  t1349 = (0.344851e1 - jnp.pi * t10 * t610 * t6 / t1296 / 0.12e2) * t54
  t1350 = t1349 * t1
  t1355 = t1349 * t26
  t1356 = t1322 * t1313
  t1357 = t44 * t1356
  t1360 = t1293 ** 2
  t1361 = 0.1e1 / t1360
  t1362 = t1361 * t1323
  t1363 = t29 * t1362
  t1366 = t1322 * t1337
  t1367 = t29 * t1366
  t1370 = t1289 * t246
  t1371 = t1370 * t1322
  t1374 = t1289 * t164
  t1376 = t1374 * t1361 * t1
  t1379 = t1374 * t1322
  t1382 = t1289 * t285
  t1384 = 0.1e1 / t1360 / t1292
  t1391 = -t1303 + t1317 + t1320 + t1326 - t1340 + t1350 * t98 * t67 * t1305 / 0.9e1 + t1355 * t1357 / 0.3e1 + 0.3e1 / 0.2e1 * t1355 * t1363 - t1355 * t1367 / 0.2e1 + 0.16322666666666666666666666666666666666666666666667e0 * t1371 * t74 + 0.14690400000000000000000000000000000000000000000000e1 * t1376 * t1315 + 0.32645333333333333333333333333333333333333333333333e0 * t1379 * t69 + 0.58761600000000000000000000000000000000000000000000e1 * t1382 * t1384 * t1323 - 0.14690400000000000000000000000000000000000000000000e1 * t1382 * t1361 * t1337
  t1393 = 0.29230250000000000000000000000000000000000000000000e1 * t1321 * t1300
  t1394 = t54 * t1
  t1395 = t1394 * t6
  t1399 = 0.1e1 + t1393 + 0.86212750000000000000000000000000000000000000000000e0 * t1395 * t29 * t1305
  t1400 = 0.1e1 / t1399
  t1403 = 0.48717083333333333333333333333333333333333333333333e0 * t1318 * t114
  t1406 = 0.29230250000000000000000000000000000000000000000000e1 * t1321 * t1305 * t1313
  t1411 = t29 * t1356
  t1416 = t1361 * t1313
  t1419 = -t1403 - t1406 - t1350 * t98 * t43 * t1305 / 0.12e2 - t1355 * t1411 / 0.2e1 - 0.24484000000000000000000000000000000000000000000000e0 * t1379 * t114 - 0.14690400000000000000000000000000000000000000000000e1 * t1382 * t1416
  t1420 = t1399 ** 2
  t1421 = 0.1e1 / t1420
  t1422 = t1419 * t1421
  t1428 = -t1403 - t1406 - 0.28737583333333333333333333333333333333333333333333e0 * t1395 * t44 * t1305 - 0.17242550000000000000000000000000000000000000000000e1 * t1395 * t1411
  t1437 = 0.1e1 + t1393 + t1350 * t98 * t28 * t1305 / 0.4e1 + 0.48968000000000000000000000000000000000000000000000e0 * t1382 * t1322
  t1439 = 0.1e1 / t1420 / t1399
  t1440 = t1437 * t1439
  t1441 = t1428 ** 2
  t1444 = t1437 * t1421
  t1454 = -t1303 + t1317 + t1320 + t1326 - t1340 + 0.38316777777777777777777777777777777777777777777777e0 * t1395 * t68 * t1305 + 0.11495033333333333333333333333333333333333333333333e1 * t1395 * t1357 + 0.51727650000000000000000000000000000000000000000000e1 * t1395 * t1363 - 0.17242550000000000000000000000000000000000000000000e1 * t1395 * t1367
  t1456 = t1391 * t1400 - 0.2e1 * t1422 * t1428 + 0.2e1 * t1440 * t1441 - t1444 * t1454
  t1457 = t1298 * t1456
  t1458 = 0.1e1 / t1437
  t1459 = t1458 * t1399
  t1460 = t1459 * t4
  t1464 = t1419 * t1400 - t1444 * t1428
  t1465 = t1298 * t1464
  t1466 = t1458 * t1428
  t1467 = t1466 * t4
  t1469 = t1292 * t1297
  t1471 = jnp.log(t1437 * t1400)
  t1472 = t1471 * t4
  t1476 = t1293 * t1297
  t1480 = t1476 * t1464
  t1481 = t4 * t1313
  t1482 = t1459 * t1481
  t1485 = t1437 ** 2
  t1486 = 0.1e1 / t1485
  t1487 = t1486 * t1399
  t1488 = t4 * t1419
  t1489 = t1487 * t1488
  t1491 = -0.10166034692201226236048067621113869552895440734161e-1 * t512 * t507 - 0.10166034692201226236048067621113869552895440734161e-1 * t515 * t516 + (-0.45038253996992850593868809237612393907918840750312e-1 * t142 * t519 * t522 + 0.33778690497744637945401606928209295430939130562734e-1 * t142 * t526 * t522 + 0.33778690497744637945401606928209295430939130562734e-1 * t142 * t530 * t538 - 0.10133607149323391383620482078462788629281739168820e-1 * t142 * t542 * t522 - 0.20267214298646782767240964156925577258563478337640e-1 * t142 * t546 * t538 - 0.10133607149323391383620482078462788629281739168820e-1 * t142 * t550 * t565 + 0.31577839396596107974149602675275503135000000000000e1 * t569 * t499 - 0.21051892931064071982766401783517002090000000000000e1 * t572 * t489 + 0.52629732327660179956916004458792505225000000000000e0 * t575 * t471) * t579 + t1156 * t55 + t1288 * t1289 + t1457 * t1460 + t1465 * t1467 + 0.6e1 * t1469 * t1472 * t1323 + 0.3e1 * t1476 * t1472 * t1337 + 0.6e1 * t1480 * t1482 - t1465 * t1489
  t1492 = t510 + t1491
  t1496 = 0.1e1 + 0.15403623315025000000000000000000000000000000000000e0 * t32 * t34 * t54
  t1497 = t1496 ** 2
  t1498 = t1497 ** 2
  t1499 = 0.1e1 / t1498
  t1535 = t1298 * t1472 + (-0.17543244109220059985638668152930835075000000000000e0 * t1192 * t1162 - 0.30400821447970174150861446235388365887845217506462e-2 * t142 * t62 * t1217 * t53) * t1289 + (-0.26314866163830089978458002229396252612500000000000e0 * t38 * t581 - 0.38001026809962717688576807794235457359806521883077e-2 * t142 * t62 * t676 * jnp.pi + 0.42708890021612718670335112500000000000000000000000e0 * t41 * t44 * t499) * t55 - 0.67557380995489275890803213856418590861878261125470e-2 * t65 * t58 + (-0.10133607149323391383620482078462788629281739168820e-1 * t142 * t550 * t522 + 0.52629732327660179956916004458792505225000000000000e0 * t575 * t499) * t579 + 0.20267214298646782767240964156925577258563478337641e-1 * t142 * t72 * t499 * t473
  t1537 = 0.1e1 / t1498 / t1496
  t1539 = t1535 * t1537 * t2
  t1541 = t288 * t72 * t54
  t1545 = 0.1e1 / t1498 / t1497
  t1547 = t1535 * t1545 * t1
  t1548 = t40 * t27
  t1550 = t1548 * t80 * t55
  t1629 = 0.3e1 * t1476 * t1472 * t1313 + t1465 * t1460 + (0.17543244109220059985638668152930835075000000000000e0 * t1169 * t1162 - 0.17543244109220059985638668152930835075000000000000e0 * t1184 * t1162 - 0.17543244109220059985638668152930835075000000000000e0 * t1192 * t1170 - 0.10999614056480977610995444931887633592025000000000e-1 * t1187 * t95 * t1177 + 0.50668035746616956918102410392313943146408695844103e-2 * t142 * t72 * t1217 * t53 - 0.30400821447970174150861446235388365887845217506462e-2 * t142 * t62 * t1240 * t53) * t1289 + (0.26314866163830089978458002229396252612500000000000e0 * t118 * t581 - 0.26314866163830089978458002229396252612500000000000e0 * t38 * t584 - 0.26314866163830089978458002229396252612500000000000e0 * t38 * t587 + 0.63335044683271196147628012990392428933010869805128e-2 * t142 * t72 * t676 * jnp.pi - 0.38001026809962717688576807794235457359806521883077e-2 * t142 * t62 * t819 * jnp.pi - 0.56945186695483624893780150000000000000000000000000e0 * t41 * t68 * t499 + 0.42708890021612718670335112500000000000000000000000e0 * t41 * t44 * t489) * t55 + 0.11259563499248212648467202309403098476979710187578e-1 * t113 * t58 - 0.67557380995489275890803213856418590861878261125470e-2 * t139 * t58 - 0.67557380995489275890803213856418590861878261125470e-2 * t65 * t124 - 0.50830173461006131180240338105569347764477203670804e-2 * t515 * t507 + (0.16889345248872318972700803464104647715469565281367e-1 * t142 * t530 * t522 - 0.10133607149323391383620482078462788629281739168820e-1 * t142 * t546 * t522 - 0.10133607149323391383620482078462788629281739168820e-1 * t142 * t550 * t538 - 0.10525946465532035991383200891758501045000000000000e1 * t572 * t499 + 0.52629732327660179956916004458792505225000000000000e0 * t575 * t489) * t579 - 0.54045904796391420712642571085134872689502608900376e-1 * t142 * t17 * t499 * t473 + 0.20267214298646782767240964156925577258563478337641e-1 * t142 * t72 * t489 * t473
  t1631 = t1629 * t1537 * t2
  t1633 = t288 * t62 * t54
  t1646 = -0.3e1 * t1492 * t1499 + 0.20538164420033333333333333333333333333333333333334e1 * t1539 * t1541 - 0.18981728898494541631260050000000000000000000000001e1 * t1547 * t1550 - 0.24645797304040000000000000000000000000000000000001e1 * t1631 * t1633 + 0.35089340384731224424988055003710697745685326982943e1 * t463 - 0.51947267698127589899017076750918898776700016259464e2 * t272 - 0.35089340384731224424988055003710697745685326982943e1 * t283 - 0.17544670192365612212494027501855348872842663491471e1 * t306 + 0.73246220147012639765228919932558287780546586655172e-3 * t468 - 0.10685000000000000000000000000000000000000000000000e0 * t390 - 0.10986933022051895964784337989883743167081987998276e-2 * t311 + 0.3e1 * t422 + 0.32530742648344572643999342659690126035062438557102e-1 * t262 - 0.44294311333333333333333333333333333333333333333332e-2 * t214
  t1661 = 0.12e2 * t444 * t423
  t1663 = 0.60e2 * t458 * t448
  t1665 = 0.60e2 * t458 * t445
  t1666 = t19 * t130
  t1668 = 0.24e2 * t1666 * t204
  t1669 = t20 * t209
  t1671 = 0.144e3 * t1669 * t204
  t1674 = 0.3e1 * t343 * t281 * t420
  t1677 = 0.34451131037037037037037037037037037037037037037036e-2 * t26 * t81 * t187
  t1680 = 0.60000000000000000000000000000000000000000000000000e1 * t394 * t324 * t334
  t1683 = 0.32530742648344572643999342659690126035062438557102e-1 * t281 * t26 * t261
  t1686 = 0.21687161765563048429332895106460084023374959038068e-1 * t243 * t68 * t260
  t1689 = 0.16265371324172286321999671329845063017531219278551e-1 * t243 * t44 * t305
  t1692 = 0.48159446095139119802213748237831062407565640073877e0 * t243 * t44 * t271
  t1695 = 0.32530742648344572643999342659690126035062438557102e-1 * t243 * t44 * t462
  t1696 = t1323 * t1313
  t1709 = 0.17538150000000000000000000000000000000000000000000e2 * t1321 * t1361 * t1696
  t1712 = t219 * t218
  t1718 = t76 - t1666
  t1719 = 0.6e1 * t1718
  t1724 = t231 * t230
  t1730 = -t1719
  t1733 = 0.4e1 / 0.27e2 / t148 / t665 * t1712 - t1327 * t218 * t223 / 0.3e1 + t1308 * t1719 / 0.3e1 + 0.4e1 / 0.27e2 / t153 / t667 * t1724 - t1332 * t230 * t234 / 0.3e1 + t1310 * t1730 / 0.3e1
  t1736 = 0.29230250000000000000000000000000000000000000000000e1 * t1321 * t1305 * t1733
  t1746 = 0.1e1 / t164 / t35 / 0.4e1
  t1751 = 0.19486833333333333333333333333333333333333333333333e1 * f.p.cam_omega * t1746 * t1300 * t5 * t130
  t1754 = 0.17538150000000000000000000000000000000000000000000e2 * t1321 * t1356 * t1337
  t1761 = t98 * t43 * t1337
  t1767 = t288 * t72 * t1313
  t1769 = 0.97434166666666666666666666666666666666666666666666e0 * t1299 * t1305 * t2 * t1767
  t1771 = 0.14615125000000000000000000000000000000000000000000e1 * t1307 * t1761
  t1775 = t98 * t43 * t1323
  t1779 = t98 * t67 * t1313
  t1782 = -0.29380800000000000000000000000000000000000000000000e2 * t1382 / t1360 / t1293 * t1696 - t1709 - t1736 - 0.14690400000000000000000000000000000000000000000000e1 * t1382 * t1361 * t1733 + 0.17628480000000000000000000000000000000000000000000e2 * t1382 * t1384 * t1313 * t1337 - t1751 + t1754 + 0.32645333333333333333333333333333333333333333333334e0 * t1289 * t286 * t1322 * t5 * t130 + 0.22035600000000000000000000000000000000000000000000e1 * t1376 * t1761 + t1769 + t1771 - 0.88142400000000000000000000000000000000000000000000e1 * t1374 * t1384 * t1 * t1775 - 0.29380800000000000000000000000000000000000000000000e1 * t1376 * t1779
  t1783 = t44 * t1362
  t1787 = t29 * t1384 * t1696
  t1793 = 0.29230250000000000000000000000000000000000000000000e1 * t1304 * t1322 * t1 * t1775
  t1795 = 0.19486833333333333333333333333333333333333333333333e1 * t1307 * t1779
  t1796 = t68 * t1356
  t1799 = t44 * t1366
  t1803 = t29 * t1322 * t1733
  t1814 = t26 * t81
  t1821 = t32 * t18
  t1825 = 0.12991222222222222222222222222222222222222222222222e1 * t1301 * t1821
  t1827 = 0.15156425925925925925925925925925925925925925925926e1 * t1318 * t1814
  t1828 = -0.3e1 / 0.2e1 * t1355 * t1783 - 0.6e1 * t1355 * t1787 - t1793 - t1795 - 0.2e1 / 0.3e1 * t1355 * t1796 + t1355 * t1799 / 0.2e1 - t1355 * t1803 / 0.2e1 - 0.14690400000000000000000000000000000000000000000000e1 * t1370 * t1361 * t2 * t1767 + 0.9e1 / 0.2e1 * t1355 * t29 * t1416 * t1337 - 0.76172444444444444444444444444444444444444444444444e0 * t1379 * t1814 - 0.7e1 / 0.27e2 * t1350 * t98 * t80 * t1305 - 0.65290666666666666666666666666666666666666666666667e0 * t1371 * t1821 + t1825 - t1827
  t1839 = t1420 ** 2
  t1867 = -t1793 - t1795 - t1751 - t1709 + t1754 - 0.17242550000000000000000000000000000000000000000000e1 * t1395 * t1803 - 0.89405814814814814814814814814814814814814814814813e0 * t1395 * t81 * t1305 - 0.22990066666666666666666666666666666666666666666666e1 * t1395 * t1796 + 0.17242550000000000000000000000000000000000000000000e1 * t1395 * t1799 - t1736 - 0.51727649999999999999999999999999999999999999999999e1 * t1395 * t1783 - 0.20691060000000000000000000000000000000000000000000e2 * t1395 * t1787 + 0.15518295000000000000000000000000000000000000000000e2 * t1394 * t98 * t28 * t1361 * t1313 * t1337 + t1769 + t1825 + t1771 - t1827
  t1876 = t5 * t130
  t1887 = -t1661 + t1663 + t1665 + t1668 - t1671 + t1674 + t1677 - t1680 + t1683 - t1686 + t1689 + t1692
  t1891 = t335 * t334
  t1896 = 0.51725014705706168413145063783413931475389495076352e3 * t178 / t327 / t313 * t1891 / t336 / t186
  t1900 = 0.85917146441092277507960503039464796886558811231548e0 * t347 * t43 * t328 * t338
  t1904 = 0.71233333333333333333333333333333333333333333333333e-1 * t347 * t67 * t314 * t388
  t1907 = 0.53424999999999999999999999999999999999999999999999e-1 * t347 * t387 * t324
  t1911 = 0.10685000000000000000000000000000000000000000000000e0 * t347 * t43 * t393 * t395
  t1913 = 0.12e2 * t451 * t421
  t1923 = f.my_piecewise3(t145, 0, -0.8e1 / 0.27e2 / t807 * t1712 + 0.4e1 / 0.3e1 * t217 * t218 * t223 + 0.4e1 / 0.3e1 * t148 * t1719)
  t1933 = f.my_piecewise3(t152, 0, -0.8e1 / 0.27e2 / t809 * t1724 + 0.4e1 / 0.3e1 * t229 * t230 * t234 + 0.4e1 / 0.3e1 * t153 * t1730)
  t1935 = (t1923 + t1933) * t160
  t1937 = 0.19751789702565206228825776161588751761046270558698e-1 * t1935 * t201
  t1939 = 0.36e2 * t131 * t448
  t1944 = t1746 * t5 * t130
  t1946 = t288 * t17
  t1947 = t287 * t1946
  t1949 = t98 * t80
  t1950 = t247 * t1949
  t1953 = t30 ** (-0.15e1)
  t1955 = t1953 * t5 * t130
  t1957 = t297 * t1946
  t1959 = t253 * t1949
  t1962 = -0.34523333333333333333333333333333333333333333333333e1 * t1944 + 0.23015555555555555555555555555555555555555555555556e1 * t1947 - 0.26851481481481481481481481481481481481481481481482e1 * t1950 - 0.93932222222222222222222222222222222222222222222223e0 * t1814 + 0.73355000000000000000000000000000000000000000000000e-1 * t1955 - 0.14671000000000000000000000000000000000000000000000e0 * t1957 - 0.17116166666666666666666666666666666666666666666667e0 * t1959 - 0.36793333333333333333333333333333333333333333333333e0 * t1821
  t1967 = 0.1e1 / t265 / t244
  t1969 = t267 * t257
  t1971 = 0.1e1 / t269 / t199
  t1976 = 0.1e1 / t265 / t196
  t1981 = t364 * t355
  t2007 = -t1677 + t1680 - 0.35089340384731224424988055003710697745685326982943e1 * t408 * t402 * t303 + 0.58482233974552040708313425006184496242808878304903e0 * t412 * t1962 * t259 + 0.10253897021007794930818001372045340355835853271641e4 * t191 * t1967 * t1969 * t1971 - 0.10389453539625517979803415350183779755340003251893e3 * t191 * t1976 * t1969 * t270 + 0.60000000000000000000000000000000000000000000000000e1 * t381 * t1981 * t356 + 0.96494049533612093920874879382438082984882598906400e2 * t381 * t375 * t383 * t355 - 0.60000000000000000000000000000000000000000000000000e1 * t363 * t357 * t375 + 0.16562449037037037037037037037037037037037037037036e-2 * t26 * t81 * t174 + 0.20691336878655965245175271659148296983999699561788e4 * t163 / t379 / t348 * t1981 / t382 / t173 - t1896 + t1900 - t1904 + t1907 + 0.10274000000000000000000000000000000000000000000000e0 * t347 * t43 * t362 * t365
  t2037 = t303 * t270
  t2044 = 0.48245472966453314463992795342703676305040043742564e2 * t329 * t322 * t337 * t334
  t2068 = 0.60000000000000000000000000000000000000000000000000e1 * t329 * t1891 * t323
  t2074 = 0.96490945932906628927985590685407352610080087485128e2 * t178 / t327 / t183 * t1891 * t337
  t2086 = 0.10000000000000000000000000000000000000000000000000e1 * t315 * (-0.25319000000000000000000000000000000000000000000000e1 * t1944 + 0.16879333333333333333333333333333333333333333333333e1 * t1947 - 0.19692555555555555555555555555555555555555555555555e1 * t1950 - 0.93011851851851851851851851851851851851851851851854e0 * t1814 + 0.13651666666666666666666666666666666666666666666667e0 * t1955 - 0.27303333333333333333333333333333333333333333333333e0 * t1957 - 0.31853888888888888888888888888888888888888888888890e0 * t1959 - 0.36514074074074074074074074074074074074074074074075e0 * t1821) * t323
  t2087 = 0.32530742648344572643999342659690126035062438557102e-1 * t347 * t43 * t407 * t409 - t1911 + 0.21687161765563048429332895106460084023374959038068e-1 * t347 * t67 * t245 * t402 - 0.16265371324172286321999671329845063017531219278551e-1 * t347 * t401 * t413 - 0.48159446095139119802213748237831062407565640073877e0 * t347 * t43 * t266 * t417 + 0.68493333333333333333333333333333333333333333333331e-1 * t347 * t67 * t349 * t357 - 0.51369999999999999999999999999999999999999999999999e-1 * t347 * t350 * t376 - 0.16522997748472177549051141846252814409778063686072e1 * t347 * t43 * t380 * t384 + 0.56969282336565386484066937725323112718202900731800e-3 * t26 * t81 * t200 + 0.51947267698127589899017076750918898776700016259463e2 * t416 * t2037 * t257 - t2044 + 0.35089340384731224424988055003710697745685326982943e1 * t416 * t1969 * t259 - 0.19298809906722418784174975876487616596976519781280e3 * t163 / t379 / t170 * t1981 * t383 + 0.99999999999999999999999999999999999999999999999999e0 * t368 * (-0.47063000000000000000000000000000000000000000000000e1 * t1944 + 0.31375333333333333333333333333333333333333333333334e1 * t1947 - 0.36604555555555555555555555555555555555555555555556e1 * t1950 - 0.16068111111111111111111111111111111111111111111111e1 * t1814 + 0.28051666666666666666666666666666666666666666666666e0 * t1955 - 0.56103333333333333333333333333333333333333333333332e0 * t1957 - 0.65453888888888888888888888888888888888888888888890e0 * t1959 - 0.46308888888888888888888888888888888888888888888888e0 * t1821) * t356 - t2068 + t2074 - t2086
  t2090 = t343 * t161 * (t2007 + t2087)
  t2093 = 0.240e3 * t207 * t457 * t204
  t2095 = 0.36e2 * t131 * t445
  t2096 = -t1695 + t1896 - t1900 + t1904 - t1907 + t1911 + t1913 + t1937 + t1939 + t2090 + t2044 + t2093 + t2095
  t2099 = 0.73246220147012639765228919932558287780546586655172e-3 * t308 * t467
  t2103 = 0.56969282336565386484066937725323112718202900731800e-3 * t465 * t98 * t80 * t200
  t2107 = 0.35089340384731224424988055003710697745685326982943e1 * t264 * t407 * t303 * t402
  t2110 = 0.54934665110259479823921689949418715835409939991379e-3 * t240 * t1 * t310
  t2114 = 0.51947267698127589899017076750918898776700016259463e2 * t264 * t266 * t257 * t2037
  t2118 = 0.58482233974552040708313425006184496242808878304903e0 * t264 * t245 * t1962 * t259
  t2120 = 0.17544670192365612212494027501855348872842663491471e1 * t282 * t305
  t2124 = 0.10253897021007794930818001372045340355835853271641e4 * t264 * t1967 * t1969 * t1971
  t2126 = 0.51947267698127589899017076750918898776700016259464e2 * t282 * t271
  t2129 = 0.17544670192365612212494027501855348872842663491471e1 * t240 * t191 * t260
  t2133 = 0.35089340384731224424988055003710697745685326982943e1 * t264 * t266 * t1969 * t259
  t2134 = t2099 - t2103 + t2107 - t2110 - t2114 + t2068 - t2118 - t2120 - t2124 - t2126 - t2129 - t2133
  t2138 = 0.10389453539625517979803415350183779755340003251893e3 * t264 * t1976 * t1969 * t270
  t2140 = 0.35089340384731224424988055003710697745685326982943e1 * t282 * t462
  t2143 = 0.3e1 * t343 * t240 * t440
  t2145 = t343 * t1935 * t203
  t2147 = 0.12e2 * t444 * t421
  t2149 = 0.96e2 * t210 * t445
  t2151 = 0.96e2 * t210 * t448
  t2156 = 0.120e3 * t342 / t91 / t13 * t204
  t2158 = 0.24e2 * t451 * t441
  t2160 = 0.24e2 * t444 * t441
  t2162 = 0.12e2 * t451 * t423
  t2163 = t2138 + t2140 - t2074 + t2086 + t2143 + t2145 - t2147 - t2149 - t2151 - t2156 + t2158 - t2160 + t2162
  t2165 = t1887 + t2096 + t2134 + t2163
  t2170 = 0.2e1 / 0.5e1 * t754 * t1098
  t2171 = t922 * t707
  t2173 = 0.16e2 / 0.15e2 * t2171 * t1005
  t2174 = t1134 * t625
  t2176 = t884 * t223 * t218
  t2179 = 0.4e1 / 0.9e1 * t708 * t2174 * t2176
  t2180 = t969 * t647
  t2182 = t971 * t234 * t230
  t2185 = 0.4e1 / 0.9e1 * t760 * t2180 * t2182
  t2187 = t938 * t230 * t234
  t2190 = 0.8e1 / 0.15e2 * t760 * t996 * t2187
  t2192 = t890 * t218 * t223
  t2195 = 0.8e1 / 0.15e2 * t708 * t1002 * t2192
  t2199 = 0.16e2 / 0.45e2 * t708 * t982 * t718 * t992
  t2204 = 0.8e1 / 0.15e2 * t708 * t711 * t1064 * t694 * t1066
  t2229 = -t2170 + t2173 + t2179 + t2185 - t2190 - t2195 - t2199 + t2204 + 0.2e1 / 0.3e1 * t835 * t804 + 0.4e1 / 0.3e1 * t838 * t804 + 0.2e-50 * t842 * t63 * t794 + 0.2e1 / 0.3e1 * t852 * t804 + 0.2e-50 * t793 * t63 * t845 - 0.2e1 / 0.9e1 * t788 * t831 - 0.2e1 / 0.9e1 * t801 * t831 + 0.8e1 / 0.81e2 * t658 * t660 * t68 + 0.15154381759259259259259259259259259259259259259259e-2 * t23 * t80 * t1 * t98 * t794
  t2236 = 0.12e2 * t76 - 0.36e2 * t1666 + 0.24e2 * t1669
  t2249 = 0.1e1 / t883 / t665
  t2250 = t2249 * t1712
  t2254 = t693 * t1719
  t2258 = t69 * t695
  t2260 = t114 * t896
  t2262 = t114 * t886
  t2266 = t30 * t157 * t1133 * t2250
  t2269 = t30 * t692 * t2254
  t2273 = t80 * t157
  t2275 = t347 * t2273 * t603
  t2277 = 0.13333333333333333333333333333333333333333333333334e-1 * t116 * t914 + 0.44444444444444444444444444444444444444444444444445e-2 * t116 * t908 - 0.29629629629629629629629629629629629629629629629629e-2 * t35 * t619 / t603 / t693 * t2250 - 0.66666666666666666666666666666666666666666666666667e-2 * t35 * t727 * t2254 - 0.47988888888888888888888888888888888888888888888888e-1 * t2258 + 0.35991666666666666666666666666666666666666666666666e-1 * t2260 + 0.23994444444444444444444444444444444444444444444444e-1 * t2262 - 0.39990740740740740740740740740740740740740740740742e-1 * t2266 - 0.35991666666666666666666666666666666666666666666667e-1 * t2269 - 0.22222222222222222222222222222222222222222222222222e-1 * t74 * t728 - 0.11197407407407407407407407407407407407407407407407e0 * t2275
  t2278 = t17 * t619
  t2285 = 0.1e1 / t883 / t144
  t2286 = t2285 * t1712
  t2293 = t884 * t1712
  t2300 = t114 * t892
  t2303 = t30 * t882 * t2286
  t2306 = t30 * t882 * t2176
  t2309 = t30 * t692 * t2293
  t2312 = t30 * t692 * t2192
  t2314 = -0.29629629629629629629629629629629629629629629629629e-1 * t618 * t2278 * t615 - 0.26666666666666666666666666666666666666666666666667e-1 * t116 * t911 + 0.13333333333333333333333333333333333333333333333333e-1 * t35 * t907 * t2286 - 0.66666666666666666666666666666666666666666666666666e-2 * t35 * t907 * t2176 - 0.39999999999999999999999999999999999999999999999999e-1 * t35 * t727 * t2293 + 0.39999999999999999999999999999999999999999999999999e-1 * t35 * t727 * t2192 - 0.71983333333333333333333333333333333333333333333333e-1 * t2300 + 0.14396666666666666666666666666666666666666666666667e0 * t2303 - 0.71983333333333333333333333333333333333333333333335e-1 * t2306 - 0.21595000000000000000000000000000000000000000000000e0 * t2309 + 0.21595000000000000000000000000000000000000000000000e0 * t2312
  t2319 = 0.2e1 / 0.15e2 * t613 * t614 * t719 * (t2277 + t2314)
  t2348 = 0.4e1 / 0.5e1 * t630 * t1042 * t612 * t740
  t2350 = 0.4e1 / 0.5e1 * t1107 * t1112
  t2354 = 0.4e1 / 0.5e1 * t738 * t637 * t612 * t1112
  t2356 = -0.3e1 * t1718
  t2360 = 0.4e1 / 0.15e2 * t737 * t614 * t648 * t2356
  t2362 = 0.2e1 / 0.5e1 * t1056 * t733
  t2364 = 0.2e1 / 0.5e1 * t1044 * t784
  t2366 = 0.4e1 / 0.5e1 * t1010 * t784
  t2369 = 0.4e1 / 0.45e2 * t639 * t1013 * t783
  t2372 = 0.8e1 / 0.15e2 * t639 * t703 * t1121
  t2374 = 0.8e1 / 0.15e2 * t754 * t1103
  t2376 = 0.4e1 / 0.5e1 * t754 * t1122
  t2377 = -0.13506172839506172839506172839506172839506172839506e-1 * t793 * t73 * t794 + t2236 * t653 * t657 * t662 / 0.3e1 - t2319 - 0.2e1 / 0.15e2 * t869 * t816 - (0.40e2 / 0.27e2 * t1308 * t1712 + 0.20e2 / 0.3e1 * t216 * t218 * t223 + 0.4e1 / 0.3e1 * t807 * t1719 + 0.40e2 / 0.27e2 * t1310 * t1724 + 0.20e2 / 0.3e1 * t228 * t230 * t234 + 0.4e1 / 0.3e1 * t809 * t1730) * t610 * t673 / 0.15e2 + 0.2e1 / 0.45e2 * t813 * t857 - 0.8e1 / 0.405e3 * t671 * t672 * t67 + t2348 + t2350 + t2354 + t2360 - t2362 - t2364 - t2366 + t2369 + t2372 - t2374 + t2376
  t2382 = 0.4e1 / 0.5e1 * t683 * t607 * t612 * t927
  t2384 = 0.4e1 / 0.5e1 * t1019 * t733
  t2386 = 0.8e1 / 0.15e2 * t700 * t873
  t2409 = 0.4e1 / 0.15e2 * t613 * t703 * t918
  t2411 = 0.2e1 / 0.5e1 * t700 * t919
  t2414 = 0.4e1 / 0.15e2 * t639 * t703 * t1097
  t2416 = 0.16e2 / 0.15e2 * t923 * t1071
  t2419 = 0.8e1 / 0.15e2 * t682 * t703 * t926
  t2422 = 0.8e1 / 0.45e2 * t682 * t1013 * t684
  t2425 = 0.8e1 / 0.45e2 * t737 * t1013 * t739
  t2426 = t717 ** 2
  t2433 = 0.4e1 / 0.5e1 * t613 * t614 * t616 / t2426 * t1066 * t731
  t2435 = 0.4e1 / 0.5e1 * t700 * t1068
  t2436 = t2382 - t2384 - t2386 + t834 * t800 * t662 + 0.18233333333333333333333333333333333333333333333333e0 * t133 * t2 * t792 * t795 + t787 * t851 * t662 + 0.36466666666666666666666666666666666666666666666665e0 * t842 * t846 + 0.18233333333333333333333333333333333333333333333333e0 * t793 * t34 * t653 * t851 + t654 * (0.10059259259259259259259259259259259259259259259259e0 * t1814 - 0.50074074074074074074074074074074074074074074074075e0 * t1821) * t662 / 0.3e1 - t2409 - t2411 - t2414 + t2416 + t2419 - t2422 - t2425 - t2433 + t2435
  t2437 = t769 ** 2
  t2444 = 0.4e1 / 0.5e1 * t639 * t614 * t641 / t2437 * t1120 * t782
  t2446 = 0.16e2 / 0.15e2 * t1107 * t1125
  t2449 = 0.8e1 / 0.15e2 * t737 * t703 * t1111
  t2450 = t23 * t76
  t2468 = 0.1e1 / t970 / t667
  t2469 = t2468 * t1724
  t2473 = t747 * t1730
  t2477 = t69 * t749
  t2479 = t114 * t1039
  t2481 = t114 * t1031
  t2485 = t30 * t157 * t968 * t2469
  t2488 = t30 * t746 * t2473
  t2492 = -0.22222222222222222222222222222222222222222222222222e-1 * t74 * t779 + 0.13333333333333333333333333333333333333333333333334e-1 * t116 * t1093 + 0.44444444444444444444444444444444444444444444444445e-2 * t116 * t1087 - 0.29629629629629629629629629629629629629629629629629e-2 * t35 * t619 / t633 / t747 * t2469 - 0.66666666666666666666666666666666666666666666666667e-2 * t35 * t778 * t2473 - 0.47988888888888888888888888888888888888888888888888e-1 * t2477 + 0.35991666666666666666666666666666666666666666666666e-1 * t2479 + 0.23994444444444444444444444444444444444444444444444e-1 * t2481 - 0.39990740740740740740740740740740740740740740740742e-1 * t2485 - 0.35991666666666666666666666666666666666666666666667e-1 * t2488 - 0.26666666666666666666666666666666666666666666666667e-1 * t116 * t1090
  t2494 = 0.1e1 / t970 / t151
  t2495 = t2494 * t1724
  t2502 = t971 * t1724
  t2510 = t30 * t1029 * t2495
  t2513 = t30 * t1029 * t2182
  t2516 = t30 * t746 * t2502
  t2519 = t30 * t746 * t2187
  t2521 = t114 * t1035
  t2524 = t347 * t2273 * t633
  t2529 = 0.13333333333333333333333333333333333333333333333333e-1 * t35 * t1086 * t2495 - 0.66666666666666666666666666666666666666666666666666e-2 * t35 * t1086 * t2182 - 0.39999999999999999999999999999999999999999999999999e-1 * t35 * t778 * t2502 + 0.39999999999999999999999999999999999999999999999999e-1 * t35 * t778 * t2187 + 0.14396666666666666666666666666666666666666666666667e0 * t2510 - 0.71983333333333333333333333333333333333333333333335e-1 * t2513 - 0.21595000000000000000000000000000000000000000000000e0 * t2516 + 0.21595000000000000000000000000000000000000000000000e0 * t2519 - 0.71983333333333333333333333333333333333333333333333e-1 * t2521 - 0.11197407407407407407407407407407407407407407407407e0 * t2524 - 0.29629629629629629629629629629629629629629629629629e-1 * t618 * t2278 * t640
  t2534 = 0.2e1 / 0.15e2 * t639 * t614 * t771 * (t2492 + t2529)
  t2538 = 0.4e1 / 0.5e1 * t599 * t1054 * t612 * t685
  t2550 = 0.58774074074074074074074074074074074074074074074074e-2 * t2524 + 0.25188888888888888888888888888888888888888888888889e-2 * t2477 - 0.12594444444444444444444444444444444444444444444445e-2 * t2481 + 0.37783333333333333333333333333333333333333333333335e-2 * t2521 - 0.18891666666666666666666666666666666666666666666667e-2 * t2479 + 0.20990740740740740740740740740740740740740740740742e-2 * t2485 - 0.75566666666666666666666666666666666666666666666669e-2 * t2510 + 0.37783333333333333333333333333333333333333333333335e-2 * t2513 + 0.11335000000000000000000000000000000000000000000000e-1 * t2516 - 0.11335000000000000000000000000000000000000000000000e-1 * t2519 + 0.18891666666666666666666666666666666666666666666667e-2 * t2488
  t2554 = 0.2e1 / 0.15e2 * t631 * t2550 * t612 * t649
  t2555 = t1 * t67
  t2558 = 0.16e2 / 0.405e3 * t639 * t2555 * t648
  t2561 = 0.16e2 / 0.405e3 * t613 * t2555 * t626
  t2563 = 0.8e1 / 0.15e2 * t1010 * t757
  t2575 = 0.58774074074074074074074074074074074074074074074074e-2 * t2275 + 0.25188888888888888888888888888888888888888888888889e-2 * t2258 - 0.12594444444444444444444444444444444444444444444445e-2 * t2262 + 0.37783333333333333333333333333333333333333333333335e-2 * t2300 - 0.18891666666666666666666666666666666666666666666667e-2 * t2260 + 0.20990740740740740740740740740740740740740740740742e-2 * t2266 - 0.75566666666666666666666666666666666666666666666669e-2 * t2303 + 0.37783333333333333333333333333333333333333333333335e-2 * t2306 + 0.11335000000000000000000000000000000000000000000000e-1 * t2309 - 0.11335000000000000000000000000000000000000000000000e-1 * t2312 + 0.18891666666666666666666666666666666666666666666667e-2 * t2269
  t2579 = 0.2e1 / 0.15e2 * t600 * t2575 * t612 * t627
  t2581 = 0.4e1 / 0.45e2 * t700 * t1014
  t2583 = 0.4e1 / 0.45e2 * t754 * t1060
  t2585 = 0.4e1 / 0.15e2 * t1044 * t757
  t2589 = 0.4e1 / 0.5e1 * t1008 * t752 * t612 * t649
  t2593 = 0.4e1 / 0.5e1 * t1017 * t698 * t612 * t627
  t2594 = -t2444 + t2446 + t2449 - 0.66490888888888888888888888888888888888888888888888e-1 * t2450 * t794 + 0.99736333333333333333333333333333333333333333333330e-1 * t107 * t21 * t794 + 0.99736333333333333333333333333333333333333333333330e-1 * t824 * t845 - t2534 + t2538 + t2554 + t2558 + t2561 + t2563 + t2579 - t2581 - t2583 + t2585 + t2589 + t2593
  t2598 = 0.8e1 / 0.15e2 * t1019 * t704
  t2600 = 0.4e1 / 0.15e2 * t1056 * t704
  t2602 = 0.4e1 / 0.15e2 * t956 * t964
  t2604 = 0.4e1 / 0.9e1 * t956 * t974
  t2607 = 0.8e1 / 0.45e2 * t760 * t959 * t963
  t2611 = 0.8e1 / 0.27e2 * t760 * t28 * t968 * t973
  t2615 = 0.4e1 / 0.45e2 * t760 * t763 * t764 * t1730
  t2617 = 0.16e2 / 0.45e2 * t956 * t960
  t2619 = 0.16e2 / 0.45e2 * t977 * t983
  t2623 = 0.8e1 / 0.135e3 * t708 * t43 * t710 * t713
  t2627 = 0.8e1 / 0.135e3 * t760 * t43 * t762 * t765
  t2632 = 0.8e1 / 0.5e1 * t930 * t931 * t1064 * t1066 * t683
  t2637 = 0.8e1 / 0.5e1 * t949 * t950 * t1118 * t1120 * t738
  t2642 = 0.4e1 / 0.5e1 * t949 * t950 * t770 * t1110 * t782
  t2647 = 0.4e1 / 0.5e1 * t930 * t931 * t718 * t917 * t683
  t2652 = 0.4e1 / 0.5e1 * t708 * t931 * t1064 * t917 * t731
  t2660 = 0.32e2 / 0.81e2 * t760 * t15 / t640 / t938 * t647 * t2468 * t1724
  t2661 = t2598 + t2600 + t2602 + t2604 + t2607 + t2611 + t2615 + t2617 + t2619 - t2623 - t2627 + t2632 + t2637 - t2642 - t2647 + t2652 + t2660
  t2663 = 0.8e1 / 0.15e2 * t956 * t941
  t2668 = 0.8e1 / 0.9e1 * t760 * t969 * t647 * t2494 * t1724
  t2670 = 0.8e1 / 0.15e2 * t977 * t946
  t2672 = 0.4e1 / 0.15e2 * t977 * t1129
  t2674 = 0.4e1 / 0.9e1 * t977 * t1137
  t2677 = 0.8e1 / 0.45e2 * t708 * t982 * t1128
  t2681 = 0.8e1 / 0.27e2 * t708 * t28 * t1133 * t1136
  t2685 = 0.4e1 / 0.45e2 * t708 * t711 * t712 * t1719
  t2693 = 0.32e2 / 0.81e2 * t708 * t15 / t615 / t890 * t625 * t2249 * t1712
  t2698 = 0.4e1 / 0.5e1 * t930 * t931 * t718 * t222 * t731
  t2703 = 0.4e1 / 0.5e1 * t949 * t950 * t770 * t1096 * t738
  t2706 = 0.4e1 / 0.15e2 * t1055 * t707 * t714
  t2707 = t1106 * t707
  t2709 = 0.8e1 / 0.5e1 * t2707 * t953
  t2712 = 0.16e2 / 0.45e2 * t760 * t959 * t940
  t2716 = 0.8e1 / 0.15e2 * t760 * t763 * t972 * t1724
  t2719 = 0.16e2 / 0.45e2 * t708 * t982 * t945
  t2723 = 0.8e1 / 0.15e2 * t708 * t711 * t1135 * t1712
  t2727 = 0.16e2 / 0.15e2 * t930 * t28 * t616 * t933
  t2728 = -t2663 - t2668 - t2670 + t2672 + t2674 + t2677 + t2681 + t2685 + t2693 - t2698 - t2703 + t2706 - t2709 - t2712 + t2716 - t2719 + t2723 - t2727
  t2734 = 0.4e1 / 0.5e1 * t760 * t950 * t1118 * t1096 * t782
  t2736 = 0.8e1 / 0.5e1 * t2171 * t934
  t2741 = 0.8e1 / 0.9e1 * t708 * t1134 * t625 * t2285 * t1712
  t2744 = 0.4e1 / 0.15e2 * t1043 * t707 * t766
  t2747 = 0.8e1 / 0.15e2 * t1009 * t707 * t766
  t2750 = 0.8e1 / 0.15e2 * t1018 * t707 * t714
  t2754 = 0.16e2 / 0.15e2 * t949 * t28 * t641 * t952
  t2758 = 0.32e2 / 0.45e2 * t949 * t959 * t647 * t998
  t2763 = 0.16e2 / 0.15e2 * t949 * t996 * t738 * t938 * t231
  t2767 = 0.32e2 / 0.45e2 * t930 * t982 * t625 * t1004
  t2772 = 0.16e2 / 0.15e2 * t930 * t1002 * t683 * t890 * t219
  t2776 = 0.16e2 / 0.45e2 * t760 * t959 * t770 * t987
  t2781 = 0.8e1 / 0.15e2 * t760 * t763 * t1118 * t748 * t1120
  t2785 = 0.8e1 / 0.15e2 * t760 * t986 * t1034 * t782
  t2790 = 0.8e1 / 0.15e2 * t930 * t1002 * t222 * t693 * t218
  t2794 = 0.8e1 / 0.15e2 * t930 * t1002 * t1003 * t223
  t2799 = 0.8e1 / 0.9e1 * t930 * t2174 * t683 * t884 * t219
  t2804 = 0.4e1 / 0.9e1 * t760 * t969 * t770 * t1030 * t782
  t2805 = t2734 - t2736 - t2741 + t2744 + t2747 + t2750 - t2754 + t2758 - t2763 + t2767 - t2772 - t2776 + t2781 + t2785 + t2790 + t2794 + t2799 - t2804
  t2807 = 0.8e1 / 0.15e2 * t977 * t993
  t2809 = 0.8e1 / 0.15e2 * t956 * t988
  t2813 = 0.4e1 / 0.15e2 * t760 * t986 * t1038 * t782
  t2817 = 0.4e1 / 0.15e2 * t760 * t986 * t748 * t1096
  t2821 = 0.4e1 / 0.15e2 * t708 * t991 * t895 * t731
  t2825 = 0.4e1 / 0.15e2 * t708 * t991 * t694 * t917
  t2830 = 0.4e1 / 0.9e1 * t708 * t1134 * t718 * t885 * t731
  t2832 = 0.16e2 / 0.15e2 * t2707 * t999
  t2837 = 0.8e1 / 0.15e2 * t949 * t996 * t1110 * t747 * t230
  t2841 = 0.8e1 / 0.15e2 * t949 * t996 * t997 * t234
  t2846 = 0.8e1 / 0.9e1 * t949 * t2180 * t738 * t971 * t231
  t2855 = 0.16e2 / 0.15e2 * t736 * t610 * t673 * t762 * t770 * t747 * t230 * t782 * t738
  t2864 = 0.16e2 / 0.15e2 * t681 * t610 * t673 * t710 * t718 * t693 * t218 * t731 * t683
  t2868 = 0.8e1 / 0.15e2 * t708 * t991 * t891 * t731
  t2871 = 0.4e1 / 0.45e2 * t613 * t1013 * t732
  t2874 = 0.8e1 / 0.15e2 * t613 * t703 * t1067
  t2879 = -0.4e1 / 0.15e2 * t682 * t614 * t626 * t2356
  t2881 = 0.4e1 / 0.5e1 * t923 * t927
  t2882 = -t2807 - t2809 - t2813 - t2817 - t2821 - t2825 - t2830 + t2832 + t2837 + t2841 + t2846 - t2855 - t2864 + t2868 + t2871 + t2874 + t2879 + t2881
  t2902 = t27 * t93
  t2906 = (-0.53666666666666666666666666666666666666666666666667e-2 * t1814 - 0.60688888888888888888888888888888888888888888888888e-1 * t1821 + 0.57465000000000000000000000000000000000000000000000e-1 * t1876 - 0.36147222222222222222222222222222222222222222222223e-2 * t41 * t2902) * t49
  t2928 = t2906 / 0.2e1 + 0.94050000000000000000000000000000000000000000000000e-1 * t84 * t1 * t6 * t534 - 0.12540000000000000000000000000000000000000000000000e0 * t553 * t556 + 0.23587740000000000000000000000000000000000000000000e-1 * t122 * t2 * t7 * t561 + 0.97533333333333333333333333333333333333333333333333e-1 * t533 * t81 * t49 - 0.31450320000000000000000000000000000000000000000000e-1 * t560 * t18 * t49 + 0.59158051920000000000000000000000000000000000000000e-2 * t47 * t5 * t130 * t49
  t2955 = 0.15788919698298053987074801337637751567500000000000e1 * t1876 * t581 - 0.50668035746616956918102410392313943146408695844103e-1 * t142 * t17 * t819 * jnp.pi + 0.19000513404981358844288403897117728679903260941539e-1 * t142 * t72 * t1142 * jnp.pi + 0.42708890021612718670335112500000000000000000000000e0 * t41 * t44 * t2165 - 0.38001026809962717688576807794235457359806521883077e-2 * t142 * t62 * (t2229 + t2377 + t2436 + t2594 + t2661 + t2728 + t2805 + t2882) * jnp.pi + 0.39861630686838537425646105000000000000000000000000e1 * t41 * t81 * t489 - 0.78944598491490269935374006688188757837500000000000e0 * t38 * t133 * t537 - 0.78944598491490269935374006688188757837500000000000e0 * t38 * t107 * t564 - 0.26314866163830089978458002229396252612500000000000e0 * t38 * t23 * t2928 - 0.15788919698298053987074801337637751567500000000000e1 * t77 * t584 - 0.15788919698298053987074801337637751567500000000000e1 * t77 * t587 + 0.78944598491490269935374006688188757837500000000000e0 * t118 * t590 + 0.15788919698298053987074801337637751567500000000000e1 * t118 * t593 + 0.78944598491490269935374006688188757837500000000000e0 * t118 * t596 - 0.26314866163830089978458002229396252612500000000000e0 * t38 * t2236 * t521 - 0.17083556008645087468134045000000000000000000000000e1 * t41 * t68 * t471 + 0.61927599245865169566569612701717041623388406031679e-1 * t142 * t495 * t676 * jnp.pi - 0.44290700763153930472940116666666666666666666666667e1 * t41 * t2902 * t499
  t2977 = 0.1e1 / t15 / t208
  t3029 = t4 * t209
  t3038 = 0.16514026465564045217751896720457877766236908275114e0 * t142 * t495 * t23 * t522 - 0.13511476199097855178160642771283718172375652225094e0 * t142 * t17 * t107 * t522 - 0.13511476199097855178160642771283718172375652225094e0 * t142 * t519 * t538 + 0.50668035746616956918102410392313943146408695844101e-1 * t142 * t72 * t133 * t522 + 0.10133607149323391383620482078462788629281739168820e0 * t142 * t526 * t538 + 0.50668035746616956918102410392313943146408695844101e-1 * t142 * t530 * t565 - 0.10133607149323391383620482078462788629281739168820e-1 * t142 * t62 * t2236 * t522 - 0.30400821447970174150861446235388365887845217506460e-1 * t142 * t542 * t538 - 0.30400821447970174150861446235388365887845217506460e-1 * t142 * t546 * t565 - 0.10133607149323391383620482078462788629281739168820e-1 * t142 * t550 * t2928 * jnp.pi - 0.12631135758638443189659841070110201254000000000000e2 * t3029 * t499 + 0.94733518189788323922448808025826509405000000000000e1 * t569 * t489 - 0.31577839396596107974149602675275503135000000000000e1 * t572 * t471 + 0.52629732327660179956916004458792505225000000000000e0 * t575 * t2165
  t3043 = t1419 ** 2
  t3083 = t90 * t209 * t23
  t3101 = 0.10999614056480977610995444931887633592025000000000e0 * t1173 * t1196 * t1177 + 0.19310922437558004293863603122421929534159090000000e-1 * t1159 * t495 * t95 * t1204 - 0.32998842169442932832986334795662900776075000000000e-1 * t1187 * t133 * t47 * t1177 - 0.65997684338885865665972669591325801552150000000000e-1 * t1187 * t107 * t122 * t1177 - 0.82761096160962875545129727667522555146396100000000e-2 * t1200 * t1188 * t1204 - 0.32998842169442932832986334795662900776075000000000e-1 * t1187 * t23 * t84 * t1177 - 0.82761096160962875545129727667522555146396100000000e-2 * t1200 * t1196 * t1204 - 0.20756482917169489186718535699014656830716141880000e-2 * t3083 * t1162 - 0.14421716207386170645527361132919341820655000000000e0 * t1159 * t93 * t95 * t1177 + 0.10999614056480977610995444931887633592025000000000e0 * t1173 * t1188 * t1177 + 0.15200410723985087075430723117694182943922608753231e-1 * t142 * t72 * t1283 * t53 + 0.10525946465532035991383200891758501045000000000000e1 * t1159 * t130 * t23 * t1162
  t3106 = -t2170 + t2173 + t2179 + t2185 - t2190 - t2195 - t2199 + t2204 - t2319 + t2348 + t2350 + t2354 + t2360 - t2362 - t2364 - t2366
  t3107 = t2369 + t2372 - t2374 + t2376 + t2382 - t2384 - t2386 - t2409 - t2411 - t2414 + t2416 + t2419 - t2422 - t2425 - t2433 + t2435 - t2444
  t3132 = t2446 + t2449 - t2534 + t2538 + 0.4e1 * t1252 * t1235 + 0.4e1 * t1222 * t1249 + 0.4e1 / 0.3e1 * t1209 * (0.12833333333333333333333333333333333333333333333333e1 * t1814 - 0.20e2 / 0.27e2 * t1821) * jnp.pi * t11 + 0.4e1 / 0.3e1 * t2236 * t1208 * t1214 + t2554 + t2558 + t2561 + t2563 - 0.30617283950617283950617283950617283950617283950617e-1 * t1226 * t67 * t1208 * t1213 + t2579 - t2581 + 0.68888888888888888888888888888888888888888888888888e-1 * t1270 * t1263 + 0.68888888888888888888888888888888888888888888888888e-1 * t1226 * t1262 * t1234
  t3161 = -0.35592592592592592592592592592592592592592592592590e-2 * t1257 * t72 * t1208 * t1213 + 0.10333333333333333333333333333333333333333333333333e0 * t133 * t1 * t98 * t1228 + 0.20666666666666666666666666666666666666666666666667e0 * t1270 * t1273 + 0.10677777777777777777777777777777777777777777777777e-1 * t841 * t288 * t1259 + 0.10333333333333333333333333333333333333333333333333e0 * t1226 * t1227 * t1248 + 0.10677777777777777777777777777777777777777777777777e-1 * t1257 * t1258 * t1234 - t2583 + t2585 + t2589 + t2593 + t2598 + t2600 + 0.4e1 * t1252 * t1213 + 0.8e1 * t1222 * t1234 + 0.11033703703703703703703703703703703703703703703703e-2 * t2450 * t1208 * t1212 + 0.4e1 * t1209 * t1248 + t2602
  t3164 = t2604 + t2607 + t2611 + t2615 + t2617 + t2619 - t2623 - t2627 + t2632 + t2637 - t2642 - t2647 + t2652 + t2660 - t2663 - t2668 - t2670
  t3165 = t2672 + t2674 + t2677 + t2681 + t2685 + t2693 - t2698 - t2703 + t2706 - t2709 - t2712 + t2716 - t2719 + t2723 - t2727 + t2734 - t2736
  t3167 = -t2741 + t2744 + t2747 + t2750 - t2754 + t2758 - t2763 + t2767 - t2772 - t2776 + t2781 + t2785 + t2790 + t2794 + t2799 - t2804 - t2807
  t3168 = -t2809 - t2813 - t2817 - t2821 - t2825 - t2830 + t2832 + t2837 + t2841 + t2846 - t2855 - t2864 + t2868 + t2871 + t2874 + t2879 + t2881
  t3202 = -0.40534428597293565534481928313851154517126956675283e-1 * t142 * t17 * t1240 * t53 - 0.30400821447970174150861446235388365887845217506462e-2 * t142 * t62 * (t3106 + t3107 + t3132 + t3161 + t3164 + t3165 + t3167 + t3168) * t53 - 0.17543244109220059985638668152930835075000000000000e0 * t1192 * t2906 * t51 + 0.52629732327660179956916004458792505225000000000000e0 * t1169 * t1193 - 0.17543244109220059985638668152930835075000000000000e0 * t1180 * t2236 * t1162 - 0.52629732327660179956916004458792505225000000000000e0 * t1181 * t1170 - 0.52629732327660179956916004458792505225000000000000e0 * t1184 * t1193 - 0.10525946465532035991383200891758501045000000000000e1 * t1160 * t107 * t1162 - 0.10525946465532035991383200891758501045000000000000e1 * t1161 * t1170 + 0.52629732327660179956916004458792505225000000000000e0 * t1165 * t133 * t1162 + 0.10525946465532035991383200891758501045000000000000e1 * t1166 * t1170 + 0.49542079396692135653255690161373633298710724825345e-1 * t142 * t495 * t1217 * t53
  t3208 = -0.92478548207158653219410621634564115490926686340644e0 * t142 * t2977 * t499 * t473 - 0.9e1 * t1476 * t1464 * t1486 * t1399 * t4 * t1313 * t1419 - t1465 * t1487 * t4 * t1391 - 0.20267214298646782767240964156925577258563478337641e-1 * t139 * t86 + t3038 * t579 + 0.2e1 * t1465 / t1485 / t1437 * t1399 * t4 * t3043 + 0.9e1 * t1480 * t1466 * t1481 - 0.2e1 * t1457 * t1489 + 0.9e1 * t1480 * t1459 * t4 * t1337 + (t3101 + t3202) * t1289 - 0.67557380995489275890803213856418590861878261125470e-2 * t65 * t2906 * t57
  t3283 = -0.90076507993985701187737618475224787815837681500624e-1 * t9 * t18 * t107 * t58 - 0.90076507993985701187737618475224787815837681500624e-1 * t25 * t124 + 0.3e1 * t1476 * t1472 * t1733 - 0.2e1 * t1465 * t1486 * t1428 * t1488 + 0.18e2 * t1469 * t1464 * t1459 * t4 * t1323 - 0.11747417866543639206099989251064915927790287070586e0 * t3083 * t507 - 0.15249052038301839354072101431670804329343161101241e-1 * t515 * t85 * t506 + 0.71162242845408583652336473347797086870268085139125e-1 * t504 * t107 * t507 + 0.71162242845408583652336473347797086870268085139125e-1 * t505 * t516 - 0.15249052038301839354072101431670804329343161101241e-1 * t511 * t133 * t507 - 0.30498104076603678708144202863341608658686322202483e-1 * t512 * t516
  t3287 = -t1661 + t1663 + t1665 + t1668 - t1671 + t1674 + t1677 - t1680 + t1683 - t1686 + t1689 + t1692 - t1695 - (0.6e1 * t1696 * t1297 * t1472 + 0.2e1 * t1457 * t1467 + t1298 * ((t1782 + t1828) * t1400 - 0.3e1 * t1391 * t1421 * t1428 + 0.6e1 * t1419 * t1439 * t1441 - 0.3e1 * t1422 * t1454 - 0.6e1 * t1437 / t1839 * t1441 * t1428 + 0.6e1 * t1440 * t1428 * t1454 - t1444 * t1867) * t1460 + 0.59450495276030562783906828193648359958452869790413e0 * t142 * t495 * t489 * t473 + t2955 * t55 + 0.20267214298646782767240964156925577258563478337641e-1 * t142 * t72 * t2165 * t473 + t1465 * t1458 * t1454 * t4 + 0.18e2 * t1469 * t1471 * t1481 * t1337 - 0.16213771438917426213792771325540461806850782670113e0 * t142 * t17 * t471 * t473 + 0.9e1 * t1476 * t1456 * t1482 + t3208 - 0.95611556280152532750032075976575943144981620104783e-3 * t94 * t1188 * t1 * t101 - 0.95611556280152532750032075976575943144981620104783e-3 * t94 * t1196 * t1 * t101 - 0.79931261050207517379026815516417488469204634407598e-4 * t90 * t2977 * t95 * t2 * t288 * t100 + 0.28683466884045759825009622792972782943494486031434e-2 * t90 / t14 / t208 * t96 * t101 + 0.11009350977042696811834597813638585177491272183410e0 * t9 * t10 * t495 * t23 * t58 + 0.33778690497744637945401606928209295430939130562734e-1 * t113 * t86 + 0.33778690497744637945401606928209295430939130562734e-1 * t9 * t73 * t133 * t58 + 0.67557380995489275890803213856418590861878261125469e-1 * t109 * t124 - 0.67557380995489275890803213856418590861878261125470e-2 * t9 * t63 * t2236 * t58 - 0.20267214298646782767240964156925577258563478337641e-1 * t135 * t124 + t3283) * t1499
  t3302 = t1896 - t1900 + t1904 - t1907 + t1911 + 0.31636214830824236052100083333333333333333333333334e1 * t1547 * t1548 * t93 * t55 + 0.20538164420033333333333333333333333333333333333334e1 * t1631 * t1541 - 0.18256146151140740740740740740740740740740740740741e1 * t1539 * t288 * t17 * t54 + t1913 + t1937 - 0.18981728898494541631260050000000000000000000000001e1 * t1629 * t1545 * t1 * t1550 + t1939 + t2090 + t2044
  t3304 = t2093 + t2095 + t2099 - t2103 + t2107 - t2110 - t2114 + t2068 - t2118 - t2120 - t2124 - t2126 - t2129 - t2133
  t3316 = t2138 + t2140 - t2074 + t2086 - 0.12322898652020000000000000000000000000000000000000e1 * t1492 * t1537 * t2 * t1633 + t2143 + t2145 - t2147 - t2149 - t2151 - t2156 + t2158 - t2160 + t2162 - 0.46781984291253493295036448407815560200000000000002e1 * t1535 / t1498 / t1497 / t1496 * t3029 * t579
  t3320 = -0.24e2 * t449 + 0.24e2 * t452 + 0.36e2 * t205 - 0.96e2 * t211 + 0.6e1 * t442 - 0.24e2 * t446 + 0.24e2 * t454 + 0.60e2 * t459 + 0.3e1 * t424 - 0.60000000000000000000000000000000000000000000000000e1 * t396 + 0.30000000000000000000000000000000000000000000000000e1 * t325 + 0.48245472966453314463992795342703676305040043742564e2 * t339 + 0.59255369107695618686477328484766255283138811676094e-1 * t241 + t11 * (t3287 + t3302 + t3304 + t3316)
  d111 = t1646 + t3320

  res = {'v3rho3': d111}
  return res
