"""Generated from lda_k_zlp.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  f_zeta_k = lambda z: 1 / 2 * (f.opz_pow_n(z, 5 / 3) + f.opz_pow_n(-z, 5 / 3))

  c1 = 3.2372 * f.RS_FACTOR

  c2 = 0.00196 * f.RS_FACTOR

  functional_body = lambda rs, zeta: c1 * f_zeta_k(zeta) / rs ** 2 * (1 - c2 / rs * jnp.log(1 + rs / c2))

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  f_zeta_k = lambda z: 1 / 2 * (f.opz_pow_n(z, 5 / 3) + f.opz_pow_n(-z, 5 / 3))

  c1 = 3.2372 * f.RS_FACTOR

  c2 = 0.00196 * f.RS_FACTOR

  functional_body = lambda rs, zeta: c1 * f_zeta_k(zeta) / rs ** 2 * (1 - c2 / rs * jnp.log(1 + rs / c2))

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  f_zeta_k = lambda z: 1 / 2 * (f.opz_pow_n(z, 5 / 3) + f.opz_pow_n(-z, 5 / 3))

  c1 = 3.2372 * f.RS_FACTOR

  c2 = 0.00196 * f.RS_FACTOR

  functional_body = lambda rs, zeta: c1 * f_zeta_k(zeta) / rs ** 2 * (1 - c2 / rs * jnp.log(1 + rs / c2))

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t4 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t5 = 0.1e1 / t4
  t7 = 4 ** (0.1e1 / 0.3e1)
  t9 = r0 - r1
  t10 = r0 + r1
  t11 = 0.1e1 / t10
  t12 = t9 * t11
  t13 = 0.1e1 + t12
  t14 = t13 <= f.p.zeta_threshold
  t15 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t16 = t15 ** 2
  t17 = t16 * f.p.zeta_threshold
  t18 = t13 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = f.my_piecewise3(t14, t17, t19 * t13)
  t22 = 0.1e1 - t12
  t23 = t22 <= f.p.zeta_threshold
  t24 = t22 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t27 = f.my_piecewise3(t23, t17, t25 * t22)
  t29 = t21 / 0.2e1 + t27 / 0.2e1
  t30 = t10 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t35 = 0.1e1 + 0.51020408163265306122448979591836734693877551020408e3 / t30
  t36 = jnp.log(t35)
  t39 = 0.1e1 - 0.19600000000000000000000000000000000000000000000000e-2 * t30 * t36
  t42 = 0.17984444444444444444444444444444444444444444444445e1 * t2 * t5 * t7 * t29 * t31 * t39
  t45 = t31 * t10 * t2 * t5
  t46 = t10 ** 2
  t48 = t9 / t46
  t49 = t11 - t48
  t52 = f.my_piecewise3(t14, 0, 0.5e1 / 0.3e1 * t19 * t49)
  t56 = f.my_piecewise3(t23, 0, -0.5e1 / 0.3e1 * t25 * t49)
  t73 = 0.10790666666666666666666666666666666666666666666667e1 * t45 * t7 * t29 * (-0.65333333333333333333333333333333333333333333333333e-3 / t31 * t36 + 0.33333333333333333333333333333333333333333333333334e0 * t11 / t35)
  vrho_0_ = t42 + 0.10790666666666666666666666666666666666666666666667e1 * t45 * t7 * (t52 / 0.2e1 + t56 / 0.2e1) * t39 + t73
  t74 = -t11 - t48
  t77 = f.my_piecewise3(t14, 0, 0.5e1 / 0.3e1 * t19 * t74)
  t81 = f.my_piecewise3(t23, 0, -0.5e1 / 0.3e1 * t25 * t74)
  vrho_1_ = t42 + 0.10790666666666666666666666666666666666666666666667e1 * t45 * t7 * (t77 / 0.2e1 + t81 / 0.2e1) * t39 + t73
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  f_zeta_k = lambda z: 1 / 2 * (f.opz_pow_n(z, 5 / 3) + f.opz_pow_n(-z, 5 / 3))

  c1 = 3.2372 * f.RS_FACTOR

  c2 = 0.00196 * f.RS_FACTOR

  functional_body = lambda rs, zeta: c1 * f_zeta_k(zeta) / rs ** 2 * (1 - c2 / rs * jnp.log(1 + rs / c2))

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t4 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t5 = 0.1e1 / t4
  t7 = 4 ** (0.1e1 / 0.3e1)
  t10 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t11 = t10 ** 2
  t13 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t11 * f.p.zeta_threshold, 1)
  t14 = r0 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t19 = 0.1e1 + 0.51020408163265306122448979591836734693877551020408e3 / t14
  t20 = jnp.log(t19)
  vrho_0_ = 0.17984444444444444444444444444444444444444444444445e1 * t2 * t5 * t7 * t13 * t15 * (0.1e1 - 0.19600000000000000000000000000000000000000000000000e-2 * t14 * t20) + 0.10790666666666666666666666666666666666666666666667e1 * t15 * r0 * t2 * t5 * t7 * t13 * (-0.65333333333333333333333333333333333333333333333333e-3 / t15 * t20 + 0.33333333333333333333333333333333333333333333333334e0 / r0 / t19)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  res = {'vrho': vrho_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / t1
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t7 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t7
  t10 = 4 ** (0.1e1 / 0.3e1)
  t12 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t13 = t12 ** 2
  t15 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, 1)
  t16 = t10 * t15
  t18 = 0.1e1 + 0.51020408163265306122448979591836734693877551020408e3 * t2
  t19 = jnp.log(t18)
  t26 = t1 ** 2
  t33 = 0.1e1 / t18
  t40 = t26 * r0
  t46 = r0 ** 2
  t52 = t18 ** 2
  v2rho2_0_ = 0.11989629629629629629629629629629629629629629629630e1 * t2 * t4 * t8 * t16 * (0.1e1 - 0.19600000000000000000000000000000000000000000000000e-2 * t1 * t19) + 0.35968888888888888888888888888888888888888888888890e1 * t26 * t4 * t8 * t16 * (-0.65333333333333333333333333333333333333333333333333e-3 / t26 * t19 + 0.33333333333333333333333333333333333333333333333334e0 / r0 * t33) + 0.10790666666666666666666666666666666666666666666667e1 * t40 * t4 * t8 * t16 * (0.43555555555555555555555555555555555555555555555555e-3 / t40 * t19 - 0.22222222222222222222222222222222222222222222222223e0 / t46 * t33 + 0.56689342403628117913832199546485260770975056689344e2 / t1 / t46 / t52)
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** (0.1e1 / 0.3e1)
  t4 = 3 ** (0.1e1 / 0.3e1)
  t5 = t4 ** 2
  t8 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t8
  t11 = 4 ** (0.1e1 / 0.3e1)
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t14 = t13 ** 2
  t16 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t14 * f.p.zeta_threshold, 1)
  t17 = t11 * t16
  t18 = 0.1e1 / t1
  t20 = 0.1e1 + 0.51020408163265306122448979591836734693877551020408e3 * t18
  t21 = jnp.log(t20)
  t30 = t1 ** 2
  t35 = 0.1e1 / t20
  t44 = t30 * r0
  t48 = r0 ** 2
  t54 = t20 ** 2
  t55 = 0.1e1 / t54
  t68 = t48 * r0
  v3rho3_0_ = -0.39965432098765432098765432098765432098765432098767e0 / t1 / r0 * t5 * t9 * t17 * (0.1e1 - 0.19600000000000000000000000000000000000000000000000e-2 * t1 * t21) + 0.35968888888888888888888888888888888888888888888890e1 * t18 * t5 * t9 * t17 * (-0.65333333333333333333333333333333333333333333333333e-3 / t30 * t21 + 0.33333333333333333333333333333333333333333333333334e0 / r0 * t35) + 0.53953333333333333333333333333333333333333333333335e1 * t30 * t5 * t9 * t17 * (0.43555555555555555555555555555555555555555555555555e-3 / t44 * t21 - 0.22222222222222222222222222222222222222222222222223e0 / t48 * t35 + 0.56689342403628117913832199546485260770975056689344e2 / t1 / t48 * t55) + 0.10790666666666666666666666666666666666666666666667e1 * t44 * t5 * t9 * t17 * (-0.72592592592592592592592592592592592592592592592592e-3 / t30 / t48 * t21 + 0.37037037037037037037037037037037037037037037037039e0 / t68 * t35 - 0.17006802721088435374149659863945578231292517006804e3 / t1 / t68 * t55 + 0.19282089252934733984296666512409952643188794792294e5 / t30 / t68 / t54 / t20)

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** 2
  t2 = r0 ** (0.1e1 / 0.3e1)
  t4 = 0.1e1 / t2 / t1
  t5 = 3 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t9 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t9
  t12 = 4 ** (0.1e1 / 0.3e1)
  t14 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t15 * f.p.zeta_threshold, 1)
  t18 = t12 * t17
  t19 = 0.1e1 / t2
  t21 = 0.1e1 + 0.51020408163265306122448979591836734693877551020408e3 * t19
  t22 = jnp.log(t21)
  t33 = t2 ** 2
  t38 = 0.1e1 / t21
  t47 = t33 * r0
  t54 = t21 ** 2
  t55 = 0.1e1 / t54
  t68 = t1 * r0
  t77 = 0.1e1 / t33 / t68
  t79 = 0.1e1 / t54 / t21
  t90 = t1 ** 2
  t104 = t54 ** 2
  v4rho4_0_ = 0.53287242798353909465020576131687242798353909465023e0 * t4 * t6 * t10 * t18 * (0.1e1 - 0.19600000000000000000000000000000000000000000000000e-2 * t2 * t22) - 0.15986172839506172839506172839506172839506172839507e1 / t2 / r0 * t6 * t10 * t18 * (-0.65333333333333333333333333333333333333333333333333e-3 / t33 * t22 + 0.33333333333333333333333333333333333333333333333334e0 / r0 * t38) + 0.71937777777777777777777777777777777777777777777780e1 * t19 * t6 * t10 * t18 * (0.43555555555555555555555555555555555555555555555555e-3 / t47 * t22 - 0.22222222222222222222222222222222222222222222222223e0 / t1 * t38 + 0.56689342403628117913832199546485260770975056689344e2 * t4 * t55) + 0.71937777777777777777777777777777777777777777777780e1 * t33 * t6 * t10 * t18 * (-0.72592592592592592592592592592592592592592592592592e-3 / t33 / t1 * t22 + 0.37037037037037037037037037037037037037037037037039e0 / t68 * t38 - 0.17006802721088435374149659863945578231292517006804e3 / t2 / t68 * t55 + 0.19282089252934733984296666512409952643188794792294e5 * t77 * t79) + 0.10790666666666666666666666666666666666666666666667e1 * t47 * t6 * t10 * t18 * (0.19358024691358024691358024691358024691358024691358e-2 * t77 * t22 - 0.98765432098765432098765432098765432098765432098774e0 / t90 * t38 + 0.62988158226253464348702443940539178634416729654830e3 / t2 / t90 * t55 - 0.12854726168623155989531111008273301762125863194863e6 / t33 / t90 * t79 + 0.98378006392524152981105441389846697159126504042318e7 / t90 / r0 / t104)

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 + r1
  t2 = t1 ** (0.1e1 / 0.3e1)
  t3 = 0.1e1 / t2
  t4 = 3 ** (0.1e1 / 0.3e1)
  t5 = t4 ** 2
  t8 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t8
  t11 = 4 ** (0.1e1 / 0.3e1)
  t12 = r0 - r1
  t13 = 0.1e1 / t1
  t14 = t12 * t13
  t15 = 0.1e1 + t14
  t16 = t15 <= f.p.zeta_threshold
  t17 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t19 = t18 * f.p.zeta_threshold
  t20 = t15 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t23 = f.my_piecewise3(t16, t19, t21 * t15)
  t24 = 0.1e1 - t14
  t25 = t24 <= f.p.zeta_threshold
  t26 = t24 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t29 = f.my_piecewise3(t25, t19, t27 * t24)
  t32 = t11 * (t23 / 0.2e1 + t29 / 0.2e1)
  t34 = 0.1e1 + 0.51020408163265306122448979591836734693877551020408e3 * t3
  t35 = jnp.log(t34)
  t38 = 0.1e1 - 0.19600000000000000000000000000000000000000000000000e-2 * t2 * t35
  t41 = 0.11989629629629629629629629629629629629629629629630e1 * t3 * t5 * t9 * t32 * t38
  t42 = t2 ** 2
  t44 = t42 * t5 * t9
  t45 = t1 ** 2
  t46 = 0.1e1 / t45
  t47 = t12 * t46
  t48 = t13 - t47
  t51 = f.my_piecewise3(t16, 0, 0.5e1 / 0.3e1 * t21 * t48)
  t52 = -t48
  t55 = f.my_piecewise3(t25, 0, 0.5e1 / 0.3e1 * t27 * t52)
  t58 = t11 * (t51 / 0.2e1 + t55 / 0.2e1)
  t60 = t44 * t58 * t38
  t65 = 0.1e1 / t34
  t68 = -0.65333333333333333333333333333333333333333333333333e-3 / t42 * t35 + 0.33333333333333333333333333333333333333333333333334e0 * t13 * t65
  t71 = 0.35968888888888888888888888888888888888888888888890e1 * t44 * t32 * t68
  t72 = t42 * t1
  t74 = t72 * t5 * t9
  t75 = 0.1e1 / t20
  t76 = t48 ** 2
  t80 = 0.1e1 / t45 / t1
  t81 = t12 * t80
  t83 = -0.2e1 * t46 + 0.2e1 * t81
  t87 = f.my_piecewise3(t16, 0, 0.10e2 / 0.9e1 * t75 * t76 + 0.5e1 / 0.3e1 * t21 * t83)
  t88 = 0.1e1 / t26
  t89 = t52 ** 2
  t96 = f.my_piecewise3(t25, 0, 0.10e2 / 0.9e1 * t88 * t89 - 0.5e1 / 0.3e1 * t27 * t83)
  t104 = t74 * t58 * t68
  t113 = t34 ** 2
  t120 = 0.10790666666666666666666666666666666666666666666667e1 * t74 * t32 * (0.43555555555555555555555555555555555555555555555555e-3 / t72 * t35 - 0.22222222222222222222222222222222222222222222222223e0 * t46 * t65 + 0.56689342403628117913832199546485260770975056689344e2 / t2 / t45 / t113)
  d11 = t41 + 0.35968888888888888888888888888888888888888888888890e1 * t60 + t71 + 0.10790666666666666666666666666666666666666666666667e1 * t74 * t11 * (t87 / 0.2e1 + t96 / 0.2e1) * t38 + 0.21581333333333333333333333333333333333333333333334e1 * t104 + t120
  t122 = -t13 - t47
  t125 = f.my_piecewise3(t16, 0, 0.5e1 / 0.3e1 * t21 * t122)
  t126 = -t122
  t129 = f.my_piecewise3(t25, 0, 0.5e1 / 0.3e1 * t27 * t126)
  t132 = t11 * (t125 / 0.2e1 + t129 / 0.2e1)
  t134 = t44 * t132 * t38
  t143 = f.my_piecewise3(t16, 0, 0.10e2 / 0.9e1 * t75 * t122 * t48 + 0.10e2 / 0.3e1 * t21 * t12 * t80)
  t151 = f.my_piecewise3(t25, 0, 0.10e2 / 0.9e1 * t88 * t126 * t52 - 0.10e2 / 0.3e1 * t27 * t12 * t80)
  t159 = t74 * t132 * t68
  d12 = t41 + 0.17984444444444444444444444444444444444444444444445e1 * t60 + t71 + 0.17984444444444444444444444444444444444444444444445e1 * t134 + 0.10790666666666666666666666666666666666666666666667e1 * t74 * t11 * (t143 / 0.2e1 + t151 / 0.2e1) * t38 + 0.10790666666666666666666666666666666666666666666667e1 * t159 + 0.10790666666666666666666666666666666666666666666667e1 * t104 + t120
  t163 = t122 ** 2
  t167 = 0.2e1 * t46 + 0.2e1 * t81
  t171 = f.my_piecewise3(t16, 0, 0.10e2 / 0.9e1 * t75 * t163 + 0.5e1 / 0.3e1 * t21 * t167)
  t172 = t126 ** 2
  t179 = f.my_piecewise3(t25, 0, 0.10e2 / 0.9e1 * t88 * t172 - 0.5e1 / 0.3e1 * t27 * t167)
  d22 = t41 + 0.35968888888888888888888888888888888888888888888890e1 * t134 + t71 + 0.10790666666666666666666666666666666666666666666667e1 * t74 * t11 * (t171 / 0.2e1 + t179 / 0.2e1) * t38 + 0.21581333333333333333333333333333333333333333333334e1 * t159 + t120
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = r0 + r1
  t2 = t1 ** (0.1e1 / 0.3e1)
  t5 = 3 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t9 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t9
  t12 = 4 ** (0.1e1 / 0.3e1)
  t13 = r0 - r1
  t14 = 0.1e1 / t1
  t15 = t13 * t14
  t16 = 0.1e1 + t15
  t17 = t16 <= f.p.zeta_threshold
  t18 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t20 = t19 * f.p.zeta_threshold
  t21 = t16 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = f.my_piecewise3(t17, t20, t22 * t16)
  t25 = 0.1e1 - t15
  t26 = t25 <= f.p.zeta_threshold
  t27 = t25 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t30 = f.my_piecewise3(t26, t20, t28 * t25)
  t33 = t12 * (t24 / 0.2e1 + t30 / 0.2e1)
  t34 = 0.1e1 / t2
  t36 = 0.1e1 + 0.51020408163265306122448979591836734693877551020408e3 * t34
  t37 = jnp.log(t36)
  t40 = 0.1e1 - 0.19600000000000000000000000000000000000000000000000e-2 * t2 * t37
  t45 = t34 * t6 * t10
  t46 = t1 ** 2
  t47 = 0.1e1 / t46
  t49 = -t13 * t47 + t14
  t52 = f.my_piecewise3(t17, 0, 0.5e1 / 0.3e1 * t22 * t49)
  t53 = -t49
  t56 = f.my_piecewise3(t26, 0, 0.5e1 / 0.3e1 * t28 * t53)
  t59 = t12 * (t52 / 0.2e1 + t56 / 0.2e1)
  t63 = t2 ** 2
  t67 = 0.1e1 / t36
  t70 = -0.65333333333333333333333333333333333333333333333333e-3 / t63 * t37 + 0.33333333333333333333333333333333333333333333333334e0 * t14 * t67
  t75 = t63 * t6 * t10
  t76 = 0.1e1 / t21
  t77 = t49 ** 2
  t80 = t46 * t1
  t81 = 0.1e1 / t80
  t84 = 0.2e1 * t13 * t81 - 0.2e1 * t47
  t88 = f.my_piecewise3(t17, 0, 0.10e2 / 0.9e1 * t76 * t77 + 0.5e1 / 0.3e1 * t22 * t84)
  t89 = 0.1e1 / t27
  t90 = t53 ** 2
  t93 = -t84
  t97 = f.my_piecewise3(t26, 0, 0.10e2 / 0.9e1 * t89 * t90 + 0.5e1 / 0.3e1 * t28 * t93)
  t100 = t12 * (t88 / 0.2e1 + t97 / 0.2e1)
  t107 = t63 * t1
  t115 = t36 ** 2
  t116 = 0.1e1 / t115
  t119 = 0.43555555555555555555555555555555555555555555555555e-3 / t107 * t37 - 0.22222222222222222222222222222222222222222222222223e0 * t47 * t67 + 0.56689342403628117913832199546485260770975056689344e2 / t2 / t46 * t116
  t124 = t107 * t6 * t10
  t133 = t46 ** 2
  t137 = 0.6e1 * t81 - 0.6e1 * t13 / t133
  t141 = f.my_piecewise3(t17, 0, -0.10e2 / 0.27e2 / t21 / t16 * t77 * t49 + 0.10e2 / 0.3e1 * t76 * t49 * t84 + 0.5e1 / 0.3e1 * t22 * t137)
  t154 = f.my_piecewise3(t26, 0, -0.10e2 / 0.27e2 / t27 / t25 * t90 * t53 + 0.10e2 / 0.3e1 * t89 * t53 * t93 - 0.5e1 / 0.3e1 * t28 * t137)
  d111 = -0.39965432098765432098765432098765432098765432098767e0 / t2 / t1 * t6 * t10 * t33 * t40 + 0.35968888888888888888888888888888888888888888888890e1 * t45 * t59 * t40 + 0.35968888888888888888888888888888888888888888888890e1 * t45 * t33 * t70 + 0.53953333333333333333333333333333333333333333333335e1 * t75 * t100 * t40 + 0.10790666666666666666666666666666666666666666666667e2 * t75 * t59 * t70 + 0.53953333333333333333333333333333333333333333333335e1 * t75 * t33 * t119 + 0.10790666666666666666666666666666666666666666666667e1 * t124 * t12 * (t141 / 0.2e1 + t154 / 0.2e1) * t40 + 0.32372000000000000000000000000000000000000000000001e1 * t124 * t100 * t70 + 0.32372000000000000000000000000000000000000000000001e1 * t124 * t59 * t119 + 0.10790666666666666666666666666666666666666666666667e1 * t124 * t33 * (-0.72592592592592592592592592592592592592592592592592e-3 / t63 / t46 * t37 + 0.37037037037037037037037037037037037037037037037039e0 * t81 * t67 - 0.17006802721088435374149659863945578231292517006804e3 / t2 / t80 * t116 + 0.19282089252934733984296666512409952643188794792294e5 / t63 / t80 / t115 / t36)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = r0 + r1
  t2 = t1 ** (0.1e1 / 0.3e1)
  t5 = 3 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t9 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t9
  t11 = 0.1e1 / t2 / t1 * t6 * t10
  t12 = 4 ** (0.1e1 / 0.3e1)
  t13 = r0 - r1
  t14 = 0.1e1 / t1
  t15 = t13 * t14
  t16 = 0.1e1 + t15
  t17 = t16 <= f.p.zeta_threshold
  t18 = t16 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t20 = t1 ** 2
  t21 = 0.1e1 / t20
  t23 = -t13 * t21 + t14
  t26 = f.my_piecewise3(t17, 0, 0.5e1 / 0.3e1 * t19 * t23)
  t27 = 0.1e1 - t15
  t28 = t27 <= f.p.zeta_threshold
  t29 = t27 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = -t23
  t34 = f.my_piecewise3(t28, 0, 0.5e1 / 0.3e1 * t30 * t31)
  t37 = t12 * (t26 / 0.2e1 + t34 / 0.2e1)
  t38 = 0.1e1 / t2
  t40 = 0.1e1 + 0.51020408163265306122448979591836734693877551020408e3 * t38
  t41 = jnp.log(t40)
  t44 = 0.1e1 - 0.19600000000000000000000000000000000000000000000000e-2 * t2 * t41
  t48 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t49 = t48 ** 2
  t50 = t49 * f.p.zeta_threshold
  t52 = f.my_piecewise3(t17, t50, t19 * t16)
  t54 = f.my_piecewise3(t28, t50, t30 * t27)
  t57 = t12 * (t52 / 0.2e1 + t54 / 0.2e1)
  t58 = t2 ** 2
  t62 = 0.1e1 / t40
  t65 = -0.65333333333333333333333333333333333333333333333333e-3 / t58 * t41 + 0.33333333333333333333333333333333333333333333333334e0 * t14 * t62
  t70 = t38 * t6 * t10
  t71 = 0.1e1 / t18
  t72 = t23 ** 2
  t75 = t20 * t1
  t76 = 0.1e1 / t75
  t79 = 0.2e1 * t13 * t76 - 0.2e1 * t21
  t83 = f.my_piecewise3(t17, 0, 0.10e2 / 0.9e1 * t71 * t72 + 0.5e1 / 0.3e1 * t19 * t79)
  t84 = 0.1e1 / t29
  t85 = t31 ** 2
  t88 = -t79
  t92 = f.my_piecewise3(t28, 0, 0.10e2 / 0.9e1 * t84 * t85 + 0.5e1 / 0.3e1 * t30 * t88)
  t95 = t12 * (t83 / 0.2e1 + t92 / 0.2e1)
  t102 = t58 * t1
  t109 = 0.1e1 / t2 / t20
  t110 = t40 ** 2
  t111 = 0.1e1 / t110
  t114 = 0.43555555555555555555555555555555555555555555555555e-3 / t102 * t41 - 0.22222222222222222222222222222222222222222222222223e0 * t21 * t62 + 0.56689342403628117913832199546485260770975056689344e2 * t109 * t111
  t119 = t58 * t6 * t10
  t121 = 0.1e1 / t18 / t16
  t125 = t71 * t23
  t128 = t20 ** 2
  t129 = 0.1e1 / t128
  t132 = -0.6e1 * t13 * t129 + 0.6e1 * t76
  t136 = f.my_piecewise3(t17, 0, -0.10e2 / 0.27e2 * t121 * t72 * t23 + 0.10e2 / 0.3e1 * t125 * t79 + 0.5e1 / 0.3e1 * t19 * t132)
  t138 = 0.1e1 / t29 / t27
  t142 = t84 * t31
  t145 = -t132
  t149 = f.my_piecewise3(t28, 0, -0.10e2 / 0.27e2 * t138 * t85 * t31 + 0.10e2 / 0.3e1 * t142 * t88 + 0.5e1 / 0.3e1 * t30 * t145)
  t152 = t12 * (t136 / 0.2e1 + t149 / 0.2e1)
  t173 = 0.1e1 / t58 / t75
  t175 = 0.1e1 / t110 / t40
  t178 = -0.72592592592592592592592592592592592592592592592592e-3 / t58 / t20 * t41 + 0.37037037037037037037037037037037037037037037037039e0 * t76 * t62 - 0.17006802721088435374149659863945578231292517006804e3 / t2 / t75 * t111 + 0.19282089252934733984296666512409952643188794792294e5 * t173 * t175
  t183 = t102 * t6 * t10
  t184 = t16 ** 2
  t187 = t72 ** 2
  t193 = t79 ** 2
  t199 = 0.1e1 / t128 / t1
  t202 = 0.24e2 * t13 * t199 - 0.24e2 * t129
  t206 = f.my_piecewise3(t17, 0, 0.40e2 / 0.81e2 / t18 / t184 * t187 - 0.20e2 / 0.9e1 * t121 * t72 * t79 + 0.10e2 / 0.3e1 * t71 * t193 + 0.40e2 / 0.9e1 * t125 * t132 + 0.5e1 / 0.3e1 * t19 * t202)
  t207 = t27 ** 2
  t210 = t85 ** 2
  t216 = t88 ** 2
  t225 = f.my_piecewise3(t28, 0, 0.40e2 / 0.81e2 / t29 / t207 * t210 - 0.20e2 / 0.9e1 * t138 * t85 * t88 + 0.10e2 / 0.3e1 * t84 * t216 + 0.40e2 / 0.9e1 * t142 * t145 - 0.5e1 / 0.3e1 * t30 * t202)
  t253 = t110 ** 2
  d1111 = -0.15986172839506172839506172839506172839506172839507e1 * t11 * t37 * t44 - 0.15986172839506172839506172839506172839506172839507e1 * t11 * t57 * t65 + 0.71937777777777777777777777777777777777777777777780e1 * t70 * t95 * t44 + 0.14387555555555555555555555555555555555555555555556e2 * t70 * t37 * t65 + 0.71937777777777777777777777777777777777777777777780e1 * t70 * t57 * t114 + 0.71937777777777777777777777777777777777777777777780e1 * t119 * t152 * t44 + 0.21581333333333333333333333333333333333333333333334e2 * t119 * t95 * t65 + 0.21581333333333333333333333333333333333333333333334e2 * t119 * t37 * t114 + 0.71937777777777777777777777777777777777777777777780e1 * t119 * t57 * t178 + 0.10790666666666666666666666666666666666666666666667e1 * t183 * t12 * (t206 / 0.2e1 + t225 / 0.2e1) * t44 + 0.43162666666666666666666666666666666666666666666668e1 * t183 * t152 * t65 + 0.64744000000000000000000000000000000000000000000002e1 * t183 * t95 * t114 + 0.43162666666666666666666666666666666666666666666668e1 * t183 * t37 * t178 + 0.10790666666666666666666666666666666666666666666667e1 * t183 * t57 * (0.19358024691358024691358024691358024691358024691358e-2 * t173 * t41 - 0.98765432098765432098765432098765432098765432098774e0 * t129 * t62 + 0.62988158226253464348702443940539178634416729654830e3 / t2 / t128 * t111 - 0.12854726168623155989531111008273301762125863194863e6 / t58 / t128 * t175 + 0.98378006392524152981105441389846697159126504042318e7 * t199 / t253) + 0.53287242798353909465020576131687242798353909465023e0 * t109 * t6 * t10 * t57 * t44

  res = {'v4rho4': d1111}
  return res
