"""Generated from mgga_c_ccalda.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_c_raw = params.c
  if isinstance(params_c_raw, (str, bytes, dict)):
    params_c = params_c_raw
  else:
    try:
      params_c_seq = list(params_c_raw)
    except TypeError:
      params_c = params_c_raw
    else:
      params_c_seq = np.asarray(params_c_seq, dtype=np.float64)
      params_c = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  cc_z = lambda z, xt, ts0, ts1: xt ** 2 / (8 * f.t_total(z, ts0, ts1))

  ccalda_alpha = lambda z, xt, ts0, ts1: (f.t_total(z, ts0, ts1) - xt ** 2 / 8) / K_FACTOR_C * 2 ** (2 / 3)

  ccalda_f_alpha = lambda a: (1 + params_c) * a / (1 + params_c * a)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  f_cc = lambda rs, z, xt, ts0, ts1: (1 - cc_z(z, xt, ts0, ts1) * z ** 2) * f_pw(rs, z)

  f_ccalda0 = lambda f_alpha, f_cc, f_pw: f_alpha * f_cc + (1 - f_alpha) * f_pw

  f_ccalda = lambda rs, z, xt, ts0, ts1: f_ccalda0(ccalda_f_alpha(ccalda_alpha(z, xt, ts0, ts1)), f_cc(rs, z, xt, ts0, ts1), f_pw(rs, z))

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: f_ccalda(rs, z, xt, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_c_raw = params.c
  if isinstance(params_c_raw, (str, bytes, dict)):
    params_c = params_c_raw
  else:
    try:
      params_c_seq = list(params_c_raw)
    except TypeError:
      params_c = params_c_raw
    else:
      params_c_seq = np.asarray(params_c_seq, dtype=np.float64)
      params_c = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  cc_z = lambda z, xt, ts0, ts1: xt ** 2 / (8 * f.t_total(z, ts0, ts1))

  ccalda_alpha = lambda z, xt, ts0, ts1: (f.t_total(z, ts0, ts1) - xt ** 2 / 8) / K_FACTOR_C * 2 ** (2 / 3)

  ccalda_f_alpha = lambda a: (1 + params_c) * a / (1 + params_c * a)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  f_cc = lambda rs, z, xt, ts0, ts1: (1 - cc_z(z, xt, ts0, ts1) * z ** 2) * f_pw(rs, z)

  f_ccalda0 = lambda f_alpha, f_cc, f_pw: f_alpha * f_cc + (1 - f_alpha) * f_pw

  f_ccalda = lambda rs, z, xt, ts0, ts1: f_ccalda0(ccalda_f_alpha(ccalda_alpha(z, xt, ts0, ts1)), f_cc(rs, z, xt, ts0, ts1), f_pw(rs, z))

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: f_ccalda(rs, z, xt, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_c_raw = params.c
  if isinstance(params_c_raw, (str, bytes, dict)):
    params_c = params_c_raw
  else:
    try:
      params_c_seq = list(params_c_raw)
    except TypeError:
      params_c = params_c_raw
    else:
      params_c_seq = np.asarray(params_c_seq, dtype=np.float64)
      params_c = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  cc_z = lambda z, xt, ts0, ts1: xt ** 2 / (8 * f.t_total(z, ts0, ts1))

  ccalda_alpha = lambda z, xt, ts0, ts1: (f.t_total(z, ts0, ts1) - xt ** 2 / 8) / K_FACTOR_C * 2 ** (2 / 3)

  ccalda_f_alpha = lambda a: (1 + params_c) * a / (1 + params_c * a)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  f_cc = lambda rs, z, xt, ts0, ts1: (1 - cc_z(z, xt, ts0, ts1) * z ** 2) * f_pw(rs, z)

  f_ccalda0 = lambda f_alpha, f_cc, f_pw: f_alpha * f_cc + (1 - f_alpha) * f_pw

  f_ccalda = lambda rs, z, xt, ts0, ts1: f_ccalda0(ccalda_f_alpha(ccalda_alpha(z, xt, ts0, ts1)), f_cc(rs, z, xt, ts0, ts1), f_pw(rs, z))

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: f_ccalda(rs, z, xt, ts0, ts1)

  t1 = 0.1e1 + params.c
  t2 = r0 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t5 = 0.1e1 / t3 / r0
  t6 = tau0 * t5
  t7 = r0 - r1
  t8 = r0 + r1
  t9 = 0.1e1 / t8
  t10 = t7 * t9
  t11 = 0.1e1 + t10
  t12 = t11 / 0.2e1
  t13 = t12 ** (0.1e1 / 0.3e1)
  t14 = t13 ** 2
  t15 = t14 * t12
  t16 = t6 * t15
  t17 = r1 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t20 = 0.1e1 / t18 / r1
  t21 = tau1 * t20
  t22 = 0.1e1 - t10
  t23 = t22 / 0.2e1
  t24 = t23 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = t25 * t23
  t27 = t21 * t26
  t29 = s0 + 0.2e1 * s1 + s2
  t30 = t8 ** 2
  t31 = t8 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t34 = 0.1e1 / t32 / t30
  t37 = t16 + t27 - t29 * t34 / 0.8e1
  t38 = t1 * t37
  t39 = 6 ** (0.1e1 / 0.3e1)
  t40 = jnp.pi ** 2
  t41 = t40 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t43 = 0.1e1 / t42
  t44 = t39 * t43
  t45 = t38 * t44
  t46 = 2 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t49 = t44 * t47
  t52 = 0.1e1 + 0.5e1 / 0.9e1 * params.c * t37 * t49
  t53 = 0.1e1 / t52
  t54 = t47 * t53
  t55 = t30 ** 2
  t57 = 0.1e1 / t32 / t55
  t58 = t29 * t57
  t60 = 0.8e1 * t16 + 0.8e1 * t27
  t61 = 0.1e1 / t60
  t62 = t7 ** 2
  t63 = t61 * t62
  t65 = -t58 * t63 + 0.1e1
  t66 = 3 ** (0.1e1 / 0.3e1)
  t68 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t69 = t66 * t68
  t70 = 4 ** (0.1e1 / 0.3e1)
  t71 = t70 ** 2
  t74 = t69 * t71 / t31
  t76 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t74
  t77 = jnp.sqrt(t74)
  t80 = t74 ** 0.15e1
  t82 = t66 ** 2
  t83 = t68 ** 2
  t84 = t82 * t83
  t87 = t84 * t70 / t32
  t89 = 0.23615562999000000000000000000000000000000000000000e0 * t77 + 0.55770497660000000000000000000000000000000000000000e-1 * t74 + 0.12733196185000000000000000000000000000000000000000e-1 * t80 + 0.76629248290000000000000000000000000000000000000000e-2 * t87
  t91 = 0.1e1 + 0.1e1 / t89
  t92 = jnp.log(t91)
  t93 = t76 * t92
  t94 = t62 ** 2
  t95 = 0.1e1 / t55
  t96 = t94 * t95
  t97 = t11 <= f.p.zeta_threshold
  t98 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t99 = t98 * f.p.zeta_threshold
  t100 = t11 ** (0.1e1 / 0.3e1)
  t102 = f.my_piecewise3(t97, t99, t100 * t11)
  t103 = t22 <= f.p.zeta_threshold
  t104 = t22 ** (0.1e1 / 0.3e1)
  t106 = f.my_piecewise3(t103, t99, t104 * t22)
  t110 = 0.1e1 / (0.2e1 * t46 - 0.2e1)
  t111 = (t102 + t106 - 0.2e1) * t110
  t113 = 0.3109070e-1 + 0.15971292590000000000000000000000000000000000000000e-2 * t74
  t118 = 0.21948324211500000000000000000000000000000000000000e0 * t77 + 0.48172707847500000000000000000000000000000000000000e-1 * t74 + 0.13082189292500000000000000000000000000000000000000e-1 * t80 + 0.48592432297500000000000000000000000000000000000000e-2 * t87
  t120 = 0.1e1 + 0.1e1 / t118
  t121 = jnp.log(t120)
  t124 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t74
  t129 = 0.17489762330000000000000000000000000000000000000000e0 * t77 + 0.30591463695000000000000000000000000000000000000000e-1 * t74 + 0.37162156485000000000000000000000000000000000000000e-2 * t80 + 0.41939460495000000000000000000000000000000000000000e-2 * t87
  t131 = 0.1e1 + 0.1e1 / t129
  t132 = jnp.log(t131)
  t133 = t124 * t132
  t135 = -t113 * t121 + t93 - 0.58482236226346462072622386637590534819724553404281e0 * t133
  t136 = t111 * t135
  t140 = -t93 + t96 * t136 + 0.58482236226346462072622386637590534819724553404281e0 * t111 * t133
  t142 = t54 * t65 * t140
  t144 = 0.5e1 / 0.9e1 * t45 * t142
  t146 = t43 * t47
  t147 = t146 * t53
  t148 = t38 * t39 * t147
  t150 = 0.1e1 - 0.5e1 / 0.9e1 * t148
  t151 = t150 * t140
  t152 = r0 ** 2
  t156 = tau0 / t3 / t152 * t15
  t159 = t7 / t30
  t160 = t9 - t159
  t161 = t160 / 0.2e1
  t163 = t6 * t14 * t161
  t167 = -t21 * t25 * t161
  t173 = t29 / t32 / t30 / t8 / 0.3e1
  t174 = -0.5e1 / 0.3e1 * t156 + 0.5e1 / 0.3e1 * t163 + 0.5e1 / 0.3e1 * t167 + t173
  t175 = t1 * t174
  t179 = t39 ** 2
  t182 = t179 / t41 / t40
  t184 = t38 * t182 * t46
  t185 = t52 ** 2
  t186 = 0.1e1 / t185
  t187 = t186 * t65
  t188 = t140 * params.c
  t193 = t55 * t8
  t198 = 0.14e2 / 0.3e1 * t29 / t32 / t193 * t63
  t199 = t60 ** 2
  t200 = 0.1e1 / t199
  t201 = t200 * t62
  t208 = 0.2e1 * t58 * t61 * t7
  t215 = 0.1e1 / t31 / t8
  t216 = t71 * t215
  t219 = 0.11073470983333333333333333333333333333333333333333e-2 * t69 * t216 * t92
  t220 = t89 ** 2
  t225 = t68 * t71
  t226 = t225 * t215
  t227 = 0.1e1 / t77 * t66 * t226
  t229 = t69 * t216
  t231 = t74 ** 0.5e0
  t233 = t231 * t66 * t226
  t238 = t84 * t70 / t32 / t8
  t243 = t76 / t220 * (-0.39359271665000000000000000000000000000000000000000e-1 * t227 - 0.18590165886666666666666666666666666666666666666667e-1 * t229 - 0.63665980925000000000000000000000000000000000000000e-2 * t233 - 0.51086165526666666666666666666666666666666666666667e-2 * t238) / t91
  t247 = 0.4e1 * t62 * t7 * t95 * t136
  t251 = 0.4e1 * t94 / t193 * t136
  t254 = f.my_piecewise3(t97, 0, 0.4e1 / 0.3e1 * t100 * t160)
  t258 = f.my_piecewise3(t103, 0, -0.4e1 / 0.3e1 * t104 * t160)
  t260 = (t254 + t258) * t110
  t266 = t118 ** 2
  t280 = t129 ** 2
  t281 = 0.1e1 / t280
  t287 = -0.29149603883333333333333333333333333333333333333333e-1 * t227 - 0.10197154565000000000000000000000000000000000000000e-1 * t229 - 0.18581078242500000000000000000000000000000000000000e-2 * t233 - 0.27959640330000000000000000000000000000000000000000e-2 * t238
  t288 = 0.1e1 / t131
  t294 = t96 * t111 * (0.53237641966666666666666666666666666666666666666667e-3 * t69 * t216 * t121 + t113 / t266 * (-0.36580540352500000000000000000000000000000000000000e-1 * t227 - 0.16057569282500000000000000000000000000000000000000e-1 * t229 - 0.65410946462500000000000000000000000000000000000000e-2 * t233 - 0.32394954865000000000000000000000000000000000000000e-2 * t238) / t120 - t219 - t243 + 0.18311447306006545054854346104378990962041954983034e-3 * t69 * t216 * t132 + 0.58482236226346462072622386637590534819724553404281e0 * t124 * t281 * t287 * t288)
  t301 = 0.18311447306006545054854346104378990962041954983034e-3 * t111 * t66 * t225 * t215 * t132
  t306 = 0.58482236226346462072622386637590534819724553404281e0 * t111 * t124 * t281 * t287 * t288
  t307 = t219 + t243 + t247 - t251 + t96 * t260 * t135 + t294 + 0.58482236226346462072622386637590534819724553404281e0 * t260 * t133 - t301 - t306
  t315 = t38 * t182
  t316 = t46 * t186
  vrho_0_ = t144 + t151 + t8 * (0.5e1 / 0.9e1 * t175 * t44 * t142 - 0.50e2 / 0.81e2 * t184 * t187 * t188 * t174 + 0.5e1 / 0.9e1 * t45 * t54 * (t198 + t58 * t201 * (-0.40e2 / 0.3e1 * t156 + 0.40e2 / 0.3e1 * t163 + 0.40e2 / 0.3e1 * t167) - t208) * t140 + 0.5e1 / 0.9e1 * t45 * t54 * t65 * t307 + (-0.5e1 / 0.9e1 * t175 * t39 * t147 + 0.50e2 / 0.81e2 * t315 * t316 * params.c * t174) * t140 + t150 * t307)
  t326 = -t9 - t159
  t327 = t326 / 0.2e1
  t329 = t6 * t14 * t327
  t331 = r1 ** 2
  t335 = tau1 / t18 / t331 * t26
  t339 = -t21 * t25 * t327
  t341 = 0.5e1 / 0.3e1 * t329 - 0.5e1 / 0.3e1 * t335 + 0.5e1 / 0.3e1 * t339 + t173
  t342 = t1 * t341
  t361 = f.my_piecewise3(t97, 0, 0.4e1 / 0.3e1 * t100 * t326)
  t365 = f.my_piecewise3(t103, 0, -0.4e1 / 0.3e1 * t104 * t326)
  t367 = (t361 + t365) * t110
  t372 = t219 + t243 - t247 - t251 + t96 * t367 * t135 + t294 + 0.58482236226346462072622386637590534819724553404281e0 * t367 * t133 - t301 - t306
  vrho_1_ = t144 + t151 + t8 * (0.5e1 / 0.9e1 * t342 * t44 * t142 - 0.50e2 / 0.81e2 * t184 * t187 * t188 * t341 + 0.5e1 / 0.9e1 * t45 * t54 * (t198 + t58 * t201 * (0.40e2 / 0.3e1 * t329 - 0.40e2 / 0.3e1 * t335 + 0.40e2 / 0.3e1 * t339) + t208) * t140 + 0.5e1 / 0.9e1 * t45 * t54 * t65 * t372 + (-0.5e1 / 0.9e1 * t342 * t39 * t147 + 0.50e2 / 0.81e2 * t315 * t316 * params.c * t341) * t140 + t150 * t372)
  t389 = t1 * t34
  t391 = t389 * t44 * t142
  t395 = t184 * t187 * t188 * t34
  t401 = t38 * t49 * t53 * t57 * t63 * t140
  t404 = t389 * t39 * t147
  t408 = t315 * t316 * params.c * t34
  vsigma_0_ = t8 * (-0.5e1 / 0.72e2 * t391 + 0.25e2 / 0.324e3 * t395 - 0.5e1 / 0.9e1 * t401 + (0.5e1 / 0.72e2 * t404 - 0.25e2 / 0.324e3 * t408) * t140)
  vsigma_1_ = t8 * (-0.5e1 / 0.36e2 * t391 + 0.25e2 / 0.162e3 * t395 - 0.10e2 / 0.9e1 * t401 + (0.5e1 / 0.36e2 * t404 - 0.25e2 / 0.162e3 * t408) * t140)
  vsigma_2_ = vsigma_0_
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t421 = t1 * t5
  t426 = t146 * t53 * t65 * t140
  t429 = t187 * t140
  t431 = params.c * t5 * t15
  t435 = t58 * t200
  t443 = t44 * t54
  vtau_0_ = t8 * (0.5e1 / 0.9e1 * t421 * t15 * t39 * t426 - 0.50e2 / 0.81e2 * t184 * t429 * t431 + 0.40e2 / 0.9e1 * t148 * t435 * t62 * t5 * t15 * t140 + (-0.5e1 / 0.9e1 * t421 * t15 * t443 + 0.50e2 / 0.81e2 * t315 * t316 * t431) * t140)
  t452 = t1 * t20
  t458 = params.c * t20 * t26
  vtau_1_ = t8 * (0.5e1 / 0.9e1 * t452 * t26 * t39 * t426 - 0.50e2 / 0.81e2 * t184 * t429 * t458 + 0.40e2 / 0.9e1 * t148 * t435 * t62 * t20 * t26 * t140 + (-0.5e1 / 0.9e1 * t452 * t26 * t443 + 0.50e2 / 0.81e2 * t315 * t316 * t458) * t140)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_c_raw = params.c
  if isinstance(params_c_raw, (str, bytes, dict)):
    params_c = params_c_raw
  else:
    try:
      params_c_seq = list(params_c_raw)
    except TypeError:
      params_c = params_c_raw
    else:
      params_c_seq = np.asarray(params_c_seq, dtype=np.float64)
      params_c = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  cc_z = lambda z, xt, ts0, ts1: xt ** 2 / (8 * f.t_total(z, ts0, ts1))

  ccalda_alpha = lambda z, xt, ts0, ts1: (f.t_total(z, ts0, ts1) - xt ** 2 / 8) / K_FACTOR_C * 2 ** (2 / 3)

  ccalda_f_alpha = lambda a: (1 + params_c) * a / (1 + params_c * a)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  f_cc = lambda rs, z, xt, ts0, ts1: (1 - cc_z(z, xt, ts0, ts1) * z ** 2) * f_pw(rs, z)

  f_ccalda0 = lambda f_alpha, f_cc, f_pw: f_alpha * f_cc + (1 - f_alpha) * f_pw

  f_ccalda = lambda rs, z, xt, ts0, ts1: f_ccalda0(ccalda_f_alpha(ccalda_alpha(z, xt, ts0, ts1)), f_cc(rs, z, xt, ts0, ts1), f_pw(rs, z))

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: f_ccalda(rs, z, xt, ts0, ts1)

  t1 = 0.1e1 + params.c
  t2 = r0 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t5 = 0.1e1 / t3 / r0
  t7 = r0 ** 2
  t9 = 0.1e1 / t3 / t7
  t12 = tau0 * t5 - s0 * t9 / 0.8e1
  t13 = t1 * t12
  t14 = 6 ** (0.1e1 / 0.3e1)
  t15 = t13 * t14
  t16 = jnp.pi ** 2
  t17 = t16 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t19 = 0.1e1 / t18
  t20 = 2 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t22 = t19 * t21
  t28 = 0.1e1 + 0.5e1 / 0.9e1 * params.c * t12 * t14 * t19 * t21
  t29 = 0.1e1 / t28
  t30 = 3 ** (0.1e1 / 0.3e1)
  t32 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t33 = t30 * t32
  t34 = 4 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t38 = t33 * t35 / t2
  t40 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t38
  t41 = jnp.sqrt(t38)
  t44 = t38 ** 0.15e1
  t46 = t30 ** 2
  t47 = t32 ** 2
  t48 = t46 * t47
  t51 = t48 * t34 / t3
  t53 = 0.23615562999000000000000000000000000000000000000000e0 * t41 + 0.55770497660000000000000000000000000000000000000000e-1 * t38 + 0.12733196185000000000000000000000000000000000000000e-1 * t44 + 0.76629248290000000000000000000000000000000000000000e-2 * t51
  t55 = 0.1e1 + 0.1e1 / t53
  t56 = jnp.log(t55)
  t59 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t61 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t59 * f.p.zeta_threshold, 1)
  t67 = (0.2e1 * t61 - 0.2e1) / (0.2e1 * t20 - 0.2e1)
  t69 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t38
  t74 = 0.17489762330000000000000000000000000000000000000000e0 * t41 + 0.30591463695000000000000000000000000000000000000000e-1 * t38 + 0.37162156485000000000000000000000000000000000000000e-2 * t44 + 0.41939460495000000000000000000000000000000000000000e-2 * t51
  t76 = 0.1e1 + 0.1e1 / t74
  t77 = jnp.log(t76)
  t81 = -t40 * t56 + 0.58482236226346462072622386637590534819724553404281e0 * t67 * t69 * t77
  t83 = t22 * t29 * t81
  t86 = t22 * t29
  t89 = 0.1e1 - 0.5e1 / 0.9e1 * t15 * t86
  t98 = -0.5e1 / 0.3e1 * tau0 * t9 + s0 / t3 / t7 / r0 / 0.3e1
  t100 = t1 * t98 * t14
  t103 = t14 ** 2
  t107 = t13 * t103 / t17 / t16
  t108 = t28 ** 2
  t110 = t20 / t108
  t111 = t81 * params.c
  t117 = 0.1e1 / t2 / r0
  t118 = t35 * t117
  t122 = t53 ** 2
  t127 = t32 * t35
  t128 = t127 * t117
  t129 = 0.1e1 / t41 * t30 * t128
  t131 = t33 * t118
  t133 = t38 ** 0.5e0
  t135 = t133 * t30 * t128
  t138 = t48 * t34 * t5
  t150 = t74 ** 2
  t162 = 0.11073470983333333333333333333333333333333333333333e-2 * t33 * t118 * t56 + t40 / t122 * (-0.39359271665000000000000000000000000000000000000000e-1 * t129 - 0.18590165886666666666666666666666666666666666666667e-1 * t131 - 0.63665980925000000000000000000000000000000000000000e-2 * t135 - 0.51086165526666666666666666666666666666666666666667e-2 * t138) / t55 - 0.18311447306006545054854346104378990962041954983034e-3 * t67 * t30 * t127 * t117 * t77 - 0.58482236226346462072622386637590534819724553404281e0 * t67 * t69 / t150 * (-0.29149603883333333333333333333333333333333333333333e-1 * t129 - 0.10197154565000000000000000000000000000000000000000e-1 * t131 - 0.18581078242500000000000000000000000000000000000000e-2 * t135 - 0.27959640330000000000000000000000000000000000000000e-2 * t138) / t76
  vrho_0_ = 0.5e1 / 0.9e1 * t15 * t83 + t89 * t81 + r0 * (0.5e1 / 0.9e1 * t100 * t83 - 0.50e2 / 0.81e2 * t107 * t110 * t111 * t98 + 0.5e1 / 0.9e1 * t15 * t22 * t29 * t162 + (-0.5e1 / 0.9e1 * t100 * t86 + 0.50e2 / 0.81e2 * t107 * t110 * params.c * t98) * t81 + t89 * t162)
  t179 = t1 * t9 * t14
  vsigma_0_ = r0 * (-0.5e1 / 0.72e2 * t179 * t83 + 0.25e2 / 0.324e3 * t107 * t110 * t111 * t9 + (0.5e1 / 0.72e2 * t179 * t86 - 0.25e2 / 0.324e3 * t107 * t110 * params.c * t9) * t81)
  vlapl_0_ = 0.0e0
  t196 = t1 * t5 * t14
  vtau_0_ = r0 * (0.5e1 / 0.9e1 * t196 * t83 - 0.50e2 / 0.81e2 * t107 * t110 * t111 * t5 + (-0.5e1 / 0.9e1 * t196 * t86 + 0.50e2 / 0.81e2 * t107 * t110 * params.c * t5) * t81)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 0.1e1 + params.c
  t2 = r0 ** 2
  t3 = r0 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t6 = 0.1e1 / t4 / t2
  t11 = 0.1e1 / t4 / t2 / r0
  t14 = -0.5e1 / 0.3e1 * tau0 * t6 + s0 * t11 / 0.3e1
  t16 = 6 ** (0.1e1 / 0.3e1)
  t17 = t1 * t14 * t16
  t18 = jnp.pi ** 2
  t19 = t18 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = 0.1e1 / t20
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = t21 * t23
  t26 = 0.1e1 / t4 / r0
  t30 = tau0 * t26 - s0 * t6 / 0.8e1
  t36 = 0.1e1 + 0.5e1 / 0.9e1 * params.c * t30 * t16 * t21 * t23
  t37 = 0.1e1 / t36
  t38 = 3 ** (0.1e1 / 0.3e1)
  t40 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t41 = t38 * t40
  t42 = 4 ** (0.1e1 / 0.3e1)
  t43 = t42 ** 2
  t46 = t41 * t43 / t3
  t48 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t46
  t49 = jnp.sqrt(t46)
  t52 = t46 ** 0.15e1
  t54 = t38 ** 2
  t55 = t40 ** 2
  t56 = t54 * t55
  t59 = t56 * t42 / t4
  t61 = 0.37978500000000000000000000000000000000000000000000e1 * t49 + 0.89690000000000000000000000000000000000000000000000e0 * t46 + 0.20477500000000000000000000000000000000000000000000e0 * t52 + 0.12323500000000000000000000000000000000000000000000e0 * t59
  t64 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t61
  t65 = jnp.log(t64)
  t69 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t71 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t69 * f.p.zeta_threshold, 1)
  t77 = (0.2e1 * t71 - 0.2e1) / (0.2e1 * t22 - 0.2e1)
  t79 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t46
  t84 = 0.51785000000000000000000000000000000000000000000000e1 * t49 + 0.90577500000000000000000000000000000000000000000000e0 * t46 + 0.11003250000000000000000000000000000000000000000000e0 * t52 + 0.12417750000000000000000000000000000000000000000000e0 * t59
  t87 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t84
  t88 = jnp.log(t87)
  t92 = -0.621814e-1 * t48 * t65 + 0.19751673498613801407483339618206552048944131217655e-1 * t77 * t79 * t88
  t94 = t24 * t37 * t92
  t97 = t1 * t30
  t98 = t16 ** 2
  t100 = 0.1e1 / t19 / t18
  t101 = t98 * t100
  t102 = t97 * t101
  t103 = t36 ** 2
  t104 = 0.1e1 / t103
  t105 = t22 * t104
  t106 = t92 * params.c
  t111 = t97 * t16
  t113 = 0.1e1 / t3 / r0
  t114 = t43 * t113
  t118 = t61 ** 2
  t119 = 0.1e1 / t118
  t120 = t48 * t119
  t122 = 0.1e1 / t49 * t38
  t123 = t40 * t43
  t124 = t123 * t113
  t125 = t122 * t124
  t127 = t41 * t114
  t129 = t46 ** 0.5e0
  t130 = t129 * t38
  t131 = t130 * t124
  t134 = t56 * t42 * t26
  t136 = -0.63297500000000000000000000000000000000000000000000e0 * t125 - 0.29896666666666666666666666666666666666666666666667e0 * t127 - 0.10238750000000000000000000000000000000000000000000e0 * t131 - 0.82156666666666666666666666666666666666666666666667e-1 * t134
  t137 = 0.1e1 / t64
  t138 = t136 * t137
  t141 = t77 * t38
  t146 = t77 * t79
  t147 = t84 ** 2
  t148 = 0.1e1 / t147
  t153 = -0.86308333333333333333333333333333333333333333333334e0 * t125 - 0.30192500000000000000000000000000000000000000000000e0 * t127 - 0.55016250000000000000000000000000000000000000000000e-1 * t131 - 0.82785000000000000000000000000000000000000000000000e-1 * t134
  t155 = 0.1e1 / t87
  t156 = t148 * t153 * t155
  t159 = 0.11073470983333333333333333333333333333333333333333e-2 * t41 * t114 * t65 + 0.10000000000000000000000000000000000000000000000000e1 * t120 * t138 - 0.18311447306006545054854346104378990962041954983034e-3 * t141 * t123 * t113 * t88 - 0.58482236226346462072622386637590534819724553404280e0 * t146 * t156
  t161 = t24 * t37 * t159
  t164 = t24 * t37
  t171 = -0.5e1 / 0.9e1 * t17 * t164 + 0.50e2 / 0.81e2 * t102 * t105 * params.c * t14
  t176 = 0.1e1 - 0.5e1 / 0.9e1 * t111 * t164
  t181 = t2 ** 2
  t186 = 0.40e2 / 0.9e1 * tau0 * t11 - 0.11e2 / 0.9e1 * s0 / t4 / t181
  t188 = t1 * t186 * t16
  t191 = t14 ** 2
  t192 = t1 * t191
  t199 = t18 ** 2
  t201 = t97 / t199
  t203 = 0.1e1 / t103 / t36
  t205 = params.c ** 2
  t220 = 0.1e1 / t3 / t2
  t221 = t43 * t220
  t233 = t136 ** 2
  t241 = t55 * t42 * t6
  t242 = 0.1e1 / t49 / t46 * t54 * t241
  t244 = t123 * t220
  t245 = t122 * t244
  t247 = t41 * t221
  t249 = t46 ** (-0.5e0)
  t251 = t249 * t54 * t241
  t253 = t130 * t244
  t256 = t56 * t42 * t6
  t262 = t118 ** 2
  t265 = t64 ** 2
  t280 = t153 ** 2
  t296 = t147 ** 2
  t299 = t87 ** 2
  t304 = -0.14764627977777777777777777777777777777777777777777e-2 * t41 * t221 * t65 - 0.35616666666666666666666666666666666666666666666666e-1 * t41 * t43 * t113 * t119 * t138 - 0.20000000000000000000000000000000000000000000000000e1 * t48 / t118 / t61 * t233 * t137 + 0.10000000000000000000000000000000000000000000000000e1 * t120 * (-0.42198333333333333333333333333333333333333333333333e0 * t242 + 0.84396666666666666666666666666666666666666666666666e0 * t245 + 0.39862222222222222222222222222222222222222222222223e0 * t247 + 0.68258333333333333333333333333333333333333333333333e-1 * t251 + 0.13651666666666666666666666666666666666666666666667e0 * t253 + 0.13692777777777777777777777777777777777777777777778e0 * t256) * t137 + 0.16081979498692535066756296899072713062105388428051e2 * t48 / t262 * t233 / t265 + 0.24415263074675393406472461472505321282722606644045e-3 * t141 * t123 * t220 * t88 + 0.10843581300301739842632067522386578331157260943710e-1 * t77 * t41 * t114 * t156 + 0.11696447245269292414524477327518106963944910680856e1 * t146 / t147 / t84 * t280 * t155 - 0.58482236226346462072622386637590534819724553404280e0 * t146 * t148 * (-0.57538888888888888888888888888888888888888888888889e0 * t242 + 0.11507777777777777777777777777777777777777777777778e1 * t245 + 0.40256666666666666666666666666666666666666666666667e0 * t247 + 0.36677500000000000000000000000000000000000000000000e-1 * t251 + 0.73355000000000000000000000000000000000000000000000e-1 * t253 + 0.13797500000000000000000000000000000000000000000000e0 * t256) * t155 - 0.17315859105681463759666483083807725165579399831905e2 * t146 / t296 * t280 / t299
  v2rho2_0_ = 0.10e2 / 0.9e1 * t17 * t94 - 0.100e3 / 0.81e2 * t102 * t105 * t106 * t14 + 0.10e2 / 0.9e1 * t111 * t161 + 0.2e1 * t171 * t92 + 0.2e1 * t176 * t159 + r0 * (0.5e1 / 0.9e1 * t188 * t94 - 0.100e3 / 0.81e2 * t192 * t101 * t105 * t106 + 0.10e2 / 0.9e1 * t17 * t161 + 0.2000e4 / 0.243e3 * t201 * t203 * t92 * t205 * t191 - 0.100e3 / 0.81e2 * t102 * t105 * t159 * params.c * t14 - 0.50e2 / 0.81e2 * t102 * t105 * t106 * t186 + 0.5e1 / 0.9e1 * t111 * t24 * t37 * t304 + (-0.5e1 / 0.9e1 * t188 * t164 + 0.100e3 / 0.81e2 * t192 * t98 * t100 * t22 * t104 * params.c - 0.2000e4 / 0.243e3 * t201 * t203 * t205 * t191 + 0.50e2 / 0.81e2 * t102 * t105 * params.c * t186) * t92 + 0.2e1 * t171 * t159 + t176 * t304)
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 0.1e1 + params.c
  t2 = r0 ** 2
  t3 = r0 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t6 = 0.1e1 / t4 / t2
  t9 = t2 * r0
  t11 = 0.1e1 / t4 / t9
  t14 = -0.5e1 / 0.3e1 * tau0 * t6 + s0 * t11 / 0.3e1
  t15 = t14 ** 2
  t16 = t15 * t14
  t17 = t1 * t16
  t18 = jnp.pi ** 2
  t19 = t18 ** 2
  t20 = 0.1e1 / t19
  t23 = 0.1e1 / t4 / r0
  t27 = tau0 * t23 - s0 * t6 / 0.8e1
  t29 = 6 ** (0.1e1 / 0.3e1)
  t30 = t18 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = 0.1e1 / t31
  t34 = 2 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t36 = t29 * t32 * t35
  t39 = 0.1e1 + 0.5e1 / 0.9e1 * params.c * t27 * t36
  t40 = t39 ** 2
  t42 = 0.1e1 / t40 / t39
  t43 = 3 ** (0.1e1 / 0.3e1)
  t44 = 0.1e1 / jnp.pi
  t45 = t44 ** (0.1e1 / 0.3e1)
  t46 = t43 * t45
  t47 = 4 ** (0.1e1 / 0.3e1)
  t48 = t47 ** 2
  t51 = t46 * t48 / t3
  t53 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t51
  t54 = jnp.sqrt(t51)
  t57 = t51 ** 0.15e1
  t59 = t43 ** 2
  t60 = t45 ** 2
  t61 = t59 * t60
  t64 = t61 * t47 / t4
  t66 = 0.37978500000000000000000000000000000000000000000000e1 * t54 + 0.89690000000000000000000000000000000000000000000000e0 * t51 + 0.20477500000000000000000000000000000000000000000000e0 * t57 + 0.12323500000000000000000000000000000000000000000000e0 * t64
  t69 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t66
  t70 = jnp.log(t69)
  t74 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t76 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t74 * f.p.zeta_threshold, 1)
  t82 = (0.2e1 * t76 - 0.2e1) / (0.2e1 * t34 - 0.2e1)
  t84 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t51
  t89 = 0.51785000000000000000000000000000000000000000000000e1 * t54 + 0.90577500000000000000000000000000000000000000000000e0 * t51 + 0.11003250000000000000000000000000000000000000000000e0 * t57 + 0.12417750000000000000000000000000000000000000000000e0 * t64
  t92 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t89
  t93 = jnp.log(t92)
  t97 = -0.621814e-1 * t53 * t70 + 0.19751673498613801407483339618206552048944131217655e-1 * t82 * t84 * t93
  t98 = t42 * t97
  t99 = params.c ** 2
  t103 = t1 * t27
  t104 = t103 * t29
  t105 = t32 * t35
  t106 = 0.1e1 / t39
  t107 = t105 * t106
  t110 = 0.1e1 - 0.5e1 / 0.9e1 * t104 * t107
  t111 = t66 ** 2
  t112 = t111 ** 2
  t113 = 0.1e1 / t112
  t114 = t53 * t113
  t117 = 0.1e1 / t54 / t51 * t59
  t118 = t60 * t47
  t119 = t118 * t6
  t120 = t117 * t119
  t123 = 0.1e1 / t54 * t43
  t124 = t45 * t48
  t126 = 0.1e1 / t3 / t2
  t127 = t124 * t126
  t128 = t123 * t127
  t130 = t48 * t126
  t131 = t46 * t130
  t133 = t51 ** (-0.5e0)
  t134 = t133 * t59
  t135 = t134 * t119
  t137 = t51 ** 0.5e0
  t138 = t137 * t43
  t139 = t138 * t127
  t142 = t61 * t47 * t6
  t144 = -0.42198333333333333333333333333333333333333333333333e0 * t120 + 0.84396666666666666666666666666666666666666666666666e0 * t128 + 0.39862222222222222222222222222222222222222222222223e0 * t131 + 0.68258333333333333333333333333333333333333333333333e-1 * t135 + 0.13651666666666666666666666666666666666666666666667e0 * t139 + 0.13692777777777777777777777777777777777777777777778e0 * t142
  t145 = t69 ** 2
  t146 = 0.1e1 / t145
  t149 = 0.1e1 / t3 / r0
  t150 = t124 * t149
  t151 = t123 * t150
  t153 = t48 * t149
  t154 = t46 * t153
  t156 = t138 * t150
  t159 = t61 * t47 * t23
  t161 = -0.63297500000000000000000000000000000000000000000000e0 * t151 - 0.29896666666666666666666666666666666666666666666667e0 * t154 - 0.10238750000000000000000000000000000000000000000000e0 * t156 - 0.82156666666666666666666666666666666666666666666667e-1 * t159
  t168 = t161 ** 2
  t169 = t168 * t161
  t181 = 0.1e1 / t111
  t182 = t53 * t181
  t187 = t2 ** 2
  t188 = 0.1e1 / t187
  t189 = 0.1e1 / t54 / t64 * t44 * t188 / 0.4e1
  t191 = t118 * t11
  t192 = t117 * t191
  t195 = 0.1e1 / t3 / t9
  t196 = t124 * t195
  t197 = t123 * t196
  t199 = t48 * t195
  t200 = t46 * t199
  t202 = t51 ** (-0.15e1)
  t204 = t202 * t44 * t188
  t206 = t134 * t191
  t208 = t138 * t196
  t211 = t61 * t47 * t11
  t214 = 0.1e1 / t69
  t218 = t82 * t84
  t219 = t89 ** 2
  t220 = t219 ** 2
  t227 = -0.86308333333333333333333333333333333333333333333334e0 * t151 - 0.30192500000000000000000000000000000000000000000000e0 * t154 - 0.55016250000000000000000000000000000000000000000000e-1 * t156 - 0.82785000000000000000000000000000000000000000000000e-1 * t159
  t228 = t227 ** 2
  t229 = t228 * t227
  t231 = t92 ** 2
  t240 = 0.1e1 / t231
  t244 = 0.1e1 / t219
  t255 = 0.1e1 / t92
  t266 = 0.1e1 / t111 / t66
  t267 = t53 * t266
  t268 = t161 * t214
  t272 = t82 * t46
  t274 = 0.1e1 / t219 / t89
  t276 = t274 * t228 * t255
  t280 = 0.48245938496077605200268890697218139186316165284153e2 * t114 * t144 * t146 * t161 + 0.51726012919273400298984252201052768390886626637712e3 * t53 / t112 / t111 * t169 / t145 / t69 - 0.96491876992155210400537781394436278372632330568306e2 * t53 / t112 / t66 * t169 * t146 + 0.10000000000000000000000000000000000000000000000000e1 * t182 * (-0.25319000000000000000000000000000000000000000000000e1 * t189 + 0.16879333333333333333333333333333333333333333333333e1 * t192 - 0.19692555555555555555555555555555555555555555555555e1 * t197 - 0.93011851851851851851851851851851851851851851851854e0 * t200 + 0.13651666666666666666666666666666666666666666666667e0 * t204 - 0.27303333333333333333333333333333333333333333333333e0 * t206 - 0.31853888888888888888888888888888888888888888888890e0 * t208 - 0.36514074074074074074074074074074074074074074074075e0 * t211) * t214 - 0.10254018858216406658218194626490193680059335835414e4 * t218 / t220 / t219 * t229 / t231 / t92 + 0.10389515463408878255799889850284635099347639899143e3 * t218 / t220 / t89 * t229 * t240 - 0.58482236226346462072622386637590534819724553404280e0 * t218 * t244 * (-0.34523333333333333333333333333333333333333333333333e1 * t189 + 0.23015555555555555555555555555555555555555555555556e1 * t192 - 0.26851481481481481481481481481481481481481481481482e1 * t197 - 0.93932222222222222222222222222222222222222222222223e0 * t200 + 0.73355000000000000000000000000000000000000000000000e-1 * t204 - 0.14671000000000000000000000000000000000000000000000e0 * t206 - 0.17116166666666666666666666666666666666666666666667e0 * t208 - 0.36793333333333333333333333333333333333333333333333e0 * t211) * t255 + 0.34450798614814814814814814814814814814814814814813e-2 * t46 * t199 * t70 + 0.60000000000000000000000000000000000000000000000000e1 * t114 * t169 * t214 - 0.60000000000000000000000000000000000000000000000000e1 * t267 * t268 * t144 - 0.32530743900905219527896202567159734993471782831130e-1 * t272 * t153 * t276
  t282 = t244 * t227 * t255
  t292 = -0.57538888888888888888888888888888888888888888888889e0 * t120 + 0.11507777777777777777777777777777777777777777777778e1 * t128 + 0.40256666666666666666666666666666666666666666666667e0 * t131 + 0.36677500000000000000000000000000000000000000000000e-1 * t135 + 0.73355000000000000000000000000000000000000000000000e-1 * t139 + 0.13797500000000000000000000000000000000000000000000e0 * t142
  t294 = t244 * t292 * t255
  t298 = 0.1e1 / t220
  t300 = t298 * t228 * t240
  t304 = t46 * t48
  t306 = t168 * t214
  t310 = t82 * t43
  t319 = t149 * t181
  t320 = t144 * t214
  t325 = t168 * t146
  t343 = -0.21687162600603479685264135044773156662314521887420e-1 * t272 * t130 * t282 + 0.16265371950452609763948101283579867496735891415565e-1 * t272 * t153 * t294 + 0.48159733137676571081572406076840235616767705782485e0 * t272 * t153 * t300 + 0.10685000000000000000000000000000000000000000000000e0 * t304 * t149 * t266 * t306 - 0.56968947174242584615102410102512416326352748836105e-3 * t310 * t124 * t195 * t93 + 0.71233333333333333333333333333333333333333333333331e-1 * t304 * t126 * t181 * t268 - 0.53424999999999999999999999999999999999999999999999e-1 * t304 * t319 * t320 - 0.85917975471764868594145516183295969534298037676861e0 * t304 * t149 * t113 * t325 - 0.35089341735807877243573431982554320891834732042568e1 * t218 * t298 * t229 * t255 + 0.35089341735807877243573431982554320891834732042568e1 * t218 * t274 * t227 * t255 * t292 - 0.51947577317044391278999449251423175496738199495715e2 * t218 * t298 * t292 * t240 * t227
  t344 = t280 + t343
  t347 = 0.1e1 / t4 / t187
  t355 = -0.440e3 / 0.27e2 * tau0 * t347 + 0.154e3 / 0.27e2 * s0 / t4 / t187 / r0
  t357 = t1 * t355 * t29
  t364 = 0.40e2 / 0.9e1 * tau0 * t11 - 0.11e2 / 0.9e1 * s0 * t347
  t365 = t1 * t364
  t366 = t29 ** 2
  t368 = 0.1e1 / t30 / t18
  t369 = t366 * t368
  t370 = t365 * t369
  t371 = 0.1e1 / t40
  t372 = t34 * t371
  t374 = t372 * params.c * t14
  t377 = t20 * t42
  t381 = t40 ** 2
  t383 = t20 / t381
  t387 = t99 * params.c * t16 * t36
  t390 = t103 * t20
  t391 = t42 * t99
  t392 = t14 * t364
  t396 = t103 * t369
  t403 = t365 * t29
  t406 = t1 * t15
  t420 = -0.5e1 / 0.9e1 * t403 * t107 + 0.100e3 / 0.81e2 * t406 * t366 * t368 * t34 * t371 * params.c - 0.2000e4 / 0.243e3 * t390 * t391 * t15 + 0.50e2 / 0.81e2 * t396 * t372 * params.c * t364
  t432 = 0.11073470983333333333333333333333333333333333333333e-2 * t46 * t153 * t70 + 0.10000000000000000000000000000000000000000000000000e1 * t182 * t268 - 0.18311447306006545054854346104378990962041954983034e-3 * t310 * t124 * t149 * t93 - 0.58482236226346462072622386637590534819724553404280e0 * t218 * t282
  t436 = t1 * t14 * t29
  t441 = -0.5e1 / 0.9e1 * t436 * t107 + 0.50e2 / 0.81e2 * t396 * t374
  t467 = -0.14764627977777777777777777777777777777777777777777e-2 * t46 * t130 * t70 - 0.35616666666666666666666666666666666666666666666666e-1 * t304 * t319 * t268 - 0.20000000000000000000000000000000000000000000000000e1 * t267 * t306 + 0.10000000000000000000000000000000000000000000000000e1 * t182 * t320 + 0.16081979498692535066756296899072713062105388428051e2 * t114 * t325 + 0.24415263074675393406472461472505321282722606644045e-3 * t310 * t124 * t126 * t93 + 0.10843581300301739842632067522386578331157260943710e-1 * t272 * t153 * t282 + 0.11696447245269292414524477327518106963944910680856e1 * t218 * t276 - 0.58482236226346462072622386637590534819724553404280e0 * t218 * t294 - 0.17315859105681463759666483083807725165579399831905e2 * t218 * t300
  t474 = t432 * params.c
  t479 = t97 * params.c
  t493 = t406 * t369
  t503 = t105 * t106 * t97
  t507 = t105 * t106 * t432
  t511 = t105 * t106 * t467
  t515 = t99 * t15
  t523 = 0.2000e4 / 0.81e2 * t17 * t20 * t98 * t99 + t110 * t344 + (-0.5e1 / 0.9e1 * t357 * t107 + 0.100e3 / 0.27e2 * t370 * t374 - 0.2000e4 / 0.81e2 * t17 * t377 * t99 + 0.10000e5 / 0.729e3 * t103 * t383 * t387 - 0.2000e4 / 0.81e2 * t390 * t391 * t392 + 0.50e2 / 0.81e2 * t396 * t372 * params.c * t355) * t97 + 0.3e1 * t420 * t432 + 0.3e1 * t441 * t467 - 0.10000e5 / 0.729e3 * t103 * t383 * t97 * t387 - 0.50e2 / 0.27e2 * t396 * t372 * t474 * t364 - 0.50e2 / 0.81e2 * t396 * t372 * t479 * t355 - 0.100e3 / 0.27e2 * t370 * t372 * t479 * t14 - 0.50e2 / 0.27e2 * t396 * t372 * t467 * params.c * t14 - 0.100e3 / 0.27e2 * t493 * t372 * t474 + 0.2000e4 / 0.81e2 * t103 * t377 * t97 * t99 * t392 + 0.5e1 / 0.9e1 * t357 * t503 + 0.5e1 / 0.3e1 * t403 * t507 + 0.5e1 / 0.3e1 * t436 * t511 + 0.2000e4 / 0.81e2 * t390 * t42 * t432 * t515 + 0.5e1 / 0.9e1 * t104 * t105 * t106 * t344
  v3rho3_0_ = r0 * t523 + 0.3e1 * t110 * t467 + 0.6e1 * t441 * t432 + 0.3e1 * t420 * t97 - 0.100e3 / 0.27e2 * t396 * t372 * t474 * t14 - 0.50e2 / 0.27e2 * t396 * t372 * t479 * t364 - 0.100e3 / 0.27e2 * t493 * t372 * t479 + 0.5e1 / 0.3e1 * t403 * t503 + 0.10e2 / 0.3e1 * t436 * t507 + 0.2000e4 / 0.81e2 * t390 * t98 * t515 + 0.5e1 / 0.3e1 * t104 * t511

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 0.1e1 + params.c
  t2 = r0 ** 2
  t3 = r0 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t6 = 0.1e1 / t4 / t2
  t9 = t2 * r0
  t11 = 0.1e1 / t4 / t9
  t14 = -0.5e1 / 0.3e1 * tau0 * t6 + s0 * t11 / 0.3e1
  t15 = t1 * t14
  t16 = 6 ** (0.1e1 / 0.3e1)
  t17 = t15 * t16
  t18 = jnp.pi ** 2
  t19 = t18 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = 0.1e1 / t20
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = t21 * t23
  t26 = 0.1e1 / t4 / r0
  t30 = tau0 * t26 - s0 * t6 / 0.8e1
  t33 = t16 * t21 * t23
  t36 = 0.1e1 + 0.5e1 / 0.9e1 * params.c * t30 * t33
  t37 = 0.1e1 / t36
  t38 = t24 * t37
  t41 = t1 * t30
  t42 = t16 ** 2
  t44 = 0.1e1 / t19 / t18
  t45 = t42 * t44
  t46 = t41 * t45
  t47 = t36 ** 2
  t48 = 0.1e1 / t47
  t49 = t22 * t48
  t51 = t49 * params.c * t14
  t54 = -0.5e1 / 0.9e1 * t17 * t38 + 0.50e2 / 0.81e2 * t46 * t51
  t55 = 3 ** (0.1e1 / 0.3e1)
  t56 = 0.1e1 / jnp.pi
  t57 = t56 ** (0.1e1 / 0.3e1)
  t58 = t55 * t57
  t59 = 4 ** (0.1e1 / 0.3e1)
  t60 = t59 ** 2
  t62 = 0.1e1 / t3 / t2
  t63 = t60 * t62
  t66 = t58 * t60 / t3
  t67 = jnp.sqrt(t66)
  t70 = t66 ** 0.15e1
  t72 = t55 ** 2
  t73 = t57 ** 2
  t74 = t72 * t73
  t77 = t74 * t59 / t4
  t79 = 0.37978500000000000000000000000000000000000000000000e1 * t67 + 0.89690000000000000000000000000000000000000000000000e0 * t66 + 0.20477500000000000000000000000000000000000000000000e0 * t70 + 0.12323500000000000000000000000000000000000000000000e0 * t77
  t82 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t79
  t83 = jnp.log(t82)
  t87 = t58 * t60
  t89 = 0.1e1 / t3 / r0
  t90 = t79 ** 2
  t91 = 0.1e1 / t90
  t92 = t89 * t91
  t94 = 0.1e1 / t67 * t55
  t95 = t57 * t60
  t96 = t95 * t89
  t97 = t94 * t96
  t99 = t60 * t89
  t100 = t58 * t99
  t102 = t66 ** 0.5e0
  t103 = t102 * t55
  t104 = t103 * t96
  t107 = t74 * t59 * t26
  t109 = -0.63297500000000000000000000000000000000000000000000e0 * t97 - 0.29896666666666666666666666666666666666666666666667e0 * t100 - 0.10238750000000000000000000000000000000000000000000e0 * t104 - 0.82156666666666666666666666666666666666666666666667e-1 * t107
  t110 = 0.1e1 / t82
  t111 = t109 * t110
  t116 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t66
  t117 = t90 * t79
  t118 = 0.1e1 / t117
  t119 = t116 * t118
  t120 = t109 ** 2
  t121 = t120 * t110
  t124 = t116 * t91
  t127 = 0.1e1 / t67 / t66 * t72
  t128 = t73 * t59
  t129 = t128 * t6
  t130 = t127 * t129
  t132 = t95 * t62
  t133 = t94 * t132
  t135 = t58 * t63
  t137 = t66 ** (-0.5e0)
  t138 = t137 * t72
  t139 = t138 * t129
  t141 = t103 * t132
  t144 = t74 * t59 * t6
  t146 = -0.42198333333333333333333333333333333333333333333333e0 * t130 + 0.84396666666666666666666666666666666666666666666666e0 * t133 + 0.39862222222222222222222222222222222222222222222223e0 * t135 + 0.68258333333333333333333333333333333333333333333333e-1 * t139 + 0.13651666666666666666666666666666666666666666666667e0 * t141 + 0.13692777777777777777777777777777777777777777777778e0 * t144
  t147 = t146 * t110
  t150 = t90 ** 2
  t151 = 0.1e1 / t150
  t152 = t116 * t151
  t153 = t82 ** 2
  t154 = 0.1e1 / t153
  t155 = t120 * t154
  t159 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t161 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t159 * f.p.zeta_threshold, 1)
  t167 = (0.2e1 * t161 - 0.2e1) / (0.2e1 * t22 - 0.2e1)
  t168 = t167 * t55
  t173 = 0.51785000000000000000000000000000000000000000000000e1 * t67 + 0.90577500000000000000000000000000000000000000000000e0 * t66 + 0.11003250000000000000000000000000000000000000000000e0 * t70 + 0.12417750000000000000000000000000000000000000000000e0 * t77
  t176 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t173
  t177 = jnp.log(t176)
  t182 = t167 * t58
  t183 = t173 ** 2
  t184 = 0.1e1 / t183
  t189 = -0.86308333333333333333333333333333333333333333333334e0 * t97 - 0.30192500000000000000000000000000000000000000000000e0 * t100 - 0.55016250000000000000000000000000000000000000000000e-1 * t104 - 0.82785000000000000000000000000000000000000000000000e-1 * t107
  t191 = 0.1e1 / t176
  t192 = t184 * t189 * t191
  t197 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t66
  t198 = t167 * t197
  t199 = t183 * t173
  t200 = 0.1e1 / t199
  t201 = t189 ** 2
  t203 = t200 * t201 * t191
  t212 = -0.57538888888888888888888888888888888888888888888889e0 * t130 + 0.11507777777777777777777777777777777777777777777778e1 * t133 + 0.40256666666666666666666666666666666666666666666667e0 * t135 + 0.36677500000000000000000000000000000000000000000000e-1 * t139 + 0.73355000000000000000000000000000000000000000000000e-1 * t141 + 0.13797500000000000000000000000000000000000000000000e0 * t144
  t214 = t184 * t212 * t191
  t217 = t183 ** 2
  t218 = 0.1e1 / t217
  t219 = t218 * t201
  t220 = t176 ** 2
  t221 = 0.1e1 / t220
  t222 = t219 * t221
  t225 = -0.14764627977777777777777777777777777777777777777777e-2 * t58 * t63 * t83 - 0.35616666666666666666666666666666666666666666666666e-1 * t87 * t92 * t111 - 0.20000000000000000000000000000000000000000000000000e1 * t119 * t121 + 0.10000000000000000000000000000000000000000000000000e1 * t124 * t147 + 0.16081979498692535066756296899072713062105388428051e2 * t152 * t155 + 0.24415263074675393406472461472505321282722606644045e-3 * t168 * t95 * t62 * t177 + 0.10843581300301739842632067522386578331157260943710e-1 * t182 * t99 * t192 + 0.11696447245269292414524477327518106963944910680856e1 * t198 * t203 - 0.58482236226346462072622386637590534819724553404280e0 * t198 * t214 - 0.17315859105681463759666483083807725165579399831905e2 * t198 * t222
  t230 = t2 ** 2
  t232 = 0.1e1 / t4 / t230
  t235 = 0.40e2 / 0.9e1 * tau0 * t11 - 0.11e2 / 0.9e1 * s0 * t232
  t236 = t1 * t235
  t237 = t236 * t16
  t240 = t14 ** 2
  t241 = t1 * t240
  t245 = t44 * t22 * t48 * params.c
  t248 = t18 ** 2
  t249 = 0.1e1 / t248
  t250 = t41 * t249
  t252 = 0.1e1 / t47 / t36
  t253 = params.c ** 2
  t254 = t252 * t253
  t255 = t254 * t240
  t262 = -0.5e1 / 0.9e1 * t237 * t38 + 0.100e3 / 0.81e2 * t241 * t42 * t245 - 0.2000e4 / 0.243e3 * t250 * t255 + 0.50e2 / 0.81e2 * t46 * t49 * params.c * t235
  t274 = 0.11073470983333333333333333333333333333333333333333e-2 * t58 * t99 * t83 + 0.10000000000000000000000000000000000000000000000000e1 * t124 * t111 - 0.18311447306006545054854346104378990962041954983034e-3 * t168 * t95 * t89 * t177 - 0.58482236226346462072622386637590534819724553404280e0 * t198 * t192
  t277 = t47 ** 2
  t280 = t249 / t277 / t36
  t286 = -0.621814e-1 * t116 * t83 + 0.19751673498613801407483339618206552048944131217655e-1 * t167 * t197 * t177
  t289 = t253 ** 2
  t290 = t240 ** 2
  t293 = t289 * t290 * t45 * t22
  t297 = t249 / t277
  t300 = t253 * params.c
  t301 = t240 * t14
  t303 = t300 * t301 * t33
  t306 = t146 * t154
  t311 = 0.1e1 / t150 / t90
  t312 = t116 * t311
  t313 = t120 * t109
  t315 = 0.1e1 / t153 / t82
  t316 = t313 * t315
  t320 = 0.1e1 / t150 / t79
  t321 = t116 * t320
  t322 = t313 * t154
  t328 = 0.1e1 / t67 / t77 * t56 / 0.4e1
  t329 = 0.1e1 / t230
  t330 = t328 * t329
  t332 = t128 * t11
  t333 = t127 * t332
  t336 = 0.1e1 / t3 / t9
  t337 = t95 * t336
  t338 = t94 * t337
  t340 = t60 * t336
  t341 = t58 * t340
  t343 = t66 ** (-0.15e1)
  t344 = t343 * t56
  t345 = t344 * t329
  t347 = t138 * t332
  t349 = t103 * t337
  t352 = t74 * t59 * t11
  t354 = -0.25319000000000000000000000000000000000000000000000e1 * t330 + 0.16879333333333333333333333333333333333333333333333e1 * t333 - 0.19692555555555555555555555555555555555555555555555e1 * t338 - 0.93011851851851851851851851851851851851851851851854e0 * t341 + 0.13651666666666666666666666666666666666666666666667e0 * t345 - 0.27303333333333333333333333333333333333333333333333e0 * t347 - 0.31853888888888888888888888888888888888888888888890e0 * t349 - 0.36514074074074074074074074074074074074074074074075e0 * t352
  t355 = t354 * t110
  t359 = 0.1e1 / t217 / t183
  t360 = t201 * t189
  t363 = 0.1e1 / t220 / t176
  t364 = t359 * t360 * t363
  t368 = 0.1e1 / t217 / t173
  t370 = t368 * t360 * t221
  t381 = -0.34523333333333333333333333333333333333333333333333e1 * t330 + 0.23015555555555555555555555555555555555555555555556e1 * t333 - 0.26851481481481481481481481481481481481481481481482e1 * t338 - 0.93932222222222222222222222222222222222222222222223e0 * t341 + 0.73355000000000000000000000000000000000000000000000e-1 * t345 - 0.14671000000000000000000000000000000000000000000000e0 * t347 - 0.17116166666666666666666666666666666666666666666667e0 * t349 - 0.36793333333333333333333333333333333333333333333333e0 * t352
  t383 = t184 * t381 * t191
  t389 = t313 * t110
  t398 = 0.48245938496077605200268890697218139186316165284153e2 * t152 * t306 * t109 + 0.51726012919273400298984252201052768390886626637712e3 * t312 * t316 - 0.96491876992155210400537781394436278372632330568306e2 * t321 * t322 + 0.10000000000000000000000000000000000000000000000000e1 * t124 * t355 - 0.10254018858216406658218194626490193680059335835414e4 * t198 * t364 + 0.10389515463408878255799889850284635099347639899143e3 * t198 * t370 - 0.58482236226346462072622386637590534819724553404280e0 * t198 * t383 + 0.34450798614814814814814814814814814814814814814813e-2 * t58 * t340 * t83 + 0.60000000000000000000000000000000000000000000000000e1 * t152 * t389 - 0.60000000000000000000000000000000000000000000000000e1 * t119 * t111 * t146 - 0.32530743900905219527896202567159734993471782831130e-1 * t182 * t99 * t203
  t416 = t62 * t91
  t423 = t89 * t151
  t428 = t218 * t360 * t191
  t432 = t191 * t212
  t437 = t221 * t189
  t441 = -0.21687162600603479685264135044773156662314521887420e-1 * t182 * t63 * t192 + 0.16265371950452609763948101283579867496735891415565e-1 * t182 * t99 * t214 + 0.48159733137676571081572406076840235616767705782485e0 * t182 * t99 * t222 + 0.10685000000000000000000000000000000000000000000000e0 * t87 * t89 * t118 * t121 - 0.56968947174242584615102410102512416326352748836105e-3 * t168 * t95 * t336 * t177 + 0.71233333333333333333333333333333333333333333333331e-1 * t87 * t416 * t111 - 0.53424999999999999999999999999999999999999999999999e-1 * t87 * t92 * t147 - 0.85917975471764868594145516183295969534298037676861e0 * t87 * t423 * t155 - 0.35089341735807877243573431982554320891834732042568e1 * t198 * t428 + 0.35089341735807877243573431982554320891834732042568e1 * t198 * t200 * t189 * t432 - 0.51947577317044391278999449251423175496738199495715e2 * t198 * t218 * t212 * t437
  t442 = t398 + t441
  t445 = t41 * t16
  t448 = 0.1e1 - 0.5e1 / 0.9e1 * t445 * t38
  t449 = t167 * t87
  t451 = t212 * t221
  t457 = t189 * t191
  t474 = 0.1e1 / t3 / t230
  t475 = t60 * t474
  t497 = t120 ** 2
  t501 = 0.19263893255070628432628962430736094246707082312995e1 * t449 * t89 * t218 * t451 * t189 - 0.13012297560362087811158481026863893997388713132452e0 * t449 * t89 * t200 * t457 * t212 + 0.31035607751564040179390551320631661034531975982628e4 * t312 * t146 * t315 * t120 + 0.64327917994770140267025187596290852248421553712204e2 * t152 * t354 * t154 * t109 + 0.36000000000000000000000000000000000000000000000000e2 * t152 * t121 * t146 - 0.11483599538271604938271604938271604938271604938271e-1 * t58 * t475 * t83 - 0.80000000000000000000000000000000000000000000000000e1 * t119 * t355 * t109 - 0.57895126195293126240322668836661767023579398340984e3 * t321 * t306 * t120 + 0.42740000000000000000000000000000000000000000000000e0 * t100 * t118 * t109 * t147 - 0.34367190188705947437658206473318387813719215070744e1 * t100 * t151 * t146 * t154 * t109 - 0.62071215503128080358781102641263322069063951965254e4 * t116 / t150 / t117 * t497 * t315
  t502 = t150 ** 2
  t505 = t153 ** 2
  t513 = t146 ** 2
  t523 = t230 * r0
  t525 = 0.1e1 / t3 / t523
  t527 = 0.1e1 / t67 * r0 * t525 * t87 / 0.48e2
  t529 = 0.1e1 / t523
  t530 = t328 * t529
  t532 = t128 * t232
  t533 = t127 * t532
  t535 = t95 * t474
  t536 = t94 * t535
  t538 = t58 * t475
  t540 = t66 ** (-0.25e1)
  t543 = t540 * t56 * t525 * t87
  t545 = t344 * t529
  t547 = t138 * t532
  t549 = t103 * t535
  t552 = t74 * t59 * t232
  t579 = t217 ** 2
  t581 = t201 ** 2
  t583 = t220 ** 2
  t588 = t212 ** 2
  t605 = 0.24955700379505800914252936827276051226357058527653e5 * t116 / t502 * t497 / t505 + 0.57895126195293126240322668836661767023579398340984e3 * t312 * t497 * t154 + 0.48245938496077605200268890697218139186316165284153e2 * t152 * t513 * t154 + 0.10000000000000000000000000000000000000000000000000e1 * t124 * (-0.21099166666666666666666666666666666666666666666667e1 * t527 + 0.20255200000000000000000000000000000000000000000000e2 * t530 - 0.75019259259259259259259259259259259259259259259258e1 * t533 + 0.65641851851851851851851851851851851851851851851850e1 * t536 + 0.31003950617283950617283950617283950617283950617285e1 * t538 + 0.68258333333333333333333333333333333333333333333335e-1 * t543 - 0.10921333333333333333333333333333333333333333333333e1 * t545 + 0.12134814814814814814814814814814814814814814814815e1 * t547 + 0.10617962962962962962962962962962962962962962962963e1 * t549 + 0.13388493827160493827160493827160493827160493827161e1 * t552) * t110 - 0.60000000000000000000000000000000000000000000000000e1 * t119 * t513 * t110 - 0.24000000000000000000000000000000000000000000000000e2 * t321 * t497 * t110 - 0.58482236226346462072622386637590534819724553404280e0 * t198 * t184 * (-0.28769444444444444444444444444444444444444444444444e1 * t527 + 0.27618666666666666666666666666666666666666666666667e2 * t530 - 0.10229135802469135802469135802469135802469135802469e2 * t533 + 0.89504938271604938271604938271604938271604938271607e1 * t536 + 0.31310740740740740740740740740740740740740740740741e1 * t538 + 0.36677500000000000000000000000000000000000000000000e-1 * t543 - 0.58684000000000000000000000000000000000000000000000e0 * t545 + 0.65204444444444444444444444444444444444444444444445e0 * t547 + 0.57053888888888888888888888888888888888888888888890e0 * t549 + 0.13490888888888888888888888888888888888888888888889e1 * t552) * t191 - 0.91082604192152556048340974007871726131433263376469e5 * t198 / t579 * t581 / t583 - 0.51947577317044391278999449251423175496738199495715e2 * t198 * t218 * t588 * t221 + 0.35089341735807877243573431982554320891834732042568e1 * t198 * t200 * t588 * t191 + 0.14035736694323150897429372793021728356733892817027e2 * t198 * t368 * t581 * t191 - 0.62337092780453269534799339101707810596085839394858e3 * t198 * t359 * t581 * t221
  t652 = 0.12304822629859687989861833551788232416071203002497e5 * t198 / t217 / t199 * t581 * t363 - 0.69263436422725855038665932335230900662317599327620e2 * t198 * t218 * t381 * t437 - 0.22161481481481481481481481481481481481481481481481e0 * t87 * t336 * t91 * t111 - 0.42740000000000000000000000000000000000000000000000e0 * t87 * t423 * t389 + 0.62337092780453269534799339101707810596085839394858e3 * t198 * t368 * t201 * t451 + 0.46785788981077169658097909310072427855779642723424e1 * t198 * t200 * t381 * t457 - 0.36846163202829085479643115651216588683774907041596e2 * t87 * t89 * t311 * t316 + 0.68734380377411894875316412946636775627438430141488e1 * t87 * t89 * t320 * t322 - 0.71233333333333333333333333333333333333333333333332e-1 * t87 * t92 * t355 - 0.61524113149298439949309167758941162080356015012483e4 * t198 * t359 * t201 * t363 * t212 - 0.28493333333333333333333333333333333333333333333333e0 * t87 * t62 * t118 * t121
  t691 = 0.18989649058080861538367470034170805442117582945368e-2 * t168 * t95 * t474 * t177 + 0.22911460125803964958438804315545591875812810047162e1 * t87 * t62 * t151 * t155 - 0.21053605041484726346144059189532592535100839225540e2 * t198 * t219 * t432 + 0.14246666666666666666666666666666666666666666666666e0 * t87 * t416 * t147 + 0.86748650402413918741056540179092626649258087549680e-1 * t182 * t63 * t203 + 0.13012297560362087811158481026863893997388713132452e0 * t182 * t99 * t428 + 0.67471172535210825687488420139294265171645179205307e-1 * t182 * t340 * t192 - 0.43374325201206959370528270089546313324629043774840e-1 * t182 * t63 * t214 - 0.12842595503380418955085974953824062831138054875329e1 * t182 * t63 * t222 + 0.38025319932552508024225805073234468230220037056326e2 * t182 * t99 * t364 - 0.38527786510141256865257924861472188493414164625988e1 * t182 * t99 * t370 + 0.21687162600603479685264135044773156662314521887420e-1 * t182 * t99 * t383
  t693 = t501 + t605 + t652 + t691
  t698 = 0.1e1 / t4 / t523
  t706 = 0.6160e4 / 0.81e2 * tau0 * t698 - 0.2618e4 / 0.81e2 * s0 / t4 / t230 / t2
  t708 = t1 * t706 * t16
  t715 = -0.440e3 / 0.27e2 * tau0 * t232 + 0.154e3 / 0.27e2 * s0 * t698
  t716 = t1 * t715
  t723 = t235 ** 2
  t724 = t1 * t723
  t729 = t1 * t290 * t297
  t740 = t24 * t235
  t747 = t14 * t715
  t757 = t716 * t16
  t760 = t236 * t45
  t763 = t1 * t301
  t764 = t249 * t252
  t771 = t14 * t235
  t779 = -0.5e1 / 0.9e1 * t757 * t38 + 0.100e3 / 0.27e2 * t760 * t51 - 0.2000e4 / 0.81e2 * t763 * t764 * t253 + 0.10000e5 / 0.729e3 * t41 * t297 * t303 - 0.2000e4 / 0.81e2 * t250 * t254 * t771 + 0.50e2 / 0.81e2 * t46 * t49 * params.c * t715
  t783 = t41 * t297 * t286
  t789 = t241 * t45
  t790 = t225 * params.c
  t794 = t41 * t764
  t799 = t286 * t253
  t804 = t286 * params.c
  t809 = t24 * t37 * t286
  t813 = t24 * t37 * t274
  t816 = 0.400000e6 / 0.6561e4 * t41 * t280 * t286 * t293 - 0.40000e5 / 0.729e3 * t41 * t297 * t274 * t303 + 0.4e1 * t54 * t442 + t448 * t693 + 0.6e1 * t262 * t225 + (-0.5e1 / 0.9e1 * t708 * t38 + 0.400e3 / 0.81e2 * t716 * t45 * t51 - 0.4000e4 / 0.27e2 * t236 * t249 * t255 + 0.100e3 / 0.27e2 * t724 * t42 * t245 + 0.40000e5 / 0.729e3 * t729 * t300 * t16 * t24 - 0.400000e6 / 0.6561e4 * t41 * t280 * t293 + 0.20000e5 / 0.243e3 * t41 * t297 * t300 * t240 * t16 * t740 - 0.2000e4 / 0.81e2 * t250 * t254 * t723 - 0.8000e4 / 0.243e3 * t250 * t254 * t747 + 0.50e2 / 0.81e2 * t46 * t49 * params.c * t706) * t286 + 0.4e1 * t779 * t274 - 0.20000e5 / 0.243e3 * t783 * t300 * t240 * t16 * t740 - 0.200e3 / 0.27e2 * t789 * t49 * t790 + 0.8000e4 / 0.81e2 * t794 * t274 * t253 * t771 + 0.8000e4 / 0.243e3 * t794 * t799 * t747 - 0.100e3 / 0.27e2 * t724 * t45 * t49 * t804 + 0.5e1 / 0.9e1 * t708 * t809 + 0.20e2 / 0.9e1 * t757 * t813
  t818 = t24 * t37 * t225
  t822 = t253 * t240
  t826 = t252 * t286
  t841 = t24 * t37 * t442
  t844 = t763 * t249
  t845 = t252 * t274
  t853 = t15 * t45
  t854 = t274 * params.c
  t856 = t49 * t854 * t235
  t868 = t49 * t804 * t715
  t880 = 0.10e2 / 0.3e1 * t237 * t818 + 0.4000e4 / 0.81e2 * t250 * t252 * t225 * t822 + 0.2000e4 / 0.81e2 * t250 * t826 * t253 * t723 + 0.5e1 / 0.9e1 * t445 * t24 * t37 * t693 + 0.4000e4 / 0.27e2 * t241 * t249 * t826 * t253 * t235 + 0.20e2 / 0.9e1 * t17 * t841 + 0.8000e4 / 0.81e2 * t844 * t845 * t253 - 0.40000e5 / 0.729e3 * t729 * t286 * t300 * t33 - 0.400e3 / 0.27e2 * t853 * t856 - 0.100e3 / 0.27e2 * t46 * t49 * t790 * t235 - 0.200e3 / 0.81e2 * t46 * t49 * t854 * t715 - 0.400e3 / 0.81e2 * t853 * t868 - 0.50e2 / 0.81e2 * t46 * t49 * t804 * t706 - 0.200e3 / 0.81e2 * t46 * t49 * t442 * params.c * t14
  v4rho4_0_ = 0.12e2 * t54 * t225 + 0.12e2 * t262 * t274 + r0 * (t816 + t880) + 0.4e1 * t779 * t286 + 0.4e1 * t448 * t442 + 0.20e2 / 0.3e1 * t237 * t813 + 0.20e2 / 0.3e1 * t17 * t818 + 0.8000e4 / 0.81e2 * t250 * t845 * t822 + 0.20e2 / 0.9e1 * t445 * t841 + 0.20e2 / 0.9e1 * t757 * t809 + 0.8000e4 / 0.81e2 * t844 * t826 * t253 - 0.40000e5 / 0.729e3 * t783 * t303 - 0.200e3 / 0.27e2 * t46 * t856 - 0.200e3 / 0.81e2 * t46 * t868 - 0.400e3 / 0.27e2 * t760 * t49 * t804 * t14 - 0.200e3 / 0.27e2 * t46 * t49 * t790 * t14 + 0.8000e4 / 0.81e2 * t794 * t799 * t771 - 0.400e3 / 0.27e2 * t789 * t49 * t854

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 + r1
  t2 = 0.1e1 + params.c
  t3 = r0 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t7 = tau0 / t4 / r0
  t8 = r0 - r1
  t9 = 0.1e1 / t1
  t10 = t8 * t9
  t11 = 0.1e1 + t10
  t12 = t11 / 0.2e1
  t13 = t12 ** (0.1e1 / 0.3e1)
  t14 = t13 ** 2
  t15 = t14 * t12
  t16 = t7 * t15
  t17 = r1 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t21 = tau1 / t18 / r1
  t22 = 0.1e1 - t10
  t23 = t22 / 0.2e1
  t24 = t23 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t27 = t21 * t25 * t23
  t29 = s0 + 0.2e1 * s1 + s2
  t30 = t1 ** 2
  t31 = t1 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t34 = 0.1e1 / t32 / t30
  t37 = t16 + t27 - t29 * t34 / 0.8e1
  t38 = t2 * t37
  t39 = 6 ** (0.1e1 / 0.3e1)
  t41 = jnp.pi ** 2
  t42 = t41 ** (0.1e1 / 0.3e1)
  t43 = t42 ** 2
  t44 = 0.1e1 / t43
  t45 = 2 ** (0.1e1 / 0.3e1)
  t46 = t45 ** 2
  t49 = t39 * t44
  t50 = t49 * t46
  t53 = 0.1e1 + 0.5e1 / 0.9e1 * params.c * t37 * t50
  t54 = 0.1e1 / t53
  t55 = t44 * t46 * t54
  t58 = 0.1e1 - 0.5e1 / 0.9e1 * t38 * t39 * t55
  t59 = t11 <= f.p.zeta_threshold
  t60 = t11 ** (0.1e1 / 0.3e1)
  t61 = 0.1e1 / t30
  t63 = -t8 * t61 + t9
  t66 = f.my_piecewise3(t59, 0, 0.4e1 / 0.3e1 * t60 * t63)
  t67 = t22 <= f.p.zeta_threshold
  t68 = t22 ** (0.1e1 / 0.3e1)
  t69 = -t63
  t72 = f.my_piecewise3(t67, 0, 0.4e1 / 0.3e1 * t68 * t69)
  t76 = 0.1e1 / (0.2e1 * t45 - 0.2e1)
  t77 = (t66 + t72) * t76
  t78 = 3 ** (0.1e1 / 0.3e1)
  t79 = 0.1e1 / jnp.pi
  t80 = t79 ** (0.1e1 / 0.3e1)
  t81 = t78 * t80
  t82 = 4 ** (0.1e1 / 0.3e1)
  t83 = t82 ** 2
  t86 = t81 * t83 / t31
  t88 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t86
  t89 = t77 * t88
  t90 = jnp.sqrt(t86)
  t93 = t86 ** 0.15e1
  t95 = t78 ** 2
  t96 = t80 ** 2
  t97 = t95 * t96
  t100 = t97 * t82 / t32
  t102 = 0.51785000000000000000000000000000000000000000000000e1 * t90 + 0.90577500000000000000000000000000000000000000000000e0 * t86 + 0.11003250000000000000000000000000000000000000000000e0 * t93 + 0.12417750000000000000000000000000000000000000000000e0 * t100
  t103 = t102 ** 2
  t105 = 0.1e1 / t103 / t102
  t107 = 0.1e1 / t90 * t78
  t108 = t80 * t83
  t110 = 0.1e1 / t31 / t1
  t111 = t108 * t110
  t112 = t107 * t111
  t114 = t83 * t110
  t115 = t81 * t114
  t117 = t86 ** 0.5e0
  t118 = t117 * t78
  t119 = t118 * t111
  t124 = t97 * t82 / t32 / t1
  t126 = -0.86308333333333333333333333333333333333333333333334e0 * t112 - 0.30192500000000000000000000000000000000000000000000e0 * t115 - 0.55016250000000000000000000000000000000000000000000e-1 * t119 - 0.82785000000000000000000000000000000000000000000000e-1 * t124
  t127 = t126 ** 2
  t131 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t102
  t132 = 0.1e1 / t131
  t133 = t105 * t127 * t132
  t136 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t137 = t136 * f.p.zeta_threshold
  t139 = f.my_piecewise3(t59, t137, t60 * t11)
  t141 = f.my_piecewise3(t67, t137, t68 * t22)
  t143 = (t139 + t141 - 0.2e1) * t76
  t144 = t143 * t88
  t145 = t103 ** 2
  t147 = 0.1e1 / t145 / t103
  t148 = t127 * t126
  t150 = t131 ** 2
  t152 = 0.1e1 / t150 / t131
  t156 = t60 ** 2
  t157 = 0.1e1 / t156
  t158 = t63 ** 2
  t161 = t30 * t1
  t162 = 0.1e1 / t161
  t164 = t8 * t162 - t61
  t165 = 0.2e1 * t164
  t169 = f.my_piecewise3(t59, 0, 0.4e1 / 0.9e1 * t157 * t158 + 0.4e1 / 0.3e1 * t60 * t165)
  t170 = t68 ** 2
  t171 = 0.1e1 / t170
  t172 = t69 ** 2
  t175 = -t165
  t179 = f.my_piecewise3(t67, 0, 0.4e1 / 0.9e1 * t171 * t172 + 0.4e1 / 0.3e1 * t68 * t175)
  t181 = (t169 + t179) * t76
  t183 = 0.1e1 / t103
  t185 = t183 * t126 * t132
  t188 = 0.1e1 / t145
  t190 = 0.1e1 / t150
  t191 = t188 * t127 * t190
  t196 = 0.1e1 / t90 / t86 * t95
  t197 = t96 * t82
  t198 = t197 * t34
  t199 = t196 * t198
  t202 = 0.1e1 / t31 / t30
  t203 = t108 * t202
  t204 = t107 * t203
  t206 = t83 * t202
  t207 = t81 * t206
  t209 = t86 ** (-0.5e0)
  t210 = t209 * t95
  t211 = t210 * t198
  t213 = t118 * t203
  t216 = t97 * t82 * t34
  t218 = -0.57538888888888888888888888888888888888888888888889e0 * t199 + 0.11507777777777777777777777777777777777777777777778e1 * t204 + 0.40256666666666666666666666666666666666666666666667e0 * t207 + 0.36677500000000000000000000000000000000000000000000e-1 * t211 + 0.73355000000000000000000000000000000000000000000000e-1 * t213 + 0.13797500000000000000000000000000000000000000000000e0 * t216
  t220 = t183 * t218 * t132
  t227 = t30 ** 2
  t228 = 0.1e1 / t227
  t229 = 0.1e1 / t90 / t100 * t79 * t228 / 0.4e1
  t232 = 0.1e1 / t32 / t161
  t233 = t197 * t232
  t234 = t196 * t233
  t237 = 0.1e1 / t31 / t161
  t238 = t108 * t237
  t239 = t107 * t238
  t241 = t83 * t237
  t242 = t81 * t241
  t244 = t86 ** (-0.15e1)
  t246 = t244 * t79 * t228
  t248 = t210 * t233
  t250 = t118 * t238
  t253 = t97 * t82 * t232
  t255 = -0.34523333333333333333333333333333333333333333333333e1 * t229 + 0.23015555555555555555555555555555555555555555555556e1 * t234 - 0.26851481481481481481481481481481481481481481481482e1 * t239 - 0.93932222222222222222222222222222222222222222222223e0 * t242 + 0.73355000000000000000000000000000000000000000000000e-1 * t246 - 0.14671000000000000000000000000000000000000000000000e0 * t248 - 0.17116166666666666666666666666666666666666666666667e0 * t250 - 0.36793333333333333333333333333333333333333333333333e0 * t253
  t265 = 0.1e1 / t145 / t102
  t270 = t143 * t81
  t283 = 0.35089341735807877243573431982554320891834732042568e1 * t89 * t133 - 0.10254018858216406658218194626490193680059335835414e4 * t144 * t147 * t148 * t152 - 0.17544670867903938621786715991277160445917366021284e1 * t181 * t88 * t185 - 0.51947577317044391278999449251423175496738199495715e2 * t89 * t191 - 0.17544670867903938621786715991277160445917366021284e1 * t89 * t220 - 0.58482236226346462072622386637590534819724553404280e0 * t144 * t183 * t255 * t132 - 0.35089341735807877243573431982554320891834732042568e1 * t144 * t188 * t148 * t132 + 0.10389515463408878255799889850284635099347639899143e3 * t144 * t265 * t148 * t190 - 0.21687162600603479685264135044773156662314521887420e-1 * t270 * t206 * t185 - 0.32530743900905219527896202567159734993471782831130e-1 * t270 * t114 * t133 + 0.16265371950452609763948101283579867496735891415565e-1 * t270 * t114 * t220 + 0.48159733137676571081572406076840235616767705782485e0 * t270 * t114 * t191
  t285 = t114 * t185
  t289 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t86
  t294 = 0.37978500000000000000000000000000000000000000000000e1 * t90 + 0.89690000000000000000000000000000000000000000000000e0 * t86 + 0.20477500000000000000000000000000000000000000000000e0 * t93 + 0.12323500000000000000000000000000000000000000000000e0 * t100
  t295 = t294 ** 2
  t296 = t295 ** 2
  t297 = 0.1e1 / t296
  t298 = t289 * t297
  t303 = -0.63297500000000000000000000000000000000000000000000e0 * t112 - 0.29896666666666666666666666666666666666666666666667e0 * t115 - 0.10238750000000000000000000000000000000000000000000e0 * t119 - 0.82156666666666666666666666666666666666666666666667e-1 * t124
  t304 = t303 ** 2
  t305 = t304 * t303
  t308 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t294
  t309 = 0.1e1 / t308
  t312 = 0.60000000000000000000000000000000000000000000000000e1 * t298 * t305 * t309
  t313 = 0.1e1 / t295
  t314 = t289 * t313
  t326 = 0.10000000000000000000000000000000000000000000000000e1 * t314 * (-0.25319000000000000000000000000000000000000000000000e1 * t229 + 0.16879333333333333333333333333333333333333333333333e1 * t234 - 0.19692555555555555555555555555555555555555555555555e1 * t239 - 0.93011851851851851851851851851851851851851851851854e0 * t242 + 0.13651666666666666666666666666666666666666666666667e0 * t246 - 0.27303333333333333333333333333333333333333333333333e0 * t248 - 0.31853888888888888888888888888888888888888888888890e0 * t250 - 0.36514074074074074074074074074074074074074074074075e0 * t253) * t309
  t330 = t308 ** 2
  t331 = 0.1e1 / t330
  t334 = 0.96491876992155210400537781394436278372632330568306e2 * t289 / t296 / t294 * t305 * t331
  t343 = t8 * t228
  t344 = t162 - t343
  t345 = 0.6e1 * t344
  t349 = f.my_piecewise3(t59, 0, -0.8e1 / 0.27e2 / t156 / t11 * t158 * t63 + 0.4e1 / 0.3e1 * t157 * t63 * t165 + 0.4e1 / 0.3e1 * t60 * t345)
  t362 = f.my_piecewise3(t67, 0, -0.8e1 / 0.27e2 / t170 / t22 * t172 * t69 + 0.4e1 / 0.3e1 * t171 * t69 * t175 - 0.4e1 / 0.3e1 * t68 * t345)
  t364 = (t349 + t362) * t76
  t365 = jnp.log(t131)
  t366 = t88 * t365
  t376 = 0.51726012919273400298984252201052768390886626637712e3 * t289 / t296 / t295 * t305 / t330 / t308
  t377 = t8 ** 2
  t378 = t377 * t8
  t379 = t378 * t228
  t384 = 0.70594500000000000000000000000000000000000000000000e1 * t90 + 0.15494250000000000000000000000000000000000000000000e1 * t86 + 0.42077500000000000000000000000000000000000000000000e0 * t93 + 0.15629250000000000000000000000000000000000000000000e0 * t100
  t387 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t384
  t388 = jnp.log(t387)
  t393 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t86
  t394 = t384 ** 2
  t395 = 0.1e1 / t394
  t396 = t393 * t395
  t401 = -0.11765750000000000000000000000000000000000000000000e1 * t112 - 0.51647500000000000000000000000000000000000000000000e0 * t115 - 0.21038750000000000000000000000000000000000000000000e0 * t119 - 0.10419500000000000000000000000000000000000000000000e0 * t124
  t402 = 0.1e1 / t387
  t403 = t401 * t402
  t406 = jnp.log(t308)
  t409 = 0.11073470983333333333333333333333333333333333333333e-2 * t81 * t114 * t406
  t410 = t303 * t309
  t412 = 0.10000000000000000000000000000000000000000000000000e1 * t314 * t410
  t416 = t88 * t183
  t417 = t126 * t132
  t420 = 0.53237641966666666666666666666666666666666666666666e-3 * t81 * t114 * t388 + 0.10000000000000000000000000000000000000000000000000e1 * t396 * t403 - t409 - t412 + 0.18311447306006545054854346104378990962041954983034e-3 * t81 * t114 * t365 + 0.58482236226346462072622386637590534819724553404280e0 * t416 * t417
  t421 = t77 * t420
  t424 = t227 * t1
  t425 = 0.1e1 / t424
  t426 = t378 * t425
  t427 = t143 * t420
  t430 = t377 * t228
  t434 = 0.621814e-1 * t289 * t406
  t436 = -0.3109070e-1 * t393 * t388 + t434 - 0.19751673498613801407483339618206552048944131217655e-1 * t366
  t437 = t77 * t436
  t442 = t377 ** 2
  t443 = t442 * t228
  t449 = t442 * t425
  t452 = 0.32530743900905219527896202567159734993471782831130e-1 * t77 * t81 * t285 + t312 + t326 - t334 + 0.19751673498613801407483339618206552048944131217655e-1 * t364 * t366 + t376 + 0.24e2 * t379 * t421 - 0.96e2 * t426 * t427 + 0.36e2 * t430 * t437 + 0.36e2 * t430 * t427 + 0.3e1 * t443 * t181 * t420 - 0.96e2 * t426 * t437 - 0.24e2 * t449 * t421
  t454 = t181 * t436
  t461 = t227 * t30
  t462 = 0.1e1 / t461
  t463 = t442 * t462
  t466 = t143 * t436
  t475 = t227 * t161
  t483 = t81 * t83
  t484 = t110 * t395
  t489 = 0.1e1 / t394 / t384
  t490 = t393 * t489
  t491 = t401 ** 2
  t492 = t491 * t402
  t501 = -0.78438333333333333333333333333333333333333333333333e0 * t199 + 0.15687666666666666666666666666666666666666666666667e1 * t204 + 0.68863333333333333333333333333333333333333333333333e0 * t207 + 0.14025833333333333333333333333333333333333333333333e0 * t211 + 0.28051666666666666666666666666666666666666666666667e0 * t213 + 0.17365833333333333333333333333333333333333333333333e0 * t216
  t502 = t501 * t402
  t505 = t394 ** 2
  t506 = 0.1e1 / t505
  t507 = t393 * t506
  t508 = t387 ** 2
  t509 = 0.1e1 / t508
  t510 = t491 * t509
  t515 = 0.14764627977777777777777777777777777777777777777777e-2 * t81 * t206 * t406
  t516 = t110 * t313
  t519 = 0.35616666666666666666666666666666666666666666666666e-1 * t483 * t516 * t410
  t521 = 0.1e1 / t295 / t294
  t522 = t289 * t521
  t523 = t304 * t309
  t525 = 0.20000000000000000000000000000000000000000000000000e1 * t522 * t523
  t532 = -0.42198333333333333333333333333333333333333333333333e0 * t199 + 0.84396666666666666666666666666666666666666666666666e0 * t204 + 0.39862222222222222222222222222222222222222222222223e0 * t207 + 0.68258333333333333333333333333333333333333333333333e-1 * t211 + 0.13651666666666666666666666666666666666666666666667e0 * t213 + 0.13692777777777777777777777777777777777777777777778e0 * t216
  t533 = t532 * t309
  t535 = 0.10000000000000000000000000000000000000000000000000e1 * t314 * t533
  t536 = t304 * t331
  t538 = 0.16081979498692535066756296899072713062105388428051e2 * t298 * t536
  t542 = t110 * t183
  t546 = t88 * t105
  t547 = t127 * t132
  t550 = t218 * t132
  t553 = t88 * t188
  t554 = t127 * t190
  t557 = -0.70983522622222222222222222222222222222222222222221e-3 * t81 * t206 * t388 - 0.34246666666666666666666666666666666666666666666666e-1 * t483 * t484 * t403 - 0.20000000000000000000000000000000000000000000000000e1 * t490 * t492 + 0.10000000000000000000000000000000000000000000000000e1 * t396 * t502 + 0.32163958997385070133512593798145426124210776856102e2 * t507 * t510 + t515 + t519 + t525 - t535 - t538 - 0.24415263074675393406472461472505321282722606644045e-3 * t81 * t206 * t365 - 0.10843581300301739842632067522386578331157260943710e-1 * t483 * t542 * t417 - 0.11696447245269292414524477327518106963944910680856e1 * t546 * t547 + 0.58482236226346462072622386637590534819724553404280e0 * t416 * t550 + 0.17315859105681463759666483083807725165579399831905e2 * t553 * t554
  t558 = t143 * t557
  t568 = 0.12e2 * t379 * t454 - 0.12e2 * t449 * t454 + t443 * t364 * t436 + 0.60e2 * t463 * t427 + 0.24e2 * t343 * t466 - 0.144e3 * t377 * t425 * t466 + 0.240e3 * t378 * t462 * t466 - 0.120e3 * t442 / t475 * t466 + 0.12e2 * t379 * t558 + 0.60e2 * t463 * t437 + 0.3e1 * t443 * t77 * t557 - 0.12e2 * t449 * t558
  t594 = 0.60000000000000000000000000000000000000000000000000e1 * t522 * t410 * t532
  t597 = 0.34450798614814814814814814814814814814814814814813e-2 * t81 * t241 * t406
  t601 = 0.48245938496077605200268890697218139186316165284153e2 * t298 * t532 * t331 * t303
  t605 = t491 * t401
  t613 = 0.35089341735807877243573431982554320891834732042568e1 * t553 * t148 * t132 - t312 - t326 + t334 - t376 - 0.35089341735807877243573431982554320891834732042568e1 * t546 * t417 * t218 + 0.16562821945185185185185185185185185185185185185185e-2 * t81 * t241 * t388 + 0.96491876992155210400537781394436278372632330568306e2 * t507 * t501 * t509 * t401 - 0.60000000000000000000000000000000000000000000000000e1 * t490 * t403 * t501 + 0.51947577317044391278999449251423175496738199495715e2 * t553 * t218 * t190 * t126 + 0.56968947174242584615102410102512416326352748836105e-3 * t81 * t241 * t365 + t594 - t597 - t601 - 0.19298375398431042080107556278887255674526466113661e3 * t393 / t505 / t384 * t605 * t509 - 0.10389515463408878255799889850284635099347639899143e3 * t88 * t265 * t148 * t190
  t654 = 0.10685000000000000000000000000000000000000000000000e0 * t483 * t110 * t521 * t523
  t658 = 0.85917975471764868594145516183295969534298037676861e0 * t483 * t110 * t297 * t536
  t662 = 0.71233333333333333333333333333333333333333333333331e-1 * t483 * t202 * t313 * t410
  t665 = 0.53424999999999999999999999999999999999999999999999e-1 * t483 * t516 * t533
  t689 = 0.10000000000000000000000000000000000000000000000000e1 * t396 * (-0.47063000000000000000000000000000000000000000000000e1 * t229 + 0.31375333333333333333333333333333333333333333333334e1 * t234 - 0.36604555555555555555555555555555555555555555555556e1 * t239 - 0.16068111111111111111111111111111111111111111111111e1 * t242 + 0.28051666666666666666666666666666666666666666666666e0 * t246 - 0.56103333333333333333333333333333333333333333333332e0 * t248 - 0.65453888888888888888888888888888888888888888888890e0 * t250 - 0.46308888888888888888888888888888888888888888888888e0 * t253) * t402 + 0.58482236226346462072622386637590534819724553404280e0 * t416 * t255 * t132 + 0.60000000000000000000000000000000000000000000000000e1 * t507 * t605 * t402 + 0.10254018858216406658218194626490193680059335835414e4 * t88 * t147 * t148 * t152 + 0.20690405167709360119593700880421107356354650655085e4 * t393 / t505 / t394 * t605 / t508 / t387 - 0.51369999999999999999999999999999999999999999999999e-1 * t483 * t484 * t502 - 0.16522625736956710527585419434107305400007076070979e1 * t483 * t110 * t506 * t510 - t654 + t658 - t662 + t665 + 0.10274000000000000000000000000000000000000000000000e0 * t483 * t110 * t489 * t492 + 0.32530743900905219527896202567159734993471782831130e-1 * t483 * t110 * t105 * t547 + 0.21687162600603479685264135044773156662314521887420e-1 * t483 * t202 * t183 * t417 - 0.16265371950452609763948101283579867496735891415565e-1 * t483 * t542 * t550 - 0.48159733137676571081572406076840235616767705782485e0 * t483 * t110 * t188 * t554 + 0.68493333333333333333333333333333333333333333333332e-1 * t483 * t202 * t395 * t403
  t695 = t108 * t110 * t365
  t707 = t77 * t78
  t709 = t108 * t202 * t365
  t712 = t143 * t78
  t717 = t443 * t143 * (t613 + t689) - t594 + t597 + t601 - 0.54934341918019635164563038313136972886125864949102e-3 * t181 * t78 * t695 - 0.51947577317044391278999449251423175496738199495715e2 * t144 * t188 * t218 * t190 * t126 + 0.35089341735807877243573431982554320891834732042568e1 * t144 * t105 * t218 * t417 + 0.73245789224026180219417384417515963848167819932136e-3 * t707 * t709 - 0.56968947174242584615102410102512416326352748836105e-3 * t712 * t108 * t237 * t365 + t654 - t658 + t662 - t665
  t719 = t283 + t452 + t568 + t717
  t721 = t39 ** 2
  t723 = 0.1e1 / t42 / t41
  t724 = t721 * t723
  t725 = t724 * t45
  t726 = t38 * t725
  t727 = t53 ** 2
  t728 = 0.1e1 / t727
  t731 = t29 / t32 / t227
  t732 = t16 + t27
  t733 = 0.1e1 / t732
  t734 = t733 * t377
  t737 = 0.1e1 - t731 * t734 / 0.8e1
  t738 = t728 * t737
  t751 = t409 + t412 + 0.4e1 * t379 * t466 - 0.4e1 * t449 * t466 + t443 * t437 + t443 * t427 + 0.19751673498613801407483339618206552048944131217655e-1 * t77 * t366 - 0.18311447306006545054854346104378990962041954983034e-3 * t712 * t695 - 0.58482236226346462072622386637590534819724553404280e0 * t144 * t185
  t752 = t751 * params.c
  t753 = r0 ** 2
  t757 = tau0 / t4 / t753 / r0
  t759 = 0.40e2 / 0.9e1 * t757 * t15
  t762 = tau0 / t4 / t753
  t763 = t63 / 0.2e1
  t764 = t14 * t763
  t766 = 0.50e2 / 0.9e1 * t762 * t764
  t767 = 0.1e1 / t13
  t768 = t763 ** 2
  t769 = t767 * t768
  t771 = 0.10e2 / 0.9e1 * t7 * t769
  t772 = t14 * t164
  t774 = 0.5e1 / 0.3e1 * t7 * t772
  t775 = 0.1e1 / t24
  t776 = -t763
  t777 = t776 ** 2
  t780 = 0.10e2 / 0.9e1 * t21 * t775 * t777
  t781 = -t164
  t784 = 0.5e1 / 0.3e1 * t21 * t25 * t781
  t786 = t759 - t766 + t771 + t774 + t780 + t784 - 0.11e2 / 0.9e1 * t731
  t793 = t29 / t32 / t461
  t798 = t29 / t32 / t424
  t799 = t732 ** 2
  t800 = 0.1e1 / t799
  t801 = t800 * t377
  t802 = t762 * t15
  t803 = t7 * t764
  t805 = t21 * t25 * t776
  t807 = -0.5e1 / 0.3e1 * t802 + 0.5e1 / 0.3e1 * t803 + 0.5e1 / 0.3e1 * t805
  t808 = t801 * t807
  t811 = t733 * t8
  t815 = 0.1e1 / t799 / t732
  t817 = t807 ** 2
  t818 = t815 * t377 * t817
  t821 = t800 * t8
  t822 = t821 * t807
  t825 = t759 - t766 + t771 + t774 + t780 + t784
  t826 = t801 * t825
  t831 = -0.119e3 / 0.36e2 * t793 * t734 - 0.7e1 / 0.6e1 * t798 * t808 + 0.7e1 / 0.3e1 * t798 * t811 - t731 * t818 / 0.4e1 + t731 * t822 / 0.2e1 + t731 * t826 / 0.8e1 - t731 * t733 / 0.4e1
  t836 = -t434 + t443 * t466 + 0.19751673498613801407483339618206552048944131217655e-1 * t143 * t366
  t837 = t836 * params.c
  t843 = -0.5e1 / 0.3e1 * t802 + 0.5e1 / 0.3e1 * t803 + 0.5e1 / 0.3e1 * t805 + t29 * t232 / 0.3e1
  t844 = t837 * t843
  t854 = 0.7e1 / 0.12e2 * t798 * t734 + t731 * t808 / 0.8e1 - t731 * t811 / 0.4e1
  t855 = t728 * t854
  t856 = t752 * t843
  t860 = t837 * t786
  t864 = t2 * t786
  t869 = t753 ** 2
  t874 = 0.440e3 / 0.27e2 * tau0 / t4 / t869 * t15
  t876 = 0.200e3 / 0.9e1 * t757 * t764
  t878 = 0.50e2 / 0.9e1 * t762 * t769
  t880 = 0.25e2 / 0.3e1 * t762 * t772
  t886 = 0.10e2 / 0.27e2 * t7 / t13 / t12 * t768 * t763
  t890 = 0.10e2 / 0.3e1 * t7 * t767 * t763 * t164
  t891 = 0.3e1 * t344
  t894 = 0.5e1 / 0.3e1 * t7 * t14 * t891
  t900 = 0.10e2 / 0.27e2 * t21 / t24 / t23 * t777 * t776
  t904 = 0.10e2 / 0.3e1 * t21 * t775 * t776 * t781
  t908 = -0.5e1 / 0.3e1 * t21 * t25 * t891
  t910 = -t874 + t876 - t878 - t880 - t886 + t890 + t894 - t900 + t904 + t908 + 0.154e3 / 0.27e2 * t798
  t932 = t443 * t558 - 0.58482236226346462072622386637590534819724553404280e0 * t144 * t220 - 0.17315859105681463759666483083807725165579399831905e2 * t144 * t191 - 0.11696447245269292414524477327518106963944910680856e1 * t89 * t185 + 0.20e2 * t463 * t466 + 0.12e2 * t430 * t466 - 0.32e2 * t426 * t466 + 0.19751673498613801407483339618206552048944131217655e-1 * t181 * t366 + t538 + t535 + 0.10843581300301739842632067522386578331157260943710e-1 * t270 * t285
  t950 = t443 * t454 + 0.2e1 * t443 * t421 - 0.8e1 * t449 * t437 - 0.8e1 * t449 * t427 + 0.8e1 * t379 * t437 + 0.8e1 * t379 * t427 - t525 - 0.36622894612013090109708692208757981924083909966068e-3 * t707 * t695 + 0.11696447245269292414524477327518106963944910680856e1 * t144 * t133 - t519 - t515 + 0.24415263074675393406472461472505321282722606644045e-3 * t712 * t709
  t951 = t932 + t950
  t957 = t41 ** 2
  t958 = 0.1e1 / t957
  t960 = 0.1e1 / t727 / t53
  t961 = t958 * t960
  t962 = t38 * t961
  t963 = t737 * t836
  t964 = params.c ** 2
  t970 = t843 ** 2
  t971 = t2 * t970
  t972 = t971 * t724
  t973 = t45 * t728
  t974 = t854 * t836
  t979 = t737 * t751
  t993 = t38 * t958
  t994 = t960 * t964
  t998 = t38 * t724
  t1003 = -0.5e1 / 0.9e1 * t864 * t39 * t55 + 0.100e3 / 0.81e2 * t971 * t721 * t723 * t45 * t728 * params.c - 0.2000e4 / 0.243e3 * t993 * t994 * t970 + 0.50e2 / 0.81e2 * t998 * t973 * params.c * t786
  t1006 = t2 * t843
  t1011 = t973 * params.c * t843
  t1014 = -0.5e1 / 0.9e1 * t1006 * t39 * t55 + 0.50e2 / 0.81e2 * t998 * t1011
  t1017 = t2 * t910
  t1024 = t970 * t843
  t1025 = t2 * t1024
  t1029 = t727 ** 2
  t1031 = t958 / t1029
  t1033 = t964 * params.c
  t1048 = t58 * t719 - 0.50e2 / 0.27e2 * t726 * t738 * t752 * t786 - 0.50e2 / 0.27e2 * t726 * t728 * t831 * t844 - 0.100e3 / 0.27e2 * t726 * t855 * t856 - 0.50e2 / 0.27e2 * t726 * t855 * t860 - 0.100e3 / 0.27e2 * t864 * t725 * t738 * t844 - 0.50e2 / 0.81e2 * t726 * t738 * t837 * t910 - 0.50e2 / 0.27e2 * t726 * t738 * t951 * params.c * t843 + 0.2000e4 / 0.81e2 * t962 * t963 * t964 * t843 * t786 - 0.100e3 / 0.27e2 * t972 * t973 * t974 * params.c - 0.100e3 / 0.27e2 * t972 * t973 * t979 * params.c + 0.3e1 * t1003 * t751 + 0.3e1 * t1014 * t951 + (-0.5e1 / 0.9e1 * t1017 * t39 * t55 + 0.100e3 / 0.27e2 * t864 * t724 * t1011 - 0.2000e4 / 0.81e2 * t1025 * t961 * t964 + 0.10000e5 / 0.729e3 * t38 * t1031 * t1033 * t1024 * t50 - 0.2000e4 / 0.81e2 * t993 * t994 * t843 * t786 + 0.50e2 / 0.81e2 * t998 * t973 * params.c * t910) * t836
  t1062 = t38 * t49
  t1063 = t46 * t54
  t1077 = t1063 * t963
  t1080 = t864 * t49
  t1081 = t1063 * t974
  t1084 = t1063 * t979
  t1087 = t1006 * t49
  t1089 = t1063 * t831 * t836
  t1093 = t1063 * t854 * t751
  t1097 = t1063 * t737 * t951
  t1100 = t964 * t970
  t1124 = t799 ** 2
  t1150 = 0.595e3 / 0.27e2 * t29 / t32 / t475 * t734 + 0.119e3 / 0.12e2 * t793 * t808 - 0.119e3 / 0.6e1 * t793 * t811 + 0.7e1 / 0.2e1 * t798 * t818 - 0.7e1 * t798 * t822 - 0.7e1 / 0.4e1 * t798 * t826 + 0.7e1 / 0.2e1 * t798 * t733 + 0.3e1 / 0.4e1 * t731 / t1124 * t377 * t817 * t807 - 0.3e1 / 0.2e1 * t731 * t815 * t8 * t817 - 0.3e1 / 0.4e1 * t731 * t815 * t377 * t807 * t825 + 0.3e1 / 0.4e1 * t731 * t800 * t807 + 0.3e1 / 0.4e1 * t731 * t821 * t825 + t731 * t801 * (-t874 + t876 - t878 - t880 - t886 + t890 + t894 - t900 + t904 + t908) / 0.8e1
  t1155 = 0.2000e4 / 0.81e2 * t1025 * t958 * t960 * t737 * t836 * t964 - 0.10000e5 / 0.729e3 * t38 * t1031 * t737 * t836 * t1033 * t1024 * t50 + 0.5e1 / 0.3e1 * t1062 * t1063 * t831 * t751 + 0.5e1 / 0.3e1 * t1062 * t1063 * t854 * t951 + 0.5e1 / 0.9e1 * t1062 * t1063 * t737 * t719 + 0.5e1 / 0.9e1 * t1017 * t49 * t1077 + 0.5e1 / 0.3e1 * t1080 * t1081 + 0.5e1 / 0.3e1 * t1080 * t1084 + 0.5e1 / 0.3e1 * t1087 * t1089 + 0.10e2 / 0.3e1 * t1087 * t1093 + 0.5e1 / 0.3e1 * t1087 * t1097 + 0.2000e4 / 0.81e2 * t962 * t974 * t1100 + 0.2000e4 / 0.81e2 * t962 * t979 * t1100 + 0.5e1 / 0.9e1 * t1062 * t1063 * t1150 * t836
  d111 = t1 * (t1048 + t1155) + 0.6e1 * t1014 * t751 - 0.100e3 / 0.27e2 * t726 * t855 * t844 - 0.100e3 / 0.27e2 * t726 * t738 * t856 - 0.50e2 / 0.27e2 * t726 * t738 * t860 - 0.100e3 / 0.27e2 * t972 * t973 * t963 * params.c + 0.3e1 * t58 * t951 + 0.3e1 * t1003 * t836 + 0.2000e4 / 0.81e2 * t962 * t963 * t1100 + 0.5e1 / 0.3e1 * t1080 * t1077 + 0.5e1 / 0.3e1 * t1062 * t1089 + 0.10e2 / 0.3e1 * t1087 * t1084 + 0.10e2 / 0.3e1 * t1062 * t1093 + 0.5e1 / 0.3e1 * t1062 * t1097 + 0.10e2 / 0.3e1 * t1087 * t1081

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = 0.1e1 + params.c
  t2 = r0 ** 2
  t3 = r0 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t7 = tau0 / t4 / t2
  t8 = r0 - r1
  t9 = r0 + r1
  t10 = 0.1e1 / t9
  t11 = t8 * t10
  t12 = 0.1e1 + t11
  t13 = t12 / 0.2e1
  t14 = t13 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t16 = t15 * t13
  t17 = t7 * t16
  t21 = tau0 / t4 / r0
  t22 = t9 ** 2
  t23 = 0.1e1 / t22
  t25 = -t8 * t23 + t10
  t26 = t25 / 0.2e1
  t27 = t15 * t26
  t28 = t21 * t27
  t30 = r1 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t34 = tau1 / t31 / r1
  t35 = 0.1e1 - t11
  t36 = t35 / 0.2e1
  t37 = t36 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t39 = -t26
  t41 = t34 * t38 * t39
  t44 = s0 + 0.2e1 * s1 + s2
  t45 = t22 * t9
  t46 = t9 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t49 = 0.1e1 / t47 / t45
  t52 = -0.5e1 / 0.3e1 * t17 + 0.5e1 / 0.3e1 * t28 + 0.5e1 / 0.3e1 * t41 + t44 * t49 / 0.3e1
  t53 = t1 * t52
  t54 = 6 ** (0.1e1 / 0.3e1)
  t56 = jnp.pi ** 2
  t57 = t56 ** (0.1e1 / 0.3e1)
  t58 = t57 ** 2
  t59 = 0.1e1 / t58
  t60 = 2 ** (0.1e1 / 0.3e1)
  t61 = t60 ** 2
  t62 = t59 * t61
  t63 = t21 * t16
  t65 = t34 * t38 * t36
  t67 = 0.1e1 / t47 / t22
  t70 = t63 + t65 - t44 * t67 / 0.8e1
  t72 = t54 * t59
  t73 = t72 * t61
  t76 = 0.1e1 + 0.5e1 / 0.9e1 * params.c * t70 * t73
  t77 = 0.1e1 / t76
  t78 = t62 * t77
  t81 = t1 * t70
  t82 = t54 ** 2
  t84 = 0.1e1 / t57 / t56
  t85 = t82 * t84
  t86 = t81 * t85
  t87 = t76 ** 2
  t88 = 0.1e1 / t87
  t89 = t60 * t88
  t91 = t89 * params.c * t52
  t94 = -0.5e1 / 0.9e1 * t53 * t54 * t78 + 0.50e2 / 0.81e2 * t86 * t91
  t95 = t8 ** 2
  t96 = t95 ** 2
  t97 = t22 ** 2
  t98 = 0.1e1 / t97
  t99 = t96 * t98
  t100 = t12 <= f.p.zeta_threshold
  t101 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t102 = t101 * f.p.zeta_threshold
  t103 = t12 ** (0.1e1 / 0.3e1)
  t105 = f.my_piecewise3(t100, t102, t103 * t12)
  t106 = t35 <= f.p.zeta_threshold
  t107 = t35 ** (0.1e1 / 0.3e1)
  t109 = f.my_piecewise3(t106, t102, t107 * t35)
  t110 = t105 + t109 - 0.2e1
  t113 = 0.1e1 / (0.2e1 * t60 - 0.2e1)
  t114 = t110 * t113
  t115 = 3 ** (0.1e1 / 0.3e1)
  t116 = 0.1e1 / jnp.pi
  t117 = t116 ** (0.1e1 / 0.3e1)
  t118 = t115 * t117
  t119 = 4 ** (0.1e1 / 0.3e1)
  t120 = t119 ** 2
  t122 = 0.1e1 / t46 / t22
  t123 = t120 * t122
  t126 = t118 * t120 / t46
  t127 = jnp.sqrt(t126)
  t130 = t126 ** 0.15e1
  t132 = t115 ** 2
  t133 = t117 ** 2
  t134 = t132 * t133
  t137 = t134 * t119 / t47
  t139 = 0.70594500000000000000000000000000000000000000000000e1 * t127 + 0.15494250000000000000000000000000000000000000000000e1 * t126 + 0.42077500000000000000000000000000000000000000000000e0 * t130 + 0.15629250000000000000000000000000000000000000000000e0 * t137
  t142 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t139
  t143 = jnp.log(t142)
  t147 = t118 * t120
  t149 = 0.1e1 / t46 / t9
  t150 = t139 ** 2
  t151 = 0.1e1 / t150
  t152 = t149 * t151
  t154 = 0.1e1 / t127 * t115
  t155 = t117 * t120
  t156 = t155 * t149
  t157 = t154 * t156
  t159 = t120 * t149
  t160 = t118 * t159
  t162 = t126 ** 0.5e0
  t163 = t162 * t115
  t164 = t163 * t156
  t169 = t134 * t119 / t47 / t9
  t171 = -0.11765750000000000000000000000000000000000000000000e1 * t157 - 0.51647500000000000000000000000000000000000000000000e0 * t160 - 0.21038750000000000000000000000000000000000000000000e0 * t164 - 0.10419500000000000000000000000000000000000000000000e0 * t169
  t172 = 0.1e1 / t142
  t173 = t171 * t172
  t178 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t126
  t179 = t150 * t139
  t180 = 0.1e1 / t179
  t181 = t178 * t180
  t182 = t171 ** 2
  t183 = t182 * t172
  t186 = t178 * t151
  t189 = 0.1e1 / t127 / t126 * t132
  t190 = t133 * t119
  t191 = t190 * t67
  t192 = t189 * t191
  t194 = t155 * t122
  t195 = t154 * t194
  t197 = t118 * t123
  t199 = t126 ** (-0.5e0)
  t200 = t199 * t132
  t201 = t200 * t191
  t203 = t163 * t194
  t206 = t134 * t119 * t67
  t208 = -0.78438333333333333333333333333333333333333333333333e0 * t192 + 0.15687666666666666666666666666666666666666666666667e1 * t195 + 0.68863333333333333333333333333333333333333333333333e0 * t197 + 0.14025833333333333333333333333333333333333333333333e0 * t201 + 0.28051666666666666666666666666666666666666666666667e0 * t203 + 0.17365833333333333333333333333333333333333333333333e0 * t206
  t209 = t208 * t172
  t212 = t150 ** 2
  t213 = 0.1e1 / t212
  t214 = t178 * t213
  t215 = t142 ** 2
  t216 = 0.1e1 / t215
  t217 = t182 * t216
  t224 = 0.37978500000000000000000000000000000000000000000000e1 * t127 + 0.89690000000000000000000000000000000000000000000000e0 * t126 + 0.20477500000000000000000000000000000000000000000000e0 * t130 + 0.12323500000000000000000000000000000000000000000000e0 * t137
  t227 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t224
  t228 = jnp.log(t227)
  t231 = 0.14764627977777777777777777777777777777777777777777e-2 * t118 * t123 * t228
  t232 = t224 ** 2
  t233 = 0.1e1 / t232
  t234 = t149 * t233
  t239 = -0.63297500000000000000000000000000000000000000000000e0 * t157 - 0.29896666666666666666666666666666666666666666666667e0 * t160 - 0.10238750000000000000000000000000000000000000000000e0 * t164 - 0.82156666666666666666666666666666666666666666666667e-1 * t169
  t240 = 0.1e1 / t227
  t241 = t239 * t240
  t244 = 0.35616666666666666666666666666666666666666666666666e-1 * t147 * t234 * t241
  t246 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t126
  t247 = t232 * t224
  t248 = 0.1e1 / t247
  t249 = t246 * t248
  t250 = t239 ** 2
  t251 = t250 * t240
  t253 = 0.20000000000000000000000000000000000000000000000000e1 * t249 * t251
  t254 = t246 * t233
  t261 = -0.42198333333333333333333333333333333333333333333333e0 * t192 + 0.84396666666666666666666666666666666666666666666666e0 * t195 + 0.39862222222222222222222222222222222222222222222223e0 * t197 + 0.68258333333333333333333333333333333333333333333333e-1 * t201 + 0.13651666666666666666666666666666666666666666666667e0 * t203 + 0.13692777777777777777777777777777777777777777777778e0 * t206
  t262 = t261 * t240
  t264 = 0.10000000000000000000000000000000000000000000000000e1 * t254 * t262
  t265 = t232 ** 2
  t266 = 0.1e1 / t265
  t267 = t246 * t266
  t268 = t227 ** 2
  t269 = 0.1e1 / t268
  t270 = t250 * t269
  t272 = 0.16081979498692535066756296899072713062105388428051e2 * t267 * t270
  t277 = 0.51785000000000000000000000000000000000000000000000e1 * t127 + 0.90577500000000000000000000000000000000000000000000e0 * t126 + 0.11003250000000000000000000000000000000000000000000e0 * t130 + 0.12417750000000000000000000000000000000000000000000e0 * t137
  t280 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t277
  t281 = jnp.log(t280)
  t285 = t277 ** 2
  t286 = 0.1e1 / t285
  t287 = t149 * t286
  t292 = -0.86308333333333333333333333333333333333333333333334e0 * t157 - 0.30192500000000000000000000000000000000000000000000e0 * t160 - 0.55016250000000000000000000000000000000000000000000e-1 * t164 - 0.82785000000000000000000000000000000000000000000000e-1 * t169
  t293 = 0.1e1 / t280
  t294 = t292 * t293
  t299 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t126
  t300 = t285 * t277
  t301 = 0.1e1 / t300
  t302 = t299 * t301
  t303 = t292 ** 2
  t304 = t303 * t293
  t307 = t299 * t286
  t314 = -0.57538888888888888888888888888888888888888888888889e0 * t192 + 0.11507777777777777777777777777777777777777777777778e1 * t195 + 0.40256666666666666666666666666666666666666666666667e0 * t197 + 0.36677500000000000000000000000000000000000000000000e-1 * t201 + 0.73355000000000000000000000000000000000000000000000e-1 * t203 + 0.13797500000000000000000000000000000000000000000000e0 * t206
  t315 = t314 * t293
  t318 = t285 ** 2
  t319 = 0.1e1 / t318
  t320 = t299 * t319
  t321 = t280 ** 2
  t322 = 0.1e1 / t321
  t323 = t303 * t322
  t326 = -0.70983522622222222222222222222222222222222222222221e-3 * t118 * t123 * t143 - 0.34246666666666666666666666666666666666666666666666e-1 * t147 * t152 * t173 - 0.20000000000000000000000000000000000000000000000000e1 * t181 * t183 + 0.10000000000000000000000000000000000000000000000000e1 * t186 * t209 + 0.32163958997385070133512593798145426124210776856102e2 * t214 * t217 + t231 + t244 + t253 - t264 - t272 - 0.24415263074675393406472461472505321282722606644045e-3 * t118 * t123 * t281 - 0.10843581300301739842632067522386578331157260943710e-1 * t147 * t287 * t294 - 0.11696447245269292414524477327518106963944910680856e1 * t302 * t304 + 0.58482236226346462072622386637590534819724553404280e0 * t307 * t315 + 0.17315859105681463759666483083807725165579399831905e2 * t320 * t323
  t327 = t114 * t326
  t329 = t114 * t299
  t331 = t286 * t314 * t293
  t334 = t319 * t303
  t335 = t334 * t322
  t340 = f.my_piecewise3(t100, 0, 0.4e1 / 0.3e1 * t103 * t25)
  t341 = -t25
  t344 = f.my_piecewise3(t106, 0, 0.4e1 / 0.3e1 * t107 * t341)
  t346 = (t340 + t344) * t113
  t347 = t346 * t299
  t349 = t286 * t292 * t293
  t352 = t97 * t22
  t353 = 0.1e1 / t352
  t354 = t96 * t353
  t358 = 0.621814e-1 * t246 * t228
  t359 = t299 * t281
  t361 = -0.3109070e-1 * t178 * t143 + t358 - 0.19751673498613801407483339618206552048944131217655e-1 * t359
  t362 = t114 * t361
  t365 = t95 * t98
  t368 = t95 * t8
  t369 = t97 * t9
  t370 = 0.1e1 / t369
  t371 = t368 * t370
  t374 = t103 ** 2
  t375 = 0.1e1 / t374
  t376 = t25 ** 2
  t379 = 0.1e1 / t45
  t381 = t8 * t379 - t23
  t382 = 0.2e1 * t381
  t386 = f.my_piecewise3(t100, 0, 0.4e1 / 0.9e1 * t375 * t376 + 0.4e1 / 0.3e1 * t103 * t382)
  t387 = t107 ** 2
  t388 = 0.1e1 / t387
  t389 = t341 ** 2
  t392 = -t382
  t396 = f.my_piecewise3(t106, 0, 0.4e1 / 0.9e1 * t388 * t389 + 0.4e1 / 0.3e1 * t107 * t392)
  t398 = (t386 + t396) * t113
  t401 = t114 * t118
  t402 = t159 * t349
  t405 = t99 * t327 - 0.58482236226346462072622386637590534819724553404280e0 * t329 * t331 - 0.17315859105681463759666483083807725165579399831905e2 * t329 * t335 - 0.11696447245269292414524477327518106963944910680856e1 * t347 * t349 + 0.20e2 * t354 * t362 + 0.12e2 * t365 * t362 - 0.32e2 * t371 * t362 + 0.19751673498613801407483339618206552048944131217655e-1 * t398 * t359 + t272 + t264 + 0.10843581300301739842632067522386578331157260943710e-1 * t401 * t402
  t406 = t398 * t361
  t415 = 0.11073470983333333333333333333333333333333333333333e-2 * t118 * t159 * t228
  t417 = 0.10000000000000000000000000000000000000000000000000e1 * t254 * t241
  t423 = 0.53237641966666666666666666666666666666666666666666e-3 * t118 * t159 * t143 + 0.10000000000000000000000000000000000000000000000000e1 * t186 * t173 - t415 - t417 + 0.18311447306006545054854346104378990962041954983034e-3 * t118 * t159 * t281 + 0.58482236226346462072622386637590534819724553404280e0 * t307 * t294
  t424 = t346 * t423
  t427 = t96 * t370
  t428 = t346 * t361
  t431 = t114 * t423
  t434 = t368 * t98
  t439 = t346 * t115
  t441 = t155 * t149 * t281
  t445 = t301 * t303 * t293
  t448 = t114 * t115
  t450 = t155 * t122 * t281
  t453 = t99 * t406 + 0.2e1 * t99 * t424 - 0.8e1 * t427 * t428 - 0.8e1 * t427 * t431 + 0.8e1 * t434 * t428 + 0.8e1 * t434 * t431 - t253 - 0.36622894612013090109708692208757981924083909966068e-3 * t439 * t441 + 0.11696447245269292414524477327518106963944910680856e1 * t329 * t445 - t244 - t231 + 0.24415263074675393406472461472505321282722606644045e-3 * t448 * t450
  t454 = t405 + t453
  t457 = t52 ** 2
  t458 = t457 * t52
  t459 = t1 * t458
  t460 = t56 ** 2
  t461 = 0.1e1 / t460
  t462 = t459 * t461
  t464 = 0.1e1 / t87 / t76
  t466 = 0.1e1 / t47 / t97
  t467 = t44 * t466
  t468 = t63 + t65
  t469 = 0.1e1 / t468
  t470 = t469 * t95
  t473 = 0.1e1 - t467 * t470 / 0.8e1
  t474 = t464 * t473
  t478 = -t358 + t99 * t362 + 0.19751673498613801407483339618206552048944131217655e-1 * t114 * t359
  t479 = params.c ** 2
  t480 = t478 * t479
  t484 = t2 ** 2
  t487 = tau0 / t4 / t484
  t489 = 0.440e3 / 0.27e2 * t487 * t16
  t493 = tau0 / t4 / t2 / r0
  t495 = 0.200e3 / 0.9e1 * t493 * t27
  t496 = 0.1e1 / t14
  t497 = t26 ** 2
  t498 = t496 * t497
  t500 = 0.50e2 / 0.9e1 * t7 * t498
  t501 = t15 * t381
  t503 = 0.25e2 / 0.3e1 * t7 * t501
  t505 = 0.1e1 / t14 / t13
  t507 = t505 * t497 * t26
  t509 = 0.10e2 / 0.27e2 * t21 * t507
  t510 = t496 * t26
  t511 = t510 * t381
  t513 = 0.10e2 / 0.3e1 * t21 * t511
  t514 = t8 * t98
  t515 = t379 - t514
  t516 = 0.3e1 * t515
  t517 = t15 * t516
  t519 = 0.5e1 / 0.3e1 * t21 * t517
  t521 = 0.1e1 / t37 / t36
  t522 = t39 ** 2
  t526 = 0.10e2 / 0.27e2 * t34 * t521 * t522 * t39
  t527 = 0.1e1 / t37
  t528 = t527 * t39
  t529 = -t381
  t532 = 0.10e2 / 0.3e1 * t34 * t528 * t529
  t533 = -t516
  t536 = 0.5e1 / 0.3e1 * t34 * t38 * t533
  t539 = t44 / t47 / t369
  t541 = -t489 + t495 - t500 - t503 - t509 + t513 + t519 - t526 + t532 + t536 + 0.154e3 / 0.27e2 * t539
  t542 = t1 * t541
  t547 = 0.40e2 / 0.9e1 * t493 * t16
  t549 = 0.50e2 / 0.9e1 * t7 * t27
  t551 = 0.10e2 / 0.9e1 * t21 * t498
  t553 = 0.5e1 / 0.3e1 * t21 * t501
  t556 = 0.10e2 / 0.9e1 * t34 * t527 * t522
  t559 = 0.5e1 / 0.3e1 * t34 * t38 * t529
  t561 = t547 - t549 + t551 + t553 + t556 + t559 - 0.11e2 / 0.9e1 * t467
  t562 = t1 * t561
  t566 = t461 * t464
  t570 = t87 ** 2
  t571 = 0.1e1 / t570
  t572 = t461 * t571
  t574 = t479 * params.c
  t579 = t81 * t461
  t580 = t464 * t479
  t589 = -0.5e1 / 0.9e1 * t542 * t54 * t78 + 0.100e3 / 0.27e2 * t562 * t85 * t91 - 0.2000e4 / 0.81e2 * t459 * t566 * t479 + 0.10000e5 / 0.729e3 * t81 * t572 * t574 * t458 * t73 - 0.2000e4 / 0.81e2 * t579 * t580 * t52 * t561 + 0.50e2 / 0.81e2 * t86 * t89 * params.c * t541
  t592 = t81 * t566
  t593 = t473 * t478
  t595 = t479 * t52 * t561
  t599 = t1 * t457
  t600 = t599 * t85
  t603 = t468 ** 2
  t604 = 0.1e1 / t603
  t605 = t604 * t95
  t607 = -0.5e1 / 0.3e1 * t17 + 0.5e1 / 0.3e1 * t28 + 0.5e1 / 0.3e1 * t41
  t608 = t605 * t607
  t611 = t469 * t8
  t614 = 0.7e1 / 0.12e2 * t539 * t470 + t467 * t608 / 0.8e1 - t467 * t611 / 0.4e1
  t615 = t614 * t478
  t632 = t415 + t417 + 0.4e1 * t434 * t362 - 0.4e1 * t427 * t362 + t99 * t428 + t99 * t431 + 0.19751673498613801407483339618206552048944131217655e-1 * t346 * t359 - 0.18311447306006545054854346104378990962041954983034e-3 * t448 * t441 - 0.58482236226346462072622386637590534819724553404280e0 * t329 * t349
  t633 = t473 * t632
  t644 = t84 * t60 * t88 * params.c
  t647 = t580 * t457
  t654 = -0.5e1 / 0.9e1 * t562 * t54 * t78 + 0.100e3 / 0.81e2 * t599 * t82 * t644 - 0.2000e4 / 0.243e3 * t579 * t647 + 0.50e2 / 0.81e2 * t86 * t89 * params.c * t561
  t657 = t572 * t473
  t658 = t81 * t657
  t659 = t478 * t574
  t661 = t659 * t458 * t73
  t664 = t85 * t60
  t665 = t562 * t664
  t666 = t88 * t473
  t667 = t478 * params.c
  t668 = t667 * t52
  t669 = t666 * t668
  t672 = t81 * t664
  t673 = t667 * t541
  t677 = t454 * params.c
  t678 = t677 * t52
  t682 = t632 * params.c
  t683 = t682 * t561
  t689 = t44 / t47 / t352
  t697 = 0.1e1 / t603 / t468
  t698 = t697 * t95
  t699 = t607 ** 2
  t700 = t698 * t699
  t703 = t604 * t8
  t704 = t703 * t607
  t707 = t547 - t549 + t551 + t553 + t556 + t559
  t708 = t605 * t707
  t713 = -0.119e3 / 0.36e2 * t689 * t470 - 0.7e1 / 0.6e1 * t539 * t608 + 0.7e1 / 0.3e1 * t539 * t611 - t467 * t700 / 0.4e1 + t467 * t704 / 0.2e1 + t467 * t708 / 0.8e1 - t467 * t469 / 0.4e1
  t714 = t88 * t713
  t718 = t88 * t614
  t719 = t682 * t52
  t723 = 0.12e2 * t94 * t454 + 0.8000e4 / 0.81e2 * t462 * t474 * t480 + 0.4e1 * t589 * t478 + 0.8000e4 / 0.81e2 * t592 * t593 * t595 - 0.400e3 / 0.27e2 * t600 * t89 * t615 * params.c - 0.400e3 / 0.27e2 * t600 * t89 * t633 * params.c + 0.12e2 * t654 * t632 - 0.40000e5 / 0.729e3 * t658 * t661 - 0.400e3 / 0.27e2 * t665 * t669 - 0.200e3 / 0.81e2 * t672 * t666 * t673 - 0.200e3 / 0.27e2 * t672 * t666 * t678 - 0.200e3 / 0.27e2 * t672 * t666 * t683 - 0.200e3 / 0.27e2 * t672 * t714 * t668 - 0.400e3 / 0.27e2 * t672 * t718 * t719
  t724 = t667 * t561
  t731 = 0.1e1 - 0.5e1 / 0.9e1 * t81 * t54 * t78
  t739 = 0.1e1 / t374 / t12
  t743 = t375 * t25
  t746 = 0.6e1 * t515
  t750 = f.my_piecewise3(t100, 0, -0.8e1 / 0.27e2 * t739 * t376 * t25 + 0.4e1 / 0.3e1 * t743 * t382 + 0.4e1 / 0.3e1 * t103 * t746)
  t752 = 0.1e1 / t387 / t35
  t756 = t388 * t341
  t759 = -t746
  t763 = f.my_piecewise3(t106, 0, -0.8e1 / 0.27e2 * t752 * t389 * t341 + 0.4e1 / 0.3e1 * t756 * t392 + 0.4e1 / 0.3e1 * t107 * t759)
  t765 = (t750 + t763) * t113
  t766 = t765 * t361
  t769 = 0.1e1 / t265 / t224
  t770 = t246 * t769
  t771 = t250 * t239
  t772 = t771 * t269
  t774 = 0.96491876992155210400537781394436278372632330568306e2 * t770 * t772
  t776 = 0.1e1 / t318 / t285
  t777 = t303 * t292
  t780 = 0.1e1 / t321 / t280
  t781 = t776 * t777 * t780
  t784 = t398 * t299
  t794 = 0.1e1 / t127 / t137 * t116 / 0.4e1
  t795 = t794 * t98
  t797 = t190 * t49
  t798 = t189 * t797
  t801 = 0.1e1 / t46 / t45
  t802 = t155 * t801
  t803 = t154 * t802
  t805 = t120 * t801
  t806 = t118 * t805
  t808 = t126 ** (-0.15e1)
  t809 = t808 * t116
  t810 = t809 * t98
  t812 = t200 * t797
  t814 = t163 * t802
  t817 = t134 * t119 * t49
  t819 = -0.34523333333333333333333333333333333333333333333333e1 * t795 + 0.23015555555555555555555555555555555555555555555556e1 * t798 - 0.26851481481481481481481481481481481481481481481482e1 * t803 - 0.93932222222222222222222222222222222222222222222223e0 * t806 + 0.73355000000000000000000000000000000000000000000000e-1 * t810 - 0.14671000000000000000000000000000000000000000000000e0 * t812 - 0.17116166666666666666666666666666666666666666666667e0 * t814 - 0.36793333333333333333333333333333333333333333333333e0 * t817
  t821 = t286 * t819 * t293
  t825 = t319 * t777 * t293
  t829 = 0.1e1 / t318 / t277
  t831 = t829 * t777 * t322
  t834 = -0.24e2 * t427 * t424 + 0.12e2 * t434 * t406 - 0.12e2 * t427 * t406 + t99 * t766 - t774 - 0.10254018858216406658218194626490193680059335835414e4 * t329 * t781 - 0.17544670867903938621786715991277160445917366021284e1 * t784 * t349 - 0.51947577317044391278999449251423175496738199495715e2 * t347 * t335 - 0.17544670867903938621786715991277160445917366021284e1 * t347 * t331 - 0.58482236226346462072622386637590534819724553404280e0 * t329 * t821 - 0.35089341735807877243573431982554320891834732042568e1 * t329 * t825 + 0.10389515463408878255799889850284635099347639899143e3 * t329 * t831
  t839 = t771 * t240
  t841 = 0.60000000000000000000000000000000000000000000000000e1 * t267 * t839
  t843 = 0.1e1 / t265 / t232
  t844 = t246 * t843
  t846 = 0.1e1 / t268 / t227
  t847 = t771 * t846
  t849 = 0.51726012919273400298984252201052768390886626637712e3 * t844 * t847
  t852 = t123 * t349
  t855 = t159 * t445
  t858 = t159 * t331
  t861 = t159 * t335
  t864 = t346 * t118
  t871 = t95 * t370
  t874 = 0.35089341735807877243573431982554320891834732042568e1 * t347 * t445 - 0.12e2 * t427 * t327 + t841 + t849 + 0.60e2 * t354 * t428 - 0.21687162600603479685264135044773156662314521887420e-1 * t401 * t852 - 0.32530743900905219527896202567159734993471782831130e-1 * t401 * t855 + 0.16265371950452609763948101283579867496735891415565e-1 * t401 * t858 + 0.48159733137676571081572406076840235616767705782485e0 * t401 * t861 + 0.32530743900905219527896202567159734993471782831130e-1 * t864 * t402 + 0.60e2 * t354 * t431 + 0.24e2 * t514 * t362 - 0.144e3 * t871 * t362
  t876 = t368 * t353
  t879 = t97 * t45
  t880 = 0.1e1 / t879
  t881 = t96 * t880
  t884 = t261 * t269
  t887 = 0.48245938496077605200268890697218139186316165284153e2 * t267 * t884 * t239
  t890 = 0.60000000000000000000000000000000000000000000000000e1 * t249 * t241 * t261
  t894 = 0.10685000000000000000000000000000000000000000000000e0 * t147 * t149 * t248 * t251
  t895 = t149 * t266
  t898 = 0.85917975471764868594145516183295969534298037676861e0 * t147 * t895 * t270
  t899 = t122 * t233
  t902 = 0.71233333333333333333333333333333333333333333333331e-1 * t147 * t899 * t241
  t905 = 0.53424999999999999999999999999999999999999999999999e-1 * t147 * t234 * t262
  t906 = t398 * t115
  t910 = t322 * t292
  t911 = t319 * t314 * t910
  t915 = t301 * t314 * t294
  t920 = 0.240e3 * t876 * t362 - 0.120e3 * t881 * t362 + t887 - t890 + t894 - t898 + t902 - t905 - 0.54934341918019635164563038313136972886125864949102e-3 * t906 * t441 - 0.51947577317044391278999449251423175496738199495715e2 * t329 * t911 + 0.35089341735807877243573431982554320891834732042568e1 * t329 * t915 + 0.73245789224026180219417384417515963848167819932136e-3 * t439 * t450
  t922 = t155 * t801 * t281
  t937 = 0.34450798614814814814814814814814814814814814814813e-2 * t118 * t805 * t228
  t938 = t299 * t829
  t939 = t777 * t322
  t942 = t819 * t293
  t946 = 0.1e1 / t212 / t139
  t947 = t178 * t946
  t948 = t182 * t171
  t949 = t948 * t216
  t952 = t122 * t151
  t959 = t149 * t213
  t967 = t149 * t301
  t971 = t122 * t286
  t978 = -0.10389515463408878255799889850284635099347639899143e3 * t938 * t939 + 0.58482236226346462072622386637590534819724553404280e0 * t307 * t942 + t774 - t841 - t849 - 0.19298375398431042080107556278887255674526466113661e3 * t947 * t949 - t887 + t890 + 0.68493333333333333333333333333333333333333333333332e-1 * t147 * t952 * t173 - 0.51369999999999999999999999999999999999999999999999e-1 * t147 * t152 * t209 - 0.16522625736956710527585419434107305400007076070979e1 * t147 * t959 * t217 + 0.10274000000000000000000000000000000000000000000000e0 * t147 * t149 * t180 * t183 - t894 + 0.32530743900905219527896202567159734993471782831130e-1 * t147 * t967 * t304 + 0.21687162600603479685264135044773156662314521887420e-1 * t147 * t971 * t294 - 0.16265371950452609763948101283579867496735891415565e-1 * t147 * t287 * t315
  t979 = t149 * t319
  t986 = t314 * t322
  t987 = t986 * t292
  t993 = t294 * t314
  t999 = t208 * t216
  t1003 = t777 * t293
  t1014 = -0.25319000000000000000000000000000000000000000000000e1 * t795 + 0.16879333333333333333333333333333333333333333333333e1 * t798 - 0.19692555555555555555555555555555555555555555555555e1 * t803 - 0.93011851851851851851851851851851851851851851851854e0 * t806 + 0.13651666666666666666666666666666666666666666666667e0 * t810 - 0.27303333333333333333333333333333333333333333333333e0 * t812 - 0.31853888888888888888888888888888888888888888888890e0 * t814 - 0.36514074074074074074074074074074074074074074074075e0 * t817
  t1015 = t1014 * t240
  t1017 = 0.10000000000000000000000000000000000000000000000000e1 * t254 * t1015
  t1018 = t948 * t172
  t1021 = t299 * t776
  t1022 = t777 * t780
  t1033 = -0.47063000000000000000000000000000000000000000000000e1 * t795 + 0.31375333333333333333333333333333333333333333333334e1 * t798 - 0.36604555555555555555555555555555555555555555555556e1 * t803 - 0.16068111111111111111111111111111111111111111111111e1 * t806 + 0.28051666666666666666666666666666666666666666666666e0 * t810 - 0.56103333333333333333333333333333333333333333333332e0 * t812 - 0.65453888888888888888888888888888888888888888888890e0 * t814 - 0.46308888888888888888888888888888888888888888888888e0 * t817
  t1034 = t1033 * t172
  t1038 = 0.1e1 / t212 / t150
  t1039 = t178 * t1038
  t1041 = 0.1e1 / t215 / t142
  t1042 = t948 * t1041
  t1045 = -0.48159733137676571081572406076840235616767705782485e0 * t147 * t979 * t323 + t898 - t902 + t905 - 0.60000000000000000000000000000000000000000000000000e1 * t181 * t173 * t208 + 0.51947577317044391278999449251423175496738199495715e2 * t320 * t987 + 0.56968947174242584615102410102512416326352748836105e-3 * t118 * t805 * t281 - 0.35089341735807877243573431982554320891834732042568e1 * t302 * t993 - t937 + 0.16562821945185185185185185185185185185185185185185e-2 * t118 * t805 * t143 + 0.96491876992155210400537781394436278372632330568306e2 * t214 * t999 * t171 + 0.35089341735807877243573431982554320891834732042568e1 * t320 * t1003 - t1017 + 0.60000000000000000000000000000000000000000000000000e1 * t214 * t1018 + 0.10254018858216406658218194626490193680059335835414e4 * t1021 * t1022 + 0.10000000000000000000000000000000000000000000000000e1 * t186 * t1034 + 0.20690405167709360119593700880421107356354650655085e4 * t1039 * t1042
  t1046 = t978 + t1045
  t1047 = t114 * t1046
  t1049 = t398 * t423
  t1054 = t346 * t326
  t1059 = -0.56968947174242584615102410102512416326352748836105e-3 * t448 * t922 + 0.24e2 * t434 * t424 - 0.96e2 * t371 * t431 + 0.36e2 * t365 * t428 + 0.36e2 * t365 * t431 + 0.19751673498613801407483339618206552048944131217655e-1 * t765 * t359 + t937 + t99 * t1047 + t1017 + 0.3e1 * t99 * t1049 - 0.96e2 * t371 * t428 + 0.3e1 * t99 * t1054 + 0.12e2 * t434 * t327
  t1061 = t834 + t874 + t920 + t1059
  t1072 = t53 * t72
  t1073 = t61 * t77
  t1075 = t1073 * t473 * t1061
  t1078 = t561 ** 2
  t1083 = t713 * t478
  t1084 = t479 * t457
  t1088 = t81 * t72
  t1090 = 0.1e1 / t46 / t97
  t1091 = t120 * t1090
  t1094 = 0.11483599538271604938271604938271604938271604938271e-1 * t118 * t1091 * t228
  t1098 = 0.31035607751564040179390551320631661034531975982628e4 * t844 * t261 * t846 * t250
  t1099 = t12 ** 2
  t1102 = t376 ** 2
  t1108 = t382 ** 2
  t1113 = t8 * t370
  t1114 = -t98 + t1113
  t1115 = 0.24e2 * t1114
  t1119 = f.my_piecewise3(t100, 0, 0.40e2 / 0.81e2 / t374 / t1099 * t1102 - 0.16e2 / 0.9e1 * t739 * t376 * t382 + 0.4e1 / 0.3e1 * t375 * t1108 + 0.16e2 / 0.9e1 * t743 * t746 + 0.4e1 / 0.3e1 * t103 * t1115)
  t1120 = t35 ** 2
  t1123 = t389 ** 2
  t1129 = t392 ** 2
  t1138 = f.my_piecewise3(t106, 0, 0.40e2 / 0.81e2 / t387 / t1120 * t1123 - 0.16e2 / 0.9e1 * t752 * t389 * t392 + 0.4e1 / 0.3e1 * t388 * t1129 + 0.16e2 / 0.9e1 * t756 * t759 - 0.4e1 / 0.3e1 * t107 * t1115)
  t1140 = (t1119 + t1138) * t113
  t1143 = t250 ** 2
  t1146 = 0.57895126195293126240322668836661767023579398340984e3 * t844 * t1143 * t269
  t1165 = 0.1e1 / t46 / t369
  t1167 = 0.1e1 / t127 / t10 * t1165 * t147 / 0.48e2
  t1169 = t794 * t370
  t1171 = t190 * t466
  t1172 = t189 * t1171
  t1174 = t155 * t1090
  t1175 = t154 * t1174
  t1177 = t118 * t1091
  t1179 = t126 ** (-0.25e1)
  t1182 = t1179 * t116 * t1165 * t147
  t1184 = t809 * t370
  t1186 = t200 * t1171
  t1188 = t163 * t1174
  t1191 = t134 * t119 * t466
  t1196 = 0.10000000000000000000000000000000000000000000000000e1 * t254 * (-0.21099166666666666666666666666666666666666666666667e1 * t1167 + 0.20255200000000000000000000000000000000000000000000e2 * t1169 - 0.75019259259259259259259259259259259259259259259258e1 * t1172 + 0.65641851851851851851851851851851851851851851851850e1 * t1175 + 0.31003950617283950617283950617283950617283950617285e1 * t1177 + 0.68258333333333333333333333333333333333333333333335e-1 * t1182 - 0.10921333333333333333333333333333333333333333333333e1 * t1184 + 0.12134814814814814814814814814814814814814814814815e1 * t1186 + 0.10617962962962962962962962962962962962962962962963e1 * t1188 + 0.13388493827160493827160493827160493827160493827161e1 * t1191) * t240
  t1197 = t114 * t147
  t1204 = -t1094 + t1098 + 0.19751673498613801407483339618206552048944131217655e-1 * t1140 * t359 + t1146 + 0.4e1 * t99 * t346 * t1046 + 0.1440e4 * t95 * t353 * t362 + 0.96e2 * t514 * t428 - 0.576e3 * t871 * t428 - 0.384e3 * t1113 * t362 + t1196 - 0.13012297560362087811158481026863893997388713132452e0 * t1197 * t967 * t993 + 0.19263893255070628432628962430736094246707082312995e1 * t1197 * t979 * t987
  t1205 = t261 ** 2
  t1208 = 0.60000000000000000000000000000000000000000000000000e1 * t249 * t1205 * t240
  t1217 = t314 ** 2
  t1222 = t303 ** 2
  t1232 = 0.1e1 / t318 / t300
  t1247 = -0.28769444444444444444444444444444444444444444444444e1 * t1167 + 0.27618666666666666666666666666666666666666666666667e2 * t1169 - 0.10229135802469135802469135802469135802469135802469e2 * t1172 + 0.89504938271604938271604938271604938271604938271607e1 * t1175 + 0.31310740740740740740740740740740740740740740740741e1 * t1177 + 0.36677500000000000000000000000000000000000000000000e-1 * t1182 - 0.58684000000000000000000000000000000000000000000000e0 * t1184 + 0.65204444444444444444444444444444444444444444444445e0 * t1186 + 0.57053888888888888888888888888888888888888888888890e0 * t1188 + 0.13490888888888888888888888888888888888888888888889e1 * t1191
  t1261 = -t1208 + 0.24e2 * t98 * t110 * t113 * t361 + 0.144e3 * t365 * t424 + 0.16e2 * t434 * t1047 - 0.51947577317044391278999449251423175496738199495715e2 * t329 * t319 * t1217 * t322 + 0.14035736694323150897429372793021728356733892817027e2 * t329 * t829 * t1222 * t293 + 0.70178683471615754487146863965108641783669464085136e1 * t784 * t445 + 0.41558061853635513023199559401138540397390559596572e3 * t347 * t831 + 0.12304822629859687989861833551788232416071203002497e5 * t329 * t1232 * t1222 * t780 - 0.58482236226346462072622386637590534819724553404280e0 * t329 * t286 * t1247 * t293 - 0.62337092780453269534799339101707810596085839394858e3 * t329 * t776 * t1222 * t322 - 0.14035736694323150897429372793021728356733892817027e2 * t347 * t825 + 0.6e1 * t99 * t398 * t326
  t1269 = t318 ** 2
  t1270 = 0.1e1 / t1269
  t1272 = t321 ** 2
  t1273 = 0.1e1 / t1272
  t1292 = 0.57895126195293126240322668836661767023579398340984e3 * t770 * t884 * t250
  t1306 = t212 ** 2
  t1309 = t182 ** 2
  t1310 = t215 ** 2
  t1339 = t1094 - t1098 - t1146 + 0.21053605041484726346144059189532592535100839225540e2 * t320 * t304 * t314 - 0.18989649058080861538367470034170805442117582945368e-2 * t118 * t1091 * t281 + 0.69263436422725855038665932335230900662317599327620e2 * t320 * t819 * t322 * t292 - t1196 + t1208 + 0.58482236226346462072622386637590534819724553404280e0 * t307 * t1247 * t293 + 0.19964560303604640731402349461820840981085646822122e6 * t178 / t1306 * t1309 / t1310 - 0.12304822629859687989861833551788232416071203002497e5 * t299 * t1232 * t1222 * t780 + 0.51947577317044391278999449251423175496738199495715e2 * t320 * t1217 * t322 - 0.14035736694323150897429372793021728356733892817027e2 * t938 * t1222 * t293 + 0.36000000000000000000000000000000000000000000000000e2 * t214 * t183 * t208 - 0.80000000000000000000000000000000000000000000000000e1 * t181 * t173 * t1033 + 0.12414243100625616071756220528252664413812790393051e5 * t1039 * t208 * t1041 * t182 + 0.61524113149298439949309167758941162080356015012483e4 * t1021 * t303 * t780 * t314
  t1357 = t265 ** 2
  t1360 = t268 ** 2
  t1364 = 0.24955700379505800914252936827276051226357058527653e5 * t246 / t1357 * t1143 / t1360
  t1370 = 0.62071215503128080358781102641263322069063951965254e4 * t246 / t265 / t247 * t1143 * t846
  t1415 = -0.46785788981077169658097909310072427855779642723424e1 * t302 * t294 * t819 + t1292 + 0.10000000000000000000000000000000000000000000000000e1 * t186 * (-0.39219166666666666666666666666666666666666666666667e1 * t1167 + 0.37650400000000000000000000000000000000000000000000e2 * t1169 - 0.13944592592592592592592592592592592592592592592593e2 * t1172 + 0.12201518518518518518518518518518518518518518518519e2 * t1175 + 0.53560370370370370370370370370370370370370370370370e1 * t1177 + 0.14025833333333333333333333333333333333333333333333e0 * t1182 - 0.22441333333333333333333333333333333333333333333332e1 * t1184 + 0.24934814814814814814814814814814814814814814814815e1 * t1186 + 0.21817962962962962962962962962962962962962962962963e1 * t1188 + 0.16979925925925925925925925925925925925925925925926e1 * t1191) * t172 - t1364 + t1370 - 0.55209406483950617283950617283950617283950617283950e-2 * t118 * t1091 * t143 + 0.13698666666666666666666666666666666666666666666666e0 * t147 * t952 * t209 + 0.44060335298551228073561118490952814400018869522611e1 * t147 * t122 * t213 * t217 - 0.68493333333333333333333333333333333333333333333332e-1 * t147 * t152 * t1034 - 0.14171548179536397724580378856363097131945845388689e3 * t147 * t149 * t1038 * t1042 - 0.86748650402413918741056540179092626649258087549680e-1 * t147 * t122 * t301 * t304 - 0.67471172535210825687488420139294265171645179205307e-1 * t147 * t801 * t286 * t294 - 0.21309037037037037037037037037037037037037037037036e0 * t147 * t801 * t151 * t173 - 0.27397333333333333333333333333333333333333333333333e0 * t147 * t122 * t180 * t183 + 0.13218100589565368422068335547285844320005660856783e2 * t147 * t149 * t946 * t949 - 0.38025319932552508024225805073234468230220037056326e2 * t147 * t149 * t776 * t1022 - 0.13012297560362087811158481026863893997388713132452e0 * t147 * t979 * t1003
  t1430 = 0.68734380377411894875316412946636775627438430141488e1 * t147 * t149 * t769 * t772
  t1434 = 0.36846163202829085479643115651216588683774907041596e2 * t147 * t149 * t843 * t847
  t1437 = 0.14246666666666666666666666666666666666666666666666e0 * t147 * t899 * t262
  t1440 = 0.71233333333333333333333333333333333333333333333332e-1 * t147 * t234 * t1015
  t1444 = 0.28493333333333333333333333333333333333333333333333e0 * t147 * t122 * t248 * t251
  t1447 = 0.42740000000000000000000000000000000000000000000000e0 * t147 * t895 * t839
  t1451 = 0.22911460125803964958438804315545591875812810047162e1 * t147 * t122 * t266 * t270
  t1455 = 0.22161481481481481481481481481481481481481481481481e0 * t147 * t801 * t233 * t241
  t1473 = t208 ** 2
  t1477 = -0.41096000000000000000000000000000000000000000000000e0 * t147 * t959 * t1018 + 0.38527786510141256865257924861472188493414164625988e1 * t147 * t149 * t829 * t939 + 0.43374325201206959370528270089546313324629043774840e-1 * t147 * t971 * t315 - t1430 + t1434 - t1437 + t1440 + t1444 + t1447 - t1451 + t1455 + 0.12842595503380418955085974953824062831138054875329e1 * t147 * t122 * t319 * t323 - 0.21687162600603479685264135044773156662314521887420e-1 * t147 * t287 * t942 + 0.91082604192152556048340974007871726131433263376469e5 * t299 * t1270 * t1222 * t1273 + 0.62337092780453269534799339101707810596085839394858e3 * t1021 * t1222 * t322 + 0.11579025239058625248064533767332353404715879668197e4 * t1039 * t1309 * t216 + 0.96491876992155210400537781394436278372632330568306e2 * t214 * t1473 * t216
  t1480 = 0.24000000000000000000000000000000000000000000000000e2 * t770 * t1143 * t240
  t1483 = 0.48245938496077605200268890697218139186316165284153e2 * t267 * t1205 * t269
  t1506 = 0.64327917994770140267025187596290852248421553712204e2 * t267 * t1014 * t269 * t239
  t1509 = 0.36000000000000000000000000000000000000000000000000e2 * t267 * t251 * t261
  t1512 = 0.80000000000000000000000000000000000000000000000000e1 * t249 * t241 * t1014
  t1523 = 0.34367190188705947437658206473318387813719215070744e1 * t160 * t266 * t261 * t269 * t239
  t1527 = 0.42740000000000000000000000000000000000000000000000e0 * t160 * t248 * t239 * t262
  t1541 = t1480 - t1483 - 0.35089341735807877243573431982554320891834732042568e1 * t302 * t1217 * t293 - 0.24828486201251232143512441056505328827625580786102e5 * t178 / t212 / t179 * t1309 * t1041 - 0.11579025239058625248064533767332353404715879668197e4 * t947 * t999 * t182 + 0.12865583598954028053405037519258170449684310742441e3 * t214 * t1033 * t216 * t171 - 0.62337092780453269534799339101707810596085839394858e3 * t938 * t323 * t314 - t1506 - t1509 + t1512 - 0.24000000000000000000000000000000000000000000000000e2 * t947 * t1309 * t172 - 0.60000000000000000000000000000000000000000000000000e1 * t181 * t1473 * t172 + t1523 - t1527 + 0.41096000000000000000000000000000000000000000000000e0 * t160 * t180 * t208 * t173 - 0.66090502947826842110341677736429221600028304283916e1 * t160 * t213 * t208 * t216 * t171 + 0.13012297560362087811158481026863893997388713132452e0 * t160 * t915 - 0.19263893255070628432628962430736094246707082312995e1 * t160 * t911
  t1549 = -0.23392894490538584829048954655036213927889821361712e1 * t347 * t821 - 0.35089341735807877243573431982554320891834732042568e1 * t784 * t331 - 0.10389515463408878255799889850284635099347639899143e3 * t784 * t335 - 0.91082604192152556048340974007871726131433263376469e5 * t329 * t1270 * t1222 * t1273 - 0.23392894490538584829048954655036213927889821361712e1 * t765 * t299 * t349 - 0.41016075432865626632872778505960774720237343341655e4 * t347 * t781 + 0.35089341735807877243573431982554320891834732042568e1 * t329 * t301 * t1217 * t293 - 0.384e3 * t371 * t424 - 0.192e3 * t371 * t327 - t1292 + t99 * t114 * (t1339 + t1415 + t1477 + t1541) + 0.38025319932552508024225805073234468230220037056326e2 * t401 * t159 * t781
  t1582 = 0.65061487801810439055792405134319469986943565662260e-1 * t398 * t118 * t402 + 0.19263893255070628432628962430736094246707082312994e1 * t864 * t861 + 0.65061487801810439055792405134319469986943565662260e-1 * t864 * t858 + 0.21687162600603479685264135044773156662314521887420e-1 * t401 * t159 * t821 + 0.13012297560362087811158481026863893997388713132452e0 * t401 * t159 * t825 - 0.86748650402413918741056540179092626649258087549680e-1 * t864 * t852 - 0.43374325201206959370528270089546313324629043774840e-1 * t401 * t123 * t331 - 0.12842595503380418955085974953824062831138054875329e1 * t401 * t123 * t335 - 0.38527786510141256865257924861472188493414164625988e1 * t401 * t159 * t831 - 0.13012297560362087811158481026863893997388713132452e0 * t864 * t855 + 0.67471172535210825687488420139294265171645179205307e-1 * t401 * t805 * t349 + 0.86748650402413918741056540179092626649258087549680e-1 * t401 * t123 * t445 + t1364
  t1606 = t1140 * t361 * t99 + 0.4e1 * t423 * t765 * t99 - 0.16e2 * t1047 * t427 - 0.48e2 * t1049 * t427 + 0.48e2 * t1049 * t434 + 0.72e2 * t327 * t365 + 0.120e3 * t354 * t406 + 0.240e3 * t354 * t424 + 0.960e3 * t428 * t876 - 0.480e3 * t428 * t881 - t1370 + t1430
  t1627 = -t1434 + t1437 - t1440 - t1444 - t1447 + t1451 - t1455 + 0.18989649058080861538367470034170805442117582945368e-2 * t448 * t155 * t1090 * t281 + 0.14035736694323150897429372793021728356733892817027e2 * t347 * t915 + 0.46785788981077169658097909310072427855779642723424e1 * t329 * t301 * t819 * t294 - 0.20779030926817756511599779700569270198695279798286e3 * t347 * t911 - 0.61524113149298439949309167758941162080356015012483e4 * t329 * t776 * t303 * t780 * t314 - 0.73245789224026180219417384417515963848167819932136e-3 * t765 * t115 * t441
  t1654 = -0.69263436422725855038665932335230900662317599327620e2 * t329 * t319 * t819 * t910 - 0.21053605041484726346144059189532592535100839225540e2 * t329 * t334 * t315 + 0.62337092780453269534799339101707810596085839394858e3 * t329 * t829 * t303 * t986 + 0.14649157844805236043883476883503192769633563986427e-2 * t906 * t450 - 0.22787578869697033846040964041004966530541099534442e-2 * t439 * t922 - t1480 + t1483 - 0.48e2 * t427 * t1054 + 0.960e3 * t876 * t431 + 0.48e2 * t434 * t1054 - 0.576e3 * t871 * t431 + 0.120e3 * t354 * t327
  t1670 = t97 ** 2
  t1675 = -0.192e3 * t371 * t406 + t1506 + t1509 - t1512 - 0.480e3 * t881 * t431 + 0.72e2 * t365 * t406 + 0.96e2 * t514 * t431 + 0.16e2 * t434 * t766 - 0.16e2 * t427 * t766 - 0.1920e4 * t368 * t880 * t362 + 0.840e3 * t96 / t1670 * t362 - t1523 + t1527
  t1678 = t1204 + t1261 + t1549 + t1582 + t1606 + t1627 + t1654 + t1675
  t1683 = t36 ** 2
  t1686 = t522 ** 2
  t1689 = 0.40e2 / 0.81e2 * t34 / t37 / t1683 * t1686
  t1693 = 0.20e2 / 0.9e1 * t34 * t521 * t522 * t529
  t1694 = t529 ** 2
  t1697 = 0.10e2 / 0.3e1 * t34 * t527 * t1694
  t1700 = 0.40e2 / 0.9e1 * t34 * t528 * t533
  t1702 = 0.800e3 / 0.27e2 * t493 * t498
  t1704 = 0.200e3 / 0.81e2 * t7 * t507
  t1706 = 0.200e3 / 0.9e1 * t7 * t511
  t1707 = t13 ** 2
  t1710 = t497 ** 2
  t1713 = 0.40e2 / 0.81e2 * t21 / t14 / t1707 * t1710
  t1717 = 0.20e2 / 0.9e1 * t21 * t505 * t497 * t381
  t1718 = t381 ** 2
  t1721 = 0.10e2 / 0.3e1 * t21 * t496 * t1718
  t1724 = 0.40e2 / 0.9e1 * t21 * t510 * t516
  t1731 = 0.6160e4 / 0.81e2 * tau0 / t4 / t484 / r0 * t16
  t1733 = 0.8800e4 / 0.81e2 * t487 * t27
  t1735 = 0.400e3 / 0.9e1 * t493 * t501
  t1737 = 0.100e3 / 0.9e1 * t7 * t517
  t1738 = 0.12e2 * t1114
  t1741 = 0.5e1 / 0.3e1 * t21 * t15 * t1738
  t1745 = -0.5e1 / 0.3e1 * t34 * t38 * t1738
  t1746 = t1689 - t1693 + t1697 + t1700 + t1702 + t1704 - t1706 + t1713 - t1717 + t1721 + t1724 - 0.2618e4 / 0.81e2 * t689 + t1731 - t1733 + t1735 - t1737 + t1741 + t1745
  t1747 = t1 * t1746
  t1749 = t1073 * t593
  t1752 = t542 * t72
  t1753 = t1073 * t615
  t1756 = t614 * t632
  t1776 = -0.20000e5 / 0.243e3 * t579 * t571 * t473 * t478 * t574 * t457 * t561 * t73 + 0.20e2 / 0.9e1 * t1072 * t1075 + 0.2000e4 / 0.81e2 * t592 * t593 * t479 * t1078 + 0.4000e4 / 0.81e2 * t592 * t1083 * t1084 + 0.5e1 / 0.9e1 * t1088 * t1073 * t473 * t1678 + 0.5e1 / 0.9e1 * t1747 * t72 * t1749 + 0.20e2 / 0.9e1 * t1752 * t1753 + 0.8000e4 / 0.81e2 * t592 * t1756 * t1084 + 0.4e1 * t94 * t1061 + 0.8000e4 / 0.81e2 * t462 * t474 * t632 * t479 + 0.8000e4 / 0.81e2 * t462 * t464 * t614 * t480 + 0.8000e4 / 0.81e2 * t592 * t633 * t595 + 0.8000e4 / 0.81e2 * t592 * t615 * t595
  t1782 = t1 * t1078
  t1788 = t473 * t454
  t1803 = t461 / t570 / t76
  t1806 = t479 ** 2
  t1808 = t457 ** 2
  t1833 = 0.8000e4 / 0.243e3 * t592 * t593 * t479 * t541 * t52 - 0.100e3 / 0.27e2 * t1782 * t85 * t89 * t593 * params.c - 0.200e3 / 0.27e2 * t600 * t89 * t1788 * params.c - 0.200e3 / 0.27e2 * t600 * t89 * t1083 * params.c - 0.400e3 / 0.27e2 * t600 * t89 * t1756 * params.c + 0.400000e6 / 0.6561e4 * t81 * t1803 * t473 * t478 * t1806 * t1808 * t664 - 0.40000e5 / 0.729e3 * t81 * t572 * t614 * t661 - 0.40000e5 / 0.729e3 * t658 * t632 * t574 * t458 * t73 + 0.4e1 * t589 * t632 + 0.6e1 * t654 * t454 + t731 * t1678 - 0.400e3 / 0.81e2 * t542 * t664 * t669 - 0.400e3 / 0.27e2 * t665 * t718 * t668
  t1866 = t44 / t47 / t879
  t1881 = t603 ** 2
  t1882 = 0.1e1 / t1881
  t1884 = t699 * t607
  t1885 = t1882 * t95 * t1884
  t1889 = t697 * t8 * t699
  t1892 = t467 * t697
  t1893 = t95 * t607
  t1894 = t1893 * t707
  t1897 = t604 * t607
  t1900 = t703 * t707
  t1903 = -t489 + t495 - t500 - t503 - t509 + t513 + t519 - t526 + t532 + t536
  t1904 = t605 * t1903
  t1907 = 0.595e3 / 0.27e2 * t1866 * t470 + 0.119e3 / 0.12e2 * t689 * t608 - 0.119e3 / 0.6e1 * t689 * t611 + 0.7e1 / 0.2e1 * t539 * t700 - 0.7e1 * t539 * t704 - 0.7e1 / 0.4e1 * t539 * t708 + 0.7e1 / 0.2e1 * t539 * t469 + 0.3e1 / 0.4e1 * t467 * t1885 - 0.3e1 / 0.2e1 * t467 * t1889 - 0.3e1 / 0.4e1 * t1892 * t1894 + 0.3e1 / 0.4e1 * t467 * t1897 + 0.3e1 / 0.4e1 * t467 * t1900 + t467 * t1904 / 0.8e1
  t1918 = t1 * t1808
  t1965 = -0.400e3 / 0.27e2 * t665 * t666 * t719 - 0.200e3 / 0.81e2 * t672 * t718 * t673 - 0.200e3 / 0.81e2 * t672 * t666 * t682 * t541 - 0.50e2 / 0.81e2 * t672 * t666 * t667 * t1746 - 0.200e3 / 0.27e2 * t672 * t718 * t678 - 0.200e3 / 0.81e2 * t672 * t666 * t1061 * params.c * t52 - 0.100e3 / 0.27e2 * t672 * t666 * t677 * t561 - 0.200e3 / 0.27e2 * t672 * t718 * t683 - 0.200e3 / 0.81e2 * t672 * t88 * t1907 * t668 - 0.200e3 / 0.27e2 * t672 * t714 * t719 - 0.100e3 / 0.27e2 * t672 * t714 * t724 - 0.40000e5 / 0.729e3 * t1918 * t657 * t659 * t73 + (-0.5e1 / 0.9e1 * t1747 * t54 * t78 + 0.400e3 / 0.81e2 * t542 * t85 * t91 - 0.4000e4 / 0.27e2 * t562 * t461 * t647 + 0.100e3 / 0.27e2 * t1782 * t82 * t644 + 0.40000e5 / 0.729e3 * t1918 * t572 * t574 * t54 * t62 - 0.400000e6 / 0.6561e4 * t81 * t1803 * t1806 * t1808 * t664 + 0.20000e5 / 0.243e3 * t81 * t572 * t574 * t457 * t54 * t62 * t561 - 0.2000e4 / 0.81e2 * t579 * t580 * t1078 - 0.8000e4 / 0.243e3 * t579 * t580 * t52 * t541 + 0.50e2 / 0.81e2 * t86 * t89 * params.c * t1746) * t478
  t1967 = t1073 * t713 * t632
  t1978 = t1073 * t633
  t1981 = t562 * t72
  t1982 = t1073 * t1756
  t1985 = t1073 * t1788
  t1989 = t1073 * t1907 * t478
  t2006 = t699 ** 2
  t2023 = t707 ** 2
  t2029 = -0.119e3 / 0.3e1 * t689 * t700 + 0.238e3 / 0.3e1 * t689 * t704 - 0.14e2 * t539 * t1885 + 0.28e2 * t539 * t1889 + 0.14e2 * t539 * t697 * t1894 - 0.3e1 * t467 / t1881 / t468 * t95 * t2006 + 0.6e1 * t467 * t1882 * t8 * t1884 + 0.9e1 / 0.2e1 * t467 * t1882 * t95 * t699 * t707 - 0.6e1 * t1892 * t8 * t607 * t707 - 0.3e1 / 0.4e1 * t467 * t698 * t2023 - t1892 * t1893 * t1903
  t2057 = t1689 - t1693 + t1697 + t1700 + t1702 + t1704 - t1706 + t1713 - t1717 + t1721 + t1724 + t1731 - t1733 + t1735 - t1737 + t1741 + t1745
  t2061 = -0.119e3 / 0.3e1 * t689 * t469 - 0.14e2 * t539 * t1897 - 0.14e2 * t539 * t1900 - 0.7e1 / 0.3e1 * t539 * t1904 - 0.3e1 * t467 * t697 * t699 + 0.3e1 / 0.2e1 * t467 * t604 * t707 - 0.13685e5 / 0.81e2 * t44 / t47 / t1670 * t470 - 0.2380e4 / 0.27e2 * t1866 * t608 + 0.4760e4 / 0.27e2 * t1866 * t611 + 0.119e3 / 0.6e1 * t689 * t708 + t467 * t703 * t1903 + t467 * t605 * t2057 / 0.8e1
  t2067 = t1073 * t1083
  t2071 = t1073 * t614 * t454
  t2085 = 0.20e2 / 0.3e1 * t1072 * t1967 + 0.20e2 / 0.9e1 * t1088 * t1073 * t1907 * t632 + 0.10e2 / 0.3e1 * t1088 * t1073 * t713 * t454 + 0.20e2 / 0.9e1 * t1752 * t1978 + 0.20e2 / 0.3e1 * t1981 * t1982 + 0.10e2 / 0.3e1 * t1981 * t1985 + 0.20e2 / 0.9e1 * t1072 * t1989 + 0.5e1 / 0.9e1 * t1088 * t1073 * (t2029 + t2061) * t478 + 0.10e2 / 0.3e1 * t1981 * t2067 + 0.20e2 / 0.3e1 * t1072 * t2071 + 0.4000e4 / 0.27e2 * t562 * t566 * t593 * t1084 + 0.4000e4 / 0.81e2 * t592 * t1788 * t1084 + 0.20e2 / 0.9e1 * t1088 * t1073 * t614 * t1061
  t2115 = -0.200e3 / 0.27e2 * t672 * t718 * t724 + 0.4e1 * t731 * t1061 + t9 * (t1776 + t1833 + t1965 + t2085) + 0.8000e4 / 0.81e2 * t592 * t615 * t1084 + 0.8000e4 / 0.81e2 * t592 * t633 * t1084 + 0.20e2 / 0.9e1 * t1088 * t1989 + 0.20e2 / 0.3e1 * t1088 * t1967 + 0.20e2 / 0.3e1 * t1088 * t2071 + 0.20e2 / 0.9e1 * t1088 * t1075 + 0.20e2 / 0.9e1 * t1752 * t1749 + 0.20e2 / 0.3e1 * t1981 * t1753 + 0.20e2 / 0.3e1 * t1981 * t1978 + 0.20e2 / 0.3e1 * t1072 * t2067 + 0.40e2 / 0.3e1 * t1072 * t1982 + 0.20e2 / 0.3e1 * t1072 * t1985
  d1111 = t723 + t2115

  res = {'v4rho4': d1111}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = 0.1e1 + params.c
  t2 = r0 ** 2
  t3 = r0 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t7 = tau0 / t4 / t2
  t8 = r0 - r1
  t9 = r0 + r1
  t10 = 0.1e1 / t9
  t11 = t8 * t10
  t12 = 0.1e1 + t11
  t13 = t12 / 0.2e1
  t14 = t13 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t16 = t15 * t13
  t17 = t7 * t16
  t21 = tau0 / t4 / r0
  t22 = t9 ** 2
  t23 = 0.1e1 / t22
  t24 = t8 * t23
  t25 = t10 - t24
  t26 = t25 / 0.2e1
  t27 = t15 * t26
  t28 = t21 * t27
  t30 = r1 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t34 = tau1 / t31 / r1
  t35 = 0.1e1 - t11
  t36 = t35 / 0.2e1
  t37 = t36 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t39 = -t26
  t40 = t38 * t39
  t41 = t34 * t40
  t44 = s0 + 0.2e1 * s1 + s2
  t45 = t22 * t9
  t46 = t9 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t51 = t44 / t47 / t45 / 0.3e1
  t52 = -0.5e1 / 0.3e1 * t17 + 0.5e1 / 0.3e1 * t28 + 0.5e1 / 0.3e1 * t41 + t51
  t53 = t1 * t52
  t54 = 6 ** (0.1e1 / 0.3e1)
  t55 = jnp.pi ** 2
  t56 = t55 ** (0.1e1 / 0.3e1)
  t57 = t56 ** 2
  t58 = 0.1e1 / t57
  t59 = t54 * t58
  t60 = t53 * t59
  t61 = 2 ** (0.1e1 / 0.3e1)
  t62 = t61 ** 2
  t63 = t21 * t16
  t64 = t38 * t36
  t65 = t34 * t64
  t67 = 0.1e1 / t47 / t22
  t70 = t63 + t65 - t44 * t67 / 0.8e1
  t75 = 0.1e1 + 0.5e1 / 0.9e1 * params.c * t70 * t59 * t62
  t76 = 0.1e1 / t75
  t77 = t62 * t76
  t78 = t22 ** 2
  t81 = t44 / t47 / t78
  t82 = t63 + t65
  t83 = 0.1e1 / t82
  t84 = t8 ** 2
  t85 = t83 * t84
  t88 = 0.1e1 - t81 * t85 / 0.8e1
  t89 = 3 ** (0.1e1 / 0.3e1)
  t91 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t92 = t89 * t91
  t93 = 4 ** (0.1e1 / 0.3e1)
  t94 = t93 ** 2
  t97 = t92 * t94 / t46
  t99 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t97
  t100 = jnp.sqrt(t97)
  t103 = t97 ** 0.15e1
  t105 = t89 ** 2
  t106 = t91 ** 2
  t107 = t105 * t106
  t110 = t107 * t93 / t47
  t112 = 0.37978500000000000000000000000000000000000000000000e1 * t100 + 0.89690000000000000000000000000000000000000000000000e0 * t97 + 0.20477500000000000000000000000000000000000000000000e0 * t103 + 0.12323500000000000000000000000000000000000000000000e0 * t110
  t115 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t112
  t116 = jnp.log(t115)
  t118 = 0.621814e-1 * t99 * t116
  t119 = t84 ** 2
  t120 = 0.1e1 / t78
  t121 = t119 * t120
  t122 = t12 <= f.p.zeta_threshold
  t123 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t124 = t123 * f.p.zeta_threshold
  t125 = t12 ** (0.1e1 / 0.3e1)
  t127 = f.my_piecewise3(t122, t124, t125 * t12)
  t128 = t35 <= f.p.zeta_threshold
  t129 = t35 ** (0.1e1 / 0.3e1)
  t131 = f.my_piecewise3(t128, t124, t129 * t35)
  t135 = 0.1e1 / (0.2e1 * t61 - 0.2e1)
  t136 = (t127 + t131 - 0.2e1) * t135
  t138 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t97
  t143 = 0.70594500000000000000000000000000000000000000000000e1 * t100 + 0.15494250000000000000000000000000000000000000000000e1 * t97 + 0.42077500000000000000000000000000000000000000000000e0 * t103 + 0.15629250000000000000000000000000000000000000000000e0 * t110
  t146 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t143
  t147 = jnp.log(t146)
  t151 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t97
  t156 = 0.51785000000000000000000000000000000000000000000000e1 * t100 + 0.90577500000000000000000000000000000000000000000000e0 * t97 + 0.11003250000000000000000000000000000000000000000000e0 * t103 + 0.12417750000000000000000000000000000000000000000000e0 * t110
  t159 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t156
  t160 = jnp.log(t159)
  t161 = t151 * t160
  t163 = -0.3109070e-1 * t138 * t147 + t118 - 0.19751673498613801407483339618206552048944131217655e-1 * t161
  t164 = t136 * t163
  t168 = -t118 + t121 * t164 + 0.19751673498613801407483339618206552048944131217655e-1 * t136 * t161
  t169 = t88 * t168
  t170 = t77 * t169
  t171 = t60 * t170
  t173 = t1 * t70
  t174 = t54 ** 2
  t176 = 0.1e1 / t56 / t55
  t177 = t174 * t176
  t178 = t177 * t61
  t179 = t173 * t178
  t180 = t75 ** 2
  t181 = 0.1e1 / t180
  t182 = t181 * t88
  t183 = t168 * params.c
  t184 = t183 * t52
  t185 = t182 * t184
  t186 = t179 * t185
  t188 = t173 * t59
  t189 = t78 * t9
  t192 = t44 / t47 / t189
  t194 = 0.7e1 / 0.12e2 * t192 * t85
  t195 = t82 ** 2
  t196 = 0.1e1 / t195
  t197 = t196 * t84
  t199 = -0.5e1 / 0.3e1 * t17 + 0.5e1 / 0.3e1 * t28 + 0.5e1 / 0.3e1 * t41
  t200 = t197 * t199
  t203 = t83 * t8
  t205 = t81 * t203 / 0.4e1
  t206 = t194 + t81 * t200 / 0.8e1 - t205
  t208 = t77 * t206 * t168
  t209 = t188 * t208
  t212 = 0.1e1 / t46 / t9
  t213 = t94 * t212
  t216 = 0.11073470983333333333333333333333333333333333333333e-2 * t92 * t213 * t116
  t217 = t112 ** 2
  t218 = 0.1e1 / t217
  t219 = t99 * t218
  t221 = 0.1e1 / t100 * t89
  t222 = t91 * t94
  t223 = t222 * t212
  t224 = t221 * t223
  t226 = t92 * t213
  t228 = t97 ** 0.5e0
  t229 = t228 * t89
  t230 = t229 * t223
  t235 = t107 * t93 / t47 / t9
  t237 = -0.63297500000000000000000000000000000000000000000000e0 * t224 - 0.29896666666666666666666666666666666666666666666667e0 * t226 - 0.10238750000000000000000000000000000000000000000000e0 * t230 - 0.82156666666666666666666666666666666666666666666667e-1 * t235
  t238 = 0.1e1 / t115
  t239 = t237 * t238
  t241 = 0.10000000000000000000000000000000000000000000000000e1 * t219 * t239
  t242 = t84 * t8
  t243 = t242 * t120
  t245 = 0.4e1 * t243 * t164
  t246 = 0.1e1 / t189
  t247 = t119 * t246
  t249 = 0.4e1 * t247 * t164
  t252 = f.my_piecewise3(t122, 0, 0.4e1 / 0.3e1 * t125 * t25)
  t253 = -t25
  t256 = f.my_piecewise3(t128, 0, 0.4e1 / 0.3e1 * t129 * t253)
  t258 = (t252 + t256) * t135
  t259 = t258 * t163
  t264 = t143 ** 2
  t265 = 0.1e1 / t264
  t266 = t138 * t265
  t271 = -0.11765750000000000000000000000000000000000000000000e1 * t224 - 0.51647500000000000000000000000000000000000000000000e0 * t226 - 0.21038750000000000000000000000000000000000000000000e0 * t230 - 0.10419500000000000000000000000000000000000000000000e0 * t235
  t272 = 0.1e1 / t146
  t273 = t271 * t272
  t279 = t156 ** 2
  t280 = 0.1e1 / t279
  t281 = t151 * t280
  t286 = -0.86308333333333333333333333333333333333333333333334e0 * t224 - 0.30192500000000000000000000000000000000000000000000e0 * t226 - 0.55016250000000000000000000000000000000000000000000e-1 * t230 - 0.82785000000000000000000000000000000000000000000000e-1 * t235
  t287 = 0.1e1 / t159
  t288 = t286 * t287
  t291 = 0.53237641966666666666666666666666666666666666666666e-3 * t92 * t213 * t147 + 0.10000000000000000000000000000000000000000000000000e1 * t266 * t273 - t216 - t241 + 0.18311447306006545054854346104378990962041954983034e-3 * t92 * t213 * t160 + 0.58482236226346462072622386637590534819724553404280e0 * t281 * t288
  t292 = t136 * t291
  t293 = t121 * t292
  t296 = t136 * t89
  t298 = t222 * t212 * t160
  t300 = 0.18311447306006545054854346104378990962041954983034e-3 * t296 * t298
  t301 = t136 * t151
  t303 = t280 * t286 * t287
  t305 = 0.58482236226346462072622386637590534819724553404280e0 * t301 * t303
  t306 = t216 + t241 + t245 - t249 + t121 * t259 + t293 + 0.19751673498613801407483339618206552048944131217655e-1 * t258 * t161 - t300 - t305
  t308 = t77 * t88 * t306
  t309 = t188 * t308
  t313 = t58 * t62 * t76
  t316 = t173 * t177
  t317 = t61 * t181
  t319 = t317 * params.c * t52
  t322 = -0.5e1 / 0.9e1 * t53 * t54 * t313 + 0.50e2 / 0.81e2 * t316 * t319
  t323 = t322 * t168
  t328 = 0.1e1 - 0.5e1 / 0.9e1 * t173 * t54 * t313
  t329 = t328 * t306
  t336 = 0.40e2 / 0.9e1 * tau0 / t4 / t2 / r0 * t16
  t338 = 0.50e2 / 0.9e1 * t7 * t27
  t339 = 0.1e1 / t14
  t340 = t26 ** 2
  t343 = 0.10e2 / 0.9e1 * t21 * t339 * t340
  t344 = 0.1e1 / t45
  t345 = t8 * t344
  t346 = -t23 + t345
  t349 = 0.5e1 / 0.3e1 * t21 * t15 * t346
  t350 = 0.1e1 / t37
  t351 = t39 ** 2
  t354 = 0.10e2 / 0.9e1 * t34 * t350 * t351
  t358 = -0.5e1 / 0.3e1 * t34 * t38 * t346
  t359 = 0.11e2 / 0.9e1 * t81
  t360 = t336 - t338 + t343 + t349 + t354 + t358 - t359
  t361 = t1 * t360
  t365 = t52 ** 2
  t366 = t1 * t365
  t369 = t317 * t169 * params.c
  t376 = t55 ** 2
  t377 = 0.1e1 / t376
  t379 = 0.1e1 / t180 / t75
  t381 = t173 * t377 * t379
  t382 = params.c ** 2
  t387 = t181 * t206
  t391 = t306 * params.c
  t400 = t78 * t22
  t405 = 0.119e3 / 0.36e2 * t44 / t47 / t400 * t85
  t406 = t192 * t200
  t409 = 0.7e1 / 0.3e1 * t192 * t203
  t411 = 0.1e1 / t195 / t82
  t412 = t411 * t84
  t413 = t199 ** 2
  t417 = t196 * t8
  t419 = t81 * t417 * t199
  t426 = t81 * t83 / 0.4e1
  t437 = 0.1e1 / t46 / t22
  t438 = t94 * t437
  t442 = t92 * t94
  t450 = t271 ** 2
  t458 = t106 * t93 * t67
  t459 = 0.1e1 / t100 / t97 * t105 * t458
  t461 = t222 * t437
  t462 = t221 * t461
  t464 = t92 * t438
  t466 = t97 ** (-0.5e0)
  t468 = t466 * t105 * t458
  t470 = t229 * t461
  t473 = t107 * t93 * t67
  t479 = t264 ** 2
  t482 = t146 ** 2
  t489 = 0.14764627977777777777777777777777777777777777777777e-2 * t92 * t438 * t116
  t493 = 0.35616666666666666666666666666666666666666666666666e-1 * t442 * t212 * t218 * t239
  t497 = t237 ** 2
  t500 = 0.20000000000000000000000000000000000000000000000000e1 * t99 / t217 / t112 * t497 * t238
  t510 = 0.10000000000000000000000000000000000000000000000000e1 * t219 * (-0.42198333333333333333333333333333333333333333333333e0 * t459 + 0.84396666666666666666666666666666666666666666666666e0 * t462 + 0.39862222222222222222222222222222222222222222222223e0 * t464 + 0.68258333333333333333333333333333333333333333333333e-1 * t468 + 0.13651666666666666666666666666666666666666666666667e0 * t470 + 0.13692777777777777777777777777777777777777777777778e0 * t473) * t238
  t511 = t217 ** 2
  t514 = t115 ** 2
  t518 = 0.16081979498692535066756296899072713062105388428051e2 * t99 / t511 * t497 / t514
  t527 = 0.1e1 / t279 / t156
  t529 = t286 ** 2
  t539 = -0.57538888888888888888888888888888888888888888888889e0 * t459 + 0.11507777777777777777777777777777777777777777777778e1 * t462 + 0.40256666666666666666666666666666666666666666666667e0 * t464 + 0.36677500000000000000000000000000000000000000000000e-1 * t468 + 0.73355000000000000000000000000000000000000000000000e-1 * t470 + 0.13797500000000000000000000000000000000000000000000e0 * t473
  t543 = t279 ** 2
  t544 = 0.1e1 / t543
  t546 = t159 ** 2
  t547 = 0.1e1 / t546
  t551 = -0.70983522622222222222222222222222222222222222222221e-3 * t92 * t438 * t147 - 0.34246666666666666666666666666666666666666666666666e-1 * t442 * t212 * t265 * t273 - 0.20000000000000000000000000000000000000000000000000e1 * t138 / t264 / t143 * t450 * t272 + 0.10000000000000000000000000000000000000000000000000e1 * t266 * (-0.78438333333333333333333333333333333333333333333333e0 * t459 + 0.15687666666666666666666666666666666666666666666667e1 * t462 + 0.68863333333333333333333333333333333333333333333333e0 * t464 + 0.14025833333333333333333333333333333333333333333333e0 * t468 + 0.28051666666666666666666666666666666666666666666667e0 * t470 + 0.17365833333333333333333333333333333333333333333333e0 * t473) * t272 + 0.32163958997385070133512593798145426124210776856102e2 * t138 / t479 * t450 / t482 + t489 + t493 + t500 - t510 - t518 - 0.24415263074675393406472461472505321282722606644045e-3 * t92 * t438 * t160 - 0.10843581300301739842632067522386578331157260943710e-1 * t442 * t212 * t280 * t288 - 0.11696447245269292414524477327518106963944910680856e1 * t151 * t527 * t529 * t287 + 0.58482236226346462072622386637590534819724553404280e0 * t281 * t539 * t287 + 0.17315859105681463759666483083807725165579399831905e2 * t151 * t544 * t529 * t547
  t553 = t121 * t136 * t551
  t557 = 0.17315859105681463759666483083807725165579399831905e2 * t301 * t544 * t529 * t547
  t559 = t258 * t151 * t303
  t564 = 0.58482236226346462072622386637590534819724553404280e0 * t301 * t280 * t539 * t287
  t568 = 0.20e2 * t119 / t400 * t164
  t571 = 0.12e2 * t84 * t120 * t164
  t574 = 0.32e2 * t242 * t246 * t164
  t575 = t125 ** 2
  t576 = 0.1e1 / t575
  t577 = t25 ** 2
  t580 = 0.2e1 * t346
  t584 = f.my_piecewise3(t122, 0, 0.4e1 / 0.9e1 * t576 * t577 + 0.4e1 / 0.3e1 * t125 * t580)
  t585 = t129 ** 2
  t586 = 0.1e1 / t585
  t587 = t253 ** 2
  t594 = f.my_piecewise3(t128, 0, 0.4e1 / 0.9e1 * t586 * t587 - 0.4e1 / 0.3e1 * t129 * t580)
  t596 = (t584 + t594) * t135
  t602 = 0.10843581300301739842632067522386578331157260943710e-1 * t136 * t92 * t213 * t303
  t603 = t553 - t557 - 0.11696447245269292414524477327518106963944910680856e1 * t559 - t564 + t568 + t571 - t574 + 0.19751673498613801407483339618206552048944131217655e-1 * t596 * t161 + t518 + t510 + t602
  t607 = t121 * t258 * t291
  t609 = t247 * t259
  t612 = 0.8e1 * t247 * t292
  t613 = t243 * t259
  t616 = 0.8e1 * t243 * t292
  t618 = t258 * t89 * t298
  t623 = 0.11696447245269292414524477327518106963944910680856e1 * t301 * t527 * t529 * t287
  t627 = 0.24415263074675393406472461472505321282722606644045e-3 * t296 * t222 * t437 * t160
  t628 = t121 * t596 * t163 + 0.2e1 * t607 - 0.8e1 * t609 - t612 + 0.8e1 * t613 + t616 - t500 - 0.36622894612013090109708692208757981924083909966068e-3 * t618 + t623 - t493 - t489 + t627
  t629 = t603 + t628
  t640 = t176 * t61 * t181 * params.c
  t643 = t173 * t377
  t644 = t379 * t382
  t657 = 0.5e1 / 0.9e1 * t361 * t59 * t170 - 0.100e3 / 0.81e2 * t366 * t177 * t369 + 0.10e2 / 0.9e1 * t60 * t208 + 0.10e2 / 0.9e1 * t60 * t308 + 0.2000e4 / 0.243e3 * t381 * t169 * t382 * t365 - 0.100e3 / 0.81e2 * t179 * t387 * t184 - 0.100e3 / 0.81e2 * t179 * t182 * t391 * t52 - 0.50e2 / 0.81e2 * t179 * t182 * t183 * t360 + 0.5e1 / 0.9e1 * t188 * t77 * (-t405 - 0.7e1 / 0.6e1 * t406 + t409 - t81 * t412 * t413 / 0.4e1 + t419 / 0.2e1 + t81 * t197 * (t336 - t338 + t343 + t349 + t354 + t358) / 0.8e1 - t426) * t168 + 0.10e2 / 0.9e1 * t188 * t77 * t206 * t306 + 0.5e1 / 0.9e1 * t188 * t77 * t88 * t629 + (-0.5e1 / 0.9e1 * t361 * t54 * t313 + 0.100e3 / 0.81e2 * t366 * t174 * t640 - 0.2000e4 / 0.243e3 * t643 * t644 * t365 + 0.50e2 / 0.81e2 * t316 * t317 * params.c * t360) * t168 + 0.2e1 * t322 * t306 + t328 * t629
  d11 = 0.10e2 / 0.9e1 * t171 - 0.100e3 / 0.81e2 * t186 + 0.10e2 / 0.9e1 * t209 + 0.10e2 / 0.9e1 * t309 + 0.2e1 * t323 + 0.2e1 * t329 + t9 * t657
  t663 = -t10 - t24
  t664 = t663 / 0.2e1
  t665 = t15 * t664
  t666 = t21 * t665
  t668 = r1 ** 2
  t671 = tau1 / t31 / t668
  t672 = t671 * t64
  t674 = -t664
  t675 = t38 * t674
  t676 = t34 * t675
  t678 = 0.5e1 / 0.3e1 * t666 - 0.5e1 / 0.3e1 * t672 + 0.5e1 / 0.3e1 * t676 + t51
  t679 = t1 * t678
  t680 = t679 * t59
  t681 = t680 * t170
  t683 = t183 * t678
  t685 = t179 * t182 * t683
  t688 = 0.5e1 / 0.3e1 * t666 - 0.5e1 / 0.3e1 * t672 + 0.5e1 / 0.3e1 * t676
  t689 = t197 * t688
  t692 = t194 + t81 * t689 / 0.8e1 + t205
  t694 = t77 * t692 * t168
  t695 = t188 * t694
  t699 = f.my_piecewise3(t122, 0, 0.4e1 / 0.3e1 * t125 * t663)
  t700 = -t663
  t703 = f.my_piecewise3(t128, 0, 0.4e1 / 0.3e1 * t129 * t700)
  t705 = (t699 + t703) * t135
  t706 = t705 * t163
  t710 = t216 + t241 - t245 - t249 + t121 * t706 + t293 + 0.19751673498613801407483339618206552048944131217655e-1 * t705 * t161 - t300 - t305
  t712 = t77 * t88 * t710
  t713 = t188 * t712
  t722 = -0.5e1 / 0.9e1 * t679 * t54 * t313 + 0.50e2 / 0.81e2 * t316 * t317 * params.c * t678
  t723 = t722 * t168
  t724 = t328 * t710
  t726 = 0.25e2 / 0.9e1 * t7 * t665
  t730 = 0.10e2 / 0.9e1 * t21 * t339 * t664 * t26
  t734 = 0.5e1 / 0.3e1 * t21 * t15 * t8 * t344
  t736 = 0.25e2 / 0.9e1 * t671 * t40
  t740 = 0.10e2 / 0.9e1 * t34 * t350 * t674 * t39
  t744 = 0.5e1 / 0.3e1 * t34 * t38 * t8 * t344
  t745 = -t726 + t730 + t734 - t736 + t740 - t744 - t359
  t746 = t1 * t745
  t775 = t181 * t692
  t780 = t192 * t689
  t788 = t81 * t417 * t688
  t806 = t710 * params.c
  t816 = t705 * t151 * t303
  t818 = t243 * t706
  t820 = t247 * t706
  t829 = f.my_piecewise3(t122, 0, 0.4e1 / 0.9e1 * t576 * t663 * t25 + 0.8e1 / 0.3e1 * t125 * t8 * t344)
  t837 = f.my_piecewise3(t128, 0, 0.4e1 / 0.9e1 * t586 * t700 * t253 - 0.8e1 / 0.3e1 * t129 * t8 * t344)
  t839 = (t829 + t837) * t135
  t843 = t121 * t705 * t291
  t846 = t705 * t89 * t298
  t848 = -t489 + t553 - 0.58482236226346462072622386637590534819724553404280e0 * t816 + t602 + 0.4e1 * t818 - 0.4e1 * t820 + t121 * t839 * t163 + t843 + t623 - 0.58482236226346462072622386637590534819724553404280e0 * t559 - t564 - t557 - 0.18311447306006545054854346104378990962041954983034e-3 * t846
  t854 = -t493 - 0.18311447306006545054854346104378990962041954983034e-3 * t618 + t627 + 0.19751673498613801407483339618206552048944131217655e-1 * t839 * t161 - t612 - 0.4e1 * t613 + t568 - t571 + t607 - 0.4e1 * t609 - t500 + t510 + t518
  t855 = t848 + t854
  t879 = 0.5e1 / 0.9e1 * t746 * t59 * t170 - 0.100e3 / 0.81e2 * t679 * t178 * t185 + 0.5e1 / 0.9e1 * t680 * t208 + 0.5e1 / 0.9e1 * t680 * t308 + 0.2000e4 / 0.243e3 * t381 * t169 * t382 * t678 * t52 - 0.50e2 / 0.81e2 * t179 * t387 * t683 - 0.50e2 / 0.81e2 * t179 * t182 * t391 * t678 - 0.50e2 / 0.81e2 * t179 * t182 * t183 * t745 + 0.5e1 / 0.9e1 * t60 * t694 - 0.50e2 / 0.81e2 * t179 * t775 * t184 + 0.5e1 / 0.9e1 * t188 * t77 * (-t405 - 0.7e1 / 0.12e2 * t406 - 0.7e1 / 0.12e2 * t780 - t81 * t411 * t84 * t688 * t199 / 0.4e1 + t788 / 0.4e1 + t81 * t197 * (-t726 + t730 + t734 - t736 + t740 - t744) / 0.8e1 - t419 / 0.4e1 + t426) * t168 + 0.5e1 / 0.9e1 * t188 * t77 * t692 * t306 + 0.5e1 / 0.9e1 * t60 * t712 - 0.50e2 / 0.81e2 * t179 * t182 * t806 * t52 + 0.5e1 / 0.9e1 * t188 * t77 * t206 * t710 + 0.5e1 / 0.9e1 * t188 * t77 * t88 * t855 + (-0.5e1 / 0.9e1 * t746 * t54 * t313 + 0.100e3 / 0.81e2 * t679 * t177 * t319 - 0.2000e4 / 0.243e3 * t643 * t644 * t678 * t52 + 0.50e2 / 0.81e2 * t316 * t317 * params.c * t745) * t168 + t722 * t306 + t322 * t710 + t328 * t855
  d12 = 0.5e1 / 0.9e1 * t171 - 0.50e2 / 0.81e2 * t186 + 0.5e1 / 0.9e1 * t209 + 0.5e1 / 0.9e1 * t309 + t323 + t329 + 0.5e1 / 0.9e1 * t681 - 0.50e2 / 0.81e2 * t685 + 0.5e1 / 0.9e1 * t695 + 0.5e1 / 0.9e1 * t713 + t723 + t724 + t9 * t879
  t887 = t664 ** 2
  t890 = 0.10e2 / 0.9e1 * t21 * t339 * t887
  t891 = t23 + t345
  t894 = 0.5e1 / 0.3e1 * t21 * t15 * t891
  t900 = 0.40e2 / 0.9e1 * tau1 / t31 / t668 / r1 * t64
  t902 = 0.50e2 / 0.9e1 * t671 * t675
  t903 = t674 ** 2
  t906 = 0.10e2 / 0.9e1 * t34 * t350 * t903
  t910 = -0.5e1 / 0.3e1 * t34 * t38 * t891
  t911 = t890 + t894 + t900 - t902 + t906 + t910 - t359
  t912 = t1 * t911
  t916 = t678 ** 2
  t917 = t1 * t916
  t941 = t688 ** 2
  t960 = t663 ** 2
  t963 = 0.2e1 * t891
  t967 = f.my_piecewise3(t122, 0, 0.4e1 / 0.9e1 * t576 * t960 + 0.4e1 / 0.3e1 * t125 * t963)
  t968 = t700 ** 2
  t975 = f.my_piecewise3(t128, 0, 0.4e1 / 0.9e1 * t586 * t968 - 0.4e1 / 0.3e1 * t129 * t963)
  t977 = (t967 + t975) * t135
  t981 = t568 + t574 - t489 + t602 - 0.36622894612013090109708692208757981924083909966068e-3 * t846 + t623 - t493 + t553 + t121 * t977 * t163 + 0.2e1 * t843 - t557
  t987 = -t564 - 0.11696447245269292414524477327518106963944910680856e1 * t816 + 0.19751673498613801407483339618206552048944131217655e-1 * t977 * t161 + t510 + t518 + t571 - 0.8e1 * t820 - t612 - 0.8e1 * t818 - t616 - t500 + t627
  t988 = t981 + t987
  t1011 = 0.5e1 / 0.9e1 * t912 * t59 * t170 - 0.100e3 / 0.81e2 * t917 * t177 * t369 + 0.10e2 / 0.9e1 * t680 * t694 + 0.10e2 / 0.9e1 * t680 * t712 + 0.2000e4 / 0.243e3 * t381 * t169 * t382 * t916 - 0.100e3 / 0.81e2 * t179 * t775 * t683 - 0.100e3 / 0.81e2 * t179 * t182 * t806 * t678 - 0.50e2 / 0.81e2 * t179 * t182 * t183 * t911 + 0.5e1 / 0.9e1 * t188 * t77 * (-t405 - 0.7e1 / 0.6e1 * t780 - t409 - t81 * t412 * t941 / 0.4e1 - t788 / 0.2e1 + t81 * t197 * (t890 + t894 + t900 - t902 + t906 + t910) / 0.8e1 - t426) * t168 + 0.10e2 / 0.9e1 * t188 * t77 * t692 * t710 + 0.5e1 / 0.9e1 * t188 * t77 * t88 * t988 + (-0.5e1 / 0.9e1 * t912 * t54 * t313 + 0.100e3 / 0.81e2 * t917 * t174 * t640 - 0.2000e4 / 0.243e3 * t643 * t644 * t916 + 0.50e2 / 0.81e2 * t316 * t317 * params.c * t911) * t168 + 0.2e1 * t722 * t710 + t328 * t988
  d22 = 0.10e2 / 0.9e1 * t681 - 0.100e3 / 0.81e2 * t685 + 0.10e2 / 0.9e1 * t695 + 0.10e2 / 0.9e1 * t713 + 0.2e1 * t723 + 0.2e1 * t724 + t9 * t1011
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

