"""Generated from mgga_c_ltapw.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_ltafrac_raw = params.ltafrac
  if isinstance(params_ltafrac_raw, (str, bytes, dict)):
    params_ltafrac = params_ltafrac_raw
  else:
    try:
      params_ltafrac_seq = list(params_ltafrac_raw)
    except TypeError:
      params_ltafrac = params_ltafrac_raw
    else:
      params_ltafrac_seq = np.asarray(params_ltafrac_seq, dtype=np.float64)
      params_ltafrac = np.concatenate((np.array([np.nan], dtype=np.float64), params_ltafrac_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  nt_tau = lambda t: (t / K_FACTOR_C) ** (3 * params_ltafrac / 5)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  n_eff_s = lambda rs, z, t: f.n_spin(rs, z) * nt_tau(t)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  n_eff = lambda rs, z, ts0, ts1: n_eff_s(rs, z, ts0) + n_eff_s(rs, -z, ts1)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  eff_rs = lambda rs, z, ts0, ts1: f.r_ws(n_eff(rs, z, ts0, ts1))

  eff_z = lambda rs, z, ts0, ts1: (n_eff_s(rs, z, ts0) - n_eff_s(rs, -z, ts1)) / n_eff(rs, z, ts0, ts1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: f_pw(eff_rs(rs, z, ts0, ts1), eff_z(rs, z, ts0, ts1))

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_ltafrac_raw = params.ltafrac
  if isinstance(params_ltafrac_raw, (str, bytes, dict)):
    params_ltafrac = params_ltafrac_raw
  else:
    try:
      params_ltafrac_seq = list(params_ltafrac_raw)
    except TypeError:
      params_ltafrac = params_ltafrac_raw
    else:
      params_ltafrac_seq = np.asarray(params_ltafrac_seq, dtype=np.float64)
      params_ltafrac = np.concatenate((np.array([np.nan], dtype=np.float64), params_ltafrac_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  nt_tau = lambda t: (t / K_FACTOR_C) ** (3 * params_ltafrac / 5)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  n_eff_s = lambda rs, z, t: f.n_spin(rs, z) * nt_tau(t)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  n_eff = lambda rs, z, ts0, ts1: n_eff_s(rs, z, ts0) + n_eff_s(rs, -z, ts1)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  eff_rs = lambda rs, z, ts0, ts1: f.r_ws(n_eff(rs, z, ts0, ts1))

  eff_z = lambda rs, z, ts0, ts1: (n_eff_s(rs, z, ts0) - n_eff_s(rs, -z, ts1)) / n_eff(rs, z, ts0, ts1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: f_pw(eff_rs(rs, z, ts0, ts1), eff_z(rs, z, ts0, ts1))

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_ltafrac_raw = params.ltafrac
  if isinstance(params_ltafrac_raw, (str, bytes, dict)):
    params_ltafrac = params_ltafrac_raw
  else:
    try:
      params_ltafrac_seq = list(params_ltafrac_raw)
    except TypeError:
      params_ltafrac = params_ltafrac_raw
    else:
      params_ltafrac_seq = np.asarray(params_ltafrac_seq, dtype=np.float64)
      params_ltafrac = np.concatenate((np.array([np.nan], dtype=np.float64), params_ltafrac_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  nt_tau = lambda t: (t / K_FACTOR_C) ** (3 * params_ltafrac / 5)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  n_eff_s = lambda rs, z, t: f.n_spin(rs, z) * nt_tau(t)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  n_eff = lambda rs, z, ts0, ts1: n_eff_s(rs, z, ts0) + n_eff_s(rs, -z, ts1)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  eff_rs = lambda rs, z, ts0, ts1: f.r_ws(n_eff(rs, z, ts0, ts1))

  eff_z = lambda rs, z, ts0, ts1: (n_eff_s(rs, z, ts0) - n_eff_s(rs, -z, ts1)) / n_eff(rs, z, ts0, ts1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: f_pw(eff_rs(rs, z, ts0, ts1), eff_z(rs, z, ts0, ts1))

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t12 = 6 ** (0.1e1 / 0.3e1)
  t13 = jnp.pi ** 2
  t14 = t13 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = t12 / t15
  t20 = 0.3e1 / 0.5e1 * params.ltafrac
  t21 = (0.5e1 / 0.9e1 * tau0 / t8 / r0 * t17) ** t20
  t22 = r0 * t21
  t23 = r1 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t30 = (0.5e1 / 0.9e1 * tau1 / t24 / r1 * t17) ** t20
  t31 = r1 * t30
  t32 = t22 + t31
  t33 = t32 ** (0.1e1 / 0.3e1)
  t36 = t4 * t6 / t33
  t38 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t36
  t39 = jnp.sqrt(t36)
  t42 = t36 ** 0.15e1
  t44 = t1 ** 2
  t45 = t3 ** 2
  t46 = t44 * t45
  t47 = t33 ** 2
  t50 = t46 * t5 / t47
  t52 = 0.23615790870000000000000000000000000000000000000000e0 * t39 + 0.55771035800000000000000000000000000000000000000000e-1 * t36 + 0.12733319050000000000000000000000000000000000000000e-1 * t42 + 0.76629987700000000000000000000000000000000000000000e-2 * t50
  t54 = 0.1e1 + 0.1e1 / t52
  t55 = jnp.log(t54)
  t56 = t38 * t55
  t57 = t22 - t31
  t58 = t57 ** 2
  t59 = t58 ** 2
  t60 = t32 ** 2
  t61 = t60 ** 2
  t62 = 0.1e1 / t61
  t63 = t59 * t62
  t64 = 0.1e1 / t32
  t65 = t57 * t64
  t66 = 0.1e1 + t65
  t67 = t66 <= f.p.zeta_threshold
  t68 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t69 = t68 * f.p.zeta_threshold
  t70 = t66 ** (0.1e1 / 0.3e1)
  t72 = f.my_piecewise3(t67, t69, t70 * t66)
  t73 = 0.1e1 - t65
  t74 = t73 <= f.p.zeta_threshold
  t75 = t73 ** (0.1e1 / 0.3e1)
  t77 = f.my_piecewise3(t74, t69, t75 * t73)
  t78 = t72 + t77 - 0.2e1
  t79 = 2 ** (0.1e1 / 0.3e1)
  t82 = 0.1e1 / (0.2e1 * t79 - 0.2e1)
  t83 = t78 * t82
  t85 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t36
  t90 = 0.21947830050000000000000000000000000000000000000000e0 * t39 + 0.48171623250000000000000000000000000000000000000000e-1 * t36 + 0.13081894750000000000000000000000000000000000000000e-1 * t42 + 0.48591338250000000000000000000000000000000000000000e-2 * t50
  t92 = 0.1e1 + 0.1e1 / t90
  t93 = jnp.log(t92)
  t96 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t36
  t101 = 0.17489865900000000000000000000000000000000000000000e0 * t39 + 0.30591644850000000000000000000000000000000000000000e-1 * t36 + 0.37162376550000000000000000000000000000000000000000e-2 * t42 + 0.41939708850000000000000000000000000000000000000000e-2 * t50
  t103 = 0.1e1 + 0.1e1 / t101
  t104 = jnp.log(t103)
  t105 = t96 * t104
  t107 = -t85 * t93 + t56 - 0.58482233974552040708313425006184496242808878304904e0 * t105
  t109 = t63 * t83 * t107
  t111 = 0.58482233974552040708313425006184496242808878304904e0 * t83 * t105
  t112 = r0 + r1
  t113 = t4 * t6
  t115 = 0.1e1 / t33 / t32
  t116 = t21 * params.ltafrac
  t117 = t21 - t116
  t118 = t115 * t117
  t121 = 0.11073577833333333333333333333333333333333333333333e-2 * t113 * t118 * t55
  t122 = t52 ** 2
  t124 = t38 / t122
  t126 = 0.1e1 / t39 * t1
  t127 = t126 * t3
  t128 = t6 * t115
  t129 = t128 * t117
  t130 = t127 * t129
  t132 = t4 * t129
  t134 = t36 ** 0.5e0
  t135 = t134 * t1
  t136 = t135 * t3
  t137 = t136 * t129
  t141 = t5 / t47 / t32
  t143 = t46 * t141 * t117
  t146 = 0.1e1 / t54
  t148 = t124 * (-0.39359651450000000000000000000000000000000000000000e-1 * t130 - 0.18590345266666666666666666666666666666666666666667e-1 * t132 - 0.63666595250000000000000000000000000000000000000000e-2 * t137 - 0.51086658466666666666666666666666666666666666666667e-2 * t143) * t146
  t150 = t58 * t57 * t62
  t151 = t150 * t78
  t152 = t82 * t107
  t153 = t152 * t117
  t158 = t59 / t61 / t32
  t159 = t158 * t78
  t164 = t57 / t60
  t166 = -t164 * t117 + t117 * t64
  t169 = f.my_piecewise3(t67, 0, 0.4e1 / 0.3e1 * t70 * t166)
  t173 = f.my_piecewise3(t74, 0, -0.4e1 / 0.3e1 * t75 * t166)
  t175 = (t169 + t173) * t82
  t181 = t90 ** 2
  t183 = t85 / t181
  t189 = 0.1e1 / t92
  t195 = t101 ** 2
  t196 = 0.1e1 / t195
  t197 = t96 * t196
  t202 = -0.29149776500000000000000000000000000000000000000000e-1 * t130 - 0.10197214950000000000000000000000000000000000000000e-1 * t132 - 0.18581188275000000000000000000000000000000000000000e-2 * t137 - 0.27959805900000000000000000000000000000000000000000e-2 * t143
  t203 = 0.1e1 / t103
  t212 = t83 * t4
  t217 = t83 * t96
  vrho_0_ = -t56 + t109 + t111 + t112 * (t121 + t148 + 0.4e1 * t151 * t153 - 0.4e1 * t159 * t153 + t63 * t175 * t107 + t63 * t83 * (0.53236443333333333333333333333333333333333333333333e-3 * t113 * t118 * t93 + t183 * (-0.36579716750000000000000000000000000000000000000000e-1 * t130 - 0.16057207750000000000000000000000000000000000000000e-1 * t132 - 0.65409473750000000000000000000000000000000000000000e-2 * t137 - 0.32394225500000000000000000000000000000000000000000e-2 * t143) * t189 - t121 - t148 + 0.18311555036753159941307229983139571945136646663793e-3 * t113 * t118 * t104 + 0.58482233974552040708313425006184496242808878304904e0 * t197 * t202 * t203) + 0.58482233974552040708313425006184496242808878304904e0 * t175 * t105 - 0.18311555036753159941307229983139571945136646663793e-3 * t212 * t128 * t117 * t104 - 0.58482233974552040708313425006184496242808878304904e0 * t217 * t196 * t202 * t203)
  t224 = t30 * params.ltafrac
  t225 = t30 - t224
  t226 = t115 * t225
  t229 = 0.11073577833333333333333333333333333333333333333333e-2 * t113 * t226 * t55
  t230 = t128 * t225
  t231 = t127 * t230
  t233 = t4 * t230
  t235 = t136 * t230
  t238 = t46 * t141 * t225
  t242 = t124 * (-0.39359651450000000000000000000000000000000000000000e-1 * t231 - 0.18590345266666666666666666666666666666666666666667e-1 * t233 - 0.63666595250000000000000000000000000000000000000000e-2 * t235 - 0.51086658466666666666666666666666666666666666666667e-2 * t238) * t146
  t243 = -t225
  t252 = -t164 * t225 + t243 * t64
  t255 = f.my_piecewise3(t67, 0, 0.4e1 / 0.3e1 * t70 * t252)
  t259 = f.my_piecewise3(t74, 0, -0.4e1 / 0.3e1 * t75 * t252)
  t261 = (t255 + t259) * t82
  t281 = -0.29149776500000000000000000000000000000000000000000e-1 * t231 - 0.10197214950000000000000000000000000000000000000000e-1 * t233 - 0.18581188275000000000000000000000000000000000000000e-2 * t235 - 0.27959805900000000000000000000000000000000000000000e-2 * t238
  vrho_1_ = -t56 + t109 + t111 + t112 * (t229 + t242 + 0.4e1 * t151 * t152 * t243 - 0.4e1 * t159 * t152 * t225 + t63 * t261 * t107 + t63 * t83 * (0.53236443333333333333333333333333333333333333333333e-3 * t113 * t226 * t93 + t183 * (-0.36579716750000000000000000000000000000000000000000e-1 * t231 - 0.16057207750000000000000000000000000000000000000000e-1 * t233 - 0.65409473750000000000000000000000000000000000000000e-2 * t235 - 0.32394225500000000000000000000000000000000000000000e-2 * t238) * t189 - t229 - t242 + 0.18311555036753159941307229983139571945136646663793e-3 * t113 * t226 * t104 + 0.58482233974552040708313425006184496242808878304904e0 * t197 * t281 * t203) + 0.58482233974552040708313425006184496242808878304904e0 * t261 * t105 - 0.18311555036753159941307229983139571945136646663793e-3 * t212 * t128 * t225 * t104 - 0.58482233974552040708313425006184496242808878304904e0 * t217 * t196 * t281 * t203)
  vsigma_0_ = 0.0e0
  vsigma_1_ = 0.0e0
  vsigma_2_ = 0.0e0
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t300 = t4 * t128
  t301 = 0.1e1 / tau0
  t302 = params.ltafrac * t301
  t306 = 0.66441467000000000000000000000000000000000000000000e-3 * t300 * t22 * t302 * t55
  t307 = t3 * t6
  t308 = t126 * t307
  t309 = t115 * r0
  t310 = t116 * t301
  t311 = t309 * t310
  t312 = t308 * t311
  t314 = t22 * t302
  t315 = t300 * t314
  t317 = t135 * t307
  t318 = t317 * t311
  t320 = t46 * t141
  t321 = t320 * t314
  t325 = t124 * (-0.23615790870000000000000000000000000000000000000000e-1 * t312 - 0.11154207160000000000000000000000000000000000000000e-1 * t315 - 0.38199957150000000000000000000000000000000000000000e-2 * t318 - 0.30651995080000000000000000000000000000000000000000e-2 * t321) * t146
  t326 = t150 * t83
  t328 = t107 * r0 * t310
  t331 = t158 * t83
  t339 = -0.3e1 / 0.5e1 * t164 * r0 * t310 + 0.3e1 / 0.5e1 * t22 * t302 * t64
  t342 = f.my_piecewise3(t67, 0, 0.4e1 / 0.3e1 * t70 * t339)
  t346 = f.my_piecewise3(t74, 0, -0.4e1 / 0.3e1 * t75 * t339)
  t348 = (t342 + t346) * t82
  t362 = t302 * t104
  t370 = -0.17489865900000000000000000000000000000000000000000e-1 * t312 - 0.61183289700000000000000000000000000000000000000000e-2 * t315 - 0.11148712965000000000000000000000000000000000000000e-2 * t318 - 0.16775883540000000000000000000000000000000000000000e-2 * t321
  t379 = t83 * t113
  vtau_0_ = t112 * (t306 + t325 + 0.12e2 / 0.5e1 * t326 * t328 - 0.12e2 / 0.5e1 * t331 * t328 + t63 * t348 * t107 + t63 * t83 * (0.31941866000000000000000000000000000000000000000000e-3 * t300 * t22 * t302 * t93 + t183 * (-0.21947830050000000000000000000000000000000000000000e-1 * t312 - 0.96343246500000000000000000000000000000000000000000e-2 * t315 - 0.39245684250000000000000000000000000000000000000000e-2 * t318 - 0.19436535300000000000000000000000000000000000000000e-2 * t321) * t189 - t306 - t325 + 0.10986933022051895964784337989883743167081987998276e-3 * t300 * t22 * t362 + 0.58482233974552040708313425006184496242808878304904e0 * t197 * t370 * t203) + 0.58482233974552040708313425006184496242808878304904e0 * t348 * t105 - 0.10986933022051895964784337989883743167081987998276e-3 * t379 * t309 * t21 * t362 - 0.58482233974552040708313425006184496242808878304904e0 * t217 * t196 * t370 * t203)
  t389 = 0.1e1 / tau1
  t390 = params.ltafrac * t389
  t394 = 0.66441467000000000000000000000000000000000000000000e-3 * t300 * t31 * t390 * t55
  t395 = t115 * r1
  t396 = t224 * t389
  t397 = t395 * t396
  t398 = t308 * t397
  t400 = t31 * t390
  t401 = t300 * t400
  t403 = t317 * t397
  t405 = t320 * t400
  t409 = t124 * (-0.23615790870000000000000000000000000000000000000000e-1 * t398 - 0.11154207160000000000000000000000000000000000000000e-1 * t401 - 0.38199957150000000000000000000000000000000000000000e-2 * t403 - 0.30651995080000000000000000000000000000000000000000e-2 * t405) * t146
  t411 = t107 * r1 * t396
  t421 = -0.3e1 / 0.5e1 * t164 * r1 * t396 - 0.3e1 / 0.5e1 * t31 * t390 * t64
  t424 = f.my_piecewise3(t67, 0, 0.4e1 / 0.3e1 * t70 * t421)
  t428 = f.my_piecewise3(t74, 0, -0.4e1 / 0.3e1 * t75 * t421)
  t430 = (t424 + t428) * t82
  t444 = t390 * t104
  t452 = -0.17489865900000000000000000000000000000000000000000e-1 * t398 - 0.61183289700000000000000000000000000000000000000000e-2 * t401 - 0.11148712965000000000000000000000000000000000000000e-2 * t403 - 0.16775883540000000000000000000000000000000000000000e-2 * t405
  vtau_1_ = t112 * (t394 + t409 - 0.12e2 / 0.5e1 * t326 * t411 - 0.12e2 / 0.5e1 * t331 * t411 + t63 * t430 * t107 + t63 * t83 * (0.31941866000000000000000000000000000000000000000000e-3 * t300 * t31 * t390 * t93 + t183 * (-0.21947830050000000000000000000000000000000000000000e-1 * t398 - 0.96343246500000000000000000000000000000000000000000e-2 * t401 - 0.39245684250000000000000000000000000000000000000000e-2 * t403 - 0.19436535300000000000000000000000000000000000000000e-2 * t405) * t189 - t394 - t409 + 0.10986933022051895964784337989883743167081987998276e-3 * t300 * t31 * t444 + 0.58482233974552040708313425006184496242808878304904e0 * t197 * t452 * t203) + 0.58482233974552040708313425006184496242808878304904e0 * t430 * t105 - 0.10986933022051895964784337989883743167081987998276e-3 * t379 * t395 * t30 * t444 - 0.58482233974552040708313425006184496242808878304904e0 * t217 * t196 * t452 * t203)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_ltafrac_raw = params.ltafrac
  if isinstance(params_ltafrac_raw, (str, bytes, dict)):
    params_ltafrac = params_ltafrac_raw
  else:
    try:
      params_ltafrac_seq = list(params_ltafrac_raw)
    except TypeError:
      params_ltafrac = params_ltafrac_raw
    else:
      params_ltafrac_seq = np.asarray(params_ltafrac_seq, dtype=np.float64)
      params_ltafrac = np.concatenate((np.array([np.nan], dtype=np.float64), params_ltafrac_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  nt_tau = lambda t: (t / K_FACTOR_C) ** (3 * params_ltafrac / 5)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  n_eff_s = lambda rs, z, t: f.n_spin(rs, z) * nt_tau(t)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  n_eff = lambda rs, z, ts0, ts1: n_eff_s(rs, z, ts0) + n_eff_s(rs, -z, ts1)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  eff_rs = lambda rs, z, ts0, ts1: f.r_ws(n_eff(rs, z, ts0, ts1))

  eff_z = lambda rs, z, ts0, ts1: (n_eff_s(rs, z, ts0) - n_eff_s(rs, -z, ts1)) / n_eff(rs, z, ts0, ts1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: f_pw(eff_rs(rs, z, ts0, ts1), eff_z(rs, z, ts0, ts1))

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = 2 ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t10 = r0 ** (0.1e1 / 0.3e1)
  t11 = t10 ** 2
  t14 = 6 ** (0.1e1 / 0.3e1)
  t16 = jnp.pi ** 2
  t17 = t16 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t24 = (0.5e1 / 0.9e1 * tau0 * t8 / t11 / r0 * t14 / t18) ** (0.3e1 / 0.5e1 * params.ltafrac)
  t25 = r0 * t24
  t26 = t25 ** (0.1e1 / 0.3e1)
  t29 = t4 * t6 / t26
  t31 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t29
  t32 = jnp.sqrt(t29)
  t35 = t29 ** 0.15e1
  t37 = t1 ** 2
  t38 = t3 ** 2
  t39 = t37 * t38
  t40 = t26 ** 2
  t43 = t39 * t5 / t40
  t45 = 0.23615790870000000000000000000000000000000000000000e0 * t32 + 0.55771035800000000000000000000000000000000000000000e-1 * t29 + 0.12733319050000000000000000000000000000000000000000e-1 * t35 + 0.76629987700000000000000000000000000000000000000000e-2 * t43
  t47 = 0.1e1 + 0.1e1 / t45
  t48 = jnp.log(t47)
  t51 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t53 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t51 * f.p.zeta_threshold, 1)
  t59 = (0.2e1 * t53 - 0.2e1) / (0.2e1 * t7 - 0.2e1)
  t61 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t29
  t66 = 0.17489865900000000000000000000000000000000000000000e0 * t32 + 0.30591644850000000000000000000000000000000000000000e-1 * t29 + 0.37162376550000000000000000000000000000000000000000e-2 * t35 + 0.41939708850000000000000000000000000000000000000000e-2 * t43
  t68 = 0.1e1 + 0.1e1 / t66
  t69 = jnp.log(t68)
  t73 = t4 * t6
  t75 = 0.1e1 / t26 / t25
  t76 = t24 * params.ltafrac
  t77 = t24 - t76
  t82 = t45 ** 2
  t84 = t31 / t82
  t86 = 0.1e1 / t32 * t1
  t88 = t6 * t75
  t89 = t88 * t77
  t90 = t86 * t3 * t89
  t92 = t4 * t89
  t94 = t29 ** 0.5e0
  t95 = t94 * t1
  t97 = t95 * t3 * t89
  t101 = t5 / t40 / t25
  t103 = t39 * t101 * t77
  t106 = 0.1e1 / t47
  t114 = t59 * t61
  t115 = t66 ** 2
  t116 = 0.1e1 / t115
  t123 = 0.1e1 / t68
  vrho_0_ = -t31 * t48 + 0.58482233974552040708313425006184496242808878304904e0 * t59 * t61 * t69 + r0 * (0.11073577833333333333333333333333333333333333333333e-2 * t73 * t75 * t77 * t48 + t84 * (-0.39359651450000000000000000000000000000000000000000e-1 * t90 - 0.18590345266666666666666666666666666666666666666667e-1 * t92 - 0.63666595250000000000000000000000000000000000000000e-2 * t97 - 0.51086658466666666666666666666666666666666666666667e-2 * t103) * t106 - 0.18311555036753159941307229983139571945136646663793e-3 * t59 * t4 * t88 * t77 * t69 - 0.58482233974552040708313425006184496242808878304904e0 * t114 * t116 * (-0.29149776500000000000000000000000000000000000000000e-1 * t90 - 0.10197214950000000000000000000000000000000000000000e-1 * t92 - 0.18581188275000000000000000000000000000000000000000e-2 * t97 - 0.27959805900000000000000000000000000000000000000000e-2 * t103) * t123)
  vsigma_0_ = 0.0e0
  vlapl_0_ = 0.0e0
  t129 = t4 * t88
  t130 = 0.1e1 / tau0
  t131 = params.ltafrac * t130
  t136 = t3 * t6
  t138 = t75 * r0
  t140 = t138 * t76 * t130
  t141 = t86 * t136 * t140
  t143 = t25 * t131
  t144 = t129 * t143
  t147 = t95 * t136 * t140
  t150 = t39 * t101 * t143
  vtau_0_ = r0 * (0.66441467000000000000000000000000000000000000000000e-3 * t129 * t25 * t131 * t48 + t84 * (-0.23615790870000000000000000000000000000000000000000e-1 * t141 - 0.11154207160000000000000000000000000000000000000000e-1 * t144 - 0.38199957150000000000000000000000000000000000000000e-2 * t147 - 0.30651995080000000000000000000000000000000000000000e-2 * t150) * t106 - 0.10986933022051895964784337989883743167081987998276e-3 * t59 * t73 * t138 * t24 * t131 * t69 - 0.58482233974552040708313425006184496242808878304904e0 * t114 * t116 * (-0.17489865900000000000000000000000000000000000000000e-1 * t141 - 0.61183289700000000000000000000000000000000000000000e-2 * t144 - 0.11148712965000000000000000000000000000000000000000e-2 * t147 - 0.16775883540000000000000000000000000000000000000000e-2 * t150) * t123)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = t4 * t6
  t8 = 2 ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t11 = r0 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t15 = 6 ** (0.1e1 / 0.3e1)
  t17 = jnp.pi ** 2
  t18 = t17 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t25 = (0.5e1 / 0.9e1 * tau0 * t9 / t12 / r0 * t15 / t19) ** (0.3e1 / 0.5e1 * params.ltafrac)
  t26 = r0 * t25
  t27 = t26 ** (0.1e1 / 0.3e1)
  t29 = 0.1e1 / t27 / t26
  t30 = t25 * params.ltafrac
  t31 = t25 - t30
  t32 = t29 * t31
  t35 = t4 * t6 / t27
  t36 = jnp.sqrt(t35)
  t39 = t35 ** 0.15e1
  t41 = t1 ** 2
  t42 = t3 ** 2
  t43 = t41 * t42
  t44 = t27 ** 2
  t47 = t43 * t5 / t44
  t49 = 0.37978500000000000000000000000000000000000000000000e1 * t36 + 0.89690000000000000000000000000000000000000000000000e0 * t35 + 0.20477500000000000000000000000000000000000000000000e0 * t39 + 0.12323500000000000000000000000000000000000000000000e0 * t47
  t52 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t49
  t53 = jnp.log(t52)
  t58 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t35
  t59 = t49 ** 2
  t60 = 0.1e1 / t59
  t61 = t58 * t60
  t64 = 0.1e1 / t36 * t1 * t3
  t65 = t6 * t29
  t66 = t65 * t31
  t67 = t64 * t66
  t69 = t4 * t66
  t71 = t35 ** 0.5e0
  t73 = t71 * t1 * t3
  t74 = t73 * t66
  t78 = t5 / t44 / t26
  t80 = t43 * t78 * t31
  t82 = -0.63297500000000000000000000000000000000000000000000e0 * t67 - 0.29896666666666666666666666666666666666666666666667e0 * t69 - 0.10238750000000000000000000000000000000000000000000e0 * t74 - 0.82156666666666666666666666666666666666666666666667e-1 * t80
  t83 = 0.1e1 / t52
  t84 = t82 * t83
  t88 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t90 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t88 * f.p.zeta_threshold, 1)
  t96 = (0.2e1 * t90 - 0.2e1) / (0.2e1 * t8 - 0.2e1)
  t97 = t96 * t4
  t102 = 0.51785000000000000000000000000000000000000000000000e1 * t36 + 0.90577500000000000000000000000000000000000000000000e0 * t35 + 0.11003250000000000000000000000000000000000000000000e0 * t39 + 0.12417750000000000000000000000000000000000000000000e0 * t47
  t105 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t102
  t106 = jnp.log(t105)
  t113 = t96 * (0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t35)
  t114 = t102 ** 2
  t115 = 0.1e1 / t114
  t120 = -0.86308333333333333333333333333333333333333333333334e0 * t67 - 0.30192500000000000000000000000000000000000000000000e0 * t69 - 0.55016250000000000000000000000000000000000000000000e-1 * t74 - 0.82785000000000000000000000000000000000000000000000e-1 * t80
  t122 = 0.1e1 / t105
  t123 = t115 * t120 * t122
  t126 = r0 ** 2
  t127 = t25 ** 2
  t128 = t126 * t127
  t130 = 0.1e1 / t27 / t128
  t131 = t31 ** 2
  t136 = 0.1e1 / r0
  t138 = params.ltafrac ** 2
  t141 = t25 * t138 * t136 - t30 * t136
  t154 = t82 ** 2
  t165 = t5 / t44 / t128 * t131
  t166 = 0.1e1 / t36 / t35 * t41 * t42 * t165
  t168 = t6 * t130
  t169 = t168 * t131
  t170 = t64 * t169
  t172 = t65 * t141
  t173 = t64 * t172
  t175 = t4 * t169
  t177 = t4 * t172
  t179 = t35 ** (-0.5e0)
  t182 = t179 * t41 * t42 * t165
  t184 = t73 * t169
  t186 = t73 * t172
  t188 = t43 * t165
  t191 = t43 * t78 * t141
  t197 = t59 ** 2
  t200 = t52 ** 2
  t219 = t120 ** 2
  t239 = t114 ** 2
  t242 = t105 ** 2
  t247 = -0.14764770444444444444444444444444444444444444444444e-2 * t7 * t130 * t131 * t53 + 0.11073577833333333333333333333333333333333333333333e-2 * t7 * t29 * t141 * t53 - 0.35616666666666666666666666666666666666666666666666e-1 * t4 * t65 * t31 * t60 * t84 - 0.20000000000000000000000000000000000000000000000000e1 * t58 / t59 / t49 * t154 * t83 + 0.10000000000000000000000000000000000000000000000000e1 * t61 * (-0.42198333333333333333333333333333333333333333333333e0 * t166 + 0.84396666666666666666666666666666666666666666666666e0 * t170 - 0.63297500000000000000000000000000000000000000000000e0 * t173 + 0.39862222222222222222222222222222222222222222222223e0 * t175 - 0.29896666666666666666666666666666666666666666666667e0 * t177 + 0.68258333333333333333333333333333333333333333333333e-1 * t182 + 0.13651666666666666666666666666666666666666666666667e0 * t184 - 0.10238750000000000000000000000000000000000000000000e0 * t186 + 0.13692777777777777777777777777777777777777777777778e0 * t188 - 0.82156666666666666666666666666666666666666666666667e-1 * t191) * t83 + 0.16081824322151104821330931780901225435013347914188e2 * t58 / t197 * t154 / t200 + 0.24415406715670879921742973310852762593515528885057e-3 * t97 * t168 * t131 * t106 - 0.18311555036753159941307229983139571945136646663793e-3 * t97 * t65 * t141 * t106 + 0.10843580882781524214666447553230042011687479519034e-1 * t96 * t7 * t32 * t123 + 0.11696446794910408141662685001236899248561775660981e1 * t113 / t114 / t102 * t219 * t122 - 0.58482233974552040708313425006184496242808878304903e0 * t113 * t115 * (-0.57538888888888888888888888888888888888888888888889e0 * t166 + 0.11507777777777777777777777777777777777777777777778e1 * t170 - 0.86308333333333333333333333333333333333333333333334e0 * t173 + 0.40256666666666666666666666666666666666666666666667e0 * t175 - 0.30192500000000000000000000000000000000000000000000e0 * t177 + 0.36677500000000000000000000000000000000000000000000e-1 * t182 + 0.73355000000000000000000000000000000000000000000000e-1 * t184 - 0.55016250000000000000000000000000000000000000000000e-1 * t186 + 0.13797500000000000000000000000000000000000000000000e0 * t188 - 0.82785000000000000000000000000000000000000000000000e-1 * t191) * t122 - 0.17315755899375863299672358916972966258900005419821e2 * t113 / t239 * t219 / t242
  v2rho2_0_ = 0.22147155666666666666666666666666666666666666666666e-2 * t7 * t32 * t53 + 0.20000000000000000000000000000000000000000000000000e1 * t61 * t84 - 0.36623110073506319882614459966279143890273293327586e-3 * t97 * t65 * t31 * t106 - 0.11696446794910408141662685001236899248561775660981e1 * t113 * t123 + r0 * t247
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t4 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t2 * f.p.zeta_threshold, 1)
  t7 = 2 ** (0.1e1 / 0.3e1)
  t11 = (0.2e1 * t4 - 0.2e1) / (0.2e1 * t7 - 0.2e1)
  t12 = 3 ** (0.1e1 / 0.3e1)
  t13 = 0.1e1 / jnp.pi
  t14 = t13 ** (0.1e1 / 0.3e1)
  t15 = t12 * t14
  t16 = 4 ** (0.1e1 / 0.3e1)
  t17 = t16 ** 2
  t18 = t7 ** 2
  t20 = r0 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t24 = 6 ** (0.1e1 / 0.3e1)
  t26 = jnp.pi ** 2
  t27 = t26 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t34 = (0.5e1 / 0.9e1 * tau0 * t18 / t21 / r0 * t24 / t28) ** (0.3e1 / 0.5e1 * params.ltafrac)
  t35 = r0 * t34
  t36 = t35 ** (0.1e1 / 0.3e1)
  t39 = t15 * t17 / t36
  t42 = t11 * (0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t39)
  t43 = jnp.sqrt(t39)
  t46 = t39 ** 0.15e1
  t48 = t12 ** 2
  t49 = t14 ** 2
  t50 = t48 * t49
  t51 = t36 ** 2
  t54 = t50 * t16 / t51
  t56 = 0.51785000000000000000000000000000000000000000000000e1 * t43 + 0.90577500000000000000000000000000000000000000000000e0 * t39 + 0.11003250000000000000000000000000000000000000000000e0 * t46 + 0.12417750000000000000000000000000000000000000000000e0 * t54
  t57 = t56 ** 2
  t58 = t57 ** 2
  t59 = 0.1e1 / t58
  t62 = 0.1e1 / t43 * t12 * t14
  t64 = 0.1e1 / t36 / t35
  t65 = t17 * t64
  t66 = t34 * params.ltafrac
  t67 = t34 - t66
  t68 = t65 * t67
  t69 = t62 * t68
  t71 = t15 * t68
  t73 = t39 ** 0.5e0
  t75 = t73 * t12 * t14
  t76 = t75 * t68
  t80 = t16 / t51 / t35
  t82 = t50 * t80 * t67
  t84 = -0.86308333333333333333333333333333333333333333333334e0 * t69 - 0.30192500000000000000000000000000000000000000000000e0 * t71 - 0.55016250000000000000000000000000000000000000000000e-1 * t76 - 0.82785000000000000000000000000000000000000000000000e-1 * t82
  t85 = t84 ** 2
  t86 = t85 * t84
  t90 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t56
  t91 = 0.1e1 / t90
  t96 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t39
  t101 = 0.37978500000000000000000000000000000000000000000000e1 * t43 + 0.89690000000000000000000000000000000000000000000000e0 * t39 + 0.20477500000000000000000000000000000000000000000000e0 * t46 + 0.12323500000000000000000000000000000000000000000000e0 * t54
  t102 = t101 ** 2
  t104 = 0.1e1 / t102 / t101
  t105 = t96 * t104
  t110 = -0.63297500000000000000000000000000000000000000000000e0 * t69 - 0.29896666666666666666666666666666666666666666666667e0 * t71 - 0.10238750000000000000000000000000000000000000000000e0 * t76 - 0.82156666666666666666666666666666666666666666666667e-1 * t82
  t113 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t101
  t114 = 0.1e1 / t113
  t115 = t110 * t114
  t119 = 0.1e1 / t43 / t39 * t48 * t49
  t120 = r0 ** 2
  t121 = t34 ** 2
  t122 = t120 * t121
  t124 = 0.1e1 / t51 / t122
  t125 = t16 * t124
  t126 = t67 ** 2
  t127 = t125 * t126
  t128 = t119 * t127
  t131 = 0.1e1 / t36 / t122
  t132 = t17 * t131
  t133 = t132 * t126
  t134 = t62 * t133
  t136 = 0.1e1 / r0
  t138 = params.ltafrac ** 2
  t141 = t34 * t138 * t136 - t66 * t136
  t142 = t65 * t141
  t143 = t62 * t142
  t145 = t15 * t133
  t147 = t15 * t142
  t149 = t39 ** (-0.5e0)
  t151 = t149 * t48 * t49
  t152 = t151 * t127
  t154 = t75 * t133
  t156 = t75 * t142
  t158 = t50 * t127
  t161 = t50 * t80 * t141
  t163 = -0.42198333333333333333333333333333333333333333333333e0 * t128 + 0.84396666666666666666666666666666666666666666666666e0 * t134 - 0.63297500000000000000000000000000000000000000000000e0 * t143 + 0.39862222222222222222222222222222222222222222222223e0 * t145 - 0.29896666666666666666666666666666666666666666666667e0 * t147 + 0.68258333333333333333333333333333333333333333333333e-1 * t152 + 0.13651666666666666666666666666666666666666666666667e0 * t154 - 0.10238750000000000000000000000000000000000000000000e0 * t156 + 0.13692777777777777777777777777777777777777777777778e0 * t158 - 0.82156666666666666666666666666666666666666666666667e-1 * t161
  t167 = t102 ** 2
  t168 = 0.1e1 / t167
  t169 = t96 * t168
  t170 = t113 ** 2
  t171 = 0.1e1 / t170
  t176 = t11 * t15
  t177 = 0.1e1 / t120
  t182 = -t34 * t138 * params.ltafrac * t177 + t66 * t177
  t183 = jnp.log(t90)
  t190 = t120 * r0 * t121 * t34
  t192 = 0.1e1 / t36 / t190
  t193 = t17 * t192
  t194 = t126 * t67
  t199 = t15 * t65
  t201 = t110 ** 2
  t202 = t201 * t114
  t207 = t201 * t171
  t212 = 0.1e1 / t102
  t221 = t67 * t212
  t222 = t163 * t114
  t226 = t96 * t212
  t228 = t50 * t80 * t182
  t230 = t65 * t182
  t231 = t15 * t230
  t233 = t39 ** (-0.15e1)
  t235 = t120 ** 2
  t237 = t121 ** 2
  t240 = 0.1e1 / t235 / t237 * t194
  t241 = t233 * t13 * t240
  t247 = 0.1e1 / t43 / t54 * t13 * t240 / 0.4e1
  t249 = t62 * t230
  t251 = t193 * t194
  t252 = t15 * t251
  t254 = t15 * t17
  t255 = t131 * t67
  t257 = t254 * t255 * t141
  t259 = t75 * t230
  t264 = t16 / t51 / t190 * t194
  t265 = t50 * t264
  t270 = t50 * t16 * t124 * t67 * t141
  t272 = t151 * t264
  t274 = t67 * t141
  t275 = t125 * t274
  t276 = t151 * t275
  t278 = t75 * t251
  t280 = t132 * t274
  t281 = t75 * t280
  t283 = t119 * t264
  t285 = t119 * t275
  t287 = t62 * t251
  t289 = t62 * t280
  t291 = -0.82156666666666666666666666666666666666666666666667e-1 * t228 - 0.29896666666666666666666666666666666666666666666667e0 * t231 + 0.13651666666666666666666666666666666666666666666667e0 * t241 - 0.25319000000000000000000000000000000000000000000000e1 * t247 - 0.63297500000000000000000000000000000000000000000000e0 * t249 - 0.93011851851851851851851851851851851851851851851854e0 * t252 + 0.11958666666666666666666666666666666666666666666667e1 * t257 - 0.10238750000000000000000000000000000000000000000000e0 * t259 - 0.36514074074074074074074074074074074074074074074075e0 * t265 + 0.41078333333333333333333333333333333333333333333334e0 * t270 - 0.27303333333333333333333333333333333333333333333333e0 * t272 + 0.20477500000000000000000000000000000000000000000000e0 * t276 - 0.31853888888888888888888888888888888888888888888890e0 * t278 + 0.40955000000000000000000000000000000000000000000001e0 * t281 + 0.16879333333333333333333333333333333333333333333333e1 * t283 - 0.12659500000000000000000000000000000000000000000000e1 * t285 - 0.19692555555555555555555555555555555555555555555555e1 * t287 + 0.25319000000000000000000000000000000000000000000000e1 * t289
  t298 = t201 * t110
  t313 = -0.35089340384731224424988055003710697745685326982943e1 * t42 * t59 * t86 * t91 - 0.60000000000000000000000000000000000000000000000000e1 * t105 * t115 * t163 + 0.48245472966453314463992795342703676305040043742564e2 * t169 * t163 * t171 * t110 - 0.18311555036753159941307229983139571945136646663793e-3 * t176 * t65 * t182 * t183 - 0.56969282336565386484066937725323112718202900731800e-3 * t176 * t193 * t194 * t183 + 0.10685000000000000000000000000000000000000000000000e0 * t199 * t67 * t104 * t202 - 0.85917146441092277507960503039464796886558811231548e0 * t199 * t67 * t168 * t207 + 0.71233333333333333333333333333333333333333333333333e-1 * t15 * t132 * t126 * t212 * t115 - 0.53424999999999999999999999999999999999999999999999e-1 * t199 * t141 * t212 * t115 - 0.53424999999999999999999999999999999999999999999999e-1 * t199 * t221 * t222 + 0.10000000000000000000000000000000000000000000000000e1 * t226 * t291 * t114 - 0.96490945932906628927985590685407352610080087485128e2 * t96 / t167 / t101 * t298 * t171 + 0.60000000000000000000000000000000000000000000000000e1 * t169 * t298 * t114 + 0.51725014705706168413145063783413931475389495076352e3 * t96 / t167 / t102 * t298 / t170 / t113
  t315 = jnp.log(t113)
  t319 = 0.1e1 / t57
  t338 = -0.82785000000000000000000000000000000000000000000000e-1 * t228 - 0.30192500000000000000000000000000000000000000000000e0 * t231 + 0.73355000000000000000000000000000000000000000000000e-1 * t241 - 0.34523333333333333333333333333333333333333333333333e1 * t247 - 0.86308333333333333333333333333333333333333333333334e0 * t249 - 0.93932222222222222222222222222222222222222222222223e0 * t252 + 0.12077000000000000000000000000000000000000000000000e1 * t257 - 0.55016250000000000000000000000000000000000000000000e-1 * t259 - 0.36793333333333333333333333333333333333333333333333e0 * t265 + 0.41392500000000000000000000000000000000000000000000e0 * t270 - 0.14671000000000000000000000000000000000000000000000e0 * t272 + 0.11003250000000000000000000000000000000000000000000e0 * t276 - 0.17116166666666666666666666666666666666666666666667e0 * t278 + 0.22006500000000000000000000000000000000000000000000e0 * t281 + 0.23015555555555555555555555555555555555555555555556e1 * t283 - 0.17261666666666666666666666666666666666666666666667e1 * t285 - 0.26851481481481481481481481481481481481481481481482e1 * t287 + 0.34523333333333333333333333333333333333333333333334e1 * t289
  t350 = t90 ** 2
  t359 = 0.1e1 / t350
  t363 = t11 * t254
  t364 = t64 * t67
  t375 = -0.57538888888888888888888888888888888888888888888889e0 * t128 + 0.11507777777777777777777777777777777777777777777778e1 * t134 - 0.86308333333333333333333333333333333333333333333334e0 * t143 + 0.40256666666666666666666666666666666666666666666667e0 * t145 - 0.30192500000000000000000000000000000000000000000000e0 * t147 + 0.36677500000000000000000000000000000000000000000000e-1 * t152 + 0.73355000000000000000000000000000000000000000000000e-1 * t154 - 0.55016250000000000000000000000000000000000000000000e-1 * t156 + 0.13797500000000000000000000000000000000000000000000e0 * t158 - 0.82785000000000000000000000000000000000000000000000e-1 * t161
  t377 = t319 * t375 * t91
  t382 = t59 * t85 * t359
  t387 = 0.1e1 / t57 / t56
  t389 = t387 * t85 * t91
  t393 = t131 * t126
  t395 = t319 * t84 * t91
  t399 = t64 * t141
  t422 = 0.34451131037037037037037037037037037037037037037036e-2 * t254 * t192 * t194 * t315 - 0.58482233974552040708313425006184496242808878304903e0 * t42 * t319 * t338 * t91 + 0.11073577833333333333333333333333333333333333333333e-2 * t254 * t64 * t182 * t315 - 0.10253897021007794930818001372045340355835853271641e4 * t42 / t58 / t57 * t86 / t350 / t90 + 0.10389453539625517979803415350183779755340003251893e3 * t42 / t58 / t56 * t86 * t359 + 0.16265371324172286321999671329845063017531219278551e-1 * t363 * t364 * t377 + 0.48159446095139119802213748237831062407565640073877e0 * t363 * t364 * t382 - 0.32530742648344572643999342659690126035062438557102e-1 * t363 * t364 * t389 - 0.21687161765563048429332895106460084023374959038068e-1 * t363 * t393 * t395 + 0.16265371324172286321999671329845063017531219278551e-1 * t363 * t399 * t395 - 0.51947267698127589899017076750918898776700016259463e2 * t42 * t59 * t375 * t359 * t84 + 0.35089340384731224424988055003710697745685326982943e1 * t42 * t387 * t84 * t91 * t375 - 0.44294311333333333333333333333333333333333333333332e-2 * t254 * t255 * t315 * t141 + 0.73246220147012639765228919932558287780546586655171e-3 * t176 * t132 * t67 * t183 * t141
  v3rho3_0_ = r0 * (t313 + t422) + 0.32530742648344572643999342659690126035062438557102e-1 * t363 * t364 * t395 - 0.60000000000000000000000000000000000000000000000000e1 * t105 * t202 + 0.30000000000000000000000000000000000000000000000000e1 * t226 * t222 + 0.48245472966453314463992795342703676305040043742564e2 * t169 * t207 - 0.17544670192365612212494027501855348872842663491471e1 * t42 * t377 - 0.51947267698127589899017076750918898776700016259464e2 * t42 * t382 - 0.44294311333333333333333333333333333333333333333332e-2 * t254 * t393 * t315 + 0.33220733499999999999999999999999999999999999999999e-2 * t254 * t399 * t315 + 0.35089340384731224424988055003710697745685326982943e1 * t42 * t389 - 0.10685000000000000000000000000000000000000000000000e0 * t199 * t221 * t115 + 0.73246220147012639765228919932558287780546586655172e-3 * t176 * t132 * t126 * t183 - 0.54934665110259479823921689949418715835409939991379e-3 * t176 * t65 * t141 * t183

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t4 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t2 * f.p.zeta_threshold, 1)
  t7 = 2 ** (0.1e1 / 0.3e1)
  t11 = (0.2e1 * t4 - 0.2e1) / (0.2e1 * t7 - 0.2e1)
  t12 = 3 ** (0.1e1 / 0.3e1)
  t13 = 0.1e1 / jnp.pi
  t14 = t13 ** (0.1e1 / 0.3e1)
  t15 = t12 * t14
  t16 = t11 * t15
  t17 = 4 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t19 = r0 ** 2
  t20 = t7 ** 2
  t22 = r0 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t26 = 6 ** (0.1e1 / 0.3e1)
  t28 = jnp.pi ** 2
  t29 = t28 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t36 = (0.5e1 / 0.9e1 * tau0 * t20 / t23 / r0 * t26 / t30) ** (0.3e1 / 0.5e1 * params.ltafrac)
  t37 = t36 ** 2
  t38 = t19 * t37
  t39 = r0 * t36
  t40 = t39 ** (0.1e1 / 0.3e1)
  t42 = 0.1e1 / t40 / t38
  t43 = t18 * t42
  t44 = t36 * params.ltafrac
  t45 = t36 - t44
  t48 = t15 * t18 / t40
  t49 = jnp.sqrt(t48)
  t52 = t48 ** 0.15e1
  t54 = t12 ** 2
  t55 = t14 ** 2
  t56 = t54 * t55
  t57 = t40 ** 2
  t60 = t56 * t17 / t57
  t62 = 0.51785000000000000000000000000000000000000000000000e1 * t49 + 0.90577500000000000000000000000000000000000000000000e0 * t48 + 0.11003250000000000000000000000000000000000000000000e0 * t52 + 0.12417750000000000000000000000000000000000000000000e0 * t60
  t65 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t62
  t66 = jnp.log(t65)
  t68 = 0.1e1 / r0
  t70 = params.ltafrac ** 2
  t71 = t36 * t70
  t73 = -t44 * t68 + t71 * t68
  t79 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t48
  t84 = 0.37978500000000000000000000000000000000000000000000e1 * t49 + 0.89690000000000000000000000000000000000000000000000e0 * t48 + 0.20477500000000000000000000000000000000000000000000e0 * t52 + 0.12323500000000000000000000000000000000000000000000e0 * t60
  t85 = t84 ** 2
  t86 = t85 * t84
  t87 = 0.1e1 / t86
  t88 = t79 * t87
  t91 = 0.1e1 / t49 * t12 * t14
  t93 = 0.1e1 / t40 / t39
  t94 = t18 * t93
  t95 = t94 * t45
  t96 = t91 * t95
  t98 = t15 * t95
  t100 = t48 ** 0.5e0
  t102 = t100 * t12 * t14
  t103 = t102 * t95
  t107 = t17 / t57 / t39
  t109 = t56 * t107 * t45
  t111 = -0.63297500000000000000000000000000000000000000000000e0 * t96 - 0.29896666666666666666666666666666666666666666666667e0 * t98 - 0.10238750000000000000000000000000000000000000000000e0 * t103 - 0.82156666666666666666666666666666666666666666666667e-1 * t109
  t114 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t84
  t115 = 0.1e1 / t114
  t116 = t111 * t115
  t120 = 0.1e1 / t49 / t48 * t54 * t55
  t122 = 0.1e1 / t57 / t38
  t123 = t17 * t122
  t124 = t45 ** 2
  t125 = t123 * t124
  t126 = t120 * t125
  t128 = t43 * t124
  t129 = t91 * t128
  t131 = t94 * t73
  t132 = t91 * t131
  t134 = t15 * t128
  t136 = t15 * t131
  t138 = t48 ** (-0.5e0)
  t140 = t138 * t54 * t55
  t141 = t140 * t125
  t143 = t102 * t128
  t145 = t102 * t131
  t147 = t56 * t125
  t150 = t56 * t107 * t73
  t152 = -0.42198333333333333333333333333333333333333333333333e0 * t126 + 0.84396666666666666666666666666666666666666666666666e0 * t129 - 0.63297500000000000000000000000000000000000000000000e0 * t132 + 0.39862222222222222222222222222222222222222222222223e0 * t134 - 0.29896666666666666666666666666666666666666666666667e0 * t136 + 0.68258333333333333333333333333333333333333333333333e-1 * t141 + 0.13651666666666666666666666666666666666666666666667e0 * t143 - 0.10238750000000000000000000000000000000000000000000e0 * t145 + 0.13692777777777777777777777777777777777777777777778e0 * t147 - 0.82156666666666666666666666666666666666666666666667e-1 * t150
  t153 = t116 * t152
  t158 = t11 * (0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t48)
  t159 = t62 ** 2
  t160 = t159 * t62
  t161 = 0.1e1 / t160
  t166 = -0.86308333333333333333333333333333333333333333333334e0 * t96 - 0.30192500000000000000000000000000000000000000000000e0 * t98 - 0.55016250000000000000000000000000000000000000000000e-1 * t103 - 0.82785000000000000000000000000000000000000000000000e-1 * t109
  t168 = 0.1e1 / t65
  t179 = -0.57538888888888888888888888888888888888888888888889e0 * t126 + 0.11507777777777777777777777777777777777777777777778e1 * t129 - 0.86308333333333333333333333333333333333333333333334e0 * t132 + 0.40256666666666666666666666666666666666666666666667e0 * t134 - 0.30192500000000000000000000000000000000000000000000e0 * t136 + 0.36677500000000000000000000000000000000000000000000e-1 * t141 + 0.73355000000000000000000000000000000000000000000000e-1 * t143 - 0.55016250000000000000000000000000000000000000000000e-1 * t145 + 0.13797500000000000000000000000000000000000000000000e0 * t147 - 0.82785000000000000000000000000000000000000000000000e-1 * t150
  t180 = t168 * t179
  t184 = t15 * t18
  t185 = t42 * t45
  t186 = jnp.log(t114)
  t187 = t186 * t73
  t191 = t159 ** 2
  t192 = 0.1e1 / t191
  t194 = t65 ** 2
  t195 = 0.1e1 / t194
  t196 = t195 * t166
  t200 = t85 ** 2
  t201 = 0.1e1 / t200
  t202 = t79 * t201
  t203 = t114 ** 2
  t204 = 0.1e1 / t203
  t205 = t152 * t204
  t206 = t205 * t111
  t209 = 0.1e1 / t19
  t212 = t36 * t70 * params.ltafrac
  t214 = -t212 * t209 + t44 * t209
  t215 = t214 * t66
  t219 = t19 * r0
  t221 = t219 * t37 * t36
  t223 = 0.1e1 / t40 / t221
  t224 = t18 * t223
  t225 = t124 * t45
  t230 = t15 * t94
  t231 = t45 * t87
  t232 = t111 ** 2
  t233 = t232 * t115
  t237 = t45 * t201
  t238 = t232 * t204
  t242 = t15 * t43
  t243 = 0.1e1 / t85
  t244 = t124 * t243
  t248 = t73 * t243
  t252 = t45 * t243
  t253 = t152 * t115
  t257 = t166 ** 2
  t258 = t257 * t166
  t260 = t192 * t258 * t168
  t263 = 0.29298488058805055906091567973023315112218634662068e-2 * t16 * t43 * t45 * t66 * t73 - 0.24000000000000000000000000000000000000000000000000e2 * t88 * t153 + 0.14035736153892489769995222001484279098274130793177e2 * t158 * t161 * t166 * t180 - 0.17717724533333333333333333333333333333333333333333e-1 * t184 * t185 * t187 - 0.20778907079251035959606830700367559510680006503785e3 * t158 * t192 * t179 * t196 + 0.19298189186581325785597118137081470522016017497026e3 * t202 * t206 - 0.73246220147012639765228919932558287780546586655172e-3 * t16 * t94 * t215 - 0.22787712934626154593626775090129245087281160292720e-2 * t16 * t224 * t225 * t66 + 0.42740000000000000000000000000000000000000000000000e0 * t230 * t231 * t233 - 0.34366858576436911003184201215785918754623524492620e1 * t230 * t237 * t238 + 0.28493333333333333333333333333333333333333333333334e0 * t242 * t244 * t116 - 0.21370000000000000000000000000000000000000000000000e0 * t230 * t248 * t116 - 0.21370000000000000000000000000000000000000000000000e0 * t230 * t252 * t253 - 0.14035736153892489769995222001484279098274130793177e2 * t158 * t260
  t264 = t223 * t225
  t268 = t11 * t184
  t269 = t93 * t45
  t270 = 0.1e1 / t159
  t272 = t270 * t179 * t168
  t276 = t192 * t257
  t277 = t276 * t195
  t282 = t161 * t257 * t168
  t286 = t42 * t124
  t288 = t270 * t166 * t168
  t292 = t93 * t73
  t297 = t56 * t107 * t214
  t299 = t94 * t214
  t300 = t15 * t299
  t302 = t48 ** (-0.15e1)
  t303 = t302 * t13
  t304 = t19 ** 2
  t305 = 0.1e1 / t304
  t306 = t37 ** 2
  t307 = 0.1e1 / t306
  t308 = t305 * t307
  t309 = t308 * t225
  t310 = t303 * t309
  t315 = 0.1e1 / t49 / t60 * t13 / 0.4e1
  t316 = t315 * t309
  t318 = t56 * t17
  t321 = t318 * t122 * t45 * t73
  t323 = t91 * t299
  t325 = t224 * t225
  t326 = t15 * t325
  t329 = t184 * t185 * t73
  t331 = t102 * t299
  t334 = 0.1e1 / t57 / t221
  t335 = t17 * t334
  t336 = t335 * t225
  t337 = t56 * t336
  t339 = t140 * t336
  t341 = t45 * t73
  t342 = t123 * t341
  t343 = t140 * t342
  t345 = t102 * t325
  t347 = t43 * t341
  t348 = t102 * t347
  t350 = t120 * t336
  t352 = t120 * t342
  t354 = t91 * t325
  t356 = t91 * t347
  t358 = -0.82785000000000000000000000000000000000000000000000e-1 * t297 - 0.30192500000000000000000000000000000000000000000000e0 * t300 + 0.73355000000000000000000000000000000000000000000000e-1 * t310 - 0.34523333333333333333333333333333333333333333333333e1 * t316 + 0.41392500000000000000000000000000000000000000000000e0 * t321 - 0.86308333333333333333333333333333333333333333333334e0 * t323 - 0.93932222222222222222222222222222222222222222222223e0 * t326 + 0.12077000000000000000000000000000000000000000000000e1 * t329 - 0.55016250000000000000000000000000000000000000000000e-1 * t331 - 0.36793333333333333333333333333333333333333333333333e0 * t337 - 0.14671000000000000000000000000000000000000000000000e0 * t339 + 0.11003250000000000000000000000000000000000000000000e0 * t343 - 0.17116166666666666666666666666666666666666666666667e0 * t345 + 0.22006500000000000000000000000000000000000000000000e0 * t348 + 0.23015555555555555555555555555555555555555555555556e1 * t350 - 0.17261666666666666666666666666666666666666666666667e1 * t352 - 0.26851481481481481481481481481481481481481481481482e1 * t354 + 0.34523333333333333333333333333333333333333333333334e1 * t356
  t360 = t270 * t358 * t168
  t363 = t93 * t214
  t367 = t79 * t243
  t386 = -0.82156666666666666666666666666666666666666666666667e-1 * t297 - 0.29896666666666666666666666666666666666666666666667e0 * t300 + 0.13651666666666666666666666666666666666666666666667e0 * t310 - 0.25319000000000000000000000000000000000000000000000e1 * t316 + 0.41078333333333333333333333333333333333333333333334e0 * t321 - 0.63297500000000000000000000000000000000000000000000e0 * t323 - 0.93011851851851851851851851851851851851851851851854e0 * t326 + 0.11958666666666666666666666666666666666666666666667e1 * t329 - 0.10238750000000000000000000000000000000000000000000e0 * t331 - 0.36514074074074074074074074074074074074074074074075e0 * t337 - 0.27303333333333333333333333333333333333333333333333e0 * t339 + 0.20477500000000000000000000000000000000000000000000e0 * t343 - 0.31853888888888888888888888888888888888888888888890e0 * t345 + 0.40955000000000000000000000000000000000000000000001e0 * t348 + 0.16879333333333333333333333333333333333333333333333e1 * t350 - 0.12659500000000000000000000000000000000000000000000e1 * t352 - 0.19692555555555555555555555555555555555555555555555e1 * t354 + 0.25319000000000000000000000000000000000000000000000e1 * t356
  t387 = t386 * t115
  t391 = 0.1e1 / t200 / t84
  t392 = t79 * t391
  t393 = t232 * t111
  t394 = t393 * t204
  t397 = t393 * t115
  t401 = 0.1e1 / t200 / t85
  t402 = t79 * t401
  t404 = 0.1e1 / t203 / t114
  t405 = t393 * t404
  t414 = t179 * t195
  t420 = t166 * t168
  t449 = 0.1e1 / t191 / t159
  t452 = 0.1e1 / t194 / t65
  t457 = t42 * t214
  t466 = t223 * t124
  t474 = 0.1e1 / t191 / t62
  t483 = -0.13012297059337829057599737063876050414024975422841e0 * t268 * t269 * t161 * t180 * t166 + 0.19263778438055647920885499295132424963026256029551e1 * t268 * t269 * t192 * t414 * t166 - 0.86748647062252193717331580425840336093499836152272e-1 * t268 * t185 * t270 * t420 * t73 + 0.97661626862683519686971893243411050374062115540228e-3 * t16 * t43 * t215 * t45 + 0.28493333333333333333333333333333333333333333333333e0 * t242 * t248 * t116 * t45 - 0.34181569401939231890440162635193867630921740439080e-2 * t16 * t224 * t124 * t66 * t73 + 0.42740000000000000000000000000000000000000000000000e0 * t230 * t231 * t153 - 0.34366858576436911003184201215785918754623524492620e1 * t230 * t237 * t206 + 0.46785787179641632566650740004947596994247102643924e1 * t158 * t161 * t358 * t420 - 0.61523382126046769584908008232272042135015119629847e4 * t158 * t449 * t257 * t452 * t179 - 0.59059081777777777777777777777777777777777777777776e-2 * t184 * t457 * t186 * t45 - 0.69263023597503453198689435667891865035600021679284e2 * t158 * t192 * t358 * t196 + 0.20670678622222222222222222222222222222222222222222e-1 * t184 * t466 * t187 - 0.21053604230838734654992833002226418647411196189766e2 * t158 * t276 * t180 + 0.62336721237753107878820492101102678532040019511357e3 * t158 * t474 * t257 * t414 + 0.21370000000000000000000000000000000000000000000000e0 * t230 * t73 * t87 * t233
  t484 = 0.1e1 / t219
  t488 = t70 ** 2
  t493 = t36 * t488 * t484 + 0.2e1 * t212 * t484 - 0.2e1 * t44 * t484 - t71 * t484
  t522 = t304 * t306
  t524 = 0.1e1 / t40 / t522
  t525 = t18 * t524
  t526 = t124 ** 2
  t540 = t73 ** 2
  t559 = -0.18311555036753159941307229983139571945136646663793e-3 * t16 * t94 * t493 * t66 - 0.17183429288218455501592100607892959377311762246310e1 * t230 * t73 * t201 * t238 - 0.42740000000000000000000000000000000000000000000000e0 * t230 * t237 * t397 - 0.10685000000000000000000000000000000000000000000000e0 * t230 * t248 * t253 + 0.68733717152873822006368402431571837509247048985239e1 * t230 * t45 * t391 * t394 - 0.71233333333333333333333333333333333333333333333332e-1 * t230 * t252 * t387 - 0.36845452142031360632963667101718523854302450326054e2 * t230 * t45 * t401 * t405 + 0.14246666666666666666666666666666666666666666666666e0 * t242 * t244 * t253 + 0.18989760778855128828022312575107704239400966910600e-2 * t16 * t525 * t526 * t66 - 0.71233333333333333333333333333333333333333333333332e-1 * t230 * t214 * t243 * t116 - 0.22161481481481481481481481481481481481481481481481e0 * t15 * t224 * t225 * t243 * t116 + 0.73246220147012639765228919932558287780546586655171e-3 * t16 * t43 * t540 * t66 - 0.28493333333333333333333333333333333333333333333334e0 * t242 * t124 * t87 * t233 + 0.22911239050957940668789467477190612503082349661746e1 * t242 * t124 * t201 * t238 - 0.57894567559743977356791354411244411566048052491077e3 * t392 * t205 * t232 + 0.36000000000000000000000000000000000000000000000000e2 * t202 * t233 * t152
  t576 = t474 * t258 * t195
  t581 = t449 * t258 * t452
  t612 = t257 ** 2
  t617 = -0.80000000000000000000000000000000000000000000000000e1 * t88 * t116 * t386 + 0.31035008823423701047887038270048358885233697045812e4 * t402 * t152 * t404 * t232 + 0.64327297288604419285323727123604901740053391656752e2 * t202 * t386 * t204 * t111 + 0.21687161765563048429332895106460084023374959038068e-1 * t268 * t269 * t360 - 0.38527556876111295841770998590264849926052512059102e1 * t268 * t269 * t576 + 0.38024868119570572868450088421334803819557955882337e2 * t268 * t269 * t581 + 0.13012297059337829057599737063876050414024975422841e0 * t268 * t269 * t260 + 0.67471169937307261780146784775653594739388761451767e-1 * t268 * t264 * t288 + 0.86748647062252193717331580425840336093499836152272e-1 * t268 * t286 * t282 - 0.43374323531126096858665790212920168046749918076136e-1 * t268 * t286 * t272 - 0.12842518958703765280590332863421616642017504019700e1 * t268 * t286 * t277 + 0.32530742648344572643999342659690126035062438557102e-1 * t268 * t292 * t272 + 0.96318892190278239604427496475662124815131280147753e0 * t268 * t292 * t277 - 0.65061485296689145287998685319380252070124877114204e-1 * t268 * t292 * t282 + 0.21687161765563048429332895106460084023374959038068e-1 * t268 * t363 * t288 + 0.14035736153892489769995222001484279098274130793177e2 * t158 * t474 * t612 * t168
  t637 = t526 * t12 * t14 * t18 * t93
  t638 = 0.1e1 / t49 / t68 * t36 * t308 * t637 / 0.48e2
  t640 = t48 ** (-0.25e1)
  t643 = t640 * t13 * t308 * t637
  t645 = t124 * t73
  t646 = t335 * t645
  t647 = t120 * t646
  t649 = t224 * t645
  t650 = t91 * t649
  t652 = t214 * t45
  t653 = t43 * t652
  t654 = t102 * t653
  t656 = t123 * t652
  t657 = t140 * t656
  t659 = t140 * t646
  t661 = t102 * t649
  t663 = t91 * t653
  t665 = t120 * t656
  t668 = 0.1e1 / t304 / r0
  t672 = t668 / t306 / t36 * t526
  t673 = t315 * t672
  t675 = t525 * t526
  t676 = t15 * t675
  t678 = t43 * t540
  t679 = t15 * t678
  t684 = t17 / t57 / t522 * t526
  t685 = t56 * t684
  t688 = t56 * t107 * t493
  t691 = t668 * t307 * t225
  t692 = t303 * t691
  t694 = t315 * t691
  t696 = t123 * t540
  t697 = t56 * t696
  t699 = t303 * t672
  t701 = -0.21099166666666666666666666666666666666666666666667e1 * t638 + 0.68258333333333333333333333333333333333333333333335e-1 * t643 + 0.10127600000000000000000000000000000000000000000000e2 * t647 - 0.11815533333333333333333333333333333333333333333333e2 * t650 + 0.54606666666666666666666666666666666666666666666668e0 * t654 + 0.27303333333333333333333333333333333333333333333333e0 * t657 - 0.16382000000000000000000000000000000000000000000000e1 * t659 - 0.19112333333333333333333333333333333333333333333334e1 * t661 + 0.33758666666666666666666666666666666666666666666667e1 * t663 - 0.16879333333333333333333333333333333333333333333333e1 * t665 + 0.10127600000000000000000000000000000000000000000000e2 * t673 + 0.31003950617283950617283950617283950617283950617285e1 * t676 + 0.11958666666666666666666666666666666666666666666667e1 * t679 + 0.13388493827160493827160493827160493827160493827161e1 * t685 - 0.82156666666666666666666666666666666666666666666667e-1 * t688 - 0.54606666666666666666666666666666666666666666666668e0 * t692 + 0.10127600000000000000000000000000000000000000000000e2 * t694 + 0.41078333333333333333333333333333333333333333333334e0 * t697 - 0.54606666666666666666666666666666666666666666666666e0 * t699
  t702 = t94 * t493
  t703 = t15 * t702
  t705 = t120 * t696
  t707 = t91 * t675
  t709 = t91 * t678
  t711 = t140 * t684
  t713 = t140 * t696
  t715 = t102 * t675
  t719 = t318 * t334 * t124 * t73
  t723 = t307 * t124 * t73
  t724 = t315 * t305 * t723
  t728 = t307 * t225 * params.ltafrac
  t729 = t315 * t668 * t728
  t731 = t102 * t678
  t733 = t120 * t684
  t735 = t91 * t702
  t738 = t184 * t466 * t73
  t740 = t102 * t702
  t744 = t318 * t122 * t214 * t45
  t747 = t184 * t457 * t45
  t750 = t303 * t305 * t723
  t753 = t303 * t668 * t728
  t755 = -0.29896666666666666666666666666666666666666666666667e0 * t703 - 0.12659500000000000000000000000000000000000000000000e1 * t705 + 0.65641851851851851851851851851851851851851851851850e1 * t707 + 0.25319000000000000000000000000000000000000000000000e1 * t709 + 0.12134814814814814814814814814814814814814814814815e1 * t711 + 0.20477500000000000000000000000000000000000000000000e0 * t713 + 0.10617962962962962962962962962962962962962962962963e1 * t715 - 0.21908444444444444444444444444444444444444444444444e1 * t719 - 0.15191400000000000000000000000000000000000000000000e2 * t724 - 0.10127600000000000000000000000000000000000000000000e2 * t729 + 0.40955000000000000000000000000000000000000000000001e0 * t731 - 0.75019259259259259259259259259259259259259259259258e1 * t733 - 0.63297500000000000000000000000000000000000000000000e0 * t735 - 0.55807111111111111111111111111111111111111111111112e1 * t738 - 0.10238750000000000000000000000000000000000000000000e0 * t740 + 0.54771111111111111111111111111111111111111111111112e0 * t744 + 0.15944888888888888888888888888888888888888888888889e1 * t747 + 0.81910000000000000000000000000000000000000000000001e0 * t750 + 0.54606666666666666666666666666666666666666666666668e0 * t753
  t760 = t232 ** 2
  t764 = t152 ** 2
  t780 = t200 ** 2
  t783 = t203 ** 2
  t807 = -0.28769444444444444444444444444444444444444444444444e1 * t638 + 0.36677500000000000000000000000000000000000000000000e-1 * t643 + 0.13809333333333333333333333333333333333333333333334e2 * t647 - 0.16110888888888888888888888888888888888888888888889e2 * t650 + 0.29342000000000000000000000000000000000000000000000e0 * t654 + 0.14671000000000000000000000000000000000000000000000e0 * t657 - 0.88026000000000000000000000000000000000000000000000e0 * t659 - 0.10269700000000000000000000000000000000000000000000e1 * t661 + 0.46031111111111111111111111111111111111111111111112e1 * t663 - 0.23015555555555555555555555555555555555555555555556e1 * t665 + 0.13809333333333333333333333333333333333333333333334e2 * t673 + 0.31310740740740740740740740740740740740740740740741e1 * t676 + 0.12077000000000000000000000000000000000000000000000e1 * t679 + 0.13490888888888888888888888888888888888888888888889e1 * t685 - 0.82785000000000000000000000000000000000000000000000e-1 * t688 - 0.29342000000000000000000000000000000000000000000000e0 * t692 + 0.13809333333333333333333333333333333333333333333333e2 * t694 + 0.41392500000000000000000000000000000000000000000000e0 * t697 - 0.29342000000000000000000000000000000000000000000000e0 * t699
  t827 = -0.30192500000000000000000000000000000000000000000000e0 * t703 - 0.17261666666666666666666666666666666666666666666667e1 * t705 + 0.89504938271604938271604938271604938271604938271607e1 * t707 + 0.34523333333333333333333333333333333333333333333334e1 * t709 + 0.65204444444444444444444444444444444444444444444445e0 * t711 + 0.11003250000000000000000000000000000000000000000000e0 * t713 + 0.57053888888888888888888888888888888888888888888890e0 * t715 - 0.22076000000000000000000000000000000000000000000000e1 * t719 - 0.20714000000000000000000000000000000000000000000000e2 * t724 - 0.13809333333333333333333333333333333333333333333333e2 * t729 + 0.22006500000000000000000000000000000000000000000000e0 * t731 - 0.10229135802469135802469135802469135802469135802469e2 * t733 - 0.86308333333333333333333333333333333333333333333334e0 * t735 - 0.56359333333333333333333333333333333333333333333334e1 * t738 - 0.55016250000000000000000000000000000000000000000000e-1 * t740 + 0.55190000000000000000000000000000000000000000000000e0 * t744 + 0.16102666666666666666666666666666666666666666666667e1 * t747 + 0.44013000000000000000000000000000000000000000000000e0 * t750 + 0.29342000000000000000000000000000000000000000000000e0 * t753
  t833 = t191 ** 2
  t836 = t194 ** 2
  t847 = t179 ** 2
  t864 = 0.11073577833333333333333333333333333333333333333333e-2 * t184 * t93 * t493 * t186 - 0.11483710345679012345679012345679012345679012345679e-1 * t184 * t524 * t526 * t186 + 0.10000000000000000000000000000000000000000000000000e1 * t367 * (t701 + t755) * t115 + 0.57894567559743977356791354411244411566048052491077e3 * t402 * t760 * t204 + 0.48245472966453314463992795342703676305040043742564e2 * t202 * t764 * t204 - 0.62070017646847402095774076540096717770467394091622e4 * t79 / t200 / t86 * t760 * t404 - 0.24000000000000000000000000000000000000000000000000e2 * t392 * t760 * t115 - 0.60000000000000000000000000000000000000000000000000e1 * t88 * t764 * t115 + 0.24954977986735470914321699422701391789612506067521e5 * t79 / t780 * t760 / t783 - 0.58482233974552040708313425006184496242808878304903e0 * t158 * t270 * (t807 + t827) * t168 - 0.91080982599109921218848830805163797795664001346962e5 * t158 / t833 * t612 / t836 + 0.12304676425209353916981601646454408427003023925970e5 * t158 / t191 / t160 * t612 * t452 - 0.51947267698127589899017076750918898776700016259463e2 * t158 * t192 * t847 * t195 + 0.35089340384731224424988055003710697745685326982943e1 * t158 * t161 * t847 * t168 - 0.62336721237753107878820492101102678532040019511358e3 * t158 * t449 * t612 * t195 - 0.44294311333333333333333333333333333333333333333332e-2 * t184 * t42 * t540 * t186
  t872 = 0.13780452414814814814814814814814814814814814814815e-1 * t184 * t264 * t186 + 0.65061485296689145287998685319380252070124877114204e-1 * t268 * t269 * t272 + 0.19263778438055647920885499295132424963026256029551e1 * t268 * t269 * t277 - 0.13012297059337829057599737063876050414024975422841e0 * t268 * t269 * t282 - 0.86748647062252193717331580425840336093499836152272e-1 * t268 * t286 * t288 + 0.65061485296689145287998685319380252070124877114204e-1 * t268 * t292 * t288 - 0.23392893589820816283325370002473798497123551321961e1 * t158 * t360 + 0.44294311333333333333333333333333333333333333333332e-2 * t184 * t363 * t186 + 0.40000000000000000000000000000000000000000000000000e1 * t367 * t387 - 0.38596378373162651571194236274162941044032034994052e3 * t392 * t394 + 0.24000000000000000000000000000000000000000000000000e2 * t202 * t397 + 0.20690005882282467365258025513365572590155798030541e4 * t402 * t405 + r0 * (t483 + t559 + t617 + t864) - 0.41015588084031179723272005488181361423343413086566e4 * t158 * t581 + 0.41557814158502071919213661400735119021360013007572e3 * t158 * t576
  v4rho4_0_ = t263 + t872

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = t4 * t6
  t8 = r0 ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t13 = 6 ** (0.1e1 / 0.3e1)
  t14 = jnp.pi ** 2
  t15 = t14 ** (0.1e1 / 0.3e1)
  t16 = t15 ** 2
  t18 = t13 / t16
  t21 = 0.3e1 / 0.5e1 * params.ltafrac
  t22 = (0.5e1 / 0.9e1 * tau0 / t9 / r0 * t18) ** t21
  t23 = r0 * t22
  t24 = r1 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t31 = (0.5e1 / 0.9e1 * tau1 / t25 / r1 * t18) ** t21
  t32 = r1 * t31
  t33 = t23 + t32
  t34 = t33 ** (0.1e1 / 0.3e1)
  t36 = 0.1e1 / t34 / t33
  t37 = t22 * params.ltafrac
  t38 = t22 - t37
  t39 = t36 * t38
  t42 = t4 * t6 / t34
  t43 = jnp.sqrt(t42)
  t46 = t42 ** 0.15e1
  t48 = t1 ** 2
  t49 = t3 ** 2
  t50 = t48 * t49
  t51 = t34 ** 2
  t54 = t50 * t5 / t51
  t56 = 0.37978500000000000000000000000000000000000000000000e1 * t43 + 0.89690000000000000000000000000000000000000000000000e0 * t42 + 0.20477500000000000000000000000000000000000000000000e0 * t46 + 0.12323500000000000000000000000000000000000000000000e0 * t54
  t59 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t56
  t60 = jnp.log(t59)
  t62 = t7 * t39 * t60
  t65 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t42
  t66 = t56 ** 2
  t67 = 0.1e1 / t66
  t68 = t65 * t67
  t71 = 0.1e1 / t43 * t1 * t3
  t72 = t6 * t36
  t73 = t72 * t38
  t74 = t71 * t73
  t76 = t4 * t73
  t78 = t42 ** 0.5e0
  t80 = t78 * t1 * t3
  t81 = t80 * t73
  t85 = t5 / t51 / t33
  t87 = t50 * t85 * t38
  t89 = -0.63297500000000000000000000000000000000000000000000e0 * t74 - 0.29896666666666666666666666666666666666666666666667e0 * t76 - 0.10238750000000000000000000000000000000000000000000e0 * t81 - 0.82156666666666666666666666666666666666666666666667e-1 * t87
  t90 = 0.1e1 / t59
  t91 = t89 * t90
  t92 = t68 * t91
  t94 = t23 - t32
  t95 = t94 ** 2
  t96 = t95 * t94
  t97 = t33 ** 2
  t98 = t97 ** 2
  t99 = 0.1e1 / t98
  t100 = t96 * t99
  t101 = 0.1e1 / t33
  t102 = t94 * t101
  t103 = 0.1e1 + t102
  t104 = t103 <= f.p.zeta_threshold
  t105 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t106 = t105 * f.p.zeta_threshold
  t107 = t103 ** (0.1e1 / 0.3e1)
  t109 = f.my_piecewise3(t104, t106, t107 * t103)
  t110 = 0.1e1 - t102
  t111 = t110 <= f.p.zeta_threshold
  t112 = t110 ** (0.1e1 / 0.3e1)
  t114 = f.my_piecewise3(t111, t106, t112 * t110)
  t115 = t109 + t114 - 0.2e1
  t116 = t100 * t115
  t117 = 2 ** (0.1e1 / 0.3e1)
  t120 = 0.1e1 / (0.2e1 * t117 - 0.2e1)
  t122 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t42
  t127 = 0.70594500000000000000000000000000000000000000000000e1 * t43 + 0.15494250000000000000000000000000000000000000000000e1 * t42 + 0.42077500000000000000000000000000000000000000000000e0 * t46 + 0.15629250000000000000000000000000000000000000000000e0 * t54
  t130 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t127
  t131 = jnp.log(t130)
  t137 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t42
  t142 = 0.51785000000000000000000000000000000000000000000000e1 * t43 + 0.90577500000000000000000000000000000000000000000000e0 * t42 + 0.11003250000000000000000000000000000000000000000000e0 * t46 + 0.12417750000000000000000000000000000000000000000000e0 * t54
  t145 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t142
  t146 = jnp.log(t145)
  t147 = t137 * t146
  t149 = -0.31090e-1 * t122 * t131 + 0.62182e-1 * t65 * t60 - 0.19751789702565206228825776161588751761046270558698e-1 * t147
  t150 = t120 * t149
  t151 = t150 * t38
  t152 = t116 * t151
  t154 = t95 ** 2
  t156 = 0.1e1 / t98 / t33
  t157 = t154 * t156
  t158 = t157 * t115
  t159 = t158 * t151
  t161 = t154 * t99
  t163 = 0.1e1 / t97
  t164 = t94 * t163
  t166 = t38 * t101 - t164 * t38
  t169 = f.my_piecewise3(t104, 0, 0.4e1 / 0.3e1 * t107 * t166)
  t170 = -t166
  t173 = f.my_piecewise3(t111, 0, 0.4e1 / 0.3e1 * t112 * t170)
  t174 = t169 + t173
  t175 = t174 * t120
  t177 = t161 * t175 * t149
  t179 = t115 * t120
  t183 = t127 ** 2
  t184 = 0.1e1 / t183
  t185 = t122 * t184
  t190 = -0.11765750000000000000000000000000000000000000000000e1 * t74 - 0.51647500000000000000000000000000000000000000000000e0 * t76 - 0.21038750000000000000000000000000000000000000000000e0 * t81 - 0.10419500000000000000000000000000000000000000000000e0 * t87
  t191 = 0.1e1 / t130
  t192 = t190 * t191
  t195 = 0.11073577833333333333333333333333333333333333333333e-2 * t62
  t196 = 0.10000000000000000000000000000000000000000000000000e1 * t92
  t200 = t142 ** 2
  t201 = 0.1e1 / t200
  t202 = t137 * t201
  t207 = -0.86308333333333333333333333333333333333333333333334e0 * t74 - 0.30192500000000000000000000000000000000000000000000e0 * t76 - 0.55016250000000000000000000000000000000000000000000e-1 * t81 - 0.82785000000000000000000000000000000000000000000000e-1 * t87
  t208 = 0.1e1 / t145
  t209 = t207 * t208
  t212 = 0.53236443333333333333333333333333333333333333333332e-3 * t7 * t39 * t131 + 0.99999999999999999999999999999999999999999999999999e0 * t185 * t192 - t195 - t196 + 0.18311555036753159941307229983139571945136646663793e-3 * t7 * t39 * t146 + 0.58482233974552040708313425006184496242808878304903e0 * t202 * t209
  t214 = t161 * t179 * t212
  t216 = t175 * t147
  t218 = t179 * t4
  t219 = t38 * t146
  t220 = t72 * t219
  t221 = t218 * t220
  t223 = t179 * t137
  t225 = t201 * t207 * t208
  t226 = t223 * t225
  t228 = r0 + r1
  t232 = 0.1e1 / t43 / t42 * t48 * t49
  t234 = 0.1e1 / t51 / t97
  t235 = t5 * t234
  t236 = t38 ** 2
  t237 = t235 * t236
  t238 = t232 * t237
  t241 = 0.1e1 / t34 / t97
  t242 = t6 * t241
  t243 = t242 * t236
  t244 = t71 * t243
  t246 = 0.1e1 / r0
  t248 = params.ltafrac ** 2
  t251 = t22 * t248 * t246 - t37 * t246
  t252 = t72 * t251
  t253 = t71 * t252
  t255 = t4 * t243
  t257 = t4 * t252
  t259 = t42 ** (-0.5e0)
  t261 = t259 * t48 * t49
  t262 = t261 * t237
  t264 = t80 * t243
  t266 = t80 * t252
  t268 = t50 * t237
  t271 = t50 * t85 * t251
  t276 = 0.10000000000000000000000000000000000000000000000000e1 * t68 * (-0.42198333333333333333333333333333333333333333333333e0 * t238 + 0.84396666666666666666666666666666666666666666666666e0 * t244 - 0.63297500000000000000000000000000000000000000000000e0 * t253 + 0.39862222222222222222222222222222222222222222222223e0 * t255 - 0.29896666666666666666666666666666666666666666666667e0 * t257 + 0.68258333333333333333333333333333333333333333333333e-1 * t262 + 0.13651666666666666666666666666666666666666666666667e0 * t264 - 0.10238750000000000000000000000000000000000000000000e0 * t266 + 0.13692777777777777777777777777777777777777777777778e0 * t268 - 0.82156666666666666666666666666666666666666666666667e-1 * t271) * t90
  t277 = t66 ** 2
  t279 = t65 / t277
  t280 = t89 ** 2
  t281 = t59 ** 2
  t282 = 0.1e1 / t281
  t285 = 0.16081824322151104821330931780901225435013347914188e2 * t279 * t280 * t282
  t286 = t150 * t251
  t289 = t157 * t174
  t292 = t120 * t212
  t293 = t292 * t38
  t296 = t241 * t236
  t299 = 0.14764770444444444444444444444444444444444444444444e-2 * t7 * t296 * t60
  t300 = t36 * t251
  t303 = 0.11073577833333333333333333333333333333333333333333e-2 * t7 * t300 * t60
  t306 = t175 * t137
  t309 = t179 * t7
  t322 = t4 * t72
  t323 = t38 * t184
  t329 = t122 / t183 / t127
  t330 = t190 ** 2
  t348 = t183 ** 2
  t350 = t122 / t348
  t351 = t130 ** 2
  t352 = 0.1e1 / t351
  t356 = t38 * t67
  t359 = 0.35616666666666666666666666666666666666666666666666e-1 * t322 * t356 * t91
  t362 = t65 / t66 / t56
  t365 = 0.20000000000000000000000000000000000000000000000000e1 * t362 * t280 * t90
  t372 = t38 * t201
  t377 = 0.1e1 / t200 / t142
  t378 = t137 * t377
  t379 = t207 ** 2
  t393 = -0.57538888888888888888888888888888888888888888888889e0 * t238 + 0.11507777777777777777777777777777777777777777777778e1 * t244 - 0.86308333333333333333333333333333333333333333333334e0 * t253 + 0.40256666666666666666666666666666666666666666666667e0 * t255 - 0.30192500000000000000000000000000000000000000000000e0 * t257 + 0.36677500000000000000000000000000000000000000000000e-1 * t262 + 0.73355000000000000000000000000000000000000000000000e-1 * t264 - 0.55016250000000000000000000000000000000000000000000e-1 * t266 + 0.13797500000000000000000000000000000000000000000000e0 * t268 - 0.82785000000000000000000000000000000000000000000000e-1 * t271
  t397 = t200 ** 2
  t398 = 0.1e1 / t397
  t399 = t137 * t398
  t400 = t145 ** 2
  t401 = 0.1e1 / t400
  t405 = -0.70981924444444444444444444444444444444444444444442e-3 * t7 * t296 * t131 + 0.53236443333333333333333333333333333333333333333332e-3 * t7 * t300 * t131 - 0.34246666666666666666666666666666666666666666666666e-1 * t322 * t323 * t192 - 0.20000000000000000000000000000000000000000000000000e1 * t329 * t330 * t191 + 0.99999999999999999999999999999999999999999999999999e0 * t185 * (-0.78438333333333333333333333333333333333333333333333e0 * t238 + 0.15687666666666666666666666666666666666666666666667e1 * t244 - 0.11765750000000000000000000000000000000000000000000e1 * t253 + 0.68863333333333333333333333333333333333333333333333e0 * t255 - 0.51647500000000000000000000000000000000000000000000e0 * t257 + 0.14025833333333333333333333333333333333333333333333e0 * t262 + 0.28051666666666666666666666666666666666666666666667e0 * t264 - 0.21038750000000000000000000000000000000000000000000e0 * t266 + 0.17365833333333333333333333333333333333333333333333e0 * t268 - 0.10419500000000000000000000000000000000000000000000e0 * t271) * t191 + 0.32164683177870697973624959794146027661627532968800e2 * t350 * t330 * t352 + t299 - t303 + t359 + t365 - t276 - t285 - 0.24415406715670879921742973310852762593515528885057e-3 * t7 * t296 * t146 + 0.18311555036753159941307229983139571945136646663793e-3 * t7 * t300 * t146 - 0.10843580882781524214666447553230042011687479519034e-1 * t322 * t372 * t209 - 0.11696446794910408141662685001236899248561775660981e1 * t378 * t379 * t208 + 0.58482233974552040708313425006184496242808878304903e0 * t202 * t393 * t208 + 0.17315755899375863299672358916972966258900005419821e2 * t399 * t379 * t401
  t408 = t107 ** 2
  t409 = 0.1e1 / t408
  t410 = t166 ** 2
  t418 = t94 / t97 / t33
  t422 = t251 * t101 - 0.2e1 * t236 * t163 - t164 * t251 + 0.2e1 * t418 * t236
  t426 = f.my_piecewise3(t104, 0, 0.4e1 / 0.9e1 * t409 * t410 + 0.4e1 / 0.3e1 * t107 * t422)
  t427 = t112 ** 2
  t428 = 0.1e1 / t427
  t429 = t170 ** 2
  t436 = f.my_piecewise3(t111, 0, 0.4e1 / 0.9e1 * t428 * t429 - 0.4e1 / 0.3e1 * t112 * t422)
  t438 = (t426 + t436) * t120
  t441 = t276 + t285 + 0.4e1 * t116 * t286 - 0.8e1 * t289 * t151 - 0.8e1 * t158 * t293 - t299 + t303 - 0.4e1 * t158 * t286 - 0.11696446794910408141662685001236899248561775660981e1 * t306 * t225 + 0.10843580882781524214666447553230042011687479519034e-1 * t309 * t39 * t225 + 0.2e1 * t161 * t175 * t212 + t161 * t179 * t405 + t161 * t438 * t149
  t455 = t95 * t99 * t115
  t456 = t150 * t236
  t460 = t96 * t156 * t115
  t466 = t154 / t98 / t97 * t115
  t469 = t100 * t174
  t480 = t175 * t4
  t487 = -0.58482233974552040708313425006184496242808878304903e0 * t223 * t201 * t393 * t208 - 0.17315755899375863299672358916972966258900005419821e2 * t223 * t398 * t379 * t401 + 0.11696446794910408141662685001236899248561775660981e1 * t223 * t377 * t379 * t208 + 0.12e2 * t455 * t456 - 0.32e2 * t460 * t456 + 0.20e2 * t466 * t456 + 0.8e1 * t469 * t151 - t365 + 0.19751789702565206228825776161588751761046270558698e-1 * t438 * t147 + 0.8e1 * t116 * t293 - t359 + 0.24415406715670879921742973310852762593515528885057e-3 * t218 * t242 * t236 * t146 - 0.36623110073506319882614459966279143890273293327586e-3 * t480 * t220 - 0.18311555036753159941307229983139571945136646663793e-3 * t218 * t72 * t251 * t146
  d11 = 0.22147155666666666666666666666666666666666666666666e-2 * t62 + 0.20000000000000000000000000000000000000000000000000e1 * t92 + 0.8e1 * t152 - 0.8e1 * t159 + 0.2e1 * t177 + 0.2e1 * t214 + 0.39503579405130412457651552323177503522092541117396e-1 * t216 - 0.36623110073506319882614459966279143890273293327586e-3 * t221 - 0.11696446794910408141662685001236899248561775660981e1 * t226 + t228 * (t441 + t487)
  t495 = t31 * params.ltafrac
  t496 = t31 - t495
  t497 = t36 * t496
  t499 = t7 * t497 * t60
  t500 = 0.11073577833333333333333333333333333333333333333333e-2 * t499
  t501 = t72 * t496
  t502 = t71 * t501
  t504 = t4 * t501
  t506 = t80 * t501
  t509 = t50 * t85 * t496
  t511 = -0.63297500000000000000000000000000000000000000000000e0 * t502 - 0.29896666666666666666666666666666666666666666666667e0 * t504 - 0.10238750000000000000000000000000000000000000000000e0 * t506 - 0.82156666666666666666666666666666666666666666666667e-1 * t509
  t512 = t511 * t90
  t513 = t68 * t512
  t514 = 0.10000000000000000000000000000000000000000000000000e1 * t513
  t515 = -t496
  t516 = t150 * t515
  t517 = t116 * t516
  t519 = t150 * t496
  t520 = t158 * t519
  t524 = t515 * t101 - t164 * t496
  t527 = f.my_piecewise3(t104, 0, 0.4e1 / 0.3e1 * t107 * t524)
  t528 = -t524
  t531 = f.my_piecewise3(t111, 0, 0.4e1 / 0.3e1 * t112 * t528)
  t532 = t527 + t531
  t533 = t532 * t120
  t535 = t161 * t533 * t149
  t543 = -0.11765750000000000000000000000000000000000000000000e1 * t502 - 0.51647500000000000000000000000000000000000000000000e0 * t504 - 0.21038750000000000000000000000000000000000000000000e0 * t506 - 0.10419500000000000000000000000000000000000000000000e0 * t509
  t544 = t543 * t191
  t554 = -0.86308333333333333333333333333333333333333333333334e0 * t502 - 0.30192500000000000000000000000000000000000000000000e0 * t504 - 0.55016250000000000000000000000000000000000000000000e-1 * t506 - 0.82785000000000000000000000000000000000000000000000e-1 * t509
  t555 = t554 * t208
  t558 = 0.53236443333333333333333333333333333333333333333332e-3 * t7 * t497 * t131 + 0.99999999999999999999999999999999999999999999999999e0 * t185 * t544 - t500 - t514 + 0.18311555036753159941307229983139571945136646663793e-3 * t7 * t497 * t146 + 0.58482233974552040708313425006184496242808878304903e0 * t202 * t555
  t560 = t161 * t179 * t558
  t561 = t533 * t147
  t563 = t496 * t146
  t564 = t72 * t563
  t565 = t218 * t564
  t568 = t201 * t554 * t208
  t569 = t223 * t568
  t573 = t496 * t38
  t574 = t235 * t573
  t575 = t232 * t574
  t577 = t242 * t573
  t578 = t71 * t577
  t580 = t241 * t496
  t582 = t7 * t580 * t38
  t584 = t261 * t574
  t586 = t80 * t577
  t591 = t50 * t5 * t234 * t496 * t38
  t593 = -0.57538888888888888888888888888888888888888888888889e0 * t575 + 0.11507777777777777777777777777777777777777777777778e1 * t578 + 0.40256666666666666666666666666666666666666666666667e0 * t582 + 0.36677500000000000000000000000000000000000000000000e-1 * t584 + 0.73355000000000000000000000000000000000000000000000e-1 * t586 + 0.13797500000000000000000000000000000000000000000000e0 * t591
  t598 = t533 * t137
  t610 = t150 * t573
  t616 = t150 * t515 * t38
  t624 = 0.14764770444444444444444444444444444444444444444444e-2 * t7 * t580 * t60 * t38
  t625 = t533 * t4
  t633 = t515 * t163
  t639 = -t38 * t163 * t496 - t633 * t38 + 0.2e1 * t418 * t573
  t643 = f.my_piecewise3(t104, 0, 0.4e1 / 0.9e1 * t409 * t524 * t166 + 0.4e1 / 0.3e1 * t107 * t639)
  t651 = f.my_piecewise3(t111, 0, 0.4e1 / 0.9e1 * t428 * t528 * t170 - 0.4e1 / 0.3e1 * t112 * t639)
  t653 = (t643 + t651) * t120
  t666 = -0.58482233974552040708313425006184496242808878304903e0 * t306 * t568 - 0.58482233974552040708313425006184496242808878304903e0 * t223 * t201 * t593 * t208 - 0.58482233974552040708313425006184496242808878304903e0 * t598 * t225 - 0.17315755899375863299672358916972966258900005419821e2 * t223 * t398 * t554 * t401 * t207 + 0.11696446794910408141662685001236899248561775660981e1 * t223 * t377 * t554 * t209 - 0.16e2 * t460 * t610 + 0.20e2 * t466 * t610 + 0.12e2 * t455 * t616 - 0.16e2 * t460 * t616 - t624 - 0.18311555036753159941307229983139571945136646663793e-3 * t625 * t220 - 0.18311555036753159941307229983139571945136646663793e-3 * t480 * t564 + 0.19751789702565206228825776161588751761046270558698e-1 * t653 * t147 + 0.54217904413907621073332237766150210058437397595171e-2 * t309 * t497 * t225 + 0.54217904413907621073332237766150210058437397595170e-2 * t309 * t39 * t568 + 0.24415406715670879921742973310852762593515528885057e-3 * t218 * t242 * t563 * t38
  t677 = t120 * t558
  t678 = t677 * t38
  t683 = t100 * t532
  t686 = t157 * t532
  t692 = 0.16081824322151104821330931780901225435013347914188e2 * t279 * t511 * t282 * t89
  t695 = 0.20000000000000000000000000000000000000000000000000e1 * t362 * t512 * t89
  t700 = t496 * t184
  t724 = t496 * t67
  t727 = 0.17808333333333333333333333333333333333333333333333e-1 * t322 * t724 * t91
  t730 = 0.17808333333333333333333333333333333333333333333333e-1 * t322 * t356 * t512
  t740 = 0.10000000000000000000000000000000000000000000000000e1 * t68 * (-0.42198333333333333333333333333333333333333333333333e0 * t575 + 0.84396666666666666666666666666666666666666666666666e0 * t578 + 0.39862222222222222222222222222222222222222222222223e0 * t582 + 0.68258333333333333333333333333333333333333333333333e-1 * t584 + 0.13651666666666666666666666666666666666666666666667e0 * t586 + 0.13692777777777777777777777777777777777777777777778e0 * t591) * t90
  t744 = t496 * t201
  t761 = -0.70981924444444444444444444444444444444444444444442e-3 * t7 * t580 * t131 * t38 - 0.17123333333333333333333333333333333333333333333333e-1 * t322 * t700 * t192 - 0.17123333333333333333333333333333333333333333333333e-1 * t322 * t323 * t544 - 0.20000000000000000000000000000000000000000000000000e1 * t329 * t544 * t190 + 0.99999999999999999999999999999999999999999999999999e0 * t185 * (-0.78438333333333333333333333333333333333333333333333e0 * t575 + 0.15687666666666666666666666666666666666666666666667e1 * t578 + 0.68863333333333333333333333333333333333333333333333e0 * t582 + 0.14025833333333333333333333333333333333333333333333e0 * t584 + 0.28051666666666666666666666666666666666666666666667e0 * t586 + 0.17365833333333333333333333333333333333333333333333e0 * t591) * t191 + 0.32164683177870697973624959794146027661627532968800e2 * t350 * t543 * t352 * t190 + t624 + t727 + t730 + t695 - t740 - t692 - 0.24415406715670879921742973310852762593515528885057e-3 * t7 * t580 * t219 - 0.54217904413907621073332237766150210058437397595171e-2 * t322 * t744 * t209 - 0.54217904413907621073332237766150210058437397595170e-2 * t322 * t372 * t555 - 0.11696446794910408141662685001236899248561775660981e1 * t378 * t555 * t207 + 0.58482233974552040708313425006184496242808878304903e0 * t202 * t593 * t208 + 0.17315755899375863299672358916972966258900005419821e2 * t399 * t554 * t401 * t207
  t770 = 0.4e1 * t116 * t292 * t515 + t161 * t653 * t149 - 0.4e1 * t158 * t292 * t496 + t161 * t175 * t558 + t161 * t179 * t761 + t161 * t533 * t212 + 0.4e1 * t116 * t678 + 0.4e1 * t683 * t151 - 0.4e1 * t686 * t151 - 0.4e1 * t158 * t678 - 0.4e1 * t289 * t519 + 0.4e1 * t469 * t516 + t692 - t695 - t727 - t730 + t740
  d12 = t195 + t196 + 0.4e1 * t152 - 0.4e1 * t159 + t177 + t214 + 0.19751789702565206228825776161588751761046270558698e-1 * t216 - 0.18311555036753159941307229983139571945136646663793e-3 * t221 - 0.58482233974552040708313425006184496242808878304903e0 * t226 + t500 + t514 + 0.4e1 * t517 - 0.4e1 * t520 + t535 + t560 + 0.19751789702565206228825776161588751761046270558698e-1 * t561 - 0.18311555036753159941307229983139571945136646663793e-3 * t565 - 0.58482233974552040708313425006184496242808878304903e0 * t569 + t228 * (t666 + t770)
  t782 = t511 ** 2
  t785 = 0.20000000000000000000000000000000000000000000000000e1 * t362 * t782 * t90
  t786 = t496 ** 2
  t787 = t241 * t786
  t790 = 0.14764770444444444444444444444444444444444444444444e-2 * t7 * t787 * t60
  t791 = 0.1e1 / r1
  t795 = t31 * t248 * t791 - t495 * t791
  t796 = t36 * t795
  t799 = 0.11073577833333333333333333333333333333333333333333e-2 * t7 * t796 * t60
  t810 = 0.35616666666666666666666666666666666666666666666666e-1 * t322 * t724 * t512
  t817 = t524 ** 2
  t820 = -t795
  t827 = t820 * t101 - t164 * t795 + 0.2e1 * t418 * t786 - 0.2e1 * t633 * t496
  t831 = f.my_piecewise3(t104, 0, 0.4e1 / 0.9e1 * t409 * t817 + 0.4e1 / 0.3e1 * t107 * t827)
  t832 = t528 ** 2
  t839 = f.my_piecewise3(t111, 0, 0.4e1 / 0.9e1 * t428 * t832 - 0.4e1 / 0.3e1 * t112 * t827)
  t841 = (t831 + t839) * t120
  t855 = -t785 - t790 + t799 - 0.32e2 * t460 * t150 * t515 * t496 - 0.18311555036753159941307229983139571945136646663793e-3 * t218 * t72 * t795 * t146 - t810 + 0.24415406715670879921742973310852762593515528885057e-3 * t218 * t242 * t786 * t146 - 0.36623110073506319882614459966279143890273293327586e-3 * t625 * t564 + 0.19751789702565206228825776161588751761046270558698e-1 * t841 * t147 + 0.10843580882781524214666447553230042011687479519034e-1 * t309 * t497 * t568 + 0.2e1 * t161 * t533 * t558 + t161 * t841 * t149 - 0.8e1 * t158 * t677 * t496
  t861 = t235 * t786
  t862 = t232 * t861
  t864 = t242 * t786
  t865 = t71 * t864
  t867 = t72 * t795
  t868 = t71 * t867
  t870 = t4 * t864
  t872 = t4 * t867
  t874 = t261 * t861
  t876 = t80 * t864
  t878 = t80 * t867
  t880 = t50 * t861
  t883 = t50 * t85 * t795
  t885 = -0.57538888888888888888888888888888888888888888888889e0 * t862 + 0.11507777777777777777777777777777777777777777777778e1 * t865 - 0.86308333333333333333333333333333333333333333333334e0 * t868 + 0.40256666666666666666666666666666666666666666666667e0 * t870 - 0.30192500000000000000000000000000000000000000000000e0 * t872 + 0.36677500000000000000000000000000000000000000000000e-1 * t874 + 0.73355000000000000000000000000000000000000000000000e-1 * t876 - 0.55016250000000000000000000000000000000000000000000e-1 * t878 + 0.13797500000000000000000000000000000000000000000000e0 * t880 - 0.82785000000000000000000000000000000000000000000000e-1 * t883
  t890 = t554 ** 2
  t904 = t515 ** 2
  t925 = t543 ** 2
  t959 = 0.10000000000000000000000000000000000000000000000000e1 * t68 * (-0.42198333333333333333333333333333333333333333333333e0 * t862 + 0.84396666666666666666666666666666666666666666666666e0 * t865 - 0.63297500000000000000000000000000000000000000000000e0 * t868 + 0.39862222222222222222222222222222222222222222222223e0 * t870 - 0.29896666666666666666666666666666666666666666666667e0 * t872 + 0.68258333333333333333333333333333333333333333333333e-1 * t874 + 0.13651666666666666666666666666666666666666666666667e0 * t876 - 0.10238750000000000000000000000000000000000000000000e0 * t878 + 0.13692777777777777777777777777777777777777777777778e0 * t880 - 0.82156666666666666666666666666666666666666666666667e-1 * t883) * t90
  t962 = 0.16081824322151104821330931780901225435013347914188e2 * t279 * t782 * t282
  t981 = -0.70981924444444444444444444444444444444444444444442e-3 * t7 * t787 * t131 + 0.53236443333333333333333333333333333333333333333332e-3 * t7 * t796 * t131 - 0.34246666666666666666666666666666666666666666666666e-1 * t322 * t700 * t544 - 0.20000000000000000000000000000000000000000000000000e1 * t329 * t925 * t191 + 0.99999999999999999999999999999999999999999999999999e0 * t185 * (-0.78438333333333333333333333333333333333333333333333e0 * t862 + 0.15687666666666666666666666666666666666666666666667e1 * t865 - 0.11765750000000000000000000000000000000000000000000e1 * t868 + 0.68863333333333333333333333333333333333333333333333e0 * t870 - 0.51647500000000000000000000000000000000000000000000e0 * t872 + 0.14025833333333333333333333333333333333333333333333e0 * t874 + 0.28051666666666666666666666666666666666666666666667e0 * t876 - 0.21038750000000000000000000000000000000000000000000e0 * t878 + 0.17365833333333333333333333333333333333333333333333e0 * t880 - 0.10419500000000000000000000000000000000000000000000e0 * t883) * t191 + 0.32164683177870697973624959794146027661627532968800e2 * t350 * t925 * t352 + t790 - t799 + t810 + t785 - t959 - t962 - 0.24415406715670879921742973310852762593515528885057e-3 * t7 * t787 * t146 + 0.18311555036753159941307229983139571945136646663793e-3 * t7 * t796 * t146 - 0.10843580882781524214666447553230042011687479519034e-1 * t322 * t744 * t555 - 0.11696446794910408141662685001236899248561775660981e1 * t378 * t890 * t208 + 0.58482233974552040708313425006184496242808878304903e0 * t202 * t885 * t208 + 0.17315755899375863299672358916972966258900005419821e2 * t399 * t890 * t401
  t984 = 0.8e1 * t683 * t516 + 0.8e1 * t116 * t677 * t515 - 0.58482233974552040708313425006184496242808878304903e0 * t223 * t201 * t885 * t208 - 0.17315755899375863299672358916972966258900005419821e2 * t223 * t398 * t890 * t401 - 0.11696446794910408141662685001236899248561775660981e1 * t598 * t568 + 0.11696446794910408141662685001236899248561775660981e1 * t223 * t377 * t890 * t208 + 0.20e2 * t466 * t150 * t786 + 0.12e2 * t455 * t150 * t904 - 0.4e1 * t158 * t150 * t795 + 0.4e1 * t116 * t150 * t820 - 0.8e1 * t686 * t519 + t161 * t179 * t981 + t962 + t959
  d22 = 0.22147155666666666666666666666666666666666666666666e-2 * t499 + 0.20000000000000000000000000000000000000000000000000e1 * t513 + 0.8e1 * t517 - 0.8e1 * t520 + 0.2e1 * t535 + 0.2e1 * t560 + 0.39503579405130412457651552323177503522092541117396e-1 * t561 - 0.36623110073506319882614459966279143890273293327586e-3 * t565 - 0.11696446794910408141662685001236899248561775660981e1 * t569 + t228 * (t855 + t984)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t6 = 6 ** (0.1e1 / 0.3e1)
  t7 = jnp.pi ** 2
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t11 = t6 / t9
  t14 = 0.3e1 / 0.5e1 * params.ltafrac
  t15 = (0.5e1 / 0.9e1 * tau0 / t2 / r0 * t11) ** t14
  t16 = r0 * t15
  t17 = r1 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t24 = (0.5e1 / 0.9e1 * tau1 / t18 / r1 * t11) ** t14
  t25 = r1 * t24
  t26 = t16 - t25
  t27 = t26 ** 2
  t28 = t27 ** 2
  t29 = t16 + t25
  t30 = t29 ** 2
  t31 = t30 ** 2
  t32 = 0.1e1 / t31
  t33 = t28 * t32
  t34 = 0.1e1 / t29
  t35 = t26 * t34
  t36 = 0.1e1 + t35
  t37 = t36 <= f.p.zeta_threshold
  t38 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t39 = t38 * f.p.zeta_threshold
  t40 = t36 ** (0.1e1 / 0.3e1)
  t42 = f.my_piecewise3(t37, t39, t40 * t36)
  t43 = 0.1e1 - t35
  t44 = t43 <= f.p.zeta_threshold
  t45 = t43 ** (0.1e1 / 0.3e1)
  t47 = f.my_piecewise3(t44, t39, t45 * t43)
  t48 = t42 + t47 - 0.2e1
  t49 = 2 ** (0.1e1 / 0.3e1)
  t52 = 0.1e1 / (0.2e1 * t49 - 0.2e1)
  t53 = t48 * t52
  t54 = 3 ** (0.1e1 / 0.3e1)
  t55 = 0.1e1 / jnp.pi
  t56 = t55 ** (0.1e1 / 0.3e1)
  t57 = t54 * t56
  t58 = 4 ** (0.1e1 / 0.3e1)
  t59 = t58 ** 2
  t60 = t57 * t59
  t61 = t29 ** (0.1e1 / 0.3e1)
  t63 = 0.1e1 / t61 / t30
  t64 = t15 * params.ltafrac
  t65 = t15 - t64
  t66 = t65 ** 2
  t67 = t63 * t66
  t70 = t57 * t59 / t61
  t71 = jnp.sqrt(t70)
  t74 = t70 ** 0.15e1
  t76 = t54 ** 2
  t77 = t56 ** 2
  t78 = t76 * t77
  t79 = t61 ** 2
  t82 = t78 * t58 / t79
  t84 = 0.70594500000000000000000000000000000000000000000000e1 * t71 + 0.15494250000000000000000000000000000000000000000000e1 * t70 + 0.42077500000000000000000000000000000000000000000000e0 * t74 + 0.15629250000000000000000000000000000000000000000000e0 * t82
  t87 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t84
  t88 = jnp.log(t87)
  t93 = 0.1e1 / t61 / t29
  t94 = 0.1e1 / r0
  t96 = params.ltafrac ** 2
  t99 = t15 * t96 * t94 - t64 * t94
  t100 = t93 * t99
  t104 = t59 * t93
  t105 = t57 * t104
  t106 = t84 ** 2
  t107 = 0.1e1 / t106
  t108 = t65 * t107
  t111 = 0.1e1 / t71 * t54 * t56
  t112 = t104 * t65
  t113 = t111 * t112
  t115 = t57 * t112
  t117 = t70 ** 0.5e0
  t119 = t117 * t54 * t56
  t120 = t119 * t112
  t124 = t58 / t79 / t29
  t126 = t78 * t124 * t65
  t128 = -0.11765750000000000000000000000000000000000000000000e1 * t113 - 0.51647500000000000000000000000000000000000000000000e0 * t115 - 0.21038750000000000000000000000000000000000000000000e0 * t120 - 0.10419500000000000000000000000000000000000000000000e0 * t126
  t129 = 0.1e1 / t87
  t130 = t128 * t129
  t135 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t70
  t137 = 0.1e1 / t106 / t84
  t138 = t135 * t137
  t139 = t128 ** 2
  t140 = t139 * t129
  t143 = t135 * t107
  t147 = 0.1e1 / t71 / t70 * t76 * t77
  t149 = 0.1e1 / t79 / t30
  t150 = t58 * t149
  t151 = t150 * t66
  t152 = t147 * t151
  t154 = t59 * t63
  t155 = t154 * t66
  t156 = t111 * t155
  t158 = t104 * t99
  t159 = t111 * t158
  t161 = t57 * t155
  t163 = t57 * t158
  t165 = t70 ** (-0.5e0)
  t167 = t165 * t76 * t77
  t168 = t167 * t151
  t170 = t119 * t155
  t172 = t119 * t158
  t174 = t78 * t151
  t177 = t78 * t124 * t99
  t179 = -0.78438333333333333333333333333333333333333333333333e0 * t152 + 0.15687666666666666666666666666666666666666666666667e1 * t156 - 0.11765750000000000000000000000000000000000000000000e1 * t159 + 0.68863333333333333333333333333333333333333333333333e0 * t161 - 0.51647500000000000000000000000000000000000000000000e0 * t163 + 0.14025833333333333333333333333333333333333333333333e0 * t168 + 0.28051666666666666666666666666666666666666666666667e0 * t170 - 0.21038750000000000000000000000000000000000000000000e0 * t172 + 0.17365833333333333333333333333333333333333333333333e0 * t174 - 0.10419500000000000000000000000000000000000000000000e0 * t177
  t180 = t179 * t129
  t183 = t106 ** 2
  t184 = 0.1e1 / t183
  t185 = t135 * t184
  t186 = t87 ** 2
  t187 = 0.1e1 / t186
  t188 = t139 * t187
  t195 = 0.37978500000000000000000000000000000000000000000000e1 * t71 + 0.89690000000000000000000000000000000000000000000000e0 * t70 + 0.20477500000000000000000000000000000000000000000000e0 * t74 + 0.12323500000000000000000000000000000000000000000000e0 * t82
  t198 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t195
  t199 = jnp.log(t198)
  t201 = t60 * t67 * t199
  t204 = t60 * t100 * t199
  t206 = t195 ** 2
  t207 = 0.1e1 / t206
  t208 = t65 * t207
  t213 = -0.63297500000000000000000000000000000000000000000000e0 * t113 - 0.29896666666666666666666666666666666666666666666667e0 * t115 - 0.10238750000000000000000000000000000000000000000000e0 * t120 - 0.82156666666666666666666666666666666666666666666667e-1 * t126
  t214 = 0.1e1 / t198
  t215 = t213 * t214
  t217 = t105 * t208 * t215
  t220 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t70
  t222 = 0.1e1 / t206 / t195
  t223 = t220 * t222
  t224 = t213 ** 2
  t225 = t224 * t214
  t226 = t223 * t225
  t228 = t220 * t207
  t239 = -0.42198333333333333333333333333333333333333333333333e0 * t152 + 0.84396666666666666666666666666666666666666666666666e0 * t156 - 0.63297500000000000000000000000000000000000000000000e0 * t159 + 0.39862222222222222222222222222222222222222222222223e0 * t161 - 0.29896666666666666666666666666666666666666666666667e0 * t163 + 0.68258333333333333333333333333333333333333333333333e-1 * t168 + 0.13651666666666666666666666666666666666666666666667e0 * t170 - 0.10238750000000000000000000000000000000000000000000e0 * t172 + 0.13692777777777777777777777777777777777777777777778e0 * t174 - 0.82156666666666666666666666666666666666666666666667e-1 * t177
  t240 = t239 * t214
  t241 = t228 * t240
  t243 = t206 ** 2
  t244 = 0.1e1 / t243
  t245 = t220 * t244
  t246 = t198 ** 2
  t247 = 0.1e1 / t246
  t248 = t224 * t247
  t249 = t245 * t248
  t255 = 0.51785000000000000000000000000000000000000000000000e1 * t71 + 0.90577500000000000000000000000000000000000000000000e0 * t70 + 0.11003250000000000000000000000000000000000000000000e0 * t74 + 0.12417750000000000000000000000000000000000000000000e0 * t82
  t258 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t255
  t259 = jnp.log(t258)
  t266 = t255 ** 2
  t267 = 0.1e1 / t266
  t268 = t65 * t267
  t273 = -0.86308333333333333333333333333333333333333333333334e0 * t113 - 0.30192500000000000000000000000000000000000000000000e0 * t115 - 0.55016250000000000000000000000000000000000000000000e-1 * t120 - 0.82785000000000000000000000000000000000000000000000e-1 * t126
  t274 = 0.1e1 / t258
  t275 = t273 * t274
  t280 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t70
  t282 = 0.1e1 / t266 / t255
  t283 = t280 * t282
  t284 = t273 ** 2
  t285 = t284 * t274
  t288 = t280 * t267
  t299 = -0.57538888888888888888888888888888888888888888888889e0 * t152 + 0.11507777777777777777777777777777777777777777777778e1 * t156 - 0.86308333333333333333333333333333333333333333333334e0 * t159 + 0.40256666666666666666666666666666666666666666666667e0 * t161 - 0.30192500000000000000000000000000000000000000000000e0 * t163 + 0.36677500000000000000000000000000000000000000000000e-1 * t168 + 0.73355000000000000000000000000000000000000000000000e-1 * t170 - 0.55016250000000000000000000000000000000000000000000e-1 * t172 + 0.13797500000000000000000000000000000000000000000000e0 * t174 - 0.82785000000000000000000000000000000000000000000000e-1 * t177
  t300 = t299 * t274
  t303 = t266 ** 2
  t304 = 0.1e1 / t303
  t305 = t280 * t304
  t306 = t258 ** 2
  t307 = 0.1e1 / t306
  t308 = t284 * t307
  t311 = -0.70981924444444444444444444444444444444444444444442e-3 * t60 * t67 * t88 + 0.53236443333333333333333333333333333333333333333332e-3 * t60 * t100 * t88 - 0.34246666666666666666666666666666666666666666666666e-1 * t105 * t108 * t130 - 0.20000000000000000000000000000000000000000000000000e1 * t138 * t140 + 0.99999999999999999999999999999999999999999999999999e0 * t143 * t180 + 0.32164683177870697973624959794146027661627532968800e2 * t185 * t188 + 0.14764770444444444444444444444444444444444444444444e-2 * t201 - 0.11073577833333333333333333333333333333333333333333e-2 * t204 + 0.35616666666666666666666666666666666666666666666666e-1 * t217 + 0.20000000000000000000000000000000000000000000000000e1 * t226 - 0.10000000000000000000000000000000000000000000000000e1 * t241 - 0.16081824322151104821330931780901225435013347914188e2 * t249 - 0.24415406715670879921742973310852762593515528885057e-3 * t60 * t67 * t259 + 0.18311555036753159941307229983139571945136646663793e-3 * t60 * t100 * t259 - 0.10843580882781524214666447553230042011687479519034e-1 * t105 * t268 * t275 - 0.11696446794910408141662685001236899248561775660981e1 * t283 * t285 + 0.58482233974552040708313425006184496242808878304903e0 * t288 * t300 + 0.17315755899375863299672358916972966258900005419821e2 * t305 * t308
  t315 = t40 ** 2
  t316 = 0.1e1 / t315
  t318 = 0.1e1 / t30
  t319 = t26 * t318
  t321 = -t319 * t65 + t65 * t34
  t322 = t321 ** 2
  t328 = t30 * t29
  t329 = 0.1e1 / t328
  t330 = t26 * t329
  t334 = -0.2e1 * t66 * t318 - t319 * t99 + 0.2e1 * t330 * t66 + t99 * t34
  t338 = f.my_piecewise3(t37, 0, 0.4e1 / 0.9e1 * t316 * t322 + 0.4e1 / 0.3e1 * t40 * t334)
  t339 = t45 ** 2
  t340 = 0.1e1 / t339
  t341 = -t321
  t342 = t341 ** 2
  t345 = -t334
  t349 = f.my_piecewise3(t44, 0, 0.4e1 / 0.9e1 * t340 * t342 + 0.4e1 / 0.3e1 * t45 * t345)
  t350 = t338 + t349
  t351 = t350 * t52
  t356 = t280 * t259
  t358 = -0.31090e-1 * t135 * t88 + 0.62182e-1 * t220 * t199 - 0.19751789702565206228825776161588751761046270558698e-1 * t356
  t362 = t53 * t280
  t364 = t267 * t299 * t274
  t367 = t27 * t26
  t368 = t367 * t32
  t369 = t368 * t48
  t370 = t93 * t65
  t386 = 0.53236443333333333333333333333333333333333333333332e-3 * t60 * t370 * t88 + 0.99999999999999999999999999999999999999999999999999e0 * t143 * t130 - 0.11073577833333333333333333333333333333333333333333e-2 * t60 * t370 * t199 - 0.10000000000000000000000000000000000000000000000000e1 * t228 * t215 + 0.18311555036753159941307229983139571945136646663793e-3 * t60 * t370 * t259 + 0.58482233974552040708313425006184496242808878304903e0 * t288 * t275
  t387 = t52 * t386
  t388 = t387 * t65
  t391 = t52 * t358
  t392 = t391 * t99
  t396 = 0.1e1 / t31 / t29
  t397 = t28 * t396
  t400 = f.my_piecewise3(t37, 0, 0.4e1 / 0.3e1 * t40 * t321)
  t403 = f.my_piecewise3(t44, 0, 0.4e1 / 0.3e1 * t45 * t341)
  t404 = t400 + t403
  t405 = t397 * t404
  t406 = t391 * t65
  t409 = t397 * t48
  t414 = t404 * t52
  t415 = t414 * t280
  t417 = t267 * t273 * t274
  t421 = t304 * t284 * t307
  t425 = t282 * t284 * t274
  t428 = t27 * t32
  t429 = t428 * t48
  t430 = t391 * t66
  t433 = t367 * t396
  t434 = t433 * t48
  t438 = 0.1e1 / t31 / t30
  t439 = t28 * t438
  t440 = t439 * t48
  t443 = 0.3e1 * t33 * t53 * t311 + 0.3e1 * t33 * t351 * t358 - 0.17544670192365612212494027501855348872842663491471e1 * t362 * t364 + 0.24e2 * t369 * t388 + 0.12e2 * t369 * t392 - 0.24e2 * t405 * t406 - 0.24e2 * t409 * t388 - 0.12e2 * t409 * t392 - 0.35089340384731224424988055003710697745685326982943e1 * t415 * t417 - 0.51947267698127589899017076750918898776700016259464e2 * t362 * t421 + 0.35089340384731224424988055003710697745685326982943e1 * t362 * t425 + 0.36e2 * t429 * t430 - 0.96e2 * t434 * t430 + 0.60e2 * t440 * t430
  t444 = t368 * t404
  t447 = t53 * t60
  t448 = t370 * t417
  t454 = t53 * t57
  t455 = t99 * t259
  t456 = t104 * t455
  t461 = t154 * t66 * t259
  t464 = t414 * t57
  t466 = t104 * t65 * t259
  t475 = t66 * t65
  t476 = t58 / t79 / t328 * t475
  t477 = t167 * t476
  t479 = t65 * t99
  t480 = t150 * t479
  t481 = t167 * t480
  t484 = 0.1e1 / t61 / t328
  t485 = t59 * t484
  t486 = t485 * t475
  t487 = t119 * t486
  t489 = t154 * t479
  t490 = t119 * t489
  t492 = t147 * t476
  t494 = t147 * t480
  t496 = t111 * t486
  t498 = t111 * t489
  t504 = t32 * t475
  t505 = 0.1e1 / t71 / t82 * t55 * t504 / 0.4e1
  t507 = t70 ** (-0.15e1)
  t509 = t507 * t55 * t504
  t511 = r0 ** 2
  t512 = 0.1e1 / t511
  t517 = -t15 * t96 * params.ltafrac * t512 + t64 * t512
  t518 = t104 * t517
  t519 = t111 * t518
  t521 = t57 * t486
  t523 = t63 * t65
  t525 = t60 * t523 * t99
  t528 = t78 * t124 * t517
  t530 = t57 * t518
  t532 = t119 * t518
  t534 = t78 * t476
  t539 = t78 * t58 * t149 * t65 * t99
  t541 = -0.27303333333333333333333333333333333333333333333333e0 * t477 + 0.20477500000000000000000000000000000000000000000000e0 * t481 - 0.31853888888888888888888888888888888888888888888890e0 * t487 + 0.40955000000000000000000000000000000000000000000001e0 * t490 + 0.16879333333333333333333333333333333333333333333333e1 * t492 - 0.12659500000000000000000000000000000000000000000000e1 * t494 - 0.19692555555555555555555555555555555555555555555555e1 * t496 + 0.25319000000000000000000000000000000000000000000000e1 * t498 - 0.25319000000000000000000000000000000000000000000000e1 * t505 + 0.13651666666666666666666666666666666666666666666667e0 * t509 - 0.63297500000000000000000000000000000000000000000000e0 * t519 - 0.93011851851851851851851851851851851851851851851854e0 * t521 + 0.11958666666666666666666666666666666666666666666667e1 * t525 - 0.82156666666666666666666666666666666666666666666667e-1 * t528 - 0.29896666666666666666666666666666666666666666666667e0 * t530 - 0.10238750000000000000000000000000000000000000000000e0 * t532 - 0.36514074074074074074074074074074074074074074074075e0 * t534 + 0.41078333333333333333333333333333333333333333333334e0 * t539
  t544 = 0.10000000000000000000000000000000000000000000000000e1 * t228 * t541 * t214
  t559 = t26 * t32
  t565 = -0.6e1 * t99 * t318 * t65 - t319 * t517 + 0.6e1 * t475 * t329 + 0.6e1 * t330 * t479 + t517 * t34 - 0.6e1 * t559 * t475
  t569 = f.my_piecewise3(t37, 0, -0.8e1 / 0.27e2 / t315 / t36 * t322 * t321 + 0.4e1 / 0.3e1 * t316 * t321 * t334 + 0.4e1 / 0.3e1 * t40 * t565)
  t582 = f.my_piecewise3(t44, 0, -0.8e1 / 0.27e2 / t339 / t43 * t342 * t341 + 0.4e1 / 0.3e1 * t340 * t341 * t345 - 0.4e1 / 0.3e1 * t45 * t565)
  t584 = (t569 + t582) * t52
  t605 = -0.14671000000000000000000000000000000000000000000000e0 * t477 + 0.11003250000000000000000000000000000000000000000000e0 * t481 - 0.17116166666666666666666666666666666666666666666667e0 * t487 + 0.22006500000000000000000000000000000000000000000000e0 * t490 + 0.23015555555555555555555555555555555555555555555556e1 * t492 - 0.17261666666666666666666666666666666666666666666667e1 * t494 - 0.26851481481481481481481481481481481481481481481482e1 * t496 + 0.34523333333333333333333333333333333333333333333334e1 * t498 - 0.34523333333333333333333333333333333333333333333333e1 * t505 + 0.73355000000000000000000000000000000000000000000000e-1 * t509 - 0.86308333333333333333333333333333333333333333333334e0 * t519 - 0.93932222222222222222222222222222222222222222222223e0 * t521 + 0.12077000000000000000000000000000000000000000000000e1 * t525 - 0.82785000000000000000000000000000000000000000000000e-1 * t528 - 0.30192500000000000000000000000000000000000000000000e0 * t530 - 0.55016250000000000000000000000000000000000000000000e-1 * t532 - 0.36793333333333333333333333333333333333333333333333e0 * t534 + 0.41392500000000000000000000000000000000000000000000e0 * t539
  t633 = 0.1e1 / t303 / t266
  t634 = t284 * t273
  t637 = 0.1e1 / t306 / t258
  t648 = t391 * t475
  t660 = t544 + 0.19751789702565206228825776161588751761046270558698e-1 * t584 * t356 - 0.58482233974552040708313425006184496242808878304903e0 * t362 * t267 * t605 * t274 - 0.21687161765563048429332895106460084023374959038068e-1 * t447 * t67 * t417 + 0.16265371324172286321999671329845063017531219278551e-1 * t447 * t100 * t417 + 0.32530742648344572643999342659690126035062438557102e-1 * t414 * t60 * t448 + 0.16265371324172286321999671329845063017531219278551e-1 * t447 * t370 * t364 + 0.48159446095139119802213748237831062407565640073877e0 * t447 * t370 * t421 - 0.32530742648344572643999342659690126035062438557102e-1 * t447 * t370 * t425 + 0.73246220147012639765228919932558287780546586655171e-3 * t454 * t154 * t455 * t65 - 0.10253897021007794930818001372045340355835853271641e4 * t362 * t633 * t634 * t637 - 0.12e2 * t397 * t350 * t406 - 0.120e3 * t28 / t31 / t328 * t48 * t648 + 0.24e2 * t559 * t48 * t648 - 0.17544670192365612212494027501855348872842663491471e1 * t415 * t364 - 0.35089340384731224424988055003710697745685326982943e1 * t362 * t304 * t634 * t274
  t664 = t52 * t311 * t65
  t667 = t391 * t517
  t670 = t387 * t99
  t687 = t387 * t66
  t703 = 0.1e1 / t303 / t255
  t711 = 0.12e2 * t444 * t392 - 0.12e2 * t409 * t664 + 0.4e1 * t369 * t667 + 0.12e2 * t369 * t670 + 0.35089340384731224424988055003710697745685326982943e1 * t415 * t425 - 0.144e3 * t27 * t396 * t48 * t648 + 0.240e3 * t367 * t438 * t48 * t648 - 0.12e2 * t409 * t670 - 0.12e2 * t405 * t392 + 0.36e2 * t429 * t687 - 0.24e2 * t405 * t388 - 0.17544670192365612212494027501855348872842663491471e1 * t351 * t280 * t417 + 0.60e2 * t440 * t687 - 0.96e2 * t433 * t404 * t430 - 0.96e2 * t434 * t687 + 0.10389453539625517979803415350183779755340003251893e3 * t362 * t703 * t634 * t307 + 0.36e2 * t428 * t404 * t430
  t718 = t93 * t517
  t721 = 0.11073577833333333333333333333333333333333333333333e-2 * t60 * t718 * t199
  t722 = t484 * t475
  t725 = 0.34451131037037037037037037037037037037037037037036e-2 * t60 * t722 * t199
  t726 = t57 * t154
  t730 = 0.71233333333333333333333333333333333333333333333333e-1 * t726 * t66 * t207 * t215
  t734 = 0.53424999999999999999999999999999999999999999999999e-1 * t105 * t99 * t207 * t215
  t738 = 0.10685000000000000000000000000000000000000000000000e0 * t105 * t65 * t222 * t225
  t757 = 0.85917146441092277507960503039464796886558811231548e0 * t105 * t65 * t244 * t248
  t760 = 0.53424999999999999999999999999999999999999999999999e-1 * t105 * t208 * t240
  t764 = t224 * t213
  t767 = 0.96490945932906628927985590685407352610080087485128e2 * t220 / t243 / t195 * t764 * t247
  t775 = 0.51725014705706168413145063783413931475389495076352e3 * t220 / t243 / t206 * t764 / t246 / t198
  t776 = 0.60e2 * t439 * t404 * t430 + 0.24e2 * t444 * t388 + t721 + t725 + t730 - t734 + t738 + 0.73246220147012639765228919932558287780546586655172e-3 * t464 * t461 - 0.56969282336565386484066937725323112718202900731800e-3 * t454 * t485 * t475 * t259 - 0.54934665110259479823921689949418715835409939991379e-3 * t464 * t456 - 0.18311555036753159941307229983139571945136646663793e-3 * t454 * t104 * t517 * t259 - 0.54934665110259479823921689949418715835409939991379e-3 * t351 * t57 * t466 - t757 - t760 - t767 + t775
  t799 = -0.56103333333333333333333333333333333333333333333332e0 * t477 + 0.42077499999999999999999999999999999999999999999999e0 * t481 - 0.65453888888888888888888888888888888888888888888890e0 * t487 + 0.84155000000000000000000000000000000000000000000001e0 * t490 + 0.31375333333333333333333333333333333333333333333334e1 * t492 - 0.23531500000000000000000000000000000000000000000000e1 * t494 - 0.36604555555555555555555555555555555555555555555556e1 * t496 + 0.47063000000000000000000000000000000000000000000001e1 * t498 - 0.47063000000000000000000000000000000000000000000000e1 * t505 + 0.28051666666666666666666666666666666666666666666666e0 * t509 - 0.11765750000000000000000000000000000000000000000000e1 * t519 - 0.16068111111111111111111111111111111111111111111111e1 * t521 + 0.20659000000000000000000000000000000000000000000000e1 * t525 - 0.10419500000000000000000000000000000000000000000000e0 * t528 - 0.51647500000000000000000000000000000000000000000000e0 * t530 - 0.21038750000000000000000000000000000000000000000000e0 * t532 - 0.46308888888888888888888888888888888888888888888888e0 * t534 + 0.52097499999999999999999999999999999999999999999999e0 * t539
  t806 = t139 * t128
  t865 = 0.51947267698127589899017076750918898776700016259463e2 * t305 * t299 * t307 * t273 - 0.60000000000000000000000000000000000000000000000000e1 * t138 * t130 * t179 + 0.35089340384731224424988055003710697745685326982943e1 * t305 * t634 * t274 + 0.18311555036753159941307229983139571945136646663793e-3 * t60 * t718 * t259 + 0.56969282336565386484066937725323112718202900731800e-3 * t60 * t722 * t259 + 0.16562449037037037037037037037037037037037037037036e-2 * t60 * t722 * t88 + 0.53236443333333333333333333333333333333333333333332e-3 * t60 * t718 * t88 - t721 - t725 - 0.16265371324172286321999671329845063017531219278551e-1 * t105 * t99 * t267 * t275 - 0.16265371324172286321999671329845063017531219278551e-1 * t105 * t268 * t300
  t902 = 0.48245472966453314463992795342703676305040043742564e2 * t245 * t239 * t247 * t213
  t905 = 0.60000000000000000000000000000000000000000000000000e1 * t223 * t215 * t239
  t908 = 0.60000000000000000000000000000000000000000000000000e1 * t245 * t764 * t214
  t919 = 0.44294311333333333333333333333333333333333333333332e-2 * t60 * t523 * t199 * t99
  t920 = 0.10274000000000000000000000000000000000000000000000e0 * t105 * t65 * t137 * t140 - 0.48159446095139119802213748237831062407565640073877e0 * t105 * t65 * t304 * t308 + 0.21687161765563048429332895106460084023374959038068e-1 * t726 * t66 * t267 * t275 + t767 - t775 - t902 + t905 - t908 - 0.21294577333333333333333333333333333333333333333332e-2 * t60 * t523 * t88 * t99 - 0.73246220147012639765228919932558287780546586655171e-3 * t60 * t523 * t455 + t919
  t938 = t391 * t479
  t958 = t33 * t53 * (0.10253897021007794930818001372045340355835853271641e4 * t280 * t633 * t634 * t637 + 0.99999999999999999999999999999999999999999999999999e0 * t143 * t799 * t129 - 0.19298809906722418784174975876487616596976519781280e3 * t135 / t183 / t84 * t806 * t187 + 0.20691336878655965245175271659148296983999699561788e4 * t135 / t183 / t106 * t806 / t186 / t87 - 0.10389453539625517979803415350183779755340003251893e3 * t280 * t703 * t634 * t307 + 0.58482233974552040708313425006184496242808878304903e0 * t288 * t605 * t274 + 0.60000000000000000000000000000000000000000000000000e1 * t185 * t806 * t129 - t544 + 0.96494049533612093920874879382438082984882598906400e2 * t185 * t179 * t187 * t128 - 0.35089340384731224424988055003710697745685326982943e1 * t283 * t275 * t299 + t865 - t730 + t734 - t738 + t757 + t760 - 0.51369999999999999999999999999999999999999999999999e-1 * t105 * t108 * t180 - 0.16522997748472177549051141846252814409778063686072e1 * t105 * t65 * t184 * t188 + 0.68493333333333333333333333333333333333333333333331e-1 * t726 * t66 * t107 * t130 - 0.51369999999999999999999999999999999999999999999999e-1 * t105 * t99 * t107 * t130 + 0.32530742648344572643999342659690126035062438557102e-1 * t105 * t65 * t282 * t285 + t920) + t902 + t33 * t584 * t358 - t905 + t908 + 0.3e1 * t33 * t351 * t386 + 0.3e1 * t33 * t414 * t311 - 0.51947267698127589899017076750918898776700016259463e2 * t362 * t304 * t299 * t307 * t273 - 0.96e2 * t434 * t938 + 0.60e2 * t440 * t938 + 0.36e2 * t429 * t938 + 0.35089340384731224424988055003710697745685326982943e1 * t362 * t282 * t273 * t300 - t919 + 0.12e2 * t369 * t664 - 0.4e1 * t409 * t667 + 0.12e2 * t368 * t350 * t406 - 0.51947267698127589899017076750918898776700016259464e2 * t415 * t421
  t967 = 0.24e2 * t444 * t406 + 0.32530742648344572643999342659690126035062438557102e-1 * t447 * t448 + 0.6e1 * t33 * t414 * t386 - 0.54934665110259479823921689949418715835409939991379e-3 * t454 * t456 - 0.10685000000000000000000000000000000000000000000000e0 * t217 + 0.73246220147012639765228919932558287780546586655172e-3 * t454 * t461 - 0.10986933022051895964784337989883743167081987998276e-2 * t464 * t466 + 0.33220733499999999999999999999999999999999999999999e-2 * t204 - 0.44294311333333333333333333333333333333333333333332e-2 * t201 + (r0 + r1) * (t660 + t711 + t776 + t958) + 0.59255369107695618686477328484766255283138811676094e-1 * t351 * t356 - 0.60000000000000000000000000000000000000000000000000e1 * t226 + 0.30000000000000000000000000000000000000000000000000e1 * t241 + 0.48245472966453314463992795342703676305040043742564e2 * t249
  d111 = t443 + t967

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = t4 * t6
  t8 = r0 ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t13 = 6 ** (0.1e1 / 0.3e1)
  t14 = jnp.pi ** 2
  t15 = t14 ** (0.1e1 / 0.3e1)
  t16 = t15 ** 2
  t18 = t13 / t16
  t21 = 0.3e1 / 0.5e1 * params.ltafrac
  t22 = (0.5e1 / 0.9e1 * tau0 / t9 / r0 * t18) ** t21
  t23 = r0 * t22
  t24 = r1 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t31 = (0.5e1 / 0.9e1 * tau1 / t25 / r1 * t18) ** t21
  t32 = r1 * t31
  t33 = t23 + t32
  t34 = t33 ** 2
  t35 = t33 ** (0.1e1 / 0.3e1)
  t37 = 0.1e1 / t35 / t34
  t38 = t22 * params.ltafrac
  t39 = t22 - t38
  t40 = t37 * t39
  t43 = t4 * t6 / t35
  t44 = jnp.sqrt(t43)
  t47 = t43 ** 0.15e1
  t49 = t1 ** 2
  t50 = t3 ** 2
  t51 = t49 * t50
  t52 = t35 ** 2
  t55 = t51 * t5 / t52
  t57 = 0.37978500000000000000000000000000000000000000000000e1 * t44 + 0.89690000000000000000000000000000000000000000000000e0 * t43 + 0.20477500000000000000000000000000000000000000000000e0 * t47 + 0.12323500000000000000000000000000000000000000000000e0 * t55
  t60 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t57
  t61 = jnp.log(t60)
  t62 = 0.1e1 / r0
  t64 = params.ltafrac ** 2
  t65 = t22 * t64
  t67 = -t38 * t62 + t65 * t62
  t68 = t61 * t67
  t70 = t7 * t40 * t68
  t73 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t43
  t74 = t57 ** 2
  t75 = t74 ** 2
  t77 = 0.1e1 / t75 / t74
  t78 = t73 * t77
  t81 = 0.1e1 / t44 * t1 * t3
  t83 = 0.1e1 / t35 / t33
  t84 = t6 * t83
  t85 = t84 * t39
  t86 = t81 * t85
  t88 = t4 * t85
  t90 = t43 ** 0.5e0
  t92 = t90 * t1 * t3
  t93 = t92 * t85
  t97 = t5 / t52 / t33
  t99 = t51 * t97 * t39
  t101 = -0.63297500000000000000000000000000000000000000000000e0 * t86 - 0.29896666666666666666666666666666666666666666666667e0 * t88 - 0.10238750000000000000000000000000000000000000000000e0 * t93 - 0.82156666666666666666666666666666666666666666666667e-1 * t99
  t102 = t101 ** 2
  t103 = t102 * t101
  t104 = t60 ** 2
  t106 = 0.1e1 / t104 / t60
  t107 = t103 * t106
  t108 = t78 * t107
  t110 = t23 - t32
  t111 = 0.1e1 / t33
  t112 = t110 * t111
  t113 = 0.1e1 + t112
  t114 = t113 <= f.p.zeta_threshold
  t115 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t116 = t115 * f.p.zeta_threshold
  t117 = t113 ** (0.1e1 / 0.3e1)
  t119 = f.my_piecewise3(t114, t116, t117 * t113)
  t120 = 0.1e1 - t112
  t121 = t120 <= f.p.zeta_threshold
  t122 = t120 ** (0.1e1 / 0.3e1)
  t124 = f.my_piecewise3(t121, t116, t122 * t120)
  t125 = t119 + t124 - 0.2e1
  t126 = 2 ** (0.1e1 / 0.3e1)
  t129 = 0.1e1 / (0.2e1 * t126 - 0.2e1)
  t130 = t125 * t129
  t131 = t130 * t4
  t132 = t6 * t37
  t137 = 0.51785000000000000000000000000000000000000000000000e1 * t44 + 0.90577500000000000000000000000000000000000000000000e0 * t43 + 0.11003250000000000000000000000000000000000000000000e0 * t47 + 0.12417750000000000000000000000000000000000000000000e0 * t55
  t140 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t137
  t141 = jnp.log(t140)
  t142 = t67 * t141
  t144 = t132 * t142 * t39
  t147 = 0.1e1 / t74
  t148 = t73 * t147
  t152 = 0.1e1 / t44 / t43 * t49 * t50
  t154 = 0.1e1 / t52 / t34
  t155 = t5 * t154
  t156 = t39 * t67
  t157 = t155 * t156
  t158 = t152 * t157
  t160 = t34 * t33
  t162 = 0.1e1 / t35 / t160
  t163 = t6 * t162
  t164 = t39 ** 2
  t165 = t164 * t39
  t166 = t163 * t165
  t167 = t81 * t166
  t169 = t132 * t156
  t170 = t81 * t169
  t172 = t43 ** (-0.5e0)
  t174 = t172 * t49 * t50
  t176 = 0.1e1 / t52 / t160
  t177 = t5 * t176
  t178 = t177 * t165
  t179 = t174 * t178
  t181 = t174 * t157
  t183 = t92 * t166
  t185 = t92 * t169
  t187 = t152 * t178
  t189 = r0 ** 2
  t190 = 0.1e1 / t189
  t193 = t22 * t64 * params.ltafrac
  t195 = -t193 * t190 + t38 * t190
  t197 = t51 * t97 * t195
  t199 = t84 * t195
  t200 = t4 * t199
  t205 = 0.1e1 / t44 / t55 * t2 / 0.4e1
  t206 = t34 ** 2
  t207 = 0.1e1 / t206
  t208 = t207 * t165
  t209 = t205 * t208
  t211 = t43 ** (-0.15e1)
  t212 = t211 * t2
  t213 = t212 * t208
  t215 = t81 * t199
  t217 = t4 * t166
  t220 = t7 * t40 * t67
  t222 = t92 * t199
  t224 = t51 * t178
  t226 = t51 * t5
  t229 = t226 * t154 * t39 * t67
  t231 = -0.12659500000000000000000000000000000000000000000000e1 * t158 - 0.19692555555555555555555555555555555555555555555555e1 * t167 + 0.25319000000000000000000000000000000000000000000000e1 * t170 - 0.27303333333333333333333333333333333333333333333333e0 * t179 + 0.20477500000000000000000000000000000000000000000000e0 * t181 - 0.31853888888888888888888888888888888888888888888890e0 * t183 + 0.40955000000000000000000000000000000000000000000001e0 * t185 + 0.16879333333333333333333333333333333333333333333333e1 * t187 - 0.82156666666666666666666666666666666666666666666667e-1 * t197 - 0.29896666666666666666666666666666666666666666666667e0 * t200 - 0.25319000000000000000000000000000000000000000000000e1 * t209 + 0.13651666666666666666666666666666666666666666666667e0 * t213 - 0.63297500000000000000000000000000000000000000000000e0 * t215 - 0.93011851851851851851851851851851851851851851851854e0 * t217 + 0.11958666666666666666666666666666666666666666666667e1 * t220 - 0.10238750000000000000000000000000000000000000000000e0 * t222 - 0.36514074074074074074074074074074074074074074074075e0 * t224 + 0.41078333333333333333333333333333333333333333333334e0 * t229
  t232 = 0.1e1 / t60
  t233 = t231 * t232
  t234 = t148 * t233
  t236 = t110 ** 2
  t237 = t236 * t207
  t238 = t237 * t125
  t240 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t43
  t245 = 0.70594500000000000000000000000000000000000000000000e1 * t44 + 0.15494250000000000000000000000000000000000000000000e1 * t43 + 0.42077500000000000000000000000000000000000000000000e0 * t47 + 0.15629250000000000000000000000000000000000000000000e0 * t55
  t248 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t245
  t249 = jnp.log(t248)
  t255 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t43
  t256 = t255 * t141
  t258 = -0.31090e-1 * t240 * t249 + 0.62182e-1 * t73 * t61 - 0.19751789702565206228825776161588751761046270558698e-1 * t256
  t259 = t129 * t258
  t260 = t259 * t156
  t263 = t83 * t39
  t267 = t245 ** 2
  t268 = 0.1e1 / t267
  t269 = t240 * t268
  t274 = -0.11765750000000000000000000000000000000000000000000e1 * t86 - 0.51647500000000000000000000000000000000000000000000e0 * t88 - 0.21038750000000000000000000000000000000000000000000e0 * t93 - 0.10419500000000000000000000000000000000000000000000e0 * t99
  t275 = 0.1e1 / t248
  t276 = t274 * t275
  t282 = t101 * t232
  t288 = t137 ** 2
  t289 = 0.1e1 / t288
  t290 = t255 * t289
  t295 = -0.86308333333333333333333333333333333333333333333334e0 * t86 - 0.30192500000000000000000000000000000000000000000000e0 * t88 - 0.55016250000000000000000000000000000000000000000000e-1 * t93 - 0.82785000000000000000000000000000000000000000000000e-1 * t99
  t296 = 0.1e1 / t140
  t297 = t295 * t296
  t300 = 0.53236443333333333333333333333333333333333333333332e-3 * t7 * t263 * t249 + 0.99999999999999999999999999999999999999999999999999e0 * t269 * t276 - 0.11073577833333333333333333333333333333333333333333e-2 * t7 * t263 * t61 - 0.10000000000000000000000000000000000000000000000000e1 * t148 * t282 + 0.18311555036753159941307229983139571945136646663793e-3 * t7 * t263 * t141 + 0.58482233974552040708313425006184496242808878304903e0 * t290 * t297
  t301 = t129 * t300
  t302 = t301 * t164
  t305 = t236 * t110
  t306 = t206 * t33
  t307 = 0.1e1 / t306
  t308 = t305 * t307
  t310 = 0.1e1 / t34
  t311 = t110 * t310
  t313 = t39 * t111 - t311 * t39
  t316 = f.my_piecewise3(t114, 0, 0.4e1 / 0.3e1 * t117 * t313)
  t317 = -t313
  t320 = f.my_piecewise3(t121, 0, 0.4e1 / 0.3e1 * t122 * t317)
  t321 = t316 + t320
  t322 = t308 * t321
  t323 = t259 * t164
  t326 = t308 * t125
  t329 = t321 * t129
  t330 = t329 * t255
  t331 = t155 * t164
  t332 = t152 * t331
  t334 = t132 * t164
  t335 = t81 * t334
  t337 = t84 * t67
  t338 = t81 * t337
  t340 = t4 * t334
  t342 = t4 * t337
  t344 = t174 * t331
  t346 = t92 * t334
  t348 = t92 * t337
  t350 = t51 * t331
  t353 = t51 * t97 * t67
  t355 = -0.57538888888888888888888888888888888888888888888889e0 * t332 + 0.11507777777777777777777777777777777777777777777778e1 * t335 - 0.86308333333333333333333333333333333333333333333334e0 * t338 + 0.40256666666666666666666666666666666666666666666667e0 * t340 - 0.30192500000000000000000000000000000000000000000000e0 * t342 + 0.36677500000000000000000000000000000000000000000000e-1 * t344 + 0.73355000000000000000000000000000000000000000000000e-1 * t346 - 0.55016250000000000000000000000000000000000000000000e-1 * t348 + 0.13797500000000000000000000000000000000000000000000e0 * t350 - 0.82785000000000000000000000000000000000000000000000e-1 * t353
  t357 = t289 * t355 * t296
  t360 = t236 ** 2
  t361 = t360 * t307
  t362 = t361 * t125
  t363 = t301 * t67
  t366 = t83 * t195
  t368 = t7 * t366 * t61
  t370 = t117 ** 2
  t372 = 0.1e1 / t370 / t113
  t373 = t313 ** 2
  t377 = 0.1e1 / t370
  t378 = t377 * t313
  t382 = 0.1e1 / t160
  t383 = t110 * t382
  t387 = t67 * t111 - 0.2e1 * t164 * t310 + 0.2e1 * t383 * t164 - t311 * t67
  t396 = t110 * t207
  t402 = -0.6e1 * t67 * t310 * t39 + t195 * t111 + 0.6e1 * t383 * t156 + 0.6e1 * t165 * t382 - 0.6e1 * t396 * t165 - t311 * t195
  t406 = f.my_piecewise3(t114, 0, -0.8e1 / 0.27e2 * t372 * t373 * t313 + 0.4e1 / 0.3e1 * t378 * t387 + 0.4e1 / 0.3e1 * t117 * t402)
  t407 = t122 ** 2
  t409 = 0.1e1 / t407 / t120
  t410 = t317 ** 2
  t414 = 0.1e1 / t407
  t415 = t414 * t317
  t416 = -t387
  t419 = -t402
  t423 = f.my_piecewise3(t121, 0, -0.8e1 / 0.27e2 * t409 * t410 * t317 + 0.4e1 / 0.3e1 * t415 * t416 + 0.4e1 / 0.3e1 * t122 * t419)
  t424 = t406 + t423
  t425 = t424 * t129
  t428 = t305 * t207
  t429 = t428 * t125
  t430 = t37 * t164
  t434 = t83 * t67
  t438 = t4 * t84
  t439 = t39 * t268
  t443 = t267 * t245
  t444 = 0.1e1 / t443
  t445 = t240 * t444
  t446 = t274 ** 2
  t447 = t446 * t275
  t460 = -0.78438333333333333333333333333333333333333333333333e0 * t332 + 0.15687666666666666666666666666666666666666666666667e1 * t335 - 0.11765750000000000000000000000000000000000000000000e1 * t338 + 0.68863333333333333333333333333333333333333333333333e0 * t340 - 0.51647500000000000000000000000000000000000000000000e0 * t342 + 0.14025833333333333333333333333333333333333333333333e0 * t344 + 0.28051666666666666666666666666666666666666666666667e0 * t346 - 0.21038750000000000000000000000000000000000000000000e0 * t348 + 0.17365833333333333333333333333333333333333333333333e0 * t350 - 0.10419500000000000000000000000000000000000000000000e0 * t353
  t461 = t460 * t275
  t464 = t267 ** 2
  t465 = 0.1e1 / t464
  t466 = t240 * t465
  t467 = t248 ** 2
  t468 = 0.1e1 / t467
  t469 = t446 * t468
  t478 = t39 * t147
  t482 = t74 * t57
  t483 = 0.1e1 / t482
  t484 = t73 * t483
  t485 = t102 * t232
  t498 = -0.42198333333333333333333333333333333333333333333333e0 * t332 + 0.84396666666666666666666666666666666666666666666666e0 * t335 - 0.63297500000000000000000000000000000000000000000000e0 * t338 + 0.39862222222222222222222222222222222222222222222223e0 * t340 - 0.29896666666666666666666666666666666666666666666667e0 * t342 + 0.68258333333333333333333333333333333333333333333333e-1 * t344 + 0.13651666666666666666666666666666666666666666666667e0 * t346 - 0.10238750000000000000000000000000000000000000000000e0 * t348 + 0.13692777777777777777777777777777777777777777777778e0 * t350 - 0.82156666666666666666666666666666666666666666666667e-1 * t353
  t499 = t498 * t232
  t502 = 0.1e1 / t75
  t503 = t73 * t502
  t504 = 0.1e1 / t104
  t505 = t102 * t504
  t514 = t39 * t289
  t518 = t288 * t137
  t519 = 0.1e1 / t518
  t520 = t255 * t519
  t521 = t295 ** 2
  t522 = t521 * t296
  t525 = t355 * t296
  t528 = t288 ** 2
  t529 = 0.1e1 / t528
  t530 = t255 * t529
  t531 = t140 ** 2
  t532 = 0.1e1 / t531
  t533 = t521 * t532
  t536 = -0.70981924444444444444444444444444444444444444444442e-3 * t7 * t430 * t249 + 0.53236443333333333333333333333333333333333333333332e-3 * t7 * t434 * t249 - 0.34246666666666666666666666666666666666666666666666e-1 * t438 * t439 * t276 - 0.20000000000000000000000000000000000000000000000000e1 * t445 * t447 + 0.99999999999999999999999999999999999999999999999999e0 * t269 * t461 + 0.32164683177870697973624959794146027661627532968800e2 * t466 * t469 + 0.14764770444444444444444444444444444444444444444444e-2 * t7 * t430 * t61 - 0.11073577833333333333333333333333333333333333333333e-2 * t7 * t434 * t61 + 0.35616666666666666666666666666666666666666666666666e-1 * t438 * t478 * t282 + 0.20000000000000000000000000000000000000000000000000e1 * t484 * t485 - 0.10000000000000000000000000000000000000000000000000e1 * t148 * t499 - 0.16081824322151104821330931780901225435013347914188e2 * t503 * t505 - 0.24415406715670879921742973310852762593515528885057e-3 * t7 * t430 * t141 + 0.18311555036753159941307229983139571945136646663793e-3 * t7 * t434 * t141 - 0.10843580882781524214666447553230042011687479519034e-1 * t438 * t514 * t297 - 0.11696446794910408141662685001236899248561775660981e1 * t520 * t522 + 0.58482233974552040708313425006184496242808878304903e0 * t290 * t525 + 0.17315755899375863299672358916972966258900005419821e2 * t530 * t533
  t537 = t129 * t536
  t538 = t537 * t39
  t543 = t532 * t295
  t544 = t529 * t355 * t543
  t547 = t360 * t207
  t555 = t329 * t4
  t558 = t195 * t141
  t563 = t39 * t483
  t564 = t282 * t498
  t567 = 0.42740000000000000000000000000000000000000000000000e0 * t438 * t563 * t564
  t568 = t4 * t132
  t572 = 0.28493333333333333333333333333333333333333333333333e0 * t568 * t478 * t282 * t67
  t573 = t39 * t502
  t575 = t498 * t504 * t101
  t578 = 0.34366858576436911003184201215785918754623524492620e1 * t438 * t573 * t575
  t580 = 0.1e1 / t206 / t34
  t581 = t360 * t580
  t582 = t581 * t125
  t583 = t537 * t164
  t586 = t249 * t67
  t613 = -0.23531500000000000000000000000000000000000000000000e1 * t158 - 0.36604555555555555555555555555555555555555555555556e1 * t167 + 0.47063000000000000000000000000000000000000000000001e1 * t170 - 0.56103333333333333333333333333333333333333333333332e0 * t179 + 0.42077499999999999999999999999999999999999999999999e0 * t181 - 0.65453888888888888888888888888888888888888888888890e0 * t183 + 0.84155000000000000000000000000000000000000000000001e0 * t185 + 0.31375333333333333333333333333333333333333333333334e1 * t187 - 0.10419500000000000000000000000000000000000000000000e0 * t197 - 0.51647500000000000000000000000000000000000000000000e0 * t200 - 0.47063000000000000000000000000000000000000000000000e1 * t209 + 0.28051666666666666666666666666666666666666666666666e0 * t213 - 0.11765750000000000000000000000000000000000000000000e1 * t215 - 0.16068111111111111111111111111111111111111111111111e1 * t217 + 0.20659000000000000000000000000000000000000000000000e1 * t220 - 0.21038750000000000000000000000000000000000000000000e0 * t222 - 0.46308888888888888888888888888888888888888888888888e0 * t224 + 0.52097499999999999999999999999999999999999999999999e0 * t229
  t614 = t613 * t275
  t618 = 0.1e1 / t464 / t267
  t619 = t240 * t618
  t620 = t446 * t274
  t622 = 0.1e1 / t467 / t248
  t623 = t620 * t622
  t627 = 0.1e1 / t528 / t288
  t628 = t255 * t627
  t629 = t521 * t295
  t631 = 0.1e1 / t531 / t140
  t632 = t629 * t631
  t635 = t355 * t532
  t636 = t635 * t295
  t640 = t297 * t355
  t648 = t162 * t165
  t656 = t460 * t468 * t274
  t659 = t629 * t296
  t662 = t103 * t232
  t663 = t503 * t662
  t683 = -0.17261666666666666666666666666666666666666666666667e1 * t158 - 0.26851481481481481481481481481481481481481481481482e1 * t167 + 0.34523333333333333333333333333333333333333333333334e1 * t170 - 0.14671000000000000000000000000000000000000000000000e0 * t179 + 0.11003250000000000000000000000000000000000000000000e0 * t181 - 0.17116166666666666666666666666666666666666666666667e0 * t183 + 0.22006500000000000000000000000000000000000000000000e0 * t185 + 0.23015555555555555555555555555555555555555555555556e1 * t187 - 0.82785000000000000000000000000000000000000000000000e-1 * t197 - 0.30192500000000000000000000000000000000000000000000e0 * t200 - 0.34523333333333333333333333333333333333333333333333e1 * t209 + 0.73355000000000000000000000000000000000000000000000e-1 * t213 - 0.86308333333333333333333333333333333333333333333334e0 * t215 - 0.93932222222222222222222222222222222222222222222223e0 * t217 + 0.12077000000000000000000000000000000000000000000000e1 * t220 - 0.55016250000000000000000000000000000000000000000000e-1 * t222 - 0.36793333333333333333333333333333333333333333333333e0 * t224 + 0.41392500000000000000000000000000000000000000000000e0 * t229
  t684 = t683 * t296
  t687 = t503 * t575
  t693 = t7 * t648 * t61
  t695 = -0.11073577833333333333333333333333333333333333333333e-2 * t368 + 0.18311555036753159941307229983139571945136646663793e-3 * t7 * t366 * t141 + 0.56969282336565386484066937725323112718202900731800e-3 * t7 * t648 * t141 + 0.53236443333333333333333333333333333333333333333332e-3 * t7 * t366 * t249 + 0.96494049533612093920874879382438082984882598906400e2 * t466 * t656 + 0.35089340384731224424988055003710697745685326982943e1 * t530 * t659 - 0.60000000000000000000000000000000000000000000000000e1 * t663 + 0.58482233974552040708313425006184496242808878304903e0 * t290 * t684 - 0.48245472966453314463992795342703676305040043742564e2 * t687 + 0.16562449037037037037037037037037037037037037037036e-2 * t7 * t648 * t249 - 0.34451131037037037037037037037037037037037037037036e-2 * t693
  t698 = 0.1e1 / t528 / t137
  t699 = t255 * t698
  t700 = t629 * t532
  t704 = 0.1e1 / t75 / t57
  t705 = t73 * t704
  t706 = t103 * t504
  t707 = t705 * t706
  t710 = t438 * t563 * t485
  t712 = t164 * t147
  t714 = t568 * t712 * t282
  t716 = t67 * t147
  t718 = t438 * t716 * t282
  t721 = t438 * t478 * t499
  t724 = t438 * t573 * t505
  t726 = t39 * t529
  t730 = t164 * t289
  t734 = t67 * t289
  t742 = t67 * t268
  t749 = t39 * t465
  t753 = t164 * t268
  t757 = t39 * t519
  t761 = t39 * t444
  t765 = t484 * t564
  t767 = t276 * t460
  t770 = t620 * t275
  t774 = 0.1e1 / t464 / t245
  t775 = t240 * t774
  t776 = t620 * t468
  t779 = -0.16265371324172286321999671329845063017531219278551e-1 * t438 * t514 * t525 - 0.51369999999999999999999999999999999999999999999999e-1 * t438 * t742 * t276 - 0.51369999999999999999999999999999999999999999999999e-1 * t438 * t439 * t461 - 0.16522997748472177549051141846252814409778063686072e1 * t438 * t749 * t469 + 0.68493333333333333333333333333333333333333333333331e-1 * t568 * t753 * t276 + 0.32530742648344572643999342659690126035062438557102e-1 * t438 * t757 * t522 + 0.10274000000000000000000000000000000000000000000000e0 * t438 * t761 * t447 + 0.60000000000000000000000000000000000000000000000000e1 * t765 - 0.60000000000000000000000000000000000000000000000000e1 * t445 * t767 + 0.60000000000000000000000000000000000000000000000000e1 * t466 * t770 - 0.19298809906722418784174975876487616596976519781280e3 * t775 * t776
  t781 = -0.21294577333333333333333333333333333333333333333332e-2 * t7 * t40 * t586 - 0.73246220147012639765228919932558287780546586655171e-3 * t7 * t40 * t142 + 0.44294311333333333333333333333333333333333333333332e-2 * t70 - 0.51725014705706168413145063783413931475389495076352e3 * t108 + 0.99999999999999999999999999999999999999999999999999e0 * t269 * t614 + 0.20691336878655965245175271659148296983999699561788e4 * t619 * t623 + 0.10253897021007794930818001372045340355835853271641e4 * t628 * t632 + 0.51947267698127589899017076750918898776700016259463e2 * t530 * t636 - 0.10000000000000000000000000000000000000000000000000e1 * t234 - 0.35089340384731224424988055003710697745685326982943e1 * t520 * t640 + t695 - 0.10389453539625517979803415350183779755340003251893e3 * t699 * t700 + 0.96490945932906628927985590685407352610080087485128e2 * t707 - 0.10685000000000000000000000000000000000000000000000e0 * t710 - 0.71233333333333333333333333333333333333333333333333e-1 * t714 + 0.53424999999999999999999999999999999999999999999999e-1 * t718 + 0.53424999999999999999999999999999999999999999999999e-1 * t721 + 0.85917146441092277507960503039464796886558811231548e0 * t724 - 0.48159446095139119802213748237831062407565640073877e0 * t438 * t726 * t533 + 0.21687161765563048429332895106460084023374959038068e-1 * t568 * t730 * t297 - 0.16265371324172286321999671329845063017531219278551e-1 * t438 * t734 * t297 + t779
  t783 = t129 * t781 * t39
  t791 = f.my_piecewise3(t114, 0, 0.4e1 / 0.9e1 * t377 * t373 + 0.4e1 / 0.3e1 * t117 * t387)
  t797 = f.my_piecewise3(t121, 0, 0.4e1 / 0.9e1 * t414 * t410 + 0.4e1 / 0.3e1 * t122 * t416)
  t798 = t791 + t797
  t799 = t361 * t798
  t800 = t301 * t39
  t804 = t259 * t39
  t814 = 0.1e1 / t35 / t206
  t815 = t164 ** 2
  t816 = t814 * t815
  t819 = 0.11483710345679012345679012345679012345679012345679e-1 * t7 * t816 * t61
  t820 = t815 * t207
  t837 = t297 * t67
  t851 = t446 ** 2
  t855 = 0.69263023597503453198689435667891865035600021679284e2 * t530 * t683 * t532 * t295 - t567 - t572 + t578 - 0.19263778438055647920885499295132424963026256029551e1 * t438 * t726 * t636 + 0.13012297059337829057599737063876050414024975422841e0 * t438 * t757 * t640 - 0.66091990993888710196204567385011257639112254744288e1 * t438 * t749 * t656 + 0.86748647062252193717331580425840336093499836152272e-1 * t568 * t514 * t837 + 0.27397333333333333333333333333333333333333333333332e0 * t568 * t439 * t276 * t67 + 0.41096000000000000000000000000000000000000000000000e0 * t438 * t761 * t767 - 0.62336721237753107878820492101102678532040019511357e3 * t699 * t635 * t521 - 0.24000000000000000000000000000000000000000000000000e2 * t775 * t851 * t275
  t891 = t819 - 0.18989760778855128828022312575107704239400966910600e-2 * t7 * t816 * t141 - 0.55208163456790123456790123456790123456790123456787e-2 * t7 * t816 * t249 + 0.21053604230838734654992833002226418647411196189766e2 * t530 * t522 * t355 - 0.21687161765563048429332895106460084023374959038068e-1 * t438 * t514 * t684 - 0.41096000000000000000000000000000000000000000000000e0 * t438 * t749 * t770 + 0.38527556876111295841770998590264849926052512059102e1 * t438 * t39 * t698 * t700 - 0.68493333333333333333333333333333333333333333333332e-1 * t438 * t439 * t614 - 0.13012297059337829057599737063876050414024975422841e0 * t438 * t726 * t659 - 0.38024868119570572868450088421334803819557955882337e2 * t438 * t39 * t627 * t632 - 0.32530742648344572643999342659690126035062438557102e-1 * t438 * t734 * t525 - 0.10274000000000000000000000000000000000000000000000e0 * t438 * t742 * t461
  t896 = 0.17183429288218455501592100607892959377311762246310e1 * t438 * t67 * t502 * t505
  t900 = 0.21370000000000000000000000000000000000000000000000e0 * t438 * t67 * t483 * t485
  t908 = 0.71233333333333333333333333333333333333333333333332e-1 * t438 * t195 * t147 * t282
  t909 = t4 * t163
  t913 = 0.22161481481481481481481481481481481481481481481481e0 * t909 * t165 * t147 * t282
  t916 = 0.71233333333333333333333333333333333333333333333332e-1 * t438 * t478 * t233
  t920 = 0.68733717152873822006368402431571837509247048985239e1 * t438 * t39 * t704 * t706
  t924 = t102 ** 2
  t927 = 0.62070017646847402095774076540096717770467394091622e4 * t73 / t75 / t482 * t924 * t106
  t928 = t307 * t815
  t929 = t205 * t928
  t931 = t212 * t928
  t934 = t207 * t164 * t67
  t935 = t205 * t934
  t937 = t212 * t934
  t940 = 0.1e1 / t189 / r0
  t944 = t64 ** 2
  t949 = t22 * t944 * t940 + 0.2e1 * t193 * t940 - 0.2e1 * t38 * t940 - t65 * t940
  t951 = t51 * t97 * t949
  t953 = t84 * t949
  t954 = t4 * t953
  t956 = t6 * t814
  t957 = t956 * t815
  t958 = t4 * t957
  t960 = t67 ** 2
  t961 = t132 * t960
  t962 = t4 * t961
  t967 = t5 / t52 / t206 * t815
  t968 = t51 * t967
  t970 = t155 * t960
  t971 = t51 * t970
  t975 = t226 * t154 * t195 * t39
  t977 = t37 * t195
  t979 = t7 * t977 * t39
  t981 = t81 * t953
  t983 = t162 * t164
  t985 = t7 * t983 * t67
  t987 = t152 * t967
  t989 = t92 * t953
  t993 = t226 * t176 * t164 * t67
  t995 = 0.20255200000000000000000000000000000000000000000000e2 * t929 - 0.10921333333333333333333333333333333333333333333333e1 * t931 - 0.15191400000000000000000000000000000000000000000000e2 * t935 + 0.81910000000000000000000000000000000000000000000001e0 * t937 - 0.82156666666666666666666666666666666666666666666667e-1 * t951 - 0.29896666666666666666666666666666666666666666666667e0 * t954 + 0.31003950617283950617283950617283950617283950617285e1 * t958 + 0.11958666666666666666666666666666666666666666666667e1 * t962 + 0.13388493827160493827160493827160493827160493827161e1 * t968 + 0.41078333333333333333333333333333333333333333333334e0 * t971 + 0.54771111111111111111111111111111111111111111111112e0 * t975 + 0.15944888888888888888888888888888888888888888888889e1 * t979 - 0.63297500000000000000000000000000000000000000000000e0 * t981 - 0.55807111111111111111111111111111111111111111111112e1 * t985 - 0.75019259259259259259259259259259259259259259259258e1 * t987 - 0.10238750000000000000000000000000000000000000000000e0 * t989 - 0.21908444444444444444444444444444444444444444444444e1 * t993
  t996 = t174 * t970
  t998 = t92 * t957
  t1000 = t92 * t961
  t1002 = t152 * t970
  t1004 = t81 * t957
  t1006 = t81 * t961
  t1008 = t174 * t967
  t1010 = t39 * t195
  t1011 = t132 * t1010
  t1012 = t81 * t1011
  t1014 = t164 * t67
  t1015 = t177 * t1014
  t1016 = t174 * t1015
  t1018 = t152 * t1015
  t1020 = t155 * t1010
  t1021 = t174 * t1020
  t1023 = t163 * t1014
  t1024 = t92 * t1023
  t1026 = t92 * t1011
  t1034 = 0.1e1 / t35 / t306
  t1038 = t815 * t1 * t3 * t6
  t1039 = 0.1e1 / t44 / t111 * t1034 * t1038 / 0.48e2
  t1041 = t43 ** (-0.25e1)
  t1044 = t1041 * t2 * t1034 * t1038
  t1046 = t152 * t1020
  t1048 = t81 * t1023
  t1050 = 0.20477500000000000000000000000000000000000000000000e0 * t996 + 0.10617962962962962962962962962962962962962962962963e1 * t998 + 0.40955000000000000000000000000000000000000000000001e0 * t1000 - 0.12659500000000000000000000000000000000000000000000e1 * t1002 + 0.65641851851851851851851851851851851851851851851850e1 * t1004 + 0.25319000000000000000000000000000000000000000000000e1 * t1006 + 0.12134814814814814814814814814814814814814814814815e1 * t1008 + 0.33758666666666666666666666666666666666666666666667e1 * t1012 - 0.16382000000000000000000000000000000000000000000000e1 * t1016 + 0.10127600000000000000000000000000000000000000000000e2 * t1018 + 0.27303333333333333333333333333333333333333333333333e0 * t1021 - 0.19112333333333333333333333333333333333333333333334e1 * t1024 + 0.54606666666666666666666666666666666666666666666668e0 * t1026 - 0.21099166666666666666666666666666666666666666666667e1 * t1039 + 0.68258333333333333333333333333333333333333333333335e-1 * t1044 - 0.16879333333333333333333333333333333333333333333333e1 * t1046 - 0.11815533333333333333333333333333333333333333333333e2 * t1048
  t1054 = 0.10000000000000000000000000000000000000000000000000e1 * t148 * (t995 + t1050) * t232
  t1055 = t498 ** 2
  t1058 = 0.48245472966453314463992795342703676305040043742564e2 * t503 * t1055 * t504
  t1059 = t75 ** 2
  t1062 = t104 ** 2
  t1066 = 0.24954977986735470914321699422701391789612506067521e5 * t73 / t1059 * t924 / t1062
  t1070 = t896 - t900 + 0.13218398198777742039240913477002251527822450948858e2 * t438 * t39 * t774 * t776 + t908 + t913 + t916 - t920 + t927 - t1054 - t1058 - t1066 - 0.46785787179641632566650740004947596994247102643924e1 * t520 * t684 * t295
  t1071 = t141 * t39
  t1102 = 0.37650400000000000000000000000000000000000000000000e2 * t929 - 0.22441333333333333333333333333333333333333333333332e1 * t931 - 0.28237800000000000000000000000000000000000000000000e2 * t935 + 0.16831000000000000000000000000000000000000000000000e1 * t937 - 0.10419500000000000000000000000000000000000000000000e0 * t951 - 0.51647500000000000000000000000000000000000000000000e0 * t954 + 0.53560370370370370370370370370370370370370370370370e1 * t958 + 0.20659000000000000000000000000000000000000000000000e1 * t962 + 0.16979925925925925925925925925925925925925925925926e1 * t968 + 0.52097499999999999999999999999999999999999999999999e0 * t971 + 0.69463333333333333333333333333333333333333333333332e0 * t975 + 0.27545333333333333333333333333333333333333333333333e1 * t979 - 0.11765750000000000000000000000000000000000000000000e1 * t981 - 0.96408666666666666666666666666666666666666666666666e1 * t985 - 0.13944592592592592592592592592592592592592592592593e2 * t987 - 0.21038750000000000000000000000000000000000000000000e0 * t989 - 0.27785333333333333333333333333333333333333333333332e1 * t993
  t1120 = 0.42077499999999999999999999999999999999999999999999e0 * t996 + 0.21817962962962962962962962962962962962962962962963e1 * t998 + 0.84155000000000000000000000000000000000000000000001e0 * t1000 - 0.23531500000000000000000000000000000000000000000000e1 * t1002 + 0.12201518518518518518518518518518518518518518518519e2 * t1004 + 0.47063000000000000000000000000000000000000000000001e1 * t1006 + 0.24934814814814814814814814814814814814814814814815e1 * t1008 + 0.62750666666666666666666666666666666666666666666668e1 * t1012 - 0.33661999999999999999999999999999999999999999999999e1 * t1016 + 0.18825200000000000000000000000000000000000000000000e2 * t1018 + 0.56103333333333333333333333333333333333333333333332e0 * t1021 - 0.39272333333333333333333333333333333333333333333334e1 * t1024 + 0.11220666666666666666666666666666666666666666666667e1 * t1026 - 0.39219166666666666666666666666666666666666666666667e1 * t1039 + 0.14025833333333333333333333333333333333333333333333e0 * t1044 - 0.31375333333333333333333333333333333333333333333333e1 * t1046 - 0.21962733333333333333333333333333333333333333333334e2 * t1048
  t1125 = t528 ** 2
  t1126 = 0.1e1 / t1125
  t1128 = t521 ** 2
  t1129 = t531 ** 2
  t1130 = 0.1e1 / t1129
  t1151 = 0.27618666666666666666666666666666666666666666666667e2 * t929 - 0.58684000000000000000000000000000000000000000000000e0 * t931 - 0.20714000000000000000000000000000000000000000000000e2 * t935 + 0.44013000000000000000000000000000000000000000000000e0 * t937 - 0.82785000000000000000000000000000000000000000000000e-1 * t951 - 0.30192500000000000000000000000000000000000000000000e0 * t954 + 0.31310740740740740740740740740740740740740740740741e1 * t958 + 0.12077000000000000000000000000000000000000000000000e1 * t962 + 0.13490888888888888888888888888888888888888888888889e1 * t968 + 0.41392500000000000000000000000000000000000000000000e0 * t971 + 0.55190000000000000000000000000000000000000000000000e0 * t975 + 0.16102666666666666666666666666666666666666666666667e1 * t979 - 0.86308333333333333333333333333333333333333333333334e0 * t981 - 0.56359333333333333333333333333333333333333333333334e1 * t985 - 0.10229135802469135802469135802469135802469135802469e2 * t987 - 0.55016250000000000000000000000000000000000000000000e-1 * t989 - 0.22076000000000000000000000000000000000000000000000e1 * t993
  t1169 = 0.11003250000000000000000000000000000000000000000000e0 * t996 + 0.57053888888888888888888888888888888888888888888890e0 * t998 + 0.22006500000000000000000000000000000000000000000000e0 * t1000 - 0.17261666666666666666666666666666666666666666666667e1 * t1002 + 0.89504938271604938271604938271604938271604938271607e1 * t1004 + 0.34523333333333333333333333333333333333333333333334e1 * t1006 + 0.65204444444444444444444444444444444444444444444445e0 * t1008 + 0.46031111111111111111111111111111111111111111111112e1 * t1012 - 0.88026000000000000000000000000000000000000000000000e0 * t1016 + 0.13809333333333333333333333333333333333333333333334e2 * t1018 + 0.14671000000000000000000000000000000000000000000000e0 * t1021 - 0.10269700000000000000000000000000000000000000000000e1 * t1024 + 0.29342000000000000000000000000000000000000000000000e0 * t1026 - 0.28769444444444444444444444444444444444444444444444e1 * t1039 + 0.36677500000000000000000000000000000000000000000000e-1 * t1044 - 0.23015555555555555555555555555555555555555555555556e1 * t1046 - 0.16110888888888888888888888888888888888888888888889e2 * t1048
  t1170 = t1151 + t1169
  t1176 = 0.57894567559743977356791354411244411566048052491077e3 * t78 * t924 * t504
  t1184 = t460 ** 2
  t1188 = t355 ** 2
  t1192 = -0.97661626862683519686971893243411050374062115540228e-3 * t7 * t977 * t1071 + 0.34181569401939231890440162635193867630921740439080e-2 * t7 * t983 * t142 - 0.28392769777777777777777777777777777777777777777776e-2 * t7 * t977 * t249 * t39 + 0.99374694222222222222222222222222222222222222222216e-2 * t7 * t983 * t586 + 0.99999999999999999999999999999999999999999999999999e0 * t269 * (t1102 + t1120) * t275 + 0.91080982599109921218848830805163797795664001346962e5 * t255 * t1126 * t1128 * t1130 + 0.58482233974552040708313425006184496242808878304903e0 * t290 * t1170 * t296 - t1176 - 0.11579285944033451270504985525892569958185911868768e4 * t775 * t469 * t460 + 0.12865873271148279189449983917658411064651013187520e3 * t466 * t613 * t468 * t274 - 0.60000000000000000000000000000000000000000000000000e1 * t445 * t1184 * t275 - 0.35089340384731224424988055003710697745685326982943e1 * t520 * t1188 * t296
  t1200 = 0.10685000000000000000000000000000000000000000000000e0 * t438 * t716 * t499
  t1211 = 0.28493333333333333333333333333333333333333333333334e0 * t568 * t164 * t483 * t485
  t1214 = 0.14246666666666666666666666666666666666666666666666e0 * t568 * t712 * t499
  t1217 = 0.42740000000000000000000000000000000000000000000000e0 * t438 * t573 * t662
  t1221 = 0.36845452142031360632963667101718523854302450326054e2 * t438 * t39 * t77 * t107
  t1238 = 0.11579285944033451270504985525892569958185911868768e4 * t619 * t851 * t468 + t1200 - 0.33045995496944355098102283692505628819556127372144e1 * t438 * t67 * t465 * t469 + 0.43374323531126096858665790212920168046749918076136e-1 * t568 * t730 * t525 + t1211 - t1214 + t1217 + t1221 - 0.86748647062252193717331580425840336093499836152272e-1 * t568 * t164 * t519 * t522 + 0.44061327329259140130803044923340838426074836496192e1 * t568 * t164 * t465 * t469 + 0.12842518958703765280590332863421616642017504019700e1 * t568 * t164 * t529 * t533 - 0.27397333333333333333333333333333333333333333333333e0 * t568 * t164 * t444 * t447
  t1242 = 0.22911239050957940668789467477190612503082349661746e1 * t568 * t164 * t502 * t505
  t1280 = 0.80000000000000000000000000000000000000000000000000e1 * t484 * t282 * t231
  t1283 = 0.57894567559743977356791354411244411566048052491077e3 * t705 * t505 * t498
  t1284 = -t1242 + 0.13698666666666666666666666666666666666666666666666e0 * t568 * t753 * t461 + 0.20548000000000000000000000000000000000000000000000e0 * t438 * t67 * t444 * t447 - 0.96318892190278239604427496475662124815131280147753e0 * t438 * t67 * t529 * t533 + 0.65061485296689145287998685319380252070124877114204e-1 * t438 * t67 * t519 * t522 - 0.14172186339420759128595382735072640214240860886520e3 * t438 * t39 * t618 * t623 - 0.21687161765563048429332895106460084023374959038068e-1 * t438 * t195 * t289 * t297 - 0.67471169937307261780146784775653594739388761451767e-1 * t909 * t165 * t289 * t297 - 0.68493333333333333333333333333333333333333333333332e-1 * t438 * t195 * t268 * t276 - 0.21309037037037037037037037037037037037037037037036e0 * t909 * t165 * t268 * t276 + t1280 + t1283
  t1289 = t464 ** 2
  t1292 = t467 ** 2
  t1297 = t355 * t631
  t1304 = 0.59059081777777777777777777777777777777777777777776e-2 * t7 * t977 * t61 * t39
  t1307 = 0.20670678622222222222222222222222222222222222222222e-1 * t7 * t983 * t68
  t1309 = 0.1e1 / t528 / t518
  t1317 = 0.64327297288604419285323727123604901740053391656752e2 * t503 * t231 * t504 * t101
  t1320 = 0.60000000000000000000000000000000000000000000000000e1 * t484 * t1055 * t232
  t1321 = t83 * t949
  t1324 = 0.11073577833333333333333333333333333333333333333333e-2 * t7 * t1321 * t61
  t1325 = t37 * t960
  t1335 = 0.51947267698127589899017076750918898776700016259463e2 * t530 * t1188 * t532 + 0.19965908856856833623520686708731068173688999255505e6 * t240 / t1289 * t851 / t1292 + 0.61523382126046769584908008232272042135015119629847e4 * t628 * t1297 * t521 + t1304 - t1307 - 0.12304676425209353916981601646454408427003023925970e5 * t255 * t1309 * t1128 * t631 - t1317 + t1320 - t1324 - 0.21294577333333333333333333333333333333333333333332e-2 * t7 * t1325 * t249 - 0.73246220147012639765228919932558287780546586655171e-3 * t7 * t1325 * t141 + 0.18311555036753159941307229983139571945136646663793e-3 * t7 * t1321 * t141
  t1341 = 0.36000000000000000000000000000000000000000000000000e2 * t503 * t485 * t498
  t1345 = 0.31035008823423701047887038270048358885233697045812e4 * t78 * t102 * t106 * t498
  t1358 = 0.44294311333333333333333333333333333333333333333332e-2 * t7 * t1325 * t61
  t1367 = 0.24000000000000000000000000000000000000000000000000e2 * t705 * t924 * t232
  t1377 = 0.53236443333333333333333333333333333333333333333332e-3 * t7 * t1321 * t249 - t1341 - t1345 + 0.12414802127193579147105162995488978190399819737073e5 * t619 * t446 * t622 * t460 + 0.36000000000000000000000000000000000000000000000000e2 * t466 * t447 * t460 + 0.62336721237753107878820492101102678532040019511358e3 * t628 * t1128 * t532 + t1358 - 0.24829604254387158294210325990977956380799639474146e5 * t240 / t464 / t443 * t851 * t622 + t1367 - 0.14035736153892489769995222001484279098274130793177e2 * t699 * t1128 * t296 + 0.96494049533612093920874879382438082984882598906400e2 * t466 * t1184 * t468 - 0.80000000000000000000000000000000000000000000000000e1 * t445 * t276 * t613
  t1383 = -0.20778907079251035959606830700367559510680006503785e3 * t330 * t544 + 0.4e1 * t547 * t425 * t300 - 0.34181569401939231890440162635193867630921740439080e-2 * t131 * t163 * t142 * t164 + 0.29298488058805055906091567973023315112218634662068e-2 * t555 * t144 + 0.97661626862683519686971893243411050374062115540228e-3 * t131 * t132 * t558 * t39 + t567 + t572 - t578 + 0.120e3 * t582 * t583 - 0.16e2 * t362 * t783 - 0.48e2 * t799 * t800 + 0.16e2 * t428 * t424 * t804 - 0.16e2 * t361 * t424 * t804 + 0.72e2 * t237 * t798 * t323 - t819 + 0.24e2 * t820 * t130 * t258 + t547 * t130 * (t855 + t891 + t1070 + t1192 + t1238 + t1284 + t1335 + t1377) - t896
  t1384 = t361 * t321
  t1387 = t537 * t67
  t1390 = t305 * t580
  t1391 = t1390 * t125
  t1392 = t301 * t165
  t1395 = t130 * t255
  t1400 = t301 * t156
  t1403 = t798 * t129
  t1407 = t113 ** 2
  t1410 = t373 ** 2
  t1416 = t387 ** 2
  t1431 = t110 * t307
  t1441 = 0.36e2 * t67 * t382 * t164 - 0.8e1 * t195 * t310 * t39 + 0.8e1 * t383 * t1010 - 0.36e2 * t396 * t1014 + t949 * t111 + 0.24e2 * t1431 * t815 - 0.6e1 * t960 * t310 - t311 * t949 + 0.6e1 * t383 * t960 - 0.24e2 * t820
  t1445 = f.my_piecewise3(t114, 0, 0.40e2 / 0.81e2 / t370 / t1407 * t1410 - 0.16e2 / 0.9e1 * t372 * t373 * t387 + 0.4e1 / 0.3e1 * t377 * t1416 + 0.16e2 / 0.9e1 * t378 * t402 + 0.4e1 / 0.3e1 * t117 * t1441)
  t1446 = t120 ** 2
  t1449 = t410 ** 2
  t1455 = t416 ** 2
  t1464 = f.my_piecewise3(t121, 0, 0.40e2 / 0.81e2 / t407 / t1446 * t1449 - 0.16e2 / 0.9e1 * t409 * t410 * t416 + 0.4e1 / 0.3e1 * t414 * t1455 + 0.16e2 / 0.9e1 * t415 * t419 - 0.4e1 / 0.3e1 * t122 * t1441)
  t1466 = (t1445 + t1464) * t129
  t1469 = t130 * t7
  t1482 = t900 - t908 - t913 - t916 + t920 - 0.48e2 * t1384 * t538 + 0.24e2 * t429 * t1387 + 0.960e3 * t1391 * t1392 - 0.69263023597503453198689435667891865035600021679284e2 * t1395 * t529 * t683 * t543 + 0.144e3 * t238 * t1400 - t927 + t1054 + 0.6e1 * t547 * t1403 * t536 + t547 * t1466 * t258 + t1058 - 0.86748647062252193717331580425840336093499836152272e-1 * t1469 * t40 * t289 * t837 - 0.13012297059337829057599737063876050414024975422841e0 * t1469 * t263 * t519 * t640 + 0.19263778438055647920885499295132424963026256029551e1 * t1469 * t263 * t529 * t636 + t1066
  t1486 = t428 * t321
  t1493 = t289 * t295 * t296
  t1497 = t519 * t521 * t296
  t1502 = t529 * t629 * t296
  t1512 = 0.1e1 / t206 / t160
  t1513 = t360 * t1512
  t1514 = t1513 * t125
  t1518 = t259 * t815
  t1530 = t259 * t165
  t1536 = 0.72e2 * t238 * t583 + 0.48e2 * t1486 * t538 + 0.16e2 * t429 * t783 - 0.23392893589820816283325370002473798497123551321961e1 * t425 * t255 * t1493 + 0.86748647062252193717331580425840336093499836152272e-1 * t1469 * t430 * t1497 + 0.13012297059337829057599737063876050414024975422841e0 * t1469 * t263 * t1502 + 0.67471169937307261780146784775653594739388761451767e-1 * t1469 * t648 * t1493 + 0.19751789702565206228825776161588751761046270558698e-1 * t1466 * t256 - 0.480e3 * t1514 * t1392 - 0.384e3 * t1431 * t125 * t1518 + 0.1440e4 * t236 * t580 * t125 * t1518 - 0.48e2 * t1384 * t363 - 0.24e2 * t362 * t1387 - 0.480e3 * t1513 * t321 * t1530 + t1176 + 0.4e1 * t547 * t329 * t781 - t1200 - t1211 + t1214
  t1537 = t329 * t7
  t1538 = t430 * t1493
  t1541 = t263 * t1497
  t1547 = t529 * t521
  t1548 = t1547 * t532
  t1553 = t698 * t629 * t532
  t1558 = t627 * t629 * t631
  t1569 = t263 * t1493
  t1572 = t434 * t1493
  t1575 = t263 * t357
  t1578 = t263 * t1548
  t1585 = t289 * t683 * t296
  t1589 = -t1217 - t1221 + t1242 - t1280 - t1283 - 0.86748647062252193717331580425840336093499836152272e-1 * t1537 * t1538 - 0.13012297059337829057599737063876050414024975422841e0 * t1537 * t1541 - 0.43374323531126096858665790212920168046749918076136e-1 * t1469 * t430 * t357 - 0.12842518958703765280590332863421616642017504019700e1 * t1469 * t430 * t1548 - 0.38527556876111295841770998590264849926052512059102e1 * t1469 * t263 * t1553 + 0.38024868119570572868450088421334803819557955882337e2 * t1469 * t263 * t1558 - 0.65061485296689145287998685319380252070124877114204e-1 * t1469 * t434 * t1497 + 0.21687161765563048429332895106460084023374959038068e-1 * t1469 * t366 * t1493 + 0.65061485296689145287998685319380252070124877114204e-1 * t1403 * t7 * t1569 + 0.65061485296689145287998685319380252070124877114204e-1 * t1537 * t1572 + 0.65061485296689145287998685319380252070124877114204e-1 * t1537 * t1575 + 0.19263778438055647920885499295132424963026256029551e1 * t1537 * t1578 + 0.32530742648344572643999342659690126035062438557102e-1 * t1469 * t434 * t357 + 0.21687161765563048429332895106460084023374959038068e-1 * t1469 * t263 * t1585
  t1595 = t237 * t321
  t1604 = t236 * t307
  t1605 = t1604 * t125
  t1606 = t259 * t1014
  t1611 = t396 * t125
  t1616 = t581 * t321
  t1619 = t259 * t1010
  t1638 = t519 * t355 * t297
  t1641 = 0.96318892190278239604427496475662124815131280147753e0 * t1469 * t434 * t1548 + 0.144e3 * t1595 * t302 - 0.91080982599109921218848830805163797795664001346962e5 * t1395 * t1126 * t1128 * t1130 + 0.144e3 * t1595 * t260 - 0.864e3 * t1605 * t1606 + 0.1440e4 * t1391 * t1606 + 0.144e3 * t1611 * t1606 - 0.384e3 * t322 * t260 + 0.240e3 * t1616 * t260 + 0.48e2 * t238 * t1619 - 0.128e3 * t326 * t1619 + 0.62336721237753107878820492101102678532040019511357e3 * t1395 * t698 * t521 * t635 - 0.21053604230838734654992833002226418647411196189766e2 * t1395 * t1547 * t525 - 0.384e3 * t326 * t1400 + 0.240e3 * t582 * t1400 + 0.80e2 * t582 * t1619 + 0.14035736153892489769995222001484279098274130793177e2 * t330 * t1638 - t1304
  t1660 = t1403 * t255
  t1667 = t206 ** 2
  t1673 = t259 * t949
  t1680 = t428 * t798
  t1681 = t259 * t67
  t1691 = t1307 + 0.46785787179641632566650740004947596994247102643924e1 * t1395 * t519 * t683 * t297 - 0.61523382126046769584908008232272042135015119629847e4 * t1395 * t627 * t521 * t1297 - 0.720e3 * t1514 * t1606 - 0.41015588084031179723272005488181361423343413086566e4 * t330 * t1558 - 0.51947267698127589899017076750918898776700016259463e2 * t1395 * t529 * t1188 * t532 + t1317 - 0.192e3 * t326 * t583 + 0.70178680769462448849976110007421395491370653965885e1 * t1660 * t1497 - 0.1920e4 * t305 * t1512 * t125 * t1518 + 0.840e3 * t360 / t1667 * t125 * t1518 - t1320 - 0.4e1 * t362 * t1673 - 0.35089340384731224424988055003710697745685326982942e1 * t1660 * t357 - 0.10389453539625517979803415350183779755340003251893e3 * t1660 * t1548 + 0.24e2 * t1680 * t1681 + 0.96e2 * t1611 * t1392 + 0.48e2 * t1680 * t800 + 0.120e3 * t581 * t798 * t323
  t1696 = t259 * t195
  t1705 = t301 * t195
  t1734 = -0.192e3 * t308 * t798 * t323 - 0.16e2 * t1384 * t1696 + 0.16e2 * t1486 * t1696 - 0.58482233974552040708313425006184496242808878304903e0 * t1395 * t289 * t1170 * t296 + t1324 + 0.16e2 * t429 * t1705 + 0.96e2 * t396 * t321 * t1530 - 0.576e3 * t1604 * t321 * t1530 + t1341 + t1345 - 0.16e2 * t362 * t1705 + 0.4e1 * t429 * t1673 - 0.23392893589820816283325370002473798497123551321961e1 * t330 * t1585 + 0.240e3 * t1616 * t302 - 0.24e2 * t799 * t1681 + 0.48e2 * t1486 * t363 - 0.384e3 * t322 * t302 + 0.12304676425209353916981601646454408427003023925970e5 * t1395 * t1309 * t1128 * t631 - 0.14035736153892489769995222001484279098274130793177e2 * t330 * t1502
  t1755 = t163 * t165 * t141
  t1758 = t1403 * t4
  t1759 = t84 * t142
  t1763 = t132 * t164 * t141
  t1766 = t84 * t558
  t1774 = t84 * t1071
  t1781 = t259 * t960
  t1792 = 0.41557814158502071919213661400735119021360013007572e3 * t330 * t1553 - t1358 + 0.14035736153892489769995222001484279098274130793177e2 * t1395 * t698 * t1128 * t296 + 0.960e3 * t1390 * t321 * t1530 - 0.62336721237753107878820492101102678532040019511358e3 * t1395 * t627 * t1128 * t532 - 0.576e3 * t1605 * t1392 - t1367 + 0.18989760778855128828022312575107704239400966910600e-2 * t131 * t956 * t815 * t141 - 0.22787712934626154593626775090129245087281160292720e-2 * t555 * t1755 - 0.10986933022051895964784337989883743167081987998276e-2 * t1758 * t1759 + 0.14649244029402527953045783986511657556109317331034e-2 * t1758 * t1763 - 0.73246220147012639765228919932558287780546586655172e-3 * t555 * t1766 - 0.18311555036753159941307229983139571945136646663793e-3 * t131 * t84 * t949 * t141 - 0.73246220147012639765228919932558287780546586655172e-3 * t425 * t4 * t1774 + 0.73246220147012639765228919932558287780546586655171e-3 * t131 * t132 * t960 * t141 - 0.96e2 * t326 * t1781 + 0.60e2 * t582 * t1781 + 0.36e2 * t238 * t1781 + 0.35089340384731224424988055003710697745685326982943e1 * t1395 * t519 * t1188 * t296
  t1801 = -0.17717724533333333333333333333333333333333333333333e-1 * t70 + 0.20690005882282467365258025513365572590155798030541e4 * t108 + 0.29298488058805055906091567973023315112218634662068e-2 * t131 * t144 + 0.40000000000000000000000000000000000000000000000000e1 * t234 + 0.144e3 * t238 * t260 + 0.144e3 * t238 * t302 - 0.384e3 * t322 * t323 - 0.384e3 * t326 * t302 - 0.70178680769462448849976110007421395491370653965885e1 * t330 * t357 - 0.48e2 * t362 * t363 + 0.44294311333333333333333333333333333333333333333332e-2 * t368 + 0.79007158810260824915303104646355007044185082234792e-1 * t425 * t256 + 0.48e2 * t429 * t538 + (r0 + r1) * (t1383 + t1482 + t1536 + t1589 + t1641 + t1691 + t1734 + t1792) + 0.65061485296689145287998685319380252070124877114204e-1 * t1469 * t1575 + 0.19263778438055647920885499295132424963026256029551e1 * t1469 * t1578
  t1836 = -0.13012297059337829057599737063876050414024975422841e0 * t1469 * t1541 - 0.86748647062252193717331580425840336093499836152272e-1 * t1469 * t1538 + 0.65061485296689145287998685319380252070124877114204e-1 * t1469 * t1572 + 0.13012297059337829057599737063876050414024975422841e0 * t1537 * t1569 + 0.24000000000000000000000000000000000000000000000000e2 * t663 - 0.20778907079251035959606830700367559510680006503785e3 * t1395 * t544 + 0.14035736153892489769995222001484279098274130793177e2 * t1395 * t1638 - 0.384e3 * t326 * t260 + 0.240e3 * t582 * t260 + 0.19298189186581325785597118137081470522016017497025e3 * t687 + 0.13780452414814814814814814814814814814814814814815e-1 * t693 - 0.38596378373162651571194236274162941044032034994052e3 * t707 + 0.4e1 * t547 * t130 * t781 + 0.12e2 * t547 * t1403 * t300 + 0.4e1 * t547 * t425 * t258 + 0.12e2 * t547 * t329 * t536 - 0.48e2 * t362 * t538
  t1866 = 0.42740000000000000000000000000000000000000000000000e0 * t710 + 0.28493333333333333333333333333333333333333333333334e0 * t714 - 0.21370000000000000000000000000000000000000000000000e0 * t718 - 0.21370000000000000000000000000000000000000000000000e0 * t721 - 0.34366858576436911003184201215785918754623524492620e1 * t724 - 0.24000000000000000000000000000000000000000000000000e2 * t765 - 0.96e2 * t1384 * t800 - 0.480e3 * t1514 * t1530 + 0.48e2 * t1680 * t804 - 0.48e2 * t799 * t804 + 0.96e2 * t1611 * t1530 - 0.576e3 * t1605 * t1530 - 0.48e2 * t1384 * t1681 + 0.16e2 * t429 * t1696 - 0.23392893589820816283325370002473798497123551321961e1 * t1395 * t1585 - 0.16e2 * t362 * t1696 + 0.960e3 * t1391 * t1530
  t1901 = 0.96e2 * t1486 * t800 + 0.48e2 * t429 * t363 + 0.41557814158502071919213661400735119021360013007572e3 * t1395 * t1553 - 0.14035736153892489769995222001484279098274130793177e2 * t1395 * t1502 - 0.70178680769462448849976110007421395491370653965885e1 * t1660 * t1493 + 0.29298488058805055906091567973023315112218634662069e-2 * t555 * t1763 - 0.22787712934626154593626775090129245087281160292720e-2 * t131 * t1755 - 0.21973866044103791929568675979767486334163975996552e-2 * t1758 * t1774 - 0.21973866044103791929568675979767486334163975996552e-2 * t555 * t1759 - 0.73246220147012639765228919932558287780546586655172e-3 * t131 * t1766 - 0.20778907079251035959606830700367559510680006503786e3 * t330 * t1548 - 0.41015588084031179723272005488181361423343413086566e4 * t1395 * t1558 + 0.14035736153892489769995222001484279098274130793177e2 * t330 * t1497 + 0.144e3 * t1595 * t323 + 0.240e3 * t1616 * t323 + 0.240e3 * t582 * t302 + 0.48e2 * t1486 * t1681
  d1111 = t1801 + t1836 + t1866 + t1901

  res = {'v4rho4': d1111}
  return res
