"""Generated from mgga_x_gvt4.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  gvt4_alpha = 0.00186726

  gvt4_coeff_d = np.array([np.nan, -0.9800683, -0.003556788, 0.006250326, -2.354518e-05, -0.0001282732, 0.0003574822], dtype=np.float64)

  gvt4_gamm = lambda alpha, x, z: 1 + alpha * (x ** 2 + z)

  gtv4 = lambda alpha, dd, x, z: dd[1] / gvt4_gamm(alpha, x, z) + (dd[2] * x ** 2 + dd[3] * z) / gvt4_gamm(alpha, x, z) ** 2 + (dd[4] * x ** 4 + dd[5] * x ** 2 * z + dd[6] * z ** 2) / gvt4_gamm(alpha, x, z) ** 3

  gvt4_f = lambda x, u, t: -gtv4(gvt4_alpha, gvt4_coeff_d, x, 2 * (t - K_FACTOR_C)) / X_FACTOR_C

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, gvt4_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  gvt4_alpha = 0.00186726

  gvt4_coeff_d = np.array([np.nan, -0.9800683, -0.003556788, 0.006250326, -2.354518e-05, -0.0001282732, 0.0003574822], dtype=np.float64)

  gvt4_gamm = lambda alpha, x, z: 1 + alpha * (x ** 2 + z)

  gtv4 = lambda alpha, dd, x, z: dd[1] / gvt4_gamm(alpha, x, z) + (dd[2] * x ** 2 + dd[3] * z) / gvt4_gamm(alpha, x, z) ** 2 + (dd[4] * x ** 4 + dd[5] * x ** 2 * z + dd[6] * z ** 2) / gvt4_gamm(alpha, x, z) ** 3

  gvt4_f = lambda x, u, t: -gtv4(gvt4_alpha, gvt4_coeff_d, x, 2 * (t - K_FACTOR_C)) / X_FACTOR_C

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, gvt4_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  gvt4_alpha = 0.00186726

  gvt4_coeff_d = np.array([np.nan, -0.9800683, -0.003556788, 0.006250326, -2.354518e-05, -0.0001282732, 0.0003574822], dtype=np.float64)

  gvt4_gamm = lambda alpha, x, z: 1 + alpha * (x ** 2 + z)

  gtv4 = lambda alpha, dd, x, z: dd[1] / gvt4_gamm(alpha, x, z) + (dd[2] * x ** 2 + dd[3] * z) / gvt4_gamm(alpha, x, z) ** 2 + (dd[4] * x ** 4 + dd[5] * x ** 2 * z + dd[6] * z ** 2) / gvt4_gamm(alpha, x, z) ** 3

  gvt4_f = lambda x, u, t: -gtv4(gvt4_alpha, gvt4_coeff_d, x, 2 * (t - K_FACTOR_C)) / X_FACTOR_C

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, gvt4_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 <= f.p.dens_threshold
  t2 = jnp.pi ** (0.1e1 / 0.3e1)
  t3 = 0.1e1 / t2
  t4 = r0 + r1
  t5 = 0.1e1 / t4
  t8 = 0.2e1 * r0 * t5 <= f.p.zeta_threshold
  t9 = f.p.zeta_threshold - 0.1e1
  t12 = 0.2e1 * r1 * t5 <= f.p.zeta_threshold
  t13 = -t9
  t14 = r0 - r1
  t15 = t14 * t5
  t16 = f.my_piecewise5(t8, t9, t12, t13, t15)
  t17 = 0.1e1 + t16
  t18 = t17 <= f.p.zeta_threshold
  t19 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t20 = t19 * f.p.zeta_threshold
  t21 = t17 ** (0.1e1 / 0.3e1)
  t23 = f.my_piecewise3(t18, t20, t21 * t17)
  t24 = t3 * t23
  t25 = t4 ** (0.1e1 / 0.3e1)
  t26 = t24 * t25
  t27 = r0 ** 2
  t28 = r0 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t31 = 0.1e1 / t29 / t27
  t32 = s0 * t31
  t35 = 0.1e1 / t29 / r0
  t36 = tau0 * t35
  t38 = 6 ** (0.1e1 / 0.3e1)
  t39 = t38 ** 2
  t40 = jnp.pi ** 2
  t41 = t40 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t43 = t39 * t42
  t44 = 0.11203560000000000000000000000000000000000000000000e-2 * t43
  t45 = 0.1e1 + 0.186726e-2 * t32 + 0.373452e-2 * t36 - t44
  t50 = 0.37501956000000000000000000000000000000000000000000e-2 * t43
  t51 = -0.3556788e-2 * t32 + 0.12500652e-1 * t36 - t50
  t52 = t45 ** 2
  t53 = 0.1e1 / t52
  t55 = s0 ** 2
  t56 = t27 ** 2
  t59 = 0.1e1 / t28 / t56 / r0
  t63 = 0.3e1 / 0.5e1 * t43
  t64 = 0.2e1 * t36 - t63
  t67 = t64 ** 2
  t69 = -0.2354518e-4 * t55 * t59 - 0.1282732e-3 * t32 * t64 + 0.3574822e-3 * t67
  t71 = 0.1e1 / t52 / t45
  t75 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t76 = 0.1e1 / t75
  t78 = 4 ** (0.1e1 / 0.3e1)
  t79 = (-0.9800683e0 / t45 + t51 * t53 + t69 * t71) * t76 * t78
  t82 = f.my_piecewise3(t1, 0, t26 * t79 / 0.4e1)
  t83 = r1 <= f.p.dens_threshold
  t84 = f.my_piecewise5(t12, t9, t8, t13, -t15)
  t85 = 0.1e1 + t84
  t86 = t85 <= f.p.zeta_threshold
  t87 = t85 ** (0.1e1 / 0.3e1)
  t89 = f.my_piecewise3(t86, t20, t87 * t85)
  t90 = t3 * t89
  t91 = t90 * t25
  t92 = r1 ** 2
  t93 = r1 ** (0.1e1 / 0.3e1)
  t94 = t93 ** 2
  t96 = 0.1e1 / t94 / t92
  t97 = s2 * t96
  t100 = 0.1e1 / t94 / r1
  t101 = tau1 * t100
  t103 = 0.1e1 + 0.186726e-2 * t97 + 0.373452e-2 * t101 - t44
  t108 = -0.3556788e-2 * t97 + 0.12500652e-1 * t101 - t50
  t109 = t103 ** 2
  t110 = 0.1e1 / t109
  t112 = s2 ** 2
  t113 = t92 ** 2
  t116 = 0.1e1 / t93 / t113 / r1
  t120 = 0.2e1 * t101 - t63
  t123 = t120 ** 2
  t125 = -0.2354518e-4 * t112 * t116 - 0.1282732e-3 * t97 * t120 + 0.3574822e-3 * t123
  t127 = 0.1e1 / t109 / t103
  t131 = (-0.9800683e0 / t103 + t108 * t110 + t125 * t127) * t76 * t78
  t134 = f.my_piecewise3(t83, 0, t91 * t131 / 0.4e1)
  t135 = t4 ** 2
  t137 = t14 / t135
  t138 = t5 - t137
  t139 = f.my_piecewise5(t8, 0, t12, 0, t138)
  t142 = f.my_piecewise3(t18, 0, 0.4e1 / 0.3e1 * t21 * t139)
  t147 = t25 ** 2
  t148 = 0.1e1 / t147
  t151 = t24 * t148 * t79 / 0.12e2
  t155 = s0 / t29 / t27 / r0
  t157 = tau0 * t31
  t159 = -0.49793600000000000000000000000000000000000000000000e-2 * t155 - 0.62242000000000000000000000000000000000000000000000e-2 * t157
  t166 = t51 * t71
  t176 = s0 * t59
  t184 = t52 ** 2
  t186 = t69 / t184
  t195 = f.my_piecewise3(t1, 0, t3 * t142 * t25 * t79 / 0.4e1 + t151 + t26 * (0.9800683e0 * t53 * t159 + (0.94847680000000000000000000000000000000000000000000e-2 * t155 - 0.20834420000000000000000000000000000000000000000000e-1 * t157) * t53 - 0.2e1 * t166 * t159 + (0.12557429333333333333333333333333333333333333333333e-3 * t55 / t28 / t56 / t27 + 0.34206186666666666666666666666666666666666666666667e-3 * t155 * t64 + 0.42757733333333333333333333333333333333333333333333e-3 * t176 * tau0 - 0.23832146666666666666666666666666666666666666666667e-2 * t64 * tau0 * t31) * t71 - 0.3e1 * t186 * t159) * t76 * t78 / 0.4e1)
  t197 = f.my_piecewise5(t12, 0, t8, 0, -t138)
  t200 = f.my_piecewise3(t86, 0, 0.4e1 / 0.3e1 * t87 * t197)
  t207 = t90 * t148 * t131 / 0.12e2
  t209 = f.my_piecewise3(t83, 0, t3 * t200 * t25 * t131 / 0.4e1 + t207)
  vrho_0_ = t82 + t134 + t4 * (t195 + t209)
  t212 = -t5 - t137
  t213 = f.my_piecewise5(t8, 0, t12, 0, t212)
  t216 = f.my_piecewise3(t18, 0, 0.4e1 / 0.3e1 * t21 * t213)
  t222 = f.my_piecewise3(t1, 0, t3 * t216 * t25 * t79 / 0.4e1 + t151)
  t224 = f.my_piecewise5(t12, 0, t8, 0, -t212)
  t227 = f.my_piecewise3(t86, 0, 0.4e1 / 0.3e1 * t87 * t224)
  t235 = s2 / t94 / t92 / r1
  t237 = tau1 * t96
  t239 = -0.49793600000000000000000000000000000000000000000000e-2 * t235 - 0.62242000000000000000000000000000000000000000000000e-2 * t237
  t246 = t108 * t127
  t256 = s2 * t116
  t264 = t109 ** 2
  t266 = t125 / t264
  t275 = f.my_piecewise3(t83, 0, t3 * t227 * t25 * t131 / 0.4e1 + t207 + t91 * (0.9800683e0 * t110 * t239 + (0.94847680000000000000000000000000000000000000000000e-2 * t235 - 0.20834420000000000000000000000000000000000000000000e-1 * t237) * t110 - 0.2e1 * t246 * t239 + (0.12557429333333333333333333333333333333333333333333e-3 * t112 / t93 / t113 / t92 + 0.34206186666666666666666666666666666666666666666667e-3 * t235 * t120 + 0.42757733333333333333333333333333333333333333333333e-3 * t256 * tau1 - 0.23832146666666666666666666666666666666666666666667e-2 * t120 * tau1 * t96) * t127 - 0.3e1 * t266 * t239) * t76 * t78 / 0.4e1)
  vrho_1_ = t82 + t134 + t4 * (t222 + t275)
  t294 = f.my_piecewise3(t1, 0, t26 * (-0.1726745666142e-2 * t53 * t31 - 0.373452e-2 * t166 * t31 + (-0.4709036e-4 * t176 - 0.1282732e-3 * t31 * t64) * t71 - 0.560178e-2 * t186 * t31) * t76 * t78 / 0.4e1)
  vsigma_0_ = t4 * t294
  vsigma_1_ = 0.0e0
  t311 = f.my_piecewise3(t83, 0, t91 * (-0.1726745666142e-2 * t110 * t96 - 0.373452e-2 * t246 * t96 + (-0.4709036e-4 * t256 - 0.1282732e-3 * t96 * t120) * t127 - 0.560178e-2 * t266 * t96) * t76 * t78 / 0.4e1)
  vsigma_2_ = t4 * t311
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t331 = f.my_piecewise3(t1, 0, t26 * (0.16160736667716e-1 * t53 * t35 - 0.746904e-2 * t166 * t35 + (-0.2565464e-3 * s0 / t28 / t56 + 0.14299288e-2 * t64 * t35) * t71 - 0.1120356e-1 * t186 * t35) * t76 * t78 / 0.4e1)
  vtau_0_ = t4 * t331
  t351 = f.my_piecewise3(t83, 0, t91 * (0.16160736667716e-1 * t110 * t100 - 0.746904e-2 * t246 * t100 + (-0.2565464e-3 * s2 / t93 / t113 + 0.14299288e-2 * t120 * t100) * t127 - 0.1120356e-1 * t266 * t100) * t76 * t78 / 0.4e1)
  vtau_1_ = t4 * t351
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  gvt4_alpha = 0.00186726

  gvt4_coeff_d = np.array([np.nan, -0.9800683, -0.003556788, 0.006250326, -2.354518e-05, -0.0001282732, 0.0003574822], dtype=np.float64)

  gvt4_gamm = lambda alpha, x, z: 1 + alpha * (x ** 2 + z)

  gtv4 = lambda alpha, dd, x, z: dd[1] / gvt4_gamm(alpha, x, z) + (dd[2] * x ** 2 + dd[3] * z) / gvt4_gamm(alpha, x, z) ** 2 + (dd[4] * x ** 4 + dd[5] * x ** 2 * z + dd[6] * z ** 2) / gvt4_gamm(alpha, x, z) ** 3

  gvt4_f = lambda x, u, t: -gtv4(gvt4_alpha, gvt4_coeff_d, x, 2 * (t - K_FACTOR_C)) / X_FACTOR_C

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, gvt4_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = 0.1e1 <= f.p.zeta_threshold
  t6 = f.p.zeta_threshold - 0.1e1
  t8 = f.my_piecewise5(t5, t6, t5, -t6, 0)
  t9 = 0.1e1 + t8
  t11 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t13 = t9 ** (0.1e1 / 0.3e1)
  t15 = f.my_piecewise3(t9 <= f.p.zeta_threshold, t11 * f.p.zeta_threshold, t13 * t9)
  t16 = 0.1e1 / t3 * t15
  t17 = r0 ** (0.1e1 / 0.3e1)
  t18 = t16 * t17
  t19 = 2 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = s0 * t20
  t22 = r0 ** 2
  t23 = t17 ** 2
  t25 = 0.1e1 / t23 / t22
  t26 = t21 * t25
  t28 = tau0 * t20
  t30 = 0.1e1 / t23 / r0
  t31 = t28 * t30
  t33 = 6 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t35 = jnp.pi ** 2
  t36 = t35 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t38 = t34 * t37
  t40 = 0.1e1 + 0.186726e-2 * t26 + 0.373452e-2 * t31 - 0.11203560000000000000000000000000000000000000000000e-2 * t38
  t46 = -0.3556788e-2 * t26 + 0.12500652e-1 * t31 - 0.37501956000000000000000000000000000000000000000000e-2 * t38
  t47 = t40 ** 2
  t48 = 0.1e1 / t47
  t50 = s0 ** 2
  t51 = t50 * t19
  t52 = t22 ** 2
  t55 = 0.1e1 / t17 / t52 / r0
  t60 = 0.2e1 * t31 - 0.3e1 / 0.5e1 * t38
  t64 = t60 ** 2
  t66 = -0.4709036e-4 * t51 * t55 - 0.1282732e-3 * t21 * t25 * t60 + 0.3574822e-3 * t64
  t68 = 0.1e1 / t47 / t40
  t72 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t73 = 0.1e1 / t72
  t75 = 4 ** (0.1e1 / 0.3e1)
  t76 = (-0.9800683e0 / t40 + t46 * t48 + t66 * t68) * t73 * t75
  t79 = f.my_piecewise3(t2, 0, t18 * t76 / 0.4e1)
  t86 = 0.1e1 / t23 / t22 / r0
  t87 = t21 * t86
  t89 = t28 * t25
  t91 = -0.49793600000000000000000000000000000000000000000000e-2 * t87 - 0.62242000000000000000000000000000000000000000000000e-2 * t89
  t98 = t46 * t68
  t109 = s0 * t19
  t114 = t20 * t25
  t119 = t47 ** 2
  t121 = t66 / t119
  t130 = f.my_piecewise3(t2, 0, t16 / t23 * t76 / 0.12e2 + t18 * (0.9800683e0 * t48 * t91 + (0.94847680000000000000000000000000000000000000000000e-2 * t87 - 0.20834420000000000000000000000000000000000000000000e-1 * t89) * t48 - 0.2e1 * t98 * t91 + (0.25114858666666666666666666666666666666666666666667e-3 * t51 / t17 / t52 / t22 + 0.34206186666666666666666666666666666666666666666667e-3 * t21 * t86 * t60 + 0.85515466666666666666666666666666666666666666666667e-3 * t109 * t55 * tau0 - 0.23832146666666666666666666666666666666666666666667e-2 * t60 * tau0 * t114) * t68 - 0.3e1 * t121 * t91) * t73 * t75 / 0.4e1)
  vrho_0_ = 0.2e1 * r0 * t130 + 0.2e1 * t79
  t133 = t48 * t20
  t151 = f.my_piecewise3(t2, 0, t18 * (-0.1726745666142e-2 * t133 * t25 - 0.373452e-2 * t98 * t114 + (-0.9418072e-4 * t109 * t55 - 0.1282732e-3 * t114 * t60) * t68 - 0.560178e-2 * t121 * t114) * t73 * t75 / 0.4e1)
  vsigma_0_ = 0.2e1 * r0 * t151
  vlapl_0_ = 0.0e0
  t155 = t20 * t30
  t174 = f.my_piecewise3(t2, 0, t18 * (0.16160736667716e-1 * t133 * t30 - 0.746904e-2 * t98 * t155 + (-0.5130928e-3 * t109 / t17 / t52 + 0.14299288e-2 * t60 * t20 * t30) * t68 - 0.1120356e-1 * t121 * t155) * t73 * t75 / 0.4e1)
  vtau_0_ = 0.2e1 * r0 * t174
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = 0.1e1 <= f.p.zeta_threshold
  t6 = f.p.zeta_threshold - 0.1e1
  t8 = f.my_piecewise5(t5, t6, t5, -t6, 0)
  t9 = 0.1e1 + t8
  t11 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t13 = t9 ** (0.1e1 / 0.3e1)
  t15 = f.my_piecewise3(t9 <= f.p.zeta_threshold, t11 * f.p.zeta_threshold, t13 * t9)
  t16 = 0.1e1 / t3 * t15
  t17 = r0 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t20 = t16 / t18
  t21 = 2 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = s0 * t22
  t24 = r0 ** 2
  t26 = 0.1e1 / t18 / t24
  t27 = t23 * t26
  t29 = tau0 * t22
  t31 = 0.1e1 / t18 / r0
  t32 = t29 * t31
  t34 = 6 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t36 = jnp.pi ** 2
  t37 = t36 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t39 = t35 * t38
  t41 = 0.1e1 + 0.186726e-2 * t27 + 0.373452e-2 * t32 - 0.11203560000000000000000000000000000000000000000000e-2 * t39
  t47 = -0.3556788e-2 * t27 + 0.12500652e-1 * t32 - 0.37501956000000000000000000000000000000000000000000e-2 * t39
  t48 = t41 ** 2
  t49 = 0.1e1 / t48
  t51 = s0 ** 2
  t52 = t51 * t21
  t53 = t24 ** 2
  t56 = 0.1e1 / t17 / t53 / r0
  t61 = 0.2e1 * t32 - 0.3e1 / 0.5e1 * t39
  t65 = t61 ** 2
  t67 = -0.4709036e-4 * t52 * t56 - 0.1282732e-3 * t23 * t26 * t61 + 0.3574822e-3 * t65
  t69 = 0.1e1 / t48 / t41
  t73 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t74 = 0.1e1 / t73
  t76 = 4 ** (0.1e1 / 0.3e1)
  t77 = (-0.9800683e0 / t41 + t47 * t49 + t67 * t69) * t74 * t76
  t80 = t16 * t17
  t81 = t24 * r0
  t83 = 0.1e1 / t18 / t81
  t84 = t23 * t83
  t86 = t29 * t26
  t88 = -0.49793600000000000000000000000000000000000000000000e-2 * t84 - 0.62242000000000000000000000000000000000000000000000e-2 * t86
  t93 = 0.94847680000000000000000000000000000000000000000000e-2 * t84 - 0.20834420000000000000000000000000000000000000000000e-1 * t86
  t95 = t47 * t69
  t100 = 0.1e1 / t17 / t53 / t24
  t106 = s0 * t21
  t110 = t61 * tau0
  t114 = 0.25114858666666666666666666666666666666666666666667e-3 * t52 * t100 + 0.34206186666666666666666666666666666666666666666667e-3 * t23 * t83 * t61 + 0.85515466666666666666666666666666666666666666666667e-3 * t106 * t56 * tau0 - 0.23832146666666666666666666666666666666666666666667e-2 * t110 * t22 * t26
  t116 = t48 ** 2
  t117 = 0.1e1 / t116
  t118 = t67 * t117
  t123 = (0.9800683e0 * t49 * t88 + t93 * t49 - 0.2e1 * t95 * t88 + t114 * t69 - 0.3e1 * t118 * t88) * t74 * t76
  t127 = f.my_piecewise3(t2, 0, t20 * t77 / 0.12e2 + t80 * t123 / 0.4e1)
  t134 = t88 ** 2
  t138 = 0.1e1 / t18 / t53
  t139 = t23 * t138
  t141 = t29 * t83
  t143 = 0.18257653333333333333333333333333333333333333333333e-1 * t139 + 0.16597866666666666666666666666666666666666666666667e-1 * t141
  t169 = tau0 ** 2
  t194 = f.my_piecewise3(t2, 0, -t16 * t31 * t77 / 0.18e2 + t20 * t123 / 0.6e1 + t80 * (-0.19601366e1 * t69 * t134 + 0.9800683e0 * t49 * t143 + (-0.34777482666666666666666666666666666666666666666667e-1 * t139 + 0.55558453333333333333333333333333333333333333333333e-1 * t141) * t49 - 0.4e1 * t93 * t69 * t88 + 0.6e1 * t47 * t117 * t134 - 0.2e1 * t95 * t143 + (-0.15906077155555555555555555555555555555555555555556e-2 * t52 / t17 / t53 / t81 - 0.12542268444444444444444444444444444444444444444445e-2 * t23 * t138 * t61 - 0.68412373333333333333333333333333333333333333333334e-2 * t106 * t100 * tau0 + 0.15888097777777777777777777777777777777777777777778e-1 * t169 * t21 * t56 + 0.63552391111111111111111111111111111111111111111112e-2 * t110 * t22 * t83) * t69 - 0.6e1 * t114 * t117 * t88 + 0.12e2 * t67 / t116 / t41 * t134 - 0.3e1 * t118 * t143) * t74 * t76 / 0.4e1)
  v2rho2_0_ = 0.2e1 * r0 * t194 + 0.4e1 * t127
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = 0.1e1 <= f.p.zeta_threshold
  t6 = f.p.zeta_threshold - 0.1e1
  t8 = f.my_piecewise5(t5, t6, t5, -t6, 0)
  t9 = 0.1e1 + t8
  t11 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t13 = t9 ** (0.1e1 / 0.3e1)
  t15 = f.my_piecewise3(t9 <= f.p.zeta_threshold, t11 * f.p.zeta_threshold, t13 * t9)
  t16 = 0.1e1 / t3 * t15
  t17 = r0 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t20 = 0.1e1 / t18 / r0
  t21 = t16 * t20
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = s0 * t23
  t25 = r0 ** 2
  t27 = 0.1e1 / t18 / t25
  t28 = t24 * t27
  t30 = tau0 * t23
  t31 = t30 * t20
  t33 = 6 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t35 = jnp.pi ** 2
  t36 = t35 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t38 = t34 * t37
  t40 = 0.1e1 + 0.186726e-2 * t28 + 0.373452e-2 * t31 - 0.11203560000000000000000000000000000000000000000000e-2 * t38
  t46 = -0.3556788e-2 * t28 + 0.12500652e-1 * t31 - 0.37501956000000000000000000000000000000000000000000e-2 * t38
  t47 = t40 ** 2
  t48 = 0.1e1 / t47
  t50 = s0 ** 2
  t51 = t50 * t22
  t52 = t25 ** 2
  t53 = t52 * r0
  t55 = 0.1e1 / t17 / t53
  t60 = 0.2e1 * t31 - 0.3e1 / 0.5e1 * t38
  t64 = t60 ** 2
  t66 = -0.4709036e-4 * t51 * t55 - 0.1282732e-3 * t24 * t27 * t60 + 0.3574822e-3 * t64
  t68 = 0.1e1 / t47 / t40
  t72 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t73 = 0.1e1 / t72
  t75 = 4 ** (0.1e1 / 0.3e1)
  t76 = (-0.9800683e0 / t40 + t46 * t48 + t66 * t68) * t73 * t75
  t80 = t16 / t18
  t81 = t25 * r0
  t83 = 0.1e1 / t18 / t81
  t84 = t24 * t83
  t86 = t30 * t27
  t88 = -0.49793600000000000000000000000000000000000000000000e-2 * t84 - 0.62242000000000000000000000000000000000000000000000e-2 * t86
  t93 = 0.94847680000000000000000000000000000000000000000000e-2 * t84 - 0.20834420000000000000000000000000000000000000000000e-1 * t86
  t95 = t46 * t68
  t100 = 0.1e1 / t17 / t52 / t25
  t106 = s0 * t22
  t110 = t60 * tau0
  t114 = 0.25114858666666666666666666666666666666666666666667e-3 * t51 * t100 + 0.34206186666666666666666666666666666666666666666667e-3 * t24 * t83 * t60 + 0.85515466666666666666666666666666666666666666666667e-3 * t106 * t55 * tau0 - 0.23832146666666666666666666666666666666666666666667e-2 * t110 * t23 * t27
  t116 = t47 ** 2
  t117 = 0.1e1 / t116
  t118 = t66 * t117
  t123 = (0.9800683e0 * t48 * t88 + t93 * t48 - 0.2e1 * t95 * t88 + t114 * t68 - 0.3e1 * t118 * t88) * t73 * t75
  t126 = t16 * t17
  t127 = t88 ** 2
  t131 = 0.1e1 / t18 / t52
  t132 = t24 * t131
  t134 = t30 * t83
  t136 = 0.18257653333333333333333333333333333333333333333333e-1 * t132 + 0.16597866666666666666666666666666666666666666666667e-1 * t134
  t141 = -0.34777482666666666666666666666666666666666666666667e-1 * t132 + 0.55558453333333333333333333333333333333333333333333e-1 * t134
  t143 = t93 * t68
  t146 = t46 * t117
  t153 = 0.1e1 / t17 / t52 / t81
  t162 = tau0 ** 2
  t163 = t162 * t22
  t169 = -0.15906077155555555555555555555555555555555555555556e-2 * t51 * t153 - 0.12542268444444444444444444444444444444444444444445e-2 * t24 * t131 * t60 - 0.68412373333333333333333333333333333333333333333334e-2 * t106 * t100 * tau0 + 0.15888097777777777777777777777777777777777777777778e-1 * t163 * t55 + 0.63552391111111111111111111111111111111111111111112e-2 * t110 * t23 * t83
  t171 = t114 * t117
  t175 = 0.1e1 / t116 / t40
  t176 = t66 * t175
  t183 = (-0.19601366e1 * t68 * t127 + 0.9800683e0 * t48 * t136 + t141 * t48 - 0.4e1 * t143 * t88 + 0.6e1 * t146 * t127 - 0.2e1 * t95 * t136 + t169 * t68 - 0.6e1 * t171 * t88 + 0.12e2 * t176 * t127 - 0.3e1 * t118 * t136) * t73 * t75
  t187 = f.my_piecewise3(t2, 0, -t21 * t76 / 0.18e2 + t80 * t123 / 0.6e1 + t126 * t183 / 0.4e1)
  t199 = t127 * t88
  t202 = t88 * t136
  t216 = t52 ** 2
  t222 = 0.1e1 / t18 / t53
  t236 = t24 * t222
  t238 = t30 * t131
  t240 = -0.85202382222222222222222222222222222222222222222221e-1 * t236 - 0.60858844444444444444444444444444444444444444444446e-1 * t238
  t266 = -0.60e2 * t66 / t116 / t47 * t199 + 0.36e2 * t176 * t202 + 0.18e2 * t93 * t117 * t127 - 0.24e2 * t46 * t175 * t199 + 0.18e2 * t146 * t202 + 0.36e2 * t114 * t175 * t127 + (0.11664456580740740740740740740740740740740740740741e-1 * t51 / t17 / t216 + 0.58530586074074074074074074074074074074074074074077e-2 * t24 * t222 * t60 + 0.51689348740740740740740740740740740740740740740742e-1 * t106 * t153 * tau0 - 0.12710478222222222222222222222222222222222222222222e0 * t163 * t100 - 0.23302543407407407407407407407407407407407407407408e-1 * t110 * t23 * t131) * t68 + 0.9800683e0 * t48 * t240 + (0.16229491911111111111111111111111111111111111111111e0 * t236 - 0.20371432888888888888888888888888888888888888888889e0 * t238) * t48 - 0.3e1 * t118 * t240 - 0.9e1 * t171 * t136 - 0.2e1 * t95 * t240 - 0.9e1 * t169 * t117 * t88 + 0.58804098e1 * t117 * t199 - 0.58804098e1 * t68 * t88 * t136 - 0.6e1 * t141 * t68 * t88 - 0.6e1 * t143 * t136
  t272 = f.my_piecewise3(t2, 0, 0.5e1 / 0.54e2 * t16 * t27 * t76 - t21 * t123 / 0.6e1 + t80 * t183 / 0.4e1 + t126 * t266 * t73 * t75 / 0.4e1)
  v3rho3_0_ = 0.2e1 * r0 * t272 + 0.6e1 * t187

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = 0.1e1 <= f.p.zeta_threshold
  t6 = f.p.zeta_threshold - 0.1e1
  t8 = f.my_piecewise5(t5, t6, t5, -t6, 0)
  t9 = 0.1e1 + t8
  t11 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t13 = t9 ** (0.1e1 / 0.3e1)
  t15 = f.my_piecewise3(t9 <= f.p.zeta_threshold, t11 * f.p.zeta_threshold, t13 * t9)
  t16 = 0.1e1 / t3 * t15
  t17 = r0 ** 2
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = 0.1e1 / t19 / t17
  t22 = t16 * t21
  t23 = 2 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = s0 * t24
  t26 = t25 * t21
  t28 = tau0 * t24
  t30 = 0.1e1 / t19 / r0
  t31 = t28 * t30
  t33 = 6 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t35 = jnp.pi ** 2
  t36 = t35 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t38 = t34 * t37
  t40 = 0.1e1 + 0.186726e-2 * t26 + 0.373452e-2 * t31 - 0.11203560000000000000000000000000000000000000000000e-2 * t38
  t46 = -0.3556788e-2 * t26 + 0.12500652e-1 * t31 - 0.37501956000000000000000000000000000000000000000000e-2 * t38
  t47 = t40 ** 2
  t48 = 0.1e1 / t47
  t50 = s0 ** 2
  t51 = t50 * t23
  t52 = t17 ** 2
  t53 = t52 * r0
  t55 = 0.1e1 / t18 / t53
  t60 = 0.2e1 * t31 - 0.3e1 / 0.5e1 * t38
  t64 = t60 ** 2
  t66 = -0.4709036e-4 * t51 * t55 - 0.1282732e-3 * t25 * t21 * t60 + 0.3574822e-3 * t64
  t67 = t47 * t40
  t68 = 0.1e1 / t67
  t72 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t73 = 0.1e1 / t72
  t75 = 4 ** (0.1e1 / 0.3e1)
  t76 = (-0.9800683e0 / t40 + t46 * t48 + t66 * t68) * t73 * t75
  t79 = t16 * t30
  t80 = t17 * r0
  t82 = 0.1e1 / t19 / t80
  t83 = t25 * t82
  t85 = t28 * t21
  t87 = -0.49793600000000000000000000000000000000000000000000e-2 * t83 - 0.62242000000000000000000000000000000000000000000000e-2 * t85
  t92 = 0.94847680000000000000000000000000000000000000000000e-2 * t83 - 0.20834420000000000000000000000000000000000000000000e-1 * t85
  t94 = t46 * t68
  t97 = t52 * t17
  t99 = 0.1e1 / t18 / t97
  t105 = s0 * t23
  t109 = t60 * tau0
  t113 = 0.25114858666666666666666666666666666666666666666667e-3 * t51 * t99 + 0.34206186666666666666666666666666666666666666666667e-3 * t25 * t82 * t60 + 0.85515466666666666666666666666666666666666666666667e-3 * t105 * t55 * tau0 - 0.23832146666666666666666666666666666666666666666667e-2 * t109 * t24 * t21
  t115 = t47 ** 2
  t116 = 0.1e1 / t115
  t117 = t66 * t116
  t122 = (0.9800683e0 * t48 * t87 + t92 * t48 - 0.2e1 * t94 * t87 + t113 * t68 - 0.3e1 * t117 * t87) * t73 * t75
  t126 = t16 / t19
  t127 = t87 ** 2
  t131 = 0.1e1 / t19 / t52
  t132 = t25 * t131
  t134 = t28 * t82
  t136 = 0.18257653333333333333333333333333333333333333333333e-1 * t132 + 0.16597866666666666666666666666666666666666666666667e-1 * t134
  t141 = -0.34777482666666666666666666666666666666666666666667e-1 * t132 + 0.55558453333333333333333333333333333333333333333333e-1 * t134
  t143 = t92 * t68
  t146 = t46 * t116
  t153 = 0.1e1 / t18 / t52 / t80
  t162 = tau0 ** 2
  t163 = t162 * t23
  t169 = -0.15906077155555555555555555555555555555555555555556e-2 * t51 * t153 - 0.12542268444444444444444444444444444444444444444445e-2 * t25 * t131 * t60 - 0.68412373333333333333333333333333333333333333333334e-2 * t105 * t99 * tau0 + 0.15888097777777777777777777777777777777777777777778e-1 * t163 * t55 + 0.63552391111111111111111111111111111111111111111112e-2 * t109 * t24 * t82
  t171 = t113 * t116
  t175 = 0.1e1 / t115 / t40
  t176 = t66 * t175
  t183 = (-0.19601366e1 * t68 * t127 + 0.9800683e0 * t48 * t136 + t141 * t48 - 0.4e1 * t143 * t87 + 0.6e1 * t146 * t127 - 0.2e1 * t94 * t136 + t169 * t68 - 0.6e1 * t171 * t87 + 0.12e2 * t176 * t127 - 0.3e1 * t117 * t136) * t73 * t75
  t186 = t16 * t18
  t188 = 0.1e1 / t115 / t47
  t189 = t66 * t188
  t190 = t127 * t87
  t193 = t87 * t136
  t196 = t92 * t116
  t199 = t46 * t175
  t204 = t113 * t175
  t208 = 0.1e1 / t19 / t53
  t209 = t25 * t208
  t211 = t28 * t131
  t213 = 0.16229491911111111111111111111111111111111111111111e0 * t209 - 0.20371432888888888888888888888888888888888888888889e0 * t211
  t215 = t52 ** 2
  t217 = 0.1e1 / t18 / t215
  t231 = 0.11664456580740740740740740740740740740740740740741e-1 * t51 * t217 + 0.58530586074074074074074074074074074074074074074077e-2 * t25 * t208 * t60 + 0.51689348740740740740740740740740740740740740740742e-1 * t105 * t153 * tau0 - 0.12710478222222222222222222222222222222222222222222e0 * t163 * t99 - 0.23302543407407407407407407407407407407407407407408e-1 * t109 * t24 * t131
  t235 = -0.85202382222222222222222222222222222222222222222221e-1 * t209 - 0.60858844444444444444444444444444444444444444444446e-1 * t211
  t244 = t169 * t116
  t252 = t141 * t68
  t257 = -0.60e2 * t189 * t190 + 0.36e2 * t176 * t193 + 0.18e2 * t196 * t127 - 0.24e2 * t199 * t190 + 0.18e2 * t146 * t193 + 0.36e2 * t204 * t127 + t213 * t48 + t231 * t68 + 0.9800683e0 * t48 * t235 - 0.9e1 * t171 * t136 - 0.3e1 * t117 * t235 - 0.2e1 * t94 * t235 - 0.9e1 * t244 * t87 + 0.58804098e1 * t116 * t190 - 0.58804098e1 * t68 * t87 * t136 - 0.6e1 * t252 * t87 - 0.6e1 * t143 * t136
  t259 = t257 * t73 * t75
  t263 = f.my_piecewise3(t2, 0, 0.5e1 / 0.54e2 * t22 * t76 - t79 * t122 / 0.6e1 + t126 * t183 / 0.4e1 + t186 * t259 / 0.4e1)
  t274 = t127 ** 2
  t277 = t136 ** 2
  t281 = 0.1e1 / t19 / t97
  t282 = t25 * t281
  t284 = t28 * t208
  t308 = 0.48281349925925925925925925925925925925925925925925e0 * t282 + 0.28400794074074074074074074074074074074074074074075e0 * t284
  t311 = t87 * t235
  t314 = t127 * t136
  t333 = -0.235216392e2 * t175 * t274 - 0.58804098e1 * t68 * t277 + (-0.91967120829629629629629629629629629629629629629629e0 * t282 + 0.95066686814814814814814814814814814814814814814815e0 * t284) * t48 + (-0.97203804839506172839506172839506172839506172839508e-1 * t51 / t18 / t215 / r0 - 0.33167332108641975308641975308641975308641975308644e-1 * t25 * t281 * t60 - 0.41807561481481481481481481481481481481481481481482e0 * t105 * t217 * tau0 + 0.96034724345679012345679012345679012345679012345678e0 * t163 * t153 + 0.10874520256790123456790123456790123456790123456790e0 * t109 * t24 * t208) * t68 + 0.9800683e0 * t48 * t308 + 0.24e2 * t146 * t311 - 0.360e3 * t189 * t314 + 0.144e3 * t204 * t193 + 0.48e2 * t176 * t311 + 0.72e2 * t196 * t193 - 0.144e3 * t199 * t314 - 0.18e2 * t244 * t136 + 0.72e2 * t169 * t175 * t127 + 0.36e2 * t141 * t116 * t127
  t374 = -0.240e3 * t113 * t188 * t190 + 0.352824588e2 * t116 * t127 * t136 - 0.8e1 * t143 * t235 - 0.2e1 * t94 * t308 - 0.8e1 * t213 * t68 * t87 + 0.36e2 * t176 * t277 - 0.96e2 * t92 * t175 * t190 + 0.120e3 * t46 * t188 * t274 - 0.12e2 * t231 * t116 * t87 - 0.78405464e1 * t68 * t235 * t87 + 0.18e2 * t146 * t277 + 0.360e3 * t66 / t115 / t67 * t274 - 0.12e2 * t252 * t136 - 0.12e2 * t171 * t235 - 0.3e1 * t117 * t308
  t381 = f.my_piecewise3(t2, 0, -0.20e2 / 0.81e2 * t16 * t82 * t76 + 0.10e2 / 0.27e2 * t22 * t122 - t79 * t183 / 0.3e1 + t126 * t259 / 0.3e1 + t186 * (t333 + t374) * t73 * t75 / 0.4e1)
  v4rho4_0_ = 0.2e1 * r0 * t381 + 0.8e1 * t263

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = jnp.pi ** (0.1e1 / 0.3e1)
  t3 = 0.1e1 / t2
  t4 = r0 + r1
  t5 = 0.1e1 / t4
  t8 = 0.2e1 * r0 * t5 <= f.p.zeta_threshold
  t9 = f.p.zeta_threshold - 0.1e1
  t12 = 0.2e1 * r1 * t5 <= f.p.zeta_threshold
  t13 = -t9
  t14 = r0 - r1
  t15 = t14 * t5
  t16 = f.my_piecewise5(t8, t9, t12, t13, t15)
  t17 = 0.1e1 + t16
  t18 = t17 <= f.p.zeta_threshold
  t19 = t17 ** (0.1e1 / 0.3e1)
  t20 = t4 ** 2
  t21 = 0.1e1 / t20
  t22 = t14 * t21
  t23 = t5 - t22
  t24 = f.my_piecewise5(t8, 0, t12, 0, t23)
  t27 = f.my_piecewise3(t18, 0, 0.4e1 / 0.3e1 * t19 * t24)
  t28 = t3 * t27
  t29 = t4 ** (0.1e1 / 0.3e1)
  t30 = t28 * t29
  t31 = r0 ** 2
  t32 = r0 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t35 = 0.1e1 / t33 / t31
  t36 = s0 * t35
  t40 = tau0 / t33 / r0
  t42 = 6 ** (0.1e1 / 0.3e1)
  t43 = t42 ** 2
  t44 = jnp.pi ** 2
  t45 = t44 ** (0.1e1 / 0.3e1)
  t46 = t45 ** 2
  t47 = t43 * t46
  t48 = 0.11203560000000000000000000000000000000000000000000e-2 * t47
  t49 = 0.1e1 + 0.186726e-2 * t36 + 0.373452e-2 * t40 - t48
  t54 = 0.37501956000000000000000000000000000000000000000000e-2 * t47
  t55 = -0.3556788e-2 * t36 + 0.12500652e-1 * t40 - t54
  t56 = t49 ** 2
  t57 = 0.1e1 / t56
  t59 = s0 ** 2
  t60 = t31 ** 2
  t63 = 0.1e1 / t32 / t60 / r0
  t67 = 0.3e1 / 0.5e1 * t47
  t68 = 0.2e1 * t40 - t67
  t71 = t68 ** 2
  t73 = -0.2354518e-4 * t59 * t63 - 0.1282732e-3 * t36 * t68 + 0.3574822e-3 * t71
  t75 = 0.1e1 / t56 / t49
  t79 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t80 = 0.1e1 / t79
  t82 = 4 ** (0.1e1 / 0.3e1)
  t83 = (-0.9800683e0 / t49 + t55 * t57 + t73 * t75) * t80 * t82
  t86 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t87 = t86 * f.p.zeta_threshold
  t89 = f.my_piecewise3(t18, t87, t19 * t17)
  t90 = t3 * t89
  t91 = t29 ** 2
  t92 = 0.1e1 / t91
  t93 = t90 * t92
  t95 = t93 * t83 / 0.12e2
  t96 = t90 * t29
  t97 = t31 * r0
  t99 = 0.1e1 / t33 / t97
  t100 = s0 * t99
  t102 = tau0 * t35
  t104 = -0.49793600000000000000000000000000000000000000000000e-2 * t100 - 0.62242000000000000000000000000000000000000000000000e-2 * t102
  t109 = 0.94847680000000000000000000000000000000000000000000e-2 * t100 - 0.20834420000000000000000000000000000000000000000000e-1 * t102
  t111 = t55 * t75
  t116 = 0.1e1 / t32 / t60 / t31
  t124 = t68 * tau0
  t127 = 0.12557429333333333333333333333333333333333333333333e-3 * t59 * t116 + 0.34206186666666666666666666666666666666666666666667e-3 * t100 * t68 + 0.42757733333333333333333333333333333333333333333333e-3 * s0 * t63 * tau0 - 0.23832146666666666666666666666666666666666666666667e-2 * t124 * t35
  t129 = t56 ** 2
  t130 = 0.1e1 / t129
  t131 = t73 * t130
  t136 = (0.9800683e0 * t57 * t104 + t109 * t57 - 0.2e1 * t111 * t104 + t127 * t75 - 0.3e1 * t131 * t104) * t80 * t82
  t140 = f.my_piecewise3(t1, 0, t30 * t83 / 0.4e1 + t95 + t96 * t136 / 0.4e1)
  t142 = r1 <= f.p.dens_threshold
  t143 = f.my_piecewise5(t12, t9, t8, t13, -t15)
  t144 = 0.1e1 + t143
  t145 = t144 <= f.p.zeta_threshold
  t146 = t144 ** (0.1e1 / 0.3e1)
  t148 = f.my_piecewise5(t12, 0, t8, 0, -t23)
  t151 = f.my_piecewise3(t145, 0, 0.4e1 / 0.3e1 * t146 * t148)
  t152 = t3 * t151
  t153 = t152 * t29
  t154 = r1 ** 2
  t155 = r1 ** (0.1e1 / 0.3e1)
  t156 = t155 ** 2
  t158 = 0.1e1 / t156 / t154
  t159 = s2 * t158
  t163 = tau1 / t156 / r1
  t165 = 0.1e1 + 0.186726e-2 * t159 + 0.373452e-2 * t163 - t48
  t170 = -0.3556788e-2 * t159 + 0.12500652e-1 * t163 - t54
  t171 = t165 ** 2
  t172 = 0.1e1 / t171
  t174 = s2 ** 2
  t175 = t154 ** 2
  t178 = 0.1e1 / t155 / t175 / r1
  t182 = 0.2e1 * t163 - t67
  t185 = t182 ** 2
  t187 = -0.2354518e-4 * t174 * t178 - 0.1282732e-3 * t159 * t182 + 0.3574822e-3 * t185
  t189 = 0.1e1 / t171 / t165
  t193 = (-0.9800683e0 / t165 + t170 * t172 + t187 * t189) * t80 * t82
  t197 = f.my_piecewise3(t145, t87, t146 * t144)
  t198 = t3 * t197
  t199 = t198 * t92
  t201 = t199 * t193 / 0.12e2
  t203 = f.my_piecewise3(t142, 0, t153 * t193 / 0.4e1 + t201)
  t205 = t19 ** 2
  t206 = 0.1e1 / t205
  t207 = t24 ** 2
  t212 = t14 / t20 / t4
  t214 = -0.2e1 * t21 + 0.2e1 * t212
  t215 = f.my_piecewise5(t8, 0, t12, 0, t214)
  t219 = f.my_piecewise3(t18, 0, 0.4e1 / 0.9e1 * t206 * t207 + 0.4e1 / 0.3e1 * t19 * t215)
  t225 = t28 * t92 * t83
  t230 = 0.1e1 / t91 / t4
  t233 = t90 * t230 * t83 / 0.18e2
  t234 = t93 * t136
  t236 = t104 ** 2
  t241 = s0 / t33 / t60
  t243 = tau0 * t99
  t245 = 0.18257653333333333333333333333333333333333333333333e-1 * t241 + 0.16597866666666666666666666666666666666666666666667e-1 * t243
  t270 = tau0 ** 2
  t293 = f.my_piecewise3(t1, 0, t3 * t219 * t29 * t83 / 0.4e1 + t225 / 0.6e1 + t30 * t136 / 0.2e1 - t233 + t234 / 0.6e1 + t96 * (-0.19601366e1 * t75 * t236 + 0.9800683e0 * t57 * t245 + (-0.34777482666666666666666666666666666666666666666667e-1 * t241 + 0.55558453333333333333333333333333333333333333333333e-1 * t243) * t57 - 0.4e1 * t109 * t75 * t104 + 0.6e1 * t55 * t130 * t236 - 0.2e1 * t111 * t245 + (-0.79530385777777777777777777777777777777777777777776e-3 * t59 / t32 / t60 / t97 - 0.12542268444444444444444444444444444444444444444445e-2 * t241 * t68 - 0.34206186666666666666666666666666666666666666666666e-2 * s0 * t116 * tau0 + 0.79440488888888888888888888888888888888888888888890e-2 * t270 * t63 + 0.63552391111111111111111111111111111111111111111112e-2 * t124 * t99) * t75 - 0.6e1 * t127 * t130 * t104 + 0.12e2 * t73 / t129 / t49 * t236 - 0.3e1 * t131 * t245) * t80 * t82 / 0.4e1)
  t294 = t146 ** 2
  t295 = 0.1e1 / t294
  t296 = t148 ** 2
  t300 = f.my_piecewise5(t12, 0, t8, 0, -t214)
  t304 = f.my_piecewise3(t145, 0, 0.4e1 / 0.9e1 * t295 * t296 + 0.4e1 / 0.3e1 * t146 * t300)
  t310 = t152 * t92 * t193
  t314 = t198 * t230 * t193 / 0.18e2
  t316 = f.my_piecewise3(t142, 0, t3 * t304 * t29 * t193 / 0.4e1 + t310 / 0.6e1 - t314)
  d11 = 0.2e1 * t140 + 0.2e1 * t203 + t4 * (t293 + t316)
  t319 = -t5 - t22
  t320 = f.my_piecewise5(t8, 0, t12, 0, t319)
  t323 = f.my_piecewise3(t18, 0, 0.4e1 / 0.3e1 * t19 * t320)
  t324 = t3 * t323
  t325 = t324 * t29
  t329 = f.my_piecewise3(t1, 0, t325 * t83 / 0.4e1 + t95)
  t331 = f.my_piecewise5(t12, 0, t8, 0, -t319)
  t334 = f.my_piecewise3(t145, 0, 0.4e1 / 0.3e1 * t146 * t331)
  t335 = t3 * t334
  t336 = t335 * t29
  t339 = t198 * t29
  t340 = t154 * r1
  t342 = 0.1e1 / t156 / t340
  t343 = s2 * t342
  t345 = tau1 * t158
  t347 = -0.49793600000000000000000000000000000000000000000000e-2 * t343 - 0.62242000000000000000000000000000000000000000000000e-2 * t345
  t352 = 0.94847680000000000000000000000000000000000000000000e-2 * t343 - 0.20834420000000000000000000000000000000000000000000e-1 * t345
  t354 = t170 * t189
  t359 = 0.1e1 / t155 / t175 / t154
  t367 = t182 * tau1
  t370 = 0.12557429333333333333333333333333333333333333333333e-3 * t174 * t359 + 0.34206186666666666666666666666666666666666666666667e-3 * t343 * t182 + 0.42757733333333333333333333333333333333333333333333e-3 * s2 * t178 * tau1 - 0.23832146666666666666666666666666666666666666666667e-2 * t367 * t158
  t372 = t171 ** 2
  t373 = 0.1e1 / t372
  t374 = t187 * t373
  t379 = (0.9800683e0 * t172 * t347 + t352 * t172 - 0.2e1 * t354 * t347 + t370 * t189 - 0.3e1 * t374 * t347) * t80 * t82
  t383 = f.my_piecewise3(t142, 0, t336 * t193 / 0.4e1 + t201 + t339 * t379 / 0.4e1)
  t387 = 0.2e1 * t212
  t388 = f.my_piecewise5(t8, 0, t12, 0, t387)
  t392 = f.my_piecewise3(t18, 0, 0.4e1 / 0.9e1 * t206 * t320 * t24 + 0.4e1 / 0.3e1 * t19 * t388)
  t398 = t324 * t92 * t83
  t405 = f.my_piecewise3(t1, 0, t3 * t392 * t29 * t83 / 0.4e1 + t398 / 0.12e2 + t325 * t136 / 0.4e1 + t225 / 0.12e2 - t233 + t234 / 0.12e2)
  t409 = f.my_piecewise5(t12, 0, t8, 0, -t387)
  t413 = f.my_piecewise3(t145, 0, 0.4e1 / 0.9e1 * t295 * t331 * t148 + 0.4e1 / 0.3e1 * t146 * t409)
  t419 = t335 * t92 * t193
  t424 = t199 * t379
  t427 = f.my_piecewise3(t142, 0, t3 * t413 * t29 * t193 / 0.4e1 + t419 / 0.12e2 + t310 / 0.12e2 - t314 + t153 * t379 / 0.4e1 + t424 / 0.12e2)
  d12 = t140 + t203 + t329 + t383 + t4 * (t405 + t427)
  t432 = t320 ** 2
  t436 = 0.2e1 * t21 + 0.2e1 * t212
  t437 = f.my_piecewise5(t8, 0, t12, 0, t436)
  t441 = f.my_piecewise3(t18, 0, 0.4e1 / 0.9e1 * t206 * t432 + 0.4e1 / 0.3e1 * t19 * t437)
  t448 = f.my_piecewise3(t1, 0, t3 * t441 * t29 * t83 / 0.4e1 + t398 / 0.6e1 - t233)
  t449 = t331 ** 2
  t453 = f.my_piecewise5(t12, 0, t8, 0, -t436)
  t457 = f.my_piecewise3(t145, 0, 0.4e1 / 0.9e1 * t295 * t449 + 0.4e1 / 0.3e1 * t146 * t453)
  t466 = t347 ** 2
  t471 = s2 / t156 / t175
  t473 = tau1 * t342
  t475 = 0.18257653333333333333333333333333333333333333333333e-1 * t471 + 0.16597866666666666666666666666666666666666666666667e-1 * t473
  t500 = tau1 ** 2
  t523 = f.my_piecewise3(t142, 0, t3 * t457 * t29 * t193 / 0.4e1 + t419 / 0.6e1 + t336 * t379 / 0.2e1 - t314 + t424 / 0.6e1 + t339 * (-0.19601366e1 * t189 * t466 + 0.9800683e0 * t172 * t475 + (-0.34777482666666666666666666666666666666666666666667e-1 * t471 + 0.55558453333333333333333333333333333333333333333333e-1 * t473) * t172 - 0.4e1 * t352 * t189 * t347 + 0.6e1 * t170 * t373 * t466 - 0.2e1 * t354 * t475 + (-0.79530385777777777777777777777777777777777777777776e-3 * t174 / t155 / t175 / t340 - 0.12542268444444444444444444444444444444444444444445e-2 * t471 * t182 - 0.34206186666666666666666666666666666666666666666666e-2 * s2 * t359 * tau1 + 0.79440488888888888888888888888888888888888888888890e-2 * t500 * t178 + 0.63552391111111111111111111111111111111111111111112e-2 * t367 * t342) * t189 - 0.6e1 * t370 * t373 * t347 + 0.12e2 * t187 / t372 / t165 * t466 - 0.3e1 * t374 * t475) * t80 * t82 / 0.4e1)
  d22 = 0.2e1 * t329 + 0.2e1 * t383 + t4 * (t448 + t523)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = jnp.pi ** (0.1e1 / 0.3e1)
  t3 = 0.1e1 / t2
  t4 = r0 + r1
  t5 = 0.1e1 / t4
  t8 = 0.2e1 * r0 * t5 <= f.p.zeta_threshold
  t9 = f.p.zeta_threshold - 0.1e1
  t12 = 0.2e1 * r1 * t5 <= f.p.zeta_threshold
  t13 = -t9
  t14 = r0 - r1
  t15 = t14 * t5
  t16 = f.my_piecewise5(t8, t9, t12, t13, t15)
  t17 = 0.1e1 + t16
  t18 = t17 <= f.p.zeta_threshold
  t19 = t17 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = 0.1e1 / t20
  t22 = t4 ** 2
  t23 = 0.1e1 / t22
  t25 = -t14 * t23 + t5
  t26 = f.my_piecewise5(t8, 0, t12, 0, t25)
  t27 = t26 ** 2
  t31 = 0.1e1 / t22 / t4
  t34 = 0.2e1 * t14 * t31 - 0.2e1 * t23
  t35 = f.my_piecewise5(t8, 0, t12, 0, t34)
  t39 = f.my_piecewise3(t18, 0, 0.4e1 / 0.9e1 * t21 * t27 + 0.4e1 / 0.3e1 * t19 * t35)
  t40 = t3 * t39
  t41 = t4 ** (0.1e1 / 0.3e1)
  t42 = t40 * t41
  t43 = r0 ** 2
  t44 = r0 ** (0.1e1 / 0.3e1)
  t45 = t44 ** 2
  t47 = 0.1e1 / t45 / t43
  t48 = s0 * t47
  t52 = tau0 / t45 / r0
  t54 = 6 ** (0.1e1 / 0.3e1)
  t55 = t54 ** 2
  t56 = jnp.pi ** 2
  t57 = t56 ** (0.1e1 / 0.3e1)
  t58 = t57 ** 2
  t59 = t55 * t58
  t60 = 0.11203560000000000000000000000000000000000000000000e-2 * t59
  t61 = 0.1e1 + 0.186726e-2 * t48 + 0.373452e-2 * t52 - t60
  t66 = 0.37501956000000000000000000000000000000000000000000e-2 * t59
  t67 = -0.3556788e-2 * t48 + 0.12500652e-1 * t52 - t66
  t68 = t61 ** 2
  t69 = 0.1e1 / t68
  t71 = s0 ** 2
  t72 = t43 ** 2
  t73 = t72 * r0
  t75 = 0.1e1 / t44 / t73
  t79 = 0.3e1 / 0.5e1 * t59
  t80 = 0.2e1 * t52 - t79
  t83 = t80 ** 2
  t85 = -0.2354518e-4 * t71 * t75 - 0.1282732e-3 * t48 * t80 + 0.3574822e-3 * t83
  t87 = 0.1e1 / t68 / t61
  t91 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t92 = 0.1e1 / t91
  t94 = 4 ** (0.1e1 / 0.3e1)
  t95 = (-0.9800683e0 / t61 + t67 * t69 + t85 * t87) * t92 * t94
  t100 = f.my_piecewise3(t18, 0, 0.4e1 / 0.3e1 * t19 * t26)
  t101 = t3 * t100
  t102 = t41 ** 2
  t103 = 0.1e1 / t102
  t104 = t101 * t103
  t107 = t101 * t41
  t108 = t43 * r0
  t110 = 0.1e1 / t45 / t108
  t111 = s0 * t110
  t113 = tau0 * t47
  t115 = -0.49793600000000000000000000000000000000000000000000e-2 * t111 - 0.62242000000000000000000000000000000000000000000000e-2 * t113
  t120 = 0.94847680000000000000000000000000000000000000000000e-2 * t111 - 0.20834420000000000000000000000000000000000000000000e-1 * t113
  t122 = t67 * t87
  t127 = 0.1e1 / t44 / t72 / t43
  t135 = t80 * tau0
  t138 = 0.12557429333333333333333333333333333333333333333333e-3 * t71 * t127 + 0.34206186666666666666666666666666666666666666666667e-3 * t111 * t80 + 0.42757733333333333333333333333333333333333333333333e-3 * s0 * t75 * tau0 - 0.23832146666666666666666666666666666666666666666667e-2 * t135 * t47
  t140 = t68 ** 2
  t141 = 0.1e1 / t140
  t142 = t85 * t141
  t147 = (0.9800683e0 * t69 * t115 + t120 * t69 - 0.2e1 * t122 * t115 + t138 * t87 - 0.3e1 * t142 * t115) * t92 * t94
  t150 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t151 = t150 * f.p.zeta_threshold
  t153 = f.my_piecewise3(t18, t151, t19 * t17)
  t154 = t3 * t153
  t156 = 0.1e1 / t102 / t4
  t157 = t154 * t156
  t160 = t154 * t103
  t163 = t154 * t41
  t164 = t115 ** 2
  t168 = 0.1e1 / t45 / t72
  t169 = s0 * t168
  t171 = tau0 * t110
  t173 = 0.18257653333333333333333333333333333333333333333333e-1 * t169 + 0.16597866666666666666666666666666666666666666666667e-1 * t171
  t178 = -0.34777482666666666666666666666666666666666666666667e-1 * t169 + 0.55558453333333333333333333333333333333333333333333e-1 * t171
  t180 = t120 * t87
  t183 = t67 * t141
  t190 = 0.1e1 / t44 / t72 / t108
  t198 = tau0 ** 2
  t203 = -0.79530385777777777777777777777777777777777777777776e-3 * t71 * t190 - 0.12542268444444444444444444444444444444444444444445e-2 * t169 * t80 - 0.34206186666666666666666666666666666666666666666666e-2 * s0 * t127 * tau0 + 0.79440488888888888888888888888888888888888888888890e-2 * t198 * t75 + 0.63552391111111111111111111111111111111111111111112e-2 * t135 * t110
  t205 = t138 * t141
  t209 = 0.1e1 / t140 / t61
  t210 = t85 * t209
  t217 = (-0.19601366e1 * t87 * t164 + 0.9800683e0 * t69 * t173 + t178 * t69 - 0.4e1 * t180 * t115 + 0.6e1 * t183 * t164 - 0.2e1 * t122 * t173 + t203 * t87 - 0.6e1 * t205 * t115 + 0.12e2 * t210 * t164 - 0.3e1 * t142 * t173) * t92 * t94
  t221 = f.my_piecewise3(t1, 0, t42 * t95 / 0.4e1 + t104 * t95 / 0.6e1 + t107 * t147 / 0.2e1 - t157 * t95 / 0.18e2 + t160 * t147 / 0.6e1 + t163 * t217 / 0.4e1)
  t223 = r1 <= f.p.dens_threshold
  t224 = f.my_piecewise5(t12, t9, t8, t13, -t15)
  t225 = 0.1e1 + t224
  t226 = t225 <= f.p.zeta_threshold
  t227 = t225 ** (0.1e1 / 0.3e1)
  t228 = t227 ** 2
  t229 = 0.1e1 / t228
  t231 = f.my_piecewise5(t12, 0, t8, 0, -t25)
  t232 = t231 ** 2
  t236 = f.my_piecewise5(t12, 0, t8, 0, -t34)
  t240 = f.my_piecewise3(t226, 0, 0.4e1 / 0.9e1 * t229 * t232 + 0.4e1 / 0.3e1 * t227 * t236)
  t241 = t3 * t240
  t243 = r1 ** 2
  t244 = r1 ** (0.1e1 / 0.3e1)
  t245 = t244 ** 2
  t248 = s2 / t245 / t243
  t252 = tau1 / t245 / r1
  t254 = 0.1e1 + 0.186726e-2 * t248 + 0.373452e-2 * t252 - t60
  t260 = t254 ** 2
  t263 = s2 ** 2
  t264 = t243 ** 2
  t271 = 0.2e1 * t252 - t79
  t274 = t271 ** 2
  t282 = (-0.9800683e0 / t254 + (-0.3556788e-2 * t248 + 0.12500652e-1 * t252 - t66) / t260 + (-0.2354518e-4 * t263 / t244 / t264 / r1 - 0.1282732e-3 * t248 * t271 + 0.3574822e-3 * t274) / t260 / t254) * t92 * t94
  t287 = f.my_piecewise3(t226, 0, 0.4e1 / 0.3e1 * t227 * t231)
  t288 = t3 * t287
  t293 = f.my_piecewise3(t226, t151, t227 * t225)
  t294 = t3 * t293
  t299 = f.my_piecewise3(t223, 0, t241 * t41 * t282 / 0.4e1 + t288 * t103 * t282 / 0.6e1 - t294 * t156 * t282 / 0.18e2)
  t309 = t22 ** 2
  t313 = 0.6e1 * t31 - 0.6e1 * t14 / t309
  t314 = f.my_piecewise5(t8, 0, t12, 0, t313)
  t318 = f.my_piecewise3(t18, 0, -0.8e1 / 0.27e2 / t20 / t17 * t27 * t26 + 0.4e1 / 0.3e1 * t21 * t26 * t35 + 0.4e1 / 0.3e1 * t19 * t314)
  t336 = 0.1e1 / t102 / t22
  t350 = t164 * t115
  t353 = t115 * t173
  t358 = s0 / t45 / t73
  t360 = tau0 * t168
  t362 = -0.85202382222222222222222222222222222222222222222221e-1 * t358 - 0.60858844444444444444444444444444444444444444444446e-1 * t360
  t369 = t72 ** 2
  t412 = 0.36e2 * t138 * t209 * t164 - 0.60e2 * t85 / t140 / t68 * t350 + 0.36e2 * t210 * t353 + 0.9800683e0 * t69 * t362 + (0.16229491911111111111111111111111111111111111111111e0 * t358 - 0.20371432888888888888888888888888888888888888888889e0 * t360) * t69 + (0.58322282903703703703703703703703703703703703703702e-2 * t71 / t44 / t369 + 0.58530586074074074074074074074074074074074074074077e-2 * t358 * t80 + 0.25844674370370370370370370370370370370370370370370e-1 * s0 * t190 * tau0 - 0.63552391111111111111111111111111111111111111111112e-1 * t198 * t127 - 0.23302543407407407407407407407407407407407407407408e-1 * t135 * t168) * t87 - 0.3e1 * t142 * t362 - 0.9e1 * t203 * t141 * t115 - 0.9e1 * t205 * t173 - 0.6e1 * t178 * t87 * t115 - 0.6e1 * t180 * t173 - 0.2e1 * t122 * t362 + 0.58804098e1 * t141 * t350 - 0.58804098e1 * t87 * t115 * t173 + 0.18e2 * t120 * t141 * t164 - 0.24e2 * t67 * t209 * t350 + 0.18e2 * t183 * t353
  t418 = f.my_piecewise3(t1, 0, t3 * t318 * t41 * t95 / 0.4e1 + t40 * t103 * t95 / 0.4e1 + 0.3e1 / 0.4e1 * t42 * t147 - t101 * t156 * t95 / 0.6e1 + t104 * t147 / 0.2e1 + 0.3e1 / 0.4e1 * t107 * t217 + 0.5e1 / 0.54e2 * t154 * t336 * t95 - t157 * t147 / 0.6e1 + t160 * t217 / 0.4e1 + t163 * t412 * t92 * t94 / 0.4e1)
  t428 = f.my_piecewise5(t12, 0, t8, 0, -t313)
  t432 = f.my_piecewise3(t226, 0, -0.8e1 / 0.27e2 / t228 / t225 * t232 * t231 + 0.4e1 / 0.3e1 * t229 * t231 * t236 + 0.4e1 / 0.3e1 * t227 * t428)
  t447 = f.my_piecewise3(t223, 0, t3 * t432 * t41 * t282 / 0.4e1 + t241 * t103 * t282 / 0.4e1 - t288 * t156 * t282 / 0.6e1 + 0.5e1 / 0.54e2 * t294 * t336 * t282)
  d111 = 0.3e1 * t221 + 0.3e1 * t299 + t4 * (t418 + t447)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = jnp.pi ** (0.1e1 / 0.3e1)
  t3 = 0.1e1 / t2
  t4 = r0 + r1
  t5 = 0.1e1 / t4
  t8 = 0.2e1 * r0 * t5 <= f.p.zeta_threshold
  t9 = f.p.zeta_threshold - 0.1e1
  t12 = 0.2e1 * r1 * t5 <= f.p.zeta_threshold
  t13 = -t9
  t14 = r0 - r1
  t15 = t14 * t5
  t16 = f.my_piecewise5(t8, t9, t12, t13, t15)
  t17 = 0.1e1 + t16
  t18 = t17 <= f.p.zeta_threshold
  t19 = t17 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t17
  t23 = t4 ** 2
  t24 = 0.1e1 / t23
  t26 = -t14 * t24 + t5
  t27 = f.my_piecewise5(t8, 0, t12, 0, t26)
  t28 = t27 ** 2
  t32 = 0.1e1 / t20
  t33 = t32 * t27
  t34 = t23 * t4
  t35 = 0.1e1 / t34
  t38 = 0.2e1 * t14 * t35 - 0.2e1 * t24
  t39 = f.my_piecewise5(t8, 0, t12, 0, t38)
  t42 = t23 ** 2
  t43 = 0.1e1 / t42
  t46 = -0.6e1 * t14 * t43 + 0.6e1 * t35
  t47 = f.my_piecewise5(t8, 0, t12, 0, t46)
  t51 = f.my_piecewise3(t18, 0, -0.8e1 / 0.27e2 * t22 * t28 * t27 + 0.4e1 / 0.3e1 * t33 * t39 + 0.4e1 / 0.3e1 * t19 * t47)
  t52 = t3 * t51
  t53 = t4 ** (0.1e1 / 0.3e1)
  t54 = t52 * t53
  t55 = r0 ** 2
  t56 = r0 ** (0.1e1 / 0.3e1)
  t57 = t56 ** 2
  t59 = 0.1e1 / t57 / t55
  t60 = s0 * t59
  t64 = tau0 / t57 / r0
  t66 = 6 ** (0.1e1 / 0.3e1)
  t67 = t66 ** 2
  t68 = jnp.pi ** 2
  t69 = t68 ** (0.1e1 / 0.3e1)
  t70 = t69 ** 2
  t71 = t67 * t70
  t72 = 0.11203560000000000000000000000000000000000000000000e-2 * t71
  t73 = 0.1e1 + 0.186726e-2 * t60 + 0.373452e-2 * t64 - t72
  t78 = 0.37501956000000000000000000000000000000000000000000e-2 * t71
  t79 = -0.3556788e-2 * t60 + 0.12500652e-1 * t64 - t78
  t80 = t73 ** 2
  t81 = 0.1e1 / t80
  t83 = s0 ** 2
  t84 = t55 ** 2
  t85 = t84 * r0
  t87 = 0.1e1 / t56 / t85
  t91 = 0.3e1 / 0.5e1 * t71
  t92 = 0.2e1 * t64 - t91
  t95 = t92 ** 2
  t97 = -0.2354518e-4 * t83 * t87 - 0.1282732e-3 * t60 * t92 + 0.3574822e-3 * t95
  t98 = t80 * t73
  t99 = 0.1e1 / t98
  t103 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t104 = 0.1e1 / t103
  t106 = 4 ** (0.1e1 / 0.3e1)
  t107 = (-0.9800683e0 / t73 + t79 * t81 + t97 * t99) * t104 * t106
  t115 = f.my_piecewise3(t18, 0, 0.4e1 / 0.9e1 * t32 * t28 + 0.4e1 / 0.3e1 * t19 * t39)
  t116 = t3 * t115
  t117 = t53 ** 2
  t118 = 0.1e1 / t117
  t119 = t116 * t118
  t122 = t116 * t53
  t123 = t55 * r0
  t125 = 0.1e1 / t57 / t123
  t126 = s0 * t125
  t128 = tau0 * t59
  t130 = -0.49793600000000000000000000000000000000000000000000e-2 * t126 - 0.62242000000000000000000000000000000000000000000000e-2 * t128
  t135 = 0.94847680000000000000000000000000000000000000000000e-2 * t126 - 0.20834420000000000000000000000000000000000000000000e-1 * t128
  t137 = t79 * t99
  t140 = t84 * t55
  t142 = 0.1e1 / t56 / t140
  t150 = t92 * tau0
  t153 = 0.12557429333333333333333333333333333333333333333333e-3 * t83 * t142 + 0.34206186666666666666666666666666666666666666666667e-3 * t126 * t92 + 0.42757733333333333333333333333333333333333333333333e-3 * s0 * t87 * tau0 - 0.23832146666666666666666666666666666666666666666667e-2 * t150 * t59
  t155 = t80 ** 2
  t156 = 0.1e1 / t155
  t157 = t97 * t156
  t162 = (0.9800683e0 * t81 * t130 + t135 * t81 - 0.2e1 * t137 * t130 + t153 * t99 - 0.3e1 * t157 * t130) * t104 * t106
  t167 = f.my_piecewise3(t18, 0, 0.4e1 / 0.3e1 * t19 * t27)
  t168 = t3 * t167
  t170 = 0.1e1 / t117 / t4
  t171 = t168 * t170
  t174 = t168 * t118
  t177 = t168 * t53
  t178 = t130 ** 2
  t182 = 0.1e1 / t57 / t84
  t183 = s0 * t182
  t185 = tau0 * t125
  t187 = 0.18257653333333333333333333333333333333333333333333e-1 * t183 + 0.16597866666666666666666666666666666666666666666667e-1 * t185
  t192 = -0.34777482666666666666666666666666666666666666666667e-1 * t183 + 0.55558453333333333333333333333333333333333333333333e-1 * t185
  t194 = t135 * t99
  t197 = t79 * t156
  t204 = 0.1e1 / t56 / t84 / t123
  t212 = tau0 ** 2
  t217 = -0.79530385777777777777777777777777777777777777777776e-3 * t83 * t204 - 0.12542268444444444444444444444444444444444444444445e-2 * t183 * t92 - 0.34206186666666666666666666666666666666666666666666e-2 * s0 * t142 * tau0 + 0.79440488888888888888888888888888888888888888888890e-2 * t212 * t87 + 0.63552391111111111111111111111111111111111111111112e-2 * t150 * t125
  t219 = t153 * t156
  t223 = 0.1e1 / t155 / t73
  t224 = t97 * t223
  t231 = (-0.19601366e1 * t99 * t178 + 0.9800683e0 * t81 * t187 + t192 * t81 - 0.4e1 * t194 * t130 + 0.6e1 * t197 * t178 - 0.2e1 * t137 * t187 + t217 * t99 - 0.6e1 * t219 * t130 + 0.12e2 * t224 * t178 - 0.3e1 * t157 * t187) * t104 * t106
  t234 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t235 = t234 * f.p.zeta_threshold
  t237 = f.my_piecewise3(t18, t235, t19 * t17)
  t238 = t3 * t237
  t240 = 0.1e1 / t117 / t23
  t241 = t238 * t240
  t244 = t238 * t170
  t247 = t238 * t118
  t250 = t238 * t53
  t251 = t153 * t223
  t255 = 0.1e1 / t155 / t80
  t256 = t97 * t255
  t257 = t178 * t130
  t260 = t130 * t187
  t264 = 0.1e1 / t57 / t85
  t265 = s0 * t264
  t267 = tau0 * t182
  t269 = -0.85202382222222222222222222222222222222222222222221e-1 * t265 - 0.60858844444444444444444444444444444444444444444446e-1 * t267
  t274 = 0.16229491911111111111111111111111111111111111111111e0 * t265 - 0.20371432888888888888888888888888888888888888888889e0 * t267
  t276 = t84 ** 2
  t278 = 0.1e1 / t56 / t276
  t290 = 0.58322282903703703703703703703703703703703703703702e-2 * t83 * t278 + 0.58530586074074074074074074074074074074074074074077e-2 * t265 * t92 + 0.25844674370370370370370370370370370370370370370370e-1 * s0 * t204 * tau0 - 0.63552391111111111111111111111111111111111111111112e-1 * t212 * t142 - 0.23302543407407407407407407407407407407407407407408e-1 * t150 * t182
  t294 = t217 * t156
  t299 = t192 * t99
  t311 = t135 * t156
  t314 = t79 * t223
  t319 = 0.36e2 * t251 * t178 - 0.60e2 * t256 * t257 + 0.36e2 * t224 * t260 + 0.9800683e0 * t81 * t269 + t274 * t81 + t290 * t99 - 0.3e1 * t157 * t269 - 0.9e1 * t294 * t130 - 0.9e1 * t219 * t187 - 0.6e1 * t299 * t130 - 0.6e1 * t194 * t187 - 0.2e1 * t137 * t269 + 0.58804098e1 * t156 * t257 - 0.58804098e1 * t99 * t130 * t187 + 0.18e2 * t311 * t178 - 0.24e2 * t314 * t257 + 0.18e2 * t197 * t260
  t321 = t319 * t104 * t106
  t325 = f.my_piecewise3(t1, 0, t54 * t107 / 0.4e1 + t119 * t107 / 0.4e1 + 0.3e1 / 0.4e1 * t122 * t162 - t171 * t107 / 0.6e1 + t174 * t162 / 0.2e1 + 0.3e1 / 0.4e1 * t177 * t231 + 0.5e1 / 0.54e2 * t241 * t107 - t244 * t162 / 0.6e1 + t247 * t231 / 0.4e1 + t250 * t321 / 0.4e1)
  t327 = r1 <= f.p.dens_threshold
  t328 = f.my_piecewise5(t12, t9, t8, t13, -t15)
  t329 = 0.1e1 + t328
  t330 = t329 <= f.p.zeta_threshold
  t331 = t329 ** (0.1e1 / 0.3e1)
  t332 = t331 ** 2
  t334 = 0.1e1 / t332 / t329
  t336 = f.my_piecewise5(t12, 0, t8, 0, -t26)
  t337 = t336 ** 2
  t341 = 0.1e1 / t332
  t342 = t341 * t336
  t344 = f.my_piecewise5(t12, 0, t8, 0, -t38)
  t348 = f.my_piecewise5(t12, 0, t8, 0, -t46)
  t352 = f.my_piecewise3(t330, 0, -0.8e1 / 0.27e2 * t334 * t337 * t336 + 0.4e1 / 0.3e1 * t342 * t344 + 0.4e1 / 0.3e1 * t331 * t348)
  t353 = t3 * t352
  t355 = r1 ** 2
  t356 = r1 ** (0.1e1 / 0.3e1)
  t357 = t356 ** 2
  t360 = s2 / t357 / t355
  t364 = tau1 / t357 / r1
  t366 = 0.1e1 + 0.186726e-2 * t360 + 0.373452e-2 * t364 - t72
  t372 = t366 ** 2
  t375 = s2 ** 2
  t376 = t355 ** 2
  t383 = 0.2e1 * t364 - t91
  t386 = t383 ** 2
  t394 = (-0.9800683e0 / t366 + (-0.3556788e-2 * t360 + 0.12500652e-1 * t364 - t78) / t372 + (-0.2354518e-4 * t375 / t356 / t376 / r1 - 0.1282732e-3 * t360 * t383 + 0.3574822e-3 * t386) / t372 / t366) * t104 * t106
  t402 = f.my_piecewise3(t330, 0, 0.4e1 / 0.9e1 * t341 * t337 + 0.4e1 / 0.3e1 * t331 * t344)
  t403 = t3 * t402
  t409 = f.my_piecewise3(t330, 0, 0.4e1 / 0.3e1 * t331 * t336)
  t410 = t3 * t409
  t415 = f.my_piecewise3(t330, t235, t331 * t329)
  t416 = t3 * t415
  t421 = f.my_piecewise3(t327, 0, t353 * t53 * t394 / 0.4e1 + t403 * t118 * t394 / 0.4e1 - t410 * t170 * t394 / 0.6e1 + 0.5e1 / 0.54e2 * t416 * t240 * t394)
  t424 = 0.1e1 / t117 / t34
  t437 = t17 ** 2
  t440 = t28 ** 2
  t446 = t39 ** 2
  t455 = -0.24e2 * t43 + 0.24e2 * t14 / t42 / t4
  t456 = f.my_piecewise5(t8, 0, t12, 0, t455)
  t460 = f.my_piecewise3(t18, 0, 0.40e2 / 0.81e2 / t20 / t437 * t440 - 0.16e2 / 0.9e1 * t22 * t28 * t39 + 0.4e1 / 0.3e1 * t32 * t446 + 0.16e2 / 0.9e1 * t33 * t47 + 0.4e1 / 0.3e1 * t19 * t456)
  t481 = s0 / t57 / t140
  t483 = tau0 * t264
  t485 = 0.48281349925925925925925925925925925925925925925925e0 * t481 + 0.28400794074074074074074074074074074074074074074075e0 * t483
  t508 = t178 ** 2
  t511 = t187 ** 2
  t516 = t269 * t130
  t519 = t178 * t187
  t536 = 0.9800683e0 * t81 * t485 + (-0.91967120829629629629629629629629629629629629629629e0 * t481 + 0.95066686814814814814814814814814814814814814814815e0 * t483) * t81 + (-0.48601902419753086419753086419753086419753086419752e-1 * t83 / t56 / t276 / r0 - 0.33167332108641975308641975308641975308641975308644e-1 * t481 * t92 - 0.20903780740740740740740740740740740740740740740741e0 * s0 * t278 * tau0 + 0.48017362172839506172839506172839506172839506172840e0 * t212 * t204 + 0.10874520256790123456790123456790123456790123456790e0 * t150 * t264) * t99 - 0.235216392e2 * t223 * t508 - 0.58804098e1 * t99 * t511 + 0.72e2 * t311 * t260 + 0.24e2 * t197 * t516 - 0.144e3 * t314 * t519 - 0.360e3 * t256 * t519 + 0.48e2 * t224 * t516 + 0.144e3 * t251 * t260 - 0.8e1 * t274 * t99 * t130 - 0.12e2 * t290 * t156 * t130 - 0.12e2 * t219 * t269
  t577 = 0.72e2 * t217 * t223 * t178 + 0.18e2 * t197 * t511 + 0.36e2 * t192 * t156 * t178 - 0.96e2 * t135 * t223 * t257 - 0.12e2 * t299 * t187 - 0.8e1 * t194 * t269 - 0.2e1 * t137 * t485 + 0.352824588e2 * t156 * t178 * t187 - 0.3e1 * t157 * t485 - 0.18e2 * t294 * t187 - 0.78405464e1 * t99 * t269 * t130 + 0.120e3 * t79 * t255 * t508 + 0.360e3 * t97 / t155 / t98 * t508 + 0.36e2 * t224 * t511 - 0.240e3 * t153 * t255 * t257
  t583 = -0.20e2 / 0.81e2 * t238 * t424 * t107 + t52 * t118 * t107 / 0.3e1 - t116 * t170 * t107 / 0.3e1 + 0.10e2 / 0.27e2 * t168 * t240 * t107 + t3 * t460 * t53 * t107 / 0.4e1 + t54 * t162 + t119 * t162 + 0.3e1 / 0.2e1 * t122 * t231 - 0.2e1 / 0.3e1 * t171 * t162 + t174 * t231 + t177 * t321 + 0.10e2 / 0.27e2 * t241 * t162 - t244 * t231 / 0.3e1 + t247 * t321 / 0.3e1 + t250 * (t536 + t577) * t104 * t106 / 0.4e1
  t584 = f.my_piecewise3(t1, 0, t583)
  t585 = t329 ** 2
  t588 = t337 ** 2
  t594 = t344 ** 2
  t600 = f.my_piecewise5(t12, 0, t8, 0, -t455)
  t604 = f.my_piecewise3(t330, 0, 0.40e2 / 0.81e2 / t332 / t585 * t588 - 0.16e2 / 0.9e1 * t334 * t337 * t344 + 0.4e1 / 0.3e1 * t341 * t594 + 0.16e2 / 0.9e1 * t342 * t348 + 0.4e1 / 0.3e1 * t331 * t600)
  t622 = f.my_piecewise3(t327, 0, t3 * t604 * t53 * t394 / 0.4e1 + t353 * t118 * t394 / 0.3e1 - t403 * t170 * t394 / 0.3e1 + 0.10e2 / 0.27e2 * t410 * t240 * t394 - 0.20e2 / 0.81e2 * t416 * t424 * t394)
  d1111 = 0.4e1 * t325 + 0.4e1 * t421 + t4 * (t584 + t622)

  res = {'v4rho4': d1111}
  return res
