"""Generated from mgga_xc_lp90.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t3 = r0 + r1
  t4 = t3 ** 2
  t5 = t3 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t11 = r0 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t18 = (r0 - r1) / t3
  t20 = 0.1e1 / 0.2e1 + t18 / 0.2e1
  t21 = t20 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t26 = r1 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t32 = 0.1e1 / 0.2e1 - t18 / 0.2e1
  t33 = t32 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  res = -(0.80569 + 0.37655e-3 * (s0 + 0.2e1 * s1 + s2) / t6 / t4 - 0.37655e-3 * l0 / t12 / r0 * t22 * t20 - 0.37655e-3 * l1 / t27 / r1 * t34 * t32) / (0.1e1 / t5 + 0.40743e-2)
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = r0 ** 2
  t2 = r0 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  res = -(0.80569 + 0.37655e-3 * s0 / t3 / t1 - 0.37655e-3 * l0 / t3 / r0) / (0.1e1 / t2 + 0.40743e-2)
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = r0 ** 2
  t3 = r0 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t6 = 0.1e1 / t4 / t1 / r0
  t10 = 0.1e1 / t4 / t1
  t13 = -0.10041333333333333333333333333333333333333333333333e-2 * s0 * t6 + 0.62758333333333333333333333333333333333333333333333e-3 * l0 * t10
  t14 = 0.1e1 / t3
  t15 = t14 + 0.40743e-2
  t16 = 0.1e1 / t15
  t22 = 0.1e1 / t4 / r0
  t25 = 0.80569e0 + 0.37655000000000000000000000000000000000000000000000e-3 * s0 * t10 - 0.37655000000000000000000000000000000000000000000000e-3 * l0 * t22
  t26 = t15 ** 2
  t27 = 0.1e1 / t26
  t33 = t1 ** 2
  v2rho2_0_ = -0.2e1 * t13 * t16 - 0.2e1 / 0.9e1 * t25 * t27 / t3 / r0 - r0 * (0.36818222222222222222222222222222222222222222222221e-2 * s0 / t4 / t33 - 0.16735555555555555555555555555555555555555555555555e-2 * l0 * t6) * t16 - 0.2e1 / 0.3e1 * t14 * t13 * t27 - 0.2e1 / 0.9e1 * t22 * t25 / t26 / t15
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** 2
  t2 = t1 ** 2
  t3 = r0 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t6 = 0.1e1 / t4 / t2
  t9 = t1 * r0
  t11 = 0.1e1 / t4 / t9
  t14 = 0.36818222222222222222222222222222222222222222222221e-2 * s0 * t6 - 0.16735555555555555555555555555555555555555555555555e-2 * l0 * t11
  t15 = 0.1e1 / t3
  t16 = t15 + 0.40743e-2
  t17 = 0.1e1 / t16
  t23 = 0.1e1 / t4 / t1
  t26 = -0.10041333333333333333333333333333333333333333333333e-2 * s0 * t11 + 0.62758333333333333333333333333333333333333333333333e-3 * l0 * t23
  t27 = t16 ** 2
  t28 = 0.1e1 / t27
  t37 = 0.1e1 / t4 / r0
  t40 = 0.80569e0 + 0.37655000000000000000000000000000000000000000000000e-3 * s0 * t23 - 0.37655000000000000000000000000000000000000000000000e-3 * l0 * t37
  t42 = 0.1e1 / t27 / t16
  t68 = t27 ** 2
  v3rho3_0_ = -0.3e1 * t14 * t17 - 0.2e1 / 0.3e1 * t26 * t28 / t3 / r0 + 0.2e1 / 0.9e1 * t40 * t42 * t23 + 0.8e1 / 0.27e2 * t40 * t28 / t3 / t1 - r0 * (-0.17181837037037037037037037037037037037037037037036e-1 * s0 / t4 / t2 / r0 + 0.61363703703703703703703703703703703703703703703702e-2 * l0 * t6) * t17 - t15 * t14 * t28 - 0.2e1 / 0.3e1 * t37 * t26 * t42 - 0.2e1 / 0.9e1 / t9 * t40 / t68

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** 2
  t2 = t1 ** 2
  t4 = r0 ** (0.1e1 / 0.3e1)
  t5 = t4 ** 2
  t7 = 0.1e1 / t5 / t2 / r0
  t11 = 0.1e1 / t5 / t2
  t14 = -0.17181837037037037037037037037037037037037037037036e-1 * s0 * t7 + 0.61363703703703703703703703703703703703703703703702e-2 * l0 * t11
  t15 = 0.1e1 / t4
  t16 = t15 + 0.40743e-2
  t17 = 0.1e1 / t16
  t22 = t1 * r0
  t24 = 0.1e1 / t5 / t22
  t27 = 0.36818222222222222222222222222222222222222222222221e-2 * s0 * t11 - 0.16735555555555555555555555555555555555555555555555e-2 * l0 * t24
  t28 = t16 ** 2
  t29 = 0.1e1 / t28
  t38 = 0.1e1 / t5 / t1
  t41 = -0.10041333333333333333333333333333333333333333333333e-2 * s0 * t24 + 0.62758333333333333333333333333333333333333333333333e-3 * l0 * t38
  t43 = 0.1e1 / t28 / t16
  t55 = 0.1e1 / t5 / r0
  t58 = 0.80569e0 + 0.37655000000000000000000000000000000000000000000000e-3 * s0 * t38 - 0.37655000000000000000000000000000000000000000000000e-3 * l0 * t55
  t59 = t28 ** 2
  t60 = 0.1e1 / t59
  v4rho4_0_ = -0.4e1 * t14 * t17 - 0.4e1 / 0.3e1 * t27 * t29 / t4 / r0 + 0.8e1 / 0.9e1 * t41 * t43 * t38 + 0.32e2 / 0.27e2 * t41 * t29 / t4 / t1 + 0.8e1 / 0.9e1 * t58 * t60 / t2 - 0.32e2 / 0.81e2 * t58 * t43 * t24 - 0.56e2 / 0.81e2 * t58 * t29 / t4 / t22 - r0 * (0.97363743209876543209876543209876543209876543209871e-1 * s0 / t5 / t2 / t1 - 0.28636395061728395061728395061728395061728395061728e-1 * l0 * t7) * t17 - 0.4e1 / 0.3e1 * t15 * t14 * t29 - 0.4e1 / 0.3e1 * t55 * t27 * t43 - 0.8e1 / 0.9e1 / t22 * t41 * t60 - 0.8e1 / 0.27e2 / t4 / t2 * t58 / t59 / t16

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t2 = s0 + 0.2e1 * s1 + s2
  t3 = r0 + r1
  t4 = t3 ** 2
  t5 = t4 * t3
  t6 = t3 ** (0.1e1 / 0.3e1)
  t7 = t6 ** 2
  t11 = 0.10041333333333333333333333333333333333333333333333e-2 * t2 / t7 / t5
  t12 = r0 ** 2
  t13 = r0 ** (0.1e1 / 0.3e1)
  t14 = t13 ** 2
  t17 = l0 / t14 / t12
  t18 = r0 - r1
  t19 = 0.1e1 / t3
  t20 = t18 * t19
  t22 = 0.1e1 / 0.2e1 + t20 / 0.2e1
  t23 = t22 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = t24 * t22
  t30 = l0 / t14 / r0
  t31 = 0.1e1 / t4
  t32 = t18 * t31
  t34 = t19 / 0.2e1 - t32 / 0.2e1
  t35 = t24 * t34
  t38 = r1 ** (0.1e1 / 0.3e1)
  t39 = t38 ** 2
  t42 = l1 / t39 / r1
  t44 = 0.1e1 / 0.2e1 - t20 / 0.2e1
  t45 = t44 ** (0.1e1 / 0.3e1)
  t46 = t45 ** 2
  t47 = -t34
  t48 = t46 * t47
  t51 = -t11 + 0.62758333333333333333333333333333333333333333333333e-3 * t17 * t25 - 0.62758333333333333333333333333333333333333333333333e-3 * t30 * t35 - 0.62758333333333333333333333333333333333333333333333e-3 * t42 * t48
  t52 = 0.1e1 / t6
  t53 = t52 + 0.40743e-2
  t54 = 0.1e1 / t53
  t55 = t51 * t54
  t63 = t46 * t44
  t66 = 0.80569e0 + 0.37655000000000000000000000000000000000000000000000e-3 * t2 / t7 / t4 - 0.37655000000000000000000000000000000000000000000000e-3 * t30 * t25 - 0.37655000000000000000000000000000000000000000000000e-3 * t42 * t63
  t67 = t53 ** 2
  t68 = 0.1e1 / t67
  t73 = 0.2e1 / 0.9e1 * t66 * t68 / t6 / t3
  t74 = t4 ** 2
  t78 = 0.36818222222222222222222222222222222222222222222221e-2 * t2 / t7 / t74
  t87 = 0.1e1 / t23
  t88 = t34 ** 2
  t92 = 0.1e1 / t5
  t93 = t18 * t92
  t94 = -t31 + t93
  t98 = 0.1e1 / t45
  t99 = t47 ** 2
  t111 = t52 * t51 * t68
  t119 = 0.2e1 / 0.9e1 / t7 / t3 * t66 / t67 / t53
  d11 = -0.2e1 * t55 - t73 - t3 * (t78 - 0.16735555555555555555555555555555555555555555555555e-2 * l0 / t14 / t12 / r0 * t25 + 0.20919444444444444444444444444444444444444444444444e-2 * t17 * t35 - 0.41838888888888888888888888888888888888888888888889e-3 * t30 * t87 * t88 - 0.62758333333333333333333333333333333333333333333333e-3 * t30 * t24 * t94 - 0.41838888888888888888888888888888888888888888888889e-3 * t42 * t98 * t99 + 0.62758333333333333333333333333333333333333333333333e-3 * t42 * t46 * t94) * t54 - 0.2e1 / 0.3e1 * t111 - t119
  t121 = -t19 / 0.2e1 - t32 / 0.2e1
  t122 = t24 * t121
  t125 = r1 ** 2
  t128 = l1 / t39 / t125
  t131 = -t121
  t132 = t46 * t131
  t135 = -t11 - 0.62758333333333333333333333333333333333333333333333e-3 * t30 * t122 + 0.62758333333333333333333333333333333333333333333333e-3 * t128 * t63 - 0.62758333333333333333333333333333333333333333333333e-3 * t42 * t132
  t136 = t135 * t54
  t161 = t52 * t135 * t68
  d12 = -t55 - t73 - t136 - t3 * (t78 + 0.10459722222222222222222222222222222222222222222222e-2 * t17 * t122 - 0.41838888888888888888888888888888888888888888888889e-3 * t30 * t87 * t121 * t34 - 0.62758333333333333333333333333333333333333333333333e-3 * t30 * t24 * t18 * t92 + 0.10459722222222222222222222222222222222222222222222e-2 * t128 * t48 - 0.41838888888888888888888888888888888888888888888889e-3 * t42 * t98 * t131 * t47 + 0.62758333333333333333333333333333333333333333333333e-3 * t42 * t46 * t18 * t92) * t54 - t161 / 0.3e1 - t111 / 0.3e1 - t119
  t165 = t121 ** 2
  t169 = t31 + t93
  t181 = t131 ** 2
  d22 = -0.2e1 * t136 - t73 - t3 * (t78 - 0.41838888888888888888888888888888888888888888888889e-3 * t30 * t87 * t165 - 0.62758333333333333333333333333333333333333333333333e-3 * t30 * t24 * t169 - 0.16735555555555555555555555555555555555555555555555e-2 * l1 / t39 / t125 / r1 * t63 + 0.20919444444444444444444444444444444444444444444444e-2 * t128 * t132 - 0.41838888888888888888888888888888888888888888888889e-3 * t42 * t98 * t181 + 0.62758333333333333333333333333333333333333333333333e-3 * t42 * t46 * t169) * t54 - 0.2e1 / 0.3e1 * t161 - t119
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t2 = s0 + 0.2e1 * s1 + s2
  t3 = r0 + r1
  t4 = t3 ** 2
  t5 = t4 ** 2
  t6 = t3 ** (0.1e1 / 0.3e1)
  t7 = t6 ** 2
  t12 = r0 ** 2
  t14 = r0 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t18 = l0 / t15 / t12 / r0
  t19 = r0 - r1
  t20 = 0.1e1 / t3
  t21 = t19 * t20
  t23 = 0.1e1 / 0.2e1 + t21 / 0.2e1
  t24 = t23 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = t25 * t23
  t31 = l0 / t15 / t12
  t32 = 0.1e1 / t4
  t35 = -t19 * t32 / 0.2e1 + t20 / 0.2e1
  t36 = t25 * t35
  t41 = l0 / t15 / r0
  t42 = 0.1e1 / t24
  t43 = t35 ** 2
  t44 = t42 * t43
  t47 = t4 * t3
  t48 = 0.1e1 / t47
  t50 = t19 * t48 - t32
  t51 = t25 * t50
  t54 = r1 ** (0.1e1 / 0.3e1)
  t55 = t54 ** 2
  t58 = l1 / t55 / r1
  t60 = 0.1e1 / 0.2e1 - t21 / 0.2e1
  t61 = t60 ** (0.1e1 / 0.3e1)
  t62 = 0.1e1 / t61
  t63 = -t35
  t64 = t63 ** 2
  t68 = t61 ** 2
  t69 = -t50
  t73 = 0.36818222222222222222222222222222222222222222222221e-2 * t2 / t7 / t5 - 0.16735555555555555555555555555555555555555555555555e-2 * t18 * t26 + 0.20919444444444444444444444444444444444444444444444e-2 * t31 * t36 - 0.41838888888888888888888888888888888888888888888889e-3 * t41 * t44 - 0.62758333333333333333333333333333333333333333333333e-3 * t41 * t51 - 0.41838888888888888888888888888888888888888888888889e-3 * t58 * t62 * t64 - 0.62758333333333333333333333333333333333333333333333e-3 * t58 * t68 * t69
  t74 = 0.1e1 / t6
  t75 = t74 + 0.40743e-2
  t76 = 0.1e1 / t75
  t90 = -0.10041333333333333333333333333333333333333333333333e-2 * t2 / t7 / t47 + 0.62758333333333333333333333333333333333333333333333e-3 * t31 * t26 - 0.62758333333333333333333333333333333333333333333333e-3 * t41 * t36 - 0.62758333333333333333333333333333333333333333333333e-3 * t58 * t68 * t63
  t91 = t75 ** 2
  t92 = 0.1e1 / t91
  t99 = 0.1e1 / t7 / t4
  t107 = 0.80569e0 + 0.37655000000000000000000000000000000000000000000000e-3 * t2 * t99 - 0.37655000000000000000000000000000000000000000000000e-3 * t41 * t26 - 0.37655000000000000000000000000000000000000000000000e-3 * t58 * t68 * t60
  t109 = 0.1e1 / t91 / t75
  t123 = t12 ** 2
  t148 = 0.3e1 * t48 - 0.3e1 * t19 / t5
  t166 = -0.17181837037037037037037037037037037037037037037036e-1 * t2 / t7 / t5 / t3 + 0.61363703703703703703703703703703703703703703703702e-2 * l0 / t15 / t123 * t26 - 0.83677777777777777777777777777777777777777777777776e-2 * t18 * t36 + 0.20919444444444444444444444444444444444444444444444e-2 * t31 * t44 + 0.31379166666666666666666666666666666666666666666666e-2 * t31 * t51 + 0.13946296296296296296296296296296296296296296296296e-3 * t41 / t24 / t23 * t43 * t35 - 0.12551666666666666666666666666666666666666666666667e-2 * t41 * t42 * t35 * t50 - 0.62758333333333333333333333333333333333333333333333e-3 * t41 * t25 * t148 + 0.13946296296296296296296296296296296296296296296296e-3 * t58 / t61 / t60 * t64 * t63 - 0.12551666666666666666666666666666666666666666666667e-2 * t58 * t62 * t63 * t69 + 0.62758333333333333333333333333333333333333333333333e-3 * t58 * t68 * t148
  t177 = t91 ** 2
  d111 = -0.3e1 * t73 * t76 - 0.2e1 / 0.3e1 * t90 * t92 / t6 / t3 + 0.2e1 / 0.9e1 * t107 * t109 * t99 + 0.8e1 / 0.27e2 * t107 * t92 / t6 / t4 - t3 * t166 * t76 - t74 * t73 * t92 - 0.2e1 / 0.3e1 / t7 / t3 * t90 * t109 - 0.2e1 / 0.9e1 * t48 * t107 / t177

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t2 = s0 + 0.2e1 * s1 + s2
  t3 = r0 + r1
  t4 = t3 ** 2
  t5 = t4 ** 2
  t6 = t5 * t3
  t7 = t3 ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t13 = r0 ** 2
  t14 = t13 ** 2
  t15 = r0 ** (0.1e1 / 0.3e1)
  t16 = t15 ** 2
  t19 = l0 / t16 / t14
  t20 = r0 - r1
  t21 = 0.1e1 / t3
  t22 = t20 * t21
  t24 = 0.1e1 / 0.2e1 + t22 / 0.2e1
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = t26 * t24
  t33 = l0 / t16 / t13 / r0
  t34 = 0.1e1 / t4
  t37 = -t20 * t34 / 0.2e1 + t21 / 0.2e1
  t38 = t26 * t37
  t43 = l0 / t16 / t13
  t44 = 0.1e1 / t25
  t45 = t37 ** 2
  t46 = t44 * t45
  t49 = t4 * t3
  t50 = 0.1e1 / t49
  t52 = t20 * t50 - t34
  t53 = t26 * t52
  t58 = l0 / t16 / r0
  t60 = 0.1e1 / t25 / t24
  t62 = t60 * t45 * t37
  t65 = t44 * t37
  t66 = t65 * t52
  t69 = 0.1e1 / t5
  t72 = -0.3e1 * t20 * t69 + 0.3e1 * t50
  t73 = t26 * t72
  t76 = r1 ** (0.1e1 / 0.3e1)
  t77 = t76 ** 2
  t80 = l1 / t77 / r1
  t82 = 0.1e1 / 0.2e1 - t22 / 0.2e1
  t83 = t82 ** (0.1e1 / 0.3e1)
  t85 = 0.1e1 / t83 / t82
  t86 = -t37
  t87 = t86 ** 2
  t92 = 0.1e1 / t83
  t93 = t92 * t86
  t94 = -t52
  t98 = t83 ** 2
  t99 = -t72
  t103 = -0.17181837037037037037037037037037037037037037037036e-1 * t2 / t8 / t6 + 0.61363703703703703703703703703703703703703703703702e-2 * t19 * t27 - 0.83677777777777777777777777777777777777777777777776e-2 * t33 * t38 + 0.20919444444444444444444444444444444444444444444444e-2 * t43 * t46 + 0.31379166666666666666666666666666666666666666666666e-2 * t43 * t53 + 0.13946296296296296296296296296296296296296296296296e-3 * t58 * t62 - 0.12551666666666666666666666666666666666666666666667e-2 * t58 * t66 - 0.62758333333333333333333333333333333333333333333333e-3 * t58 * t73 + 0.13946296296296296296296296296296296296296296296296e-3 * t80 * t85 * t87 * t86 - 0.12551666666666666666666666666666666666666666666667e-2 * t80 * t93 * t94 - 0.62758333333333333333333333333333333333333333333333e-3 * t80 * t98 * t99
  t104 = 0.1e1 / t7
  t105 = t104 + 0.40743e-2
  t106 = 0.1e1 / t105
  t127 = 0.36818222222222222222222222222222222222222222222221e-2 * t2 / t8 / t5 - 0.16735555555555555555555555555555555555555555555555e-2 * t33 * t27 + 0.20919444444444444444444444444444444444444444444444e-2 * t43 * t38 - 0.41838888888888888888888888888888888888888888888889e-3 * t58 * t46 - 0.62758333333333333333333333333333333333333333333333e-3 * t58 * t53 - 0.41838888888888888888888888888888888888888888888889e-3 * t80 * t92 * t87 - 0.62758333333333333333333333333333333333333333333333e-3 * t80 * t98 * t94
  t128 = t105 ** 2
  t129 = 0.1e1 / t128
  t136 = 0.1e1 / t8 / t49
  t146 = -0.10041333333333333333333333333333333333333333333333e-2 * t2 * t136 + 0.62758333333333333333333333333333333333333333333333e-3 * t43 * t27 - 0.62758333333333333333333333333333333333333333333333e-3 * t58 * t38 - 0.62758333333333333333333333333333333333333333333333e-3 * t80 * t98 * t86
  t148 = 0.1e1 / t128 / t105
  t151 = 0.1e1 / t8 / t4
  t166 = 0.80569e0 + 0.37655000000000000000000000000000000000000000000000e-3 * t2 * t151 - 0.37655000000000000000000000000000000000000000000000e-3 * t58 * t27 - 0.37655000000000000000000000000000000000000000000000e-3 * t80 * t98 * t82
  t167 = t128 ** 2
  t168 = 0.1e1 / t167
  t191 = t24 ** 2
  t194 = t45 ** 2
  t202 = t52 ** 2
  t209 = t82 ** 2
  t212 = t87 ** 2
  t220 = t94 ** 2
  t242 = -0.12e2 * t69 + 0.12e2 * t20 / t6
  t250 = 0.97363743209876543209876543209876543209876543209871e-1 * t2 / t8 / t5 / t4 - 0.11157037037037037037037037037037037037037037037037e-1 * t33 * t46 - 0.92975308641975308641975308641975308641975308641973e-3 * t43 * t62 + 0.83677777777777777777777777777777777777777777777777e-2 * t43 * t66 - 0.18595061728395061728395061728395061728395061728395e-3 * t58 / t25 / t191 * t194 + 0.83677777777777777777777777777777777777777777777778e-3 * t58 * t60 * t45 * t52 - 0.12551666666666666666666666666666666666666666666667e-2 * t58 * t44 * t202 - 0.16735555555555555555555555555555555555555555555556e-2 * t58 * t65 * t72 - 0.18595061728395061728395061728395061728395061728395e-3 * t80 / t83 / t209 * t212 + 0.83677777777777777777777777777777777777777777777778e-3 * t80 * t85 * t87 * t94 - 0.12551666666666666666666666666666666666666666666667e-2 * t80 * t92 * t220 - 0.16735555555555555555555555555555555555555555555556e-2 * t80 * t93 * t99 - 0.28636395061728395061728395061728395061728395061728e-1 * l0 / t16 / t14 / r0 * t27 + 0.40909135802469135802469135802469135802469135802468e-1 * t19 * t38 - 0.16735555555555555555555555555555555555555555555555e-1 * t33 * t53 + 0.41838888888888888888888888888888888888888888888888e-2 * t43 * t73 - 0.62758333333333333333333333333333333333333333333333e-3 * t58 * t26 * t242 + 0.62758333333333333333333333333333333333333333333333e-3 * t80 * t98 * t242
  d1111 = -0.4e1 * t103 * t106 - 0.4e1 / 0.3e1 * t127 * t129 / t7 / t3 + 0.8e1 / 0.9e1 * t146 * t148 * t151 + 0.32e2 / 0.27e2 * t146 * t129 / t7 / t4 + 0.8e1 / 0.9e1 * t166 * t168 * t69 - 0.32e2 / 0.81e2 * t166 * t148 * t136 - 0.56e2 / 0.81e2 * t166 * t129 / t7 / t49 - t3 * t250 * t106 - 0.4e1 / 0.3e1 * t104 * t103 * t129 - 0.4e1 / 0.3e1 / t8 / t3 * t127 * t148 - 0.8e1 / 0.9e1 * t50 * t146 * t168 - 0.8e1 / 0.27e2 / t7 / t5 * t166 / t167 / t105

  res = {'v4rho4': d1111}
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  lp90_c0 = 0.80569

  lp90_d0 = 0.0030124

  lp90_k = 0.0040743

  lp90_f = lambda rs, z, xt, us0, us1: -(lp90_c0 + lp90_d0 * f.t_vw(z, xt, us0, us1)) / (rs / f.RS_FACTOR + lp90_k)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0=None, ts1=None: lp90_f(rs, z, xt, us0, us1)

  t2 = s0 + 0.2e1 * s1 + s2
  t3 = r0 + r1
  t4 = t3 ** 2
  t5 = t3 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t11 = r0 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t14 = 0.1e1 / t12 / r0
  t15 = l0 * t14
  t16 = r0 - r1
  t17 = 0.1e1 / t3
  t18 = t16 * t17
  t20 = 0.1e1 / 0.2e1 + t18 / 0.2e1
  t21 = t20 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = t22 * t20
  t26 = r1 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t29 = 0.1e1 / t27 / r1
  t30 = l1 * t29
  t32 = 0.1e1 / 0.2e1 - t18 / 0.2e1
  t33 = t32 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t35 = t34 * t32
  t38 = 0.80569e0 + 0.37655000000000000000000000000000000000000000000000e-3 * t2 / t6 / t4 - 0.37655000000000000000000000000000000000000000000000e-3 * t15 * t23 - 0.37655000000000000000000000000000000000000000000000e-3 * t30 * t35
  t39 = 0.1e1 / t5
  t40 = t39 + 0.40743e-2
  t41 = 0.1e1 / t40
  t42 = t38 * t41
  t47 = 0.10041333333333333333333333333333333333333333333333e-2 * t2 / t6 / t4 / t3
  t48 = r0 ** 2
  t55 = t16 / t4
  t57 = t17 / 0.2e1 - t55 / 0.2e1
  t69 = t40 ** 2
  t72 = t39 * t38 / t69 / 0.3e1
  vrho_0_ = -t42 - t3 * (-t47 + 0.62758333333333333333333333333333333333333333333333e-3 * l0 / t12 / t48 * t23 - 0.62758333333333333333333333333333333333333333333333e-3 * t15 * t22 * t57 + 0.62758333333333333333333333333333333333333333333333e-3 * t30 * t34 * t57) * t41 - t72
  t74 = -t17 / 0.2e1 - t55 / 0.2e1
  t78 = r1 ** 2
  vrho_1_ = -t42 - t3 * (-t47 - 0.62758333333333333333333333333333333333333333333333e-3 * t15 * t22 * t74 + 0.62758333333333333333333333333333333333333333333333e-3 * l1 / t27 / t78 * t35 + 0.62758333333333333333333333333333333333333333333333e-3 * t30 * t34 * t74) * t41 - t72
  t93 = 0.1e1 / t6 / t3 * t41
  vsigma_0_ = -0.37655000000000000000000000000000000000000000000000e-3 * t93
  vsigma_1_ = -0.75310000000000000000000000000000000000000000000000e-3 * t93
  vsigma_2_ = vsigma_0_
  vlapl_0_ = 0.37655000000000000000000000000000000000000000000000e-3 * t3 * t14 * t23 * t41
  vlapl_1_ = 0.37655000000000000000000000000000000000000000000000e-3 * t3 * t29 * t35 * t41
  vtau_0_ = 0.0e0
  vtau_1_ = 0.0e0
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  lp90_c0 = 0.80569

  lp90_d0 = 0.0030124

  lp90_k = 0.0040743

  lp90_f = lambda rs, z, xt, us0, us1: -(lp90_c0 + lp90_d0 * f.t_vw(z, xt, us0, us1)) / (rs / f.RS_FACTOR + lp90_k)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0=None, ts1=None: lp90_f(rs, z, xt, us0, us1)

  t1 = r0 ** 2
  t2 = r0 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t5 = 0.1e1 / t3 / t1
  t9 = 0.1e1 / t3 / r0
  t12 = 0.80569e0 + 0.37655000000000000000000000000000000000000000000000e-3 * s0 * t5 - 0.37655000000000000000000000000000000000000000000000e-3 * l0 * t9
  t13 = 0.1e1 / t2
  t14 = t13 + 0.40743e-2
  t15 = 0.1e1 / t14
  t28 = t14 ** 2
  vrho_0_ = -t12 * t15 - r0 * (-0.10041333333333333333333333333333333333333333333333e-2 * s0 / t3 / t1 / r0 + 0.62758333333333333333333333333333333333333333333333e-3 * l0 * t5) * t15 - t13 * t12 / t28 / 0.3e1
  vsigma_0_ = -0.37655000000000000000000000000000000000000000000000e-3 * t9 * t15
  vlapl_0_ = 0.37655000000000000000000000000000000000000000000000e-3 / t3 * t15
  vtau_0_ = 0.0e0
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

