"""Generated from gga_c_pbe_vwn.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_BB_raw = params.BB
  if isinstance(params_BB_raw, (str, bytes, dict)):
    params_BB = params_BB_raw
  else:
    try:
      params_BB_seq = list(params_BB_raw)
    except TypeError:
      params_BB = params_BB_raw
    else:
      params_BB_seq = np.asarray(params_BB_seq, dtype=np.float64)
      params_BB = np.concatenate((np.array([np.nan], dtype=np.float64), params_BB_seq))
  params_beta_raw = params.beta
  if isinstance(params_beta_raw, (str, bytes, dict)):
    params_beta = params_beta_raw
  else:
    try:
      params_beta_seq = list(params_beta_raw)
    except TypeError:
      params_beta = params_beta_raw
    else:
      params_beta_seq = np.asarray(params_beta_seq, dtype=np.float64)
      params_beta = np.concatenate((np.array([np.nan], dtype=np.float64), params_beta_seq))
  params_gamma_raw = params.gamma
  if isinstance(params_gamma_raw, (str, bytes, dict)):
    params_gamma = params_gamma_raw
  else:
    try:
      params_gamma_seq = list(params_gamma_raw)
    except TypeError:
      params_gamma = params_gamma_raw
    else:
      params_gamma_seq = np.asarray(params_gamma_seq, dtype=np.float64)
      params_gamma = np.concatenate((np.array([np.nan], dtype=np.float64), params_gamma_seq))

  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fpp_vwn = 4 / (9 * (2 ** (1 / 3) - 1))

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  mgamma = params_gamma

  mbeta = lambda rs=None, t=None: params_beta

  BB = params_BB

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  DMC = lambda rs, z=None: +f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) - f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs)

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) + f_aux(A_vwn[3], b_vwn[3], c_vwn[3], x0_vwn[3], rs) * f.f_zeta(z) * (1 - z ** 4) / fpp_vwn + DMC(rs, z) * f.f_zeta(z) * z ** 4

  functional_body = lambda rs, z, xt, xs0, xs1: f_pbe(rs, z, xt, xs0, xs1)

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_vwn(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  f1 = lambda rs, z, t: t ** 2 + BB * A(rs, z, t) * t ** 4

  f2 = lambda rs, z, t: mbeta(rs, t) * f1(rs, z, t) / (mgamma * (1 + A(rs, z, t) * f1(rs, z, t)))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_vwn(rs, z) + fH(rs, z, tp(rs, z, xt))

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_BB_raw = params.BB
  if isinstance(params_BB_raw, (str, bytes, dict)):
    params_BB = params_BB_raw
  else:
    try:
      params_BB_seq = list(params_BB_raw)
    except TypeError:
      params_BB = params_BB_raw
    else:
      params_BB_seq = np.asarray(params_BB_seq, dtype=np.float64)
      params_BB = np.concatenate((np.array([np.nan], dtype=np.float64), params_BB_seq))
  params_beta_raw = params.beta
  if isinstance(params_beta_raw, (str, bytes, dict)):
    params_beta = params_beta_raw
  else:
    try:
      params_beta_seq = list(params_beta_raw)
    except TypeError:
      params_beta = params_beta_raw
    else:
      params_beta_seq = np.asarray(params_beta_seq, dtype=np.float64)
      params_beta = np.concatenate((np.array([np.nan], dtype=np.float64), params_beta_seq))
  params_gamma_raw = params.gamma
  if isinstance(params_gamma_raw, (str, bytes, dict)):
    params_gamma = params_gamma_raw
  else:
    try:
      params_gamma_seq = list(params_gamma_raw)
    except TypeError:
      params_gamma = params_gamma_raw
    else:
      params_gamma_seq = np.asarray(params_gamma_seq, dtype=np.float64)
      params_gamma = np.concatenate((np.array([np.nan], dtype=np.float64), params_gamma_seq))

  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fpp_vwn = 4 / (9 * (2 ** (1 / 3) - 1))

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  mgamma = params_gamma

  mbeta = lambda rs=None, t=None: params_beta

  BB = params_BB

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  DMC = lambda rs, z=None: +f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) - f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs)

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) + f_aux(A_vwn[3], b_vwn[3], c_vwn[3], x0_vwn[3], rs) * f.f_zeta(z) * (1 - z ** 4) / fpp_vwn + DMC(rs, z) * f.f_zeta(z) * z ** 4

  functional_body = lambda rs, z, xt, xs0, xs1: f_pbe(rs, z, xt, xs0, xs1)

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_vwn(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  f1 = lambda rs, z, t: t ** 2 + BB * A(rs, z, t) * t ** 4

  f2 = lambda rs, z, t: mbeta(rs, t) * f1(rs, z, t) / (mgamma * (1 + A(rs, z, t) * f1(rs, z, t)))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_vwn(rs, z) + fH(rs, z, tp(rs, z, xt))

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_BB_raw = params.BB
  if isinstance(params_BB_raw, (str, bytes, dict)):
    params_BB = params_BB_raw
  else:
    try:
      params_BB_seq = list(params_BB_raw)
    except TypeError:
      params_BB = params_BB_raw
    else:
      params_BB_seq = np.asarray(params_BB_seq, dtype=np.float64)
      params_BB = np.concatenate((np.array([np.nan], dtype=np.float64), params_BB_seq))
  params_beta_raw = params.beta
  if isinstance(params_beta_raw, (str, bytes, dict)):
    params_beta = params_beta_raw
  else:
    try:
      params_beta_seq = list(params_beta_raw)
    except TypeError:
      params_beta = params_beta_raw
    else:
      params_beta_seq = np.asarray(params_beta_seq, dtype=np.float64)
      params_beta = np.concatenate((np.array([np.nan], dtype=np.float64), params_beta_seq))
  params_gamma_raw = params.gamma
  if isinstance(params_gamma_raw, (str, bytes, dict)):
    params_gamma = params_gamma_raw
  else:
    try:
      params_gamma_seq = list(params_gamma_raw)
    except TypeError:
      params_gamma = params_gamma_raw
    else:
      params_gamma_seq = np.asarray(params_gamma_seq, dtype=np.float64)
      params_gamma = np.concatenate((np.array([np.nan], dtype=np.float64), params_gamma_seq))

  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fpp_vwn = 4 / (9 * (2 ** (1 / 3) - 1))

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  mgamma = params_gamma

  mbeta = lambda rs=None, t=None: params_beta

  BB = params_BB

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  DMC = lambda rs, z=None: +f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) - f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs)

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) + f_aux(A_vwn[3], b_vwn[3], c_vwn[3], x0_vwn[3], rs) * f.f_zeta(z) * (1 - z ** 4) / fpp_vwn + DMC(rs, z) * f.f_zeta(z) * z ** 4

  functional_body = lambda rs, z, xt, xs0, xs1: f_pbe(rs, z, xt, xs0, xs1)

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_vwn(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  f1 = lambda rs, z, t: t ** 2 + BB * A(rs, z, t) * t ** 4

  f2 = lambda rs, z, t: mbeta(rs, t) * f1(rs, z, t) / (mgamma * (1 + A(rs, z, t) * f1(rs, z, t)))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_vwn(rs, z) + fH(rs, z, tp(rs, z, xt))

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t8
  t10 = t6 * t9
  t11 = t4 * t10
  t12 = t11 / 0.4e1
  t13 = jnp.sqrt(t11)
  t15 = t12 + 0.18637200000000000000000000000000000000000000000000e1 * t13 + 0.129352e2
  t16 = 0.1e1 / t15
  t20 = jnp.log(t4 * t10 * t16 / 0.4e1)
  t21 = 0.310907e-1 * t20
  t22 = t13 + 0.372744e1
  t25 = jnp.arctan(0.61519908197590802321728722658814145360143502774884e1 / t22)
  t26 = 0.38783294878113014394824731224995739188004877421366e-1 * t25
  t27 = t13 / 0.2e1
  t28 = t27 + 0.10498e0
  t29 = t28 ** 2
  t31 = jnp.log(t29 * t16)
  t32 = 0.96902277115443742137603943210562149050493484994510e-3 * t31
  t33 = jnp.pi ** 2
  t34 = 0.1e1 / t33
  t36 = t12 + 0.56553500000000000000000000000000000000000000000000e0 * t13 + 0.130045e2
  t37 = 0.1e1 / t36
  t41 = jnp.log(t4 * t10 * t37 / 0.4e1)
  t42 = t13 + 0.113107e1
  t45 = jnp.arctan(0.71231089178181179907634622339714221951452652573438e1 / t42)
  t47 = t27 + 0.47584e-2
  t48 = t47 ** 2
  t50 = jnp.log(t48 * t37)
  t53 = t34 * (t41 + 0.31770800474394146398819696256107927053514547209957e0 * t45 + 0.41403379428206274608377249480129098139321562919141e-3 * t50)
  t54 = r0 - r1
  t55 = 0.1e1 / t7
  t56 = t54 * t55
  t57 = 0.1e1 + t56
  t58 = t57 <= f.p.zeta_threshold
  t59 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t60 = t59 * f.p.zeta_threshold
  t61 = t57 ** (0.1e1 / 0.3e1)
  t63 = f.my_piecewise3(t58, t60, t61 * t57)
  t64 = 0.1e1 - t56
  t65 = t64 <= f.p.zeta_threshold
  t66 = t64 ** (0.1e1 / 0.3e1)
  t68 = f.my_piecewise3(t65, t60, t66 * t64)
  t69 = t63 + t68 - 0.2e1
  t70 = t53 * t69
  t71 = 2 ** (0.1e1 / 0.3e1)
  t72 = t71 - 0.1e1
  t74 = 0.1e1 / t72 / 0.2e1
  t75 = t54 ** 2
  t76 = t75 ** 2
  t77 = t7 ** 2
  t78 = t77 ** 2
  t79 = 0.1e1 / t78
  t83 = 0.9e1 / 0.4e1 * t72
  t84 = t74 * (-t76 * t79 + 0.1e1) * t83
  t86 = t70 * t84 / 0.6e1
  t88 = t12 + 0.35302100000000000000000000000000000000000000000000e1 * t13 + 0.180578e2
  t89 = 0.1e1 / t88
  t93 = jnp.log(t4 * t10 * t89 / 0.4e1)
  t95 = t13 + 0.706042e1
  t98 = jnp.arctan(0.47309269095601128299619512910246923284397083311420e1 / t95)
  t100 = t27 + 0.32500e0
  t101 = t100 ** 2
  t103 = jnp.log(t101 * t89)
  t105 = 0.1554535e-1 * t93 + 0.52491393169780936217021346072241076933841385384498e-1 * t98 + 0.22478670955426118383265363956423012380560746650571e-2 * t103 - t21 - t26 - t32
  t106 = t105 * t69
  t107 = t74 * t76
  t108 = t107 * t79
  t109 = t106 * t108
  t110 = t59 ** 2
  t111 = t61 ** 2
  t112 = f.my_piecewise3(t58, t110, t111)
  t113 = t66 ** 2
  t114 = f.my_piecewise3(t65, t110, t113)
  t116 = t112 / 0.2e1 + t114 / 0.2e1
  t117 = t116 ** 2
  t118 = t117 * t116
  t119 = params.gamma * t118
  t121 = s0 + 0.2e1 * s1 + s2
  t123 = 0.1e1 / t8 / t77
  t124 = t121 * t123
  t126 = 0.1e1 / t117
  t127 = t1 ** 2
  t129 = 0.1e1 / t3
  t131 = t126 * t127 * t129 * t5
  t134 = params.BB * params.beta
  t135 = 0.1e1 / params.gamma
  t137 = (t21 + t26 + t32 - t86 + t109) * t135
  t138 = 0.1e1 / t118
  t140 = jnp.exp(-t137 * t138)
  t141 = t140 - 0.1e1
  t142 = 0.1e1 / t141
  t143 = t135 * t142
  t144 = t121 ** 2
  t146 = t134 * t143 * t144
  t147 = t8 ** 2
  t149 = 0.1e1 / t147 / t78
  t150 = t71 ** 2
  t152 = t117 ** 2
  t153 = 0.1e1 / t152
  t155 = t3 ** 2
  t156 = 0.1e1 / t155
  t158 = t1 * t156 * t6
  t159 = t149 * t150 * t153 * t158
  t162 = t124 * t71 * t131 / 0.96e2 + t146 * t159 / 0.3072e4
  t163 = params.beta * t162
  t164 = params.beta * t135
  t167 = t164 * t142 * t162 + 0.1e1
  t169 = t135 / t167
  t171 = t163 * t169 + 0.1e1
  t172 = jnp.log(t171)
  t173 = t119 * t172
  t175 = 0.1e1 / t8 / t7
  t176 = t6 * t175
  t180 = t4 * t6
  t181 = t15 ** 2
  t182 = 0.1e1 / t181
  t184 = t4 * t176
  t185 = t184 / 0.12e2
  t186 = 0.1e1 / t13
  t188 = t3 * t6
  t190 = t186 * t1 * t188 * t175
  t192 = -t185 - 0.31062000000000000000000000000000000000000000000000e0 * t190
  t199 = t5 * t8
  t202 = 0.10363566666666666666666666666666666666666666666667e-1 * (-t4 * t176 * t16 / 0.12e2 - t180 * t9 * t182 * t192 / 0.4e1) * t127 * t129 * t199 * t15
  t203 = t22 ** 2
  t204 = 0.1e1 / t203
  t213 = 0.39765745675026770180313930393880960493473766078662e-1 * t204 * t186 * t1 * t188 * t175 / (0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t204)
  t224 = 0.96902277115443742137603943210562149050493484994510e-3 * (-t28 * t16 * t186 * t184 / 0.6e1 - t29 * t182 * t192) / t29 * t15
  t228 = t36 ** 2
  t229 = 0.1e1 / t228
  t232 = -t185 - 0.94255833333333333333333333333333333333333333333334e-1 * t190
  t242 = t42 ** 2
  t243 = 0.1e1 / t242
  t268 = t34 * ((-t4 * t176 * t37 / 0.12e2 - t180 * t9 * t229 * t232 / 0.4e1) * t127 * t129 * t199 * t36 / 0.3e1 + 0.37717812030896172972515701416987212375477090048242e0 * t243 * t186 * t1 * t188 * t175 / (0.1e1 + 0.50738680655100000000000000000000000000000000000000e2 * t243) + 0.41403379428206274608377249480129098139321562919141e-3 * (-t47 * t37 * t186 * t184 / 0.6e1 - t48 * t229 * t232) / t48 * t36) * t69 * t84 / 0.6e1
  t270 = t54 / t77
  t271 = t55 - t270
  t274 = f.my_piecewise3(t58, 0, 0.4e1 / 0.3e1 * t61 * t271)
  t275 = -t271
  t278 = f.my_piecewise3(t65, 0, 0.4e1 / 0.3e1 * t66 * t275)
  t279 = t274 + t278
  t282 = t53 * t279 * t84 / 0.6e1
  t283 = t75 * t54
  t284 = t283 * t79
  t285 = t78 * t7
  t286 = 0.1e1 / t285
  t287 = t76 * t286
  t293 = t70 * t74 * (-0.4e1 * t284 + 0.4e1 * t287) * t83 / 0.6e1
  t297 = t88 ** 2
  t298 = 0.1e1 / t297
  t301 = -t185 - 0.58836833333333333333333333333333333333333333333333e0 * t190
  t311 = t95 ** 2
  t312 = 0.1e1 / t311
  t335 = (0.51817833333333333333333333333333333333333333333333e-2 * (-t4 * t176 * t89 / 0.12e2 - t180 * t9 * t298 * t301 / 0.4e1) * t127 * t129 * t199 * t88 + 0.41388824077869423260215065147117773567486474051459e-1 * t312 * t186 * t1 * t188 * t175 / (0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t312) + 0.22478670955426118383265363956423012380560746650571e-2 * (-t100 * t89 * t186 * t184 / 0.6e1 - t101 * t298 * t301) / t101 * t88 - t202 - t213 - t224) * t69 * t108
  t337 = t105 * t279 * t108
  t341 = 0.4e1 * t106 * t74 * t283 * t79
  t344 = 0.4e1 * t106 * t107 * t286
  t345 = params.gamma * t117
  t346 = 0.1e1 / t61
  t349 = f.my_piecewise3(t58, 0, 0.2e1 / 0.3e1 * t346 * t271)
  t350 = 0.1e1 / t66
  t353 = f.my_piecewise3(t65, 0, 0.2e1 / 0.3e1 * t350 * t275)
  t355 = t349 / 0.2e1 + t353 / 0.2e1
  t365 = 0.7e1 / 0.288e3 * t121 / t8 / t77 / t7 * t71 * t131
  t367 = t124 * t71 * t138
  t368 = t127 * t129
  t373 = t134 * t135
  t374 = t141 ** 2
  t375 = 0.1e1 / t374
  t378 = t373 * t375 * t144 * t149
  t380 = t150 * t153 * t1
  t381 = t156 * t6
  t388 = -(t202 + t213 + t224 - t268 - t282 - t293 + t335 + t337 + t341 - t344) * t135 * t138 + 0.3e1 * t137 * t153 * t355
  t400 = 0.7e1 / 0.4608e4 * t146 / t147 / t285 * t150 * t153 * t158
  t403 = t373 * t142 * t144 * t149
  t407 = t150 / t152 / t116 * t1
  t412 = -t365 - t367 * t368 * t5 * t355 / 0.48e2 - t378 * t380 * t381 * t388 * t140 / 0.3072e4 - t400 - t403 * t407 * t381 * t355 / 0.768e3
  t415 = t167 ** 2
  t416 = 0.1e1 / t415
  t417 = t135 * t416
  t418 = t164 * t375
  t428 = 0.1e1 / t171
  t431 = t202 + t213 + t224 - t268 - t282 - t293 + t335 + t337 + t341 - t344 + 0.3e1 * t345 * t172 * t355 + t119 * (params.beta * t412 * t169 - t163 * t417 * (-t418 * t162 * t388 * t140 + t164 * t142 * t412)) * t428
  vrho_0_ = t7 * t431 + t109 + t173 + t21 + t26 + t32 - t86
  t433 = -t55 - t270
  t436 = f.my_piecewise3(t58, 0, 0.4e1 / 0.3e1 * t61 * t433)
  t437 = -t433
  t440 = f.my_piecewise3(t65, 0, 0.4e1 / 0.3e1 * t66 * t437)
  t441 = t436 + t440
  t444 = t53 * t441 * t84 / 0.6e1
  t450 = t70 * t74 * (0.4e1 * t284 + 0.4e1 * t287) * t83 / 0.6e1
  t452 = t105 * t441 * t108
  t455 = f.my_piecewise3(t58, 0, 0.2e1 / 0.3e1 * t346 * t433)
  t458 = f.my_piecewise3(t65, 0, 0.2e1 / 0.3e1 * t350 * t437)
  t460 = t455 / 0.2e1 + t458 / 0.2e1
  t474 = -(t202 + t213 + t224 - t268 - t444 - t450 + t335 + t452 - t341 - t344) * t135 * t138 + 0.3e1 * t137 * t153 * t460
  t484 = -t365 - t367 * t368 * t5 * t460 / 0.48e2 - t378 * t380 * t381 * t474 * t140 / 0.3072e4 - t400 - t403 * t407 * t381 * t460 / 0.768e3
  t498 = t202 + t213 + t224 - t268 - t444 - t450 + t335 + t452 - t341 - t344 + 0.3e1 * t345 * t172 * t460 + t119 * (params.beta * t484 * t169 - t163 * t417 * (-t418 * t162 * t474 * t140 + t164 * t142 * t484)) * t428
  vrho_1_ = t7 * t498 + t109 + t173 + t21 + t26 + t32 - t86
  t500 = t7 * params.gamma
  t504 = t123 * t71 * t126 * t368 * t5
  t508 = t134 * t143 * t121 * t159
  t510 = t504 / 0.96e2 + t508 / 0.1536e4
  t513 = params.beta ** 2
  t515 = params.gamma ** 2
  t517 = t513 * t162 / t515
  t518 = t416 * t142
  vsigma_0_ = t500 * t118 * (params.beta * t510 * t169 - t517 * t518 * t510) * t428
  t526 = t504 / 0.48e2 + t508 / 0.768e3
  vsigma_1_ = t500 * t118 * (params.beta * t526 * t169 - t517 * t518 * t526) * t428
  vsigma_2_ = vsigma_0_
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_BB_raw = params.BB
  if isinstance(params_BB_raw, (str, bytes, dict)):
    params_BB = params_BB_raw
  else:
    try:
      params_BB_seq = list(params_BB_raw)
    except TypeError:
      params_BB = params_BB_raw
    else:
      params_BB_seq = np.asarray(params_BB_seq, dtype=np.float64)
      params_BB = np.concatenate((np.array([np.nan], dtype=np.float64), params_BB_seq))
  params_beta_raw = params.beta
  if isinstance(params_beta_raw, (str, bytes, dict)):
    params_beta = params_beta_raw
  else:
    try:
      params_beta_seq = list(params_beta_raw)
    except TypeError:
      params_beta = params_beta_raw
    else:
      params_beta_seq = np.asarray(params_beta_seq, dtype=np.float64)
      params_beta = np.concatenate((np.array([np.nan], dtype=np.float64), params_beta_seq))
  params_gamma_raw = params.gamma
  if isinstance(params_gamma_raw, (str, bytes, dict)):
    params_gamma = params_gamma_raw
  else:
    try:
      params_gamma_seq = list(params_gamma_raw)
    except TypeError:
      params_gamma = params_gamma_raw
    else:
      params_gamma_seq = np.asarray(params_gamma_seq, dtype=np.float64)
      params_gamma = np.concatenate((np.array([np.nan], dtype=np.float64), params_gamma_seq))

  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fpp_vwn = 4 / (9 * (2 ** (1 / 3) - 1))

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  mgamma = params_gamma

  mbeta = lambda rs=None, t=None: params_beta

  BB = params_BB

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  DMC = lambda rs, z=None: +f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) - f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs)

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) + f_aux(A_vwn[3], b_vwn[3], c_vwn[3], x0_vwn[3], rs) * f.f_zeta(z) * (1 - z ** 4) / fpp_vwn + DMC(rs, z) * f.f_zeta(z) * z ** 4

  functional_body = lambda rs, z, xt, xs0, xs1: f_pbe(rs, z, xt, xs0, xs1)

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_vwn(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  f1 = lambda rs, z, t: t ** 2 + BB * A(rs, z, t) * t ** 4

  f2 = lambda rs, z, t: mbeta(rs, t) * f1(rs, z, t) / (mgamma * (1 + A(rs, z, t) * f1(rs, z, t)))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_vwn(rs, z) + fH(rs, z, tp(rs, z, xt))

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t10 = t4 * t9
  t11 = t10 / 0.4e1
  t12 = jnp.sqrt(t10)
  t14 = t11 + 0.18637200000000000000000000000000000000000000000000e1 * t12 + 0.129352e2
  t15 = 0.1e1 / t14
  t19 = jnp.log(t4 * t9 * t15 / 0.4e1)
  t20 = 0.310907e-1 * t19
  t21 = t12 + 0.372744e1
  t24 = jnp.arctan(0.61519908197590802321728722658814145360143502774884e1 / t21)
  t25 = 0.38783294878113014394824731224995739188004877421366e-1 * t24
  t26 = t12 / 0.2e1
  t27 = t26 + 0.10498e0
  t28 = t27 ** 2
  t30 = jnp.log(t28 * t15)
  t31 = 0.96902277115443742137603943210562149050493484994510e-3 * t30
  t32 = jnp.pi ** 2
  t33 = 0.1e1 / t32
  t35 = t11 + 0.56553500000000000000000000000000000000000000000000e0 * t12 + 0.130045e2
  t36 = 0.1e1 / t35
  t40 = jnp.log(t4 * t9 * t36 / 0.4e1)
  t41 = t12 + 0.113107e1
  t44 = jnp.arctan(0.71231089178181179907634622339714221951452652573438e1 / t41)
  t46 = t26 + 0.47584e-2
  t47 = t46 ** 2
  t49 = jnp.log(t47 * t36)
  t53 = 0.1e1 <= f.p.zeta_threshold
  t54 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t56 = f.my_piecewise3(t53, t54 * f.p.zeta_threshold, 1)
  t59 = 2 ** (0.1e1 / 0.3e1)
  t60 = t59 - 0.1e1
  t65 = 0.9e1 / 0.4e1 * t56 - 0.9e1 / 0.4e1
  t67 = t33 * (t40 + 0.31770800474394146398819696256107927053514547209957e0 * t44 + 0.41403379428206274608377249480129098139321562919141e-3 * t49) * t65 / 0.6e1
  t68 = t54 ** 2
  t69 = f.my_piecewise3(t53, t68, 1)
  t70 = t69 ** 2
  t71 = t70 * t69
  t72 = params.gamma * t71
  t73 = r0 ** 2
  t75 = 0.1e1 / t7 / t73
  t78 = 0.1e1 / t70
  t79 = t1 ** 2
  t81 = 0.1e1 / t3
  t83 = t78 * t79 * t81 * t5
  t86 = params.BB * params.beta
  t87 = 0.1e1 / params.gamma
  t90 = 0.1e1 / t71
  t92 = jnp.exp(-(t20 + t25 + t31 - t67) * t87 * t90)
  t93 = t92 - 0.1e1
  t94 = 0.1e1 / t93
  t95 = t87 * t94
  t96 = s0 ** 2
  t98 = t86 * t95 * t96
  t99 = t73 ** 2
  t100 = t7 ** 2
  t102 = 0.1e1 / t100 / t99
  t103 = t59 ** 2
  t105 = t70 ** 2
  t106 = 0.1e1 / t105
  t108 = t3 ** 2
  t109 = 0.1e1 / t108
  t111 = t1 * t109 * t6
  t112 = t102 * t103 * t106 * t111
  t115 = s0 * t75 * t59 * t83 / 0.96e2 + t98 * t112 / 0.3072e4
  t116 = params.beta * t115
  t117 = params.beta * t87
  t120 = t117 * t94 * t115 + 0.1e1
  t122 = t87 / t120
  t124 = t116 * t122 + 0.1e1
  t125 = jnp.log(t124)
  t128 = 0.1e1 / t7 / r0
  t129 = t6 * t128
  t133 = t4 * t6
  t134 = t14 ** 2
  t135 = 0.1e1 / t134
  t137 = t4 * t129
  t138 = t137 / 0.12e2
  t139 = 0.1e1 / t12
  t141 = t3 * t6
  t143 = t139 * t1 * t141 * t128
  t145 = -t138 - 0.31062000000000000000000000000000000000000000000000e0 * t143
  t152 = t5 * t7
  t155 = 0.10363566666666666666666666666666666666666666666667e-1 * (-t4 * t129 * t15 / 0.12e2 - t133 * t8 * t135 * t145 / 0.4e1) * t79 * t81 * t152 * t14
  t156 = t21 ** 2
  t157 = 0.1e1 / t156
  t166 = 0.39765745675026770180313930393880960493473766078662e-1 * t157 * t139 * t1 * t141 * t128 / (0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t157)
  t177 = 0.96902277115443742137603943210562149050493484994510e-3 * (-t27 * t15 * t139 * t137 / 0.6e1 - t28 * t135 * t145) / t28 * t14
  t181 = t35 ** 2
  t182 = 0.1e1 / t181
  t185 = -t138 - 0.94255833333333333333333333333333333333333333333334e-1 * t143
  t195 = t41 ** 2
  t196 = 0.1e1 / t195
  t220 = t33 * ((-t4 * t129 * t36 / 0.12e2 - t133 * t8 * t182 * t185 / 0.4e1) * t79 * t81 * t152 * t35 / 0.3e1 + 0.37717812030896172972515701416987212375477090048242e0 * t196 * t139 * t1 * t141 * t128 / (0.1e1 + 0.50738680655100000000000000000000000000000000000000e2 * t196) + 0.41403379428206274608377249480129098139321562919141e-3 * (-t46 * t36 * t139 * t137 / 0.6e1 - t47 * t182 * t185) / t47 * t35) * t65 / 0.6e1
  t228 = params.gamma ** 2
  t229 = 0.1e1 / t228
  t231 = t93 ** 2
  t232 = 0.1e1 / t231
  t241 = t155 + t166 + t177 - t220
  t255 = -0.7e1 / 0.288e3 * s0 / t7 / t73 / r0 * t59 * t83 + t86 * t229 * t232 * t96 * t102 * t103 / t105 / t71 * t1 * t109 * t6 * t241 * t92 / 0.3072e4 - 0.7e1 / 0.4608e4 * t98 / t100 / t99 / r0 * t103 * t106 * t111
  t258 = t120 ** 2
  t259 = 0.1e1 / t258
  t273 = 0.1e1 / t124
  vrho_0_ = t20 + t25 + t31 - t67 + t72 * t125 + r0 * (t155 + t166 + t177 - t220 + t72 * (params.beta * t255 * t122 - t116 * t87 * t259 * (params.beta * t229 * t232 * t115 * t241 * t90 * t92 + t117 * t94 * t255)) * t273)
  t289 = t75 * t59 * t78 * t79 * t81 * t5 / 0.96e2 + t86 * t95 * s0 * t112 / 0.1536e4
  t292 = params.beta ** 2
  vsigma_0_ = r0 * params.gamma * t71 * (-t292 * t115 * t229 * t259 * t94 * t289 + params.beta * t289 * t122) * t273
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t7 / r0
  t10 = t6 * t9
  t11 = 0.1e1 / t7
  t12 = t6 * t11
  t13 = t4 * t12
  t14 = t13 / 0.4e1
  t15 = jnp.sqrt(t13)
  t17 = t14 + 0.18637200000000000000000000000000000000000000000000e1 * t15 + 0.129352e2
  t18 = 0.1e1 / t17
  t22 = t4 * t6
  t23 = t17 ** 2
  t24 = 0.1e1 / t23
  t25 = t11 * t24
  t26 = t4 * t10
  t27 = t26 / 0.12e2
  t28 = 0.1e1 / t15
  t29 = t28 * t1
  t30 = t3 * t6
  t32 = t29 * t30 * t9
  t34 = -t27 - 0.31062000000000000000000000000000000000000000000000e0 * t32
  t39 = t1 ** 2
  t41 = 0.1e1 / t3
  t42 = (-t4 * t10 * t18 / 0.12e2 - t22 * t25 * t34 / 0.4e1) * t39 * t41
  t43 = t5 * t7
  t44 = t43 * t17
  t45 = t42 * t44
  t47 = t15 + 0.372744e1
  t48 = t47 ** 2
  t49 = 0.1e1 / t48
  t51 = t49 * t28 * t1
  t53 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t49
  t54 = 0.1e1 / t53
  t57 = t51 * t30 * t9 * t54
  t59 = t15 / 0.2e1
  t60 = t59 + 0.10498e0
  t61 = t60 * t18
  t62 = t61 * t28
  t65 = t60 ** 2
  t66 = t65 * t24
  t68 = -t62 * t26 / 0.6e1 - t66 * t34
  t69 = 0.1e1 / t65
  t70 = t68 * t69
  t71 = t70 * t17
  t73 = jnp.pi ** 2
  t74 = 0.1e1 / t73
  t76 = t14 + 0.56553500000000000000000000000000000000000000000000e0 * t15 + 0.130045e2
  t77 = 0.1e1 / t76
  t81 = t76 ** 2
  t82 = 0.1e1 / t81
  t83 = t11 * t82
  t85 = -t27 - 0.94255833333333333333333333333333333333333333333334e-1 * t32
  t91 = (-t4 * t10 * t77 / 0.12e2 - t22 * t83 * t85 / 0.4e1) * t39 * t41
  t92 = t43 * t76
  t95 = t15 + 0.113107e1
  t96 = t95 ** 2
  t97 = 0.1e1 / t96
  t99 = t97 * t28 * t1
  t101 = 0.1e1 + 0.50738680655100000000000000000000000000000000000000e2 * t97
  t102 = 0.1e1 / t101
  t107 = t59 + 0.47584e-2
  t108 = t107 * t77
  t109 = t108 * t28
  t112 = t107 ** 2
  t113 = t112 * t82
  t115 = -t109 * t26 / 0.6e1 - t113 * t85
  t116 = 0.1e1 / t112
  t117 = t115 * t116
  t122 = 0.1e1 <= f.p.zeta_threshold
  t123 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t125 = f.my_piecewise3(t122, t123 * f.p.zeta_threshold, 1)
  t128 = 2 ** (0.1e1 / 0.3e1)
  t129 = t128 - 0.1e1
  t134 = 0.9e1 * t125 - 0.9e1
  t135 = t74 * (t91 * t92 / 0.3e1 + 0.37717812030896172972515701416987212375477090048242e0 * t99 * t30 * t9 * t102 + 0.41403379428206274608377249480129098139321562919141e-3 * t117 * t76) * t134
  t137 = t123 ** 2
  t138 = f.my_piecewise3(t122, t137, 1)
  t139 = t138 ** 2
  t140 = t139 * t138
  t141 = params.gamma * t140
  t142 = r0 ** 2
  t145 = 0.1e1 / t7 / t142 / r0
  t148 = 0.1e1 / t139
  t151 = t148 * t39 * t41 * t5
  t154 = params.BB * params.beta
  t155 = params.gamma ** 2
  t156 = 0.1e1 / t155
  t157 = t154 * t156
  t161 = jnp.log(t4 * t12 * t18 / 0.4e1)
  t165 = jnp.arctan(0.61519908197590802321728722658814145360143502774884e1 / t47)
  t168 = jnp.log(t65 * t18)
  t173 = jnp.log(t4 * t12 * t77 / 0.4e1)
  t176 = jnp.arctan(0.71231089178181179907634622339714221951452652573438e1 / t95)
  t179 = jnp.log(t112 * t77)
  t186 = 0.1e1 / params.gamma
  t188 = 0.1e1 / t140
  t190 = jnp.exp(-(0.310907e-1 * t161 + 0.38783294878113014394824731224995739188004877421366e-1 * t165 + 0.96902277115443742137603943210562149050493484994510e-3 * t168 - t74 * (t173 + 0.31770800474394146398819696256107927053514547209957e0 * t176 + 0.41403379428206274608377249480129098139321562919141e-3 * t179) * t134 / 0.24e2) * t186 * t188)
  t191 = t190 - 0.1e1
  t192 = t191 ** 2
  t193 = 0.1e1 / t192
  t194 = s0 ** 2
  t195 = t193 * t194
  t196 = t142 ** 2
  t197 = t7 ** 2
  t199 = 0.1e1 / t197 / t196
  t200 = t195 * t199
  t201 = t157 * t200
  t202 = t128 ** 2
  t203 = t139 ** 2
  t207 = t202 / t203 / t140 * t1
  t208 = t3 ** 2
  t209 = 0.1e1 / t208
  t210 = t209 * t6
  t215 = 0.10363566666666666666666666666666666666666666666667e-1 * t45 + 0.39765745675026770180313930393880960493473766078662e-1 * t57 + 0.96902277115443742137603943210562149050493484994510e-3 * t71 - t135 / 0.24e2
  t218 = t207 * t210 * t215 * t190
  t221 = 0.1e1 / t191
  t222 = t186 * t221
  t224 = t154 * t222 * t194
  t227 = 0.1e1 / t197 / t196 / r0
  t229 = 0.1e1 / t203
  t232 = t1 * t209 * t6
  t233 = t227 * t202 * t229 * t232
  t236 = -0.7e1 / 0.288e3 * s0 * t145 * t128 * t151 + t201 * t218 / 0.3072e4 - 0.7e1 / 0.4608e4 * t224 * t233
  t237 = params.beta * t236
  t238 = params.beta * t186
  t240 = 0.1e1 / t7 / t142
  t247 = t199 * t202 * t229 * t232
  t250 = s0 * t240 * t128 * t151 / 0.96e2 + t224 * t247 / 0.3072e4
  t253 = t238 * t221 * t250 + 0.1e1
  t254 = 0.1e1 / t253
  t255 = t186 * t254
  t257 = params.beta * t250
  t258 = t253 ** 2
  t259 = 0.1e1 / t258
  t260 = t186 * t259
  t262 = params.beta * t156 * t193
  t264 = t188 * t190
  t269 = t262 * t250 * t215 * t264 + t238 * t221 * t236
  t270 = t260 * t269
  t272 = t237 * t255 - t257 * t270
  t274 = t257 * t255 + 0.1e1
  t275 = 0.1e1 / t274
  t279 = t6 * t240
  t281 = t4 * t279 * t18
  t288 = 0.1e1 / t23 / t17
  t290 = t34 ** 2
  t294 = t4 * t279
  t295 = t294 / 0.9e1
  t297 = 0.1e1 / t15 / t13
  t299 = t208 * t5
  t301 = 0.1e1 / t197 / t142
  t303 = t297 * t39 * t299 * t301
  t306 = t29 * t30 * t240
  t308 = t295 - 0.20708000000000000000000000000000000000000000000000e0 * t303 + 0.41416000000000000000000000000000000000000000000000e0 * t306
  t316 = 0.10363566666666666666666666666666666666666666666667e-1 * (t281 / 0.9e1 + t22 * t9 * t24 * t34 / 0.6e1 + t22 * t11 * t288 * t290 / 0.2e1 - t22 * t25 * t308 / 0.4e1) * t39 * t41 * t44
  t318 = t5 / t197
  t321 = 0.34545222222222222222222222222222222222222222222223e-2 * t42 * t318 * t17
  t324 = 0.10363566666666666666666666666666666666666666666667e-1 * t42 * t43 * t34
  t331 = 0.13255248558342256726771310131293653497824588692887e-1 / t48 / t47 * t1 * t3 * t279 * t54
  t337 = 0.26510497116684513453542620262587306995649177385775e-1 * t49 * t297 * t39 * t299 * t301 * t54
  t341 = 0.53020994233369026907085240525174613991298354771549e-1 * t51 * t30 * t240 * t54
  t342 = t48 ** 2
  t347 = t53 ** 2
  t351 = 0.50167127350538589836488394571946851238131125013746e0 / t342 / t47 * t1 * t3 * t279 / t347
  t362 = t39 * t208 * t5 * t301
  t374 = 0.96902277115443742137603943210562149050493484994510e-3 * (t281 / 0.72e2 + t60 * t24 * t29 * t30 * t9 * t34 / 0.3e1 - t61 * t297 * t362 / 0.9e1 + 0.2e1 / 0.9e1 * t62 * t294 + 0.2e1 * t65 * t288 * t290 - t66 * t308) * t69 * t17
  t381 = 0.16150379519240623689600657201760358175082247499085e-3 * t68 / t65 / t60 * t17 * t28 * t26
  t383 = 0.96902277115443742137603943210562149050493484994510e-3 * t70 * t34
  t385 = t4 * t279 * t77
  t392 = 0.1e1 / t81 / t76
  t394 = t85 ** 2
  t400 = t295 - 0.62837222222222222222222222222222222222222222222223e-1 * t303 + 0.12567444444444444444444444444444444444444444444445e0 * t306
  t432 = t96 ** 2
  t437 = t101 ** 2
  t474 = t74 * ((t385 / 0.9e1 + t22 * t9 * t82 * t85 / 0.6e1 + t22 * t11 * t392 * t394 / 0.2e1 - t22 * t83 * t400 / 0.4e1) * t39 * t41 * t92 / 0.3e1 + t91 * t318 * t76 / 0.9e1 + t91 * t43 * t85 / 0.3e1 + 0.12572604010298724324171900472329070791825696682747e0 / t96 / t95 * t1 * t3 * t279 * t102 + 0.25145208020597448648343800944658141583651393365495e0 * t97 * t297 * t39 * t299 * t301 * t102 - 0.50290416041194897296687601889316283167302786730989e0 * t99 * t30 * t240 * t102 - 0.63791733988157656503906862782236557702656491548799e1 / t432 / t95 * t1 * t3 * t279 / t437 + 0.41403379428206274608377249480129098139321562919141e-3 * (t385 / 0.72e2 + t107 * t82 * t29 * t30 * t9 * t85 / 0.3e1 - t108 * t297 * t362 / 0.9e1 + 0.2e1 / 0.9e1 * t109 * t294 + 0.2e1 * t112 * t392 * t394 - t113 * t400) * t116 * t76 + 0.69005632380343791013962082466881830232202604865235e-4 * t115 / t112 / t107 * t76 * t28 * t26 + 0.41403379428206274608377249480129098139321562919141e-3 * t117 * t85) * t134 / 0.24e2
  t482 = 0.1e1 / t155 / params.gamma
  t483 = t154 * t482
  t485 = 0.1e1 / t192 / t191
  t489 = t203 ** 2
  t493 = t202 / t489 / t139 * t1
  t494 = t215 ** 2
  t495 = t190 ** 2
  t505 = t316 + t321 + t324 + t331 + t337 - t341 - t351 + t374 + t381 + t383 - t474
  t525 = 0.35e2 / 0.432e3 * s0 / t7 / t196 * t128 * t151 + t483 * t485 * t194 * t199 * t493 * t210 * t494 * t495 / 0.1536e4 - 0.7e1 / 0.2304e4 * t157 * t195 * t227 * t218 + t201 * t207 * t210 * t505 * t190 / 0.3072e4 - t483 * t200 * t493 * t210 * t494 * t190 / 0.3072e4 + 0.119e3 / 0.13824e5 * t224 / t197 / t196 / t142 * t202 * t229 * t232
  t531 = 0.1e1 / t258 / t253
  t533 = t269 ** 2
  t537 = params.beta * t482
  t539 = t250 * t494
  t541 = 0.1e1 / t203 / t139
  t565 = t272 ** 2
  t566 = t274 ** 2
  t567 = 0.1e1 / t566
  t570 = t316 + t321 + t324 + t331 + t337 - t341 - t351 + t374 + t381 + t383 - t474 + t141 * (params.beta * t525 * t255 - 0.2e1 * t237 * t270 + 0.2e1 * t257 * t186 * t531 * t533 - t257 * t260 * (-t537 * t193 * t539 * t541 * t190 + 0.2e1 * t537 * t485 * t539 * t541 * t495 + 0.2e1 * t262 * t236 * t215 * t264 + t262 * t250 * t505 * t264 + t238 * t221 * t525)) * t275 - t141 * t565 * t567
  v2rho2_0_ = 0.20727133333333333333333333333333333333333333333334e-1 * t45 + 0.79531491350053540360627860787761920986947532157324e-1 * t57 + 0.19380455423088748427520788642112429810098696998902e-2 * t71 - t135 / 0.12e2 + 0.2e1 * t141 * t272 * t275 + r0 * t570
  t575 = t39 * t41 * t5
  t579 = t154 * t222 * s0
  t582 = t240 * t128 * t148 * t575 / 0.96e2 + t579 * t247 / 0.1536e4
  t583 = params.beta * t582
  t585 = params.beta ** 2
  t586 = t585 * t250
  t587 = t586 * t156
  t588 = t259 * t221
  t589 = t588 * t582
  t591 = t583 * t255 - t587 * t589
  t594 = r0 * params.gamma
  t606 = -0.7e1 / 0.288e3 * t145 * t128 * t148 * t575 + t157 * t193 * s0 * t199 * t218 / 0.1536e4 - 0.7e1 / 0.2304e4 * t579 * t233
  v2rhosigma_0_ = t141 * t591 * t275 + t594 * t140 * (-t586 * t482 * t259 * t193 * t582 * t215 * t188 * t190 + 0.2e1 * t587 * t531 * t221 * t582 * t269 - t585 * t236 * t156 * t589 + params.beta * t606 * t255 - t587 * t588 * t606 - t583 * t270) * t275 - t594 * t140 * t591 * t567 * t272
  t645 = t582 ** 2
  t653 = t585 * params.beta * t250 * t482
  t667 = t591 ** 2
  v2sigma2_0_ = t594 * t140 * (t585 * params.BB * t156 * t221 * t199 * t202 * t229 * t1 * t210 * t254 / 0.1536e4 - 0.2e1 * t585 * t645 * t156 * t259 * t221 + 0.2e1 * t653 * t531 * t193 * t645 - t653 * t259 * t193 * params.BB * t247 / 0.1536e4) * t275 - t594 * t140 * t667 * t567
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t10 = t4 * t9
  t11 = jnp.sqrt(t10)
  t12 = t11 + 0.372744e1
  t13 = t12 ** 2
  t14 = t13 ** 2
  t15 = t14 ** 2
  t17 = t1 ** 2
  t19 = t3 ** 2
  t21 = r0 ** 2
  t22 = t21 * r0
  t23 = t7 ** 2
  t25 = 0.1e1 / t23 / t22
  t26 = t5 * t25
  t27 = 0.1e1 / t13
  t29 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t27
  t30 = t29 ** 2
  t33 = 0.1e1 / t11
  t37 = 0.50631328524251801700246888250186209051365905137714e2 / t15 * t17 * t19 * t26 / t30 / t29 * t33
  t38 = t11 / 0.2e1
  t39 = t38 + 0.10498e0
  t40 = t10 / 0.4e1
  t42 = t40 + 0.18637200000000000000000000000000000000000000000000e1 * t11 + 0.129352e2
  t43 = 0.1e1 / t42
  t44 = t39 * t43
  t45 = t44 * t33
  t47 = 0.1e1 / t7 / r0
  t48 = t6 * t47
  t49 = t4 * t48
  t52 = t39 ** 2
  t53 = t42 ** 2
  t54 = 0.1e1 / t53
  t55 = t52 * t54
  t56 = t49 / 0.12e2
  t57 = t33 * t1
  t58 = t3 * t6
  t60 = t57 * t58 * t47
  t62 = -t56 - 0.31062000000000000000000000000000000000000000000000e0 * t60
  t64 = -t45 * t49 / 0.6e1 - t55 * t62
  t65 = t52 ** 2
  t70 = 0.1e1 / t7 / t21
  t71 = t6 * t70
  t72 = t4 * t71
  t74 = 0.40375948798101559224001643004400895437705618747712e-4 * t64 / t65 * t42 * t72
  t78 = 0.1e1 / t29
  t82 = 0.26510497116684513453542620262587306995649177385774e-1 / t14 * t17 * t19 * t26 * t78 * t33
  t87 = 0.1e1 / t30
  t91 = 0.23411326096918008590361250800241863911127858339748e1 / t14 / t13 * t17 * t19 * t26 * t87 * t33
  t94 = 0.1e1 / t13 / t12 * t1
  t95 = 0.1e1 / t19
  t98 = 0.1e1 / t7 / t22
  t99 = t6 * t98
  t103 = 0.22092080930570427877952183552156089163040981154812e-2 * t94 * t95 * t99 * t2 * t78
  t106 = 0.1e1 / t14 / t12 * t1
  t111 = 0.83611878917564316394147324286578085396885208356242e-1 * t106 * t95 * t99 * t2 * t87
  t113 = 0.1e1 / t11 / t10
  t115 = t27 * t113 * t17
  t116 = t19 * t5
  t120 = 0.10604198846673805381417048105034922798259670954310e0 * t115 * t116 * t25 * t78
  t122 = t27 * t33 * t1
  t126 = 0.12371565321119439611653222789207409931302949446695e0 * t122 * t58 * t98 * t78
  t128 = t4 * t71 * t43
  t130 = t39 * t54
  t131 = t130 * t57
  t136 = t44 * t113
  t137 = t17 * t19
  t139 = 0.1e1 / t23 / t21
  t141 = t137 * t5 * t139
  t147 = 0.1e1 / t53 / t42
  t148 = t52 * t147
  t149 = t62 ** 2
  t152 = t72 / 0.9e1
  t153 = t113 * t17
  t155 = t153 * t116 * t139
  t158 = t57 * t58 * t70
  t160 = t152 - 0.20708000000000000000000000000000000000000000000000e0 * t155 + 0.41416000000000000000000000000000000000000000000000e0 * t158
  t162 = t128 / 0.72e2 + t131 * t58 * t47 * t62 / 0.3e1 - t136 * t141 / 0.9e1 + 0.2e1 / 0.9e1 * t45 * t72 + 0.2e1 * t148 * t149 - t55 * t160
  t164 = 0.1e1 / t52 / t39
  t166 = t42 * t33
  t169 = 0.32300759038481247379201314403520716350164494998170e-3 * t162 * t164 * t166 * t49
  t170 = t64 * t164
  t174 = 0.32300759038481247379201314403520716350164494998170e-3 * t170 * t62 * t33 * t49
  t178 = 0.10766919679493749126400438134506905450054831666057e-3 * t170 * t42 * t113 * t141
  t179 = t170 * t166
  t181 = 0.21533839358987498252800876269013810900109663332113e-3 * t179 * t72
  t183 = t4 * t6
  t184 = t47 * t54
  t188 = t8 * t147
  t192 = t8 * t54
  t198 = 0.1e1 / t3
  t199 = (t128 / 0.9e1 + t183 * t184 * t62 / 0.6e1 + t183 * t188 * t149 / 0.2e1 - t183 * t192 * t160 / 0.4e1) * t17 * t198
  t201 = t5 / t23
  t202 = t201 * t42
  t204 = 0.69090444444444444444444444444444444444444444444446e-2 * t199 * t202
  t213 = (-t4 * t48 * t43 / 0.12e2 - t183 * t192 * t62 / 0.4e1) * t17 * t198
  t216 = t5 / t23 / r0
  t219 = 0.23030148148148148148148148148148148148148148148149e-2 * t213 * t216 * t42
  t220 = t37 + t74 + t82 - t91 + t103 - t111 - t120 + t126 + t169 + t174 + t178 - t181 + t204 - t219
  t221 = t106 * t3
  t224 = 0.18394613361864149606712411343047178787314745838373e1 * t221 * t99 * t87
  t227 = 0.69090444444444444444444444444444444444444444444446e-2 * t213 * t201 * t62
  t228 = t5 * t7
  t231 = 0.10363566666666666666666666666666666666666666666667e-1 * t213 * t228 * t160
  t232 = t228 * t62
  t234 = 0.20727133333333333333333333333333333333333333333334e-1 * t199 * t232
  t236 = t4 * t99 * t43
  t240 = t183 * t70 * t54 * t62
  t249 = t53 ** 2
  t250 = 0.1e1 / t249
  t252 = t149 * t62
  t256 = t62 * t160
  t260 = t4 * t99
  t261 = 0.7e1 / 0.27e2 * t260
  t265 = 0.1e1 / t11 / t137 / t201 / 0.4e1
  t267 = t21 ** 2
  t268 = 0.1e1 / t267
  t269 = t265 * t2 * t268
  t272 = t153 * t116 * t25
  t275 = t57 * t58 * t98
  t277 = -t261 - 0.12424800000000000000000000000000000000000000000000e1 * t269 + 0.82832000000000000000000000000000000000000000000000e0 * t272 - 0.96637333333333333333333333333333333333333333333333e0 * t275
  t284 = t228 * t42
  t286 = 0.10363566666666666666666666666666666666666666666667e-1 * (-0.7e1 / 0.27e2 * t236 - t240 / 0.3e1 - t183 * t47 * t147 * t149 / 0.2e1 + t183 * t184 * t160 / 0.4e1 - 0.3e1 / 0.2e1 * t183 * t8 * t250 * t252 + 0.3e1 / 0.2e1 * t183 * t188 * t256 - t183 * t192 * t277 / 0.4e1) * t17 * t198 * t284
  t287 = t94 * t3
  t290 = 0.48602578047254941331494803814743396158690158540586e-1 * t287 * t99 * t78
  t291 = jnp.pi ** 2
  t292 = 0.1e1 / t291
  t293 = t11 + 0.113107e1
  t294 = t293 ** 2
  t295 = t294 ** 2
  t298 = 0.1e1 / t295 / t293 * t1
  t299 = t298 * t3
  t300 = 0.1e1 / t294
  t302 = 0.1e1 + 0.50738680655100000000000000000000000000000000000000e2 * t300
  t303 = t302 ** 2
  t304 = 0.1e1 / t303
  t309 = t40 + 0.56553500000000000000000000000000000000000000000000e0 * t11 + 0.130045e2
  t310 = 0.1e1 / t309
  t314 = t309 ** 2
  t315 = 0.1e1 / t314
  t316 = t8 * t315
  t318 = -t56 - 0.94255833333333333333333333333333333333333333333334e-1 * t60
  t324 = (-t4 * t48 * t310 / 0.12e2 - t183 * t316 * t318 / 0.4e1) * t17 * t198
  t327 = t152 - 0.62837222222222222222222222222222222222222222222223e-1 * t155 + 0.12567444444444444444444444444444444444444444444445e0 * t158
  t332 = t4 * t71 * t310
  t334 = t47 * t315
  t339 = 0.1e1 / t314 / t309
  t340 = t8 * t339
  t341 = t318 ** 2
  t350 = (t332 / 0.9e1 + t183 * t334 * t318 / 0.6e1 + t183 * t340 * t341 / 0.2e1 - t183 * t316 * t327 / 0.4e1) * t17 * t198
  t351 = t228 * t318
  t358 = t4 * t99 * t310
  t362 = t183 * t70 * t315 * t318
  t371 = t314 ** 2
  t372 = 0.1e1 / t371
  t374 = t341 * t318
  t378 = t318 * t327
  t385 = -t261 - 0.37702333333333333333333333333333333333333333333334e0 * t269 + 0.25134888888888888888888888888888888888888888888890e0 * t272 - 0.29324037037037037037037037037037037037037037037038e0 * t275
  t392 = t228 * t309
  t395 = t38 + 0.47584e-2
  t396 = t395 * t310
  t397 = t396 * t33
  t400 = t395 ** 2
  t401 = t400 * t315
  t403 = -t397 * t49 / 0.6e1 - t401 * t318
  t405 = 0.1e1 / t400 / t395
  t406 = t403 * t405
  t412 = t395 * t315
  t413 = t412 * t57
  t418 = t396 * t113
  t423 = t400 * t339
  t427 = t332 / 0.72e2 + t413 * t58 * t47 * t318 / 0.3e1 - t418 * t141 / 0.9e1 + 0.2e1 / 0.9e1 * t397 * t72 + 0.2e1 * t423 * t341 - t401 * t327
  t429 = t309 * t33
  t438 = t300 * t113 * t17
  t439 = 0.1e1 / t302
  t445 = t300 * t33 * t1
  t450 = t406 * t429
  t454 = t2 * t268
  t458 = 0.23390302462324474051432516353486737824307380234560e2 * t299 * t99 * t304 + t324 * t228 * t327 / 0.3e1 + 0.2e1 / 0.3e1 * t350 * t351 + 0.2e1 / 0.9e1 * t324 * t201 * t318 + (-0.7e1 / 0.27e2 * t358 - t362 / 0.3e1 - t183 * t47 * t339 * t341 / 0.2e1 + t183 * t334 * t327 / 0.4e1 - 0.3e1 / 0.2e1 * t183 * t8 * t372 * t374 + 0.3e1 / 0.2e1 * t183 * t340 * t378 - t183 * t316 * t385 / 0.4e1) * t17 * t198 * t392 / 0.3e1 + 0.46003754920229194009308054977921220154801736576823e-4 * t406 * t309 * t113 * t141 + 0.13801126476068758202792416493376366046440520973047e-3 * t427 * t405 * t429 * t49 + 0.13801126476068758202792416493376366046440520973047e-3 * t406 * t318 * t33 * t49 - 0.10058083208238979459337520377863256633460557346198e1 * t438 * t116 * t25 * t439 + 0.11734430409612142702560440440840466072370650237231e1 * t445 * t58 * t98 * t439 - 0.92007509840458388018616109955842440309603473153646e-4 * t450 * t72 + 0.15087124812358469189006280566794884950190836019297e1 * t300 * t265 * t454 * t439
  t459 = t400 ** 2
  t465 = t295 ** 2
  t477 = 0.1e1 / t294 / t293 * t1
  t478 = t477 * t3
  t507 = t201 * t309
  t534 = t1 * t95 * t6
  t535 = t98 * t2
  t541 = t137 * t26
  t552 = -0.11e2 / 0.216e3 * t358 - t362 / 0.24e2 - t395 * t339 * t57 * t58 * t47 * t341 + t412 * t153 * t116 * t139 * t318 / 0.3e1 - 0.2e1 / 0.3e1 * t413 * t58 * t70 * t318 + t413 * t58 * t47 * t327 / 0.2e1 + t534 * t535 * t310 / 0.432e3 - 0.2e1 / 0.3e1 * t396 * t269 + 0.4e1 / 0.9e1 * t418 * t541 - 0.14e2 / 0.27e2 * t397 * t260 - 0.6e1 * t400 * t372 * t374 + 0.6e1 * t423 * t378 - t401 * t385
  t553 = 0.1e1 / t400
  t557 = t427 * t553
  t560 = t403 * t553
  t563 = 0.17251408095085947753490520616720457558050651216309e-4 * t403 / t459 * t309 * t72 + 0.86312224513605868227832795632565231845861115350066e3 / t465 * t17 * t19 * t26 / t303 / t302 * t33 - 0.46099548037761989188630301731873259570027554503406e0 * t478 * t99 * t439 + 0.25145208020597448648343800944658141583651393365494e0 / t295 * t17 * t19 * t26 * t439 * t33 - 0.29769475861140239701823202631710393594573029389440e2 / t295 / t294 * t17 * t19 * t26 * t304 * t33 + 0.20954340017164540540286500787215117986376161137912e-1 * t477 * t95 * t99 * t2 * t439 - 0.10631955664692942750651143797039426283776081924800e1 * t298 * t95 * t99 * t2 * t304 + 0.2e1 / 0.9e1 * t350 * t507 - 0.2e1 / 0.27e2 * t324 * t216 * t309 + 0.41403379428206274608377249480129098139321562919141e-3 * t552 * t553 * t309 + 0.82806758856412549216754498960258196278643125838282e-3 * t557 * t318 + 0.41403379428206274608377249480129098139321562919141e-3 * t560 * t327
  t566 = 0.1e1 <= f.p.zeta_threshold
  t567 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t569 = f.my_piecewise3(t566, t567 * f.p.zeta_threshold, 1)
  t572 = 2 ** (0.1e1 / 0.3e1)
  t573 = t572 - 0.1e1
  t578 = 0.9e1 * t569 - 0.9e1
  t580 = t292 * (t458 + t563) * t578 / 0.24e2
  t584 = 0.15906298270010708072125572157552384197389506431465e0 * t27 * t265 * t454 * t78
  t585 = t567 ** 2
  t586 = f.my_piecewise3(t566, t585, 1)
  t587 = t586 ** 2
  t588 = t587 * t586
  t589 = params.gamma * t588
  t595 = 0.1e1 / t587 * t17 * t198 * t5
  t598 = params.BB * params.beta
  t599 = params.gamma ** 2
  t600 = 0.1e1 / t599
  t601 = t598 * t600
  t605 = jnp.log(t4 * t9 * t43 / 0.4e1)
  t609 = jnp.atan(0.61519908197590802321728722658814145360143502774884e1 / t12)
  t612 = jnp.log(t52 * t43)
  t617 = jnp.log(t4 * t9 * t310 / 0.4e1)
  t620 = jnp.atan(0.71231089178181179907634622339714221951452652573438e1 / t293)
  t623 = jnp.log(t400 * t310)
  t630 = 0.1e1 / params.gamma
  t632 = 0.1e1 / t588
  t634 = jnp.exp(-(0.310907e-1 * t605 + 0.38783294878113014394824731224995739188004877421366e-1 * t609 + 0.96902277115443742137603943210562149050493484994510e-3 * t612 - t292 * (t617 + 0.31770800474394146398819696256107927053514547209957e0 * t620 + 0.41403379428206274608377249480129098139321562919141e-3 * t623) * t578 / 0.24e2) * t630 * t632)
  t635 = t634 - 0.1e1
  t636 = t635 ** 2
  t637 = 0.1e1 / t636
  t638 = s0 ** 2
  t639 = t637 * t638
  t641 = 0.1e1 / t23 / t267
  t642 = t639 * t641
  t643 = t601 * t642
  t644 = t572 ** 2
  t645 = t587 ** 2
  t649 = t644 / t645 / t588 * t1
  t650 = t95 * t6
  t657 = 0.1e1 / t52
  t658 = t64 * t657
  t673 = 0.10363566666666666666666666666666666666666666666667e-1 * t213 * t284 + 0.39765745675026770180313930393880960493473766078662e-1 * t122 * t58 * t47 * t78 + 0.96902277115443742137603943210562149050493484994510e-3 * t658 * t42 - t292 * (t324 * t392 / 0.3e1 + 0.37717812030896172972515701416987212375477090048242e0 * t445 * t58 * t47 * t439 + 0.41403379428206274608377249480129098139321562919141e-3 * t560 * t309) * t578 / 0.24e2
  t674 = t673 * t634
  t676 = t649 * t650 * t674
  t679 = 0.1e1 / t635
  t682 = t598 * t630 * t679 * t638
  t683 = t267 * r0
  t685 = 0.1e1 / t23 / t683
  t687 = 0.1e1 / t645
  t692 = -0.7e1 / 0.288e3 * s0 * t98 * t572 * t595 + t643 * t676 / 0.3072e4 - 0.7e1 / 0.4608e4 * t682 * t685 * t644 * t687 * t534
  t693 = params.beta * t692
  t694 = params.beta * t630
  t699 = t641 * t644
  t704 = s0 * t70 * t572 * t595 / 0.96e2 + t682 * t699 * t687 * t534 / 0.3072e4
  t707 = t694 * t679 * t704 + 0.1e1
  t709 = t630 / t707
  t711 = params.beta * t704
  t712 = t707 ** 2
  t714 = t630 / t712
  t716 = params.beta * t600 * t637
  t718 = t632 * t634
  t723 = t716 * t704 * t673 * t718 + t694 * t679 * t692
  t724 = t714 * t723
  t726 = t693 * t709 - t711 * t724
  t727 = t726 ** 2
  t730 = t711 * t709 + 0.1e1
  t731 = t730 ** 2
  t743 = t599 ** 2
  t744 = 0.1e1 / t743
  t745 = t598 * t744
  t746 = t636 ** 2
  t747 = 0.1e1 / t746
  t752 = t645 ** 2
  t756 = t644 / t752 / t645 / t586 * t1
  t757 = t673 ** 2
  t758 = t757 * t673
  t759 = t634 ** 2
  t760 = t759 * t634
  t767 = 0.1e1 / t599 / params.gamma
  t768 = t598 * t767
  t770 = 0.1e1 / t636 / t635
  t771 = t770 * t638
  t775 = 0.1e1 / t752 / t587
  t777 = t644 * t775 * t1
  t780 = t777 * t650 * t757 * t759
  t786 = t775 * t1 * t95
  t788 = t199 * t284
  t790 = t213 * t202
  t792 = t213 * t232
  t795 = t287 * t71 * t78
  t799 = t115 * t116 * t139 * t78
  t803 = t122 * t58 * t70 * t78
  t806 = t221 * t71 * t87
  t808 = t162 * t657
  t809 = t808 * t42
  t811 = t179 * t49
  t813 = t658 * t62
  t843 = t292 * (t350 * t392 / 0.3e1 + t324 * t507 / 0.9e1 + t324 * t351 / 0.3e1 + 0.12572604010298724324171900472329070791825696682747e0 * t478 * t71 * t439 + 0.25145208020597448648343800944658141583651393365495e0 * t438 * t116 * t139 * t439 - 0.50290416041194897296687601889316283167302786730989e0 * t445 * t58 * t70 * t439 - 0.63791733988157656503906862782236557702656491548799e1 * t299 * t71 * t304 + 0.41403379428206274608377249480129098139321562919141e-3 * t557 * t309 + 0.69005632380343791013962082466881830232202604865235e-4 * t450 * t49 + 0.41403379428206274608377249480129098139321562919141e-3 * t560 * t318) * t578
  t845 = 0.10363566666666666666666666666666666666666666666667e-1 * t788 + 0.34545222222222222222222222222222222222222222222223e-2 * t790 + 0.10363566666666666666666666666666666666666666666667e-1 * t792 + 0.13255248558342256726771310131293653497824588692887e-1 * t795 + 0.26510497116684513453542620262587306995649177385775e-1 * t799 - 0.53020994233369026907085240525174613991298354771549e-1 * t803 - 0.50167127350538589836488394571946851238131125013746e0 * t806 + 0.96902277115443742137603943210562149050493484994510e-3 * t809 + 0.16150379519240623689600657201760358175082247499085e-3 * t811 + 0.96902277115443742137603943210562149050493484994510e-3 * t813 - t843 / 0.24e2
  t846 = t759 * t845
  t851 = t771 * t641
  t860 = 0.1e1 / t23 / t267 / t21
  t865 = t639 * t685
  t866 = t601 * t865
  t869 = t649 * t650 * t845 * t634
  t875 = t777 * t650 * t757 * t634
  t878 = t37 + t74 + t82 - t91 + t103 - t111 - t120 + t126 + t169 + t174 + t178 - t181
  t914 = -0.11e2 / 0.216e3 * t236 - t240 / 0.24e2 - t39 * t147 * t57 * t58 * t47 * t149 + t130 * t153 * t116 * t139 * t62 / 0.3e1 - 0.2e1 / 0.3e1 * t131 * t58 * t70 * t62 + t131 * t58 * t47 * t160 / 0.2e1 + t534 * t535 * t43 / 0.432e3 - 0.2e1 / 0.3e1 * t44 * t269 + 0.4e1 / 0.9e1 * t136 * t541 - 0.14e2 / 0.27e2 * t45 * t260 - 0.6e1 * t52 * t250 * t252 + 0.6e1 * t148 * t256 - t55 * t277
  t917 = 0.96902277115443742137603943210562149050493484994510e-3 * t914 * t657 * t42
  t919 = 0.19380455423088748427520788642112429810098696998902e-2 * t808 * t62
  t921 = 0.96902277115443742137603943210562149050493484994510e-3 * t658 * t160
  t922 = t204 - t219 + t224 + t227 + t231 + t234 + t286 - t290 - t580 + t584 + t917 + t919 + t921
  t923 = t878 + t922
  t950 = -0.455e3 / 0.1296e4 * s0 / t7 / t683 * t572 * t595 + t745 * t747 * t638 * t641 * t756 * t650 * t758 * t760 / 0.512e3 - 0.7e1 / 0.768e3 * t768 * t771 * t685 * t780 + t768 * t771 * t699 * t786 * t6 * t673 * t846 / 0.512e3 - t745 * t851 * t756 * t650 * t758 * t759 / 0.512e3 + 0.119e3 / 0.4608e4 * t601 * t639 * t860 * t676 - 0.7e1 / 0.1536e4 * t866 * t869 + 0.7e1 / 0.1536e4 * t768 * t865 * t875 + t643 * t649 * t650 * t923 * t634 / 0.3072e4 - t768 * t639 * t699 * t786 * t6 * t845 * t674 / 0.1024e4 + t745 * t642 * t756 * t650 * t758 * t634 / 0.3072e4 - 0.595e3 / 0.10368e5 * t682 / t23 / t267 / t22 * t644 * t687 * t534
  t974 = 0.35e2 / 0.432e3 * s0 / t7 / t267 * t572 * t595 + t768 * t851 * t780 / 0.1536e4 - 0.7e1 / 0.2304e4 * t866 * t676 + t643 * t869 / 0.3072e4 - t768 * t642 * t875 / 0.3072e4 + 0.119e3 / 0.13824e5 * t682 * t860 * t644 * t687 * t534
  t975 = params.beta * t974
  t979 = 0.1e1 / t712 / t707
  t981 = t723 ** 2
  t982 = t630 * t979 * t981
  t985 = params.beta * t767
  t986 = t985 * t770
  t987 = t704 * t757
  t989 = 0.1e1 / t645 / t587
  t990 = t989 * t759
  t1001 = t985 * t637
  t1002 = t989 * t634
  t1007 = 0.2e1 * t716 * t692 * t673 * t718 + t716 * t704 * t845 * t718 - t1001 * t987 * t1002 + t694 * t679 * t974 + 0.2e1 * t986 * t987 * t990
  t1008 = t714 * t1007
  t1011 = t712 ** 2
  t1023 = params.beta * t744
  t1025 = t704 * t758
  t1027 = 0.1e1 / t752 / t586
  t1032 = t692 * t757
  t1073 = -0.3e1 * t985 * t637 * t704 * t845 * t989 * t674 + 0.6e1 * t985 * t770 * t704 * t673 * t989 * t846 + t1023 * t637 * t1025 * t1027 * t634 + 0.6e1 * t1023 * t747 * t1025 * t1027 * t760 - 0.6e1 * t1023 * t770 * t1025 * t1027 * t759 + 0.3e1 * t716 * t974 * t673 * t718 + 0.3e1 * t716 * t692 * t845 * t718 + t716 * t704 * t923 * t718 - 0.3e1 * t1001 * t1032 * t1002 + 0.6e1 * t986 * t1032 * t990 + t694 * t679 * t950
  t1077 = 0.1e1 / t730
  t1086 = -t711 * t1008 - 0.2e1 * t693 * t724 + t975 * t709 + 0.2e1 * t711 * t982
  t1087 = 0.1e1 / t731
  t1092 = t224 + t227 + t231 + t234 + t286 - t290 - t580 + t584 + 0.2e1 * t589 * t727 * t726 / t731 / t730 + t589 * (params.beta * t950 * t709 - 0.3e1 * t975 * t724 + 0.6e1 * t693 * t982 - 0.3e1 * t693 * t1008 - 0.6e1 * t711 * t630 / t1011 * t981 * t723 + 0.6e1 * t711 * t630 * t979 * t723 * t1007 - t711 * t714 * t1073) * t1077 + t917 + t919 + t921 - 0.3e1 * t589 * t1086 * t1087 * t726
  v3rho3_0_ = r0 * (t220 + t1092) - t843 / 0.8e1 + 0.29070683134633122641281182963168644715148045498353e-2 * t813 + 0.29070683134633122641281182963168644715148045498353e-2 * t809 - 0.3e1 * t589 * t727 * t1087 + 0.31090700000000000000000000000000000000000000000001e-1 * t788 + 0.10363566666666666666666666666666666666666666666667e-1 * t790 + 0.31090700000000000000000000000000000000000000000001e-1 * t792 + 0.39765745675026770180313930393880960493473766078662e-1 * t795 - 0.15050138205161576950946518371584055371439337504124e1 * t806 + 0.48451138557721871068801971605281074525246742497255e-3 * t811 + 0.79531491350053540360627860787761920986947532157324e-1 * t799 - 0.15906298270010708072125572157552384197389506431465e0 * t803 + 0.3e1 * t589 * t1086 * t1077

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t10 = t4 * t9
  t11 = jnp.sqrt(t10)
  t12 = t11 / 0.2e1
  t13 = t12 + 0.10498e0
  t14 = t10 / 0.4e1
  t16 = t14 + 0.18637200000000000000000000000000000000000000000000e1 * t11 + 0.129352e2
  t17 = 0.1e1 / t16
  t18 = t13 * t17
  t19 = 0.1e1 / t11
  t20 = t18 * t19
  t22 = 0.1e1 / t7 / r0
  t23 = t6 * t22
  t24 = t4 * t23
  t27 = t13 ** 2
  t28 = t16 ** 2
  t29 = 0.1e1 / t28
  t30 = t27 * t29
  t31 = t24 / 0.12e2
  t32 = t19 * t1
  t33 = t3 * t6
  t35 = t32 * t33 * t22
  t37 = -t31 - 0.31062000000000000000000000000000000000000000000000e0 * t35
  t39 = -t20 * t24 / 0.6e1 - t30 * t37
  t40 = t27 ** 2
  t41 = 0.1e1 / t40
  t42 = t39 * t41
  t43 = t42 * t16
  t44 = r0 ** 2
  t46 = 0.1e1 / t7 / t44
  t47 = t6 * t46
  t48 = t4 * t47
  t49 = t43 * t48
  t51 = t11 + 0.372744e1
  t52 = t51 ** 2
  t53 = t52 ** 2
  t54 = 0.1e1 / t53
  t55 = t1 ** 2
  t56 = t54 * t55
  t57 = t3 ** 2
  t58 = t56 * t57
  t59 = t44 * r0
  t60 = t7 ** 2
  t62 = 0.1e1 / t60 / t59
  t63 = t5 * t62
  t64 = 0.1e1 / t52
  t66 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t64
  t67 = 0.1e1 / t66
  t68 = t67 * t19
  t70 = t58 * t63 * t68
  t73 = 0.1e1 / t53 / t52
  t74 = t73 * t55
  t75 = t74 * t57
  t76 = t66 ** 2
  t77 = 0.1e1 / t76
  t78 = t77 * t19
  t80 = t75 * t63 * t78
  t82 = t52 * t51
  t84 = 0.1e1 / t82 * t1
  t85 = 0.1e1 / t57
  t86 = t84 * t85
  t88 = 0.1e1 / t7 / t59
  t89 = t6 * t88
  t90 = t2 * t67
  t92 = t86 * t89 * t90
  t95 = 0.1e1 / t53 / t51
  t96 = t95 * t1
  t97 = t96 * t85
  t98 = t2 * t77
  t100 = t97 * t89 * t98
  t103 = 0.1e1 / t11 / t10
  t105 = t64 * t103 * t55
  t106 = t57 * t5
  t109 = t105 * t106 * t62 * t67
  t112 = t64 * t19 * t1
  t115 = t112 * t33 * t88 * t67
  t117 = t53 ** 2
  t118 = 0.1e1 / t117
  t119 = t118 * t55
  t120 = t119 * t57
  t122 = 0.1e1 / t76 / t66
  t123 = t122 * t19
  t125 = t120 * t63 * t123
  t127 = 0.1e1 <= f.p.zeta_threshold
  t128 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t129 = t128 ** 2
  t130 = f.my_piecewise3(t127, t129, 1)
  t131 = t130 ** 2
  t132 = t131 * t130
  t133 = params.gamma * t132
  t134 = t44 ** 2
  t136 = 0.1e1 / t7 / t134
  t138 = 2 ** (0.1e1 / 0.3e1)
  t142 = 0.1e1 / t3
  t143 = t142 * t5
  t144 = 0.1e1 / t131 * t55 * t143
  t147 = params.BB * params.beta
  t148 = params.gamma ** 2
  t150 = 0.1e1 / t148 / params.gamma
  t151 = t147 * t150
  t155 = jnp.log(t4 * t9 * t17 / 0.4e1)
  t159 = jnp.atan(0.61519908197590802321728722658814145360143502774884e1 / t51)
  t162 = jnp.log(t27 * t17)
  t164 = jnp.pi ** 2
  t165 = 0.1e1 / t164
  t167 = t14 + 0.56553500000000000000000000000000000000000000000000e0 * t11 + 0.130045e2
  t168 = 0.1e1 / t167
  t172 = jnp.log(t4 * t9 * t168 / 0.4e1)
  t173 = t11 + 0.113107e1
  t176 = jnp.atan(0.71231089178181179907634622339714221951452652573438e1 / t173)
  t178 = t12 + 0.47584e-2
  t179 = t178 ** 2
  t181 = jnp.log(t179 * t168)
  t186 = f.my_piecewise3(t127, t128 * f.p.zeta_threshold, 1)
  t189 = t138 - 0.1e1
  t194 = 0.9e1 * t186 - 0.9e1
  t198 = 0.1e1 / params.gamma
  t200 = 0.1e1 / t132
  t202 = jnp.exp(-(0.310907e-1 * t155 + 0.38783294878113014394824731224995739188004877421366e-1 * t159 + 0.96902277115443742137603943210562149050493484994510e-3 * t162 - t165 * (t172 + 0.31770800474394146398819696256107927053514547209957e0 * t176 + 0.41403379428206274608377249480129098139321562919141e-3 * t181) * t194 / 0.24e2) * t198 * t200)
  t203 = t202 - 0.1e1
  t204 = t203 ** 2
  t206 = 0.1e1 / t204 / t203
  t207 = s0 ** 2
  t208 = t206 * t207
  t210 = 0.1e1 / t60 / t134
  t211 = t208 * t210
  t212 = t151 * t211
  t213 = t138 ** 2
  t214 = t131 ** 2
  t215 = t214 ** 2
  t217 = 0.1e1 / t215 / t131
  t219 = t213 * t217 * t1
  t220 = t85 * t6
  t224 = t4 * t6
  t225 = t8 * t29
  t231 = (-t4 * t23 * t17 / 0.12e2 - t224 * t225 * t37 / 0.4e1) * t55 * t142
  t232 = t5 * t7
  t233 = t232 * t16
  t240 = 0.1e1 / t27
  t241 = t39 * t240
  t247 = t167 ** 2
  t248 = 0.1e1 / t247
  t249 = t8 * t248
  t251 = -t31 - 0.94255833333333333333333333333333333333333333333334e-1 * t35
  t257 = (-t4 * t23 * t168 / 0.12e2 - t224 * t249 * t251 / 0.4e1) * t55 * t142
  t258 = t232 * t167
  t261 = t173 ** 2
  t262 = 0.1e1 / t261
  t264 = t262 * t19 * t1
  t266 = 0.1e1 + 0.50738680655100000000000000000000000000000000000000e2 * t262
  t267 = 0.1e1 / t266
  t272 = t178 * t168
  t273 = t272 * t19
  t276 = t179 * t248
  t278 = -t273 * t24 / 0.6e1 - t276 * t251
  t279 = 0.1e1 / t179
  t280 = t278 * t279
  t287 = 0.10363566666666666666666666666666666666666666666667e-1 * t231 * t233 + 0.39765745675026770180313930393880960493473766078662e-1 * t112 * t33 * t22 * t67 + 0.96902277115443742137603943210562149050493484994510e-3 * t241 * t16 - t165 * (t257 * t258 / 0.3e1 + 0.37717812030896172972515701416987212375477090048242e0 * t264 * t33 * t22 * t267 + 0.41403379428206274608377249480129098139321562919141e-3 * t280 * t167) * t194 / 0.24e2
  t288 = t287 ** 2
  t289 = t202 ** 2
  t292 = t219 * t220 * t288 * t289
  t295 = 0.1e1 / t148
  t296 = t147 * t295
  t297 = 0.1e1 / t204
  t298 = t297 * t207
  t299 = t134 * r0
  t301 = 0.1e1 / t60 / t299
  t302 = t298 * t301
  t303 = t296 * t302
  t307 = t213 / t214 / t132 * t1
  t308 = t287 * t202
  t310 = t307 * t220 * t308
  t313 = t298 * t210
  t314 = t296 * t313
  t316 = t4 * t47 * t17
  t318 = t22 * t29
  t323 = 0.1e1 / t28 / t16
  t324 = t8 * t323
  t325 = t37 ** 2
  t329 = t48 / 0.9e1
  t330 = t103 * t55
  t332 = 0.1e1 / t60 / t44
  t334 = t330 * t106 * t332
  t337 = t32 * t33 * t46
  t339 = t329 - 0.20708000000000000000000000000000000000000000000000e0 * t334 + 0.41416000000000000000000000000000000000000000000000e0 * t337
  t345 = (t316 / 0.9e1 + t224 * t318 * t37 / 0.6e1 + t224 * t324 * t325 / 0.2e1 - t224 * t225 * t339 / 0.4e1) * t55 * t142
  t349 = t5 / t60
  t350 = t349 * t16
  t353 = t232 * t37
  t356 = t84 * t3
  t368 = t96 * t3
  t373 = t13 * t29
  t374 = t373 * t32
  t375 = t22 * t37
  t379 = t18 * t103
  t380 = t55 * t57
  t381 = t5 * t332
  t382 = t380 * t381
  t387 = t27 * t323
  t391 = t316 / 0.72e2 + t374 * t33 * t375 / 0.3e1 - t379 * t382 / 0.9e1 + 0.2e1 / 0.9e1 * t20 * t48 + 0.2e1 * t387 * t325 - t30 * t339
  t392 = t391 * t240
  t396 = 0.1e1 / t27 / t13
  t397 = t39 * t396
  t398 = t16 * t19
  t399 = t397 * t398
  t405 = t4 * t47 * t168
  t407 = t22 * t248
  t412 = 0.1e1 / t247 / t167
  t413 = t8 * t412
  t414 = t251 ** 2
  t420 = t329 - 0.62837222222222222222222222222222222222222222222223e-1 * t334 + 0.12567444444444444444444444444444444444444444444445e0 * t337
  t426 = (t405 / 0.9e1 + t224 * t407 * t251 / 0.6e1 + t224 * t413 * t414 / 0.2e1 - t224 * t249 * t420 / 0.4e1) * t55 * t142
  t429 = t349 * t167
  t432 = t232 * t251
  t435 = t261 * t173
  t436 = 0.1e1 / t435
  t437 = t436 * t1
  t438 = t437 * t3
  t443 = t262 * t103 * t55
  t452 = t261 ** 2
  t454 = 0.1e1 / t452 / t173
  t455 = t454 * t1
  t456 = t455 * t3
  t457 = t266 ** 2
  t458 = 0.1e1 / t457
  t463 = t178 * t248
  t464 = t463 * t32
  t465 = t22 * t251
  t469 = t272 * t103
  t474 = t179 * t412
  t478 = t405 / 0.72e2 + t464 * t33 * t465 / 0.3e1 - t469 * t382 / 0.9e1 + 0.2e1 / 0.9e1 * t273 * t48 + 0.2e1 * t474 * t414 - t276 * t420
  t479 = t478 * t279
  t483 = 0.1e1 / t179 / t178
  t484 = t278 * t483
  t485 = t167 * t19
  t486 = t484 * t485
  t495 = 0.10363566666666666666666666666666666666666666666667e-1 * t345 * t233 + 0.34545222222222222222222222222222222222222222222223e-2 * t231 * t350 + 0.10363566666666666666666666666666666666666666666667e-1 * t231 * t353 + 0.13255248558342256726771310131293653497824588692887e-1 * t356 * t47 * t67 + 0.26510497116684513453542620262587306995649177385775e-1 * t105 * t106 * t332 * t67 - 0.53020994233369026907085240525174613991298354771549e-1 * t112 * t33 * t46 * t67 - 0.50167127350538589836488394571946851238131125013746e0 * t368 * t47 * t77 + 0.96902277115443742137603943210562149050493484994510e-3 * t392 * t16 + 0.16150379519240623689600657201760358175082247499085e-3 * t399 * t24 + 0.96902277115443742137603943210562149050493484994510e-3 * t241 * t37 - t165 * (t426 * t258 / 0.3e1 + t257 * t429 / 0.9e1 + t257 * t432 / 0.3e1 + 0.12572604010298724324171900472329070791825696682747e0 * t438 * t47 * t267 + 0.25145208020597448648343800944658141583651393365495e0 * t443 * t106 * t332 * t267 - 0.50290416041194897296687601889316283167302786730989e0 * t264 * t33 * t46 * t267 - 0.63791733988157656503906862782236557702656491548799e1 * t456 * t47 * t458 + 0.41403379428206274608377249480129098139321562919141e-3 * t479 * t167 + 0.69005632380343791013962082466881830232202604865235e-4 * t486 * t24 + 0.41403379428206274608377249480129098139321562919141e-3 * t280 * t251) * t194 / 0.24e2
  t498 = t307 * t220 * t495 * t202
  t501 = t151 * t313
  t502 = t288 * t202
  t504 = t219 * t220 * t502
  t507 = 0.1e1 / t203
  t510 = t147 * t198 * t507 * t207
  t511 = t134 * t44
  t513 = 0.1e1 / t60 / t511
  t515 = 0.1e1 / t214
  t518 = t1 * t85 * t6
  t522 = 0.35e2 / 0.432e3 * s0 * t136 * t138 * t144 + t212 * t292 / 0.1536e4 - 0.7e1 / 0.2304e4 * t303 * t310 + t314 * t498 / 0.3072e4 - t501 * t504 / 0.3072e4 + 0.119e3 / 0.13824e5 * t510 * t513 * t213 * t515 * t518
  t523 = params.beta * t522
  t524 = params.beta * t198
  t529 = t210 * t213
  t534 = s0 * t46 * t138 * t144 / 0.96e2 + t510 * t529 * t515 * t518 / 0.3072e4
  t537 = t524 * t507 * t534 + 0.1e1
  t539 = t198 / t537
  t547 = t301 * t213
  t552 = -0.7e1 / 0.288e3 * s0 * t88 * t138 * t144 + t314 * t310 / 0.3072e4 - 0.7e1 / 0.4608e4 * t510 * t547 * t515 * t518
  t553 = params.beta * t552
  t554 = t537 ** 2
  t556 = t198 / t554
  t558 = params.beta * t295 * t297
  t560 = t200 * t202
  t565 = t558 * t534 * t287 * t560 + t524 * t507 * t552
  t566 = t556 * t565
  t569 = params.beta * t534
  t571 = 0.1e1 / t554 / t537
  t572 = t198 * t571
  t573 = t565 ** 2
  t574 = t572 * t573
  t577 = params.beta * t150
  t578 = t577 * t206
  t579 = t534 * t288
  t581 = 0.1e1 / t214 / t131
  t582 = t581 * t289
  t593 = t577 * t297
  t594 = t581 * t202
  t599 = 0.2e1 * t558 * t552 * t287 * t560 + t558 * t534 * t495 * t560 + t524 * t507 * t522 + 0.2e1 * t578 * t579 * t582 - t593 * t579 * t594
  t600 = t556 * t599
  t602 = t523 * t539 - 0.2e1 * t553 * t566 + 0.2e1 * t569 * t574 - t569 * t600
  t604 = t569 * t539 + 0.1e1
  t605 = t604 ** 2
  t606 = 0.1e1 / t605
  t610 = t553 * t539 - t569 * t566
  t615 = 0.1e1 / t7 / t299
  t620 = t148 ** 2
  t621 = 0.1e1 / t620
  t622 = t147 * t621
  t623 = t204 ** 2
  t624 = 0.1e1 / t623
  t625 = t624 * t207
  t626 = t625 * t210
  t630 = 0.1e1 / t215 / t214 / t130
  t632 = t213 * t630 * t1
  t633 = t288 * t287
  t634 = t289 * t202
  t637 = t632 * t220 * t633 * t634
  t640 = t208 * t301
  t644 = t208 * t529
  t645 = t151 * t644
  t647 = t217 * t1 * t85
  t648 = t6 * t287
  t649 = t289 * t495
  t651 = t647 * t648 * t649
  t657 = t632 * t220 * t633 * t289
  t660 = t298 * t513
  t661 = t296 * t660
  t677 = t349 * t37
  t678 = t231 * t677
  t680 = t391 * t396
  t681 = t680 * t398
  t682 = t681 * t24
  t684 = t37 * t19
  t685 = t397 * t684
  t686 = t685 * t24
  t688 = t16 * t103
  t689 = t397 * t688
  t690 = t689 * t382
  t692 = 0.40375948798101559224001643004400895437705618747712e-4 * t49 + 0.26510497116684513453542620262587306995649177385774e-1 * t70 - 0.23411326096918008590361250800241863911127858339748e1 * t80 + 0.22092080930570427877952183552156089163040981154812e-2 * t92 - 0.83611878917564316394147324286578085396885208356242e-1 * t100 - 0.10604198846673805381417048105034922798259670954310e0 * t109 + 0.12371565321119439611653222789207409931302949446695e0 * t115 + 0.50631328524251801700246888250186209051365905137714e2 * t125 + 0.69090444444444444444444444444444444444444444444446e-2 * t678 + 0.32300759038481247379201314403520716350164494998170e-3 * t682 + 0.32300759038481247379201314403520716350164494998170e-3 * t686 + 0.10766919679493749126400438134506905450054831666057e-3 * t690
  t694 = t4 * t89 * t17
  t696 = t46 * t29
  t698 = t224 * t696 * t37
  t700 = t22 * t323
  t707 = t28 ** 2
  t708 = 0.1e1 / t707
  t709 = t8 * t708
  t710 = t325 * t37
  t714 = t37 * t339
  t718 = t4 * t89
  t719 = 0.7e1 / 0.27e2 * t718
  t723 = 0.1e1 / t11 / t380 / t349 / 0.4e1
  t724 = t723 * t2
  t725 = 0.1e1 / t134
  t726 = t724 * t725
  t729 = t330 * t106 * t62
  t732 = t32 * t33 * t88
  t734 = -t719 - 0.12424800000000000000000000000000000000000000000000e1 * t726 + 0.82832000000000000000000000000000000000000000000000e0 * t729 - 0.96637333333333333333333333333333333333333333333333e0 * t732
  t740 = (-0.7e1 / 0.27e2 * t694 - t698 / 0.3e1 - t224 * t700 * t325 / 0.2e1 + t224 * t318 * t339 / 0.4e1 - 0.3e1 / 0.2e1 * t224 * t709 * t710 + 0.3e1 / 0.2e1 * t224 * t324 * t714 - t224 * t225 * t734 / 0.4e1) * t55 * t142
  t741 = t740 * t233
  t744 = t356 * t89 * t67
  t746 = t345 * t350
  t750 = t5 / t60 / r0
  t751 = t750 * t16
  t752 = t231 * t751
  t754 = t345 * t353
  t756 = t232 * t339
  t757 = t231 * t756
  t760 = t368 * t89 * t77
  t762 = t399 * t48
  t764 = t392 * t37
  t766 = t241 * t339
  t770 = t13 * t323
  t771 = t770 * t32
  t775 = t373 * t330
  t788 = t88 * t2
  t794 = t380 * t63
  t799 = t27 * t708
  t805 = -0.11e2 / 0.216e3 * t694 - t698 / 0.24e2 - t771 * t33 * t22 * t325 + t775 * t106 * t332 * t37 / 0.3e1 - 0.2e1 / 0.3e1 * t374 * t33 * t46 * t37 + t374 * t33 * t22 * t339 / 0.2e1 + t518 * t788 * t17 / 0.432e3 - 0.2e1 / 0.3e1 * t18 * t726 + 0.4e1 / 0.9e1 * t379 * t794 - 0.14e2 / 0.27e2 * t20 * t718 - 0.6e1 * t799 * t710 + 0.6e1 * t387 * t714 - t30 * t734
  t806 = t805 * t240
  t807 = t806 * t16
  t812 = t232 * t420
  t817 = t349 * t251
  t821 = t4 * t89 * t168
  t823 = t46 * t248
  t825 = t224 * t823 * t251
  t827 = t22 * t412
  t834 = t247 ** 2
  t835 = 0.1e1 / t834
  t836 = t8 * t835
  t837 = t414 * t251
  t841 = t251 * t420
  t848 = -t719 - 0.37702333333333333333333333333333333333333333333334e0 * t726 + 0.25134888888888888888888888888888888888888888888890e0 * t729 - 0.29324037037037037037037037037037037037037037037038e0 * t732
  t854 = (-0.7e1 / 0.27e2 * t821 - t825 / 0.3e1 - t224 * t827 * t414 / 0.2e1 + t224 * t407 * t420 / 0.4e1 - 0.3e1 / 0.2e1 * t224 * t836 * t837 + 0.3e1 / 0.2e1 * t224 * t413 * t841 - t224 * t249 * t848 / 0.4e1) * t55 * t142
  t857 = t262 * t723
  t858 = t2 * t725
  t862 = t478 * t483
  t863 = t862 * t485
  t866 = t251 * t19
  t867 = t484 * t866
  t870 = t167 * t103
  t871 = t484 * t870
  t884 = 0.23390302462324474051432516353486737824307380234560e2 * t456 * t89 * t458 + t257 * t812 / 0.3e1 + 0.2e1 / 0.3e1 * t426 * t432 + 0.2e1 / 0.9e1 * t257 * t817 + t854 * t258 / 0.3e1 + 0.15087124812358469189006280566794884950190836019297e1 * t857 * t858 * t267 + 0.13801126476068758202792416493376366046440520973047e-3 * t863 * t24 + 0.13801126476068758202792416493376366046440520973047e-3 * t867 * t24 + 0.46003754920229194009308054977921220154801736576823e-4 * t871 * t382 - 0.10058083208238979459337520377863256633460557346198e1 * t443 * t106 * t62 * t267 + 0.11734430409612142702560440440840466072370650237231e1 * t264 * t33 * t88 * t267 - 0.92007509840458388018616109955842440309603473153646e-4 * t486 * t48
  t885 = t179 ** 2
  t886 = 0.1e1 / t885
  t887 = t278 * t886
  t888 = t887 * t167
  t891 = t452 ** 2
  t892 = 0.1e1 / t891
  t893 = t892 * t55
  t894 = t893 * t57
  t896 = 0.1e1 / t457 / t266
  t897 = t896 * t19
  t904 = 0.1e1 / t452
  t905 = t904 * t55
  t906 = t905 * t57
  t907 = t267 * t19
  t912 = 0.1e1 / t452 / t261
  t913 = t912 * t55
  t914 = t913 * t57
  t915 = t458 * t19
  t919 = t437 * t85
  t920 = t2 * t267
  t924 = t455 * t85
  t925 = t2 * t458
  t931 = t750 * t167
  t936 = t178 * t412
  t937 = t936 * t32
  t941 = t463 * t330
  t963 = t179 * t835
  t969 = -0.11e2 / 0.216e3 * t821 - t825 / 0.24e2 - t937 * t33 * t22 * t414 + t941 * t106 * t332 * t251 / 0.3e1 - 0.2e1 / 0.3e1 * t464 * t33 * t46 * t251 + t464 * t33 * t22 * t420 / 0.2e1 + t518 * t788 * t168 / 0.432e3 - 0.2e1 / 0.3e1 * t272 * t726 + 0.4e1 / 0.9e1 * t469 * t794 - 0.14e2 / 0.27e2 * t273 * t718 - 0.6e1 * t963 * t837 + 0.6e1 * t474 * t841 - t276 * t848
  t970 = t969 * t279
  t977 = 0.17251408095085947753490520616720457558050651216309e-4 * t888 * t48 + 0.86312224513605868227832795632565231845861115350066e3 * t894 * t63 * t897 - 0.46099548037761989188630301731873259570027554503406e0 * t438 * t89 * t267 + 0.25145208020597448648343800944658141583651393365494e0 * t906 * t63 * t907 - 0.29769475861140239701823202631710393594573029389440e2 * t914 * t63 * t915 + 0.20954340017164540540286500787215117986376161137912e-1 * t919 * t89 * t920 - 0.10631955664692942750651143797039426283776081924800e1 * t924 * t89 * t925 + 0.2e1 / 0.9e1 * t426 * t429 - 0.2e1 / 0.27e2 * t257 * t931 + 0.41403379428206274608377249480129098139321562919141e-3 * t970 * t167 + 0.82806758856412549216754498960258196278643125838282e-3 * t479 * t251 + 0.41403379428206274608377249480129098139321562919141e-3 * t280 * t420
  t980 = t165 * (t884 + t977) * t194
  t982 = t64 * t723
  t984 = t982 * t858 * t67
  t986 = 0.10363566666666666666666666666666666666666666666667e-1 * t741 - 0.48602578047254941331494803814743396158690158540586e-1 * t744 + 0.69090444444444444444444444444444444444444444444446e-2 * t746 - 0.23030148148148148148148148148148148148148148148149e-2 * t752 + 0.20727133333333333333333333333333333333333333333334e-1 * t754 + 0.10363566666666666666666666666666666666666666666667e-1 * t757 + 0.18394613361864149606712411343047178787314745838373e1 * t760 - 0.21533839358987498252800876269013810900109663332113e-3 * t762 + 0.19380455423088748427520788642112429810098696998902e-2 * t764 + 0.96902277115443742137603943210562149050493484994510e-3 * t766 + 0.96902277115443742137603943210562149050493484994510e-3 * t807 - t980 / 0.24e2 + 0.15906298270010708072125572157552384197389506431465e0 * t984
  t987 = t692 + t986
  t990 = t307 * t220 * t987 * t202
  t993 = t298 * t529
  t994 = t151 * t993
  t995 = t6 * t495
  t997 = t647 * t995 * t308
  t1003 = t632 * t220 * t633 * t202
  t1008 = 0.1e1 / t60 / t134 / t59
  t1014 = -0.455e3 / 0.1296e4 * s0 * t615 * t138 * t144 + t622 * t626 * t637 / 0.512e3 - 0.7e1 / 0.768e3 * t151 * t640 * t292 + t645 * t651 / 0.512e3 - t622 * t211 * t657 / 0.512e3 + 0.119e3 / 0.4608e4 * t661 * t310 - 0.7e1 / 0.1536e4 * t303 * t498 + 0.7e1 / 0.1536e4 * t151 * t302 * t504 + t314 * t990 / 0.3072e4 - t994 * t997 / 0.1024e4 + t622 * t313 * t1003 / 0.3072e4 - 0.595e3 / 0.10368e5 * t510 * t1008 * t213 * t515 * t518
  t1015 = params.beta * t1014
  t1023 = t554 ** 2
  t1024 = 0.1e1 / t1023
  t1027 = t198 * t1024 * t573 * t565
  t1030 = t569 * t198
  t1031 = t571 * t565
  t1032 = t1031 * t599
  t1035 = params.beta * t621
  t1036 = t1035 * t624
  t1037 = t534 * t633
  t1039 = 0.1e1 / t215 / t130
  t1040 = t1039 * t634
  t1044 = t552 * t288
  t1048 = t206 * t534
  t1049 = t577 * t1048
  t1050 = t287 * t581
  t1051 = t1050 * t649
  t1054 = t1035 * t206
  t1055 = t1039 * t289
  t1073 = t297 * t534
  t1074 = t577 * t1073
  t1076 = t495 * t581 * t308
  t1079 = t1035 * t297
  t1080 = t1039 * t202
  t1085 = 0.3e1 * t558 * t522 * t287 * t560 + 0.3e1 * t558 * t552 * t495 * t560 + t558 * t534 * t987 * t560 + t524 * t507 * t1014 + 0.6e1 * t1036 * t1037 * t1040 - 0.6e1 * t1054 * t1037 * t1055 + t1079 * t1037 * t1080 + 0.6e1 * t578 * t1044 * t582 - 0.3e1 * t593 * t1044 * t594 + 0.6e1 * t1049 * t1051 - 0.3e1 * t1074 * t1076
  t1086 = t556 * t1085
  t1088 = t1015 * t539 - 0.6e1 * t569 * t1027 + 0.6e1 * t1030 * t1032 - t569 * t1086 - 0.3e1 * t523 * t566 + 0.6e1 * t553 * t574 - 0.3e1 * t553 * t600
  t1089 = 0.1e1 / t604
  t1097 = 0.16150379519240623689600657201760358175082247499085e-3 * t49 + 0.10604198846673805381417048105034922798259670954310e0 * t70 - 0.93645304387672034361445003200967455644511433358993e1 * t80 + 0.88368323722281711511808734208624356652163924619249e-2 * t92 - 0.33444751567025726557658929714631234158754083342496e0 * t100 - 0.42416795386695221525668192420139691193038683817240e0 * t109 + 0.49486261284477758446612891156829639725211797786780e0 * t115 + 0.20252531409700720680098755300074483620546362055085e3 * t125 - 0.12e2 * t133 * t602 * t606 * t610 + 0.4e1 * t133 * t1088 * t1089 + 0.27636177777777777777777777777777777777777777777779e-1 * t678 + 0.12920303615392498951680525761408286540065797999268e-2 * t682 + 0.12920303615392498951680525761408286540065797999268e-2 * t686 + 0.43067678717974996505601752538027621800219326664227e-3 * t690
  t1098 = t610 ** 2
  t1101 = 0.1e1 / t605 / t604
  t1117 = 0.1e1 / t299
  t1127 = t5 * t210
  t1139 = t6 * t136
  t1144 = t4 * t1139 * t168
  t1148 = t224 * t88 * t248 * t251
  t1152 = t224 * t46 * t412 * t414
  t1155 = t224 * t823 * t420
  t1168 = 0.1e1 / t834 / t167
  t1170 = t414 ** 2
  t1174 = t414 * t420
  t1178 = t420 ** 2
  t1182 = t251 * t848
  t1186 = t4 * t1139
  t1187 = 0.70e2 / 0.81e2 * t1186
  t1192 = 0.1e1 / t11 / t2 * r0 / 0.48e2
  t1193 = t1192 * t2
  t1195 = t1193 * t615 * t224
  t1197 = t724 * t1117
  t1200 = t330 * t106 * t210
  t1203 = t32 * t33 * t136
  t1205 = t1187 - 0.31418611111111111111111111111111111111111111111112e0 * t1195 + 0.30161866666666666666666666666666666666666666666668e1 * t1197 - 0.11171061728395061728395061728395061728395061728396e1 * t1200 + 0.97746790123456790123456790123456790123456790123460e0 * t1203
  t1209 = 0.70e2 / 0.81e2 * t1144 + 0.28e2 / 0.27e2 * t1148 + 0.4e1 / 0.3e1 * t1152 - 0.2e1 / 0.3e1 * t1155 + 0.2e1 * t224 * t22 * t835 * t837 - 0.2e1 * t224 * t827 * t841 + t224 * t407 * t848 / 0.3e1 + 0.6e1 * t224 * t8 * t1168 * t1170 - 0.9e1 * t224 * t836 * t1174 + 0.3e1 / 0.2e1 * t224 * t413 * t1178 + 0.2e1 * t224 * t413 * t1182 - t224 * t249 * t1205 / 0.4e1
  t1241 = 0.16e2 / 0.3e1 * t272 * t1197 + 0.185e3 / 0.864e3 * t1144 + 0.11e2 / 0.54e2 * t1148 + t1152 / 0.6e1 - t1155 / 0.12e2 + 0.8e1 * t474 * t1182 - 0.36e2 * t963 * t1174 - 0.4e1 * t937 * t33 * t465 * t420 + 0.6e1 * t474 * t1178 + 0.24e2 * t179 * t1168 * t1170 - t276 * t1205 + 0.140e3 / 0.81e2 * t273 * t1186
  t1246 = t380 * t1127
  t1249 = t136 * t2
  t1294 = t615 * t1 * t33
  t1297 = -t518 * t788 * t248 * t251 / 0.108e3 - 0.160e3 / 0.81e2 * t469 * t1246 - 0.11e2 / 0.648e3 * t518 * t1249 * t168 + 0.8e1 / 0.3e1 * t463 * t723 * t858 * t251 - 0.16e2 / 0.9e1 * t941 * t106 * t62 * t251 + 0.56e2 / 0.27e2 * t464 * t33 * t88 * t251 + 0.4e1 * t178 * t835 * t32 * t33 * t22 * t837 + 0.8e1 / 0.3e1 * t937 * t33 * t46 * t414 - 0.4e1 / 0.3e1 * t936 * t330 * t106 * t332 * t414 + 0.2e1 / 0.3e1 * t941 * t106 * t332 * t420 - 0.4e1 / 0.3e1 * t464 * t33 * t46 * t420 + 0.2e1 / 0.3e1 * t464 * t33 * t22 * t848 - 0.5e1 / 0.9e1 * t272 * t1193 * t1294
  t1305 = 0.50290416041194897296687601889316283167302786730988e0 * t904 * t2 * t1117 * t267 * t103 - 0.59538951722280479403646405263420787189146058778880e2 * t912 * t2 * t1117 * t458 * t103 + 0.21830948964836175781337015263254288636020221552256e3 * t914 * t1127 * t915 - 0.63295631309977636700410716797214503353631484590049e4 * t894 * t1127 * t897 + 0.2e1 / 0.3e1 * t426 * t817 + t257 * t349 * t420 / 0.3e1 - 0.98345589898409720443523080122614693124928757804400e2 * t456 * t1139 * t458 + t1209 * t55 * t142 * t258 / 0.3e1 - 0.2e1 / 0.9e1 * t426 * t931 + 0.10e2 / 0.81e2 * t257 * t381 * t167 + 0.41403379428206274608377249480129098139321562919141e-3 * (t1241 + t1297) * t279 * t167 + t257 * t232 * t848 / 0.3e1
  t1355 = t457 ** 2
  t1368 = 0.51754224285257843260471561850161372674151953648927e-4 * t478 * t886 * t167 * t48 + 0.51754224285257843260471561850161372674151953648927e-4 * t887 * t251 * t48 - 0.15366516012587329729543433910624419856675851501136e0 * t919 * t1139 * t920 + 0.77967674874414913504775054511622459414357934115200e1 * t924 * t1139 * t925 + 0.16763472013731632432229200629772094389100928910329e0 * t454 * t2 * t210 * t267 * t55 * t143 - 0.34022258127017416802083660150526164108083462159360e2 / t452 / t435 * t2 * t210 * t458 * t55 * t143 + 0.44702592036617686485944535012725585037602477094213e1 * t443 * t106 * t210 * t267 - 0.39114768032040475675201468136134886907902167457437e1 * t264 * t33 * t136 * t267 - 0.63255163015315141762798575594641677712852387793133e-4 * t888 * t718 + 0.21578056128401467056958198908141307961465278837517e4 / t891 / t173 * t2 * t210 * t896 * t55 * t143 - 0.43793683962271420729973795871593892966464398384137e5 / t891 / t435 * t2 * t210 / t1355 * t55 * t143 - 0.18439819215104795675452120692749303828011021801362e1 * t906 * t1127 * t907 + 0.20701689714103137304188624740064549069660781459570e-3 * t969 * t483 * t485 * t24
  t1379 = t106 * t62 * t19
  t1385 = t210 * t2
  t1403 = t2 * t1117
  t1412 = 0.41403379428206274608377249480129098139321562919141e-3 * t862 * t866 * t24 + 0.23001877460114597004654027488960610077400868288412e-4 * t278 / t885 / t178 * t167 * t55 * t1379 - 0.18401501968091677603723221991168488061920694630729e-3 * t871 * t794 + 0.41908680034329081080573001574430235972752322275824e-1 * t905 * t143 * t1385 * t907 - 0.2e1 / 0.9e1 * t257 * t750 * t251 + t426 * t812 + t854 * t429 / 0.3e1 + t854 * t432 + 0.27602252952137516405584832986752732092881041946094e-3 * t484 * t167 * t726 + 0.19382764515877199999765013228173984137397949052568e1 * t436 * t136 * t267 * t224 - 0.12069699849886775351205024453435907960152668815438e2 * t857 * t1403 * t267 + 0.17262444902721173645566559126513046369172223070013e4 * t892 * t2 * t1117 * t896 * t103
  t1440 = t220 * t788
  t1444 = t2 * t615
  t1456 = -0.49615793101900399503038671052850655990955048982400e1 * t913 * t143 * t1385 * t915 + 0.14385370752267644704638799272094205307643519225011e3 * t893 * t143 * t1385 * t897 - 0.27602252952137516405584832986752732092881041946094e-3 * t863 * t48 - 0.27602252952137516405584832986752732092881041946094e-3 * t867 * t48 + 0.21468418962773623871010425656363236072240810402517e-3 * t486 * t718 + 0.13801126476068758202792416493376366046440520973047e-3 * t862 * t870 * t382 + 0.20701689714103137304188624740064549069660781459570e-3 * t484 * t420 * t19 * t24 + 0.13801126476068758202792416493376366046440520973047e-3 * t484 * t251 * t103 * t382 + 0.28752346825143246255817534361200762596751085360514e-5 * t887 * t167 * t1 * t1440 + 0.12572604010298724324171900472329070791825696682747e1 * t262 * t1192 * t1444 * t267 * t1 * t33 + 0.12421013828461882382513174844038729441796468875742e-2 * t479 * t420 + 0.41403379428206274608377249480129098139321562919141e-3 * t280 * t848 + 0.12421013828461882382513174844038729441796468875742e-2 * t970 * t251
  t1461 = t165 * (t1305 + t1368 + t1412 + t1456) * t194 / 0.24e2
  t1466 = 0.53020994233369026907085240525174613991298354771548e-1 * t54 * t2 * t1117 * t67 * t103
  t1471 = 0.46822652193836017180722501600483727822255716679496e1 * t73 * t2 * t1117 * t77 * t103
  t1477 = 0.17673664744456342302361746841724871330432784923849e-1 * t95 * t2 * t210 * t67 * t55 * t143
  t1485 = 0.26755801253620581246127143771704987327003266673998e1 / t53 / t82 * t2 * t210 * t77 * t55 * t143
  t1493 = 0.12657832131062950425061722062546552262841476284429e3 / t117 / t51 * t2 * t210 * t122 * t55 * t143
  t1498 = t76 ** 2
  t1503 = 0.19162434373246948642083122762742588170998040494372e4 / t117 / t82 * t2 * t210 / t1498 * t55 * t143
  t1507 = 0.12112784639430467767200492901320268631311685624314e-3 * t391 * t41 * t16 * t48
  t1510 = 0.12112784639430467767200492901320268631311685624314e-3 * t42 * t37 * t48
  t1513 = 0.19441031218901976532597921525897358463476063416234e0 * t58 * t1127 * t68
  t1514 = t602 ** 2
  t1518 = t495 ** 2
  t1526 = t630 * t1 * t85
  t1551 = 0.1e1 / t620 / params.gamma
  t1552 = t147 * t1551
  t1554 = t215 ** 2
  t1557 = t213 / t1554 * t1
  t1558 = t288 ** 2
  t1565 = 0.29070683134633122641281182963168644715148045498353e-2 * t392 * t339
  t1567 = 0.96902277115443742137603943210562149050493484994510e-3 * t241 * t734
  t1568 = -t1461 + t1466 - t1471 + t1477 - t1485 + t1493 - t1503 + t1507 + t1510 - t1513 + t1565 + t1567
  t1576 = t37 * t734
  t1584 = 0.1e1 / t707 / t16
  t1586 = t325 ** 2
  t1593 = t1187 - 0.10354000000000000000000000000000000000000000000000e1 * t1195 + 0.99398400000000000000000000000000000000000000000000e1 * t1197 - 0.36814222222222222222222222222222222222222222222222e1 * t1200 + 0.32212444444444444444444444444444444444444444444444e1 * t1203
  t1595 = t339 ** 2
  t1598 = t325 * t339
  t1602 = t4 * t1139 * t17
  t1606 = t224 * t88 * t29 * t37
  t1610 = t224 * t46 * t323 * t325
  t1613 = t224 * t696 * t339
  t1615 = 0.8e1 / 0.3e1 * t373 * t723 * t858 * t37 - 0.11e2 / 0.648e3 * t518 * t1249 * t17 + 0.8e1 * t387 * t1576 - 0.4e1 * t771 * t33 * t375 * t339 + 0.24e2 * t27 * t1584 * t1586 - t30 * t1593 + 0.6e1 * t387 * t1595 - 0.36e2 * t799 * t1598 + 0.185e3 / 0.864e3 * t1602 + 0.11e2 / 0.54e2 * t1606 + t1610 / 0.6e1 - t1613 / 0.12e2
  t1664 = -0.160e3 / 0.81e2 * t379 * t1246 + 0.140e3 / 0.81e2 * t20 * t1186 + 0.16e2 / 0.3e1 * t18 * t1197 - t518 * t788 * t29 * t37 / 0.108e3 - 0.4e1 / 0.3e1 * t374 * t33 * t46 * t339 + 0.2e1 / 0.3e1 * t374 * t33 * t22 * t734 - 0.5e1 / 0.9e1 * t18 * t1193 * t1294 - 0.4e1 / 0.3e1 * t770 * t330 * t106 * t332 * t325 + 0.2e1 / 0.3e1 * t775 * t106 * t332 * t339 + 0.4e1 * t13 * t708 * t32 * t33 * t22 * t710 + 0.8e1 / 0.3e1 * t771 * t33 * t46 * t325 - 0.16e2 / 0.9e1 * t775 * t106 * t62 * t37 + 0.56e2 / 0.27e2 * t374 * t33 * t88 * t37
  t1668 = 0.96902277115443742137603943210562149050493484994510e-3 * (t1615 + t1664) * t240 * t16
  t1671 = 0.10363566666666666666666666666666666666666666666667e-1 * t231 * t349 * t339
  t1673 = 0.10363566666666666666666666666666666666666666666667e-1 * t740 * t350
  t1676 = 0.20435174860777645787105769785744382475812907568201e0 * t356 * t1139 * t67
  t1707 = 0.70e2 / 0.81e2 * t1602 + 0.28e2 / 0.27e2 * t1606 + 0.4e1 / 0.3e1 * t1610 - 0.2e1 / 0.3e1 * t1613 + 0.2e1 * t224 * t22 * t708 * t710 - 0.2e1 * t224 * t700 * t714 + t224 * t318 * t734 / 0.3e1 + 0.6e1 * t224 * t8 * t1584 * t1586 - 0.9e1 * t224 * t709 * t1598 + 0.3e1 / 0.2e1 * t224 * t324 * t1595 + 0.2e1 * t224 * t324 * t1576 - t224 * t225 * t1593 / 0.4e1
  t1711 = 0.10363566666666666666666666666666666666666666666667e-1 * t1707 * t55 * t142 * t233
  t1714 = 0.38383580246913580246913580246913580246913580246915e-2 * t231 * t381 * t16
  t1716 = 0.31090700000000000000000000000000000000000000000001e-1 * t345 * t756
  t1718 = 0.31090700000000000000000000000000000000000000000001e-1 * t740 * t353
  t1720 = 0.69090444444444444444444444444444444444444444444446e-2 * t345 * t751
  t1723 = 0.12725038616008566457700457726041907357911605145172e1 * t982 * t1403 * t67
  t1728 = 0.10126265704850360340049377650037241810273181027543e3 * t118 * t2 * t1117 * t122 * t103
  t1731 = 0.17168305804406539632931583920177366868160429449148e2 * t75 * t1127 * t78
  t1735 = 0.41238551070398132038844075964024699771009831488983e0 * t112 * t33 * t136 * t67
  t1736 = t1668 + t1671 + t1673 + t1676 + t1711 + t1714 + t1716 + t1718 - t1720 - t1723 + t1728 + t1731 - t1735
  t1740 = 0.37129640917784654580181051383469886637668330434323e3 * t120 * t1127 * t123
  t1743 = 0.16200859349084980443831601271581132052896719513529e-1 * t86 * t1139 * t90
  t1746 = 0.61315377872880498689041371143490595957715819461244e0 * t97 * t1139 * t98
  t1750 = 0.47129772651883579472964658244599656881154093130267e0 * t105 * t106 * t210 * t67
  t1752 = 0.14804514559303905048800602434946994993825393540828e-3 * t43 * t718
  t1756 = 0.84385547540419669500411480416977015085609841896189e1 * t119 * t143 * t1385 * t123
  t1758 = 0.50245625170970829256535377961032225433589214441597e-3 * t399 * t718
  t1764 = 0.13255248558342256726771310131293653497824588692887e0 * t64 * t1192 * t1444 * t67 * t1 * t33
  t1768 = 0.67293247996835932040002738340668159062842697912856e-5 * t42 * t16 * t1 * t1440
  t1775 = 0.53834598397468745632002190672534527250274158330283e-4 * t39 / t40 / t13 * t16 * t55 * t1379
  t1777 = 0.64601518076962494758402628807041432700328989996340e-3 * t681 * t48
  t1779 = 0.64601518076962494758402628807041432700328989996340e-3 * t685 * t48
  t1781 = 0.43067678717974996505601752538027621800219326664227e-3 * t689 * t794
  t1782 = -t1740 - t1743 + t1746 + t1750 - t1752 + t1756 + t1758 + t1764 + t1768 + t1775 - t1777 - t1779 - t1781
  t1786 = 0.48451138557721871068801971605281074525246742497255e-3 * t805 * t396 * t398 * t24
  t1789 = 0.96902277115443742137603943210562149050493484994510e-3 * t680 * t684 * t24
  t1792 = 0.32300759038481247379201314403520716350164494998170e-3 * t680 * t688 * t382
  t1796 = 0.48451138557721871068801971605281074525246742497255e-3 * t397 * t339 * t19 * t24
  t1800 = 0.32300759038481247379201314403520716350164494998170e-3 * t397 * t37 * t103 * t382
  t1804 = 0.44184161861140855755904367104312178326081962309624e-2 * t56 * t143 * t1385 * t68
  t1808 = 0.39018876828196680983935418000403106518546430566246e0 * t74 * t143 * t1385 * t78
  t1811 = 0.10363566666666666666666666666666666666666666666667e-1 * t231 * t232 * t734
  t1813 = 0.20727133333333333333333333333333333333333333333334e-1 * t345 * t677
  t1816 = 0.69090444444444444444444444444444444444444444444446e-2 * t231 * t750 * t37
  t1819 = 0.77340987998746992664586274965084728992118817729523e1 * t368 * t1139 * t77
  t1822 = 0.64601518076962494758402628807041432700328989996342e-3 * t397 * t16 * t726
  t1824 = 0.29070683134633122641281182963168644715148045498353e-2 * t806 * t37
  t1825 = t1786 + t1789 + t1792 + t1796 + t1800 + t1804 - t1808 + t1811 + t1813 - t1816 - t1819 + t1822 + t1824
  t1827 = t1568 + t1736 + t1782 + t1825
  t1843 = -t501 * t219 * t220 * t1518 * t202 / 0.1024e4 + t622 * t993 * t1526 * t995 * t502 / 0.512e3 - t994 * t647 * t6 * t987 * t308 / 0.768e3 + 0.455e3 / 0.243e3 * s0 / t7 / t511 * t138 * t144 - 0.595e3 / 0.2592e4 * t296 * t298 * t1008 * t310 + 0.7e1 / 0.384e3 * t151 * t298 * t547 * t997 - t1552 * t313 * t1557 * t220 * t1558 * t202 / 0.3072e4 + t314 * t307 * t220 * t1827 * t202 / 0.3072e4 - 0.7e1 / 0.1152e4 * t622 * t302 * t1003 + 0.119e3 / 0.2304e4 * t661 * t498 - 0.119e3 / 0.2304e4 * t151 * t660 * t504 - 0.7e1 / 0.1152e4 * t303 * t990
  t1860 = 0.1e1 / t623 / t203
  t1864 = t289 ** 2
  t1870 = t134 ** 2
  t1884 = t6 * t288
  t1885 = t634 * t495
  t1903 = t289 * t987
  t1913 = 0.7e1 / 0.1536e4 * t1552 * t211 * t1557 * t220 * t1558 * t289 - 0.3e1 / 0.256e3 * t1552 * t626 * t1557 * t220 * t1558 * t634 + 0.7e1 / 0.192e3 * t622 * t640 * t657 + t1552 * t1860 * t207 * t210 * t1557 * t220 * t1558 * t1864 / 0.128e3 + 0.13685e5 / 0.31104e5 * t510 / t60 / t1870 * t213 * t515 * t518 - 0.7e1 / 0.192e3 * t622 * t625 * t301 * t637 + 0.3e1 / 0.256e3 * t622 * t625 * t529 * t1526 * t1884 * t1885 + 0.119e3 / 0.1152e4 * t151 * t208 * t513 * t292 - 0.7e1 / 0.192e3 * t151 * t208 * t547 * t651 + t212 * t219 * t220 * t1518 * t289 / 0.512e3 + t645 * t647 * t648 * t1903 / 0.384e3 - 0.3e1 / 0.256e3 * t622 * t644 * t1526 * t1884 * t649
  t1914 = t1843 + t1913
  t1933 = t573 ** 2
  t1941 = t599 ** 2
  t1948 = t552 * t633
  t1966 = params.beta * t1551
  t1968 = t534 * t1558
  t1970 = 0.1e1 / t215 / t214
  t1980 = t522 * t288
  t1996 = 0.24e2 * t1966 * t1860 * t1968 * t1970 * t1864 + 0.14e2 * t1966 * t206 * t1968 * t1970 * t289 - 0.36e2 * t1966 * t624 * t1968 * t1970 * t634 + 0.4e1 * t558 * t1014 * t287 * t560 - 0.4e1 * t1074 * t987 * t581 * t308 + t558 * t534 * t1827 * t560 + 0.4e1 * t558 * t552 * t987 * t560 + 0.24e2 * t1036 * t1948 * t1040 - 0.24e2 * t1054 * t1948 * t1055 + 0.4e1 * t1079 * t1948 * t1080 + 0.12e2 * t578 * t1980 * t582
  t1997 = t534 * t1518
  t2015 = t288 * t1039
  t2043 = -0.3e1 * t593 * t1997 * t594 + 0.6e1 * t1035 * t1073 * t495 * t1039 * t502 + 0.24e2 * t577 * t206 * t552 * t1051 - 0.12e2 * t577 * t297 * t552 * t1076 - 0.36e2 * t1035 * t1048 * t2015 * t649 - 0.6e1 * t593 * t1980 * t594 + 0.6e1 * t578 * t1997 * t582 + 0.6e1 * t558 * t522 * t495 * t560 + 0.8e1 * t1049 * t1050 * t1903 + t524 * t507 * t1914 - t1966 * t297 * t1968 * t1970 * t202 + 0.36e2 * t1035 * t624 * t534 * t2015 * t1885
  t2047 = params.beta * t1914 * t539 - 0.4e1 * t1015 * t566 + 0.12e2 * t523 * t574 - 0.6e1 * t523 * t600 - 0.24e2 * t553 * t1027 + 0.24e2 * t553 * t198 * t1032 - 0.4e1 * t553 * t1086 + 0.24e2 * t569 * t198 / t1023 / t537 * t1933 - 0.36e2 * t1030 * t1024 * t573 * t599 + 0.6e1 * t569 * t572 * t1941 + 0.8e1 * t1030 * t1031 * t1085 - t569 * t556 * (t1996 + t2043)
  t2050 = t133 * t2047 * t1089 - 0.3e1 * t133 * t1514 * t606 - t1461 + t1466 - t1471 + t1477 - t1485 + t1493 - t1503 + t1507 + t1510 - t1513 + t1565 + t1567
  t2055 = t1098 ** 2
  t2056 = t605 ** 2
  t2065 = t1668 - 0.4e1 * t133 * t1088 * t606 * t610 + t1671 + t1673 + t1676 + t1711 + t1714 - 0.6e1 * t133 * t2055 / t2056 + 0.12e2 * t133 * t602 * t1101 * t1098 + t1716 + t1718 - t1720 - t1723 + t1728
  t2067 = t1731 - t1735 - t1740 - t1743 + t1746 + t1750 - t1752 + t1756 + t1758 + t1764 + t1768 + t1775 - t1777 - t1779
  t2068 = -t1781 + t1786 + t1789 + t1792 + t1796 + t1800 + t1804 - t1808 + t1811 + t1813 - t1816 - t1819 + t1822 + t1824
  t2074 = 0.8e1 * t133 * t1098 * t610 * t1101 + 0.41454266666666666666666666666666666666666666666668e-1 * t741 - 0.19441031218901976532597921525897358463476063416235e0 * t744 + 0.27636177777777777777777777777777777777777777777779e-1 * t746 - 0.92120592592592592592592592592592592592592592592596e-2 * t752 + 0.82908533333333333333333333333333333333333333333336e-1 * t754 + 0.41454266666666666666666666666666666666666666666668e-1 * t757 + 0.73578453447456598426849645372188715149258983353495e1 * t760 - 0.86135357435949993011203505076055243600438653328453e-3 * t762 + 0.77521821692354993710083154568449719240394787995608e-2 * t764 + 0.38760910846177496855041577284224859620197393997804e-2 * t766 + 0.38760910846177496855041577284224859620197393997804e-2 * t807 + r0 * (t2050 + t2065 + t2067 + t2068) - t980 / 0.6e1 + 0.63625193080042832288502288630209536789558025725859e0 * t984
  v4rho4_0_ = t1097 + t2074

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 + r1
  t2 = 3 ** (0.1e1 / 0.3e1)
  t4 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t5 = t2 * t4
  t6 = 4 ** (0.1e1 / 0.3e1)
  t7 = t6 ** 2
  t8 = t1 ** 2
  t9 = t1 ** (0.1e1 / 0.3e1)
  t11 = 0.1e1 / t9 / t8
  t12 = t7 * t11
  t13 = 0.1e1 / t9
  t14 = t7 * t13
  t15 = t5 * t14
  t16 = t15 / 0.4e1
  t17 = jnp.sqrt(t15)
  t19 = t16 + 0.18637200000000000000000000000000000000000000000000e1 * t17 + 0.129352e2
  t20 = 0.1e1 / t19
  t22 = t5 * t12 * t20
  t24 = t17 / 0.2e1
  t25 = t24 + 0.10498e0
  t26 = t19 ** 2
  t27 = 0.1e1 / t26
  t29 = 0.1e1 / t17
  t30 = t29 * t2
  t32 = t4 * t7
  t34 = 0.1e1 / t9 / t1
  t35 = t7 * t34
  t36 = t5 * t35
  t37 = t36 / 0.12e2
  t39 = t30 * t32 * t34
  t41 = -t37 - 0.31062000000000000000000000000000000000000000000000e0 * t39
  t46 = t25 * t20
  t48 = 0.1e1 / t17 / t15
  t50 = t2 ** 2
  t51 = t4 ** 2
  t53 = t9 ** 2
  t55 = 0.1e1 / t53 / t8
  t57 = t50 * t51 * t6 * t55
  t60 = t46 * t29
  t61 = t5 * t12
  t64 = t25 ** 2
  t66 = 0.1e1 / t26 / t19
  t68 = t41 ** 2
  t71 = t64 * t27
  t72 = t61 / 0.9e1
  t74 = t51 * t6
  t76 = t48 * t50 * t74 * t55
  t79 = t30 * t32 * t11
  t81 = t72 - 0.20708000000000000000000000000000000000000000000000e0 * t76 + 0.41416000000000000000000000000000000000000000000000e0 * t79
  t84 = 0.1e1 / t64
  t87 = 0.96902277115443742137603943210562149050493484994510e-3 * (t22 / 0.72e2 + t25 * t27 * t30 * t32 * t34 * t41 / 0.3e1 - t46 * t48 * t57 / 0.9e1 + 0.2e1 / 0.9e1 * t60 * t61 + 0.2e1 * t64 * t66 * t68 - t71 * t81) * t84 * t19
  t91 = -t60 * t36 / 0.6e1 - t71 * t41
  t92 = t91 * t84
  t94 = 0.96902277115443742137603943210562149050493484994510e-3 * t92 * t41
  t101 = 0.16150379519240623689600657201760358175082247499085e-3 * t91 / t64 / t25 * t19 * t29 * t36
  t103 = t16 + 0.35302100000000000000000000000000000000000000000000e1 * t17 + 0.180578e2
  t104 = 0.1e1 / t103
  t108 = t5 * t7
  t109 = t103 ** 2
  t110 = 0.1e1 / t109
  t111 = t13 * t110
  t113 = -t37 - 0.58836833333333333333333333333333333333333333333333e0 * t39
  t119 = 0.1e1 / t4
  t120 = (-t5 * t35 * t104 / 0.12e2 - t108 * t111 * t113 / 0.4e1) * t50 * t119
  t121 = t6 * t9
  t122 = t121 * t103
  t125 = t17 + 0.706042e1
  t126 = t125 ** 2
  t127 = 0.1e1 / t126
  t129 = t127 * t29 * t2
  t131 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t127
  t132 = 0.1e1 / t131
  t137 = t24 + 0.32500e0
  t138 = t137 * t104
  t139 = t138 * t29
  t142 = t137 ** 2
  t143 = t142 * t110
  t145 = -t139 * t36 / 0.6e1 - t143 * t113
  t146 = 0.1e1 / t142
  t147 = t145 * t146
  t153 = t13 * t27
  t159 = (-t5 * t35 * t20 / 0.12e2 - t108 * t153 * t41 / 0.4e1) * t50 * t119
  t160 = t121 * t19
  t161 = t159 * t160
  t162 = 0.10363566666666666666666666666666666666666666666667e-1 * t161
  t163 = t17 + 0.372744e1
  t164 = t163 ** 2
  t165 = 0.1e1 / t164
  t167 = t165 * t29 * t2
  t169 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t165
  t170 = 0.1e1 / t169
  t173 = t167 * t32 * t34 * t170
  t174 = 0.39765745675026770180313930393880960493473766078662e-1 * t173
  t175 = t92 * t19
  t176 = 0.96902277115443742137603943210562149050493484994510e-3 * t175
  t177 = 0.51817833333333333333333333333333333333333333333333e-2 * t120 * t122 + 0.41388824077869423260215065147117773567486474051458e-1 * t129 * t32 * t34 * t132 + 0.22478670955426118383265363956423012380560746650571e-2 * t147 * t103 - t162 - t174 - t176
  t178 = r0 - r1
  t179 = 0.1e1 / t1
  t180 = t178 * t179
  t181 = 0.1e1 + t180
  t182 = t181 <= f.p.zeta_threshold
  t183 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t184 = t183 * f.p.zeta_threshold
  t185 = t181 ** (0.1e1 / 0.3e1)
  t186 = t185 * t181
  t187 = f.my_piecewise3(t182, t184, t186)
  t188 = 0.1e1 - t180
  t189 = t188 <= f.p.zeta_threshold
  t190 = t188 ** (0.1e1 / 0.3e1)
  t191 = t190 * t188
  t192 = f.my_piecewise3(t189, t184, t191)
  t193 = t187 + t192 - 0.2e1
  t194 = t177 * t193
  t195 = 2 ** (0.1e1 / 0.3e1)
  t196 = t195 - 0.1e1
  t198 = 0.1e1 / t196 / 0.2e1
  t199 = t178 ** 2
  t200 = t199 ** 2
  t201 = t198 * t200
  t202 = t8 ** 2
  t203 = t202 * t1
  t204 = 0.1e1 / t203
  t205 = t201 * t204
  t207 = 0.8e1 * t194 * t205
  t211 = jnp.log(t5 * t14 * t104 / 0.4e1)
  t215 = jnp.arctan(0.47309269095601128299619512910246923284397083311420e1 / t125)
  t218 = jnp.log(t142 * t104)
  t223 = jnp.log(t5 * t14 * t20 / 0.4e1)
  t224 = 0.310907e-1 * t223
  t227 = jnp.arctan(0.61519908197590802321728722658814145360143502774884e1 / t163)
  t228 = 0.38783294878113014394824731224995739188004877421366e-1 * t227
  t230 = jnp.log(t64 * t20)
  t231 = 0.96902277115443742137603943210562149050493484994510e-3 * t230
  t232 = 0.1554535e-1 * t211 + 0.52491393169780936217021346072241076933841385384497e-1 * t215 + 0.22478670955426118383265363956423012380560746650571e-2 * t218 - t224 - t228 - t231
  t233 = t185 ** 2
  t234 = 0.1e1 / t233
  t235 = 0.1e1 / t8
  t236 = t178 * t235
  t237 = t179 - t236
  t238 = t237 ** 2
  t241 = t8 * t1
  t242 = 0.1e1 / t241
  t243 = t178 * t242
  t245 = -0.2e1 * t235 + 0.2e1 * t243
  t249 = f.my_piecewise3(t182, 0, 0.4e1 / 0.9e1 * t234 * t238 + 0.4e1 / 0.3e1 * t185 * t245)
  t250 = t190 ** 2
  t251 = 0.1e1 / t250
  t252 = -t237
  t253 = t252 ** 2
  t256 = -t245
  t260 = f.my_piecewise3(t189, 0, 0.4e1 / 0.9e1 * t251 * t253 + 0.4e1 / 0.3e1 * t190 * t256)
  t261 = t249 + t260
  t263 = 0.1e1 / t202
  t264 = t201 * t263
  t265 = t232 * t261 * t264
  t268 = f.my_piecewise3(t182, 0, 0.4e1 / 0.3e1 * t185 * t237)
  t271 = f.my_piecewise3(t189, 0, 0.4e1 / 0.3e1 * t190 * t252)
  t272 = t268 + t271
  t274 = t177 * t272 * t264
  t275 = 0.2e1 * t274
  t276 = t232 * t193
  t277 = t202 * t8
  t278 = 0.1e1 / t277
  t281 = 0.20e2 * t276 * t201 * t278
  t285 = 0.12e2 * t276 * t198 * t199 * t263
  t286 = t199 * t178
  t287 = t198 * t286
  t290 = 0.32e2 * t276 * t287 * t204
  t291 = t232 * t272
  t292 = t287 * t263
  t293 = t291 * t292
  t294 = 0.8e1 * t293
  t295 = t291 * t205
  t296 = 0.8e1 * t295
  t298 = 0.8e1 * t194 * t292
  t299 = t183 ** 2
  t300 = f.my_piecewise3(t182, t299, t233)
  t301 = f.my_piecewise3(t189, t299, t250)
  t303 = t300 / 0.2e1 + t301 / 0.2e1
  t304 = t303 ** 2
  t305 = params.gamma * t304
  t307 = s0 + 0.2e1 * s1 + s2
  t310 = t307 / t9 / t241
  t315 = 0.1e1 / t304 * t50 * t119 * t6
  t317 = 0.7e1 / 0.288e3 * t310 * t195 * t315
  t318 = t307 * t11
  t319 = t304 * t303
  t320 = 0.1e1 / t319
  t321 = t195 * t320
  t322 = t318 * t321
  t323 = t50 * t119
  t324 = 0.1e1 / t185
  t327 = f.my_piecewise3(t182, 0, 0.2e1 / 0.3e1 * t324 * t237)
  t328 = 0.1e1 / t190
  t331 = f.my_piecewise3(t189, 0, 0.2e1 / 0.3e1 * t328 * t252)
  t333 = t327 / 0.2e1 + t331 / 0.2e1
  t335 = t323 * t6 * t333
  t338 = params.BB * params.beta
  t339 = 0.1e1 / params.gamma
  t340 = t338 * t339
  t341 = jnp.pi ** 2
  t342 = 0.1e1 / t341
  t344 = t16 + 0.56553500000000000000000000000000000000000000000000e0 * t17 + 0.130045e2
  t345 = 0.1e1 / t344
  t349 = jnp.log(t5 * t14 * t345 / 0.4e1)
  t350 = t17 + 0.113107e1
  t353 = jnp.arctan(0.71231089178181179907634622339714221951452652573438e1 / t350)
  t355 = t24 + 0.47584e-2
  t356 = t355 ** 2
  t358 = jnp.log(t356 * t345)
  t361 = t342 * (t349 + 0.31770800474394146398819696256107927053514547209957e0 * t353 + 0.41403379428206274608377249480129098139321562919141e-3 * t358)
  t362 = t361 * t193
  t366 = 0.9e1 * t196
  t367 = t198 * (-t200 * t263 + 0.1e1) * t366
  t372 = (t224 + t228 + t231 - t362 * t367 / 0.24e2 + t276 * t264) * t339
  t374 = jnp.exp(-t372 * t320)
  t375 = t374 - 0.1e1
  t376 = t375 ** 2
  t377 = 0.1e1 / t376
  t378 = t307 ** 2
  t379 = t377 * t378
  t381 = 0.1e1 / t53 / t202
  t383 = t340 * t379 * t381
  t384 = t195 ** 2
  t385 = t304 ** 2
  t386 = 0.1e1 / t385
  t388 = t384 * t386 * t2
  t389 = 0.1e1 / t51
  t390 = t389 * t7
  t394 = t344 ** 2
  t395 = 0.1e1 / t394
  t396 = t13 * t395
  t398 = -t37 - 0.94255833333333333333333333333333333333333333333334e-1 * t39
  t404 = (-t5 * t35 * t345 / 0.12e2 - t108 * t396 * t398 / 0.4e1) * t50 * t119
  t405 = t121 * t344
  t408 = t350 ** 2
  t409 = 0.1e1 / t408
  t411 = t409 * t29 * t2
  t413 = 0.1e1 + 0.50738680655100000000000000000000000000000000000000e2 * t409
  t414 = 0.1e1 / t413
  t419 = t355 * t345
  t420 = t419 * t29
  t423 = t356 * t395
  t425 = -t420 * t36 / 0.6e1 - t423 * t398
  t426 = 0.1e1 / t356
  t427 = t425 * t426
  t431 = t342 * (t404 * t405 / 0.3e1 + 0.37717812030896172972515701416987212375477090048242e0 * t411 * t32 * t34 * t414 + 0.41403379428206274608377249480129098139321562919141e-3 * t427 * t344)
  t432 = t431 * t193
  t433 = t432 * t367
  t434 = t433 / 0.24e2
  t435 = t361 * t272
  t436 = t435 * t367
  t437 = t436 / 0.24e2
  t438 = t286 * t263
  t439 = t200 * t204
  t443 = t198 * (-0.4e1 * t438 + 0.4e1 * t439) * t366
  t444 = t362 * t443
  t445 = t444 / 0.24e2
  t446 = t194 * t264
  t447 = t291 * t264
  t448 = t276 * t292
  t449 = 0.4e1 * t448
  t450 = t276 * t205
  t451 = 0.4e1 * t450
  t453 = (t162 + t174 + t176 - t434 - t437 - t445 + t446 + t447 + t449 - t451) * t339
  t455 = t386 * t333
  t458 = -t453 * t320 + 0.3e1 * t372 * t455
  t459 = t458 * t374
  t461 = t388 * t390 * t459
  t464 = 0.1e1 / t375
  t467 = t338 * t339 * t464 * t378
  t469 = 0.1e1 / t53 / t203
  t473 = t2 * t389 * t7
  t476 = 0.7e1 / 0.4608e4 * t467 * t469 * t384 * t386 * t473
  t477 = t464 * t378
  t479 = t340 * t477 * t381
  t481 = 0.1e1 / t385 / t303
  t483 = t384 * t481 * t2
  t485 = t483 * t390 * t333
  t488 = -t317 - t322 * t335 / 0.48e2 - t383 * t461 / 0.3072e4 - t476 - t479 * t485 / 0.768e3
  t489 = params.beta * t488
  t490 = params.beta * t339
  t494 = t381 * t384
  t499 = t318 * t195 * t315 / 0.96e2 + t467 * t494 * t386 * t473 / 0.3072e4
  t502 = t490 * t464 * t499 + 0.1e1
  t504 = t339 / t502
  t506 = params.beta * t499
  t507 = t502 ** 2
  t509 = t339 / t507
  t510 = t490 * t377
  t516 = -t510 * t499 * t458 * t374 + t490 * t464 * t488
  t517 = t509 * t516
  t519 = t489 * t504 - t506 * t517
  t521 = t506 * t504 + 0.1e1
  t522 = 0.1e1 / t521
  t523 = t519 * t522
  t527 = params.gamma * t319
  t528 = t519 ** 2
  t529 = t521 ** 2
  t530 = 0.1e1 / t529
  t533 = params.gamma * t303
  t534 = jnp.log(t521)
  t535 = t333 ** 2
  t539 = 0.6e1 * t305 * t523 * t333 - t527 * t528 * t530 + 0.6e1 * t533 * t534 * t535 + t101 - t207 + t265 + t275 + t281 + t285 - t290 + t294 - t296 + t298 + t87 + t94
  t540 = 0.1e1 / t186
  t546 = f.my_piecewise3(t182, 0, -0.2e1 / 0.9e1 * t540 * t238 + 0.2e1 / 0.3e1 * t324 * t245)
  t547 = 0.1e1 / t191
  t553 = f.my_piecewise3(t189, 0, -0.2e1 / 0.9e1 * t547 * t253 + 0.2e1 / 0.3e1 * t328 * t256)
  t555 = t546 / 0.2e1 + t553 / 0.2e1
  t560 = t5 * t12 * t345
  t567 = 0.1e1 / t394 / t344
  t569 = t398 ** 2
  t575 = t72 - 0.62837222222222222222222222222222222222222222222223e-1 * t76 + 0.12567444444444444444444444444444444444444444444445e0 * t79
  t585 = t6 / t53
  t609 = t408 ** 2
  t614 = t413 ** 2
  t652 = t342 * ((t560 / 0.9e1 + t108 * t34 * t395 * t398 / 0.6e1 + t108 * t13 * t567 * t569 / 0.2e1 - t108 * t396 * t575 / 0.4e1) * t50 * t119 * t405 / 0.3e1 + t404 * t585 * t344 / 0.9e1 + t404 * t121 * t398 / 0.3e1 + 0.12572604010298724324171900472329070791825696682747e0 / t408 / t350 * t2 * t4 * t12 * t414 + 0.25145208020597448648343800944658141583651393365495e0 * t409 * t48 * t50 * t74 * t55 * t414 - 0.50290416041194897296687601889316283167302786730989e0 * t411 * t32 * t11 * t414 - 0.63791733988157656503906862782236557702656491548799e1 / t609 / t350 * t2 * t4 * t12 / t614 + 0.41403379428206274608377249480129098139321562919141e-3 * (t560 / 0.72e2 + t355 * t395 * t30 * t32 * t34 * t398 / 0.3e1 - t419 * t48 * t57 / 0.9e1 + 0.2e1 / 0.9e1 * t420 * t61 + 0.2e1 * t356 * t567 * t569 - t423 * t575) * t426 * t344 + 0.69005632380343791013962082466881830232202604865235e-4 * t425 / t356 / t355 * t344 * t29 * t36 + 0.41403379428206274608377249480129098139321562919141e-3 * t427 * t398) * t193 * t367 / 0.24e2
  t654 = t435 * t443 / 0.12e2
  t656 = 0.12e2 * t199 * t263
  t658 = 0.32e2 * t286 * t204
  t660 = 0.20e2 * t200 * t278
  t665 = t362 * t198 * (-t656 + t658 - t660) * t366 / 0.24e2
  t667 = t431 * t272 * t367
  t668 = t667 / 0.12e2
  t671 = t361 * t261 * t367 / 0.24e2
  t675 = 0.53020994233369026907085240525174613991298354771549e-1 * t167 * t32 * t11 * t170
  t681 = 0.26510497116684513453542620262587306995649177385775e-1 * t165 * t48 * t50 * t74 * t55 * t170
  t682 = t432 * t443
  t683 = t682 / 0.12e2
  t700 = 0.10363566666666666666666666666666666666666666666667e-1 * (t22 / 0.9e1 + t108 * t34 * t27 * t41 / 0.6e1 + t108 * t13 * t66 * t68 / 0.2e1 - t108 * t153 * t81 / 0.4e1) * t50 * t119 * t160
  t703 = 0.34545222222222222222222222222222222222222222222223e-2 * t159 * t585 * t19
  t706 = 0.10363566666666666666666666666666666666666666666667e-1 * t159 * t121 * t41
  t713 = 0.13255248558342256726771310131293653497824588692887e-1 / t164 / t163 * t2 * t4 * t12 * t170
  t714 = t164 ** 2
  t719 = t169 ** 2
  t723 = 0.50167127350538589836488394571946851238131125013746e0 / t714 / t163 * t2 * t4 * t12 / t719
  t729 = 0.35e2 / 0.432e3 * t307 / t9 / t202 * t195 * t315
  t730 = t310 * t321
  t731 = t730 * t335
  t734 = t318 * t195 * t386
  t744 = 0.1e1 / t376 / t375
  t745 = t744 * t378
  t747 = t340 * t745 * t381
  t748 = t458 ** 2
  t749 = t374 ** 2
  t756 = t340 * t379 * t469
  t757 = t756 * t461
  t760 = t340 * t379 * t494
  t762 = t481 * t2 * t389
  t764 = t374 * t333
  t769 = t87 + t94 + t101 - t207 + t265 + t275 + t281 + t285 - t290 + t294 - t296 + t298 - t652
  t771 = t5 * t12 * t104
  t778 = 0.1e1 / t109 / t103
  t780 = t113 ** 2
  t786 = t72 - 0.39224555555555555555555555555555555555555555555555e0 * t76 + 0.78449111111111111111111111111111111111111111111110e0 * t79
  t818 = t126 ** 2
  t823 = t131 ** 2
  t857 = 0.51817833333333333333333333333333333333333333333333e-2 * (t771 / 0.9e1 + t108 * t34 * t110 * t113 / 0.6e1 + t108 * t13 * t778 * t780 / 0.2e1 - t108 * t111 * t786 / 0.4e1) * t50 * t119 * t122 + 0.17272611111111111111111111111111111111111111111111e-2 * t120 * t585 * t103 + 0.51817833333333333333333333333333333333333333333333e-2 * t120 * t121 * t113 + 0.13796274692623141086738355049039257855828824683819e-1 / t126 / t125 * t2 * t4 * t12 * t132 + 0.27592549385246282173476710098078515711657649367639e-1 * t127 * t48 * t50 * t74 * t55 * t132 - 0.55185098770492564346953420196157031423315298735277e-1 * t129 * t32 * t11 * t132 - 0.30878365944746984533884071665444263610784010246137e0 / t818 / t125 * t2 * t4 * t12 / t823 + 0.22478670955426118383265363956423012380560746650571e-2 * (t771 / 0.72e2 + t137 * t110 * t30 * t32 * t34 * t113 / 0.3e1 - t138 * t48 * t57 / 0.9e1 + 0.2e1 / 0.9e1 * t139 * t61 + 0.2e1 * t142 * t778 * t780 - t143 * t786) * t146 * t103 + 0.37464451592376863972108939927371687300934577750952e-3 * t145 / t142 / t137 * t103 * t29 * t36 + 0.22478670955426118383265363956423012380560746650571e-2 * t147 * t113 - t700 - t703 - t706 - t713 - t681 + t675 + t723 - t87 - t101 - t94
  t859 = t857 * t193 * t264
  t860 = -t654 - t665 - t668 - t671 - t675 + t681 - t683 + t700 + t703 + t706 + t713 - t723 + t859
  t872 = -(t769 + t860) * t339 * t320 + 0.6e1 * t453 * t455 - 0.12e2 * t372 * t481 * t535 + 0.3e1 * t372 * t386 * t555
  t889 = 0.119e3 / 0.13824e5 * t467 / t53 / t277 * t384 * t386 * t473
  t891 = t340 * t477 * t469
  t892 = t891 * t485
  t897 = t384 / t385 / t304 * t2
  t906 = t729 + 0.7e1 / 0.72e2 * t731 + t734 * t323 * t6 * t535 / 0.16e2 - t322 * t323 * t6 * t555 / 0.48e2 + t747 * t388 * t390 * t748 * t749 / 0.1536e4 + 0.7e1 / 0.2304e4 * t757 + t760 * t762 * t7 * t458 * t764 / 0.384e3 - t383 * t388 * t390 * t872 * t374 / 0.3072e4 - t383 * t388 * t390 * t748 * t374 / 0.3072e4 + t889 + 0.7e1 / 0.576e3 * t892 + 0.5e1 / 0.768e3 * t479 * t897 * t390 * t535 - t479 * t483 * t390 * t555 / 0.768e3
  t912 = 0.1e1 / t507 / t502
  t913 = t339 * t912
  t914 = t516 ** 2
  t918 = t490 * t744
  t919 = t499 * t748
  t940 = 0.3e1 * t305 * t534 * t555 - t652 - t654 - t665 - t668 - t671 - t675 + t681 - t683 + t700 + t703 + t706 + t713 - t723 + t527 * (params.beta * t906 * t504 - 0.2e1 * t489 * t517 + 0.2e1 * t506 * t913 * t914 - t506 * t509 * (-0.2e1 * t510 * t488 * t458 * t374 - t510 * t499 * t872 * t374 - t510 * t919 * t374 + t490 * t464 * t906 + 0.2e1 * t918 * t919 * t749)) * t522 + t859
  t943 = 0.8e1 * t448
  t944 = 0.8e1 * t450
  t945 = 0.2e1 * t446
  t948 = t305 * t534 * t333
  t950 = t527 * t523
  t952 = 0.79531491350053540360627860787761920986947532157324e-1 * t173
  t953 = 0.20727133333333333333333333333333333333333333333334e-1 * t161
  t954 = 0.19380455423088748427520788642112429810098696998902e-2 * t175
  t955 = t433 / 0.12e2
  d11 = t1 * (t539 + t940) + t943 - t944 + t945 + 0.2e1 * t447 + 0.6e1 * t948 + 0.2e1 * t950 + t952 + t953 + t954 - t955 - t436 / 0.12e2 - t444 / 0.12e2
  t958 = -t179 - t236
  t961 = f.my_piecewise3(t182, 0, 0.4e1 / 0.3e1 * t185 * t958)
  t962 = -t958
  t965 = f.my_piecewise3(t189, 0, 0.4e1 / 0.3e1 * t190 * t962)
  t966 = t961 + t965
  t967 = t232 * t966
  t968 = t967 * t264
  t969 = t361 * t966
  t970 = t969 * t367
  t971 = t970 / 0.24e2
  t975 = t198 * (0.4e1 * t438 + 0.4e1 * t439) * t366
  t976 = t362 * t975
  t977 = t976 / 0.24e2
  t981 = f.my_piecewise3(t182, 0, 0.2e1 / 0.3e1 * t324 * t958)
  t984 = f.my_piecewise3(t189, 0, 0.2e1 / 0.3e1 * t328 * t962)
  t986 = t981 / 0.2e1 + t984 / 0.2e1
  t987 = t6 * t986
  t988 = t323 * t987
  t992 = (t162 + t174 + t176 - t434 - t971 - t977 + t446 + t968 - t449 - t451) * t339
  t994 = t386 * t986
  t997 = -t992 * t320 + 0.3e1 * t372 * t994
  t1000 = t388 * t390 * t997 * t374
  t1004 = t483 * t390 * t986
  t1007 = -t317 - t322 * t988 / 0.48e2 - t383 * t1000 / 0.3072e4 - t476 - t479 * t1004 / 0.768e3
  t1008 = params.beta * t1007
  t1010 = t499 * t997
  t1015 = t490 * t464 * t1007 - t510 * t1010 * t374
  t1016 = t509 * t1015
  t1018 = t1008 * t504 - t506 * t1016
  t1019 = t1018 * t522
  t1020 = t527 * t1019
  t1022 = t435 * t975 / 0.24e2
  t1027 = t362 * t198 * (t656 - t660) * t366 / 0.24e2
  t1031 = 0.4e1 * t293
  t1032 = 0.4e1 * t295
  t1040 = f.my_piecewise3(t182, 0, -0.2e1 / 0.9e1 * t540 * t958 * t237 + 0.4e1 / 0.3e1 * t324 * t178 * t242)
  t1048 = f.my_piecewise3(t189, 0, -0.2e1 / 0.9e1 * t547 * t962 * t252 - 0.4e1 / 0.3e1 * t328 * t178 * t242)
  t1050 = t1040 / 0.2e1 + t1048 / 0.2e1
  t1055 = t730 * t988
  t1068 = t386 * t2 * t389
  t1069 = t7 * t997
  t1070 = t749 * t458
  t1075 = t756 * t1000
  t1082 = t431 * t966 * t367
  t1083 = t1082 / 0.24e2
  t1091 = f.my_piecewise3(t182, 0, 0.4e1 / 0.9e1 * t234 * t958 * t237 + 0.8e1 / 0.3e1 * t185 * t178 * t242)
  t1099 = f.my_piecewise3(t189, 0, 0.4e1 / 0.9e1 * t251 * t962 * t252 - 0.8e1 / 0.3e1 * t190 * t178 * t242)
  t1100 = t1091 + t1099
  t1103 = t361 * t1100 * t367 / 0.24e2
  t1105 = t969 * t443 / 0.24e2
  t1106 = t432 * t975
  t1107 = t1106 / 0.24e2
  t1108 = t87 + t94 - t1022 - t1027 + t101 - t207 + t274 + t281 - t285 - t1031 - t1032 - t1083 - t1103 - t1105 - t1107
  t1110 = t232 * t1100 * t264
  t1112 = t177 * t966 * t264
  t1113 = t967 * t292
  t1114 = 0.4e1 * t1113
  t1115 = t967 * t205
  t1116 = 0.4e1 * t1115
  t1117 = t667 / 0.24e2
  t1118 = t682 / 0.24e2
  t1119 = t1110 + t1112 + t1114 - t1116 - t652 - t1117 - t675 + t681 - t1118 + t700 + t703 + t706 + t713 - t723 + t859
  t1134 = -(t1108 + t1119) * t339 * t320 + 0.3e1 * t992 * t455 + 0.3e1 * t453 * t994 - 0.12e2 * t372 * t481 * t986 * t333 + 0.3e1 * t372 * t386 * t1050
  t1151 = t891 * t1004
  t1162 = t729 + 0.7e1 / 0.144e3 * t731 + 0.7e1 / 0.144e3 * t1055 + t734 * t323 * t987 * t333 / 0.16e2 - t322 * t323 * t6 * t1050 / 0.48e2 + t340 * t745 * t494 * t1068 * t1069 * t1070 / 0.1536e4 + 0.7e1 / 0.4608e4 * t1075 + t760 * t762 * t1069 * t764 / 0.768e3 - t383 * t388 * t390 * t1134 * t374 / 0.3072e4 - t760 * t1068 * t1069 * t459 / 0.3072e4 + 0.7e1 / 0.4608e4 * t757 + t889 + 0.7e1 / 0.1152e4 * t892 + t760 * t762 * t7 * t986 * t459 / 0.768e3 + 0.7e1 / 0.1152e4 * t1151 + 0.5e1 / 0.768e3 * t479 * t897 * t390 * t986 * t333 - t479 * t483 * t390 * t1050 / 0.768e3
  t1194 = t87 + t94 - t1022 - t1027 - t527 * t1018 * t530 * t519 + t101 - t207 + t274 + t281 - t285 - t1031 - t1032 + 0.3e1 * t305 * t534 * t1050 + t527 * (params.beta * t1162 * t504 - t1008 * t517 - t489 * t1016 + 0.2e1 * t506 * t339 * t912 * t1015 * t516 - t506 * t509 * (-t510 * t1007 * t458 * t374 - t510 * t499 * t1134 * t374 - t510 * t488 * t997 * t374 + 0.2e1 * t918 * t1010 * t1070 - t510 * t1010 * t459 + t490 * t464 * t1162)) * t522 - t1083 - t1103 - t1105 - t1107
  t1195 = t534 * t986
  t1205 = 0.3e1 * t305 * t1019 * t333 + 0.6e1 * t533 * t1195 * t333 + 0.3e1 * t305 * t523 * t986 + t1110 + t1112 + t1114 - t1116 - t1117 - t1118 - t652 - t675 + t681 + t700 + t703 + t706 + t713 - t723 + t859
  t1208 = t305 * t1195
  d12 = t945 + t968 + t953 - t955 - t971 - t977 - t437 - t445 + t954 + 0.3e1 * t948 + t1020 + t952 + t447 + t1 * (t1194 + t1205) - t944 + 0.3e1 * t1208 + t950
  t1214 = t958 ** 2
  t1218 = 0.2e1 * t235 + 0.2e1 * t243
  t1222 = f.my_piecewise3(t182, 0, 0.4e1 / 0.9e1 * t234 * t1214 + 0.4e1 / 0.3e1 * t185 * t1218)
  t1223 = t962 ** 2
  t1226 = -t1218
  t1230 = f.my_piecewise3(t189, 0, 0.4e1 / 0.9e1 * t251 * t1223 + 0.4e1 / 0.3e1 * t190 * t1226)
  t1231 = t1222 + t1230
  t1233 = t232 * t1231 * t264
  t1237 = t1082 / 0.12e2
  t1238 = t1106 / 0.12e2
  t1239 = t1018 ** 2
  t1242 = 0.2e1 * t1112
  t1243 = 0.8e1 * t1113
  t1244 = 0.6e1 * t305 * t1019 * t986 - t527 * t1239 * t530 + t101 + t1233 - t1237 - t1238 + t1242 - t1243 - t207 + t281 + t285 + t290 - t298 + t87 + t94
  t1245 = 0.8e1 * t1115
  t1251 = f.my_piecewise3(t182, 0, -0.2e1 / 0.9e1 * t540 * t1214 + 0.2e1 / 0.3e1 * t324 * t1218)
  t1257 = f.my_piecewise3(t189, 0, -0.2e1 / 0.9e1 * t547 * t1223 + 0.2e1 / 0.3e1 * t328 * t1226)
  t1259 = t1251 / 0.2e1 + t1257 / 0.2e1
  t1263 = t986 ** 2
  t1276 = t997 ** 2
  t1288 = t1233 + t87 + t94 + t101 - t207 + t281 + t285 + t290 - t298 - t1237 - t1238 + t1242 - t1243
  t1293 = t362 * t198 * (-t656 - t658 - t660) * t366 / 0.24e2
  t1296 = t361 * t1231 * t367 / 0.24e2
  t1298 = t969 * t975 / 0.12e2
  t1299 = -t1245 - t652 - t675 + t681 + t700 + t703 + t706 + t713 - t723 + t859 - t1293 - t1296 - t1298
  t1311 = -(t1288 + t1299) * t339 * t320 + 0.6e1 * t992 * t994 - 0.12e2 * t372 * t481 * t1263 + 0.3e1 * t372 * t386 * t1259
  t1331 = t729 + 0.7e1 / 0.72e2 * t1055 + t734 * t323 * t6 * t1263 / 0.16e2 - t322 * t323 * t6 * t1259 / 0.48e2 + t747 * t388 * t390 * t1276 * t749 / 0.1536e4 + 0.7e1 / 0.2304e4 * t1075 + t760 * t762 * t1069 * t374 * t986 / 0.384e3 - t383 * t388 * t390 * t1311 * t374 / 0.3072e4 - t383 * t388 * t390 * t1276 * t374 / 0.3072e4 + t889 + 0.7e1 / 0.576e3 * t1151 + 0.5e1 / 0.768e3 * t479 * t897 * t390 * t1263 - t479 * t483 * t390 * t1259 / 0.768e3
  t1336 = t1015 ** 2
  t1340 = t499 * t1276
  t1361 = -t1245 + 0.3e1 * t305 * t534 * t1259 + 0.6e1 * t533 * t534 * t1263 + t527 * (params.beta * t1331 * t504 - 0.2e1 * t1008 * t1016 + 0.2e1 * t506 * t913 * t1336 - t506 * t509 * (-0.2e1 * t510 * t1007 * t997 * t374 - t510 * t499 * t1311 * t374 + t490 * t464 * t1331 - t510 * t1340 * t374 + 0.2e1 * t918 * t1340 * t749)) * t522 - t652 - t675 + t681 + t700 + t703 + t706 + t713 - t723 + t859 - t1293 - t1296 - t1298
  d22 = -t970 / 0.12e2 - t976 / 0.12e2 + t953 - t955 + t954 + 0.2e1 * t1020 - t944 + 0.2e1 * t968 - t943 + t945 + t1 * (t1244 + t1361) + 0.6e1 * t1208 + t952
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 + r1
  t2 = r0 - r1
  t3 = 0.1e1 / t1
  t4 = t2 * t3
  t5 = 0.1e1 + t4
  t6 = t5 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = t5 ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t11 = f.my_piecewise3(t6, t8, t10)
  t12 = 0.1e1 - t4
  t13 = t12 <= f.p.zeta_threshold
  t14 = t12 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t16 = f.my_piecewise3(t13, t8, t15)
  t18 = t11 / 0.2e1 + t16 / 0.2e1
  t19 = t18 ** 2
  t20 = params.gamma * t19
  t22 = s0 + 0.2e1 * s1 + s2
  t23 = t1 ** 2
  t24 = t23 * t1
  t25 = t1 ** (0.1e1 / 0.3e1)
  t28 = t22 / t25 / t24
  t29 = 2 ** (0.1e1 / 0.3e1)
  t32 = 3 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t36 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t37 = 0.1e1 / t36
  t38 = 4 ** (0.1e1 / 0.3e1)
  t40 = 0.1e1 / t19 * t33 * t37 * t38
  t42 = 0.7e1 / 0.288e3 * t28 * t29 * t40
  t44 = 0.1e1 / t25 / t23
  t45 = t22 * t44
  t46 = t19 * t18
  t47 = 0.1e1 / t46
  t48 = t29 * t47
  t49 = t45 * t48
  t50 = t33 * t37
  t51 = 0.1e1 / t9
  t52 = 0.1e1 / t23
  t53 = t2 * t52
  t54 = t3 - t53
  t57 = f.my_piecewise3(t6, 0, 0.2e1 / 0.3e1 * t51 * t54)
  t58 = 0.1e1 / t14
  t59 = -t54
  t62 = f.my_piecewise3(t13, 0, 0.2e1 / 0.3e1 * t58 * t59)
  t64 = t57 / 0.2e1 + t62 / 0.2e1
  t66 = t50 * t38 * t64
  t69 = params.BB * params.beta
  t70 = 0.1e1 / params.gamma
  t71 = t69 * t70
  t72 = t32 * t36
  t73 = t38 ** 2
  t74 = 0.1e1 / t25
  t75 = t73 * t74
  t76 = t72 * t75
  t77 = t76 / 0.4e1
  t78 = jnp.sqrt(t76)
  t80 = t77 + 0.18637200000000000000000000000000000000000000000000e1 * t78 + 0.129352e2
  t81 = 0.1e1 / t80
  t85 = jnp.log(t72 * t75 * t81 / 0.4e1)
  t86 = 0.310907e-1 * t85
  t87 = t78 + 0.372744e1
  t90 = jnp.arctan(0.61519908197590802321728722658814145360143502774884e1 / t87)
  t91 = 0.38783294878113014394824731224995739188004877421366e-1 * t90
  t92 = t78 / 0.2e1
  t93 = t92 + 0.10498e0
  t94 = t93 ** 2
  t96 = jnp.log(t94 * t81)
  t97 = 0.96902277115443742137603943210562149050493484994510e-3 * t96
  t98 = jnp.pi ** 2
  t99 = 0.1e1 / t98
  t101 = t77 + 0.56553500000000000000000000000000000000000000000000e0 * t78 + 0.130045e2
  t102 = 0.1e1 / t101
  t106 = jnp.log(t72 * t75 * t102 / 0.4e1)
  t107 = t78 + 0.113107e1
  t110 = jnp.arctan(0.71231089178181179907634622339714221951452652573438e1 / t107)
  t112 = t92 + 0.47584e-2
  t113 = t112 ** 2
  t115 = jnp.log(t113 * t102)
  t118 = t99 * (t106 + 0.31770800474394146398819696256107927053514547209957e0 * t110 + 0.41403379428206274608377249480129098139321562919141e-3 * t115)
  t119 = t7 * f.p.zeta_threshold
  t120 = t9 * t5
  t121 = f.my_piecewise3(t6, t119, t120)
  t122 = t14 * t12
  t123 = f.my_piecewise3(t13, t119, t122)
  t124 = t121 + t123 - 0.2e1
  t125 = t118 * t124
  t126 = t29 - 0.1e1
  t128 = 0.1e1 / t126 / 0.2e1
  t129 = t2 ** 2
  t130 = t129 ** 2
  t131 = t23 ** 2
  t132 = 0.1e1 / t131
  t136 = 0.9e1 * t126
  t137 = t128 * (-t130 * t132 + 0.1e1) * t136
  t141 = t77 + 0.35302100000000000000000000000000000000000000000000e1 * t78 + 0.180578e2
  t142 = 0.1e1 / t141
  t146 = jnp.log(t72 * t75 * t142 / 0.4e1)
  t148 = t78 + 0.706042e1
  t151 = jnp.arctan(0.47309269095601128299619512910246923284397083311420e1 / t148)
  t153 = t92 + 0.32500e0
  t154 = t153 ** 2
  t156 = jnp.log(t154 * t142)
  t158 = 0.1554535e-1 * t146 + 0.52491393169780936217021346072241076933841385384497e-1 * t151 + 0.22478670955426118383265363956423012380560746650571e-2 * t156 - t86 - t91 - t97
  t159 = t158 * t124
  t160 = t128 * t130
  t161 = t160 * t132
  t164 = (t86 + t91 + t97 - t125 * t137 / 0.24e2 + t159 * t161) * t70
  t166 = jnp.exp(-t164 * t47)
  t167 = t166 - 0.1e1
  t168 = t167 ** 2
  t169 = 0.1e1 / t168
  t170 = t22 ** 2
  t171 = t169 * t170
  t172 = t25 ** 2
  t174 = 0.1e1 / t172 / t131
  t176 = t71 * t171 * t174
  t177 = t29 ** 2
  t178 = t19 ** 2
  t179 = 0.1e1 / t178
  t181 = t177 * t179 * t32
  t182 = t36 ** 2
  t183 = 0.1e1 / t182
  t184 = t183 * t73
  t186 = 0.1e1 / t25 / t1
  t187 = t73 * t186
  t191 = t72 * t73
  t192 = t80 ** 2
  t193 = 0.1e1 / t192
  t194 = t74 * t193
  t195 = t72 * t187
  t196 = t195 / 0.12e2
  t197 = 0.1e1 / t78
  t198 = t197 * t32
  t199 = t36 * t73
  t201 = t198 * t199 * t186
  t203 = -t196 - 0.31062000000000000000000000000000000000000000000000e0 * t201
  t209 = (-t72 * t187 * t81 / 0.12e2 - t191 * t194 * t203 / 0.4e1) * t33 * t37
  t210 = t38 * t25
  t211 = t210 * t80
  t212 = t209 * t211
  t213 = 0.10363566666666666666666666666666666666666666666667e-1 * t212
  t214 = t87 ** 2
  t215 = 0.1e1 / t214
  t217 = t215 * t197 * t32
  t219 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t215
  t220 = 0.1e1 / t219
  t223 = t217 * t199 * t186 * t220
  t224 = 0.39765745675026770180313930393880960493473766078662e-1 * t223
  t225 = t93 * t81
  t226 = t225 * t197
  t229 = t94 * t193
  t231 = -t226 * t195 / 0.6e1 - t229 * t203
  t232 = 0.1e1 / t94
  t233 = t231 * t232
  t234 = t233 * t80
  t235 = 0.96902277115443742137603943210562149050493484994510e-3 * t234
  t239 = t101 ** 2
  t240 = 0.1e1 / t239
  t241 = t74 * t240
  t243 = -t196 - 0.94255833333333333333333333333333333333333333333334e-1 * t201
  t249 = (-t72 * t187 * t102 / 0.12e2 - t191 * t241 * t243 / 0.4e1) * t33 * t37
  t250 = t210 * t101
  t253 = t107 ** 2
  t254 = 0.1e1 / t253
  t256 = t254 * t197 * t32
  t258 = 0.1e1 + 0.50738680655100000000000000000000000000000000000000e2 * t254
  t259 = 0.1e1 / t258
  t264 = t112 * t102
  t265 = t264 * t197
  t268 = t113 * t240
  t270 = -t265 * t195 / 0.6e1 - t268 * t243
  t271 = 0.1e1 / t113
  t272 = t270 * t271
  t276 = t99 * (t249 * t250 / 0.3e1 + 0.37717812030896172972515701416987212375477090048242e0 * t256 * t199 * t186 * t259 + 0.41403379428206274608377249480129098139321562919141e-3 * t272 * t101)
  t277 = t276 * t124
  t278 = t277 * t137
  t279 = t278 / 0.24e2
  t282 = f.my_piecewise3(t6, 0, 0.4e1 / 0.3e1 * t9 * t54)
  t285 = f.my_piecewise3(t13, 0, 0.4e1 / 0.3e1 * t14 * t59)
  t286 = t282 + t285
  t287 = t118 * t286
  t288 = t287 * t137
  t289 = t288 / 0.24e2
  t290 = t129 * t2
  t291 = t290 * t132
  t292 = t131 * t1
  t293 = 0.1e1 / t292
  t294 = t130 * t293
  t298 = t128 * (-0.4e1 * t291 + 0.4e1 * t294) * t136
  t299 = t125 * t298
  t300 = t299 / 0.24e2
  t304 = t141 ** 2
  t305 = 0.1e1 / t304
  t306 = t74 * t305
  t308 = -t196 - 0.58836833333333333333333333333333333333333333333333e0 * t201
  t314 = (-t72 * t187 * t142 / 0.12e2 - t191 * t306 * t308 / 0.4e1) * t33 * t37
  t315 = t210 * t141
  t318 = t148 ** 2
  t319 = 0.1e1 / t318
  t321 = t319 * t197 * t32
  t323 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t319
  t324 = 0.1e1 / t323
  t329 = t153 * t142
  t330 = t329 * t197
  t333 = t154 * t305
  t335 = -t330 * t195 / 0.6e1 - t333 * t308
  t336 = 0.1e1 / t154
  t337 = t335 * t336
  t340 = 0.51817833333333333333333333333333333333333333333333e-2 * t314 * t315 + 0.41388824077869423260215065147117773567486474051458e-1 * t321 * t199 * t186 * t324 + 0.22478670955426118383265363956423012380560746650571e-2 * t337 * t141 - t213 - t224 - t235
  t341 = t340 * t124
  t342 = t341 * t161
  t343 = t158 * t286
  t344 = t343 * t161
  t345 = t128 * t290
  t346 = t345 * t132
  t347 = t159 * t346
  t348 = 0.4e1 * t347
  t349 = t160 * t293
  t350 = t159 * t349
  t351 = 0.4e1 * t350
  t353 = (t213 + t224 + t235 - t279 - t289 - t300 + t342 + t344 + t348 - t351) * t70
  t355 = t179 * t64
  t358 = 0.3e1 * t164 * t355 - t353 * t47
  t359 = t358 * t166
  t361 = t181 * t184 * t359
  t364 = 0.1e1 / t167
  t367 = t69 * t70 * t364 * t170
  t369 = 0.1e1 / t172 / t292
  t373 = t32 * t183 * t73
  t376 = 0.7e1 / 0.4608e4 * t367 * t369 * t177 * t179 * t373
  t377 = t364 * t170
  t379 = t71 * t377 * t174
  t381 = 0.1e1 / t178 / t18
  t383 = t177 * t381 * t32
  t385 = t383 * t184 * t64
  t388 = -t42 - t49 * t66 / 0.48e2 - t176 * t361 / 0.3072e4 - t376 - t379 * t385 / 0.768e3
  t389 = params.beta * t388
  t390 = params.beta * t70
  t394 = t174 * t177
  t399 = t45 * t29 * t40 / 0.96e2 + t367 * t394 * t179 * t373 / 0.3072e4
  t402 = t390 * t364 * t399 + 0.1e1
  t404 = t70 / t402
  t406 = params.beta * t399
  t407 = t402 ** 2
  t409 = t70 / t407
  t410 = t390 * t169
  t416 = -t410 * t399 * t358 * t166 + t390 * t364 * t388
  t417 = t409 * t416
  t419 = t389 * t404 - t406 * t417
  t421 = t406 * t404 + 0.1e1
  t422 = 0.1e1 / t421
  t423 = t419 * t422
  t428 = t38 / t172
  t431 = 0.34545222222222222222222222222222222222222222222223e-2 * t209 * t428 * t80
  t434 = 0.10363566666666666666666666666666666666666666666667e-1 * t209 * t210 * t203
  t439 = t73 * t44
  t442 = 0.13255248558342256726771310131293653497824588692887e-1 / t214 / t87 * t32 * t36 * t439 * t220
  t443 = t214 ** 2
  t448 = t219 ** 2
  t452 = 0.50167127350538589836488394571946851238131125013746e0 / t443 / t87 * t32 * t36 * t439 / t448
  t454 = t72 * t439 * t81
  t463 = 0.1e1 / t78 / t76
  t467 = 0.1e1 / t172 / t23
  t469 = t33 * t182 * t38 * t467
  t472 = t72 * t439
  t476 = 0.1e1 / t192 / t80
  t478 = t203 ** 2
  t481 = t472 / 0.9e1
  t483 = t182 * t38
  t485 = t463 * t33 * t483 * t467
  t488 = t198 * t199 * t44
  t490 = t481 - 0.20708000000000000000000000000000000000000000000000e0 * t485 + 0.41416000000000000000000000000000000000000000000000e0 * t488
  t495 = 0.96902277115443742137603943210562149050493484994510e-3 * (t454 / 0.72e2 + t93 * t193 * t198 * t199 * t186 * t203 / 0.3e1 - t225 * t463 * t469 / 0.9e1 + 0.2e1 / 0.9e1 * t226 * t472 + 0.2e1 * t94 * t476 * t478 - t229 * t490) * t232 * t80
  t497 = 0.96902277115443742137603943210562149050493484994510e-3 * t233 * t203
  t498 = 0.1e1 / t10
  t499 = t54 ** 2
  t502 = 0.1e1 / t24
  t503 = t2 * t502
  t505 = -0.2e1 * t52 + 0.2e1 * t503
  t509 = f.my_piecewise3(t6, 0, 0.4e1 / 0.9e1 * t498 * t499 + 0.4e1 / 0.3e1 * t9 * t505)
  t510 = 0.1e1 / t15
  t511 = t59 ** 2
  t514 = -t505
  t518 = f.my_piecewise3(t13, 0, 0.4e1 / 0.9e1 * t510 * t511 + 0.4e1 / 0.3e1 * t14 * t514)
  t519 = t509 + t518
  t522 = t118 * t519 * t137 / 0.24e2
  t524 = t340 * t286 * t161
  t525 = 0.2e1 * t524
  t526 = t131 * t23
  t527 = 0.1e1 / t526
  t530 = 0.20e2 * t159 * t160 * t527
  t534 = 0.12e2 * t159 * t128 * t129 * t132
  t537 = 0.32e2 * t159 * t345 * t293
  t538 = t343 * t346
  t539 = 0.8e1 * t538
  t540 = t343 * t349
  t541 = 0.8e1 * t540
  t543 = 0.8e1 * t341 * t346
  t544 = 0.6e1 * t20 * t423 * t64 + t431 + t434 + t442 - t452 + t495 + t497 - t522 + t525 + t530 + t534 - t537 + t539 - t541 + t543
  t546 = t158 * t519 * t161
  t548 = 0.8e1 * t341 * t349
  t550 = t72 * t439 * t142
  t557 = 0.1e1 / t304 / t141
  t559 = t308 ** 2
  t565 = t481 - 0.39224555555555555555555555555555555555555555555555e0 * t485 + 0.78449111111111111111111111111111111111111111111110e0 * t488
  t597 = t318 ** 2
  t602 = t323 ** 2
  t652 = 0.10363566666666666666666666666666666666666666666667e-1 * (t454 / 0.9e1 + t191 * t186 * t193 * t203 / 0.6e1 + t191 * t74 * t476 * t478 / 0.2e1 - t191 * t194 * t490 / 0.4e1) * t33 * t37 * t211
  t658 = 0.26510497116684513453542620262587306995649177385775e-1 * t215 * t463 * t33 * t483 * t467 * t220
  t662 = 0.53020994233369026907085240525174613991298354771549e-1 * t217 * t199 * t44 * t220
  t669 = 0.16150379519240623689600657201760358175082247499085e-3 * t231 / t94 / t93 * t80 * t197 * t195
  t670 = 0.51817833333333333333333333333333333333333333333333e-2 * (t550 / 0.9e1 + t191 * t186 * t305 * t308 / 0.6e1 + t191 * t74 * t557 * t559 / 0.2e1 - t191 * t306 * t565 / 0.4e1) * t33 * t37 * t315 + 0.17272611111111111111111111111111111111111111111111e-2 * t314 * t428 * t141 + 0.51817833333333333333333333333333333333333333333333e-2 * t314 * t210 * t308 + 0.13796274692623141086738355049039257855828824683819e-1 / t318 / t148 * t32 * t36 * t439 * t324 + 0.27592549385246282173476710098078515711657649367639e-1 * t319 * t463 * t33 * t483 * t467 * t324 - 0.55185098770492564346953420196157031423315298735277e-1 * t321 * t199 * t44 * t324 - 0.30878365944746984533884071665444263610784010246137e0 / t597 / t148 * t32 * t36 * t439 / t602 + 0.22478670955426118383265363956423012380560746650571e-2 * (t550 / 0.72e2 + t153 * t305 * t198 * t199 * t186 * t308 / 0.3e1 - t329 * t463 * t469 / 0.9e1 + 0.2e1 / 0.9e1 * t330 * t472 + 0.2e1 * t154 * t557 * t559 - t333 * t565) * t336 * t141 + 0.37464451592376863972108939927371687300934577750952e-3 * t335 / t154 / t153 * t141 * t197 * t195 + 0.22478670955426118383265363956423012380560746650571e-2 * t337 * t308 - t652 - t431 - t434 - t442 - t658 + t662 + t452 - t495 - t669 - t497
  t672 = t670 * t124 * t161
  t674 = t72 * t439 * t102
  t681 = 0.1e1 / t239 / t101
  t683 = t243 ** 2
  t689 = t481 - 0.62837222222222222222222222222222222222222222222223e-1 * t485 + 0.12567444444444444444444444444444444444444444444445e0 * t488
  t721 = t253 ** 2
  t726 = t258 ** 2
  t764 = t99 * ((t674 / 0.9e1 + t191 * t186 * t240 * t243 / 0.6e1 + t191 * t74 * t681 * t683 / 0.2e1 - t191 * t241 * t689 / 0.4e1) * t33 * t37 * t250 / 0.3e1 + t249 * t428 * t101 / 0.9e1 + t249 * t210 * t243 / 0.3e1 + 0.12572604010298724324171900472329070791825696682747e0 / t253 / t107 * t32 * t36 * t439 * t259 + 0.25145208020597448648343800944658141583651393365495e0 * t254 * t463 * t33 * t483 * t467 * t259 - 0.50290416041194897296687601889316283167302786730989e0 * t256 * t199 * t44 * t259 - 0.63791733988157656503906862782236557702656491548799e1 / t721 / t107 * t32 * t36 * t439 / t726 + 0.41403379428206274608377249480129098139321562919141e-3 * (t674 / 0.72e2 + t112 * t240 * t198 * t199 * t186 * t243 / 0.3e1 - t264 * t463 * t469 / 0.9e1 + 0.2e1 / 0.9e1 * t265 * t472 + 0.2e1 * t113 * t681 * t683 - t268 * t689) * t271 * t101 + 0.69005632380343791013962082466881830232202604865235e-4 * t270 / t113 / t112 * t101 * t197 * t195 + 0.41403379428206274608377249480129098139321562919141e-3 * t272 * t243) * t124 * t137 / 0.24e2
  t766 = t287 * t298 / 0.12e2
  t768 = 0.12e2 * t129 * t132
  t770 = 0.32e2 * t290 * t293
  t772 = 0.20e2 * t130 * t527
  t777 = t125 * t128 * (-t768 + t770 - t772) * t136 / 0.24e2
  t779 = t276 * t286 * t137
  t780 = t779 / 0.12e2
  t781 = t277 * t298
  t782 = t781 / 0.12e2
  t783 = params.gamma * t18
  t784 = jnp.log(t421)
  t785 = t64 ** 2
  t789 = 0.1e1 / t120
  t795 = f.my_piecewise3(t6, 0, -0.2e1 / 0.9e1 * t789 * t499 + 0.2e1 / 0.3e1 * t51 * t505)
  t796 = 0.1e1 / t122
  t802 = f.my_piecewise3(t13, 0, -0.2e1 / 0.9e1 * t796 * t511 + 0.2e1 / 0.3e1 * t58 * t514)
  t804 = t795 / 0.2e1 + t802 / 0.2e1
  t808 = params.gamma * t46
  t809 = t419 ** 2
  t810 = t421 ** 2
  t811 = 0.1e1 / t810
  t819 = 0.35e2 / 0.432e3 * t22 / t25 / t131 * t29 * t40
  t820 = t28 * t48
  t821 = t820 * t66
  t824 = t45 * t29 * t179
  t834 = 0.1e1 / t168 / t167
  t835 = t834 * t170
  t837 = t71 * t835 * t174
  t838 = t358 ** 2
  t839 = t166 ** 2
  t846 = t71 * t171 * t369
  t847 = t846 * t361
  t850 = t71 * t171 * t394
  t852 = t381 * t32 * t183
  t854 = t166 * t64
  t859 = t431 + t434 + t442 - t452 + t495 + t497 - t522 + t525 + t530 + t534 - t537 + t539 - t541
  t860 = t543 + t546 - t548 + t672 - t764 - t766 - t777 - t780 - t782 + t669 + t658 - t662 + t652
  t872 = -(t859 + t860) * t70 * t47 + 0.6e1 * t353 * t355 - 0.12e2 * t164 * t381 * t785 + 0.3e1 * t164 * t179 * t804
  t889 = 0.119e3 / 0.13824e5 * t367 / t172 / t526 * t177 * t179 * t373
  t891 = t71 * t377 * t369
  t892 = t891 * t385
  t897 = t177 / t178 / t19 * t32
  t906 = t819 + 0.7e1 / 0.72e2 * t821 + t824 * t50 * t38 * t785 / 0.16e2 - t49 * t50 * t38 * t804 / 0.48e2 + t837 * t181 * t184 * t838 * t839 / 0.1536e4 + 0.7e1 / 0.2304e4 * t847 + t850 * t852 * t73 * t358 * t854 / 0.384e3 - t176 * t181 * t184 * t872 * t166 / 0.3072e4 - t176 * t181 * t184 * t838 * t166 / 0.3072e4 + t889 + 0.7e1 / 0.576e3 * t892 + 0.5e1 / 0.768e3 * t379 * t897 * t184 * t785 - t379 * t383 * t184 * t804 / 0.768e3
  t912 = 0.1e1 / t407 / t402
  t913 = t70 * t912
  t914 = t416 ** 2
  t918 = t390 * t834
  t919 = t399 * t838
  t940 = t546 - t548 + t672 - t764 - t766 - t777 - t780 - t782 + 0.6e1 * t783 * t784 * t785 + 0.3e1 * t20 * t784 * t804 - t808 * t809 * t811 + t669 + t808 * (params.beta * t906 * t404 - 0.2e1 * t389 * t417 + 0.2e1 * t406 * t913 * t914 - t406 * t409 * (-0.2e1 * t410 * t388 * t358 * t166 - t410 * t399 * t872 * t166 - t410 * t919 * t166 + t390 * t364 * t906 + 0.2e1 * t918 * t919 * t839)) * t422 + t658 - t662 + t652
  t943 = 0.8e1 * t347
  t944 = 0.8e1 * t350
  t945 = 0.2e1 * t342
  t948 = t20 * t784 * t64
  t950 = t808 * t423
  t952 = 0.79531491350053540360627860787761920986947532157324e-1 * t223
  t953 = 0.20727133333333333333333333333333333333333333333334e-1 * t212
  t954 = 0.19380455423088748427520788642112429810098696998902e-2 * t234
  t955 = t278 / 0.12e2
  d11 = t1 * (t544 + t940) + t943 - t944 + t945 + 0.2e1 * t344 + 0.6e1 * t948 + 0.2e1 * t950 + t952 + t953 + t954 - t955 - t288 / 0.12e2 - t299 / 0.12e2
  t958 = -t3 - t53
  t961 = f.my_piecewise3(t6, 0, 0.4e1 / 0.3e1 * t9 * t958)
  t962 = -t958
  t965 = f.my_piecewise3(t13, 0, 0.4e1 / 0.3e1 * t14 * t962)
  t966 = t961 + t965
  t967 = t158 * t966
  t968 = t967 * t161
  t969 = t118 * t966
  t970 = t969 * t137
  t971 = t970 / 0.24e2
  t975 = t128 * (0.4e1 * t291 + 0.4e1 * t294) * t136
  t976 = t125 * t975
  t977 = t976 / 0.24e2
  t981 = f.my_piecewise3(t6, 0, 0.2e1 / 0.3e1 * t51 * t958)
  t984 = f.my_piecewise3(t13, 0, 0.2e1 / 0.3e1 * t58 * t962)
  t986 = t981 / 0.2e1 + t984 / 0.2e1
  t987 = t38 * t986
  t988 = t50 * t987
  t992 = (t213 + t224 + t235 - t279 - t971 - t977 + t342 + t968 - t348 - t351) * t70
  t994 = t179 * t986
  t997 = 0.3e1 * t164 * t994 - t992 * t47
  t1000 = t181 * t184 * t997 * t166
  t1004 = t383 * t184 * t986
  t1007 = -t42 - t49 * t988 / 0.48e2 - t176 * t1000 / 0.3072e4 - t376 - t379 * t1004 / 0.768e3
  t1008 = params.beta * t1007
  t1010 = t399 * t997
  t1015 = t390 * t364 * t1007 - t410 * t1010 * t166
  t1016 = t409 * t1015
  t1018 = t1008 * t404 - t406 * t1016
  t1019 = t1018 * t422
  t1020 = t808 * t1019
  t1028 = f.my_piecewise3(t6, 0, -0.2e1 / 0.9e1 * t789 * t958 * t54 + 0.4e1 / 0.3e1 * t51 * t2 * t502)
  t1036 = f.my_piecewise3(t13, 0, -0.2e1 / 0.9e1 * t796 * t962 * t59 - 0.4e1 / 0.3e1 * t58 * t2 * t502)
  t1038 = t1028 / 0.2e1 + t1036 / 0.2e1
  t1049 = f.my_piecewise3(t6, 0, 0.4e1 / 0.9e1 * t498 * t958 * t54 + 0.8e1 / 0.3e1 * t9 * t2 * t502)
  t1057 = f.my_piecewise3(t13, 0, 0.4e1 / 0.9e1 * t510 * t962 * t59 - 0.8e1 / 0.3e1 * t14 * t2 * t502)
  t1058 = t1049 + t1057
  t1060 = t158 * t1058 * t161
  t1062 = t340 * t966 * t161
  t1063 = t967 * t346
  t1064 = 0.4e1 * t1063
  t1065 = t967 * t349
  t1066 = 0.4e1 * t1065
  t1070 = t784 * t986
  t1074 = 0.4e1 * t538
  t1075 = 0.4e1 * t540
  t1076 = -t808 * t1018 * t811 * t419 + 0.3e1 * t20 * t784 * t1038 + 0.6e1 * t783 * t1070 * t64 + t1060 + t1062 + t1064 - t1066 - t1074 - t1075 + t431 + t434 + t442 - t452 + t495 + t497 + t524 + t530 - t534
  t1077 = t779 / 0.24e2
  t1078 = t781 / 0.24e2
  t1086 = t820 * t988
  t1099 = t179 * t32 * t183
  t1100 = t73 * t997
  t1101 = t839 * t358
  t1106 = t846 * t1000
  t1112 = t431 + t434 + t442 - t452 + t1060 + t1062 + t1064 - t1066 + t495 + t497 + t524 + t530 - t534 - t1074 - t1075
  t1113 = t277 * t975
  t1114 = t1113 / 0.24e2
  t1116 = t287 * t975 / 0.24e2
  t1121 = t125 * t128 * (t768 - t772) * t136 / 0.24e2
  t1123 = t276 * t966 * t137
  t1124 = t1123 / 0.24e2
  t1127 = t118 * t1058 * t137 / 0.24e2
  t1129 = t969 * t298 / 0.24e2
  t1130 = -t548 + t672 - t764 - t1077 - t1078 + t669 + t658 - t662 - t1114 - t1116 - t1121 - t1124 - t1127 - t1129 + t652
  t1145 = -(t1112 + t1130) * t70 * t47 + 0.3e1 * t992 * t355 + 0.3e1 * t353 * t994 - 0.12e2 * t164 * t381 * t986 * t64 + 0.3e1 * t164 * t179 * t1038
  t1162 = t891 * t1004
  t1173 = t819 + 0.7e1 / 0.144e3 * t821 + 0.7e1 / 0.144e3 * t1086 + t824 * t50 * t987 * t64 / 0.16e2 - t49 * t50 * t38 * t1038 / 0.48e2 + t71 * t835 * t394 * t1099 * t1100 * t1101 / 0.1536e4 + 0.7e1 / 0.4608e4 * t1106 + t850 * t852 * t1100 * t854 / 0.768e3 - t176 * t181 * t184 * t1145 * t166 / 0.3072e4 - t850 * t1099 * t1100 * t359 / 0.3072e4 + 0.7e1 / 0.4608e4 * t847 + t889 + 0.7e1 / 0.1152e4 * t892 + t850 * t852 * t73 * t986 * t359 / 0.768e3 + 0.7e1 / 0.1152e4 * t1162 + 0.5e1 / 0.768e3 * t379 * t897 * t184 * t986 * t64 - t379 * t383 * t184 * t1038 / 0.768e3
  t1205 = -t548 + t672 - t764 - t1077 - t1078 + 0.3e1 * t20 * t1019 * t64 + 0.3e1 * t20 * t423 * t986 + t669 + t808 * (params.beta * t1173 * t404 - t1008 * t417 - t389 * t1016 + 0.2e1 * t406 * t70 * t912 * t1015 * t416 - t406 * t409 * (-t410 * t1007 * t358 * t166 - t410 * t399 * t1145 * t166 - t410 * t388 * t997 * t166 + 0.2e1 * t918 * t1010 * t1101 - t410 * t1010 * t359 + t390 * t364 * t1173)) * t422 + t658 - t662 - t1114 - t1116 - t1121 - t1124 - t1127 - t1129 + t652
  t1208 = t20 * t1070
  d12 = -t289 - t300 + t945 + t968 + t953 - t955 - t971 - t977 + t954 + 0.3e1 * t948 + t1020 + t1 * (t1076 + t1205) + t952 + t344 - t944 + t950 + 0.3e1 * t1208
  t1212 = 0.2e1 * t1062
  t1213 = 0.8e1 * t1063
  t1214 = 0.8e1 * t1065
  t1215 = t958 ** 2
  t1219 = 0.2e1 * t52 + 0.2e1 * t503
  t1223 = f.my_piecewise3(t6, 0, 0.4e1 / 0.9e1 * t498 * t1215 + 0.4e1 / 0.3e1 * t9 * t1219)
  t1224 = t962 ** 2
  t1227 = -t1219
  t1231 = f.my_piecewise3(t13, 0, 0.4e1 / 0.9e1 * t510 * t1224 + 0.4e1 / 0.3e1 * t14 * t1227)
  t1232 = t1223 + t1231
  t1234 = t158 * t1232 * t161
  t1239 = t125 * t128 * (-t768 - t770 - t772) * t136 / 0.24e2
  t1242 = t118 * t1232 * t137 / 0.24e2
  t1244 = t969 * t975 / 0.12e2
  t1245 = t986 ** 2
  t1254 = f.my_piecewise3(t6, 0, -0.2e1 / 0.9e1 * t789 * t1215 + 0.2e1 / 0.3e1 * t51 * t1219)
  t1260 = f.my_piecewise3(t13, 0, -0.2e1 / 0.9e1 * t796 * t1224 + 0.2e1 / 0.3e1 * t58 * t1227)
  t1262 = t1254 / 0.2e1 + t1260 / 0.2e1
  t1266 = 0.6e1 * t783 * t784 * t1245 + 0.3e1 * t20 * t784 * t1262 + t1212 - t1213 - t1214 + t1234 - t1239 - t1242 - t1244 + t431 + t434 + t442 - t452 + t495 + t497
  t1270 = t1018 ** 2
  t1273 = t1113 / 0.12e2
  t1274 = t1123 / 0.12e2
  t1284 = t997 ** 2
  t1296 = t431 + t434 + t442 - t452 + t1212 - t1213 - t1214 + t1234 - t1239 - t1242 - t1244 + t495 + t497
  t1297 = t530 + t534 + t537 - t543 - t548 + t672 - t764 + t669 + t658 - t662 - t1273 - t1274 + t652
  t1309 = -(t1296 + t1297) * t70 * t47 + 0.6e1 * t992 * t994 - 0.12e2 * t164 * t381 * t1245 + 0.3e1 * t164 * t179 * t1262
  t1329 = t819 + 0.7e1 / 0.72e2 * t1086 + t824 * t50 * t38 * t1245 / 0.16e2 - t49 * t50 * t38 * t1262 / 0.48e2 + t837 * t181 * t184 * t1284 * t839 / 0.1536e4 + 0.7e1 / 0.2304e4 * t1106 + t850 * t852 * t1100 * t166 * t986 / 0.384e3 - t176 * t181 * t184 * t1309 * t166 / 0.3072e4 - t176 * t181 * t184 * t1284 * t166 / 0.3072e4 + t889 + 0.7e1 / 0.576e3 * t1162 + 0.5e1 / 0.768e3 * t379 * t897 * t184 * t1245 - t379 * t383 * t184 * t1262 / 0.768e3
  t1334 = t1015 ** 2
  t1338 = t399 * t1284
  t1359 = t530 + t534 + t537 - t543 - t548 + t672 - t764 + 0.6e1 * t20 * t1019 * t986 - t808 * t1270 * t811 + t669 + t658 - t662 - t1273 - t1274 + t652 + t808 * (params.beta * t1329 * t404 - 0.2e1 * t1008 * t1016 + 0.2e1 * t406 * t913 * t1334 - t406 * t409 * (-0.2e1 * t410 * t1007 * t997 * t166 - t410 * t399 * t1309 * t166 + t390 * t364 * t1329 - t410 * t1338 * t166 + 0.2e1 * t918 * t1338 * t839)) * t422
  d22 = t954 - t970 / 0.12e2 - t976 / 0.12e2 + t1 * (t1266 + t1359) + 0.2e1 * t1020 + t952 + t953 - t955 + 0.6e1 * t1208 + t945 + 0.2e1 * t968 - t943 - t944
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

