"""Generated from gga_c_wl.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  a = -0.7486

  b = 0.06001

  c = 3.60073

  d = 0.9

  f_num = lambda z, xt: jnp.sqrt(1 - z ** 2) * (a + b * xt)

  f_den = lambda rs, xs0, xs1: c + d * (xs0 + xs1) + rs

  functional_body = lambda rs, zeta, xt, xs0, xs1: f_num(zeta, xt) / f_den(rs, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  a = -0.7486

  b = 0.06001

  c = 3.60073

  d = 0.9

  f_num = lambda z, xt: jnp.sqrt(1 - z ** 2) * (a + b * xt)

  f_den = lambda rs, xs0, xs1: c + d * (xs0 + xs1) + rs

  functional_body = lambda rs, zeta, xt, xs0, xs1: f_num(zeta, xt) / f_den(rs, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  a = -0.7486

  b = 0.06001

  c = 3.60073

  d = 0.9

  f_num = lambda z, xt: jnp.sqrt(1 - z ** 2) * (a + b * xt)

  f_den = lambda rs, xs0, xs1: c + d * (xs0 + xs1) + rs

  functional_body = lambda rs, zeta, xt, xs0, xs1: f_num(zeta, xt) / f_den(rs, xs0, xs1)

  t1 = r0 - r1
  t2 = t1 ** 2
  t3 = r0 + r1
  t4 = t3 ** 2
  t5 = 0.1e1 / t4
  t8 = jnp.sqrt(-t2 * t5 + 0.1e1)
  t11 = jnp.sqrt(s0 + 0.2e1 * s1 + s2)
  t12 = t3 ** (0.1e1 / 0.3e1)
  t14 = 0.1e1 / t12 / t3
  t17 = -0.74860e0 + 0.6001e-1 * t11 * t14
  t19 = jnp.sqrt(s0)
  t20 = r0 ** (0.1e1 / 0.3e1)
  t22 = 0.1e1 / t20 / r0
  t25 = jnp.sqrt(s2)
  t26 = r1 ** (0.1e1 / 0.3e1)
  t28 = 0.1e1 / t26 / r1
  t31 = 3 ** (0.1e1 / 0.3e1)
  t33 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t34 = t31 * t33
  t35 = 4 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t37 = 0.1e1 / t12
  t41 = 0.360073e1 + 0.90000e0 * t19 * t22 + 0.90000e0 * t25 * t28 + t34 * t36 * t37 / 0.4e1
  t42 = 0.1e1 / t41
  t43 = t8 * t17 * t42
  t45 = t3 / t8
  t46 = t17 * t42
  t47 = t1 * t5
  t50 = t2 / t4 / t3
  t59 = 0.80013333333333333333333333333333333333333333333333e-1 * t14 * t8 * t11 * t42
  t60 = t3 * t8
  t61 = t41 ** 2
  t62 = 0.1e1 / t61
  t63 = t17 * t62
  t64 = r0 ** 2
  t71 = t34 * t36 * t14 / 0.12e2
  vrho_0_ = t43 + t45 * t46 * (-0.2e1 * t47 + 0.2e1 * t50) / 0.2e1 - t59 - t60 * t63 * (-0.12000000000000000000000000000000000000000000000000e1 * t19 / t20 / t64 - t71)
  t80 = r1 ** 2
  vrho_1_ = t43 + t45 * t46 * (0.2e1 * t47 + 0.2e1 * t50) / 0.2e1 - t59 - t60 * t63 * (-0.12000000000000000000000000000000000000000000000000e1 * t25 / t26 / t80 - t71)
  t91 = t37 * t8 / t11 * t42
  t92 = 0.30005000000000000000000000000000000000000000000000e-1 * t91
  t93 = t60 * t17
  vsigma_0_ = t92 - 0.45000000000000000000000000000000000000000000000000e0 * t93 * t62 / t19 * t22
  vsigma_1_ = 0.6001e-1 * t91
  vsigma_2_ = t92 - 0.45000000000000000000000000000000000000000000000000e0 * t93 * t62 / t25 * t28
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  a = -0.7486

  b = 0.06001

  c = 3.60073

  d = 0.9

  f_num = lambda z, xt: jnp.sqrt(1 - z ** 2) * (a + b * xt)

  f_den = lambda rs, xs0, xs1: c + d * (xs0 + xs1) + rs

  functional_body = lambda rs, zeta, xt, xs0, xs1: f_num(zeta, xt) / f_den(rs, xs0, xs1)

  t1 = jnp.sqrt(s0)
  t2 = r0 ** (0.1e1 / 0.3e1)
  t4 = 0.1e1 / t2 / r0
  t5 = t1 * t4
  t7 = -0.74860e0 + 0.6001e-1 * t5
  t8 = 2 ** (0.1e1 / 0.3e1)
  t9 = t1 * t8
  t12 = 3 ** (0.1e1 / 0.3e1)
  t14 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t15 = t12 * t14
  t16 = 4 ** (0.1e1 / 0.3e1)
  t17 = t16 ** 2
  t18 = 0.1e1 / t2
  t22 = 0.360073e1 + 0.180000e1 * t9 * t4 + t15 * t17 * t18 / 0.4e1
  t23 = 0.1e1 / t22
  t28 = t22 ** 2
  t29 = 0.1e1 / t28
  t30 = r0 ** 2
  vrho_0_ = t7 * t23 - 0.80013333333333333333333333333333333333333333333333e-1 * t5 * t23 - r0 * t7 * t29 * (-0.24000000000000000000000000000000000000000000000000e1 * t9 / t2 / t30 - t15 * t17 * t4 / 0.12e2)
  t41 = 0.1e1 / t1
  vsigma_0_ = 0.30005000000000000000000000000000000000000000000000e-1 * t18 * t41 * t23 - 0.90000000000000000000000000000000000000000000000000e0 * t18 * t7 * t29 * t41 * t8
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = jnp.sqrt(s0)
  t2 = r0 ** 2
  t3 = r0 ** (0.1e1 / 0.3e1)
  t5 = 0.1e1 / t3 / t2
  t7 = 2 ** (0.1e1 / 0.3e1)
  t8 = t1 * t7
  t10 = 0.1e1 / t3 / r0
  t13 = 3 ** (0.1e1 / 0.3e1)
  t15 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t16 = t13 * t15
  t17 = 4 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t19 = 0.1e1 / t3
  t23 = 0.360073e1 + 0.180000e1 * t8 * t10 + t16 * t18 * t19 / 0.4e1
  t24 = 0.1e1 / t23
  t27 = t1 * t10
  t29 = -0.74860e0 + 0.6001e-1 * t27
  t30 = t23 ** 2
  t31 = 0.1e1 / t30
  t38 = -0.24000000000000000000000000000000000000000000000000e1 * t8 * t5 - t16 * t18 * t10 / 0.12e2
  t41 = t31 * t38
  t44 = r0 * t29
  t46 = 0.1e1 / t30 / t23
  t47 = t38 ** 2
  v2rho2_0_ = 0.26671111111111111111111111111111111111111111111107e-1 * t1 * t5 * t24 - 0.2e1 * t29 * t31 * t38 + 0.16002666666666666666666666666666666666666666666667e0 * t27 * t41 + 0.2e1 * t44 * t46 * t47 - t44 * t31 * (0.56000000000000000000000000000000000000000000000000e1 * t8 / t3 / t2 / r0 + t16 * t18 * t5 / 0.9e1)
  t62 = 0.1e1 / t1
  t74 = t3 ** 2
  t80 = t19 * t29
  v2rhosigma_0_ = -0.10001666666666666666666666666666666666666666666667e-1 * t10 * t62 * t24 - 0.30005000000000000000000000000000000000000000000000e-1 * t19 * t62 * t41 + 0.30000000000000000000000000000000000000000000000000e0 * t10 * t29 * t31 * t62 * t7 + 0.72012000000000000000000000000000000000000000000000e-1 / t74 / t2 * t31 * t7 + 0.18000000000000000000000000000000000000000000000000e1 * t80 * t46 * t62 * t7 * t38
  t87 = 0.1e1 / t1 / s0
  t92 = 0.1e1 / t74 / r0
  t93 = 0.1e1 / s0
  t100 = t7 ** 2
  v2sigma2_0_ = -0.15002500000000000000000000000000000000000000000000e-1 * t19 * t87 * t24 - 0.54009000000000000000000000000000000000000000000000e-1 * t92 * t93 * t31 * t7 + 0.16200000000000000000000000000000000000000000000000e1 * t92 * t29 * t46 * t93 * t100 + 0.45000000000000000000000000000000000000000000000000e0 * t80 * t31 * t87 * t7
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = jnp.sqrt(s0)
  t2 = r0 ** 2
  t4 = r0 ** (0.1e1 / 0.3e1)
  t6 = 0.1e1 / t4 / t2 / r0
  t8 = 2 ** (0.1e1 / 0.3e1)
  t9 = t1 * t8
  t11 = 0.1e1 / t4 / r0
  t14 = 3 ** (0.1e1 / 0.3e1)
  t16 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t17 = t14 * t16
  t18 = 4 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t24 = 0.360073e1 + 0.180000e1 * t9 * t11 + t17 * t19 / t4 / 0.4e1
  t29 = 0.1e1 / t4 / t2
  t31 = t24 ** 2
  t32 = 0.1e1 / t31
  t38 = -0.24000000000000000000000000000000000000000000000000e1 * t9 * t29 - t17 * t19 * t11 / 0.12e2
  t42 = t1 * t11
  t44 = -0.74860e0 + 0.6001e-1 * t42
  t46 = 0.1e1 / t31 / t24
  t48 = t38 ** 2
  t57 = 0.56000000000000000000000000000000000000000000000000e1 * t9 * t6 + t17 * t19 * t29 / 0.9e1
  t66 = r0 * t44
  t67 = t31 ** 2
  t77 = t2 ** 2
  v3rho3_0_ = -0.62232592592592592592592592592592592592592592592583e-1 * t1 * t6 / t24 - 0.8001333333333333333333333333333333333333333333333e-1 * t1 * t29 * t32 * t38 + 0.6e1 * t44 * t46 * t48 - 0.3e1 * t44 * t32 * t57 - 0.48008000000000000000000000000000000000000000000001e0 * t42 * t46 * t48 + 0.24004000000000000000000000000000000000000000000000e0 * t42 * t32 * t57 - 0.6e1 * t66 / t67 * t48 * t38 + 0.6e1 * t66 * t46 * t38 * t57 - t66 * t32 * (-0.18666666666666666666666666666666666666666666666667e2 * t9 / t4 / t77 - 0.7e1 / 0.27e2 * t17 * t19 * t6)

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = jnp.sqrt(s0)
  t2 = r0 ** 2
  t3 = r0 ** (0.1e1 / 0.3e1)
  t5 = 0.1e1 / t3 / t2
  t6 = t1 * t5
  t7 = 2 ** (0.1e1 / 0.3e1)
  t8 = t1 * t7
  t10 = 0.1e1 / t3 / r0
  t13 = 3 ** (0.1e1 / 0.3e1)
  t15 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t16 = t13 * t15
  t17 = 4 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t23 = 0.360073e1 + 0.180000e1 * t8 * t10 + t16 * t18 / t3 / 0.4e1
  t24 = t23 ** 2
  t26 = 0.1e1 / t24 / t23
  t32 = -0.24000000000000000000000000000000000000000000000000e1 * t8 * t5 - t16 * t18 * t10 / 0.12e2
  t33 = t32 ** 2
  t37 = t1 * t10
  t38 = t24 ** 2
  t39 = 0.1e1 / t38
  t40 = t33 * t32
  t44 = t26 * t32
  t47 = 0.1e1 / t3 / t2 / r0
  t53 = 0.56000000000000000000000000000000000000000000000000e1 * t8 * t47 + t16 * t18 * t5 / 0.9e1
  t58 = -0.74860e0 + 0.6001e-1 * t37
  t59 = r0 * t58
  t62 = t33 ** 2
  t70 = t53 ** 2
  t74 = t2 ** 2
  t76 = 0.1e1 / t3 / t74
  t82 = -0.18666666666666666666666666666666666666666666666667e2 * t8 * t76 - 0.7e1 / 0.27e2 * t16 * t18 * t47
  t91 = 0.1e1 / t24
  v4rho4_0_ = 0.32005333333333333333333333333333333333333333333334e0 * t6 * t26 * t33 + 0.19203200000000000000000000000000000000000000000000e1 * t37 * t39 * t40 - 0.19203200000000000000000000000000000000000000000000e1 * t37 * t44 * t53 + 0.24e2 * t59 / t38 / t23 * t62 - 0.36e2 * t59 * t39 * t33 * t53 + 0.6e1 * t59 * t26 * t70 + 0.8e1 * t59 * t44 * t82 + 0.20744197530864197530864197530864197530864197530861e0 * t1 * t76 / t23 + 0.24893037037037037037037037037037037037037037037035e0 * t1 * t47 * t91 * t32 - 0.16002666666666666666666666666666666666666666666666e0 * t6 * t91 * t53 - 0.24e2 * t58 * t39 * t40 + 0.24e2 * t58 * t26 * t32 * t53 + 0.32005333333333333333333333333333333333333333333333e0 * t37 * t91 * t82 - t59 * t91 * (0.80888888888888888888888888888888888888888888888890e2 * t8 / t3 / t74 / r0 + 0.70e2 / 0.81e2 * t16 * t18 * t76) - 0.4e1 * t58 * t91 * t82

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 - r1
  t2 = t1 ** 2
  t3 = r0 + r1
  t4 = t3 ** 2
  t5 = 0.1e1 / t4
  t7 = -t2 * t5 + 0.1e1
  t8 = jnp.sqrt(t7)
  t9 = 0.1e1 / t8
  t12 = jnp.sqrt(s0 + 0.2e1 * s1 + s2)
  t13 = t3 ** (0.1e1 / 0.3e1)
  t15 = 0.1e1 / t13 / t3
  t18 = -0.74860e0 + 0.6001e-1 * t12 * t15
  t19 = t9 * t18
  t20 = jnp.sqrt(s0)
  t21 = r0 ** (0.1e1 / 0.3e1)
  t26 = jnp.sqrt(s2)
  t27 = r1 ** (0.1e1 / 0.3e1)
  t32 = 3 ** (0.1e1 / 0.3e1)
  t34 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t35 = t32 * t34
  t36 = 4 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t42 = 0.360073e1 + 0.90000e0 * t20 / t21 / r0 + 0.90000e0 * t26 / t27 / r1 + t35 * t37 / t13 / 0.4e1
  t43 = 0.1e1 / t42
  t44 = t1 * t5
  t46 = 0.1e1 / t4 / t3
  t47 = t2 * t46
  t49 = -0.2e1 * t44 + 0.2e1 * t47
  t51 = t19 * t43 * t49
  t54 = 0.1e1 / t13 / t4
  t57 = 0.26671111111111111111111111111111111111111111111107e-1 * t8 * t12 * t54 * t43
  t58 = t8 * t18
  t59 = t42 ** 2
  t60 = 0.1e1 / t59
  t61 = r0 ** 2
  t68 = t35 * t37 * t15 / 0.12e2
  t69 = -0.12000000000000000000000000000000000000000000000000e1 * t20 / t21 / t61 - t68
  t71 = t58 * t60 * t69
  t75 = t3 / t8 / t7
  t76 = t18 * t43
  t77 = t49 ** 2
  t81 = t15 * t9
  t82 = t12 * t43
  t84 = t81 * t82 * t49
  t86 = t3 * t9
  t87 = t86 * t18
  t91 = 0.2e1 * t5
  t93 = 0.8e1 * t1 * t46
  t94 = t4 ** 2
  t97 = 0.6e1 * t2 / t94
  t102 = t15 * t8
  t103 = t12 * t60
  t105 = t102 * t103 * t69
  t107 = t3 * t8
  t109 = 0.1e1 / t59 / t42
  t110 = t18 * t109
  t111 = t69 ** 2
  t115 = t18 * t60
  t123 = t35 * t37 * t54 / 0.9e1
  d11 = t51 + t57 - 0.2e1 * t71 - t75 * t76 * t77 / 0.4e1 - 0.80013333333333333333333333333333333333333333333332e-1 * t84 - t87 * t60 * t49 * t69 + t86 * t76 * (-t91 + t93 - t97) / 0.2e1 + 0.16002666666666666666666666666666666666666666666667e0 * t105 + 0.2e1 * t107 * t110 * t111 - t107 * t115 * (0.28000000000000000000000000000000000000000000000000e1 * t20 / t21 / t61 / r0 + t123)
  t129 = 0.2e1 * t44 + 0.2e1 * t47
  t130 = t43 * t129
  t131 = t19 * t130
  t138 = t81 * t82 * t129
  t140 = t60 * t129
  t150 = r1 ** 2
  t155 = -0.12000000000000000000000000000000000000000000000000e1 * t26 / t27 / t150 - t68
  t156 = t60 * t155
  t157 = t58 * t156
  t162 = t102 * t103 * t155
  d12 = t51 / 0.2e1 + t57 - t71 + t131 / 0.2e1 - t75 * t18 * t130 * t49 / 0.4e1 - 0.40006666666666666666666666666666666666666666666666e-1 * t138 - t87 * t140 * t69 / 0.2e1 + t86 * t76 * (t91 - t97) / 0.2e1 - 0.40006666666666666666666666666666666666666666666666e-1 * t84 + 0.80013333333333333333333333333333333333333333333333e-1 * t105 - t157 - t87 * t156 * t49 / 0.2e1 + 0.80013333333333333333333333333333333333333333333333e-1 * t162 + 0.2e1 * t107 * t18 * t109 * t155 * t69 - t102 * t18 * t60 * t32 * t34 * t37 / 0.9e1
  t176 = t129 ** 2
  t188 = t155 ** 2
  d22 = t131 + t57 - 0.2e1 * t157 - t75 * t76 * t176 / 0.4e1 - 0.80013333333333333333333333333333333333333333333332e-1 * t138 - t87 * t140 * t155 + t86 * t76 * (-t91 - t93 - t97) / 0.2e1 + 0.16002666666666666666666666666666666666666666666667e0 * t162 + 0.2e1 * t107 * t110 * t188 - t107 * t115 * (0.28000000000000000000000000000000000000000000000000e1 * t26 / t27 / t150 / r1 + t123)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 + r1
  t2 = r0 - r1
  t3 = t2 ** 2
  t4 = t1 ** 2
  t5 = 0.1e1 / t4
  t7 = -t3 * t5 + 0.1e1
  t8 = jnp.sqrt(t7)
  t9 = 0.1e1 / t8
  t10 = t1 * t9
  t13 = jnp.sqrt(s0 + 0.2e1 * s1 + s2)
  t14 = t1 ** (0.1e1 / 0.3e1)
  t16 = 0.1e1 / t14 / t1
  t19 = -0.74860e0 + 0.6001e-1 * t13 * t16
  t20 = t10 * t19
  t21 = jnp.sqrt(s0)
  t22 = r0 ** (0.1e1 / 0.3e1)
  t27 = jnp.sqrt(s2)
  t28 = r1 ** (0.1e1 / 0.3e1)
  t33 = 3 ** (0.1e1 / 0.3e1)
  t35 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t36 = t33 * t35
  t37 = 4 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t43 = 0.360073e1 + 0.90000e0 * t21 / t22 / r0 + 0.90000e0 * t27 / t28 / r1 + t36 * t38 / t14 / 0.4e1
  t44 = t43 ** 2
  t46 = 0.1e1 / t44 / t43
  t48 = t4 * t1
  t49 = 0.1e1 / t48
  t52 = -0.2e1 * t2 * t5 + 0.2e1 * t3 * t49
  t54 = r0 ** 2
  t62 = -0.12000000000000000000000000000000000000000000000000e1 * t21 / t22 / t54 - t36 * t38 * t16 / 0.12e2
  t63 = t62 ** 2
  t68 = 0.1e1 / t8 / t7
  t70 = 0.1e1 / t43
  t71 = t52 ** 2
  t75 = t9 * t19
  t76 = 0.1e1 / t44
  t77 = t76 * t52
  t78 = t77 * t62
  t83 = 0.1e1 / t14 / t4
  t88 = t8 * t13
  t90 = 0.1e1 / t14 / t48
  t98 = t8 * t19
  t103 = t13 * t70
  t107 = t16 * t9
  t111 = t4 ** 2
  t112 = 0.1e1 / t111
  t115 = -0.6e1 * t3 * t112 + 0.8e1 * t2 * t49 - 0.2e1 * t5
  t119 = t19 * t70
  t131 = t16 * t8
  t141 = 0.28000000000000000000000000000000000000000000000000e1 * t21 / t22 / t54 / r0 + t36 * t38 * t83 / 0.9e1
  t145 = 0.3e1 * t20 * t46 * t52 * t63 - 0.3e1 / 0.4e1 * t68 * t19 * t70 * t71 - 0.3e1 * t75 * t78 + 0.40006666666666666666666666666666666666666666666661e-1 * t9 * t13 * t83 * t70 * t52 - 0.62232592592592592592592592592592592592592592592583e-1 * t88 * t90 * t70 - 0.8001333333333333333333333333333333333333333333333e-1 * t88 * t83 * t76 * t62 + 0.6e1 * t98 * t46 * t63 + 0.60009999999999999999999999999999999999999999999999e-1 * t16 * t68 * t103 * t71 - 0.12002000000000000000000000000000000000000000000000e0 * t107 * t103 * t115 + t10 * t119 * (0.12e2 * t49 - 0.36e2 * t2 * t112 + 0.24e2 * t3 / t111 / t1) / 0.2e1 + 0.24004000000000000000000000000000000000000000000000e0 * t131 * t13 * t76 * t141
  t146 = t1 * t8
  t148 = t54 ** 2
  t165 = t7 ** 2
  t174 = t1 * t68 * t19
  t197 = t44 ** 2
  t209 = -t146 * t19 * t76 * (-0.93333333333333333333333333333333333333333333333333e1 * t21 / t22 / t148 - 0.7e1 / 0.27e2 * t36 * t38 * t90) + 0.3e1 / 0.2e1 * t75 * t70 * t115 - 0.3e1 * t98 * t76 * t141 + 0.3e1 / 0.8e1 * t1 / t8 / t165 * t119 * t71 * t52 + 0.3e1 / 0.4e1 * t174 * t76 * t71 * t62 - 0.3e1 / 0.4e1 * t174 * t70 * t52 * t115 + 0.24004000000000000000000000000000000000000000000000e0 * t107 * t13 * t78 - 0.3e1 / 0.2e1 * t20 * t76 * t115 * t62 - 0.3e1 / 0.2e1 * t20 * t77 * t141 - 0.48008000000000000000000000000000000000000000000001e0 * t131 * t13 * t46 * t63 - 0.6e1 * t146 * t19 / t197 * t63 * t62 + 0.6e1 * t146 * t19 * t46 * t62 * t141
  d111 = t145 + t209

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 - r1
  t2 = t1 ** 2
  t3 = r0 + r1
  t4 = t3 ** 2
  t5 = 0.1e1 / t4
  t7 = -t2 * t5 + 0.1e1
  t8 = jnp.sqrt(t7)
  t11 = jnp.sqrt(s0 + 0.2e1 * s1 + s2)
  t12 = t3 ** (0.1e1 / 0.3e1)
  t14 = 0.1e1 / t12 / t3
  t17 = -0.74860e0 + 0.6001e-1 * t11 * t14
  t18 = t8 * t17
  t19 = jnp.sqrt(s0)
  t20 = r0 ** (0.1e1 / 0.3e1)
  t25 = jnp.sqrt(s2)
  t26 = r1 ** (0.1e1 / 0.3e1)
  t31 = 3 ** (0.1e1 / 0.3e1)
  t33 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t34 = t31 * t33
  t35 = 4 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t41 = 0.360073e1 + 0.90000e0 * t19 / t20 / r0 + 0.90000e0 * t25 / t26 / r1 + t34 * t36 / t12 / 0.4e1
  t42 = t41 ** 2
  t43 = 0.1e1 / t42
  t44 = r0 ** 2
  t45 = t44 ** 2
  t50 = t4 * t3
  t52 = 0.1e1 / t12 / t50
  t56 = -0.93333333333333333333333333333333333333333333333333e1 * t19 / t20 / t45 - 0.7e1 / 0.27e2 * t34 * t36 * t52
  t57 = t43 * t56
  t60 = t42 ** 2
  t61 = 0.1e1 / t60
  t69 = -0.12000000000000000000000000000000000000000000000000e1 * t19 / t20 / t44 - t34 * t36 * t14 / 0.12e2
  t70 = t69 ** 2
  t71 = t70 * t69
  t75 = 0.1e1 / t8
  t76 = t75 * t17
  t77 = 0.1e1 / t41
  t78 = 0.1e1 / t50
  t80 = t4 ** 2
  t81 = 0.1e1 / t80
  t85 = 0.1e1 / t80 / t3
  t88 = -0.36e2 * t1 * t81 + 0.24e2 * t2 * t85 + 0.12e2 * t78
  t89 = t77 * t88
  t92 = t7 ** 2
  t94 = 0.1e1 / t8 / t92
  t99 = -0.2e1 * t1 * t5 + 0.2e1 * t2 * t78
  t100 = t99 ** 2
  t101 = t100 * t99
  t105 = t8 * t11
  t107 = 0.1e1 / t12 / t80
  t116 = 0.1e1 / t42 / t41
  t117 = t116 * t99
  t118 = t117 * t70
  t125 = t17 * t77
  t126 = t100 ** 2
  t131 = 0.1e1 / t8 / t7
  t132 = t3 * t131
  t138 = 0.8e1 * t1 * t78 - 0.6e1 * t2 * t81 - 0.2e1 * t5
  t139 = t138 ** 2
  t143 = t14 * t8
  t148 = t3 * t8
  t152 = t70 ** 2
  t163 = 0.1e1 / t12 / t4
  t167 = 0.28000000000000000000000000000000000000000000000000e1 * t19 / t20 / t44 / r0 + t34 * t36 * t163 / 0.9e1
  t168 = t167 ** 2
  t172 = -0.4e1 * t18 * t57 - 0.24e2 * t18 * t61 * t71 + 0.2e1 * t76 * t89 + 0.3e1 / 0.2e1 * t94 * t17 * t77 * t101 + 0.20744197530864197530864197530864197530864197530861e0 * t105 * t107 * t77 + 0.24893037037037037037037037037037037037037037037035e0 * t105 * t52 * t43 * t69 + 0.12e2 * t76 * t118 - 0.15e2 / 0.16e2 * t3 / t8 / t92 / t7 * t125 * t126 - 0.3e1 / 0.4e1 * t132 * t125 * t139 + 0.19203200000000000000000000000000000000000000000000e1 * t143 * t11 * t61 * t71 + 0.24e2 * t148 * t17 / t60 / t41 * t152 + 0.6e1 * t148 * t17 * t116 * t168
  t194 = t116 * t69 * t167
  t197 = t14 * t75
  t198 = t11 * t77
  t202 = t3 * t75
  t214 = t131 * t17
  t215 = t43 * t100
  t216 = t215 * t69
  t220 = t77 * t99 * t138
  t224 = t163 * t77
  t228 = t43 * t138
  t229 = t228 * t69
  t232 = t43 * t99
  t233 = t232 * t167
  t236 = t75 * t11
  t240 = 0.32005333333333333333333333333333333333333333333333e0 * t143 * t11 * t43 * t56 - t148 * t17 * t43 * (0.40444444444444444444444444444444444444444444444444e2 * t19 / t20 / t45 / r0 + 0.70e2 / 0.81e2 * t34 * t36 * t107) - 0.16002666666666666666666666666666666666666666666666e0 * t105 * t163 * t43 * t167 + 0.24e2 * t18 * t194 - 0.16002666666666666666666666666666666666666666666667e0 * t197 * t198 * t88 + t202 * t125 * (-0.72e2 * t81 + 0.192e3 * t1 * t85 - 0.120e3 * t2 / t80 / t4) / 0.2e1 + 0.3e1 * t214 * t216 - 0.3e1 * t214 * t220 - 0.40006666666666666666666666666666666666666666666662e-1 * t131 * t11 * t224 * t100 - 0.6e1 * t76 * t229 - 0.6e1 * t76 * t233 + 0.8001333333333333333333333333333333333333333333333e-1 * t236 * t224 * t138
  t254 = t132 * t17
  t259 = t202 * t17
  t276 = t197 * t11
  t284 = t14 * t131 * t11
  t289 = -0.12446518518518518518518518518518518518518518518517e0 * t236 * t52 * t77 * t99 + 0.32005333333333333333333333333333333333333333333334e0 * t105 * t163 * t116 * t70 - 0.12002000000000000000000000000000000000000000000000e0 * t14 * t94 * t198 * t101 + 0.3e1 * t254 * t232 * t69 * t138 + 0.12e2 * t259 * t117 * t69 * t167 - 0.3e1 * t254 * t116 * t100 * t70 - 0.12e2 * t259 * t61 * t99 * t71 + 0.6e1 * t259 * t116 * t138 * t70 - 0.96016000000000000000000000000000000000000000000000e0 * t276 * t118 - 0.16002666666666666666666666666666666666666666666665e0 * t236 * t163 * t232 * t69 - 0.24004000000000000000000000000000000000000000000000e0 * t284 * t216 + 0.24004000000000000000000000000000000000000000000000e0 * t284 * t220
  t306 = t148 * t17
  t312 = t3 * t94 * t17
  t331 = 0.48008000000000000000000000000000000000000000000000e0 * t276 * t229 - t254 * t89 * t99 - 0.2e1 * t259 * t43 * t88 * t69 + 0.48008000000000000000000000000000000000000000000000e0 * t276 * t233 - 0.19203200000000000000000000000000000000000000000000e1 * t143 * t11 * t194 - 0.2e1 * t259 * t57 * t99 + 0.8e1 * t306 * t116 * t56 * t69 - 0.3e1 / 0.2e1 * t312 * t43 * t101 * t69 + 0.9e1 / 0.4e1 * t312 * t77 * t100 * t138 + 0.3e1 / 0.2e1 * t254 * t215 * t167 - 0.3e1 * t259 * t228 * t167 - 0.36e2 * t306 * t61 * t70 * t167
  d1111 = t172 + t240 + t289 + t331

  res = {'v4rho4': d1111}
  return res
