"""Generated from gga_x_lv_rpw86.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_aa = 15 * 0.1234

  params_bb = 17.33

  params_cc = 0.163

  lv_alpha = 0.02178

  lv_beta = 1.15

  lv_muLV = 0.8491 / 9

  pw86_f0 = lambda s: (1 + params_aa * s ** 2 + params_bb * s ** 4 + params_cc * s ** 6) ** (1 / 15)

  lv_f0 = lambda s: +(1 + lv_muLV * s ** 2) / (1 + lv_alpha * s ** 6) + lv_alpha * s ** 6 * pw86_f0(s) / (lv_beta + lv_alpha * s ** 6)

  lv_f = lambda x: lv_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, lv_f, rs, z, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_aa = 15 * 0.1234

  params_bb = 17.33

  params_cc = 0.163

  lv_alpha = 0.02178

  lv_beta = 1.15

  lv_muLV = 0.8491 / 9

  pw86_f0 = lambda s: (1 + params_aa * s ** 2 + params_bb * s ** 4 + params_cc * s ** 6) ** (1 / 15)

  lv_f0 = lambda s: +(1 + lv_muLV * s ** 2) / (1 + lv_alpha * s ** 6) + lv_alpha * s ** 6 * pw86_f0(s) / (lv_beta + lv_alpha * s ** 6)

  lv_f = lambda x: lv_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, lv_f, rs, z, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_aa = 15 * 0.1234

  params_bb = 17.33

  params_cc = 0.163

  lv_alpha = 0.02178

  lv_beta = 1.15

  lv_muLV = 0.8491 / 9

  pw86_f0 = lambda s: (1 + params_aa * s ** 2 + params_bb * s ** 4 + params_cc * s ** 6) ** (1 / 15)

  lv_f0 = lambda s: +(1 + lv_muLV * s ** 2) / (1 + lv_alpha * s ** 6) + lv_alpha * s ** 6 * pw86_f0(s) / (lv_beta + lv_alpha * s ** 6)

  lv_f = lambda x: lv_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, lv_f, rs, z, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = jnp.pi ** 2
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t33 = t28 / t31
  t34 = r0 ** 2
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / t34
  t40 = t33 * s0 * t38
  t42 = 0.1e1 + 0.39310185185185185185185185185185185185185185185185e-2 * t40
  t43 = t29 ** 2
  t44 = 0.1e1 / t43
  t45 = s0 ** 2
  t47 = t44 * t45 * s0
  t48 = t34 ** 2
  t49 = t48 ** 2
  t50 = 0.1e1 / t49
  t51 = t47 * t50
  t52 = 0.94531250000000000000000000000000000000000000000000e-5 * t51
  t53 = 0.1e1 + t52
  t54 = 0.1e1 / t53
  t57 = t28 ** 2
  t60 = t57 / t30 / t29
  t63 = 0.1e1 / t35 / t48 / r0
  t69 = (0.1e1 + 0.77125000000000000000000000000000000000000000000000e-1 * t40 + 0.30086805555555555555555555555555555555555555555556e-1 * t60 * t45 * t63 + 0.70746527777777777777777777777777777777777777777778e-4 * t51) ** (0.1e1 / 0.15e2)
  t71 = 0.115e1 + t52
  t72 = 0.1e1 / t71
  t73 = t50 * t69 * t72
  t76 = t42 * t54 + 0.94531250000000000000000000000000000000000000000000e-5 * t47 * t73
  t80 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t76)
  t81 = r1 <= f.p.dens_threshold
  t82 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t83 = 0.1e1 + t82
  t84 = t83 <= f.p.zeta_threshold
  t85 = t83 ** (0.1e1 / 0.3e1)
  t87 = f.my_piecewise3(t84, t22, t85 * t83)
  t88 = t87 * t26
  t89 = r1 ** 2
  t90 = r1 ** (0.1e1 / 0.3e1)
  t91 = t90 ** 2
  t93 = 0.1e1 / t91 / t89
  t95 = t33 * s2 * t93
  t97 = 0.1e1 + 0.39310185185185185185185185185185185185185185185185e-2 * t95
  t98 = s2 ** 2
  t100 = t44 * t98 * s2
  t101 = t89 ** 2
  t102 = t101 ** 2
  t103 = 0.1e1 / t102
  t104 = t100 * t103
  t105 = 0.94531250000000000000000000000000000000000000000000e-5 * t104
  t106 = 0.1e1 + t105
  t107 = 0.1e1 / t106
  t112 = 0.1e1 / t90 / t101 / r1
  t118 = (0.1e1 + 0.77125000000000000000000000000000000000000000000000e-1 * t95 + 0.30086805555555555555555555555555555555555555555556e-1 * t60 * t98 * t112 + 0.70746527777777777777777777777777777777777777777778e-4 * t104) ** (0.1e1 / 0.15e2)
  t120 = 0.115e1 + t105
  t121 = 0.1e1 / t120
  t122 = t103 * t118 * t121
  t125 = t97 * t107 + 0.94531250000000000000000000000000000000000000000000e-5 * t100 * t122
  t129 = f.my_piecewise3(t81, 0, -0.3e1 / 0.8e1 * t5 * t88 * t125)
  t130 = t6 ** 2
  t132 = t16 / t130
  t133 = t7 - t132
  t134 = f.my_piecewise5(t10, 0, t14, 0, t133)
  t137 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t134)
  t142 = t26 ** 2
  t143 = 0.1e1 / t142
  t147 = t5 * t25 * t143 * t76 / 0.8e1
  t151 = s0 / t36 / t34 / r0
  t155 = t53 ** 2
  t157 = t42 / t155
  t159 = 0.1e1 / t49 / r0
  t160 = t47 * t159
  t167 = t69 ** 2
  t168 = t167 ** 2
  t170 = t168 ** 2
  t173 = 0.1e1 / t170 / t168 / t167 * t72
  t187 = t43 ** 2
  t188 = 0.1e1 / t187
  t189 = t45 ** 2
  t192 = t49 ** 2
  t196 = t71 ** 2
  t197 = 0.1e1 / t196
  t206 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t137 * t26 * t76 - t147 - 0.3e1 / 0.8e1 * t5 * t27 * (-0.10482716049382716049382716049382716049382716049383e-1 * t33 * t151 * t54 + 0.75625000000000000000000000000000000000000000000000e-4 * t157 * t160 - 0.75625000000000000000000000000000000000000000000000e-4 * t47 * t159 * t69 * t72 + 0.63020833333333333333333333333333333333333333333333e-6 * t51 * t173 * (-0.20566666666666666666666666666666666666666666666667e0 * t33 * t151 - 0.16046296296296296296296296296296296296296296296297e0 * t60 * t45 / t35 / t48 / t34 - 0.56597222222222222222222222222222222222222222222222e-3 * t160) + 0.71489257812500000000000000000000000000000000000000e-9 * t188 * t189 * t45 / t192 / r0 * t69 * t197))
  t208 = f.my_piecewise5(t14, 0, t10, 0, -t133)
  t211 = f.my_piecewise3(t84, 0, 0.4e1 / 0.3e1 * t85 * t208)
  t219 = t5 * t87 * t143 * t125 / 0.8e1
  t221 = f.my_piecewise3(t81, 0, -0.3e1 / 0.8e1 * t5 * t211 * t26 * t125 - t219)
  vrho_0_ = t80 + t129 + t6 * (t206 + t221)
  t224 = -t7 - t132
  t225 = f.my_piecewise5(t10, 0, t14, 0, t224)
  t228 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t225)
  t234 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t228 * t26 * t76 - t147)
  t236 = f.my_piecewise5(t14, 0, t10, 0, -t224)
  t239 = f.my_piecewise3(t84, 0, 0.4e1 / 0.3e1 * t85 * t236)
  t247 = s2 / t91 / t89 / r1
  t251 = t106 ** 2
  t253 = t97 / t251
  t255 = 0.1e1 / t102 / r1
  t256 = t100 * t255
  t263 = t118 ** 2
  t264 = t263 ** 2
  t266 = t264 ** 2
  t269 = 0.1e1 / t266 / t264 / t263 * t121
  t283 = t98 ** 2
  t286 = t102 ** 2
  t290 = t120 ** 2
  t291 = 0.1e1 / t290
  t300 = f.my_piecewise3(t81, 0, -0.3e1 / 0.8e1 * t5 * t239 * t26 * t125 - t219 - 0.3e1 / 0.8e1 * t5 * t88 * (-0.10482716049382716049382716049382716049382716049383e-1 * t33 * t247 * t107 + 0.75625000000000000000000000000000000000000000000000e-4 * t253 * t256 - 0.75625000000000000000000000000000000000000000000000e-4 * t100 * t255 * t118 * t121 + 0.63020833333333333333333333333333333333333333333333e-6 * t104 * t269 * (-0.20566666666666666666666666666666666666666666666667e0 * t33 * t247 - 0.16046296296296296296296296296296296296296296296297e0 * t60 * t98 / t90 / t101 / t89 - 0.56597222222222222222222222222222222222222222222222e-3 * t256) + 0.71489257812500000000000000000000000000000000000000e-9 * t188 * t283 * t98 / t286 / r1 * t118 * t291))
  vrho_1_ = t80 + t129 + t6 * (t234 + t300)
  t306 = t44 * t45
  t307 = t306 * t50
  t333 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (0.39310185185185185185185185185185185185185185185185e-2 * t33 * t38 * t54 - 0.28359375000000000000000000000000000000000000000000e-4 * t157 * t307 + 0.28359375000000000000000000000000000000000000000000e-4 * t306 * t73 + 0.63020833333333333333333333333333333333333333333333e-6 * t51 * t173 * (0.77125000000000000000000000000000000000000000000000e-1 * t33 * t38 + 0.60173611111111111111111111111111111111111111111112e-1 * t60 * s0 * t63 + 0.21223958333333333333333333333333333333333333333333e-3 * t307) - 0.26808471679687500000000000000000000000000000000000e-9 * t188 * t189 * s0 / t192 * t69 * t197))
  vsigma_0_ = t6 * t333
  vsigma_1_ = 0.0e0
  t337 = t44 * t98
  t338 = t337 * t103
  t364 = f.my_piecewise3(t81, 0, -0.3e1 / 0.8e1 * t5 * t88 * (0.39310185185185185185185185185185185185185185185185e-2 * t33 * t93 * t107 - 0.28359375000000000000000000000000000000000000000000e-4 * t253 * t338 + 0.28359375000000000000000000000000000000000000000000e-4 * t337 * t122 + 0.63020833333333333333333333333333333333333333333333e-6 * t104 * t269 * (0.77125000000000000000000000000000000000000000000000e-1 * t33 * t93 + 0.60173611111111111111111111111111111111111111111112e-1 * t60 * s2 * t112 + 0.21223958333333333333333333333333333333333333333333e-3 * t338) - 0.26808471679687500000000000000000000000000000000000e-9 * t188 * t283 * s2 / t286 * t118 * t291))
  vsigma_2_ = t6 * t364
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_aa = 15 * 0.1234

  params_bb = 17.33

  params_cc = 0.163

  lv_alpha = 0.02178

  lv_beta = 1.15

  lv_muLV = 0.8491 / 9

  pw86_f0 = lambda s: (1 + params_aa * s ** 2 + params_bb * s ** 4 + params_cc * s ** 6) ** (1 / 15)

  lv_f0 = lambda s: +(1 + lv_muLV * s ** 2) / (1 + lv_alpha * s ** 6) + lv_alpha * s ** 6 * pw86_f0(s) / (lv_beta + lv_alpha * s ** 6)

  lv_f = lambda x: lv_f0(X2S * x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, lv_f, rs, z, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** 2
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t25 = t20 / t23
  t26 = 2 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = s0 * t27
  t29 = r0 ** 2
  t30 = t18 ** 2
  t32 = 0.1e1 / t30 / t29
  t34 = t25 * t28 * t32
  t36 = 0.1e1 + 0.39310185185185185185185185185185185185185185185185e-2 * t34
  t37 = t21 ** 2
  t38 = 0.1e1 / t37
  t39 = s0 ** 2
  t41 = t38 * t39 * s0
  t42 = t29 ** 2
  t43 = t42 ** 2
  t44 = 0.1e1 / t43
  t45 = t41 * t44
  t46 = 0.37812500000000000000000000000000000000000000000000e-4 * t45
  t47 = 0.1e1 + t46
  t48 = 0.1e1 / t47
  t51 = t20 ** 2
  t54 = t51 / t22 / t21
  t55 = t39 * t26
  t58 = 0.1e1 / t18 / t42 / r0
  t64 = (0.1e1 + 0.77125000000000000000000000000000000000000000000000e-1 * t34 + 0.60173611111111111111111111111111111111111111111111e-1 * t54 * t55 * t58 + 0.28298611111111111111111111111111111111111111111111e-3 * t45) ** (0.1e1 / 0.15e2)
  t66 = 0.115e1 + t46
  t67 = 0.1e1 / t66
  t68 = t44 * t64 * t67
  t71 = t36 * t48 + 0.37812500000000000000000000000000000000000000000000e-4 * t41 * t68
  t75 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t71)
  t84 = 0.1e1 / t30 / t29 / r0
  t89 = t47 ** 2
  t91 = t36 / t89
  t93 = 0.1e1 / t43 / r0
  t94 = t41 * t93
  t101 = t64 ** 2
  t102 = t101 ** 2
  t104 = t102 ** 2
  t107 = 0.1e1 / t104 / t102 / t101 * t67
  t122 = t37 ** 2
  t123 = 0.1e1 / t122
  t124 = t39 ** 2
  t127 = t43 ** 2
  t131 = t66 ** 2
  t132 = 0.1e1 / t131
  t141 = f.my_piecewise3(t2, 0, -t6 * t17 / t30 * t71 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (-0.10482716049382716049382716049382716049382716049383e-1 * t25 * s0 * t27 * t84 * t48 + 0.30250000000000000000000000000000000000000000000000e-3 * t91 * t94 - 0.30250000000000000000000000000000000000000000000000e-3 * t41 * t93 * t64 * t67 + 0.25208333333333333333333333333333333333333333333333e-5 * t45 * t107 * (-0.20566666666666666666666666666666666666666666666667e0 * t25 * t28 * t84 - 0.32092592592592592592592592592592592592592592592593e0 * t54 * t55 / t18 / t42 / t29 - 0.22638888888888888888888888888888888888888888888889e-2 * t94) + 0.11438281250000000000000000000000000000000000000000e-7 * t123 * t124 * t39 / t127 / r0 * t64 * t132))
  vrho_0_ = 0.2e1 * r0 * t141 + 0.2e1 * t75
  t144 = t27 * t32
  t148 = t38 * t39
  t149 = t148 * t44
  t176 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (0.39310185185185185185185185185185185185185185185185e-2 * t25 * t144 * t48 - 0.11343750000000000000000000000000000000000000000000e-3 * t91 * t149 + 0.11343750000000000000000000000000000000000000000000e-3 * t148 * t68 + 0.25208333333333333333333333333333333333333333333333e-5 * t45 * t107 * (0.77125000000000000000000000000000000000000000000000e-1 * t25 * t144 + 0.12034722222222222222222222222222222222222222222222e0 * t54 * s0 * t26 * t58 + 0.84895833333333333333333333333333333333333333333333e-3 * t149) - 0.42893554687500000000000000000000000000000000000000e-8 * t123 * t124 * s0 / t127 * t64 * t132))
  vsigma_0_ = 0.2e1 * r0 * t176
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t22 = 6 ** (0.1e1 / 0.3e1)
  t23 = jnp.pi ** 2
  t24 = t23 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t27 = t22 / t25
  t28 = 2 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = s0 * t29
  t31 = r0 ** 2
  t33 = 0.1e1 / t19 / t31
  t35 = t27 * t30 * t33
  t37 = 0.1e1 + 0.39310185185185185185185185185185185185185185185185e-2 * t35
  t38 = t23 ** 2
  t39 = 0.1e1 / t38
  t40 = s0 ** 2
  t41 = t40 * s0
  t42 = t39 * t41
  t43 = t31 ** 2
  t44 = t43 ** 2
  t45 = 0.1e1 / t44
  t46 = t42 * t45
  t47 = 0.37812500000000000000000000000000000000000000000000e-4 * t46
  t48 = 0.1e1 + t47
  t49 = 0.1e1 / t48
  t52 = t22 ** 2
  t55 = t52 / t24 / t23
  t56 = t40 * t28
  t59 = 0.1e1 / t18 / t43 / r0
  t64 = 0.1e1 + 0.77125000000000000000000000000000000000000000000002e-1 * t35 + 0.60173611111111111111111111111111111111111111111110e-1 * t55 * t56 * t59 + 0.28298611111111111111111111111111111111111111111111e-3 * t46
  t65 = t64 ** (0.1e1 / 0.15e2)
  t67 = 0.115e1 + t47
  t68 = 0.1e1 / t67
  t69 = t45 * t65 * t68
  t72 = t37 * t49 + 0.37812500000000000000000000000000000000000000000000e-4 * t42 * t69
  t76 = t17 * t18
  t77 = t27 * s0
  t78 = t31 * r0
  t80 = 0.1e1 / t19 / t78
  t81 = t29 * t80
  t82 = t81 * t49
  t85 = t48 ** 2
  t86 = 0.1e1 / t85
  t87 = t37 * t86
  t88 = t44 * r0
  t89 = 0.1e1 / t88
  t90 = t42 * t89
  t94 = t89 * t65 * t68
  t97 = t65 ** 2
  t98 = t97 ** 2
  t100 = t98 ** 2
  t101 = t100 * t98 * t97
  t102 = 0.1e1 / t101
  t103 = t102 * t68
  t109 = 0.1e1 / t18 / t43 / t31
  t114 = -0.20566666666666666666666666666666666666666666666667e0 * t27 * t30 * t80 - 0.32092592592592592592592592592592592592592592592592e0 * t55 * t56 * t109 - 0.22638888888888888888888888888888888888888888888889e-2 * t90
  t115 = t103 * t114
  t118 = t38 ** 2
  t119 = 0.1e1 / t118
  t120 = t40 ** 2
  t122 = t119 * t120 * t40
  t123 = t44 ** 2
  t125 = 0.1e1 / t123 / r0
  t127 = t67 ** 2
  t128 = 0.1e1 / t127
  t129 = t125 * t65 * t128
  t132 = -0.10482716049382716049382716049382716049382716049383e-1 * t77 * t82 + 0.30250000000000000000000000000000000000000000000000e-3 * t87 * t90 - 0.30250000000000000000000000000000000000000000000000e-3 * t42 * t94 + 0.25208333333333333333333333333333333333333333333333e-5 * t46 * t115 + 0.11438281250000000000000000000000000000000000000000e-7 * t122 * t129
  t137 = f.my_piecewise3(t2, 0, -t6 * t21 * t72 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t76 * t132)
  t149 = 0.1e1 / t19 / t43
  t165 = t37 / t85 / t48
  t167 = 0.1e1 / t123 / t31
  t171 = t44 * t31
  t172 = 0.1e1 / t171
  t173 = t42 * t172
  t188 = 0.1e1 / t101 / t64 * t68
  t189 = t114 ** 2
  t193 = t122 * t125
  t194 = t102 * t128
  t195 = t194 * t114
  t213 = 0.1e1 / t118 / t38
  t214 = t120 ** 2
  t221 = 0.1e1 / t127 / t67
  t225 = 0.38436625514403292181069958847736625514403292181071e-1 * t77 * t29 * t149 * t49 - 0.63420432098765432098765432098765432098765432098768e-5 * t27 * t120 * t29 / t19 / t44 / t43 * t86 * t39 + 0.18301250000000000000000000000000000000000000000000e-6 * t165 * t122 * t167 - 0.27225000000000000000000000000000000000000000000000e-2 * t87 * t173 + 0.27225000000000000000000000000000000000000000000000e-2 * t42 * t172 * t65 * t68 - 0.40333333333333333333333333333333333333333333333333e-4 * t90 * t115 - 0.28595703125000000000000000000000000000000000000000e-6 * t122 * t167 * t65 * t128 - 0.23527777777777777777777777777777777777777777777777e-5 * t46 * t188 * t189 + 0.15251041666666666666666666666666666666666666666666e-8 * t193 * t195 + 0.25208333333333333333333333333333333333333333333333e-5 * t46 * t103 * (0.75411111111111111111111111111111111111111111111112e0 * t27 * t30 * t149 + 0.20325308641975308641975308641975308641975308641975e1 * t55 * t56 / t18 / t43 / t78 + 0.20375000000000000000000000000000000000000000000000e-1 * t173) + 0.69201601562500000000000000000000000000000000000000e-11 * t213 * t214 * s0 / t123 / t171 * t65 * t221
  t230 = f.my_piecewise3(t2, 0, t6 * t17 / t19 / r0 * t72 / 0.12e2 - t6 * t21 * t132 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t76 * t225)
  v2rho2_0_ = 0.2e1 * r0 * t230 + 0.4e1 * t137
  t233 = t29 * t33
  t237 = t39 * t40
  t238 = t237 * t45
  t245 = s0 * t28
  t250 = 0.77125000000000000000000000000000000000000000000002e-1 * t27 * t233 + 0.12034722222222222222222222222222222222222222222222e0 * t55 * t245 * t59 + 0.84895833333333333333333333333333333333333333333333e-3 * t238
  t251 = t103 * t250
  t255 = t119 * t120 * s0
  t256 = 0.1e1 / t123
  t258 = t256 * t65 * t128
  t261 = 0.39310185185185185185185185185185185185185185185185e-2 * t27 * t233 * t49 - 0.11343750000000000000000000000000000000000000000000e-3 * t87 * t238 + 0.11343750000000000000000000000000000000000000000000e-3 * t237 * t69 + 0.25208333333333333333333333333333333333333333333333e-5 * t46 * t251 - 0.42893554687500000000000000000000000000000000000000e-8 * t255 * t258
  t265 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t76 * t261)
  t271 = t27 * t29
  t282 = t237 * t89
  t297 = t194 * t250
  t310 = t255 * t256
  t320 = -0.10482716049382716049382716049382716049382716049383e-1 * t27 * t82 + 0.23782662037037037037037037037037037037037037037037e-5 * t271 / t19 / t44 / t78 * t86 * t42 - 0.68629687500000000000000000000000000000000000000000e-7 * t165 * t255 * t125 + 0.90750000000000000000000000000000000000000000000000e-3 * t87 * t282 - 0.90750000000000000000000000000000000000000000000000e-3 * t237 * t94 + 0.75625000000000000000000000000000000000000000000000e-5 * t238 * t115 + 0.10294453125000000000000000000000000000000000000000e-6 * t255 * t129 - 0.20166666666666666666666666666666666666666666666666e-4 * t90 * t251 - 0.23527777777777777777777777777777777777777777777777e-5 * t46 * t188 * t250 * t114 + 0.76255208333333333333333333333333333333333333333332e-9 * t193 * t297 + 0.25208333333333333333333333333333333333333333333333e-5 * t46 * t103 * (-0.20566666666666666666666666666666666666666666666667e0 * t27 * t81 - 0.64185185185185185185185185185185185185185185185184e0 * t55 * t245 * t109 - 0.67916666666666666666666666666666666666666666666666e-2 * t282) - 0.28595703125000000000000000000000000000000000000000e-9 * t310 * t195 - 0.25950600585937500000000000000000000000000000000000e-11 * t213 * t214 / t123 / t88 * t65 * t221
  t325 = f.my_piecewise3(t2, 0, -t6 * t21 * t261 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t76 * t320)
  v2rhosigma_0_ = 0.2e1 * r0 * t325 + 0.2e1 * t265
  t334 = t119 * t120
  t338 = t39 * s0
  t339 = t338 * t45
  t348 = t250 ** 2
  t374 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t76 * (-0.89184982638888888888888888888888888888888888888888e-6 * t271 / t19 / t171 * t86 * t237 + 0.25736132812500000000000000000000000000000000000000e-7 * t165 * t334 * t256 - 0.22687500000000000000000000000000000000000000000000e-3 * t87 * t339 + 0.22687500000000000000000000000000000000000000000000e-3 * t338 * t69 + 0.15125000000000000000000000000000000000000000000000e-4 * t238 * t251 - 0.34314843750000000000000000000000000000000000000000e-7 * t334 * t258 - 0.23527777777777777777777777777777777777777777777777e-5 * t46 * t188 * t348 - 0.57191406250000000000000000000000000000000000000000e-9 * t310 * t297 + 0.25208333333333333333333333333333333333333333333333e-5 * t46 * t103 * (0.12034722222222222222222222222222222222222222222222e0 * t55 * t28 * t59 + 0.16979166666666666666666666666666666666666666666667e-2 * t339) + 0.97314752197265625000000000000000000000000000000000e-12 * t213 * t120 * t41 / t123 / t44 * t65 * t221))
  v2sigma2_0_ = 0.2e1 * r0 * t374
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t22 = t17 / t19 / r0
  t23 = 6 ** (0.1e1 / 0.3e1)
  t24 = jnp.pi ** 2
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t28 = t23 / t26
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = s0 * t30
  t32 = r0 ** 2
  t34 = 0.1e1 / t19 / t32
  t36 = t28 * t31 * t34
  t38 = 0.1e1 + 0.39310185185185185185185185185185185185185185185185e-2 * t36
  t39 = t24 ** 2
  t40 = 0.1e1 / t39
  t41 = s0 ** 2
  t42 = t41 * s0
  t43 = t40 * t42
  t44 = t32 ** 2
  t45 = t44 ** 2
  t46 = 0.1e1 / t45
  t47 = t43 * t46
  t48 = 0.37812500000000000000000000000000000000000000000000e-4 * t47
  t49 = 0.1e1 + t48
  t50 = 0.1e1 / t49
  t53 = t23 ** 2
  t56 = t53 / t25 / t24
  t57 = t41 * t29
  t58 = t44 * r0
  t65 = 0.1e1 + 0.77125000000000000000000000000000000000000000000002e-1 * t36 + 0.60173611111111111111111111111111111111111111111110e-1 * t56 * t57 / t18 / t58 + 0.28298611111111111111111111111111111111111111111111e-3 * t47
  t66 = t65 ** (0.1e1 / 0.15e2)
  t68 = 0.115e1 + t48
  t69 = 0.1e1 / t68
  t73 = t38 * t50 + 0.37812500000000000000000000000000000000000000000000e-4 * t43 * t46 * t66 * t69
  t78 = t17 / t19
  t79 = t28 * s0
  t80 = t32 * r0
  t82 = 0.1e1 / t19 / t80
  t87 = t49 ** 2
  t88 = 0.1e1 / t87
  t89 = t38 * t88
  t91 = 0.1e1 / t45 / r0
  t92 = t43 * t91
  t99 = t66 ** 2
  t100 = t99 ** 2
  t102 = t100 ** 2
  t103 = t102 * t100 * t99
  t104 = 0.1e1 / t103
  t105 = t104 * t69
  t116 = -0.20566666666666666666666666666666666666666666666667e0 * t28 * t31 * t82 - 0.32092592592592592592592592592592592592592592592592e0 * t56 * t57 / t18 / t44 / t32 - 0.22638888888888888888888888888888888888888888888889e-2 * t92
  t117 = t105 * t116
  t120 = t39 ** 2
  t121 = 0.1e1 / t120
  t122 = t41 ** 2
  t124 = t121 * t122 * t41
  t125 = t45 ** 2
  t127 = 0.1e1 / t125 / r0
  t129 = t68 ** 2
  t130 = 0.1e1 / t129
  t134 = -0.10482716049382716049382716049382716049382716049383e-1 * t79 * t30 * t82 * t50 + 0.30250000000000000000000000000000000000000000000000e-3 * t89 * t92 - 0.30250000000000000000000000000000000000000000000000e-3 * t43 * t91 * t66 * t69 + 0.25208333333333333333333333333333333333333333333333e-5 * t47 * t117 + 0.11438281250000000000000000000000000000000000000000e-7 * t124 * t127 * t66 * t130
  t138 = t17 * t18
  t140 = 0.1e1 / t19 / t44
  t145 = t28 * t122
  t150 = t88 * t40
  t155 = 0.1e1 / t87 / t49
  t156 = t38 * t155
  t158 = 0.1e1 / t125 / t32
  t159 = t124 * t158
  t162 = t45 * t32
  t163 = 0.1e1 / t162
  t164 = t43 * t163
  t178 = 0.1e1 / t103 / t65
  t179 = t178 * t69
  t180 = t116 ** 2
  t181 = t179 * t180
  t184 = t124 * t127
  t185 = t104 * t130
  t186 = t185 * t116
  t199 = 0.75411111111111111111111111111111111111111111111112e0 * t28 * t31 * t140 + 0.20325308641975308641975308641975308641975308641975e1 * t56 * t57 / t18 / t44 / t80 + 0.20375000000000000000000000000000000000000000000000e-1 * t164
  t200 = t105 * t199
  t205 = t122 ** 2
  t207 = 0.1e1 / t120 / t39 * t205 * s0
  t209 = 0.1e1 / t125 / t162
  t212 = 0.1e1 / t129 / t68
  t216 = 0.38436625514403292181069958847736625514403292181071e-1 * t79 * t30 * t140 * t50 - 0.63420432098765432098765432098765432098765432098768e-5 * t145 * t30 / t19 / t45 / t44 * t150 + 0.18301250000000000000000000000000000000000000000000e-6 * t156 * t159 - 0.27225000000000000000000000000000000000000000000000e-2 * t89 * t164 + 0.27225000000000000000000000000000000000000000000000e-2 * t43 * t163 * t66 * t69 - 0.40333333333333333333333333333333333333333333333333e-4 * t92 * t117 - 0.28595703125000000000000000000000000000000000000000e-6 * t124 * t158 * t66 * t130 - 0.23527777777777777777777777777777777777777777777777e-5 * t47 * t181 + 0.15251041666666666666666666666666666666666666666666e-8 * t184 * t186 + 0.25208333333333333333333333333333333333333333333333e-5 * t47 * t200 + 0.69201601562500000000000000000000000000000000000000e-11 * t207 * t209 * t66 * t212
  t221 = f.my_piecewise3(t2, 0, t6 * t22 * t73 / 0.12e2 - t6 * t78 * t134 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t138 * t216)
  t234 = 0.1e1 / t19 / t58
  t258 = t65 ** 2
  t270 = t120 ** 2
  t274 = t125 ** 2
  t278 = t129 ** 2
  t283 = t87 ** 2
  t286 = t45 * t80
  t288 = 0.1e1 / t125 / t286
  t293 = 0.1e1 / t125 / t80
  t305 = 0.1e1 / t286
  t306 = t43 * t305
  t344 = -0.17937091906721536351165980795610425240054869684500e0 * t79 * t30 * t234 * t50 + 0.12049882098765432098765432098765432098765432098766e-3 * t145 * t30 / t19 / t45 / t58 * t150 - 0.57554042129629629629629629629629629629629629629632e-8 * t28 * t122 * t42 * t30 / t19 / t125 / t58 * t155 * t121 + 0.56466666666666666666666666666666666666666666666666e-4 * t92 * t181 + 0.45487037037037037037037037037037037037037037037035e-5 * t47 / t103 / t258 * t69 * t180 * t116 - 0.70583333333333333333333333333333333333333333333331e-5 * t47 * t179 * t116 * t199 + 0.62800453417968750000000000000000000000000000000000e-14 / t270 * t205 * t122 / t274 / t80 * t66 / t278 + 0.16608384375000000000000000000000000000000000000000e-9 * t38 / t283 * t207 * t288 + 0.59707828125000000000000000000000000000000000000000e-5 * t124 * t293 * t66 * t130 - 0.35292816796875000000000000000000000000000000000000e-9 * t207 * t288 * t66 * t212 - 0.49413375000000000000000000000000000000000000000000e-5 * t156 * t124 * t293 + 0.27225000000000000000000000000000000000000000000000e-1 * t89 * t306 - 0.27225000000000000000000000000000000000000000000000e-1 * t43 * t305 * t66 * t69 + 0.54450000000000000000000000000000000000000000000000e-3 * t164 * t117 - 0.60499999999999999999999999999999999999999999999999e-4 * t92 * t200 - 0.57191406249999999999999999999999999999999999999998e-7 * t159 * t186 - 0.21351458333333333333333333333333333333333333333332e-8 * t184 * t178 * t130 * t180 + 0.22876562499999999999999999999999999999999999999999e-8 * t184 * t185 * t199 + 0.13840320312500000000000000000000000000000000000000e-11 * t207 * t209 * t104 * t212 * t116 + 0.25208333333333333333333333333333333333333333333333e-5 * t47 * t105 * (-0.35191851851851851851851851851851851851851851851852e1 * t28 * t31 * t234 - 0.14905226337448559670781893004115226337448559670782e2 * t56 * t57 / t18 / t45 - 0.20375000000000000000000000000000000000000000000000e0 * t306)
  t349 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t34 * t73 + t6 * t22 * t134 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t78 * t216 - 0.3e1 / 0.8e1 * t6 * t138 * t344)
  v3rho3_0_ = 0.2e1 * r0 * t349 + 0.6e1 * t221

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t23 = t17 * t22
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t29 = t24 / t27
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = s0 * t31
  t34 = t29 * t32 * t22
  t36 = 0.1e1 + 0.39310185185185185185185185185185185185185185185185e-2 * t34
  t37 = t25 ** 2
  t38 = 0.1e1 / t37
  t39 = s0 ** 2
  t40 = t39 * s0
  t41 = t38 * t40
  t42 = t18 ** 2
  t43 = t42 ** 2
  t44 = 0.1e1 / t43
  t45 = t41 * t44
  t46 = 0.37812500000000000000000000000000000000000000000000e-4 * t45
  t47 = 0.1e1 + t46
  t48 = 0.1e1 / t47
  t51 = t24 ** 2
  t54 = t51 / t26 / t25
  t55 = t39 * t30
  t56 = t42 * r0
  t63 = 0.1e1 + 0.77125000000000000000000000000000000000000000000002e-1 * t34 + 0.60173611111111111111111111111111111111111111111110e-1 * t54 * t55 / t19 / t56 + 0.28298611111111111111111111111111111111111111111111e-3 * t45
  t64 = t63 ** (0.1e1 / 0.15e2)
  t66 = 0.115e1 + t46
  t67 = 0.1e1 / t66
  t71 = t36 * t48 + 0.37812500000000000000000000000000000000000000000000e-4 * t41 * t44 * t64 * t67
  t77 = t17 / t20 / r0
  t78 = t29 * s0
  t79 = t18 * r0
  t81 = 0.1e1 / t20 / t79
  t86 = t47 ** 2
  t87 = 0.1e1 / t86
  t88 = t36 * t87
  t89 = t43 * r0
  t90 = 0.1e1 / t89
  t91 = t41 * t90
  t98 = t64 ** 2
  t99 = t98 ** 2
  t101 = t99 ** 2
  t102 = t101 * t99 * t98
  t103 = 0.1e1 / t102
  t104 = t103 * t67
  t108 = t42 * t18
  t115 = -0.20566666666666666666666666666666666666666666666667e0 * t29 * t32 * t81 - 0.32092592592592592592592592592592592592592592592592e0 * t54 * t55 / t19 / t108 - 0.22638888888888888888888888888888888888888888888889e-2 * t91
  t116 = t104 * t115
  t119 = t37 ** 2
  t120 = 0.1e1 / t119
  t121 = t39 ** 2
  t123 = t120 * t121 * t39
  t124 = t43 ** 2
  t126 = 0.1e1 / t124 / r0
  t128 = t66 ** 2
  t129 = 0.1e1 / t128
  t133 = -0.10482716049382716049382716049382716049382716049383e-1 * t78 * t31 * t81 * t48 + 0.30250000000000000000000000000000000000000000000000e-3 * t88 * t91 - 0.30250000000000000000000000000000000000000000000000e-3 * t41 * t90 * t64 * t67 + 0.25208333333333333333333333333333333333333333333333e-5 * t45 * t116 + 0.11438281250000000000000000000000000000000000000000e-7 * t123 * t126 * t64 * t129
  t138 = t17 / t20
  t140 = 0.1e1 / t20 / t42
  t145 = t29 * t121
  t146 = t43 * t42
  t150 = t87 * t38
  t155 = 0.1e1 / t86 / t47
  t156 = t36 * t155
  t158 = 0.1e1 / t124 / t18
  t159 = t123 * t158
  t162 = t43 * t18
  t163 = 0.1e1 / t162
  t164 = t41 * t163
  t178 = 0.1e1 / t102 / t63
  t179 = t178 * t67
  t180 = t115 ** 2
  t181 = t179 * t180
  t184 = t123 * t126
  t185 = t103 * t129
  t186 = t185 * t115
  t199 = 0.75411111111111111111111111111111111111111111111112e0 * t29 * t32 * t140 + 0.20325308641975308641975308641975308641975308641975e1 * t54 * t55 / t19 / t42 / t79 + 0.20375000000000000000000000000000000000000000000000e-1 * t164
  t200 = t104 * t199
  t204 = 0.1e1 / t119 / t37
  t205 = t121 ** 2
  t207 = t204 * t205 * s0
  t209 = 0.1e1 / t124 / t162
  t212 = 0.1e1 / t128 / t66
  t216 = 0.38436625514403292181069958847736625514403292181071e-1 * t78 * t31 * t140 * t48 - 0.63420432098765432098765432098765432098765432098768e-5 * t145 * t31 / t20 / t146 * t150 + 0.18301250000000000000000000000000000000000000000000e-6 * t156 * t159 - 0.27225000000000000000000000000000000000000000000000e-2 * t88 * t164 + 0.27225000000000000000000000000000000000000000000000e-2 * t41 * t163 * t64 * t67 - 0.40333333333333333333333333333333333333333333333333e-4 * t91 * t116 - 0.28595703125000000000000000000000000000000000000000e-6 * t123 * t158 * t64 * t129 - 0.23527777777777777777777777777777777777777777777777e-5 * t45 * t181 + 0.15251041666666666666666666666666666666666666666666e-8 * t184 * t186 + 0.25208333333333333333333333333333333333333333333333e-5 * t45 * t200 + 0.69201601562500000000000000000000000000000000000000e-11 * t207 * t209 * t64 * t212
  t220 = t17 * t19
  t222 = 0.1e1 / t20 / t56
  t234 = t121 * t40
  t235 = t29 * t234
  t240 = t155 * t120
  t246 = t63 ** 2
  t248 = 0.1e1 / t102 / t246
  t249 = t248 * t67
  t250 = t180 * t115
  t251 = t249 * t250
  t254 = t115 * t199
  t255 = t179 * t254
  t258 = t119 ** 2
  t261 = 0.1e1 / t258 * t205 * t121
  t262 = t124 ** 2
  t264 = 0.1e1 / t262 / t79
  t266 = t128 ** 2
  t267 = 0.1e1 / t266
  t271 = t86 ** 2
  t272 = 0.1e1 / t271
  t273 = t36 * t272
  t274 = t43 * t79
  t276 = 0.1e1 / t124 / t274
  t277 = t207 * t276
  t281 = 0.1e1 / t124 / t79
  t290 = t123 * t281
  t293 = 0.1e1 / t274
  t294 = t41 * t293
  t307 = t178 * t129
  t308 = t307 * t180
  t311 = t185 * t199
  t314 = t207 * t209
  t315 = t103 * t212
  t316 = t315 * t115
  t328 = -0.35191851851851851851851851851851851851851851851852e1 * t29 * t32 * t222 - 0.14905226337448559670781893004115226337448559670782e2 * t54 * t55 / t19 / t43 - 0.20375000000000000000000000000000000000000000000000e0 * t294
  t329 = t104 * t328
  t332 = -0.17937091906721536351165980795610425240054869684500e0 * t78 * t31 * t222 * t48 + 0.12049882098765432098765432098765432098765432098766e-3 * t145 * t31 / t20 / t43 / t56 * t150 - 0.57554042129629629629629629629629629629629629629632e-8 * t235 * t31 / t20 / t124 / t56 * t240 + 0.56466666666666666666666666666666666666666666666666e-4 * t91 * t181 + 0.45487037037037037037037037037037037037037037037035e-5 * t45 * t251 - 0.70583333333333333333333333333333333333333333333331e-5 * t45 * t255 + 0.62800453417968750000000000000000000000000000000000e-14 * t261 * t264 * t64 * t267 + 0.16608384375000000000000000000000000000000000000000e-9 * t273 * t277 + 0.59707828125000000000000000000000000000000000000000e-5 * t123 * t281 * t64 * t129 - 0.35292816796875000000000000000000000000000000000000e-9 * t207 * t276 * t64 * t212 - 0.49413375000000000000000000000000000000000000000000e-5 * t156 * t290 + 0.27225000000000000000000000000000000000000000000000e-1 * t88 * t294 - 0.27225000000000000000000000000000000000000000000000e-1 * t41 * t293 * t64 * t67 + 0.54450000000000000000000000000000000000000000000000e-3 * t164 * t116 - 0.60499999999999999999999999999999999999999999999999e-4 * t91 * t200 - 0.57191406249999999999999999999999999999999999999998e-7 * t159 * t186 - 0.21351458333333333333333333333333333333333333333332e-8 * t184 * t308 + 0.22876562499999999999999999999999999999999999999999e-8 * t184 * t311 + 0.13840320312500000000000000000000000000000000000000e-11 * t314 * t316 + 0.25208333333333333333333333333333333333333333333333e-5 * t45 * t329
  t337 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t23 * t71 + t6 * t77 * t133 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t138 * t216 - 0.3e1 / 0.8e1 * t6 * t220 * t332)
  t367 = 0.1e1 / t20 / t108
  t376 = 0.1e1 / t146
  t377 = t41 * t376
  t386 = 0.1e1 / t124 / t42
  t408 = 0.1e1 / t262 / t42
  t413 = 0.1e1 / t124 / t146
  t435 = -0.80666666666666666666666666666666666666666666666665e-4 * t91 * t329 - 0.11438281250000000000000000000000000000000000000000e-6 * t159 * t311 - 0.25835264583333333333333333333333333333333333333333e-11 * t314 * t178 * t212 * t180 + 0.30502083333333333333333333333333333333333333333332e-8 * t184 * t185 * t328 + 0.27680640624999999999999999999999999999999999999999e-11 * t314 * t315 * t199 + 0.25208333333333333333333333333333333333333333333333e-5 * t45 * t104 * (0.19942049382716049382716049382716049382716049382716e2 * t29 * t32 * t367 + 0.12421021947873799725651577503429355281207133058985e3 * t54 * t55 / t19 / t89 + 0.22412500000000000000000000000000000000000000000000e1 * t377) + 0.10675729166666666666666666666666666666666666666666e-6 * t159 * t308 + 0.11035653750000000000000000000000000000000000000000e-3 * t156 * t123 * t386 - 0.29947500000000000000000000000000000000000000000000e0 * t88 * t377 + 0.75988548635742187500000000000000000000000000000000e-17 / t258 / t37 * t205 * t234 / t262 / t146 * t64 / t266 / t66 + 0.20096145093750000000000000000000000000000000000000e-12 * t36 / t271 / t47 * t261 * t408 + 0.13141384136718750000000000000000000000000000000000e-7 * t207 * t413 * t64 * t212 - 0.54008389939453125000000000000000000000000000000000e-12 * t261 * t408 * t64 * t267 - 0.89685275625000000000000000000000000000000000000000e-8 * t273 * t207 * t413 - 0.12168043593750000000000000000000000000000000000000e-3 * t123 * t386 * t64 * t129 + 0.29947500000000000000000000000000000000000000000000e0 * t41 * t376 * t64 * t67 + 0.15922087500000000000000000000000000000000000000000e-5 * t290 * t186
  t446 = t180 ** 2
  t450 = t199 ** 2
  t484 = t43 * t108
  t508 = -0.94114178124999999999999999999999999999999999999999e-10 * t277 * t316 - 0.10164000000000000000000000000000000000000000000000e-2 * t164 * t181 - 0.14555851851851851851851851851851851851851851851852e-3 * t91 * t251 - 0.13342864197530864197530864197530864197530864197530e-4 * t45 / t102 / t246 / t63 * t67 * t446 - 0.70583333333333333333333333333333333333333333333331e-5 * t45 * t179 * t450 + 0.10164352080475537265660722450845907636031092821217e1 * t78 * t31 * t367 * t48 - 0.72600000000000000000000000000000000000000000000000e-2 * t294 * t116 + 0.10890000000000000000000000000000000000000000000000e-2 * t164 * t200 + 0.55039314814814814814814814814814814814814814814811e-8 * t184 * t248 * t129 * t250 + 0.16746787578125000000000000000000000000000000000000e-14 * t261 * t264 * t103 * t267 * t115 + 0.22586666666666666666666666666666666666666666666667e-3 * t91 * t255 + 0.27292222222222222222222222222222222222222222222221e-4 * t45 * t249 * t180 * t199 - 0.94111111111111111111111111111111111111111111111108e-5 * t45 * t179 * t115 * t328 - 0.85405833333333333333333333333333333333333333333329e-8 * t184 * t307 * t254 - 0.19864688676268861454046639231824417009602194787380e-2 * t145 * t31 / t20 / t484 * t150 + 0.24940084922839506172839506172839506172839506172840e-6 * t235 * t31 / t20 / t124 / t108 * t240 - 0.69640390976851851851851851851851851851851851851854e-11 * t29 * t205 * t39 * t31 / t20 / t124 / t484 * t272 * t204
  t514 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t17 * t81 * t71 - 0.5e1 / 0.9e1 * t6 * t23 * t133 + t6 * t77 * t216 / 0.2e1 - t6 * t138 * t332 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t220 * (t435 + t508))
  v4rho4_0_ = 0.2e1 * r0 * t514 + 0.8e1 * t337

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t37 = t32 / t35
  t38 = r0 ** 2
  t39 = r0 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t44 = t37 * s0 / t40 / t38
  t46 = 0.1e1 + 0.39310185185185185185185185185185185185185185185185e-2 * t44
  t47 = t33 ** 2
  t48 = 0.1e1 / t47
  t49 = s0 ** 2
  t51 = t48 * t49 * s0
  t52 = t38 ** 2
  t53 = t52 ** 2
  t54 = 0.1e1 / t53
  t55 = t51 * t54
  t56 = 0.94531250000000000000000000000000000000000000000000e-5 * t55
  t57 = 0.1e1 + t56
  t58 = 0.1e1 / t57
  t61 = t32 ** 2
  t64 = t61 / t34 / t33
  t72 = 0.1e1 + 0.77125000000000000000000000000000000000000000000002e-1 * t44 + 0.30086805555555555555555555555555555555555555555555e-1 * t64 * t49 / t39 / t52 / r0 + 0.70746527777777777777777777777777777777777777777778e-4 * t55
  t73 = t72 ** (0.1e1 / 0.15e2)
  t75 = 0.115e1 + t56
  t76 = 0.1e1 / t75
  t80 = t46 * t58 + 0.94531250000000000000000000000000000000000000000000e-5 * t51 * t54 * t73 * t76
  t84 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t85 = t84 * f.p.zeta_threshold
  t87 = f.my_piecewise3(t20, t85, t21 * t19)
  t88 = t30 ** 2
  t89 = 0.1e1 / t88
  t90 = t87 * t89
  t93 = t5 * t90 * t80 / 0.8e1
  t94 = t87 * t30
  t95 = t38 * r0
  t98 = s0 / t40 / t95
  t102 = t57 ** 2
  t103 = 0.1e1 / t102
  t104 = t46 * t103
  t106 = 0.1e1 / t53 / r0
  t107 = t51 * t106
  t114 = t73 ** 2
  t115 = t114 ** 2
  t117 = t115 ** 2
  t118 = t117 * t115 * t114
  t119 = 0.1e1 / t118
  t120 = t119 * t76
  t130 = -0.20566666666666666666666666666666666666666666666667e0 * t37 * t98 - 0.16046296296296296296296296296296296296296296296296e0 * t64 * t49 / t39 / t52 / t38 - 0.56597222222222222222222222222222222222222222222222e-3 * t107
  t131 = t120 * t130
  t134 = t47 ** 2
  t135 = 0.1e1 / t134
  t136 = t49 ** 2
  t138 = t135 * t136 * t49
  t139 = t53 ** 2
  t141 = 0.1e1 / t139 / r0
  t143 = t75 ** 2
  t144 = 0.1e1 / t143
  t148 = -0.10482716049382716049382716049382716049382716049383e-1 * t37 * t98 * t58 + 0.75625000000000000000000000000000000000000000000000e-4 * t104 * t107 - 0.75625000000000000000000000000000000000000000000000e-4 * t51 * t106 * t73 * t76 + 0.63020833333333333333333333333333333333333333333333e-6 * t55 * t131 + 0.71489257812500000000000000000000000000000000000000e-9 * t138 * t141 * t73 * t144
  t153 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t80 - t93 - 0.3e1 / 0.8e1 * t5 * t94 * t148)
  t155 = r1 <= f.p.dens_threshold
  t156 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t157 = 0.1e1 + t156
  t158 = t157 <= f.p.zeta_threshold
  t159 = t157 ** (0.1e1 / 0.3e1)
  t161 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t164 = f.my_piecewise3(t158, 0, 0.4e1 / 0.3e1 * t159 * t161)
  t165 = t164 * t30
  t166 = r1 ** 2
  t167 = r1 ** (0.1e1 / 0.3e1)
  t168 = t167 ** 2
  t172 = t37 * s2 / t168 / t166
  t174 = 0.1e1 + 0.39310185185185185185185185185185185185185185185185e-2 * t172
  t175 = s2 ** 2
  t177 = t48 * t175 * s2
  t178 = t166 ** 2
  t179 = t178 ** 2
  t180 = 0.1e1 / t179
  t181 = t177 * t180
  t182 = 0.94531250000000000000000000000000000000000000000000e-5 * t181
  t183 = 0.1e1 + t182
  t184 = 0.1e1 / t183
  t194 = 0.1e1 + 0.77125000000000000000000000000000000000000000000002e-1 * t172 + 0.30086805555555555555555555555555555555555555555555e-1 * t64 * t175 / t167 / t178 / r1 + 0.70746527777777777777777777777777777777777777777778e-4 * t181
  t195 = t194 ** (0.1e1 / 0.15e2)
  t197 = 0.115e1 + t182
  t198 = 0.1e1 / t197
  t202 = t174 * t184 + 0.94531250000000000000000000000000000000000000000000e-5 * t177 * t180 * t195 * t198
  t207 = f.my_piecewise3(t158, t85, t159 * t157)
  t208 = t207 * t89
  t211 = t5 * t208 * t202 / 0.8e1
  t213 = f.my_piecewise3(t155, 0, -0.3e1 / 0.8e1 * t5 * t165 * t202 - t211)
  t215 = t21 ** 2
  t216 = 0.1e1 / t215
  t217 = t26 ** 2
  t222 = t16 / t22 / t6
  t224 = -0.2e1 * t23 + 0.2e1 * t222
  t225 = f.my_piecewise5(t10, 0, t14, 0, t224)
  t229 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t216 * t217 + 0.4e1 / 0.3e1 * t21 * t225)
  t236 = t5 * t29 * t89 * t80
  t242 = 0.1e1 / t88 / t6
  t246 = t5 * t87 * t242 * t80 / 0.12e2
  t248 = t5 * t90 * t148
  t252 = s0 / t40 / t52
  t268 = 0.1e1 / t139 / t38
  t272 = t53 * t38
  t273 = 0.1e1 / t272
  t274 = t51 * t273
  t290 = t130 ** 2
  t313 = 0.1e1 / t134 / t47
  t314 = t136 ** 2
  t325 = 0.38436625514403292181069958847736625514403292181071e-1 * t37 * t252 * t58 - 0.15855108024691358024691358024691358024691358024692e-5 * t37 * t136 / t40 / t53 / t52 * t103 * t48 + 0.11438281250000000000000000000000000000000000000000e-7 * t46 / t102 / t57 * t138 * t268 - 0.68062500000000000000000000000000000000000000000000e-3 * t104 * t274 + 0.68062500000000000000000000000000000000000000000000e-3 * t51 * t273 * t73 * t76 - 0.10083333333333333333333333333333333333333333333333e-4 * t107 * t131 - 0.17872314453125000000000000000000000000000000000000e-7 * t138 * t268 * t73 * t144 - 0.58819444444444444444444444444444444444444444444444e-6 * t55 / t118 / t72 * t76 * t290 + 0.95319010416666666666666666666666666666666666666666e-10 * t138 * t141 * t119 * t144 * t130 + 0.63020833333333333333333333333333333333333333333333e-6 * t55 * t120 * (0.75411111111111111111111111111111111111111111111112e0 * t37 * t252 + 0.10162654320987654320987654320987654320987654320987e1 * t64 * t49 / t39 / t52 / t95 + 0.50937500000000000000000000000000000000000000000000e-2 * t274) + 0.10812750244140625000000000000000000000000000000000e-12 * t313 * t314 * s0 / t139 / t272 * t73 / t143 / t75
  t330 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t229 * t30 * t80 - t236 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t148 + t246 - t248 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t94 * t325)
  t331 = t159 ** 2
  t332 = 0.1e1 / t331
  t333 = t161 ** 2
  t337 = f.my_piecewise5(t14, 0, t10, 0, -t224)
  t341 = f.my_piecewise3(t158, 0, 0.4e1 / 0.9e1 * t332 * t333 + 0.4e1 / 0.3e1 * t159 * t337)
  t348 = t5 * t164 * t89 * t202
  t353 = t5 * t207 * t242 * t202 / 0.12e2
  t355 = f.my_piecewise3(t155, 0, -0.3e1 / 0.8e1 * t5 * t341 * t30 * t202 - t348 / 0.4e1 + t353)
  d11 = 0.2e1 * t153 + 0.2e1 * t213 + t6 * (t330 + t355)
  t358 = -t7 - t24
  t359 = f.my_piecewise5(t10, 0, t14, 0, t358)
  t362 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t359)
  t363 = t362 * t30
  t368 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t363 * t80 - t93)
  t370 = f.my_piecewise5(t14, 0, t10, 0, -t358)
  t373 = f.my_piecewise3(t158, 0, 0.4e1 / 0.3e1 * t159 * t370)
  t374 = t373 * t30
  t378 = t207 * t30
  t379 = t166 * r1
  t382 = s2 / t168 / t379
  t386 = t183 ** 2
  t387 = 0.1e1 / t386
  t388 = t174 * t387
  t390 = 0.1e1 / t179 / r1
  t391 = t177 * t390
  t398 = t195 ** 2
  t399 = t398 ** 2
  t401 = t399 ** 2
  t402 = t401 * t399 * t398
  t403 = 0.1e1 / t402
  t404 = t403 * t198
  t414 = -0.20566666666666666666666666666666666666666666666667e0 * t37 * t382 - 0.16046296296296296296296296296296296296296296296296e0 * t64 * t175 / t167 / t178 / t166 - 0.56597222222222222222222222222222222222222222222222e-3 * t391
  t415 = t404 * t414
  t418 = t175 ** 2
  t420 = t135 * t418 * t175
  t421 = t179 ** 2
  t423 = 0.1e1 / t421 / r1
  t425 = t197 ** 2
  t426 = 0.1e1 / t425
  t430 = -0.10482716049382716049382716049382716049382716049383e-1 * t37 * t382 * t184 + 0.75625000000000000000000000000000000000000000000000e-4 * t388 * t391 - 0.75625000000000000000000000000000000000000000000000e-4 * t177 * t390 * t195 * t198 + 0.63020833333333333333333333333333333333333333333333e-6 * t181 * t415 + 0.71489257812500000000000000000000000000000000000000e-9 * t420 * t423 * t195 * t426
  t435 = f.my_piecewise3(t155, 0, -0.3e1 / 0.8e1 * t5 * t374 * t202 - t211 - 0.3e1 / 0.8e1 * t5 * t378 * t430)
  t439 = 0.2e1 * t222
  t440 = f.my_piecewise5(t10, 0, t14, 0, t439)
  t444 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t216 * t359 * t26 + 0.4e1 / 0.3e1 * t21 * t440)
  t451 = t5 * t362 * t89 * t80
  t459 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t444 * t30 * t80 - t451 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t363 * t148 - t236 / 0.8e1 + t246 - t248 / 0.8e1)
  t463 = f.my_piecewise5(t14, 0, t10, 0, -t439)
  t467 = f.my_piecewise3(t158, 0, 0.4e1 / 0.9e1 * t332 * t370 * t161 + 0.4e1 / 0.3e1 * t159 * t463)
  t474 = t5 * t373 * t89 * t202
  t481 = t5 * t208 * t430
  t484 = f.my_piecewise3(t155, 0, -0.3e1 / 0.8e1 * t5 * t467 * t30 * t202 - t474 / 0.8e1 - t348 / 0.8e1 + t353 - 0.3e1 / 0.8e1 * t5 * t165 * t430 - t481 / 0.8e1)
  d12 = t153 + t213 + t368 + t435 + t6 * (t459 + t484)
  t489 = t359 ** 2
  t493 = 0.2e1 * t23 + 0.2e1 * t222
  t494 = f.my_piecewise5(t10, 0, t14, 0, t493)
  t498 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t216 * t489 + 0.4e1 / 0.3e1 * t21 * t494)
  t505 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t498 * t30 * t80 - t451 / 0.4e1 + t246)
  t506 = t370 ** 2
  t510 = f.my_piecewise5(t14, 0, t10, 0, -t493)
  t514 = f.my_piecewise3(t158, 0, 0.4e1 / 0.9e1 * t332 * t506 + 0.4e1 / 0.3e1 * t159 * t510)
  t526 = s2 / t168 / t178
  t542 = 0.1e1 / t421 / t166
  t546 = t179 * t166
  t547 = 0.1e1 / t546
  t548 = t177 * t547
  t564 = t414 ** 2
  t586 = t418 ** 2
  t597 = 0.38436625514403292181069958847736625514403292181071e-1 * t37 * t526 * t184 - 0.15855108024691358024691358024691358024691358024692e-5 * t37 * t418 / t168 / t179 / t178 * t387 * t48 + 0.11438281250000000000000000000000000000000000000000e-7 * t174 / t386 / t183 * t420 * t542 - 0.68062500000000000000000000000000000000000000000000e-3 * t388 * t548 + 0.68062500000000000000000000000000000000000000000000e-3 * t177 * t547 * t195 * t198 - 0.10083333333333333333333333333333333333333333333333e-4 * t391 * t415 - 0.17872314453125000000000000000000000000000000000000e-7 * t420 * t542 * t195 * t426 - 0.58819444444444444444444444444444444444444444444444e-6 * t181 / t402 / t194 * t198 * t564 + 0.95319010416666666666666666666666666666666666666666e-10 * t420 * t423 * t403 * t426 * t414 + 0.63020833333333333333333333333333333333333333333333e-6 * t181 * t404 * (0.75411111111111111111111111111111111111111111111112e0 * t37 * t526 + 0.10162654320987654320987654320987654320987654320987e1 * t64 * t175 / t167 / t178 / t379 + 0.50937500000000000000000000000000000000000000000000e-2 * t548) + 0.10812750244140625000000000000000000000000000000000e-12 * t313 * t586 * s2 / t421 / t546 * t195 / t425 / t197
  t602 = f.my_piecewise3(t155, 0, -0.3e1 / 0.8e1 * t5 * t514 * t30 * t202 - t474 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t374 * t430 + t353 - t481 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t378 * t597)
  d22 = 0.2e1 * t368 + 0.2e1 * t435 + t6 * (t505 + t602)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 6 ** (0.1e1 / 0.3e1)
  t45 = jnp.pi ** 2
  t46 = t45 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t49 = t44 / t47
  t50 = r0 ** 2
  t51 = r0 ** (0.1e1 / 0.3e1)
  t52 = t51 ** 2
  t56 = t49 * s0 / t52 / t50
  t58 = 0.1e1 + 0.39310185185185185185185185185185185185185185185185e-2 * t56
  t59 = t45 ** 2
  t60 = 0.1e1 / t59
  t61 = s0 ** 2
  t62 = t61 * s0
  t63 = t60 * t62
  t64 = t50 ** 2
  t65 = t64 ** 2
  t66 = 0.1e1 / t65
  t67 = t63 * t66
  t68 = 0.94531250000000000000000000000000000000000000000000e-5 * t67
  t69 = 0.1e1 + t68
  t70 = 0.1e1 / t69
  t73 = t44 ** 2
  t76 = t73 / t46 / t45
  t77 = t64 * r0
  t84 = 0.1e1 + 0.77125000000000000000000000000000000000000000000002e-1 * t56 + 0.30086805555555555555555555555555555555555555555555e-1 * t76 * t61 / t51 / t77 + 0.70746527777777777777777777777777777777777777777778e-4 * t67
  t85 = t84 ** (0.1e1 / 0.15e2)
  t87 = 0.115e1 + t68
  t88 = 0.1e1 / t87
  t92 = t58 * t70 + 0.94531250000000000000000000000000000000000000000000e-5 * t63 * t66 * t85 * t88
  t98 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t99 = t42 ** 2
  t100 = 0.1e1 / t99
  t101 = t98 * t100
  t105 = t98 * t42
  t106 = t50 * r0
  t109 = s0 / t52 / t106
  t113 = t69 ** 2
  t114 = 0.1e1 / t113
  t115 = t58 * t114
  t117 = 0.1e1 / t65 / r0
  t118 = t63 * t117
  t125 = t85 ** 2
  t126 = t125 ** 2
  t128 = t126 ** 2
  t129 = t128 * t126 * t125
  t130 = 0.1e1 / t129
  t131 = t130 * t88
  t141 = -0.20566666666666666666666666666666666666666666666667e0 * t49 * t109 - 0.16046296296296296296296296296296296296296296296296e0 * t76 * t61 / t51 / t64 / t50 - 0.56597222222222222222222222222222222222222222222222e-3 * t118
  t142 = t131 * t141
  t145 = t59 ** 2
  t146 = 0.1e1 / t145
  t147 = t61 ** 2
  t149 = t146 * t147 * t61
  t150 = t65 ** 2
  t152 = 0.1e1 / t150 / r0
  t154 = t87 ** 2
  t155 = 0.1e1 / t154
  t159 = -0.10482716049382716049382716049382716049382716049383e-1 * t49 * t109 * t70 + 0.75625000000000000000000000000000000000000000000000e-4 * t115 * t118 - 0.75625000000000000000000000000000000000000000000000e-4 * t63 * t117 * t85 * t88 + 0.63020833333333333333333333333333333333333333333333e-6 * t67 * t142 + 0.71489257812500000000000000000000000000000000000000e-9 * t149 * t152 * t85 * t155
  t163 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t164 = t163 * f.p.zeta_threshold
  t166 = f.my_piecewise3(t20, t164, t21 * t19)
  t168 = 0.1e1 / t99 / t6
  t169 = t166 * t168
  t173 = t166 * t100
  t177 = t166 * t42
  t180 = s0 / t52 / t64
  t184 = t49 * t147
  t193 = 0.1e1 / t113 / t69
  t194 = t58 * t193
  t196 = 0.1e1 / t150 / t50
  t197 = t149 * t196
  t200 = t65 * t50
  t201 = 0.1e1 / t200
  t202 = t63 * t201
  t216 = 0.1e1 / t129 / t84
  t217 = t216 * t88
  t218 = t141 ** 2
  t219 = t217 * t218
  t222 = t149 * t152
  t223 = t130 * t155
  t224 = t223 * t141
  t236 = 0.75411111111111111111111111111111111111111111111112e0 * t49 * t180 + 0.10162654320987654320987654320987654320987654320987e1 * t76 * t61 / t51 / t64 / t106 + 0.50937500000000000000000000000000000000000000000000e-2 * t202
  t237 = t131 * t236
  t242 = t147 ** 2
  t244 = 0.1e1 / t145 / t59 * t242 * s0
  t246 = 0.1e1 / t150 / t200
  t249 = 0.1e1 / t154 / t87
  t253 = 0.38436625514403292181069958847736625514403292181071e-1 * t49 * t180 * t70 - 0.15855108024691358024691358024691358024691358024692e-5 * t184 / t52 / t65 / t64 * t114 * t60 + 0.11438281250000000000000000000000000000000000000000e-7 * t194 * t197 - 0.68062500000000000000000000000000000000000000000000e-3 * t115 * t202 + 0.68062500000000000000000000000000000000000000000000e-3 * t63 * t201 * t85 * t88 - 0.10083333333333333333333333333333333333333333333333e-4 * t118 * t142 - 0.17872314453125000000000000000000000000000000000000e-7 * t149 * t196 * t85 * t155 - 0.58819444444444444444444444444444444444444444444444e-6 * t67 * t219 + 0.95319010416666666666666666666666666666666666666666e-10 * t222 * t224 + 0.63020833333333333333333333333333333333333333333333e-6 * t67 * t237 + 0.10812750244140625000000000000000000000000000000000e-12 * t244 * t246 * t85 * t249
  t258 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t92 - t5 * t101 * t92 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t105 * t159 + t5 * t169 * t92 / 0.12e2 - t5 * t173 * t159 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t177 * t253)
  t260 = r1 <= f.p.dens_threshold
  t261 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t262 = 0.1e1 + t261
  t263 = t262 <= f.p.zeta_threshold
  t264 = t262 ** (0.1e1 / 0.3e1)
  t265 = t264 ** 2
  t266 = 0.1e1 / t265
  t268 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t269 = t268 ** 2
  t273 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t277 = f.my_piecewise3(t263, 0, 0.4e1 / 0.9e1 * t266 * t269 + 0.4e1 / 0.3e1 * t264 * t273)
  t279 = r1 ** 2
  t280 = r1 ** (0.1e1 / 0.3e1)
  t281 = t280 ** 2
  t285 = t49 * s2 / t281 / t279
  t288 = s2 ** 2
  t290 = t60 * t288 * s2
  t291 = t279 ** 2
  t292 = t291 ** 2
  t293 = 0.1e1 / t292
  t294 = t290 * t293
  t295 = 0.94531250000000000000000000000000000000000000000000e-5 * t294
  t308 = (0.1e1 + 0.77125000000000000000000000000000000000000000000002e-1 * t285 + 0.30086805555555555555555555555555555555555555555555e-1 * t76 * t288 / t280 / t291 / r1 + 0.70746527777777777777777777777777777777777777777778e-4 * t294) ** (0.1e1 / 0.15e2)
  t315 = (0.1e1 + 0.39310185185185185185185185185185185185185185185185e-2 * t285) / (0.1e1 + t295) + 0.94531250000000000000000000000000000000000000000000e-5 * t290 * t293 * t308 / (0.115e1 + t295)
  t321 = f.my_piecewise3(t263, 0, 0.4e1 / 0.3e1 * t264 * t268)
  t327 = f.my_piecewise3(t263, t164, t264 * t262)
  t333 = f.my_piecewise3(t260, 0, -0.3e1 / 0.8e1 * t5 * t277 * t42 * t315 - t5 * t321 * t100 * t315 / 0.4e1 + t5 * t327 * t168 * t315 / 0.12e2)
  t343 = t24 ** 2
  t347 = 0.6e1 * t33 - 0.6e1 * t16 / t343
  t348 = f.my_piecewise5(t10, 0, t14, 0, t347)
  t352 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t348)
  t375 = 0.1e1 / t99 / t24
  t386 = t84 ** 2
  t400 = t113 ** 2
  t403 = t65 * t106
  t405 = 0.1e1 / t150 / t403
  t410 = 0.1e1 / t150 / t106
  t419 = t145 ** 2
  t423 = t150 ** 2
  t427 = t154 ** 2
  t434 = s0 / t52 / t77
  t457 = 0.1e1 / t403
  t458 = t63 * t457
  t495 = 0.11371759259259259259259259259259259259259259259259e-5 * t67 / t129 / t386 * t88 * t218 * t141 - 0.17645833333333333333333333333333333333333333333333e-5 * t67 * t217 * t141 * t236 + 0.14116666666666666666666666666666666666666666666666e-4 * t118 * t219 + 0.25950600585937500000000000000000000000000000000000e-11 * t58 / t400 * t244 * t405 + 0.37317392578125000000000000000000000000000000000000e-6 * t149 * t410 * t85 * t155 - 0.55145026245117187500000000000000000000000000000000e-11 * t244 * t405 * t85 * t249 + 0.24531427116394042968750000000000000000000000000000e-16 / t419 * t242 * t147 / t423 / t106 * t85 / t427 - 0.17937091906721536351165980795610425240054869684500e0 * t49 * t434 * t70 + 0.30124705246913580246913580246913580246913580246915e-4 * t184 / t52 / t65 / t77 * t114 * t60 - 0.35971276331018518518518518518518518518518518518520e-9 * t49 * t147 * t62 / t52 / t150 / t77 * t193 * t146 - 0.30883359375000000000000000000000000000000000000000e-6 * t194 * t149 * t410 + 0.68062500000000000000000000000000000000000000000000e-2 * t115 * t458 - 0.68062500000000000000000000000000000000000000000000e-2 * t63 * t457 * t85 * t88 + 0.13612500000000000000000000000000000000000000000000e-3 * t202 * t142 - 0.15125000000000000000000000000000000000000000000000e-4 * t118 * t237 - 0.35744628906249999999999999999999999999999999999999e-8 * t197 * t224 - 0.13344661458333333333333333333333333333333333333333e-9 * t222 * t216 * t155 * t218 + 0.14297851562500000000000000000000000000000000000000e-9 * t222 * t223 * t236 + 0.21625500488281250000000000000000000000000000000000e-13 * t244 * t246 * t130 * t249 * t141 + 0.63020833333333333333333333333333333333333333333333e-6 * t67 * t131 * (-0.35191851851851851851851851851851851851851851851852e1 * t49 * t434 - 0.74526131687242798353909465020576131687242798353905e1 * t76 * t61 / t51 / t65 - 0.50937500000000000000000000000000000000000000000000e-1 * t458)
  t500 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t352 * t42 * t92 - 0.3e1 / 0.8e1 * t5 * t41 * t100 * t92 - 0.9e1 / 0.8e1 * t5 * t43 * t159 + t5 * t98 * t168 * t92 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t101 * t159 - 0.9e1 / 0.8e1 * t5 * t105 * t253 - 0.5e1 / 0.36e2 * t5 * t166 * t375 * t92 + t5 * t169 * t159 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t173 * t253 - 0.3e1 / 0.8e1 * t5 * t177 * t495)
  t510 = f.my_piecewise5(t14, 0, t10, 0, -t347)
  t514 = f.my_piecewise3(t263, 0, -0.8e1 / 0.27e2 / t265 / t262 * t269 * t268 + 0.4e1 / 0.3e1 * t266 * t268 * t273 + 0.4e1 / 0.3e1 * t264 * t510)
  t532 = f.my_piecewise3(t260, 0, -0.3e1 / 0.8e1 * t5 * t514 * t42 * t315 - 0.3e1 / 0.8e1 * t5 * t277 * t100 * t315 + t5 * t321 * t168 * t315 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t327 * t375 * t315)
  d111 = 0.3e1 * t258 + 0.3e1 * t333 + t6 * (t500 + t532)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 0.1e1 / t22 / t19
  t25 = t6 ** 2
  t26 = 0.1e1 / t25
  t28 = -t16 * t26 + t7
  t29 = f.my_piecewise5(t10, 0, t14, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t6
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t16 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t10, 0, t14, 0, t40)
  t44 = t25 ** 2
  t45 = 0.1e1 / t44
  t48 = -0.6e1 * t16 * t45 + 0.6e1 * t37
  t49 = f.my_piecewise5(t10, 0, t14, 0, t48)
  t53 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t24 * t30 * t29 + 0.4e1 / 0.3e1 * t35 * t41 + 0.4e1 / 0.3e1 * t21 * t49)
  t54 = t6 ** (0.1e1 / 0.3e1)
  t55 = t53 * t54
  t56 = 6 ** (0.1e1 / 0.3e1)
  t57 = jnp.pi ** 2
  t58 = t57 ** (0.1e1 / 0.3e1)
  t59 = t58 ** 2
  t61 = t56 / t59
  t62 = r0 ** 2
  t63 = r0 ** (0.1e1 / 0.3e1)
  t64 = t63 ** 2
  t68 = t61 * s0 / t64 / t62
  t70 = 0.1e1 + 0.39310185185185185185185185185185185185185185185185e-2 * t68
  t71 = t57 ** 2
  t72 = 0.1e1 / t71
  t73 = s0 ** 2
  t74 = t73 * s0
  t75 = t72 * t74
  t76 = t62 ** 2
  t77 = t76 ** 2
  t78 = 0.1e1 / t77
  t79 = t75 * t78
  t80 = 0.94531250000000000000000000000000000000000000000000e-5 * t79
  t81 = 0.1e1 + t80
  t82 = 0.1e1 / t81
  t85 = t56 ** 2
  t88 = t85 / t58 / t57
  t89 = t76 * r0
  t96 = 0.1e1 + 0.77125000000000000000000000000000000000000000000002e-1 * t68 + 0.30086805555555555555555555555555555555555555555555e-1 * t88 * t73 / t63 / t89 + 0.70746527777777777777777777777777777777777777777778e-4 * t79
  t97 = t96 ** (0.1e1 / 0.15e2)
  t99 = 0.115e1 + t80
  t100 = 0.1e1 / t99
  t104 = t70 * t82 + 0.94531250000000000000000000000000000000000000000000e-5 * t75 * t78 * t97 * t100
  t113 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t34 * t30 + 0.4e1 / 0.3e1 * t21 * t41)
  t114 = t54 ** 2
  t115 = 0.1e1 / t114
  t116 = t113 * t115
  t120 = t113 * t54
  t121 = t62 * r0
  t124 = s0 / t64 / t121
  t128 = t81 ** 2
  t129 = 0.1e1 / t128
  t130 = t70 * t129
  t131 = t77 * r0
  t132 = 0.1e1 / t131
  t133 = t75 * t132
  t140 = t97 ** 2
  t141 = t140 ** 2
  t143 = t141 ** 2
  t144 = t143 * t141 * t140
  t145 = 0.1e1 / t144
  t146 = t145 * t100
  t149 = t76 * t62
  t156 = -0.20566666666666666666666666666666666666666666666667e0 * t61 * t124 - 0.16046296296296296296296296296296296296296296296296e0 * t88 * t73 / t63 / t149 - 0.56597222222222222222222222222222222222222222222222e-3 * t133
  t157 = t146 * t156
  t160 = t71 ** 2
  t161 = 0.1e1 / t160
  t162 = t73 ** 2
  t164 = t161 * t162 * t73
  t165 = t77 ** 2
  t167 = 0.1e1 / t165 / r0
  t169 = t99 ** 2
  t170 = 0.1e1 / t169
  t174 = -0.10482716049382716049382716049382716049382716049383e-1 * t61 * t124 * t82 + 0.75625000000000000000000000000000000000000000000000e-4 * t130 * t133 - 0.75625000000000000000000000000000000000000000000000e-4 * t75 * t132 * t97 * t100 + 0.63020833333333333333333333333333333333333333333333e-6 * t79 * t157 + 0.71489257812500000000000000000000000000000000000000e-9 * t164 * t167 * t97 * t170
  t180 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t29)
  t182 = 0.1e1 / t114 / t6
  t183 = t180 * t182
  t187 = t180 * t115
  t191 = t180 * t54
  t194 = s0 / t64 / t76
  t198 = t61 * t162
  t199 = t77 * t76
  t207 = 0.1e1 / t128 / t81
  t208 = t70 * t207
  t210 = 0.1e1 / t165 / t62
  t211 = t164 * t210
  t214 = t77 * t62
  t215 = 0.1e1 / t214
  t216 = t75 * t215
  t230 = 0.1e1 / t144 / t96
  t231 = t230 * t100
  t232 = t156 ** 2
  t233 = t231 * t232
  t236 = t164 * t167
  t237 = t145 * t170
  t238 = t237 * t156
  t250 = 0.75411111111111111111111111111111111111111111111112e0 * t61 * t194 + 0.10162654320987654320987654320987654320987654320987e1 * t88 * t73 / t63 / t76 / t121 + 0.50937500000000000000000000000000000000000000000000e-2 * t216
  t251 = t146 * t250
  t255 = 0.1e1 / t160 / t71
  t256 = t162 ** 2
  t258 = t255 * t256 * s0
  t260 = 0.1e1 / t165 / t214
  t263 = 0.1e1 / t169 / t99
  t267 = 0.38436625514403292181069958847736625514403292181071e-1 * t61 * t194 * t82 - 0.15855108024691358024691358024691358024691358024692e-5 * t198 / t64 / t199 * t129 * t72 + 0.11438281250000000000000000000000000000000000000000e-7 * t208 * t211 - 0.68062500000000000000000000000000000000000000000000e-3 * t130 * t216 + 0.68062500000000000000000000000000000000000000000000e-3 * t75 * t215 * t97 * t100 - 0.10083333333333333333333333333333333333333333333333e-4 * t133 * t157 - 0.17872314453125000000000000000000000000000000000000e-7 * t164 * t210 * t97 * t170 - 0.58819444444444444444444444444444444444444444444444e-6 * t79 * t233 + 0.95319010416666666666666666666666666666666666666666e-10 * t236 * t238 + 0.63020833333333333333333333333333333333333333333333e-6 * t79 * t251 + 0.10812750244140625000000000000000000000000000000000e-12 * t258 * t260 * t97 * t263
  t271 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t272 = t271 * f.p.zeta_threshold
  t274 = f.my_piecewise3(t20, t272, t21 * t19)
  t276 = 0.1e1 / t114 / t25
  t277 = t274 * t276
  t281 = t274 * t182
  t285 = t274 * t115
  t289 = t274 * t54
  t290 = t96 ** 2
  t292 = 0.1e1 / t144 / t290
  t293 = t292 * t100
  t294 = t232 * t156
  t295 = t293 * t294
  t298 = t156 * t250
  t299 = t231 * t298
  t304 = t128 ** 2
  t305 = 0.1e1 / t304
  t306 = t70 * t305
  t307 = t77 * t121
  t309 = 0.1e1 / t165 / t307
  t310 = t258 * t309
  t314 = 0.1e1 / t165 / t121
  t323 = t160 ** 2
  t326 = 0.1e1 / t323 * t256 * t162
  t327 = t165 ** 2
  t329 = 0.1e1 / t327 / t121
  t331 = t169 ** 2
  t332 = 0.1e1 / t331
  t338 = s0 / t64 / t89
  t349 = t162 * t74
  t350 = t61 * t349
  t358 = t164 * t314
  t361 = 0.1e1 / t307
  t362 = t75 * t361
  t375 = t230 * t170
  t376 = t375 * t232
  t379 = t237 * t250
  t382 = t258 * t260
  t383 = t145 * t263
  t384 = t383 * t156
  t395 = -0.35191851851851851851851851851851851851851851851852e1 * t61 * t338 - 0.74526131687242798353909465020576131687242798353905e1 * t88 * t73 / t63 / t77 - 0.50937500000000000000000000000000000000000000000000e-1 * t362
  t396 = t146 * t395
  t399 = 0.11371759259259259259259259259259259259259259259259e-5 * t79 * t295 - 0.17645833333333333333333333333333333333333333333333e-5 * t79 * t299 + 0.14116666666666666666666666666666666666666666666666e-4 * t133 * t233 + 0.25950600585937500000000000000000000000000000000000e-11 * t306 * t310 + 0.37317392578125000000000000000000000000000000000000e-6 * t164 * t314 * t97 * t170 - 0.55145026245117187500000000000000000000000000000000e-11 * t258 * t309 * t97 * t263 + 0.24531427116394042968750000000000000000000000000000e-16 * t326 * t329 * t97 * t332 - 0.17937091906721536351165980795610425240054869684500e0 * t61 * t338 * t82 + 0.30124705246913580246913580246913580246913580246915e-4 * t198 / t64 / t77 / t89 * t129 * t72 - 0.35971276331018518518518518518518518518518518518520e-9 * t350 / t64 / t165 / t89 * t207 * t161 - 0.30883359375000000000000000000000000000000000000000e-6 * t208 * t358 + 0.68062500000000000000000000000000000000000000000000e-2 * t130 * t362 - 0.68062500000000000000000000000000000000000000000000e-2 * t75 * t361 * t97 * t100 + 0.13612500000000000000000000000000000000000000000000e-3 * t216 * t157 - 0.15125000000000000000000000000000000000000000000000e-4 * t133 * t251 - 0.35744628906249999999999999999999999999999999999999e-8 * t211 * t238 - 0.13344661458333333333333333333333333333333333333333e-9 * t236 * t376 + 0.14297851562500000000000000000000000000000000000000e-9 * t236 * t379 + 0.21625500488281250000000000000000000000000000000000e-13 * t382 * t384 + 0.63020833333333333333333333333333333333333333333333e-6 * t79 * t396
  t404 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t55 * t104 - 0.3e1 / 0.8e1 * t5 * t116 * t104 - 0.9e1 / 0.8e1 * t5 * t120 * t174 + t5 * t183 * t104 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t187 * t174 - 0.9e1 / 0.8e1 * t5 * t191 * t267 - 0.5e1 / 0.36e2 * t5 * t277 * t104 + t5 * t281 * t174 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t285 * t267 - 0.3e1 / 0.8e1 * t5 * t289 * t399)
  t406 = r1 <= f.p.dens_threshold
  t407 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t408 = 0.1e1 + t407
  t409 = t408 <= f.p.zeta_threshold
  t410 = t408 ** (0.1e1 / 0.3e1)
  t411 = t410 ** 2
  t413 = 0.1e1 / t411 / t408
  t415 = f.my_piecewise5(t14, 0, t10, 0, -t28)
  t416 = t415 ** 2
  t420 = 0.1e1 / t411
  t421 = t420 * t415
  t423 = f.my_piecewise5(t14, 0, t10, 0, -t40)
  t427 = f.my_piecewise5(t14, 0, t10, 0, -t48)
  t431 = f.my_piecewise3(t409, 0, -0.8e1 / 0.27e2 * t413 * t416 * t415 + 0.4e1 / 0.3e1 * t421 * t423 + 0.4e1 / 0.3e1 * t410 * t427)
  t433 = r1 ** 2
  t434 = r1 ** (0.1e1 / 0.3e1)
  t435 = t434 ** 2
  t439 = t61 * s2 / t435 / t433
  t442 = s2 ** 2
  t444 = t72 * t442 * s2
  t445 = t433 ** 2
  t446 = t445 ** 2
  t447 = 0.1e1 / t446
  t448 = t444 * t447
  t449 = 0.94531250000000000000000000000000000000000000000000e-5 * t448
  t462 = (0.1e1 + 0.77125000000000000000000000000000000000000000000002e-1 * t439 + 0.30086805555555555555555555555555555555555555555555e-1 * t88 * t442 / t434 / t445 / r1 + 0.70746527777777777777777777777777777777777777777778e-4 * t448) ** (0.1e1 / 0.15e2)
  t469 = (0.1e1 + 0.39310185185185185185185185185185185185185185185185e-2 * t439) / (0.1e1 + t449) + 0.94531250000000000000000000000000000000000000000000e-5 * t444 * t447 * t462 / (0.115e1 + t449)
  t478 = f.my_piecewise3(t409, 0, 0.4e1 / 0.9e1 * t420 * t416 + 0.4e1 / 0.3e1 * t410 * t423)
  t485 = f.my_piecewise3(t409, 0, 0.4e1 / 0.3e1 * t410 * t415)
  t491 = f.my_piecewise3(t409, t272, t410 * t408)
  t497 = f.my_piecewise3(t406, 0, -0.3e1 / 0.8e1 * t5 * t431 * t54 * t469 - 0.3e1 / 0.8e1 * t5 * t478 * t115 * t469 + t5 * t485 * t182 * t469 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t491 * t276 * t469)
  t500 = 0.1e1 / t114 / t36
  t524 = 0.1e1 / t165 / t199
  t529 = 0.1e1 / t165 / t76
  t538 = 0.1e1 / t327 / t76
  t564 = s0 / t64 / t149
  t571 = 0.1e1 / t199
  t572 = t75 * t571
  t598 = t77 * t149
  t616 = -0.14013324316406250000000000000000000000000000000000e-9 * t306 * t258 * t524 - 0.76050272460937500000000000000000000000000000000000e-5 * t164 * t529 * t97 * t170 + 0.78500566772460937500000000000000000000000000000000e-15 * t70 / t304 / t81 * t326 * t538 + 0.20533412713623046875000000000000000000000000000000e-9 * t258 * t524 * t97 * t263 - 0.21097027320098876953125000000000000000000000000000e-14 * t326 * t538 * t97 * t332 + 0.74207567027091979980468750000000000000000000000000e-20 / t323 / t71 * t256 * t349 / t327 / t199 * t97 / t331 / t99 + 0.10164352080475537265660722450845907636031092821217e1 * t61 * t564 * t82 + 0.68972835937500000000000000000000000000000000000000e-5 * t208 * t164 * t529 - 0.74868750000000000000000000000000000000000000000000e-1 * t130 * t572 + 0.74868750000000000000000000000000000000000000000000e-1 * t75 * t571 * t97 * t100 + 0.63020833333333333333333333333333333333333333333333e-6 * t79 * t146 * (0.19942049382716049382716049382716049382716049382716e2 * t61 * t564 + 0.62105109739368998628257887517146776406035665294921e2 * t88 * t73 / t63 / t131 + 0.56031250000000000000000000000000000000000000000000e0 * t572) - 0.14705340332031250000000000000000000000000000000000e-11 * t310 * t384 + 0.65417138977050781250000000000000000000000000000000e-17 * t326 * t329 * t145 * t332 * t156 - 0.49661721690672153635116598079561042524005486968452e-3 * t198 / t64 / t598 * t129 * t72 + 0.15587553076774691358024691358024691358024691358026e-7 * t350 / t64 / t165 / t149 * t207 * t161 - 0.18150000000000000000000000000000000000000000000000e-2 * t362 * t157 + 0.27225000000000000000000000000000000000000000000000e-3 * t216 * t251
  t640 = t232 ** 2
  t644 = t250 ** 2
  t677 = 0.34399571759259259259259259259259259259259259259259e-9 * t236 * t292 * t170 * t294 + 0.66723307291666666666666666666666666666666666666664e-8 * t211 * t376 - 0.10881311090133101851851851851851851851851851851852e-12 * t61 * t256 * t73 / t64 / t165 / t598 * t305 * t255 + 0.99513046874999999999999999999999999999999999999998e-7 * t358 * t238 - 0.36389629629629629629629629629629629629629629629628e-4 * t133 * t295 - 0.33357160493827160493827160493827160493827160493826e-5 * t79 / t144 / t290 / t96 * t100 * t640 - 0.17645833333333333333333333333333333333333333333333e-5 * t79 * t231 * t644 - 0.25409999999999999999999999999999999999999999999999e-3 * t216 * t233 - 0.20166666666666666666666666666666666666666666666667e-4 * t133 * t396 - 0.71489257812499999999999999999999999999999999999999e-8 * t211 * t379 - 0.40367600911458333333333333333333333333333333333333e-13 * t382 * t230 * t263 * t232 + 0.19063802083333333333333333333333333333333333333333e-9 * t236 * t237 * t395 + 0.43251000976562500000000000000000000000000000000000e-13 * t382 * t383 * t250 + 0.68230555555555555555555555555555555555555555555554e-5 * t79 * t293 * t232 * t250 - 0.23527777777777777777777777777777777777777777777777e-5 * t79 * t231 * t156 * t395 - 0.53378645833333333333333333333333333333333333333332e-9 * t236 * t375 * t298 + 0.56466666666666666666666666666666666666666666666665e-4 * t133 * t299
  t693 = t19 ** 2
  t696 = t30 ** 2
  t702 = t41 ** 2
  t711 = -0.24e2 * t45 + 0.24e2 * t16 / t44 / t6
  t712 = f.my_piecewise5(t10, 0, t14, 0, t711)
  t716 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t22 / t693 * t696 - 0.16e2 / 0.9e1 * t24 * t30 * t41 + 0.4e1 / 0.3e1 * t34 * t702 + 0.16e2 / 0.9e1 * t35 * t49 + 0.4e1 / 0.3e1 * t21 * t712)
  t730 = 0.10e2 / 0.27e2 * t5 * t274 * t500 * t104 - 0.5e1 / 0.9e1 * t5 * t180 * t276 * t104 - t5 * t53 * t115 * t104 / 0.2e1 + t5 * t113 * t182 * t104 / 0.2e1 + t5 * t281 * t267 / 0.2e1 - t5 * t285 * t399 / 0.2e1 - 0.3e1 / 0.8e1 * t5 * t289 * (t616 + t677) + t5 * t183 * t174 - 0.3e1 / 0.2e1 * t5 * t187 * t267 - 0.3e1 / 0.2e1 * t5 * t191 * t399 - 0.5e1 / 0.9e1 * t5 * t277 * t174 - 0.3e1 / 0.8e1 * t5 * t716 * t54 * t104 - 0.3e1 / 0.2e1 * t5 * t55 * t174 - 0.3e1 / 0.2e1 * t5 * t116 * t174 - 0.9e1 / 0.4e1 * t5 * t120 * t267
  t731 = f.my_piecewise3(t1, 0, t730)
  t732 = t408 ** 2
  t735 = t416 ** 2
  t741 = t423 ** 2
  t747 = f.my_piecewise5(t14, 0, t10, 0, -t711)
  t751 = f.my_piecewise3(t409, 0, 0.40e2 / 0.81e2 / t411 / t732 * t735 - 0.16e2 / 0.9e1 * t413 * t416 * t423 + 0.4e1 / 0.3e1 * t420 * t741 + 0.16e2 / 0.9e1 * t421 * t427 + 0.4e1 / 0.3e1 * t410 * t747)
  t773 = f.my_piecewise3(t406, 0, -0.3e1 / 0.8e1 * t5 * t751 * t54 * t469 - t5 * t431 * t115 * t469 / 0.2e1 + t5 * t478 * t182 * t469 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t485 * t276 * t469 + 0.10e2 / 0.27e2 * t5 * t491 * t500 * t469)
  d1111 = 0.4e1 * t404 + 0.4e1 * t497 + t6 * (t731 + t773)

  res = {'v4rho4': d1111}
  return res
