"""Generated from gga_xc_th2.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_n = 19

  params_a = [None, 13 / 12, 7 / 6, 8 / 6, 9 / 6, 10 / 6, 17 / 12, 9 / 6, 10 / 6, 11 / 6, 10 / 6, 11 / 6, 12 / 6, 10 / 6, 11 / 6, 12 / 6, 7 / 6, 8 / 6, 9 / 6, 10 / 6.0]

  params_b = np.array([np.nan, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1], dtype=np.float64)

  params_c = np.array([np.nan, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0], dtype=np.float64)

  params_d = np.array([np.nan, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0], dtype=np.float64)

  params_omega = np.array([np.nan, +0.678831, -1.75821, +1.27676, -1.60789, +0.36561, -0.181327, +0.146973, +0.147141, -0.0716917, -0.0407167, +0.0214625, -0.000768156, +0.0310377, -0.0720326, +0.0446562, -0.266802, +1.50822, -1.94515, +0.679078], dtype=np.float64)

  XX = lambda z, xs: xs * f.opz_pow_n(z, 4 / 3) * 2 ** (-4 / 3)

  YY = lambda z, xt, xs0, xs1: 2 * (XX(z, xs0) ** 2 + XX(-z, xs1) ** 2) - xt ** 2

  f_th = lambda rs, z, xt, xs0, xs1: jnp.sum(jnp.array([params_omega[i] * (f.n_spin(rs, z) ** params_a[i] + f.n_spin(rs, -z) ** params_a[i]) * z ** (2 * params_b[i]) * 1 / 2 * (XX(z, xs0) ** params_c[i] + XX(-z, xs1) ** params_c[i]) * YY(z, xt, xs0, xs1) ** params_d[i] for i in range(1, params_n + 1)]), axis=0) / f.n_total(rs)

  functional_body = lambda rs, z, xt, xs0, xs1: f_th(rs, z, xt, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_n = 19

  params_a = [None, 13 / 12, 7 / 6, 8 / 6, 9 / 6, 10 / 6, 17 / 12, 9 / 6, 10 / 6, 11 / 6, 10 / 6, 11 / 6, 12 / 6, 10 / 6, 11 / 6, 12 / 6, 7 / 6, 8 / 6, 9 / 6, 10 / 6.0]

  params_b = np.array([np.nan, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1], dtype=np.float64)

  params_c = np.array([np.nan, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0], dtype=np.float64)

  params_d = np.array([np.nan, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0], dtype=np.float64)

  params_omega = np.array([np.nan, +0.678831, -1.75821, +1.27676, -1.60789, +0.36561, -0.181327, +0.146973, +0.147141, -0.0716917, -0.0407167, +0.0214625, -0.000768156, +0.0310377, -0.0720326, +0.0446562, -0.266802, +1.50822, -1.94515, +0.679078], dtype=np.float64)

  XX = lambda z, xs: xs * f.opz_pow_n(z, 4 / 3) * 2 ** (-4 / 3)

  YY = lambda z, xt, xs0, xs1: 2 * (XX(z, xs0) ** 2 + XX(-z, xs1) ** 2) - xt ** 2

  f_th = lambda rs, z, xt, xs0, xs1: jnp.sum(jnp.array([params_omega[i] * (f.n_spin(rs, z) ** params_a[i] + f.n_spin(rs, -z) ** params_a[i]) * z ** (2 * params_b[i]) * 1 / 2 * (XX(z, xs0) ** params_c[i] + XX(-z, xs1) ** params_c[i]) * YY(z, xt, xs0, xs1) ** params_d[i] for i in range(1, params_n + 1)]), axis=0) / f.n_total(rs)

  functional_body = lambda rs, z, xt, xs0, xs1: f_th(rs, z, xt, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_n = 19

  params_a = [None, 13 / 12, 7 / 6, 8 / 6, 9 / 6, 10 / 6, 17 / 12, 9 / 6, 10 / 6, 11 / 6, 10 / 6, 11 / 6, 12 / 6, 10 / 6, 11 / 6, 12 / 6, 7 / 6, 8 / 6, 9 / 6, 10 / 6.0]

  params_b = np.array([np.nan, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1], dtype=np.float64)

  params_c = np.array([np.nan, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0], dtype=np.float64)

  params_d = np.array([np.nan, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0], dtype=np.float64)

  params_omega = np.array([np.nan, +0.678831, -1.75821, +1.27676, -1.60789, +0.36561, -0.181327, +0.146973, +0.147141, -0.0716917, -0.0407167, +0.0214625, -0.000768156, +0.0310377, -0.0720326, +0.0446562, -0.266802, +1.50822, -1.94515, +0.679078], dtype=np.float64)

  XX = lambda z, xs: xs * f.opz_pow_n(z, 4 / 3) * 2 ** (-4 / 3)

  YY = lambda z, xt, xs0, xs1: 2 * (XX(z, xs0) ** 2 + XX(-z, xs1) ** 2) - xt ** 2

  f_th = lambda rs, z, xt, xs0, xs1: jnp.sum(jnp.array([params_omega[i] * (f.n_spin(rs, z) ** params_a[i] + f.n_spin(rs, -z) ** params_a[i]) * z ** (2 * params_b[i]) * 1 / 2 * (XX(z, xs0) ** params_c[i] + XX(-z, xs1) ** params_c[i]) * YY(z, xt, xs0, xs1) ** params_d[i] for i in range(1, params_n + 1)]), axis=0) / f.n_total(rs)

  functional_body = lambda rs, z, xt, xs0, xs1: f_th(rs, z, xt, xs0, xs1)

  t1 = r0 ** (0.1e1 / 0.3e1)
  t3 = r0 ** (0.1e1 / 0.12e2)
  t5 = jnp.sqrt(r0)
  t7 = t1 ** 2
  t9 = r0 ** (0.1e1 / 0.6e1)
  t11 = jnp.sqrt(s0)
  t12 = t1 * r0
  t13 = 0.1e1 / t12
  t14 = t11 * t13
  t15 = r0 - r1
  t16 = r0 + r1
  t17 = 0.1e1 / t16
  t18 = t15 * t17
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = 2 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = t25 * t27
  t30 = jnp.sqrt(s2)
  t31 = r1 ** (0.1e1 / 0.3e1)
  t32 = t31 * r1
  t33 = 0.1e1 / t32
  t34 = t30 * t33
  t35 = 0.1e1 - t18
  t36 = t35 <= f.p.zeta_threshold
  t37 = t35 ** (0.1e1 / 0.3e1)
  t39 = f.my_piecewise3(t36, t22, t37 * t35)
  t40 = t39 * t27
  t43 = t14 * t28 / 0.4e1 + t34 * t40 / 0.4e1
  t46 = t9 ** 2
  t47 = t46 ** 2
  t48 = t47 * t9
  t49 = t48 * r0
  t51 = r1 ** (0.1e1 / 0.6e1)
  t52 = t51 ** 2
  t53 = t52 ** 2
  t54 = t53 * t51
  t55 = t54 * r1
  t57 = -0.35845850000000000000000000000000000000000000000000e-1 * t49 - 0.35845850000000000000000000000000000000000000000000e-1 * t55
  t58 = r0 ** 2
  t64 = t16 ** 2
  t65 = 0.1e1 / t64
  t66 = t15 * t65
  t67 = t17 - t66
  t70 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t67)
  t77 = f.my_piecewise3(t36, 0, -0.4e1 / 0.3e1 * t37 * t67)
  t81 = -t11 / t1 / t58 * t28 / 0.3e1 + t14 * t70 * t27 / 0.4e1 + t34 * t77 * t27 / 0.4e1
  t85 = t7 * r0
  t87 = t31 ** 2
  t88 = t87 * r1
  t90 = -0.20358350000000000000000000000000000000000000000000e-1 * t85 - 0.20358350000000000000000000000000000000000000000000e-1 * t88
  t95 = t25 ** 2
  t96 = t95 * t26
  t97 = s0 / t7 / t58 / r0 * t96
  t100 = 0.1e1 / t7 / t58
  t101 = s0 * t100
  t102 = t25 * t26
  t104 = t101 * t102 * t70
  t106 = r1 ** 2
  t108 = 0.1e1 / t87 / t106
  t109 = s2 * t108
  t110 = t39 * t26
  t112 = t109 * t110 * t77
  t114 = -t97 / 0.3e1 + t104 / 0.4e1 + t112 / 0.4e1
  t116 = t101 * t96
  t117 = t39 ** 2
  t118 = t117 * t26
  t119 = t109 * t118
  t121 = t116 / 0.8e1 + t119 / 0.8e1
  t126 = 0.10731250000000000000000000000000000000000000000000e-1 * t49 + 0.10731250000000000000000000000000000000000000000000e-1 * t55
  t132 = -0.38407800000000000000000000000000000000000000000000e-3 * t58 - 0.38407800000000000000000000000000000000000000000000e-3 * t106
  t138 = 0.31037700000000000000000000000000000000000000000000e-1 * t85 + 0.31037700000000000000000000000000000000000000000000e-1 * t88
  t143 = s0 + 0.2e1 * s1 + s2
  t144 = t64 * t16
  t145 = t16 ** (0.1e1 / 0.3e1)
  t146 = t145 ** 2
  t150 = 0.8e1 / 0.3e1 * t143 / t146 / t144
  t151 = -0.2e1 / 0.3e1 * t97 + t104 / 0.2e1 + t112 / 0.2e1 + t150
  t156 = 0.1e1 / t146 / t64
  t158 = t116 / 0.4e1 + t119 / 0.4e1 - t143 * t156
  t163 = -0.72032600000000000000000000000000000000000000000000e-1 * t49 - 0.72032600000000000000000000000000000000000000000000e-1 * t55
  t167 = 0.17023466666666666666666666666666666666666666666667e1 * t1 + 0.73540025000000000000000000000000000000000000000000e0 * t3 - 0.24118350000000000000000000000000000000000000000000e1 * t5 + 0.60935000000000000000000000000000000000000000000000e0 * t7 - 0.20512450000000000000000000000000000000000000000000e1 * t9 + 0.12261750000000000000000000000000000000000000000000e0 * t7 * t43 + t57 * t81 - 0.65717391666666666666666666666666666666666666666667e-1 * t48 * t43 + t90 * t114 - 0.33930583333333333333333333333333333333333333333333e-1 * t7 * t121 + t126 * t114 + 0.19673958333333333333333333333333333333333333333333e-1 * t48 * t121 + t132 * t114 - 0.76815600000000000000000000000000000000000000000000e-3 * r0 * t121 + t138 * t151 + 0.51729500000000000000000000000000000000000000000000e-1 * t7 * t158 + t163 * t151 - 0.13205976666666666666666666666666666666666666666667e0 * t48 * t158
  t170 = 0.44656200000000000000000000000000000000000000000000e-1 * t58 + 0.44656200000000000000000000000000000000000000000000e-1 * t106
  t174 = t3 ** 2
  t175 = t174 ** 2
  t176 = t175 * t3
  t179 = r1 ** (0.1e1 / 0.12e2)
  t180 = t179 ** 2
  t181 = t180 ** 2
  t182 = t181 * t179
  t185 = -0.90663500000000000000000000000000000000000000000000e-1 * t176 * r0 - 0.90663500000000000000000000000000000000000000000000e-1 * t182 * r1
  t189 = t5 * r0
  t191 = jnp.sqrt(r1)
  t192 = t191 * r1
  t194 = 0.73486500000000000000000000000000000000000000000000e-1 * t189 + 0.73486500000000000000000000000000000000000000000000e-1 * t192
  t200 = 0.73570500000000000000000000000000000000000000000000e-1 * t85 + 0.73570500000000000000000000000000000000000000000000e-1 * t88
  t206 = -0.266802e0 * t9 * r0 - 0.266802e0 * t51 * r1
  t209 = 0.2e1 * t206 * t15 * t65
  t210 = t15 ** 2
  t212 = 0.1e1 / t144
  t214 = 0.2e1 * t206 * t210 * t212
  t217 = 0.150822e1 * t12 + 0.150822e1 * t32
  t220 = 0.2e1 * t217 * t15 * t65
  t223 = 0.2e1 * t217 * t210 * t212
  t226 = -0.194515e1 * t189 - 0.194515e1 * t192
  t229 = 0.2e1 * t226 * t15 * t65
  t232 = 0.2e1 * t226 * t210 * t212
  t233 = r0 ** 0.16666666666666666666666666666666666666666666666667e1
  t235 = r1 ** 0.16666666666666666666666666666666666666666666666667e1
  t237 = 0.679078e0 * t233 + 0.679078e0 * t235
  t240 = 0.2e1 * t237 * t15 * t65
  t243 = 0.2e1 * t237 * t210 * t212
  t253 = r0 ** 0.6666666666666666666666666666666666666666666666667e0
  t257 = t170 * t151 + 0.89312400000000000000000000000000000000000000000000e-1 * r0 * t158 + t185 * t81 - 0.12843995833333333333333333333333333333333333333333e0 * t176 * t43 + t194 * t81 + 0.11022975000000000000000000000000000000000000000000e0 * t5 * t43 + t200 * t81 + t209 - t214 + t220 - t223 + t229 - t232 + t240 - t243 - 0.31126900000000000000000000000000000000000000000000e0 * t9 * t210 * t65 + 0.20109600000000000000000000000000000000000000000000e1 * t1 * t210 * t65 - 0.29177250000000000000000000000000000000000000000000e1 * t5 * t210 * t65 + 0.11317966666666666666666666666666666666666666666667e1 * t253 * t210 * t65
  vrho_0_ = t167 + t257
  t265 = -t17 - t66
  t268 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t265)
  t270 = t101 * t102 * t268
  t276 = s2 / t87 / t106 / r1 * t118
  t281 = f.my_piecewise3(t36, 0, -0.4e1 / 0.3e1 * t37 * t265)
  t283 = t109 * t110 * t281
  t285 = t270 / 0.2e1 - 0.2e1 / 0.3e1 * t276 + t283 / 0.2e1 + t150
  t303 = t14 * t268 * t27 / 0.4e1 - t30 / t31 / t106 * t40 / 0.3e1 + t34 * t281 * t27 / 0.4e1
  t316 = 0.17023466666666666666666666666666666666666666666667e1 * t31 - 0.24118350000000000000000000000000000000000000000000e1 * t191 + 0.73540025000000000000000000000000000000000000000000e0 * t179 + 0.60935000000000000000000000000000000000000000000000e0 * t87 - 0.20512450000000000000000000000000000000000000000000e1 * t51 + 0.51729500000000000000000000000000000000000000000000e-1 * t87 * t158 + t163 * t285 - 0.13205976666666666666666666666666666666666666666667e0 * t54 * t158 + t170 * t285 + 0.89312400000000000000000000000000000000000000000000e-1 * r1 * t158 + t185 * t303 - 0.12843995833333333333333333333333333333333333333333e0 * t182 * t43 + t194 * t303 + 0.11022975000000000000000000000000000000000000000000e0 * t191 * t43 + t200 * t303 + 0.12261750000000000000000000000000000000000000000000e0 * t87 * t43 + t57 * t303 - 0.65717391666666666666666666666666666666666666666667e-1 * t54 * t43
  t320 = t270 / 0.4e1 - t276 / 0.3e1 + t283 / 0.4e1
  t340 = r1 ** 0.6666666666666666666666666666666666666666666666667e0
  t344 = t90 * t320 - 0.33930583333333333333333333333333333333333333333333e-1 * t87 * t121 + t126 * t320 + 0.19673958333333333333333333333333333333333333333333e-1 * t54 * t121 + t132 * t320 - 0.76815600000000000000000000000000000000000000000000e-3 * r1 * t121 + t138 * t285 - t209 - t214 - t220 - t223 - t229 - t232 - t240 - t243 - 0.31126900000000000000000000000000000000000000000000e0 * t51 * t210 * t65 + 0.20109600000000000000000000000000000000000000000000e1 * t31 * t210 * t65 - 0.29177250000000000000000000000000000000000000000000e1 * t191 * t210 * t65 + 0.11317966666666666666666666666666666666666666666667e1 * t340 * t210 * t65
  vrho_1_ = t316 + t344
  t345 = 0.1e1 / t11
  t348 = t13 * t25 * t27
  t372 = t100 * t95 * t26 / 0.4e1 - t156
  vsigma_0_ = t185 * t345 * t348 / 0.8e1 + t194 * t345 * t348 / 0.8e1 + t200 * t345 * t348 / 0.8e1 + t57 * t345 * t348 / 0.8e1 + t90 * t100 * t96 / 0.8e1 + t126 * t100 * t96 / 0.8e1 + t132 * t100 * t96 / 0.8e1 + t138 * t372 + t163 * t372 + t170 * t372
  vsigma_1_ = -0.2e1 * t138 * t156 - 0.2e1 * t163 * t156 - 0.2e1 * t170 * t156
  t380 = 0.1e1 / t30
  t383 = t33 * t39 * t27
  t407 = t108 * t117 * t26 / 0.4e1 - t156
  vsigma_2_ = t185 * t380 * t383 / 0.8e1 + t194 * t380 * t383 / 0.8e1 + t200 * t380 * t383 / 0.8e1 + t57 * t380 * t383 / 0.8e1 + t90 * t108 * t118 / 0.8e1 + t126 * t108 * t118 / 0.8e1 + t132 * t108 * t118 / 0.8e1 + t138 * t407 + t163 * t407 + t170 * t407
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_n = 19

  params_a = [None, 13 / 12, 7 / 6, 8 / 6, 9 / 6, 10 / 6, 17 / 12, 9 / 6, 10 / 6, 11 / 6, 10 / 6, 11 / 6, 12 / 6, 10 / 6, 11 / 6, 12 / 6, 7 / 6, 8 / 6, 9 / 6, 10 / 6.0]

  params_b = np.array([np.nan, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1], dtype=np.float64)

  params_c = np.array([np.nan, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0], dtype=np.float64)

  params_d = np.array([np.nan, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0], dtype=np.float64)

  params_omega = np.array([np.nan, +0.678831, -1.75821, +1.27676, -1.60789, +0.36561, -0.181327, +0.146973, +0.147141, -0.0716917, -0.0407167, +0.0214625, -0.000768156, +0.0310377, -0.0720326, +0.0446562, -0.266802, +1.50822, -1.94515, +0.679078], dtype=np.float64)

  XX = lambda z, xs: xs * f.opz_pow_n(z, 4 / 3) * 2 ** (-4 / 3)

  YY = lambda z, xt, xs0, xs1: 2 * (XX(z, xs0) ** 2 + XX(-z, xs1) ** 2) - xt ** 2

  f_th = lambda rs, z, xt, xs0, xs1: jnp.sum(jnp.array([params_omega[i] * (f.n_spin(rs, z) ** params_a[i] + f.n_spin(rs, -z) ** params_a[i]) * z ** (2 * params_b[i]) * 1 / 2 * (XX(z, xs0) ** params_c[i] + XX(-z, xs1) ** params_c[i]) * YY(z, xt, xs0, xs1) ** params_d[i] for i in range(1, params_n + 1)]), axis=0) / f.n_total(rs)

  functional_body = lambda rs, z, xt, xs0, xs1: f_th(rs, z, xt, xs0, xs1)

  t1 = 2 ** (0.1e1 / 0.12e2)
  t2 = t1 ** 2
  t3 = t2 * t1
  t4 = t2 ** 2
  t5 = t4 ** 2
  t7 = r0 ** (0.1e1 / 0.12e2)
  t10 = 2 ** (0.1e1 / 0.6e1)
  t11 = t10 ** 2
  t12 = t11 ** 2
  t14 = r0 ** (0.1e1 / 0.6e1)
  t17 = 2 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t22 = jnp.sqrt(0.2e1)
  t23 = jnp.sqrt(r0)
  t26 = t19 ** 2
  t27 = t17 * t26
  t29 = t4 * t3
  t30 = t7 ** 2
  t32 = t30 ** 2
  t33 = t32 ** 2
  t37 = jnp.sqrt(s0)
  t39 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t41 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t39 * f.p.zeta_threshold, 1)
  t42 = t37 * t41
  t45 = t14 ** 2
  t46 = t45 ** 2
  t47 = t46 * t14
  t48 = 0.1e1 / t47
  t52 = 0.1e1 / t26
  t60 = r0 ** 2
  t63 = t41 ** 2
  t64 = s0 * t63
  t67 = t47 * r0
  t72 = t26 * r0
  t78 = 0.1e1 / t26 / t60
  t79 = s0 * t78
  t81 = t79 * t63 - t79
  t84 = t17 * t72
  t88 = s0 / t26 / t60 / r0
  t91 = -0.8e1 / 0.3e1 * t88 * t63 + 0.8e1 / 0.3e1 * t88
  t97 = t10 * t67
  vrho_0_ = 0.36770012500000000000000000000000000000000000000000e0 * t5 * t3 * t7 - 0.10256225000000000000000000000000000000000000000000e1 * t12 * t10 * t14 + 0.85117333333333333333333333333333333333333333333333e0 * t18 * t19 - 0.12059175000000000000000000000000000000000000000000e1 * t22 * t23 + 0.30467500000000000000000000000000000000000000000000e0 * t27 - 0.37776458333333333333333333333333333333333333333333e-2 * t29 / t33 / t30 / t7 * t42 + 0.61238750000000000000000000000000000000000000000000e-2 * t22 * t48 * t42 + 0.12261750000000000000000000000000000000000000000000e-1 * t17 * t52 * t42 - 0.89614625000000000000000000000000000000000000000000e-2 * t10 / t23 * t42 + 0.50895875000000000000000000000000000000000000000000e-2 * t17 / t60 * t64 - 0.22356770833333333333333333333333333333333333333333e-2 * t10 / t67 * t64 + 0.64013000000000000000000000000000000000000000000000e-4 / t72 * s0 * t63 + 0.25864750000000000000000000000000000000000000000000e-1 * t27 * t81 + 0.15518850000000000000000000000000000000000000000000e-1 * t84 * t91 - 0.66029883333333333333333333333333333333333333333333e-1 * t10 * t47 * t81 - 0.36016300000000000000000000000000000000000000000000e-1 * t97 * t91 + 0.44656200000000000000000000000000000000000000000000e-1 * r0 * t81 + 0.22328100000000000000000000000000000000000000000000e-1 * t60 * t91
  t106 = 0.1e1 / t37 * t41
  t128 = t78 * t63 - t78
  vsigma_0_ = -0.22665875000000000000000000000000000000000000000000e-1 * t29 * t7 * t106 + 0.18371625000000000000000000000000000000000000000000e-1 * t22 * t14 * t106 + 0.18392625000000000000000000000000000000000000000000e-1 * t17 * t19 * t106 - 0.89614625000000000000000000000000000000000000000000e-2 * t10 * t23 * t106 - 0.50895875000000000000000000000000000000000000000000e-2 * t17 / r0 * t63 + 0.26828125000000000000000000000000000000000000000000e-2 * t10 * t48 * t63 - 0.96019500000000000000000000000000000000000000000000e-4 * t52 * t63 + 0.15518850000000000000000000000000000000000000000000e-1 * t84 * t128 - 0.36016300000000000000000000000000000000000000000000e-1 * t97 * t128 + 0.22328100000000000000000000000000000000000000000000e-1 * t60 * t128
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 2 ** (0.1e1 / 0.12e2)
  t2 = t1 ** 2
  t3 = t2 * t1
  t4 = t2 ** 2
  t5 = t4 * t3
  t6 = r0 ** (0.1e1 / 0.12e2)
  t7 = t6 ** 2
  t9 = t7 ** 2
  t10 = t9 ** 2
  t11 = t10 * t7 * t6
  t15 = jnp.sqrt(s0)
  t17 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t19 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t17 * f.p.zeta_threshold, 1)
  t20 = t15 * t19
  t23 = jnp.sqrt(0.2e1)
  t24 = r0 ** (0.1e1 / 0.6e1)
  t25 = t24 ** 2
  t26 = t25 ** 2
  t27 = t26 * t24
  t28 = t27 * r0
  t29 = 0.1e1 / t28
  t33 = 2 ** (0.1e1 / 0.3e1)
  t34 = r0 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t36 = t35 * r0
  t37 = 0.1e1 / t36
  t41 = 2 ** (0.1e1 / 0.6e1)
  t42 = jnp.sqrt(r0)
  t48 = r0 ** 2
  t49 = t48 * r0
  t52 = t19 ** 2
  t53 = s0 * t52
  t62 = t33 / t34
  t64 = 0.1e1 / t35 / t48
  t65 = s0 * t64
  t66 = t65 * t52
  t67 = t66 - t65
  t75 = t33 * t35
  t77 = 0.1e1 / t35 / t49
  t78 = s0 * t77
  t81 = -0.8e1 / 0.3e1 * t78 * t52 + 0.8e1 / 0.3e1 * t78
  t85 = t33 * t36
  t86 = t48 ** 2
  t89 = s0 / t35 / t86
  t92 = 0.88e2 / 0.9e1 * t89 * t52 - 0.88e2 / 0.9e1 * t89
  t95 = t41 * t27
  t98 = t41 * t28
  t102 = t4 ** 2
  t104 = 0.1e1 / t11
  t107 = t41 ** 2
  t108 = t107 ** 2
  t110 = 0.1e1 / t27
  t113 = t33 ** 2
  t114 = 0.1e1 / t35
  t117 = 0.1e1 / t42
  t125 = 0.15518850000000000000000000000000000000000000000000e-1 * t85 * t92 - 0.13205976666666666666666666666666666666666666666667e0 * t95 * t81 - 0.36016300000000000000000000000000000000000000000000e-1 * t98 * t92 - 0.44656200000000000000000000000000000000000000000000e-1 * t65 + 0.30641677083333333333333333333333333333333333333333e-1 * t102 * t3 * t104 - 0.17093708333333333333333333333333333333333333333333e0 * t108 * t41 * t110 + 0.28372444444444444444444444444444444444444444444444e0 * t113 * t114 - 0.60295875000000000000000000000000000000000000000000e0 * t23 * t117 + 0.20311666666666666666666666666666666666666666666667e0 * t62 + 0.89312400000000000000000000000000000000000000000000e-1 * r0 * t81 + 0.22328100000000000000000000000000000000000000000000e-1 * t48 * t92
  v2rho2_0_ = 0.34628420138888888888888888888888888888888888888889e-2 * t5 / t11 / r0 * t20 - 0.51032291666666666666666666666666666666666666666667e-2 * t23 * t29 * t20 - 0.81745000000000000000000000000000000000000000000000e-2 * t33 * t37 * t20 + 0.44807312500000000000000000000000000000000000000000e-2 * t41 / t42 / r0 * t20 - 0.10179175000000000000000000000000000000000000000000e-1 * t33 / t49 * t53 + 0.40987413194444444444444444444444444444444444444444e-2 * t41 / t27 / t48 * t53 + 0.17243166666666666666666666666666666666666666666667e-1 * t62 * t67 - 0.55024902777777777777777777777777777777777777777777e-1 * t41 / t24 * t67 + 0.44549511666666666666666666666666666666666666666667e-1 * t66 + 0.51729500000000000000000000000000000000000000000000e-1 * t75 * t81 + t125
  t128 = 0.1e1 / t15 * t19
  t150 = t64 * t52 - t64
  t155 = -0.8e1 / 0.3e1 * t77 * t52 + 0.8e1 / 0.3e1 * t77
  v2rhosigma_0_ = -0.18888229166666666666666666666666666666666666666667e-2 * t5 * t104 * t128 + 0.30619375000000000000000000000000000000000000000000e-2 * t23 * t110 * t128 + 0.61308750000000000000000000000000000000000000000000e-2 * t33 * t114 * t128 - 0.44807312500000000000000000000000000000000000000000e-2 * t41 * t117 * t128 + 0.50895875000000000000000000000000000000000000000000e-2 * t33 / t48 * t52 - 0.22356770833333333333333333333333333333333333333333e-2 * t41 * t29 * t52 + 0.64013000000000000000000000000000000000000000000000e-4 * t37 * t52 + 0.25864750000000000000000000000000000000000000000000e-1 * t75 * t150 + 0.15518850000000000000000000000000000000000000000000e-1 * t85 * t155 - 0.66029883333333333333333333333333333333333333333333e-1 * t95 * t150 - 0.36016300000000000000000000000000000000000000000000e-1 * t98 * t155 + 0.44656200000000000000000000000000000000000000000000e-1 * r0 * t150 + 0.22328100000000000000000000000000000000000000000000e-1 * t48 * t155
  t169 = 0.1e1 / t15 / s0 * t19
  v2sigma2_0_ = 0.11332937500000000000000000000000000000000000000000e-1 * t5 * t6 * t169 - 0.91858125000000000000000000000000000000000000000000e-2 * t23 * t24 * t169 - 0.91963125000000000000000000000000000000000000000000e-2 * t33 * t34 * t169 + 0.44807312500000000000000000000000000000000000000000e-2 * t41 * t42 * t169
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 2 ** (0.1e1 / 0.12e2)
  t2 = t1 ** 2
  t3 = t2 * t1
  t4 = t2 ** 2
  t5 = t4 ** 2
  t7 = r0 ** (0.1e1 / 0.12e2)
  t8 = t7 ** 2
  t10 = t8 ** 2
  t11 = t10 ** 2
  t12 = t11 * t8 * t7
  t17 = 2 ** (0.1e1 / 0.6e1)
  t18 = t17 ** 2
  t19 = t18 ** 2
  t21 = r0 ** (0.1e1 / 0.6e1)
  t22 = t21 ** 2
  t23 = t22 ** 2
  t24 = t23 * t21
  t25 = t24 * r0
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = r0 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t33 = t32 * r0
  t37 = jnp.sqrt(0.2e1)
  t38 = jnp.sqrt(r0)
  t45 = t29 / t31 / r0
  t47 = r0 ** 2
  t48 = t47 ** 2
  t51 = s0 / t32 / t48
  t53 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t55 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t53 * f.p.zeta_threshold, 1)
  t56 = t55 ** 2
  t59 = 0.88e2 / 0.9e1 * t51 * t56 - 0.88e2 / 0.9e1 * t51
  t65 = s0 / t32 / t48 / r0
  t68 = -0.1232e4 / 0.27e2 * t65 * t56 + 0.1232e4 / 0.27e2 * t65
  t71 = t47 * r0
  t74 = s0 / t32 / t71
  t80 = jnp.sqrt(s0)
  t81 = t80 * t55
  t90 = 0.1e1 / t32 / t47
  t94 = -0.28088203993055555555555555555555555555555555555555e-1 * t5 * t3 / t12 / r0 + 0.14244756944444444444444444444444444444444444444444e0 * t19 * t17 / t25 - 0.18914962962962962962962962962962962962962962962963e0 * t30 / t33 + 0.30147937500000000000000000000000000000000000000000e0 * t37 / t38 / r0 - 0.67705555555555555555555555555555555555555555555557e-1 * t45 + 0.13396860000000000000000000000000000000000000000000e0 * r0 * t59 + 0.22328100000000000000000000000000000000000000000000e-1 * t47 * t68 + 0.35724960000000000000000000000000000000000000000000e0 * t74 - 0.66371138599537037037037037037037037037037037037037e-2 * t4 * t3 / t12 / t47 * t81 + 0.93559201388888888888888888888888888888888888888889e-2 * t37 / t24 / t47 * t81 + 0.13624166666666666666666666666666666666666666666667e-1 * t29 * t90 * t81
  t102 = s0 * t56
  t110 = s0 * t90
  t112 = t110 * t56 - t110
  t120 = t74 * t56
  t125 = -0.8e1 / 0.3e1 * t120 + 0.8e1 / 0.3e1 * t74
  t144 = -0.67210968750000000000000000000000000000000000000000e-2 * t17 / t38 / t47 * t81 + 0.30537525000000000000000000000000000000000000000000e-1 * t29 / t48 * t102 - 0.11613100405092592592592592592592592592592592592592e-1 * t17 / t24 / t71 * t102 - 0.57477222222222222222222222222222222222222222222223e-2 * t45 * t112 + 0.91708171296296296296296296296296296296296296296295e-2 * t17 / t21 / r0 * t112 - 0.35696509777777777777777777777777777777777777777778e0 * t120 + 0.51729500000000000000000000000000000000000000000000e-1 * t29 / t31 * t125 - 0.16507470833333333333333333333333333333333333333334e0 * t17 / t21 * t125 + 0.77594250000000000000000000000000000000000000000000e-1 * t29 * t32 * t59 + 0.15518850000000000000000000000000000000000000000000e-1 * t29 * t33 * t68 - 0.19808965000000000000000000000000000000000000000000e0 * t17 * t24 * t59 - 0.36016300000000000000000000000000000000000000000000e-1 * t17 * t25 * t68
  v3rho3_0_ = t94 + t144

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 2 ** (0.1e1 / 0.12e2)
  t2 = t1 ** 2
  t3 = t2 * t1
  t4 = t2 ** 2
  t5 = t4 ** 2
  t7 = r0 ** 2
  t8 = r0 ** (0.1e1 / 0.12e2)
  t9 = t8 ** 2
  t11 = t9 ** 2
  t12 = t11 ** 2
  t13 = t12 * t9 * t8
  t18 = 2 ** (0.1e1 / 0.6e1)
  t19 = t18 ** 2
  t20 = t19 ** 2
  t22 = r0 ** (0.1e1 / 0.6e1)
  t23 = t22 ** 2
  t24 = t23 ** 2
  t25 = t24 * t22
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = r0 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t35 = 0.1e1 / t33 / t7
  t38 = jnp.sqrt(0.2e1)
  t39 = jnp.sqrt(r0)
  t46 = t30 / t32 / t7
  t48 = t7 ** 2
  t49 = t48 * r0
  t52 = s0 / t33 / t49
  t54 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t56 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t54 * f.p.zeta_threshold, 1)
  t57 = t56 ** 2
  t60 = -0.1232e4 / 0.27e2 * t52 * t57 + 0.1232e4 / 0.27e2 * t52
  t66 = s0 / t33 / t48 / t7
  t69 = 0.20944e5 / 0.81e2 * t66 * t57 - 0.20944e5 / 0.81e2 * t66
  t74 = s0 / t33 / t48
  t77 = t7 * r0
  t81 = jnp.sqrt(s0)
  t82 = t81 * t56
  t91 = 0.1e1 / t33 / t77
  t100 = 0.53835724320023148148148148148148148148148148148147e-1 * t5 * t3 / t13 / t7 - 0.26115387731481481481481481481481481481481481481481e0 * t20 * t18 / t25 / t7 + 0.31524938271604938271604938271604938271604938271605e0 * t31 * t35 - 0.45221906250000000000000000000000000000000000000000e0 * t38 / t39 / t7 + 0.90274074074074074074074074074074074074074074074076e-1 * t46 + 0.17862480000000000000000000000000000000000000000000e0 * r0 * t60 + 0.22328100000000000000000000000000000000000000000000e-1 * t7 * t69 - 0.26198304000000000000000000000000000000000000000000e1 * t74 + 0.19358248758198302469135802469135802469135802469136e-1 * t4 * t3 / t13 / t77 * t82 - 0.26508440393518518518518518518518518518518518518519e-1 * t38 / t25 / t77 * t82 - 0.36331111111111111111111111111111111111111111111112e-1 * t30 * t91 * t82 + 0.16802742187500000000000000000000000000000000000000e-1 * t18 / t39 / t77 * t82
  t103 = s0 * t57
  t111 = s0 * t35
  t113 = t111 * t57 - t111
  t124 = s0 * t91
  t127 = -0.8e1 / 0.3e1 * t124 * t57 + 0.8e1 / 0.3e1 * t124
  t135 = t74 * t57
  t140 = 0.88e2 / 0.9e1 * t135 - 0.88e2 / 0.9e1 * t74
  t161 = -0.12215010000000000000000000000000000000000000000000e0 * t30 / t49 * t103 + 0.44516884886188271604938271604938271604938271604936e-1 * t18 / t25 / t48 * t103 + 0.76636296296296296296296296296296296296296296296297e-2 * t46 * t113 - 0.10699286651234567901234567901234567901234567901234e-1 * t18 / t22 / t7 * t113 - 0.22990888888888888888888888888888888888888888888889e-1 * t30 / t32 / r0 * t127 + 0.36683268518518518518518518518518518518518518518520e-1 * t18 / t22 / r0 * t127 + 0.26187872251851851851851851851851851851851851851852e1 * t135 + 0.10345900000000000000000000000000000000000000000000e0 * t30 / t32 * t140 - 0.33014941666666666666666666666666666666666666666667e0 * t18 / t22 * t140 + 0.10345900000000000000000000000000000000000000000000e0 * t30 * t33 * t60 + 0.15518850000000000000000000000000000000000000000000e-1 * t30 * t33 * r0 * t69 - 0.26411953333333333333333333333333333333333333333333e0 * t18 * t25 * t60 - 0.36016300000000000000000000000000000000000000000000e-1 * t18 * t25 * r0 * t69
  v4rho4_0_ = t100 + t161

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 ** (0.1e1 / 0.6e1)
  t2 = t1 ** 2
  t3 = t2 ** 2
  t4 = t3 * t1
  t5 = 0.1e1 / t4
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = 0.1e1 / t8
  t11 = r0 ** (0.1e1 / 0.12e2)
  t12 = t11 ** 2
  t13 = t12 * t11
  t14 = t12 ** 2
  t15 = t14 ** 2
  t19 = 0.1e1 / t7
  t21 = jnp.sqrt(r0)
  t22 = 0.1e1 / t21
  t25 = r1 ** (0.1e1 / 0.6e1)
  t27 = t1 * r0 + t25 * r1
  t28 = r0 - r1
  t30 = r0 + r1
  t31 = t30 ** 2
  t32 = t31 * t30
  t33 = 0.1e1 / t32
  t35 = 0.21344160000000000000000000000000000000000000000000e1 * t27 * t28 * t33
  t36 = t28 ** 2
  t38 = t31 ** 2
  t39 = 0.1e1 / t38
  t41 = 0.16008120000000000000000000000000000000000000000000e1 * t27 * t36 * t39
  t42 = t7 * r0
  t43 = r1 ** (0.1e1 / 0.3e1)
  t44 = t43 * r1
  t45 = t42 + t44
  t48 = 0.12065760000000000000000000000000000000000000000000e2 * t45 * t28 * t33
  t51 = 0.90493200000000000000000000000000000000000000000000e1 * t45 * t36 * t39
  t53 = jnp.sqrt(r1)
  t55 = t21 * r0 + t53 * r1
  t58 = 0.15561200000000000000000000000000000000000000000000e2 * t55 * t28 * t33
  t61 = 0.11670900000000000000000000000000000000000000000000e2 * t55 * t36 * t39
  t62 = r0 ** 0.16666666666666666666666666666666666666666666666667e1
  t63 = r1 ** 0.16666666666666666666666666666666666666666666666667e1
  t64 = t62 + t63
  t67 = 0.54326240000000000000000000000000000000000000000000e1 * t64 * t28 * t33
  t70 = 0.40744680000000000000000000000000000000000000000000e1 * t64 * t36 * t39
  t72 = 0.1e1 / t31
  t78 = -0.34187416666666666666666666666666666666666666666667e0 * t5 + 0.56744888888888888888888888888888888888888888888890e0 * t9 + 0.61283354166666666666666666666666666666666666666667e-1 / t15 / t13 + 0.40623333333333333333333333333333333333333333333333e0 * t19 - 0.12059175000000000000000000000000000000000000000000e1 * t22 + t35 - t41 - t48 + t51 + t58 - t61 - t67 + t70 - 0.51878166666666666666666666666666666666666666666667e-1 * t5 * t36 * t72 + 0.67032000000000000000000000000000000000000000000000e0 * t9 * t36 * t72
  t82 = r0 ** (-0.3333333333333333333333333333333333333333333333333e0)
  t87 = t1 * t28 * t72
  t90 = t1 * t36 * t33
  t93 = t7 * t28 * t72
  t96 = t7 * t36 * t33
  t99 = t21 * t28 * t72
  t102 = t21 * t36 * t33
  t104 = r0 ** 0.6666666666666666666666666666666666666666666666667e0
  t106 = t104 * t28 * t72
  t109 = t104 * t36 * t33
  t112 = t25 ** 2
  t113 = t112 ** 2
  t114 = t113 * t25
  t116 = t4 * r0 + t114 * r1
  t117 = r0 ** 2
  t118 = t117 ** 2
  t122 = 0.1e1 / t30
  t123 = t28 * t122
  t124 = 0.1e1 + t123
  t125 = t124 <= f.p.zeta_threshold
  t126 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t127 = t126 * f.p.zeta_threshold
  t128 = t124 ** (0.1e1 / 0.3e1)
  t130 = f.my_piecewise3(t125, t127, t128 * t124)
  t131 = t130 ** 2
  t132 = 2 ** (0.1e1 / 0.3e1)
  t133 = t131 * t132
  t134 = s0 / t8 / t118 * t133
  t136 = t117 * r0
  t139 = s0 / t8 / t136
  t140 = t130 * t132
  t141 = t28 * t72
  t142 = t122 - t141
  t145 = f.my_piecewise3(t125, 0, 0.4e1 / 0.3e1 * t128 * t142)
  t146 = t140 * t145
  t147 = t139 * t146
  t151 = s0 / t8 / t117
  t152 = t145 ** 2
  t154 = t151 * t152 * t132
  t156 = t128 ** 2
  t157 = 0.1e1 / t156
  t158 = t142 ** 2
  t161 = t28 * t33
  t163 = -0.2e1 * t72 + 0.2e1 * t161
  t167 = f.my_piecewise3(t125, 0, 0.4e1 / 0.9e1 * t157 * t158 + 0.4e1 / 0.3e1 * t128 * t163)
  t169 = t151 * t140 * t167
  t171 = r1 ** 2
  t172 = t43 ** 2
  t175 = s2 / t172 / t171
  t176 = 0.1e1 - t123
  t177 = t176 <= f.p.zeta_threshold
  t178 = t176 ** (0.1e1 / 0.3e1)
  t179 = -t142
  t182 = f.my_piecewise3(t177, 0, 0.4e1 / 0.3e1 * t178 * t179)
  t183 = t182 ** 2
  t185 = t175 * t183 * t132
  t188 = f.my_piecewise3(t177, t127, t178 * t176)
  t189 = t188 * t132
  t190 = t178 ** 2
  t191 = 0.1e1 / t190
  t192 = t179 ** 2
  t199 = f.my_piecewise3(t177, 0, 0.4e1 / 0.9e1 * t191 * t192 - 0.4e1 / 0.3e1 * t178 * t163)
  t201 = t175 * t189 * t199
  t203 = 0.11e2 / 0.9e1 * t134 - 0.4e1 / 0.3e1 * t147 + t154 / 0.4e1 + t169 / 0.4e1 + t185 / 0.4e1 + t201 / 0.4e1
  t206 = t139 * t133
  t208 = t151 * t146
  t210 = t189 * t182
  t211 = t175 * t210
  t213 = -t206 / 0.3e1 + t208 / 0.4e1 + t211 / 0.4e1
  t216 = jnp.sqrt(s0)
  t219 = t216 / t7 / t117
  t220 = t132 ** 2
  t221 = t130 * t220
  t225 = t216 / t42
  t226 = t145 * t220
  t229 = jnp.sqrt(s2)
  t231 = t229 / t44
  t232 = t182 * t220
  t235 = -t219 * t221 / 0.3e1 + t225 * t226 / 0.4e1 + t231 * t232 / 0.4e1
  t240 = t8 * r0 + t172 * r1
  t256 = 0.7e1 / 0.9e1 * t216 / t7 / t136 * t221 - 0.2e1 / 0.3e1 * t219 * t226 + t225 * t167 * t220 / 0.4e1 + t231 * t199 * t220 / 0.4e1
  t259 = -0.14588625000000000000000000000000000000000000000000e1 * t22 * t36 * t72 + 0.75453111111111111111111111111111111111111111111117e0 * t82 * t36 * t72 - 0.12450760000000000000000000000000000000000000000000e1 * t87 + 0.12450760000000000000000000000000000000000000000000e1 * t90 + 0.80438400000000000000000000000000000000000000000000e1 * t93 - 0.80438400000000000000000000000000000000000000000000e1 * t96 - 0.11670900000000000000000000000000000000000000000000e2 * t99 + 0.11670900000000000000000000000000000000000000000000e2 * t102 + 0.45271866666666666666666666666666666666666666666668e1 * t106 - 0.45271866666666666666666666666666666666666666666668e1 * t109 + 0.10731250000000000000000000000000000000000000000000e-1 * t116 * t203 - 0.67861166666666666666666666666666666666666666666666e-1 * t8 * t213 - 0.13143478333333333333333333333333333333333333333333e0 * t4 * t235 - 0.20358350000000000000000000000000000000000000000000e-1 * t240 * t203 - 0.35845850000000000000000000000000000000000000000000e-1 * t116 * t256
  t269 = t14 * t11
  t273 = r1 ** (0.1e1 / 0.12e2)
  t274 = t273 ** 2
  t275 = t274 ** 2
  t276 = t275 * t273
  t278 = t269 * r0 + t276 * r1
  t285 = s0 + 0.2e1 * s1 + s2
  t286 = t30 ** (0.1e1 / 0.3e1)
  t287 = t286 ** 2
  t291 = 0.8e1 / 0.3e1 * t285 / t287 / t32
  t292 = -0.2e1 / 0.3e1 * t206 + t208 / 0.2e1 + t211 / 0.2e1 + t291
  t295 = t117 + t171
  t305 = 0.88e2 / 0.9e1 * t285 / t287 / t38
  t306 = 0.22e2 / 0.9e1 * t134 - 0.8e1 / 0.3e1 * t147 + t154 / 0.2e1 + t169 / 0.2e1 + t185 / 0.2e1 + t201 / 0.2e1 - t305
  t320 = t188 * t220
  t323 = t225 * t221 / 0.4e1 + t231 * t320 / 0.4e1
  t328 = 0.24523500000000000000000000000000000000000000000000e0 * t8 * t235 + 0.22045950000000000000000000000000000000000000000000e0 * t21 * t235 + 0.73486500000000000000000000000000000000000000000000e-1 * t55 * t256 + 0.73570500000000000000000000000000000000000000000000e-1 * t240 * t256 - 0.25687991666666666666666666666666666666666666666666e0 * t269 * t235 - 0.90663500000000000000000000000000000000000000000000e-1 * t278 * t256 + 0.17862480000000000000000000000000000000000000000000e0 * r0 * t292 + 0.44656200000000000000000000000000000000000000000000e-1 * t295 * t306 - 0.26411953333333333333333333333333333333333333333334e0 * t4 * t292 - 0.72032600000000000000000000000000000000000000000000e-1 * t116 * t306 + 0.10345900000000000000000000000000000000000000000000e0 * t8 * t292 + 0.31037700000000000000000000000000000000000000000000e-1 * t240 * t306 - 0.38407800000000000000000000000000000000000000000000e-3 * t295 * t203 + 0.81745000000000000000000000000000000000000000000000e-1 * t19 * t323 + 0.55114875000000000000000000000000000000000000000000e-1 * t22 * t323
  t335 = t285 / t287 / t31
  t336 = 0.89312400000000000000000000000000000000000000000000e-1 * t335
  t337 = 0.1e1 / t1
  t338 = t151 * t133
  t340 = t188 ** 2
  t341 = t340 * t132
  t342 = t175 * t341
  t344 = t338 / 0.4e1 + t342 / 0.4e1 - t335
  t352 = 0.53360400000000000000000000000000000000000000000000e0 * t27 * t72
  t354 = 0.30164400000000000000000000000000000000000000000000e1 * t45 * t72
  t356 = 0.38903000000000000000000000000000000000000000000000e1 * t55 * t72
  t358 = 0.13581560000000000000000000000000000000000000000000e1 * t64 * t72
  t360 = t338 / 0.8e1 + t342 / 0.8e1
  t369 = 0.22232080500000000000000000000000000000000000000000e-1 * t338
  t370 = 0.22232080500000000000000000000000000000000000000000e-1 * t342
  t371 = -0.53516649305555555555555555555555555555555555555554e-1 / t14 / t13 * t323 - t336 - 0.11004980555555555555555555555555555555555555555556e0 * t337 * t344 + 0.34486333333333333333333333333333333333333333333333e-1 * t19 * t344 - 0.15363120000000000000000000000000000000000000000000e-2 * r0 * t213 - t352 + t354 - t356 + t358 + 0.16394965277777777777777777777777777777777777777777e-1 * t337 * t360 - 0.22620388888888888888888888888888888888888888888889e-1 * t19 * t360 - 0.54764493055555555555555555555555555555555555555556e-1 * t337 * t323 + 0.39347916666666666666666666666666666666666666666666e-1 * t4 * t213 + t369 + t370
  d11 = t78 + t259 + t328 + t371
  t373 = -t122 - t141
  t376 = f.my_piecewise3(t125, 0, 0.4e1 / 0.3e1 * t128 * t373)
  t377 = t140 * t376
  t378 = t139 * t377
  t382 = t151 * t145 * t132 * t376
  t391 = f.my_piecewise3(t125, 0, 0.4e1 / 0.9e1 * t157 * t373 * t142 + 0.8e1 / 0.3e1 * t128 * t28 * t33)
  t393 = t151 * t140 * t391
  t395 = t171 * r1
  t398 = s2 / t172 / t395
  t399 = t398 * t210
  t402 = -t373
  t405 = f.my_piecewise3(t177, 0, 0.4e1 / 0.3e1 * t178 * t402)
  t407 = t175 * t182 * t132 * t405
  t416 = f.my_piecewise3(t177, 0, 0.4e1 / 0.9e1 * t191 * t402 * t179 - 0.8e1 / 0.3e1 * t178 * t28 * t33)
  t418 = t175 * t189 * t416
  t420 = -0.4e1 / 0.3e1 * t378 + t382 / 0.2e1 + t393 / 0.2e1 - 0.4e1 / 0.3e1 * t399 + t407 / 0.2e1 + t418 / 0.2e1 - t305
  t423 = t151 * t377
  t425 = t398 * t341
  t427 = t189 * t405
  t428 = t175 * t427
  t430 = t423 / 0.2e1 - 0.2e1 / 0.3e1 * t425 + t428 / 0.2e1 + t291
  t437 = t376 * t220
  t445 = t229 / t43 / t171
  t451 = -t219 * t437 / 0.3e1 + t225 * t391 * t220 / 0.4e1 - t445 * t232 / 0.3e1 + t231 * t416 * t220 / 0.4e1
  t462 = t405 * t220
  t465 = t225 * t437 / 0.4e1 - t445 * t320 / 0.3e1 + t231 * t462 / 0.4e1
  t478 = 0.44656200000000000000000000000000000000000000000000e-1 * t295 * t420 + 0.89312400000000000000000000000000000000000000000000e-1 * r0 * t430 - 0.72032600000000000000000000000000000000000000000000e-1 * t116 * t420 - 0.13205976666666666666666666666666666666666666666667e0 * t114 * t292 + 0.73486500000000000000000000000000000000000000000000e-1 * t55 * t451 - 0.13205976666666666666666666666666666666666666666667e0 * t4 * t430 + 0.11022975000000000000000000000000000000000000000000e0 * t53 * t235 + 0.11022975000000000000000000000000000000000000000000e0 * t21 * t465 - 0.12843995833333333333333333333333333333333333333333e0 * t276 * t235 - 0.35845850000000000000000000000000000000000000000000e-1 * t116 * t451 + 0.73570500000000000000000000000000000000000000000000e-1 * t240 * t451 - 0.65717391666666666666666666666666666666666666666667e-1 * t4 * t465 + 0.12261750000000000000000000000000000000000000000000e0 * t172 * t235
  t480 = t25 * t28 * t72
  t483 = t25 * t36 * t33
  t486 = t43 * t28 * t72
  t489 = t43 * t36 * t33
  t492 = t53 * t28 * t72
  t495 = t53 * t36 * t33
  t497 = r1 ** 0.6666666666666666666666666666666666666666666666667e0
  t499 = t497 * t28 * t72
  t502 = t497 * t36 * t33
  t506 = -0.62253800000000000000000000000000000000000000000000e0 * t480 + 0.62253800000000000000000000000000000000000000000000e0 * t483 + 0.40219200000000000000000000000000000000000000000000e1 * t486 - 0.40219200000000000000000000000000000000000000000000e1 * t489 - 0.58354500000000000000000000000000000000000000000000e1 * t492 + 0.58354500000000000000000000000000000000000000000000e1 * t495 + 0.22635933333333333333333333333333333333333333333334e1 * t499 - 0.22635933333333333333333333333333333333333333333334e1 * t502 - t41 + t51 - t61 + t70 + 0.62253800000000000000000000000000000000000000000000e0 * t87 + 0.62253800000000000000000000000000000000000000000000e0 * t90
  t524 = -0.2e1 / 0.3e1 * t378 + t382 / 0.4e1 + t393 / 0.4e1 - 0.2e1 / 0.3e1 * t399 + t407 / 0.4e1 + t418 / 0.4e1
  t534 = t423 / 0.4e1 - t425 / 0.3e1 + t428 / 0.4e1
  t539 = -0.40219200000000000000000000000000000000000000000000e1 * t93 - 0.40219200000000000000000000000000000000000000000000e1 * t96 + 0.58354500000000000000000000000000000000000000000000e1 * t99 + 0.58354500000000000000000000000000000000000000000000e1 * t102 - 0.22635933333333333333333333333333333333333333333334e1 * t106 - 0.22635933333333333333333333333333333333333333333334e1 * t109 - 0.90663500000000000000000000000000000000000000000000e-1 * t278 * t451 - 0.12843995833333333333333333333333333333333333333333e0 * t269 * t465 + 0.10731250000000000000000000000000000000000000000000e-1 * t116 * t524 + 0.89312400000000000000000000000000000000000000000000e-1 * r1 * t292 + 0.12261750000000000000000000000000000000000000000000e0 * t8 * t465 + 0.19673958333333333333333333333333333333333333333333e-1 * t4 * t534 - 0.20358350000000000000000000000000000000000000000000e-1 * t240 * t524
  t560 = -0.65717391666666666666666666666666666666666666666667e-1 * t114 * t235 - 0.33930583333333333333333333333333333333333333333333e-1 * t172 * t213 - 0.33930583333333333333333333333333333333333333333333e-1 * t8 * t534 - 0.38407800000000000000000000000000000000000000000000e-3 * t295 * t524 + 0.51729500000000000000000000000000000000000000000000e-1 * t172 * t292 - 0.76815600000000000000000000000000000000000000000000e-3 * r0 * t534 + 0.19673958333333333333333333333333333333333333333333e-1 * t114 * t213 - 0.76815600000000000000000000000000000000000000000000e-3 * r1 * t213 + 0.31037700000000000000000000000000000000000000000000e-1 * t240 * t420 + 0.51729500000000000000000000000000000000000000000000e-1 * t8 * t430 + t352 - t354 + t356 - t358
  d12 = t478 + t506 + t539 + t560
  t562 = 0.1e1 / t114
  t564 = 0.1e1 / t172
  t566 = t274 * t273
  t567 = t275 ** 2
  t571 = 0.1e1 / t53
  t573 = 0.1e1 / t43
  t577 = t373 ** 2
  t581 = 0.2e1 * t72 + 0.2e1 * t161
  t585 = f.my_piecewise3(t125, 0, 0.4e1 / 0.9e1 * t157 * t577 + 0.4e1 / 0.3e1 * t128 * t581)
  t596 = t402 ** 2
  t603 = f.my_piecewise3(t177, 0, 0.4e1 / 0.9e1 * t191 * t596 - 0.4e1 / 0.3e1 * t178 * t581)
  t607 = t225 * t585 * t220 / 0.4e1 + 0.7e1 / 0.9e1 * t229 / t43 / t395 * t320 - 0.2e1 / 0.3e1 * t445 * t462 + t231 * t603 * t220 / 0.4e1
  t628 = -0.34187416666666666666666666666666666666666666666667e0 * t562 + 0.56744888888888888888888888888888888888888888888890e0 * t564 + 0.61283354166666666666666666666666666666666666666667e-1 / t567 / t566 - 0.12059175000000000000000000000000000000000000000000e1 * t571 + 0.40623333333333333333333333333333333333333333333333e0 * t573 - 0.26411953333333333333333333333333333333333333333334e0 * t114 * t430 - 0.35845850000000000000000000000000000000000000000000e-1 * t116 * t607 + 0.22045950000000000000000000000000000000000000000000e0 * t53 * t465 - 0.25687991666666666666666666666666666666666666666666e0 * t276 * t465 - 0.13143478333333333333333333333333333333333333333333e0 * t114 * t465 + 0.24523500000000000000000000000000000000000000000000e0 * t172 * t465 + 0.73570500000000000000000000000000000000000000000000e-1 * t240 * t607 + 0.55114875000000000000000000000000000000000000000000e-1 * t571 * t323 - 0.53516649305555555555555555555555555555555555555554e-1 / t275 / t566 * t323 + 0.81745000000000000000000000000000000000000000000000e-1 * t573 * t323
  t631 = 0.1e1 / t25
  t642 = t376 ** 2
  t644 = t151 * t642 * t132
  t647 = t151 * t140 * t585
  t649 = t171 ** 2
  t653 = s2 / t172 / t649 * t341
  t655 = t398 * t427
  t657 = t405 ** 2
  t659 = t175 * t657 * t132
  t662 = t175 * t189 * t603
  t664 = t644 / 0.4e1 + t647 / 0.4e1 + 0.11e2 / 0.9e1 * t653 - 0.4e1 / 0.3e1 * t655 + t659 / 0.4e1 + t662 / 0.4e1
  t685 = t644 / 0.2e1 + t647 / 0.2e1 + 0.22e2 / 0.9e1 * t653 - 0.8e1 / 0.3e1 * t655 + t659 / 0.2e1 + t662 / 0.2e1 - t305
  t690 = -0.22620388888888888888888888888888888888888888888889e-1 * t573 * t360 + 0.16394965277777777777777777777777777777777777777777e-1 * t631 * t360 + 0.34486333333333333333333333333333333333333333333333e-1 * t573 * t344 - 0.54764493055555555555555555555555555555555555555556e-1 * t631 * t323 - 0.11004980555555555555555555555555555555555555555556e0 * t631 * t344 - 0.90663500000000000000000000000000000000000000000000e-1 * t278 * t607 + 0.10731250000000000000000000000000000000000000000000e-1 * t116 * t664 + 0.39347916666666666666666666666666666666666666666666e-1 * t114 * t534 - 0.20358350000000000000000000000000000000000000000000e-1 * t240 * t664 - 0.67861166666666666666666666666666666666666666666666e-1 * t172 * t534 + 0.10345900000000000000000000000000000000000000000000e0 * t172 * t430 - 0.38407800000000000000000000000000000000000000000000e-3 * t295 * t664 - 0.15363120000000000000000000000000000000000000000000e-2 * r1 * t534 + 0.31037700000000000000000000000000000000000000000000e-1 * t240 * t685 + 0.44656200000000000000000000000000000000000000000000e-1 * t295 * t685
  t704 = r1 ** (-0.3333333333333333333333333333333333333333333333333e0)
  t719 = 0.17862480000000000000000000000000000000000000000000e0 * r1 * t430 - 0.72032600000000000000000000000000000000000000000000e-1 * t116 * t685 + 0.73486500000000000000000000000000000000000000000000e-1 * t55 * t607 + 0.67032000000000000000000000000000000000000000000000e0 * t564 * t36 * t72 - 0.14588625000000000000000000000000000000000000000000e1 * t571 * t36 * t72 + 0.75453111111111111111111111111111111111111111111117e0 * t704 * t36 * t72 - 0.51878166666666666666666666666666666666666666666667e-1 * t562 * t36 * t72 + 0.12450760000000000000000000000000000000000000000000e1 * t480 + 0.12450760000000000000000000000000000000000000000000e1 * t483 - 0.80438400000000000000000000000000000000000000000000e1 * t486 - 0.80438400000000000000000000000000000000000000000000e1 * t489 + 0.11670900000000000000000000000000000000000000000000e2 * t492 + 0.11670900000000000000000000000000000000000000000000e2 * t495 - 0.45271866666666666666666666666666666666666666666668e1 * t499 - 0.45271866666666666666666666666666666666666666666668e1 * t502
  t720 = -t35 - t41 + t48 + t51 - t58 - t61 + t67 + t70 - t336 - t352 + t354 - t356 + t358 + t369 + t370
  d22 = t628 + t690 + t719 + t720
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = jnp.sqrt(r0)
  t2 = t1 * r0
  t3 = jnp.sqrt(r1)
  t5 = t3 * r1 + t2
  t6 = r0 - r1
  t8 = r0 + r1
  t9 = t8 ** 2
  t10 = t9 ** 2
  t11 = 0.1e1 / t10
  t14 = t6 ** 2
  t16 = t10 * t8
  t17 = 0.1e1 / t16
  t20 = r0 ** 0.16666666666666666666666666666666666666666666666667e1
  t21 = r1 ** 0.16666666666666666666666666666666666666666666666667e1
  t22 = t20 + t21
  t29 = r0 ** (0.1e1 / 0.6e1)
  t30 = t29 ** 2
  t31 = t30 ** 2
  t32 = t31 * t29
  t33 = t32 * r0
  t34 = 0.1e1 / t33
  t36 = 0.1e1 / t9
  t39 = r0 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t41 = t40 * r0
  t42 = 0.1e1 / t41
  t46 = r0 ** (-0.13333333333333333333333333333333333333333333333333e1)
  t50 = r0 ** (-0.3333333333333333333333333333333333333333333333333e0)
  t55 = t9 * t8
  t56 = 0.1e1 / t55
  t59 = 0.1e1 / t32
  t72 = 0.1e1 / t40
  t85 = 0.1e1 / t1
  t95 = -0.70025400000000000000000000000000000000000000000000e2 * t5 * t6 * t11 + 0.46683600000000000000000000000000000000000000000000e2 * t5 * t14 * t17 + 0.24446808000000000000000000000000000000000000000000e2 * t22 * t6 * t11 - 0.16297872000000000000000000000000000000000000000000e2 * t22 * t14 * t17 + 0.43231805555555555555555555555555555555555555555556e-1 * t34 * t14 * t36 - 0.44688000000000000000000000000000000000000000000000e0 * t42 * t14 * t36 - 0.25151037037037037037037037037037037037037037037036e0 * t46 * t14 * t36 + 0.45271866666666666666666666666666666666666666666670e1 * t50 * t6 * t36 - 0.45271866666666666666666666666666666666666666666670e1 * t50 * t14 * t56 - 0.31126900000000000000000000000000000000000000000000e0 * t59 * t6 * t36 + 0.74704560000000000000000000000000000000000000000000e1 * t29 * t6 * t56 + 0.31126900000000000000000000000000000000000000000000e0 * t59 * t14 * t56 - 0.56028420000000000000000000000000000000000000000000e1 * t29 * t14 * t11 + 0.40219200000000000000000000000000000000000000000000e1 * t72 * t6 * t36 - 0.48263040000000000000000000000000000000000000000000e2 * t39 * t6 * t56 - 0.40219200000000000000000000000000000000000000000000e1 * t72 * t14 * t56 + 0.36197280000000000000000000000000000000000000000000e2 * t39 * t14 * t11 - 0.87531750000000000000000000000000000000000000000000e1 * t85 * t6 * t36 + 0.70025400000000000000000000000000000000000000000000e2 * t1 * t6 * t56 + 0.87531750000000000000000000000000000000000000000000e1 * t85 * t14 * t56
  t99 = r0 ** 0.6666666666666666666666666666666666666666666666667e0
  t106 = 0.1e1 / t2
  t110 = t29 * r0
  t111 = r1 ** (0.1e1 / 0.6e1)
  t113 = t111 * r1 + t110
  t120 = t39 * r0
  t121 = r1 ** (0.1e1 / 0.3e1)
  t122 = t121 * r1
  t123 = t120 + t122
  t130 = r0 ** 2
  t131 = r1 ** 2
  t132 = t130 + t131
  t133 = t130 ** 2
  t138 = 0.1e1 / t8
  t139 = t6 * t138
  t140 = 0.1e1 + t139
  t141 = t140 <= f.p.zeta_threshold
  t142 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t143 = t142 * f.p.zeta_threshold
  t144 = t140 ** (0.1e1 / 0.3e1)
  t146 = f.my_piecewise3(t141, t143, t144 * t140)
  t147 = t146 ** 2
  t148 = 2 ** (0.1e1 / 0.3e1)
  t149 = t147 * t148
  t150 = s0 / t40 / t133 / r0 * t149
  t154 = s0 / t40 / t133
  t155 = t146 * t148
  t157 = -t6 * t36 + t138
  t160 = f.my_piecewise3(t141, 0, 0.4e1 / 0.3e1 * t144 * t157)
  t161 = t155 * t160
  t162 = t154 * t161
  t164 = t130 * r0
  t167 = s0 / t40 / t164
  t168 = t160 ** 2
  t169 = t168 * t148
  t170 = t167 * t169
  t172 = t144 ** 2
  t173 = 0.1e1 / t172
  t174 = t157 ** 2
  t179 = 0.2e1 * t6 * t56 - 0.2e1 * t36
  t183 = f.my_piecewise3(t141, 0, 0.4e1 / 0.9e1 * t173 * t174 + 0.4e1 / 0.3e1 * t144 * t179)
  t184 = t155 * t183
  t185 = t167 * t184
  t189 = s0 / t40 / t130
  t192 = t189 * t160 * t148 * t183
  t204 = -0.6e1 * t6 * t11 + 0.6e1 * t56
  t208 = f.my_piecewise3(t141, 0, -0.8e1 / 0.27e2 / t172 / t140 * t174 * t157 + 0.4e1 / 0.3e1 * t173 * t157 * t179 + 0.4e1 / 0.3e1 * t144 * t204)
  t210 = t189 * t155 * t208
  t212 = t121 ** 2
  t215 = s2 / t212 / t131
  t216 = 0.1e1 - t139
  t217 = t216 <= f.p.zeta_threshold
  t218 = t216 ** (0.1e1 / 0.3e1)
  t219 = -t157
  t222 = f.my_piecewise3(t217, 0, 0.4e1 / 0.3e1 * t218 * t219)
  t224 = t218 ** 2
  t225 = 0.1e1 / t224
  t226 = t219 ** 2
  t229 = -t179
  t233 = f.my_piecewise3(t217, 0, 0.4e1 / 0.9e1 * t225 * t226 + 0.4e1 / 0.3e1 * t218 * t229)
  t235 = t215 * t222 * t148 * t233
  t238 = f.my_piecewise3(t217, t143, t218 * t216)
  t239 = t238 * t148
  t252 = f.my_piecewise3(t217, 0, -0.8e1 / 0.27e2 / t224 / t216 * t226 * t219 + 0.4e1 / 0.3e1 * t225 * t219 * t229 - 0.4e1 / 0.3e1 * t218 * t204)
  t254 = t215 * t239 * t252
  t257 = s0 + 0.2e1 * s1 + s2
  t258 = t8 ** (0.1e1 / 0.3e1)
  t259 = t258 ** 2
  t264 = -0.308e3 / 0.27e2 * t150 + 0.44e2 / 0.3e1 * t162 - 0.4e1 * t170 - 0.4e1 * t185 + 0.3e1 / 0.2e1 * t192 + t210 / 0.2e1 + 0.3e1 / 0.2e1 * t235 + t254 / 0.2e1 + 0.1232e4 / 0.27e2 * t257 / t259 / t16
  t267 = t154 * t149
  t269 = t167 * t161
  t271 = t189 * t169
  t273 = t189 * t184
  t275 = t222 ** 2
  t277 = t215 * t275 * t148
  t280 = t215 * t239 * t233
  t286 = 0.22e2 / 0.9e1 * t267 - 0.8e1 / 0.3e1 * t269 + t271 / 0.2e1 + t273 / 0.2e1 + t277 / 0.2e1 + t280 / 0.2e1 - 0.88e2 / 0.9e1 * t257 / t259 / t10
  t291 = t111 ** 2
  t292 = t291 ** 2
  t295 = t292 * t111 * r1 + t33
  t306 = -0.154e3 / 0.27e2 * t150 + 0.22e2 / 0.3e1 * t162 - 0.2e1 * t170 - 0.2e1 * t185 + 0.3e1 / 0.4e1 * t192 + t210 / 0.4e1 + 0.3e1 / 0.4e1 * t235 + t254 / 0.4e1
  t315 = 0.11e2 / 0.9e1 * t267 - 0.4e1 / 0.3e1 * t269 + t271 / 0.4e1 + t273 / 0.4e1 + t277 / 0.4e1 + t280 / 0.4e1
  t321 = t212 * r1 + t41
  t324 = 0.1e1 / t39
  t325 = jnp.sqrt(s0)
  t328 = t325 / t39 / t130
  t329 = t148 ** 2
  t330 = t146 * t329
  t333 = 0.1e1 / t120
  t334 = t325 * t333
  t335 = t160 * t329
  t338 = jnp.sqrt(s2)
  t340 = t338 / t122
  t344 = -t328 * t330 / 0.3e1 + t334 * t335 / 0.4e1 + t340 * t222 * t329 / 0.4e1
  t347 = 0.1e1 / t110
  t348 = t189 * t149
  t349 = t238 ** 2
  t351 = t215 * t349 * t148
  t353 = t348 / 0.8e1 + t351 / 0.8e1
  t360 = -0.52519050000000000000000000000000000000000000000000e2 * t1 * t14 * t11 - 0.27163120000000000000000000000000000000000000000000e2 * t99 * t6 * t56 + 0.20372340000000000000000000000000000000000000000000e2 * t99 * t14 * t11 + 0.72943125000000000000000000000000000000000000000000e0 * t106 * t14 * t36 - 0.96048720000000000000000000000000000000000000000000e1 * t113 * t6 * t11 + 0.64032480000000000000000000000000000000000000000000e1 * t113 * t14 * t17 + 0.54295920000000000000000000000000000000000000000000e2 * t123 * t6 * t11 - 0.36197280000000000000000000000000000000000000000000e2 * t123 * t14 * t17 + 0.44656200000000000000000000000000000000000000000000e-1 * t132 * t264 + 0.26793720000000000000000000000000000000000000000000e0 * r0 * t286 - 0.39617930000000000000000000000000000000000000000001e0 * t32 * t286 - 0.72032600000000000000000000000000000000000000000000e-1 * t295 * t264 + 0.10731250000000000000000000000000000000000000000000e-1 * t295 * t306 + 0.59021874999999999999999999999999999999999999999999e-1 * t32 * t315 - 0.10179175000000000000000000000000000000000000000000e0 * t40 * t315 - 0.20358350000000000000000000000000000000000000000000e-1 * t321 * t306 + 0.24523500000000000000000000000000000000000000000000e0 * t324 * t344 - 0.27324942129629629629629629629629629629629629629628e-2 * t347 * t353 - 0.81489360000000000000000000000000000000000000000000e1 * t22 * t56 + 0.23341800000000000000000000000000000000000000000000e2 * t5 * t56
  t366 = 0.1e1 / t29
  t367 = t167 * t149
  t369 = t189 * t161
  t372 = t215 * t239 * t222
  t374 = -t367 / 0.3e1 + t369 / 0.4e1 + t372 / 0.4e1
  t377 = r0 ** (0.1e1 / 0.12e2)
  t378 = t377 ** 2
  t379 = t378 * t377
  t380 = t378 ** 2
  t381 = t380 * t379
  t391 = t257 / t259 / t55
  t397 = -0.2e1 / 0.3e1 * t367 + t369 / 0.2e1 + t372 / 0.2e1 + 0.8e1 / 0.3e1 * t391
  t408 = t340 * t238 * t329 / 0.4e1 + t334 * t330 / 0.4e1
  t434 = t348 / 0.4e1 + t351 / 0.4e1 - t257 / t259 / t9
  t437 = -0.18098640000000000000000000000000000000000000000000e2 * t123 * t56 + 0.32016240000000000000000000000000000000000000000000e1 * t113 * t56 + 0.49184895833333333333333333333333333333333333333332e-1 * t366 * t374 - 0.16054994791666666666666666666666666666666666666666e0 / t381 * t344 - 0.67861166666666666666666666666666666666666666666666e-1 * t324 * t374 - 0.16429347916666666666666666666666666666666666666667e0 * t366 * t344 + 0.71449920000000000000000000000000000000000000000000e0 * t391 + 0.10345900000000000000000000000000000000000000000000e0 * t324 * t397 + 0.16534462500000000000000000000000000000000000000000e0 * t85 * t344 + 0.31218045428240740740740740740740740740740740740740e-1 / t381 / r0 * t408 - 0.27557437500000000000000000000000000000000000000000e-1 * t106 * t408 - 0.27248333333333333333333333333333333333333333333333e-1 * t333 * t408 - 0.33014941666666666666666666666666666666666666666668e0 * t366 * t397 + 0.91274155092592592592592592592592592592592592592594e-2 * t347 * t408 + 0.75401296296296296296296296296296296296296296296297e-2 * t333 * t353 - 0.18676140000000000000000000000000000000000000000000e1 * t29 * t36 + 0.12065760000000000000000000000000000000000000000000e2 * t39 * t36 - 0.17506350000000000000000000000000000000000000000000e2 * t1 * t36 + 0.67907800000000000000000000000000000000000000000002e1 * t99 * t36 - 0.11495444444444444444444444444444444444444444444444e-1 * t333 * t434
  t448 = t325 / t39 / t164
  t453 = t183 * t329
  t459 = 0.7e1 / 0.9e1 * t448 * t330 - 0.2e1 / 0.3e1 * t328 * t335 + t334 * t453 / 0.4e1 + t340 * t233 * t329 / 0.4e1
  t478 = -0.70e2 / 0.27e2 * t325 / t39 / t133 * t330 + 0.7e1 / 0.3e1 * t448 * t335 - t328 * t453 + t334 * t208 * t329 / 0.4e1 + t340 * t252 * t329 / 0.4e1
  t485 = t380 * t377
  t492 = r1 ** (0.1e1 / 0.12e2)
  t493 = t492 ** 2
  t494 = t493 ** 2
  t503 = t380 ** 2
  t514 = 0.73486500000000000000000000000000000000000000000000e-1 * t5 * t478 - 0.90663500000000000000000000000000000000000000000000e-1 * (t494 * t492 * r1 + t485 * r0) * t478 + 0.15518850000000000000000000000000000000000000000000e0 * t40 * t286 + 0.60295875000000000000000000000000000000000000000000e0 * t106 - 0.56176407986111111111111111111111111111111111111111e-1 / t503 / t379 / r0 + 0.28489513888888888888888888888888888888888888888889e0 * t34 - 0.37829925925925925925925925925925925925925925925927e0 * t42 - 0.13541111111111111111111111111111111111111111111111e0 * t333 + 0.13339248300000000000000000000000000000000000000000e0 * t369 + 0.13339248300000000000000000000000000000000000000000e0 * t372 - 0.17785664400000000000000000000000000000000000000000e0 * t367
  d111 = t95 + t360 + t437 + 0.18341634259259259259259259259259259259259259259260e-1 * t347 * t434 + 0.31037700000000000000000000000000000000000000000000e-1 * t321 * t264 - 0.38407800000000000000000000000000000000000000000000e-3 * t132 * t306 - 0.23044680000000000000000000000000000000000000000000e-2 * r0 * t315 - 0.19715217500000000000000000000000000000000000000000e0 * t32 * t459 + 0.36785250000000000000000000000000000000000000000000e0 * t40 * t459 - 0.35845850000000000000000000000000000000000000000000e-1 * t295 * t478 + 0.33068925000000000000000000000000000000000000000000e0 * t1 * t459 + 0.73570500000000000000000000000000000000000000000000e-1 * t321 * t478 - 0.38531987499999999999999999999999999999999999999999e0 * t485 * t459 + t514

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 ** 0.6666666666666666666666666666666666666666666666667e0
  t2 = r0 - r1
  t3 = t2 ** 2
  t5 = r0 + r1
  t6 = t5 ** 2
  t7 = t6 ** 2
  t8 = t7 * t5
  t9 = 0.1e1 / t8
  t12 = r0 ** (0.1e1 / 0.6e1)
  t13 = t12 * r0
  t14 = r1 ** (0.1e1 / 0.6e1)
  t16 = t14 * r1 + t13
  t21 = t7 * t6
  t22 = 0.1e1 / t21
  t25 = r0 ** (0.1e1 / 0.3e1)
  t26 = t25 * r0
  t27 = r1 ** (0.1e1 / 0.3e1)
  t28 = t27 * r1
  t29 = t26 + t28
  t36 = jnp.sqrt(r0)
  t37 = t36 * r0
  t38 = jnp.sqrt(r1)
  t40 = t38 * r1 + t37
  t47 = r0 ** 0.16666666666666666666666666666666666666666666666667e1
  t48 = r1 ** 0.16666666666666666666666666666666666666666666666667e1
  t49 = t47 + t48
  t56 = r0 ** 2
  t57 = t12 ** 2
  t58 = t57 ** 2
  t59 = t58 * t12
  t61 = 0.1e1 / t59 / t56
  t63 = 0.1e1 / t6
  t66 = t59 * r0
  t67 = 0.1e1 / t66
  t72 = t6 * t5
  t73 = 0.1e1 / t72
  t76 = t25 ** 2
  t78 = 0.1e1 / t76 / t56
  t82 = -0.10865248000000000000000000000000000000000000000000e3 * t1 * t3 * t9 + 0.51225984000000000000000000000000000000000000000000e2 * t16 * t2 * t9 - 0.32016240000000000000000000000000000000000000000000e2 * t16 * t3 * t22 - 0.28957824000000000000000000000000000000000000000000e3 * t29 * t2 * t9 + 0.18098640000000000000000000000000000000000000000000e3 * t29 * t3 * t22 + 0.37346880000000000000000000000000000000000000000000e3 * t40 * t2 * t9 - 0.23341800000000000000000000000000000000000000000000e3 * t40 * t3 * t22 - 0.13038297600000000000000000000000000000000000000000e3 * t49 * t2 * t9 + 0.81489360000000000000000000000000000000000000000000e2 * t49 * t3 * t22 - 0.79258310185185185185185185185185185185185185185186e-1 * t61 * t3 * t63 + 0.34585444444444444444444444444444444444444444444444e0 * t67 * t2 * t63 - 0.34585444444444444444444444444444444444444444444444e0 * t67 * t3 * t73 + 0.74480000000000000000000000000000000000000000000000e0 * t78 * t3 * t63
  t83 = t76 * r0
  t84 = 0.1e1 / t83
  t89 = 0.1e1 / t36 / t56
  t93 = r0 ** (-0.23333333333333333333333333333333333333333333333333e1)
  t97 = 0.1e1 / t59
  t99 = 0.1e1 / t7
  t114 = 0.1e1 / t76
  t127 = 0.1e1 / t37
  t131 = -0.35750400000000000000000000000000000000000000000000e1 * t84 * t2 * t63 - 0.10941468750000000000000000000000000000000000000000e1 * t89 * t3 * t63 + 0.33534716049382716049382716049382716049382716049380e0 * t93 * t3 * t63 - 0.18676140000000000000000000000000000000000000000000e1 * t97 * t3 * t99 - 0.44822736000000000000000000000000000000000000000000e2 * t12 * t2 * t99 + 0.29881824000000000000000000000000000000000000000000e2 * t12 * t3 * t9 + 0.24901520000000000000000000000000000000000000000000e1 * t97 * t2 * t73 + 0.35750400000000000000000000000000000000000000000000e1 * t84 * t3 * t73 - 0.32175360000000000000000000000000000000000000000000e2 * t114 * t2 * t73 + 0.24131520000000000000000000000000000000000000000000e2 * t114 * t3 * t99 + 0.28957824000000000000000000000000000000000000000000e3 * t25 * t2 * t99 - 0.19305216000000000000000000000000000000000000000000e3 * t25 * t3 * t9 + 0.58354500000000000000000000000000000000000000000000e1 * t127 * t2 * t63
  t133 = 0.1e1 / t36
  t149 = r0 ** (-0.13333333333333333333333333333333333333333333333333e1)
  t153 = r0 ** (-0.3333333333333333333333333333333333333333333333333e0)
  t168 = r0 ** (0.1e1 / 0.12e2)
  t169 = t168 ** 2
  t170 = t169 * t168
  t171 = t169 ** 2
  t172 = t171 ** 2
  t177 = 0.70025400000000000000000000000000000000000000000000e2 * t133 * t2 * t73 - 0.42015240000000000000000000000000000000000000000000e3 * t36 * t2 * t99 - 0.58354500000000000000000000000000000000000000000000e1 * t127 * t3 * t73 - 0.52519050000000000000000000000000000000000000000000e2 * t133 * t3 * t99 + 0.28010160000000000000000000000000000000000000000000e3 * t36 * t3 * t9 - 0.20120829629629629629629629629629629629629629629629e1 * t149 * t2 * t63 - 0.36217493333333333333333333333333333333333333333336e2 * t153 * t2 * t73 + 0.16297872000000000000000000000000000000000000000000e3 * t1 * t2 * t99 + 0.20120829629629629629629629629629629629629629629629e1 * t149 * t3 * t73 + 0.27163120000000000000000000000000000000000000000002e2 * t153 * t3 * t99 - 0.90443812500000000000000000000000000000000000000000e0 * t89 - 0.52230775462962962962962962962962962962962962962963e0 * t61 + 0.10767144864004629629629629629629629629629629629630e0 / t172 / t170 / t56
  t178 = t56 ** 2
  t181 = s0 / t76 / t178
  t182 = 0.1e1 / t5
  t183 = t2 * t182
  t184 = 0.1e1 + t183
  t185 = t184 <= f.p.zeta_threshold
  t186 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t187 = t186 * f.p.zeta_threshold
  t188 = t184 ** (0.1e1 / 0.3e1)
  t190 = f.my_piecewise3(t185, t187, t188 * t184)
  t191 = t190 ** 2
  t192 = 2 ** (0.1e1 / 0.3e1)
  t193 = t191 * t192
  t194 = t181 * t193
  t196 = s0 * t78
  t198 = -t2 * t63 + t182
  t201 = f.my_piecewise3(t185, 0, 0.4e1 / 0.3e1 * t188 * t198)
  t202 = t201 ** 2
  t203 = t202 * t192
  t204 = t196 * t203
  t206 = r1 ** 2
  t207 = t27 ** 2
  t210 = s2 / t207 / t206
  t211 = 0.1e1 - t183
  t212 = t211 <= f.p.zeta_threshold
  t213 = t211 ** (0.1e1 / 0.3e1)
  t214 = -t198
  t217 = f.my_piecewise3(t212, 0, 0.4e1 / 0.3e1 * t213 * t214)
  t218 = t217 ** 2
  t220 = t210 * t218 * t192
  t224 = 0.1e1 / t25 / t56
  t226 = t56 * r0
  t229 = s0 / t76 / t226
  t230 = t190 * t192
  t231 = t230 * t201
  t232 = t229 * t231
  t234 = t188 ** 2
  t235 = 0.1e1 / t234
  t236 = t198 ** 2
  t241 = 0.2e1 * t2 * t73 - 0.2e1 * t63
  t245 = f.my_piecewise3(t185, 0, 0.4e1 / 0.9e1 * t235 * t236 + 0.4e1 / 0.3e1 * t188 * t241)
  t246 = t230 * t245
  t247 = t196 * t246
  t250 = f.my_piecewise3(t212, t187, t213 * t211)
  t251 = t250 * t192
  t252 = t213 ** 2
  t253 = 0.1e1 / t252
  t254 = t214 ** 2
  t257 = -t241
  t261 = f.my_piecewise3(t212, 0, 0.4e1 / 0.9e1 * t253 * t254 + 0.4e1 / 0.3e1 * t213 * t257)
  t263 = t210 * t251 * t261
  t269 = t14 ** 2
  t270 = t269 ** 2
  t273 = t270 * t14 * r1 + t66
  t274 = jnp.sqrt(s0)
  t275 = t178 * r0
  t279 = t192 ** 2
  t280 = t190 * t279
  t285 = t274 / t25 / t178
  t286 = t201 * t279
  t291 = t274 / t25 / t226
  t292 = t245 * t279
  t295 = t274 * t224
  t297 = 0.1e1 / t234 / t184
  t301 = t235 * t198
  t306 = -0.6e1 * t2 * t99 + 0.6e1 * t73
  t310 = f.my_piecewise3(t185, 0, -0.8e1 / 0.27e2 * t297 * t236 * t198 + 0.4e1 / 0.3e1 * t301 * t241 + 0.4e1 / 0.3e1 * t188 * t306)
  t311 = t310 * t279
  t314 = 0.1e1 / t26
  t315 = t274 * t314
  t316 = t184 ** 2
  t319 = t236 ** 2
  t325 = t241 ** 2
  t332 = 0.24e2 * t2 * t9 - 0.24e2 * t99
  t336 = f.my_piecewise3(t185, 0, 0.40e2 / 0.81e2 / t234 / t316 * t319 - 0.16e2 / 0.9e1 * t297 * t236 * t241 + 0.4e1 / 0.3e1 * t235 * t325 + 0.16e2 / 0.9e1 * t301 * t306 + 0.4e1 / 0.3e1 * t188 * t332)
  t340 = jnp.sqrt(s2)
  t342 = t340 / t28
  t343 = t211 ** 2
  t346 = t254 ** 2
  t350 = 0.1e1 / t252 / t211
  t354 = t257 ** 2
  t357 = t253 * t214
  t358 = -t306
  t365 = f.my_piecewise3(t212, 0, 0.40e2 / 0.81e2 / t252 / t343 * t346 - 0.16e2 / 0.9e1 * t350 * t254 * t257 + 0.4e1 / 0.3e1 * t253 * t354 + 0.16e2 / 0.9e1 * t357 * t358 - 0.4e1 / 0.3e1 * t213 * t332)
  t369 = 0.910e3 / 0.81e2 * t274 / t25 / t275 * t280 - 0.280e3 / 0.27e2 * t285 * t286 + 0.14e2 / 0.3e1 * t291 * t292 - 0.4e1 / 0.3e1 * t295 * t311 + t315 * t336 * t279 / 0.4e1 + t342 * t365 * t279 / 0.4e1
  t387 = f.my_piecewise3(t212, 0, -0.8e1 / 0.27e2 * t350 * t254 * t214 + 0.4e1 / 0.3e1 * t357 * t257 + 0.4e1 / 0.3e1 * t213 * t358)
  t391 = -0.70e2 / 0.27e2 * t285 * t280 + 0.7e1 / 0.3e1 * t291 * t286 - t295 * t292 + t315 * t311 / 0.4e1 + t342 * t387 * t279 / 0.4e1
  t396 = s0 / t76 / t275
  t397 = t396 * t193
  t399 = t181 * t231
  t401 = t229 * t203
  t403 = t229 * t246
  t405 = t201 * t192
  t406 = t405 * t245
  t407 = t196 * t406
  t409 = t230 * t310
  t410 = t196 * t409
  t412 = t217 * t192
  t414 = t210 * t412 * t261
  t417 = t210 * t251 * t387
  t419 = -0.154e3 / 0.27e2 * t397 + 0.22e2 / 0.3e1 * t399 - 0.2e1 * t401 - 0.2e1 * t403 + 0.3e1 / 0.4e1 * t407 + t410 / 0.4e1 + 0.3e1 / 0.4e1 * t414 + t417 / 0.4e1
  t422 = 0.13042820560000000000000000000000000000000000000000e1 * t194 + 0.26678496600000000000000000000000000000000000000000e0 * t204 + 0.26678496600000000000000000000000000000000000000000e0 * t220 + 0.63049876543209876543209876543209876543209876543212e0 * t78 + 0.18054814814814814814814814814814814814814814814815e0 * t224 - 0.14228531520000000000000000000000000000000000000000e1 * t232 + 0.26678496600000000000000000000000000000000000000000e0 * t247 + 0.26678496600000000000000000000000000000000000000000e0 * t263 - 0.19209744000000000000000000000000000000000000000000e2 * t16 * t99 + 0.10859184000000000000000000000000000000000000000000e3 * t29 * t99 - 0.35845850000000000000000000000000000000000000000000e-1 * t273 * t369 - 0.26286956666666666666666666666666666666666666666667e0 * t59 * t391 - 0.13572233333333333333333333333333333333333333333333e0 * t76 * t419
  t426 = t207 * r1 + t83
  t431 = s0 / t76 / t178 / t56 * t193
  t433 = t396 * t231
  t435 = t181 * t203
  t437 = t181 * t246
  t439 = t229 * t406
  t441 = t229 * t409
  t443 = t245 ** 2
  t445 = t196 * t443 * t192
  t448 = t196 * t405 * t310
  t450 = t196 * t230 * t336
  t452 = t261 ** 2
  t454 = t210 * t452 * t192
  t457 = t210 * t412 * t387
  t459 = t210 * t251 * t365
  t461 = 0.2618e4 / 0.81e2 * t431 - 0.1232e4 / 0.27e2 * t433 + 0.44e2 / 0.3e1 * t435 + 0.44e2 / 0.3e1 * t437 - 0.8e1 * t439 - 0.8e1 / 0.3e1 * t441 + 0.3e1 / 0.4e1 * t445 + t448 + t450 / 0.4e1 + 0.3e1 / 0.4e1 * t454 + t457 + t459 / 0.4e1
  t468 = t171 * t168
  t470 = r1 ** (0.1e1 / 0.12e2)
  t471 = t470 ** 2
  t472 = t471 ** 2
  t493 = s0 + 0.2e1 * s1 + s2
  t494 = t5 ** (0.1e1 / 0.3e1)
  t495 = t494 ** 2
  t500 = 0.5236e4 / 0.81e2 * t431 - 0.2464e4 / 0.27e2 * t433 + 0.88e2 / 0.3e1 * t435 + 0.88e2 / 0.3e1 * t437 - 0.16e2 * t439 - 0.16e2 / 0.3e1 * t441 + 0.3e1 / 0.2e1 * t445 + 0.2e1 * t448 + t450 / 0.2e1 + 0.3e1 / 0.2e1 * t454 + 0.2e1 * t457 + t459 / 0.2e1 - 0.20944e5 / 0.81e2 * t493 / t495 / t21
  t515 = -0.308e3 / 0.27e2 * t397 + 0.44e2 / 0.3e1 * t399 - 0.4e1 * t401 - 0.4e1 * t403 + 0.3e1 / 0.2e1 * t407 + t410 / 0.2e1 + 0.3e1 / 0.2e1 * t414 + t417 / 0.2e1 + 0.1232e4 / 0.27e2 * t493 / t495 / t8
  t518 = t56 + t206
  t531 = t493 / t495 / t7
  t533 = -0.20358350000000000000000000000000000000000000000000e-1 * t426 * t461 + 0.73486500000000000000000000000000000000000000000000e-1 * t40 * t369 + 0.44091900000000000000000000000000000000000000000000e0 * t36 * t391 - 0.90663500000000000000000000000000000000000000000000e-1 * (t472 * t470 * r1 + t468 * r0) * t369 - 0.51375983333333333333333333333333333333333333333332e0 * t468 * t391 + 0.31037700000000000000000000000000000000000000000000e-1 * t426 * t500 + 0.20691800000000000000000000000000000000000000000000e0 * t76 * t515 - 0.38407800000000000000000000000000000000000000000000e-3 * t518 * t461 - 0.30726240000000000000000000000000000000000000000000e-2 * r0 * t419 + 0.78695833333333333333333333333333333333333333333332e-1 * t59 * t419 - 0.52823906666666666666666666666666666666666666666668e0 * t59 * t515 - 0.72032600000000000000000000000000000000000000000000e-1 * t273 * t500 - 0.52396608000000000000000000000000000000000000000000e1 * t531
  t534 = 0.1e1 / t12
  t542 = 0.22e2 / 0.9e1 * t194 - 0.8e1 / 0.3e1 * t232 + t204 / 0.2e1 + t247 / 0.2e1 + t220 / 0.2e1 + t263 / 0.2e1 - 0.88e2 / 0.9e1 * t531
  t545 = t171 * t170
  t556 = 0.7e1 / 0.9e1 * t291 * t280 - 0.2e1 / 0.3e1 * t295 * t286 + t315 * t292 / 0.4e1 + t342 * t261 * t279 / 0.4e1
  t559 = 0.1e1 / t25
  t568 = 0.11e2 / 0.9e1 * t194 - 0.4e1 / 0.3e1 * t232 + t204 / 0.4e1 + t247 / 0.4e1 + t220 / 0.4e1 + t263 / 0.4e1
  t571 = t229 * t193
  t573 = t196 * t231
  t576 = t210 * t251 * t217
  t582 = -0.2e1 / 0.3e1 * t571 + t573 / 0.2e1 + t576 / 0.2e1 + 0.8e1 / 0.3e1 * t493 / t495 / t72
  t587 = 0.1e1 / t13
  t591 = -t571 / 0.3e1 + t573 / 0.4e1 + t576 / 0.4e1
  t603 = -t295 * t280 / 0.3e1 + t315 * t286 / 0.4e1 + t342 * t217 * t279 / 0.4e1
  t612 = t342 * t250 * t279 / 0.4e1 + t315 * t280 / 0.4e1
  t619 = -0.66029883333333333333333333333333333333333333333335e0 * t534 * t542 - 0.32109989583333333333333333333333333333333333333332e0 / t545 * t556 + 0.20691800000000000000000000000000000000000000000000e0 * t559 * t542 + 0.98369791666666666666666666666666666666666666666664e-1 * t534 * t568 - 0.45981777777777777777777777777777777777777777777777e-1 * t314 * t582 - 0.13572233333333333333333333333333333333333333333333e0 * t559 * t568 - 0.10929976851851851851851851851851851851851851851852e-1 * t587 * t591 + 0.33068925000000000000000000000000000000000000000000e0 * t133 * t556 - 0.10899333333333333333333333333333333333333333333333e0 * t314 * t603 + 0.30160518518518518518518518518518518518518518518519e-1 * t314 * t591 + 0.36331111111111111111111111111111111111111111111111e-1 * t224 * t612 + 0.73366537037037037037037037037037037037037037037040e-1 * t587 * t582 - 0.11022975000000000000000000000000000000000000000000e0 * t127 * t603
  t626 = 0.1e1 / t12 / t56
  t627 = t196 * t193
  t629 = t250 ** 2
  t631 = t210 * t629 * t192
  t636 = t627 / 0.4e1 + t631 / 0.4e1 - t493 / t495 / t6
  t642 = t627 / 0.8e1 + t631 / 0.8e1
  t663 = -0.14005080000000000000000000000000000000000000000000e3 * t40 * t99 + 0.48893616000000000000000000000000000000000000000000e2 * t49 * t99 - 0.21398573302469135802469135802469135802469135802470e-1 * t626 * t636 + 0.15327259259259259259259259259259259259259259259259e-1 * t224 * t636 + 0.31879099151234567901234567901234567901234567901233e-2 * t626 * t642 - 0.10053506172839506172839506172839506172839506172840e-1 * t224 * t642 + 0.36509662037037037037037037037037037037037037037037e-1 * t587 * t603 - 0.62253800000000000000000000000000000000000000000000e0 * t97 * t63 + 0.80438400000000000000000000000000000000000000000000e1 * t114 * t63 - 0.10648651427469135802469135802469135802469135802469e-1 * t626 * t612 + 0.12487218171296296296296296296296296296296296296296e0 / t545 / r0 * t603 + 0.90543733333333333333333333333333333333333333333340e1 * t153 * t63 + 0.41336156250000000000000000000000000000000000000000e-1 * t89 * t612
  t692 = -0.17506350000000000000000000000000000000000000000000e2 * t133 * t63 - 0.49428571928047839506172839506172839506172839506172e-1 / t545 / t56 * t612 + 0.44656200000000000000000000000000000000000000000000e-1 * t518 * t500 + 0.35724960000000000000000000000000000000000000000000e0 * r0 * t515 + 0.49047000000000000000000000000000000000000000000000e0 * t559 * t556 - 0.32858695833333333333333333333333333333333333333334e0 * t534 * t556 + 0.14005080000000000000000000000000000000000000000000e3 * t36 * t73 - 0.54326240000000000000000000000000000000000000000000e2 * t1 * t73 + 0.14940912000000000000000000000000000000000000000000e2 * t12 * t73 - 0.96526080000000000000000000000000000000000000000000e2 * t25 * t73 + 0.73570500000000000000000000000000000000000000000000e-1 * t426 * t369 + 0.10731250000000000000000000000000000000000000000000e-1 * t273 * t461 + 0.49047000000000000000000000000000000000000000000000e0 * t76 * t391
  d1111 = t82 + t131 + t177 + t422 + t533 + t619 + t663 + t692

  res = {'v4rho4': d1111}
  return res
