"""Generated from hyb_lda_xc_bn05.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import jax.scipy.special as jsp_special
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *


def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  att_yuk_aux1 = lambda a: jnp.arctan2(1, a)

  att_yuk_aux2 = lambda a: jnp.log(1 + 1 / a ** 2)

  att_yuk_aux3 = lambda a: a ** 2 + 1

  a_cnst = (4 / (9 * jnp.pi)) ** (1 / 3) * f.p.cam_omega / 2

  lda_x_ax = -f.RS_FACTOR * X_FACTOR_C / 2 ** (4 / 3)

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  bn05_A = 3.4602

  bn05_C0 = 3.2

  bn05_C1 = -0.9

  attenuation_yukawa0 = lambda a: 1 - 8 / 3 * a * (att_yuk_aux1(a) + a / 4 * (1 - (att_yuk_aux3(a) + 2) * att_yuk_aux2(a)))

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  attenuation_yukawa = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.92, lambda _aval: -1 / 7030 * (1.0 / jnp.maximum(_aval, 1.92)) ** 36 + 1 / 5985 * (1.0 / jnp.maximum(_aval, 1.92)) ** 34 - 1 / 5049 * (1.0 / jnp.maximum(_aval, 1.92)) ** 32 + 1 / 4216 * (1.0 / jnp.maximum(_aval, 1.92)) ** 30 - 1 / 3480 * (1.0 / jnp.maximum(_aval, 1.92)) ** 28 + 1 / 2835 * (1.0 / jnp.maximum(_aval, 1.92)) ** 26 - 1 / 2275 * (1.0 / jnp.maximum(_aval, 1.92)) ** 24 + 1 / 1794 * (1.0 / jnp.maximum(_aval, 1.92)) ** 22 - 1 / 1386 * (1.0 / jnp.maximum(_aval, 1.92)) ** 20 + 1 / 1045 * (1.0 / jnp.maximum(_aval, 1.92)) ** 18 - 1 / 765 * (1.0 / jnp.maximum(_aval, 1.92)) ** 16 + 1 / 540 * (1.0 / jnp.maximum(_aval, 1.92)) ** 14 - 1 / 364 * (1.0 / jnp.maximum(_aval, 1.92)) ** 12 + 1 / 231 * (1.0 / jnp.maximum(_aval, 1.92)) ** 10 - 1 / 135 * (1.0 / jnp.maximum(_aval, 1.92)) ** 8 + 1 / 70 * (1.0 / jnp.maximum(_aval, 1.92)) ** 6 - 1 / 30 * (1.0 / jnp.maximum(_aval, 1.92)) ** 4 + 1 / 9 * (1.0 / jnp.maximum(_aval, 1.92)) ** 2, lambda _aval: attenuation_yukawa0(jnp.minimum(_aval, 1.92)))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  lda_x_yukawa_spin = lambda rs, z: lda_x_ax * f.opz_pow_n(z, 4 / 3) / rs * attenuation_yukawa(a_cnst * rs / f.opz_pow_n(z, 1 / 3))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  f_lda_x_yukawa = lambda rs, z: lda_x_yukawa_spin(rs, z) + lda_x_yukawa_spin(rs, -z)

  functional_body = lambda rs, z: f_lda_x_yukawa(rs, z) + f_pw(rs, z) * bn05_A / (bn05_C0 + bn05_C1 * rs + rs ** 2)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
  )
  return res


def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  att_yuk_aux1 = lambda a: jnp.arctan2(1, a)

  att_yuk_aux2 = lambda a: jnp.log(1 + 1 / a ** 2)

  att_yuk_aux3 = lambda a: a ** 2 + 1

  a_cnst = (4 / (9 * jnp.pi)) ** (1 / 3) * f.p.cam_omega / 2

  lda_x_ax = -f.RS_FACTOR * X_FACTOR_C / 2 ** (4 / 3)

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  bn05_A = 3.4602

  bn05_C0 = 3.2

  bn05_C1 = -0.9

  attenuation_yukawa0 = lambda a: 1 - 8 / 3 * a * (att_yuk_aux1(a) + a / 4 * (1 - (att_yuk_aux3(a) + 2) * att_yuk_aux2(a)))

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  attenuation_yukawa = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.92, lambda _aval: -1 / 7030 * (1.0 / jnp.maximum(_aval, 1.92)) ** 36 + 1 / 5985 * (1.0 / jnp.maximum(_aval, 1.92)) ** 34 - 1 / 5049 * (1.0 / jnp.maximum(_aval, 1.92)) ** 32 + 1 / 4216 * (1.0 / jnp.maximum(_aval, 1.92)) ** 30 - 1 / 3480 * (1.0 / jnp.maximum(_aval, 1.92)) ** 28 + 1 / 2835 * (1.0 / jnp.maximum(_aval, 1.92)) ** 26 - 1 / 2275 * (1.0 / jnp.maximum(_aval, 1.92)) ** 24 + 1 / 1794 * (1.0 / jnp.maximum(_aval, 1.92)) ** 22 - 1 / 1386 * (1.0 / jnp.maximum(_aval, 1.92)) ** 20 + 1 / 1045 * (1.0 / jnp.maximum(_aval, 1.92)) ** 18 - 1 / 765 * (1.0 / jnp.maximum(_aval, 1.92)) ** 16 + 1 / 540 * (1.0 / jnp.maximum(_aval, 1.92)) ** 14 - 1 / 364 * (1.0 / jnp.maximum(_aval, 1.92)) ** 12 + 1 / 231 * (1.0 / jnp.maximum(_aval, 1.92)) ** 10 - 1 / 135 * (1.0 / jnp.maximum(_aval, 1.92)) ** 8 + 1 / 70 * (1.0 / jnp.maximum(_aval, 1.92)) ** 6 - 1 / 30 * (1.0 / jnp.maximum(_aval, 1.92)) ** 4 + 1 / 9 * (1.0 / jnp.maximum(_aval, 1.92)) ** 2, lambda _aval: attenuation_yukawa0(jnp.minimum(_aval, 1.92)))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  lda_x_yukawa_spin = lambda rs, z: lda_x_ax * f.opz_pow_n(z, 4 / 3) / rs * attenuation_yukawa(a_cnst * rs / f.opz_pow_n(z, 1 / 3))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  f_lda_x_yukawa = lambda rs, z: lda_x_yukawa_spin(rs, z) + lda_x_yukawa_spin(rs, -z)

  functional_body = lambda rs, z: f_lda_x_yukawa(rs, z) + f_pw(rs, z) * bn05_A / (bn05_C0 + bn05_C1 * rs + rs ** 2)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = t4 * t6
  t8 = 2 ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t10 = r0 - r1
  t11 = r0 + r1
  t12 = 0.1e1 / t11
  t13 = t10 * t12
  t14 = 0.1e1 + t13
  t15 = t14 <= f.p.zeta_threshold
  t16 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t17 = t16 * f.p.zeta_threshold
  t18 = t14 ** (0.1e1 / 0.3e1)
  t20 = f.my_piecewise3(t15, t17, t18 * t14)
  t21 = t9 * t20
  t22 = t11 ** (0.1e1 / 0.3e1)
  t23 = 9 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = t3 ** 2
  t27 = t24 * t25 * f.p.cam_omega
  t28 = 0.1e1 / t22
  t29 = t1 * t28
  t30 = f.my_piecewise3(t15, t16, t18)
  t31 = 0.1e1 / t30
  t34 = t27 * t29 * t31 / 0.18e2
  t35 = 0.192e1 <= t34
  t36 = 0.192e1 < t34
  t37 = f.my_piecewise3(t36, t34, 0.192e1)
  t38 = t37 ** 2
  t41 = t38 ** 2
  t44 = t41 * t38
  t47 = t41 ** 2
  t50 = t47 * t38
  t53 = t47 * t41
  t56 = t47 * t44
  t59 = t47 ** 2
  t83 = t59 ** 2
  t92 = 0.1e1 / t38 / 0.9e1 - 0.1e1 / t41 / 0.30e2 + 0.1e1 / t44 / 0.70e2 - 0.1e1 / t47 / 0.135e3 + 0.1e1 / t50 / 0.231e3 - 0.1e1 / t53 / 0.364e3 + 0.1e1 / t56 / 0.540e3 - 0.1e1 / t59 / 0.765e3 + 0.1e1 / t59 / t38 / 0.1045e4 - 0.1e1 / t59 / t41 / 0.1386e4 + 0.1e1 / t59 / t44 / 0.1794e4 - 0.1e1 / t59 / t47 / 0.2275e4 + 0.1e1 / t59 / t50 / 0.2835e4 - 0.1e1 / t59 / t53 / 0.3480e4 + 0.1e1 / t59 / t56 / 0.4216e4 - 0.1e1 / t83 / 0.5049e4 + 0.1e1 / t83 / t38 / 0.5985e4 - 0.1e1 / t83 / t41 / 0.7030e4
  t93 = f.my_piecewise3(t36, 0.192e1, t34)
  t94 = jnp.atan2(0.1e1, t93)
  t95 = t93 ** 2
  t96 = t95 + 0.3e1
  t97 = 0.1e1 / t95
  t98 = 0.1e1 + t97
  t99 = jnp.log(t98)
  t101 = -t96 * t99 + 0.1e1
  t104 = t94 + t93 * t101 / 0.4e1
  t108 = f.my_piecewise3(t35, t92, 0.1e1 - 0.8e1 / 0.3e1 * t93 * t104)
  t109 = t22 * t108
  t112 = 0.3e1 / 0.32e2 * t7 * t21 * t109
  t113 = 0.1e1 - t13
  t114 = t113 <= f.p.zeta_threshold
  t115 = t113 ** (0.1e1 / 0.3e1)
  t117 = f.my_piecewise3(t114, t17, t115 * t113)
  t118 = t9 * t117
  t119 = f.my_piecewise3(t114, t16, t115)
  t120 = 0.1e1 / t119
  t123 = t27 * t29 * t120 / 0.18e2
  t124 = 0.192e1 <= t123
  t125 = 0.192e1 < t123
  t126 = f.my_piecewise3(t125, t123, 0.192e1)
  t127 = t126 ** 2
  t130 = t127 ** 2
  t133 = t130 * t127
  t136 = t130 ** 2
  t139 = t136 * t127
  t142 = t136 * t130
  t145 = t136 * t133
  t148 = t136 ** 2
  t172 = t148 ** 2
  t181 = 0.1e1 / t127 / 0.9e1 - 0.1e1 / t130 / 0.30e2 + 0.1e1 / t133 / 0.70e2 - 0.1e1 / t136 / 0.135e3 + 0.1e1 / t139 / 0.231e3 - 0.1e1 / t142 / 0.364e3 + 0.1e1 / t145 / 0.540e3 - 0.1e1 / t148 / 0.765e3 + 0.1e1 / t148 / t127 / 0.1045e4 - 0.1e1 / t148 / t130 / 0.1386e4 + 0.1e1 / t148 / t133 / 0.1794e4 - 0.1e1 / t148 / t136 / 0.2275e4 + 0.1e1 / t148 / t139 / 0.2835e4 - 0.1e1 / t148 / t142 / 0.3480e4 + 0.1e1 / t148 / t145 / 0.4216e4 - 0.1e1 / t172 / 0.5049e4 + 0.1e1 / t172 / t127 / 0.5985e4 - 0.1e1 / t172 / t130 / 0.7030e4
  t182 = f.my_piecewise3(t125, 0.192e1, t123)
  t183 = jnp.atan2(0.1e1, t182)
  t184 = t182 ** 2
  t185 = t184 + 0.3e1
  t186 = 0.1e1 / t184
  t187 = 0.1e1 + t186
  t188 = jnp.log(t187)
  t190 = -t185 * t188 + 0.1e1
  t193 = t183 + t182 * t190 / 0.4e1
  t197 = f.my_piecewise3(t124, t181, 0.1e1 - 0.8e1 / 0.3e1 * t182 * t193)
  t198 = t22 * t197
  t201 = 0.3e1 / 0.32e2 * t7 * t118 * t198
  t203 = t4 * t6 * t28
  t205 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t203
  t206 = jnp.sqrt(t203)
  t209 = t203 ** 0.15e1
  t211 = t1 ** 2
  t212 = t211 * t25
  t213 = t22 ** 2
  t214 = 0.1e1 / t213
  t216 = t212 * t5 * t214
  t218 = 0.37978500000000000000000000000000000000000000000000e1 * t206 + 0.89690000000000000000000000000000000000000000000000e0 * t203 + 0.20477500000000000000000000000000000000000000000000e0 * t209 + 0.12323500000000000000000000000000000000000000000000e0 * t216
  t221 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t218
  t222 = jnp.log(t221)
  t224 = 0.621814e-1 * t205 * t222
  t225 = t10 ** 2
  t226 = t225 ** 2
  t227 = t11 ** 2
  t228 = t227 ** 2
  t229 = 0.1e1 / t228
  t230 = t226 * t229
  t234 = 0.1e1 / (0.2e1 * t8 - 0.2e1)
  t235 = (t20 + t117 - 0.2e1) * t234
  t237 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t203
  t242 = 0.70594500000000000000000000000000000000000000000000e1 * t206 + 0.15494250000000000000000000000000000000000000000000e1 * t203 + 0.42077500000000000000000000000000000000000000000000e0 * t209 + 0.15629250000000000000000000000000000000000000000000e0 * t216
  t245 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t242
  t246 = jnp.log(t245)
  t250 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t203
  t255 = 0.51785000000000000000000000000000000000000000000000e1 * t206 + 0.90577500000000000000000000000000000000000000000000e0 * t203 + 0.11003250000000000000000000000000000000000000000000e0 * t209 + 0.12417750000000000000000000000000000000000000000000e0 * t216
  t258 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t255
  t259 = jnp.log(t258)
  t260 = t250 * t259
  t262 = -0.3109070e-1 * t237 * t246 + t224 - 0.19751673498613801407483339618206552048944131217655e-1 * t260
  t263 = t235 * t262
  t267 = -t224 + t230 * t263 + 0.19751673498613801407483339618206552048944131217655e-1 * t235 * t260
  t270 = 0.32e1 - 0.22500000000000000000000000000000000000000000000000e0 * t203 + t216 / 0.4e1
  t271 = 0.1e1 / t270
  t273 = 0.34602e1 * t267 * t271
  t275 = t10 / t227
  t276 = t12 - t275
  t279 = f.my_piecewise3(t15, 0, 0.4e1 / 0.3e1 * t18 * t276)
  t287 = t7 * t21 * t214 * t108 / 0.32e2
  t288 = t38 * t37
  t289 = 0.1e1 / t288
  t291 = 0.1e1 / t22 / t11
  t292 = t1 * t291
  t295 = t27 * t292 * t31 / 0.54e2
  t296 = t30 ** 2
  t297 = 0.1e1 / t296
  t298 = t18 ** 2
  t299 = 0.1e1 / t298
  t302 = f.my_piecewise3(t15, 0, t299 * t276 / 0.3e1)
  t307 = -t295 - t27 * t29 * t297 * t302 / 0.18e2
  t308 = f.my_piecewise3(t36, t307, 0)
  t311 = t41 * t37
  t312 = 0.1e1 / t311
  t315 = t41 * t288
  t316 = 0.1e1 / t315
  t319 = t47 * t37
  t320 = 0.1e1 / t319
  t323 = t47 * t288
  t324 = 0.1e1 / t323
  t327 = t47 * t311
  t328 = 0.1e1 / t327
  t331 = t47 * t315
  t332 = 0.1e1 / t331
  t336 = 0.1e1 / t59 / t37
  t340 = 0.1e1 / t59 / t288
  t344 = 0.1e1 / t59 / t311
  t348 = 0.1e1 / t59 / t315
  t352 = 0.1e1 / t59 / t319
  t356 = 0.1e1 / t59 / t323
  t360 = 0.1e1 / t59 / t327
  t364 = 0.1e1 / t59 / t331
  t368 = 0.1e1 / t83 / t37
  t372 = 0.1e1 / t83 / t288
  t376 = 0.1e1 / t83 / t311
  t379 = -0.2e1 / 0.9e1 * t289 * t308 + 0.2e1 / 0.15e2 * t312 * t308 - 0.3e1 / 0.35e2 * t316 * t308 + 0.8e1 / 0.135e3 * t320 * t308 - 0.10e2 / 0.231e3 * t324 * t308 + 0.3e1 / 0.91e2 * t328 * t308 - 0.7e1 / 0.270e3 * t332 * t308 + 0.16e2 / 0.765e3 * t336 * t308 - 0.18e2 / 0.1045e4 * t340 * t308 + 0.10e2 / 0.693e3 * t344 * t308 - 0.11e2 / 0.897e3 * t348 * t308 + 0.24e2 / 0.2275e4 * t352 * t308 - 0.26e2 / 0.2835e4 * t356 * t308 + 0.7e1 / 0.870e3 * t360 * t308 - 0.15e2 / 0.2108e4 * t364 * t308 + 0.32e2 / 0.5049e4 * t368 * t308 - 0.34e2 / 0.5985e4 * t372 * t308 + 0.18e2 / 0.3515e4 * t376 * t308
  t380 = f.my_piecewise3(t36, 0, t307)
  t383 = 0.1e1 / t98
  t391 = t96 / t95 / t93
  t402 = f.my_piecewise3(t35, t379, -0.8e1 / 0.3e1 * t380 * t104 - 0.8e1 / 0.3e1 * t93 * (-t97 * t380 * t383 + t380 * t101 / 0.4e1 + t93 * (0.2e1 * t391 * t380 * t383 - 0.2e1 * t93 * t380 * t99) / 0.4e1))
  t407 = -t276
  t410 = f.my_piecewise3(t114, 0, 0.4e1 / 0.3e1 * t115 * t407)
  t418 = t7 * t118 * t214 * t197 / 0.32e2
  t419 = t127 * t126
  t420 = 0.1e1 / t419
  t423 = t27 * t292 * t120 / 0.54e2
  t424 = t119 ** 2
  t425 = 0.1e1 / t424
  t426 = t115 ** 2
  t427 = 0.1e1 / t426
  t430 = f.my_piecewise3(t114, 0, t427 * t407 / 0.3e1)
  t435 = -t423 - t27 * t29 * t425 * t430 / 0.18e2
  t436 = f.my_piecewise3(t125, t435, 0)
  t439 = t130 * t126
  t440 = 0.1e1 / t439
  t443 = t130 * t419
  t444 = 0.1e1 / t443
  t447 = t136 * t126
  t448 = 0.1e1 / t447
  t451 = t136 * t419
  t452 = 0.1e1 / t451
  t455 = t136 * t439
  t456 = 0.1e1 / t455
  t459 = t136 * t443
  t460 = 0.1e1 / t459
  t464 = 0.1e1 / t148 / t126
  t468 = 0.1e1 / t148 / t419
  t472 = 0.1e1 / t148 / t439
  t476 = 0.1e1 / t148 / t443
  t480 = 0.1e1 / t148 / t447
  t484 = 0.1e1 / t148 / t451
  t488 = 0.1e1 / t148 / t455
  t492 = 0.1e1 / t148 / t459
  t496 = 0.1e1 / t172 / t126
  t500 = 0.1e1 / t172 / t419
  t504 = 0.1e1 / t172 / t439
  t507 = -0.2e1 / 0.9e1 * t420 * t436 + 0.2e1 / 0.15e2 * t440 * t436 - 0.3e1 / 0.35e2 * t444 * t436 + 0.8e1 / 0.135e3 * t448 * t436 - 0.10e2 / 0.231e3 * t452 * t436 + 0.3e1 / 0.91e2 * t456 * t436 - 0.7e1 / 0.270e3 * t460 * t436 + 0.16e2 / 0.765e3 * t464 * t436 - 0.18e2 / 0.1045e4 * t468 * t436 + 0.10e2 / 0.693e3 * t472 * t436 - 0.11e2 / 0.897e3 * t476 * t436 + 0.24e2 / 0.2275e4 * t480 * t436 - 0.26e2 / 0.2835e4 * t484 * t436 + 0.7e1 / 0.870e3 * t488 * t436 - 0.15e2 / 0.2108e4 * t492 * t436 + 0.32e2 / 0.5049e4 * t496 * t436 - 0.34e2 / 0.5985e4 * t500 * t436 + 0.18e2 / 0.3515e4 * t504 * t436
  t508 = f.my_piecewise3(t125, 0, t435)
  t511 = 0.1e1 / t187
  t519 = t185 / t184 / t182
  t530 = f.my_piecewise3(t124, t507, -0.8e1 / 0.3e1 * t508 * t193 - 0.8e1 / 0.3e1 * t182 * (-t186 * t508 * t511 + t508 * t190 / 0.4e1 + t182 * (-0.2e1 * t182 * t508 * t188 + 0.2e1 * t519 * t508 * t511) / 0.4e1))
  t535 = t6 * t291
  t538 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t535 * t222
  t539 = t218 ** 2
  t544 = t3 * t6
  t545 = t544 * t291
  t546 = 0.1e1 / t206 * t1 * t545
  t548 = t4 * t535
  t550 = t203 ** 0.5e0
  t552 = t550 * t1 * t545
  t557 = t212 * t5 / t213 / t11
  t563 = 0.10000000000000000000000000000000000000000000000000e1 * t205 / t539 * (-0.63297500000000000000000000000000000000000000000000e0 * t546 - 0.29896666666666666666666666666666666666666666666667e0 * t548 - 0.10238750000000000000000000000000000000000000000000e0 * t552 - 0.82156666666666666666666666666666666666666666666667e-1 * t557) / t221
  t567 = 0.4e1 * t225 * t10 * t229 * t263
  t572 = 0.4e1 * t226 / t228 / t11 * t263
  t574 = (t279 + t410) * t234
  t580 = t242 ** 2
  t595 = t255 ** 2
  t596 = 0.1e1 / t595
  t602 = -0.86308333333333333333333333333333333333333333333334e0 * t546 - 0.30192500000000000000000000000000000000000000000000e0 * t548 - 0.55016250000000000000000000000000000000000000000000e-1 * t552 - 0.82785000000000000000000000000000000000000000000000e-1 * t557
  t603 = 0.1e1 / t258
  t609 = t230 * t235 * (0.53237641966666666666666666666666666666666666666666e-3 * t4 * t535 * t246 + 0.10000000000000000000000000000000000000000000000000e1 * t237 / t580 * (-0.11765750000000000000000000000000000000000000000000e1 * t546 - 0.51647500000000000000000000000000000000000000000000e0 * t548 - 0.21038750000000000000000000000000000000000000000000e0 * t552 - 0.10419500000000000000000000000000000000000000000000e0 * t557) / t245 - t538 - t563 + 0.18311447306006545054854346104378990962041954983034e-3 * t4 * t535 * t259 + 0.58482236226346462072622386637590534819724553404280e0 * t250 * t596 * t602 * t603)
  t616 = 0.18311447306006545054854346104378990962041954983034e-3 * t235 * t1 * t544 * t291 * t259
  t621 = 0.58482236226346462072622386637590534819724553404280e0 * t235 * t250 * t596 * t602 * t603
  t625 = t270 ** 2
  t632 = 0.34602e1 * t267 / t625 * (0.75000000000000000000000000000000000000000000000000e-1 * t548 - t557 / 0.6e1)
  vrho_0_ = -t112 - t201 + t273 + t11 * (-0.3e1 / 0.32e2 * t7 * t9 * t279 * t109 - t287 - 0.3e1 / 0.32e2 * t7 * t21 * t22 * t402 - 0.3e1 / 0.32e2 * t7 * t9 * t410 * t198 - t418 - 0.3e1 / 0.32e2 * t7 * t118 * t22 * t530 + 0.34602e1 * (t538 + t563 + t567 - t572 + t230 * t574 * t262 + t609 + 0.19751673498613801407483339618206552048944131217655e-1 * t574 * t260 - t616 - t621) * t271 - t632)
  t635 = -t12 - t275
  t638 = f.my_piecewise3(t15, 0, 0.4e1 / 0.3e1 * t18 * t635)
  t645 = f.my_piecewise3(t15, 0, t299 * t635 / 0.3e1)
  t650 = -t295 - t27 * t29 * t297 * t645 / 0.18e2
  t651 = f.my_piecewise3(t36, t650, 0)
  t688 = -0.2e1 / 0.9e1 * t289 * t651 + 0.2e1 / 0.15e2 * t312 * t651 - 0.3e1 / 0.35e2 * t316 * t651 + 0.8e1 / 0.135e3 * t320 * t651 - 0.10e2 / 0.231e3 * t324 * t651 + 0.3e1 / 0.91e2 * t328 * t651 - 0.7e1 / 0.270e3 * t332 * t651 + 0.16e2 / 0.765e3 * t336 * t651 - 0.18e2 / 0.1045e4 * t340 * t651 + 0.10e2 / 0.693e3 * t344 * t651 - 0.11e2 / 0.897e3 * t348 * t651 + 0.24e2 / 0.2275e4 * t352 * t651 - 0.26e2 / 0.2835e4 * t356 * t651 + 0.7e1 / 0.870e3 * t360 * t651 - 0.15e2 / 0.2108e4 * t364 * t651 + 0.32e2 / 0.5049e4 * t368 * t651 - 0.34e2 / 0.5985e4 * t372 * t651 + 0.18e2 / 0.3515e4 * t376 * t651
  t689 = f.my_piecewise3(t36, 0, t650)
  t707 = f.my_piecewise3(t35, t688, -0.8e1 / 0.3e1 * t689 * t104 - 0.8e1 / 0.3e1 * t93 * (-t97 * t689 * t383 + t689 * t101 / 0.4e1 + t93 * (0.2e1 * t391 * t689 * t383 - 0.2e1 * t93 * t689 * t99) / 0.4e1))
  t712 = -t635
  t715 = f.my_piecewise3(t114, 0, 0.4e1 / 0.3e1 * t115 * t712)
  t722 = f.my_piecewise3(t114, 0, t427 * t712 / 0.3e1)
  t727 = -t423 - t27 * t29 * t425 * t722 / 0.18e2
  t728 = f.my_piecewise3(t125, t727, 0)
  t765 = -0.2e1 / 0.9e1 * t420 * t728 + 0.2e1 / 0.15e2 * t440 * t728 - 0.3e1 / 0.35e2 * t444 * t728 + 0.8e1 / 0.135e3 * t448 * t728 - 0.10e2 / 0.231e3 * t452 * t728 + 0.3e1 / 0.91e2 * t456 * t728 - 0.7e1 / 0.270e3 * t460 * t728 + 0.16e2 / 0.765e3 * t464 * t728 - 0.18e2 / 0.1045e4 * t468 * t728 + 0.10e2 / 0.693e3 * t472 * t728 - 0.11e2 / 0.897e3 * t476 * t728 + 0.24e2 / 0.2275e4 * t480 * t728 - 0.26e2 / 0.2835e4 * t484 * t728 + 0.7e1 / 0.870e3 * t488 * t728 - 0.15e2 / 0.2108e4 * t492 * t728 + 0.32e2 / 0.5049e4 * t496 * t728 - 0.34e2 / 0.5985e4 * t500 * t728 + 0.18e2 / 0.3515e4 * t504 * t728
  t766 = f.my_piecewise3(t125, 0, t727)
  t784 = f.my_piecewise3(t124, t765, -0.8e1 / 0.3e1 * t766 * t193 - 0.8e1 / 0.3e1 * t182 * (-t186 * t766 * t511 + t766 * t190 / 0.4e1 + t182 * (-0.2e1 * t182 * t766 * t188 + 0.2e1 * t519 * t766 * t511) / 0.4e1))
  t790 = (t638 + t715) * t234
  vrho_1_ = -t112 - t201 + t273 + t11 * (-0.3e1 / 0.32e2 * t7 * t9 * t638 * t109 - t287 - 0.3e1 / 0.32e2 * t7 * t21 * t22 * t707 - 0.3e1 / 0.32e2 * t7 * t9 * t715 * t198 - t418 - 0.3e1 / 0.32e2 * t7 * t118 * t22 * t784 + 0.34602e1 * (t538 + t563 - t567 - t572 + t230 * t790 * t262 + t609 + 0.19751673498613801407483339618206552048944131217655e-1 * t790 * t260 - t616 - t621) * t271 - t632)

  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1)}
  return res


def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = t4 * t6
  t8 = 2 ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t10 = 0.1e1 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t13 = f.my_piecewise3(t10, t11 * f.p.zeta_threshold, 1)
  t14 = t9 * t13
  t15 = r0 ** (0.1e1 / 0.3e1)
  t16 = 9 ** (0.1e1 / 0.3e1)
  t17 = t16 ** 2
  t18 = t3 ** 2
  t20 = t17 * t18 * f.p.cam_omega
  t21 = 0.1e1 / t15
  t23 = f.my_piecewise3(t10, t11, 1)
  t24 = 0.1e1 / t23
  t27 = t20 * t1 * t21 * t24 / 0.18e2
  t28 = 0.192e1 <= t27
  t29 = 0.192e1 < t27
  t30 = f.my_piecewise3(t29, t27, 0.192e1)
  t31 = t30 ** 2
  t34 = t31 ** 2
  t37 = t34 * t31
  t40 = t34 ** 2
  t43 = t40 * t31
  t46 = t40 * t34
  t49 = t40 * t37
  t52 = t40 ** 2
  t76 = t52 ** 2
  t85 = 0.1e1 / t31 / 0.9e1 - 0.1e1 / t34 / 0.30e2 + 0.1e1 / t37 / 0.70e2 - 0.1e1 / t40 / 0.135e3 + 0.1e1 / t43 / 0.231e3 - 0.1e1 / t46 / 0.364e3 + 0.1e1 / t49 / 0.540e3 - 0.1e1 / t52 / 0.765e3 + 0.1e1 / t52 / t31 / 0.1045e4 - 0.1e1 / t52 / t34 / 0.1386e4 + 0.1e1 / t52 / t37 / 0.1794e4 - 0.1e1 / t52 / t40 / 0.2275e4 + 0.1e1 / t52 / t43 / 0.2835e4 - 0.1e1 / t52 / t46 / 0.3480e4 + 0.1e1 / t52 / t49 / 0.4216e4 - 0.1e1 / t76 / 0.5049e4 + 0.1e1 / t76 / t31 / 0.5985e4 - 0.1e1 / t76 / t34 / 0.7030e4
  t86 = f.my_piecewise3(t29, 0.192e1, t27)
  t87 = jnp.atan2(0.1e1, t86)
  t88 = t86 ** 2
  t89 = t88 + 0.3e1
  t90 = 0.1e1 / t88
  t91 = 0.1e1 + t90
  t92 = jnp.log(t91)
  t94 = -t89 * t92 + 0.1e1
  t97 = t87 + t86 * t94 / 0.4e1
  t101 = f.my_piecewise3(t28, t85, 0.1e1 - 0.8e1 / 0.3e1 * t86 * t97)
  t107 = t4 * t6 * t21
  t109 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t107
  t110 = jnp.sqrt(t107)
  t113 = t107 ** 0.15e1
  t115 = t1 ** 2
  t116 = t115 * t18
  t117 = t15 ** 2
  t118 = 0.1e1 / t117
  t120 = t116 * t5 * t118
  t122 = 0.37978500000000000000000000000000000000000000000000e1 * t110 + 0.89690000000000000000000000000000000000000000000000e0 * t107 + 0.20477500000000000000000000000000000000000000000000e0 * t113 + 0.12323500000000000000000000000000000000000000000000e0 * t120
  t125 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t122
  t126 = jnp.log(t125)
  t134 = (0.2e1 * t13 - 0.2e1) / (0.2e1 * t8 - 0.2e1)
  t136 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t107
  t141 = 0.51785000000000000000000000000000000000000000000000e1 * t110 + 0.90577500000000000000000000000000000000000000000000e0 * t107 + 0.11003250000000000000000000000000000000000000000000e0 * t113 + 0.12417750000000000000000000000000000000000000000000e0 * t120
  t144 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t141
  t145 = jnp.log(t144)
  t149 = -0.621814e-1 * t109 * t126 + 0.19751673498613801407483339618206552048944131217655e-1 * t134 * t136 * t145
  t152 = 0.32e1 - 0.22500000000000000000000000000000000000000000000000e0 * t107 + t120 / 0.4e1
  t153 = 0.1e1 / t152
  t160 = t31 * t30
  t163 = 0.1e1 / t15 / r0
  t167 = t20 * t1 * t163 * t24 / 0.54e2
  t168 = f.my_piecewise3(t29, -t167, 0)
  t171 = t34 * t30
  t175 = t34 * t160
  t179 = t40 * t30
  t183 = t40 * t160
  t187 = t40 * t171
  t191 = t40 * t175
  t239 = -0.2e1 / 0.9e1 / t160 * t168 + 0.2e1 / 0.15e2 / t171 * t168 - 0.3e1 / 0.35e2 / t175 * t168 + 0.8e1 / 0.135e3 / t179 * t168 - 0.10e2 / 0.231e3 / t183 * t168 + 0.3e1 / 0.91e2 / t187 * t168 - 0.7e1 / 0.270e3 / t191 * t168 + 0.16e2 / 0.765e3 / t52 / t30 * t168 - 0.18e2 / 0.1045e4 / t52 / t160 * t168 + 0.10e2 / 0.693e3 / t52 / t171 * t168 - 0.11e2 / 0.897e3 / t52 / t175 * t168 + 0.24e2 / 0.2275e4 / t52 / t179 * t168 - 0.26e2 / 0.2835e4 / t52 / t183 * t168 + 0.7e1 / 0.870e3 / t52 / t187 * t168 - 0.15e2 / 0.2108e4 / t52 / t191 * t168 + 0.32e2 / 0.5049e4 / t76 / t30 * t168 - 0.34e2 / 0.5985e4 / t76 / t160 * t168 + 0.18e2 / 0.3515e4 / t76 / t171 * t168
  t240 = f.my_piecewise3(t29, 0, -t167)
  t243 = 0.1e1 / t91
  t262 = f.my_piecewise3(t28, t239, -0.8e1 / 0.3e1 * t240 * t97 - 0.8e1 / 0.3e1 * t86 * (-t90 * t240 * t243 + t240 * t94 / 0.4e1 + t86 * (-0.2e1 * t86 * t240 * t92 + 0.2e1 * t89 / t88 / t86 * t240 * t243) / 0.4e1))
  t267 = t6 * t163
  t271 = t122 ** 2
  t276 = t3 * t6
  t277 = t276 * t163
  t278 = 0.1e1 / t110 * t1 * t277
  t280 = t4 * t267
  t282 = t107 ** 0.5e0
  t284 = t282 * t1 * t277
  t289 = t116 * t5 / t117 / r0
  t302 = t141 ** 2
  t317 = t152 ** 2
  vrho_0_ = -0.3e1 / 0.16e2 * t7 * t14 * t15 * t101 + 0.34602e1 * t149 * t153 + r0 * (-t7 * t14 * t118 * t101 / 0.16e2 - 0.3e1 / 0.16e2 * t7 * t14 * t15 * t262 + 0.34602e1 * (0.11073470983333333333333333333333333333333333333333e-2 * t4 * t267 * t126 + 0.10000000000000000000000000000000000000000000000000e1 * t109 / t271 * (-0.63297500000000000000000000000000000000000000000000e0 * t278 - 0.29896666666666666666666666666666666666666666666667e0 * t280 - 0.10238750000000000000000000000000000000000000000000e0 * t284 - 0.82156666666666666666666666666666666666666666666667e-1 * t289) / t125 - 0.18311447306006545054854346104378990962041954983034e-3 * t134 * t1 * t276 * t163 * t145 - 0.58482236226346462072622386637590534819724553404280e0 * t134 * t136 / t302 * (-0.86308333333333333333333333333333333333333333333334e0 * t278 - 0.30192500000000000000000000000000000000000000000000e0 * t280 - 0.55016250000000000000000000000000000000000000000000e-1 * t284 - 0.82785000000000000000000000000000000000000000000000e-1 * t289) / t144) * t153 - 0.34602e1 * t149 / t317 * (0.75000000000000000000000000000000000000000000000000e-1 * t280 - t289 / 0.6e1))

  res = {'vrho': vrho_0_}
  return res
