"""Generated from lda_x_rel.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_alpha = 1

  beta = lambda rs: (9 * jnp.pi / 4) ** (1 / 3) / (rs * M_C)

  f_lda_x = lambda rs, z: +params_alpha * f.my_piecewise3(f.screen_dens(rs, z), 0, f.lda_x_spin(rs, z)) + params_alpha * f.my_piecewise3(f.screen_dens(rs, -z), 0, f.lda_x_spin(rs, -z))

  phi = lambda rs: 1 - 1.5 * (jnp.sqrt(1 + beta(rs) ** 2) / beta(rs) - jnp.arcsinh(beta(rs)) / beta(rs) ** 2) ** 2

  functional_body = lambda rs, z: f_lda_x(rs, z) * phi(rs)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_alpha = 1

  beta = lambda rs: (9 * jnp.pi / 4) ** (1 / 3) / (rs * M_C)

  f_lda_x = lambda rs, z: +params_alpha * f.my_piecewise3(f.screen_dens(rs, z), 0, f.lda_x_spin(rs, z)) + params_alpha * f.my_piecewise3(f.screen_dens(rs, -z), 0, f.lda_x_spin(rs, -z))

  phi = lambda rs: 1 - 1.5 * (jnp.sqrt(1 + beta(rs) ** 2) / beta(rs) - jnp.arcsinh(beta(rs)) / beta(rs) ** 2) ** 2

  functional_body = lambda rs, z: f_lda_x(rs, z) * phi(rs)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_alpha = 1

  beta = lambda rs: (9 * jnp.pi / 4) ** (1 / 3) / (rs * M_C)

  f_lda_x = lambda rs, z: +params_alpha * f.my_piecewise3(f.screen_dens(rs, z), 0, f.lda_x_spin(rs, z)) + params_alpha * f.my_piecewise3(f.screen_dens(rs, -z), 0, f.lda_x_spin(rs, -z))

  phi = lambda rs: 1 - 1.5 * (jnp.sqrt(1 + beta(rs) ** 2) / beta(rs) - jnp.arcsinh(beta(rs)) / beta(rs) ** 2) ** 2

  functional_body = lambda rs, z: f_lda_x(rs, z) * phi(rs)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t4 = 0.1e1 / t3
  t5 = t2 * t4
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t8 = r0 * t7
  t10 = 0.2e1 * t8 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t12 = t11 * f.p.zeta_threshold
  t13 = 2 ** (0.1e1 / 0.3e1)
  t14 = t13 * r0
  t15 = t8 ** (0.1e1 / 0.3e1)
  t19 = f.my_piecewise3(t10, t12, 0.2e1 * t14 * t7 * t15)
  t20 = t6 ** (0.1e1 / 0.3e1)
  t24 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t19 * t20)
  t25 = r1 <= f.p.dens_threshold
  t26 = r1 * t7
  t28 = 0.2e1 * t26 <= f.p.zeta_threshold
  t29 = t13 * r1
  t30 = t26 ** (0.1e1 / 0.3e1)
  t34 = f.my_piecewise3(t28, t12, 0.2e1 * t29 * t7 * t30)
  t38 = f.my_piecewise3(t25, 0, -0.3e1 / 0.8e1 * t5 * t34 * t20)
  t39 = t24 + t38
  t40 = 9 ** (0.1e1 / 0.3e1)
  t41 = t40 ** 2
  t42 = t3 ** 2
  t45 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t46 = t45 ** 2
  t49 = t20 ** 2
  t54 = jnp.sqrt(0.1e1 + 0.17750451365686221606162525710885164915525131374403e-4 * t41 * t42 * t2 / t46 * t49)
  t56 = t54 * t41 * t4
  t57 = t2 * t45
  t63 = t2 ** 2
  t65 = t63 / t45
  t69 = jnp.arcsinh(0.24324508467583486201881266313614310329863507558814e-2 * t40 * t3 * t65 * t20)
  t72 = t69 * t40 / t42
  t73 = t63 * t46
  t74 = 0.1e1 / t49
  t78 = 0.15226222180972388888888888888888888888888888888889e2 * t56 * t57 / t20 - 0.20865405771390201384250498613611111111111111111111e4 * t72 * t73 * t74
  t79 = t78 ** 2
  t81 = 0.1e1 - 0.15e1 * t79
  t82 = t39 * t81
  t83 = t13 * t7
  t86 = t6 ** 2
  t87 = 0.1e1 / t86
  t90 = 0.2e1 * t14 * t87 * t15
  t91 = t15 ** 2
  t92 = 0.1e1 / t91
  t100 = f.my_piecewise3(t10, 0, 0.2e1 * t83 * t15 - t90 + 0.2e1 / 0.3e1 * t14 * t7 * t92 * (-r0 * t87 + t7))
  t106 = t5 * t19 * t74 / 0.8e1
  t108 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t100 * t20 - t106)
  t111 = 0.2e1 * t29 * t87 * t30
  t112 = r1 ** 2
  t115 = 0.1e1 / t86 / t6
  t116 = t30 ** 2
  t117 = 0.1e1 / t116
  t122 = f.my_piecewise3(t28, 0, -t111 - 0.2e1 / 0.3e1 * t13 * t112 * t115 * t117)
  t128 = t5 * t34 * t74 / 0.8e1
  t130 = f.my_piecewise3(t25, 0, -0.3e1 / 0.8e1 * t5 * t122 * t20 - t128)
  t135 = 0.1e1 / t54
  t143 = t57 / t20 / t6
  t158 = 0.30e1 * t6 * t39 * t78 * (0.81081694891944954006270887712047701099545025196047e-3 * t135 * t40 * t3 * t65 * t74 - 0.50754073936574629629629629629629629629629629629630e1 * t56 * t143 - 0.50754073936574629629629629629629629629629629629629e1 * t135 * t41 * t4 * t143 + 0.13910270514260134256166999075740740740740740740741e4 * t72 * t73 / t49 / t6)
  vrho_0_ = t82 + t6 * (t108 + t130) * t81 - t158
  t159 = r0 ** 2
  t165 = f.my_piecewise3(t10, 0, -t90 - 0.2e1 / 0.3e1 * t13 * t159 * t115 * t92)
  t170 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t165 * t20 - t106)
  t180 = f.my_piecewise3(t28, 0, 0.2e1 * t83 * t30 - t111 + 0.2e1 / 0.3e1 * t29 * t7 * t117 * (-r1 * t87 + t7))
  t185 = f.my_piecewise3(t25, 0, -0.3e1 / 0.8e1 * t5 * t180 * t20 - t128)
  vrho_1_ = t82 + t6 * (t170 + t185) * t81 - t158
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_alpha = 1

  beta = lambda rs: (9 * jnp.pi / 4) ** (1 / 3) / (rs * M_C)

  f_lda_x = lambda rs, z: +params_alpha * f.my_piecewise3(f.screen_dens(rs, z), 0, f.lda_x_spin(rs, z)) + params_alpha * f.my_piecewise3(f.screen_dens(rs, -z), 0, f.lda_x_spin(rs, -z))

  phi = lambda rs: 1 - 1.5 * (jnp.sqrt(1 + beta(rs) ** 2) / beta(rs) - jnp.arcsinh(beta(rs)) / beta(rs) ** 2) ** 2

  functional_body = lambda rs, z: f_lda_x(rs, z) * phi(rs)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = 0.1e1 / t4
  t6 = t3 * t5
  t8 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t10 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t8 * f.p.zeta_threshold, 1)
  t11 = r0 ** (0.1e1 / 0.3e1)
  t15 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t10 * t11)
  t16 = 9 ** (0.1e1 / 0.3e1)
  t17 = t16 ** 2
  t18 = t4 ** 2
  t21 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t25 = t11 ** 2
  t30 = jnp.sqrt(0.1e1 + 0.17750451365686221606162525710885164915525131374403e-4 * t17 * t18 * t3 / t22 * t25)
  t32 = t30 * t17 * t5
  t33 = t3 * t21
  t39 = t3 ** 2
  t41 = t39 / t21
  t45 = jnp.arcsinh(0.24324508467583486201881266313614310329863507558814e-2 * t16 * t4 * t41 * t11)
  t48 = t45 * t16 / t18
  t49 = t39 * t22
  t50 = 0.1e1 / t25
  t54 = 0.15226222180972388888888888888888888888888888888889e2 * t32 * t33 / t11 - 0.20865405771390201384250498613611111111111111111111e4 * t48 * t49 * t50
  t55 = t54 ** 2
  t57 = 0.1e1 - 0.15e1 * t55
  t63 = f.my_piecewise3(t2, 0, -t6 * t10 * t50 / 0.8e1)
  t68 = 0.1e1 / t30
  t76 = t33 / t11 / r0
  vrho_0_ = 0.2e1 * t15 * t57 + 0.2e1 * r0 * t63 * t57 - 0.60e1 * r0 * t15 * t54 * (0.81081694891944954006270887712047701099545025196047e-3 * t68 * t16 * t4 * t41 * t50 - 0.50754073936574629629629629629629629629629629629630e1 * t32 * t76 - 0.50754073936574629629629629629629629629629629629629e1 * t68 * t17 * t5 * t76 + 0.13910270514260134256166999075740740740740740740741e4 * t48 * t49 / t25 / r0)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  res = {'vrho': vrho_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = 0.1e1 / t4
  t6 = t3 * t5
  t8 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t10 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t8 * f.p.zeta_threshold, 1)
  t11 = r0 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t13 = 0.1e1 / t12
  t17 = f.my_piecewise3(t2, 0, -t6 * t10 * t13 / 0.8e1)
  t18 = 9 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t20 = t4 ** 2
  t23 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t30 = 0.1e1 + 0.17750451365686221606162525710885164915525131374403e-4 * t19 * t20 * t3 / t24 * t12
  t31 = jnp.sqrt(t30)
  t33 = t31 * t19 * t5
  t34 = t3 * t23
  t40 = t3 ** 2
  t42 = t40 / t23
  t46 = jnp.arcsinh(0.24324508467583486201881266313614310329863507558814e-2 * t18 * t4 * t42 * t11)
  t49 = t46 * t18 / t20
  t50 = t40 * t24
  t54 = 0.15226222180972388888888888888888888888888888888889e2 * t33 * t34 / t11 - 0.20865405771390201384250498613611111111111111111111e4 * t49 * t50 * t13
  t55 = t54 ** 2
  t57 = 0.1e1 - 0.15e1 * t55
  t63 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t10 * t11)
  t65 = 0.1e1 / t31
  t67 = t65 * t18 * t4
  t73 = t34 / t11 / r0
  t77 = t65 * t19 * t5
  t81 = 0.1e1 / t12 / r0
  t85 = 0.81081694891944954006270887712047701099545025196047e-3 * t67 * t42 * t13 - 0.50754073936574629629629629629629629629629629629630e1 * t33 * t73 - 0.50754073936574629629629629629629629629629629629629e1 * t77 * t73 + 0.13910270514260134256166999075740740740740740740741e4 * t49 * t50 * t81
  t91 = f.my_piecewise3(t2, 0, t6 * t10 * t81 / 0.12e2)
  t99 = r0 * t63
  t100 = t85 ** 2
  t104 = 0.1e1 / t31 / t30
  t105 = jnp.pi ** 2
  t110 = t42 * t81
  t113 = r0 ** 2
  t116 = t34 / t11 / t113
  v2rho2_0_ = 0.4e1 * t17 * t57 - 0.120e2 * t63 * t54 * t85 + 0.2e1 * r0 * t91 * t57 - 0.120e2 * r0 * t17 * t54 * t85 - 0.60e1 * t99 * t100 - 0.60e1 * t99 * t54 * (-0.12953130136441900625201432582267510256943087357081e-6 * t104 * t105 / r0 - 0.81081694891944954006270887712047701099545025196047e-3 * t67 * t110 + 0.67672098582099506172839506172839506172839506172840e1 * t33 * t116 + 0.27027231630648318002090295904015900366515008398682e-3 * t104 * t18 * t4 * t110 + 0.10150814787314925925925925925925925925925925925926e2 * t77 * t116 - 0.23183784190433557093611665126234567901234567901235e4 * t49 * t50 / t12 / t113)
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = 0.1e1 / t4
  t6 = t3 * t5
  t8 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t10 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t8 * f.p.zeta_threshold, 1)
  t11 = r0 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t14 = 0.1e1 / t12 / r0
  t18 = f.my_piecewise3(t2, 0, t6 * t10 * t14 / 0.12e2)
  t19 = 9 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = t4 ** 2
  t24 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = 0.1e1 / t25
  t31 = 0.1e1 + 0.17750451365686221606162525710885164915525131374403e-4 * t20 * t21 * t3 * t26 * t12
  t32 = jnp.sqrt(t31)
  t34 = t32 * t20 * t5
  t35 = t3 * t24
  t41 = t3 ** 2
  t43 = t41 / t24
  t47 = jnp.asinh(0.24324508467583486201881266313614310329863507558814e-2 * t19 * t4 * t43 * t11)
  t50 = t47 * t19 / t21
  t51 = t41 * t25
  t52 = 0.1e1 / t12
  t56 = 0.15226222180972388888888888888888888888888888888889e2 * t34 * t35 / t11 - 0.20865405771390201384250498613611111111111111111111e4 * t50 * t51 * t52
  t57 = t56 ** 2
  t59 = 0.1e1 - 0.15e1 * t57
  t65 = f.my_piecewise3(t2, 0, -t6 * t10 * t52 / 0.8e1)
  t67 = 0.1e1 / t32
  t69 = t67 * t19 * t4
  t74 = 0.1e1 / t11 / r0
  t75 = t35 * t74
  t79 = t67 * t20 * t5
  t85 = 0.81081694891944954006270887712047701099545025196047e-3 * t69 * t43 * t52 - 0.50754073936574629629629629629629629629629629629630e1 * t34 * t75 - 0.50754073936574629629629629629629629629629629629629e1 * t79 * t75 + 0.13910270514260134256166999075740740740740740740741e4 * t50 * t51 * t14
  t91 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t10 * t11)
  t92 = t85 ** 2
  t97 = 0.1e1 / t32 / t31
  t98 = jnp.pi ** 2
  t99 = t97 * t98
  t103 = t43 * t14
  t106 = r0 ** 2
  t109 = t35 / t11 / t106
  t113 = t97 * t19 * t4
  t119 = 0.1e1 / t12 / t106
  t123 = -0.12953130136441900625201432582267510256943087357081e-6 * t99 / r0 - 0.81081694891944954006270887712047701099545025196047e-3 * t69 * t103 + 0.67672098582099506172839506172839506172839506172840e1 * t34 * t109 + 0.27027231630648318002090295904015900366515008398682e-3 * t113 * t103 + 0.10150814787314925925925925925925925925925925925926e2 * t79 * t109 - 0.23183784190433557093611665126234567901234567901235e4 * t50 * t51 * t119
  t129 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t10 * t119)
  t137 = r0 * t65
  t143 = r0 * t91
  t147 = t31 ** 2
  t149 = 0.1e1 / t32 / t147
  t157 = 0.1e1 / t106
  t160 = t43 * t119
  t163 = t106 * r0
  t166 = t35 / t11 / t163
  v3rho3_0_ = 0.6e1 * t18 * t59 - 0.360e2 * t65 * t56 * t85 - 0.180e2 * t91 * t92 - 0.180e2 * t91 * t56 * t123 + 0.2e1 * r0 * t129 * t59 - 0.180e2 * r0 * t18 * t56 * t85 - 0.180e2 * t137 * t92 - 0.180e2 * t137 * t56 * t123 - 0.180e2 * t143 * t85 * t123 - 0.60e1 * t143 * t56 * (0.22992390652031648896286249923619720649148119883912e-11 * t149 * t21 * t98 * t74 * t20 * t3 * t26 + 0.25906260272883801250402865164535020513886174714162e-6 * t99 * t157 + 0.17117246699410601401323854072543403565459505319165e-2 * t69 * t160 - 0.15790156335823218106995884773662551440329218106996e2 * t34 * t166 - 0.12953130136441900625201432582267510256943087357081e-6 * t149 * t98 * t157 - 0.99099849312377166007664418314724968010555030795168e-3 * t113 * t160 - 0.29324576052243119341563786008230452674897119341564e2 * t79 * t166 + 0.61823424507822818916297773669958847736625514403293e4 * t50 * t51 / t12 / t163)

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = 0.1e1 / t4
  t6 = t3 * t5
  t8 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t10 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t8 * f.p.zeta_threshold, 1)
  t11 = r0 ** 2
  t12 = r0 ** (0.1e1 / 0.3e1)
  t13 = t12 ** 2
  t15 = 0.1e1 / t13 / t11
  t19 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t10 * t15)
  t20 = 9 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t22 = t4 ** 2
  t24 = 0.1e1 / jnp.pi
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = 0.1e1 / t26
  t32 = 0.1e1 + 0.17750451365686221606162525710885164915525131374403e-4 * t21 * t22 * t3 * t27 * t13
  t33 = jnp.sqrt(t32)
  t35 = t33 * t21 * t5
  t36 = t3 * t25
  t42 = t3 ** 2
  t44 = t42 / t25
  t48 = jnp.asinh(0.24324508467583486201881266313614310329863507558814e-2 * t20 * t4 * t44 * t12)
  t51 = t48 * t20 / t22
  t52 = t42 * t26
  t53 = 0.1e1 / t13
  t57 = 0.15226222180972388888888888888888888888888888888889e2 * t35 * t36 / t12 - 0.20865405771390201384250498613611111111111111111111e4 * t51 * t52 * t53
  t58 = t57 ** 2
  t60 = 0.1e1 - 0.15e1 * t58
  t64 = 0.1e1 / t33
  t66 = t64 * t20 * t4
  t71 = 0.1e1 / t12 / r0
  t72 = t36 * t71
  t76 = t64 * t21 * t5
  t80 = 0.1e1 / t13 / r0
  t84 = 0.81081694891944954006270887712047701099545025196047e-3 * t66 * t44 * t53 - 0.50754073936574629629629629629629629629629629629630e1 * t35 * t72 - 0.50754073936574629629629629629629629629629629629629e1 * t76 * t72 + 0.13910270514260134256166999075740740740740740740741e4 * t51 * t52 * t80
  t91 = f.my_piecewise3(t2, 0, t6 * t10 * t80 / 0.12e2)
  t92 = r0 * t91
  t93 = t84 ** 2
  t97 = 0.1e1 / t33 / t32
  t98 = jnp.pi ** 2
  t99 = t97 * t98
  t103 = t44 * t80
  t107 = 0.1e1 / t12 / t11
  t108 = t36 * t107
  t112 = t97 * t20 * t4
  t120 = -0.12953130136441900625201432582267510256943087357081e-6 * t99 / r0 - 0.81081694891944954006270887712047701099545025196047e-3 * t66 * t103 + 0.67672098582099506172839506172839506172839506172840e1 * t35 * t108 + 0.27027231630648318002090295904015900366515008398682e-3 * t112 * t103 + 0.10150814787314925925925925925925925925925925925926e2 * t76 * t108 - 0.23183784190433557093611665126234567901234567901235e4 * t51 * t52 * t15
  t127 = f.my_piecewise3(t2, 0, -t6 * t10 * t53 / 0.8e1)
  t128 = r0 * t127
  t132 = t32 ** 2
  t134 = 0.1e1 / t33 / t132
  t135 = t22 * t98
  t136 = t134 * t135
  t139 = t21 * t3 * t27
  t142 = 0.1e1 / t11
  t145 = t44 * t15
  t148 = t11 * r0
  t151 = t36 / t12 / t148
  t154 = t134 * t98
  t162 = 0.1e1 / t13 / t148
  t166 = 0.22992390652031648896286249923619720649148119883912e-11 * t136 * t71 * t139 + 0.25906260272883801250402865164535020513886174714162e-6 * t99 * t142 + 0.17117246699410601401323854072543403565459505319165e-2 * t66 * t145 - 0.15790156335823218106995884773662551440329218106996e2 * t35 * t151 - 0.12953130136441900625201432582267510256943087357081e-6 * t154 * t142 - 0.99099849312377166007664418314724968010555030795168e-3 * t112 * t145 - 0.29324576052243119341563786008230452674897119341564e2 * t76 * t151 + 0.61823424507822818916297773669958847736625514403293e4 * t51 * t52 * t162
  t173 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t10 * t12)
  t174 = r0 * t173
  t175 = t120 ** 2
  t183 = 0.1e1 / t33 / t132 / t32
  t197 = 0.1e1 / t148
  t200 = t44 * t162
  t203 = t11 ** 2
  t206 = t36 / t12 / t203
  t245 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t10 * t162)
  v4rho4_0_ = 0.8e1 * t19 * t60 - 0.240e2 * r0 * t19 * t57 * t84 - 0.360e2 * t92 * t93 - 0.360e2 * t92 * t57 * t120 - 0.720e2 * t128 * t84 * t120 - 0.240e2 * t128 * t57 * t166 - 0.180e2 * t174 * t175 - 0.240e2 * t174 * t84 * t166 - 0.60e1 * t174 * t57 * (-0.61218796807461944612555761243733303730668952993943e-15 * t183 * t4 * t98 * jnp.pi * t80 * t20 * t42 / t25 / t24 - 0.76641302173438829654287499745399068830493732946373e-11 * t136 * t107 * t139 - 0.79158017500478281598453199113857007125763311626605e-6 * t99 * t197 - 0.54054463261296636004180591808031800733030016797363e-2 * t66 * t200 + 0.52633854452744060356652949245541838134430727023320e2 * t35 * t206 + 0.38320651086719414827143749872699534415246866473187e-11 * t183 * t135 * t107 * t139 + 0.73401070773170770209474784632849224789344161690127e-6 * t154 * t197 + 0.42042360314341828003251571406246956125690013064617e-2 * t112 * t200 + 0.11278683097016584362139917695473251028806584362140e3 * t76 * t206 - 0.22668588986201700269309183678984910836762688614541e5 * t51 * t52 / t13 / t203) - 0.720e2 * t91 * t57 * t84 - 0.720e2 * t127 * t93 - 0.720e2 * t127 * t57 * t120 - 0.720e2 * t173 * t84 * t120 - 0.240e2 * t173 * t57 * t166 + 0.2e1 * r0 * t245 * t60

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t4 = 0.1e1 / t3
  t5 = t2 * t4
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t8 = r0 * t7
  t10 = 0.2e1 * t8 <= f.p.zeta_threshold
  t11 = 2 ** (0.1e1 / 0.3e1)
  t12 = t11 * t7
  t13 = t8 ** (0.1e1 / 0.3e1)
  t16 = t11 * r0
  t17 = t6 ** 2
  t18 = 0.1e1 / t17
  t21 = 0.2e1 * t16 * t18 * t13
  t22 = t13 ** 2
  t23 = 0.1e1 / t22
  t24 = t7 * t23
  t26 = -r0 * t18 + t7
  t31 = f.my_piecewise3(t10, 0, 0.2e1 * t12 * t13 - t21 + 0.2e1 / 0.3e1 * t16 * t24 * t26)
  t32 = t6 ** (0.1e1 / 0.3e1)
  t36 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t37 = t36 * f.p.zeta_threshold
  t41 = f.my_piecewise3(t10, t37, 0.2e1 * t16 * t7 * t13)
  t42 = t32 ** 2
  t43 = 0.1e1 / t42
  t46 = t5 * t41 * t43 / 0.8e1
  t48 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t32 - t46)
  t49 = r1 <= f.p.dens_threshold
  t50 = r1 * t7
  t52 = 0.2e1 * t50 <= f.p.zeta_threshold
  t53 = t11 * r1
  t54 = t50 ** (0.1e1 / 0.3e1)
  t57 = 0.2e1 * t53 * t18 * t54
  t58 = r1 ** 2
  t59 = t11 * t58
  t61 = 0.1e1 / t17 / t6
  t62 = t54 ** 2
  t63 = 0.1e1 / t62
  t68 = f.my_piecewise3(t52, 0, -t57 - 0.2e1 / 0.3e1 * t59 * t61 * t63)
  t75 = f.my_piecewise3(t52, t37, 0.2e1 * t53 * t7 * t54)
  t78 = t5 * t75 * t43 / 0.8e1
  t80 = f.my_piecewise3(t49, 0, -0.3e1 / 0.8e1 * t5 * t68 * t32 - t78)
  t81 = t48 + t80
  t82 = 9 ** (0.1e1 / 0.3e1)
  t83 = t82 ** 2
  t84 = t3 ** 2
  t87 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t88 = t87 ** 2
  t94 = 0.1e1 + 0.17750451365686221606162525710885164915525131374403e-4 * t83 * t84 * t2 / t88 * t42
  t95 = jnp.sqrt(t94)
  t97 = t95 * t83 * t4
  t98 = t2 * t87
  t104 = t2 ** 2
  t106 = t104 / t87
  t110 = jnp.arcsinh(0.24324508467583486201881266313614310329863507558814e-2 * t82 * t3 * t106 * t32)
  t113 = t110 * t82 / t84
  t114 = t104 * t88
  t118 = 0.15226222180972388888888888888888888888888888888889e2 * t97 * t98 / t32 - 0.20865405771390201384250498613611111111111111111111e4 * t113 * t114 * t43
  t119 = t118 ** 2
  t121 = 0.1e1 - 0.15e1 * t119
  t122 = t81 * t121
  t127 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t41 * t32)
  t131 = f.my_piecewise3(t49, 0, -0.3e1 / 0.8e1 * t5 * t75 * t32)
  t132 = t127 + t131
  t134 = 0.1e1 / t95
  t136 = t134 * t82 * t3
  t142 = t98 / t32 / t6
  t146 = t134 * t83 * t4
  t150 = 0.1e1 / t42 / t6
  t154 = 0.81081694891944954006270887712047701099545025196047e-3 * t136 * t106 * t43 - 0.50754073936574629629629629629629629629629629629630e1 * t97 * t142 - 0.50754073936574629629629629629629629629629629629629e1 * t146 * t142 + 0.13910270514260134256166999075740740740740740740741e4 * t113 * t114 * t150
  t156 = 0.60e1 * t132 * t118 * t154
  t157 = t11 * t18
  t158 = t157 * t13
  t165 = 0.4e1 * t16 * t61 * t13
  t168 = t16 * t18 * t23 * t26
  t171 = 0.1e1 / t22 / t8
  t173 = t26 ** 2
  t184 = f.my_piecewise3(t10, 0, -0.4e1 * t158 + 0.4e1 / 0.3e1 * t12 * t23 * t26 + t165 - 0.4e1 / 0.3e1 * t168 - 0.4e1 / 0.9e1 * t16 * t7 * t171 * t173 + 0.2e1 / 0.3e1 * t16 * t24 * (0.2e1 * r0 * t61 - 0.2e1 * t18))
  t189 = t5 * t31 * t43
  t193 = t5 * t41 * t150 / 0.12e2
  t195 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t184 * t32 - t189 / 0.4e1 + t193)
  t198 = 0.4e1 * t53 * t61 * t54
  t199 = t17 ** 2
  t200 = 0.1e1 / t199
  t202 = t59 * t200 * t63
  t207 = 0.1e1 / t199 / t6
  t209 = 0.1e1 / t62 / t50
  t214 = f.my_piecewise3(t52, 0, t198 + 0.8e1 / 0.3e1 * t202 - 0.4e1 / 0.9e1 * t11 * t58 * r1 * t207 * t209)
  t219 = t5 * t68 * t43
  t223 = t5 * t75 * t150 / 0.12e2
  t225 = f.my_piecewise3(t49, 0, -0.3e1 / 0.8e1 * t5 * t214 * t32 - t219 / 0.4e1 + t223)
  t230 = t118 * t154
  t231 = t6 * t81 * t230
  t233 = t6 * t132
  t234 = t154 ** 2
  t236 = 0.30e1 * t233 * t234
  t238 = 0.1e1 / t95 / t94
  t239 = jnp.pi ** 2
  t243 = t106 * t150
  t248 = t98 / t32 / t17
  t265 = 0.30e1 * t233 * t118 * (-0.12953130136441900625201432582267510256943087357081e-6 * t238 * t239 * t7 - 0.81081694891944954006270887712047701099545025196047e-3 * t136 * t243 + 0.67672098582099506172839506172839506172839506172840e1 * t97 * t248 + 0.27027231630648318002090295904015900366515008398682e-3 * t238 * t82 * t3 * t243 + 0.10150814787314925925925925925925925925925925925926e2 * t146 * t248 - 0.23183784190433557093611665126234567901234567901235e4 * t113 * t114 / t42 / t17)
  d11 = 0.2e1 * t122 - t156 + t6 * (t195 + t225) * t121 - 0.60e1 * t231 - t236 - t265
  t266 = r0 ** 2
  t267 = t11 * t266
  t268 = t61 * t23
  t272 = f.my_piecewise3(t10, 0, -t21 - 0.2e1 / 0.3e1 * t267 * t268)
  t277 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t272 * t32 - t46)
  t280 = t7 * t63
  t282 = -r1 * t18 + t7
  t287 = f.my_piecewise3(t52, 0, 0.2e1 * t12 * t54 - t57 + 0.2e1 / 0.3e1 * t53 * t280 * t282)
  t292 = f.my_piecewise3(t49, 0, -0.3e1 / 0.8e1 * t5 * t287 * t32 - t78)
  t293 = t277 + t292
  t294 = t293 * t121
  t300 = t267 * t200 * t23
  t307 = f.my_piecewise3(t10, 0, -0.2e1 * t158 + t165 - 0.2e1 / 0.3e1 * t168 - 0.4e1 / 0.3e1 * t16 * t268 + 0.2e1 * t300 + 0.4e1 / 0.9e1 * t267 * t61 * t171 * t26)
  t312 = t5 * t272 * t43
  t316 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t307 * t32 - t312 / 0.8e1 - t189 / 0.8e1 + t193)
  t317 = t157 * t54
  t326 = t53 * t18 * t63 * t282
  t332 = r1 * t61
  t339 = f.my_piecewise3(t52, 0, -0.2e1 * t317 - 0.2e1 / 0.3e1 * t11 * t61 * t63 * r1 + t198 + 0.2e1 / 0.3e1 * t202 - 0.2e1 / 0.3e1 * t326 + 0.4e1 / 0.9e1 * t59 * t61 * t209 * t282 + 0.2e1 / 0.3e1 * t53 * t280 * (-t18 + 0.2e1 * t332))
  t344 = t5 * t287 * t43
  t348 = f.my_piecewise3(t49, 0, -0.3e1 / 0.8e1 * t5 * t339 * t32 - t344 / 0.8e1 - t219 / 0.8e1 + t223)
  t353 = t6 * t293 * t230
  d12 = t122 - t156 + t294 + t6 * (t316 + t348) * t121 - 0.30e1 * t353 - 0.30e1 * t231 - t236 - t265
  t364 = f.my_piecewise3(t10, 0, t165 + 0.8e1 / 0.3e1 * t300 - 0.4e1 / 0.9e1 * t11 * t266 * r0 * t207 * t171)
  t370 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t364 * t32 - t312 / 0.4e1 + t193)
  t377 = t282 ** 2
  t387 = f.my_piecewise3(t52, 0, -0.4e1 * t317 + 0.4e1 / 0.3e1 * t12 * t63 * t282 + t198 - 0.4e1 / 0.3e1 * t326 - 0.4e1 / 0.9e1 * t53 * t7 * t209 * t377 + 0.2e1 / 0.3e1 * t53 * t280 * (-0.2e1 * t18 + 0.2e1 * t332))
  t393 = f.my_piecewise3(t49, 0, -0.3e1 / 0.8e1 * t5 * t387 * t32 - t344 / 0.4e1 + t223)
  d22 = 0.2e1 * t294 - t156 + t6 * (t370 + t393) * t121 - 0.60e1 * t353 - t236 - t265
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t4 = 0.1e1 / t3
  t5 = t2 * t4
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t8 = r0 * t7
  t10 = 0.2e1 * t8 <= f.p.zeta_threshold
  t11 = 2 ** (0.1e1 / 0.3e1)
  t12 = t6 ** 2
  t13 = 0.1e1 / t12
  t14 = t11 * t13
  t15 = t8 ** (0.1e1 / 0.3e1)
  t18 = t11 * t7
  t19 = t15 ** 2
  t20 = 0.1e1 / t19
  t22 = -r0 * t13 + t7
  t23 = t20 * t22
  t26 = t11 * r0
  t27 = t12 * t6
  t28 = 0.1e1 / t27
  t32 = t13 * t20
  t37 = 0.1e1 / t19 / t8
  t39 = t22 ** 2
  t43 = t7 * t20
  t46 = 0.2e1 * r0 * t28 - 0.2e1 * t13
  t51 = f.my_piecewise3(t10, 0, -0.4e1 * t14 * t15 + 0.4e1 / 0.3e1 * t18 * t23 + 0.4e1 * t26 * t28 * t15 - 0.4e1 / 0.3e1 * t26 * t32 * t22 - 0.4e1 / 0.9e1 * t26 * t7 * t37 * t39 + 0.2e1 / 0.3e1 * t26 * t43 * t46)
  t52 = t6 ** (0.1e1 / 0.3e1)
  t65 = f.my_piecewise3(t10, 0, 0.2e1 * t18 * t15 - 0.2e1 * t26 * t13 * t15 + 0.2e1 / 0.3e1 * t26 * t43 * t22)
  t66 = t52 ** 2
  t67 = 0.1e1 / t66
  t71 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t72 = t71 * f.p.zeta_threshold
  t76 = f.my_piecewise3(t10, t72, 0.2e1 * t26 * t7 * t15)
  t78 = 0.1e1 / t66 / t6
  t83 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t51 * t52 - t5 * t65 * t67 / 0.4e1 + t5 * t76 * t78 / 0.12e2)
  t84 = r1 <= f.p.dens_threshold
  t85 = r1 * t7
  t87 = 0.2e1 * t85 <= f.p.zeta_threshold
  t88 = t11 * r1
  t89 = t85 ** (0.1e1 / 0.3e1)
  t93 = r1 ** 2
  t94 = t11 * t93
  t95 = t12 ** 2
  t96 = 0.1e1 / t95
  t97 = t89 ** 2
  t98 = 0.1e1 / t97
  t103 = t11 * t93 * r1
  t105 = 0.1e1 / t95 / t6
  t107 = 0.1e1 / t97 / t85
  t112 = f.my_piecewise3(t87, 0, 0.4e1 * t88 * t28 * t89 + 0.8e1 / 0.3e1 * t94 * t96 * t98 - 0.4e1 / 0.9e1 * t103 * t105 * t107)
  t123 = f.my_piecewise3(t87, 0, -0.2e1 * t88 * t13 * t89 - 0.2e1 / 0.3e1 * t94 * t28 * t98)
  t130 = f.my_piecewise3(t87, t72, 0.2e1 * t88 * t7 * t89)
  t135 = f.my_piecewise3(t84, 0, -0.3e1 / 0.8e1 * t5 * t112 * t52 - t5 * t123 * t67 / 0.4e1 + t5 * t130 * t78 / 0.12e2)
  t136 = t83 + t135
  t137 = 9 ** (0.1e1 / 0.3e1)
  t138 = t137 ** 2
  t139 = t3 ** 2
  t142 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t143 = t142 ** 2
  t144 = 0.1e1 / t143
  t149 = 0.1e1 + 0.17750451365686221606162525710885164915525131374403e-4 * t138 * t139 * t2 * t144 * t66
  t150 = jnp.sqrt(t149)
  t152 = t150 * t138 * t4
  t153 = t2 * t142
  t159 = t2 ** 2
  t161 = t159 / t142
  t165 = jnp.asinh(0.24324508467583486201881266313614310329863507558814e-2 * t137 * t3 * t161 * t52)
  t168 = t165 * t137 / t139
  t169 = t159 * t143
  t173 = 0.15226222180972388888888888888888888888888888888889e2 * t152 * t153 / t52 - 0.20865405771390201384250498613611111111111111111111e4 * t168 * t169 * t67
  t174 = t173 ** 2
  t176 = 0.1e1 - 0.15e1 * t174
  t186 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t65 * t52 - t5 * t76 * t67 / 0.8e1)
  t194 = f.my_piecewise3(t84, 0, -0.3e1 / 0.8e1 * t5 * t123 * t52 - t5 * t130 * t67 / 0.8e1)
  t195 = t186 + t194
  t197 = 0.1e1 / t150
  t199 = t197 * t137 * t3
  t204 = 0.1e1 / t52 / t6
  t205 = t153 * t204
  t209 = t197 * t138 * t4
  t215 = 0.81081694891944954006270887712047701099545025196047e-3 * t199 * t161 * t67 - 0.50754073936574629629629629629629629629629629629630e1 * t152 * t205 - 0.50754073936574629629629629629629629629629629629629e1 * t209 * t205 + 0.13910270514260134256166999075740740740740740740741e4 * t168 * t169 * t78
  t221 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t76 * t52)
  t225 = f.my_piecewise3(t84, 0, -0.3e1 / 0.8e1 * t5 * t130 * t52)
  t226 = t221 + t225
  t227 = t215 ** 2
  t232 = 0.1e1 / t150 / t149
  t233 = jnp.pi ** 2
  t234 = t232 * t233
  t237 = t161 * t78
  t242 = t153 / t52 / t12
  t246 = t232 * t137 * t3
  t252 = 0.1e1 / t66 / t12
  t256 = -0.12953130136441900625201432582267510256943087357081e-6 * t234 * t7 - 0.81081694891944954006270887712047701099545025196047e-3 * t199 * t237 + 0.67672098582099506172839506172839506172839506172840e1 * t152 * t242 + 0.27027231630648318002090295904015900366515008398682e-3 * t246 * t237 + 0.10150814787314925925925925925925925925925925925926e2 * t209 * t242 - 0.23183784190433557093611665126234567901234567901235e4 * t168 * t169 * t252
  t284 = r0 ** 2
  t304 = 0.12e2 * t11 * t28 * t15 - 0.4e1 * t14 * t23 - 0.4e1 / 0.3e1 * t18 * t37 * t39 + 0.2e1 * t18 * t20 * t46 - 0.12e2 * t26 * t96 * t15 + 0.4e1 * t26 * t28 * t20 * t22 + 0.4e1 / 0.3e1 * t26 * t13 * t37 * t39 - 0.2e1 * t26 * t32 * t46 + 0.20e2 / 0.27e2 * t26 * t7 / t19 / t284 / t13 * t39 * t22 - 0.4e1 / 0.3e1 * t26 * t7 * t37 * t22 * t46 + 0.2e1 / 0.3e1 * t26 * t43 * (-0.6e1 * r0 * t96 + 0.6e1 * t28)
  t305 = f.my_piecewise3(t10, 0, t304)
  t319 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t305 * t52 - 0.3e1 / 0.8e1 * t5 * t51 * t67 + t5 * t65 * t78 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t76 * t252)
  t331 = t93 ** 2
  t342 = f.my_piecewise3(t87, 0, -0.12e2 * t88 * t96 * t89 - 0.12e2 * t94 * t105 * t98 + 0.4e1 * t103 / t95 / t12 * t107 - 0.20e2 / 0.27e2 * t11 * t331 / t95 / t27 / t97 / t93 / t13)
  t356 = f.my_piecewise3(t84, 0, -0.3e1 / 0.8e1 * t5 * t342 * t52 - 0.3e1 / 0.8e1 * t5 * t112 * t67 + t5 * t123 * t78 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t130 * t252)
  t364 = t6 * t195
  t370 = t6 * t226
  t374 = t149 ** 2
  t376 = 0.1e1 / t150 / t374
  t386 = t161 * t252
  t391 = t153 / t52 / t27
  d111 = 0.3e1 * t136 * t176 - 0.180e2 * t195 * t173 * t215 - 0.90e1 * t226 * t227 - 0.90e1 * t226 * t173 * t256 + t6 * (t319 + t356) * t176 - 0.90e1 * t6 * t136 * t173 * t215 - 0.90e1 * t364 * t227 - 0.90e1 * t364 * t173 * t256 - 0.90e1 * t370 * t215 * t256 - 0.30e1 * t370 * t173 * (0.22992390652031648896286249923619720649148119883912e-11 * t376 * t139 * t233 * t204 * t138 * t2 * t144 + 0.25906260272883801250402865164535020513886174714162e-6 * t234 * t13 + 0.17117246699410601401323854072543403565459505319165e-2 * t199 * t386 - 0.15790156335823218106995884773662551440329218106996e2 * t152 * t391 - 0.12953130136441900625201432582267510256943087357081e-6 * t376 * t233 * t13 - 0.99099849312377166007664418314724968010555030795168e-3 * t246 * t386 - 0.29324576052243119341563786008230452674897119341564e2 * t209 * t391 + 0.61823424507822818916297773669958847736625514403293e4 * t168 * t169 / t66 / t27)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t4 = 0.1e1 / t3
  t5 = t2 * t4
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t8 = r0 * t7
  t10 = 0.2e1 * t8 <= f.p.zeta_threshold
  t11 = 2 ** (0.1e1 / 0.3e1)
  t12 = t6 ** 2
  t13 = t12 * t6
  t14 = 0.1e1 / t13
  t15 = t11 * t14
  t16 = t8 ** (0.1e1 / 0.3e1)
  t19 = 0.1e1 / t12
  t20 = t11 * t19
  t21 = t16 ** 2
  t22 = 0.1e1 / t21
  t24 = -r0 * t19 + t7
  t25 = t22 * t24
  t28 = t11 * t7
  t30 = 0.1e1 / t21 / t8
  t31 = t24 ** 2
  t32 = t30 * t31
  t37 = 0.2e1 * r0 * t14 - 0.2e1 * t19
  t38 = t22 * t37
  t41 = t11 * r0
  t42 = t12 ** 2
  t43 = 0.1e1 / t42
  t47 = t14 * t22
  t55 = t19 * t22
  t59 = r0 ** 2
  t62 = 0.1e1 / t21 / t59 / t19
  t64 = t31 * t24
  t68 = t41 * t7
  t69 = t30 * t24
  t70 = t69 * t37
  t73 = t7 * t22
  t76 = -0.6e1 * r0 * t43 + 0.6e1 * t14
  t80 = 0.12e2 * t15 * t16 - 0.4e1 * t20 * t25 - 0.4e1 / 0.3e1 * t28 * t32 + 0.2e1 * t28 * t38 - 0.12e2 * t41 * t43 * t16 + 0.4e1 * t41 * t47 * t24 + 0.4e1 / 0.3e1 * t41 * t19 * t30 * t31 - 0.2e1 * t41 * t55 * t37 + 0.20e2 / 0.27e2 * t41 * t7 * t62 * t64 - 0.4e1 / 0.3e1 * t68 * t70 + 0.2e1 / 0.3e1 * t41 * t73 * t76
  t81 = f.my_piecewise3(t10, 0, t80)
  t82 = t6 ** (0.1e1 / 0.3e1)
  t96 = t7 * t30
  t104 = f.my_piecewise3(t10, 0, -0.4e1 * t20 * t16 + 0.4e1 / 0.3e1 * t28 * t25 + 0.4e1 * t41 * t14 * t16 - 0.4e1 / 0.3e1 * t41 * t55 * t24 - 0.4e1 / 0.9e1 * t41 * t96 * t31 + 0.2e1 / 0.3e1 * t41 * t73 * t37)
  t105 = t82 ** 2
  t106 = 0.1e1 / t105
  t119 = f.my_piecewise3(t10, 0, 0.2e1 * t28 * t16 - 0.2e1 * t41 * t19 * t16 + 0.2e1 / 0.3e1 * t41 * t73 * t24)
  t121 = 0.1e1 / t105 / t6
  t125 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t126 = t125 * f.p.zeta_threshold
  t130 = f.my_piecewise3(t10, t126, 0.2e1 * t41 * t7 * t16)
  t132 = 0.1e1 / t105 / t12
  t137 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t81 * t82 - 0.3e1 / 0.8e1 * t5 * t104 * t106 + t5 * t119 * t121 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t130 * t132)
  t138 = r1 <= f.p.dens_threshold
  t139 = r1 * t7
  t141 = 0.2e1 * t139 <= f.p.zeta_threshold
  t142 = t11 * r1
  t143 = t139 ** (0.1e1 / 0.3e1)
  t147 = r1 ** 2
  t148 = t11 * t147
  t150 = 0.1e1 / t42 / t6
  t151 = t143 ** 2
  t152 = 0.1e1 / t151
  t156 = t147 * r1
  t157 = t11 * t156
  t159 = 0.1e1 / t42 / t12
  t161 = 0.1e1 / t151 / t139
  t165 = t147 ** 2
  t166 = t11 * t165
  t168 = 0.1e1 / t42 / t13
  t171 = 0.1e1 / t151 / t147 / t19
  t176 = f.my_piecewise3(t141, 0, -0.12e2 * t142 * t43 * t143 - 0.12e2 * t148 * t150 * t152 + 0.4e1 * t157 * t159 * t161 - 0.20e2 / 0.27e2 * t166 * t168 * t171)
  t190 = f.my_piecewise3(t141, 0, 0.4e1 * t142 * t14 * t143 + 0.8e1 / 0.3e1 * t148 * t43 * t152 - 0.4e1 / 0.9e1 * t157 * t150 * t161)
  t201 = f.my_piecewise3(t141, 0, -0.2e1 * t142 * t19 * t143 - 0.2e1 / 0.3e1 * t148 * t14 * t152)
  t208 = f.my_piecewise3(t141, t126, 0.2e1 * t142 * t7 * t143)
  t213 = f.my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t5 * t176 * t82 - 0.3e1 / 0.8e1 * t5 * t190 * t106 + t5 * t201 * t121 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t208 * t132)
  t214 = t137 + t213
  t215 = 9 ** (0.1e1 / 0.3e1)
  t216 = t215 ** 2
  t217 = t3 ** 2
  t219 = 0.1e1 / jnp.pi
  t220 = t219 ** (0.1e1 / 0.3e1)
  t221 = t220 ** 2
  t222 = 0.1e1 / t221
  t227 = 0.1e1 + 0.17750451365686221606162525710885164915525131374403e-4 * t216 * t217 * t2 * t222 * t105
  t228 = jnp.sqrt(t227)
  t230 = t228 * t216 * t4
  t231 = t2 * t220
  t237 = t2 ** 2
  t239 = t237 / t220
  t243 = jnp.asinh(0.24324508467583486201881266313614310329863507558814e-2 * t215 * t3 * t239 * t82)
  t246 = t243 * t215 / t217
  t247 = t237 * t221
  t251 = 0.15226222180972388888888888888888888888888888888889e2 * t230 * t231 / t82 - 0.20865405771390201384250498613611111111111111111111e4 * t246 * t247 * t106
  t252 = t251 ** 2
  t254 = 0.1e1 - 0.15e1 * t252
  t260 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t130 * t82)
  t264 = f.my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t5 * t208 * t82)
  t265 = t260 + t264
  t267 = t227 ** 2
  t269 = 0.1e1 / t228 / t267
  t270 = jnp.pi ** 2
  t271 = t217 * t270
  t272 = t269 * t271
  t274 = 0.1e1 / t82 / t6
  t277 = t216 * t2 * t222
  t281 = 0.1e1 / t228 / t227
  t282 = t281 * t270
  t285 = 0.1e1 / t228
  t287 = t285 * t215 * t3
  t288 = t239 * t132
  t293 = t231 / t82 / t13
  t296 = t269 * t270
  t300 = t281 * t215 * t3
  t304 = t285 * t216 * t4
  t308 = 0.1e1 / t105 / t13
  t312 = 0.22992390652031648896286249923619720649148119883912e-11 * t272 * t274 * t277 + 0.25906260272883801250402865164535020513886174714162e-6 * t282 * t19 + 0.17117246699410601401323854072543403565459505319165e-2 * t287 * t288 - 0.15790156335823218106995884773662551440329218106996e2 * t230 * t293 - 0.12953130136441900625201432582267510256943087357081e-6 * t296 * t19 - 0.99099849312377166007664418314724968010555030795168e-3 * t300 * t288 - 0.29324576052243119341563786008230452674897119341564e2 * t304 * t293 + 0.61823424507822818916297773669958847736625514403293e4 * t246 * t247 * t308
  t346 = t31 ** 2
  t354 = t37 ** 2
  t382 = 0.16e2 / 0.3e1 * t20 * t32 + 0.80e2 / 0.27e2 * t28 * t62 * t64 - 0.16e2 / 0.3e1 * t28 * t70 + 0.48e2 * t41 * t150 * t16 - 0.16e2 * t41 * t43 * t22 * t24 + 0.8e1 * t41 * t47 * t37 - 0.8e1 / 0.3e1 * t41 * t55 * t76 + 0.2e1 / 0.3e1 * t41 * t73 * (0.24e2 * r0 * t150 - 0.24e2 * t43) - 0.160e3 / 0.81e2 * t41 * t7 / t21 / t59 / r0 / t14 * t346 + 0.40e2 / 0.9e1 * t68 * t62 * t31 * t37 - 0.4e1 / 0.3e1 * t41 * t96 * t354 - 0.16e2 / 0.9e1 * t68 * t69 * t76 - 0.16e2 / 0.3e1 * t41 * t14 * t30 * t31 - 0.80e2 / 0.27e2 * t41 * t19 * t62 * t64 + 0.16e2 / 0.3e1 * t41 * t19 * t70 - 0.48e2 * t11 * t43 * t16 + 0.16e2 * t15 * t25 - 0.8e1 * t20 * t38 + 0.8e1 / 0.3e1 * t28 * t22 * t76
  t383 = f.my_piecewise3(t10, 0, t382)
  t400 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t383 * t82 - t5 * t81 * t106 / 0.2e1 + t5 * t104 * t121 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t119 * t132 + 0.10e2 / 0.27e2 * t5 * t130 * t308)
  t410 = t42 ** 2
  t426 = f.my_piecewise3(t141, 0, 0.48e2 * t142 * t150 * t143 + 0.64e2 * t148 * t159 * t152 - 0.32e2 * t157 * t168 * t161 + 0.320e3 / 0.27e2 * t166 / t410 * t171 - 0.160e3 / 0.81e2 * t11 * t165 * r1 / t410 / t6 / t151 / t156 / t14)
  t443 = f.my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t5 * t426 * t82 - t5 * t176 * t106 / 0.2e1 + t5 * t190 * t121 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t201 * t132 + 0.10e2 / 0.27e2 * t5 * t208 * t308)
  t450 = t231 * t274
  t458 = 0.81081694891944954006270887712047701099545025196047e-3 * t287 * t239 * t106 - 0.50754073936574629629629629629629629629629629629630e1 * t230 * t450 - 0.50754073936574629629629629629629629629629629629629e1 * t304 * t450 + 0.13910270514260134256166999075740740740740740740741e4 * t246 * t247 * t121
  t462 = t239 * t121
  t466 = 0.1e1 / t82 / t12
  t467 = t231 * t466
  t477 = -0.12953130136441900625201432582267510256943087357081e-6 * t282 * t7 - 0.81081694891944954006270887712047701099545025196047e-3 * t287 * t462 + 0.67672098582099506172839506172839506172839506172840e1 * t230 * t467 + 0.27027231630648318002090295904015900366515008398682e-3 * t300 * t462 + 0.10150814787314925925925925925925925925925925925926e2 * t304 * t467 - 0.23183784190433557093611665126234567901234567901235e4 * t246 * t247 * t132
  t490 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t104 * t82 - t5 * t119 * t106 / 0.4e1 + t5 * t130 * t121 / 0.12e2)
  t501 = f.my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t5 * t190 * t82 - t5 * t201 * t106 / 0.4e1 + t5 * t208 * t121 / 0.12e2)
  t502 = t490 + t501
  t513 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t119 * t82 - t5 * t130 * t106 / 0.8e1)
  t521 = f.my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t5 * t201 * t82 - t5 * t208 * t106 / 0.8e1)
  t522 = t513 + t521
  t523 = t458 ** 2
  t529 = t6 * t265
  t535 = 0.1e1 / t228 / t267 / t227
  t551 = t239 * t308
  t556 = t231 / t82 / t42
  t578 = t6 * t522
  t582 = t477 ** 2
  t589 = t6 * t502
  d1111 = 0.4e1 * t214 * t254 - 0.120e2 * t265 * t251 * t312 + t6 * (t400 + t443) * t254 - 0.360e2 * t265 * t458 * t477 - 0.360e2 * t502 * t251 * t458 - 0.360e2 * t522 * t523 - 0.360e2 * t522 * t251 * t477 - 0.120e2 * t529 * t458 * t312 - 0.30e1 * t529 * t251 * (-0.61218796807461944612555761243733303730668952993943e-15 * t535 * t3 * t270 * jnp.pi * t121 * t215 * t237 / t220 / t219 - 0.76641302173438829654287499745399068830493732946373e-11 * t272 * t466 * t277 - 0.79158017500478281598453199113857007125763311626605e-6 * t282 * t14 - 0.54054463261296636004180591808031800733030016797363e-2 * t287 * t551 + 0.52633854452744060356652949245541838134430727023320e2 * t230 * t556 + 0.38320651086719414827143749872699534415246866473187e-11 * t535 * t271 * t466 * t277 + 0.73401070773170770209474784632849224789344161690127e-6 * t296 * t14 + 0.42042360314341828003251571406246956125690013064617e-2 * t300 * t551 + 0.11278683097016584362139917695473251028806584362140e3 * t304 * t556 - 0.22668588986201700269309183678984910836762688614541e5 * t246 * t247 / t105 / t42) - 0.120e2 * t578 * t251 * t312 - 0.90e1 * t529 * t582 - 0.120e2 * t6 * t214 * t251 * t458 - 0.180e2 * t589 * t523 - 0.180e2 * t589 * t251 * t477 - 0.360e2 * t578 * t458 * t477

  res = {'v4rho4': d1111}
  return res
