"""Generated from mgga_c_cs.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  cs_a = -0.04918

  cs_b = 0.132

  cs_c = 0.2533 / f.RS_FACTOR

  cs_d = 0.349 / f.RS_FACTOR

  cs_thf = lambda z, u, t: f.opz_pow_n(z, 8 / 3) * 2 ** (-8 / 3) * (t - u / 8)

  f_cs = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: cs_a * (1 - z ** 2) / (1 + cs_d * rs) * (1 + 2 * cs_b * jnp.exp(-cs_c * rs) * (cs_thf(z, u0, t0) + cs_thf(-z, u1, t1) - f.t_vw(z, xt, u0, u1)))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: f_cs(rs, z, xt, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  cs_a = -0.04918

  cs_b = 0.132

  cs_c = 0.2533 / f.RS_FACTOR

  cs_d = 0.349 / f.RS_FACTOR

  cs_thf = lambda z, u, t: f.opz_pow_n(z, 8 / 3) * 2 ** (-8 / 3) * (t - u / 8)

  f_cs = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: cs_a * (1 - z ** 2) / (1 + cs_d * rs) * (1 + 2 * cs_b * jnp.exp(-cs_c * rs) * (cs_thf(z, u0, t0) + cs_thf(-z, u1, t1) - f.t_vw(z, xt, u0, u1)))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: f_cs(rs, z, xt, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  cs_a = -0.04918

  cs_b = 0.132

  cs_c = 0.2533 / f.RS_FACTOR

  cs_d = 0.349 / f.RS_FACTOR

  cs_thf = lambda z, u, t: f.opz_pow_n(z, 8 / 3) * 2 ** (-8 / 3) * (t - u / 8)

  f_cs = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: cs_a * (1 - z ** 2) / (1 + cs_d * rs) * (1 + 2 * cs_b * jnp.exp(-cs_c * rs) * (cs_thf(z, u0, t0) + cs_thf(-z, u1, t1) - f.t_vw(z, xt, u0, u1)))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: f_cs(rs, z, xt, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 - r1
  t2 = t1 ** 2
  t3 = r0 + r1
  t4 = t3 ** 2
  t5 = 0.1e1 / t4
  t8 = -0.4918e-1 + 0.4918e-1 * t2 * t5
  t9 = t3 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t9
  t12 = 0.1e1 + 0.34899999999999999999999999999999999999999999999998e0 * t10
  t13 = 0.1e1 / t12
  t16 = jnp.exp(-0.25330000000000000000000000000000000000000000000000e0 * t10)
  t17 = 0.1e1 / t3
  t18 = t1 * t17
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** 2
  t22 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = t23 * t21
  t25 = t19 ** 2
  t26 = t19 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t29 = f.my_piecewise3(t20, t24, t27 * t25)
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = r0 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t35 = 0.1e1 / t33 / r0
  t37 = l0 * t35
  t39 = tau0 * t35 - t37 / 0.8e1
  t41 = 0.1e1 - t18
  t42 = t41 <= f.p.zeta_threshold
  t43 = t41 ** 2
  t44 = t41 ** (0.1e1 / 0.3e1)
  t45 = t44 ** 2
  t47 = f.my_piecewise3(t42, t24, t45 * t43)
  t48 = t47 * t30
  t49 = r1 ** (0.1e1 / 0.3e1)
  t50 = t49 ** 2
  t52 = 0.1e1 / t50 / r1
  t54 = l1 * t52
  t56 = tau1 * t52 - t54 / 0.8e1
  t59 = s0 + 0.2e1 * s1 + s2
  t60 = t9 ** 2
  t64 = t19 / 0.2e1
  t65 = t64 ** (0.1e1 / 0.3e1)
  t66 = t65 ** 2
  t67 = t66 * t64
  t69 = t41 / 0.2e1
  t70 = t69 ** (0.1e1 / 0.3e1)
  t71 = t70 ** 2
  t72 = t71 * t69
  t75 = t31 * t39 / 0.8e1 + t48 * t56 / 0.8e1 - t59 / t60 / t4 / 0.8e1 + t37 * t67 / 0.8e1 + t54 * t72 / 0.8e1
  t78 = 0.1e1 + 0.264e0 * t16 * t75
  t79 = t8 * t13 * t78
  t80 = t1 * t5
  t81 = 0.9836e-1 * t80
  t82 = t4 * t3
  t85 = 0.9836e-1 * t2 / t82
  t88 = t13 * t78
  t91 = t12 ** 2
  t95 = 0.11633333333333333333333333333333333333333333333333e0 * t10 * t8 / t91 * t78
  t96 = t3 * t8
  t101 = 0.22290400000000000000000000000000000000000000000000e-1 / t9 / t3 * t16 * t75
  t102 = t27 * t19
  t103 = t17 - t80
  t106 = f.my_piecewise3(t20, 0, 0.8e1 / 0.3e1 * t102 * t103)
  t110 = r0 ** 2
  t112 = 0.1e1 / t33 / t110
  t115 = l0 * t112
  t120 = t45 * t41
  t124 = f.my_piecewise3(t42, 0, -0.8e1 / 0.3e1 * t120 * t103)
  t131 = t59 / t60 / t82 / 0.3e1
  t134 = t103 / 0.2e1
  vrho_0_ = t79 + t3 * (t81 - t85) * t88 + t95 + t96 * t13 * (t101 + 0.264e0 * t16 * (t106 * t30 * t39 / 0.8e1 + t31 * (-0.5e1 / 0.3e1 * tau0 * t112 + 0.5e1 / 0.24e2 * t115) / 0.8e1 + t124 * t30 * t56 / 0.8e1 + t131 - 0.5e1 / 0.24e2 * t115 * t67 + 0.5e1 / 0.24e2 * t37 * t66 * t134 - 0.5e1 / 0.24e2 * t54 * t71 * t134))
  t151 = -t17 - t80
  t154 = f.my_piecewise3(t20, 0, 0.8e1 / 0.3e1 * t102 * t151)
  t161 = f.my_piecewise3(t42, 0, -0.8e1 / 0.3e1 * t120 * t151)
  t165 = r1 ** 2
  t167 = 0.1e1 / t50 / t165
  t170 = l1 * t167
  t175 = t151 / 0.2e1
  vrho_1_ = t79 + t3 * (-t81 - t85) * t88 + t95 + t96 * t13 * (t101 + 0.264e0 * t16 * (t154 * t30 * t39 / 0.8e1 + t161 * t30 * t56 / 0.8e1 + t48 * (-0.5e1 / 0.3e1 * tau1 * t167 + 0.5e1 / 0.24e2 * t170) / 0.8e1 + t131 + 0.5e1 / 0.24e2 * t37 * t66 * t175 - 0.5e1 / 0.24e2 * t170 * t72 - 0.5e1 / 0.24e2 * t54 * t71 * t175))
  t194 = t13 * t16
  t195 = 0.1e1 / t60 / t3 * t8 * t194
  vsigma_0_ = -0.33000000000000000000000000000000000000000000000000e-1 * t195
  vsigma_1_ = -0.66000000000000000000000000000000000000000000000000e-1 * t195
  vsigma_2_ = vsigma_0_
  vlapl_0_ = 0.264e0 * t96 * t194 * (-t31 * t35 / 0.64e2 + t35 * t67 / 0.8e1)
  vlapl_1_ = 0.264e0 * t96 * t194 * (-t48 * t52 / 0.64e2 + t52 * t72 / 0.8e1)
  t212 = t96 * t13
  vtau_0_ = 0.33000000000000000000000000000000000000000000000000e-1 * t212 * t16 * t29 * t30 * t35
  vtau_1_ = 0.33000000000000000000000000000000000000000000000000e-1 * t212 * t16 * t47 * t30 * t52
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  cs_a = -0.04918

  cs_b = 0.132

  cs_c = 0.2533 / f.RS_FACTOR

  cs_d = 0.349 / f.RS_FACTOR

  cs_thf = lambda z, u, t: f.opz_pow_n(z, 8 / 3) * 2 ** (-8 / 3) * (t - u / 8)

  f_cs = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: cs_a * (1 - z ** 2) / (1 + cs_d * rs) * (1 + 2 * cs_b * jnp.exp(-cs_c * rs) * (cs_thf(z, u0, t0) + cs_thf(-z, u1, t1) - f.t_vw(z, xt, u0, u1)))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: f_cs(rs, z, xt, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / t1
  t4 = 0.1e1 + 0.34899999999999999999999999999999999999999999999998e0 * t2
  t5 = 0.1e1 / t4
  t7 = jnp.exp(-0.25330000000000000000000000000000000000000000000000e0 * t2)
  t9 = f.p.zeta_threshold ** 2
  t10 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t11 = t10 ** 2
  t13 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t11 * t9, 1)
  t14 = 2 ** (0.1e1 / 0.3e1)
  t15 = t13 * t14
  t16 = t14 ** 2
  t17 = tau0 * t16
  t18 = t1 ** 2
  t20 = 0.1e1 / t18 / r0
  t22 = l0 * t16
  t28 = r0 ** 2
  t30 = 0.1e1 / t18 / t28
  t35 = t15 * (t17 * t20 - t22 * t20 / 0.8e1) / 0.4e1 - s0 * t30 / 0.8e1 + l0 * t20 / 0.8e1
  t38 = 0.1e1 + 0.264e0 * t7 * t35
  t41 = t4 ** 2
  t46 = r0 * t5
  vrho_0_ = -0.4918e-1 * t5 * t38 - 0.57212733333333333333333333333333333333333333333332e-2 * t2 / t41 * t38 - 0.4918e-1 * t46 * (0.22290400000000000000000000000000000000000000000000e-1 / t1 / r0 * t7 * t35 + 0.264e0 * t7 * (t15 * (-0.5e1 / 0.3e1 * t17 * t30 + 0.5e1 / 0.24e2 * t22 * t30) / 0.4e1 + s0 / t18 / t28 / r0 / 0.3e1 - 0.5e1 / 0.24e2 * l0 * t30))
  vsigma_0_ = 0.16229400000000000000000000000000000000000000000000e-2 * t20 * t5 * t7
  vlapl_0_ = -0.1298352e-1 * t46 * t7 * (-t13 * t20 / 0.16e2 + t20 / 0.8e1)
  vtau_0_ = -0.64917600000000000000000000000000000000000000000000e-2 / t18 * t5 * t7 * t13
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / t1
  t4 = 0.1e1 + 0.34899999999999999999999999999999999999999999999998e0 * t2
  t5 = t4 ** 2
  t6 = 0.1e1 / t5
  t8 = jnp.exp(-0.25330000000000000000000000000000000000000000000000e0 * t2)
  t10 = f.p.zeta_threshold ** 2
  t11 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t14 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t12 * t10, 1)
  t15 = 2 ** (0.1e1 / 0.3e1)
  t16 = t14 * t15
  t17 = t15 ** 2
  t18 = tau0 * t17
  t19 = t1 ** 2
  t21 = 0.1e1 / t19 / r0
  t23 = l0 * t17
  t29 = r0 ** 2
  t31 = 0.1e1 / t19 / t29
  t36 = t16 * (t18 * t21 - t23 * t21 / 0.8e1) / 0.4e1 - s0 * t31 / 0.8e1 + l0 * t21 / 0.8e1
  t39 = 0.1e1 + 0.264e0 * t8 * t36
  t42 = 0.1e1 / t1 / r0
  t45 = 0.1e1 / t4
  t46 = t42 * t8
  t58 = 0.1e1 / t19 / t29 / r0
  t63 = t16 * (-0.5e1 / 0.3e1 * t18 * t31 + 0.5e1 / 0.24e2 * t23 * t31) / 0.4e1 + s0 * t58 / 0.3e1 - 0.5e1 / 0.24e2 * l0 * t31
  t66 = 0.22290400000000000000000000000000000000000000000000e-1 * t46 * t36 + 0.264e0 * t8 * t63
  t95 = t29 ** 2
  v2rho2_0_ = -0.38141822222222222222222222222222222222222222222221e-2 * t6 * t39 * t42 - 0.9836e-1 * t45 * t66 - 0.13311495955555555555555555555555555555555555555555e-2 * t21 / t5 / t4 * t39 - 0.11442546666666666666666666666666666666666666666666e-1 * t2 * t6 * t66 - 0.4918e-1 * r0 * t45 * (-0.29720533333333333333333333333333333333333333333333e-1 / t1 / t29 * t8 * t36 + 0.18820527733333333333333333333333333333333333333333e-2 * t31 * t8 * t36 + 0.44580800000000000000000000000000000000000000000000e-1 * t46 * t63 + 0.264e0 * t8 * (t16 * (0.40e2 / 0.9e1 * t18 * t58 - 0.5e1 / 0.9e1 * t23 * t58) / 0.4e1 - 0.11e2 / 0.9e1 * s0 / t19 / t95 + 0.5e1 / 0.9e1 * l0 * t58))
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / t1
  t4 = 0.1e1 + 0.34899999999999999999999999999999999999999999999998e0 * t2
  t5 = t4 ** 2
  t7 = 0.1e1 / t5 / t4
  t9 = jnp.exp(-0.25330000000000000000000000000000000000000000000000e0 * t2)
  t11 = f.p.zeta_threshold ** 2
  t12 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t13 = t12 ** 2
  t15 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t13 * t11, 1)
  t16 = 2 ** (0.1e1 / 0.3e1)
  t17 = t15 * t16
  t18 = t16 ** 2
  t19 = tau0 * t18
  t20 = t1 ** 2
  t22 = 0.1e1 / t20 / r0
  t24 = l0 * t18
  t30 = r0 ** 2
  t32 = 0.1e1 / t20 / t30
  t37 = t17 * (t19 * t22 - t24 * t22 / 0.8e1) / 0.4e1 - s0 * t32 / 0.8e1 + l0 * t22 / 0.8e1
  t40 = 0.1e1 + 0.264e0 * t9 * t37
  t44 = 0.1e1 / t5
  t46 = 0.1e1 / t1 / r0
  t47 = t46 * t9
  t57 = t30 * r0
  t59 = 0.1e1 / t20 / t57
  t64 = t17 * (-0.5e1 / 0.3e1 * t19 * t32 + 0.5e1 / 0.24e2 * t24 * t32) / 0.4e1 + s0 * t59 / 0.3e1 - 0.5e1 / 0.24e2 * l0 * t32
  t67 = 0.22290400000000000000000000000000000000000000000000e-1 * t47 * t37 + 0.264e0 * t9 * t64
  t73 = 0.1e1 / t1 / t30
  t76 = 0.1e1 / t4
  t77 = t73 * t9
  t80 = t32 * t9
  t92 = t30 ** 2
  t94 = 0.1e1 / t20 / t92
  t99 = t17 * (0.40e2 / 0.9e1 * t19 * t59 - 0.5e1 / 0.9e1 * t24 * t59) / 0.4e1 - 0.11e2 / 0.9e1 * s0 * t94 + 0.5e1 / 0.9e1 * l0 * t59
  t102 = -0.29720533333333333333333333333333333333333333333333e-1 * t77 * t37 + 0.18820527733333333333333333333333333333333333333333e-2 * t80 * t37 + 0.44580800000000000000000000000000000000000000000000e-1 * t47 * t64 + 0.264e0 * t9 * t99
  t106 = t5 ** 2
  v3rho3_0_ = 0.13311495955555555555555555555555555555555555555556e-2 * t7 * t40 * t32 - 0.11442546666666666666666666666666666666666666666666e-1 * t44 * t67 * t46 + 0.50855762962962962962962962962962962962962962962961e-2 * t44 * t40 * t73 - 0.14754e0 * t76 * t102 - 0.46457120884888888888888888888888888888888888888886e-3 / t57 / t106 * t40 - 0.39934487866666666666666666666666666666666666666664e-2 * t22 * t7 * t67 - 0.17163819999999999999999999999999999999999999999999e-1 * t2 * t44 * t102 - 0.4918e-1 * r0 * t76 * (0.69347911111111111111111111111111111111111111111110e-1 / t1 / t57 * t9 * t37 - 0.75282110933333333333333333333333333333333333333332e-2 * t59 * t9 * t37 - 0.89161600000000000000000000000000000000000000000000e-1 * t77 * t64 + 0.15890798916177777777777777777777777777777777777777e-3 / t92 * t9 * t37 + 0.56461583200000000000000000000000000000000000000000e-2 * t80 * t64 + 0.66871200000000000000000000000000000000000000000000e-1 * t47 * t99 + 0.264e0 * t9 * (t17 * (-0.440e3 / 0.27e2 * t19 * t94 + 0.55e2 / 0.27e2 * t24 * t94) / 0.4e1 + 0.154e3 / 0.27e2 * s0 / t20 / t92 / r0 - 0.55e2 / 0.27e2 * l0 * t94))

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / t1
  t4 = 0.1e1 + 0.34899999999999999999999999999999999999999999999998e0 * t2
  t5 = t4 ** 2
  t6 = t5 ** 2
  t7 = 0.1e1 / t6
  t9 = jnp.exp(-0.25330000000000000000000000000000000000000000000000e0 * t2)
  t11 = f.p.zeta_threshold ** 2
  t12 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t13 = t12 ** 2
  t15 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t13 * t11, 1)
  t16 = 2 ** (0.1e1 / 0.3e1)
  t17 = t15 * t16
  t18 = t16 ** 2
  t19 = tau0 * t18
  t20 = t1 ** 2
  t22 = 0.1e1 / t20 / r0
  t24 = l0 * t18
  t30 = r0 ** 2
  t32 = 0.1e1 / t20 / t30
  t37 = t17 * (t19 * t22 - t24 * t22 / 0.8e1) / 0.4e1 - s0 * t32 / 0.8e1 + l0 * t22 / 0.8e1
  t40 = 0.1e1 + 0.264e0 * t9 * t37
  t42 = t30 ** 2
  t43 = 0.1e1 / t42
  t47 = 0.1e1 / t5 / t4
  t49 = 0.1e1 / t1 / r0
  t50 = t49 * t9
  t60 = t30 * r0
  t62 = 0.1e1 / t20 / t60
  t67 = t17 * (-0.5e1 / 0.3e1 * t19 * t32 + 0.5e1 / 0.24e2 * t24 * t32) / 0.4e1 + s0 * t62 / 0.3e1 - 0.5e1 / 0.24e2 * l0 * t32
  t70 = 0.22290400000000000000000000000000000000000000000000e-1 * t50 * t37 + 0.264e0 * t9 * t67
  t77 = 0.1e1 / t5
  t79 = 0.1e1 / t1 / t30
  t80 = t79 * t9
  t83 = t32 * t9
  t96 = 0.1e1 / t20 / t42
  t101 = t17 * (0.40e2 / 0.9e1 * t19 * t62 - 0.5e1 / 0.9e1 * t24 * t62) / 0.4e1 - 0.11e2 / 0.9e1 * s0 * t96 + 0.5e1 / 0.9e1 * l0 * t62
  t104 = -0.29720533333333333333333333333333333333333333333333e-1 * t80 * t37 + 0.18820527733333333333333333333333333333333333333333e-2 * t83 * t37 + 0.44580800000000000000000000000000000000000000000000e-1 * t50 * t67 + 0.264e0 * t9 * t101
  t113 = 0.1e1 / t1 / t60
  t116 = 0.1e1 / t4
  t117 = t113 * t9
  t120 = t62 * t9
  t125 = t43 * t9
  t139 = t42 * r0
  t141 = 0.1e1 / t20 / t139
  t146 = t17 * (-0.440e3 / 0.27e2 * t19 * t96 + 0.55e2 / 0.27e2 * t24 * t96) / 0.4e1 + 0.154e3 / 0.27e2 * s0 * t141 - 0.55e2 / 0.27e2 * l0 * t96
  t149 = 0.69347911111111111111111111111111111111111111111110e-1 * t117 * t37 - 0.75282110933333333333333333333333333333333333333332e-2 * t120 * t37 - 0.89161600000000000000000000000000000000000000000000e-1 * t80 * t67 + 0.15890798916177777777777777777777777777777777777777e-3 * t125 * t37 + 0.56461583200000000000000000000000000000000000000000e-2 * t83 * t67 + 0.66871200000000000000000000000000000000000000000000e-1 * t50 * t101 + 0.264e0 * t9 * t146
  t153 = 0.1e1 / t1 / t42
  t214 = -0.23115970370370370370370370370370370370370370370370e0 * t153 * t9 * t37 + 0.33458715970370370370370370370370370370370370370370e-1 * t96 * t9 * t37 + 0.27739164444444444444444444444444444444444444444444e0 * t117 * t67 - 0.12712639132942222222222222222222222222222222222222e-2 / t139 * t9 * t37 - 0.30112844373333333333333333333333333333333333333333e-1 * t120 * t67 - 0.17832320000000000000000000000000000000000000000000e0 * t80 * t101 + 0.13417131218226103703703703703703703703703703703703e-4 / t1 / t139 * t9 * t37 + 0.63563195664711111111111111111111111111111111111110e-3 * t125 * t67 + 0.11292316640000000000000000000000000000000000000000e-1 * t83 * t101 + 0.89161600000000000000000000000000000000000000000000e-1 * t50 * t146 + 0.264e0 * t9 * (t17 * (0.6160e4 / 0.81e2 * t19 * t141 - 0.770e3 / 0.81e2 * t24 * t141) / 0.4e1 - 0.2618e4 / 0.81e2 * s0 / t20 / t42 / t30 + 0.770e3 / 0.81e2 * l0 * t141)
  v4rho4_0_ = 0.18582848353955555555555555555555555555555555555555e-2 * t7 * t40 * t43 + 0.53245983822222222222222222222222222222222222222220e-2 * t47 * t70 * t32 - 0.23664881698765432098765432098765432098765432098767e-2 * t47 * t40 * t62 - 0.22885093333333333333333333333333333333333333333333e-1 * t77 * t104 * t49 + 0.20342305185185185185185185185185185185185185185184e-1 * t77 * t70 * t79 - 0.11866344691358024691358024691358024691358024691358e-1 * t77 * t40 * t113 - 0.19672e0 * t116 * t149 - 0.21618046918434962962962962962962962962962962962961e-3 * t153 / t6 / t4 * t40 - 0.18582848353955555555555555555555555555555555555554e-2 / t60 * t7 * t70 - 0.79868975733333333333333333333333333333333333333327e-2 * t22 * t47 * t104 - 0.22885093333333333333333333333333333333333333333332e-1 * t2 * t77 * t149 - 0.4918e-1 * r0 * t116 * t214

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 - r1
  t2 = r0 + r1
  t3 = t2 ** 2
  t4 = 0.1e1 / t3
  t5 = t1 * t4
  t6 = t1 ** 2
  t7 = t3 * t2
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t11 = -0.2e1 * t5 + 0.2e1 * t9
  t12 = t2 ** (0.1e1 / 0.3e1)
  t13 = 0.1e1 / t12
  t15 = 0.1e1 + 0.34899999999999999999999999999999999999999999999998e0 * t13
  t16 = 0.1e1 / t15
  t19 = jnp.exp(-0.25330000000000000000000000000000000000000000000000e0 * t13)
  t20 = 0.1e1 / t2
  t21 = t1 * t20
  t22 = 0.1e1 + t21
  t23 = t22 <= f.p.zeta_threshold
  t24 = f.p.zeta_threshold ** 2
  t25 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = t26 * t24
  t28 = t22 ** 2
  t29 = t22 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t32 = f.my_piecewise3(t23, t27, t30 * t28)
  t33 = 2 ** (0.1e1 / 0.3e1)
  t34 = t32 * t33
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / r0
  t40 = l0 * t38
  t42 = tau0 * t38 - t40 / 0.8e1
  t44 = 0.1e1 - t21
  t45 = t44 <= f.p.zeta_threshold
  t46 = t44 ** 2
  t47 = t44 ** (0.1e1 / 0.3e1)
  t48 = t47 ** 2
  t50 = f.my_piecewise3(t45, t27, t48 * t46)
  t51 = t50 * t33
  t52 = r1 ** (0.1e1 / 0.3e1)
  t53 = t52 ** 2
  t55 = 0.1e1 / t53 / r1
  t57 = l1 * t55
  t59 = tau1 * t55 - t57 / 0.8e1
  t62 = s0 + 0.2e1 * s1 + s2
  t63 = t12 ** 2
  t65 = 0.1e1 / t63 / t3
  t67 = t22 / 0.2e1
  t68 = t67 ** (0.1e1 / 0.3e1)
  t69 = t68 ** 2
  t70 = t69 * t67
  t72 = t44 / 0.2e1
  t73 = t72 ** (0.1e1 / 0.3e1)
  t74 = t73 ** 2
  t75 = t74 * t72
  t78 = t34 * t42 / 0.8e1 + t40 * t70 / 0.8e1 + t51 * t59 / 0.8e1 + t57 * t75 / 0.8e1 - t62 * t65 / 0.8e1
  t81 = 0.1e1 + 0.264e0 * t19 * t78
  t82 = t11 * t16 * t81
  t85 = -t6 * t4 + 0.1e1
  t86 = t15 ** 2
  t87 = 0.1e1 / t86
  t90 = 0.1e1 / t12 / t2
  t93 = 0.38141822222222222222222222222222222222222222222221e-2 * t85 * t87 * t81 * t90
  t94 = t85 * t16
  t95 = t90 * t19
  t97 = 0.22290400000000000000000000000000000000000000000000e-1 * t95 * t78
  t98 = t30 * t22
  t99 = t20 - t5
  t102 = f.my_piecewise3(t23, 0, 0.8e1 / 0.3e1 * t98 * t99)
  t103 = t102 * t33
  t106 = r0 ** 2
  t108 = 0.1e1 / t36 / t106
  t111 = l0 * t108
  t113 = -0.5e1 / 0.3e1 * tau0 * t108 + 0.5e1 / 0.24e2 * t111
  t116 = t48 * t44
  t117 = -t99
  t120 = f.my_piecewise3(t45, 0, 0.8e1 / 0.3e1 * t116 * t117)
  t121 = t120 * t33
  t127 = t62 / t63 / t7 / 0.3e1
  t130 = t99 / 0.2e1
  t131 = t69 * t130
  t134 = -t130
  t135 = t74 * t134
  t138 = t103 * t42 / 0.8e1 + t34 * t113 / 0.8e1 + t121 * t59 / 0.8e1 + t127 - 0.5e1 / 0.24e2 * t111 * t70 + 0.5e1 / 0.24e2 * t40 * t131 + 0.5e1 / 0.24e2 * t57 * t135
  t141 = t97 + 0.264e0 * t19 * t138
  t142 = t94 * t141
  t144 = 0.2e1 * t4
  t145 = t1 * t8
  t146 = 0.8e1 * t145
  t147 = t3 ** 2
  t150 = 0.6e1 * t6 / t147
  t153 = t16 * t81
  t157 = t87 * t81
  t158 = t13 * t11 * t157
  t160 = t2 * t11
  t161 = t16 * t141
  t171 = 0.13311495955555555555555555555555555555555555555555e-2 / t63 / t2 * t85 / t86 / t15 * t81
  t172 = t13 * t85
  t174 = t172 * t87 * t141
  t176 = t2 * t85
  t181 = 0.29720533333333333333333333333333333333333333333333e-1 / t12 / t3 * t19 * t78
  t184 = 0.18820527733333333333333333333333333333333333333333e-2 * t65 * t19 * t78
  t185 = t95 * t138
  t187 = t99 ** 2
  t190 = -t4 + t145
  t191 = 0.2e1 * t190
  t195 = f.my_piecewise3(t23, 0, 0.40e2 / 0.9e1 * t30 * t187 + 0.8e1 / 0.3e1 * t98 * t191)
  t203 = 0.1e1 / t36 / t106 / r0
  t206 = l0 * t203
  t211 = t117 ** 2
  t218 = f.my_piecewise3(t45, 0, 0.40e2 / 0.9e1 * t48 * t211 - 0.8e1 / 0.3e1 * t116 * t191)
  t225 = 0.11e2 / 0.9e1 * t62 / t63 / t147
  t230 = 0.1e1 / t68
  t231 = t130 ** 2
  t238 = 0.1e1 / t73
  t239 = t134 ** 2
  t247 = t195 * t33 * t42 / 0.8e1 + t103 * t113 / 0.4e1 + t34 * (0.40e2 / 0.9e1 * tau0 * t203 - 0.5e1 / 0.9e1 * t206) / 0.8e1 + t218 * t33 * t59 / 0.8e1 - t225 + 0.5e1 / 0.9e1 * t206 * t70 - 0.25e2 / 0.36e2 * t111 * t131 + 0.5e1 / 0.36e2 * t40 * t230 * t231 + 0.5e1 / 0.24e2 * t40 * t69 * t190 + 0.5e1 / 0.36e2 * t57 * t238 * t239 - 0.5e1 / 0.24e2 * t57 * t74 * t190
  d11 = -0.9836e-1 * t82 - t93 - 0.9836e-1 * t142 - 0.4918e-1 * t2 * (-t144 + t146 - t150) * t153 - 0.11442546666666666666666666666666666666666666666666e-1 * t158 - 0.9836e-1 * t160 * t161 - t171 - 0.11442546666666666666666666666666666666666666666666e-1 * t174 - 0.4918e-1 * t176 * t16 * (-t181 + t184 + 0.44580800000000000000000000000000000000000000000000e-1 * t185 + 0.264e0 * t19 * t247)
  t257 = 0.2e1 * t5 + 0.2e1 * t9
  t259 = t257 * t16 * t81
  t266 = t13 * t257 * t157
  t268 = t2 * t257
  t273 = -t20 - t5
  t276 = f.my_piecewise3(t23, 0, 0.8e1 / 0.3e1 * t98 * t273)
  t277 = t276 * t33
  t280 = -t273
  t283 = f.my_piecewise3(t45, 0, 0.8e1 / 0.3e1 * t116 * t280)
  t284 = t283 * t33
  t287 = r1 ** 2
  t289 = 0.1e1 / t53 / t287
  t292 = l1 * t289
  t294 = -0.5e1 / 0.3e1 * tau1 * t289 + 0.5e1 / 0.24e2 * t292
  t297 = t273 / 0.2e1
  t298 = t69 * t297
  t303 = -t297
  t304 = t74 * t303
  t307 = t277 * t42 / 0.8e1 + t284 * t59 / 0.8e1 + t51 * t294 / 0.8e1 + t127 + 0.5e1 / 0.24e2 * t40 * t298 - 0.5e1 / 0.24e2 * t292 * t75 + 0.5e1 / 0.24e2 * t57 * t304
  t310 = t97 + 0.264e0 * t19 * t307
  t311 = t94 * t310
  t313 = t16 * t310
  t317 = t172 * t87 * t310
  t320 = t95 * t307
  t329 = f.my_piecewise3(t23, 0, 0.40e2 / 0.9e1 * t30 * t273 * t99 + 0.16e2 / 0.3e1 * t98 * t1 * t8)
  t342 = f.my_piecewise3(t45, 0, 0.40e2 / 0.9e1 * t48 * t280 * t117 - 0.16e2 / 0.3e1 * t116 * t1 * t8)
  t368 = t329 * t33 * t42 / 0.8e1 + t277 * t113 / 0.8e1 + t342 * t33 * t59 / 0.8e1 + t121 * t294 / 0.8e1 - t225 - 0.25e2 / 0.72e2 * t111 * t298 + 0.5e1 / 0.36e2 * t40 * t230 * t297 * t130 + 0.5e1 / 0.24e2 * t40 * t69 * t1 * t8 - 0.25e2 / 0.72e2 * t292 * t135 + 0.5e1 / 0.36e2 * t57 * t238 * t303 * t134 - 0.5e1 / 0.24e2 * t57 * t74 * t1 * t8
  d12 = -0.4918e-1 * t82 - t93 - 0.4918e-1 * t142 - 0.4918e-1 * t259 - 0.4918e-1 * t2 * (t144 - t150) * t153 - 0.57212733333333333333333333333333333333333333333332e-2 * t266 - 0.4918e-1 * t268 * t161 - 0.57212733333333333333333333333333333333333333333332e-2 * t158 - t171 - 0.57212733333333333333333333333333333333333333333332e-2 * t174 - 0.4918e-1 * t311 - 0.4918e-1 * t160 * t313 - 0.57212733333333333333333333333333333333333333333332e-2 * t317 - 0.4918e-1 * t176 * t16 * (-t181 + t184 + 0.22290400000000000000000000000000000000000000000000e-1 * t185 + 0.22290400000000000000000000000000000000000000000000e-1 * t320 + 0.264e0 * t19 * t368)
  t386 = t273 ** 2
  t389 = t4 + t145
  t390 = 0.2e1 * t389
  t394 = f.my_piecewise3(t23, 0, 0.40e2 / 0.9e1 * t30 * t386 + 0.8e1 / 0.3e1 * t98 * t390)
  t398 = t280 ** 2
  t405 = f.my_piecewise3(t45, 0, 0.40e2 / 0.9e1 * t48 * t398 - 0.8e1 / 0.3e1 * t116 * t390)
  t413 = 0.1e1 / t53 / t287 / r1
  t416 = l1 * t413
  t421 = t297 ** 2
  t432 = t303 ** 2
  t440 = t394 * t33 * t42 / 0.8e1 + t405 * t33 * t59 / 0.8e1 + t284 * t294 / 0.4e1 + t51 * (0.40e2 / 0.9e1 * tau1 * t413 - 0.5e1 / 0.9e1 * t416) / 0.8e1 - t225 + 0.5e1 / 0.36e2 * t40 * t230 * t421 + 0.5e1 / 0.24e2 * t40 * t69 * t389 + 0.5e1 / 0.9e1 * t416 * t75 - 0.25e2 / 0.36e2 * t292 * t304 + 0.5e1 / 0.36e2 * t57 * t238 * t432 - 0.5e1 / 0.24e2 * t57 * t74 * t389
  d22 = -0.9836e-1 * t259 - t93 - 0.9836e-1 * t311 - 0.4918e-1 * t2 * (-t144 - t146 - t150) * t153 - 0.11442546666666666666666666666666666666666666666666e-1 * t266 - 0.9836e-1 * t268 * t313 - t171 - 0.11442546666666666666666666666666666666666666666666e-1 * t317 - 0.4918e-1 * t176 * t16 * (-t181 + t184 + 0.44580800000000000000000000000000000000000000000000e-1 * t320 + 0.264e0 * t19 * t440)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 - r1
  t2 = t1 ** 2
  t3 = r0 + r1
  t4 = t3 ** 2
  t5 = 0.1e1 / t4
  t7 = -t2 * t5 + 0.1e1
  t8 = t3 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t8
  t11 = 0.1e1 + 0.34899999999999999999999999999999999999999999999998e0 * t9
  t12 = t11 ** 2
  t13 = 0.1e1 / t12
  t14 = t7 * t13
  t16 = jnp.exp(-0.25330000000000000000000000000000000000000000000000e0 * t9)
  t17 = 0.1e1 / t3
  t18 = t1 * t17
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** 2
  t22 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = t23 * t21
  t25 = t19 ** 2
  t26 = t19 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t29 = f.my_piecewise3(t20, t24, t27 * t25)
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = r0 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t35 = 0.1e1 / t33 / r0
  t37 = l0 * t35
  t39 = tau0 * t35 - t37 / 0.8e1
  t41 = 0.1e1 - t18
  t42 = t41 <= f.p.zeta_threshold
  t43 = t41 ** 2
  t44 = t41 ** (0.1e1 / 0.3e1)
  t45 = t44 ** 2
  t47 = f.my_piecewise3(t42, t24, t45 * t43)
  t49 = r1 ** (0.1e1 / 0.3e1)
  t50 = t49 ** 2
  t52 = 0.1e1 / t50 / r1
  t54 = l1 * t52
  t56 = tau1 * t52 - t54 / 0.8e1
  t59 = s0 + 0.2e1 * s1 + s2
  t60 = t8 ** 2
  t62 = 0.1e1 / t60 / t4
  t64 = t19 / 0.2e1
  t65 = t64 ** (0.1e1 / 0.3e1)
  t66 = t65 ** 2
  t67 = t66 * t64
  t69 = t41 / 0.2e1
  t70 = t69 ** (0.1e1 / 0.3e1)
  t71 = t70 ** 2
  t75 = t47 * t30 * t56 / 0.8e1 + t54 * t71 * t69 / 0.8e1 + t31 * t39 / 0.8e1 + t37 * t67 / 0.8e1 - t59 * t62 / 0.8e1
  t78 = 0.1e1 + 0.264e0 * t16 * t75
  t80 = 0.1e1 / t8 / t4
  t84 = t1 * t5
  t85 = t4 * t3
  t86 = 0.1e1 / t85
  t89 = 0.2e1 * t2 * t86 - 0.2e1 * t84
  t92 = 0.1e1 / t8 / t3
  t96 = t92 * t16
  t99 = t27 * t19
  t100 = t17 - t84
  t103 = f.my_piecewise3(t20, 0, 0.8e1 / 0.3e1 * t99 * t100)
  t104 = t103 * t30
  t107 = r0 ** 2
  t109 = 0.1e1 / t33 / t107
  t112 = l0 * t109
  t114 = -0.5e1 / 0.3e1 * tau0 * t109 + 0.5e1 / 0.24e2 * t112
  t117 = t45 * t41
  t118 = -t100
  t121 = f.my_piecewise3(t42, 0, 0.8e1 / 0.3e1 * t117 * t118)
  t126 = 0.1e1 / t60 / t85
  t131 = t100 / 0.2e1
  t132 = t66 * t131
  t135 = -t131
  t139 = t104 * t39 / 0.8e1 + t31 * t114 / 0.8e1 + t121 * t30 * t56 / 0.8e1 + t59 * t126 / 0.3e1 - 0.5e1 / 0.24e2 * t112 * t67 + 0.5e1 / 0.24e2 * t37 * t132 + 0.5e1 / 0.24e2 * t54 * t71 * t135
  t142 = 0.22290400000000000000000000000000000000000000000000e-1 * t96 * t75 + 0.264e0 * t16 * t139
  t147 = 0.1e1 / t12 / t11
  t153 = t4 ** 2
  t154 = 0.1e1 / t153
  t155 = t1 * t154
  t157 = t153 * t3
  t163 = 0.1e1 / t11
  t168 = t1 * t86
  t172 = -0.6e1 * t2 * t154 + 0.8e1 * t168 - 0.2e1 * t5
  t186 = 0.1e1 / t60 / t3
  t192 = t80 * t16
  t195 = t62 * t16
  t200 = t100 ** 2
  t203 = -t5 + t168
  t204 = 0.2e1 * t203
  t208 = f.my_piecewise3(t20, 0, 0.40e2 / 0.9e1 * t27 * t200 + 0.8e1 / 0.3e1 * t99 * t204)
  t209 = t208 * t30
  t216 = 0.1e1 / t33 / t107 / r0
  t219 = l0 * t216
  t221 = 0.40e2 / 0.9e1 * tau0 * t216 - 0.5e1 / 0.9e1 * t219
  t224 = t118 ** 2
  t227 = -t204
  t231 = f.my_piecewise3(t42, 0, 0.40e2 / 0.9e1 * t45 * t224 + 0.8e1 / 0.3e1 * t117 * t227)
  t243 = 0.1e1 / t65
  t244 = t131 ** 2
  t245 = t243 * t244
  t248 = t66 * t203
  t251 = 0.1e1 / t70
  t252 = t135 ** 2
  t256 = -t203
  t260 = t209 * t39 / 0.8e1 + t104 * t114 / 0.4e1 + t31 * t221 / 0.8e1 + t231 * t30 * t56 / 0.8e1 - 0.11e2 / 0.9e1 * t59 / t60 / t153 + 0.5e1 / 0.9e1 * t219 * t67 - 0.25e2 / 0.36e2 * t112 * t132 + 0.5e1 / 0.36e2 * t37 * t245 + 0.5e1 / 0.24e2 * t37 * t248 + 0.5e1 / 0.36e2 * t54 * t251 * t252 + 0.5e1 / 0.24e2 * t54 * t71 * t256
  t263 = -0.29720533333333333333333333333333333333333333333333e-1 * t192 * t75 + 0.18820527733333333333333333333333333333333333333333e-2 * t195 * t75 + 0.44580800000000000000000000000000000000000000000000e-1 * t96 * t139 + 0.264e0 * t16 * t260
  t272 = t12 ** 2
  t306 = t86 - t155
  t307 = 0.6e1 * t306
  t311 = f.my_piecewise3(t20, 0, 0.80e2 / 0.27e2 / t26 * t200 * t100 + 0.40e2 / 0.3e1 * t27 * t100 * t204 + 0.8e1 / 0.3e1 * t99 * t307)
  t319 = t107 ** 2
  t321 = 0.1e1 / t33 / t319
  t324 = l0 * t321
  t340 = f.my_piecewise3(t42, 0, 0.80e2 / 0.27e2 / t44 * t224 * t118 + 0.40e2 / 0.3e1 * t45 * t118 * t227 - 0.8e1 / 0.3e1 * t117 * t307)
  t366 = 0.3e1 * t306
  t384 = t311 * t30 * t39 / 0.8e1 + 0.3e1 / 0.8e1 * t209 * t114 + 0.3e1 / 0.8e1 * t104 * t221 + t31 * (-0.440e3 / 0.27e2 * tau0 * t321 + 0.55e2 / 0.27e2 * t324) / 0.8e1 + t340 * t30 * t56 / 0.8e1 + 0.154e3 / 0.27e2 * t59 / t60 / t157 - 0.55e2 / 0.27e2 * t324 * t67 + 0.25e2 / 0.9e1 * t219 * t132 - 0.25e2 / 0.36e2 * t112 * t245 - 0.25e2 / 0.24e2 * t112 * t248 - 0.5e1 / 0.108e3 * t37 / t65 / t64 * t244 * t131 + 0.5e1 / 0.12e2 * t37 * t243 * t131 * t203 + 0.5e1 / 0.24e2 * t37 * t66 * t366 - 0.5e1 / 0.108e3 * t54 / t70 / t69 * t252 * t135 + 0.5e1 / 0.12e2 * t54 * t251 * t135 * t256 - 0.5e1 / 0.24e2 * t54 * t71 * t366
  d111 = 0.50855762962962962962962962962962962962962962962961e-2 * t14 * t78 * t80 - 0.11442546666666666666666666666666666666666666666666e-1 * t89 * t13 * t78 * t92 - 0.11442546666666666666666666666666666666666666666666e-1 * t14 * t142 * t92 + 0.13311495955555555555555555555555555555555555555556e-2 * t7 * t147 * t78 * t62 - 0.4918e-1 * t3 * (0.12e2 * t86 - 0.36e2 * t155 + 0.24e2 * t2 / t157) * t163 * t78 - 0.14754e0 * t3 * t172 * t163 * t142 - 0.17163819999999999999999999999999999999999999999999e-1 * t9 * t172 * t13 * t78 - 0.34327639999999999999999999999999999999999999999998e-1 * t9 * t89 * t13 * t142 - 0.39934487866666666666666666666666666666666666666664e-2 * t186 * t89 * t147 * t78 - 0.14754e0 * t3 * t89 * t163 * t263 - 0.39934487866666666666666666666666666666666666666664e-2 * t186 * t7 * t147 * t142 - 0.46457120884888888888888888888888888888888888888886e-3 * t86 * t7 / t272 * t78 - 0.17163819999999999999999999999999999999999999999999e-1 * t9 * t7 * t13 * t263 - 0.4918e-1 * t3 * t7 * t163 * (0.69347911111111111111111111111111111111111111111110e-1 / t8 / t85 * t16 * t75 - 0.75282110933333333333333333333333333333333333333332e-2 * t126 * t16 * t75 - 0.89161600000000000000000000000000000000000000000000e-1 * t192 * t139 + 0.15890798916177777777777777777777777777777777777777e-3 * t154 * t16 * t75 + 0.56461583200000000000000000000000000000000000000000e-2 * t195 * t139 + 0.66871200000000000000000000000000000000000000000000e-1 * t96 * t260 + 0.264e0 * t16 * t384) - 0.14754e0 * t172 * t163 * t78 - 0.29508e0 * t89 * t163 * t142 - 0.14754e0 * t7 * t163 * t263

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 - r1
  t2 = t1 ** 2
  t3 = r0 + r1
  t4 = t3 ** 2
  t5 = 0.1e1 / t4
  t7 = -t2 * t5 + 0.1e1
  t8 = t3 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t8
  t11 = 0.1e1 + 0.34899999999999999999999999999999999999999999999998e0 * t9
  t12 = 0.1e1 / t11
  t14 = t4 * t3
  t16 = 0.1e1 / t8 / t14
  t18 = jnp.exp(-0.25330000000000000000000000000000000000000000000000e0 * t9)
  t19 = t16 * t18
  t20 = 0.1e1 / t3
  t21 = t1 * t20
  t22 = 0.1e1 + t21
  t23 = t22 <= f.p.zeta_threshold
  t24 = f.p.zeta_threshold ** 2
  t25 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = t26 * t24
  t28 = t22 ** 2
  t29 = t22 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t32 = f.my_piecewise3(t23, t27, t30 * t28)
  t33 = 2 ** (0.1e1 / 0.3e1)
  t34 = t32 * t33
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / r0
  t40 = l0 * t38
  t42 = tau0 * t38 - t40 / 0.8e1
  t44 = 0.1e1 - t21
  t45 = t44 <= f.p.zeta_threshold
  t46 = t44 ** 2
  t47 = t44 ** (0.1e1 / 0.3e1)
  t48 = t47 ** 2
  t50 = f.my_piecewise3(t45, t27, t48 * t46)
  t52 = r1 ** (0.1e1 / 0.3e1)
  t53 = t52 ** 2
  t55 = 0.1e1 / t53 / r1
  t57 = l1 * t55
  t59 = tau1 * t55 - t57 / 0.8e1
  t62 = s0 + 0.2e1 * s1 + s2
  t63 = t8 ** 2
  t65 = 0.1e1 / t63 / t4
  t67 = t22 / 0.2e1
  t68 = t67 ** (0.1e1 / 0.3e1)
  t69 = t68 ** 2
  t70 = t69 * t67
  t72 = t44 / 0.2e1
  t73 = t72 ** (0.1e1 / 0.3e1)
  t74 = t73 ** 2
  t78 = t50 * t33 * t59 / 0.8e1 + t57 * t74 * t72 / 0.8e1 + t34 * t42 / 0.8e1 + t40 * t70 / 0.8e1 - t62 * t65 / 0.8e1
  t82 = 0.1e1 / t63 / t14
  t83 = t82 * t18
  t87 = 0.1e1 / t8 / t4
  t88 = t87 * t18
  t89 = t30 * t22
  t90 = t1 * t5
  t91 = t20 - t90
  t94 = f.my_piecewise3(t23, 0, 0.8e1 / 0.3e1 * t89 * t91)
  t95 = t94 * t33
  t98 = r0 ** 2
  t100 = 0.1e1 / t36 / t98
  t103 = l0 * t100
  t105 = -0.5e1 / 0.3e1 * tau0 * t100 + 0.5e1 / 0.24e2 * t103
  t108 = t48 * t44
  t109 = -t91
  t112 = f.my_piecewise3(t45, 0, 0.8e1 / 0.3e1 * t108 * t109)
  t120 = t91 / 0.2e1
  t121 = t69 * t120
  t124 = -t120
  t128 = t95 * t42 / 0.8e1 + t34 * t105 / 0.8e1 + t112 * t33 * t59 / 0.8e1 + t62 * t82 / 0.3e1 - 0.5e1 / 0.24e2 * t103 * t70 + 0.5e1 / 0.24e2 * t40 * t121 + 0.5e1 / 0.24e2 * t57 * t74 * t124
  t131 = t4 ** 2
  t132 = 0.1e1 / t131
  t133 = t132 * t18
  t136 = t65 * t18
  t140 = 0.1e1 / t8 / t3
  t141 = t140 * t18
  t142 = t91 ** 2
  t145 = 0.1e1 / t14
  t146 = t1 * t145
  t147 = -t5 + t146
  t148 = 0.2e1 * t147
  t152 = f.my_piecewise3(t23, 0, 0.40e2 / 0.9e1 * t30 * t142 + 0.8e1 / 0.3e1 * t89 * t148)
  t153 = t152 * t33
  t160 = 0.1e1 / t36 / t98 / r0
  t163 = l0 * t160
  t165 = 0.40e2 / 0.9e1 * tau0 * t160 - 0.5e1 / 0.9e1 * t163
  t168 = t109 ** 2
  t171 = -t148
  t175 = f.my_piecewise3(t45, 0, 0.40e2 / 0.9e1 * t48 * t168 + 0.8e1 / 0.3e1 * t108 * t171)
  t180 = 0.1e1 / t63 / t131
  t187 = 0.1e1 / t68
  t188 = t120 ** 2
  t189 = t187 * t188
  t192 = t69 * t147
  t195 = 0.1e1 / t73
  t196 = t124 ** 2
  t200 = -t147
  t204 = t153 * t42 / 0.8e1 + t95 * t105 / 0.4e1 + t34 * t165 / 0.8e1 + t175 * t33 * t59 / 0.8e1 - 0.11e2 / 0.9e1 * t62 * t180 + 0.5e1 / 0.9e1 * t163 * t70 - 0.25e2 / 0.36e2 * t103 * t121 + 0.5e1 / 0.36e2 * t40 * t189 + 0.5e1 / 0.24e2 * t40 * t192 + 0.5e1 / 0.36e2 * t57 * t195 * t196 + 0.5e1 / 0.24e2 * t57 * t74 * t200
  t207 = 0.1e1 / t29
  t211 = t30 * t91
  t214 = t1 * t132
  t215 = t145 - t214
  t216 = 0.6e1 * t215
  t220 = f.my_piecewise3(t23, 0, 0.80e2 / 0.27e2 * t207 * t142 * t91 + 0.40e2 / 0.3e1 * t211 * t148 + 0.8e1 / 0.3e1 * t89 * t216)
  t221 = t220 * t33
  t228 = t98 ** 2
  t230 = 0.1e1 / t36 / t228
  t233 = l0 * t230
  t235 = -0.440e3 / 0.27e2 * tau0 * t230 + 0.55e2 / 0.27e2 * t233
  t238 = 0.1e1 / t47
  t242 = t48 * t109
  t245 = -t216
  t249 = f.my_piecewise3(t45, 0, 0.80e2 / 0.27e2 * t238 * t168 * t109 + 0.40e2 / 0.3e1 * t242 * t171 + 0.8e1 / 0.3e1 * t108 * t245)
  t253 = t131 * t3
  t267 = 0.1e1 / t68 / t67
  t269 = t267 * t188 * t120
  t272 = t187 * t120
  t273 = t272 * t147
  t276 = 0.3e1 * t215
  t277 = t69 * t276
  t281 = 0.1e1 / t73 / t72
  t286 = t195 * t124
  t290 = -t276
  t294 = t221 * t42 / 0.8e1 + 0.3e1 / 0.8e1 * t153 * t105 + 0.3e1 / 0.8e1 * t95 * t165 + t34 * t235 / 0.8e1 + t249 * t33 * t59 / 0.8e1 + 0.154e3 / 0.27e2 * t62 / t63 / t253 - 0.55e2 / 0.27e2 * t233 * t70 + 0.25e2 / 0.9e1 * t163 * t121 - 0.25e2 / 0.36e2 * t103 * t189 - 0.25e2 / 0.24e2 * t103 * t192 - 0.5e1 / 0.108e3 * t40 * t269 + 0.5e1 / 0.12e2 * t40 * t273 + 0.5e1 / 0.24e2 * t40 * t277 - 0.5e1 / 0.108e3 * t57 * t281 * t196 * t124 + 0.5e1 / 0.12e2 * t57 * t286 * t200 + 0.5e1 / 0.24e2 * t57 * t74 * t290
  t297 = 0.69347911111111111111111111111111111111111111111110e-1 * t19 * t78 - 0.75282110933333333333333333333333333333333333333332e-2 * t83 * t78 - 0.89161600000000000000000000000000000000000000000000e-1 * t88 * t128 + 0.15890798916177777777777777777777777777777777777777e-3 * t133 * t78 + 0.56461583200000000000000000000000000000000000000000e-2 * t136 * t128 + 0.66871200000000000000000000000000000000000000000000e-1 * t141 * t204 + 0.264e0 * t18 * t294
  t302 = 0.2e1 * t2 * t145 - 0.2e1 * t90
  t312 = -0.29720533333333333333333333333333333333333333333333e-1 * t88 * t78 + 0.18820527733333333333333333333333333333333333333333e-2 * t136 * t78 + 0.44580800000000000000000000000000000000000000000000e-1 * t141 * t128 + 0.264e0 * t18 * t204
  t319 = -0.6e1 * t2 * t132 + 0.8e1 * t146 - 0.2e1 * t5
  t325 = 0.22290400000000000000000000000000000000000000000000e-1 * t141 * t78 + 0.264e0 * t18 * t128
  t330 = 0.1e1 / t253
  t333 = 0.24e2 * t2 * t330 + 0.12e2 * t145 - 0.36e2 * t214
  t337 = 0.1e1 + 0.264e0 * t18 * t78
  t341 = 0.1e1 / t63 / t3
  t343 = t11 ** 2
  t345 = 0.1e1 / t343 / t11
  t349 = t7 * t345
  t353 = t343 ** 2
  t354 = 0.1e1 / t353
  t359 = 0.1e1 / t343
  t360 = t302 * t359
  t364 = t7 * t359
  t387 = -0.19672e0 * t7 * t12 * t297 - 0.59016e0 * t302 * t12 * t312 - 0.59016e0 * t319 * t12 * t325 - 0.19672e0 * t333 * t12 * t337 - 0.15973795146666666666666666666666666666666666666665e-1 * t341 * t302 * t345 * t325 + 0.53245983822222222222222222222222222222222222222220e-2 * t349 * t325 * t65 + 0.18582848353955555555555555555555555555555555555555e-2 * t7 * t354 * t337 * t132 + 0.20342305185185185185185185185185185185185185185184e-1 * t360 * t337 * t87 + 0.20342305185185185185185185185185185185185185185184e-1 * t364 * t325 * t87 - 0.19672e0 * t3 * t302 * t12 * t297 - 0.68655279999999999999999999999999999999999999999997e-1 * t9 * t319 * t359 * t325 - 0.79868975733333333333333333333333333333333333333327e-2 * t341 * t319 * t345 * t337 - 0.68655279999999999999999999999999999999999999999997e-1 * t9 * t302 * t359 * t312 - 0.11866344691358024691358024691358024691358024691358e-1 * t364 * t337 * t16
  t411 = 0.1e1 / t8 / t131
  t440 = t168 ** 2
  t446 = t171 ** 2
  t451 = t1 * t330
  t452 = t132 - t451
  t453 = 0.24e2 * t452
  t457 = f.my_piecewise3(t45, 0, -0.80e2 / 0.81e2 / t47 / t44 * t440 + 0.160e3 / 0.9e1 * t238 * t168 * t171 + 0.40e2 / 0.3e1 * t48 * t446 + 0.160e3 / 0.9e1 * t242 * t245 + 0.8e1 / 0.3e1 * t108 * t453)
  t461 = t131 * t4
  t468 = t142 ** 2
  t474 = t148 ** 2
  t483 = f.my_piecewise3(t23, 0, -0.80e2 / 0.81e2 / t29 / t22 * t468 + 0.160e3 / 0.9e1 * t207 * t142 * t148 + 0.40e2 / 0.3e1 * t30 * t474 + 0.160e3 / 0.9e1 * t211 * t216 - 0.8e1 / 0.3e1 * t89 * t453)
  t495 = 0.1e1 / t36 / t228 / r0
  t498 = l0 * t495
  t504 = -0.12e2 * t452
  t518 = t457 * t33 * t59 / 0.8e1 - 0.2618e4 / 0.81e2 * t62 / t63 / t461 + t483 * t33 * t42 / 0.8e1 + t221 * t105 / 0.2e1 + 0.3e1 / 0.4e1 * t153 * t165 + t95 * t235 / 0.2e1 + t34 * (0.6160e4 / 0.81e2 * tau0 * t495 - 0.770e3 / 0.81e2 * t498) / 0.8e1 + 0.5e1 / 0.24e2 * t40 * t69 * t504 - 0.5e1 / 0.24e2 * t57 * t74 * t504 + 0.770e3 / 0.81e2 * t498 * t70 - 0.1100e4 / 0.81e2 * t233 * t121 + 0.50e2 / 0.9e1 * t163 * t192
  t525 = t147 ** 2
  t532 = t72 ** 2
  t535 = t196 ** 2
  t543 = t200 ** 2
  t556 = t67 ** 2
  t559 = t188 ** 2
  t563 = -0.25e2 / 0.18e2 * t103 * t277 - 0.5e1 / 0.18e2 * t40 * t267 * t188 * t147 + 0.5e1 / 0.12e2 * t40 * t187 * t525 + 0.5e1 / 0.9e1 * t40 * t272 * t276 + 0.5e1 / 0.81e2 * t57 / t73 / t532 * t535 - 0.5e1 / 0.18e2 * t57 * t281 * t196 * t200 + 0.5e1 / 0.12e2 * t57 * t195 * t543 + 0.5e1 / 0.9e1 * t57 * t286 * t290 + 0.100e3 / 0.27e2 * t163 * t189 + 0.25e2 / 0.81e2 * t103 * t269 - 0.25e2 / 0.9e1 * t103 * t273 + 0.5e1 / 0.81e2 * t40 / t68 / t556 * t559
  t567 = -0.23115970370370370370370370370370370370370370370370e0 * t411 * t18 * t78 + 0.33458715970370370370370370370370370370370370370370e-1 * t180 * t18 * t78 + 0.27739164444444444444444444444444444444444444444444e0 * t19 * t128 - 0.12712639132942222222222222222222222222222222222222e-2 * t330 * t18 * t78 - 0.30112844373333333333333333333333333333333333333333e-1 * t83 * t128 - 0.17832320000000000000000000000000000000000000000000e0 * t88 * t204 + 0.13417131218226103703703703703703703703703703703703e-4 / t8 / t253 * t18 * t78 + 0.63563195664711111111111111111111111111111111111110e-3 * t133 * t128 + 0.11292316640000000000000000000000000000000000000000e-1 * t136 * t204 + 0.89161600000000000000000000000000000000000000000000e-1 * t141 * t294 + 0.264e0 * t18 * (t518 + t563)
  t611 = -0.18582848353955555555555555555555555555555555555554e-2 * t145 * t302 * t354 * t337 - 0.23664881698765432098765432098765432098765432098767e-2 * t349 * t337 * t82 - 0.22885093333333333333333333333333333333333333333333e-1 * t319 * t359 * t337 * t140 - 0.45770186666666666666666666666666666666666666666665e-1 * t360 * t325 * t140 + 0.53245983822222222222222222222222222222222222222220e-2 * t302 * t345 * t337 * t65 - 0.22885093333333333333333333333333333333333333333333e-1 * t364 * t312 * t140 - 0.4918e-1 * t3 * t7 * t12 * t567 - 0.79868975733333333333333333333333333333333333333327e-2 * t341 * t7 * t345 * t312 - 0.18582848353955555555555555555555555555555555555554e-2 * t145 * t7 * t354 * t325 - 0.22885093333333333333333333333333333333333333333332e-1 * t9 * t7 * t359 * t297 - 0.22885093333333333333333333333333333333333333333332e-1 * t9 * t333 * t359 * t337 - 0.29508e0 * t3 * t319 * t12 * t312 - 0.21618046918434962962962962962962962962962962962961e-3 * t411 * t7 / t353 / t11 * t337 - 0.4918e-1 * t3 * (-0.72e2 * t132 + 0.192e3 * t451 - 0.120e3 * t2 / t461) * t12 * t337 - 0.19672e0 * t3 * t333 * t12 * t325
  d1111 = t387 + t611

  res = {'v4rho4': d1111}
  return res
