"""Generated from mgga_x_m06l.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_a_raw = params.a
  if isinstance(params_a_raw, (str, bytes, dict)):
    params_a = params_a_raw
  else:
    try:
      params_a_seq = list(params_a_raw)
    except TypeError:
      params_a = params_a_raw
    else:
      params_a_seq = np.asarray(params_a_seq, dtype=np.float64)
      params_a = np.concatenate((np.array([np.nan], dtype=np.float64), params_a_seq))
  params_d_raw = params.d
  if isinstance(params_d_raw, (str, bytes, dict)):
    params_d = params_d_raw
  else:
    try:
      params_d_seq = list(params_d_raw)
    except TypeError:
      params_d = params_d_raw
    else:
      params_d_seq = np.asarray(params_d_seq, dtype=np.float64)
      params_d = np.concatenate((np.array([np.nan], dtype=np.float64), params_d_seq))

  params_kappa = 0.804

  params_mu = 0.2195149727645171

  gvt4_gamm = lambda alpha, x, z: 1 + alpha * (x ** 2 + z)

  m06_alpha = 0.00186726

  m06_coeff_d = params_d

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  gtv4 = lambda alpha, dd, x, z: dd[1] / gvt4_gamm(alpha, x, z) + (dd[2] * x ** 2 + dd[3] * z) / gvt4_gamm(alpha, x, z) ** 2 + (dd[4] * x ** 4 + dd[5] * x ** 2 * z + dd[6] * z ** 2) / gvt4_gamm(alpha, x, z) ** 3

  pbe_f = lambda x: pbe_f0(X2S * x)

  m06_f = lambda x, u, t: +pbe_f(x) * mgga_series_w(params_a, 12, t) + gtv4(m06_alpha, m06_coeff_d, x, 2 * (t - K_FACTOR_C))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, m06_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_a_raw = params.a
  if isinstance(params_a_raw, (str, bytes, dict)):
    params_a = params_a_raw
  else:
    try:
      params_a_seq = list(params_a_raw)
    except TypeError:
      params_a = params_a_raw
    else:
      params_a_seq = np.asarray(params_a_seq, dtype=np.float64)
      params_a = np.concatenate((np.array([np.nan], dtype=np.float64), params_a_seq))
  params_d_raw = params.d
  if isinstance(params_d_raw, (str, bytes, dict)):
    params_d = params_d_raw
  else:
    try:
      params_d_seq = list(params_d_raw)
    except TypeError:
      params_d = params_d_raw
    else:
      params_d_seq = np.asarray(params_d_seq, dtype=np.float64)
      params_d = np.concatenate((np.array([np.nan], dtype=np.float64), params_d_seq))

  params_kappa = 0.804

  params_mu = 0.2195149727645171

  gvt4_gamm = lambda alpha, x, z: 1 + alpha * (x ** 2 + z)

  m06_alpha = 0.00186726

  m06_coeff_d = params_d

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  gtv4 = lambda alpha, dd, x, z: dd[1] / gvt4_gamm(alpha, x, z) + (dd[2] * x ** 2 + dd[3] * z) / gvt4_gamm(alpha, x, z) ** 2 + (dd[4] * x ** 4 + dd[5] * x ** 2 * z + dd[6] * z ** 2) / gvt4_gamm(alpha, x, z) ** 3

  pbe_f = lambda x: pbe_f0(X2S * x)

  m06_f = lambda x, u, t: +pbe_f(x) * mgga_series_w(params_a, 12, t) + gtv4(m06_alpha, m06_coeff_d, x, 2 * (t - K_FACTOR_C))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, m06_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_a_raw = params.a
  if isinstance(params_a_raw, (str, bytes, dict)):
    params_a = params_a_raw
  else:
    try:
      params_a_seq = list(params_a_raw)
    except TypeError:
      params_a = params_a_raw
    else:
      params_a_seq = np.asarray(params_a_seq, dtype=np.float64)
      params_a = np.concatenate((np.array([np.nan], dtype=np.float64), params_a_seq))
  params_d_raw = params.d
  if isinstance(params_d_raw, (str, bytes, dict)):
    params_d = params_d_raw
  else:
    try:
      params_d_seq = list(params_d_raw)
    except TypeError:
      params_d = params_d_raw
    else:
      params_d_seq = np.asarray(params_d_seq, dtype=np.float64)
      params_d = np.concatenate((np.array([np.nan], dtype=np.float64), params_d_seq))

  params_kappa = 0.804

  params_mu = 0.2195149727645171

  gvt4_gamm = lambda alpha, x, z: 1 + alpha * (x ** 2 + z)

  m06_alpha = 0.00186726

  m06_coeff_d = params_d

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  gtv4 = lambda alpha, dd, x, z: dd[1] / gvt4_gamm(alpha, x, z) + (dd[2] * x ** 2 + dd[3] * z) / gvt4_gamm(alpha, x, z) ** 2 + (dd[4] * x ** 4 + dd[5] * x ** 2 * z + dd[6] * z ** 2) / gvt4_gamm(alpha, x, z) ** 3

  pbe_f = lambda x: pbe_f0(X2S * x)

  m06_f = lambda x, u, t: +pbe_f(x) * mgga_series_w(params_a, 12, t) + gtv4(m06_alpha, m06_coeff_d, x, 2 * (t - K_FACTOR_C))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, m06_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = jnp.pi ** 2
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = 0.1e1 / t31
  t33 = t28 * t32
  t34 = r0 ** 2
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / t34
  t39 = s0 * t38
  t42 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333333e-2 * t33 * t39
  t45 = 0.18040e1 - 0.64641600e0 / t42
  t46 = params.a[0]
  t47 = params.a[1]
  t48 = t28 ** 2
  t49 = t48 * t31
  t50 = 0.3e1 / 0.10e2 * t49
  t52 = 0.1e1 / t36 / r0
  t53 = tau0 * t52
  t54 = t50 - t53
  t55 = t47 * t54
  t56 = t50 + t53
  t57 = 0.1e1 / t56
  t59 = params.a[2]
  t60 = t54 ** 2
  t61 = t59 * t60
  t62 = t56 ** 2
  t63 = 0.1e1 / t62
  t65 = params.a[3]
  t66 = t60 * t54
  t67 = t65 * t66
  t68 = t62 * t56
  t69 = 0.1e1 / t68
  t71 = params.a[4]
  t72 = t60 ** 2
  t73 = t71 * t72
  t74 = t62 ** 2
  t75 = 0.1e1 / t74
  t77 = params.a[5]
  t78 = t72 * t54
  t79 = t77 * t78
  t81 = 0.1e1 / t74 / t56
  t83 = params.a[6]
  t84 = t72 * t60
  t85 = t83 * t84
  t87 = 0.1e1 / t74 / t62
  t89 = params.a[7]
  t90 = t72 * t66
  t91 = t89 * t90
  t93 = 0.1e1 / t74 / t68
  t95 = params.a[8]
  t96 = t72 ** 2
  t97 = t95 * t96
  t98 = t74 ** 2
  t99 = 0.1e1 / t98
  t101 = params.a[9]
  t102 = t96 * t54
  t103 = t101 * t102
  t105 = 0.1e1 / t98 / t56
  t107 = params.a[10]
  t108 = t96 * t60
  t109 = t107 * t108
  t111 = 0.1e1 / t98 / t62
  t113 = params.a[11]
  t115 = t113 * t96 * t66
  t117 = 0.1e1 / t98 / t68
  t119 = t103 * t105 + t109 * t111 + t115 * t117 + t55 * t57 + t61 * t63 + t67 * t69 + t73 * t75 + t79 * t81 + t85 * t87 + t91 * t93 + t97 * t99 + t46
  t121 = params.d[0]
  t124 = 0.11203560000000000000000000000000000000000000000000e-2 * t49
  t125 = 0.1e1 + 0.186726e-2 * t39 + 0.373452e-2 * t53 - t124
  t128 = params.d[1]
  t129 = t128 * s0
  t131 = params.d[2]
  t133 = 0.3e1 / 0.5e1 * t49
  t134 = 0.2e1 * t53 - t133
  t136 = t129 * t38 + t131 * t134
  t137 = t125 ** 2
  t138 = 0.1e1 / t137
  t140 = params.d[3]
  t141 = s0 ** 2
  t142 = t140 * t141
  t143 = t34 ** 2
  t146 = 0.1e1 / t35 / t143 / r0
  t148 = params.d[4]
  t149 = t148 * s0
  t152 = params.d[5]
  t153 = t134 ** 2
  t155 = t149 * t38 * t134 + t142 * t146 + t152 * t153
  t157 = 0.1e1 / t137 / t125
  t159 = t45 * t119 + t121 / t125 + t136 * t138 + t155 * t157
  t163 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t159)
  t164 = r1 <= f.p.dens_threshold
  t165 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t166 = 0.1e1 + t165
  t167 = t166 <= f.p.zeta_threshold
  t168 = t166 ** (0.1e1 / 0.3e1)
  t170 = f.my_piecewise3(t167, t22, t168 * t166)
  t171 = t170 * t26
  t172 = r1 ** 2
  t173 = r1 ** (0.1e1 / 0.3e1)
  t174 = t173 ** 2
  t176 = 0.1e1 / t174 / t172
  t177 = s2 * t176
  t180 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333333e-2 * t33 * t177
  t183 = 0.18040e1 - 0.64641600e0 / t180
  t185 = 0.1e1 / t174 / r1
  t186 = tau1 * t185
  t187 = t50 - t186
  t188 = t47 * t187
  t189 = t50 + t186
  t190 = 0.1e1 / t189
  t192 = t187 ** 2
  t193 = t59 * t192
  t194 = t189 ** 2
  t195 = 0.1e1 / t194
  t197 = t192 * t187
  t198 = t65 * t197
  t199 = t194 * t189
  t200 = 0.1e1 / t199
  t202 = t192 ** 2
  t203 = t71 * t202
  t204 = t194 ** 2
  t205 = 0.1e1 / t204
  t207 = t202 * t187
  t208 = t77 * t207
  t210 = 0.1e1 / t204 / t189
  t212 = t202 * t192
  t213 = t83 * t212
  t215 = 0.1e1 / t204 / t194
  t217 = t202 * t197
  t218 = t89 * t217
  t220 = 0.1e1 / t204 / t199
  t222 = t202 ** 2
  t223 = t95 * t222
  t224 = t204 ** 2
  t225 = 0.1e1 / t224
  t227 = t222 * t187
  t228 = t101 * t227
  t230 = 0.1e1 / t224 / t189
  t232 = t222 * t192
  t233 = t107 * t232
  t235 = 0.1e1 / t224 / t194
  t238 = t113 * t222 * t197
  t240 = 0.1e1 / t224 / t199
  t242 = t188 * t190 + t193 * t195 + t198 * t200 + t203 * t205 + t208 * t210 + t213 * t215 + t218 * t220 + t223 * t225 + t228 * t230 + t233 * t235 + t238 * t240 + t46
  t246 = 0.1e1 + 0.186726e-2 * t177 + 0.373452e-2 * t186 - t124
  t249 = t128 * s2
  t252 = 0.2e1 * t186 - t133
  t254 = t131 * t252 + t249 * t176
  t255 = t246 ** 2
  t256 = 0.1e1 / t255
  t258 = s2 ** 2
  t259 = t140 * t258
  t260 = t172 ** 2
  t263 = 0.1e1 / t173 / t260 / r1
  t265 = t148 * s2
  t268 = t252 ** 2
  t270 = t265 * t176 * t252 + t152 * t268 + t259 * t263
  t272 = 0.1e1 / t255 / t246
  t274 = t183 * t242 + t121 / t246 + t254 * t256 + t270 * t272
  t278 = f.my_piecewise3(t164, 0, -0.3e1 / 0.8e1 * t5 * t171 * t274)
  t279 = t6 ** 2
  t281 = t16 / t279
  t282 = t7 - t281
  t283 = f.my_piecewise5(t10, 0, t14, 0, t282)
  t286 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t283)
  t291 = t26 ** 2
  t292 = 0.1e1 / t291
  t296 = t5 * t25 * t292 * t159 / 0.8e1
  t297 = t42 ** 2
  t299 = 0.1e1 / t297 * t28
  t303 = 0.1e1 / t36 / t34 / r0
  t304 = s0 * t303
  t313 = t63 * tau0 * t38
  t316 = t59 * t54
  t320 = t69 * tau0 * t38
  t323 = t65 * t60
  t327 = t75 * tau0 * t38
  t330 = t71 * t66
  t334 = t81 * tau0 * t38
  t337 = t77 * t72
  t341 = t87 * tau0 * t38
  t344 = t83 * t78
  t347 = 0.5e1 / 0.3e1 * t47 * tau0 * t38 * t57 + 0.5e1 / 0.3e1 * t55 * t313 + 0.10e2 / 0.3e1 * t316 * t313 + 0.10e2 / 0.3e1 * t61 * t320 + 0.5e1 * t323 * t320 + 0.5e1 * t67 * t327 + 0.20e2 / 0.3e1 * t330 * t327 + 0.20e2 / 0.3e1 * t73 * t334 + 0.25e2 / 0.3e1 * t337 * t334 + 0.25e2 / 0.3e1 * t79 * t341 + 0.10e2 * t344 * t341
  t349 = t93 * tau0 * t38
  t352 = t89 * t84
  t356 = t99 * tau0 * t38
  t359 = t95 * t90
  t363 = t105 * tau0 * t38
  t366 = t101 * t96
  t370 = t111 * tau0 * t38
  t373 = t107 * t102
  t377 = t117 * tau0 * t38
  t380 = t113 * t108
  t384 = 0.1e1 / t98 / t74
  t389 = 0.10e2 * t85 * t349 + 0.35e2 / 0.3e1 * t352 * t349 + 0.35e2 / 0.3e1 * t91 * t356 + 0.40e2 / 0.3e1 * t359 * t356 + 0.40e2 / 0.3e1 * t97 * t363 + 0.15e2 * t366 * t363 + 0.15e2 * t103 * t370 + 0.50e2 / 0.3e1 * t373 * t370 + 0.50e2 / 0.3e1 * t109 * t377 + 0.55e2 / 0.3e1 * t380 * t377 + 0.55e2 / 0.3e1 * t115 * t384 * tau0 * t38
  t392 = t121 * t138
  t394 = tau0 * t38
  t396 = -0.49793600000000000000000000000000000000000000000000e-2 * t304 - 0.62242000000000000000000000000000000000000000000000e-2 * t394
  t405 = t136 * t157
  t419 = t152 * t134
  t424 = t137 ** 2
  t426 = t155 / t424
  t434 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t286 * t26 * t159 - t296 - 0.3e1 / 0.8e1 * t5 * t27 * (-0.15766443403838676190400000000000000000000000000000e-1 * t299 * t32 * t304 * t119 + t45 * (t347 + t389) - t392 * t396 + (-0.8e1 / 0.3e1 * t129 * t303 - 0.10e2 / 0.3e1 * t131 * tau0 * t38) * t138 - 0.2e1 * t405 * t396 + (-0.16e2 / 0.3e1 * t142 / t35 / t143 / t34 - 0.8e1 / 0.3e1 * t149 * t303 * t134 - 0.10e2 / 0.3e1 * t149 * t146 * tau0 - 0.20e2 / 0.3e1 * t419 * t394) * t157 - 0.3e1 * t426 * t396))
  t436 = f.my_piecewise5(t14, 0, t10, 0, -t282)
  t439 = f.my_piecewise3(t167, 0, 0.4e1 / 0.3e1 * t168 * t436)
  t447 = t5 * t170 * t292 * t274 / 0.8e1
  t449 = f.my_piecewise3(t164, 0, -0.3e1 / 0.8e1 * t5 * t439 * t26 * t274 - t447)
  vrho_0_ = t163 + t278 + t6 * (t434 + t449)
  t452 = -t7 - t281
  t453 = f.my_piecewise5(t10, 0, t14, 0, t452)
  t456 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t453)
  t462 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t456 * t26 * t159 - t296)
  t464 = f.my_piecewise5(t14, 0, t10, 0, -t452)
  t467 = f.my_piecewise3(t167, 0, 0.4e1 / 0.3e1 * t168 * t464)
  t472 = t180 ** 2
  t474 = 0.1e1 / t472 * t28
  t478 = 0.1e1 / t174 / t172 / r1
  t479 = s2 * t478
  t488 = t195 * tau1 * t176
  t491 = t59 * t187
  t495 = t200 * tau1 * t176
  t498 = t65 * t192
  t502 = t205 * tau1 * t176
  t505 = t71 * t197
  t509 = t210 * tau1 * t176
  t512 = t77 * t202
  t516 = t215 * tau1 * t176
  t519 = t83 * t207
  t522 = 0.5e1 / 0.3e1 * t47 * tau1 * t176 * t190 + 0.5e1 / 0.3e1 * t188 * t488 + 0.10e2 / 0.3e1 * t491 * t488 + 0.10e2 / 0.3e1 * t193 * t495 + 0.5e1 * t498 * t495 + 0.5e1 * t198 * t502 + 0.20e2 / 0.3e1 * t505 * t502 + 0.20e2 / 0.3e1 * t203 * t509 + 0.25e2 / 0.3e1 * t512 * t509 + 0.25e2 / 0.3e1 * t208 * t516 + 0.10e2 * t519 * t516
  t524 = t220 * tau1 * t176
  t527 = t89 * t212
  t531 = t225 * tau1 * t176
  t534 = t95 * t217
  t538 = t230 * tau1 * t176
  t541 = t101 * t222
  t545 = t235 * tau1 * t176
  t548 = t107 * t227
  t552 = t240 * tau1 * t176
  t555 = t113 * t232
  t559 = 0.1e1 / t224 / t204
  t564 = 0.10e2 * t213 * t524 + 0.35e2 / 0.3e1 * t527 * t524 + 0.35e2 / 0.3e1 * t218 * t531 + 0.40e2 / 0.3e1 * t534 * t531 + 0.40e2 / 0.3e1 * t223 * t538 + 0.15e2 * t541 * t538 + 0.15e2 * t228 * t545 + 0.50e2 / 0.3e1 * t548 * t545 + 0.50e2 / 0.3e1 * t233 * t552 + 0.55e2 / 0.3e1 * t555 * t552 + 0.55e2 / 0.3e1 * t238 * t559 * tau1 * t176
  t567 = t121 * t256
  t569 = tau1 * t176
  t571 = -0.49793600000000000000000000000000000000000000000000e-2 * t479 - 0.62242000000000000000000000000000000000000000000000e-2 * t569
  t580 = t254 * t272
  t594 = t152 * t252
  t599 = t255 ** 2
  t601 = t270 / t599
  t609 = f.my_piecewise3(t164, 0, -0.3e1 / 0.8e1 * t5 * t467 * t26 * t274 - t447 - 0.3e1 / 0.8e1 * t5 * t171 * (-0.15766443403838676190400000000000000000000000000000e-1 * t474 * t32 * t479 * t242 + t183 * (t522 + t564) - t567 * t571 + (-0.8e1 / 0.3e1 * t249 * t478 - 0.10e2 / 0.3e1 * t131 * tau1 * t176) * t256 - 0.2e1 * t580 * t571 + (-0.16e2 / 0.3e1 * t259 / t173 / t260 / t172 - 0.8e1 / 0.3e1 * t265 * t478 * t252 - 0.10e2 / 0.3e1 * t265 * t263 * tau1 - 0.20e2 / 0.3e1 * t594 * t569) * t272 - 0.3e1 * t601 * t571))
  vrho_1_ = t163 + t278 + t6 * (t462 + t609)
  t635 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (0.59124162764395035714000000000000000000000000000000e-2 * t299 * t32 * t38 * t119 - 0.186726e-2 * t392 * t38 + t128 * t38 * t138 - 0.373452e-2 * t405 * t38 + (0.2e1 * t140 * s0 * t146 + t148 * t38 * t134) * t157 - 0.560178e-2 * t426 * t38))
  vsigma_0_ = t6 * t635
  vsigma_1_ = 0.0e0
  t659 = f.my_piecewise3(t164, 0, -0.3e1 / 0.8e1 * t5 * t171 * (0.59124162764395035714000000000000000000000000000000e-2 * t474 * t32 * t176 * t242 - 0.186726e-2 * t567 * t176 + t128 * t176 * t256 - 0.373452e-2 * t580 * t176 + (0.2e1 * t140 * s2 * t263 + t148 * t176 * t252) * t272 - 0.560178e-2 * t601 * t176))
  vsigma_2_ = t6 * t659
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t662 = t63 * t52
  t666 = t69 * t52
  t671 = t75 * t52
  t676 = t81 * t52
  t681 = t87 * t52
  t686 = -t47 * t52 * t57 - 0.2e1 * t316 * t662 - 0.3e1 * t323 * t666 - 0.4e1 * t330 * t671 - 0.5e1 * t337 * t676 - 0.6e1 * t344 * t681 - t55 * t662 - 0.2e1 * t61 * t666 - 0.3e1 * t67 * t671 - 0.4e1 * t73 * t676 - 0.5e1 * t79 * t681
  t687 = t93 * t52
  t692 = t99 * t52
  t697 = t105 * t52
  t702 = t111 * t52
  t707 = t117 * t52
  t715 = -0.11e2 * t115 * t384 * t52 - 0.9e1 * t103 * t702 - 0.10e2 * t109 * t707 - 0.7e1 * t352 * t687 - 0.8e1 * t359 * t692 - 0.9e1 * t366 * t697 - 0.10e2 * t373 * t702 - 0.11e2 * t380 * t707 - 0.6e1 * t85 * t687 - 0.7e1 * t91 * t692 - 0.8e1 * t97 * t697
  t739 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (t45 * (t686 + t715) - 0.373452e-2 * t392 * t52 + 0.2e1 * t131 * t52 * t138 - 0.746904e-2 * t405 * t52 + (0.2e1 * t149 / t35 / t143 + 0.4e1 * t419 * t52) * t157 - 0.1120356e-1 * t426 * t52))
  vtau_0_ = t6 * t739
  t742 = t195 * t185
  t746 = t200 * t185
  t751 = t205 * t185
  t756 = t210 * t185
  t761 = t215 * t185
  t766 = -t47 * t185 * t190 - t188 * t742 - 0.2e1 * t193 * t746 - 0.3e1 * t198 * t751 - 0.4e1 * t203 * t756 - 0.5e1 * t208 * t761 - 0.2e1 * t491 * t742 - 0.3e1 * t498 * t746 - 0.4e1 * t505 * t751 - 0.5e1 * t512 * t756 - 0.6e1 * t519 * t761
  t767 = t220 * t185
  t772 = t225 * t185
  t777 = t230 * t185
  t782 = t235 * t185
  t787 = t240 * t185
  t795 = -0.11e2 * t238 * t559 * t185 - 0.6e1 * t213 * t767 - 0.7e1 * t218 * t772 - 0.8e1 * t223 * t777 - 0.9e1 * t228 * t782 - 0.10e2 * t233 * t787 - 0.7e1 * t527 * t767 - 0.8e1 * t534 * t772 - 0.9e1 * t541 * t777 - 0.10e2 * t548 * t782 - 0.11e2 * t555 * t787
  t819 = f.my_piecewise3(t164, 0, -0.3e1 / 0.8e1 * t5 * t171 * (t183 * (t766 + t795) - 0.373452e-2 * t567 * t185 + 0.2e1 * t131 * t185 * t256 - 0.746904e-2 * t580 * t185 + (0.2e1 * t265 / t173 / t260 + 0.4e1 * t594 * t185) * t272 - 0.1120356e-1 * t601 * t185))
  vtau_1_ = t6 * t819
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_a_raw = params.a
  if isinstance(params_a_raw, (str, bytes, dict)):
    params_a = params_a_raw
  else:
    try:
      params_a_seq = list(params_a_raw)
    except TypeError:
      params_a = params_a_raw
    else:
      params_a_seq = np.asarray(params_a_seq, dtype=np.float64)
      params_a = np.concatenate((np.array([np.nan], dtype=np.float64), params_a_seq))
  params_d_raw = params.d
  if isinstance(params_d_raw, (str, bytes, dict)):
    params_d = params_d_raw
  else:
    try:
      params_d_seq = list(params_d_raw)
    except TypeError:
      params_d = params_d_raw
    else:
      params_d_seq = np.asarray(params_d_seq, dtype=np.float64)
      params_d = np.concatenate((np.array([np.nan], dtype=np.float64), params_d_seq))

  params_kappa = 0.804

  params_mu = 0.2195149727645171

  gvt4_gamm = lambda alpha, x, z: 1 + alpha * (x ** 2 + z)

  m06_alpha = 0.00186726

  m06_coeff_d = params_d

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  gtv4 = lambda alpha, dd, x, z: dd[1] / gvt4_gamm(alpha, x, z) + (dd[2] * x ** 2 + dd[3] * z) / gvt4_gamm(alpha, x, z) ** 2 + (dd[4] * x ** 4 + dd[5] * x ** 2 * z + dd[6] * z ** 2) / gvt4_gamm(alpha, x, z) ** 3

  pbe_f = lambda x: pbe_f0(X2S * x)

  m06_f = lambda x, u, t: +pbe_f(x) * mgga_series_w(params_a, 12, t) + gtv4(m06_alpha, m06_coeff_d, x, 2 * (t - K_FACTOR_C))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, m06_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** 2
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = 0.1e1 / t23
  t26 = 2 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = s0 * t27
  t29 = r0 ** 2
  t30 = t18 ** 2
  t32 = 0.1e1 / t30 / t29
  t33 = t28 * t32
  t36 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333333e-2 * t20 * t24 * t33
  t39 = 0.18040e1 - 0.64641600e0 / t36
  t41 = params.a[1]
  t42 = t20 ** 2
  t43 = t42 * t23
  t44 = 0.3e1 / 0.10e2 * t43
  t45 = tau0 * t27
  t47 = 0.1e1 / t30 / r0
  t48 = t45 * t47
  t49 = t44 - t48
  t50 = t41 * t49
  t51 = t44 + t48
  t52 = 0.1e1 / t51
  t54 = params.a[2]
  t55 = t49 ** 2
  t56 = t54 * t55
  t57 = t51 ** 2
  t58 = 0.1e1 / t57
  t60 = params.a[3]
  t61 = t55 * t49
  t62 = t60 * t61
  t63 = t57 * t51
  t64 = 0.1e1 / t63
  t66 = params.a[4]
  t67 = t55 ** 2
  t68 = t66 * t67
  t69 = t57 ** 2
  t70 = 0.1e1 / t69
  t72 = params.a[5]
  t73 = t67 * t49
  t74 = t72 * t73
  t76 = 0.1e1 / t69 / t51
  t78 = params.a[6]
  t79 = t67 * t55
  t80 = t78 * t79
  t82 = 0.1e1 / t69 / t57
  t84 = params.a[7]
  t85 = t67 * t61
  t86 = t84 * t85
  t88 = 0.1e1 / t69 / t63
  t90 = params.a[8]
  t91 = t67 ** 2
  t92 = t90 * t91
  t93 = t69 ** 2
  t94 = 0.1e1 / t93
  t96 = params.a[9]
  t97 = t91 * t49
  t98 = t96 * t97
  t100 = 0.1e1 / t93 / t51
  t102 = params.a[10]
  t103 = t91 * t55
  t104 = t102 * t103
  t106 = 0.1e1 / t93 / t57
  t108 = params.a[11]
  t110 = t108 * t91 * t61
  t112 = 0.1e1 / t93 / t63
  t114 = t98 * t100 + t104 * t106 + t110 * t112 + t50 * t52 + t56 * t58 + t62 * t64 + t68 * t70 + t74 * t76 + t80 * t82 + t86 * t88 + t92 * t94 + params.a[0]
  t116 = params.d[0]
  t120 = 0.1e1 + 0.186726e-2 * t33 + 0.373452e-2 * t48 - 0.11203560000000000000000000000000000000000000000000e-2 * t43
  t123 = params.d[1]
  t124 = t123 * s0
  t125 = t27 * t32
  t127 = params.d[2]
  t130 = 0.2e1 * t48 - 0.3e1 / 0.5e1 * t43
  t132 = t124 * t125 + t127 * t130
  t133 = t120 ** 2
  t134 = 0.1e1 / t133
  t136 = params.d[3]
  t137 = s0 ** 2
  t138 = t136 * t137
  t139 = t29 ** 2
  t143 = t26 / t18 / t139 / r0
  t146 = params.d[4]
  t147 = t146 * s0
  t150 = params.d[5]
  t151 = t130 ** 2
  t153 = t147 * t125 * t130 + 0.2e1 * t138 * t143 + t150 * t151
  t155 = 0.1e1 / t133 / t120
  t157 = t39 * t114 + t116 / t120 + t132 * t134 + t153 * t155
  t161 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t157)
  t167 = t36 ** 2
  t170 = 0.1e1 / t167 * t20 * t24
  t173 = 0.1e1 / t30 / t29 / r0
  t183 = t45 * t32
  t186 = t54 * t49
  t193 = t60 * t55
  t200 = t66 * t61
  t207 = t72 * t67
  t214 = t78 * t73
  t218 = 0.5e1 / 0.3e1 * t41 * tau0 * t125 * t52 + 0.5e1 / 0.3e1 * t50 * t58 * t183 + 0.10e2 / 0.3e1 * t186 * t58 * t183 + 0.10e2 / 0.3e1 * t56 * t64 * t183 + 0.5e1 * t193 * t64 * t183 + 0.5e1 * t62 * t70 * t183 + 0.20e2 / 0.3e1 * t200 * t70 * t183 + 0.20e2 / 0.3e1 * t68 * t76 * t183 + 0.25e2 / 0.3e1 * t207 * t76 * t183 + 0.25e2 / 0.3e1 * t74 * t82 * t183 + 0.10e2 * t214 * t82 * t183
  t222 = t84 * t79
  t229 = t90 * t85
  t236 = t96 * t91
  t243 = t102 * t97
  t250 = t108 * t103
  t255 = 0.1e1 / t93 / t69
  t259 = 0.10e2 * t80 * t88 * t183 + 0.35e2 / 0.3e1 * t222 * t88 * t183 + 0.35e2 / 0.3e1 * t86 * t94 * t183 + 0.40e2 / 0.3e1 * t229 * t94 * t183 + 0.40e2 / 0.3e1 * t92 * t100 * t183 + 0.15e2 * t236 * t100 * t183 + 0.15e2 * t98 * t106 * t183 + 0.50e2 / 0.3e1 * t243 * t106 * t183 + 0.50e2 / 0.3e1 * t104 * t112 * t183 + 0.55e2 / 0.3e1 * t250 * t112 * t183 + 0.55e2 / 0.3e1 * t110 * t255 * t183
  t262 = t116 * t134
  t266 = -0.49793600000000000000000000000000000000000000000000e-2 * t28 * t173 - 0.62242000000000000000000000000000000000000000000000e-2 * t183
  t268 = t27 * t173
  t276 = t132 * t155
  t291 = t150 * t130
  t296 = t133 ** 2
  t298 = t153 / t296
  t306 = f.my_piecewise3(t2, 0, -t6 * t17 / t30 * t157 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (-0.15766443403838676190400000000000000000000000000000e-1 * t170 * t28 * t173 * t114 + t39 * (t218 + t259) - t262 * t266 + (-0.8e1 / 0.3e1 * t124 * t268 - 0.10e2 / 0.3e1 * t127 * tau0 * t125) * t134 - 0.2e1 * t276 * t266 + (-0.32e2 / 0.3e1 * t138 * t26 / t18 / t139 / t29 - 0.8e1 / 0.3e1 * t147 * t268 * t130 - 0.20e2 / 0.3e1 * t147 * t143 * tau0 - 0.20e2 / 0.3e1 * t291 * t183) * t155 - 0.3e1 * t298 * t266))
  vrho_0_ = 0.2e1 * r0 * t306 + 0.2e1 * t161
  t333 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (0.59124162764395035714000000000000000000000000000000e-2 * t170 * t125 * t114 - 0.186726e-2 * t262 * t125 + t123 * t27 * t32 * t134 - 0.373452e-2 * t276 * t125 + (t146 * t27 * t32 * t130 + 0.4e1 * t136 * s0 * t143) * t155 - 0.560178e-2 * t298 * t125))
  vsigma_0_ = 0.2e1 * r0 * t333
  vlapl_0_ = 0.0e0
  t339 = t58 * t27 * t47
  t344 = t64 * t27 * t47
  t350 = t70 * t27 * t47
  t356 = t76 * t27 * t47
  t362 = t82 * t27 * t47
  t367 = -t41 * t27 * t47 * t52 - 0.2e1 * t186 * t339 - 0.3e1 * t193 * t344 - 0.4e1 * t200 * t350 - 0.5e1 * t207 * t356 - 0.6e1 * t214 * t362 - t50 * t339 - 0.2e1 * t56 * t344 - 0.3e1 * t62 * t350 - 0.4e1 * t68 * t356 - 0.5e1 * t74 * t362
  t369 = t88 * t27 * t47
  t375 = t94 * t27 * t47
  t381 = t100 * t27 * t47
  t387 = t106 * t27 * t47
  t393 = t112 * t27 * t47
  t402 = -0.11e2 * t110 * t255 * t27 * t47 - 0.10e2 * t104 * t393 - 0.7e1 * t222 * t369 - 0.8e1 * t229 * t375 - 0.9e1 * t236 * t381 - 0.10e2 * t243 * t387 - 0.11e2 * t250 * t393 - 0.6e1 * t80 * t369 - 0.7e1 * t86 * t375 - 0.8e1 * t92 * t381 - 0.9e1 * t98 * t387
  t405 = t27 * t47
  t428 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t39 * (t367 + t402) - 0.373452e-2 * t262 * t405 + 0.2e1 * t127 * t27 * t47 * t134 - 0.746904e-2 * t276 * t405 + (0.4e1 * t147 * t26 / t18 / t139 + 0.4e1 * t291 * t405) * t155 - 0.1120356e-1 * t298 * t405))
  vtau_0_ = 0.2e1 * r0 * t428
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t22 = 6 ** (0.1e1 / 0.3e1)
  t23 = jnp.pi ** 2
  t24 = t23 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = 0.1e1 / t25
  t28 = 2 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = s0 * t29
  t31 = r0 ** 2
  t33 = 0.1e1 / t19 / t31
  t34 = t30 * t33
  t37 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t22 * t26 * t34
  t40 = 0.18040e1 - 0.64641600e0 / t37
  t42 = params.a[1]
  t43 = t22 ** 2
  t44 = t43 * t25
  t45 = 0.3e1 / 0.10e2 * t44
  t46 = tau0 * t29
  t48 = 0.1e1 / t19 / r0
  t49 = t46 * t48
  t50 = t45 - t49
  t51 = t42 * t50
  t52 = t45 + t49
  t53 = 0.1e1 / t52
  t55 = params.a[2]
  t56 = t50 ** 2
  t57 = t55 * t56
  t58 = t52 ** 2
  t59 = 0.1e1 / t58
  t61 = params.a[3]
  t62 = t56 * t50
  t63 = t61 * t62
  t64 = t58 * t52
  t65 = 0.1e1 / t64
  t67 = params.a[4]
  t68 = t56 ** 2
  t69 = t67 * t68
  t70 = t58 ** 2
  t71 = 0.1e1 / t70
  t73 = params.a[5]
  t74 = t68 * t50
  t75 = t73 * t74
  t76 = t70 * t52
  t77 = 0.1e1 / t76
  t79 = params.a[6]
  t80 = t68 * t56
  t81 = t79 * t80
  t83 = 0.1e1 / t70 / t58
  t85 = params.a[7]
  t86 = t68 * t62
  t87 = t85 * t86
  t89 = 0.1e1 / t70 / t64
  t91 = params.a[8]
  t92 = t68 ** 2
  t93 = t91 * t92
  t94 = t70 ** 2
  t95 = 0.1e1 / t94
  t97 = params.a[9]
  t98 = t92 * t50
  t99 = t97 * t98
  t101 = 0.1e1 / t94 / t52
  t103 = params.a[10]
  t104 = t92 * t56
  t105 = t103 * t104
  t107 = 0.1e1 / t94 / t58
  t109 = params.a[11]
  t111 = t109 * t92 * t62
  t113 = 0.1e1 / t94 / t64
  t115 = t99 * t101 + t105 * t107 + t111 * t113 + t51 * t53 + t57 * t59 + t63 * t65 + t69 * t71 + t75 * t77 + t81 * t83 + t87 * t89 + t93 * t95 + params.a[0]
  t117 = params.d[0]
  t121 = 0.1e1 + 0.186726e-2 * t34 + 0.373452e-2 * t49 - 0.11203560000000000000000000000000000000000000000000e-2 * t44
  t125 = params.d[1] * s0
  t126 = t29 * t33
  t128 = params.d[2]
  t131 = 0.2e1 * t49 - 0.3e1 / 0.5e1 * t44
  t133 = t125 * t126 + t128 * t131
  t134 = t121 ** 2
  t135 = 0.1e1 / t134
  t138 = s0 ** 2
  t139 = params.d[3] * t138
  t140 = t31 ** 2
  t143 = 0.1e1 / t18 / t140 / r0
  t144 = t28 * t143
  t148 = params.d[4] * s0
  t151 = params.d[5]
  t152 = t131 ** 2
  t154 = t148 * t126 * t131 + 0.2e1 * t139 * t144 + t151 * t152
  t156 = 0.1e1 / t134 / t121
  t158 = t40 * t115 + t117 / t121 + t133 * t135 + t154 * t156
  t162 = t17 * t18
  t163 = t37 ** 2
  t166 = 0.1e1 / t163 * t22 * t26
  t167 = t31 * r0
  t169 = 0.1e1 / t19 / t167
  t174 = t42 * tau0
  t178 = t51 * t59
  t179 = t46 * t33
  t182 = t55 * t50
  t183 = t182 * t59
  t186 = t57 * t65
  t189 = t61 * t56
  t190 = t189 * t65
  t193 = t63 * t71
  t196 = t67 * t62
  t197 = t196 * t71
  t200 = t69 * t77
  t203 = t73 * t68
  t204 = t203 * t77
  t207 = t75 * t83
  t210 = t79 * t74
  t211 = t210 * t83
  t214 = 0.5e1 / 0.3e1 * t174 * t126 * t53 + 0.5e1 / 0.3e1 * t178 * t179 + 0.10e2 / 0.3e1 * t183 * t179 + 0.10e2 / 0.3e1 * t186 * t179 + 0.5e1 * t190 * t179 + 0.5e1 * t193 * t179 + 0.20e2 / 0.3e1 * t197 * t179 + 0.20e2 / 0.3e1 * t200 * t179 + 0.25e2 / 0.3e1 * t204 * t179 + 0.25e2 / 0.3e1 * t207 * t179 + 0.10e2 * t211 * t179
  t215 = t81 * t89
  t218 = t85 * t80
  t219 = t218 * t89
  t222 = t87 * t95
  t225 = t91 * t86
  t226 = t225 * t95
  t229 = t93 * t101
  t232 = t97 * t92
  t233 = t232 * t101
  t236 = t99 * t107
  t239 = t103 * t98
  t240 = t239 * t107
  t243 = t105 * t113
  t246 = t109 * t104
  t247 = t246 * t113
  t251 = 0.1e1 / t94 / t70
  t252 = t111 * t251
  t255 = 0.10e2 * t215 * t179 + 0.35e2 / 0.3e1 * t219 * t179 + 0.35e2 / 0.3e1 * t222 * t179 + 0.40e2 / 0.3e1 * t226 * t179 + 0.40e2 / 0.3e1 * t229 * t179 + 0.15e2 * t233 * t179 + 0.15e2 * t236 * t179 + 0.50e2 / 0.3e1 * t240 * t179 + 0.50e2 / 0.3e1 * t243 * t179 + 0.55e2 / 0.3e1 * t247 * t179 + 0.55e2 / 0.3e1 * t252 * t179
  t256 = t214 + t255
  t258 = t117 * t135
  t262 = -0.49793600000000000000000000000000000000000000000000e-2 * t30 * t169 - 0.62242000000000000000000000000000000000000000000000e-2 * t179
  t264 = t29 * t169
  t267 = t128 * tau0
  t270 = -0.8e1 / 0.3e1 * t125 * t264 - 0.10e2 / 0.3e1 * t267 * t126
  t272 = t133 * t156
  t278 = t28 / t18 / t140 / t31
  t287 = t151 * t131
  t290 = -0.32e2 / 0.3e1 * t139 * t278 - 0.8e1 / 0.3e1 * t148 * t264 * t131 - 0.20e2 / 0.3e1 * t148 * t144 * tau0 - 0.20e2 / 0.3e1 * t287 * t179
  t292 = t134 ** 2
  t293 = 0.1e1 / t292
  t294 = t154 * t293
  t297 = -0.15766443403838676190400000000000000000000000000001e-1 * t166 * t30 * t169 * t115 + t40 * t256 - t258 * t262 + t270 * t135 - 0.2e1 * t272 * t262 + t290 * t156 - 0.3e1 * t294 * t262
  t302 = f.my_piecewise3(t2, 0, -t6 * t21 * t158 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t162 * t297)
  t320 = 0.1e1 / t18 / t140 / t167
  t326 = 0.1e1 / t19 / t140
  t335 = tau0 ** 2
  t337 = t144 * t59
  t348 = t335 * t28 * t143
  t381 = 0.100e3 / 0.9e1 * t42 * t335 * t337 + 0.100e3 / 0.9e1 * t55 * t335 * t337 - 0.40e2 / 0.9e1 * t174 * t264 * t53 + 0.100e3 / 0.3e1 * t57 * t71 * t348 + 0.100e3 / 0.3e1 * t61 * t50 * t65 * t348 + 0.100e3 * t189 * t71 * t348 + 0.200e3 / 0.3e1 * t63 * t77 * t348 + 0.200e3 / 0.3e1 * t67 * t56 * t71 * t348 + 0.1600e4 / 0.9e1 * t196 * t77 * t348 + 0.1000e4 / 0.9e1 * t69 * t83 * t348 + 0.1000e4 / 0.9e1 * t73 * t62 * t77 * t348 + 0.2500e4 / 0.9e1 * t203 * t83 * t348 + 0.500e3 / 0.3e1 * t75 * t89 * t348
  t429 = 0.500e3 / 0.3e1 * t79 * t68 * t83 * t348 + 0.400e3 * t210 * t89 * t348 + 0.700e3 / 0.3e1 * t81 * t95 * t348 + 0.700e3 / 0.3e1 * t85 * t74 * t89 * t348 + 0.4900e4 / 0.9e1 * t218 * t95 * t348 + 0.2800e4 / 0.9e1 * t87 * t101 * t348 + 0.2800e4 / 0.9e1 * t91 * t80 * t95 * t348 + 0.6400e4 / 0.9e1 * t225 * t101 * t348 + 0.400e3 * t93 * t107 * t348 + 0.400e3 * t97 * t86 * t101 * t348 + 0.900e3 * t232 * t107 * t348 + 0.500e3 * t99 * t113 * t348 + 0.500e3 * t103 * t92 * t107 * t348 + 0.10000e5 / 0.9e1 * t239 * t113 * t348
  t446 = t46 * t169
  t465 = 0.5500e4 / 0.9e1 * t105 * t251 * t348 + 0.5500e4 / 0.9e1 * t109 * t98 * t113 * t348 + 0.12100e5 / 0.9e1 * t246 * t251 * t348 + 0.2200e4 / 0.3e1 * t111 / t94 / t76 * t348 - 0.40e2 * t236 * t446 - 0.400e3 / 0.9e1 * t240 * t446 - 0.400e3 / 0.9e1 * t243 * t446 - 0.440e3 / 0.9e1 * t247 * t446 - 0.440e3 / 0.9e1 * t252 * t446 - 0.200e3 / 0.9e1 * t207 * t446 - 0.80e2 / 0.3e1 * t211 * t446 - 0.80e2 / 0.3e1 * t215 * t446 - 0.280e3 / 0.9e1 * t219 * t446
  t496 = -0.280e3 / 0.9e1 * t222 * t446 - 0.320e3 / 0.9e1 * t226 * t446 - 0.320e3 / 0.9e1 * t229 * t446 - 0.40e2 * t233 * t446 - 0.40e2 / 0.9e1 * t178 * t446 - 0.80e2 / 0.9e1 * t183 * t446 - 0.80e2 / 0.9e1 * t186 * t446 - 0.40e2 / 0.3e1 * t190 * t446 - 0.40e2 / 0.3e1 * t193 * t446 - 0.160e3 / 0.9e1 * t197 * t446 - 0.160e3 / 0.9e1 * t200 * t446 - 0.200e3 / 0.9e1 * t204 * t446 + 0.100e3 / 0.9e1 * t51 * t65 * t348 + 0.400e3 / 0.9e1 * t182 * t65 * t348
  t501 = t262 ** 2
  t507 = 0.18257653333333333333333333333333333333333333333333e-1 * t30 * t326 + 0.16597866666666666666666666666666666666666666666667e-1 * t446
  t509 = t29 * t326
  t550 = -0.15382090641719765710531538923216248177777777777779e-2 / t163 / t37 * t43 / t24 / t23 * t138 * t28 * t320 * t115 + 0.57810292480741812698133333333333333333333333333337e-1 * t166 * t30 * t326 * t115 - 0.31532886807677352380800000000000000000000000000002e-1 * t166 * t30 * t169 * t256 + t40 * (t381 + t429 + t465 + t496) + 0.2e1 * t117 * t156 * t501 - t258 * t507 + (0.88e2 / 0.9e1 * t125 * t509 + 0.80e2 / 0.9e1 * t267 * t264) * t135 - 0.4e1 * t270 * t156 * t262 + 0.6e1 * t133 * t293 * t501 - 0.2e1 * t272 * t507 + (0.608e3 / 0.9e1 * t139 * t28 * t320 + 0.88e2 / 0.9e1 * t148 * t509 * t131 + 0.160e3 / 0.3e1 * t148 * t278 * tau0 + 0.400e3 / 0.9e1 * t151 * t335 * t144 + 0.160e3 / 0.9e1 * t287 * t446) * t156 - 0.6e1 * t290 * t293 * t262 + 0.12e2 * t154 / t292 / t121 * t501 - 0.3e1 * t294 * t507
  t555 = f.my_piecewise3(t2, 0, t6 * t17 * t48 * t158 / 0.12e2 - t6 * t21 * t297 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t162 * t550)
  v2rho2_0_ = 0.2e1 * r0 * t555 + 0.4e1 * t302
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = 0.1e1 / t19 / r0
  t22 = t17 * t21
  t23 = 6 ** (0.1e1 / 0.3e1)
  t24 = jnp.pi ** 2
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = 0.1e1 / t26
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = s0 * t30
  t32 = r0 ** 2
  t34 = 0.1e1 / t19 / t32
  t35 = t31 * t34
  t38 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t23 * t27 * t35
  t41 = 0.18040e1 - 0.64641600e0 / t38
  t43 = params.a[1]
  t44 = t23 ** 2
  t45 = t44 * t26
  t46 = 0.3e1 / 0.10e2 * t45
  t47 = tau0 * t30
  t48 = t47 * t21
  t49 = t46 - t48
  t50 = t43 * t49
  t51 = t46 + t48
  t52 = 0.1e1 / t51
  t54 = params.a[2]
  t55 = t49 ** 2
  t56 = t54 * t55
  t57 = t51 ** 2
  t58 = 0.1e1 / t57
  t60 = params.a[3]
  t61 = t55 * t49
  t62 = t60 * t61
  t63 = t57 * t51
  t64 = 0.1e1 / t63
  t66 = params.a[4]
  t67 = t55 ** 2
  t68 = t66 * t67
  t69 = t57 ** 2
  t70 = 0.1e1 / t69
  t72 = params.a[5]
  t73 = t67 * t49
  t74 = t72 * t73
  t75 = t69 * t51
  t76 = 0.1e1 / t75
  t78 = params.a[6]
  t79 = t67 * t55
  t80 = t78 * t79
  t81 = t69 * t57
  t82 = 0.1e1 / t81
  t84 = params.a[7]
  t85 = t67 * t61
  t86 = t84 * t85
  t88 = 0.1e1 / t69 / t63
  t90 = params.a[8]
  t91 = t67 ** 2
  t92 = t90 * t91
  t93 = t69 ** 2
  t94 = 0.1e1 / t93
  t96 = params.a[9]
  t97 = t91 * t49
  t98 = t96 * t97
  t100 = 0.1e1 / t93 / t51
  t102 = params.a[10]
  t103 = t91 * t55
  t104 = t102 * t103
  t106 = 0.1e1 / t93 / t57
  t108 = params.a[11]
  t110 = t108 * t91 * t61
  t112 = 0.1e1 / t93 / t63
  t114 = t98 * t100 + t104 * t106 + t110 * t112 + t50 * t52 + t56 * t58 + t62 * t64 + t68 * t70 + t74 * t76 + t80 * t82 + t86 * t88 + t92 * t94 + params.a[0]
  t116 = params.d[0]
  t120 = 0.1e1 + 0.186726e-2 * t35 + 0.373452e-2 * t48 - 0.11203560000000000000000000000000000000000000000000e-2 * t45
  t124 = params.d[1] * s0
  t125 = t30 * t34
  t127 = params.d[2]
  t130 = 0.2e1 * t48 - 0.3e1 / 0.5e1 * t45
  t132 = t124 * t125 + t127 * t130
  t133 = t120 ** 2
  t134 = 0.1e1 / t133
  t137 = s0 ** 2
  t138 = params.d[3] * t137
  t139 = t32 ** 2
  t140 = t139 * r0
  t142 = 0.1e1 / t18 / t140
  t143 = t29 * t142
  t147 = params.d[4] * s0
  t150 = params.d[5]
  t151 = t130 ** 2
  t153 = t147 * t125 * t130 + 0.2e1 * t138 * t143 + t150 * t151
  t155 = 0.1e1 / t133 / t120
  t157 = t41 * t114 + t116 / t120 + t132 * t134 + t153 * t155
  t162 = t17 / t19
  t163 = t38 ** 2
  t166 = 0.1e1 / t163 * t23 * t27
  t167 = t32 * r0
  t169 = 0.1e1 / t19 / t167
  t174 = t43 * tau0
  t178 = t50 * t58
  t179 = t47 * t34
  t182 = t54 * t49
  t183 = t182 * t58
  t186 = t56 * t64
  t189 = t60 * t55
  t190 = t189 * t64
  t193 = t62 * t70
  t196 = t66 * t61
  t197 = t196 * t70
  t200 = t68 * t76
  t203 = t72 * t67
  t204 = t203 * t76
  t207 = t74 * t82
  t210 = t78 * t73
  t211 = t210 * t82
  t214 = 0.5e1 / 0.3e1 * t174 * t125 * t52 + 0.5e1 / 0.3e1 * t178 * t179 + 0.10e2 / 0.3e1 * t183 * t179 + 0.10e2 / 0.3e1 * t186 * t179 + 0.5e1 * t190 * t179 + 0.5e1 * t193 * t179 + 0.20e2 / 0.3e1 * t197 * t179 + 0.20e2 / 0.3e1 * t200 * t179 + 0.25e2 / 0.3e1 * t204 * t179 + 0.25e2 / 0.3e1 * t207 * t179 + 0.10e2 * t211 * t179
  t215 = t80 * t88
  t218 = t84 * t79
  t219 = t218 * t88
  t222 = t86 * t94
  t225 = t90 * t85
  t226 = t225 * t94
  t229 = t92 * t100
  t232 = t96 * t91
  t233 = t232 * t100
  t236 = t98 * t106
  t239 = t102 * t97
  t240 = t239 * t106
  t243 = t104 * t112
  t246 = t108 * t103
  t247 = t246 * t112
  t251 = 0.1e1 / t93 / t69
  t252 = t110 * t251
  t255 = 0.10e2 * t215 * t179 + 0.35e2 / 0.3e1 * t219 * t179 + 0.35e2 / 0.3e1 * t222 * t179 + 0.40e2 / 0.3e1 * t226 * t179 + 0.40e2 / 0.3e1 * t229 * t179 + 0.15e2 * t233 * t179 + 0.15e2 * t236 * t179 + 0.50e2 / 0.3e1 * t240 * t179 + 0.50e2 / 0.3e1 * t243 * t179 + 0.55e2 / 0.3e1 * t247 * t179 + 0.55e2 / 0.3e1 * t252 * t179
  t256 = t214 + t255
  t258 = t116 * t134
  t262 = -0.49793600000000000000000000000000000000000000000000e-2 * t31 * t169 - 0.62242000000000000000000000000000000000000000000000e-2 * t179
  t264 = t30 * t169
  t267 = t127 * tau0
  t270 = -0.8e1 / 0.3e1 * t124 * t264 - 0.10e2 / 0.3e1 * t267 * t125
  t272 = t132 * t155
  t277 = 0.1e1 / t18 / t139 / t32
  t278 = t29 * t277
  t287 = t150 * t130
  t290 = -0.32e2 / 0.3e1 * t138 * t278 - 0.8e1 / 0.3e1 * t147 * t264 * t130 - 0.20e2 / 0.3e1 * t147 * t143 * tau0 - 0.20e2 / 0.3e1 * t287 * t179
  t292 = t133 ** 2
  t293 = 0.1e1 / t292
  t294 = t153 * t293
  t297 = -0.15766443403838676190400000000000000000000000000001e-1 * t166 * t31 * t169 * t114 + t41 * t256 - t258 * t262 + t270 * t134 - 0.2e1 * t272 * t262 + t290 * t155 - 0.3e1 * t294 * t262
  t301 = t17 * t18
  t307 = 0.1e1 / t163 / t38 * t44 / t25 / t24
  t308 = t137 * t29
  t311 = 0.1e1 / t18 / t139 / t167
  t317 = 0.1e1 / t19 / t139
  t326 = tau0 ** 2
  t327 = t43 * t326
  t328 = t143 * t58
  t331 = t54 * t326
  t337 = t50 * t64
  t338 = t326 * t29
  t339 = t338 * t142
  t342 = t182 * t64
  t345 = t56 * t70
  t348 = t60 * t49
  t349 = t348 * t64
  t352 = t189 * t70
  t355 = t62 * t76
  t358 = t66 * t55
  t359 = t358 * t70
  t362 = t196 * t76
  t365 = t68 * t82
  t368 = t72 * t61
  t369 = t368 * t76
  t372 = 0.100e3 / 0.9e1 * t327 * t328 + 0.100e3 / 0.9e1 * t331 * t328 - 0.40e2 / 0.9e1 * t174 * t264 * t52 + 0.100e3 / 0.9e1 * t337 * t339 + 0.400e3 / 0.9e1 * t342 * t339 + 0.100e3 / 0.3e1 * t345 * t339 + 0.100e3 / 0.3e1 * t349 * t339 + 0.100e3 * t352 * t339 + 0.200e3 / 0.3e1 * t355 * t339 + 0.200e3 / 0.3e1 * t359 * t339 + 0.1600e4 / 0.9e1 * t362 * t339 + 0.1000e4 / 0.9e1 * t365 * t339 + 0.1000e4 / 0.9e1 * t369 * t339
  t373 = t203 * t82
  t376 = t74 * t88
  t379 = t78 * t67
  t380 = t379 * t82
  t383 = t210 * t88
  t386 = t80 * t94
  t389 = t84 * t73
  t390 = t389 * t88
  t393 = t218 * t94
  t396 = t86 * t100
  t399 = t90 * t79
  t400 = t399 * t94
  t403 = t225 * t100
  t406 = t47 * t169
  t411 = t92 * t106
  t414 = t96 * t85
  t415 = t414 * t100
  t418 = 0.2500e4 / 0.9e1 * t373 * t339 + 0.500e3 / 0.3e1 * t376 * t339 + 0.500e3 / 0.3e1 * t380 * t339 + 0.400e3 * t383 * t339 + 0.700e3 / 0.3e1 * t386 * t339 + 0.700e3 / 0.3e1 * t390 * t339 + 0.4900e4 / 0.9e1 * t393 * t339 + 0.2800e4 / 0.9e1 * t396 * t339 + 0.2800e4 / 0.9e1 * t400 * t339 + 0.6400e4 / 0.9e1 * t403 * t339 - 0.440e3 / 0.9e1 * t252 * t406 - 0.280e3 / 0.9e1 * t219 * t406 + 0.400e3 * t411 * t339 + 0.400e3 * t415 * t339
  t420 = t232 * t106
  t423 = t98 * t112
  t426 = t102 * t91
  t427 = t426 * t106
  t430 = t239 * t112
  t433 = t104 * t251
  t436 = t108 * t97
  t437 = t436 * t112
  t440 = t246 * t251
  t444 = 0.1e1 / t93 / t75
  t445 = t110 * t444
  t458 = 0.900e3 * t420 * t339 + 0.500e3 * t423 * t339 + 0.500e3 * t427 * t339 + 0.10000e5 / 0.9e1 * t430 * t339 + 0.5500e4 / 0.9e1 * t433 * t339 + 0.5500e4 / 0.9e1 * t437 * t339 + 0.12100e5 / 0.9e1 * t440 * t339 + 0.2200e4 / 0.3e1 * t445 * t339 - 0.280e3 / 0.9e1 * t222 * t406 - 0.320e3 / 0.9e1 * t226 * t406 - 0.320e3 / 0.9e1 * t229 * t406 - 0.40e2 * t233 * t406 - 0.40e2 * t236 * t406
  t487 = -0.400e3 / 0.9e1 * t240 * t406 - 0.400e3 / 0.9e1 * t243 * t406 - 0.440e3 / 0.9e1 * t247 * t406 - 0.40e2 / 0.3e1 * t190 * t406 - 0.40e2 / 0.3e1 * t193 * t406 - 0.160e3 / 0.9e1 * t197 * t406 - 0.160e3 / 0.9e1 * t200 * t406 - 0.200e3 / 0.9e1 * t204 * t406 - 0.200e3 / 0.9e1 * t207 * t406 - 0.80e2 / 0.3e1 * t211 * t406 - 0.80e2 / 0.3e1 * t215 * t406 - 0.40e2 / 0.9e1 * t178 * t406 - 0.80e2 / 0.9e1 * t183 * t406 - 0.80e2 / 0.9e1 * t186 * t406
  t489 = t372 + t418 + t458 + t487
  t491 = t116 * t155
  t492 = t262 ** 2
  t498 = 0.18257653333333333333333333333333333333333333333333e-1 * t31 * t317 + 0.16597866666666666666666666666666666666666666666667e-1 * t406
  t500 = t30 * t317
  t505 = 0.88e2 / 0.9e1 * t124 * t500 + 0.80e2 / 0.9e1 * t267 * t264
  t507 = t270 * t155
  t510 = t132 * t293
  t515 = t29 * t311
  t524 = t150 * t326
  t529 = 0.608e3 / 0.9e1 * t138 * t515 + 0.88e2 / 0.9e1 * t147 * t500 * t130 + 0.160e3 / 0.3e1 * t147 * t278 * tau0 + 0.400e3 / 0.9e1 * t524 * t143 + 0.160e3 / 0.9e1 * t287 * t406
  t531 = t290 * t293
  t535 = 0.1e1 / t292 / t120
  t536 = t153 * t535
  t541 = -0.15382090641719765710531538923216248177777777777779e-2 * t307 * t308 * t311 * t114 + 0.57810292480741812698133333333333333333333333333337e-1 * t166 * t31 * t317 * t114 - 0.31532886807677352380800000000000000000000000000002e-1 * t166 * t31 * t169 * t256 + t41 * t489 + 0.2e1 * t491 * t492 - t258 * t498 + t505 * t134 - 0.4e1 * t507 * t262 + 0.6e1 * t510 * t492 - 0.2e1 * t272 * t498 + t529 * t155 - 0.6e1 * t531 * t262 + 0.12e2 * t536 * t492 - 0.3e1 * t294 * t498
  t546 = f.my_piecewise3(t2, 0, t6 * t22 * t157 / 0.12e2 - t6 * t162 * t297 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t301 * t541)
  t576 = 0.1e1 / t19 / t140
  t579 = t47 * t317
  t581 = -0.85202382222222222222222222222222222222222222222221e-1 * t31 * t576 - 0.60858844444444444444444444444444444444444444444446e-1 * t579
  t592 = t139 ** 2
  t594 = 0.1e1 / t18 / t592
  t603 = -0.47299330211516028571200000000000000000000000000003e-1 * t166 * t31 * t169 * t489 - 0.46146271925159297131594616769648744533333333333338e-2 * t307 * t308 * t311 * t256 + 0.17343087744222543809440000000000000000000000000001e0 * t166 * t31 * t317 * t256 - 0.9e1 * t529 * t293 * t262 - 0.9e1 * t531 * t498 - 0.3e1 * t294 * t581 - t258 * t581 - 0.6e1 * t505 * t155 * t262 - 0.6e1 * t507 * t498 - 0.2e1 * t272 * t581 + 0.16920299705891742281584692815537872995555555555557e-1 * t307 * t308 * t594 * t114 - 0.26978136491012845925795555555555555555555555555557e0 * t166 * t31 * t576 * t114
  t607 = t30 * t576
  t628 = t326 * tau0
  t630 = 0.1e1 / t592
  t635 = t70 * t628 * t630
  t641 = t76 * t628 * t630
  t649 = t82 * t628 * t630
  t660 = t88 * t628 * t630
  t663 = 0.286000e6 / 0.9e1 * t110 / t93 / t81 * t628 * t630 + 0.1000e4 / 0.9e1 * t50 * t635 + 0.2000e4 / 0.3e1 * t182 * t635 + 0.4000e4 / 0.9e1 * t56 * t641 + 0.1000e4 * t348 * t635 + 0.2000e4 * t189 * t641 + 0.10000e5 / 0.9e1 * t62 * t649 + 0.4000e4 / 0.9e1 * t66 * t49 * t635 + 0.8000e4 / 0.3e1 * t358 * t641 + 0.40000e5 / 0.9e1 * t196 * t649 + 0.20000e5 / 0.9e1 * t68 * t660
  t672 = t94 * t628 * t630
  t683 = t100 * t628 * t630
  t694 = t106 * t628 * t630
  t697 = 0.10000e5 / 0.9e1 * t72 * t55 * t641 + 0.50000e5 / 0.9e1 * t368 * t649 + 0.25000e5 / 0.3e1 * t203 * t660 + 0.35000e5 / 0.9e1 * t74 * t672 + 0.20000e5 / 0.9e1 * t78 * t61 * t649 + 0.10000e5 * t379 * t660 + 0.14000e5 * t210 * t672 + 0.56000e5 / 0.9e1 * t80 * t683 + 0.35000e5 / 0.9e1 * t84 * t67 * t660 + 0.49000e5 / 0.3e1 * t389 * t672 + 0.196000e6 / 0.9e1 * t218 * t683 + 0.28000e5 / 0.3e1 * t86 * t694
  t702 = t278 * t58
  t711 = t630 * t64
  t725 = t112 * t628 * t630
  t733 = 0.56000e5 / 0.9e1 * t90 * t73 * t672 - 0.800e3 / 0.9e1 * t327 * t702 - 0.800e3 / 0.9e1 * t331 * t702 + 0.440e3 / 0.27e2 * t174 * t500 * t52 + 0.1000e4 / 0.9e1 * t43 * t628 * t711 + 0.2000e4 / 0.9e1 * t54 * t628 * t711 + 0.1000e4 / 0.9e1 * t60 * t628 * t711 + 0.224000e6 / 0.9e1 * t399 * t683 + 0.32000e5 * t225 * t694 + 0.40000e5 / 0.3e1 * t92 * t725 + 0.28000e5 / 0.3e1 * t96 * t79 * t683 + 0.36000e5 * t414 * t694
  t737 = t251 * t628 * t630
  t748 = t444 * t628 * t630
  t764 = 0.45000e5 * t232 * t725 + 0.55000e5 / 0.3e1 * t98 * t737 + 0.40000e5 / 0.3e1 * t102 * t85 * t694 + 0.50000e5 * t426 * t725 + 0.550000e6 / 0.9e1 * t239 * t737 + 0.220000e6 / 0.9e1 * t104 * t748 + 0.55000e5 / 0.3e1 * t108 * t91 * t725 + 0.605000e6 / 0.9e1 * t436 * t737 + 0.242000e6 / 0.3e1 * t246 * t748 + 0.3080e4 / 0.27e2 * t219 * t579 + 0.3080e4 / 0.27e2 * t222 * t579 + 0.3520e4 / 0.27e2 * t226 * t579
  t771 = t338 * t277
  t792 = 0.3520e4 / 0.27e2 * t229 * t579 + 0.440e3 / 0.3e1 * t233 * t579 - 0.3200e4 / 0.9e1 * t342 * t771 - 0.800e3 / 0.3e1 * t345 * t771 - 0.1600e4 / 0.3e1 * t355 * t771 - 0.1600e4 / 0.3e1 * t359 * t771 - 0.12800e5 / 0.9e1 * t362 * t771 - 0.8000e4 / 0.9e1 * t365 * t771 - 0.8000e4 / 0.9e1 * t369 * t771 - 0.20000e5 / 0.9e1 * t373 * t771 - 0.4000e4 / 0.3e1 * t376 * t771 - 0.4000e4 / 0.3e1 * t380 * t771
  t817 = -0.3200e4 * t383 * t771 - 0.5600e4 / 0.3e1 * t386 * t771 - 0.800e3 / 0.9e1 * t337 * t771 - 0.22400e5 / 0.9e1 * t400 * t771 - 0.51200e5 / 0.9e1 * t403 * t771 - 0.3200e4 * t411 * t771 - 0.3200e4 * t415 * t771 - 0.7200e4 * t420 * t771 - 0.4000e4 * t423 * t771 - 0.4000e4 * t427 * t771 - 0.80000e5 / 0.9e1 * t430 * t771 - 0.44000e5 / 0.9e1 * t433 * t771
  t843 = -0.44000e5 / 0.9e1 * t437 * t771 - 0.800e3 / 0.3e1 * t349 * t771 - 0.800e3 * t352 * t771 - 0.96800e5 / 0.9e1 * t440 * t771 - 0.17600e5 / 0.3e1 * t445 * t771 - 0.5600e4 / 0.3e1 * t390 * t771 - 0.39200e5 / 0.9e1 * t393 * t771 - 0.22400e5 / 0.9e1 * t396 * t771 + 0.2200e4 / 0.27e2 * t204 * t579 + 0.2200e4 / 0.27e2 * t207 * t579 + 0.880e3 / 0.9e1 * t211 * t579 + 0.880e3 / 0.9e1 * t215 * t579
  t868 = 0.440e3 / 0.27e2 * t178 * t579 + 0.880e3 / 0.27e2 * t183 * t579 + 0.880e3 / 0.27e2 * t186 * t579 + 0.440e3 / 0.3e1 * t236 * t579 + 0.4400e4 / 0.27e2 * t240 * t579 + 0.4400e4 / 0.27e2 * t243 * t579 + 0.4840e4 / 0.27e2 * t247 * t579 + 0.440e3 / 0.9e1 * t190 * t579 + 0.440e3 / 0.9e1 * t193 * t579 + 0.1760e4 / 0.27e2 * t197 * t579 + 0.1760e4 / 0.27e2 * t200 * t579 + 0.4840e4 / 0.27e2 * t252 * t579
  t876 = t492 * t262
  t879 = t262 * t498
  t898 = t163 ** 2
  t900 = t24 ** 2
  t910 = (-0.13376e5 / 0.27e2 * t138 * t29 * t594 - 0.1232e4 / 0.27e2 * t147 * t607 * t130 - 0.10880e5 / 0.27e2 * t147 * t515 * tau0 - 0.3200e4 / 0.9e1 * t524 * t278 - 0.1760e4 / 0.27e2 * t287 * t579) * t155 + (-0.1232e4 / 0.27e2 * t124 * t607 - 0.880e3 / 0.27e2 * t267 * t500) * t134 + t41 * (t663 + t697 + t733 + t764 + t792 + t817 + t843 + t868) - 0.60e2 * t153 / t292 / t133 * t876 + 0.36e2 * t536 * t879 - 0.6e1 * t116 * t293 * t876 + 0.6e1 * t491 * t879 + 0.18e2 * t270 * t293 * t492 - 0.24e2 * t132 * t535 * t876 + 0.18e2 * t510 * t879 + 0.36e2 * t290 * t535 * t492 - 0.13506396833113790924554500662166945859217394563466e-2 / t898 / t900 * t137 * s0 / t592 / t167 * t114
  t916 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t34 * t157 + t6 * t22 * t297 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t162 * t541 - 0.3e1 / 0.8e1 * t6 * t301 * (t603 + t910))
  v3rho3_0_ = 0.2e1 * r0 * t916 + 0.6e1 * t546

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t23 = t17 * t22
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = 0.1e1 / t27
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = s0 * t31
  t33 = t32 * t22
  t36 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t24 * t28 * t33
  t39 = 0.18040e1 - 0.64641600e0 / t36
  t41 = params.a[1]
  t42 = t24 ** 2
  t43 = t42 * t27
  t44 = 0.3e1 / 0.10e2 * t43
  t45 = tau0 * t31
  t47 = 0.1e1 / t20 / r0
  t48 = t45 * t47
  t49 = t44 - t48
  t50 = t41 * t49
  t51 = t44 + t48
  t52 = 0.1e1 / t51
  t54 = params.a[2]
  t55 = t49 ** 2
  t56 = t54 * t55
  t57 = t51 ** 2
  t58 = 0.1e1 / t57
  t60 = params.a[3]
  t61 = t55 * t49
  t62 = t60 * t61
  t63 = t57 * t51
  t64 = 0.1e1 / t63
  t66 = params.a[4]
  t67 = t55 ** 2
  t68 = t66 * t67
  t69 = t57 ** 2
  t70 = 0.1e1 / t69
  t72 = params.a[5]
  t73 = t67 * t49
  t74 = t72 * t73
  t75 = t69 * t51
  t76 = 0.1e1 / t75
  t78 = params.a[6]
  t79 = t67 * t55
  t80 = t78 * t79
  t81 = t69 * t57
  t82 = 0.1e1 / t81
  t84 = params.a[7]
  t85 = t67 * t61
  t86 = t84 * t85
  t87 = t69 * t63
  t88 = 0.1e1 / t87
  t90 = params.a[8]
  t91 = t67 ** 2
  t92 = t90 * t91
  t93 = t69 ** 2
  t94 = 0.1e1 / t93
  t96 = params.a[9]
  t97 = t91 * t49
  t98 = t96 * t97
  t100 = 0.1e1 / t93 / t51
  t102 = params.a[10]
  t103 = t91 * t55
  t104 = t102 * t103
  t106 = 0.1e1 / t93 / t57
  t108 = params.a[11]
  t110 = t108 * t91 * t61
  t112 = 0.1e1 / t93 / t63
  t114 = t98 * t100 + t104 * t106 + t110 * t112 + t50 * t52 + t56 * t58 + t62 * t64 + t68 * t70 + t74 * t76 + t80 * t82 + t86 * t88 + t92 * t94 + params.a[0]
  t116 = params.d[0]
  t120 = 0.1e1 + 0.186726e-2 * t33 + 0.373452e-2 * t48 - 0.11203560000000000000000000000000000000000000000000e-2 * t43
  t124 = params.d[1] * s0
  t125 = t31 * t22
  t127 = params.d[2]
  t130 = 0.2e1 * t48 - 0.3e1 / 0.5e1 * t43
  t132 = t124 * t125 + t127 * t130
  t133 = t120 ** 2
  t134 = 0.1e1 / t133
  t137 = s0 ** 2
  t138 = params.d[3] * t137
  t139 = t18 ** 2
  t140 = t139 * r0
  t142 = 0.1e1 / t19 / t140
  t143 = t30 * t142
  t147 = params.d[4] * s0
  t150 = params.d[5]
  t151 = t130 ** 2
  t153 = t147 * t125 * t130 + 0.2e1 * t138 * t143 + t150 * t151
  t154 = t133 * t120
  t155 = 0.1e1 / t154
  t157 = t39 * t114 + t116 / t120 + t132 * t134 + t153 * t155
  t161 = t17 * t47
  t162 = t36 ** 2
  t165 = 0.1e1 / t162 * t24 * t28
  t166 = t18 * r0
  t168 = 0.1e1 / t20 / t166
  t173 = t41 * tau0
  t177 = t50 * t58
  t178 = t45 * t22
  t181 = t54 * t49
  t182 = t181 * t58
  t185 = t56 * t64
  t188 = t60 * t55
  t189 = t188 * t64
  t192 = t62 * t70
  t195 = t66 * t61
  t196 = t195 * t70
  t199 = t68 * t76
  t202 = t72 * t67
  t203 = t202 * t76
  t206 = t74 * t82
  t209 = t78 * t73
  t210 = t209 * t82
  t213 = 0.5e1 / 0.3e1 * t173 * t125 * t52 + 0.5e1 / 0.3e1 * t177 * t178 + 0.10e2 / 0.3e1 * t182 * t178 + 0.10e2 / 0.3e1 * t185 * t178 + 0.5e1 * t189 * t178 + 0.5e1 * t192 * t178 + 0.20e2 / 0.3e1 * t196 * t178 + 0.20e2 / 0.3e1 * t199 * t178 + 0.25e2 / 0.3e1 * t203 * t178 + 0.25e2 / 0.3e1 * t206 * t178 + 0.10e2 * t210 * t178
  t214 = t80 * t88
  t217 = t84 * t79
  t218 = t217 * t88
  t221 = t86 * t94
  t224 = t90 * t85
  t225 = t224 * t94
  t228 = t92 * t100
  t231 = t96 * t91
  t232 = t231 * t100
  t235 = t98 * t106
  t238 = t102 * t97
  t239 = t238 * t106
  t242 = t104 * t112
  t245 = t108 * t103
  t246 = t245 * t112
  t250 = 0.1e1 / t93 / t69
  t251 = t110 * t250
  t254 = 0.10e2 * t214 * t178 + 0.35e2 / 0.3e1 * t218 * t178 + 0.35e2 / 0.3e1 * t221 * t178 + 0.40e2 / 0.3e1 * t225 * t178 + 0.40e2 / 0.3e1 * t228 * t178 + 0.15e2 * t232 * t178 + 0.15e2 * t235 * t178 + 0.50e2 / 0.3e1 * t239 * t178 + 0.50e2 / 0.3e1 * t242 * t178 + 0.55e2 / 0.3e1 * t246 * t178 + 0.55e2 / 0.3e1 * t251 * t178
  t255 = t213 + t254
  t257 = t116 * t134
  t261 = -0.49793600000000000000000000000000000000000000000000e-2 * t32 * t168 - 0.62242000000000000000000000000000000000000000000000e-2 * t178
  t263 = t31 * t168
  t266 = t127 * tau0
  t269 = -0.8e1 / 0.3e1 * t124 * t263 - 0.10e2 / 0.3e1 * t266 * t125
  t271 = t132 * t155
  t274 = t139 * t18
  t276 = 0.1e1 / t19 / t274
  t277 = t30 * t276
  t286 = t150 * t130
  t289 = -0.32e2 / 0.3e1 * t138 * t277 - 0.8e1 / 0.3e1 * t147 * t263 * t130 - 0.20e2 / 0.3e1 * t147 * t143 * tau0 - 0.20e2 / 0.3e1 * t286 * t178
  t291 = t133 ** 2
  t292 = 0.1e1 / t291
  t293 = t153 * t292
  t296 = -0.15766443403838676190400000000000000000000000000001e-1 * t165 * t32 * t168 * t114 + t39 * t255 - t257 * t261 + t269 * t134 - 0.2e1 * t271 * t261 + t289 * t155 - 0.3e1 * t293 * t261
  t301 = t17 / t20
  t307 = 0.1e1 / t162 / t36 * t42 / t26 / t25
  t308 = t137 * t30
  t311 = 0.1e1 / t19 / t139 / t166
  t317 = 0.1e1 / t20 / t139
  t326 = t202 * t82
  t327 = tau0 ** 2
  t328 = t327 * t30
  t329 = t328 * t142
  t332 = t74 * t88
  t335 = t78 * t67
  t336 = t335 * t82
  t339 = t209 * t88
  t342 = t80 * t94
  t345 = t84 * t73
  t346 = t345 * t88
  t349 = t217 * t94
  t352 = t86 * t100
  t355 = t90 * t79
  t356 = t355 * t94
  t359 = t224 * t100
  t362 = t92 * t106
  t365 = t96 * t85
  t366 = t365 * t100
  t369 = t231 * t106
  t372 = 0.2500e4 / 0.9e1 * t326 * t329 + 0.500e3 / 0.3e1 * t332 * t329 + 0.500e3 / 0.3e1 * t336 * t329 + 0.400e3 * t339 * t329 + 0.700e3 / 0.3e1 * t342 * t329 + 0.700e3 / 0.3e1 * t346 * t329 + 0.4900e4 / 0.9e1 * t349 * t329 + 0.2800e4 / 0.9e1 * t352 * t329 + 0.2800e4 / 0.9e1 * t356 * t329 + 0.6400e4 / 0.9e1 * t359 * t329 + 0.400e3 * t362 * t329 + 0.400e3 * t366 * t329 + 0.900e3 * t369 * t329
  t373 = t98 * t112
  t376 = t102 * t91
  t377 = t376 * t106
  t380 = t238 * t112
  t383 = t104 * t250
  t386 = t108 * t97
  t387 = t386 * t112
  t390 = t245 * t250
  t394 = 0.1e1 / t93 / t75
  t395 = t110 * t394
  t398 = t45 * t168
  t413 = 0.500e3 * t373 * t329 + 0.500e3 * t377 * t329 + 0.10000e5 / 0.9e1 * t380 * t329 + 0.5500e4 / 0.9e1 * t383 * t329 + 0.5500e4 / 0.9e1 * t387 * t329 + 0.12100e5 / 0.9e1 * t390 * t329 + 0.2200e4 / 0.3e1 * t395 * t329 - 0.440e3 / 0.9e1 * t251 * t398 - 0.280e3 / 0.9e1 * t218 * t398 - 0.280e3 / 0.9e1 * t221 * t398 - 0.320e3 / 0.9e1 * t225 * t398 - 0.320e3 / 0.9e1 * t228 * t398 - 0.40e2 * t232 * t398 - 0.40e2 * t235 * t398
  t429 = t41 * t327
  t430 = t143 * t58
  t433 = t54 * t327
  t445 = -0.400e3 / 0.9e1 * t239 * t398 - 0.400e3 / 0.9e1 * t242 * t398 - 0.440e3 / 0.9e1 * t246 * t398 - 0.40e2 / 0.3e1 * t189 * t398 - 0.40e2 / 0.3e1 * t192 * t398 - 0.160e3 / 0.9e1 * t196 * t398 - 0.160e3 / 0.9e1 * t199 * t398 + 0.100e3 / 0.9e1 * t429 * t430 + 0.100e3 / 0.9e1 * t433 * t430 - 0.40e2 / 0.9e1 * t173 * t263 * t52 - 0.200e3 / 0.9e1 * t203 * t398 - 0.200e3 / 0.9e1 * t206 * t398 - 0.80e2 / 0.3e1 * t210 * t398
  t454 = t50 * t64
  t457 = t181 * t64
  t460 = t56 * t70
  t463 = t60 * t49
  t464 = t463 * t64
  t467 = t188 * t70
  t470 = t62 * t76
  t473 = t66 * t55
  t474 = t473 * t70
  t477 = t195 * t76
  t480 = t68 * t82
  t483 = t72 * t61
  t484 = t483 * t76
  t487 = -0.80e2 / 0.3e1 * t214 * t398 - 0.40e2 / 0.9e1 * t177 * t398 - 0.80e2 / 0.9e1 * t182 * t398 - 0.80e2 / 0.9e1 * t185 * t398 + 0.100e3 / 0.9e1 * t454 * t329 + 0.400e3 / 0.9e1 * t457 * t329 + 0.100e3 / 0.3e1 * t460 * t329 + 0.100e3 / 0.3e1 * t464 * t329 + 0.100e3 * t467 * t329 + 0.200e3 / 0.3e1 * t470 * t329 + 0.200e3 / 0.3e1 * t474 * t329 + 0.1600e4 / 0.9e1 * t477 * t329 + 0.1000e4 / 0.9e1 * t480 * t329 + 0.1000e4 / 0.9e1 * t484 * t329
  t489 = t372 + t413 + t445 + t487
  t491 = t116 * t155
  t492 = t261 ** 2
  t498 = 0.18257653333333333333333333333333333333333333333333e-1 * t32 * t317 + 0.16597866666666666666666666666666666666666666666667e-1 * t398
  t500 = t31 * t317
  t505 = 0.88e2 / 0.9e1 * t124 * t500 + 0.80e2 / 0.9e1 * t266 * t263
  t507 = t269 * t155
  t510 = t132 * t292
  t515 = t30 * t311
  t524 = t150 * t327
  t529 = 0.608e3 / 0.9e1 * t138 * t515 + 0.88e2 / 0.9e1 * t147 * t500 * t130 + 0.160e3 / 0.3e1 * t147 * t277 * tau0 + 0.400e3 / 0.9e1 * t524 * t143 + 0.160e3 / 0.9e1 * t286 * t398
  t531 = t289 * t292
  t535 = 0.1e1 / t291 / t120
  t536 = t153 * t535
  t541 = -0.15382090641719765710531538923216248177777777777779e-2 * t307 * t308 * t311 * t114 + 0.57810292480741812698133333333333333333333333333337e-1 * t165 * t32 * t317 * t114 - 0.31532886807677352380800000000000000000000000000002e-1 * t165 * t32 * t168 * t255 + t39 * t489 + 0.2e1 * t491 * t492 - t257 * t498 + t505 * t134 - 0.4e1 * t507 * t261 + 0.6e1 * t510 * t492 - 0.2e1 * t271 * t498 + t529 * t155 - 0.6e1 * t531 * t261 + 0.12e2 * t536 * t492 - 0.3e1 * t293 * t498
  t545 = t17 * t19
  t561 = 0.1e1 / t20 / t140
  t564 = t45 * t317
  t566 = -0.85202382222222222222222222222222222222222222222221e-1 * t32 * t561 - 0.60858844444444444444444444444444444444444444444446e-1 * t564
  t570 = t505 * t155
  t577 = t529 * t292
  t580 = t139 ** 2
  t582 = 0.1e1 / t19 / t580
  t591 = -0.47299330211516028571200000000000000000000000000003e-1 * t165 * t32 * t168 * t489 - 0.46146271925159297131594616769648744533333333333338e-2 * t307 * t308 * t311 * t255 + 0.17343087744222543809440000000000000000000000000001e0 * t165 * t32 * t317 * t255 - 0.9e1 * t531 * t498 - 0.3e1 * t293 * t566 - t257 * t566 - 0.6e1 * t570 * t261 - 0.6e1 * t507 * t498 - 0.2e1 * t271 * t566 - 0.9e1 * t577 * t261 + 0.16920299705891742281584692815537872995555555555557e-1 * t307 * t308 * t582 * t114 - 0.26978136491012845925795555555555555555555555555557e0 * t165 * t32 * t561 * t114
  t592 = t30 * t582
  t595 = t31 * t561
  t606 = -0.13376e5 / 0.27e2 * t138 * t592 - 0.1232e4 / 0.27e2 * t147 * t595 * t130 - 0.10880e5 / 0.27e2 * t147 * t515 * tau0 - 0.3200e4 / 0.9e1 * t524 * t277 - 0.1760e4 / 0.27e2 * t286 * t564
  t612 = -0.1232e4 / 0.27e2 * t124 * t595 - 0.880e3 / 0.27e2 * t266 * t500
  t614 = t102 * t85
  t615 = t327 * tau0
  t616 = t106 * t615
  t617 = 0.1e1 / t580
  t618 = t616 * t617
  t621 = t112 * t615
  t622 = t621 * t617
  t625 = t250 * t615
  t626 = t625 * t617
  t629 = t394 * t615
  t630 = t629 * t617
  t633 = t108 * t91
  t641 = 0.1e1 / t93 / t81
  t642 = t641 * t615
  t646 = t70 * t615
  t647 = t646 * t617
  t652 = t76 * t615
  t653 = t652 * t617
  t656 = 0.40000e5 / 0.3e1 * t614 * t618 + 0.50000e5 * t376 * t622 + 0.550000e6 / 0.9e1 * t238 * t626 + 0.220000e6 / 0.9e1 * t104 * t630 + 0.55000e5 / 0.3e1 * t633 * t622 + 0.605000e6 / 0.9e1 * t386 * t626 + 0.242000e6 / 0.3e1 * t245 * t630 + 0.286000e6 / 0.9e1 * t110 * t642 * t617 + 0.1000e4 / 0.9e1 * t50 * t647 + 0.2000e4 / 0.3e1 * t181 * t647 + 0.4000e4 / 0.9e1 * t56 * t653
  t661 = t82 * t615
  t662 = t661 * t617
  t665 = t66 * t49
  t672 = t88 * t615
  t673 = t672 * t617
  t676 = t72 * t55
  t683 = t94 * t615
  t684 = t683 * t617
  t687 = t78 * t61
  t690 = 0.1000e4 * t463 * t647 + 0.2000e4 * t188 * t653 + 0.10000e5 / 0.9e1 * t62 * t662 + 0.4000e4 / 0.9e1 * t665 * t647 + 0.8000e4 / 0.3e1 * t473 * t653 + 0.40000e5 / 0.9e1 * t195 * t662 + 0.20000e5 / 0.9e1 * t68 * t673 + 0.10000e5 / 0.9e1 * t676 * t653 + 0.50000e5 / 0.9e1 * t483 * t662 + 0.25000e5 / 0.3e1 * t202 * t673 + 0.35000e5 / 0.9e1 * t74 * t684 + 0.20000e5 / 0.9e1 * t687 * t662
  t696 = t100 * t615
  t697 = t696 * t617
  t700 = t84 * t67
  t709 = t90 * t73
  t716 = t96 * t79
  t721 = 0.10000e5 * t335 * t673 + 0.14000e5 * t209 * t684 + 0.56000e5 / 0.9e1 * t80 * t697 + 0.35000e5 / 0.9e1 * t700 * t673 + 0.49000e5 / 0.3e1 * t345 * t684 + 0.196000e6 / 0.9e1 * t217 * t697 + 0.28000e5 / 0.3e1 * t86 * t618 + 0.56000e5 / 0.9e1 * t709 * t684 + 0.32000e5 * t224 * t618 + 0.40000e5 / 0.3e1 * t92 * t622 + 0.28000e5 / 0.3e1 * t716 * t697 + 0.36000e5 * t365 * t618
  t726 = t328 * t276
  t747 = 0.45000e5 * t231 * t622 + 0.55000e5 / 0.3e1 * t98 * t626 - 0.44000e5 / 0.9e1 * t383 * t726 - 0.44000e5 / 0.9e1 * t387 * t726 - 0.800e3 / 0.3e1 * t464 * t726 - 0.800e3 * t467 * t726 - 0.96800e5 / 0.9e1 * t390 * t726 - 0.17600e5 / 0.3e1 * t395 * t726 - 0.5600e4 / 0.3e1 * t346 * t726 - 0.39200e5 / 0.9e1 * t349 * t726 - 0.22400e5 / 0.9e1 * t352 * t726 + 0.2200e4 / 0.27e2 * t203 * t564
  t774 = 0.2200e4 / 0.27e2 * t206 * t564 + 0.880e3 / 0.9e1 * t210 * t564 + 0.880e3 / 0.9e1 * t214 * t564 + 0.440e3 / 0.27e2 * t177 * t564 + 0.880e3 / 0.27e2 * t182 * t564 + 0.1760e4 / 0.27e2 * t199 * t564 + 0.4840e4 / 0.27e2 * t251 * t564 + 0.3080e4 / 0.27e2 * t218 * t564 + 0.3080e4 / 0.27e2 * t221 * t564 + 0.4840e4 / 0.27e2 * t246 * t564 + 0.440e3 / 0.9e1 * t189 * t564 + 0.440e3 / 0.9e1 * t192 * t564
  t799 = 0.1760e4 / 0.27e2 * t196 * t564 + 0.3520e4 / 0.27e2 * t225 * t564 + 0.3520e4 / 0.27e2 * t228 * t564 + 0.440e3 / 0.3e1 * t232 * t564 - 0.3200e4 / 0.9e1 * t457 * t726 - 0.800e3 / 0.3e1 * t460 * t726 - 0.1600e4 / 0.3e1 * t470 * t726 - 0.1600e4 / 0.3e1 * t474 * t726 - 0.12800e5 / 0.9e1 * t477 * t726 - 0.8000e4 / 0.9e1 * t480 * t726 - 0.8000e4 / 0.9e1 * t484 * t726 - 0.20000e5 / 0.9e1 * t326 * t726
  t825 = -0.4000e4 / 0.3e1 * t332 * t726 - 0.4000e4 / 0.3e1 * t336 * t726 - 0.3200e4 * t339 * t726 - 0.5600e4 / 0.3e1 * t342 * t726 - 0.800e3 / 0.9e1 * t454 * t726 - 0.22400e5 / 0.9e1 * t356 * t726 - 0.51200e5 / 0.9e1 * t359 * t726 - 0.3200e4 * t362 * t726 - 0.3200e4 * t366 * t726 - 0.7200e4 * t369 * t726 - 0.4000e4 * t373 * t726 - 0.4000e4 * t377 * t726
  t836 = t277 * t58
  t846 = t41 * t615
  t847 = t617 * t64
  t850 = t54 * t615
  t853 = t60 * t615
  t856 = -0.80000e5 / 0.9e1 * t380 * t726 + 0.4400e4 / 0.27e2 * t239 * t564 + 0.4400e4 / 0.27e2 * t242 * t564 + 0.880e3 / 0.27e2 * t185 * t564 + 0.440e3 / 0.3e1 * t235 * t564 - 0.800e3 / 0.9e1 * t429 * t836 - 0.800e3 / 0.9e1 * t433 * t836 + 0.440e3 / 0.27e2 * t173 * t500 * t52 + 0.224000e6 / 0.9e1 * t355 * t697 + 0.1000e4 / 0.9e1 * t846 * t847 + 0.2000e4 / 0.9e1 * t850 * t847 + 0.1000e4 / 0.9e1 * t853 * t847
  t859 = t656 + t690 + t721 + t747 + t774 + t799 + t825 + t856
  t862 = 0.1e1 / t291 / t133
  t863 = t153 * t862
  t864 = t492 * t261
  t867 = t261 * t498
  t870 = t116 * t292
  t875 = t269 * t292
  t878 = t132 * t535
  t883 = t289 * t535
  t886 = t162 ** 2
  t888 = t25 ** 2
  t889 = 0.1e1 / t888
  t890 = 0.1e1 / t886 * t889
  t891 = t137 * s0
  t894 = t891 / t580 / t166
  t898 = t606 * t155 + t612 * t134 + t39 * t859 - 0.60e2 * t863 * t864 + 0.36e2 * t536 * t867 - 0.6e1 * t870 * t864 + 0.6e1 * t491 * t867 + 0.18e2 * t875 * t492 - 0.24e2 * t878 * t864 + 0.18e2 * t510 * t867 + 0.36e2 * t883 * t492 - 0.13506396833113790924554500662166945859217394563466e-2 * t890 * t894 * t114
  t899 = t591 + t898
  t904 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t23 * t157 + t6 * t161 * t296 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t301 * t541 - 0.3e1 / 0.8e1 * t6 * t545 * t899)
  t931 = t492 * t498
  t936 = t566 * t261
  t949 = t580 * r0
  t951 = 0.1e1 / t19 / t949
  t956 = 0.1e1 / t20 / t274
  t957 = t31 * t956
  t966 = t45 * t561
  t978 = t327 ** 2
  t981 = 0.1e1 / t20 / t580 / t18
  t983 = t978 * t981 * t31
  t1040 = 0.20000e5 / 0.27e2 * t50 * t76 * t983 + 0.700000e6 / 0.27e2 * t84 * t61 * t88 * t983 + 0.4900000e7 / 0.27e2 * t700 * t94 * t983 + 0.3920000e7 / 0.9e1 * t345 * t100 * t983 + 0.160000e6 / 0.27e2 * t181 * t76 * t983 + 0.100000e6 / 0.27e2 * t56 * t82 * t983 + 0.40000e5 / 0.3e1 * t463 * t76 * t983 + 0.1100000e7 / 0.3e1 * t98 * t394 * t983 + 0.1400000e7 / 0.9e1 * t102 * t79 * t106 * t983 + 0.8000000e7 / 0.9e1 * t614 * t112 * t983 + 0.5500000e7 / 0.3e1 * t376 * t250 * t983 + 0.44000000e8 / 0.27e2 * t238 * t394 * t983 + 0.14300000e8 / 0.27e2 * t104 * t641 * t983 + 0.2200000e7 / 0.9e1 * t108 * t85 * t112 * t983 + 0.12100000e8 / 0.9e1 * t633 * t250 * t983 + 0.8960000e7 / 0.27e2 * t709 * t100 * t983 + 0.2240000e7 / 0.3e1 * t355 * t106 * t983 + 0.6400000e7 / 0.9e1 * t224 * t112 * t983
  t1057 = t328 * t311
  t1084 = 0.2200000e7 / 0.9e1 * t92 * t250 * t983 + 0.280000e6 / 0.3e1 * t96 * t73 * t100 * t983 + 0.560000e6 * t716 * t106 * t983 + 0.1200000e7 * t365 * t112 * t983 + 0.1100000e7 * t231 * t250 * t983 + 0.54400e5 / 0.27e2 * t460 * t1057 + 0.217600e6 / 0.81e2 * t457 * t1057 + 0.54400e5 / 0.9e1 * t467 * t1057 + 0.108800e6 / 0.27e2 * t470 * t1057 + 0.108800e6 / 0.27e2 * t474 * t1057 + 0.870400e6 / 0.81e2 * t477 * t1057 + 0.6582400e7 / 0.81e2 * t390 * t1057 + 0.1196800e7 / 0.27e2 * t395 * t1057 + 0.380800e6 / 0.27e2 * t346 * t1057 - 0.12320e5 / 0.81e2 * t185 * t966 - 0.6160e4 / 0.9e1 * t235 * t966 - 0.61600e5 / 0.81e2 * t239 * t966 - 0.61600e5 / 0.81e2 * t242 * t966
  t1122 = 0.2665600e7 / 0.81e2 * t349 * t1057 + 0.1523200e7 / 0.81e2 * t352 * t1057 - 0.30800e5 / 0.81e2 * t203 * t966 + 0.54400e5 * t369 * t1057 + 0.272000e6 / 0.9e1 * t373 * t1057 + 0.272000e6 / 0.9e1 * t377 * t1057 + 0.5440000e7 / 0.81e2 * t380 * t1057 + 0.2992000e7 / 0.81e2 * t383 * t1057 + 0.2992000e7 / 0.81e2 * t387 * t1057 + 0.54400e5 / 0.27e2 * t464 * t1057 + 0.217600e6 / 0.9e1 * t339 * t1057 + 0.380800e6 / 0.27e2 * t342 * t1057 + 0.54400e5 / 0.81e2 * t454 * t1057 + 0.1523200e7 / 0.81e2 * t356 * t1057 + 0.3481600e7 / 0.81e2 * t359 * t1057 + 0.217600e6 / 0.9e1 * t362 * t1057 + 0.217600e6 / 0.9e1 * t366 * t1057 + 0.544000e6 / 0.81e2 * t480 * t1057
  t1174 = 0.544000e6 / 0.81e2 * t484 * t1057 + 0.1360000e7 / 0.81e2 * t326 * t1057 + 0.272000e6 / 0.27e2 * t332 * t1057 + 0.272000e6 / 0.27e2 * t336 * t1057 - 0.6160e4 / 0.27e2 * t192 * t966 - 0.24640e5 / 0.81e2 * t196 * t966 + 0.200000e6 / 0.9e1 * t188 * t82 * t983 + 0.100000e6 / 0.9e1 * t62 * t88 * t983 + 0.320000e6 / 0.27e2 * t665 * t76 * t983 + 0.400000e6 / 0.9e1 * t473 * t82 * t983 + 0.1600000e7 / 0.27e2 * t195 * t88 * t983 + 0.700000e6 / 0.27e2 * t68 * t94 * t983 + 0.100000e6 / 0.27e2 * t72 * t49 * t76 * t983 + 0.1000000e7 / 0.27e2 * t676 * t82 * t983 + 0.24200000e8 / 0.9e1 * t386 * t394 * t983 + 0.62920000e8 / 0.27e2 * t245 * t641 * t983 + 0.20020000e8 / 0.27e2 * t110 / t93 / t87 * t983 + 0.3920000e7 / 0.9e1 * t217 * t106 * t983
  t1225 = 0.1400000e7 / 0.9e1 * t86 * t112 * t983 + 0.1400000e7 / 0.27e2 * t90 * t67 * t94 * t983 + 0.1000000e7 / 0.9e1 * t483 * t88 * t983 + 0.3500000e7 / 0.27e2 * t202 * t94 * t983 + 0.1400000e7 / 0.27e2 * t74 * t100 * t983 + 0.100000e6 / 0.9e1 * t78 * t55 * t82 * t983 + 0.800000e6 / 0.9e1 * t687 * t88 * t983 + 0.700000e6 / 0.3e1 * t335 * t94 * t983 + 0.2240000e7 / 0.9e1 * t209 * t100 * t983 + 0.280000e6 / 0.3e1 * t80 * t106 * t983 - 0.43120e5 / 0.81e2 * t221 * t966 - 0.49280e5 / 0.81e2 * t225 * t966 - 0.49280e5 / 0.81e2 * t228 * t966 - 0.6160e4 / 0.9e1 * t232 * t966 - 0.24640e5 / 0.81e2 * t199 * t966 - 0.67760e5 / 0.81e2 * t251 * t966 - 0.43120e5 / 0.81e2 * t218 * t966 - 0.67760e5 / 0.81e2 * t246 * t966
  t1238 = 0.1e1 / t949
  t1239 = t1238 * t64
  t1246 = t661 * t1238
  t1249 = t672 * t1238
  t1252 = t683 * t1238
  t1255 = t696 * t1238
  t1258 = t646 * t1238
  t1265 = t616 * t1238
  t1268 = t621 * t1238
  t1271 = -0.6160e4 / 0.27e2 * t189 * t966 - 0.30800e5 / 0.81e2 * t206 * t966 - 0.12320e5 / 0.27e2 * t210 * t966 - 0.12320e5 / 0.27e2 * t214 * t966 - 0.6160e4 / 0.81e2 * t177 * t966 - 0.12320e5 / 0.81e2 * t182 * t966 - 0.16000e5 / 0.9e1 * t846 * t1239 - 0.16000e5 / 0.9e1 * t853 * t1239 - 0.32000e5 / 0.9e1 * t850 * t1239 - 0.320000e6 / 0.9e1 * t687 * t1246 - 0.160000e6 * t335 * t1249 - 0.224000e6 * t209 * t1252 - 0.896000e6 / 0.9e1 * t80 * t1255 - 0.16000e5 / 0.9e1 * t50 * t1258 - 0.896000e6 / 0.9e1 * t709 * t1252 - 0.3584000e7 / 0.9e1 * t355 * t1255 - 0.512000e6 * t224 * t1265 - 0.640000e6 / 0.3e1 * t92 * t1268
  t1279 = t625 * t1238
  t1288 = t629 * t1238
  t1295 = t31 * t981 * t70
  t1311 = t652 * t1238
  t1319 = -0.448000e6 / 0.3e1 * t716 * t1255 - 0.576000e6 * t365 * t1265 - 0.720000e6 * t231 * t1268 - 0.880000e6 / 0.3e1 * t98 * t1279 - 0.640000e6 / 0.3e1 * t614 * t1265 - 0.800000e6 * t376 * t1268 - 0.8800000e7 / 0.9e1 * t238 * t1279 - 0.3520000e7 / 0.9e1 * t104 * t1288 - 0.880000e6 / 0.3e1 * t633 * t1268 + 0.20000e5 / 0.27e2 * t41 * t978 * t1295 + 0.20000e5 / 0.9e1 * t54 * t978 * t1295 + 0.20000e5 / 0.9e1 * t60 * t978 * t1295 + 0.20000e5 / 0.27e2 * t66 * t978 * t1295 - 0.160000e6 / 0.9e1 * t62 * t1246 - 0.32000e5 / 0.3e1 * t181 * t1258 - 0.64000e5 / 0.9e1 * t56 * t1311 - 0.6160e4 / 0.81e2 * t173 * t595 * t52 - 0.9680000e7 / 0.9e1 * t386 * t1279
  t1337 = t515 * t58
  t1358 = -0.16000e5 * t463 * t1258 - 0.32000e5 * t188 * t1311 - 0.3872000e7 / 0.3e1 * t245 * t1288 - 0.4576000e7 / 0.9e1 * t110 * t642 * t1238 - 0.560000e6 / 0.9e1 * t700 * t1249 - 0.784000e6 / 0.3e1 * t345 * t1252 - 0.3136000e7 / 0.9e1 * t217 * t1255 - 0.448000e6 / 0.3e1 * t86 * t1265 + 0.54400e5 / 0.81e2 * t429 * t1337 + 0.54400e5 / 0.81e2 * t433 * t1337 - 0.64000e5 / 0.9e1 * t665 * t1258 - 0.128000e6 / 0.3e1 * t473 * t1311 - 0.640000e6 / 0.9e1 * t195 * t1246 - 0.320000e6 / 0.9e1 * t68 * t1249 - 0.160000e6 / 0.9e1 * t676 * t1311 - 0.800000e6 / 0.9e1 * t483 * t1246 - 0.400000e6 / 0.3e1 * t202 * t1249 - 0.560000e6 / 0.9e1 * t74 * t1252
  t1375 = t498 ** 2
  t1382 = 0.34686175488445087618880000000000000000000000000002e0 * t165 * t32 * t317 * t489 - 0.10791254596405138370318222222222222222222222222223e1 * t165 * t32 * t561 * t255 + 0.67681198823566969126338771262151491982222222222229e-1 * t307 * t308 * t582 * t255 - 0.144e3 * t878 * t931 + 0.144e3 * t883 * t867 + 0.48e2 * t536 * t936 + 0.8e1 * t491 * t936 + 0.72e2 * t875 * t867 + 0.24e2 * t510 * t936 - 0.360e3 * t863 * t931 - 0.36e2 * t870 * t931 + (0.334400e6 / 0.81e2 * t138 * t30 * t951 + 0.20944e5 / 0.81e2 * t147 * t957 * t130 + 0.88000e5 / 0.27e2 * t147 * t592 * tau0 + 0.217600e6 / 0.81e2 * t524 * t515 + 0.24640e5 / 0.81e2 * t286 * t966) * t155 + (0.20944e5 / 0.81e2 * t124 * t957 + 0.12320e5 / 0.81e2 * t266 * t595) * t134 + t39 * (t1040 + t1084 + t1122 + t1174 + t1225 + t1271 + t1319 + t1358) - 0.16732296375826278478455974006476341073382716049384e0 * t307 * t308 * t951 * t114 + 0.15287610678240612691284148148148148148148148148149e1 * t165 * t32 * t956 * t114 - 0.63065773615354704761600000000000000000000000000004e-1 * t165 * t32 * t168 * t859 + 0.18e2 * t510 * t1375 - 0.12e2 * t570 * t498 - 0.8e1 * t507 * t566
  t1393 = t492 ** 2
  t1402 = 0.48281349925925925925925925925925925925925925925925e0 * t32 * t956 + 0.28400794074074074074074074074074074074074074074075e0 * t966
  t1446 = t137 ** 2
  t1457 = -0.18e2 * t577 * t498 - 0.12e2 * t531 * t566 - 0.240e3 * t289 * t862 * t864 + 0.360e3 * t153 / t291 / t154 * t1393 + 0.36e2 * t505 * t292 * t492 - 0.3e1 * t293 * t1402 - t257 * t1402 - 0.8e1 * t612 * t155 * t261 + 0.72e2 * t529 * t535 * t492 + 0.36e2 * t536 * t1375 + 0.24e2 * t116 * t535 * t1393 + 0.6e1 * t491 * t1375 - 0.96e2 * t269 * t535 * t864 + 0.120e3 * t132 * t862 * t1393 - 0.2e1 * t271 * t1402 - 0.12e2 * t606 * t292 * t261 + 0.29714073032850340034019901456767280890278268039626e-1 * t890 * t891 / t580 / t139 * t114 - 0.54025587332455163698218002648667783436869578253865e-2 * t890 * t894 * t255 - 0.92292543850318594263189233539297489066666666666676e-2 * t307 * t308 * t311 * t489 - 0.13177139257634372559638998813227929856887002105148e-3 / t886 / t36 * t889 * t1446 / t20 / t580 / t274 * t114 * t24 * t28 * t31
  t1463 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t17 * t168 * t157 - 0.5e1 / 0.9e1 * t6 * t23 * t296 + t6 * t161 * t541 / 0.2e1 - t6 * t301 * t899 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t545 * (t1382 + t1457))
  v4rho4_0_ = 0.2e1 * r0 * t1463 + 0.8e1 * t904

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t36 = 0.1e1 / t35
  t37 = t32 * t36
  t38 = r0 ** 2
  t39 = r0 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t42 = 0.1e1 / t40 / t38
  t43 = s0 * t42
  t46 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t37 * t43
  t49 = 0.18040e1 - 0.64641600e0 / t46
  t50 = params.a[0]
  t51 = params.a[1]
  t52 = t32 ** 2
  t53 = t52 * t35
  t54 = 0.3e1 / 0.10e2 * t53
  t57 = tau0 / t40 / r0
  t58 = t54 - t57
  t59 = t51 * t58
  t60 = t54 + t57
  t61 = 0.1e1 / t60
  t63 = params.a[2]
  t64 = t58 ** 2
  t65 = t63 * t64
  t66 = t60 ** 2
  t67 = 0.1e1 / t66
  t69 = params.a[3]
  t70 = t64 * t58
  t71 = t69 * t70
  t72 = t66 * t60
  t73 = 0.1e1 / t72
  t75 = params.a[4]
  t76 = t64 ** 2
  t77 = t75 * t76
  t78 = t66 ** 2
  t79 = 0.1e1 / t78
  t81 = params.a[5]
  t82 = t76 * t58
  t83 = t81 * t82
  t84 = t78 * t60
  t85 = 0.1e1 / t84
  t87 = params.a[6]
  t88 = t76 * t64
  t89 = t87 * t88
  t91 = 0.1e1 / t78 / t66
  t93 = params.a[7]
  t94 = t76 * t70
  t95 = t93 * t94
  t97 = 0.1e1 / t78 / t72
  t99 = params.a[8]
  t100 = t76 ** 2
  t101 = t99 * t100
  t102 = t78 ** 2
  t103 = 0.1e1 / t102
  t105 = params.a[9]
  t106 = t100 * t58
  t107 = t105 * t106
  t109 = 0.1e1 / t102 / t60
  t111 = params.a[10]
  t112 = t100 * t64
  t113 = t111 * t112
  t115 = 0.1e1 / t102 / t66
  t117 = params.a[11]
  t119 = t117 * t100 * t70
  t121 = 0.1e1 / t102 / t72
  t123 = t101 * t103 + t107 * t109 + t113 * t115 + t119 * t121 + t59 * t61 + t65 * t67 + t71 * t73 + t77 * t79 + t83 * t85 + t89 * t91 + t95 * t97 + t50
  t125 = params.d[0]
  t128 = 0.11203560000000000000000000000000000000000000000000e-2 * t53
  t129 = 0.1e1 + 0.186726e-2 * t43 + 0.373452e-2 * t57 - t128
  t132 = params.d[1]
  t133 = t132 * s0
  t135 = params.d[2]
  t137 = 0.3e1 / 0.5e1 * t53
  t138 = 0.2e1 * t57 - t137
  t140 = t133 * t42 + t135 * t138
  t141 = t129 ** 2
  t142 = 0.1e1 / t141
  t144 = params.d[3]
  t145 = s0 ** 2
  t146 = t144 * t145
  t147 = t38 ** 2
  t150 = 0.1e1 / t39 / t147 / r0
  t152 = params.d[4]
  t153 = t152 * s0
  t156 = params.d[5]
  t157 = t138 ** 2
  t159 = t153 * t42 * t138 + t146 * t150 + t156 * t157
  t161 = 0.1e1 / t141 / t129
  t163 = t49 * t123 + t125 / t129 + t140 * t142 + t159 * t161
  t167 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t168 = t167 * f.p.zeta_threshold
  t170 = f.my_piecewise3(t20, t168, t21 * t19)
  t171 = t30 ** 2
  t172 = 0.1e1 / t171
  t173 = t170 * t172
  t176 = t5 * t173 * t163 / 0.8e1
  t177 = t170 * t30
  t178 = t46 ** 2
  t181 = 0.1e1 / t178 * t32 * t36
  t182 = t38 * r0
  t184 = 0.1e1 / t40 / t182
  t185 = s0 * t184
  t189 = t51 * tau0
  t193 = t67 * tau0
  t194 = t193 * t42
  t197 = t63 * t58
  t200 = t73 * tau0
  t201 = t200 * t42
  t204 = t69 * t64
  t207 = t79 * tau0
  t208 = t207 * t42
  t211 = t75 * t70
  t214 = t85 * tau0
  t215 = t214 * t42
  t218 = t81 * t76
  t221 = t91 * tau0
  t222 = t221 * t42
  t225 = t87 * t82
  t228 = 0.5e1 / 0.3e1 * t189 * t42 * t61 + 0.5e1 / 0.3e1 * t59 * t194 + 0.10e2 / 0.3e1 * t197 * t194 + 0.10e2 / 0.3e1 * t65 * t201 + 0.5e1 * t204 * t201 + 0.5e1 * t71 * t208 + 0.20e2 / 0.3e1 * t211 * t208 + 0.20e2 / 0.3e1 * t77 * t215 + 0.25e2 / 0.3e1 * t218 * t215 + 0.25e2 / 0.3e1 * t83 * t222 + 0.10e2 * t225 * t222
  t229 = t97 * tau0
  t230 = t229 * t42
  t233 = t93 * t88
  t236 = t103 * tau0
  t237 = t236 * t42
  t240 = t99 * t94
  t243 = t109 * tau0
  t244 = t243 * t42
  t247 = t105 * t100
  t250 = t115 * tau0
  t251 = t250 * t42
  t254 = t111 * t106
  t257 = t121 * tau0
  t258 = t257 * t42
  t261 = t117 * t112
  t265 = 0.1e1 / t102 / t78
  t266 = t265 * tau0
  t270 = 0.10e2 * t89 * t230 + 0.35e2 / 0.3e1 * t233 * t230 + 0.35e2 / 0.3e1 * t95 * t237 + 0.40e2 / 0.3e1 * t240 * t237 + 0.40e2 / 0.3e1 * t101 * t244 + 0.15e2 * t247 * t244 + 0.15e2 * t107 * t251 + 0.50e2 / 0.3e1 * t254 * t251 + 0.50e2 / 0.3e1 * t113 * t258 + 0.55e2 / 0.3e1 * t261 * t258 + 0.55e2 / 0.3e1 * t119 * t266 * t42
  t271 = t228 + t270
  t273 = t125 * t142
  t275 = tau0 * t42
  t277 = -0.49793600000000000000000000000000000000000000000000e-2 * t185 - 0.62242000000000000000000000000000000000000000000000e-2 * t275
  t281 = t135 * tau0
  t284 = -0.8e1 / 0.3e1 * t133 * t184 - 0.10e2 / 0.3e1 * t281 * t42
  t286 = t140 * t161
  t291 = 0.1e1 / t39 / t147 / t38
  t300 = t156 * t138
  t303 = -0.16e2 / 0.3e1 * t146 * t291 - 0.8e1 / 0.3e1 * t153 * t184 * t138 - 0.10e2 / 0.3e1 * t153 * t150 * tau0 - 0.20e2 / 0.3e1 * t300 * t275
  t305 = t141 ** 2
  t306 = 0.1e1 / t305
  t307 = t159 * t306
  t310 = -0.15766443403838676190400000000000000000000000000001e-1 * t181 * t185 * t123 + t49 * t271 - t273 * t277 + t284 * t142 - 0.2e1 * t286 * t277 + t303 * t161 - 0.3e1 * t307 * t277
  t315 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t163 - t176 - 0.3e1 / 0.8e1 * t5 * t177 * t310)
  t317 = r1 <= f.p.dens_threshold
  t318 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t319 = 0.1e1 + t318
  t320 = t319 <= f.p.zeta_threshold
  t321 = t319 ** (0.1e1 / 0.3e1)
  t323 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t326 = f.my_piecewise3(t320, 0, 0.4e1 / 0.3e1 * t321 * t323)
  t327 = t326 * t30
  t328 = r1 ** 2
  t329 = r1 ** (0.1e1 / 0.3e1)
  t330 = t329 ** 2
  t332 = 0.1e1 / t330 / t328
  t333 = s2 * t332
  t336 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t37 * t333
  t339 = 0.18040e1 - 0.64641600e0 / t336
  t342 = tau1 / t330 / r1
  t343 = t54 - t342
  t344 = t51 * t343
  t345 = t54 + t342
  t346 = 0.1e1 / t345
  t348 = t343 ** 2
  t349 = t63 * t348
  t350 = t345 ** 2
  t351 = 0.1e1 / t350
  t353 = t348 * t343
  t354 = t69 * t353
  t355 = t350 * t345
  t356 = 0.1e1 / t355
  t358 = t348 ** 2
  t359 = t75 * t358
  t360 = t350 ** 2
  t361 = 0.1e1 / t360
  t363 = t358 * t343
  t364 = t81 * t363
  t365 = t360 * t345
  t366 = 0.1e1 / t365
  t368 = t358 * t348
  t369 = t87 * t368
  t371 = 0.1e1 / t360 / t350
  t373 = t358 * t353
  t374 = t93 * t373
  t376 = 0.1e1 / t360 / t355
  t378 = t358 ** 2
  t379 = t99 * t378
  t380 = t360 ** 2
  t381 = 0.1e1 / t380
  t383 = t378 * t343
  t384 = t105 * t383
  t386 = 0.1e1 / t380 / t345
  t388 = t378 * t348
  t389 = t111 * t388
  t391 = 0.1e1 / t380 / t350
  t394 = t117 * t378 * t353
  t396 = 0.1e1 / t380 / t355
  t398 = t344 * t346 + t349 * t351 + t354 * t356 + t359 * t361 + t364 * t366 + t369 * t371 + t374 * t376 + t379 * t381 + t384 * t386 + t389 * t391 + t394 * t396 + t50
  t402 = 0.1e1 + 0.186726e-2 * t333 + 0.373452e-2 * t342 - t128
  t405 = t132 * s2
  t408 = 0.2e1 * t342 - t137
  t410 = t135 * t408 + t405 * t332
  t411 = t402 ** 2
  t412 = 0.1e1 / t411
  t414 = s2 ** 2
  t415 = t144 * t414
  t416 = t328 ** 2
  t419 = 0.1e1 / t329 / t416 / r1
  t421 = t152 * s2
  t424 = t408 ** 2
  t426 = t421 * t332 * t408 + t156 * t424 + t415 * t419
  t428 = 0.1e1 / t411 / t402
  t430 = t339 * t398 + t125 / t402 + t410 * t412 + t426 * t428
  t435 = f.my_piecewise3(t320, t168, t321 * t319)
  t436 = t435 * t172
  t439 = t5 * t436 * t430 / 0.8e1
  t441 = f.my_piecewise3(t317, 0, -0.3e1 / 0.8e1 * t5 * t327 * t430 - t439)
  t443 = t21 ** 2
  t444 = 0.1e1 / t443
  t445 = t26 ** 2
  t450 = t16 / t22 / t6
  t452 = -0.2e1 * t23 + 0.2e1 * t450
  t453 = f.my_piecewise5(t10, 0, t14, 0, t452)
  t457 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t444 * t445 + 0.4e1 / 0.3e1 * t21 * t453)
  t464 = t5 * t29 * t172 * t163
  t470 = 0.1e1 / t171 / t6
  t474 = t5 * t170 * t470 * t163 / 0.12e2
  t476 = t5 * t173 * t310
  t482 = 0.1e1 / t34 / t33
  t486 = 0.1e1 / t39 / t147 / t182
  t492 = 0.1e1 / t40 / t147
  t493 = s0 * t492
  t503 = tau0 ** 2
  t505 = t150 * t67
  t511 = t221 * t184
  t514 = t229 * t184
  t519 = t236 * t184
  t524 = t243 * t184
  t529 = t250 * t184
  t534 = t257 * t184
  t537 = -0.40e2 / 0.9e1 * t189 * t184 * t61 + 0.50e2 / 0.9e1 * t51 * t503 * t505 + 0.50e2 / 0.9e1 * t63 * t503 * t505 - 0.80e2 / 0.3e1 * t225 * t511 - 0.80e2 / 0.3e1 * t89 * t514 - 0.280e3 / 0.9e1 * t233 * t514 - 0.280e3 / 0.9e1 * t95 * t519 - 0.320e3 / 0.9e1 * t240 * t519 - 0.320e3 / 0.9e1 * t101 * t524 - 0.40e2 * t247 * t524 - 0.40e2 * t107 * t529 - 0.400e3 / 0.9e1 * t254 * t529 - 0.400e3 / 0.9e1 * t113 * t534
  t544 = t265 * t503 * t150
  t549 = t121 * t503 * t150
  t562 = t91 * t503 * t150
  t566 = t97 * t503 * t150
  t570 = t103 * t503 * t150
  t579 = t109 * t503 * t150
  t586 = t115 * t503 * t150
  t589 = -0.440e3 / 0.9e1 * t261 * t534 - 0.440e3 / 0.9e1 * t119 * t266 * t184 + 0.2750e4 / 0.9e1 * t113 * t544 + 0.2750e4 / 0.9e1 * t117 * t106 * t549 + 0.6050e4 / 0.9e1 * t261 * t544 + 0.1100e4 / 0.3e1 * t119 / t102 / t84 * t503 * t150 + 0.250e3 / 0.3e1 * t87 * t76 * t562 + 0.200e3 * t225 * t566 + 0.350e3 / 0.3e1 * t89 * t570 + 0.350e3 / 0.3e1 * t93 * t82 * t566 + 0.2450e4 / 0.9e1 * t233 * t570 + 0.1400e4 / 0.9e1 * t95 * t579 + 0.1400e4 / 0.9e1 * t99 * t88 * t570 + 0.450e3 * t247 * t586
  t606 = t73 * t503 * t150
  t612 = t79 * t503 * t150
  t621 = t85 * t503 * t150
  t627 = 0.250e3 * t107 * t549 + 0.3200e4 / 0.9e1 * t240 * t579 + 0.200e3 * t101 * t586 + 0.200e3 * t105 * t94 * t579 + 0.250e3 * t111 * t100 * t586 + 0.5000e4 / 0.9e1 * t254 * t549 + 0.50e2 / 0.9e1 * t59 * t606 + 0.200e3 / 0.9e1 * t197 * t606 + 0.50e2 / 0.3e1 * t65 * t612 + 0.50e2 / 0.3e1 * t69 * t58 * t606 + 0.50e2 * t204 * t612 + 0.100e3 / 0.3e1 * t71 * t621 + 0.100e3 / 0.3e1 * t75 * t64 * t612
  t639 = t193 * t184
  t644 = t200 * t184
  t649 = t207 * t184
  t654 = t214 * t184
  t661 = 0.800e3 / 0.9e1 * t211 * t621 + 0.500e3 / 0.9e1 * t77 * t562 + 0.500e3 / 0.9e1 * t81 * t70 * t621 + 0.1250e4 / 0.9e1 * t218 * t562 + 0.250e3 / 0.3e1 * t83 * t566 - 0.40e2 / 0.9e1 * t59 * t639 - 0.80e2 / 0.9e1 * t197 * t639 - 0.80e2 / 0.9e1 * t65 * t644 - 0.40e2 / 0.3e1 * t204 * t644 - 0.40e2 / 0.3e1 * t71 * t649 - 0.160e3 / 0.9e1 * t211 * t649 - 0.160e3 / 0.9e1 * t77 * t654 - 0.200e3 / 0.9e1 * t218 * t654 - 0.200e3 / 0.9e1 * t83 * t511
  t666 = t277 ** 2
  t670 = tau0 * t184
  t672 = 0.18257653333333333333333333333333333333333333333333e-1 * t493 + 0.16597866666666666666666666666666666666666666666667e-1 * t670
  t713 = -0.76910453208598828552657694616081240888888888888897e-3 / t178 / t46 * t52 * t482 * t145 * t486 * t123 + 0.57810292480741812698133333333333333333333333333337e-1 * t181 * t493 * t123 - 0.31532886807677352380800000000000000000000000000002e-1 * t181 * t185 * t271 + t49 * (t537 + t589 + t627 + t661) + 0.2e1 * t125 * t161 * t666 - t273 * t672 + (0.88e2 / 0.9e1 * t133 * t492 + 0.80e2 / 0.9e1 * t281 * t184) * t142 - 0.4e1 * t284 * t161 * t277 + 0.6e1 * t140 * t306 * t666 - 0.2e1 * t286 * t672 + (0.304e3 / 0.9e1 * t146 * t486 + 0.88e2 / 0.9e1 * t153 * t492 * t138 + 0.80e2 / 0.3e1 * t153 * t291 * tau0 + 0.200e3 / 0.9e1 * t156 * t503 * t150 + 0.160e3 / 0.9e1 * t300 * t670) * t161 - 0.6e1 * t303 * t306 * t277 + 0.12e2 * t159 / t305 / t129 * t666 - 0.3e1 * t307 * t672
  t718 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t457 * t30 * t163 - t464 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t310 + t474 - t476 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t177 * t713)
  t719 = t321 ** 2
  t720 = 0.1e1 / t719
  t721 = t323 ** 2
  t725 = f.my_piecewise5(t14, 0, t10, 0, -t452)
  t729 = f.my_piecewise3(t320, 0, 0.4e1 / 0.9e1 * t720 * t721 + 0.4e1 / 0.3e1 * t321 * t725)
  t736 = t5 * t326 * t172 * t430
  t741 = t5 * t435 * t470 * t430 / 0.12e2
  t743 = f.my_piecewise3(t317, 0, -0.3e1 / 0.8e1 * t5 * t729 * t30 * t430 - t736 / 0.4e1 + t741)
  d11 = 0.2e1 * t315 + 0.2e1 * t441 + t6 * (t718 + t743)
  t746 = -t7 - t24
  t747 = f.my_piecewise5(t10, 0, t14, 0, t746)
  t750 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t747)
  t751 = t750 * t30
  t756 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t751 * t163 - t176)
  t758 = f.my_piecewise5(t14, 0, t10, 0, -t746)
  t761 = f.my_piecewise3(t320, 0, 0.4e1 / 0.3e1 * t321 * t758)
  t762 = t761 * t30
  t766 = t435 * t30
  t767 = t336 ** 2
  t770 = 0.1e1 / t767 * t32 * t36
  t771 = t328 * r1
  t773 = 0.1e1 / t330 / t771
  t774 = s2 * t773
  t778 = t51 * tau1
  t782 = t351 * tau1
  t783 = t782 * t332
  t786 = t63 * t343
  t789 = t356 * tau1
  t790 = t789 * t332
  t793 = t69 * t348
  t796 = t361 * tau1
  t797 = t796 * t332
  t800 = t75 * t353
  t803 = t366 * tau1
  t804 = t803 * t332
  t807 = t81 * t358
  t810 = t371 * tau1
  t811 = t810 * t332
  t814 = t87 * t363
  t817 = 0.5e1 / 0.3e1 * t778 * t332 * t346 + 0.5e1 / 0.3e1 * t344 * t783 + 0.10e2 / 0.3e1 * t786 * t783 + 0.10e2 / 0.3e1 * t349 * t790 + 0.5e1 * t793 * t790 + 0.5e1 * t354 * t797 + 0.20e2 / 0.3e1 * t800 * t797 + 0.20e2 / 0.3e1 * t359 * t804 + 0.25e2 / 0.3e1 * t807 * t804 + 0.25e2 / 0.3e1 * t364 * t811 + 0.10e2 * t814 * t811
  t818 = t376 * tau1
  t819 = t818 * t332
  t822 = t93 * t368
  t825 = t381 * tau1
  t826 = t825 * t332
  t829 = t99 * t373
  t832 = t386 * tau1
  t833 = t832 * t332
  t836 = t105 * t378
  t839 = t391 * tau1
  t840 = t839 * t332
  t843 = t111 * t383
  t846 = t396 * tau1
  t847 = t846 * t332
  t850 = t117 * t388
  t854 = 0.1e1 / t380 / t360
  t855 = t854 * tau1
  t859 = 0.10e2 * t369 * t819 + 0.35e2 / 0.3e1 * t822 * t819 + 0.35e2 / 0.3e1 * t374 * t826 + 0.40e2 / 0.3e1 * t829 * t826 + 0.40e2 / 0.3e1 * t379 * t833 + 0.15e2 * t836 * t833 + 0.15e2 * t384 * t840 + 0.50e2 / 0.3e1 * t843 * t840 + 0.50e2 / 0.3e1 * t389 * t847 + 0.55e2 / 0.3e1 * t850 * t847 + 0.55e2 / 0.3e1 * t394 * t855 * t332
  t860 = t817 + t859
  t862 = t125 * t412
  t864 = tau1 * t332
  t866 = -0.49793600000000000000000000000000000000000000000000e-2 * t774 - 0.62242000000000000000000000000000000000000000000000e-2 * t864
  t870 = t135 * tau1
  t873 = -0.8e1 / 0.3e1 * t405 * t773 - 0.10e2 / 0.3e1 * t870 * t332
  t875 = t410 * t428
  t880 = 0.1e1 / t329 / t416 / t328
  t889 = t156 * t408
  t892 = -0.16e2 / 0.3e1 * t415 * t880 - 0.8e1 / 0.3e1 * t421 * t773 * t408 - 0.10e2 / 0.3e1 * t421 * t419 * tau1 - 0.20e2 / 0.3e1 * t889 * t864
  t894 = t411 ** 2
  t895 = 0.1e1 / t894
  t896 = t426 * t895
  t899 = -0.15766443403838676190400000000000000000000000000001e-1 * t770 * t774 * t398 + t339 * t860 - t862 * t866 + t873 * t412 - 0.2e1 * t875 * t866 + t892 * t428 - 0.3e1 * t896 * t866
  t904 = f.my_piecewise3(t317, 0, -0.3e1 / 0.8e1 * t5 * t762 * t430 - t439 - 0.3e1 / 0.8e1 * t5 * t766 * t899)
  t908 = 0.2e1 * t450
  t909 = f.my_piecewise5(t10, 0, t14, 0, t908)
  t913 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t444 * t747 * t26 + 0.4e1 / 0.3e1 * t21 * t909)
  t920 = t5 * t750 * t172 * t163
  t928 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t913 * t30 * t163 - t920 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t751 * t310 - t464 / 0.8e1 + t474 - t476 / 0.8e1)
  t932 = f.my_piecewise5(t14, 0, t10, 0, -t908)
  t936 = f.my_piecewise3(t320, 0, 0.4e1 / 0.9e1 * t720 * t758 * t323 + 0.4e1 / 0.3e1 * t321 * t932)
  t943 = t5 * t761 * t172 * t430
  t950 = t5 * t436 * t899
  t953 = f.my_piecewise3(t317, 0, -0.3e1 / 0.8e1 * t5 * t936 * t30 * t430 - t943 / 0.8e1 - t736 / 0.8e1 + t741 - 0.3e1 / 0.8e1 * t5 * t327 * t899 - t950 / 0.8e1)
  d12 = t315 + t441 + t756 + t904 + t6 * (t928 + t953)
  t958 = t747 ** 2
  t962 = 0.2e1 * t23 + 0.2e1 * t450
  t963 = f.my_piecewise5(t10, 0, t14, 0, t962)
  t967 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t444 * t958 + 0.4e1 / 0.3e1 * t21 * t963)
  t974 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t967 * t30 * t163 - t920 / 0.4e1 + t474)
  t975 = t758 ** 2
  t979 = f.my_piecewise5(t14, 0, t10, 0, -t962)
  t983 = f.my_piecewise3(t320, 0, 0.4e1 / 0.9e1 * t720 * t975 + 0.4e1 / 0.3e1 * t321 * t979)
  t999 = 0.1e1 / t329 / t416 / t771
  t1005 = 0.1e1 / t330 / t416
  t1006 = s2 * t1005
  t1013 = t839 * t773
  t1016 = t846 * t773
  t1024 = tau1 ** 2
  t1026 = t381 * t1024 * t419
  t1030 = t386 * t1024 * t419
  t1039 = t391 * t1024 * t419
  t1048 = t396 * t1024 * t419
  t1054 = -0.400e3 / 0.9e1 * t843 * t1013 - 0.400e3 / 0.9e1 * t389 * t1016 - 0.440e3 / 0.9e1 * t850 * t1016 - 0.440e3 / 0.9e1 * t394 * t855 * t773 + 0.2450e4 / 0.9e1 * t822 * t1026 + 0.1400e4 / 0.9e1 * t374 * t1030 + 0.1400e4 / 0.9e1 * t99 * t368 * t1026 + 0.3200e4 / 0.9e1 * t829 * t1030 + 0.200e3 * t379 * t1039 + 0.200e3 * t105 * t373 * t1030 + 0.450e3 * t836 * t1039 + 0.250e3 * t384 * t1048 + 0.250e3 * t111 * t378 * t1039
  t1058 = t854 * t1024 * t419
  t1073 = t361 * t1024 * t419
  t1078 = t356 * t1024 * t419
  t1084 = t366 * t1024 * t419
  t1093 = t371 * t1024 * t419
  t1101 = 0.5000e4 / 0.9e1 * t843 * t1048 + 0.2750e4 / 0.9e1 * t389 * t1058 + 0.2750e4 / 0.9e1 * t117 * t383 * t1048 + 0.6050e4 / 0.9e1 * t850 * t1058 + 0.1100e4 / 0.3e1 * t394 / t380 / t365 * t1024 * t419 + 0.50e2 / 0.3e1 * t349 * t1073 + 0.50e2 / 0.3e1 * t69 * t343 * t1078 + 0.50e2 * t793 * t1073 + 0.100e3 / 0.3e1 * t354 * t1084 + 0.100e3 / 0.3e1 * t75 * t348 * t1073 + 0.800e3 / 0.9e1 * t800 * t1084 + 0.500e3 / 0.9e1 * t359 * t1093 + 0.500e3 / 0.9e1 * t81 * t353 * t1084 + 0.1250e4 / 0.9e1 * t807 * t1093
  t1104 = t376 * t1024 * t419
  t1121 = t782 * t773
  t1126 = t789 * t773
  t1131 = t796 * t773
  t1136 = 0.250e3 / 0.3e1 * t364 * t1104 + 0.250e3 / 0.3e1 * t87 * t358 * t1093 + 0.200e3 * t814 * t1104 + 0.350e3 / 0.3e1 * t369 * t1026 + 0.350e3 / 0.3e1 * t93 * t363 * t1104 + 0.50e2 / 0.9e1 * t344 * t1078 + 0.200e3 / 0.9e1 * t786 * t1078 - 0.40e2 / 0.9e1 * t344 * t1121 - 0.80e2 / 0.9e1 * t786 * t1121 - 0.80e2 / 0.9e1 * t349 * t1126 - 0.40e2 / 0.3e1 * t793 * t1126 - 0.40e2 / 0.3e1 * t354 * t1131 - 0.160e3 / 0.9e1 * t800 * t1131
  t1137 = t803 * t773
  t1142 = t810 * t773
  t1147 = t818 * t773
  t1152 = t825 * t773
  t1157 = t832 * t773
  t1165 = t419 * t351
  t1174 = -0.160e3 / 0.9e1 * t359 * t1137 - 0.200e3 / 0.9e1 * t807 * t1137 - 0.200e3 / 0.9e1 * t364 * t1142 - 0.80e2 / 0.3e1 * t814 * t1142 - 0.80e2 / 0.3e1 * t369 * t1147 - 0.280e3 / 0.9e1 * t822 * t1147 - 0.280e3 / 0.9e1 * t374 * t1152 - 0.320e3 / 0.9e1 * t829 * t1152 - 0.320e3 / 0.9e1 * t379 * t1157 - 0.40e2 * t836 * t1157 - 0.40e2 * t384 * t1013 + 0.50e2 / 0.9e1 * t51 * t1024 * t1165 + 0.50e2 / 0.9e1 * t63 * t1024 * t1165 - 0.40e2 / 0.9e1 * t778 * t773 * t346
  t1179 = t866 ** 2
  t1183 = tau1 * t773
  t1185 = 0.18257653333333333333333333333333333333333333333333e-1 * t1006 + 0.16597866666666666666666666666666666666666666666667e-1 * t1183
  t1226 = -0.76910453208598828552657694616081240888888888888897e-3 / t767 / t336 * t52 * t482 * t414 * t999 * t398 + 0.57810292480741812698133333333333333333333333333337e-1 * t770 * t1006 * t398 - 0.31532886807677352380800000000000000000000000000002e-1 * t770 * t774 * t860 + t339 * (t1054 + t1101 + t1136 + t1174) + 0.2e1 * t125 * t428 * t1179 - t862 * t1185 + (0.88e2 / 0.9e1 * t405 * t1005 + 0.80e2 / 0.9e1 * t870 * t773) * t412 - 0.4e1 * t873 * t428 * t866 + 0.6e1 * t410 * t895 * t1179 - 0.2e1 * t875 * t1185 + (0.304e3 / 0.9e1 * t415 * t999 + 0.88e2 / 0.9e1 * t421 * t1005 * t408 + 0.80e2 / 0.3e1 * t421 * t880 * tau1 + 0.200e3 / 0.9e1 * t156 * t1024 * t419 + 0.160e3 / 0.9e1 * t889 * t1183) * t428 - 0.6e1 * t892 * t895 * t866 + 0.12e2 * t426 / t894 / t402 * t1179 - 0.3e1 * t896 * t1185
  t1231 = f.my_piecewise3(t317, 0, -0.3e1 / 0.8e1 * t5 * t983 * t30 * t430 - t943 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t762 * t899 + t741 - t950 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t766 * t1226)
  d22 = 0.2e1 * t756 + 0.2e1 * t904 + t6 * (t974 + t1231)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 6 ** (0.1e1 / 0.3e1)
  t45 = jnp.pi ** 2
  t46 = t45 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t48 = 0.1e1 / t47
  t49 = t44 * t48
  t50 = r0 ** 2
  t51 = r0 ** (0.1e1 / 0.3e1)
  t52 = t51 ** 2
  t54 = 0.1e1 / t52 / t50
  t55 = s0 * t54
  t58 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t49 * t55
  t61 = 0.18040e1 - 0.64641600e0 / t58
  t62 = params.a[0]
  t63 = params.a[1]
  t64 = t44 ** 2
  t65 = t64 * t47
  t66 = 0.3e1 / 0.10e2 * t65
  t69 = tau0 / t52 / r0
  t70 = t66 - t69
  t71 = t63 * t70
  t72 = t66 + t69
  t73 = 0.1e1 / t72
  t75 = params.a[2]
  t76 = t70 ** 2
  t77 = t75 * t76
  t78 = t72 ** 2
  t79 = 0.1e1 / t78
  t81 = params.a[3]
  t82 = t76 * t70
  t83 = t81 * t82
  t84 = t78 * t72
  t85 = 0.1e1 / t84
  t87 = params.a[4]
  t88 = t76 ** 2
  t89 = t87 * t88
  t90 = t78 ** 2
  t91 = 0.1e1 / t90
  t93 = params.a[5]
  t94 = t88 * t70
  t95 = t93 * t94
  t96 = t90 * t72
  t97 = 0.1e1 / t96
  t99 = params.a[6]
  t100 = t88 * t76
  t101 = t99 * t100
  t102 = t90 * t78
  t103 = 0.1e1 / t102
  t105 = params.a[7]
  t106 = t88 * t82
  t107 = t105 * t106
  t109 = 0.1e1 / t90 / t84
  t111 = params.a[8]
  t112 = t88 ** 2
  t113 = t111 * t112
  t114 = t90 ** 2
  t115 = 0.1e1 / t114
  t117 = params.a[9]
  t118 = t112 * t70
  t119 = t117 * t118
  t121 = 0.1e1 / t114 / t72
  t123 = params.a[10]
  t124 = t112 * t76
  t125 = t123 * t124
  t127 = 0.1e1 / t114 / t78
  t129 = params.a[11]
  t131 = t129 * t112 * t82
  t133 = 0.1e1 / t114 / t84
  t135 = t101 * t103 + t107 * t109 + t113 * t115 + t119 * t121 + t125 * t127 + t131 * t133 + t71 * t73 + t77 * t79 + t83 * t85 + t89 * t91 + t95 * t97 + t62
  t137 = params.d[0]
  t140 = 0.11203560000000000000000000000000000000000000000000e-2 * t65
  t141 = 0.1e1 + 0.186726e-2 * t55 + 0.373452e-2 * t69 - t140
  t144 = params.d[1]
  t145 = t144 * s0
  t147 = params.d[2]
  t149 = 0.3e1 / 0.5e1 * t65
  t150 = 0.2e1 * t69 - t149
  t152 = t145 * t54 + t147 * t150
  t153 = t141 ** 2
  t154 = 0.1e1 / t153
  t156 = params.d[3]
  t157 = s0 ** 2
  t158 = t156 * t157
  t159 = t50 ** 2
  t160 = t159 * r0
  t162 = 0.1e1 / t51 / t160
  t164 = params.d[4]
  t165 = t164 * s0
  t168 = params.d[5]
  t169 = t150 ** 2
  t171 = t165 * t54 * t150 + t158 * t162 + t168 * t169
  t173 = 0.1e1 / t153 / t141
  t175 = t61 * t135 + t137 / t141 + t152 * t154 + t171 * t173
  t181 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t182 = t42 ** 2
  t183 = 0.1e1 / t182
  t184 = t181 * t183
  t188 = t181 * t42
  t189 = t58 ** 2
  t192 = 0.1e1 / t189 * t44 * t48
  t193 = t50 * r0
  t195 = 0.1e1 / t52 / t193
  t196 = s0 * t195
  t200 = t63 * tau0
  t204 = t79 * tau0
  t205 = t204 * t54
  t208 = t75 * t70
  t211 = t85 * tau0
  t212 = t211 * t54
  t215 = t81 * t76
  t218 = t91 * tau0
  t219 = t218 * t54
  t222 = t87 * t82
  t225 = t97 * tau0
  t226 = t225 * t54
  t229 = t93 * t88
  t232 = t103 * tau0
  t233 = t232 * t54
  t236 = t99 * t94
  t239 = 0.5e1 / 0.3e1 * t200 * t54 * t73 + 0.5e1 / 0.3e1 * t71 * t205 + 0.10e2 / 0.3e1 * t208 * t205 + 0.10e2 / 0.3e1 * t77 * t212 + 0.5e1 * t215 * t212 + 0.5e1 * t83 * t219 + 0.20e2 / 0.3e1 * t222 * t219 + 0.20e2 / 0.3e1 * t89 * t226 + 0.25e2 / 0.3e1 * t229 * t226 + 0.25e2 / 0.3e1 * t95 * t233 + 0.10e2 * t236 * t233
  t240 = t109 * tau0
  t241 = t240 * t54
  t244 = t105 * t100
  t247 = t115 * tau0
  t248 = t247 * t54
  t251 = t111 * t106
  t254 = t121 * tau0
  t255 = t254 * t54
  t258 = t117 * t112
  t261 = t127 * tau0
  t262 = t261 * t54
  t265 = t123 * t118
  t268 = t133 * tau0
  t269 = t268 * t54
  t272 = t129 * t124
  t276 = 0.1e1 / t114 / t90
  t277 = t276 * tau0
  t281 = 0.10e2 * t101 * t241 + 0.35e2 / 0.3e1 * t244 * t241 + 0.35e2 / 0.3e1 * t107 * t248 + 0.40e2 / 0.3e1 * t251 * t248 + 0.40e2 / 0.3e1 * t113 * t255 + 0.15e2 * t258 * t255 + 0.15e2 * t119 * t262 + 0.50e2 / 0.3e1 * t265 * t262 + 0.50e2 / 0.3e1 * t125 * t269 + 0.55e2 / 0.3e1 * t272 * t269 + 0.55e2 / 0.3e1 * t131 * t277 * t54
  t282 = t239 + t281
  t284 = t137 * t154
  t286 = tau0 * t54
  t288 = -0.49793600000000000000000000000000000000000000000000e-2 * t196 - 0.62242000000000000000000000000000000000000000000000e-2 * t286
  t292 = t147 * tau0
  t295 = -0.8e1 / 0.3e1 * t145 * t195 - 0.10e2 / 0.3e1 * t292 * t54
  t297 = t152 * t173
  t302 = 0.1e1 / t51 / t159 / t50
  t311 = t168 * t150
  t314 = -0.16e2 / 0.3e1 * t158 * t302 - 0.8e1 / 0.3e1 * t165 * t195 * t150 - 0.10e2 / 0.3e1 * t165 * t162 * tau0 - 0.20e2 / 0.3e1 * t311 * t286
  t316 = t153 ** 2
  t317 = 0.1e1 / t316
  t318 = t171 * t317
  t321 = -0.15766443403838676190400000000000000000000000000001e-1 * t192 * t196 * t135 + t61 * t282 - t284 * t288 + t295 * t154 - 0.2e1 * t297 * t288 + t314 * t173 - 0.3e1 * t318 * t288
  t325 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t326 = t325 * f.p.zeta_threshold
  t328 = f.my_piecewise3(t20, t326, t21 * t19)
  t330 = 0.1e1 / t182 / t6
  t331 = t328 * t330
  t335 = t328 * t183
  t339 = t328 * t42
  t345 = 0.1e1 / t189 / t58 * t64 / t46 / t45
  t348 = 0.1e1 / t51 / t159 / t193
  t349 = t157 * t348
  t354 = 0.1e1 / t52 / t159
  t355 = s0 * t354
  t362 = t218 * t195
  t365 = t225 * t195
  t370 = t232 * t195
  t375 = t240 * t195
  t380 = t247 * t195
  t385 = t254 * t195
  t390 = t261 * t195
  t395 = -0.160e3 / 0.9e1 * t222 * t362 - 0.160e3 / 0.9e1 * t89 * t365 - 0.200e3 / 0.9e1 * t229 * t365 - 0.200e3 / 0.9e1 * t95 * t370 - 0.80e2 / 0.3e1 * t236 * t370 - 0.80e2 / 0.3e1 * t101 * t375 - 0.280e3 / 0.9e1 * t244 * t375 - 0.280e3 / 0.9e1 * t107 * t380 - 0.320e3 / 0.9e1 * t251 * t380 - 0.320e3 / 0.9e1 * t113 * t385 - 0.40e2 * t258 * t385 - 0.40e2 * t119 * t390 - 0.400e3 / 0.9e1 * t265 * t390
  t396 = t268 * t195
  t404 = tau0 ** 2
  t405 = t276 * t404
  t406 = t405 * t162
  t409 = t129 * t118
  t410 = t133 * t404
  t411 = t410 * t162
  t417 = 0.1e1 / t114 / t96
  t418 = t417 * t404
  t422 = t99 * t88
  t423 = t103 * t404
  t424 = t423 * t162
  t427 = t109 * t404
  t428 = t427 * t162
  t431 = t115 * t404
  t432 = t431 * t162
  t435 = t105 * t94
  t440 = t121 * t404
  t441 = t440 * t162
  t444 = t111 * t100
  t447 = -0.400e3 / 0.9e1 * t125 * t396 - 0.440e3 / 0.9e1 * t272 * t396 - 0.440e3 / 0.9e1 * t131 * t277 * t195 + 0.2750e4 / 0.9e1 * t125 * t406 + 0.2750e4 / 0.9e1 * t409 * t411 + 0.6050e4 / 0.9e1 * t272 * t406 + 0.1100e4 / 0.3e1 * t131 * t418 * t162 + 0.250e3 / 0.3e1 * t422 * t424 + 0.200e3 * t236 * t428 + 0.350e3 / 0.3e1 * t101 * t432 + 0.350e3 / 0.3e1 * t435 * t428 + 0.2450e4 / 0.9e1 * t244 * t432 + 0.1400e4 / 0.9e1 * t107 * t441 + 0.1400e4 / 0.9e1 * t444 * t432
  t451 = t127 * t404
  t452 = t451 * t162
  t455 = t117 * t106
  t462 = t123 * t112
  t467 = t85 * t404
  t468 = t467 * t162
  t473 = t91 * t404
  t474 = t473 * t162
  t477 = t81 * t70
  t482 = t97 * t404
  t483 = t482 * t162
  t486 = 0.3200e4 / 0.9e1 * t251 * t441 + 0.200e3 * t113 * t452 + 0.200e3 * t455 * t441 + 0.450e3 * t258 * t452 + 0.250e3 * t119 * t411 + 0.250e3 * t462 * t452 + 0.5000e4 / 0.9e1 * t265 * t411 + 0.50e2 / 0.9e1 * t71 * t468 + 0.200e3 / 0.9e1 * t208 * t468 + 0.50e2 / 0.3e1 * t77 * t474 + 0.50e2 / 0.3e1 * t477 * t468 + 0.50e2 * t215 * t474 + 0.100e3 / 0.3e1 * t83 * t483
  t487 = t87 * t76
  t494 = t93 * t82
  t501 = t204 * t195
  t506 = t211 * t195
  t516 = t63 * t404
  t517 = t162 * t79
  t520 = t75 * t404
  t523 = 0.100e3 / 0.3e1 * t487 * t474 + 0.800e3 / 0.9e1 * t222 * t483 + 0.500e3 / 0.9e1 * t89 * t424 + 0.500e3 / 0.9e1 * t494 * t483 + 0.1250e4 / 0.9e1 * t229 * t424 + 0.250e3 / 0.3e1 * t95 * t428 - 0.40e2 / 0.9e1 * t71 * t501 - 0.80e2 / 0.9e1 * t208 * t501 - 0.80e2 / 0.9e1 * t77 * t506 - 0.40e2 / 0.3e1 * t215 * t506 - 0.40e2 / 0.3e1 * t83 * t362 - 0.40e2 / 0.9e1 * t200 * t195 * t73 + 0.50e2 / 0.9e1 * t516 * t517 + 0.50e2 / 0.9e1 * t520 * t517
  t525 = t395 + t447 + t486 + t523
  t527 = t137 * t173
  t528 = t288 ** 2
  t532 = tau0 * t195
  t534 = 0.18257653333333333333333333333333333333333333333333e-1 * t355 + 0.16597866666666666666666666666666666666666666666667e-1 * t532
  t540 = 0.88e2 / 0.9e1 * t145 * t354 + 0.80e2 / 0.9e1 * t292 * t195
  t542 = t295 * t173
  t545 = t152 * t317
  t558 = t168 * t404
  t563 = 0.304e3 / 0.9e1 * t158 * t348 + 0.88e2 / 0.9e1 * t165 * t354 * t150 + 0.80e2 / 0.3e1 * t165 * t302 * tau0 + 0.200e3 / 0.9e1 * t558 * t162 + 0.160e3 / 0.9e1 * t311 * t532
  t565 = t314 * t317
  t569 = 0.1e1 / t316 / t141
  t570 = t171 * t569
  t575 = -0.76910453208598828552657694616081240888888888888897e-3 * t345 * t349 * t135 + 0.57810292480741812698133333333333333333333333333337e-1 * t192 * t355 * t135 - 0.31532886807677352380800000000000000000000000000002e-1 * t192 * t196 * t282 + t61 * t525 + 0.2e1 * t527 * t528 - t284 * t534 + t540 * t154 - 0.4e1 * t542 * t288 + 0.6e1 * t545 * t528 - 0.2e1 * t297 * t534 + t563 * t173 - 0.6e1 * t565 * t288 + 0.12e2 * t570 * t528 - 0.3e1 * t318 * t534
  t580 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t175 - t5 * t184 * t175 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t188 * t321 + t5 * t331 * t175 / 0.12e2 - t5 * t335 * t321 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t339 * t575)
  t582 = r1 <= f.p.dens_threshold
  t583 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t584 = 0.1e1 + t583
  t585 = t584 <= f.p.zeta_threshold
  t586 = t584 ** (0.1e1 / 0.3e1)
  t587 = t586 ** 2
  t588 = 0.1e1 / t587
  t590 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t591 = t590 ** 2
  t595 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t599 = f.my_piecewise3(t585, 0, 0.4e1 / 0.9e1 * t588 * t591 + 0.4e1 / 0.3e1 * t586 * t595)
  t601 = r1 ** 2
  t602 = r1 ** (0.1e1 / 0.3e1)
  t603 = t602 ** 2
  t605 = 0.1e1 / t603 / t601
  t606 = s2 * t605
  t615 = tau1 / t603 / r1
  t616 = t66 - t615
  t618 = t66 + t615
  t621 = t616 ** 2
  t623 = t618 ** 2
  t626 = t621 * t616
  t628 = t623 * t618
  t631 = t621 ** 2
  t633 = t623 ** 2
  t651 = t631 ** 2
  t653 = t633 ** 2
  t671 = t62 + t63 * t616 / t618 + t75 * t621 / t623 + t81 * t626 / t628 + t87 * t631 / t633 + t93 * t631 * t616 / t633 / t618 + t99 * t631 * t621 / t633 / t623 + t105 * t631 * t626 / t633 / t628 + t111 * t651 / t653 + t117 * t651 * t616 / t653 / t618 + t123 * t651 * t621 / t653 / t623 + t129 * t651 * t626 / t653 / t628
  t675 = 0.1e1 + 0.186726e-2 * t606 + 0.373452e-2 * t615 - t140
  t681 = 0.2e1 * t615 - t149
  t684 = t675 ** 2
  t687 = s2 ** 2
  t689 = t601 ** 2
  t697 = t681 ** 2
  t703 = (0.18040e1 - 0.64641600e0 / (0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t49 * t606)) * t671 + t137 / t675 + (t144 * s2 * t605 + t147 * t681) / t684 + (t156 * t687 / t602 / t689 / r1 + t164 * s2 * t605 * t681 + t168 * t697) / t684 / t675
  t709 = f.my_piecewise3(t585, 0, 0.4e1 / 0.3e1 * t586 * t590)
  t715 = f.my_piecewise3(t585, t326, t586 * t584)
  t721 = f.my_piecewise3(t582, 0, -0.3e1 / 0.8e1 * t5 * t599 * t42 * t703 - t5 * t709 * t183 * t703 / 0.4e1 + t5 * t715 * t330 * t703 / 0.12e2)
  t731 = t24 ** 2
  t735 = 0.6e1 * t33 - 0.6e1 * t16 / t731
  t736 = f.my_piecewise5(t10, 0, t14, 0, t735)
  t740 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t736)
  t763 = 0.1e1 / t182 / t24
  t777 = t528 * t288
  t780 = t288 * t534
  t808 = t159 ** 2
  t810 = 0.1e1 / t51 / t808
  t814 = 0.1e1 / t52 / t160
  t823 = tau0 * t354
  t828 = -0.60e2 * t171 / t316 / t153 * t777 + 0.36e2 * t570 * t780 - 0.6e1 * t137 * t317 * t777 + 0.6e1 * t527 * t780 + 0.18e2 * t295 * t317 * t528 - 0.24e2 * t152 * t569 * t777 + 0.18e2 * t545 * t780 + 0.36e2 * t314 * t569 * t528 - 0.47299330211516028571200000000000000000000000000003e-1 * t192 * t196 * t525 - 0.23073135962579648565797308384824372266666666666669e-2 * t345 * t349 * t282 + 0.17343087744222543809440000000000000000000000000001e0 * t192 * t355 * t282 + (-0.6688e4 / 0.27e2 * t158 * t810 - 0.1232e4 / 0.27e2 * t165 * t814 * t150 - 0.5440e4 / 0.27e2 * t165 * t348 * tau0 - 0.1600e4 / 0.9e1 * t558 * t302 - 0.1760e4 / 0.27e2 * t311 * t823) * t173
  t835 = t404 * tau0
  t837 = 0.1e1 / t808
  t838 = t837 * t85
  t847 = t302 * t79
  t856 = t115 * t835 * t837
  t860 = t121 * t835 * t837
  t864 = t127 * t835 * t837
  t868 = t276 * t835 * t837
  t872 = t417 * t835 * t837
  t875 = 0.250e3 / 0.9e1 * t63 * t835 * t838 + 0.500e3 / 0.9e1 * t75 * t835 * t838 + 0.250e3 / 0.9e1 * t81 * t835 * t838 - 0.400e3 / 0.9e1 * t516 * t847 - 0.400e3 / 0.9e1 * t520 * t847 + 0.440e3 / 0.27e2 * t200 * t354 * t73 + 0.12250e5 / 0.3e1 * t435 * t856 + 0.49000e5 / 0.9e1 * t244 * t860 + 0.7000e4 / 0.3e1 * t107 * t864 + 0.151250e6 / 0.9e1 * t409 * t868 + 0.60500e5 / 0.3e1 * t272 * t872
  t884 = t103 * t835 * t837
  t887 = t423 * t302
  t890 = t482 * t302
  t895 = t427 * t302
  t898 = t204 * t354
  t903 = t211 * t354
  t908 = t440 * t302
  t911 = t451 * t302
  t914 = 0.71500e5 / 0.9e1 * t131 / t114 / t102 * t835 * t837 + 0.5000e4 / 0.9e1 * t99 * t82 * t884 - 0.4000e4 / 0.9e1 * t89 * t887 - 0.4000e4 / 0.9e1 * t494 * t890 - 0.10000e5 / 0.9e1 * t229 * t887 - 0.2000e4 / 0.3e1 * t95 * t895 + 0.440e3 / 0.27e2 * t71 * t898 + 0.880e3 / 0.27e2 * t208 * t898 + 0.880e3 / 0.27e2 * t77 * t903 + 0.440e3 / 0.9e1 * t215 * t903 - 0.1600e4 * t455 * t908 - 0.3600e4 * t258 * t911
  t916 = t410 * t302
  t923 = t467 * t302
  t928 = t473 * t302
  t935 = t431 * t302
  t944 = -0.2000e4 * t119 * t916 - 0.2000e4 * t462 * t911 - 0.40000e5 / 0.9e1 * t265 * t916 - 0.400e3 / 0.9e1 * t71 * t923 - 0.1600e4 / 0.9e1 * t208 * t923 - 0.400e3 / 0.3e1 * t77 * t928 - 0.400e3 / 0.3e1 * t477 * t923 - 0.400e3 * t215 * t928 - 0.2800e4 / 0.3e1 * t101 * t935 - 0.2800e4 / 0.3e1 * t435 * t895 - 0.19600e5 / 0.9e1 * t244 * t935 - 0.11200e5 / 0.9e1 * t107 * t908
  t955 = t133 * t835 * t837
  t966 = t91 * t835 * t837
  t970 = t97 * t835 * t837
  t976 = t109 * t835 * t837
  t979 = -0.11200e5 / 0.9e1 * t444 * t935 - 0.25600e5 / 0.9e1 * t251 * t908 - 0.1600e4 * t113 * t911 + 0.55000e5 / 0.9e1 * t125 * t872 + 0.13750e5 / 0.3e1 * t129 * t112 * t955 - 0.2000e4 / 0.3e1 * t422 * t887 - 0.1600e4 * t236 * t895 + 0.2500e4 / 0.9e1 * t83 * t884 + 0.1000e4 / 0.9e1 * t87 * t70 * t966 + 0.2000e4 / 0.3e1 * t487 * t970 + 0.10000e5 / 0.9e1 * t222 * t884 + 0.5000e4 / 0.9e1 * t89 * t976
  t993 = t405 * t302
  t1010 = 0.2500e4 / 0.9e1 * t93 * t76 * t970 + 0.12500e5 / 0.9e1 * t494 * t884 + 0.6250e4 / 0.3e1 * t229 * t976 + 0.8750e4 / 0.9e1 * t95 * t856 + 0.2500e4 * t422 * t976 - 0.22000e5 / 0.9e1 * t125 * t993 - 0.22000e5 / 0.9e1 * t409 * t916 - 0.48400e5 / 0.9e1 * t272 * t993 - 0.8800e4 / 0.3e1 * t131 * t418 * t302 + 0.10000e5 / 0.3e1 * t113 * t955 + 0.7000e4 / 0.3e1 * t117 * t100 * t860 + 0.9000e4 * t455 * t864
  t1032 = t261 * t354
  t1035 = t268 * t354
  t1038 = 0.11250e5 * t258 * t955 + 0.13750e5 / 0.3e1 * t119 * t868 + 0.10000e5 / 0.3e1 * t123 * t106 * t864 + 0.12500e5 * t462 * t955 + 0.137500e6 / 0.9e1 * t265 * t868 + 0.250e3 / 0.9e1 * t71 * t966 + 0.500e3 / 0.3e1 * t208 * t966 + 0.1000e4 / 0.9e1 * t77 * t970 + 0.250e3 * t477 * t966 + 0.500e3 * t215 * t970 + 0.4400e4 / 0.27e2 * t265 * t1032 + 0.4400e4 / 0.27e2 * t125 * t1035
  t1045 = t218 * t354
  t1050 = t225 * t354
  t1055 = t232 * t354
  t1060 = t240 * t354
  t1065 = t247 * t354
  t1070 = 0.4840e4 / 0.27e2 * t272 * t1035 + 0.4840e4 / 0.27e2 * t131 * t277 * t354 + 0.440e3 / 0.9e1 * t83 * t1045 + 0.1760e4 / 0.27e2 * t222 * t1045 + 0.1760e4 / 0.27e2 * t89 * t1050 + 0.2200e4 / 0.27e2 * t229 * t1050 + 0.2200e4 / 0.27e2 * t95 * t1055 + 0.880e3 / 0.9e1 * t236 * t1055 + 0.880e3 / 0.9e1 * t101 * t1060 + 0.3080e4 / 0.27e2 * t244 * t1060 + 0.3080e4 / 0.27e2 * t107 * t1065 + 0.3520e4 / 0.27e2 * t251 * t1065
  t1071 = t254 * t354
  t1098 = 0.3520e4 / 0.27e2 * t113 * t1071 + 0.440e3 / 0.3e1 * t258 * t1071 + 0.440e3 / 0.3e1 * t119 * t1032 - 0.800e3 / 0.3e1 * t83 * t890 - 0.800e3 / 0.3e1 * t487 * t928 - 0.6400e4 / 0.9e1 * t222 * t890 + 0.56000e5 / 0.9e1 * t444 * t860 + 0.8000e4 * t251 * t864 + 0.14000e5 / 0.9e1 * t111 * t94 * t856 + 0.3500e4 * t236 * t856 + 0.14000e5 / 0.9e1 * t101 * t860 + 0.8750e4 / 0.9e1 * t105 * t88 * t976
  t1107 = s0 * t814
  t1111 = t189 ** 2
  t1113 = t45 ** 2
  t1125 = -0.85202382222222222222222222222222222222222222222221e-1 * t1107 - 0.60858844444444444444444444444444444444444444444446e-1 * t823
  t1141 = (-0.1232e4 / 0.27e2 * t145 * t814 - 0.880e3 / 0.27e2 * t292 * t354) * t154 + t61 * (t875 + t914 + t944 + t979 + t1010 + t1038 + t1070 + t1098) + 0.84601498529458711407923464077689364977777777777787e-2 * t345 * t157 * t810 * t135 - 0.26978136491012845925795555555555555555555555555557e0 * t192 * t1107 * t135 - 0.33765992082784477311386251655417364648043486408666e-3 / t1111 / t1113 * t157 * s0 / t808 / t193 * t135 - t284 * t1125 - 0.6e1 * t540 * t173 * t288 - 0.6e1 * t542 * t534 - 0.2e1 * t297 * t1125 - 0.9e1 * t563 * t317 * t288 - 0.9e1 * t565 * t534 - 0.3e1 * t318 * t1125
  t1147 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t740 * t42 * t175 - 0.3e1 / 0.8e1 * t5 * t41 * t183 * t175 - 0.9e1 / 0.8e1 * t5 * t43 * t321 + t5 * t181 * t330 * t175 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t184 * t321 - 0.9e1 / 0.8e1 * t5 * t188 * t575 - 0.5e1 / 0.36e2 * t5 * t328 * t763 * t175 + t5 * t331 * t321 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t335 * t575 - 0.3e1 / 0.8e1 * t5 * t339 * (t828 + t1141))
  t1157 = f.my_piecewise5(t14, 0, t10, 0, -t735)
  t1161 = f.my_piecewise3(t585, 0, -0.8e1 / 0.27e2 / t587 / t584 * t591 * t590 + 0.4e1 / 0.3e1 * t588 * t590 * t595 + 0.4e1 / 0.3e1 * t586 * t1157)
  t1179 = f.my_piecewise3(t582, 0, -0.3e1 / 0.8e1 * t5 * t1161 * t42 * t703 - 0.3e1 / 0.8e1 * t5 * t599 * t183 * t703 + t5 * t709 * t330 * t703 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t715 * t763 * t703)
  d111 = 0.3e1 * t580 + 0.3e1 * t721 + t6 * (t1147 + t1179)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 0.1e1 / t22 / t19
  t25 = t6 ** 2
  t26 = 0.1e1 / t25
  t28 = -t16 * t26 + t7
  t29 = f.my_piecewise5(t10, 0, t14, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t6
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t16 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t10, 0, t14, 0, t40)
  t44 = t25 ** 2
  t45 = 0.1e1 / t44
  t48 = -0.6e1 * t16 * t45 + 0.6e1 * t37
  t49 = f.my_piecewise5(t10, 0, t14, 0, t48)
  t53 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t24 * t30 * t29 + 0.4e1 / 0.3e1 * t35 * t41 + 0.4e1 / 0.3e1 * t21 * t49)
  t54 = t6 ** (0.1e1 / 0.3e1)
  t55 = t53 * t54
  t56 = 6 ** (0.1e1 / 0.3e1)
  t57 = jnp.pi ** 2
  t58 = t57 ** (0.1e1 / 0.3e1)
  t59 = t58 ** 2
  t60 = 0.1e1 / t59
  t61 = t56 * t60
  t62 = r0 ** 2
  t63 = r0 ** (0.1e1 / 0.3e1)
  t64 = t63 ** 2
  t66 = 0.1e1 / t64 / t62
  t67 = s0 * t66
  t70 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t61 * t67
  t73 = 0.18040e1 - 0.64641600e0 / t70
  t74 = params.a[0]
  t75 = params.a[1]
  t76 = t56 ** 2
  t77 = t76 * t59
  t78 = 0.3e1 / 0.10e2 * t77
  t81 = tau0 / t64 / r0
  t82 = t78 - t81
  t83 = t75 * t82
  t84 = t78 + t81
  t85 = 0.1e1 / t84
  t87 = params.a[2]
  t88 = t82 ** 2
  t89 = t87 * t88
  t90 = t84 ** 2
  t91 = 0.1e1 / t90
  t93 = params.a[3]
  t94 = t88 * t82
  t95 = t93 * t94
  t96 = t90 * t84
  t97 = 0.1e1 / t96
  t99 = params.a[4]
  t100 = t88 ** 2
  t101 = t99 * t100
  t102 = t90 ** 2
  t103 = 0.1e1 / t102
  t105 = params.a[5]
  t106 = t100 * t82
  t107 = t105 * t106
  t108 = t102 * t84
  t109 = 0.1e1 / t108
  t111 = params.a[6]
  t112 = t100 * t88
  t113 = t111 * t112
  t114 = t102 * t90
  t115 = 0.1e1 / t114
  t117 = params.a[7]
  t118 = t100 * t94
  t119 = t117 * t118
  t120 = t102 * t96
  t121 = 0.1e1 / t120
  t123 = params.a[8]
  t124 = t100 ** 2
  t125 = t123 * t124
  t126 = t102 ** 2
  t127 = 0.1e1 / t126
  t129 = params.a[9]
  t130 = t124 * t82
  t131 = t129 * t130
  t133 = 0.1e1 / t126 / t84
  t135 = params.a[10]
  t136 = t124 * t88
  t137 = t135 * t136
  t139 = 0.1e1 / t126 / t90
  t141 = params.a[11]
  t143 = t141 * t124 * t94
  t145 = 0.1e1 / t126 / t96
  t147 = t101 * t103 + t107 * t109 + t113 * t115 + t119 * t121 + t125 * t127 + t131 * t133 + t137 * t139 + t143 * t145 + t83 * t85 + t89 * t91 + t95 * t97 + t74
  t149 = params.d[0]
  t152 = 0.11203560000000000000000000000000000000000000000000e-2 * t77
  t153 = 0.1e1 + 0.186726e-2 * t67 + 0.373452e-2 * t81 - t152
  t156 = params.d[1]
  t157 = t156 * s0
  t159 = params.d[2]
  t161 = 0.3e1 / 0.5e1 * t77
  t162 = 0.2e1 * t81 - t161
  t164 = t157 * t66 + t159 * t162
  t165 = t153 ** 2
  t166 = 0.1e1 / t165
  t168 = params.d[3]
  t169 = s0 ** 2
  t170 = t168 * t169
  t171 = t62 ** 2
  t172 = t171 * r0
  t174 = 0.1e1 / t63 / t172
  t176 = params.d[4]
  t177 = t176 * s0
  t180 = params.d[5]
  t181 = t162 ** 2
  t183 = t177 * t66 * t162 + t170 * t174 + t180 * t181
  t184 = t165 * t153
  t185 = 0.1e1 / t184
  t187 = t73 * t147 + t149 / t153 + t164 * t166 + t183 * t185
  t196 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t34 * t30 + 0.4e1 / 0.3e1 * t21 * t41)
  t197 = t54 ** 2
  t198 = 0.1e1 / t197
  t199 = t196 * t198
  t203 = t196 * t54
  t204 = t70 ** 2
  t207 = 0.1e1 / t204 * t56 * t60
  t208 = t62 * r0
  t210 = 0.1e1 / t64 / t208
  t211 = s0 * t210
  t215 = t75 * tau0
  t219 = t91 * tau0
  t220 = t219 * t66
  t223 = t87 * t82
  t226 = t97 * tau0
  t227 = t226 * t66
  t230 = t93 * t88
  t233 = t103 * tau0
  t234 = t233 * t66
  t237 = t99 * t94
  t240 = t109 * tau0
  t241 = t240 * t66
  t244 = t105 * t100
  t247 = t115 * tau0
  t248 = t247 * t66
  t251 = t111 * t106
  t254 = 0.5e1 / 0.3e1 * t215 * t66 * t85 + 0.5e1 / 0.3e1 * t83 * t220 + 0.10e2 / 0.3e1 * t223 * t220 + 0.10e2 / 0.3e1 * t89 * t227 + 0.5e1 * t230 * t227 + 0.5e1 * t95 * t234 + 0.20e2 / 0.3e1 * t237 * t234 + 0.20e2 / 0.3e1 * t101 * t241 + 0.25e2 / 0.3e1 * t244 * t241 + 0.25e2 / 0.3e1 * t107 * t248 + 0.10e2 * t251 * t248
  t255 = t121 * tau0
  t256 = t255 * t66
  t259 = t117 * t112
  t262 = t127 * tau0
  t263 = t262 * t66
  t266 = t123 * t118
  t269 = t133 * tau0
  t270 = t269 * t66
  t273 = t129 * t124
  t276 = t139 * tau0
  t277 = t276 * t66
  t280 = t135 * t130
  t283 = t145 * tau0
  t284 = t283 * t66
  t287 = t141 * t136
  t291 = 0.1e1 / t126 / t102
  t292 = t291 * tau0
  t296 = 0.10e2 * t113 * t256 + 0.35e2 / 0.3e1 * t259 * t256 + 0.35e2 / 0.3e1 * t119 * t263 + 0.40e2 / 0.3e1 * t266 * t263 + 0.40e2 / 0.3e1 * t125 * t270 + 0.15e2 * t273 * t270 + 0.15e2 * t131 * t277 + 0.50e2 / 0.3e1 * t280 * t277 + 0.50e2 / 0.3e1 * t137 * t284 + 0.55e2 / 0.3e1 * t287 * t284 + 0.55e2 / 0.3e1 * t143 * t292 * t66
  t297 = t254 + t296
  t299 = t149 * t166
  t301 = tau0 * t66
  t303 = -0.49793600000000000000000000000000000000000000000000e-2 * t211 - 0.62242000000000000000000000000000000000000000000000e-2 * t301
  t307 = t159 * tau0
  t310 = -0.8e1 / 0.3e1 * t157 * t210 - 0.10e2 / 0.3e1 * t307 * t66
  t312 = t164 * t185
  t315 = t171 * t62
  t317 = 0.1e1 / t63 / t315
  t326 = t180 * t162
  t329 = -0.16e2 / 0.3e1 * t170 * t317 - 0.8e1 / 0.3e1 * t177 * t210 * t162 - 0.10e2 / 0.3e1 * t177 * t174 * tau0 - 0.20e2 / 0.3e1 * t326 * t301
  t331 = t165 ** 2
  t332 = 0.1e1 / t331
  t333 = t183 * t332
  t336 = -0.15766443403838676190400000000000000000000000000001e-1 * t207 * t211 * t147 + t73 * t297 - t299 * t303 + t310 * t166 - 0.2e1 * t312 * t303 + t329 * t185 - 0.3e1 * t333 * t303
  t342 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t29)
  t344 = 0.1e1 / t197 / t6
  t345 = t342 * t344
  t349 = t342 * t198
  t353 = t342 * t54
  t359 = 0.1e1 / t204 / t70 * t76 / t58 / t57
  t362 = 0.1e1 / t63 / t171 / t208
  t363 = t169 * t362
  t368 = 0.1e1 / t64 / t171
  t369 = s0 * t368
  t376 = t255 * t210
  t381 = t262 * t210
  t386 = t269 * t210
  t391 = t276 * t210
  t396 = t283 * t210
  t404 = tau0 ** 2
  t405 = t291 * t404
  t406 = t405 * t174
  t409 = t141 * t130
  t410 = t145 * t404
  t411 = t410 * t174
  t414 = -0.80e2 / 0.3e1 * t113 * t376 - 0.280e3 / 0.9e1 * t259 * t376 - 0.280e3 / 0.9e1 * t119 * t381 - 0.320e3 / 0.9e1 * t266 * t381 - 0.320e3 / 0.9e1 * t125 * t386 - 0.40e2 * t273 * t386 - 0.40e2 * t131 * t391 - 0.400e3 / 0.9e1 * t280 * t391 - 0.400e3 / 0.9e1 * t137 * t396 - 0.440e3 / 0.9e1 * t287 * t396 - 0.440e3 / 0.9e1 * t143 * t292 * t210 + 0.2750e4 / 0.9e1 * t137 * t406 + 0.2750e4 / 0.9e1 * t409 * t411
  t418 = 0.1e1 / t126 / t108
  t419 = t418 * t404
  t423 = t111 * t100
  t424 = t115 * t404
  t425 = t424 * t174
  t428 = t121 * t404
  t429 = t428 * t174
  t432 = t127 * t404
  t433 = t432 * t174
  t436 = t117 * t106
  t441 = t133 * t404
  t442 = t441 * t174
  t445 = t123 * t112
  t450 = t139 * t404
  t451 = t450 * t174
  t454 = t129 * t118
  t461 = 0.6050e4 / 0.9e1 * t287 * t406 + 0.1100e4 / 0.3e1 * t143 * t419 * t174 + 0.250e3 / 0.3e1 * t423 * t425 + 0.200e3 * t251 * t429 + 0.350e3 / 0.3e1 * t113 * t433 + 0.350e3 / 0.3e1 * t436 * t429 + 0.2450e4 / 0.9e1 * t259 * t433 + 0.1400e4 / 0.9e1 * t119 * t442 + 0.1400e4 / 0.9e1 * t445 * t433 + 0.3200e4 / 0.9e1 * t266 * t442 + 0.200e3 * t125 * t451 + 0.200e3 * t454 * t442 + 0.450e3 * t273 * t451 + 0.250e3 * t131 * t411
  t463 = t135 * t124
  t468 = t97 * t404
  t469 = t468 * t174
  t474 = t103 * t404
  t475 = t474 * t174
  t478 = t93 * t82
  t483 = t109 * t404
  t484 = t483 * t174
  t487 = t99 * t88
  t494 = t105 * t94
  t499 = 0.250e3 * t463 * t451 + 0.5000e4 / 0.9e1 * t280 * t411 + 0.50e2 / 0.9e1 * t83 * t469 + 0.200e3 / 0.9e1 * t223 * t469 + 0.50e2 / 0.3e1 * t89 * t475 + 0.50e2 / 0.3e1 * t478 * t469 + 0.50e2 * t230 * t475 + 0.100e3 / 0.3e1 * t95 * t484 + 0.100e3 / 0.3e1 * t487 * t475 + 0.800e3 / 0.9e1 * t237 * t484 + 0.500e3 / 0.9e1 * t101 * t425 + 0.500e3 / 0.9e1 * t494 * t484 + 0.1250e4 / 0.9e1 * t244 * t425
  t502 = t219 * t210
  t507 = t226 * t210
  t512 = t233 * t210
  t517 = t240 * t210
  t522 = t247 * t210
  t530 = t75 * t404
  t531 = t174 * t91
  t534 = t87 * t404
  t537 = 0.250e3 / 0.3e1 * t107 * t429 - 0.40e2 / 0.9e1 * t83 * t502 - 0.80e2 / 0.9e1 * t223 * t502 - 0.80e2 / 0.9e1 * t89 * t507 - 0.40e2 / 0.3e1 * t230 * t507 - 0.40e2 / 0.3e1 * t95 * t512 - 0.160e3 / 0.9e1 * t237 * t512 - 0.160e3 / 0.9e1 * t101 * t517 - 0.200e3 / 0.9e1 * t244 * t517 - 0.200e3 / 0.9e1 * t107 * t522 - 0.80e2 / 0.3e1 * t251 * t522 - 0.40e2 / 0.9e1 * t215 * t210 * t85 + 0.50e2 / 0.9e1 * t530 * t531 + 0.50e2 / 0.9e1 * t534 * t531
  t539 = t414 + t461 + t499 + t537
  t541 = t149 * t185
  t542 = t303 ** 2
  t546 = tau0 * t210
  t548 = 0.18257653333333333333333333333333333333333333333333e-1 * t369 + 0.16597866666666666666666666666666666666666666666667e-1 * t546
  t554 = 0.88e2 / 0.9e1 * t157 * t368 + 0.80e2 / 0.9e1 * t307 * t210
  t556 = t310 * t185
  t559 = t164 * t332
  t572 = t180 * t404
  t577 = 0.304e3 / 0.9e1 * t170 * t362 + 0.88e2 / 0.9e1 * t177 * t368 * t162 + 0.80e2 / 0.3e1 * t177 * t317 * tau0 + 0.200e3 / 0.9e1 * t572 * t174 + 0.160e3 / 0.9e1 * t326 * t546
  t579 = t329 * t332
  t583 = 0.1e1 / t331 / t153
  t584 = t183 * t583
  t589 = -0.76910453208598828552657694616081240888888888888897e-3 * t359 * t363 * t147 + 0.57810292480741812698133333333333333333333333333337e-1 * t207 * t369 * t147 - 0.31532886807677352380800000000000000000000000000002e-1 * t207 * t211 * t297 + t73 * t539 + 0.2e1 * t541 * t542 - t299 * t548 + t554 * t166 - 0.4e1 * t556 * t303 + 0.6e1 * t559 * t542 - 0.2e1 * t312 * t548 + t577 * t185 - 0.6e1 * t579 * t303 + 0.12e2 * t584 * t542 - 0.3e1 * t333 * t548
  t593 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t594 = t593 * f.p.zeta_threshold
  t596 = f.my_piecewise3(t20, t594, t21 * t19)
  t598 = 0.1e1 / t197 / t25
  t599 = t596 * t598
  t603 = t596 * t344
  t607 = t596 * t198
  t611 = t596 * t54
  t613 = 0.1e1 / t331 / t165
  t614 = t183 * t613
  t615 = t542 * t303
  t618 = t303 * t548
  t621 = t149 * t332
  t626 = t310 * t332
  t629 = t164 * t583
  t634 = t329 * t583
  t646 = t171 ** 2
  t648 = 0.1e1 / t63 / t646
  t652 = 0.1e1 / t64 / t172
  t661 = tau0 * t368
  t664 = -0.6688e4 / 0.27e2 * t170 * t648 - 0.1232e4 / 0.27e2 * t177 * t652 * t162 - 0.5440e4 / 0.27e2 * t177 * t362 * tau0 - 0.1600e4 / 0.9e1 * t572 * t317 - 0.1760e4 / 0.27e2 * t326 * t661
  t666 = -0.60e2 * t614 * t615 + 0.36e2 * t584 * t618 - 0.6e1 * t621 * t615 + 0.6e1 * t541 * t618 + 0.18e2 * t626 * t542 - 0.24e2 * t629 * t615 + 0.18e2 * t559 * t618 + 0.36e2 * t634 * t542 - 0.47299330211516028571200000000000000000000000000003e-1 * t207 * t211 * t539 - 0.23073135962579648565797308384824372266666666666669e-2 * t359 * t363 * t297 + 0.17343087744222543809440000000000000000000000000001e0 * t207 * t369 * t297 + t664 * t185
  t671 = -0.1232e4 / 0.27e2 * t157 * t652 - 0.880e3 / 0.27e2 * t307 * t368
  t673 = t226 * t368
  t678 = t441 * t317
  t681 = t450 * t317
  t684 = t410 * t317
  t691 = t468 * t317
  t696 = t474 * t317
  t701 = 0.880e3 / 0.27e2 * t89 * t673 + 0.440e3 / 0.9e1 * t230 * t673 - 0.1600e4 * t454 * t678 - 0.3600e4 * t273 * t681 - 0.2000e4 * t131 * t684 - 0.2000e4 * t463 * t681 - 0.40000e5 / 0.9e1 * t280 * t684 - 0.400e3 / 0.9e1 * t83 * t691 - 0.1600e4 / 0.9e1 * t223 * t691 - 0.400e3 / 0.3e1 * t89 * t696 - 0.400e3 / 0.3e1 * t478 * t691
  t704 = t432 * t317
  t707 = t428 * t317
  t720 = t404 * tau0
  t721 = t109 * t720
  t722 = 0.1e1 / t646
  t723 = t721 * t722
  t726 = t115 * t720
  t727 = t726 * t722
  t730 = t121 * t720
  t731 = t730 * t722
  t734 = t105 * t88
  t737 = -0.400e3 * t230 * t696 - 0.2800e4 / 0.3e1 * t113 * t704 - 0.2800e4 / 0.3e1 * t436 * t707 - 0.19600e5 / 0.9e1 * t259 * t704 - 0.11200e5 / 0.9e1 * t119 * t678 - 0.11200e5 / 0.9e1 * t445 * t704 - 0.25600e5 / 0.9e1 * t266 * t678 - 0.1600e4 * t125 * t681 + 0.2000e4 / 0.3e1 * t487 * t723 + 0.10000e5 / 0.9e1 * t237 * t727 + 0.5000e4 / 0.9e1 * t101 * t731 + 0.2500e4 / 0.9e1 * t734 * t723
  t743 = t127 * t720
  t744 = t743 * t722
  t747 = t129 * t112
  t748 = t133 * t720
  t749 = t748 * t722
  t752 = t145 * t720
  t753 = t752 * t722
  t756 = t291 * t720
  t757 = t756 * t722
  t760 = t135 * t118
  t761 = t139 * t720
  t762 = t761 * t722
  t769 = t103 * t720
  t770 = t769 * t722
  t777 = 0.12500e5 / 0.9e1 * t494 * t727 + 0.6250e4 / 0.3e1 * t244 * t731 + 0.8750e4 / 0.9e1 * t107 * t744 + 0.7000e4 / 0.3e1 * t747 * t749 + 0.11250e5 * t273 * t753 + 0.13750e5 / 0.3e1 * t131 * t757 + 0.10000e5 / 0.3e1 * t760 * t762 + 0.12500e5 * t463 * t753 + 0.137500e6 / 0.9e1 * t280 * t757 + 0.250e3 / 0.9e1 * t83 * t770 + 0.500e3 / 0.3e1 * t223 * t770 + 0.1000e4 / 0.9e1 * t89 * t723
  t784 = t99 * t82
  t787 = t276 * t368
  t790 = t283 * t368
  t798 = t233 * t368
  t803 = t240 * t368
  t808 = 0.250e3 * t478 * t770 + 0.500e3 * t230 * t723 + 0.2500e4 / 0.9e1 * t95 * t727 + 0.1000e4 / 0.9e1 * t784 * t770 + 0.4400e4 / 0.27e2 * t280 * t787 + 0.4400e4 / 0.27e2 * t137 * t790 + 0.4840e4 / 0.27e2 * t287 * t790 + 0.4840e4 / 0.27e2 * t143 * t292 * t368 + 0.440e3 / 0.9e1 * t95 * t798 + 0.1760e4 / 0.27e2 * t237 * t798 + 0.1760e4 / 0.27e2 * t101 * t803 + 0.2200e4 / 0.27e2 * t244 * t803
  t811 = t247 * t368
  t816 = t255 * t368
  t821 = t262 * t368
  t826 = t269 * t368
  t833 = t483 * t317
  t840 = 0.2200e4 / 0.27e2 * t107 * t811 + 0.880e3 / 0.9e1 * t251 * t811 + 0.880e3 / 0.9e1 * t113 * t816 + 0.3080e4 / 0.27e2 * t259 * t816 + 0.3080e4 / 0.27e2 * t119 * t821 + 0.3520e4 / 0.27e2 * t266 * t821 + 0.3520e4 / 0.27e2 * t125 * t826 + 0.440e3 / 0.3e1 * t273 * t826 + 0.440e3 / 0.3e1 * t131 * t787 - 0.800e3 / 0.3e1 * t95 * t833 - 0.800e3 / 0.3e1 * t487 * t696 - 0.6400e4 / 0.9e1 * t237 * t833
  t841 = t424 * t317
  t850 = t219 * t368
  t859 = t123 * t106
  t866 = t117 * t100
  t869 = -0.4000e4 / 0.9e1 * t101 * t841 - 0.4000e4 / 0.9e1 * t494 * t833 - 0.10000e5 / 0.9e1 * t244 * t841 - 0.2000e4 / 0.3e1 * t107 * t707 + 0.440e3 / 0.27e2 * t83 * t850 + 0.56000e5 / 0.9e1 * t445 * t749 + 0.8000e4 * t266 * t762 + 0.10000e5 / 0.3e1 * t125 * t753 + 0.14000e5 / 0.9e1 * t859 * t744 + 0.3500e4 * t251 * t744 + 0.14000e5 / 0.9e1 * t113 * t749 + 0.8750e4 / 0.9e1 * t866 * t731
  t880 = 0.1e1 / t126 / t114
  t881 = t880 * t720
  t885 = t111 * t94
  t890 = t405 * t317
  t900 = t418 * t720
  t901 = t900 * t722
  t904 = 0.12250e5 / 0.3e1 * t436 * t744 + 0.880e3 / 0.27e2 * t223 * t850 + 0.49000e5 / 0.9e1 * t259 * t749 + 0.7000e4 / 0.3e1 * t119 * t762 + 0.71500e5 / 0.9e1 * t143 * t881 * t722 + 0.5000e4 / 0.9e1 * t885 * t727 + 0.2500e4 * t423 * t731 - 0.22000e5 / 0.9e1 * t137 * t890 - 0.22000e5 / 0.9e1 * t409 * t684 - 0.48400e5 / 0.9e1 * t287 * t890 - 0.8800e4 / 0.3e1 * t143 * t419 * t317 + 0.55000e5 / 0.9e1 * t137 * t901
  t905 = t141 * t124
  t918 = t93 * t720
  t919 = t722 * t97
  t922 = t317 * t91
  t930 = t75 * t720
  t933 = t87 * t720
  t936 = 0.13750e5 / 0.3e1 * t905 * t753 + 0.151250e6 / 0.9e1 * t409 * t757 + 0.60500e5 / 0.3e1 * t287 * t901 - 0.2000e4 / 0.3e1 * t423 * t841 - 0.1600e4 * t251 * t707 + 0.9000e4 * t454 * t762 + 0.250e3 / 0.9e1 * t918 * t919 - 0.400e3 / 0.9e1 * t530 * t922 - 0.400e3 / 0.9e1 * t534 * t922 + 0.440e3 / 0.27e2 * t215 * t368 * t85 + 0.250e3 / 0.9e1 * t930 * t919 + 0.500e3 / 0.9e1 * t933 * t919
  t939 = t701 + t737 + t777 + t808 + t840 + t869 + t904 + t936
  t941 = t169 * t648
  t945 = s0 * t652
  t949 = t204 ** 2
  t951 = t57 ** 2
  t952 = 0.1e1 / t951
  t953 = 0.1e1 / t949 * t952
  t954 = t169 * s0
  t957 = t954 / t646 / t208
  t963 = -0.85202382222222222222222222222222222222222222222221e-1 * t945 - 0.60858844444444444444444444444444444444444444444446e-1 * t661
  t965 = t554 * t185
  t972 = t577 * t332
  t979 = t671 * t166 + t73 * t939 + 0.84601498529458711407923464077689364977777777777787e-2 * t359 * t941 * t147 - 0.26978136491012845925795555555555555555555555555557e0 * t207 * t945 * t147 - 0.33765992082784477311386251655417364648043486408666e-3 * t953 * t957 * t147 - t299 * t963 - 0.6e1 * t965 * t303 - 0.6e1 * t556 * t548 - 0.2e1 * t312 * t963 - 0.9e1 * t972 * t303 - 0.9e1 * t579 * t548 - 0.3e1 * t333 * t963
  t980 = t666 + t979
  t985 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t55 * t187 - 0.3e1 / 0.8e1 * t5 * t199 * t187 - 0.9e1 / 0.8e1 * t5 * t203 * t336 + t5 * t345 * t187 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t349 * t336 - 0.9e1 / 0.8e1 * t5 * t353 * t589 - 0.5e1 / 0.36e2 * t5 * t599 * t187 + t5 * t603 * t336 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t607 * t589 - 0.3e1 / 0.8e1 * t5 * t611 * t980)
  t987 = r1 <= f.p.dens_threshold
  t988 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t989 = 0.1e1 + t988
  t990 = t989 <= f.p.zeta_threshold
  t991 = t989 ** (0.1e1 / 0.3e1)
  t992 = t991 ** 2
  t994 = 0.1e1 / t992 / t989
  t996 = f.my_piecewise5(t14, 0, t10, 0, -t28)
  t997 = t996 ** 2
  t1001 = 0.1e1 / t992
  t1002 = t1001 * t996
  t1004 = f.my_piecewise5(t14, 0, t10, 0, -t40)
  t1008 = f.my_piecewise5(t14, 0, t10, 0, -t48)
  t1012 = f.my_piecewise3(t990, 0, -0.8e1 / 0.27e2 * t994 * t997 * t996 + 0.4e1 / 0.3e1 * t1002 * t1004 + 0.4e1 / 0.3e1 * t991 * t1008)
  t1014 = r1 ** 2
  t1015 = r1 ** (0.1e1 / 0.3e1)
  t1016 = t1015 ** 2
  t1018 = 0.1e1 / t1016 / t1014
  t1019 = s2 * t1018
  t1028 = tau1 / t1016 / r1
  t1029 = t78 - t1028
  t1031 = t78 + t1028
  t1034 = t1029 ** 2
  t1036 = t1031 ** 2
  t1039 = t1034 * t1029
  t1041 = t1036 * t1031
  t1044 = t1034 ** 2
  t1046 = t1036 ** 2
  t1064 = t1044 ** 2
  t1066 = t1046 ** 2
  t1084 = t74 + t75 * t1029 / t1031 + t87 * t1034 / t1036 + t93 * t1039 / t1041 + t99 * t1044 / t1046 + t105 * t1044 * t1029 / t1046 / t1031 + t111 * t1044 * t1034 / t1046 / t1036 + t117 * t1044 * t1039 / t1046 / t1041 + t123 * t1064 / t1066 + t129 * t1064 * t1029 / t1066 / t1031 + t135 * t1064 * t1034 / t1066 / t1036 + t141 * t1064 * t1039 / t1066 / t1041
  t1088 = 0.1e1 + 0.186726e-2 * t1019 + 0.373452e-2 * t1028 - t152
  t1094 = 0.2e1 * t1028 - t161
  t1097 = t1088 ** 2
  t1100 = s2 ** 2
  t1102 = t1014 ** 2
  t1110 = t1094 ** 2
  t1116 = (0.18040e1 - 0.64641600e0 / (0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t61 * t1019)) * t1084 + t149 / t1088 + (t156 * s2 * t1018 + t159 * t1094) / t1097 + (t168 * t1100 / t1015 / t1102 / r1 + t176 * s2 * t1018 * t1094 + t180 * t1110) / t1097 / t1088
  t1125 = f.my_piecewise3(t990, 0, 0.4e1 / 0.9e1 * t1001 * t997 + 0.4e1 / 0.3e1 * t991 * t1004)
  t1132 = f.my_piecewise3(t990, 0, 0.4e1 / 0.3e1 * t991 * t996)
  t1138 = f.my_piecewise3(t990, t594, t991 * t989)
  t1144 = f.my_piecewise3(t987, 0, -0.3e1 / 0.8e1 * t5 * t1012 * t54 * t1116 - 0.3e1 / 0.8e1 * t5 * t1125 * t198 * t1116 + t5 * t1132 * t344 * t1116 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t1138 * t598 * t1116)
  t1152 = t19 ** 2
  t1155 = t30 ** 2
  t1161 = t41 ** 2
  t1170 = -0.24e2 * t45 + 0.24e2 * t16 / t44 / t6
  t1171 = f.my_piecewise5(t10, 0, t14, 0, t1170)
  t1175 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t22 / t1152 * t1155 - 0.16e2 / 0.9e1 * t24 * t30 * t41 + 0.4e1 / 0.3e1 * t34 * t1161 + 0.16e2 / 0.9e1 * t35 * t49 + 0.4e1 / 0.3e1 * t21 * t1171)
  t1202 = 0.1e1 / t197 / t36
  t1218 = t646 * r0
  t1220 = 0.1e1 / t63 / t1218
  t1224 = 0.1e1 / t64 / t315
  t1233 = tau0 * t652
  t1244 = t404 ** 2
  t1248 = 0.1e1 / t64 / t646 / t62
  t1249 = t880 * t1244 * t1248
  t1254 = t145 * t1244 * t1248
  t1258 = t291 * t1244 * t1248
  t1262 = t418 * t1244 * t1248
  t1265 = t468 * t362
  t1268 = t474 * t362
  t1271 = 0.1e1 / t1218
  t1272 = t748 * t1271
  t1275 = t233 * t652
  t1278 = t450 * t362
  t1281 = t410 * t362
  t1288 = t226 * t652
  t1291 = t743 * t1271
  t1297 = t115 * t1244 * t1248
  t1301 = t121 * t1244 * t1248
  t1305 = t133 * t1244 * t1248
  t1308 = 0.3575000e7 / 0.27e2 * t137 * t1249 + 0.550000e6 / 0.9e1 * t141 * t118 * t1254 + 0.3025000e7 / 0.9e1 * t905 * t1258 + 0.6050000e7 / 0.9e1 * t409 * t1262 + 0.27200e5 / 0.27e2 * t478 * t1265 + 0.27200e5 / 0.9e1 * t230 * t1268 - 0.112000e6 / 0.3e1 * t747 * t1272 - 0.6160e4 / 0.27e2 * t95 * t1275 + 0.136000e6 / 0.9e1 * t463 * t1278 + 0.2720000e7 / 0.81e2 * t280 * t1281 + 0.108800e6 / 0.81e2 * t223 * t1265 + 0.27200e5 / 0.27e2 * t89 * t1268 - 0.6160e4 / 0.27e2 * t230 * t1288 - 0.196000e6 / 0.3e1 * t436 * t1291 - 0.784000e6 / 0.9e1 * t259 * t1272 + 0.50000e5 / 0.9e1 * t230 * t1297 + 0.25000e5 / 0.9e1 * t95 * t1301 + 0.350000e6 / 0.27e2 * t107 * t1305
  t1313 = t139 * t1244 * t1248
  t1326 = t127 * t1244 * t1248
  t1354 = t109 * t1244 * t1248
  t1359 = 0.70000e5 / 0.3e1 * t129 * t106 * t1305 + 0.140000e6 * t747 * t1313 + 0.300000e6 * t454 * t1254 + 0.275000e6 * t273 * t1258 + 0.275000e6 / 0.3e1 * t131 * t1262 + 0.175000e6 / 0.27e2 * t117 * t94 * t1301 + 0.1225000e7 / 0.27e2 * t866 * t1326 + 0.980000e6 / 0.9e1 * t436 * t1305 + 0.980000e6 / 0.9e1 * t259 * t1313 + 0.350000e6 / 0.9e1 * t119 * t1254 + 0.15730000e8 / 0.27e2 * t287 * t1249 + 0.5005000e7 / 0.27e2 * t143 / t126 / t120 * t1244 * t1248 + 0.25000e5 / 0.9e1 * t111 * t88 * t1297 + 0.350000e6 / 0.9e1 * t135 * t112 * t1313 + 0.2000000e7 / 0.9e1 * t760 * t1254 + 0.1375000e7 / 0.3e1 * t463 * t1258 + 0.5000e4 / 0.27e2 * t83 * t1354 + 0.40000e5 / 0.27e2 * t223 * t1354
  t1382 = t761 * t1271
  t1385 = t752 * t1271
  t1388 = t756 * t1271
  t1395 = t769 * t1271
  t1400 = t721 * t1271
  t1403 = 0.25000e5 / 0.27e2 * t89 * t1297 + 0.10000e5 / 0.3e1 * t478 * t1354 + 0.80000e5 / 0.27e2 * t784 * t1354 + 0.100000e6 / 0.9e1 * t487 * t1297 + 0.400000e6 / 0.27e2 * t237 * t1301 + 0.175000e6 / 0.27e2 * t101 * t1326 + 0.25000e5 / 0.27e2 * t105 * t82 * t1354 + 0.250000e6 / 0.27e2 * t734 * t1297 + 0.250000e6 / 0.9e1 * t494 * t1301 + 0.875000e6 / 0.27e2 * t244 * t1326 - 0.144000e6 * t454 * t1382 - 0.180000e6 * t273 * t1385 - 0.220000e6 / 0.3e1 * t131 * t1388 - 0.160000e6 / 0.3e1 * t760 * t1382 - 0.200000e6 * t463 * t1385 - 0.4000e4 / 0.9e1 * t83 * t1395 - 0.8000e4 / 0.3e1 * t223 * t1395 - 0.16000e5 / 0.9e1 * t89 * t1400
  t1408 = t900 * t1271
  t1421 = t441 * t362
  t1428 = t240 * t652
  t1431 = t219 * t652
  t1436 = t276 * t652
  t1439 = t283 * t652
  t1447 = -0.4000e4 * t478 * t1395 - 0.2200000e7 / 0.9e1 * t280 * t1388 - 0.880000e6 / 0.9e1 * t137 * t1408 - 0.220000e6 / 0.3e1 * t905 * t1385 - 0.2420000e7 / 0.9e1 * t409 * t1388 - 0.968000e6 / 0.3e1 * t287 * t1408 + 0.11000000e8 / 0.27e2 * t280 * t1262 + 0.108800e6 / 0.9e1 * t125 * t1278 + 0.108800e6 / 0.9e1 * t454 * t1421 + 0.27200e5 * t273 * t1278 - 0.24640e5 / 0.81e2 * t237 * t1275 - 0.24640e5 / 0.81e2 * t101 * t1428 - 0.12320e5 / 0.81e2 * t223 * t1431 - 0.12320e5 / 0.81e2 * t89 * t1288 - 0.61600e5 / 0.81e2 * t280 * t1436 - 0.61600e5 / 0.81e2 * t137 * t1439 - 0.67760e5 / 0.81e2 * t287 * t1439 - 0.67760e5 / 0.81e2 * t143 * t292 * t652
  t1466 = t726 * t1271
  t1469 = t730 * t1271
  t1472 = t405 * t362
  t1492 = 0.550000e6 / 0.9e1 * t125 * t1258 + 0.350000e6 / 0.27e2 * t123 * t100 * t1326 + 0.175000e6 / 0.3e1 * t423 * t1326 + 0.560000e6 / 0.9e1 * t251 * t1305 + 0.70000e5 / 0.3e1 * t113 * t1313 - 0.112000e6 / 0.3e1 * t119 * t1382 - 0.1144000e7 / 0.9e1 * t143 * t881 * t1271 - 0.80000e5 / 0.9e1 * t885 * t1466 - 0.40000e5 * t423 * t1469 + 0.1496000e7 / 0.81e2 * t137 * t1472 + 0.1496000e7 / 0.81e2 * t409 * t1281 + 0.3291200e7 / 0.81e2 * t287 * t1472 + 0.598400e6 / 0.27e2 * t143 * t419 * t362 - 0.6160e4 / 0.81e2 * t83 * t1431 - 0.896000e6 / 0.9e1 * t445 * t1272 - 0.128000e6 * t266 * t1382 - 0.160000e6 / 0.3e1 * t125 * t1385 - 0.224000e6 / 0.9e1 * t859 * t1291
  t1499 = t255 * t652
  t1502 = t262 * t652
  t1507 = t269 * t652
  t1514 = t483 * t362
  t1521 = t424 * t362
  t1526 = t247 * t652
  t1535 = -0.56000e5 * t251 * t1291 - 0.224000e6 / 0.9e1 * t113 * t1272 - 0.140000e6 / 0.9e1 * t866 * t1469 - 0.43120e5 / 0.81e2 * t259 * t1499 - 0.43120e5 / 0.81e2 * t119 * t1502 - 0.49280e5 / 0.81e2 * t266 * t1502 - 0.49280e5 / 0.81e2 * t125 * t1507 - 0.6160e4 / 0.9e1 * t273 * t1507 - 0.6160e4 / 0.9e1 * t131 * t1436 + 0.54400e5 / 0.27e2 * t95 * t1514 + 0.54400e5 / 0.27e2 * t487 * t1268 + 0.435200e6 / 0.81e2 * t237 * t1514 + 0.272000e6 / 0.81e2 * t101 * t1521 - 0.30800e5 / 0.81e2 * t244 * t1428 - 0.30800e5 / 0.81e2 * t107 * t1526 - 0.12320e5 / 0.27e2 * t251 * t1526 - 0.12320e5 / 0.27e2 * t113 * t1499 + 0.200000e6 / 0.9e1 * t885 * t1301
  t1571 = t428 * t362
  t1574 = 0.136000e6 / 0.9e1 * t131 * t1281 - 0.8000e4 * t230 * t1400 - 0.40000e5 / 0.9e1 * t95 * t1466 - 0.16000e5 / 0.9e1 * t784 * t1395 - 0.32000e5 / 0.3e1 * t487 * t1400 - 0.160000e6 / 0.9e1 * t237 * t1466 - 0.80000e5 / 0.9e1 * t101 * t1469 - 0.40000e5 / 0.9e1 * t734 * t1400 - 0.200000e6 / 0.9e1 * t494 * t1466 - 0.100000e6 / 0.3e1 * t244 * t1469 - 0.140000e6 / 0.9e1 * t107 * t1291 + 0.27200e5 / 0.81e2 * t83 * t1265 + 0.2240000e7 / 0.27e2 * t859 * t1305 + 0.560000e6 / 0.3e1 * t445 * t1313 + 0.1600000e7 / 0.9e1 * t266 * t1254 + 0.272000e6 / 0.81e2 * t494 * t1514 + 0.680000e6 / 0.81e2 * t244 * t1521 + 0.136000e6 / 0.27e2 * t107 * t1571
  t1579 = t432 * t362
  t1592 = t1271 * t97
  t1600 = t1248 * t103
  t1612 = t362 * t91
  t1620 = 0.136000e6 / 0.27e2 * t423 * t1521 + 0.108800e6 / 0.9e1 * t251 * t1571 + 0.190400e6 / 0.27e2 * t113 * t1579 + 0.190400e6 / 0.27e2 * t436 * t1571 + 0.1332800e7 / 0.81e2 * t259 * t1579 + 0.761600e6 / 0.81e2 * t119 * t1421 + 0.761600e6 / 0.81e2 * t445 * t1579 + 0.1740800e7 / 0.81e2 * t266 * t1421 - 0.4000e4 / 0.9e1 * t930 * t1592 - 0.8000e4 / 0.9e1 * t933 * t1592 - 0.4000e4 / 0.9e1 * t918 * t1592 + 0.5000e4 / 0.27e2 * t75 * t1244 * t1600 + 0.5000e4 / 0.9e1 * t87 * t1244 * t1600 + 0.5000e4 / 0.9e1 * t93 * t1244 * t1600 + 0.5000e4 / 0.27e2 * t99 * t1244 * t1600 + 0.27200e5 / 0.81e2 * t534 * t1612 + 0.27200e5 / 0.81e2 * t530 * t1612 - 0.6160e4 / 0.81e2 * t215 * t652 * t85
  t1637 = t169 ** 2
  t1648 = s0 * t1224
  t1651 = 0.48281349925925925925925925925925925925925925925925e0 * t1648 + 0.28400794074074074074074074074074074074074074074075e0 * t1233
  t1655 = t542 ** 2
  t1658 = t548 ** 2
  t1685 = (0.167200e6 / 0.81e2 * t170 * t1220 + 0.20944e5 / 0.81e2 * t177 * t1224 * t162 + 0.44000e5 / 0.27e2 * t177 * t648 * tau0 + 0.108800e6 / 0.81e2 * t572 * t362 + 0.24640e5 / 0.81e2 * t326 * t1233) * t185 + (0.20944e5 / 0.81e2 * t157 * t1224 + 0.12320e5 / 0.81e2 * t307 * t652) * t166 + t73 * (t1308 + t1359 + t1403 + t1447 + t1492 + t1535 + t1574 + t1620) - 0.13506396833113790924554500662166945859217394563467e-2 * t953 * t957 * t297 + 0.74285182582125850085049753641918202225695670099065e-2 * t953 * t954 / t646 / t171 * t147 - 0.32942848144085931399097497033069824642217505262870e-4 / t949 / t70 * t952 * t1637 / t64 / t646 / t315 * t147 * t61 - 0.12e2 * t579 * t963 - 0.3e1 * t333 * t1651 + 0.24e2 * t149 * t583 * t1655 + 0.6e1 * t541 * t1658 - 0.96e2 * t310 * t583 * t615 + 0.72e2 * t577 * t583 * t542 - 0.12e2 * t664 * t332 * t303 - 0.8e1 * t671 * t185 * t303 - t299 * t1651 - 0.12e2 * t965 * t548 - 0.8e1 * t556 * t963 - 0.2e1 * t312 * t1651 - 0.18e2 * t972 * t548 + 0.120e3 * t164 * t613 * t1655
  t1707 = t542 * t548
  t1710 = t303 * t963
  t1741 = 0.18e2 * t559 * t1658 + 0.360e3 * t183 / t331 / t184 * t1655 - 0.240e3 * t329 * t613 * t615 + 0.36e2 * t584 * t1658 + 0.36e2 * t554 * t332 * t542 - 0.46146271925159297131594616769648744533333333333338e-2 * t359 * t363 * t539 - 0.63065773615354704761600000000000000000000000000004e-1 * t207 * t211 * t939 - 0.36e2 * t621 * t1707 + 0.8e1 * t541 * t1710 + 0.72e2 * t626 * t618 - 0.144e3 * t629 * t1707 + 0.24e2 * t559 * t1710 - 0.360e3 * t614 * t1707 + 0.144e3 * t634 * t618 + 0.48e2 * t584 * t1710 + 0.34686175488445087618880000000000000000000000000002e0 * t207 * t369 * t539 - 0.83661481879131392392279870032381705366913580246922e-1 * t359 * t169 * t1220 * t147 + 0.15287610678240612691284148148148148148148148148149e1 * t207 * t1648 * t147 - 0.10791254596405138370318222222222222222222222222223e1 * t207 * t945 * t297 + 0.33840599411783484563169385631075745991111111111115e-1 * t359 * t941 * t297
  t1746 = -0.9e1 / 0.4e1 * t5 * t203 * t589 - 0.3e1 / 0.2e1 * t5 * t199 * t336 - 0.3e1 / 0.8e1 * t5 * t1175 * t54 * t187 - 0.3e1 / 0.2e1 * t5 * t55 * t336 - 0.5e1 / 0.9e1 * t5 * t342 * t598 * t187 - 0.3e1 / 0.2e1 * t5 * t349 * t589 + t5 * t196 * t344 * t187 / 0.2e1 - t5 * t53 * t198 * t187 / 0.2e1 - 0.3e1 / 0.2e1 * t5 * t353 * t980 + 0.10e2 / 0.27e2 * t5 * t596 * t1202 * t187 + t5 * t345 * t336 - t5 * t607 * t980 / 0.2e1 + t5 * t603 * t589 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t599 * t336 - 0.3e1 / 0.8e1 * t5 * t611 * (t1685 + t1741)
  t1747 = f.my_piecewise3(t1, 0, t1746)
  t1748 = t989 ** 2
  t1751 = t997 ** 2
  t1757 = t1004 ** 2
  t1763 = f.my_piecewise5(t14, 0, t10, 0, -t1170)
  t1767 = f.my_piecewise3(t990, 0, 0.40e2 / 0.81e2 / t992 / t1748 * t1751 - 0.16e2 / 0.9e1 * t994 * t997 * t1004 + 0.4e1 / 0.3e1 * t1001 * t1757 + 0.16e2 / 0.9e1 * t1002 * t1008 + 0.4e1 / 0.3e1 * t991 * t1763)
  t1789 = f.my_piecewise3(t987, 0, -0.3e1 / 0.8e1 * t5 * t1767 * t54 * t1116 - t5 * t1012 * t198 * t1116 / 0.2e1 + t5 * t1125 * t344 * t1116 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t1132 * t598 * t1116 + 0.10e2 / 0.27e2 * t5 * t1138 * t1202 * t1116)
  d1111 = 0.4e1 * t985 + 0.4e1 * t1144 + t6 * (t1747 + t1789)

  res = {'v4rho4': d1111}
  return res
