"""Generated from mgga_x_m08.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_a_raw = params.a
  if isinstance(params_a_raw, (str, bytes, dict)):
    params_a = params_a_raw
  else:
    try:
      params_a_seq = list(params_a_raw)
    except TypeError:
      params_a = params_a_raw
    else:
      params_a_seq = np.asarray(params_a_seq, dtype=np.float64)
      params_a = np.concatenate((np.array([np.nan], dtype=np.float64), params_a_seq))
  params_b_raw = params.b
  if isinstance(params_b_raw, (str, bytes, dict)):
    params_b = params_b_raw
  else:
    try:
      params_b_seq = list(params_b_raw)
    except TypeError:
      params_b = params_b_raw
    else:
      params_b_seq = np.asarray(params_b_seq, dtype=np.float64)
      params_b = np.concatenate((np.array([np.nan], dtype=np.float64), params_b_seq))

  params_rpbe_kappa = 0.552

  params_rpbe_mu = MU_GE

  params_kappa = KAPPA_PBE

  params_mu = 0.21951

  rpbe_f0 = lambda s: 1 + params_rpbe_kappa * (1 - jnp.exp(-params_rpbe_mu * s ** 2 / params_rpbe_kappa))

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  rpbe_f = lambda x: rpbe_f0(X2S * x)

  pbe_f = lambda x: pbe_f0(X2S * x)

  m08_f0 = lambda a, b, x, t: +pbe_f(x) * mgga_series_w(a, 12, t) + rpbe_f(x) * mgga_series_w(b, 12, t)

  m08_f = lambda x, u, t: m08_f0(params_a, params_b, x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, m08_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_a_raw = params.a
  if isinstance(params_a_raw, (str, bytes, dict)):
    params_a = params_a_raw
  else:
    try:
      params_a_seq = list(params_a_raw)
    except TypeError:
      params_a = params_a_raw
    else:
      params_a_seq = np.asarray(params_a_seq, dtype=np.float64)
      params_a = np.concatenate((np.array([np.nan], dtype=np.float64), params_a_seq))
  params_b_raw = params.b
  if isinstance(params_b_raw, (str, bytes, dict)):
    params_b = params_b_raw
  else:
    try:
      params_b_seq = list(params_b_raw)
    except TypeError:
      params_b = params_b_raw
    else:
      params_b_seq = np.asarray(params_b_seq, dtype=np.float64)
      params_b = np.concatenate((np.array([np.nan], dtype=np.float64), params_b_seq))

  params_rpbe_kappa = 0.552

  params_rpbe_mu = MU_GE

  params_kappa = KAPPA_PBE

  params_mu = 0.21951

  rpbe_f0 = lambda s: 1 + params_rpbe_kappa * (1 - jnp.exp(-params_rpbe_mu * s ** 2 / params_rpbe_kappa))

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  rpbe_f = lambda x: rpbe_f0(X2S * x)

  pbe_f = lambda x: pbe_f0(X2S * x)

  m08_f0 = lambda a, b, x, t: +pbe_f(x) * mgga_series_w(a, 12, t) + rpbe_f(x) * mgga_series_w(b, 12, t)

  m08_f = lambda x, u, t: m08_f0(params_a, params_b, x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, m08_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_a_raw = params.a
  if isinstance(params_a_raw, (str, bytes, dict)):
    params_a = params_a_raw
  else:
    try:
      params_a_seq = list(params_a_raw)
    except TypeError:
      params_a = params_a_raw
    else:
      params_a_seq = np.asarray(params_a_seq, dtype=np.float64)
      params_a = np.concatenate((np.array([np.nan], dtype=np.float64), params_a_seq))
  params_b_raw = params.b
  if isinstance(params_b_raw, (str, bytes, dict)):
    params_b = params_b_raw
  else:
    try:
      params_b_seq = list(params_b_raw)
    except TypeError:
      params_b = params_b_raw
    else:
      params_b_seq = np.asarray(params_b_seq, dtype=np.float64)
      params_b = np.concatenate((np.array([np.nan], dtype=np.float64), params_b_seq))

  params_rpbe_kappa = 0.552

  params_rpbe_mu = MU_GE

  params_kappa = KAPPA_PBE

  params_mu = 0.21951

  rpbe_f0 = lambda s: 1 + params_rpbe_kappa * (1 - jnp.exp(-params_rpbe_mu * s ** 2 / params_rpbe_kappa))

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  rpbe_f = lambda x: rpbe_f0(X2S * x)

  pbe_f = lambda x: pbe_f0(X2S * x)

  m08_f0 = lambda a, b, x, t: +pbe_f(x) * mgga_series_w(a, 12, t) + rpbe_f(x) * mgga_series_w(b, 12, t)

  m08_f = lambda x, u, t: m08_f0(params_a, params_b, x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, m08_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = jnp.pi ** 2
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = 0.1e1 / t31
  t33 = t28 * t32
  t34 = r0 ** 2
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / t34
  t40 = t33 * s0 * t38
  t42 = 0.8040e0 + 0.91462500000000000000000000000000000000000000000000e-2 * t40
  t45 = 0.18040e1 - 0.64641600e0 / t42
  t46 = params.a[0]
  t47 = params.a[1]
  t48 = t28 ** 2
  t50 = 0.3e1 / 0.10e2 * t48 * t31
  t52 = 0.1e1 / t36 / r0
  t53 = tau0 * t52
  t54 = t50 - t53
  t55 = t47 * t54
  t56 = t50 + t53
  t57 = 0.1e1 / t56
  t59 = params.a[2]
  t60 = t54 ** 2
  t61 = t59 * t60
  t62 = t56 ** 2
  t63 = 0.1e1 / t62
  t65 = params.a[3]
  t66 = t60 * t54
  t67 = t65 * t66
  t68 = t62 * t56
  t69 = 0.1e1 / t68
  t71 = params.a[4]
  t72 = t60 ** 2
  t73 = t71 * t72
  t74 = t62 ** 2
  t75 = 0.1e1 / t74
  t77 = params.a[5]
  t78 = t72 * t54
  t79 = t77 * t78
  t81 = 0.1e1 / t74 / t56
  t83 = params.a[6]
  t84 = t72 * t60
  t85 = t83 * t84
  t87 = 0.1e1 / t74 / t62
  t89 = params.a[7]
  t90 = t72 * t66
  t91 = t89 * t90
  t93 = 0.1e1 / t74 / t68
  t95 = params.a[8]
  t96 = t72 ** 2
  t97 = t95 * t96
  t98 = t74 ** 2
  t99 = 0.1e1 / t98
  t101 = params.a[9]
  t102 = t96 * t54
  t103 = t101 * t102
  t105 = 0.1e1 / t98 / t56
  t107 = params.a[10]
  t108 = t96 * t60
  t109 = t107 * t108
  t111 = 0.1e1 / t98 / t62
  t113 = params.a[11]
  t114 = t96 * t66
  t115 = t113 * t114
  t117 = 0.1e1 / t98 / t68
  t119 = t103 * t105 + t109 * t111 + t115 * t117 + t55 * t57 + t61 * t63 + t67 * t69 + t73 * t75 + t79 * t81 + t85 * t87 + t91 * t93 + t97 * t99 + t46
  t122 = jnp.exp(-0.93189002206715572255024750998986103655990934573863e-2 * t40)
  t124 = 0.1552e1 - 0.552e0 * t122
  t125 = params.b[0]
  t126 = params.b[1]
  t127 = t126 * t54
  t129 = params.b[2]
  t130 = t129 * t60
  t132 = params.b[3]
  t133 = t132 * t66
  t135 = params.b[4]
  t136 = t135 * t72
  t138 = params.b[5]
  t139 = t138 * t78
  t141 = params.b[6]
  t142 = t141 * t84
  t144 = params.b[7]
  t145 = t144 * t90
  t147 = params.b[8]
  t148 = t147 * t96
  t150 = params.b[9]
  t151 = t150 * t102
  t153 = params.b[10]
  t154 = t153 * t108
  t156 = params.b[11]
  t157 = t156 * t114
  t159 = t151 * t105 + t154 * t111 + t157 * t117 + t127 * t57 + t130 * t63 + t133 * t69 + t136 * t75 + t139 * t81 + t142 * t87 + t145 * t93 + t148 * t99 + t125
  t161 = t45 * t119 + t124 * t159
  t165 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t161)
  t166 = r1 <= f.p.dens_threshold
  t167 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t168 = 0.1e1 + t167
  t169 = t168 <= f.p.zeta_threshold
  t170 = t168 ** (0.1e1 / 0.3e1)
  t172 = f.my_piecewise3(t169, t22, t170 * t168)
  t173 = t172 * t26
  t174 = r1 ** 2
  t175 = r1 ** (0.1e1 / 0.3e1)
  t176 = t175 ** 2
  t178 = 0.1e1 / t176 / t174
  t180 = t33 * s2 * t178
  t182 = 0.8040e0 + 0.91462500000000000000000000000000000000000000000000e-2 * t180
  t185 = 0.18040e1 - 0.64641600e0 / t182
  t187 = 0.1e1 / t176 / r1
  t188 = tau1 * t187
  t189 = t50 - t188
  t190 = t47 * t189
  t191 = t50 + t188
  t192 = 0.1e1 / t191
  t194 = t189 ** 2
  t195 = t59 * t194
  t196 = t191 ** 2
  t197 = 0.1e1 / t196
  t199 = t194 * t189
  t200 = t65 * t199
  t201 = t196 * t191
  t202 = 0.1e1 / t201
  t204 = t194 ** 2
  t205 = t71 * t204
  t206 = t196 ** 2
  t207 = 0.1e1 / t206
  t209 = t204 * t189
  t210 = t77 * t209
  t212 = 0.1e1 / t206 / t191
  t214 = t204 * t194
  t215 = t83 * t214
  t217 = 0.1e1 / t206 / t196
  t219 = t204 * t199
  t220 = t89 * t219
  t222 = 0.1e1 / t206 / t201
  t224 = t204 ** 2
  t225 = t95 * t224
  t226 = t206 ** 2
  t227 = 0.1e1 / t226
  t229 = t224 * t189
  t230 = t101 * t229
  t232 = 0.1e1 / t226 / t191
  t234 = t224 * t194
  t235 = t107 * t234
  t237 = 0.1e1 / t226 / t196
  t239 = t224 * t199
  t240 = t113 * t239
  t242 = 0.1e1 / t226 / t201
  t244 = t190 * t192 + t195 * t197 + t200 * t202 + t205 * t207 + t210 * t212 + t215 * t217 + t220 * t222 + t225 * t227 + t230 * t232 + t235 * t237 + t240 * t242 + t46
  t247 = jnp.exp(-0.93189002206715572255024750998986103655990934573863e-2 * t180)
  t249 = 0.1552e1 - 0.552e0 * t247
  t250 = t126 * t189
  t252 = t129 * t194
  t254 = t132 * t199
  t256 = t135 * t204
  t258 = t138 * t209
  t260 = t141 * t214
  t262 = t144 * t219
  t264 = t147 * t224
  t266 = t150 * t229
  t268 = t153 * t234
  t270 = t156 * t239
  t272 = t250 * t192 + t252 * t197 + t254 * t202 + t256 * t207 + t258 * t212 + t260 * t217 + t262 * t222 + t264 * t227 + t266 * t232 + t268 * t237 + t270 * t242 + t125
  t274 = t185 * t244 + t249 * t272
  t278 = f.my_piecewise3(t166, 0, -0.3e1 / 0.8e1 * t5 * t173 * t274)
  t279 = t6 ** 2
  t281 = t16 / t279
  t282 = t7 - t281
  t283 = f.my_piecewise5(t10, 0, t14, 0, t282)
  t286 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t283)
  t291 = t26 ** 2
  t292 = 0.1e1 / t291
  t296 = t5 * t25 * t292 * t161 / 0.8e1
  t297 = t42 ** 2
  t299 = 0.1e1 / t297 * t28
  t303 = 0.1e1 / t36 / t34 / r0
  t309 = t38 * t57
  t313 = t63 * tau0 * t38
  t316 = t59 * t54
  t320 = t69 * tau0 * t38
  t323 = t65 * t60
  t327 = t75 * tau0 * t38
  t330 = t71 * t66
  t334 = t81 * tau0 * t38
  t337 = t77 * t72
  t341 = t87 * tau0 * t38
  t344 = t83 * t78
  t347 = 0.5e1 / 0.3e1 * t47 * tau0 * t309 + 0.5e1 / 0.3e1 * t55 * t313 + 0.10e2 / 0.3e1 * t316 * t313 + 0.10e2 / 0.3e1 * t61 * t320 + 0.5e1 * t323 * t320 + 0.5e1 * t67 * t327 + 0.20e2 / 0.3e1 * t330 * t327 + 0.20e2 / 0.3e1 * t73 * t334 + 0.25e2 / 0.3e1 * t337 * t334 + 0.25e2 / 0.3e1 * t79 * t341 + 0.10e2 * t344 * t341
  t349 = t93 * tau0 * t38
  t352 = t89 * t84
  t356 = t99 * tau0 * t38
  t359 = t95 * t90
  t363 = t105 * tau0 * t38
  t366 = t101 * t96
  t370 = t111 * tau0 * t38
  t373 = t107 * t102
  t377 = t117 * tau0 * t38
  t380 = t113 * t108
  t384 = 0.1e1 / t98 / t74
  t386 = t384 * tau0 * t38
  t389 = 0.10e2 * t85 * t349 + 0.35e2 / 0.3e1 * t352 * t349 + 0.35e2 / 0.3e1 * t91 * t356 + 0.40e2 / 0.3e1 * t359 * t356 + 0.40e2 / 0.3e1 * t97 * t363 + 0.15e2 * t366 * t363 + 0.15e2 * t103 * t370 + 0.50e2 / 0.3e1 * t373 * t370 + 0.50e2 / 0.3e1 * t109 * t377 + 0.55e2 / 0.3e1 * t380 * t377 + 0.55e2 / 0.3e1 * t115 * t386
  t402 = t129 * t54
  t407 = t132 * t60
  t412 = t135 * t66
  t417 = t138 * t72
  t422 = t141 * t78
  t425 = 0.5e1 / 0.3e1 * t126 * tau0 * t309 + 0.5e1 / 0.3e1 * t127 * t313 + 0.10e2 / 0.3e1 * t402 * t313 + 0.10e2 / 0.3e1 * t130 * t320 + 0.5e1 * t407 * t320 + 0.5e1 * t133 * t327 + 0.20e2 / 0.3e1 * t412 * t327 + 0.20e2 / 0.3e1 * t136 * t334 + 0.25e2 / 0.3e1 * t417 * t334 + 0.25e2 / 0.3e1 * t139 * t341 + 0.10e2 * t422 * t341
  t428 = t144 * t84
  t433 = t147 * t90
  t438 = t150 * t96
  t443 = t153 * t102
  t448 = t156 * t108
  t453 = 0.10e2 * t142 * t349 + 0.35e2 / 0.3e1 * t428 * t349 + 0.35e2 / 0.3e1 * t145 * t356 + 0.40e2 / 0.3e1 * t433 * t356 + 0.40e2 / 0.3e1 * t148 * t363 + 0.15e2 * t438 * t363 + 0.15e2 * t151 * t370 + 0.50e2 / 0.3e1 * t443 * t370 + 0.50e2 / 0.3e1 * t154 * t377 + 0.55e2 / 0.3e1 * t448 * t377 + 0.55e2 / 0.3e1 * t157 * t386
  t461 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t286 * t26 * t161 - t296 - 0.3e1 / 0.8e1 * t5 * t27 * (-0.15766086240000000000000000000000000000000000000000e-1 * t299 * t32 * s0 * t303 * t119 + t45 * (t347 + t389) - 0.13717421124828532235939643347050754458161865569272e-1 * t33 * s0 * t303 * t122 * t159 + t124 * (t425 + t453)))
  t463 = f.my_piecewise5(t14, 0, t10, 0, -t282)
  t466 = f.my_piecewise3(t169, 0, 0.4e1 / 0.3e1 * t170 * t463)
  t474 = t5 * t172 * t292 * t274 / 0.8e1
  t476 = f.my_piecewise3(t166, 0, -0.3e1 / 0.8e1 * t5 * t466 * t26 * t274 - t474)
  vrho_0_ = t165 + t278 + t6 * (t461 + t476)
  t479 = -t7 - t281
  t480 = f.my_piecewise5(t10, 0, t14, 0, t479)
  t483 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t480)
  t489 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t483 * t26 * t161 - t296)
  t491 = f.my_piecewise5(t14, 0, t10, 0, -t479)
  t494 = f.my_piecewise3(t169, 0, 0.4e1 / 0.3e1 * t170 * t491)
  t499 = t182 ** 2
  t501 = 0.1e1 / t499 * t28
  t505 = 0.1e1 / t176 / t174 / r1
  t511 = t178 * t192
  t515 = t197 * tau1 * t178
  t518 = t59 * t189
  t522 = t202 * tau1 * t178
  t525 = t65 * t194
  t529 = t207 * tau1 * t178
  t532 = t71 * t199
  t536 = t212 * tau1 * t178
  t539 = t77 * t204
  t543 = t217 * tau1 * t178
  t546 = t83 * t209
  t549 = 0.5e1 / 0.3e1 * t47 * tau1 * t511 + 0.5e1 / 0.3e1 * t190 * t515 + 0.10e2 / 0.3e1 * t518 * t515 + 0.10e2 / 0.3e1 * t195 * t522 + 0.5e1 * t525 * t522 + 0.5e1 * t200 * t529 + 0.20e2 / 0.3e1 * t532 * t529 + 0.20e2 / 0.3e1 * t205 * t536 + 0.25e2 / 0.3e1 * t539 * t536 + 0.25e2 / 0.3e1 * t210 * t543 + 0.10e2 * t546 * t543
  t551 = t222 * tau1 * t178
  t554 = t89 * t214
  t558 = t227 * tau1 * t178
  t561 = t95 * t219
  t565 = t232 * tau1 * t178
  t568 = t101 * t224
  t572 = t237 * tau1 * t178
  t575 = t107 * t229
  t579 = t242 * tau1 * t178
  t582 = t113 * t234
  t586 = 0.1e1 / t226 / t206
  t588 = t586 * tau1 * t178
  t591 = 0.10e2 * t215 * t551 + 0.35e2 / 0.3e1 * t554 * t551 + 0.35e2 / 0.3e1 * t220 * t558 + 0.40e2 / 0.3e1 * t561 * t558 + 0.40e2 / 0.3e1 * t225 * t565 + 0.15e2 * t568 * t565 + 0.15e2 * t230 * t572 + 0.50e2 / 0.3e1 * t575 * t572 + 0.50e2 / 0.3e1 * t235 * t579 + 0.55e2 / 0.3e1 * t582 * t579 + 0.55e2 / 0.3e1 * t240 * t588
  t604 = t129 * t189
  t609 = t132 * t194
  t614 = t135 * t199
  t619 = t138 * t204
  t624 = t141 * t209
  t627 = 0.5e1 / 0.3e1 * t126 * tau1 * t511 + 0.5e1 / 0.3e1 * t250 * t515 + 0.10e2 / 0.3e1 * t604 * t515 + 0.10e2 / 0.3e1 * t252 * t522 + 0.5e1 * t609 * t522 + 0.5e1 * t254 * t529 + 0.20e2 / 0.3e1 * t614 * t529 + 0.20e2 / 0.3e1 * t256 * t536 + 0.25e2 / 0.3e1 * t619 * t536 + 0.25e2 / 0.3e1 * t258 * t543 + 0.10e2 * t624 * t543
  t630 = t144 * t214
  t635 = t147 * t219
  t640 = t150 * t224
  t645 = t153 * t229
  t650 = t156 * t234
  t655 = 0.10e2 * t260 * t551 + 0.35e2 / 0.3e1 * t630 * t551 + 0.35e2 / 0.3e1 * t262 * t558 + 0.40e2 / 0.3e1 * t635 * t558 + 0.40e2 / 0.3e1 * t264 * t565 + 0.15e2 * t640 * t565 + 0.15e2 * t266 * t572 + 0.50e2 / 0.3e1 * t645 * t572 + 0.50e2 / 0.3e1 * t268 * t579 + 0.55e2 / 0.3e1 * t650 * t579 + 0.55e2 / 0.3e1 * t270 * t588
  t663 = f.my_piecewise3(t166, 0, -0.3e1 / 0.8e1 * t5 * t494 * t26 * t274 - t474 - 0.3e1 / 0.8e1 * t5 * t173 * (-0.15766086240000000000000000000000000000000000000000e-1 * t501 * t32 * s2 * t505 * t244 + t185 * (t549 + t591) - 0.13717421124828532235939643347050754458161865569272e-1 * t33 * s2 * t505 * t247 * t272 + t249 * (t627 + t655)))
  vrho_1_ = t165 + t278 + t6 * (t489 + t663)
  t678 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (0.59122823400000000000000000000000000000000000000000e-2 * t299 * t32 * t38 * t119 + 0.51440329218106995884773662551440329218106995884772e-2 * t33 * t38 * t122 * t159))
  vsigma_0_ = t6 * t678
  vsigma_1_ = 0.0e0
  t691 = f.my_piecewise3(t166, 0, -0.3e1 / 0.8e1 * t5 * t173 * (0.59122823400000000000000000000000000000000000000000e-2 * t501 * t32 * t178 * t244 + 0.51440329218106995884773662551440329218106995884772e-2 * t33 * t178 * t247 * t272))
  vsigma_2_ = t6 * t691
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t694 = t63 * t52
  t698 = t69 * t52
  t703 = t75 * t52
  t708 = t81 * t52
  t713 = t87 * t52
  t718 = -t47 * t52 * t57 - 0.2e1 * t316 * t694 - 0.3e1 * t323 * t698 - 0.4e1 * t330 * t703 - 0.5e1 * t337 * t708 - 0.6e1 * t344 * t713 - t55 * t694 - 0.2e1 * t61 * t698 - 0.3e1 * t67 * t703 - 0.4e1 * t73 * t708 - 0.5e1 * t79 * t713
  t719 = t93 * t52
  t724 = t99 * t52
  t729 = t105 * t52
  t734 = t111 * t52
  t739 = t117 * t52
  t744 = t384 * t52
  t747 = -0.9e1 * t103 * t734 - 0.10e2 * t109 * t739 - 0.11e2 * t115 * t744 - 0.7e1 * t352 * t719 - 0.8e1 * t359 * t724 - 0.9e1 * t366 * t729 - 0.10e2 * t373 * t734 - 0.11e2 * t380 * t739 - 0.6e1 * t85 * t719 - 0.7e1 * t91 * t724 - 0.8e1 * t97 * t729
  t771 = -t126 * t52 * t57 - t127 * t694 - 0.2e1 * t130 * t698 - 0.3e1 * t133 * t703 - 0.4e1 * t136 * t708 - 0.5e1 * t139 * t713 - 0.2e1 * t402 * t694 - 0.3e1 * t407 * t698 - 0.4e1 * t412 * t703 - 0.5e1 * t417 * t708 - 0.6e1 * t422 * t713
  t794 = -0.6e1 * t142 * t719 - 0.7e1 * t145 * t724 - 0.8e1 * t148 * t729 - 0.9e1 * t151 * t734 - 0.10e2 * t154 * t739 - 0.11e2 * t157 * t744 - 0.7e1 * t428 * t719 - 0.8e1 * t433 * t724 - 0.9e1 * t438 * t729 - 0.10e2 * t443 * t734 - 0.11e2 * t448 * t739
  t801 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (t45 * (t718 + t747) + t124 * (t771 + t794)))
  vtau_0_ = t6 * t801
  t804 = t197 * t187
  t808 = t202 * t187
  t813 = t207 * t187
  t818 = t212 * t187
  t823 = t217 * t187
  t828 = -t47 * t187 * t192 - t190 * t804 - 0.2e1 * t195 * t808 - 0.3e1 * t200 * t813 - 0.4e1 * t205 * t818 - 0.5e1 * t210 * t823 - 0.2e1 * t518 * t804 - 0.3e1 * t525 * t808 - 0.4e1 * t532 * t813 - 0.5e1 * t539 * t818 - 0.6e1 * t546 * t823
  t829 = t222 * t187
  t834 = t227 * t187
  t839 = t232 * t187
  t844 = t237 * t187
  t849 = t242 * t187
  t854 = t586 * t187
  t857 = -0.6e1 * t215 * t829 - 0.7e1 * t220 * t834 - 0.8e1 * t225 * t839 - 0.9e1 * t230 * t844 - 0.10e2 * t235 * t849 - 0.11e2 * t240 * t854 - 0.7e1 * t554 * t829 - 0.8e1 * t561 * t834 - 0.9e1 * t568 * t839 - 0.10e2 * t575 * t844 - 0.11e2 * t582 * t849
  t881 = -t126 * t187 * t192 - t250 * t804 - 0.2e1 * t252 * t808 - 0.3e1 * t254 * t813 - 0.4e1 * t256 * t818 - 0.5e1 * t258 * t823 - 0.2e1 * t604 * t804 - 0.3e1 * t609 * t808 - 0.4e1 * t614 * t813 - 0.5e1 * t619 * t818 - 0.6e1 * t624 * t823
  t904 = -0.6e1 * t260 * t829 - 0.7e1 * t262 * t834 - 0.8e1 * t264 * t839 - 0.9e1 * t266 * t844 - 0.10e2 * t268 * t849 - 0.11e2 * t270 * t854 - 0.7e1 * t630 * t829 - 0.8e1 * t635 * t834 - 0.9e1 * t640 * t839 - 0.10e2 * t645 * t844 - 0.11e2 * t650 * t849
  t911 = f.my_piecewise3(t166, 0, -0.3e1 / 0.8e1 * t5 * t173 * (t185 * (t828 + t857) + t249 * (t881 + t904)))
  vtau_1_ = t6 * t911
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_a_raw = params.a
  if isinstance(params_a_raw, (str, bytes, dict)):
    params_a = params_a_raw
  else:
    try:
      params_a_seq = list(params_a_raw)
    except TypeError:
      params_a = params_a_raw
    else:
      params_a_seq = np.asarray(params_a_seq, dtype=np.float64)
      params_a = np.concatenate((np.array([np.nan], dtype=np.float64), params_a_seq))
  params_b_raw = params.b
  if isinstance(params_b_raw, (str, bytes, dict)):
    params_b = params_b_raw
  else:
    try:
      params_b_seq = list(params_b_raw)
    except TypeError:
      params_b = params_b_raw
    else:
      params_b_seq = np.asarray(params_b_seq, dtype=np.float64)
      params_b = np.concatenate((np.array([np.nan], dtype=np.float64), params_b_seq))

  params_rpbe_kappa = 0.552

  params_rpbe_mu = MU_GE

  params_kappa = KAPPA_PBE

  params_mu = 0.21951

  rpbe_f0 = lambda s: 1 + params_rpbe_kappa * (1 - jnp.exp(-params_rpbe_mu * s ** 2 / params_rpbe_kappa))

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  rpbe_f = lambda x: rpbe_f0(X2S * x)

  pbe_f = lambda x: pbe_f0(X2S * x)

  m08_f0 = lambda a, b, x, t: +pbe_f(x) * mgga_series_w(a, 12, t) + rpbe_f(x) * mgga_series_w(b, 12, t)

  m08_f = lambda x, u, t: m08_f0(params_a, params_b, x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, m08_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** 2
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = 0.1e1 / t23
  t25 = t20 * t24
  t26 = 2 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = s0 * t27
  t29 = r0 ** 2
  t30 = t18 ** 2
  t32 = 0.1e1 / t30 / t29
  t34 = t25 * t28 * t32
  t36 = 0.8040e0 + 0.91462500000000000000000000000000000000000000000000e-2 * t34
  t39 = 0.18040e1 - 0.64641600e0 / t36
  t41 = params.a[1]
  t42 = t20 ** 2
  t44 = 0.3e1 / 0.10e2 * t42 * t23
  t45 = tau0 * t27
  t47 = 0.1e1 / t30 / r0
  t48 = t45 * t47
  t49 = t44 - t48
  t50 = t41 * t49
  t51 = t44 + t48
  t52 = 0.1e1 / t51
  t54 = params.a[2]
  t55 = t49 ** 2
  t56 = t54 * t55
  t57 = t51 ** 2
  t58 = 0.1e1 / t57
  t60 = params.a[3]
  t61 = t55 * t49
  t62 = t60 * t61
  t63 = t57 * t51
  t64 = 0.1e1 / t63
  t66 = params.a[4]
  t67 = t55 ** 2
  t68 = t66 * t67
  t69 = t57 ** 2
  t70 = 0.1e1 / t69
  t72 = params.a[5]
  t73 = t67 * t49
  t74 = t72 * t73
  t76 = 0.1e1 / t69 / t51
  t78 = params.a[6]
  t79 = t67 * t55
  t80 = t78 * t79
  t82 = 0.1e1 / t69 / t57
  t84 = params.a[7]
  t85 = t67 * t61
  t86 = t84 * t85
  t88 = 0.1e1 / t69 / t63
  t90 = params.a[8]
  t91 = t67 ** 2
  t92 = t90 * t91
  t93 = t69 ** 2
  t94 = 0.1e1 / t93
  t96 = params.a[9]
  t97 = t91 * t49
  t98 = t96 * t97
  t100 = 0.1e1 / t93 / t51
  t102 = params.a[10]
  t103 = t91 * t55
  t104 = t102 * t103
  t106 = 0.1e1 / t93 / t57
  t108 = params.a[11]
  t109 = t91 * t61
  t110 = t108 * t109
  t112 = 0.1e1 / t93 / t63
  t114 = t98 * t100 + t104 * t106 + t110 * t112 + t50 * t52 + t56 * t58 + t62 * t64 + t68 * t70 + t74 * t76 + t80 * t82 + t86 * t88 + t92 * t94 + params.a[0]
  t117 = jnp.exp(-0.93189002206715572255024750998986103655990934573863e-2 * t34)
  t119 = 0.1552e1 - 0.552e0 * t117
  t121 = params.b[1]
  t122 = t121 * t49
  t124 = params.b[2]
  t125 = t124 * t55
  t127 = params.b[3]
  t128 = t127 * t61
  t130 = params.b[4]
  t131 = t130 * t67
  t133 = params.b[5]
  t134 = t133 * t73
  t136 = params.b[6]
  t137 = t136 * t79
  t139 = params.b[7]
  t140 = t139 * t85
  t142 = params.b[8]
  t143 = t142 * t91
  t145 = params.b[9]
  t146 = t145 * t97
  t148 = params.b[10]
  t149 = t148 * t103
  t151 = params.b[11]
  t152 = t151 * t109
  t154 = t146 * t100 + t149 * t106 + t152 * t112 + t122 * t52 + t125 * t58 + t128 * t64 + t131 * t70 + t134 * t76 + t137 * t82 + t140 * t88 + t143 * t94 + params.b[0]
  t156 = t39 * t114 + t119 * t154
  t160 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t156)
  t166 = t36 ** 2
  t169 = 0.1e1 / t166 * t20 * t24
  t172 = 0.1e1 / t30 / t29 / r0
  t178 = t27 * t32
  t179 = t178 * t52
  t183 = t45 * t32
  t186 = t54 * t49
  t193 = t60 * t55
  t200 = t66 * t61
  t207 = t72 * t67
  t214 = t78 * t73
  t218 = 0.5e1 / 0.3e1 * t41 * tau0 * t179 + 0.5e1 / 0.3e1 * t50 * t58 * t183 + 0.10e2 / 0.3e1 * t186 * t58 * t183 + 0.10e2 / 0.3e1 * t56 * t64 * t183 + 0.5e1 * t193 * t64 * t183 + 0.5e1 * t62 * t70 * t183 + 0.20e2 / 0.3e1 * t200 * t70 * t183 + 0.20e2 / 0.3e1 * t68 * t76 * t183 + 0.25e2 / 0.3e1 * t207 * t76 * t183 + 0.25e2 / 0.3e1 * t74 * t82 * t183 + 0.10e2 * t214 * t82 * t183
  t222 = t84 * t79
  t229 = t90 * t85
  t236 = t96 * t91
  t243 = t102 * t97
  t250 = t108 * t103
  t255 = 0.1e1 / t93 / t69
  t259 = 0.10e2 * t80 * t88 * t183 + 0.35e2 / 0.3e1 * t222 * t88 * t183 + 0.35e2 / 0.3e1 * t86 * t94 * t183 + 0.40e2 / 0.3e1 * t229 * t94 * t183 + 0.40e2 / 0.3e1 * t92 * t100 * t183 + 0.15e2 * t236 * t100 * t183 + 0.15e2 * t98 * t106 * t183 + 0.50e2 / 0.3e1 * t243 * t106 * t183 + 0.50e2 / 0.3e1 * t104 * t112 * t183 + 0.55e2 / 0.3e1 * t250 * t112 * t183 + 0.55e2 / 0.3e1 * t110 * t255 * t183
  t274 = t124 * t49
  t281 = t127 * t55
  t288 = t130 * t61
  t295 = t133 * t67
  t302 = t136 * t73
  t306 = 0.5e1 / 0.3e1 * t121 * tau0 * t179 + 0.5e1 / 0.3e1 * t122 * t58 * t183 + 0.10e2 / 0.3e1 * t274 * t58 * t183 + 0.10e2 / 0.3e1 * t125 * t64 * t183 + 0.5e1 * t281 * t64 * t183 + 0.5e1 * t128 * t70 * t183 + 0.20e2 / 0.3e1 * t288 * t70 * t183 + 0.20e2 / 0.3e1 * t131 * t76 * t183 + 0.25e2 / 0.3e1 * t295 * t76 * t183 + 0.25e2 / 0.3e1 * t134 * t82 * t183 + 0.10e2 * t302 * t82 * t183
  t310 = t139 * t79
  t317 = t142 * t85
  t324 = t145 * t91
  t331 = t148 * t97
  t338 = t151 * t103
  t345 = 0.10e2 * t137 * t88 * t183 + 0.35e2 / 0.3e1 * t310 * t88 * t183 + 0.35e2 / 0.3e1 * t140 * t94 * t183 + 0.40e2 / 0.3e1 * t317 * t94 * t183 + 0.40e2 / 0.3e1 * t143 * t100 * t183 + 0.15e2 * t324 * t100 * t183 + 0.15e2 * t146 * t106 * t183 + 0.50e2 / 0.3e1 * t331 * t106 * t183 + 0.50e2 / 0.3e1 * t149 * t112 * t183 + 0.55e2 / 0.3e1 * t338 * t112 * t183 + 0.55e2 / 0.3e1 * t152 * t255 * t183
  t353 = f.my_piecewise3(t2, 0, -t6 * t17 / t30 * t156 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (-0.15766086240000000000000000000000000000000000000000e-1 * t169 * t28 * t172 * t114 + t39 * (t218 + t259) - 0.13717421124828532235939643347050754458161865569272e-1 * t25 * s0 * t27 * t172 * t117 * t154 + t119 * (t306 + t345)))
  vrho_0_ = 0.2e1 * r0 * t353 + 0.2e1 * t160
  t368 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (0.59122823400000000000000000000000000000000000000000e-2 * t169 * t178 * t114 + 0.51440329218106995884773662551440329218106995884772e-2 * t25 * t27 * t32 * t117 * t154))
  vsigma_0_ = 0.2e1 * r0 * t368
  vlapl_0_ = 0.0e0
  t371 = t47 * t52
  t374 = t58 * t27 * t47
  t379 = t64 * t27 * t47
  t385 = t70 * t27 * t47
  t391 = t76 * t27 * t47
  t397 = t82 * t27 * t47
  t402 = -t41 * t27 * t371 - 0.2e1 * t186 * t374 - 0.3e1 * t193 * t379 - 0.4e1 * t200 * t385 - 0.5e1 * t207 * t391 - 0.6e1 * t214 * t397 - t50 * t374 - 0.2e1 * t56 * t379 - 0.3e1 * t62 * t385 - 0.4e1 * t68 * t391 - 0.5e1 * t74 * t397
  t404 = t88 * t27 * t47
  t410 = t94 * t27 * t47
  t416 = t100 * t27 * t47
  t422 = t106 * t27 * t47
  t428 = t112 * t27 * t47
  t434 = t255 * t27 * t47
  t437 = -0.10e2 * t104 * t428 - 0.11e2 * t110 * t434 - 0.7e1 * t222 * t404 - 0.8e1 * t229 * t410 - 0.9e1 * t236 * t416 - 0.10e2 * t243 * t422 - 0.11e2 * t250 * t428 - 0.6e1 * t80 * t404 - 0.7e1 * t86 * t410 - 0.8e1 * t92 * t416 - 0.9e1 * t98 * t422
  t461 = -t121 * t27 * t371 - t122 * t374 - 0.2e1 * t125 * t379 - 0.3e1 * t128 * t385 - 0.4e1 * t131 * t391 - 0.5e1 * t134 * t397 - 0.2e1 * t274 * t374 - 0.3e1 * t281 * t379 - 0.4e1 * t288 * t385 - 0.5e1 * t295 * t391 - 0.6e1 * t302 * t397
  t484 = -0.6e1 * t137 * t404 - 0.7e1 * t140 * t410 - 0.8e1 * t143 * t416 - 0.9e1 * t146 * t422 - 0.10e2 * t149 * t428 - 0.11e2 * t152 * t434 - 0.7e1 * t310 * t404 - 0.8e1 * t317 * t410 - 0.9e1 * t324 * t416 - 0.10e2 * t331 * t422 - 0.11e2 * t338 * t428
  t491 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t39 * (t402 + t437) + t119 * (t461 + t484)))
  vtau_0_ = 0.2e1 * r0 * t491
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t22 = 6 ** (0.1e1 / 0.3e1)
  t23 = jnp.pi ** 2
  t24 = t23 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = 0.1e1 / t25
  t27 = t22 * t26
  t28 = 2 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = s0 * t29
  t31 = r0 ** 2
  t33 = 0.1e1 / t19 / t31
  t35 = t27 * t30 * t33
  t37 = 0.8040e0 + 0.91462500000000000000000000000000000000000000000000e-2 * t35
  t40 = 0.18040e1 - 0.64641600e0 / t37
  t42 = params.a[1]
  t43 = t22 ** 2
  t45 = 0.3e1 / 0.10e2 * t43 * t25
  t46 = tau0 * t29
  t48 = 0.1e1 / t19 / r0
  t49 = t46 * t48
  t50 = t45 - t49
  t51 = t42 * t50
  t52 = t45 + t49
  t53 = 0.1e1 / t52
  t55 = params.a[2]
  t56 = t50 ** 2
  t57 = t55 * t56
  t58 = t52 ** 2
  t59 = 0.1e1 / t58
  t61 = params.a[3]
  t62 = t56 * t50
  t63 = t61 * t62
  t64 = t58 * t52
  t65 = 0.1e1 / t64
  t67 = params.a[4]
  t68 = t56 ** 2
  t69 = t67 * t68
  t70 = t58 ** 2
  t71 = 0.1e1 / t70
  t73 = params.a[5]
  t74 = t68 * t50
  t75 = t73 * t74
  t76 = t70 * t52
  t77 = 0.1e1 / t76
  t79 = params.a[6]
  t80 = t68 * t56
  t81 = t79 * t80
  t83 = 0.1e1 / t70 / t58
  t85 = params.a[7]
  t86 = t68 * t62
  t87 = t85 * t86
  t89 = 0.1e1 / t70 / t64
  t91 = params.a[8]
  t92 = t68 ** 2
  t93 = t91 * t92
  t94 = t70 ** 2
  t95 = 0.1e1 / t94
  t97 = params.a[9]
  t98 = t92 * t50
  t99 = t97 * t98
  t101 = 0.1e1 / t94 / t52
  t103 = params.a[10]
  t104 = t92 * t56
  t105 = t103 * t104
  t107 = 0.1e1 / t94 / t58
  t109 = params.a[11]
  t110 = t92 * t62
  t111 = t109 * t110
  t113 = 0.1e1 / t94 / t64
  t115 = t99 * t101 + t105 * t107 + t111 * t113 + t51 * t53 + t57 * t59 + t63 * t65 + t69 * t71 + t75 * t77 + t81 * t83 + t87 * t89 + t93 * t95 + params.a[0]
  t118 = jnp.exp(-0.93189002206715572255024750998986103655990934573866e-2 * t35)
  t120 = 0.1552e1 - 0.552e0 * t118
  t122 = params.b[1]
  t123 = t122 * t50
  t125 = params.b[2]
  t126 = t125 * t56
  t128 = params.b[3]
  t129 = t128 * t62
  t131 = params.b[4]
  t132 = t131 * t68
  t134 = params.b[5]
  t135 = t134 * t74
  t137 = params.b[6]
  t138 = t137 * t80
  t140 = params.b[7]
  t141 = t140 * t86
  t143 = params.b[8]
  t144 = t143 * t92
  t146 = params.b[9]
  t147 = t146 * t98
  t149 = params.b[10]
  t150 = t149 * t104
  t152 = params.b[11]
  t153 = t152 * t110
  t155 = t147 * t101 + t150 * t107 + t153 * t113 + t123 * t53 + t126 * t59 + t129 * t65 + t132 * t71 + t135 * t77 + t138 * t83 + t141 * t89 + t144 * t95 + params.b[0]
  t157 = t40 * t115 + t120 * t155
  t161 = t17 * t18
  t162 = t37 ** 2
  t165 = 0.1e1 / t162 * t22 * t26
  t166 = t31 * r0
  t168 = 0.1e1 / t19 / t166
  t173 = t42 * tau0
  t175 = t29 * t33 * t53
  t178 = t51 * t59
  t179 = t46 * t33
  t182 = t55 * t50
  t183 = t182 * t59
  t186 = t57 * t65
  t189 = t61 * t56
  t190 = t189 * t65
  t193 = t63 * t71
  t196 = t67 * t62
  t197 = t196 * t71
  t200 = t69 * t77
  t203 = t73 * t68
  t204 = t203 * t77
  t207 = t75 * t83
  t210 = t79 * t74
  t211 = t210 * t83
  t214 = 0.5e1 / 0.3e1 * t173 * t175 + 0.5e1 / 0.3e1 * t178 * t179 + 0.10e2 / 0.3e1 * t183 * t179 + 0.10e2 / 0.3e1 * t186 * t179 + 0.5e1 * t190 * t179 + 0.5e1 * t193 * t179 + 0.20e2 / 0.3e1 * t197 * t179 + 0.20e2 / 0.3e1 * t200 * t179 + 0.25e2 / 0.3e1 * t204 * t179 + 0.25e2 / 0.3e1 * t207 * t179 + 0.10e2 * t211 * t179
  t215 = t81 * t89
  t218 = t85 * t80
  t219 = t218 * t89
  t222 = t87 * t95
  t225 = t91 * t86
  t226 = t225 * t95
  t229 = t93 * t101
  t232 = t97 * t92
  t233 = t232 * t101
  t236 = t99 * t107
  t239 = t103 * t98
  t240 = t239 * t107
  t243 = t105 * t113
  t246 = t109 * t104
  t247 = t246 * t113
  t251 = 0.1e1 / t94 / t70
  t252 = t111 * t251
  t255 = 0.10e2 * t215 * t179 + 0.35e2 / 0.3e1 * t219 * t179 + 0.35e2 / 0.3e1 * t222 * t179 + 0.40e2 / 0.3e1 * t226 * t179 + 0.40e2 / 0.3e1 * t229 * t179 + 0.15e2 * t233 * t179 + 0.15e2 * t236 * t179 + 0.50e2 / 0.3e1 * t240 * t179 + 0.50e2 / 0.3e1 * t243 * t179 + 0.55e2 / 0.3e1 * t247 * t179 + 0.55e2 / 0.3e1 * t252 * t179
  t256 = t214 + t255
  t258 = t27 * s0
  t259 = t29 * t168
  t260 = t118 * t155
  t264 = t122 * tau0
  t267 = t123 * t59
  t270 = t125 * t50
  t271 = t270 * t59
  t274 = t126 * t65
  t277 = t128 * t56
  t278 = t277 * t65
  t281 = t129 * t71
  t284 = t131 * t62
  t285 = t284 * t71
  t288 = t132 * t77
  t291 = t134 * t68
  t292 = t291 * t77
  t295 = t135 * t83
  t298 = t137 * t74
  t299 = t298 * t83
  t302 = 0.5e1 / 0.3e1 * t264 * t175 + 0.5e1 / 0.3e1 * t267 * t179 + 0.10e2 / 0.3e1 * t271 * t179 + 0.10e2 / 0.3e1 * t274 * t179 + 0.5e1 * t278 * t179 + 0.5e1 * t281 * t179 + 0.20e2 / 0.3e1 * t285 * t179 + 0.20e2 / 0.3e1 * t288 * t179 + 0.25e2 / 0.3e1 * t292 * t179 + 0.25e2 / 0.3e1 * t295 * t179 + 0.10e2 * t299 * t179
  t303 = t138 * t89
  t306 = t140 * t80
  t307 = t306 * t89
  t310 = t141 * t95
  t313 = t143 * t86
  t314 = t313 * t95
  t317 = t144 * t101
  t320 = t146 * t92
  t321 = t320 * t101
  t324 = t147 * t107
  t327 = t149 * t98
  t328 = t327 * t107
  t331 = t150 * t113
  t334 = t152 * t104
  t335 = t334 * t113
  t338 = t153 * t251
  t341 = 0.10e2 * t303 * t179 + 0.35e2 / 0.3e1 * t307 * t179 + 0.35e2 / 0.3e1 * t310 * t179 + 0.40e2 / 0.3e1 * t314 * t179 + 0.40e2 / 0.3e1 * t317 * t179 + 0.15e2 * t321 * t179 + 0.15e2 * t324 * t179 + 0.50e2 / 0.3e1 * t328 * t179 + 0.50e2 / 0.3e1 * t331 * t179 + 0.55e2 / 0.3e1 * t335 * t179 + 0.55e2 / 0.3e1 * t338 * t179
  t342 = t302 + t341
  t344 = -0.15766086240000000000000000000000000000000000000000e-1 * t165 * t30 * t168 * t115 + t40 * t256 - 0.13717421124828532235939643347050754458161865569273e-1 * t258 * t259 * t260 + t120 * t342
  t349 = f.my_piecewise3(t2, 0, -t6 * t21 * t157 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t161 * t344)
  t362 = 0.1e1 / t24 / t23
  t364 = s0 ** 2
  t366 = t31 ** 2
  t369 = 0.1e1 / t18 / t366 / t166
  t375 = 0.1e1 / t19 / t366
  t384 = tau0 ** 2
  t388 = 0.1e1 / t18 / t366 / r0
  t390 = t28 * t388 * t59
  t396 = t259 * t53
  t399 = t46 * t168
  t406 = t384 * t28 * t388
  t432 = 0.100e3 / 0.9e1 * t42 * t384 * t390 + 0.100e3 / 0.9e1 * t55 * t384 * t390 - 0.40e2 / 0.9e1 * t173 * t396 - 0.40e2 / 0.3e1 * t193 * t399 - 0.160e3 / 0.9e1 * t197 * t399 + 0.100e3 / 0.9e1 * t51 * t65 * t406 + 0.400e3 / 0.9e1 * t182 * t65 * t406 + 0.100e3 / 0.3e1 * t57 * t71 * t406 + 0.100e3 / 0.3e1 * t61 * t50 * t65 * t406 + 0.100e3 * t189 * t71 * t406 + 0.200e3 / 0.3e1 * t63 * t77 * t406 + 0.200e3 / 0.3e1 * t67 * t56 * t71 * t406 + 0.1600e4 / 0.9e1 * t196 * t77 * t406
  t480 = 0.1000e4 / 0.9e1 * t69 * t83 * t406 + 0.1000e4 / 0.9e1 * t73 * t62 * t77 * t406 + 0.2500e4 / 0.9e1 * t203 * t83 * t406 + 0.500e3 / 0.3e1 * t75 * t89 * t406 + 0.500e3 / 0.3e1 * t79 * t68 * t83 * t406 + 0.400e3 * t210 * t89 * t406 + 0.700e3 / 0.3e1 * t81 * t95 * t406 + 0.700e3 / 0.3e1 * t85 * t74 * t89 * t406 + 0.4900e4 / 0.9e1 * t218 * t95 * t406 + 0.2800e4 / 0.9e1 * t87 * t101 * t406 + 0.2800e4 / 0.9e1 * t91 * t80 * t95 * t406 + 0.6400e4 / 0.9e1 * t225 * t101 * t406 + 0.400e3 * t93 * t107 * t406 + 0.400e3 * t97 * t86 * t101 * t406
  t506 = 0.1e1 / t94 / t76
  t520 = 0.900e3 * t232 * t107 * t406 + 0.500e3 * t99 * t113 * t406 + 0.500e3 * t103 * t92 * t107 * t406 + 0.10000e5 / 0.9e1 * t239 * t113 * t406 + 0.5500e4 / 0.9e1 * t105 * t251 * t406 + 0.5500e4 / 0.9e1 * t109 * t98 * t113 * t406 + 0.12100e5 / 0.9e1 * t246 * t251 * t406 + 0.2200e4 / 0.3e1 * t111 * t506 * t406 - 0.40e2 * t233 * t399 - 0.40e2 * t236 * t399 - 0.400e3 / 0.9e1 * t240 * t399 - 0.400e3 / 0.9e1 * t243 * t399 - 0.440e3 / 0.9e1 * t247 * t399
  t549 = -0.440e3 / 0.9e1 * t252 * t399 - 0.160e3 / 0.9e1 * t200 * t399 - 0.200e3 / 0.9e1 * t204 * t399 - 0.200e3 / 0.9e1 * t207 * t399 - 0.80e2 / 0.3e1 * t211 * t399 - 0.80e2 / 0.3e1 * t215 * t399 - 0.280e3 / 0.9e1 * t219 * t399 - 0.280e3 / 0.9e1 * t222 * t399 - 0.320e3 / 0.9e1 * t226 * t399 - 0.320e3 / 0.9e1 * t229 * t399 - 0.40e2 / 0.9e1 * t178 * t399 - 0.80e2 / 0.9e1 * t183 * t399 - 0.80e2 / 0.9e1 * t186 * t399 - 0.40e2 / 0.3e1 * t190 * t399
  t611 = 0.500e3 / 0.3e1 * t137 * t68 * t83 * t406 + 0.400e3 * t298 * t89 * t406 + 0.700e3 / 0.3e1 * t138 * t95 * t406 + 0.700e3 / 0.3e1 * t140 * t74 * t89 * t406 + 0.4900e4 / 0.9e1 * t306 * t95 * t406 + 0.2800e4 / 0.9e1 * t141 * t101 * t406 + 0.2800e4 / 0.9e1 * t143 * t80 * t95 * t406 + 0.6400e4 / 0.9e1 * t313 * t101 * t406 + 0.400e3 * t144 * t107 * t406 + 0.400e3 * t146 * t86 * t101 * t406 + 0.900e3 * t320 * t107 * t406 + 0.500e3 * t147 * t113 * t406 + 0.500e3 * t149 * t92 * t107 * t406
  t646 = 0.10000e5 / 0.9e1 * t327 * t113 * t406 + 0.5500e4 / 0.9e1 * t150 * t251 * t406 + 0.5500e4 / 0.9e1 * t152 * t98 * t113 * t406 + 0.12100e5 / 0.9e1 * t334 * t251 * t406 + 0.2200e4 / 0.3e1 * t153 * t506 * t406 - 0.440e3 / 0.9e1 * t338 * t399 - 0.280e3 / 0.9e1 * t307 * t399 - 0.280e3 / 0.9e1 * t310 * t399 - 0.320e3 / 0.9e1 * t314 * t399 - 0.320e3 / 0.9e1 * t317 * t399 - 0.40e2 * t321 * t399 - 0.40e2 * t324 * t399 - 0.400e3 / 0.9e1 * t328 * t399 - 0.400e3 / 0.9e1 * t331 * t399
  t675 = -0.440e3 / 0.9e1 * t335 * t399 - 0.40e2 / 0.3e1 * t278 * t399 - 0.40e2 / 0.3e1 * t281 * t399 - 0.160e3 / 0.9e1 * t285 * t399 - 0.160e3 / 0.9e1 * t288 * t399 - 0.200e3 / 0.9e1 * t292 * t399 - 0.200e3 / 0.9e1 * t295 * t399 - 0.80e2 / 0.3e1 * t299 * t399 - 0.80e2 / 0.3e1 * t303 * t399 - 0.40e2 / 0.9e1 * t267 * t399 - 0.80e2 / 0.9e1 * t271 * t399 - 0.80e2 / 0.9e1 * t274 * t399 + 0.100e3 / 0.9e1 * t123 * t65 * t406
  t720 = 0.400e3 / 0.9e1 * t270 * t65 * t406 + 0.100e3 / 0.3e1 * t126 * t71 * t406 + 0.100e3 / 0.3e1 * t128 * t50 * t65 * t406 + 0.100e3 * t277 * t71 * t406 + 0.200e3 / 0.3e1 * t129 * t77 * t406 + 0.200e3 / 0.3e1 * t131 * t56 * t71 * t406 + 0.1600e4 / 0.9e1 * t284 * t77 * t406 + 0.1000e4 / 0.9e1 * t132 * t83 * t406 + 0.1000e4 / 0.9e1 * t134 * t62 * t77 * t406 + 0.2500e4 / 0.9e1 * t291 * t83 * t406 + 0.500e3 / 0.3e1 * t135 * t89 * t406 + 0.100e3 / 0.9e1 * t122 * t384 * t390 + 0.100e3 / 0.9e1 * t125 * t384 * t390 - 0.40e2 / 0.9e1 * t264 * t396
  t729 = f.my_piecewise3(t2, 0, t6 * t17 * t48 * t157 / 0.12e2 - t6 * t21 * t344 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t161 * (-0.15381393735744000000000000000000000000000000000000e-2 / t162 / t37 * t43 * t362 * t364 * t28 * t369 * t115 + 0.57808982880000000000000000000000000000000000000000e-1 * t165 * t30 * t375 * t115 - 0.31532172480000000000000000000000000000000000000000e-1 * t165 * t30 * t168 * t256 + t40 * (t432 + t480 + t520 + t549) + 0.50297210791037951531778692272519433013260173754001e-1 * t258 * t29 * t375 * t260 - 0.68176681998511621219954093094822938202828301471506e-3 * t43 * t362 * t364 * t28 * t369 * t260 - 0.27434842249657064471879286694101508916323731138546e-1 * t258 * t259 * t118 * t342 + t120 * (t611 + t646 + t675 + t720)))
  v2rho2_0_ = 0.2e1 * r0 * t729 + 0.4e1 * t349
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = 0.1e1 / t19 / r0
  t22 = t17 * t21
  t23 = 6 ** (0.1e1 / 0.3e1)
  t24 = jnp.pi ** 2
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = 0.1e1 / t26
  t28 = t23 * t27
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = s0 * t30
  t32 = r0 ** 2
  t34 = 0.1e1 / t19 / t32
  t36 = t28 * t31 * t34
  t38 = 0.8040e0 + 0.91462500000000000000000000000000000000000000000000e-2 * t36
  t41 = 0.18040e1 - 0.64641600e0 / t38
  t43 = params.a[1]
  t44 = t23 ** 2
  t46 = 0.3e1 / 0.10e2 * t44 * t26
  t47 = tau0 * t30
  t48 = t47 * t21
  t49 = t46 - t48
  t50 = t43 * t49
  t51 = t46 + t48
  t52 = 0.1e1 / t51
  t54 = params.a[2]
  t55 = t49 ** 2
  t56 = t54 * t55
  t57 = t51 ** 2
  t58 = 0.1e1 / t57
  t60 = params.a[3]
  t61 = t55 * t49
  t62 = t60 * t61
  t63 = t57 * t51
  t64 = 0.1e1 / t63
  t66 = params.a[4]
  t67 = t55 ** 2
  t68 = t66 * t67
  t69 = t57 ** 2
  t70 = 0.1e1 / t69
  t72 = params.a[5]
  t73 = t67 * t49
  t74 = t72 * t73
  t75 = t69 * t51
  t76 = 0.1e1 / t75
  t78 = params.a[6]
  t79 = t67 * t55
  t80 = t78 * t79
  t81 = t69 * t57
  t82 = 0.1e1 / t81
  t84 = params.a[7]
  t85 = t67 * t61
  t86 = t84 * t85
  t88 = 0.1e1 / t69 / t63
  t90 = params.a[8]
  t91 = t67 ** 2
  t92 = t90 * t91
  t93 = t69 ** 2
  t94 = 0.1e1 / t93
  t96 = params.a[9]
  t97 = t91 * t49
  t98 = t96 * t97
  t100 = 0.1e1 / t93 / t51
  t102 = params.a[10]
  t103 = t91 * t55
  t104 = t102 * t103
  t106 = 0.1e1 / t93 / t57
  t108 = params.a[11]
  t109 = t91 * t61
  t110 = t108 * t109
  t112 = 0.1e1 / t93 / t63
  t114 = t98 * t100 + t104 * t106 + t110 * t112 + t50 * t52 + t56 * t58 + t62 * t64 + t68 * t70 + t74 * t76 + t80 * t82 + t86 * t88 + t92 * t94 + params.a[0]
  t117 = jnp.exp(-0.93189002206715572255024750998986103655990934573866e-2 * t36)
  t119 = 0.1552e1 - 0.552e0 * t117
  t121 = params.b[1]
  t122 = t121 * t49
  t124 = params.b[2]
  t125 = t124 * t55
  t127 = params.b[3]
  t128 = t127 * t61
  t130 = params.b[4]
  t131 = t130 * t67
  t133 = params.b[5]
  t134 = t133 * t73
  t136 = params.b[6]
  t137 = t136 * t79
  t139 = params.b[7]
  t140 = t139 * t85
  t142 = params.b[8]
  t143 = t142 * t91
  t145 = params.b[9]
  t146 = t145 * t97
  t148 = params.b[10]
  t149 = t148 * t103
  t151 = params.b[11]
  t152 = t151 * t109
  t154 = t146 * t100 + t149 * t106 + t152 * t112 + t122 * t52 + t125 * t58 + t128 * t64 + t131 * t70 + t134 * t76 + t137 * t82 + t140 * t88 + t143 * t94 + params.b[0]
  t156 = t41 * t114 + t119 * t154
  t161 = t17 / t19
  t162 = t38 ** 2
  t165 = 0.1e1 / t162 * t23 * t27
  t166 = t32 * r0
  t168 = 0.1e1 / t19 / t166
  t173 = t43 * tau0
  t175 = t30 * t34 * t52
  t178 = t50 * t58
  t179 = t47 * t34
  t182 = t54 * t49
  t183 = t182 * t58
  t186 = t56 * t64
  t189 = t60 * t55
  t190 = t189 * t64
  t193 = t62 * t70
  t196 = t66 * t61
  t197 = t196 * t70
  t200 = t68 * t76
  t203 = t72 * t67
  t204 = t203 * t76
  t207 = t74 * t82
  t210 = t78 * t73
  t211 = t210 * t82
  t214 = 0.5e1 / 0.3e1 * t173 * t175 + 0.5e1 / 0.3e1 * t178 * t179 + 0.10e2 / 0.3e1 * t183 * t179 + 0.10e2 / 0.3e1 * t186 * t179 + 0.5e1 * t190 * t179 + 0.5e1 * t193 * t179 + 0.20e2 / 0.3e1 * t197 * t179 + 0.20e2 / 0.3e1 * t200 * t179 + 0.25e2 / 0.3e1 * t204 * t179 + 0.25e2 / 0.3e1 * t207 * t179 + 0.10e2 * t211 * t179
  t215 = t80 * t88
  t218 = t84 * t79
  t219 = t218 * t88
  t222 = t86 * t94
  t225 = t90 * t85
  t226 = t225 * t94
  t229 = t92 * t100
  t232 = t96 * t91
  t233 = t232 * t100
  t236 = t98 * t106
  t239 = t102 * t97
  t240 = t239 * t106
  t243 = t104 * t112
  t246 = t108 * t103
  t247 = t246 * t112
  t251 = 0.1e1 / t93 / t69
  t252 = t110 * t251
  t255 = 0.10e2 * t215 * t179 + 0.35e2 / 0.3e1 * t219 * t179 + 0.35e2 / 0.3e1 * t222 * t179 + 0.40e2 / 0.3e1 * t226 * t179 + 0.40e2 / 0.3e1 * t229 * t179 + 0.15e2 * t233 * t179 + 0.15e2 * t236 * t179 + 0.50e2 / 0.3e1 * t240 * t179 + 0.50e2 / 0.3e1 * t243 * t179 + 0.55e2 / 0.3e1 * t247 * t179 + 0.55e2 / 0.3e1 * t252 * t179
  t256 = t214 + t255
  t258 = t28 * s0
  t259 = t30 * t168
  t260 = t117 * t154
  t264 = t121 * tau0
  t267 = t122 * t58
  t270 = t124 * t49
  t271 = t270 * t58
  t274 = t125 * t64
  t277 = t127 * t55
  t278 = t277 * t64
  t281 = t128 * t70
  t284 = t130 * t61
  t285 = t284 * t70
  t288 = t131 * t76
  t291 = t133 * t67
  t292 = t291 * t76
  t295 = t134 * t82
  t298 = t136 * t73
  t299 = t298 * t82
  t302 = 0.5e1 / 0.3e1 * t264 * t175 + 0.5e1 / 0.3e1 * t267 * t179 + 0.10e2 / 0.3e1 * t271 * t179 + 0.10e2 / 0.3e1 * t274 * t179 + 0.5e1 * t278 * t179 + 0.5e1 * t281 * t179 + 0.20e2 / 0.3e1 * t285 * t179 + 0.20e2 / 0.3e1 * t288 * t179 + 0.25e2 / 0.3e1 * t292 * t179 + 0.25e2 / 0.3e1 * t295 * t179 + 0.10e2 * t299 * t179
  t303 = t137 * t88
  t306 = t139 * t79
  t307 = t306 * t88
  t310 = t140 * t94
  t313 = t142 * t85
  t314 = t313 * t94
  t317 = t143 * t100
  t320 = t145 * t91
  t321 = t320 * t100
  t324 = t146 * t106
  t327 = t148 * t97
  t328 = t327 * t106
  t331 = t149 * t112
  t334 = t151 * t103
  t335 = t334 * t112
  t338 = t152 * t251
  t341 = 0.10e2 * t303 * t179 + 0.35e2 / 0.3e1 * t307 * t179 + 0.35e2 / 0.3e1 * t310 * t179 + 0.40e2 / 0.3e1 * t314 * t179 + 0.40e2 / 0.3e1 * t317 * t179 + 0.15e2 * t321 * t179 + 0.15e2 * t324 * t179 + 0.50e2 / 0.3e1 * t328 * t179 + 0.50e2 / 0.3e1 * t331 * t179 + 0.55e2 / 0.3e1 * t335 * t179 + 0.55e2 / 0.3e1 * t338 * t179
  t342 = t302 + t341
  t344 = -0.15766086240000000000000000000000000000000000000000e-1 * t165 * t31 * t168 * t114 + t41 * t256 - 0.13717421124828532235939643347050754458161865569273e-1 * t258 * t259 * t260 + t119 * t342
  t348 = t17 * t18
  t353 = 0.1e1 / t25 / t24
  t354 = 0.1e1 / t162 / t38 * t44 * t353
  t355 = s0 ** 2
  t356 = t355 * t29
  t357 = t32 ** 2
  t360 = 0.1e1 / t18 / t357 / t166
  t366 = 0.1e1 / t19 / t357
  t375 = tau0 ** 2
  t376 = t43 * t375
  t377 = t357 * r0
  t379 = 0.1e1 / t18 / t377
  t381 = t29 * t379 * t58
  t384 = t54 * t375
  t387 = t259 * t52
  t390 = t47 * t168
  t401 = t50 * t64
  t402 = t375 * t29
  t403 = t402 * t379
  t406 = t182 * t64
  t409 = t56 * t70
  t412 = t60 * t49
  t413 = t412 * t64
  t416 = t189 * t70
  t419 = 0.100e3 / 0.9e1 * t376 * t381 + 0.100e3 / 0.9e1 * t384 * t381 - 0.40e2 / 0.9e1 * t173 * t387 - 0.80e2 / 0.9e1 * t183 * t390 - 0.80e2 / 0.9e1 * t186 * t390 - 0.40e2 / 0.3e1 * t190 * t390 - 0.40e2 / 0.3e1 * t193 * t390 - 0.160e3 / 0.9e1 * t197 * t390 + 0.100e3 / 0.9e1 * t401 * t403 + 0.400e3 / 0.9e1 * t406 * t403 + 0.100e3 / 0.3e1 * t409 * t403 + 0.100e3 / 0.3e1 * t413 * t403 + 0.100e3 * t416 * t403
  t420 = t62 * t76
  t423 = t66 * t55
  t424 = t423 * t70
  t427 = t196 * t76
  t430 = t68 * t82
  t433 = t72 * t61
  t434 = t433 * t76
  t437 = t203 * t82
  t440 = t74 * t88
  t443 = t78 * t67
  t444 = t443 * t82
  t447 = t210 * t88
  t450 = t80 * t94
  t453 = t84 * t73
  t454 = t453 * t88
  t457 = t218 * t94
  t460 = t86 * t100
  t463 = t90 * t79
  t464 = t463 * t94
  t467 = 0.200e3 / 0.3e1 * t420 * t403 + 0.200e3 / 0.3e1 * t424 * t403 + 0.1600e4 / 0.9e1 * t427 * t403 + 0.1000e4 / 0.9e1 * t430 * t403 + 0.1000e4 / 0.9e1 * t434 * t403 + 0.2500e4 / 0.9e1 * t437 * t403 + 0.500e3 / 0.3e1 * t440 * t403 + 0.500e3 / 0.3e1 * t444 * t403 + 0.400e3 * t447 * t403 + 0.700e3 / 0.3e1 * t450 * t403 + 0.700e3 / 0.3e1 * t454 * t403 + 0.4900e4 / 0.9e1 * t457 * t403 + 0.2800e4 / 0.9e1 * t460 * t403 + 0.2800e4 / 0.9e1 * t464 * t403
  t469 = t225 * t100
  t472 = t92 * t106
  t475 = t96 * t85
  t476 = t475 * t100
  t479 = t232 * t106
  t482 = t98 * t112
  t485 = t102 * t91
  t486 = t485 * t106
  t489 = t239 * t112
  t492 = t104 * t251
  t495 = t108 * t97
  t496 = t495 * t112
  t499 = t246 * t251
  t503 = 0.1e1 / t93 / t75
  t504 = t110 * t503
  t511 = 0.6400e4 / 0.9e1 * t469 * t403 + 0.400e3 * t472 * t403 + 0.400e3 * t476 * t403 + 0.900e3 * t479 * t403 + 0.500e3 * t482 * t403 + 0.500e3 * t486 * t403 + 0.10000e5 / 0.9e1 * t489 * t403 + 0.5500e4 / 0.9e1 * t492 * t403 + 0.5500e4 / 0.9e1 * t496 * t403 + 0.12100e5 / 0.9e1 * t499 * t403 + 0.2200e4 / 0.3e1 * t504 * t403 - 0.40e2 * t233 * t390 - 0.40e2 * t236 * t390
  t540 = -0.400e3 / 0.9e1 * t240 * t390 - 0.400e3 / 0.9e1 * t243 * t390 - 0.440e3 / 0.9e1 * t247 * t390 - 0.440e3 / 0.9e1 * t252 * t390 - 0.160e3 / 0.9e1 * t200 * t390 - 0.200e3 / 0.9e1 * t204 * t390 - 0.200e3 / 0.9e1 * t207 * t390 - 0.80e2 / 0.3e1 * t211 * t390 - 0.80e2 / 0.3e1 * t215 * t390 - 0.280e3 / 0.9e1 * t219 * t390 - 0.280e3 / 0.9e1 * t222 * t390 - 0.320e3 / 0.9e1 * t226 * t390 - 0.320e3 / 0.9e1 * t229 * t390 - 0.40e2 / 0.9e1 * t178 * t390
  t542 = t419 + t467 + t511 + t540
  t544 = t30 * t366
  t549 = t44 * t353 * t355
  t550 = t29 * t360
  t554 = t117 * t342
  t558 = t121 * t375
  t561 = t124 * t375
  t566 = t133 * t61
  t567 = t566 * t76
  t570 = t291 * t82
  t573 = t134 * t88
  t576 = t136 * t67
  t577 = t576 * t82
  t580 = t298 * t88
  t583 = t137 * t94
  t586 = t139 * t73
  t587 = t586 * t88
  t590 = t306 * t94
  t593 = t140 * t100
  t596 = t142 * t79
  t597 = t596 * t94
  t600 = 0.100e3 / 0.9e1 * t558 * t381 + 0.100e3 / 0.9e1 * t561 * t381 - 0.40e2 / 0.9e1 * t264 * t387 + 0.1000e4 / 0.9e1 * t567 * t403 + 0.2500e4 / 0.9e1 * t570 * t403 + 0.500e3 / 0.3e1 * t573 * t403 + 0.500e3 / 0.3e1 * t577 * t403 + 0.400e3 * t580 * t403 + 0.700e3 / 0.3e1 * t583 * t403 + 0.700e3 / 0.3e1 * t587 * t403 + 0.4900e4 / 0.9e1 * t590 * t403 + 0.2800e4 / 0.9e1 * t593 * t403 + 0.2800e4 / 0.9e1 * t597 * t403
  t601 = t313 * t100
  t604 = t143 * t106
  t607 = t145 * t85
  t608 = t607 * t100
  t611 = t320 * t106
  t614 = t146 * t112
  t617 = t148 * t91
  t618 = t617 * t106
  t621 = t327 * t112
  t624 = t149 * t251
  t627 = t151 * t97
  t628 = t627 * t112
  t631 = t334 * t251
  t634 = t152 * t503
  t643 = 0.6400e4 / 0.9e1 * t601 * t403 + 0.400e3 * t604 * t403 + 0.400e3 * t608 * t403 + 0.900e3 * t611 * t403 + 0.500e3 * t614 * t403 + 0.500e3 * t618 * t403 + 0.10000e5 / 0.9e1 * t621 * t403 + 0.5500e4 / 0.9e1 * t624 * t403 + 0.5500e4 / 0.9e1 * t628 * t403 + 0.12100e5 / 0.9e1 * t631 * t403 + 0.2200e4 / 0.3e1 * t634 * t403 - 0.440e3 / 0.9e1 * t338 * t390 - 0.280e3 / 0.9e1 * t307 * t390 - 0.280e3 / 0.9e1 * t310 * t390
  t671 = -0.320e3 / 0.9e1 * t314 * t390 - 0.320e3 / 0.9e1 * t317 * t390 - 0.40e2 * t321 * t390 - 0.40e2 * t324 * t390 - 0.400e3 / 0.9e1 * t328 * t390 - 0.400e3 / 0.9e1 * t331 * t390 - 0.440e3 / 0.9e1 * t335 * t390 - 0.40e2 / 0.3e1 * t278 * t390 - 0.40e2 / 0.3e1 * t281 * t390 - 0.160e3 / 0.9e1 * t285 * t390 - 0.160e3 / 0.9e1 * t288 * t390 - 0.200e3 / 0.9e1 * t292 * t390 - 0.200e3 / 0.9e1 * t295 * t390
  t682 = t122 * t64
  t685 = t270 * t64
  t688 = t125 * t70
  t691 = t127 * t49
  t692 = t691 * t64
  t695 = t277 * t70
  t698 = t128 * t76
  t701 = t130 * t55
  t702 = t701 * t70
  t705 = t284 * t76
  t708 = t131 * t82
  t711 = -0.80e2 / 0.3e1 * t299 * t390 - 0.80e2 / 0.3e1 * t303 * t390 - 0.40e2 / 0.9e1 * t267 * t390 - 0.80e2 / 0.9e1 * t271 * t390 - 0.80e2 / 0.9e1 * t274 * t390 + 0.100e3 / 0.9e1 * t682 * t403 + 0.400e3 / 0.9e1 * t685 * t403 + 0.100e3 / 0.3e1 * t688 * t403 + 0.100e3 / 0.3e1 * t692 * t403 + 0.100e3 * t695 * t403 + 0.200e3 / 0.3e1 * t698 * t403 + 0.200e3 / 0.3e1 * t702 * t403 + 0.1600e4 / 0.9e1 * t705 * t403 + 0.1000e4 / 0.9e1 * t708 * t403
  t713 = t600 + t643 + t671 + t711
  t715 = -0.15381393735744000000000000000000000000000000000000e-2 * t354 * t356 * t360 * t114 + 0.57808982880000000000000000000000000000000000000000e-1 * t165 * t31 * t366 * t114 - 0.31532172480000000000000000000000000000000000000000e-1 * t165 * t31 * t168 * t256 + t41 * t542 + 0.50297210791037951531778692272519433013260173754001e-1 * t258 * t544 * t260 - 0.68176681998511621219954093094822938202828301471506e-3 * t549 * t550 * t260 - 0.27434842249657064471879286694101508916323731138546e-1 * t258 * t259 * t554 + t119 * t713
  t720 = f.my_piecewise3(t2, 0, t6 * t22 * t156 / 0.12e2 - t6 * t161 * t344 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t348 * t715)
  t732 = t162 ** 2
  t734 = t24 ** 2
  t735 = 0.1e1 / t734
  t737 = t355 * s0
  t738 = t357 ** 2
  t740 = 0.1e1 / t738 / t166
  t746 = 0.1e1 / t18 / t738
  t756 = 0.1e1 / t19 / t377
  t769 = t375 * tau0
  t771 = 0.1e1 / t738
  t772 = t771 * t64
  t780 = 0.1e1 / t18 / t357 / t32
  t781 = t402 * t780
  t800 = 0.1000e4 / 0.9e1 * t60 * t769 * t772 + 0.1000e4 / 0.9e1 * t43 * t769 * t772 - 0.17600e5 / 0.3e1 * t504 * t781 - 0.22400e5 / 0.9e1 * t464 * t781 - 0.51200e5 / 0.9e1 * t469 * t781 - 0.3200e4 * t472 * t781 - 0.3200e4 * t476 * t781 - 0.7200e4 * t479 * t781 - 0.20000e5 / 0.9e1 * t437 * t781 - 0.4000e4 / 0.3e1 * t440 * t781 - 0.4000e4 / 0.3e1 * t444 * t781
  t819 = t47 * t366
  t826 = -0.3200e4 * t447 * t781 - 0.5600e4 / 0.3e1 * t450 * t781 - 0.800e3 / 0.3e1 * t413 * t781 - 0.800e3 * t416 * t781 - 0.1600e4 / 0.3e1 * t420 * t781 - 0.1600e4 / 0.3e1 * t424 * t781 - 0.12800e5 / 0.9e1 * t427 * t781 - 0.8000e4 / 0.9e1 * t430 * t781 - 0.8000e4 / 0.9e1 * t434 * t781 + 0.3080e4 / 0.27e2 * t219 * t819 + 0.440e3 / 0.9e1 * t193 * t819 + 0.1760e4 / 0.27e2 * t197 * t819
  t852 = 0.880e3 / 0.9e1 * t211 * t819 + 0.3080e4 / 0.27e2 * t222 * t819 - 0.800e3 / 0.3e1 * t409 * t781 - 0.800e3 / 0.9e1 * t401 * t781 - 0.3200e4 / 0.9e1 * t406 * t781 - 0.5600e4 / 0.3e1 * t454 * t781 - 0.39200e5 / 0.9e1 * t457 * t781 - 0.22400e5 / 0.9e1 * t460 * t781 + 0.3520e4 / 0.27e2 * t229 * t819 + 0.440e3 / 0.27e2 * t178 * t819 + 0.880e3 / 0.27e2 * t183 * t819 + 0.880e3 / 0.9e1 * t215 * t819
  t877 = 0.3520e4 / 0.27e2 * t226 * t819 + 0.880e3 / 0.27e2 * t186 * t819 + 0.440e3 / 0.9e1 * t190 * t819 + 0.440e3 / 0.3e1 * t233 * t819 + 0.440e3 / 0.3e1 * t236 * t819 + 0.4400e4 / 0.27e2 * t240 * t819 + 0.4400e4 / 0.27e2 * t243 * t819 + 0.4840e4 / 0.27e2 * t247 * t819 + 0.4840e4 / 0.27e2 * t252 * t819 + 0.1760e4 / 0.27e2 * t200 * t819 + 0.2200e4 / 0.27e2 * t204 * t819 + 0.2200e4 / 0.27e2 * t207 * t819
  t893 = t76 * t769 * t771
  t897 = t70 * t769 * t771
  t903 = t82 * t769 * t771
  t911 = -0.4000e4 * t482 * t781 - 0.4000e4 * t486 * t781 - 0.80000e5 / 0.9e1 * t489 * t781 - 0.44000e5 / 0.9e1 * t492 * t781 - 0.44000e5 / 0.9e1 * t496 * t781 - 0.96800e5 / 0.9e1 * t499 * t781 + 0.4000e4 / 0.9e1 * t56 * t893 + 0.1000e4 * t412 * t897 + 0.2000e4 * t189 * t893 + 0.10000e5 / 0.9e1 * t62 * t903 + 0.4000e4 / 0.9e1 * t66 * t49 * t897 + 0.8000e4 / 0.3e1 * t423 * t893
  t915 = t88 * t769 * t771
  t926 = t94 * t769 * t771
  t930 = t112 * t769 * t771
  t934 = t251 * t769 * t771
  t939 = t106 * t769 * t771
  t947 = t503 * t769 * t771
  t950 = 0.40000e5 / 0.9e1 * t196 * t903 + 0.20000e5 / 0.9e1 * t68 * t915 + 0.10000e5 / 0.9e1 * t72 * t55 * t893 + 0.50000e5 / 0.9e1 * t433 * t903 + 0.25000e5 / 0.3e1 * t203 * t915 + 0.35000e5 / 0.9e1 * t74 * t926 + 0.45000e5 * t232 * t930 + 0.55000e5 / 0.3e1 * t98 * t934 + 0.40000e5 / 0.3e1 * t102 * t85 * t939 + 0.50000e5 * t485 * t930 + 0.550000e6 / 0.9e1 * t239 * t934 + 0.220000e6 / 0.9e1 * t104 * t947
  t962 = 0.1e1 / t93 / t81 * t769 * t771
  t966 = t29 * t780 * t58
  t971 = t544 * t52
  t982 = t100 * t769 * t771
  t988 = 0.55000e5 / 0.3e1 * t108 * t91 * t930 + 0.605000e6 / 0.9e1 * t495 * t934 + 0.242000e6 / 0.3e1 * t246 * t947 + 0.286000e6 / 0.9e1 * t110 * t962 - 0.800e3 / 0.9e1 * t376 * t966 - 0.800e3 / 0.9e1 * t384 * t966 + 0.440e3 / 0.27e2 * t173 * t971 + 0.20000e5 / 0.9e1 * t78 * t61 * t903 + 0.10000e5 * t443 * t915 + 0.14000e5 * t210 * t926 + 0.56000e5 / 0.9e1 * t80 * t982 + 0.35000e5 / 0.9e1 * t84 * t67 * t915
  t1016 = 0.49000e5 / 0.3e1 * t453 * t926 + 0.196000e6 / 0.9e1 * t218 * t982 + 0.28000e5 / 0.3e1 * t86 * t939 + 0.56000e5 / 0.9e1 * t90 * t73 * t926 + 0.224000e6 / 0.9e1 * t463 * t982 + 0.32000e5 * t225 * t939 + 0.40000e5 / 0.3e1 * t92 * t930 + 0.28000e5 / 0.3e1 * t96 * t79 * t982 + 0.36000e5 * t475 * t939 + 0.1000e4 / 0.9e1 * t50 * t897 + 0.2000e4 / 0.3e1 * t182 * t897 + 0.2000e4 / 0.9e1 * t54 * t769 * t772
  t1066 = 0.440e3 / 0.3e1 * t324 * t819 + 0.4400e4 / 0.27e2 * t328 * t819 - 0.4000e4 * t614 * t781 - 0.4000e4 * t618 * t781 - 0.80000e5 / 0.9e1 * t621 * t781 - 0.44000e5 / 0.9e1 * t624 * t781 - 0.44000e5 / 0.9e1 * t628 * t781 - 0.96800e5 / 0.9e1 * t631 * t781 - 0.39200e5 / 0.9e1 * t590 * t781 - 0.22400e5 / 0.9e1 * t593 * t781 - 0.22400e5 / 0.9e1 * t597 * t781
  t1091 = -0.51200e5 / 0.9e1 * t601 * t781 - 0.3200e4 * t604 * t781 - 0.3200e4 * t608 * t781 - 0.7200e4 * t611 * t781 - 0.3200e4 / 0.9e1 * t685 * t781 - 0.4000e4 / 0.3e1 * t577 * t781 - 0.3200e4 * t580 * t781 - 0.5600e4 / 0.3e1 * t583 * t781 - 0.800e3 / 0.9e1 * t682 * t781 - 0.800e3 * t695 * t781 - 0.1600e4 / 0.3e1 * t698 * t781 - 0.1600e4 / 0.3e1 * t702 * t781
  t1117 = -0.12800e5 / 0.9e1 * t705 * t781 - 0.8000e4 / 0.9e1 * t708 * t781 - 0.8000e4 / 0.9e1 * t567 * t781 - 0.20000e5 / 0.9e1 * t570 * t781 - 0.4000e4 / 0.3e1 * t573 * t781 - 0.5600e4 / 0.3e1 * t587 * t781 - 0.800e3 / 0.3e1 * t688 * t781 - 0.800e3 / 0.3e1 * t692 * t781 + 0.440e3 / 0.9e1 * t281 * t819 + 0.1760e4 / 0.27e2 * t285 * t819 + 0.1760e4 / 0.27e2 * t288 * t819 + 0.2200e4 / 0.27e2 * t292 * t819
  t1142 = 0.2200e4 / 0.27e2 * t295 * t819 + 0.880e3 / 0.9e1 * t299 * t819 + 0.880e3 / 0.9e1 * t303 * t819 + 0.440e3 / 0.27e2 * t267 * t819 + 0.4400e4 / 0.27e2 * t331 * t819 + 0.4840e4 / 0.27e2 * t335 * t819 + 0.440e3 / 0.9e1 * t278 * t819 + 0.880e3 / 0.27e2 * t271 * t819 + 0.880e3 / 0.27e2 * t274 * t819 - 0.17600e5 / 0.3e1 * t634 * t781 + 0.4840e4 / 0.27e2 * t338 * t819 + 0.3080e4 / 0.27e2 * t307 * t819
  t1171 = 0.3080e4 / 0.27e2 * t310 * t819 + 0.3520e4 / 0.27e2 * t314 * t819 + 0.3520e4 / 0.27e2 * t317 * t819 + 0.440e3 / 0.3e1 * t321 * t819 + 0.55000e5 / 0.3e1 * t146 * t934 + 0.40000e5 / 0.3e1 * t148 * t85 * t939 + 0.50000e5 * t617 * t930 + 0.550000e6 / 0.9e1 * t327 * t934 + 0.220000e6 / 0.9e1 * t149 * t947 + 0.55000e5 / 0.3e1 * t151 * t91 * t930 + 0.605000e6 / 0.9e1 * t627 * t934 + 0.242000e6 / 0.3e1 * t334 * t947
  t1197 = 0.286000e6 / 0.9e1 * t152 * t962 - 0.800e3 / 0.9e1 * t561 * t966 + 0.1000e4 / 0.9e1 * t122 * t897 + 0.2000e4 / 0.3e1 * t270 * t897 + 0.4000e4 / 0.9e1 * t125 * t893 + 0.1000e4 * t691 * t897 + 0.2000e4 * t277 * t893 + 0.10000e5 / 0.9e1 * t128 * t903 + 0.4000e4 / 0.9e1 * t130 * t49 * t897 + 0.8000e4 / 0.3e1 * t701 * t893 + 0.40000e5 / 0.9e1 * t284 * t903 + 0.20000e5 / 0.9e1 * t131 * t915
  t1226 = 0.10000e5 / 0.9e1 * t133 * t55 * t893 + 0.50000e5 / 0.9e1 * t566 * t903 + 0.25000e5 / 0.3e1 * t291 * t915 + 0.35000e5 / 0.9e1 * t134 * t926 + 0.20000e5 / 0.9e1 * t136 * t61 * t903 + 0.10000e5 * t576 * t915 + 0.14000e5 * t298 * t926 + 0.56000e5 / 0.9e1 * t137 * t982 + 0.35000e5 / 0.9e1 * t139 * t67 * t915 + 0.49000e5 / 0.3e1 * t586 * t926 + 0.196000e6 / 0.9e1 * t306 * t982 + 0.28000e5 / 0.3e1 * t140 * t939
  t1256 = 0.56000e5 / 0.9e1 * t142 * t73 * t926 + 0.224000e6 / 0.9e1 * t596 * t982 + 0.32000e5 * t313 * t939 + 0.40000e5 / 0.3e1 * t143 * t930 + 0.28000e5 / 0.3e1 * t145 * t79 * t982 - 0.800e3 / 0.9e1 * t558 * t966 + 0.440e3 / 0.27e2 * t264 * t971 + 0.36000e5 * t607 * t939 + 0.45000e5 * t320 * t930 + 0.1000e4 / 0.9e1 * t127 * t769 * t772 + 0.1000e4 / 0.9e1 * t121 * t769 * t772 + 0.2000e4 / 0.9e1 * t124 * t769 * t772
  t1261 = -0.13505478955732661760000000000000000000000000000000e-2 / t732 * t735 * t737 * t740 * t114 + 0.16919533109318400000000000000000000000000000000000e-1 * t354 * t356 * t746 * t114 - 0.46144181207232000000000000000000000000000000000000e-2 * t354 * t356 * t360 * t256 - 0.26977525344000000000000000000000000000000000000000e0 * t165 * t31 * t756 * t114 + 0.17342694864000000000000000000000000000000000000000e0 * t165 * t31 * t366 * t256 - 0.47298258720000000000000000000000000000000000000000e-1 * t165 * t31 * t168 * t542 + t41 * (t800 + t826 + t852 + t877 + t911 + t950 + t988 + t1016) - 0.23472031702484377381496723060509068739521414418534e0 * t258 * t30 * t756 * t260 + 0.74994350198362783341949502404305232023111131618657e-2 * t549 * t29 * t746 * t260 + 0.15089163237311385459533607681755829903978052126200e0 * t258 * t544 * t554 - 0.20330614301458704962114299843389675613654291605984e-3 * t735 * t737 * t740 * t117 * t154 - 0.20453004599553486365986227928446881460848490441452e-2 * t549 * t550 * t554 - 0.41152263374485596707818930041152263374485596707819e-1 * t258 * t259 * t117 * t713 + t119 * (t1066 + t1091 + t1117 + t1142 + t1171 + t1197 + t1226 + t1256)
  t1266 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t34 * t156 + t6 * t22 * t344 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t161 * t715 - 0.3e1 / 0.8e1 * t6 * t348 * t1261)
  v3rho3_0_ = 0.2e1 * r0 * t1266 + 0.6e1 * t720

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t23 = t17 * t22
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = 0.1e1 / t27
  t29 = t24 * t28
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = s0 * t31
  t34 = t29 * t32 * t22
  t36 = 0.8040e0 + 0.91462500000000000000000000000000000000000000000000e-2 * t34
  t39 = 0.18040e1 - 0.64641600e0 / t36
  t41 = params.a[1]
  t42 = t24 ** 2
  t44 = 0.3e1 / 0.10e2 * t42 * t27
  t45 = tau0 * t31
  t47 = 0.1e1 / t20 / r0
  t48 = t45 * t47
  t49 = t44 - t48
  t50 = t41 * t49
  t51 = t44 + t48
  t52 = 0.1e1 / t51
  t54 = params.a[2]
  t55 = t49 ** 2
  t56 = t54 * t55
  t57 = t51 ** 2
  t58 = 0.1e1 / t57
  t60 = params.a[3]
  t61 = t55 * t49
  t62 = t60 * t61
  t63 = t57 * t51
  t64 = 0.1e1 / t63
  t66 = params.a[4]
  t67 = t55 ** 2
  t68 = t66 * t67
  t69 = t57 ** 2
  t70 = 0.1e1 / t69
  t72 = params.a[5]
  t73 = t67 * t49
  t74 = t72 * t73
  t75 = t69 * t51
  t76 = 0.1e1 / t75
  t78 = params.a[6]
  t79 = t67 * t55
  t80 = t78 * t79
  t81 = t69 * t57
  t82 = 0.1e1 / t81
  t84 = params.a[7]
  t85 = t67 * t61
  t86 = t84 * t85
  t87 = t69 * t63
  t88 = 0.1e1 / t87
  t90 = params.a[8]
  t91 = t67 ** 2
  t92 = t90 * t91
  t93 = t69 ** 2
  t94 = 0.1e1 / t93
  t96 = params.a[9]
  t97 = t91 * t49
  t98 = t96 * t97
  t100 = 0.1e1 / t93 / t51
  t102 = params.a[10]
  t103 = t91 * t55
  t104 = t102 * t103
  t106 = 0.1e1 / t93 / t57
  t108 = params.a[11]
  t109 = t91 * t61
  t110 = t108 * t109
  t112 = 0.1e1 / t93 / t63
  t114 = t98 * t100 + t104 * t106 + t110 * t112 + t50 * t52 + t56 * t58 + t62 * t64 + t68 * t70 + t74 * t76 + t80 * t82 + t86 * t88 + t92 * t94 + params.a[0]
  t117 = jnp.exp(-0.93189002206715572255024750998986103655990934573866e-2 * t34)
  t119 = 0.1552e1 - 0.552e0 * t117
  t121 = params.b[1]
  t122 = t121 * t49
  t124 = params.b[2]
  t125 = t124 * t55
  t127 = params.b[3]
  t128 = t127 * t61
  t130 = params.b[4]
  t131 = t130 * t67
  t133 = params.b[5]
  t134 = t133 * t73
  t136 = params.b[6]
  t137 = t136 * t79
  t139 = params.b[7]
  t140 = t139 * t85
  t142 = params.b[8]
  t143 = t142 * t91
  t145 = params.b[9]
  t146 = t145 * t97
  t148 = params.b[10]
  t149 = t148 * t103
  t151 = params.b[11]
  t152 = t151 * t109
  t154 = t146 * t100 + t149 * t106 + t152 * t112 + t122 * t52 + t125 * t58 + t128 * t64 + t131 * t70 + t134 * t76 + t137 * t82 + t140 * t88 + t143 * t94 + params.b[0]
  t156 = t39 * t114 + t119 * t154
  t160 = t17 * t47
  t161 = t36 ** 2
  t164 = 0.1e1 / t161 * t24 * t28
  t165 = t18 * r0
  t167 = 0.1e1 / t20 / t165
  t172 = t41 * tau0
  t174 = t31 * t22 * t52
  t177 = t50 * t58
  t178 = t45 * t22
  t181 = t54 * t49
  t182 = t181 * t58
  t185 = t56 * t64
  t188 = t60 * t55
  t189 = t188 * t64
  t192 = t62 * t70
  t195 = t66 * t61
  t196 = t195 * t70
  t199 = t68 * t76
  t202 = t72 * t67
  t203 = t202 * t76
  t206 = t74 * t82
  t209 = t78 * t73
  t210 = t209 * t82
  t213 = 0.5e1 / 0.3e1 * t172 * t174 + 0.5e1 / 0.3e1 * t177 * t178 + 0.10e2 / 0.3e1 * t182 * t178 + 0.10e2 / 0.3e1 * t185 * t178 + 0.5e1 * t189 * t178 + 0.5e1 * t192 * t178 + 0.20e2 / 0.3e1 * t196 * t178 + 0.20e2 / 0.3e1 * t199 * t178 + 0.25e2 / 0.3e1 * t203 * t178 + 0.25e2 / 0.3e1 * t206 * t178 + 0.10e2 * t210 * t178
  t214 = t80 * t88
  t217 = t84 * t79
  t218 = t217 * t88
  t221 = t86 * t94
  t224 = t90 * t85
  t225 = t224 * t94
  t228 = t92 * t100
  t231 = t96 * t91
  t232 = t231 * t100
  t235 = t98 * t106
  t238 = t102 * t97
  t239 = t238 * t106
  t242 = t104 * t112
  t245 = t108 * t103
  t246 = t245 * t112
  t250 = 0.1e1 / t93 / t69
  t251 = t110 * t250
  t254 = 0.10e2 * t214 * t178 + 0.35e2 / 0.3e1 * t218 * t178 + 0.35e2 / 0.3e1 * t221 * t178 + 0.40e2 / 0.3e1 * t225 * t178 + 0.40e2 / 0.3e1 * t228 * t178 + 0.15e2 * t232 * t178 + 0.15e2 * t235 * t178 + 0.50e2 / 0.3e1 * t239 * t178 + 0.50e2 / 0.3e1 * t242 * t178 + 0.55e2 / 0.3e1 * t246 * t178 + 0.55e2 / 0.3e1 * t251 * t178
  t255 = t213 + t254
  t257 = t29 * s0
  t258 = t31 * t167
  t259 = t117 * t154
  t263 = t121 * tau0
  t266 = t122 * t58
  t269 = t124 * t49
  t270 = t269 * t58
  t273 = t125 * t64
  t276 = t127 * t55
  t277 = t276 * t64
  t280 = t128 * t70
  t283 = t130 * t61
  t284 = t283 * t70
  t287 = t131 * t76
  t290 = t133 * t67
  t291 = t290 * t76
  t294 = t134 * t82
  t297 = t136 * t73
  t298 = t297 * t82
  t301 = 0.5e1 / 0.3e1 * t263 * t174 + 0.5e1 / 0.3e1 * t266 * t178 + 0.10e2 / 0.3e1 * t270 * t178 + 0.10e2 / 0.3e1 * t273 * t178 + 0.5e1 * t277 * t178 + 0.5e1 * t280 * t178 + 0.20e2 / 0.3e1 * t284 * t178 + 0.20e2 / 0.3e1 * t287 * t178 + 0.25e2 / 0.3e1 * t291 * t178 + 0.25e2 / 0.3e1 * t294 * t178 + 0.10e2 * t298 * t178
  t302 = t137 * t88
  t305 = t139 * t79
  t306 = t305 * t88
  t309 = t140 * t94
  t312 = t142 * t85
  t313 = t312 * t94
  t316 = t143 * t100
  t319 = t145 * t91
  t320 = t319 * t100
  t323 = t146 * t106
  t326 = t148 * t97
  t327 = t326 * t106
  t330 = t149 * t112
  t333 = t151 * t103
  t334 = t333 * t112
  t337 = t152 * t250
  t340 = 0.10e2 * t302 * t178 + 0.35e2 / 0.3e1 * t306 * t178 + 0.35e2 / 0.3e1 * t309 * t178 + 0.40e2 / 0.3e1 * t313 * t178 + 0.40e2 / 0.3e1 * t316 * t178 + 0.15e2 * t320 * t178 + 0.15e2 * t323 * t178 + 0.50e2 / 0.3e1 * t327 * t178 + 0.50e2 / 0.3e1 * t330 * t178 + 0.55e2 / 0.3e1 * t334 * t178 + 0.55e2 / 0.3e1 * t337 * t178
  t341 = t301 + t340
  t343 = -0.15766086240000000000000000000000000000000000000000e-1 * t164 * t32 * t167 * t114 + t39 * t255 - 0.13717421124828532235939643347050754458161865569273e-1 * t257 * t258 * t259 + t119 * t341
  t348 = t17 / t20
  t353 = 0.1e1 / t26 / t25
  t354 = 0.1e1 / t161 / t36 * t42 * t353
  t355 = s0 ** 2
  t356 = t355 * t30
  t357 = t18 ** 2
  t360 = 0.1e1 / t19 / t357 / t165
  t366 = 0.1e1 / t20 / t357
  t375 = t188 * t70
  t376 = tau0 ** 2
  t377 = t376 * t30
  t378 = t357 * r0
  t380 = 0.1e1 / t19 / t378
  t381 = t377 * t380
  t384 = t62 * t76
  t387 = t66 * t55
  t388 = t387 * t70
  t391 = t195 * t76
  t394 = t68 * t82
  t397 = t72 * t61
  t398 = t397 * t76
  t401 = t202 * t82
  t404 = t74 * t88
  t407 = t78 * t67
  t408 = t407 * t82
  t411 = t209 * t88
  t414 = t80 * t94
  t417 = t60 * t49
  t418 = t417 * t64
  t421 = t84 * t73
  t422 = t421 * t88
  t425 = 0.100e3 * t375 * t381 + 0.200e3 / 0.3e1 * t384 * t381 + 0.200e3 / 0.3e1 * t388 * t381 + 0.1600e4 / 0.9e1 * t391 * t381 + 0.1000e4 / 0.9e1 * t394 * t381 + 0.1000e4 / 0.9e1 * t398 * t381 + 0.2500e4 / 0.9e1 * t401 * t381 + 0.500e3 / 0.3e1 * t404 * t381 + 0.500e3 / 0.3e1 * t408 * t381 + 0.400e3 * t411 * t381 + 0.700e3 / 0.3e1 * t414 * t381 + 0.100e3 / 0.3e1 * t418 * t381 + 0.700e3 / 0.3e1 * t422 * t381
  t426 = t217 * t94
  t429 = t86 * t100
  t432 = t90 * t79
  t433 = t432 * t94
  t436 = t224 * t100
  t439 = t92 * t106
  t442 = t96 * t85
  t443 = t442 * t100
  t446 = t231 * t106
  t449 = t98 * t112
  t452 = t102 * t91
  t453 = t452 * t106
  t456 = t238 * t112
  t459 = t104 * t250
  t462 = t108 * t97
  t463 = t462 * t112
  t466 = t245 * t250
  t470 = 0.1e1 / t93 / t75
  t471 = t110 * t470
  t474 = 0.4900e4 / 0.9e1 * t426 * t381 + 0.2800e4 / 0.9e1 * t429 * t381 + 0.2800e4 / 0.9e1 * t433 * t381 + 0.6400e4 / 0.9e1 * t436 * t381 + 0.400e3 * t439 * t381 + 0.400e3 * t443 * t381 + 0.900e3 * t446 * t381 + 0.500e3 * t449 * t381 + 0.500e3 * t453 * t381 + 0.10000e5 / 0.9e1 * t456 * t381 + 0.5500e4 / 0.9e1 * t459 * t381 + 0.5500e4 / 0.9e1 * t463 * t381 + 0.12100e5 / 0.9e1 * t466 * t381 + 0.2200e4 / 0.3e1 * t471 * t381
  t476 = t45 * t167
  t503 = -0.40e2 * t232 * t476 - 0.40e2 * t235 * t476 - 0.400e3 / 0.9e1 * t239 * t476 - 0.400e3 / 0.9e1 * t242 * t476 - 0.440e3 / 0.9e1 * t246 * t476 - 0.440e3 / 0.9e1 * t251 * t476 - 0.160e3 / 0.9e1 * t199 * t476 - 0.200e3 / 0.9e1 * t203 * t476 - 0.200e3 / 0.9e1 * t206 * t476 - 0.80e2 / 0.3e1 * t210 * t476 - 0.80e2 / 0.3e1 * t214 * t476 - 0.280e3 / 0.9e1 * t218 * t476 - 0.280e3 / 0.9e1 * t221 * t476
  t520 = t50 * t64
  t523 = t181 * t64
  t526 = t56 * t70
  t529 = t41 * t376
  t531 = t30 * t380 * t58
  t534 = t54 * t376
  t537 = t258 * t52
  t540 = -0.320e3 / 0.9e1 * t225 * t476 - 0.320e3 / 0.9e1 * t228 * t476 - 0.40e2 / 0.9e1 * t177 * t476 - 0.80e2 / 0.9e1 * t182 * t476 - 0.80e2 / 0.9e1 * t185 * t476 - 0.40e2 / 0.3e1 * t189 * t476 - 0.40e2 / 0.3e1 * t192 * t476 - 0.160e3 / 0.9e1 * t196 * t476 + 0.100e3 / 0.9e1 * t520 * t381 + 0.400e3 / 0.9e1 * t523 * t381 + 0.100e3 / 0.3e1 * t526 * t381 + 0.100e3 / 0.9e1 * t529 * t531 + 0.100e3 / 0.9e1 * t534 * t531 - 0.40e2 / 0.9e1 * t172 * t537
  t542 = t425 + t474 + t503 + t540
  t544 = t31 * t366
  t549 = t42 * t353 * t355
  t550 = t30 * t360
  t554 = t117 * t341
  t558 = t152 * t470
  t585 = 0.2200e4 / 0.3e1 * t558 * t381 - 0.440e3 / 0.9e1 * t337 * t476 - 0.280e3 / 0.9e1 * t306 * t476 - 0.280e3 / 0.9e1 * t309 * t476 - 0.320e3 / 0.9e1 * t313 * t476 - 0.320e3 / 0.9e1 * t316 * t476 - 0.40e2 * t320 * t476 - 0.40e2 * t323 * t476 - 0.400e3 / 0.9e1 * t327 * t476 - 0.400e3 / 0.9e1 * t330 * t476 - 0.440e3 / 0.9e1 * t334 * t476 - 0.40e2 / 0.3e1 * t277 * t476 - 0.40e2 / 0.3e1 * t280 * t476
  t604 = t122 * t64
  t607 = t269 * t64
  t610 = t125 * t70
  t613 = t127 * t49
  t614 = t613 * t64
  t617 = t276 * t70
  t620 = -0.160e3 / 0.9e1 * t284 * t476 - 0.160e3 / 0.9e1 * t287 * t476 - 0.200e3 / 0.9e1 * t291 * t476 - 0.200e3 / 0.9e1 * t294 * t476 - 0.80e2 / 0.3e1 * t298 * t476 - 0.80e2 / 0.3e1 * t302 * t476 - 0.40e2 / 0.9e1 * t266 * t476 - 0.80e2 / 0.9e1 * t270 * t476 - 0.80e2 / 0.9e1 * t273 * t476 + 0.100e3 / 0.9e1 * t604 * t381 + 0.400e3 / 0.9e1 * t607 * t381 + 0.100e3 / 0.3e1 * t610 * t381 + 0.100e3 / 0.3e1 * t614 * t381 + 0.100e3 * t617 * t381
  t622 = t128 * t76
  t625 = t130 * t55
  t626 = t625 * t70
  t629 = t283 * t76
  t632 = t131 * t82
  t635 = t133 * t61
  t636 = t635 * t76
  t639 = t290 * t82
  t642 = t134 * t88
  t645 = t136 * t67
  t646 = t645 * t82
  t649 = t297 * t88
  t652 = t137 * t94
  t655 = t139 * t73
  t656 = t655 * t88
  t659 = t305 * t94
  t662 = t140 * t100
  t665 = 0.200e3 / 0.3e1 * t622 * t381 + 0.200e3 / 0.3e1 * t626 * t381 + 0.1600e4 / 0.9e1 * t629 * t381 + 0.1000e4 / 0.9e1 * t632 * t381 + 0.1000e4 / 0.9e1 * t636 * t381 + 0.2500e4 / 0.9e1 * t639 * t381 + 0.500e3 / 0.3e1 * t642 * t381 + 0.500e3 / 0.3e1 * t646 * t381 + 0.400e3 * t649 * t381 + 0.700e3 / 0.3e1 * t652 * t381 + 0.700e3 / 0.3e1 * t656 * t381 + 0.4900e4 / 0.9e1 * t659 * t381 + 0.2800e4 / 0.9e1 * t662 * t381
  t666 = t142 * t79
  t667 = t666 * t94
  t670 = t312 * t100
  t673 = t143 * t106
  t676 = t145 * t85
  t677 = t676 * t100
  t680 = t319 * t106
  t683 = t146 * t112
  t686 = t148 * t91
  t687 = t686 * t106
  t690 = t326 * t112
  t693 = t149 * t250
  t696 = t151 * t97
  t697 = t696 * t112
  t700 = t333 * t250
  t703 = t121 * t376
  t706 = t124 * t376
  t711 = 0.2800e4 / 0.9e1 * t667 * t381 + 0.6400e4 / 0.9e1 * t670 * t381 + 0.400e3 * t673 * t381 + 0.400e3 * t677 * t381 + 0.900e3 * t680 * t381 + 0.500e3 * t683 * t381 + 0.500e3 * t687 * t381 + 0.10000e5 / 0.9e1 * t690 * t381 + 0.5500e4 / 0.9e1 * t693 * t381 + 0.5500e4 / 0.9e1 * t697 * t381 + 0.12100e5 / 0.9e1 * t700 * t381 + 0.100e3 / 0.9e1 * t703 * t531 + 0.100e3 / 0.9e1 * t706 * t531 - 0.40e2 / 0.9e1 * t263 * t537
  t713 = t585 + t620 + t665 + t711
  t715 = -0.15381393735744000000000000000000000000000000000000e-2 * t354 * t356 * t360 * t114 + 0.57808982880000000000000000000000000000000000000000e-1 * t164 * t32 * t366 * t114 - 0.31532172480000000000000000000000000000000000000000e-1 * t164 * t32 * t167 * t255 + t39 * t542 + 0.50297210791037951531778692272519433013260173754001e-1 * t257 * t544 * t259 - 0.68176681998511621219954093094822938202828301471506e-3 * t549 * t550 * t259 - 0.27434842249657064471879286694101508916323731138546e-1 * t257 * t258 * t554 + t119 * t713
  t719 = t17 * t19
  t720 = t161 ** 2
  t722 = t25 ** 2
  t723 = 0.1e1 / t722
  t724 = 0.1e1 / t720 * t723
  t725 = t355 * s0
  t726 = t357 ** 2
  t728 = 0.1e1 / t726 / t165
  t729 = t725 * t728
  t734 = 0.1e1 / t19 / t726
  t744 = 0.1e1 / t20 / t378
  t757 = t376 * tau0
  t758 = t41 * t757
  t759 = 0.1e1 / t726
  t760 = t759 * t64
  t763 = t54 * t757
  t766 = t60 * t757
  t769 = t357 * t18
  t771 = 0.1e1 / t19 / t769
  t772 = t377 * t771
  t789 = 0.1000e4 / 0.9e1 * t758 * t760 + 0.2000e4 / 0.9e1 * t763 * t760 + 0.1000e4 / 0.9e1 * t766 * t760 - 0.4000e4 * t449 * t772 - 0.4000e4 * t453 * t772 - 0.80000e5 / 0.9e1 * t456 * t772 - 0.44000e5 / 0.9e1 * t459 * t772 - 0.4000e4 / 0.3e1 * t404 * t772 - 0.800e3 / 0.9e1 * t520 * t772 - 0.3200e4 / 0.9e1 * t523 * t772 - 0.800e3 / 0.3e1 * t526 * t772
  t798 = t45 * t366
  t815 = -0.800e3 / 0.3e1 * t418 * t772 - 0.800e3 * t375 * t772 - 0.1600e4 / 0.3e1 * t384 * t772 - 0.1600e4 / 0.3e1 * t388 * t772 + 0.880e3 / 0.27e2 * t185 * t798 + 0.440e3 / 0.9e1 * t189 * t798 + 0.440e3 / 0.9e1 * t192 * t798 + 0.1760e4 / 0.27e2 * t196 * t798 + 0.880e3 / 0.9e1 * t210 * t798 + 0.880e3 / 0.9e1 * t214 * t798 + 0.3080e4 / 0.27e2 * t218 * t798 - 0.5600e4 / 0.3e1 * t414 * t772
  t841 = -0.5600e4 / 0.3e1 * t422 * t772 - 0.39200e5 / 0.9e1 * t426 * t772 - 0.4000e4 / 0.3e1 * t408 * t772 - 0.3200e4 * t411 * t772 + 0.4840e4 / 0.27e2 * t251 * t798 + 0.1760e4 / 0.27e2 * t199 * t798 + 0.2200e4 / 0.27e2 * t203 * t798 + 0.2200e4 / 0.27e2 * t206 * t798 + 0.3080e4 / 0.27e2 * t221 * t798 + 0.3520e4 / 0.27e2 * t225 * t798 + 0.3520e4 / 0.27e2 * t228 * t798 + 0.440e3 / 0.27e2 * t177 * t798
  t866 = 0.880e3 / 0.27e2 * t182 * t798 - 0.44000e5 / 0.9e1 * t463 * t772 - 0.96800e5 / 0.9e1 * t466 * t772 - 0.17600e5 / 0.3e1 * t471 * t772 + 0.440e3 / 0.3e1 * t232 * t798 + 0.440e3 / 0.3e1 * t235 * t798 + 0.4400e4 / 0.27e2 * t239 * t798 + 0.4400e4 / 0.27e2 * t242 * t798 + 0.4840e4 / 0.27e2 * t246 * t798 - 0.3200e4 * t443 * t772 - 0.7200e4 * t446 * t772 - 0.22400e5 / 0.9e1 * t429 * t772
  t883 = t96 * t79
  t884 = t100 * t757
  t885 = t884 * t759
  t889 = t30 * t771 * t58
  t892 = t70 * t757
  t893 = t892 * t759
  t898 = t76 * t757
  t899 = t898 * t759
  t902 = -0.22400e5 / 0.9e1 * t433 * t772 - 0.51200e5 / 0.9e1 * t436 * t772 - 0.3200e4 * t439 * t772 - 0.12800e5 / 0.9e1 * t391 * t772 - 0.8000e4 / 0.9e1 * t394 * t772 - 0.8000e4 / 0.9e1 * t398 * t772 - 0.20000e5 / 0.9e1 * t401 * t772 + 0.28000e5 / 0.3e1 * t883 * t885 - 0.800e3 / 0.9e1 * t534 * t889 + 0.1000e4 / 0.9e1 * t50 * t893 + 0.2000e4 / 0.3e1 * t181 * t893 + 0.4000e4 / 0.9e1 * t56 * t899
  t907 = t82 * t757
  t908 = t907 * t759
  t911 = t66 * t49
  t918 = t88 * t757
  t919 = t918 * t759
  t922 = t72 * t55
  t929 = t106 * t757
  t930 = t929 * t759
  t933 = t112 * t757
  t934 = t933 * t759
  t937 = 0.1000e4 * t417 * t893 + 0.2000e4 * t188 * t899 + 0.10000e5 / 0.9e1 * t62 * t908 + 0.4000e4 / 0.9e1 * t911 * t893 + 0.8000e4 / 0.3e1 * t387 * t899 + 0.40000e5 / 0.9e1 * t195 * t908 + 0.20000e5 / 0.9e1 * t68 * t919 + 0.10000e5 / 0.9e1 * t922 * t899 + 0.50000e5 / 0.9e1 * t397 * t908 + 0.25000e5 / 0.3e1 * t202 * t919 + 0.36000e5 * t442 * t930 + 0.45000e5 * t231 * t934
  t939 = t250 * t757
  t940 = t939 * t759
  t943 = t102 * t85
  t950 = t470 * t757
  t951 = t950 * t759
  t954 = t108 * t91
  t962 = 0.1e1 / t93 / t81
  t963 = t962 * t757
  t964 = t963 * t759
  t969 = t544 * t52
  t972 = t94 * t757
  t973 = t972 * t759
  t976 = 0.55000e5 / 0.3e1 * t98 * t940 + 0.40000e5 / 0.3e1 * t943 * t930 + 0.50000e5 * t452 * t934 + 0.550000e6 / 0.9e1 * t238 * t940 + 0.220000e6 / 0.9e1 * t104 * t951 + 0.55000e5 / 0.3e1 * t954 * t934 + 0.605000e6 / 0.9e1 * t462 * t940 + 0.242000e6 / 0.3e1 * t245 * t951 + 0.286000e6 / 0.9e1 * t110 * t964 - 0.800e3 / 0.9e1 * t529 * t889 + 0.440e3 / 0.27e2 * t172 * t969 + 0.35000e5 / 0.9e1 * t74 * t973
  t977 = t78 * t61
  t986 = t84 * t67
  t995 = t90 * t73
  t1004 = 0.20000e5 / 0.9e1 * t977 * t908 + 0.10000e5 * t407 * t919 + 0.14000e5 * t209 * t973 + 0.56000e5 / 0.9e1 * t80 * t885 + 0.35000e5 / 0.9e1 * t986 * t919 + 0.49000e5 / 0.3e1 * t421 * t973 + 0.196000e6 / 0.9e1 * t217 * t885 + 0.28000e5 / 0.3e1 * t86 * t930 + 0.56000e5 / 0.9e1 * t995 * t973 + 0.224000e6 / 0.9e1 * t432 * t885 + 0.32000e5 * t224 * t930 + 0.40000e5 / 0.3e1 * t92 * t934
  t1007 = t789 + t815 + t841 + t866 + t902 + t937 + t976 + t1004
  t1009 = t31 * t744
  t1013 = t30 * t734
  t1020 = t723 * t725
  t1021 = t728 * t117
  t1028 = t117 * t713
  t1054 = -0.17600e5 / 0.3e1 * t558 * t772 + 0.4840e4 / 0.27e2 * t337 * t798 + 0.3080e4 / 0.27e2 * t306 * t798 + 0.3080e4 / 0.27e2 * t309 * t798 + 0.3520e4 / 0.27e2 * t313 * t798 - 0.3200e4 * t673 * t772 - 0.3200e4 * t677 * t772 - 0.7200e4 * t680 * t772 - 0.5600e4 / 0.3e1 * t656 * t772 - 0.39200e5 / 0.9e1 * t659 * t772 - 0.22400e5 / 0.9e1 * t662 * t772
  t1057 = t121 * t757
  t1060 = t124 * t757
  t1063 = t127 * t757
  t1072 = t151 * t91
  t1083 = -0.22400e5 / 0.9e1 * t667 * t772 + 0.1000e4 / 0.9e1 * t1057 * t760 + 0.2000e4 / 0.9e1 * t1060 * t760 + 0.1000e4 / 0.9e1 * t1063 * t760 + 0.50000e5 * t686 * t934 + 0.550000e6 / 0.9e1 * t326 * t940 + 0.220000e6 / 0.9e1 * t149 * t951 + 0.55000e5 / 0.3e1 * t1072 * t934 + 0.605000e6 / 0.9e1 * t696 * t940 + 0.242000e6 / 0.3e1 * t333 * t951 + 0.286000e6 / 0.9e1 * t152 * t964 - 0.800e3 / 0.9e1 * t703 * t889
  t1097 = t130 * t49
  t1106 = t133 * t55
  t1111 = -0.800e3 / 0.9e1 * t706 * t889 + 0.2000e4 / 0.3e1 * t269 * t893 + 0.4000e4 / 0.9e1 * t125 * t899 + 0.1000e4 * t613 * t893 + 0.2000e4 * t276 * t899 + 0.10000e5 / 0.9e1 * t128 * t908 + 0.4000e4 / 0.9e1 * t1097 * t893 + 0.8000e4 / 0.3e1 * t625 * t899 + 0.40000e5 / 0.9e1 * t283 * t908 + 0.20000e5 / 0.9e1 * t131 * t919 + 0.10000e5 / 0.9e1 * t1106 * t899 + 0.50000e5 / 0.9e1 * t635 * t908
  t1116 = t136 * t61
  t1125 = t139 * t67
  t1134 = t142 * t73
  t1139 = 0.25000e5 / 0.3e1 * t290 * t919 + 0.35000e5 / 0.9e1 * t134 * t973 + 0.20000e5 / 0.9e1 * t1116 * t908 + 0.10000e5 * t645 * t919 + 0.14000e5 * t297 * t973 + 0.56000e5 / 0.9e1 * t137 * t885 + 0.35000e5 / 0.9e1 * t1125 * t919 + 0.49000e5 / 0.3e1 * t655 * t973 + 0.196000e6 / 0.9e1 * t305 * t885 + 0.28000e5 / 0.3e1 * t140 * t930 + 0.56000e5 / 0.9e1 * t1134 * t973 + 0.224000e6 / 0.9e1 * t666 * t885
  t1150 = t145 * t79
  t1159 = t148 * t85
  t1168 = 0.32000e5 * t312 * t930 + 0.40000e5 / 0.3e1 * t143 * t934 + 0.1000e4 / 0.9e1 * t122 * t893 + 0.440e3 / 0.27e2 * t263 * t969 + 0.28000e5 / 0.3e1 * t1150 * t885 + 0.36000e5 * t676 * t930 + 0.45000e5 * t319 * t934 + 0.55000e5 / 0.3e1 * t146 * t940 + 0.40000e5 / 0.3e1 * t1159 * t930 - 0.51200e5 / 0.9e1 * t670 * t772 - 0.8000e4 / 0.9e1 * t636 * t772 - 0.20000e5 / 0.9e1 * t639 * t772
  t1193 = -0.4000e4 / 0.3e1 * t642 * t772 - 0.4000e4 / 0.3e1 * t646 * t772 - 0.3200e4 * t649 * t772 - 0.5600e4 / 0.3e1 * t652 * t772 - 0.44000e5 / 0.9e1 * t697 * t772 - 0.96800e5 / 0.9e1 * t700 * t772 - 0.800e3 / 0.3e1 * t614 * t772 - 0.800e3 * t617 * t772 - 0.1600e4 / 0.3e1 * t622 * t772 - 0.1600e4 / 0.3e1 * t626 * t772 - 0.12800e5 / 0.9e1 * t629 * t772 - 0.8000e4 / 0.9e1 * t632 * t772
  t1219 = 0.880e3 / 0.9e1 * t302 * t798 - 0.800e3 / 0.9e1 * t604 * t772 - 0.3200e4 / 0.9e1 * t607 * t772 - 0.800e3 / 0.3e1 * t610 * t772 + 0.4840e4 / 0.27e2 * t334 * t798 + 0.440e3 / 0.9e1 * t277 * t798 + 0.440e3 / 0.9e1 * t280 * t798 + 0.1760e4 / 0.27e2 * t284 * t798 + 0.1760e4 / 0.27e2 * t287 * t798 + 0.2200e4 / 0.27e2 * t291 * t798 + 0.2200e4 / 0.27e2 * t294 * t798 + 0.880e3 / 0.9e1 * t298 * t798
  t1244 = 0.3520e4 / 0.27e2 * t316 * t798 + 0.440e3 / 0.3e1 * t320 * t798 + 0.440e3 / 0.3e1 * t323 * t798 + 0.4400e4 / 0.27e2 * t327 * t798 + 0.4400e4 / 0.27e2 * t330 * t798 + 0.440e3 / 0.27e2 * t266 * t798 + 0.880e3 / 0.27e2 * t270 * t798 + 0.880e3 / 0.27e2 * t273 * t798 - 0.4000e4 * t683 * t772 - 0.4000e4 * t687 * t772 - 0.80000e5 / 0.9e1 * t690 * t772 - 0.44000e5 / 0.9e1 * t693 * t772
  t1247 = t1054 + t1083 + t1111 + t1139 + t1168 + t1193 + t1219 + t1244
  t1249 = -0.13505478955732661760000000000000000000000000000000e-2 * t724 * t729 * t114 + 0.16919533109318400000000000000000000000000000000000e-1 * t354 * t356 * t734 * t114 - 0.46144181207232000000000000000000000000000000000000e-2 * t354 * t356 * t360 * t255 - 0.26977525344000000000000000000000000000000000000000e0 * t164 * t32 * t744 * t114 + 0.17342694864000000000000000000000000000000000000000e0 * t164 * t32 * t366 * t255 - 0.47298258720000000000000000000000000000000000000000e-1 * t164 * t32 * t167 * t542 + t39 * t1007 - 0.23472031702484377381496723060509068739521414418534e0 * t257 * t1009 * t259 + 0.74994350198362783341949502404305232023111131618657e-2 * t549 * t1013 * t259 + 0.15089163237311385459533607681755829903978052126200e0 * t257 * t544 * t554 - 0.20330614301458704962114299843389675613654291605984e-3 * t1020 * t1021 * t154 - 0.20453004599553486365986227928446881460848490441452e-2 * t549 * t550 * t554 - 0.41152263374485596707818930041152263374485596707819e-1 * t257 * t258 * t1028 + t119 * t1247
  t1254 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t23 * t156 + t6 * t160 * t343 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t348 * t715 - 0.3e1 / 0.8e1 * t6 * t719 * t1249)
  t1272 = t355 ** 2
  t1275 = 0.1e1 / t20 / t726 / t769
  t1279 = t28 * t31
  t1283 = t726 * r0
  t1285 = 0.1e1 / t19 / t1283
  t1291 = 0.1e1 / t726 / t357
  t1317 = 0.1e1 / t20 / t769
  t1330 = -0.13175945269212784813056000000000000000000000000000e-3 / t720 / t36 * t723 * t1272 * t1275 * t114 * t24 * t1279 - 0.16731538296992640000000000000000000000000000000000e0 * t354 * t356 * t1285 * t114 + 0.29712053702611855872000000000000000000000000000000e-1 * t724 * t725 * t1291 * t114 - 0.54021915822930647040000000000000000000000000000000e-2 * t724 * t729 * t255 - 0.40906009199106972731972455856893762921696980882904e-2 * t549 * t550 * t1028 - 0.50522390960067158113442823809143147287465188579710e-5 * t723 * t1272 * t1275 * t24 * t1279 * t259 + 0.67678132437273600000000000000000000000000000000000e-1 * t354 * t356 * t734 * t255 - 0.92288362414464000000000000000000000000000000000000e-2 * t354 * t356 * t360 * t542 + 0.15287264361600000000000000000000000000000000000000e1 * t164 * t32 * t1317 * t114 + 0.13300817964741147182848143067621805619062134837169e1 * t257 * t31 * t1317 * t259 - 0.54869684499314128943758573388203017832647462277092e-1 * t257 * t258 * t117 * t1247
  t1364 = t376 ** 2
  t1367 = 0.1e1 / t20 / t726 / t18
  t1369 = t1364 * t1367 * t31
  t1404 = t45 * t744
  t1417 = t377 * t360
  t1420 = 0.1100000e7 / 0.3e1 * t98 * t470 * t1369 + 0.1400000e7 / 0.9e1 * t102 * t79 * t106 * t1369 + 0.8000000e7 / 0.9e1 * t943 * t112 * t1369 + 0.5500000e7 / 0.3e1 * t452 * t250 * t1369 + 0.100000e6 / 0.9e1 * t62 * t88 * t1369 + 0.320000e6 / 0.27e2 * t911 * t76 * t1369 + 0.400000e6 / 0.9e1 * t387 * t82 * t1369 + 0.1600000e7 / 0.27e2 * t195 * t88 * t1369 + 0.700000e6 / 0.27e2 * t68 * t94 * t1369 + 0.100000e6 / 0.27e2 * t72 * t49 * t76 * t1369 + 0.1000000e7 / 0.27e2 * t922 * t82 * t1369 - 0.61600e5 / 0.81e2 * t239 * t1404 - 0.61600e5 / 0.81e2 * t242 * t1404 - 0.67760e5 / 0.81e2 * t246 * t1404 - 0.49280e5 / 0.81e2 * t228 * t1404 - 0.6160e4 / 0.81e2 * t177 * t1404 - 0.12320e5 / 0.81e2 * t182 * t1404 + 0.272000e6 / 0.27e2 * t408 * t1417
  t1457 = 0.217600e6 / 0.9e1 * t411 * t1417 - 0.67760e5 / 0.81e2 * t251 * t1404 - 0.24640e5 / 0.81e2 * t199 * t1404 - 0.30800e5 / 0.81e2 * t203 * t1404 - 0.30800e5 / 0.81e2 * t206 * t1404 - 0.43120e5 / 0.81e2 * t221 * t1404 - 0.49280e5 / 0.81e2 * t225 * t1404 - 0.12320e5 / 0.81e2 * t185 * t1404 - 0.6160e4 / 0.27e2 * t189 * t1404 - 0.6160e4 / 0.27e2 * t192 * t1404 - 0.24640e5 / 0.81e2 * t196 * t1404 - 0.43120e5 / 0.81e2 * t218 * t1404 + 0.380800e6 / 0.27e2 * t414 * t1417 + 0.217600e6 / 0.81e2 * t523 * t1417 + 0.54400e5 / 0.27e2 * t526 * t1417 + 0.54400e5 / 0.27e2 * t418 * t1417 + 0.54400e5 / 0.9e1 * t375 * t1417 + 0.108800e6 / 0.27e2 * t384 * t1417
  t1502 = 0.108800e6 / 0.27e2 * t388 * t1417 + 0.870400e6 / 0.81e2 * t391 * t1417 + 0.380800e6 / 0.27e2 * t422 * t1417 + 0.6582400e7 / 0.81e2 * t466 * t1417 + 0.1196800e7 / 0.27e2 * t471 * t1417 + 0.544000e6 / 0.81e2 * t394 * t1417 + 0.544000e6 / 0.81e2 * t398 * t1417 + 0.1360000e7 / 0.81e2 * t401 * t1417 + 0.272000e6 / 0.27e2 * t404 * t1417 + 0.1523200e7 / 0.81e2 * t429 * t1417 + 0.1523200e7 / 0.81e2 * t433 * t1417 + 0.3481600e7 / 0.81e2 * t436 * t1417 + 0.3920000e7 / 0.9e1 * t421 * t100 * t1369 + 0.3920000e7 / 0.9e1 * t217 * t106 * t1369 + 0.1400000e7 / 0.9e1 * t86 * t112 * t1369 + 0.1400000e7 / 0.27e2 * t90 * t67 * t94 * t1369 + 0.8960000e7 / 0.27e2 * t995 * t100 * t1369 + 0.2240000e7 / 0.3e1 * t432 * t106 * t1369
  t1557 = 0.6400000e7 / 0.9e1 * t224 * t112 * t1369 + 0.1400000e7 / 0.27e2 * t74 * t100 * t1369 + 0.2665600e7 / 0.81e2 * t426 * t1417 - 0.12320e5 / 0.27e2 * t210 * t1404 - 0.12320e5 / 0.27e2 * t214 * t1404 + 0.100000e6 / 0.9e1 * t78 * t55 * t82 * t1369 + 0.800000e6 / 0.9e1 * t977 * t88 * t1369 + 0.700000e6 / 0.3e1 * t407 * t94 * t1369 + 0.2240000e7 / 0.9e1 * t209 * t100 * t1369 + 0.280000e6 / 0.3e1 * t80 * t106 * t1369 + 0.700000e6 / 0.27e2 * t84 * t61 * t88 * t1369 + 0.4900000e7 / 0.27e2 * t986 * t94 * t1369 + 0.44000000e8 / 0.27e2 * t238 * t470 * t1369 + 0.14300000e8 / 0.27e2 * t104 * t962 * t1369 + 0.2200000e7 / 0.9e1 * t108 * t85 * t112 * t1369 + 0.12100000e8 / 0.9e1 * t954 * t250 * t1369 + 0.24200000e8 / 0.9e1 * t462 * t470 * t1369 + 0.62920000e8 / 0.27e2 * t245 * t962 * t1369
  t1561 = 0.1e1 / t93 / t87
  t1612 = 0.20020000e8 / 0.27e2 * t110 * t1561 * t1369 + 0.1000000e7 / 0.9e1 * t397 * t88 * t1369 + 0.3500000e7 / 0.27e2 * t202 * t94 * t1369 + 0.560000e6 * t883 * t106 * t1369 + 0.1200000e7 * t442 * t112 * t1369 + 0.1100000e7 * t231 * t250 * t1369 + 0.2992000e7 / 0.81e2 * t463 * t1417 - 0.6160e4 / 0.9e1 * t232 * t1404 - 0.6160e4 / 0.9e1 * t235 * t1404 + 0.2200000e7 / 0.9e1 * t92 * t250 * t1369 + 0.280000e6 / 0.3e1 * t96 * t73 * t100 * t1369 + 0.20000e5 / 0.27e2 * t50 * t76 * t1369 + 0.160000e6 / 0.27e2 * t181 * t76 * t1369 + 0.100000e6 / 0.27e2 * t56 * t82 * t1369 + 0.40000e5 / 0.3e1 * t417 * t76 * t1369 + 0.200000e6 / 0.9e1 * t188 * t82 * t1369 + 0.217600e6 / 0.9e1 * t439 * t1417 + 0.54400e5 / 0.81e2 * t520 * t1417
  t1625 = 0.1e1 / t1283
  t1626 = t1625 * t64
  t1633 = t907 * t1625
  t1636 = t918 * t1625
  t1639 = t972 * t1625
  t1642 = t892 * t1625
  t1647 = t31 * t1367 * t70
  t1661 = 0.217600e6 / 0.9e1 * t443 * t1417 + 0.54400e5 * t446 * t1417 + 0.272000e6 / 0.9e1 * t449 * t1417 + 0.272000e6 / 0.9e1 * t453 * t1417 + 0.5440000e7 / 0.81e2 * t456 * t1417 + 0.2992000e7 / 0.81e2 * t459 * t1417 - 0.32000e5 / 0.9e1 * t763 * t1626 - 0.16000e5 / 0.9e1 * t766 * t1626 - 0.16000e5 / 0.9e1 * t758 * t1626 - 0.800000e6 / 0.9e1 * t397 * t1633 - 0.400000e6 / 0.3e1 * t202 * t1636 - 0.560000e6 / 0.9e1 * t74 * t1639 - 0.16000e5 / 0.9e1 * t50 * t1642 + 0.20000e5 / 0.27e2 * t41 * t1364 * t1647 + 0.20000e5 / 0.9e1 * t54 * t1364 * t1647 + 0.20000e5 / 0.9e1 * t60 * t1364 * t1647 + 0.20000e5 / 0.27e2 * t66 * t1364 * t1647 - 0.32000e5 / 0.3e1 * t181 * t1642
  t1663 = t898 * t1625
  t1678 = t884 * t1625
  t1691 = t550 * t58
  t1696 = t933 * t1625
  t1699 = t939 * t1625
  t1702 = t950 * t1625
  t1705 = -0.64000e5 / 0.9e1 * t56 * t1663 - 0.16000e5 * t417 * t1642 - 0.32000e5 * t188 * t1663 - 0.160000e6 / 0.9e1 * t62 * t1633 - 0.64000e5 / 0.9e1 * t911 * t1642 - 0.128000e6 / 0.3e1 * t387 * t1663 - 0.224000e6 * t209 * t1639 - 0.896000e6 / 0.9e1 * t80 * t1678 - 0.560000e6 / 0.9e1 * t986 * t1636 - 0.784000e6 / 0.3e1 * t421 * t1639 - 0.3136000e7 / 0.9e1 * t217 * t1678 - 0.320000e6 / 0.9e1 * t977 * t1633 - 0.160000e6 * t407 * t1636 + 0.54400e5 / 0.81e2 * t529 * t1691 + 0.54400e5 / 0.81e2 * t534 * t1691 - 0.880000e6 / 0.3e1 * t954 * t1696 - 0.9680000e7 / 0.9e1 * t462 * t1699 - 0.3872000e7 / 0.3e1 * t245 * t1702
  t1706 = t963 * t1625
  t1711 = t929 * t1625
  t1722 = t1009 * t52
  t1745 = -0.4576000e7 / 0.9e1 * t110 * t1706 - 0.448000e6 / 0.3e1 * t883 * t1678 - 0.576000e6 * t442 * t1711 - 0.720000e6 * t231 * t1696 - 0.880000e6 / 0.3e1 * t98 * t1699 - 0.640000e6 / 0.3e1 * t943 * t1711 - 0.800000e6 * t452 * t1696 - 0.6160e4 / 0.81e2 * t172 * t1722 - 0.8800000e7 / 0.9e1 * t238 * t1699 - 0.3520000e7 / 0.9e1 * t104 * t1702 - 0.448000e6 / 0.3e1 * t86 * t1711 - 0.896000e6 / 0.9e1 * t995 * t1639 - 0.3584000e7 / 0.9e1 * t432 * t1678 - 0.512000e6 * t224 * t1711 - 0.640000e6 / 0.3e1 * t92 * t1696 - 0.640000e6 / 0.9e1 * t195 * t1633 - 0.320000e6 / 0.9e1 * t68 * t1636 - 0.160000e6 / 0.9e1 * t922 * t1663
  t1786 = 0.217600e6 / 0.81e2 * t607 * t1417 + 0.54400e5 / 0.27e2 * t610 * t1417 - 0.67760e5 / 0.81e2 * t334 * t1404 - 0.6160e4 / 0.27e2 * t277 * t1404 - 0.6160e4 / 0.27e2 * t280 * t1404 - 0.24640e5 / 0.81e2 * t284 * t1404 - 0.24640e5 / 0.81e2 * t287 * t1404 - 0.30800e5 / 0.81e2 * t291 * t1404 + 0.54400e5 / 0.9e1 * t617 * t1417 + 0.108800e6 / 0.27e2 * t622 * t1417 + 0.108800e6 / 0.27e2 * t626 * t1417 + 0.870400e6 / 0.81e2 * t629 * t1417 + 0.544000e6 / 0.81e2 * t632 * t1417 - 0.12320e5 / 0.27e2 * t302 * t1404 + 0.54400e5 / 0.81e2 * t604 * t1417 + 0.272000e6 / 0.27e2 * t642 * t1417 + 0.272000e6 / 0.27e2 * t646 * t1417 + 0.217600e6 / 0.9e1 * t649 * t1417
  t1823 = 0.380800e6 / 0.27e2 * t652 * t1417 + 0.2992000e7 / 0.81e2 * t697 * t1417 + 0.54400e5 / 0.27e2 * t614 * t1417 + 0.54400e5 * t680 * t1417 + 0.544000e6 / 0.81e2 * t636 * t1417 + 0.1360000e7 / 0.81e2 * t639 * t1417 - 0.67760e5 / 0.81e2 * t337 * t1404 - 0.43120e5 / 0.81e2 * t306 * t1404 - 0.43120e5 / 0.81e2 * t309 * t1404 - 0.49280e5 / 0.81e2 * t313 * t1404 + 0.217600e6 / 0.9e1 * t673 * t1417 + 0.217600e6 / 0.9e1 * t677 * t1417 + 0.6582400e7 / 0.81e2 * t700 * t1417 + 0.1196800e7 / 0.27e2 * t558 * t1417 + 0.380800e6 / 0.27e2 * t656 * t1417 - 0.32000e5 / 0.9e1 * t1060 * t1626 - 0.16000e5 / 0.9e1 * t1063 * t1626 - 0.16000e5 / 0.9e1 * t1057 * t1626
  t1861 = -0.784000e6 / 0.3e1 * t655 * t1639 - 0.3136000e7 / 0.9e1 * t305 * t1678 - 0.448000e6 / 0.3e1 * t140 * t1711 - 0.896000e6 / 0.9e1 * t1134 * t1639 - 0.3584000e7 / 0.9e1 * t666 * t1678 - 0.160000e6 / 0.9e1 * t1106 * t1663 - 0.800000e6 / 0.9e1 * t635 * t1633 - 0.400000e6 / 0.3e1 * t290 * t1636 - 0.560000e6 / 0.9e1 * t134 * t1639 - 0.320000e6 / 0.9e1 * t1116 * t1633 - 0.160000e6 * t645 * t1636 - 0.224000e6 * t297 * t1639 - 0.896000e6 / 0.9e1 * t137 * t1678 - 0.880000e6 / 0.3e1 * t1072 * t1696 - 0.9680000e7 / 0.9e1 * t696 * t1699 - 0.3872000e7 / 0.3e1 * t333 * t1702 - 0.16000e5 * t613 * t1642 - 0.32000e5 * t276 * t1663
  t1899 = -0.160000e6 / 0.9e1 * t128 * t1633 - 0.64000e5 / 0.9e1 * t1097 * t1642 - 0.128000e6 / 0.3e1 * t625 * t1663 - 0.640000e6 / 0.9e1 * t283 * t1633 - 0.320000e6 / 0.9e1 * t131 * t1636 - 0.16000e5 / 0.9e1 * t122 * t1642 - 0.32000e5 / 0.3e1 * t269 * t1642 - 0.64000e5 / 0.9e1 * t125 * t1663 + 0.54400e5 / 0.81e2 * t703 * t1691 + 0.54400e5 / 0.81e2 * t706 * t1691 - 0.4576000e7 / 0.9e1 * t152 * t1706 - 0.880000e6 / 0.3e1 * t146 * t1699 - 0.640000e6 / 0.3e1 * t1159 * t1711 - 0.800000e6 * t686 * t1696 - 0.8800000e7 / 0.9e1 * t326 * t1699 - 0.3520000e7 / 0.9e1 * t149 * t1702 - 0.560000e6 / 0.9e1 * t1125 * t1636 + 0.20000e5 / 0.27e2 * t130 * t1364 * t1647
  t1946 = -0.6160e4 / 0.81e2 * t263 * t1722 + 0.20000e5 / 0.27e2 * t121 * t1364 * t1647 + 0.20000e5 / 0.9e1 * t124 * t1364 * t1647 + 0.20000e5 / 0.9e1 * t127 * t1364 * t1647 - 0.512000e6 * t312 * t1711 - 0.640000e6 / 0.3e1 * t143 * t1696 - 0.448000e6 / 0.3e1 * t1150 * t1678 - 0.576000e6 * t676 * t1711 - 0.720000e6 * t319 * t1696 + 0.2665600e7 / 0.81e2 * t659 * t1417 + 0.1523200e7 / 0.81e2 * t662 * t1417 + 0.1523200e7 / 0.81e2 * t667 * t1417 + 0.3481600e7 / 0.81e2 * t670 * t1417 + 0.20020000e8 / 0.27e2 * t152 * t1561 * t1369 + 0.160000e6 / 0.27e2 * t269 * t76 * t1369 + 0.100000e6 / 0.27e2 * t125 * t82 * t1369 + 0.40000e5 / 0.3e1 * t613 * t76 * t1369 + 0.5500000e7 / 0.3e1 * t686 * t250 * t1369
  t2005 = 0.44000000e8 / 0.27e2 * t326 * t470 * t1369 + 0.14300000e8 / 0.27e2 * t149 * t962 * t1369 + 0.2200000e7 / 0.9e1 * t151 * t85 * t112 * t1369 + 0.12100000e8 / 0.9e1 * t1072 * t250 * t1369 + 0.24200000e8 / 0.9e1 * t696 * t470 * t1369 + 0.62920000e8 / 0.27e2 * t333 * t962 * t1369 + 0.20000e5 / 0.27e2 * t122 * t76 * t1369 + 0.280000e6 / 0.3e1 * t145 * t73 * t100 * t1369 + 0.560000e6 * t1150 * t106 * t1369 + 0.1200000e7 * t676 * t112 * t1369 + 0.1100000e7 * t319 * t250 * t1369 + 0.1100000e7 / 0.3e1 * t146 * t470 * t1369 + 0.1400000e7 / 0.9e1 * t148 * t79 * t106 * t1369 + 0.8000000e7 / 0.9e1 * t1159 * t112 * t1369 + 0.3920000e7 / 0.9e1 * t655 * t100 * t1369 + 0.3920000e7 / 0.9e1 * t305 * t106 * t1369 + 0.1400000e7 / 0.9e1 * t140 * t112 * t1369 + 0.1400000e7 / 0.27e2 * t142 * t67 * t94 * t1369
  t2064 = 0.8960000e7 / 0.27e2 * t1134 * t100 * t1369 + 0.2240000e7 / 0.3e1 * t666 * t106 * t1369 + 0.6400000e7 / 0.9e1 * t312 * t112 * t1369 + 0.2200000e7 / 0.9e1 * t143 * t250 * t1369 + 0.1400000e7 / 0.27e2 * t134 * t100 * t1369 + 0.100000e6 / 0.9e1 * t136 * t55 * t82 * t1369 + 0.800000e6 / 0.9e1 * t1116 * t88 * t1369 + 0.700000e6 / 0.3e1 * t645 * t94 * t1369 + 0.2240000e7 / 0.9e1 * t297 * t100 * t1369 + 0.280000e6 / 0.3e1 * t137 * t106 * t1369 + 0.700000e6 / 0.27e2 * t139 * t61 * t88 * t1369 + 0.4900000e7 / 0.27e2 * t1125 * t94 * t1369 + 0.320000e6 / 0.27e2 * t1097 * t76 * t1369 + 0.400000e6 / 0.9e1 * t625 * t82 * t1369 + 0.1600000e7 / 0.27e2 * t283 * t88 * t1369 + 0.700000e6 / 0.27e2 * t131 * t94 * t1369 + 0.100000e6 / 0.27e2 * t133 * t49 * t76 * t1369 + 0.1000000e7 / 0.27e2 * t1106 * t82 * t1369
  t2105 = 0.1000000e7 / 0.9e1 * t635 * t88 * t1369 + 0.3500000e7 / 0.27e2 * t290 * t94 * t1369 + 0.2992000e7 / 0.81e2 * t693 * t1417 + 0.200000e6 / 0.9e1 * t276 * t82 * t1369 + 0.100000e6 / 0.9e1 * t128 * t88 * t1369 + 0.272000e6 / 0.9e1 * t683 * t1417 + 0.272000e6 / 0.9e1 * t687 * t1417 + 0.5440000e7 / 0.81e2 * t690 * t1417 - 0.12320e5 / 0.81e2 * t273 * t1404 - 0.30800e5 / 0.81e2 * t294 * t1404 - 0.12320e5 / 0.27e2 * t298 * t1404 - 0.49280e5 / 0.81e2 * t316 * t1404 - 0.6160e4 / 0.9e1 * t320 * t1404 - 0.6160e4 / 0.9e1 * t323 * t1404 - 0.61600e5 / 0.81e2 * t327 * t1404 - 0.61600e5 / 0.81e2 * t330 * t1404 - 0.6160e4 / 0.81e2 * t266 * t1404 - 0.12320e5 / 0.81e2 * t270 * t1404
  t2110 = -0.63064344960000000000000000000000000000000000000000e-1 * t164 * t32 * t167 * t1007 + 0.34685389728000000000000000000000000000000000000000e0 * t164 * t32 * t366 * t542 - 0.10791010137600000000000000000000000000000000000000e1 * t164 * t32 * t744 * t255 + 0.44727351463209150916651459655457286350039441533164e-2 * t1020 * t1291 * t117 * t154 - 0.81322457205834819848457199373558702454617166423936e-3 * t1020 * t1021 * t341 - 0.93888126809937509525986892242036274958085657674134e0 * t257 * t1009 * t554 - 0.74161079640603196860372285710924062778409896822894e-1 * t549 * t30 * t1285 * t259 + 0.29997740079345113336779800961722092809244452647462e-1 * t549 * t1013 * t554 + 0.30178326474622770919067215363511659807956104252400e0 * t257 * t544 * t1028 + t39 * (t1420 + t1457 + t1502 + t1557 + t1612 + t1661 + t1705 + t1745) + t119 * (t1786 + t1823 + t1861 + t1899 + t1946 + t2005 + t2064 + t2105)
  t2116 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t17 * t167 * t156 - 0.5e1 / 0.9e1 * t6 * t23 * t343 + t6 * t160 * t715 / 0.2e1 - t6 * t348 * t1249 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t719 * (t1330 + t2110))
  v4rho4_0_ = 0.2e1 * r0 * t2116 + 0.8e1 * t1254

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t36 = 0.1e1 / t35
  t37 = t32 * t36
  t38 = r0 ** 2
  t39 = r0 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t42 = 0.1e1 / t40 / t38
  t44 = t37 * s0 * t42
  t46 = 0.8040e0 + 0.91462500000000000000000000000000000000000000000000e-2 * t44
  t49 = 0.18040e1 - 0.64641600e0 / t46
  t50 = params.a[0]
  t51 = params.a[1]
  t52 = t32 ** 2
  t54 = 0.3e1 / 0.10e2 * t52 * t35
  t57 = tau0 / t40 / r0
  t58 = t54 - t57
  t59 = t51 * t58
  t60 = t54 + t57
  t61 = 0.1e1 / t60
  t63 = params.a[2]
  t64 = t58 ** 2
  t65 = t63 * t64
  t66 = t60 ** 2
  t67 = 0.1e1 / t66
  t69 = params.a[3]
  t70 = t64 * t58
  t71 = t69 * t70
  t72 = t66 * t60
  t73 = 0.1e1 / t72
  t75 = params.a[4]
  t76 = t64 ** 2
  t77 = t75 * t76
  t78 = t66 ** 2
  t79 = 0.1e1 / t78
  t81 = params.a[5]
  t82 = t76 * t58
  t83 = t81 * t82
  t84 = t78 * t60
  t85 = 0.1e1 / t84
  t87 = params.a[6]
  t88 = t76 * t64
  t89 = t87 * t88
  t91 = 0.1e1 / t78 / t66
  t93 = params.a[7]
  t94 = t76 * t70
  t95 = t93 * t94
  t97 = 0.1e1 / t78 / t72
  t99 = params.a[8]
  t100 = t76 ** 2
  t101 = t99 * t100
  t102 = t78 ** 2
  t103 = 0.1e1 / t102
  t105 = params.a[9]
  t106 = t100 * t58
  t107 = t105 * t106
  t109 = 0.1e1 / t102 / t60
  t111 = params.a[10]
  t112 = t100 * t64
  t113 = t111 * t112
  t115 = 0.1e1 / t102 / t66
  t117 = params.a[11]
  t118 = t100 * t70
  t119 = t117 * t118
  t121 = 0.1e1 / t102 / t72
  t123 = t101 * t103 + t107 * t109 + t113 * t115 + t119 * t121 + t59 * t61 + t65 * t67 + t71 * t73 + t77 * t79 + t83 * t85 + t89 * t91 + t95 * t97 + t50
  t126 = jnp.exp(-0.93189002206715572255024750998986103655990934573866e-2 * t44)
  t128 = 0.1552e1 - 0.552e0 * t126
  t129 = params.b[0]
  t130 = params.b[1]
  t131 = t130 * t58
  t133 = params.b[2]
  t134 = t133 * t64
  t136 = params.b[3]
  t137 = t136 * t70
  t139 = params.b[4]
  t140 = t139 * t76
  t142 = params.b[5]
  t143 = t142 * t82
  t145 = params.b[6]
  t146 = t145 * t88
  t148 = params.b[7]
  t149 = t148 * t94
  t151 = params.b[8]
  t152 = t151 * t100
  t154 = params.b[9]
  t155 = t154 * t106
  t157 = params.b[10]
  t158 = t157 * t112
  t160 = params.b[11]
  t161 = t160 * t118
  t163 = t152 * t103 + t155 * t109 + t158 * t115 + t161 * t121 + t131 * t61 + t134 * t67 + t137 * t73 + t140 * t79 + t143 * t85 + t146 * t91 + t149 * t97 + t129
  t165 = t49 * t123 + t128 * t163
  t169 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t170 = t169 * f.p.zeta_threshold
  t172 = f.my_piecewise3(t20, t170, t21 * t19)
  t173 = t30 ** 2
  t174 = 0.1e1 / t173
  t175 = t172 * t174
  t178 = t5 * t175 * t165 / 0.8e1
  t179 = t172 * t30
  t180 = t46 ** 2
  t183 = 0.1e1 / t180 * t32 * t36
  t184 = t38 * r0
  t186 = 0.1e1 / t40 / t184
  t187 = s0 * t186
  t191 = t51 * tau0
  t192 = t42 * t61
  t195 = t67 * tau0
  t196 = t195 * t42
  t199 = t63 * t58
  t202 = t73 * tau0
  t203 = t202 * t42
  t206 = t69 * t64
  t209 = t79 * tau0
  t210 = t209 * t42
  t213 = t75 * t70
  t216 = t85 * tau0
  t217 = t216 * t42
  t220 = t81 * t76
  t223 = t91 * tau0
  t224 = t223 * t42
  t227 = t87 * t82
  t230 = 0.5e1 / 0.3e1 * t191 * t192 + 0.5e1 / 0.3e1 * t59 * t196 + 0.10e2 / 0.3e1 * t199 * t196 + 0.10e2 / 0.3e1 * t65 * t203 + 0.5e1 * t206 * t203 + 0.5e1 * t71 * t210 + 0.20e2 / 0.3e1 * t213 * t210 + 0.20e2 / 0.3e1 * t77 * t217 + 0.25e2 / 0.3e1 * t220 * t217 + 0.25e2 / 0.3e1 * t83 * t224 + 0.10e2 * t227 * t224
  t231 = t97 * tau0
  t232 = t231 * t42
  t235 = t93 * t88
  t238 = t103 * tau0
  t239 = t238 * t42
  t242 = t99 * t94
  t245 = t109 * tau0
  t246 = t245 * t42
  t249 = t105 * t100
  t252 = t115 * tau0
  t253 = t252 * t42
  t256 = t111 * t106
  t259 = t121 * tau0
  t260 = t259 * t42
  t263 = t117 * t112
  t267 = 0.1e1 / t102 / t78
  t268 = t267 * tau0
  t269 = t268 * t42
  t272 = 0.10e2 * t89 * t232 + 0.35e2 / 0.3e1 * t235 * t232 + 0.35e2 / 0.3e1 * t95 * t239 + 0.40e2 / 0.3e1 * t242 * t239 + 0.40e2 / 0.3e1 * t101 * t246 + 0.15e2 * t249 * t246 + 0.15e2 * t107 * t253 + 0.50e2 / 0.3e1 * t256 * t253 + 0.50e2 / 0.3e1 * t113 * t260 + 0.55e2 / 0.3e1 * t263 * t260 + 0.55e2 / 0.3e1 * t119 * t269
  t273 = t230 + t272
  t275 = t37 * s0
  t276 = t186 * t126
  t280 = t130 * tau0
  t285 = t133 * t58
  t290 = t136 * t64
  t295 = t139 * t70
  t300 = t142 * t76
  t305 = t145 * t82
  t308 = 0.5e1 / 0.3e1 * t280 * t192 + 0.5e1 / 0.3e1 * t131 * t196 + 0.10e2 / 0.3e1 * t285 * t196 + 0.10e2 / 0.3e1 * t134 * t203 + 0.5e1 * t290 * t203 + 0.5e1 * t137 * t210 + 0.20e2 / 0.3e1 * t295 * t210 + 0.20e2 / 0.3e1 * t140 * t217 + 0.25e2 / 0.3e1 * t300 * t217 + 0.25e2 / 0.3e1 * t143 * t224 + 0.10e2 * t305 * t224
  t311 = t148 * t88
  t316 = t151 * t94
  t321 = t154 * t100
  t326 = t157 * t106
  t331 = t160 * t112
  t336 = 0.10e2 * t146 * t232 + 0.35e2 / 0.3e1 * t311 * t232 + 0.35e2 / 0.3e1 * t149 * t239 + 0.40e2 / 0.3e1 * t316 * t239 + 0.40e2 / 0.3e1 * t152 * t246 + 0.15e2 * t321 * t246 + 0.15e2 * t155 * t253 + 0.50e2 / 0.3e1 * t326 * t253 + 0.50e2 / 0.3e1 * t158 * t260 + 0.55e2 / 0.3e1 * t331 * t260 + 0.55e2 / 0.3e1 * t161 * t269
  t337 = t308 + t336
  t339 = -0.15766086240000000000000000000000000000000000000000e-1 * t183 * t187 * t123 + t49 * t273 - 0.13717421124828532235939643347050754458161865569273e-1 * t275 * t276 * t163 + t128 * t337
  t344 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t165 - t178 - 0.3e1 / 0.8e1 * t5 * t179 * t339)
  t346 = r1 <= f.p.dens_threshold
  t347 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t348 = 0.1e1 + t347
  t349 = t348 <= f.p.zeta_threshold
  t350 = t348 ** (0.1e1 / 0.3e1)
  t352 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t355 = f.my_piecewise3(t349, 0, 0.4e1 / 0.3e1 * t350 * t352)
  t356 = t355 * t30
  t357 = r1 ** 2
  t358 = r1 ** (0.1e1 / 0.3e1)
  t359 = t358 ** 2
  t361 = 0.1e1 / t359 / t357
  t363 = t37 * s2 * t361
  t365 = 0.8040e0 + 0.91462500000000000000000000000000000000000000000000e-2 * t363
  t368 = 0.18040e1 - 0.64641600e0 / t365
  t371 = tau1 / t359 / r1
  t372 = t54 - t371
  t373 = t51 * t372
  t374 = t54 + t371
  t375 = 0.1e1 / t374
  t377 = t372 ** 2
  t378 = t63 * t377
  t379 = t374 ** 2
  t380 = 0.1e1 / t379
  t382 = t377 * t372
  t383 = t69 * t382
  t384 = t379 * t374
  t385 = 0.1e1 / t384
  t387 = t377 ** 2
  t388 = t75 * t387
  t389 = t379 ** 2
  t390 = 0.1e1 / t389
  t392 = t387 * t372
  t393 = t81 * t392
  t394 = t389 * t374
  t395 = 0.1e1 / t394
  t397 = t387 * t377
  t398 = t87 * t397
  t400 = 0.1e1 / t389 / t379
  t402 = t387 * t382
  t403 = t93 * t402
  t405 = 0.1e1 / t389 / t384
  t407 = t387 ** 2
  t408 = t99 * t407
  t409 = t389 ** 2
  t410 = 0.1e1 / t409
  t412 = t407 * t372
  t413 = t105 * t412
  t415 = 0.1e1 / t409 / t374
  t417 = t407 * t377
  t418 = t111 * t417
  t420 = 0.1e1 / t409 / t379
  t422 = t407 * t382
  t423 = t117 * t422
  t425 = 0.1e1 / t409 / t384
  t427 = t373 * t375 + t378 * t380 + t383 * t385 + t388 * t390 + t393 * t395 + t398 * t400 + t403 * t405 + t408 * t410 + t413 * t415 + t418 * t420 + t423 * t425 + t50
  t430 = jnp.exp(-0.93189002206715572255024750998986103655990934573866e-2 * t363)
  t432 = 0.1552e1 - 0.552e0 * t430
  t433 = t130 * t372
  t435 = t133 * t377
  t437 = t136 * t382
  t439 = t139 * t387
  t441 = t142 * t392
  t443 = t145 * t397
  t445 = t148 * t402
  t447 = t151 * t407
  t449 = t154 * t412
  t451 = t157 * t417
  t453 = t160 * t422
  t455 = t433 * t375 + t435 * t380 + t437 * t385 + t439 * t390 + t441 * t395 + t443 * t400 + t445 * t405 + t447 * t410 + t449 * t415 + t451 * t420 + t453 * t425 + t129
  t457 = t368 * t427 + t432 * t455
  t462 = f.my_piecewise3(t349, t170, t350 * t348)
  t463 = t462 * t174
  t466 = t5 * t463 * t457 / 0.8e1
  t468 = f.my_piecewise3(t346, 0, -0.3e1 / 0.8e1 * t5 * t356 * t457 - t466)
  t470 = t21 ** 2
  t471 = 0.1e1 / t470
  t472 = t26 ** 2
  t477 = t16 / t22 / t6
  t479 = -0.2e1 * t23 + 0.2e1 * t477
  t480 = f.my_piecewise5(t10, 0, t14, 0, t479)
  t484 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t471 * t472 + 0.4e1 / 0.3e1 * t21 * t480)
  t491 = t5 * t29 * t174 * t165
  t497 = 0.1e1 / t173 / t6
  t501 = t5 * t172 * t497 * t165 / 0.12e2
  t503 = t5 * t175 * t339
  t509 = 0.1e1 / t34 / t33
  t511 = s0 ** 2
  t512 = t38 ** 2
  t515 = 0.1e1 / t39 / t512 / t184
  t521 = 0.1e1 / t40 / t512
  t529 = tau0 ** 2
  t533 = 0.1e1 / t39 / t512 / r0
  t534 = t267 * t529 * t533
  t539 = t121 * t529 * t533
  t547 = 0.1e1 / t102 / t84 * t529 * t533
  t552 = t73 * t529 * t533
  t556 = t79 * t529 * t533
  t560 = t85 * t529 * t533
  t569 = t91 * t529 * t533
  t578 = t97 * t529 * t533
  t581 = 0.2750e4 / 0.9e1 * t113 * t534 + 0.2750e4 / 0.9e1 * t117 * t106 * t539 + 0.6050e4 / 0.9e1 * t263 * t534 + 0.1100e4 / 0.3e1 * t119 * t547 + 0.50e2 / 0.3e1 * t69 * t58 * t552 + 0.50e2 * t206 * t556 + 0.100e3 / 0.3e1 * t71 * t560 + 0.100e3 / 0.3e1 * t75 * t64 * t556 + 0.800e3 / 0.9e1 * t213 * t560 + 0.500e3 / 0.9e1 * t77 * t569 + 0.500e3 / 0.9e1 * t81 * t70 * t560 + 0.1250e4 / 0.9e1 * t220 * t569 + 0.250e3 / 0.3e1 * t83 * t578
  t588 = t103 * t529 * t533
  t602 = t195 * t186
  t607 = t202 * t186
  t612 = t209 * t186
  t617 = 0.250e3 / 0.3e1 * t87 * t76 * t569 + 0.200e3 * t227 * t578 + 0.350e3 / 0.3e1 * t89 * t588 + 0.350e3 / 0.3e1 * t93 * t82 * t578 + 0.2450e4 / 0.9e1 * t235 * t588 + 0.50e2 / 0.9e1 * t59 * t552 + 0.200e3 / 0.9e1 * t199 * t552 + 0.50e2 / 0.3e1 * t65 * t556 - 0.40e2 / 0.9e1 * t59 * t602 - 0.80e2 / 0.9e1 * t199 * t602 - 0.80e2 / 0.9e1 * t65 * t607 - 0.40e2 / 0.3e1 * t206 * t607 - 0.40e2 / 0.3e1 * t71 * t612 - 0.160e3 / 0.9e1 * t213 * t612
  t619 = t216 * t186
  t624 = t223 * t186
  t629 = t231 * t186
  t634 = t238 * t186
  t639 = t245 * t186
  t644 = t252 * t186
  t649 = t259 * t186
  t652 = -0.160e3 / 0.9e1 * t77 * t619 - 0.200e3 / 0.9e1 * t220 * t619 - 0.200e3 / 0.9e1 * t83 * t624 - 0.80e2 / 0.3e1 * t227 * t624 - 0.80e2 / 0.3e1 * t89 * t629 - 0.280e3 / 0.9e1 * t235 * t629 - 0.280e3 / 0.9e1 * t95 * t634 - 0.320e3 / 0.9e1 * t242 * t634 - 0.320e3 / 0.9e1 * t101 * t639 - 0.40e2 * t249 * t639 - 0.40e2 * t107 * t644 - 0.400e3 / 0.9e1 * t256 * t644 - 0.400e3 / 0.9e1 * t113 * t649
  t655 = t268 * t186
  t659 = t109 * t529 * t533
  t668 = t115 * t529 * t533
  t684 = t533 * t67
  t687 = t186 * t61
  t693 = -0.440e3 / 0.9e1 * t263 * t649 - 0.440e3 / 0.9e1 * t119 * t655 + 0.1400e4 / 0.9e1 * t95 * t659 + 0.1400e4 / 0.9e1 * t99 * t88 * t588 + 0.3200e4 / 0.9e1 * t242 * t659 + 0.200e3 * t101 * t668 + 0.200e3 * t105 * t94 * t659 + 0.450e3 * t249 * t668 + 0.250e3 * t107 * t539 + 0.250e3 * t111 * t100 * t668 + 0.5000e4 / 0.9e1 * t256 * t539 + 0.50e2 / 0.9e1 * t63 * t529 * t684 - 0.40e2 / 0.9e1 * t191 * t687 + 0.50e2 / 0.9e1 * t51 * t529 * t684
  t701 = t52 * t509
  t740 = 0.50e2 / 0.3e1 * t136 * t58 * t552 + 0.50e2 * t290 * t556 + 0.100e3 / 0.3e1 * t137 * t560 + 0.100e3 / 0.3e1 * t139 * t64 * t556 + 0.800e3 / 0.9e1 * t295 * t560 + 0.500e3 / 0.9e1 * t140 * t569 + 0.500e3 / 0.9e1 * t142 * t70 * t560 + 0.1250e4 / 0.9e1 * t300 * t569 + 0.250e3 / 0.3e1 * t143 * t578 + 0.250e3 / 0.3e1 * t145 * t76 * t569 + 0.200e3 * t305 * t578 - 0.40e2 / 0.9e1 * t131 * t602 - 0.80e2 / 0.9e1 * t285 * t602
  t769 = -0.80e2 / 0.9e1 * t134 * t607 - 0.40e2 / 0.3e1 * t290 * t607 - 0.40e2 / 0.3e1 * t137 * t612 - 0.160e3 / 0.9e1 * t295 * t612 - 0.160e3 / 0.9e1 * t140 * t619 - 0.200e3 / 0.9e1 * t300 * t619 - 0.200e3 / 0.9e1 * t143 * t624 - 0.80e2 / 0.3e1 * t305 * t624 - 0.80e2 / 0.3e1 * t146 * t629 - 0.280e3 / 0.9e1 * t311 * t629 - 0.280e3 / 0.9e1 * t149 * t634 - 0.320e3 / 0.9e1 * t316 * t634 - 0.320e3 / 0.9e1 * t152 * t639 - 0.40e2 * t321 * t639
  t800 = -0.40e2 * t155 * t644 - 0.400e3 / 0.9e1 * t326 * t644 - 0.400e3 / 0.9e1 * t158 * t649 - 0.440e3 / 0.9e1 * t331 * t649 - 0.440e3 / 0.9e1 * t161 * t655 + 0.2750e4 / 0.9e1 * t160 * t106 * t539 + 0.6050e4 / 0.9e1 * t331 * t534 + 0.1100e4 / 0.3e1 * t161 * t547 + 0.350e3 / 0.3e1 * t146 * t588 + 0.350e3 / 0.3e1 * t148 * t82 * t578 + 0.2450e4 / 0.9e1 * t311 * t588 + 0.1400e4 / 0.9e1 * t149 * t659 + 0.1400e4 / 0.9e1 * t151 * t88 * t588
  t833 = 0.3200e4 / 0.9e1 * t316 * t659 + 0.200e3 * t152 * t668 + 0.200e3 * t154 * t94 * t659 + 0.450e3 * t321 * t668 + 0.250e3 * t155 * t539 + 0.250e3 * t157 * t100 * t668 + 0.5000e4 / 0.9e1 * t326 * t539 + 0.2750e4 / 0.9e1 * t158 * t534 + 0.50e2 / 0.9e1 * t131 * t552 + 0.200e3 / 0.9e1 * t285 * t552 + 0.50e2 / 0.3e1 * t134 * t556 - 0.40e2 / 0.9e1 * t280 * t687 + 0.50e2 / 0.9e1 * t130 * t529 * t684 + 0.50e2 / 0.9e1 * t133 * t529 * t684
  t842 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t484 * t30 * t165 - t491 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t339 + t501 - t503 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t179 * (-0.76906968678720000000000000000000000000000000000000e-3 / t180 / t46 * t52 * t509 * t511 * t515 * t123 + 0.57808982880000000000000000000000000000000000000000e-1 * t183 * s0 * t521 * t123 - 0.31532172480000000000000000000000000000000000000000e-1 * t183 * t187 * t273 + t49 * (t581 + t617 + t652 + t693) + 0.50297210791037951531778692272519433013260173754001e-1 * t275 * t521 * t126 * t163 - 0.34088340999255810609977046547411469101414150735753e-3 * t701 * t511 * t515 * t126 * t163 - 0.27434842249657064471879286694101508916323731138546e-1 * t275 * t276 * t337 + t128 * (t740 + t769 + t800 + t833)))
  t843 = t350 ** 2
  t844 = 0.1e1 / t843
  t845 = t352 ** 2
  t849 = f.my_piecewise5(t14, 0, t10, 0, -t479)
  t853 = f.my_piecewise3(t349, 0, 0.4e1 / 0.9e1 * t844 * t845 + 0.4e1 / 0.3e1 * t350 * t849)
  t860 = t5 * t355 * t174 * t457
  t865 = t5 * t462 * t497 * t457 / 0.12e2
  t867 = f.my_piecewise3(t346, 0, -0.3e1 / 0.8e1 * t5 * t853 * t30 * t457 - t860 / 0.4e1 + t865)
  d11 = 0.2e1 * t344 + 0.2e1 * t468 + t6 * (t842 + t867)
  t870 = -t7 - t24
  t871 = f.my_piecewise5(t10, 0, t14, 0, t870)
  t874 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t871)
  t875 = t874 * t30
  t880 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t875 * t165 - t178)
  t882 = f.my_piecewise5(t14, 0, t10, 0, -t870)
  t885 = f.my_piecewise3(t349, 0, 0.4e1 / 0.3e1 * t350 * t882)
  t886 = t885 * t30
  t890 = t462 * t30
  t891 = t365 ** 2
  t894 = 0.1e1 / t891 * t32 * t36
  t895 = t357 * r1
  t897 = 0.1e1 / t359 / t895
  t898 = s2 * t897
  t902 = t51 * tau1
  t903 = t361 * t375
  t906 = t380 * tau1
  t907 = t906 * t361
  t910 = t63 * t372
  t913 = t385 * tau1
  t914 = t913 * t361
  t917 = t69 * t377
  t920 = t390 * tau1
  t921 = t920 * t361
  t924 = t75 * t382
  t927 = t395 * tau1
  t928 = t927 * t361
  t931 = t81 * t387
  t934 = t400 * tau1
  t935 = t934 * t361
  t938 = t87 * t392
  t941 = 0.5e1 / 0.3e1 * t902 * t903 + 0.5e1 / 0.3e1 * t373 * t907 + 0.10e2 / 0.3e1 * t910 * t907 + 0.10e2 / 0.3e1 * t378 * t914 + 0.5e1 * t917 * t914 + 0.5e1 * t383 * t921 + 0.20e2 / 0.3e1 * t924 * t921 + 0.20e2 / 0.3e1 * t388 * t928 + 0.25e2 / 0.3e1 * t931 * t928 + 0.25e2 / 0.3e1 * t393 * t935 + 0.10e2 * t938 * t935
  t942 = t405 * tau1
  t943 = t942 * t361
  t946 = t93 * t397
  t949 = t410 * tau1
  t950 = t949 * t361
  t953 = t99 * t402
  t956 = t415 * tau1
  t957 = t956 * t361
  t960 = t105 * t407
  t963 = t420 * tau1
  t964 = t963 * t361
  t967 = t111 * t412
  t970 = t425 * tau1
  t971 = t970 * t361
  t974 = t117 * t417
  t978 = 0.1e1 / t409 / t389
  t979 = t978 * tau1
  t980 = t979 * t361
  t983 = 0.10e2 * t398 * t943 + 0.35e2 / 0.3e1 * t946 * t943 + 0.35e2 / 0.3e1 * t403 * t950 + 0.40e2 / 0.3e1 * t953 * t950 + 0.40e2 / 0.3e1 * t408 * t957 + 0.15e2 * t960 * t957 + 0.15e2 * t413 * t964 + 0.50e2 / 0.3e1 * t967 * t964 + 0.50e2 / 0.3e1 * t418 * t971 + 0.55e2 / 0.3e1 * t974 * t971 + 0.55e2 / 0.3e1 * t423 * t980
  t984 = t941 + t983
  t986 = t37 * s2
  t987 = t897 * t430
  t991 = t130 * tau1
  t996 = t133 * t372
  t1001 = t136 * t377
  t1006 = t139 * t382
  t1011 = t142 * t387
  t1016 = t145 * t392
  t1019 = 0.5e1 / 0.3e1 * t991 * t903 + 0.5e1 / 0.3e1 * t433 * t907 + 0.10e2 / 0.3e1 * t996 * t907 + 0.10e2 / 0.3e1 * t435 * t914 + 0.5e1 * t1001 * t914 + 0.5e1 * t437 * t921 + 0.20e2 / 0.3e1 * t1006 * t921 + 0.20e2 / 0.3e1 * t439 * t928 + 0.25e2 / 0.3e1 * t1011 * t928 + 0.25e2 / 0.3e1 * t441 * t935 + 0.10e2 * t1016 * t935
  t1022 = t148 * t397
  t1027 = t151 * t402
  t1032 = t154 * t407
  t1037 = t157 * t412
  t1042 = t160 * t417
  t1047 = 0.10e2 * t443 * t943 + 0.35e2 / 0.3e1 * t1022 * t943 + 0.35e2 / 0.3e1 * t445 * t950 + 0.40e2 / 0.3e1 * t1027 * t950 + 0.40e2 / 0.3e1 * t447 * t957 + 0.15e2 * t1032 * t957 + 0.15e2 * t449 * t964 + 0.50e2 / 0.3e1 * t1037 * t964 + 0.50e2 / 0.3e1 * t451 * t971 + 0.55e2 / 0.3e1 * t1042 * t971 + 0.55e2 / 0.3e1 * t453 * t980
  t1048 = t1019 + t1047
  t1050 = -0.15766086240000000000000000000000000000000000000000e-1 * t894 * t898 * t427 + t368 * t984 - 0.13717421124828532235939643347050754458161865569273e-1 * t986 * t987 * t455 + t432 * t1048
  t1055 = f.my_piecewise3(t346, 0, -0.3e1 / 0.8e1 * t5 * t886 * t457 - t466 - 0.3e1 / 0.8e1 * t5 * t890 * t1050)
  t1059 = 0.2e1 * t477
  t1060 = f.my_piecewise5(t10, 0, t14, 0, t1059)
  t1064 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t471 * t871 * t26 + 0.4e1 / 0.3e1 * t21 * t1060)
  t1071 = t5 * t874 * t174 * t165
  t1079 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1064 * t30 * t165 - t1071 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t875 * t339 - t491 / 0.8e1 + t501 - t503 / 0.8e1)
  t1083 = f.my_piecewise5(t14, 0, t10, 0, -t1059)
  t1087 = f.my_piecewise3(t349, 0, 0.4e1 / 0.9e1 * t844 * t882 * t352 + 0.4e1 / 0.3e1 * t350 * t1083)
  t1094 = t5 * t885 * t174 * t457
  t1101 = t5 * t463 * t1050
  t1104 = f.my_piecewise3(t346, 0, -0.3e1 / 0.8e1 * t5 * t1087 * t30 * t457 - t1094 / 0.8e1 - t860 / 0.8e1 + t865 - 0.3e1 / 0.8e1 * t5 * t356 * t1050 - t1101 / 0.8e1)
  d12 = t344 + t468 + t880 + t1055 + t6 * (t1079 + t1104)
  t1109 = t871 ** 2
  t1113 = 0.2e1 * t23 + 0.2e1 * t477
  t1114 = f.my_piecewise5(t10, 0, t14, 0, t1113)
  t1118 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t471 * t1109 + 0.4e1 / 0.3e1 * t21 * t1114)
  t1125 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1118 * t30 * t165 - t1071 / 0.4e1 + t501)
  t1126 = t882 ** 2
  t1130 = f.my_piecewise5(t14, 0, t10, 0, -t1113)
  t1134 = f.my_piecewise3(t349, 0, 0.4e1 / 0.9e1 * t844 * t1126 + 0.4e1 / 0.3e1 * t350 * t1130)
  t1148 = s2 ** 2
  t1149 = t357 ** 2
  t1152 = 0.1e1 / t358 / t1149 / t895
  t1158 = 0.1e1 / t359 / t1149
  t1167 = tau1 ** 2
  t1171 = 0.1e1 / t358 / t1149 / r1
  t1172 = t385 * t1167 * t1171
  t1176 = t390 * t1167 * t1171
  t1180 = t395 * t1167 * t1171
  t1189 = t400 * t1167 * t1171
  t1198 = t405 * t1167 * t1171
  t1207 = t410 * t1167 * t1171
  t1212 = 0.50e2 / 0.3e1 * t69 * t372 * t1172 + 0.50e2 * t917 * t1176 + 0.100e3 / 0.3e1 * t383 * t1180 + 0.100e3 / 0.3e1 * t75 * t377 * t1176 + 0.800e3 / 0.9e1 * t924 * t1180 + 0.500e3 / 0.9e1 * t388 * t1189 + 0.500e3 / 0.9e1 * t81 * t382 * t1180 + 0.1250e4 / 0.9e1 * t931 * t1189 + 0.250e3 / 0.3e1 * t393 * t1198 + 0.250e3 / 0.3e1 * t87 * t387 * t1189 + 0.200e3 * t938 * t1198 + 0.350e3 / 0.3e1 * t398 * t1207 + 0.50e2 / 0.9e1 * t373 * t1172
  t1215 = t906 * t897
  t1220 = t913 * t897
  t1225 = t920 * t897
  t1230 = t927 * t897
  t1235 = t934 * t897
  t1240 = t942 * t897
  t1245 = t949 * t897
  t1248 = 0.200e3 / 0.9e1 * t910 * t1172 - 0.40e2 / 0.9e1 * t373 * t1215 - 0.80e2 / 0.9e1 * t910 * t1215 - 0.80e2 / 0.9e1 * t378 * t1220 - 0.40e2 / 0.3e1 * t917 * t1220 - 0.40e2 / 0.3e1 * t383 * t1225 - 0.160e3 / 0.9e1 * t924 * t1225 - 0.160e3 / 0.9e1 * t388 * t1230 - 0.200e3 / 0.9e1 * t931 * t1230 - 0.200e3 / 0.9e1 * t393 * t1235 - 0.80e2 / 0.3e1 * t938 * t1235 - 0.80e2 / 0.3e1 * t398 * t1240 - 0.280e3 / 0.9e1 * t946 * t1240 - 0.280e3 / 0.9e1 * t403 * t1245
  t1252 = t956 * t897
  t1257 = t963 * t897
  t1262 = t970 * t897
  t1270 = 0.1e1 / t409 / t394 * t1167 * t1171
  t1279 = t415 * t1167 * t1171
  t1282 = t979 * t897
  t1288 = -0.320e3 / 0.9e1 * t953 * t1245 - 0.320e3 / 0.9e1 * t408 * t1252 - 0.40e2 * t960 * t1252 - 0.40e2 * t413 * t1257 - 0.400e3 / 0.9e1 * t967 * t1257 - 0.400e3 / 0.9e1 * t418 * t1262 - 0.440e3 / 0.9e1 * t974 * t1262 + 0.1100e4 / 0.3e1 * t423 * t1270 + 0.350e3 / 0.3e1 * t93 * t392 * t1198 + 0.2450e4 / 0.9e1 * t946 * t1207 + 0.1400e4 / 0.9e1 * t403 * t1279 - 0.440e3 / 0.9e1 * t423 * t1282 + 0.1400e4 / 0.9e1 * t99 * t397 * t1207
  t1292 = t420 * t1167 * t1171
  t1301 = t425 * t1167 * t1171
  t1310 = t978 * t1167 * t1171
  t1321 = t1171 * t380
  t1327 = t897 * t375
  t1330 = 0.3200e4 / 0.9e1 * t953 * t1279 + 0.200e3 * t408 * t1292 + 0.200e3 * t105 * t402 * t1279 + 0.450e3 * t960 * t1292 + 0.250e3 * t413 * t1301 + 0.250e3 * t111 * t407 * t1292 + 0.5000e4 / 0.9e1 * t967 * t1301 + 0.2750e4 / 0.9e1 * t418 * t1310 + 0.2750e4 / 0.9e1 * t117 * t412 * t1301 + 0.6050e4 / 0.9e1 * t974 * t1310 + 0.50e2 / 0.3e1 * t378 * t1176 + 0.50e2 / 0.9e1 * t51 * t1167 * t1321 + 0.50e2 / 0.9e1 * t63 * t1167 * t1321 - 0.40e2 / 0.9e1 * t902 * t1327
  t1375 = 0.50e2 / 0.3e1 * t435 * t1176 + 0.50e2 / 0.3e1 * t136 * t372 * t1172 + 0.50e2 * t1001 * t1176 + 0.100e3 / 0.3e1 * t437 * t1180 + 0.100e3 / 0.3e1 * t139 * t377 * t1176 + 0.800e3 / 0.9e1 * t1006 * t1180 + 0.500e3 / 0.9e1 * t439 * t1189 + 0.500e3 / 0.9e1 * t142 * t382 * t1180 + 0.1250e4 / 0.9e1 * t1011 * t1189 - 0.40e2 / 0.9e1 * t433 * t1215 - 0.80e2 / 0.9e1 * t996 * t1215 - 0.80e2 / 0.9e1 * t435 * t1220 - 0.40e2 / 0.3e1 * t1001 * t1220
  t1404 = -0.40e2 / 0.3e1 * t437 * t1225 - 0.160e3 / 0.9e1 * t1006 * t1225 - 0.160e3 / 0.9e1 * t439 * t1230 - 0.200e3 / 0.9e1 * t1011 * t1230 - 0.200e3 / 0.9e1 * t441 * t1235 - 0.80e2 / 0.3e1 * t1016 * t1235 - 0.80e2 / 0.3e1 * t443 * t1240 - 0.280e3 / 0.9e1 * t1022 * t1240 - 0.280e3 / 0.9e1 * t445 * t1245 - 0.320e3 / 0.9e1 * t1027 * t1245 - 0.320e3 / 0.9e1 * t447 * t1252 - 0.40e2 * t1032 * t1252 - 0.40e2 * t449 * t1257 - 0.400e3 / 0.9e1 * t1037 * t1257
  t1435 = -0.400e3 / 0.9e1 * t451 * t1262 - 0.440e3 / 0.9e1 * t1042 * t1262 - 0.440e3 / 0.9e1 * t453 * t1282 + 0.250e3 * t157 * t407 * t1292 + 0.5000e4 / 0.9e1 * t1037 * t1301 + 0.2750e4 / 0.9e1 * t451 * t1310 + 0.2750e4 / 0.9e1 * t160 * t412 * t1301 + 0.6050e4 / 0.9e1 * t1042 * t1310 + 0.1100e4 / 0.3e1 * t453 * t1270 + 0.250e3 / 0.3e1 * t441 * t1198 + 0.250e3 / 0.3e1 * t145 * t387 * t1189 + 0.200e3 * t1016 * t1198 + 0.350e3 / 0.3e1 * t443 * t1207
  t1469 = 0.350e3 / 0.3e1 * t148 * t392 * t1198 + 0.2450e4 / 0.9e1 * t1022 * t1207 + 0.1400e4 / 0.9e1 * t445 * t1279 + 0.1400e4 / 0.9e1 * t151 * t397 * t1207 + 0.3200e4 / 0.9e1 * t1027 * t1279 + 0.200e3 * t447 * t1292 + 0.200e3 * t154 * t402 * t1279 + 0.450e3 * t1032 * t1292 + 0.250e3 * t449 * t1301 + 0.50e2 / 0.9e1 * t433 * t1172 + 0.200e3 / 0.9e1 * t996 * t1172 + 0.50e2 / 0.9e1 * t130 * t1167 * t1321 + 0.50e2 / 0.9e1 * t133 * t1167 * t1321 - 0.40e2 / 0.9e1 * t991 * t1327
  t1478 = f.my_piecewise3(t346, 0, -0.3e1 / 0.8e1 * t5 * t1134 * t30 * t457 - t1094 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t886 * t1050 + t865 - t1101 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t890 * (-0.76906968678720000000000000000000000000000000000000e-3 / t891 / t365 * t52 * t509 * t1148 * t1152 * t427 + 0.57808982880000000000000000000000000000000000000000e-1 * t894 * s2 * t1158 * t427 - 0.31532172480000000000000000000000000000000000000000e-1 * t894 * t898 * t984 + t368 * (t1212 + t1248 + t1288 + t1330) + 0.50297210791037951531778692272519433013260173754001e-1 * t986 * t1158 * t430 * t455 - 0.34088340999255810609977046547411469101414150735753e-3 * t701 * t1148 * t1152 * t430 * t455 - 0.27434842249657064471879286694101508916323731138546e-1 * t986 * t987 * t1048 + t432 * (t1375 + t1404 + t1435 + t1469)))
  d22 = 0.2e1 * t880 + 0.2e1 * t1055 + t6 * (t1125 + t1478)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 6 ** (0.1e1 / 0.3e1)
  t45 = jnp.pi ** 2
  t46 = t45 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t48 = 0.1e1 / t47
  t49 = t44 * t48
  t50 = r0 ** 2
  t51 = r0 ** (0.1e1 / 0.3e1)
  t52 = t51 ** 2
  t54 = 0.1e1 / t52 / t50
  t56 = t49 * s0 * t54
  t58 = 0.8040e0 + 0.91462500000000000000000000000000000000000000000000e-2 * t56
  t61 = 0.18040e1 - 0.64641600e0 / t58
  t62 = params.a[0]
  t63 = params.a[1]
  t64 = t44 ** 2
  t66 = 0.3e1 / 0.10e2 * t64 * t47
  t69 = tau0 / t52 / r0
  t70 = t66 - t69
  t71 = t63 * t70
  t72 = t66 + t69
  t73 = 0.1e1 / t72
  t75 = params.a[2]
  t76 = t70 ** 2
  t77 = t75 * t76
  t78 = t72 ** 2
  t79 = 0.1e1 / t78
  t81 = params.a[3]
  t82 = t76 * t70
  t83 = t81 * t82
  t84 = t78 * t72
  t85 = 0.1e1 / t84
  t87 = params.a[4]
  t88 = t76 ** 2
  t89 = t87 * t88
  t90 = t78 ** 2
  t91 = 0.1e1 / t90
  t93 = params.a[5]
  t94 = t88 * t70
  t95 = t93 * t94
  t96 = t90 * t72
  t97 = 0.1e1 / t96
  t99 = params.a[6]
  t100 = t88 * t76
  t101 = t99 * t100
  t102 = t90 * t78
  t103 = 0.1e1 / t102
  t105 = params.a[7]
  t106 = t88 * t82
  t107 = t105 * t106
  t109 = 0.1e1 / t90 / t84
  t111 = params.a[8]
  t112 = t88 ** 2
  t113 = t111 * t112
  t114 = t90 ** 2
  t115 = 0.1e1 / t114
  t117 = params.a[9]
  t118 = t112 * t70
  t119 = t117 * t118
  t121 = 0.1e1 / t114 / t72
  t123 = params.a[10]
  t124 = t112 * t76
  t125 = t123 * t124
  t127 = 0.1e1 / t114 / t78
  t129 = params.a[11]
  t130 = t112 * t82
  t131 = t129 * t130
  t133 = 0.1e1 / t114 / t84
  t135 = t101 * t103 + t107 * t109 + t113 * t115 + t119 * t121 + t125 * t127 + t131 * t133 + t71 * t73 + t77 * t79 + t83 * t85 + t89 * t91 + t95 * t97 + t62
  t138 = jnp.exp(-0.93189002206715572255024750998986103655990934573866e-2 * t56)
  t140 = 0.1552e1 - 0.552e0 * t138
  t141 = params.b[0]
  t142 = params.b[1]
  t143 = t142 * t70
  t145 = params.b[2]
  t146 = t145 * t76
  t148 = params.b[3]
  t149 = t148 * t82
  t151 = params.b[4]
  t152 = t151 * t88
  t154 = params.b[5]
  t155 = t154 * t94
  t157 = params.b[6]
  t158 = t157 * t100
  t160 = params.b[7]
  t161 = t160 * t106
  t163 = params.b[8]
  t164 = t163 * t112
  t166 = params.b[9]
  t167 = t166 * t118
  t169 = params.b[10]
  t170 = t169 * t124
  t172 = params.b[11]
  t173 = t172 * t130
  t175 = t158 * t103 + t161 * t109 + t164 * t115 + t167 * t121 + t170 * t127 + t173 * t133 + t143 * t73 + t146 * t79 + t149 * t85 + t152 * t91 + t155 * t97 + t141
  t177 = t61 * t135 + t140 * t175
  t183 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t184 = t42 ** 2
  t185 = 0.1e1 / t184
  t186 = t183 * t185
  t190 = t183 * t42
  t191 = t58 ** 2
  t194 = 0.1e1 / t191 * t44 * t48
  t195 = t50 * r0
  t197 = 0.1e1 / t52 / t195
  t198 = s0 * t197
  t202 = t63 * tau0
  t203 = t54 * t73
  t206 = t79 * tau0
  t207 = t206 * t54
  t210 = t75 * t70
  t213 = t85 * tau0
  t214 = t213 * t54
  t217 = t81 * t76
  t220 = t91 * tau0
  t221 = t220 * t54
  t224 = t87 * t82
  t227 = t97 * tau0
  t228 = t227 * t54
  t231 = t93 * t88
  t234 = t103 * tau0
  t235 = t234 * t54
  t238 = t99 * t94
  t241 = 0.5e1 / 0.3e1 * t202 * t203 + 0.5e1 / 0.3e1 * t71 * t207 + 0.10e2 / 0.3e1 * t210 * t207 + 0.10e2 / 0.3e1 * t77 * t214 + 0.5e1 * t217 * t214 + 0.5e1 * t83 * t221 + 0.20e2 / 0.3e1 * t224 * t221 + 0.20e2 / 0.3e1 * t89 * t228 + 0.25e2 / 0.3e1 * t231 * t228 + 0.25e2 / 0.3e1 * t95 * t235 + 0.10e2 * t238 * t235
  t242 = t109 * tau0
  t243 = t242 * t54
  t246 = t105 * t100
  t249 = t115 * tau0
  t250 = t249 * t54
  t253 = t111 * t106
  t256 = t121 * tau0
  t257 = t256 * t54
  t260 = t117 * t112
  t263 = t127 * tau0
  t264 = t263 * t54
  t267 = t123 * t118
  t270 = t133 * tau0
  t271 = t270 * t54
  t274 = t129 * t124
  t278 = 0.1e1 / t114 / t90
  t279 = t278 * tau0
  t280 = t279 * t54
  t283 = 0.10e2 * t101 * t243 + 0.35e2 / 0.3e1 * t246 * t243 + 0.35e2 / 0.3e1 * t107 * t250 + 0.40e2 / 0.3e1 * t253 * t250 + 0.40e2 / 0.3e1 * t113 * t257 + 0.15e2 * t260 * t257 + 0.15e2 * t119 * t264 + 0.50e2 / 0.3e1 * t267 * t264 + 0.50e2 / 0.3e1 * t125 * t271 + 0.55e2 / 0.3e1 * t274 * t271 + 0.55e2 / 0.3e1 * t131 * t280
  t284 = t241 + t283
  t286 = t49 * s0
  t287 = t197 * t138
  t291 = t142 * tau0
  t296 = t145 * t70
  t301 = t148 * t76
  t306 = t151 * t82
  t311 = t154 * t88
  t316 = t157 * t94
  t319 = 0.5e1 / 0.3e1 * t291 * t203 + 0.5e1 / 0.3e1 * t143 * t207 + 0.10e2 / 0.3e1 * t296 * t207 + 0.10e2 / 0.3e1 * t146 * t214 + 0.5e1 * t301 * t214 + 0.5e1 * t149 * t221 + 0.20e2 / 0.3e1 * t306 * t221 + 0.20e2 / 0.3e1 * t152 * t228 + 0.25e2 / 0.3e1 * t311 * t228 + 0.25e2 / 0.3e1 * t155 * t235 + 0.10e2 * t316 * t235
  t322 = t160 * t100
  t327 = t163 * t106
  t332 = t166 * t112
  t337 = t169 * t118
  t342 = t172 * t124
  t347 = 0.10e2 * t158 * t243 + 0.35e2 / 0.3e1 * t322 * t243 + 0.35e2 / 0.3e1 * t161 * t250 + 0.40e2 / 0.3e1 * t327 * t250 + 0.40e2 / 0.3e1 * t164 * t257 + 0.15e2 * t332 * t257 + 0.15e2 * t167 * t264 + 0.50e2 / 0.3e1 * t337 * t264 + 0.50e2 / 0.3e1 * t170 * t271 + 0.55e2 / 0.3e1 * t342 * t271 + 0.55e2 / 0.3e1 * t173 * t280
  t348 = t319 + t347
  t350 = -0.15766086240000000000000000000000000000000000000000e-1 * t194 * t198 * t135 + t61 * t284 - 0.13717421124828532235939643347050754458161865569273e-1 * t286 * t287 * t175 + t140 * t348
  t354 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t355 = t354 * f.p.zeta_threshold
  t357 = f.my_piecewise3(t20, t355, t21 * t19)
  t359 = 0.1e1 / t184 / t6
  t360 = t357 * t359
  t364 = t357 * t185
  t368 = t357 * t42
  t373 = 0.1e1 / t46 / t45
  t374 = 0.1e1 / t191 / t58 * t64 * t373
  t375 = s0 ** 2
  t376 = t50 ** 2
  t379 = 0.1e1 / t51 / t376 / t195
  t380 = t375 * t379
  t385 = 0.1e1 / t52 / t376
  t386 = s0 * t385
  t393 = t197 * t73
  t396 = tau0 ** 2
  t397 = t63 * t396
  t398 = t376 * r0
  t400 = 0.1e1 / t51 / t398
  t401 = t400 * t79
  t404 = t75 * t396
  t407 = t105 * t94
  t408 = t109 * t396
  t409 = t408 * t400
  t412 = t115 * t396
  t413 = t412 * t400
  t416 = t85 * t396
  t417 = t416 * t400
  t422 = t91 * t396
  t423 = t422 * t400
  t426 = t206 * t197
  t431 = t213 * t197
  t436 = t220 * t197
  t439 = -0.40e2 / 0.9e1 * t202 * t393 + 0.50e2 / 0.9e1 * t397 * t401 + 0.50e2 / 0.9e1 * t404 * t401 + 0.350e3 / 0.3e1 * t407 * t409 + 0.2450e4 / 0.9e1 * t246 * t413 + 0.50e2 / 0.9e1 * t71 * t417 + 0.200e3 / 0.9e1 * t210 * t417 + 0.50e2 / 0.3e1 * t77 * t423 - 0.40e2 / 0.9e1 * t71 * t426 - 0.80e2 / 0.9e1 * t210 * t426 - 0.80e2 / 0.9e1 * t77 * t431 - 0.40e2 / 0.3e1 * t217 * t431 - 0.40e2 / 0.3e1 * t83 * t436
  t442 = t227 * t197
  t447 = t234 * t197
  t452 = t242 * t197
  t457 = t249 * t197
  t462 = t256 * t197
  t467 = t263 * t197
  t472 = t270 * t197
  t475 = -0.160e3 / 0.9e1 * t224 * t436 - 0.160e3 / 0.9e1 * t89 * t442 - 0.200e3 / 0.9e1 * t231 * t442 - 0.200e3 / 0.9e1 * t95 * t447 - 0.80e2 / 0.3e1 * t238 * t447 - 0.80e2 / 0.3e1 * t101 * t452 - 0.280e3 / 0.9e1 * t246 * t452 - 0.280e3 / 0.9e1 * t107 * t457 - 0.320e3 / 0.9e1 * t253 * t457 - 0.320e3 / 0.9e1 * t113 * t462 - 0.40e2 * t260 * t462 - 0.40e2 * t119 * t467 - 0.400e3 / 0.9e1 * t267 * t467 - 0.400e3 / 0.9e1 * t125 * t472
  t479 = t279 * t197
  t482 = t121 * t396
  t483 = t482 * t400
  t486 = t111 * t100
  t491 = t127 * t396
  t492 = t491 * t400
  t495 = t117 * t106
  t500 = t133 * t396
  t501 = t500 * t400
  t504 = t123 * t112
  t509 = t278 * t396
  t510 = t509 * t400
  t513 = t129 * t118
  t516 = -0.440e3 / 0.9e1 * t274 * t472 - 0.440e3 / 0.9e1 * t131 * t479 + 0.1400e4 / 0.9e1 * t107 * t483 + 0.1400e4 / 0.9e1 * t486 * t413 + 0.3200e4 / 0.9e1 * t253 * t483 + 0.200e3 * t113 * t492 + 0.200e3 * t495 * t483 + 0.450e3 * t260 * t492 + 0.250e3 * t119 * t501 + 0.250e3 * t504 * t492 + 0.5000e4 / 0.9e1 * t267 * t501 + 0.2750e4 / 0.9e1 * t125 * t510 + 0.2750e4 / 0.9e1 * t513 * t501
  t520 = 0.1e1 / t114 / t96
  t521 = t520 * t396
  t522 = t521 * t400
  t525 = t81 * t70
  t530 = t97 * t396
  t531 = t530 * t400
  t534 = t87 * t76
  t539 = t103 * t396
  t540 = t539 * t400
  t543 = t93 * t82
  t550 = t99 * t88
  t557 = 0.6050e4 / 0.9e1 * t274 * t510 + 0.1100e4 / 0.3e1 * t131 * t522 + 0.50e2 / 0.3e1 * t525 * t417 + 0.50e2 * t217 * t423 + 0.100e3 / 0.3e1 * t83 * t531 + 0.100e3 / 0.3e1 * t534 * t423 + 0.800e3 / 0.9e1 * t224 * t531 + 0.500e3 / 0.9e1 * t89 * t540 + 0.500e3 / 0.9e1 * t543 * t531 + 0.1250e4 / 0.9e1 * t231 * t540 + 0.250e3 / 0.3e1 * t95 * t409 + 0.250e3 / 0.3e1 * t550 * t540 + 0.200e3 * t238 * t409 + 0.350e3 / 0.3e1 * t101 * t413
  t559 = t439 + t475 + t516 + t557
  t561 = t385 * t138
  t566 = t64 * t373 * t375
  t567 = t379 * t138
  t576 = t142 * t396
  t579 = t145 * t396
  t602 = -0.40e2 / 0.9e1 * t291 * t393 + 0.50e2 / 0.9e1 * t576 * t401 + 0.50e2 / 0.9e1 * t579 * t401 - 0.80e2 / 0.3e1 * t158 * t452 - 0.280e3 / 0.9e1 * t322 * t452 - 0.280e3 / 0.9e1 * t161 * t457 - 0.320e3 / 0.9e1 * t327 * t457 - 0.320e3 / 0.9e1 * t164 * t462 - 0.40e2 * t332 * t462 - 0.40e2 * t167 * t467 - 0.400e3 / 0.9e1 * t337 * t467 - 0.400e3 / 0.9e1 * t170 * t472 - 0.440e3 / 0.9e1 * t342 * t472
  t605 = t172 * t118
  t614 = t160 * t94
  t621 = t163 * t100
  t628 = t166 * t106
  t635 = -0.440e3 / 0.9e1 * t173 * t479 + 0.2750e4 / 0.9e1 * t605 * t501 + 0.6050e4 / 0.9e1 * t342 * t510 + 0.1100e4 / 0.3e1 * t173 * t522 + 0.350e3 / 0.3e1 * t158 * t413 + 0.350e3 / 0.3e1 * t614 * t409 + 0.2450e4 / 0.9e1 * t322 * t413 + 0.1400e4 / 0.9e1 * t161 * t483 + 0.1400e4 / 0.9e1 * t621 * t413 + 0.3200e4 / 0.9e1 * t327 * t483 + 0.200e3 * t164 * t492 + 0.200e3 * t628 * t483 + 0.450e3 * t332 * t492 + 0.250e3 * t167 * t501
  t637 = t169 * t112
  t650 = t148 * t70
  t657 = t151 * t76
  t664 = t154 * t82
  t667 = 0.250e3 * t637 * t492 + 0.5000e4 / 0.9e1 * t337 * t501 + 0.2750e4 / 0.9e1 * t170 * t510 + 0.50e2 / 0.9e1 * t143 * t417 + 0.200e3 / 0.9e1 * t296 * t417 + 0.50e2 / 0.3e1 * t146 * t423 + 0.50e2 / 0.3e1 * t650 * t417 + 0.50e2 * t301 * t423 + 0.100e3 / 0.3e1 * t149 * t531 + 0.100e3 / 0.3e1 * t657 * t423 + 0.800e3 / 0.9e1 * t306 * t531 + 0.500e3 / 0.9e1 * t152 * t540 + 0.500e3 / 0.9e1 * t664 * t531
  t672 = t157 * t88
  t697 = 0.1250e4 / 0.9e1 * t311 * t540 + 0.250e3 / 0.3e1 * t155 * t409 + 0.250e3 / 0.3e1 * t672 * t540 + 0.200e3 * t316 * t409 - 0.40e2 / 0.9e1 * t143 * t426 - 0.80e2 / 0.9e1 * t296 * t426 - 0.80e2 / 0.9e1 * t146 * t431 - 0.40e2 / 0.3e1 * t301 * t431 - 0.40e2 / 0.3e1 * t149 * t436 - 0.160e3 / 0.9e1 * t306 * t436 - 0.160e3 / 0.9e1 * t152 * t442 - 0.200e3 / 0.9e1 * t311 * t442 - 0.200e3 / 0.9e1 * t155 * t447 - 0.80e2 / 0.3e1 * t316 * t447
  t699 = t602 + t635 + t667 + t697
  t701 = -0.76906968678720000000000000000000000000000000000000e-3 * t374 * t380 * t135 + 0.57808982880000000000000000000000000000000000000000e-1 * t194 * t386 * t135 - 0.31532172480000000000000000000000000000000000000000e-1 * t194 * t198 * t284 + t61 * t559 + 0.50297210791037951531778692272519433013260173754001e-1 * t286 * t561 * t175 - 0.34088340999255810609977046547411469101414150735753e-3 * t566 * t567 * t175 - 0.27434842249657064471879286694101508916323731138546e-1 * t286 * t287 * t348 + t140 * t699
  t706 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t177 - t5 * t186 * t177 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t190 * t350 + t5 * t360 * t177 / 0.12e2 - t5 * t364 * t350 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t368 * t701)
  t708 = r1 <= f.p.dens_threshold
  t709 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t710 = 0.1e1 + t709
  t711 = t710 <= f.p.zeta_threshold
  t712 = t710 ** (0.1e1 / 0.3e1)
  t713 = t712 ** 2
  t714 = 0.1e1 / t713
  t716 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t717 = t716 ** 2
  t721 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t725 = f.my_piecewise3(t711, 0, 0.4e1 / 0.9e1 * t714 * t717 + 0.4e1 / 0.3e1 * t712 * t721)
  t727 = r1 ** 2
  t728 = r1 ** (0.1e1 / 0.3e1)
  t729 = t728 ** 2
  t733 = t49 * s2 / t729 / t727
  t741 = tau1 / t729 / r1
  t742 = t66 - t741
  t744 = t66 + t741
  t745 = 0.1e1 / t744
  t747 = t742 ** 2
  t749 = t744 ** 2
  t750 = 0.1e1 / t749
  t752 = t747 * t742
  t754 = t749 * t744
  t755 = 0.1e1 / t754
  t757 = t747 ** 2
  t759 = t749 ** 2
  t760 = 0.1e1 / t759
  t762 = t757 * t742
  t765 = 0.1e1 / t759 / t744
  t767 = t757 * t747
  t770 = 0.1e1 / t759 / t749
  t772 = t757 * t752
  t775 = 0.1e1 / t759 / t754
  t777 = t757 ** 2
  t779 = t759 ** 2
  t780 = 0.1e1 / t779
  t782 = t777 * t742
  t785 = 0.1e1 / t779 / t744
  t787 = t777 * t747
  t790 = 0.1e1 / t779 / t749
  t792 = t777 * t752
  t795 = 0.1e1 / t779 / t754
  t797 = t62 + t63 * t742 * t745 + t75 * t747 * t750 + t81 * t752 * t755 + t87 * t757 * t760 + t93 * t762 * t765 + t99 * t767 * t770 + t105 * t772 * t775 + t111 * t777 * t780 + t117 * t782 * t785 + t123 * t787 * t790 + t129 * t792 * t795
  t800 = jnp.exp(-0.93189002206715572255024750998986103655990934573866e-2 * t733)
  t825 = t141 + t142 * t742 * t745 + t145 * t747 * t750 + t148 * t752 * t755 + t151 * t757 * t760 + t154 * t762 * t765 + t157 * t767 * t770 + t160 * t772 * t775 + t163 * t777 * t780 + t166 * t782 * t785 + t169 * t787 * t790 + t172 * t792 * t795
  t827 = (0.18040e1 - 0.64641600e0 / (0.8040e0 + 0.91462500000000000000000000000000000000000000000000e-2 * t733)) * t797 + (0.1552e1 - 0.552e0 * t800) * t825
  t833 = f.my_piecewise3(t711, 0, 0.4e1 / 0.3e1 * t712 * t716)
  t839 = f.my_piecewise3(t711, t355, t712 * t710)
  t845 = f.my_piecewise3(t708, 0, -0.3e1 / 0.8e1 * t5 * t725 * t42 * t827 - t5 * t833 * t185 * t827 / 0.4e1 + t5 * t839 * t359 * t827 / 0.12e2)
  t855 = t24 ** 2
  t859 = 0.6e1 * t33 - 0.6e1 * t16 / t855
  t860 = f.my_piecewise5(t10, 0, t14, 0, t859)
  t864 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t860)
  t887 = 0.1e1 / t184 / t24
  t898 = t191 ** 2
  t900 = t45 ** 2
  t901 = 0.1e1 / t900
  t903 = t375 * s0
  t904 = t376 ** 2
  t906 = 0.1e1 / t904 / t195
  t912 = 0.1e1 / t51 / t904
  t921 = 0.1e1 / t52 / t398
  t932 = t385 * t73
  t935 = t396 * tau0
  t937 = 0.1e1 / t904
  t938 = t937 * t85
  t949 = 0.1e1 / t51 / t376 / t50
  t950 = t949 * t79
  t955 = t270 * t385
  t958 = t242 * t385
  t963 = t249 * t385
  t968 = 0.440e3 / 0.27e2 * t202 * t932 + 0.250e3 / 0.9e1 * t81 * t935 * t938 + 0.250e3 / 0.9e1 * t63 * t935 * t938 + 0.500e3 / 0.9e1 * t75 * t935 * t938 - 0.400e3 / 0.9e1 * t397 * t950 - 0.400e3 / 0.9e1 * t404 * t950 + 0.4840e4 / 0.27e2 * t274 * t955 + 0.880e3 / 0.9e1 * t101 * t958 + 0.3080e4 / 0.27e2 * t246 * t958 + 0.3080e4 / 0.27e2 * t107 * t963 + 0.3520e4 / 0.27e2 * t253 * t963
  t969 = t256 * t385
  t974 = t408 * t949
  t977 = t412 * t949
  t984 = t416 * t949
  t989 = t422 * t949
  t992 = t206 * t385
  t997 = t213 * t385
  t1000 = 0.3520e4 / 0.27e2 * t113 * t969 + 0.440e3 / 0.3e1 * t260 * t969 - 0.1600e4 * t238 * t974 - 0.2800e4 / 0.3e1 * t101 * t977 - 0.2800e4 / 0.3e1 * t407 * t974 - 0.19600e5 / 0.9e1 * t246 * t977 - 0.400e3 / 0.9e1 * t71 * t984 - 0.1600e4 / 0.9e1 * t210 * t984 - 0.400e3 / 0.3e1 * t77 * t989 + 0.440e3 / 0.27e2 * t71 * t992 + 0.880e3 / 0.27e2 * t210 * t992 + 0.880e3 / 0.27e2 * t77 * t997
  t1006 = t530 * t949
  t1013 = t539 * t949
  t1024 = t491 * t949
  t1027 = t482 * t949
  t1030 = -0.400e3 / 0.3e1 * t525 * t984 - 0.400e3 * t217 * t989 - 0.800e3 / 0.3e1 * t83 * t1006 - 0.800e3 / 0.3e1 * t534 * t989 - 0.6400e4 / 0.9e1 * t224 * t1006 - 0.4000e4 / 0.9e1 * t89 * t1013 - 0.4000e4 / 0.9e1 * t543 * t1006 - 0.10000e5 / 0.9e1 * t231 * t1013 - 0.2000e4 / 0.3e1 * t95 * t974 - 0.2000e4 / 0.3e1 * t550 * t1013 - 0.1600e4 * t113 * t1024 - 0.1600e4 * t495 * t1027
  t1033 = t500 * t949
  t1039 = t278 * t935 * t937
  t1043 = t520 * t935 * t937
  t1049 = 0.1e1 / t114 / t102 * t935 * t937
  t1053 = t121 * t935 * t937
  t1057 = t127 * t935 * t937
  t1062 = t115 * t935 * t937
  t1067 = t263 * t385
  t1072 = -0.3600e4 * t260 * t1024 - 0.2000e4 * t119 * t1033 - 0.2000e4 * t504 * t1024 + 0.151250e6 / 0.9e1 * t513 * t1039 + 0.60500e5 / 0.3e1 * t274 * t1043 + 0.71500e5 / 0.9e1 * t131 * t1049 + 0.49000e5 / 0.9e1 * t246 * t1053 + 0.7000e4 / 0.3e1 * t107 * t1057 + 0.14000e5 / 0.9e1 * t111 * t94 * t1062 + 0.56000e5 / 0.9e1 * t486 * t1053 + 0.440e3 / 0.3e1 * t119 * t1067 + 0.4400e4 / 0.27e2 * t267 * t1067
  t1077 = t509 * t949
  t1080 = t521 * t949
  t1090 = t97 * t935 * t937
  t1094 = t91 * t935 * t937
  t1100 = t103 * t935 * t937
  t1108 = 0.4400e4 / 0.27e2 * t125 * t955 - 0.48400e5 / 0.9e1 * t274 * t1077 - 0.8800e4 / 0.3e1 * t131 * t1080 - 0.11200e5 / 0.9e1 * t107 * t1027 - 0.11200e5 / 0.9e1 * t486 * t977 - 0.25600e5 / 0.9e1 * t253 * t1027 + 0.1000e4 / 0.9e1 * t77 * t1090 + 0.250e3 * t525 * t1094 + 0.500e3 * t217 * t1090 + 0.2500e4 / 0.9e1 * t83 * t1100 + 0.1000e4 / 0.9e1 * t87 * t70 * t1094 + 0.2000e4 / 0.3e1 * t534 * t1090
  t1112 = t109 * t935 * t937
  t1136 = t133 * t935 * t937
  t1139 = 0.10000e5 / 0.9e1 * t224 * t1100 + 0.5000e4 / 0.9e1 * t89 * t1112 + 0.2500e4 / 0.9e1 * t93 * t76 * t1090 + 0.12500e5 / 0.9e1 * t543 * t1100 + 0.6250e4 / 0.3e1 * t231 * t1112 + 0.8750e4 / 0.9e1 * t95 * t1062 + 0.5000e4 / 0.9e1 * t99 * t82 * t1100 + 0.2500e4 * t550 * t1112 + 0.3500e4 * t238 * t1062 + 0.14000e5 / 0.9e1 * t101 * t1053 + 0.8000e4 * t253 * t1057 + 0.10000e5 / 0.3e1 * t113 * t1136
  t1162 = t279 * t385
  t1167 = t220 * t385
  t1170 = 0.7000e4 / 0.3e1 * t117 * t100 * t1053 + 0.9000e4 * t495 * t1057 + 0.11250e5 * t260 * t1136 + 0.13750e5 / 0.3e1 * t119 * t1039 + 0.10000e5 / 0.3e1 * t123 * t106 * t1057 + 0.12500e5 * t504 * t1136 + 0.137500e6 / 0.9e1 * t267 * t1039 + 0.55000e5 / 0.9e1 * t125 * t1043 + 0.13750e5 / 0.3e1 * t129 * t112 * t1136 + 0.4840e4 / 0.27e2 * t131 * t1162 + 0.440e3 / 0.9e1 * t217 * t997 + 0.440e3 / 0.9e1 * t83 * t1167
  t1173 = t227 * t385
  t1178 = t234 * t385
  t1198 = 0.1760e4 / 0.27e2 * t224 * t1167 + 0.1760e4 / 0.27e2 * t89 * t1173 + 0.2200e4 / 0.27e2 * t231 * t1173 + 0.2200e4 / 0.27e2 * t95 * t1178 + 0.880e3 / 0.9e1 * t238 * t1178 + 0.8750e4 / 0.9e1 * t105 * t88 * t1112 + 0.12250e5 / 0.3e1 * t407 * t1062 + 0.250e3 / 0.9e1 * t71 * t1094 + 0.500e3 / 0.3e1 * t210 * t1094 - 0.40000e5 / 0.9e1 * t267 * t1033 - 0.22000e5 / 0.9e1 * t125 * t1077 - 0.22000e5 / 0.9e1 * t513 * t1033
  t1247 = -0.4000e4 / 0.9e1 * t664 * t1006 - 0.10000e5 / 0.9e1 * t311 * t1013 - 0.2000e4 / 0.3e1 * t155 * t974 - 0.2000e4 / 0.3e1 * t672 * t1013 - 0.2800e4 / 0.3e1 * t158 * t977 - 0.2800e4 / 0.3e1 * t614 * t974 - 0.19600e5 / 0.9e1 * t322 * t977 - 0.11200e5 / 0.9e1 * t161 * t1027 - 0.11200e5 / 0.9e1 * t621 * t977 - 0.25600e5 / 0.9e1 * t327 * t1027 - 0.1600e4 * t164 * t1024
  t1275 = -0.1600e4 * t628 * t1027 + 0.2500e4 * t672 * t1112 + 0.3500e4 * t316 * t1062 - 0.400e3 / 0.9e1 * t143 * t984 - 0.1600e4 / 0.9e1 * t296 * t984 + 0.440e3 / 0.27e2 * t291 * t932 - 0.400e3 / 0.9e1 * t576 * t950 - 0.400e3 / 0.9e1 * t579 * t950 + 0.250e3 / 0.9e1 * t142 * t935 * t938 + 0.500e3 / 0.9e1 * t145 * t935 * t938 + 0.250e3 / 0.9e1 * t148 * t935 * t938 + 0.56000e5 / 0.9e1 * t621 * t1053
  t1302 = 0.8000e4 * t327 * t1057 + 0.10000e5 / 0.3e1 * t164 * t1136 + 0.7000e4 / 0.3e1 * t166 * t100 * t1053 + 0.9000e4 * t628 * t1057 - 0.3600e4 * t332 * t1024 - 0.2000e4 * t167 * t1033 - 0.2000e4 * t637 * t1024 - 0.40000e5 / 0.9e1 * t337 * t1033 - 0.22000e5 / 0.9e1 * t170 * t1077 - 0.22000e5 / 0.9e1 * t605 * t1033 - 0.48400e5 / 0.9e1 * t342 * t1077 - 0.8800e4 / 0.3e1 * t173 * t1080
  t1329 = 0.13750e5 / 0.3e1 * t172 * t112 * t1136 + 0.151250e6 / 0.9e1 * t605 * t1039 + 0.60500e5 / 0.3e1 * t342 * t1043 + 0.71500e5 / 0.9e1 * t173 * t1049 + 0.14000e5 / 0.9e1 * t158 * t1053 + 0.8750e4 / 0.9e1 * t160 * t88 * t1112 + 0.12250e5 / 0.3e1 * t614 * t1062 - 0.4000e4 / 0.9e1 * t152 * t1013 + 0.250e3 / 0.9e1 * t143 * t1094 + 0.500e3 / 0.3e1 * t296 * t1094 + 0.1000e4 / 0.9e1 * t146 * t1090 + 0.250e3 * t650 * t1094
  t1358 = 0.500e3 * t301 * t1090 + 0.2500e4 / 0.9e1 * t149 * t1100 + 0.1000e4 / 0.9e1 * t151 * t70 * t1094 + 0.2000e4 / 0.3e1 * t657 * t1090 + 0.10000e5 / 0.9e1 * t306 * t1100 + 0.5000e4 / 0.9e1 * t152 * t1112 + 0.2500e4 / 0.9e1 * t154 * t76 * t1090 + 0.12500e5 / 0.9e1 * t664 * t1100 + 0.6250e4 / 0.3e1 * t311 * t1112 + 0.8750e4 / 0.9e1 * t155 * t1062 + 0.49000e5 / 0.9e1 * t322 * t1053 + 0.7000e4 / 0.3e1 * t161 * t1057
  t1386 = 0.14000e5 / 0.9e1 * t163 * t94 * t1062 + 0.880e3 / 0.27e2 * t296 * t992 + 0.880e3 / 0.27e2 * t146 * t997 + 0.440e3 / 0.9e1 * t301 * t997 + 0.5000e4 / 0.9e1 * t157 * t82 * t1100 + 0.11250e5 * t332 * t1136 + 0.13750e5 / 0.3e1 * t167 * t1039 + 0.10000e5 / 0.3e1 * t169 * t106 * t1057 + 0.12500e5 * t637 * t1136 + 0.137500e6 / 0.9e1 * t337 * t1039 + 0.55000e5 / 0.9e1 * t170 * t1043 + 0.4400e4 / 0.27e2 * t337 * t1067
  t1412 = 0.4400e4 / 0.27e2 * t170 * t955 + 0.4840e4 / 0.27e2 * t342 * t955 + 0.4840e4 / 0.27e2 * t173 * t1162 + 0.440e3 / 0.9e1 * t149 * t1167 - 0.400e3 / 0.3e1 * t146 * t989 - 0.400e3 / 0.3e1 * t650 * t984 - 0.400e3 * t301 * t989 - 0.800e3 / 0.3e1 * t149 * t1006 - 0.800e3 / 0.3e1 * t657 * t989 - 0.6400e4 / 0.9e1 * t306 * t1006 + 0.1760e4 / 0.27e2 * t306 * t1167 + 0.1760e4 / 0.27e2 * t152 * t1173
  t1437 = 0.2200e4 / 0.27e2 * t311 * t1173 + 0.2200e4 / 0.27e2 * t155 * t1178 + 0.880e3 / 0.9e1 * t316 * t1178 + 0.880e3 / 0.9e1 * t158 * t958 + 0.3080e4 / 0.27e2 * t322 * t958 + 0.3080e4 / 0.27e2 * t161 * t963 + 0.3520e4 / 0.27e2 * t327 * t963 + 0.3520e4 / 0.27e2 * t164 * t969 + 0.440e3 / 0.3e1 * t332 * t969 + 0.440e3 / 0.3e1 * t167 * t1067 - 0.1600e4 * t316 * t974 + 0.440e3 / 0.27e2 * t143 * t992
  t1442 = -0.33763697389331654400000000000000000000000000000000e-3 / t898 * t901 * t903 * t906 * t135 + 0.84597665546592000000000000000000000000000000000000e-2 * t374 * t375 * t912 * t135 - 0.23072090603616000000000000000000000000000000000000e-2 * t374 * t380 * t284 - 0.26977525344000000000000000000000000000000000000000e0 * t194 * s0 * t921 * t135 + 0.17342694864000000000000000000000000000000000000000e0 * t194 * t386 * t284 - 0.47298258720000000000000000000000000000000000000000e-1 * t194 * t198 * t559 + t61 * (t968 + t1000 + t1030 + t1072 + t1108 + t1139 + t1170 + t1198) - 0.23472031702484377381496723060509068739521414418534e0 * t286 * t921 * t138 * t175 + 0.37497175099181391670974751202152616011555565809329e-2 * t566 * t912 * t138 * t175 + 0.15089163237311385459533607681755829903978052126200e0 * t286 * t561 * t348 - 0.50826535753646762405285749608474189034135729014958e-4 * t901 * t903 * t906 * t138 * t175 - 0.10226502299776743182993113964223440730424245220726e-2 * t566 * t567 * t348 - 0.41152263374485596707818930041152263374485596707819e-1 * t286 * t287 * t699 + t140 * (t1247 + t1275 + t1302 + t1329 + t1358 + t1386 + t1412 + t1437)
  t1447 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t864 * t42 * t177 - 0.3e1 / 0.8e1 * t5 * t41 * t185 * t177 - 0.9e1 / 0.8e1 * t5 * t43 * t350 + t5 * t183 * t359 * t177 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t186 * t350 - 0.9e1 / 0.8e1 * t5 * t190 * t701 - 0.5e1 / 0.36e2 * t5 * t357 * t887 * t177 + t5 * t360 * t350 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t364 * t701 - 0.3e1 / 0.8e1 * t5 * t368 * t1442)
  t1457 = f.my_piecewise5(t14, 0, t10, 0, -t859)
  t1461 = f.my_piecewise3(t711, 0, -0.8e1 / 0.27e2 / t713 / t710 * t717 * t716 + 0.4e1 / 0.3e1 * t714 * t716 * t721 + 0.4e1 / 0.3e1 * t712 * t1457)
  t1479 = f.my_piecewise3(t708, 0, -0.3e1 / 0.8e1 * t5 * t1461 * t42 * t827 - 0.3e1 / 0.8e1 * t5 * t725 * t185 * t827 + t5 * t833 * t359 * t827 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t839 * t887 * t827)
  d111 = 0.3e1 * t706 + 0.3e1 * t845 + t6 * (t1447 + t1479)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 0.1e1 / t22 / t19
  t25 = t6 ** 2
  t26 = 0.1e1 / t25
  t28 = -t16 * t26 + t7
  t29 = f.my_piecewise5(t10, 0, t14, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t6
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t16 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t10, 0, t14, 0, t40)
  t44 = t25 ** 2
  t45 = 0.1e1 / t44
  t48 = -0.6e1 * t16 * t45 + 0.6e1 * t37
  t49 = f.my_piecewise5(t10, 0, t14, 0, t48)
  t53 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t24 * t30 * t29 + 0.4e1 / 0.3e1 * t35 * t41 + 0.4e1 / 0.3e1 * t21 * t49)
  t54 = t6 ** (0.1e1 / 0.3e1)
  t55 = t53 * t54
  t56 = 6 ** (0.1e1 / 0.3e1)
  t57 = jnp.pi ** 2
  t58 = t57 ** (0.1e1 / 0.3e1)
  t59 = t58 ** 2
  t60 = 0.1e1 / t59
  t61 = t56 * t60
  t62 = r0 ** 2
  t63 = r0 ** (0.1e1 / 0.3e1)
  t64 = t63 ** 2
  t66 = 0.1e1 / t64 / t62
  t68 = t61 * s0 * t66
  t70 = 0.8040e0 + 0.91462500000000000000000000000000000000000000000000e-2 * t68
  t73 = 0.18040e1 - 0.64641600e0 / t70
  t74 = params.a[0]
  t75 = params.a[1]
  t76 = t56 ** 2
  t78 = 0.3e1 / 0.10e2 * t76 * t59
  t81 = tau0 / t64 / r0
  t82 = t78 - t81
  t83 = t75 * t82
  t84 = t78 + t81
  t85 = 0.1e1 / t84
  t87 = params.a[2]
  t88 = t82 ** 2
  t89 = t87 * t88
  t90 = t84 ** 2
  t91 = 0.1e1 / t90
  t93 = params.a[3]
  t94 = t88 * t82
  t95 = t93 * t94
  t96 = t90 * t84
  t97 = 0.1e1 / t96
  t99 = params.a[4]
  t100 = t88 ** 2
  t101 = t99 * t100
  t102 = t90 ** 2
  t103 = 0.1e1 / t102
  t105 = params.a[5]
  t106 = t100 * t82
  t107 = t105 * t106
  t108 = t102 * t84
  t109 = 0.1e1 / t108
  t111 = params.a[6]
  t112 = t100 * t88
  t113 = t111 * t112
  t114 = t102 * t90
  t115 = 0.1e1 / t114
  t117 = params.a[7]
  t118 = t100 * t94
  t119 = t117 * t118
  t120 = t102 * t96
  t121 = 0.1e1 / t120
  t123 = params.a[8]
  t124 = t100 ** 2
  t125 = t123 * t124
  t126 = t102 ** 2
  t127 = 0.1e1 / t126
  t129 = params.a[9]
  t130 = t124 * t82
  t131 = t129 * t130
  t133 = 0.1e1 / t126 / t84
  t135 = params.a[10]
  t136 = t124 * t88
  t137 = t135 * t136
  t139 = 0.1e1 / t126 / t90
  t141 = params.a[11]
  t142 = t124 * t94
  t143 = t141 * t142
  t145 = 0.1e1 / t126 / t96
  t147 = t101 * t103 + t107 * t109 + t113 * t115 + t119 * t121 + t125 * t127 + t131 * t133 + t137 * t139 + t143 * t145 + t83 * t85 + t89 * t91 + t95 * t97 + t74
  t150 = jnp.exp(-0.93189002206715572255024750998986103655990934573866e-2 * t68)
  t152 = 0.1552e1 - 0.552e0 * t150
  t153 = params.b[0]
  t154 = params.b[1]
  t155 = t154 * t82
  t157 = params.b[2]
  t158 = t157 * t88
  t160 = params.b[3]
  t161 = t160 * t94
  t163 = params.b[4]
  t164 = t163 * t100
  t166 = params.b[5]
  t167 = t166 * t106
  t169 = params.b[6]
  t170 = t169 * t112
  t172 = params.b[7]
  t173 = t172 * t118
  t175 = params.b[8]
  t176 = t175 * t124
  t178 = params.b[9]
  t179 = t178 * t130
  t181 = params.b[10]
  t182 = t181 * t136
  t184 = params.b[11]
  t185 = t184 * t142
  t187 = t164 * t103 + t167 * t109 + t170 * t115 + t173 * t121 + t176 * t127 + t179 * t133 + t182 * t139 + t185 * t145 + t155 * t85 + t158 * t91 + t161 * t97 + t153
  t189 = t73 * t147 + t152 * t187
  t198 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t34 * t30 + 0.4e1 / 0.3e1 * t21 * t41)
  t199 = t54 ** 2
  t200 = 0.1e1 / t199
  t201 = t198 * t200
  t205 = t198 * t54
  t206 = t70 ** 2
  t209 = 0.1e1 / t206 * t56 * t60
  t210 = t62 * r0
  t212 = 0.1e1 / t64 / t210
  t213 = s0 * t212
  t217 = t75 * tau0
  t218 = t66 * t85
  t221 = t91 * tau0
  t222 = t221 * t66
  t225 = t87 * t82
  t228 = t97 * tau0
  t229 = t228 * t66
  t232 = t93 * t88
  t235 = t103 * tau0
  t236 = t235 * t66
  t239 = t99 * t94
  t242 = t109 * tau0
  t243 = t242 * t66
  t246 = t105 * t100
  t249 = t115 * tau0
  t250 = t249 * t66
  t253 = t111 * t106
  t256 = 0.5e1 / 0.3e1 * t217 * t218 + 0.5e1 / 0.3e1 * t83 * t222 + 0.10e2 / 0.3e1 * t225 * t222 + 0.10e2 / 0.3e1 * t89 * t229 + 0.5e1 * t232 * t229 + 0.5e1 * t95 * t236 + 0.20e2 / 0.3e1 * t239 * t236 + 0.20e2 / 0.3e1 * t101 * t243 + 0.25e2 / 0.3e1 * t246 * t243 + 0.25e2 / 0.3e1 * t107 * t250 + 0.10e2 * t253 * t250
  t257 = t121 * tau0
  t258 = t257 * t66
  t261 = t117 * t112
  t264 = t127 * tau0
  t265 = t264 * t66
  t268 = t123 * t118
  t271 = t133 * tau0
  t272 = t271 * t66
  t275 = t129 * t124
  t278 = t139 * tau0
  t279 = t278 * t66
  t282 = t135 * t130
  t285 = t145 * tau0
  t286 = t285 * t66
  t289 = t141 * t136
  t293 = 0.1e1 / t126 / t102
  t294 = t293 * tau0
  t295 = t294 * t66
  t298 = 0.10e2 * t113 * t258 + 0.35e2 / 0.3e1 * t261 * t258 + 0.35e2 / 0.3e1 * t119 * t265 + 0.40e2 / 0.3e1 * t268 * t265 + 0.40e2 / 0.3e1 * t125 * t272 + 0.15e2 * t275 * t272 + 0.15e2 * t131 * t279 + 0.50e2 / 0.3e1 * t282 * t279 + 0.50e2 / 0.3e1 * t137 * t286 + 0.55e2 / 0.3e1 * t289 * t286 + 0.55e2 / 0.3e1 * t143 * t295
  t299 = t256 + t298
  t301 = t61 * s0
  t302 = t212 * t150
  t306 = t154 * tau0
  t311 = t157 * t82
  t316 = t160 * t88
  t321 = t163 * t94
  t326 = t166 * t100
  t331 = t169 * t106
  t334 = 0.5e1 / 0.3e1 * t306 * t218 + 0.5e1 / 0.3e1 * t155 * t222 + 0.10e2 / 0.3e1 * t311 * t222 + 0.10e2 / 0.3e1 * t158 * t229 + 0.5e1 * t316 * t229 + 0.5e1 * t161 * t236 + 0.20e2 / 0.3e1 * t321 * t236 + 0.20e2 / 0.3e1 * t164 * t243 + 0.25e2 / 0.3e1 * t326 * t243 + 0.25e2 / 0.3e1 * t167 * t250 + 0.10e2 * t331 * t250
  t337 = t172 * t112
  t342 = t175 * t118
  t347 = t178 * t124
  t352 = t181 * t130
  t357 = t184 * t136
  t362 = 0.10e2 * t170 * t258 + 0.35e2 / 0.3e1 * t337 * t258 + 0.35e2 / 0.3e1 * t173 * t265 + 0.40e2 / 0.3e1 * t342 * t265 + 0.40e2 / 0.3e1 * t176 * t272 + 0.15e2 * t347 * t272 + 0.15e2 * t179 * t279 + 0.50e2 / 0.3e1 * t352 * t279 + 0.50e2 / 0.3e1 * t182 * t286 + 0.55e2 / 0.3e1 * t357 * t286 + 0.55e2 / 0.3e1 * t185 * t295
  t363 = t334 + t362
  t365 = -0.15766086240000000000000000000000000000000000000000e-1 * t209 * t213 * t147 + t73 * t299 - 0.13717421124828532235939643347050754458161865569273e-1 * t301 * t302 * t187 + t152 * t363
  t371 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t29)
  t373 = 0.1e1 / t199 / t6
  t374 = t371 * t373
  t378 = t371 * t200
  t382 = t371 * t54
  t387 = 0.1e1 / t58 / t57
  t388 = 0.1e1 / t206 / t70 * t76 * t387
  t389 = s0 ** 2
  t390 = t62 ** 2
  t393 = 0.1e1 / t63 / t390 / t210
  t394 = t389 * t393
  t399 = 0.1e1 / t64 / t390
  t400 = s0 * t399
  t407 = t123 * t112
  t408 = tau0 ** 2
  t409 = t127 * t408
  t410 = t390 * r0
  t412 = 0.1e1 / t63 / t410
  t413 = t409 * t412
  t416 = t133 * t408
  t417 = t416 * t412
  t420 = t139 * t408
  t421 = t420 * t412
  t424 = t129 * t118
  t429 = t145 * t408
  t430 = t429 * t412
  t433 = t135 * t124
  t438 = t293 * t408
  t439 = t438 * t412
  t442 = t141 * t130
  t448 = 0.1e1 / t126 / t108
  t449 = t448 * t408
  t450 = t449 * t412
  t453 = t93 * t82
  t454 = t97 * t408
  t455 = t454 * t412
  t458 = 0.1400e4 / 0.9e1 * t407 * t413 + 0.3200e4 / 0.9e1 * t268 * t417 + 0.200e3 * t125 * t421 + 0.200e3 * t424 * t417 + 0.450e3 * t275 * t421 + 0.250e3 * t131 * t430 + 0.250e3 * t433 * t421 + 0.5000e4 / 0.9e1 * t282 * t430 + 0.2750e4 / 0.9e1 * t137 * t439 + 0.2750e4 / 0.9e1 * t442 * t430 + 0.6050e4 / 0.9e1 * t289 * t439 + 0.1100e4 / 0.3e1 * t143 * t450 + 0.50e2 / 0.3e1 * t453 * t455
  t459 = t103 * t408
  t460 = t459 * t412
  t463 = t109 * t408
  t464 = t463 * t412
  t467 = t99 * t88
  t472 = t115 * t408
  t473 = t472 * t412
  t476 = t105 * t94
  t481 = t121 * t408
  t482 = t481 * t412
  t485 = t111 * t100
  t492 = t117 * t106
  t499 = 0.50e2 * t232 * t460 + 0.100e3 / 0.3e1 * t95 * t464 + 0.100e3 / 0.3e1 * t467 * t460 + 0.800e3 / 0.9e1 * t239 * t464 + 0.500e3 / 0.9e1 * t101 * t473 + 0.500e3 / 0.9e1 * t476 * t464 + 0.1250e4 / 0.9e1 * t246 * t473 + 0.250e3 / 0.3e1 * t107 * t482 + 0.250e3 / 0.3e1 * t485 * t473 + 0.200e3 * t253 * t482 + 0.350e3 / 0.3e1 * t113 * t413 + 0.350e3 / 0.3e1 * t492 * t482 + 0.2450e4 / 0.9e1 * t261 * t413 + 0.50e2 / 0.9e1 * t83 * t455
  t505 = t221 * t212
  t510 = t228 * t212
  t515 = t235 * t212
  t520 = t242 * t212
  t525 = t249 * t212
  t530 = t257 * t212
  t533 = 0.200e3 / 0.9e1 * t225 * t455 + 0.50e2 / 0.3e1 * t89 * t460 - 0.40e2 / 0.9e1 * t83 * t505 - 0.80e2 / 0.9e1 * t225 * t505 - 0.80e2 / 0.9e1 * t89 * t510 - 0.40e2 / 0.3e1 * t232 * t510 - 0.40e2 / 0.3e1 * t95 * t515 - 0.160e3 / 0.9e1 * t239 * t515 - 0.160e3 / 0.9e1 * t101 * t520 - 0.200e3 / 0.9e1 * t246 * t520 - 0.200e3 / 0.9e1 * t107 * t525 - 0.80e2 / 0.3e1 * t253 * t525 - 0.80e2 / 0.3e1 * t113 * t530
  t536 = t264 * t212
  t541 = t271 * t212
  t546 = t278 * t212
  t551 = t285 * t212
  t556 = t294 * t212
  t561 = t212 * t85
  t564 = t75 * t408
  t565 = t412 * t91
  t568 = t87 * t408
  t571 = -0.280e3 / 0.9e1 * t261 * t530 - 0.280e3 / 0.9e1 * t119 * t536 - 0.320e3 / 0.9e1 * t268 * t536 - 0.320e3 / 0.9e1 * t125 * t541 - 0.40e2 * t275 * t541 - 0.40e2 * t131 * t546 - 0.400e3 / 0.9e1 * t282 * t546 - 0.400e3 / 0.9e1 * t137 * t551 - 0.440e3 / 0.9e1 * t289 * t551 - 0.440e3 / 0.9e1 * t143 * t556 + 0.1400e4 / 0.9e1 * t119 * t417 - 0.40e2 / 0.9e1 * t217 * t561 + 0.50e2 / 0.9e1 * t564 * t565 + 0.50e2 / 0.9e1 * t568 * t565
  t573 = t458 + t499 + t533 + t571
  t575 = t399 * t150
  t580 = t76 * t387 * t389
  t581 = t393 * t150
  t590 = t172 * t106
  t597 = t175 * t112
  t604 = t178 * t118
  t611 = t181 * t124
  t618 = 0.350e3 / 0.3e1 * t170 * t413 + 0.350e3 / 0.3e1 * t590 * t482 + 0.2450e4 / 0.9e1 * t337 * t413 + 0.1400e4 / 0.9e1 * t173 * t417 + 0.1400e4 / 0.9e1 * t597 * t413 + 0.3200e4 / 0.9e1 * t342 * t417 + 0.200e3 * t176 * t421 + 0.200e3 * t604 * t417 + 0.450e3 * t347 * t421 + 0.250e3 * t179 * t430 + 0.250e3 * t611 * t421 + 0.5000e4 / 0.9e1 * t352 * t430 + 0.2750e4 / 0.9e1 * t182 * t439
  t625 = t160 * t82
  t632 = t163 * t88
  t639 = t166 * t94
  t646 = t169 * t100
  t651 = 0.50e2 / 0.9e1 * t155 * t455 + 0.200e3 / 0.9e1 * t311 * t455 + 0.50e2 / 0.3e1 * t158 * t460 + 0.50e2 / 0.3e1 * t625 * t455 + 0.50e2 * t316 * t460 + 0.100e3 / 0.3e1 * t161 * t464 + 0.100e3 / 0.3e1 * t632 * t460 + 0.800e3 / 0.9e1 * t321 * t464 + 0.500e3 / 0.9e1 * t164 * t473 + 0.500e3 / 0.9e1 * t639 * t464 + 0.1250e4 / 0.9e1 * t326 * t473 + 0.250e3 / 0.3e1 * t167 * t482 + 0.250e3 / 0.3e1 * t646 * t473 + 0.200e3 * t331 * t482
  t679 = -0.40e2 / 0.9e1 * t155 * t505 - 0.80e2 / 0.9e1 * t311 * t505 - 0.80e2 / 0.9e1 * t158 * t510 - 0.40e2 / 0.3e1 * t316 * t510 - 0.40e2 / 0.3e1 * t161 * t515 - 0.160e3 / 0.9e1 * t321 * t515 - 0.160e3 / 0.9e1 * t164 * t520 - 0.200e3 / 0.9e1 * t326 * t520 - 0.200e3 / 0.9e1 * t167 * t525 - 0.80e2 / 0.3e1 * t331 * t525 - 0.80e2 / 0.3e1 * t170 * t530 - 0.280e3 / 0.9e1 * t337 * t530 - 0.280e3 / 0.9e1 * t173 * t536
  t696 = t184 * t130
  t705 = t154 * t408
  t708 = t157 * t408
  t711 = -0.320e3 / 0.9e1 * t342 * t536 - 0.320e3 / 0.9e1 * t176 * t541 - 0.40e2 * t347 * t541 - 0.40e2 * t179 * t546 - 0.400e3 / 0.9e1 * t352 * t546 - 0.400e3 / 0.9e1 * t182 * t551 - 0.440e3 / 0.9e1 * t357 * t551 - 0.440e3 / 0.9e1 * t185 * t556 + 0.2750e4 / 0.9e1 * t696 * t430 + 0.6050e4 / 0.9e1 * t357 * t439 + 0.1100e4 / 0.3e1 * t185 * t450 - 0.40e2 / 0.9e1 * t306 * t561 + 0.50e2 / 0.9e1 * t705 * t565 + 0.50e2 / 0.9e1 * t708 * t565
  t713 = t618 + t651 + t679 + t711
  t715 = -0.76906968678720000000000000000000000000000000000000e-3 * t388 * t394 * t147 + 0.57808982880000000000000000000000000000000000000000e-1 * t209 * t400 * t147 - 0.31532172480000000000000000000000000000000000000000e-1 * t209 * t213 * t299 + t73 * t573 + 0.50297210791037951531778692272519433013260173754001e-1 * t301 * t575 * t187 - 0.34088340999255810609977046547411469101414150735753e-3 * t580 * t581 * t187 - 0.27434842249657064471879286694101508916323731138546e-1 * t301 * t302 * t363 + t152 * t713
  t719 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t720 = t719 * f.p.zeta_threshold
  t722 = f.my_piecewise3(t20, t720, t21 * t19)
  t724 = 0.1e1 / t199 / t25
  t725 = t722 * t724
  t729 = t722 * t373
  t733 = t722 * t200
  t737 = t722 * t54
  t738 = t206 ** 2
  t740 = t57 ** 2
  t741 = 0.1e1 / t740
  t742 = 0.1e1 / t738 * t741
  t743 = t389 * s0
  t744 = t390 ** 2
  t746 = 0.1e1 / t744 / t210
  t747 = t743 * t746
  t752 = 0.1e1 / t63 / t744
  t753 = t389 * t752
  t761 = 0.1e1 / t64 / t410
  t762 = s0 * t761
  t772 = t264 * t399
  t775 = t271 * t399
  t780 = t390 * t62
  t782 = 0.1e1 / t63 / t780
  t783 = t472 * t782
  t786 = t481 * t782
  t789 = t409 * t782
  t796 = t454 * t782
  t801 = t459 * t782
  t804 = 0.3520e4 / 0.27e2 * t268 * t772 + 0.3520e4 / 0.27e2 * t125 * t775 + 0.440e3 / 0.3e1 * t275 * t775 - 0.2000e4 / 0.3e1 * t485 * t783 - 0.1600e4 * t253 * t786 - 0.2800e4 / 0.3e1 * t113 * t789 - 0.2800e4 / 0.3e1 * t492 * t786 - 0.19600e5 / 0.9e1 * t261 * t789 - 0.400e3 / 0.9e1 * t83 * t796 - 0.1600e4 / 0.9e1 * t225 * t796 - 0.400e3 / 0.3e1 * t89 * t801
  t805 = t221 * t399
  t810 = t228 * t399
  t817 = t463 * t782
  t824 = t105 * t88
  t825 = t408 * tau0
  t826 = t109 * t825
  t827 = 0.1e1 / t744
  t828 = t826 * t827
  t831 = t115 * t825
  t832 = t831 * t827
  t835 = t121 * t825
  t836 = t835 * t827
  t839 = t127 * t825
  t840 = t839 * t827
  t843 = 0.440e3 / 0.27e2 * t83 * t805 + 0.880e3 / 0.27e2 * t225 * t805 + 0.880e3 / 0.27e2 * t89 * t810 - 0.400e3 / 0.3e1 * t453 * t796 - 0.400e3 * t232 * t801 - 0.800e3 / 0.3e1 * t95 * t817 - 0.800e3 / 0.3e1 * t467 * t801 - 0.6400e4 / 0.9e1 * t239 * t817 + 0.2500e4 / 0.9e1 * t824 * t828 + 0.12500e5 / 0.9e1 * t476 * t832 + 0.6250e4 / 0.3e1 * t246 * t836 + 0.8750e4 / 0.9e1 * t107 * t840
  t845 = t111 * t94
  t852 = t133 * t825
  t853 = t852 * t827
  t856 = t139 * t825
  t857 = t856 * t827
  t860 = t145 * t825
  t861 = t860 * t827
  t864 = t129 * t112
  t871 = t293 * t825
  t872 = t871 * t827
  t875 = t135 * t118
  t880 = 0.5000e4 / 0.9e1 * t845 * t832 + 0.2500e4 * t485 * t836 + 0.3500e4 * t253 * t840 + 0.14000e5 / 0.9e1 * t113 * t853 + 0.8000e4 * t268 * t857 + 0.10000e5 / 0.3e1 * t125 * t861 + 0.7000e4 / 0.3e1 * t864 * t853 + 0.9000e4 * t424 * t857 + 0.11250e5 * t275 * t861 + 0.13750e5 / 0.3e1 * t131 * t872 + 0.10000e5 / 0.3e1 * t875 * t857 + 0.12500e5 * t433 * t861
  t883 = t448 * t825
  t884 = t883 * t827
  t887 = t141 * t124
  t894 = t257 * t399
  t907 = t420 * t782
  t910 = 0.137500e6 / 0.9e1 * t282 * t872 + 0.55000e5 / 0.9e1 * t137 * t884 + 0.13750e5 / 0.3e1 * t887 * t861 + 0.151250e6 / 0.9e1 * t442 * t872 + 0.60500e5 / 0.3e1 * t289 * t884 + 0.880e3 / 0.9e1 * t113 * t894 + 0.3080e4 / 0.27e2 * t261 * t894 + 0.3080e4 / 0.27e2 * t119 * t772 - 0.4000e4 / 0.9e1 * t476 * t817 - 0.10000e5 / 0.9e1 * t246 * t783 - 0.2000e4 / 0.3e1 * t107 * t786 - 0.1600e4 * t125 * t907
  t913 = t416 * t782
  t918 = t429 * t782
  t925 = t438 * t782
  t932 = t449 * t782
  t941 = -0.1600e4 * t424 * t913 - 0.3600e4 * t275 * t907 - 0.2000e4 * t131 * t918 - 0.2000e4 * t433 * t907 - 0.40000e5 / 0.9e1 * t282 * t918 - 0.22000e5 / 0.9e1 * t137 * t925 - 0.22000e5 / 0.9e1 * t442 * t918 - 0.48400e5 / 0.9e1 * t289 * t925 - 0.8800e4 / 0.3e1 * t143 * t932 - 0.11200e5 / 0.9e1 * t119 * t913 - 0.11200e5 / 0.9e1 * t407 * t789 - 0.25600e5 / 0.9e1 * t268 * t913
  t944 = t103 * t825
  t945 = t944 * t827
  t952 = t99 * t82
  t962 = 0.1e1 / t126 / t114
  t963 = t962 * t825
  t964 = t963 * t827
  t971 = t123 * t106
  t974 = 0.1000e4 / 0.9e1 * t89 * t828 + 0.250e3 * t453 * t945 + 0.500e3 * t232 * t828 + 0.2500e4 / 0.9e1 * t95 * t832 + 0.1000e4 / 0.9e1 * t952 * t945 + 0.2000e4 / 0.3e1 * t467 * t828 + 0.10000e5 / 0.9e1 * t239 * t832 + 0.5000e4 / 0.9e1 * t101 * t836 + 0.71500e5 / 0.9e1 * t143 * t964 + 0.49000e5 / 0.9e1 * t261 * t853 + 0.7000e4 / 0.3e1 * t119 * t857 + 0.14000e5 / 0.9e1 * t971 * t840
  t978 = t278 * t399
  t983 = t285 * t399
  t988 = t294 * t399
  t993 = t235 * t399
  t998 = t242 * t399
  t1003 = t249 * t399
  t1006 = 0.56000e5 / 0.9e1 * t407 * t853 + 0.440e3 / 0.3e1 * t131 * t978 + 0.4400e4 / 0.27e2 * t282 * t978 + 0.4400e4 / 0.27e2 * t137 * t983 + 0.4840e4 / 0.27e2 * t289 * t983 + 0.4840e4 / 0.27e2 * t143 * t988 + 0.440e3 / 0.9e1 * t232 * t810 + 0.440e3 / 0.9e1 * t95 * t993 + 0.1760e4 / 0.27e2 * t239 * t993 + 0.1760e4 / 0.27e2 * t101 * t998 + 0.2200e4 / 0.27e2 * t246 * t998 + 0.2200e4 / 0.27e2 * t107 * t1003
  t1009 = t117 * t100
  t1020 = t782 * t91
  t1023 = t399 * t85
  t1026 = t93 * t825
  t1027 = t827 * t97
  t1030 = t75 * t825
  t1033 = t87 * t825
  t1038 = 0.880e3 / 0.9e1 * t253 * t1003 + 0.8750e4 / 0.9e1 * t1009 * t836 + 0.12250e5 / 0.3e1 * t492 * t840 + 0.250e3 / 0.9e1 * t83 * t945 + 0.500e3 / 0.3e1 * t225 * t945 - 0.4000e4 / 0.9e1 * t101 * t783 - 0.400e3 / 0.9e1 * t568 * t1020 + 0.440e3 / 0.27e2 * t217 * t1023 + 0.250e3 / 0.9e1 * t1026 * t1027 + 0.250e3 / 0.9e1 * t1030 * t1027 + 0.500e3 / 0.9e1 * t1033 * t1027 - 0.400e3 / 0.9e1 * t564 * t1020
  t1041 = t804 + t843 + t880 + t910 + t941 + t974 + t1006 + t1038
  t1043 = t761 * t150
  t1047 = t752 * t150
  t1054 = t741 * t743
  t1055 = t746 * t150
  t1065 = t184 * t124
  t1076 = t172 * t100
  t1089 = 0.13750e5 / 0.3e1 * t1065 * t861 + 0.151250e6 / 0.9e1 * t696 * t872 + 0.60500e5 / 0.3e1 * t357 * t884 + 0.71500e5 / 0.9e1 * t185 * t964 + 0.14000e5 / 0.9e1 * t170 * t853 + 0.8750e4 / 0.9e1 * t1076 * t836 + 0.12250e5 / 0.3e1 * t590 * t840 - 0.4000e4 / 0.9e1 * t164 * t783 - 0.4000e4 / 0.9e1 * t639 * t817 - 0.10000e5 / 0.9e1 * t326 * t783 - 0.2000e4 / 0.3e1 * t167 * t786
  t1104 = t175 * t106
  t1113 = t178 * t112
  t1116 = -0.2000e4 / 0.3e1 * t646 * t783 - 0.2800e4 / 0.3e1 * t170 * t789 - 0.2800e4 / 0.3e1 * t590 * t786 - 0.19600e5 / 0.9e1 * t337 * t789 + 0.8750e4 / 0.9e1 * t167 * t840 + 0.49000e5 / 0.9e1 * t337 * t853 + 0.7000e4 / 0.3e1 * t173 * t857 + 0.14000e5 / 0.9e1 * t1104 * t840 + 0.56000e5 / 0.9e1 * t597 * t853 + 0.8000e4 * t342 * t857 + 0.10000e5 / 0.3e1 * t176 * t861 + 0.7000e4 / 0.3e1 * t1113 * t853
  t1124 = t181 * t118
  t1143 = 0.9000e4 * t604 * t857 + 0.11250e5 * t347 * t861 + 0.13750e5 / 0.3e1 * t179 * t872 + 0.10000e5 / 0.3e1 * t1124 * t857 + 0.12500e5 * t611 * t861 + 0.137500e6 / 0.9e1 * t352 * t872 + 0.55000e5 / 0.9e1 * t182 * t884 + 0.440e3 / 0.3e1 * t179 * t978 + 0.4400e4 / 0.27e2 * t352 * t978 + 0.4400e4 / 0.27e2 * t182 * t983 + 0.4840e4 / 0.27e2 * t357 * t983 + 0.4840e4 / 0.27e2 * t185 * t988
  t1168 = -0.400e3 / 0.3e1 * t158 * t801 - 0.400e3 / 0.3e1 * t625 * t796 - 0.400e3 * t316 * t801 - 0.800e3 / 0.3e1 * t161 * t817 - 0.800e3 / 0.3e1 * t632 * t801 - 0.6400e4 / 0.9e1 * t321 * t817 + 0.440e3 / 0.9e1 * t316 * t810 + 0.440e3 / 0.9e1 * t161 * t993 + 0.1760e4 / 0.27e2 * t321 * t993 + 0.1760e4 / 0.27e2 * t164 * t998 + 0.2200e4 / 0.27e2 * t326 * t998 + 0.2200e4 / 0.27e2 * t167 * t1003
  t1193 = t169 * t94
  t1196 = 0.880e3 / 0.9e1 * t331 * t1003 + 0.880e3 / 0.9e1 * t170 * t894 + 0.3080e4 / 0.27e2 * t337 * t894 + 0.3080e4 / 0.27e2 * t173 * t772 + 0.3520e4 / 0.27e2 * t342 * t772 + 0.3520e4 / 0.27e2 * t176 * t775 + 0.440e3 / 0.3e1 * t347 * t775 - 0.1600e4 * t331 * t786 + 0.440e3 / 0.27e2 * t155 * t805 + 0.880e3 / 0.27e2 * t311 * t805 + 0.880e3 / 0.27e2 * t158 * t810 + 0.5000e4 / 0.9e1 * t1193 * t832
  t1209 = t163 * t82
  t1218 = t166 * t88
  t1223 = 0.250e3 / 0.9e1 * t155 * t945 + 0.500e3 / 0.3e1 * t311 * t945 + 0.1000e4 / 0.9e1 * t158 * t828 + 0.250e3 * t625 * t945 + 0.500e3 * t316 * t828 + 0.2500e4 / 0.9e1 * t161 * t832 + 0.1000e4 / 0.9e1 * t1209 * t945 + 0.2000e4 / 0.3e1 * t632 * t828 + 0.10000e5 / 0.9e1 * t321 * t832 + 0.5000e4 / 0.9e1 * t164 * t836 + 0.2500e4 / 0.9e1 * t1218 * t828 + 0.12500e5 / 0.9e1 * t639 * t832
  t1249 = 0.6250e4 / 0.3e1 * t326 * t836 - 0.3600e4 * t347 * t907 - 0.2000e4 * t179 * t918 - 0.2000e4 * t611 * t907 - 0.40000e5 / 0.9e1 * t352 * t918 - 0.22000e5 / 0.9e1 * t182 * t925 - 0.22000e5 / 0.9e1 * t696 * t918 - 0.48400e5 / 0.9e1 * t357 * t925 - 0.8800e4 / 0.3e1 * t185 * t932 - 0.11200e5 / 0.9e1 * t173 * t913 - 0.11200e5 / 0.9e1 * t597 * t789 - 0.25600e5 / 0.9e1 * t342 * t913
  t1268 = t154 * t825
  t1271 = t157 * t825
  t1274 = t160 * t825
  t1277 = -0.1600e4 * t176 * t907 - 0.1600e4 * t604 * t913 + 0.2500e4 * t646 * t836 + 0.3500e4 * t331 * t840 - 0.400e3 / 0.9e1 * t155 * t796 - 0.1600e4 / 0.9e1 * t311 * t796 + 0.440e3 / 0.27e2 * t306 * t1023 - 0.400e3 / 0.9e1 * t705 * t1020 - 0.400e3 / 0.9e1 * t708 * t1020 + 0.250e3 / 0.9e1 * t1268 * t1027 + 0.500e3 / 0.9e1 * t1271 * t1027 + 0.250e3 / 0.9e1 * t1274 * t1027
  t1280 = t1089 + t1116 + t1143 + t1168 + t1196 + t1223 + t1249 + t1277
  t1282 = -0.33763697389331654400000000000000000000000000000000e-3 * t742 * t747 * t147 + 0.84597665546592000000000000000000000000000000000000e-2 * t388 * t753 * t147 - 0.23072090603616000000000000000000000000000000000000e-2 * t388 * t394 * t299 - 0.26977525344000000000000000000000000000000000000000e0 * t209 * t762 * t147 + 0.17342694864000000000000000000000000000000000000000e0 * t209 * t400 * t299 - 0.47298258720000000000000000000000000000000000000000e-1 * t209 * t213 * t573 + t73 * t1041 - 0.23472031702484377381496723060509068739521414418534e0 * t301 * t1043 * t187 + 0.37497175099181391670974751202152616011555565809329e-2 * t580 * t1047 * t187 + 0.15089163237311385459533607681755829903978052126200e0 * t301 * t575 * t363 - 0.50826535753646762405285749608474189034135729014958e-4 * t1054 * t1055 * t187 - 0.10226502299776743182993113964223440730424245220726e-2 * t580 * t581 * t363 - 0.41152263374485596707818930041152263374485596707819e-1 * t301 * t302 * t713 + t152 * t1280
  t1287 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t55 * t189 - 0.3e1 / 0.8e1 * t5 * t201 * t189 - 0.9e1 / 0.8e1 * t5 * t205 * t365 + t5 * t374 * t189 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t378 * t365 - 0.9e1 / 0.8e1 * t5 * t382 * t715 - 0.5e1 / 0.36e2 * t5 * t725 * t189 + t5 * t729 * t365 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t733 * t715 - 0.3e1 / 0.8e1 * t5 * t737 * t1282)
  t1289 = r1 <= f.p.dens_threshold
  t1290 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t1291 = 0.1e1 + t1290
  t1292 = t1291 <= f.p.zeta_threshold
  t1293 = t1291 ** (0.1e1 / 0.3e1)
  t1294 = t1293 ** 2
  t1296 = 0.1e1 / t1294 / t1291
  t1298 = f.my_piecewise5(t14, 0, t10, 0, -t28)
  t1299 = t1298 ** 2
  t1303 = 0.1e1 / t1294
  t1304 = t1303 * t1298
  t1306 = f.my_piecewise5(t14, 0, t10, 0, -t40)
  t1310 = f.my_piecewise5(t14, 0, t10, 0, -t48)
  t1314 = f.my_piecewise3(t1292, 0, -0.8e1 / 0.27e2 * t1296 * t1299 * t1298 + 0.4e1 / 0.3e1 * t1304 * t1306 + 0.4e1 / 0.3e1 * t1293 * t1310)
  t1316 = r1 ** 2
  t1317 = r1 ** (0.1e1 / 0.3e1)
  t1318 = t1317 ** 2
  t1322 = t61 * s2 / t1318 / t1316
  t1330 = tau1 / t1318 / r1
  t1331 = t78 - t1330
  t1333 = t78 + t1330
  t1334 = 0.1e1 / t1333
  t1336 = t1331 ** 2
  t1338 = t1333 ** 2
  t1339 = 0.1e1 / t1338
  t1341 = t1336 * t1331
  t1343 = t1338 * t1333
  t1344 = 0.1e1 / t1343
  t1346 = t1336 ** 2
  t1348 = t1338 ** 2
  t1349 = 0.1e1 / t1348
  t1351 = t1346 * t1331
  t1354 = 0.1e1 / t1348 / t1333
  t1356 = t1346 * t1336
  t1359 = 0.1e1 / t1348 / t1338
  t1361 = t1346 * t1341
  t1364 = 0.1e1 / t1348 / t1343
  t1366 = t1346 ** 2
  t1368 = t1348 ** 2
  t1369 = 0.1e1 / t1368
  t1371 = t1366 * t1331
  t1374 = 0.1e1 / t1368 / t1333
  t1376 = t1366 * t1336
  t1379 = 0.1e1 / t1368 / t1338
  t1381 = t1366 * t1341
  t1384 = 0.1e1 / t1368 / t1343
  t1386 = t74 + t75 * t1331 * t1334 + t87 * t1336 * t1339 + t93 * t1341 * t1344 + t99 * t1346 * t1349 + t105 * t1351 * t1354 + t111 * t1356 * t1359 + t117 * t1361 * t1364 + t123 * t1366 * t1369 + t129 * t1371 * t1374 + t135 * t1376 * t1379 + t141 * t1381 * t1384
  t1389 = jnp.exp(-0.93189002206715572255024750998986103655990934573866e-2 * t1322)
  t1414 = t153 + t154 * t1331 * t1334 + t157 * t1336 * t1339 + t160 * t1341 * t1344 + t163 * t1346 * t1349 + t166 * t1351 * t1354 + t169 * t1356 * t1359 + t172 * t1361 * t1364 + t175 * t1366 * t1369 + t178 * t1371 * t1374 + t181 * t1376 * t1379 + t184 * t1381 * t1384
  t1416 = (0.18040e1 - 0.64641600e0 / (0.8040e0 + 0.91462500000000000000000000000000000000000000000000e-2 * t1322)) * t1386 + (0.1552e1 - 0.552e0 * t1389) * t1414
  t1425 = f.my_piecewise3(t1292, 0, 0.4e1 / 0.9e1 * t1303 * t1299 + 0.4e1 / 0.3e1 * t1293 * t1306)
  t1432 = f.my_piecewise3(t1292, 0, 0.4e1 / 0.3e1 * t1293 * t1298)
  t1438 = f.my_piecewise3(t1292, t720, t1293 * t1291)
  t1444 = f.my_piecewise3(t1289, 0, -0.3e1 / 0.8e1 * t5 * t1314 * t54 * t1416 - 0.3e1 / 0.8e1 * t5 * t1425 * t200 * t1416 + t5 * t1432 * t373 * t1416 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t1438 * t724 * t1416)
  t1452 = 0.1e1 / t199 / t36
  t1463 = t19 ** 2
  t1466 = t30 ** 2
  t1472 = t41 ** 2
  t1481 = -0.24e2 * t45 + 0.24e2 * t16 / t44 / t6
  t1482 = f.my_piecewise5(t10, 0, t14, 0, t1481)
  t1486 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t22 / t1463 * t1466 - 0.16e2 / 0.9e1 * t24 * t30 * t41 + 0.4e1 / 0.3e1 * t34 * t1472 + 0.16e2 / 0.9e1 * t35 * t49 + 0.4e1 / 0.3e1 * t21 * t1482)
  t1533 = t744 * r0
  t1535 = 0.1e1 / t63 / t1533
  t1549 = t389 ** 2
  t1553 = 0.1e1 / t64 / t744 / t780
  t1565 = -0.63064344960000000000000000000000000000000000000000e-1 * t209 * t213 * t1041 + 0.34685389728000000000000000000000000000000000000000e0 * t209 * t400 * t573 - 0.54869684499314128943758573388203017832647462277092e-1 * t301 * t302 * t1280 - 0.20453004599553486365986227928446881460848490441452e-2 * t580 * t581 * t713 + 0.30178326474622770919067215363511659807956104252400e0 * t301 * t575 * t713 - 0.37080539820301598430186142855462031389204948411447e-1 * t580 * t1535 * t150 * t187 + 0.14998870039672556668389900480861046404622226323731e-1 * t580 * t1047 * t363 - 0.93888126809937509525986892242036274958085657674134e0 * t301 * t1043 * t363 - 0.32939863173031962032640000000000000000000000000000e-4 / t738 / t70 * t741 * t1549 * t1553 * t147 * t61 - 0.83657691484963200000000000000000000000000000000000e-1 * t388 * t389 * t1535 * t147 - 0.10791010137600000000000000000000000000000000000000e1 * t209 * t762 * t299
  t1579 = 0.1e1 / t64 / t780
  t1584 = t459 * t393
  t1587 = t463 * t393
  t1590 = t472 * t393
  t1593 = t481 * t393
  t1598 = 0.1e1 / t1533
  t1599 = t852 * t1598
  t1602 = t835 * t1598
  t1605 = t839 * t1598
  t1612 = t278 * t761
  t1615 = t285 * t761
  t1618 = t242 * t761
  t1621 = t249 * t761
  t1626 = t454 * t393
  t1629 = t831 * t1598
  t1634 = 0.27200e5 / 0.9e1 * t316 * t1584 + 0.54400e5 / 0.27e2 * t161 * t1587 + 0.680000e6 / 0.81e2 * t326 * t1590 + 0.136000e6 / 0.27e2 * t167 * t1593 + 0.136000e6 / 0.27e2 * t646 * t1590 - 0.224000e6 / 0.9e1 * t170 * t1599 - 0.140000e6 / 0.9e1 * t1076 * t1602 - 0.196000e6 / 0.3e1 * t590 * t1605 + 0.272000e6 / 0.81e2 * t164 * t1590 + 0.272000e6 / 0.81e2 * t639 * t1587 - 0.61600e5 / 0.81e2 * t352 * t1612 - 0.61600e5 / 0.81e2 * t182 * t1615 - 0.30800e5 / 0.81e2 * t326 * t1618 - 0.30800e5 / 0.81e2 * t167 * t1621 - 0.12320e5 / 0.27e2 * t331 * t1621 + 0.27200e5 / 0.27e2 * t625 * t1626 - 0.200000e6 / 0.9e1 * t639 * t1629 - 0.100000e6 / 0.3e1 * t326 * t1602
  t1639 = t856 * t1598
  t1650 = t944 * t1598
  t1655 = t826 * t1598
  t1670 = t294 * t761
  t1673 = t257 * t761
  t1676 = -0.140000e6 / 0.9e1 * t167 * t1605 - 0.784000e6 / 0.9e1 * t337 * t1599 - 0.112000e6 / 0.3e1 * t173 * t1639 - 0.224000e6 / 0.9e1 * t1104 * t1605 - 0.896000e6 / 0.9e1 * t597 * t1599 - 0.128000e6 * t342 * t1639 - 0.80000e5 / 0.9e1 * t1193 * t1629 - 0.4000e4 / 0.9e1 * t155 * t1650 - 0.8000e4 / 0.3e1 * t311 * t1650 - 0.16000e5 / 0.9e1 * t158 * t1655 - 0.4000e4 * t625 * t1650 - 0.8000e4 * t316 * t1655 - 0.40000e5 / 0.9e1 * t161 * t1629 - 0.16000e5 / 0.9e1 * t1209 * t1650 - 0.32000e5 / 0.3e1 * t632 * t1655 - 0.160000e6 / 0.9e1 * t321 * t1629 - 0.67760e5 / 0.81e2 * t185 * t1670 - 0.12320e5 / 0.27e2 * t170 * t1673
  t1680 = t264 * t761
  t1685 = t271 * t761
  t1690 = t221 * t761
  t1695 = t228 * t761
  t1704 = t409 * t393
  t1707 = t416 * t393
  t1710 = t420 * t393
  t1721 = -0.43120e5 / 0.81e2 * t337 * t1673 - 0.43120e5 / 0.81e2 * t173 * t1680 - 0.49280e5 / 0.81e2 * t342 * t1680 - 0.49280e5 / 0.81e2 * t176 * t1685 - 0.6160e4 / 0.9e1 * t347 * t1685 - 0.6160e4 / 0.81e2 * t155 * t1690 - 0.12320e5 / 0.81e2 * t311 * t1690 - 0.12320e5 / 0.81e2 * t158 * t1695 + 0.54400e5 / 0.27e2 * t632 * t1584 + 0.435200e6 / 0.81e2 * t321 * t1587 - 0.6160e4 / 0.27e2 * t316 * t1695 + 0.761600e6 / 0.81e2 * t597 * t1704 + 0.1740800e7 / 0.81e2 * t342 * t1707 + 0.108800e6 / 0.9e1 * t176 * t1710 + 0.108800e6 / 0.9e1 * t604 * t1707 + 0.27200e5 * t347 * t1710 - 0.40000e5 * t646 * t1602 - 0.56000e5 * t331 * t1605
  t1722 = t235 * t761
  t1729 = t408 ** 2
  t1733 = 0.1e1 / t64 / t744 / t62
  t1734 = t448 * t1729 * t1733
  t1738 = t962 * t1729 * t1733
  t1744 = 0.1e1 / t126 / t120 * t1729 * t1733
  t1748 = t133 * t1729 * t1733
  t1752 = t139 * t1729 * t1733
  t1774 = t429 * t393
  t1777 = -0.6160e4 / 0.27e2 * t161 * t1722 - 0.24640e5 / 0.81e2 * t321 * t1722 - 0.24640e5 / 0.81e2 * t164 * t1618 + 0.6050000e7 / 0.9e1 * t696 * t1734 + 0.15730000e8 / 0.27e2 * t357 * t1738 + 0.5005000e7 / 0.27e2 * t185 * t1744 + 0.560000e6 / 0.9e1 * t331 * t1748 + 0.70000e5 / 0.3e1 * t170 * t1752 + 0.275000e6 / 0.3e1 * t179 * t1734 + 0.350000e6 / 0.9e1 * t181 * t112 * t1752 - 0.80000e5 / 0.9e1 * t164 * t1602 - 0.40000e5 / 0.9e1 * t1218 * t1655 + 0.190400e6 / 0.27e2 * t590 * t1593 + 0.1332800e7 / 0.81e2 * t337 * t1704 + 0.761600e6 / 0.81e2 * t173 * t1707 + 0.27200e5 / 0.81e2 * t155 * t1626 + 0.108800e6 / 0.81e2 * t311 * t1626 + 0.2720000e7 / 0.81e2 * t352 * t1774
  t1780 = t438 * t393
  t1786 = t121 * t1729 * t1733
  t1790 = t127 * t1729 * t1733
  t1800 = t145 * t1729 * t1733
  t1813 = t293 * t1729 * t1733
  t1826 = t109 * t1729 * t1733
  t1829 = 0.1496000e7 / 0.81e2 * t182 * t1780 + 0.1496000e7 / 0.81e2 * t696 * t1774 + 0.250000e6 / 0.9e1 * t639 * t1786 + 0.875000e6 / 0.27e2 * t326 * t1790 + 0.350000e6 / 0.27e2 * t167 * t1748 + 0.980000e6 / 0.9e1 * t590 * t1748 + 0.980000e6 / 0.9e1 * t337 * t1752 + 0.350000e6 / 0.9e1 * t173 * t1800 + 0.350000e6 / 0.27e2 * t175 * t100 * t1790 + 0.2240000e7 / 0.27e2 * t1104 * t1748 + 0.560000e6 / 0.3e1 * t597 * t1752 + 0.1600000e7 / 0.9e1 * t342 * t1800 + 0.550000e6 / 0.9e1 * t176 * t1813 + 0.70000e5 / 0.3e1 * t178 * t106 * t1748 + 0.140000e6 * t1113 * t1752 + 0.300000e6 * t604 * t1800 + 0.275000e6 * t347 * t1813 + 0.5000e4 / 0.27e2 * t155 * t1826
  t1833 = t115 * t1729 * t1733
  t1857 = t860 * t1598
  t1866 = t871 * t1598
  t1871 = 0.40000e5 / 0.27e2 * t311 * t1826 + 0.25000e5 / 0.27e2 * t158 * t1833 + 0.10000e5 / 0.3e1 * t625 * t1826 + 0.50000e5 / 0.9e1 * t316 * t1833 + 0.25000e5 / 0.9e1 * t161 * t1786 + 0.80000e5 / 0.27e2 * t1209 * t1826 + 0.100000e6 / 0.9e1 * t632 * t1833 + 0.400000e6 / 0.27e2 * t321 * t1786 + 0.175000e6 / 0.27e2 * t164 * t1790 + 0.25000e5 / 0.27e2 * t166 * t82 * t1826 + 0.250000e6 / 0.27e2 * t1218 * t1833 - 0.67760e5 / 0.81e2 * t357 * t1615 - 0.160000e6 / 0.3e1 * t176 * t1857 - 0.112000e6 / 0.3e1 * t1113 * t1599 - 0.144000e6 * t604 * t1639 - 0.180000e6 * t347 * t1857 - 0.220000e6 / 0.3e1 * t179 * t1866 - 0.160000e6 / 0.3e1 * t1124 * t1639
  t1877 = t883 * t1598
  t1895 = t963 * t1598
  t1912 = t449 * t393
  t1915 = -0.200000e6 * t611 * t1857 - 0.2200000e7 / 0.9e1 * t352 * t1866 - 0.880000e6 / 0.9e1 * t182 * t1877 - 0.6160e4 / 0.9e1 * t179 * t1612 + 0.175000e6 / 0.3e1 * t646 * t1790 + 0.175000e6 / 0.27e2 * t172 * t94 * t1786 + 0.1225000e7 / 0.27e2 * t1076 * t1790 - 0.220000e6 / 0.3e1 * t1065 * t1857 - 0.2420000e7 / 0.9e1 * t696 * t1866 - 0.968000e6 / 0.3e1 * t357 * t1877 - 0.1144000e7 / 0.9e1 * t185 * t1895 + 0.550000e6 / 0.9e1 * t184 * t118 * t1800 + 0.3025000e7 / 0.9e1 * t1065 * t1813 + 0.27200e5 / 0.27e2 * t158 * t1584 + 0.25000e5 / 0.9e1 * t169 * t88 * t1833 + 0.200000e6 / 0.9e1 * t1193 * t1786 + 0.3291200e7 / 0.81e2 * t357 * t1780 + 0.598400e6 / 0.27e2 * t185 * t1912
  t1933 = t1733 * t103
  t1942 = t1598 * t97
  t1949 = t393 * t91
  t1952 = t761 * t85
  t1960 = 0.108800e6 / 0.9e1 * t331 * t1593 + 0.190400e6 / 0.27e2 * t170 * t1704 + 0.2000000e7 / 0.9e1 * t1124 * t1800 + 0.1375000e7 / 0.3e1 * t611 * t1813 + 0.11000000e8 / 0.27e2 * t352 * t1734 + 0.3575000e7 / 0.27e2 * t182 * t1738 + 0.136000e6 / 0.9e1 * t179 * t1774 + 0.136000e6 / 0.9e1 * t611 * t1710 + 0.5000e4 / 0.9e1 * t157 * t1729 * t1933 + 0.5000e4 / 0.9e1 * t160 * t1729 * t1933 + 0.5000e4 / 0.27e2 * t163 * t1729 * t1933 - 0.4000e4 / 0.9e1 * t1268 * t1942 - 0.8000e4 / 0.9e1 * t1271 * t1942 - 0.4000e4 / 0.9e1 * t1274 * t1942 + 0.27200e5 / 0.81e2 * t705 * t1949 - 0.6160e4 / 0.81e2 * t306 * t1952 + 0.27200e5 / 0.81e2 * t708 * t1949 + 0.5000e4 / 0.27e2 * t154 * t1729 * t1933
  t2006 = 0.3575000e7 / 0.27e2 * t137 * t1738 + 0.550000e6 / 0.9e1 * t141 * t118 * t1800 + 0.3025000e7 / 0.9e1 * t887 * t1813 + 0.6050000e7 / 0.9e1 * t442 * t1734 + 0.2000000e7 / 0.9e1 * t875 * t1800 + 0.25000e5 / 0.27e2 * t89 * t1833 + 0.598400e6 / 0.27e2 * t143 * t1912 + 0.27200e5 / 0.27e2 * t453 * t1626 + 0.190400e6 / 0.27e2 * t113 * t1704 + 0.10000e5 / 0.3e1 * t453 * t1826 + 0.50000e5 / 0.9e1 * t232 * t1833 + 0.25000e5 / 0.9e1 * t95 * t1786 + 0.80000e5 / 0.27e2 * t952 * t1826 + 0.100000e6 / 0.9e1 * t467 * t1833 + 0.400000e6 / 0.27e2 * t239 * t1786 + 0.175000e6 / 0.27e2 * t101 * t1790 + 0.25000e5 / 0.27e2 * t105 * t82 * t1826 + 0.250000e6 / 0.27e2 * t824 * t1833
  t2044 = 0.250000e6 / 0.9e1 * t476 * t1786 + 0.875000e6 / 0.27e2 * t246 * t1790 + 0.272000e6 / 0.81e2 * t101 * t1590 + 0.272000e6 / 0.81e2 * t476 * t1587 + 0.680000e6 / 0.81e2 * t246 * t1590 + 0.136000e6 / 0.27e2 * t107 * t1593 + 0.136000e6 / 0.27e2 * t485 * t1590 + 0.108800e6 / 0.9e1 * t253 * t1593 + 0.175000e6 / 0.27e2 * t117 * t94 * t1786 + 0.1225000e7 / 0.27e2 * t1009 * t1790 + 0.980000e6 / 0.9e1 * t492 * t1748 + 0.5000e4 / 0.27e2 * t83 * t1826 + 0.40000e5 / 0.27e2 * t225 * t1826 - 0.784000e6 / 0.9e1 * t261 * t1599 - 0.112000e6 / 0.3e1 * t119 * t1639 - 0.224000e6 / 0.9e1 * t971 * t1605 - 0.896000e6 / 0.9e1 * t407 * t1599 - 0.128000e6 * t268 * t1639
  t2082 = -0.8000e4 * t232 * t1655 - 0.40000e5 / 0.9e1 * t95 * t1629 - 0.16000e5 / 0.9e1 * t952 * t1650 + 0.1740800e7 / 0.81e2 * t268 * t1707 - 0.16000e5 / 0.9e1 * t89 * t1655 - 0.4000e4 * t453 * t1650 + 0.27200e5 / 0.81e2 * t83 * t1626 + 0.108800e6 / 0.81e2 * t225 * t1626 + 0.27200e5 / 0.27e2 * t89 * t1584 - 0.32000e5 / 0.3e1 * t467 * t1655 - 0.160000e6 / 0.9e1 * t239 * t1629 - 0.80000e5 / 0.9e1 * t101 * t1602 - 0.6160e4 / 0.27e2 * t95 * t1722 - 0.24640e5 / 0.81e2 * t239 * t1722 - 0.24640e5 / 0.81e2 * t101 * t1618 - 0.30800e5 / 0.81e2 * t246 * t1618 - 0.30800e5 / 0.81e2 * t107 * t1621 - 0.12320e5 / 0.27e2 * t253 * t1621
  t2119 = -0.140000e6 / 0.9e1 * t1009 * t1602 - 0.196000e6 / 0.3e1 * t492 * t1605 - 0.4000e4 / 0.9e1 * t83 * t1650 - 0.8000e4 / 0.3e1 * t225 * t1650 + 0.761600e6 / 0.81e2 * t119 * t1707 + 0.1375000e7 / 0.3e1 * t433 * t1813 + 0.11000000e8 / 0.27e2 * t282 * t1734 + 0.136000e6 / 0.9e1 * t433 * t1710 + 0.2720000e7 / 0.81e2 * t282 * t1774 + 0.1496000e7 / 0.81e2 * t137 * t1780 + 0.1496000e7 / 0.81e2 * t442 * t1774 + 0.3291200e7 / 0.81e2 * t289 * t1780 + 0.190400e6 / 0.27e2 * t492 * t1593 + 0.1332800e7 / 0.81e2 * t261 * t1704 + 0.27200e5 / 0.9e1 * t232 * t1584 + 0.54400e5 / 0.27e2 * t95 * t1587 + 0.54400e5 / 0.27e2 * t467 * t1584 + 0.435200e6 / 0.81e2 * t239 * t1587
  t2158 = -0.67760e5 / 0.81e2 * t143 * t1670 - 0.6160e4 / 0.27e2 * t232 * t1695 - 0.12320e5 / 0.27e2 * t113 * t1673 - 0.43120e5 / 0.81e2 * t261 * t1673 - 0.43120e5 / 0.81e2 * t119 * t1680 - 0.49280e5 / 0.81e2 * t268 * t1680 - 0.49280e5 / 0.81e2 * t125 * t1685 - 0.6160e4 / 0.9e1 * t275 * t1685 - 0.2420000e7 / 0.9e1 * t442 * t1866 - 0.968000e6 / 0.3e1 * t289 * t1877 - 0.1144000e7 / 0.9e1 * t143 * t1895 - 0.6160e4 / 0.9e1 * t131 * t1612 - 0.61600e5 / 0.81e2 * t282 * t1612 - 0.61600e5 / 0.81e2 * t137 * t1615 - 0.67760e5 / 0.81e2 * t289 * t1615 - 0.112000e6 / 0.3e1 * t864 * t1599 - 0.144000e6 * t424 * t1639 - 0.180000e6 * t275 * t1857
  t2195 = -0.220000e6 / 0.3e1 * t131 * t1866 - 0.160000e6 / 0.3e1 * t875 * t1639 - 0.200000e6 * t433 * t1857 - 0.2200000e7 / 0.9e1 * t282 * t1866 - 0.880000e6 / 0.9e1 * t137 * t1877 - 0.220000e6 / 0.3e1 * t887 * t1857 - 0.40000e5 / 0.9e1 * t824 * t1655 - 0.200000e6 / 0.9e1 * t476 * t1629 - 0.100000e6 / 0.3e1 * t246 * t1602 - 0.140000e6 / 0.9e1 * t107 * t1605 - 0.80000e5 / 0.9e1 * t845 * t1629 - 0.40000e5 * t485 * t1602 - 0.56000e5 * t253 * t1605 - 0.224000e6 / 0.9e1 * t113 * t1599 - 0.160000e6 / 0.3e1 * t125 * t1857 + 0.761600e6 / 0.81e2 * t407 * t1704 - 0.6160e4 / 0.81e2 * t83 * t1690 - 0.12320e5 / 0.81e2 * t225 * t1690
  t2235 = -0.12320e5 / 0.81e2 * t89 * t1695 + 0.108800e6 / 0.9e1 * t125 * t1710 + 0.108800e6 / 0.9e1 * t424 * t1707 + 0.27200e5 * t275 * t1710 + 0.136000e6 / 0.9e1 * t131 * t1774 + 0.15730000e8 / 0.27e2 * t289 * t1738 + 0.5005000e7 / 0.27e2 * t143 * t1744 + 0.980000e6 / 0.9e1 * t261 * t1752 + 0.350000e6 / 0.9e1 * t119 * t1800 + 0.350000e6 / 0.27e2 * t123 * t100 * t1790 + 0.2240000e7 / 0.27e2 * t971 * t1748 + 0.350000e6 / 0.27e2 * t107 * t1748 + 0.25000e5 / 0.9e1 * t111 * t88 * t1833 + 0.200000e6 / 0.9e1 * t845 * t1786 + 0.175000e6 / 0.3e1 * t485 * t1790 + 0.560000e6 / 0.9e1 * t253 * t1748 + 0.70000e5 / 0.3e1 * t113 * t1752 + 0.560000e6 / 0.3e1 * t407 * t1752
  t2278 = 0.1600000e7 / 0.9e1 * t268 * t1800 + 0.550000e6 / 0.9e1 * t125 * t1813 + 0.70000e5 / 0.3e1 * t129 * t106 * t1748 + 0.140000e6 * t864 * t1752 + 0.300000e6 * t424 * t1800 + 0.275000e6 * t275 * t1813 + 0.275000e6 / 0.3e1 * t131 * t1734 + 0.350000e6 / 0.9e1 * t135 * t112 * t1752 + 0.27200e5 / 0.81e2 * t564 * t1949 + 0.5000e4 / 0.9e1 * t93 * t1729 * t1933 + 0.5000e4 / 0.27e2 * t75 * t1729 * t1933 + 0.5000e4 / 0.9e1 * t87 * t1729 * t1933 + 0.5000e4 / 0.27e2 * t99 * t1729 * t1933 - 0.6160e4 / 0.81e2 * t217 * t1952 - 0.4000e4 / 0.9e1 * t1026 * t1942 - 0.4000e4 / 0.9e1 * t1030 * t1942 - 0.8000e4 / 0.9e1 * t1033 * t1942 + 0.27200e5 / 0.81e2 * t568 * t1949
  t2287 = 0.1e1 / t744 / t390
  t2300 = 0.33839066218636800000000000000000000000000000000000e-1 * t388 * t753 * t299 - 0.46144181207232000000000000000000000000000000000000e-2 * t388 * t394 * t573 - 0.12630597740016789528360705952285786821866297144927e-5 * t741 * t1549 * t1553 * t61 * t150 * t187 + 0.13300817964741147182848143067621805619062134837169e1 * t301 * t1579 * t150 * t187 + t152 * (t1634 + t1676 + t1721 + t1777 + t1829 + t1871 + t1915 + t1960) - 0.13505478955732661760000000000000000000000000000000e-2 * t742 * t747 * t299 + t73 * (t2006 + t2044 + t2082 + t2119 + t2158 + t2195 + t2235 + t2278) - 0.20330614301458704962114299843389675613654291605984e-3 * t1054 * t1055 * t363 + 0.11181837865802287729162864913864321587509860383291e-2 * t1054 * t2287 * t150 * t187 + 0.15287264361600000000000000000000000000000000000000e1 * t209 * s0 * t1579 * t147 + 0.74280134256529639680000000000000000000000000000000e-2 * t742 * t743 * t2287 * t147
  t2305 = -0.3e1 / 0.2e1 * t5 * t378 * t715 + t5 * t374 * t365 + 0.10e2 / 0.27e2 * t5 * t722 * t1452 * t189 - 0.9e1 / 0.4e1 * t5 * t205 * t715 - 0.3e1 / 0.2e1 * t5 * t201 * t365 - 0.3e1 / 0.8e1 * t5 * t1486 * t54 * t189 - 0.3e1 / 0.2e1 * t5 * t55 * t365 + t5 * t198 * t373 * t189 / 0.2e1 - t5 * t53 * t200 * t189 / 0.2e1 - 0.3e1 / 0.2e1 * t5 * t382 * t1282 - t5 * t733 * t1282 / 0.2e1 + t5 * t729 * t715 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t725 * t365 - 0.5e1 / 0.9e1 * t5 * t371 * t724 * t189 - 0.3e1 / 0.8e1 * t5 * t737 * (t1565 + t2300)
  t2306 = f.my_piecewise3(t1, 0, t2305)
  t2307 = t1291 ** 2
  t2310 = t1299 ** 2
  t2316 = t1306 ** 2
  t2322 = f.my_piecewise5(t14, 0, t10, 0, -t1481)
  t2326 = f.my_piecewise3(t1292, 0, 0.40e2 / 0.81e2 / t1294 / t2307 * t2310 - 0.16e2 / 0.9e1 * t1296 * t1299 * t1306 + 0.4e1 / 0.3e1 * t1303 * t2316 + 0.16e2 / 0.9e1 * t1304 * t1310 + 0.4e1 / 0.3e1 * t1293 * t2322)
  t2348 = f.my_piecewise3(t1289, 0, -0.3e1 / 0.8e1 * t5 * t2326 * t54 * t1416 - t5 * t1314 * t200 * t1416 / 0.2e1 + t5 * t1425 * t373 * t1416 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t1432 * t724 * t1416 + 0.10e2 / 0.27e2 * t5 * t1438 * t1452 * t1416)
  d1111 = 0.4e1 * t1287 + 0.4e1 * t1444 + t6 * (t2306 + t2348)

  res = {'v4rho4': d1111}
  return res
