"""Generated from mgga_x_revtm.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  tm_lambda = 0.6866

  tm_beta = 79.873

  tm_p = lambda x: (X2S * x) ** 2

  tm_alpha = lambda x, t: (t - x ** 2 / 8) / K_FACTOR_C

  tm_tratio = lambda x, t: jnp.minimum(1.0, x ** 2 / (8 * t))

  tm_b = 0.4

  tm_y = lambda x: (2 * tm_lambda - 1) ** 2 * tm_p(x)

  tm_R = lambda x, t: 1 + 595 * (2 * tm_lambda - 1) ** 2 * tm_p(x) / 54 - (t - 3 * (tm_lambda ** 2 - tm_lambda + 1 / 2) * (t - K_FACTOR_C - x ** 2 / 72)) / K_FACTOR_C

  tm_w = lambda x, t: (tm_tratio(x, t) ** 2 + 3 * tm_tratio(x, t) ** 3) / (1 + tm_tratio(x, t) ** 3) ** 2

  tm_qtilde = lambda x, t: 9 / 20 * (tm_alpha(x, t) - 1) / jnp.sqrt(1 + tm_b * tm_alpha(x, t) * (tm_alpha(x, t) - 1)) + 2 * tm_p(x) / 3

  tm_f0 = lambda x: (1 + 10 * (70 * tm_y(x) / 27) + tm_beta * tm_y(x) ** 2) ** (1 / 10)

  tm_fx_SC = lambda x, t: (1 + 10 * (+(MU_GE + 50 * tm_p(x) / 729) * tm_p(x) + 146 * tm_qtilde(x, t) ** 2 / 2025 - 73 * tm_qtilde(x, t) / 405 * (3 / 5 * tm_tratio(x, t)) * (1 - tm_tratio(x, t)))) ** (1 / 10)

  tm_fx_DME = lambda x, t: 1 / tm_f0(x) ** 2 + 7 * tm_R(x, t) / (9 * tm_f0(x) ** 4)

  tm_f = lambda x, u, t: tm_w(x, t) * tm_fx_DME(x, t) + (1 - tm_w(x, t)) * tm_fx_SC(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, tm_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  tm_lambda = 0.6866

  tm_beta = 79.873

  tm_p = lambda x: (X2S * x) ** 2

  tm_alpha = lambda x, t: (t - x ** 2 / 8) / K_FACTOR_C

  tm_tratio = lambda x, t: jnp.minimum(1.0, x ** 2 / (8 * t))

  tm_b = 0.4

  tm_y = lambda x: (2 * tm_lambda - 1) ** 2 * tm_p(x)

  tm_R = lambda x, t: 1 + 595 * (2 * tm_lambda - 1) ** 2 * tm_p(x) / 54 - (t - 3 * (tm_lambda ** 2 - tm_lambda + 1 / 2) * (t - K_FACTOR_C - x ** 2 / 72)) / K_FACTOR_C

  tm_w = lambda x, t: (tm_tratio(x, t) ** 2 + 3 * tm_tratio(x, t) ** 3) / (1 + tm_tratio(x, t) ** 3) ** 2

  tm_qtilde = lambda x, t: 9 / 20 * (tm_alpha(x, t) - 1) / jnp.sqrt(1 + tm_b * tm_alpha(x, t) * (tm_alpha(x, t) - 1)) + 2 * tm_p(x) / 3

  tm_f0 = lambda x: (1 + 10 * (70 * tm_y(x) / 27) + tm_beta * tm_y(x) ** 2) ** (1 / 10)

  tm_fx_SC = lambda x, t: (1 + 10 * (+(MU_GE + 50 * tm_p(x) / 729) * tm_p(x) + 146 * tm_qtilde(x, t) ** 2 / 2025 - 73 * tm_qtilde(x, t) / 405 * (3 / 5 * tm_tratio(x, t)) * (1 - tm_tratio(x, t)))) ** (1 / 10)

  tm_fx_DME = lambda x, t: 1 / tm_f0(x) ** 2 + 7 * tm_R(x, t) / (9 * tm_f0(x) ** 4)

  tm_f = lambda x, u, t: tm_w(x, t) * tm_fx_DME(x, t) + (1 - tm_w(x, t)) * tm_fx_SC(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, tm_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  tm_lambda = 0.6866

  tm_beta = 79.873

  tm_p = lambda x: (X2S * x) ** 2

  tm_alpha = lambda x, t: (t - x ** 2 / 8) / K_FACTOR_C

  tm_tratio = lambda x, t: jnp.minimum(1.0, x ** 2 / (8 * t))

  tm_b = 0.4

  tm_y = lambda x: (2 * tm_lambda - 1) ** 2 * tm_p(x)

  tm_R = lambda x, t: 1 + 595 * (2 * tm_lambda - 1) ** 2 * tm_p(x) / 54 - (t - 3 * (tm_lambda ** 2 - tm_lambda + 1 / 2) * (t - K_FACTOR_C - x ** 2 / 72)) / K_FACTOR_C

  tm_w = lambda x, t: (tm_tratio(x, t) ** 2 + 3 * tm_tratio(x, t) ** 3) / (1 + tm_tratio(x, t) ** 3) ** 2

  tm_qtilde = lambda x, t: 9 / 20 * (tm_alpha(x, t) - 1) / jnp.sqrt(1 + tm_b * tm_alpha(x, t) * (tm_alpha(x, t) - 1)) + 2 * tm_p(x) / 3

  tm_f0 = lambda x: (1 + 10 * (70 * tm_y(x) / 27) + tm_beta * tm_y(x) ** 2) ** (1 / 10)

  tm_fx_SC = lambda x, t: (1 + 10 * (+(MU_GE + 50 * tm_p(x) / 729) * tm_p(x) + 146 * tm_qtilde(x, t) ** 2 / 2025 - 73 * tm_qtilde(x, t) / 405 * (3 / 5 * tm_tratio(x, t)) * (1 - tm_tratio(x, t)))) ** (1 / 10)

  tm_fx_DME = lambda x, t: 1 / tm_f0(x) ** 2 + 7 * tm_R(x, t) / (9 * tm_f0(x) ** 4)

  tm_f = lambda x, u, t: tm_w(x, t) * tm_fx_DME(x, t) + (1 - tm_w(x, t)) * tm_fx_SC(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, tm_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = 0.1e1 / r0
  t29 = s0 * t28
  t30 = 0.1e1 / tau0
  t32 = t29 * t30 / 0.8e1
  t33 = t32 < 0.10e1
  t34 = f.my_piecewise3(t33, t32, 0.10e1)
  t35 = t34 ** 2
  t36 = t35 * t34
  t38 = t35 + 0.3e1 * t36
  t39 = 0.1e1 + t36
  t40 = t39 ** 2
  t41 = 0.1e1 / t40
  t42 = t38 * t41
  t43 = 6 ** (0.1e1 / 0.3e1)
  t44 = jnp.pi ** 2
  t45 = t44 ** (0.1e1 / 0.3e1)
  t46 = t45 ** 2
  t47 = 0.1e1 / t46
  t48 = t43 * t47
  t49 = r0 ** 2
  t50 = r0 ** (0.1e1 / 0.3e1)
  t51 = t50 ** 2
  t53 = 0.1e1 / t51 / t49
  t54 = s0 * t53
  t55 = t48 * t54
  t57 = t43 ** 2
  t59 = 0.1e1 / t45 / t44
  t60 = t57 * t59
  t61 = s0 ** 2
  t62 = t49 ** 2
  t65 = 0.1e1 / t50 / t62 / r0
  t69 = 0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t55 + 0.26899490462262948000000000000000000000000000000000e-2 * t60 * t61 * t65
  t70 = t69 ** (0.1e1 / 0.5e1)
  t74 = 0.1e1 / t51 / r0
  t75 = tau0 * t74
  t78 = 0.25633760400000000000000000000000000000000000000000e0 * t57 * t46
  t84 = 0.7e1 + 0.44760329444444444444444444444444444444444444444445e0 * t55 - 0.35e2 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t75 + t78 + 0.11867481666666666666666666666666666666666666666667e-1 * t54) * t43 * t47
  t85 = t70 ** 2
  t86 = 0.1e1 / t85
  t89 = 0.1e1 / t70 + t84 * t86 / 0.9e1
  t91 = 0.1e1 - t42
  t94 = (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t55) * t43
  t95 = t47 * s0
  t100 = t75 - t54 / 0.8e1
  t101 = t100 * t43
  t102 = t101 * t47
  t104 = t102 / 0.4e1 - 0.9e1 / 0.20e2
  t107 = t47 * (0.5e1 / 0.9e1 * t102 - 0.1e1)
  t110 = 0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t101 * t107
  t111 = jnp.sqrt(t110)
  t112 = 0.1e1 / t111
  t113 = t104 * t112
  t115 = t113 + t55 / 0.36e2
  t116 = t115 ** 2
  t120 = 0.73e2 / 0.405e3 * t113 + 0.73e2 / 0.14580e5 * t55
  t121 = t120 * t34
  t122 = 0.1e1 - t34
  t126 = (0.1e1 + 0.5e1 / 0.12e2 * t94 * t95 * t53 + 0.292e3 / 0.405e3 * t116 - 0.6e1 * t121 * t122) ** (0.1e1 / 0.10e2)
  t128 = t91 * t126 + t42 * t89
  t132 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t128)
  t133 = r1 <= f.p.dens_threshold
  t134 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t135 = 0.1e1 + t134
  t136 = t135 <= f.p.zeta_threshold
  t137 = t135 ** (0.1e1 / 0.3e1)
  t139 = f.my_piecewise3(t136, t22, t137 * t135)
  t140 = t139 * t26
  t141 = 0.1e1 / r1
  t142 = s2 * t141
  t143 = 0.1e1 / tau1
  t145 = t142 * t143 / 0.8e1
  t146 = t145 < 0.10e1
  t147 = f.my_piecewise3(t146, t145, 0.10e1)
  t148 = t147 ** 2
  t149 = t148 * t147
  t151 = t148 + 0.3e1 * t149
  t152 = 0.1e1 + t149
  t153 = t152 ** 2
  t154 = 0.1e1 / t153
  t155 = t151 * t154
  t156 = r1 ** 2
  t157 = r1 ** (0.1e1 / 0.3e1)
  t158 = t157 ** 2
  t160 = 0.1e1 / t158 / t156
  t161 = s2 * t160
  t162 = t48 * t161
  t164 = s2 ** 2
  t165 = t156 ** 2
  t168 = 0.1e1 / t157 / t165 / r1
  t172 = 0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t162 + 0.26899490462262948000000000000000000000000000000000e-2 * t60 * t164 * t168
  t173 = t172 ** (0.1e1 / 0.5e1)
  t177 = 0.1e1 / t158 / r1
  t178 = tau1 * t177
  t185 = 0.7e1 + 0.44760329444444444444444444444444444444444444444445e0 * t162 - 0.35e2 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t178 + t78 + 0.11867481666666666666666666666666666666666666666667e-1 * t161) * t43 * t47
  t186 = t173 ** 2
  t187 = 0.1e1 / t186
  t190 = 0.1e1 / t173 + t185 * t187 / 0.9e1
  t192 = 0.1e1 - t155
  t195 = (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t162) * t43
  t196 = t47 * s2
  t201 = t178 - t161 / 0.8e1
  t202 = t201 * t43
  t203 = t202 * t47
  t205 = t203 / 0.4e1 - 0.9e1 / 0.20e2
  t208 = t47 * (0.5e1 / 0.9e1 * t203 - 0.1e1)
  t211 = 0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t202 * t208
  t212 = jnp.sqrt(t211)
  t213 = 0.1e1 / t212
  t214 = t205 * t213
  t216 = t214 + t162 / 0.36e2
  t217 = t216 ** 2
  t221 = 0.73e2 / 0.405e3 * t214 + 0.73e2 / 0.14580e5 * t162
  t222 = t221 * t147
  t223 = 0.1e1 - t147
  t227 = (0.1e1 + 0.5e1 / 0.12e2 * t195 * t196 * t160 + 0.292e3 / 0.405e3 * t217 - 0.6e1 * t222 * t223) ** (0.1e1 / 0.10e2)
  t229 = t155 * t190 + t192 * t227
  t233 = f.my_piecewise3(t133, 0, -0.3e1 / 0.8e1 * t5 * t140 * t229)
  t234 = t6 ** 2
  t236 = t16 / t234
  t237 = t7 - t236
  t238 = f.my_piecewise5(t10, 0, t14, 0, t237)
  t241 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t238)
  t246 = t26 ** 2
  t247 = 0.1e1 / t246
  t251 = t5 * t25 * t247 * t128 / 0.8e1
  t256 = f.my_piecewise3(t33, -s0 / t49 * t30 / 0.8e1, 0)
  t259 = t35 * t256
  t262 = (0.2e1 * t34 * t256 + 0.9e1 * t259) * t41
  t266 = t38 / t40 / t39
  t267 = t89 * t35
  t272 = 0.1e1 / t70 / t69
  t275 = 0.1e1 / t51 / t49 / r0
  t276 = s0 * t275
  t277 = t48 * t276
  t283 = t60 * t61 / t50 / t62 / t49
  t285 = -0.40121303703703703703703703703703703703703703703704e0 * t277 - 0.14346394913206905600000000000000000000000000000000e-1 * t283
  t289 = tau0 * t53
  t301 = t84 / t85 / t69
  t310 = t126 ** 2
  t311 = t310 ** 2
  t312 = t311 ** 2
  t315 = t91 / t312 / t126
  t322 = -0.5e1 / 0.3e1 * t289 + t276 / 0.3e1
  t323 = t322 * t43
  t324 = t47 * t112
  t325 = t323 * t324
  t329 = t104 / t111 / t110
  t332 = t100 * t57
  t337 = t329 * (0.22222222222222222222222222222222222222222222222222e0 * t323 * t107 + 0.12345679012345679012345679012345679012345679012346e0 * t332 * t59 * t322)
  t363 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t241 * t26 * t128 - t251 - 0.3e1 / 0.8e1 * t5 * t27 * (t262 * t89 - 0.6e1 * t266 * t267 * t256 + t42 * (-t272 * t285 / 0.5e1 + (-0.11936087851851851851851851851851851851851851851852e1 * t277 - 0.35e2 / 0.9e1 * (-0.24256886666666666666666666666666666666666666666667e0 * t289 - 0.31646617777777777777777777777777777777777777777779e-1 * t276) * t43 * t47) * t86 / 0.9e1 - 0.2e1 / 0.45e2 * t301 * t285) + (0.6e1 * t266 * t259 - t262) * t126 + t315 * (-0.125e3 / 0.39366e5 * t283 - 0.10e2 / 0.9e1 * t94 * t95 * t275 + 0.584e3 / 0.405e3 * t115 * (t325 / 0.4e1 - t337 / 0.2e1 - 0.2e1 / 0.27e2 * t277) - 0.6e1 * (0.73e2 / 0.1620e4 * t325 - 0.73e2 / 0.810e3 * t337 - 0.146e3 / 0.10935e5 * t277) * t34 * t122 - 0.6e1 * t120 * t256 * t122 + 0.6e1 * t121 * t256) / 0.10e2))
  t365 = f.my_piecewise5(t14, 0, t10, 0, -t237)
  t368 = f.my_piecewise3(t136, 0, 0.4e1 / 0.3e1 * t137 * t365)
  t376 = t5 * t139 * t247 * t229 / 0.8e1
  t378 = f.my_piecewise3(t133, 0, -0.3e1 / 0.8e1 * t5 * t368 * t26 * t229 - t376)
  vrho_0_ = t132 + t233 + t6 * (t363 + t378)
  t381 = -t7 - t236
  t382 = f.my_piecewise5(t10, 0, t14, 0, t381)
  t385 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t382)
  t391 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t385 * t26 * t128 - t251)
  t393 = f.my_piecewise5(t14, 0, t10, 0, -t381)
  t396 = f.my_piecewise3(t136, 0, 0.4e1 / 0.3e1 * t137 * t393)
  t405 = f.my_piecewise3(t146, -s2 / t156 * t143 / 0.8e1, 0)
  t408 = t148 * t405
  t411 = (0.2e1 * t147 * t405 + 0.9e1 * t408) * t154
  t415 = t151 / t153 / t152
  t416 = t190 * t148
  t421 = 0.1e1 / t173 / t172
  t424 = 0.1e1 / t158 / t156 / r1
  t425 = s2 * t424
  t426 = t48 * t425
  t432 = t60 * t164 / t157 / t165 / t156
  t434 = -0.40121303703703703703703703703703703703703703703704e0 * t426 - 0.14346394913206905600000000000000000000000000000000e-1 * t432
  t438 = tau1 * t160
  t450 = t185 / t186 / t172
  t459 = t227 ** 2
  t460 = t459 ** 2
  t461 = t460 ** 2
  t464 = t192 / t461 / t227
  t471 = -0.5e1 / 0.3e1 * t438 + t425 / 0.3e1
  t472 = t471 * t43
  t473 = t47 * t213
  t474 = t472 * t473
  t478 = t205 / t212 / t211
  t481 = t201 * t57
  t486 = t478 * (0.22222222222222222222222222222222222222222222222222e0 * t472 * t208 + 0.12345679012345679012345679012345679012345679012346e0 * t481 * t59 * t471)
  t512 = f.my_piecewise3(t133, 0, -0.3e1 / 0.8e1 * t5 * t396 * t26 * t229 - t376 - 0.3e1 / 0.8e1 * t5 * t140 * (t411 * t190 - 0.6e1 * t415 * t416 * t405 + t155 * (-t421 * t434 / 0.5e1 + (-0.11936087851851851851851851851851851851851851851852e1 * t426 - 0.35e2 / 0.9e1 * (-0.24256886666666666666666666666666666666666666666667e0 * t438 - 0.31646617777777777777777777777777777777777777777779e-1 * t425) * t43 * t47) * t187 / 0.9e1 - 0.2e1 / 0.45e2 * t450 * t434) + (0.6e1 * t415 * t408 - t411) * t227 + t464 * (-0.125e3 / 0.39366e5 * t432 - 0.10e2 / 0.9e1 * t195 * t196 * t424 + 0.584e3 / 0.405e3 * t216 * (t474 / 0.4e1 - t486 / 0.2e1 - 0.2e1 / 0.27e2 * t426) - 0.6e1 * (0.73e2 / 0.1620e4 * t474 - 0.73e2 / 0.810e3 * t486 - 0.146e3 / 0.10935e5 * t426) * t147 * t223 - 0.6e1 * t221 * t405 * t223 + 0.6e1 * t222 * t405) / 0.10e2))
  vrho_1_ = t132 + t233 + t6 * (t391 + t512)
  t517 = f.my_piecewise3(t33, t28 * t30 / 0.8e1, 0)
  t520 = t35 * t517
  t523 = (0.2e1 * t34 * t517 + 0.9e1 * t520) * t41
  t528 = t48 * t53
  t531 = t60 * s0 * t65
  t533 = 0.15045488888888888888888888888888888888888888888889e0 * t528 + 0.53798980924525896000000000000000000000000000000000e-2 * t531
  t552 = t48 * t53 * t112
  t561 = t329 * (-0.27777777777777777777777777777777777777777777777778e-1 * t53 * t43 * t107 - 0.15432098765432098765432098765432098765432098765432e-1 * t332 * t59 * t53)
  t586 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (t523 * t89 - 0.6e1 * t266 * t267 * t517 + t42 * (-t272 * t533 / 0.5e1 + 0.44605775205761316872427983539094650205761316872429e-1 * t48 * t53 * t86 - 0.2e1 / 0.45e2 * t301 * t533) + (0.6e1 * t266 * t520 - t523) * t126 + t315 * (0.125e3 / 0.104976e6 * t531 + 0.5e1 / 0.12e2 * t94 * t47 * t53 + 0.584e3 / 0.405e3 * t115 * (-t552 / 0.32e2 - t561 / 0.2e1 + t528 / 0.36e2) - 0.6e1 * (-0.73e2 / 0.12960e5 * t552 - 0.73e2 / 0.810e3 * t561 + 0.73e2 / 0.14580e5 * t528) * t34 * t122 - 0.6e1 * t120 * t517 * t122 + 0.6e1 * t121 * t517) / 0.10e2))
  vsigma_0_ = t6 * t586
  vsigma_1_ = 0.0e0
  t589 = f.my_piecewise3(t146, t141 * t143 / 0.8e1, 0)
  t592 = t148 * t589
  t595 = (0.2e1 * t147 * t589 + 0.9e1 * t592) * t154
  t600 = t48 * t160
  t603 = t60 * s2 * t168
  t605 = 0.15045488888888888888888888888888888888888888888889e0 * t600 + 0.53798980924525896000000000000000000000000000000000e-2 * t603
  t624 = t48 * t160 * t213
  t633 = t478 * (-0.27777777777777777777777777777777777777777777777778e-1 * t160 * t43 * t208 - 0.15432098765432098765432098765432098765432098765432e-1 * t481 * t59 * t160)
  t658 = f.my_piecewise3(t133, 0, -0.3e1 / 0.8e1 * t5 * t140 * (t595 * t190 - 0.6e1 * t415 * t416 * t589 + t155 * (-t421 * t605 / 0.5e1 + 0.44605775205761316872427983539094650205761316872429e-1 * t48 * t160 * t187 - 0.2e1 / 0.45e2 * t450 * t605) + (0.6e1 * t415 * t592 - t595) * t227 + t464 * (0.125e3 / 0.104976e6 * t603 + 0.5e1 / 0.12e2 * t195 * t47 * t160 + 0.584e3 / 0.405e3 * t216 * (-t624 / 0.32e2 - t633 / 0.2e1 + t600 / 0.36e2) - 0.6e1 * (-0.73e2 / 0.12960e5 * t624 - 0.73e2 / 0.810e3 * t633 + 0.73e2 / 0.14580e5 * t600) * t147 * t223 - 0.6e1 * t221 * t589 * t223 + 0.6e1 * t222 * t589) / 0.10e2))
  vsigma_2_ = t6 * t658
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t659 = tau0 ** 2
  t663 = f.my_piecewise3(t33, -t29 / t659 / 0.8e1, 0)
  t666 = t35 * t663
  t669 = (0.2e1 * t34 * t663 + 0.9e1 * t666) * t41
  t682 = t74 * t43
  t683 = t682 * t324
  t691 = t329 * (0.22222222222222222222222222222222222222222222222222e0 * t682 * t107 + 0.12345679012345679012345679012345679012345679012346e0 * t332 * t59 * t74)
  t714 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (t669 * t89 - 0.6e1 * t266 * t267 * t663 - 0.62888224691358024691358024691358024691358024691358e-1 * t42 * t74 * t48 * t86 + (0.6e1 * t266 * t666 - t669) * t126 + t315 * (0.584e3 / 0.405e3 * t115 * (t683 / 0.4e1 - t691 / 0.2e1) - 0.6e1 * (0.73e2 / 0.1620e4 * t683 - 0.73e2 / 0.810e3 * t691) * t34 * t122 - 0.6e1 * t120 * t663 * t122 + 0.6e1 * t121 * t663) / 0.10e2))
  vtau_0_ = t6 * t714
  t715 = tau1 ** 2
  t719 = f.my_piecewise3(t146, -t142 / t715 / 0.8e1, 0)
  t722 = t148 * t719
  t725 = (0.2e1 * t147 * t719 + 0.9e1 * t722) * t154
  t738 = t177 * t43
  t739 = t738 * t473
  t747 = t478 * (0.22222222222222222222222222222222222222222222222222e0 * t738 * t208 + 0.12345679012345679012345679012345679012345679012346e0 * t481 * t59 * t177)
  t770 = f.my_piecewise3(t133, 0, -0.3e1 / 0.8e1 * t5 * t140 * (t725 * t190 - 0.6e1 * t415 * t416 * t719 - 0.62888224691358024691358024691358024691358024691358e-1 * t155 * t177 * t48 * t187 + (0.6e1 * t415 * t722 - t725) * t227 + t464 * (0.584e3 / 0.405e3 * t216 * (t739 / 0.4e1 - t747 / 0.2e1) - 0.6e1 * (0.73e2 / 0.1620e4 * t739 - 0.73e2 / 0.810e3 * t747) * t147 * t223 - 0.6e1 * t221 * t719 * t223 + 0.6e1 * t222 * t719) / 0.10e2))
  vtau_1_ = t6 * t770
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  tm_lambda = 0.6866

  tm_beta = 79.873

  tm_p = lambda x: (X2S * x) ** 2

  tm_alpha = lambda x, t: (t - x ** 2 / 8) / K_FACTOR_C

  tm_tratio = lambda x, t: jnp.minimum(1.0, x ** 2 / (8 * t))

  tm_b = 0.4

  tm_y = lambda x: (2 * tm_lambda - 1) ** 2 * tm_p(x)

  tm_R = lambda x, t: 1 + 595 * (2 * tm_lambda - 1) ** 2 * tm_p(x) / 54 - (t - 3 * (tm_lambda ** 2 - tm_lambda + 1 / 2) * (t - K_FACTOR_C - x ** 2 / 72)) / K_FACTOR_C

  tm_w = lambda x, t: (tm_tratio(x, t) ** 2 + 3 * tm_tratio(x, t) ** 3) / (1 + tm_tratio(x, t) ** 3) ** 2

  tm_qtilde = lambda x, t: 9 / 20 * (tm_alpha(x, t) - 1) / jnp.sqrt(1 + tm_b * tm_alpha(x, t) * (tm_alpha(x, t) - 1)) + 2 * tm_p(x) / 3

  tm_f0 = lambda x: (1 + 10 * (70 * tm_y(x) / 27) + tm_beta * tm_y(x) ** 2) ** (1 / 10)

  tm_fx_SC = lambda x, t: (1 + 10 * (+(MU_GE + 50 * tm_p(x) / 729) * tm_p(x) + 146 * tm_qtilde(x, t) ** 2 / 2025 - 73 * tm_qtilde(x, t) / 405 * (3 / 5 * tm_tratio(x, t)) * (1 - tm_tratio(x, t)))) ** (1 / 10)

  tm_fx_DME = lambda x, t: 1 / tm_f0(x) ** 2 + 7 * tm_R(x, t) / (9 * tm_f0(x) ** 4)

  tm_f = lambda x, u, t: tm_w(x, t) * tm_fx_DME(x, t) + (1 - tm_w(x, t)) * tm_fx_SC(x, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, tm_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = 0.1e1 / r0
  t21 = s0 * t20
  t22 = 0.1e1 / tau0
  t24 = t21 * t22 / 0.8e1
  t25 = t24 < 0.10e1
  t26 = f.my_piecewise3(t25, t24, 0.10e1)
  t27 = t26 ** 2
  t28 = t27 * t26
  t30 = t27 + 0.3e1 * t28
  t31 = 0.1e1 + t28
  t32 = t31 ** 2
  t33 = 0.1e1 / t32
  t34 = t30 * t33
  t35 = 6 ** (0.1e1 / 0.3e1)
  t36 = jnp.pi ** 2
  t37 = t36 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t39 = 0.1e1 / t38
  t40 = t35 * t39
  t41 = 2 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t43 = s0 * t42
  t44 = r0 ** 2
  t45 = t18 ** 2
  t47 = 0.1e1 / t45 / t44
  t48 = t43 * t47
  t49 = t40 * t48
  t51 = t35 ** 2
  t53 = 0.1e1 / t37 / t36
  t54 = t51 * t53
  t55 = s0 ** 2
  t56 = t55 * t41
  t57 = t44 ** 2
  t60 = 0.1e1 / t18 / t57 / r0
  t64 = 0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t49 + 0.53798980924525896000000000000000000000000000000000e-2 * t54 * t56 * t60
  t65 = t64 ** (0.1e1 / 0.5e1)
  t68 = tau0 * t42
  t70 = 0.1e1 / t45 / r0
  t71 = t68 * t70
  t80 = 0.7e1 + 0.44760329444444444444444444444444444444444444444445e0 * t49 - 0.35e2 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t71 + 0.25633760400000000000000000000000000000000000000000e0 * t51 * t38 + 0.11867481666666666666666666666666666666666666666667e-1 * t48) * t35 * t39
  t81 = t65 ** 2
  t82 = 0.1e1 / t81
  t85 = 0.1e1 / t65 + t80 * t82 / 0.9e1
  t87 = 0.1e1 - t34
  t90 = (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t49) * t35
  t91 = t90 * t39
  t95 = t71 - t48 / 0.8e1
  t96 = t95 * t35
  t97 = t96 * t39
  t99 = t97 / 0.4e1 - 0.9e1 / 0.20e2
  t101 = 0.5e1 / 0.9e1 * t97 - 0.1e1
  t102 = t39 * t101
  t105 = 0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t96 * t102
  t106 = jnp.sqrt(t105)
  t107 = 0.1e1 / t106
  t108 = t99 * t107
  t110 = t108 + t49 / 0.36e2
  t111 = t110 ** 2
  t115 = 0.73e2 / 0.405e3 * t108 + 0.73e2 / 0.14580e5 * t49
  t116 = t115 * t26
  t117 = 0.1e1 - t26
  t121 = (0.1e1 + 0.5e1 / 0.12e2 * t91 * t48 + 0.292e3 / 0.405e3 * t111 - 0.6e1 * t116 * t117) ** (0.1e1 / 0.10e2)
  t123 = t87 * t121 + t34 * t85
  t127 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t123)
  t137 = f.my_piecewise3(t25, -s0 / t44 * t22 / 0.8e1, 0)
  t140 = t27 * t137
  t143 = (0.2e1 * t26 * t137 + 0.9e1 * t140) * t33
  t147 = t30 / t32 / t31
  t148 = t85 * t27
  t153 = 0.1e1 / t65 / t64
  t157 = t43 / t45 / t44 / r0
  t158 = t40 * t157
  t164 = t54 * t56 / t18 / t57 / t44
  t166 = -0.40121303703703703703703703703703703703703703703704e0 * t158 - 0.28692789826413811200000000000000000000000000000000e-1 * t164
  t170 = t68 * t47
  t182 = t80 / t81 / t64
  t191 = t121 ** 2
  t192 = t191 ** 2
  t193 = t192 ** 2
  t196 = t87 / t193 / t121
  t202 = -0.5e1 / 0.3e1 * t170 + t157 / 0.3e1
  t203 = t202 * t35
  t205 = t203 * t39 * t107
  t209 = t99 / t106 / t105
  t212 = t95 * t51
  t217 = t209 * (0.22222222222222222222222222222222222222222222222222e0 * t203 * t102 + 0.12345679012345679012345679012345679012345679012346e0 * t212 * t53 * t202)
  t243 = f.my_piecewise3(t2, 0, -t6 * t17 / t45 * t123 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (t143 * t85 - 0.6e1 * t147 * t148 * t137 + t34 * (-t153 * t166 / 0.5e1 + (-0.11936087851851851851851851851851851851851851851852e1 * t158 - 0.35e2 / 0.9e1 * (-0.24256886666666666666666666666666666666666666666667e0 * t170 - 0.31646617777777777777777777777777777777777777777779e-1 * t157) * t35 * t39) * t82 / 0.9e1 - 0.2e1 / 0.45e2 * t182 * t166) + (0.6e1 * t147 * t140 - t143) * t121 + t196 * (-0.125e3 / 0.19683e5 * t164 - 0.10e2 / 0.9e1 * t91 * t157 + 0.584e3 / 0.405e3 * t110 * (t205 / 0.4e1 - t217 / 0.2e1 - 0.2e1 / 0.27e2 * t158) - 0.6e1 * (0.73e2 / 0.1620e4 * t205 - 0.73e2 / 0.810e3 * t217 - 0.146e3 / 0.10935e5 * t158) * t26 * t117 - 0.6e1 * t115 * t137 * t117 + 0.6e1 * t116 * t137) / 0.10e2))
  vrho_0_ = 0.2e1 * r0 * t243 + 0.2e1 * t127
  t248 = f.my_piecewise3(t25, t20 * t22 / 0.8e1, 0)
  t251 = t27 * t248
  t254 = (0.2e1 * t26 * t248 + 0.9e1 * t251) * t33
  t259 = t42 * t47
  t260 = t40 * t259
  t264 = t54 * s0 * t41 * t60
  t266 = 0.15045488888888888888888888888888888888888888888889e0 * t260 + 0.10759796184905179200000000000000000000000000000000e-1 * t264
  t286 = t40 * t259 * t107
  t288 = t40 * t101
  t291 = t53 * t42
  t296 = t209 * (-0.27777777777777777777777777777777777777777777777778e-1 * t259 * t288 - 0.15432098765432098765432098765432098765432098765432e-1 * t212 * t291 * t47)
  t321 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t254 * t85 - 0.6e1 * t147 * t148 * t248 + t34 * (-t153 * t266 / 0.5e1 + 0.44605775205761316872427983539094650205761316872429e-1 * t40 * t259 * t82 - 0.2e1 / 0.45e2 * t182 * t266) + (0.6e1 * t147 * t251 - t254) * t121 + t196 * (0.125e3 / 0.52488e5 * t264 + 0.5e1 / 0.12e2 * t90 * t39 * t42 * t47 + 0.584e3 / 0.405e3 * t110 * (-t286 / 0.32e2 - t296 / 0.2e1 + t260 / 0.36e2) - 0.6e1 * (-0.73e2 / 0.12960e5 * t286 - 0.73e2 / 0.810e3 * t296 + 0.73e2 / 0.14580e5 * t260) * t26 * t117 - 0.6e1 * t115 * t248 * t117 + 0.6e1 * t116 * t248) / 0.10e2))
  vsigma_0_ = 0.2e1 * r0 * t321
  vlapl_0_ = 0.0e0
  t323 = tau0 ** 2
  t327 = f.my_piecewise3(t25, -t21 / t323 / 0.8e1, 0)
  t330 = t27 * t327
  t333 = (0.2e1 * t26 * t327 + 0.9e1 * t330) * t33
  t348 = t42 * t70
  t350 = t348 * t40 * t107
  t358 = t209 * (0.22222222222222222222222222222222222222222222222222e0 * t348 * t288 + 0.12345679012345679012345679012345679012345679012346e0 * t212 * t291 * t70)
  t381 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (t333 * t85 - 0.6e1 * t147 * t148 * t327 - 0.62888224691358024691358024691358024691358024691358e-1 * t34 * t42 * t70 * t35 * t39 * t82 + (0.6e1 * t147 * t330 - t333) * t121 + t196 * (0.584e3 / 0.405e3 * t110 * (t350 / 0.4e1 - t358 / 0.2e1) - 0.6e1 * (0.73e2 / 0.1620e4 * t350 - 0.73e2 / 0.810e3 * t358) * t26 * t117 - 0.6e1 * t115 * t327 * t117 + 0.6e1 * t116 * t327) / 0.10e2))
  vtau_0_ = 0.2e1 * r0 * t381
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t24 = 0.1e1 / tau0
  t26 = s0 / r0 * t24 / 0.8e1
  t27 = t26 < 0.10e1
  t28 = f.my_piecewise3(t27, t26, 0.10e1)
  t29 = t28 ** 2
  t30 = t29 * t28
  t32 = t29 + 0.3e1 * t30
  t33 = 0.1e1 + t30
  t34 = t33 ** 2
  t35 = 0.1e1 / t34
  t36 = t32 * t35
  t37 = 6 ** (0.1e1 / 0.3e1)
  t38 = jnp.pi ** 2
  t39 = t38 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t41 = 0.1e1 / t40
  t42 = t37 * t41
  t43 = 2 ** (0.1e1 / 0.3e1)
  t44 = t43 ** 2
  t45 = s0 * t44
  t46 = r0 ** 2
  t48 = 0.1e1 / t19 / t46
  t49 = t45 * t48
  t50 = t42 * t49
  t52 = t37 ** 2
  t54 = 0.1e1 / t39 / t38
  t55 = t52 * t54
  t56 = s0 ** 2
  t57 = t56 * t43
  t58 = t46 ** 2
  t65 = 0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t50 + 0.53798980924525896000000000000000000000000000000000e-2 * t55 * t57 / t18 / t58 / r0
  t66 = t65 ** (0.1e1 / 0.5e1)
  t69 = tau0 * t44
  t71 = 0.1e1 / t19 / r0
  t72 = t69 * t71
  t81 = 0.1e1 + 0.63943327777777777777777777777777777777777777777778e-1 * t50 - 0.5e1 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t72 + 0.25633760400000000000000000000000000000000000000000e0 * t52 * t40 + 0.11867481666666666666666666666666666666666666666667e-1 * t49) * t37 * t41
  t82 = t66 ** 2
  t83 = 0.1e1 / t82
  t86 = 0.1e1 / t66 + 0.7e1 / 0.9e1 * t81 * t83
  t88 = 0.1e1 - t36
  t92 = (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t50) * t37 * t41
  t96 = t72 - t49 / 0.8e1
  t97 = t96 * t37
  t100 = 0.5e1 / 0.9e1 * t97 * t41 - 0.1e1
  t101 = t41 * t100
  t104 = 0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t97 * t101
  t105 = jnp.sqrt(t104)
  t106 = 0.1e1 / t105
  t110 = 0.9e1 / 0.20e2 * t100 * t106 + t50 / 0.36e2
  t111 = t110 ** 2
  t113 = t110 * t28
  t114 = 0.1e1 - t28
  t117 = 0.1e1 + 0.5e1 / 0.12e2 * t92 * t49 + 0.292e3 / 0.405e3 * t111 - 0.146e3 / 0.135e3 * t113 * t114
  t118 = t117 ** (0.1e1 / 0.10e2)
  t120 = t88 * t118 + t36 * t86
  t124 = t17 * t18
  t129 = f.my_piecewise3(t27, -s0 / t46 * t24 / 0.8e1, 0)
  t132 = t29 * t129
  t134 = 0.2e1 * t28 * t129 + 0.9e1 * t132
  t135 = t134 * t35
  t138 = 0.1e1 / t34 / t33
  t139 = t32 * t138
  t140 = t86 * t29
  t141 = t140 * t129
  t145 = 0.1e1 / t66 / t65
  t146 = t46 * r0
  t148 = 0.1e1 / t19 / t146
  t149 = t45 * t148
  t150 = t42 * t149
  t156 = t55 * t57 / t18 / t58 / t46
  t158 = -0.40121303703703703703703703703703703703703703703704e0 * t150 - 0.28692789826413811200000000000000000000000000000000e-1 * t156
  t162 = t69 * t48
  t169 = -0.17051554074074074074074074074074074074074074074074e0 * t150 - 0.5e1 / 0.9e1 * (-0.24256886666666666666666666666666666666666666666667e0 * t162 - 0.31646617777777777777777777777777777777777777777779e-1 * t149) * t37 * t41
  t173 = 0.1e1 / t82 / t65
  t174 = t81 * t173
  t177 = -t145 * t158 / 0.5e1 + 0.7e1 / 0.9e1 * t169 * t83 - 0.14e2 / 0.45e2 * t174 * t158
  t181 = 0.6e1 * t139 * t132 - t135
  t183 = t118 ** 2
  t184 = t183 ** 2
  t185 = t184 ** 2
  t186 = t185 * t118
  t187 = 0.1e1 / t186
  t188 = t88 * t187
  t194 = -0.5e1 / 0.3e1 * t162 + t149 / 0.3e1
  t195 = t194 * t37
  t196 = t41 * t106
  t200 = 0.1e1 / t105 / t104
  t201 = t100 * t200
  t204 = t96 * t52
  t208 = 0.22222222222222222222222222222222222222222222222222e0 * t195 * t101 + 0.12345679012345679012345679012345679012345679012346e0 * t204 * t54 * t194
  t212 = t195 * t196 / 0.4e1 - 0.9e1 / 0.40e2 * t201 * t208 - 0.2e1 / 0.27e2 * t150
  t215 = t212 * t28
  t223 = -0.125e3 / 0.19683e5 * t156 - 0.10e2 / 0.9e1 * t92 * t149 + 0.584e3 / 0.405e3 * t110 * t212 - 0.146e3 / 0.135e3 * t215 * t114 - 0.146e3 / 0.135e3 * t110 * t129 * t114 + 0.146e3 / 0.135e3 * t113 * t129
  t226 = t135 * t86 - 0.6e1 * t139 * t141 + t36 * t177 + t181 * t118 + t188 * t223 / 0.10e2
  t231 = f.my_piecewise3(t2, 0, -t6 * t21 * t120 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t124 * t226)
  t240 = t129 ** 2
  t246 = f.my_piecewise3(t27, s0 / t146 * t24 / 0.4e1, 0)
  t249 = t28 * t240
  t251 = t29 * t246
  t254 = (0.2e1 * t28 * t246 + 0.2e1 * t240 + 0.18e2 * t249 + 0.9e1 * t251) * t35
  t256 = t134 * t138
  t261 = t34 ** 2
  t263 = t32 / t261
  t264 = t29 ** 2
  t280 = t65 ** 2
  t283 = t158 ** 2
  t288 = t45 / t19 / t58
  t289 = t42 * t288
  t295 = t55 * t57 / t18 / t58 / t146
  t297 = 0.14711144691358024691358024691358024691358024691358e1 * t289 + 0.18172100223395413760000000000000000000000000000000e0 * t295
  t301 = t69 * t148
  t340 = t223 ** 2
  t346 = t212 ** 2
  t350 = 0.40e2 / 0.9e1 * t301 - 0.11e2 / 0.9e1 * t288
  t351 = t350 * t37
  t358 = t104 ** 2
  t362 = t208 ** 2
  t367 = t194 ** 2
  t378 = t351 * t196 / 0.4e1 - t195 * t41 * t200 * t208 / 0.4e1 + 0.27e2 / 0.80e2 * t100 / t105 / t358 * t362 - 0.9e1 / 0.40e2 * t201 * (0.22222222222222222222222222222222222222222222222222e0 * t351 * t101 + 0.24691358024691358024691358024691358024691358024692e0 * t367 * t52 * t54 + 0.12345679012345679012345679012345679012345679012346e0 * t204 * t54 * t350) + 0.22e2 / 0.81e2 * t289
  t399 = t254 * t86 - 0.12e2 * t256 * t141 + 0.2e1 * t135 * t177 + 0.54e2 * t263 * t86 * t264 * t240 - 0.12e2 * t139 * t177 * t29 * t129 - 0.12e2 * t139 * t86 * t28 * t240 - 0.6e1 * t139 * t140 * t246 + t36 * (0.6e1 / 0.25e2 / t66 / t280 * t283 - t145 * t297 / 0.5e1 + 0.7e1 / 0.9e1 * (0.62522364938271604938271604938271604938271604938271e0 * t289 - 0.5e1 / 0.9e1 * (0.64685031111111111111111111111111111111111111111112e0 * t301 + 0.11603759851851851851851851851851851851851851851852e0 * t288) * t37 * t41) * t83 - 0.28e2 / 0.45e2 * t169 * t173 * t158 + 0.98e2 / 0.225e3 * t81 / t82 / t280 * t283 - 0.14e2 / 0.45e2 * t174 * t297) + (-0.54e2 * t263 * t264 * t240 + 0.12e2 * t256 * t132 + 0.12e2 * t139 * t249 + 0.6e1 * t139 * t251 - t254) * t118 + t181 * t187 * t223 / 0.5e1 - 0.9e1 / 0.100e3 * t88 / t186 / t117 * t340 + t188 * (0.125e3 / 0.2187e4 * t295 + 0.110e3 / 0.27e2 * t92 * t288 + 0.584e3 / 0.405e3 * t346 + 0.584e3 / 0.405e3 * t110 * t378 - 0.146e3 / 0.135e3 * t378 * t28 * t114 - 0.292e3 / 0.135e3 * t212 * t129 * t114 + 0.292e3 / 0.135e3 * t215 * t129 - 0.146e3 / 0.135e3 * t110 * t246 * t114 + 0.292e3 / 0.135e3 * t110 * t240 + 0.146e3 / 0.135e3 * t113 * t246) / 0.10e2
  t404 = f.my_piecewise3(t2, 0, t6 * t17 * t71 * t120 / 0.12e2 - t6 * t21 * t226 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t124 * t399)
  v2rho2_0_ = 0.2e1 * r0 * t404 + 0.4e1 * t231
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = 0.1e1 / t19 / r0
  t22 = t17 * t21
  t25 = 0.1e1 / tau0
  t27 = s0 / r0 * t25 / 0.8e1
  t28 = t27 < 0.10e1
  t29 = f.my_piecewise3(t28, t27, 0.10e1)
  t30 = t29 ** 2
  t31 = t30 * t29
  t33 = t30 + 0.3e1 * t31
  t34 = 0.1e1 + t31
  t35 = t34 ** 2
  t36 = 0.1e1 / t35
  t37 = t33 * t36
  t38 = 6 ** (0.1e1 / 0.3e1)
  t39 = jnp.pi ** 2
  t40 = t39 ** (0.1e1 / 0.3e1)
  t41 = t40 ** 2
  t42 = 0.1e1 / t41
  t43 = t38 * t42
  t44 = 2 ** (0.1e1 / 0.3e1)
  t45 = t44 ** 2
  t46 = s0 * t45
  t47 = r0 ** 2
  t49 = 0.1e1 / t19 / t47
  t50 = t46 * t49
  t51 = t43 * t50
  t53 = t38 ** 2
  t55 = 0.1e1 / t40 / t39
  t56 = t53 * t55
  t57 = s0 ** 2
  t58 = t57 * t44
  t59 = t47 ** 2
  t60 = t59 * r0
  t66 = 0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t51 + 0.53798980924525896000000000000000000000000000000000e-2 * t56 * t58 / t18 / t60
  t67 = t66 ** (0.1e1 / 0.5e1)
  t70 = tau0 * t45
  t71 = t70 * t21
  t80 = 0.1e1 + 0.63943327777777777777777777777777777777777777777778e-1 * t51 - 0.5e1 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t71 + 0.25633760400000000000000000000000000000000000000000e0 * t53 * t41 + 0.11867481666666666666666666666666666666666666666667e-1 * t50) * t38 * t42
  t81 = t67 ** 2
  t82 = 0.1e1 / t81
  t85 = 0.1e1 / t67 + 0.7e1 / 0.9e1 * t80 * t82
  t87 = 0.1e1 - t37
  t91 = (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t51) * t38 * t42
  t95 = t71 - t50 / 0.8e1
  t96 = t95 * t38
  t99 = 0.5e1 / 0.9e1 * t96 * t42 - 0.1e1
  t100 = t42 * t99
  t103 = 0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t96 * t100
  t104 = jnp.sqrt(t103)
  t105 = 0.1e1 / t104
  t109 = 0.9e1 / 0.20e2 * t99 * t105 + t51 / 0.36e2
  t110 = t109 ** 2
  t112 = t109 * t29
  t113 = 0.1e1 - t29
  t116 = 0.1e1 + 0.5e1 / 0.12e2 * t91 * t50 + 0.292e3 / 0.405e3 * t110 - 0.146e3 / 0.135e3 * t112 * t113
  t117 = t116 ** (0.1e1 / 0.10e2)
  t119 = t87 * t117 + t37 * t85
  t124 = t17 / t19
  t129 = f.my_piecewise3(t28, -s0 / t47 * t25 / 0.8e1, 0)
  t130 = t29 * t129
  t132 = t30 * t129
  t134 = 0.2e1 * t130 + 0.9e1 * t132
  t135 = t134 * t36
  t138 = 0.1e1 / t35 / t34
  t139 = t33 * t138
  t140 = t85 * t30
  t141 = t140 * t129
  t145 = 0.1e1 / t67 / t66
  t146 = t47 * r0
  t148 = 0.1e1 / t19 / t146
  t149 = t46 * t148
  t150 = t43 * t149
  t156 = t56 * t58 / t18 / t59 / t47
  t158 = -0.40121303703703703703703703703703703703703703703704e0 * t150 - 0.28692789826413811200000000000000000000000000000000e-1 * t156
  t162 = t70 * t49
  t169 = -0.17051554074074074074074074074074074074074074074074e0 * t150 - 0.5e1 / 0.9e1 * (-0.24256886666666666666666666666666666666666666666667e0 * t162 - 0.31646617777777777777777777777777777777777777777779e-1 * t149) * t38 * t42
  t173 = 0.1e1 / t81 / t66
  t174 = t80 * t173
  t177 = -t145 * t158 / 0.5e1 + 0.7e1 / 0.9e1 * t169 * t82 - 0.14e2 / 0.45e2 * t174 * t158
  t181 = 0.6e1 * t139 * t132 - t135
  t183 = t117 ** 2
  t184 = t183 ** 2
  t185 = t184 ** 2
  t186 = t185 * t117
  t187 = 0.1e1 / t186
  t188 = t87 * t187
  t194 = -0.5e1 / 0.3e1 * t162 + t149 / 0.3e1
  t195 = t194 * t38
  t196 = t42 * t105
  t200 = 0.1e1 / t104 / t103
  t201 = t99 * t200
  t204 = t95 * t53
  t205 = t55 * t194
  t208 = 0.22222222222222222222222222222222222222222222222222e0 * t195 * t100 + 0.12345679012345679012345679012345679012345679012346e0 * t204 * t205
  t212 = t195 * t196 / 0.4e1 - 0.9e1 / 0.40e2 * t201 * t208 - 0.2e1 / 0.27e2 * t150
  t215 = t212 * t29
  t223 = -0.125e3 / 0.19683e5 * t156 - 0.10e2 / 0.9e1 * t91 * t149 + 0.584e3 / 0.405e3 * t109 * t212 - 0.146e3 / 0.135e3 * t215 * t113 - 0.146e3 / 0.135e3 * t109 * t129 * t113 + 0.146e3 / 0.135e3 * t112 * t129
  t226 = t135 * t85 - 0.6e1 * t139 * t141 + t37 * t177 + t181 * t117 + t188 * t223 / 0.10e2
  t230 = t17 * t18
  t231 = t129 ** 2
  t237 = f.my_piecewise3(t28, s0 / t146 * t25 / 0.4e1, 0)
  t240 = t29 * t231
  t242 = t30 * t237
  t244 = 0.2e1 * t29 * t237 + 0.2e1 * t231 + 0.18e2 * t240 + 0.9e1 * t242
  t245 = t244 * t36
  t247 = t134 * t138
  t252 = t35 ** 2
  t253 = 0.1e1 / t252
  t254 = t33 * t253
  t255 = t30 ** 2
  t257 = t85 * t255 * t231
  t260 = t177 * t30
  t261 = t260 * t129
  t265 = t85 * t29 * t231
  t268 = t140 * t237
  t271 = t66 ** 2
  t273 = 0.1e1 / t67 / t271
  t274 = t158 ** 2
  t278 = 0.1e1 / t19 / t59
  t279 = t46 * t278
  t280 = t43 * t279
  t286 = t56 * t58 / t18 / t59 / t146
  t288 = 0.14711144691358024691358024691358024691358024691358e1 * t280 + 0.18172100223395413760000000000000000000000000000000e0 * t286
  t292 = t70 * t148
  t299 = 0.62522364938271604938271604938271604938271604938271e0 * t280 - 0.5e1 / 0.9e1 * (0.64685031111111111111111111111111111111111111111112e0 * t292 + 0.11603759851851851851851851851851851851851851851852e0 * t279) * t38 * t42
  t302 = t169 * t173
  t306 = 0.1e1 / t81 / t271
  t307 = t80 * t306
  t312 = 0.6e1 / 0.25e2 * t273 * t274 - t145 * t288 / 0.5e1 + 0.7e1 / 0.9e1 * t299 * t82 - 0.28e2 / 0.45e2 * t302 * t158 + 0.98e2 / 0.225e3 * t307 * t274 - 0.14e2 / 0.45e2 * t174 * t288
  t316 = t255 * t231
  t323 = 0.12e2 * t247 * t132 + 0.12e2 * t139 * t240 + 0.6e1 * t139 * t242 - 0.54e2 * t254 * t316 - t245
  t325 = t181 * t187
  t329 = 0.1e1 / t186 / t116
  t330 = t87 * t329
  t331 = t223 ** 2
  t337 = t212 ** 2
  t341 = 0.40e2 / 0.9e1 * t292 - 0.11e2 / 0.9e1 * t279
  t342 = t341 * t38
  t345 = t42 * t200
  t346 = t345 * t208
  t349 = t103 ** 2
  t351 = 0.1e1 / t104 / t349
  t352 = t99 * t351
  t353 = t208 ** 2
  t358 = t194 ** 2
  t365 = 0.22222222222222222222222222222222222222222222222222e0 * t342 * t100 + 0.24691358024691358024691358024691358024691358024692e0 * t358 * t53 * t55 + 0.12345679012345679012345679012345679012345679012346e0 * t204 * t55 * t341
  t369 = t342 * t196 / 0.4e1 - t195 * t346 / 0.4e1 + 0.27e2 / 0.80e2 * t352 * t353 - 0.9e1 / 0.40e2 * t201 * t365 + 0.22e2 / 0.81e2 * t280
  t372 = t369 * t29
  t380 = t109 * t237
  t387 = 0.125e3 / 0.2187e4 * t286 + 0.110e3 / 0.27e2 * t91 * t279 + 0.584e3 / 0.405e3 * t337 + 0.584e3 / 0.405e3 * t109 * t369 - 0.146e3 / 0.135e3 * t372 * t113 - 0.292e3 / 0.135e3 * t212 * t129 * t113 + 0.292e3 / 0.135e3 * t215 * t129 - 0.146e3 / 0.135e3 * t380 * t113 + 0.292e3 / 0.135e3 * t109 * t231 + 0.146e3 / 0.135e3 * t112 * t237
  t390 = t245 * t85 - 0.12e2 * t247 * t141 + 0.2e1 * t135 * t177 + 0.54e2 * t254 * t257 - 0.12e2 * t139 * t261 - 0.12e2 * t139 * t265 - 0.6e1 * t139 * t268 + t37 * t312 + t323 * t117 + t325 * t223 / 0.5e1 - 0.9e1 / 0.100e3 * t330 * t331 + t188 * t387 / 0.10e2
  t395 = f.my_piecewise3(t2, 0, t6 * t22 * t119 / 0.12e2 - t6 * t124 * t226 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t230 * t390)
  t407 = t244 * t138
  t410 = t134 * t253
  t415 = t33 / t252 / t34
  t416 = t255 * t30
  t418 = t231 * t129
  t438 = f.my_piecewise3(t28, -0.3e1 / 0.4e1 * s0 / t59 * t25, 0)
  t458 = -0.18e2 * t407 * t141 + 0.162e3 * t410 * t257 - 0.648e3 * t415 * t85 * t416 * t418 - 0.18e2 * t139 * t312 * t30 * t129 + 0.324e3 * t254 * t85 * t31 * t418 - 0.36e2 * t139 * t177 * t29 * t231 - 0.6e1 * t139 * t140 * t438 - 0.36e2 * t247 * t261 - 0.18e2 * t247 * t268 + 0.162e3 * t254 * t177 * t255 * t231 - 0.36e2 * t247 * t265 - 0.18e2 * t139 * t260 * t237 - 0.27e2 / 0.100e3 * t330 * t223 * t387
  t464 = t255 * t129 * t237
  t468 = t130 * t237
  t477 = t30 * t438
  t480 = (0.6e1 * t129 * t237 + 0.2e1 * t29 * t438 + 0.18e2 * t418 + 0.54e2 * t468 + 0.9e1 * t477) * t36
  t503 = -0.324e3 * t254 * t31 * t418 + 0.648e3 * t415 * t416 * t418 + 0.18e2 * t407 * t132 + 0.12e2 * t139 * t418 + 0.36e2 * t139 * t468 + 0.6e1 * t139 * t477 + 0.36e2 * t247 * t240 + 0.18e2 * t247 * t242 - 0.162e3 * t254 * t464 - 0.162e3 * t410 * t316 - t480
  t505 = t59 ** 2
  t509 = t56 * t58 / t18 / t505
  t513 = t46 / t19 / t60
  t518 = t70 * t278
  t521 = -0.440e3 / 0.27e2 * t518 + 0.154e3 / 0.27e2 * t513
  t522 = t521 * t38
  t555 = t43 * t513
  t557 = t522 * t196 / 0.4e1 - 0.3e1 / 0.8e1 * t342 * t346 + 0.9e1 / 0.16e2 * t195 * t42 * t351 * t353 - 0.3e1 / 0.8e1 * t195 * t345 * t365 - 0.27e2 / 0.32e2 * t99 / t104 / t349 / t103 * t353 * t208 + 0.81e2 / 0.80e2 * t352 * t208 * t365 - 0.9e1 / 0.40e2 * t201 * (0.22222222222222222222222222222222222222222222222222e0 * t522 * t100 + 0.74074074074074074074074074074074074074074074074076e0 * t341 * t53 * t205 + 0.12345679012345679012345679012345679012345679012346e0 * t204 * t55 * t521) - 0.308e3 / 0.243e3 * t555
  t582 = -0.85250e5 / 0.177147e6 * t509 - 0.1540e4 / 0.81e2 * t91 * t513 + 0.584e3 / 0.135e3 * t212 * t369 + 0.584e3 / 0.405e3 * t109 * t557 - 0.146e3 / 0.135e3 * t557 * t29 * t113 - 0.146e3 / 0.45e2 * t369 * t129 * t113 + 0.146e3 / 0.45e2 * t372 * t129 - 0.146e3 / 0.45e2 * t212 * t237 * t113 + 0.292e3 / 0.45e2 * t212 * t231 + 0.146e3 / 0.45e2 * t215 * t237 - 0.146e3 / 0.135e3 * t109 * t438 * t113 + 0.292e3 / 0.45e2 * t380 * t129 + 0.146e3 / 0.135e3 * t112 * t438
  t585 = t116 ** 2
  t600 = t271 * t66
  t603 = t274 * t158
  t611 = -0.68652008559670781893004115226337448559670781893004e1 * t555 - 0.13326206830489970090666666666666666666666666666667e1 * t509
  t649 = -0.12e2 * t139 * t85 * t418 + 0.162e3 * t254 * t85 * t464 - 0.36e2 * t139 * t85 * t468 + t503 * t117 + t188 * t582 / 0.10e2 + 0.171e3 / 0.1000e4 * t87 / t186 / t585 * t331 * t223 - 0.27e2 / 0.100e3 * t181 * t329 * t331 + 0.3e1 / 0.10e2 * t325 * t387 + 0.3e1 / 0.10e2 * t323 * t187 * t223 + t37 * (-0.66e2 / 0.125e3 / t67 / t600 * t603 + 0.18e2 / 0.25e2 * t273 * t158 * t288 - t145 * t611 / 0.5e1 + 0.7e1 / 0.9e1 * (-0.29177103637860082304526748971193415637860082304526e1 * t555 - 0.5e1 / 0.9e1 * (-0.23717844740740740740740740740740740740740740740741e1 * t518 - 0.54150879308641975308641975308641975308641975308643e0 * t513) * t38 * t42) * t82 - 0.14e2 / 0.15e2 * t299 * t173 * t158 + 0.98e2 / 0.75e2 * t169 * t306 * t274 - 0.14e2 / 0.15e2 * t302 * t288 - 0.392e3 / 0.375e3 * t80 / t81 / t600 * t603 + 0.98e2 / 0.75e2 * t307 * t158 * t288 - 0.14e2 / 0.45e2 * t174 * t611) + t480 * t85 + 0.3e1 * t245 * t177 + 0.3e1 * t135 * t312
  t655 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t49 * t119 + t6 * t22 * t226 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t124 * t390 - 0.3e1 / 0.8e1 * t6 * t230 * (t458 + t649))
  v3rho3_0_ = 0.2e1 * r0 * t655 + 0.6e1 * t395

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t23 = t17 * t22
  t26 = 0.1e1 / tau0
  t28 = s0 / r0 * t26 / 0.8e1
  t29 = t28 < 0.10e1
  t30 = f.my_piecewise3(t29, t28, 0.10e1)
  t31 = t30 ** 2
  t32 = t31 * t30
  t34 = t31 + 0.3e1 * t32
  t35 = 0.1e1 + t32
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t38 = t34 * t37
  t39 = 6 ** (0.1e1 / 0.3e1)
  t40 = jnp.pi ** 2
  t41 = t40 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t43 = 0.1e1 / t42
  t44 = t39 * t43
  t45 = 2 ** (0.1e1 / 0.3e1)
  t46 = t45 ** 2
  t47 = s0 * t46
  t48 = t47 * t22
  t49 = t44 * t48
  t51 = t39 ** 2
  t53 = 0.1e1 / t41 / t40
  t54 = t51 * t53
  t55 = s0 ** 2
  t56 = t55 * t45
  t57 = t18 ** 2
  t58 = t57 * r0
  t64 = 0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t49 + 0.53798980924525896000000000000000000000000000000000e-2 * t54 * t56 / t19 / t58
  t65 = t64 ** (0.1e1 / 0.5e1)
  t68 = tau0 * t46
  t70 = 0.1e1 / t20 / r0
  t71 = t68 * t70
  t80 = 0.1e1 + 0.63943327777777777777777777777777777777777777777778e-1 * t49 - 0.5e1 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t71 + 0.25633760400000000000000000000000000000000000000000e0 * t51 * t42 + 0.11867481666666666666666666666666666666666666666667e-1 * t48) * t39 * t43
  t81 = t65 ** 2
  t82 = 0.1e1 / t81
  t85 = 0.1e1 / t65 + 0.7e1 / 0.9e1 * t80 * t82
  t87 = 0.1e1 - t38
  t91 = (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t49) * t39 * t43
  t95 = t71 - t48 / 0.8e1
  t96 = t95 * t39
  t99 = 0.5e1 / 0.9e1 * t96 * t43 - 0.1e1
  t100 = t43 * t99
  t103 = 0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t96 * t100
  t104 = jnp.sqrt(t103)
  t105 = 0.1e1 / t104
  t109 = 0.9e1 / 0.20e2 * t99 * t105 + t49 / 0.36e2
  t110 = t109 ** 2
  t112 = t109 * t30
  t113 = 0.1e1 - t30
  t116 = 0.1e1 + 0.5e1 / 0.12e2 * t91 * t48 + 0.292e3 / 0.405e3 * t110 - 0.146e3 / 0.135e3 * t112 * t113
  t117 = t116 ** (0.1e1 / 0.10e2)
  t119 = t87 * t117 + t38 * t85
  t123 = t17 * t70
  t128 = f.my_piecewise3(t29, -s0 / t18 * t26 / 0.8e1, 0)
  t129 = t30 * t128
  t131 = t31 * t128
  t133 = 0.2e1 * t129 + 0.9e1 * t131
  t134 = t133 * t37
  t137 = 0.1e1 / t36 / t35
  t138 = t34 * t137
  t139 = t85 * t31
  t140 = t139 * t128
  t144 = 0.1e1 / t65 / t64
  t145 = t18 * r0
  t147 = 0.1e1 / t20 / t145
  t148 = t47 * t147
  t149 = t44 * t148
  t151 = t57 * t18
  t155 = t54 * t56 / t19 / t151
  t157 = -0.40121303703703703703703703703703703703703703703704e0 * t149 - 0.28692789826413811200000000000000000000000000000000e-1 * t155
  t161 = t68 * t22
  t168 = -0.17051554074074074074074074074074074074074074074074e0 * t149 - 0.5e1 / 0.9e1 * (-0.24256886666666666666666666666666666666666666666667e0 * t161 - 0.31646617777777777777777777777777777777777777777779e-1 * t148) * t39 * t43
  t172 = 0.1e1 / t81 / t64
  t173 = t80 * t172
  t176 = -t144 * t157 / 0.5e1 + 0.7e1 / 0.9e1 * t168 * t82 - 0.14e2 / 0.45e2 * t173 * t157
  t180 = 0.6e1 * t138 * t131 - t134
  t182 = t117 ** 2
  t183 = t182 ** 2
  t184 = t183 ** 2
  t185 = t184 * t117
  t186 = 0.1e1 / t185
  t187 = t87 * t186
  t193 = -0.5e1 / 0.3e1 * t161 + t148 / 0.3e1
  t194 = t193 * t39
  t195 = t43 * t105
  t199 = 0.1e1 / t104 / t103
  t200 = t99 * t199
  t203 = t95 * t51
  t204 = t53 * t193
  t207 = 0.22222222222222222222222222222222222222222222222222e0 * t194 * t100 + 0.12345679012345679012345679012345679012345679012346e0 * t203 * t204
  t211 = t194 * t195 / 0.4e1 - 0.9e1 / 0.40e2 * t200 * t207 - 0.2e1 / 0.27e2 * t149
  t214 = t211 * t30
  t222 = -0.125e3 / 0.19683e5 * t155 - 0.10e2 / 0.9e1 * t91 * t148 + 0.584e3 / 0.405e3 * t109 * t211 - 0.146e3 / 0.135e3 * t214 * t113 - 0.146e3 / 0.135e3 * t109 * t128 * t113 + 0.146e3 / 0.135e3 * t112 * t128
  t225 = t134 * t85 - 0.6e1 * t138 * t140 + t38 * t176 + t180 * t117 + t187 * t222 / 0.10e2
  t230 = t17 / t20
  t231 = t128 ** 2
  t237 = f.my_piecewise3(t29, s0 / t145 * t26 / 0.4e1, 0)
  t240 = t30 * t231
  t242 = t31 * t237
  t244 = 0.2e1 * t30 * t237 + 0.2e1 * t231 + 0.18e2 * t240 + 0.9e1 * t242
  t245 = t244 * t37
  t247 = t133 * t137
  t252 = t36 ** 2
  t253 = 0.1e1 / t252
  t254 = t34 * t253
  t255 = t31 ** 2
  t256 = t85 * t255
  t257 = t256 * t231
  t260 = t176 * t31
  t261 = t260 * t128
  t264 = t85 * t30
  t265 = t264 * t231
  t268 = t139 * t237
  t271 = t64 ** 2
  t273 = 0.1e1 / t65 / t271
  t274 = t157 ** 2
  t278 = 0.1e1 / t20 / t57
  t279 = t47 * t278
  t280 = t44 * t279
  t286 = t54 * t56 / t19 / t57 / t145
  t288 = 0.14711144691358024691358024691358024691358024691358e1 * t280 + 0.18172100223395413760000000000000000000000000000000e0 * t286
  t292 = t68 * t147
  t299 = 0.62522364938271604938271604938271604938271604938271e0 * t280 - 0.5e1 / 0.9e1 * (0.64685031111111111111111111111111111111111111111112e0 * t292 + 0.11603759851851851851851851851851851851851851851852e0 * t279) * t39 * t43
  t302 = t168 * t172
  t306 = 0.1e1 / t81 / t271
  t307 = t80 * t306
  t312 = 0.6e1 / 0.25e2 * t273 * t274 - t144 * t288 / 0.5e1 + 0.7e1 / 0.9e1 * t299 * t82 - 0.28e2 / 0.45e2 * t302 * t157 + 0.98e2 / 0.225e3 * t307 * t274 - 0.14e2 / 0.45e2 * t173 * t288
  t316 = t255 * t231
  t323 = 0.12e2 * t247 * t131 + 0.12e2 * t138 * t240 + 0.6e1 * t138 * t242 - 0.54e2 * t254 * t316 - t245
  t325 = t180 * t186
  t329 = 0.1e1 / t185 / t116
  t330 = t87 * t329
  t331 = t222 ** 2
  t337 = t211 ** 2
  t341 = 0.40e2 / 0.9e1 * t292 - 0.11e2 / 0.9e1 * t279
  t342 = t341 * t39
  t345 = t43 * t199
  t346 = t345 * t207
  t349 = t103 ** 2
  t351 = 0.1e1 / t104 / t349
  t352 = t99 * t351
  t353 = t207 ** 2
  t358 = t193 ** 2
  t365 = 0.22222222222222222222222222222222222222222222222222e0 * t342 * t100 + 0.24691358024691358024691358024691358024691358024692e0 * t358 * t51 * t53 + 0.12345679012345679012345679012345679012345679012346e0 * t203 * t53 * t341
  t369 = t342 * t195 / 0.4e1 - t194 * t346 / 0.4e1 + 0.27e2 / 0.80e2 * t352 * t353 - 0.9e1 / 0.40e2 * t200 * t365 + 0.22e2 / 0.81e2 * t280
  t372 = t369 * t30
  t380 = t109 * t237
  t387 = 0.125e3 / 0.2187e4 * t286 + 0.110e3 / 0.27e2 * t91 * t279 + 0.584e3 / 0.405e3 * t337 + 0.584e3 / 0.405e3 * t109 * t369 - 0.146e3 / 0.135e3 * t372 * t113 - 0.292e3 / 0.135e3 * t211 * t128 * t113 + 0.292e3 / 0.135e3 * t214 * t128 - 0.146e3 / 0.135e3 * t380 * t113 + 0.292e3 / 0.135e3 * t109 * t231 + 0.146e3 / 0.135e3 * t112 * t237
  t390 = t245 * t85 - 0.12e2 * t247 * t140 + 0.2e1 * t134 * t176 + 0.54e2 * t254 * t257 - 0.12e2 * t138 * t261 - 0.12e2 * t138 * t265 - 0.6e1 * t138 * t268 + t38 * t312 + t323 * t117 + t325 * t222 / 0.5e1 - 0.9e1 / 0.100e3 * t330 * t331 + t187 * t387 / 0.10e2
  t394 = t17 * t19
  t395 = t254 * t85
  t397 = t255 * t128 * t237
  t400 = t138 * t85
  t401 = t129 * t237
  t406 = t323 * t186
  t409 = t271 * t64
  t411 = 0.1e1 / t65 / t409
  t412 = t274 * t157
  t415 = t273 * t157
  t419 = 0.1e1 / t20 / t58
  t420 = t47 * t419
  t421 = t44 * t420
  t423 = t57 ** 2
  t427 = t54 * t56 / t19 / t423
  t429 = -0.68652008559670781893004115226337448559670781893004e1 * t421 - 0.13326206830489970090666666666666666666666666666667e1 * t427
  t433 = t68 * t278
  t440 = -0.29177103637860082304526748971193415637860082304526e1 * t421 - 0.5e1 / 0.9e1 * (-0.23717844740740740740740740740740740740740740740741e1 * t433 - 0.54150879308641975308641975308641975308641975308643e0 * t420) * t39 * t43
  t443 = t299 * t172
  t446 = t168 * t306
  t452 = 0.1e1 / t81 / t409
  t453 = t80 * t452
  t456 = t157 * t288
  t461 = -0.66e2 / 0.125e3 * t411 * t412 + 0.18e2 / 0.25e2 * t415 * t288 - t144 * t429 / 0.5e1 + 0.7e1 / 0.9e1 * t440 * t82 - 0.14e2 / 0.15e2 * t443 * t157 + 0.98e2 / 0.75e2 * t446 * t274 - 0.14e2 / 0.15e2 * t302 * t288 - 0.392e3 / 0.375e3 * t453 * t412 + 0.98e2 / 0.75e2 * t307 * t456 - 0.14e2 / 0.45e2 * t173 * t429
  t469 = f.my_piecewise3(t29, -0.3e1 / 0.4e1 * s0 / t57 * t26, 0)
  t472 = t231 * t128
  t475 = t31 * t469
  t477 = 0.6e1 * t128 * t237 + 0.2e1 * t30 * t469 + 0.54e2 * t401 + 0.18e2 * t472 + 0.9e1 * t475
  t478 = t477 * t37
  t480 = t180 * t329
  t483 = t116 ** 2
  t485 = 0.1e1 / t185 / t483
  t486 = t87 * t485
  t487 = t331 * t222
  t497 = -0.440e3 / 0.27e2 * t433 + 0.154e3 / 0.27e2 * t420
  t498 = t497 * t39
  t504 = t43 * t351 * t353
  t507 = t345 * t365
  t512 = 0.1e1 / t104 / t349 / t103
  t513 = t99 * t512
  t514 = t353 * t207
  t528 = 0.22222222222222222222222222222222222222222222222222e0 * t498 * t100 + 0.74074074074074074074074074074074074074074074074076e0 * t341 * t51 * t204 + 0.12345679012345679012345679012345679012345679012346e0 * t203 * t53 * t497
  t532 = t498 * t195 / 0.4e1 - 0.3e1 / 0.8e1 * t342 * t346 + 0.9e1 / 0.16e2 * t194 * t504 - 0.3e1 / 0.8e1 * t194 * t507 - 0.27e2 / 0.32e2 * t513 * t514 + 0.81e2 / 0.80e2 * t352 * t207 * t365 - 0.9e1 / 0.40e2 * t200 * t528 - 0.308e3 / 0.243e3 * t421
  t535 = t532 * t30
  t543 = t211 * t237
  t550 = t109 * t469
  t557 = -0.85250e5 / 0.177147e6 * t427 - 0.1540e4 / 0.81e2 * t91 * t420 + 0.584e3 / 0.135e3 * t211 * t369 + 0.584e3 / 0.405e3 * t109 * t532 - 0.146e3 / 0.135e3 * t535 * t113 - 0.146e3 / 0.45e2 * t369 * t128 * t113 + 0.146e3 / 0.45e2 * t372 * t128 - 0.146e3 / 0.45e2 * t543 * t113 + 0.292e3 / 0.45e2 * t211 * t231 + 0.146e3 / 0.45e2 * t214 * t237 - 0.146e3 / 0.135e3 * t550 * t113 + 0.292e3 / 0.45e2 * t380 * t128 + 0.146e3 / 0.135e3 * t112 * t469
  t560 = t244 * t137
  t563 = t133 * t253
  t571 = 0.1e1 / t252 / t35
  t572 = t34 * t571
  t573 = t255 * t31
  t574 = t573 * t472
  t577 = t32 * t472
  t588 = 0.18e2 * t560 * t131 + 0.36e2 * t138 * t401 + 0.12e2 * t138 * t472 + 0.6e1 * t138 * t475 + 0.36e2 * t247 * t240 + 0.18e2 * t247 * t242 - 0.162e3 * t254 * t397 - 0.324e3 * t254 * t577 - 0.162e3 * t563 * t316 + 0.648e3 * t572 * t574 - t478
  t594 = t312 * t31
  t595 = t594 * t128
  t598 = 0.162e3 * t395 * t397 - 0.36e2 * t400 * t401 + 0.3e1 * t245 * t176 + 0.3e1 / 0.10e2 * t406 * t222 + t38 * t461 + t478 * t85 - 0.27e2 / 0.100e3 * t480 * t331 + 0.171e3 / 0.1000e4 * t486 * t487 + t187 * t557 / 0.10e2 + t588 * t117 + 0.3e1 / 0.10e2 * t325 * t387 + 0.3e1 * t134 * t312 - 0.18e2 * t138 * t595
  t599 = t260 * t237
  t609 = t85 * t573 * t472
  t613 = t176 * t30 * t231
  t616 = t139 * t469
  t620 = t176 * t255 * t231
  t628 = t85 * t32 * t472
  t631 = t222 * t387
  t634 = t85 * t472
  t637 = -0.18e2 * t138 * t599 - 0.36e2 * t247 * t261 - 0.18e2 * t247 * t268 + 0.162e3 * t563 * t257 - 0.648e3 * t572 * t609 - 0.36e2 * t138 * t613 - 0.6e1 * t138 * t616 + 0.162e3 * t254 * t620 - 0.36e2 * t247 * t265 - 0.18e2 * t560 * t140 + 0.324e3 * t254 * t628 - 0.27e2 / 0.100e3 * t330 * t631 - 0.12e2 * t138 * t634
  t638 = t598 + t637
  t643 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t23 * t119 + t6 * t123 * t225 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t230 * t390 - 0.3e1 / 0.8e1 * t6 * t394 * t638)
  t670 = t255 * t30
  t672 = t231 ** 2
  t684 = t477 * t137
  t697 = 0.513e3 / 0.500e3 * t486 * t331 * t387 - 0.27e2 / 0.25e2 * t480 * t631 - 0.36e2 * t138 * t594 * t237 + 0.1296e4 * t254 * t176 * t32 * t472 - 0.7776e4 * t572 * t85 * t670 * t672 + 0.324e3 * t254 * t312 * t255 * t231 + 0.1296e4 * t563 * t628 - 0.72e2 * t247 * t599 - 0.24e2 * t684 * t140 - 0.72e2 * t560 * t261 - 0.24e2 * t138 * t260 * t469 - 0.36e2 * t560 * t268 - 0.9e1 / 0.25e2 * t330 * t557 * t222
  t702 = t237 ** 2
  t710 = t331 ** 2
  t717 = t32 * t231 * t237
  t720 = t129 * t469
  t724 = t255 * t469 * t128
  t729 = t573 * t231 * t237
  t749 = t133 * t571
  t758 = t34 / t252 / t36
  t759 = t255 ** 2
  t763 = t231 * t237
  t770 = f.my_piecewise3(t29, 0.3e1 * s0 / t58 * t26, 0)
  t771 = t31 * t770
  t776 = -0.9720e4 * t758 * t759 * t672 + 0.24e2 * t684 * t131 + 0.72e2 * t138 * t763 + 0.6e1 * t138 * t771 + 0.72e2 * t560 * t240 + 0.144e3 * t247 * t401 + 0.48e2 * t247 * t472 + 0.24e2 * t247 * t475 - 0.648e3 * t563 * t397 - 0.1296e4 * t563 * t577 + 0.2592e4 * t749 * t574
  t779 = t244 * t253
  t797 = t30 * t702
  t812 = (0.8e1 * t128 * t469 + 0.2e1 * t30 * t770 + 0.6e1 * t702 + 0.72e2 * t720 + 0.108e3 * t763 + 0.9e1 * t771 + 0.54e2 * t797) * t37
  t813 = -0.162e3 * t254 * t255 * t702 - 0.1080e4 * t254 * t31 * t672 + 0.7776e4 * t572 * t670 * t672 + 0.48e2 * t138 * t720 + 0.36e2 * t138 * t797 + 0.36e2 * t560 * t242 - 0.1944e4 * t254 * t717 - 0.216e3 * t254 * t724 - 0.324e3 * t779 * t316 + 0.3888e4 * t572 * t729 - t812
  t819 = -0.72e2 * t138 * t85 * t231 * t237 - 0.36e2 * t138 * t264 * t702 - 0.4959e4 / 0.10000e5 * t87 / t185 / t483 / t116 * t710 + 0.648e3 * t254 * t176 * t397 + 0.1944e4 * t395 * t717 - 0.48e2 * t400 * t720 + 0.216e3 * t395 * t724 - 0.3888e4 * t572 * t85 * t729 + 0.648e3 * t563 * t85 * t397 - 0.144e3 * t247 * t85 * t401 - 0.144e3 * t138 * t176 * t401 + (t776 + t813) * t117 - 0.48e2 * t138 * t176 * t472
  t839 = t369 ** 2
  t843 = t47 / t20 / t151
  t846 = t68 * t419
  t849 = 0.6160e4 / 0.81e2 * t846 - 0.2618e4 / 0.81e2 * t843
  t850 = t849 * t39
  t871 = t349 ** 2
  t875 = t353 ** 2
  t881 = t365 ** 2
  t892 = t341 ** 2
  t902 = t44 * t843
  t904 = t850 * t195 / 0.4e1 - t498 * t346 / 0.2e1 + 0.9e1 / 0.8e1 * t342 * t504 - 0.3e1 / 0.4e1 * t342 * t507 - 0.15e2 / 0.8e1 * t194 * t43 * t512 * t514 + 0.9e1 / 0.4e1 * t194 * t43 * t351 * t207 * t365 - t194 * t345 * t528 / 0.2e1 + 0.189e3 / 0.64e2 * t99 / t104 / t871 * t875 - 0.81e2 / 0.16e2 * t513 * t353 * t365 + 0.81e2 / 0.80e2 * t352 * t881 + 0.27e2 / 0.20e2 * t352 * t207 * t528 - 0.9e1 / 0.40e2 * t200 * (0.22222222222222222222222222222222222222222222222222e0 * t850 * t100 + 0.98765432098765432098765432098765432098765432098768e0 * t497 * t51 * t204 + 0.74074074074074074074074074074074074074074074074076e0 * t892 * t51 * t53 + 0.12345679012345679012345679012345679012345679012346e0 * t203 * t53 * t849) + 0.5236e4 / 0.729e3 * t902
  t918 = t54 * t56 / t19 / t423 / r0
  t946 = 0.584e3 / 0.135e3 * t839 + 0.26180e5 / 0.243e3 * t91 * t843 - 0.146e3 / 0.135e3 * t904 * t30 * t113 + 0.2336e4 / 0.405e3 * t211 * t532 + 0.584e3 / 0.405e3 * t109 * t904 + 0.584e3 / 0.45e2 * t369 * t231 + 0.761750e6 / 0.177147e6 * t918 - 0.584e3 / 0.135e3 * t532 * t128 * t113 + 0.584e3 / 0.135e3 * t535 * t128 - 0.292e3 / 0.45e2 * t369 * t237 * t113 + 0.292e3 / 0.45e2 * t372 * t237 - 0.584e3 / 0.135e3 * t211 * t469 * t113 + 0.1168e4 / 0.45e2 * t543 * t128 + 0.584e3 / 0.135e3 * t214 * t469 - 0.146e3 / 0.135e3 * t109 * t770 * t113 + 0.1168e4 / 0.135e3 * t550 * t128 + 0.292e3 / 0.45e2 * t109 * t702 + 0.146e3 / 0.135e3 * t112 * t770
  t965 = -0.48e2 * t247 * t634 - 0.24e2 * t138 * t461 * t31 * t128 - 0.72e2 * t247 * t595 - 0.2592e4 * t572 * t176 * t573 * t472 - 0.2592e4 * t749 * t609 + 0.9720e4 * t758 * t85 * t759 * t672 + t187 * t946 / 0.10e2 + 0.171e3 / 0.250e3 * t180 * t485 * t487 - 0.24e2 * t247 * t616 - 0.6e1 * t138 * t139 * t770 + 0.648e3 * t563 * t620 + 0.162e3 * t254 * t256 * t702 + 0.1080e4 * t254 * t139 * t672
  t987 = 0.38902804850480109739368998628257887517146776406036e2 * t902 + 0.11105172358741641742222222222222222222222222222222e2 * t918
  t997 = t271 ** 2
  t1000 = t274 ** 2
  t1006 = t288 ** 2
  t1044 = -0.14e2 / 0.45e2 * t173 * t987 - 0.56e2 / 0.45e2 * t302 * t429 - 0.56e2 / 0.45e2 * t440 * t172 * t157 - 0.28e2 / 0.15e2 * t443 * t288 + 0.1056e4 / 0.625e3 / t65 / t997 * t1000 - 0.396e3 / 0.125e3 * t411 * t274 * t288 + 0.18e2 / 0.25e2 * t273 * t1006 + 0.24e2 / 0.25e2 * t415 * t429 + 0.196e3 / 0.75e2 * t299 * t306 * t274 - 0.1568e4 / 0.375e3 * t168 * t452 * t412 + 0.392e3 / 0.75e2 * t446 * t456 + 0.6664e4 / 0.1875e4 * t80 / t81 / t997 * t1000 - 0.784e3 / 0.125e3 * t453 * t274 * t288 + 0.98e2 / 0.75e2 * t307 * t1006 + 0.392e3 / 0.225e3 * t307 * t157 * t429 - t144 * t987 / 0.5e1 + 0.7e1 / 0.9e1 * (0.16533692061454046639231824417009602194787379972565e2 * t902 - 0.5e1 / 0.9e1 * (0.11068327545679012345679012345679012345679012345679e2 * t846 + 0.30685498274897119341563786008230452674897119341564e1 * t843) * t39 * t43) * t82
  t1046 = t387 ** 2
  t1057 = 0.324e3 * t779 * t257 - 0.27e2 / 0.50e2 * t323 * t329 * t331 + 0.3e1 / 0.5e1 * t406 * t387 + 0.2e1 / 0.5e1 * t325 * t557 + 0.2e1 / 0.5e1 * t588 * t186 * t222 + t812 * t85 + 0.4e1 * t478 * t176 + 0.6e1 * t245 * t312 + 0.4e1 * t134 * t461 + t38 * t1044 - 0.27e2 / 0.100e3 * t330 * t1046 - 0.72e2 * t138 * t312 * t30 * t231 - 0.72e2 * t560 * t265 - 0.144e3 * t247 * t613
  t1064 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t17 * t147 * t119 - 0.5e1 / 0.9e1 * t6 * t23 * t225 + t6 * t123 * t390 / 0.2e1 - t6 * t230 * t638 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t394 * (t697 + t819 + t965 + t1057))
  v4rho4_0_ = 0.2e1 * r0 * t1064 + 0.8e1 * t643

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t34 = 0.1e1 / tau0
  t36 = s0 / r0 * t34 / 0.8e1
  t37 = t36 < 0.10e1
  t38 = f.my_piecewise3(t37, t36, 0.10e1)
  t39 = t38 ** 2
  t40 = t39 * t38
  t42 = t39 + 0.3e1 * t40
  t43 = 0.1e1 + t40
  t44 = t43 ** 2
  t45 = 0.1e1 / t44
  t46 = t42 * t45
  t47 = 6 ** (0.1e1 / 0.3e1)
  t48 = jnp.pi ** 2
  t49 = t48 ** (0.1e1 / 0.3e1)
  t50 = t49 ** 2
  t51 = 0.1e1 / t50
  t52 = t47 * t51
  t53 = r0 ** 2
  t54 = r0 ** (0.1e1 / 0.3e1)
  t55 = t54 ** 2
  t57 = 0.1e1 / t55 / t53
  t58 = s0 * t57
  t59 = t52 * t58
  t61 = t47 ** 2
  t63 = 0.1e1 / t49 / t48
  t64 = t61 * t63
  t65 = s0 ** 2
  t66 = t53 ** 2
  t73 = 0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t59 + 0.26899490462262948000000000000000000000000000000000e-2 * t64 * t65 / t54 / t66 / r0
  t74 = t73 ** (0.1e1 / 0.5e1)
  t79 = tau0 / t55 / r0
  t82 = 0.25633760400000000000000000000000000000000000000000e0 * t61 * t50
  t88 = 0.1e1 + 0.63943327777777777777777777777777777777777777777778e-1 * t59 - 0.5e1 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t79 + t82 + 0.11867481666666666666666666666666666666666666666667e-1 * t58) * t47 * t51
  t89 = t74 ** 2
  t90 = 0.1e1 / t89
  t93 = 0.1e1 / t74 + 0.7e1 / 0.9e1 * t88 * t90
  t95 = 0.1e1 - t46
  t98 = (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t59) * t47
  t99 = t51 * s0
  t104 = t79 - t58 / 0.8e1
  t105 = t104 * t47
  t108 = 0.5e1 / 0.9e1 * t105 * t51 - 0.1e1
  t109 = t51 * t108
  t112 = 0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t105 * t109
  t113 = jnp.sqrt(t112)
  t114 = 0.1e1 / t113
  t118 = 0.9e1 / 0.20e2 * t108 * t114 + t59 / 0.36e2
  t119 = t118 ** 2
  t121 = t118 * t38
  t122 = 0.1e1 - t38
  t125 = 0.1e1 + 0.5e1 / 0.12e2 * t98 * t99 * t57 + 0.292e3 / 0.405e3 * t119 - 0.146e3 / 0.135e3 * t121 * t122
  t126 = t125 ** (0.1e1 / 0.10e2)
  t128 = t95 * t126 + t46 * t93
  t132 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t133 = t132 * f.p.zeta_threshold
  t135 = f.my_piecewise3(t20, t133, t21 * t19)
  t136 = t30 ** 2
  t137 = 0.1e1 / t136
  t138 = t135 * t137
  t141 = t5 * t138 * t128 / 0.8e1
  t142 = t135 * t30
  t147 = f.my_piecewise3(t37, -s0 / t53 * t34 / 0.8e1, 0)
  t150 = t39 * t147
  t152 = 0.2e1 * t38 * t147 + 0.9e1 * t150
  t153 = t152 * t45
  t156 = 0.1e1 / t44 / t43
  t157 = t42 * t156
  t158 = t93 * t39
  t159 = t158 * t147
  t163 = 0.1e1 / t74 / t73
  t164 = t53 * r0
  t166 = 0.1e1 / t55 / t164
  t167 = s0 * t166
  t168 = t52 * t167
  t174 = t64 * t65 / t54 / t66 / t53
  t176 = -0.40121303703703703703703703703703703703703703703704e0 * t168 - 0.14346394913206905600000000000000000000000000000000e-1 * t174
  t180 = tau0 * t57
  t187 = -0.17051554074074074074074074074074074074074074074074e0 * t168 - 0.5e1 / 0.9e1 * (-0.24256886666666666666666666666666666666666666666667e0 * t180 - 0.31646617777777777777777777777777777777777777777779e-1 * t167) * t47 * t51
  t191 = 0.1e1 / t89 / t73
  t192 = t88 * t191
  t195 = -t163 * t176 / 0.5e1 + 0.7e1 / 0.9e1 * t187 * t90 - 0.14e2 / 0.45e2 * t192 * t176
  t199 = 0.6e1 * t157 * t150 - t153
  t201 = t126 ** 2
  t202 = t201 ** 2
  t203 = t202 ** 2
  t204 = t203 * t126
  t205 = 0.1e1 / t204
  t206 = t95 * t205
  t213 = -0.5e1 / 0.3e1 * t180 + t167 / 0.3e1
  t214 = t213 * t47
  t215 = t51 * t114
  t219 = 0.1e1 / t113 / t112
  t220 = t108 * t219
  t223 = t104 * t61
  t227 = 0.22222222222222222222222222222222222222222222222222e0 * t214 * t109 + 0.12345679012345679012345679012345679012345679012346e0 * t223 * t63 * t213
  t231 = t214 * t215 / 0.4e1 - 0.9e1 / 0.40e2 * t220 * t227 - 0.2e1 / 0.27e2 * t168
  t234 = t231 * t38
  t242 = -0.125e3 / 0.39366e5 * t174 - 0.10e2 / 0.9e1 * t98 * t99 * t166 + 0.584e3 / 0.405e3 * t118 * t231 - 0.146e3 / 0.135e3 * t234 * t122 - 0.146e3 / 0.135e3 * t118 * t147 * t122 + 0.146e3 / 0.135e3 * t121 * t147
  t245 = t153 * t93 - 0.6e1 * t157 * t159 + t46 * t195 + t199 * t126 + t206 * t242 / 0.10e2
  t250 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t128 - t141 - 0.3e1 / 0.8e1 * t5 * t142 * t245)
  t252 = r1 <= f.p.dens_threshold
  t253 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t254 = 0.1e1 + t253
  t255 = t254 <= f.p.zeta_threshold
  t256 = t254 ** (0.1e1 / 0.3e1)
  t258 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t261 = f.my_piecewise3(t255, 0, 0.4e1 / 0.3e1 * t256 * t258)
  t262 = t261 * t30
  t265 = 0.1e1 / tau1
  t267 = s2 / r1 * t265 / 0.8e1
  t268 = t267 < 0.10e1
  t269 = f.my_piecewise3(t268, t267, 0.10e1)
  t270 = t269 ** 2
  t271 = t270 * t269
  t273 = t270 + 0.3e1 * t271
  t274 = 0.1e1 + t271
  t275 = t274 ** 2
  t276 = 0.1e1 / t275
  t277 = t273 * t276
  t278 = r1 ** 2
  t279 = r1 ** (0.1e1 / 0.3e1)
  t280 = t279 ** 2
  t282 = 0.1e1 / t280 / t278
  t283 = s2 * t282
  t284 = t52 * t283
  t286 = s2 ** 2
  t287 = t278 ** 2
  t294 = 0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t284 + 0.26899490462262948000000000000000000000000000000000e-2 * t64 * t286 / t279 / t287 / r1
  t295 = t294 ** (0.1e1 / 0.5e1)
  t300 = tau1 / t280 / r1
  t307 = 0.1e1 + 0.63943327777777777777777777777777777777777777777778e-1 * t284 - 0.5e1 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t300 + t82 + 0.11867481666666666666666666666666666666666666666667e-1 * t283) * t47 * t51
  t308 = t295 ** 2
  t309 = 0.1e1 / t308
  t312 = 0.1e1 / t295 + 0.7e1 / 0.9e1 * t307 * t309
  t314 = 0.1e1 - t277
  t317 = (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t284) * t47
  t318 = t51 * s2
  t323 = t300 - t283 / 0.8e1
  t324 = t323 * t47
  t327 = 0.5e1 / 0.9e1 * t324 * t51 - 0.1e1
  t328 = t51 * t327
  t331 = 0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t324 * t328
  t332 = jnp.sqrt(t331)
  t333 = 0.1e1 / t332
  t337 = 0.9e1 / 0.20e2 * t327 * t333 + t284 / 0.36e2
  t338 = t337 ** 2
  t340 = t337 * t269
  t341 = 0.1e1 - t269
  t344 = 0.1e1 + 0.5e1 / 0.12e2 * t317 * t318 * t282 + 0.292e3 / 0.405e3 * t338 - 0.146e3 / 0.135e3 * t340 * t341
  t345 = t344 ** (0.1e1 / 0.10e2)
  t347 = t277 * t312 + t314 * t345
  t352 = f.my_piecewise3(t255, t133, t256 * t254)
  t353 = t352 * t137
  t356 = t5 * t353 * t347 / 0.8e1
  t358 = f.my_piecewise3(t252, 0, -0.3e1 / 0.8e1 * t5 * t262 * t347 - t356)
  t360 = t21 ** 2
  t361 = 0.1e1 / t360
  t362 = t26 ** 2
  t367 = t16 / t22 / t6
  t369 = -0.2e1 * t23 + 0.2e1 * t367
  t370 = f.my_piecewise5(t10, 0, t14, 0, t369)
  t374 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t361 * t362 + 0.4e1 / 0.3e1 * t21 * t370)
  t381 = t5 * t29 * t137 * t128
  t387 = 0.1e1 / t136 / t6
  t391 = t5 * t135 * t387 * t128 / 0.12e2
  t393 = t5 * t138 * t245
  t395 = t147 ** 2
  t401 = f.my_piecewise3(t37, s0 / t164 * t34 / 0.4e1, 0)
  t404 = t38 * t395
  t406 = t39 * t401
  t409 = (0.2e1 * t38 * t401 + 0.2e1 * t395 + 0.18e2 * t404 + 0.9e1 * t406) * t45
  t411 = t152 * t156
  t416 = t44 ** 2
  t418 = t42 / t416
  t419 = t39 ** 2
  t435 = t73 ** 2
  t438 = t176 ** 2
  t442 = 0.1e1 / t55 / t66
  t443 = s0 * t442
  t444 = t52 * t443
  t450 = t64 * t65 / t54 / t66 / t164
  t452 = 0.14711144691358024691358024691358024691358024691358e1 * t444 + 0.90860501116977068800000000000000000000000000000000e-1 * t450
  t456 = tau0 * t166
  t495 = t242 ** 2
  t502 = t231 ** 2
  t506 = 0.40e2 / 0.9e1 * t456 - 0.11e2 / 0.9e1 * t443
  t507 = t506 * t47
  t514 = t112 ** 2
  t518 = t227 ** 2
  t523 = t213 ** 2
  t534 = t507 * t215 / 0.4e1 - t214 * t51 * t219 * t227 / 0.4e1 + 0.27e2 / 0.80e2 * t108 / t113 / t514 * t518 - 0.9e1 / 0.40e2 * t220 * (0.22222222222222222222222222222222222222222222222222e0 * t507 * t109 + 0.24691358024691358024691358024691358024691358024692e0 * t523 * t61 * t63 + 0.12345679012345679012345679012345679012345679012346e0 * t223 * t63 * t506) + 0.22e2 / 0.81e2 * t444
  t555 = t409 * t93 - 0.12e2 * t411 * t159 + 0.2e1 * t153 * t195 + 0.54e2 * t418 * t93 * t419 * t395 - 0.12e2 * t157 * t195 * t39 * t147 - 0.12e2 * t157 * t93 * t38 * t395 - 0.6e1 * t157 * t158 * t401 + t46 * (0.6e1 / 0.25e2 / t74 / t435 * t438 - t163 * t452 / 0.5e1 + 0.7e1 / 0.9e1 * (0.62522364938271604938271604938271604938271604938271e0 * t444 - 0.5e1 / 0.9e1 * (0.64685031111111111111111111111111111111111111111112e0 * t456 + 0.11603759851851851851851851851851851851851851851852e0 * t443) * t47 * t51) * t90 - 0.28e2 / 0.45e2 * t187 * t191 * t176 + 0.98e2 / 0.225e3 * t88 / t89 / t435 * t438 - 0.14e2 / 0.45e2 * t192 * t452) + (-0.54e2 * t418 * t419 * t395 + 0.12e2 * t411 * t150 + 0.12e2 * t157 * t404 + 0.6e1 * t157 * t406 - t409) * t126 + t199 * t205 * t242 / 0.5e1 - 0.9e1 / 0.100e3 * t95 / t204 / t125 * t495 + t206 * (0.125e3 / 0.4374e4 * t450 + 0.110e3 / 0.27e2 * t98 * t99 * t442 + 0.584e3 / 0.405e3 * t502 + 0.584e3 / 0.405e3 * t118 * t534 - 0.146e3 / 0.135e3 * t534 * t38 * t122 - 0.292e3 / 0.135e3 * t231 * t147 * t122 + 0.292e3 / 0.135e3 * t234 * t147 - 0.146e3 / 0.135e3 * t118 * t401 * t122 + 0.292e3 / 0.135e3 * t118 * t395 + 0.146e3 / 0.135e3 * t121 * t401) / 0.10e2
  t560 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t374 * t30 * t128 - t381 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t245 + t391 - t393 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t142 * t555)
  t561 = t256 ** 2
  t562 = 0.1e1 / t561
  t563 = t258 ** 2
  t567 = f.my_piecewise5(t14, 0, t10, 0, -t369)
  t571 = f.my_piecewise3(t255, 0, 0.4e1 / 0.9e1 * t562 * t563 + 0.4e1 / 0.3e1 * t256 * t567)
  t578 = t5 * t261 * t137 * t347
  t583 = t5 * t352 * t387 * t347 / 0.12e2
  t585 = f.my_piecewise3(t252, 0, -0.3e1 / 0.8e1 * t5 * t571 * t30 * t347 - t578 / 0.4e1 + t583)
  d11 = 0.2e1 * t250 + 0.2e1 * t358 + t6 * (t560 + t585)
  t588 = -t7 - t24
  t589 = f.my_piecewise5(t10, 0, t14, 0, t588)
  t592 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t589)
  t593 = t592 * t30
  t598 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t593 * t128 - t141)
  t600 = f.my_piecewise5(t14, 0, t10, 0, -t588)
  t603 = f.my_piecewise3(t255, 0, 0.4e1 / 0.3e1 * t256 * t600)
  t604 = t603 * t30
  t608 = t352 * t30
  t613 = f.my_piecewise3(t268, -s2 / t278 * t265 / 0.8e1, 0)
  t616 = t270 * t613
  t618 = 0.2e1 * t269 * t613 + 0.9e1 * t616
  t619 = t618 * t276
  t622 = 0.1e1 / t275 / t274
  t623 = t273 * t622
  t624 = t312 * t270
  t625 = t624 * t613
  t629 = 0.1e1 / t295 / t294
  t630 = t278 * r1
  t632 = 0.1e1 / t280 / t630
  t633 = s2 * t632
  t634 = t52 * t633
  t640 = t64 * t286 / t279 / t287 / t278
  t642 = -0.40121303703703703703703703703703703703703703703704e0 * t634 - 0.14346394913206905600000000000000000000000000000000e-1 * t640
  t646 = tau1 * t282
  t653 = -0.17051554074074074074074074074074074074074074074074e0 * t634 - 0.5e1 / 0.9e1 * (-0.24256886666666666666666666666666666666666666666667e0 * t646 - 0.31646617777777777777777777777777777777777777777779e-1 * t633) * t47 * t51
  t657 = 0.1e1 / t308 / t294
  t658 = t307 * t657
  t661 = -t629 * t642 / 0.5e1 + 0.7e1 / 0.9e1 * t653 * t309 - 0.14e2 / 0.45e2 * t658 * t642
  t665 = 0.6e1 * t623 * t616 - t619
  t667 = t345 ** 2
  t668 = t667 ** 2
  t669 = t668 ** 2
  t670 = t669 * t345
  t671 = 0.1e1 / t670
  t672 = t314 * t671
  t679 = -0.5e1 / 0.3e1 * t646 + t633 / 0.3e1
  t680 = t679 * t47
  t681 = t51 * t333
  t685 = 0.1e1 / t332 / t331
  t686 = t327 * t685
  t689 = t323 * t61
  t693 = 0.22222222222222222222222222222222222222222222222222e0 * t680 * t328 + 0.12345679012345679012345679012345679012345679012346e0 * t689 * t63 * t679
  t697 = t680 * t681 / 0.4e1 - 0.9e1 / 0.40e2 * t686 * t693 - 0.2e1 / 0.27e2 * t634
  t700 = t697 * t269
  t708 = -0.125e3 / 0.39366e5 * t640 - 0.10e2 / 0.9e1 * t317 * t318 * t632 + 0.584e3 / 0.405e3 * t337 * t697 - 0.146e3 / 0.135e3 * t700 * t341 - 0.146e3 / 0.135e3 * t337 * t613 * t341 + 0.146e3 / 0.135e3 * t340 * t613
  t711 = t619 * t312 - 0.6e1 * t623 * t625 + t277 * t661 + t665 * t345 + t672 * t708 / 0.10e2
  t716 = f.my_piecewise3(t252, 0, -0.3e1 / 0.8e1 * t5 * t604 * t347 - t356 - 0.3e1 / 0.8e1 * t5 * t608 * t711)
  t720 = 0.2e1 * t367
  t721 = f.my_piecewise5(t10, 0, t14, 0, t720)
  t725 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t361 * t589 * t26 + 0.4e1 / 0.3e1 * t21 * t721)
  t732 = t5 * t592 * t137 * t128
  t740 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t725 * t30 * t128 - t732 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t593 * t245 - t381 / 0.8e1 + t391 - t393 / 0.8e1)
  t744 = f.my_piecewise5(t14, 0, t10, 0, -t720)
  t748 = f.my_piecewise3(t255, 0, 0.4e1 / 0.9e1 * t562 * t600 * t258 + 0.4e1 / 0.3e1 * t256 * t744)
  t755 = t5 * t603 * t137 * t347
  t762 = t5 * t353 * t711
  t765 = f.my_piecewise3(t252, 0, -0.3e1 / 0.8e1 * t5 * t748 * t30 * t347 - t755 / 0.8e1 - t578 / 0.8e1 + t583 - 0.3e1 / 0.8e1 * t5 * t262 * t711 - t762 / 0.8e1)
  d12 = t250 + t358 + t598 + t716 + t6 * (t740 + t765)
  t770 = t589 ** 2
  t774 = 0.2e1 * t23 + 0.2e1 * t367
  t775 = f.my_piecewise5(t10, 0, t14, 0, t774)
  t779 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t361 * t770 + 0.4e1 / 0.3e1 * t21 * t775)
  t786 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t779 * t30 * t128 - t732 / 0.4e1 + t391)
  t787 = t600 ** 2
  t791 = f.my_piecewise5(t14, 0, t10, 0, -t774)
  t795 = f.my_piecewise3(t255, 0, 0.4e1 / 0.9e1 * t562 * t787 + 0.4e1 / 0.3e1 * t256 * t791)
  t805 = t613 ** 2
  t811 = f.my_piecewise3(t268, s2 / t630 * t265 / 0.4e1, 0)
  t814 = t269 * t805
  t816 = t270 * t811
  t819 = (0.2e1 * t269 * t811 + 0.2e1 * t805 + 0.18e2 * t814 + 0.9e1 * t816) * t276
  t821 = t618 * t622
  t826 = t275 ** 2
  t828 = t273 / t826
  t829 = t270 ** 2
  t845 = t294 ** 2
  t848 = t642 ** 2
  t852 = 0.1e1 / t280 / t287
  t853 = s2 * t852
  t854 = t52 * t853
  t860 = t64 * t286 / t279 / t287 / t630
  t862 = 0.14711144691358024691358024691358024691358024691358e1 * t854 + 0.90860501116977068800000000000000000000000000000000e-1 * t860
  t866 = tau1 * t632
  t905 = t708 ** 2
  t912 = t697 ** 2
  t916 = 0.40e2 / 0.9e1 * t866 - 0.11e2 / 0.9e1 * t853
  t917 = t916 * t47
  t924 = t331 ** 2
  t928 = t693 ** 2
  t933 = t679 ** 2
  t944 = t917 * t681 / 0.4e1 - t680 * t51 * t685 * t693 / 0.4e1 + 0.27e2 / 0.80e2 * t327 / t332 / t924 * t928 - 0.9e1 / 0.40e2 * t686 * (0.22222222222222222222222222222222222222222222222222e0 * t917 * t328 + 0.24691358024691358024691358024691358024691358024692e0 * t933 * t61 * t63 + 0.12345679012345679012345679012345679012345679012346e0 * t689 * t63 * t916) + 0.22e2 / 0.81e2 * t854
  t965 = t819 * t312 - 0.12e2 * t821 * t625 + 0.2e1 * t619 * t661 + 0.54e2 * t828 * t312 * t829 * t805 - 0.12e2 * t623 * t661 * t270 * t613 - 0.12e2 * t623 * t312 * t269 * t805 - 0.6e1 * t623 * t624 * t811 + t277 * (0.6e1 / 0.25e2 / t295 / t845 * t848 - t629 * t862 / 0.5e1 + 0.7e1 / 0.9e1 * (0.62522364938271604938271604938271604938271604938271e0 * t854 - 0.5e1 / 0.9e1 * (0.64685031111111111111111111111111111111111111111112e0 * t866 + 0.11603759851851851851851851851851851851851851851852e0 * t853) * t47 * t51) * t309 - 0.28e2 / 0.45e2 * t653 * t657 * t642 + 0.98e2 / 0.225e3 * t307 / t308 / t845 * t848 - 0.14e2 / 0.45e2 * t658 * t862) + (-0.54e2 * t828 * t829 * t805 + 0.12e2 * t821 * t616 + 0.12e2 * t623 * t814 + 0.6e1 * t623 * t816 - t819) * t345 + t665 * t671 * t708 / 0.5e1 - 0.9e1 / 0.100e3 * t314 / t670 / t344 * t905 + t672 * (0.125e3 / 0.4374e4 * t860 + 0.110e3 / 0.27e2 * t317 * t318 * t852 + 0.584e3 / 0.405e3 * t912 + 0.584e3 / 0.405e3 * t337 * t944 - 0.146e3 / 0.135e3 * t944 * t269 * t341 - 0.292e3 / 0.135e3 * t697 * t613 * t341 + 0.292e3 / 0.135e3 * t700 * t613 - 0.146e3 / 0.135e3 * t337 * t811 * t341 + 0.292e3 / 0.135e3 * t337 * t805 + 0.146e3 / 0.135e3 * t340 * t811) / 0.10e2
  t970 = f.my_piecewise3(t252, 0, -0.3e1 / 0.8e1 * t5 * t795 * t30 * t347 - t755 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t604 * t711 + t583 - t762 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t608 * t965)
  d22 = 0.2e1 * t598 + 0.2e1 * t716 + t6 * (t786 + t970)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t46 = 0.1e1 / tau0
  t48 = s0 / r0 * t46 / 0.8e1
  t49 = t48 < 0.10e1
  t50 = f.my_piecewise3(t49, t48, 0.10e1)
  t51 = t50 ** 2
  t52 = t51 * t50
  t54 = t51 + 0.3e1 * t52
  t55 = 0.1e1 + t52
  t56 = t55 ** 2
  t57 = 0.1e1 / t56
  t58 = t54 * t57
  t59 = 6 ** (0.1e1 / 0.3e1)
  t60 = jnp.pi ** 2
  t61 = t60 ** (0.1e1 / 0.3e1)
  t62 = t61 ** 2
  t63 = 0.1e1 / t62
  t64 = t59 * t63
  t65 = r0 ** 2
  t66 = r0 ** (0.1e1 / 0.3e1)
  t67 = t66 ** 2
  t69 = 0.1e1 / t67 / t65
  t70 = s0 * t69
  t71 = t64 * t70
  t73 = t59 ** 2
  t75 = 0.1e1 / t61 / t60
  t76 = t73 * t75
  t77 = s0 ** 2
  t78 = t65 ** 2
  t79 = t78 * r0
  t85 = 0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t71 + 0.26899490462262948000000000000000000000000000000000e-2 * t76 * t77 / t66 / t79
  t86 = t85 ** (0.1e1 / 0.5e1)
  t91 = tau0 / t67 / r0
  t94 = 0.25633760400000000000000000000000000000000000000000e0 * t73 * t62
  t100 = 0.1e1 + 0.63943327777777777777777777777777777777777777777778e-1 * t71 - 0.5e1 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t91 + t94 + 0.11867481666666666666666666666666666666666666666667e-1 * t70) * t59 * t63
  t101 = t86 ** 2
  t102 = 0.1e1 / t101
  t105 = 0.1e1 / t86 + 0.7e1 / 0.9e1 * t100 * t102
  t107 = 0.1e1 - t58
  t110 = (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t71) * t59
  t111 = t63 * s0
  t116 = t91 - t70 / 0.8e1
  t117 = t116 * t59
  t120 = 0.5e1 / 0.9e1 * t117 * t63 - 0.1e1
  t121 = t63 * t120
  t124 = 0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t117 * t121
  t125 = jnp.sqrt(t124)
  t126 = 0.1e1 / t125
  t130 = 0.9e1 / 0.20e2 * t120 * t126 + t71 / 0.36e2
  t131 = t130 ** 2
  t133 = t130 * t50
  t134 = 0.1e1 - t50
  t137 = 0.1e1 + 0.5e1 / 0.12e2 * t110 * t111 * t69 + 0.292e3 / 0.405e3 * t131 - 0.146e3 / 0.135e3 * t133 * t134
  t138 = t137 ** (0.1e1 / 0.10e2)
  t140 = t58 * t105 + t107 * t138
  t146 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t147 = t42 ** 2
  t148 = 0.1e1 / t147
  t149 = t146 * t148
  t153 = t146 * t42
  t158 = f.my_piecewise3(t49, -s0 / t65 * t46 / 0.8e1, 0)
  t159 = t50 * t158
  t161 = t51 * t158
  t163 = 0.2e1 * t159 + 0.9e1 * t161
  t164 = t163 * t57
  t167 = 0.1e1 / t56 / t55
  t168 = t54 * t167
  t169 = t105 * t51
  t170 = t169 * t158
  t174 = 0.1e1 / t86 / t85
  t175 = t65 * r0
  t177 = 0.1e1 / t67 / t175
  t178 = s0 * t177
  t179 = t64 * t178
  t185 = t76 * t77 / t66 / t78 / t65
  t187 = -0.40121303703703703703703703703703703703703703703704e0 * t179 - 0.14346394913206905600000000000000000000000000000000e-1 * t185
  t191 = tau0 * t69
  t198 = -0.17051554074074074074074074074074074074074074074074e0 * t179 - 0.5e1 / 0.9e1 * (-0.24256886666666666666666666666666666666666666666667e0 * t191 - 0.31646617777777777777777777777777777777777777777779e-1 * t178) * t59 * t63
  t202 = 0.1e1 / t101 / t85
  t203 = t100 * t202
  t206 = -t174 * t187 / 0.5e1 + 0.7e1 / 0.9e1 * t198 * t102 - 0.14e2 / 0.45e2 * t203 * t187
  t210 = 0.6e1 * t168 * t161 - t164
  t212 = t138 ** 2
  t213 = t212 ** 2
  t214 = t213 ** 2
  t215 = t214 * t138
  t216 = 0.1e1 / t215
  t217 = t107 * t216
  t224 = -0.5e1 / 0.3e1 * t191 + t178 / 0.3e1
  t225 = t224 * t59
  t226 = t63 * t126
  t230 = 0.1e1 / t125 / t124
  t231 = t120 * t230
  t234 = t116 * t73
  t235 = t75 * t224
  t238 = 0.22222222222222222222222222222222222222222222222222e0 * t225 * t121 + 0.12345679012345679012345679012345679012345679012346e0 * t234 * t235
  t242 = t225 * t226 / 0.4e1 - 0.9e1 / 0.40e2 * t231 * t238 - 0.2e1 / 0.27e2 * t179
  t245 = t242 * t50
  t253 = -0.125e3 / 0.39366e5 * t185 - 0.10e2 / 0.9e1 * t110 * t111 * t177 + 0.584e3 / 0.405e3 * t130 * t242 - 0.146e3 / 0.135e3 * t245 * t134 - 0.146e3 / 0.135e3 * t130 * t158 * t134 + 0.146e3 / 0.135e3 * t133 * t158
  t256 = t164 * t105 - 0.6e1 * t168 * t170 + t58 * t206 + t210 * t138 + t217 * t253 / 0.10e2
  t260 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t261 = t260 * f.p.zeta_threshold
  t263 = f.my_piecewise3(t20, t261, t21 * t19)
  t265 = 0.1e1 / t147 / t6
  t266 = t263 * t265
  t270 = t263 * t148
  t274 = t263 * t42
  t275 = t158 ** 2
  t281 = f.my_piecewise3(t49, s0 / t175 * t46 / 0.4e1, 0)
  t284 = t50 * t275
  t286 = t51 * t281
  t288 = 0.2e1 * t50 * t281 + 0.2e1 * t275 + 0.18e2 * t284 + 0.9e1 * t286
  t289 = t288 * t57
  t291 = t163 * t167
  t296 = t56 ** 2
  t297 = 0.1e1 / t296
  t298 = t54 * t297
  t299 = t51 ** 2
  t301 = t105 * t299 * t275
  t304 = t206 * t51
  t305 = t304 * t158
  t309 = t105 * t50 * t275
  t312 = t169 * t281
  t315 = t85 ** 2
  t317 = 0.1e1 / t86 / t315
  t318 = t187 ** 2
  t322 = 0.1e1 / t67 / t78
  t323 = s0 * t322
  t324 = t64 * t323
  t330 = t76 * t77 / t66 / t78 / t175
  t332 = 0.14711144691358024691358024691358024691358024691358e1 * t324 + 0.90860501116977068800000000000000000000000000000000e-1 * t330
  t336 = tau0 * t177
  t343 = 0.62522364938271604938271604938271604938271604938271e0 * t324 - 0.5e1 / 0.9e1 * (0.64685031111111111111111111111111111111111111111112e0 * t336 + 0.11603759851851851851851851851851851851851851851852e0 * t323) * t59 * t63
  t346 = t198 * t202
  t350 = 0.1e1 / t101 / t315
  t351 = t100 * t350
  t356 = 0.6e1 / 0.25e2 * t317 * t318 - t174 * t332 / 0.5e1 + 0.7e1 / 0.9e1 * t343 * t102 - 0.28e2 / 0.45e2 * t346 * t187 + 0.98e2 / 0.225e3 * t351 * t318 - 0.14e2 / 0.45e2 * t203 * t332
  t360 = t299 * t275
  t367 = 0.12e2 * t291 * t161 + 0.12e2 * t168 * t284 + 0.6e1 * t168 * t286 - 0.54e2 * t298 * t360 - t289
  t369 = t210 * t216
  t373 = 0.1e1 / t215 / t137
  t374 = t107 * t373
  t375 = t253 ** 2
  t382 = t242 ** 2
  t386 = 0.40e2 / 0.9e1 * t336 - 0.11e2 / 0.9e1 * t323
  t387 = t386 * t59
  t390 = t63 * t230
  t391 = t390 * t238
  t394 = t124 ** 2
  t396 = 0.1e1 / t125 / t394
  t397 = t120 * t396
  t398 = t238 ** 2
  t403 = t224 ** 2
  t410 = 0.22222222222222222222222222222222222222222222222222e0 * t387 * t121 + 0.24691358024691358024691358024691358024691358024692e0 * t403 * t73 * t75 + 0.12345679012345679012345679012345679012345679012346e0 * t234 * t75 * t386
  t414 = t387 * t226 / 0.4e1 - t225 * t391 / 0.4e1 + 0.27e2 / 0.80e2 * t397 * t398 - 0.9e1 / 0.40e2 * t231 * t410 + 0.22e2 / 0.81e2 * t324
  t417 = t414 * t50
  t425 = t130 * t281
  t432 = 0.125e3 / 0.4374e4 * t330 + 0.110e3 / 0.27e2 * t110 * t111 * t322 + 0.584e3 / 0.405e3 * t382 + 0.584e3 / 0.405e3 * t130 * t414 - 0.146e3 / 0.135e3 * t417 * t134 - 0.292e3 / 0.135e3 * t242 * t158 * t134 + 0.292e3 / 0.135e3 * t245 * t158 - 0.146e3 / 0.135e3 * t425 * t134 + 0.292e3 / 0.135e3 * t130 * t275 + 0.146e3 / 0.135e3 * t133 * t281
  t435 = t289 * t105 - 0.12e2 * t291 * t170 + 0.2e1 * t164 * t206 + 0.54e2 * t298 * t301 - 0.12e2 * t168 * t305 - 0.12e2 * t168 * t309 - 0.6e1 * t168 * t312 + t58 * t356 + t367 * t138 + t369 * t253 / 0.5e1 - 0.9e1 / 0.100e3 * t374 * t375 + t217 * t432 / 0.10e2
  t440 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t140 - t5 * t149 * t140 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t153 * t256 + t5 * t266 * t140 / 0.12e2 - t5 * t270 * t256 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t274 * t435)
  t442 = r1 <= f.p.dens_threshold
  t443 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t444 = 0.1e1 + t443
  t445 = t444 <= f.p.zeta_threshold
  t446 = t444 ** (0.1e1 / 0.3e1)
  t447 = t446 ** 2
  t448 = 0.1e1 / t447
  t450 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t451 = t450 ** 2
  t455 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t459 = f.my_piecewise3(t445, 0, 0.4e1 / 0.9e1 * t448 * t451 + 0.4e1 / 0.3e1 * t446 * t455)
  t465 = s2 / r1 / tau1 / 0.8e1
  t467 = f.my_piecewise3(t465 < 0.10e1, t465, 0.10e1)
  t468 = t467 ** 2
  t469 = t468 * t467
  t473 = (0.1e1 + t469) ** 2
  t475 = (t468 + 0.3e1 * t469) / t473
  t476 = r1 ** 2
  t477 = r1 ** (0.1e1 / 0.3e1)
  t478 = t477 ** 2
  t480 = 0.1e1 / t478 / t476
  t481 = s2 * t480
  t482 = t64 * t481
  t484 = s2 ** 2
  t485 = t476 ** 2
  t493 = (0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t482 + 0.26899490462262948000000000000000000000000000000000e-2 * t76 * t484 / t477 / t485 / r1) ** (0.1e1 / 0.5e1)
  t498 = tau1 / t478 / r1
  t506 = t493 ** 2
  t522 = (t498 - t481 / 0.8e1) * t59
  t525 = 0.5e1 / 0.9e1 * t522 * t63 - 0.1e1
  t530 = jnp.sqrt(0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t522 * t63 * t525)
  t535 = 0.9e1 / 0.20e2 * t525 / t530 + t482 / 0.36e2
  t536 = t535 ** 2
  t543 = (0.1e1 + 0.5e1 / 0.12e2 * (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t482) * t59 * t63 * s2 * t480 + 0.292e3 / 0.405e3 * t536 - 0.146e3 / 0.135e3 * t535 * t467 * (0.1e1 - t467)) ** (0.1e1 / 0.10e2)
  t545 = t475 * (0.1e1 / t493 + 0.7e1 / 0.9e1 * (0.1e1 + 0.63943327777777777777777777777777777777777777777778e-1 * t482 - 0.5e1 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t498 + t94 + 0.11867481666666666666666666666666666666666666666667e-1 * t481) * t59 * t63) / t506) + (0.1e1 - t475) * t543
  t551 = f.my_piecewise3(t445, 0, 0.4e1 / 0.3e1 * t446 * t450)
  t557 = f.my_piecewise3(t445, t261, t446 * t444)
  t563 = f.my_piecewise3(t442, 0, -0.3e1 / 0.8e1 * t5 * t459 * t42 * t545 - t5 * t551 * t148 * t545 / 0.4e1 + t5 * t557 * t265 * t545 / 0.12e2)
  t573 = t24 ** 2
  t577 = 0.6e1 * t33 - 0.6e1 * t16 / t573
  t578 = f.my_piecewise5(t10, 0, t14, 0, t577)
  t582 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t578)
  t605 = 0.1e1 / t147 / t24
  t622 = f.my_piecewise3(t49, -0.3e1 / 0.4e1 * s0 / t78 * t46, 0)
  t625 = t275 * t158
  t627 = t159 * t281
  t629 = t51 * t622
  t632 = (0.6e1 * t158 * t281 + 0.2e1 * t50 * t622 + 0.18e2 * t625 + 0.54e2 * t627 + 0.9e1 * t629) * t57
  t633 = t288 * t167
  t636 = t163 * t297
  t645 = t54 / t296 / t55
  t646 = t299 * t51
  t654 = t299 * t158 * t281
  t663 = -0.324e3 * t298 * t52 * t625 + 0.648e3 * t645 * t646 * t625 + 0.18e2 * t633 * t161 + 0.12e2 * t168 * t625 + 0.36e2 * t168 * t627 + 0.6e1 * t168 * t629 + 0.36e2 * t291 * t284 + 0.18e2 * t291 * t286 - 0.162e3 * t298 * t654 - 0.162e3 * t636 * t360 - t632
  t700 = t663 * t138 - 0.27e2 / 0.100e3 * t374 * t253 * t432 - 0.18e2 * t291 * t312 + 0.162e3 * t636 * t301 + 0.162e3 * t298 * t206 * t299 * t275 - 0.648e3 * t645 * t105 * t646 * t625 - 0.18e2 * t168 * t356 * t51 * t158 - 0.18e2 * t168 * t304 * t281 - 0.6e1 * t168 * t169 * t622 - 0.18e2 * t633 * t170 - 0.36e2 * t291 * t305 - 0.36e2 * t291 * t309 + 0.324e3 * t298 * t105 * t52 * t625
  t718 = t315 * t85
  t721 = t318 * t187
  t728 = 0.1e1 / t67 / t79
  t729 = s0 * t728
  t730 = t64 * t729
  t732 = t78 ** 2
  t736 = t76 * t77 / t66 / t732
  t738 = -0.68652008559670781893004115226337448559670781893004e1 * t730 - 0.66631034152449850453333333333333333333333333333333e0 * t736
  t742 = tau0 * t322
  t786 = -0.440e3 / 0.27e2 * t742 + 0.154e3 / 0.27e2 * t729
  t787 = t786 * t59
  t821 = t787 * t226 / 0.4e1 - 0.3e1 / 0.8e1 * t387 * t391 + 0.9e1 / 0.16e2 * t225 * t63 * t396 * t398 - 0.3e1 / 0.8e1 * t225 * t390 * t410 - 0.27e2 / 0.32e2 * t120 / t125 / t394 / t124 * t398 * t238 + 0.81e2 / 0.80e2 * t397 * t238 * t410 - 0.9e1 / 0.40e2 * t231 * (0.22222222222222222222222222222222222222222222222222e0 * t787 * t121 + 0.74074074074074074074074074074074074074074074074076e0 * t386 * t73 * t235 + 0.12345679012345679012345679012345679012345679012346e0 * t234 * t75 * t786) - 0.308e3 / 0.243e3 * t730
  t846 = -0.42625e5 / 0.177147e6 * t736 - 0.1540e4 / 0.81e2 * t110 * t111 * t728 + 0.584e3 / 0.135e3 * t242 * t414 + 0.584e3 / 0.405e3 * t130 * t821 - 0.146e3 / 0.135e3 * t821 * t50 * t134 - 0.146e3 / 0.45e2 * t414 * t158 * t134 + 0.146e3 / 0.45e2 * t417 * t158 - 0.146e3 / 0.45e2 * t242 * t281 * t134 + 0.292e3 / 0.45e2 * t242 * t275 + 0.146e3 / 0.45e2 * t245 * t281 - 0.146e3 / 0.135e3 * t130 * t622 * t134 + 0.292e3 / 0.45e2 * t425 * t158 + 0.146e3 / 0.135e3 * t133 * t622
  t852 = t137 ** 2
  t859 = -0.36e2 * t168 * t206 * t50 * t275 + 0.162e3 * t298 * t105 * t654 - 0.36e2 * t168 * t105 * t627 - 0.12e2 * t168 * t105 * t625 + 0.3e1 * t289 * t206 + 0.3e1 * t164 * t356 + t58 * (-0.66e2 / 0.125e3 / t86 / t718 * t721 + 0.18e2 / 0.25e2 * t317 * t187 * t332 - t174 * t738 / 0.5e1 + 0.7e1 / 0.9e1 * (-0.29177103637860082304526748971193415637860082304526e1 * t730 - 0.5e1 / 0.9e1 * (-0.23717844740740740740740740740740740740740740740741e1 * t742 - 0.54150879308641975308641975308641975308641975308643e0 * t729) * t59 * t63) * t102 - 0.14e2 / 0.15e2 * t343 * t202 * t187 + 0.98e2 / 0.75e2 * t198 * t350 * t318 - 0.14e2 / 0.15e2 * t346 * t332 - 0.392e3 / 0.375e3 * t100 / t101 / t718 * t721 + 0.98e2 / 0.75e2 * t351 * t187 * t332 - 0.14e2 / 0.45e2 * t203 * t738) + 0.3e1 / 0.10e2 * t367 * t216 * t253 + t632 * t105 + 0.3e1 / 0.10e2 * t369 * t432 + t217 * t846 / 0.10e2 - 0.27e2 / 0.100e3 * t210 * t373 * t375 + 0.171e3 / 0.1000e4 * t107 / t215 / t852 * t375 * t253
  t865 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t582 * t42 * t140 - 0.3e1 / 0.8e1 * t5 * t41 * t148 * t140 - 0.9e1 / 0.8e1 * t5 * t43 * t256 + t5 * t146 * t265 * t140 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t149 * t256 - 0.9e1 / 0.8e1 * t5 * t153 * t435 - 0.5e1 / 0.36e2 * t5 * t263 * t605 * t140 + t5 * t266 * t256 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t270 * t435 - 0.3e1 / 0.8e1 * t5 * t274 * (t700 + t859))
  t875 = f.my_piecewise5(t14, 0, t10, 0, -t577)
  t879 = f.my_piecewise3(t445, 0, -0.8e1 / 0.27e2 / t447 / t444 * t451 * t450 + 0.4e1 / 0.3e1 * t448 * t450 * t455 + 0.4e1 / 0.3e1 * t446 * t875)
  t897 = f.my_piecewise3(t442, 0, -0.3e1 / 0.8e1 * t5 * t879 * t42 * t545 - 0.3e1 / 0.8e1 * t5 * t459 * t148 * t545 + t5 * t551 * t265 * t545 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t557 * t605 * t545)
  d111 = 0.3e1 * t440 + 0.3e1 * t563 + t6 * (t865 + t897)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 0.1e1 / t22 / t19
  t25 = t6 ** 2
  t26 = 0.1e1 / t25
  t28 = -t16 * t26 + t7
  t29 = f.my_piecewise5(t10, 0, t14, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t6
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t16 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t10, 0, t14, 0, t40)
  t44 = t25 ** 2
  t45 = 0.1e1 / t44
  t48 = -0.6e1 * t16 * t45 + 0.6e1 * t37
  t49 = f.my_piecewise5(t10, 0, t14, 0, t48)
  t53 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t24 * t30 * t29 + 0.4e1 / 0.3e1 * t35 * t41 + 0.4e1 / 0.3e1 * t21 * t49)
  t54 = t6 ** (0.1e1 / 0.3e1)
  t55 = t53 * t54
  t58 = 0.1e1 / tau0
  t60 = s0 / r0 * t58 / 0.8e1
  t61 = t60 < 0.10e1
  t62 = f.my_piecewise3(t61, t60, 0.10e1)
  t63 = t62 ** 2
  t64 = t63 * t62
  t66 = t63 + 0.3e1 * t64
  t67 = 0.1e1 + t64
  t68 = t67 ** 2
  t69 = 0.1e1 / t68
  t70 = t66 * t69
  t71 = 6 ** (0.1e1 / 0.3e1)
  t72 = jnp.pi ** 2
  t73 = t72 ** (0.1e1 / 0.3e1)
  t74 = t73 ** 2
  t75 = 0.1e1 / t74
  t76 = t71 * t75
  t77 = r0 ** 2
  t78 = r0 ** (0.1e1 / 0.3e1)
  t79 = t78 ** 2
  t81 = 0.1e1 / t79 / t77
  t82 = s0 * t81
  t83 = t76 * t82
  t85 = t71 ** 2
  t87 = 0.1e1 / t73 / t72
  t88 = t85 * t87
  t89 = s0 ** 2
  t90 = t77 ** 2
  t91 = t90 * r0
  t97 = 0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t83 + 0.26899490462262948000000000000000000000000000000000e-2 * t88 * t89 / t78 / t91
  t98 = t97 ** (0.1e1 / 0.5e1)
  t103 = tau0 / t79 / r0
  t106 = 0.25633760400000000000000000000000000000000000000000e0 * t85 * t74
  t112 = 0.1e1 + 0.63943327777777777777777777777777777777777777777778e-1 * t83 - 0.5e1 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t103 + t106 + 0.11867481666666666666666666666666666666666666666667e-1 * t82) * t71 * t75
  t113 = t98 ** 2
  t114 = 0.1e1 / t113
  t117 = 0.1e1 / t98 + 0.7e1 / 0.9e1 * t112 * t114
  t119 = 0.1e1 - t70
  t122 = (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t83) * t71
  t123 = t75 * s0
  t128 = t103 - t82 / 0.8e1
  t129 = t128 * t71
  t132 = 0.5e1 / 0.9e1 * t129 * t75 - 0.1e1
  t133 = t75 * t132
  t136 = 0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t129 * t133
  t137 = jnp.sqrt(t136)
  t138 = 0.1e1 / t137
  t142 = 0.9e1 / 0.20e2 * t132 * t138 + t83 / 0.36e2
  t143 = t142 ** 2
  t145 = t142 * t62
  t146 = 0.1e1 - t62
  t149 = 0.1e1 + 0.5e1 / 0.12e2 * t122 * t123 * t81 + 0.292e3 / 0.405e3 * t143 - 0.146e3 / 0.135e3 * t145 * t146
  t150 = t149 ** (0.1e1 / 0.10e2)
  t152 = t117 * t70 + t119 * t150
  t161 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t34 * t30 + 0.4e1 / 0.3e1 * t21 * t41)
  t162 = t54 ** 2
  t163 = 0.1e1 / t162
  t164 = t161 * t163
  t168 = t161 * t54
  t173 = f.my_piecewise3(t61, -s0 / t77 * t58 / 0.8e1, 0)
  t174 = t62 * t173
  t176 = t63 * t173
  t178 = 0.2e1 * t174 + 0.9e1 * t176
  t179 = t178 * t69
  t182 = 0.1e1 / t68 / t67
  t183 = t66 * t182
  t184 = t117 * t63
  t185 = t184 * t173
  t189 = 0.1e1 / t98 / t97
  t190 = t77 * r0
  t192 = 0.1e1 / t79 / t190
  t193 = s0 * t192
  t194 = t76 * t193
  t196 = t90 * t77
  t200 = t88 * t89 / t78 / t196
  t202 = -0.40121303703703703703703703703703703703703703703704e0 * t194 - 0.14346394913206905600000000000000000000000000000000e-1 * t200
  t206 = tau0 * t81
  t213 = -0.17051554074074074074074074074074074074074074074074e0 * t194 - 0.5e1 / 0.9e1 * (-0.24256886666666666666666666666666666666666666666667e0 * t206 - 0.31646617777777777777777777777777777777777777777779e-1 * t193) * t71 * t75
  t217 = 0.1e1 / t113 / t97
  t218 = t112 * t217
  t221 = -t189 * t202 / 0.5e1 + 0.7e1 / 0.9e1 * t213 * t114 - 0.14e2 / 0.45e2 * t218 * t202
  t225 = 0.6e1 * t176 * t183 - t179
  t227 = t150 ** 2
  t228 = t227 ** 2
  t229 = t228 ** 2
  t230 = t229 * t150
  t231 = 0.1e1 / t230
  t232 = t119 * t231
  t239 = -0.5e1 / 0.3e1 * t206 + t193 / 0.3e1
  t240 = t239 * t71
  t241 = t75 * t138
  t245 = 0.1e1 / t137 / t136
  t246 = t132 * t245
  t249 = t128 * t85
  t250 = t87 * t239
  t253 = 0.22222222222222222222222222222222222222222222222222e0 * t240 * t133 + 0.12345679012345679012345679012345679012345679012346e0 * t249 * t250
  t257 = t240 * t241 / 0.4e1 - 0.9e1 / 0.40e2 * t246 * t253 - 0.2e1 / 0.27e2 * t194
  t260 = t257 * t62
  t268 = -0.125e3 / 0.39366e5 * t200 - 0.10e2 / 0.9e1 * t122 * t123 * t192 + 0.584e3 / 0.405e3 * t142 * t257 - 0.146e3 / 0.135e3 * t260 * t146 - 0.146e3 / 0.135e3 * t142 * t173 * t146 + 0.146e3 / 0.135e3 * t145 * t173
  t271 = t179 * t117 - 0.6e1 * t183 * t185 + t70 * t221 + t225 * t150 + t232 * t268 / 0.10e2
  t277 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t29)
  t279 = 0.1e1 / t162 / t6
  t280 = t277 * t279
  t284 = t277 * t163
  t288 = t277 * t54
  t289 = t173 ** 2
  t295 = f.my_piecewise3(t61, s0 / t190 * t58 / 0.4e1, 0)
  t298 = t62 * t289
  t300 = t63 * t295
  t302 = 0.2e1 * t295 * t62 + 0.2e1 * t289 + 0.18e2 * t298 + 0.9e1 * t300
  t303 = t302 * t69
  t305 = t178 * t182
  t310 = t68 ** 2
  t311 = 0.1e1 / t310
  t312 = t66 * t311
  t313 = t63 ** 2
  t314 = t117 * t313
  t315 = t314 * t289
  t318 = t221 * t63
  t319 = t318 * t173
  t322 = t117 * t62
  t323 = t322 * t289
  t326 = t184 * t295
  t329 = t97 ** 2
  t331 = 0.1e1 / t98 / t329
  t332 = t202 ** 2
  t336 = 0.1e1 / t79 / t90
  t337 = s0 * t336
  t338 = t76 * t337
  t344 = t88 * t89 / t78 / t90 / t190
  t346 = 0.14711144691358024691358024691358024691358024691358e1 * t338 + 0.90860501116977068800000000000000000000000000000000e-1 * t344
  t350 = tau0 * t192
  t357 = 0.62522364938271604938271604938271604938271604938271e0 * t338 - 0.5e1 / 0.9e1 * (0.64685031111111111111111111111111111111111111111112e0 * t350 + 0.11603759851851851851851851851851851851851851851852e0 * t337) * t71 * t75
  t360 = t213 * t217
  t364 = 0.1e1 / t113 / t329
  t365 = t112 * t364
  t370 = 0.6e1 / 0.25e2 * t331 * t332 - t189 * t346 / 0.5e1 + 0.7e1 / 0.9e1 * t357 * t114 - 0.28e2 / 0.45e2 * t360 * t202 + 0.98e2 / 0.225e3 * t365 * t332 - 0.14e2 / 0.45e2 * t218 * t346
  t374 = t313 * t289
  t381 = 0.12e2 * t176 * t305 + 0.12e2 * t183 * t298 + 0.6e1 * t183 * t300 - 0.54e2 * t312 * t374 - t303
  t383 = t225 * t231
  t387 = 0.1e1 / t230 / t149
  t388 = t119 * t387
  t389 = t268 ** 2
  t396 = t257 ** 2
  t400 = 0.40e2 / 0.9e1 * t350 - 0.11e2 / 0.9e1 * t337
  t401 = t400 * t71
  t404 = t75 * t245
  t405 = t404 * t253
  t408 = t136 ** 2
  t410 = 0.1e1 / t137 / t408
  t411 = t132 * t410
  t412 = t253 ** 2
  t417 = t239 ** 2
  t424 = 0.22222222222222222222222222222222222222222222222222e0 * t401 * t133 + 0.24691358024691358024691358024691358024691358024692e0 * t417 * t85 * t87 + 0.12345679012345679012345679012345679012345679012346e0 * t249 * t87 * t400
  t428 = t401 * t241 / 0.4e1 - t240 * t405 / 0.4e1 + 0.27e2 / 0.80e2 * t411 * t412 - 0.9e1 / 0.40e2 * t246 * t424 + 0.22e2 / 0.81e2 * t338
  t431 = t428 * t62
  t439 = t142 * t295
  t446 = 0.125e3 / 0.4374e4 * t344 + 0.110e3 / 0.27e2 * t122 * t123 * t336 + 0.584e3 / 0.405e3 * t396 + 0.584e3 / 0.405e3 * t142 * t428 - 0.146e3 / 0.135e3 * t431 * t146 - 0.292e3 / 0.135e3 * t257 * t173 * t146 + 0.292e3 / 0.135e3 * t260 * t173 - 0.146e3 / 0.135e3 * t439 * t146 + 0.292e3 / 0.135e3 * t142 * t289 + 0.146e3 / 0.135e3 * t145 * t295
  t449 = t303 * t117 - 0.12e2 * t305 * t185 + 0.2e1 * t179 * t221 + 0.54e2 * t312 * t315 - 0.12e2 * t183 * t319 - 0.12e2 * t183 * t323 - 0.6e1 * t183 * t326 + t70 * t370 + t381 * t150 + t383 * t268 / 0.5e1 - 0.9e1 / 0.100e3 * t388 * t389 + t232 * t446 / 0.10e2
  t453 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t454 = t453 * f.p.zeta_threshold
  t456 = f.my_piecewise3(t20, t454, t21 * t19)
  t458 = 0.1e1 / t162 / t25
  t459 = t456 * t458
  t463 = t456 * t279
  t467 = t456 * t163
  t471 = t456 * t54
  t472 = t225 * t387
  t475 = t149 ** 2
  t477 = 0.1e1 / t230 / t475
  t478 = t119 * t477
  t479 = t389 * t268
  t486 = t178 * t311
  t490 = t221 * t313 * t289
  t494 = 0.1e1 / t310 / t67
  t495 = t66 * t494
  t496 = t313 * t63
  t498 = t289 * t173
  t499 = t117 * t496 * t498
  t502 = t370 * t63
  t503 = t502 * t173
  t506 = t318 * t295
  t513 = f.my_piecewise3(t61, -0.3e1 / 0.4e1 * s0 / t90 * t58, 0)
  t514 = t184 * t513
  t517 = t302 * t182
  t523 = t117 * t64 * t498
  t526 = -0.27e2 / 0.100e3 * t472 * t389 + 0.171e3 / 0.1000e4 * t478 * t479 - 0.36e2 * t305 * t319 - 0.18e2 * t305 * t326 + 0.162e3 * t486 * t315 + 0.162e3 * t312 * t490 - 0.648e3 * t495 * t499 - 0.18e2 * t183 * t503 - 0.18e2 * t183 * t506 - 0.6e1 * t183 * t514 - 0.18e2 * t517 * t185 - 0.36e2 * t305 * t323 + 0.324e3 * t312 * t523
  t528 = t221 * t62 * t289
  t531 = t312 * t117
  t533 = t313 * t173 * t295
  t536 = t183 * t117
  t537 = t174 * t295
  t540 = t268 * t446
  t543 = t117 * t498
  t554 = t63 * t513
  t556 = 0.6e1 * t173 * t295 + 0.2e1 * t513 * t62 + 0.18e2 * t498 + 0.54e2 * t537 + 0.9e1 * t554
  t557 = t556 * t69
  t561 = t381 * t231
  t564 = t329 * t97
  t566 = 0.1e1 / t98 / t564
  t567 = t332 * t202
  t570 = t331 * t202
  t574 = 0.1e1 / t79 / t91
  t575 = s0 * t574
  t576 = t76 * t575
  t578 = t90 ** 2
  t582 = t88 * t89 / t78 / t578
  t584 = -0.68652008559670781893004115226337448559670781893004e1 * t576 - 0.66631034152449850453333333333333333333333333333333e0 * t582
  t588 = tau0 * t336
  t595 = -0.29177103637860082304526748971193415637860082304526e1 * t576 - 0.5e1 / 0.9e1 * (-0.23717844740740740740740740740740740740740740740741e1 * t588 - 0.54150879308641975308641975308641975308641975308643e0 * t575) * t71 * t75
  t598 = t357 * t217
  t601 = t213 * t364
  t607 = 0.1e1 / t113 / t564
  t608 = t112 * t607
  t611 = t202 * t346
  t616 = -0.66e2 / 0.125e3 * t566 * t567 + 0.18e2 / 0.25e2 * t570 * t346 - t189 * t584 / 0.5e1 + 0.7e1 / 0.9e1 * t595 * t114 - 0.14e2 / 0.15e2 * t598 * t202 + 0.98e2 / 0.75e2 * t601 * t332 - 0.14e2 / 0.15e2 * t360 * t346 - 0.392e3 / 0.375e3 * t608 * t567 + 0.98e2 / 0.75e2 * t365 * t611 - 0.14e2 / 0.45e2 * t218 * t584
  t628 = -0.440e3 / 0.27e2 * t588 + 0.154e3 / 0.27e2 * t575
  t629 = t628 * t71
  t635 = t75 * t410 * t412
  t638 = t404 * t424
  t643 = 0.1e1 / t137 / t408 / t136
  t644 = t132 * t643
  t645 = t412 * t253
  t659 = 0.22222222222222222222222222222222222222222222222222e0 * t629 * t133 + 0.74074074074074074074074074074074074074074074074076e0 * t400 * t85 * t250 + 0.12345679012345679012345679012345679012345679012346e0 * t249 * t87 * t628
  t663 = t629 * t241 / 0.4e1 - 0.3e1 / 0.8e1 * t401 * t405 + 0.9e1 / 0.16e2 * t240 * t635 - 0.3e1 / 0.8e1 * t240 * t638 - 0.27e2 / 0.32e2 * t644 * t645 + 0.81e2 / 0.80e2 * t411 * t253 * t424 - 0.9e1 / 0.40e2 * t246 * t659 - 0.308e3 / 0.243e3 * t576
  t666 = t663 * t62
  t674 = t257 * t295
  t681 = t142 * t513
  t688 = -0.42625e5 / 0.177147e6 * t582 - 0.1540e4 / 0.81e2 * t122 * t123 * t574 + 0.584e3 / 0.135e3 * t257 * t428 + 0.584e3 / 0.405e3 * t142 * t663 - 0.146e3 / 0.135e3 * t666 * t146 - 0.146e3 / 0.45e2 * t428 * t173 * t146 + 0.146e3 / 0.45e2 * t431 * t173 - 0.146e3 / 0.45e2 * t674 * t146 + 0.292e3 / 0.45e2 * t257 * t289 + 0.146e3 / 0.45e2 * t260 * t295 - 0.146e3 / 0.135e3 * t681 * t146 + 0.292e3 / 0.45e2 * t439 * t173 + 0.146e3 / 0.135e3 * t145 * t513
  t699 = t496 * t498
  t702 = t64 * t498
  t713 = 0.18e2 * t176 * t517 + 0.12e2 * t183 * t498 + 0.36e2 * t183 * t537 + 0.6e1 * t183 * t554 + 0.36e2 * t298 * t305 + 0.18e2 * t300 * t305 - 0.162e3 * t312 * t533 - 0.324e3 * t312 * t702 - 0.162e3 * t374 * t486 + 0.648e3 * t495 * t699 - t557
  t715 = -0.36e2 * t183 * t528 + 0.162e3 * t531 * t533 - 0.36e2 * t536 * t537 - 0.27e2 / 0.100e3 * t388 * t540 - 0.12e2 * t183 * t543 + 0.3e1 * t179 * t370 + t557 * t117 + 0.3e1 * t303 * t221 + 0.3e1 / 0.10e2 * t561 * t268 + t70 * t616 + 0.3e1 / 0.10e2 * t383 * t446 + t232 * t688 / 0.10e2 + t713 * t150
  t716 = t526 + t715
  t721 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t55 * t152 - 0.3e1 / 0.8e1 * t5 * t164 * t152 - 0.9e1 / 0.8e1 * t5 * t168 * t271 + t5 * t280 * t152 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t284 * t271 - 0.9e1 / 0.8e1 * t5 * t288 * t449 - 0.5e1 / 0.36e2 * t5 * t459 * t152 + t5 * t463 * t271 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t467 * t449 - 0.3e1 / 0.8e1 * t5 * t471 * t716)
  t723 = r1 <= f.p.dens_threshold
  t724 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t725 = 0.1e1 + t724
  t726 = t725 <= f.p.zeta_threshold
  t727 = t725 ** (0.1e1 / 0.3e1)
  t728 = t727 ** 2
  t730 = 0.1e1 / t728 / t725
  t732 = f.my_piecewise5(t14, 0, t10, 0, -t28)
  t733 = t732 ** 2
  t737 = 0.1e1 / t728
  t738 = t737 * t732
  t740 = f.my_piecewise5(t14, 0, t10, 0, -t40)
  t744 = f.my_piecewise5(t14, 0, t10, 0, -t48)
  t748 = f.my_piecewise3(t726, 0, -0.8e1 / 0.27e2 * t730 * t733 * t732 + 0.4e1 / 0.3e1 * t738 * t740 + 0.4e1 / 0.3e1 * t727 * t744)
  t754 = s2 / r1 / tau1 / 0.8e1
  t756 = f.my_piecewise3(t754 < 0.10e1, t754, 0.10e1)
  t757 = t756 ** 2
  t758 = t757 * t756
  t762 = (0.1e1 + t758) ** 2
  t764 = (t757 + 0.3e1 * t758) / t762
  t765 = r1 ** 2
  t766 = r1 ** (0.1e1 / 0.3e1)
  t767 = t766 ** 2
  t769 = 0.1e1 / t767 / t765
  t770 = s2 * t769
  t771 = t76 * t770
  t773 = s2 ** 2
  t774 = t765 ** 2
  t782 = (0.1e1 + 0.15045488888888888888888888888888888888888888888889e0 * t771 + 0.26899490462262948000000000000000000000000000000000e-2 * t88 * t773 / t766 / t774 / r1) ** (0.1e1 / 0.5e1)
  t787 = tau1 / t767 / r1
  t795 = t782 ** 2
  t811 = (t787 - t770 / 0.8e1) * t71
  t814 = 0.5e1 / 0.9e1 * t811 * t75 - 0.1e1
  t819 = jnp.sqrt(0.1e1 + 0.22222222222222222222222222222222222222222222222222e0 * t811 * t75 * t814)
  t824 = 0.9e1 / 0.20e2 * t814 / t819 + t771 / 0.36e2
  t825 = t824 ** 2
  t832 = (0.1e1 + 0.5e1 / 0.12e2 * (0.10e2 / 0.81e2 + 0.25e2 / 0.8748e4 * t771) * t71 * t75 * s2 * t769 + 0.292e3 / 0.405e3 * t825 - 0.146e3 / 0.135e3 * t824 * t756 * (0.1e1 - t756)) ** (0.1e1 / 0.10e2)
  t834 = t764 * (0.1e1 / t782 + 0.7e1 / 0.9e1 * (0.1e1 + 0.63943327777777777777777777777777777777777777777778e-1 * t771 - 0.5e1 / 0.9e1 * (0.14554132000000000000000000000000000000000000000000e0 * t787 + t106 + 0.11867481666666666666666666666666666666666666666667e-1 * t770) * t71 * t75) / t795) + (0.1e1 - t764) * t832
  t843 = f.my_piecewise3(t726, 0, 0.4e1 / 0.9e1 * t737 * t733 + 0.4e1 / 0.3e1 * t727 * t740)
  t850 = f.my_piecewise3(t726, 0, 0.4e1 / 0.3e1 * t727 * t732)
  t856 = f.my_piecewise3(t726, t454, t727 * t725)
  t862 = f.my_piecewise3(t723, 0, -0.3e1 / 0.8e1 * t5 * t748 * t54 * t834 - 0.3e1 / 0.8e1 * t5 * t843 * t163 * t834 + t5 * t850 * t279 * t834 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t856 * t458 * t834)
  t865 = 0.1e1 / t162 / t36
  t885 = t19 ** 2
  t888 = t30 ** 2
  t894 = t41 ** 2
  t903 = -0.24e2 * t45 + 0.24e2 * t16 / t44 / t6
  t904 = f.my_piecewise5(t10, 0, t14, 0, t903)
  t908 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t22 / t885 * t888 - 0.16e2 / 0.9e1 * t24 * t30 * t41 + 0.4e1 / 0.3e1 * t34 * t894 + 0.16e2 / 0.9e1 * t35 * t49 + 0.4e1 / 0.3e1 * t21 * t904)
  t924 = t329 ** 2
  t928 = t332 ** 2
  t934 = t346 ** 2
  t949 = 0.1e1 / t79 / t196
  t950 = s0 * t949
  t951 = t76 * t950
  t957 = t88 * t89 / t78 / t578 / r0
  t959 = 0.38902804850480109739368998628257887517146776406036e2 * t951 + 0.55525861793708208711111111111111111111111111111111e1 * t957
  t963 = tau0 * t574
  t993 = 0.6664e4 / 0.1875e4 * t112 / t113 / t924 * t928 - 0.784e3 / 0.125e3 * t608 * t332 * t346 + 0.98e2 / 0.75e2 * t365 * t934 + 0.392e3 / 0.225e3 * t365 * t202 * t584 + 0.196e3 / 0.75e2 * t357 * t364 * t332 - 0.1568e4 / 0.375e3 * t213 * t607 * t567 + 0.392e3 / 0.75e2 * t601 * t611 - t189 * t959 / 0.5e1 + 0.7e1 / 0.9e1 * (0.16533692061454046639231824417009602194787379972565e2 * t951 - 0.5e1 / 0.9e1 * (0.11068327545679012345679012345679012345679012345679e2 * t963 + 0.30685498274897119341563786008230452674897119341564e1 * t950) * t71 * t75) * t114 - 0.56e2 / 0.45e2 * t360 * t584 - 0.14e2 / 0.45e2 * t218 * t959 - 0.56e2 / 0.45e2 * t595 * t217 * t202 - 0.28e2 / 0.15e2 * t598 * t346 + 0.1056e4 / 0.625e3 / t98 / t924 * t928 - 0.396e3 / 0.125e3 * t566 * t332 * t346 + 0.18e2 / 0.25e2 * t331 * t934 + 0.24e2 / 0.25e2 * t570 * t584
  t999 = t389 ** 2
  t1006 = t446 ** 2
  t1009 = t295 ** 2
  t1017 = f.my_piecewise3(t61, 0.3e1 * s0 / t91 * t58, 0)
  t1020 = t289 * t295
  t1022 = t62 * t1009
  t1024 = t174 * t513
  t1026 = t63 * t1017
  t1029 = (0.2e1 * t1017 * t62 + 0.8e1 * t173 * t513 + 0.6e1 * t1009 + 0.108e3 * t1020 + 0.54e2 * t1022 + 0.72e2 * t1024 + 0.9e1 * t1026) * t69
  t1044 = 0.2e1 / 0.5e1 * t713 * t231 * t268 + 0.4e1 * t179 * t616 + t70 * t993 - 0.4959e4 / 0.10000e5 * t119 / t230 / t475 / t149 * t999 + 0.6e1 * t303 * t370 + 0.4e1 * t557 * t221 - 0.27e2 / 0.100e3 * t388 * t1006 + t1029 * t117 + 0.513e3 / 0.500e3 * t478 * t389 * t446 + 0.2e1 / 0.5e1 * t383 * t688 + 0.171e3 / 0.250e3 * t225 * t477 * t479 - 0.144e3 * t183 * t221 * t537 - 0.48e2 * t536 * t1024
  t1046 = t313 * t513 * t173
  t1050 = t64 * t289 * t295
  t1064 = t496 * t289 * t295
  t1086 = 0.216e3 * t531 * t1046 + 0.1944e4 * t531 * t1050 - 0.144e3 * t305 * t117 * t537 + 0.648e3 * t486 * t117 * t533 + 0.648e3 * t312 * t221 * t533 - 0.3888e4 * t495 * t117 * t1064 - 0.9e1 / 0.25e2 * t388 * t688 * t268 + 0.3e1 / 0.5e1 * t561 * t446 - 0.48e2 * t305 * t543 - 0.48e2 * t183 * t221 * t498 - 0.27e2 / 0.25e2 * t472 * t540 - 0.72e2 * t183 * t370 * t62 * t289 + 0.162e3 * t312 * t314 * t1009
  t1099 = t178 * t494
  t1114 = t302 * t311
  t1125 = -0.72e2 * t117 * t183 * t289 * t295 - 0.24e2 * t173 * t183 * t616 * t63 - 0.2592e4 * t221 * t495 * t496 * t498 + 0.324e3 * t289 * t312 * t313 * t370 - 0.36e2 * t1009 * t183 * t322 - 0.2592e4 * t1099 * t499 + 0.324e3 * t1114 * t315 - 0.72e2 * t305 * t503 - 0.72e2 * t305 * t506 - 0.24e2 * t305 * t514 - 0.72e2 * t319 * t517 - 0.36e2 * t326 * t517 + 0.648e3 * t486 * t490
  t1126 = t289 ** 2
  t1133 = t66 / t310 / t68
  t1134 = t313 ** 2
  t1139 = t556 * t182
  t1152 = t313 * t62
  t1171 = 0.6160e4 / 0.81e2 * t963 - 0.2618e4 / 0.81e2 * t950
  t1172 = t1171 * t71
  t1193 = t408 ** 2
  t1197 = t412 ** 2
  t1203 = t424 ** 2
  t1214 = t400 ** 2
  t1225 = t1172 * t241 / 0.4e1 - t629 * t405 / 0.2e1 + 0.9e1 / 0.8e1 * t401 * t635 - 0.3e1 / 0.4e1 * t401 * t638 - 0.15e2 / 0.8e1 * t240 * t75 * t643 * t645 + 0.9e1 / 0.4e1 * t240 * t75 * t410 * t253 * t424 - t240 * t404 * t659 / 0.2e1 + 0.189e3 / 0.64e2 * t132 / t137 / t1193 * t1197 - 0.81e2 / 0.16e2 * t644 * t412 * t424 + 0.81e2 / 0.80e2 * t411 * t1203 + 0.27e2 / 0.20e2 * t411 * t253 * t659 - 0.9e1 / 0.40e2 * t246 * (0.22222222222222222222222222222222222222222222222222e0 * t1172 * t133 + 0.98765432098765432098765432098765432098765432098768e0 * t628 * t85 * t250 + 0.74074074074074074074074074074074074074074074074076e0 * t1214 * t85 * t87 + 0.12345679012345679012345679012345679012345679012346e0 * t249 * t87 * t1171) + 0.5236e4 / 0.729e3 * t951
  t1260 = t428 ** 2
  t1267 = -0.146e3 / 0.135e3 * t1225 * t62 * t146 + 0.380875e6 / 0.177147e6 * t957 + 0.584e3 / 0.45e2 * t428 * t289 + 0.1168e4 / 0.135e3 * t681 * t173 + 0.292e3 / 0.45e2 * t142 * t1009 + 0.146e3 / 0.135e3 * t145 * t1017 - 0.584e3 / 0.135e3 * t257 * t513 * t146 + 0.1168e4 / 0.45e2 * t674 * t173 + 0.584e3 / 0.135e3 * t260 * t513 - 0.146e3 / 0.135e3 * t142 * t1017 * t146 - 0.292e3 / 0.45e2 * t428 * t295 * t146 + 0.292e3 / 0.45e2 * t431 * t295 - 0.584e3 / 0.135e3 * t663 * t173 * t146 + 0.584e3 / 0.135e3 * t666 * t173 + 0.584e3 / 0.405e3 * t142 * t1225 + 0.584e3 / 0.135e3 * t1260 + 0.2336e4 / 0.405e3 * t257 * t663 + 0.26180e5 / 0.243e3 * t122 * t123 * t949
  t1293 = -0.162e3 * t1009 * t312 * t313 + 0.7776e4 * t1126 * t1152 * t495 - 0.1080e4 * t1126 * t312 * t63 - 0.216e3 * t1046 * t312 - 0.1944e4 * t1050 * t312 + 0.3888e4 * t1064 * t495 + 0.72e2 * t298 * t517 + 0.144e3 * t305 * t537 - 0.648e3 * t486 * t533 - 0.1296e4 * t486 * t702 - t1029
  t1317 = -0.9720e4 * t1126 * t1133 * t1134 + 0.72e2 * t1020 * t183 + 0.36e2 * t1022 * t183 + 0.48e2 * t1024 * t183 + 0.6e1 * t1026 * t183 + 0.2592e4 * t1099 * t699 - 0.324e3 * t1114 * t374 + 0.24e2 * t1139 * t176 + 0.36e2 * t300 * t517 + 0.48e2 * t305 * t498 + 0.24e2 * t305 * t554
  t1320 = 0.1080e4 * t312 * t117 * t1126 * t63 + 0.9720e4 * t1133 * t117 * t1134 * t1126 - 0.24e2 * t1139 * t185 - 0.24e2 * t183 * t318 * t513 - 0.6e1 * t183 * t184 * t1017 + 0.1296e4 * t312 * t221 * t64 * t498 - 0.7776e4 * t495 * t117 * t1152 * t1126 - 0.36e2 * t183 * t502 * t295 - 0.72e2 * t517 * t323 - 0.144e3 * t305 * t528 + 0.1296e4 * t486 * t523 - 0.27e2 / 0.50e2 * t381 * t387 * t389 + t232 * t1267 / 0.10e2 + (t1293 + t1317) * t150
  t1343 = 0.10e2 / 0.27e2 * t5 * t456 * t865 * t152 - 0.5e1 / 0.9e1 * t5 * t277 * t458 * t152 + t5 * t161 * t279 * t152 / 0.2e1 - t5 * t53 * t163 * t152 / 0.2e1 - 0.9e1 / 0.4e1 * t5 * t168 * t449 - 0.3e1 / 0.8e1 * t5 * t908 * t54 * t152 - 0.3e1 / 0.2e1 * t5 * t55 * t271 - 0.3e1 / 0.2e1 * t5 * t164 * t271 - 0.3e1 / 0.8e1 * t5 * t471 * (t1044 + t1086 + t1125 + t1320) - 0.3e1 / 0.2e1 * t5 * t288 * t716 - 0.3e1 / 0.2e1 * t5 * t284 * t449 + t5 * t280 * t271 - t5 * t467 * t716 / 0.2e1 + t5 * t463 * t449 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t459 * t271
  t1344 = f.my_piecewise3(t1, 0, t1343)
  t1345 = t725 ** 2
  t1348 = t733 ** 2
  t1354 = t740 ** 2
  t1360 = f.my_piecewise5(t14, 0, t10, 0, -t903)
  t1364 = f.my_piecewise3(t726, 0, 0.40e2 / 0.81e2 / t728 / t1345 * t1348 - 0.16e2 / 0.9e1 * t730 * t733 * t740 + 0.4e1 / 0.3e1 * t737 * t1354 + 0.16e2 / 0.9e1 * t738 * t744 + 0.4e1 / 0.3e1 * t727 * t1360)
  t1386 = f.my_piecewise3(t723, 0, -0.3e1 / 0.8e1 * t5 * t1364 * t54 * t834 - t5 * t748 * t163 * t834 / 0.2e1 + t5 * t843 * t279 * t834 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t850 * t458 * t834 + 0.10e2 / 0.27e2 * t5 * t856 * t865 * t834)
  d1111 = 0.4e1 * t721 + 0.4e1 * t862 + t6 * (t1344 + t1386)

  res = {'v4rho4': d1111}
  return res
