"""Generated from mgga_x_tb09.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import jax.scipy.special as jsp_special
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_alpha_raw = params.alpha
  if isinstance(params_alpha_raw, (str, bytes, dict)):
    params_alpha = params_alpha_raw
  else:
    try:
      params_alpha_seq = list(params_alpha_raw)
    except TypeError:
      params_alpha = params_alpha_raw
    else:
      params_alpha_seq = np.asarray(params_alpha_seq, dtype=np.float64)
      params_alpha = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_seq))
  params_c_raw = params.c
  if isinstance(params_c_raw, (str, bytes, dict)):
    params_c = params_c_raw
  else:
    try:
      params_c_seq = list(params_c_raw)
    except TypeError:
      params_c = params_c_raw
    else:
      params_c_seq = np.asarray(params_c_seq, dtype=np.float64)
      params_c = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_seq))

  br89_min_Q = 5e-13

  br89_v = lambda x: -2 * jnp.pi ** (1 / 3) / X_FACTOR_C * jnp.exp(x / 3) * (1 - jnp.exp(-x) * (1 + x / 2)) / x

  params_gamma = 0.8

  tb09_c_HEG = (3 * params_c - 2) * jnp.sqrt(5 / 12) / jnp.pi

  br89_cQ = lambda Q: f.my_piecewise3(jnp.abs(Q) < br89_min_Q, f.my_piecewise3(Q > 0, br89_min_Q, -br89_min_Q), Q)

  br89_Q = lambda x, u, t: (u - 4 * params_gamma * t + params_gamma * x ** 2 / 2) / 6

  tb09_f = lambda rs, z, x, u, t: (params_c * X_FACTOR_C * br89_v(br89_x(br89_cQ(br89_Q(x, u, t)))) + tb09_c_HEG * jnp.sqrt(2 * jnp.maximum(t - params_alpha * x ** 2 / 8, 1e-10))) * f.n_spin(rs, z) ** (1 / 3)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1=None: tb09_f(rs, z, xs0, u0, t0)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_alpha_raw = params.alpha
  if isinstance(params_alpha_raw, (str, bytes, dict)):
    params_alpha = params_alpha_raw
  else:
    try:
      params_alpha_seq = list(params_alpha_raw)
    except TypeError:
      params_alpha = params_alpha_raw
    else:
      params_alpha_seq = np.asarray(params_alpha_seq, dtype=np.float64)
      params_alpha = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_seq))
  params_c_raw = params.c
  if isinstance(params_c_raw, (str, bytes, dict)):
    params_c = params_c_raw
  else:
    try:
      params_c_seq = list(params_c_raw)
    except TypeError:
      params_c = params_c_raw
    else:
      params_c_seq = np.asarray(params_c_seq, dtype=np.float64)
      params_c = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_seq))

  br89_min_Q = 5e-13

  br89_v = lambda x: -2 * jnp.pi ** (1 / 3) / X_FACTOR_C * jnp.exp(x / 3) * (1 - jnp.exp(-x) * (1 + x / 2)) / x

  params_gamma = 0.8

  tb09_c_HEG = (3 * params_c - 2) * jnp.sqrt(5 / 12) / jnp.pi

  br89_cQ = lambda Q: f.my_piecewise3(jnp.abs(Q) < br89_min_Q, f.my_piecewise3(Q > 0, br89_min_Q, -br89_min_Q), Q)

  br89_Q = lambda x, u, t: (u - 4 * params_gamma * t + params_gamma * x ** 2 / 2) / 6

  tb09_f = lambda rs, z, x, u, t: (params_c * X_FACTOR_C * br89_v(br89_x(br89_cQ(br89_Q(x, u, t)))) + tb09_c_HEG * jnp.sqrt(2 * jnp.maximum(t - params_alpha * x ** 2 / 8, 1e-10))) * f.n_spin(rs, z) ** (1 / 3)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1=None: tb09_f(rs, z, xs0, u0, t0)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = params.c * t4
  t6 = 2 ** (0.1e1 / 0.3e1)
  t7 = t6 ** 2
  t8 = l0 * t7
  t10 = 0.1e1 / t2 / r0
  t13 = tau0 * t7
  t14 = t13 * t10
  t16 = s0 * t7
  t17 = r0 ** 2
  t19 = 0.1e1 / t2 / t17
  t22 = t8 * t10 / 0.6e1 - 0.53333333333333333333333333333333333333333333333333e0 * t14 + 0.66666666666666666666666666666666666666666666666667e-1 * t16 * t19
  t23 = abs(t22)
  t24 = t23 < 0.50e-12
  t25 = 0.0e0 < t22
  t26 = f.my_piecewise3(t25, 0.50e-12, -0.50e-12)
  t27 = f.my_piecewise3(t24, t26, t22)
  t28 = br89_x(t27)
  t30 = jnp.exp(t28 / 0.3e1)
  t31 = jnp.exp(-t28)
  t34 = t31 * (0.1e1 + t28 / 0.2e1)
  t35 = 0.1e1 - t34
  t36 = t30 * t35
  t37 = 0.1e1 / t28
  t38 = t36 * t37
  t43 = jnp.sqrt(0.15e2)
  t44 = (0.3e1 * params.c - 0.2e1) * t43
  t45 = 0.1e1 / jnp.pi
  t46 = jnp.sqrt(0.2e1)
  t48 = params.alpha * s0
  t52 = t14 - t48 * t7 * t19 / 0.8e1
  t53 = 0.1e-9 < t52
  t54 = f.my_piecewise3(t53, t52, 0.1e-9)
  t55 = jnp.sqrt(t54)
  t63 = params.c * jnp.pi
  t64 = f.my_piecewise3(t25, 0, 0)
  t67 = t13 * t19
  t71 = 0.1e1 / t2 / t17 / r0
  t75 = f.my_piecewise3(t24, t64, -0.5e1 / 0.18e2 * t8 * t19 + 0.88888888888888888888888888888888888888888888888889e0 * t67 - 0.17777777777777777777777777777777777777777777777778e0 * t16 * t71)
  t76 = t27 ** 2
  t77 = 0.1e1 / t76
  t78 = t75 * t77
  t80 = jnp.exp(-0.2e1 / 0.3e1 * t28)
  t81 = 0.1e1 / t80
  t82 = t78 * t81
  t83 = t63 * t82
  t84 = t28 ** 2
  t86 = t84 - 0.2e1 * t28 + 0.3e1
  t87 = 0.1e1 / t86
  t88 = t28 - 0.2e1
  t89 = t88 ** 2
  t90 = t87 * t89
  t91 = t90 * t38
  t94 = t4 ** 2
  t95 = t94 * t75
  t96 = t77 * t81
  t97 = t95 * t96
  t98 = t90 * t34
  t100 = t95 * t77
  t101 = t81 * t87
  t103 = t101 * t89 * t31
  t107 = t30 * (t97 * t98 - t100 * t103 / 0.2e1)
  t108 = t107 * t37
  t111 = 0.1e1 / t84
  t112 = t36 * t111
  t113 = t63 * t112
  t114 = t101 * t89
  t115 = t78 * t114
  t118 = t44 * t45
  t120 = t46 / t55
  t126 = f.my_piecewise3(t53, -0.5e1 / 0.3e1 * t67 + t48 * t7 * t71 / 0.3e1, 0)
  t137 = t13 * t71
  t139 = t17 ** 2
  t141 = 0.1e1 / t2 / t139
  t145 = f.my_piecewise3(t24, t64, 0.20e2 / 0.27e2 * t8 * t71 - 0.23703703703703703703703703703703703703703703703704e1 * t137 + 0.65185185185185185185185185185185185185185185185186e0 * t16 * t141)
  t146 = t145 * t77
  t151 = t75 ** 2
  t153 = 0.1e1 / t76 / t27
  t154 = t151 * t153
  t160 = params.c * t94 * jnp.pi
  t161 = t76 ** 2
  t162 = 0.1e1 / t161
  t163 = t151 * t162
  t164 = t80 ** 2
  t165 = 0.1e1 / t164
  t167 = t160 * t163 * t165
  t168 = t86 ** 2
  t169 = 0.1e1 / t168
  t170 = t89 ** 2
  t171 = t169 * t170
  t175 = t169 * t89
  t184 = 0.2e1 * t28 * t94 * t75 * t96 * t90 - 0.2e1 * t100 * t114
  t189 = t89 * t88
  t190 = t169 * t189
  t200 = t94 * t145
  t203 = t94 * t151
  t209 = t4 * jnp.pi * t151
  t211 = t209 * t162 * t165
  t221 = t209 * t162
  t222 = t165 * t169
  t274 = t126 ** 2
  t283 = f.my_piecewise3(t53, 0.40e2 / 0.9e1 * t137 - 0.11e2 / 0.9e1 * t48 * t7 * t141, 0)
  t287 = -0.2e1 / 0.3e1 * t63 * t146 * t81 * t91 + 0.4e1 / 0.3e1 * t63 * t154 * t81 * t91 - 0.2e1 / 0.3e1 * t167 * t171 * t38 + 0.2e1 / 0.3e1 * t83 * t175 * t30 * t35 * t37 * t184 - 0.4e1 / 0.3e1 * t167 * t190 * t38 - 0.4e1 / 0.3e1 * t83 * t90 * t108 + 0.8e1 / 0.3e1 * t167 * t171 * t112 - 0.2e1 * t5 * t30 * (t200 * t96 * t98 - 0.2e1 * t203 * t153 * t81 * t98 - t211 * t171 * t34 / 0.3e1 - t97 * t175 * t34 * t184 + 0.2e1 * t211 * t190 * t34 + 0.2e1 / 0.3e1 * t221 * t222 * t170 * t31 - t200 * t77 * t103 / 0.2e1 + t203 * t153 * t103 + t97 * t175 * t31 * t184 / 0.2e1 - t221 * t222 * t189 * t31) * t37 + 0.4e1 * t63 * t107 * t111 * t115 - 0.4e1 * t160 * t36 / t84 / t28 * t163 * t222 * t170 + 0.2e1 * t113 * t146 * t114 - 0.4e1 * t113 * t154 * t114 - 0.2e1 * t113 * t82 * t175 * t184 + 0.4e1 * t160 * t112 * t163 * t222 * t189 - t118 * t46 / t55 / t54 * t274 / 0.24e2 + t118 * t120 * t283 / 0.12e2
  v2rho2_0_ = 0.2e1 / 0.9e1 / t2 * (-0.2e1 * t5 * t38 + t44 * t45 * t46 * t55 / 0.6e1) * t7 + 0.4e1 / 0.3e1 * t1 * (-0.2e1 / 0.3e1 * t83 * t91 - 0.2e1 * t5 * t108 + 0.2e1 * t113 * t115 + t118 * t120 * t126 / 0.12e2) * t7 + t1 * r0 * t287 * t7 / 0.2e1
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t4 = 0.1e1 / t2 / r0
  t5 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = params.c * t5
  t7 = 2 ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = l0 * t8
  t12 = tau0 * t8
  t13 = t12 * t4
  t15 = s0 * t8
  t16 = r0 ** 2
  t18 = 0.1e1 / t2 / t16
  t21 = t9 * t4 / 0.6e1 - 0.53333333333333333333333333333333333333333333333333e0 * t13 + 0.66666666666666666666666666666666666666666666666667e-1 * t15 * t18
  t22 = abs(t21)
  t23 = t22 < 0.50e-12
  t24 = 0.0e0 < t21
  t25 = f.my_piecewise3(t24, 0.50e-12, -0.50e-12)
  t26 = f.my_piecewise3(t23, t25, t21)
  t27 = br89_x(t26)
  t29 = jnp.exp(t27 / 0.3e1)
  t30 = jnp.exp(-t27)
  t33 = t30 * (0.1e1 + t27 / 0.2e1)
  t34 = 0.1e1 - t33
  t35 = t29 * t34
  t36 = 0.1e1 / t27
  t37 = t35 * t36
  t42 = jnp.sqrt(0.15e2)
  t43 = (0.3e1 * params.c - 0.2e1) * t42
  t44 = 0.1e1 / jnp.pi
  t45 = jnp.sqrt(0.2e1)
  t47 = params.alpha * s0
  t51 = t13 - t47 * t8 * t18 / 0.8e1
  t52 = 0.1e-9 < t51
  t53 = f.my_piecewise3(t52, t51, 0.1e-9)
  t54 = jnp.sqrt(t53)
  t63 = params.c * jnp.pi
  t64 = f.my_piecewise3(t24, 0, 0)
  t67 = t12 * t18
  t71 = 0.1e1 / t2 / t16 / r0
  t75 = f.my_piecewise3(t23, t64, -0.5e1 / 0.18e2 * t9 * t18 + 0.88888888888888888888888888888888888888888888888889e0 * t67 - 0.17777777777777777777777777777777777777777777777778e0 * t15 * t71)
  t76 = t26 ** 2
  t77 = 0.1e1 / t76
  t78 = t75 * t77
  t80 = jnp.exp(-0.2e1 / 0.3e1 * t27)
  t81 = 0.1e1 / t80
  t82 = t78 * t81
  t83 = t63 * t82
  t84 = t27 ** 2
  t86 = t84 - 0.2e1 * t27 + 0.3e1
  t87 = 0.1e1 / t86
  t88 = t27 - 0.2e1
  t89 = t88 ** 2
  t90 = t87 * t89
  t91 = t90 * t37
  t94 = t5 ** 2
  t95 = t94 * t75
  t96 = t77 * t81
  t97 = t95 * t96
  t98 = t90 * t33
  t100 = t95 * t77
  t101 = t81 * t87
  t103 = t101 * t89 * t30
  t106 = t97 * t98 - t100 * t103 / 0.2e1
  t107 = t29 * t106
  t108 = t107 * t36
  t111 = 0.1e1 / t84
  t112 = t35 * t111
  t113 = t63 * t112
  t114 = t101 * t89
  t115 = t78 * t114
  t118 = t43 * t44
  t120 = t45 / t54
  t126 = f.my_piecewise3(t52, -0.5e1 / 0.3e1 * t67 + t47 * t8 * t71 / 0.3e1, 0)
  t136 = t12 * t71
  t138 = t16 ** 2
  t140 = 0.1e1 / t2 / t138
  t144 = f.my_piecewise3(t23, t64, 0.20e2 / 0.27e2 * t9 * t71 - 0.23703703703703703703703703703703703703703703703704e1 * t136 + 0.65185185185185185185185185185185185185185185185186e0 * t15 * t140)
  t145 = t144 * t77
  t146 = t145 * t81
  t147 = t63 * t146
  t150 = t75 ** 2
  t152 = 0.1e1 / t76 / t26
  t153 = t150 * t152
  t154 = t153 * t81
  t155 = t63 * t154
  t159 = params.c * t94 * jnp.pi
  t160 = t76 ** 2
  t161 = 0.1e1 / t160
  t162 = t150 * t161
  t163 = t80 ** 2
  t164 = 0.1e1 / t163
  t165 = t162 * t164
  t166 = t159 * t165
  t167 = t86 ** 2
  t168 = 0.1e1 / t167
  t169 = t89 ** 2
  t170 = t168 * t169
  t171 = t170 * t37
  t174 = t168 * t89
  t175 = t174 * t29
  t176 = t34 * t36
  t177 = t27 * t94
  t179 = t96 * t90
  t183 = 0.2e1 * t177 * t75 * t179 - 0.2e1 * t100 * t114
  t184 = t176 * t183
  t185 = t175 * t184
  t188 = t89 * t88
  t189 = t168 * t188
  t190 = t189 * t37
  t193 = t90 * t108
  t196 = t170 * t112
  t199 = t94 * t144
  t200 = t199 * t96
  t202 = t94 * t150
  t203 = t152 * t81
  t204 = t202 * t203
  t207 = t5 * jnp.pi
  t208 = t207 * t150
  t209 = t161 * t164
  t210 = t208 * t209
  t211 = t170 * t33
  t214 = t33 * t183
  t215 = t174 * t214
  t217 = t189 * t33
  t220 = t208 * t161
  t221 = t164 * t168
  t222 = t169 * t30
  t223 = t221 * t222
  t226 = t199 * t77
  t229 = t202 * t152
  t231 = t30 * t183
  t232 = t174 * t231
  t236 = t221 * t188 * t30
  t239 = t29 * (t200 * t98 - 0.2e1 * t204 * t98 - t210 * t211 / 0.3e1 - t97 * t215 + 0.2e1 * t210 * t217 + 0.2e1 / 0.3e1 * t220 * t223 - t226 * t103 / 0.2e1 + t229 * t103 + t97 * t232 / 0.2e1 - t220 * t236)
  t240 = t239 * t36
  t243 = t107 * t111
  t244 = t63 * t243
  t248 = 0.1e1 / t84 / t27
  t249 = t35 * t248
  t250 = t159 * t249
  t251 = t221 * t169
  t252 = t162 * t251
  t255 = t145 * t114
  t258 = t153 * t114
  t261 = t174 * t183
  t262 = t82 * t261
  t265 = t159 * t112
  t266 = t221 * t188
  t267 = t162 * t266
  t272 = t45 / t54 / t53
  t273 = t126 ** 2
  t282 = f.my_piecewise3(t52, 0.40e2 / 0.9e1 * t136 - 0.11e2 / 0.9e1 * t47 * t8 * t140, 0)
  t286 = -0.2e1 / 0.3e1 * t147 * t91 + 0.4e1 / 0.3e1 * t155 * t91 - 0.2e1 / 0.3e1 * t166 * t171 + 0.2e1 / 0.3e1 * t83 * t185 - 0.4e1 / 0.3e1 * t166 * t190 - 0.4e1 / 0.3e1 * t83 * t193 + 0.8e1 / 0.3e1 * t166 * t196 - 0.2e1 * t6 * t240 + 0.4e1 * t244 * t115 - 0.4e1 * t250 * t252 + 0.2e1 * t113 * t255 - 0.4e1 * t113 * t258 - 0.2e1 * t113 * t262 + 0.4e1 * t265 * t267 - t118 * t272 * t273 / 0.24e2 + t118 * t120 * t282 / 0.12e2
  t292 = 0.1e1 / t167 / t86
  t293 = t292 * t169
  t297 = t199 * t203
  t298 = t30 * t75
  t302 = t150 * t75
  t303 = t94 * t302
  t308 = t292 * t89
  t309 = t183 ** 2
  t326 = t27 * t207 * t150
  t333 = t81 * t168 * t89 * t183
  t347 = 0.2e1 / 0.3e1 * t220 * t251 + 0.2e1 * t177 * t144 * t179 - 0.4e1 * t177 * t150 * t203 * t90 + 0.4e1 / 0.3e1 * t326 * t209 * t170 - 0.2e1 * t177 * t78 * t333 + 0.4e1 * t326 * t209 * t189 - 0.2e1 * t226 * t114 + 0.4e1 * t229 * t114 + 0.2e1 * t100 * t333 - 0.4e1 * t220 * t266
  t354 = t12 * t140
  t358 = 0.1e1 / t2 / t138 / r0
  t362 = f.my_piecewise3(t23, t64, -0.220e3 / 0.81e2 * t9 * t140 + 0.86913580246913580246913580246913580246913580246915e1 * t354 - 0.30419753086419753086419753086419753086419753086420e1 * t15 * t358)
  t363 = t94 * t362
  t367 = t207 * t144 * t209
  t371 = t207 * t302
  t373 = 0.1e1 / t160 / t26
  t375 = t371 * t373 * t164
  t380 = jnp.pi ** 2
  t381 = t380 * t302
  t383 = 0.1e1 / t160 / t76
  t385 = 0.1e1 / t163 / t80
  t387 = t381 * t383 * t385
  t388 = t169 * t88
  t389 = t292 * t388
  t396 = t292 * t188
  t400 = t169 * t89
  t401 = t292 * t400
  t408 = -0.2e1 * t210 * t293 * t231 + 0.3e1 * t297 * t90 * t298 + 0.6e1 * t303 * t161 * t81 * t98 - t97 * t308 * t30 * t309 + t200 * t232 - 0.2e1 * t204 * t232 + t97 * t174 * t30 * t347 / 0.2e1 + t363 * t96 * t98 + 0.2e1 * t367 * t170 * t298 + 0.2e1 * t375 * t211 - 0.12e2 * t375 * t217 - 0.2e1 / 0.3e1 * t387 * t389 * t33 + 0.6e1 * t387 * t293 * t33 + 0.3e1 * t210 * t396 * t231 - t387 * t401 * t33 / 0.9e1 - 0.3e1 * t367 * t189 * t298
  t412 = t381 * t383
  t413 = t385 * t292
  t421 = t371 * t373
  t440 = t33 * t75
  t458 = -0.3e1 * t303 * t161 * t103 + 0.10e2 / 0.3e1 * t412 * t413 * t388 * t30 - t363 * t77 * t103 / 0.2e1 - 0.4e1 * t421 * t223 + t412 * t413 * t400 * t30 / 0.18e2 - 0.3e1 * t412 * t413 * t222 + 0.6e1 * t421 * t236 + 0.2e1 * t97 * t308 * t33 * t309 - 0.6e1 * t210 * t396 * t214 - 0.6e1 * t297 * t90 * t440 - 0.2e1 * t200 * t215 - t367 * t170 * t440 + 0.4e1 * t204 * t215 + t210 * t293 * t214 - t97 * t174 * t33 * t347 + 0.6e1 * t367 * t189 * t440
  t464 = t293 * t29
  t465 = t34 * t111
  t475 = t144 * t161 * t164
  t500 = t144 * t152 * t81
  t516 = -0.2e1 * t6 * t29 * (t408 + t458) * t36 - 0.8e1 * t166 * t464 * t465 * t183 + 0.4e1 * t113 * t82 * t308 * t309 + 0.12e2 * t265 * t475 * t189 * t75 + 0.8e1 * t113 * t154 * t261 - 0.2e1 * t113 * t82 * t174 * t347 - 0.6e1 * t244 * t262 - 0.12e2 * t250 * t75 * t161 * t164 * t170 * t144 + 0.12e2 * t250 * t165 * t293 * t183 - 0.12e2 * t113 * t500 * t90 * t75 - 0.4e1 * t113 * t146 * t261 + 0.2e1 * t166 * t464 * t184 + 0.2e1 * t83 * t175 * t106 * t36 * t183
  t523 = t176 * t75
  t529 = t159 * t475
  t530 = t170 * t29
  t561 = t302 * t373
  t563 = t159 * t561 * t164
  t569 = params.c * t5 * t380
  t570 = t302 * t383
  t572 = t569 * t570 * t385
  t576 = 0.2e1 / 0.3e1 * t83 * t175 * t176 * t347 + 0.4e1 * t63 * t500 * t90 * t29 * t523 + 0.4e1 / 0.3e1 * t147 * t185 - 0.2e1 * t529 * t530 * t523 - 0.8e1 / 0.3e1 * t155 * t185 - 0.12e2 * t265 * t165 * t396 * t183 - 0.4e1 / 0.3e1 * t83 * t308 * t29 * t176 * t309 - 0.4e1 * t529 * t189 * t29 * t523 + 0.8e1 * t529 * t530 * t465 * t75 + 0.4e1 * t166 * t396 * t29 * t184 - t118 * t272 * t126 * t282 / 0.8e1 + 0.8e1 * t563 * t190 - 0.16e2 * t563 * t196 - 0.44e2 / 0.9e1 * t572 * t389 * t37
  t593 = t302 * t161
  t610 = t362 * t77
  t622 = 0.46e2 / 0.9e1 * t572 * t401 * t112 - 0.4e1 * t572 * t293 * t37 + 0.56e2 / 0.3e1 * t572 * t389 * t112 + 0.8e1 * t166 * t170 * t243 - 0.12e2 * t572 * t401 * t249 + 0.12e2 * t113 * t593 * t114 - 0.12e2 * t244 * t258 + 0.24e2 * t250 * t561 * t251 + 0.6e1 * t63 * t239 * t111 * t115 - 0.4e1 * t63 * t593 * t81 * t91 + 0.2e1 * t113 * t610 * t114 + 0.6e1 * t244 * t255 - 0.4e1 * t166 * t189 * t108 - 0.2e1 * t83 * t90 * t240
  t646 = t84 ** 2
  t667 = t53 ** 2
  t680 = f.my_piecewise3(t52, -0.440e3 / 0.27e2 * t354 + 0.154e3 / 0.27e2 * t47 * t8 * t358, 0)
  t684 = -0.2e1 / 0.3e1 * t63 * t610 * t81 * t91 - 0.2e1 * t147 * t193 + 0.4e1 * t155 * t193 + 0.4e1 * t563 * t171 - 0.2e1 * t166 * t170 * t108 - 0.10e2 / 0.9e1 * t572 * t401 * t37 - 0.12e2 * t159 * t107 * t248 * t252 + 0.12e2 * t159 * t243 * t267 + 0.12e2 * t569 * t35 / t646 * t570 * t413 * t400 - 0.24e2 * t569 * t249 * t570 * t413 * t388 - 0.24e2 * t265 * t561 * t266 + 0.12e2 * t569 * t112 * t570 * t413 * t169 + t118 * t45 / t54 / t667 * t273 * t126 / 0.16e2 + t118 * t120 * t680 / 0.12e2
  v3rho3_0_ = -0.4e1 / 0.27e2 * t4 * (-0.2e1 * t6 * t37 + t43 * t44 * t45 * t54 / 0.6e1) * t8 + 0.2e1 / 0.3e1 / t2 * (-0.2e1 / 0.3e1 * t83 * t91 - 0.2e1 * t6 * t108 + 0.2e1 * t113 * t115 + t118 * t120 * t126 / 0.12e2) * t8 + 0.2e1 * t1 * t286 * t8 + t1 * r0 * (t516 + t576 + t622 + t684) * t8 / 0.2e1

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** 2
  t2 = r0 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t5 = 0.1e1 / t3 / t1
  t6 = jnp.pi ** (0.1e1 / 0.3e1)
  t7 = params.c * t6
  t8 = 2 ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t10 = l0 * t9
  t12 = 0.1e1 / t3 / r0
  t15 = tau0 * t9
  t16 = t15 * t12
  t18 = s0 * t9
  t21 = t10 * t12 / 0.6e1 - 0.53333333333333333333333333333333333333333333333333e0 * t16 + 0.66666666666666666666666666666666666666666666666667e-1 * t18 * t5
  t22 = abs(t21)
  t23 = t22 < 0.50e-12
  t24 = 0.0e0 < t21
  t25 = f.my_piecewise3(t24, 0.50e-12, -0.50e-12)
  t26 = f.my_piecewise3(t23, t25, t21)
  t27 = br89_x(t26)
  t29 = jnp.exp(t27 / 0.3e1)
  t30 = jnp.exp(-t27)
  t32 = 0.1e1 + t27 / 0.2e1
  t33 = t30 * t32
  t34 = 0.1e1 - t33
  t35 = t29 * t34
  t36 = 0.1e1 / t27
  t37 = t35 * t36
  t42 = jnp.sqrt(0.15e2)
  t43 = (0.3e1 * params.c - 0.2e1) * t42
  t44 = 0.1e1 / jnp.pi
  t45 = jnp.sqrt(0.2e1)
  t47 = params.alpha * s0
  t51 = t16 - t47 * t9 * t5 / 0.8e1
  t52 = 0.1e-9 < t51
  t53 = f.my_piecewise3(t52, t51, 0.1e-9)
  t54 = jnp.sqrt(t53)
  t62 = params.c * jnp.pi
  t63 = f.my_piecewise3(t24, 0, 0)
  t66 = t15 * t5
  t70 = 0.1e1 / t3 / t1 / r0
  t74 = f.my_piecewise3(t23, t63, -0.5e1 / 0.18e2 * t10 * t5 + 0.88888888888888888888888888888888888888888888888889e0 * t66 - 0.17777777777777777777777777777777777777777777777778e0 * t18 * t70)
  t75 = t26 ** 2
  t76 = 0.1e1 / t75
  t77 = t74 * t76
  t79 = jnp.exp(-0.2e1 / 0.3e1 * t27)
  t80 = 0.1e1 / t79
  t81 = t77 * t80
  t82 = t62 * t81
  t83 = t27 ** 2
  t85 = t83 - 0.2e1 * t27 + 0.3e1
  t86 = 0.1e1 / t85
  t87 = t27 - 0.2e1
  t88 = t87 ** 2
  t89 = t86 * t88
  t90 = t89 * t37
  t93 = t6 ** 2
  t94 = t93 * t74
  t95 = t76 * t80
  t96 = t94 * t95
  t97 = t89 * t33
  t99 = t94 * t76
  t100 = t80 * t86
  t101 = t88 * t30
  t102 = t100 * t101
  t105 = t96 * t97 - t99 * t102 / 0.2e1
  t106 = t29 * t105
  t107 = t106 * t36
  t110 = 0.1e1 / t83
  t111 = t35 * t110
  t112 = t62 * t111
  t113 = t100 * t88
  t114 = t77 * t113
  t117 = t43 * t44
  t119 = t45 / t54
  t125 = f.my_piecewise3(t52, -0.5e1 / 0.3e1 * t66 + t47 * t9 * t70 / 0.3e1, 0)
  t136 = t15 * t70
  t138 = t1 ** 2
  t140 = 0.1e1 / t3 / t138
  t144 = f.my_piecewise3(t23, t63, 0.20e2 / 0.27e2 * t10 * t70 - 0.23703703703703703703703703703703703703703703703704e1 * t136 + 0.65185185185185185185185185185185185185185185185186e0 * t18 * t140)
  t145 = t144 * t76
  t146 = t145 * t80
  t147 = t62 * t146
  t150 = t74 ** 2
  t151 = t75 * t26
  t152 = 0.1e1 / t151
  t153 = t150 * t152
  t154 = t153 * t80
  t155 = t62 * t154
  t159 = params.c * t93 * jnp.pi
  t160 = t75 ** 2
  t161 = 0.1e1 / t160
  t162 = t150 * t161
  t163 = t79 ** 2
  t164 = 0.1e1 / t163
  t165 = t162 * t164
  t166 = t159 * t165
  t167 = t85 ** 2
  t168 = 0.1e1 / t167
  t169 = t88 ** 2
  t170 = t168 * t169
  t171 = t170 * t37
  t174 = t168 * t88
  t175 = t174 * t29
  t176 = t34 * t36
  t177 = t27 * t93
  t179 = t95 * t89
  t183 = 0.2e1 * t177 * t74 * t179 - 0.2e1 * t99 * t113
  t184 = t176 * t183
  t185 = t175 * t184
  t188 = t88 * t87
  t189 = t168 * t188
  t190 = t189 * t37
  t193 = t89 * t107
  t196 = t170 * t111
  t199 = t93 * t144
  t200 = t199 * t95
  t202 = t93 * t150
  t203 = t152 * t80
  t204 = t202 * t203
  t207 = t6 * jnp.pi
  t208 = t207 * t150
  t209 = t161 * t164
  t210 = t208 * t209
  t211 = t170 * t33
  t214 = t33 * t183
  t215 = t174 * t214
  t217 = t189 * t33
  t220 = t208 * t161
  t221 = t164 * t168
  t222 = t169 * t30
  t223 = t221 * t222
  t226 = t199 * t76
  t229 = t202 * t152
  t231 = t30 * t183
  t232 = t174 * t231
  t235 = t188 * t30
  t236 = t221 * t235
  t238 = t200 * t97 - 0.2e1 * t204 * t97 - t210 * t211 / 0.3e1 - t96 * t215 + 0.2e1 * t210 * t217 + 0.2e1 / 0.3e1 * t220 * t223 - t226 * t102 / 0.2e1 + t229 * t102 + t96 * t232 / 0.2e1 - t220 * t236
  t239 = t29 * t238
  t240 = t239 * t36
  t243 = t106 * t110
  t244 = t62 * t243
  t248 = 0.1e1 / t83 / t27
  t249 = t35 * t248
  t250 = t159 * t249
  t251 = t221 * t169
  t252 = t162 * t251
  t255 = t145 * t113
  t258 = t153 * t113
  t261 = t174 * t183
  t262 = t81 * t261
  t265 = t159 * t111
  t266 = t221 * t188
  t267 = t162 * t266
  t272 = t45 / t54 / t53
  t273 = t125 ** 2
  t282 = f.my_piecewise3(t52, 0.40e2 / 0.9e1 * t136 - 0.11e2 / 0.9e1 * t47 * t9 * t140, 0)
  t286 = -0.2e1 / 0.3e1 * t147 * t90 + 0.4e1 / 0.3e1 * t155 * t90 - 0.2e1 / 0.3e1 * t166 * t171 + 0.2e1 / 0.3e1 * t82 * t185 - 0.4e1 / 0.3e1 * t166 * t190 - 0.4e1 / 0.3e1 * t82 * t193 + 0.8e1 / 0.3e1 * t166 * t196 - 0.2e1 * t7 * t240 + 0.4e1 * t244 * t114 - 0.4e1 * t250 * t252 + 0.2e1 * t112 * t255 - 0.4e1 * t112 * t258 - 0.2e1 * t112 * t262 + 0.4e1 * t265 * t267 - t117 * t272 * t273 / 0.24e2 + t117 * t119 * t282 / 0.12e2
  t291 = 0.1e1 / t167 / t85
  t292 = t291 * t88
  t293 = t183 ** 2
  t294 = t30 * t293
  t295 = t292 * t294
  t297 = t150 * t74
  t298 = t93 * t297
  t299 = t161 * t80
  t300 = t298 * t299
  t303 = t207 * t297
  t305 = 0.1e1 / t160 / t26
  t306 = t305 * t164
  t307 = t303 * t306
  t310 = jnp.pi ** 2
  t311 = t310 * t297
  t313 = 0.1e1 / t160 / t75
  t315 = 0.1e1 / t163 / t79
  t316 = t313 * t315
  t317 = t311 * t316
  t318 = t169 * t88
  t319 = t291 * t318
  t320 = t319 * t33
  t323 = t207 * t144
  t324 = t323 * t209
  t325 = t30 * t74
  t326 = t189 * t325
  t329 = t291 * t169
  t330 = t329 * t231
  t333 = t199 * t203
  t334 = t89 * t325
  t349 = t27 * t207
  t350 = t349 * t150
  t354 = t177 * t77
  t355 = t80 * t168
  t356 = t88 * t183
  t357 = t355 * t356
  t371 = 0.2e1 / 0.3e1 * t220 * t251 + 0.2e1 * t177 * t144 * t179 - 0.4e1 * t177 * t150 * t203 * t89 + 0.4e1 / 0.3e1 * t350 * t209 * t170 - 0.2e1 * t354 * t357 + 0.4e1 * t350 * t209 * t189 - 0.2e1 * t226 * t113 + 0.4e1 * t229 * t113 + 0.2e1 * t99 * t357 - 0.4e1 * t220 * t266
  t372 = t30 * t371
  t373 = t174 * t372
  t378 = t15 * t140
  t382 = 0.1e1 / t3 / t138 / r0
  t386 = f.my_piecewise3(t23, t63, -0.220e3 / 0.81e2 * t10 * t140 + 0.86913580246913580246913580246913580246913580246915e1 * t378 - 0.30419753086419753086419753086419753086419753086420e1 * t18 * t382)
  t387 = t93 * t386
  t388 = t387 * t95
  t390 = t170 * t325
  t395 = t169 * t87
  t396 = t291 * t395
  t397 = t396 * t33
  t400 = t329 * t33
  t403 = t291 * t188
  t404 = t403 * t231
  t407 = -t96 * t295 + 0.6e1 * t300 * t97 + 0.2e1 * t307 * t211 - t317 * t320 / 0.9e1 - 0.3e1 * t324 * t326 - 0.2e1 * t210 * t330 + 0.3e1 * t333 * t334 + t200 * t232 - 0.2e1 * t204 * t232 + t96 * t373 / 0.2e1 + t388 * t97 + 0.2e1 * t324 * t390 - 0.12e2 * t307 * t217 - 0.2e1 / 0.3e1 * t317 * t397 + 0.6e1 * t317 * t400 + 0.3e1 * t210 * t404
  t408 = t298 * t161
  t411 = t311 * t313
  t412 = t315 * t291
  t413 = t395 * t30
  t414 = t412 * t413
  t417 = t387 * t76
  t420 = t303 * t305
  t423 = t318 * t30
  t424 = t412 * t423
  t427 = t412 * t222
  t432 = t329 * t214
  t434 = t33 * t371
  t435 = t174 * t434
  t437 = t33 * t74
  t438 = t89 * t437
  t443 = t170 * t437
  t447 = t33 * t293
  t448 = t292 * t447
  t451 = t403 * t214
  t454 = t189 * t437
  t457 = -0.3e1 * t408 * t102 + 0.10e2 / 0.3e1 * t411 * t414 - t417 * t102 / 0.2e1 - 0.4e1 * t420 * t223 + t411 * t424 / 0.18e2 - 0.3e1 * t411 * t427 + 0.6e1 * t420 * t236 + t210 * t432 - t96 * t435 - 0.6e1 * t333 * t438 - 0.2e1 * t200 * t215 - t324 * t443 + 0.4e1 * t204 * t215 + 0.2e1 * t96 * t448 - 0.6e1 * t210 * t451 + 0.6e1 * t324 * t454
  t459 = t29 * (t407 + t457)
  t460 = t459 * t36
  t463 = t53 ** 2
  t466 = t45 / t54 / t463
  t476 = f.my_piecewise3(t52, -0.440e3 / 0.27e2 * t378 + 0.154e3 / 0.27e2 * t47 * t9 * t382, 0)
  t480 = t386 * t76
  t481 = t480 * t80
  t482 = t62 * t481
  t489 = t297 * t305
  t490 = t489 * t164
  t491 = t159 * t490
  t494 = t170 * t107
  t498 = params.c * t6 * t310
  t499 = t297 * t313
  t500 = t499 * t315
  t501 = t498 * t500
  t502 = t319 * t37
  t505 = t106 * t248
  t506 = t159 * t505
  t513 = t89 * t240
  t516 = t159 * t243
  t519 = -0.2e1 * t7 * t460 + t117 * t466 * t273 * t125 / 0.16e2 + t117 * t119 * t476 / 0.12e2 - 0.2e1 / 0.3e1 * t482 * t90 - 0.2e1 * t147 * t193 + 0.4e1 * t155 * t193 + 0.4e1 * t491 * t171 - 0.2e1 * t166 * t494 - 0.10e2 / 0.9e1 * t501 * t502 - 0.12e2 * t506 * t252 - t117 * t272 * t125 * t282 / 0.8e1 - 0.2e1 * t82 * t513 + 0.12e2 * t516 * t267
  t520 = t83 ** 2
  t521 = 0.1e1 / t520
  t522 = t35 * t521
  t523 = t498 * t522
  t524 = t412 * t318
  t525 = t499 * t524
  t528 = t498 * t249
  t529 = t412 * t395
  t530 = t499 * t529
  t533 = t489 * t266
  t536 = t498 * t111
  t537 = t412 * t169
  t538 = t499 * t537
  t545 = t396 * t37
  t548 = t319 * t111
  t551 = t329 * t37
  t554 = t396 * t111
  t557 = t170 * t243
  t560 = t319 * t249
  t563 = t297 * t161
  t564 = t563 * t113
  t569 = 0.12e2 * t523 * t525 - 0.24e2 * t528 * t530 - 0.24e2 * t265 * t533 + 0.12e2 * t536 * t538 + 0.8e1 * t491 * t190 - 0.16e2 * t491 * t196 - 0.44e2 / 0.9e1 * t501 * t545 + 0.46e2 / 0.9e1 * t501 * t548 - 0.4e1 * t501 * t551 + 0.56e2 / 0.3e1 * t501 * t554 + 0.8e1 * t166 * t557 - 0.12e2 * t501 * t560 + 0.12e2 * t112 * t564 - 0.12e2 * t244 * t258
  t571 = t489 * t251
  t574 = t239 * t110
  t575 = t62 * t574
  t578 = t563 * t80
  t579 = t62 * t578
  t582 = t480 * t113
  t587 = t189 * t107
  t590 = t329 * t29
  t591 = t590 * t184
  t594 = t105 * t36
  t595 = t594 * t183
  t596 = t175 * t595
  t599 = t176 * t371
  t600 = t175 * t599
  t603 = t144 * t152
  t604 = t603 * t80
  t605 = t62 * t604
  t606 = t89 * t29
  t607 = t176 * t74
  t608 = t606 * t607
  t613 = t144 * t161
  t614 = t613 * t164
  t615 = t159 * t614
  t616 = t170 * t29
  t617 = t616 * t607
  t622 = t403 * t183
  t623 = t165 * t622
  t626 = 0.24e2 * t250 * t571 + 0.6e1 * t575 * t114 - 0.4e1 * t579 * t90 + 0.2e1 * t112 * t582 + 0.6e1 * t244 * t255 - 0.4e1 * t166 * t587 + 0.2e1 * t166 * t591 + 0.2e1 * t82 * t596 + 0.2e1 / 0.3e1 * t82 * t600 + 0.4e1 * t605 * t608 + 0.4e1 / 0.3e1 * t147 * t185 - 0.2e1 * t615 * t617 - 0.8e1 / 0.3e1 * t155 * t185 - 0.12e2 * t265 * t623
  t627 = t292 * t29
  t628 = t176 * t293
  t629 = t627 * t628
  t632 = t189 * t29
  t633 = t632 * t607
  t636 = t34 * t110
  t637 = t636 * t74
  t638 = t616 * t637
  t641 = t403 * t29
  t642 = t641 * t184
  t645 = t636 * t183
  t646 = t590 * t645
  t649 = t292 * t293
  t650 = t81 * t649
  t653 = t189 * t74
  t654 = t614 * t653
  t657 = t154 * t261
  t660 = t174 * t371
  t661 = t81 * t660
  t667 = t74 * t161 * t164
  t668 = t170 * t144
  t669 = t667 * t668
  t672 = t329 * t183
  t673 = t165 * t672
  t676 = t89 * t74
  t677 = t604 * t676
  t680 = t146 * t261
  t683 = -0.4e1 / 0.3e1 * t82 * t629 - 0.4e1 * t615 * t633 + 0.8e1 * t615 * t638 + 0.4e1 * t166 * t642 - 0.8e1 * t166 * t646 + 0.4e1 * t112 * t650 + 0.12e2 * t265 * t654 + 0.8e1 * t112 * t657 - 0.2e1 * t112 * t661 - 0.6e1 * t244 * t262 - 0.12e2 * t250 * t669 + 0.12e2 * t250 * t673 - 0.12e2 * t112 * t677 - 0.4e1 * t112 * t680
  t690 = t167 ** 2
  t691 = 0.1e1 / t690
  t692 = t691 * t169
  t697 = t310 * t144 * t316
  t698 = t33 * t150
  t702 = t691 * t395
  t709 = t323 * t306
  t713 = t325 * t183
  t732 = t691 * t88
  t733 = t293 * t183
  t747 = t691 * t318
  t753 = t150 ** 2
  t754 = t207 * t753
  t755 = t754 * t313
  t759 = t93 * t310 * t753
  t760 = t160 ** 2
  t761 = 0.1e1 / t760
  t762 = t759 * t761
  t763 = t163 ** 2
  t764 = 0.1e1 / t763
  t765 = t764 * t691
  t766 = t169 * t188
  t773 = t15 * t382
  t777 = 0.1e1 / t3 / t138 / t1
  t781 = f.my_piecewise3(t23, t63, 0.3080e4 / 0.243e3 * t10 * t382 - 0.40559670781893004115226337448559670781893004115227e2 * t773 + 0.17237860082304526748971193415637860082304526748971e2 * t18 * t777)
  t782 = t93 * t781
  t786 = -0.18e2 * t300 * t215 - 0.12e2 * t204 * t448 - 0.6e1 * t96 * t732 * t33 * t733 + 0.36e2 * t199 * t299 * t89 * t698 + 0.6e1 * t200 * t448 + 0.4e1 / 0.3e1 * t210 * t329 * t434 + 0.2e1 / 0.3e1 * t317 * t747 * t214 - 0.3e1 * t200 * t435 + 0.24e2 * t755 * t223 + 0.10e2 / 0.3e1 * t762 * t765 * t766 * t30 - t782 * t76 * t102 / 0.2e1
  t788 = t144 ** 2
  t789 = t207 * t788
  t790 = t789 * t161
  t801 = t93 * t788
  t805 = t310 * t753
  t807 = 0.1e1 / t160 / t151
  t808 = t805 * t807
  t817 = t93 * t753
  t821 = t164 * t291
  t823 = t821 * t169 * t183
  t832 = t355 * t88 * t371
  t837 = t100 * t88 * t74
  t842 = t349 * t297
  t847 = t27 * t310 * t297
  t864 = t188 * t183
  t865 = t821 * t864
  t870 = t221 * t188 * t74
  t875 = t80 * t291 * t88 * t293
  t878 = t207 * t74
  t880 = t169 * t144
  t884 = -0.2e1 * t220 * t823 + 0.2e1 * t177 * t386 * t179 - 0.8e1 * t229 * t357 + 0.2e1 * t99 * t832 + 0.12e2 * t199 * t152 * t837 + 0.4e1 * t226 * t357 - 0.8e1 * t842 * t306 * t170 + 0.16e2 / 0.9e1 * t847 * t316 * t319 + 0.12e2 * t177 * t297 * t299 * t89 - 0.24e2 * t842 * t306 * t189 + 0.32e2 / 0.3e1 * t847 * t316 * t396 + 0.12e2 * t847 * t316 * t329 + 0.12e2 * t220 * t865 - 0.12e2 * t323 * t161 * t870 - 0.4e1 * t99 * t875 + 0.2e1 * t878 * t161 * t221 * t880
  t899 = t349 * t613
  t902 = t349 * t162
  t924 = -0.12e2 * t408 * t113 - 0.2e1 * t417 * t113 + 0.20e2 / 0.9e1 * t411 * t524 - 0.12e2 * t411 * t537 + 0.4e1 / 0.3e1 * t411 * t529 + 0.24e2 * t420 * t266 - 0.4e1 * t420 * t251 + 0.12e2 * t899 * t870 - 0.12e2 * t902 * t865 + 0.4e1 * t354 * t875 - 0.12e2 * t177 * t603 * t837 - 0.4e1 * t177 * t145 * t357 + 0.4e1 * t899 * t221 * t169 * t74 + 0.8e1 * t177 * t153 * t357 - 0.4e1 * t902 * t823 - 0.2e1 * t354 * t832
  t925 = t884 + t924
  t929 = 0.2e1 * t790 * t223 - 0.36e2 * t755 * t236 + 0.50e2 / 0.3e1 * t762 * t765 * t423 - 0.12e2 * t762 * t765 * t413 + 0.3e1 * t801 * t152 * t102 - 0.2e1 / 0.3e1 * t808 * t424 - 0.3e1 * t790 * t236 + 0.36e2 * t808 * t427 - 0.40e2 * t808 * t414 + 0.12e2 * t817 * t305 * t102 - t96 * t174 * t33 * t925
  t935 = t207 * t386 * t209
  t946 = t387 * t203
  t959 = t691 * t188
  t963 = -0.3e1 * t96 * t292 * t231 * t371 + 0.8e1 * t935 * t454 - 0.28e2 / 0.3e1 * t324 * t329 * t713 - 0.4e1 / 0.3e1 * t935 * t443 - 0.2e1 / 0.3e1 * t697 * t319 * t698 - 0.8e1 * t946 * t438 + 0.12e2 * t709 * t170 * t698 - 0.3e1 * t388 * t215 - 0.4e1 * t697 * t396 * t698 + 0.56e2 * t307 * t451 + 0.22e2 * t210 * t959 * t447
  t966 = t209 * t291
  t968 = t32 * t183
  t969 = t968 * t74
  t978 = t95 * t291
  t985 = t203 * t168
  t994 = t789 * t209
  t1002 = t759 * t761 * t764
  t1003 = t169 ** 2
  t1004 = t691 * t1003
  t1009 = t754 * t313 * t164
  t1013 = t805 * t807 * t315
  t1016 = -0.28e2 * t323 * t966 * t235 * t969 + 0.14e2 / 0.3e1 * t878 * t966 * t222 * t968 * t144 + 0.6e1 * t94 * t978 * t101 * t32 * t371 * t183 + 0.18e2 * t199 * t985 * t101 * t969 - 0.24e2 * t817 * t305 * t80 * t97 + 0.6e1 * t994 * t217 - t994 * t211 - 0.6e1 * t801 * t203 * t97 - t1002 * t1004 * t33 / 0.9e1 - 0.12e2 * t1009 * t211 + 0.4e1 / 0.3e1 * t1013 * t320
  t1019 = t30 * t144
  t1046 = t30 * t150
  t1050 = -0.18e2 * t310 * t150 * t316 * t329 * t1019 + 0.18e2 * t317 * t692 * t231 + 0.36e2 * t208 * t306 * t189 * t1019 - 0.28e2 * t307 * t404 - 0.3e1 * t200 * t295 + 0.4e1 * t946 * t334 + 0.3e1 / 0.2e1 * t388 * t232 + 0.8e1 / 0.3e1 * t935 * t390 + 0.22e2 / 0.3e1 * t210 * t692 * t294 - 0.20e2 * t317 * t702 * t231 + 0.20e2 * t697 * t396 * t1046
  t1083 = -0.18e2 * t202 * t299 * t89 * t1019 + 0.9e1 * t300 * t232 - 0.8e1 / 0.3e1 * t210 * t329 * t372 - 0.24e2 * t709 * t170 * t1046 + t697 * t319 * t1046 / 0.3e1 + 0.56e2 / 0.3e1 * t307 * t330 + t96 * t174 * t30 * t925 / 0.2e1 + 0.6e1 * t204 * t295 + 0.3e1 * t96 * t732 * t30 * t733 + 0.3e1 / 0.2e1 * t200 * t373 - 0.3e1 * t204 * t373
  t1096 = t691 * t766
  t1113 = -0.4e1 * t935 * t326 - t317 * t747 * t231 / 0.3e1 - 0.11e2 * t210 * t959 * t294 + 0.72e2 * t1009 * t217 + 0.8e1 * t1013 * t397 - 0.4e1 / 0.3e1 * t1002 * t1096 * t33 + 0.4e1 * t210 * t403 * t372 - 0.72e2 * t1013 * t400 + 0.8e1 / 0.3e1 * t1002 * t747 * t33 + 0.24e2 * t1002 * t702 * t33 + t782 * t95 * t97
  t1122 = t386 * t161 * t164
  t1123 = t159 * t1122
  t1126 = t105 * t110
  t1140 = t747 * t29
  t1154 = t386 * t152 * t80
  t1176 = f.my_piecewise3(t52, 0.6160e4 / 0.81e2 * t773 - 0.2618e4 / 0.81e2 * t47 * t9 * t777, 0)
  t1180 = t282 ** 2
  t1188 = t273 ** 2
  t1197 = -0.16e2 * t112 * t1154 * t676 - 0.8e1 * t244 * t661 - 0.6e1 * t112 * t146 * t660 - 0.2e1 * t112 * t81 * t174 * t925 - 0.12e2 * t575 * t262 + 0.12e2 * t579 * t185 + t117 * t119 * t1176 / 0.12e2 - t117 * t272 * t1180 / 0.8e1 - 0.5e1 / 0.32e2 * t117 * t45 / t54 / t463 / t53 * t1188 + 0.8e1 * t155 * t629 + 0.112e3 * t265 * t490 * t622
  t1211 = t781 * t76
  t1231 = params.c * t310 * jnp.pi
  t1232 = t753 * t761
  t1234 = t1231 * t1232 * t764
  t1238 = t594 * t74
  t1243 = t144 * t305 * t164
  t1244 = t159 * t1243
  t1245 = t176 * t150
  t1269 = -0.70e2 / 0.27e2 * t1234 * t1004 * t37 - 0.8e1 * t615 * t616 * t1238 + 0.24e2 * t1244 * t616 * t1245 + 0.2e1 * t482 * t185 - 0.8e1 / 0.3e1 * t1123 * t617 + 0.16e2 / 0.3e1 * t62 * t1154 * t608 + 0.16e2 * t605 * t606 * t1238 - 0.4e1 * t155 * t600 - 0.56e2 / 0.3e1 * t491 * t591 - 0.48e2 * t516 * t623 - 0.16e2 * t265 * t165 * t403 * t371
  t1272 = t702 * t29
  t1277 = t144 * t313 * t315
  t1278 = t498 * t1277
  t1279 = t319 * t29
  t1300 = t753 * t305
  t1325 = t636 * t150
  t1347 = -t117 * t272 * t125 * t476 / 0.6e1 + 0.3e1 / 0.8e1 * t117 * t466 * t273 * t282 + 0.4e1 * t82 * t732 * t29 * t176 * t733 + 0.48e2 * t1244 * t632 * t1245 - 0.96e2 * t1244 * t616 * t1325 - 0.112e3 * t250 * t490 * t672 - 0.112e3 / 0.3e1 * t491 * t642 + 0.224e3 / 0.3e1 * t491 * t646 + 0.144e3 * t528 * t500 * t702 * t183 - 0.72e2 * t536 * t500 * t692 * t183 - 0.96e2 * t498 * t505 * t530
  t1369 = t753 * t807
  t1371 = t498 * t1369 * t315
  t1379 = t753 * t313
  t1381 = t159 * t1379 * t164
  t1384 = t788 * t161
  t1386 = t159 * t1384 * t164
  t1390 = t788 * t152
  t1420 = 0.4e1 * t62 * t1390 * t80 * t90 - 0.12e2 * t112 * t1390 * t113 - 0.144e3 * t523 * t1369 * t524 + 0.288e3 * t528 * t1369 * t529 - 0.144e3 * t250 * t1379 * t251 + 0.144e3 * t265 * t1379 * t266 - 0.48e2 * t1381 * t190 + 0.96e2 * t1381 * t196 + 0.48e2 * t244 * t564 - 0.24e2 * t575 * t258 - 0.96e2 * t516 * t533
  t1486 = 0.24e2 * t159 * t574 * t267 + 0.224e3 / 0.3e1 * t501 * t396 * t243 + 0.64e2 * t1234 * t1004 * t522 - 0.496e3 / 0.3e1 * t1234 * t1096 * t249 - 0.224e3 * t1371 * t554 + 0.40e2 / 0.3e1 * t1371 * t502 - 0.4e1 * t166 * t170 * t240 + 0.144e3 * t250 * t150 * t305 * t164 * t668 - 0.144e3 * t265 * t1243 * t189 * t150 - 0.36e2 * t112 * t578 * t261 - 0.24e2 * t112 * t154 * t649
  t1492 = t613 * t80
  t1506 = t692 * t29
  t1515 = t396 * t29
  t1539 = t34 * t248
  t1551 = t169 * t29 * t34
  t1552 = t36 * t183
  t1553 = t1552 * t144
  t1557 = t159 * t29
  t1565 = t62 * t29 * t637
  t1574 = t62 * t74
  t1577 = t88 * t29 * t34
  t1581 = 0.48e2 * t506 * t673 + 0.72e2 * t523 * t150 * t313 * t315 * t319 * t144 - 0.72e2 * t523 * t500 * t747 * t183 + 0.24e2 * t501 * t1506 * t184 + 0.72e2 * t501 * t1140 * t1539 * t183 - 0.44e2 * t250 * t165 * t692 * t293 + 0.28e2 / 0.3e1 * t159 * t74 * t966 * t1551 * t1553 + 0.56e2 * t1557 * t1539 * t74 * t966 * t880 * t183 + 0.36e2 * t1565 * t985 * t356 * t144 + 0.12e2 * t1565 * t978 * t356 * t371 - 0.12e2 * t1574 * t985 * t1577 * t1553
  t1595 = t159 * t144 * t966
  t1661 = 0.48e2 * t1371 * t551 + 0.144e3 * t1371 * t560 - 0.304e3 / 0.9e1 * t1234 * t747 * t37 + 0.184e3 / 0.9e1 * t501 * t319 * t243 - 0.488e3 / 0.27e2 * t1234 * t1096 * t37 - 0.144e3 * t528 * t1277 * t396 * t150 + 0.72e2 * t536 * t1277 * t329 * t150 - 0.16e2 * t244 * t680 + 0.16e2 * t244 * t650 + 0.12e2 * t112 * t146 * t649 + 0.48e2 * t516 * t654
  t1733 = 0.8e1 / 0.3e1 * t82 * t175 * t594 * t371 + 0.2e1 * t147 * t600 + 0.2e1 / 0.3e1 * t82 * t175 * t176 * t925 + 0.72e2 * t112 * t1492 * t89 * t150 - 0.44e2 / 0.3e1 * t166 * t959 * t29 * t628 + 0.88e2 / 0.3e1 * t166 * t1506 * t636 * t293 - 0.24e2 * t1278 * t590 * t1245 + 0.112e3 * t1278 * t1515 * t1325 - 0.72e2 * t1278 * t1279 * t1539 * t150 + 0.16e2 / 0.3e1 * t147 * t596 + 0.4e1 * t82 * t175 * t238 * t36 * t183
  v4rho4_0_ = 0.20e2 / 0.81e2 * t5 * (-0.2e1 * t7 * t37 + t43 * t44 * t45 * t54 / 0.6e1) * t9 - 0.16e2 / 0.27e2 * t12 * (-0.2e1 / 0.3e1 * t82 * t90 - 0.2e1 * t7 * t107 + 0.2e1 * t112 * t114 + t117 * t119 * t125 / 0.12e2) * t9 + 0.4e1 / 0.3e1 / t3 * t286 * t9 + 0.8e1 / 0.3e1 * t2 * (t519 + t569 + t626 + t683) * t9 + t2 * r0 * (-0.2e1 * t7 * t29 * (-0.36e2 * t317 * t692 * t214 + 0.36e2 * t697 * t329 * t698 + 0.4e1 * t317 * t702 * t214 - 0.8e1 * t210 * t403 * t434 - 0.72e2 * t709 * t189 * t698 + 0.14e2 * t324 * t403 * t713 - 0.9e1 * t333 * t174 * t713 - 0.28e2 / 0.3e1 * t307 * t432 - 0.11e2 / 0.3e1 * t210 * t692 * t447 + 0.6e1 * t204 * t435 + t786 + t929 + t963 + t1016 + t1050 + t1083 + t1113) * t36 + 0.32e2 * t615 * t616 * t1126 * t74 - 0.16e2 * t250 * t667 * t170 * t386 + 0.44e2 * t265 * t165 * t959 * t293 - 0.2e1 / 0.3e1 * t62 * t1211 * t80 * t90 - 0.24e2 * t159 * t239 * t248 * t252 + 0.8e1 * t62 * t459 * t110 * t114 + 0.16e2 * t62 * t1300 * t80 * t90 + 0.48e2 * t498 * t106 * t521 * t525 + t1197 + 0.16e2 * t265 * t1122 * t653 + 0.12e2 * t112 * t154 * t660 + 0.92e2 / 0.3e1 * t1278 * t1279 * t1325 + 0.16e2 * t166 * t641 * t595 + 0.16e2 / 0.3e1 * t166 * t641 * t599 + 0.88e2 / 0.3e1 * t501 * t1272 * t184 + 0.48e2 * t498 * t243 * t538 - 0.176e3 / 0.9e1 * t501 * t396 * t107 + 0.376e3 / 0.3e1 * t1234 * t747 * t111 - 0.12e2 * t250 * t1384 * t251 + 0.12e2 * t265 * t1384 * t266 + 0.352e3 / 0.27e2 * t1234 * t1004 * t111 + 0.16e2 * t166 * t170 * t574 - 0.92e2 / 0.3e1 * t501 * t1140 * t645 - 0.22e2 / 0.3e1 * t166 * t1506 * t628 - 0.16e2 * t615 * t632 * t1238 - 0.88e2 / 0.3e1 * t1278 * t1515 * t1245 + 0.712e3 / 0.9e1 * t1234 * t1096 * t111 - 0.344e3 / 0.9e1 * t1234 * t1004 * t249 - 0.16e2 * t1234 * t702 * t37 - 0.144e3 * t536 * t1369 * t537 - 0.6e1 * t112 * t481 * t261 + 0.8e1 * t166 * t590 * t595 + 0.8e1 / 0.3e1 * t166 * t590 * t599 + 0.20e2 / 0.3e1 * t501 * t1140 * t184 - 0.8e1 / 0.3e1 * t82 * t89 * t460 - 0.48e2 * t501 * t319 * t505 - 0.40e2 / 0.9e1 * t501 * t319 * t107 - 0.112e3 * t501 * t1272 * t645 - 0.20e2 / 0.3e1 * t1278 * t1279 * t1245 - 0.16e2 * t501 * t329 * t107 - 0.8e1 * t166 * t189 * t240 + t1347 - 0.32e2 / 0.3e1 * t155 * t596 + 0.32e2 * t244 * t657 - 0.4e1 * t1386 * t190 + 0.8e1 * t1386 * t196 + 0.96e2 * t506 * t571 + 0.32e2 / 0.3e1 * t1123 * t638 - 0.48e2 * t506 * t669 - 0.48e2 * t244 * t677 - 0.4e1 * t147 * t629 - 0.16e2 / 0.3e1 * t1123 * t633 + 0.8e1 * t244 * t582 + 0.12e2 * t575 * t255 - 0.24e2 * t1381 * t171 - 0.2e1 * t1386 * t171 + 0.16e2 * t491 * t494 - 0.8e1 / 0.3e1 * t482 * t193 - 0.4e1 * t147 * t513 + 0.8e1 * t155 * t513 + 0.32e2 * t491 * t587 - 0.64e2 * t491 * t557 + 0.176e3 / 0.3e1 * t1371 * t545 - 0.184e3 / 0.3e1 * t1371 * t548 - 0.16e2 * t579 * t193 + t1420 + t1269 + 0.144e3 * t1231 * t522 * t1232 * t765 * t766 - 0.56e2 * t1557 * t637 * t966 * t864 * t144 - 0.4e1 * t1574 * t978 * t1577 * t1552 * t371 - 0.112e3 / 0.3e1 * t1595 * t1551 * t110 * t74 * t183 - 0.144e3 * t1231 * t249 * t1232 * t765 * t318 + 0.48e2 * t1231 * t111 * t1232 * t765 * t395 + t1733 + t1661 + t1486 - 0.48e2 * t1231 * t35 / t520 / t27 * t1232 * t765 * t1003 + 0.56e2 / 0.3e1 * t1595 * t188 * t29 * t34 * t36 * t74 * t183 + 0.2e1 * t112 * t1211 * t113 - 0.48e2 * t112 * t1300 * t113 + t1581 - 0.12e2 * t112 * t81 * t732 * t733 - 0.24e2 * t62 * t1492 * t606 * t1245 - 0.16e2 / 0.3e1 * t82 * t627 * t594 * t293 + 0.16e2 * t250 * t165 * t329 * t371 - 0.32e2 * t166 * t590 * t1126 * t183 - 0.32e2 / 0.3e1 * t166 * t590 * t636 * t371) * t9 / 0.2e1

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = params.c * jnp.pi
  t2 = r0 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t5 = 0.1e1 / t3 / r0
  t8 = tau0 * t5
  t10 = r0 ** 2
  t12 = 0.1e1 / t3 / t10
  t15 = l0 * t5 / 0.6e1 - 0.53333333333333333333333333333333333333333333333333e0 * t8 + 0.66666666666666666666666666666666666666666666666667e-1 * s0 * t12
  t16 = abs(t15)
  t17 = t16 < 0.50e-12
  t18 = 0.0e0 < t15
  t19 = f.my_piecewise3(t18, 0, 0)
  t22 = tau0 * t12
  t26 = 0.1e1 / t3 / t10 / r0
  t30 = f.my_piecewise3(t17, t19, -0.5e1 / 0.18e2 * l0 * t12 + 0.88888888888888888888888888888888888888888888888889e0 * t22 - 0.17777777777777777777777777777777777777777777777778e0 * s0 * t26)
  t31 = f.my_piecewise3(t18, 0.50e-12, -0.50e-12)
  t32 = f.my_piecewise3(t17, t31, t15)
  t33 = t32 ** 2
  t34 = 0.1e1 / t33
  t35 = t30 * t34
  t36 = br89_x(t32)
  t38 = jnp.exp(-0.2e1 / 0.3e1 * t36)
  t39 = 0.1e1 / t38
  t40 = t35 * t39
  t41 = t1 * t40
  t42 = t36 ** 2
  t44 = t42 - 0.2e1 * t36 + 0.3e1
  t45 = 0.1e1 / t44
  t46 = t36 - 0.2e1
  t47 = t46 ** 2
  t48 = t45 * t47
  t50 = jnp.exp(t36 / 0.3e1)
  t51 = jnp.exp(-t36)
  t54 = t51 * (0.1e1 + t36 / 0.2e1)
  t55 = 0.1e1 - t54
  t56 = t50 * t55
  t57 = 0.1e1 / t36
  t58 = t56 * t57
  t59 = t48 * t58
  t62 = jnp.pi ** (0.1e1 / 0.3e1)
  t63 = params.c * t62
  t64 = t62 ** 2
  t65 = t64 * t30
  t66 = t34 * t39
  t67 = t65 * t66
  t68 = t48 * t54
  t70 = t65 * t34
  t71 = t39 * t45
  t73 = t71 * t47 * t51
  t77 = t50 * (t67 * t68 - t70 * t73 / 0.2e1)
  t78 = t77 * t57
  t81 = 0.1e1 / t42
  t82 = t56 * t81
  t83 = t1 * t82
  t84 = t71 * t47
  t85 = t35 * t84
  t90 = jnp.sqrt(0.15e2)
  t91 = (0.3e1 * params.c - 0.2e1) * t90
  t92 = 0.1e1 / jnp.pi
  t93 = t91 * t92
  t94 = jnp.sqrt(0.2e1)
  t95 = params.alpha * s0
  t98 = t8 - t95 * t12 / 0.8e1
  t99 = 0.1e-9 < t98
  t100 = f.my_piecewise3(t99, t98, 0.1e-9)
  t101 = jnp.sqrt(t100)
  t103 = t94 / t101
  t108 = f.my_piecewise3(t99, -0.5e1 / 0.3e1 * t22 + t95 * t26 / 0.3e1, 0)
  t112 = -0.2e1 / 0.3e1 * t41 * t59 - 0.2e1 * t63 * t78 + 0.2e1 * t83 * t85 + t93 * t103 * t108 / 0.12e2
  t113 = t112 * t2
  t121 = -0.2e1 * t63 * t58 + t91 * t92 * t94 * t101 / 0.6e1
  t122 = 0.1e1 / t3
  t123 = t121 * t122
  t125 = r0 + r1
  t128 = tau0 * t26
  t130 = t10 ** 2
  t132 = 0.1e1 / t3 / t130
  t136 = f.my_piecewise3(t17, t19, 0.20e2 / 0.27e2 * l0 * t26 - 0.23703703703703703703703703703703703703703703703704e1 * t128 + 0.65185185185185185185185185185185185185185185185186e0 * s0 * t132)
  t137 = t136 * t34
  t142 = t30 ** 2
  t144 = 0.1e1 / t33 / t32
  t145 = t142 * t144
  t151 = params.c * t64 * jnp.pi
  t152 = t33 ** 2
  t153 = 0.1e1 / t152
  t154 = t142 * t153
  t155 = t38 ** 2
  t156 = 0.1e1 / t155
  t158 = t151 * t154 * t156
  t159 = t44 ** 2
  t160 = 0.1e1 / t159
  t161 = t47 ** 2
  t162 = t160 * t161
  t166 = t160 * t47
  t175 = 0.2e1 * t36 * t64 * t30 * t66 * t48 - 0.2e1 * t70 * t84
  t180 = t47 * t46
  t181 = t160 * t180
  t191 = t64 * t136
  t194 = t64 * t142
  t200 = t62 * jnp.pi * t142
  t202 = t200 * t153 * t156
  t212 = t200 * t153
  t213 = t156 * t160
  t265 = t108 ** 2
  t273 = f.my_piecewise3(t99, 0.40e2 / 0.9e1 * t128 - 0.11e2 / 0.9e1 * t95 * t132, 0)
  t277 = -0.2e1 / 0.3e1 * t1 * t137 * t39 * t59 + 0.4e1 / 0.3e1 * t1 * t145 * t39 * t59 - 0.2e1 / 0.3e1 * t158 * t162 * t58 + 0.2e1 / 0.3e1 * t41 * t166 * t50 * t55 * t57 * t175 - 0.4e1 / 0.3e1 * t158 * t181 * t58 - 0.4e1 / 0.3e1 * t41 * t48 * t78 + 0.8e1 / 0.3e1 * t158 * t162 * t82 - 0.2e1 * t63 * t50 * (t191 * t66 * t68 - 0.2e1 * t194 * t144 * t39 * t68 - t202 * t162 * t54 / 0.3e1 - t67 * t166 * t54 * t175 + 0.2e1 * t202 * t181 * t54 + 0.2e1 / 0.3e1 * t212 * t213 * t161 * t51 - t191 * t34 * t73 / 0.2e1 + t194 * t144 * t73 + t67 * t166 * t51 * t175 / 0.2e1 - t212 * t213 * t180 * t51) * t57 + 0.4e1 * t1 * t77 * t81 * t85 - 0.4e1 * t151 * t56 / t42 / t36 * t154 * t213 * t161 + 0.2e1 * t83 * t137 * t84 - 0.4e1 * t83 * t145 * t84 - 0.2e1 * t83 * t40 * t166 * t175 + 0.4e1 * t151 * t82 * t154 * t213 * t180 - t93 * t94 / t101 / t100 * t265 / 0.24e2 + t93 * t103 * t273 / 0.12e2
  d11 = 0.2e1 * t113 + 0.2e1 / 0.3e1 * t123 + t125 * t277 * t2 + 0.2e1 / 0.3e1 * t125 * t112 * t122 - 0.2e1 / 0.9e1 * t125 * t121 * t5
  d12 = t113 + t123 / 0.3e1
  d22 = 0.0e0
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = params.c * jnp.pi
  t2 = r0 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t5 = 0.1e1 / t3 / r0
  t8 = tau0 * t5
  t10 = r0 ** 2
  t12 = 0.1e1 / t3 / t10
  t15 = l0 * t5 / 0.6e1 - 0.53333333333333333333333333333333333333333333333333e0 * t8 + 0.66666666666666666666666666666666666666666666666667e-1 * s0 * t12
  t16 = abs(t15)
  t17 = t16 < 0.50e-12
  t18 = 0.0e0 < t15
  t19 = f.my_piecewise3(t18, 0, 0)
  t22 = 0.1e1 / t3 / t10 / r0
  t25 = tau0 * t22
  t27 = t10 ** 2
  t29 = 0.1e1 / t3 / t27
  t33 = f.my_piecewise3(t17, t19, 0.20e2 / 0.27e2 * l0 * t22 - 0.23703703703703703703703703703703703703703703703704e1 * t25 + 0.65185185185185185185185185185185185185185185185186e0 * s0 * t29)
  t34 = f.my_piecewise3(t18, 0.50e-12, -0.50e-12)
  t35 = f.my_piecewise3(t17, t34, t15)
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t38 = t33 * t37
  t39 = br89_x(t35)
  t41 = jnp.exp(-0.2e1 / 0.3e1 * t39)
  t42 = 0.1e1 / t41
  t43 = t38 * t42
  t44 = t1 * t43
  t45 = t39 ** 2
  t47 = t45 - 0.2e1 * t39 + 0.3e1
  t48 = 0.1e1 / t47
  t49 = t39 - 0.2e1
  t50 = t49 ** 2
  t51 = t48 * t50
  t53 = jnp.exp(t39 / 0.3e1)
  t54 = jnp.exp(-t39)
  t57 = t54 * (0.1e1 + t39 / 0.2e1)
  t58 = 0.1e1 - t57
  t59 = t53 * t58
  t60 = 0.1e1 / t39
  t61 = t59 * t60
  t62 = t51 * t61
  t67 = tau0 * t12
  t72 = f.my_piecewise3(t17, t19, -0.5e1 / 0.18e2 * l0 * t12 + 0.88888888888888888888888888888888888888888888888889e0 * t67 - 0.17777777777777777777777777777777777777777777777778e0 * s0 * t22)
  t73 = t72 ** 2
  t75 = 0.1e1 / t36 / t35
  t76 = t73 * t75
  t77 = t76 * t42
  t78 = t1 * t77
  t81 = jnp.pi ** (0.1e1 / 0.3e1)
  t82 = t81 ** 2
  t84 = params.c * t82 * jnp.pi
  t85 = t36 ** 2
  t86 = 0.1e1 / t85
  t87 = t73 * t86
  t88 = t41 ** 2
  t89 = 0.1e1 / t88
  t90 = t87 * t89
  t91 = t84 * t90
  t92 = t47 ** 2
  t93 = 0.1e1 / t92
  t94 = t50 ** 2
  t95 = t93 * t94
  t96 = t95 * t61
  t99 = t72 * t37
  t100 = t99 * t42
  t101 = t1 * t100
  t102 = t93 * t50
  t103 = t102 * t53
  t104 = t58 * t60
  t105 = t39 * t82
  t107 = t37 * t42
  t108 = t107 * t51
  t110 = t82 * t72
  t111 = t110 * t37
  t112 = t42 * t48
  t113 = t112 * t50
  t116 = 0.2e1 * t105 * t72 * t108 - 0.2e1 * t111 * t113
  t117 = t104 * t116
  t118 = t103 * t117
  t121 = t50 * t49
  t122 = t93 * t121
  t123 = t122 * t61
  t126 = t110 * t107
  t127 = t51 * t57
  t130 = t112 * t50 * t54
  t133 = t126 * t127 - t111 * t130 / 0.2e1
  t134 = t53 * t133
  t135 = t134 * t60
  t136 = t51 * t135
  t139 = 0.1e1 / t45
  t140 = t59 * t139
  t141 = t95 * t140
  t144 = params.c * t81
  t145 = t82 * t33
  t146 = t145 * t107
  t148 = t82 * t73
  t149 = t75 * t42
  t150 = t148 * t149
  t153 = t81 * jnp.pi
  t154 = t153 * t73
  t155 = t86 * t89
  t156 = t154 * t155
  t157 = t95 * t57
  t160 = t57 * t116
  t161 = t102 * t160
  t163 = t122 * t57
  t166 = t154 * t86
  t167 = t89 * t93
  t168 = t94 * t54
  t169 = t167 * t168
  t172 = t145 * t37
  t175 = t148 * t75
  t177 = t54 * t116
  t178 = t102 * t177
  t182 = t167 * t121 * t54
  t185 = t53 * (t146 * t127 - 0.2e1 * t150 * t127 - t156 * t157 / 0.3e1 - t126 * t161 + 0.2e1 * t156 * t163 + 0.2e1 / 0.3e1 * t166 * t169 - t172 * t130 / 0.2e1 + t175 * t130 + t126 * t178 / 0.2e1 - t166 * t182)
  t186 = t185 * t60
  t189 = t134 * t139
  t190 = t1 * t189
  t191 = t99 * t113
  t195 = 0.1e1 / t45 / t39
  t196 = t59 * t195
  t197 = t84 * t196
  t198 = t167 * t94
  t199 = t87 * t198
  t202 = t1 * t140
  t203 = t38 * t113
  t206 = t76 * t113
  t209 = t102 * t116
  t210 = t100 * t209
  t213 = t84 * t140
  t214 = t167 * t121
  t215 = t87 * t214
  t220 = jnp.sqrt(0.15e2)
  t221 = (0.3e1 * params.c - 0.2e1) * t220
  t222 = 0.1e1 / jnp.pi
  t223 = t221 * t222
  t224 = jnp.sqrt(0.2e1)
  t225 = params.alpha * s0
  t228 = t8 - t225 * t12 / 0.8e1
  t229 = 0.1e-9 < t228
  t230 = f.my_piecewise3(t229, t228, 0.1e-9)
  t231 = jnp.sqrt(t230)
  t234 = t224 / t231 / t230
  t239 = f.my_piecewise3(t229, -0.5e1 / 0.3e1 * t67 + t225 * t22 / 0.3e1, 0)
  t240 = t239 ** 2
  t245 = t224 / t231
  t250 = f.my_piecewise3(t229, 0.40e2 / 0.9e1 * t25 - 0.11e2 / 0.9e1 * t225 * t29, 0)
  t254 = -0.2e1 / 0.3e1 * t44 * t62 + 0.4e1 / 0.3e1 * t78 * t62 - 0.2e1 / 0.3e1 * t91 * t96 + 0.2e1 / 0.3e1 * t101 * t118 - 0.4e1 / 0.3e1 * t91 * t123 - 0.4e1 / 0.3e1 * t101 * t136 + 0.8e1 / 0.3e1 * t91 * t141 - 0.2e1 * t144 * t186 + 0.4e1 * t190 * t191 - 0.4e1 * t197 * t199 + 0.2e1 * t202 * t203 - 0.4e1 * t202 * t206 - 0.2e1 * t202 * t210 + 0.4e1 * t213 * t215 - t223 * t234 * t240 / 0.24e2 + t223 * t245 * t250 / 0.12e2
  t266 = -0.2e1 / 0.3e1 * t101 * t62 - 0.2e1 * t144 * t135 + 0.2e1 * t202 * t191 + t223 * t245 * t239 / 0.12e2
  t267 = 0.1e1 / t3
  t276 = -0.2e1 * t144 * t61 + t221 * t222 * t224 * t231 / 0.6e1
  t279 = r0 + r1
  t284 = t73 * t72
  t285 = t153 * t284
  t287 = 0.1e1 / t85 / t35
  t288 = t285 * t287
  t291 = jnp.pi ** 2
  t292 = t291 * t284
  t294 = 0.1e1 / t85 / t36
  t295 = t292 * t294
  t297 = 0.1e1 / t88 / t41
  t299 = 0.1e1 / t92 / t47
  t300 = t297 * t299
  t301 = t94 * t50
  t308 = t82 * t284
  t317 = tau0 * t29
  t321 = 0.1e1 / t3 / t27 / r0
  t325 = f.my_piecewise3(t17, t19, -0.220e3 / 0.81e2 * l0 * t29 + 0.86913580246913580246913580246913580246913580246915e1 * t317 - 0.30419753086419753086419753086419753086419753086420e1 * s0 * t321)
  t326 = t82 * t325
  t330 = t94 * t49
  t345 = t39 * t153 * t73
  t352 = t42 * t93 * t50 * t116
  t366 = 0.2e1 / 0.3e1 * t166 * t198 + 0.2e1 * t105 * t33 * t108 - 0.4e1 * t105 * t73 * t149 * t51 + 0.4e1 / 0.3e1 * t345 * t155 * t95 - 0.2e1 * t105 * t99 * t352 + 0.4e1 * t345 * t155 * t122 - 0.2e1 * t172 * t113 + 0.4e1 * t175 * t113 + 0.2e1 * t111 * t352 - 0.4e1 * t166 * t214
  t370 = t145 * t149
  t371 = t57 * t72
  t378 = t153 * t33 * t155
  t383 = t299 * t50
  t384 = t116 ** 2
  t389 = t299 * t121
  t396 = t299 * t94
  t399 = -0.4e1 * t288 * t169 + t295 * t300 * t301 * t54 / 0.18e2 + 0.6e1 * t288 * t182 - 0.3e1 * t308 * t86 * t130 - 0.3e1 * t295 * t300 * t168 - t326 * t37 * t130 / 0.2e1 + 0.10e2 / 0.3e1 * t295 * t300 * t330 * t54 - t126 * t102 * t57 * t366 - 0.6e1 * t370 * t51 * t371 - 0.2e1 * t146 * t161 - t378 * t95 * t371 + 0.4e1 * t150 * t161 + 0.2e1 * t126 * t383 * t57 * t384 - 0.6e1 * t156 * t389 * t160 + 0.6e1 * t378 * t122 * t371 + t156 * t396 * t160
  t402 = t54 * t72
  t414 = t285 * t287 * t89
  t418 = t292 * t294 * t297
  t419 = t299 * t301
  t431 = t299 * t330
  t451 = t326 * t107 * t127 + 0.2e1 * t378 * t95 * t402 - t126 * t383 * t54 * t384 + 0.6e1 * t308 * t86 * t42 * t127 + 0.2e1 * t414 * t157 - t418 * t419 * t57 / 0.9e1 - 0.3e1 * t378 * t122 * t402 - 0.2e1 * t156 * t396 * t177 - 0.12e2 * t414 * t163 - 0.2e1 / 0.3e1 * t418 * t431 * t57 + 0.6e1 * t418 * t396 * t57 + 0.3e1 * t156 * t389 * t177 + 0.3e1 * t370 * t51 * t402 + t146 * t178 - 0.2e1 * t150 * t178 + t126 * t102 * t54 * t366 / 0.2e1
  t474 = t33 * t75 * t42
  t482 = t396 * t53
  t497 = t104 * t72
  t503 = -t223 * t234 * t239 * t250 / 0.8e1 - 0.2e1 * t144 * t53 * (t399 + t451) * t60 - 0.2e1 * t202 * t100 * t102 * t366 - 0.6e1 * t190 * t210 - 0.12e2 * t197 * t72 * t86 * t89 * t95 * t33 + 0.12e2 * t197 * t90 * t396 * t116 - 0.12e2 * t202 * t474 * t51 * t72 - 0.4e1 * t202 * t43 * t209 + 0.2e1 * t91 * t482 * t117 + 0.2e1 * t101 * t103 * t133 * t60 * t116 + 0.2e1 / 0.3e1 * t101 * t103 * t104 * t366 + 0.4e1 * t1 * t474 * t51 * t53 * t497 + 0.4e1 / 0.3e1 * t44 * t118
  t505 = t33 * t86 * t89
  t506 = t84 * t505
  t507 = t95 * t53
  t522 = t58 * t139
  t551 = params.c * t81 * t291
  t552 = t284 * t294
  t554 = t551 * t552 * t297
  t564 = -0.2e1 * t506 * t507 * t497 - 0.8e1 / 0.3e1 * t78 * t118 - 0.4e1 / 0.3e1 * t101 * t383 * t53 * t104 * t384 - 0.4e1 * t506 * t122 * t53 * t497 + 0.8e1 * t506 * t507 * t522 * t72 + 0.4e1 * t91 * t389 * t53 * t117 - 0.8e1 * t91 * t482 * t522 * t116 - 0.12e2 * t213 * t90 * t389 * t116 + 0.4e1 * t202 * t100 * t383 * t384 + 0.12e2 * t213 * t505 * t122 * t72 + 0.8e1 * t202 * t77 * t209 - 0.10e2 / 0.9e1 * t554 * t419 * t61 - 0.4e1 * t91 * t122 * t135 - 0.2e1 * t101 * t51 * t186
  t566 = t325 * t37
  t575 = t284 * t287
  t577 = t84 * t575 * t89
  t590 = t45 ** 2
  t618 = -0.2e1 / 0.3e1 * t1 * t566 * t42 * t62 - 0.2e1 * t44 * t136 + 0.4e1 * t78 * t136 + 0.4e1 * t577 * t96 - 0.2e1 * t91 * t95 * t135 - 0.12e2 * t84 * t134 * t195 * t199 + 0.12e2 * t84 * t189 * t215 + 0.12e2 * t551 * t59 / t590 * t552 * t300 * t301 - 0.24e2 * t551 * t196 * t552 * t300 * t330 - 0.24e2 * t213 * t575 * t214 + 0.12e2 * t551 * t140 * t552 * t300 * t94 + 0.8e1 * t577 * t123 - 0.16e2 * t577 * t141 - 0.44e2 / 0.9e1 * t554 * t431 * t61
  t634 = t284 * t86
  t656 = t230 ** 2
  t668 = f.my_piecewise3(t229, -0.440e3 / 0.27e2 * t317 + 0.154e3 / 0.27e2 * t225 * t321, 0)
  t672 = 0.46e2 / 0.9e1 * t554 * t419 * t140 - 0.4e1 * t554 * t396 * t61 + 0.56e2 / 0.3e1 * t554 * t431 * t140 + 0.8e1 * t91 * t95 * t189 - 0.12e2 * t554 * t419 * t196 + 0.12e2 * t202 * t634 * t113 + 0.6e1 * t1 * t185 * t139 * t191 - 0.12e2 * t190 * t206 + 0.24e2 * t197 * t575 * t198 - 0.4e1 * t1 * t634 * t42 * t62 + 0.2e1 * t202 * t566 * t113 + 0.6e1 * t190 * t203 + t223 * t224 / t231 / t656 * t240 * t239 / 0.16e2 + t223 * t245 * t668 / 0.12e2
  d111 = 0.3e1 * t254 * t2 + 0.2e1 * t266 * t267 - 0.2e1 / 0.3e1 * t276 * t5 + t279 * (t503 + t564 + t618 + t672) * t2 + t279 * t254 * t267 - 0.2e1 / 0.3e1 * t279 * t266 * t5 + 0.10e2 / 0.27e2 * t279 * t276 * t12

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t3 = jnp.sqrt(0.15e2)
  t4 = (0.3e1 * params.c - 0.2e1) * t3
  t5 = 0.1e1 / jnp.pi
  t6 = t4 * t5
  t7 = jnp.sqrt(0.2e1)
  t8 = r0 ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t11 = 0.1e1 / t9 / r0
  t12 = tau0 * t11
  t13 = params.alpha * s0
  t14 = r0 ** 2
  t16 = 0.1e1 / t9 / t14
  t19 = t12 - t13 * t16 / 0.8e1
  t20 = 0.1e-9 < t19
  t21 = f.my_piecewise3(t20, t19, 0.1e-9)
  t22 = t21 ** 2
  t23 = jnp.sqrt(t21)
  t26 = t7 / t23 / t22
  t27 = tau0 * t16
  t31 = 0.1e1 / t9 / t14 / r0
  t35 = f.my_piecewise3(t20, -0.5e1 / 0.3e1 * t27 + t13 * t31 / 0.3e1, 0)
  t36 = t35 ** 2
  t42 = t7 / t23
  t43 = t14 ** 2
  t45 = 0.1e1 / t9 / t43
  t46 = tau0 * t45
  t50 = 0.1e1 / t9 / t43 / r0
  t54 = f.my_piecewise3(t20, -0.440e3 / 0.27e2 * t46 + 0.154e3 / 0.27e2 * t13 * t50, 0)
  t58 = jnp.pi ** (0.1e1 / 0.3e1)
  t59 = params.c * t58
  t65 = l0 * t11 / 0.6e1 - 0.53333333333333333333333333333333333333333333333333e0 * t12 + 0.66666666666666666666666666666666666666666666666667e-1 * s0 * t16
  t66 = abs(t65)
  t67 = t66 < 0.50e-12
  t68 = 0.0e0 < t65
  t69 = f.my_piecewise3(t68, 0.50e-12, -0.50e-12)
  t70 = f.my_piecewise3(t67, t69, t65)
  t71 = br89_x(t70)
  t73 = jnp.exp(t71 / 0.3e1)
  t74 = t58 ** 2
  t75 = f.my_piecewise3(t68, 0, 0)
  t82 = f.my_piecewise3(t67, t75, -0.220e3 / 0.81e2 * l0 * t45 + 0.86913580246913580246913580246913580246913580246915e1 * t46 - 0.30419753086419753086419753086419753086419753086420e1 * s0 * t50)
  t83 = t74 * t82
  t84 = t70 ** 2
  t85 = 0.1e1 / t84
  t86 = t83 * t85
  t88 = jnp.exp(-0.2e1 / 0.3e1 * t71)
  t89 = 0.1e1 / t88
  t90 = t71 ** 2
  t92 = t90 - 0.2e1 * t71 + 0.3e1
  t93 = 0.1e1 / t92
  t94 = t89 * t93
  t95 = t71 - 0.2e1
  t96 = t95 ** 2
  t97 = jnp.exp(-t71)
  t98 = t96 * t97
  t99 = t94 * t98
  t102 = jnp.pi ** 2
  t109 = f.my_piecewise3(t67, t75, -0.5e1 / 0.18e2 * l0 * t16 + 0.88888888888888888888888888888888888888888888888889e0 * t27 - 0.17777777777777777777777777777777777777777777777778e0 * s0 * t31)
  t110 = t109 ** 2
  t111 = t110 * t109
  t112 = t102 * t111
  t113 = t84 ** 2
  t115 = 0.1e1 / t113 / t84
  t116 = t112 * t115
  t117 = t88 ** 2
  t119 = 0.1e1 / t117 / t88
  t120 = t92 ** 2
  t122 = 0.1e1 / t120 / t92
  t123 = t119 * t122
  t124 = t96 ** 2
  t125 = t124 * t95
  t126 = t125 * t97
  t127 = t123 * t126
  t130 = t58 * jnp.pi
  t131 = t130 * t111
  t133 = 0.1e1 / t113 / t70
  t134 = t131 * t133
  t135 = 0.1e1 / t117
  t136 = 0.1e1 / t120
  t137 = t135 * t136
  t138 = t124 * t97
  t139 = t137 * t138
  t142 = t124 * t96
  t143 = t142 * t97
  t144 = t123 * t143
  t147 = t96 * t95
  t148 = t147 * t97
  t149 = t137 * t148
  t152 = t74 * t111
  t153 = 0.1e1 / t113
  t154 = t152 * t153
  t157 = t123 * t138
  t160 = t74 * t109
  t161 = t85 * t89
  t162 = t160 * t161
  t163 = t136 * t96
  t165 = 0.1e1 + t71 / 0.2e1
  t166 = t97 * t165
  t167 = t130 * t110
  t168 = t167 * t153
  t169 = t137 * t124
  t172 = t71 * t74
  t175 = tau0 * t31
  t180 = f.my_piecewise3(t67, t75, 0.20e2 / 0.27e2 * l0 * t31 - 0.23703703703703703703703703703703703703703703703704e1 * t175 + 0.65185185185185185185185185185185185185185185185186e0 * s0 * t45)
  t182 = t93 * t96
  t183 = t161 * t182
  t187 = t84 * t70
  t188 = 0.1e1 / t187
  t189 = t188 * t89
  t193 = t71 * t130
  t194 = t193 * t110
  t195 = t153 * t135
  t196 = t136 * t124
  t200 = t109 * t85
  t201 = t172 * t200
  t202 = t89 * t136
  t205 = t160 * t85
  t206 = t94 * t96
  t209 = 0.2e1 * t172 * t109 * t183 - 0.2e1 * t205 * t206
  t210 = t96 * t209
  t211 = t202 * t210
  t214 = t136 * t147
  t218 = t74 * t180
  t219 = t218 * t85
  t222 = t74 * t110
  t223 = t222 * t188
  t228 = t137 * t147
  t231 = 0.2e1 / 0.3e1 * t168 * t169 + 0.2e1 * t172 * t180 * t183 - 0.4e1 * t172 * t110 * t189 * t182 + 0.4e1 / 0.3e1 * t194 * t195 * t196 - 0.2e1 * t201 * t211 + 0.4e1 * t194 * t195 * t214 - 0.2e1 * t219 * t206 + 0.4e1 * t223 * t206 + 0.2e1 * t205 * t211 - 0.4e1 * t168 * t228
  t232 = t166 * t231
  t233 = t163 * t232
  t235 = t218 * t189
  t236 = t166 * t109
  t237 = t182 * t236
  t240 = t218 * t161
  t241 = t166 * t209
  t242 = t163 * t241
  t245 = t130 * t180
  t246 = t245 * t195
  t247 = t196 * t236
  t249 = t222 * t189
  t252 = t122 * t96
  t253 = t209 ** 2
  t254 = t166 * t253
  t255 = t252 * t254
  t258 = t167 * t195
  t259 = t122 * t147
  t260 = t259 * t241
  t263 = t214 * t236
  t266 = t122 * t124
  t267 = t266 * t241
  t269 = -t86 * t99 / 0.2e1 + 0.10e2 / 0.3e1 * t116 * t127 - 0.4e1 * t134 * t139 + t116 * t144 / 0.18e2 + 0.6e1 * t134 * t149 - 0.3e1 * t154 * t99 - 0.3e1 * t116 * t157 - t162 * t233 - 0.6e1 * t235 * t237 - 0.2e1 * t240 * t242 - t246 * t247 + 0.4e1 * t249 * t242 + 0.2e1 * t162 * t255 - 0.6e1 * t258 * t260 + 0.6e1 * t246 * t263 + t258 * t267
  t270 = t115 * t119
  t271 = t112 * t270
  t272 = t266 * t166
  t275 = t97 * t209
  t276 = t259 * t275
  t279 = t97 * t109
  t280 = t182 * t279
  t283 = t163 * t275
  t287 = t97 * t231
  t288 = t163 * t287
  t291 = t83 * t161
  t292 = t182 * t166
  t294 = t196 * t279
  t297 = t97 * t253
  t298 = t252 * t297
  t300 = t153 * t89
  t301 = t152 * t300
  t304 = t133 * t135
  t305 = t131 * t304
  t306 = t196 * t166
  t309 = t214 * t279
  t312 = t122 * t142
  t313 = t312 * t166
  t316 = t266 * t275
  t319 = t214 * t166
  t322 = t122 * t125
  t323 = t322 * t166
  t326 = 0.6e1 * t271 * t272 + 0.3e1 * t258 * t276 + 0.3e1 * t235 * t280 + t240 * t283 - 0.2e1 * t249 * t283 + t162 * t288 / 0.2e1 + t291 * t292 + 0.2e1 * t246 * t294 - t162 * t298 + 0.6e1 * t301 * t292 + 0.2e1 * t305 * t306 - 0.3e1 * t246 * t309 - t271 * t313 / 0.9e1 - 0.2e1 * t258 * t316 - 0.12e2 * t305 * t319 - 0.2e1 / 0.3e1 * t271 * t323
  t328 = t73 * (t269 + t326)
  t329 = 0.1e1 / t71
  t330 = t328 * t329
  t335 = t7 / t23 / t21
  t340 = f.my_piecewise3(t20, 0.40e2 / 0.9e1 * t175 - 0.11e2 / 0.9e1 * t13 * t45, 0)
  t346 = params.c * t58 * t102
  t347 = t111 * t115
  t348 = t347 * t119
  t349 = t346 * t348
  t350 = 0.1e1 - t166
  t351 = t73 * t350
  t352 = t351 * t329
  t353 = t312 * t352
  t357 = params.c * t74 * jnp.pi
  t358 = t110 * t153
  t359 = t358 * t135
  t360 = t357 * t359
  t364 = t162 * t292 - t205 * t99 / 0.2e1
  t365 = t73 * t364
  t366 = t365 * t329
  t367 = t214 * t366
  t370 = params.c * jnp.pi
  t371 = t200 * t89
  t372 = t370 * t371
  t389 = t240 * t292 - 0.2e1 * t249 * t292 - t258 * t306 / 0.3e1 - t162 * t242 + 0.2e1 * t258 * t319 + 0.2e1 / 0.3e1 * t168 * t139 - t219 * t99 / 0.2e1 + t223 * t99 + t162 * t283 / 0.2e1 - t168 * t149
  t390 = t73 * t389
  t391 = t390 * t329
  t392 = t182 * t391
  t395 = t82 * t85
  t396 = t395 * t89
  t397 = t370 * t396
  t398 = t182 * t352
  t401 = t180 * t85
  t402 = t401 * t89
  t403 = t370 * t402
  t404 = t182 * t366
  t407 = t110 * t188
  t408 = t407 * t89
  t409 = t370 * t408
  t412 = t111 * t133
  t413 = t412 * t135
  t414 = t357 * t413
  t415 = t196 * t352
  t418 = t196 * t366
  t422 = 0.1e1 / t90 / t71
  t423 = t365 * t422
  t424 = t357 * t423
  t425 = t358 * t169
  t428 = t6 * t26 * t36 * t35 / 0.16e2 + t6 * t42 * t54 / 0.12e2 - 0.2e1 * t59 * t330 - t6 * t335 * t35 * t340 / 0.8e1 - 0.10e2 / 0.9e1 * t349 * t353 - 0.4e1 * t360 * t367 - 0.2e1 * t372 * t392 - 0.2e1 / 0.3e1 * t397 * t398 - 0.2e1 * t403 * t404 + 0.4e1 * t409 * t404 + 0.4e1 * t414 * t415 - 0.2e1 * t360 * t418 - 0.12e2 * t424 * t425
  t429 = 0.1e1 / t90
  t430 = t365 * t429
  t431 = t357 * t430
  t432 = t358 * t228
  t435 = t90 ** 2
  t436 = 0.1e1 / t435
  t437 = t351 * t436
  t438 = t346 * t437
  t439 = t123 * t142
  t440 = t347 * t439
  t443 = t351 * t422
  t444 = t346 * t443
  t445 = t123 * t125
  t446 = t347 * t445
  t449 = t351 * t429
  t450 = t357 * t449
  t451 = t412 * t228
  t454 = t346 * t449
  t455 = t123 * t124
  t456 = t347 * t455
  t459 = t214 * t352
  t462 = t196 * t449
  t465 = t322 * t352
  t468 = t312 * t449
  t471 = t266 * t352
  t474 = t322 * t449
  t477 = t196 * t430
  t480 = t312 * t443
  t483 = t370 * t449
  t484 = t111 * t153
  t485 = t484 * t206
  t488 = 0.12e2 * t431 * t432 + 0.12e2 * t438 * t440 - 0.24e2 * t444 * t446 - 0.24e2 * t450 * t451 + 0.12e2 * t454 * t456 + 0.8e1 * t414 * t459 - 0.16e2 * t414 * t462 - 0.44e2 / 0.9e1 * t349 * t465 + 0.46e2 / 0.9e1 * t349 * t468 - 0.4e1 * t349 * t471 + 0.56e2 / 0.3e1 * t349 * t474 + 0.8e1 * t360 * t477 - 0.12e2 * t349 * t480 + 0.12e2 * t483 * t485
  t490 = t390 * t429
  t491 = t370 * t490
  t492 = t200 * t206
  t495 = t370 * t430
  t496 = t407 * t206
  t499 = t357 * t443
  t500 = t412 * t169
  t503 = t484 * t89
  t504 = t370 * t503
  t507 = t395 * t206
  t510 = t401 * t206
  t513 = t259 * t73
  t514 = t350 * t329
  t515 = t514 * t209
  t516 = t513 * t515
  t519 = t266 * t73
  t520 = t350 * t429
  t521 = t520 * t209
  t522 = t519 * t521
  t525 = t252 * t73
  t526 = t514 * t253
  t527 = t525 * t526
  t530 = t180 * t153
  t531 = t530 * t135
  t532 = t357 * t531
  t533 = t214 * t73
  t534 = t514 * t109
  t535 = t533 * t534
  t538 = t196 * t73
  t539 = t520 * t109
  t540 = t538 * t539
  t543 = t538 * t534
  t546 = t163 * t73
  t547 = t546 * t515
  t550 = t252 * t253
  t551 = t371 * t550
  t554 = 0.6e1 * t491 * t492 - 0.12e2 * t495 * t496 + 0.24e2 * t499 * t500 - 0.4e1 * t504 * t398 + 0.2e1 * t483 * t507 + 0.6e1 * t495 * t510 + 0.4e1 * t360 * t516 - 0.8e1 * t360 * t522 - 0.4e1 / 0.3e1 * t372 * t527 - 0.4e1 * t532 * t535 + 0.8e1 * t532 * t540 - 0.2e1 * t532 * t543 - 0.8e1 / 0.3e1 * t409 * t547 + 0.4e1 * t483 * t551
  t555 = t214 * t109
  t556 = t531 * t555
  t559 = t163 * t209
  t560 = t408 * t559
  t563 = t163 * t231
  t564 = t371 * t563
  t567 = t371 * t559
  t571 = t109 * t153 * t135
  t572 = t196 * t180
  t573 = t571 * t572
  t576 = t266 * t209
  t577 = t359 * t576
  t580 = t180 * t188
  t581 = t580 * t89
  t582 = t182 * t109
  t583 = t581 * t582
  t586 = t402 * t559
  t589 = t519 * t515
  t592 = t364 * t329
  t593 = t592 * t209
  t594 = t546 * t593
  t597 = t514 * t231
  t598 = t546 * t597
  t601 = t370 * t581
  t602 = t182 * t73
  t603 = t602 * t534
  t608 = t259 * t209
  t609 = t359 * t608
  t612 = 0.12e2 * t450 * t556 + 0.8e1 * t483 * t560 - 0.2e1 * t483 * t564 - 0.6e1 * t495 * t567 - 0.12e2 * t499 * t573 + 0.12e2 * t499 * t577 - 0.12e2 * t483 * t583 - 0.4e1 * t483 * t586 + 0.2e1 * t360 * t589 + 0.2e1 * t372 * t594 + 0.2e1 / 0.3e1 * t372 * t598 + 0.4e1 * t601 * t603 + 0.4e1 / 0.3e1 * t403 * t547 - 0.12e2 * t450 * t609
  t614 = t428 + t488 + t554 + t612
  t651 = -0.2e1 / 0.3e1 * t403 * t398 + 0.4e1 / 0.3e1 * t409 * t398 - 0.2e1 / 0.3e1 * t360 * t415 + 0.2e1 / 0.3e1 * t372 * t547 - 0.4e1 / 0.3e1 * t360 * t459 - 0.4e1 / 0.3e1 * t372 * t404 + 0.8e1 / 0.3e1 * t360 * t462 - 0.2e1 * t59 * t391 + 0.4e1 * t495 * t492 - 0.4e1 * t499 * t425 + 0.2e1 * t483 * t510 - 0.4e1 * t483 * t496 - 0.2e1 * t483 * t567 + 0.4e1 * t450 * t432 - t6 * t335 * t36 / 0.24e2 + t6 * t42 * t340 / 0.12e2
  t652 = 0.1e1 / t9
  t664 = -0.2e1 / 0.3e1 * t372 * t398 - 0.2e1 * t59 * t366 + 0.2e1 * t483 * t492 + t6 * t42 * t35 / 0.12e2
  t673 = -0.2e1 * t59 * t352 + t4 * t5 * t7 * t23 / 0.6e1
  t676 = r0 + r1
  t677 = tau0 * t50
  t681 = 0.1e1 / t9 / t43 / t14
  t685 = f.my_piecewise3(t20, 0.6160e4 / 0.81e2 * t677 - 0.2618e4 / 0.81e2 * t13 * t681, 0)
  t689 = t340 ** 2
  t720 = t94 * t96 * t109
  t726 = t193 * t530
  t734 = t193 * t358
  t735 = t135 * t122
  t737 = t735 * t124 * t209
  t741 = t202 * t96 * t231
  t744 = t147 * t209
  t745 = t735 * t744
  t749 = t137 * t147 * t109
  t754 = t89 * t122 * t96 * t253
  t757 = -0.4e1 * t134 * t169 + 0.24e2 * t134 * t228 - 0.12e2 * t116 * t455 + 0.4e1 / 0.3e1 * t116 * t445 - 0.12e2 * t154 * t206 - 0.2e1 * t86 * t206 + 0.20e2 / 0.9e1 * t116 * t439 - 0.12e2 * t172 * t580 * t720 - 0.4e1 * t172 * t401 * t211 + 0.4e1 * t726 * t137 * t124 * t109 + 0.8e1 * t172 * t407 * t211 - 0.4e1 * t734 * t737 - 0.2e1 * t201 * t741 - 0.12e2 * t734 * t745 + 0.12e2 * t726 * t749 + 0.4e1 * t201 * t754
  t761 = t71 * t102 * t111
  t788 = t130 * t109
  t790 = t124 * t180
  t797 = t193 * t111
  t807 = -0.2e1 * t168 * t737 + 0.12e2 * t761 * t270 * t266 + 0.12e2 * t168 * t745 - 0.12e2 * t245 * t153 * t749 + 0.2e1 * t205 * t741 + 0.12e2 * t218 * t188 * t720 + 0.4e1 * t219 * t211 - 0.8e1 * t223 * t211 + 0.16e2 / 0.9e1 * t761 * t270 * t312 - 0.4e1 * t205 * t754 + 0.12e2 * t172 * t111 * t300 * t182 + 0.2e1 * t788 * t153 * t137 * t790 + 0.2e1 * t172 * t82 * t183 - 0.8e1 * t797 * t304 * t196 - 0.24e2 * t797 * t304 * t214 + 0.32e2 / 0.3e1 * t761 * t270 * t322
  t808 = t757 + t807
  t813 = t120 ** 2
  t814 = 0.1e1 / t813
  t815 = t814 * t96
  t816 = t253 * t209
  t822 = t180 * t133 * t135
  t829 = t814 * t124
  t830 = t829 * t73
  t839 = t814 * t147
  t844 = t357 * t822
  t845 = t520 * t110
  t855 = t514 * t110
  t872 = 0.112e3 * t450 * t413 * t608 + 0.44e2 * t450 * t359 * t839 * t253 - 0.96e2 * t844 * t538 * t845 - 0.112e3 / 0.3e1 * t414 * t516 - 0.44e2 / 0.3e1 * t360 * t839 * t73 * t526 + 0.48e2 * t844 * t533 * t855 - 0.8e1 * t495 * t564 - 0.6e1 * t483 * t402 * t563 - 0.2e1 * t483 * t371 * t163 * t808 - 0.12e2 * t491 * t567 - 0.16e2 * t495 * t586
  t875 = t82 * t188 * t89
  t889 = t36 ** 2
  t898 = t110 ** 2
  t899 = t74 * t102 * t898
  t900 = t113 ** 2
  t901 = 0.1e1 / t900
  t902 = t117 ** 2
  t903 = 0.1e1 / t902
  t905 = t899 * t901 * t903
  t906 = t814 * t142
  t910 = t814 * t125
  t923 = f.my_piecewise3(t67, t75, 0.3080e4 / 0.243e3 * l0 * t50 - 0.40559670781893004115226337448559670781893004115227e2 * t677 + 0.17237860082304526748971193415637860082304526748971e2 * s0 * t681)
  t924 = t74 * t923
  t927 = t124 ** 2
  t928 = t814 * t927
  t932 = t102 * t898
  t934 = 0.1e1 / t113 / t187
  t936 = t932 * t934 * t119
  t942 = t195 * t122
  t944 = t165 * t209
  t945 = t944 * t109
  t955 = t161 * t122
  t962 = t189 * t136
  t967 = t124 * t147
  t968 = t814 * t967
  t975 = t130 * t82 * t195
  t978 = t74 * t898
  t990 = t166 * t110
  t997 = 0.14e2 / 0.3e1 * t788 * t942 * t138 * t944 * t180 + 0.6e1 * t160 * t955 * t98 * t165 * t231 * t209 + 0.18e2 * t218 * t962 * t98 * t945 - 0.4e1 / 0.3e1 * t905 * t968 * t166 - 0.72e2 * t936 * t272 - 0.4e1 * t975 * t309 - 0.24e2 * t978 * t133 * t89 * t292 + 0.3e1 * t162 * t815 * t97 * t816 + 0.6e1 * t249 * t233 + 0.36e2 * t218 * t300 * t182 * t990 - 0.36e2 * t271 * t829 * t241
  t1000 = t102 * t180 * t270
  t1016 = t279 * t209
  t1030 = t83 * t189
  t1033 = t245 * t304
  t1037 = 0.36e2 * t1000 * t266 * t990 + 0.4e1 * t271 * t910 * t241 - 0.3e1 * t162 * t252 * t287 * t209 + 0.14e2 * t788 * t195 * t259 * t275 * t180 - 0.9e1 * t235 * t163 * t1016 + 0.8e1 * t975 * t263 - 0.28e2 / 0.3e1 * t246 * t266 * t1016 - 0.4e1 / 0.3e1 * t975 * t247 - 0.2e1 / 0.3e1 * t1000 * t312 * t990 - 0.8e1 * t1030 * t237 + 0.12e2 * t1033 * t196 * t990
  t1049 = t899 * t901
  t1050 = t903 * t814
  t1054 = t180 ** 2
  t1055 = t130 * t1054
  t1056 = t1055 * t153
  t1059 = t74 * t1054
  t1063 = t130 * t898
  t1064 = t1063 * t115
  t1070 = t932 * t934
  t1075 = -0.3e1 * t291 * t242 + 0.4e1 / 0.3e1 * t258 * t266 * t232 + 0.2e1 / 0.3e1 * t271 * t906 * t241 - t924 * t85 * t99 / 0.2e1 - 0.12e2 * t1049 * t1050 * t126 + 0.2e1 * t1056 * t139 + 0.3e1 * t1059 * t188 * t99 - 0.36e2 * t1064 * t149 + 0.12e2 * t978 * t133 * t99 - 0.40e2 * t1070 * t127 + 0.24e2 * t1064 * t139
  t1094 = t1063 * t115 * t135
  t1106 = 0.36e2 * t1070 * t157 - 0.3e1 * t1056 * t149 - 0.2e1 / 0.3e1 * t1070 * t144 + 0.10e2 / 0.3e1 * t1049 * t1050 * t967 * t97 + 0.50e2 / 0.3e1 * t1049 * t1050 * t143 - 0.3e1 * t240 * t233 - 0.12e2 * t1094 * t306 - 0.3e1 * t240 * t298 + 0.6e1 * t249 * t298 - 0.11e2 * t258 * t839 * t297 + 0.4e1 / 0.3e1 * t936 * t313
  t1109 = t1055 * t195
  t1123 = t167 * t304
  t1124 = t97 * t180
  t1138 = 0.72e2 * t1094 * t319 + 0.6e1 * t1109 * t319 - t1109 * t306 - 0.6e1 * t1059 * t189 * t292 - 0.8e1 / 0.3e1 * t258 * t266 * t287 + t162 * t163 * t97 * t808 / 0.2e1 + 0.36e2 * t1123 * t214 * t1124 - 0.28e2 * t305 * t276 - 0.18e2 * t222 * t300 * t182 * t1124 + 0.9e1 * t301 * t283 + 0.8e1 / 0.3e1 * t975 * t294
  t1141 = t102 * t110 * t270
  t1172 = 0.20e2 * t1141 * t322 * t1124 - 0.20e2 * t271 * t910 * t275 - 0.24e2 * t1123 * t196 * t1124 + 0.56e2 / 0.3e1 * t305 * t316 + t1141 * t312 * t1124 / 0.3e1 - t271 * t906 * t275 / 0.3e1 - 0.18e2 * t1141 * t266 * t1124 + 0.18e2 * t271 * t829 * t275 + 0.4e1 * t1030 * t280 + 0.3e1 / 0.2e1 * t291 * t283 - t162 * t163 * t166 * t808
  t1202 = -0.8e1 * t258 * t259 * t232 - 0.72e2 * t1033 * t214 * t990 - 0.4e1 * t1000 * t322 * t990 + 0.56e2 * t305 * t260 + 0.22e2 * t258 * t839 * t254 - 0.6e1 * t162 * t815 * t166 * t816 + 0.6e1 * t240 * t255 - 0.18e2 * t301 * t242 - 0.12e2 * t249 * t255 - 0.28e2 / 0.3e1 * t305 * t267 - 0.11e2 / 0.3e1 * t258 * t829 * t254
  t1211 = t180 * t115 * t119
  t1212 = t346 * t1211
  t1213 = t312 * t73
  t1236 = t82 * t153 * t135
  t1237 = t357 * t1236
  t1240 = t592 * t109
  t1244 = t322 * t73
  t1250 = t364 * t429
  t1264 = t910 * t73
  t1268 = 0.16e2 * t495 * t551 + 0.12e2 * t483 * t402 * t550 - 0.16e2 / 0.3e1 * t1237 * t535 - 0.16e2 * t532 * t533 * t1240 - 0.88e2 / 0.3e1 * t1212 * t1244 * t855 + 0.32e2 / 0.3e1 * t1237 * t540 + 0.32e2 * t532 * t538 * t1250 * t109 + 0.92e2 / 0.3e1 * t1212 * t1213 * t845 + 0.16e2 * t360 * t513 * t593 + 0.16e2 / 0.3e1 * t360 * t513 * t597 + 0.88e2 / 0.3e1 * t349 * t1264 * t515
  t1289 = t906 * t73
  t1301 = t124 * t73 * t350
  t1308 = t357 * t73
  t1309 = t350 * t422
  t1317 = t370 * t73 * t539
  t1332 = t357 * t180 * t942
  t1336 = t329 * t109 * t209
  t1348 = t96 * t73 * t350
  t1365 = 0.56e2 * t1308 * t1309 * t109 * t942 * t790 * t209 + 0.36e2 * t1317 * t962 * t210 * t180 + 0.12e2 * t1317 * t955 * t210 * t231 - 0.56e2 * t1308 * t539 * t942 * t744 * t180 + 0.56e2 / 0.3e1 * t1332 * t147 * t73 * t350 * t1336 - 0.112e3 / 0.3e1 * t1332 * t1301 * t429 * t109 * t209 - 0.12e2 * t370 * t180 * t962 * t1348 * t1336 - 0.4e1 * t370 * t109 * t955 * t1348 * t329 * t231 * t209 - 0.4e1 * t403 * t527 - 0.4e1 * t409 * t598 - 0.56e2 / 0.3e1 * t414 * t589
  t1376 = t530 * t89
  t1433 = -0.92e2 / 0.3e1 * t349 * t1289 * t521 - 0.112e3 * t499 * t413 * t576 + 0.16e2 * t499 * t359 * t266 * t231 - 0.24e2 * t1212 * t519 * t855 + 0.112e3 * t1212 * t1244 * t845 + 0.2e1 * t397 * t547 + 0.16e2 / 0.3e1 * t403 * t594 + 0.144e3 * t499 * t110 * t133 * t135 * t572 - 0.36e2 * t483 * t503 * t559 - 0.24e2 * t483 * t408 * t550 + 0.48e2 * t424 * t577
  t1495 = t1054 * t153
  t1508 = t923 * t85
  t1515 = 0.72e2 * t349 * t1289 * t1309 * t209 + 0.4e1 * t372 * t815 * t73 * t514 * t816 + 0.12e2 * t504 * t547 + 0.8e1 * t409 * t527 - 0.24e2 * t370 * t1376 * t602 * t855 - 0.12e2 * t499 * t1495 * t169 - 0.48e2 * t349 * t312 * t423 + 0.24e2 * t357 * t490 * t432 - 0.4e1 * t360 * t196 * t391 - 0.2e1 / 0.3e1 * t370 * t1508 * t89 * t398 - 0.8e1 / 0.3e1 * t397 * t404
  t1518 = params.c * t102 * jnp.pi
  t1519 = t898 * t901
  t1521 = t1518 * t1519 * t903
  t1529 = t898 * t115
  t1531 = t357 * t1529 * t135
  t1539 = t357 * t1495 * t135
  t1556 = t898 * t934
  t1558 = t346 * t1556 * t119
  t1590 = -0.24e2 * t357 * t390 * t422 * t425 + 0.40e2 / 0.3e1 * t1558 * t353 + 0.16e2 * t414 * t418 - 0.8e1 / 0.3e1 * t372 * t182 * t330 - 0.496e3 / 0.3e1 * t1521 * t968 * t443 + 0.48e2 * t346 * t430 * t456 - 0.48e2 * t1518 * t351 / t435 / t71 * t1519 * t1050 * t927 - 0.8e1 * t360 * t214 * t391 + 0.16e2 * t360 * t196 * t490 + 0.32e2 * t414 * t367 - 0.4e1 * t403 * t392
  t1597 = t1054 * t188
  t1639 = t898 * t133
  t1657 = -0.16e2 * t1521 * t910 * t352 + 0.144e3 * t1518 * t437 * t1519 * t1050 * t967 - 0.4e1 * t1539 * t459 + 0.8e1 * t1539 * t462 - 0.24e2 * t491 * t496 - 0.48e2 * t483 * t1639 * t206 - 0.488e3 / 0.27e2 * t1521 * t968 * t352 + 0.352e3 / 0.27e2 * t1521 * t928 * t449 - 0.16e2 * t349 * t266 * t366 - 0.224e3 * t1558 * t474 + 0.376e3 / 0.3e1 * t1521 * t906 * t449
  t1722 = 0.48e2 * t1558 * t471 - 0.64e2 * t414 * t477 - 0.176e3 / 0.9e1 * t349 * t322 * t366 + 0.184e3 / 0.9e1 * t349 * t312 * t430 + 0.48e2 * t346 * t365 * t436 * t440 - 0.96e2 * t346 * t423 * t446 + 0.96e2 * t1531 * t462 + 0.8e1 * t495 * t507 + 0.2e1 * t483 * t1508 * t206 + 0.12e2 * t491 * t510 + 0.16e2 * t370 * t1639 * t89 * t398
  d1111 = 0.4e1 * t614 * t8 + 0.4e1 * t651 * t652 - 0.8e1 / 0.3e1 * t664 * t11 + 0.40e2 / 0.27e2 * t673 * t16 + t676 * (0.4e1 * t372 * t546 * t389 * t329 * t209 - 0.144e3 * t1518 * t443 * t1519 * t1050 * t142 + 0.48e2 * t1518 * t449 * t1519 * t1050 * t125 + 0.288e3 * t444 * t1556 * t445 + 0.712e3 / 0.9e1 * t1521 * t968 * t449 - 0.344e3 / 0.9e1 * t1521 * t928 * t443 + 0.12e2 * t450 * t1495 * t228 - 0.144e3 * t499 * t1529 * t169 - 0.304e3 / 0.9e1 * t1521 * t906 * t352 - 0.144e3 * t454 * t1556 * t455 + t1590 + t6 * t42 * t685 / 0.12e2 - t6 * t335 * t689 / 0.8e1 - 0.16e2 * t483 * t875 * t582 - 0.20e2 / 0.3e1 * t1212 * t1213 * t855 + 0.16e2 / 0.3e1 * t370 * t875 * t603 + 0.16e2 * t601 * t602 * t1240 + 0.24e2 * t844 * t538 * t855 - 0.6e1 * t483 * t396 * t559 + 0.8e1 * t360 * t519 * t593 + 0.8e1 / 0.3e1 * t360 * t519 * t597 + 0.20e2 / 0.3e1 * t349 * t1289 * t515 - 0.8e1 * t532 * t538 * t1240 - 0.22e2 / 0.3e1 * t360 * t830 * t526 + 0.16e2 * t450 * t1236 * t555 + 0.12e2 * t483 * t408 * t563 + 0.24e2 * t349 * t830 * t515 - 0.112e3 * t349 * t1264 * t521 - 0.70e2 / 0.27e2 * t1521 * t928 * t352 + 0.224e3 / 0.3e1 * t349 * t322 * t430 + 0.64e2 * t1521 * t928 * t437 - 0.40e2 / 0.9e1 * t349 * t312 * t366 - 0.12e2 * t483 * t1597 * t206 + 0.144e3 * t450 * t1529 * t228 - 0.144e3 * t438 * t1556 * t439 + t872 + t1433 + 0.8e1 * t370 * t328 * t429 * t492 + 0.4e1 * t370 * t1597 * t89 * t398 + 0.3e1 / 0.8e1 * t6 * t26 * t36 * t340 - 0.16e2 / 0.3e1 * t372 * t525 * t592 * t253 + 0.72e2 * t483 * t1376 * t182 * t110 - 0.32e2 * t360 * t519 * t1250 * t209 - 0.32e2 / 0.3e1 * t360 * t519 * t520 * t231 - 0.72e2 * t438 * t348 * t906 * t209 + 0.144e3 * t444 * t348 * t910 * t209 - 0.72e2 * t454 * t348 * t829 * t209 - 0.44e2 * t499 * t359 * t829 * t253 - 0.144e3 * t444 * t1211 * t322 * t110 + 0.72e2 * t454 * t1211 * t266 * t110 - 0.72e2 * t1212 * t1213 * t1309 * t110 + 0.8e1 / 0.3e1 * t372 * t546 * t592 * t231 + 0.2e1 / 0.3e1 * t372 * t546 * t514 * t808 - 0.12e2 * t483 * t371 * t815 * t816 - 0.144e3 * t450 * t822 * t214 * t110 + 0.88e2 / 0.3e1 * t360 * t830 * t520 * t253 - t6 * t335 * t35 * t54 / 0.6e1 - 0.2e1 * t59 * t73 * (0.3e1 / 0.2e1 * t240 * t288 - 0.3e1 * t249 * t288 + 0.8e1 / 0.3e1 * t905 * t906 * t166 + 0.24e2 * t905 * t910 * t166 + 0.22e2 / 0.3e1 * t258 * t829 * t297 + t924 * t161 * t292 - t905 * t928 * t166 / 0.9e1 + 0.8e1 * t936 * t323 + 0.4e1 * t258 * t259 * t287 - 0.28e2 * t245 * t942 * t148 * t945 + t997 + t1037 + t1075 + t1106 + t1138 + t1172 + t1202) * t329 - 0.16e2 * t499 * t571 * t196 * t82 - 0.16e2 * t450 * t359 * t259 * t231 + t1657 + t1268 + 0.28e2 / 0.3e1 * t357 * t109 * t942 * t1301 * t329 * t209 * t180 + t1722 + 0.144e3 * t1558 * t480 + 0.176e3 / 0.3e1 * t1558 * t465 - 0.184e3 / 0.3e1 * t1558 * t468 + 0.32e2 * t495 * t560 - 0.32e2 / 0.3e1 * t409 * t594 + 0.48e2 * t431 * t556 - 0.48e2 * t1531 * t459 - 0.96e2 * t431 * t451 - 0.48e2 * t424 * t573 - 0.48e2 * t495 * t583 + 0.224e3 / 0.3e1 * t414 * t522 + 0.2e1 * t403 * t598 - 0.8e1 / 0.3e1 * t1237 * t543 - 0.48e2 * t431 * t609 + 0.96e2 * t424 * t500 - 0.16e2 * t504 * t404 - 0.24e2 * t1531 * t415 + 0.48e2 * t495 * t485 + 0.8e1 * t409 * t392 - 0.2e1 * t1539 * t415 - 0.5e1 / 0.32e2 * t6 * t7 / t23 / t22 / t21 * t889 + 0.72e2 * t438 * t110 * t115 * t119 * t312 * t180 + t1515 + t1365) * t8 + 0.4e1 / 0.3e1 * t676 * t614 * t652 - 0.4e1 / 0.3e1 * t676 * t651 * t11 + 0.40e2 / 0.27e2 * t676 * t664 * t16 - 0.80e2 / 0.81e2 * t676 * t673 * t31

  res = {'v4rho4': d1111}
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_alpha_raw = params.alpha
  if isinstance(params_alpha_raw, (str, bytes, dict)):
    params_alpha = params_alpha_raw
  else:
    try:
      params_alpha_seq = list(params_alpha_raw)
    except TypeError:
      params_alpha = params_alpha_raw
    else:
      params_alpha_seq = np.asarray(params_alpha_seq, dtype=np.float64)
      params_alpha = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_seq))
  params_c_raw = params.c
  if isinstance(params_c_raw, (str, bytes, dict)):
    params_c = params_c_raw
  else:
    try:
      params_c_seq = list(params_c_raw)
    except TypeError:
      params_c = params_c_raw
    else:
      params_c_seq = np.asarray(params_c_seq, dtype=np.float64)
      params_c = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_seq))

  br89_min_Q = 5e-13

  br89_v = lambda x: -2 * jnp.pi ** (1 / 3) / X_FACTOR_C * jnp.exp(x / 3) * (1 - jnp.exp(-x) * (1 + x / 2)) / x

  params_gamma = 0.8

  tb09_c_HEG = (3 * params_c - 2) * jnp.sqrt(5 / 12) / jnp.pi

  br89_cQ = lambda Q: f.my_piecewise3(jnp.abs(Q) < br89_min_Q, f.my_piecewise3(Q > 0, br89_min_Q, -br89_min_Q), Q)

  br89_Q = lambda x, u, t: (u - 4 * params_gamma * t + params_gamma * x ** 2 / 2) / 6

  tb09_f = lambda rs, z, x, u, t: (params_c * X_FACTOR_C * br89_v(br89_x(br89_cQ(br89_Q(x, u, t)))) + tb09_c_HEG * jnp.sqrt(2 * jnp.maximum(t - params_alpha * x ** 2 / 8, 1e-10))) * f.n_spin(rs, z) ** (1 / 3)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1=None: tb09_f(rs, z, xs0, u0, t0)

  t1 = jnp.pi ** (0.1e1 / 0.3e1)
  t2 = params.c * t1
  t3 = r0 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t6 = 0.1e1 / t4 / r0
  t9 = tau0 * t6
  t11 = r0 ** 2
  t13 = 0.1e1 / t4 / t11
  t16 = l0 * t6 / 0.6e1 - 0.53333333333333333333333333333333333333333333333333e0 * t9 + 0.66666666666666666666666666666666666666666666666667e-1 * s0 * t13
  t17 = abs(t16)
  t18 = t17 < 0.50e-12
  t19 = 0.0e0 < t16
  t20 = f.my_piecewise3(t19, 0.50e-12, -0.50e-12)
  t21 = f.my_piecewise3(t18, t20, t16)
  t22 = br89_x(t21)
  t24 = jnp.exp(t22 / 0.3e1)
  t25 = jnp.exp(-t22)
  t28 = t25 * (0.1e1 + t22 / 0.2e1)
  t30 = t24 * (0.1e1 - t28)
  t31 = 0.1e1 / t22
  t32 = t30 * t31
  t37 = jnp.sqrt(0.15e2)
  t38 = (0.3e1 * params.c - 0.2e1) * t37
  t39 = 0.1e1 / jnp.pi
  t40 = jnp.sqrt(0.2e1)
  t42 = params.alpha * s0
  t45 = t9 - t42 * t13 / 0.8e1
  t46 = 0.1e-9 < t45
  t47 = f.my_piecewise3(t46, t45, 0.1e-9)
  t48 = jnp.sqrt(t47)
  t52 = -0.2e1 * t2 * t32 + t38 * t39 * t40 * t48 / 0.6e1
  t53 = t52 * t3
  t54 = r0 + r1
  t55 = params.c * jnp.pi
  t56 = f.my_piecewise3(t19, 0, 0)
  t59 = tau0 * t13
  t63 = 0.1e1 / t4 / t11 / r0
  t67 = f.my_piecewise3(t18, t56, -0.5e1 / 0.18e2 * l0 * t13 + 0.88888888888888888888888888888888888888888888888889e0 * t59 - 0.17777777777777777777777777777777777777777777777778e0 * s0 * t63)
  t68 = t21 ** 2
  t69 = 0.1e1 / t68
  t70 = t67 * t69
  t72 = jnp.exp(-0.2e1 / 0.3e1 * t22)
  t73 = 0.1e1 / t72
  t76 = t22 ** 2
  t79 = 0.1e1 / (t76 - 0.2e1 * t22 + 0.3e1)
  t81 = (t22 - 0.2e1) ** 2
  t82 = t79 * t81
  t83 = t82 * t32
  t86 = t1 ** 2
  t87 = t86 * t67
  t88 = t69 * t73
  t90 = t82 * t28
  t93 = t73 * t79
  t95 = t93 * t81 * t25
  t105 = t55 * t30 / t76
  t106 = t93 * t81
  t110 = t38 * t39
  t112 = t40 / t48
  t117 = f.my_piecewise3(t46, -0.5e1 / 0.3e1 * t59 + t42 * t63 / 0.3e1, 0)
  vrho_0_ = t53 + t54 * (-0.2e1 / 0.3e1 * t55 * t70 * t73 * t83 - 0.2e1 * t2 * t24 * (t87 * t88 * t90 - t87 * t69 * t95 / 0.2e1) * t31 + 0.2e1 * t105 * t70 * t106 + t110 * t112 * t117 / 0.12e2) * t3 + t54 * t52 / t4 / 0.3e1
  vrho_1_ = t53
  t129 = f.my_piecewise3(t18, t56, 0.66666666666666666666666666666666666666666666666667e-1 * t13)
  t130 = t129 * t69
  t135 = t86 * t129
  t151 = f.my_piecewise3(t46, -params.alpha * t13 / 0.8e1, 0)
  vsigma_0_ = t54 * (-0.2e1 / 0.3e1 * t55 * t130 * t73 * t83 - 0.2e1 * t2 * t24 * (t135 * t88 * t90 - t135 * t69 * t95 / 0.2e1) * t31 + 0.2e1 * t105 * t130 * t106 + t110 * t112 * t151 / 0.12e2) * t3
  vsigma_1_ = 0.0e0
  vsigma_2_ = 0.0e0
  t158 = f.my_piecewise3(t18, t56, t6 / 0.6e1)
  t159 = t158 * t69
  t164 = t86 * t158
  vlapl_0_ = t54 * (-0.2e1 / 0.3e1 * t55 * t159 * t73 * t83 - 0.2e1 * t2 * t24 * (t164 * t88 * t90 - t164 * t69 * t95 / 0.2e1) * t31 + 0.2e1 * t105 * t159 * t106) * t3
  vlapl_1_ = 0.0e0
  t181 = f.my_piecewise3(t18, t56, -0.53333333333333333333333333333333333333333333333333e0 * t6)
  t182 = t181 * t69
  t187 = t86 * t181
  t201 = f.my_piecewise3(t46, t6, 0)
  vtau_0_ = t54 * (-0.2e1 / 0.3e1 * t55 * t182 * t73 * t83 - 0.2e1 * t2 * t24 * (t187 * t88 * t90 - t187 * t69 * t95 / 0.2e1) * t31 + 0.2e1 * t105 * t182 * t106 + t110 * t112 * t201 / 0.12e2) * t3
  vtau_1_ = 0.0e0
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_alpha_raw = params.alpha
  if isinstance(params_alpha_raw, (str, bytes, dict)):
    params_alpha = params_alpha_raw
  else:
    try:
      params_alpha_seq = list(params_alpha_raw)
    except TypeError:
      params_alpha = params_alpha_raw
    else:
      params_alpha_seq = np.asarray(params_alpha_seq, dtype=np.float64)
      params_alpha = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_seq))
  params_c_raw = params.c
  if isinstance(params_c_raw, (str, bytes, dict)):
    params_c = params_c_raw
  else:
    try:
      params_c_seq = list(params_c_raw)
    except TypeError:
      params_c = params_c_raw
    else:
      params_c_seq = np.asarray(params_c_seq, dtype=np.float64)
      params_c = np.concatenate((np.array([np.nan], dtype=np.float64), params_c_seq))

  br89_min_Q = 5e-13

  br89_v = lambda x: -2 * jnp.pi ** (1 / 3) / X_FACTOR_C * jnp.exp(x / 3) * (1 - jnp.exp(-x) * (1 + x / 2)) / x

  params_gamma = 0.8

  tb09_c_HEG = (3 * params_c - 2) * jnp.sqrt(5 / 12) / jnp.pi

  br89_cQ = lambda Q: f.my_piecewise3(jnp.abs(Q) < br89_min_Q, f.my_piecewise3(Q > 0, br89_min_Q, -br89_min_Q), Q)

  br89_Q = lambda x, u, t: (u - 4 * params_gamma * t + params_gamma * x ** 2 / 2) / 6

  tb09_f = lambda rs, z, x, u, t: (params_c * X_FACTOR_C * br89_v(br89_x(br89_cQ(br89_Q(x, u, t)))) + tb09_c_HEG * jnp.sqrt(2 * jnp.maximum(t - params_alpha * x ** 2 / 8, 1e-10))) * f.n_spin(rs, z) ** (1 / 3)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1=None: tb09_f(rs, z, xs0, u0, t0)

  t1 = jnp.pi ** (0.1e1 / 0.3e1)
  t2 = params.c * t1
  t3 = 2 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t5 = l0 * t4
  t6 = r0 ** (0.1e1 / 0.3e1)
  t7 = t6 ** 2
  t9 = 0.1e1 / t7 / r0
  t12 = tau0 * t4
  t13 = t12 * t9
  t15 = s0 * t4
  t16 = r0 ** 2
  t18 = 0.1e1 / t7 / t16
  t21 = t5 * t9 / 0.6e1 - 0.53333333333333333333333333333333333333333333333333e0 * t13 + 0.66666666666666666666666666666666666666666666666667e-1 * t15 * t18
  t22 = abs(t21)
  t23 = t22 < 0.50e-12
  t24 = 0.0e0 < t21
  t25 = f.my_piecewise3(t24, 0.50e-12, -0.50e-12)
  t26 = f.my_piecewise3(t23, t25, t21)
  t27 = br89_x(t26)
  t29 = jnp.exp(t27 / 0.3e1)
  t30 = jnp.exp(-t27)
  t33 = t30 * (0.1e1 + t27 / 0.2e1)
  t35 = t29 * (0.1e1 - t33)
  t36 = 0.1e1 / t27
  t37 = t35 * t36
  t42 = jnp.sqrt(0.15e2)
  t43 = (0.3e1 * params.c - 0.2e1) * t42
  t44 = 0.1e1 / jnp.pi
  t45 = jnp.sqrt(0.2e1)
  t47 = params.alpha * s0
  t48 = t4 * t18
  t51 = t13 - t47 * t48 / 0.8e1
  t52 = 0.1e-9 < t51
  t53 = f.my_piecewise3(t52, t51, 0.1e-9)
  t54 = jnp.sqrt(t53)
  t62 = t6 * r0
  t63 = params.c * jnp.pi
  t64 = f.my_piecewise3(t24, 0, 0)
  t67 = t12 * t18
  t71 = 0.1e1 / t7 / t16 / r0
  t75 = f.my_piecewise3(t23, t64, -0.5e1 / 0.18e2 * t5 * t18 + 0.88888888888888888888888888888888888888888888888889e0 * t67 - 0.17777777777777777777777777777777777777777777777778e0 * t15 * t71)
  t76 = t26 ** 2
  t77 = 0.1e1 / t76
  t78 = t75 * t77
  t80 = jnp.exp(-0.2e1 / 0.3e1 * t27)
  t81 = 0.1e1 / t80
  t84 = t27 ** 2
  t87 = 0.1e1 / (t84 - 0.2e1 * t27 + 0.3e1)
  t89 = (t27 - 0.2e1) ** 2
  t90 = t87 * t89
  t91 = t90 * t37
  t94 = t1 ** 2
  t95 = t94 * t75
  t96 = t77 * t81
  t98 = t90 * t33
  t101 = t81 * t87
  t103 = t101 * t89 * t30
  t113 = t63 * t35 / t84
  t114 = t101 * t89
  t118 = t43 * t44
  t120 = t45 / t54
  t126 = f.my_piecewise3(t52, -0.5e1 / 0.3e1 * t67 + t47 * t4 * t71 / 0.3e1, 0)
  vrho_0_ = 0.2e1 / 0.3e1 * (-0.2e1 * t2 * t37 + t43 * t44 * t45 * t54 / 0.6e1) * t4 * t6 + t62 * (-0.2e1 / 0.3e1 * t63 * t78 * t81 * t91 - 0.2e1 * t2 * t29 * (t95 * t96 * t98 - t95 * t77 * t103 / 0.2e1) * t36 + 0.2e1 * t113 * t78 * t114 + t118 * t120 * t126 / 0.12e2) * t4 / 0.2e1
  t135 = f.my_piecewise3(t23, t64, 0.66666666666666666666666666666666666666666666666667e-1 * t48)
  t136 = t135 * t77
  t141 = t94 * t135
  t158 = f.my_piecewise3(t52, -params.alpha * t4 * t18 / 0.8e1, 0)
  vsigma_0_ = t62 * (-0.2e1 / 0.3e1 * t63 * t136 * t81 * t91 - 0.2e1 * t2 * t29 * (t141 * t96 * t98 - t141 * t77 * t103 / 0.2e1) * t36 + 0.2e1 * t113 * t136 * t114 + t118 * t120 * t158 / 0.12e2) * t4 / 0.2e1
  t165 = t4 * t9
  t167 = f.my_piecewise3(t23, t64, t165 / 0.6e1)
  t168 = t167 * t77
  t173 = t94 * t167
  vlapl_0_ = t62 * (-0.2e1 / 0.3e1 * t63 * t168 * t81 * t91 - 0.2e1 * t2 * t29 * (t173 * t96 * t98 - t173 * t77 * t103 / 0.2e1) * t36 + 0.2e1 * t113 * t168 * t114) * t4 / 0.2e1
  t191 = f.my_piecewise3(t23, t64, -0.53333333333333333333333333333333333333333333333333e0 * t165)
  t192 = t191 * t77
  t197 = t94 * t191
  t211 = f.my_piecewise3(t52, t165, 0)
  vtau_0_ = t62 * (-0.2e1 / 0.3e1 * t63 * t192 * t81 * t91 - 0.2e1 * t2 * t29 * (t197 * t96 * t98 - t197 * t77 * t103 / 0.2e1) * t36 + 0.2e1 * t113 * t192 * t114 + t118 * t120 * t211 / 0.12e2) * t4 / 0.2e1
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

