"""Generated from gga_c_pbeloc.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  params_BB = 1

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  pbeloc_b0 = 0.0375

  pbeloc_a = 0.08

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  BB = params_BB

  mbeta = lambda rs, t: pbeloc_b0 + pbeloc_a * t ** 2 * (1 - jnp.exp(-rs ** 2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  f1 = lambda rs, z, t: t ** 2 + BB * A(rs, z, t) * t ** 4

  f2 = lambda rs, z, t: mbeta(rs, t) * f1(rs, z, t) / (mgamma * (1 + A(rs, z, t) * f1(rs, z, t)))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  functional_body = lambda rs, z, xt, xs0, xs1: f_pbe(rs, z, xt, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  params_BB = 1

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  pbeloc_b0 = 0.0375

  pbeloc_a = 0.08

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  BB = params_BB

  mbeta = lambda rs, t: pbeloc_b0 + pbeloc_a * t ** 2 * (1 - jnp.exp(-rs ** 2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  f1 = lambda rs, z, t: t ** 2 + BB * A(rs, z, t) * t ** 4

  f2 = lambda rs, z, t: mbeta(rs, t) * f1(rs, z, t) / (mgamma * (1 + A(rs, z, t) * f1(rs, z, t)))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  functional_body = lambda rs, z, xt, xs0, xs1: f_pbe(rs, z, xt, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  params_BB = 1

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  pbeloc_b0 = 0.0375

  pbeloc_a = 0.08

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  BB = params_BB

  mbeta = lambda rs, t: pbeloc_b0 + pbeloc_a * t ** 2 * (1 - jnp.exp(-rs ** 2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  f1 = lambda rs, z, t: t ** 2 + BB * A(rs, z, t) * t ** 4

  f2 = lambda rs, z, t: mbeta(rs, t) * f1(rs, z, t) / (mgamma * (1 + A(rs, z, t) * f1(rs, z, t)))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  functional_body = lambda rs, z, xt, xs0, xs1: f_pbe(rs, z, xt, xs0, xs1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t11 = t4 * t6 / t8
  t13 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t11
  t14 = jnp.sqrt(t11)
  t17 = t11 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t8 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.23615562999000000000000000000000000000000000000000e0 * t14 + 0.55770497660000000000000000000000000000000000000000e-1 * t11 + 0.12733196185000000000000000000000000000000000000000e-1 * t17 + 0.76629248290000000000000000000000000000000000000000e-2 * t25
  t29 = 0.1e1 + 0.1e1 / t27
  t30 = jnp.log(t29)
  t31 = t13 * t30
  t32 = r0 - r1
  t33 = t32 ** 2
  t34 = t33 ** 2
  t35 = t7 ** 2
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t38 = t34 * t37
  t39 = 0.1e1 / t7
  t40 = t32 * t39
  t41 = 0.1e1 + t40
  t42 = t41 <= f.p.zeta_threshold
  t43 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t44 = t43 * f.p.zeta_threshold
  t45 = t41 ** (0.1e1 / 0.3e1)
  t47 = f.my_piecewise3(t42, t44, t45 * t41)
  t48 = 0.1e1 - t40
  t49 = t48 <= f.p.zeta_threshold
  t50 = t48 ** (0.1e1 / 0.3e1)
  t52 = f.my_piecewise3(t49, t44, t50 * t48)
  t54 = 2 ** (0.1e1 / 0.3e1)
  t57 = 0.1e1 / (0.2e1 * t54 - 0.2e1)
  t58 = (t47 + t52 - 0.2e1) * t57
  t60 = 0.3109070e-1 + 0.15971292590000000000000000000000000000000000000000e-2 * t11
  t65 = 0.21948324211500000000000000000000000000000000000000e0 * t14 + 0.48172707847500000000000000000000000000000000000000e-1 * t11 + 0.13082189292500000000000000000000000000000000000000e-1 * t17 + 0.48592432297500000000000000000000000000000000000000e-2 * t25
  t67 = 0.1e1 + 0.1e1 / t65
  t68 = jnp.log(t67)
  t71 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t11
  t76 = 0.17489762330000000000000000000000000000000000000000e0 * t14 + 0.30591463695000000000000000000000000000000000000000e-1 * t11 + 0.37162156485000000000000000000000000000000000000000e-2 * t17 + 0.41939460495000000000000000000000000000000000000000e-2 * t25
  t78 = 0.1e1 + 0.1e1 / t76
  t79 = jnp.log(t78)
  t80 = t71 * t79
  t82 = -t60 * t68 + t31 - 0.58482236226346462072622386637590534819724553404281e0 * t80
  t83 = t58 * t82
  t84 = t38 * t83
  t86 = 0.58482236226346462072622386637590534819724553404281e0 * t58 * t80
  t87 = jnp.log(0.2e1)
  t88 = 0.1e1 - t87
  t89 = jnp.pi ** 2
  t90 = 0.1e1 / t89
  t91 = t88 * t90
  t92 = t43 ** 2
  t93 = t45 ** 2
  t94 = f.my_piecewise3(t42, t92, t93)
  t95 = t50 ** 2
  t96 = f.my_piecewise3(t49, t92, t95)
  t98 = t94 / 0.2e1 + t96 / 0.2e1
  t99 = t98 ** 2
  t100 = t99 * t98
  t102 = s0 + 0.2e1 * s1 + s2
  t104 = 0.1e1 / t8 / t35
  t105 = t102 * t104
  t106 = 0.1e1 / t99
  t107 = t54 * t106
  t109 = 0.1e1 / t3
  t110 = t19 * t109
  t112 = jnp.exp(-t25 / 0.4e1)
  t113 = 0.1e1 - t112
  t114 = t5 * t113
  t115 = t110 * t114
  t118 = 0.375e-1 + 0.83333333333333333333333333333333333333333333333333e-3 * t105 * t107 * t115
  t120 = t106 * t19
  t122 = t120 * t109 * t5
  t125 = 0.1e1 / t88
  t126 = t118 * t125
  t128 = (-t31 + t84 + t86) * t125
  t129 = 0.1e1 / t100
  t130 = t89 * t129
  t132 = jnp.exp(-t128 * t130)
  t133 = t132 - 0.1e1
  t134 = 0.1e1 / t133
  t135 = t89 * t134
  t136 = t102 ** 2
  t137 = t135 * t136
  t138 = t126 * t137
  t140 = 0.1e1 / t22 / t36
  t141 = t54 ** 2
  t143 = t99 ** 2
  t144 = 0.1e1 / t143
  t146 = 0.1e1 / t20
  t148 = t1 * t146 * t6
  t149 = t140 * t141 * t144 * t148
  t152 = t105 * t54 * t122 / 0.96e2 + t138 * t149 / 0.3072e4
  t153 = t118 * t152
  t155 = t135 * t152
  t157 = t126 * t155 + 0.1e1
  t159 = t125 * t89 / t157
  t161 = t153 * t159 + 0.1e1
  t162 = jnp.log(t161)
  t164 = t91 * t100 * t162
  t166 = 0.1e1 / t8 / t7
  t167 = t6 * t166
  t170 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t167 * t30
  t171 = t27 ** 2
  t176 = t3 * t6
  t177 = t176 * t166
  t178 = 0.1e1 / t14 * t1 * t177
  t180 = t4 * t167
  t182 = t11 ** 0.5e0
  t184 = t182 * t1 * t177
  t189 = t21 * t5 / t22 / t7
  t194 = t13 / t171 * (-0.39359271665000000000000000000000000000000000000000e-1 * t178 - 0.18590165886666666666666666666666666666666666666667e-1 * t180 - 0.63665980925000000000000000000000000000000000000000e-2 * t184 - 0.51086165526666666666666666666666666666666666666667e-2 * t189) / t29
  t198 = 0.4e1 * t33 * t32 * t37 * t83
  t199 = t36 * t7
  t203 = 0.4e1 * t34 / t199 * t83
  t205 = t32 / t35
  t206 = t39 - t205
  t209 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t206)
  t210 = -t206
  t213 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t210)
  t215 = (t209 + t213) * t57
  t217 = t38 * t215 * t82
  t221 = t65 ** 2
  t235 = t76 ** 2
  t236 = 0.1e1 / t235
  t242 = -0.29149603883333333333333333333333333333333333333333e-1 * t178 - 0.10197154565000000000000000000000000000000000000000e-1 * t180 - 0.18581078242500000000000000000000000000000000000000e-2 * t184 - 0.27959640330000000000000000000000000000000000000000e-2 * t189
  t243 = 0.1e1 / t78
  t249 = t38 * t58 * (0.53237641966666666666666666666666666666666666666667e-3 * t4 * t167 * t68 + t60 / t221 * (-0.36580540352500000000000000000000000000000000000000e-1 * t178 - 0.16057569282500000000000000000000000000000000000000e-1 * t180 - 0.65410946462500000000000000000000000000000000000000e-2 * t184 - 0.32394954865000000000000000000000000000000000000000e-2 * t189) / t67 - t170 - t194 + 0.18311447306006545054854346104378990962041954983034e-3 * t4 * t167 * t79 + 0.58482236226346462072622386637590534819724553404281e0 * t71 * t236 * t242 * t243)
  t251 = 0.58482236226346462072622386637590534819724553404281e0 * t215 * t80
  t256 = 0.18311447306006545054854346104378990962041954983034e-3 * t58 * t1 * t176 * t166 * t79
  t261 = 0.58482236226346462072622386637590534819724553404281e0 * t58 * t71 * t236 * t242 * t243
  t262 = t99 * t162
  t263 = 0.1e1 / t45
  t266 = f.my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t263 * t206)
  t267 = 0.1e1 / t50
  t270 = f.my_piecewise3(t49, 0, 0.2e1 / 0.3e1 * t267 * t210)
  t272 = t266 / 0.2e1 + t270 / 0.2e1
  t276 = t35 * t7
  t279 = t102 / t8 / t276
  t282 = 0.19444444444444444444444444444444444444444444444444e-2 * t279 * t107 * t115
  t284 = t105 * t54 * t129
  t294 = 0.41666666666666666666666666666666666666666666666666e-3 * t102 * t37 * t107 * t4 * t6 * t112
  t295 = -t282 - 0.16666666666666666666666666666666666666666666666667e-2 * t284 * t110 * t114 * t272 - t294
  t300 = 0.7e1 / 0.288e3 * t279 * t54 * t122
  t305 = t295 * t125
  t309 = t126 * t89
  t310 = t133 ** 2
  t311 = 0.1e1 / t310
  t314 = t309 * t311 * t136 * t140
  t316 = t141 * t144 * t1
  t317 = t146 * t6
  t321 = t89 * t144
  t326 = (-(t170 + t194 + t198 - t203 + t217 + t249 + t251 - t256 - t261) * t125 * t130 + 0.3e1 * t128 * t321 * t272) * t132
  t337 = 0.7e1 / 0.4608e4 * t138 / t22 / t199 * t141 * t144 * t148
  t338 = t134 * t136
  t340 = t309 * t338 * t140
  t344 = t141 / t143 / t98 * t1
  t349 = -t300 - t284 * t110 * t5 * t272 / 0.48e2 + t305 * t137 * t149 / 0.3072e4 - t314 * t316 * t317 * t326 / 0.3072e4 - t337 - t340 * t344 * t317 * t272 / 0.768e3
  t352 = t153 * t125
  t353 = t157 ** 2
  t355 = t89 / t353
  t357 = t311 * t152
  t367 = 0.1e1 / t161
  t370 = t170 + t194 + t198 - t203 + t217 + t249 + t251 - t256 - t261 + 0.3e1 * t91 * t262 * t272 + t91 * t100 * (t295 * t152 * t159 + t118 * t349 * t159 - t352 * t355 * (t126 * t135 * t349 - t309 * t357 * t326 + t305 * t155)) * t367
  vrho_0_ = t7 * t370 + t164 - t31 + t84 + t86
  t372 = -t39 - t205
  t375 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t372)
  t376 = -t372
  t379 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t376)
  t381 = (t375 + t379) * t57
  t383 = t38 * t381 * t82
  t385 = 0.58482236226346462072622386637590534819724553404281e0 * t381 * t80
  t388 = f.my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t263 * t372)
  t391 = f.my_piecewise3(t49, 0, 0.2e1 / 0.3e1 * t267 * t376)
  t393 = t388 / 0.2e1 + t391 / 0.2e1
  t401 = -t282 - 0.16666666666666666666666666666666666666666666666667e-2 * t284 * t110 * t114 * t393 - t294
  t408 = t401 * t125
  t419 = (-(t170 + t194 - t198 - t203 + t383 + t249 + t385 - t256 - t261) * t125 * t130 + 0.3e1 * t128 * t321 * t393) * t132
  t428 = -t300 - t284 * t110 * t5 * t393 / 0.48e2 + t408 * t137 * t149 / 0.3072e4 - t314 * t316 * t317 * t419 / 0.3072e4 - t337 - t340 * t344 * t317 * t393 / 0.768e3
  t443 = t170 + t194 - t198 - t203 + t383 + t249 + t385 - t256 - t261 + 0.3e1 * t91 * t262 * t393 + t91 * t100 * (t401 * t152 * t159 + t118 * t428 * t159 - t352 * t355 * (t126 * t135 * t428 - t309 * t357 * t419 + t408 * t155)) * t367
  vrho_1_ = t7 * t443 + t164 - t31 + t84 + t86
  t446 = t7 * t88 * t90
  t447 = t104 * t54
  t449 = t447 * t120 * t109
  t452 = t449 * t114 * t152 * t159
  t456 = t447 * t106 * t110 * t5
  t467 = 0.1e1 / t36 / t276 / t143 / t99 * t89 * jnp.pi * t113 * t125 * t338
  t471 = t126 * t135 * t102 * t149
  t473 = t456 / 0.96e2 + 0.65104166666666666666666666666666666666666666666667e-5 * t467 + t471 / 0.1536e4
  t478 = t449 * t114 * t125 * t155
  vsigma_0_ = t446 * t100 * (0.83333333333333333333333333333333333333333333333333e-3 * t452 + t118 * t473 * t159 - t352 * t355 * (0.83333333333333333333333333333333333333333333333333e-3 * t478 + t126 * t135 * t473)) * t367
  t492 = t456 / 0.48e2 + 0.13020833333333333333333333333333333333333333333333e-4 * t467 + t471 / 0.768e3
  vsigma_1_ = t446 * t100 * (0.16666666666666666666666666666666666666666666666667e-2 * t452 + t118 * t492 * t159 - t352 * t355 * (0.16666666666666666666666666666666666666666666666667e-2 * t478 + t126 * t135 * t492)) * t367
  vsigma_2_ = vsigma_0_
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  params_BB = 1

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  pbeloc_b0 = 0.0375

  pbeloc_a = 0.08

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  BB = params_BB

  mbeta = lambda rs, t: pbeloc_b0 + pbeloc_a * t ** 2 * (1 - jnp.exp(-rs ** 2))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  f1 = lambda rs, z, t: t ** 2 + BB * A(rs, z, t) * t ** 4

  f2 = lambda rs, z, t: mbeta(rs, t) * f1(rs, z, t) / (mgamma * (1 + A(rs, z, t) * f1(rs, z, t)))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  functional_body = lambda rs, z, xt, xs0, xs1: f_pbe(rs, z, xt, xs0, xs1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t10 = t4 * t6 / t7
  t12 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t24 = t20 * t5 / t21
  t26 = 0.23615562999000000000000000000000000000000000000000e0 * t13 + 0.55770497660000000000000000000000000000000000000000e-1 * t10 + 0.12733196185000000000000000000000000000000000000000e-1 * t16 + 0.76629248290000000000000000000000000000000000000000e-2 * t24
  t28 = 0.1e1 + 0.1e1 / t26
  t29 = jnp.log(t28)
  t30 = t12 * t29
  t31 = 0.1e1 <= f.p.zeta_threshold
  t32 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t34 = f.my_piecewise3(t31, t32 * f.p.zeta_threshold, 1)
  t37 = 2 ** (0.1e1 / 0.3e1)
  t41 = (0.2e1 * t34 - 0.2e1) / (0.2e1 * t37 - 0.2e1)
  t43 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t10
  t48 = 0.17489762330000000000000000000000000000000000000000e0 * t13 + 0.30591463695000000000000000000000000000000000000000e-1 * t10 + 0.37162156485000000000000000000000000000000000000000e-2 * t16 + 0.41939460495000000000000000000000000000000000000000e-2 * t24
  t50 = 0.1e1 + 0.1e1 / t48
  t51 = jnp.log(t50)
  t54 = 0.58482236226346462072622386637590534819724553404281e0 * t41 * t43 * t51
  t55 = jnp.log(0.2e1)
  t56 = 0.1e1 - t55
  t57 = jnp.pi ** 2
  t58 = 0.1e1 / t57
  t59 = t56 * t58
  t60 = t32 ** 2
  t61 = f.my_piecewise3(t31, t60, 1)
  t62 = t61 ** 2
  t63 = t62 * t61
  t64 = r0 ** 2
  t66 = 0.1e1 / t7 / t64
  t67 = s0 * t66
  t68 = 0.1e1 / t62
  t69 = t37 * t68
  t71 = 0.1e1 / t3
  t72 = t18 * t71
  t74 = jnp.exp(-t24 / 0.4e1)
  t75 = 0.1e1 - t74
  t76 = t5 * t75
  t77 = t72 * t76
  t80 = 0.375e-1 + 0.83333333333333333333333333333333333333333333333333e-3 * t67 * t69 * t77
  t82 = t68 * t18
  t84 = t82 * t71 * t5
  t87 = 0.1e1 / t56
  t88 = t80 * t87
  t91 = 0.1e1 / t63
  t94 = jnp.exp(-(-t30 + t54) * t87 * t57 * t91)
  t95 = t94 - 0.1e1
  t96 = 0.1e1 / t95
  t97 = t57 * t96
  t98 = s0 ** 2
  t99 = t97 * t98
  t100 = t88 * t99
  t101 = t64 ** 2
  t103 = 0.1e1 / t21 / t101
  t104 = t37 ** 2
  t106 = t62 ** 2
  t107 = 0.1e1 / t106
  t109 = 0.1e1 / t19
  t111 = t1 * t109 * t6
  t112 = t103 * t104 * t107 * t111
  t115 = t67 * t37 * t84 / 0.96e2 + t100 * t112 / 0.3072e4
  t116 = t80 * t115
  t118 = t97 * t115
  t120 = t88 * t118 + 0.1e1
  t122 = t87 * t57 / t120
  t124 = t116 * t122 + 0.1e1
  t125 = jnp.log(t124)
  t129 = 0.1e1 / t7 / r0
  t130 = t6 * t129
  t133 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t130 * t29
  t134 = t26 ** 2
  t139 = t3 * t6
  t140 = t139 * t129
  t141 = 0.1e1 / t13 * t1 * t140
  t143 = t4 * t130
  t145 = t10 ** 0.5e0
  t147 = t145 * t1 * t140
  t152 = t20 * t5 / t21 / r0
  t157 = t12 / t134 * (-0.39359271665000000000000000000000000000000000000000e-1 * t141 - 0.18590165886666666666666666666666666666666666666667e-1 * t143 - 0.63665980925000000000000000000000000000000000000000e-2 * t147 - 0.51086165526666666666666666666666666666666666666667e-2 * t152) / t28
  t162 = 0.18311447306006545054854346104378990962041954983034e-3 * t41 * t1 * t139 * t129 * t51
  t164 = t48 ** 2
  t175 = 0.58482236226346462072622386637590534819724553404281e0 * t41 * t43 / t164 * (-0.29149603883333333333333333333333333333333333333333e-1 * t141 - 0.10197154565000000000000000000000000000000000000000e-1 * t143 - 0.18581078242500000000000000000000000000000000000000e-2 * t147 - 0.27959640330000000000000000000000000000000000000000e-2 * t152) / t50
  t176 = t64 * r0
  t179 = s0 / t7 / t176
  t190 = -0.19444444444444444444444444444444444444444444444444e-2 * t179 * t69 * t77 - 0.41666666666666666666666666666666666666666666666666e-3 * s0 / t101 * t69 * t4 * t6 * t74
  t196 = t190 * t87
  t200 = t56 ** 2
  t202 = t80 / t200
  t203 = t57 ** 2
  t205 = t95 ** 2
  t206 = 0.1e1 / t205
  t215 = t133 + t157 - t162 - t175
  t229 = -0.7e1 / 0.288e3 * t179 * t37 * t84 + t196 * t99 * t112 / 0.3072e4 + t202 * t203 * t206 * t98 * t103 * t104 / t106 / t63 * t1 * t109 * t6 * t215 * t94 / 0.3072e4 - 0.7e1 / 0.4608e4 * t100 / t21 / t101 / r0 * t104 * t107 * t111
  t232 = t116 * t87
  t233 = t120 ** 2
  t235 = t57 / t233
  t250 = 0.1e1 / t124
  vrho_0_ = -t30 + t54 + t59 * t63 * t125 + r0 * (t133 + t157 - t162 - t175 + t59 * t63 * (t190 * t115 * t122 + t80 * t229 * t122 - t232 * t235 * (t202 * t203 * t206 * t115 * t215 * t91 * t94 + t88 * t97 * t229 + t196 * t118)) * t250)
  t257 = t66 * t37
  t259 = t257 * t82 * t71
  t284 = t257 * t68 * t72 * t5 / 0.96e2 + 0.65104166666666666666666666666666666666666666666667e-5 / t101 / t176 / t106 / t62 * t57 * jnp.pi * t75 * t87 * t96 * t98 + t88 * t97 * s0 * t112 / 0.1536e4
  vsigma_0_ = r0 * t56 * t58 * t63 * (0.83333333333333333333333333333333333333333333333333e-3 * t259 * t76 * t115 * t122 + t80 * t284 * t122 - t232 * t235 * (0.83333333333333333333333333333333333333333333333333e-3 * t259 * t76 * t87 * t118 + t88 * t97 * t284)) * t250
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t7 / r0
  t10 = t6 * t9
  t13 = t4 * t6 / t7
  t14 = jnp.sqrt(t13)
  t17 = t13 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t7 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.37978500000000000000000000000000000000000000000000e1 * t14 + 0.89690000000000000000000000000000000000000000000000e0 * t13 + 0.20477500000000000000000000000000000000000000000000e0 * t17 + 0.12323500000000000000000000000000000000000000000000e0 * t25
  t30 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t27
  t31 = jnp.log(t30)
  t33 = t4 * t10 * t31
  t36 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t13
  t37 = t27 ** 2
  t38 = 0.1e1 / t37
  t39 = t36 * t38
  t41 = 0.1e1 / t14 * t1
  t42 = t3 * t6
  t43 = t42 * t9
  t44 = t41 * t43
  t46 = t4 * t10
  t48 = t13 ** 0.5e0
  t49 = t48 * t1
  t50 = t49 * t43
  t55 = t21 * t5 / t22 / r0
  t57 = -0.63297500000000000000000000000000000000000000000000e0 * t44 - 0.29896666666666666666666666666666666666666666666667e0 * t46 - 0.10238750000000000000000000000000000000000000000000e0 * t50 - 0.82156666666666666666666666666666666666666666666667e-1 * t55
  t58 = 0.1e1 / t30
  t59 = t57 * t58
  t60 = t39 * t59
  t62 = 0.1e1 <= f.p.zeta_threshold
  t63 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t65 = f.my_piecewise3(t62, t63 * f.p.zeta_threshold, 1)
  t68 = 2 ** (0.1e1 / 0.3e1)
  t72 = (0.2e1 * t65 - 0.2e1) / (0.2e1 * t68 - 0.2e1)
  t73 = t72 * t1
  t78 = 0.51785000000000000000000000000000000000000000000000e1 * t14 + 0.90577500000000000000000000000000000000000000000000e0 * t13 + 0.11003250000000000000000000000000000000000000000000e0 * t17 + 0.12417750000000000000000000000000000000000000000000e0 * t25
  t81 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t78
  t82 = jnp.log(t81)
  t85 = t73 * t42 * t9 * t82
  t88 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t13
  t89 = t72 * t88
  t90 = t78 ** 2
  t91 = 0.1e1 / t90
  t96 = -0.86308333333333333333333333333333333333333333333334e0 * t44 - 0.30192500000000000000000000000000000000000000000000e0 * t46 - 0.55016250000000000000000000000000000000000000000000e-1 * t50 - 0.82785000000000000000000000000000000000000000000000e-1 * t55
  t98 = 0.1e1 / t81
  t99 = t91 * t96 * t98
  t100 = t89 * t99
  t102 = jnp.log(0.2e1)
  t103 = 0.1e1 - t102
  t104 = jnp.pi ** 2
  t105 = 0.1e1 / t104
  t106 = t103 * t105
  t107 = t63 ** 2
  t108 = f.my_piecewise3(t62, t107, 1)
  t109 = t108 ** 2
  t110 = t109 * t108
  t111 = r0 ** 2
  t112 = t111 * r0
  t114 = 0.1e1 / t7 / t112
  t115 = s0 * t114
  t116 = 0.1e1 / t109
  t117 = t68 * t116
  t119 = 0.1e1 / t3
  t120 = t19 * t119
  t122 = jnp.exp(-t25 / 0.4e1)
  t123 = 0.1e1 - t122
  t124 = t5 * t123
  t125 = t120 * t124
  t128 = t111 ** 2
  t129 = 0.1e1 / t128
  t132 = t6 * t122
  t133 = t4 * t132
  t136 = -0.19444444444444444444444444444444444444444444444444e-2 * t115 * t117 * t125 - 0.41666666666666666666666666666666666666666666666666e-3 * s0 * t129 * t117 * t133
  t138 = 0.1e1 / t7 / t111
  t139 = s0 * t138
  t141 = t116 * t19
  t143 = t141 * t119 * t5
  t149 = 0.375e-1 + 0.83333333333333333333333333333333333333333333333332e-3 * t139 * t117 * t125
  t150 = 0.1e1 / t103
  t151 = t149 * t150
  t159 = 0.1e1 / t110
  t162 = jnp.exp(-(-0.621814e-1 * t36 * t31 + 0.19751673498613801407483339618206552048944131217655e-1 * t72 * t88 * t82) * t150 * t104 * t159)
  t163 = t162 - 0.1e1
  t164 = 0.1e1 / t163
  t165 = t104 * t164
  t166 = s0 ** 2
  t167 = t165 * t166
  t168 = t151 * t167
  t170 = 0.1e1 / t22 / t128
  t171 = t68 ** 2
  t173 = t109 ** 2
  t174 = 0.1e1 / t173
  t176 = 0.1e1 / t20
  t178 = t1 * t176 * t6
  t179 = t170 * t171 * t174 * t178
  t182 = t139 * t68 * t143 / 0.96e2 + t168 * t179 / 0.3072e4
  t183 = t136 * t182
  t185 = t165 * t182
  t187 = t151 * t185 + 0.1e1
  t189 = t150 * t104 / t187
  t194 = t136 * t150
  t195 = t194 * t167
  t198 = t103 ** 2
  t199 = 0.1e1 / t198
  t200 = t149 * t199
  t201 = t104 ** 2
  t202 = t200 * t201
  t203 = t163 ** 2
  t204 = 0.1e1 / t203
  t205 = t204 * t166
  t206 = t205 * t170
  t207 = t202 * t206
  t211 = t171 / t173 / t110 * t1
  t212 = t176 * t6
  t217 = 0.11073470983333333333333333333333333333333333333333e-2 * t33 + 0.10000000000000000000000000000000000000000000000000e1 * t60 - 0.18311447306006545054854346104378990962041954983034e-3 * t85 - 0.58482236226346462072622386637590534819724553404280e0 * t100
  t218 = t217 * t162
  t220 = t211 * t212 * t218
  t223 = t128 * r0
  t225 = 0.1e1 / t22 / t223
  t228 = t225 * t171 * t174 * t178
  t231 = -0.7e1 / 0.288e3 * t115 * t68 * t143 + t195 * t179 / 0.3072e4 + t207 * t220 / 0.3072e4 - 0.7e1 / 0.4608e4 * t168 * t228
  t232 = t149 * t231
  t234 = t149 * t182
  t235 = t234 * t150
  t236 = t187 ** 2
  t238 = t104 / t236
  t240 = t201 * t204
  t241 = t200 * t240
  t243 = t159 * t162
  t244 = t182 * t217 * t243
  t246 = t165 * t231
  t248 = t151 * t246 + t194 * t185 + t241 * t244
  t249 = t238 * t248
  t251 = t183 * t189 + t232 * t189 - t235 * t249
  t254 = t234 * t189 + 0.1e1
  t255 = 0.1e1 / t254
  t259 = t6 * t138
  t262 = 0.14764627977777777777777777777777777777777777777777e-2 * t4 * t259 * t31
  t267 = 0.35616666666666666666666666666666666666666666666666e-1 * t4 * t6 * t9 * t38 * t59
  t271 = t57 ** 2
  t274 = 0.20000000000000000000000000000000000000000000000000e1 * t36 / t37 / t27 * t271 * t58
  t280 = 0.1e1 / t22 / t111
  t281 = t20 * t5 * t280
  t282 = 0.1e1 / t14 / t13 * t19 * t281
  t284 = t42 * t138
  t285 = t41 * t284
  t287 = t4 * t259
  t289 = t13 ** (-0.5e0)
  t291 = t289 * t19 * t281
  t293 = t49 * t284
  t296 = t21 * t5 * t280
  t301 = 0.10000000000000000000000000000000000000000000000000e1 * t39 * (-0.42198333333333333333333333333333333333333333333333e0 * t282 + 0.84396666666666666666666666666666666666666666666666e0 * t285 + 0.39862222222222222222222222222222222222222222222223e0 * t287 + 0.68258333333333333333333333333333333333333333333333e-1 * t291 + 0.13651666666666666666666666666666666666666666666667e0 * t293 + 0.13692777777777777777777777777777777777777777777778e0 * t296) * t58
  t302 = t37 ** 2
  t305 = t30 ** 2
  t309 = 0.16081979498692535066756296899072713062105388428051e2 * t36 / t302 * t271 / t305
  t313 = 0.24415263074675393406472461472505321282722606644045e-3 * t73 * t42 * t138 * t82
  t317 = 0.10843581300301739842632067522386578331157260943710e-1 * t72 * t4 * t10 * t99
  t320 = t96 ** 2
  t324 = 0.11696447245269292414524477327518106963944910680856e1 * t89 / t90 / t78 * t320 * t98
  t335 = 0.58482236226346462072622386637590534819724553404280e0 * t89 * t91 * (-0.57538888888888888888888888888888888888888888888889e0 * t282 + 0.11507777777777777777777777777777777777777777777778e1 * t285 + 0.40256666666666666666666666666666666666666666666667e0 * t287 + 0.36677500000000000000000000000000000000000000000000e-1 * t291 + 0.73355000000000000000000000000000000000000000000000e-1 * t293 + 0.13797500000000000000000000000000000000000000000000e0 * t296) * t98
  t336 = t90 ** 2
  t339 = t81 ** 2
  t343 = 0.17315859105681463759666483083807725165579399831905e2 * t89 / t336 * t320 / t339
  t346 = s0 / t7 / t128
  t361 = 0.64814814814814814814814814814814814814814814814813e-2 * t346 * t117 * t125 + 0.26388888888888888888888888888888888888888888888888e-2 * s0 / t223 * t117 * t133 - 0.83333333333333333333333333333333333333333333333332e-3 * s0 * t225 * t68 * t116 * t2 * t122
  t367 = t183 * t150
  t373 = t361 * t150
  t377 = t136 * t199
  t386 = t149 / t198 / t103
  t387 = t201 * t104
  t388 = t386 * t387
  t390 = 0.1e1 / t203 / t163
  t394 = t173 ** 2
  t398 = t171 / t394 / t109 * t1
  t399 = t217 ** 2
  t400 = t162 ** 2
  t410 = -t262 - t267 - t274 + t301 + t309 + t313 + t317 + t324 - t335 - t343
  t430 = 0.35e2 / 0.432e3 * t346 * t68 * t143 + t373 * t167 * t179 / 0.3072e4 + t377 * t201 * t206 * t220 / 0.1536e4 - 0.7e1 / 0.2304e4 * t195 * t228 + t388 * t390 * t166 * t170 * t398 * t212 * t399 * t400 / 0.1536e4 - 0.7e1 / 0.2304e4 * t202 * t205 * t225 * t220 + t207 * t211 * t212 * t410 * t162 / 0.3072e4 - t388 * t206 * t398 * t212 * t399 * t162 / 0.3072e4 + 0.119e3 / 0.13824e5 * t168 / t22 / t128 / t111 * t171 * t174 * t178
  t433 = t232 * t150
  t438 = t104 / t236 / t187
  t439 = t248 ** 2
  t451 = t182 * t399
  t453 = 0.1e1 / t173 / t109
  t479 = t251 ** 2
  t481 = t254 ** 2
  t482 = 0.1e1 / t481
  t485 = -t262 - t267 - t274 + t301 + t309 + t313 + t317 + t324 - t335 - t343 + t106 * t110 * (t361 * t182 * t189 + 0.2e1 * t136 * t231 * t189 - 0.2e1 * t367 * t249 + t149 * t430 * t189 - 0.2e1 * t433 * t249 + 0.2e1 * t235 * t438 * t439 - t235 * t238 * (-t386 * t387 * t204 * t451 * t453 * t162 + 0.2e1 * t386 * t387 * t390 * t451 * t453 * t400 + t241 * t182 * t410 * t243 + 0.2e1 * t241 * t231 * t217 * t243 + t151 * t165 * t430 + 0.2e1 * t377 * t240 * t244 + t373 * t185 + 0.2e1 * t194 * t246)) * t255 - t106 * t110 * t479 * t482
  v2rho2_0_ = 0.22146941966666666666666666666666666666666666666666e-2 * t33 + 0.20000000000000000000000000000000000000000000000000e1 * t60 - 0.36622894612013090109708692208757981924083909966068e-3 * t85 - 0.11696447245269292414524477327518106963944910680856e1 * t100 + 0.2e1 * t106 * t110 * t251 * t255 + r0 * t485
  t487 = t138 * t68
  t488 = t141 * t119
  t489 = t487 * t488
  t491 = t124 * t182 * t189
  t495 = t120 * t5
  t496 = t487 * t116 * t495
  t499 = 0.1e1 / t128 / t112
  t501 = t104 * jnp.pi
  t502 = t499 * t453 * t501
  t503 = t123 * t150
  t505 = t503 * t164 * t166
  t508 = t165 * s0
  t509 = t151 * t508
  t512 = t496 / 0.96e2 + 0.65104166666666666666666666666666666666666666666663e-5 * t502 * t505 + t509 * t179 / 0.1536e4
  t513 = t149 * t512
  t515 = t124 * t150
  t516 = t515 * t185
  t519 = t165 * t512
  t521 = 0.83333333333333333333333333333333333333333333333332e-3 * t489 * t516 + t151 * t519
  t522 = t238 * t521
  t524 = 0.83333333333333333333333333333333333333333333333332e-3 * t489 * t491 + t513 * t189 - t235 * t522
  t525 = t110 * t524
  t529 = r0 * t103 * t105
  t530 = t114 * t68
  t531 = t530 * t488
  t537 = t129 * t68 * t116 * t1 * t3
  t547 = t123 * t182 * t150
  t556 = t128 ** 2
  t596 = -0.7e1 / 0.288e3 * t530 * t116 * t495 - 0.45572916666666666666666666666666666666666666666664e-4 / t556 * t453 * t501 * t505 - 0.10850694444444444444444444444444444444444444444444e-5 / t22 / t556 * t453 * t501 * t19 * t20 * t5 * t122 * t150 * t164 * t166 + 0.65104166666666666666666666666666666666666666666663e-5 * t499 / t394 / t108 * t201 * jnp.pi * t123 * t199 * t204 * t166 * t217 * t162 + t194 * t508 * t179 / 0.1536e4 + t202 * t204 * s0 * t170 * t220 / 0.1536e4 - 0.7e1 / 0.2304e4 * t509 * t228
  t599 = t513 * t150
  t636 = -0.19444444444444444444444444444444444444444444444444e-2 * t531 * t491 - 0.41666666666666666666666666666666666666666666666666e-3 * t537 * t132 * t182 * t189 + 0.83333333333333333333333333333333333333333333333332e-3 * t489 * t124 * t231 * t189 - 0.83333333333333333333333333333333333333333333333332e-3 * t496 * t547 * t249 + t136 * t512 * t189 + t149 * t596 * t189 - t599 * t249 - t367 * t522 - t433 * t522 + 0.2e1 * t235 * t438 * t521 * t248 - t235 * t238 * (-0.19444444444444444444444444444444444444444444444444e-2 * t531 * t516 - 0.41666666666666666666666666666666666666666666666666e-3 * t537 * t132 * t150 * t185 + 0.83333333333333333333333333333333333333333333333332e-3 * t487 / t173 / t108 * t495 * t123 * t199 * t201 * t204 * t182 * t218 + 0.83333333333333333333333333333333333333333333333332e-3 * t489 * t515 * t246 + t194 * t519 + t241 * t512 * t217 * t243 + t151 * t165 * t596)
  v2rhosigma_0_ = t529 * t110 * t636 * t255 - t529 * t525 * t482 * t251 + t106 * t525 * t255
  t660 = 0.26041666666666666666666666666666666666666666666666e-4 * t502 * t503 * t164 * s0 + t151 * t165 * t170 * t171 * t174 * t178 / 0.1536e4
  t665 = t521 ** 2
  t681 = t524 ** 2
  v2sigma2_0_ = t529 * t110 * (0.16666666666666666666666666666666666666666666666666e-2 * t489 * t124 * t512 * t189 - 0.16666666666666666666666666666666666666666666666666e-2 * t496 * t547 * t522 + t149 * t660 * t189 - 0.2e1 * t599 * t522 + 0.2e1 * t235 * t438 * t665 - t235 * t238 * (0.16666666666666666666666666666666666666666666666666e-2 * t489 * t515 * t519 + t151 * t165 * t660)) * t255 - t529 * t110 * t681 * t482
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t10 = t4 * t6 / t7
  t12 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t24 = t20 * t5 / t21
  t26 = 0.37978500000000000000000000000000000000000000000000e1 * t13 + 0.89690000000000000000000000000000000000000000000000e0 * t10 + 0.20477500000000000000000000000000000000000000000000e0 * t16 + 0.12323500000000000000000000000000000000000000000000e0 * t24
  t27 = t26 ** 2
  t28 = t27 ** 2
  t29 = 0.1e1 / t28
  t30 = t12 * t29
  t32 = 0.1e1 / t13 * t1
  t33 = t3 * t6
  t35 = 0.1e1 / t7 / r0
  t36 = t33 * t35
  t37 = t32 * t36
  t39 = t6 * t35
  t40 = t4 * t39
  t42 = t10 ** 0.5e0
  t43 = t42 * t1
  t44 = t43 * t36
  t49 = t20 * t5 / t21 / r0
  t51 = -0.63297500000000000000000000000000000000000000000000e0 * t37 - 0.29896666666666666666666666666666666666666666666667e0 * t40 - 0.10238750000000000000000000000000000000000000000000e0 * t44 - 0.82156666666666666666666666666666666666666666666667e-1 * t49
  t52 = t51 ** 2
  t55 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t26
  t56 = t55 ** 2
  t57 = 0.1e1 / t56
  t58 = t52 * t57
  t59 = t30 * t58
  t61 = r0 ** 2
  t63 = 0.1e1 / t7 / t61
  t64 = t6 * t63
  t65 = jnp.log(t55)
  t67 = t4 * t64 * t65
  t69 = 0.1e1 <= f.p.zeta_threshold
  t70 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t72 = f.my_piecewise3(t69, t70 * f.p.zeta_threshold, 1)
  t75 = 2 ** (0.1e1 / 0.3e1)
  t79 = (0.2e1 * t72 - 0.2e1) / (0.2e1 * t75 - 0.2e1)
  t80 = t79 * t4
  t85 = 0.51785000000000000000000000000000000000000000000000e1 * t13 + 0.90577500000000000000000000000000000000000000000000e0 * t10 + 0.11003250000000000000000000000000000000000000000000e0 * t16 + 0.12417750000000000000000000000000000000000000000000e0 * t24
  t86 = t85 ** 2
  t87 = t86 ** 2
  t88 = 0.1e1 / t87
  t93 = -0.86308333333333333333333333333333333333333333333334e0 * t37 - 0.30192500000000000000000000000000000000000000000000e0 * t40 - 0.55016250000000000000000000000000000000000000000000e-1 * t44 - 0.82785000000000000000000000000000000000000000000000e-1 * t49
  t94 = t93 ** 2
  t98 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t85
  t99 = t98 ** 2
  t100 = 0.1e1 / t99
  t101 = t88 * t94 * t100
  t104 = 0.48159733137676571081572406076840235616767705782485e0 * t80 * t39 * t101
  t106 = 0.1e1 / t86 / t85
  t108 = 0.1e1 / t98
  t109 = t106 * t94 * t108
  t112 = 0.32530743900905219527896202567159734993471782831130e-1 * t80 * t39 * t109
  t113 = 0.1e1 / t86
  t115 = t113 * t93 * t108
  t118 = 0.21687162600603479685264135044773156662314521887420e-1 * t80 * t64 * t115
  t121 = 0.1e1 / t13 / t10 * t18
  t122 = t19 * t5
  t124 = 0.1e1 / t21 / t61
  t125 = t122 * t124
  t126 = t121 * t125
  t128 = t33 * t63
  t129 = t32 * t128
  t131 = t4 * t64
  t133 = t10 ** (-0.5e0)
  t134 = t133 * t18
  t135 = t134 * t125
  t137 = t43 * t128
  t140 = t20 * t5 * t124
  t142 = -0.57538888888888888888888888888888888888888888888889e0 * t126 + 0.11507777777777777777777777777777777777777777777778e1 * t129 + 0.40256666666666666666666666666666666666666666666667e0 * t131 + 0.36677500000000000000000000000000000000000000000000e-1 * t135 + 0.73355000000000000000000000000000000000000000000000e-1 * t137 + 0.13797500000000000000000000000000000000000000000000e0 * t140
  t144 = t113 * t142 * t108
  t147 = 0.16265371950452609763948101283579867496735891415565e-1 * t80 * t39 * t144
  t149 = 0.1e1 / t27 / t26
  t150 = t12 * t149
  t151 = 0.1e1 / t55
  t152 = t51 * t151
  t159 = -0.42198333333333333333333333333333333333333333333333e0 * t126 + 0.84396666666666666666666666666666666666666666666666e0 * t129 + 0.39862222222222222222222222222222222222222222222223e0 * t131 + 0.68258333333333333333333333333333333333333333333333e-1 * t135 + 0.13651666666666666666666666666666666666666666666667e0 * t137 + 0.13692777777777777777777777777777777777777777777778e0 * t140
  t162 = 0.60000000000000000000000000000000000000000000000000e1 * t150 * t152 * t159
  t163 = t61 * r0
  t165 = 0.1e1 / t7 / t163
  t166 = t6 * t165
  t169 = 0.34450798614814814814814814814814814814814814814813e-2 * t4 * t166 * t65
  t173 = 0.48245938496077605200268890697218139186316165284153e2 * t30 * t159 * t57 * t51
  t174 = t52 * t51
  t177 = 0.60000000000000000000000000000000000000000000000000e1 * t30 * t174 * t151
  t178 = jnp.log(0.2e1)
  t179 = 0.1e1 - t178
  t180 = jnp.pi ** 2
  t182 = t179 / t180
  t183 = t70 ** 2
  t184 = f.my_piecewise3(t69, t183, 1)
  t185 = t184 ** 2
  t186 = t185 * t184
  t187 = s0 * t165
  t188 = 0.1e1 / t185
  t189 = t75 * t188
  t191 = 0.1e1 / t3
  t194 = jnp.exp(-t24 / 0.4e1)
  t197 = t18 * t191 * t5 * (0.1e1 - t194)
  t200 = t61 ** 2
  t201 = 0.1e1 / t200
  t205 = t4 * t6 * t194
  t208 = -0.19444444444444444444444444444444444444444444444444e-2 * t187 * t189 * t197 - 0.41666666666666666666666666666666666666666666666666e-3 * s0 * t201 * t189 * t205
  t209 = s0 * t63
  t213 = t188 * t18 * t191 * t5
  t219 = 0.375e-1 + 0.83333333333333333333333333333333333333333333333332e-3 * t209 * t189 * t197
  t220 = 0.1e1 / t179
  t221 = t219 * t220
  t225 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t10
  t226 = jnp.log(t98)
  t232 = 0.1e1 / t186
  t235 = jnp.exp(-(-0.621814e-1 * t12 * t65 + 0.19751673498613801407483339618206552048944131217655e-1 * t79 * t225 * t226) * t220 * t180 * t232)
  t236 = t235 - 0.1e1
  t238 = t180 / t236
  t239 = s0 ** 2
  t240 = t238 * t239
  t241 = t221 * t240
  t243 = 0.1e1 / t21 / t200
  t244 = t75 ** 2
  t245 = t243 * t244
  t246 = t185 ** 2
  t247 = 0.1e1 / t246
  t249 = 0.1e1 / t19
  t251 = t1 * t249 * t6
  t252 = t245 * t247 * t251
  t255 = t209 * t75 * t213 / 0.96e2 + t241 * t252 / 0.3072e4
  t256 = t208 * t255
  t258 = t238 * t255
  t260 = t221 * t258 + 0.1e1
  t262 = t220 * t180 / t260
  t267 = t208 * t220
  t268 = t267 * t240
  t271 = t179 ** 2
  t272 = 0.1e1 / t271
  t273 = t219 * t272
  t274 = t180 ** 2
  t275 = t273 * t274
  t276 = t236 ** 2
  t277 = 0.1e1 / t276
  t278 = t277 * t239
  t279 = t278 * t243
  t280 = t275 * t279
  t284 = t244 / t246 / t186 * t1
  t285 = t249 * t6
  t289 = 0.1e1 / t27
  t290 = t12 * t289
  t293 = t79 * t1
  t298 = t79 * t225
  t301 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t39 * t65 + 0.10000000000000000000000000000000000000000000000000e1 * t290 * t152 - 0.18311447306006545054854346104378990962041954983034e-3 * t293 * t33 * t35 * t226 - 0.58482236226346462072622386637590534819724553404280e0 * t298 * t115
  t302 = t301 * t235
  t304 = t284 * t285 * t302
  t307 = t200 * r0
  t309 = 0.1e1 / t21 / t307
  t312 = t309 * t244 * t247 * t251
  t315 = -0.7e1 / 0.288e3 * t187 * t75 * t213 + t268 * t252 / 0.3072e4 + t280 * t304 / 0.3072e4 - 0.7e1 / 0.4608e4 * t241 * t312
  t316 = t219 * t315
  t318 = t219 * t255
  t319 = t318 * t220
  t320 = t260 ** 2
  t322 = t180 / t320
  t324 = t274 * t277
  t325 = t273 * t324
  t326 = t255 * t301
  t327 = t232 * t235
  t328 = t326 * t327
  t330 = t238 * t315
  t332 = t221 * t330 + t267 * t258 + t325 * t328
  t333 = t322 * t332
  t335 = t256 * t262 + t316 * t262 - t319 * t333
  t336 = t335 ** 2
  t340 = t318 * t262 + 0.1e1
  t341 = t340 ** 2
  t347 = t256 * t220
  t350 = s0 / t7 / t200
  t362 = t188 * t2 * t194
  t365 = 0.64814814814814814814814814814814814814814814814813e-2 * t350 * t189 * t197 + 0.26388888888888888888888888888888888888888888888888e-2 * s0 / t307 * t189 * t205 - 0.83333333333333333333333333333333333333333333333332e-3 * s0 * t309 * t75 * t362
  t366 = t365 * t220
  t368 = t208 * t272
  t369 = t368 * t324
  t375 = 0.1e1 / t271 / t179
  t376 = t219 * t375
  t377 = t274 * t180
  t379 = 0.1e1 / t276 / t236
  t380 = t377 * t379
  t381 = t376 * t380
  t382 = t301 ** 2
  t383 = t255 * t382
  t385 = 0.1e1 / t246 / t185
  t386 = t235 ** 2
  t387 = t385 * t386
  t388 = t383 * t387
  t392 = t315 * t301 * t327
  t396 = t4 * t6
  t397 = t35 * t289
  t399 = t396 * t397 * t152
  t401 = t52 * t151
  t402 = t150 * t401
  t404 = t159 * t151
  t405 = t290 * t404
  t410 = t293 * t33 * t63 * t226
  t413 = t80 * t39 * t115
  t415 = t298 * t109
  t417 = t298 * t144
  t419 = t298 * t101
  t421 = -0.14764627977777777777777777777777777777777777777777e-2 * t67 - 0.35616666666666666666666666666666666666666666666666e-1 * t399 - 0.20000000000000000000000000000000000000000000000000e1 * t402 + 0.10000000000000000000000000000000000000000000000000e1 * t405 + 0.16081979498692535066756296899072713062105388428051e2 * t59 + 0.24415263074675393406472461472505321282722606644045e-3 * t410 + 0.10843581300301739842632067522386578331157260943710e-1 * t413 + 0.11696447245269292414524477327518106963944910680856e1 * t415 - 0.58482236226346462072622386637590534819724553404280e0 * t417 - 0.17315859105681463759666483083807725165579399831905e2 * t419
  t422 = t255 * t421
  t423 = t422 * t327
  t425 = t377 * t277
  t426 = t376 * t425
  t427 = t385 * t235
  t428 = t383 * t427
  t433 = t366 * t240
  t436 = t368 * t274
  t437 = t436 * t279
  t442 = t376 * t377
  t443 = t379 * t239
  t444 = t443 * t243
  t446 = t246 ** 2
  t448 = 0.1e1 / t446 / t185
  t450 = t244 * t448 * t1
  t453 = t450 * t285 * t382 * t386
  t456 = t278 * t309
  t457 = t275 * t456
  t462 = t284 * t285 * t421 * t235
  t468 = t450 * t285 * t382 * t235
  t471 = t200 * t61
  t473 = 0.1e1 / t21 / t471
  t476 = t473 * t244 * t247 * t251
  t479 = 0.35e2 / 0.432e3 * t350 * t75 * t213 + t433 * t252 / 0.3072e4 + t437 * t304 / 0.1536e4 - 0.7e1 / 0.2304e4 * t268 * t312 + t442 * t444 * t453 / 0.1536e4 - 0.7e1 / 0.2304e4 * t457 * t304 + t280 * t462 / 0.3072e4 - t442 * t279 * t468 / 0.3072e4 + 0.119e3 / 0.13824e5 * t241 * t476
  t480 = t238 * t479
  t482 = t221 * t480 + t366 * t258 + 0.2e1 * t267 * t330 + 0.2e1 * t325 * t392 + t325 * t423 + 0.2e1 * t369 * t328 + 0.2e1 * t381 * t388 - t426 * t428
  t483 = t322 * t482
  t486 = t208 * t315
  t490 = t365 * t255
  t497 = t219 * t479
  t503 = s0 / t7 / t307
  t516 = t200 * t163
  t526 = -0.28086419753086419753086419753086419753086419753086e-1 * t503 * t189 * t197 - 0.16435185185185185185185185185185185185185185185185e-1 * s0 / t471 * t189 * t205 + 0.99999999999999999999999999999999999999999999999997e-2 * s0 * t473 * t75 * t362 - 0.13888888888888888888888888888888888888888888888889e-3 * s0 / t7 / t516 * t189 * t2 * t18 * t122 * t194
  t532 = t320 ** 2
  t535 = t332 ** 2
  t542 = t180 / t320 / t260
  t547 = t316 * t220
  t548 = t542 * t535
  t556 = t271 ** 2
  t558 = t219 / t556
  t559 = t274 ** 2
  t560 = t558 * t559
  t566 = t244 / t446 / t246 / t184 * t1
  t567 = t382 * t301
  t573 = t276 ** 2
  t574 = 0.1e1 / t573
  t578 = t386 * t235
  t597 = t94 * t93
  t603 = 0.10254018858216406658218194626490193680059335835414e4 * t298 / t87 / t86 * t597 / t99 / t98
  t609 = 0.10389515463408878255799889850284635099347639899143e3 * t298 / t87 / t85 * t597 * t100
  t614 = 0.1e1 / t13 / t24 * t2 * t201 / 0.4e1
  t617 = 0.1e1 / t21 / t163
  t618 = t122 * t617
  t619 = t121 * t618
  t621 = t33 * t165
  t622 = t32 * t621
  t624 = t4 * t166
  t626 = t10 ** (-0.15e1)
  t628 = t626 * t2 * t201
  t630 = t134 * t618
  t632 = t43 * t621
  t635 = t20 * t5 * t617
  t641 = 0.58482236226346462072622386637590534819724553404280e0 * t298 * t113 * (-0.34523333333333333333333333333333333333333333333333e1 * t614 + 0.23015555555555555555555555555555555555555555555556e1 * t619 - 0.26851481481481481481481481481481481481481481481482e1 * t622 - 0.93932222222222222222222222222222222222222222222223e0 * t624 + 0.73355000000000000000000000000000000000000000000000e-1 * t628 - 0.14671000000000000000000000000000000000000000000000e0 * t630 - 0.17116166666666666666666666666666666666666666666667e0 * t632 - 0.36793333333333333333333333333333333333333333333333e0 * t635) * t108
  t642 = t173 + t177 - t162 - t118 + t147 + t104 + t169 - t603 + t609 - t641 - t112
  t647 = 0.51947577317044391278999449251423175496738199495715e2 * t298 * t88 * t142 * t100 * t93
  t651 = 0.35089341735807877243573431982554320891834732042568e1 * t298 * t88 * t597 * t108
  t656 = 0.35089341735807877243573431982554320891834732042568e1 * t298 * t106 * t93 * t108 * t142
  t664 = 0.51726012919273400298984252201052768390886626637712e3 * t12 / t28 / t27 * t174 / t56 / t55
  t670 = 0.96491876992155210400537781394436278372632330568306e2 * t12 / t28 / t26 * t174 * t57
  t682 = 0.10000000000000000000000000000000000000000000000000e1 * t290 * (-0.25319000000000000000000000000000000000000000000000e1 * t614 + 0.16879333333333333333333333333333333333333333333333e1 * t619 - 0.19692555555555555555555555555555555555555555555555e1 * t622 - 0.93011851851851851851851851851851851851851851851854e0 * t624 + 0.13651666666666666666666666666666666666666666666667e0 * t628 - 0.27303333333333333333333333333333333333333333333333e0 * t630 - 0.31853888888888888888888888888888888888888888888890e0 * t632 - 0.36514074074074074074074074074074074074074074074075e0 * t635) * t151
  t686 = 0.85917975471764868594145516183295969534298037676861e0 * t396 * t35 * t29 * t58
  t690 = 0.71233333333333333333333333333333333333333333333331e-1 * t396 * t63 * t289 * t152
  t693 = 0.53424999999999999999999999999999999999999999999999e-1 * t396 * t397 * t404
  t697 = 0.10685000000000000000000000000000000000000000000000e0 * t396 * t35 * t149 * t401
  t701 = 0.56968947174242584615102410102512416326352748836105e-3 * t293 * t33 * t165 * t226
  t702 = -t647 - t651 + t656 + t664 - t670 + t682 - t686 + t690 - t693 + t697 - t701
  t703 = t642 + t702
  t711 = t208 * t375
  t712 = t711 * t377
  t719 = t365 * t272
  t724 = t526 * t220
  t749 = t448 * t1 * t249
  t767 = -0.455e3 / 0.1296e4 * t503 * t75 * t213 + t560 * t279 * t566 * t285 * t567 * t235 / 0.3072e4 + t560 * t574 * t239 * t243 * t566 * t285 * t567 * t578 / 0.512e3 - t560 * t444 * t566 * t285 * t567 * t386 / 0.512e3 - 0.7e1 / 0.1536e4 * t457 * t462 + 0.7e1 / 0.1536e4 * t442 * t456 * t468 + t280 * t284 * t285 * t703 * t235 / 0.3072e4 + t437 * t462 / 0.1024e4 + t712 * t444 * t453 / 0.512e3 - t712 * t279 * t468 / 0.1024e4 + t719 * t274 * t279 * t304 / 0.1024e4 + t724 * t240 * t252 / 0.3072e4 - 0.7e1 / 0.1536e4 * t433 * t312 - 0.595e3 / 0.10368e5 * t241 / t21 / t516 * t244 * t247 * t251 + 0.119e3 / 0.4608e4 * t268 * t476 - 0.7e1 / 0.768e3 * t436 * t456 * t304 - 0.7e1 / 0.768e3 * t442 * t443 * t309 * t453 + t442 * t443 * t245 * t749 * t6 * t301 * t386 * t421 / 0.512e3 + 0.119e3 / 0.4608e4 * t275 * t278 * t473 * t304 - t442 * t278 * t245 * t749 * t6 * t421 * t302 / 0.1024e4
  t777 = t255 * t567
  t779 = 0.1e1 / t446 / t184
  t790 = t315 * t382
  t837 = t221 * t238 * t767 + t724 * t258 + 0.3e1 * t366 * t330 + t558 * t559 * t277 * t777 * t779 * t235 + t325 * t255 * t703 * t327 + 0.3e1 * t325 * t315 * t421 * t327 - 0.3e1 * t426 * t790 * t427 + 0.3e1 * t325 * t479 * t301 * t327 + 0.6e1 * t381 * t790 * t387 + 0.6e1 * t558 * t559 * t574 * t777 * t779 * t578 - 0.6e1 * t558 * t559 * t379 * t777 * t779 * t386 + 0.6e1 * t369 * t392 + 0.3e1 * t369 * t423 + 0.6e1 * t711 * t380 * t388 - 0.3e1 * t711 * t425 * t428 + 0.3e1 * t719 * t324 * t328 - 0.3e1 * t426 * t422 * t385 * t301 * t235 + 0.6e1 * t381 * t326 * t387 * t421 + 0.3e1 * t267 * t480
  t842 = -0.3e1 * t347 * t483 - 0.6e1 * t486 * t220 * t333 - 0.3e1 * t490 * t220 * t333 + 0.3e1 * t208 * t479 * t262 - 0.3e1 * t497 * t220 * t333 + t526 * t255 * t262 + 0.3e1 * t365 * t315 * t262 - 0.6e1 * t319 * t180 / t532 * t535 * t332 + 0.6e1 * t319 * t542 * t332 * t482 + 0.6e1 * t547 * t548 + 0.6e1 * t347 * t548 + t219 * t767 * t262 - t319 * t322 * t837 - 0.3e1 * t547 * t483
  t844 = 0.1e1 / t340
  t859 = 0.2e1 * t486 * t262 + t490 * t262 + t497 * t262 - t319 * t483 + 0.2e1 * t319 * t548 - 0.2e1 * t347 * t333 - 0.2e1 * t547 * t333
  t860 = 0.1e1 / t341
  t865 = t104 - t112 - t118 + t147 - t162 + t169 + t173 + t177 + 0.2e1 * t182 * t186 * t336 * t335 / t341 / t340 + t182 * t186 * t842 * t844 - 0.3e1 * t182 * t186 * t859 * t860 * t335 + t664
  t866 = -t670 + t682 - t647 + t656 - t686 + t690 - t693 + t697 - t701 - t603 + t609 - t641 - t651
  v3rho3_0_ = 0.48245938496077605200268890697218139186316165284153e2 * t59 - 0.44293883933333333333333333333333333333333333333332e-2 * t67 + r0 * (t865 + t866) - 0.60000000000000000000000000000000000000000000000000e1 * t402 + 0.30000000000000000000000000000000000000000000000000e1 * t405 + 0.3e1 * t182 * t186 * t859 * t844 - 0.17544670867903938621786715991277160445917366021284e1 * t417 - 0.51947577317044391278999449251423175496738199495715e2 * t419 + 0.35089341735807877243573431982554320891834732042568e1 * t415 - 0.10685000000000000000000000000000000000000000000000e0 * t399 + 0.73245789224026180219417384417515963848167819932136e-3 * t410 + 0.32530743900905219527896202567159734993471782831130e-1 * t413 - 0.3e1 * t182 * t186 * t336 * t860

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t10 = t4 * t6 / t7
  t12 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t24 = t20 * t5 / t21
  t26 = 0.37978500000000000000000000000000000000000000000000e1 * t13 + 0.89690000000000000000000000000000000000000000000000e0 * t10 + 0.20477500000000000000000000000000000000000000000000e0 * t16 + 0.12323500000000000000000000000000000000000000000000e0 * t24
  t27 = t26 ** 2
  t28 = t27 * t26
  t29 = 0.1e1 / t28
  t30 = t12 * t29
  t32 = 0.1e1 / t13 * t1
  t33 = t3 * t6
  t35 = 0.1e1 / t7 / r0
  t36 = t33 * t35
  t37 = t32 * t36
  t39 = t6 * t35
  t40 = t4 * t39
  t42 = t10 ** 0.5e0
  t43 = t42 * t1
  t44 = t43 * t36
  t49 = t20 * t5 / t21 / r0
  t51 = -0.63297500000000000000000000000000000000000000000000e0 * t37 - 0.29896666666666666666666666666666666666666666666667e0 * t40 - 0.10238750000000000000000000000000000000000000000000e0 * t44 - 0.82156666666666666666666666666666666666666666666667e-1 * t49
  t54 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t26
  t55 = 0.1e1 / t54
  t56 = t51 * t55
  t59 = 0.1e1 / t13 / t10 * t18
  t60 = t19 * t5
  t61 = r0 ** 2
  t63 = 0.1e1 / t21 / t61
  t64 = t60 * t63
  t65 = t59 * t64
  t68 = 0.1e1 / t7 / t61
  t69 = t33 * t68
  t70 = t32 * t69
  t72 = t6 * t68
  t73 = t4 * t72
  t75 = t10 ** (-0.5e0)
  t76 = t75 * t18
  t77 = t76 * t64
  t79 = t43 * t69
  t82 = t20 * t5 * t63
  t84 = -0.42198333333333333333333333333333333333333333333333e0 * t65 + 0.84396666666666666666666666666666666666666666666666e0 * t70 + 0.39862222222222222222222222222222222222222222222223e0 * t73 + 0.68258333333333333333333333333333333333333333333333e-1 * t77 + 0.13651666666666666666666666666666666666666666666667e0 * t79 + 0.13692777777777777777777777777777777777777777777778e0 * t82
  t86 = t30 * t56 * t84
  t88 = t61 * r0
  t90 = 0.1e1 / t7 / t88
  t91 = t6 * t90
  t92 = jnp.log(t54)
  t94 = t4 * t91 * t92
  t96 = t27 ** 2
  t97 = 0.1e1 / t96
  t98 = t12 * t97
  t99 = t54 ** 2
  t100 = 0.1e1 / t99
  t101 = t84 * t100
  t103 = t98 * t101 * t51
  t105 = jnp.log(0.2e1)
  t106 = 0.1e1 - t105
  t107 = jnp.pi ** 2
  t109 = t106 / t107
  t110 = 0.1e1 <= f.p.zeta_threshold
  t111 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t112 = t111 ** 2
  t113 = f.my_piecewise3(t110, t112, 1)
  t114 = t113 ** 2
  t115 = t114 * t113
  t116 = t109 * t115
  t117 = t61 ** 2
  t119 = 0.1e1 / t7 / t117
  t120 = s0 * t119
  t121 = 2 ** (0.1e1 / 0.3e1)
  t122 = 0.1e1 / t114
  t123 = t121 * t122
  t125 = 0.1e1 / t3
  t128 = jnp.exp(-t24 / 0.4e1)
  t131 = t18 * t125 * t5 * (0.1e1 - t128)
  t134 = t117 * r0
  t135 = 0.1e1 / t134
  t139 = t4 * t6 * t128
  t143 = 0.1e1 / t21 / t134
  t147 = t122 * t2 * t128
  t150 = 0.64814814814814814814814814814814814814814814814813e-2 * t120 * t123 * t131 + 0.26388888888888888888888888888888888888888888888888e-2 * s0 * t135 * t123 * t139 - 0.83333333333333333333333333333333333333333333333332e-3 * s0 * t143 * t121 * t147
  t151 = s0 * t68
  t155 = t122 * t18 * t125 * t5
  t161 = 0.375e-1 + 0.83333333333333333333333333333333333333333333333332e-3 * t151 * t123 * t131
  t162 = 0.1e1 / t106
  t163 = t161 * t162
  t167 = f.my_piecewise3(t110, t111 * f.p.zeta_threshold, 1)
  t173 = (0.2e1 * t167 - 0.2e1) / (0.2e1 * t121 - 0.2e1)
  t175 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t10
  t180 = 0.51785000000000000000000000000000000000000000000000e1 * t13 + 0.90577500000000000000000000000000000000000000000000e0 * t10 + 0.11003250000000000000000000000000000000000000000000e0 * t16 + 0.12417750000000000000000000000000000000000000000000e0 * t24
  t183 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t180
  t184 = jnp.log(t183)
  t190 = 0.1e1 / t115
  t193 = jnp.exp(-(-0.621814e-1 * t12 * t92 + 0.19751673498613801407483339618206552048944131217655e-1 * t173 * t175 * t184) * t162 * t107 * t190)
  t194 = t193 - 0.1e1
  t196 = t107 / t194
  t197 = s0 ** 2
  t198 = t196 * t197
  t199 = t163 * t198
  t201 = 0.1e1 / t21 / t117
  t202 = t121 ** 2
  t203 = t201 * t202
  t204 = t114 ** 2
  t205 = 0.1e1 / t204
  t207 = 0.1e1 / t19
  t209 = t1 * t207 * t6
  t210 = t203 * t205 * t209
  t213 = t151 * t121 * t155 / 0.96e2 + t199 * t210 / 0.3072e4
  t214 = t150 * t213
  t216 = t196 * t213
  t218 = t163 * t216 + 0.1e1
  t220 = t162 * t107 / t218
  t222 = s0 * t90
  t226 = 0.1e1 / t117
  t231 = -0.19444444444444444444444444444444444444444444444444e-2 * t222 * t123 * t131 - 0.41666666666666666666666666666666666666666666666666e-3 * s0 * t226 * t123 * t139
  t235 = t231 * t162
  t236 = t235 * t198
  t239 = t106 ** 2
  t240 = 0.1e1 / t239
  t241 = t161 * t240
  t242 = t107 ** 2
  t243 = t241 * t242
  t244 = t194 ** 2
  t245 = 0.1e1 / t244
  t246 = t245 * t197
  t247 = t246 * t201
  t248 = t243 * t247
  t252 = t202 / t204 / t115 * t1
  t253 = t207 * t6
  t257 = 0.1e1 / t27
  t258 = t12 * t257
  t261 = t173 * t1
  t266 = t173 * t175
  t267 = t180 ** 2
  t268 = 0.1e1 / t267
  t273 = -0.86308333333333333333333333333333333333333333333334e0 * t37 - 0.30192500000000000000000000000000000000000000000000e0 * t40 - 0.55016250000000000000000000000000000000000000000000e-1 * t44 - 0.82785000000000000000000000000000000000000000000000e-1 * t49
  t275 = 0.1e1 / t183
  t276 = t268 * t273 * t275
  t279 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t39 * t92 + 0.10000000000000000000000000000000000000000000000000e1 * t258 * t56 - 0.18311447306006545054854346104378990962041954983034e-3 * t261 * t33 * t35 * t184 - 0.58482236226346462072622386637590534819724553404280e0 * t266 * t276
  t280 = t279 * t193
  t282 = t252 * t253 * t280
  t285 = t143 * t202
  t287 = t285 * t205 * t209
  t290 = -0.7e1 / 0.288e3 * t222 * t121 * t155 + t236 * t210 / 0.3072e4 + t248 * t282 / 0.3072e4 - 0.7e1 / 0.4608e4 * t199 * t287
  t291 = t231 * t290
  t294 = t231 * t213
  t295 = t294 * t162
  t296 = t218 ** 2
  t298 = t107 / t296
  t300 = t242 * t245
  t301 = t241 * t300
  t302 = t213 * t279
  t303 = t190 * t193
  t304 = t302 * t303
  t306 = t196 * t290
  t308 = t163 * t306 + t235 * t216 + t301 * t304
  t309 = t298 * t308
  t315 = t150 * t162
  t316 = t315 * t198
  t319 = t231 * t240
  t320 = t319 * t242
  t321 = t320 * t247
  t327 = 0.1e1 / t239 / t106
  t328 = t161 * t327
  t329 = t242 * t107
  t330 = t328 * t329
  t332 = 0.1e1 / t244 / t194
  t333 = t332 * t197
  t334 = t333 * t201
  t335 = t330 * t334
  t336 = t204 ** 2
  t338 = 0.1e1 / t336 / t114
  t340 = t202 * t338 * t1
  t341 = t279 ** 2
  t342 = t193 ** 2
  t345 = t340 * t253 * t341 * t342
  t348 = t246 * t143
  t349 = t243 * t348
  t355 = t4 * t6
  t356 = t35 * t257
  t360 = t51 ** 2
  t361 = t360 * t55
  t364 = t84 * t55
  t367 = t360 * t100
  t374 = t173 * t4
  t378 = t267 * t180
  t379 = 0.1e1 / t378
  t380 = t273 ** 2
  t382 = t379 * t380 * t275
  t391 = -0.57538888888888888888888888888888888888888888888889e0 * t65 + 0.11507777777777777777777777777777777777777777777778e1 * t70 + 0.40256666666666666666666666666666666666666666666667e0 * t73 + 0.36677500000000000000000000000000000000000000000000e-1 * t77 + 0.73355000000000000000000000000000000000000000000000e-1 * t79 + 0.13797500000000000000000000000000000000000000000000e0 * t82
  t393 = t268 * t391 * t275
  t396 = t267 ** 2
  t397 = 0.1e1 / t396
  t398 = t397 * t380
  t399 = t183 ** 2
  t400 = 0.1e1 / t399
  t401 = t398 * t400
  t404 = -0.14764627977777777777777777777777777777777777777777e-2 * t4 * t72 * t92 - 0.35616666666666666666666666666666666666666666666666e-1 * t355 * t356 * t56 - 0.20000000000000000000000000000000000000000000000000e1 * t30 * t361 + 0.10000000000000000000000000000000000000000000000000e1 * t258 * t364 + 0.16081979498692535066756296899072713062105388428051e2 * t98 * t367 + 0.24415263074675393406472461472505321282722606644045e-3 * t261 * t33 * t68 * t184 + 0.10843581300301739842632067522386578331157260943710e-1 * t374 * t39 * t276 + 0.11696447245269292414524477327518106963944910680856e1 * t266 * t382 - 0.58482236226346462072622386637590534819724553404280e0 * t266 * t393 - 0.17315859105681463759666483083807725165579399831905e2 * t266 * t401
  t405 = t404 * t193
  t407 = t252 * t253 * t405
  t410 = t330 * t247
  t413 = t340 * t253 * t341 * t193
  t416 = t117 * t61
  t418 = 0.1e1 / t21 / t416
  t421 = t418 * t202 * t205 * t209
  t424 = 0.35e2 / 0.432e3 * t120 * t121 * t155 + t316 * t210 / 0.3072e4 + t321 * t282 / 0.1536e4 - 0.7e1 / 0.2304e4 * t236 * t287 + t335 * t345 / 0.1536e4 - 0.7e1 / 0.2304e4 * t349 * t282 + t248 * t407 / 0.3072e4 - t410 * t413 / 0.3072e4 + 0.119e3 / 0.13824e5 * t199 * t421
  t425 = t161 * t424
  t427 = t161 * t290
  t428 = t427 * t162
  t431 = t161 * t213
  t432 = t431 * t162
  t435 = t107 / t296 / t218
  t436 = t308 ** 2
  t437 = t435 * t436
  t441 = t319 * t300
  t446 = t329 * t332
  t447 = t328 * t446
  t448 = t213 * t341
  t450 = 0.1e1 / t204 / t114
  t451 = t450 * t342
  t452 = t448 * t451
  t455 = t290 * t279
  t456 = t455 * t303
  t459 = t213 * t404
  t460 = t459 * t303
  t462 = t329 * t245
  t463 = t328 * t462
  t464 = t450 * t193
  t465 = t448 * t464
  t467 = t196 * t424
  t469 = t163 * t467 + t315 * t216 + 0.2e1 * t235 * t306 + 0.2e1 * t301 * t456 + t301 * t460 + 0.2e1 * t441 * t304 + 0.2e1 * t447 * t452 - t463 * t465
  t470 = t298 * t469
  t472 = t214 * t220 + 0.2e1 * t291 * t220 + t425 * t220 - 0.2e1 * t295 * t309 - 0.2e1 * t428 * t309 + 0.2e1 * t432 * t437 - t432 * t470
  t474 = t431 * t220 + 0.1e1
  t475 = t474 ** 2
  t476 = 0.1e1 / t475
  t481 = t294 * t220 + t427 * t220 - t432 * t309
  t486 = t374 * t72 * t276
  t489 = t374 * t39 * t393
  t492 = t374 * t39 * t401
  t495 = t374 * t39 * t382
  t498 = 0.1e1 / t7 / t134
  t499 = s0 * t498
  t503 = t239 ** 2
  t504 = 0.1e1 / t503
  t505 = t161 * t504
  t506 = t242 ** 2
  t507 = t505 * t506
  t511 = 0.1e1 / t336 / t204 / t113
  t513 = t202 * t511 * t1
  t514 = t341 * t279
  t517 = t513 * t253 * t514 * t193
  t520 = t244 ** 2
  t521 = 0.1e1 / t520
  t522 = t521 * t197
  t523 = t522 * t201
  t525 = t342 * t193
  t528 = t513 * t253 * t514 * t525
  t534 = t513 * t253 * t514 * t342
  t543 = t360 * t51
  t544 = t543 * t55
  t545 = t98 * t544
  t553 = 0.1e1 / t396 / t267
  t554 = t380 * t273
  t557 = 0.1e1 / t399 / t183
  t558 = t553 * t554 * t557
  t559 = t266 * t558
  t562 = 0.1e1 / t396 / t180
  t564 = t562 * t554 * t400
  t565 = t266 * t564
  t570 = 0.1e1 / t13 / t24 * t2 / 0.4e1
  t571 = t570 * t226
  t574 = 0.1e1 / t21 / t88
  t575 = t60 * t574
  t576 = t59 * t575
  t578 = t33 * t90
  t579 = t32 * t578
  t581 = t4 * t91
  t583 = t10 ** (-0.15e1)
  t584 = t583 * t2
  t585 = t584 * t226
  t587 = t76 * t575
  t589 = t43 * t578
  t592 = t20 * t5 * t574
  t594 = -0.34523333333333333333333333333333333333333333333333e1 * t571 + 0.23015555555555555555555555555555555555555555555556e1 * t576 - 0.26851481481481481481481481481481481481481481481482e1 * t579 - 0.93932222222222222222222222222222222222222222222223e0 * t581 + 0.73355000000000000000000000000000000000000000000000e-1 * t585 - 0.14671000000000000000000000000000000000000000000000e0 * t587 - 0.17116166666666666666666666666666666666666666666667e0 * t589 - 0.36793333333333333333333333333333333333333333333333e0 * t592
  t596 = t268 * t594 * t275
  t597 = t266 * t596
  t600 = 0.48245938496077605200268890697218139186316165284153e2 * t103 + 0.60000000000000000000000000000000000000000000000000e1 * t545 - 0.60000000000000000000000000000000000000000000000000e1 * t86 - 0.21687162600603479685264135044773156662314521887420e-1 * t486 + 0.16265371950452609763948101283579867496735891415565e-1 * t489 + 0.48159733137676571081572406076840235616767705782485e0 * t492 + 0.34450798614814814814814814814814814814814814814813e-2 * t94 - 0.10254018858216406658218194626490193680059335835414e4 * t559 + 0.10389515463408878255799889850284635099347639899143e3 * t565 - 0.58482236226346462072622386637590534819724553404280e0 * t597 - 0.32530743900905219527896202567159734993471782831130e-1 * t495
  t602 = t400 * t273
  t604 = t266 * t397 * t391 * t602
  t607 = t397 * t554 * t275
  t608 = t266 * t607
  t610 = t379 * t273
  t611 = t275 * t391
  t613 = t266 * t610 * t611
  t616 = 0.1e1 / t96 / t27
  t617 = t12 * t616
  t619 = 0.1e1 / t99 / t54
  t620 = t543 * t619
  t621 = t617 * t620
  t624 = 0.1e1 / t96 / t26
  t625 = t12 * t624
  t626 = t543 * t100
  t627 = t625 * t626
  t637 = -0.25319000000000000000000000000000000000000000000000e1 * t571 + 0.16879333333333333333333333333333333333333333333333e1 * t576 - 0.19692555555555555555555555555555555555555555555555e1 * t579 - 0.93011851851851851851851851851851851851851851851854e0 * t581 + 0.13651666666666666666666666666666666666666666666667e0 * t585 - 0.27303333333333333333333333333333333333333333333333e0 * t587 - 0.31853888888888888888888888888888888888888888888890e0 * t589 - 0.36514074074074074074074074074074074074074074074075e0 * t592
  t638 = t637 * t55
  t639 = t258 * t638
  t641 = t35 * t97
  t643 = t355 * t641 * t367
  t645 = t68 * t257
  t647 = t355 * t645 * t56
  t650 = t355 * t356 * t364
  t654 = t355 * t35 * t29 * t361
  t658 = t261 * t33 * t90 * t184
  t660 = -0.51947577317044391278999449251423175496738199495715e2 * t604 - 0.35089341735807877243573431982554320891834732042568e1 * t608 + 0.35089341735807877243573431982554320891834732042568e1 * t613 + 0.51726012919273400298984252201052768390886626637712e3 * t621 - 0.96491876992155210400537781394436278372632330568306e2 * t627 + 0.10000000000000000000000000000000000000000000000000e1 * t639 - 0.85917975471764868594145516183295969534298037676861e0 * t643 + 0.71233333333333333333333333333333333333333333333331e-1 * t647 - 0.53424999999999999999999999999999999999999999999999e-1 * t650 + 0.10685000000000000000000000000000000000000000000000e0 * t654 - 0.56968947174242584615102410102512416326352748836105e-3 * t658
  t661 = t600 + t660
  t664 = t252 * t253 * t661 * t193
  t669 = t231 * t327
  t670 = t669 * t329
  t677 = t150 * t240
  t678 = t677 * t242
  t679 = t678 * t247
  t694 = t117 * t88
  t701 = t2 * t18 * t60 * t128
  t704 = -0.28086419753086419753086419753086419753086419753086e-1 * t499 * t123 * t131 - 0.16435185185185185185185185185185185185185185185185e-1 * s0 / t416 * t123 * t139 + 0.99999999999999999999999999999999999999999999999997e-2 * s0 * t418 * t121 * t147 - 0.13888888888888888888888888888888888888888888888889e-3 * s0 / t7 / t694 * t123 * t701
  t705 = t704 * t162
  t706 = t705 * t198
  t712 = 0.1e1 / t21 / t694
  t715 = t712 * t202 * t205 * t209
  t720 = t320 * t348
  t723 = t333 * t143
  t727 = t333 * t203
  t728 = t330 * t727
  t730 = t338 * t1 * t207
  t732 = t342 * t404
  t734 = t730 * t6 * t279 * t732
  t737 = t246 * t418
  t738 = t243 * t737
  t741 = t246 * t203
  t742 = t330 * t741
  t745 = t730 * t6 * t404 * t280
  t748 = -0.455e3 / 0.1296e4 * t499 * t121 * t155 + t507 * t247 * t517 / 0.3072e4 + t507 * t523 * t528 / 0.512e3 - t507 * t334 * t534 / 0.512e3 - 0.7e1 / 0.1536e4 * t349 * t407 + 0.7e1 / 0.1536e4 * t330 * t348 * t413 + t248 * t664 / 0.3072e4 + t321 * t407 / 0.1024e4 + t670 * t334 * t345 / 0.512e3 - t670 * t247 * t413 / 0.1024e4 + t679 * t282 / 0.1024e4 + t706 * t210 / 0.3072e4 - 0.7e1 / 0.1536e4 * t316 * t287 - 0.595e3 / 0.10368e5 * t199 * t715 + 0.119e3 / 0.4608e4 * t236 * t421 - 0.7e1 / 0.768e3 * t720 * t282 - 0.7e1 / 0.768e3 * t330 * t723 * t345 + t728 * t734 / 0.512e3 + 0.119e3 / 0.4608e4 * t738 * t282 - t742 * t745 / 0.1024e4
  t749 = t161 * t748
  t753 = t291 * t162
  t756 = t214 * t162
  t761 = t425 * t162
  t764 = t231 * t424
  t767 = t704 * t213
  t769 = t150 * t290
  t774 = t296 ** 2
  t776 = t107 / t774
  t778 = t776 * t436 * t308
  t782 = t435 * t308 * t469
  t787 = t196 * t748
  t793 = t450 * t279 * t193
  t794 = t459 * t793
  t797 = t451 * t404
  t798 = t302 * t797
  t803 = t506 * t245
  t804 = t505 * t803
  t805 = t213 * t514
  t807 = 0.1e1 / t336 / t113
  t808 = t807 * t193
  t809 = t805 * t808
  t811 = t213 * t661
  t812 = t811 * t303
  t814 = t290 * t404
  t815 = t814 * t303
  t818 = t290 * t341
  t819 = t818 * t464
  t823 = t424 * t279 * t303
  t826 = t818 * t451
  t829 = t506 * t521
  t830 = t505 * t829
  t831 = t807 * t525
  t832 = t805 * t831
  t835 = t506 * t332
  t836 = t505 * t835
  t837 = t807 * t342
  t838 = t805 * t837
  t841 = t677 * t300
  t848 = t669 * t446
  t851 = t669 * t462
  t854 = t163 * t787 + t705 * t216 + 0.3e1 * t315 * t306 - 0.3e1 * t463 * t794 + 0.6e1 * t447 * t798 + 0.3e1 * t235 * t467 + t804 * t809 + t301 * t812 + 0.3e1 * t301 * t815 - 0.3e1 * t463 * t819 + 0.3e1 * t301 * t823 + 0.6e1 * t447 * t826 + 0.6e1 * t830 * t832 - 0.6e1 * t836 * t838 + 0.3e1 * t841 * t304 + 0.6e1 * t441 * t456 + 0.3e1 * t441 * t460 + 0.6e1 * t848 * t452 - 0.3e1 * t851 * t465
  t855 = t298 * t854
  t857 = t749 * t220 + 0.3e1 * t764 * t220 + t767 * t220 + 0.3e1 * t769 * t220 + 0.6e1 * t295 * t437 - 0.3e1 * t295 * t470 - 0.6e1 * t753 * t309 - 0.3e1 * t756 * t309 - 0.3e1 * t761 * t309 + 0.6e1 * t428 * t437 - 0.3e1 * t428 * t470 - 0.6e1 * t432 * t778 + 0.6e1 * t432 * t782 - t432 * t855
  t862 = t360 ** 2
  t865 = 0.57895126195293126240322668836661767023579398340984e3 * t617 * t862 * t100
  t873 = 0.1e1 / t13 * r0 * t498 * t355 / 0.48e2
  t875 = t570 * t135
  t877 = t60 * t201
  t878 = t59 * t877
  t880 = t33 * t119
  t881 = t32 * t880
  t883 = t6 * t119
  t884 = t4 * t883
  t886 = t10 ** (-0.25e1)
  t889 = t886 * t2 * t498 * t355
  t891 = t584 * t135
  t893 = t76 * t877
  t895 = t43 * t880
  t898 = t20 * t5 * t201
  t903 = 0.10000000000000000000000000000000000000000000000000e1 * t258 * (-0.21099166666666666666666666666666666666666666666667e1 * t873 + 0.20255200000000000000000000000000000000000000000000e2 * t875 - 0.75019259259259259259259259259259259259259259259258e1 * t878 + 0.65641851851851851851851851851851851851851851851850e1 * t881 + 0.31003950617283950617283950617283950617283950617285e1 * t884 + 0.68258333333333333333333333333333333333333333333335e-1 * t889 - 0.10921333333333333333333333333333333333333333333333e1 * t891 + 0.12134814814814814814814814814814814814814814814815e1 * t893 + 0.10617962962962962962962962962962962962962962962963e1 * t895 + 0.13388493827160493827160493827160493827160493827161e1 * t898) * t55
  t904 = t481 ** 2
  t905 = t904 ** 2
  t907 = t475 ** 2
  t914 = t469 ** 2
  t920 = t231 * t504
  t928 = t704 * t240
  t934 = 0.24000000000000000000000000000000000000000000000000e2 * t625 * t862 * t55
  t935 = t84 ** 2
  t938 = 0.60000000000000000000000000000000000000000000000000e1 * t30 * t935 * t55
  t941 = 0.80000000000000000000000000000000000000000000000000e1 * t30 * t56 * t637
  t944 = 0.57895126195293126240322668836661767023579398340984e3 * t625 * t101 * t360
  t949 = 0.61524113149298439949309167758941162080356015012483e4 * t266 * t553 * t391 * t557 * t380
  t953 = 0.46785788981077169658097909310072427855779642723424e1 * t266 * t610 * t275 * t594
  t957 = 0.36846163202829085479643115651216588683774907041596e2 * t355 * t35 * t616 * t620
  t961 = 0.68734380377411894875316412946636775627438430141488e1 * t355 * t35 * t624 * t626
  t965 = 0.69263436422725855038665932335230900662317599327620e2 * t266 * t397 * t594 * t602
  t966 = t865 + t903 - t934 - t938 - t941 - t944 - t949 + t953 - t957 + t961 - t965
  t970 = 0.22161481481481481481481481481481481481481481481481e0 * t355 * t90 * t257 * t56
  t974 = 0.28493333333333333333333333333333333333333333333333e0 * t355 * t68 * t29 * t361
  t977 = 0.42740000000000000000000000000000000000000000000000e0 * t355 * t641 * t544
  t981 = 0.18989649058080861538367470034170805442117582945368e-2 * t261 * t33 * t119 * t184
  t986 = 0.62337092780453269534799339101707810596085839394858e3 * t266 * t562 * t391 * t400 * t380
  t989 = 0.21053605041484726346144059189532592535100839225540e2 * t266 * t398 * t611
  t992 = 0.14246666666666666666666666666666666666666666666666e0 * t355 * t645 * t364
  t996 = 0.22911460125803964958438804315545591875812810047162e1 * t355 * t68 * t97 * t367
  t999 = 0.71233333333333333333333333333333333333333333333332e-1 * t355 * t356 * t638
  t1003 = 0.42740000000000000000000000000000000000000000000000e0 * t40 * t29 * t84 * t56
  t1008 = 0.34367190188705947437658206473318387813719215070744e1 * t40 * t97 * t84 * t100 * t51
  t1011 = 0.48245938496077605200268890697218139186316165284153e2 * t98 * t935 * t100
  t1012 = -t970 - t974 - t977 + t981 + t986 - t989 + t992 + t996 - t999 + t1003 - t1008 + t1011
  t1017 = 0.64327917994770140267025187596290852248421553712204e2 * t98 * t637 * t100 * t51
  t1021 = 0.31035607751564040179390551320631661034531975982628e4 * t617 * t84 * t619 * t360
  t1022 = t391 ** 2
  t1026 = 0.35089341735807877243573431982554320891834732042568e1 * t266 * t379 * t1022 * t275
  t1027 = t380 ** 2
  t1031 = 0.14035736694323150897429372793021728356733892817027e2 * t266 * t562 * t1027 * t275
  t1035 = 0.51947577317044391278999449251423175496738199495715e2 * t266 * t397 * t1022 * t400
  t1036 = t396 ** 2
  t1039 = t399 ** 2
  t1043 = 0.91082604192152556048340974007871726131433263376469e5 * t266 / t1036 * t1027 / t1039
  t1058 = 0.58482236226346462072622386637590534819724553404280e0 * t266 * t268 * (-0.28769444444444444444444444444444444444444444444444e1 * t873 + 0.27618666666666666666666666666666666666666666666667e2 * t875 - 0.10229135802469135802469135802469135802469135802469e2 * t878 + 0.89504938271604938271604938271604938271604938271607e1 * t881 + 0.31310740740740740740740740740740740740740740740741e1 * t884 + 0.36677500000000000000000000000000000000000000000000e-1 * t889 - 0.58684000000000000000000000000000000000000000000000e0 * t891 + 0.65204444444444444444444444444444444444444444444445e0 * t893 + 0.57053888888888888888888888888888888888888888888890e0 * t895 + 0.13490888888888888888888888888888888888888888888889e1 * t898) * t275
  t1064 = 0.12304822629859687989861833551788232416071203002497e5 * t266 / t396 / t378 * t1027 * t557
  t1068 = 0.62337092780453269534799339101707810596085839394858e3 * t266 * t553 * t1027 * t400
  t1074 = 0.62071215503128080358781102641263322069063951965254e4 * t12 / t96 / t28 * t862 * t619
  t1077 = 0.67471172535210825687488420139294265171645179205307e-1 * t374 * t91 * t276
  t1078 = t1017 + t1021 + t1026 + t1031 - t1035 - t1043 - t1058 + t1064 - t1068 - t1074 + t1077
  t1081 = 0.43374325201206959370528270089546313324629043774840e-1 * t374 * t72 * t393
  t1084 = 0.12842595503380418955085974953824062831138054875329e1 * t374 * t72 * t401
  t1087 = 0.21687162600603479685264135044773156662314521887420e-1 * t374 * t39 * t596
  t1090 = 0.38025319932552508024225805073234468230220037056326e2 * t374 * t39 * t558
  t1093 = 0.13012297560362087811158481026863893997388713132452e0 * t374 * t39 * t607
  t1096 = 0.38527786510141256865257924861472188493414164625988e1 * t374 * t39 * t564
  t1099 = 0.86748650402413918741056540179092626649258087549680e-1 * t374 * t72 * t382
  t1102 = 0.36000000000000000000000000000000000000000000000000e2 * t98 * t361 * t84
  t1105 = 0.11483599538271604938271604938271604938271604938271e-1 * t4 * t883 * t92
  t1106 = t96 ** 2
  t1109 = t99 ** 2
  t1113 = 0.24955700379505800914252936827276051226357058527653e5 * t12 / t1106 * t862 / t1109
  t1114 = t173 * t355
  t1119 = t1114 * t35 * t397 * t391 * t400 * t273
  t1126 = 0.13012297560362087811158481026863893997388713132452e0 * t1114 * t35 * t379 * t273 * t275 * t391
  t1127 = -t1081 - t1084 + t1087 + t1090 + t1093 - t1096 + t1099 + t1102 - t1105 + t1113 + 0.19263893255070628432628962430736094246707082312995e1 * t1119 - t1126
  t1129 = t966 + t1012 + t1078 + t1127
  t1137 = t161 / t503 / t106
  t1138 = t506 * t107
  t1140 = 0.1e1 / t520 / t194
  t1143 = t341 ** 2
  t1144 = t213 * t1143
  t1146 = 0.1e1 / t336 / t204
  t1147 = t342 ** 2
  t1164 = t150 * t327
  t1171 = t290 * t514
  t1186 = s0 / t7 / t416
  t1199 = t117 ** 2
  t1217 = 0.14979423868312757201646090534979423868312757201646e0 * t1186 * t123 * t131 + 0.11265432098765432098765432098765432098765432098765e0 * s0 / t694 * t123 * t139 - 0.99537037037037037037037037037037037037037037037035e-1 * s0 * t712 * t121 * t147 + 0.26851851851851851851851851851851851851851851851851e-2 * s0 / t7 / t1199 * t123 * t701 - 0.69444444444444444444444444444444444444444444444445e-4 * s0 / t1199 / r0 * t123 * t2 ** 2 * t1 * t3 * t6 * t128
  t1218 = t1217 * t162
  t1220 = t424 * t341
  t1231 = 0.4e1 * t301 * t748 * t279 * t303 + 0.12e2 * t1164 * t446 * t452 - 0.6e1 * t1164 * t462 * t465 + 0.24e2 * t830 * t1171 * t831 - 0.24e2 * t836 * t1171 * t837 - 0.6e1 * t463 * t1220 * t464 + 0.24e2 * t920 * t829 * t832 + t1218 * t216 + 0.4e1 * t235 * t787 + 0.4e1 * t705 * t306 + 0.6e1 * t315 * t467
  t1233 = t807 * t341
  t1289 = t404 ** 2
  t1290 = t213 * t1289
  t1303 = t920 * t506
  t1317 = t1137 * t1138
  t1319 = t336 ** 2
  t1322 = t202 / t1319 * t1
  t1357 = t6 * t661
  t1373 = t511 * t1 * t207
  t1374 = t6 * t341
  t1395 = -0.7e1 / 0.1152e4 * t507 * t348 * t517 + 0.119e3 / 0.2304e4 * t316 * t421 + 0.13685e5 / 0.31104e5 * t199 / t21 / t1199 * t202 * t205 * t209 + t1218 * t198 * t210 / 0.3072e4 + t728 * t730 * t1357 * t342 * t279 / 0.384e3 - t742 * t730 * t1357 * t280 / 0.768e3 + 0.7e1 / 0.384e3 * t330 * t246 * t285 * t745 - 0.3e1 / 0.256e3 * t507 * t727 * t1373 * t1374 * t732 - 0.7e1 / 0.192e3 * t330 * t333 * t285 * t734 + 0.3e1 / 0.256e3 * t507 * t522 * t203 * t1373 * t1374 * t525 * t404 + t507 * t741 * t1373 * t1374 * t405 / 0.512e3
  t1434 = t670 * t727 * t734 / 0.128e3 - t670 * t741 * t745 / 0.256e3 + 0.455e3 / 0.243e3 * t1186 * t121 * t155 - 0.7e1 / 0.192e3 * t670 * t723 * t345 + t321 * t664 / 0.768e3 + t248 * t252 * t253 * t1129 * t193 / 0.3072e4 - 0.119e3 / 0.2304e4 * t330 * t737 * t413 + 0.119e3 / 0.1152e4 * t320 * t737 * t282 + 0.119e3 / 0.1152e4 * t330 * t333 * t418 * t345 - 0.7e1 / 0.384e3 * t678 * t348 * t282 - t410 * t340 * t253 * t1289 * t193 / 0.1024e4
  t1440 = t1164 * t329
  t1480 = t335 * t340 * t253 * t1289 * t342 / 0.512e3 - t1440 * t247 * t413 / 0.512e3 + t928 * t242 * t247 * t282 / 0.768e3 + t679 * t407 / 0.512e3 + t1440 * t334 * t345 / 0.256e3 - t1317 * t247 * t1322 * t253 * t1143 * t193 / 0.3072e4 + t1303 * t523 * t528 / 0.128e3 + t1317 * t1140 * t197 * t201 * t1322 * t253 * t1143 * t1147 / 0.128e3 - 0.3e1 / 0.256e3 * t1317 * t523 * t1322 * t253 * t1143 * t525 - 0.595e3 / 0.2592e4 * t236 * t715 - 0.7e1 / 0.1152e4 * t706 * t287
  t1482 = -t1303 * t334 * t534 / 0.128e3 - 0.7e1 / 0.384e3 * t720 * t407 - 0.7e1 / 0.1152e4 * t349 * t664 + 0.7e1 / 0.384e3 * t670 * t348 * t413 + t1303 * t247 * t517 / 0.768e3 + 0.7e1 / 0.1536e4 * t1317 * t334 * t1322 * t253 * t1143 * t342 + 0.119e3 / 0.2304e4 * t738 * t407 - 0.595e3 / 0.2592e4 * t243 * t246 * t712 * t282 - 0.7e1 / 0.192e3 * t507 * t522 * t143 * t528 + 0.7e1 / 0.192e3 * t507 * t723 * t534 + t1395 + t1434 + t1480
  t1485 = -t1137 * t1138 * t245 * t1144 * t1146 * t193 + 0.14e2 * t1137 * t1138 * t332 * t1144 * t1146 * t342 + 0.6e1 * t301 * t424 * t404 * t303 + 0.4e1 * t804 * t1171 * t808 + 0.6e1 * t447 * t1290 * t451 - 0.3e1 * t463 * t1290 * t464 + t163 * t196 * t1482 - 0.4e1 * t463 * t811 * t793 - 0.12e2 * t463 * t814 * t793 + 0.12e2 * t441 * t823 + 0.6e1 * t841 * t460
  t1513 = -0.4e1 * t428 * t855 + 0.6e1 * t432 * t435 * t914 + 0.12e2 * t761 * t437 - t432 * t298 * (0.24e2 * t1137 * t1138 * t1140 * t1144 * t1146 * t1147 - 0.36e2 * t1137 * t1138 * t521 * t1144 * t1146 * t525 + t301 * t213 * t1129 * t303 + 0.4e1 * t928 * t300 * t304 + 0.4e1 * t920 * t803 * t809 - 0.24e2 * t920 * t835 * t838 + 0.4e1 * t441 * t812 + 0.12e2 * t441 * t815 + 0.12e2 * t841 * t456 - 0.12e2 * t851 * t819 + t1231 + 0.6e1 * t804 * t459 * t1233 * t193 - 0.36e2 * t836 * t459 * t1233 * t342 + 0.4e1 * t301 * t290 * t661 * t303 + 0.8e1 * t447 * t302 * t451 * t661 + 0.36e2 * t830 * t448 * t831 * t404 + 0.12e2 * t447 * t1220 * t451 + 0.24e2 * t447 * t455 * t797 - 0.12e2 * t851 * t794 + 0.24e2 * t848 * t798 + 0.24e2 * t848 * t826 + t1485) + t1217 * t213 * t220 + 0.6e1 * t150 * t424 * t220 + t161 * t1482 * t220 - 0.4e1 * t749 * t162 * t309 + 0.4e1 * t231 * t748 * t220 + 0.24e2 * t753 * t437 - 0.4e1 * t767 * t162 * t309 - 0.6e1 * t761 * t470 - 0.12e2 * t764 * t162 * t309
  t1541 = t436 ** 2
  t1551 = -0.12e2 * t769 * t162 * t309 + 0.24e2 * t295 * t782 - 0.6e1 * t756 * t470 + 0.4e1 * t704 * t290 * t220 + 0.8e1 * t432 * t435 * t308 * t854 - 0.12e2 * t753 * t470 + 0.12e2 * t756 * t437 - 0.4e1 * t295 * t855 - 0.24e2 * t295 * t778 - 0.24e2 * t428 * t778 + 0.24e2 * t432 * t107 / t774 / t218 * t1541 + 0.24e2 * t428 * t782 - 0.36e2 * t432 * t776 * t436 * t469
  t1554 = 0.1e1 / t474
  t1557 = -0.4e1 * t116 * t857 * t476 * t481 + t865 + t903 - 0.6e1 * t109 * t115 * t905 / t907 + t109 * t115 * (t1513 + t1551) * t1554 - t934 - t938 - t941 - t944 - t949 + t953 - t957
  t1558 = t961 - t965 - t970 - t974 - t977 + t981 + t986 - t989 + t992 + t996 - t999 + t1003 - t1008
  t1561 = 0.1e1 / t475 / t474
  t1566 = t472 ** 2
  t1571 = -0.3e1 * t109 * t115 * t1566 * t476 + 0.12e2 * t116 * t904 * t1561 * t472 + t1011 + t1017 + t1021 + t1026 + t1031 - t1035 - t1043 - t1058 + t1064 - t1068 - t1074
  t1573 = t1077 - t1081 - t1084 + t1087 + t1090 + t1093 - t1096 + t1099 + t1102 - t1105 + t1113 + 0.19263893255070628432628962430736094246707082312994e1 * t1119 - t1126
  t1581 = -0.24000000000000000000000000000000000000000000000000e2 * t86 + 0.13780319445925925925925925925925925925925925925925e-1 * t94 + 0.19298375398431042080107556278887255674526466113661e3 * t103 - 0.12e2 * t116 * t472 * t476 * t481 - 0.86748650402413918741056540179092626649258087549680e-1 * t486 + 0.65061487801810439055792405134319469986943565662260e-1 * t489 + 0.19263893255070628432628962430736094246707082312994e1 * t492 - 0.13012297560362087811158481026863893997388713132452e0 * t495 + r0 * (t1557 + t1558 + t1571 + t1573) - 0.41016075432865626632872778505960774720237343341655e4 * t559 + 0.41558061853635513023199559401138540397390559596572e3 * t565 - 0.23392894490538584829048954655036213927889821361712e1 * t597 - 0.14035736694323150897429372793021728356733892817027e2 * t608
  t1602 = 0.8e1 * t109 * t115 * t904 * t481 * t1561 + 0.24000000000000000000000000000000000000000000000000e2 * t545 + 0.40000000000000000000000000000000000000000000000000e1 * t639 + 0.20690405167709360119593700880421107356354650655085e4 * t621 + 0.4e1 * t109 * t115 * t857 * t1554 - 0.38596750796862084160215112557774511349052932227323e3 * t627 - 0.20779030926817756511599779700569270198695279798286e3 * t604 + 0.14035736694323150897429372793021728356733892817027e2 * t613 - 0.34367190188705947437658206473318387813719215070744e1 * t643 + 0.28493333333333333333333333333333333333333333333333e0 * t647 - 0.21370000000000000000000000000000000000000000000000e0 * t650 + 0.42740000000000000000000000000000000000000000000000e0 * t654 - 0.22787578869697033846040964041004966530541099534442e-2 * t658
  v4rho4_0_ = t1581 + t1602

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t14 = t4 * t6 / t8
  t15 = jnp.sqrt(t14)
  t18 = t14 ** 0.15e1
  t20 = t1 ** 2
  t21 = t3 ** 2
  t22 = t20 * t21
  t23 = t8 ** 2
  t26 = t22 * t5 / t23
  t28 = 0.37978500000000000000000000000000000000000000000000e1 * t15 + 0.89690000000000000000000000000000000000000000000000e0 * t14 + 0.20477500000000000000000000000000000000000000000000e0 * t18 + 0.12323500000000000000000000000000000000000000000000e0 * t26
  t31 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t28
  t32 = jnp.log(t31)
  t34 = t4 * t11 * t32
  t35 = 0.22146941966666666666666666666666666666666666666666e-2 * t34
  t37 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t14
  t38 = t28 ** 2
  t39 = 0.1e1 / t38
  t40 = t37 * t39
  t42 = 0.1e1 / t15 * t1
  t43 = t3 * t6
  t44 = t43 * t10
  t45 = t42 * t44
  t47 = t4 * t11
  t49 = t14 ** 0.5e0
  t50 = t49 * t1
  t51 = t50 * t44
  t56 = t22 * t5 / t23 / t7
  t58 = -0.63297500000000000000000000000000000000000000000000e0 * t45 - 0.29896666666666666666666666666666666666666666666667e0 * t47 - 0.10238750000000000000000000000000000000000000000000e0 * t51 - 0.82156666666666666666666666666666666666666666666667e-1 * t56
  t59 = 0.1e1 / t31
  t60 = t58 * t59
  t61 = t40 * t60
  t62 = 0.20000000000000000000000000000000000000000000000000e1 * t61
  t63 = r0 - r1
  t64 = t63 ** 2
  t65 = t64 * t63
  t66 = t7 ** 2
  t67 = t66 ** 2
  t68 = 0.1e1 / t67
  t69 = t65 * t68
  t70 = 0.1e1 / t7
  t71 = t63 * t70
  t72 = 0.1e1 + t71
  t73 = t72 <= f.p.zeta_threshold
  t74 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t75 = t74 * f.p.zeta_threshold
  t76 = t72 ** (0.1e1 / 0.3e1)
  t77 = t76 * t72
  t78 = f.my_piecewise3(t73, t75, t77)
  t79 = 0.1e1 - t71
  t80 = t79 <= f.p.zeta_threshold
  t81 = t79 ** (0.1e1 / 0.3e1)
  t82 = t81 * t79
  t83 = f.my_piecewise3(t80, t75, t82)
  t85 = 2 ** (0.1e1 / 0.3e1)
  t88 = 0.1e1 / (0.2e1 * t85 - 0.2e1)
  t89 = (t78 + t83 - 0.2e1) * t88
  t91 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t14
  t96 = 0.70594500000000000000000000000000000000000000000000e1 * t15 + 0.15494250000000000000000000000000000000000000000000e1 * t14 + 0.42077500000000000000000000000000000000000000000000e0 * t18 + 0.15629250000000000000000000000000000000000000000000e0 * t26
  t99 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t96
  t100 = jnp.log(t99)
  t104 = 0.621814e-1 * t37 * t32
  t106 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t14
  t111 = 0.51785000000000000000000000000000000000000000000000e1 * t15 + 0.90577500000000000000000000000000000000000000000000e0 * t14 + 0.11003250000000000000000000000000000000000000000000e0 * t18 + 0.12417750000000000000000000000000000000000000000000e0 * t26
  t114 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t111
  t115 = jnp.log(t114)
  t116 = t106 * t115
  t118 = -0.3109070e-1 * t91 * t100 + t104 - 0.19751673498613801407483339618206552048944131217655e-1 * t116
  t119 = t89 * t118
  t120 = t69 * t119
  t121 = 0.8e1 * t120
  t122 = t64 ** 2
  t123 = t67 * t7
  t124 = 0.1e1 / t123
  t125 = t122 * t124
  t126 = t125 * t119
  t127 = 0.8e1 * t126
  t128 = t122 * t68
  t129 = 0.1e1 / t66
  t130 = t63 * t129
  t131 = t70 - t130
  t134 = f.my_piecewise3(t73, 0, 0.4e1 / 0.3e1 * t76 * t131)
  t135 = -t131
  t138 = f.my_piecewise3(t80, 0, 0.4e1 / 0.3e1 * t81 * t135)
  t140 = (t134 + t138) * t88
  t141 = t140 * t118
  t142 = t128 * t141
  t147 = t96 ** 2
  t148 = 0.1e1 / t147
  t149 = t91 * t148
  t154 = -0.11765750000000000000000000000000000000000000000000e1 * t45 - 0.51647500000000000000000000000000000000000000000000e0 * t47 - 0.21038750000000000000000000000000000000000000000000e0 * t51 - 0.10419500000000000000000000000000000000000000000000e0 * t56
  t155 = 0.1e1 / t99
  t156 = t154 * t155
  t159 = 0.11073470983333333333333333333333333333333333333333e-2 * t34
  t160 = 0.10000000000000000000000000000000000000000000000000e1 * t61
  t164 = t111 ** 2
  t165 = 0.1e1 / t164
  t166 = t106 * t165
  t171 = -0.86308333333333333333333333333333333333333333333334e0 * t45 - 0.30192500000000000000000000000000000000000000000000e0 * t47 - 0.55016250000000000000000000000000000000000000000000e-1 * t51 - 0.82785000000000000000000000000000000000000000000000e-1 * t56
  t172 = 0.1e1 / t114
  t173 = t171 * t172
  t176 = 0.53237641966666666666666666666666666666666666666666e-3 * t4 * t11 * t100 + 0.10000000000000000000000000000000000000000000000000e1 * t149 * t156 - t159 - t160 + 0.18311447306006545054854346104378990962041954983034e-3 * t4 * t11 * t115 + 0.58482236226346462072622386637590534819724553404280e0 * t166 * t173
  t177 = t89 * t176
  t178 = t128 * t177
  t179 = 0.2e1 * t178
  t180 = t140 * t116
  t182 = t89 * t1
  t184 = t43 * t10 * t115
  t185 = t182 * t184
  t186 = 0.36622894612013090109708692208757981924083909966068e-3 * t185
  t187 = t89 * t106
  t189 = t165 * t171 * t172
  t190 = t187 * t189
  t191 = 0.11696447245269292414524477327518106963944910680856e1 * t190
  t192 = jnp.log(0.2e1)
  t193 = 0.1e1 - t192
  t194 = jnp.pi ** 2
  t196 = t193 / t194
  t197 = t74 ** 2
  t198 = t76 ** 2
  t199 = f.my_piecewise3(t73, t197, t198)
  t200 = t81 ** 2
  t201 = f.my_piecewise3(t80, t197, t200)
  t203 = t199 / 0.2e1 + t201 / 0.2e1
  t204 = t203 ** 2
  t206 = s0 + 0.2e1 * s1 + s2
  t208 = 0.1e1 / t8 / t66
  t209 = t206 * t208
  t210 = 0.1e1 / t204
  t211 = t85 * t210
  t213 = 0.1e1 / t3
  t214 = t20 * t213
  t216 = jnp.exp(-t26 / 0.4e1)
  t217 = 0.1e1 - t216
  t218 = t5 * t217
  t219 = t214 * t218
  t222 = 0.375e-1 + 0.83333333333333333333333333333333333333333333333332e-3 * t209 * t211 * t219
  t225 = t213 * t5
  t226 = t210 * t20 * t225
  t229 = 0.1e1 / t193
  t230 = t222 * t229
  t235 = (-t104 + t128 * t119 + 0.19751673498613801407483339618206552048944131217655e-1 * t89 * t116) * t229
  t236 = t204 * t203
  t237 = 0.1e1 / t236
  t238 = t194 * t237
  t240 = jnp.exp(-t235 * t238)
  t241 = t240 - 0.1e1
  t242 = 0.1e1 / t241
  t243 = t194 * t242
  t244 = t206 ** 2
  t245 = t243 * t244
  t246 = t230 * t245
  t248 = 0.1e1 / t23 / t67
  t249 = t85 ** 2
  t250 = t248 * t249
  t251 = t204 ** 2
  t252 = 0.1e1 / t251
  t254 = 0.1e1 / t21
  t256 = t1 * t254 * t6
  t257 = t250 * t252 * t256
  t260 = t209 * t85 * t226 / 0.96e2 + t246 * t257 / 0.3072e4
  t261 = t222 * t260
  t263 = t243 * t260
  t265 = t230 * t263 + 0.1e1
  t267 = t229 * t194 / t265
  t269 = t261 * t267 + 0.1e1
  t270 = jnp.log(t269)
  t271 = t204 * t270
  t272 = 0.1e1 / t76
  t275 = f.my_piecewise3(t73, 0, 0.2e1 / 0.3e1 * t272 * t131)
  t276 = 0.1e1 / t81
  t279 = f.my_piecewise3(t80, 0, 0.2e1 / 0.3e1 * t276 * t135)
  t281 = t275 / 0.2e1 + t279 / 0.2e1
  t283 = t196 * t271 * t281
  t285 = t66 * t7
  t288 = t206 / t8 / t285
  t291 = 0.19444444444444444444444444444444444444444444444444e-2 * t288 * t211 * t219
  t292 = t85 * t237
  t293 = t209 * t292
  t295 = t214 * t218 * t281
  t298 = t206 * t68
  t300 = t6 * t216
  t301 = t4 * t300
  t303 = 0.41666666666666666666666666666666666666666666666666e-3 * t298 * t211 * t301
  t304 = -t291 - 0.16666666666666666666666666666666666666666666666666e-2 * t293 * t295 - t303
  t305 = t304 * t260
  t309 = 0.7e1 / 0.288e3 * t288 * t85 * t226
  t311 = t214 * t5 * t281
  t314 = t304 * t229
  t315 = t314 * t245
  t318 = t230 * t194
  t319 = t241 ** 2
  t320 = 0.1e1 / t319
  t321 = t320 * t244
  t322 = t321 * t248
  t323 = t318 * t322
  t325 = t249 * t252 * t1
  t326 = t254 * t6
  t327 = 0.4e1 * t120
  t328 = 0.4e1 * t126
  t329 = 0.19751673498613801407483339618206552048944131217655e-1 * t180
  t330 = 0.18311447306006545054854346104378990962041954983034e-3 * t185
  t331 = 0.58482236226346462072622386637590534819724553404280e0 * t190
  t333 = (t159 + t160 + t327 - t328 + t142 + t178 + t329 - t330 - t331) * t229
  t335 = t194 * t252
  t336 = t335 * t281
  t339 = 0.3e1 * t235 * t336 - t333 * t238
  t340 = t339 * t240
  t342 = t325 * t326 * t340
  t346 = 0.1e1 / t23 / t123
  t349 = t346 * t249 * t252 * t256
  t351 = 0.7e1 / 0.4608e4 * t246 * t349
  t352 = t242 * t244
  t353 = t352 * t248
  t354 = t318 * t353
  t356 = 0.1e1 / t251 / t203
  t358 = t249 * t356 * t1
  t360 = t358 * t326 * t281
  t363 = -t309 - t293 * t311 / 0.48e2 + t315 * t257 / 0.3072e4 - t323 * t342 / 0.3072e4 - t351 - t354 * t360 / 0.768e3
  t364 = t222 * t363
  t366 = t261 * t229
  t367 = t265 ** 2
  t369 = t194 / t367
  t371 = t320 * t260
  t372 = t371 * t340
  t374 = t243 * t363
  t376 = t230 * t374 + t314 * t263 - t318 * t372
  t377 = t369 * t376
  t379 = t305 * t267 + t364 * t267 - t366 * t377
  t381 = 0.1e1 / t269
  t383 = t196 * t236 * t379 * t381
  t388 = 0.10843581300301739842632067522386578331157260943710e-1 * t89 * t4 * t11 * t189
  t391 = 0.12e2 * t64 * t68 * t119
  t394 = 0.32e2 * t65 * t124 * t119
  t395 = t67 * t66
  t399 = 0.20e2 * t122 / t395 * t119
  t400 = t6 * t208
  t404 = t4 * t6
  t412 = t154 ** 2
  t421 = 0.1e1 / t23 / t66
  t422 = t21 * t5 * t421
  t423 = 0.1e1 / t15 / t14 * t20 * t422
  t425 = t43 * t208
  t426 = t42 * t425
  t428 = t4 * t400
  t430 = t14 ** (-0.5e0)
  t432 = t430 * t20 * t422
  t434 = t50 * t425
  t437 = t22 * t5 * t421
  t443 = t147 ** 2
  t446 = t99 ** 2
  t453 = 0.14764627977777777777777777777777777777777777777777e-2 * t4 * t400 * t32
  t457 = 0.35616666666666666666666666666666666666666666666666e-1 * t404 * t10 * t39 * t60
  t461 = t58 ** 2
  t464 = 0.20000000000000000000000000000000000000000000000000e1 * t37 / t38 / t28 * t461 * t59
  t474 = 0.10000000000000000000000000000000000000000000000000e1 * t40 * (-0.42198333333333333333333333333333333333333333333333e0 * t423 + 0.84396666666666666666666666666666666666666666666666e0 * t426 + 0.39862222222222222222222222222222222222222222222223e0 * t428 + 0.68258333333333333333333333333333333333333333333333e-1 * t432 + 0.13651666666666666666666666666666666666666666666667e0 * t434 + 0.13692777777777777777777777777777777777777777777778e0 * t437) * t59
  t475 = t38 ** 2
  t478 = t31 ** 2
  t482 = 0.16081979498692535066756296899072713062105388428051e2 * t37 / t475 * t461 / t478
  t491 = 0.1e1 / t164 / t111
  t493 = t171 ** 2
  t503 = -0.57538888888888888888888888888888888888888888888889e0 * t423 + 0.11507777777777777777777777777777777777777777777778e1 * t426 + 0.40256666666666666666666666666666666666666666666667e0 * t428 + 0.36677500000000000000000000000000000000000000000000e-1 * t432 + 0.73355000000000000000000000000000000000000000000000e-1 * t434 + 0.13797500000000000000000000000000000000000000000000e0 * t437
  t507 = t164 ** 2
  t508 = 0.1e1 / t507
  t510 = t114 ** 2
  t511 = 0.1e1 / t510
  t515 = -0.70983522622222222222222222222222222222222222222221e-3 * t4 * t400 * t100 - 0.34246666666666666666666666666666666666666666666666e-1 * t404 * t10 * t148 * t156 - 0.20000000000000000000000000000000000000000000000000e1 * t91 / t147 / t96 * t412 * t155 + 0.10000000000000000000000000000000000000000000000000e1 * t149 * (-0.78438333333333333333333333333333333333333333333333e0 * t423 + 0.15687666666666666666666666666666666666666666666667e1 * t426 + 0.68863333333333333333333333333333333333333333333333e0 * t428 + 0.14025833333333333333333333333333333333333333333333e0 * t432 + 0.28051666666666666666666666666666666666666666666667e0 * t434 + 0.17365833333333333333333333333333333333333333333333e0 * t437) * t155 + 0.32163958997385070133512593798145426124210776856102e2 * t91 / t443 * t412 / t446 + t453 + t457 + t464 - t474 - t482 - 0.24415263074675393406472461472505321282722606644045e-3 * t4 * t400 * t115 - 0.10843581300301739842632067522386578331157260943710e-1 * t404 * t10 * t165 * t173 - 0.11696447245269292414524477327518106963944910680856e1 * t106 * t491 * t493 * t172 + 0.58482236226346462072622386637590534819724553404280e0 * t166 * t503 * t172 + 0.17315859105681463759666483083807725165579399831905e2 * t106 * t508 * t493 * t511
  t517 = t128 * t89 * t515
  t519 = t140 * t1 * t184
  t520 = 0.36622894612013090109708692208757981924083909966068e-3 * t519
  t524 = 0.24415263074675393406472461472505321282722606644045e-3 * t182 * t43 * t208 * t115
  t525 = t379 ** 2
  t527 = t269 ** 2
  t528 = 0.1e1 / t527
  t531 = 0.1e1 / t198
  t532 = t131 ** 2
  t535 = 0.1e1 / t285
  t536 = t63 * t535
  t538 = -0.2e1 * t129 + 0.2e1 * t536
  t542 = f.my_piecewise3(t73, 0, 0.4e1 / 0.9e1 * t531 * t532 + 0.4e1 / 0.3e1 * t76 * t538)
  t543 = 0.1e1 / t200
  t544 = t135 ** 2
  t547 = -t538
  t551 = f.my_piecewise3(t80, 0, 0.4e1 / 0.9e1 * t543 * t544 + 0.4e1 / 0.3e1 * t81 * t547)
  t553 = (t542 + t551) * t88
  t555 = 0.19751673498613801407483339618206552048944131217655e-1 * t553 * t116
  t557 = 0.8e1 * t69 * t177
  t558 = -t196 * t236 * t525 * t528 + t388 + t391 - t394 + t399 - t457 - t464 + t474 + t482 + t517 - t520 + t524 + t555 + t557
  t559 = 0.1e1 / t77
  t565 = f.my_piecewise3(t73, 0, -0.2e1 / 0.9e1 * t559 * t532 + 0.2e1 / 0.3e1 * t272 * t538)
  t566 = 0.1e1 / t82
  t572 = f.my_piecewise3(t80, 0, -0.2e1 / 0.9e1 * t566 * t544 + 0.2e1 / 0.3e1 * t276 * t547)
  t574 = t565 / 0.2e1 + t572 / 0.2e1
  t580 = t206 / t8 / t67
  t583 = 0.64814814814814814814814814814814814814814814814813e-2 * t580 * t211 * t219
  t584 = t288 * t292
  t585 = t584 * t295
  t590 = 0.26388888888888888888888888888888888888888888888888e-2 * t206 * t124 * t211 * t301
  t591 = t85 * t252
  t592 = t209 * t591
  t593 = t281 ** 2
  t598 = t298 * t292
  t601 = t598 * t4 * t300 * t281
  t612 = 0.83333333333333333333333333333333333333333333333332e-3 * t206 * t346 * t85 * t210 * t2 * t216
  t613 = t583 + 0.77777777777777777777777777777777777777777777777775e-2 * t585 + t590 + 0.49999999999999999999999999999999999999999999999998e-2 * t592 * t214 * t218 * t593 + 0.16666666666666666666666666666666666666666666666666e-2 * t601 - 0.16666666666666666666666666666666666666666666666666e-2 * t293 * t214 * t218 * t574 - t612
  t619 = t305 * t229
  t624 = 0.35e2 / 0.432e3 * t580 * t85 * t226
  t625 = t584 * t311
  t635 = t613 * t229
  t639 = t314 * t194
  t640 = t639 * t322
  t643 = t315 * t349
  t645 = t639 * t353
  t649 = 0.1e1 / t319 / t241
  t650 = t649 * t244
  t652 = t318 * t650 * t248
  t653 = t339 ** 2
  t654 = t240 ** 2
  t655 = t653 * t654
  t661 = t318 * t321 * t346
  t662 = t661 * t342
  t665 = t318 * t321 * t250
  t667 = t356 * t1 * t254
  t669 = t240 * t281
  t677 = 0.17315859105681463759666483083807725165579399831905e2 * t187 * t508 * t493 * t511
  t679 = t140 * t106 * t189
  t680 = 0.11696447245269292414524477327518106963944910680856e1 * t679
  t684 = 0.58482236226346462072622386637590534819724553404280e0 * t187 * t165 * t503 * t172
  t686 = t128 * t553 * t118
  t688 = t128 * t140 * t176
  t689 = 0.2e1 * t688
  t693 = 0.11696447245269292414524477327518106963944910680856e1 * t187 * t491 * t493 * t172
  t694 = -t677 - t680 - t684 + t555 + t482 + t474 + t686 + t689 - t520 + t693 - t457
  t695 = t125 * t141
  t696 = 0.8e1 * t695
  t698 = 0.8e1 * t125 * t177
  t699 = t69 * t141
  t700 = 0.8e1 * t699
  t701 = t388 - t696 - t698 + t700 + t557 - t464 - t453 + t391 - t394 + t399 + t524 + t517
  t707 = t194 * t356
  t715 = (-(t694 + t701) * t229 * t238 + 0.6e1 * t333 * t336 - 0.12e2 * t235 * t707 * t593 + 0.3e1 * t235 * t335 * t574) * t240
  t720 = t653 * t240
  t731 = 0.119e3 / 0.13824e5 * t246 / t23 / t395 * t249 * t252 * t256
  t733 = t318 * t352 * t346
  t734 = t733 * t360
  t739 = t249 / t251 / t204 * t1
  t748 = t624 + 0.7e1 / 0.72e2 * t625 + t592 * t214 * t5 * t593 / 0.16e2 - t293 * t214 * t5 * t574 / 0.48e2 + t635 * t245 * t257 / 0.3072e4 - t640 * t342 / 0.1536e4 - 0.7e1 / 0.2304e4 * t643 - t645 * t360 / 0.384e3 + t652 * t325 * t326 * t655 / 0.1536e4 + 0.7e1 / 0.2304e4 * t662 + t665 * t667 * t6 * t339 * t669 / 0.384e3 - t323 * t325 * t326 * t715 / 0.3072e4 - t323 * t325 * t326 * t720 / 0.3072e4 + t731 + 0.7e1 / 0.576e3 * t734 + 0.5e1 / 0.768e3 * t354 * t739 * t326 * t593 - t354 * t358 * t326 * t574 / 0.768e3
  t751 = t364 * t229
  t756 = t194 / t367 / t265
  t757 = t376 ** 2
  t766 = t649 * t260
  t770 = t320 * t363
  t787 = t203 * t270
  t791 = t196 * t204
  t792 = t379 * t381
  t796 = 0.3e1 * t196 * t271 * t574 + t196 * t236 * (t613 * t260 * t267 + 0.2e1 * t304 * t363 * t267 - 0.2e1 * t619 * t377 + t222 * t748 * t267 - 0.2e1 * t751 * t377 + 0.2e1 * t366 * t756 * t757 - t366 * t369 * (t230 * t243 * t748 - 0.2e1 * t318 * t770 * t340 - t318 * t371 * t715 - t318 * t371 * t720 + 0.2e1 * t318 * t766 * t655 + t635 * t263 + 0.2e1 * t314 * t374 - 0.2e1 * t639 * t372)) * t381 - t696 - t698 + t700 + 0.6e1 * t196 * t787 * t593 + t693 - t677 - t680 - t684 - t453 + t686 + t689 + 0.6e1 * t791 * t792 * t281
  d11 = t35 + t62 + t121 - t127 + 0.2e1 * t142 + t179 + 0.39503346997227602814966679236413104097888262435310e-1 * t180 - t186 - t191 + 0.6e1 * t283 + 0.2e1 * t383 + t7 * (t558 + t796)
  t800 = -t70 - t130
  t803 = f.my_piecewise3(t73, 0, 0.4e1 / 0.3e1 * t76 * t800)
  t804 = -t800
  t807 = f.my_piecewise3(t80, 0, 0.4e1 / 0.3e1 * t81 * t804)
  t809 = (t803 + t807) * t88
  t810 = t809 * t118
  t811 = t128 * t810
  t812 = t809 * t116
  t813 = 0.19751673498613801407483339618206552048944131217655e-1 * t812
  t816 = f.my_piecewise3(t73, 0, 0.2e1 / 0.3e1 * t272 * t800)
  t819 = f.my_piecewise3(t80, 0, 0.2e1 / 0.3e1 * t276 * t804)
  t821 = t816 / 0.2e1 + t819 / 0.2e1
  t823 = t196 * t271 * t821
  t826 = t214 * t218 * t821
  t829 = -t291 - 0.16666666666666666666666666666666666666666666666666e-2 * t293 * t826 - t303
  t830 = t829 * t260
  t832 = t5 * t821
  t833 = t214 * t832
  t836 = t829 * t229
  t837 = t836 * t245
  t841 = (t159 + t160 - t327 - t328 + t811 + t178 + t813 - t330 - t331) * t229
  t843 = t335 * t821
  t846 = 0.3e1 * t235 * t843 - t841 * t238
  t847 = t846 * t240
  t849 = t325 * t326 * t847
  t853 = t358 * t326 * t821
  t856 = -t309 - t293 * t833 / 0.48e2 + t837 * t257 / 0.3072e4 - t323 * t849 / 0.3072e4 - t351 - t354 * t853 / 0.768e3
  t857 = t222 * t856
  t860 = t371 * t847
  t862 = t243 * t856
  t864 = t230 * t862 + t836 * t263 - t318 * t860
  t865 = t369 * t864
  t867 = t830 * t267 + t857 * t267 - t366 * t865
  t870 = t196 * t236 * t867 * t381
  t878 = f.my_piecewise3(t73, 0, 0.4e1 / 0.9e1 * t531 * t800 * t131 + 0.8e1 / 0.3e1 * t76 * t63 * t535)
  t886 = f.my_piecewise3(t80, 0, 0.4e1 / 0.9e1 * t543 * t804 * t135 - 0.8e1 / 0.3e1 * t81 * t63 * t535)
  t888 = (t878 + t886) * t88
  t890 = 0.19751673498613801407483339618206552048944131217655e-1 * t888 * t116
  t895 = t867 * t381
  t900 = t809 * t106 * t189
  t901 = 0.58482236226346462072622386637590534819724553404280e0 * t900
  t902 = 0.18311447306006545054854346104378990962041954983034e-3 * t519
  t904 = t809 * t1 * t184
  t905 = 0.18311447306006545054854346104378990962041954983034e-3 * t904
  t906 = t69 * t810
  t907 = 0.4e1 * t906
  t908 = -t196 * t236 * t867 * t528 * t379 + 0.3e1 * t791 * t895 * t281 + t388 - t391 + t399 - t457 - t464 + t474 + t482 + t517 + t524 + t890 - t901 - t902 - t905 + t907
  t909 = t125 * t810
  t910 = 0.4e1 * t909
  t918 = f.my_piecewise3(t73, 0, -0.2e1 / 0.9e1 * t559 * t800 * t131 + 0.4e1 / 0.3e1 * t272 * t63 * t535)
  t926 = f.my_piecewise3(t80, 0, -0.2e1 / 0.9e1 * t566 * t804 * t135 - 0.4e1 / 0.3e1 * t276 * t63 * t535)
  t928 = t918 / 0.2e1 + t926 / 0.2e1
  t933 = t584 * t826
  t944 = t598 * t4 * t300 * t821
  t951 = t583 + 0.38888888888888888888888888888888888888888888888888e-2 * t585 + t590 + 0.38888888888888888888888888888888888888888888888887e-2 * t933 + 0.49999999999999999999999999999999999999999999999998e-2 * t209 * t591 * t20 * t225 * t217 * t821 * t281 + 0.83333333333333333333333333333333333333333333333330e-3 * t944 - 0.16666666666666666666666666666666666666666666666666e-2 * t293 * t214 * t218 * t928 + 0.83333333333333333333333333333333333333333333333332e-3 * t601 - t612
  t956 = t830 * t229
  t961 = t584 * t833
  t971 = t951 * t229
  t975 = t836 * t194
  t976 = t975 * t322
  t979 = t837 * t349
  t981 = t975 * t353
  t989 = t252 * t1 * t254
  t990 = t6 * t846
  t991 = t654 * t339
  t996 = t661 * t849
  t998 = t624 + 0.7e1 / 0.144e3 * t625 + 0.7e1 / 0.144e3 * t961 + t592 * t214 * t832 * t281 / 0.16e2 - t293 * t214 * t5 * t928 / 0.48e2 + t971 * t245 * t257 / 0.3072e4 - t976 * t342 / 0.3072e4 - 0.7e1 / 0.4608e4 * t979 - t981 * t360 / 0.768e3 - t640 * t849 / 0.3072e4 + t318 * t650 * t250 * t989 * t990 * t991 / 0.1536e4 + 0.7e1 / 0.4608e4 * t996
  t1003 = t388 + t890 - t391 + t399 + t517 - t901 - t902 + t524 - t457 - t905 - t464 + t474 + t482
  t1005 = t128 * t888 * t118
  t1007 = t128 * t809 * t176
  t1008 = 0.4e1 * t695
  t1009 = 0.4e1 * t699
  t1010 = 0.58482236226346462072622386637590534819724553404280e0 * t679
  t1011 = t907 - t910 + t1005 + t1007 - t1008 - t698 - t1009 + t693 - t677 - t1010 - t684 - t453 + t688
  t1028 = (-(t1003 + t1011) * t229 * t238 + 0.3e1 * t841 * t336 + 0.3e1 * t333 * t843 - 0.12e2 * t235 * t194 * t356 * t821 * t281 + 0.3e1 * t235 * t335 * t928) * t240
  t1047 = t733 * t853
  t1058 = t665 * t667 * t990 * t669 / 0.768e3 - t323 * t325 * t326 * t1028 / 0.3072e4 - t665 * t989 * t990 * t340 / 0.3072e4 - 0.7e1 / 0.4608e4 * t643 + 0.7e1 / 0.4608e4 * t662 + t731 + 0.7e1 / 0.1152e4 * t734 - t645 * t853 / 0.768e3 + t665 * t667 * t6 * t821 * t340 / 0.768e3 + 0.7e1 / 0.1152e4 * t1047 + 0.5e1 / 0.768e3 * t354 * t739 * t326 * t821 * t281 - t354 * t358 * t326 * t928 / 0.768e3
  t1059 = t998 + t1058
  t1062 = t857 * t229
  t1076 = t260 * t846
  t1089 = t320 * t856
  t1094 = -t230 * t194 * t320 * t1076 * t340 + 0.2e1 * t230 * t194 * t649 * t1076 * t991 - t318 * t371 * t1028 + t230 * t243 * t1059 - t318 * t1089 * t340 - t318 * t770 * t847 + t971 * t263 + t314 * t862 - t975 * t372 + t836 * t374 - t639 * t860
  t1109 = -t910 + 0.3e1 * t196 * t271 * t928 + t196 * t236 * (0.2e1 * t366 * t756 * t864 * t376 + t222 * t1059 * t267 - t366 * t369 * t1094 + t951 * t260 * t267 + t304 * t856 * t267 + t829 * t363 * t267 - t1062 * t377 - t956 * t377 - t619 * t865 - t751 * t865) * t381 + t1005 + t1007 - t1008 - t698 - t1009 + 0.3e1 * t791 * t792 * t821 + 0.6e1 * t196 * t203 * t270 * t821 * t281 + t693 - t677 - t1010 - t684 - t453 + t688
  d12 = t35 + t62 - t127 + t142 + t179 + t329 - t186 - t191 + 0.3e1 * t283 + t383 + t811 + t813 + 0.3e1 * t823 + t870 + t7 * (t908 + t1109)
  t1116 = t800 ** 2
  t1120 = 0.2e1 * t129 + 0.2e1 * t536
  t1124 = f.my_piecewise3(t73, 0, 0.4e1 / 0.9e1 * t531 * t1116 + 0.4e1 / 0.3e1 * t76 * t1120)
  t1125 = t804 ** 2
  t1128 = -t1120
  t1132 = f.my_piecewise3(t80, 0, 0.4e1 / 0.9e1 * t543 * t1125 + 0.4e1 / 0.3e1 * t81 * t1128)
  t1134 = (t1124 + t1132) * t88
  t1136 = 0.19751673498613801407483339618206552048944131217655e-1 * t1134 * t116
  t1142 = f.my_piecewise3(t73, 0, -0.2e1 / 0.9e1 * t559 * t1116 + 0.2e1 / 0.3e1 * t272 * t1120)
  t1148 = f.my_piecewise3(t80, 0, -0.2e1 / 0.9e1 * t566 * t1125 + 0.2e1 / 0.3e1 * t276 * t1128)
  t1150 = t1142 / 0.2e1 + t1148 / 0.2e1
  t1155 = t821 ** 2
  t1165 = t583 + 0.77777777777777777777777777777777777777777777777775e-2 * t933 + t590 + 0.49999999999999999999999999999999999999999999999998e-2 * t592 * t214 * t218 * t1155 + 0.16666666666666666666666666666666666666666666666666e-2 * t944 - 0.16666666666666666666666666666666666666666666666666e-2 * t293 * t214 * t218 * t1150 - t612
  t1182 = t1165 * t229
  t1191 = t846 ** 2
  t1192 = t1191 * t654
  t1203 = 0.11696447245269292414524477327518106963944910680856e1 * t900
  t1204 = -t1203 + t388 - t677 + t394 - t453 - t684 + t474 + t482 - t464 + t517 + t524
  t1205 = 0.8e1 * t906
  t1206 = 0.8e1 * t909
  t1208 = t128 * t1134 * t118
  t1209 = 0.2e1 * t1007
  t1210 = 0.36622894612013090109708692208757981924083909966068e-3 * t904
  t1211 = t1136 + t399 - t1205 - t557 + t391 - t1206 - t698 + t1208 + t1209 - t457 - t1210 + t693
  t1224 = (-(t1204 + t1211) * t229 * t238 + 0.6e1 * t841 * t843 - 0.12e2 * t235 * t707 * t1155 + 0.3e1 * t235 * t335 * t1150) * t240
  t1229 = t1191 * t240
  t1243 = t624 + 0.7e1 / 0.72e2 * t961 + t592 * t214 * t5 * t1155 / 0.16e2 - t293 * t214 * t5 * t1150 / 0.48e2 + t1182 * t245 * t257 / 0.3072e4 - t976 * t849 / 0.1536e4 - 0.7e1 / 0.2304e4 * t979 - t981 * t853 / 0.384e3 + t652 * t325 * t326 * t1192 / 0.1536e4 + 0.7e1 / 0.2304e4 * t996 + t665 * t667 * t990 * t240 * t821 / 0.384e3 - t323 * t325 * t326 * t1224 / 0.3072e4 - t323 * t325 * t326 * t1229 / 0.3072e4 + t731 + 0.7e1 / 0.576e3 * t1047 + 0.5e1 / 0.768e3 * t354 * t739 * t326 * t1155 - t354 * t358 * t326 * t1150 / 0.768e3
  t1248 = t864 ** 2
  t1276 = t867 ** 2
  t1283 = t388 + t1136 + 0.3e1 * t196 * t271 * t1150 + t196 * t236 * (t1165 * t260 * t267 + 0.2e1 * t829 * t856 * t267 - 0.2e1 * t956 * t865 + t222 * t1243 * t267 - 0.2e1 * t1062 * t865 + 0.2e1 * t366 * t756 * t1248 - t366 * t369 * (-0.2e1 * t318 * t1089 * t847 + 0.2e1 * t318 * t766 * t1192 - t318 * t371 * t1224 - t318 * t371 * t1229 + t230 * t243 * t1243 + t1182 * t263 + 0.2e1 * t836 * t862 - 0.2e1 * t975 * t860)) * t381 - t196 * t236 * t1276 * t528 + t391 + t394 + t399 + t517 + 0.6e1 * t791 * t895 * t821 - t1203 + t524 - t457 - t1210
  t1287 = 0.6e1 * t196 * t787 * t1155 - t1205 - t1206 + t1208 + t1209 - t453 - t464 + t474 + t482 - t557 - t677 - t684 + t693 - t698
  d22 = t35 + t62 - t121 - t127 + 0.2e1 * t811 + t179 + 0.39503346997227602814966679236413104097888262435310e-1 * t812 - t186 - t191 + 0.6e1 * t823 + 0.2e1 * t870 + t7 * (t1283 + t1287)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t14 = t4 * t6 / t8
  t15 = jnp.sqrt(t14)
  t18 = t14 ** 0.15e1
  t20 = t1 ** 2
  t21 = t3 ** 2
  t22 = t20 * t21
  t23 = t8 ** 2
  t26 = t22 * t5 / t23
  t28 = 0.37978500000000000000000000000000000000000000000000e1 * t15 + 0.89690000000000000000000000000000000000000000000000e0 * t14 + 0.20477500000000000000000000000000000000000000000000e0 * t18 + 0.12323500000000000000000000000000000000000000000000e0 * t26
  t31 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t28
  t32 = jnp.log(t31)
  t34 = t4 * t11 * t32
  t35 = 0.22146941966666666666666666666666666666666666666666e-2 * t34
  t37 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t14
  t38 = t28 ** 2
  t39 = 0.1e1 / t38
  t40 = t37 * t39
  t42 = 0.1e1 / t15 * t1
  t43 = t3 * t6
  t44 = t43 * t10
  t45 = t42 * t44
  t47 = t4 * t11
  t49 = t14 ** 0.5e0
  t50 = t49 * t1
  t51 = t50 * t44
  t56 = t22 * t5 / t23 / t7
  t58 = -0.63297500000000000000000000000000000000000000000000e0 * t45 - 0.29896666666666666666666666666666666666666666666667e0 * t47 - 0.10238750000000000000000000000000000000000000000000e0 * t51 - 0.82156666666666666666666666666666666666666666666667e-1 * t56
  t59 = 0.1e1 / t31
  t60 = t58 * t59
  t61 = t40 * t60
  t62 = 0.20000000000000000000000000000000000000000000000000e1 * t61
  t63 = r0 - r1
  t64 = t63 ** 2
  t65 = t64 * t63
  t66 = t7 ** 2
  t67 = t66 ** 2
  t68 = 0.1e1 / t67
  t69 = t65 * t68
  t70 = 0.1e1 / t7
  t71 = t63 * t70
  t72 = 0.1e1 + t71
  t73 = t72 <= f.p.zeta_threshold
  t74 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t75 = t74 * f.p.zeta_threshold
  t76 = t72 ** (0.1e1 / 0.3e1)
  t77 = t76 * t72
  t78 = f.my_piecewise3(t73, t75, t77)
  t79 = 0.1e1 - t71
  t80 = t79 <= f.p.zeta_threshold
  t81 = t79 ** (0.1e1 / 0.3e1)
  t82 = t81 * t79
  t83 = f.my_piecewise3(t80, t75, t82)
  t85 = 2 ** (0.1e1 / 0.3e1)
  t88 = 0.1e1 / (0.2e1 * t85 - 0.2e1)
  t89 = (t78 + t83 - 0.2e1) * t88
  t91 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t14
  t96 = 0.70594500000000000000000000000000000000000000000000e1 * t15 + 0.15494250000000000000000000000000000000000000000000e1 * t14 + 0.42077500000000000000000000000000000000000000000000e0 * t18 + 0.15629250000000000000000000000000000000000000000000e0 * t26
  t99 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t96
  t100 = jnp.log(t99)
  t104 = 0.621814e-1 * t37 * t32
  t106 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t14
  t111 = 0.51785000000000000000000000000000000000000000000000e1 * t15 + 0.90577500000000000000000000000000000000000000000000e0 * t14 + 0.11003250000000000000000000000000000000000000000000e0 * t18 + 0.12417750000000000000000000000000000000000000000000e0 * t26
  t114 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t111
  t115 = jnp.log(t114)
  t116 = t106 * t115
  t118 = -0.3109070e-1 * t91 * t100 + t104 - 0.19751673498613801407483339618206552048944131217655e-1 * t116
  t119 = t89 * t118
  t120 = t69 * t119
  t121 = 0.8e1 * t120
  t122 = t64 ** 2
  t123 = t67 * t7
  t124 = 0.1e1 / t123
  t125 = t122 * t124
  t126 = t125 * t119
  t127 = 0.8e1 * t126
  t128 = t122 * t68
  t129 = 0.1e1 / t66
  t130 = t63 * t129
  t131 = t70 - t130
  t134 = f.my_piecewise3(t73, 0, 0.4e1 / 0.3e1 * t76 * t131)
  t135 = -t131
  t138 = f.my_piecewise3(t80, 0, 0.4e1 / 0.3e1 * t81 * t135)
  t140 = (t134 + t138) * t88
  t141 = t140 * t118
  t142 = t128 * t141
  t147 = t96 ** 2
  t148 = 0.1e1 / t147
  t149 = t91 * t148
  t154 = -0.11765750000000000000000000000000000000000000000000e1 * t45 - 0.51647500000000000000000000000000000000000000000000e0 * t47 - 0.21038750000000000000000000000000000000000000000000e0 * t51 - 0.10419500000000000000000000000000000000000000000000e0 * t56
  t155 = 0.1e1 / t99
  t156 = t154 * t155
  t159 = 0.11073470983333333333333333333333333333333333333333e-2 * t34
  t160 = 0.10000000000000000000000000000000000000000000000000e1 * t61
  t164 = t111 ** 2
  t165 = 0.1e1 / t164
  t166 = t106 * t165
  t171 = -0.86308333333333333333333333333333333333333333333334e0 * t45 - 0.30192500000000000000000000000000000000000000000000e0 * t47 - 0.55016250000000000000000000000000000000000000000000e-1 * t51 - 0.82785000000000000000000000000000000000000000000000e-1 * t56
  t172 = 0.1e1 / t114
  t173 = t171 * t172
  t176 = 0.53237641966666666666666666666666666666666666666666e-3 * t4 * t11 * t100 + 0.10000000000000000000000000000000000000000000000000e1 * t149 * t156 - t159 - t160 + 0.18311447306006545054854346104378990962041954983034e-3 * t4 * t11 * t115 + 0.58482236226346462072622386637590534819724553404280e0 * t166 * t173
  t177 = t89 * t176
  t178 = t128 * t177
  t179 = 0.2e1 * t178
  t180 = t140 * t116
  t182 = t89 * t1
  t184 = t43 * t10 * t115
  t185 = t182 * t184
  t186 = 0.36622894612013090109708692208757981924083909966068e-3 * t185
  t187 = t89 * t106
  t189 = t165 * t171 * t172
  t190 = t187 * t189
  t191 = 0.11696447245269292414524477327518106963944910680856e1 * t190
  t192 = jnp.log(0.2e1)
  t193 = 0.1e1 - t192
  t194 = jnp.pi ** 2
  t196 = t193 / t194
  t197 = t74 ** 2
  t198 = t76 ** 2
  t199 = f.my_piecewise3(t73, t197, t198)
  t200 = t81 ** 2
  t201 = f.my_piecewise3(t80, t197, t200)
  t203 = t199 / 0.2e1 + t201 / 0.2e1
  t204 = t203 ** 2
  t206 = s0 + 0.2e1 * s1 + s2
  t208 = 0.1e1 / t8 / t66
  t209 = t206 * t208
  t210 = 0.1e1 / t204
  t211 = t85 * t210
  t213 = 0.1e1 / t3
  t214 = t20 * t213
  t216 = jnp.exp(-t26 / 0.4e1)
  t217 = 0.1e1 - t216
  t218 = t5 * t217
  t219 = t214 * t218
  t222 = 0.375e-1 + 0.83333333333333333333333333333333333333333333333332e-3 * t209 * t211 * t219
  t225 = t213 * t5
  t226 = t210 * t20 * t225
  t229 = 0.1e1 / t193
  t230 = t222 * t229
  t235 = (-t104 + t128 * t119 + 0.19751673498613801407483339618206552048944131217655e-1 * t89 * t116) * t229
  t236 = t204 * t203
  t237 = 0.1e1 / t236
  t238 = t194 * t237
  t240 = jnp.exp(-t235 * t238)
  t241 = t240 - 0.1e1
  t242 = 0.1e1 / t241
  t243 = t194 * t242
  t244 = t206 ** 2
  t245 = t243 * t244
  t246 = t230 * t245
  t248 = 0.1e1 / t23 / t67
  t249 = t85 ** 2
  t250 = t248 * t249
  t251 = t204 ** 2
  t252 = 0.1e1 / t251
  t254 = 0.1e1 / t21
  t256 = t1 * t254 * t6
  t257 = t250 * t252 * t256
  t260 = t209 * t85 * t226 / 0.96e2 + t246 * t257 / 0.3072e4
  t261 = t222 * t260
  t263 = t243 * t260
  t265 = t230 * t263 + 0.1e1
  t267 = t229 * t194 / t265
  t269 = t261 * t267 + 0.1e1
  t270 = jnp.log(t269)
  t271 = t204 * t270
  t272 = 0.1e1 / t76
  t275 = f.my_piecewise3(t73, 0, 0.2e1 / 0.3e1 * t272 * t131)
  t276 = 0.1e1 / t81
  t279 = f.my_piecewise3(t80, 0, 0.2e1 / 0.3e1 * t276 * t135)
  t281 = t275 / 0.2e1 + t279 / 0.2e1
  t283 = t196 * t271 * t281
  t285 = t66 * t7
  t288 = t206 / t8 / t285
  t291 = 0.19444444444444444444444444444444444444444444444444e-2 * t288 * t211 * t219
  t292 = t85 * t237
  t293 = t209 * t292
  t295 = t214 * t218 * t281
  t298 = t206 * t68
  t300 = t6 * t216
  t301 = t4 * t300
  t303 = 0.41666666666666666666666666666666666666666666666666e-3 * t298 * t211 * t301
  t304 = -t291 - 0.16666666666666666666666666666666666666666666666666e-2 * t293 * t295 - t303
  t305 = t304 * t260
  t309 = 0.7e1 / 0.288e3 * t288 * t85 * t226
  t311 = t214 * t5 * t281
  t314 = t304 * t229
  t315 = t314 * t245
  t318 = t230 * t194
  t319 = t241 ** 2
  t320 = 0.1e1 / t319
  t321 = t320 * t244
  t322 = t321 * t248
  t323 = t318 * t322
  t325 = t249 * t252 * t1
  t326 = t254 * t6
  t327 = 0.4e1 * t120
  t328 = 0.4e1 * t126
  t329 = 0.19751673498613801407483339618206552048944131217655e-1 * t180
  t330 = 0.18311447306006545054854346104378990962041954983034e-3 * t185
  t331 = 0.58482236226346462072622386637590534819724553404280e0 * t190
  t333 = (t159 + t160 + t327 - t328 + t142 + t178 + t329 - t330 - t331) * t229
  t335 = t194 * t252
  t336 = t335 * t281
  t339 = 0.3e1 * t235 * t336 - t333 * t238
  t340 = t339 * t240
  t342 = t325 * t326 * t340
  t346 = 0.1e1 / t23 / t123
  t349 = t346 * t249 * t252 * t256
  t351 = 0.7e1 / 0.4608e4 * t246 * t349
  t352 = t242 * t244
  t353 = t352 * t248
  t354 = t318 * t353
  t356 = 0.1e1 / t251 / t203
  t358 = t249 * t356 * t1
  t360 = t358 * t326 * t281
  t363 = -t309 - t293 * t311 / 0.48e2 + t315 * t257 / 0.3072e4 - t323 * t342 / 0.3072e4 - t351 - t354 * t360 / 0.768e3
  t364 = t222 * t363
  t366 = t261 * t229
  t367 = t265 ** 2
  t369 = t194 / t367
  t371 = t320 * t260
  t372 = t371 * t340
  t374 = t243 * t363
  t376 = t230 * t374 + t314 * t263 - t318 * t372
  t377 = t369 * t376
  t379 = t305 * t267 + t364 * t267 - t366 * t377
  t381 = 0.1e1 / t269
  t383 = t196 * t236 * t379 * t381
  t387 = t206 / t8 / t67
  t390 = 0.64814814814814814814814814814814814814814814814813e-2 * t387 * t211 * t219
  t391 = t288 * t292
  t392 = t391 * t295
  t397 = 0.26388888888888888888888888888888888888888888888888e-2 * t206 * t124 * t211 * t301
  t398 = t85 * t252
  t399 = t209 * t398
  t400 = t281 ** 2
  t405 = t298 * t292
  t408 = t405 * t4 * t300 * t281
  t410 = 0.1e1 / t77
  t411 = t131 ** 2
  t414 = 0.1e1 / t285
  t415 = t63 * t414
  t417 = -0.2e1 * t129 + 0.2e1 * t415
  t421 = f.my_piecewise3(t73, 0, -0.2e1 / 0.9e1 * t410 * t411 + 0.2e1 / 0.3e1 * t272 * t417)
  t422 = 0.1e1 / t82
  t423 = t135 ** 2
  t426 = -t417
  t430 = f.my_piecewise3(t80, 0, -0.2e1 / 0.9e1 * t422 * t423 + 0.2e1 / 0.3e1 * t276 * t426)
  t432 = t421 / 0.2e1 + t430 / 0.2e1
  t442 = 0.83333333333333333333333333333333333333333333333332e-3 * t206 * t346 * t85 * t210 * t2 * t216
  t443 = t390 + 0.77777777777777777777777777777777777777777777777775e-2 * t392 + t397 + 0.49999999999999999999999999999999999999999999999998e-2 * t399 * t214 * t218 * t400 + 0.16666666666666666666666666666666666666666666666666e-2 * t408 - 0.16666666666666666666666666666666666666666666666666e-2 * t293 * t214 * t218 * t432 - t442
  t449 = t305 * t229
  t454 = 0.35e2 / 0.432e3 * t387 * t85 * t226
  t455 = t391 * t311
  t465 = t443 * t229
  t469 = t314 * t194
  t470 = t469 * t322
  t473 = t315 * t349
  t475 = t469 * t353
  t479 = 0.1e1 / t319 / t241
  t480 = t479 * t244
  t482 = t318 * t480 * t248
  t483 = t339 ** 2
  t484 = t240 ** 2
  t485 = t483 * t484
  t491 = t318 * t321 * t346
  t492 = t491 * t342
  t495 = t318 * t321 * t250
  t497 = t356 * t1 * t254
  t499 = t240 * t281
  t504 = t6 * t208
  t508 = t4 * t6
  t516 = t154 ** 2
  t525 = 0.1e1 / t23 / t66
  t526 = t21 * t5 * t525
  t527 = 0.1e1 / t15 / t14 * t20 * t526
  t529 = t43 * t208
  t530 = t42 * t529
  t532 = t4 * t504
  t534 = t14 ** (-0.5e0)
  t536 = t534 * t20 * t526
  t538 = t50 * t529
  t541 = t22 * t5 * t525
  t547 = t147 ** 2
  t550 = t99 ** 2
  t557 = 0.14764627977777777777777777777777777777777777777777e-2 * t4 * t504 * t32
  t561 = 0.35616666666666666666666666666666666666666666666666e-1 * t508 * t10 * t39 * t60
  t565 = t58 ** 2
  t568 = 0.20000000000000000000000000000000000000000000000000e1 * t37 / t38 / t28 * t565 * t59
  t578 = 0.10000000000000000000000000000000000000000000000000e1 * t40 * (-0.42198333333333333333333333333333333333333333333333e0 * t527 + 0.84396666666666666666666666666666666666666666666666e0 * t530 + 0.39862222222222222222222222222222222222222222222223e0 * t532 + 0.68258333333333333333333333333333333333333333333333e-1 * t536 + 0.13651666666666666666666666666666666666666666666667e0 * t538 + 0.13692777777777777777777777777777777777777777777778e0 * t541) * t59
  t579 = t38 ** 2
  t582 = t31 ** 2
  t586 = 0.16081979498692535066756296899072713062105388428051e2 * t37 / t579 * t565 / t582
  t595 = 0.1e1 / t164 / t111
  t597 = t171 ** 2
  t607 = -0.57538888888888888888888888888888888888888888888889e0 * t527 + 0.11507777777777777777777777777777777777777777777778e1 * t530 + 0.40256666666666666666666666666666666666666666666667e0 * t532 + 0.36677500000000000000000000000000000000000000000000e-1 * t536 + 0.73355000000000000000000000000000000000000000000000e-1 * t538 + 0.13797500000000000000000000000000000000000000000000e0 * t541
  t611 = t164 ** 2
  t612 = 0.1e1 / t611
  t614 = t114 ** 2
  t615 = 0.1e1 / t614
  t619 = -0.70983522622222222222222222222222222222222222222221e-3 * t4 * t504 * t100 - 0.34246666666666666666666666666666666666666666666666e-1 * t508 * t10 * t148 * t156 - 0.20000000000000000000000000000000000000000000000000e1 * t91 / t147 / t96 * t516 * t155 + 0.10000000000000000000000000000000000000000000000000e1 * t149 * (-0.78438333333333333333333333333333333333333333333333e0 * t527 + 0.15687666666666666666666666666666666666666666666667e1 * t530 + 0.68863333333333333333333333333333333333333333333333e0 * t532 + 0.14025833333333333333333333333333333333333333333333e0 * t536 + 0.28051666666666666666666666666666666666666666666667e0 * t538 + 0.17365833333333333333333333333333333333333333333333e0 * t541) * t155 + 0.32163958997385070133512593798145426124210776856102e2 * t91 / t547 * t516 / t550 + t557 + t561 + t568 - t578 - t586 - 0.24415263074675393406472461472505321282722606644045e-3 * t4 * t504 * t115 - 0.10843581300301739842632067522386578331157260943710e-1 * t508 * t10 * t165 * t173 - 0.11696447245269292414524477327518106963944910680856e1 * t106 * t595 * t597 * t172 + 0.58482236226346462072622386637590534819724553404280e0 * t166 * t607 * t172 + 0.17315859105681463759666483083807725165579399831905e2 * t106 * t612 * t597 * t615
  t621 = t128 * t89 * t619
  t625 = 0.17315859105681463759666483083807725165579399831905e2 * t187 * t612 * t597 * t615
  t627 = t140 * t106 * t189
  t628 = 0.11696447245269292414524477327518106963944910680856e1 * t627
  t632 = 0.58482236226346462072622386637590534819724553404280e0 * t187 * t165 * t607 * t172
  t633 = 0.1e1 / t198
  t639 = f.my_piecewise3(t73, 0, 0.4e1 / 0.9e1 * t633 * t411 + 0.4e1 / 0.3e1 * t76 * t417)
  t640 = 0.1e1 / t200
  t646 = f.my_piecewise3(t80, 0, 0.4e1 / 0.9e1 * t640 * t423 + 0.4e1 / 0.3e1 * t81 * t426)
  t648 = (t639 + t646) * t88
  t650 = 0.19751673498613801407483339618206552048944131217655e-1 * t648 * t116
  t652 = t128 * t648 * t118
  t654 = t128 * t140 * t176
  t655 = 0.2e1 * t654
  t657 = t140 * t1 * t184
  t658 = 0.36622894612013090109708692208757981924083909966068e-3 * t657
  t662 = 0.11696447245269292414524477327518106963944910680856e1 * t187 * t595 * t597 * t172
  t663 = t621 - t625 - t628 - t632 + t650 + t586 + t578 + t652 + t655 - t658 + t662
  t667 = 0.10843581300301739842632067522386578331157260943710e-1 * t89 * t4 * t11 * t189
  t668 = t125 * t141
  t669 = 0.8e1 * t668
  t671 = 0.8e1 * t125 * t177
  t672 = t69 * t141
  t673 = 0.8e1 * t672
  t675 = 0.8e1 * t69 * t177
  t678 = 0.12e2 * t64 * t68 * t119
  t681 = 0.32e2 * t65 * t124 * t119
  t682 = t67 * t66
  t686 = 0.20e2 * t122 / t682 * t119
  t690 = 0.24415263074675393406472461472505321282722606644045e-3 * t182 * t43 * t208 * t115
  t691 = -t561 + t667 - t669 - t671 + t673 + t675 - t568 - t557 + t678 - t681 + t686 + t690
  t697 = t194 * t356
  t705 = (-(t663 + t691) * t229 * t238 + 0.6e1 * t333 * t336 - 0.12e2 * t235 * t697 * t400 + 0.3e1 * t235 * t335 * t432) * t240
  t710 = t483 * t240
  t721 = 0.119e3 / 0.13824e5 * t246 / t23 / t682 * t249 * t252 * t256
  t723 = t318 * t352 * t346
  t724 = t723 * t360
  t729 = t249 / t251 / t204 * t1
  t738 = t454 + 0.7e1 / 0.72e2 * t455 + t399 * t214 * t5 * t400 / 0.16e2 - t293 * t214 * t5 * t432 / 0.48e2 + t465 * t245 * t257 / 0.3072e4 - t470 * t342 / 0.1536e4 - 0.7e1 / 0.2304e4 * t473 - t475 * t360 / 0.384e3 + t482 * t325 * t326 * t485 / 0.1536e4 + 0.7e1 / 0.2304e4 * t492 + t495 * t497 * t6 * t339 * t499 / 0.384e3 - t323 * t325 * t326 * t705 / 0.3072e4 - t323 * t325 * t326 * t710 / 0.3072e4 + t721 + 0.7e1 / 0.576e3 * t724 + 0.5e1 / 0.768e3 * t354 * t729 * t326 * t400 - t354 * t358 * t326 * t432 / 0.768e3
  t741 = t364 * t229
  t746 = t194 / t367 / t265
  t747 = t376 ** 2
  t756 = t479 * t260
  t760 = t320 * t363
  t777 = t379 ** 2
  t779 = t269 ** 2
  t780 = 0.1e1 / t779
  t783 = t196 * t236 * (t443 * t260 * t267 + 0.2e1 * t304 * t363 * t267 - 0.2e1 * t449 * t377 + t222 * t738 * t267 - 0.2e1 * t741 * t377 + 0.2e1 * t366 * t746 * t747 - t366 * t369 * (t230 * t243 * t738 - 0.2e1 * t318 * t760 * t340 - t318 * t371 * t705 - t318 * t371 * t710 + 0.2e1 * t318 * t756 * t485 + t465 * t263 + 0.2e1 * t314 * t374 - 0.2e1 * t469 * t372)) * t381 + t667 - t196 * t236 * t777 * t780 - t625 - t628 - t632 + t662 - t658 + t690 - t561 + t650 + t586 - t557 + t655
  t787 = t203 * t270
  t791 = t196 * t204
  t792 = t379 * t381
  t796 = 0.3e1 * t196 * t271 * t432 + 0.6e1 * t196 * t787 * t400 + 0.6e1 * t791 * t792 * t281 - t568 + t578 + t621 + t652 - t669 - t671 + t673 + t675 + t678 - t681 + t686
  d11 = t35 + t62 + t121 - t127 + 0.2e1 * t142 + t179 + 0.39503346997227602814966679236413104097888262435310e-1 * t180 - t186 - t191 + 0.6e1 * t283 + 0.2e1 * t383 + t7 * (t783 + t796)
  t800 = -t70 - t130
  t803 = f.my_piecewise3(t73, 0, 0.4e1 / 0.3e1 * t76 * t800)
  t804 = -t800
  t807 = f.my_piecewise3(t80, 0, 0.4e1 / 0.3e1 * t81 * t804)
  t809 = (t803 + t807) * t88
  t810 = t809 * t118
  t811 = t128 * t810
  t812 = t809 * t116
  t813 = 0.19751673498613801407483339618206552048944131217655e-1 * t812
  t816 = f.my_piecewise3(t73, 0, 0.2e1 / 0.3e1 * t272 * t800)
  t819 = f.my_piecewise3(t80, 0, 0.2e1 / 0.3e1 * t276 * t804)
  t821 = t816 / 0.2e1 + t819 / 0.2e1
  t823 = t196 * t271 * t821
  t826 = t214 * t218 * t821
  t829 = -t291 - 0.16666666666666666666666666666666666666666666666666e-2 * t293 * t826 - t303
  t830 = t829 * t260
  t832 = t5 * t821
  t833 = t214 * t832
  t836 = t829 * t229
  t837 = t836 * t245
  t841 = (t159 + t160 - t327 - t328 + t811 + t178 + t813 - t330 - t331) * t229
  t843 = t335 * t821
  t846 = 0.3e1 * t235 * t843 - t841 * t238
  t847 = t846 * t240
  t849 = t325 * t326 * t847
  t853 = t358 * t326 * t821
  t856 = -t309 - t293 * t833 / 0.48e2 + t837 * t257 / 0.3072e4 - t323 * t849 / 0.3072e4 - t351 - t354 * t853 / 0.768e3
  t857 = t222 * t856
  t860 = t371 * t847
  t862 = t243 * t856
  t864 = t230 * t862 + t836 * t263 - t318 * t860
  t865 = t369 * t864
  t867 = t830 * t267 + t857 * t267 - t366 * t865
  t870 = t196 * t236 * t867 * t381
  t872 = t809 * t106 * t189
  t873 = 0.58482236226346462072622386637590534819724553404280e0 * t872
  t879 = t867 * t381
  t890 = 0.58482236226346462072622386637590534819724553404280e0 * t627
  t891 = 0.18311447306006545054854346104378990962041954983034e-3 * t657
  t893 = t809 * t1 * t184
  t894 = 0.18311447306006545054854346104378990962041954983034e-3 * t893
  t895 = t69 * t810
  t896 = 0.4e1 * t895
  t897 = 0.6e1 * t196 * t203 * t270 * t821 * t281 - t196 * t236 * t867 * t780 * t379 + 0.3e1 * t791 * t879 * t281 + 0.3e1 * t791 * t792 * t821 - t561 + t586 - t625 - t632 + t662 + t667 + t690 - t873 - t890 - t891 - t894 + t896
  t898 = t125 * t810
  t899 = 0.4e1 * t898
  t907 = f.my_piecewise3(t73, 0, 0.4e1 / 0.9e1 * t633 * t800 * t131 + 0.8e1 / 0.3e1 * t76 * t63 * t414)
  t915 = f.my_piecewise3(t80, 0, 0.4e1 / 0.9e1 * t640 * t804 * t135 - 0.8e1 / 0.3e1 * t81 * t63 * t414)
  t917 = (t907 + t915) * t88
  t919 = t128 * t917 * t118
  t921 = t128 * t809 * t176
  t929 = f.my_piecewise3(t73, 0, -0.2e1 / 0.9e1 * t410 * t800 * t131 + 0.4e1 / 0.3e1 * t272 * t63 * t414)
  t937 = f.my_piecewise3(t80, 0, -0.2e1 / 0.9e1 * t422 * t804 * t135 - 0.4e1 / 0.3e1 * t276 * t63 * t414)
  t939 = t929 / 0.2e1 + t937 / 0.2e1
  t944 = t391 * t826
  t955 = t405 * t4 * t300 * t821
  t962 = t390 + 0.38888888888888888888888888888888888888888888888888e-2 * t392 + t397 + 0.38888888888888888888888888888888888888888888888887e-2 * t944 + 0.49999999999999999999999999999999999999999999999998e-2 * t209 * t398 * t20 * t225 * t217 * t821 * t281 + 0.83333333333333333333333333333333333333333333333330e-3 * t955 - 0.16666666666666666666666666666666666666666666666666e-2 * t293 * t214 * t218 * t939 + 0.83333333333333333333333333333333333333333333333332e-3 * t408 - t442
  t967 = t830 * t229
  t972 = t391 * t833
  t982 = t962 * t229
  t986 = t836 * t194
  t987 = t986 * t322
  t990 = t837 * t349
  t992 = t986 * t353
  t1000 = t252 * t1 * t254
  t1001 = t6 * t846
  t1002 = t484 * t339
  t1007 = t491 * t849
  t1009 = t454 + 0.7e1 / 0.144e3 * t455 + 0.7e1 / 0.144e3 * t972 + t399 * t214 * t832 * t281 / 0.16e2 - t293 * t214 * t5 * t939 / 0.48e2 + t982 * t245 * t257 / 0.3072e4 - t987 * t342 / 0.3072e4 - 0.7e1 / 0.4608e4 * t990 - t992 * t360 / 0.768e3 - t470 * t849 / 0.3072e4 + t318 * t480 * t250 * t1000 * t1001 * t1002 / 0.1536e4 + 0.7e1 / 0.4608e4 * t1007
  t1014 = -t873 + t667 - t625 - t890 - t632 + t662 - t891 + t690 - t561 - t894 + t586 + t896 - t899
  t1015 = 0.4e1 * t668
  t1016 = 0.4e1 * t672
  t1018 = 0.19751673498613801407483339618206552048944131217655e-1 * t917 * t116
  t1019 = t919 + t921 - t557 + t654 + t621 - t678 + t686 - t1015 - t671 - t1016 - t568 + t578 + t1018
  t1036 = (-(t1014 + t1019) * t229 * t238 + 0.3e1 * t841 * t336 + 0.3e1 * t333 * t843 - 0.12e2 * t235 * t194 * t356 * t821 * t281 + 0.3e1 * t235 * t335 * t939) * t240
  t1055 = t723 * t853
  t1066 = t495 * t497 * t1001 * t499 / 0.768e3 - t323 * t325 * t326 * t1036 / 0.3072e4 - t495 * t1000 * t1001 * t340 / 0.3072e4 - 0.7e1 / 0.4608e4 * t473 + 0.7e1 / 0.4608e4 * t492 + t721 + 0.7e1 / 0.1152e4 * t724 - t475 * t853 / 0.768e3 + t495 * t497 * t6 * t821 * t340 / 0.768e3 + 0.7e1 / 0.1152e4 * t1055 + 0.5e1 / 0.768e3 * t354 * t729 * t326 * t821 * t281 - t354 * t358 * t326 * t939 / 0.768e3
  t1067 = t1009 + t1066
  t1070 = t857 * t229
  t1084 = t260 * t846
  t1097 = t320 * t856
  t1102 = 0.2e1 * t230 * t194 * t479 * t1084 * t1002 - t230 * t194 * t320 * t1084 * t340 - t318 * t371 * t1036 + t230 * t243 * t1067 - t318 * t1097 * t340 - t318 * t760 * t847 + t982 * t263 + t314 * t862 - t986 * t372 + t836 * t374 - t469 * t860
  t1109 = -t899 + t919 + t921 - t557 + t654 + t621 - t678 + t686 + 0.3e1 * t196 * t271 * t939 + t196 * t236 * (0.2e1 * t366 * t746 * t864 * t376 + t222 * t1067 * t267 - t366 * t369 * t1102 + t962 * t260 * t267 + t304 * t856 * t267 + t829 * t363 * t267 - t1070 * t377 - t967 * t377 - t449 * t865 - t741 * t865) * t381 - t1015 - t671 - t1016 - t568 + t578 + t1018
  d12 = t35 + t62 - t127 + t142 + t179 + t329 - t186 - t191 + 0.3e1 * t283 + t383 + t811 + t813 + 0.3e1 * t823 + t870 + t7 * (t897 + t1109)
  t1116 = 0.11696447245269292414524477327518106963944910680856e1 * t872
  t1117 = t821 ** 2
  t1124 = t800 ** 2
  t1128 = 0.2e1 * t129 + 0.2e1 * t415
  t1132 = f.my_piecewise3(t73, 0, 0.4e1 / 0.9e1 * t633 * t1124 + 0.4e1 / 0.3e1 * t76 * t1128)
  t1133 = t804 ** 2
  t1136 = -t1128
  t1140 = f.my_piecewise3(t80, 0, 0.4e1 / 0.9e1 * t640 * t1133 + 0.4e1 / 0.3e1 * t81 * t1136)
  t1142 = (t1132 + t1140) * t88
  t1144 = t128 * t1142 * t118
  t1150 = f.my_piecewise3(t73, 0, -0.2e1 / 0.9e1 * t410 * t1124 + 0.2e1 / 0.3e1 * t272 * t1128)
  t1156 = f.my_piecewise3(t80, 0, -0.2e1 / 0.9e1 * t422 * t1133 + 0.2e1 / 0.3e1 * t276 * t1136)
  t1158 = t1150 / 0.2e1 + t1156 / 0.2e1
  t1172 = t390 + 0.77777777777777777777777777777777777777777777777775e-2 * t944 + t397 + 0.49999999999999999999999999999999999999999999999998e-2 * t399 * t214 * t218 * t1117 + 0.16666666666666666666666666666666666666666666666666e-2 * t955 - 0.16666666666666666666666666666666666666666666666666e-2 * t293 * t214 * t218 * t1158 - t442
  t1189 = t1172 * t229
  t1198 = t846 ** 2
  t1199 = t1198 * t484
  t1210 = 0.36622894612013090109708692208757981924083909966068e-3 * t893
  t1211 = -t568 + t690 - t1210 + t662 - t561 - t625 - t632 - t1116 + t667 + t686 + t681
  t1213 = 0.19751673498613801407483339618206552048944131217655e-1 * t1142 * t116
  t1214 = 0.2e1 * t921
  t1215 = 0.8e1 * t898
  t1216 = 0.8e1 * t895
  t1217 = -t557 + t621 + t586 + t578 + t1213 + t1144 + t1214 + t678 - t1215 - t671 - t1216 - t675
  t1230 = (-(t1211 + t1217) * t229 * t238 + 0.6e1 * t841 * t843 - 0.12e2 * t235 * t697 * t1117 + 0.3e1 * t235 * t335 * t1158) * t240
  t1235 = t1198 * t240
  t1249 = t454 + 0.7e1 / 0.72e2 * t972 + t399 * t214 * t5 * t1117 / 0.16e2 - t293 * t214 * t5 * t1158 / 0.48e2 + t1189 * t245 * t257 / 0.3072e4 - t987 * t849 / 0.1536e4 - 0.7e1 / 0.2304e4 * t990 - t992 * t853 / 0.384e3 + t482 * t325 * t326 * t1199 / 0.1536e4 + 0.7e1 / 0.2304e4 * t1007 + t495 * t497 * t1001 * t240 * t821 / 0.384e3 - t323 * t325 * t326 * t1230 / 0.3072e4 - t323 * t325 * t326 * t1235 / 0.3072e4 + t721 + 0.7e1 / 0.576e3 * t1055 + 0.5e1 / 0.768e3 * t354 * t729 * t326 * t1117 - t354 * t358 * t326 * t1158 / 0.768e3
  t1254 = t864 ** 2
  t1282 = -t1116 + t667 + 0.6e1 * t196 * t787 * t1117 + 0.6e1 * t791 * t879 * t821 - t625 - t632 + t662 + t1144 + 0.3e1 * t196 * t271 * t1158 + t196 * t236 * (t1172 * t260 * t267 + 0.2e1 * t829 * t856 * t267 - 0.2e1 * t967 * t865 + t222 * t1249 * t267 - 0.2e1 * t1070 * t865 + 0.2e1 * t366 * t746 * t1254 - t366 * t369 * (-0.2e1 * t318 * t1097 * t847 + 0.2e1 * t318 * t756 * t1199 - t318 * t371 * t1230 - t318 * t371 * t1235 + t230 * t243 * t1249 + t1189 * t263 + 0.2e1 * t836 * t862 - 0.2e1 * t986 * t860)) * t381 + t690 - t561 - t1210 + t1213
  t1283 = t867 ** 2
  t1287 = -t196 * t236 * t1283 * t780 + t1214 - t1215 - t1216 - t557 - t568 + t578 + t586 + t621 - t671 - t675 + t678 + t681 + t686
  d22 = t35 + t62 - t121 - t127 + 0.2e1 * t811 + t179 + 0.39503346997227602814966679236413104097888262435310e-1 * t812 - t186 - t191 + 0.6e1 * t823 + 0.2e1 * t870 + t7 * (t1282 + t1287)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

