"""Generated from gga_x_sfat_pbe.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_kappa = 0.804

  params_mu = 0.2195149727645171

  att_yuk_aux1 = lambda a: jnp.arctan2(1, a)

  att_yuk_aux2 = lambda a: jnp.log(1 + 1 / a ** 2)

  att_yuk_aux3 = lambda a: a ** 2 + 1

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  attenuation_yukawa0 = lambda a: 1 - 8 / 3 * a * (att_yuk_aux1(a) + a / 4 * (1 - (att_yuk_aux3(a) + 2) * att_yuk_aux2(a)))

  pbe_f = lambda x: pbe_f0(X2S * x)

  attenuation_yukawa = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.92, lambda _aval: -1 / 7030 * (1.0 / jnp.maximum(_aval, 1.92)) ** 36 + 1 / 5985 * (1.0 / jnp.maximum(_aval, 1.92)) ** 34 - 1 / 5049 * (1.0 / jnp.maximum(_aval, 1.92)) ** 32 + 1 / 4216 * (1.0 / jnp.maximum(_aval, 1.92)) ** 30 - 1 / 3480 * (1.0 / jnp.maximum(_aval, 1.92)) ** 28 + 1 / 2835 * (1.0 / jnp.maximum(_aval, 1.92)) ** 26 - 1 / 2275 * (1.0 / jnp.maximum(_aval, 1.92)) ** 24 + 1 / 1794 * (1.0 / jnp.maximum(_aval, 1.92)) ** 22 - 1 / 1386 * (1.0 / jnp.maximum(_aval, 1.92)) ** 20 + 1 / 1045 * (1.0 / jnp.maximum(_aval, 1.92)) ** 18 - 1 / 765 * (1.0 / jnp.maximum(_aval, 1.92)) ** 16 + 1 / 540 * (1.0 / jnp.maximum(_aval, 1.92)) ** 14 - 1 / 364 * (1.0 / jnp.maximum(_aval, 1.92)) ** 12 + 1 / 231 * (1.0 / jnp.maximum(_aval, 1.92)) ** 10 - 1 / 135 * (1.0 / jnp.maximum(_aval, 1.92)) ** 8 + 1 / 70 * (1.0 / jnp.maximum(_aval, 1.92)) ** 6 - 1 / 30 * (1.0 / jnp.maximum(_aval, 1.92)) ** 4 + 1 / 9 * (1.0 / jnp.maximum(_aval, 1.92)) ** 2, lambda _aval: attenuation_yukawa0(jnp.minimum(_aval, 1.92)))

  ityh_enhancement = lambda xs: pbe_f(xs)

  ityh_attenuation = lambda a: attenuation_yukawa(a)

  ityh_k_GGA = lambda rs, z, xs: jnp.sqrt(9 * jnp.pi / (2 * X_FACTOR_C * ityh_enhancement(xs))) * f.n_spin(rs, z) ** (1 / 3)

  ityh_aa = lambda rs, z, xs: f.p.cam_omega / (2 * ityh_k_GGA(rs, z, xs))

  ityh_f_aa = lambda rs, z, xs: ityh_attenuation(ityh_aa(rs, z, xs))

  ityh_f = lambda rs, z, xs: ityh_f_aa(rs, z, xs) * ityh_enhancement(xs)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange_nsp(f, params, ityh_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_kappa = 0.804

  params_mu = 0.2195149727645171

  att_yuk_aux1 = lambda a: jnp.arctan2(1, a)

  att_yuk_aux2 = lambda a: jnp.log(1 + 1 / a ** 2)

  att_yuk_aux3 = lambda a: a ** 2 + 1

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  attenuation_yukawa0 = lambda a: 1 - 8 / 3 * a * (att_yuk_aux1(a) + a / 4 * (1 - (att_yuk_aux3(a) + 2) * att_yuk_aux2(a)))

  pbe_f = lambda x: pbe_f0(X2S * x)

  attenuation_yukawa = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.92, lambda _aval: -1 / 7030 * (1.0 / jnp.maximum(_aval, 1.92)) ** 36 + 1 / 5985 * (1.0 / jnp.maximum(_aval, 1.92)) ** 34 - 1 / 5049 * (1.0 / jnp.maximum(_aval, 1.92)) ** 32 + 1 / 4216 * (1.0 / jnp.maximum(_aval, 1.92)) ** 30 - 1 / 3480 * (1.0 / jnp.maximum(_aval, 1.92)) ** 28 + 1 / 2835 * (1.0 / jnp.maximum(_aval, 1.92)) ** 26 - 1 / 2275 * (1.0 / jnp.maximum(_aval, 1.92)) ** 24 + 1 / 1794 * (1.0 / jnp.maximum(_aval, 1.92)) ** 22 - 1 / 1386 * (1.0 / jnp.maximum(_aval, 1.92)) ** 20 + 1 / 1045 * (1.0 / jnp.maximum(_aval, 1.92)) ** 18 - 1 / 765 * (1.0 / jnp.maximum(_aval, 1.92)) ** 16 + 1 / 540 * (1.0 / jnp.maximum(_aval, 1.92)) ** 14 - 1 / 364 * (1.0 / jnp.maximum(_aval, 1.92)) ** 12 + 1 / 231 * (1.0 / jnp.maximum(_aval, 1.92)) ** 10 - 1 / 135 * (1.0 / jnp.maximum(_aval, 1.92)) ** 8 + 1 / 70 * (1.0 / jnp.maximum(_aval, 1.92)) ** 6 - 1 / 30 * (1.0 / jnp.maximum(_aval, 1.92)) ** 4 + 1 / 9 * (1.0 / jnp.maximum(_aval, 1.92)) ** 2, lambda _aval: attenuation_yukawa0(jnp.minimum(_aval, 1.92)))

  ityh_enhancement = lambda xs: pbe_f(xs)

  ityh_attenuation = lambda a: attenuation_yukawa(a)

  ityh_k_GGA = lambda rs, z, xs: jnp.sqrt(9 * jnp.pi / (2 * X_FACTOR_C * ityh_enhancement(xs))) * f.n_spin(rs, z) ** (1 / 3)

  ityh_aa = lambda rs, z, xs: f.p.cam_omega / (2 * ityh_k_GGA(rs, z, xs))

  ityh_f_aa = lambda rs, z, xs: ityh_attenuation(ityh_aa(rs, z, xs))

  ityh_f = lambda rs, z, xs: ityh_f_aa(rs, z, xs) * ityh_enhancement(xs)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange_nsp(f, params, ityh_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_kappa = 0.804

  params_mu = 0.2195149727645171

  att_yuk_aux1 = lambda a: jnp.arctan2(1, a)

  att_yuk_aux2 = lambda a: jnp.log(1 + 1 / a ** 2)

  att_yuk_aux3 = lambda a: a ** 2 + 1

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  attenuation_yukawa0 = lambda a: 1 - 8 / 3 * a * (att_yuk_aux1(a) + a / 4 * (1 - (att_yuk_aux3(a) + 2) * att_yuk_aux2(a)))

  pbe_f = lambda x: pbe_f0(X2S * x)

  attenuation_yukawa = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.92, lambda _aval: -1 / 7030 * (1.0 / jnp.maximum(_aval, 1.92)) ** 36 + 1 / 5985 * (1.0 / jnp.maximum(_aval, 1.92)) ** 34 - 1 / 5049 * (1.0 / jnp.maximum(_aval, 1.92)) ** 32 + 1 / 4216 * (1.0 / jnp.maximum(_aval, 1.92)) ** 30 - 1 / 3480 * (1.0 / jnp.maximum(_aval, 1.92)) ** 28 + 1 / 2835 * (1.0 / jnp.maximum(_aval, 1.92)) ** 26 - 1 / 2275 * (1.0 / jnp.maximum(_aval, 1.92)) ** 24 + 1 / 1794 * (1.0 / jnp.maximum(_aval, 1.92)) ** 22 - 1 / 1386 * (1.0 / jnp.maximum(_aval, 1.92)) ** 20 + 1 / 1045 * (1.0 / jnp.maximum(_aval, 1.92)) ** 18 - 1 / 765 * (1.0 / jnp.maximum(_aval, 1.92)) ** 16 + 1 / 540 * (1.0 / jnp.maximum(_aval, 1.92)) ** 14 - 1 / 364 * (1.0 / jnp.maximum(_aval, 1.92)) ** 12 + 1 / 231 * (1.0 / jnp.maximum(_aval, 1.92)) ** 10 - 1 / 135 * (1.0 / jnp.maximum(_aval, 1.92)) ** 8 + 1 / 70 * (1.0 / jnp.maximum(_aval, 1.92)) ** 6 - 1 / 30 * (1.0 / jnp.maximum(_aval, 1.92)) ** 4 + 1 / 9 * (1.0 / jnp.maximum(_aval, 1.92)) ** 2, lambda _aval: attenuation_yukawa0(jnp.minimum(_aval, 1.92)))

  ityh_enhancement = lambda xs: pbe_f(xs)

  ityh_attenuation = lambda a: attenuation_yukawa(a)

  ityh_k_GGA = lambda rs, z, xs: jnp.sqrt(9 * jnp.pi / (2 * X_FACTOR_C * ityh_enhancement(xs))) * f.n_spin(rs, z) ** (1 / 3)

  ityh_aa = lambda rs, z, xs: f.p.cam_omega / (2 * ityh_k_GGA(rs, z, xs))

  ityh_f_aa = lambda rs, z, xs: ityh_attenuation(ityh_aa(rs, z, xs))

  ityh_f = lambda rs, z, xs: ityh_f_aa(rs, z, xs) * ityh_enhancement(xs)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange_nsp(f, params, ityh_f, rs, zeta, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t5 * t25
  t27 = t6 ** (0.1e1 / 0.3e1)
  t28 = t2 ** 2
  t29 = jnp.pi * t28
  t31 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t32 = 0.1e1 / t31
  t33 = 4 ** (0.1e1 / 0.3e1)
  t34 = t32 * t33
  t35 = 6 ** (0.1e1 / 0.3e1)
  t36 = jnp.pi ** 2
  t37 = t36 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t39 = 0.1e1 / t38
  t40 = t35 * t39
  t41 = r0 ** 2
  t42 = r0 ** (0.1e1 / 0.3e1)
  t43 = t42 ** 2
  t45 = 0.1e1 / t43 / t41
  t49 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333333e-2 * t40 * s0 * t45
  t52 = 0.18040e1 - 0.64641600e0 / t49
  t55 = t29 * t34 / t52
  t56 = jnp.sqrt(t55)
  t58 = f.p.cam_omega / t56
  t59 = 2 ** (0.1e1 / 0.3e1)
  t60 = t19 * t6
  t61 = t60 ** (0.1e1 / 0.3e1)
  t62 = 0.1e1 / t61
  t65 = t58 * t59 * t62 / 0.2e1
  t66 = 0.192e1 <= t65
  t67 = 0.192e1 < t65
  t68 = f.my_piecewise3(t67, t65, 0.192e1)
  t69 = t68 ** 2
  t70 = t69 ** 2
  t73 = t70 * t69
  t76 = t70 ** 2
  t79 = t76 * t69
  t82 = t76 * t70
  t85 = t76 * t73
  t88 = t76 ** 2
  t112 = t88 ** 2
  t123 = -0.1e1 / t70 / 0.30e2 + 0.1e1 / t73 / 0.70e2 - 0.1e1 / t76 / 0.135e3 + 0.1e1 / t79 / 0.231e3 - 0.1e1 / t82 / 0.364e3 + 0.1e1 / t85 / 0.540e3 - 0.1e1 / t88 / 0.765e3 + 0.1e1 / t88 / t69 / 0.1045e4 - 0.1e1 / t88 / t70 / 0.1386e4 + 0.1e1 / t88 / t73 / 0.1794e4 - 0.1e1 / t88 / t76 / 0.2275e4 + 0.1e1 / t88 / t79 / 0.2835e4 - 0.1e1 / t88 / t82 / 0.3480e4 + 0.1e1 / t88 / t85 / 0.4216e4 - 0.1e1 / t112 / 0.5049e4 + 0.1e1 / t112 / t69 / 0.5985e4 - 0.1e1 / t112 / t70 / 0.7030e4 + 0.1e1 / t69 / 0.9e1
  t124 = f.my_piecewise3(t67, 0.192e1, t65)
  t125 = jnp.arctan2(0.1e1, t124)
  t126 = t124 ** 2
  t127 = t126 + 0.3e1
  t128 = 0.1e1 / t126
  t129 = 0.1e1 + t128
  t130 = jnp.log(t129)
  t132 = -t127 * t130 + 0.1e1
  t135 = t125 + t124 * t132 / 0.4e1
  t139 = f.my_piecewise3(t66, t123, 0.1e1 - 0.8e1 / 0.3e1 * t124 * t135)
  t141 = t27 * t139 * t52
  t144 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t26 * t141)
  t145 = r1 <= f.p.dens_threshold
  t146 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t147 = 0.1e1 + t146
  t148 = t147 <= f.p.zeta_threshold
  t149 = t147 ** (0.1e1 / 0.3e1)
  t151 = f.my_piecewise3(t148, t22, t149 * t147)
  t152 = t5 * t151
  t153 = r1 ** 2
  t154 = r1 ** (0.1e1 / 0.3e1)
  t155 = t154 ** 2
  t157 = 0.1e1 / t155 / t153
  t161 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333333e-2 * t40 * s2 * t157
  t164 = 0.18040e1 - 0.64641600e0 / t161
  t167 = t29 * t34 / t164
  t168 = jnp.sqrt(t167)
  t170 = f.p.cam_omega / t168
  t171 = t147 * t6
  t172 = t171 ** (0.1e1 / 0.3e1)
  t173 = 0.1e1 / t172
  t176 = t170 * t59 * t173 / 0.2e1
  t177 = 0.192e1 <= t176
  t178 = 0.192e1 < t176
  t179 = f.my_piecewise3(t178, t176, 0.192e1)
  t180 = t179 ** 2
  t181 = t180 ** 2
  t184 = t181 * t180
  t187 = t181 ** 2
  t190 = t187 * t180
  t193 = t187 * t181
  t196 = t187 * t184
  t199 = t187 ** 2
  t223 = t199 ** 2
  t234 = -0.1e1 / t181 / 0.30e2 + 0.1e1 / t184 / 0.70e2 - 0.1e1 / t187 / 0.135e3 + 0.1e1 / t190 / 0.231e3 - 0.1e1 / t193 / 0.364e3 + 0.1e1 / t196 / 0.540e3 - 0.1e1 / t199 / 0.765e3 + 0.1e1 / t199 / t180 / 0.1045e4 - 0.1e1 / t199 / t181 / 0.1386e4 + 0.1e1 / t199 / t184 / 0.1794e4 - 0.1e1 / t199 / t187 / 0.2275e4 + 0.1e1 / t199 / t190 / 0.2835e4 - 0.1e1 / t199 / t193 / 0.3480e4 + 0.1e1 / t199 / t196 / 0.4216e4 - 0.1e1 / t223 / 0.5049e4 + 0.1e1 / t223 / t180 / 0.5985e4 - 0.1e1 / t223 / t181 / 0.7030e4 + 0.1e1 / t180 / 0.9e1
  t235 = f.my_piecewise3(t178, 0.192e1, t176)
  t236 = jnp.arctan2(0.1e1, t235)
  t237 = t235 ** 2
  t238 = t237 + 0.3e1
  t239 = 0.1e1 / t237
  t240 = 0.1e1 + t239
  t241 = jnp.log(t240)
  t243 = -t238 * t241 + 0.1e1
  t246 = t236 + t235 * t243 / 0.4e1
  t250 = f.my_piecewise3(t177, t234, 0.1e1 - 0.8e1 / 0.3e1 * t235 * t246)
  t252 = t27 * t250 * t164
  t255 = f.my_piecewise3(t145, 0, -0.3e1 / 0.8e1 * t152 * t252)
  t256 = t6 ** 2
  t258 = t16 / t256
  t259 = t7 - t258
  t260 = f.my_piecewise5(t10, 0, t14, 0, t259)
  t263 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t260)
  t267 = t27 ** 2
  t268 = 0.1e1 / t267
  t272 = t26 * t268 * t139 * t52 / 0.8e1
  t273 = t70 * t68
  t274 = 0.1e1 / t273
  t278 = f.p.cam_omega / t56 / t55 * t59
  t279 = t62 * jnp.pi
  t280 = t28 * t32
  t283 = t52 ** 2
  t284 = 0.1e1 / t283
  t286 = t49 ** 2
  t287 = 0.1e1 / t286
  t291 = 0.1e1 / t43 / t41 / r0
  t299 = t59 / t61 / t60
  t305 = -0.39416108509596690476000000000000000000000000000000e-2 * t278 * t279 * t280 * t33 * t284 * t287 * t40 * s0 * t291 - t58 * t299 * (t260 * t6 + t18 + 0.1e1) / 0.6e1
  t306 = f.my_piecewise3(t67, t305, 0)
  t309 = t69 * t68
  t310 = t70 * t309
  t311 = 0.1e1 / t310
  t314 = t76 * t68
  t315 = 0.1e1 / t314
  t318 = t76 * t309
  t319 = 0.1e1 / t318
  t322 = t76 * t273
  t323 = 0.1e1 / t322
  t326 = t76 * t310
  t327 = 0.1e1 / t326
  t331 = 0.1e1 / t88 / t68
  t335 = 0.1e1 / t88 / t309
  t339 = 0.1e1 / t88 / t273
  t343 = 0.1e1 / t88 / t310
  t347 = 0.1e1 / t88 / t314
  t351 = 0.1e1 / t88 / t318
  t355 = 0.1e1 / t88 / t322
  t359 = 0.1e1 / t88 / t326
  t363 = 0.1e1 / t112 / t68
  t367 = 0.1e1 / t112 / t309
  t371 = 0.1e1 / t112 / t273
  t374 = 0.1e1 / t309
  t377 = 0.2e1 / 0.15e2 * t274 * t306 - 0.3e1 / 0.35e2 * t311 * t306 + 0.8e1 / 0.135e3 * t315 * t306 - 0.10e2 / 0.231e3 * t319 * t306 + 0.3e1 / 0.91e2 * t323 * t306 - 0.7e1 / 0.270e3 * t327 * t306 + 0.16e2 / 0.765e3 * t331 * t306 - 0.18e2 / 0.1045e4 * t335 * t306 + 0.10e2 / 0.693e3 * t339 * t306 - 0.11e2 / 0.897e3 * t343 * t306 + 0.24e2 / 0.2275e4 * t347 * t306 - 0.26e2 / 0.2835e4 * t351 * t306 + 0.7e1 / 0.870e3 * t355 * t306 - 0.15e2 / 0.2108e4 * t359 * t306 + 0.32e2 / 0.5049e4 * t363 * t306 - 0.34e2 / 0.5985e4 * t367 * t306 + 0.18e2 / 0.3515e4 * t371 * t306 - 0.2e1 / 0.9e1 * t374 * t306
  t378 = f.my_piecewise3(t67, 0, t305)
  t381 = 0.1e1 / t129
  t389 = t127 / t126 / t124
  t400 = f.my_piecewise3(t66, t377, -0.8e1 / 0.3e1 * t378 * t135 - 0.8e1 / 0.3e1 * t124 * (-t128 * t378 * t381 + t378 * t132 / 0.4e1 + t124 * (-0.2e1 * t124 * t378 * t130 + 0.2e1 * t389 * t378 * t381) / 0.4e1))
  t405 = t25 * t27
  t408 = t287 * t35
  t415 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t263 * t141 - t272 - 0.3e1 / 0.8e1 * t26 * t27 * t400 * t52 + 0.59124162764395035714000000000000000000000000000000e-2 * t5 * t405 * t139 * t408 * t39 * s0 * t291)
  t417 = f.my_piecewise5(t14, 0, t10, 0, -t259)
  t420 = f.my_piecewise3(t148, 0, 0.4e1 / 0.3e1 * t149 * t417)
  t427 = t152 * t268 * t250 * t164 / 0.8e1
  t428 = t181 * t179
  t429 = 0.1e1 / t428
  t432 = t59 / t172 / t171
  t437 = t170 * t432 * (t417 * t6 + t146 + 0.1e1) / 0.6e1
  t438 = f.my_piecewise3(t178, -t437, 0)
  t441 = t180 * t179
  t442 = t181 * t441
  t443 = 0.1e1 / t442
  t446 = t187 * t179
  t447 = 0.1e1 / t446
  t450 = t187 * t441
  t451 = 0.1e1 / t450
  t454 = t187 * t428
  t455 = 0.1e1 / t454
  t458 = t187 * t442
  t459 = 0.1e1 / t458
  t463 = 0.1e1 / t199 / t179
  t467 = 0.1e1 / t199 / t441
  t471 = 0.1e1 / t199 / t428
  t475 = 0.1e1 / t199 / t442
  t479 = 0.1e1 / t199 / t446
  t483 = 0.1e1 / t199 / t450
  t487 = 0.1e1 / t199 / t454
  t491 = 0.1e1 / t199 / t458
  t495 = 0.1e1 / t223 / t179
  t499 = 0.1e1 / t223 / t441
  t503 = 0.1e1 / t223 / t428
  t506 = 0.1e1 / t441
  t509 = 0.2e1 / 0.15e2 * t429 * t438 - 0.3e1 / 0.35e2 * t443 * t438 + 0.8e1 / 0.135e3 * t447 * t438 - 0.10e2 / 0.231e3 * t451 * t438 + 0.3e1 / 0.91e2 * t455 * t438 - 0.7e1 / 0.270e3 * t459 * t438 + 0.16e2 / 0.765e3 * t463 * t438 - 0.18e2 / 0.1045e4 * t467 * t438 + 0.10e2 / 0.693e3 * t471 * t438 - 0.11e2 / 0.897e3 * t475 * t438 + 0.24e2 / 0.2275e4 * t479 * t438 - 0.26e2 / 0.2835e4 * t483 * t438 + 0.7e1 / 0.870e3 * t487 * t438 - 0.15e2 / 0.2108e4 * t491 * t438 + 0.32e2 / 0.5049e4 * t495 * t438 - 0.34e2 / 0.5985e4 * t499 * t438 + 0.18e2 / 0.3515e4 * t503 * t438 - 0.2e1 / 0.9e1 * t506 * t438
  t510 = f.my_piecewise3(t178, 0, -t437)
  t513 = 0.1e1 / t240
  t521 = t238 / t237 / t235
  t532 = f.my_piecewise3(t177, t509, -0.8e1 / 0.3e1 * t510 * t246 - 0.8e1 / 0.3e1 * t235 * (-t239 * t510 * t513 + t510 * t243 / 0.4e1 + t235 * (-0.2e1 * t235 * t510 * t241 + 0.2e1 * t521 * t510 * t513) / 0.4e1))
  t538 = f.my_piecewise3(t145, 0, -0.3e1 / 0.8e1 * t5 * t420 * t252 - t427 - 0.3e1 / 0.8e1 * t152 * t27 * t532 * t164)
  vrho_0_ = t144 + t255 + t6 * (t415 + t538)
  t541 = -t7 - t258
  t542 = f.my_piecewise5(t10, 0, t14, 0, t541)
  t545 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t542)
  t553 = t58 * t299 * (t542 * t6 + t18 + 0.1e1) / 0.6e1
  t554 = f.my_piecewise3(t67, -t553, 0)
  t591 = 0.2e1 / 0.15e2 * t274 * t554 - 0.3e1 / 0.35e2 * t311 * t554 + 0.8e1 / 0.135e3 * t315 * t554 - 0.10e2 / 0.231e3 * t319 * t554 + 0.3e1 / 0.91e2 * t323 * t554 - 0.7e1 / 0.270e3 * t327 * t554 + 0.16e2 / 0.765e3 * t331 * t554 - 0.18e2 / 0.1045e4 * t335 * t554 + 0.10e2 / 0.693e3 * t339 * t554 - 0.11e2 / 0.897e3 * t343 * t554 + 0.24e2 / 0.2275e4 * t347 * t554 - 0.26e2 / 0.2835e4 * t351 * t554 + 0.7e1 / 0.870e3 * t355 * t554 - 0.15e2 / 0.2108e4 * t359 * t554 + 0.32e2 / 0.5049e4 * t363 * t554 - 0.34e2 / 0.5985e4 * t367 * t554 + 0.18e2 / 0.3515e4 * t371 * t554 - 0.2e1 / 0.9e1 * t374 * t554
  t592 = f.my_piecewise3(t67, 0, -t553)
  t610 = f.my_piecewise3(t66, t591, -0.8e1 / 0.3e1 * t592 * t135 - 0.8e1 / 0.3e1 * t124 * (-t128 * t592 * t381 + t592 * t132 / 0.4e1 + t124 * (-0.2e1 * t124 * t592 * t130 + 0.2e1 * t389 * t592 * t381) / 0.4e1))
  t616 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t545 * t141 - t272 - 0.3e1 / 0.8e1 * t26 * t27 * t610 * t52)
  t618 = f.my_piecewise5(t14, 0, t10, 0, -t541)
  t621 = f.my_piecewise3(t148, 0, 0.4e1 / 0.3e1 * t149 * t618)
  t628 = f.p.cam_omega / t168 / t167 * t59
  t629 = t173 * jnp.pi
  t632 = t164 ** 2
  t633 = 0.1e1 / t632
  t635 = t161 ** 2
  t636 = 0.1e1 / t635
  t640 = 0.1e1 / t155 / t153 / r1
  t651 = -0.39416108509596690476000000000000000000000000000000e-2 * t628 * t629 * t280 * t33 * t633 * t636 * t40 * s2 * t640 - t170 * t432 * (t618 * t6 + t146 + 0.1e1) / 0.6e1
  t652 = f.my_piecewise3(t178, t651, 0)
  t689 = 0.2e1 / 0.15e2 * t429 * t652 - 0.3e1 / 0.35e2 * t443 * t652 + 0.8e1 / 0.135e3 * t447 * t652 - 0.10e2 / 0.231e3 * t451 * t652 + 0.3e1 / 0.91e2 * t455 * t652 - 0.7e1 / 0.270e3 * t459 * t652 + 0.16e2 / 0.765e3 * t463 * t652 - 0.18e2 / 0.1045e4 * t467 * t652 + 0.10e2 / 0.693e3 * t471 * t652 - 0.11e2 / 0.897e3 * t475 * t652 + 0.24e2 / 0.2275e4 * t479 * t652 - 0.26e2 / 0.2835e4 * t483 * t652 + 0.7e1 / 0.870e3 * t487 * t652 - 0.15e2 / 0.2108e4 * t491 * t652 + 0.32e2 / 0.5049e4 * t495 * t652 - 0.34e2 / 0.5985e4 * t499 * t652 + 0.18e2 / 0.3515e4 * t503 * t652 - 0.2e1 / 0.9e1 * t506 * t652
  t690 = f.my_piecewise3(t178, 0, t651)
  t708 = f.my_piecewise3(t177, t689, -0.8e1 / 0.3e1 * t690 * t246 - 0.8e1 / 0.3e1 * t235 * (-t239 * t690 * t513 + t690 * t243 / 0.4e1 + t235 * (-0.2e1 * t235 * t690 * t241 + 0.2e1 * t521 * t690 * t513) / 0.4e1))
  t713 = t151 * t27
  t716 = t636 * t35
  t723 = f.my_piecewise3(t145, 0, -0.3e1 / 0.8e1 * t5 * t621 * t252 - t427 - 0.3e1 / 0.8e1 * t152 * t27 * t708 * t164 + 0.59124162764395035714000000000000000000000000000000e-2 * t5 * t713 * t250 * t716 * t39 * s2 * t640)
  vrho_1_ = t144 + t255 + t6 * (t616 + t723)
  t733 = 0.14781040691098758928500000000000000000000000000000e-2 * t278 * t279 * t28 * t34 * t284 * t408 * t39 * t45
  t734 = f.my_piecewise3(t67, t733, 0)
  t771 = 0.2e1 / 0.15e2 * t274 * t734 - 0.3e1 / 0.35e2 * t311 * t734 + 0.8e1 / 0.135e3 * t315 * t734 - 0.10e2 / 0.231e3 * t319 * t734 + 0.3e1 / 0.91e2 * t323 * t734 - 0.7e1 / 0.270e3 * t327 * t734 + 0.16e2 / 0.765e3 * t331 * t734 - 0.18e2 / 0.1045e4 * t335 * t734 + 0.10e2 / 0.693e3 * t339 * t734 - 0.11e2 / 0.897e3 * t343 * t734 + 0.24e2 / 0.2275e4 * t347 * t734 - 0.26e2 / 0.2835e4 * t351 * t734 + 0.7e1 / 0.870e3 * t355 * t734 - 0.15e2 / 0.2108e4 * t359 * t734 + 0.32e2 / 0.5049e4 * t363 * t734 - 0.34e2 / 0.5985e4 * t367 * t734 + 0.18e2 / 0.3515e4 * t371 * t734 - 0.2e1 / 0.9e1 * t374 * t734
  t772 = f.my_piecewise3(t67, 0, t733)
  t790 = f.my_piecewise3(t66, t771, -0.8e1 / 0.3e1 * t772 * t135 - 0.8e1 / 0.3e1 * t124 * (-t128 * t772 * t381 + t772 * t132 / 0.4e1 + t124 * (-0.2e1 * t124 * t772 * t130 + 0.2e1 * t389 * t772 * t381) / 0.4e1))
  t802 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t26 * t27 * t790 * t52 - 0.22171561036648138392750000000000000000000000000000e-2 * t5 * t405 * t139 * t287 * t40 * t45)
  vsigma_0_ = t6 * t802
  vsigma_1_ = 0.0e0
  t810 = 0.14781040691098758928500000000000000000000000000000e-2 * t628 * t629 * t28 * t34 * t633 * t716 * t39 * t157
  t811 = f.my_piecewise3(t178, t810, 0)
  t848 = 0.2e1 / 0.15e2 * t429 * t811 - 0.3e1 / 0.35e2 * t443 * t811 + 0.8e1 / 0.135e3 * t447 * t811 - 0.10e2 / 0.231e3 * t451 * t811 + 0.3e1 / 0.91e2 * t455 * t811 - 0.7e1 / 0.270e3 * t459 * t811 + 0.16e2 / 0.765e3 * t463 * t811 - 0.18e2 / 0.1045e4 * t467 * t811 + 0.10e2 / 0.693e3 * t471 * t811 - 0.11e2 / 0.897e3 * t475 * t811 + 0.24e2 / 0.2275e4 * t479 * t811 - 0.26e2 / 0.2835e4 * t483 * t811 + 0.7e1 / 0.870e3 * t487 * t811 - 0.15e2 / 0.2108e4 * t491 * t811 + 0.32e2 / 0.5049e4 * t495 * t811 - 0.34e2 / 0.5985e4 * t499 * t811 + 0.18e2 / 0.3515e4 * t503 * t811 - 0.2e1 / 0.9e1 * t506 * t811
  t849 = f.my_piecewise3(t178, 0, t810)
  t867 = f.my_piecewise3(t177, t848, -0.8e1 / 0.3e1 * t849 * t246 - 0.8e1 / 0.3e1 * t235 * (-t239 * t849 * t513 + t849 * t243 / 0.4e1 + t235 * (-0.2e1 * t235 * t849 * t241 + 0.2e1 * t521 * t849 * t513) / 0.4e1))
  t879 = f.my_piecewise3(t145, 0, -0.3e1 / 0.8e1 * t152 * t27 * t867 * t164 - 0.22171561036648138392750000000000000000000000000000e-2 * t5 * t713 * t250 * t636 * t40 * t157)
  vsigma_2_ = t6 * t879
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_kappa = 0.804

  params_mu = 0.2195149727645171

  att_yuk_aux1 = lambda a: jnp.arctan2(1, a)

  att_yuk_aux2 = lambda a: jnp.log(1 + 1 / a ** 2)

  att_yuk_aux3 = lambda a: a ** 2 + 1

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  attenuation_yukawa0 = lambda a: 1 - 8 / 3 * a * (att_yuk_aux1(a) + a / 4 * (1 - (att_yuk_aux3(a) + 2) * att_yuk_aux2(a)))

  pbe_f = lambda x: pbe_f0(X2S * x)

  attenuation_yukawa = lambda a: apply_piecewise(a, lambda _aval: _aval >= 1.92, lambda _aval: -1 / 7030 * (1.0 / jnp.maximum(_aval, 1.92)) ** 36 + 1 / 5985 * (1.0 / jnp.maximum(_aval, 1.92)) ** 34 - 1 / 5049 * (1.0 / jnp.maximum(_aval, 1.92)) ** 32 + 1 / 4216 * (1.0 / jnp.maximum(_aval, 1.92)) ** 30 - 1 / 3480 * (1.0 / jnp.maximum(_aval, 1.92)) ** 28 + 1 / 2835 * (1.0 / jnp.maximum(_aval, 1.92)) ** 26 - 1 / 2275 * (1.0 / jnp.maximum(_aval, 1.92)) ** 24 + 1 / 1794 * (1.0 / jnp.maximum(_aval, 1.92)) ** 22 - 1 / 1386 * (1.0 / jnp.maximum(_aval, 1.92)) ** 20 + 1 / 1045 * (1.0 / jnp.maximum(_aval, 1.92)) ** 18 - 1 / 765 * (1.0 / jnp.maximum(_aval, 1.92)) ** 16 + 1 / 540 * (1.0 / jnp.maximum(_aval, 1.92)) ** 14 - 1 / 364 * (1.0 / jnp.maximum(_aval, 1.92)) ** 12 + 1 / 231 * (1.0 / jnp.maximum(_aval, 1.92)) ** 10 - 1 / 135 * (1.0 / jnp.maximum(_aval, 1.92)) ** 8 + 1 / 70 * (1.0 / jnp.maximum(_aval, 1.92)) ** 6 - 1 / 30 * (1.0 / jnp.maximum(_aval, 1.92)) ** 4 + 1 / 9 * (1.0 / jnp.maximum(_aval, 1.92)) ** 2, lambda _aval: attenuation_yukawa0(jnp.minimum(_aval, 1.92)))

  ityh_enhancement = lambda xs: pbe_f(xs)

  ityh_attenuation = lambda a: attenuation_yukawa(a)

  ityh_k_GGA = lambda rs, z, xs: jnp.sqrt(9 * jnp.pi / (2 * X_FACTOR_C * ityh_enhancement(xs))) * f.n_spin(rs, z) ** (1 / 3)

  ityh_aa = lambda rs, z, xs: f.p.cam_omega / (2 * ityh_k_GGA(rs, z, xs))

  ityh_f_aa = lambda rs, z, xs: ityh_attenuation(ityh_aa(rs, z, xs))

  ityh_f = lambda rs, z, xs: ityh_f_aa(rs, z, xs) * ityh_enhancement(xs)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange_nsp(f, params, ityh_f, rs, zeta, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t3 ** 2
  t21 = jnp.pi * t20
  t23 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t24 = 0.1e1 / t23
  t25 = 4 ** (0.1e1 / 0.3e1)
  t27 = 6 ** (0.1e1 / 0.3e1)
  t28 = jnp.pi ** 2
  t29 = t28 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = 0.1e1 / t30
  t32 = t27 * t31
  t33 = 2 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t36 = r0 ** 2
  t37 = t19 ** 2
  t39 = 0.1e1 / t37 / t36
  t43 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333333e-2 * t32 * s0 * t34 * t39
  t46 = 0.18040e1 - 0.64641600e0 / t43
  t49 = t21 * t24 * t25 / t46
  t50 = jnp.sqrt(t49)
  t52 = f.p.cam_omega / t50
  t53 = t11 * r0
  t54 = t53 ** (0.1e1 / 0.3e1)
  t55 = 0.1e1 / t54
  t58 = t52 * t33 * t55 / 0.2e1
  t59 = 0.192e1 <= t58
  t60 = 0.192e1 < t58
  t61 = f.my_piecewise3(t60, t58, 0.192e1)
  t62 = t61 ** 2
  t63 = t62 ** 2
  t66 = t63 * t62
  t69 = t63 ** 2
  t72 = t69 * t62
  t75 = t69 * t63
  t78 = t69 * t66
  t81 = t69 ** 2
  t105 = t81 ** 2
  t116 = -0.1e1 / t63 / 0.30e2 + 0.1e1 / t66 / 0.70e2 - 0.1e1 / t69 / 0.135e3 + 0.1e1 / t72 / 0.231e3 - 0.1e1 / t75 / 0.364e3 + 0.1e1 / t78 / 0.540e3 - 0.1e1 / t81 / 0.765e3 + 0.1e1 / t81 / t62 / 0.1045e4 - 0.1e1 / t81 / t63 / 0.1386e4 + 0.1e1 / t81 / t66 / 0.1794e4 - 0.1e1 / t81 / t69 / 0.2275e4 + 0.1e1 / t81 / t72 / 0.2835e4 - 0.1e1 / t81 / t75 / 0.3480e4 + 0.1e1 / t81 / t78 / 0.4216e4 - 0.1e1 / t105 / 0.5049e4 + 0.1e1 / t105 / t62 / 0.5985e4 - 0.1e1 / t105 / t63 / 0.7030e4 + 0.1e1 / t62 / 0.9e1
  t117 = f.my_piecewise3(t60, 0.192e1, t58)
  t118 = jnp.arctan2(0.1e1, t117)
  t119 = t117 ** 2
  t120 = t119 + 0.3e1
  t121 = 0.1e1 / t119
  t122 = 0.1e1 + t121
  t123 = jnp.log(t122)
  t125 = -t120 * t123 + 0.1e1
  t128 = t118 + t117 * t125 / 0.4e1
  t132 = f.my_piecewise3(t59, t116, 0.1e1 - 0.8e1 / 0.3e1 * t117 * t128)
  t137 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t19 * t132 * t46)
  t143 = t63 * t61
  t144 = 0.1e1 / t143
  t150 = f.p.cam_omega / t50 / t49 * t55 * t21 * t24
  t151 = t46 ** 2
  t154 = t43 ** 2
  t155 = 0.1e1 / t154
  t156 = t25 / t151 * t155
  t157 = t36 * r0
  t171 = -0.78832217019193380952000000000000000000000000000000e-2 * t150 * t156 * t32 * s0 / t37 / t157 - t52 * t33 / t54 / t53 * t11 / 0.6e1
  t172 = f.my_piecewise3(t60, t171, 0)
  t175 = t62 * t61
  t176 = t63 * t175
  t177 = 0.1e1 / t176
  t180 = t69 * t61
  t181 = 0.1e1 / t180
  t184 = t69 * t175
  t185 = 0.1e1 / t184
  t188 = t69 * t143
  t189 = 0.1e1 / t188
  t192 = t69 * t176
  t193 = 0.1e1 / t192
  t197 = 0.1e1 / t81 / t61
  t201 = 0.1e1 / t81 / t175
  t205 = 0.1e1 / t81 / t143
  t209 = 0.1e1 / t81 / t176
  t213 = 0.1e1 / t81 / t180
  t217 = 0.1e1 / t81 / t184
  t221 = 0.1e1 / t81 / t188
  t225 = 0.1e1 / t81 / t192
  t229 = 0.1e1 / t105 / t61
  t233 = 0.1e1 / t105 / t175
  t237 = 0.1e1 / t105 / t143
  t240 = 0.1e1 / t175
  t243 = 0.2e1 / 0.15e2 * t144 * t172 - 0.3e1 / 0.35e2 * t177 * t172 + 0.8e1 / 0.135e3 * t181 * t172 - 0.10e2 / 0.231e3 * t185 * t172 + 0.3e1 / 0.91e2 * t189 * t172 - 0.7e1 / 0.270e3 * t193 * t172 + 0.16e2 / 0.765e3 * t197 * t172 - 0.18e2 / 0.1045e4 * t201 * t172 + 0.10e2 / 0.693e3 * t205 * t172 - 0.11e2 / 0.897e3 * t209 * t172 + 0.24e2 / 0.2275e4 * t213 * t172 - 0.26e2 / 0.2835e4 * t217 * t172 + 0.7e1 / 0.870e3 * t221 * t172 - 0.15e2 / 0.2108e4 * t225 * t172 + 0.32e2 / 0.5049e4 * t229 * t172 - 0.34e2 / 0.5985e4 * t233 * t172 + 0.18e2 / 0.3515e4 * t237 * t172 - 0.2e1 / 0.9e1 * t240 * t172
  t244 = f.my_piecewise3(t60, 0, t171)
  t247 = 0.1e1 / t122
  t255 = t120 / t119 / t117
  t266 = f.my_piecewise3(t59, t243, -0.8e1 / 0.3e1 * t244 * t128 - 0.8e1 / 0.3e1 * t117 * (-t121 * t244 * t247 + t244 * t125 / 0.4e1 + t117 * (-0.2e1 * t117 * t244 * t123 + 0.2e1 * t255 * t244 * t247) / 0.4e1))
  t283 = f.my_piecewise3(t2, 0, -t18 / t37 * t132 * t46 / 0.8e1 - 0.3e1 / 0.8e1 * t18 * t19 * t266 * t46 + 0.59124162764395035714000000000000000000000000000000e-2 * t6 * t17 / t19 / t157 * t132 * t155 * t27 * t31 * s0 * t34)
  vrho_0_ = 0.2e1 * r0 * t283 + 0.2e1 * t137
  t289 = 0.29562081382197517857000000000000000000000000000000e-2 * t150 * t156 * t32 * t39
  t290 = f.my_piecewise3(t60, t289, 0)
  t327 = 0.2e1 / 0.15e2 * t144 * t290 - 0.3e1 / 0.35e2 * t177 * t290 + 0.8e1 / 0.135e3 * t181 * t290 - 0.10e2 / 0.231e3 * t185 * t290 + 0.3e1 / 0.91e2 * t189 * t290 - 0.7e1 / 0.270e3 * t193 * t290 + 0.16e2 / 0.765e3 * t197 * t290 - 0.18e2 / 0.1045e4 * t201 * t290 + 0.10e2 / 0.693e3 * t205 * t290 - 0.11e2 / 0.897e3 * t209 * t290 + 0.24e2 / 0.2275e4 * t213 * t290 - 0.26e2 / 0.2835e4 * t217 * t290 + 0.7e1 / 0.870e3 * t221 * t290 - 0.15e2 / 0.2108e4 * t225 * t290 + 0.32e2 / 0.5049e4 * t229 * t290 - 0.34e2 / 0.5985e4 * t233 * t290 + 0.18e2 / 0.3515e4 * t237 * t290 - 0.2e1 / 0.9e1 * t240 * t290
  t328 = f.my_piecewise3(t60, 0, t289)
  t346 = f.my_piecewise3(t59, t327, -0.8e1 / 0.3e1 * t328 * t128 - 0.8e1 / 0.3e1 * t117 * (-t121 * t328 * t247 + t328 * t125 / 0.4e1 + t117 * (-0.2e1 * t117 * t328 * t123 + 0.2e1 * t255 * t328 * t247) / 0.4e1))
  t361 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t19 * t346 * t46 - 0.22171561036648138392750000000000000000000000000000e-2 * t6 * t17 / t19 / t36 * t132 * t155 * t32 * t34)
  vsigma_0_ = 0.2e1 * r0 * t361
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = 0.1e1 / t20
  t22 = t3 ** 2
  t23 = jnp.pi * t22
  t25 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t26 = 0.1e1 / t25
  t27 = 4 ** (0.1e1 / 0.3e1)
  t28 = t26 * t27
  t29 = 6 ** (0.1e1 / 0.3e1)
  t30 = jnp.pi ** 2
  t31 = t30 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t33 = 0.1e1 / t32
  t34 = t29 * t33
  t35 = 2 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t37 = s0 * t36
  t38 = r0 ** 2
  t40 = 0.1e1 / t20 / t38
  t44 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t34 * t37 * t40
  t47 = 0.18040e1 - 0.64641600e0 / t44
  t50 = t23 * t28 / t47
  t51 = jnp.sqrt(t50)
  t53 = f.p.cam_omega / t51
  t54 = t11 * r0
  t55 = t54 ** (0.1e1 / 0.3e1)
  t56 = 0.1e1 / t55
  t59 = t53 * t35 * t56 / 0.2e1
  t60 = 0.192e1 <= t59
  t61 = 0.192e1 < t59
  t62 = f.my_piecewise3(t61, t59, 0.192e1)
  t63 = t62 ** 2
  t64 = t63 ** 2
  t65 = 0.1e1 / t64
  t67 = t64 * t63
  t68 = 0.1e1 / t67
  t70 = t64 ** 2
  t71 = 0.1e1 / t70
  t73 = t70 * t63
  t74 = 0.1e1 / t73
  t76 = t70 * t64
  t77 = 0.1e1 / t76
  t79 = t70 * t67
  t80 = 0.1e1 / t79
  t82 = t70 ** 2
  t83 = 0.1e1 / t82
  t86 = 0.1e1 / t82 / t63
  t89 = 0.1e1 / t82 / t64
  t92 = 0.1e1 / t82 / t67
  t95 = 0.1e1 / t82 / t70
  t98 = 0.1e1 / t82 / t73
  t101 = 0.1e1 / t82 / t76
  t104 = 0.1e1 / t82 / t79
  t106 = t82 ** 2
  t107 = 0.1e1 / t106
  t110 = 0.1e1 / t106 / t63
  t113 = 0.1e1 / t106 / t64
  t117 = -t65 / 0.30e2 + t68 / 0.70e2 - t71 / 0.135e3 + t74 / 0.231e3 - t77 / 0.364e3 + t80 / 0.540e3 - t83 / 0.765e3 + t86 / 0.1045e4 - t89 / 0.1386e4 + t92 / 0.1794e4 - t95 / 0.2275e4 + t98 / 0.2835e4 - t101 / 0.3480e4 + t104 / 0.4216e4 - t107 / 0.5049e4 + t110 / 0.5985e4 - t113 / 0.7030e4 + 0.1e1 / t63 / 0.9e1
  t118 = f.my_piecewise3(t61, 0.192e1, t59)
  t119 = jnp.arctan2(0.1e1, t118)
  t120 = t118 ** 2
  t121 = t120 + 0.3e1
  t122 = 0.1e1 / t120
  t123 = 0.1e1 + t122
  t124 = jnp.log(t123)
  t126 = -t121 * t124 + 0.1e1
  t129 = t119 + t118 * t126 / 0.4e1
  t133 = f.my_piecewise3(t60, t117, 0.1e1 - 0.8e1 / 0.3e1 * t118 * t129)
  t138 = t64 * t62
  t139 = 0.1e1 / t138
  t142 = f.p.cam_omega / t51 / t50
  t143 = t142 * t56
  t144 = t23 * t26
  t145 = t143 * t144
  t146 = t47 ** 2
  t147 = 0.1e1 / t146
  t148 = t27 * t147
  t149 = t44 ** 2
  t150 = 0.1e1 / t149
  t151 = t148 * t150
  t152 = t38 * r0
  t154 = 0.1e1 / t20 / t152
  t161 = 0.1e1 / t55 / t54
  t166 = -0.78832217019193380952000000000000000000000000000005e-2 * t145 * t151 * t34 * s0 * t154 - t53 * t35 * t161 * t11 / 0.6e1
  t167 = f.my_piecewise3(t61, t166, 0)
  t170 = t63 * t62
  t171 = t64 * t170
  t172 = 0.1e1 / t171
  t175 = t70 * t62
  t176 = 0.1e1 / t175
  t179 = t70 * t170
  t180 = 0.1e1 / t179
  t183 = t70 * t138
  t184 = 0.1e1 / t183
  t187 = t70 * t171
  t188 = 0.1e1 / t187
  t192 = 0.1e1 / t82 / t62
  t196 = 0.1e1 / t82 / t170
  t200 = 0.1e1 / t82 / t138
  t204 = 0.1e1 / t82 / t171
  t208 = 0.1e1 / t82 / t175
  t212 = 0.1e1 / t82 / t179
  t216 = 0.1e1 / t82 / t183
  t220 = 0.1e1 / t82 / t187
  t224 = 0.1e1 / t106 / t62
  t228 = 0.1e1 / t106 / t170
  t232 = 0.1e1 / t106 / t138
  t235 = 0.1e1 / t170
  t238 = 0.2e1 / 0.15e2 * t139 * t167 - 0.3e1 / 0.35e2 * t172 * t167 + 0.8e1 / 0.135e3 * t176 * t167 - 0.10e2 / 0.231e3 * t180 * t167 + 0.3e1 / 0.91e2 * t184 * t167 - 0.7e1 / 0.270e3 * t188 * t167 + 0.16e2 / 0.765e3 * t192 * t167 - 0.18e2 / 0.1045e4 * t196 * t167 + 0.10e2 / 0.693e3 * t200 * t167 - 0.11e2 / 0.897e3 * t204 * t167 + 0.24e2 / 0.2275e4 * t208 * t167 - 0.26e2 / 0.2835e4 * t212 * t167 + 0.7e1 / 0.870e3 * t216 * t167 - 0.15e2 / 0.2108e4 * t220 * t167 + 0.32e2 / 0.5049e4 * t224 * t167 - 0.34e2 / 0.5985e4 * t228 * t167 + 0.18e2 / 0.3515e4 * t232 * t167 - 0.2e1 / 0.9e1 * t235 * t167
  t239 = f.my_piecewise3(t61, 0, t166)
  t242 = 0.1e1 / t123
  t249 = 0.1e1 / t120 / t118
  t250 = t121 * t249
  t251 = t239 * t242
  t254 = -0.2e1 * t118 * t239 * t124 + 0.2e1 * t250 * t251
  t257 = -t122 * t239 * t242 + t239 * t126 / 0.4e1 + t118 * t254 / 0.4e1
  t261 = f.my_piecewise3(t60, t238, -0.8e1 / 0.3e1 * t118 * t257 - 0.8e1 / 0.3e1 * t239 * t129)
  t268 = t17 / t19 / t152
  t272 = t33 * s0
  t274 = t150 * t29 * t272 * t36
  t278 = f.my_piecewise3(t2, 0, -t18 * t21 * t133 * t47 / 0.8e1 - 0.3e1 / 0.8e1 * t18 * t19 * t261 * t47 + 0.59124162764395035714000000000000000000000000000004e-2 * t6 * t268 * t133 * t274)
  t290 = t38 ** 2
  t298 = t30 * t3
  t299 = t25 ** 2
  t300 = 0.1e1 / t299
  t301 = t27 ** 2
  t302 = t300 * t301
  t309 = f.p.cam_omega / t51 / t298 / t302 / t147 * t56 / 0.3e1
  t311 = t309 * t298 * t302
  t312 = t146 ** 2
  t313 = 0.1e1 / t312
  t314 = t149 ** 2
  t315 = 0.1e1 / t314
  t317 = t29 ** 2
  t318 = t313 * t315 * t317
  t320 = 0.1e1 / t31 / t30
  t321 = s0 ** 2
  t322 = t320 * t321
  t323 = t290 * t152
  t327 = t322 / t19 / t323 * t36
  t331 = t142 * t161
  t332 = t23 * t28
  t341 = t143 * t332
  t343 = 0.1e1 / t146 / t47
  t345 = t343 * t315 * t317
  t350 = 0.1e1 / t149 / t44
  t352 = t147 * t350 * t317
  t363 = t11 ** 2
  t371 = 0.55930665961450822902406623363317367836736000000007e-3 * t311 * t318 * t327 + 0.52554811346128920634666666666666666666666666666670e-2 * t331 * t332 * t147 * t150 * t29 * t272 * t154 * t11 - 0.24858073760644810178847388161474385705216000000003e-3 * t341 * t345 * t327 - 0.38455226604299414276328847308040620444444444444449e-3 * t341 * t352 * t327 + 0.28905146240370906349066666666666666666666666666669e-1 * t145 * t151 * t34 * s0 / t20 / t290 + 0.2e1 / 0.9e1 * t53 * t35 / t55 / t38
  t372 = f.my_piecewise3(t61, t371, 0)
  t377 = t167 ** 2
  t401 = 0.1e1 / t106 / t67
  t412 = 0.2e1 / 0.15e2 * t139 * t372 - 0.3e1 / 0.35e2 * t172 * t372 + 0.7e1 / 0.18e2 * t83 * t377 - 0.16e2 / 0.45e2 * t86 * t377 + 0.18e2 / 0.55e2 * t89 * t377 - 0.10e2 / 0.33e2 * t92 * t377 + 0.11e2 / 0.39e2 * t95 * t377 - 0.24e2 / 0.91e2 * t98 * t377 + 0.26e2 / 0.105e3 * t101 * t377 - 0.7e1 / 0.30e2 * t104 * t377 + 0.15e2 / 0.68e2 * t107 * t377 - 0.32e2 / 0.153e3 * t110 * t377 + 0.34e2 / 0.171e3 * t113 * t377 - 0.18e2 / 0.95e2 * t401 * t377 + 0.2e1 / 0.3e1 * t65 * t377 - 0.3e1 / 0.7e1 * t80 * t377 - 0.8e1 / 0.15e2 * t74 * t377 + 0.10e2 / 0.21e2 * t77 * t377
  t449 = 0.18e2 / 0.3515e4 * t232 * t372 - 0.2e1 / 0.9e1 * t235 * t372 - 0.15e2 / 0.2108e4 * t220 * t372 - 0.2e1 / 0.3e1 * t68 * t377 + 0.3e1 / 0.5e1 * t71 * t377 + 0.32e2 / 0.5049e4 * t224 * t372 - 0.34e2 / 0.5985e4 * t228 * t372 + 0.7e1 / 0.870e3 * t216 * t372 + 0.24e2 / 0.2275e4 * t208 * t372 - 0.26e2 / 0.2835e4 * t212 * t372 + 0.16e2 / 0.765e3 * t192 * t372 - 0.11e2 / 0.897e3 * t204 * t372 - 0.18e2 / 0.1045e4 * t196 * t372 + 0.10e2 / 0.693e3 * t200 * t372 - 0.7e1 / 0.270e3 * t188 * t372 + 0.8e1 / 0.135e3 * t176 * t372 - 0.10e2 / 0.231e3 * t180 * t372 + 0.3e1 / 0.91e2 * t184 * t372
  t451 = f.my_piecewise3(t61, 0, t371)
  t456 = t239 ** 2
  t462 = t120 ** 2
  t464 = 0.1e1 / t462 / t118
  t466 = t123 ** 2
  t467 = 0.1e1 / t466
  t483 = t121 / t462
  t492 = t121 / t462 / t120
  t503 = f.my_piecewise3(t60, t412 + t449, -0.8e1 / 0.3e1 * t451 * t129 - 0.16e2 / 0.3e1 * t239 * t257 - 0.8e1 / 0.3e1 * t118 * (0.2e1 * t249 * t456 * t242 - t122 * t451 * t242 - 0.2e1 * t464 * t456 * t467 + t451 * t126 / 0.4e1 + t239 * t254 / 0.2e1 + t118 * (-0.2e1 * t118 * t451 * t124 + 0.8e1 * t122 * t456 * t242 + 0.2e1 * t250 * t451 * t242 - 0.6e1 * t483 * t456 * t242 + 0.4e1 * t492 * t456 * t467 - 0.2e1 * t456 * t124) / 0.4e1))
  t516 = t350 * t317
  t522 = f.my_piecewise3(t2, 0, t18 / t20 / r0 * t133 * t47 / 0.12e2 - t18 * t21 * t261 * t47 / 0.4e1 - 0.17737248829318510714200000000000000000000000000001e-1 * t6 * t17 / t19 / t290 * t133 * t274 - 0.3e1 / 0.8e1 * t18 * t19 * t503 * t47 + 0.11824832552879007142800000000000000000000000000001e-1 * t6 * t268 * t261 * t274 + 0.57682839906449121414493270962060930666666666666673e-3 * t6 * t17 / t323 * t133 * t516 * t322 * t35)
  v2rho2_0_ = 0.2e1 * r0 * t522 + 0.4e1 * t278
  t528 = 0.29562081382197517857000000000000000000000000000000e-2 * t145 * t151 * t34 * t40
  t529 = f.my_piecewise3(t61, t528, 0)
  t566 = 0.2e1 / 0.15e2 * t139 * t529 - 0.3e1 / 0.35e2 * t172 * t529 + 0.8e1 / 0.135e3 * t176 * t529 - 0.10e2 / 0.231e3 * t180 * t529 + 0.3e1 / 0.91e2 * t184 * t529 - 0.7e1 / 0.270e3 * t188 * t529 + 0.16e2 / 0.765e3 * t192 * t529 - 0.18e2 / 0.1045e4 * t196 * t529 + 0.10e2 / 0.693e3 * t200 * t529 - 0.11e2 / 0.897e3 * t204 * t529 + 0.24e2 / 0.2275e4 * t208 * t529 - 0.26e2 / 0.2835e4 * t212 * t529 + 0.7e1 / 0.870e3 * t216 * t529 - 0.15e2 / 0.2108e4 * t220 * t529 + 0.32e2 / 0.5049e4 * t224 * t529 - 0.34e2 / 0.5985e4 * t228 * t529 + 0.18e2 / 0.3515e4 * t232 * t529 - 0.2e1 / 0.9e1 * t235 * t529
  t567 = f.my_piecewise3(t61, 0, t528)
  t569 = t122 * t567
  t575 = t567 * t242
  t578 = -0.2e1 * t118 * t567 * t124 + 0.2e1 * t250 * t575
  t581 = -t569 * t242 + t567 * t126 / 0.4e1 + t118 * t578 / 0.4e1
  t585 = f.my_piecewise3(t60, t566, -0.8e1 / 0.3e1 * t118 * t581 - 0.8e1 / 0.3e1 * t567 * t129)
  t593 = t6 * t17 / t19 / t38
  t595 = t34 * t36
  t596 = t133 * t150 * t595
  t600 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t19 * t585 * t47 - 0.22171561036648138392750000000000000000000000000001e-2 * t593 * t596)
  t605 = t290 * t38
  t609 = t320 / t19 / t605 * t37
  t629 = -0.20973999735544058588402483761244012938776000000001e-3 * t311 * t318 * t609 - 0.98540271273991726190000000000000000000000000000000e-3 * t331 * t144 * t151 * t34 * t40 * t11 + 0.93217776602418038170677705605528946394560000000006e-4 * t341 * t345 * t609 + 0.14420709976612280353623317740515232666666666666667e-3 * t341 * t352 * t609 - 0.78832217019193380952000000000000000000000000000000e-2 * t145 * t151 * t34 * t154
  t630 = f.my_piecewise3(t61, t629, 0)
  t667 = -0.7e1 / 0.270e3 * t188 * t630 + 0.2e1 / 0.15e2 * t139 * t630 + 0.8e1 / 0.135e3 * t176 * t630 - 0.10e2 / 0.231e3 * t180 * t630 + 0.3e1 / 0.91e2 * t184 * t630 + 0.24e2 / 0.2275e4 * t208 * t630 - 0.3e1 / 0.35e2 * t172 * t630 + 0.10e2 / 0.693e3 * t200 * t630 - 0.11e2 / 0.897e3 * t204 * t630 - 0.34e2 / 0.5985e4 * t228 * t630 + 0.16e2 / 0.765e3 * t192 * t630 - 0.18e2 / 0.1045e4 * t196 * t630 - 0.15e2 / 0.2108e4 * t220 * t630 + 0.32e2 / 0.5049e4 * t224 * t630 - 0.2e1 / 0.9e1 * t235 * t630 - 0.26e2 / 0.2835e4 * t212 * t630 + 0.7e1 / 0.870e3 * t216 * t630 + 0.18e2 / 0.3515e4 * t232 * t630
  t722 = -0.32e2 / 0.153e3 * t110 * t529 * t167 + 0.34e2 / 0.171e3 * t113 * t529 * t167 - 0.7e1 / 0.30e2 * t104 * t529 * t167 + 0.15e2 / 0.68e2 * t107 * t529 * t167 - 0.24e2 / 0.91e2 * t98 * t529 * t167 + 0.26e2 / 0.105e3 * t101 * t529 * t167 + 0.11e2 / 0.39e2 * t95 * t529 * t167 + 0.18e2 / 0.55e2 * t89 * t529 * t167 - 0.10e2 / 0.33e2 * t92 * t529 * t167 + 0.7e1 / 0.18e2 * t83 * t529 * t167 - 0.16e2 / 0.45e2 * t86 * t529 * t167 + 0.10e2 / 0.21e2 * t77 * t529 * t167 - 0.3e1 / 0.7e1 * t80 * t529 * t167 + 0.3e1 / 0.5e1 * t71 * t529 * t167 - 0.8e1 / 0.15e2 * t74 * t529 * t167 - 0.2e1 / 0.3e1 * t68 * t529 * t167 - 0.18e2 / 0.95e2 * t401 * t529 * t167 + 0.2e1 / 0.3e1 * t65 * t529 * t167
  t724 = f.my_piecewise3(t61, 0, t629)
  t768 = f.my_piecewise3(t60, t667 + t722, -0.8e1 / 0.3e1 * t724 * t129 - 0.8e1 / 0.3e1 * t567 * t257 - 0.8e1 / 0.3e1 * t239 * t581 - 0.8e1 / 0.3e1 * t118 * (0.2e1 * t249 * t567 * t251 - t122 * t724 * t242 - 0.2e1 * t464 * t567 * t467 * t239 + t724 * t126 / 0.4e1 + t567 * t254 / 0.4e1 + t239 * t578 / 0.4e1 + t118 * (0.4e1 * t492 * t567 * t467 * t239 - 0.2e1 * t118 * t724 * t124 - 0.2e1 * t239 * t567 * t124 - 0.6e1 * t483 * t575 * t239 + 0.2e1 * t250 * t724 * t242 + 0.8e1 * t569 * t251) / 0.4e1))
  t794 = f.my_piecewise3(t2, 0, -t18 * t21 * t585 * t47 / 0.8e1 - 0.3e1 / 0.8e1 * t18 * t19 * t768 * t47 + 0.59124162764395035714000000000000000000000000000004e-2 * t6 * t268 * t585 * t274 + 0.51733642418845656249750000000000000000000000000002e-2 * t6 * t268 * t596 - 0.22171561036648138392750000000000000000000000000001e-2 * t593 * t261 * t150 * t595 - 0.21631064964918420530434976610772849000000000000002e-3 * t6 * t17 / t605 * t133 * t516 * t320 * t35 * s0)
  v2rhosigma_0_ = 0.2e1 * r0 * t794 + 0.2e1 * t600
  t801 = t317 * t320
  t802 = t290 * r0
  t806 = t801 / t19 / t802 * t36
  t819 = 0.78652499008290219706509314104665048520410000000006e-4 * t309 * t298 * t300 * t301 * t313 * t315 * t806 - 0.34956666225906764314004139602073354897960000000000e-4 * t145 * t27 * t343 * t315 * t806 - 0.54077662412296051326087441526932122500000000000001e-4 * t145 * t148 * t350 * t806
  t820 = f.my_piecewise3(t61, t819, 0)
  t849 = t529 ** 2
  t858 = 0.18e2 / 0.3515e4 * t232 * t820 - 0.15e2 / 0.2108e4 * t220 * t820 + 0.10e2 / 0.693e3 * t200 * t820 + 0.32e2 / 0.5049e4 * t224 * t820 - 0.34e2 / 0.5985e4 * t228 * t820 + 0.7e1 / 0.870e3 * t216 * t820 - 0.2e1 / 0.9e1 * t235 * t820 + 0.16e2 / 0.765e3 * t192 * t820 - 0.18e2 / 0.1045e4 * t196 * t820 + 0.8e1 / 0.135e3 * t176 * t820 - 0.11e2 / 0.897e3 * t204 * t820 + 0.24e2 / 0.2275e4 * t208 * t820 - 0.26e2 / 0.2835e4 * t212 * t820 - 0.7e1 / 0.270e3 * t188 * t820 - 0.2e1 / 0.3e1 * t68 * t849 + 0.2e1 / 0.15e2 * t139 * t820 - 0.3e1 / 0.35e2 * t172 * t820 - 0.3e1 / 0.7e1 * t80 * t849
  t895 = 0.7e1 / 0.18e2 * t83 * t849 - 0.16e2 / 0.45e2 * t86 * t849 - 0.10e2 / 0.231e3 * t180 * t820 + 0.3e1 / 0.91e2 * t184 * t820 + 0.26e2 / 0.105e3 * t101 * t849 - 0.7e1 / 0.30e2 * t104 * t849 + 0.15e2 / 0.68e2 * t107 * t849 + 0.3e1 / 0.5e1 * t71 * t849 - 0.8e1 / 0.15e2 * t74 * t849 + 0.10e2 / 0.21e2 * t77 * t849 + 0.34e2 / 0.171e3 * t113 * t849 - 0.18e2 / 0.95e2 * t401 * t849 + 0.2e1 / 0.3e1 * t65 * t849 + 0.18e2 / 0.55e2 * t89 * t849 - 0.10e2 / 0.33e2 * t92 * t849 + 0.11e2 / 0.39e2 * t95 * t849 - 0.24e2 / 0.91e2 * t98 * t849 - 0.32e2 / 0.153e3 * t110 * t849
  t897 = f.my_piecewise3(t61, 0, t819)
  t902 = t567 ** 2
  t939 = f.my_piecewise3(t60, t858 + t895, -0.8e1 / 0.3e1 * t897 * t129 - 0.16e2 / 0.3e1 * t567 * t581 - 0.8e1 / 0.3e1 * t118 * (0.2e1 * t249 * t902 * t242 - t122 * t897 * t242 - 0.2e1 * t464 * t902 * t467 + t897 * t126 / 0.4e1 + t567 * t578 / 0.2e1 + t118 * (-0.2e1 * t118 * t897 * t124 + 0.8e1 * t122 * t902 * t242 + 0.2e1 * t250 * t897 * t242 - 0.6e1 * t483 * t902 * t242 + 0.4e1 * t492 * t902 * t467 - 0.2e1 * t902 * t124) / 0.4e1))
  t957 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t19 * t939 * t47 - 0.44343122073296276785500000000000000000000000000002e-2 * t593 * t585 * t150 * t595 + 0.81116493618444076989131162290398183750000000000005e-4 * t6 * t17 / t802 * t133 * t350 * t801 * t35)
  v2sigma2_0_ = 0.2e1 * r0 * t957
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / r0
  t23 = t3 ** 2
  t24 = jnp.pi * t23
  t26 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t27 = 0.1e1 / t26
  t28 = 4 ** (0.1e1 / 0.3e1)
  t29 = t27 * t28
  t30 = 6 ** (0.1e1 / 0.3e1)
  t31 = jnp.pi ** 2
  t32 = t31 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t34 = 0.1e1 / t33
  t35 = t30 * t34
  t36 = 2 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t39 = r0 ** 2
  t41 = 0.1e1 / t20 / t39
  t45 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t35 * s0 * t37 * t41
  t48 = 0.18040e1 - 0.64641600e0 / t45
  t51 = t24 * t29 / t48
  t52 = jnp.sqrt(t51)
  t54 = f.p.cam_omega / t52
  t55 = t11 * r0
  t56 = t55 ** (0.1e1 / 0.3e1)
  t57 = 0.1e1 / t56
  t60 = t54 * t36 * t57 / 0.2e1
  t61 = 0.192e1 <= t60
  t62 = 0.192e1 < t60
  t63 = f.my_piecewise3(t62, t60, 0.192e1)
  t64 = t63 ** 2
  t65 = t64 ** 2
  t66 = 0.1e1 / t65
  t68 = t65 * t64
  t69 = 0.1e1 / t68
  t71 = t65 ** 2
  t72 = 0.1e1 / t71
  t74 = t71 * t64
  t75 = 0.1e1 / t74
  t77 = t71 * t65
  t78 = 0.1e1 / t77
  t80 = t71 * t68
  t81 = 0.1e1 / t80
  t83 = t71 ** 2
  t84 = 0.1e1 / t83
  t87 = 0.1e1 / t83 / t64
  t90 = 0.1e1 / t83 / t65
  t93 = 0.1e1 / t83 / t68
  t96 = 0.1e1 / t83 / t71
  t99 = 0.1e1 / t83 / t74
  t102 = 0.1e1 / t83 / t77
  t105 = 0.1e1 / t83 / t80
  t107 = t83 ** 2
  t108 = 0.1e1 / t107
  t111 = 0.1e1 / t107 / t64
  t114 = 0.1e1 / t107 / t65
  t118 = -t66 / 0.30e2 + t69 / 0.70e2 - t72 / 0.135e3 + t75 / 0.231e3 - t78 / 0.364e3 + t81 / 0.540e3 - t84 / 0.765e3 + t87 / 0.1045e4 - t90 / 0.1386e4 + t93 / 0.1794e4 - t96 / 0.2275e4 + t99 / 0.2835e4 - t102 / 0.3480e4 + t105 / 0.4216e4 - t108 / 0.5049e4 + t111 / 0.5985e4 - t114 / 0.7030e4 + 0.1e1 / t64 / 0.9e1
  t119 = f.my_piecewise3(t62, 0.192e1, t60)
  t120 = jnp.atan2(0.1e1, t119)
  t121 = t119 ** 2
  t122 = t121 + 0.3e1
  t123 = 0.1e1 / t121
  t124 = 0.1e1 + t123
  t125 = jnp.log(t124)
  t127 = -t122 * t125 + 0.1e1
  t130 = t120 + t119 * t127 / 0.4e1
  t134 = f.my_piecewise3(t61, t118, 0.1e1 - 0.8e1 / 0.3e1 * t119 * t130)
  t139 = 0.1e1 / t20
  t140 = t65 * t63
  t141 = 0.1e1 / t140
  t144 = f.p.cam_omega / t52 / t51
  t145 = t144 * t57
  t147 = t145 * t24 * t27
  t148 = t48 ** 2
  t149 = 0.1e1 / t148
  t150 = t28 * t149
  t151 = t45 ** 2
  t152 = 0.1e1 / t151
  t153 = t150 * t152
  t154 = t39 * r0
  t156 = 0.1e1 / t20 / t154
  t163 = 0.1e1 / t56 / t55
  t168 = -0.78832217019193380952000000000000000000000000000005e-2 * t147 * t153 * t35 * s0 * t156 - t54 * t36 * t163 * t11 / 0.6e1
  t169 = f.my_piecewise3(t62, t168, 0)
  t172 = t64 * t63
  t173 = t65 * t172
  t174 = 0.1e1 / t173
  t177 = t71 * t63
  t178 = 0.1e1 / t177
  t181 = t71 * t172
  t182 = 0.1e1 / t181
  t185 = t71 * t140
  t186 = 0.1e1 / t185
  t189 = t71 * t173
  t190 = 0.1e1 / t189
  t194 = 0.1e1 / t83 / t63
  t198 = 0.1e1 / t83 / t172
  t202 = 0.1e1 / t83 / t140
  t206 = 0.1e1 / t83 / t173
  t210 = 0.1e1 / t83 / t177
  t214 = 0.1e1 / t83 / t181
  t218 = 0.1e1 / t83 / t185
  t222 = 0.1e1 / t83 / t189
  t226 = 0.1e1 / t107 / t63
  t230 = 0.1e1 / t107 / t172
  t234 = 0.1e1 / t107 / t140
  t237 = 0.1e1 / t172
  t240 = 0.2e1 / 0.15e2 * t141 * t169 - 0.3e1 / 0.35e2 * t174 * t169 + 0.8e1 / 0.135e3 * t178 * t169 - 0.10e2 / 0.231e3 * t182 * t169 + 0.3e1 / 0.91e2 * t186 * t169 - 0.7e1 / 0.270e3 * t190 * t169 + 0.16e2 / 0.765e3 * t194 * t169 - 0.18e2 / 0.1045e4 * t198 * t169 + 0.10e2 / 0.693e3 * t202 * t169 - 0.11e2 / 0.897e3 * t206 * t169 + 0.24e2 / 0.2275e4 * t210 * t169 - 0.26e2 / 0.2835e4 * t214 * t169 + 0.7e1 / 0.870e3 * t218 * t169 - 0.15e2 / 0.2108e4 * t222 * t169 + 0.32e2 / 0.5049e4 * t226 * t169 - 0.34e2 / 0.5985e4 * t230 * t169 + 0.18e2 / 0.3515e4 * t234 * t169 - 0.2e1 / 0.9e1 * t237 * t169
  t241 = f.my_piecewise3(t62, 0, t168)
  t244 = 0.1e1 / t124
  t250 = t121 * t119
  t251 = 0.1e1 / t250
  t252 = t122 * t251
  t253 = t241 * t244
  t256 = -0.2e1 * t119 * t241 * t125 + 0.2e1 * t252 * t253
  t259 = -t123 * t241 * t244 + t241 * t127 / 0.4e1 + t119 * t256 / 0.4e1
  t263 = f.my_piecewise3(t61, t240, -0.8e1 / 0.3e1 * t119 * t259 - 0.8e1 / 0.3e1 * t241 * t130)
  t268 = t39 ** 2
  t271 = t17 / t19 / t268
  t275 = t34 * s0
  t277 = t152 * t30 * t275 * t37
  t280 = t31 * t3
  t281 = t26 ** 2
  t282 = 0.1e1 / t281
  t283 = t28 ** 2
  t284 = t282 * t283
  t290 = f.p.cam_omega / t52 / t280 / t284 / t149 / 0.3e1
  t291 = t290 * t57
  t292 = t280 * t284
  t293 = t291 * t292
  t294 = t148 ** 2
  t295 = 0.1e1 / t294
  t296 = t151 ** 2
  t297 = 0.1e1 / t296
  t298 = t295 * t297
  t299 = t30 ** 2
  t300 = t298 * t299
  t302 = 0.1e1 / t32 / t31
  t303 = s0 ** 2
  t304 = t302 * t303
  t305 = t268 * t154
  t307 = 0.1e1 / t19 / t305
  t309 = t304 * t307 * t37
  t314 = t24 * t29
  t315 = t144 * t163 * t314
  t317 = t149 * t152 * t30
  t323 = t145 * t314
  t325 = 0.1e1 / t148 / t48
  t326 = t325 * t297
  t327 = t326 * t299
  t332 = 0.1e1 / t151 / t45
  t333 = t149 * t332
  t334 = t333 * t299
  t339 = 0.1e1 / t20 / t268
  t345 = t11 ** 2
  t348 = 0.1e1 / t56 / t345 / t39
  t353 = 0.55930665961450822902406623363317367836736000000007e-3 * t293 * t300 * t309 + 0.52554811346128920634666666666666666666666666666670e-2 * t315 * t317 * t275 * t156 * t11 - 0.24858073760644810178847388161474385705216000000003e-3 * t323 * t327 * t309 - 0.38455226604299414276328847308040620444444444444449e-3 * t323 * t334 * t309 + 0.28905146240370906349066666666666666666666666666669e-1 * t147 * t153 * t35 * s0 * t339 + 0.2e1 / 0.9e1 * t54 * t36 * t348 * t345
  t354 = f.my_piecewise3(t62, t353, 0)
  t357 = t169 ** 2
  t363 = 0.1e1 / t107 / t68
  t394 = 0.2e1 / 0.15e2 * t141 * t354 - 0.24e2 / 0.91e2 * t99 * t357 - 0.8e1 / 0.15e2 * t75 * t357 - 0.18e2 / 0.95e2 * t363 * t357 - 0.3e1 / 0.7e1 * t81 * t357 + 0.18e2 / 0.3515e4 * t234 * t354 + 0.18e2 / 0.55e2 * t90 * t357 + 0.10e2 / 0.21e2 * t78 * t357 + 0.34e2 / 0.171e3 * t114 * t357 - 0.2e1 / 0.9e1 * t237 * t354 + 0.11e2 / 0.39e2 * t96 * t357 - 0.26e2 / 0.2835e4 * t214 * t354 - 0.7e1 / 0.270e3 * t190 * t354 - 0.16e2 / 0.45e2 * t87 * t357 - 0.15e2 / 0.2108e4 * t222 * t354 - 0.11e2 / 0.897e3 * t206 * t354 + 0.16e2 / 0.765e3 * t194 * t354 - 0.3e1 / 0.35e2 * t174 * t354
  t431 = 0.26e2 / 0.105e3 * t102 * t357 + 0.10e2 / 0.693e3 * t202 * t354 + 0.2e1 / 0.3e1 * t66 * t357 + 0.32e2 / 0.5049e4 * t226 * t354 - 0.18e2 / 0.1045e4 * t198 * t354 + 0.3e1 / 0.91e2 * t186 * t354 - 0.10e2 / 0.231e3 * t182 * t354 + 0.3e1 / 0.5e1 * t72 * t357 - 0.10e2 / 0.33e2 * t93 * t357 + 0.7e1 / 0.870e3 * t218 * t354 + 0.7e1 / 0.18e2 * t84 * t357 - 0.34e2 / 0.5985e4 * t230 * t354 - 0.7e1 / 0.30e2 * t105 * t357 + 0.8e1 / 0.135e3 * t178 * t354 - 0.32e2 / 0.153e3 * t111 * t357 - 0.2e1 / 0.3e1 * t69 * t357 + 0.24e2 / 0.2275e4 * t210 * t354 + 0.15e2 / 0.68e2 * t108 * t357
  t433 = f.my_piecewise3(t62, 0, t353)
  t438 = t241 ** 2
  t442 = t123 * t433
  t444 = t121 ** 2
  t446 = 0.1e1 / t444 / t119
  t448 = t124 ** 2
  t449 = 0.1e1 / t448
  t464 = 0.1e1 / t444
  t465 = t122 * t464
  t469 = t433 * t244
  t473 = 0.1e1 / t444 / t121
  t474 = t122 * t473
  t478 = -0.2e1 * t119 * t433 * t125 + 0.8e1 * t123 * t438 * t244 - 0.6e1 * t465 * t438 * t244 + 0.4e1 * t474 * t438 * t449 - 0.2e1 * t438 * t125 + 0.2e1 * t252 * t469
  t481 = 0.2e1 * t251 * t438 * t244 - t442 * t244 - 0.2e1 * t446 * t438 * t449 + t433 * t127 / 0.4e1 + t241 * t256 / 0.2e1 + t119 * t478 / 0.4e1
  t485 = f.my_piecewise3(t61, t394 + t431, -0.8e1 / 0.3e1 * t433 * t130 - 0.16e2 / 0.3e1 * t241 * t259 - 0.8e1 / 0.3e1 * t119 * t481)
  t492 = t17 / t19 / t154
  t498 = t17 / t305
  t503 = t332 * t299 * t304 * t36
  t507 = f.my_piecewise3(t2, 0, t18 * t22 * t134 * t48 / 0.12e2 - t18 * t139 * t263 * t48 / 0.4e1 - 0.17737248829318510714200000000000000000000000000001e-1 * t6 * t271 * t134 * t277 - 0.3e1 / 0.8e1 * t18 * t19 * t485 * t48 + 0.11824832552879007142800000000000000000000000000001e-1 * t6 * t492 * t263 * t277 + 0.57682839906449121414493270962060930666666666666673e-3 * t6 * t498 * t134 * t503)
  t517 = t268 * r0
  t533 = t268 ** 2
  t540 = t345 * t11
  t551 = t304 / t19 / t533 * t37
  t563 = t299 * t302
  t567 = t303 * t307 * t11 * t37
  t575 = t31 ** 2
  t586 = 0.1e1 / t296 / t151
  t587 = t303 * s0
  t590 = 0.1e1 / t533 / t154
  t598 = t291 / t31 * t3 * t282
  t604 = t587 * t590 * t36
  t610 = 0.1e1 / t296 / t45
  t619 = t145 / t31 / jnp.pi * t23 * t27
  t657 = -0.14e2 / 0.27e2 * t54 * t36 / t56 / t154 + 0.27343881136709291196732126977621824275737600000004e-2 * t323 * t327 * t551 + 0.42300749264729355703961732038844682488888888888894e-2 * t323 * t334 * t551 - 0.28905146240370906349066666666666666666666666666668e-1 * t315 * t317 * t275 * t339 * t11 + 0.24858073760644810178847388161474385705216000000003e-3 * t315 * t326 * t563 * t567 + 0.38455226604299414276328847308040620444444444444449e-3 * t315 * t333 * t563 * t567 - 0.88182767942022069691365474915881624419890533341622e-4 * f.p.cam_omega / t52 / t575 / t325 * t57 / t294 / t148 * t586 * t587 * t590 * t36 + 0.63491592918255890177783141939434769582321184005969e-3 * t598 * t283 / t294 / t48 * t586 * t604 + 0.98220948921833448085726748625397220338483552396549e-3 * t598 * t283 * t295 * t610 * t604 - 0.14109242870723531150618475986541059907182485334660e-3 * t619 * t28 * t295 * t586 * t604 - 0.43653755076370421371434110500176542372659356620688e-3 * t619 * t28 * t325 * t610 * t604 - 0.33765992082784477311386251655417364648043486408666e-3 * t619 * t150 * t297 * t604 - 0.55930665961450822902406623363317367836736000000006e-3 * t290 * t163 * t292 * t298 * t563 * t567 - 0.13489068245506422962897777777777777777777777777779e0 * t147 * t153 * t35 * s0 / t20 / t517 - 0.61523732557595905192647285699649104620409600000008e-2 * t293 * t300 * t551 - 0.10510962269225784126933333333333333333333333333334e-1 * t144 * t348 * t314 * t317 * t275 * t156 * t345
  t658 = f.my_piecewise3(t62, t657, 0)
  t665 = t357 * t169
  t686 = -0.11e2 / 0.897e3 * t206 * t658 - 0.15e2 / 0.2108e4 * t222 * t658 + 0.24e2 / 0.2275e4 * t210 * t658 - 0.56e2 / 0.9e1 * t194 * t665 + 0.64e2 / 0.9e1 * t230 * t665 + 0.7e1 * t222 * t665 + 0.32e2 / 0.5049e4 * t226 * t658 + 0.2e1 / 0.15e2 * t141 * t658 - 0.88e2 / 0.13e2 * t210 * t665 - 0.136e3 / 0.19e2 * t234 * t665 + 0.18e2 / 0.3515e4 * t234 * t658 - 0.104e3 / 0.15e2 * t218 * t665 - 0.40e2 / 0.7e1 * t186 * t665
  t717 = 0.16e2 / 0.3e1 * t182 * t665 - 0.3e1 / 0.35e2 * t174 * t658 + 0.36e2 / 0.5e1 / t107 / t173 * t665 + 0.48e2 / 0.7e1 * t214 * t665 + 0.3e1 / 0.91e2 * t186 * t658 + 0.16e2 / 0.765e3 * t194 * t658 - 0.10e2 / 0.231e3 * t182 * t658 - 0.34e2 / 0.5985e4 * t230 * t658 + 0.32e2 / 0.5e1 * t198 * t665 + 0.4e1 * t174 * t665 - 0.72e2 / 0.11e2 * t202 * t665 + 0.8e1 / 0.135e3 * t178 * t658 + 0.7e1 / 0.870e3 * t218 * t658 - 0.18e2 / 0.1045e4 * t198 * t658
  t749 = -0.7e1 / 0.270e3 * t190 * t658 - 0.8e1 / 0.3e1 * t141 * t665 - 0.26e2 / 0.2835e4 * t214 * t658 - 0.24e2 / 0.5e1 * t178 * t665 - 0.2e1 / 0.9e1 * t237 * t658 - 0.120e3 / 0.17e2 * t226 * t665 + 0.6e1 * t190 * t665 + 0.20e2 / 0.3e1 * t206 * t665 + 0.10e2 / 0.693e3 * t202 * t658 - 0.9e1 / 0.7e1 * t81 * t169 * t354 - 0.54e2 / 0.95e2 * t363 * t354 * t169 - 0.16e2 / 0.15e2 * t87 * t354 * t169 + 0.9e1 / 0.5e1 * t72 * t354 * t169
  t792 = 0.7e1 / 0.6e1 * t84 * t354 * t169 + 0.34e2 / 0.57e2 * t114 * t169 * t354 + 0.10e2 / 0.7e1 * t78 * t169 * t354 - 0.10e2 / 0.11e2 * t93 * t354 * t169 - 0.8e1 / 0.5e1 * t75 * t169 * t354 - 0.7e1 / 0.10e2 * t105 * t169 * t354 + 0.11e2 / 0.13e2 * t96 * t354 * t169 + 0.45e2 / 0.68e2 * t108 * t354 * t169 + 0.26e2 / 0.35e2 * t102 * t169 * t354 - 0.72e2 / 0.91e2 * t99 * t354 * t169 - 0.2e1 * t69 * t354 * t169 + 0.54e2 / 0.55e2 * t90 * t169 * t354 + 0.2e1 * t66 * t169 * t354 - 0.32e2 / 0.51e2 * t111 * t354 * t169
  t795 = f.my_piecewise3(t62, 0, t657)
  t802 = t438 * t241
  t818 = t444 ** 2
  t822 = 0.1e1 / t448 / t124
  t871 = -0.6e1 * t241 * t125 * t433 - 0.24e2 * t802 * t251 * t244 - 0.2e1 * t119 * t795 * t125 + 0.24e2 * t442 * t253 + 0.24e2 * t446 * t802 * t449 + 0.24e2 * t122 * t446 * t802 * t244 - 0.18e2 * t465 * t253 * t433 - 0.36e2 * t122 / t444 / t250 * t802 * t449 + 0.2e1 * t252 * t795 * t244 + 0.12e2 * t474 * t433 * t449 * t241 + 0.16e2 * t122 / t818 / t119 * t802 * t822
  t878 = f.my_piecewise3(t61, t686 + t717 + t749 + t792, -0.8e1 / 0.3e1 * t795 * t130 - 0.8e1 * t433 * t259 - 0.8e1 * t241 * t481 - 0.8e1 / 0.3e1 * t119 * (-0.6e1 * t464 * t802 * t244 + 0.6e1 * t251 * t241 * t469 + 0.14e2 * t473 * t802 * t449 - t123 * t795 * t244 - 0.6e1 * t446 * t433 * t449 * t241 - 0.8e1 / t818 * t802 * t822 + t795 * t127 / 0.4e1 + 0.3e1 / 0.4e1 * t433 * t256 + 0.3e1 / 0.4e1 * t241 * t478 + t119 * t871 / 0.4e1))
  t904 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t18 * t41 * t134 * t48 + t18 * t22 * t263 * t48 / 0.4e1 + 0.75547541310060323412333333333333333333333333333337e-1 * t6 * t17 / t19 / t517 * t134 * t277 - 0.3e1 / 0.8e1 * t18 * t139 * t485 * t48 - 0.53211746487955532142600000000000000000000000000004e-1 * t6 * t271 * t263 * t277 - 0.57682839906449121414493270962060930666666666666673e-2 * t6 * t17 / t533 * t134 * t503 - 0.3e1 / 0.8e1 * t18 * t19 * t878 * t48 + 0.17737248829318510714200000000000000000000000000001e-1 * t6 * t492 * t485 * t277 + 0.17304851971934736424347981288618279200000000000002e-2 * t6 * t498 * t263 * t503 + 0.50648988124176715967079377483126046972065229612999e-3 * t3 / t4 / t575 * t17 / t20 / t533 / t39 * t134 * t297 * t587)
  v3rho3_0_ = 0.2e1 * r0 * t904 + 0.6e1 * t507

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** 2
  t20 = r0 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t23 = 0.1e1 / t21 / t19
  t24 = t3 ** 2
  t25 = jnp.pi * t24
  t26 = 0.1e1 / jnp.pi
  t27 = t26 ** (0.1e1 / 0.3e1)
  t28 = 0.1e1 / t27
  t29 = 4 ** (0.1e1 / 0.3e1)
  t30 = t28 * t29
  t31 = 6 ** (0.1e1 / 0.3e1)
  t32 = jnp.pi ** 2
  t33 = t32 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t35 = 0.1e1 / t34
  t36 = t31 * t35
  t37 = 2 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t43 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t36 * s0 * t38 * t23
  t46 = 0.18040e1 - 0.64641600e0 / t43
  t49 = t25 * t30 / t46
  t50 = jnp.sqrt(t49)
  t52 = f.p.cam_omega / t50
  t53 = t11 * r0
  t54 = t53 ** (0.1e1 / 0.3e1)
  t55 = 0.1e1 / t54
  t58 = t52 * t37 * t55 / 0.2e1
  t59 = 0.192e1 <= t58
  t60 = 0.192e1 < t58
  t61 = f.my_piecewise3(t60, t58, 0.192e1)
  t62 = t61 ** 2
  t63 = t62 ** 2
  t64 = 0.1e1 / t63
  t66 = t63 * t62
  t67 = 0.1e1 / t66
  t69 = t63 ** 2
  t70 = 0.1e1 / t69
  t72 = t69 * t62
  t73 = 0.1e1 / t72
  t75 = t69 * t63
  t76 = 0.1e1 / t75
  t78 = t69 * t66
  t79 = 0.1e1 / t78
  t81 = t69 ** 2
  t82 = 0.1e1 / t81
  t85 = 0.1e1 / t81 / t62
  t88 = 0.1e1 / t81 / t63
  t91 = 0.1e1 / t81 / t66
  t94 = 0.1e1 / t81 / t69
  t97 = 0.1e1 / t81 / t72
  t100 = 0.1e1 / t81 / t75
  t103 = 0.1e1 / t81 / t78
  t105 = t81 ** 2
  t106 = 0.1e1 / t105
  t109 = 0.1e1 / t105 / t62
  t112 = 0.1e1 / t105 / t63
  t116 = -t64 / 0.30e2 + t67 / 0.70e2 - t70 / 0.135e3 + t73 / 0.231e3 - t76 / 0.364e3 + t79 / 0.540e3 - t82 / 0.765e3 + t85 / 0.1045e4 - t88 / 0.1386e4 + t91 / 0.1794e4 - t94 / 0.2275e4 + t97 / 0.2835e4 - t100 / 0.3480e4 + t103 / 0.4216e4 - t106 / 0.5049e4 + t109 / 0.5985e4 - t112 / 0.7030e4 + 0.1e1 / t62 / 0.9e1
  t117 = f.my_piecewise3(t60, 0.192e1, t58)
  t118 = jnp.atan2(0.1e1, t117)
  t119 = t117 ** 2
  t120 = t119 + 0.3e1
  t121 = 0.1e1 / t119
  t122 = 0.1e1 + t121
  t123 = jnp.log(t122)
  t125 = -t120 * t123 + 0.1e1
  t128 = t118 + t117 * t125 / 0.4e1
  t132 = f.my_piecewise3(t59, t116, 0.1e1 - 0.8e1 / 0.3e1 * t117 * t128)
  t138 = 0.1e1 / t21 / r0
  t139 = t63 * t61
  t140 = 0.1e1 / t139
  t143 = f.p.cam_omega / t50 / t49
  t144 = t143 * t55
  t146 = t144 * t25 * t28
  t147 = t46 ** 2
  t148 = 0.1e1 / t147
  t149 = t29 * t148
  t150 = t43 ** 2
  t151 = 0.1e1 / t150
  t152 = t149 * t151
  t153 = t19 * r0
  t155 = 0.1e1 / t21 / t153
  t158 = t152 * t36 * s0 * t155
  t162 = 0.1e1 / t54 / t53
  t167 = -0.78832217019193380952000000000000000000000000000005e-2 * t146 * t158 - t52 * t37 * t162 * t11 / 0.6e1
  t168 = f.my_piecewise3(t60, t167, 0)
  t171 = t62 * t61
  t172 = t63 * t171
  t173 = 0.1e1 / t172
  t176 = t69 * t61
  t177 = 0.1e1 / t176
  t180 = t69 * t171
  t181 = 0.1e1 / t180
  t184 = t69 * t139
  t185 = 0.1e1 / t184
  t188 = t69 * t172
  t189 = 0.1e1 / t188
  t193 = 0.1e1 / t81 / t61
  t197 = 0.1e1 / t81 / t171
  t201 = 0.1e1 / t81 / t139
  t205 = 0.1e1 / t81 / t172
  t209 = 0.1e1 / t81 / t176
  t213 = 0.1e1 / t81 / t180
  t217 = 0.1e1 / t81 / t184
  t221 = 0.1e1 / t81 / t188
  t225 = 0.1e1 / t105 / t61
  t229 = 0.1e1 / t105 / t171
  t233 = 0.1e1 / t105 / t139
  t236 = 0.1e1 / t171
  t239 = 0.2e1 / 0.15e2 * t140 * t168 - 0.3e1 / 0.35e2 * t173 * t168 + 0.8e1 / 0.135e3 * t177 * t168 - 0.10e2 / 0.231e3 * t181 * t168 + 0.3e1 / 0.91e2 * t185 * t168 - 0.7e1 / 0.270e3 * t189 * t168 + 0.16e2 / 0.765e3 * t193 * t168 - 0.18e2 / 0.1045e4 * t197 * t168 + 0.10e2 / 0.693e3 * t201 * t168 - 0.11e2 / 0.897e3 * t205 * t168 + 0.24e2 / 0.2275e4 * t209 * t168 - 0.26e2 / 0.2835e4 * t213 * t168 + 0.7e1 / 0.870e3 * t217 * t168 - 0.15e2 / 0.2108e4 * t221 * t168 + 0.32e2 / 0.5049e4 * t225 * t168 - 0.34e2 / 0.5985e4 * t229 * t168 + 0.18e2 / 0.3515e4 * t233 * t168 - 0.2e1 / 0.9e1 * t236 * t168
  t240 = f.my_piecewise3(t60, 0, t167)
  t243 = 0.1e1 / t122
  t249 = t119 * t117
  t250 = 0.1e1 / t249
  t251 = t120 * t250
  t252 = t240 * t243
  t255 = -0.2e1 * t117 * t240 * t123 + 0.2e1 * t251 * t252
  t258 = -t121 * t240 * t243 + t240 * t125 / 0.4e1 + t117 * t255 / 0.4e1
  t262 = f.my_piecewise3(t59, t239, -0.8e1 / 0.3e1 * t117 * t258 - 0.8e1 / 0.3e1 * t240 * t128)
  t267 = t19 ** 2
  t268 = t267 * r0
  t271 = t17 / t20 / t268
  t275 = t35 * s0
  t277 = t151 * t31 * t275 * t38
  t280 = 0.1e1 / t21
  t281 = t168 ** 2
  t286 = t32 * t3
  t287 = t27 ** 2
  t288 = 0.1e1 / t287
  t289 = t29 ** 2
  t290 = t288 * t289
  t296 = f.p.cam_omega / t50 / t286 / t290 / t148 / 0.3e1
  t297 = t296 * t55
  t298 = t286 * t290
  t299 = t297 * t298
  t300 = t147 ** 2
  t301 = 0.1e1 / t300
  t302 = t150 ** 2
  t303 = 0.1e1 / t302
  t304 = t301 * t303
  t305 = t31 ** 2
  t306 = t304 * t305
  t308 = 0.1e1 / t33 / t32
  t309 = s0 ** 2
  t310 = t308 * t309
  t311 = t267 * t153
  t313 = 0.1e1 / t20 / t311
  t315 = t310 * t313 * t38
  t319 = t143 * t162
  t320 = t25 * t30
  t321 = t319 * t320
  t323 = t148 * t151 * t31
  t329 = t144 * t320
  t330 = t147 * t46
  t331 = 0.1e1 / t330
  t332 = t331 * t303
  t333 = t332 * t305
  t337 = t150 * t43
  t338 = 0.1e1 / t337
  t339 = t148 * t338
  t340 = t339 * t305
  t345 = 0.1e1 / t21 / t267
  t351 = t11 ** 2
  t354 = 0.1e1 / t54 / t351 / t19
  t359 = 0.55930665961450822902406623363317367836736000000007e-3 * t299 * t306 * t315 + 0.52554811346128920634666666666666666666666666666670e-2 * t321 * t323 * t275 * t155 * t11 - 0.24858073760644810178847388161474385705216000000003e-3 * t329 * t333 * t315 - 0.38455226604299414276328847308040620444444444444449e-3 * t329 * t340 * t315 + 0.28905146240370906349066666666666666666666666666669e-1 * t146 * t152 * t36 * s0 * t345 + 0.2e1 / 0.9e1 * t52 * t37 * t354 * t351
  t360 = f.my_piecewise3(t60, t359, 0)
  t385 = t193 * t360
  t393 = 0.2e1 / 0.3e1 * t64 * t281 - 0.8e1 / 0.15e2 * t73 * t281 - 0.18e2 / 0.1045e4 * t197 * t360 + 0.11e2 / 0.39e2 * t94 * t281 + 0.34e2 / 0.171e3 * t112 * t281 - 0.34e2 / 0.5985e4 * t229 * t360 + 0.3e1 / 0.91e2 * t185 * t360 + 0.15e2 / 0.68e2 * t106 * t281 - 0.3e1 / 0.7e1 * t79 * t281 - 0.7e1 / 0.270e3 * t189 * t360 + 0.26e2 / 0.105e3 * t100 * t281 - 0.11e2 / 0.897e3 * t205 * t360 - 0.2e1 / 0.3e1 * t67 * t281 + 0.2e1 / 0.15e2 * t140 * t360 + 0.16e2 / 0.765e3 * t385 - 0.15e2 / 0.2108e4 * t221 * t360 + 0.24e2 / 0.2275e4 * t209 * t360 + 0.7e1 / 0.18e2 * t82 * t281
  t414 = t173 * t360
  t421 = 0.1e1 / t105 / t66
  t432 = 0.18e2 / 0.3515e4 * t233 * t360 + 0.8e1 / 0.135e3 * t177 * t360 - 0.7e1 / 0.30e2 * t103 * t281 + 0.3e1 / 0.5e1 * t70 * t281 - 0.32e2 / 0.153e3 * t109 * t281 + 0.7e1 / 0.870e3 * t217 * t360 - 0.2e1 / 0.9e1 * t236 * t360 - 0.26e2 / 0.2835e4 * t213 * t360 - 0.24e2 / 0.91e2 * t97 * t281 - 0.10e2 / 0.33e2 * t91 * t281 - 0.3e1 / 0.35e2 * t414 + 0.10e2 / 0.21e2 * t76 * t281 + 0.18e2 / 0.55e2 * t88 * t281 - 0.18e2 / 0.95e2 * t421 * t281 + 0.10e2 / 0.693e3 * t201 * t360 - 0.10e2 / 0.231e3 * t181 * t360 - 0.16e2 / 0.45e2 * t85 * t281 + 0.32e2 / 0.5049e4 * t225 * t360
  t434 = f.my_piecewise3(t60, 0, t359)
  t439 = t240 ** 2
  t440 = t250 * t439
  t443 = t121 * t434
  t445 = t119 ** 2
  t447 = 0.1e1 / t445 / t117
  t449 = t122 ** 2
  t450 = 0.1e1 / t449
  t465 = 0.1e1 / t445
  t466 = t120 * t465
  t467 = t439 * t243
  t470 = t434 * t243
  t474 = 0.1e1 / t445 / t119
  t475 = t120 * t474
  t476 = t439 * t450
  t479 = -0.2e1 * t117 * t434 * t123 + 0.8e1 * t121 * t439 * t243 - 0.2e1 * t439 * t123 + 0.2e1 * t251 * t470 - 0.6e1 * t466 * t467 + 0.4e1 * t475 * t476
  t482 = 0.2e1 * t440 * t243 - t443 * t243 - 0.2e1 * t447 * t439 * t450 + t434 * t125 / 0.4e1 + t240 * t255 / 0.2e1 + t117 * t479 / 0.4e1
  t486 = f.my_piecewise3(t59, t393 + t432, -0.8e1 / 0.3e1 * t434 * t128 - 0.16e2 / 0.3e1 * t240 * t258 - 0.8e1 / 0.3e1 * t117 * t482)
  t493 = t17 / t20 / t267
  t498 = t267 ** 2
  t500 = t17 / t498
  t505 = t338 * t305 * t310 * t37
  t508 = t351 * t11
  t511 = 0.1e1 / t54 / t508 / t153
  t517 = 0.1e1 / t20 / t498
  t519 = t310 * t517 * t38
  t526 = t296 * t162
  t527 = t526 * t298
  t528 = t305 * t308
  t529 = t304 * t528
  t530 = t309 * t313
  t531 = t38 * t11
  t532 = t530 * t531
  t536 = t32 ** 2
  t541 = f.p.cam_omega / t50 / t536 / t331 / 0.36e2
  t543 = 0.1e1 / t300 / t147
  t545 = t541 * t55 * t543
  t547 = 0.1e1 / t302 / t150
  t548 = t309 * s0
  t549 = t547 * t548
  t550 = t498 * t153
  t551 = 0.1e1 / t550
  t552 = t551 * t37
  t558 = 0.1e1 / t32 * t3 * t288
  t559 = t297 * t558
  t561 = 0.1e1 / t300 / t46
  t562 = t289 * t561
  t563 = t562 * t547
  t564 = t548 * t551
  t565 = t564 * t37
  t569 = t289 * t301
  t571 = 0.1e1 / t302 / t43
  t572 = t569 * t571
  t579 = 0.1e1 / t32 / jnp.pi * t24 * t28
  t580 = t144 * t579
  t581 = t29 * t301
  t582 = t581 * t547
  t586 = t29 * t331
  t587 = t586 * t571
  t591 = t149 * t303
  t600 = t332 * t528
  t604 = t339 * t528
  t609 = 0.1e1 / t21 / t268
  t619 = t143 * t354 * t320
  t625 = -0.14e2 / 0.27e2 * t52 * t37 * t511 * t508 + 0.27343881136709291196732126977621824275737600000004e-2 * t329 * t333 * t519 + 0.42300749264729355703961732038844682488888888888894e-2 * t329 * t340 * t519 - 0.55930665961450822902406623363317367836736000000006e-3 * t527 * t529 * t532 - 0.31745796459127945088891570969717384791160592002984e-2 * t545 * t549 * t552 + 0.63491592918255890177783141939434769582321184005969e-3 * t559 * t563 * t565 + 0.98220948921833448085726748625397220338483552396549e-3 * t559 * t572 * t565 - 0.14109242870723531150618475986541059907182485334660e-3 * t580 * t582 * t565 - 0.43653755076370421371434110500176542372659356620688e-3 * t580 * t587 * t565 - 0.33765992082784477311386251655417364648043486408666e-3 * t580 * t591 * t565 - 0.28905146240370906349066666666666666666666666666668e-1 * t321 * t323 * t275 * t345 * t11 + 0.24858073760644810178847388161474385705216000000003e-3 * t321 * t600 * t532 + 0.38455226604299414276328847308040620444444444444449e-3 * t321 * t604 * t532 - 0.13489068245506422962897777777777777777777777777779e0 * t146 * t152 * t36 * s0 * t609 - 0.61523732557595905192647285699649104620409600000008e-2 * t299 * t306 * t519 - 0.10510962269225784126933333333333333333333333333334e-1 * t619 * t323 * t275 * t155 * t351
  t626 = f.my_piecewise3(t60, t625, 0)
  t629 = t281 * t168
  t654 = 0.16e2 / 0.765e3 * t193 * t626 + 0.6e1 * t189 * t629 - 0.11e2 / 0.897e3 * t205 * t626 - 0.7e1 / 0.270e3 * t189 * t626 + 0.16e2 / 0.3e1 * t181 * t629 + 0.32e2 / 0.5049e4 * t225 * t626 - 0.136e3 / 0.19e2 * t233 * t629 - 0.34e2 / 0.5985e4 * t229 * t626 - 0.88e2 / 0.13e2 * t209 * t629 - 0.56e2 / 0.9e1 * t193 * t629 + 0.2e1 / 0.15e2 * t140 * t626 - 0.40e2 / 0.7e1 * t185 * t629 + 0.7e1 / 0.870e3 * t217 * t626
  t658 = 0.1e1 / t105 / t172
  t685 = -0.72e2 / 0.11e2 * t201 * t629 + 0.36e2 / 0.5e1 * t658 * t629 + 0.64e2 / 0.9e1 * t229 * t629 - 0.18e2 / 0.1045e4 * t197 * t626 + 0.3e1 / 0.91e2 * t185 * t626 - 0.8e1 / 0.3e1 * t140 * t629 + 0.10e2 / 0.693e3 * t201 * t626 - 0.26e2 / 0.2835e4 * t213 * t626 - 0.2e1 / 0.9e1 * t236 * t626 + 0.8e1 / 0.135e3 * t177 * t626 - 0.10e2 / 0.231e3 * t181 * t626 + 0.20e2 / 0.3e1 * t205 * t629 - 0.24e2 / 0.5e1 * t177 * t629 - 0.104e3 / 0.15e2 * t217 * t629
  t714 = t91 * t168
  t717 = 0.4e1 * t173 * t629 - 0.120e3 / 0.17e2 * t225 * t629 + 0.48e2 / 0.7e1 * t213 * t629 + 0.18e2 / 0.3515e4 * t233 * t626 + 0.24e2 / 0.2275e4 * t209 * t626 - 0.3e1 / 0.35e2 * t173 * t626 + 0.32e2 / 0.5e1 * t197 * t629 + 0.7e1 * t221 * t629 - 0.15e2 / 0.2108e4 * t221 * t626 + 0.34e2 / 0.57e2 * t112 * t168 * t360 + 0.9e1 / 0.5e1 * t70 * t168 * t360 - 0.54e2 / 0.95e2 * t421 * t168 * t360 - 0.10e2 / 0.11e2 * t714 * t360
  t736 = t64 * t168
  t751 = t79 * t168
  t760 = -0.2e1 * t67 * t360 * t168 + 0.7e1 / 0.6e1 * t82 * t360 * t168 + 0.54e2 / 0.55e2 * t88 * t168 * t360 - 0.16e2 / 0.15e2 * t85 * t168 * t360 - 0.32e2 / 0.51e2 * t109 * t168 * t360 - 0.8e1 / 0.5e1 * t73 * t360 * t168 + 0.2e1 * t736 * t360 + 0.26e2 / 0.35e2 * t100 * t360 * t168 - 0.7e1 / 0.10e2 * t103 * t168 * t360 + 0.11e2 / 0.13e2 * t94 * t168 * t360 + 0.45e2 / 0.68e2 * t106 * t168 * t360 - 0.9e1 / 0.7e1 * t751 * t360 + 0.10e2 / 0.7e1 * t76 * t360 * t168 - 0.72e2 / 0.91e2 * t97 * t360 * t168
  t763 = f.my_piecewise3(t60, 0, t625)
  t770 = t439 * t240
  t774 = t250 * t240
  t780 = t121 * t763
  t782 = t447 * t434
  t783 = t450 * t240
  t786 = t445 ** 2
  t787 = 0.1e1 / t786
  t790 = 0.1e1 / t449 / t122
  t799 = t240 * t123
  t813 = t120 * t447
  t821 = 0.1e1 / t445 / t249
  t822 = t120 * t821
  t826 = t763 * t243
  t829 = t434 * t450
  t834 = 0.1e1 / t786 / t117
  t835 = t120 * t834
  t839 = -0.2e1 * t117 * t763 * t123 + 0.12e2 * t475 * t829 * t240 - 0.24e2 * t770 * t250 * t243 + 0.24e2 * t813 * t770 * t243 - 0.18e2 * t466 * t252 * t434 + 0.24e2 * t447 * t770 * t450 - 0.36e2 * t822 * t770 * t450 + 0.16e2 * t835 * t770 * t790 + 0.2e1 * t251 * t826 + 0.24e2 * t443 * t252 - 0.6e1 * t799 * t434
  t842 = -0.6e1 * t465 * t770 * t243 + 0.6e1 * t774 * t470 + 0.14e2 * t474 * t770 * t450 - t780 * t243 - 0.6e1 * t782 * t783 - 0.8e1 * t787 * t770 * t790 + t763 * t125 / 0.4e1 + 0.3e1 / 0.4e1 * t434 * t255 + 0.3e1 / 0.4e1 * t240 * t479 + t117 * t839 / 0.4e1
  t846 = f.my_piecewise3(t59, t654 + t685 + t717 + t760, -0.8e1 / 0.3e1 * t763 * t128 - 0.8e1 * t434 * t258 - 0.8e1 * t240 * t482 - 0.8e1 / 0.3e1 * t117 * t842)
  t853 = t17 / t20 / t153
  t859 = t17 / t311
  t866 = t3 / t4 / t536
  t867 = t866 * t17
  t870 = 0.1e1 / t21 / t498 / t19
  t872 = t303 * t548
  t877 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t18 * t23 * t132 * t46 + t18 * t138 * t262 * t46 / 0.4e1 + 0.75547541310060323412333333333333333333333333333337e-1 * t6 * t271 * t132 * t277 - 0.3e1 / 0.8e1 * t18 * t280 * t486 * t46 - 0.53211746487955532142600000000000000000000000000004e-1 * t6 * t493 * t262 * t277 - 0.57682839906449121414493270962060930666666666666673e-2 * t6 * t500 * t132 * t505 - 0.3e1 / 0.8e1 * t18 * t20 * t846 * t46 + 0.17737248829318510714200000000000000000000000000001e-1 * t6 * t853 * t486 * t277 + 0.17304851971934736424347981288618279200000000000002e-2 * t6 * t859 * t262 * t505 + 0.50648988124176715967079377483126046972065229612999e-3 * t867 * t870 * t132 * t872)
  t913 = t267 * t19
  t914 = t498 * t913
  t920 = t309 ** 2
  t926 = t498 * r0
  t953 = t530 * t351 * t38
  t958 = t309 * t517 * t531
  t977 = 0.1e1 / t498 / t267
  t982 = t319 * t579
  t984 = t564 * t37 * t11
  t989 = t302 ** 2
  t990 = 0.1e1 / t989
  t993 = 0.1e1 / t21 / t914
  t995 = t920 * t993 * t36
  t1000 = 0.1e1 / t302 / t337
  t1005 = t526 * t558
  t1023 = t300 ** 2
  t1046 = t310 / t20 / t926 * t38
  t1058 = -0.10254727094479843807021025948810832118518518518520e-2 * t619 * t604 * t953 - 0.36458508182279054928976169303495765700983466666672e-2 * t321 * t600 * t958 - 0.56400999019639140938615642718459576651851851851858e-2 * t321 * t604 * t958 + 0.14914844256386886107308432896884631423129600000002e-2 * t296 * t354 * t298 * t529 * t953 + 0.82031643410127873590196380932865472827212800000009e-2 * t527 * t529 * t958 - 0.66288196695052827143593035097265028547242666666675e-3 * t619 * t600 * t953 + 0.69840752210081479195561456133378246540553302406564e-1 * t545 * t549 * t977 * t37 + 0.45021322777045969748515002207223152864057981878221e-3 * t982 * t591 * t984 + 0.12012439276382951822766143807787334711549446204968e-3 * t559 * t289 * t543 * t990 * t995 + 0.37166280773937996035884457710784803320305952219526e-3 * t559 * t562 * t1000 * t995 - 0.84655457224341186903710855919246359443094912007958e-3 * t1005 * t563 * t984 - 0.13096126522911126411430233150052962711797806986206e-2 * t1005 * t572 * t984 + 0.97323003396621137452966442887165906227831161382850e-5 * f.p.cam_omega / t50 / t536 * t27 * t26 / t29 / t301 * t55 / t1023 * t990 * t920 * t993 * jnp.pi * t30 * t36 - 0.65885696288171862798194994066139649284435010525740e-4 * t580 * t149 * t571 * t995 + 0.17985424327341897283863703703703703703703703703704e0 * t321 * t323 * t275 * t609 * t11 - 0.41830740939565696196139935016190852683456790123462e-1 * t329 * t340 * t1046 + 0.77080389974322416930844444444444444444444444444449e-1 * t619 * t323 * t275 * t345 * t351 + 0.60840135529178172912728982525208559013516160000008e-1 * t299 * t306 * t1046
  t1062 = t351 ** 2
  t1071 = t548 * t977 * t37
  t1100 = t993 * t31 * t35
  t1144 = -0.27040060235190299072323992233426026228229404444448e-1 * t329 * t333 * t1046 + 0.140e3 / 0.81e2 * t52 * t37 / t54 / t267 - 0.13968150442016295839112291226675649308110660481313e-1 * t559 * t563 * t1071 + 0.31040334315591768531360647170390331795801467736252e-2 * t580 * t582 * t1071 + 0.96038261168014927017155043100388393219850584565515e-2 * t580 * t587 * t1071 - 0.21608608762803358578859884697587388474466381527241e-1 * t559 * t572 * t1071 + 0.74285182582125850085049753641918202225695670099066e-2 * t580 * t591 * t1071 + 0.32700771504257995061570370370370370370370370370372e-1 * t143 * t511 * t508 * jnp.pi * t24 * t28 * t158 - 0.12012439276382951822766143807787334711549446204968e-2 * t541 * t55 / t300 / t330 * t990 * t920 * t1100 - 0.18583140386968998017942228855392401660152976109763e-2 * t545 * t1000 * t920 * t1100 + 0.42327728612170593451855427959623179721547456003978e-2 * t541 * t162 * t543 * t549 * t552 * t11 + 0.28747958569975059432226660316873966083996955690705e-3 * t559 * t569 * t547 * t995 + 0.18812323827631374867491301315388079876243313779547e-3 * t982 * t582 * t984 - 0.17796206335382150848542435270796051424517698081436e-4 * t580 * t29 * t561 * t990 * t995 - 0.82591735053195546746409906023966229600679893821169e-4 * t580 * t581 * t1000 * t995 + 0.76438053391203063456420740740740740740740740740748e0 * t146 * t152 * t36 * s0 / t21 / t913 + 0.58205006768493895161912147333568723163545808827584e-3 * t982 * t587 * t984 - 0.12776870475544470858767404585277318259554202529202e-3 * t580 * t586 * t547 * t995
  t1145 = t1058 + t1144
  t1146 = f.my_piecewise3(t60, t1145, 0)
  t1149 = t360 ** 2
  t1152 = t281 ** 2
  t1171 = -0.7e1 / 0.270e3 * t189 * t1146 - 0.9e1 / 0.7e1 * t79 * t1149 - 0.2240e4 / 0.9e1 * t112 * t1152 + 0.2e1 / 0.15e2 * t140 * t1146 + 0.24e2 / 0.2275e4 * t209 * t1146 - 0.176e3 / 0.3e1 * t76 * t1152 + 0.40e2 / 0.3e1 * t67 * t1152 - 0.16e2 / 0.15e2 * t85 * t1149 + 0.3016e4 / 0.15e2 * t103 * t1152 - 0.7e1 / 0.10e2 * t103 * t1149 - 0.3e1 / 0.35e2 * t173 * t1146
  t1196 = -0.15e2 / 0.2108e4 * t221 * t1146 - 0.1404e4 / 0.5e1 / t105 / t69 * t1152 - 0.72e2 / 0.91e2 * t97 * t1149 + 0.7e1 / 0.870e3 * t217 * t1146 + 0.7e1 / 0.6e1 * t82 * t1149 + 0.45e2 / 0.68e2 * t106 * t1149 + 0.1512e4 / 0.11e2 * t91 * t1152 + 0.18e2 / 0.3515e4 * t233 * t1146 - 0.18e2 / 0.1045e4 * t197 * t1146 + 0.8e1 / 0.135e3 * t177 * t1146 + 0.10e2 / 0.693e3 * t201 * t1146
  t1220 = -0.10e2 / 0.11e2 * t91 * t1149 + 0.5032e4 / 0.19e2 * t421 * t1152 + 0.34e2 / 0.57e2 * t112 * t1149 - 0.1296e4 / 0.7e1 * t100 * t1152 + 0.11e2 / 0.13e2 * t94 * t1149 - 0.90e2 * t82 * t1152 + 0.216e3 / 0.5e1 * t73 * t1152 - 0.460e3 / 0.3e1 * t94 * t1152 + 0.3960e4 / 0.17e2 * t109 * t1152 + 0.2e1 * t64 * t1149 - 0.8e1 / 0.5e1 * t73 * t1149
  t1252 = 0.2200e4 / 0.13e2 * t97 * t1152 + 0.54e2 / 0.55e2 * t88 * t1149 + 0.952e3 / 0.9e1 * t85 * t1152 + 0.128e3 / 0.3e1 * t229 * t281 * t360 + 0.72e2 / 0.55e2 * t88 * t626 * t168 + 0.24e2 * t414 * t281 - 0.528e3 / 0.13e2 * t209 * t281 * t360 + 0.8e1 / 0.3e1 * t736 * t626 + 0.288e3 / 0.7e1 * t213 * t281 * t360 - 0.144e3 / 0.5e1 * t177 * t281 * t360 + 0.216e3 / 0.5e1 * t658 * t281 * t360 - 0.816e3 / 0.19e2 * t233 * t281 * t360
  t1287 = 0.136e3 / 0.171e3 * t112 * t626 * t168 + 0.40e2 * t205 * t281 * t360 - 0.240e3 / 0.7e1 * t185 * t281 * t360 + 0.36e2 * t189 * t281 * t360 + 0.44e2 / 0.39e2 * t94 * t626 * t168 - 0.14e2 / 0.15e2 * t103 * t626 * t168 - 0.208e3 / 0.5e1 * t217 * t281 * t360 + 0.40e2 / 0.21e2 * t76 * t626 * t168 - 0.16e2 * t140 * t281 * t360 - 0.72e2 / 0.95e2 * t421 * t626 * t168 - 0.112e3 / 0.3e1 * t385 * t281
  t1320 = 0.192e3 / 0.5e1 * t197 * t281 * t360 + 0.42e2 * t221 * t281 * t360 - 0.128e3 / 0.153e3 * t109 * t626 * t168 - 0.32e2 / 0.15e2 * t73 * t626 * t168 + 0.15e2 / 0.17e2 * t106 * t626 * t168 - 0.40e2 / 0.33e2 * t714 * t626 + 0.14e2 / 0.9e1 * t82 * t626 * t168 - 0.720e3 / 0.17e2 * t225 * t281 * t360 - 0.432e3 / 0.11e2 * t201 * t281 * t360 + 0.32e2 * t181 * t281 * t360 + 0.12e2 / 0.5e1 * t70 * t626 * t168
  t1348 = 0.104e3 / 0.105e3 * t100 * t626 * t168 - 0.64e2 / 0.45e2 * t85 * t626 * t168 - 0.96e2 / 0.91e2 * t97 * t626 * t168 - 0.8e1 / 0.3e1 * t67 * t626 * t168 - 0.12e2 / 0.7e1 * t751 * t626 - 0.34e2 / 0.5985e4 * t229 * t1146 - 0.2e1 / 0.9e1 * t236 * t1146 + 0.26e2 / 0.35e2 * t100 * t1149 + 0.9e1 / 0.5e1 * t70 * t1149 + 0.10e2 / 0.7e1 * t76 * t1149 - 0.28e2 * t70 * t1152
  t1373 = 0.16e2 / 0.765e3 * t193 * t1146 - 0.26e2 / 0.2835e4 * t213 * t1146 + 0.32e2 / 0.5049e4 * t225 * t1146 - 0.11e2 / 0.897e3 * t205 * t1146 - 0.10e2 / 0.231e3 * t181 * t1146 - 0.217e3 * t106 * t1152 - 0.608e3 / 0.5e1 * t88 * t1152 - 0.2e1 * t67 * t1149 + 0.520e3 / 0.7e1 * t79 * t1152 - 0.32e2 / 0.51e2 * t109 * t1149 - 0.54e2 / 0.95e2 * t421 * t1149 + 0.3e1 / 0.91e2 * t185 * t1146
  t1377 = f.my_piecewise3(t60, 0, t1145)
  t1386 = t434 ** 2
  t1401 = t439 ** 2
  t1425 = t449 ** 2
  t1426 = 0.1e1 / t1425
  t1446 = 0.2e1 * t251 * t1377 * t243 - 0.288e3 * t120 / t786 / t119 * t1401 * t790 + 0.144e3 * t782 * t476 - 0.6e1 * t1386 * t123 - 0.8e1 * t799 * t763 + 0.96e2 * t120 / t786 / t445 * t1401 * t1426 + 0.300e3 * t120 * t787 * t1401 * t450 + 0.16e2 * t475 * t763 * t450 * t240 + 0.24e2 * t121 * t1386 * t243 + 0.32e2 * t780 * t252 - 0.240e3 * t1401 * t474 * t450
  t1480 = 0.96e2 * t835 * t434 * t790 * t439 - 0.2e1 * t117 * t1377 * t123 - 0.18e2 * t466 * t1386 * t243 + 0.12e2 * t475 * t1386 * t450 + 0.120e3 * t1401 * t465 * t243 - 0.120e3 * t475 * t1401 * t243 + 0.128e3 * t787 * t1401 * t790 - 0.24e2 * t466 * t252 * t763 + 0.144e3 * t813 * t467 * t434 - 0.216e3 * t822 * t476 * t434 - 0.144e3 * t440 * t470
  t1508 = -0.6e1 * t447 * t1386 * t450 - 0.48e2 * t787 * t434 * t790 * t439 - 0.8e1 * t447 * t763 * t783 + 0.84e2 * t474 * t439 * t829 + t240 * t839 + 0.120e3 * t834 * t1401 * t790 - t121 * t1377 * t243 + t117 * (t1446 + t1480) / 0.4e1 - 0.48e2 / t786 / t249 * t1401 * t1426 + t1377 * t125 / 0.4e1 - 0.96e2 * t821 * t1401 * t450 + 0.3e1 / 0.2e1 * t434 * t479 + 0.6e1 * t250 * t1386 * t243 + 0.8e1 * t774 * t826 + 0.24e2 * t447 * t1401 * t243 - 0.36e2 * t465 * t439 * t470 + t763 * t255
  t1512 = f.my_piecewise3(t59, t1171 + t1196 + t1220 + t1252 + t1287 + t1320 + t1348 + t1373, -0.8e1 / 0.3e1 * t1377 * t128 - 0.32e2 / 0.3e1 * t763 * t258 - 0.16e2 * t434 * t482 - 0.32e2 / 0.3e1 * t240 * t842 - 0.8e1 / 0.3e1 * t117 * t1508)
  t1517 = 0.10e2 / 0.27e2 * t18 * t155 * t132 * t46 - 0.10467457545663187966529738013179383040893480786686e-1 * t867 / t21 / t550 * t132 * t872 + 0.20259595249670686386831750993250418788826091845200e-2 * t867 * t870 * t262 * t872 - 0.5e1 / 0.9e1 * t18 * t23 * t262 * t46 - t18 * t280 * t846 * t46 / 0.2e1 + t18 * t138 * t486 * t46 / 0.2e1 + 0.23649665105758014285600000000000000000000000000001e-1 * t6 * t853 * t846 * t277 + 0.34609703943869472848695962577236558400000000000004e-2 * t6 * t859 * t486 * t505 + 0.49414272216128897098646245549604736963326257894305e-4 * t866 * t17 / t20 / t914 * t132 * t571 * t920 * t36 * t38 + 0.53516857024316684867890979170356530118518518518524e-1 * t6 * t17 / t926 * t132 * t505 - 0.10642349297591106428520000000000000000000000000001e0 * t6 * t493 * t486 * t277 - 0.23073135962579648565797308384824372266666666666669e-1 * t6 * t500 * t262 * t505 - 0.40073043651423301983933333333333333333333333333336e0 * t6 * t17 / t20 / t913 * t132 * t277 + 0.30219016524024129364933333333333333333333333333336e0 * t6 * t271 * t262 * t277 - 0.3e1 / 0.8e1 * t18 * t20 * t1512 * t46
  t1518 = f.my_piecewise3(t2, 0, t1517)
  v4rho4_0_ = 0.2e1 * r0 * t1518 + 0.8e1 * t877

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t5 * t29
  t31 = t6 ** (0.1e1 / 0.3e1)
  t32 = t2 ** 2
  t33 = jnp.pi * t32
  t35 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t36 = 0.1e1 / t35
  t37 = 4 ** (0.1e1 / 0.3e1)
  t38 = t36 * t37
  t39 = 6 ** (0.1e1 / 0.3e1)
  t40 = jnp.pi ** 2
  t41 = t40 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t43 = 0.1e1 / t42
  t44 = t39 * t43
  t45 = r0 ** 2
  t46 = r0 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t53 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t44 * s0 / t47 / t45
  t56 = 0.18040e1 - 0.64641600e0 / t53
  t59 = t33 * t38 / t56
  t60 = jnp.sqrt(t59)
  t62 = f.p.cam_omega / t60
  t63 = 2 ** (0.1e1 / 0.3e1)
  t64 = t19 * t6
  t65 = t64 ** (0.1e1 / 0.3e1)
  t66 = 0.1e1 / t65
  t69 = t62 * t63 * t66 / 0.2e1
  t70 = 0.192e1 <= t69
  t71 = 0.192e1 < t69
  t72 = f.my_piecewise3(t71, t69, 0.192e1)
  t73 = t72 ** 2
  t74 = t73 ** 2
  t75 = 0.1e1 / t74
  t77 = t74 * t73
  t78 = 0.1e1 / t77
  t80 = t74 ** 2
  t81 = 0.1e1 / t80
  t83 = t80 * t73
  t84 = 0.1e1 / t83
  t86 = t80 * t74
  t87 = 0.1e1 / t86
  t89 = t80 * t77
  t90 = 0.1e1 / t89
  t92 = t80 ** 2
  t93 = 0.1e1 / t92
  t96 = 0.1e1 / t92 / t73
  t99 = 0.1e1 / t92 / t74
  t102 = 0.1e1 / t92 / t77
  t105 = 0.1e1 / t92 / t80
  t108 = 0.1e1 / t92 / t83
  t111 = 0.1e1 / t92 / t86
  t114 = 0.1e1 / t92 / t89
  t116 = t92 ** 2
  t117 = 0.1e1 / t116
  t120 = 0.1e1 / t116 / t73
  t123 = 0.1e1 / t116 / t74
  t127 = -t75 / 0.30e2 + t78 / 0.70e2 - t81 / 0.135e3 + t84 / 0.231e3 - t87 / 0.364e3 + t90 / 0.540e3 - t93 / 0.765e3 + t96 / 0.1045e4 - t99 / 0.1386e4 + t102 / 0.1794e4 - t105 / 0.2275e4 + t108 / 0.2835e4 - t111 / 0.3480e4 + t114 / 0.4216e4 - t117 / 0.5049e4 + t120 / 0.5985e4 - t123 / 0.7030e4 + 0.1e1 / t73 / 0.9e1
  t128 = f.my_piecewise3(t71, 0.192e1, t69)
  t129 = jnp.arctan2(0.1e1, t128)
  t130 = t128 ** 2
  t131 = t130 + 0.3e1
  t132 = 0.1e1 / t130
  t133 = 0.1e1 + t132
  t134 = jnp.log(t133)
  t136 = -t131 * t134 + 0.1e1
  t139 = t129 + t128 * t136 / 0.4e1
  t143 = f.my_piecewise3(t70, t127, 0.1e1 - 0.8e1 / 0.3e1 * t128 * t139)
  t145 = t31 * t143 * t56
  t148 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t149 = t148 * f.p.zeta_threshold
  t151 = f.my_piecewise3(t20, t149, t21 * t19)
  t152 = t5 * t151
  t153 = t31 ** 2
  t154 = 0.1e1 / t153
  t156 = t154 * t143 * t56
  t158 = t152 * t156 / 0.8e1
  t159 = t74 * t72
  t160 = 0.1e1 / t159
  t164 = f.p.cam_omega / t60 / t59 * t63
  t166 = t32 * t36
  t168 = t164 * t66 * jnp.pi * t166
  t169 = t56 ** 2
  t170 = 0.1e1 / t169
  t171 = t37 * t170
  t172 = t53 ** 2
  t173 = 0.1e1 / t172
  t174 = t171 * t173
  t175 = t45 * r0
  t177 = 0.1e1 / t47 / t175
  t179 = t44 * s0 * t177
  t184 = 0.1e1 / t65 / t64
  t185 = t63 * t184
  t187 = t26 * t6 + t18 + 0.1e1
  t191 = -0.39416108509596690476000000000000000000000000000002e-2 * t168 * t174 * t179 - t62 * t185 * t187 / 0.6e1
  t192 = f.my_piecewise3(t71, t191, 0)
  t195 = t73 * t72
  t196 = t74 * t195
  t197 = 0.1e1 / t196
  t200 = t80 * t72
  t201 = 0.1e1 / t200
  t204 = t80 * t195
  t205 = 0.1e1 / t204
  t208 = t80 * t159
  t209 = 0.1e1 / t208
  t212 = t80 * t196
  t213 = 0.1e1 / t212
  t217 = 0.1e1 / t92 / t72
  t221 = 0.1e1 / t92 / t195
  t225 = 0.1e1 / t92 / t159
  t229 = 0.1e1 / t92 / t196
  t233 = 0.1e1 / t92 / t200
  t237 = 0.1e1 / t92 / t204
  t241 = 0.1e1 / t92 / t208
  t245 = 0.1e1 / t92 / t212
  t249 = 0.1e1 / t116 / t72
  t253 = 0.1e1 / t116 / t195
  t257 = 0.1e1 / t116 / t159
  t260 = 0.1e1 / t195
  t263 = 0.2e1 / 0.15e2 * t160 * t192 - 0.3e1 / 0.35e2 * t197 * t192 + 0.8e1 / 0.135e3 * t201 * t192 - 0.10e2 / 0.231e3 * t205 * t192 + 0.3e1 / 0.91e2 * t209 * t192 - 0.7e1 / 0.270e3 * t213 * t192 + 0.16e2 / 0.765e3 * t217 * t192 - 0.18e2 / 0.1045e4 * t221 * t192 + 0.10e2 / 0.693e3 * t225 * t192 - 0.11e2 / 0.897e3 * t229 * t192 + 0.24e2 / 0.2275e4 * t233 * t192 - 0.26e2 / 0.2835e4 * t237 * t192 + 0.7e1 / 0.870e3 * t241 * t192 - 0.15e2 / 0.2108e4 * t245 * t192 + 0.32e2 / 0.5049e4 * t249 * t192 - 0.34e2 / 0.5985e4 * t253 * t192 + 0.18e2 / 0.3515e4 * t257 * t192 - 0.2e1 / 0.9e1 * t260 * t192
  t264 = f.my_piecewise3(t71, 0, t191)
  t267 = 0.1e1 / t133
  t274 = 0.1e1 / t130 / t128
  t275 = t131 * t274
  t276 = t264 * t267
  t279 = -0.2e1 * t128 * t264 * t134 + 0.2e1 * t275 * t276
  t282 = -t132 * t264 * t267 + t264 * t136 / 0.4e1 + t128 * t279 / 0.4e1
  t286 = f.my_piecewise3(t70, t263, -0.8e1 / 0.3e1 * t128 * t282 - 0.8e1 / 0.3e1 * t264 * t139)
  t288 = t31 * t286 * t56
  t291 = t151 * t31
  t293 = t5 * t291 * t143
  t294 = t173 * t39
  t295 = t43 * s0
  t297 = t294 * t295 * t177
  t301 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t30 * t145 - t158 - 0.3e1 / 0.8e1 * t152 * t288 + 0.59124162764395035714000000000000000000000000000004e-2 * t293 * t297)
  t303 = r1 <= f.p.dens_threshold
  t304 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t305 = 0.1e1 + t304
  t306 = t305 <= f.p.zeta_threshold
  t307 = t305 ** (0.1e1 / 0.3e1)
  t309 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t312 = f.my_piecewise3(t306, 0, 0.4e1 / 0.3e1 * t307 * t309)
  t313 = t5 * t312
  t314 = r1 ** 2
  t315 = r1 ** (0.1e1 / 0.3e1)
  t316 = t315 ** 2
  t322 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t44 * s2 / t316 / t314
  t325 = 0.18040e1 - 0.64641600e0 / t322
  t328 = t33 * t38 / t325
  t329 = jnp.sqrt(t328)
  t331 = f.p.cam_omega / t329
  t332 = t305 * t6
  t333 = t332 ** (0.1e1 / 0.3e1)
  t334 = 0.1e1 / t333
  t337 = t331 * t63 * t334 / 0.2e1
  t338 = 0.192e1 <= t337
  t339 = 0.192e1 < t337
  t340 = f.my_piecewise3(t339, t337, 0.192e1)
  t341 = t340 ** 2
  t342 = t341 ** 2
  t343 = 0.1e1 / t342
  t345 = t342 * t341
  t346 = 0.1e1 / t345
  t348 = t342 ** 2
  t349 = 0.1e1 / t348
  t351 = t348 * t341
  t352 = 0.1e1 / t351
  t354 = t348 * t342
  t355 = 0.1e1 / t354
  t357 = t348 * t345
  t358 = 0.1e1 / t357
  t360 = t348 ** 2
  t361 = 0.1e1 / t360
  t364 = 0.1e1 / t360 / t341
  t367 = 0.1e1 / t360 / t342
  t370 = 0.1e1 / t360 / t345
  t373 = 0.1e1 / t360 / t348
  t376 = 0.1e1 / t360 / t351
  t379 = 0.1e1 / t360 / t354
  t382 = 0.1e1 / t360 / t357
  t384 = t360 ** 2
  t385 = 0.1e1 / t384
  t388 = 0.1e1 / t384 / t341
  t391 = 0.1e1 / t384 / t342
  t395 = -t343 / 0.30e2 + t346 / 0.70e2 - t349 / 0.135e3 + t352 / 0.231e3 - t355 / 0.364e3 + t358 / 0.540e3 - t361 / 0.765e3 + t364 / 0.1045e4 - t367 / 0.1386e4 + t370 / 0.1794e4 - t373 / 0.2275e4 + t376 / 0.2835e4 - t379 / 0.3480e4 + t382 / 0.4216e4 - t385 / 0.5049e4 + t388 / 0.5985e4 - t391 / 0.7030e4 + 0.1e1 / t341 / 0.9e1
  t396 = f.my_piecewise3(t339, 0.192e1, t337)
  t397 = jnp.arctan2(0.1e1, t396)
  t398 = t396 ** 2
  t399 = t398 + 0.3e1
  t400 = 0.1e1 / t398
  t401 = 0.1e1 + t400
  t402 = jnp.log(t401)
  t404 = -t399 * t402 + 0.1e1
  t407 = t397 + t396 * t404 / 0.4e1
  t411 = f.my_piecewise3(t338, t395, 0.1e1 - 0.8e1 / 0.3e1 * t396 * t407)
  t413 = t31 * t411 * t325
  t417 = f.my_piecewise3(t306, t149, t307 * t305)
  t418 = t5 * t417
  t420 = t154 * t411 * t325
  t422 = t418 * t420 / 0.8e1
  t423 = t342 * t340
  t424 = 0.1e1 / t423
  t426 = 0.1e1 / t333 / t332
  t427 = t63 * t426
  t429 = t309 * t6 + t304 + 0.1e1
  t432 = t331 * t427 * t429 / 0.6e1
  t433 = f.my_piecewise3(t339, -t432, 0)
  t436 = t341 * t340
  t437 = t342 * t436
  t438 = 0.1e1 / t437
  t441 = t348 * t340
  t442 = 0.1e1 / t441
  t445 = t348 * t436
  t446 = 0.1e1 / t445
  t449 = t348 * t423
  t450 = 0.1e1 / t449
  t453 = t348 * t437
  t454 = 0.1e1 / t453
  t458 = 0.1e1 / t360 / t340
  t462 = 0.1e1 / t360 / t436
  t466 = 0.1e1 / t360 / t423
  t470 = 0.1e1 / t360 / t437
  t474 = 0.1e1 / t360 / t441
  t478 = 0.1e1 / t360 / t445
  t482 = 0.1e1 / t360 / t449
  t486 = 0.1e1 / t360 / t453
  t490 = 0.1e1 / t384 / t340
  t494 = 0.1e1 / t384 / t436
  t498 = 0.1e1 / t384 / t423
  t501 = 0.1e1 / t436
  t504 = 0.2e1 / 0.15e2 * t424 * t433 - 0.3e1 / 0.35e2 * t438 * t433 + 0.8e1 / 0.135e3 * t442 * t433 - 0.10e2 / 0.231e3 * t446 * t433 + 0.3e1 / 0.91e2 * t450 * t433 - 0.7e1 / 0.270e3 * t454 * t433 + 0.16e2 / 0.765e3 * t458 * t433 - 0.18e2 / 0.1045e4 * t462 * t433 + 0.10e2 / 0.693e3 * t466 * t433 - 0.11e2 / 0.897e3 * t470 * t433 + 0.24e2 / 0.2275e4 * t474 * t433 - 0.26e2 / 0.2835e4 * t478 * t433 + 0.7e1 / 0.870e3 * t482 * t433 - 0.15e2 / 0.2108e4 * t486 * t433 + 0.32e2 / 0.5049e4 * t490 * t433 - 0.34e2 / 0.5985e4 * t494 * t433 + 0.18e2 / 0.3515e4 * t498 * t433 - 0.2e1 / 0.9e1 * t501 * t433
  t505 = f.my_piecewise3(t339, 0, -t432)
  t508 = 0.1e1 / t401
  t515 = 0.1e1 / t398 / t396
  t516 = t399 * t515
  t517 = t505 * t508
  t520 = -0.2e1 * t396 * t505 * t402 + 0.2e1 * t516 * t517
  t523 = -t400 * t505 * t508 + t505 * t404 / 0.4e1 + t396 * t520 / 0.4e1
  t527 = f.my_piecewise3(t338, t504, -0.8e1 / 0.3e1 * t396 * t523 - 0.8e1 / 0.3e1 * t505 * t407)
  t529 = t31 * t527 * t325
  t533 = f.my_piecewise3(t303, 0, -0.3e1 / 0.8e1 * t313 * t413 - t422 - 0.3e1 / 0.8e1 * t418 * t529)
  t535 = t21 ** 2
  t536 = 0.1e1 / t535
  t537 = t26 ** 2
  t542 = t16 / t22 / t6
  t544 = -0.2e1 * t23 + 0.2e1 * t542
  t545 = f.my_piecewise5(t10, 0, t14, 0, t544)
  t549 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t536 * t537 + 0.4e1 / 0.3e1 * t21 * t545)
  t553 = t30 * t156
  t563 = 0.1e1 / t153 / t6
  t567 = t152 * t563 * t143 * t56 / 0.12e2
  t570 = t152 * t154 * t286 * t56
  t575 = t5 * t151 * t154 * t143 * t297
  t577 = t40 * t2
  t578 = t35 ** 2
  t579 = 0.1e1 / t578
  t580 = t37 ** 2
  t581 = t579 * t580
  t590 = t2 * t579
  t593 = t169 ** 2
  t596 = t172 ** 2
  t597 = 0.1e1 / t596
  t599 = t39 ** 2
  t601 = 0.1e1 / t41 / t40
  t602 = t599 * t601
  t603 = s0 ** 2
  t604 = t45 ** 2
  t607 = 0.1e1 / t46 / t604 / t175
  t609 = t602 * t603 * t607
  t630 = 0.1e1 / t172 / t53
  t636 = 0.1e1 / t47 / t604
  t642 = t19 ** 2
  t645 = 0.1e1 / t65 / t642 / t22
  t646 = t63 * t645
  t647 = t187 ** 2
  t657 = 0.93217776602418038170677705605528946394560000000010e-4 * f.p.cam_omega / t60 / t577 / t581 / t170 * t63 * t66 * t40 * t590 * t580 / t593 * t597 * t609 + 0.26277405673064460317333333333333333333333333333335e-2 * t164 * t184 * jnp.pi * t166 * t171 * t294 * t295 * t177 * t187 - 0.12429036880322405089423694080737192852608000000001e-3 * t168 * t37 / t169 / t56 * t597 * t609 - 0.19227613302149707138164423654020310222222222222224e-3 * t168 * t171 * t630 * t609 + 0.14452573120185453174533333333333333333333333333334e-1 * t168 * t174 * t44 * s0 * t636 + 0.2e1 / 0.9e1 * t62 * t646 * t647 - t62 * t185 * (t545 * t6 + 0.2e1 * t26) / 0.6e1
  t658 = f.my_piecewise3(t71, t657, 0)
  t661 = t192 ** 2
  t691 = 0.1e1 / t116 / t77
  t698 = -0.7e1 / 0.270e3 * t213 * t658 - 0.2e1 / 0.3e1 * t78 * t661 - 0.8e1 / 0.15e2 * t84 * t661 + 0.3e1 / 0.5e1 * t81 * t661 - 0.3e1 / 0.7e1 * t90 * t661 + 0.10e2 / 0.21e2 * t87 * t661 + 0.32e2 / 0.5049e4 * t249 * t658 - 0.11e2 / 0.897e3 * t229 * t658 + 0.11e2 / 0.39e2 * t105 * t661 - 0.24e2 / 0.91e2 * t108 * t661 + 0.26e2 / 0.105e3 * t111 * t661 - 0.7e1 / 0.30e2 * t114 * t661 + 0.15e2 / 0.68e2 * t117 * t661 - 0.32e2 / 0.153e3 * t120 * t661 + 0.34e2 / 0.171e3 * t123 * t661 - 0.18e2 / 0.95e2 * t691 * t661 + 0.2e1 / 0.3e1 * t75 * t661 + 0.2e1 / 0.15e2 * t160 * t658
  t735 = -0.3e1 / 0.35e2 * t197 * t658 + 0.8e1 / 0.135e3 * t201 * t658 - 0.26e2 / 0.2835e4 * t237 * t658 - 0.10e2 / 0.231e3 * t205 * t658 + 0.7e1 / 0.18e2 * t93 * t661 + 0.3e1 / 0.91e2 * t209 * t658 - 0.16e2 / 0.45e2 * t96 * t661 + 0.18e2 / 0.55e2 * t99 * t661 - 0.10e2 / 0.33e2 * t102 * t661 + 0.24e2 / 0.2275e4 * t233 * t658 + 0.16e2 / 0.765e3 * t217 * t658 + 0.10e2 / 0.693e3 * t225 * t658 - 0.18e2 / 0.1045e4 * t221 * t658 - 0.2e1 / 0.9e1 * t260 * t658 + 0.18e2 / 0.3515e4 * t257 * t658 - 0.34e2 / 0.5985e4 * t253 * t658 + 0.7e1 / 0.870e3 * t241 * t658 - 0.15e2 / 0.2108e4 * t245 * t658
  t737 = f.my_piecewise3(t71, 0, t657)
  t742 = t264 ** 2
  t748 = t130 ** 2
  t750 = 0.1e1 / t748 / t128
  t752 = t133 ** 2
  t753 = 0.1e1 / t752
  t769 = t131 / t748
  t778 = t131 / t748 / t130
  t789 = f.my_piecewise3(t70, t698 + t735, -0.8e1 / 0.3e1 * t737 * t139 - 0.16e2 / 0.3e1 * t264 * t282 - 0.8e1 / 0.3e1 * t128 * (0.2e1 * t274 * t742 * t267 - t132 * t737 * t267 - 0.2e1 * t750 * t742 * t753 + t737 * t136 / 0.4e1 + t264 * t279 / 0.2e1 + t128 * (-0.2e1 * t128 * t737 * t134 + 0.8e1 * t132 * t742 * t267 + 0.2e1 * t275 * t737 * t267 - 0.6e1 * t769 * t742 * t267 + 0.4e1 * t778 * t742 * t753 - 0.2e1 * t742 * t134) / 0.4e1))
  t808 = -0.3e1 / 0.8e1 * t5 * t549 * t145 - t553 / 0.4e1 - 0.3e1 / 0.4e1 * t30 * t288 + 0.11824832552879007142800000000000000000000000000001e-1 * t5 * t29 * t31 * t143 * t297 + t567 - t570 / 0.4e1 + 0.39416108509596690476000000000000000000000000000002e-2 * t575 - 0.3e1 / 0.8e1 * t152 * t31 * t789 * t56 + 0.11824832552879007142800000000000000000000000000001e-1 * t5 * t291 * t286 * t297 + 0.28841419953224560707246635481030465333333333333337e-3 * t293 * t630 * t599 * t601 * t603 * t607 - 0.21678859680278179761800000000000000000000000000001e-1 * t293 * t294 * t295 * t636
  t809 = f.my_piecewise3(t1, 0, t808)
  t810 = t307 ** 2
  t811 = 0.1e1 / t810
  t812 = t309 ** 2
  t816 = f.my_piecewise5(t14, 0, t10, 0, -t544)
  t820 = f.my_piecewise3(t306, 0, 0.4e1 / 0.9e1 * t811 * t812 + 0.4e1 / 0.3e1 * t307 * t816)
  t824 = t313 * t420
  t831 = t418 * t563 * t411 * t325 / 0.12e2
  t834 = t418 * t154 * t527 * t325
  t836 = t433 ** 2
  t842 = 0.1e1 / t384 / t345
  t847 = t305 ** 2
  t850 = 0.1e1 / t333 / t847 / t22
  t851 = t63 * t850
  t852 = t429 ** 2
  t862 = 0.2e1 / 0.9e1 * t331 * t851 * t852 - t331 * t427 * (t816 * t6 + 0.2e1 * t309) / 0.6e1
  t863 = f.my_piecewise3(t339, t862, 0)
  t892 = -0.32e2 / 0.153e3 * t388 * t836 + 0.34e2 / 0.171e3 * t391 * t836 - 0.18e2 / 0.95e2 * t842 * t836 + 0.2e1 / 0.3e1 * t343 * t836 + 0.18e2 / 0.3515e4 * t498 * t863 - 0.34e2 / 0.5985e4 * t494 * t863 - 0.7e1 / 0.270e3 * t454 * t863 - 0.2e1 / 0.3e1 * t346 * t836 + 0.3e1 / 0.5e1 * t349 * t836 - 0.8e1 / 0.15e2 * t352 * t836 + 0.10e2 / 0.21e2 * t355 * t836 - 0.16e2 / 0.45e2 * t364 * t836 + 0.18e2 / 0.55e2 * t367 * t836 - 0.10e2 / 0.33e2 * t370 * t836 - 0.15e2 / 0.2108e4 * t486 * t863 + 0.32e2 / 0.5049e4 * t490 * t863 - 0.2e1 / 0.9e1 * t501 * t863 + 0.16e2 / 0.765e3 * t458 * t863
  t929 = -0.18e2 / 0.1045e4 * t462 * t863 + 0.10e2 / 0.693e3 * t466 * t863 - 0.11e2 / 0.897e3 * t470 * t863 + 0.24e2 / 0.2275e4 * t474 * t863 - 0.26e2 / 0.2835e4 * t478 * t863 + 0.7e1 / 0.870e3 * t482 * t863 + 0.2e1 / 0.15e2 * t424 * t863 - 0.3e1 / 0.35e2 * t438 * t863 + 0.8e1 / 0.135e3 * t442 * t863 - 0.10e2 / 0.231e3 * t446 * t863 + 0.3e1 / 0.91e2 * t450 * t863 - 0.3e1 / 0.7e1 * t358 * t836 + 0.7e1 / 0.18e2 * t361 * t836 + 0.11e2 / 0.39e2 * t373 * t836 - 0.24e2 / 0.91e2 * t376 * t836 + 0.26e2 / 0.105e3 * t379 * t836 - 0.7e1 / 0.30e2 * t382 * t836 + 0.15e2 / 0.68e2 * t385 * t836
  t931 = f.my_piecewise3(t339, 0, t862)
  t936 = t505 ** 2
  t942 = t398 ** 2
  t944 = 0.1e1 / t942 / t396
  t946 = t401 ** 2
  t947 = 0.1e1 / t946
  t963 = t399 / t942
  t972 = t399 / t942 / t398
  t983 = f.my_piecewise3(t338, t892 + t929, -0.8e1 / 0.3e1 * t931 * t407 - 0.16e2 / 0.3e1 * t505 * t523 - 0.8e1 / 0.3e1 * t396 * (0.2e1 * t515 * t936 * t508 - t400 * t931 * t508 - 0.2e1 * t944 * t936 * t947 + t931 * t404 / 0.4e1 + t505 * t520 / 0.2e1 + t396 * (-0.2e1 * t396 * t931 * t402 + 0.8e1 * t400 * t936 * t508 + 0.2e1 * t516 * t931 * t508 - 0.6e1 * t963 * t936 * t508 + 0.4e1 * t972 * t936 * t947 - 0.2e1 * t936 * t402) / 0.4e1))
  t989 = f.my_piecewise3(t303, 0, -0.3e1 / 0.8e1 * t5 * t820 * t413 - t824 / 0.4e1 - 0.3e1 / 0.4e1 * t313 * t529 + t831 - t834 / 0.4e1 - 0.3e1 / 0.8e1 * t418 * t31 * t983 * t325)
  d11 = 0.2e1 * t301 + 0.2e1 * t533 + t6 * (t809 + t989)
  t992 = -t7 - t24
  t993 = f.my_piecewise5(t10, 0, t14, 0, t992)
  t996 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t993)
  t997 = t5 * t996
  t1001 = t993 * t6 + t18 + 0.1e1
  t1004 = t62 * t185 * t1001 / 0.6e1
  t1005 = f.my_piecewise3(t71, -t1004, 0)
  t1042 = 0.2e1 / 0.15e2 * t160 * t1005 - 0.3e1 / 0.35e2 * t197 * t1005 + 0.8e1 / 0.135e3 * t201 * t1005 - 0.10e2 / 0.231e3 * t205 * t1005 + 0.3e1 / 0.91e2 * t209 * t1005 - 0.7e1 / 0.270e3 * t213 * t1005 + 0.16e2 / 0.765e3 * t217 * t1005 - 0.18e2 / 0.1045e4 * t221 * t1005 + 0.10e2 / 0.693e3 * t225 * t1005 - 0.11e2 / 0.897e3 * t229 * t1005 + 0.24e2 / 0.2275e4 * t233 * t1005 - 0.26e2 / 0.2835e4 * t237 * t1005 + 0.7e1 / 0.870e3 * t241 * t1005 - 0.15e2 / 0.2108e4 * t245 * t1005 + 0.32e2 / 0.5049e4 * t249 * t1005 - 0.34e2 / 0.5985e4 * t253 * t1005 + 0.18e2 / 0.3515e4 * t257 * t1005 - 0.2e1 / 0.9e1 * t260 * t1005
  t1043 = f.my_piecewise3(t71, 0, -t1004)
  t1045 = t132 * t1043
  t1051 = t1043 * t267
  t1054 = -0.2e1 * t128 * t1043 * t134 + 0.2e1 * t275 * t1051
  t1057 = -t1045 * t267 + t1043 * t136 / 0.4e1 + t128 * t1054 / 0.4e1
  t1061 = f.my_piecewise3(t70, t1042, -0.8e1 / 0.3e1 * t1043 * t139 - 0.8e1 / 0.3e1 * t128 * t1057)
  t1063 = t31 * t1061 * t56
  t1067 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t997 * t145 - t158 - 0.3e1 / 0.8e1 * t152 * t1063)
  t1069 = f.my_piecewise5(t14, 0, t10, 0, -t992)
  t1072 = f.my_piecewise3(t306, 0, 0.4e1 / 0.3e1 * t307 * t1069)
  t1073 = t5 * t1072
  t1079 = f.p.cam_omega / t329 / t328 * t63
  t1082 = t1079 * t334 * jnp.pi * t166
  t1083 = t325 ** 2
  t1084 = 0.1e1 / t1083
  t1085 = t37 * t1084
  t1086 = t322 ** 2
  t1087 = 0.1e1 / t1086
  t1088 = t1085 * t1087
  t1089 = t314 * r1
  t1091 = 0.1e1 / t316 / t1089
  t1098 = t1069 * t6 + t304 + 0.1e1
  t1102 = -0.39416108509596690476000000000000000000000000000002e-2 * t1082 * t1088 * t44 * s2 * t1091 - t331 * t427 * t1098 / 0.6e1
  t1103 = f.my_piecewise3(t339, t1102, 0)
  t1140 = 0.2e1 / 0.15e2 * t424 * t1103 - 0.3e1 / 0.35e2 * t438 * t1103 + 0.8e1 / 0.135e3 * t442 * t1103 - 0.10e2 / 0.231e3 * t446 * t1103 + 0.3e1 / 0.91e2 * t450 * t1103 - 0.7e1 / 0.270e3 * t454 * t1103 + 0.16e2 / 0.765e3 * t458 * t1103 - 0.18e2 / 0.1045e4 * t462 * t1103 + 0.10e2 / 0.693e3 * t466 * t1103 - 0.11e2 / 0.897e3 * t470 * t1103 + 0.24e2 / 0.2275e4 * t474 * t1103 - 0.26e2 / 0.2835e4 * t478 * t1103 + 0.7e1 / 0.870e3 * t482 * t1103 - 0.15e2 / 0.2108e4 * t486 * t1103 + 0.32e2 / 0.5049e4 * t490 * t1103 - 0.34e2 / 0.5985e4 * t494 * t1103 + 0.18e2 / 0.3515e4 * t498 * t1103 - 0.2e1 / 0.9e1 * t501 * t1103
  t1141 = f.my_piecewise3(t339, 0, t1102)
  t1143 = t400 * t1141
  t1149 = t1141 * t508
  t1152 = -0.2e1 * t396 * t1141 * t402 + 0.2e1 * t516 * t1149
  t1155 = -t1143 * t508 + t1141 * t404 / 0.4e1 + t396 * t1152 / 0.4e1
  t1159 = f.my_piecewise3(t338, t1140, -0.8e1 / 0.3e1 * t1141 * t407 - 0.8e1 / 0.3e1 * t396 * t1155)
  t1161 = t31 * t1159 * t325
  t1164 = t417 * t31
  t1166 = t5 * t1164 * t411
  t1167 = t1087 * t39
  t1168 = t43 * s2
  t1170 = t1167 * t1168 * t1091
  t1174 = f.my_piecewise3(t303, 0, -0.3e1 / 0.8e1 * t1073 * t413 - t422 - 0.3e1 / 0.8e1 * t418 * t1161 + 0.59124162764395035714000000000000000000000000000004e-2 * t1166 * t1170)
  t1178 = 0.2e1 * t542
  t1179 = f.my_piecewise5(t10, 0, t14, 0, t1178)
  t1183 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t536 * t993 * t26 + 0.4e1 / 0.3e1 * t21 * t1179)
  t1187 = t997 * t156
  t1203 = t152 * t154 * t1061 * t56
  t1259 = 0.3e1 / 0.5e1 * t81 * t1005 * t192 - 0.8e1 / 0.15e2 * t84 * t1005 * t192 + 0.10e2 / 0.21e2 * t87 * t1005 * t192 - 0.3e1 / 0.7e1 * t90 * t1005 * t192 + 0.7e1 / 0.18e2 * t93 * t1005 * t192 - 0.16e2 / 0.45e2 * t96 * t1005 * t192 + 0.18e2 / 0.55e2 * t99 * t1005 * t192 - 0.10e2 / 0.33e2 * t102 * t1005 * t192 + 0.11e2 / 0.39e2 * t105 * t1005 * t192 - 0.24e2 / 0.91e2 * t108 * t1005 * t192 + 0.26e2 / 0.105e3 * t111 * t1005 * t192 - 0.7e1 / 0.30e2 * t114 * t1005 * t192 + 0.15e2 / 0.68e2 * t117 * t1005 * t192 - 0.32e2 / 0.153e3 * t120 * t1005 * t192 + 0.34e2 / 0.171e3 * t123 * t1005 * t192 - 0.18e2 / 0.95e2 * t691 * t1005 * t192 + 0.2e1 / 0.3e1 * t75 * t1005 * t192 - 0.2e1 / 0.3e1 * t78 * t1005 * t192
  t1278 = 0.13138702836532230158666666666666666666666666666668e-2 * t164 * t184 * t1001 * t33 * t38 * t170 * t173 * t179 + 0.2e1 / 0.9e1 * t62 * t63 * t645 * t1001 * t187 - t62 * t185 * (t1179 * t6 + t26 + t993) / 0.6e1
  t1279 = f.my_piecewise3(t71, t1278, 0)
  t1316 = 0.8e1 / 0.135e3 * t201 * t1279 + 0.32e2 / 0.5049e4 * t249 * t1279 - 0.10e2 / 0.231e3 * t205 * t1279 + 0.3e1 / 0.91e2 * t209 * t1279 + 0.24e2 / 0.2275e4 * t233 * t1279 + 0.18e2 / 0.3515e4 * t257 * t1279 - 0.7e1 / 0.270e3 * t213 * t1279 + 0.16e2 / 0.765e3 * t217 * t1279 - 0.18e2 / 0.1045e4 * t221 * t1279 - 0.2e1 / 0.9e1 * t260 * t1279 + 0.2e1 / 0.15e2 * t160 * t1279 - 0.3e1 / 0.35e2 * t197 * t1279 + 0.10e2 / 0.693e3 * t225 * t1279 - 0.11e2 / 0.897e3 * t229 * t1279 - 0.26e2 / 0.2835e4 * t237 * t1279 + 0.7e1 / 0.870e3 * t241 * t1279 - 0.15e2 / 0.2108e4 * t245 * t1279 - 0.34e2 / 0.5985e4 * t253 * t1279
  t1318 = f.my_piecewise3(t71, 0, t1278)
  t1362 = f.my_piecewise3(t70, t1259 + t1316, -0.8e1 / 0.3e1 * t1318 * t139 - 0.8e1 / 0.3e1 * t1043 * t282 - 0.8e1 / 0.3e1 * t264 * t1057 - 0.8e1 / 0.3e1 * t128 * (0.2e1 * t274 * t1043 * t276 - t132 * t1318 * t267 - 0.2e1 * t750 * t1043 * t753 * t264 + t1318 * t136 / 0.4e1 + t1043 * t279 / 0.4e1 + t264 * t1054 / 0.4e1 + t128 * (0.4e1 * t778 * t1043 * t753 * t264 - 0.2e1 * t264 * t1043 * t134 - 0.6e1 * t769 * t1051 * t264 - 0.2e1 * t128 * t1318 * t134 + 0.2e1 * t275 * t1318 * t267 + 0.8e1 * t1045 * t276) / 0.4e1))
  t1371 = -0.3e1 / 0.8e1 * t5 * t1183 * t145 - t1187 / 0.8e1 - 0.3e1 / 0.8e1 * t997 * t288 + 0.59124162764395035714000000000000000000000000000004e-2 * t5 * t996 * t31 * t143 * t297 - t553 / 0.8e1 + t567 - t570 / 0.8e1 + 0.19708054254798345238000000000000000000000000000001e-2 * t575 - 0.3e1 / 0.8e1 * t30 * t1063 - t1203 / 0.8e1 - 0.3e1 / 0.8e1 * t152 * t31 * t1362 * t56 + 0.59124162764395035714000000000000000000000000000004e-2 * t5 * t291 * t1061 * t297
  t1372 = f.my_piecewise3(t1, 0, t1371)
  t1376 = f.my_piecewise5(t14, 0, t10, 0, -t1178)
  t1380 = f.my_piecewise3(t306, 0, 0.4e1 / 0.9e1 * t811 * t1069 * t309 + 0.4e1 / 0.3e1 * t307 * t1376)
  t1384 = t1073 * t420
  t1394 = t418 * t154 * t1159 * t325
  t1398 = t1079 * t426 * jnp.pi * t166
  t1399 = t1085 * t1167
  t1415 = 0.13138702836532230158666666666666666666666666666667e-2 * t1398 * t1399 * t1168 * t1091 * t429 + 0.2e1 / 0.9e1 * t331 * t63 * t850 * t1098 * t429 - t331 * t427 * (t1376 * t6 + t1069 + t309) / 0.6e1
  t1416 = f.my_piecewise3(t339, t1415, 0)
  t1453 = 0.7e1 / 0.870e3 * t482 * t1416 - 0.26e2 / 0.2835e4 * t478 * t1416 + 0.18e2 / 0.3515e4 * t498 * t1416 - 0.34e2 / 0.5985e4 * t494 * t1416 - 0.7e1 / 0.270e3 * t454 * t1416 + 0.16e2 / 0.765e3 * t458 * t1416 - 0.18e2 / 0.1045e4 * t462 * t1416 + 0.10e2 / 0.693e3 * t466 * t1416 - 0.15e2 / 0.2108e4 * t486 * t1416 + 0.2e1 / 0.15e2 * t424 * t1416 - 0.10e2 / 0.231e3 * t446 * t1416 + 0.3e1 / 0.91e2 * t450 * t1416 - 0.2e1 / 0.9e1 * t501 * t1416 - 0.11e2 / 0.897e3 * t470 * t1416 + 0.24e2 / 0.2275e4 * t474 * t1416 + 0.32e2 / 0.5049e4 * t490 * t1416 + 0.8e1 / 0.135e3 * t442 * t1416 - 0.3e1 / 0.35e2 * t438 * t1416
  t1508 = 0.11e2 / 0.39e2 * t373 * t1103 * t433 - 0.24e2 / 0.91e2 * t376 * t1103 * t433 + 0.26e2 / 0.105e3 * t379 * t1103 * t433 - 0.2e1 / 0.3e1 * t346 * t1103 * t433 + 0.3e1 / 0.5e1 * t349 * t1103 * t433 - 0.8e1 / 0.15e2 * t352 * t1103 * t433 + 0.10e2 / 0.21e2 * t355 * t1103 * t433 - 0.3e1 / 0.7e1 * t358 * t1103 * t433 - 0.18e2 / 0.95e2 * t842 * t1103 * t433 + 0.2e1 / 0.3e1 * t343 * t1103 * t433 - 0.7e1 / 0.30e2 * t382 * t1103 * t433 + 0.15e2 / 0.68e2 * t385 * t1103 * t433 - 0.32e2 / 0.153e3 * t388 * t1103 * t433 + 0.34e2 / 0.171e3 * t391 * t1103 * t433 + 0.7e1 / 0.18e2 * t361 * t1103 * t433 - 0.16e2 / 0.45e2 * t364 * t1103 * t433 + 0.18e2 / 0.55e2 * t367 * t1103 * t433 - 0.10e2 / 0.33e2 * t370 * t1103 * t433
  t1510 = f.my_piecewise3(t339, 0, t1415)
  t1554 = f.my_piecewise3(t338, t1453 + t1508, -0.8e1 / 0.3e1 * t1510 * t407 - 0.8e1 / 0.3e1 * t1141 * t523 - 0.8e1 / 0.3e1 * t505 * t1155 - 0.8e1 / 0.3e1 * t396 * (0.2e1 * t515 * t1141 * t517 - t400 * t1510 * t508 - 0.2e1 * t944 * t1141 * t947 * t505 + t1510 * t404 / 0.4e1 + t1141 * t520 / 0.4e1 + t505 * t1152 / 0.4e1 + t396 * (0.4e1 * t972 * t1141 * t947 * t505 - 0.2e1 * t505 * t1141 * t402 - 0.6e1 * t963 * t1149 * t505 - 0.2e1 * t396 * t1510 * t402 + 0.2e1 * t516 * t1510 * t508 + 0.8e1 * t1143 * t517) / 0.4e1))
  t1567 = t5 * t417 * t154 * t411 * t1170
  t1573 = -0.3e1 / 0.8e1 * t5 * t1380 * t413 - t1384 / 0.8e1 - 0.3e1 / 0.8e1 * t1073 * t529 - t824 / 0.8e1 + t831 - t834 / 0.8e1 - 0.3e1 / 0.8e1 * t313 * t1161 - t1394 / 0.8e1 - 0.3e1 / 0.8e1 * t418 * t31 * t1554 * t325 + 0.59124162764395035714000000000000000000000000000004e-2 * t5 * t312 * t31 * t411 * t1170 + 0.19708054254798345238000000000000000000000000000001e-2 * t1567 + 0.59124162764395035714000000000000000000000000000004e-2 * t5 * t1164 * t527 * t1170
  t1574 = f.my_piecewise3(t303, 0, t1573)
  d12 = t301 + t533 + t1067 + t1174 + t6 * (t1372 + t1574)
  t1579 = t993 ** 2
  t1583 = 0.2e1 * t23 + 0.2e1 * t542
  t1584 = f.my_piecewise5(t10, 0, t14, 0, t1583)
  t1588 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t536 * t1579 + 0.4e1 / 0.3e1 * t21 * t1584)
  t1596 = t1001 ** 2
  t1606 = 0.2e1 / 0.9e1 * t62 * t646 * t1596 - t62 * t185 * (t1584 * t6 + 0.2e1 * t993) / 0.6e1
  t1607 = f.my_piecewise3(t71, t1606, 0)
  t1616 = t1005 ** 2
  t1645 = -0.11e2 / 0.897e3 * t229 * t1607 + 0.24e2 / 0.2275e4 * t233 * t1607 - 0.26e2 / 0.2835e4 * t237 * t1607 + 0.2e1 / 0.15e2 * t160 * t1607 + 0.18e2 / 0.55e2 * t99 * t1616 + 0.8e1 / 0.135e3 * t201 * t1607 - 0.7e1 / 0.270e3 * t213 * t1607 - 0.2e1 / 0.9e1 * t260 * t1607 + 0.32e2 / 0.5049e4 * t249 * t1607 - 0.18e2 / 0.1045e4 * t221 * t1607 - 0.7e1 / 0.30e2 * t114 * t1616 - 0.3e1 / 0.35e2 * t197 * t1607 + 0.15e2 / 0.68e2 * t117 * t1616 - 0.32e2 / 0.153e3 * t120 * t1616 + 0.34e2 / 0.171e3 * t123 * t1616 + 0.7e1 / 0.870e3 * t241 * t1607 + 0.18e2 / 0.3515e4 * t257 * t1607 + 0.10e2 / 0.693e3 * t225 * t1607
  t1682 = 0.3e1 / 0.5e1 * t81 * t1616 + 0.2e1 / 0.3e1 * t75 * t1616 - 0.18e2 / 0.95e2 * t691 * t1616 - 0.2e1 / 0.3e1 * t78 * t1616 + 0.10e2 / 0.21e2 * t87 * t1616 - 0.8e1 / 0.15e2 * t84 * t1616 - 0.3e1 / 0.7e1 * t90 * t1616 + 0.7e1 / 0.18e2 * t93 * t1616 - 0.16e2 / 0.45e2 * t96 * t1616 - 0.15e2 / 0.2108e4 * t245 * t1607 + 0.3e1 / 0.91e2 * t209 * t1607 - 0.34e2 / 0.5985e4 * t253 * t1607 + 0.11e2 / 0.39e2 * t105 * t1616 - 0.10e2 / 0.33e2 * t102 * t1616 + 0.26e2 / 0.105e3 * t111 * t1616 - 0.24e2 / 0.91e2 * t108 * t1616 + 0.16e2 / 0.765e3 * t217 * t1607 - 0.10e2 / 0.231e3 * t205 * t1607
  t1684 = f.my_piecewise3(t71, 0, t1606)
  t1689 = t1043 ** 2
  t1726 = f.my_piecewise3(t70, t1645 + t1682, -0.8e1 / 0.3e1 * t1684 * t139 - 0.16e2 / 0.3e1 * t1043 * t1057 - 0.8e1 / 0.3e1 * t128 * (0.2e1 * t274 * t1689 * t267 - t132 * t1684 * t267 - 0.2e1 * t750 * t1689 * t753 + t1684 * t136 / 0.4e1 + t1043 * t1054 / 0.2e1 + t128 * (-0.2e1 * t128 * t1684 * t134 + 0.8e1 * t132 * t1689 * t267 + 0.2e1 * t275 * t1684 * t267 - 0.6e1 * t769 * t1689 * t267 + 0.4e1 * t778 * t1689 * t753 - 0.2e1 * t1689 * t134) / 0.4e1))
  t1732 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1588 * t145 - t1187 / 0.4e1 - 0.3e1 / 0.4e1 * t997 * t1063 + t567 - t1203 / 0.4e1 - 0.3e1 / 0.8e1 * t152 * t31 * t1726 * t56)
  t1733 = t1069 ** 2
  t1737 = f.my_piecewise5(t14, 0, t10, 0, -t1583)
  t1741 = f.my_piecewise3(t306, 0, 0.4e1 / 0.9e1 * t811 * t1733 + 0.4e1 / 0.3e1 * t307 * t1737)
  t1765 = t1083 ** 2
  t1768 = t1086 ** 2
  t1769 = 0.1e1 / t1768
  t1771 = s2 ** 2
  t1772 = t314 ** 2
  t1775 = 0.1e1 / t315 / t1772 / t1089
  t1777 = t602 * t1771 * t1775
  t1794 = 0.1e1 / t1086 / t322
  t1800 = 0.1e1 / t316 / t1772
  t1806 = t1098 ** 2
  t1816 = 0.93217776602418038170677705605528946394560000000010e-4 * f.p.cam_omega / t329 / t577 / t581 / t1084 * t63 * t334 * t40 * t590 * t580 / t1765 * t1769 * t1777 + 0.26277405673064460317333333333333333333333333333335e-2 * t1398 * t1399 * t1168 * t1091 * t1098 - 0.12429036880322405089423694080737192852608000000001e-3 * t1082 * t37 / t1083 / t325 * t1769 * t1777 - 0.19227613302149707138164423654020310222222222222224e-3 * t1082 * t1085 * t1794 * t1777 + 0.14452573120185453174533333333333333333333333333334e-1 * t1082 * t1088 * t44 * s2 * t1800 + 0.2e1 / 0.9e1 * t331 * t851 * t1806 - t331 * t427 * (t1737 * t6 + 0.2e1 * t1069) / 0.6e1
  t1817 = f.my_piecewise3(t339, t1816, 0)
  t1826 = t1103 ** 2
  t1855 = -0.34e2 / 0.5985e4 * t494 * t1817 + 0.7e1 / 0.870e3 * t482 * t1817 + 0.10e2 / 0.693e3 * t466 * t1817 - 0.2e1 / 0.9e1 * t501 * t1817 + 0.2e1 / 0.3e1 * t343 * t1826 + 0.34e2 / 0.171e3 * t391 * t1826 + 0.15e2 / 0.68e2 * t385 * t1826 - 0.15e2 / 0.2108e4 * t486 * t1817 + 0.32e2 / 0.5049e4 * t490 * t1817 + 0.8e1 / 0.135e3 * t442 * t1817 - 0.10e2 / 0.231e3 * t446 * t1817 + 0.3e1 / 0.91e2 * t450 * t1817 - 0.18e2 / 0.1045e4 * t462 * t1817 - 0.3e1 / 0.35e2 * t438 * t1817 + 0.10e2 / 0.21e2 * t355 * t1826 - 0.3e1 / 0.7e1 * t358 * t1826 - 0.18e2 / 0.95e2 * t842 * t1826 + 0.2e1 / 0.15e2 * t424 * t1817
  t1892 = -0.24e2 / 0.91e2 * t376 * t1826 + 0.11e2 / 0.39e2 * t373 * t1826 - 0.26e2 / 0.2835e4 * t478 * t1817 + 0.18e2 / 0.55e2 * t367 * t1826 - 0.10e2 / 0.33e2 * t370 * t1826 - 0.8e1 / 0.15e2 * t352 * t1826 + 0.3e1 / 0.5e1 * t349 * t1826 - 0.7e1 / 0.30e2 * t382 * t1826 + 0.24e2 / 0.2275e4 * t474 * t1817 + 0.7e1 / 0.18e2 * t361 * t1826 - 0.16e2 / 0.45e2 * t364 * t1826 + 0.26e2 / 0.105e3 * t379 * t1826 - 0.11e2 / 0.897e3 * t470 * t1817 - 0.2e1 / 0.3e1 * t346 * t1826 - 0.7e1 / 0.270e3 * t454 * t1817 - 0.32e2 / 0.153e3 * t388 * t1826 + 0.16e2 / 0.765e3 * t458 * t1817 + 0.18e2 / 0.3515e4 * t498 * t1817
  t1894 = f.my_piecewise3(t339, 0, t1816)
  t1899 = t1141 ** 2
  t1936 = f.my_piecewise3(t338, t1855 + t1892, -0.8e1 / 0.3e1 * t1894 * t407 - 0.16e2 / 0.3e1 * t1141 * t1155 - 0.8e1 / 0.3e1 * t396 * (0.2e1 * t515 * t1899 * t508 - t400 * t1894 * t508 - 0.2e1 * t944 * t1899 * t947 + t1894 * t404 / 0.4e1 + t1141 * t1152 / 0.2e1 + t396 * (-0.2e1 * t396 * t1894 * t402 + 0.2e1 * t516 * t1894 * t508 + 0.8e1 * t400 * t1899 * t508 - 0.6e1 * t963 * t1899 * t508 + 0.4e1 * t972 * t1899 * t947 - 0.2e1 * t1899 * t402) / 0.4e1))
  t1955 = -0.3e1 / 0.8e1 * t5 * t1741 * t413 - t1384 / 0.4e1 - 0.3e1 / 0.4e1 * t1073 * t1161 + 0.11824832552879007142800000000000000000000000000001e-1 * t5 * t1072 * t31 * t411 * t1170 + t831 - t1394 / 0.4e1 + 0.39416108509596690476000000000000000000000000000002e-2 * t1567 - 0.3e1 / 0.8e1 * t418 * t31 * t1936 * t325 + 0.11824832552879007142800000000000000000000000000001e-1 * t5 * t1164 * t1159 * t1170 + 0.28841419953224560707246635481030465333333333333337e-3 * t1166 * t1794 * t599 * t601 * t1771 * t1775 - 0.21678859680278179761800000000000000000000000000001e-1 * t1166 * t1167 * t1168 * t1800
  t1956 = f.my_piecewise3(t303, 0, t1955)
  d22 = 0.2e1 * t1067 + 0.2e1 * t1174 + t6 * (t1732 + t1956)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t5 * t29
  t31 = t6 ** (0.1e1 / 0.3e1)
  t32 = t2 ** 2
  t33 = jnp.pi * t32
  t35 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t36 = 0.1e1 / t35
  t37 = 4 ** (0.1e1 / 0.3e1)
  t38 = t36 * t37
  t39 = 6 ** (0.1e1 / 0.3e1)
  t40 = jnp.pi ** 2
  t41 = t40 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t43 = 0.1e1 / t42
  t44 = t39 * t43
  t45 = r0 ** 2
  t46 = r0 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t53 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t44 * s0 / t47 / t45
  t56 = 0.18040e1 - 0.64641600e0 / t53
  t59 = t33 * t38 / t56
  t60 = jnp.sqrt(t59)
  t62 = f.p.cam_omega / t60
  t63 = 2 ** (0.1e1 / 0.3e1)
  t64 = t19 * t6
  t65 = t64 ** (0.1e1 / 0.3e1)
  t66 = 0.1e1 / t65
  t69 = t62 * t63 * t66 / 0.2e1
  t70 = 0.192e1 <= t69
  t71 = 0.192e1 < t69
  t72 = f.my_piecewise3(t71, t69, 0.192e1)
  t73 = t72 ** 2
  t74 = t73 ** 2
  t75 = 0.1e1 / t74
  t77 = t74 * t73
  t78 = 0.1e1 / t77
  t80 = t74 ** 2
  t81 = 0.1e1 / t80
  t83 = t80 * t73
  t84 = 0.1e1 / t83
  t86 = t80 * t74
  t87 = 0.1e1 / t86
  t89 = t80 * t77
  t90 = 0.1e1 / t89
  t92 = t80 ** 2
  t93 = 0.1e1 / t92
  t96 = 0.1e1 / t92 / t73
  t99 = 0.1e1 / t92 / t74
  t102 = 0.1e1 / t92 / t77
  t105 = 0.1e1 / t92 / t80
  t108 = 0.1e1 / t92 / t83
  t111 = 0.1e1 / t92 / t86
  t114 = 0.1e1 / t92 / t89
  t116 = t92 ** 2
  t117 = 0.1e1 / t116
  t120 = 0.1e1 / t116 / t73
  t123 = 0.1e1 / t116 / t74
  t127 = -t75 / 0.30e2 + t78 / 0.70e2 - t81 / 0.135e3 + t84 / 0.231e3 - t87 / 0.364e3 + t90 / 0.540e3 - t93 / 0.765e3 + t96 / 0.1045e4 - t99 / 0.1386e4 + t102 / 0.1794e4 - t105 / 0.2275e4 + t108 / 0.2835e4 - t111 / 0.3480e4 + t114 / 0.4216e4 - t117 / 0.5049e4 + t120 / 0.5985e4 - t123 / 0.7030e4 + 0.1e1 / t73 / 0.9e1
  t128 = f.my_piecewise3(t71, 0.192e1, t69)
  t129 = jnp.arctan2(0.1e1, t128)
  t130 = t128 ** 2
  t131 = t130 + 0.3e1
  t132 = 0.1e1 / t130
  t133 = 0.1e1 + t132
  t134 = jnp.log(t133)
  t136 = -t131 * t134 + 0.1e1
  t139 = t129 + t128 * t136 / 0.4e1
  t143 = f.my_piecewise3(t70, t127, 0.1e1 - 0.8e1 / 0.3e1 * t128 * t139)
  t145 = t31 * t143 * t56
  t148 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t149 = t148 * f.p.zeta_threshold
  t151 = f.my_piecewise3(t20, t149, t21 * t19)
  t152 = t5 * t151
  t153 = t31 ** 2
  t154 = 0.1e1 / t153
  t156 = t154 * t143 * t56
  t158 = t152 * t156 / 0.8e1
  t159 = t74 * t72
  t160 = 0.1e1 / t159
  t164 = f.p.cam_omega / t60 / t59 * t63
  t166 = t32 * t36
  t168 = t164 * t66 * jnp.pi * t166
  t169 = t56 ** 2
  t170 = 0.1e1 / t169
  t171 = t37 * t170
  t172 = t53 ** 2
  t173 = 0.1e1 / t172
  t174 = t171 * t173
  t175 = t45 * r0
  t177 = 0.1e1 / t47 / t175
  t179 = t44 * s0 * t177
  t184 = 0.1e1 / t65 / t64
  t185 = t63 * t184
  t187 = t26 * t6 + t18 + 0.1e1
  t191 = -0.39416108509596690476000000000000000000000000000002e-2 * t168 * t174 * t179 - t62 * t185 * t187 / 0.6e1
  t192 = f.my_piecewise3(t71, t191, 0)
  t195 = t73 * t72
  t196 = t74 * t195
  t197 = 0.1e1 / t196
  t200 = t80 * t72
  t201 = 0.1e1 / t200
  t204 = t80 * t195
  t205 = 0.1e1 / t204
  t208 = t80 * t159
  t209 = 0.1e1 / t208
  t212 = t80 * t196
  t213 = 0.1e1 / t212
  t217 = 0.1e1 / t92 / t72
  t221 = 0.1e1 / t92 / t195
  t225 = 0.1e1 / t92 / t159
  t229 = 0.1e1 / t92 / t196
  t233 = 0.1e1 / t92 / t200
  t237 = 0.1e1 / t92 / t204
  t241 = 0.1e1 / t92 / t208
  t245 = 0.1e1 / t92 / t212
  t249 = 0.1e1 / t116 / t72
  t253 = 0.1e1 / t116 / t195
  t257 = 0.1e1 / t116 / t159
  t260 = 0.1e1 / t195
  t263 = 0.2e1 / 0.15e2 * t160 * t192 - 0.3e1 / 0.35e2 * t197 * t192 + 0.8e1 / 0.135e3 * t201 * t192 - 0.10e2 / 0.231e3 * t205 * t192 + 0.3e1 / 0.91e2 * t209 * t192 - 0.7e1 / 0.270e3 * t213 * t192 + 0.16e2 / 0.765e3 * t217 * t192 - 0.18e2 / 0.1045e4 * t221 * t192 + 0.10e2 / 0.693e3 * t225 * t192 - 0.11e2 / 0.897e3 * t229 * t192 + 0.24e2 / 0.2275e4 * t233 * t192 - 0.26e2 / 0.2835e4 * t237 * t192 + 0.7e1 / 0.870e3 * t241 * t192 - 0.15e2 / 0.2108e4 * t245 * t192 + 0.32e2 / 0.5049e4 * t249 * t192 - 0.34e2 / 0.5985e4 * t253 * t192 + 0.18e2 / 0.3515e4 * t257 * t192 - 0.2e1 / 0.9e1 * t260 * t192
  t264 = f.my_piecewise3(t71, 0, t191)
  t267 = 0.1e1 / t133
  t274 = 0.1e1 / t130 / t128
  t275 = t131 * t274
  t276 = t264 * t267
  t279 = -0.2e1 * t128 * t264 * t134 + 0.2e1 * t275 * t276
  t282 = -t132 * t264 * t267 + t264 * t136 / 0.4e1 + t128 * t279 / 0.4e1
  t286 = f.my_piecewise3(t70, t263, -0.8e1 / 0.3e1 * t128 * t282 - 0.8e1 / 0.3e1 * t264 * t139)
  t288 = t31 * t286 * t56
  t291 = t151 * t31
  t293 = t5 * t291 * t143
  t294 = t173 * t39
  t295 = t43 * s0
  t297 = t294 * t295 * t177
  t301 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t30 * t145 - t158 - 0.3e1 / 0.8e1 * t152 * t288 + 0.59124162764395035714000000000000000000000000000004e-2 * t293 * t297)
  t303 = r1 <= f.p.dens_threshold
  t304 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t305 = 0.1e1 + t304
  t306 = t305 <= f.p.zeta_threshold
  t307 = t305 ** (0.1e1 / 0.3e1)
  t309 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t312 = f.my_piecewise3(t306, 0, 0.4e1 / 0.3e1 * t307 * t309)
  t313 = t5 * t312
  t314 = r1 ** 2
  t315 = r1 ** (0.1e1 / 0.3e1)
  t316 = t315 ** 2
  t322 = 0.8040e0 + 0.91464571985215458333333333333333333333333333333336e-2 * t44 * s2 / t316 / t314
  t325 = 0.18040e1 - 0.64641600e0 / t322
  t328 = t33 * t38 / t325
  t329 = jnp.sqrt(t328)
  t331 = f.p.cam_omega / t329
  t332 = t305 * t6
  t333 = t332 ** (0.1e1 / 0.3e1)
  t334 = 0.1e1 / t333
  t337 = t331 * t63 * t334 / 0.2e1
  t338 = 0.192e1 <= t337
  t339 = 0.192e1 < t337
  t340 = f.my_piecewise3(t339, t337, 0.192e1)
  t341 = t340 ** 2
  t342 = t341 ** 2
  t343 = 0.1e1 / t342
  t345 = t342 * t341
  t346 = 0.1e1 / t345
  t348 = t342 ** 2
  t349 = 0.1e1 / t348
  t351 = t348 * t341
  t352 = 0.1e1 / t351
  t354 = t348 * t342
  t355 = 0.1e1 / t354
  t357 = t348 * t345
  t358 = 0.1e1 / t357
  t360 = t348 ** 2
  t361 = 0.1e1 / t360
  t364 = 0.1e1 / t360 / t341
  t367 = 0.1e1 / t360 / t342
  t370 = 0.1e1 / t360 / t345
  t373 = 0.1e1 / t360 / t348
  t376 = 0.1e1 / t360 / t351
  t379 = 0.1e1 / t360 / t354
  t382 = 0.1e1 / t360 / t357
  t384 = t360 ** 2
  t385 = 0.1e1 / t384
  t388 = 0.1e1 / t384 / t341
  t391 = 0.1e1 / t384 / t342
  t395 = -t343 / 0.30e2 + t346 / 0.70e2 - t349 / 0.135e3 + t352 / 0.231e3 - t355 / 0.364e3 + t358 / 0.540e3 - t361 / 0.765e3 + t364 / 0.1045e4 - t367 / 0.1386e4 + t370 / 0.1794e4 - t373 / 0.2275e4 + t376 / 0.2835e4 - t379 / 0.3480e4 + t382 / 0.4216e4 - t385 / 0.5049e4 + t388 / 0.5985e4 - t391 / 0.7030e4 + 0.1e1 / t341 / 0.9e1
  t396 = f.my_piecewise3(t339, 0.192e1, t337)
  t397 = jnp.arctan2(0.1e1, t396)
  t398 = t396 ** 2
  t399 = t398 + 0.3e1
  t400 = 0.1e1 / t398
  t401 = 0.1e1 + t400
  t402 = jnp.log(t401)
  t404 = -t399 * t402 + 0.1e1
  t407 = t397 + t396 * t404 / 0.4e1
  t411 = f.my_piecewise3(t338, t395, 0.1e1 - 0.8e1 / 0.3e1 * t396 * t407)
  t413 = t31 * t411 * t325
  t417 = f.my_piecewise3(t306, t149, t307 * t305)
  t418 = t5 * t417
  t420 = t154 * t411 * t325
  t422 = t418 * t420 / 0.8e1
  t423 = t342 * t340
  t424 = 0.1e1 / t423
  t426 = 0.1e1 / t333 / t332
  t427 = t63 * t426
  t429 = t309 * t6 + t304 + 0.1e1
  t432 = t331 * t427 * t429 / 0.6e1
  t433 = f.my_piecewise3(t339, -t432, 0)
  t436 = t341 * t340
  t437 = t342 * t436
  t438 = 0.1e1 / t437
  t441 = t348 * t340
  t442 = 0.1e1 / t441
  t445 = t348 * t436
  t446 = 0.1e1 / t445
  t449 = t348 * t423
  t450 = 0.1e1 / t449
  t453 = t348 * t437
  t454 = 0.1e1 / t453
  t458 = 0.1e1 / t360 / t340
  t462 = 0.1e1 / t360 / t436
  t466 = 0.1e1 / t360 / t423
  t470 = 0.1e1 / t360 / t437
  t474 = 0.1e1 / t360 / t441
  t478 = 0.1e1 / t360 / t445
  t482 = 0.1e1 / t360 / t449
  t486 = 0.1e1 / t360 / t453
  t490 = 0.1e1 / t384 / t340
  t494 = 0.1e1 / t384 / t436
  t498 = 0.1e1 / t384 / t423
  t501 = 0.1e1 / t436
  t504 = 0.2e1 / 0.15e2 * t424 * t433 - 0.3e1 / 0.35e2 * t438 * t433 + 0.8e1 / 0.135e3 * t442 * t433 - 0.10e2 / 0.231e3 * t446 * t433 + 0.3e1 / 0.91e2 * t450 * t433 - 0.7e1 / 0.270e3 * t454 * t433 + 0.16e2 / 0.765e3 * t458 * t433 - 0.18e2 / 0.1045e4 * t462 * t433 + 0.10e2 / 0.693e3 * t466 * t433 - 0.11e2 / 0.897e3 * t470 * t433 + 0.24e2 / 0.2275e4 * t474 * t433 - 0.26e2 / 0.2835e4 * t478 * t433 + 0.7e1 / 0.870e3 * t482 * t433 - 0.15e2 / 0.2108e4 * t486 * t433 + 0.32e2 / 0.5049e4 * t490 * t433 - 0.34e2 / 0.5985e4 * t494 * t433 + 0.18e2 / 0.3515e4 * t498 * t433 - 0.2e1 / 0.9e1 * t501 * t433
  t505 = f.my_piecewise3(t339, 0, -t432)
  t508 = 0.1e1 / t401
  t515 = 0.1e1 / t398 / t396
  t516 = t399 * t515
  t517 = t505 * t508
  t520 = -0.2e1 * t396 * t505 * t402 + 0.2e1 * t516 * t517
  t523 = -t400 * t505 * t508 + t505 * t404 / 0.4e1 + t396 * t520 / 0.4e1
  t527 = f.my_piecewise3(t338, t504, -0.8e1 / 0.3e1 * t396 * t523 - 0.8e1 / 0.3e1 * t505 * t407)
  t529 = t31 * t527 * t325
  t533 = f.my_piecewise3(t303, 0, -0.3e1 / 0.8e1 * t313 * t413 - t422 - 0.3e1 / 0.8e1 * t418 * t529)
  t535 = t21 ** 2
  t536 = 0.1e1 / t535
  t537 = t26 ** 2
  t542 = t16 / t22 / t6
  t544 = -0.2e1 * t23 + 0.2e1 * t542
  t545 = f.my_piecewise5(t10, 0, t14, 0, t544)
  t549 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t536 * t537 + 0.4e1 / 0.3e1 * t21 * t545)
  t553 = t30 * t156
  t563 = 0.1e1 / t153 / t6
  t567 = t152 * t563 * t143 * t56 / 0.12e2
  t570 = t152 * t154 * t286 * t56
  t575 = t5 * t151 * t154 * t143 * t297
  t577 = t40 * t2
  t578 = t35 ** 2
  t579 = 0.1e1 / t578
  t580 = t37 ** 2
  t581 = t579 * t580
  t590 = t2 * t579
  t593 = t169 ** 2
  t596 = t172 ** 2
  t597 = 0.1e1 / t596
  t599 = t39 ** 2
  t601 = 0.1e1 / t41 / t40
  t602 = t599 * t601
  t603 = s0 ** 2
  t604 = t45 ** 2
  t607 = 0.1e1 / t46 / t604 / t175
  t609 = t602 * t603 * t607
  t630 = 0.1e1 / t172 / t53
  t636 = 0.1e1 / t47 / t604
  t642 = t19 ** 2
  t645 = 0.1e1 / t65 / t642 / t22
  t646 = t63 * t645
  t647 = t187 ** 2
  t657 = 0.93217776602418038170677705605528946394560000000010e-4 * f.p.cam_omega / t60 / t577 / t581 / t170 * t63 * t66 * t40 * t590 * t580 / t593 * t597 * t609 + 0.26277405673064460317333333333333333333333333333335e-2 * t164 * t184 * jnp.pi * t166 * t171 * t294 * t295 * t177 * t187 - 0.12429036880322405089423694080737192852608000000001e-3 * t168 * t37 / t169 / t56 * t597 * t609 - 0.19227613302149707138164423654020310222222222222224e-3 * t168 * t171 * t630 * t609 + 0.14452573120185453174533333333333333333333333333334e-1 * t168 * t174 * t44 * s0 * t636 + 0.2e1 / 0.9e1 * t62 * t646 * t647 - t62 * t185 * (t545 * t6 + 0.2e1 * t26) / 0.6e1
  t658 = f.my_piecewise3(t71, t657, 0)
  t667 = t192 ** 2
  t696 = 0.2e1 / 0.15e2 * t160 * t658 - 0.3e1 / 0.35e2 * t197 * t658 + 0.8e1 / 0.135e3 * t201 * t658 - 0.10e2 / 0.231e3 * t205 * t658 + 0.7e1 / 0.18e2 * t93 * t667 - 0.26e2 / 0.2835e4 * t237 * t658 + 0.18e2 / 0.55e2 * t99 * t667 - 0.16e2 / 0.45e2 * t96 * t667 + 0.3e1 / 0.5e1 * t81 * t667 + 0.3e1 / 0.91e2 * t209 * t658 - 0.2e1 / 0.3e1 * t78 * t667 - 0.8e1 / 0.15e2 * t84 * t667 + 0.10e2 / 0.21e2 * t87 * t667 - 0.3e1 / 0.7e1 * t90 * t667 - 0.2e1 / 0.9e1 * t260 * t658 + 0.18e2 / 0.3515e4 * t257 * t658 - 0.34e2 / 0.5985e4 * t253 * t658 + 0.32e2 / 0.5049e4 * t249 * t658
  t732 = 0.1e1 / t116 / t77
  t735 = 0.7e1 / 0.870e3 * t241 * t658 - 0.15e2 / 0.2108e4 * t245 * t658 + 0.10e2 / 0.693e3 * t225 * t658 - 0.11e2 / 0.897e3 * t229 * t658 + 0.24e2 / 0.2275e4 * t233 * t658 + 0.16e2 / 0.765e3 * t217 * t658 - 0.18e2 / 0.1045e4 * t221 * t658 - 0.7e1 / 0.270e3 * t213 * t658 - 0.10e2 / 0.33e2 * t102 * t667 + 0.11e2 / 0.39e2 * t105 * t667 - 0.24e2 / 0.91e2 * t108 * t667 - 0.7e1 / 0.30e2 * t114 * t667 + 0.15e2 / 0.68e2 * t117 * t667 + 0.26e2 / 0.105e3 * t111 * t667 - 0.32e2 / 0.153e3 * t120 * t667 + 0.34e2 / 0.171e3 * t123 * t667 + 0.2e1 / 0.3e1 * t75 * t667 - 0.18e2 / 0.95e2 * t732 * t667
  t737 = f.my_piecewise3(t71, 0, t657)
  t742 = t264 ** 2
  t748 = t130 ** 2
  t750 = 0.1e1 / t748 / t128
  t752 = t133 ** 2
  t753 = 0.1e1 / t752
  t769 = t131 / t748
  t778 = t131 / t748 / t130
  t789 = f.my_piecewise3(t70, t696 + t735, -0.8e1 / 0.3e1 * t737 * t139 - 0.16e2 / 0.3e1 * t264 * t282 - 0.8e1 / 0.3e1 * t128 * (0.2e1 * t274 * t742 * t267 - t132 * t737 * t267 - 0.2e1 * t750 * t742 * t753 + t737 * t136 / 0.4e1 + t264 * t279 / 0.2e1 + t128 * (-0.2e1 * t128 * t737 * t134 + 0.8e1 * t132 * t742 * t267 + 0.2e1 * t275 * t737 * t267 - 0.6e1 * t769 * t742 * t267 + 0.4e1 * t778 * t742 * t753 - 0.2e1 * t742 * t134) / 0.4e1))
  t808 = -0.3e1 / 0.8e1 * t5 * t549 * t145 - t553 / 0.4e1 - 0.3e1 / 0.4e1 * t30 * t288 + 0.11824832552879007142800000000000000000000000000001e-1 * t5 * t29 * t31 * t143 * t297 + t567 - t570 / 0.4e1 + 0.39416108509596690476000000000000000000000000000002e-2 * t575 - 0.3e1 / 0.8e1 * t152 * t31 * t789 * t56 + 0.11824832552879007142800000000000000000000000000001e-1 * t5 * t291 * t286 * t297 + 0.28841419953224560707246635481030465333333333333337e-3 * t293 * t630 * t599 * t601 * t603 * t607 - 0.21678859680278179761800000000000000000000000000001e-1 * t293 * t294 * t295 * t636
  t809 = f.my_piecewise3(t1, 0, t808)
  t810 = t307 ** 2
  t811 = 0.1e1 / t810
  t812 = t309 ** 2
  t816 = f.my_piecewise5(t14, 0, t10, 0, -t544)
  t820 = f.my_piecewise3(t306, 0, 0.4e1 / 0.9e1 * t811 * t812 + 0.4e1 / 0.3e1 * t307 * t816)
  t824 = t313 * t420
  t831 = t418 * t563 * t411 * t325 / 0.12e2
  t834 = t418 * t154 * t527 * t325
  t836 = t433 ** 2
  t842 = 0.1e1 / t384 / t345
  t847 = t305 ** 2
  t850 = 0.1e1 / t333 / t847 / t22
  t851 = t63 * t850
  t852 = t429 ** 2
  t862 = 0.2e1 / 0.9e1 * t331 * t851 * t852 - t331 * t427 * (t816 * t6 + 0.2e1 * t309) / 0.6e1
  t863 = f.my_piecewise3(t339, t862, 0)
  t892 = -0.32e2 / 0.153e3 * t388 * t836 + 0.34e2 / 0.171e3 * t391 * t836 - 0.18e2 / 0.95e2 * t842 * t836 + 0.2e1 / 0.3e1 * t343 * t836 + 0.7e1 / 0.870e3 * t482 * t863 + 0.8e1 / 0.135e3 * t442 * t863 - 0.26e2 / 0.2835e4 * t478 * t863 + 0.3e1 / 0.5e1 * t349 * t836 - 0.10e2 / 0.231e3 * t446 * t863 - 0.2e1 / 0.3e1 * t346 * t836 - 0.8e1 / 0.15e2 * t352 * t836 + 0.10e2 / 0.21e2 * t355 * t836 - 0.3e1 / 0.7e1 * t358 * t836 + 0.7e1 / 0.18e2 * t361 * t836 - 0.16e2 / 0.45e2 * t364 * t836 + 0.18e2 / 0.55e2 * t367 * t836 - 0.10e2 / 0.33e2 * t370 * t836 + 0.11e2 / 0.39e2 * t373 * t836
  t929 = -0.24e2 / 0.91e2 * t376 * t836 + 0.26e2 / 0.105e3 * t379 * t836 - 0.7e1 / 0.30e2 * t382 * t836 + 0.15e2 / 0.68e2 * t385 * t836 - 0.15e2 / 0.2108e4 * t486 * t863 + 0.32e2 / 0.5049e4 * t490 * t863 - 0.34e2 / 0.5985e4 * t494 * t863 + 0.18e2 / 0.3515e4 * t498 * t863 - 0.2e1 / 0.9e1 * t501 * t863 + 0.3e1 / 0.91e2 * t450 * t863 - 0.7e1 / 0.270e3 * t454 * t863 - 0.3e1 / 0.35e2 * t438 * t863 + 0.2e1 / 0.15e2 * t424 * t863 + 0.24e2 / 0.2275e4 * t474 * t863 - 0.11e2 / 0.897e3 * t470 * t863 + 0.10e2 / 0.693e3 * t466 * t863 - 0.18e2 / 0.1045e4 * t462 * t863 + 0.16e2 / 0.765e3 * t458 * t863
  t931 = f.my_piecewise3(t339, 0, t862)
  t936 = t505 ** 2
  t942 = t398 ** 2
  t944 = 0.1e1 / t942 / t396
  t946 = t401 ** 2
  t947 = 0.1e1 / t946
  t963 = t399 / t942
  t972 = t399 / t942 / t398
  t983 = f.my_piecewise3(t338, t892 + t929, -0.8e1 / 0.3e1 * t931 * t407 - 0.16e2 / 0.3e1 * t505 * t523 - 0.8e1 / 0.3e1 * t396 * (0.2e1 * t515 * t936 * t508 - t400 * t931 * t508 - 0.2e1 * t944 * t936 * t947 + t931 * t404 / 0.4e1 + t505 * t520 / 0.2e1 + t396 * (-0.2e1 * t396 * t931 * t402 + 0.8e1 * t400 * t936 * t508 + 0.2e1 * t516 * t931 * t508 - 0.6e1 * t963 * t936 * t508 + 0.4e1 * t972 * t936 * t947 - 0.2e1 * t936 * t402) / 0.4e1))
  t989 = f.my_piecewise3(t303, 0, -0.3e1 / 0.8e1 * t5 * t820 * t413 - t824 / 0.4e1 - 0.3e1 / 0.4e1 * t313 * t529 + t831 - t834 / 0.4e1 - 0.3e1 / 0.8e1 * t418 * t31 * t983 * t325)
  d11 = 0.2e1 * t301 + 0.2e1 * t533 + t6 * (t809 + t989)
  t992 = -t7 - t24
  t993 = f.my_piecewise5(t10, 0, t14, 0, t992)
  t996 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t993)
  t997 = t5 * t996
  t1001 = t993 * t6 + t18 + 0.1e1
  t1004 = t62 * t185 * t1001 / 0.6e1
  t1005 = f.my_piecewise3(t71, -t1004, 0)
  t1042 = 0.2e1 / 0.15e2 * t160 * t1005 - 0.3e1 / 0.35e2 * t197 * t1005 + 0.8e1 / 0.135e3 * t201 * t1005 - 0.10e2 / 0.231e3 * t205 * t1005 + 0.3e1 / 0.91e2 * t209 * t1005 - 0.7e1 / 0.270e3 * t213 * t1005 + 0.16e2 / 0.765e3 * t217 * t1005 - 0.18e2 / 0.1045e4 * t221 * t1005 + 0.10e2 / 0.693e3 * t225 * t1005 - 0.11e2 / 0.897e3 * t229 * t1005 + 0.24e2 / 0.2275e4 * t233 * t1005 - 0.26e2 / 0.2835e4 * t237 * t1005 + 0.7e1 / 0.870e3 * t241 * t1005 - 0.15e2 / 0.2108e4 * t245 * t1005 + 0.32e2 / 0.5049e4 * t249 * t1005 - 0.34e2 / 0.5985e4 * t253 * t1005 + 0.18e2 / 0.3515e4 * t257 * t1005 - 0.2e1 / 0.9e1 * t260 * t1005
  t1043 = f.my_piecewise3(t71, 0, -t1004)
  t1045 = t132 * t1043
  t1051 = t1043 * t267
  t1054 = -0.2e1 * t128 * t1043 * t134 + 0.2e1 * t275 * t1051
  t1057 = -t1045 * t267 + t1043 * t136 / 0.4e1 + t128 * t1054 / 0.4e1
  t1061 = f.my_piecewise3(t70, t1042, -0.8e1 / 0.3e1 * t1043 * t139 - 0.8e1 / 0.3e1 * t128 * t1057)
  t1063 = t31 * t1061 * t56
  t1067 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t997 * t145 - t158 - 0.3e1 / 0.8e1 * t152 * t1063)
  t1069 = f.my_piecewise5(t14, 0, t10, 0, -t992)
  t1072 = f.my_piecewise3(t306, 0, 0.4e1 / 0.3e1 * t307 * t1069)
  t1073 = t5 * t1072
  t1079 = f.p.cam_omega / t329 / t328 * t63
  t1082 = t1079 * t334 * jnp.pi * t166
  t1083 = t325 ** 2
  t1084 = 0.1e1 / t1083
  t1085 = t37 * t1084
  t1086 = t322 ** 2
  t1087 = 0.1e1 / t1086
  t1088 = t1085 * t1087
  t1089 = t314 * r1
  t1091 = 0.1e1 / t316 / t1089
  t1098 = t1069 * t6 + t304 + 0.1e1
  t1102 = -0.39416108509596690476000000000000000000000000000002e-2 * t1082 * t1088 * t44 * s2 * t1091 - t331 * t427 * t1098 / 0.6e1
  t1103 = f.my_piecewise3(t339, t1102, 0)
  t1140 = 0.2e1 / 0.15e2 * t424 * t1103 - 0.3e1 / 0.35e2 * t438 * t1103 + 0.8e1 / 0.135e3 * t442 * t1103 - 0.10e2 / 0.231e3 * t446 * t1103 + 0.3e1 / 0.91e2 * t450 * t1103 - 0.7e1 / 0.270e3 * t454 * t1103 + 0.16e2 / 0.765e3 * t458 * t1103 - 0.18e2 / 0.1045e4 * t462 * t1103 + 0.10e2 / 0.693e3 * t466 * t1103 - 0.11e2 / 0.897e3 * t470 * t1103 + 0.24e2 / 0.2275e4 * t474 * t1103 - 0.26e2 / 0.2835e4 * t478 * t1103 + 0.7e1 / 0.870e3 * t482 * t1103 - 0.15e2 / 0.2108e4 * t486 * t1103 + 0.32e2 / 0.5049e4 * t490 * t1103 - 0.34e2 / 0.5985e4 * t494 * t1103 + 0.18e2 / 0.3515e4 * t498 * t1103 - 0.2e1 / 0.9e1 * t501 * t1103
  t1141 = f.my_piecewise3(t339, 0, t1102)
  t1143 = t400 * t1141
  t1149 = t1141 * t508
  t1152 = -0.2e1 * t396 * t1141 * t402 + 0.2e1 * t516 * t1149
  t1155 = -t1143 * t508 + t1141 * t404 / 0.4e1 + t396 * t1152 / 0.4e1
  t1159 = f.my_piecewise3(t338, t1140, -0.8e1 / 0.3e1 * t1141 * t407 - 0.8e1 / 0.3e1 * t396 * t1155)
  t1161 = t31 * t1159 * t325
  t1164 = t417 * t31
  t1166 = t5 * t1164 * t411
  t1167 = t1087 * t39
  t1168 = t43 * s2
  t1170 = t1167 * t1168 * t1091
  t1174 = f.my_piecewise3(t303, 0, -0.3e1 / 0.8e1 * t1073 * t413 - t422 - 0.3e1 / 0.8e1 * t418 * t1161 + 0.59124162764395035714000000000000000000000000000004e-2 * t1166 * t1170)
  t1178 = 0.2e1 * t542
  t1179 = f.my_piecewise5(t10, 0, t14, 0, t1178)
  t1183 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t536 * t993 * t26 + 0.4e1 / 0.3e1 * t21 * t1179)
  t1187 = t997 * t156
  t1203 = t152 * t154 * t1061 * t56
  t1223 = 0.13138702836532230158666666666666666666666666666668e-2 * t164 * t184 * t1001 * t33 * t38 * t170 * t173 * t179 + 0.2e1 / 0.9e1 * t62 * t63 * t645 * t1001 * t187 - t62 * t185 * (t1179 * t6 + t26 + t993) / 0.6e1
  t1224 = f.my_piecewise3(t71, t1223, 0)
  t1261 = 0.10e2 / 0.693e3 * t225 * t1224 - 0.11e2 / 0.897e3 * t229 * t1224 - 0.15e2 / 0.2108e4 * t245 * t1224 + 0.32e2 / 0.5049e4 * t249 * t1224 - 0.34e2 / 0.5985e4 * t253 * t1224 + 0.24e2 / 0.2275e4 * t233 * t1224 - 0.26e2 / 0.2835e4 * t237 * t1224 + 0.3e1 / 0.91e2 * t209 * t1224 - 0.7e1 / 0.270e3 * t213 * t1224 + 0.16e2 / 0.765e3 * t217 * t1224 - 0.18e2 / 0.1045e4 * t221 * t1224 + 0.2e1 / 0.15e2 * t160 * t1224 - 0.3e1 / 0.35e2 * t197 * t1224 + 0.8e1 / 0.135e3 * t201 * t1224 - 0.2e1 / 0.9e1 * t260 * t1224 + 0.7e1 / 0.870e3 * t241 * t1224 - 0.10e2 / 0.231e3 * t205 * t1224 + 0.18e2 / 0.3515e4 * t257 * t1224
  t1316 = -0.16e2 / 0.45e2 * t96 * t1005 * t192 + 0.18e2 / 0.55e2 * t99 * t1005 * t192 - 0.10e2 / 0.33e2 * t102 * t1005 * t192 + 0.11e2 / 0.39e2 * t105 * t1005 * t192 - 0.24e2 / 0.91e2 * t108 * t1005 * t192 + 0.26e2 / 0.105e3 * t111 * t1005 * t192 - 0.7e1 / 0.30e2 * t114 * t1005 * t192 + 0.15e2 / 0.68e2 * t117 * t1005 * t192 - 0.32e2 / 0.153e3 * t120 * t1005 * t192 + 0.34e2 / 0.171e3 * t123 * t1005 * t192 - 0.18e2 / 0.95e2 * t732 * t1005 * t192 + 0.2e1 / 0.3e1 * t75 * t1005 * t192 - 0.2e1 / 0.3e1 * t78 * t1005 * t192 + 0.3e1 / 0.5e1 * t81 * t1005 * t192 - 0.8e1 / 0.15e2 * t84 * t1005 * t192 + 0.10e2 / 0.21e2 * t87 * t1005 * t192 - 0.3e1 / 0.7e1 * t90 * t1005 * t192 + 0.7e1 / 0.18e2 * t93 * t1005 * t192
  t1318 = f.my_piecewise3(t71, 0, t1223)
  t1362 = f.my_piecewise3(t70, t1261 + t1316, -0.8e1 / 0.3e1 * t1318 * t139 - 0.8e1 / 0.3e1 * t1043 * t282 - 0.8e1 / 0.3e1 * t264 * t1057 - 0.8e1 / 0.3e1 * t128 * (0.2e1 * t274 * t1043 * t276 - t132 * t1318 * t267 - 0.2e1 * t750 * t1043 * t753 * t264 + t1318 * t136 / 0.4e1 + t1043 * t279 / 0.4e1 + t264 * t1054 / 0.4e1 + t128 * (0.4e1 * t778 * t1043 * t753 * t264 - 0.2e1 * t264 * t1043 * t134 - 0.6e1 * t769 * t1051 * t264 - 0.2e1 * t128 * t1318 * t134 + 0.2e1 * t275 * t1318 * t267 + 0.8e1 * t1045 * t276) / 0.4e1))
  t1371 = -0.3e1 / 0.8e1 * t5 * t1183 * t145 - t1187 / 0.8e1 - 0.3e1 / 0.8e1 * t997 * t288 + 0.59124162764395035714000000000000000000000000000004e-2 * t5 * t996 * t31 * t143 * t297 - t553 / 0.8e1 + t567 - t570 / 0.8e1 + 0.19708054254798345238000000000000000000000000000001e-2 * t575 - 0.3e1 / 0.8e1 * t30 * t1063 - t1203 / 0.8e1 - 0.3e1 / 0.8e1 * t152 * t31 * t1362 * t56 + 0.59124162764395035714000000000000000000000000000004e-2 * t5 * t291 * t1061 * t297
  t1372 = f.my_piecewise3(t1, 0, t1371)
  t1376 = f.my_piecewise5(t14, 0, t10, 0, -t1178)
  t1380 = f.my_piecewise3(t306, 0, 0.4e1 / 0.9e1 * t811 * t1069 * t309 + 0.4e1 / 0.3e1 * t307 * t1376)
  t1384 = t1073 * t420
  t1394 = t418 * t154 * t1159 * t325
  t1398 = t1079 * t426 * jnp.pi * t166
  t1399 = t1085 * t1167
  t1415 = 0.13138702836532230158666666666666666666666666666667e-2 * t1398 * t1399 * t1168 * t1091 * t429 + 0.2e1 / 0.9e1 * t331 * t63 * t850 * t1098 * t429 - t331 * t427 * (t1376 * t6 + t1069 + t309) / 0.6e1
  t1416 = f.my_piecewise3(t339, t1415, 0)
  t1453 = -0.18e2 / 0.1045e4 * t462 * t1416 + 0.3e1 / 0.91e2 * t450 * t1416 - 0.3e1 / 0.35e2 * t438 * t1416 + 0.24e2 / 0.2275e4 * t474 * t1416 - 0.7e1 / 0.270e3 * t454 * t1416 + 0.7e1 / 0.870e3 * t482 * t1416 - 0.10e2 / 0.231e3 * t446 * t1416 + 0.2e1 / 0.15e2 * t424 * t1416 - 0.26e2 / 0.2835e4 * t478 * t1416 + 0.16e2 / 0.765e3 * t458 * t1416 + 0.10e2 / 0.693e3 * t466 * t1416 + 0.8e1 / 0.135e3 * t442 * t1416 - 0.11e2 / 0.897e3 * t470 * t1416 - 0.2e1 / 0.9e1 * t501 * t1416 + 0.18e2 / 0.3515e4 * t498 * t1416 - 0.34e2 / 0.5985e4 * t494 * t1416 + 0.32e2 / 0.5049e4 * t490 * t1416 - 0.15e2 / 0.2108e4 * t486 * t1416
  t1508 = 0.34e2 / 0.171e3 * t391 * t1103 * t433 - 0.16e2 / 0.45e2 * t364 * t1103 * t433 + 0.18e2 / 0.55e2 * t367 * t1103 * t433 - 0.10e2 / 0.33e2 * t370 * t1103 * t433 + 0.11e2 / 0.39e2 * t373 * t1103 * t433 - 0.24e2 / 0.91e2 * t376 * t1103 * t433 + 0.26e2 / 0.105e3 * t379 * t1103 * t433 - 0.7e1 / 0.30e2 * t382 * t1103 * t433 + 0.3e1 / 0.5e1 * t349 * t1103 * t433 - 0.8e1 / 0.15e2 * t352 * t1103 * t433 + 0.10e2 / 0.21e2 * t355 * t1103 * t433 - 0.3e1 / 0.7e1 * t358 * t1103 * t433 + 0.7e1 / 0.18e2 * t361 * t1103 * t433 - 0.2e1 / 0.3e1 * t346 * t1103 * t433 - 0.18e2 / 0.95e2 * t842 * t1103 * t433 + 0.2e1 / 0.3e1 * t343 * t1103 * t433 + 0.15e2 / 0.68e2 * t385 * t1103 * t433 - 0.32e2 / 0.153e3 * t388 * t1103 * t433
  t1510 = f.my_piecewise3(t339, 0, t1415)
  t1554 = f.my_piecewise3(t338, t1453 + t1508, -0.8e1 / 0.3e1 * t1510 * t407 - 0.8e1 / 0.3e1 * t1141 * t523 - 0.8e1 / 0.3e1 * t505 * t1155 - 0.8e1 / 0.3e1 * t396 * (0.2e1 * t515 * t1141 * t517 - t400 * t1510 * t508 - 0.2e1 * t944 * t1141 * t947 * t505 + t1510 * t404 / 0.4e1 + t1141 * t520 / 0.4e1 + t505 * t1152 / 0.4e1 + t396 * (0.4e1 * t972 * t1141 * t947 * t505 - 0.2e1 * t505 * t1141 * t402 - 0.6e1 * t963 * t1149 * t505 - 0.2e1 * t396 * t1510 * t402 + 0.2e1 * t516 * t1510 * t508 + 0.8e1 * t1143 * t517) / 0.4e1))
  t1567 = t5 * t417 * t154 * t411 * t1170
  t1573 = -0.3e1 / 0.8e1 * t5 * t1380 * t413 - t1384 / 0.8e1 - 0.3e1 / 0.8e1 * t1073 * t529 - t824 / 0.8e1 + t831 - t834 / 0.8e1 - 0.3e1 / 0.8e1 * t313 * t1161 - t1394 / 0.8e1 - 0.3e1 / 0.8e1 * t418 * t31 * t1554 * t325 + 0.59124162764395035714000000000000000000000000000004e-2 * t5 * t312 * t31 * t411 * t1170 + 0.19708054254798345238000000000000000000000000000001e-2 * t1567 + 0.59124162764395035714000000000000000000000000000004e-2 * t5 * t1164 * t527 * t1170
  t1574 = f.my_piecewise3(t303, 0, t1573)
  d12 = t301 + t533 + t1067 + t1174 + t6 * (t1372 + t1574)
  t1579 = t993 ** 2
  t1583 = 0.2e1 * t23 + 0.2e1 * t542
  t1584 = f.my_piecewise5(t10, 0, t14, 0, t1583)
  t1588 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t536 * t1579 + 0.4e1 / 0.3e1 * t21 * t1584)
  t1596 = t1005 ** 2
  t1603 = t1001 ** 2
  t1613 = 0.2e1 / 0.9e1 * t62 * t646 * t1603 - t62 * t185 * (t1584 * t6 + 0.2e1 * t993) / 0.6e1
  t1614 = f.my_piecewise3(t71, t1613, 0)
  t1645 = 0.2e1 / 0.3e1 * t75 * t1596 - 0.8e1 / 0.15e2 * t84 * t1596 - 0.18e2 / 0.95e2 * t732 * t1596 + 0.32e2 / 0.5049e4 * t249 * t1614 - 0.34e2 / 0.5985e4 * t253 * t1614 + 0.18e2 / 0.3515e4 * t257 * t1614 - 0.3e1 / 0.35e2 * t197 * t1614 - 0.10e2 / 0.231e3 * t205 * t1614 + 0.3e1 / 0.91e2 * t209 * t1614 + 0.8e1 / 0.135e3 * t201 * t1614 + 0.10e2 / 0.693e3 * t225 * t1614 - 0.10e2 / 0.33e2 * t102 * t1596 + 0.10e2 / 0.21e2 * t87 * t1596 - 0.3e1 / 0.7e1 * t90 * t1596 + 0.7e1 / 0.18e2 * t93 * t1596 - 0.16e2 / 0.45e2 * t96 * t1596 + 0.18e2 / 0.55e2 * t99 * t1596 - 0.2e1 / 0.9e1 * t260 * t1614
  t1682 = 0.7e1 / 0.870e3 * t241 * t1614 - 0.15e2 / 0.2108e4 * t245 * t1614 + 0.11e2 / 0.39e2 * t105 * t1596 - 0.7e1 / 0.270e3 * t213 * t1614 + 0.16e2 / 0.765e3 * t217 * t1614 - 0.18e2 / 0.1045e4 * t221 * t1614 + 0.34e2 / 0.171e3 * t123 * t1596 - 0.32e2 / 0.153e3 * t120 * t1596 + 0.2e1 / 0.15e2 * t160 * t1614 - 0.11e2 / 0.897e3 * t229 * t1614 + 0.24e2 / 0.2275e4 * t233 * t1614 - 0.26e2 / 0.2835e4 * t237 * t1614 + 0.26e2 / 0.105e3 * t111 * t1596 - 0.24e2 / 0.91e2 * t108 * t1596 + 0.15e2 / 0.68e2 * t117 * t1596 - 0.2e1 / 0.3e1 * t78 * t1596 - 0.7e1 / 0.30e2 * t114 * t1596 + 0.3e1 / 0.5e1 * t81 * t1596
  t1684 = f.my_piecewise3(t71, 0, t1613)
  t1689 = t1043 ** 2
  t1726 = f.my_piecewise3(t70, t1645 + t1682, -0.8e1 / 0.3e1 * t1684 * t139 - 0.16e2 / 0.3e1 * t1043 * t1057 - 0.8e1 / 0.3e1 * t128 * (0.2e1 * t274 * t1689 * t267 - t132 * t1684 * t267 - 0.2e1 * t750 * t1689 * t753 + t1684 * t136 / 0.4e1 + t1043 * t1054 / 0.2e1 + t128 * (-0.2e1 * t128 * t1684 * t134 + 0.8e1 * t132 * t1689 * t267 + 0.2e1 * t275 * t1684 * t267 - 0.6e1 * t769 * t1689 * t267 + 0.4e1 * t778 * t1689 * t753 - 0.2e1 * t1689 * t134) / 0.4e1))
  t1732 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t1588 * t145 - t1187 / 0.4e1 - 0.3e1 / 0.4e1 * t997 * t1063 + t567 - t1203 / 0.4e1 - 0.3e1 / 0.8e1 * t152 * t31 * t1726 * t56)
  t1733 = t1069 ** 2
  t1737 = f.my_piecewise5(t14, 0, t10, 0, -t1583)
  t1741 = f.my_piecewise3(t306, 0, 0.4e1 / 0.9e1 * t811 * t1733 + 0.4e1 / 0.3e1 * t307 * t1737)
  t1765 = t1083 ** 2
  t1768 = t1086 ** 2
  t1769 = 0.1e1 / t1768
  t1771 = s2 ** 2
  t1772 = t314 ** 2
  t1775 = 0.1e1 / t315 / t1772 / t1089
  t1777 = t602 * t1771 * t1775
  t1794 = 0.1e1 / t1086 / t322
  t1800 = 0.1e1 / t316 / t1772
  t1806 = t1098 ** 2
  t1816 = 0.93217776602418038170677705605528946394560000000010e-4 * f.p.cam_omega / t329 / t577 / t581 / t1084 * t63 * t334 * t40 * t590 * t580 / t1765 * t1769 * t1777 + 0.26277405673064460317333333333333333333333333333335e-2 * t1398 * t1399 * t1168 * t1091 * t1098 - 0.12429036880322405089423694080737192852608000000001e-3 * t1082 * t37 / t1083 / t325 * t1769 * t1777 - 0.19227613302149707138164423654020310222222222222224e-3 * t1082 * t1085 * t1794 * t1777 + 0.14452573120185453174533333333333333333333333333334e-1 * t1082 * t1088 * t44 * s2 * t1800 + 0.2e1 / 0.9e1 * t331 * t851 * t1806 - t331 * t427 * (t1737 * t6 + 0.2e1 * t1069) / 0.6e1
  t1817 = f.my_piecewise3(t339, t1816, 0)
  t1822 = t1103 ** 2
  t1855 = -0.26e2 / 0.2835e4 * t478 * t1817 + 0.32e2 / 0.5049e4 * t490 * t1817 - 0.8e1 / 0.15e2 * t352 * t1822 - 0.32e2 / 0.153e3 * t388 * t1822 + 0.2e1 / 0.15e2 * t424 * t1817 - 0.3e1 / 0.35e2 * t438 * t1817 + 0.8e1 / 0.135e3 * t442 * t1817 - 0.10e2 / 0.231e3 * t446 * t1817 + 0.24e2 / 0.2275e4 * t474 * t1817 + 0.26e2 / 0.105e3 * t379 * t1822 - 0.34e2 / 0.5985e4 * t494 * t1817 - 0.18e2 / 0.1045e4 * t462 * t1817 + 0.16e2 / 0.765e3 * t458 * t1817 + 0.18e2 / 0.3515e4 * t498 * t1817 - 0.16e2 / 0.45e2 * t364 * t1822 - 0.2e1 / 0.9e1 * t501 * t1817 + 0.18e2 / 0.55e2 * t367 * t1822 - 0.15e2 / 0.2108e4 * t486 * t1817
  t1892 = -0.7e1 / 0.30e2 * t382 * t1822 + 0.3e1 / 0.91e2 * t450 * t1817 - 0.24e2 / 0.91e2 * t376 * t1822 - 0.7e1 / 0.270e3 * t454 * t1817 - 0.11e2 / 0.897e3 * t470 * t1817 + 0.34e2 / 0.171e3 * t391 * t1822 + 0.15e2 / 0.68e2 * t385 * t1822 - 0.10e2 / 0.33e2 * t370 * t1822 + 0.11e2 / 0.39e2 * t373 * t1822 + 0.7e1 / 0.870e3 * t482 * t1817 - 0.2e1 / 0.3e1 * t346 * t1822 + 0.3e1 / 0.5e1 * t349 * t1822 + 0.10e2 / 0.21e2 * t355 * t1822 + 0.2e1 / 0.3e1 * t343 * t1822 - 0.18e2 / 0.95e2 * t842 * t1822 + 0.10e2 / 0.693e3 * t466 * t1817 + 0.7e1 / 0.18e2 * t361 * t1822 - 0.3e1 / 0.7e1 * t358 * t1822
  t1894 = f.my_piecewise3(t339, 0, t1816)
  t1899 = t1141 ** 2
  t1936 = f.my_piecewise3(t338, t1855 + t1892, -0.8e1 / 0.3e1 * t1894 * t407 - 0.16e2 / 0.3e1 * t1141 * t1155 - 0.8e1 / 0.3e1 * t396 * (0.2e1 * t515 * t1899 * t508 - t400 * t1894 * t508 - 0.2e1 * t944 * t1899 * t947 + t1894 * t404 / 0.4e1 + t1141 * t1152 / 0.2e1 + t396 * (-0.2e1 * t396 * t1894 * t402 + 0.2e1 * t516 * t1894 * t508 + 0.8e1 * t400 * t1899 * t508 - 0.6e1 * t963 * t1899 * t508 + 0.4e1 * t972 * t1899 * t947 - 0.2e1 * t1899 * t402) / 0.4e1))
  t1955 = -0.3e1 / 0.8e1 * t5 * t1741 * t413 - t1384 / 0.4e1 - 0.3e1 / 0.4e1 * t1073 * t1161 + 0.11824832552879007142800000000000000000000000000001e-1 * t5 * t1072 * t31 * t411 * t1170 + t831 - t1394 / 0.4e1 + 0.39416108509596690476000000000000000000000000000002e-2 * t1567 - 0.3e1 / 0.8e1 * t418 * t31 * t1936 * t325 + 0.11824832552879007142800000000000000000000000000001e-1 * t5 * t1164 * t1159 * t1170 + 0.28841419953224560707246635481030465333333333333337e-3 * t1166 * t1794 * t599 * t601 * t1771 * t1775 - 0.21678859680278179761800000000000000000000000000001e-1 * t1166 * t1167 * t1168 * t1800
  t1956 = f.my_piecewise3(t303, 0, t1955)
  d22 = 0.2e1 * t1067 + 0.2e1 * t1174 + t6 * (t1732 + t1956)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

