"""Generated from hyb_mgga_x_dldf.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_kappa = 4.8827323

  params_mu = 0.3511128

  dldf_a = np.array([np.nan, 1, -0.1637571, -0.1880028, -0.4490609, -0.0082359], dtype=np.float64)

  dldf_csi_HF = 1 - 0.6144129

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  pbe_f = lambda x: pbe_f0(X2S * x)

  dldf_f = lambda x, u, t: +dldf_csi_HF * pbe_f(x) * mgga_series_w(dldf_a, 5, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, dldf_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_kappa = 4.8827323

  params_mu = 0.3511128

  dldf_a = np.array([np.nan, 1, -0.1637571, -0.1880028, -0.4490609, -0.0082359], dtype=np.float64)

  dldf_csi_HF = 1 - 0.6144129

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  pbe_f = lambda x: pbe_f0(X2S * x)

  dldf_f = lambda x, u, t: +dldf_csi_HF * pbe_f(x) * mgga_series_w(dldf_a, 5, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, dldf_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_kappa = 4.8827323

  params_mu = 0.3511128

  dldf_a = np.array([np.nan, 1, -0.1637571, -0.1880028, -0.4490609, -0.0082359], dtype=np.float64)

  dldf_csi_HF = 1 - 0.6144129

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  pbe_f = lambda x: pbe_f0(X2S * x)

  dldf_f = lambda x, u, t: +dldf_csi_HF * pbe_f(x) * mgga_series_w(dldf_a, 5, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, dldf_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t5 * t25
  t27 = t6 ** (0.1e1 / 0.3e1)
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = jnp.pi ** 2
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = 0.1e1 / t31
  t33 = t28 * t32
  t34 = r0 ** 2
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / t34
  t42 = 0.48827323e1 + 0.14629700000000000000000000000000000000000000000000e-1 * t33 * s0 * t38
  t45 = 0.226830568763333e1 - 0.9192810859647640947559e1 / t42
  t46 = t27 * t45
  t47 = t28 ** 2
  t49 = 0.3e1 / 0.10e2 * t47 * t31
  t51 = 0.1e1 / t36 / r0
  t52 = tau0 * t51
  t53 = t49 - t52
  t54 = t49 + t52
  t55 = 0.1e1 / t54
  t58 = t53 ** 2
  t59 = t54 ** 2
  t60 = 0.1e1 / t59
  t63 = t58 * t53
  t65 = 0.1e1 / t59 / t54
  t68 = t58 ** 2
  t69 = t59 ** 2
  t70 = 0.1e1 / t69
  t73 = 0.1e1 - 0.1637571e0 * t53 * t55 - 0.1880028e0 * t58 * t60 - 0.4490609e0 * t63 * t65 - 0.82359e-2 * t68 * t70
  t74 = t46 * t73
  t77 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t26 * t74)
  t78 = r1 <= f.p.dens_threshold
  t79 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t80 = 0.1e1 + t79
  t81 = t80 <= f.p.zeta_threshold
  t82 = t80 ** (0.1e1 / 0.3e1)
  t84 = f.my_piecewise3(t81, t22, t82 * t80)
  t85 = t5 * t84
  t86 = r1 ** 2
  t87 = r1 ** (0.1e1 / 0.3e1)
  t88 = t87 ** 2
  t90 = 0.1e1 / t88 / t86
  t94 = 0.48827323e1 + 0.14629700000000000000000000000000000000000000000000e-1 * t33 * s2 * t90
  t97 = 0.226830568763333e1 - 0.9192810859647640947559e1 / t94
  t98 = t27 * t97
  t100 = 0.1e1 / t88 / r1
  t101 = tau1 * t100
  t102 = t49 - t101
  t103 = t49 + t101
  t104 = 0.1e1 / t103
  t107 = t102 ** 2
  t108 = t103 ** 2
  t109 = 0.1e1 / t108
  t112 = t107 * t102
  t114 = 0.1e1 / t108 / t103
  t117 = t107 ** 2
  t118 = t108 ** 2
  t119 = 0.1e1 / t118
  t122 = 0.1e1 - 0.1637571e0 * t102 * t104 - 0.1880028e0 * t107 * t109 - 0.4490609e0 * t112 * t114 - 0.82359e-2 * t117 * t119
  t123 = t98 * t122
  t126 = f.my_piecewise3(t78, 0, -0.3e1 / 0.8e1 * t85 * t123)
  t127 = t6 ** 2
  t129 = t16 / t127
  t130 = t7 - t129
  t131 = f.my_piecewise5(t10, 0, t14, 0, t130)
  t134 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t131)
  t138 = t27 ** 2
  t139 = 0.1e1 / t138
  t143 = t26 * t139 * t45 * t73 / 0.8e1
  t144 = t25 * t27
  t145 = t42 ** 2
  t146 = 0.1e1 / t145
  t157 = tau0 * t38
  t160 = t53 * t60
  t163 = t58 * t65
  t166 = t63 * t70
  t171 = t68 / t69 / t54
  t179 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t134 * t74 - t143 + 0.13448806503338709277050390230000000000000000000000e0 * t5 * t144 * t146 * t33 * s0 / t36 / t34 / r0 * t73 - 0.3e1 / 0.8e1 * t26 * t46 * (-0.27292850000000000000000000000000000000000000000000e0 * t157 * t55 - 0.89960450000000000000000000000000000000000000000000e0 * t160 * t157 - 0.28719805000000000000000000000000000000000000000000e1 * t163 * t157 - 0.23002105000000000000000000000000000000000000000000e1 * t166 * t157 - 0.54906000000000000000000000000000000000000000000000e-1 * t171 * t157))
  t181 = f.my_piecewise5(t14, 0, t10, 0, -t130)
  t184 = f.my_piecewise3(t81, 0, 0.4e1 / 0.3e1 * t82 * t181)
  t191 = t85 * t139 * t97 * t122 / 0.8e1
  t193 = f.my_piecewise3(t78, 0, -0.3e1 / 0.8e1 * t5 * t184 * t123 - t191)
  vrho_0_ = t77 + t126 + t6 * (t179 + t193)
  t196 = -t7 - t129
  t197 = f.my_piecewise5(t10, 0, t14, 0, t196)
  t200 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t197)
  t205 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t200 * t74 - t143)
  t207 = f.my_piecewise5(t14, 0, t10, 0, -t196)
  t210 = f.my_piecewise3(t81, 0, 0.4e1 / 0.3e1 * t82 * t207)
  t214 = t84 * t27
  t215 = t94 ** 2
  t216 = 0.1e1 / t215
  t227 = tau1 * t90
  t230 = t102 * t109
  t233 = t107 * t114
  t236 = t112 * t119
  t241 = t117 / t118 / t103
  t249 = f.my_piecewise3(t78, 0, -0.3e1 / 0.8e1 * t5 * t210 * t123 - t191 + 0.13448806503338709277050390230000000000000000000000e0 * t5 * t214 * t216 * t33 * s2 / t88 / t86 / r1 * t122 - 0.3e1 / 0.8e1 * t85 * t98 * (-0.27292850000000000000000000000000000000000000000000e0 * t227 * t104 - 0.89960450000000000000000000000000000000000000000000e0 * t230 * t227 - 0.28719805000000000000000000000000000000000000000000e1 * t233 * t227 - 0.23002105000000000000000000000000000000000000000000e1 * t236 * t227 - 0.54906000000000000000000000000000000000000000000000e-1 * t241 * t227))
  vrho_1_ = t77 + t126 + t6 * (t205 + t249)
  t259 = f.my_piecewise3(t1, 0, -0.50433024387520159788938963362500000000000000000000e-1 * t5 * t144 * t146 * t28 * t32 * t38 * t73)
  vsigma_0_ = t6 * t259
  vsigma_1_ = 0.0e0
  t267 = f.my_piecewise3(t78, 0, -0.50433024387520159788938963362500000000000000000000e-1 * t5 * t214 * t216 * t28 * t32 * t90 * t122)
  vsigma_2_ = t6 * t267
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t282 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t26 * t46 * (0.1637571e0 * t51 * t55 + 0.5397627e0 * t160 * t51 + 0.17231883e1 * t163 * t51 + 0.13801263e1 * t166 * t51 + 0.329436e-1 * t171 * t51))
  vtau_0_ = t6 * t282
  t297 = f.my_piecewise3(t78, 0, -0.3e1 / 0.8e1 * t85 * t98 * (0.1637571e0 * t100 * t104 + 0.5397627e0 * t230 * t100 + 0.17231883e1 * t233 * t100 + 0.13801263e1 * t236 * t100 + 0.329436e-1 * t241 * t100))
  vtau_1_ = t6 * t297
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_kappa = 4.8827323

  params_mu = 0.3511128

  dldf_a = np.array([np.nan, 1, -0.1637571, -0.1880028, -0.4490609, -0.0082359], dtype=np.float64)

  dldf_csi_HF = 1 - 0.6144129

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  pbe_f = lambda x: pbe_f0(X2S * x)

  dldf_f = lambda x, u, t: +dldf_csi_HF * pbe_f(x) * mgga_series_w(dldf_a, 5, t)

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, dldf_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** 2
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = 0.1e1 / t23
  t25 = t20 * t24
  t26 = 2 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = s0 * t27
  t29 = r0 ** 2
  t30 = t19 ** 2
  t32 = 0.1e1 / t30 / t29
  t36 = 0.48827323e1 + 0.14629700000000000000000000000000000000000000000000e-1 * t25 * t28 * t32
  t39 = 0.226830568763333e1 - 0.9192810859647640947559e1 / t36
  t40 = t19 * t39
  t41 = t20 ** 2
  t43 = 0.3e1 / 0.10e2 * t41 * t23
  t44 = tau0 * t27
  t46 = 0.1e1 / t30 / r0
  t47 = t44 * t46
  t48 = t43 - t47
  t49 = t43 + t47
  t50 = 0.1e1 / t49
  t53 = t48 ** 2
  t54 = t49 ** 2
  t55 = 0.1e1 / t54
  t58 = t53 * t48
  t60 = 0.1e1 / t54 / t49
  t63 = t53 ** 2
  t64 = t54 ** 2
  t65 = 0.1e1 / t64
  t68 = 0.1e1 - 0.1637571e0 * t48 * t50 - 0.1880028e0 * t53 * t55 - 0.4490609e0 * t58 * t60 - 0.82359e-2 * t63 * t65
  t72 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t40 * t68)
  t82 = t36 ** 2
  t83 = 0.1e1 / t82
  t93 = t48 * t55
  t94 = t44 * t32
  t97 = t53 * t60
  t100 = t58 * t65
  t105 = t63 / t64 / t49
  t113 = f.my_piecewise3(t2, 0, -t18 / t30 * t39 * t68 / 0.8e1 + 0.13448806503338709277050390230000000000000000000000e0 * t6 * t17 / t19 / t29 / r0 * t83 * t25 * t28 * t68 - 0.3e1 / 0.8e1 * t18 * t40 * (-0.27292850000000000000000000000000000000000000000000e0 * t44 * t32 * t50 - 0.89960450000000000000000000000000000000000000000000e0 * t93 * t94 - 0.28719805000000000000000000000000000000000000000000e1 * t97 * t94 - 0.23002105000000000000000000000000000000000000000000e1 * t100 * t94 - 0.54906000000000000000000000000000000000000000000000e-1 * t105 * t94))
  vrho_0_ = 0.2e1 * r0 * t113 + 0.2e1 * t72
  t126 = f.my_piecewise3(t2, 0, -0.50433024387520159788938963362500000000000000000000e-1 * t6 * t17 / t19 / t29 * t83 * t20 * t24 * t27 * t68)
  vsigma_0_ = 0.2e1 * r0 * t126
  vlapl_0_ = 0.0e0
  t128 = t27 * t46
  t143 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t40 * (0.1637571e0 * t128 * t50 + 0.5397627e0 * t93 * t128 + 0.17231883e1 * t97 * t128 + 0.13801263e1 * t100 * t128 + 0.329436e-1 * t105 * t128))
  vtau_0_ = 0.2e1 * r0 * t143
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 6 ** (0.1e1 / 0.3e1)
  t23 = jnp.pi ** 2
  t24 = t23 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t27 = t22 / t25
  t28 = 2 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = s0 * t29
  t31 = r0 ** 2
  t33 = 0.1e1 / t20 / t31
  t37 = 0.48827323e1 + 0.14629700000000000000000000000000000000000000000000e-1 * t27 * t30 * t33
  t40 = 0.58827323e1 - 0.2384107471346329e2 / t37
  t41 = 0.1e1 / t20 * t40
  t42 = t22 ** 2
  t44 = 0.3e1 / 0.10e2 * t42 * t25
  t45 = tau0 * t29
  t47 = 0.1e1 / t20 / r0
  t48 = t45 * t47
  t49 = t44 - t48
  t50 = t44 + t48
  t51 = 0.1e1 / t50
  t54 = t49 ** 2
  t55 = t50 ** 2
  t56 = 0.1e1 / t55
  t59 = t54 * t49
  t61 = 0.1e1 / t55 / t50
  t64 = t54 ** 2
  t65 = t55 ** 2
  t66 = 0.1e1 / t65
  t69 = 0.1e1 - 0.1637571e0 * t49 * t51 - 0.1880028e0 * t54 * t56 - 0.4490609e0 * t59 * t61 - 0.82359e-2 * t64 * t66
  t73 = t31 * r0
  t77 = t37 ** 2
  t78 = 0.1e1 / t77
  t80 = t6 * t17 / t19 / t73 * t78
  t82 = t27 * t30 * t69
  t85 = t19 * t40
  t89 = t49 * t56
  t90 = t45 * t33
  t93 = t54 * t61
  t96 = t59 * t66
  t100 = 0.1e1 / t65 / t50
  t101 = t64 * t100
  t104 = -0.27292850000000000000000000000000000000000000000000e0 * t45 * t33 * t51 - 0.89960450000000000000000000000000000000000000000000e0 * t89 * t90 - 0.28719805000000000000000000000000000000000000000000e1 * t93 * t90 - 0.23002105000000000000000000000000000000000000000000e1 * t96 * t90 - 0.54906000000000000000000000000000000000000000000000e-1 * t101 * t90
  t109 = f.my_piecewise3(t2, 0, -0.48198387500000000000000000000000000000000000000000e-1 * t18 * t41 * t69 + 0.13448806503338709277050390230000000000000000000000e0 * t80 * t82 - 0.14459516250000000000000000000000000000000000000000e0 * t18 * t85 * t104)
  t115 = t31 ** 2
  t136 = s0 ** 2
  t147 = 0.1e1 / t20 / t73
  t151 = tau0 ** 2
  t152 = t151 * t28
  t155 = 0.1e1 / t19 / t115 / r0
  t160 = t152 * t155
  t163 = t45 * t147
  t188 = f.my_piecewise3(t2, 0, 0.32132258333333333333333333333333333333333333333333e-1 * t18 * t47 * t40 * t69 - 0.40346419510016127831151170690000000000000000000000e0 * t6 * t17 / t19 / t115 * t78 * t82 - 0.96396775000000000000000000000000000000000000000000e-1 * t18 * t41 * t104 + 0.20986880480202060278449503354435306666666666666666e-1 * t6 * t17 / t115 / t73 / t77 / t37 * t42 / t24 / t23 * t136 * t28 * t69 + 0.26897613006677418554100780460000000000000000000000e0 * t80 * t27 * t30 * t104 - 0.14459516250000000000000000000000000000000000000000e0 * t18 * t85 * (0.72780933333333333333333333333333333333333333333333e0 * t45 * t147 * t51 - 0.39084433333333333333333333333333333333333333333334e1 * t152 * t155 * t56 - 0.25143900000000000000000000000000000000000000000000e2 * t49 * t61 * t160 + 0.23989453333333333333333333333333333333333333333333e1 * t89 * t163 - 0.51721910000000000000000000000000000000000000000000e2 * t54 * t66 * t160 + 0.76586146666666666666666666666666666666666666666667e1 * t93 * t163 - 0.31401553333333333333333333333333333333333333333333e2 * t59 * t100 * t160 + 0.61338946666666666666666666666666666666666666666667e1 * t96 * t163 - 0.91510000000000000000000000000000000000000000000000e0 * t64 / t65 / t55 * t160 + 0.14641600000000000000000000000000000000000000000000e0 * t101 * t163))
  v2rho2_0_ = 0.2e1 * r0 * t188 + 0.4e1 * t109
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / r0
  t23 = 6 ** (0.1e1 / 0.3e1)
  t24 = jnp.pi ** 2
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t28 = t23 / t26
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = s0 * t30
  t32 = r0 ** 2
  t34 = 0.1e1 / t20 / t32
  t38 = 0.48827323e1 + 0.14629700000000000000000000000000000000000000000000e-1 * t28 * t31 * t34
  t41 = 0.58827323e1 - 0.2384107471346329e2 / t38
  t42 = t22 * t41
  t43 = t23 ** 2
  t45 = 0.3e1 / 0.10e2 * t43 * t26
  t46 = tau0 * t30
  t47 = t46 * t22
  t48 = t45 - t47
  t49 = t45 + t47
  t50 = 0.1e1 / t49
  t53 = t48 ** 2
  t54 = t49 ** 2
  t55 = 0.1e1 / t54
  t58 = t53 * t48
  t59 = t54 * t49
  t60 = 0.1e1 / t59
  t63 = t53 ** 2
  t64 = t54 ** 2
  t65 = 0.1e1 / t64
  t68 = 0.1e1 - 0.1637571e0 * t48 * t50 - 0.1880028e0 * t53 * t55 - 0.4490609e0 * t58 * t60 - 0.82359e-2 * t63 * t65
  t72 = t32 ** 2
  t76 = t38 ** 2
  t77 = 0.1e1 / t76
  t79 = t6 * t17 / t19 / t72 * t77
  t81 = t28 * t31 * t68
  t85 = 0.1e1 / t20 * t41
  t89 = t48 * t55
  t90 = t46 * t34
  t93 = t53 * t60
  t96 = t58 * t65
  t100 = 0.1e1 / t64 / t49
  t101 = t63 * t100
  t104 = -0.27292850000000000000000000000000000000000000000000e0 * t46 * t34 * t50 - 0.89960450000000000000000000000000000000000000000000e0 * t89 * t90 - 0.28719805000000000000000000000000000000000000000000e1 * t93 * t90 - 0.23002105000000000000000000000000000000000000000000e1 * t96 * t90 - 0.54906000000000000000000000000000000000000000000000e-1 * t101 * t90
  t108 = t32 * r0
  t113 = 0.1e1 / t76 / t38
  t115 = t6 * t17 / t72 / t108 * t113
  t118 = t43 / t25 / t24
  t119 = s0 ** 2
  t120 = t119 * t29
  t122 = t118 * t120 * t68
  t129 = t6 * t17 / t19 / t108 * t77
  t131 = t28 * t31 * t104
  t134 = t19 * t41
  t136 = 0.1e1 / t20 / t108
  t140 = tau0 ** 2
  t141 = t140 * t29
  t144 = 0.1e1 / t19 / t72 / r0
  t148 = t48 * t60
  t149 = t141 * t144
  t152 = t46 * t136
  t155 = t53 * t65
  t160 = t58 * t100
  t166 = 0.1e1 / t64 / t54
  t167 = t63 * t166
  t172 = 0.72780933333333333333333333333333333333333333333333e0 * t46 * t136 * t50 - 0.39084433333333333333333333333333333333333333333334e1 * t141 * t144 * t55 - 0.25143900000000000000000000000000000000000000000000e2 * t148 * t149 + 0.23989453333333333333333333333333333333333333333333e1 * t89 * t152 - 0.51721910000000000000000000000000000000000000000000e2 * t155 * t149 + 0.76586146666666666666666666666666666666666666666667e1 * t93 * t152 - 0.31401553333333333333333333333333333333333333333333e2 * t160 * t149 + 0.61338946666666666666666666666666666666666666666667e1 * t96 * t152 - 0.91510000000000000000000000000000000000000000000000e0 * t167 * t149 + 0.14641600000000000000000000000000000000000000000000e0 * t101 * t152
  t177 = f.my_piecewise3(t2, 0, 0.32132258333333333333333333333333333333333333333333e-1 * t18 * t42 * t68 - 0.40346419510016127831151170690000000000000000000000e0 * t79 * t81 - 0.96396775000000000000000000000000000000000000000000e-1 * t18 * t85 * t104 + 0.20986880480202060278449503354435306666666666666666e-1 * t115 * t122 + 0.26897613006677418554100780460000000000000000000000e0 * t129 * t131 - 0.14459516250000000000000000000000000000000000000000e0 * t18 * t134 * t172)
  t191 = t72 ** 2
  t192 = 0.1e1 / t191
  t203 = t24 ** 2
  t211 = t76 ** 2
  t228 = t140 * tau0 * t192
  t232 = 0.1e1 / t20 / t72
  t238 = 0.1e1 / t19 / t72 / t32
  t256 = t141 * t238
  t259 = t46 * t232
  t274 = -0.10986928888888888888888888888888888888888888888889e3 * t228 * t60 - 0.26686342222222222222222222222222222222222222222222e1 * t46 * t232 * t50 + 0.31267546666666666666666666666666666666666666666666e2 * t141 * t238 * t55 - 0.59625173333333333333333333333333333333333333333333e3 * t48 * t65 * t228 - 0.10036410000000000000000000000000000000000000000000e4 * t53 * t100 * t228 - 0.53556055555555555555555555555555555555555555555555e3 * t58 * t166 * t228 - 0.18302000000000000000000000000000000000000000000000e2 * t63 / t64 / t59 * t228 + 0.20115120000000000000000000000000000000000000000000e3 * t148 * t256 - 0.87961328888888888888888888888888888888888888888888e1 * t89 * t259 + 0.41377528000000000000000000000000000000000000000001e3 * t155 * t256 - 0.28081587111111111111111111111111111111111111111111e2 * t93 * t259 + 0.25121242666666666666666666666666666666666666666666e3 * t160 * t256 - 0.22490947111111111111111111111111111111111111111111e2 * t96 * t259 + 0.73208000000000000000000000000000000000000000000000e1 * t167 * t256 - 0.53685866666666666666666666666666666666666666666667e0 * t101 * t259
  t279 = f.my_piecewise3(t2, 0, -0.53553763888888888888888888888888888888888888888888e-1 * t18 * t34 * t41 * t68 + 0.17184586087599461854008831960555555555555555555556e1 * t6 * t17 * t144 * t77 * t81 + 0.96396775000000000000000000000000000000000000000000e-1 * t18 * t42 * t104 - 0.20986880480202060278449503354435306666666666666666e0 * t6 * t17 * t192 * t113 * t122 - 0.12103925853004838349345351207000000000000000000000e1 * t79 * t131 - 0.14459516250000000000000000000000000000000000000000e0 * t18 * t85 * t172 + 0.29475049474676359800540739125540691770367999999999e-1 * t3 / t4 / t203 * t17 / t20 / t191 / t32 / t211 * t119 * s0 * t68 + 0.62960641440606180835348510063305919999999999999998e-1 * t115 * t118 * t120 * t104 + 0.40346419510016127831151170690000000000000000000000e0 * t129 * t28 * t31 * t172 - 0.14459516250000000000000000000000000000000000000000e0 * t18 * t134 * t274)
  v3rho3_0_ = 0.2e1 * r0 * t279 + 0.6e1 * t177

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** 2
  t20 = r0 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t23 = 0.1e1 / t21 / t19
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t29 = t24 / t27
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = s0 * t31
  t36 = 0.48827323e1 + 0.14629700000000000000000000000000000000000000000000e-1 * t29 * t32 * t23
  t39 = 0.58827323e1 - 0.2384107471346329e2 / t36
  t40 = t23 * t39
  t41 = t24 ** 2
  t43 = 0.3e1 / 0.10e2 * t41 * t27
  t44 = tau0 * t31
  t46 = 0.1e1 / t21 / r0
  t47 = t44 * t46
  t48 = t43 - t47
  t49 = t43 + t47
  t50 = 0.1e1 / t49
  t53 = t48 ** 2
  t54 = t49 ** 2
  t55 = 0.1e1 / t54
  t58 = t53 * t48
  t59 = t54 * t49
  t60 = 0.1e1 / t59
  t63 = t53 ** 2
  t64 = t54 ** 2
  t65 = 0.1e1 / t64
  t68 = 0.1e1 - 0.1637571e0 * t48 * t50 - 0.1880028e0 * t53 * t55 - 0.4490609e0 * t58 * t60 - 0.82359e-2 * t63 * t65
  t72 = t19 ** 2
  t73 = t72 * r0
  t75 = 0.1e1 / t20 / t73
  t77 = t36 ** 2
  t78 = 0.1e1 / t77
  t80 = t6 * t17 * t75 * t78
  t82 = t29 * t32 * t68
  t85 = t46 * t39
  t89 = t48 * t55
  t90 = t44 * t23
  t93 = t53 * t60
  t96 = t58 * t65
  t100 = 0.1e1 / t64 / t49
  t101 = t63 * t100
  t104 = -0.27292850000000000000000000000000000000000000000000e0 * t44 * t23 * t50 - 0.89960450000000000000000000000000000000000000000000e0 * t89 * t90 - 0.28719805000000000000000000000000000000000000000000e1 * t93 * t90 - 0.23002105000000000000000000000000000000000000000000e1 * t96 * t90 - 0.54906000000000000000000000000000000000000000000000e-1 * t101 * t90
  t108 = t72 ** 2
  t109 = 0.1e1 / t108
  t112 = 0.1e1 / t77 / t36
  t114 = t6 * t17 * t109 * t112
  t117 = t41 / t26 / t25
  t118 = s0 ** 2
  t119 = t118 * t30
  t121 = t117 * t119 * t68
  t128 = t6 * t17 / t20 / t72 * t78
  t130 = t29 * t32 * t104
  t134 = 0.1e1 / t21 * t39
  t135 = t19 * r0
  t137 = 0.1e1 / t21 / t135
  t141 = tau0 ** 2
  t142 = t141 * t30
  t146 = t48 * t60
  t147 = t142 * t75
  t150 = t44 * t137
  t153 = t53 * t65
  t158 = t58 * t100
  t164 = 0.1e1 / t64 / t54
  t165 = t63 * t164
  t170 = 0.72780933333333333333333333333333333333333333333333e0 * t44 * t137 * t50 - 0.39084433333333333333333333333333333333333333333334e1 * t142 * t75 * t55 - 0.25143900000000000000000000000000000000000000000000e2 * t146 * t147 + 0.23989453333333333333333333333333333333333333333333e1 * t89 * t150 - 0.51721910000000000000000000000000000000000000000000e2 * t153 * t147 + 0.76586146666666666666666666666666666666666666666667e1 * t93 * t150 - 0.31401553333333333333333333333333333333333333333333e2 * t158 * t147 + 0.61338946666666666666666666666666666666666666666667e1 * t96 * t150 - 0.91510000000000000000000000000000000000000000000000e0 * t165 * t147 + 0.14641600000000000000000000000000000000000000000000e0 * t101 * t150
  t174 = t25 ** 2
  t177 = t3 / t4 / t174
  t178 = t177 * t17
  t181 = 0.1e1 / t21 / t108 / t19
  t182 = t77 ** 2
  t183 = 0.1e1 / t182
  t184 = t181 * t183
  t185 = t118 * s0
  t186 = t185 * t68
  t190 = t72 * t135
  t194 = t6 * t17 / t190 * t112
  t196 = t117 * t119 * t104
  t203 = t6 * t17 / t20 / t135 * t78
  t205 = t29 * t32 * t170
  t208 = t20 * t39
  t209 = t141 * tau0
  t210 = t209 * t109
  t214 = 0.1e1 / t21 / t72
  t218 = t72 * t19
  t220 = 0.1e1 / t20 / t218
  t224 = t48 * t65
  t227 = t53 * t100
  t230 = t58 * t164
  t234 = 0.1e1 / t64 / t59
  t235 = t63 * t234
  t238 = t142 * t220
  t241 = t44 * t214
  t256 = -0.10986928888888888888888888888888888888888888888889e3 * t210 * t60 - 0.26686342222222222222222222222222222222222222222222e1 * t44 * t214 * t50 + 0.31267546666666666666666666666666666666666666666666e2 * t142 * t220 * t55 - 0.59625173333333333333333333333333333333333333333333e3 * t224 * t210 - 0.10036410000000000000000000000000000000000000000000e4 * t227 * t210 - 0.53556055555555555555555555555555555555555555555555e3 * t230 * t210 - 0.18302000000000000000000000000000000000000000000000e2 * t235 * t210 + 0.20115120000000000000000000000000000000000000000000e3 * t146 * t238 - 0.87961328888888888888888888888888888888888888888888e1 * t89 * t241 + 0.41377528000000000000000000000000000000000000000001e3 * t153 * t238 - 0.28081587111111111111111111111111111111111111111111e2 * t93 * t241 + 0.25121242666666666666666666666666666666666666666666e3 * t158 * t238 - 0.22490947111111111111111111111111111111111111111111e2 * t96 * t241 + 0.73208000000000000000000000000000000000000000000000e1 * t165 * t238 - 0.53685866666666666666666666666666666666666666666667e0 * t101 * t241
  t261 = f.my_piecewise3(t2, 0, -0.53553763888888888888888888888888888888888888888888e-1 * t18 * t40 * t68 + 0.17184586087599461854008831960555555555555555555556e1 * t80 * t82 + 0.96396775000000000000000000000000000000000000000000e-1 * t18 * t85 * t104 - 0.20986880480202060278449503354435306666666666666666e0 * t114 * t121 - 0.12103925853004838349345351207000000000000000000000e1 * t128 * t130 - 0.14459516250000000000000000000000000000000000000000e0 * t18 * t134 * t170 + 0.29475049474676359800540739125540691770367999999999e-1 * t178 * t184 * t186 + 0.62960641440606180835348510063305919999999999999998e-1 * t194 * t196 + 0.40346419510016127831151170690000000000000000000000e0 * t203 * t205 - 0.14459516250000000000000000000000000000000000000000e0 * t18 * t208 * t256)
  t264 = 0.1e1 / t21 / t73
  t265 = t44 * t264
  t269 = 0.1e1 / t20 / t190
  t270 = t142 * t269
  t289 = 0.1e1 / t108 / r0
  t290 = t209 * t289
  t294 = t141 ** 2
  t295 = t294 * t181
  t296 = t295 * t31
  t311 = t64 ** 2
  t324 = 0.25053404444444444444444444444444444444444444444445e1 * t101 * t265 - 0.15198090666666666666666666666666666666666666666666e4 * t146 * t270 + 0.41048620148148148148148148148148148148148148148148e2 * t89 * t265 - 0.31263021155555555555555555555555555555555555555556e4 * t153 * t270 + 0.13104740651851851851851851851851851851851851851852e3 * t93 * t265 - 0.18980494459259259259259259259259259259259259259259e4 * t158 * t270 + 0.10495775318518518518518518518518518518518518518518e3 * t96 * t265 - 0.55312711111111111111111111111111111111111111111112e2 * t165 * t270 + 0.12453626370370370370370370370370370370370370370370e2 * t44 * t264 * t50 + 0.95400277333333333333333333333333333333333333333333e4 * t224 * t290 - 0.73204815555555555555555555555555555555555555555555e4 * t48 * t100 * t296 + 0.16058256000000000000000000000000000000000000000001e5 * t227 * t290 - 0.11041477777777777777777777777777777777777777777778e5 * t53 * t164 * t296 + 0.85689688888888888888888888888888888888888888888888e4 * t230 * t290 - 0.54776188888888888888888888888888888888888888888888e4 * t58 * t234 * t296 + 0.29283200000000000000000000000000000000000000000000e3 * t235 * t290 - 0.21352333333333333333333333333333333333333333333333e3 * t63 / t311 * t296 + 0.17579086222222222222222222222222222222222222222222e4 * t290 * t60 - 0.15430993333333333333333333333333333333333333333333e4 * t295 * t65 * t31 - 0.23624368592592592592592592592592592592592592592592e3 * t142 * t269 * t55
  t336 = t118 ** 2
  t390 = -0.14459516250000000000000000000000000000000000000000e0 * t18 * t208 * t324 + 0.45995854005298425703890224126391750228581624490664e-2 * t177 * t17 / t20 / t108 / t218 / t182 / t36 * t336 * t68 * t29 * t31 + 0.12592128288121236167069702012661184000000000000000e0 * t194 * t117 * t119 * t170 + 0.53795226013354837108201560920000000000000000000000e0 * t203 * t29 * t32 * t256 - 0.91153021855962362877785978225555555555555555555558e1 * t6 * t17 * t220 * t78 * t82 + 0.68738344350397847416035327842222222222222222222223e1 * t80 * t130 + 0.19471161334409689258339261445503867851851851851852e1 * t6 * t17 * t289 * t112 * t121 - 0.83947521920808241113798013417741226666666666666665e0 * t114 * t196 - 0.24207851706009676698690702414000000000000000000000e1 * t128 * t205 + 0.11790019789870543920216295650216276708147200000000e0 * t178 * t184 * t185 * t104 - 0.60915102247664476921117527526117429658760533333331e0 * t178 / t21 / t108 / t135 * t183 * t186 + 0.14281003703703703703703703703703703703703703703703e0 * t18 * t137 * t39 * t68 - 0.21421505555555555555555555555555555555555555555556e0 * t18 * t40 * t104 + 0.19279355000000000000000000000000000000000000000000e0 * t18 * t85 * t170 - 0.19279355000000000000000000000000000000000000000000e0 * t18 * t134 * t256
  t391 = f.my_piecewise3(t2, 0, t390)
  v4rho4_0_ = 0.2e1 * r0 * t391 + 0.8e1 * t261

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t5 * t29
  t31 = t6 ** (0.1e1 / 0.3e1)
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t37 = t32 / t35
  t38 = r0 ** 2
  t39 = r0 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t42 = 0.1e1 / t40 / t38
  t46 = 0.48827323e1 + 0.14629700000000000000000000000000000000000000000000e-1 * t37 * s0 * t42
  t49 = 0.58827323e1 - 0.2384107471346329e2 / t46
  t50 = t31 * t49
  t51 = t32 ** 2
  t53 = 0.3e1 / 0.10e2 * t51 * t35
  t56 = tau0 / t40 / r0
  t57 = t53 - t56
  t58 = t53 + t56
  t59 = 0.1e1 / t58
  t62 = t57 ** 2
  t63 = t58 ** 2
  t64 = 0.1e1 / t63
  t67 = t62 * t57
  t69 = 0.1e1 / t63 / t58
  t72 = t62 ** 2
  t73 = t63 ** 2
  t74 = 0.1e1 / t73
  t77 = 0.1e1 - 0.1637571e0 * t57 * t59 - 0.1880028e0 * t62 * t64 - 0.4490609e0 * t67 * t69 - 0.82359e-2 * t72 * t74
  t78 = t50 * t77
  t81 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t82 = t81 * f.p.zeta_threshold
  t84 = f.my_piecewise3(t20, t82, t21 * t19)
  t85 = t5 * t84
  t86 = t31 ** 2
  t87 = 0.1e1 / t86
  t88 = t87 * t49
  t89 = t88 * t77
  t91 = 0.48198387500000000000000000000000000000000000000000e-1 * t85 * t89
  t92 = t84 * t31
  t93 = t46 ** 2
  t94 = 0.1e1 / t93
  t96 = t5 * t92 * t94
  t97 = t38 * r0
  t99 = 0.1e1 / t40 / t97
  t100 = s0 * t99
  t102 = t37 * t100 * t77
  t105 = tau0 * t42
  t108 = t57 * t64
  t111 = t62 * t69
  t114 = t67 * t74
  t118 = 0.1e1 / t73 / t58
  t119 = t72 * t118
  t122 = -0.27292850000000000000000000000000000000000000000000e0 * t105 * t59 - 0.89960450000000000000000000000000000000000000000000e0 * t108 * t105 - 0.28719805000000000000000000000000000000000000000000e1 * t111 * t105 - 0.23002105000000000000000000000000000000000000000000e1 * t114 * t105 - 0.54906000000000000000000000000000000000000000000000e-1 * t119 * t105
  t123 = t50 * t122
  t127 = f.my_piecewise3(t1, 0, -0.14459516250000000000000000000000000000000000000000e0 * t30 * t78 - t91 + 0.13448806503338709277050390230000000000000000000000e0 * t96 * t102 - 0.14459516250000000000000000000000000000000000000000e0 * t85 * t123)
  t129 = r1 <= f.p.dens_threshold
  t130 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t131 = 0.1e1 + t130
  t132 = t131 <= f.p.zeta_threshold
  t133 = t131 ** (0.1e1 / 0.3e1)
  t135 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t138 = f.my_piecewise3(t132, 0, 0.4e1 / 0.3e1 * t133 * t135)
  t139 = t5 * t138
  t140 = r1 ** 2
  t141 = r1 ** (0.1e1 / 0.3e1)
  t142 = t141 ** 2
  t144 = 0.1e1 / t142 / t140
  t148 = 0.48827323e1 + 0.14629700000000000000000000000000000000000000000000e-1 * t37 * s2 * t144
  t151 = 0.58827323e1 - 0.2384107471346329e2 / t148
  t152 = t31 * t151
  t155 = tau1 / t142 / r1
  t156 = t53 - t155
  t157 = t53 + t155
  t158 = 0.1e1 / t157
  t161 = t156 ** 2
  t162 = t157 ** 2
  t163 = 0.1e1 / t162
  t166 = t161 * t156
  t168 = 0.1e1 / t162 / t157
  t171 = t161 ** 2
  t172 = t162 ** 2
  t173 = 0.1e1 / t172
  t176 = 0.1e1 - 0.1637571e0 * t156 * t158 - 0.1880028e0 * t161 * t163 - 0.4490609e0 * t166 * t168 - 0.82359e-2 * t171 * t173
  t177 = t152 * t176
  t181 = f.my_piecewise3(t132, t82, t133 * t131)
  t182 = t5 * t181
  t183 = t87 * t151
  t184 = t183 * t176
  t186 = 0.48198387500000000000000000000000000000000000000000e-1 * t182 * t184
  t188 = f.my_piecewise3(t129, 0, -0.14459516250000000000000000000000000000000000000000e0 * t139 * t177 - t186)
  t190 = t21 ** 2
  t191 = 0.1e1 / t190
  t192 = t26 ** 2
  t197 = t16 / t22 / t6
  t199 = -0.2e1 * t23 + 0.2e1 * t197
  t200 = f.my_piecewise5(t10, 0, t14, 0, t199)
  t204 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t191 * t192 + 0.4e1 / 0.3e1 * t21 * t200)
  t208 = t30 * t89
  t218 = 0.1e1 / t86 / t6
  t222 = 0.32132258333333333333333333333333333333333333333333e-1 * t85 * t218 * t49 * t77
  t226 = t5 * t84 * t87 * t94 * t102
  t229 = t85 * t88 * t122
  t237 = t51 / t34 / t33
  t238 = s0 ** 2
  t239 = t38 ** 2
  t259 = tau0 * t99
  t262 = tau0 ** 2
  t266 = t262 / t39 / t239 / r0
  t295 = -0.14459516250000000000000000000000000000000000000000e0 * t5 * t204 * t78 - 0.96396775000000000000000000000000000000000000000000e-1 * t208 + 0.26897613006677418554100780460000000000000000000000e0 * t5 * t29 * t31 * t94 * t102 - 0.28919032500000000000000000000000000000000000000000e0 * t30 * t123 + t222 + 0.89658710022258061847002601533333333333333333333334e-1 * t226 - 0.96396775000000000000000000000000000000000000000000e-1 * t229 + 0.10493440240101030139224751677217653333333333333333e-1 * t5 * t92 / t93 / t46 * t237 * t238 / t39 / t239 / t97 * t77 - 0.49312290512241934015851430843333333333333333333333e0 * t96 * t37 * s0 / t40 / t239 * t77 + 0.26897613006677418554100780460000000000000000000000e0 * t96 * t37 * t100 * t122 - 0.14459516250000000000000000000000000000000000000000e0 * t85 * t50 * (0.72780933333333333333333333333333333333333333333333e0 * t259 * t59 - 0.19542216666666666666666666666666666666666666666666e1 * t266 * t64 - 0.12571950000000000000000000000000000000000000000000e2 * t57 * t69 * t266 + 0.23989453333333333333333333333333333333333333333333e1 * t108 * t259 - 0.25860955000000000000000000000000000000000000000000e2 * t62 * t74 * t266 + 0.76586146666666666666666666666666666666666666666667e1 * t111 * t259 - 0.15700776666666666666666666666666666666666666666667e2 * t67 * t118 * t266 + 0.61338946666666666666666666666666666666666666666667e1 * t114 * t259 - 0.45755000000000000000000000000000000000000000000000e0 * t72 / t73 / t63 * t266 + 0.14641600000000000000000000000000000000000000000000e0 * t119 * t259)
  t296 = f.my_piecewise3(t1, 0, t295)
  t297 = t133 ** 2
  t298 = 0.1e1 / t297
  t299 = t135 ** 2
  t303 = f.my_piecewise5(t14, 0, t10, 0, -t199)
  t307 = f.my_piecewise3(t132, 0, 0.4e1 / 0.9e1 * t298 * t299 + 0.4e1 / 0.3e1 * t133 * t303)
  t311 = t139 * t184
  t316 = 0.32132258333333333333333333333333333333333333333333e-1 * t182 * t218 * t151 * t176
  t318 = f.my_piecewise3(t129, 0, -0.14459516250000000000000000000000000000000000000000e0 * t5 * t307 * t177 - 0.96396775000000000000000000000000000000000000000000e-1 * t311 + t316)
  d11 = 0.2e1 * t127 + 0.2e1 * t188 + t6 * (t296 + t318)
  t321 = -t7 - t24
  t322 = f.my_piecewise5(t10, 0, t14, 0, t321)
  t325 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t322)
  t326 = t5 * t325
  t330 = f.my_piecewise3(t1, 0, -0.14459516250000000000000000000000000000000000000000e0 * t326 * t78 - t91)
  t332 = f.my_piecewise5(t14, 0, t10, 0, -t321)
  t335 = f.my_piecewise3(t132, 0, 0.4e1 / 0.3e1 * t133 * t332)
  t336 = t5 * t335
  t339 = t181 * t31
  t340 = t148 ** 2
  t341 = 0.1e1 / t340
  t343 = t5 * t339 * t341
  t344 = t140 * r1
  t346 = 0.1e1 / t142 / t344
  t347 = s2 * t346
  t349 = t37 * t347 * t176
  t352 = tau1 * t144
  t355 = t156 * t163
  t358 = t161 * t168
  t361 = t166 * t173
  t365 = 0.1e1 / t172 / t157
  t366 = t171 * t365
  t369 = -0.27292850000000000000000000000000000000000000000000e0 * t352 * t158 - 0.89960450000000000000000000000000000000000000000000e0 * t355 * t352 - 0.28719805000000000000000000000000000000000000000000e1 * t358 * t352 - 0.23002105000000000000000000000000000000000000000000e1 * t361 * t352 - 0.54906000000000000000000000000000000000000000000000e-1 * t366 * t352
  t370 = t152 * t369
  t374 = f.my_piecewise3(t129, 0, -0.14459516250000000000000000000000000000000000000000e0 * t336 * t177 - t186 + 0.13448806503338709277050390230000000000000000000000e0 * t343 * t349 - 0.14459516250000000000000000000000000000000000000000e0 * t182 * t370)
  t378 = 0.2e1 * t197
  t379 = f.my_piecewise5(t10, 0, t14, 0, t378)
  t383 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t191 * t322 * t26 + 0.4e1 / 0.3e1 * t21 * t379)
  t387 = t326 * t89
  t400 = f.my_piecewise3(t1, 0, -0.14459516250000000000000000000000000000000000000000e0 * t5 * t383 * t78 - 0.48198387500000000000000000000000000000000000000000e-1 * t387 + 0.13448806503338709277050390230000000000000000000000e0 * t5 * t325 * t31 * t94 * t102 - 0.14459516250000000000000000000000000000000000000000e0 * t326 * t123 - 0.48198387500000000000000000000000000000000000000000e-1 * t208 + t222 + 0.44829355011129030923501300766666666666666666666667e-1 * t226 - 0.48198387500000000000000000000000000000000000000000e-1 * t229)
  t404 = f.my_piecewise5(t14, 0, t10, 0, -t378)
  t408 = f.my_piecewise3(t132, 0, 0.4e1 / 0.9e1 * t298 * t332 * t135 + 0.4e1 / 0.3e1 * t133 * t404)
  t412 = t336 * t184
  t423 = t5 * t181 * t87 * t341 * t349
  t428 = t182 * t183 * t369
  t431 = f.my_piecewise3(t129, 0, -0.14459516250000000000000000000000000000000000000000e0 * t5 * t408 * t177 - 0.48198387500000000000000000000000000000000000000000e-1 * t412 - 0.48198387500000000000000000000000000000000000000000e-1 * t311 + t316 + 0.13448806503338709277050390230000000000000000000000e0 * t5 * t138 * t31 * t341 * t349 + 0.44829355011129030923501300766666666666666666666667e-1 * t423 - 0.14459516250000000000000000000000000000000000000000e0 * t139 * t370 - 0.48198387500000000000000000000000000000000000000000e-1 * t428)
  d12 = t127 + t188 + t330 + t374 + t6 * (t400 + t431)
  t436 = t322 ** 2
  t440 = 0.2e1 * t23 + 0.2e1 * t197
  t441 = f.my_piecewise5(t10, 0, t14, 0, t440)
  t445 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t191 * t436 + 0.4e1 / 0.3e1 * t21 * t441)
  t451 = f.my_piecewise3(t1, 0, -0.14459516250000000000000000000000000000000000000000e0 * t5 * t445 * t78 - 0.96396775000000000000000000000000000000000000000000e-1 * t387 + t222)
  t452 = t332 ** 2
  t456 = f.my_piecewise5(t14, 0, t10, 0, -t440)
  t460 = f.my_piecewise3(t132, 0, 0.4e1 / 0.9e1 * t298 * t452 + 0.4e1 / 0.3e1 * t133 * t456)
  t478 = s2 ** 2
  t479 = t140 ** 2
  t499 = tau1 * t346
  t502 = tau1 ** 2
  t506 = t502 / t141 / t479 / r1
  t535 = -0.14459516250000000000000000000000000000000000000000e0 * t5 * t460 * t177 - 0.96396775000000000000000000000000000000000000000000e-1 * t412 + 0.26897613006677418554100780460000000000000000000000e0 * t5 * t335 * t31 * t341 * t349 - 0.28919032500000000000000000000000000000000000000000e0 * t336 * t370 + t316 + 0.89658710022258061847002601533333333333333333333334e-1 * t423 - 0.96396775000000000000000000000000000000000000000000e-1 * t428 + 0.10493440240101030139224751677217653333333333333333e-1 * t5 * t339 / t340 / t148 * t237 * t478 / t141 / t479 / t344 * t176 - 0.49312290512241934015851430843333333333333333333333e0 * t343 * t37 * s2 / t142 / t479 * t176 + 0.26897613006677418554100780460000000000000000000000e0 * t343 * t37 * t347 * t369 - 0.14459516250000000000000000000000000000000000000000e0 * t182 * t152 * (0.72780933333333333333333333333333333333333333333333e0 * t499 * t158 - 0.19542216666666666666666666666666666666666666666666e1 * t506 * t163 - 0.12571950000000000000000000000000000000000000000000e2 * t156 * t168 * t506 + 0.23989453333333333333333333333333333333333333333333e1 * t355 * t499 - 0.25860955000000000000000000000000000000000000000000e2 * t161 * t173 * t506 + 0.76586146666666666666666666666666666666666666666667e1 * t358 * t499 - 0.15700776666666666666666666666666666666666666666667e2 * t166 * t365 * t506 + 0.61338946666666666666666666666666666666666666666667e1 * t361 * t499 - 0.45755000000000000000000000000000000000000000000000e0 * t171 / t172 / t162 * t506 + 0.14641600000000000000000000000000000000000000000000e0 * t366 * t499)
  t536 = f.my_piecewise3(t129, 0, t535)
  d22 = 0.2e1 * t330 + 0.2e1 * t374 + t6 * (t451 + t536)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t5 * t41
  t43 = t6 ** (0.1e1 / 0.3e1)
  t44 = 6 ** (0.1e1 / 0.3e1)
  t45 = jnp.pi ** 2
  t46 = t45 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t49 = t44 / t47
  t50 = r0 ** 2
  t51 = r0 ** (0.1e1 / 0.3e1)
  t52 = t51 ** 2
  t54 = 0.1e1 / t52 / t50
  t58 = 0.48827323e1 + 0.14629700000000000000000000000000000000000000000000e-1 * t49 * s0 * t54
  t61 = 0.58827323e1 - 0.2384107471346329e2 / t58
  t62 = t43 * t61
  t63 = t44 ** 2
  t65 = 0.3e1 / 0.10e2 * t63 * t47
  t68 = tau0 / t52 / r0
  t69 = t65 - t68
  t70 = t65 + t68
  t71 = 0.1e1 / t70
  t74 = t69 ** 2
  t75 = t70 ** 2
  t76 = 0.1e1 / t75
  t79 = t74 * t69
  t80 = t75 * t70
  t81 = 0.1e1 / t80
  t84 = t74 ** 2
  t85 = t75 ** 2
  t86 = 0.1e1 / t85
  t89 = 0.1e1 - 0.1637571e0 * t69 * t71 - 0.1880028e0 * t74 * t76 - 0.4490609e0 * t79 * t81 - 0.82359e-2 * t84 * t86
  t90 = t62 * t89
  t95 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t96 = t5 * t95
  t97 = t43 ** 2
  t98 = 0.1e1 / t97
  t99 = t98 * t61
  t100 = t99 * t89
  t103 = t95 * t43
  t104 = t58 ** 2
  t105 = 0.1e1 / t104
  t107 = t5 * t103 * t105
  t108 = t50 * r0
  t110 = 0.1e1 / t52 / t108
  t111 = s0 * t110
  t113 = t49 * t111 * t89
  t116 = tau0 * t54
  t119 = t69 * t76
  t122 = t74 * t81
  t125 = t79 * t86
  t129 = 0.1e1 / t85 / t70
  t130 = t84 * t129
  t133 = -0.27292850000000000000000000000000000000000000000000e0 * t116 * t71 - 0.89960450000000000000000000000000000000000000000000e0 * t119 * t116 - 0.28719805000000000000000000000000000000000000000000e1 * t122 * t116 - 0.23002105000000000000000000000000000000000000000000e1 * t125 * t116 - 0.54906000000000000000000000000000000000000000000000e-1 * t130 * t116
  t134 = t62 * t133
  t137 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t138 = t137 * f.p.zeta_threshold
  t140 = f.my_piecewise3(t20, t138, t21 * t19)
  t141 = t5 * t140
  t143 = 0.1e1 / t97 / t6
  t144 = t143 * t61
  t145 = t144 * t89
  t148 = t140 * t98
  t150 = t5 * t148 * t105
  t153 = t99 * t133
  t156 = t140 * t43
  t158 = 0.1e1 / t104 / t58
  t160 = t5 * t156 * t158
  t163 = t63 / t46 / t45
  t164 = s0 ** 2
  t165 = t50 ** 2
  t169 = t164 / t51 / t165 / t108
  t171 = t163 * t169 * t89
  t175 = t5 * t156 * t105
  t177 = 0.1e1 / t52 / t165
  t178 = s0 * t177
  t180 = t49 * t178 * t89
  t184 = t49 * t111 * t133
  t187 = tau0 * t110
  t190 = tau0 ** 2
  t191 = t165 * r0
  t194 = t190 / t51 / t191
  t197 = t69 * t81
  t202 = t74 * t86
  t207 = t79 * t129
  t213 = 0.1e1 / t85 / t75
  t214 = t84 * t213
  t219 = 0.72780933333333333333333333333333333333333333333333e0 * t187 * t71 - 0.19542216666666666666666666666666666666666666666666e1 * t194 * t76 - 0.12571950000000000000000000000000000000000000000000e2 * t197 * t194 + 0.23989453333333333333333333333333333333333333333333e1 * t119 * t187 - 0.25860955000000000000000000000000000000000000000000e2 * t202 * t194 + 0.76586146666666666666666666666666666666666666666667e1 * t122 * t187 - 0.15700776666666666666666666666666666666666666666667e2 * t207 * t194 + 0.61338946666666666666666666666666666666666666666667e1 * t125 * t187 - 0.45755000000000000000000000000000000000000000000000e0 * t214 * t194 + 0.14641600000000000000000000000000000000000000000000e0 * t130 * t187
  t220 = t62 * t219
  t223 = -0.14459516250000000000000000000000000000000000000000e0 * t42 * t90 - 0.96396775000000000000000000000000000000000000000000e-1 * t96 * t100 + 0.26897613006677418554100780460000000000000000000000e0 * t107 * t113 - 0.28919032500000000000000000000000000000000000000000e0 * t96 * t134 + 0.32132258333333333333333333333333333333333333333333e-1 * t141 * t145 + 0.89658710022258061847002601533333333333333333333334e-1 * t150 * t113 - 0.96396775000000000000000000000000000000000000000000e-1 * t141 * t153 + 0.10493440240101030139224751677217653333333333333333e-1 * t160 * t171 - 0.49312290512241934015851430843333333333333333333333e0 * t175 * t180 + 0.26897613006677418554100780460000000000000000000000e0 * t175 * t184 - 0.14459516250000000000000000000000000000000000000000e0 * t141 * t220
  t224 = f.my_piecewise3(t1, 0, t223)
  t226 = r1 <= f.p.dens_threshold
  t227 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t228 = 0.1e1 + t227
  t229 = t228 <= f.p.zeta_threshold
  t230 = t228 ** (0.1e1 / 0.3e1)
  t231 = t230 ** 2
  t232 = 0.1e1 / t231
  t234 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t235 = t234 ** 2
  t239 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t243 = f.my_piecewise3(t229, 0, 0.4e1 / 0.9e1 * t232 * t235 + 0.4e1 / 0.3e1 * t230 * t239)
  t244 = t5 * t243
  t245 = r1 ** 2
  t246 = r1 ** (0.1e1 / 0.3e1)
  t247 = t246 ** 2
  t256 = 0.58827323e1 - 0.2384107471346329e2 / (0.48827323e1 + 0.14629700000000000000000000000000000000000000000000e-1 * t49 * s2 / t247 / t245)
  t260 = tau1 / t247 / r1
  t261 = t65 - t260
  t262 = t65 + t260
  t266 = t261 ** 2
  t267 = t262 ** 2
  t276 = t266 ** 2
  t277 = t267 ** 2
  t281 = 0.1e1 - 0.1637571e0 * t261 / t262 - 0.1880028e0 * t266 / t267 - 0.4490609e0 * t266 * t261 / t267 / t262 - 0.82359e-2 * t276 / t277
  t282 = t43 * t256 * t281
  t287 = f.my_piecewise3(t229, 0, 0.4e1 / 0.3e1 * t230 * t234)
  t288 = t5 * t287
  t290 = t98 * t256 * t281
  t294 = f.my_piecewise3(t229, t138, t230 * t228)
  t295 = t5 * t294
  t297 = t143 * t256 * t281
  t301 = f.my_piecewise3(t226, 0, -0.14459516250000000000000000000000000000000000000000e0 * t244 * t282 - 0.96396775000000000000000000000000000000000000000000e-1 * t288 * t290 + 0.32132258333333333333333333333333333333333333333333e-1 * t295 * t297)
  t303 = t45 ** 2
  t308 = t104 ** 2
  t312 = t165 ** 2
  t365 = 0.73687623686690899501351847813851729425919999999998e-2 * t2 / t3 / t303 * t156 / t308 * t164 * s0 / t312 / t108 * t89 - 0.11542784264111133153147226844939418666666666666666e0 * t160 * t163 * t164 / t51 / t312 * t89 + 0.23012402239046235874064001060222222222222222222222e1 * t175 * t49 * s0 / t52 / t191 * t89 - 0.14793687153672580204755429253000000000000000000000e1 * t107 * t180 - 0.49312290512241934015851430843333333333333333333333e0 * t150 * t180 + 0.31480320720303090417674255031652959999999999999999e-1 * t160 * t163 * t169 * t133 - 0.14793687153672580204755429253000000000000000000000e1 * t175 * t49 * t178 * t133 + 0.40346419510016127831151170690000000000000000000000e0 * t175 * t49 * t111 * t219 + 0.40346419510016127831151170690000000000000000000000e0 * t5 * t41 * t43 * t105 * t113 + 0.26897613006677418554100780460000000000000000000000e0 * t5 * t95 * t98 * t105 * t113 + 0.80692839020032255662302341380000000000000000000000e0 * t107 * t184 + 0.31480320720303090417674255031652959999999999999999e-1 * t5 * t103 * t158 * t171
  t378 = 0.1e1 / t97 / t24
  t395 = t24 ** 2
  t399 = 0.6e1 * t33 - 0.6e1 * t16 / t395
  t400 = f.my_piecewise5(t10, 0, t14, 0, t399)
  t404 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t400)
  t420 = tau0 * t177
  t426 = t190 * tau0 / t312
  t443 = t190 / t51 / t165 / t50
  t464 = -0.26686342222222222222222222222222222222222222222222e1 * t420 * t71 - 0.14906293333333333333333333333333333333333333333333e3 * t69 * t86 * t426 - 0.25091025000000000000000000000000000000000000000000e3 * t74 * t129 * t426 - 0.13389013888888888888888888888888888888888888888889e3 * t79 * t213 * t426 - 0.45755000000000000000000000000000000000000000000000e1 * t84 / t85 / t80 * t426 + 0.15633773333333333333333333333333333333333333333333e2 * t443 * t76 - 0.27467322222222222222222222222222222222222222222222e2 * t426 * t81 + 0.10057560000000000000000000000000000000000000000000e3 * t197 * t443 - 0.87961328888888888888888888888888888888888888888888e1 * t119 * t420 + 0.20688763999999999999999999999999999999999999999999e3 * t202 * t443 - 0.28081587111111111111111111111111111111111111111111e2 * t122 * t420 + 0.12560621333333333333333333333333333333333333333334e3 * t207 * t443 - 0.22490947111111111111111111111111111111111111111111e2 * t125 * t420 + 0.36604000000000000000000000000000000000000000000000e1 * t214 * t443 - 0.53685866666666666666666666666666666666666666666667e0 * t130 * t420
  t468 = -0.89658710022258061847002601533333333333333333333333e-1 * t5 * t140 * t143 * t105 * t113 + 0.26897613006677418554100780460000000000000000000000e0 * t150 * t184 + 0.10493440240101030139224751677217653333333333333333e-1 * t5 * t148 * t158 * t171 - 0.53553763888888888888888888888888888888888888888888e-1 * t141 * t378 * t61 * t89 - 0.14459516250000000000000000000000000000000000000000e0 * t42 * t100 + 0.96396775000000000000000000000000000000000000000000e-1 * t96 * t145 - 0.14459516250000000000000000000000000000000000000000e0 * t5 * t404 * t90 - 0.43378548750000000000000000000000000000000000000000e0 * t42 * t134 - 0.28919032500000000000000000000000000000000000000000e0 * t96 * t153 - 0.43378548750000000000000000000000000000000000000000e0 * t96 * t220 + 0.96396775000000000000000000000000000000000000000000e-1 * t141 * t144 * t133 - 0.14459516250000000000000000000000000000000000000000e0 * t141 * t99 * t219 - 0.14459516250000000000000000000000000000000000000000e0 * t141 * t62 * t464
  t470 = f.my_piecewise3(t1, 0, t365 + t468)
  t480 = f.my_piecewise5(t14, 0, t10, 0, -t399)
  t484 = f.my_piecewise3(t229, 0, -0.8e1 / 0.27e2 / t231 / t228 * t235 * t234 + 0.4e1 / 0.3e1 * t232 * t234 * t239 + 0.4e1 / 0.3e1 * t230 * t480)
  t497 = f.my_piecewise3(t226, 0, -0.14459516250000000000000000000000000000000000000000e0 * t5 * t484 * t282 - 0.14459516250000000000000000000000000000000000000000e0 * t244 * t290 + 0.96396775000000000000000000000000000000000000000000e-1 * t288 * t297 - 0.53553763888888888888888888888888888888888888888888e-1 * t295 * t378 * t256 * t281)
  d111 = 0.3e1 * t224 + 0.3e1 * t301 + t6 * (t470 + t497)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t5 * t25
  t27 = t6 ** 2
  t28 = t6 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t31 = 0.1e1 / t29 / t27
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t36 = 0.1e1 / t35
  t37 = t32 * t36
  t38 = r0 ** 2
  t39 = r0 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t42 = 0.1e1 / t40 / t38
  t46 = 0.48827323e1 + 0.14629700000000000000000000000000000000000000000000e-1 * t37 * s0 * t42
  t49 = 0.58827323e1 - 0.2384107471346329e2 / t46
  t50 = t31 * t49
  t51 = t32 ** 2
  t53 = 0.3e1 / 0.10e2 * t51 * t35
  t56 = tau0 / t40 / r0
  t57 = t53 - t56
  t58 = t53 + t56
  t59 = 0.1e1 / t58
  t62 = t57 ** 2
  t63 = t58 ** 2
  t64 = 0.1e1 / t63
  t67 = t62 * t57
  t68 = t63 * t58
  t69 = 0.1e1 / t68
  t72 = t62 ** 2
  t73 = t63 ** 2
  t74 = 0.1e1 / t73
  t77 = 0.1e1 - 0.1637571e0 * t57 * t59 - 0.1880028e0 * t62 * t64 - 0.4490609e0 * t67 * t69 - 0.82359e-2 * t72 * t74
  t78 = t50 * t77
  t81 = t23 ** 2
  t82 = 0.1e1 / t81
  t83 = 0.1e1 / t27
  t85 = -t16 * t83 + t7
  t86 = f.my_piecewise5(t10, 0, t14, 0, t85)
  t87 = t86 ** 2
  t90 = t27 * t6
  t91 = 0.1e1 / t90
  t94 = 0.2e1 * t16 * t91 - 0.2e1 * t83
  t95 = f.my_piecewise5(t10, 0, t14, 0, t94)
  t99 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t82 * t87 + 0.4e1 / 0.3e1 * t23 * t95)
  t100 = t5 * t99
  t101 = 0.1e1 / t29
  t102 = t101 * t49
  t103 = t102 * t77
  t108 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t86)
  t109 = t5 * t108
  t111 = 0.1e1 / t29 / t6
  t112 = t111 * t49
  t113 = t112 * t77
  t117 = 0.1e1 / t81 / t19
  t121 = t82 * t86
  t124 = t27 ** 2
  t125 = 0.1e1 / t124
  t128 = -0.6e1 * t16 * t125 + 0.6e1 * t91
  t129 = f.my_piecewise5(t10, 0, t14, 0, t128)
  t133 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t117 * t87 * t86 + 0.4e1 / 0.3e1 * t121 * t95 + 0.4e1 / 0.3e1 * t23 * t129)
  t134 = t5 * t133
  t135 = t28 * t49
  t136 = t135 * t77
  t139 = tau0 * t42
  t142 = t57 * t64
  t145 = t62 * t69
  t148 = t67 * t74
  t152 = 0.1e1 / t73 / t58
  t153 = t72 * t152
  t156 = -0.27292850000000000000000000000000000000000000000000e0 * t139 * t59 - 0.89960450000000000000000000000000000000000000000000e0 * t142 * t139 - 0.28719805000000000000000000000000000000000000000000e1 * t145 * t139 - 0.23002105000000000000000000000000000000000000000000e1 * t148 * t139 - 0.54906000000000000000000000000000000000000000000000e-1 * t153 * t139
  t157 = t135 * t156
  t160 = t102 * t156
  t163 = t38 * r0
  t165 = 0.1e1 / t40 / t163
  t166 = tau0 * t165
  t169 = tau0 ** 2
  t170 = t38 ** 2
  t171 = t170 * r0
  t174 = t169 / t39 / t171
  t177 = t57 * t69
  t182 = t62 * t74
  t187 = t67 * t152
  t193 = 0.1e1 / t73 / t63
  t194 = t72 * t193
  t199 = 0.72780933333333333333333333333333333333333333333333e0 * t166 * t59 - 0.19542216666666666666666666666666666666666666666666e1 * t174 * t64 - 0.12571950000000000000000000000000000000000000000000e2 * t177 * t174 + 0.23989453333333333333333333333333333333333333333333e1 * t142 * t166 - 0.25860955000000000000000000000000000000000000000000e2 * t182 * t174 + 0.76586146666666666666666666666666666666666666666667e1 * t145 * t166 - 0.15700776666666666666666666666666666666666666666667e2 * t187 * t174 + 0.61338946666666666666666666666666666666666666666667e1 * t148 * t166 - 0.45755000000000000000000000000000000000000000000000e0 * t194 * t174 + 0.14641600000000000000000000000000000000000000000000e0 * t153 * t166
  t200 = t135 * t199
  t203 = t112 * t156
  t206 = t102 * t199
  t210 = 0.1e1 / t40 / t170
  t211 = tau0 * t210
  t214 = t57 * t74
  t215 = t169 * tau0
  t216 = t170 ** 2
  t218 = t215 / t216
  t221 = t62 * t152
  t224 = t67 * t193
  t228 = 0.1e1 / t73 / t68
  t229 = t72 * t228
  t232 = t170 * t38
  t235 = t169 / t39 / t232
  t256 = -0.26686342222222222222222222222222222222222222222222e1 * t211 * t59 - 0.14906293333333333333333333333333333333333333333333e3 * t214 * t218 - 0.25091025000000000000000000000000000000000000000000e3 * t221 * t218 - 0.13389013888888888888888888888888888888888888888889e3 * t224 * t218 - 0.45755000000000000000000000000000000000000000000000e1 * t229 * t218 + 0.15633773333333333333333333333333333333333333333333e2 * t235 * t64 - 0.27467322222222222222222222222222222222222222222222e2 * t218 * t69 + 0.10057560000000000000000000000000000000000000000000e3 * t177 * t235 - 0.87961328888888888888888888888888888888888888888888e1 * t142 * t211 + 0.20688763999999999999999999999999999999999999999999e3 * t182 * t235 - 0.28081587111111111111111111111111111111111111111111e2 * t145 * t211 + 0.12560621333333333333333333333333333333333333333334e3 * t187 * t235 - 0.22490947111111111111111111111111111111111111111111e2 * t148 * t211 + 0.36604000000000000000000000000000000000000000000000e1 * t194 * t235 - 0.53685866666666666666666666666666666666666666666667e0 * t153 * t211
  t257 = t135 * t256
  t260 = t25 * t28
  t261 = t46 ** 2
  t262 = 0.1e1 / t261
  t264 = t5 * t260 * t262
  t265 = s0 * t210
  t267 = t37 * t265 * t156
  t270 = s0 * t165
  t272 = t37 * t270 * t199
  t275 = -0.53553763888888888888888888888888888888888888888888e-1 * t26 * t78 - 0.14459516250000000000000000000000000000000000000000e0 * t100 * t103 + 0.96396775000000000000000000000000000000000000000000e-1 * t109 * t113 - 0.14459516250000000000000000000000000000000000000000e0 * t134 * t136 - 0.43378548750000000000000000000000000000000000000000e0 * t100 * t157 - 0.28919032500000000000000000000000000000000000000000e0 * t109 * t160 - 0.43378548750000000000000000000000000000000000000000e0 * t109 * t200 + 0.96396775000000000000000000000000000000000000000000e-1 * t26 * t203 - 0.14459516250000000000000000000000000000000000000000e0 * t26 * t206 - 0.14459516250000000000000000000000000000000000000000e0 * t26 * t257 - 0.14793687153672580204755429253000000000000000000000e1 * t264 * t267 + 0.40346419510016127831151170690000000000000000000000e0 * t264 * t272
  t276 = t99 * t28
  t278 = t5 * t276 * t262
  t280 = t37 * t270 * t77
  t283 = t108 * t101
  t285 = t5 * t283 * t262
  t288 = t108 * t28
  t290 = t5 * t288 * t262
  t292 = t37 * t270 * t156
  t296 = 0.1e1 / t261 / t46
  t298 = t5 * t288 * t296
  t301 = t51 / t34 / t33
  t302 = s0 ** 2
  t305 = 0.1e1 / t39 / t170 / t163
  t306 = t302 * t305
  t308 = t301 * t306 * t77
  t311 = t25 * t111
  t313 = t5 * t311 * t262
  t316 = t25 * t101
  t318 = t5 * t316 * t262
  t322 = t5 * t316 * t296
  t326 = t5 * t260 * t296
  t329 = t302 / t39 / t216
  t331 = t301 * t329 * t77
  t335 = 0.1e1 / t40 / t171
  t336 = s0 * t335
  t338 = t37 * t336 * t77
  t342 = t37 * t265 * t77
  t348 = t301 * t306 * t156
  t351 = t33 ** 2
  t354 = t2 / t3 / t351
  t355 = t354 * t260
  t356 = t261 ** 2
  t359 = 0.1e1 / t356 * t302 * s0
  t361 = 0.1e1 / t216 / t163
  t363 = t359 * t361 * t77
  t366 = 0.40346419510016127831151170690000000000000000000000e0 * t278 * t280 + 0.26897613006677418554100780460000000000000000000000e0 * t285 * t280 + 0.80692839020032255662302341380000000000000000000000e0 * t290 * t292 + 0.31480320720303090417674255031652959999999999999999e-1 * t298 * t308 - 0.89658710022258061847002601533333333333333333333333e-1 * t313 * t280 + 0.26897613006677418554100780460000000000000000000000e0 * t318 * t292 + 0.10493440240101030139224751677217653333333333333333e-1 * t322 * t308 - 0.11542784264111133153147226844939418666666666666666e0 * t326 * t331 + 0.23012402239046235874064001060222222222222222222222e1 * t264 * t338 - 0.14793687153672580204755429253000000000000000000000e1 * t290 * t342 - 0.49312290512241934015851430843333333333333333333333e0 * t318 * t342 + 0.31480320720303090417674255031652959999999999999999e-1 * t326 * t348 + 0.73687623686690899501351847813851729425919999999998e-2 * t355 * t363
  t368 = f.my_piecewise3(t1, 0, t275 + t366)
  t370 = r1 <= f.p.dens_threshold
  t371 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t372 = 0.1e1 + t371
  t373 = t372 <= f.p.zeta_threshold
  t374 = t372 ** (0.1e1 / 0.3e1)
  t375 = t374 ** 2
  t377 = 0.1e1 / t375 / t372
  t379 = f.my_piecewise5(t14, 0, t10, 0, -t85)
  t380 = t379 ** 2
  t384 = 0.1e1 / t375
  t385 = t384 * t379
  t387 = f.my_piecewise5(t14, 0, t10, 0, -t94)
  t391 = f.my_piecewise5(t14, 0, t10, 0, -t128)
  t395 = f.my_piecewise3(t373, 0, -0.8e1 / 0.27e2 * t377 * t380 * t379 + 0.4e1 / 0.3e1 * t385 * t387 + 0.4e1 / 0.3e1 * t374 * t391)
  t396 = t5 * t395
  t397 = r1 ** 2
  t398 = r1 ** (0.1e1 / 0.3e1)
  t399 = t398 ** 2
  t408 = 0.58827323e1 - 0.2384107471346329e2 / (0.48827323e1 + 0.14629700000000000000000000000000000000000000000000e-1 * t37 * s2 / t399 / t397)
  t412 = tau1 / t399 / r1
  t413 = t53 - t412
  t414 = t53 + t412
  t418 = t413 ** 2
  t419 = t414 ** 2
  t428 = t418 ** 2
  t429 = t419 ** 2
  t433 = 0.1e1 - 0.1637571e0 * t413 / t414 - 0.1880028e0 * t418 / t419 - 0.4490609e0 * t418 * t413 / t419 / t414 - 0.82359e-2 * t428 / t429
  t434 = t28 * t408 * t433
  t442 = f.my_piecewise3(t373, 0, 0.4e1 / 0.9e1 * t384 * t380 + 0.4e1 / 0.3e1 * t374 * t387)
  t443 = t5 * t442
  t445 = t101 * t408 * t433
  t450 = f.my_piecewise3(t373, 0, 0.4e1 / 0.3e1 * t374 * t379)
  t451 = t5 * t450
  t453 = t111 * t408 * t433
  t457 = f.my_piecewise3(t373, t22, t374 * t372)
  t458 = t5 * t457
  t460 = t31 * t408 * t433
  t464 = f.my_piecewise3(t370, 0, -0.14459516250000000000000000000000000000000000000000e0 * t396 * t434 - 0.14459516250000000000000000000000000000000000000000e0 * t443 * t445 + 0.96396775000000000000000000000000000000000000000000e-1 * t451 * t453 - 0.53553763888888888888888888888888888888888888888888e-1 * t458 * t460)
  t467 = 0.1e1 / t29 / t90
  t478 = t169 ** 2
  t482 = t478 / t40 / t216 / t38
  t491 = t73 ** 2
  t496 = tau0 * t335
  t499 = t169 * t305
  t504 = t216 * r0
  t506 = t215 / t504
  t533 = -0.18301203888888888888888888888888888888888888888889e4 * t57 * t152 * t482 - 0.27603694444444444444444444444444444444444444444444e4 * t62 * t193 * t482 - 0.13694047222222222222222222222222222222222222222222e4 * t67 * t228 * t482 - 0.53380833333333333333333333333333333333333333333333e2 * t72 / t491 * t482 + 0.12453626370370370370370370370370370370370370370370e2 * t496 * t59 - 0.11812184296296296296296296296296296296296296296296e3 * t499 * t64 - 0.38577483333333333333333333333333333333333333333333e3 * t482 * t74 + 0.43947715555555555555555555555555555555555555555556e3 * t506 * t69 + 0.23850069333333333333333333333333333333333333333332e4 * t214 * t506 + 0.40145640000000000000000000000000000000000000000000e4 * t221 * t506 + 0.21422422222222222222222222222222222222222222222223e4 * t224 * t506 + 0.73208000000000000000000000000000000000000000000000e2 * t229 * t506 - 0.75990453333333333333333333333333333333333333333333e3 * t177 * t499 + 0.41048620148148148148148148148148148148148148148148e2 * t142 * t496 - 0.15631510577777777777777777777777777777777777777778e4 * t182 * t499 + 0.13104740651851851851851851851851851851851851851852e3 * t145 * t496 - 0.94902472296296296296296296296296296296296296296301e3 * t187 * t499 + 0.10495775318518518518518518518518518518518518518518e3 * t148 * t496 - 0.27656355555555555555555555555555555555555555555555e2 * t194 * t499 + 0.25053404444444444444444444444444444444444444444445e1 * t153 * t496
  t548 = t19 ** 2
  t551 = t87 ** 2
  t557 = t95 ** 2
  t566 = -0.24e2 * t125 + 0.24e2 * t16 / t124 / t6
  t567 = f.my_piecewise5(t10, 0, t14, 0, t566)
  t571 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t81 / t548 * t551 - 0.16e2 / 0.9e1 * t117 * t87 * t95 + 0.4e1 / 0.3e1 * t82 * t557 + 0.16e2 / 0.9e1 * t121 * t129 + 0.4e1 / 0.3e1 * t23 * t567)
  t579 = 0.14281003703703703703703703703703703703703703703703e0 * t26 * t467 * t49 * t77 + 0.19279355000000000000000000000000000000000000000000e0 * t100 * t113 - 0.19279355000000000000000000000000000000000000000000e0 * t26 * t102 * t256 - 0.14459516250000000000000000000000000000000000000000e0 * t26 * t135 * t533 - 0.21421505555555555555555555555555555555555555555556e0 * t109 * t78 - 0.21421505555555555555555555555555555555555555555556e0 * t26 * t50 * t156 - 0.19279355000000000000000000000000000000000000000000e0 * t134 * t103 - 0.57838065000000000000000000000000000000000000000000e0 * t100 * t160 + 0.38558710000000000000000000000000000000000000000000e0 * t109 * t203 - 0.14459516250000000000000000000000000000000000000000e0 * t5 * t571 * t136 - 0.57838065000000000000000000000000000000000000000000e0 * t134 * t157 - 0.86757097500000000000000000000000000000000000000000e0 * t100 * t200
  t618 = t302 ** 2
  t632 = -0.57838065000000000000000000000000000000000000000000e0 * t109 * t206 - 0.57838065000000000000000000000000000000000000000000e0 * t109 * t257 + 0.19279355000000000000000000000000000000000000000000e0 * t26 * t112 * t199 + 0.19924157782724013743778355896296296296296296296296e0 * t5 * t25 * t31 * t262 * t280 + 0.53795226013354837108201560920000000000000000000000e0 * t318 * t272 + 0.53795226013354837108201560920000000000000000000000e0 * t5 * t99 * t101 * t262 * t280 - 0.35863484008903224738801040613333333333333333333333e0 * t5 * t108 * t111 * t262 * t280 + 0.65749720682989245354468574457777777777777777777778e0 * t313 * t342 + 0.41973760960404120556899006708870613333333333333332e-1 * t322 * t348 - 0.15390379018814844204196302459919224888888888888888e0 * t322 * t331 - 0.13991253653468040185633002236290204444444444444444e-1 * t5 * t311 * t296 * t308 + 0.11498963501324606425972556031597937557145406122666e-2 * t354 * t260 / t356 / t46 * t618 / t40 / t216 / t232 * t77 * t32 * t36 - 0.29587374307345160409510858506000000000000000000000e1 * t264 * t37 * t265 * t199
  t677 = 0.16138567804006451132460468276000000000000000000000e1 * t290 * t272 + 0.11414531105621009451445590991106758459259259259259e1 * t326 * t301 * t302 / t39 / t504 * t77 + 0.30683202985394981165418668080296296296296296296296e1 * t318 * t338 - 0.13040361268792866995302933934125925925925925925926e2 * t264 * t37 * s0 / t40 / t232 * t77 - 0.19724916204896773606340572337333333333333333333333e1 * t285 * t342 - 0.35863484008903224738801040613333333333333333333333e0 * t313 * t292 + 0.53795226013354837108201560920000000000000000000000e0 * t264 * t37 * t270 * t256 + 0.53795226013354837108201560920000000000000000000000e0 * t5 * t133 * t28 * t262 * t280 + 0.16138567804006451132460468276000000000000000000000e1 * t278 * t292 + 0.62960641440606180835348510063305919999999999999999e-1 * t5 * t276 * t296 * t308 + 0.10759045202670967421640312184000000000000000000000e1 * t285 * t292 + 0.41973760960404120556899006708870613333333333333332e-1 * t5 * t283 * t296 * t308
  t718 = -0.46171137056444532612588907379757674666666666666666e0 * t298 * t331 - 0.46171137056444532612588907379757674666666666666666e0 * t326 * t301 * t329 * t156 + 0.92049608956184943496256004240888888888888888888889e1 * t290 * t338 + 0.92049608956184943496256004240888888888888888888889e1 * t264 * t37 * t336 * t156 - 0.29587374307345160409510858506000000000000000000000e1 * t278 * t342 - 0.59174748614690320819021717012000000000000000000000e1 * t290 * t267 - 0.19724916204896773606340572337333333333333333333333e1 * t318 * t267 + 0.12592128288121236167069702012661184000000000000000e0 * t298 * t348 + 0.62960641440606180835348510063305919999999999999999e-1 * t326 * t301 * t306 * t199 + 0.98250164915587866001802463751802305901226666666664e-2 * t354 * t316 * t363 + 0.29475049474676359800540739125540691770367999999999e-1 * t355 * t359 * t361 * t156 + 0.29475049474676359800540739125540691770367999999999e-1 * t354 * t288 * t363 - 0.16211277211071997890297406519047380473702399999999e0 * t355 * t359 / t216 / t170 * t77
  t721 = f.my_piecewise3(t1, 0, t579 + t632 + t677 + t718)
  t722 = t372 ** 2
  t725 = t380 ** 2
  t731 = t387 ** 2
  t737 = f.my_piecewise5(t14, 0, t10, 0, -t566)
  t741 = f.my_piecewise3(t373, 0, 0.40e2 / 0.81e2 / t375 / t722 * t725 - 0.16e2 / 0.9e1 * t377 * t380 * t387 + 0.4e1 / 0.3e1 * t384 * t731 + 0.16e2 / 0.9e1 * t385 * t391 + 0.4e1 / 0.3e1 * t374 * t737)
  t756 = f.my_piecewise3(t370, 0, -0.14459516250000000000000000000000000000000000000000e0 * t5 * t741 * t434 - 0.19279355000000000000000000000000000000000000000000e0 * t396 * t445 + 0.19279355000000000000000000000000000000000000000000e0 * t443 * t453 - 0.21421505555555555555555555555555555555555555555556e0 * t451 * t460 + 0.14281003703703703703703703703703703703703703703703e0 * t458 * t467 * t408 * t433)
  d1111 = 0.4e1 * t368 + 0.4e1 * t464 + t6 * (t721 + t756)

  res = {'v4rho4': d1111}
  return res
