"""Generated from lda_c_2d_amgb.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import jax.scipy.special as jsp_special
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *


def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  amgb_aa = np.array([np.nan, -0.1925, 0.117331, 0.0234188], dtype=np.float64)

  amgb_bb = np.array([np.nan, 0.0863136, -0.03394, -0.037093], dtype=np.float64)

  amgb_cc = np.array([np.nan, 0.0572384, -0.00766765, 0.0163618], dtype=np.float64)

  amgb_ee = np.array([np.nan, 1.0022, 0.4133, 1.424301], dtype=np.float64)

  amgb_ff = np.array([np.nan, -0.02069, 0, 0], dtype=np.float64)

  amgb_gg = np.array([np.nan, 0.33997, 0.0668467, 0], dtype=np.float64)

  amgb_hh = np.array([np.nan, 0.01747, 0.0007799, 1.163099], dtype=np.float64)

  amgb_beta = 1.3386

  amgb_ex6 = lambda rs, z: -4 * jnp.sqrt(2) / (3 * jnp.pi * rs) * (f.f_zeta_2d(z) - 1 - 3 / 8 * z ** 2 - 3 / 128 * z ** 4)

  amgb_dd = [None] + [-amgb_aa[i] * amgb_hh[i] for i in range(1, 3 + 1)]

  amgb_alpha = lambda i, rs: amgb_aa[i] + (amgb_bb[i] * rs + amgb_cc[i] * rs ** 2 + amgb_dd[i] * rs ** 3) * jnp.log(1 + 1 / (amgb_ee[i] * rs + amgb_ff[i] * rs ** 1.5 + amgb_gg[i] * rs ** 2 + amgb_hh[i] * rs ** 3))

  f_amgb = lambda rs, z: amgb_alpha(1, rs) + amgb_alpha(2, rs) * z ** 2 + amgb_alpha(3, rs) * z ** 4 + (jnp.exp(-amgb_beta * rs) - 1) * amgb_ex6(rs, z)

  functional_body = lambda rs, z: f_amgb(rs, z)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
  )
  return res


def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  amgb_aa = np.array([np.nan, -0.1925, 0.117331, 0.0234188], dtype=np.float64)

  amgb_bb = np.array([np.nan, 0.0863136, -0.03394, -0.037093], dtype=np.float64)

  amgb_cc = np.array([np.nan, 0.0572384, -0.00766765, 0.0163618], dtype=np.float64)

  amgb_ee = np.array([np.nan, 1.0022, 0.4133, 1.424301], dtype=np.float64)

  amgb_ff = np.array([np.nan, -0.02069, 0, 0], dtype=np.float64)

  amgb_gg = np.array([np.nan, 0.33997, 0.0668467, 0], dtype=np.float64)

  amgb_hh = np.array([np.nan, 0.01747, 0.0007799, 1.163099], dtype=np.float64)

  amgb_beta = 1.3386

  amgb_ex6 = lambda rs, z: -4 * jnp.sqrt(2) / (3 * jnp.pi * rs) * (f.f_zeta_2d(z) - 1 - 3 / 8 * z ** 2 - 3 / 128 * z ** 4)

  amgb_dd = [None] + [-amgb_aa[i] * amgb_hh[i] for i in range(1, 3 + 1)]

  amgb_alpha = lambda i, rs: amgb_aa[i] + (amgb_bb[i] * rs + amgb_cc[i] * rs ** 2 + amgb_dd[i] * rs ** 3) * jnp.log(1 + 1 / (amgb_ee[i] * rs + amgb_ff[i] * rs ** 1.5 + amgb_gg[i] * rs ** 2 + amgb_hh[i] * rs ** 3))

  f_amgb = lambda rs, z: amgb_alpha(1, rs) + amgb_alpha(2, rs) * z ** 2 + amgb_alpha(3, rs) * z ** 4 + (jnp.exp(-amgb_beta * rs) - 1) * amgb_ex6(rs, z)

  functional_body = lambda rs, z: f_amgb(rs, z)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t11 = t4 * t6 / t8
  t13 = t1 ** 2
  t14 = t3 ** 2
  t15 = t13 * t14
  t16 = t8 ** 2
  t17 = 0.1e1 / t16
  t19 = t15 * t5 * t17
  t21 = 0.1e1 / t7
  t22 = t2 * t21
  t24 = 0.21578400000000000000000000000000000000000000000000e-1 * t11 + 0.14309600000000000000000000000000000000000000000000e-1 * t19 + 0.25222312500000000000000000000000000000000000000000e-2 * t22
  t26 = t11 ** 0.15e1
  t30 = 0.25055000000000000000000000000000000000000000000000e0 * t11 - 0.25862500000000000000000000000000000000000000000000e-2 * t26 + 0.84992500000000000000000000000000000000000000000000e-1 * t19 + 0.13102500000000000000000000000000000000000000000000e-1 * t22
  t32 = 0.1e1 + 0.1e1 / t30
  t33 = jnp.log(t32)
  t34 = t24 * t33
  t38 = -0.84850000000000000000000000000000000000000000000000e-2 * t11 - 0.19169125000000000000000000000000000000000000000000e-2 * t19 - 0.68629835175000000000000000000000000000000000000000e-4 * t22
  t42 = 0.10332500000000000000000000000000000000000000000000e0 * t11 + 0.16711675000000000000000000000000000000000000000000e-1 * t19 + 0.58492500000000000000000000000000000000000000000000e-3 * t22
  t44 = 0.1e1 + 0.1e1 / t42
  t45 = jnp.log(t44)
  t47 = 0.117331e0 + t38 * t45
  t48 = r0 - r1
  t49 = t48 ** 2
  t50 = t47 * t49
  t51 = t7 ** 2
  t52 = 0.1e1 / t51
  t53 = t50 * t52
  t57 = -0.92732500000000000000000000000000000000000000000000e-2 * t11 + 0.40904500000000000000000000000000000000000000000000e-2 * t19 - 0.20428787145900000000000000000000000000000000000000e-1 * t22
  t60 = 0.35607525000000000000000000000000000000000000000000e0 * t11 + 0.87232425000000000000000000000000000000000000000000e0 * t22
  t62 = 0.1e1 + 0.1e1 / t60
  t63 = jnp.log(t62)
  t65 = 0.234188e-1 + t57 * t63
  t66 = t49 ** 2
  t67 = t65 * t66
  t68 = t51 ** 2
  t69 = 0.1e1 / t68
  t70 = t67 * t69
  t72 = jnp.exp(-0.33465000000000000000000000000000000000000000000000e0 * t11)
  t74 = jnp.sqrt(0.2e1)
  t77 = (t72 - 0.1e1) * t74 * t2 * t13
  t79 = 0.1e1 / t3 * t5
  t80 = t48 * t21
  t81 = 0.1e1 + t80
  t82 = t81 <= f.p.zeta_threshold
  t83 = jnp.sqrt(f.p.zeta_threshold)
  t84 = t83 * f.p.zeta_threshold
  t85 = jnp.sqrt(t81)
  t87 = f.my_piecewise3(t82, t84, t85 * t81)
  t89 = 0.1e1 - t80
  t90 = t89 <= f.p.zeta_threshold
  t91 = jnp.sqrt(t89)
  t93 = f.my_piecewise3(t90, t84, t91 * t89)
  t99 = t87 / 0.2e1 + t93 / 0.2e1 - 0.1e1 - 0.3e1 / 0.8e1 * t49 * t52 - 0.3e1 / 0.128e3 * t66 * t69
  t103 = 0.4e1 / 0.9e1 * t77 * t79 * t8 * t99
  t105 = 0.1e1 / t8 / t7
  t107 = t4 * t6 * t105
  t112 = t15 * t5 / t16 / t7
  t114 = t2 * t52
  t117 = (-0.71928000000000000000000000000000000000000000000000e-2 * t107 - 0.95397333333333333333333333333333333333333333333333e-2 * t112 - 0.25222312500000000000000000000000000000000000000000e-2 * t114) * t33
  t118 = t30 ** 2
  t122 = t11 ** 0.5e0
  t133 = t24 / t118 * (-0.83516666666666666666666666666666666666666666666667e-1 * t107 + 0.12931250000000000000000000000000000000000000000000e-2 * t122 * t1 * t3 * t6 * t105 - 0.56661666666666666666666666666666666666666666666667e-1 * t112 - 0.13102500000000000000000000000000000000000000000000e-1 * t114) / t32
  t139 = t42 ** 2
  t151 = ((0.28283333333333333333333333333333333333333333333333e-2 * t107 + 0.12779416666666666666666666666666666666666666666667e-2 * t112 + 0.68629835175000000000000000000000000000000000000000e-4 * t114) * t45 - t38 / t139 * (-0.34441666666666666666666666666666666666666666666667e-1 * t107 - 0.11141116666666666666666666666666666666666666666667e-1 * t112 - 0.58492500000000000000000000000000000000000000000000e-3 * t114) / t44) * t49 * t52
  t154 = 0.2e1 * t47 * t48 * t52
  t156 = 0.1e1 / t51 / t7
  t158 = 0.2e1 * t50 * t156
  t164 = t60 ** 2
  t175 = ((0.30910833333333333333333333333333333333333333333333e-2 * t107 - 0.27269666666666666666666666666666666666666666666667e-2 * t112 + 0.20428787145900000000000000000000000000000000000000e-1 * t114) * t63 - t57 / t164 * (-0.11869175000000000000000000000000000000000000000000e0 * t107 - 0.87232425000000000000000000000000000000000000000000e0 * t114) / t62) * t66 * t69
  t176 = t49 * t48
  t179 = 0.4e1 * t65 * t176 * t69
  t181 = 0.1e1 / t68 / t7
  t183 = 0.4e1 * t67 * t181
  t188 = 0.59493333333333333333333333333333333333333333333333e0 * t21 * t72 * t74 * t2 * t99
  t192 = 0.4e1 / 0.27e2 * t77 * t79 * t17 * t99
  t193 = t48 * t52
  t194 = t21 - t193
  t197 = f.my_piecewise3(t82, 0, 0.3e1 / 0.2e1 * t85 * t194)
  t202 = f.my_piecewise3(t90, 0, -0.3e1 / 0.2e1 * t91 * t194)
  t204 = 0.3e1 / 0.4e1 * t193
  t206 = 0.3e1 / 0.4e1 * t49 * t156
  t208 = 0.3e1 / 0.32e2 * t176 * t69
  t210 = 0.3e1 / 0.32e2 * t66 * t181
  t216 = t117 - t133 + t151 + t154 - t158 + t175 + t179 - t183 - t188 - t192 - 0.4e1 / 0.9e1 * t77 * t79 * t8 * (t197 / 0.2e1 + t202 / 0.2e1 - t204 + t206 - t208 + t210)
  vrho_0_ = -0.1925e0 + t34 + t53 + t70 - t103 + t7 * t216
  t218 = -t21 - t193
  t221 = f.my_piecewise3(t82, 0, 0.3e1 / 0.2e1 * t85 * t218)
  t226 = f.my_piecewise3(t90, 0, -0.3e1 / 0.2e1 * t91 * t218)
  t233 = t117 - t133 + t151 - t154 - t158 + t175 - t179 - t183 - t188 - t192 - 0.4e1 / 0.9e1 * t77 * t79 * t8 * (t221 / 0.2e1 + t226 / 0.2e1 + t204 + t206 + t208 + t210)
  vrho_1_ = -0.1925e0 + t34 + t53 + t70 - t103 + t7 * t233

  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1)}
  return res


def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t10 = t4 * t6 / t7
  t12 = t1 ** 2
  t13 = t3 ** 2
  t14 = t12 * t13
  t15 = t7 ** 2
  t16 = 0.1e1 / t15
  t18 = t14 * t5 * t16
  t20 = 0.1e1 / r0
  t21 = t2 * t20
  t23 = 0.21578400000000000000000000000000000000000000000000e-1 * t10 + 0.14309600000000000000000000000000000000000000000000e-1 * t18 + 0.25222312500000000000000000000000000000000000000000e-2 * t21
  t25 = t10 ** 0.15e1
  t29 = 0.25055000000000000000000000000000000000000000000000e0 * t10 - 0.25862500000000000000000000000000000000000000000000e-2 * t25 + 0.84992500000000000000000000000000000000000000000000e-1 * t18 + 0.13102500000000000000000000000000000000000000000000e-1 * t21
  t31 = 0.1e1 + 0.1e1 / t29
  t32 = jnp.log(t31)
  t35 = jnp.exp(-0.33465000000000000000000000000000000000000000000000e0 * t10)
  t37 = jnp.sqrt(0.2e1)
  t40 = (t35 - 0.1e1) * t37 * t2 * t12
  t42 = 0.1e1 / t3 * t5
  t44 = jnp.sqrt(f.p.zeta_threshold)
  t46 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t44 * f.p.zeta_threshold, 1)
  t47 = t46 - 0.1e1
  t53 = 0.1e1 / t7 / r0
  t55 = t4 * t6 * t53
  t60 = t14 * t5 / t15 / r0
  t62 = r0 ** 2
  t64 = t2 / t62
  t68 = t29 ** 2
  t72 = t10 ** 0.5e0
  vrho_0_ = -0.1925e0 + t23 * t32 - 0.4e1 / 0.9e1 * t40 * t42 * t7 * t47 + r0 * ((-0.71928000000000000000000000000000000000000000000000e-2 * t55 - 0.95397333333333333333333333333333333333333333333333e-2 * t60 - 0.25222312500000000000000000000000000000000000000000e-2 * t64) * t32 - t23 / t68 * (-0.83516666666666666666666666666666666666666666666667e-1 * t55 + 0.12931250000000000000000000000000000000000000000000e-2 * t72 * t1 * t3 * t6 * t53 - 0.56661666666666666666666666666666666666666666666667e-1 * t60 - 0.13102500000000000000000000000000000000000000000000e-1 * t64) / t31 - 0.59493333333333333333333333333333333333333333333333e0 * t20 * t35 * t37 * t2 * t47 - 0.4e1 / 0.27e2 * t40 * t42 * t16 * t47)

  res = {'vrho': vrho_0_}
  return res
