"""Generated from lda_c_vwn_4.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  A_rpa = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_rpa = np.array([np.nan, 13.072, 20.1231, 1.06835], dtype=np.float64)

  c_rpa = np.array([np.nan, 42.7198, 101.578, 11.4813], dtype=np.float64)

  x0_rpa = np.array([np.nan, -0.409286, -0.743294, -0.228344], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fpp_vwn = 4 / (9 * (2 ** (1 / 3) - 1))

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  DMC = lambda rs, z=None: +f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) - f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs)

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) + f_aux(A_rpa[3], b_rpa[3], c_rpa[3], x0_rpa[3], rs) * f.f_zeta(z) * (1 - z ** 4) / fpp_vwn + DMC(rs, z) * f.f_zeta(z) * z ** 4

  functional_body = lambda rs, z: f_vwn(rs, z)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  A_rpa = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_rpa = np.array([np.nan, 13.072, 20.1231, 1.06835], dtype=np.float64)

  c_rpa = np.array([np.nan, 42.7198, 101.578, 11.4813], dtype=np.float64)

  x0_rpa = np.array([np.nan, -0.409286, -0.743294, -0.228344], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fpp_vwn = 4 / (9 * (2 ** (1 / 3) - 1))

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  DMC = lambda rs, z=None: +f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) - f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs)

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) + f_aux(A_rpa[3], b_rpa[3], c_rpa[3], x0_rpa[3], rs) * f.f_zeta(z) * (1 - z ** 4) / fpp_vwn + DMC(rs, z) * f.f_zeta(z) * z ** 4

  functional_body = lambda rs, z: f_vwn(rs, z)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  A_rpa = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_rpa = np.array([np.nan, 13.072, 20.1231, 1.06835], dtype=np.float64)

  c_rpa = np.array([np.nan, 42.7198, 101.578, 11.4813], dtype=np.float64)

  x0_rpa = np.array([np.nan, -0.409286, -0.743294, -0.228344], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fpp_vwn = 4 / (9 * (2 ** (1 / 3) - 1))

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  DMC = lambda rs, z=None: +f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) - f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs)

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) + f_aux(A_rpa[3], b_rpa[3], c_rpa[3], x0_rpa[3], rs) * f.f_zeta(z) * (1 - z ** 4) / fpp_vwn + DMC(rs, z) * f.f_zeta(z) * z ** 4

  functional_body = lambda rs, z: f_vwn(rs, z)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t8
  t10 = t6 * t9
  t11 = t4 * t10
  t12 = t11 / 0.4e1
  t13 = jnp.sqrt(t11)
  t15 = t12 + 0.18637200000000000000000000000000000000000000000000e1 * t13 + 0.129352e2
  t16 = 0.1e1 / t15
  t20 = jnp.log(t4 * t10 * t16 / 0.4e1)
  t21 = 0.310907e-1 * t20
  t22 = t13 + 0.372744e1
  t25 = jnp.arctan(0.61519908197590802321728722658814145360143502774884e1 / t22)
  t26 = 0.38783294878113014394824731224995739188004877421366e-1 * t25
  t27 = t13 / 0.2e1
  t28 = t27 + 0.10498e0
  t29 = t28 ** 2
  t31 = jnp.log(t29 * t16)
  t32 = 0.96902277115443742137603943210562149050493484994510e-3 * t31
  t33 = jnp.pi ** 2
  t34 = 0.1e1 / t33
  t36 = t12 + 0.53417500000000000000000000000000000000000000000000e0 * t13 + 0.114813e2
  t37 = 0.1e1 / t36
  t41 = jnp.log(t4 * t10 * t37 / 0.4e1)
  t42 = t13 + 0.106835e1
  t45 = jnp.arctan(0.66920720466459414830082628492168721398166211679256e1 / t42)
  t47 = t27 + 0.228344e0
  t48 = t47 ** 2
  t50 = jnp.log(t48 * t37)
  t53 = t34 * (t41 + 0.32323836906055067299704130765928097906535029214057e0 * t45 + 0.21608710360898267021763215722876235716176892439270e-1 * t50)
  t54 = r0 - r1
  t55 = 0.1e1 / t7
  t56 = t54 * t55
  t57 = 0.1e1 + t56
  t58 = t57 <= f.p.zeta_threshold
  t59 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t60 = t59 * f.p.zeta_threshold
  t61 = t57 ** (0.1e1 / 0.3e1)
  t63 = f.my_piecewise3(t58, t60, t61 * t57)
  t64 = 0.1e1 - t56
  t65 = t64 <= f.p.zeta_threshold
  t66 = t64 ** (0.1e1 / 0.3e1)
  t68 = f.my_piecewise3(t65, t60, t66 * t64)
  t69 = t63 + t68 - 0.2e1
  t70 = t53 * t69
  t71 = 2 ** (0.1e1 / 0.3e1)
  t72 = t71 - 0.1e1
  t74 = 0.1e1 / t72 / 0.2e1
  t75 = t54 ** 2
  t76 = t75 ** 2
  t77 = t7 ** 2
  t78 = t77 ** 2
  t79 = 0.1e1 / t78
  t83 = 0.9e1 / 0.4e1 * t72
  t84 = t74 * (-t76 * t79 + 0.1e1) * t83
  t86 = t70 * t84 / 0.6e1
  t88 = t12 + 0.35302100000000000000000000000000000000000000000000e1 * t13 + 0.180578e2
  t89 = 0.1e1 / t88
  t93 = jnp.log(t4 * t10 * t89 / 0.4e1)
  t95 = t13 + 0.706042e1
  t98 = jnp.arctan(0.47309269095601128299619512910246923284397083311420e1 / t95)
  t100 = t27 + 0.32500e0
  t101 = t100 ** 2
  t103 = jnp.log(t101 * t89)
  t105 = 0.1554535e-1 * t93 + 0.52491393169780936217021346072241076933841385384498e-1 * t98 + 0.22478670955426118383265363956423012380560746650571e-2 * t103 - t21 - t26 - t32
  t106 = t105 * t69
  t107 = t74 * t76
  t108 = t107 * t79
  t109 = t106 * t108
  t111 = 0.1e1 / t8 / t7
  t112 = t6 * t111
  t116 = t4 * t6
  t117 = t15 ** 2
  t118 = 0.1e1 / t117
  t120 = t4 * t112
  t121 = t120 / 0.12e2
  t122 = 0.1e1 / t13
  t124 = t3 * t6
  t126 = t122 * t1 * t124 * t111
  t128 = -t121 - 0.31062000000000000000000000000000000000000000000000e0 * t126
  t133 = t1 ** 2
  t135 = 0.1e1 / t3
  t137 = t5 * t8
  t140 = 0.10363566666666666666666666666666666666666666666667e-1 * (-t4 * t112 * t16 / 0.12e2 - t116 * t9 * t118 * t128 / 0.4e1) * t133 * t135 * t137 * t15
  t141 = t22 ** 2
  t142 = 0.1e1 / t141
  t151 = 0.39765745675026770180313930393880960493473766078662e-1 * t142 * t122 * t1 * t124 * t111 / (0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t142)
  t162 = 0.96902277115443742137603943210562149050493484994510e-3 * (-t28 * t16 * t122 * t120 / 0.6e1 - t29 * t118 * t128) / t29 * t15
  t166 = t36 ** 2
  t167 = 0.1e1 / t166
  t170 = -t121 - 0.89029166666666666666666666666666666666666666666667e-1 * t126
  t180 = t42 ** 2
  t181 = 0.1e1 / t180
  t206 = t34 * ((-t4 * t112 * t37 / 0.12e2 - t116 * t9 * t167 * t170 / 0.4e1) * t133 * t135 * t137 * t36 / 0.3e1 + 0.36052240899892258526768857735182864136354273012771e0 * t181 * t122 * t1 * t124 * t111 / (0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t181) + 0.21608710360898267021763215722876235716176892439270e-1 * (-t47 * t37 * t122 * t120 / 0.6e1 - t48 * t167 * t170) / t48 * t36) * t69 * t84 / 0.6e1
  t208 = t54 / t77
  t209 = t55 - t208
  t212 = f.my_piecewise3(t58, 0, 0.4e1 / 0.3e1 * t61 * t209)
  t216 = f.my_piecewise3(t65, 0, -0.4e1 / 0.3e1 * t66 * t209)
  t217 = t212 + t216
  t221 = t75 * t54
  t222 = t221 * t79
  t224 = 0.1e1 / t78 / t7
  t225 = t76 * t224
  t235 = t88 ** 2
  t236 = 0.1e1 / t235
  t239 = -t121 - 0.58836833333333333333333333333333333333333333333333e0 * t126
  t249 = t95 ** 2
  t250 = 0.1e1 / t249
  t273 = (0.51817833333333333333333333333333333333333333333333e-2 * (-t4 * t112 * t89 / 0.12e2 - t116 * t9 * t236 * t239 / 0.4e1) * t133 * t135 * t137 * t88 + 0.41388824077869423260215065147117773567486474051459e-1 * t250 * t122 * t1 * t124 * t111 / (0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t250) + 0.22478670955426118383265363956423012380560746650571e-2 * (-t100 * t89 * t122 * t120 / 0.6e1 - t101 * t236 * t239) / t101 * t88 - t140 - t151 - t162) * t69 * t108
  t279 = 0.4e1 * t106 * t74 * t221 * t79
  t282 = 0.4e1 * t106 * t107 * t224
  vrho_0_ = t21 + t26 + t32 - t86 + t109 + t7 * (t140 + t151 + t162 - t206 - t53 * t217 * t84 / 0.6e1 - t70 * t74 * (-0.4e1 * t222 + 0.4e1 * t225) * t83 / 0.6e1 + t273 + t105 * t217 * t108 + t279 - t282)
  t285 = -t55 - t208
  t288 = f.my_piecewise3(t58, 0, 0.4e1 / 0.3e1 * t61 * t285)
  t292 = f.my_piecewise3(t65, 0, -0.4e1 / 0.3e1 * t66 * t285)
  t293 = t288 + t292
  vrho_1_ = t21 + t26 + t32 - t86 + t109 + t7 * (t140 + t151 + t162 - t206 - t53 * t293 * t84 / 0.6e1 - t70 * t74 * (0.4e1 * t222 + 0.4e1 * t225) * t83 / 0.6e1 + t273 + t105 * t293 * t108 - t279 - t282)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  A_rpa = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_rpa = np.array([np.nan, 13.072, 20.1231, 1.06835], dtype=np.float64)

  c_rpa = np.array([np.nan, 42.7198, 101.578, 11.4813], dtype=np.float64)

  x0_rpa = np.array([np.nan, -0.409286, -0.743294, -0.228344], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fpp_vwn = 4 / (9 * (2 ** (1 / 3) - 1))

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  DMC = lambda rs, z=None: +f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) - f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs)

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) + f_aux(A_rpa[3], b_rpa[3], c_rpa[3], x0_rpa[3], rs) * f.f_zeta(z) * (1 - z ** 4) / fpp_vwn + DMC(rs, z) * f.f_zeta(z) * z ** 4

  functional_body = lambda rs, z: f_vwn(rs, z)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t10 = t4 * t9
  t11 = t10 / 0.4e1
  t12 = jnp.sqrt(t10)
  t14 = t11 + 0.18637200000000000000000000000000000000000000000000e1 * t12 + 0.129352e2
  t15 = 0.1e1 / t14
  t19 = jnp.log(t4 * t9 * t15 / 0.4e1)
  t21 = t12 + 0.372744e1
  t24 = jnp.arctan(0.61519908197590802321728722658814145360143502774884e1 / t21)
  t26 = t12 / 0.2e1
  t27 = t26 + 0.10498e0
  t28 = t27 ** 2
  t30 = jnp.log(t28 * t15)
  t32 = jnp.pi ** 2
  t33 = 0.1e1 / t32
  t35 = t11 + 0.53417500000000000000000000000000000000000000000000e0 * t12 + 0.114813e2
  t36 = 0.1e1 / t35
  t40 = jnp.log(t4 * t9 * t36 / 0.4e1)
  t41 = t12 + 0.106835e1
  t44 = jnp.arctan(0.66920720466459414830082628492168721398166211679256e1 / t41)
  t46 = t26 + 0.228344e0
  t47 = t46 ** 2
  t49 = jnp.log(t47 * t36)
  t54 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t56 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t54 * f.p.zeta_threshold, 1)
  t59 = 2 ** (0.1e1 / 0.3e1)
  t60 = t59 - 0.1e1
  t65 = 0.9e1 / 0.4e1 * t56 - 0.9e1 / 0.4e1
  t69 = 0.1e1 / t7 / r0
  t70 = t6 * t69
  t74 = t4 * t6
  t75 = t14 ** 2
  t76 = 0.1e1 / t75
  t78 = t4 * t70
  t79 = t78 / 0.12e2
  t80 = 0.1e1 / t12
  t82 = t3 * t6
  t84 = t80 * t1 * t82 * t69
  t86 = -t79 - 0.31062000000000000000000000000000000000000000000000e0 * t84
  t91 = t1 ** 2
  t93 = 0.1e1 / t3
  t95 = t5 * t7
  t99 = t21 ** 2
  t100 = 0.1e1 / t99
  t124 = t35 ** 2
  t125 = 0.1e1 / t124
  t128 = -t79 - 0.89029166666666666666666666666666666666666666666667e-1 * t84
  t138 = t41 ** 2
  t139 = 0.1e1 / t138
  vrho_0_ = 0.310907e-1 * t19 + 0.38783294878113014394824731224995739188004877421366e-1 * t24 + 0.96902277115443742137603943210562149050493484994510e-3 * t30 - t33 * (t40 + 0.32323836906055067299704130765928097906535029214057e0 * t44 + 0.21608710360898267021763215722876235716176892439270e-1 * t49) * t65 / 0.6e1 + r0 * (0.10363566666666666666666666666666666666666666666667e-1 * (-t4 * t70 * t15 / 0.12e2 - t74 * t8 * t76 * t86 / 0.4e1) * t91 * t93 * t95 * t14 + 0.39765745675026770180313930393880960493473766078662e-1 * t100 * t80 * t1 * t82 * t69 / (0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t100) + 0.96902277115443742137603943210562149050493484994510e-3 * (-t27 * t15 * t80 * t78 / 0.6e1 - t28 * t76 * t86) / t28 * t14 - t33 * ((-t4 * t70 * t36 / 0.12e2 - t74 * t8 * t125 * t128 / 0.4e1) * t91 * t93 * t95 * t35 / 0.3e1 + 0.36052240899892258526768857735182864136354273012771e0 * t139 * t80 * t1 * t82 * t69 / (0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t139) + 0.21608710360898267021763215722876235716176892439270e-1 * (-t46 * t36 * t80 * t78 / 0.6e1 - t47 * t125 * t128) / t47 * t35) * t65 / 0.6e1)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  res = {'vrho': vrho_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t7 / r0
  t10 = t6 * t9
  t11 = 0.1e1 / t7
  t13 = t4 * t6 * t11
  t14 = t13 / 0.4e1
  t15 = jnp.sqrt(t13)
  t17 = t14 + 0.18637200000000000000000000000000000000000000000000e1 * t15 + 0.129352e2
  t18 = 0.1e1 / t17
  t22 = t4 * t6
  t23 = t17 ** 2
  t24 = 0.1e1 / t23
  t25 = t11 * t24
  t26 = t4 * t10
  t27 = t26 / 0.12e2
  t28 = 0.1e1 / t15
  t29 = t28 * t1
  t30 = t3 * t6
  t32 = t29 * t30 * t9
  t34 = -t27 - 0.31062000000000000000000000000000000000000000000000e0 * t32
  t39 = t1 ** 2
  t41 = 0.1e1 / t3
  t42 = (-t4 * t10 * t18 / 0.12e2 - t22 * t25 * t34 / 0.4e1) * t39 * t41
  t43 = t5 * t7
  t44 = t43 * t17
  t47 = t15 + 0.372744e1
  t48 = t47 ** 2
  t49 = 0.1e1 / t48
  t51 = t49 * t28 * t1
  t53 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t49
  t54 = 0.1e1 / t53
  t59 = t15 / 0.2e1
  t60 = t59 + 0.10498e0
  t61 = t60 * t18
  t62 = t61 * t28
  t65 = t60 ** 2
  t66 = t65 * t24
  t68 = -t62 * t26 / 0.6e1 - t66 * t34
  t69 = 0.1e1 / t65
  t70 = t68 * t69
  t73 = jnp.pi ** 2
  t74 = 0.1e1 / t73
  t76 = t14 + 0.53417500000000000000000000000000000000000000000000e0 * t15 + 0.114813e2
  t77 = 0.1e1 / t76
  t81 = t76 ** 2
  t82 = 0.1e1 / t81
  t83 = t11 * t82
  t85 = -t27 - 0.89029166666666666666666666666666666666666666666667e-1 * t32
  t91 = (-t4 * t10 * t77 / 0.12e2 - t22 * t83 * t85 / 0.4e1) * t39 * t41
  t92 = t43 * t76
  t95 = t15 + 0.106835e1
  t96 = t95 ** 2
  t97 = 0.1e1 / t96
  t99 = t97 * t28 * t1
  t101 = 0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t97
  t102 = 0.1e1 / t101
  t107 = t59 + 0.228344e0
  t108 = t107 * t77
  t109 = t108 * t28
  t112 = t107 ** 2
  t113 = t112 * t82
  t115 = -t109 * t26 / 0.6e1 - t113 * t85
  t116 = 0.1e1 / t112
  t117 = t115 * t116
  t123 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t125 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t123 * f.p.zeta_threshold, 1)
  t128 = 2 ** (0.1e1 / 0.3e1)
  t129 = t128 - 0.1e1
  t134 = 0.9e1 * t125 - 0.9e1
  t137 = r0 ** 2
  t139 = 0.1e1 / t7 / t137
  t140 = t6 * t139
  t142 = t4 * t140 * t18
  t149 = 0.1e1 / t23 / t17
  t151 = t34 ** 2
  t155 = t4 * t140
  t156 = t155 / 0.9e1
  t158 = 0.1e1 / t15 / t13
  t160 = t3 ** 2
  t161 = t160 * t5
  t162 = t7 ** 2
  t164 = 0.1e1 / t162 / t137
  t166 = t158 * t39 * t161 * t164
  t169 = t29 * t30 * t139
  t171 = t156 - 0.20708000000000000000000000000000000000000000000000e0 * t166 + 0.41416000000000000000000000000000000000000000000000e0 * t169
  t181 = t5 / t162
  t205 = t48 ** 2
  t210 = t53 ** 2
  t225 = t39 * t160 * t5 * t164
  t248 = t4 * t140 * t77
  t255 = 0.1e1 / t81 / t76
  t257 = t85 ** 2
  t263 = t156 - 0.59352777777777777777777777777777777777777777777778e-1 * t166 + 0.11870555555555555555555555555555555555555555555556e0 * t169
  t295 = t96 ** 2
  t300 = t101 ** 2
  t338 = 0.10363566666666666666666666666666666666666666666667e-1 * (t142 / 0.9e1 + t22 * t9 * t24 * t34 / 0.6e1 + t22 * t11 * t149 * t151 / 0.2e1 - t22 * t25 * t171 / 0.4e1) * t39 * t41 * t44 + 0.34545222222222222222222222222222222222222222222223e-2 * t42 * t181 * t17 + 0.10363566666666666666666666666666666666666666666667e-1 * t42 * t43 * t34 + 0.13255248558342256726771310131293653497824588692887e-1 / t48 / t47 * t1 * t3 * t140 * t54 + 0.26510497116684513453542620262587306995649177385775e-1 * t49 * t158 * t39 * t161 * t164 * t54 - 0.53020994233369026907085240525174613991298354771549e-1 * t51 * t30 * t139 * t54 - 0.50167127350538589836488394571946851238131125013746e0 / t205 / t47 * t1 * t3 * t140 / t210 + 0.96902277115443742137603943210562149050493484994510e-3 * (t142 / 0.72e2 + t60 * t24 * t29 * t30 * t9 * t34 / 0.3e1 - t61 * t158 * t225 / 0.9e1 + 0.2e1 / 0.9e1 * t62 * t155 + 0.2e1 * t65 * t149 * t151 - t66 * t171) * t69 * t17 + 0.16150379519240623689600657201760358175082247499085e-3 * t68 / t65 / t60 * t17 * t28 * t26 + 0.96902277115443742137603943210562149050493484994510e-3 * t70 * t34 - t74 * ((t248 / 0.9e1 + t22 * t9 * t82 * t85 / 0.6e1 + t22 * t11 * t255 * t257 / 0.2e1 - t22 * t83 * t263 / 0.4e1) * t39 * t41 * t92 / 0.3e1 + t91 * t181 * t76 / 0.9e1 + t91 * t43 * t85 / 0.3e1 + 0.12017413633297419508922952578394288045451424337591e0 / t96 / t95 * t1 * t3 * t140 * t102 + 0.24034827266594839017845905156788576090902848675181e0 * t97 * t158 * t39 * t161 * t164 * t102 - 0.48069654533189678035691810313577152181805697350363e0 * t99 * t30 * t139 * t102 - 0.53818578849327899137148388724908565251436770250246e1 / t295 / t95 * t1 * t3 * t140 / t300 + 0.21608710360898267021763215722876235716176892439270e-1 * (t248 / 0.72e2 + t107 * t82 * t29 * t30 * t9 * t85 / 0.3e1 - t108 * t158 * t225 / 0.9e1 + 0.2e1 / 0.9e1 * t109 * t155 + 0.2e1 * t112 * t255 * t257 - t113 * t263) * t116 * t76 + 0.36014517268163778369605359538127059526961487398783e-2 * t115 / t112 / t107 * t76 * t28 * t26 + 0.21608710360898267021763215722876235716176892439270e-1 * t117 * t85) * t134 / 0.24e2
  v2rho2_0_ = 0.20727133333333333333333333333333333333333333333334e-1 * t42 * t44 + 0.79531491350053540360627860787761920986947532157324e-1 * t51 * t30 * t9 * t54 + 0.19380455423088748427520788642112429810098696998902e-2 * t70 * t17 - t74 * (t91 * t92 / 0.3e1 + 0.36052240899892258526768857735182864136354273012772e0 * t99 * t30 * t9 * t102 + 0.21608710360898267021763215722876235716176892439270e-1 * t117 * t76) * t134 / 0.12e2 + r0 * t338
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** 2
  t8 = r0 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t12 = 0.1e1 / t8
  t14 = t4 * t6 * t12
  t15 = t14 / 0.4e1
  t16 = jnp.sqrt(t14)
  t18 = t15 + 0.18637200000000000000000000000000000000000000000000e1 * t16 + 0.129352e2
  t19 = 0.1e1 / t18
  t21 = t4 * t11 * t19
  t23 = t4 * t6
  t25 = 0.1e1 / t8 / r0
  t26 = t18 ** 2
  t27 = 0.1e1 / t26
  t28 = t25 * t27
  t29 = t6 * t25
  t30 = t4 * t29
  t31 = t30 / 0.12e2
  t32 = 0.1e1 / t16
  t33 = t32 * t1
  t34 = t3 * t6
  t36 = t33 * t34 * t25
  t38 = -t31 - 0.31062000000000000000000000000000000000000000000000e0 * t36
  t43 = 0.1e1 / t26 / t18
  t44 = t12 * t43
  t45 = t38 ** 2
  t49 = t12 * t27
  t50 = t4 * t11
  t51 = t50 / 0.9e1
  t53 = 0.1e1 / t16 / t14
  t54 = t1 ** 2
  t55 = t53 * t54
  t56 = t3 ** 2
  t57 = t56 * t5
  t58 = t8 ** 2
  t60 = 0.1e1 / t58 / t7
  t62 = t55 * t57 * t60
  t65 = t33 * t34 * t10
  t67 = t51 - 0.20708000000000000000000000000000000000000000000000e0 * t62 + 0.41416000000000000000000000000000000000000000000000e0 * t65
  t73 = 0.1e1 / t3
  t74 = (t21 / 0.9e1 + t23 * t28 * t38 / 0.6e1 + t23 * t44 * t45 / 0.2e1 - t23 * t49 * t67 / 0.4e1) * t54 * t73
  t75 = t5 * t8
  t76 = t75 * t18
  t87 = (-t4 * t29 * t19 / 0.12e2 - t23 * t49 * t38 / 0.4e1) * t54 * t73
  t89 = t5 / t58
  t90 = t89 * t18
  t93 = t75 * t38
  t96 = t16 + 0.372744e1
  t97 = t96 ** 2
  t100 = 0.1e1 / t97 / t96 * t1
  t101 = t100 * t3
  t102 = 0.1e1 / t97
  t104 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t102
  t105 = 0.1e1 / t104
  t110 = t102 * t53 * t54
  t116 = t102 * t32 * t1
  t121 = t97 ** 2
  t124 = 0.1e1 / t121 / t96 * t1
  t125 = t124 * t3
  t126 = t104 ** 2
  t127 = 0.1e1 / t126
  t132 = t16 / 0.2e1
  t133 = t132 + 0.10498e0
  t134 = t133 * t27
  t135 = t134 * t33
  t140 = t133 * t19
  t141 = t140 * t53
  t142 = t54 * t56
  t144 = t142 * t5 * t60
  t147 = t140 * t32
  t150 = t133 ** 2
  t151 = t150 * t43
  t154 = t150 * t27
  t156 = t21 / 0.72e2 + t135 * t34 * t25 * t38 / 0.3e1 - t141 * t144 / 0.9e1 + 0.2e1 / 0.9e1 * t147 * t50 + 0.2e1 * t151 * t45 - t154 * t67
  t157 = 0.1e1 / t150
  t158 = t156 * t157
  t164 = -t147 * t30 / 0.6e1 - t154 * t38
  t166 = 0.1e1 / t150 / t133
  t167 = t164 * t166
  t168 = t18 * t32
  t169 = t167 * t168
  t172 = t164 * t157
  t175 = jnp.pi ** 2
  t176 = 0.1e1 / t175
  t178 = t15 + 0.53417500000000000000000000000000000000000000000000e0 * t16 + 0.114813e2
  t179 = 0.1e1 / t178
  t181 = t4 * t11 * t179
  t183 = t178 ** 2
  t184 = 0.1e1 / t183
  t185 = t25 * t184
  t187 = -t31 - 0.89029166666666666666666666666666666666666666666667e-1 * t36
  t192 = 0.1e1 / t183 / t178
  t193 = t12 * t192
  t194 = t187 ** 2
  t198 = t12 * t184
  t201 = t51 - 0.59352777777777777777777777777777777777777777777778e-1 * t62 + 0.11870555555555555555555555555555555555555555555556e0 * t65
  t207 = (t181 / 0.9e1 + t23 * t185 * t187 / 0.6e1 + t23 * t193 * t194 / 0.2e1 - t23 * t198 * t201 / 0.4e1) * t54 * t73
  t208 = t75 * t178
  t219 = (-t4 * t29 * t179 / 0.12e2 - t23 * t198 * t187 / 0.4e1) * t54 * t73
  t220 = t89 * t178
  t223 = t75 * t187
  t226 = t16 + 0.106835e1
  t227 = t226 ** 2
  t230 = 0.1e1 / t227 / t226 * t1
  t231 = t230 * t3
  t232 = 0.1e1 / t227
  t234 = 0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t232
  t235 = 0.1e1 / t234
  t240 = t232 * t53 * t54
  t246 = t232 * t32 * t1
  t251 = t227 ** 2
  t254 = 0.1e1 / t251 / t226 * t1
  t255 = t254 * t3
  t256 = t234 ** 2
  t257 = 0.1e1 / t256
  t262 = t132 + 0.228344e0
  t263 = t262 * t184
  t264 = t263 * t33
  t269 = t262 * t179
  t270 = t269 * t53
  t273 = t269 * t32
  t276 = t262 ** 2
  t277 = t276 * t192
  t280 = t276 * t184
  t282 = t181 / 0.72e2 + t264 * t34 * t25 * t187 / 0.3e1 - t270 * t144 / 0.9e1 + 0.2e1 / 0.9e1 * t273 * t50 + 0.2e1 * t277 * t194 - t280 * t201
  t283 = 0.1e1 / t276
  t284 = t282 * t283
  t290 = -t273 * t30 / 0.6e1 - t280 * t187
  t292 = 0.1e1 / t276 / t262
  t293 = t290 * t292
  t294 = t178 * t32
  t295 = t293 * t294
  t298 = t290 * t283
  t304 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t306 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t304 * f.p.zeta_threshold, 1)
  t309 = 2 ** (0.1e1 / 0.3e1)
  t310 = t309 - 0.1e1
  t315 = 0.9e1 * t306 - 0.9e1
  t326 = t7 * r0
  t328 = 0.1e1 / t8 / t326
  t329 = t6 * t328
  t337 = t5 / t58 / r0
  t345 = t4 * t329 * t19
  t349 = t23 * t10 * t27 * t38
  t358 = t26 ** 2
  t359 = 0.1e1 / t358
  t361 = t45 * t38
  t365 = t38 * t67
  t369 = t4 * t329
  t370 = 0.7e1 / 0.27e2 * t369
  t374 = 0.1e1 / t16 / t142 / t89 / 0.4e1
  t376 = t7 ** 2
  t377 = 0.1e1 / t376
  t378 = t374 * t2 * t377
  t381 = 0.1e1 / t58 / t326
  t383 = t55 * t57 * t381
  t386 = t33 * t34 * t328
  t388 = -t370 - 0.12424800000000000000000000000000000000000000000000e1 * t378 + 0.82832000000000000000000000000000000000000000000000e0 * t383 - 0.96637333333333333333333333333333333333333333333333e0 * t386
  t398 = t2 * t377
  t414 = t4 * t329 * t179
  t418 = t23 * t10 * t184 * t187
  t427 = t183 ** 2
  t428 = 0.1e1 / t427
  t430 = t194 * t187
  t434 = t187 * t201
  t441 = -t370 - 0.35611666666666666666666666666666666666666666666667e0 * t378 + 0.23741111111111111111111111111111111111111111111111e0 * t383 - 0.27697962962962962962962962962962962962962962962964e0 * t386
  t472 = 0.1e1 / t56
  t474 = t1 * t472 * t6
  t475 = t328 * t2
  t481 = t5 * t381
  t482 = t142 * t481
  t493 = -0.11e2 / 0.216e3 * t414 - t418 / 0.24e2 - t262 * t192 * t33 * t34 * t25 * t194 + t263 * t55 * t57 * t60 * t187 / 0.3e1 - 0.2e1 / 0.3e1 * t264 * t34 * t10 * t187 + t264 * t34 * t25 * t201 / 0.2e1 + t474 * t475 * t179 / 0.432e3 - 0.2e1 / 0.3e1 * t269 * t378 + 0.4e1 / 0.9e1 * t270 * t482 - 0.14e2 / 0.27e2 * t273 * t369 - 0.6e1 * t276 * t428 * t430 + 0.6e1 * t277 * t434 - t280 * t441
  t509 = 0.14420896359956903410707543094073145654541709205109e1 * t232 * t374 * t398 * t235 + 0.19733478911420229683621075865799807258860149091757e2 * t255 * t329 * t257 + t219 * t75 * t201 / 0.3e1 + 0.2e1 / 0.3e1 * t207 * t223 + 0.2e1 / 0.9e1 * t219 * t89 * t187 + (-0.7e1 / 0.27e2 * t414 - t418 / 0.3e1 - t23 * t25 * t192 * t194 / 0.2e1 + t23 * t185 * t201 / 0.4e1 - 0.3e1 / 0.2e1 * t23 * t12 * t428 * t430 + 0.3e1 / 0.2e1 * t23 * t193 * t434 - t23 * t198 * t441 / 0.4e1) * t54 * t73 * t208 / 0.3e1 - 0.48019356357551704492807146050836079369281983198377e-2 * t295 * t50 + 0.21608710360898267021763215722876235716176892439270e-1 * t493 * t283 * t178 + 0.43217420721796534043526431445752471432353784878540e-1 * t284 * t187 + 0.21608710360898267021763215722876235716176892439270e-1 * t298 * t201 - 0.96139309066379356071383620627154304363611394700724e0 * t240 * t57 * t381 * t235 + 0.11216252724410924874994755739834668842421329381751e1 * t246 * t34 * t328 * t235
  t555 = t251 ** 2
  t565 = t276 ** 2
  t571 = 0.72029034536327556739210719076254119053922974797566e-2 * t282 * t292 * t294 * t30 + 0.72029034536327556739210719076254119053922974797566e-2 * t293 * t187 * t32 * t30 + 0.24009678178775852246403573025418039684640991599189e-2 * t293 * t178 * t53 * t144 + 0.2e1 / 0.9e1 * t207 * t220 - 0.2e1 / 0.27e2 * t219 * t337 * t178 - 0.44063849988757204866050826120779056166655222571167e0 * t231 * t329 * t235 + 0.24034827266594839017845905156788576090902848675182e0 / t251 * t54 * t56 * t481 * t235 * t32 - 0.25115336796353019597335914738290663784003826116781e2 / t251 / t227 * t54 * t56 * t481 * t257 * t32 + 0.20029022722162365848204920963990480075752373895984e-1 * t230 * t472 * t329 * t2 * t235 - 0.89697631415546498561913981208180942085727950417076e0 * t254 * t472 * t329 * t2 * t257 + 0.64272053155397178166610502978456596616246611440970e3 / t555 * t54 * t56 * t481 / t256 / t234 * t32 + 0.90036293170409445924013398845317648817403718496958e-3 * t290 / t565 * t178 * t50
  t615 = -0.11e2 / 0.216e3 * t345 - t349 / 0.24e2 - t133 * t43 * t33 * t34 * t25 * t45 + t134 * t55 * t57 * t60 * t38 / 0.3e1 - 0.2e1 / 0.3e1 * t135 * t34 * t10 * t38 + t135 * t34 * t25 * t67 / 0.2e1 + t474 * t475 * t19 / 0.432e3 - 0.2e1 / 0.3e1 * t140 * t378 + 0.4e1 / 0.9e1 * t141 * t482 - 0.14e2 / 0.27e2 * t147 * t369 - 0.6e1 * t150 * t359 * t361 + 0.6e1 * t151 * t365 - t154 * t388
  t621 = 0.20727133333333333333333333333333333333333333333334e-1 * t74 * t93 + 0.69090444444444444444444444444444444444444444444446e-2 * t87 * t89 * t38 + 0.10363566666666666666666666666666666666666666666667e-1 * t87 * t75 * t67 + 0.18394613361864149606712411343047178787314745838373e1 * t125 * t329 * t127 + 0.69090444444444444444444444444444444444444444444446e-2 * t74 * t90 - 0.23030148148148148148148148148148148148148148148149e-2 * t87 * t337 * t18 - 0.48602578047254941331494803814743396158690158540586e-1 * t101 * t329 * t105 + 0.10363566666666666666666666666666666666666666666667e-1 * (-0.7e1 / 0.27e2 * t345 - t349 / 0.3e1 - t23 * t25 * t43 * t45 / 0.2e1 + t23 * t28 * t67 / 0.4e1 - 0.3e1 / 0.2e1 * t23 * t12 * t359 * t361 + 0.3e1 / 0.2e1 * t23 * t44 * t365 - t23 * t49 * t388 / 0.4e1) * t54 * t73 * t76 - t176 * (t509 + t571) * t315 / 0.24e2 + 0.15906298270010708072125572157552384197389506431465e0 * t102 * t374 * t398 * t105 + 0.96902277115443742137603943210562149050493484994510e-3 * t615 * t157 * t18 + 0.19380455423088748427520788642112429810098696998902e-2 * t158 * t38
  t671 = t121 ** 2
  t681 = t150 ** 2
  t687 = 0.96902277115443742137603943210562149050493484994510e-3 * t172 * t67 - 0.21533839358987498252800876269013810900109663332113e-3 * t169 * t50 + 0.32300759038481247379201314403520716350164494998170e-3 * t156 * t166 * t168 * t30 + 0.32300759038481247379201314403520716350164494998170e-3 * t167 * t38 * t32 * t30 + 0.10766919679493749126400438134506905450054831666057e-3 * t167 * t18 * t53 * t144 - 0.10604198846673805381417048105034922798259670954310e0 * t110 * t57 * t381 * t105 + 0.12371565321119439611653222789207409931302949446695e0 * t116 * t34 * t328 * t105 + 0.26510497116684513453542620262587306995649177385774e-1 / t121 * t54 * t56 * t481 * t105 * t32 - 0.23411326096918008590361250800241863911127858339748e1 / t121 / t97 * t54 * t56 * t481 * t127 * t32 + 0.22092080930570427877952183552156089163040981154812e-2 * t100 * t472 * t329 * t2 * t105 - 0.83611878917564316394147324286578085396885208356242e-1 * t124 * t472 * t329 * t2 * t127 + 0.50631328524251801700246888250186209051365905137714e2 / t671 * t54 * t56 * t481 / t126 / t104 * t32 + 0.40375948798101559224001643004400895437705618747712e-4 * t164 / t681 * t18 * t50
  v3rho3_0_ = 0.31090700000000000000000000000000000000000000000001e-1 * t74 * t76 + 0.10363566666666666666666666666666666666666666666667e-1 * t87 * t90 + 0.31090700000000000000000000000000000000000000000001e-1 * t87 * t93 + 0.39765745675026770180313930393880960493473766078662e-1 * t101 * t11 * t105 + 0.79531491350053540360627860787761920986947532157324e-1 * t110 * t57 * t60 * t105 - 0.15906298270010708072125572157552384197389506431465e0 * t116 * t34 * t10 * t105 - 0.15050138205161576950946518371584055371439337504124e1 * t125 * t11 * t127 + 0.29070683134633122641281182963168644715148045498353e-2 * t158 * t18 + 0.48451138557721871068801971605281074525246742497255e-3 * t169 * t30 + 0.29070683134633122641281182963168644715148045498353e-2 * t172 * t38 - t176 * (t207 * t208 / 0.3e1 + t219 * t220 / 0.9e1 + t219 * t223 / 0.3e1 + 0.12017413633297419508922952578394288045451424337591e0 * t231 * t11 * t235 + 0.24034827266594839017845905156788576090902848675181e0 * t240 * t57 * t60 * t235 - 0.48069654533189678035691810313577152181805697350363e0 * t246 * t34 * t10 * t235 - 0.53818578849327899137148388724908565251436770250246e1 * t255 * t11 * t257 + 0.21608710360898267021763215722876235716176892439270e-1 * t284 * t178 + 0.36014517268163778369605359538127059526961487398783e-2 * t295 * t30 + 0.21608710360898267021763215722876235716176892439270e-1 * t298 * t187) * t315 / 0.8e1 + r0 * (t621 + t687)

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** 2
  t8 = r0 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t12 = 0.1e1 / t8
  t14 = t4 * t6 * t12
  t15 = t14 / 0.4e1
  t16 = jnp.sqrt(t14)
  t18 = t15 + 0.18637200000000000000000000000000000000000000000000e1 * t16 + 0.129352e2
  t19 = 0.1e1 / t18
  t21 = t4 * t11 * t19
  t23 = t16 / 0.2e1
  t24 = t23 + 0.10498e0
  t25 = t18 ** 2
  t26 = 0.1e1 / t25
  t27 = t24 * t26
  t28 = 0.1e1 / t16
  t29 = t28 * t1
  t30 = t27 * t29
  t31 = t3 * t6
  t33 = 0.1e1 / t8 / r0
  t34 = t6 * t33
  t35 = t4 * t34
  t36 = t35 / 0.12e2
  t38 = t29 * t31 * t33
  t40 = -t36 - 0.31062000000000000000000000000000000000000000000000e0 * t38
  t41 = t33 * t40
  t45 = t24 * t19
  t47 = 0.1e1 / t16 / t14
  t48 = t45 * t47
  t49 = t1 ** 2
  t50 = t3 ** 2
  t51 = t49 * t50
  t52 = t8 ** 2
  t54 = 0.1e1 / t52 / t7
  t55 = t5 * t54
  t56 = t51 * t55
  t59 = t45 * t28
  t60 = t4 * t11
  t63 = t24 ** 2
  t65 = 0.1e1 / t25 / t18
  t66 = t63 * t65
  t67 = t40 ** 2
  t70 = t63 * t26
  t71 = t60 / 0.9e1
  t72 = t47 * t49
  t73 = t50 * t5
  t75 = t72 * t73 * t54
  t78 = t29 * t31 * t10
  t80 = t71 - 0.20708000000000000000000000000000000000000000000000e0 * t75 + 0.41416000000000000000000000000000000000000000000000e0 * t78
  t82 = t21 / 0.72e2 + t30 * t31 * t41 / 0.3e1 - t48 * t56 / 0.9e1 + 0.2e1 / 0.9e1 * t59 * t60 + 0.2e1 * t66 * t67 - t70 * t80
  t84 = 0.1e1 / t63 / t24
  t85 = t82 * t84
  t86 = t18 * t28
  t87 = t85 * t86
  t93 = -t59 * t35 / 0.6e1 - t70 * t40
  t94 = t93 * t84
  t95 = t18 * t47
  t96 = t94 * t95
  t99 = t40 * t28
  t100 = t94 * t99
  t103 = t94 * t86
  t107 = t4 * t6
  t108 = t33 * t26
  t112 = t12 * t65
  t116 = t12 * t26
  t122 = 0.1e1 / t3
  t123 = (t21 / 0.9e1 + t107 * t108 * t40 / 0.6e1 + t107 * t112 * t67 / 0.2e1 - t107 * t116 * t80 / 0.4e1) * t49 * t122
  t124 = t5 * t8
  t125 = t124 * t40
  t136 = (-t4 * t34 * t19 / 0.12e2 - t107 * t116 * t40 / 0.4e1) * t49 * t122
  t138 = t5 / t52
  t139 = t138 * t40
  t142 = t124 * t80
  t145 = t16 + 0.372744e1
  t146 = t145 ** 2
  t147 = t146 ** 2
  t149 = 0.1e1 / t147 / t145
  t150 = t149 * t1
  t151 = t150 * t3
  t152 = t7 * r0
  t154 = 0.1e1 / t8 / t152
  t155 = t6 * t154
  t156 = 0.1e1 / t146
  t158 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t156
  t159 = t158 ** 2
  t160 = 0.1e1 / t159
  t164 = t138 * t18
  t169 = t5 / t52 / r0
  t170 = t169 * t18
  t173 = t146 * t145
  t174 = 0.1e1 / t173
  t175 = t174 * t1
  t177 = 0.1e1 / t158
  t182 = t4 * t155 * t19
  t184 = t10 * t26
  t186 = t107 * t184 * t40
  t188 = t33 * t65
  t195 = t25 ** 2
  t196 = 0.1e1 / t195
  t197 = t12 * t196
  t198 = t67 * t40
  t202 = t40 * t80
  t206 = t4 * t155
  t207 = 0.7e1 / 0.27e2 * t206
  t211 = 0.1e1 / t16 / t51 / t138 / 0.4e1
  t212 = t211 * t2
  t213 = t7 ** 2
  t214 = 0.1e1 / t213
  t215 = t212 * t214
  t218 = 0.1e1 / t52 / t152
  t220 = t72 * t73 * t218
  t223 = t29 * t31 * t154
  t225 = -t207 - 0.12424800000000000000000000000000000000000000000000e1 * t215 + 0.82832000000000000000000000000000000000000000000000e0 * t220 - 0.96637333333333333333333333333333333333333333333333e0 * t223
  t231 = (-0.7e1 / 0.27e2 * t182 - t186 / 0.3e1 - t107 * t188 * t67 / 0.2e1 + t107 * t108 * t80 / 0.4e1 - 0.3e1 / 0.2e1 * t107 * t197 * t198 + 0.3e1 / 0.2e1 * t107 * t112 * t202 - t107 * t116 * t225 / 0.4e1) * t49 * t122
  t232 = t124 * t18
  t236 = t156 * t47 * t49
  t241 = 0.12920303615392498951680525761408286540065797999268e-2 * t87 * t35 + 0.43067678717974996505601752538027621800219326664227e-3 * t96 * t56 + 0.12920303615392498951680525761408286540065797999268e-2 * t100 * t35 - 0.86135357435949993011203505076055243600438653328453e-3 * t103 * t60 + 0.82908533333333333333333333333333333333333333333336e-1 * t123 * t125 + 0.27636177777777777777777777777777777777777777777779e-1 * t136 * t139 + 0.41454266666666666666666666666666666666666666666668e-1 * t136 * t142 + 0.73578453447456598426849645372188715149258983353495e1 * t151 * t155 * t160 + 0.27636177777777777777777777777777777777777777777779e-1 * t123 * t164 - 0.92120592592592592592592592592592592592592592592596e-2 * t136 * t170 - 0.19441031218901976532597921525897358463476063416235e0 * t175 * t3 * t155 * t177 + 0.41454266666666666666666666666666666666666666666668e-1 * t231 * t232 - 0.42416795386695221525668192420139691193038683817240e0 * t236 * t73 * t218 * t177
  t243 = t156 * t28 * t1
  t248 = 0.1e1 / t147
  t249 = t248 * t49
  t250 = t249 * t50
  t251 = t5 * t218
  t252 = t177 * t28
  t257 = 0.1e1 / t147 / t146
  t258 = t257 * t49
  t259 = t258 * t50
  t260 = t160 * t28
  t264 = 0.1e1 / t50
  t265 = t175 * t264
  t266 = t2 * t177
  t270 = t150 * t264
  t271 = t2 * t160
  t275 = t147 ** 2
  t276 = 0.1e1 / t275
  t277 = t276 * t49
  t278 = t277 * t50
  t280 = 0.1e1 / t159 / t158
  t281 = t280 * t28
  t285 = t63 ** 2
  t286 = 0.1e1 / t285
  t287 = t93 * t286
  t288 = t287 * t18
  t291 = jnp.pi ** 2
  t292 = 0.1e1 / t291
  t293 = t16 + 0.106835e1
  t294 = t293 ** 2
  t295 = 0.1e1 / t294
  t296 = t295 * t211
  t297 = t2 * t214
  t299 = 0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t295
  t300 = 0.1e1 / t299
  t304 = t294 ** 2
  t306 = 0.1e1 / t304 / t293
  t307 = t306 * t1
  t309 = t299 ** 2
  t310 = 0.1e1 / t309
  t315 = t15 + 0.53417500000000000000000000000000000000000000000000e0 * t16 + 0.114813e2
  t316 = 0.1e1 / t315
  t320 = t315 ** 2
  t321 = 0.1e1 / t320
  t322 = t12 * t321
  t324 = -t36 - 0.89029166666666666666666666666666666666666666666667e-1 * t38
  t330 = (-t4 * t34 * t316 / 0.12e2 - t107 * t322 * t324 / 0.4e1) * t49 * t122
  t333 = t71 - 0.59352777777777777777777777777777777777777777777778e-1 * t75 + 0.11870555555555555555555555555555555555555555555556e0 * t78
  t334 = t124 * t333
  t338 = t4 * t11 * t316
  t340 = t33 * t321
  t345 = 0.1e1 / t320 / t315
  t346 = t12 * t345
  t347 = t324 ** 2
  t356 = (t338 / 0.9e1 + t107 * t340 * t324 / 0.6e1 + t107 * t346 * t347 / 0.2e1 - t107 * t322 * t333 / 0.4e1) * t49 * t122
  t357 = t124 * t324
  t360 = t138 * t324
  t364 = t4 * t155 * t316
  t366 = t10 * t321
  t368 = t107 * t366 * t324
  t370 = t33 * t345
  t377 = t320 ** 2
  t378 = 0.1e1 / t377
  t379 = t12 * t378
  t380 = t347 * t324
  t384 = t324 * t333
  t391 = -t207 - 0.35611666666666666666666666666666666666666666666667e0 * t215 + 0.23741111111111111111111111111111111111111111111111e0 * t220 - 0.27697962962962962962962962962962962962962962962964e0 * t223
  t397 = (-0.7e1 / 0.27e2 * t364 - t368 / 0.3e1 - t107 * t370 * t347 / 0.2e1 + t107 * t340 * t333 / 0.4e1 - 0.3e1 / 0.2e1 * t107 * t379 * t380 + 0.3e1 / 0.2e1 * t107 * t346 * t384 - t107 * t322 * t391 / 0.4e1) * t49 * t122
  t398 = t124 * t315
  t401 = t23 + 0.228344e0
  t402 = t401 * t316
  t403 = t402 * t28
  t406 = t401 ** 2
  t407 = t406 * t321
  t409 = -t403 * t35 / 0.6e1 - t407 * t324
  t411 = 0.1e1 / t406 / t401
  t412 = t409 * t411
  t413 = t315 * t28
  t414 = t412 * t413
  t419 = t401 * t345
  t420 = t419 * t29
  t424 = t401 * t321
  t425 = t424 * t72
  t430 = t424 * t29
  t440 = t1 * t264 * t6
  t441 = t154 * t2
  t447 = t402 * t47
  t448 = t51 * t251
  t453 = t406 * t378
  t456 = t406 * t345
  t460 = -0.11e2 / 0.216e3 * t364 - t368 / 0.24e2 - t420 * t31 * t33 * t347 + t425 * t73 * t54 * t324 / 0.3e1 - 0.2e1 / 0.3e1 * t430 * t31 * t10 * t324 + t430 * t31 * t33 * t333 / 0.2e1 + t440 * t441 * t316 / 0.432e3 - 0.2e1 / 0.3e1 * t402 * t215 + 0.4e1 / 0.9e1 * t447 * t448 - 0.14e2 / 0.27e2 * t403 * t206 - 0.6e1 * t453 * t380 + 0.6e1 * t456 * t384 - t407 * t391
  t461 = 0.1e1 / t406
  t462 = t460 * t461
  t466 = t33 * t324
  t477 = t338 / 0.72e2 + t430 * t31 * t466 / 0.3e1 - t447 * t56 / 0.9e1 + 0.2e1 / 0.9e1 * t403 * t60 + 0.2e1 * t456 * t347 - t407 * t333
  t478 = t477 * t461
  t481 = t409 * t461
  t485 = t295 * t47 * t49
  t491 = t295 * t28 * t1
  t496 = 0.14420896359956903410707543094073145654541709205109e1 * t296 * t297 * t300 + 0.19733478911420229683621075865799807258860149091757e2 * t307 * t3 * t155 * t310 + t330 * t334 / 0.3e1 + 0.2e1 / 0.3e1 * t356 * t357 + 0.2e1 / 0.9e1 * t330 * t360 + t397 * t398 / 0.3e1 - 0.48019356357551704492807146050836079369281983198377e-2 * t414 * t60 + 0.21608710360898267021763215722876235716176892439270e-1 * t462 * t315 + 0.43217420721796534043526431445752471432353784878540e-1 * t478 * t324 + 0.21608710360898267021763215722876235716176892439270e-1 * t481 * t333 - 0.96139309066379356071383620627154304363611394700724e0 * t485 * t73 * t218 * t300 + 0.11216252724410924874994755739834668842421329381751e1 * t491 * t31 * t154 * t300
  t497 = t477 * t411
  t498 = t497 * t413
  t501 = t324 * t28
  t502 = t412 * t501
  t505 = t315 * t47
  t506 = t412 * t505
  t509 = t138 * t315
  t512 = t169 * t315
  t515 = t294 * t293
  t516 = 0.1e1 / t515
  t517 = t516 * t1
  t522 = 0.1e1 / t304
  t523 = t522 * t49
  t524 = t523 * t50
  t525 = t300 * t28
  t530 = 0.1e1 / t304 / t294
  t531 = t530 * t49
  t532 = t531 * t50
  t533 = t310 * t28
  t537 = t517 * t264
  t538 = t2 * t300
  t542 = t307 * t264
  t543 = t2 * t310
  t547 = t304 ** 2
  t548 = 0.1e1 / t547
  t549 = t548 * t49
  t550 = t549 * t50
  t552 = 0.1e1 / t309 / t299
  t553 = t552 * t28
  t557 = t406 ** 2
  t558 = 0.1e1 / t557
  t559 = t409 * t558
  t560 = t559 * t315
  t563 = 0.72029034536327556739210719076254119053922974797566e-2 * t498 * t35 + 0.72029034536327556739210719076254119053922974797566e-2 * t502 * t35 + 0.24009678178775852246403573025418039684640991599189e-2 * t506 * t56 + 0.2e1 / 0.9e1 * t356 * t509 - 0.2e1 / 0.27e2 * t330 * t512 - 0.44063849988757204866050826120779056166655222571167e0 * t517 * t3 * t155 * t300 + 0.24034827266594839017845905156788576090902848675182e0 * t524 * t251 * t525 - 0.25115336796353019597335914738290663784003826116781e2 * t532 * t251 * t533 + 0.20029022722162365848204920963990480075752373895984e-1 * t537 * t155 * t538 - 0.89697631415546498561913981208180942085727950417076e0 * t542 * t155 * t543 + 0.64272053155397178166610502978456596616246611440970e3 * t550 * t251 * t553 + 0.90036293170409445924013398845317648817403718496958e-3 * t560 * t60
  t567 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t569 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t567 * f.p.zeta_threshold, 1)
  t572 = 2 ** (0.1e1 / 0.3e1)
  t573 = t572 - 0.1e1
  t578 = 0.9e1 * t569 - 0.9e1
  t581 = t156 * t211
  t587 = t24 * t65
  t588 = t587 * t29
  t592 = t27 * t72
  t614 = t63 * t196
  t620 = -0.11e2 / 0.216e3 * t182 - t186 / 0.24e2 - t588 * t31 * t33 * t67 + t592 * t73 * t54 * t40 / 0.3e1 - 0.2e1 / 0.3e1 * t30 * t31 * t10 * t40 + t30 * t31 * t33 * t80 / 0.2e1 + t440 * t441 * t19 / 0.432e3 - 0.2e1 / 0.3e1 * t45 * t215 + 0.4e1 / 0.9e1 * t48 * t448 - 0.14e2 / 0.27e2 * t59 * t206 - 0.6e1 * t614 * t198 + 0.6e1 * t66 * t202 - t70 * t225
  t621 = 0.1e1 / t63
  t622 = t620 * t621
  t636 = t264 * t6 * t441
  t639 = t122 * t5
  t642 = 0.1e1 / t52 / t213
  t643 = t642 * t2
  t651 = 0.1e1 / t16 / t2 * r0 / 0.48e2
  t653 = t213 * r0
  t655 = 0.1e1 / t8 / t653
  t656 = t2 * t655
  t688 = t73 * t218 * t28
  t691 = 0.48451138557721871068801971605281074525246742497255e-3 * t94 * t80 * t28 * t35 + 0.32300759038481247379201314403520716350164494998170e-3 * t94 * t40 * t47 * t56 + 0.67293247996835932040002738340668159062842697912856e-5 * t287 * t18 * t1 * t636 - 0.39018876828196680983935418000403106518546430566246e0 * t258 * t639 * t643 * t260 + 0.13255248558342256726771310131293653497824588692887e0 * t156 * t651 * t656 * t177 * t1 * t31 - 0.64601518076962494758402628807041432700328989996340e-3 * t87 * t60 + 0.44184161861140855755904367104312178326081962309624e-2 * t249 * t639 * t643 * t252 + 0.48451138557721871068801971605281074525246742497255e-3 * t620 * t84 * t86 * t35 + 0.96902277115443742137603943210562149050493484994510e-3 * t85 * t99 * t35 + 0.32300759038481247379201314403520716350164494998170e-3 * t85 * t95 * t56 + 0.84385547540419669500411480416977015085609841896189e1 * t277 * t639 * t643 * t281 + 0.53834598397468745632002190672534527250274158330283e-4 * t93 / t285 / t24 * t18 * t49 * t688
  t699 = 0.1e1 / t653
  t740 = t159 ** 2
  t753 = 0.50245625170970829256535377961032225433589214441597e-3 * t103 * t206 - 0.64601518076962494758402628807041432700328989996340e-3 * t100 * t60 - 0.43067678717974996505601752538027621800219326664227e-3 * t96 * t448 - 0.46822652193836017180722501600483727822255716679496e1 * t257 * t2 * t699 * t160 * t47 + 0.53020994233369026907085240525174613991298354771548e-1 * t248 * t2 * t699 * t177 * t47 + 0.10363566666666666666666666666666666666666666666667e-1 * t231 * t164 - 0.69090444444444444444444444444444444444444444444446e-2 * t136 * t169 * t40 + 0.17673664744456342302361746841724871330432784923849e-1 * t149 * t2 * t642 * t177 * t49 * t639 - 0.26755801253620581246127143771704987327003266673998e1 / t147 / t173 * t2 * t642 * t160 * t49 * t639 + 0.12657832131062950425061722062546552262841476284429e3 / t275 / t145 * t2 * t642 * t280 * t49 * t639 - 0.19162434373246948642083122762742588170998040494372e4 / t275 / t173 * t2 * t642 / t740 * t49 * t639 + 0.12112784639430467767200492901320268631311685624314e-3 * t82 * t286 * t18 * t60 + 0.12112784639430467767200492901320268631311685624314e-3 * t287 * t40 * t60
  t756 = 0.1e1 / t8 / t213
  t757 = t6 * t756
  t764 = t5 * t642
  t785 = t4 * t757 * t19
  t789 = t107 * t154 * t26 * t40
  t793 = t107 * t10 * t65 * t67
  t796 = t107 * t184 * t80
  t809 = 0.1e1 / t195 / t18
  t811 = t67 ** 2
  t815 = t67 * t80
  t819 = t80 ** 2
  t823 = t40 * t225
  t827 = t4 * t757
  t828 = 0.70e2 / 0.81e2 * t827
  t829 = t651 * t2
  t831 = t829 * t655 * t107
  t833 = t212 * t699
  t836 = t72 * t73 * t642
  t839 = t29 * t31 * t756
  t841 = t828 - 0.10354000000000000000000000000000000000000000000000e1 * t831 + 0.99398400000000000000000000000000000000000000000000e1 * t833 - 0.36814222222222222222222222222222222222222222222222e1 * t836 + 0.32212444444444444444444444444444444444444444444444e1 * t839
  t845 = 0.70e2 / 0.81e2 * t785 + 0.28e2 / 0.27e2 * t789 + 0.4e1 / 0.3e1 * t793 - 0.2e1 / 0.3e1 * t796 + 0.2e1 * t107 * t33 * t196 * t198 - 0.2e1 * t107 * t188 * t202 + t107 * t108 * t225 / 0.3e1 + 0.6e1 * t107 * t12 * t809 * t811 - 0.9e1 * t107 * t197 * t815 + 0.3e1 / 0.2e1 * t107 * t112 * t819 + 0.2e1 * t107 * t112 * t823 - t107 * t116 * t841 / 0.4e1
  t860 = -0.16200859349084980443831601271581132052896719513529e-1 * t265 * t757 * t266 + 0.61315377872880498689041371143490595957715819461244e0 * t270 * t757 * t271 + 0.17168305804406539632931583920177366868160429449149e2 * t259 * t764 * t260 - 0.37129640917784654580181051383469886637668330434323e3 * t278 * t764 * t281 - 0.41238551070398132038844075964024699771009831488983e0 * t243 * t31 * t756 * t177 - 0.19441031218901976532597921525897358463476063416234e0 * t250 * t764 * t252 + 0.47129772651883579472964658244599656881154093130267e0 * t236 * t73 * t642 * t177 - 0.14804514559303905048800602434946994993825393540828e-3 * t288 * t206 + 0.10363566666666666666666666666666666666666666666667e-1 * t845 * t49 * t122 * t232 - 0.77340987998746992664586274965084728992118817729523e1 * t151 * t757 * t160 + 0.31090700000000000000000000000000000000000000000001e-1 * t123 * t142 + 0.31090700000000000000000000000000000000000000000001e-1 * t231 * t125 + 0.64601518076962494758402628807041432700328989996342e-3 * t94 * t18 * t215
  t923 = 0.10804355180449133510881607861438117858088446219635e-1 * t460 * t411 * t413 * t35 - 0.14405806907265511347842143815250823810784594959513e-1 * t502 * t60 - 0.96038712715103408985614292101672158738563966396755e-2 * t506 * t448 - 0.14405806907265511347842143815250823810784594959513e-1 * t498 * t60 + 0.12017413633297419508922952578394288045451424337591e1 * t295 * t651 * t656 * t300 * t1 * t31 + 0.11204516483428731048321667411861751852832462746288e-1 * t414 * t206 + 0.10712008859232863027768417163076099436041101906828e3 * t549 * t639 * t643 * t553 + 0.12004839089387926123201786512709019842320495799594e-2 * t409 / t557 / t401 * t315 * t49 * t688 + 0.40058045444324731696409841927980960151504747791968e-1 * t523 * t639 * t643 * t525 - 0.41858894660588365995559857897151106306673043527969e1 * t531 * t639 * t643 * t533 + 0.72029034536327556739210719076254119053922974797566e-2 * t412 * t324 * t47 * t56 + 0.15006048861734907654002233140886274802900619749493e-3 * t559 * t315 * t1 * t636
  t934 = t2 * t699
  t963 = t4 * t757 * t316
  t967 = t107 * t154 * t321 * t324
  t971 = t107 * t10 * t345 * t347
  t974 = t107 * t366 * t333
  t987 = 0.1e1 / t377 / t315
  t989 = t347 ** 2
  t993 = t347 * t333
  t997 = t333 ** 2
  t1001 = t324 * t391
  t1009 = t828 - 0.29676388888888888888888888888888888888888888888889e0 * t831 + 0.28489333333333333333333333333333333333333333333334e1 * t833 - 0.10551604938271604938271604938271604938271604938272e1 * t836 + 0.92326543209876543209876543209876543209876543209880e0 * t839
  t1013 = 0.70e2 / 0.81e2 * t963 + 0.28e2 / 0.27e2 * t967 + 0.4e1 / 0.3e1 * t971 - 0.2e1 / 0.3e1 * t974 + 0.2e1 * t107 * t33 * t378 * t380 - 0.2e1 * t107 * t370 * t384 + t107 * t340 * t391 / 0.3e1 + 0.6e1 * t107 * t12 * t987 * t989 - 0.9e1 * t107 * t379 * t993 + 0.3e1 / 0.2e1 * t107 * t346 * t997 + 0.2e1 * t107 * t346 * t1001 - t107 * t322 * t1009 / 0.4e1
  t1021 = 0.72029034536327556739210719076254119053922974797566e-2 * t497 * t505 * t56 + 0.21608710360898267021763215722876235716176892439270e-1 * t497 * t501 * t35 + 0.10804355180449133510881607861438117858088446219635e-1 * t412 * t333 * t28 * t35 - 0.11536717087965522728566034475258516523633367364087e2 * t296 * t934 * t300 + 0.48069654533189678035691810313577152181805697350364e0 * t522 * t2 * t699 * t300 * t47 - 0.50230673592706039194671829476581327568007652233562e2 * t530 * t2 * t699 * t310 * t47 + 0.12854410631079435633322100595691319323249322288194e4 * t548 * t2 * t699 * t552 * t47 + 0.18526846018000188409589551891691194070070945853786e1 * t516 * t756 * t300 * t107 - 0.82970309059380511169770432617567371429298354135795e2 * t306 * t756 * t310 * t107 + t356 * t334 + t1013 * t49 * t122 * t398 / 0.3e1 + t397 * t357 + 0.64826131082694801065289647168628707148530677317810e-1 * t462 * t324
  t1033 = t655 * t1 * t31
  t1070 = -0.4e1 / 0.3e1 * t430 * t31 * t10 * t333 + 0.2e1 / 0.3e1 * t430 * t31 * t33 * t391 - 0.5e1 / 0.9e1 * t402 * t829 * t1033 + 0.56e2 / 0.27e2 * t430 * t31 * t154 * t324 + 0.4e1 * t401 * t378 * t29 * t31 * t33 * t380 + 0.8e1 / 0.3e1 * t420 * t31 * t10 * t347 - 0.16e2 / 0.9e1 * t425 * t73 * t218 * t324 - 0.4e1 / 0.3e1 * t419 * t72 * t73 * t54 * t347 + 0.2e1 / 0.3e1 * t425 * t73 * t54 * t333 + 0.16e2 / 0.3e1 * t402 * t833 + 0.185e3 / 0.864e3 * t963 - t440 * t441 * t321 * t324 / 0.108e3
  t1073 = t51 * t764
  t1084 = t756 * t2
  t1101 = 0.140e3 / 0.81e2 * t403 * t827 - 0.160e3 / 0.81e2 * t447 * t1073 - 0.4e1 * t420 * t31 * t466 * t333 - 0.36e2 * t453 * t993 + 0.8e1 * t456 * t1001 - 0.11e2 / 0.648e3 * t440 * t1084 * t316 + t971 / 0.6e1 + 0.8e1 / 0.3e1 * t424 * t211 * t297 * t324 - t974 / 0.12e2 + 0.6e1 * t456 * t997 + 0.24e2 * t406 * t987 * t989 - t407 * t1009 + 0.11e2 / 0.54e2 * t967
  t1134 = 0.21608710360898267021763215722876235716176892439270e-1 * (t1070 + t1101) * t461 * t315 + 0.21608710360898267021763215722876235716176892439270e-1 * t481 * t391 + 0.64826131082694801065289647168628707148530677317810e-1 * t478 * t333 + t330 * t124 * t391 / 0.3e1 + 0.2e1 / 0.3e1 * t356 * t360 - 0.2e1 / 0.9e1 * t330 * t169 * t324 + 0.14405806907265511347842143815250823810784594959513e-1 * t412 * t315 * t215 - 0.2e1 / 0.9e1 * t356 * t512 + 0.10e2 / 0.81e2 * t330 * t55 * t315 + t397 * t509 / 0.3e1 + t330 * t138 * t333 / 0.3e1 - 0.47132838980624597322181035517534837518580848390044e4 * t550 * t764 * t553
  t1161 = t309 ** 2
  t1196 = 0.16023218177729892678563936771192384060601899116788e0 * t306 * t2 * t642 * t300 * t49 * t639 - 0.28703242052974879539812473986617901467432944133464e2 / t304 / t515 * t2 * t642 * t310 * t49 * t639 + 0.16068013288849294541652625744614149154061652860242e4 / t547 / t293 * t2 * t642 * t552 * t49 * t639 - 0.28783485915536592493215570496151025048490758133637e5 / t547 / t515 * t2 * t642 / t1161 * t49 * t639 - 0.17625539995502881946420330448311622466662089028467e1 * t524 * t764 * t525 + 0.42728581807279713809503831389846357494938397644766e1 * t485 * t73 * t642 * t300 - 0.37387509081369749583315852466115562808071097939170e1 * t491 * t31 * t756 * t300 + 0.27010887951122833777204019653595294645221115549088e-2 * t477 * t558 * t315 * t60 + 0.27010887951122833777204019653595294645221115549088e-2 * t559 * t324 * t60 - 0.14687949996252401622016942040259685388885074190388e0 * t537 * t757 * t538 + 0.65778263038067432278736919552666024196200496972522e1 * t542 * t757 * t543 - 0.33013307495816796838804912909949804566381363448884e-2 * t560 * t206 + 0.18417913650658881038046337474746486774936139152306e3 * t532 * t764 * t533
  t1253 = 0.4e1 * t24 * t196 * t29 * t31 * t33 * t198 + 0.8e1 / 0.3e1 * t588 * t31 * t10 * t67 - 0.16e2 / 0.9e1 * t592 * t73 * t218 * t40 + 0.56e2 / 0.27e2 * t30 * t31 * t154 * t40 - 0.4e1 / 0.3e1 * t587 * t72 * t73 * t54 * t67 + 0.2e1 / 0.3e1 * t592 * t73 * t54 * t80 - 0.4e1 / 0.3e1 * t30 * t31 * t10 * t80 + 0.2e1 / 0.3e1 * t30 * t31 * t33 * t225 - 0.5e1 / 0.9e1 * t45 * t829 * t1033 + t793 / 0.6e1 - t796 / 0.12e2 - 0.11e2 / 0.648e3 * t440 * t1084 * t19
  t1284 = 0.8e1 / 0.3e1 * t27 * t211 * t297 * t40 + 0.11e2 / 0.54e2 * t789 - 0.4e1 * t588 * t31 * t41 * t80 - 0.36e2 * t614 * t815 + 0.8e1 * t66 * t823 + 0.16e2 / 0.3e1 * t45 * t833 + 0.185e3 / 0.864e3 * t785 - t70 * t841 + 0.24e2 * t63 * t809 * t811 + 0.6e1 * t66 * t819 - t440 * t441 * t26 * t40 / 0.108e3 - 0.160e3 / 0.81e2 * t48 * t1073 + 0.140e3 / 0.81e2 * t59 * t827
  t1289 = t82 * t621
  t1292 = t93 * t621
  t1297 = 0.20727133333333333333333333333333333333333333333334e-1 * t123 * t139 + 0.20435174860777645787105769785744382475812907568201e0 * t174 * t756 * t177 * t107 + 0.38383580246913580246913580246913580246913580246915e-2 * t136 * t55 * t18 - 0.69090444444444444444444444444444444444444444444446e-2 * t123 * t170 + 0.10363566666666666666666666666666666666666666666667e-1 * t136 * t124 * t225 + 0.10363566666666666666666666666666666666666666666667e-1 * t136 * t138 * t80 - t292 * (t923 + t1021 + t1134 + t1196) * t578 / 0.24e2 - 0.12725038616008566457700457726041907357911605145172e1 * t581 * t934 * t177 + 0.10126265704850360340049377650037241810273181027543e3 * t276 * t2 * t699 * t280 * t47 + 0.96902277115443742137603943210562149050493484994510e-3 * (t1253 + t1284) * t621 * t18 + 0.29070683134633122641281182963168644715148045498353e-2 * t1289 * t80 + 0.96902277115443742137603943210562149050493484994510e-3 * t1292 * t225 + 0.29070683134633122641281182963168644715148045498353e-2 * t622 * t40
  t1305 = 0.49486261284477758446612891156829639725211797786780e0 * t243 * t31 * t154 * t177 + 0.10604198846673805381417048105034922798259670954310e0 * t250 * t251 * t252 - 0.93645304387672034361445003200967455644511433358993e1 * t259 * t251 * t260 + 0.88368323722281711511808734208624356652163924619249e-2 * t265 * t155 * t266 - 0.33444751567025726557658929714631234158754083342496e0 * t270 * t155 * t271 + 0.20252531409700720680098755300074483620546362055085e3 * t278 * t251 * t281 + 0.16150379519240623689600657201760358175082247499085e-3 * t288 * t60 - t292 * (t496 + t563) * t578 / 0.6e1 + 0.63625193080042832288502288630209536789558025725859e0 * t581 * t297 * t177 + 0.38760910846177496855041577284224859620197393997804e-2 * t622 * t18 + r0 * (t691 + t753 + t860 + t1297) + 0.77521821692354993710083154568449719240394787995608e-2 * t1289 * t40 + 0.38760910846177496855041577284224859620197393997804e-2 * t1292 * t80
  v4rho4_0_ = t241 + t1305

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t12 = 0.1e1 / t8
  t13 = t6 * t12
  t14 = t4 * t13
  t15 = t14 / 0.4e1
  t16 = jnp.sqrt(t14)
  t18 = t15 + 0.18637200000000000000000000000000000000000000000000e1 * t16 + 0.129352e2
  t19 = 0.1e1 / t18
  t23 = t4 * t6
  t24 = t18 ** 2
  t25 = 0.1e1 / t24
  t26 = t12 * t25
  t27 = t4 * t11
  t28 = t27 / 0.12e2
  t29 = 0.1e1 / t16
  t30 = t29 * t1
  t31 = t3 * t6
  t33 = t30 * t31 * t10
  t35 = -t28 - 0.31062000000000000000000000000000000000000000000000e0 * t33
  t40 = t1 ** 2
  t42 = 0.1e1 / t3
  t43 = (-t4 * t11 * t19 / 0.12e2 - t23 * t26 * t35 / 0.4e1) * t40 * t42
  t44 = t5 * t8
  t45 = t44 * t18
  t46 = t43 * t45
  t47 = 0.20727133333333333333333333333333333333333333333334e-1 * t46
  t48 = t16 + 0.372744e1
  t49 = t48 ** 2
  t50 = 0.1e1 / t49
  t52 = t50 * t29 * t1
  t54 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t50
  t55 = 0.1e1 / t54
  t58 = t52 * t31 * t10 * t55
  t59 = 0.79531491350053540360627860787761920986947532157324e-1 * t58
  t60 = t16 / 0.2e1
  t61 = t60 + 0.10498e0
  t62 = t61 * t19
  t63 = t62 * t29
  t66 = t61 ** 2
  t67 = t66 * t25
  t69 = -t63 * t27 / 0.6e1 - t67 * t35
  t70 = 0.1e1 / t66
  t71 = t69 * t70
  t72 = t71 * t18
  t73 = 0.19380455423088748427520788642112429810098696998902e-2 * t72
  t74 = jnp.pi ** 2
  t75 = 0.1e1 / t74
  t77 = t15 + 0.53417500000000000000000000000000000000000000000000e0 * t16 + 0.114813e2
  t78 = 0.1e1 / t77
  t82 = t77 ** 2
  t83 = 0.1e1 / t82
  t84 = t12 * t83
  t86 = -t28 - 0.89029166666666666666666666666666666666666666666667e-1 * t33
  t92 = (-t4 * t11 * t78 / 0.12e2 - t23 * t84 * t86 / 0.4e1) * t40 * t42
  t93 = t44 * t77
  t96 = t16 + 0.106835e1
  t97 = t96 ** 2
  t98 = 0.1e1 / t97
  t100 = t98 * t29 * t1
  t102 = 0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t98
  t103 = 0.1e1 / t102
  t108 = t60 + 0.228344e0
  t109 = t108 * t78
  t110 = t109 * t29
  t113 = t108 ** 2
  t114 = t113 * t83
  t116 = -t110 * t27 / 0.6e1 - t114 * t86
  t117 = 0.1e1 / t113
  t118 = t116 * t117
  t122 = t75 * (t92 * t93 / 0.3e1 + 0.36052240899892258526768857735182864136354273012772e0 * t100 * t31 * t10 * t103 + 0.21608710360898267021763215722876235716176892439270e-1 * t118 * t77)
  t123 = r0 - r1
  t124 = 0.1e1 / t7
  t125 = t123 * t124
  t126 = 0.1e1 + t125
  t127 = t126 <= f.p.zeta_threshold
  t128 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t129 = t128 * f.p.zeta_threshold
  t130 = t126 ** (0.1e1 / 0.3e1)
  t132 = f.my_piecewise3(t127, t129, t130 * t126)
  t133 = 0.1e1 - t125
  t134 = t133 <= f.p.zeta_threshold
  t135 = t133 ** (0.1e1 / 0.3e1)
  t137 = f.my_piecewise3(t134, t129, t135 * t133)
  t138 = t132 + t137 - 0.2e1
  t139 = t122 * t138
  t140 = 2 ** (0.1e1 / 0.3e1)
  t141 = t140 - 0.1e1
  t143 = 0.1e1 / t141 / 0.2e1
  t144 = t123 ** 2
  t145 = t144 ** 2
  t146 = t7 ** 2
  t147 = t146 ** 2
  t148 = 0.1e1 / t147
  t152 = 0.9e1 * t141
  t153 = t143 * (-t145 * t148 + 0.1e1) * t152
  t155 = t139 * t153 / 0.12e2
  t159 = jnp.log(t4 * t13 * t78 / 0.4e1)
  t162 = jnp.arctan(0.66920720466459414830082628492168721398166211679256e1 / t96)
  t165 = jnp.log(t113 * t78)
  t168 = t75 * (t159 + 0.32323836906055067299704130765928097906535029214058e0 * t162 + 0.21608710360898267021763215722876235716176892439270e-1 * t165)
  t169 = 0.1e1 / t146
  t170 = t123 * t169
  t171 = t124 - t170
  t174 = f.my_piecewise3(t127, 0, 0.4e1 / 0.3e1 * t130 * t171)
  t175 = -t171
  t178 = f.my_piecewise3(t134, 0, 0.4e1 / 0.3e1 * t135 * t175)
  t179 = t174 + t178
  t180 = t168 * t179
  t181 = t180 * t153
  t183 = t168 * t138
  t184 = t144 * t123
  t185 = t184 * t148
  t187 = 0.1e1 / t147 / t7
  t188 = t145 * t187
  t192 = t143 * (-0.4e1 * t185 + 0.4e1 * t188) * t152
  t193 = t183 * t192
  t196 = t15 + 0.35302100000000000000000000000000000000000000000000e1 * t16 + 0.180578e2
  t197 = 0.1e1 / t196
  t201 = t196 ** 2
  t202 = 0.1e1 / t201
  t203 = t12 * t202
  t205 = -t28 - 0.58836833333333333333333333333333333333333333333333e0 * t33
  t211 = (-t4 * t11 * t197 / 0.12e2 - t23 * t203 * t205 / 0.4e1) * t40 * t42
  t212 = t44 * t196
  t215 = t16 + 0.706042e1
  t216 = t215 ** 2
  t217 = 0.1e1 / t216
  t219 = t217 * t29 * t1
  t221 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t217
  t222 = 0.1e1 / t221
  t227 = t60 + 0.32500e0
  t228 = t227 * t197
  t229 = t228 * t29
  t232 = t227 ** 2
  t233 = t232 * t202
  t235 = -t229 * t27 / 0.6e1 - t233 * t205
  t236 = 0.1e1 / t232
  t237 = t235 * t236
  t243 = 0.51817833333333333333333333333333333333333333333333e-2 * t211 * t212 + 0.41388824077869423260215065147117773567486474051458e-1 * t219 * t31 * t10 * t222 + 0.22478670955426118383265363956423012380560746650571e-2 * t237 * t196 - 0.10363566666666666666666666666666666666666666666667e-1 * t46 - 0.39765745675026770180313930393880960493473766078662e-1 * t58 - 0.96902277115443742137603943210562149050493484994510e-3 * t72
  t244 = t243 * t138
  t245 = t143 * t145
  t246 = t245 * t148
  t248 = 0.2e1 * t244 * t246
  t252 = jnp.log(t4 * t13 * t197 / 0.4e1)
  t256 = jnp.arctan(0.47309269095601128299619512910246923284397083311420e1 / t215)
  t259 = jnp.log(t232 * t197)
  t264 = jnp.log(t4 * t13 * t19 / 0.4e1)
  t268 = jnp.arctan(0.61519908197590802321728722658814145360143502774884e1 / t48)
  t271 = jnp.log(t66 * t19)
  t273 = 0.1554535e-1 * t252 + 0.52491393169780936217021346072241076933841385384497e-1 * t256 + 0.22478670955426118383265363956423012380560746650571e-2 * t259 - 0.310907e-1 * t264 - 0.38783294878113014394824731224995739188004877421366e-1 * t268 - 0.96902277115443742137603943210562149050493484994510e-3 * t271
  t274 = t273 * t179
  t275 = t274 * t246
  t277 = t273 * t138
  t278 = t143 * t184
  t279 = t278 * t148
  t281 = 0.8e1 * t277 * t279
  t282 = t245 * t187
  t284 = 0.8e1 * t277 * t282
  t286 = 0.1e1 / t8 / t146
  t287 = t6 * t286
  t289 = t4 * t287 * t78
  t296 = 0.1e1 / t82 / t77
  t298 = t86 ** 2
  t302 = t4 * t287
  t303 = t302 / 0.9e1
  t305 = 0.1e1 / t16 / t14
  t307 = t3 ** 2
  t308 = t307 * t5
  t309 = t8 ** 2
  t311 = 0.1e1 / t309 / t146
  t313 = t305 * t40 * t308 * t311
  t316 = t30 * t31 * t286
  t318 = t303 - 0.59352777777777777777777777777777777777777777777778e-1 * t313 + 0.11870555555555555555555555555555555555555555555556e0 * t316
  t328 = t5 / t309
  t352 = t97 ** 2
  t357 = t102 ** 2
  t372 = t40 * t307 * t5 * t311
  t398 = t75 * ((t289 / 0.9e1 + t23 * t10 * t83 * t86 / 0.6e1 + t23 * t12 * t296 * t298 / 0.2e1 - t23 * t84 * t318 / 0.4e1) * t40 * t42 * t93 / 0.3e1 + t92 * t328 * t77 / 0.9e1 + t92 * t44 * t86 / 0.3e1 + 0.12017413633297419508922952578394288045451424337591e0 / t97 / t96 * t1 * t3 * t287 * t103 + 0.24034827266594839017845905156788576090902848675181e0 * t98 * t305 * t40 * t308 * t311 * t103 - 0.48069654533189678035691810313577152181805697350363e0 * t100 * t31 * t286 * t103 - 0.53818578849327899137148388724908565251436770250246e1 / t352 / t96 * t1 * t3 * t287 / t357 + 0.21608710360898267021763215722876235716176892439270e-1 * (t289 / 0.72e2 + t108 * t83 * t30 * t31 * t10 * t86 / 0.3e1 - t109 * t305 * t372 / 0.9e1 + 0.2e1 / 0.9e1 * t110 * t302 + 0.2e1 * t113 * t296 * t298 - t114 * t318) * t117 * t77 + 0.36014517268163778369605359538127059526961487398783e-2 * t116 / t113 / t108 * t77 * t29 * t27 + 0.21608710360898267021763215722876235716176892439270e-1 * t118 * t86) * t138 * t153 / 0.24e2
  t400 = t122 * t179 * t153
  t402 = t139 * t192
  t404 = t130 ** 2
  t405 = 0.1e1 / t404
  t406 = t171 ** 2
  t410 = 0.1e1 / t146 / t7
  t411 = t123 * t410
  t413 = -0.2e1 * t169 + 0.2e1 * t411
  t417 = f.my_piecewise3(t127, 0, 0.4e1 / 0.9e1 * t405 * t406 + 0.4e1 / 0.3e1 * t130 * t413)
  t418 = t135 ** 2
  t419 = 0.1e1 / t418
  t420 = t175 ** 2
  t427 = f.my_piecewise3(t134, 0, 0.4e1 / 0.9e1 * t419 * t420 - 0.4e1 / 0.3e1 * t135 * t413)
  t428 = t417 + t427
  t433 = 0.1e1 / t147 / t146
  t436 = 0.20e2 * t277 * t245 * t433
  t443 = 0.16150379519240623689600657201760358175082247499085e-3 * t69 / t66 / t61 * t18 * t29 * t27
  t449 = 0.26510497116684513453542620262587306995649177385775e-1 * t50 * t305 * t40 * t308 * t311 * t55
  t453 = 0.53020994233369026907085240525174613991298354771549e-1 * t52 * t31 * t286 * t55
  t455 = t4 * t287 * t19
  t469 = 0.1e1 / t24 / t18
  t471 = t35 ** 2
  t476 = t303 - 0.20708000000000000000000000000000000000000000000000e0 * t313 + 0.41416000000000000000000000000000000000000000000000e0 * t316
  t481 = 0.96902277115443742137603943210562149050493484994510e-3 * (t455 / 0.72e2 + t61 * t25 * t30 * t31 * t10 * t35 / 0.3e1 - t62 * t305 * t372 / 0.9e1 + 0.2e1 / 0.9e1 * t63 * t302 + 0.2e1 * t66 * t469 * t471 - t67 * t476) * t70 * t18
  t483 = 0.96902277115443742137603943210562149050493484994510e-3 * t71 * t35
  t485 = 0.8e1 * t244 * t279
  t487 = 0.8e1 * t244 * t282
  t489 = t4 * t287 * t197
  t496 = 0.1e1 / t201 / t196
  t498 = t205 ** 2
  t504 = t303 - 0.39224555555555555555555555555555555555555555555555e0 * t313 + 0.78449111111111111111111111111111111111111111111110e0 * t316
  t536 = t216 ** 2
  t541 = t221 ** 2
  t591 = 0.10363566666666666666666666666666666666666666666667e-1 * (t455 / 0.9e1 + t23 * t10 * t25 * t35 / 0.6e1 + t23 * t12 * t469 * t471 / 0.2e1 - t23 * t26 * t476 / 0.4e1) * t40 * t42 * t45
  t594 = 0.34545222222222222222222222222222222222222222222223e-2 * t43 * t328 * t18
  t597 = 0.10363566666666666666666666666666666666666666666667e-1 * t43 * t44 * t35
  t604 = 0.13255248558342256726771310131293653497824588692887e-1 / t49 / t48 * t1 * t3 * t287 * t55
  t605 = t49 ** 2
  t610 = t54 ** 2
  t614 = 0.50167127350538589836488394571946851238131125013746e0 / t605 / t48 * t1 * t3 * t287 / t610
  t615 = 0.51817833333333333333333333333333333333333333333333e-2 * (t489 / 0.9e1 + t23 * t10 * t202 * t205 / 0.6e1 + t23 * t12 * t496 * t498 / 0.2e1 - t23 * t203 * t504 / 0.4e1) * t40 * t42 * t212 + 0.17272611111111111111111111111111111111111111111111e-2 * t211 * t328 * t196 + 0.51817833333333333333333333333333333333333333333333e-2 * t211 * t44 * t205 + 0.13796274692623141086738355049039257855828824683819e-1 / t216 / t215 * t1 * t3 * t287 * t222 + 0.27592549385246282173476710098078515711657649367639e-1 * t217 * t305 * t40 * t308 * t311 * t222 - 0.55185098770492564346953420196157031423315298735277e-1 * t219 * t31 * t286 * t222 - 0.30878365944746984533884071665444263610784010246137e0 / t536 / t215 * t1 * t3 * t287 / t541 + 0.22478670955426118383265363956423012380560746650571e-2 * (t489 / 0.72e2 + t227 * t202 * t30 * t31 * t10 * t205 / 0.3e1 - t228 * t305 * t372 / 0.9e1 + 0.2e1 / 0.9e1 * t229 * t302 + 0.2e1 * t232 * t496 * t498 - t233 * t504) * t236 * t196 + 0.37464451592376863972108939927371687300934577750952e-3 * t235 / t232 / t227 * t196 * t29 * t27 + 0.22478670955426118383265363956423012380560746650571e-2 * t237 * t205 - t591 - t594 - t597 - t604 - t449 + t453 + t614 - t481 - t443 - t483
  t617 = t615 * t138 * t246
  t618 = -t398 - t400 / 0.12e2 - t402 / 0.12e2 - t168 * t428 * t153 / 0.24e2 + t436 + t443 + t449 - t453 + t481 + t483 + t485 - t487 + t617
  t622 = 0.12e2 * t277 * t143 * t144 * t148
  t625 = 0.32e2 * t277 * t278 * t187
  t626 = t274 * t279
  t628 = t274 * t282
  t631 = t243 * t179 * t246
  t638 = 0.12e2 * t144 * t148
  t640 = 0.32e2 * t184 * t187
  t642 = 0.20e2 * t145 * t433
  t648 = t622 - t625 + 0.8e1 * t626 - 0.8e1 * t628 + 0.2e1 * t631 + t273 * t428 * t246 + t591 + t594 + t597 + t604 - t614 - t180 * t192 / 0.12e2 - t183 * t143 * (-t638 + t640 - t642) * t152 / 0.24e2
  d11 = t47 + t59 + t73 - t155 - t181 / 0.12e2 - t193 / 0.12e2 + t248 + 0.2e1 * t275 + t281 - t284 + t7 * (t618 + t648)
  t653 = -t124 - t170
  t656 = f.my_piecewise3(t127, 0, 0.4e1 / 0.3e1 * t130 * t653)
  t657 = -t653
  t660 = f.my_piecewise3(t134, 0, 0.4e1 / 0.3e1 * t135 * t657)
  t661 = t656 + t660
  t662 = t168 * t661
  t663 = t662 * t153
  t668 = t143 * (0.4e1 * t185 + 0.4e1 * t188) * t152
  t669 = t183 * t668
  t671 = t273 * t661
  t672 = t671 * t246
  t675 = t139 * t668
  t678 = t122 * t661 * t153
  t694 = f.my_piecewise3(t127, 0, 0.4e1 / 0.9e1 * t405 * t653 * t171 + 0.8e1 / 0.3e1 * t130 * t123 * t410)
  t702 = f.my_piecewise3(t134, 0, 0.4e1 / 0.9e1 * t419 * t657 * t175 - 0.8e1 / 0.3e1 * t135 * t123 * t410)
  t703 = t694 + t702
  t709 = t671 * t279
  t711 = t671 * t282
  t716 = t243 * t661 * t246
  t717 = -t662 * t192 / 0.24e2 - t675 / 0.24e2 - t678 / 0.24e2 - t180 * t668 / 0.24e2 - t183 * t143 * (t638 - t642) * t152 / 0.24e2 - t168 * t703 * t153 / 0.24e2 - t398 - t400 / 0.24e2 - t402 / 0.24e2 + 0.4e1 * t709 - 0.4e1 * t711 + t273 * t703 * t246 + t716 + t436 + t443
  t720 = t449 - t453 + t481 + t483 - t487 + t617 - t622 - 0.4e1 * t626 - 0.4e1 * t628 + t631 + t591 + t594 + t597 + t604 - t614
  d12 = t47 + t59 + t73 - t155 - t181 / 0.24e2 - t193 / 0.24e2 + t248 + t275 - t284 - t663 / 0.24e2 - t669 / 0.24e2 + t672 + t7 * (t717 + t720)
  t731 = t653 ** 2
  t735 = 0.2e1 * t169 + 0.2e1 * t411
  t739 = f.my_piecewise3(t127, 0, 0.4e1 / 0.9e1 * t405 * t731 + 0.4e1 / 0.3e1 * t130 * t735)
  t740 = t657 ** 2
  t747 = f.my_piecewise3(t134, 0, 0.4e1 / 0.9e1 * t419 * t740 - 0.4e1 / 0.3e1 * t135 * t735)
  t748 = t739 + t747
  t761 = -t183 * t143 * (-t638 - t640 - t642) * t152 / 0.24e2 - t168 * t748 * t153 / 0.24e2 - t662 * t668 / 0.12e2 - t675 / 0.12e2 - t678 / 0.12e2 - t398 + t273 * t748 * t246 - 0.8e1 * t709 - 0.8e1 * t711 + 0.2e1 * t716 + t436 + t443 + t449
  t762 = -t453 + t481 + t483 - t485 - t487 + t617 + t622 + t625 + t591 + t594 + t597 + t604 - t614
  d22 = t47 + t59 + t73 - t155 - t663 / 0.12e2 - t669 / 0.12e2 + t248 + 0.2e1 * t672 - t281 - t284 + t7 * (t761 + t762)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = jnp.pi ** 2
  t2 = 0.1e1 / t1
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = 0.1e1 / jnp.pi
  t5 = t4 ** (0.1e1 / 0.3e1)
  t6 = t3 * t5
  t7 = 4 ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = r0 + r1
  t10 = t9 ** (0.1e1 / 0.3e1)
  t12 = 0.1e1 / t10 / t9
  t13 = t8 * t12
  t14 = 0.1e1 / t10
  t15 = t8 * t14
  t16 = t6 * t15
  t17 = t16 / 0.4e1
  t18 = jnp.sqrt(t16)
  t20 = t17 + 0.53417500000000000000000000000000000000000000000000e0 * t18 + 0.114813e2
  t21 = 0.1e1 / t20
  t25 = t6 * t8
  t26 = t20 ** 2
  t27 = 0.1e1 / t26
  t28 = t14 * t27
  t29 = t6 * t13
  t30 = t29 / 0.12e2
  t31 = 0.1e1 / t18
  t32 = t31 * t3
  t33 = t5 * t8
  t35 = t32 * t33 * t12
  t37 = -t30 - 0.89029166666666666666666666666666666666666666666667e-1 * t35
  t42 = t3 ** 2
  t44 = 0.1e1 / t5
  t45 = (-t6 * t13 * t21 / 0.12e2 - t25 * t28 * t37 / 0.4e1) * t42 * t44
  t46 = t7 * t10
  t47 = t46 * t20
  t50 = t18 + 0.106835e1
  t51 = t50 ** 2
  t52 = 0.1e1 / t51
  t54 = t52 * t31 * t3
  t56 = 0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t52
  t57 = 0.1e1 / t56
  t62 = t18 / 0.2e1
  t63 = t62 + 0.228344e0
  t64 = t63 * t21
  t65 = t64 * t31
  t68 = t63 ** 2
  t69 = t68 * t27
  t71 = -t65 * t29 / 0.6e1 - t69 * t37
  t72 = 0.1e1 / t68
  t73 = t71 * t72
  t77 = t2 * (t45 * t47 / 0.3e1 + 0.36052240899892258526768857735182864136354273012772e0 * t54 * t33 * t12 * t57 + 0.21608710360898267021763215722876235716176892439270e-1 * t73 * t20)
  t78 = r0 - r1
  t79 = 0.1e1 / t9
  t80 = t78 * t79
  t81 = 0.1e1 + t80
  t82 = t81 <= f.p.zeta_threshold
  t83 = t81 ** (0.1e1 / 0.3e1)
  t84 = t9 ** 2
  t85 = 0.1e1 / t84
  t87 = -t78 * t85 + t79
  t90 = f.my_piecewise3(t82, 0, 0.4e1 / 0.3e1 * t83 * t87)
  t91 = 0.1e1 - t80
  t92 = t91 <= f.p.zeta_threshold
  t93 = t91 ** (0.1e1 / 0.3e1)
  t94 = -t87
  t97 = f.my_piecewise3(t92, 0, 0.4e1 / 0.3e1 * t93 * t94)
  t98 = t90 + t97
  t99 = t77 * t98
  t100 = 2 ** (0.1e1 / 0.3e1)
  t101 = t100 - 0.1e1
  t103 = 0.1e1 / t101 / 0.2e1
  t104 = t78 ** 2
  t105 = t104 ** 2
  t106 = t84 ** 2
  t107 = 0.1e1 / t106
  t111 = 0.9e1 * t101
  t112 = t103 * (-t105 * t107 + 0.1e1) * t111
  t115 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t116 = t115 * f.p.zeta_threshold
  t118 = f.my_piecewise3(t82, t116, t83 * t81)
  t120 = f.my_piecewise3(t92, t116, t93 * t91)
  t121 = t118 + t120 - 0.2e1
  t122 = t77 * t121
  t123 = t104 * t78
  t126 = 0.1e1 / t106 / t9
  t131 = t103 * (0.4e1 * t105 * t126 - 0.4e1 * t123 * t107) * t111
  t137 = jnp.log(t6 * t15 * t21 / 0.4e1)
  t140 = jnp.atan(0.66920720466459414830082628492168721398166211679256e1 / t50)
  t143 = jnp.log(t68 * t21)
  t146 = t2 * (t137 + 0.32323836906055067299704130765928097906535029214058e0 * t140 + 0.21608710360898267021763215722876235716176892439270e-1 * t143)
  t147 = t83 ** 2
  t148 = 0.1e1 / t147
  t149 = t87 ** 2
  t152 = t84 * t9
  t153 = 0.1e1 / t152
  t156 = 0.2e1 * t78 * t153 - 0.2e1 * t85
  t160 = f.my_piecewise3(t82, 0, 0.4e1 / 0.9e1 * t148 * t149 + 0.4e1 / 0.3e1 * t83 * t156)
  t161 = t93 ** 2
  t162 = 0.1e1 / t161
  t163 = t94 ** 2
  t166 = -t156
  t170 = f.my_piecewise3(t92, 0, 0.4e1 / 0.9e1 * t162 * t163 + 0.4e1 / 0.3e1 * t93 * t166)
  t171 = t160 + t170
  t172 = t146 * t171
  t175 = t146 * t98
  t178 = t146 * t121
  t184 = 0.1e1 / t106 / t84
  t189 = t103 * (-0.12e2 * t104 * t107 - 0.20e2 * t105 * t184 + 0.32e2 * t123 * t126) * t111
  t193 = 0.1e1 / t10 / t84
  t194 = t8 * t193
  t196 = t17 + 0.18637200000000000000000000000000000000000000000000e1 * t18 + 0.129352e2
  t197 = 0.1e1 / t196
  t199 = t6 * t194 * t197
  t201 = t62 + 0.10498e0
  t202 = t196 ** 2
  t203 = 0.1e1 / t202
  t204 = t201 * t203
  t205 = t204 * t32
  t207 = -t30 - 0.31062000000000000000000000000000000000000000000000e0 * t35
  t212 = t201 * t197
  t214 = 0.1e1 / t18 / t16
  t215 = t212 * t214
  t216 = t5 ** 2
  t217 = t42 * t216
  t218 = t10 ** 2
  t220 = 0.1e1 / t218 / t84
  t222 = t217 * t7 * t220
  t225 = t212 * t31
  t226 = t6 * t194
  t229 = t201 ** 2
  t231 = 0.1e1 / t202 / t196
  t232 = t229 * t231
  t233 = t207 ** 2
  t236 = t229 * t203
  t237 = t226 / 0.9e1
  t238 = t214 * t42
  t239 = t216 * t7
  t241 = t238 * t239 * t220
  t244 = t32 * t33 * t193
  t246 = t237 - 0.20708000000000000000000000000000000000000000000000e0 * t241 + 0.41416000000000000000000000000000000000000000000000e0 * t244
  t248 = t199 / 0.72e2 + t205 * t33 * t12 * t207 / 0.3e1 - t215 * t222 / 0.9e1 + 0.2e1 / 0.9e1 * t225 * t226 + 0.2e1 * t232 * t233 - t236 * t246
  t249 = 0.1e1 / t229
  t250 = t248 * t249
  t252 = 0.19380455423088748427520788642112429810098696998902e-2 * t250 * t207
  t256 = -t225 * t29 / 0.6e1 - t236 * t207
  t257 = t256 * t249
  t259 = 0.96902277115443742137603943210562149050493484994510e-3 * t257 * t246
  t261 = 0.1e1 / t10 / t152
  t262 = t8 * t261
  t264 = t6 * t262 * t197
  t268 = t25 * t193 * t203 * t207
  t288 = 0.1e1 / t216
  t290 = t3 * t288 * t8
  t291 = t261 * t4
  t296 = t7 / t218
  t300 = 0.1e1 / t18 / t217 / t296 / 0.4e1
  t302 = t300 * t4 * t107
  t306 = 0.1e1 / t218 / t152
  t307 = t7 * t306
  t308 = t217 * t307
  t311 = t6 * t262
  t314 = t202 ** 2
  t315 = 0.1e1 / t314
  t317 = t233 * t207
  t320 = t207 * t246
  t323 = 0.7e1 / 0.27e2 * t311
  t326 = t238 * t239 * t306
  t329 = t32 * t33 * t261
  t331 = -t323 - 0.12424800000000000000000000000000000000000000000000e1 * t302 + 0.82832000000000000000000000000000000000000000000000e0 * t326 - 0.96637333333333333333333333333333333333333333333333e0 * t329
  t333 = -0.11e2 / 0.216e3 * t264 - t268 / 0.24e2 - t201 * t231 * t32 * t33 * t12 * t233 + t204 * t238 * t239 * t220 * t207 / 0.3e1 - 0.2e1 / 0.3e1 * t205 * t33 * t193 * t207 + t205 * t33 * t12 * t246 / 0.2e1 + t290 * t291 * t197 / 0.432e3 - 0.2e1 / 0.3e1 * t212 * t302 + 0.4e1 / 0.9e1 * t215 * t308 - 0.14e2 / 0.27e2 * t225 * t311 - 0.6e1 * t229 * t315 * t317 + 0.6e1 * t232 * t320 - t236 * t331
  t336 = 0.96902277115443742137603943210562149050493484994510e-3 * t333 * t249 * t196
  t338 = t17 + 0.35302100000000000000000000000000000000000000000000e1 * t18 + 0.180578e2
  t339 = 0.1e1 / t338
  t343 = t338 ** 2
  t344 = 0.1e1 / t343
  t345 = t14 * t344
  t347 = -t30 - 0.58836833333333333333333333333333333333333333333333e0 * t35
  t353 = (-t6 * t13 * t339 / 0.12e2 - t25 * t345 * t347 / 0.4e1) * t42 * t44
  t354 = t46 * t338
  t357 = t18 + 0.706042e1
  t358 = t357 ** 2
  t359 = 0.1e1 / t358
  t361 = t359 * t31 * t3
  t363 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t359
  t364 = 0.1e1 / t363
  t369 = t62 + 0.32500e0
  t370 = t369 * t339
  t371 = t370 * t31
  t374 = t369 ** 2
  t375 = t374 * t344
  t377 = -t371 * t29 / 0.6e1 - t375 * t347
  t378 = 0.1e1 / t374
  t379 = t377 * t378
  t385 = t14 * t203
  t391 = (-t6 * t13 * t197 / 0.12e2 - t25 * t385 * t207 / 0.4e1) * t42 * t44
  t392 = t46 * t196
  t395 = t18 + 0.372744e1
  t396 = t395 ** 2
  t397 = 0.1e1 / t396
  t399 = t397 * t31 * t3
  t401 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t397
  t402 = 0.1e1 / t401
  t409 = 0.51817833333333333333333333333333333333333333333333e-2 * t353 * t354 + 0.41388824077869423260215065147117773567486474051458e-1 * t361 * t33 * t12 * t364 + 0.22478670955426118383265363956423012380560746650571e-2 * t379 * t338 - 0.10363566666666666666666666666666666666666666666667e-1 * t391 * t392 - 0.39765745675026770180313930393880960493473766078662e-1 * t399 * t33 * t12 * t402 - 0.96902277115443742137603943210562149050493484994510e-3 * t257 * t196
  t410 = t409 * t121
  t411 = t103 * t105
  t412 = t411 * t184
  t418 = jnp.log(t6 * t15 * t339 / 0.4e1)
  t422 = jnp.atan(0.47309269095601128299619512910246923284397083311420e1 / t357)
  t425 = jnp.log(t374 * t339)
  t430 = jnp.log(t6 * t15 * t197 / 0.4e1)
  t434 = jnp.atan(0.61519908197590802321728722658814145360143502774884e1 / t395)
  t437 = jnp.log(t229 * t197)
  t439 = 0.1554535e-1 * t418 + 0.52491393169780936217021346072241076933841385384497e-1 * t422 + 0.22478670955426118383265363956423012380560746650571e-2 * t425 - 0.310907e-1 * t430 - 0.38783294878113014394824731224995739188004877421366e-1 * t434 - 0.96902277115443742137603943210562149050493484994510e-3 * t437
  t448 = t78 * t107
  t450 = 0.6e1 * t153 - 0.6e1 * t448
  t454 = f.my_piecewise3(t82, 0, -0.8e1 / 0.27e2 / t147 / t81 * t149 * t87 + 0.4e1 / 0.3e1 * t148 * t87 * t156 + 0.4e1 / 0.3e1 * t83 * t450)
  t467 = f.my_piecewise3(t92, 0, -0.8e1 / 0.27e2 / t161 / t91 * t163 * t94 + 0.4e1 / 0.3e1 * t162 * t94 * t166 - 0.4e1 / 0.3e1 * t93 * t450)
  t468 = t454 + t467
  t470 = t411 * t107
  t472 = t103 * t123
  t473 = t472 * t126
  t476 = t103 * t104
  t477 = t476 * t107
  t481 = t6 * t194 * t339
  t483 = t12 * t344
  t488 = 0.1e1 / t343 / t338
  t489 = t14 * t488
  t490 = t347 ** 2
  t496 = t237 - 0.39224555555555555555555555555555555555555555555555e0 * t241 + 0.78449111111111111111111111111111111111111111111110e0 * t244
  t502 = (t481 / 0.9e1 + t25 * t483 * t347 / 0.6e1 + t25 * t489 * t490 / 0.2e1 - t25 * t345 * t496 / 0.4e1) * t42 * t44
  t505 = t296 * t338
  t508 = t46 * t347
  t513 = 0.1e1 / t358 / t357 * t3
  t514 = t513 * t5
  t519 = t359 * t214 * t42
  t528 = t358 ** 2
  t531 = 0.1e1 / t528 / t357 * t3
  t532 = t531 * t5
  t533 = t363 ** 2
  t534 = 0.1e1 / t533
  t539 = t369 * t344
  t540 = t539 * t32
  t545 = t370 * t214
  t550 = t374 * t488
  t554 = t481 / 0.72e2 + t540 * t33 * t12 * t347 / 0.3e1 - t545 * t222 / 0.9e1 + 0.2e1 / 0.9e1 * t371 * t226 + 0.2e1 * t550 * t490 - t375 * t496
  t555 = t554 * t378
  t559 = 0.1e1 / t374 / t369
  t560 = t377 * t559
  t561 = t338 * t31
  t562 = t560 * t561
  t568 = t12 * t203
  t572 = t14 * t231
  t581 = (t199 / 0.9e1 + t25 * t568 * t207 / 0.6e1 + t25 * t572 * t233 / 0.2e1 - t25 * t385 * t246 / 0.4e1) * t42 * t44
  t582 = t581 * t392
  t584 = t296 * t196
  t585 = t391 * t584
  t587 = t46 * t207
  t588 = t391 * t587
  t592 = 0.1e1 / t396 / t395 * t3
  t593 = t592 * t5
  t595 = t593 * t194 * t402
  t598 = t397 * t214 * t42
  t601 = t598 * t239 * t220 * t402
  t605 = t399 * t33 * t193 * t402
  t607 = t396 ** 2
  t610 = 0.1e1 / t607 / t395 * t3
  t611 = t610 * t5
  t612 = t401 ** 2
  t613 = 0.1e1 / t612
  t615 = t611 * t194 * t613
  t617 = t250 * t196
  t620 = 0.1e1 / t229 / t201
  t621 = t256 * t620
  t622 = t196 * t31
  t623 = t621 * t622
  t624 = t623 * t29
  t626 = t257 * t207
  t628 = 0.51817833333333333333333333333333333333333333333333e-2 * t502 * t354 + 0.17272611111111111111111111111111111111111111111111e-2 * t353 * t505 + 0.51817833333333333333333333333333333333333333333333e-2 * t353 * t508 + 0.13796274692623141086738355049039257855828824683819e-1 * t514 * t194 * t364 + 0.27592549385246282173476710098078515711657649367639e-1 * t519 * t239 * t220 * t364 - 0.55185098770492564346953420196157031423315298735277e-1 * t361 * t33 * t193 * t364 - 0.30878365944746984533884071665444263610784010246137e0 * t532 * t194 * t534 + 0.22478670955426118383265363956423012380560746650571e-2 * t555 * t338 + 0.37464451592376863972108939927371687300934577750952e-3 * t562 * t29 + 0.22478670955426118383265363956423012380560746650571e-2 * t379 * t347 - 0.10363566666666666666666666666666666666666666666667e-1 * t582 - 0.34545222222222222222222222222222222222222222222223e-2 * t585 - 0.10363566666666666666666666666666666666666666666667e-1 * t588 - 0.13255248558342256726771310131293653497824588692887e-1 * t595 - 0.26510497116684513453542620262587306995649177385775e-1 * t601 + 0.53020994233369026907085240525174613991298354771549e-1 * t605 + 0.50167127350538589836488394571946851238131125013746e0 * t615 - 0.96902277115443742137603943210562149050493484994510e-3 * t617 - 0.16150379519240623689600657201760358175082247499085e-3 * t624 - 0.96902277115443742137603943210562149050493484994510e-3 * t626
  t629 = t628 * t121
  t630 = t472 * t107
  t633 = t411 * t126
  t636 = t439 * t171
  t641 = t439 * t98
  t646 = t439 * t468 * t470 + 0.60e2 * t410 * t412 - 0.96e2 * t410 * t473 + 0.36e2 * t410 * t477 - 0.96e2 * t641 * t473 + 0.36e2 * t641 * t477 + 0.12e2 * t629 * t630 - 0.12e2 * t629 * t633 + 0.12e2 * t636 * t630 - 0.12e2 * t636 * t633 + t252 + t259 + t336
  t648 = t6 * t194 * t21
  t650 = t12 * t27
  t655 = 0.1e1 / t26 / t20
  t656 = t14 * t655
  t657 = t37 ** 2
  t663 = t237 - 0.59352777777777777777777777777777777777777777777778e-1 * t241 + 0.11870555555555555555555555555555555555555555555556e0 * t244
  t669 = (t648 / 0.9e1 + t25 * t650 * t37 / 0.6e1 + t25 * t656 * t657 / 0.2e1 - t25 * t28 * t663 / 0.4e1) * t42 * t44
  t672 = t296 * t20
  t675 = t46 * t37
  t680 = 0.1e1 / t51 / t50 * t3
  t681 = t680 * t5
  t686 = t52 * t214 * t42
  t695 = t51 ** 2
  t698 = 0.1e1 / t695 / t50 * t3
  t699 = t698 * t5
  t700 = t56 ** 2
  t701 = 0.1e1 / t700
  t706 = t63 * t27
  t707 = t706 * t32
  t712 = t64 * t214
  t717 = t68 * t655
  t721 = t648 / 0.72e2 + t707 * t33 * t12 * t37 / 0.3e1 - t712 * t222 / 0.9e1 + 0.2e1 / 0.9e1 * t65 * t226 + 0.2e1 * t717 * t657 - t69 * t663
  t722 = t721 * t72
  t726 = 0.1e1 / t68 / t63
  t727 = t71 * t726
  t728 = t20 * t31
  t729 = t727 * t728
  t735 = t2 * (t669 * t47 / 0.3e1 + t45 * t672 / 0.9e1 + t45 * t675 / 0.3e1 + 0.12017413633297419508922952578394288045451424337591e0 * t681 * t194 * t57 + 0.24034827266594839017845905156788576090902848675181e0 * t686 * t239 * t220 * t57 - 0.48069654533189678035691810313577152181805697350363e0 * t54 * t33 * t193 * t57 - 0.53818578849327899137148388724908565251436770250246e1 * t699 * t194 * t701 + 0.21608710360898267021763215722876235716176892439270e-1 * t722 * t20 + 0.36014517268163778369605359538127059526961487398783e-2 * t729 * t29 + 0.21608710360898267021763215722876235716176892439270e-1 * t73 * t37)
  t739 = t735 * t121
  t757 = 0.1e1 / t106 / t152
  t795 = t6 * t262 * t21
  t799 = t25 * t193 * t27 * t37
  t808 = t26 ** 2
  t809 = 0.1e1 / t808
  t811 = t657 * t37
  t815 = t37 * t663
  t822 = -t323 - 0.35611666666666666666666666666666666666666666666667e0 * t302 + 0.23741111111111111111111111111111111111111111111111e0 * t326 - 0.27697962962962962962962962962962962962962962962964e0 * t329
  t835 = t7 / t218 / t9
  t874 = -0.11e2 / 0.216e3 * t795 - t799 / 0.24e2 - t63 * t655 * t32 * t33 * t12 * t657 + t706 * t238 * t239 * t220 * t37 / 0.3e1 - 0.2e1 / 0.3e1 * t707 * t33 * t193 * t37 + t707 * t33 * t12 * t663 / 0.2e1 + t290 * t291 * t21 / 0.432e3 - 0.2e1 / 0.3e1 * t64 * t302 + 0.4e1 / 0.9e1 * t712 * t308 - 0.14e2 / 0.27e2 * t65 * t311 - 0.6e1 * t68 * t809 * t811 + 0.6e1 * t717 * t815 - t69 * t822
  t878 = 0.72029034536327556739210719076254119053922974797566e-2 * t721 * t726 * t728 * t29 + 0.72029034536327556739210719076254119053922974797566e-2 * t727 * t37 * t31 * t29 + 0.24009678178775852246403573025418039684640991599189e-2 * t727 * t20 * t214 * t222 + 0.19733478911420229683621075865799807258860149091757e2 * t699 * t262 * t701 + t45 * t46 * t663 / 0.3e1 + 0.2e1 / 0.9e1 * t45 * t296 * t37 + 0.11216252724410924874994755739834668842421329381751e1 * t54 * t33 * t261 * t57 - 0.96139309066379356071383620627154304363611394700724e0 * t686 * t239 * t306 * t57 + (-0.7e1 / 0.27e2 * t795 - t799 / 0.3e1 - t25 * t12 * t655 * t657 / 0.2e1 + t25 * t650 * t663 / 0.4e1 - 0.3e1 / 0.2e1 * t25 * t14 * t809 * t811 + 0.3e1 / 0.2e1 * t25 * t656 * t815 - t25 * t28 * t822 / 0.4e1) * t42 * t44 * t47 / 0.3e1 - 0.48019356357551704492807146050836079369281983198377e-2 * t729 * t226 - 0.2e1 / 0.27e2 * t45 * t835 * t20 + 0.21608710360898267021763215722876235716176892439270e-1 * t874 * t72 * t20
  t911 = t695 ** 2
  t921 = t68 ** 2
  t930 = t4 * t107
  t936 = 0.43217420721796534043526431445752471432353784878540e-1 * t722 * t37 + 0.21608710360898267021763215722876235716176892439270e-1 * t73 * t663 - 0.44063849988757204866050826120779056166655222571167e0 * t681 * t262 * t57 + 0.24034827266594839017845905156788576090902848675182e0 / t695 * t42 * t216 * t307 * t57 * t31 - 0.25115336796353019597335914738290663784003826116781e2 / t695 / t51 * t42 * t216 * t307 * t701 * t31 + 0.20029022722162365848204920963990480075752373895984e-1 * t680 * t288 * t262 * t4 * t57 - 0.89697631415546498561913981208180942085727950417076e0 * t698 * t288 * t262 * t4 * t701 + 0.64272053155397178166610502978456596616246611440970e3 / t911 * t42 * t216 * t307 / t700 / t56 * t31 + 0.90036293170409445924013398845317648817403718496958e-3 * t71 / t921 * t20 * t226 + 0.2e1 / 0.9e1 * t669 * t672 + 0.14420896359956903410707543094073145654541709205109e1 * t52 * t300 * t930 * t57 + 0.2e1 / 0.3e1 * t669 * t675
  t970 = 0.10363566666666666666666666666666666666666666666667e-1 * (-0.7e1 / 0.27e2 * t264 - t268 / 0.3e1 - t25 * t12 * t231 * t233 / 0.2e1 + t25 * t568 * t246 / 0.4e1 - 0.3e1 / 0.2e1 * t25 * t14 * t315 * t317 + 0.3e1 / 0.2e1 * t25 * t572 * t320 - t25 * t385 * t331 / 0.4e1) * t42 * t44 * t392
  t973 = 0.48602578047254941331494803814743396158690158540586e-1 * t593 * t262 * t402
  t976 = 0.69090444444444444444444444444444444444444444444446e-2 * t391 * t296 * t207
  t978 = 0.20727133333333333333333333333333333333333333333334e-1 * t581 * t587
  t979 = -t735 * t98 * t112 / 0.8e1 - t739 * t131 / 0.8e1 - t175 * t189 / 0.8e1 - t122 * t189 / 0.8e1 - t77 * t171 * t112 / 0.8e1 - t99 * t131 / 0.4e1 - t178 * t103 * (0.144e3 * t104 * t126 + 0.120e3 * t105 * t757 - 0.240e3 * t123 * t184 - 0.24e2 * t448) * t111 / 0.24e2 - t2 * (t878 + t936) * t121 * t112 / 0.24e2 - t146 * t468 * t112 / 0.24e2 - t172 * t131 / 0.8e1 + t970 - t973 + t976 + t978
  t983 = 0.23030148148148148148148148148148148148148148148149e-2 * t391 * t835 * t196
  t985 = 0.69090444444444444444444444444444444444444444444446e-2 * t581 * t584
  t988 = 0.18394613361864149606712411343047178787314745838373e1 * t611 * t262 * t613
  t991 = 0.10363566666666666666666666666666666666666666666667e-1 * t391 * t46 * t246
  t995 = 0.32300759038481247379201314403520716350164494998170e-3 * t621 * t207 * t31 * t29
  t999 = 0.32300759038481247379201314403520716350164494998170e-3 * t248 * t620 * t622 * t29
  t1003 = 0.10766919679493749126400438134506905450054831666057e-3 * t621 * t196 * t214 * t222
  t1005 = 0.21533839358987498252800876269013810900109663332113e-3 * t623 * t226
  t1009 = 0.12371565321119439611653222789207409931302949446695e0 * t399 * t33 * t261 * t402
  t1013 = 0.10604198846673805381417048105034922798259670954310e0 * t598 * t239 * t306 * t402
  t1020 = 0.26510497116684513453542620262587306995649177385774e-1 / t607 * t42 * t216 * t307 * t402 * t31
  t1028 = 0.23411326096918008590361250800241863911127858339748e1 / t607 / t396 * t42 * t216 * t307 * t613 * t31
  t1033 = 0.22092080930570427877952183552156089163040981154812e-2 * t592 * t288 * t262 * t4 * t402
  t1034 = -t983 + t985 + t988 + t991 + t995 + t999 + t1003 - t1005 + t1009 - t1013 + t1020 - t1028 + t1033
  t1039 = 0.83611878917564316394147324286578085396885208356242e-1 * t610 * t288 * t262 * t4 * t613
  t1040 = t607 ** 2
  t1049 = 0.50631328524251801700246888250186209051365905137714e2 / t1040 * t42 * t216 * t307 / t612 / t401 * t31
  t1050 = t229 ** 2
  t1055 = 0.40375948798101559224001643004400895437705618747712e-4 * t256 / t1050 * t196 * t226
  t1059 = 0.15906298270010708072125572157552384197389506431465e0 * t397 * t300 * t930 * t402
  t1061 = t6 * t262 * t339
  t1065 = t25 * t193 * t344 * t347
  t1094 = t343 ** 2
  t1095 = 0.1e1 / t1094
  t1097 = t490 * t347
  t1100 = t347 * t496
  t1106 = -t323 - 0.23534733333333333333333333333333333333333333333333e1 * t302 + 0.15689822222222222222222222222222222222222222222222e1 * t326 - 0.18304792592592592592592592592592592592592592592592e1 * t329
  t1108 = -0.11e2 / 0.216e3 * t1061 - t1065 / 0.24e2 - t369 * t488 * t32 * t33 * t12 * t490 + t539 * t238 * t239 * t220 * t347 / 0.3e1 - 0.2e1 / 0.3e1 * t540 * t33 * t193 * t347 + t540 * t33 * t12 * t496 / 0.2e1 + t290 * t291 * t339 / 0.432e3 - 0.2e1 / 0.3e1 * t370 * t302 + 0.4e1 / 0.9e1 * t545 * t308 - 0.14e2 / 0.27e2 * t371 * t311 - 0.6e1 * t374 * t1095 * t1097 + 0.6e1 * t550 * t1100 - t375 * t1106
  t1133 = 0.22478670955426118383265363956423012380560746650571e-2 * t1108 * t378 * t338 + 0.44957341910852236766530727912846024761121493301142e-2 * t555 * t347 + 0.22478670955426118383265363956423012380560746650571e-2 * t379 * t496 - t252 - t259 - t336 + 0.10363566666666666666666666666666666666666666666667e-1 * t502 * t508 + 0.34545222222222222222222222222222222222222222222222e-2 * t353 * t296 * t347 + 0.51817833333333333333333333333333333333333333333333e-2 * t353 * t46 * t496 + 0.11322067513073894329090826277329563323954137090250e1 * t532 * t262 * t534 - 0.11515074074074074074074074074074074074074074074074e-2 * t353 * t835 * t338 - 0.50586340539618183984707301846477278804705690507337e-1 * t514 * t262 * t364
  t1166 = 0.34545222222222222222222222222222222222222222222222e-2 * t502 * t505 + 0.51817833333333333333333333333333333333333333333333e-2 * (-0.7e1 / 0.27e2 * t1061 - t1065 / 0.3e1 - t25 * t12 * t488 * t490 / 0.2e1 + t25 * t483 * t496 / 0.4e1 - 0.3e1 / 0.2e1 * t25 * t14 * t1095 * t1097 + 0.3e1 / 0.2e1 * t25 * t489 * t1100 - t25 * t345 * t1106 / 0.4e1) * t42 * t44 * t354 - t970 + t973 - t976 - t978 + t983 - t985 - t988 - t991 - 0.49952602123169151962811919903162249734579437001269e-3 * t562 * t226 + 0.74928903184753727944217879854743374601869155501904e-3 * t554 * t559 * t561 * t29
  t1176 = t374 ** 2
  t1202 = 0.74928903184753727944217879854743374601869155501904e-3 * t560 * t347 * t31 * t29 + 0.24976301061584575981405959951581124867289718500635e-3 * t560 * t338 * t214 * t222 - t995 - t999 - t1003 + t1005 - t1009 + t1013 + 0.93661128980942159930272349818429218252336444377380e-4 * t377 / t1176 * t338 * t226 + 0.27592549385246282173476710098078515711657649367638e-1 / t528 * t42 * t216 * t307 * t364 * t31 - 0.14409904107548592782479233443873989685032538114864e1 / t528 / t358 * t42 * t216 * t307 * t534 * t31 + 0.22993791154371901811230591748398763093048041139699e-2 * t513 * t288 * t262 * t4 * t364
  t1208 = t528 ** 2
  t1230 = -0.51463943241244974223140119442407106017973350410227e-1 * t531 * t288 * t262 * t4 * t534 + 0.18429583437767336287475605998441200095133403022660e2 / t1208 * t42 * t216 * t307 / t533 / t363 * t31 - 0.11037019754098512869390684039231406284663059747056e0 * t519 * t239 * t306 * t364 + 0.12876523046448265014289131379103307332106903038231e0 * t361 * t33 * t261 * t364 - t1020 + t1028 - t1033 + t1039 - t1049 - t1055 - t1059 + 0.16555529631147769304086026058847109426994589620583e0 * t359 * t300 * t930 * t364
  t1235 = t409 * t98
  t1244 = t439 * t121
  t1262 = -t1039 + t1049 + t1055 + t1059 + (t1133 + t1166 + t1202 + t1230) * t121 * t470 + 0.24e2 * t1235 * t630 + 0.3e1 * t628 * t98 * t470 + 0.3e1 * t409 * t171 * t470 + 0.24e2 * t1244 * t103 * t78 * t107 - 0.144e3 * t1244 * t476 * t126 + 0.240e3 * t1244 * t472 * t184 - 0.120e3 * t1244 * t411 * t757 + 0.60e2 * t641 * t412 - 0.24e2 * t1235 * t633
  t1275 = -t99 * t112 / 0.4e1 - t122 * t131 / 0.4e1 - t172 * t112 / 0.8e1 - t175 * t131 / 0.4e1 - t178 * t189 / 0.8e1 + t9 * (t646 + t979 + t1034 + t1262) + 0.31090700000000000000000000000000000000000000000001e-1 * t582 + 0.10363566666666666666666666666666666666666666666667e-1 * t585 + 0.31090700000000000000000000000000000000000000000001e-1 * t588 + 0.39765745675026770180313930393880960493473766078662e-1 * t595 - 0.15050138205161576950946518371584055371439337504124e1 * t615 - t739 * t112 / 0.8e1 + 0.6e1 * t1235 * t470
  t1299 = 0.3e1 * t636 * t470 + 0.24e2 * t641 * t630 + 0.24e2 * t410 * t630 - 0.24e2 * t641 * t633 + 0.60e2 * t1244 * t412 + 0.3e1 * t629 * t470 + 0.36e2 * t1244 * t477 - 0.96e2 * t1244 * t473 - 0.24e2 * t410 * t633 + 0.29070683134633122641281182963168644715148045498353e-2 * t626 + 0.29070683134633122641281182963168644715148045498353e-2 * t617 + 0.48451138557721871068801971605281074525246742497255e-3 * t624 + 0.79531491350053540360627860787761920986947532157324e-1 * t601 - 0.15906298270010708072125572157552384197389506431465e0 * t605
  d111 = t1275 + t1299

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t12 = 0.1e1 / t8
  t13 = t6 * t12
  t14 = t4 * t13
  t15 = t14 / 0.4e1
  t16 = jnp.sqrt(t14)
  t18 = t15 + 0.35302100000000000000000000000000000000000000000000e1 * t16 + 0.180578e2
  t19 = 0.1e1 / t18
  t23 = t4 * t6
  t24 = t18 ** 2
  t25 = 0.1e1 / t24
  t26 = t12 * t25
  t27 = t4 * t11
  t28 = t27 / 0.12e2
  t29 = 0.1e1 / t16
  t30 = t29 * t1
  t31 = t3 * t6
  t33 = t30 * t31 * t10
  t35 = -t28 - 0.58836833333333333333333333333333333333333333333333e0 * t33
  t40 = t1 ** 2
  t42 = 0.1e1 / t3
  t43 = (-t4 * t11 * t19 / 0.12e2 - t23 * t26 * t35 / 0.4e1) * t40 * t42
  t44 = t5 * t8
  t45 = t44 * t18
  t48 = t16 + 0.706042e1
  t49 = t48 ** 2
  t50 = 0.1e1 / t49
  t52 = t50 * t29 * t1
  t54 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t50
  t55 = 0.1e1 / t54
  t60 = t16 / 0.2e1
  t61 = t60 + 0.32500e0
  t62 = t61 * t19
  t63 = t62 * t29
  t66 = t61 ** 2
  t67 = t66 * t25
  t69 = -t63 * t27 / 0.6e1 - t67 * t35
  t70 = 0.1e1 / t66
  t71 = t69 * t70
  t75 = t15 + 0.18637200000000000000000000000000000000000000000000e1 * t16 + 0.129352e2
  t76 = 0.1e1 / t75
  t80 = t75 ** 2
  t81 = 0.1e1 / t80
  t82 = t12 * t81
  t84 = -t28 - 0.31062000000000000000000000000000000000000000000000e0 * t33
  t90 = (-t4 * t11 * t76 / 0.12e2 - t23 * t82 * t84 / 0.4e1) * t40 * t42
  t91 = t44 * t75
  t94 = t16 + 0.372744e1
  t95 = t94 ** 2
  t96 = 0.1e1 / t95
  t98 = t96 * t29 * t1
  t100 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t96
  t101 = 0.1e1 / t100
  t106 = t60 + 0.10498e0
  t107 = t106 * t76
  t108 = t107 * t29
  t111 = t106 ** 2
  t112 = t111 * t81
  t114 = -t108 * t27 / 0.6e1 - t112 * t84
  t115 = 0.1e1 / t111
  t116 = t114 * t115
  t119 = 0.51817833333333333333333333333333333333333333333333e-2 * t43 * t45 + 0.41388824077869423260215065147117773567486474051458e-1 * t52 * t31 * t10 * t55 + 0.22478670955426118383265363956423012380560746650571e-2 * t71 * t18 - 0.10363566666666666666666666666666666666666666666667e-1 * t90 * t91 - 0.39765745675026770180313930393880960493473766078662e-1 * t98 * t31 * t10 * t101 - 0.96902277115443742137603943210562149050493484994510e-3 * t116 * t75
  t120 = r0 - r1
  t121 = 0.1e1 / t7
  t122 = t120 * t121
  t123 = 0.1e1 + t122
  t124 = t123 <= f.p.zeta_threshold
  t125 = t123 ** (0.1e1 / 0.3e1)
  t126 = t7 ** 2
  t127 = 0.1e1 / t126
  t129 = -t120 * t127 + t121
  t132 = f.my_piecewise3(t124, 0, 0.4e1 / 0.3e1 * t125 * t129)
  t133 = 0.1e1 - t122
  t134 = t133 <= f.p.zeta_threshold
  t135 = t133 ** (0.1e1 / 0.3e1)
  t136 = -t129
  t139 = f.my_piecewise3(t134, 0, 0.4e1 / 0.3e1 * t135 * t136)
  t140 = t132 + t139
  t141 = t119 * t140
  t142 = 2 ** (0.1e1 / 0.3e1)
  t143 = t142 - 0.1e1
  t145 = 0.1e1 / t143 / 0.2e1
  t146 = t120 ** 2
  t147 = t146 ** 2
  t148 = t145 * t147
  t149 = t126 ** 2
  t150 = t149 * t7
  t151 = 0.1e1 / t150
  t152 = t148 * t151
  t155 = t125 ** 2
  t156 = 0.1e1 / t155
  t157 = t129 ** 2
  t160 = t126 * t7
  t161 = 0.1e1 / t160
  t164 = 0.2e1 * t120 * t161 - 0.2e1 * t127
  t168 = f.my_piecewise3(t124, 0, 0.4e1 / 0.9e1 * t156 * t157 + 0.4e1 / 0.3e1 * t125 * t164)
  t169 = t135 ** 2
  t170 = 0.1e1 / t169
  t171 = t136 ** 2
  t174 = -t164
  t178 = f.my_piecewise3(t134, 0, 0.4e1 / 0.9e1 * t170 * t171 + 0.4e1 / 0.3e1 * t135 * t174)
  t179 = t168 + t178
  t180 = t119 * t179
  t181 = 0.1e1 / t149
  t182 = t148 * t181
  t188 = jnp.log(t4 * t13 * t19 / 0.4e1)
  t192 = jnp.atan(0.47309269095601128299619512910246923284397083311420e1 / t48)
  t195 = jnp.log(t66 * t19)
  t200 = jnp.log(t4 * t13 * t76 / 0.4e1)
  t204 = jnp.atan(0.61519908197590802321728722658814145360143502774884e1 / t94)
  t207 = jnp.log(t111 * t76)
  t209 = 0.1554535e-1 * t188 + 0.52491393169780936217021346072241076933841385384497e-1 * t192 + 0.22478670955426118383265363956423012380560746650571e-2 * t195 - 0.310907e-1 * t200 - 0.38783294878113014394824731224995739188004877421366e-1 * t204 - 0.96902277115443742137603943210562149050493484994510e-3 * t207
  t210 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t211 = t210 * f.p.zeta_threshold
  t213 = f.my_piecewise3(t124, t211, t125 * t123)
  t215 = f.my_piecewise3(t134, t211, t135 * t133)
  t216 = t213 + t215 - 0.2e1
  t217 = t209 * t216
  t218 = t145 * t120
  t219 = t218 * t181
  t222 = t145 * t146
  t223 = t222 * t151
  t226 = t119 * t216
  t227 = t146 * t120
  t228 = t145 * t227
  t229 = t228 * t151
  t233 = 0.1e1 / t149 / t126
  t234 = t148 * t233
  t238 = 0.1e1 / t155 / t123
  t242 = t156 * t129
  t245 = t120 * t181
  t247 = 0.6e1 * t161 - 0.6e1 * t245
  t251 = f.my_piecewise3(t124, 0, -0.8e1 / 0.27e2 * t238 * t157 * t129 + 0.4e1 / 0.3e1 * t242 * t164 + 0.4e1 / 0.3e1 * t125 * t247)
  t253 = 0.1e1 / t169 / t133
  t257 = t170 * t136
  t260 = -t247
  t264 = f.my_piecewise3(t134, 0, -0.8e1 / 0.27e2 * t253 * t171 * t136 + 0.4e1 / 0.3e1 * t257 * t174 + 0.4e1 / 0.3e1 * t135 * t260)
  t265 = t251 + t264
  t266 = t209 * t265
  t269 = t209 * t140
  t273 = 0.1e1 / t8 / t126
  t274 = t6 * t273
  t276 = t4 * t274 * t19
  t278 = t10 * t25
  t283 = 0.1e1 / t24 / t18
  t284 = t12 * t283
  t285 = t35 ** 2
  t289 = t4 * t274
  t290 = t289 / 0.9e1
  t292 = 0.1e1 / t16 / t14
  t293 = t292 * t40
  t294 = t3 ** 2
  t295 = t294 * t5
  t296 = t8 ** 2
  t298 = 0.1e1 / t296 / t126
  t300 = t293 * t295 * t298
  t303 = t30 * t31 * t273
  t305 = t290 - 0.39224555555555555555555555555555555555555555555555e0 * t300 + 0.78449111111111111111111111111111111111111111111110e0 * t303
  t311 = (t276 / 0.9e1 + t23 * t278 * t35 / 0.6e1 + t23 * t284 * t285 / 0.2e1 - t23 * t26 * t305 / 0.4e1) * t40 * t42
  t315 = t5 / t296
  t316 = t315 * t18
  t319 = t44 * t35
  t322 = t49 * t48
  t323 = 0.1e1 / t322
  t324 = t323 * t1
  t325 = t324 * t3
  t330 = t50 * t292 * t40
  t339 = t49 ** 2
  t341 = 0.1e1 / t339 / t48
  t342 = t341 * t1
  t343 = t342 * t3
  t344 = t54 ** 2
  t345 = 0.1e1 / t344
  t350 = t61 * t25
  t351 = t350 * t30
  t352 = t10 * t35
  t356 = t62 * t292
  t357 = t40 * t294
  t358 = t5 * t298
  t359 = t357 * t358
  t364 = t66 * t283
  t368 = t276 / 0.72e2 + t351 * t31 * t352 / 0.3e1 - t356 * t359 / 0.9e1 + 0.2e1 / 0.9e1 * t63 * t289 + 0.2e1 * t364 * t285 - t67 * t305
  t369 = t368 * t70
  t373 = 0.1e1 / t66 / t61
  t374 = t69 * t373
  t375 = t18 * t29
  t376 = t374 * t375
  t382 = t4 * t274 * t76
  t384 = t10 * t81
  t389 = 0.1e1 / t80 / t75
  t390 = t12 * t389
  t391 = t84 ** 2
  t397 = t290 - 0.20708000000000000000000000000000000000000000000000e0 * t300 + 0.41416000000000000000000000000000000000000000000000e0 * t303
  t403 = (t382 / 0.9e1 + t23 * t384 * t84 / 0.6e1 + t23 * t390 * t391 / 0.2e1 - t23 * t82 * t397 / 0.4e1) * t40 * t42
  t406 = t315 * t75
  t409 = t44 * t84
  t412 = t95 * t94
  t413 = 0.1e1 / t412
  t414 = t413 * t1
  t415 = t414 * t3
  t420 = t96 * t292 * t40
  t429 = t95 ** 2
  t431 = 0.1e1 / t429 / t94
  t432 = t431 * t1
  t433 = t432 * t3
  t434 = t100 ** 2
  t435 = 0.1e1 / t434
  t440 = t106 * t81
  t441 = t440 * t30
  t442 = t10 * t84
  t446 = t107 * t292
  t451 = t111 * t389
  t455 = t382 / 0.72e2 + t441 * t31 * t442 / 0.3e1 - t446 * t359 / 0.9e1 + 0.2e1 / 0.9e1 * t108 * t289 + 0.2e1 * t451 * t391 - t112 * t397
  t456 = t455 * t115
  t460 = 0.1e1 / t111 / t106
  t461 = t114 * t460
  t462 = t75 * t29
  t463 = t461 * t462
  t468 = 0.51817833333333333333333333333333333333333333333333e-2 * t311 * t45 + 0.17272611111111111111111111111111111111111111111111e-2 * t43 * t316 + 0.51817833333333333333333333333333333333333333333333e-2 * t43 * t319 + 0.13796274692623141086738355049039257855828824683819e-1 * t325 * t274 * t55 + 0.27592549385246282173476710098078515711657649367639e-1 * t330 * t295 * t298 * t55 - 0.55185098770492564346953420196157031423315298735277e-1 * t52 * t31 * t273 * t55 - 0.30878365944746984533884071665444263610784010246137e0 * t343 * t274 * t345 + 0.22478670955426118383265363956423012380560746650571e-2 * t369 * t18 + 0.37464451592376863972108939927371687300934577750952e-3 * t376 * t27 + 0.22478670955426118383265363956423012380560746650571e-2 * t71 * t35 - 0.10363566666666666666666666666666666666666666666667e-1 * t403 * t91 - 0.34545222222222222222222222222222222222222222222223e-2 * t90 * t406 - 0.10363566666666666666666666666666666666666666666667e-1 * t90 * t409 - 0.13255248558342256726771310131293653497824588692887e-1 * t415 * t274 * t101 - 0.26510497116684513453542620262587306995649177385775e-1 * t420 * t295 * t298 * t101 + 0.53020994233369026907085240525174613991298354771549e-1 * t98 * t31 * t273 * t101 + 0.50167127350538589836488394571946851238131125013746e0 * t433 * t274 * t435 - 0.96902277115443742137603943210562149050493484994510e-3 * t456 * t75 - 0.16150379519240623689600657201760358175082247499085e-3 * t463 * t27 - 0.96902277115443742137603943210562149050493484994510e-3 * t116 * t84
  t469 = t468 * t216
  t470 = t228 * t181
  t474 = 0.1e1 / t8 / t160
  t475 = t6 * t474
  t477 = t4 * t475 * t76
  t479 = t273 * t81
  t481 = t23 * t479 * t84
  t483 = t10 * t389
  t490 = t80 ** 2
  t491 = 0.1e1 / t490
  t492 = t12 * t491
  t493 = t391 * t84
  t497 = t84 * t397
  t501 = t4 * t475
  t502 = 0.7e1 / 0.27e2 * t501
  t506 = 0.1e1 / t16 / t357 / t315 / 0.4e1
  t507 = t506 * t2
  t508 = t507 * t181
  t511 = 0.1e1 / t296 / t160
  t513 = t293 * t295 * t511
  t516 = t30 * t31 * t474
  t518 = -t502 - 0.12424800000000000000000000000000000000000000000000e1 * t508 + 0.82832000000000000000000000000000000000000000000000e0 * t513 - 0.96637333333333333333333333333333333333333333333333e0 * t516
  t524 = (-0.7e1 / 0.27e2 * t477 - t481 / 0.3e1 - t23 * t483 * t391 / 0.2e1 + t23 * t384 * t397 / 0.4e1 - 0.3e1 / 0.2e1 * t23 * t492 * t493 + 0.3e1 / 0.2e1 * t23 * t390 * t497 - t23 * t82 * t518 / 0.4e1) * t40 * t42
  t525 = t524 * t91
  t528 = t433 * t475 * t435
  t530 = t315 * t84
  t531 = t90 * t530
  t533 = t44 * t397
  t534 = t90 * t533
  t536 = -0.96e2 * t141 * t152 + 0.12e2 * t180 * t182 + 0.96e2 * t217 * t219 - 0.576e3 * t217 * t223 - 0.384e3 * t226 * t229 + 0.240e3 * t226 * t234 + 0.4e1 * t266 * t182 - 0.384e3 * t269 * t229 + 0.48e2 * t469 * t470 + 0.41454266666666666666666666666666666666666666666668e-1 * t525 + 0.73578453447456598426849645372188715149258983353495e1 * t528 + 0.27636177777777777777777777777777777777777777777779e-1 * t531 + 0.41454266666666666666666666666666666666666666666668e-1 * t534
  t537 = t403 * t409
  t539 = jnp.pi ** 2
  t540 = 0.1e1 / t539
  t542 = t15 + 0.53417500000000000000000000000000000000000000000000e0 * t16 + 0.114813e2
  t543 = 0.1e1 / t542
  t545 = t4 * t274 * t543
  t547 = t542 ** 2
  t548 = 0.1e1 / t547
  t549 = t10 * t548
  t551 = -t28 - 0.89029166666666666666666666666666666666666666666667e-1 * t33
  t556 = 0.1e1 / t547 / t542
  t557 = t12 * t556
  t558 = t551 ** 2
  t562 = t12 * t548
  t565 = t290 - 0.59352777777777777777777777777777777777777777777778e-1 * t300 + 0.11870555555555555555555555555555555555555555555556e0 * t303
  t571 = (t545 / 0.9e1 + t23 * t549 * t551 / 0.6e1 + t23 * t557 * t558 / 0.2e1 - t23 * t562 * t565 / 0.4e1) * t40 * t42
  t572 = t44 * t542
  t583 = (-t4 * t11 * t543 / 0.12e2 - t23 * t562 * t551 / 0.4e1) * t40 * t42
  t584 = t315 * t542
  t587 = t44 * t551
  t590 = t16 + 0.106835e1
  t591 = t590 ** 2
  t592 = t591 * t590
  t594 = 0.1e1 / t592 * t1
  t595 = t594 * t3
  t596 = 0.1e1 / t591
  t598 = 0.1e1 + 0.44783828277500000000000000000000000000000000000000e2 * t596
  t599 = 0.1e1 / t598
  t604 = t596 * t292 * t40
  t610 = t596 * t29 * t1
  t615 = t591 ** 2
  t617 = 0.1e1 / t615 / t590
  t618 = t617 * t1
  t619 = t618 * t3
  t620 = t598 ** 2
  t621 = 0.1e1 / t620
  t626 = t60 + 0.228344e0
  t627 = t626 * t548
  t628 = t627 * t30
  t629 = t10 * t551
  t633 = t626 * t543
  t634 = t633 * t292
  t637 = t633 * t29
  t640 = t626 ** 2
  t641 = t640 * t556
  t644 = t640 * t548
  t646 = t545 / 0.72e2 + t628 * t31 * t629 / 0.3e1 - t634 * t359 / 0.9e1 + 0.2e1 / 0.9e1 * t637 * t289 + 0.2e1 * t641 * t558 - t644 * t565
  t647 = 0.1e1 / t640
  t648 = t646 * t647
  t654 = -t637 * t27 / 0.6e1 - t644 * t551
  t656 = 0.1e1 / t640 / t626
  t657 = t654 * t656
  t658 = t542 * t29
  t659 = t657 * t658
  t662 = t654 * t647
  t666 = t540 * (t571 * t572 / 0.3e1 + t583 * t584 / 0.9e1 + t583 * t587 / 0.3e1 + 0.12017413633297419508922952578394288045451424337591e0 * t595 * t274 * t599 + 0.24034827266594839017845905156788576090902848675181e0 * t604 * t295 * t298 * t599 - 0.48069654533189678035691810313577152181805697350363e0 * t610 * t31 * t273 * t599 - 0.53818578849327899137148388724908565251436770250246e1 * t619 * t274 * t621 + 0.21608710360898267021763215722876235716176892439270e-1 * t648 * t542 + 0.36014517268163778369605359538127059526961487398783e-2 * t659 * t27 + 0.21608710360898267021763215722876235716176892439270e-1 * t662 * t551)
  t667 = t666 * t140
  t671 = 0.9e1 * t143
  t672 = t145 * (-t147 * t181 + 0.1e1) * t671
  t675 = t403 * t406
  t679 = t5 / t296 / t7
  t680 = t679 * t75
  t681 = t90 * t680
  t684 = t415 * t475 * t101
  t686 = t666 * t216
  t692 = t145 * (0.4e1 * t147 * t151 - 0.4e1 * t227 * t181) * t671
  t698 = jnp.log(t4 * t13 * t543 / 0.4e1)
  t701 = jnp.atan(0.66920720466459414830082628492168721398166211679256e1 / t590)
  t704 = jnp.log(t640 * t543)
  t707 = t540 * (t698 + 0.32323836906055067299704130765928097906535029214058e0 * t701 + 0.21608710360898267021763215722876235716176892439270e-1 * t704)
  t708 = t707 * t216
  t715 = 0.1e1 / t149 / t160
  t720 = t145 * (0.144e3 * t146 * t151 + 0.120e3 * t147 * t715 - 0.240e3 * t227 * t233 - 0.24e2 * t245) * t671
  t723 = t44 * t565
  t728 = t315 * t551
  t732 = t4 * t475 * t543
  t734 = t273 * t548
  t736 = t23 * t734 * t551
  t738 = t10 * t556
  t745 = t547 ** 2
  t746 = 0.1e1 / t745
  t747 = t12 * t746
  t748 = t558 * t551
  t752 = t551 * t565
  t759 = -t502 - 0.35611666666666666666666666666666666666666666666667e0 * t508 + 0.23741111111111111111111111111111111111111111111111e0 * t513 - 0.27697962962962962962962962962962962962962962962964e0 * t516
  t765 = (-0.7e1 / 0.27e2 * t732 - t736 / 0.3e1 - t23 * t738 * t558 / 0.2e1 + t23 * t549 * t565 / 0.4e1 - 0.3e1 / 0.2e1 * t23 * t747 * t748 + 0.3e1 / 0.2e1 * t23 * t557 * t752 - t23 * t562 * t759 / 0.4e1) * t40 * t42
  t770 = t551 * t29
  t771 = t657 * t770
  t774 = t542 * t292
  t775 = t657 * t774
  t778 = t640 ** 2
  t779 = 0.1e1 / t778
  t780 = t654 * t779
  t781 = t780 * t542
  t788 = t646 * t656
  t789 = t788 * t658
  t798 = t626 * t556
  t799 = t798 * t30
  t803 = t627 * t293
  t816 = 0.1e1 / t294
  t818 = t1 * t816 * t6
  t819 = t474 * t2
  t825 = t5 * t511
  t826 = t357 * t825
  t831 = t640 * t746
  t837 = -0.11e2 / 0.216e3 * t732 - t736 / 0.24e2 - t799 * t31 * t10 * t558 + t803 * t295 * t298 * t551 / 0.3e1 - 0.2e1 / 0.3e1 * t628 * t31 * t273 * t551 + t628 * t31 * t10 * t565 / 0.2e1 + t818 * t819 * t543 / 0.432e3 - 0.2e1 / 0.3e1 * t633 * t508 + 0.4e1 / 0.9e1 * t634 * t826 - 0.14e2 / 0.27e2 * t637 * t501 - 0.6e1 * t831 * t748 + 0.6e1 * t641 * t752 - t644 * t759
  t838 = t837 * t647
  t841 = t583 * t723 / 0.3e1 + 0.2e1 / 0.3e1 * t571 * t587 + 0.2e1 / 0.9e1 * t583 * t728 + t765 * t572 / 0.3e1 - 0.48019356357551704492807146050836079369281983198377e-2 * t659 * t289 + 0.72029034536327556739210719076254119053922974797566e-2 * t771 * t27 + 0.24009678178775852246403573025418039684640991599189e-2 * t775 * t359 + 0.90036293170409445924013398845317648817403718496958e-3 * t781 * t289 + 0.11216252724410924874994755739834668842421329381751e1 * t610 * t31 * t474 * t599 + 0.72029034536327556739210719076254119053922974797566e-2 * t789 * t27 - 0.96139309066379356071383620627154304363611394700724e0 * t604 * t295 * t511 * t599 + 0.21608710360898267021763215722876235716176892439270e-1 * t838 * t542
  t848 = t679 * t542
  t854 = 0.1e1 / t615
  t855 = t854 * t40
  t856 = t855 * t294
  t857 = t599 * t29
  t862 = 0.1e1 / t615 / t591
  t863 = t862 * t40
  t864 = t863 * t294
  t865 = t621 * t29
  t869 = t594 * t816
  t870 = t2 * t599
  t874 = t618 * t816
  t875 = t2 * t621
  t879 = t615 ** 2
  t880 = 0.1e1 / t879
  t881 = t880 * t40
  t882 = t881 * t294
  t884 = 0.1e1 / t620 / t598
  t885 = t884 * t29
  t892 = t596 * t506
  t893 = t2 * t181
  t897 = 0.43217420721796534043526431445752471432353784878540e-1 * t648 * t551 + 0.21608710360898267021763215722876235716176892439270e-1 * t662 * t565 + 0.2e1 / 0.9e1 * t571 * t584 - 0.2e1 / 0.27e2 * t583 * t848 - 0.44063849988757204866050826120779056166655222571167e0 * t595 * t475 * t599 + 0.24034827266594839017845905156788576090902848675182e0 * t856 * t825 * t857 - 0.25115336796353019597335914738290663784003826116781e2 * t864 * t825 * t865 + 0.20029022722162365848204920963990480075752373895984e-1 * t869 * t475 * t870 - 0.89697631415546498561913981208180942085727950417076e0 * t874 * t475 * t875 + 0.64272053155397178166610502978456596616246611440970e3 * t882 * t825 * t885 + 0.19733478911420229683621075865799807258860149091757e2 * t619 * t475 * t621 + 0.14420896359956903410707543094073145654541709205109e1 * t892 * t893 * t599
  t899 = t540 * (t841 + t897)
  t900 = t899 * t216
  t903 = t707 * t140
  t912 = t145 * (-0.12e2 * t146 * t181 - 0.20e2 * t147 * t233 + 0.32e2 * t227 * t151) * t671
  t924 = t540 * (t583 * t572 / 0.3e1 + 0.36052240899892258526768857735182864136354273012772e0 * t610 * t31 * t10 * t599 + 0.21608710360898267021763215722876235716176892439270e-1 * t662 * t542)
  t925 = t924 * t216
  t928 = t707 * t265
  t931 = t707 * t179
  t934 = t924 * t179
  t937 = t924 * t140
  t939 = 0.82908533333333333333333333333333333333333333333336e-1 * t537 - t667 * t672 / 0.2e1 + 0.27636177777777777777777777777777777777777777777779e-1 * t675 - 0.92120592592592592592592592592592592592592592592596e-2 * t681 - 0.19441031218901976532597921525897358463476063416235e0 * t684 - t686 * t692 / 0.2e1 - t708 * t720 / 0.6e1 - t900 * t672 / 0.6e1 - t903 * t912 / 0.2e1 - t925 * t912 / 0.2e1 - t928 * t672 / 0.6e1 - t931 * t692 / 0.2e1 - t934 * t672 / 0.2e1 - t937 * t692
  t943 = t222 * t181
  t946 = t96 * t506
  t948 = t946 * t893 * t101
  t950 = t228 * t233
  t953 = t148 * t715
  t958 = t455 * t460
  t959 = t958 * t462
  t960 = t959 * t27
  t962 = t84 * t29
  t963 = t461 * t962
  t964 = t963 * t27
  t966 = t463 * t289
  t968 = t75 * t292
  t969 = t461 * t968
  t970 = t969 * t359
  t972 = 0.1e1 / t429
  t973 = t972 * t40
  t974 = t973 * t294
  t975 = t101 * t29
  t977 = t974 * t825 * t975
  t980 = 0.1e1 / t429 / t95
  t981 = t980 * t40
  t982 = t981 * t294
  t983 = t435 * t29
  t985 = t982 * t825 * t983
  t987 = t414 * t816
  t988 = t2 * t101
  t990 = t987 * t475 * t988
  t992 = t432 * t816
  t993 = t2 * t435
  t995 = t992 * t475 * t993
  t997 = -0.48e2 * t469 * t152 + 0.144e3 * t226 * t943 + 0.63625193080042832288502288630209536789558025725859e0 * t948 + 0.960e3 * t217 * t950 - 0.480e3 * t217 * t953 + 0.240e3 * t269 * t234 + 0.12920303615392498951680525761408286540065797999268e-2 * t960 + 0.12920303615392498951680525761408286540065797999268e-2 * t964 - 0.86135357435949993011203505076055243600438653328453e-3 * t966 + 0.43067678717974996505601752538027621800219326664227e-3 * t970 + 0.10604198846673805381417048105034922798259670954310e0 * t977 - 0.93645304387672034361445003200967455644511433358993e1 * t985 + 0.88368323722281711511808734208624356652163924619249e-2 * t990 - 0.33444751567025726557658929714631234158754083342496e0 * t995
  t998 = t429 ** 2
  t999 = 0.1e1 / t998
  t1000 = t999 * t40
  t1001 = t1000 * t294
  t1003 = 0.1e1 / t434 / t100
  t1004 = t1003 * t29
  t1006 = t1001 * t825 * t1004
  t1008 = t111 ** 2
  t1009 = 0.1e1 / t1008
  t1010 = t114 * t1009
  t1011 = t1010 * t75
  t1012 = t1011 * t289
  t1016 = t420 * t295 * t511 * t101
  t1020 = t98 * t31 * t474 * t101
  t1022 = t468 * t140
  t1029 = t106 * t389
  t1030 = t1029 * t30
  t1034 = t440 * t293
  t1056 = t111 * t491
  t1062 = -0.11e2 / 0.216e3 * t477 - t481 / 0.24e2 - t1030 * t31 * t10 * t391 + t1034 * t295 * t298 * t84 / 0.3e1 - 0.2e1 / 0.3e1 * t441 * t31 * t273 * t84 + t441 * t31 * t10 * t397 / 0.2e1 + t818 * t819 * t76 / 0.432e3 - 0.2e1 / 0.3e1 * t107 * t508 + 0.4e1 / 0.9e1 * t446 * t826 - 0.14e2 / 0.27e2 * t108 * t501 - 0.6e1 * t1056 * t493 + 0.6e1 * t451 * t497 - t112 * t518
  t1063 = t1062 * t115
  t1064 = t1063 * t75
  t1066 = t116 * t397
  t1068 = t456 * t84
  t1071 = t4 * t475 * t19
  t1073 = t273 * t25
  t1075 = t23 * t1073 * t35
  t1077 = t10 * t283
  t1084 = t24 ** 2
  t1085 = 0.1e1 / t1084
  t1086 = t12 * t1085
  t1087 = t285 * t35
  t1091 = t35 * t305
  t1098 = -t502 - 0.23534733333333333333333333333333333333333333333333e1 * t508 + 0.15689822222222222222222222222222222222222222222222e1 * t513 - 0.18304792592592592592592592592592592592592592592592e1 * t516
  t1104 = (-0.7e1 / 0.27e2 * t1071 - t1075 / 0.3e1 - t23 * t1077 * t285 / 0.2e1 + t23 * t278 * t305 / 0.4e1 - 0.3e1 / 0.2e1 * t23 * t1086 * t1087 + 0.3e1 / 0.2e1 * t23 * t284 * t1091 - t23 * t26 * t1098 / 0.4e1) * t40 * t42
  t1117 = t315 * t35
  t1123 = 0.51817833333333333333333333333333333333333333333333e-2 * t1104 * t45 - 0.10363566666666666666666666666666666666666666666667e-1 * t525 - 0.18394613361864149606712411343047178787314745838373e1 * t528 - 0.69090444444444444444444444444444444444444444444446e-2 * t531 - 0.10363566666666666666666666666666666666666666666667e-1 * t534 - 0.20727133333333333333333333333333333333333333333334e-1 * t537 - 0.69090444444444444444444444444444444444444444444446e-2 * t675 + 0.23030148148148148148148148148148148148148148148149e-2 * t681 + 0.48602578047254941331494803814743396158690158540586e-1 * t684 + 0.10363566666666666666666666666666666666666666666667e-1 * t311 * t319 + 0.34545222222222222222222222222222222222222222222222e-2 * t43 * t1117 + 0.11322067513073894329090826277329563323954137090250e1 * t343 * t475 * t345
  t1124 = t44 * t305
  t1129 = t679 * t18
  t1137 = t368 * t373
  t1138 = t1137 * t375
  t1141 = t35 * t29
  t1142 = t374 * t1141
  t1145 = t18 * t292
  t1146 = t374 * t1145
  t1153 = 0.51817833333333333333333333333333333333333333333333e-2 * t43 * t1124 + 0.34545222222222222222222222222222222222222222222222e-2 * t311 * t316 - 0.11515074074074074074074074074074074074074074074074e-2 * t43 * t1129 - 0.50586340539618183984707301846477278804705690507337e-1 * t325 * t475 * t55 - 0.49952602123169151962811919903162249734579437001269e-3 * t376 * t289 + 0.74928903184753727944217879854743374601869155501904e-3 * t1138 * t27 + 0.74928903184753727944217879854743374601869155501904e-3 * t1142 * t27 + 0.24976301061584575981405959951581124867289718500635e-3 * t1146 * t359 - 0.15906298270010708072125572157552384197389506431465e0 * t948 - 0.32300759038481247379201314403520716350164494998170e-3 * t960 - 0.32300759038481247379201314403520716350164494998170e-3 * t964 + 0.21533839358987498252800876269013810900109663332113e-3 * t966
  t1164 = 0.1e1 / t339
  t1165 = t1164 * t40
  t1166 = t1165 * t294
  t1167 = t55 * t29
  t1172 = 0.1e1 / t339 / t49
  t1173 = t1172 * t40
  t1174 = t1173 * t294
  t1175 = t345 * t29
  t1179 = t324 * t816
  t1180 = t2 * t55
  t1184 = t342 * t816
  t1185 = t2 * t345
  t1189 = t339 ** 2
  t1190 = 0.1e1 / t1189
  t1191 = t1190 * t40
  t1192 = t1191 * t294
  t1194 = 0.1e1 / t344 / t54
  t1195 = t1194 * t29
  t1199 = t66 ** 2
  t1200 = 0.1e1 / t1199
  t1201 = t69 * t1200
  t1202 = t1201 * t18
  t1208 = -0.10766919679493749126400438134506905450054831666057e-3 * t970 + 0.12876523046448265014289131379103307332106903038231e0 * t52 * t31 * t474 * t55 - 0.11037019754098512869390684039231406284663059747056e0 * t330 * t295 * t511 * t55 + 0.27592549385246282173476710098078515711657649367638e-1 * t1166 * t825 * t1167 - 0.14409904107548592782479233443873989685032538114864e1 * t1174 * t825 * t1175 + 0.22993791154371901811230591748398763093048041139699e-2 * t1179 * t475 * t1180 - 0.51463943241244974223140119442407106017973350410227e-1 * t1184 * t475 * t1185 + 0.18429583437767336287475605998441200095133403022660e2 * t1192 * t825 * t1195 + 0.93661128980942159930272349818429218252336444377380e-4 * t1202 * t289 - 0.26510497116684513453542620262587306995649177385774e-1 * t977 + 0.23411326096918008590361250800241863911127858339748e1 * t985 - 0.22092080930570427877952183552156089163040981154812e-2 * t990
  t1220 = t61 * t283
  t1221 = t1220 * t30
  t1225 = t350 * t293
  t1247 = t66 * t1085
  t1253 = -0.11e2 / 0.216e3 * t1071 - t1075 / 0.24e2 - t1221 * t31 * t10 * t285 + t1225 * t295 * t298 * t35 / 0.3e1 - 0.2e1 / 0.3e1 * t351 * t31 * t273 * t35 + t351 * t31 * t10 * t305 / 0.2e1 + t818 * t819 * t19 / 0.432e3 - 0.2e1 / 0.3e1 * t62 * t508 + 0.4e1 / 0.9e1 * t356 * t826 - 0.14e2 / 0.27e2 * t63 * t501 - 0.6e1 * t1247 * t1087 + 0.6e1 * t364 * t1091 - t67 * t1098
  t1254 = t1253 * t70
  t1260 = t50 * t506
  t1264 = 0.83611878917564316394147324286578085396885208356242e-1 * t995 - 0.50631328524251801700246888250186209051365905137714e2 * t1006 - 0.40375948798101559224001643004400895437705618747712e-4 * t1012 + 0.10604198846673805381417048105034922798259670954310e0 * t1016 - 0.12371565321119439611653222789207409931302949446695e0 * t1020 + 0.44957341910852236766530727912846024761121493301142e-2 * t369 * t35 + 0.22478670955426118383265363956423012380560746650571e-2 * t71 * t305 + 0.22478670955426118383265363956423012380560746650571e-2 * t1254 * t18 - 0.96902277115443742137603943210562149050493484994510e-3 * t1064 - 0.96902277115443742137603943210562149050493484994510e-3 * t1066 - 0.19380455423088748427520788642112429810098696998902e-2 * t1068 + 0.16555529631147769304086026058847109426994589620583e0 * t1260 * t893 * t55
  t1266 = t1123 + t1153 + t1208 + t1264
  t1267 = t1266 * t216
  t1277 = t149 ** 2
  t1278 = 0.1e1 / t1277
  t1288 = t123 ** 2
  t1291 = t157 ** 2
  t1297 = t164 ** 2
  t1302 = t120 * t151
  t1304 = -0.24e2 * t181 + 0.24e2 * t1302
  t1308 = f.my_piecewise3(t124, 0, 0.40e2 / 0.81e2 / t155 / t1288 * t1291 - 0.16e2 / 0.9e1 * t238 * t157 * t164 + 0.4e1 / 0.3e1 * t156 * t1297 + 0.16e2 / 0.9e1 * t242 * t247 + 0.4e1 / 0.3e1 * t125 * t1304)
  t1309 = t133 ** 2
  t1312 = t171 ** 2
  t1318 = t174 ** 2
  t1327 = f.my_piecewise3(t134, 0, 0.40e2 / 0.81e2 / t169 / t1309 * t1312 - 0.16e2 / 0.9e1 * t253 * t171 * t174 + 0.4e1 / 0.3e1 * t170 * t1318 + 0.16e2 / 0.9e1 * t257 * t260 - 0.4e1 / 0.3e1 * t135 * t1304)
  t1328 = t1308 + t1327
  t1339 = 0.16e2 * t1267 * t470 + 0.4e1 * t119 * t265 * t182 + 0.96e2 * t269 * t219 + 0.72e2 * t469 * t943 + 0.840e3 * t217 * t148 * t1278 + 0.1440e4 * t217 * t222 * t233 - 0.1920e4 * t217 * t228 * t715 + t209 * t1328 * t182 + 0.240e3 * t141 * t234 - t928 * t692 / 0.6e1 - t934 * t692 / 0.2e1 - t900 * t692 / 0.6e1
  t1352 = t209 * t179
  t1360 = t2 * t151
  t1390 = 0.1e1 / t8 / t149
  t1391 = t6 * t1390
  t1402 = -0.11536717087965522728566034475258516523633367364087e2 * t892 * t1360 * t599 + 0.12854410631079435633322100595691319323249322288194e4 * t880 * t2 * t151 * t884 * t292 + 0.48069654533189678035691810313577152181805697350364e0 * t854 * t2 * t151 * t599 * t292 - 0.50230673592706039194671829476581327568007652233562e2 * t862 * t2 * t151 * t621 * t292 + 0.10e2 / 0.81e2 * t583 * t358 * t542 - 0.2e1 / 0.9e1 * t571 * t848 + t765 * t584 / 0.3e1 - 0.2e1 / 0.9e1 * t583 * t679 * t551 + 0.18526846018000188409589551891691194070070945853786e1 * t595 * t1391 * t599 - 0.82970309059380511169770432617567371429298354135795e2 * t619 * t1391 * t621 + 0.14405806907265511347842143815250823810784594959513e-1 * t657 * t542 * t508 + t571 * t723
  t1409 = t4 * t1391 * t543
  t1413 = t23 * t474 * t548 * t551
  t1417 = t23 * t273 * t556 * t558
  t1420 = t23 * t734 * t565
  t1433 = 0.1e1 / t745 / t542
  t1435 = t558 ** 2
  t1439 = t558 * t565
  t1443 = t565 ** 2
  t1447 = t551 * t759
  t1451 = t4 * t1391
  t1452 = 0.70e2 / 0.81e2 * t1451
  t1456 = 0.1e1 / t16 / t2 / t121 / 0.48e2
  t1457 = t1456 * t2
  t1459 = 0.1e1 / t8 / t150
  t1461 = t1457 * t1459 * t23
  t1463 = t507 * t151
  t1466 = 0.1e1 / t296 / t149
  t1468 = t293 * t295 * t1466
  t1471 = t30 * t31 * t1390
  t1473 = t1452 - 0.29676388888888888888888888888888888888888888888889e0 * t1461 + 0.28489333333333333333333333333333333333333333333334e1 * t1463 - 0.10551604938271604938271604938271604938271604938272e1 * t1468 + 0.92326543209876543209876543209876543209876543209880e0 * t1471
  t1477 = 0.70e2 / 0.81e2 * t1409 + 0.28e2 / 0.27e2 * t1413 + 0.4e1 / 0.3e1 * t1417 - 0.2e1 / 0.3e1 * t1420 + 0.2e1 * t23 * t10 * t746 * t748 - 0.2e1 * t23 * t738 * t752 + t23 * t549 * t759 / 0.3e1 + 0.6e1 * t23 * t12 * t1433 * t1435 - 0.9e1 * t23 * t747 * t1439 + 0.3e1 / 0.2e1 * t23 * t557 * t1443 + 0.2e1 * t23 * t557 * t1447 - t23 * t562 * t1473 / 0.4e1
  t1491 = t42 * t5
  t1499 = t620 ** 2
  t1524 = t583 * t315 * t565 / 0.3e1 + 0.2e1 / 0.3e1 * t571 * t728 + t1477 * t40 * t42 * t572 / 0.3e1 + t583 * t44 * t759 / 0.3e1 + t765 * t587 + 0.16068013288849294541652625744614149154061652860242e4 / t879 / t590 * t2 * t1466 * t884 * t40 * t1491 - 0.28783485915536592493215570496151025048490758133637e5 / t879 / t592 * t2 * t1466 / t1499 * t40 * t1491 - 0.14687949996252401622016942040259685388885074190388e0 * t869 * t1391 * t870 + 0.65778263038067432278736919552666024196200496972522e1 * t874 * t1391 * t875 + 0.27010887951122833777204019653595294645221115549088e-2 * t780 * t551 * t289 + 0.27010887951122833777204019653595294645221115549088e-2 * t646 * t779 * t542 * t289 + 0.42728581807279713809503831389846357494938397644766e1 * t604 * t295 * t1466 * t599 - 0.33013307495816796838804912909949804566381363448884e-2 * t781 * t501
  t1526 = t5 * t1466
  t1563 = t1390 * t2
  t1578 = t357 * t1526
  t1583 = 0.185e3 / 0.864e3 * t1409 + 0.16e2 / 0.3e1 * t633 * t1463 + 0.8e1 * t641 * t1447 - 0.36e2 * t831 * t1439 - 0.11e2 / 0.648e3 * t818 * t1563 * t543 + t1417 / 0.6e1 + 0.8e1 / 0.3e1 * t627 * t506 * t893 * t551 - t1420 / 0.12e2 + 0.11e2 / 0.54e2 * t1413 - 0.4e1 * t799 * t31 * t629 * t565 - 0.160e3 / 0.81e2 * t634 * t1578 + 0.140e3 / 0.81e2 * t637 * t1451
  t1608 = t1459 * t1 * t31
  t1634 = -t818 * t819 * t548 * t551 / 0.108e3 + 0.24e2 * t640 * t1433 * t1435 + 0.6e1 * t641 * t1443 - t644 * t1473 + 0.2e1 / 0.3e1 * t803 * t295 * t298 * t565 - 0.4e1 / 0.3e1 * t628 * t31 * t273 * t565 + 0.2e1 / 0.3e1 * t628 * t31 * t10 * t759 - 0.5e1 / 0.9e1 * t633 * t1457 * t1608 - 0.4e1 / 0.3e1 * t798 * t293 * t295 * t298 * t558 + 0.56e2 / 0.27e2 * t628 * t31 * t474 * t551 + 0.4e1 * t626 * t746 * t30 * t31 * t10 * t748 + 0.8e1 / 0.3e1 * t799 * t31 * t273 * t558 - 0.16e2 / 0.9e1 * t803 * t295 * t511 * t551
  t1650 = -0.47132838980624597322181035517534837518580848390044e4 * t882 * t1526 * t885 - 0.37387509081369749583315852466115562808071097939170e1 * t610 * t31 * t1390 * t599 - 0.17625539995502881946420330448311622466662089028467e1 * t856 * t1526 * t857 + 0.18417913650658881038046337474746486774936139152306e3 * t864 * t1526 * t865 + 0.16023218177729892678563936771192384060601899116788e0 * t617 * t2 * t1466 * t599 * t40 * t1491 - 0.28703242052974879539812473986617901467432944133464e2 / t615 / t592 * t2 * t1466 * t621 * t40 * t1491 + 0.64826131082694801065289647168628707148530677317810e-1 * t648 * t565 + 0.21608710360898267021763215722876235716176892439270e-1 * (t1583 + t1634) * t647 * t542 + 0.21608710360898267021763215722876235716176892439270e-1 * t662 * t759 + 0.64826131082694801065289647168628707148530677317810e-1 * t838 * t551 + 0.72029034536327556739210719076254119053922974797566e-2 * t657 * t551 * t292 * t359 + 0.72029034536327556739210719076254119053922974797566e-2 * t788 * t774 * t359
  t1654 = t2 * t1459
  t1663 = t1466 * t2
  t1678 = t816 * t6 * t819
  t1687 = t295 * t511 * t29
  t1705 = -0.14405806907265511347842143815250823810784594959513e-1 * t789 * t289 + 0.12017413633297419508922952578394288045451424337591e1 * t596 * t1456 * t1654 * t599 * t1 * t31 + 0.11204516483428731048321667411861751852832462746288e-1 * t659 * t501 + 0.40058045444324731696409841927980960151504747791968e-1 * t855 * t1491 * t1663 * t857 - 0.41858894660588365995559857897151106306673043527969e1 * t863 * t1491 * t1663 * t865 + 0.10712008859232863027768417163076099436041101906828e3 * t881 * t1491 * t1663 * t885 + 0.15006048861734907654002233140886274802900619749493e-3 * t780 * t542 * t1 * t1678 + 0.12004839089387926123201786512709019842320495799594e-2 * t654 / t778 / t626 * t542 * t40 * t1687 + 0.10804355180449133510881607861438117858088446219635e-1 * t837 * t656 * t658 * t27 - 0.14405806907265511347842143815250823810784594959513e-1 * t771 * t289 - 0.96038712715103408985614292101672158738563966396755e-2 * t775 * t826 + 0.21608710360898267021763215722876235716176892439270e-1 * t788 * t770 * t27 + 0.10804355180449133510881607861438117858088446219635e-1 * t657 * t565 * t29 * t27
  t1732 = -t937 * t912 / 0.2e1 - t931 * t912 / 0.4e1 - t924 * t265 * t672 / 0.6e1 - t707 * t1328 * t672 / 0.24e2 - 0.48e2 * t1022 * t152 + 0.120e3 * t1352 * t234 + 0.72e2 * t1352 * t943 - t899 * t140 * t672 / 0.6e1 - t540 * (t1402 + t1524 + t1650 + t1705) * t216 * t672 / 0.24e2 - t925 * t720 / 0.6e1 - t903 * t720 / 0.6e1 - t708 * t145 * (-0.840e3 * t147 * t1278 - 0.1440e4 * t146 * t233 + 0.1920e4 * t227 * t715 + 0.384e3 * t1302 - 0.24e2 * t181) * t671 / 0.24e2 - t666 * t179 * t672 / 0.4e1
  t1754 = 0.14804514559303905048800602434946994993825393540828e-3 * t1011 * t501
  t1758 = 0.47129772651883579472964658244599656881154093130267e0 * t420 * t295 * t1466 * t101
  t1762 = 0.41238551070398132038844075964024699771009831488983e0 * t98 * t31 * t1390 * t101
  t1763 = 0.48e2 * t180 * t470 - t686 * t912 / 0.4e1 + 0.144e3 * t141 * t943 - 0.192e3 * t1352 * t229 - 0.576e3 * t269 * t223 + 0.960e3 * t269 * t950 - 0.384e3 * t141 * t229 + 0.120e3 * t469 * t234 - 0.384e3 * t217 * t218 * t151 - t1754 + t1758 - t1762
  t1771 = 0.12657832131062950425061722062546552262841476284429e3 / t998 / t94 * t2 * t1466 * t1003 * t40 * t1491
  t1776 = t434 ** 2
  t1781 = 0.19162434373246948642083122762742588170998040494372e4 / t998 / t412 * t2 * t1466 / t1776 * t40 * t1491
  t1785 = 0.12112784639430467767200492901320268631311685624314e-3 * t455 * t1009 * t75 * t289
  t1788 = 0.12112784639430467767200492901320268631311685624314e-3 * t1010 * t84 * t289
  t1794 = 0.17673664744456342302361746841724871330432784923849e-1 * t431 * t2 * t1466 * t101 * t40 * t1491
  t1802 = 0.26755801253620581246127143771704987327003266673998e1 / t429 / t412 * t2 * t1466 * t435 * t40 * t1491
  t1805 = 0.16200859349084980443831601271581132052896719513529e-1 * t987 * t1391 * t988
  t1808 = 0.61315377872880498689041371143490595957715819461244e0 * t992 * t1391 * t993
  t1811 = 0.19441031218901976532597921525897358463476063416234e0 * t974 * t1526 * t975
  t1814 = 0.17168305804406539632931583920177366868160429449148e2 * t982 * t1526 * t983
  t1817 = 0.37129640917784654580181051383469886637668330434323e3 * t1001 * t1526 * t1004
  t1822 = -0.16e2 * t1267 * t152 - 0.480e3 * t226 * t953 + t1771 - t1781 + t1785 + t1788 + t1794 - t1802 - t1805 + t1808 - t1811 + t1814 - t1817
  t1844 = 0.31090700000000000000000000000000000000000000000001e-1 * t524 * t409
  t1846 = t4 * t1391 * t76
  t1850 = t23 * t474 * t81 * t84
  t1854 = t23 * t273 * t389 * t391
  t1857 = t23 * t479 * t397
  t1870 = 0.1e1 / t490 / t75
  t1872 = t391 ** 2
  t1876 = t391 * t397
  t1880 = t397 ** 2
  t1884 = t84 * t518
  t1892 = t1452 - 0.10354000000000000000000000000000000000000000000000e1 * t1461 + 0.99398400000000000000000000000000000000000000000000e1 * t1463 - 0.36814222222222222222222222222222222222222222222222e1 * t1468 + 0.32212444444444444444444444444444444444444444444444e1 * t1471
  t1896 = 0.70e2 / 0.81e2 * t1846 + 0.28e2 / 0.27e2 * t1850 + 0.4e1 / 0.3e1 * t1854 - 0.2e1 / 0.3e1 * t1857 + 0.2e1 * t23 * t10 * t491 * t493 - 0.2e1 * t23 * t483 * t497 + t23 * t384 * t518 / 0.3e1 + 0.6e1 * t23 * t12 * t1870 * t1872 - 0.9e1 * t23 * t492 * t1876 + 0.3e1 / 0.2e1 * t23 * t390 * t1880 + 0.2e1 * t23 * t390 * t1884 - t23 * t82 * t1892 / 0.4e1
  t1900 = 0.10363566666666666666666666666666666666666666666667e-1 * t1896 * t40 * t42 * t91
  t1904 = 0.20435174860777645787105769785744382475812907568201e0 * t413 * t1390 * t101 * t23
  t1908 = 0.77340987998746992664586274965084728992118817729523e1 * t431 * t1390 * t435 * t23
  t1909 = 0.960e3 * t226 * t950 + 0.96e2 * t226 * t219 + 0.48e2 * t1022 * t470 - 0.576e3 * t226 * t223 + 0.4e1 * t1266 * t140 * t182 - 0.480e3 * t269 * t953 - t667 * t692 / 0.2e1 + 0.24e2 * t217 * t145 * t181 + t1844 + t1900 + t1904 - t1908
  t1911 = 0.10363566666666666666666666666666666666666666666667e-1 * t524 * t406
  t1913 = 0.20727133333333333333333333333333333333333333333334e-1 * t403 * t530
  t1916 = 0.69090444444444444444444444444444444444444444444446e-2 * t90 * t679 * t84
  t1918 = 0.29070683134633122641281182963168644715148045498353e-2 * t1063 * t84
  t1920 = 0.29070683134633122641281182963168644715148045498353e-2 * t456 * t397
  t1950 = -0.4e1 * t1030 * t31 * t442 * t397 - 0.160e3 / 0.81e2 * t446 * t1578 + 0.140e3 / 0.81e2 * t108 * t1451 - t818 * t819 * t81 * t84 / 0.108e3 - t1857 / 0.12e2 + 0.8e1 / 0.3e1 * t440 * t506 * t893 * t84 + 0.11e2 / 0.54e2 * t1850 + t1854 / 0.6e1 - 0.11e2 / 0.648e3 * t818 * t1563 * t76 - 0.36e2 * t1056 * t1876 + 0.8e1 * t451 * t1884 + 0.24e2 * t111 * t1870 * t1872
  t1995 = 0.6e1 * t451 * t1880 - t112 * t1892 - 0.16e2 / 0.9e1 * t1034 * t295 * t511 * t84 + 0.56e2 / 0.27e2 * t441 * t31 * t474 * t84 + 0.4e1 * t106 * t491 * t30 * t31 * t10 * t493 + 0.8e1 / 0.3e1 * t1030 * t31 * t273 * t391 - 0.5e1 / 0.9e1 * t107 * t1457 * t1608 - 0.4e1 / 0.3e1 * t1029 * t293 * t295 * t298 * t391 + 0.2e1 / 0.3e1 * t1034 * t295 * t298 * t397 - 0.4e1 / 0.3e1 * t441 * t31 * t273 * t397 + 0.2e1 / 0.3e1 * t441 * t31 * t10 * t518 + 0.185e3 / 0.864e3 * t1846 + 0.16e2 / 0.3e1 * t107 * t1463
  t1999 = 0.96902277115443742137603943210562149050493484994510e-3 * (t1950 + t1995) * t115 * t75
  t2001 = 0.96902277115443742137603943210562149050493484994510e-3 * t116 * t518
  t2005 = 0.44184161861140855755904367104312178326081962309624e-2 * t973 * t1491 * t1663 * t975
  t2009 = 0.39018876828196680983935418000403106518546430566246e0 * t981 * t1491 * t1663 * t983
  t2013 = 0.84385547540419669500411480416977015085609841896189e1 * t1000 * t1491 * t1663 * t1004
  t2020 = 0.53834598397468745632002190672534527250274158330283e-4 * t114 / t1008 / t106 * t75 * t40 * t1687
  t2023 = 0.32300759038481247379201314403520716350164494998170e-3 * t958 * t968 * t359
  t2027 = 0.32300759038481247379201314403520716350164494998170e-3 * t461 * t84 * t292 * t359
  t2028 = t1911 + t1913 - t1916 + t1918 + t1920 + t1999 + t2001 + t2005 - t2009 + t2013 + t2020 + t2023 + t2027
  t2031 = 0.43067678717974996505601752538027621800219326664227e-3 * t969 * t826
  t2037 = 0.13255248558342256726771310131293653497824588692887e0 * t96 * t1456 * t1654 * t101 * t1 * t31
  t2041 = 0.48451138557721871068801971605281074525246742497255e-3 * t1062 * t460 * t462 * t27
  t2044 = 0.96902277115443742137603943210562149050493484994510e-3 * t958 * t962 * t27
  t2048 = 0.48451138557721871068801971605281074525246742497255e-3 * t461 * t397 * t29 * t27
  t2050 = 0.50245625170970829256535377961032225433589214441597e-3 * t463 * t501
  t2052 = 0.64601518076962494758402628807041432700328989996340e-3 * t959 * t289
  t2054 = 0.64601518076962494758402628807041432700328989996340e-3 * t963 * t289
  t2058 = 0.67293247996835932040002738340668159062842697912856e-5 * t1010 * t75 * t1 * t1678
  t2066 = 0.6e1 * t468 * t179 * t182 - 0.16e2 * t266 * t152 - 0.192e3 * t469 * t229 - t2031 + t2037 + t2041 + t2044 + t2048 + t2050 - t2052 - t2054 + t2058
  t2073 = 0.64601518076962494758402628807041432700328989996342e-3 * t461 * t75 * t508
  t2075 = 0.31090700000000000000000000000000000000000000000001e-1 * t403 * t533
  t2078 = 0.10363566666666666666666666666666666666666666666667e-1 * t90 * t44 * t518
  t2081 = 0.10363566666666666666666666666666666666666666666667e-1 * t90 * t315 * t397
  t2084 = 0.38383580246913580246913580246913580246913580246915e-2 * t90 * t358 * t75
  t2086 = 0.69090444444444444444444444444444444444444444444446e-2 * t403 * t680
  t2102 = t1754 - t1758 + t1762 - 0.42921743488160883380963771263677691107023010127437e0 * t52 * t31 * t1390 * t55 - 0.20234536215847273593882920738590911521882276202934e0 * t1166 * t1526 * t1167 + 0.10567263012202301373818104525507592435690527950900e2 * t1174 * t1526 * t1175 - 0.13515027854362713277482111065523546736431162216617e3 * t1192 * t1526 * t1195 - 0.34342413959678791974433194933424046692523362938372e-3 * t1202 * t501 - t1771 + t1781 - t1785 - t1788
  t2135 = t344 ** 2
  t2152 = -0.16862113513206061328235767282159092934901896835780e-1 * t1179 * t1391 * t1180 + 0.37740225043579647763636087591098544413180456967501e0 * t1184 * t1391 * t1185 + 0.18395032923497521448984473398719010474438432911759e-1 * t341 * t2 * t1466 * t55 * t40 * t1491 - 0.16468461837198391751404838221570273925751472131273e1 / t339 / t322 * t2 * t1466 * t345 * t40 * t1491 + 0.46073958594418340718689014996103000237833507556650e2 / t1189 / t48 * t2 * t1466 * t1194 * t40 * t1491 - 0.41248484411876216403621151040619215743173669759529e3 / t1189 / t322 * t2 * t1466 / t2135 * t40 * t1491 + 0.28098338694282647979081704945528765475700933313214e-3 * t368 * t1200 * t18 * t289 + 0.28098338694282647979081704945528765475700933313214e-3 * t1201 * t35 * t289 - t1794 + t1802 + t1805 - t1808 + 0.49053421129326723863958595729917361265169154431359e0 * t330 * t295 * t1466 * t55
  t2169 = t1811 - t1814 + t1817 - t1844 - t1900 + 0.15545350000000000000000000000000000000000000000000e-1 * t1104 * t319 - t1904 + t1908 + 0.21269256817794009175388297367268855861069438054221e0 * t323 * t1390 * t55 * t23 - 0.47604147498151601156404610484226573066625349129460e1 * t341 * t1390 * t345 * t23 + 0.14985780636950745588843575970948674920373831100381e-2 * t374 * t18 * t508 + 0.15545350000000000000000000000000000000000000000000e-1 * t311 * t1124
  t2184 = t285 * t305
  t2199 = t35 * t1098
  t2205 = t4 * t1391 * t19
  t2208 = t23 * t1073 * t305
  t2215 = t23 * t273 * t283 * t285
  t2221 = -0.36e2 * t1247 * t2184 - 0.4e1 * t1221 * t31 * t352 * t305 - t818 * t819 * t25 * t35 / 0.108e3 - 0.160e3 / 0.81e2 * t356 * t1578 + 0.140e3 / 0.81e2 * t63 * t1451 + 0.8e1 * t364 * t2199 + 0.16e2 / 0.3e1 * t62 * t1463 + 0.185e3 / 0.864e3 * t2205 - t2208 / 0.12e2 - 0.11e2 / 0.648e3 * t818 * t1563 * t19 + t2215 / 0.6e1 + 0.8e1 / 0.3e1 * t350 * t506 * t893 * t35
  t2224 = t23 * t474 * t25 * t35
  t2226 = t305 ** 2
  t2230 = 0.1e1 / t1084 / t18
  t2232 = t285 ** 2
  t2239 = t1452 - 0.19612277777777777777777777777777777777777777777777e1 * t1461 + 0.18827786666666666666666666666666666666666666666666e2 * t1463 - 0.69732543209876543209876543209876543209876543209875e1 * t1468 + 0.61015975308641975308641975308641975308641975308640e1 * t1471
  t2279 = 0.11e2 / 0.54e2 * t2224 + 0.6e1 * t364 * t2226 + 0.24e2 * t66 * t2230 * t2232 - t67 * t2239 - 0.16e2 / 0.9e1 * t1225 * t295 * t511 * t35 + 0.56e2 / 0.27e2 * t351 * t31 * t474 * t35 + 0.4e1 * t61 * t1085 * t30 * t31 * t10 * t1087 + 0.8e1 / 0.3e1 * t1221 * t31 * t273 * t285 - 0.4e1 / 0.3e1 * t1220 * t293 * t295 * t298 * t285 + 0.2e1 / 0.3e1 * t1225 * t295 * t298 * t305 - 0.4e1 / 0.3e1 * t351 * t31 * t273 * t305 + 0.2e1 / 0.3e1 * t351 * t31 * t10 * t1098 - 0.5e1 / 0.9e1 * t62 * t1457 * t1608
  t2284 = 0.51817833333333333333333333333333333333333333333333e-2 * t43 * t44 * t1098 - t1911 + 0.51817833333333333333333333333333333333333333333333e-2 * t43 * t315 * t305 + 0.10363566666666666666666666666666666666666666666667e-1 * t311 * t1117 - t1913 + t1916 + 0.67436012866278355149796091869269037141682239951713e-2 * t1254 * t35 + 0.67436012866278355149796091869269037141682239951713e-2 * t369 * t305 + 0.22478670955426118383265363956423012380560746650571e-2 * t71 * t1098 - t1918 - t1920 + 0.22478670955426118383265363956423012380560746650571e-2 * (t2221 + t2279) * t70 * t18 - t1999
  t2321 = -t2001 + 0.22478670955426118383265363956423012380560746650571e-2 * t1137 * t1141 * t27 + 0.15610188163490359988378724969738203042056074062897e-4 * t1201 * t18 * t1 * t1678 + 0.11239335477713059191632681978211506190280373325286e-2 * t374 * t305 * t29 * t27 + 0.11239335477713059191632681978211506190280373325286e-2 * t1253 * t373 * t375 * t27 + 0.45987582308743803622461183496797526186096082279398e-2 * t1165 * t1491 * t1663 * t1167 - 0.24016506845914321304132055739789982808387563524773e0 * t1173 * t1491 * t1663 * t1175 + 0.30715972396278893812459343330735333491889005037766e1 * t1191 * t1491 * t1663 * t1195 + 0.12488150530792287990702979975790562433644859250317e-3 * t69 / t1199 / t61 * t18 * t40 * t1687 - t2005 + t2009 - t2013
  t2330 = -t2020 - t2023 - t2027 + t2031 + 0.13796274692623141086738355049039257855828824683819e0 * t50 * t1456 * t1654 * t55 * t1 * t31 - t2037 - t2041 - t2044 - t2048 - t2050 + 0.11655607162072802124656114644071191604735201966963e-2 * t376 * t501 + t2052 + t2054
  t2375 = 0.70e2 / 0.81e2 * t2205 + 0.28e2 / 0.27e2 * t2224 + 0.4e1 / 0.3e1 * t2215 - 0.2e1 / 0.3e1 * t2208 + 0.2e1 * t23 * t10 * t1085 * t1087 - 0.2e1 * t23 * t1077 * t1091 + t23 * t278 * t1098 / 0.3e1 + 0.6e1 * t23 * t12 * t2230 * t2232 - 0.9e1 * t23 * t1086 * t2184 + 0.3e1 / 0.2e1 * t23 * t284 * t2226 + 0.2e1 * t23 * t284 * t2199 - t23 * t26 * t2239 / 0.4e1
  t2380 = -0.14985780636950745588843575970948674920373831100381e-2 * t1138 * t289 - 0.14985780636950745588843575970948674920373831100381e-2 * t1142 * t289 - 0.99905204246338303925623839806324499469158874002539e-3 * t1146 * t826 - t2058 + 0.74928903184753727944217879854743374601869155501904e-3 * t1137 * t1145 * t359 + 0.74928903184753727944217879854743374601869155501904e-3 * t374 * t35 * t292 * t359 + 0.51817833333333333333333333333333333333333333333333e-2 * t2375 * t40 * t42 * t45 - t2073 - t2075 - t2078 - t2081 - t2084
  t2395 = 0.10126265704850360340049377650037241810273181027543e3 * t999 * t2 * t151 * t1003 * t292
  t2400 = 0.53020994233369026907085240525174613991298354771548e-1 * t972 * t2 * t151 * t101 * t292
  t2405 = 0.46822652193836017180722501600483727822255716679496e1 * t980 * t2 * t151 * t435 * t292
  t2423 = 0.12725038616008566457700457726041907357911605145172e1 * t946 * t1360 * t101
  t2427 = t2086 - 0.34545222222222222222222222222222222222222222222222e-2 * t311 * t1129 + 0.19191790123456790123456790123456790123456790123457e-2 * t43 * t358 * t18 + 0.51817833333333333333333333333333333333333333333333e-2 * t1104 * t316 - 0.34545222222222222222222222222222222222222222222222e-2 * t43 * t679 * t35 - t2395 - t2400 + t2405 + 0.36859166875534672574951211996882400190266806045320e2 * t1190 * t2 * t151 * t1194 * t292 + 0.55185098770492564346953420196157031423315298735276e-1 * t1164 * t2 * t151 * t55 * t292 - 0.28819808215097185564958466887747979370065076229728e1 * t1172 * t2 * t151 * t345 * t292 + t2423 - 0.13244423704918215443268820847077687541595671696467e1 * t1260 * t1360 * t55
  t2433 = 0.16e2 * t266 * t470 - 0.48e2 * t180 * t152 + t2073 + t2075 + t2078 + t2081 + t2084 - t2086 + (t2102 + t2152 + t2169 + t2284 + t2321 + t2330 + t2380 + t2427) * t216 * t182 + t2395 + t2400 - t2405 - t2423
  t2446 = 0.20252531409700720680098755300074483620546362055085e3 * t1006 + 0.16150379519240623689600657201760358175082247499085e-3 * t1012 - 0.42416795386695221525668192420139691193038683817240e0 * t1016 + 0.49486261284477758446612891156829639725211797786780e0 * t1020 + 0.12e2 * t1022 * t182 + 0.96e2 * t141 * t470 + 0.38760910846177496855041577284224859620197393997804e-2 * t1064 + 0.38760910846177496855041577284224859620197393997804e-2 * t1066 + 0.77521821692354993710083154568449719240394787995608e-2 * t1068 + t7 * (t1339 + t1732 + t1763 + t1822 + t1909 + t2028 + t2066 + t2433) + 0.4e1 * t1267 * t182 + 0.48e2 * t1352 * t470 - 0.48e2 * t1352 * t152 + 0.144e3 * t269 * t943
  d1111 = t536 + t939 + t997 + t2446

  res = {'v4rho4': d1111}
  return res
