"""Generated from mgga_c_rscan.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  beta_a = 0.06672455060314922

  beta_b = 0.1

  beta_c = 0.1778

  scan_b1c = 0.0285764

  scan_b2c = 0.0889

  scan_b3c = 0.125541

  scan_chi_infty = 0.12802585262625815

  scan_G_cnst = 2.363

  params_c2 = 1.5

  params_d = 0.7

  rscan_fc = np.array([np.nan, -0.051848879792, 0.516884468372, -1.915710236206, 3.061560252175, -1.535685604549, -0.4352, -0.64, 1], dtype=np.float64)

  np53 = lambda rs: f.n_total(rs) ** (5 / 3)

  rscan_f_alpha_small = lambda a, ff: jnp.sum(jnp.array([ff[8 - i] * a ** i for i in range(0, 7 + 1)]), axis=0)

  params_alphar = 0.001

  params_taur = 0.0001

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  mbeta = lambda rs, t=None: beta_a * (1 + beta_b * rs) / (1 + beta_c * rs)

  scan_eclda0 = lambda rs: -scan_b1c / (1 + scan_b2c * jnp.sqrt(rs) + scan_b3c * rs)

  scan_g_infty = lambda s: 1 / (1 + 4 * scan_chi_infty * s ** 2) ** (1 / 4)

  scan_Gc = lambda z: (1 - scan_G_cnst * (2 ** (1 / 3) - 1) * f.f_zeta(z)) * (1 - z ** 12)

  rscan_f_alpha_large = lambda a: -params_d * jnp.exp(params_c2 / (1 - a))

  rscan_alpha0 = lambda rs, z, xt, ts0, ts1: np53(rs) * jnp.maximum(f.t_total(z, ts0, ts1) - xt ** 2 / 8, 0) / ((K_FACTOR_C * np53(rs) + 2 ** (2 / 3) * params_taur) * f.t_total(z, 1, 1))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  scan_H0 = lambda rs, s: scan_b1c * jnp.log(1 + (jnp.exp(-scan_eclda0(rs) / scan_b1c) - 1) * (1 - scan_g_infty(s)))

  rscan_f_alpha = lambda a, ff: f.my_piecewise3(a <= 2.5, rscan_f_alpha_small(jnp.minimum(a, 2.5), ff), rscan_f_alpha_large(jnp.maximum(a, 2.5)))

  rscan_alpha = lambda rs, z, xt, ts0, ts1: rscan_alpha0(rs, z, xt, ts0, ts1) ** 3 / (rscan_alpha0(rs, z, xt, ts0, ts1) ** 2 + params_alphar)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  scan_e0 = lambda rs, z, s: (scan_eclda0(rs) + scan_H0(rs, s)) * scan_Gc(z)

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  scan_e0_g = lambda rs, z, t: (1 + 4 * A(rs, z, t) * t ** 2) ** (-1 / 4)

  f2 = lambda rs, z, t: mbeta(rs, t) * (1 - scan_e0_g(rs, z, t)) / (mgamma * A(rs, z, t))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  rscan_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: f_pbe(rs, z, xt, xs0, xs1) + rscan_f_alpha(rscan_alpha(rs, z, xt, ts0, ts1), rscan_fc) * (+scan_e0(rs, z, X2S * 2 ** (1 / 3) * xt) - f_pbe(rs, z, xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: rscan_f(rs, z, xt, xs0, xs1, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  beta_a = 0.06672455060314922

  beta_b = 0.1

  beta_c = 0.1778

  scan_b1c = 0.0285764

  scan_b2c = 0.0889

  scan_b3c = 0.125541

  scan_chi_infty = 0.12802585262625815

  scan_G_cnst = 2.363

  params_c2 = 1.5

  params_d = 0.7

  rscan_fc = np.array([np.nan, -0.051848879792, 0.516884468372, -1.915710236206, 3.061560252175, -1.535685604549, -0.4352, -0.64, 1], dtype=np.float64)

  np53 = lambda rs: f.n_total(rs) ** (5 / 3)

  rscan_f_alpha_small = lambda a, ff: jnp.sum(jnp.array([ff[8 - i] * a ** i for i in range(0, 7 + 1)]), axis=0)

  params_alphar = 0.001

  params_taur = 0.0001

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  mbeta = lambda rs, t=None: beta_a * (1 + beta_b * rs) / (1 + beta_c * rs)

  scan_eclda0 = lambda rs: -scan_b1c / (1 + scan_b2c * jnp.sqrt(rs) + scan_b3c * rs)

  scan_g_infty = lambda s: 1 / (1 + 4 * scan_chi_infty * s ** 2) ** (1 / 4)

  scan_Gc = lambda z: (1 - scan_G_cnst * (2 ** (1 / 3) - 1) * f.f_zeta(z)) * (1 - z ** 12)

  rscan_f_alpha_large = lambda a: -params_d * jnp.exp(params_c2 / (1 - a))

  rscan_alpha0 = lambda rs, z, xt, ts0, ts1: np53(rs) * jnp.maximum(f.t_total(z, ts0, ts1) - xt ** 2 / 8, 0) / ((K_FACTOR_C * np53(rs) + 2 ** (2 / 3) * params_taur) * f.t_total(z, 1, 1))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  scan_H0 = lambda rs, s: scan_b1c * jnp.log(1 + (jnp.exp(-scan_eclda0(rs) / scan_b1c) - 1) * (1 - scan_g_infty(s)))

  rscan_f_alpha = lambda a, ff: f.my_piecewise3(a <= 2.5, rscan_f_alpha_small(jnp.minimum(a, 2.5), ff), rscan_f_alpha_large(jnp.maximum(a, 2.5)))

  rscan_alpha = lambda rs, z, xt, ts0, ts1: rscan_alpha0(rs, z, xt, ts0, ts1) ** 3 / (rscan_alpha0(rs, z, xt, ts0, ts1) ** 2 + params_alphar)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  scan_e0 = lambda rs, z, s: (scan_eclda0(rs) + scan_H0(rs, s)) * scan_Gc(z)

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  scan_e0_g = lambda rs, z, t: (1 + 4 * A(rs, z, t) * t ** 2) ** (-1 / 4)

  f2 = lambda rs, z, t: mbeta(rs, t) * (1 - scan_e0_g(rs, z, t)) / (mgamma * A(rs, z, t))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  rscan_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: f_pbe(rs, z, xt, xs0, xs1) + rscan_f_alpha(rscan_alpha(rs, z, xt, ts0, ts1), rscan_fc) * (+scan_e0(rs, z, X2S * 2 ** (1 / 3) * xt) - f_pbe(rs, z, xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: rscan_f(rs, z, xt, xs0, xs1, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  beta_a = 0.06672455060314922

  beta_b = 0.1

  beta_c = 0.1778

  scan_b1c = 0.0285764

  scan_b2c = 0.0889

  scan_b3c = 0.125541

  scan_chi_infty = 0.12802585262625815

  scan_G_cnst = 2.363

  params_c2 = 1.5

  params_d = 0.7

  rscan_fc = np.array([np.nan, -0.051848879792, 0.516884468372, -1.915710236206, 3.061560252175, -1.535685604549, -0.4352, -0.64, 1], dtype=np.float64)

  np53 = lambda rs: f.n_total(rs) ** (5 / 3)

  rscan_f_alpha_small = lambda a, ff: jnp.sum(jnp.array([ff[8 - i] * a ** i for i in range(0, 7 + 1)]), axis=0)

  params_alphar = 0.001

  params_taur = 0.0001

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  mbeta = lambda rs, t=None: beta_a * (1 + beta_b * rs) / (1 + beta_c * rs)

  scan_eclda0 = lambda rs: -scan_b1c / (1 + scan_b2c * jnp.sqrt(rs) + scan_b3c * rs)

  scan_g_infty = lambda s: 1 / (1 + 4 * scan_chi_infty * s ** 2) ** (1 / 4)

  scan_Gc = lambda z: (1 - scan_G_cnst * (2 ** (1 / 3) - 1) * f.f_zeta(z)) * (1 - z ** 12)

  rscan_f_alpha_large = lambda a: -params_d * jnp.exp(params_c2 / (1 - a))

  rscan_alpha0 = lambda rs, z, xt, ts0, ts1: np53(rs) * jnp.maximum(f.t_total(z, ts0, ts1) - xt ** 2 / 8, 0) / ((K_FACTOR_C * np53(rs) + 2 ** (2 / 3) * params_taur) * f.t_total(z, 1, 1))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  scan_H0 = lambda rs, s: scan_b1c * jnp.log(1 + (jnp.exp(-scan_eclda0(rs) / scan_b1c) - 1) * (1 - scan_g_infty(s)))

  rscan_f_alpha = lambda a, ff: f.my_piecewise3(a <= 2.5, rscan_f_alpha_small(jnp.minimum(a, 2.5), ff), rscan_f_alpha_large(jnp.maximum(a, 2.5)))

  rscan_alpha = lambda rs, z, xt, ts0, ts1: rscan_alpha0(rs, z, xt, ts0, ts1) ** 3 / (rscan_alpha0(rs, z, xt, ts0, ts1) ** 2 + params_alphar)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  scan_e0 = lambda rs, z, s: (scan_eclda0(rs) + scan_H0(rs, s)) * scan_Gc(z)

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  scan_e0_g = lambda rs, z, t: (1 + 4 * A(rs, z, t) * t ** 2) ** (-1 / 4)

  f2 = lambda rs, z, t: mbeta(rs, t) * (1 - scan_e0_g(rs, z, t)) / (mgamma * A(rs, z, t))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  rscan_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: f_pbe(rs, z, xt, xs0, xs1) + rscan_f_alpha(rscan_alpha(rs, z, xt, ts0, ts1), rscan_fc) * (+scan_e0(rs, z, X2S * 2 ** (1 / 3) * xt) - f_pbe(rs, z, xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: rscan_f(rs, z, xt, xs0, xs1, ts0, ts1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t11 = t4 * t6 / t8
  t13 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t11
  t14 = jnp.sqrt(t11)
  t17 = t11 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t8 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.23615562999000000000000000000000000000000000000000e0 * t14 + 0.55770497660000000000000000000000000000000000000000e-1 * t11 + 0.12733196185000000000000000000000000000000000000000e-1 * t17 + 0.76629248290000000000000000000000000000000000000000e-2 * t25
  t29 = 0.1e1 + 0.1e1 / t27
  t30 = jnp.log(t29)
  t31 = t13 * t30
  t32 = r0 - r1
  t33 = t32 ** 2
  t34 = t33 ** 2
  t35 = t7 ** 2
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t38 = t34 * t37
  t39 = 0.1e1 / t7
  t40 = t32 * t39
  t41 = 0.1e1 + t40
  t42 = t41 <= f.p.zeta_threshold
  t43 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t44 = t43 * f.p.zeta_threshold
  t45 = t41 ** (0.1e1 / 0.3e1)
  t47 = f.my_piecewise3(t42, t44, t45 * t41)
  t48 = 0.1e1 - t40
  t49 = t48 <= f.p.zeta_threshold
  t50 = t48 ** (0.1e1 / 0.3e1)
  t52 = f.my_piecewise3(t49, t44, t50 * t48)
  t53 = t47 + t52 - 0.2e1
  t54 = 2 ** (0.1e1 / 0.3e1)
  t57 = 0.1e1 / (0.2e1 * t54 - 0.2e1)
  t58 = t53 * t57
  t60 = 0.3109070e-1 + 0.15971292590000000000000000000000000000000000000000e-2 * t11
  t65 = 0.21948324211500000000000000000000000000000000000000e0 * t14 + 0.48172707847500000000000000000000000000000000000000e-1 * t11 + 0.13082189292500000000000000000000000000000000000000e-1 * t17 + 0.48592432297500000000000000000000000000000000000000e-2 * t25
  t67 = 0.1e1 + 0.1e1 / t65
  t68 = jnp.log(t67)
  t71 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t11
  t76 = 0.17489762330000000000000000000000000000000000000000e0 * t14 + 0.30591463695000000000000000000000000000000000000000e-1 * t11 + 0.37162156485000000000000000000000000000000000000000e-2 * t17 + 0.41939460495000000000000000000000000000000000000000e-2 * t25
  t78 = 0.1e1 + 0.1e1 / t76
  t79 = jnp.log(t78)
  t80 = t71 * t79
  t82 = -t60 * t68 + t31 - 0.58482236226346462072622386637590534819724553404281e0 * t80
  t83 = t58 * t82
  t84 = t38 * t83
  t86 = 0.58482236226346462072622386637590534819724553404281e0 * t58 * t80
  t87 = jnp.log(0.2e1)
  t88 = 0.1e1 - t87
  t89 = jnp.pi ** 2
  t91 = t88 / t89
  t92 = t43 ** 2
  t93 = t45 ** 2
  t94 = f.my_piecewise3(t42, t92, t93)
  t95 = t50 ** 2
  t96 = f.my_piecewise3(t49, t92, t95)
  t98 = t94 / 0.2e1 + t96 / 0.2e1
  t99 = t98 ** 2
  t100 = t99 * t98
  t102 = 0.66724550603149220e-1 + 0.16681137650787305000000000000000000000000000000000e-2 * t11
  t104 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t11
  t105 = 0.1e1 / t104
  t106 = t102 * t105
  t107 = 0.1e1 / t88
  t108 = t106 * t107
  t110 = (-t31 + t84 + t86) * t107
  t111 = 0.1e1 / t100
  t112 = t89 * t111
  t114 = jnp.exp(-t110 * t112)
  t115 = t114 - 0.1e1
  t116 = 0.1e1 / t115
  t119 = s0 + 0.2e1 * s1 + s2
  t121 = t108 * t89 * t116 * t119
  t122 = t8 * t35
  t123 = 0.1e1 / t122
  t124 = t123 * t54
  t125 = 0.1e1 / t99
  t127 = 0.1e1 / t3
  t128 = t19 * t127
  t129 = t128 * t5
  t133 = 0.1e1 + t121 * t124 * t125 * t129 / 0.24e2
  t134 = t133 ** (0.1e1 / 0.4e1)
  t136 = 0.1e1 - 0.1e1 / t134
  t138 = t136 * t115 + 0.1e1
  t139 = jnp.log(t138)
  t141 = t91 * t100 * t139
  t142 = t36 * t7
  t143 = r0 ** (0.1e1 / 0.3e1)
  t144 = t143 ** 2
  t146 = 0.1e1 / t144 / r0
  t147 = tau0 * t146
  t148 = t41 / 0.2e1
  t149 = t148 ** (0.1e1 / 0.3e1)
  t150 = t149 ** 2
  t151 = t150 * t148
  t153 = r1 ** (0.1e1 / 0.3e1)
  t154 = t153 ** 2
  t156 = 0.1e1 / t154 / r1
  t157 = tau1 * t156
  t158 = t48 / 0.2e1
  t159 = t158 ** (0.1e1 / 0.3e1)
  t160 = t159 ** 2
  t161 = t160 * t158
  t164 = 0.1e1 / t22 / t35
  t167 = t147 * t151 + t157 * t161 - t119 * t164 / 0.8e1
  t168 = 0.0e0 < t167
  t169 = f.my_piecewise3(t168, t167, 0)
  t170 = t169 ** 2
  t171 = t170 * t169
  t172 = t142 * t171
  t173 = 6 ** (0.1e1 / 0.3e1)
  t174 = t173 ** 2
  t175 = t89 ** (0.1e1 / 0.3e1)
  t176 = t175 ** 2
  t177 = t174 * t176
  t178 = t22 * t7
  t181 = t54 ** 2
  t183 = 0.3e1 / 0.10e2 * t177 * t178 + 0.1e-3 * t181
  t184 = t183 ** 2
  t186 = 0.1e1 / t184 / t183
  t187 = t151 + t161
  t188 = t187 ** 2
  t190 = 0.1e1 / t188 / t187
  t192 = t35 * t7
  t193 = t8 * t192
  t194 = t193 * t170
  t195 = 0.1e1 / t184
  t196 = 0.1e1 / t188
  t197 = t195 * t196
  t199 = t194 * t197 + 0.1e-2
  t200 = 0.1e1 / t199
  t201 = t186 * t190 * t200
  t202 = t172 * t201
  t203 = t202 <= 0.25e1
  t204 = 0.25e1 < t202
  t205 = f.my_piecewise3(t204, 0.25e1, t202)
  t207 = t205 ** 2
  t209 = t207 * t205
  t211 = t207 ** 2
  t213 = t211 * t205
  t215 = t211 * t207
  t220 = f.my_piecewise3(t204, t202, 0.25e1)
  t221 = 0.1e1 - t220
  t224 = jnp.exp(0.15e1 / t221)
  t226 = f.my_piecewise3(t203, 0.1e1 - 0.64e0 * t205 - 0.4352e0 * t207 - 0.1535685604549e1 * t209 + 0.3061560252175e1 * t211 - 0.1915710236206e1 * t213 + 0.516884468372e0 * t215 - 0.51848879792e-1 * t211 * t209, -0.7e0 * t224)
  t229 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t14 + 0.31385250000000000000000000000000000000000000000000e-1 * t11
  t230 = 0.1e1 / t229
  t233 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t230)
  t234 = t233 - 0.1e1
  t235 = 0.1e1 / t176
  t236 = t173 * t235
  t241 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t236 * t181 * t119 * t164
  t242 = t241 ** (0.1e1 / 0.4e1)
  t244 = 0.1e1 - 0.1e1 / t242
  t246 = t234 * t244 + 0.1e1
  t247 = jnp.log(t246)
  t249 = -0.285764e-1 * t230 + 0.285764e-1 * t247
  t251 = 0.2363e1 * t54 - 0.2363e1
  t254 = -t251 * t53 * t57 + 0.1e1
  t255 = t249 * t254
  t256 = t34 ** 2
  t257 = t256 * t34
  t258 = t36 ** 2
  t260 = 0.1e1 / t258 / t36
  t262 = -t257 * t260 + 0.1e1
  t264 = t255 * t262 - t141 + t31 - t84 - t86
  t265 = t226 * t264
  t267 = 0.1e1 / t8 / t7
  t268 = t6 * t267
  t271 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t268 * t30
  t272 = t27 ** 2
  t277 = t3 * t6
  t278 = t277 * t267
  t279 = 0.1e1 / t14 * t1 * t278
  t281 = t4 * t268
  t283 = t11 ** 0.5e0
  t285 = t283 * t1 * t278
  t289 = t21 * t5 / t178
  t294 = t13 / t272 * (-0.39359271665000000000000000000000000000000000000000e-1 * t279 - 0.18590165886666666666666666666666666666666666666667e-1 * t281 - 0.63665980925000000000000000000000000000000000000000e-2 * t285 - 0.51086165526666666666666666666666666666666666666667e-2 * t289) / t29
  t295 = t33 * t32
  t298 = 0.4e1 * t295 * t37 * t83
  t302 = 0.4e1 * t34 / t142 * t83
  t304 = t32 / t35
  t305 = t39 - t304
  t308 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t305)
  t309 = -t305
  t312 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t309)
  t314 = (t308 + t312) * t57
  t316 = t38 * t314 * t82
  t320 = t65 ** 2
  t334 = t76 ** 2
  t335 = 0.1e1 / t334
  t341 = -0.29149603883333333333333333333333333333333333333333e-1 * t279 - 0.10197154565000000000000000000000000000000000000000e-1 * t281 - 0.18581078242500000000000000000000000000000000000000e-2 * t285 - 0.27959640330000000000000000000000000000000000000000e-2 * t289
  t342 = 0.1e1 / t78
  t348 = t38 * t58 * (0.53237641966666666666666666666666666666666666666667e-3 * t4 * t268 * t68 + t60 / t320 * (-0.36580540352500000000000000000000000000000000000000e-1 * t279 - 0.16057569282500000000000000000000000000000000000000e-1 * t281 - 0.65410946462500000000000000000000000000000000000000e-2 * t285 - 0.32394954865000000000000000000000000000000000000000e-2 * t289) / t67 - t271 - t294 + 0.18311447306006545054854346104378990962041954983034e-3 * t4 * t268 * t79 + 0.58482236226346462072622386637590534819724553404281e0 * t71 * t335 * t341 * t342)
  t350 = 0.58482236226346462072622386637590534819724553404281e0 * t314 * t80
  t355 = 0.18311447306006545054854346104378990962041954983034e-3 * t58 * t1 * t277 * t267 * t79
  t360 = 0.58482236226346462072622386637590534819724553404281e0 * t58 * t71 * t335 * t341 * t342
  t361 = t99 * t139
  t362 = 0.1e1 / t45
  t365 = f.my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t362 * t305)
  t366 = 0.1e1 / t50
  t369 = f.my_piecewise3(t49, 0, 0.2e1 / 0.3e1 * t366 * t309)
  t371 = t365 / 0.2e1 + t369 / 0.2e1
  t374 = 0.3e1 * t91 * t361 * t371
  t376 = 0.1e1 / t134 / t133
  t378 = 0.1e1 / t22 / t192
  t380 = t107 * t89
  t382 = t116 * t119
  t383 = t54 * t125
  t386 = 0.27801896084645508333333333333333333333333333333333e-3 * t378 * t105 * t380 * t382 * t383
  t387 = t104 ** 2
  t395 = 0.74083333333333333333333333333333333333333333333333e-2 * t102 / t387 * t380 * t382 * t378 * t54 * t125
  t396 = t115 ** 2
  t401 = t108 * t89 / t396 * t119 * t123
  t402 = t383 * t19
  t403 = t127 * t5
  t407 = t99 ** 2
  t409 = t89 / t407
  t413 = -(t271 + t294 + t298 - t302 + t316 + t348 + t350 - t355 - t360) * t107 * t112 + 0.3e1 * t110 * t409 * t371
  t424 = 0.7e1 / 0.72e2 * t121 / t193 * t54 * t125 * t129
  t425 = t124 * t111
  t439 = 0.1e1 / t138
  t441 = t91 * t100 * (t376 * (-t386 + t395 - t401 * t402 * t403 * t413 * t114 / 0.24e2 - t424 - t121 * t425 * t128 * t5 * t371 / 0.12e2) * t115 / 0.4e1 + t136 * t413 * t114) * t439
  t444 = 0.5e1 * t36 * t171 * t201
  t446 = t142 * t170 * t186
  t447 = t190 * t200
  t448 = r0 ** 2
  t454 = t305 / 0.2e1
  t455 = t150 * t454
  t459 = -t160 * t454
  t462 = t119 * t378
  t463 = t462 / 0.3e1
  t465 = f.my_piecewise3(t168, -0.5e1 / 0.3e1 * tau0 / t144 / t448 * t151 + 0.5e1 / 0.3e1 * t147 * t455 + 0.5e1 / 0.3e1 * t157 * t459 + t463, 0)
  t471 = t184 ** 2
  t476 = 0.3e1 / 0.2e1 * t22 * t142 * t171 / t471 * t447 * t177
  t477 = t172 * t186
  t478 = t188 ** 2
  t480 = 0.1e1 / t478 * t200
  t482 = 0.5e1 / 0.3e1 * t455 + 0.5e1 / 0.3e1 * t459
  t486 = t199 ** 2
  t487 = 0.1e1 / t486
  t488 = t190 * t487
  t491 = 0.10e2 / 0.3e1 * t122 * t170 * t197
  t492 = t193 * t169
  t500 = t36 * t170 * t186 * t196 * t174 * t176
  t501 = t195 * t190
  t508 = t444 + 0.3e1 * t446 * t447 * t465 - t476 - 0.3e1 * t477 * t480 * t482 - t477 * t488 * (-0.2e1 * t194 * t501 * t482 + 0.2e1 * t492 * t197 * t465 + t491 - t500)
  t509 = f.my_piecewise3(t204, 0, t508)
  t524 = t221 ** 2
  t525 = 0.1e1 / t524
  t526 = f.my_piecewise3(t204, t508, 0)
  t530 = f.my_piecewise3(t203, -0.64e0 * t509 - 0.8704e0 * t205 * t509 - 0.4607056813647e1 * t207 * t509 + 0.12246241008700e2 * t209 * t509 - 0.9578551181030e1 * t211 * t509 + 0.3101306810232e1 * t213 * t509 - 0.362942158544e0 * t215 * t509, -0.105e1 * t525 * t526 * t224)
  t532 = t229 ** 2
  t537 = 0.1e1 / t532 * (-0.74083333333333333333333333333333333333333333333333e-2 * t279 - 0.10461750000000000000000000000000000000000000000000e-1 * t281)
  t544 = t234 / t242 / t241
  t551 = 0.1e1 / t246
  t556 = (0.285764e-1 * t537 + 0.285764e-1 * (-0.10000000000000000000000000000000000000000000000000e1 * t537 * t233 * t244 - 0.14225094736250905555555555555555555555555555555555e-1 * t544 * t173 * t235 * t181 * t462) * t551) * t254 * t262
  t557 = t249 * t251
  t561 = t256 * t295 * t260
  t564 = t257 / t258 / t142
  t568 = t556 - t557 * t314 * t262 + t255 * (-0.12e2 * t561 + 0.12e2 * t564) - t271 - t294 - t298 + t302 - t316 - t348 - t350 + t355 + t360 - t374 - t441
  t570 = t226 * t568 + t530 * t264 + t271 + t294 + t298 - t302 + t316 + t348 + t350 - t355 - t360 + t374 + t441
  vrho_0_ = t7 * t570 + t141 + t265 - t31 + t84 + t86
  t572 = -t39 - t304
  t575 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t572)
  t576 = -t572
  t579 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t576)
  t581 = (t575 + t579) * t57
  t583 = t38 * t581 * t82
  t585 = 0.58482236226346462072622386637590534819724553404281e0 * t581 * t80
  t588 = f.my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t362 * t572)
  t591 = f.my_piecewise3(t49, 0, 0.2e1 / 0.3e1 * t366 * t576)
  t593 = t588 / 0.2e1 + t591 / 0.2e1
  t596 = 0.3e1 * t91 * t361 * t593
  t603 = -(t271 + t294 - t298 - t302 + t583 + t348 + t585 - t355 - t360) * t107 * t112 + 0.3e1 * t110 * t409 * t593
  t623 = t91 * t100 * (t376 * (-t386 + t395 - t401 * t402 * t403 * t603 * t114 / 0.24e2 - t424 - t121 * t425 * t128 * t5 * t593 / 0.12e2) * t115 / 0.4e1 + t136 * t603 * t114) * t439
  t624 = t572 / 0.2e1
  t625 = t150 * t624
  t628 = r1 ** 2
  t635 = -t160 * t624
  t639 = f.my_piecewise3(t168, 0.5e1 / 0.3e1 * t147 * t625 - 0.5e1 / 0.3e1 * tau1 / t154 / t628 * t161 + 0.5e1 / 0.3e1 * t157 * t635 + t463, 0)
  t644 = 0.5e1 / 0.3e1 * t625 + 0.5e1 / 0.3e1 * t635
  t657 = t444 + 0.3e1 * t446 * t447 * t639 - t476 - 0.3e1 * t477 * t480 * t644 - t477 * t488 * (-0.2e1 * t194 * t501 * t644 + 0.2e1 * t492 * t197 * t639 + t491 - t500)
  t658 = f.my_piecewise3(t204, 0, t657)
  t673 = f.my_piecewise3(t204, t657, 0)
  t677 = f.my_piecewise3(t203, -0.64e0 * t658 - 0.8704e0 * t205 * t658 - 0.4607056813647e1 * t207 * t658 + 0.12246241008700e2 * t209 * t658 - 0.9578551181030e1 * t211 * t658 + 0.3101306810232e1 * t213 * t658 - 0.362942158544e0 * t215 * t658, -0.105e1 * t525 * t673 * t224)
  t684 = t556 - t557 * t581 * t262 + t255 * (0.12e2 * t561 + 0.12e2 * t564) - t271 - t294 + t298 + t302 - t583 - t348 - t585 + t355 + t360 - t596 - t623
  t686 = t226 * t684 + t677 * t264 + t271 + t294 - t298 - t302 + t348 - t355 - t360 + t583 + t585 + t596 + t623
  vrho_1_ = t7 * t686 + t141 + t265 - t31 + t84 + t86
  t694 = t98 * t376 * t106 * t123 * t54 * t19 * t403 * t439
  t695 = t694 / 0.96e2
  t697 = f.my_piecewise3(t168, -t164 / 0.8e1, 0)
  t702 = t170 ** 2
  t706 = t8 * t258 * t702 / t471 / t183
  t709 = 0.1e1 / t478 / t187 * t487
  t713 = 0.3e1 * t446 * t447 * t697 - 0.2e1 * t706 * t709 * t697
  t714 = f.my_piecewise3(t204, 0, t713)
  t729 = f.my_piecewise3(t204, t713, 0)
  t733 = f.my_piecewise3(t203, -0.64e0 * t714 - 0.8704e0 * t205 * t714 - 0.4607056813647e1 * t207 * t714 + 0.12246241008700e2 * t209 * t714 - 0.9578551181030e1 * t211 * t714 + 0.3101306810232e1 * t213 * t714 - 0.362942158544e0 * t215 * t714, -0.105e1 * t525 * t729 * t224)
  t740 = t544 * t236 * t181 * t164 * t551 * t254 * t262
  vsigma_0_ = t7 * (t695 + t733 * t264 + t226 * (0.15243824895787514156916666666666666666666666666666e-3 * t740 - t695))
  t745 = t694 / 0.48e2
  t747 = f.my_piecewise3(t168, -t164 / 0.4e1, 0)
  t754 = 0.3e1 * t446 * t447 * t747 - 0.2e1 * t706 * t709 * t747
  t755 = f.my_piecewise3(t204, 0, t754)
  t770 = f.my_piecewise3(t204, t754, 0)
  t774 = f.my_piecewise3(t203, -0.64e0 * t755 - 0.8704e0 * t205 * t755 - 0.4607056813647e1 * t207 * t755 + 0.12246241008700e2 * t209 * t755 - 0.9578551181030e1 * t211 * t755 + 0.3101306810232e1 * t213 * t755 - 0.362942158544e0 * t215 * t755, -0.105e1 * t525 * t770 * t224)
  vsigma_1_ = t7 * (t745 + t774 * t264 + t226 * (0.30487649791575028313833333333333333333333333333331e-3 * t740 - t745))
  vsigma_2_ = vsigma_0_
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t781 = f.my_piecewise3(t168, t146 * t151, 0)
  t788 = 0.3e1 * t446 * t447 * t781 - 0.2e1 * t706 * t709 * t781
  t789 = f.my_piecewise3(t204, 0, t788)
  t804 = f.my_piecewise3(t204, t788, 0)
  t808 = f.my_piecewise3(t203, -0.64e0 * t789 - 0.8704e0 * t205 * t789 - 0.4607056813647e1 * t207 * t789 + 0.12246241008700e2 * t209 * t789 - 0.9578551181030e1 * t211 * t789 + 0.3101306810232e1 * t213 * t789 - 0.362942158544e0 * t215 * t789, -0.105e1 * t525 * t804 * t224)
  vtau_0_ = t7 * t808 * t264
  t811 = f.my_piecewise3(t168, t156 * t161, 0)
  t818 = 0.3e1 * t446 * t447 * t811 - 0.2e1 * t706 * t709 * t811
  t819 = f.my_piecewise3(t204, 0, t818)
  t834 = f.my_piecewise3(t204, t818, 0)
  t838 = f.my_piecewise3(t203, -0.64e0 * t819 - 0.8704e0 * t205 * t819 - 0.4607056813647e1 * t207 * t819 + 0.12246241008700e2 * t209 * t819 - 0.9578551181030e1 * t211 * t819 + 0.3101306810232e1 * t213 * t819 - 0.362942158544e0 * t215 * t819, -0.105e1 * t525 * t834 * t224)
  vtau_1_ = t7 * t838 * t264
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  beta_a = 0.06672455060314922

  beta_b = 0.1

  beta_c = 0.1778

  scan_b1c = 0.0285764

  scan_b2c = 0.0889

  scan_b3c = 0.125541

  scan_chi_infty = 0.12802585262625815

  scan_G_cnst = 2.363

  params_c2 = 1.5

  params_d = 0.7

  rscan_fc = np.array([np.nan, -0.051848879792, 0.516884468372, -1.915710236206, 3.061560252175, -1.535685604549, -0.4352, -0.64, 1], dtype=np.float64)

  np53 = lambda rs: f.n_total(rs) ** (5 / 3)

  rscan_f_alpha_small = lambda a, ff: jnp.sum(jnp.array([ff[8 - i] * a ** i for i in range(0, 7 + 1)]), axis=0)

  params_alphar = 0.001

  params_taur = 0.0001

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  mbeta = lambda rs, t=None: beta_a * (1 + beta_b * rs) / (1 + beta_c * rs)

  scan_eclda0 = lambda rs: -scan_b1c / (1 + scan_b2c * jnp.sqrt(rs) + scan_b3c * rs)

  scan_g_infty = lambda s: 1 / (1 + 4 * scan_chi_infty * s ** 2) ** (1 / 4)

  scan_Gc = lambda z: (1 - scan_G_cnst * (2 ** (1 / 3) - 1) * f.f_zeta(z)) * (1 - z ** 12)

  rscan_f_alpha_large = lambda a: -params_d * jnp.exp(params_c2 / (1 - a))

  rscan_alpha0 = lambda rs, z, xt, ts0, ts1: np53(rs) * jnp.maximum(f.t_total(z, ts0, ts1) - xt ** 2 / 8, 0) / ((K_FACTOR_C * np53(rs) + 2 ** (2 / 3) * params_taur) * f.t_total(z, 1, 1))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  scan_H0 = lambda rs, s: scan_b1c * jnp.log(1 + (jnp.exp(-scan_eclda0(rs) / scan_b1c) - 1) * (1 - scan_g_infty(s)))

  rscan_f_alpha = lambda a, ff: f.my_piecewise3(a <= 2.5, rscan_f_alpha_small(jnp.minimum(a, 2.5), ff), rscan_f_alpha_large(jnp.maximum(a, 2.5)))

  rscan_alpha = lambda rs, z, xt, ts0, ts1: rscan_alpha0(rs, z, xt, ts0, ts1) ** 3 / (rscan_alpha0(rs, z, xt, ts0, ts1) ** 2 + params_alphar)

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  scan_e0 = lambda rs, z, s: (scan_eclda0(rs) + scan_H0(rs, s)) * scan_Gc(z)

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  scan_e0_g = lambda rs, z, t: (1 + 4 * A(rs, z, t) * t ** 2) ** (-1 / 4)

  f2 = lambda rs, z, t: mbeta(rs, t) * (1 - scan_e0_g(rs, z, t)) / (mgamma * A(rs, z, t))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  rscan_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: f_pbe(rs, z, xt, xs0, xs1) + rscan_f_alpha(rscan_alpha(rs, z, xt, ts0, ts1), rscan_fc) * (+scan_e0(rs, z, X2S * 2 ** (1 / 3) * xt) - f_pbe(rs, z, xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: rscan_f(rs, z, xt, xs0, xs1, ts0, ts1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t10 = t4 * t6 / t7
  t12 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t24 = t20 * t5 / t21
  t26 = 0.23615562999000000000000000000000000000000000000000e0 * t13 + 0.55770497660000000000000000000000000000000000000000e-1 * t10 + 0.12733196185000000000000000000000000000000000000000e-1 * t16 + 0.76629248290000000000000000000000000000000000000000e-2 * t24
  t28 = 0.1e1 + 0.1e1 / t26
  t29 = jnp.log(t28)
  t30 = t12 * t29
  t31 = 0.1e1 <= f.p.zeta_threshold
  t32 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t34 = f.my_piecewise3(t31, t32 * f.p.zeta_threshold, 1)
  t36 = 0.2e1 * t34 - 0.2e1
  t37 = 2 ** (0.1e1 / 0.3e1)
  t40 = 0.1e1 / (0.2e1 * t37 - 0.2e1)
  t41 = t36 * t40
  t43 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t10
  t48 = 0.17489762330000000000000000000000000000000000000000e0 * t13 + 0.30591463695000000000000000000000000000000000000000e-1 * t10 + 0.37162156485000000000000000000000000000000000000000e-2 * t16 + 0.41939460495000000000000000000000000000000000000000e-2 * t24
  t50 = 0.1e1 + 0.1e1 / t48
  t51 = jnp.log(t50)
  t54 = 0.58482236226346462072622386637590534819724553404281e0 * t41 * t43 * t51
  t55 = jnp.log(0.2e1)
  t56 = 0.1e1 - t55
  t57 = jnp.pi ** 2
  t59 = t56 / t57
  t60 = t32 ** 2
  t61 = f.my_piecewise3(t31, t60, 1)
  t62 = t61 ** 2
  t63 = t62 * t61
  t65 = 0.66724550603149220e-1 + 0.16681137650787305000000000000000000000000000000000e-2 * t10
  t67 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t10
  t68 = 0.1e1 / t67
  t69 = t65 * t68
  t70 = 0.1e1 / t56
  t75 = t57 / t63
  t77 = jnp.exp(-(-t30 + t54) * t70 * t75)
  t78 = t77 - 0.1e1
  t79 = 0.1e1 / t78
  t82 = t69 * t70 * t57 * t79 * s0
  t83 = r0 ** 2
  t84 = t7 * t83
  t85 = 0.1e1 / t84
  t87 = 0.1e1 / t62
  t89 = 0.1e1 / t3
  t91 = t18 * t89 * t5
  t95 = 0.1e1 + t82 * t85 * t37 * t87 * t91 / 0.24e2
  t96 = t95 ** (0.1e1 / 0.4e1)
  t98 = 0.1e1 - 0.1e1 / t96
  t100 = t98 * t78 + 0.1e1
  t101 = jnp.log(t100)
  t103 = t59 * t63 * t101
  t104 = t83 ** 2
  t105 = t104 * r0
  t106 = t21 * r0
  t107 = 0.1e1 / t106
  t110 = 0.1e1 / t21 / t83
  t113 = tau0 * t107 - s0 * t110 / 0.8e1
  t114 = 0.0e0 < t113
  t115 = f.my_piecewise3(t114, t113, 0)
  t116 = t115 ** 2
  t117 = t116 * t115
  t118 = t105 * t117
  t119 = 6 ** (0.1e1 / 0.3e1)
  t120 = t119 ** 2
  t121 = t57 ** (0.1e1 / 0.3e1)
  t122 = t121 ** 2
  t126 = t37 ** 2
  t128 = 0.3e1 / 0.10e2 * t120 * t122 * t106 + 0.1e-3 * t126
  t129 = t128 ** 2
  t131 = 0.1e1 / t129 / t128
  t132 = t83 * r0
  t133 = t7 * t132
  t136 = 0.1e1 / t129 * t37
  t139 = 0.2e1 * t133 * t116 * t136 + 0.1e-2
  t140 = 0.1e1 / t139
  t141 = t131 * t140
  t143 = 0.4e1 * t118 * t141
  t144 = t143 <= 0.25e1
  t145 = 0.25e1 < t143
  t146 = f.my_piecewise3(t145, 0.25e1, t143)
  t148 = t146 ** 2
  t150 = t148 * t146
  t152 = t148 ** 2
  t154 = t152 * t146
  t156 = t152 * t148
  t161 = f.my_piecewise3(t145, t143, 0.25e1)
  t162 = 0.1e1 - t161
  t165 = jnp.exp(0.15e1 / t162)
  t167 = f.my_piecewise3(t144, 0.1e1 - 0.64e0 * t146 - 0.4352e0 * t148 - 0.1535685604549e1 * t150 + 0.3061560252175e1 * t152 - 0.1915710236206e1 * t154 + 0.516884468372e0 * t156 - 0.51848879792e-1 * t152 * t150, -0.7e0 * t165)
  t170 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t13 + 0.31385250000000000000000000000000000000000000000000e-1 * t10
  t171 = 0.1e1 / t170
  t174 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t171)
  t175 = t174 - 0.1e1
  t176 = 0.1e1 / t122
  t177 = t119 * t176
  t182 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t177 * t126 * s0 * t110
  t183 = t182 ** (0.1e1 / 0.4e1)
  t185 = 0.1e1 - 0.1e1 / t183
  t187 = t175 * t185 + 0.1e1
  t188 = jnp.log(t187)
  t195 = 0.1e1 - (0.2363e1 * t37 - 0.2363e1) * t36 * t40
  t197 = (-0.285764e-1 * t171 + 0.285764e-1 * t188) * t195 + t30 - t54 - t103
  t200 = 0.1e1 / t7 / r0
  t201 = t6 * t200
  t204 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t201 * t29
  t205 = t26 ** 2
  t210 = t3 * t6
  t211 = t210 * t200
  t212 = 0.1e1 / t13 * t1 * t211
  t214 = t4 * t201
  t216 = t10 ** 0.5e0
  t218 = t216 * t1 * t211
  t221 = t20 * t5 * t107
  t226 = t12 / t205 * (-0.39359271665000000000000000000000000000000000000000e-1 * t212 - 0.18590165886666666666666666666666666666666666666667e-1 * t214 - 0.63665980925000000000000000000000000000000000000000e-2 * t218 - 0.51086165526666666666666666666666666666666666666667e-2 * t221) / t28
  t231 = 0.18311447306006545054854346104378990962041954983034e-3 * t41 * t1 * t210 * t200 * t51
  t233 = t48 ** 2
  t244 = 0.58482236226346462072622386637590534819724553404281e0 * t41 * t43 / t233 * (-0.29149603883333333333333333333333333333333333333333e-1 * t212 - 0.10197154565000000000000000000000000000000000000000e-1 * t214 - 0.18581078242500000000000000000000000000000000000000e-2 * t218 - 0.27959640330000000000000000000000000000000000000000e-2 * t221) / t50
  t246 = 0.1e1 / t96 / t95
  t248 = 0.1e1 / t21 / t132
  t250 = t70 * t57
  t252 = t79 * s0
  t257 = t67 ** 2
  t266 = t56 ** 2
  t269 = t57 ** 2
  t270 = t78 ** 2
  t276 = t62 ** 2
  t281 = t89 * t5
  t282 = t204 + t226 - t231 - t244
  t304 = 0.1e1 / t100
  t306 = t59 * t63 * (t246 * (-0.27801896084645508333333333333333333333333333333333e-3 * t248 * t68 * t250 * t252 * t37 * t87 + 0.74083333333333333333333333333333333333333333333333e-2 * t65 / t257 * t250 * t252 * t248 * t37 * t87 + t69 / t266 * t269 / t270 * s0 * t85 * t37 / t276 / t61 * t18 * t281 * t282 * t77 / 0.24e2 - 0.7e1 / 0.72e2 * t82 / t133 * t37 * t87 * t91) * t78 / 0.4e1 - t98 * t282 * t70 * t75 * t77) * t304
  t310 = t105 * t116
  t313 = s0 * t248
  t316 = f.my_piecewise3(t114, -0.5e1 / 0.3e1 * tau0 * t110 + t313 / 0.3e1, 0)
  t322 = t129 ** 2
  t329 = t139 ** 2
  t330 = 0.1e1 / t329
  t349 = 0.20e2 * t104 * t117 * t141 + 0.12e2 * t310 * t141 * t316 - 0.6e1 * t21 * t105 * t117 / t322 * t140 * t120 * t122 - 0.4e1 * t118 * t131 * t330 * (0.20e2 / 0.3e1 * t84 * t116 * t136 + 0.4e1 * t133 * t115 * t136 * t316 - 0.2e1 * t104 * t116 * t131 * t37 * t120 * t122)
  t350 = f.my_piecewise3(t145, 0, t349)
  t365 = t162 ** 2
  t366 = 0.1e1 / t365
  t367 = f.my_piecewise3(t145, t349, 0)
  t371 = f.my_piecewise3(t144, -0.64e0 * t350 - 0.8704e0 * t146 * t350 - 0.4607056813647e1 * t148 * t350 + 0.12246241008700e2 * t150 * t350 - 0.9578551181030e1 * t152 * t350 + 0.3101306810232e1 * t154 * t350 - 0.362942158544e0 * t156 * t350, -0.105e1 * t366 * t367 * t165)
  t373 = t170 ** 2
  t378 = 0.1e1 / t373 * (-0.74083333333333333333333333333333333333333333333333e-2 * t212 - 0.10461750000000000000000000000000000000000000000000e-1 * t214)
  t385 = t175 / t183 / t182
  t392 = 0.1e1 / t187
  vrho_0_ = -t30 + t54 + t103 + t167 * t197 + r0 * (t204 + t226 - t231 - t244 + t306 + t371 * t197 + t167 * ((0.285764e-1 * t378 + 0.285764e-1 * (-0.10000000000000000000000000000000000000000000000000e1 * t378 * t174 * t185 - 0.14225094736250905555555555555555555555555555555555e-1 * t385 * t119 * t176 * t126 * t313) * t392) * t195 - t204 - t226 + t231 + t244 - t306))
  t408 = t61 * t246 * t69 * t85 * t37 * t18 * t281 * t304 / 0.96e2
  t410 = f.my_piecewise3(t114, -t110 / 0.8e1, 0)
  t414 = t104 ** 2
  t416 = t116 ** 2
  t420 = t7 * t414 * t416 / t322 / t128
  t421 = t330 * t37
  t425 = 0.12e2 * t310 * t141 * t410 - 0.16e2 * t420 * t421 * t410
  t426 = f.my_piecewise3(t145, 0, t425)
  t441 = f.my_piecewise3(t145, t425, 0)
  t445 = f.my_piecewise3(t144, -0.64e0 * t426 - 0.8704e0 * t146 * t426 - 0.4607056813647e1 * t148 * t426 + 0.12246241008700e2 * t150 * t426 - 0.9578551181030e1 * t152 * t426 + 0.3101306810232e1 * t154 * t426 - 0.362942158544e0 * t156 * t426, -0.105e1 * t366 * t441 * t165)
  vsigma_0_ = r0 * (t408 + t445 * t197 + t167 * (0.15243824895787514156916666666666666666666666666666e-3 * t385 * t177 * t126 * t110 * t392 * t195 - t408))
  vlapl_0_ = 0.0e0
  t456 = f.my_piecewise3(t114, t107, 0)
  t463 = 0.12e2 * t310 * t141 * t456 - 0.16e2 * t420 * t421 * t456
  t464 = f.my_piecewise3(t145, 0, t463)
  t479 = f.my_piecewise3(t145, t463, 0)
  t483 = f.my_piecewise3(t144, -0.64e0 * t464 - 0.8704e0 * t146 * t464 - 0.4607056813647e1 * t148 * t464 + 0.12246241008700e2 * t150 * t464 - 0.9578551181030e1 * t152 * t464 + 0.3101306810232e1 * t154 * t464 - 0.362942158544e0 * t156 * t464, -0.105e1 * t366 * t479 * t165)
  vtau_0_ = r0 * t483 * t197
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = t7 * r0
  t9 = 0.1e1 / t8
  t10 = t6 * t9
  t13 = t4 * t6 / t7
  t14 = jnp.sqrt(t13)
  t17 = t13 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t7 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.37978500000000000000000000000000000000000000000000e1 * t14 + 0.89690000000000000000000000000000000000000000000000e0 * t13 + 0.20477500000000000000000000000000000000000000000000e0 * t17 + 0.12323500000000000000000000000000000000000000000000e0 * t25
  t30 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t27
  t31 = jnp.log(t30)
  t33 = t4 * t10 * t31
  t36 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t13
  t37 = t27 ** 2
  t38 = 0.1e1 / t37
  t39 = t36 * t38
  t41 = 0.1e1 / t14 * t1
  t42 = t3 * t6
  t43 = t42 * t9
  t44 = t41 * t43
  t46 = t4 * t10
  t48 = t13 ** 0.5e0
  t49 = t48 * t1
  t50 = t49 * t43
  t52 = t22 * r0
  t53 = 0.1e1 / t52
  t55 = t21 * t5 * t53
  t57 = -0.63297500000000000000000000000000000000000000000000e0 * t44 - 0.29896666666666666666666666666666666666666666666667e0 * t46 - 0.10238750000000000000000000000000000000000000000000e0 * t50 - 0.82156666666666666666666666666666666666666666666667e-1 * t55
  t58 = 0.1e1 / t30
  t59 = t57 * t58
  t60 = t39 * t59
  t62 = 0.1e1 <= f.p.zeta_threshold
  t63 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t65 = f.my_piecewise3(t62, t63 * f.p.zeta_threshold, 1)
  t67 = 0.2e1 * t65 - 0.2e1
  t68 = 2 ** (0.1e1 / 0.3e1)
  t69 = t68 - 0.1e1
  t71 = 0.1e1 / t69 / 0.2e1
  t72 = t67 * t71
  t73 = t72 * t1
  t78 = 0.51785000000000000000000000000000000000000000000000e1 * t14 + 0.90577500000000000000000000000000000000000000000000e0 * t13 + 0.11003250000000000000000000000000000000000000000000e0 * t17 + 0.12417750000000000000000000000000000000000000000000e0 * t25
  t81 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t78
  t82 = jnp.log(t81)
  t85 = t73 * t42 * t9 * t82
  t88 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t13
  t89 = t72 * t88
  t90 = t78 ** 2
  t91 = 0.1e1 / t90
  t96 = -0.86308333333333333333333333333333333333333333333334e0 * t44 - 0.30192500000000000000000000000000000000000000000000e0 * t46 - 0.55016250000000000000000000000000000000000000000000e-1 * t50 - 0.82785000000000000000000000000000000000000000000000e-1 * t55
  t98 = 0.1e1 / t81
  t99 = t91 * t96 * t98
  t100 = t89 * t99
  t102 = jnp.log(0.2e1)
  t103 = 0.1e1 - t102
  t104 = jnp.pi ** 2
  t106 = t103 / t104
  t107 = t63 ** 2
  t108 = f.my_piecewise3(t62, t107, 1)
  t109 = t108 ** 2
  t110 = t109 * t108
  t112 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e-1 * t13
  t114 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t13
  t115 = 0.1e1 / t114
  t116 = t112 * t115
  t117 = 0.1e1 / t103
  t120 = 0.621814e-1 * t36 * t31
  t123 = 0.19751673498613801407483339618206552048944131217655e-1 * t72 * t88 * t82
  t126 = 0.1e1 / t110
  t127 = t104 * t126
  t129 = jnp.exp(-(-t120 + t123) * t117 * t127)
  t130 = t129 - 0.1e1
  t131 = 0.1e1 / t130
  t133 = t104 * t131 * s0
  t134 = t116 * t117 * t133
  t135 = r0 ** 2
  t136 = t7 * t135
  t137 = 0.1e1 / t136
  t139 = 0.1e1 / t109
  t141 = 0.1e1 / t3
  t143 = t19 * t141 * t5
  t147 = 0.1e1 + 0.27801896084645508333333333333333333333333333333333e-2 * t134 * t137 * t68 * t139 * t143
  t148 = t147 ** (0.1e1 / 0.4e1)
  t150 = 0.1e1 / t148 / t147
  t151 = t135 * r0
  t153 = 0.1e1 / t22 / t151
  t154 = t153 * t115
  t155 = t117 * t104
  t157 = t131 * s0
  t159 = t157 * t68 * t139
  t162 = t114 ** 2
  t163 = 0.1e1 / t162
  t164 = t112 * t163
  t165 = t164 * t155
  t171 = t103 ** 2
  t172 = 0.1e1 / t171
  t173 = t116 * t172
  t174 = t104 ** 2
  t175 = t130 ** 2
  t176 = 0.1e1 / t175
  t177 = t174 * t176
  t178 = s0 * t137
  t180 = t173 * t177 * t178
  t181 = t109 ** 2
  t183 = 0.1e1 / t181 / t108
  t185 = t68 * t183 * t19
  t186 = t141 * t5
  t187 = 0.11073470983333333333333333333333333333333333333333e-2 * t33
  t188 = 0.10000000000000000000000000000000000000000000000000e1 * t60
  t189 = 0.18311447306006545054854346104378990962041954983034e-3 * t85
  t190 = 0.58482236226346462072622386637590534819724553404280e0 * t100
  t191 = t187 + t188 - t189 - t190
  t194 = t185 * t186 * t191 * t129
  t197 = t7 * t151
  t198 = 0.1e1 / t197
  t204 = -0.27801896084645508333333333333333333333333333333333e-3 * t154 * t155 * t159 + 0.49431771238499713816666666666666666666666666666666e-3 * t165 * t157 * t153 * t68 * t139 + 0.27801896084645508333333333333333333333333333333333e-2 * t180 * t194 - 0.64871090864172852777777777777777777777777777777777e-2 * t134 * t198 * t68 * t139 * t143
  t205 = t150 * t204
  t209 = 0.1e1 - 0.1e1 / t148
  t212 = t127 * t129
  t215 = 0.25000000000000000000000000000000000000000000000000e0 * t205 * t130 - 0.10000000000000000000000000000000000000000000000000e1 * t209 * t191 * t117 * t212
  t219 = 0.1e1 + 0.10000000000000000000000000000000000000000000000000e1 * t209 * t130
  t220 = 0.1e1 / t219
  t222 = t106 * t110 * t215 * t220
  t224 = t135 ** 2
  t225 = t224 * r0
  t228 = 0.1e1 / t22 / t135
  t231 = tau0 * t53 - s0 * t228 / 0.8e1
  t232 = 0.0e0 < t231
  t233 = f.my_piecewise3(t232, t231, 0)
  t234 = t233 ** 2
  t235 = t234 * t233
  t236 = t225 * t235
  t237 = 6 ** (0.1e1 / 0.3e1)
  t238 = t237 ** 2
  t239 = t104 ** (0.1e1 / 0.3e1)
  t240 = t239 ** 2
  t241 = t238 * t240
  t244 = t68 ** 2
  t246 = 0.3e1 / 0.10e2 * t241 * t52 + 0.1e-3 * t244
  t247 = t246 ** 2
  t249 = 0.1e1 / t247 / t246
  t252 = 0.1e1 / t247 * t68
  t255 = 0.2e1 * t197 * t234 * t252 + 0.1e-2
  t256 = 0.1e1 / t255
  t257 = t249 * t256
  t259 = 0.4e1 * t236 * t257
  t260 = t259 <= 0.25e1
  t261 = 0.25e1 < t259
  t262 = t224 * t235
  t265 = t225 * t234
  t268 = s0 * t153
  t271 = f.my_piecewise3(t232, -0.5e1 / 0.3e1 * tau0 * t228 + t268 / 0.3e1, 0)
  t272 = t257 * t271
  t275 = t22 * t225
  t277 = t247 ** 2
  t278 = 0.1e1 / t277
  t279 = t275 * t235 * t278
  t281 = t256 * t238 * t240
  t284 = t255 ** 2
  t285 = 0.1e1 / t284
  t286 = t249 * t285
  t290 = t197 * t233
  t291 = t252 * t271
  t294 = t224 * t234
  t297 = t68 * t238 * t240
  t300 = 0.20e2 / 0.3e1 * t136 * t234 * t252 + 0.4e1 * t290 * t291 - 0.2e1 * t294 * t249 * t297
  t301 = t286 * t300
  t304 = -0.4e1 * t236 * t301 + 0.20e2 * t262 * t257 + 0.12e2 * t265 * t272 - 0.6e1 * t279 * t281
  t305 = f.my_piecewise3(t261, 0, t304)
  t307 = f.my_piecewise3(t261, 0.25e1, t259)
  t310 = t307 ** 2
  t313 = t310 * t307
  t316 = t310 ** 2
  t319 = t316 * t307
  t322 = t316 * t310
  t326 = f.my_piecewise3(t261, t259, 0.25e1)
  t327 = 0.1e1 - t326
  t328 = t327 ** 2
  t329 = 0.1e1 / t328
  t330 = f.my_piecewise3(t261, t304, 0)
  t334 = jnp.exp(0.15e1 / t327)
  t337 = f.my_piecewise3(t260, -0.64e0 * t305 - 0.8704e0 * t307 * t305 - 0.4607056813647e1 * t310 * t305 + 0.12246241008700e2 * t313 * t305 - 0.9578551181030e1 * t316 * t305 + 0.3101306810232e1 * t319 * t305 - 0.362942158544e0 * t322 * t305, -0.105e1 * t329 * t330 * t334)
  t340 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t14 + 0.31385250000000000000000000000000000000000000000000e-1 * t13
  t341 = 0.1e1 / t340
  t344 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t341)
  t345 = t344 - 0.1e1
  t346 = 0.1e1 / t240
  t347 = t237 * t346
  t348 = t244 * s0
  t352 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t347 * t348 * t228
  t353 = t352 ** (0.1e1 / 0.4e1)
  t355 = 0.1e1 - 0.1e1 / t353
  t357 = t345 * t355 + 0.1e1
  t358 = jnp.log(t357)
  t364 = 0.1e1 - 0.2363e1 * t69 * t67 * t71
  t366 = jnp.log(t219)
  t369 = (-0.285764e-1 * t341 + 0.285764e-1 * t358) * t364 + t120 - t123 - t106 * t110 * t366
  t382 = f.my_piecewise3(t260, 0.1e1 - 0.64e0 * t307 - 0.4352e0 * t310 - 0.1535685604549e1 * t313 + 0.3061560252175e1 * t316 - 0.1915710236206e1 * t319 + 0.516884468372e0 * t322 - 0.51848879792e-1 * t316 * t313, -0.7e0 * t334)
  t383 = t340 ** 2
  t384 = 0.1e1 / t383
  t387 = -0.74083333333333333333333333333333333333333333333333e-2 * t44 - 0.10461750000000000000000000000000000000000000000000e-1 * t46
  t388 = t384 * t387
  t390 = t344 * t355
  t394 = 0.1e1 / t353 / t352
  t396 = t345 * t394 * t237
  t397 = t346 * t244
  t401 = -0.10000000000000000000000000000000000000000000000000e1 * t388 * t390 - 0.14225094736250905555555555555555555555555555555555e-1 * t396 * t397 * t268
  t402 = 0.1e1 / t357
  t407 = (0.285764e-1 * t388 + 0.285764e-1 * t401 * t402) * t364 - t187 - t188 + t189 + t190 - t222
  t410 = t6 * t137
  t413 = 0.14764627977777777777777777777777777777777777777777e-2 * t4 * t410 * t31
  t414 = t4 * t6
  t418 = 0.35616666666666666666666666666666666666666666666666e-1 * t414 * t9 * t38 * t59
  t422 = t57 ** 2
  t425 = 0.20000000000000000000000000000000000000000000000000e1 * t36 / t37 / t27 * t422 * t58
  t430 = t20 * t5 * t228
  t431 = 0.1e1 / t14 / t13 * t19 * t430
  t433 = t42 * t137
  t434 = t41 * t433
  t436 = t4 * t410
  t438 = t13 ** (-0.5e0)
  t440 = t438 * t19 * t430
  t442 = t49 * t433
  t445 = t21 * t5 * t228
  t450 = 0.10000000000000000000000000000000000000000000000000e1 * t39 * (-0.42198333333333333333333333333333333333333333333333e0 * t431 + 0.84396666666666666666666666666666666666666666666666e0 * t434 + 0.39862222222222222222222222222222222222222222222223e0 * t436 + 0.68258333333333333333333333333333333333333333333333e-1 * t440 + 0.13651666666666666666666666666666666666666666666667e0 * t442 + 0.13692777777777777777777777777777777777777777777778e0 * t445) * t58
  t451 = t37 ** 2
  t454 = t30 ** 2
  t458 = 0.16081979498692535066756296899072713062105388428051e2 * t36 / t451 * t422 / t454
  t462 = 0.24415263074675393406472461472505321282722606644045e-3 * t73 * t42 * t137 * t82
  t466 = 0.10843581300301739842632067522386578331157260943710e-1 * t72 * t4 * t10 * t99
  t469 = t96 ** 2
  t473 = 0.11696447245269292414524477327518106963944910680856e1 * t89 / t90 / t78 * t469 * t98
  t484 = 0.58482236226346462072622386637590534819724553404280e0 * t89 * t91 * (-0.57538888888888888888888888888888888888888888888889e0 * t431 + 0.11507777777777777777777777777777777777777777777778e1 * t434 + 0.40256666666666666666666666666666666666666666666667e0 * t436 + 0.36677500000000000000000000000000000000000000000000e-1 * t440 + 0.73355000000000000000000000000000000000000000000000e-1 * t442 + 0.13797500000000000000000000000000000000000000000000e0 * t445) * t98
  t485 = t90 ** 2
  t488 = t81 ** 2
  t492 = 0.17315859105681463759666483083807725165579399831905e2 * t89 / t485 * t469 / t488
  t493 = t147 ** 2
  t496 = t204 ** 2
  t500 = t22 * t224
  t501 = 0.1e1 / t500
  t506 = 0.1e1 / t225
  t510 = s0 * t68
  t516 = t172 * t174 * t176
  t519 = t183 * t191 * t129
  t545 = t116 / t171 / t103
  t546 = t174 * t104
  t552 = t181 ** 2
  t555 = t68 / t552 * t19
  t556 = t191 ** 2
  t557 = t129 ** 2
  t568 = -t413 - t418 - t425 + t450 + t458 + t462 + t466 + t473 - t484 - t492
  t589 = 0.16681137650787305000000000000000000000000000000000e-2 * t501 * t115 * t155 * t159 - 0.82386285397499523027777777777777777777777777777777e-5 * t506 * t163 * t155 * t131 * t510 * t139 * t414 - 0.55603792169291016666666666666666666666666666666666e-3 * t154 * t516 * t510 * t519 + 0.14648281543675415194338888888888888888888888888889e-4 * t112 / t162 / t114 * t117 * t133 * t506 * t68 * t139 * t414 + 0.98863542476999427633333333333333333333333333333332e-3 * t164 * t516 * t268 * t68 * t519 - 0.29659062743099828290000000000000000000000000000000e-2 * t165 * t157 * t501 * t68 * t139 + 0.55603792169291016666666666666666666666666666666666e-2 * t545 * t546 / t175 / t130 * t178 * t555 * t186 * t556 * t557 - 0.12974218172834570555555555555555555555555555555555e-1 * t173 * t177 * s0 * t198 * t194 + 0.27801896084645508333333333333333333333333333333333e-2 * t180 * t185 * t186 * t568 * t129 - 0.27801896084645508333333333333333333333333333333333e-2 * t545 * t546 * t176 * t178 * t555 * t186 * t556 * t129 + 0.21623696954724284259259259259259259259259259259259e-1 * t134 / t7 / t224 * t68 * t139 * t143
  t613 = t106 * t110 * (-0.31250000000000000000000000000000000000000000000000e0 / t148 / t493 * t496 * t130 + 0.25000000000000000000000000000000000000000000000000e0 * t150 * t589 * t130 - 0.50000000000000000000000000000000000000000000000000e0 * t205 * t191 * t155 * t126 * t129 - 0.10000000000000000000000000000000000000000000000000e1 * t209 * t568 * t117 * t212 + 0.10000000000000000000000000000000000000000000000000e1 * t209 * t556 * t172 * t174 / t181 / t109 * t129) * t220
  t614 = t215 ** 2
  t616 = t219 ** 2
  t619 = t106 * t110 * t614 / t616
  t632 = t271 ** 2
  t649 = s0 * t501
  t652 = f.my_piecewise3(t232, 0.40e2 / 0.9e1 * tau0 * t153 - 0.11e2 / 0.9e1 * t649, 0)
  t663 = t239 * t104
  t675 = t300 ** 2
  t711 = 0.80e2 * t151 * t235 * t257 + 0.120e3 * t294 * t272 - 0.64e2 * t500 * t235 * t278 * t281 - 0.40e2 * t262 * t301 + 0.24e2 * t225 * t233 * t257 * t632 - 0.36e2 * t275 * t234 * t278 * t256 * t271 * t241 - 0.24e2 * t265 * t249 * t285 * t271 * t300 + 0.12e2 * t265 * t257 * t652 + 0.72e2 * t7 * t224 * t135 * t235 / t277 / t246 * t256 * t237 * t663 + 0.12e2 * t279 * t285 * t238 * t240 * t300 + 0.8e1 * t236 * t249 / t284 / t255 * t675 - 0.4e1 * t236 * t286 * (0.140e3 / 0.9e1 * t8 * t234 * t252 + 0.80e2 / 0.3e1 * t136 * t233 * t291 - 0.44e2 / 0.3e1 * t151 * t234 * t249 * t297 + 0.4e1 * t197 * t632 * t252 - 0.8e1 * t224 * t233 * t249 * t68 * t271 * t241 + 0.4e1 * t290 * t252 * t652 + 0.18e2 * t500 * t234 * t278 * t68 * t237 * t663)
  t712 = f.my_piecewise3(t261, 0, t711)
  t714 = t305 ** 2
  t738 = -0.64e0 * t712 - 0.8704e0 * t714 - 0.8704e0 * t307 * t712 - 0.9214113627294e1 * t307 * t714 - 0.4607056813647e1 * t310 * t712 + 0.36738723026100e2 * t310 * t714 + 0.12246241008700e2 * t313 * t712 - 0.38314204724120e2 * t313 * t714 - 0.9578551181030e1 * t316 * t712 + 0.15506534051160e2 * t316 * t714 + 0.3101306810232e1 * t319 * t712 - 0.2177652951264e1 * t319 * t714 - 0.362942158544e0 * t322 * t712
  t741 = t330 ** 2
  t745 = f.my_piecewise3(t261, t711, 0)
  t749 = t328 ** 2
  t755 = f.my_piecewise3(t260, t738, -0.210e1 / t328 / t327 * t741 * t334 - 0.105e1 * t329 * t745 * t334 - 0.1575e1 / t749 * t741 * t334)
  t761 = t387 ** 2
  t762 = 0.1e1 / t383 / t340 * t761
  t768 = t384 * (-0.49388888888888888888888888888888888888888888888889e-2 * t431 + 0.98777777777777777777777777777777777777777777777777e-2 * t434 + 0.13949000000000000000000000000000000000000000000000e-1 * t436)
  t774 = t383 ** 2
  t785 = t352 ** 2
  t792 = s0 ** 2
  t806 = t401 ** 2
  t807 = t357 ** 2
  t813 = (-0.571528e-1 * t762 + 0.285764e-1 * t768 + 0.285764e-1 * (0.20000000000000000000000000000000000000000000000000e1 * t762 * t390 - 0.10000000000000000000000000000000000000000000000000e1 * t768 * t390 + 0.10000000000000000000000000000000000000000000000000e1 / t774 * t761 * t390 + 0.28450189472501811111111111111111111111111111111110e-1 * t388 * t344 * t394 * t347 * t348 * t153 - 0.20235332025531322029119593137558641975308641975307e-2 * t345 / t353 / t785 * t238 / t663 * t68 * t792 / t7 / t224 / t151 + 0.52158680699586653703703703703703703703703703703702e-1 * t396 * t397 * t649) * t402 - 0.285764e-1 * t806 / t807) * t364 + t413 + t418 + t425 - t450 - t458 - t462 - t466 - t473 + t484 + t492 - t613 + t619
  t815 = 0.2e1 * t337 * t407 + t755 * t369 + t382 * t813 - t413 - t418 - t425 + t450 + t458 + t462 + t466 + t473 - t484 - t492 + t613 - t619
  v2rho2_0_ = 0.22146941966666666666666666666666666666666666666666e-2 * t33 + 0.20000000000000000000000000000000000000000000000000e1 * t60 - 0.36622894612013090109708692208757981924083909966068e-3 * t85 - 0.11696447245269292414524477327518106963944910680856e1 * t100 + 0.2e1 * t222 + 0.2e1 * t337 * t369 + 0.2e1 * t382 * t407 + r0 * t815
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t10 = t4 * t6 / t7
  t12 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t24 = t20 * t5 / t21
  t26 = 0.37978500000000000000000000000000000000000000000000e1 * t13 + 0.89690000000000000000000000000000000000000000000000e0 * t10 + 0.20477500000000000000000000000000000000000000000000e0 * t16 + 0.12323500000000000000000000000000000000000000000000e0 * t24
  t27 = t26 ** 2
  t29 = 0.1e1 / t27 / t26
  t30 = t12 * t29
  t32 = 0.1e1 / t13 * t1
  t33 = t3 * t6
  t34 = t7 * r0
  t35 = 0.1e1 / t34
  t36 = t33 * t35
  t37 = t32 * t36
  t39 = t6 * t35
  t40 = t4 * t39
  t42 = t10 ** 0.5e0
  t43 = t42 * t1
  t44 = t43 * t36
  t46 = t21 * r0
  t47 = 0.1e1 / t46
  t49 = t20 * t5 * t47
  t51 = -0.63297500000000000000000000000000000000000000000000e0 * t37 - 0.29896666666666666666666666666666666666666666666667e0 * t40 - 0.10238750000000000000000000000000000000000000000000e0 * t44 - 0.82156666666666666666666666666666666666666666666667e-1 * t49
  t52 = t51 ** 2
  t55 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t26
  t56 = 0.1e1 / t55
  t57 = t52 * t56
  t58 = t30 * t57
  t60 = 0.1e1 / t27
  t61 = t12 * t60
  t64 = 0.1e1 / t13 / t10 * t18
  t65 = t19 * t5
  t66 = r0 ** 2
  t68 = 0.1e1 / t21 / t66
  t69 = t65 * t68
  t70 = t64 * t69
  t72 = t7 * t66
  t73 = 0.1e1 / t72
  t74 = t33 * t73
  t75 = t32 * t74
  t77 = t6 * t73
  t78 = t4 * t77
  t80 = t10 ** (-0.5e0)
  t81 = t80 * t18
  t82 = t81 * t69
  t84 = t43 * t74
  t87 = t20 * t5 * t68
  t89 = -0.42198333333333333333333333333333333333333333333333e0 * t70 + 0.84396666666666666666666666666666666666666666666666e0 * t75 + 0.39862222222222222222222222222222222222222222222223e0 * t78 + 0.68258333333333333333333333333333333333333333333333e-1 * t82 + 0.13651666666666666666666666666666666666666666666667e0 * t84 + 0.13692777777777777777777777777777777777777777777778e0 * t87
  t90 = t89 * t56
  t91 = t61 * t90
  t93 = t27 ** 2
  t94 = 0.1e1 / t93
  t95 = t12 * t94
  t96 = t55 ** 2
  t97 = 0.1e1 / t96
  t98 = t52 * t97
  t99 = t95 * t98
  t101 = t66 ** 2
  t102 = t101 * r0
  t106 = tau0 * t47 - s0 * t68 / 0.8e1
  t107 = 0.0e0 < t106
  t108 = f.my_piecewise3(t107, t106, 0)
  t109 = t108 ** 2
  t110 = t109 * t108
  t111 = t102 * t110
  t112 = 6 ** (0.1e1 / 0.3e1)
  t113 = t112 ** 2
  t114 = jnp.pi ** 2
  t115 = t114 ** (0.1e1 / 0.3e1)
  t116 = t115 ** 2
  t117 = t113 * t116
  t120 = 2 ** (0.1e1 / 0.3e1)
  t121 = t120 ** 2
  t123 = 0.3e1 / 0.10e2 * t117 * t46 + 0.1e-3 * t121
  t124 = t123 ** 2
  t126 = 0.1e1 / t124 / t123
  t127 = t66 * r0
  t128 = t7 * t127
  t131 = 0.1e1 / t124 * t120
  t134 = 0.2e1 * t128 * t109 * t131 + 0.1e-2
  t135 = 0.1e1 / t134
  t136 = t126 * t135
  t138 = 0.4e1 * t111 * t136
  t139 = t138 <= 0.25e1
  t140 = 0.25e1 < t138
  t141 = f.my_piecewise3(t140, 0.25e1, t138)
  t143 = t141 ** 2
  t145 = t143 * t141
  t147 = t143 ** 2
  t149 = t147 * t141
  t151 = t147 * t143
  t156 = f.my_piecewise3(t140, t138, 0.25e1)
  t157 = 0.1e1 - t156
  t160 = jnp.exp(0.15e1 / t157)
  t162 = f.my_piecewise3(t139, 0.1e1 - 0.64e0 * t141 - 0.4352e0 * t143 - 0.1535685604549e1 * t145 + 0.3061560252175e1 * t147 - 0.1915710236206e1 * t149 + 0.516884468372e0 * t151 - 0.51848879792e-1 * t147 * t145, -0.7e0 * t160)
  t165 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t13 + 0.31385250000000000000000000000000000000000000000000e-1 * t10
  t166 = t165 ** 2
  t168 = 0.1e1 / t166 / t165
  t171 = -0.74083333333333333333333333333333333333333333333333e-2 * t37 - 0.10461750000000000000000000000000000000000000000000e-1 * t40
  t172 = t171 ** 2
  t173 = t168 * t172
  t175 = 0.1e1 / t166
  t179 = -0.49388888888888888888888888888888888888888888888889e-2 * t70 + 0.98777777777777777777777777777777777777777777777777e-2 * t75 + 0.13949000000000000000000000000000000000000000000000e-1 * t78
  t180 = t175 * t179
  t182 = 0.1e1 / t165
  t184 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t182)
  t185 = 0.1e1 / t116
  t186 = t112 * t185
  t187 = t121 * s0
  t191 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t186 * t187 * t68
  t192 = t191 ** (0.1e1 / 0.4e1)
  t194 = 0.1e1 - 0.1e1 / t192
  t195 = t184 * t194
  t200 = t166 ** 2
  t201 = 0.1e1 / t200
  t202 = t201 * t172
  t205 = t175 * t171
  t207 = 0.1e1 / t192 / t191
  t208 = t184 * t207
  t209 = t205 * t208
  t210 = t21 * t127
  t211 = 0.1e1 / t210
  t213 = t186 * t187 * t211
  t216 = t184 - 0.1e1
  t217 = t191 ** 2
  t219 = 0.1e1 / t192 / t217
  t221 = t216 * t219 * t113
  t222 = t115 * t114
  t223 = 0.1e1 / t222
  t224 = t223 * t120
  t225 = s0 ** 2
  t226 = t101 * t127
  t228 = 0.1e1 / t7 / t226
  t234 = t216 * t207 * t112
  t235 = t185 * t121
  t236 = t21 * t101
  t237 = 0.1e1 / t236
  t238 = s0 * t237
  t242 = 0.20000000000000000000000000000000000000000000000000e1 * t173 * t195 - 0.10000000000000000000000000000000000000000000000000e1 * t180 * t195 + 0.10000000000000000000000000000000000000000000000000e1 * t202 * t195 + 0.28450189472501811111111111111111111111111111111110e-1 * t209 * t213 - 0.20235332025531322029119593137558641975308641975307e-2 * t221 * t224 * t225 * t228 + 0.52158680699586653703703703703703703703703703703702e-1 * t234 * t235 * t238
  t244 = t216 * t194 + 0.1e1
  t245 = 0.1e1 / t244
  t250 = s0 * t211
  t254 = -0.10000000000000000000000000000000000000000000000000e1 * t205 * t195 - 0.14225094736250905555555555555555555555555555555555e-1 * t234 * t235 * t250
  t255 = t254 ** 2
  t256 = t244 ** 2
  t257 = 0.1e1 / t256
  t261 = t120 - 0.1e1
  t262 = 0.1e1 <= f.p.zeta_threshold
  t263 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t265 = f.my_piecewise3(t262, t263 * f.p.zeta_threshold, 1)
  t267 = 0.2e1 * t265 - 0.2e1
  t270 = 0.1e1 / t261 / 0.2e1
  t273 = 0.1e1 - 0.2363e1 * t261 * t267 * t270
  t275 = jnp.log(t55)
  t277 = t4 * t77 * t275
  t278 = 0.14764627977777777777777777777777777777777777777777e-2 * t277
  t279 = t4 * t6
  t280 = t35 * t60
  t281 = t51 * t56
  t283 = t279 * t280 * t281
  t284 = 0.35616666666666666666666666666666666666666666666666e-1 * t283
  t285 = 0.20000000000000000000000000000000000000000000000000e1 * t58
  t286 = 0.10000000000000000000000000000000000000000000000000e1 * t91
  t287 = 0.16081979498692535066756296899072713062105388428051e2 * t99
  t288 = t267 * t270
  t289 = t288 * t1
  t294 = 0.51785000000000000000000000000000000000000000000000e1 * t13 + 0.90577500000000000000000000000000000000000000000000e0 * t10 + 0.11003250000000000000000000000000000000000000000000e0 * t16 + 0.12417750000000000000000000000000000000000000000000e0 * t24
  t297 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t294
  t298 = jnp.log(t297)
  t301 = t289 * t33 * t73 * t298
  t302 = 0.24415263074675393406472461472505321282722606644045e-3 * t301
  t303 = t288 * t4
  t304 = t294 ** 2
  t305 = 0.1e1 / t304
  t310 = -0.86308333333333333333333333333333333333333333333334e0 * t37 - 0.30192500000000000000000000000000000000000000000000e0 * t40 - 0.55016250000000000000000000000000000000000000000000e-1 * t44 - 0.82785000000000000000000000000000000000000000000000e-1 * t49
  t312 = 0.1e1 / t297
  t313 = t305 * t310 * t312
  t315 = t303 * t39 * t313
  t316 = 0.10843581300301739842632067522386578331157260943710e-1 * t315
  t318 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t10
  t319 = t288 * t318
  t321 = 0.1e1 / t304 / t294
  t322 = t310 ** 2
  t324 = t321 * t322 * t312
  t325 = t319 * t324
  t326 = 0.11696447245269292414524477327518106963944910680856e1 * t325
  t333 = -0.57538888888888888888888888888888888888888888888889e0 * t70 + 0.11507777777777777777777777777777777777777777777778e1 * t75 + 0.40256666666666666666666666666666666666666666666667e0 * t78 + 0.36677500000000000000000000000000000000000000000000e-1 * t82 + 0.73355000000000000000000000000000000000000000000000e-1 * t84 + 0.13797500000000000000000000000000000000000000000000e0 * t87
  t335 = t305 * t333 * t312
  t336 = t319 * t335
  t337 = 0.58482236226346462072622386637590534819724553404280e0 * t336
  t338 = t304 ** 2
  t339 = 0.1e1 / t338
  t341 = t297 ** 2
  t342 = 0.1e1 / t341
  t343 = t339 * t322 * t342
  t344 = t319 * t343
  t345 = 0.17315859105681463759666483083807725165579399831905e2 * t344
  t346 = jnp.log(0.2e1)
  t347 = 0.1e1 - t346
  t349 = t347 / t114
  t350 = t263 ** 2
  t351 = f.my_piecewise3(t262, t350, 1)
  t352 = t351 ** 2
  t353 = t352 * t351
  t355 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e-1 * t10
  t357 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t10
  t358 = 0.1e1 / t357
  t359 = t355 * t358
  t360 = 0.1e1 / t347
  t363 = 0.621814e-1 * t12 * t275
  t366 = 0.19751673498613801407483339618206552048944131217655e-1 * t288 * t318 * t298
  t369 = 0.1e1 / t353
  t370 = t114 * t369
  t372 = jnp.exp(-(-t363 + t366) * t360 * t370)
  t373 = t372 - 0.1e1
  t374 = 0.1e1 / t373
  t376 = t114 * t374 * s0
  t377 = t359 * t360 * t376
  t379 = 0.1e1 / t352
  t381 = 0.1e1 / t3
  t382 = t18 * t381
  t383 = t382 * t5
  t387 = 0.1e1 + 0.27801896084645508333333333333333333333333333333333e-2 * t377 * t73 * t120 * t379 * t383
  t388 = t387 ** 2
  t389 = t387 ** (0.1e1 / 0.4e1)
  t391 = 0.1e1 / t389 / t388
  t392 = t211 * t358
  t393 = t360 * t114
  t395 = t374 * s0
  t397 = t395 * t120 * t379
  t400 = t357 ** 2
  t401 = 0.1e1 / t400
  t402 = t355 * t401
  t403 = t402 * t393
  t409 = t347 ** 2
  t410 = 0.1e1 / t409
  t411 = t359 * t410
  t412 = t114 ** 2
  t413 = t373 ** 2
  t414 = 0.1e1 / t413
  t415 = t412 * t414
  t416 = s0 * t73
  t418 = t411 * t415 * t416
  t419 = t352 ** 2
  t421 = 0.1e1 / t419 / t351
  t422 = t120 * t421
  t423 = t422 * t18
  t424 = t381 * t5
  t427 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t39 * t275
  t429 = 0.10000000000000000000000000000000000000000000000000e1 * t61 * t281
  t433 = 0.18311447306006545054854346104378990962041954983034e-3 * t289 * t33 * t35 * t298
  t435 = 0.58482236226346462072622386637590534819724553404280e0 * t319 * t313
  t436 = t427 + t429 - t433 - t435
  t437 = t436 * t372
  t439 = t423 * t424 * t437
  t442 = 0.1e1 / t128
  t448 = -0.27801896084645508333333333333333333333333333333333e-3 * t392 * t393 * t397 + 0.49431771238499713816666666666666666666666666666666e-3 * t403 * t395 * t211 * t120 * t379 + 0.27801896084645508333333333333333333333333333333333e-2 * t418 * t439 - 0.64871090864172852777777777777777777777777777777777e-2 * t377 * t442 * t120 * t379 * t383
  t449 = t448 ** 2
  t450 = t391 * t449
  t454 = 0.1e1 / t389 / t387
  t455 = t237 * t358
  t459 = 0.1e1 / t102
  t460 = t459 * t401
  t461 = t393 * t374
  t463 = s0 * t120
  t464 = t463 * t379
  t465 = t464 * t279
  t468 = t410 * t412
  t469 = t468 * t414
  t470 = t392 * t469
  t472 = t421 * t436 * t372
  t473 = t463 * t472
  t477 = 0.1e1 / t400 / t357
  t478 = t355 * t477
  t480 = t478 * t360 * t376
  t486 = t402 * t469
  t487 = t250 * t120
  t497 = 0.1e1 / t409 / t347
  t498 = t359 * t497
  t499 = t412 * t114
  t501 = 0.1e1 / t413 / t373
  t502 = t499 * t501
  t504 = t498 * t502 * t416
  t505 = t419 ** 2
  t506 = 0.1e1 / t505
  t507 = t120 * t506
  t508 = t507 * t18
  t509 = t436 ** 2
  t510 = t372 ** 2
  t513 = t508 * t424 * t509 * t510
  t516 = s0 * t442
  t518 = t411 * t415 * t516
  t521 = -t278 - t284 - t285 + t286 + t287 + t302 + t316 + t326 - t337 - t345
  t524 = t423 * t424 * t521 * t372
  t527 = t499 * t414
  t529 = t498 * t527 * t416
  t532 = t508 * t424 * t509 * t372
  t536 = 0.1e1 / t7 / t101
  t542 = 0.16681137650787305000000000000000000000000000000000e-2 * t455 * t393 * t397 - 0.82386285397499523027777777777777777777777777777777e-5 * t460 * t461 * t465 - 0.55603792169291016666666666666666666666666666666666e-3 * t470 * t473 + 0.14648281543675415194338888888888888888888888888889e-4 * t480 * t459 * t120 * t379 * t279 + 0.98863542476999427633333333333333333333333333333332e-3 * t486 * t487 * t472 - 0.29659062743099828290000000000000000000000000000000e-2 * t403 * t395 * t237 * t120 * t379 + 0.55603792169291016666666666666666666666666666666666e-2 * t504 * t513 - 0.12974218172834570555555555555555555555555555555555e-1 * t518 * t439 + 0.27801896084645508333333333333333333333333333333333e-2 * t418 * t524 - 0.27801896084645508333333333333333333333333333333333e-2 * t529 * t532 + 0.21623696954724284259259259259259259259259259259259e-1 * t377 * t536 * t120 * t379 * t383
  t543 = t454 * t542
  t546 = t454 * t448
  t549 = t393 * t369 * t372
  t553 = 0.1e1 - 0.1e1 / t389
  t554 = t553 * t521
  t556 = t370 * t372
  t562 = 0.1e1 / t419 / t352
  t563 = t412 * t562
  t567 = -0.31250000000000000000000000000000000000000000000000e0 * t450 * t373 + 0.25000000000000000000000000000000000000000000000000e0 * t543 * t373 - 0.50000000000000000000000000000000000000000000000000e0 * t546 * t436 * t549 - 0.10000000000000000000000000000000000000000000000000e1 * t554 * t360 * t556 + 0.10000000000000000000000000000000000000000000000000e1 * t553 * t509 * t410 * t563 * t372
  t571 = 0.1e1 + 0.10000000000000000000000000000000000000000000000000e1 * t553 * t373
  t572 = 0.1e1 / t571
  t574 = t349 * t353 * t567 * t572
  t581 = 0.25000000000000000000000000000000000000000000000000e0 * t546 * t373 - 0.10000000000000000000000000000000000000000000000000e1 * t553 * t436 * t360 * t556
  t582 = t581 ** 2
  t584 = t571 ** 2
  t585 = 0.1e1 / t584
  t587 = t349 * t353 * t582 * t585
  t588 = (-0.571528e-1 * t173 + 0.285764e-1 * t180 + 0.285764e-1 * t242 * t245 - 0.285764e-1 * t255 * t257) * t273 + t278 + t284 + t285 - t286 - t287 - t302 - t316 - t326 + t337 + t345 - t574 + t587
  t591 = t101 * t110
  t594 = t102 * t109
  t599 = f.my_piecewise3(t107, -0.5e1 / 0.3e1 * tau0 * t68 + t250 / 0.3e1, 0)
  t600 = t136 * t599
  t603 = t21 * t102
  t605 = t124 ** 2
  t606 = 0.1e1 / t605
  t607 = t603 * t110 * t606
  t609 = t135 * t113 * t116
  t612 = t134 ** 2
  t613 = 0.1e1 / t612
  t614 = t126 * t613
  t618 = t128 * t108
  t619 = t131 * t599
  t622 = t101 * t109
  t623 = t622 * t126
  t625 = t120 * t113 * t116
  t628 = 0.20e2 / 0.3e1 * t72 * t109 * t131 + 0.4e1 * t618 * t619 - 0.2e1 * t623 * t625
  t629 = t614 * t628
  t632 = -0.4e1 * t111 * t629 + 0.20e2 * t591 * t136 + 0.12e2 * t594 * t600 - 0.6e1 * t607 * t609
  t633 = f.my_piecewise3(t140, 0, t632)
  t635 = t141 * t633
  t637 = t143 * t633
  t639 = t145 * t633
  t641 = t147 * t633
  t643 = t149 * t633
  t648 = t157 ** 2
  t649 = 0.1e1 / t648
  t650 = f.my_piecewise3(t140, t632, 0)
  t654 = f.my_piecewise3(t139, -0.64e0 * t633 - 0.8704e0 * t635 - 0.4607056813647e1 * t637 + 0.12246241008700e2 * t639 - 0.9578551181030e1 * t641 + 0.3101306810232e1 * t643 - 0.362942158544e0 * t151 * t633, -0.105e1 * t649 * t650 * t160)
  t663 = (0.285764e-1 * t205 + 0.285764e-1 * t254 * t245) * t273 - t427 - t429 + t433 + t435 - t349 * t353 * t581 * t572
  t669 = 0.48245938496077605200268890697218139186316165284153e2 * t95 * t89 * t97 * t51
  t672 = 0.32530743900905219527896202567159734993471782831130e-1 * t303 * t39 * t324
  t675 = 0.21687162600603479685264135044773156662314521887420e-1 * t303 * t77 * t313
  t678 = 0.16265371950452609763948101283579867496735891415565e-1 * t303 * t39 * t335
  t681 = 0.48159733137676571081572406076840235616767705782485e0 * t303 * t39 * t343
  t684 = 0.60000000000000000000000000000000000000000000000000e1 * t30 * t281 * t89
  t685 = t6 * t442
  t688 = 0.34450798614814814814814814814814814814814814814813e-2 * t4 * t685 * t275
  t693 = 0.3e1 * t349 * t353 * t567 * t585 * t581
  t694 = t599 ** 2
  t705 = t72 * t108
  t708 = t127 * t109
  t715 = t101 * t108
  t716 = t715 * t126
  t717 = t120 * t599
  t718 = t717 * t117
  t725 = f.my_piecewise3(t107, 0.40e2 / 0.9e1 * tau0 * t211 - 0.11e2 / 0.9e1 * t238, 0)
  t726 = t131 * t725
  t730 = t236 * t109 * t606
  t732 = t120 * t112 * t222
  t735 = 0.140e3 / 0.9e1 * t34 * t109 * t131 + 0.80e2 / 0.3e1 * t705 * t619 - 0.44e2 / 0.3e1 * t708 * t126 * t625 + 0.4e1 * t128 * t694 * t131 - 0.8e1 * t716 * t718 + 0.4e1 * t618 * t726 + 0.18e2 * t730 * t732
  t736 = t614 * t735
  t741 = 0.1e1 / t603
  t742 = s0 * t741
  t745 = f.my_piecewise3(t107, -0.440e3 / 0.27e2 * tau0 * t237 + 0.154e3 / 0.27e2 * t742, 0)
  t756 = t612 ** 2
  t759 = t628 ** 2
  t766 = t127 * t110
  t769 = t136 * t725
  t773 = 0.1e1 / t612 / t134
  t775 = t126 * t773 * t759
  t778 = t136 * t694
  t786 = t594 * t126
  t791 = t7 * t102
  t794 = 0.1e1 / t605 / t123
  t797 = t135 * t112 * t222
  t800 = t102 * t108
  t801 = t800 * t126
  t806 = 0.24e2 * t102 * t694 * t599 * t136 + 0.240e3 * t66 * t110 * t136 - 0.60e2 * t591 * t736 + 0.12e2 * t594 * t136 * t745 - 0.1080e4 * t226 * t110 / t605 / t124 * t135 * t412 - 0.24e2 * t111 * t126 / t756 * t759 * t628 + 0.720e3 * t708 * t600 - 0.240e3 * t766 * t629 + 0.180e3 * t622 * t769 + 0.120e3 * t591 * t775 + 0.360e3 * t715 * t778 + 0.24e2 * t111 * t126 * t773 * t628 * t735 + 0.72e2 * t786 * t773 * t599 * t759 + 0.1224e4 * t791 * t110 * t794 * t797 - 0.72e2 * t801 * t613 * t694 * t628
  t807 = t135 * t599
  t815 = t613 * t599
  t823 = t815 * t628
  t858 = t112 * t222
  t874 = 0.560e3 / 0.27e2 * t7 * t109 * t131 + 0.280e3 / 0.3e1 * t34 * t108 * t619 - 0.536e3 / 0.9e1 * t66 * t109 * t126 * t625 + 0.40e2 * t72 * t694 * t131 - 0.88e2 * t127 * t108 * t126 * t718 + 0.40e2 * t705 * t726 + 0.216e3 * t210 * t109 * t606 * t732 + 0.12e2 * t128 * t599 * t726 - 0.12e2 * t101 * t694 * t126 * t625 + 0.108e3 * t236 * t108 * t606 * t717 * t858 - 0.12e2 * t716 * t120 * t725 * t117 + 0.4e1 * t618 * t131 * t745 - 0.216e3 * t791 * t109 * t794 * t120 * t412
  t884 = t603 * t109
  t885 = t884 * t606
  t890 = t101 * t66
  t891 = t7 * t890
  t898 = t891 * t110 * t794
  t904 = t613 * t113
  t909 = t807 * t117
  t913 = t236 * t110 * t606
  t914 = t116 * t628
  t915 = t904 * t914
  t929 = 0.72e2 * t801 * t807 * t725 - 0.36e2 * t786 * t613 * t725 * t628 - 0.36e2 * t786 * t815 * t735 - 0.1256e4 / 0.3e1 * t210 * t110 * t606 * t609 - 0.360e3 * t623 * t823 - 0.4e1 * t111 * t614 * t874 - 0.108e3 * t603 * t108 * t606 * t135 * t694 * t117 - 0.54e2 * t885 * t135 * t725 * t117 + 0.648e3 * t891 * t109 * t794 * t807 * t858 - 0.216e3 * t898 * t613 * t112 * t222 * t628 + 0.18e2 * t607 * t904 * t116 * t735 - 0.576e3 * t730 * t909 + 0.192e3 * t913 * t915 - 0.36e2 * t607 * t773 * t113 * t116 * t759 + 0.108e3 * t884 * t606 * t613 * t599 * t113 * t914
  t930 = t806 + t929
  t931 = f.my_piecewise3(t140, 0, t930)
  t957 = -0.4e1 * t111 * t736 + 0.8e1 * t111 * t775 + 0.80e2 * t766 * t136 - 0.40e2 * t591 * t629 + 0.12e2 * t594 * t769 + 0.120e3 * t622 * t600 + 0.12e2 * t607 * t915 - 0.64e2 * t913 * t609 + 0.24e2 * t800 * t778 - 0.24e2 * t786 * t823 + 0.72e2 * t898 * t797 - 0.36e2 * t885 * t909
  t958 = f.my_piecewise3(t140, 0, t957)
  t963 = t633 ** 2
  t964 = t963 * t633
  t994 = -0.64e0 * t931 - 0.26112e1 * t633 * t958 - 0.8704e0 * t141 * t931 - 0.9214113627294e1 * t964 - 0.27642340881882e2 * t635 * t958 - 0.4607056813647e1 * t143 * t931 + 0.73477446052200e2 * t141 * t964 + 0.110216169078300e3 * t637 * t958 + 0.12246241008700e2 * t145 * t931 - 0.114942614172360e3 * t143 * t964 - 0.114942614172360e3 * t639 * t958 - 0.9578551181030e1 * t147 * t931 + 0.62026136204640e2 * t145 * t964 + 0.46519602153480e2 * t641 * t958 + 0.3101306810232e1 * t149 * t931 - 0.10888264756320e2 * t147 * t964 - 0.6532958853792e1 * t643 * t958 - 0.362942158544e0 * t151 * t931
  t995 = t648 ** 2
  t996 = 0.1e1 / t995
  t997 = t650 ** 2
  t998 = t997 * t650
  t1003 = 0.1e1 / t648 / t157
  t1005 = f.my_piecewise3(t140, t957, 0)
  t1014 = f.my_piecewise3(t140, t930, 0)
  t1028 = f.my_piecewise3(t139, t994, -0.630e1 * t996 * t998 * t160 - 0.630e1 * t1003 * t650 * t160 * t1005 - 0.9450e1 / t995 / t157 * t998 * t160 - 0.105e1 * t649 * t1014 * t160 - 0.4725e1 * t996 * t1005 * t650 * t160 - 0.23625e1 / t995 / t648 * t998 * t160)
  t1030 = jnp.log(t244)
  t1034 = jnp.log(t571)
  t1037 = (-0.285764e-1 * t182 + 0.285764e-1 * t1030) * t273 + t363 - t366 - t349 * t353 * t1034
  t1063 = -0.64e0 * t958 - 0.8704e0 * t963 - 0.8704e0 * t141 * t958 - 0.9214113627294e1 * t141 * t963 - 0.4607056813647e1 * t143 * t958 + 0.36738723026100e2 * t143 * t963 + 0.12246241008700e2 * t145 * t958 - 0.38314204724120e2 * t145 * t963 - 0.9578551181030e1 * t147 * t958 + 0.15506534051160e2 * t147 * t963 + 0.3101306810232e1 * t149 * t958 - 0.2177652951264e1 * t149 * t963 - 0.362942158544e0 * t151 * t958
  t1074 = f.my_piecewise3(t139, t1063, -0.210e1 * t1003 * t997 * t160 - 0.105e1 * t649 * t1005 * t160 - 0.1575e1 * t996 * t997 * t160)
  t1080 = 0.10685000000000000000000000000000000000000000000000e0 * t279 * t35 * t29 * t57
  t1084 = 0.56968947174242584615102410102512416326352748836105e-3 * t289 * t33 * t442 * t298
  t1089 = 0.35089341735807877243573431982554320891834732042568e1 * t319 * t321 * t310 * t312 * t333
  t1094 = 0.51947577317044391278999449251423175496738199495715e2 * t319 * t339 * t333 * t342 * t310
  t1095 = t1028 * t1037 + 0.3e1 * t1074 * t663 + t1080 - t1084 + t1089 - t1094 + t669 - t672 - t675 + t678 + t681 - t684 + t688 - t693
  t1099 = 0.71233333333333333333333333333333333333333333333331e-1 * t279 * t73 * t60 * t281
  t1102 = 0.53424999999999999999999999999999999999999999999999e-1 * t279 * t280 * t90
  t1106 = 0.85917975471764868594145516183295969534298037676861e0 * t279 * t35 * t94 * t98
  t1113 = 0.1e1 / t101
  t1114 = 0.1e1 / t13 / t24 * t2 * t1113 / 0.4e1
  t1116 = t65 * t211
  t1117 = t64 * t1116
  t1119 = t33 * t442
  t1120 = t32 * t1119
  t1122 = t4 * t685
  t1124 = t10 ** (-0.15e1)
  t1126 = t1124 * t2 * t1113
  t1128 = t81 * t1116
  t1130 = t43 * t1119
  t1133 = t20 * t5 * t211
  t1138 = 0.10000000000000000000000000000000000000000000000000e1 * t61 * (-0.25319000000000000000000000000000000000000000000000e1 * t1114 + 0.16879333333333333333333333333333333333333333333333e1 * t1117 - 0.19692555555555555555555555555555555555555555555555e1 * t1120 - 0.93011851851851851851851851851851851851851851851854e0 * t1122 + 0.13651666666666666666666666666666666666666666666667e0 * t1126 - 0.27303333333333333333333333333333333333333333333333e0 * t1128 - 0.31853888888888888888888888888888888888888888888890e0 * t1130 - 0.36514074074074074074074074074074074074074074074075e0 * t1133) * t56
  t1142 = t52 * t51
  t1147 = 0.51726012919273400298984252201052768390886626637712e3 * t12 / t93 / t27 * t1142 / t96 / t55
  t1153 = 0.96491876992155210400537781394436278372632330568306e2 * t12 / t93 / t26 * t1142 * t97
  t1160 = 0.2e1 * t349 * t353 * t582 * t581 / t584 / t571
  t1163 = t322 * t310
  t1167 = 0.10389515463408878255799889850284635099347639899143e3 * t319 / t338 / t294 * t1163 * t342
  t1180 = 0.58482236226346462072622386637590534819724553404280e0 * t319 * t305 * (-0.34523333333333333333333333333333333333333333333333e1 * t1114 + 0.23015555555555555555555555555555555555555555555556e1 * t1117 - 0.26851481481481481481481481481481481481481481481482e1 * t1120 - 0.93932222222222222222222222222222222222222222222223e0 * t1122 + 0.73355000000000000000000000000000000000000000000000e-1 * t1126 - 0.14671000000000000000000000000000000000000000000000e0 * t1128 - 0.17116166666666666666666666666666666666666666666667e0 * t1130 - 0.36793333333333333333333333333333333333333333333333e0 * t1133) * t312
  t1184 = 0.35089341735807877243573431982554320891834732042568e1 * t319 * t339 * t1163 * t312
  t1192 = 0.10254018858216406658218194626490193680059335835414e4 * t319 / t338 / t304 * t1163 / t341 / t297
  t1195 = 0.60000000000000000000000000000000000000000000000000e1 * t95 * t1142 * t56
  t1196 = -t669 + t672 + t675 - t678 - t681 + t684 - t688 + t693 - t1080 + t1084 - t1089 + t1094 - t1099
  t1197 = t172 * t171
  t1198 = t201 * t1197
  t1200 = t168 * t171
  t1208 = t175 * (-0.29633333333333333333333333333333333333333333333333e-1 * t1114 + 0.19755555555555555555555555555555555555555555555555e-1 * t1117 - 0.23048148148148148148148148148148148148148148148148e-1 * t1120 - 0.32547666666666666666666666666666666666666666666667e-1 * t1122)
  t1260 = t101 ** 2
  t1275 = -0.60000000000000000000000000000000000000000000000000e1 * t1198 * t195 + 0.60000000000000000000000000000000000000000000000000e1 * t1200 * t195 * t179 - 0.60000000000000000000000000000000000000000000000000e1 / t200 / t165 * t1197 * t195 - 0.85350568417505433333333333333333333333333333333330e-1 * t173 * t208 * t213 - 0.10000000000000000000000000000000000000000000000000e1 * t1208 * t195 + 0.30000000000000000000000000000000000000000000000000e1 * t201 * t179 * t171 * t184 * t194 + 0.42675284208752716666666666666666666666666666666665e-1 * t180 * t208 * t213 - 0.10000000000000000000000000000000000000000000000000e1 / t200 / t166 * t1197 * t195 - 0.42675284208752716666666666666666666666666666666665e-1 * t202 * t208 * t213 + 0.60705996076593966087358779412675925925925925925921e-2 * t205 * t184 * t219 * t113 * t223 * t120 * t225 * t228 - 0.15647604209875996111111111111111111111111111111110e0 * t209 * t186 * t187 * t237 - 0.31087747628928898252912838668079770391184269901849e-2 * t216 / t192 / t217 / t191 / t412 * t225 * s0 / t1260 / t127 + 0.22258865228084454232031552451314506172839506172838e-1 * t221 * t224 * t225 / t7 / t1260 - 0.24340717659807105061728395061728395061728395061728e0 * t234 * t235 * t742
  t1313 = t422 * t1 * t33 * t437
  t1316 = t409 ** 2
  t1318 = t359 / t1316
  t1319 = t412 ** 2
  t1320 = t413 ** 2
  t1328 = t120 / t505 / t353 * t18
  t1329 = t509 * t436
  t1350 = -t672 + t1195 - t684 + t688 - t675 + t678 + t681 + t1080 - t1084 - t1192 + t1167
  t1351 = -t1180 + t669 - t1184 + t1089 - t1094 + t1099 - t1102 - t1106 - t1153 + t1138 + t1147
  t1352 = t1350 + t1351
  t1375 = t497 * t499
  t1376 = t1375 * t501
  t1378 = t506 * t509
  t1379 = t1378 * t510
  t1383 = t1375 * t414
  t1385 = t1378 * t372
  t1393 = 0.17685589265329897609962962962962962962962962962963e-1 * t403 * t395 * t741 * t120 * t379 + 0.43944844631026245583016666666666666666666666666667e-4 * t478 * t410 * t415 * s0 * t459 * t1313 + 0.16681137650787305000000000000000000000000000000000e-1 * t1318 * t1319 / t1320 * t416 * t1328 * t424 * t1329 * t510 * t372 - 0.16681137650787305000000000000000000000000000000000e-1 * t1318 * t1319 * t501 * t416 * t1328 * t424 * t1329 * t510 - 0.19461327259251855833333333333333333333333333333333e-1 * t518 * t524 + 0.19461327259251855833333333333333333333333333333333e-1 * t498 * t527 * t516 * t532 + 0.27801896084645508333333333333333333333333333333333e-2 * t418 * t423 * t424 * t1352 * t372 + 0.27801896084645508333333333333333333333333333333333e-2 * t1318 * t1319 * t414 * t416 * t1328 * t424 * t1329 * t372 - 0.38922654518503711666666666666666666666666666666665e-1 * t498 * t502 * t516 * t513 + 0.64871090864172852777777777777777777777777777777776e-1 * t411 * t415 * s0 * t536 * t439 - 0.16681137650787305000000000000000000000000000000000e-2 * t392 * t1376 * t463 * t1379 + 0.83405688253936524999999999999999999999999999999999e-3 * t392 * t1383 * t463 * t1385 - 0.14829531371549914145000000000000000000000000000000e-2 * t402 * t1383 * t487 * t1385
  t1394 = 0.1e1 / t890
  t1403 = 0.1e1 / t891
  t1406 = t20 * t5
  t1411 = t421 * t521 * t372
  t1425 = t400 ** 2
  t1446 = t507 * t382
  t1467 = 0.90624913937249475330555555555555555555555555555555e-4 * t1394 * t401 * t461 * t465 - 0.88977188229299484869999999999999999999999999999999e-2 * t486 * t238 * t120 * t472 - 0.14648281543675415194338888888888888888888888888889e-5 * t1403 * t477 * t461 * t464 * t1406 + 0.14829531371549914145000000000000000000000000000000e-2 * t486 * t487 * t1411 + 0.29659062743099828289999999999999999999999999999999e-2 * t402 * t1376 * t487 * t1379 + 0.50043412952361914999999999999999999999999999999999e-2 * t455 * t469 * t473 - 0.83405688253936524999999999999999999999999999999999e-3 * t470 * t463 * t1411 + 0.26044644584654888215534544444444444444444444444445e-5 * t355 / t1425 * t360 * t376 * t1403 * t120 * t379 * t1406 - 0.93702686803805231790123456790123456790123456790122e-1 * t377 / t791 * t120 * t379 * t383 - 0.16113109698042956713772777777777777777777777777778e-3 * t480 * t1394 * t120 * t379 * t279 - 0.83405688253936524999999999999999999999999999999999e-2 * t529 * t1446 * t5 * t521 * t437 + 0.16681137650787305000000000000000000000000000000000e-1 * t504 * t1446 * t5 * t436 * t510 * t521 - 0.99469005991731707592592592592592592592592592592592e-2 * t741 * t358 * t393 * t397 - 0.24715885619249856908333333333333333333333333333334e-4 * t460 * t410 * t415 * s0 * t1313
  t1502 = t349 * t353 * (0.70312500000000000000000000000000000000000000000000e0 / t389 / t388 / t387 * t449 * t448 * t373 - 0.93750000000000000000000000000000000000000000000000e0 * t391 * t448 * t373 * t542 + 0.93750000000000000000000000000000000000000000000000e0 * t450 * t436 * t549 + 0.25000000000000000000000000000000000000000000000000e0 * t454 * (t1393 + t1467) * t373 - 0.75000000000000000000000000000000000000000000000000e0 * t543 * t436 * t549 - 0.75000000000000000000000000000000000000000000000000e0 * t546 * t521 * t549 + 0.75000000000000000000000000000000000000000000000000e0 * t546 * t509 * t468 * t562 * t372 - 0.10000000000000000000000000000000000000000000000000e1 * t553 * t1352 * t360 * t556 + 0.30000000000000000000000000000000000000000000000000e1 * t554 * t410 * t563 * t437 - 0.10000000000000000000000000000000000000000000000000e1 * t553 * t1329 * t497 * t499 / t505 / t351 * t372) * t572
  t1503 = t1102 + t1106 - t1138 - t1147 + t1153 - t1160 - t1167 + t1180 + t1184 + t1192 + (0.1714584e0 * t1198 - 0.1714584e0 * t1200 * t179 + 0.285764e-1 * t1208 + 0.285764e-1 * t1275 * t245 - 0.857292e-1 * t242 * t257 * t254 + 0.571528e-1 * t255 * t254 / t256 / t244) * t273 - t1195 - t1502
  t1506 = t1099 - t1102 - t1106 + 0.3e1 * t654 * t588 + t1138 + t1147 - t1153 + t1160 + t1167 - t1180 - t1184 - t1192 + t1195 + t162 * (t1196 + t1503) + t1502
  v3rho3_0_ = -0.60000000000000000000000000000000000000000000000000e1 * t58 + 0.30000000000000000000000000000000000000000000000000e1 * t91 + 0.48245938496077605200268890697218139186316165284153e2 * t99 + 0.3e1 * t162 * t588 + 0.6e1 * t654 * t663 + r0 * (t1095 + t1506) + 0.32530743900905219527896202567159734993471782831130e-1 * t315 + 0.3e1 * t1074 * t1037 - 0.3e1 * t587 - 0.10685000000000000000000000000000000000000000000000e0 * t283 + 0.73245789224026180219417384417515963848167819932136e-3 * t301 + 0.3e1 * t574 + 0.35089341735807877243573431982554320891834732042568e1 * t325 - 0.17544670867903938621786715991277160445917366021284e1 * t336 - 0.51947577317044391278999449251423175496738199495715e2 * t344 - 0.44293883933333333333333333333333333333333333333332e-2 * t277

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** 2
  t2 = t1 ** 2
  t3 = t2 * r0
  t4 = r0 ** (0.1e1 / 0.3e1)
  t5 = t4 ** 2
  t6 = t5 * r0
  t7 = 0.1e1 / t6
  t9 = t5 * t1
  t10 = 0.1e1 / t9
  t13 = tau0 * t7 - s0 * t10 / 0.8e1
  t14 = 0.0e0 < t13
  t15 = f.my_piecewise3(t14, t13, 0)
  t16 = t15 ** 2
  t17 = t16 * t15
  t18 = t3 * t17
  t19 = 6 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = jnp.pi ** 2
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = t20 * t23
  t27 = 2 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t30 = 0.3e1 / 0.10e2 * t24 * t6 + 0.1e-3 * t28
  t31 = t30 ** 2
  t32 = t31 * t30
  t33 = 0.1e1 / t32
  t34 = t1 * r0
  t35 = t4 * t34
  t38 = 0.1e1 / t31 * t27
  t41 = 0.2e1 * t35 * t16 * t38 + 0.1e-2
  t42 = 0.1e1 / t41
  t43 = t33 * t42
  t45 = 0.4e1 * t18 * t43
  t46 = t45 <= 0.25e1
  t47 = 0.25e1 < t45
  t48 = t5 * t3
  t49 = t48 * t16
  t50 = t31 ** 2
  t51 = 0.1e1 / t50
  t52 = t41 ** 2
  t53 = 0.1e1 / t52
  t54 = t51 * t53
  t55 = t49 * t54
  t58 = t5 * t34
  t59 = 0.1e1 / t58
  t60 = s0 * t59
  t63 = f.my_piecewise3(t14, -0.5e1 / 0.3e1 * tau0 * t10 + t60 / 0.3e1, 0)
  t64 = t63 * t20
  t65 = t4 * t1
  t69 = t35 * t15
  t70 = t38 * t63
  t73 = t2 * t16
  t74 = t73 * t33
  t76 = t27 * t20 * t23
  t79 = 0.20e2 / 0.3e1 * t65 * t16 * t38 + 0.4e1 * t69 * t70 - 0.2e1 * t74 * t76
  t80 = t23 * t79
  t81 = t64 * t80
  t84 = t3 * t16
  t85 = t84 * t33
  t86 = t53 * t63
  t87 = t4 * r0
  t91 = t65 * t15
  t94 = t34 * t16
  t95 = t94 * t33
  t98 = t63 ** 2
  t102 = t2 * t15
  t103 = t102 * t33
  t104 = t27 * t63
  t105 = t104 * t24
  t110 = t5 * t2
  t111 = 0.1e1 / t110
  t112 = s0 * t111
  t115 = f.my_piecewise3(t14, 0.40e2 / 0.9e1 * tau0 * t59 - 0.11e2 / 0.9e1 * t112, 0)
  t116 = t38 * t115
  t119 = t110 * t16
  t120 = t119 * t51
  t122 = t22 * t21
  t123 = t27 * t19 * t122
  t126 = 0.140e3 / 0.9e1 * t87 * t16 * t38 + 0.80e2 / 0.3e1 * t91 * t70 - 0.44e2 / 0.3e1 * t95 * t76 + 0.4e1 * t35 * t98 * t38 - 0.8e1 * t103 * t105 + 0.4e1 * t69 * t116 + 0.18e2 * t120 * t123
  t127 = t86 * t126
  t131 = t58 * t17 * t51
  t133 = t42 * t20 * t23
  t136 = t86 * t79
  t139 = t18 * t33
  t141 = 0.1e1 / t52 / t41
  t142 = t141 * t79
  t143 = t142 * t126
  t146 = t141 * t63
  t147 = t79 ** 2
  t148 = t146 * t147
  t151 = t4 * t3
  t154 = 0.1e1 / t50 / t30
  t155 = t151 * t17 * t154
  t157 = t42 * t19 * t122
  t160 = t3 * t15
  t161 = t160 * t33
  t162 = t53 * t98
  t163 = t162 * t79
  t166 = t42 * t63
  t167 = t166 * t115
  t170 = t53 * t115
  t171 = t170 * t79
  t174 = t48 * t17
  t175 = t174 * t51
  t176 = t53 * t20
  t177 = t23 * t126
  t178 = t176 * t177
  t182 = t23 * t147
  t183 = t141 * t20 * t182
  t186 = t166 * t24
  t190 = t110 * t17 * t51
  t191 = t176 * t80
  t194 = t48 * t15
  t196 = t42 * t98
  t197 = t196 * t24
  t200 = 0.108e3 * t55 * t81 - 0.36e2 * t85 * t127 - 0.1256e4 / 0.3e1 * t131 * t133 - 0.360e3 * t74 * t136 + 0.24e2 * t139 * t143 + 0.72e2 * t85 * t148 + 0.1224e4 * t155 * t157 - 0.72e2 * t161 * t163 + 0.72e2 * t161 * t167 - 0.36e2 * t85 * t171 + 0.18e2 * t175 * t178 - 0.36e2 * t175 * t183 - 0.576e3 * t120 * t186 + 0.192e3 * t190 * t191 - 0.108e3 * t194 * t51 * t197
  t201 = t49 * t51
  t202 = t42 * t115
  t203 = t202 * t24
  t206 = t2 * t1
  t207 = t4 * t206
  t208 = t207 * t16
  t209 = t208 * t154
  t210 = t19 * t122
  t211 = t166 * t210
  t215 = t207 * t17 * t154
  t216 = t53 * t19
  t217 = t122 * t79
  t218 = t216 * t217
  t221 = t2 * t17
  t222 = t33 * t53
  t223 = t222 * t126
  t228 = 0.1e1 / t48
  t229 = s0 * t228
  t232 = f.my_piecewise3(t14, -0.440e3 / 0.27e2 * tau0 * t111 + 0.154e3 / 0.27e2 * t229, 0)
  t233 = t43 * t232
  t236 = t2 * t34
  t237 = t236 * t17
  t239 = 0.1e1 / t50 / t31
  t241 = t21 ** 2
  t242 = t239 * t42 * t241
  t245 = t43 * t63
  t248 = t34 * t17
  t249 = t222 * t79
  t252 = t43 * t115
  t255 = t52 ** 2
  t256 = 0.1e1 / t255
  t258 = t147 * t79
  t259 = t33 * t256 * t258
  t262 = t33 * t141
  t263 = t262 * t147
  t266 = t43 * t98
  t272 = t87 * t15
  t275 = t1 * t16
  t282 = t34 * t15
  t283 = t282 * t33
  t289 = t58 * t16 * t51
  t292 = t35 * t63
  t300 = t110 * t15 * t51
  t301 = t104 * t210
  t304 = t27 * t115
  t305 = t304 * t24
  t308 = t38 * t232
  t311 = t151 * t16
  t313 = t154 * t27 * t241
  t316 = 0.560e3 / 0.27e2 * t4 * t16 * t38 + 0.280e3 / 0.3e1 * t272 * t70 - 0.536e3 / 0.9e1 * t275 * t33 * t76 + 0.40e2 * t65 * t98 * t38 - 0.88e2 * t283 * t105 + 0.40e2 * t91 * t116 + 0.216e3 * t289 * t123 + 0.12e2 * t292 * t116 - 0.12e2 * t2 * t98 * t33 * t76 + 0.108e3 * t300 * t301 - 0.12e2 * t103 * t305 + 0.4e1 * t69 * t308 - 0.216e3 * t311 * t313
  t317 = t222 * t316
  t320 = t98 * t63
  t321 = t3 * t320
  t324 = t1 * t17
  t327 = 0.360e3 * t102 * t266 - 0.24e2 * t18 * t259 - 0.4e1 * t18 * t317 - 0.54e2 * t201 * t203 + 0.648e3 * t209 * t211 - 0.216e3 * t215 * t218 - 0.60e2 * t221 * t223 + 0.120e3 * t221 * t263 + 0.12e2 * t233 * t84 - 0.1080e4 * t237 * t242 + 0.720e3 * t245 * t94 - 0.240e3 * t248 * t249 + 0.180e3 * t252 * t73 + 0.24e2 * t321 * t43 + 0.240e3 * t324 * t43
  t328 = t200 + t327
  t329 = f.my_piecewise3(t47, 0, t328)
  t339 = -0.6e1 * t133 * t175 - 0.4e1 * t18 * t249 + 0.20e2 * t221 * t43 + 0.12e2 * t245 * t84
  t340 = f.my_piecewise3(t47, 0, t339)
  t365 = -0.64e2 * t133 * t190 - 0.24e2 * t136 * t85 + 0.72e2 * t157 * t215 + 0.24e2 * t160 * t266 + 0.12e2 * t175 * t191 - 0.4e1 * t18 * t223 + 0.8e1 * t18 * t263 - 0.36e2 * t186 * t201 - 0.40e2 * t221 * t249 + 0.120e3 * t245 * t73 + 0.80e2 * t248 * t43 + 0.12e2 * t252 * t84
  t366 = f.my_piecewise3(t47, 0, t365)
  t369 = f.my_piecewise3(t47, 0.25e1, t45)
  t372 = t340 ** 2
  t373 = t372 * t340
  t375 = t369 * t340
  t378 = t369 ** 2
  t383 = t378 * t340
  t386 = t378 * t369
  t391 = t386 * t340
  t394 = t378 ** 2
  t399 = t394 * t340
  t402 = t394 * t369
  t407 = t402 * t340
  t410 = t394 * t378
  t413 = -0.64e0 * t329 - 0.26112e1 * t340 * t366 - 0.8704e0 * t369 * t329 - 0.9214113627294e1 * t373 - 0.27642340881882e2 * t375 * t366 - 0.4607056813647e1 * t378 * t329 + 0.73477446052200e2 * t369 * t373 + 0.110216169078300e3 * t383 * t366 + 0.12246241008700e2 * t386 * t329 - 0.114942614172360e3 * t378 * t373 - 0.114942614172360e3 * t391 * t366 - 0.9578551181030e1 * t394 * t329 + 0.62026136204640e2 * t386 * t373 + 0.46519602153480e2 * t399 * t366 + 0.3101306810232e1 * t402 * t329 - 0.10888264756320e2 * t394 * t373 - 0.6532958853792e1 * t407 * t366 - 0.362942158544e0 * t410 * t329
  t414 = f.my_piecewise3(t47, t45, 0.25e1)
  t415 = 0.1e1 - t414
  t416 = t415 ** 2
  t417 = t416 ** 2
  t418 = 0.1e1 / t417
  t419 = f.my_piecewise3(t47, t339, 0)
  t420 = t419 ** 2
  t421 = t420 * t419
  t425 = jnp.exp(0.15e1 / t415)
  t428 = t416 * t415
  t429 = 0.1e1 / t428
  t430 = t429 * t419
  t431 = f.my_piecewise3(t47, t365, 0)
  t432 = t425 * t431
  t436 = 0.1e1 / t417 / t415
  t440 = 0.1e1 / t416
  t441 = f.my_piecewise3(t47, t328, 0)
  t446 = t419 * t425
  t450 = 0.1e1 / t417 / t416
  t455 = f.my_piecewise3(t46, t413, -0.630e1 * t418 * t421 * t425 - 0.630e1 * t430 * t432 - 0.9450e1 * t436 * t421 * t425 - 0.105e1 * t440 * t441 * t425 - 0.4725e1 * t418 * t431 * t446 - 0.23625e1 * t450 * t421 * t425)
  t456 = 3 ** (0.1e1 / 0.3e1)
  t457 = 0.1e1 / jnp.pi
  t458 = t457 ** (0.1e1 / 0.3e1)
  t459 = t456 * t458
  t460 = 4 ** (0.1e1 / 0.3e1)
  t461 = t460 ** 2
  t464 = t459 * t461 / t4
  t465 = jnp.sqrt(t464)
  t468 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t465 + 0.31385250000000000000000000000000000000000000000000e-1 * t464
  t469 = 0.1e1 / t468
  t472 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t469)
  t473 = t472 - 0.1e1
  t474 = 0.1e1 / t23
  t475 = t19 * t474
  t476 = t28 * s0
  t480 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t475 * t476 * t10
  t481 = t480 ** (0.1e1 / 0.4e1)
  t483 = 0.1e1 - 0.1e1 / t481
  t485 = t473 * t483 + 0.1e1
  t486 = jnp.log(t485)
  t489 = t27 - 0.1e1
  t490 = 0.1e1 <= f.p.zeta_threshold
  t491 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t493 = f.my_piecewise3(t490, t491 * f.p.zeta_threshold, 1)
  t495 = 0.2e1 * t493 - 0.2e1
  t498 = 0.1e1 / t489 / 0.2e1
  t501 = 0.1e1 - 0.2363e1 * t489 * t495 * t498
  t504 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t464
  t507 = t464 ** 0.15e1
  t509 = t456 ** 2
  t510 = t458 ** 2
  t511 = t509 * t510
  t512 = 0.1e1 / t5
  t514 = t511 * t460 * t512
  t516 = 0.37978500000000000000000000000000000000000000000000e1 * t465 + 0.89690000000000000000000000000000000000000000000000e0 * t464 + 0.20477500000000000000000000000000000000000000000000e0 * t507 + 0.12323500000000000000000000000000000000000000000000e0 * t514
  t519 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t516
  t520 = jnp.log(t519)
  t522 = 0.621814e-1 * t504 * t520
  t523 = t495 * t498
  t525 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t464
  t530 = 0.51785000000000000000000000000000000000000000000000e1 * t465 + 0.90577500000000000000000000000000000000000000000000e0 * t464 + 0.11003250000000000000000000000000000000000000000000e0 * t507 + 0.12417750000000000000000000000000000000000000000000e0 * t514
  t533 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t530
  t534 = jnp.log(t533)
  t537 = 0.19751673498613801407483339618206552048944131217655e-1 * t523 * t525 * t534
  t538 = jnp.log(0.2e1)
  t539 = 0.1e1 - t538
  t541 = t539 / t21
  t542 = t491 ** 2
  t543 = f.my_piecewise3(t490, t542, 1)
  t544 = t543 ** 2
  t545 = t544 * t543
  t547 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e-1 * t464
  t549 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t464
  t550 = 0.1e1 / t549
  t551 = t547 * t550
  t552 = 0.1e1 / t539
  t556 = 0.1e1 / t545
  t557 = t21 * t556
  t559 = jnp.exp(-(-t522 + t537) * t552 * t557)
  t560 = t559 - 0.1e1
  t561 = 0.1e1 / t560
  t563 = t21 * t561 * s0
  t564 = t551 * t552 * t563
  t565 = 0.1e1 / t65
  t567 = 0.1e1 / t544
  t569 = 0.1e1 / t458
  t570 = t509 * t569
  t571 = t570 * t460
  t575 = 0.1e1 + 0.27801896084645508333333333333333333333333333333333e-2 * t564 * t565 * t27 * t567 * t571
  t576 = t575 ** (0.1e1 / 0.4e1)
  t578 = 0.1e1 - 0.1e1 / t576
  t581 = 0.1e1 + 0.10000000000000000000000000000000000000000000000000e1 * t578 * t560
  t582 = jnp.log(t581)
  t585 = (-0.285764e-1 * t469 + 0.285764e-1 * t486) * t501 + t522 - t537 - t541 * t545 * t582
  t588 = t523 * t525
  t589 = t530 ** 2
  t590 = t589 ** 2
  t592 = 0.1e1 / t590 / t589
  t594 = 0.1e1 / t465 * t456
  t595 = t458 * t461
  t596 = 0.1e1 / t87
  t597 = t595 * t596
  t598 = t594 * t597
  t600 = t461 * t596
  t601 = t459 * t600
  t603 = t464 ** 0.5e0
  t604 = t603 * t456
  t605 = t604 * t597
  t608 = t511 * t460 * t7
  t610 = -0.86308333333333333333333333333333333333333333333334e0 * t598 - 0.30192500000000000000000000000000000000000000000000e0 * t601 - 0.55016250000000000000000000000000000000000000000000e-1 * t605 - 0.82785000000000000000000000000000000000000000000000e-1 * t608
  t611 = t610 ** 2
  t612 = t611 * t610
  t614 = t533 ** 2
  t616 = 0.1e1 / t614 / t533
  t617 = t592 * t612 * t616
  t618 = t588 * t617
  t621 = 0.1e1 / t590 / t530
  t623 = 0.1e1 / t614
  t624 = t621 * t612 * t623
  t625 = t588 * t624
  t627 = 0.1e1 / t589
  t631 = 0.1e1 / t465 / t514 * t457 / 0.4e1
  t632 = 0.1e1 / t2
  t633 = t631 * t632
  t637 = 0.1e1 / t465 / t464 * t509
  t638 = t510 * t460
  t639 = t638 * t59
  t640 = t637 * t639
  t642 = 0.1e1 / t35
  t643 = t595 * t642
  t644 = t594 * t643
  t646 = t461 * t642
  t647 = t459 * t646
  t649 = t464 ** (-0.15e1)
  t650 = t649 * t457
  t651 = t650 * t632
  t653 = t464 ** (-0.5e0)
  t654 = t653 * t509
  t655 = t654 * t639
  t657 = t604 * t643
  t660 = t511 * t460 * t59
  t662 = -0.34523333333333333333333333333333333333333333333333e1 * t633 + 0.23015555555555555555555555555555555555555555555556e1 * t640 - 0.26851481481481481481481481481481481481481481481482e1 * t644 - 0.93932222222222222222222222222222222222222222222223e0 * t647 + 0.73355000000000000000000000000000000000000000000000e-1 * t651 - 0.14671000000000000000000000000000000000000000000000e0 * t655 - 0.17116166666666666666666666666666666666666666666667e0 * t657 - 0.36793333333333333333333333333333333333333333333333e0 * t660
  t664 = 0.1e1 / t533
  t665 = t627 * t662 * t664
  t666 = t588 * t665
  t668 = 0.1e1 / t590
  t670 = t668 * t612 * t664
  t671 = t588 * t670
  t673 = t589 * t530
  t674 = 0.1e1 / t673
  t676 = t638 * t10
  t677 = t637 * t676
  t679 = t595 * t565
  t680 = t594 * t679
  t682 = t461 * t565
  t683 = t459 * t682
  t685 = t654 * t676
  t687 = t604 * t679
  t690 = t511 * t460 * t10
  t692 = -0.57538888888888888888888888888888888888888888888889e0 * t677 + 0.11507777777777777777777777777777777777777777777778e1 * t680 + 0.40256666666666666666666666666666666666666666666667e0 * t683 + 0.36677500000000000000000000000000000000000000000000e-1 * t685 + 0.73355000000000000000000000000000000000000000000000e-1 * t687 + 0.13797500000000000000000000000000000000000000000000e0 * t690
  t693 = t664 * t692
  t695 = t588 * t674 * t610 * t693
  t698 = t623 * t610
  t700 = t588 * t668 * t692 * t698
  t702 = t459 * t461
  t703 = t516 ** 2
  t704 = 0.1e1 / t703
  t705 = t565 * t704
  t710 = -0.63297500000000000000000000000000000000000000000000e0 * t598 - 0.29896666666666666666666666666666666666666666666667e0 * t601 - 0.10238750000000000000000000000000000000000000000000e0 * t605 - 0.82156666666666666666666666666666666666666666666667e-1 * t608
  t711 = 0.1e1 / t519
  t712 = t710 * t711
  t714 = t702 * t705 * t712
  t716 = t596 * t704
  t723 = -0.42198333333333333333333333333333333333333333333333e0 * t677 + 0.84396666666666666666666666666666666666666666666666e0 * t680 + 0.39862222222222222222222222222222222222222222222223e0 * t683 + 0.68258333333333333333333333333333333333333333333333e-1 * t685 + 0.13651666666666666666666666666666666666666666666667e0 * t687 + 0.13692777777777777777777777777777777777777777777778e0 * t690
  t724 = t723 * t711
  t726 = t702 * t716 * t724
  t728 = t703 ** 2
  t729 = 0.1e1 / t728
  t730 = t596 * t729
  t731 = t710 ** 2
  t732 = t519 ** 2
  t733 = 0.1e1 / t732
  t734 = t731 * t733
  t736 = t702 * t730 * t734
  t738 = t703 * t516
  t739 = 0.1e1 / t738
  t741 = t731 * t711
  t743 = t702 * t596 * t739 * t741
  t745 = t523 * t456
  t748 = t745 * t595 * t642 * t534
  t750 = t504 * t729
  t751 = t731 * t710
  t752 = t751 * t711
  t753 = t750 * t752
  t756 = 0.1e1 / t728 / t703
  t757 = t504 * t756
  t759 = 0.1e1 / t732 / t519
  t760 = t751 * t759
  t761 = t757 * t760
  t763 = t541 * t545
  t764 = t575 ** 2
  t766 = 0.1e1 / t576 / t764
  t767 = t59 * t550
  t768 = t552 * t21
  t770 = t561 * s0
  t772 = t770 * t27 * t567
  t775 = t549 ** 2
  t776 = 0.1e1 / t775
  t777 = t547 * t776
  t778 = t777 * t768
  t779 = t59 * t27
  t784 = t539 ** 2
  t785 = 0.1e1 / t784
  t786 = t551 * t785
  t787 = t560 ** 2
  t788 = 0.1e1 / t787
  t789 = t241 * t788
  t790 = s0 * t565
  t792 = t786 * t789 * t790
  t793 = t544 ** 2
  t795 = 0.1e1 / t793 / t543
  t796 = t27 * t795
  t797 = t796 * t509
  t798 = t569 * t460
  t801 = 0.11073470983333333333333333333333333333333333333333e-2 * t459 * t600 * t520
  t802 = t504 * t704
  t804 = 0.10000000000000000000000000000000000000000000000000e1 * t802 * t712
  t808 = 0.18311447306006545054854346104378990962041954983034e-3 * t745 * t595 * t596 * t534
  t810 = t627 * t610 * t664
  t812 = 0.58482236226346462072622386637590534819724553404280e0 * t588 * t810
  t813 = t801 + t804 - t808 - t812
  t814 = t813 * t559
  t816 = t797 * t798 * t814
  t824 = -0.27801896084645508333333333333333333333333333333333e-3 * t767 * t768 * t772 + 0.49431771238499713816666666666666666666666666666666e-3 * t778 * t770 * t779 * t567 + 0.27801896084645508333333333333333333333333333333333e-2 * t792 * t816 - 0.64871090864172852777777777777777777777777777777777e-2 * t564 * t642 * t27 * t567 * t571
  t825 = t824 ** 2
  t826 = t766 * t825
  t830 = 0.1e1 / t576 / t575
  t831 = t111 * t550
  t835 = 0.1e1 / t3
  t836 = t835 * t776
  t837 = t768 * t561
  t839 = s0 * t27
  t840 = t839 * t567
  t841 = t840 * t702
  t844 = t785 * t241
  t845 = t844 * t788
  t846 = t767 * t845
  t848 = t795 * t813 * t559
  t849 = t839 * t848
  t853 = 0.1e1 / t775 / t549
  t854 = t547 * t853
  t856 = t854 * t552 * t563
  t862 = t777 * t845
  t863 = t60 * t27
  t873 = 0.1e1 / t784 / t539
  t874 = t551 * t873
  t875 = t241 * t21
  t877 = 0.1e1 / t787 / t560
  t878 = t875 * t877
  t880 = t874 * t878 * t790
  t881 = t793 ** 2
  t882 = 0.1e1 / t881
  t883 = t27 * t882
  t884 = t883 * t509
  t885 = t813 ** 2
  t886 = t559 ** 2
  t887 = t885 * t886
  t889 = t884 * t798 * t887
  t892 = s0 * t642
  t894 = t786 * t789 * t892
  t899 = 0.14764627977777777777777777777777777777777777777777e-2 * t459 * t682 * t520
  t902 = 0.35616666666666666666666666666666666666666666666666e-1 * t702 * t716 * t712
  t903 = t504 * t739
  t905 = 0.20000000000000000000000000000000000000000000000000e1 * t903 * t741
  t907 = 0.10000000000000000000000000000000000000000000000000e1 * t802 * t724
  t909 = 0.16081979498692535066756296899072713062105388428051e2 * t750 * t734
  t913 = 0.24415263074675393406472461472505321282722606644045e-3 * t745 * t595 * t565 * t534
  t914 = t523 * t459
  t917 = 0.10843581300301739842632067522386578331157260943710e-1 * t914 * t600 * t810
  t919 = t674 * t611 * t664
  t921 = 0.11696447245269292414524477327518106963944910680856e1 * t588 * t919
  t923 = t627 * t692 * t664
  t925 = 0.58482236226346462072622386637590534819724553404280e0 * t588 * t923
  t926 = t668 * t611
  t927 = t926 * t623
  t929 = 0.17315859105681463759666483083807725165579399831905e2 * t588 * t927
  t930 = -t899 - t902 - t905 + t907 + t909 + t913 + t917 + t921 - t925 - t929
  t931 = t930 * t559
  t933 = t797 * t798 * t931
  t936 = t875 * t788
  t938 = t874 * t936 * t790
  t939 = t885 * t559
  t941 = t884 * t798 * t939
  t944 = t4 * t2
  t945 = 0.1e1 / t944
  t951 = 0.16681137650787305000000000000000000000000000000000e-2 * t831 * t768 * t772 - 0.82386285397499523027777777777777777777777777777777e-5 * t836 * t837 * t841 - 0.55603792169291016666666666666666666666666666666666e-3 * t846 * t849 + 0.14648281543675415194338888888888888888888888888889e-4 * t856 * t835 * t27 * t567 * t702 + 0.98863542476999427633333333333333333333333333333332e-3 * t862 * t863 * t848 - 0.29659062743099828290000000000000000000000000000000e-2 * t778 * t770 * t111 * t27 * t567 + 0.55603792169291016666666666666666666666666666666666e-2 * t880 * t889 - 0.12974218172834570555555555555555555555555555555555e-1 * t894 * t816 + 0.27801896084645508333333333333333333333333333333333e-2 * t792 * t933 - 0.27801896084645508333333333333333333333333333333333e-2 * t938 * t941 + 0.21623696954724284259259259259259259259259259259259e-1 * t564 * t945 * t27 * t567 * t571
  t952 = t830 * t951
  t955 = t830 * t824
  t958 = t768 * t556 * t559
  t961 = t578 * t930
  t963 = t557 * t559
  t968 = t793 * t544
  t969 = 0.1e1 / t968
  t970 = t241 * t969
  t971 = t970 * t559
  t974 = -0.31250000000000000000000000000000000000000000000000e0 * t826 * t560 + 0.25000000000000000000000000000000000000000000000000e0 * t952 * t560 - 0.50000000000000000000000000000000000000000000000000e0 * t955 * t813 * t958 - 0.10000000000000000000000000000000000000000000000000e1 * t961 * t552 * t963 + 0.10000000000000000000000000000000000000000000000000e1 * t578 * t885 * t785 * t971
  t975 = t581 ** 2
  t976 = 0.1e1 / t975
  t984 = 0.25000000000000000000000000000000000000000000000000e0 * t955 * t560 - 0.10000000000000000000000000000000000000000000000000e1 * t578 * t813 * t552 * t963
  t986 = t763 * t974 * t976 * t984
  t988 = 0.4e1 * t455 * t585 - 0.41016075432865626632872778505960774720237343341655e4 * t618 + 0.41558061853635513023199559401138540397390559596572e3 * t625 - 0.23392894490538584829048954655036213927889821361712e1 * t666 - 0.14035736694323150897429372793021728356733892817027e2 * t671 + 0.14035736694323150897429372793021728356733892817027e2 * t695 - 0.20779030926817756511599779700569270198695279798286e3 * t700 + 0.28493333333333333333333333333333333333333333333333e0 * t714 - 0.21370000000000000000000000000000000000000000000000e0 * t726 - 0.34367190188705947437658206473318387813719215070744e1 * t736 + 0.42740000000000000000000000000000000000000000000000e0 * t743 - 0.22787578869697033846040964041004966530541099534442e-2 * t748 + 0.24000000000000000000000000000000000000000000000000e2 * t753 + 0.20690405167709360119593700880421107356354650655085e4 * t761 - 0.12e2 * t986
  t999 = f.my_piecewise3(t46, 0.1e1 - 0.64e0 * t369 - 0.4352e0 * t378 - 0.1535685604549e1 * t386 + 0.3061560252175e1 * t394 - 0.1915710236206e1 * t402 + 0.516884468372e0 * t410 - 0.51848879792e-1 * t394 * t386, -0.7e0 * t425)
  t1000 = 0.10254018858216406658218194626490193680059335835414e4 * t618
  t1001 = 0.10389515463408878255799889850284635099347639899143e3 * t625
  t1002 = 0.58482236226346462072622386637590534819724553404280e0 * t666
  t1003 = 0.35089341735807877243573431982554320891834732042568e1 * t671
  t1004 = 0.35089341735807877243573431982554320891834732042568e1 * t695
  t1005 = 0.51947577317044391278999449251423175496738199495715e2 * t700
  t1006 = 0.71233333333333333333333333333333333333333333333331e-1 * t714
  t1007 = 0.53424999999999999999999999999999999999999999999999e-1 * t726
  t1008 = 0.85917975471764868594145516183295969534298037676861e0 * t736
  t1009 = 0.10685000000000000000000000000000000000000000000000e0 * t743
  t1010 = 0.56968947174242584615102410102512416326352748836105e-3 * t748
  t1011 = 0.60000000000000000000000000000000000000000000000000e1 * t753
  t1012 = 0.51726012919273400298984252201052768390886626637712e3 * t761
  t1013 = t1000 - t1001 + t1002 + t1003 - t1004 + t1005 - t1006 + t1007 + t1008 - t1009 + t1010 - t1011 - t1012
  t1015 = t468 ** 2
  t1016 = t1015 ** 2
  t1017 = 0.1e1 / t1016
  t1020 = -0.74083333333333333333333333333333333333333333333333e-2 * t598 - 0.10461750000000000000000000000000000000000000000000e-1 * t601
  t1021 = t1020 ** 2
  t1022 = t1021 * t1020
  t1023 = t1017 * t1022
  t1025 = t1015 * t468
  t1026 = 0.1e1 / t1025
  t1027 = t1026 * t1020
  t1031 = -0.49388888888888888888888888888888888888888888888889e-2 * t677 + 0.98777777777777777777777777777777777777777777777777e-2 * t680 + 0.13949000000000000000000000000000000000000000000000e-1 * t683
  t1034 = 0.1e1 / t1015
  t1039 = -0.29633333333333333333333333333333333333333333333333e-1 * t633 + 0.19755555555555555555555555555555555555555555555555e-1 * t640 - 0.23048148148148148148148148148148148148148148148148e-1 * t644 - 0.32547666666666666666666666666666666666666666666667e-1 * t647
  t1040 = t1034 * t1039
  t1042 = t472 * t483
  t1045 = t1042 * t1031
  t1049 = 0.1e1 / t1016 / t468
  t1050 = t1049 * t1022
  t1053 = t1026 * t1021
  t1055 = 0.1e1 / t481 / t480
  t1056 = t472 * t1055
  t1057 = t1053 * t1056
  t1059 = t475 * t476 * t59
  t1064 = t1017 * t1031
  t1065 = t1020 * t472
  t1066 = t1065 * t483
  t1069 = t1034 * t1031
  t1070 = t1069 * t1056
  t1074 = 0.1e1 / t1016 / t1015
  t1075 = t1074 * t1022
  t1078 = t1017 * t1021
  t1079 = t1078 * t1056
  t1082 = t1034 * t1020
  t1083 = t480 ** 2
  t1085 = 0.1e1 / t481 / t1083
  t1086 = t472 * t1085
  t1087 = t1082 * t1086
  t1088 = 0.1e1 / t122
  t1089 = t20 * t1088
  t1090 = s0 ** 2
  t1091 = t27 * t1090
  t1093 = 0.1e1 / t4 / t236
  t1095 = t1089 * t1091 * t1093
  t1098 = t1082 * t1056
  t1100 = t475 * t476 * t111
  t1105 = 0.1e1 / t481 / t1083 / t480
  t1106 = t473 * t1105
  t1107 = 0.1e1 / t241
  t1108 = t1090 * s0
  t1109 = t1107 * t1108
  t1110 = t2 ** 2
  t1112 = 0.1e1 / t1110 / t34
  t1117 = t473 * t1085 * t20
  t1118 = t1088 * t27
  t1120 = 0.1e1 / t4 / t1110
  t1126 = t473 * t1055 * t19
  t1127 = t474 * t28
  t1131 = -0.60000000000000000000000000000000000000000000000000e1 * t1023 * t1042 + 0.60000000000000000000000000000000000000000000000000e1 * t1027 * t1045 - 0.60000000000000000000000000000000000000000000000000e1 * t1050 * t1042 - 0.85350568417505433333333333333333333333333333333330e-1 * t1057 * t1059 - 0.10000000000000000000000000000000000000000000000000e1 * t1040 * t1042 + 0.30000000000000000000000000000000000000000000000000e1 * t1064 * t1066 + 0.42675284208752716666666666666666666666666666666665e-1 * t1070 * t1059 - 0.10000000000000000000000000000000000000000000000000e1 * t1075 * t1042 - 0.42675284208752716666666666666666666666666666666665e-1 * t1079 * t1059 + 0.60705996076593966087358779412675925925925925925921e-2 * t1087 * t1095 - 0.15647604209875996111111111111111111111111111111110e0 * t1098 * t1100 - 0.31087747628928898252912838668079770391184269901849e-2 * t1106 * t1109 * t1112 + 0.22258865228084454232031552451314506172839506172838e-1 * t1117 * t1118 * t1090 * t1120 - 0.24340717659807105061728395061728395061728395061728e0 * t1126 * t1127 * t229
  t1132 = 0.1e1 / t485
  t1150 = 0.20000000000000000000000000000000000000000000000000e1 * t1053 * t1042 - 0.10000000000000000000000000000000000000000000000000e1 * t1069 * t1042 + 0.10000000000000000000000000000000000000000000000000e1 * t1078 * t1042 + 0.28450189472501811111111111111111111111111111111110e-1 * t1098 * t1059 - 0.20235332025531322029119593137558641975308641975307e-2 * t1117 * t1118 * t1090 * t1093 + 0.52158680699586653703703703703703703703703703703702e-1 * t1126 * t1127 * t112
  t1151 = t485 ** 2
  t1152 = 0.1e1 / t1151
  t1159 = -0.10000000000000000000000000000000000000000000000000e1 * t1082 * t1042 - 0.14225094736250905555555555555555555555555555555555e-1 * t1126 * t1127 * t60
  t1162 = t1159 ** 2
  t1165 = 0.1e1 / t1151 / t485
  t1170 = t984 ** 2
  t1174 = 0.1e1 / t975 / t581
  t1176 = t541 * t545 * t1170 * t984 * t1174
  t1180 = t750 * t723 * t733 * t710
  t1181 = 0.48245938496077605200268890697218139186316165284153e2 * t1180
  t1183 = t914 * t600 * t919
  t1184 = 0.32530743900905219527896202567159734993471782831130e-1 * t1183
  t1186 = t914 * t682 * t810
  t1187 = 0.21687162600603479685264135044773156662314521887420e-1 * t1186
  t1189 = t914 * t600 * t923
  t1190 = 0.16265371950452609763948101283579867496735891415565e-1 * t1189
  t1192 = t914 * t600 * t927
  t1193 = 0.48159733137676571081572406076840235616767705782485e0 * t1192
  t1195 = 0.1e1 / t728 / t516
  t1196 = t504 * t1195
  t1197 = t751 * t733
  t1198 = t1196 * t1197
  t1199 = 0.96491876992155210400537781394436278372632330568306e2 * t1198
  t1208 = -0.25319000000000000000000000000000000000000000000000e1 * t633 + 0.16879333333333333333333333333333333333333333333333e1 * t640 - 0.19692555555555555555555555555555555555555555555555e1 * t644 - 0.93011851851851851851851851851851851851851851851854e0 * t647 + 0.13651666666666666666666666666666666666666666666667e0 * t651 - 0.27303333333333333333333333333333333333333333333333e0 * t655 - 0.31853888888888888888888888888888888888888888888890e0 * t657 - 0.36514074074074074074074074074074074074074074074075e0 * t660
  t1209 = t1208 * t711
  t1210 = t802 * t1209
  t1211 = 0.10000000000000000000000000000000000000000000000000e1 * t1210
  t1214 = 0.1e1 / t576 / t764 / t575
  t1216 = t1214 * t825 * t824
  t1219 = t766 * t824
  t1220 = t560 * t951
  t1226 = 0.1e1 / t206
  t1227 = t1226 * t776
  t1231 = t883 * t570
  t1234 = t1231 * t460 * t930 * t814
  t1238 = t886 * t930
  t1240 = t1231 * t460 * t813 * t1238
  t1243 = t873 * t875
  t1244 = t1243 * t877
  t1245 = t767 * t1244
  t1246 = t882 * t885
  t1247 = t1246 * t886
  t1248 = t839 * t1247
  t1251 = t1243 * t788
  t1252 = t767 * t1251
  t1253 = t1246 * t559
  t1254 = t839 * t1253
  t1257 = t831 * t845
  t1261 = t795 * t930 * t559
  t1262 = t839 * t1261
  t1265 = t228 * t550
  t1270 = t874 * t878 * t892
  t1273 = s0 * t945
  t1275 = t786 * t789 * t1273
  t1278 = t854 * t785
  t1279 = s0 * t835
  t1281 = t1278 * t789 * t1279
  t1284 = t796 * t456 * t595 * t814
  t1287 = t784 ** 2
  t1288 = 0.1e1 / t1287
  t1289 = t551 * t1288
  t1290 = t241 ** 2
  t1291 = t787 ** 2
  t1292 = 0.1e1 / t1291
  t1293 = t1290 * t1292
  t1295 = t1289 * t1293 * t790
  t1297 = 0.1e1 / t881 / t545
  t1298 = t27 * t1297
  t1299 = t1298 * t509
  t1300 = t885 * t813
  t1301 = t886 * t559
  t1304 = t1299 * t798 * t1300 * t1301
  t1307 = t775 ** 2
  t1308 = 0.1e1 / t1307
  t1309 = t547 * t1308
  t1311 = t1309 * t552 * t563
  t1312 = 0.1e1 / t207
  t1314 = t1312 * t27 * t567
  t1315 = t511 * t460
  t1319 = 0.90624913937249475330555555555555555555555555555555e-4 * t1227 * t837 * t841 - 0.83405688253936524999999999999999999999999999999999e-2 * t938 * t1234 + 0.16681137650787305000000000000000000000000000000000e-1 * t880 * t1240 - 0.16681137650787305000000000000000000000000000000000e-2 * t1245 * t1248 + 0.83405688253936524999999999999999999999999999999999e-3 * t1252 * t1254 + 0.50043412952361914999999999999999999999999999999999e-2 * t1257 * t849 - 0.83405688253936524999999999999999999999999999999999e-3 * t846 * t1262 - 0.99469005991731707592592592592592592592592592592592e-2 * t1265 * t768 * t772 - 0.38922654518503711666666666666666666666666666666665e-1 * t1270 * t889 + 0.64871090864172852777777777777777777777777777777776e-1 * t1275 * t816 + 0.43944844631026245583016666666666666666666666666667e-4 * t1281 * t1284 + 0.16681137650787305000000000000000000000000000000000e-1 * t1295 * t1304 + 0.26044644584654888215534544444444444444444444444445e-5 * t1311 * t1314 * t1315
  t1320 = 0.1e1 / t151
  t1337 = t789 * s0
  t1338 = t836 * t785 * t1337
  t1341 = t1290 * t877
  t1343 = t1289 * t1341 * t790
  t1346 = t1299 * t798 * t1300 * t886
  t1352 = t874 * t936 * t892
  t1355 = -t1184 - t1187 + t1190 + t1193 - t1000 + t1001 - t1002 - t1003 + t1004 - t1005 + t1006
  t1357 = t903 * t712 * t723
  t1358 = 0.60000000000000000000000000000000000000000000000000e1 * t1357
  t1360 = t459 * t646 * t520
  t1361 = 0.34450798614814814814814814814814814814814814814813e-2 * t1360
  t1362 = -t1007 - t1008 + t1009 - t1010 + t1181 + t1011 - t1358 + t1012 - t1199 + t1211 + t1361
  t1363 = t1355 + t1362
  t1366 = t797 * t798 * t1363 * t559
  t1369 = t1290 * t788
  t1371 = t1289 * t1369 * t790
  t1374 = t1299 * t798 * t1300 * t559
  t1377 = t112 * t27
  t1381 = t1312 * t853
  t1383 = t840 * t1315
  t1389 = t777 * t1244
  t1393 = t777 * t1251
  t1397 = -0.93702686803805231790123456790123456790123456790122e-1 * t564 * t1320 * t27 * t567 * t571 - 0.16113109698042956713772777777777777777777777777778e-3 * t856 * t1226 * t27 * t567 * t702 + 0.17685589265329897609962962962962962962962962962963e-1 * t778 * t770 * t228 * t27 * t567 - 0.24715885619249856908333333333333333333333333333334e-4 * t1338 * t1284 - 0.16681137650787305000000000000000000000000000000000e-1 * t1343 * t1346 - 0.19461327259251855833333333333333333333333333333333e-1 * t894 * t933 + 0.19461327259251855833333333333333333333333333333333e-1 * t1352 * t941 + 0.27801896084645508333333333333333333333333333333333e-2 * t792 * t1366 + 0.27801896084645508333333333333333333333333333333333e-2 * t1371 * t1374 - 0.88977188229299484869999999999999999999999999999999e-2 * t862 * t1377 * t848 - 0.14648281543675415194338888888888888888888888888889e-5 * t1381 * t837 * t1383 + 0.14829531371549914145000000000000000000000000000000e-2 * t862 * t863 * t1261 + 0.29659062743099828289999999999999999999999999999999e-2 * t1389 * t863 * t1247 - 0.14829531371549914145000000000000000000000000000000e-2 * t1393 * t863 * t1253
  t1398 = t1319 + t1397
  t1399 = t830 * t1398
  t1410 = t844 * t969 * t559
  t1413 = t578 * t1363
  t1418 = t970 * t814
  t1424 = 0.1e1 / t881 / t543
  t1425 = t875 * t1424
  t1429 = 0.70312500000000000000000000000000000000000000000000e0 * t1216 * t560 - 0.93750000000000000000000000000000000000000000000000e0 * t1219 * t1220 + 0.93750000000000000000000000000000000000000000000000e0 * t826 * t813 * t958 + 0.25000000000000000000000000000000000000000000000000e0 * t1399 * t560 - 0.75000000000000000000000000000000000000000000000000e0 * t952 * t813 * t958 - 0.75000000000000000000000000000000000000000000000000e0 * t955 * t930 * t958 + 0.75000000000000000000000000000000000000000000000000e0 * t955 * t885 * t1410 - 0.10000000000000000000000000000000000000000000000000e1 * t1413 * t552 * t963 + 0.30000000000000000000000000000000000000000000000000e1 * t961 * t785 * t1418 - 0.10000000000000000000000000000000000000000000000000e1 * t578 * t1300 * t873 * t1425 * t559
  t1431 = 0.1e1 / t581
  t1433 = t541 * t545 * t1429 * t1431
  t1434 = 0.3e1 * t986 + (0.1714584e0 * t1023 - 0.1714584e0 * t1027 * t1031 + 0.285764e-1 * t1040 + 0.285764e-1 * t1131 * t1132 - 0.857292e-1 * t1150 * t1152 * t1159 + 0.571528e-1 * t1162 * t1159 * t1165) * t501 - 0.2e1 * t1176 - t1181 + t1184 + t1187 - t1190 - t1193 + t1199 - t1211 - t1433 + t1358 - t1361
  t1435 = t1013 + t1434
  t1442 = t369 * t372
  t1446 = t378 * t372
  t1450 = t386 * t372
  t1454 = t394 * t372
  t1462 = -0.64e0 * t366 - 0.8704e0 * t372 - 0.8704e0 * t369 * t366 - 0.9214113627294e1 * t1442 - 0.4607056813647e1 * t378 * t366 + 0.36738723026100e2 * t1446 + 0.12246241008700e2 * t386 * t366 - 0.38314204724120e2 * t1450 - 0.9578551181030e1 * t394 * t366 + 0.15506534051160e2 * t1454 + 0.3101306810232e1 * t402 * t366 - 0.2177652951264e1 * t402 * t372 - 0.362942158544e0 * t410 * t366
  t1469 = t418 * t420
  t1473 = f.my_piecewise3(t46, t1462, -0.210e1 * t429 * t420 * t425 - 0.105e1 * t440 * t431 * t425 - 0.1575e1 * t1469 * t425)
  t1482 = (0.285764e-1 * t1082 + 0.285764e-1 * t1159 * t1132) * t501 - t801 - t804 + t808 + t812 - t541 * t545 * t984 * t1431
  t1488 = 0.4e1 * t763 * t1429 * t976 * t984
  t1491 = t611 ** 2
  t1495 = 0.12304822629859687989861833551788232416071203002497e5 * t588 / t590 / t673 * t1491 * t616
  t1499 = 0.14035736694323150897429372793021728356733892817027e2 * t588 * t621 * t1491 * t664
  t1507 = 0.1e1 / t465 * r0 * t1320 * t702 / 0.48e2
  t1509 = t631 * t835
  t1511 = t638 * t111
  t1512 = t637 * t1511
  t1514 = t595 * t945
  t1515 = t594 * t1514
  t1517 = t461 * t945
  t1518 = t459 * t1517
  t1520 = t464 ** (-0.25e1)
  t1523 = t1520 * t457 * t1320 * t702
  t1525 = t650 * t835
  t1527 = t654 * t1511
  t1529 = t604 * t1514
  t1532 = t511 * t460 * t111
  t1538 = 0.58482236226346462072622386637590534819724553404280e0 * t588 * t627 * (-0.28769444444444444444444444444444444444444444444444e1 * t1507 + 0.27618666666666666666666666666666666666666666666667e2 * t1509 - 0.10229135802469135802469135802469135802469135802469e2 * t1512 + 0.89504938271604938271604938271604938271604938271607e1 * t1515 + 0.31310740740740740740740740740740740740740740740741e1 * t1518 + 0.36677500000000000000000000000000000000000000000000e-1 * t1523 - 0.58684000000000000000000000000000000000000000000000e0 * t1525 + 0.65204444444444444444444444444444444444444444444445e0 * t1527 + 0.57053888888888888888888888888888888888888888888890e0 * t1529 + 0.13490888888888888888888888888888888888888888888889e1 * t1532) * t664
  t1541 = 0.38025319932552508024225805073234468230220037056326e2 * t914 * t600 * t617
  t1544 = 0.38527786510141256865257924861472188493414164625988e1 * t914 * t600 * t624
  t1547 = 0.21687162600603479685264135044773156662314521887420e-1 * t914 * t600 * t665
  t1550 = 0.13012297560362087811158481026863893997388713132452e0 * t914 * t600 * t670
  t1553 = 0.43374325201206959370528270089546313324629043774840e-1 * t914 * t682 * t923
  t1556 = 0.12842595503380418955085974953824062831138054875329e1 * t914 * t682 * t927
  t1559 = 0.86748650402413918741056540179092626649258087549680e-1 * t914 * t682 * t919
  t1562 = 0.67471172535210825687488420139294265171645179205307e-1 * t914 * t646 * t810
  t1576 = 0.10000000000000000000000000000000000000000000000000e1 * t802 * (-0.21099166666666666666666666666666666666666666666667e1 * t1507 + 0.20255200000000000000000000000000000000000000000000e2 * t1509 - 0.75019259259259259259259259259259259259259259259258e1 * t1512 + 0.65641851851851851851851851851851851851851851851850e1 * t1515 + 0.31003950617283950617283950617283950617283950617285e1 * t1518 + 0.68258333333333333333333333333333333333333333333335e-1 * t1523 - 0.10921333333333333333333333333333333333333333333333e1 * t1525 + 0.12134814814814814814814814814814814814814814814815e1 * t1527 + 0.10617962962962962962962962962962962962962962962963e1 * t1529 + 0.13388493827160493827160493827160493827160493827161e1 * t1532) * t711
  t1577 = t723 ** 2
  t1580 = 0.48245938496077605200268890697218139186316165284153e2 * t750 * t1577 * t733
  t1581 = -t1488 + t1495 + t1499 - t1538 + t1541 - t1544 + t1547 + t1550 - t1553 - t1556 + t1559 + t1562 + t1576 + t1580
  t1584 = 0.71233333333333333333333333333333333333333333333332e-1 * t702 * t716 * t1209
  t1587 = 0.42740000000000000000000000000000000000000000000000e0 * t702 * t730 * t752
  t1591 = 0.22161481481481481481481481481481481481481481481481e0 * t702 * t642 * t704 * t712
  t1595 = 0.18989649058080861538367470034170805442117582945368e-2 * t745 * t595 * t945 * t534
  t1611 = t5 * t236
  t1620 = t126 * t79
  t1654 = 0.14688e5 * t311 * t154 * t211 - 0.4896e4 * t155 * t218 - 0.288e3 * t161 * t86 * t79 * t115 - 0.72e2 * t201 * t42 * t232 * t24 + 0.384e3 * t190 * t178 + 0.3240e4 * t1611 * t17 / t50 / t32 * t42 * t241 * t24 + 0.288e3 * t85 * t146 * t1620 - 0.5024e4 * t289 * t186 - 0.432e3 * t215 * t216 * t122 * t126 + 0.864e3 * t215 * t141 * t19 * t122 * t147 - 0.1152e4 * t120 * t203 + 0.2592e4 * t207 * t15 * t154 * t196 * t210 + 0.5024e4 / 0.3e1 * t131 * t191 + 0.1296e4 * t209 * t202 * t210 - 0.768e3 * t190 * t183 + 0.144e3 * t175 * t256 * t20 * t23 * t258
  t1713 = -0.2304e4 * t300 * t197 + 0.24e2 * t175 * t176 * t23 * t316 + 0.144e3 * t85 * t141 * t115 * t147 + 0.288e3 * t161 * t141 * t98 * t147 - 0.288e3 * t85 * t256 * t63 * t258 - 0.12960e5 * t236 * t16 * t239 * t166 * t241 + 0.4320e4 * t237 * t239 * t53 * t241 * t79 + 0.1440e4 * t103 * t167 + 0.11552e5 * t944 * t17 * t154 * t157 - 0.720e3 * t74 * t171 + 0.96e2 * t161 * t166 * t232 - 0.48e2 * t85 * t53 * t232 * t79 + 0.32e2 * t139 * t142 * t316 - 0.72e2 * t85 * t170 * t126 - 0.48e2 * t85 * t86 * t316 - 0.17056e5 / 0.9e1 * t9 * t17 * t51 * t133 - 0.2880e4 * t95 * t136
  t1748 = t51 * t141
  t1811 = -0.4288e4 / 0.9e1 * t1 * t15 * t33 * t105 - 0.176e3 * t283 * t305 + 0.1728e4 * t58 * t15 * t51 * t301 + 0.216e3 * t110 * t98 * t51 * t123 - 0.1728e4 * t151 * t15 * t154 * t104 * t241 - 0.3776e4 / 0.27e2 * r0 * t16 * t33 * t76 + 0.1328e4 * t9 * t16 * t51 * t123 - 0.176e3 * t34 * t98 * t33 * t76 + 0.560e3 / 0.81e2 * t512 * t16 * t38 + 0.4480e4 / 0.27e2 * t4 * t15 * t70 + 0.560e3 / 0.3e1 * t87 * t98 * t38
  t1822 = t115 ** 2
  t1831 = 0.1e1 / t5 / t206
  t1832 = s0 * t1831
  t1835 = f.my_piecewise3(t14, 0.6160e4 / 0.81e2 * tau0 * t228 - 0.2618e4 / 0.81e2 * t1832, 0)
  t1856 = 0.560e3 / 0.3e1 * t272 * t116 + 0.160e3 * t65 * t63 * t116 + 0.160e3 / 0.3e1 * t91 * t308 - 0.3744e4 * t944 * t16 * t313 + 0.12e2 * t35 * t1822 * t38 + 0.16e2 * t292 * t308 + 0.4e1 * t69 * t38 * t1835 - 0.48e2 * t2 * t63 * t33 * t305 + 0.216e3 * t300 * t304 * t210 - 0.16e2 * t103 * t27 * t232 * t24 + 0.540e3 * t206 * t16 * t239 * t27 * t241 * t24
  t1863 = -0.1440e4 * t103 * t163 + 0.1440e4 * t74 * t148 + 0.480e3 * t221 * t33 * t143 - 0.144e3 * t139 * t256 * t147 * t126 - 0.144e3 * t48 * t320 * t51 * t133 - 0.720e3 * t74 * t127 - 0.144e3 * t161 * t162 * t126 + 0.216e3 * t55 * t115 * t20 * t80 + 0.216e3 * t55 * t64 * t177 - 0.2592e4 * t208 * t154 * t53 * t63 * t19 * t217 - 0.144e3 * t174 * t1748 * t1620 * t24 - 0.432e3 * t194 * t51 * t42 * t63 * t115 * t24 + 0.2304e4 * t119 * t54 * t81 + 0.432e3 * t194 * t54 * t98 * t20 * t80 - 0.432e3 * t49 * t1748 * t64 * t182 - 0.4e1 * t18 * t222 * (t1811 + t1856) + 0.1440e4 * t94 * t252
  t1885 = t126 ** 2
  t1904 = t147 ** 2
  t1911 = -0.25920e5 * t206 * t17 * t242 + 0.2880e4 * t275 * t245 - 0.960e3 * t324 * t249 + 0.480e3 * t2 * t320 * t43 + 0.480e3 * r0 * t17 * t43 - 0.80e2 * t221 * t317 + 0.240e3 * t73 * t233 + 0.2880e4 * t282 * t266 + 0.960e3 * t248 * t263 + 0.24e2 * t18 * t262 * t1885 + 0.144e3 * t3 * t98 * t252 + 0.72e2 * t160 * t43 * t1822 - 0.96e2 * t321 * t249 - 0.480e3 * t248 * t223 - 0.480e3 * t221 * t259 + 0.96e2 * t18 * t33 / t255 / t41 * t1904 + 0.12e2 * t84 * t43 * t1835
  t1913 = t1654 + t1713 + t1863 + t1911
  t1914 = f.my_piecewise3(t47, 0, t1913)
  t1917 = t366 ** 2
  t1930 = t372 ** 2
  t1945 = -0.4607056813647e1 * t378 * t1914 - 0.6532958853792e1 * t402 * t1917 - 0.55284681763764e2 * t372 * t366 + 0.12246241008700e2 * t386 * t1914 + 0.46519602153480e2 * t394 * t1917 + 0.110216169078300e3 * t378 * t1917 - 0.362942158544e0 * t410 * t1914 - 0.229885228344720e3 * t369 * t1930 - 0.114942614172360e3 * t386 * t1917 - 0.34816e1 * t340 * t329 - 0.8704e0 * t369 * t1914 - 0.27642340881882e2 * t369 * t1917 - 0.43553059025280e2 * t386 * t1930 - 0.9578551181030e1 * t394 * t1914
  t1971 = 0.186078408613920e3 * t378 * t1930 + 0.3101306810232e1 * t402 * t1914 - 0.64e0 * t1914 - 0.26112e1 * t1917 + 0.73477446052200e2 * t1930 - 0.36856454509176e2 * t375 * t329 - 0.8710611805056e1 * t407 * t329 + 0.146954892104400e3 * t383 * t329 + 0.62026136204640e2 * t399 * t329 + 0.440864676313200e3 * t1442 * t366 - 0.65329588537920e2 * t1454 * t366 - 0.153256818896480e3 * t391 * t329 - 0.689655685034160e3 * t1446 * t366 + 0.372156817227840e3 * t1450 * t366
  t1973 = t420 ** 2
  t1982 = t431 ** 2
  t1997 = f.my_piecewise3(t47, t1913, 0)
  t2011 = t417 ** 2
  t2016 = -0.2520e2 * t436 * t1973 * t425 - 0.3780e2 * t1469 * t432 - 0.56700e2 * t450 * t1973 * t425 - 0.630e1 * t429 * t1982 * t425 - 0.56700e2 * t436 * t420 * t432 - 0.840e1 * t430 * t425 * t441 - 0.283500e2 / t417 / t428 * t1973 * t425 - 0.105e1 * t440 * t1997 * t425 - 0.6300e1 * t418 * t441 * t446 - 0.4725e1 * t418 * t1982 * t425 - 0.141750e2 * t450 * t431 * t420 * t425 - 0.354375e1 / t2011 * t1973 * t425
  t2017 = f.my_piecewise3(t46, t1945 + t1971, t2016)
  t2031 = f.my_piecewise3(t46, -0.64e0 * t340 - 0.8704e0 * t375 - 0.4607056813647e1 * t383 + 0.12246241008700e2 * t391 - 0.9578551181030e1 * t399 + 0.3101306810232e1 * t407 - 0.362942158544e0 * t410 * t340, -0.105e1 * t440 * t419 * t425)
  t2037 = 0.36846163202829085479643115651216588683774907041596e2 * t702 * t596 * t756 * t760
  t2041 = 0.68734380377411894875316412946636775627438430141488e1 * t702 * t596 * t1195 * t1197
  t2043 = t623 * t692
  t2046 = 0.62337092780453269534799339101707810596085839394858e3 * t588 * t621 * t611 * t2043
  t2048 = t664 * t610
  t2051 = 0.46785788981077169658097909310072427855779642723424e1 * t588 * t674 * t662 * t2048
  t2056 = 0.61524113149298439949309167758941162080356015012483e4 * t588 * t592 * t611 * t616 * t692
  t2060 = 0.69263436422725855038665932335230900662317599327620e2 * t588 * t668 * t662 * t698
  t2063 = 0.21053605041484726346144059189532592535100839225540e2 * t588 * t926 * t693
  t2066 = 0.14246666666666666666666666666666666666666666666666e0 * t702 * t705 * t724
  t2067 = 0.4e1 * t1435 * t2031 + t2017 * t585 - t1584 - t1587 - t1591 + t1595 - t2037 + t2041 + t2046 + t2051 - t2056 - t2060 - t2063 + t2066
  t2072 = 0.22911460125803964958438804315545591875812810047162e1 * t702 * t565 * t729 * t734
  t2076 = 0.28493333333333333333333333333333333333333333333333e0 * t702 * t565 * t739 * t741
  t2079 = 0.57895126195293126240322668836661767023579398340984e3 * t1196 * t734 * t723
  t2083 = 0.31035607751564040179390551320631661034531975982628e4 * t757 * t731 * t759 * t723
  t2086 = 0.11483599538271604938271604938271604938271604938271e-1 * t459 * t1517 * t520
  t2101 = (-0.571528e-1 * t1053 + 0.285764e-1 * t1069 + 0.285764e-1 * t1150 * t1132 - 0.285764e-1 * t1162 * t1152) * t501 + t899 + t902 + t905 - t907 - t909 - t913 - t917 - t921 + t925 + t929 - t541 * t545 * t974 * t1431 + t541 * t545 * t1170 * t976
  t2104 = t974 ** 2
  t2108 = 0.3e1 * t541 * t545 * t2104 * t976
  t2109 = t692 ** 2
  t2113 = 0.51947577317044391278999449251423175496738199495715e2 * t588 * t668 * t2109 * t623
  t2117 = 0.35089341735807877243573431982554320891834732042568e1 * t588 * t674 * t2109 * t664
  t2118 = t590 ** 2
  t2121 = t614 ** 2
  t2125 = 0.91082604192152556048340974007871726131433263376469e5 * t588 / t2118 * t1491 / t2121
  t2129 = 0.62337092780453269534799339101707810596085839394858e3 * t588 * t592 * t1491 * t623
  t2132 = 0.60000000000000000000000000000000000000000000000000e1 * t903 * t1577 * t711
  t2136 = 0.42740000000000000000000000000000000000000000000000e0 * t601 * t739 * t710 * t724
  t2141 = 0.34367190188705947437658206473318387813719215070744e1 * t601 * t729 * t723 * t733 * t710
  t2142 = 0.6e1 * t1473 * t2101 + t2072 - t2076 - t2079 + t2083 - t2086 - t2108 - t2113 + t2117 - t2125 - t2129 - t2132 + t2136 - t2141
  t2143 = t731 ** 2
  t2146 = 0.24000000000000000000000000000000000000000000000000e2 * t1196 * t2143 * t711
  t2149 = 0.57895126195293126240322668836661767023579398340984e3 * t757 * t2143 * t733
  t2155 = 0.62071215503128080358781102641263322069063951965254e4 * t504 / t728 / t738 * t2143 * t759
  t2156 = t728 ** 2
  t2159 = t732 ** 2
  t2163 = 0.24955700379505800914252936827276051226357058527653e5 * t504 / t2156 * t2143 / t2159
  t2164 = t523 * t702
  t2169 = 0.19263893255070628432628962430736094246707082312995e1 * t2164 * t596 * t668 * t2043 * t610
  t2174 = 0.13012297560362087811158481026863893997388713132452e0 * t2164 * t596 * t674 * t2048 * t692
  t2175 = t1170 ** 2
  t2177 = t975 ** 2
  t2181 = 0.6e1 * t541 * t545 * t2175 / t2177
  t2182 = 0.1e1 / t236
  t2191 = t777 * t873
  t2192 = t878 * s0
  t2194 = t779 * t882
  t2195 = t1238 * t813
  t2199 = t936 * s0
  t2202 = t930 * t813 * t559
  t2217 = t795 * t1363 * t559
  t2224 = t460 * t1363
  t2231 = t1298 * t570
  t2232 = t460 * t885
  t2248 = 0.14908695437785200353349358024691358024691358024692e-2 * t856 * t2182 * t27 * t567 * t702 + 0.49974766295362790288065843621399176954732510288065e0 * t564 * t1314 * t571 + 0.11863625097239931316000000000000000000000000000000e-1 * t2191 * t2192 * t2194 * t2195 - 0.59318125486199656580000000000000000000000000000000e-2 * t2191 * t2199 * t2194 * t2202 - 0.45144050613401806240259877037037037037037037037037e-4 * t1311 * t1093 * t27 * t567 * t1315 + 0.10008682590472383000000000000000000000000000000000e-1 * t1257 * t1262 - 0.10008682590472383000000000000000000000000000000000e-1 * t831 * t1251 * t1254 - 0.11120758433858203333333333333333333333333333333333e-2 * t846 * t839 * t2217 - 0.39787602396692683037037037037037037037037037037037e-1 * t1265 * t845 * t849 - 0.11120758433858203333333333333333333333333333333333e-1 * t938 * t1231 * t2224 * t814 - 0.15569061807401484666666666666666666666666666666667e0 * t1270 * t1240 + 0.10008682590472383000000000000000000000000000000000e0 * t1295 * t2231 * t2232 * t1301 * t930 + 0.16681137650787305000000000000000000000000000000000e-1 * t1371 * t2231 * t2232 * t931 - 0.10008682590472383000000000000000000000000000000000e0 * t1343 * t2231 * t2232 * t1238 + 0.77845309037007423333333333333333333333333333333332e-1 * t1352 * t1234
  t2262 = t552 * jnp.pi
  t2264 = 0.1e1 / t1611
  t2270 = t1288 * t1290
  t2271 = t2270 * t1292
  t2273 = t1297 * t1300
  t2274 = t2273 * t1301
  t2278 = t2270 * t877
  t2280 = t2273 * t886
  t2287 = t2270 * t788
  t2289 = t2273 * t559
  t2301 = t854 * t873
  t2306 = t883 * t456 * t595 * t887
  t2321 = t559 * t456 * t595
  t2322 = t796 * t930 * t2321
  t2325 = t836 * t873
  t2331 = t883 * t885 * t2321
  t2336 = 0.22241516867716406666666666666666666666666666666667e-1 * t880 * t1231 * t2224 * t886 * t813 - 0.11687867688391932333540740740740740740740740740740e0 * t778 * t770 * t1831 * t27 * t567 + 0.18522951228606556498888168008888888888888888888889e-5 * t547 / t1307 / t549 * t2262 * t770 * t2264 * t27 * t567 - 0.66724550603149220000000000000000000000000000000000e-2 * t767 * t2271 * t839 * t2274 + 0.66724550603149220000000000000000000000000000000000e-2 * t767 * t2278 * t839 * t2280 + 0.20017365180944765999999999999999999999999999999999e-1 * t831 * t1244 * t1248 - 0.11120758433858203333333333333333333333333333333333e-2 * t767 * t2287 * t839 * t2289 + 0.10417857833861955286213817777777777777777777777778e-4 * t1309 * t785 * t789 * s0 * t1312 * t797 * t638 * t814 + 0.17577937852410498233206666666666666666666666666667e-3 * t2301 * t878 * t1279 * t2306 - 0.58593126174701660777355555555555555555555555555558e-5 * t1315 * t1381 * t785 * t1337 * t796 * t814 + 0.36249965574899790132222222222222222222222222222223e-3 * t1227 * t785 * t1337 * t1284 - 0.49431771238499713816666666666666666666666666666668e-4 * t1338 * t2322 - 0.98863542476999427633333333333333333333333333333334e-4 * t2325 * t2192 * t2306 + 0.49431771238499713816666666666666666666666666666668e-4 * t2325 * t2199 * t2331 + 0.87889689262052491166033333333333333333333333333335e-4 * t1281 * t2322
  t2381 = t551 / t1287 / t539
  t2382 = t1290 * t21
  t2389 = t27 / t881 / t968 * t509
  t2390 = t885 ** 2
  t2406 = t1495 + t1499 - t1538 + t1541 - t1544 + t1547 + t1550 - t1553 - t1556 + t1559 + t1562
  t2407 = t1576 + t1580 - t1584 - t1587 - t1591 + t1595 - t2037 + t2041 + t2046 + t2051 - t2056 - t2060
  t2409 = -t2063 + t2066 + t2072 - t2076 - t2079 + t2083 - t2086 - t2113 + t2117 - t2125 - t2129
  t2413 = 0.64327917994770140267025187596290852248421553712204e2 * t750 * t1208 * t733 * t710
  t2416 = 0.36000000000000000000000000000000000000000000000000e2 * t750 * t741 * t723
  t2419 = 0.80000000000000000000000000000000000000000000000000e1 * t903 * t712 * t1208
  t2420 = -t2132 + t2136 - t2141 - t2146 + t2149 - t2155 + t2163 + t2169 - t2174 + t2413 + t2416 - t2419
  t2422 = t2406 + t2407 + t2409 + t2420
  t2428 = -0.10417857833861955286213817777777777777777777777778e-5 * t2264 * t1308 * t2262 * t772 + 0.65736038742361824148148148148148148148148148148147e-1 * t1831 * t550 * t768 * t772 + 0.11863625097239931316000000000000000000000000000000e-1 * t777 * t2271 * t863 * t2274 - 0.35590875291719793947999999999999999999999999999999e-1 * t1389 * t1377 * t1247 - 0.11863625097239931316000000000000000000000000000000e-1 * t777 * t2278 * t863 * t2280 - 0.17795437645859896974000000000000000000000000000000e-1 * t862 * t1377 * t1261 - 0.83850930471232847881604938271604938271604938271605e-3 * t2182 * t776 * t837 * t841 + 0.17795437645859896974000000000000000000000000000000e-1 * t1393 * t1377 * t1253 + 0.70742357061319590439851851851851851851851851851852e-1 * t862 * t229 * t27 * t848 - 0.87889689262052491166033333333333333333333333333335e-4 * t2301 * t936 * t1279 * t2331 + 0.15569061807401484666666666666666666666666666666667e0 * t1289 * t1341 * t892 * t1346 + 0.38922654518503711666666666666666666666666666666667e-1 * t2381 * t2382 * t877 * t790 * t2389 * t798 * t2390 * t886 - 0.27801896084645508333333333333333333333333333333333e-2 * t2381 * t2382 * t788 * t790 * t2389 * t798 * t2390 * t559 + 0.12974218172834570555555555555555555555555555555555e0 * t1275 * t933 + 0.27801896084645508333333333333333333333333333333333e-2 * t792 * t797 * t798 * t2422 * t559
  t2429 = t930 ** 2
  t2473 = t886 ** 2
  t2498 = t839 * t882
  t2505 = -0.83405688253936524999999999999999999999999999999999e-2 * t938 * t884 * t798 * t2429 * t559 + 0.16681137650787305000000000000000000000000000000000e-1 * t880 * t884 * t798 * t2429 * t886 - 0.37481074721522092716049382716049382716049382716048e0 * t786 * t789 * s0 * t1320 * t816 - 0.12974218172834570555555555555555555555555555555555e0 * t874 * t936 * t1273 * t941 - 0.25948436345669141111111111111111111111111111111111e-1 * t894 * t1366 + 0.25948436345669141111111111111111111111111111111110e0 * t874 * t878 * t1273 * t889 - 0.15569061807401484666666666666666666666666666666667e0 * t1289 * t1293 * t892 * t1304 - 0.64452438792171826855091111111111111111111111111112e-3 * t1278 * t789 * s0 * t1226 * t1284 - 0.25948436345669141111111111111111111111111111111111e-1 * t1289 * t1369 * t892 * t1374 + 0.66724550603149220000000000000000000000000000000000e-1 * t2381 * t2382 / t1291 / t560 * t790 * t2389 * t798 * t2390 * t2473 - 0.10008682590472383000000000000000000000000000000000e0 * t2381 * t2382 * t1292 * t790 * t2389 * t798 * t2390 * t1301 + 0.19772708495399885526666666666666666666666666666667e-2 * t862 * t863 * t2217 + 0.25390354675704053003520740740740740740740740740741e-4 * t1093 * t853 * t837 * t1383 + 0.19772708495399885526666666666666666666666666666667e-2 * t777 * t2287 * t863 * t2289 - 0.66724550603149220000000000000000000000000000000000e-2 * t1245 * t2498 * t2195 + 0.33362275301574610000000000000000000000000000000000e-2 * t1252 * t2498 * t2202
  t2546 = t951 ** 2
  t2577 = t764 ** 2
  t2580 = t825 ** 2
  t2587 = 0.25000000000000000000000000000000000000000000000000e0 * t830 * (t2248 + t2336 + t2428 + t2505) * t560 - 0.15000000000000000000000000000000000000000000000000e1 * t952 * t930 * t958 - 0.10000000000000000000000000000000000000000000000000e1 * t955 * t1363 * t958 - 0.10000000000000000000000000000000000000000000000000e1 * t955 * t1300 * t1243 * t1424 * t559 - 0.12500000000000000000000000000000000000000000000000e1 * t1219 * t560 * t1398 - 0.28125000000000000000000000000000000000000000000000e1 * t1216 * t813 * t958 + 0.37500000000000000000000000000000000000000000000000e1 * t1219 * t813 * t552 * t557 * t559 * t951 + 0.30000000000000000000000000000000000000000000000000e1 * t955 * t930 * t785 * t1418 - 0.60000000000000000000000000000000000000000000000000e1 * t961 * t873 * t1425 * t939 + 0.30000000000000000000000000000000000000000000000000e1 * t578 * t2429 * t785 * t971 - 0.93750000000000000000000000000000000000000000000000e0 * t766 * t2546 * t560 + 0.15000000000000000000000000000000000000000000000000e1 * t952 * t885 * t1410 + 0.10000000000000000000000000000000000000000000000000e1 * t578 * t2390 * t1288 * t1290 / t881 / t793 * t559 - 0.10000000000000000000000000000000000000000000000000e1 * t1399 * t813 * t958 + 0.42187500000000000000000000000000000000000000000000e1 * t1214 * t825 * t1220 - 0.18750000000000000000000000000000000000000000000000e1 * t826 * t885 * t1410 + 0.18750000000000000000000000000000000000000000000000e1 * t826 * t930 * t958 - 0.10000000000000000000000000000000000000000000000000e1 * t578 * t2422 * t552 * t963 - 0.22851562500000000000000000000000000000000000000000e1 / t576 / t2577 * t2580 * t560 + 0.40000000000000000000000000000000000000000000000000e1 * t1413 * t785 * t1418
  t2590 = t541 * t545 * t2587 * t1431
  t2594 = 0.12e2 * t763 * t974 * t1174 * t1170
  t2597 = t1488 - t1495 - t1499 + t1538 - t1541 + t1544 - t1547 - t1550 + t1553 + t1556 - t1559 - t1562 - t1576
  t2598 = -t1580 + t1584 + t1587 + t1591 - t1595 + t2037 - t2041 - t2046 - t2051 + t2056 + t2060 + t2063 - t2066
  t2600 = -t2072 + t2076 + t2079 - t2083 + t2086 + t2108 + t2113 - t2117 + t2125 + t2129 + t2132 - t2136 + t2141
  t2601 = t1021 ** 2
  t2602 = t1049 * t2601
  t2606 = t1031 ** 2
  t2607 = t1026 * t2606
  t2617 = t1034 * (-0.24694444444444444444444444444444444444444444444444e-1 * t1507 + 0.23706666666666666666666666666666666666666666666666e0 * t1509 - 0.87802469135802469135802469135802469135802469135800e-1 * t1512 + 0.76827160493827160493827160493827160493827160493827e-1 * t1515 + 0.10849222222222222222222222222222222222222222222222e0 * t1518)
  t2640 = t1016 ** 2
  t2672 = -0.60000000000000000000000000000000000000000000000000e1 * t1074 * t1031 * t1021 * t472 * t483 + 0.40000000000000000000000000000000000000000000000000e1 * t1017 * t1039 * t1066 - 0.36000000000000000000000000000000000000000000000000e2 * t1049 * t1021 * t1045 + 0.12000000000000000000000000000000000000000000000000e2 / t1016 / t1025 * t2601 * t1042 - 0.10000000000000000000000000000000000000000000000000e1 * t2617 * t1042 + 0.36000000000000000000000000000000000000000000000000e2 * t1074 * t2601 * t1042 + 0.10000000000000000000000000000000000000000000000000e1 / t2640 * t2601 * t1042 + 0.24000000000000000000000000000000000000000000000000e2 * t2602 * t1042 - 0.17070113683501086666666666666666666666666666666666e0 * t1064 * t1065 * t1055 * t1059 - 0.34140227367002173333333333333333333333333333333332e0 * t1027 * t1056 * t19 * t1127 * t60 * t1031 - 0.24282398430637586434943511765070370370370370370368e-1 * t1053 * t1086 * t1095 + 0.56900378945003622222222222222222222222222222222220e-1 * t1040 * t1056 * t1059 + 0.12141199215318793217471755882535185185185185185184e-1 * t1069 * t1086 * t1095 + 0.56900378945003622222222222222222222222222222222220e-1 * t1075 * t1056 * t1059 - 0.12141199215318793217471755882535185185185185185184e-1 * t1078 * t1086 * t1095
  t2724 = t1083 ** 2
  t2728 = t1090 ** 2
  t2738 = 0.34140227367002173333333333333333333333333333333332e0 * t1023 * t1056 * t1059 + 0.34140227367002173333333333333333333333333333333332e0 * t1050 * t1056 * t1059 + 0.97362870639228420246913580246913580246913580246908e0 * t1098 * t475 * t476 * t228 + 0.31295208419751992222222222222222222222222222222221e0 * t1079 * t1100 - 0.89035460912337816928126209805258024691358024691350e-1 * t1087 * t1089 * t1091 * t1120 + 0.62590416839503984444444444444444444444444444444441e0 * t1057 * t1100 - 0.31295208419751992222222222222222222222222222222221e0 * t1070 * t1100 + 0.60000000000000000000000000000000000000000000000000e1 * t2607 * t1042 + 0.30000000000000000000000000000000000000000000000000e1 * t1017 * t2606 * t1042 - 0.36000000000000000000000000000000000000000000000000e2 * t1078 * t1045 + 0.68393044783643576156408245069775494860605393784069e-1 * t1106 * t1109 / t1110 / t2 + 0.80000000000000000000000000000000000000000000000000e1 * t1027 * t1042 * t1039 - 0.22011544503327960296120090757411011659807956104251e0 * t1117 * t1118 * t1090 / t4 / t1110 / r0 + 0.13793073340557359534979423868312757201646090534979e1 * t1126 * t1127 * t1832 + 0.12435099051571559301165135467231908156473707960740e-1 * t1082 * t472 * t1105 * t1107 * t1108 * t1112 - 0.57489400170562495257927652663499439366228807233633e-3 * t473 / t481 / t2724 * t1107 * t2728 / t5 / t1110 / t206 * t19 * t1127
  t2748 = t1150 ** 2
  t2751 = t1162 ** 2
  t2752 = t1151 ** 2
  t2758 = t2146 - t2149 + t2155 - t2163 - t2169 + t2174 + t2181 - t2590 - t2594 + (-0.6858336e0 * t2602 + 0.10287504e1 * t1078 * t1031 - 0.1714584e0 * t2607 - 0.2286112e0 * t1027 * t1039 + 0.285764e-1 * t2617 + 0.285764e-1 * (t2672 + t2738) * t1132 - 0.1143056e0 * t1131 * t1152 * t1159 + 0.3429168e0 * t1150 * t1165 * t1162 - 0.857292e-1 * t2748 * t1152 - 0.1714584e0 * t2751 / t2752) * t501 - t2413 - t2416 + t2419
  t2762 = -t2146 + t2149 - t2155 + t2163 + t2169 - t2174 - t2181 + t2590 + t2594 + t2413 + t2416 - t2419 + 0.4e1 * t455 * t1482 + t999 * (t2597 + t2598 + t2600 + t2758)
  t2779 = 0.4e1 * t999 * t1435 + 0.12e2 * t1473 * t1482 + r0 * (t1581 + t2067 + t2142 + t2762) + 0.8e1 * t1176 + 0.19298375398431042080107556278887255674526466113661e3 * t1180 - 0.13012297560362087811158481026863893997388713132452e0 * t1183 - 0.86748650402413918741056540179092626649258087549680e-1 * t1186 + 0.65061487801810439055792405134319469986943565662260e-1 * t1189 + 0.19263893255070628432628962430736094246707082312995e1 * t1192 + 0.12e2 * t2031 * t2101 - 0.38596750796862084160215112557774511349052932227323e3 * t1198 + 0.40000000000000000000000000000000000000000000000000e1 * t1210 + 0.4e1 * t1433 - 0.24000000000000000000000000000000000000000000000000e2 * t1357 + 0.13780319445925925925925925925925925925925925925925e-1 * t1360
  v4rho4_0_ = t988 + t2779

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 + r1
  t2 = t1 ** 2
  t3 = t2 ** 2
  t4 = t3 * t1
  t5 = r0 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t9 = tau0 / t6 / r0
  t10 = r0 - r1
  t11 = 0.1e1 / t1
  t12 = t10 * t11
  t13 = 0.1e1 + t12
  t14 = t13 / 0.2e1
  t15 = t14 ** (0.1e1 / 0.3e1)
  t16 = t15 ** 2
  t17 = t16 * t14
  t19 = r1 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t23 = tau1 / t20 / r1
  t24 = 0.1e1 - t12
  t25 = t24 / 0.2e1
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = t27 * t25
  t31 = s0 + 0.2e1 * s1 + s2
  t32 = t1 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t35 = 0.1e1 / t33 / t2
  t38 = t9 * t17 + t23 * t28 - t31 * t35 / 0.8e1
  t39 = 0.0e0 < t38
  t40 = f.my_piecewise3(t39, t38, 0)
  t41 = t40 ** 2
  t42 = t41 * t40
  t43 = t4 * t42
  t44 = 6 ** (0.1e1 / 0.3e1)
  t45 = t44 ** 2
  t46 = jnp.pi ** 2
  t47 = t46 ** (0.1e1 / 0.3e1)
  t48 = t47 ** 2
  t49 = t45 * t48
  t50 = t33 * t1
  t53 = 2 ** (0.1e1 / 0.3e1)
  t54 = t53 ** 2
  t56 = 0.3e1 / 0.10e2 * t49 * t50 + 0.1e-3 * t54
  t57 = t56 ** 2
  t59 = 0.1e1 / t57 / t56
  t60 = t17 + t28
  t61 = t60 ** 2
  t63 = 0.1e1 / t61 / t60
  t65 = t2 * t1
  t66 = t32 * t65
  t67 = t66 * t41
  t68 = 0.1e1 / t57
  t69 = 0.1e1 / t61
  t70 = t68 * t69
  t72 = t67 * t70 + 0.1e-2
  t73 = 0.1e1 / t72
  t74 = t59 * t63 * t73
  t75 = t43 * t74
  t76 = t75 <= 0.25e1
  t77 = 0.25e1 < t75
  t78 = t3 * t42
  t80 = 0.5e1 * t78 * t74
  t82 = t4 * t41 * t59
  t83 = t63 * t73
  t84 = r0 ** 2
  t87 = tau0 / t6 / t84
  t90 = 0.1e1 / t2
  t91 = t10 * t90
  t92 = t11 - t91
  t93 = t92 / 0.2e1
  t94 = t16 * t93
  t97 = -t93
  t98 = t27 * t97
  t102 = 0.1e1 / t33 / t65
  t103 = t31 * t102
  t104 = t103 / 0.3e1
  t106 = f.my_piecewise3(t39, -0.5e1 / 0.3e1 * t87 * t17 + 0.5e1 / 0.3e1 * t9 * t94 + 0.5e1 / 0.3e1 * t23 * t98 + t104, 0)
  t107 = t83 * t106
  t110 = t33 * t4
  t111 = t110 * t42
  t112 = t57 ** 2
  t113 = 0.1e1 / t112
  t115 = t83 * t49
  t117 = 0.3e1 / 0.2e1 * t111 * t113 * t115
  t118 = t43 * t59
  t119 = t61 ** 2
  t120 = 0.1e1 / t119
  t121 = t120 * t73
  t123 = 0.5e1 / 0.3e1 * t94 + 0.5e1 / 0.3e1 * t98
  t124 = t121 * t123
  t127 = t72 ** 2
  t128 = 0.1e1 / t127
  t129 = t63 * t128
  t130 = t32 * t2
  t131 = t130 * t41
  t133 = 0.10e2 / 0.3e1 * t131 * t70
  t134 = t66 * t40
  t135 = t70 * t106
  t139 = t3 * t41 * t59
  t141 = t69 * t45 * t48
  t142 = t139 * t141
  t143 = t68 * t63
  t144 = t143 * t123
  t147 = 0.2e1 * t134 * t135 - 0.2e1 * t67 * t144 + t133 - t142
  t148 = t129 * t147
  t150 = 0.3e1 * t82 * t107 - 0.3e1 * t118 * t124 - t118 * t148 - t117 + t80
  t151 = f.my_piecewise3(t77, 0, t150)
  t153 = f.my_piecewise3(t77, 0.25e1, t75)
  t156 = t153 ** 2
  t159 = t156 * t153
  t162 = t156 ** 2
  t165 = t162 * t153
  t168 = t162 * t156
  t172 = f.my_piecewise3(t77, t75, 0.25e1)
  t173 = 0.1e1 - t172
  t174 = t173 ** 2
  t175 = 0.1e1 / t174
  t176 = f.my_piecewise3(t77, t150, 0)
  t180 = jnp.exp(0.15e1 / t173)
  t183 = f.my_piecewise3(t76, -0.64e0 * t151 - 0.8704e0 * t153 * t151 - 0.4607056813647e1 * t156 * t151 + 0.12246241008700e2 * t159 * t151 - 0.9578551181030e1 * t162 * t151 + 0.3101306810232e1 * t165 * t151 - 0.362942158544e0 * t168 * t151, -0.105e1 * t175 * t176 * t180)
  t184 = 3 ** (0.1e1 / 0.3e1)
  t186 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t187 = t184 * t186
  t188 = 4 ** (0.1e1 / 0.3e1)
  t189 = t188 ** 2
  t192 = t187 * t189 / t32
  t193 = jnp.sqrt(t192)
  t196 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t193 + 0.31385250000000000000000000000000000000000000000000e-1 * t192
  t197 = 0.1e1 / t196
  t200 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t197)
  t201 = t200 - 0.1e1
  t202 = 0.1e1 / t48
  t203 = t44 * t202
  t204 = t54 * t31
  t208 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t203 * t204 * t35
  t209 = t208 ** (0.1e1 / 0.4e1)
  t211 = 0.1e1 - 0.1e1 / t209
  t213 = t201 * t211 + 0.1e1
  t214 = jnp.log(t213)
  t216 = -0.285764e-1 * t197 + 0.285764e-1 * t214
  t217 = t53 - 0.1e1
  t218 = t13 <= f.p.zeta_threshold
  t219 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t220 = t219 * f.p.zeta_threshold
  t221 = t13 ** (0.1e1 / 0.3e1)
  t222 = t221 * t13
  t223 = f.my_piecewise3(t218, t220, t222)
  t224 = t24 <= f.p.zeta_threshold
  t225 = t24 ** (0.1e1 / 0.3e1)
  t226 = t225 * t24
  t227 = f.my_piecewise3(t224, t220, t226)
  t228 = t223 + t227 - 0.2e1
  t231 = 0.1e1 / t217 / 0.2e1
  t234 = 0.1e1 - 0.2363e1 * t217 * t228 * t231
  t235 = t216 * t234
  t236 = t10 ** 2
  t237 = t236 ** 2
  t238 = t237 ** 2
  t239 = t238 * t237
  t240 = t3 ** 2
  t242 = 0.1e1 / t240 / t3
  t244 = -t239 * t242 + 0.1e1
  t247 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t192
  t250 = t192 ** 0.15e1
  t252 = t184 ** 2
  t253 = t186 ** 2
  t254 = t252 * t253
  t257 = t254 * t188 / t33
  t259 = 0.37978500000000000000000000000000000000000000000000e1 * t193 + 0.89690000000000000000000000000000000000000000000000e0 * t192 + 0.20477500000000000000000000000000000000000000000000e0 * t250 + 0.12323500000000000000000000000000000000000000000000e0 * t257
  t262 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t259
  t263 = jnp.log(t262)
  t265 = 0.621814e-1 * t247 * t263
  t266 = 0.1e1 / t3
  t267 = t237 * t266
  t268 = t228 * t231
  t270 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t192
  t275 = 0.70594500000000000000000000000000000000000000000000e1 * t193 + 0.15494250000000000000000000000000000000000000000000e1 * t192 + 0.42077500000000000000000000000000000000000000000000e0 * t250 + 0.15629250000000000000000000000000000000000000000000e0 * t257
  t278 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t275
  t279 = jnp.log(t278)
  t283 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t192
  t288 = 0.51785000000000000000000000000000000000000000000000e1 * t193 + 0.90577500000000000000000000000000000000000000000000e0 * t192 + 0.11003250000000000000000000000000000000000000000000e0 * t250 + 0.12417750000000000000000000000000000000000000000000e0 * t257
  t291 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t288
  t292 = jnp.log(t291)
  t293 = t283 * t292
  t295 = -0.3109070e-1 * t270 * t279 + t265 - 0.19751673498613801407483339618206552048944131217655e-1 * t293
  t296 = t268 * t295
  t297 = t267 * t296
  t299 = 0.19751673498613801407483339618206552048944131217655e-1 * t268 * t293
  t300 = jnp.log(0.2e1)
  t301 = 0.1e1 - t300
  t303 = t301 / t46
  t304 = t219 ** 2
  t305 = t221 ** 2
  t306 = f.my_piecewise3(t218, t304, t305)
  t307 = t225 ** 2
  t308 = f.my_piecewise3(t224, t304, t307)
  t310 = t306 / 0.2e1 + t308 / 0.2e1
  t311 = t310 ** 2
  t312 = t311 * t310
  t314 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e-1 * t192
  t316 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t192
  t317 = 0.1e1 / t316
  t319 = 0.1e1 / t301
  t320 = t314 * t317 * t319
  t322 = (-t265 + t297 + t299) * t319
  t323 = 0.1e1 / t312
  t324 = t46 * t323
  t326 = jnp.exp(-t322 * t324)
  t327 = t326 - 0.1e1
  t328 = 0.1e1 / t327
  t329 = t46 * t328
  t330 = t329 * t31
  t331 = t320 * t330
  t332 = 0.1e1 / t130
  t333 = t332 * t53
  t334 = 0.1e1 / t311
  t336 = 0.1e1 / t186
  t337 = t252 * t336
  t338 = t337 * t188
  t342 = 0.1e1 + 0.27801896084645508333333333333333333333333333333333e-2 * t331 * t333 * t334 * t338
  t343 = t342 ** (0.1e1 / 0.4e1)
  t345 = 0.1e1 - 0.1e1 / t343
  t348 = 0.1e1 + 0.10000000000000000000000000000000000000000000000000e1 * t345 * t327
  t349 = jnp.log(t348)
  t352 = -t303 * t312 * t349 + t235 * t244 + t265 - t297 - t299
  t353 = t183 * t352
  t357 = f.my_piecewise3(t218, 0, 0.4e1 / 0.3e1 * t221 * t92)
  t358 = -t92
  t361 = f.my_piecewise3(t224, 0, 0.4e1 / 0.3e1 * t225 * t358)
  t363 = (t357 + t361) * t231
  t364 = t363 * t293
  t366 = t259 ** 2
  t367 = 0.1e1 / t366
  t368 = t247 * t367
  t370 = 0.1e1 / t193 * t184
  t371 = t186 * t189
  t372 = t32 * t1
  t373 = 0.1e1 / t372
  t374 = t371 * t373
  t375 = t370 * t374
  t377 = t189 * t373
  t378 = t187 * t377
  t380 = t192 ** 0.5e0
  t381 = t380 * t184
  t382 = t381 * t374
  t386 = t254 * t188 / t50
  t388 = -0.63297500000000000000000000000000000000000000000000e0 * t375 - 0.29896666666666666666666666666666666666666666666667e0 * t378 - 0.10238750000000000000000000000000000000000000000000e0 * t382 - 0.82156666666666666666666666666666666666666666666667e-1 * t386
  t389 = 0.1e1 / t262
  t390 = t388 * t389
  t391 = t368 * t390
  t392 = 0.20000000000000000000000000000000000000000000000000e1 * t391
  t403 = f.my_piecewise3(t76, 0.1e1 - 0.64e0 * t153 - 0.4352e0 * t156 - 0.1535685604549e1 * t159 + 0.3061560252175e1 * t162 - 0.1915710236206e1 * t165 + 0.516884468372e0 * t168 - 0.51848879792e-1 * t162 * t159, -0.7e0 * t180)
  t404 = t196 ** 2
  t405 = 0.1e1 / t404
  t408 = -0.74083333333333333333333333333333333333333333333333e-2 * t375 - 0.10461750000000000000000000000000000000000000000000e-1 * t378
  t409 = t405 * t408
  t411 = t200 * t211
  t415 = 0.1e1 / t209 / t208
  t417 = t201 * t415 * t44
  t418 = t202 * t54
  t422 = -0.10000000000000000000000000000000000000000000000000e1 * t409 * t411 - 0.14225094736250905555555555555555555555555555555555e-1 * t417 * t418 * t103
  t423 = 0.1e1 / t213
  t426 = 0.285764e-1 * t409 + 0.285764e-1 * t422 * t423
  t427 = t426 * t234
  t428 = t427 * t244
  t429 = t216 * t217
  t430 = t363 * t244
  t433 = t236 * t10
  t434 = t238 * t433
  t435 = t434 * t242
  t437 = 0.1e1 / t240 / t4
  t438 = t239 * t437
  t440 = -0.12e2 * t435 + 0.12e2 * t438
  t443 = t187 * t377 * t263
  t444 = 0.11073470983333333333333333333333333333333333333333e-2 * t443
  t445 = 0.10000000000000000000000000000000000000000000000000e1 * t391
  t446 = t433 * t266
  t447 = t446 * t296
  t448 = 0.4e1 * t447
  t449 = 0.1e1 / t4
  t450 = t237 * t449
  t451 = t450 * t296
  t452 = 0.4e1 * t451
  t453 = t363 * t295
  t454 = t267 * t453
  t458 = t275 ** 2
  t459 = 0.1e1 / t458
  t460 = t270 * t459
  t465 = -0.11765750000000000000000000000000000000000000000000e1 * t375 - 0.51647500000000000000000000000000000000000000000000e0 * t378 - 0.21038750000000000000000000000000000000000000000000e0 * t382 - 0.10419500000000000000000000000000000000000000000000e0 * t386
  t466 = 0.1e1 / t278
  t467 = t465 * t466
  t473 = t288 ** 2
  t474 = 0.1e1 / t473
  t475 = t283 * t474
  t480 = -0.86308333333333333333333333333333333333333333333334e0 * t375 - 0.30192500000000000000000000000000000000000000000000e0 * t378 - 0.55016250000000000000000000000000000000000000000000e-1 * t382 - 0.82785000000000000000000000000000000000000000000000e-1 * t386
  t481 = 0.1e1 / t291
  t482 = t480 * t481
  t485 = 0.53237641966666666666666666666666666666666666666666e-3 * t187 * t377 * t279 + 0.10000000000000000000000000000000000000000000000000e1 * t460 * t467 - t444 - t445 + 0.18311447306006545054854346104378990962041954983034e-3 * t187 * t377 * t292 + 0.58482236226346462072622386637590534819724553404280e0 * t475 * t482
  t486 = t268 * t485
  t487 = t267 * t486
  t488 = 0.19751673498613801407483339618206552048944131217655e-1 * t364
  t489 = t268 * t184
  t491 = t371 * t373 * t292
  t492 = t489 * t491
  t493 = 0.18311447306006545054854346104378990962041954983034e-3 * t492
  t494 = t268 * t283
  t496 = t474 * t480 * t481
  t497 = t494 * t496
  t498 = 0.58482236226346462072622386637590534819724553404280e0 * t497
  t499 = t311 * t349
  t500 = 0.1e1 / t221
  t503 = f.my_piecewise3(t218, 0, 0.2e1 / 0.3e1 * t500 * t92)
  t504 = 0.1e1 / t225
  t507 = f.my_piecewise3(t224, 0, 0.2e1 / 0.3e1 * t504 * t358)
  t509 = t503 / 0.2e1 + t507 / 0.2e1
  t511 = t303 * t499 * t509
  t512 = 0.3e1 * t511
  t514 = 0.1e1 / t343 / t342
  t515 = t102 * t317
  t516 = t319 * t46
  t517 = t515 * t516
  t518 = t328 * t31
  t519 = t53 * t334
  t520 = t518 * t519
  t522 = 0.27801896084645508333333333333333333333333333333333e-3 * t517 * t520
  t523 = t316 ** 2
  t524 = 0.1e1 / t523
  t525 = t314 * t524
  t526 = t525 * t516
  t531 = 0.49431771238499713816666666666666666666666666666666e-3 * t526 * t518 * t102 * t53 * t334
  t532 = t327 ** 2
  t533 = 0.1e1 / t532
  t534 = t46 * t533
  t535 = t31 * t332
  t537 = t320 * t534 * t535
  t538 = t519 * t252
  t539 = t336 * t188
  t541 = (t444 + t445 + t448 - t452 + t454 + t487 + t488 - t493 - t498) * t319
  t543 = t311 ** 2
  t544 = 0.1e1 / t543
  t545 = t46 * t544
  t546 = t545 * t509
  t549 = 0.3e1 * t322 * t546 - t541 * t324
  t550 = t549 * t326
  t552 = t538 * t539 * t550
  t555 = 0.1e1 / t66
  t556 = t555 * t53
  t560 = 0.64871090864172852777777777777777777777777777777777e-2 * t331 * t556 * t334 * t338
  t561 = t333 * t323
  t563 = t337 * t188 * t509
  t567 = -t522 + t531 - 0.27801896084645508333333333333333333333333333333333e-2 * t537 * t552 - t560 - 0.55603792169291016666666666666666666666666666666666e-2 * t331 * t561 * t563
  t568 = t514 * t567
  t574 = 0.25000000000000000000000000000000000000000000000000e0 * t568 * t327 + 0.10000000000000000000000000000000000000000000000000e1 * t345 * t549 * t326
  t576 = 0.1e1 / t348
  t578 = t303 * t312 * t574 * t576
  t579 = t428 - 0.2363e1 * t429 * t430 + t235 * t440 - t444 - t445 - t448 + t452 - t454 - t487 - t488 + t493 + t498 - t512 - t578
  t580 = t403 * t579
  t582 = 0.2e1 * t487
  t583 = 0.8e1 * t451
  t585 = 0.22146941966666666666666666666666666666666666666666e-2 * t443
  t586 = 0.8e1 * t447
  t588 = 0.36622894612013090109708692208757981924083909966068e-3 * t492
  t589 = t303 * t311
  t590 = t574 * t576
  t593 = 0.6e1 * t589 * t590 * t509
  t594 = t473 ** 2
  t595 = 0.1e1 / t594
  t596 = t480 ** 2
  t598 = t291 ** 2
  t599 = 0.1e1 / t598
  t602 = 0.17315859105681463759666483083807725165579399831905e2 * t494 * t595 * t596 * t599
  t607 = t253 * t188 * t35
  t608 = 0.1e1 / t193 / t192 * t252 * t607
  t610 = t371 * t332
  t611 = t370 * t610
  t613 = t189 * t332
  t614 = t187 * t613
  t616 = t192 ** (-0.5e0)
  t618 = t616 * t252 * t607
  t620 = t381 * t610
  t623 = t254 * t188 * t35
  t625 = -0.57538888888888888888888888888888888888888888888889e0 * t608 + 0.11507777777777777777777777777777777777777777777778e1 * t611 + 0.40256666666666666666666666666666666666666666666667e0 * t614 + 0.36677500000000000000000000000000000000000000000000e-1 * t618 + 0.73355000000000000000000000000000000000000000000000e-1 * t620 + 0.13797500000000000000000000000000000000000000000000e0 * t623
  t629 = 0.58482236226346462072622386637590534819724553404280e0 * t494 * t474 * t625 * t481
  t631 = t363 * t283 * t496
  t632 = 0.11696447245269292414524477327518106963944910680856e1 * t631
  t634 = 0.1e1 / t473 / t288
  t638 = 0.11696447245269292414524477327518106963944910680856e1 * t494 * t634 * t596 * t481
  t647 = 0.1e1 / t15
  t648 = t93 ** 2
  t649 = t647 * t648
  t652 = 0.1e1 / t65
  t653 = t10 * t652
  t654 = -t90 + t653
  t655 = t16 * t654
  t658 = 0.1e1 / t26
  t659 = t97 ** 2
  t660 = t658 * t659
  t664 = -t27 * t654
  t667 = t33 * t3
  t668 = 0.1e1 / t667
  t669 = t31 * t668
  t670 = 0.11e2 / 0.9e1 * t669
  t672 = f.my_piecewise3(t39, 0.40e2 / 0.9e1 * tau0 / t6 / t84 / r0 * t17 - 0.50e2 / 0.9e1 * t87 * t94 + 0.10e2 / 0.9e1 * t9 * t649 + 0.5e1 / 0.3e1 * t9 * t655 + 0.10e2 / 0.9e1 * t23 * t660 + 0.5e1 / 0.3e1 * t23 * t664 - t670, 0)
  t680 = 0.10e2 / 0.9e1 * t649 + 0.5e1 / 0.3e1 * t655 + 0.10e2 / 0.9e1 * t660 + 0.5e1 / 0.3e1 * t664
  t686 = 0.70e2 / 0.9e1 * t372 * t41 * t70
  t687 = t130 * t40
  t688 = t687 * t135
  t693 = 0.22e2 / 0.3e1 * t65 * t41 * t59 * t141
  t694 = t131 * t144
  t696 = t106 ** 2
  t701 = t3 * t40 * t59
  t704 = t701 * t69 * t106 * t49
  t706 = t134 * t68
  t717 = t47 * t46
  t720 = 0.9e1 * t667 * t41 * t113 * t69 * t44 * t717
  t722 = t48 * t123
  t724 = t139 * t63 * t45 * t722
  t726 = t68 * t120
  t727 = t123 ** 2
  t734 = t686 + 0.40e2 / 0.3e1 * t688 - t693 - 0.40e2 / 0.3e1 * t694 + 0.2e1 * t66 * t696 * t70 - 0.4e1 * t704 - 0.8e1 * t706 * t63 * t106 * t123 + 0.2e1 * t134 * t70 * t672 + t720 + 0.4e1 * t724 + 0.6e1 * t67 * t726 * t727 - 0.2e1 * t67 * t143 * t680
  t739 = 0.20e2 * t65 * t42 * t74
  t740 = t139 * t107
  t742 = t78 * t59
  t743 = t742 * t124
  t745 = t742 * t148
  t750 = 0.16e2 * t667 * t42 * t113 * t115
  t752 = t4 * t40 * t59
  t764 = t3 * t2
  t773 = 0.18e2 * t32 * t764 * t42 / t112 / t56 * t83 * t44 * t717
  t776 = 0.1e1 / t119 / t60 * t73
  t780 = t120 * t128
  t787 = t63 / t127 / t72
  t788 = t147 ** 2
  t793 = t113 * t63
  t794 = t110 * t41 * t793
  t797 = t794 * t73 * t106 * t49
  t800 = t111 * t113 * t120
  t803 = t800 * t73 * t45 * t722
  t805 = t111 * t793
  t809 = t805 * t128 * t45 * t48 * t147
  t811 = -0.18e2 * t82 * t121 * t106 * t123 - 0.6e1 * t82 * t129 * t106 * t147 + 0.6e1 * t118 * t780 * t123 * t147 - 0.3e1 * t118 * t121 * t680 - t118 * t129 * t734 + 0.12e2 * t118 * t776 * t727 + 0.2e1 * t118 * t787 * t788 + 0.3e1 * t82 * t83 * t672 + 0.6e1 * t752 * t83 * t696 + t739 + 0.30e2 * t740 - 0.30e2 * t743 - 0.10e2 * t745 - t750 + t773 - 0.9e1 * t797 + 0.9e1 * t803 + 0.3e1 * t809
  t812 = f.my_piecewise3(t77, 0, t811)
  t814 = t151 ** 2
  t838 = -0.64e0 * t812 - 0.8704e0 * t814 - 0.8704e0 * t153 * t812 - 0.9214113627294e1 * t153 * t814 - 0.4607056813647e1 * t156 * t812 + 0.36738723026100e2 * t156 * t814 + 0.12246241008700e2 * t159 * t812 - 0.38314204724120e2 * t159 * t814 - 0.9578551181030e1 * t162 * t812 + 0.15506534051160e2 * t162 * t814 + 0.3101306810232e1 * t165 * t812 - 0.2177652951264e1 * t165 * t814 - 0.362942158544e0 * t168 * t812
  t840 = 0.1e1 / t174 / t173
  t841 = t176 ** 2
  t845 = f.my_piecewise3(t77, t811, 0)
  t849 = t174 ** 2
  t850 = 0.1e1 / t849
  t855 = f.my_piecewise3(t76, t838, -0.210e1 * t840 * t841 * t180 - 0.105e1 * t175 * t845 * t180 - 0.1575e1 * t850 * t841 * t180)
  t857 = 0.1e1 / t305
  t858 = t92 ** 2
  t861 = 0.2e1 * t654
  t865 = f.my_piecewise3(t218, 0, 0.4e1 / 0.9e1 * t857 * t858 + 0.4e1 / 0.3e1 * t221 * t861)
  t866 = 0.1e1 / t307
  t867 = t358 ** 2
  t870 = -t861
  t874 = f.my_piecewise3(t224, 0, 0.4e1 / 0.9e1 * t866 * t867 + 0.4e1 / 0.3e1 * t225 * t870)
  t876 = (t865 + t874) * t231
  t878 = t267 * t876 * t295
  t880 = t267 * t363 * t485
  t881 = 0.2e1 * t880
  t883 = 0.8e1 * t450 * t486
  t884 = t446 * t453
  t885 = 0.8e1 * t884
  t886 = t450 * t453
  t887 = 0.8e1 * t886
  t888 = t574 ** 2
  t890 = t348 ** 2
  t891 = 0.1e1 / t890
  t893 = t303 * t312 * t888 * t891
  t895 = 0.8e1 * t446 * t486
  t898 = 0.14764627977777777777777777777777777777777777777777e-2 * t187 * t613 * t263
  t899 = t366 ** 2
  t902 = t388 ** 2
  t903 = t262 ** 2
  t907 = 0.16081979498692535066756296899072713062105388428051e2 * t247 / t899 * t902 / t903
  t908 = t855 * t352 + t593 - t602 - t629 - t632 + t638 + t878 + t881 - t883 + t885 - t887 - t893 + t895 - t898 + t907
  t914 = 0.20000000000000000000000000000000000000000000000000e1 * t247 / t366 / t259 * t902 * t389
  t924 = 0.10000000000000000000000000000000000000000000000000e1 * t368 * (-0.42198333333333333333333333333333333333333333333333e0 * t608 + 0.84396666666666666666666666666666666666666666666666e0 * t611 + 0.39862222222222222222222222222222222222222222222223e0 * t614 + 0.68258333333333333333333333333333333333333333333333e-1 * t618 + 0.13651666666666666666666666666666666666666666666667e0 * t620 + 0.13692777777777777777777777777777777777777777777778e0 * t623) * t389
  t925 = t310 * t349
  t926 = t509 ** 2
  t929 = 0.6e1 * t303 * t925 * t926
  t931 = 0.19751673498613801407483339618206552048944131217655e-1 * t876 * t293
  t935 = 0.10843581300301739842632067522386578331157260943710e-1 * t268 * t187 * t377 * t496
  t939 = 0.24415263074675393406472461472505321282722606644045e-3 * t489 * t371 * t332 * t292
  t940 = t187 * t189
  t944 = 0.35616666666666666666666666666666666666666666666666e-1 * t940 * t373 * t367 * t390
  t947 = 0.132e3 * t238 * t236 * t242
  t949 = 0.288e3 * t434 * t437
  t953 = 0.156e3 * t239 / t240 / t764
  t956 = t427 * t440
  t960 = t408 ** 2
  t961 = 0.1e1 / t404 / t196 * t960
  t967 = t405 * (-0.49388888888888888888888888888888888888888888888889e-2 * t608 + 0.98777777777777777777777777777777777777777777777777e-2 * t611 + 0.13949000000000000000000000000000000000000000000000e-1 * t614)
  t973 = t404 ** 2
  t984 = t208 ** 2
  t991 = t31 ** 2
  t1005 = t422 ** 2
  t1006 = t213 ** 2
  t1012 = (-0.571528e-1 * t961 + 0.285764e-1 * t967 + 0.285764e-1 * (0.20000000000000000000000000000000000000000000000000e1 * t961 * t411 - 0.10000000000000000000000000000000000000000000000000e1 * t967 * t411 + 0.10000000000000000000000000000000000000000000000000e1 / t973 * t960 * t411 + 0.28450189472501811111111111111111111111111111111110e-1 * t409 * t200 * t415 * t203 * t204 * t102 - 0.20235332025531322029119593137558641975308641975307e-2 * t201 / t209 / t984 * t45 / t717 * t53 * t991 / t32 / t3 / t65 + 0.52158680699586653703703703703703703703703703703702e-1 * t417 * t418 * t669) * t423 - 0.285764e-1 * t1005 / t1006) * t234 * t244
  t1013 = t426 * t217
  t1014 = t1013 * t430
  t1022 = -t593 + t602 + t629 + t632 - t638 + t235 * (-t947 + t949 - t953) + 0.2e1 * t956 + t1012 - t878 - t881 + t883 - t885 + t887 - 0.4726e1 * t1014 - 0.2363e1 * t429 * t876 * t244 - 0.4726e1 * t429 * t363 * t440 + t893
  t1023 = t342 ** 2
  t1025 = 0.1e1 / t343 / t1023
  t1026 = t567 ** 2
  t1030 = t516 * t328
  t1031 = t525 * t1030
  t1032 = t53 * t323
  t1033 = t1032 * t509
  t1035 = t1031 * t103 * t1033
  t1046 = 0.14648281543675415194338888888888888888888888888889e-4 * t314 / t523 / t316 * t319 * t330 * t449 * t53 * t334 * t940
  t1050 = 0.16681137650787305000000000000000000000000000000000e-2 * t668 * t317 * t516 * t520
  t1052 = t517 * t518 * t1033
  t1054 = 0.1e1 / t222
  t1060 = f.my_piecewise3(t218, 0, -0.2e1 / 0.9e1 * t1054 * t858 + 0.2e1 / 0.3e1 * t500 * t861)
  t1061 = 0.1e1 / t226
  t1067 = f.my_piecewise3(t224, 0, -0.2e1 / 0.9e1 * t1061 * t867 + 0.2e1 / 0.3e1 * t504 * t870)
  t1069 = t1060 / 0.2e1 + t1067 / 0.2e1
  t1081 = 0.21623696954724284259259259259259259259259259259259e-1 * t331 / t32 / t3 * t53 * t334 * t338
  t1082 = t556 * t323
  t1084 = t331 * t1082 * t563
  t1090 = 0.29659062743099828290000000000000000000000000000000e-2 * t526 * t518 * t668 * t53 * t334
  t1091 = t516 * t533
  t1092 = t515 * t1091
  t1093 = t31 * t53
  t1095 = t334 * t549 * t326
  t1097 = t1092 * t1093 * t1095
  t1104 = 0.82386285397499523027777777777777777777777777777777e-5 * t449 * t524 * t1030 * t1093 * t334 * t940
  t1105 = t525 * t1091
  t1106 = t103 * t53
  t1108 = t1105 * t1106 * t1095
  t1112 = t320 * t534 * t31 * t555
  t1113 = t1112 * t552
  t1115 = t1032 * t337
  t1117 = t326 * t509
  t1122 = t549 ** 2
  t1132 = t320 * t46 / t532 / t327 * t535
  t1133 = t326 ** 2
  t1140 = t363 * t184 * t491
  t1141 = 0.36622894612013090109708692208757981924083909966068e-3 * t1140
  t1152 = t465 ** 2
  t1166 = t458 ** 2
  t1169 = t278 ** 2
  t1192 = -0.70983522622222222222222222222222222222222222222221e-3 * t187 * t613 * t279 - 0.34246666666666666666666666666666666666666666666666e-1 * t940 * t373 * t459 * t467 - 0.20000000000000000000000000000000000000000000000000e1 * t270 / t458 / t275 * t1152 * t466 + 0.10000000000000000000000000000000000000000000000000e1 * t460 * (-0.78438333333333333333333333333333333333333333333333e0 * t608 + 0.15687666666666666666666666666666666666666666666667e1 * t611 + 0.68863333333333333333333333333333333333333333333333e0 * t614 + 0.14025833333333333333333333333333333333333333333333e0 * t618 + 0.28051666666666666666666666666666666666666666666667e0 * t620 + 0.17365833333333333333333333333333333333333333333333e0 * t623) * t466 + 0.32163958997385070133512593798145426124210776856102e2 * t270 / t1166 * t1152 / t1169 + t898 + t944 + t914 - t924 - t907 - 0.24415263074675393406472461472505321282722606644045e-3 * t187 * t613 * t292 - 0.10843581300301739842632067522386578331157260943710e-1 * t940 * t373 * t474 * t482 - 0.11696447245269292414524477327518106963944910680856e1 * t283 * t634 * t596 * t481 + 0.58482236226346462072622386637590534819724553404280e0 * t475 * t625 * t481 + 0.17315859105681463759666483083807725165579399831905e2 * t283 * t595 * t596 * t599
  t1194 = t267 * t268 * t1192
  t1195 = t931 - t602 - t629 - t632 + t935 + t924 + t907 - t1141 + t638 - t944 + t1194
  t1198 = 0.12e2 * t236 * t266 * t296
  t1201 = 0.32e2 * t433 * t449 * t296
  t1205 = 0.20e2 * t237 / t764 * t296
  t1206 = t878 + t881 - t887 - t883 + t885 + t895 - t914 - t898 + t1198 - t1201 + t1205 + t939
  t1213 = 0.1e1 / t543 / t310
  t1214 = t46 * t1213
  t1221 = -(t1195 + t1206) * t319 * t324 + 0.6e1 * t541 * t546 - 0.12e2 * t322 * t1214 * t926 + 0.3e1 * t322 * t545 * t1069
  t1227 = t333 * t544
  t1233 = -0.19772708495399885526666666666666666666666666666666e-2 * t1035 + t1046 + t1050 + 0.11120758433858203333333333333333333333333333333333e-2 * t1052 - 0.55603792169291016666666666666666666666666666666666e-2 * t331 * t561 * t337 * t188 * t1069 + t1081 + 0.25948436345669141111111111111111111111111111111110e-1 * t1084 - t1090 + 0.55603792169291016666666666666666666666666666666666e-3 * t1097 - t1104 - 0.98863542476999427633333333333333333333333333333332e-3 * t1108 + 0.12974218172834570555555555555555555555555555555555e-1 * t1113 + 0.11120758433858203333333333333333333333333333333333e-1 * t537 * t1115 * t188 * t549 * t1117 - 0.27801896084645508333333333333333333333333333333333e-2 * t537 * t538 * t539 * t1122 * t326 + 0.55603792169291016666666666666666666666666666666666e-2 * t1132 * t538 * t539 * t1122 * t1133 - 0.27801896084645508333333333333333333333333333333333e-2 * t537 * t538 * t539 * t1221 * t326 + 0.16681137650787305000000000000000000000000000000000e-1 * t331 * t1227 * t337 * t188 * t926
  t1248 = t303 * t312 * (-0.31250000000000000000000000000000000000000000000000e0 * t1025 * t1026 * t327 + 0.25000000000000000000000000000000000000000000000000e0 * t514 * t1233 * t327 + 0.50000000000000000000000000000000000000000000000000e0 * t568 * t550 + 0.10000000000000000000000000000000000000000000000000e1 * t345 * t1221 * t326 + 0.10000000000000000000000000000000000000000000000000e1 * t345 * t1122 * t326) * t576
  t1251 = 0.3e1 * t303 * t499 * t1069
  t1252 = -t895 + t898 - t907 + t914 - t924 - t929 - t931 - t935 - t939 + t944 - t1248 - t1251 + t1141 - t1198 + t1201 - t1205 - t1194
  t1257 = -t914 + t924 + t929 + t931 + t935 + t939 - t944 + t403 * (t1022 + t1252) + t1248 + t1251 - t1141 + 0.2e1 * t183 * t579 + t1198 - t1201 + t1205 + t1194
  t1261 = 0.11696447245269292414524477327518106963944910680856e1 * t497
  d11 = 0.2e1 * t353 + 0.39503346997227602814966679236413104097888262435310e-1 * t364 + t392 + 0.2e1 * t580 + t582 - t583 + 0.2e1 * t454 + t585 + t586 + 0.2e1 * t578 - t588 + t1 * (t908 + t1257) + 0.6e1 * t511 - t1261
  t1262 = -t11 - t91
  t1265 = f.my_piecewise3(t218, 0, 0.2e1 / 0.3e1 * t500 * t1262)
  t1266 = -t1262
  t1269 = f.my_piecewise3(t224, 0, 0.2e1 / 0.3e1 * t504 * t1266)
  t1271 = t1265 / 0.2e1 + t1269 / 0.2e1
  t1274 = 0.3e1 * t589 * t590 * t1271
  t1275 = 0.58482236226346462072622386637590534819724553404280e0 * t631
  t1279 = f.my_piecewise3(t218, 0, 0.4e1 / 0.3e1 * t221 * t1262)
  t1282 = f.my_piecewise3(t224, 0, 0.4e1 / 0.3e1 * t225 * t1266)
  t1284 = (t1279 + t1282) * t231
  t1285 = t1284 * t295
  t1286 = t267 * t1285
  t1287 = t1284 * t293
  t1288 = 0.19751673498613801407483339618206552048944131217655e-1 * t1287
  t1290 = (t444 + t445 - t448 - t452 + t1286 + t487 + t1288 - t493 - t498) * t319
  t1292 = t545 * t1271
  t1295 = -t1290 * t324 + 0.3e1 * t322 * t1292
  t1296 = t1295 * t326
  t1298 = t538 * t539 * t1296
  t1301 = t188 * t1271
  t1302 = t337 * t1301
  t1306 = -t522 + t531 - 0.27801896084645508333333333333333333333333333333333e-2 * t537 * t1298 - t560 - 0.55603792169291016666666666666666666666666666666666e-2 * t331 * t561 * t1302
  t1307 = t514 * t1306
  t1310 = t345 * t1295
  t1313 = 0.25000000000000000000000000000000000000000000000000e0 * t1307 * t327 + 0.10000000000000000000000000000000000000000000000000e1 * t1310 * t326
  t1316 = t303 * t312 * t1313 * t891 * t574
  t1318 = t1284 * t283 * t496
  t1319 = 0.58482236226346462072622386637590534819724553404280e0 * t1318
  t1324 = 0.6e1 * t303 * t310 * t349 * t1271 * t509
  t1332 = f.my_piecewise3(t218, 0, 0.4e1 / 0.9e1 * t857 * t1262 * t92 + 0.8e1 / 0.3e1 * t221 * t10 * t652)
  t1340 = f.my_piecewise3(t224, 0, 0.4e1 / 0.9e1 * t866 * t1266 * t358 - 0.8e1 / 0.3e1 * t225 * t10 * t652)
  t1342 = (t1332 + t1340) * t231
  t1344 = 0.19751673498613801407483339618206552048944131217655e-1 * t1342 * t293
  t1351 = t334 * t1295 * t326
  t1353 = t1105 * t1106 * t1351
  t1357 = t1092 * t1093 * t1351
  t1359 = t1032 * t1271
  t1361 = t1031 * t103 * t1359
  t1364 = t519 * t337
  t1365 = t188 * t1295
  t1372 = t517 * t518 * t1359
  t1374 = -t1104 - 0.49431771238499713816666666666666666666666666666666e-3 * t1108 - 0.49431771238499713816666666666666666666666666666666e-3 * t1353 - t1090 - 0.98863542476999427633333333333333333333333333333332e-3 * t1035 + 0.27801896084645508333333333333333333333333333333333e-3 * t1357 - 0.98863542476999427633333333333333333333333333333332e-3 * t1361 + 0.27801896084645508333333333333333333333333333333333e-3 * t1097 + 0.55603792169291016666666666666666666666666666666666e-2 * t1132 * t1364 * t1365 * t1133 * t549 + t1046 + 0.55603792169291016666666666666666666666666666666666e-3 * t1372 + t1050
  t1384 = t1112 * t1298
  t1397 = f.my_piecewise3(t218, 0, -0.2e1 / 0.9e1 * t1054 * t1262 * t92 + 0.4e1 / 0.3e1 * t500 * t10 * t652)
  t1405 = f.my_piecewise3(t224, 0, -0.2e1 / 0.9e1 * t1061 * t1266 * t358 - 0.4e1 / 0.3e1 * t504 * t10 * t652)
  t1407 = t1397 / 0.2e1 + t1405 / 0.2e1
  t1415 = t1284 * t184 * t491
  t1416 = 0.18311447306006545054854346104378990962041954983034e-3 * t1415
  t1417 = 0.4e1 * t884
  t1418 = 0.4e1 * t886
  t1419 = -t602 - t629 - t1275 + t638 - t1319 + t1344 + t880 - t1416 - t883 - t1417 - t1418 - t898 + t907
  t1420 = t450 * t1285
  t1421 = 0.4e1 * t1420
  t1423 = t267 * t1342 * t295
  t1425 = t267 * t1284 * t485
  t1426 = t446 * t1285
  t1427 = 0.4e1 * t1426
  t1428 = 0.18311447306006545054854346104378990962041954983034e-3 * t1140
  t1429 = -t914 + t924 + t935 + t939 - t944 - t1421 + t1423 + t1425 + t1427 - t1428 - t1198 + t1205 + t1194
  t1445 = -(t1419 + t1429) * t319 * t324 + 0.3e1 * t1290 * t546 + 0.3e1 * t541 * t1292 - 0.12e2 * t322 * t46 * t1213 * t1271 * t509 + 0.3e1 * t322 * t545 * t1407
  t1453 = t331 * t1082 * t1302
  t1464 = 0.55603792169291016666666666666666666666666666666666e-3 * t1052 - 0.27801896084645508333333333333333333333333333333333e-2 * t537 * t1364 * t1365 * t550 + 0.55603792169291016666666666666666666666666666666666e-2 * t537 * t1115 * t1301 * t550 + 0.64871090864172852777777777777777777777777777777777e-2 * t1384 + 0.55603792169291016666666666666666666666666666666666e-2 * t537 * t1115 * t1365 * t1117 - 0.55603792169291016666666666666666666666666666666666e-2 * t331 * t561 * t337 * t188 * t1407 + t1081 + 0.12974218172834570555555555555555555555555555555555e-1 * t1084 - 0.27801896084645508333333333333333333333333333333333e-2 * t537 * t538 * t539 * t1445 * t326 + 0.64871090864172852777777777777777777777777777777777e-2 * t1113 + 0.12974218172834570555555555555555555555555555555555e-1 * t1453 + 0.16681137650787305000000000000000000000000000000000e-1 * t320 * t329 * t535 * t53 * t544 * t252 * t539 * t1271 * t509
  t1481 = t303 * t312 * (-0.31250000000000000000000000000000000000000000000000e0 * t1025 * t1306 * t327 * t567 + 0.25000000000000000000000000000000000000000000000000e0 * t514 * (t1374 + t1464) * t327 + 0.25000000000000000000000000000000000000000000000000e0 * t1307 * t550 + 0.25000000000000000000000000000000000000000000000000e0 * t568 * t1296 + 0.10000000000000000000000000000000000000000000000000e1 * t345 * t1445 * t326 + 0.10000000000000000000000000000000000000000000000000e1 * t1310 * t550) * t576
  t1482 = t1262 / 0.2e1
  t1483 = t16 * t1482
  t1486 = r1 ** 2
  t1489 = tau1 / t20 / t1486
  t1492 = -t1482
  t1493 = t27 * t1492
  t1497 = f.my_piecewise3(t39, 0.5e1 / 0.3e1 * t9 * t1483 - 0.5e1 / 0.3e1 * t1489 * t28 + 0.5e1 / 0.3e1 * t23 * t1493 + t104, 0)
  t1498 = t70 * t1497
  t1502 = 0.5e1 / 0.3e1 * t1483 + 0.5e1 / 0.3e1 * t1493
  t1503 = t143 * t1502
  t1506 = 0.2e1 * t134 * t1498 - 0.2e1 * t67 * t1503 + t133 - t142
  t1545 = t687 * t1498
  t1552 = t701 * t69 * t1497 * t49
  t1554 = t63 * t1497
  t1561 = t647 * t1482 * t93
  t1565 = t16 * t10 * t652
  t1571 = t658 * t1492 * t97
  t1575 = t27 * t10 * t652
  t1579 = f.my_piecewise3(t39, -0.25e2 / 0.9e1 * t87 * t1483 + 0.10e2 / 0.9e1 * t9 * t1561 + 0.5e1 / 0.3e1 * t9 * t1565 - 0.25e2 / 0.9e1 * t1489 * t98 + 0.10e2 / 0.9e1 * t23 * t1571 - 0.5e1 / 0.3e1 * t23 * t1575 - t670, 0)
  t1585 = t131 * t1503
  t1587 = t63 * t1502
  t1592 = t139 * t1587 * t49
  t1603 = 0.10e2 / 0.9e1 * t1561 + 0.5e1 / 0.3e1 * t1565 + 0.10e2 / 0.9e1 * t1571 - 0.5e1 / 0.3e1 * t1575
  t1607 = t686 + 0.20e2 / 0.3e1 * t688 - t693 - 0.20e2 / 0.3e1 * t694 + 0.20e2 / 0.3e1 * t1545 + 0.2e1 * t66 * t106 * t1498 - 0.2e1 * t1552 - 0.4e1 * t706 * t1554 * t123 + 0.2e1 * t134 * t70 * t1579 - 0.2e1 * t704 + t720 + 0.2e1 * t724 - 0.20e2 / 0.3e1 * t1585 - 0.4e1 * t706 * t1587 * t106 + 0.2e1 * t1592 + 0.6e1 * t67 * t68 * t120 * t1502 * t123 - 0.2e1 * t67 * t143 * t1603
  t1610 = t121 * t1502
  t1611 = t742 * t1610
  t1613 = -0.9e1 * t82 * t121 * t1502 * t106 - 0.3e1 * t82 * t129 * t1506 * t106 + 0.6e1 * t752 * t83 * t1497 * t106 + 0.12e2 * t118 * t776 * t1502 * t123 + 0.3e1 * t118 * t780 * t1506 * t123 + 0.3e1 * t118 * t780 * t1502 * t147 + 0.2e1 * t118 * t787 * t1506 * t147 - 0.9e1 * t82 * t121 * t1497 * t123 - 0.3e1 * t82 * t129 * t1497 * t147 - t118 * t129 * t1607 - 0.15e2 * t1611 - t750 + t773
  t1614 = t129 * t1506
  t1615 = t742 * t1614
  t1620 = t83 * t1497
  t1621 = t139 * t1620
  t1634 = t794 * t73 * t1497 * t49
  t1638 = t800 * t73 * t1502 * t49
  t1642 = t805 * t128 * t1506 * t49
  t1644 = -0.5e1 * t1615 + 0.15e2 * t740 - 0.15e2 * t743 - 0.5e1 * t745 + t739 + 0.15e2 * t1621 + 0.3e1 * t82 * t83 * t1579 - 0.3e1 * t118 * t121 * t1603 + 0.9e1 / 0.2e1 * t803 + 0.3e1 / 0.2e1 * t809 - 0.9e1 / 0.2e1 * t797 - 0.9e1 / 0.2e1 * t1634 + 0.9e1 / 0.2e1 * t1638 + 0.3e1 / 0.2e1 * t1642
  t1645 = t1613 + t1644
  t1646 = f.my_piecewise3(t77, 0, t1645)
  t1653 = -0.3e1 * t118 * t1610 - t118 * t1614 + 0.3e1 * t82 * t1620 - t117 + t80
  t1654 = f.my_piecewise3(t77, 0, t1653)
  t1659 = t153 * t1654
  t1664 = t156 * t1654
  t1669 = t159 * t1654
  t1674 = t162 * t1654
  t1679 = t165 * t1654
  t1684 = -0.64e0 * t1646 - 0.8704e0 * t151 * t1654 - 0.8704e0 * t153 * t1646 - 0.9214113627294e1 * t1659 * t151 - 0.4607056813647e1 * t156 * t1646 + 0.36738723026100e2 * t1664 * t151 + 0.12246241008700e2 * t159 * t1646 - 0.38314204724120e2 * t1669 * t151 - 0.9578551181030e1 * t162 * t1646 + 0.15506534051160e2 * t1674 * t151 + 0.3101306810232e1 * t165 * t1646 - 0.2177652951264e1 * t1679 * t151 - 0.362942158544e0 * t168 * t1646
  t1685 = f.my_piecewise3(t77, t1653, 0)
  t1687 = t180 * t176
  t1690 = f.my_piecewise3(t77, t1645, 0)
  t1698 = f.my_piecewise3(t76, t1684, -0.210e1 * t840 * t1685 * t1687 - 0.105e1 * t175 * t1690 * t180 - 0.1575e1 * t850 * t1685 * t1687)
  t1700 = t1698 * t352 + t1274 - t1275 - t1316 - t1319 + t1324 + t1344 - t1416 - t1417 - t1418 + t1481 - t602 - t629 + t638 + t880 - t883 - t898 + t907
  t1713 = f.my_piecewise3(t76, -0.64e0 * t1654 - 0.8704e0 * t1659 - 0.4607056813647e1 * t1664 + 0.12246241008700e2 * t1669 - 0.9578551181030e1 * t1674 + 0.3101306810232e1 * t1679 - 0.362942158544e0 * t168 * t1654, -0.105e1 * t175 * t1685 * t180)
  t1717 = 0.3e1 * t303 * t499 * t1407
  t1718 = t1284 * t244
  t1722 = 0.12e2 * t435 + 0.12e2 * t438
  t1725 = t303 * t499 * t1271
  t1726 = 0.3e1 * t1725
  t1729 = t303 * t312 * t1313 * t576
  t1730 = t428 - 0.2363e1 * t429 * t1718 + t235 * t1722 - t444 - t445 + t448 + t452 - t1286 - t487 - t1288 + t493 + t498 - t1726 - t1729
  t1732 = t1313 * t576
  t1735 = 0.3e1 * t589 * t1732 * t509
  t1736 = t427 * t1722
  t1740 = -t1274 + t602 + t629 + t1275 - t638 + t1316 + t1319 - t1324 - t1344 + t1736 - t1481 + t956 + t1012 + t235 * (t947 - t953) - t880 + t1416 + t883 + t1417 + t1418 - 0.2363e1 * t1014
  t1748 = t1013 * t1718
  t1753 = -t1427 - 0.2363e1 * t429 * t1284 * t440 - 0.2363e1 * t429 * t363 * t1722 - t1717 + t1428 - t1735 + t1198 - t1205 - t1194 - 0.2363e1 * t1748 - 0.2363e1 * t429 * t1342 * t244
  t1757 = -t914 + t924 + t935 + t939 - t944 + t1713 * t579 - t1421 + t1423 + t1425 + t1427 + t1717 - t1428 + t183 * t1730 + t1735 + t403 * (t1740 + t898 - t907 + t914 - t924 - t935 - t939 + t944 + t1421 - t1423 - t1425 + t1753) - t1198 + t1205 + t1194
  t1760 = t1713 * t352
  t1761 = t403 * t1730
  d12 = t1 * (t1700 + t1757) + t512 + t454 + t1760 + t488 + t1726 + t582 + t1286 + t580 - t588 + t1761 + t585 - t583 + t353 + t578 - t1261 + t392 + t1288 + t1729
  t1762 = 0.11696447245269292414524477327518106963944910680856e1 * t1318
  t1765 = 0.6e1 * t589 * t1732 * t1271
  t1767 = t1262 ** 2
  t1770 = t90 + t653
  t1771 = 0.2e1 * t1770
  t1775 = f.my_piecewise3(t218, 0, 0.4e1 / 0.9e1 * t857 * t1767 + 0.4e1 / 0.3e1 * t221 * t1771)
  t1776 = t1266 ** 2
  t1779 = -t1771
  t1783 = f.my_piecewise3(t224, 0, 0.4e1 / 0.9e1 * t866 * t1776 + 0.4e1 / 0.3e1 * t225 * t1779)
  t1785 = (t1775 + t1783) * t231
  t1787 = t267 * t1785 * t295
  t1788 = 0.36622894612013090109708692208757981924083909966068e-3 * t1415
  t1789 = t1271 ** 2
  t1792 = 0.6e1 * t303 * t925 * t1789
  t1793 = t1313 ** 2
  t1796 = t303 * t312 * t1793 * t891
  t1803 = t602 + t629 - t638 + t1762 - t1765 + 0.2e1 * t1736 - t1787 + t1012 + t1788 + t883 - t1792 + t1796 + t895 - 0.2363e1 * t429 * t1785 * t244 - 0.4726e1 * t429 * t1284 * t1722 + t898 - t907
  t1809 = f.my_piecewise3(t218, 0, -0.2e1 / 0.9e1 * t1054 * t1767 + 0.2e1 / 0.3e1 * t500 * t1771)
  t1815 = f.my_piecewise3(t224, 0, -0.2e1 / 0.9e1 * t1061 * t1776 + 0.2e1 / 0.3e1 * t504 * t1779)
  t1817 = t1809 / 0.2e1 + t1815 / 0.2e1
  t1820 = 0.3e1 * t303 * t499 * t1817
  t1821 = 0.8e1 * t1420
  t1822 = 0.2e1 * t1425
  t1823 = 0.8e1 * t1426
  t1825 = 0.19751673498613801407483339618206552048944131217655e-1 * t1785 * t293
  t1826 = t1306 ** 2
  t1833 = t1295 ** 2
  t1857 = t1787 + t1822 - t898 - t629 - t602 + t935 + t1198 - t1821 - t883 - t1788 + t638
  t1858 = t1194 + t907 + t1205 - t1823 - t895 + t1201 - t1762 - t944 + t924 + t1825 - t914 + t939
  t1870 = -(t1857 + t1858) * t319 * t324 + 0.6e1 * t1290 * t1292 - 0.12e2 * t322 * t1214 * t1789 + 0.3e1 * t322 * t545 * t1817
  t1881 = -t1104 - 0.98863542476999427633333333333333333333333333333332e-3 * t1353 + 0.55603792169291016666666666666666666666666666666666e-3 * t1357 - t1090 - 0.19772708495399885526666666666666666666666666666666e-2 * t1361 + 0.55603792169291016666666666666666666666666666666666e-2 * t1132 * t538 * t539 * t1833 * t1133 - 0.27801896084645508333333333333333333333333333333333e-2 * t537 * t538 * t539 * t1833 * t326 + 0.12974218172834570555555555555555555555555555555555e-1 * t1384 + 0.11120758433858203333333333333333333333333333333333e-1 * t537 * t1115 * t1365 * t326 * t1271 + 0.11120758433858203333333333333333333333333333333333e-2 * t1372 + t1050 + t1081 + 0.25948436345669141111111111111111111111111111111110e-1 * t1453 + t1046 - 0.55603792169291016666666666666666666666666666666666e-2 * t331 * t561 * t337 * t188 * t1817 - 0.27801896084645508333333333333333333333333333333333e-2 * t537 * t538 * t539 * t1870 * t326 + 0.16681137650787305000000000000000000000000000000000e-1 * t331 * t1227 * t337 * t188 * t1789
  t1896 = t303 * t312 * (-0.31250000000000000000000000000000000000000000000000e0 * t1025 * t1826 * t327 + 0.25000000000000000000000000000000000000000000000000e0 * t514 * t1881 * t327 + 0.50000000000000000000000000000000000000000000000000e0 * t1307 * t1296 + 0.10000000000000000000000000000000000000000000000000e1 * t345 * t1870 * t326 + 0.10000000000000000000000000000000000000000000000000e1 * t345 * t1833 * t326) * t576
  t1900 = t914 - t924 - t935 - t939 + t944 - t1820 + t1821 - t1822 + t1823 - t1825 - t1896 - t1198 - t1201 - t1205 - t1194 - 0.4726e1 * t1748 + t235 * (-t947 - t949 - t953)
  t1905 = -t602 - t629 + t638 - t1762 + t403 * (t1803 + t1900) + t1765 + 0.2e1 * t1713 * t1730 + t1787 - t1788 - t883 + t1792 - t1796 - t895 - t898 + t907
  t1906 = t1497 ** 2
  t1918 = t1502 ** 2
  t1931 = t1482 ** 2
  t1932 = t647 * t1931
  t1935 = t16 * t1770
  t1946 = t1492 ** 2
  t1947 = t658 * t1946
  t1951 = -t27 * t1770
  t1955 = f.my_piecewise3(t39, 0.10e2 / 0.9e1 * t9 * t1932 + 0.5e1 / 0.3e1 * t9 * t1935 + 0.40e2 / 0.9e1 * tau1 / t20 / t1486 / r1 * t28 - 0.50e2 / 0.9e1 * t1489 * t1493 + 0.10e2 / 0.9e1 * t23 * t1947 + 0.5e1 / 0.3e1 * t23 * t1951 - t670, 0)
  t1963 = 0.10e2 / 0.9e1 * t1932 + 0.5e1 / 0.3e1 * t1935 + 0.10e2 / 0.9e1 * t1947 + 0.5e1 / 0.3e1 * t1951
  t1986 = t686 + 0.40e2 / 0.3e1 * t1545 - t693 - 0.40e2 / 0.3e1 * t1585 + 0.2e1 * t66 * t1906 * t70 - 0.4e1 * t1552 - 0.8e1 * t706 * t1554 * t1502 + 0.2e1 * t134 * t70 * t1955 + t720 + 0.4e1 * t1592 + 0.6e1 * t67 * t726 * t1918 - 0.2e1 * t67 * t143 * t1963
  t1989 = t1506 ** 2
  t1994 = 0.6e1 * t118 * t780 * t1502 * t1506 - 0.18e2 * t82 * t121 * t1497 * t1502 - 0.6e1 * t82 * t129 * t1497 * t1506 - 0.3e1 * t118 * t121 * t1963 - t118 * t129 * t1986 + 0.12e2 * t118 * t776 * t1918 + 0.2e1 * t118 * t787 * t1989 + 0.6e1 * t752 * t83 * t1906 + 0.3e1 * t82 * t83 * t1955 - 0.30e2 * t1611 - 0.10e2 * t1615 + 0.30e2 * t1621 - 0.9e1 * t1634 + 0.9e1 * t1638 + 0.3e1 * t1642 + t739 - t750 + t773
  t1995 = f.my_piecewise3(t77, 0, t1994)
  t1997 = t1654 ** 2
  t2021 = -0.64e0 * t1995 - 0.8704e0 * t1997 - 0.8704e0 * t153 * t1995 - 0.9214113627294e1 * t153 * t1997 - 0.4607056813647e1 * t156 * t1995 + 0.36738723026100e2 * t156 * t1997 + 0.12246241008700e2 * t159 * t1995 - 0.38314204724120e2 * t159 * t1997 - 0.9578551181030e1 * t162 * t1995 + 0.15506534051160e2 * t162 * t1997 + 0.3101306810232e1 * t165 * t1995 - 0.2177652951264e1 * t165 * t1997 - 0.362942158544e0 * t168 * t1995
  t2022 = t1685 ** 2
  t2026 = f.my_piecewise3(t77, t1994, 0)
  t2034 = f.my_piecewise3(t76, t2021, -0.210e1 * t840 * t2022 * t180 - 0.105e1 * t175 * t2026 * t180 - 0.1575e1 * t850 * t2022 * t180)
  t2036 = t2034 * t352 + t1194 + t1198 + t1201 + t1205 + t1820 - t1821 + t1822 - t1823 + t1825 + t1896 - t914 + t924 + t935 + t939 - t944
  d22 = -t1261 + t1 * (t1905 + t2036) - t588 + 0.39503346997227602814966679236413104097888262435310e-1 * t1287 + 0.6e1 * t1725 + 0.2e1 * t1761 + t582 - t586 - t583 + 0.2e1 * t1286 + 0.2e1 * t1729 + t392 + t585 + 0.2e1 * t1760
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

