"""Generated from gga_c_op_g96.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  g96_c1 = 1 / 137

  op_a1 = 1.5214

  op_a2 = 0.5764

  op_b1 = 1.1284

  op_b2 = 0.3183

  op_qab = 2.3638

  f_g96 = lambda x: 1 + g96_c1 / X_FACTOR_C * x ** (3 / 2)

  op_enhancement = lambda xs: f_g96(xs)

  op_b88_zab = lambda f_x, rs, z, xs0, xs1: f.my_piecewise3(b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1) == 0, DBL_EPSILON, b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1))

  op_beta = lambda rs, z, xs0, xs1: op_qab / op_b88_zab(op_enhancement, rs, z, xs0, xs1)

  op_f_s = lambda rs, z, xt, xs0, xs1: -(1 - z ** 2) * f.n_total(rs) / 4.0 * (op_a1 * op_beta(rs, z, xs0, xs1) + op_a2) / (op_beta(rs, z, xs0, xs1) ** 4 + op_b1 * op_beta(rs, z, xs0, xs1) ** 3 + op_b2 * op_beta(rs, z, xs0, xs1) ** 2)

  op_f = lambda rs, z, xt, xs0, xs1: f.my_piecewise3(jnp.logical_or(1 - jnp.abs(z) <= f.p.zeta_threshold, jnp.logical_and(f.screen_dens(rs, z), f.screen_dens(rs, -z))), 0, op_f_s(rs, f.z_thr(z), xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1: op_f(rs, z, xt, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  g96_c1 = 1 / 137

  op_a1 = 1.5214

  op_a2 = 0.5764

  op_b1 = 1.1284

  op_b2 = 0.3183

  op_qab = 2.3638

  f_g96 = lambda x: 1 + g96_c1 / X_FACTOR_C * x ** (3 / 2)

  op_enhancement = lambda xs: f_g96(xs)

  op_b88_zab = lambda f_x, rs, z, xs0, xs1: f.my_piecewise3(b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1) == 0, DBL_EPSILON, b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1))

  op_beta = lambda rs, z, xs0, xs1: op_qab / op_b88_zab(op_enhancement, rs, z, xs0, xs1)

  op_f_s = lambda rs, z, xt, xs0, xs1: -(1 - z ** 2) * f.n_total(rs) / 4.0 * (op_a1 * op_beta(rs, z, xs0, xs1) + op_a2) / (op_beta(rs, z, xs0, xs1) ** 4 + op_b1 * op_beta(rs, z, xs0, xs1) ** 3 + op_b2 * op_beta(rs, z, xs0, xs1) ** 2)

  op_f = lambda rs, z, xt, xs0, xs1: f.my_piecewise3(jnp.logical_or(1 - jnp.abs(z) <= f.p.zeta_threshold, jnp.logical_and(f.screen_dens(rs, z), f.screen_dens(rs, -z))), 0, op_f_s(rs, f.z_thr(z), xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1: op_f(rs, z, xt, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  g96_c1 = 1 / 137

  op_a1 = 1.5214

  op_a2 = 0.5764

  op_b1 = 1.1284

  op_b2 = 0.3183

  op_qab = 2.3638

  f_g96 = lambda x: 1 + g96_c1 / X_FACTOR_C * x ** (3 / 2)

  op_enhancement = lambda xs: f_g96(xs)

  op_b88_zab = lambda f_x, rs, z, xs0, xs1: f.my_piecewise3(b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1) == 0, DBL_EPSILON, b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1))

  op_beta = lambda rs, z, xs0, xs1: op_qab / op_b88_zab(op_enhancement, rs, z, xs0, xs1)

  op_f_s = lambda rs, z, xt, xs0, xs1: -(1 - z ** 2) * f.n_total(rs) / 4.0 * (op_a1 * op_beta(rs, z, xs0, xs1) + op_a2) / (op_beta(rs, z, xs0, xs1) ** 4 + op_b1 * op_beta(rs, z, xs0, xs1) ** 3 + op_b2 * op_beta(rs, z, xs0, xs1) ** 2)

  op_f = lambda rs, z, xt, xs0, xs1: f.my_piecewise3(jnp.logical_or(1 - jnp.abs(z) <= f.p.zeta_threshold, jnp.logical_and(f.screen_dens(rs, z), f.screen_dens(rs, -z))), 0, op_f_s(rs, f.z_thr(z), xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1: op_f(rs, z, xt, xs0, xs1)

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = abs(t4)
  t11 = 0.1e1 - t5 <= f.p.zeta_threshold or r0 <= f.p.dens_threshold and r1 <= f.p.dens_threshold
  t13 = 0.1e1 + t4 <= f.p.zeta_threshold
  t14 = f.p.zeta_threshold - 0.1e1
  t16 = 0.1e1 - t4 <= f.p.zeta_threshold
  t17 = -t14
  t18 = f.my_piecewise5(t13, t14, t16, t17, t4)
  t19 = t18 ** 2
  t20 = 0.1e1 - t19
  t21 = t20 * t2
  t24 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t27 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t28 = f.my_piecewise5(t24, t14, t27, t17, t4)
  t29 = 0.1e1 + t28
  t32 = t29 * t2 / 0.2e1 <= f.p.dens_threshold
  t33 = 3 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t36 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t38 = t34 / t36
  t39 = 4 ** (0.1e1 / 0.3e1)
  t40 = t38 * t39
  t41 = 2 ** (0.1e1 / 0.3e1)
  t42 = t29 <= f.p.zeta_threshold
  t43 = 0.1e1 - t28
  t44 = t43 <= f.p.zeta_threshold
  t45 = f.my_piecewise5(t42, t14, t44, t17, t28)
  t47 = (0.1e1 + t45) * t2
  t48 = t47 ** (0.1e1 / 0.3e1)
  t49 = 0.1e1 / t48
  t51 = jnp.sqrt(s0)
  t52 = r0 ** (0.1e1 / 0.3e1)
  t54 = 0.1e1 / t52 / r0
  t55 = t51 * t54
  t56 = jnp.sqrt(t55)
  t61 = 0.1e1 + 0.2e1 / 0.1233e4 * t38 * t39 * t56 * t55
  t62 = 0.1e1 / t61
  t66 = f.my_piecewise3(t32, 0, t40 * t41 * t49 * t62 / 0.9e1)
  t70 = t43 * t2 / 0.2e1 <= f.p.dens_threshold
  t71 = f.my_piecewise5(t44, t14, t42, t17, -t28)
  t73 = (0.1e1 + t71) * t2
  t74 = t73 ** (0.1e1 / 0.3e1)
  t75 = 0.1e1 / t74
  t77 = jnp.sqrt(s2)
  t78 = r1 ** (0.1e1 / 0.3e1)
  t80 = 0.1e1 / t78 / r1
  t81 = t77 * t80
  t82 = jnp.sqrt(t81)
  t87 = 0.1e1 + 0.2e1 / 0.1233e4 * t38 * t39 * t82 * t81
  t88 = 0.1e1 / t87
  t92 = f.my_piecewise3(t70, 0, t40 * t41 * t75 * t88 / 0.9e1)
  t93 = t66 + t92
  t94 = t93 == 0.0e0
  t95 = f.my_piecewise3(t94, DBL_EPSILON, t93)
  t98 = 0.359628532e1 / t95 + 0.5764e0
  t99 = t95 ** 2
  t100 = t99 ** 2
  t101 = 0.1e1 / t100
  t104 = 0.1e1 / t99 / t95
  t106 = 0.1e1 / t99
  t108 = 0.312207199195441936e2 * t101 + 0.149037398922132448e2 * t104 + 0.1778517305052e1 * t106
  t109 = 0.1e1 / t108
  t113 = f.my_piecewise3(t11, 0, -0.25000000000000000000000000000000000000000000000000e0 * t21 * t98 * t109)
  t114 = t2 ** 2
  t116 = t1 / t114
  t117 = t3 - t116
  t118 = f.my_piecewise5(t13, 0, t16, 0, t117)
  t121 = t2 * t98 * t109
  t126 = 0.25000000000000000000000000000000000000000000000000e0 * t20 * t98 * t109
  t129 = t41 / t48 / t47
  t130 = f.my_piecewise5(t24, 0, t27, 0, t117)
  t131 = f.my_piecewise5(t42, 0, t44, 0, t130)
  t138 = t36 ** 2
  t141 = t39 ** 2
  t143 = t33 / t138 * t141 * t41
  t144 = t61 ** 2
  t146 = t49 / t144
  t148 = r0 ** 2
  t156 = f.my_piecewise3(t32, 0, -t40 * t129 * t62 * (t131 * t2 + t45 + 0.1e1) / 0.27e2 + 0.4e1 / 0.3699e4 * t143 * t146 * t56 * t51 / t52 / t148)
  t159 = t41 / t74 / t73
  t160 = f.my_piecewise5(t44, 0, t42, 0, -t130)
  t167 = f.my_piecewise3(t70, 0, -t40 * t159 * t88 * (t160 * t2 + t71 + 0.1e1) / 0.27e2)
  t169 = f.my_piecewise3(t94, 0, t156 + t167)
  t174 = t108 ** 2
  t176 = t98 / t174
  t178 = 0.1e1 / t100 / t95
  t190 = f.my_piecewise3(t11, 0, 0.50000000000000000000000000000000000000000000000000e0 * t18 * t118 * t121 - t126 + 0.89907133000000000000000000000000000000000000000000e0 * t21 * t106 * t169 * t109 + 0.25000000000000000000000000000000000000000000000000e0 * t21 * t176 * (-0.1248828796781767744e3 * t178 * t169 - 0.447112196766397344e2 * t101 * t169 - 0.3557034610104e1 * t104 * t169))
  vrho_0_ = t2 * t190 + t113
  t192 = -t3 - t116
  t193 = f.my_piecewise5(t13, 0, t16, 0, t192)
  t197 = f.my_piecewise5(t24, 0, t27, 0, t192)
  t198 = f.my_piecewise5(t42, 0, t44, 0, t197)
  t205 = f.my_piecewise3(t32, 0, -t40 * t129 * t62 * (t198 * t2 + t45 + 0.1e1) / 0.27e2)
  t206 = f.my_piecewise5(t44, 0, t42, 0, -t197)
  t213 = t87 ** 2
  t215 = t75 / t213
  t217 = r1 ** 2
  t225 = f.my_piecewise3(t70, 0, -t40 * t159 * t88 * (t206 * t2 + t71 + 0.1e1) / 0.27e2 + 0.4e1 / 0.3699e4 * t143 * t215 * t82 * t77 / t78 / t217)
  t227 = f.my_piecewise3(t94, 0, t205 + t225)
  t243 = f.my_piecewise3(t11, 0, 0.50000000000000000000000000000000000000000000000000e0 * t18 * t193 * t121 - t126 + 0.89907133000000000000000000000000000000000000000000e0 * t21 * t106 * t227 * t109 + 0.25000000000000000000000000000000000000000000000000e0 * t21 * t176 * (-0.1248828796781767744e3 * t178 * t227 - 0.447112196766397344e2 * t101 * t227 - 0.3557034610104e1 * t104 * t227))
  vrho_1_ = t2 * t243 + t113
  t251 = f.my_piecewise3(t32, 0, -t143 * t146 * t56 / t51 * t54 / 0.2466e4)
  t252 = f.my_piecewise3(t94, 0, t251)
  t268 = f.my_piecewise3(t11, 0, 0.89907133000000000000000000000000000000000000000000e0 * t21 * t106 * t252 * t109 + 0.25000000000000000000000000000000000000000000000000e0 * t21 * t176 * (-0.1248828796781767744e3 * t178 * t252 - 0.447112196766397344e2 * t101 * t252 - 0.3557034610104e1 * t104 * t252))
  vsigma_0_ = t2 * t268
  vsigma_1_ = 0.0e0
  t275 = f.my_piecewise3(t70, 0, -t143 * t215 * t82 / t77 * t80 / 0.2466e4)
  t276 = f.my_piecewise3(t94, 0, t275)
  t292 = f.my_piecewise3(t11, 0, 0.89907133000000000000000000000000000000000000000000e0 * t21 * t106 * t276 * t109 + 0.25000000000000000000000000000000000000000000000000e0 * t21 * t176 * (-0.1248828796781767744e3 * t178 * t276 - 0.447112196766397344e2 * t101 * t276 - 0.3557034610104e1 * t104 * t276))
  vsigma_2_ = t2 * t292
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  g96_c1 = 1 / 137

  op_a1 = 1.5214

  op_a2 = 0.5764

  op_b1 = 1.1284

  op_b2 = 0.3183

  op_qab = 2.3638

  f_g96 = lambda x: 1 + g96_c1 / X_FACTOR_C * x ** (3 / 2)

  op_enhancement = lambda xs: f_g96(xs)

  op_b88_zab = lambda f_x, rs, z, xs0, xs1: f.my_piecewise3(b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1) == 0, DBL_EPSILON, b88_zab(f, params, 1, op_enhancement, rs, z, xs0, xs1))

  op_beta = lambda rs, z, xs0, xs1: op_qab / op_b88_zab(op_enhancement, rs, z, xs0, xs1)

  op_f_s = lambda rs, z, xt, xs0, xs1: -(1 - z ** 2) * f.n_total(rs) / 4.0 * (op_a1 * op_beta(rs, z, xs0, xs1) + op_a2) / (op_beta(rs, z, xs0, xs1) ** 4 + op_b1 * op_beta(rs, z, xs0, xs1) ** 3 + op_b2 * op_beta(rs, z, xs0, xs1) ** 2)

  op_f = lambda rs, z, xt, xs0, xs1: f.my_piecewise3(jnp.logical_or(1 - jnp.abs(z) <= f.p.zeta_threshold, jnp.logical_and(f.screen_dens(rs, z), f.screen_dens(rs, -z))), 0, op_f_s(rs, f.z_thr(z), xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1: op_f(rs, z, xt, xs0, xs1)

  t1 = 0.1e1 <= f.p.zeta_threshold
  t4 = t1 or r0 / 0.2e1 <= f.p.dens_threshold
  t5 = f.p.zeta_threshold - 0.1e1
  t6 = -t5
  t7 = f.my_piecewise5(t1, t5, t1, t6, 0)
  t8 = t7 ** 2
  t9 = 0.1e1 - t8
  t10 = t9 * r0
  t11 = 0.1e1 + t7
  t14 = t11 * r0 / 0.2e1 <= f.p.dens_threshold
  t15 = 3 ** (0.1e1 / 0.3e1)
  t16 = t15 ** 2
  t18 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t20 = t16 / t18
  t21 = 4 ** (0.1e1 / 0.3e1)
  t22 = t20 * t21
  t23 = 2 ** (0.1e1 / 0.3e1)
  t24 = t11 <= f.p.zeta_threshold
  t25 = 0.1e1 - t7
  t26 = t25 <= f.p.zeta_threshold
  t27 = f.my_piecewise5(t24, t5, t26, t6, t7)
  t28 = 0.1e1 + t27
  t29 = t28 * r0
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = 0.1e1 / t30
  t33 = jnp.sqrt(s0)
  t35 = r0 ** (0.1e1 / 0.3e1)
  t37 = 0.1e1 / t35 / r0
  t38 = t33 * t23 * t37
  t39 = jnp.sqrt(t38)
  t44 = 0.1e1 + 0.2e1 / 0.1233e4 * t20 * t21 * t39 * t38
  t45 = 0.1e1 / t44
  t49 = f.my_piecewise3(t14, 0, t22 * t23 * t31 * t45 / 0.9e1)
  t53 = t25 * r0 / 0.2e1 <= f.p.dens_threshold
  t54 = f.my_piecewise5(t26, t5, t24, t6, -t7)
  t55 = 0.1e1 + t54
  t56 = t55 * r0
  t57 = t56 ** (0.1e1 / 0.3e1)
  t58 = 0.1e1 / t57
  t63 = f.my_piecewise3(t53, 0, t22 * t23 * t58 * t45 / 0.9e1)
  t64 = t49 + t63
  t65 = t64 == 0.0e0
  t66 = f.my_piecewise3(t65, DBL_EPSILON, t64)
  t69 = 0.359628532e1 / t66 + 0.5764e0
  t70 = t66 ** 2
  t71 = t70 ** 2
  t72 = 0.1e1 / t71
  t75 = 0.1e1 / t70 / t66
  t77 = 0.1e1 / t70
  t79 = 0.312207199195441936e2 * t72 + 0.149037398922132448e2 * t75 + 0.1778517305052e1 * t77
  t80 = 0.1e1 / t79
  t84 = f.my_piecewise3(t4, 0, -0.25000000000000000000000000000000000000000000000000e0 * t10 * t69 * t80)
  t95 = t18 ** 2
  t98 = t21 ** 2
  t99 = t23 ** 2
  t101 = t15 / t95 * t98 * t99
  t102 = t44 ** 2
  t103 = 0.1e1 / t102
  t104 = t31 * t103
  t106 = r0 ** 2
  t109 = t39 * t33 / t35 / t106
  t114 = f.my_piecewise3(t14, 0, -t22 * t23 / t30 / t29 * t45 * t28 / 0.27e2 + 0.4e1 / 0.3699e4 * t101 * t104 * t109)
  t122 = t58 * t103
  t127 = f.my_piecewise3(t53, 0, -t22 * t23 / t57 / t56 * t45 * t55 / 0.27e2 + 0.4e1 / 0.3699e4 * t101 * t122 * t109)
  t129 = f.my_piecewise3(t65, 0, t114 + t127)
  t134 = t79 ** 2
  t136 = t69 / t134
  t138 = 0.1e1 / t71 / t66
  t150 = f.my_piecewise3(t4, 0, -0.25000000000000000000000000000000000000000000000000e0 * t9 * t69 * t80 + 0.89907133000000000000000000000000000000000000000000e0 * t10 * t77 * t129 * t80 + 0.25000000000000000000000000000000000000000000000000e0 * t10 * t136 * (-0.1248828796781767744e3 * t138 * t129 - 0.447112196766397344e2 * t72 * t129 - 0.3557034610104e1 * t75 * t129))
  vrho_0_ = r0 * t150 + t84
  t154 = t39 / t33 * t37
  t158 = f.my_piecewise3(t14, 0, -t101 * t104 * t154 / 0.2466e4)
  t162 = f.my_piecewise3(t53, 0, -t101 * t122 * t154 / 0.2466e4)
  t164 = f.my_piecewise3(t65, 0, t158 + t162)
  t180 = f.my_piecewise3(t4, 0, 0.89907133000000000000000000000000000000000000000000e0 * t10 * t77 * t164 * t80 + 0.25000000000000000000000000000000000000000000000000e0 * t10 * t136 * (-0.1248828796781767744e3 * t138 * t164 - 0.447112196766397344e2 * t72 * t164 - 0.3557034610104e1 * t75 * t164))
  vsigma_0_ = r0 * t180
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 0.1e1 <= f.p.zeta_threshold
  t4 = t1 or r0 / 0.2e1 <= f.p.dens_threshold
  t5 = f.p.zeta_threshold - 0.1e1
  t6 = -t5
  t7 = f.my_piecewise5(t1, t5, t1, t6, 0)
  t8 = t7 ** 2
  t9 = 0.1e1 - t8
  t10 = 0.1e1 + t7
  t13 = t10 * r0 / 0.2e1 <= f.p.dens_threshold
  t14 = 3 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t19 = t15 / t17
  t20 = 4 ** (0.1e1 / 0.3e1)
  t21 = t19 * t20
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = t10 <= f.p.zeta_threshold
  t24 = 0.1e1 - t7
  t25 = t24 <= f.p.zeta_threshold
  t26 = f.my_piecewise5(t23, t5, t25, t6, t7)
  t27 = 0.1e1 + t26
  t28 = t27 * r0
  t29 = t28 ** (0.1e1 / 0.3e1)
  t30 = 0.1e1 / t29
  t32 = jnp.sqrt(s0)
  t33 = t32 * t22
  t34 = r0 ** (0.1e1 / 0.3e1)
  t36 = 0.1e1 / t34 / r0
  t37 = t33 * t36
  t38 = jnp.sqrt(t37)
  t43 = 0.1e1 + 0.2e1 / 0.1233e4 * t19 * t20 * t38 * t37
  t44 = 0.1e1 / t43
  t48 = f.my_piecewise3(t13, 0, t21 * t22 * t30 * t44 / 0.9e1)
  t52 = t24 * r0 / 0.2e1 <= f.p.dens_threshold
  t53 = f.my_piecewise5(t25, t5, t23, t6, -t7)
  t54 = 0.1e1 + t53
  t55 = t54 * r0
  t56 = t55 ** (0.1e1 / 0.3e1)
  t57 = 0.1e1 / t56
  t62 = f.my_piecewise3(t52, 0, t21 * t22 * t57 * t44 / 0.9e1)
  t63 = t48 + t62
  t64 = t63 == 0.0e0
  t65 = f.my_piecewise3(t64, DBL_EPSILON, t63)
  t68 = 0.359628532e1 / t65 + 0.5764e0
  t69 = t9 * t68
  t70 = t65 ** 2
  t71 = t70 ** 2
  t72 = 0.1e1 / t71
  t75 = 0.1e1 / t70 / t65
  t77 = 0.1e1 / t70
  t79 = 0.312207199195441936e2 * t72 + 0.149037398922132448e2 * t75 + 0.1778517305052e1 * t77
  t80 = 0.1e1 / t79
  t83 = t9 * r0
  t85 = 0.1e1 / t29 / t28
  t91 = t17 ** 2
  t93 = t14 / t91
  t94 = t20 ** 2
  t95 = t22 ** 2
  t96 = t94 * t95
  t97 = t93 * t96
  t98 = t43 ** 2
  t99 = 0.1e1 / t98
  t100 = t30 * t99
  t101 = t38 * t32
  t102 = r0 ** 2
  t104 = 0.1e1 / t34 / t102
  t105 = t101 * t104
  t110 = f.my_piecewise3(t13, 0, -t21 * t22 * t85 * t44 * t27 / 0.27e2 + 0.4e1 / 0.3699e4 * t97 * t100 * t105)
  t112 = 0.1e1 / t56 / t55
  t118 = t57 * t99
  t123 = f.my_piecewise3(t52, 0, -t21 * t22 * t112 * t44 * t54 / 0.27e2 + 0.4e1 / 0.3699e4 * t97 * t118 * t105)
  t125 = f.my_piecewise3(t64, 0, t110 + t123)
  t130 = t79 ** 2
  t131 = 0.1e1 / t130
  t132 = t68 * t131
  t134 = 0.1e1 / t71 / t65
  t141 = -0.1248828796781767744e3 * t134 * t125 - 0.447112196766397344e2 * t72 * t125 - 0.3557034610104e1 * t75 * t125
  t146 = f.my_piecewise3(t4, 0, -0.25000000000000000000000000000000000000000000000000e0 * t69 * t80 + 0.89907133000000000000000000000000000000000000000000e0 * t83 * t77 * t125 * t80 + 0.25000000000000000000000000000000000000000000000000e0 * t83 * t132 * t141)
  t148 = t9 * t77
  t155 = t125 ** 2
  t160 = t27 ** 2
  t170 = t93 * t96 * t85
  t177 = 0.1e1 / t98 / t43
  t178 = jnp.pi * t30 * t177
  t179 = t32 * s0
  t181 = t102 ** 2
  t184 = t179 * t22 / t181 / t102
  t188 = t93 * t94 * t30
  t189 = 0.1e1 / t38
  t190 = t99 * t189
  t191 = t34 ** 2
  t195 = t190 * s0 / t191 / t181
  t198 = t102 * r0
  t201 = t101 / t34 / t198
  t206 = f.my_piecewise3(t13, 0, 0.4e1 / 0.81e2 * t21 * t22 / t29 / t102 * t44 - 0.8e1 / 0.11097e5 * t170 * t99 * t27 * t105 + 0.256e3 / 0.1520289e7 * t178 * t184 - 0.16e2 / 0.11097e5 * t188 * t195 - 0.28e2 / 0.11097e5 * t97 * t100 * t201)
  t207 = t54 ** 2
  t217 = t93 * t96 * t112
  t223 = jnp.pi * t57 * t177
  t227 = t93 * t94 * t57
  t234 = f.my_piecewise3(t52, 0, 0.4e1 / 0.81e2 * t21 * t22 / t56 / t102 * t44 - 0.8e1 / 0.11097e5 * t217 * t99 * t54 * t105 + 0.256e3 / 0.1520289e7 * t223 * t184 - 0.16e2 / 0.11097e5 * t227 * t195 - 0.28e2 / 0.11097e5 * t97 * t118 * t201)
  t236 = f.my_piecewise3(t64, 0, t206 + t234)
  t241 = t83 * t77
  t242 = t125 * t131
  t247 = 0.1e1 / t130 / t79
  t248 = t68 * t247
  t249 = t141 ** 2
  t254 = 0.1e1 / t71 / t70
  t272 = f.my_piecewise3(t4, 0, 0.17981426600000000000000000000000000000000000000000e1 * t148 * t125 * t80 + 0.50000000000000000000000000000000000000000000000000e0 * t69 * t131 * t141 - 0.17981426600000000000000000000000000000000000000000e1 * t83 * t75 * t155 * t80 + 0.89907133000000000000000000000000000000000000000000e0 * t83 * t77 * t236 * t80 - 0.17981426600000000000000000000000000000000000000000e1 * t241 * t242 * t141 - 0.50000000000000000000000000000000000000000000000000e0 * t83 * t248 * t249 + 0.25000000000000000000000000000000000000000000000000e0 * t83 * t132 * (0.6244143983908838720e3 * t254 * t155 - 0.1248828796781767744e3 * t134 * t236 + 0.1788448787065589376e3 * t134 * t155 - 0.447112196766397344e2 * t72 * t236 + 0.10671103830312e2 * t72 * t155 - 0.3557034610104e1 * t75 * t236))
  v2rho2_0_ = r0 * t272 + 0.2e1 * t146
  t274 = 0.1e1 / t32
  t275 = t38 * t274
  t276 = t275 * t36
  t280 = f.my_piecewise3(t13, 0, -t97 * t100 * t276 / 0.2466e4)
  t284 = f.my_piecewise3(t52, 0, -t97 * t118 * t276 / 0.2466e4)
  t286 = f.my_piecewise3(t64, 0, t280 + t284)
  t291 = t134 * t286
  t293 = t72 * t286
  t297 = -0.1248828796781767744e3 * t291 - 0.447112196766397344e2 * t293 - 0.3557034610104e1 * t75 * t286
  t302 = f.my_piecewise3(t4, 0, 0.89907133000000000000000000000000000000000000000000e0 * t83 * t77 * t286 * t80 + 0.25000000000000000000000000000000000000000000000000e0 * t83 * t132 * t297)
  t303 = t286 * t80
  t310 = t99 * t38
  t311 = t274 * t36
  t318 = t33 / t181 / r0
  t321 = t93 * t94
  t324 = t189 / t191 / t198
  t328 = t275 * t104
  t333 = f.my_piecewise3(t13, 0, t170 * t310 * t311 * t27 / 0.7398e4 - 0.32e2 / 0.506763e6 * t178 * t318 + 0.2e1 / 0.3699e4 * t321 * t100 * t324 + 0.2e1 / 0.3699e4 * t97 * t100 * t328)
  t347 = f.my_piecewise3(t52, 0, t217 * t310 * t311 * t54 / 0.7398e4 - 0.32e2 / 0.506763e6 * t223 * t318 + 0.2e1 / 0.3699e4 * t321 * t118 * t324 + 0.2e1 / 0.3699e4 * t97 * t118 * t328)
  t349 = f.my_piecewise3(t64, 0, t333 + t347)
  t354 = t286 * t131
  t387 = f.my_piecewise3(t4, 0, 0.89907133000000000000000000000000000000000000000000e0 * t148 * t303 - 0.17981426600000000000000000000000000000000000000000e1 * t83 * t75 * t303 * t125 + 0.89907133000000000000000000000000000000000000000000e0 * t83 * t77 * t349 * t80 - 0.89907133000000000000000000000000000000000000000000e0 * t241 * t354 * t141 + 0.25000000000000000000000000000000000000000000000000e0 * t69 * t131 * t297 - 0.89907133000000000000000000000000000000000000000000e0 * t241 * t242 * t297 - 0.50000000000000000000000000000000000000000000000000e0 * t83 * t68 * t247 * t297 * t141 + 0.25000000000000000000000000000000000000000000000000e0 * t83 * t132 * (0.6244143983908838720e3 * t254 * t286 * t125 - 0.1248828796781767744e3 * t134 * t349 + 0.1788448787065589376e3 * t291 * t125 - 0.447112196766397344e2 * t72 * t349 + 0.10671103830312e2 * t293 * t125 - 0.3557034610104e1 * t75 * t349))
  v2rhosigma_0_ = r0 * t387 + t302
  t389 = t286 ** 2
  t396 = t274 * t22 / t181
  t403 = t190 / s0 / t191 / t102
  t408 = t38 / t179 * t36
  t413 = f.my_piecewise3(t13, 0, 0.4e1 / 0.168921e6 * t178 * t396 - t188 * t403 / 0.4932e4 + t97 * t100 * t408 / 0.4932e4)
  t422 = f.my_piecewise3(t52, 0, 0.4e1 / 0.168921e6 * t223 * t396 - t227 * t403 / 0.4932e4 + t97 * t118 * t408 / 0.4932e4)
  t424 = f.my_piecewise3(t64, 0, t413 + t422)
  t432 = t297 ** 2
  t453 = f.my_piecewise3(t4, 0, -0.17981426600000000000000000000000000000000000000000e1 * t83 * t75 * t389 * t80 + 0.89907133000000000000000000000000000000000000000000e0 * t83 * t77 * t424 * t80 - 0.17981426600000000000000000000000000000000000000000e1 * t241 * t354 * t297 - 0.50000000000000000000000000000000000000000000000000e0 * t83 * t248 * t432 + 0.25000000000000000000000000000000000000000000000000e0 * t83 * t132 * (0.6244143983908838720e3 * t254 * t389 - 0.1248828796781767744e3 * t134 * t424 + 0.1788448787065589376e3 * t134 * t389 - 0.447112196766397344e2 * t72 * t424 + 0.10671103830312e2 * t72 * t389 - 0.3557034610104e1 * t75 * t424))
  v2sigma2_0_ = r0 * t453
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 0.1e1 <= f.p.zeta_threshold
  t4 = t1 or r0 / 0.2e1 <= f.p.dens_threshold
  t5 = f.p.zeta_threshold - 0.1e1
  t6 = -t5
  t7 = f.my_piecewise5(t1, t5, t1, t6, 0)
  t8 = t7 ** 2
  t9 = 0.1e1 - t8
  t10 = 0.1e1 + t7
  t13 = t10 * r0 / 0.2e1 <= f.p.dens_threshold
  t14 = 3 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t18 = 0.1e1 / t17
  t19 = t15 * t18
  t20 = 4 ** (0.1e1 / 0.3e1)
  t21 = t19 * t20
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = t10 <= f.p.zeta_threshold
  t24 = 0.1e1 - t7
  t25 = t24 <= f.p.zeta_threshold
  t26 = f.my_piecewise5(t23, t5, t25, t6, t7)
  t27 = 0.1e1 + t26
  t28 = t27 * r0
  t29 = t28 ** (0.1e1 / 0.3e1)
  t30 = 0.1e1 / t29
  t32 = jnp.sqrt(s0)
  t34 = r0 ** (0.1e1 / 0.3e1)
  t37 = t32 * t22 / t34 / r0
  t38 = jnp.sqrt(t37)
  t39 = t38 * t37
  t43 = 0.1e1 + 0.2e1 / 0.1233e4 * t19 * t20 * t39
  t44 = 0.1e1 / t43
  t48 = f.my_piecewise3(t13, 0, t21 * t22 * t30 * t44 / 0.9e1)
  t52 = t24 * r0 / 0.2e1 <= f.p.dens_threshold
  t53 = f.my_piecewise5(t25, t5, t23, t6, -t7)
  t54 = 0.1e1 + t53
  t55 = t54 * r0
  t56 = t55 ** (0.1e1 / 0.3e1)
  t57 = 0.1e1 / t56
  t62 = f.my_piecewise3(t52, 0, t21 * t22 * t57 * t44 / 0.9e1)
  t63 = t48 + t62
  t64 = t63 == 0.0e0
  t65 = f.my_piecewise3(t64, DBL_EPSILON, t63)
  t66 = t65 ** 2
  t67 = 0.1e1 / t66
  t68 = t9 * t67
  t70 = 0.1e1 / t29 / t28
  t76 = t17 ** 2
  t78 = t14 / t76
  t79 = t20 ** 2
  t80 = t22 ** 2
  t81 = t79 * t80
  t82 = t78 * t81
  t83 = t43 ** 2
  t84 = 0.1e1 / t83
  t85 = t30 * t84
  t86 = t38 * t32
  t87 = r0 ** 2
  t90 = t86 / t34 / t87
  t95 = f.my_piecewise3(t13, 0, -t21 * t22 * t70 * t44 * t27 / 0.27e2 + 0.4e1 / 0.3699e4 * t82 * t85 * t90)
  t97 = 0.1e1 / t56 / t55
  t103 = t57 * t84
  t108 = f.my_piecewise3(t52, 0, -t21 * t22 * t97 * t44 * t54 / 0.27e2 + 0.4e1 / 0.3699e4 * t82 * t103 * t90)
  t110 = f.my_piecewise3(t64, 0, t95 + t108)
  t111 = t66 ** 2
  t112 = 0.1e1 / t111
  t114 = t66 * t65
  t115 = 0.1e1 / t114
  t118 = 0.312207199195441936e2 * t112 + 0.149037398922132448e2 * t115 + 0.1778517305052e1 * t67
  t119 = 0.1e1 / t118
  t120 = t110 * t119
  t125 = 0.359628532e1 / t65 + 0.5764e0
  t126 = t9 * t125
  t127 = t118 ** 2
  t128 = 0.1e1 / t127
  t130 = 0.1e1 / t111 / t65
  t131 = t130 * t110
  t133 = t112 * t110
  t137 = -0.1248828796781767744e3 * t131 - 0.447112196766397344e2 * t133 - 0.3557034610104e1 * t115 * t110
  t141 = t9 * r0
  t142 = t110 ** 2
  t147 = t27 ** 2
  t150 = 0.1e1 / t29 / t147 / t87
  t157 = t78 * t81 * t70
  t158 = t84 * t27
  t162 = jnp.pi * t30
  t164 = 0.1e1 / t83 / t43
  t165 = t162 * t164
  t166 = t32 * s0
  t167 = t166 * t22
  t168 = t87 ** 2
  t170 = 0.1e1 / t168 / t87
  t171 = t167 * t170
  t175 = t78 * t79 * t30
  t176 = 0.1e1 / t38
  t177 = t84 * t176
  t178 = t34 ** 2
  t180 = 0.1e1 / t178 / t168
  t182 = t177 * s0 * t180
  t185 = t87 * r0
  t188 = t86 / t34 / t185
  t193 = f.my_piecewise3(t13, 0, 0.4e1 / 0.81e2 * t21 * t22 * t150 * t44 * t147 - 0.8e1 / 0.11097e5 * t157 * t158 * t90 + 0.256e3 / 0.1520289e7 * t165 * t171 - 0.16e2 / 0.11097e5 * t175 * t182 - 0.28e2 / 0.11097e5 * t82 * t85 * t188)
  t194 = t54 ** 2
  t197 = 0.1e1 / t56 / t194 / t87
  t204 = t78 * t81 * t97
  t205 = t84 * t54
  t209 = jnp.pi * t57
  t210 = t209 * t164
  t214 = t78 * t79 * t57
  t221 = f.my_piecewise3(t52, 0, 0.4e1 / 0.81e2 * t21 * t22 * t197 * t44 * t194 - 0.8e1 / 0.11097e5 * t204 * t205 * t90 + 0.256e3 / 0.1520289e7 * t210 * t171 - 0.16e2 / 0.11097e5 * t214 * t182 - 0.28e2 / 0.11097e5 * t82 * t103 * t188)
  t223 = f.my_piecewise3(t64, 0, t193 + t221)
  t228 = t141 * t67
  t229 = t110 * t128
  t230 = t229 * t137
  t234 = 0.1e1 / t127 / t118
  t236 = t137 ** 2
  t240 = t125 * t128
  t242 = 0.1e1 / t111 / t66
  t255 = 0.6244143983908838720e3 * t242 * t142 - 0.1248828796781767744e3 * t130 * t223 + 0.1788448787065589376e3 * t130 * t142 - 0.447112196766397344e2 * t112 * t223 + 0.10671103830312e2 * t112 * t142 - 0.3557034610104e1 * t115 * t223
  t260 = f.my_piecewise3(t4, 0, 0.17981426600000000000000000000000000000000000000000e1 * t68 * t120 + 0.50000000000000000000000000000000000000000000000000e0 * t126 * t128 * t137 - 0.17981426600000000000000000000000000000000000000000e1 * t141 * t115 * t142 * t119 + 0.89907133000000000000000000000000000000000000000000e0 * t141 * t67 * t223 * t119 - 0.17981426600000000000000000000000000000000000000000e1 * t228 * t230 - 0.50000000000000000000000000000000000000000000000000e0 * t141 * t125 * t234 * t236 + 0.25000000000000000000000000000000000000000000000000e0 * t141 * t240 * t255)
  t277 = t147 * t27
  t295 = t22 * t170
  t302 = t176 * s0 * t180
  t309 = t83 ** 2
  t311 = s0 ** 2
  t313 = 0.1e1 / t309 * t311 * t80
  t315 = t168 ** 2
  t321 = 0.1e1 / t34 / t315 * t15 * t18 * t20 * t38
  t326 = t167 / t168 / t185
  t331 = t84 / t39 * t326
  t338 = t177 * s0 / t178 / t168 / r0
  t343 = t86 / t34 / t168
  t348 = f.my_piecewise3(t13, 0, -0.28e2 / 0.243e3 * t21 * t22 / t29 / t185 * t44 + 0.16e2 / 0.11097e5 * t78 * t81 * t150 * t84 * t147 * t90 - 0.256e3 / 0.1520289e7 * jnp.pi * t70 * t164 * t27 * t166 * t295 + 0.16e2 / 0.11097e5 * t78 * t79 * t70 * t158 * t302 + 0.28e2 / 0.11097e5 * t157 * t158 * t188 + 0.1024e4 / 0.624838779e9 * t162 * t313 * t321 - 0.256e3 / 0.168921e6 * t165 * t326 - 0.32e2 / 0.33291e5 * t175 * t331 + 0.112e3 / 0.11097e5 * t175 * t338 + 0.280e3 / 0.33291e5 * t82 * t85 * t343)
  t349 = t194 * t54
  t391 = f.my_piecewise3(t52, 0, -0.28e2 / 0.243e3 * t21 * t22 / t56 / t185 * t44 + 0.16e2 / 0.11097e5 * t78 * t81 * t197 * t84 * t194 * t90 - 0.256e3 / 0.1520289e7 * jnp.pi * t97 * t164 * t54 * t166 * t295 + 0.16e2 / 0.11097e5 * t78 * t79 * t97 * t205 * t302 + 0.28e2 / 0.11097e5 * t204 * t205 * t188 + 0.1024e4 / 0.624838779e9 * t209 * t313 * t321 - 0.256e3 / 0.168921e6 * t210 * t326 - 0.32e2 / 0.33291e5 * t214 * t331 + 0.112e3 / 0.11097e5 * t214 * t338 + 0.280e3 / 0.33291e5 * t82 * t103 * t343)
  t393 = f.my_piecewise3(t64, 0, t348 + t391)
  t400 = t142 * t110
  t428 = t141 * t115
  t443 = t127 ** 2
  t459 = 0.75000000000000000000000000000000000000000000000000e0 * t126 * t128 * t255 + 0.26972139900000000000000000000000000000000000000000e1 * t68 * t223 * t119 - 0.53944279800000000000000000000000000000000000000000e1 * t9 * t115 * t142 * t119 - 0.53944279800000000000000000000000000000000000000000e1 * t68 * t230 - 0.15000000000000000000000000000000000000000000000000e1 * t126 * t234 * t236 + 0.89907133000000000000000000000000000000000000000000e0 * t141 * t67 * t393 * t119 + 0.25000000000000000000000000000000000000000000000000e0 * t141 * t240 * (-0.37464863903453032320e4 / t111 / t114 * t400 + 0.18732431951726516160e4 * t242 * t110 * t223 - 0.1248828796781767744e3 * t130 * t393 - 0.8942243935327946880e3 * t242 * t400 + 0.5365346361196768128e3 * t131 * t223 - 0.447112196766397344e2 * t112 * t393 - 0.42684415321248e2 * t130 * t400 + 0.32013311490936e2 * t133 * t223 - 0.3557034610104e1 * t115 * t393) + 0.53944279800000000000000000000000000000000000000000e1 * t141 * t112 * t400 * t119 - 0.53944279800000000000000000000000000000000000000000e1 * t428 * t120 * t223 + 0.53944279800000000000000000000000000000000000000000e1 * t428 * t142 * t128 * t137 - 0.26972139900000000000000000000000000000000000000000e1 * t228 * t223 * t128 * t137 - 0.26972139900000000000000000000000000000000000000000e1 * t228 * t229 * t255 + 0.15000000000000000000000000000000000000000000000000e1 * t141 * t125 / t443 * t236 * t137 - 0.15000000000000000000000000000000000000000000000000e1 * t141 * t125 * t234 * t137 * t255 + 0.53944279800000000000000000000000000000000000000000e1 * t228 * t110 * t234 * t236
  t460 = f.my_piecewise3(t4, 0, t459)
  v3rho3_0_ = r0 * t460 + 0.3e1 * t260

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 0.1e1 <= f.p.zeta_threshold
  t4 = t1 or r0 / 0.2e1 <= f.p.dens_threshold
  t5 = f.p.zeta_threshold - 0.1e1
  t6 = -t5
  t7 = f.my_piecewise5(t1, t5, t1, t6, 0)
  t8 = t7 ** 2
  t9 = 0.1e1 - t8
  t10 = 0.1e1 + t7
  t13 = t10 * r0 / 0.2e1 <= f.p.dens_threshold
  t14 = 3 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t18 = 0.1e1 / t17
  t19 = t15 * t18
  t20 = 4 ** (0.1e1 / 0.3e1)
  t21 = t19 * t20
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = t10 <= f.p.zeta_threshold
  t24 = 0.1e1 - t7
  t25 = t24 <= f.p.zeta_threshold
  t26 = f.my_piecewise5(t23, t5, t25, t6, t7)
  t27 = 0.1e1 + t26
  t28 = t27 * r0
  t29 = t28 ** (0.1e1 / 0.3e1)
  t30 = 0.1e1 / t29
  t32 = jnp.sqrt(s0)
  t34 = r0 ** (0.1e1 / 0.3e1)
  t37 = t32 * t22 / t34 / r0
  t38 = jnp.sqrt(t37)
  t39 = t38 * t37
  t43 = 0.1e1 + 0.2e1 / 0.1233e4 * t19 * t20 * t39
  t44 = 0.1e1 / t43
  t48 = f.my_piecewise3(t13, 0, t21 * t22 * t30 * t44 / 0.9e1)
  t52 = t24 * r0 / 0.2e1 <= f.p.dens_threshold
  t53 = f.my_piecewise5(t25, t5, t23, t6, -t7)
  t54 = 0.1e1 + t53
  t55 = t54 * r0
  t56 = t55 ** (0.1e1 / 0.3e1)
  t57 = 0.1e1 / t56
  t62 = f.my_piecewise3(t52, 0, t21 * t22 * t57 * t44 / 0.9e1)
  t63 = t48 + t62
  t64 = t63 == 0.0e0
  t65 = f.my_piecewise3(t64, DBL_EPSILON, t63)
  t68 = 0.359628532e1 / t65 + 0.5764e0
  t69 = t9 * t68
  t70 = t65 ** 2
  t71 = t70 ** 2
  t72 = 0.1e1 / t71
  t74 = t70 * t65
  t75 = 0.1e1 / t74
  t77 = 0.1e1 / t70
  t79 = 0.312207199195441936e2 * t72 + 0.149037398922132448e2 * t75 + 0.1778517305052e1 * t77
  t80 = t79 ** 2
  t81 = 0.1e1 / t80
  t83 = 0.1e1 / t71 / t70
  t85 = 0.1e1 / t29 / t28
  t91 = t17 ** 2
  t92 = 0.1e1 / t91
  t93 = t14 * t92
  t94 = t20 ** 2
  t95 = t22 ** 2
  t96 = t94 * t95
  t97 = t93 * t96
  t98 = t43 ** 2
  t99 = 0.1e1 / t98
  t100 = t30 * t99
  t101 = t38 * t32
  t102 = r0 ** 2
  t105 = t101 / t34 / t102
  t110 = f.my_piecewise3(t13, 0, -t21 * t22 * t85 * t44 * t27 / 0.27e2 + 0.4e1 / 0.3699e4 * t97 * t100 * t105)
  t112 = 0.1e1 / t56 / t55
  t118 = t57 * t99
  t123 = f.my_piecewise3(t52, 0, -t21 * t22 * t112 * t44 * t54 / 0.27e2 + 0.4e1 / 0.3699e4 * t97 * t118 * t105)
  t125 = f.my_piecewise3(t64, 0, t110 + t123)
  t126 = t125 ** 2
  t127 = t83 * t126
  t130 = 0.1e1 / t71 / t65
  t131 = t27 ** 2
  t134 = 0.1e1 / t29 / t131 / t102
  t141 = t93 * t96 * t85
  t142 = t99 * t27
  t146 = jnp.pi * t30
  t148 = 0.1e1 / t98 / t43
  t149 = t146 * t148
  t150 = t32 * s0
  t151 = t150 * t22
  t152 = t102 ** 2
  t153 = t152 * t102
  t154 = 0.1e1 / t153
  t155 = t151 * t154
  t159 = t93 * t94 * t30
  t160 = 0.1e1 / t38
  t161 = t99 * t160
  t162 = t34 ** 2
  t164 = 0.1e1 / t162 / t152
  t166 = t161 * s0 * t164
  t169 = t102 * r0
  t172 = t101 / t34 / t169
  t177 = f.my_piecewise3(t13, 0, 0.4e1 / 0.81e2 * t21 * t22 * t134 * t44 * t131 - 0.8e1 / 0.11097e5 * t141 * t142 * t105 + 0.256e3 / 0.1520289e7 * t149 * t155 - 0.16e2 / 0.11097e5 * t159 * t166 - 0.28e2 / 0.11097e5 * t97 * t100 * t172)
  t178 = t54 ** 2
  t181 = 0.1e1 / t56 / t178 / t102
  t188 = t93 * t96 * t112
  t189 = t99 * t54
  t193 = jnp.pi * t57
  t194 = t193 * t148
  t198 = t93 * t94 * t57
  t205 = f.my_piecewise3(t52, 0, 0.4e1 / 0.81e2 * t21 * t22 * t181 * t44 * t178 - 0.8e1 / 0.11097e5 * t188 * t189 * t105 + 0.256e3 / 0.1520289e7 * t194 * t155 - 0.16e2 / 0.11097e5 * t198 * t166 - 0.28e2 / 0.11097e5 * t97 * t118 * t172)
  t207 = f.my_piecewise3(t64, 0, t177 + t205)
  t210 = t130 * t126
  t218 = 0.6244143983908838720e3 * t127 - 0.1248828796781767744e3 * t130 * t207 + 0.1788448787065589376e3 * t210 - 0.447112196766397344e2 * t72 * t207 + 0.10671103830312e2 * t72 * t126 - 0.3557034610104e1 * t75 * t207
  t222 = t9 * t77
  t223 = 0.1e1 / t79
  t227 = t9 * t75
  t228 = t126 * t223
  t231 = t125 * t81
  t232 = t130 * t125
  t234 = t72 * t125
  t238 = -0.1248828796781767744e3 * t232 - 0.447112196766397344e2 * t234 - 0.3557034610104e1 * t75 * t125
  t243 = 0.1e1 / t80 / t79
  t244 = t238 ** 2
  t248 = t9 * r0
  t249 = t131 * t27
  t252 = 0.1e1 / t29 / t249 / t169
  t259 = t93 * t96 * t134
  t260 = t99 * t131
  t264 = jnp.pi * t85
  t265 = t264 * t148
  t266 = t27 * t150
  t267 = t22 * t154
  t271 = t94 * t85
  t272 = t93 * t271
  t273 = t160 * s0
  t274 = t273 * t164
  t281 = t98 ** 2
  t282 = 0.1e1 / t281
  t283 = s0 ** 2
  t285 = t282 * t283 * t95
  t286 = t146 * t285
  t287 = t152 ** 2
  t289 = 0.1e1 / t34 / t287
  t291 = t18 * t20
  t292 = t291 * t38
  t293 = t289 * t15 * t292
  t297 = 0.1e1 / t152 / t169
  t298 = t151 * t297
  t301 = 0.1e1 / t39
  t302 = t99 * t301
  t303 = t302 * t298
  t306 = t152 * r0
  t308 = 0.1e1 / t162 / t306
  t310 = t161 * s0 * t308
  t315 = t101 / t34 / t152
  t320 = f.my_piecewise3(t13, 0, -0.28e2 / 0.243e3 * t21 * t22 * t252 * t44 * t249 + 0.16e2 / 0.11097e5 * t259 * t260 * t105 - 0.256e3 / 0.1520289e7 * t265 * t266 * t267 + 0.16e2 / 0.11097e5 * t272 * t142 * t274 + 0.28e2 / 0.11097e5 * t141 * t142 * t172 + 0.1024e4 / 0.624838779e9 * t286 * t293 - 0.256e3 / 0.168921e6 * t149 * t298 - 0.32e2 / 0.33291e5 * t159 * t303 + 0.112e3 / 0.11097e5 * t159 * t310 + 0.280e3 / 0.33291e5 * t97 * t100 * t315)
  t321 = t178 * t54
  t324 = 0.1e1 / t56 / t321 / t169
  t331 = t93 * t96 * t181
  t332 = t99 * t178
  t336 = jnp.pi * t112
  t337 = t336 * t148
  t338 = t54 * t150
  t342 = t94 * t112
  t343 = t93 * t342
  t350 = t193 * t285
  t363 = f.my_piecewise3(t52, 0, -0.28e2 / 0.243e3 * t21 * t22 * t324 * t44 * t321 + 0.16e2 / 0.11097e5 * t331 * t332 * t105 - 0.256e3 / 0.1520289e7 * t337 * t338 * t267 + 0.16e2 / 0.11097e5 * t343 * t189 * t274 + 0.28e2 / 0.11097e5 * t188 * t189 * t172 + 0.1024e4 / 0.624838779e9 * t350 * t293 - 0.256e3 / 0.168921e6 * t194 * t298 - 0.32e2 / 0.33291e5 * t198 * t303 + 0.112e3 / 0.11097e5 * t198 * t310 + 0.280e3 / 0.33291e5 * t97 * t118 * t315)
  t365 = f.my_piecewise3(t64, 0, t320 + t363)
  t370 = t68 * t81
  t372 = 0.1e1 / t71 / t74
  t373 = t126 * t125
  t376 = t83 * t125
  t393 = -0.37464863903453032320e4 * t372 * t373 + 0.18732431951726516160e4 * t376 * t207 - 0.1248828796781767744e3 * t130 * t365 - 0.8942243935327946880e3 * t83 * t373 + 0.5365346361196768128e3 * t232 * t207 - 0.447112196766397344e2 * t72 * t365 - 0.42684415321248e2 * t130 * t373 + 0.32013311490936e2 * t234 * t207 - 0.3557034610104e1 * t75 * t365
  t401 = t248 * t75
  t403 = t125 * t223 * t207
  t406 = t126 * t81
  t407 = t406 * t238
  t410 = t248 * t77
  t411 = t207 * t81
  t412 = t411 * t238
  t415 = t231 * t218
  t418 = t80 ** 2
  t419 = 0.1e1 / t418
  t421 = t244 * t238
  t425 = t248 * t68
  t427 = t243 * t238 * t218
  t430 = t125 * t243
  t431 = t430 * t244
  t434 = 0.75000000000000000000000000000000000000000000000000e0 * t69 * t81 * t218 + 0.26972139900000000000000000000000000000000000000000e1 * t222 * t207 * t223 - 0.53944279800000000000000000000000000000000000000000e1 * t227 * t228 - 0.53944279800000000000000000000000000000000000000000e1 * t222 * t231 * t238 - 0.15000000000000000000000000000000000000000000000000e1 * t69 * t243 * t244 + 0.89907133000000000000000000000000000000000000000000e0 * t248 * t77 * t365 * t223 + 0.25000000000000000000000000000000000000000000000000e0 * t248 * t370 * t393 + 0.53944279800000000000000000000000000000000000000000e1 * t248 * t72 * t373 * t223 - 0.53944279800000000000000000000000000000000000000000e1 * t401 * t403 + 0.53944279800000000000000000000000000000000000000000e1 * t401 * t407 - 0.26972139900000000000000000000000000000000000000000e1 * t410 * t412 - 0.26972139900000000000000000000000000000000000000000e1 * t410 * t415 + 0.15000000000000000000000000000000000000000000000000e1 * t248 * t68 * t419 * t421 - 0.15000000000000000000000000000000000000000000000000e1 * t425 * t427 + 0.53944279800000000000000000000000000000000000000000e1 * t410 * t431
  t435 = f.my_piecewise3(t4, 0, t434)
  t441 = t365 * t223
  t452 = t71 ** 2
  t454 = t126 ** 2
  t460 = t207 ** 2
  t474 = 0.1e1 / t281 / t43 * t283 * s0
  t481 = 0.1e1 / t287 / t152 * t14 * t92 * t94 * t22
  t485 = t282 * t32 * t283
  t492 = 0.1e1 / t162 / t287 / t102 * t15 * t291 * t160
  t504 = 0.1e1 / t34 / t287 / r0
  t507 = t99 / t38 / s0 * t162 * t102 * t283 * t504
  t513 = t161 * s0 / t162 / t153
  t523 = t150 / t287 * t22
  t524 = t302 * t523
  t529 = t101 / t34 / t306
  t539 = t273 * t308
  t557 = t95 * t289 * t15 * t292
  t564 = t504 * t15 * t292
  t567 = t131 ** 2
  t576 = t22 * t297
  t582 = 0.2048e4 / 0.4560867e7 * jnp.pi * t134 * t148 * t131 * t150 * t267 + 0.32768e5 / 0.256808738169e12 * t146 * t474 * t481 - 0.4096e4 / 0.1874516337e10 * t146 * t485 * t492 - 0.64e2 / 0.33291e5 * t159 * t507 - 0.6832e4 / 0.99873e5 * t159 * t513 - 0.128e3 / 0.33291e5 * t93 * t94 * t134 * t260 * t274 + 0.448e3 / 0.33291e5 * t159 * t524 - 0.3640e4 / 0.99873e5 * t97 * t100 * t529 - 0.448e3 / 0.99873e5 * t93 * t96 * t252 * t99 * t249 * t105 - 0.448e3 / 0.33291e5 * t272 * t142 * t539 + 0.128e3 / 0.99873e5 * t93 * t271 * t99 * t27 * t301 * t298 - 0.224e3 / 0.33291e5 * t259 * t260 * t172 - 0.4096e4 / 0.1874516337e10 * t264 * t282 * t27 * t283 * t557 - 0.1120e4 / 0.99873e5 * t141 * t142 * t315 - 0.53248e5 / 0.1874516337e10 * t286 * t564 + 0.280e3 / 0.729e3 * t21 * t22 / t29 / t152 * t44 + 0.1024e4 / 0.506763e6 * t265 * t266 * t576 + 0.6400e4 / 0.506763e6 * t149 * t523
  t583 = f.my_piecewise3(t13, 0, t582)
  t632 = t178 ** 2
  t652 = 0.32768e5 / 0.256808738169e12 * t193 * t474 * t481 - 0.4096e4 / 0.1874516337e10 * t193 * t485 * t492 - 0.64e2 / 0.33291e5 * t198 * t507 - 0.6832e4 / 0.99873e5 * t198 * t513 - 0.128e3 / 0.33291e5 * t93 * t94 * t181 * t332 * t274 - 0.3640e4 / 0.99873e5 * t97 * t118 * t529 - 0.448e3 / 0.99873e5 * t93 * t96 * t324 * t99 * t321 * t105 - 0.448e3 / 0.33291e5 * t343 * t189 * t539 + 0.128e3 / 0.99873e5 * t93 * t342 * t99 * t54 * t301 * t298 + 0.448e3 / 0.33291e5 * t198 * t524 - 0.224e3 / 0.33291e5 * t331 * t332 * t172 - 0.4096e4 / 0.1874516337e10 * t336 * t282 * t54 * t283 * t557 - 0.1120e4 / 0.99873e5 * t188 * t189 * t315 - 0.53248e5 / 0.1874516337e10 * t350 * t564 + 0.280e3 / 0.729e3 * t21 * t22 / t56 / t152 * t44 + 0.1024e4 / 0.506763e6 * t337 * t338 * t576 + 0.2048e4 / 0.4560867e7 * jnp.pi * t181 * t148 * t178 * t150 * t267 + 0.6400e4 / 0.506763e6 * t194 * t523
  t653 = f.my_piecewise3(t52, 0, t652)
  t655 = f.my_piecewise3(t64, 0, t583 + t653)
  t678 = 0.262254047324171226240e5 / t452 * t454 - 0.224789183420718193920e5 * t372 * t126 * t207 + 0.18732431951726516160e4 * t83 * t460 + 0.24976575935635354880e4 * t376 * t365 - 0.1248828796781767744e3 * t130 * t655 + 0.53653463611967681280e4 * t372 * t454 - 0.53653463611967681280e4 * t127 * t207 + 0.5365346361196768128e3 * t130 * t460 + 0.7153795148262357504e3 * t232 * t365 - 0.447112196766397344e2 * t72 * t655 + 0.213422076606240e3 * t83 * t454 - 0.256106491927488e3 * t210 * t207 + 0.32013311490936e2 * t72 * t460 + 0.42684415321248e2 * t234 * t365 - 0.3557034610104e1 * t75 * t655
  t685 = t244 ** 2
  t690 = t218 ** 2
  t716 = 0.21577711920000000000000000000000000000000000000000e2 * t9 * t72 * t373 * t223 + 0.35962853200000000000000000000000000000000000000000e1 * t222 * t441 + 0.21577711920000000000000000000000000000000000000000e2 * t410 * t430 * t218 * t238 + 0.21577711920000000000000000000000000000000000000000e2 * t401 * t231 * t207 * t238 + 0.25000000000000000000000000000000000000000000000000e0 * t248 * t370 * t678 - 0.60000000000000000000000000000000000000000000000000e1 * t248 * t68 / t418 / t79 * t685 - 0.15000000000000000000000000000000000000000000000000e1 * t248 * t68 * t243 * t690 - 0.21577711920000000000000000000000000000000000000000e2 * t248 * t130 * t454 * t223 - 0.53944279800000000000000000000000000000000000000000e1 * t248 * t75 * t460 * t223 - 0.60000000000000000000000000000000000000000000000000e1 * t69 * t427 - 0.10788855960000000000000000000000000000000000000000e2 * t222 * t415 - 0.21577711920000000000000000000000000000000000000000e2 * t227 * t403 - 0.10788855960000000000000000000000000000000000000000e2 * t222 * t412 + 0.21577711920000000000000000000000000000000000000000e2 * t227 * t407 + 0.89907133000000000000000000000000000000000000000000e0 * t248 * t77 * t655 * t223
  t750 = t248 * t72
  t769 = -0.53944279800000000000000000000000000000000000000000e1 * t410 * t411 * t218 - 0.21577711920000000000000000000000000000000000000000e2 * t401 * t126 * t243 * t244 + 0.90000000000000000000000000000000000000000000000000e1 * t425 * t419 * t244 * t218 - 0.71925706400000000000000000000000000000000000000000e1 * t401 * t441 * t125 - 0.35962853200000000000000000000000000000000000000000e1 * t410 * t231 * t393 - 0.35962853200000000000000000000000000000000000000000e1 * t410 * t365 * t81 * t238 - 0.20000000000000000000000000000000000000000000000000e1 * t425 * t243 * t393 * t238 - 0.21577711920000000000000000000000000000000000000000e2 * t410 * t125 * t419 * t421 + 0.10788855960000000000000000000000000000000000000000e2 * t410 * t207 * t243 * t244 - 0.21577711920000000000000000000000000000000000000000e2 * t750 * t373 * t81 * t238 + 0.32366567880000000000000000000000000000000000000000e2 * t750 * t228 * t207 + 0.10788855960000000000000000000000000000000000000000e2 * t401 * t406 * t218 + 0.10000000000000000000000000000000000000000000000000e1 * t69 * t81 * t393 + 0.60000000000000000000000000000000000000000000000000e1 * t69 * t419 * t421 + 0.21577711920000000000000000000000000000000000000000e2 * t222 * t431
  t771 = f.my_piecewise3(t4, 0, t716 + t769)
  v4rho4_0_ = r0 * t771 + 0.4e1 * t435

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = abs(t4)
  t11 = 0.1e1 - t5 <= f.p.zeta_threshold or r0 <= f.p.dens_threshold and r1 <= f.p.dens_threshold
  t13 = 0.1e1 + t4 <= f.p.zeta_threshold
  t14 = f.p.zeta_threshold - 0.1e1
  t16 = 0.1e1 - t4 <= f.p.zeta_threshold
  t17 = -t14
  t18 = f.my_piecewise5(t13, t14, t16, t17, t4)
  t19 = t2 ** 2
  t20 = 0.1e1 / t19
  t21 = t1 * t20
  t22 = t3 - t21
  t23 = f.my_piecewise5(t13, 0, t16, 0, t22)
  t24 = t18 * t23
  t27 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t30 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t31 = f.my_piecewise5(t27, t14, t30, t17, t4)
  t32 = 0.1e1 + t31
  t35 = t32 * t2 / 0.2e1 <= f.p.dens_threshold
  t36 = 3 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t39 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t41 = t37 / t39
  t42 = 4 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 2 ** (0.1e1 / 0.3e1)
  t45 = t32 <= f.p.zeta_threshold
  t46 = 0.1e1 - t31
  t47 = t46 <= f.p.zeta_threshold
  t48 = f.my_piecewise5(t45, t14, t47, t17, t31)
  t49 = 0.1e1 + t48
  t50 = t49 * t2
  t51 = t50 ** (0.1e1 / 0.3e1)
  t52 = 0.1e1 / t51
  t54 = jnp.sqrt(s0)
  t55 = r0 ** (0.1e1 / 0.3e1)
  t58 = t54 / t55 / r0
  t59 = jnp.sqrt(t58)
  t64 = 0.1e1 + 0.2e1 / 0.1233e4 * t41 * t42 * t59 * t58
  t65 = 0.1e1 / t64
  t69 = f.my_piecewise3(t35, 0, t43 * t44 * t52 * t65 / 0.9e1)
  t73 = t46 * t2 / 0.2e1 <= f.p.dens_threshold
  t74 = f.my_piecewise5(t47, t14, t45, t17, -t31)
  t75 = 0.1e1 + t74
  t76 = t75 * t2
  t77 = t76 ** (0.1e1 / 0.3e1)
  t78 = 0.1e1 / t77
  t80 = jnp.sqrt(s2)
  t81 = r1 ** (0.1e1 / 0.3e1)
  t84 = t80 / t81 / r1
  t85 = jnp.sqrt(t84)
  t90 = 0.1e1 + 0.2e1 / 0.1233e4 * t41 * t42 * t85 * t84
  t91 = 0.1e1 / t90
  t95 = f.my_piecewise3(t73, 0, t43 * t44 * t78 * t91 / 0.9e1)
  t96 = t69 + t95
  t97 = t96 == 0.0e0
  t98 = f.my_piecewise3(t97, DBL_EPSILON, t96)
  t101 = 0.359628532e1 / t98 + 0.5764e0
  t103 = t98 ** 2
  t104 = t103 ** 2
  t105 = 0.1e1 / t104
  t108 = 0.1e1 / t103 / t98
  t110 = 0.1e1 / t103
  t112 = 0.312207199195441936e2 * t105 + 0.149037398922132448e2 * t108 + 0.1778517305052e1 * t110
  t113 = 0.1e1 / t112
  t114 = t2 * t101 * t113
  t117 = t18 ** 2
  t118 = 0.1e1 - t117
  t119 = t118 * t101
  t121 = 0.25000000000000000000000000000000000000000000000000e0 * t119 * t113
  t122 = t118 * t2
  t124 = 0.1e1 / t51 / t50
  t125 = t44 * t124
  t126 = f.my_piecewise5(t27, 0, t30, 0, t22)
  t127 = f.my_piecewise5(t45, 0, t47, 0, t126)
  t129 = t127 * t2 + t48 + 0.1e1
  t134 = t39 ** 2
  t136 = t36 / t134
  t137 = t42 ** 2
  t138 = t137 * t44
  t139 = t136 * t138
  t140 = t64 ** 2
  t141 = 0.1e1 / t140
  t142 = t52 * t141
  t143 = t59 * t54
  t144 = r0 ** 2
  t147 = t143 / t55 / t144
  t152 = f.my_piecewise3(t35, 0, -t43 * t125 * t65 * t129 / 0.27e2 + 0.4e1 / 0.3699e4 * t139 * t142 * t147)
  t154 = 0.1e1 / t77 / t76
  t155 = t44 * t154
  t156 = f.my_piecewise5(t47, 0, t45, 0, -t126)
  t158 = t156 * t2 + t74 + 0.1e1
  t163 = f.my_piecewise3(t73, 0, -t43 * t155 * t91 * t158 / 0.27e2)
  t165 = f.my_piecewise3(t97, 0, t152 + t163)
  t167 = t110 * t165 * t113
  t170 = t112 ** 2
  t171 = 0.1e1 / t170
  t172 = t101 * t171
  t174 = 0.1e1 / t104 / t98
  t181 = -0.1248828796781767744e3 * t174 * t165 - 0.447112196766397344e2 * t105 * t165 - 0.3557034610104e1 * t108 * t165
  t182 = t172 * t181
  t186 = f.my_piecewise3(t11, 0, 0.50000000000000000000000000000000000000000000000000e0 * t24 * t114 - t121 + 0.89907133000000000000000000000000000000000000000000e0 * t122 * t167 + 0.25000000000000000000000000000000000000000000000000e0 * t122 * t182)
  t188 = t23 ** 2
  t190 = t101 * t113
  t195 = t1 / t19 / t2
  t197 = -0.2e1 * t20 + 0.2e1 * t195
  t198 = f.my_piecewise5(t13, 0, t16, 0, t197)
  t202 = t24 * t190
  t204 = t24 * t2
  t209 = t118 * t110
  t211 = t209 * t165 * t113
  t214 = t119 * t171 * t181
  t216 = t165 ** 2
  t221 = t49 ** 2
  t224 = 0.1e1 / t51 / t221 / t19
  t225 = t44 * t224
  t226 = t129 ** 2
  t232 = t136 * t138 * t124
  t237 = f.my_piecewise5(t27, 0, t30, 0, t197)
  t238 = f.my_piecewise5(t45, 0, t47, 0, t237)
  t246 = jnp.pi * t44
  t252 = t144 ** 2
  t260 = t55 ** 2
  t275 = f.my_piecewise3(t35, 0, 0.4e1 / 0.81e2 * t43 * t225 * t65 * t226 - 0.8e1 / 0.11097e5 * t232 * t141 * t129 * t147 - t43 * t125 * t65 * (t238 * t2 + 0.2e1 * t127) / 0.27e2 + 0.128e3 / 0.1520289e7 * t246 * t52 / t140 / t64 * t54 * s0 / t252 / t144 - 0.8e1 / 0.11097e5 * t139 * t142 / t59 * s0 / t260 / t252 - 0.28e2 / 0.11097e5 * t139 * t142 * t143 / t55 / t144 / r0)
  t276 = t75 ** 2
  t279 = 0.1e1 / t77 / t276 / t19
  t280 = t44 * t279
  t281 = t158 ** 2
  t286 = f.my_piecewise5(t47, 0, t45, 0, -t237)
  t295 = f.my_piecewise3(t73, 0, 0.4e1 / 0.81e2 * t43 * t280 * t91 * t281 - t43 * t155 * t91 * (t286 * t2 + 0.2e1 * t156) / 0.27e2)
  t297 = f.my_piecewise3(t97, 0, t275 + t295)
  t302 = t122 * t110
  t303 = t165 * t171
  t308 = 0.1e1 / t170 / t112
  t309 = t101 * t308
  t310 = t181 ** 2
  t315 = 0.1e1 / t104 / t103
  t332 = 0.50000000000000000000000000000000000000000000000000e0 * t188 * t2 * t190 + 0.50000000000000000000000000000000000000000000000000e0 * t18 * t198 * t114 + 0.10000000000000000000000000000000000000000000000000e1 * t202 - 0.35962853200000000000000000000000000000000000000000e1 * t204 * t167 - 0.10000000000000000000000000000000000000000000000000e1 * t204 * t182 + 0.17981426600000000000000000000000000000000000000000e1 * t211 + 0.50000000000000000000000000000000000000000000000000e0 * t214 - 0.17981426600000000000000000000000000000000000000000e1 * t122 * t108 * t216 * t113 + 0.89907133000000000000000000000000000000000000000000e0 * t122 * t110 * t297 * t113 - 0.17981426600000000000000000000000000000000000000000e1 * t302 * t303 * t181 - 0.50000000000000000000000000000000000000000000000000e0 * t122 * t309 * t310 + 0.25000000000000000000000000000000000000000000000000e0 * t122 * t172 * (0.6244143983908838720e3 * t315 * t216 - 0.1248828796781767744e3 * t174 * t297 + 0.1788448787065589376e3 * t174 * t216 - 0.447112196766397344e2 * t105 * t297 + 0.10671103830312e2 * t105 * t216 - 0.3557034610104e1 * t108 * t297)
  t333 = f.my_piecewise3(t11, 0, t332)
  d11 = t2 * t333 + 0.2e1 * t186
  t335 = -t3 - t21
  t336 = f.my_piecewise5(t13, 0, t16, 0, t335)
  t337 = t18 * t336
  t340 = f.my_piecewise5(t27, 0, t30, 0, t335)
  t341 = f.my_piecewise5(t45, 0, t47, 0, t340)
  t343 = t341 * t2 + t48 + 0.1e1
  t348 = f.my_piecewise3(t35, 0, -t43 * t125 * t65 * t343 / 0.27e2)
  t349 = f.my_piecewise5(t47, 0, t45, 0, -t340)
  t351 = t349 * t2 + t74 + 0.1e1
  t356 = t90 ** 2
  t357 = 0.1e1 / t356
  t358 = t78 * t357
  t359 = t85 * t80
  t360 = r1 ** 2
  t362 = 0.1e1 / t81 / t360
  t363 = t359 * t362
  t368 = f.my_piecewise3(t73, 0, -t43 * t155 * t91 * t351 / 0.27e2 + 0.4e1 / 0.3699e4 * t139 * t358 * t363)
  t370 = f.my_piecewise3(t97, 0, t348 + t368)
  t372 = t110 * t370 * t113
  t375 = t174 * t370
  t377 = t105 * t370
  t381 = -0.1248828796781767744e3 * t375 - 0.447112196766397344e2 * t377 - 0.3557034610104e1 * t108 * t370
  t382 = t172 * t381
  t386 = f.my_piecewise3(t11, 0, 0.50000000000000000000000000000000000000000000000000e0 * t337 * t114 - t121 + 0.89907133000000000000000000000000000000000000000000e0 * t122 * t372 + 0.25000000000000000000000000000000000000000000000000e0 * t122 * t382)
  t390 = 0.2e1 * t195
  t391 = f.my_piecewise5(t13, 0, t16, 0, t390)
  t395 = t337 * t190
  t397 = t337 * t2
  t407 = t370 * t113
  t408 = t209 * t407
  t415 = t41 * t42 * t44
  t425 = f.my_piecewise5(t27, 0, t30, 0, t390)
  t426 = f.my_piecewise5(t45, 0, t47, 0, t425)
  t434 = f.my_piecewise3(t35, 0, 0.4e1 / 0.81e2 * t415 * t224 * t65 * t343 * t129 - 0.4e1 / 0.11097e5 * t232 * t141 * t343 * t147 - t43 * t125 * t65 * (t426 * t2 + t127 + t341) / 0.27e2)
  t440 = f.my_piecewise5(t47, 0, t45, 0, -t425)
  t448 = t136 * t138 * t154
  t456 = f.my_piecewise3(t73, 0, 0.4e1 / 0.81e2 * t415 * t279 * t91 * t351 * t158 - t43 * t155 * t91 * (t440 * t2 + t156 + t349) / 0.27e2 - 0.4e1 / 0.11097e5 * t448 * t357 * t85 * t80 * t362 * t158)
  t458 = f.my_piecewise3(t97, 0, t434 + t456)
  t463 = t370 * t171
  t470 = t119 * t171 * t381
  t497 = 0.50000000000000000000000000000000000000000000000000e0 * t23 * t336 * t114 + 0.50000000000000000000000000000000000000000000000000e0 * t18 * t391 * t114 + 0.50000000000000000000000000000000000000000000000000e0 * t395 - 0.17981426600000000000000000000000000000000000000000e1 * t397 * t167 - 0.50000000000000000000000000000000000000000000000000e0 * t397 * t182 + 0.50000000000000000000000000000000000000000000000000e0 * t202 + 0.89907133000000000000000000000000000000000000000000e0 * t211 + 0.25000000000000000000000000000000000000000000000000e0 * t214 - 0.17981426600000000000000000000000000000000000000000e1 * t204 * t372 + 0.89907133000000000000000000000000000000000000000000e0 * t408 - 0.17981426600000000000000000000000000000000000000000e1 * t122 * t108 * t407 * t165 + 0.89907133000000000000000000000000000000000000000000e0 * t122 * t110 * t458 * t113 - 0.89907133000000000000000000000000000000000000000000e0 * t302 * t463 * t181 - 0.50000000000000000000000000000000000000000000000000e0 * t204 * t382 + 0.25000000000000000000000000000000000000000000000000e0 * t470 - 0.89907133000000000000000000000000000000000000000000e0 * t302 * t303 * t381 - 0.50000000000000000000000000000000000000000000000000e0 * t122 * t101 * t308 * t381 * t181 + 0.25000000000000000000000000000000000000000000000000e0 * t122 * t172 * (0.6244143983908838720e3 * t315 * t370 * t165 - 0.1248828796781767744e3 * t174 * t458 + 0.1788448787065589376e3 * t375 * t165 - 0.447112196766397344e2 * t105 * t458 + 0.10671103830312e2 * t377 * t165 - 0.3557034610104e1 * t108 * t458)
  t498 = f.my_piecewise3(t11, 0, t497)
  d12 = t2 * t498 + t186 + t386
  t501 = t336 ** 2
  t506 = 0.2e1 * t20 + 0.2e1 * t195
  t507 = f.my_piecewise5(t13, 0, t16, 0, t506)
  t518 = t370 ** 2
  t523 = t343 ** 2
  t528 = f.my_piecewise5(t27, 0, t30, 0, t506)
  t529 = f.my_piecewise5(t45, 0, t47, 0, t528)
  t538 = f.my_piecewise3(t35, 0, 0.4e1 / 0.81e2 * t43 * t225 * t65 * t523 - t43 * t125 * t65 * (t529 * t2 + 0.2e1 * t341) / 0.27e2)
  t539 = t351 ** 2
  t548 = f.my_piecewise5(t47, 0, t45, 0, -t528)
  t561 = t360 ** 2
  t569 = t81 ** 2
  t584 = f.my_piecewise3(t73, 0, 0.4e1 / 0.81e2 * t43 * t280 * t91 * t539 - 0.8e1 / 0.11097e5 * t448 * t357 * t351 * t363 - t43 * t155 * t91 * (t548 * t2 + 0.2e1 * t349) / 0.27e2 + 0.128e3 / 0.1520289e7 * t246 * t78 / t356 / t90 * t80 * s2 / t561 / t360 - 0.8e1 / 0.11097e5 * t139 * t358 / t85 * s2 / t569 / t561 - 0.28e2 / 0.11097e5 * t139 * t358 * t359 / t81 / t360 / r1)
  t586 = f.my_piecewise3(t97, 0, t538 + t584)
  t594 = t381 ** 2
  t614 = 0.50000000000000000000000000000000000000000000000000e0 * t501 * t2 * t190 + 0.50000000000000000000000000000000000000000000000000e0 * t18 * t507 * t114 + 0.10000000000000000000000000000000000000000000000000e1 * t395 - 0.35962853200000000000000000000000000000000000000000e1 * t397 * t372 - 0.10000000000000000000000000000000000000000000000000e1 * t397 * t382 + 0.17981426600000000000000000000000000000000000000000e1 * t408 + 0.50000000000000000000000000000000000000000000000000e0 * t470 - 0.17981426600000000000000000000000000000000000000000e1 * t122 * t108 * t518 * t113 + 0.89907133000000000000000000000000000000000000000000e0 * t122 * t110 * t586 * t113 - 0.17981426600000000000000000000000000000000000000000e1 * t302 * t463 * t381 - 0.50000000000000000000000000000000000000000000000000e0 * t122 * t309 * t594 + 0.25000000000000000000000000000000000000000000000000e0 * t122 * t172 * (0.6244143983908838720e3 * t315 * t518 - 0.1248828796781767744e3 * t174 * t586 + 0.1788448787065589376e3 * t174 * t518 - 0.447112196766397344e2 * t105 * t586 + 0.10671103830312e2 * t105 * t518 - 0.3557034610104e1 * t108 * t586)
  t615 = f.my_piecewise3(t11, 0, t614)
  d22 = t2 * t615 + 0.2e1 * t386
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = abs(t4)
  t11 = 0.1e1 - t5 <= f.p.zeta_threshold or r0 <= f.p.dens_threshold and r1 <= f.p.dens_threshold
  t13 = 0.1e1 + t4 <= f.p.zeta_threshold
  t15 = 0.1e1 - t4 <= f.p.zeta_threshold
  t16 = t2 ** 2
  t17 = 0.1e1 / t16
  t19 = -t1 * t17 + t3
  t20 = f.my_piecewise5(t13, 0, t15, 0, t19)
  t21 = t20 ** 2
  t22 = t21 * t2
  t25 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t26 = f.p.zeta_threshold - 0.1e1
  t29 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t30 = -t26
  t31 = f.my_piecewise5(t25, t26, t29, t30, t4)
  t32 = 0.1e1 + t31
  t35 = t32 * t2 / 0.2e1 <= f.p.dens_threshold
  t36 = 3 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t39 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t40 = 0.1e1 / t39
  t41 = t37 * t40
  t42 = 4 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 2 ** (0.1e1 / 0.3e1)
  t45 = t32 <= f.p.zeta_threshold
  t46 = 0.1e1 - t31
  t47 = t46 <= f.p.zeta_threshold
  t48 = f.my_piecewise5(t45, t26, t47, t30, t31)
  t49 = 0.1e1 + t48
  t50 = t49 * t2
  t51 = t50 ** (0.1e1 / 0.3e1)
  t52 = 0.1e1 / t51
  t54 = jnp.sqrt(s0)
  t55 = r0 ** (0.1e1 / 0.3e1)
  t58 = t54 / t55 / r0
  t59 = jnp.sqrt(t58)
  t60 = t59 * t58
  t64 = 0.1e1 + 0.2e1 / 0.1233e4 * t41 * t42 * t60
  t65 = 0.1e1 / t64
  t69 = f.my_piecewise3(t35, 0, t43 * t44 * t52 * t65 / 0.9e1)
  t73 = t46 * t2 / 0.2e1 <= f.p.dens_threshold
  t74 = f.my_piecewise5(t47, t26, t45, t30, -t31)
  t75 = 0.1e1 + t74
  t76 = t75 * t2
  t77 = t76 ** (0.1e1 / 0.3e1)
  t80 = jnp.sqrt(s2)
  t81 = r1 ** (0.1e1 / 0.3e1)
  t84 = t80 / t81 / r1
  t85 = jnp.sqrt(t84)
  t91 = 0.1e1 / (0.1e1 + 0.2e1 / 0.1233e4 * t41 * t42 * t85 * t84)
  t95 = f.my_piecewise3(t73, 0, t43 * t44 / t77 * t91 / 0.9e1)
  t96 = t69 + t95
  t97 = t96 == 0.0e0
  t98 = f.my_piecewise3(t97, DBL_EPSILON, t96)
  t101 = 0.359628532e1 / t98 + 0.5764e0
  t102 = t98 ** 2
  t103 = t102 ** 2
  t104 = 0.1e1 / t103
  t106 = t102 * t98
  t107 = 0.1e1 / t106
  t109 = 0.1e1 / t102
  t111 = 0.312207199195441936e2 * t104 + 0.149037398922132448e2 * t107 + 0.1778517305052e1 * t109
  t112 = 0.1e1 / t111
  t113 = t101 * t112
  t116 = f.my_piecewise5(t13, t26, t15, t30, t4)
  t117 = t16 * t2
  t118 = 0.1e1 / t117
  t121 = 0.2e1 * t1 * t118 - 0.2e1 * t17
  t122 = f.my_piecewise5(t13, 0, t15, 0, t121)
  t123 = t116 * t122
  t125 = t2 * t101 * t112
  t128 = t116 * t20
  t131 = t128 * t2
  t133 = 0.1e1 / t51 / t50
  t134 = t44 * t133
  t135 = f.my_piecewise5(t25, 0, t29, 0, t19)
  t136 = f.my_piecewise5(t45, 0, t47, 0, t135)
  t138 = t136 * t2 + t48 + 0.1e1
  t143 = t39 ** 2
  t145 = t36 / t143
  t146 = t42 ** 2
  t147 = t146 * t44
  t148 = t145 * t147
  t149 = t64 ** 2
  t150 = 0.1e1 / t149
  t151 = t52 * t150
  t152 = t59 * t54
  t153 = r0 ** 2
  t156 = t152 / t55 / t153
  t161 = f.my_piecewise3(t35, 0, -t43 * t134 * t65 * t138 / 0.27e2 + 0.4e1 / 0.3699e4 * t148 * t151 * t156)
  t164 = t44 / t77 / t76
  t165 = f.my_piecewise5(t47, 0, t45, 0, -t135)
  t167 = t165 * t2 + t74 + 0.1e1
  t172 = f.my_piecewise3(t73, 0, -t43 * t164 * t91 * t167 / 0.27e2)
  t174 = f.my_piecewise3(t97, 0, t161 + t172)
  t175 = t109 * t174
  t176 = t175 * t112
  t179 = t111 ** 2
  t180 = 0.1e1 / t179
  t181 = t101 * t180
  t183 = 0.1e1 / t103 / t98
  t184 = t183 * t174
  t186 = t104 * t174
  t190 = -0.1248828796781767744e3 * t184 - 0.447112196766397344e2 * t186 - 0.3557034610104e1 * t107 * t174
  t191 = t181 * t190
  t194 = t116 ** 2
  t195 = 0.1e1 - t194
  t196 = t195 * t109
  t197 = t174 * t112
  t200 = t195 * t101
  t201 = t180 * t190
  t204 = t195 * t2
  t205 = t174 ** 2
  t207 = t107 * t205 * t112
  t210 = t49 ** 2
  t213 = 0.1e1 / t51 / t210 / t16
  t215 = t138 ** 2
  t221 = t145 * t147 * t133
  t222 = t150 * t138
  t226 = f.my_piecewise5(t25, 0, t29, 0, t121)
  t227 = f.my_piecewise5(t45, 0, t47, 0, t226)
  t230 = t227 * t2 + 0.2e1 * t136
  t235 = jnp.pi * t44
  t236 = t235 * t52
  t238 = 0.1e1 / t149 / t64
  t239 = t54 * s0
  t240 = t238 * t239
  t241 = t153 ** 2
  t243 = 0.1e1 / t241 / t153
  t248 = 0.1e1 / t59 * s0
  t249 = t55 ** 2
  t252 = t248 / t249 / t241
  t256 = t153 * r0
  t259 = t152 / t55 / t256
  t264 = f.my_piecewise3(t35, 0, 0.4e1 / 0.81e2 * t43 * t44 * t213 * t65 * t215 - 0.8e1 / 0.11097e5 * t221 * t222 * t156 - t43 * t134 * t65 * t230 / 0.27e2 + 0.128e3 / 0.1520289e7 * t236 * t240 * t243 - 0.8e1 / 0.11097e5 * t148 * t151 * t252 - 0.28e2 / 0.11097e5 * t148 * t151 * t259)
  t265 = t75 ** 2
  t268 = 0.1e1 / t77 / t265 / t16
  t270 = t167 ** 2
  t275 = f.my_piecewise5(t47, 0, t45, 0, -t226)
  t278 = t275 * t2 + 0.2e1 * t165
  t284 = f.my_piecewise3(t73, 0, 0.4e1 / 0.81e2 * t43 * t44 * t268 * t91 * t270 - t43 * t164 * t91 * t278 / 0.27e2)
  t286 = f.my_piecewise3(t97, 0, t264 + t284)
  t288 = t109 * t286 * t112
  t291 = t204 * t109
  t292 = t174 * t180
  t293 = t292 * t190
  t297 = 0.1e1 / t179 / t111
  t299 = t190 ** 2
  t300 = t101 * t297 * t299
  t304 = 0.1e1 / t103 / t102
  t317 = 0.6244143983908838720e3 * t304 * t205 - 0.1248828796781767744e3 * t183 * t286 + 0.1788448787065589376e3 * t183 * t205 - 0.447112196766397344e2 * t104 * t286 + 0.10671103830312e2 * t104 * t205 - 0.3557034610104e1 * t107 * t286
  t318 = t181 * t317
  t321 = 0.50000000000000000000000000000000000000000000000000e0 * t22 * t113 + 0.50000000000000000000000000000000000000000000000000e0 * t123 * t125 + 0.10000000000000000000000000000000000000000000000000e1 * t128 * t113 - 0.35962853200000000000000000000000000000000000000000e1 * t131 * t176 - 0.10000000000000000000000000000000000000000000000000e1 * t131 * t191 + 0.17981426600000000000000000000000000000000000000000e1 * t196 * t197 + 0.50000000000000000000000000000000000000000000000000e0 * t200 * t201 - 0.17981426600000000000000000000000000000000000000000e1 * t204 * t207 + 0.89907133000000000000000000000000000000000000000000e0 * t204 * t288 - 0.17981426600000000000000000000000000000000000000000e1 * t291 * t293 - 0.50000000000000000000000000000000000000000000000000e0 * t204 * t300 + 0.25000000000000000000000000000000000000000000000000e0 * t204 * t318
  t322 = f.my_piecewise3(t11, 0, t321)
  t324 = t205 * t174
  t337 = t16 ** 2
  t341 = 0.6e1 * t118 - 0.6e1 * t1 / t337
  t342 = f.my_piecewise5(t13, 0, t15, 0, t341)
  t369 = t41 * t42 * t44
  t391 = f.my_piecewise5(t25, 0, t29, 0, t341)
  t392 = f.my_piecewise5(t45, 0, t47, 0, t391)
  t400 = t149 ** 2
  t403 = s0 ** 2
  t406 = t241 ** 2
  t416 = 0.1e1 / t241 / t256
  t439 = -0.28e2 / 0.243e3 * t43 * t44 / t51 / t210 / t49 / t117 * t65 * t215 * t138 + 0.16e2 / 0.11097e5 * t145 * t147 * t213 * t150 * t215 * t156 + 0.4e1 / 0.27e2 * t369 * t213 * t65 * t138 * t230 - 0.128e3 / 0.1520289e7 * t235 * t133 * t238 * t138 * t239 * t243 - 0.4e1 / 0.3699e4 * t221 * t150 * t230 * t156 + 0.8e1 / 0.11097e5 * t221 * t222 * t252 + 0.28e2 / 0.11097e5 * t221 * t222 * t259 - t43 * t134 * t65 * (t392 * t2 + 0.3e1 * t227) / 0.27e2 + 0.512e3 / 0.624838779e9 * t235 * t52 / t400 * t403 / t55 / t406 * t37 * t40 * t42 * t59 - 0.128e3 / 0.168921e6 * t236 * t240 * t416 - 0.16e2 / 0.33291e5 * t148 * t151 / t60 * t239 * t416 + 0.56e2 / 0.11097e5 * t148 * t151 * t248 / t249 / t241 / r0 + 0.280e3 / 0.33291e5 * t148 * t151 * t152 / t55 / t241
  t440 = f.my_piecewise3(t35, 0, t439)
  t456 = f.my_piecewise5(t47, 0, t45, 0, -t391)
  t465 = f.my_piecewise3(t73, 0, -0.28e2 / 0.243e3 * t43 * t44 / t77 / t265 / t75 / t117 * t91 * t270 * t167 + 0.4e1 / 0.27e2 * t369 * t268 * t91 * t167 * t278 - t43 * t164 * t91 * (t456 * t2 + 0.3e1 * t275) / 0.27e2)
  t467 = f.my_piecewise3(t97, 0, t440 + t465)
  t497 = t179 ** 2
  t504 = t123 * t2
  t516 = 0.53944279800000000000000000000000000000000000000000e1 * t204 * t104 * t324 * t112 + 0.15000000000000000000000000000000000000000000000000e1 * t20 * t2 * t113 * t122 - 0.15000000000000000000000000000000000000000000000000e1 * t22 * t191 - 0.53944279800000000000000000000000000000000000000000e1 * t22 * t176 + 0.50000000000000000000000000000000000000000000000000e0 * t116 * t342 * t125 - 0.30000000000000000000000000000000000000000000000000e1 * t128 * t191 - 0.10788855960000000000000000000000000000000000000000e2 * t128 * t176 - 0.53944279800000000000000000000000000000000000000000e1 * t196 * t293 + 0.89907133000000000000000000000000000000000000000000e0 * t204 * t109 * t467 * t112 + 0.25000000000000000000000000000000000000000000000000e0 * t204 * t181 * (-0.37464863903453032320e4 / t103 / t106 * t324 + 0.18732431951726516160e4 * t304 * t174 * t286 - 0.1248828796781767744e3 * t183 * t467 - 0.8942243935327946880e3 * t304 * t324 + 0.5365346361196768128e3 * t184 * t286 - 0.447112196766397344e2 * t104 * t467 - 0.42684415321248e2 * t183 * t324 + 0.32013311490936e2 * t186 * t286 - 0.3557034610104e1 * t107 * t467) + 0.15000000000000000000000000000000000000000000000000e1 * t204 * t101 / t497 * t299 * t190 - 0.15000000000000000000000000000000000000000000000000e1 * t504 * t191 - 0.53944279800000000000000000000000000000000000000000e1 * t131 * t288 - 0.26972139900000000000000000000000000000000000000000e1 * t291 * t286 * t180 * t190 - 0.26972139900000000000000000000000000000000000000000e1 * t291 * t292 * t317
  t517 = t204 * t107
  t563 = -0.53944279800000000000000000000000000000000000000000e1 * t517 * t197 * t286 - 0.15000000000000000000000000000000000000000000000000e1 * t131 * t318 - 0.15000000000000000000000000000000000000000000000000e1 * t204 * t101 * t297 * t190 * t317 + 0.30000000000000000000000000000000000000000000000000e1 * t131 * t300 + 0.53944279800000000000000000000000000000000000000000e1 * t291 * t174 * t297 * t299 + 0.10788855960000000000000000000000000000000000000000e2 * t131 * t207 + 0.53944279800000000000000000000000000000000000000000e1 * t517 * t205 * t180 * t190 - 0.53944279800000000000000000000000000000000000000000e1 * t504 * t176 + 0.15000000000000000000000000000000000000000000000000e1 * t21 * t101 * t112 + 0.10788855960000000000000000000000000000000000000000e2 * t131 * t175 * t201 + 0.26972139900000000000000000000000000000000000000000e1 * t196 * t286 * t112 + 0.15000000000000000000000000000000000000000000000000e1 * t123 * t113 - 0.15000000000000000000000000000000000000000000000000e1 * t200 * t297 * t299 - 0.53944279800000000000000000000000000000000000000000e1 * t195 * t107 * t205 * t112 + 0.75000000000000000000000000000000000000000000000000e0 * t200 * t180 * t317
  t565 = f.my_piecewise3(t11, 0, t516 + t563)
  d111 = t2 * t565 + 0.3e1 * t322

  res = {'v3rho3': d111}
  return res
