"""Generated from gga_c_scan_e0.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  beta_a = 0.06672455060314922

  beta_b = 0.1

  beta_c = 0.1778

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  mbeta = lambda rs, t=None: beta_a * (1 + beta_b * rs) / (1 + beta_c * rs)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  scan_e0_g = lambda rs, z, t: (1 + 4 * A(rs, z, t) * t ** 2) ** (-1 / 4)

  f2 = lambda rs, z, t: mbeta(rs, t) * (1 - scan_e0_g(rs, z, t)) / (mgamma * A(rs, z, t))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  functional_body = lambda rs, z, xt, xs0, xs1: f_pbe(rs, z, xt, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  beta_a = 0.06672455060314922

  beta_b = 0.1

  beta_c = 0.1778

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  mbeta = lambda rs, t=None: beta_a * (1 + beta_b * rs) / (1 + beta_c * rs)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  scan_e0_g = lambda rs, z, t: (1 + 4 * A(rs, z, t) * t ** 2) ** (-1 / 4)

  f2 = lambda rs, z, t: mbeta(rs, t) * (1 - scan_e0_g(rs, z, t)) / (mgamma * A(rs, z, t))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  functional_body = lambda rs, z, xt, xs0, xs1: f_pbe(rs, z, xt, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  beta_a = 0.06672455060314922

  beta_b = 0.1

  beta_c = 0.1778

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  mbeta = lambda rs, t=None: beta_a * (1 + beta_b * rs) / (1 + beta_c * rs)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  scan_e0_g = lambda rs, z, t: (1 + 4 * A(rs, z, t) * t ** 2) ** (-1 / 4)

  f2 = lambda rs, z, t: mbeta(rs, t) * (1 - scan_e0_g(rs, z, t)) / (mgamma * A(rs, z, t))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  functional_body = lambda rs, z, xt, xs0, xs1: f_pbe(rs, z, xt, xs0, xs1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t11 = t4 * t6 / t8
  t13 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t11
  t14 = jnp.sqrt(t11)
  t17 = t11 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t8 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.23615562999000000000000000000000000000000000000000e0 * t14 + 0.55770497660000000000000000000000000000000000000000e-1 * t11 + 0.12733196185000000000000000000000000000000000000000e-1 * t17 + 0.76629248290000000000000000000000000000000000000000e-2 * t25
  t29 = 0.1e1 + 0.1e1 / t27
  t30 = jnp.log(t29)
  t31 = t13 * t30
  t32 = r0 - r1
  t33 = t32 ** 2
  t34 = t33 ** 2
  t35 = t7 ** 2
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t38 = t34 * t37
  t39 = 0.1e1 / t7
  t40 = t32 * t39
  t41 = 0.1e1 + t40
  t42 = t41 <= f.p.zeta_threshold
  t43 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t44 = t43 * f.p.zeta_threshold
  t45 = t41 ** (0.1e1 / 0.3e1)
  t47 = f.my_piecewise3(t42, t44, t45 * t41)
  t48 = 0.1e1 - t40
  t49 = t48 <= f.p.zeta_threshold
  t50 = t48 ** (0.1e1 / 0.3e1)
  t52 = f.my_piecewise3(t49, t44, t50 * t48)
  t54 = 2 ** (0.1e1 / 0.3e1)
  t57 = 0.1e1 / (0.2e1 * t54 - 0.2e1)
  t58 = (t47 + t52 - 0.2e1) * t57
  t60 = 0.3109070e-1 + 0.15971292590000000000000000000000000000000000000000e-2 * t11
  t65 = 0.21948324211500000000000000000000000000000000000000e0 * t14 + 0.48172707847500000000000000000000000000000000000000e-1 * t11 + 0.13082189292500000000000000000000000000000000000000e-1 * t17 + 0.48592432297500000000000000000000000000000000000000e-2 * t25
  t67 = 0.1e1 + 0.1e1 / t65
  t68 = jnp.log(t67)
  t71 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t11
  t76 = 0.17489762330000000000000000000000000000000000000000e0 * t14 + 0.30591463695000000000000000000000000000000000000000e-1 * t11 + 0.37162156485000000000000000000000000000000000000000e-2 * t17 + 0.41939460495000000000000000000000000000000000000000e-2 * t25
  t78 = 0.1e1 + 0.1e1 / t76
  t79 = jnp.log(t78)
  t80 = t71 * t79
  t82 = -t60 * t68 + t31 - 0.58482236226346462072622386637590534819724553404281e0 * t80
  t83 = t58 * t82
  t84 = t38 * t83
  t86 = 0.58482236226346462072622386637590534819724553404281e0 * t58 * t80
  t87 = jnp.log(0.2e1)
  t88 = 0.1e1 - t87
  t89 = jnp.pi ** 2
  t91 = t88 / t89
  t92 = t43 ** 2
  t93 = t45 ** 2
  t94 = f.my_piecewise3(t42, t92, t93)
  t95 = t50 ** 2
  t96 = f.my_piecewise3(t49, t92, t95)
  t98 = t94 / 0.2e1 + t96 / 0.2e1
  t99 = t98 ** 2
  t100 = t99 * t98
  t102 = 0.66724550603149220e-1 + 0.16681137650787305000000000000000000000000000000000e-2 * t11
  t104 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t11
  t105 = 0.1e1 / t104
  t107 = 0.1e1 / t88
  t108 = t102 * t105 * t107
  t110 = (-t31 + t84 + t86) * t107
  t111 = 0.1e1 / t100
  t112 = t89 * t111
  t114 = jnp.exp(-t110 * t112)
  t115 = t114 - 0.1e1
  t116 = 0.1e1 / t115
  t119 = s0 + 0.2e1 * s1 + s2
  t121 = t108 * t89 * t116 * t119
  t123 = 0.1e1 / t8 / t35
  t124 = t123 * t54
  t125 = 0.1e1 / t99
  t127 = 0.1e1 / t3
  t128 = t19 * t127
  t129 = t128 * t5
  t133 = 0.1e1 + t121 * t124 * t125 * t129 / 0.24e2
  t134 = t133 ** (0.1e1 / 0.4e1)
  t136 = 0.1e1 - 0.1e1 / t134
  t138 = t136 * t115 + 0.1e1
  t139 = jnp.log(t138)
  t141 = t91 * t100 * t139
  t143 = 0.1e1 / t8 / t7
  t144 = t6 * t143
  t147 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t144 * t30
  t148 = t27 ** 2
  t153 = t3 * t6
  t154 = t153 * t143
  t155 = 0.1e1 / t14 * t1 * t154
  t157 = t4 * t144
  t159 = t11 ** 0.5e0
  t161 = t159 * t1 * t154
  t166 = t21 * t5 / t22 / t7
  t171 = t13 / t148 * (-0.39359271665000000000000000000000000000000000000000e-1 * t155 - 0.18590165886666666666666666666666666666666666666667e-1 * t157 - 0.63665980925000000000000000000000000000000000000000e-2 * t161 - 0.51086165526666666666666666666666666666666666666667e-2 * t166) / t29
  t175 = 0.4e1 * t33 * t32 * t37 * t83
  t180 = 0.4e1 * t34 / t36 / t7 * t83
  t182 = t32 / t35
  t183 = t39 - t182
  t186 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t183)
  t187 = -t183
  t190 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t187)
  t192 = (t186 + t190) * t57
  t194 = t38 * t192 * t82
  t198 = t65 ** 2
  t212 = t76 ** 2
  t213 = 0.1e1 / t212
  t219 = -0.29149603883333333333333333333333333333333333333333e-1 * t155 - 0.10197154565000000000000000000000000000000000000000e-1 * t157 - 0.18581078242500000000000000000000000000000000000000e-2 * t161 - 0.27959640330000000000000000000000000000000000000000e-2 * t166
  t220 = 0.1e1 / t78
  t226 = t38 * t58 * (0.53237641966666666666666666666666666666666666666667e-3 * t4 * t144 * t68 + t60 / t198 * (-0.36580540352500000000000000000000000000000000000000e-1 * t155 - 0.16057569282500000000000000000000000000000000000000e-1 * t157 - 0.65410946462500000000000000000000000000000000000000e-2 * t161 - 0.32394954865000000000000000000000000000000000000000e-2 * t166) / t67 - t147 - t171 + 0.18311447306006545054854346104378990962041954983034e-3 * t4 * t144 * t79 + 0.58482236226346462072622386637590534819724553404281e0 * t71 * t213 * t219 * t220)
  t228 = 0.58482236226346462072622386637590534819724553404281e0 * t192 * t80
  t233 = 0.18311447306006545054854346104378990962041954983034e-3 * t58 * t1 * t153 * t143 * t79
  t238 = 0.58482236226346462072622386637590534819724553404281e0 * t58 * t71 * t213 * t219 * t220
  t239 = t99 * t139
  t240 = 0.1e1 / t45
  t243 = f.my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t240 * t183)
  t244 = 0.1e1 / t50
  t247 = f.my_piecewise3(t49, 0, 0.2e1 / 0.3e1 * t244 * t187)
  t249 = t243 / 0.2e1 + t247 / 0.2e1
  t254 = 0.1e1 / t134 / t133
  t255 = t35 * t7
  t257 = 0.1e1 / t22 / t255
  t259 = t107 * t89
  t261 = t116 * t119
  t262 = t54 * t125
  t265 = 0.27801896084645508333333333333333333333333333333333e-3 * t257 * t105 * t259 * t261 * t262
  t266 = t104 ** 2
  t274 = 0.74083333333333333333333333333333333333333333333333e-2 * t102 / t266 * t259 * t261 * t257 * t54 * t125
  t275 = t115 ** 2
  t280 = t108 * t89 / t275 * t119 * t123
  t281 = t262 * t19
  t282 = t127 * t5
  t286 = t99 ** 2
  t288 = t89 / t286
  t292 = -(t147 + t171 + t175 - t180 + t194 + t226 + t228 - t233 - t238) * t107 * t112 + 0.3e1 * t110 * t288 * t249
  t304 = 0.7e1 / 0.72e2 * t121 / t8 / t255 * t54 * t125 * t129
  t305 = t124 * t111
  t319 = 0.1e1 / t138
  t322 = t147 + t171 + t175 - t180 + t194 + t226 + t228 - t233 - t238 + 0.3e1 * t91 * t239 * t249 + t91 * t100 * (t254 * (-t265 + t274 - t280 * t281 * t282 * t292 * t114 / 0.24e2 - t304 - t121 * t305 * t128 * t5 * t249 / 0.12e2) * t115 / 0.4e1 + t136 * t292 * t114) * t319
  vrho_0_ = t7 * t322 + t141 - t31 + t84 + t86
  t324 = -t39 - t182
  t327 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t324)
  t328 = -t324
  t331 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t328)
  t333 = (t327 + t331) * t57
  t335 = t38 * t333 * t82
  t337 = 0.58482236226346462072622386637590534819724553404281e0 * t333 * t80
  t340 = f.my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t240 * t324)
  t343 = f.my_piecewise3(t49, 0, 0.2e1 / 0.3e1 * t244 * t328)
  t345 = t340 / 0.2e1 + t343 / 0.2e1
  t355 = -(t147 + t171 - t175 - t180 + t335 + t226 + t337 - t233 - t238) * t107 * t112 + 0.3e1 * t110 * t288 * t345
  t376 = t147 + t171 - t175 - t180 + t335 + t226 + t337 - t233 - t238 + 0.3e1 * t91 * t239 * t345 + t91 * t100 * (t254 * (-t265 + t274 - t280 * t281 * t282 * t355 * t114 / 0.24e2 - t304 - t121 * t305 * t128 * t5 * t345 / 0.12e2) * t115 / 0.4e1 + t136 * t355 * t114) * t319
  vrho_1_ = t7 * t376 + t141 - t31 + t84 + t86
  t385 = t143 * t98 * t254 * t102 * t105 * t54 * t19 * t282 * t319
  vsigma_0_ = t385 / 0.96e2
  vsigma_1_ = t385 / 0.48e2
  vsigma_2_ = vsigma_0_
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  beta_a = 0.06672455060314922

  beta_b = 0.1

  beta_c = 0.1778

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  mbeta = lambda rs, t=None: beta_a * (1 + beta_b * rs) / (1 + beta_c * rs)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  scan_e0_g = lambda rs, z, t: (1 + 4 * A(rs, z, t) * t ** 2) ** (-1 / 4)

  f2 = lambda rs, z, t: mbeta(rs, t) * (1 - scan_e0_g(rs, z, t)) / (mgamma * A(rs, z, t))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  functional_body = lambda rs, z, xt, xs0, xs1: f_pbe(rs, z, xt, xs0, xs1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t10 = t4 * t6 / t7
  t12 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t24 = t20 * t5 / t21
  t26 = 0.23615562999000000000000000000000000000000000000000e0 * t13 + 0.55770497660000000000000000000000000000000000000000e-1 * t10 + 0.12733196185000000000000000000000000000000000000000e-1 * t16 + 0.76629248290000000000000000000000000000000000000000e-2 * t24
  t28 = 0.1e1 + 0.1e1 / t26
  t29 = jnp.log(t28)
  t30 = t12 * t29
  t31 = 0.1e1 <= f.p.zeta_threshold
  t32 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t34 = f.my_piecewise3(t31, t32 * f.p.zeta_threshold, 1)
  t37 = 2 ** (0.1e1 / 0.3e1)
  t41 = (0.2e1 * t34 - 0.2e1) / (0.2e1 * t37 - 0.2e1)
  t43 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t10
  t48 = 0.17489762330000000000000000000000000000000000000000e0 * t13 + 0.30591463695000000000000000000000000000000000000000e-1 * t10 + 0.37162156485000000000000000000000000000000000000000e-2 * t16 + 0.41939460495000000000000000000000000000000000000000e-2 * t24
  t50 = 0.1e1 + 0.1e1 / t48
  t51 = jnp.log(t50)
  t54 = 0.58482236226346462072622386637590534819724553404281e0 * t41 * t43 * t51
  t55 = jnp.log(0.2e1)
  t56 = 0.1e1 - t55
  t57 = jnp.pi ** 2
  t59 = t56 / t57
  t60 = t32 ** 2
  t61 = f.my_piecewise3(t31, t60, 1)
  t62 = t61 ** 2
  t63 = t62 * t61
  t65 = 0.66724550603149220e-1 + 0.16681137650787305000000000000000000000000000000000e-2 * t10
  t67 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t10
  t68 = 0.1e1 / t67
  t69 = t65 * t68
  t70 = 0.1e1 / t56
  t75 = t57 / t63
  t77 = jnp.exp(-(-t30 + t54) * t70 * t75)
  t78 = t77 - 0.1e1
  t79 = 0.1e1 / t78
  t82 = t69 * t70 * t57 * t79 * s0
  t83 = r0 ** 2
  t85 = 0.1e1 / t7 / t83
  t87 = 0.1e1 / t62
  t89 = 0.1e1 / t3
  t91 = t18 * t89 * t5
  t95 = 0.1e1 + t82 * t85 * t37 * t87 * t91 / 0.24e2
  t96 = t95 ** (0.1e1 / 0.4e1)
  t98 = 0.1e1 - 0.1e1 / t96
  t100 = t98 * t78 + 0.1e1
  t101 = jnp.log(t100)
  t105 = 0.1e1 / t7 / r0
  t106 = t6 * t105
  t109 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t106 * t29
  t110 = t26 ** 2
  t115 = t3 * t6
  t116 = t115 * t105
  t117 = 0.1e1 / t13 * t1 * t116
  t119 = t4 * t106
  t121 = t10 ** 0.5e0
  t123 = t121 * t1 * t116
  t128 = t20 * t5 / t21 / r0
  t133 = t12 / t110 * (-0.39359271665000000000000000000000000000000000000000e-1 * t117 - 0.18590165886666666666666666666666666666666666666667e-1 * t119 - 0.63665980925000000000000000000000000000000000000000e-2 * t123 - 0.51086165526666666666666666666666666666666666666667e-2 * t128) / t28
  t138 = 0.18311447306006545054854346104378990962041954983034e-3 * t41 * t1 * t115 * t105 * t51
  t140 = t48 ** 2
  t151 = 0.58482236226346462072622386637590534819724553404281e0 * t41 * t43 / t140 * (-0.29149603883333333333333333333333333333333333333333e-1 * t117 - 0.10197154565000000000000000000000000000000000000000e-1 * t119 - 0.18581078242500000000000000000000000000000000000000e-2 * t123 - 0.27959640330000000000000000000000000000000000000000e-2 * t128) / t50
  t153 = 0.1e1 / t96 / t95
  t154 = t83 * r0
  t156 = 0.1e1 / t21 / t154
  t158 = t70 * t57
  t160 = t79 * s0
  t165 = t67 ** 2
  t174 = t56 ** 2
  t177 = t57 ** 2
  t178 = t78 ** 2
  t184 = t62 ** 2
  t189 = t89 * t5
  t190 = t109 + t133 - t138 - t151
  t213 = 0.1e1 / t100
  vrho_0_ = -t30 + t54 + t59 * t63 * t101 + r0 * (t109 + t133 - t138 - t151 + t59 * t63 * (t153 * (-0.27801896084645508333333333333333333333333333333333e-3 * t156 * t68 * t158 * t160 * t37 * t87 + 0.74083333333333333333333333333333333333333333333333e-2 * t65 / t165 * t158 * t160 * t156 * t37 * t87 + t69 / t174 * t177 / t178 * s0 * t85 * t37 / t184 / t61 * t18 * t189 * t190 * t77 / 0.24e2 - 0.7e1 / 0.72e2 * t82 / t7 / t154 * t37 * t87 * t91) * t78 / 0.4e1 - t98 * t190 * t70 * t75 * t77) * t213)
  vsigma_0_ = t105 * t61 * t153 * t65 * t68 * t37 * t18 * t189 * t213 / 0.96e2
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t7 / r0
  t10 = t6 * t9
  t13 = t4 * t6 / t7
  t14 = jnp.sqrt(t13)
  t17 = t13 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t7 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.37978500000000000000000000000000000000000000000000e1 * t14 + 0.89690000000000000000000000000000000000000000000000e0 * t13 + 0.20477500000000000000000000000000000000000000000000e0 * t17 + 0.12323500000000000000000000000000000000000000000000e0 * t25
  t30 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t27
  t31 = jnp.log(t30)
  t33 = t4 * t10 * t31
  t36 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t13
  t37 = t27 ** 2
  t38 = 0.1e1 / t37
  t39 = t36 * t38
  t41 = 0.1e1 / t14 * t1
  t42 = t3 * t6
  t43 = t42 * t9
  t44 = t41 * t43
  t46 = t4 * t10
  t48 = t13 ** 0.5e0
  t49 = t48 * t1
  t50 = t49 * t43
  t55 = t21 * t5 / t22 / r0
  t57 = -0.63297500000000000000000000000000000000000000000000e0 * t44 - 0.29896666666666666666666666666666666666666666666667e0 * t46 - 0.10238750000000000000000000000000000000000000000000e0 * t50 - 0.82156666666666666666666666666666666666666666666667e-1 * t55
  t58 = 0.1e1 / t30
  t59 = t57 * t58
  t60 = t39 * t59
  t62 = 0.1e1 <= f.p.zeta_threshold
  t63 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t65 = f.my_piecewise3(t62, t63 * f.p.zeta_threshold, 1)
  t68 = 2 ** (0.1e1 / 0.3e1)
  t72 = (0.2e1 * t65 - 0.2e1) / (0.2e1 * t68 - 0.2e1)
  t73 = t72 * t1
  t78 = 0.51785000000000000000000000000000000000000000000000e1 * t14 + 0.90577500000000000000000000000000000000000000000000e0 * t13 + 0.11003250000000000000000000000000000000000000000000e0 * t17 + 0.12417750000000000000000000000000000000000000000000e0 * t25
  t81 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t78
  t82 = jnp.log(t81)
  t85 = t73 * t42 * t9 * t82
  t88 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t13
  t89 = t72 * t88
  t90 = t78 ** 2
  t91 = 0.1e1 / t90
  t96 = -0.86308333333333333333333333333333333333333333333334e0 * t44 - 0.30192500000000000000000000000000000000000000000000e0 * t46 - 0.55016250000000000000000000000000000000000000000000e-1 * t50 - 0.82785000000000000000000000000000000000000000000000e-1 * t55
  t98 = 0.1e1 / t81
  t99 = t91 * t96 * t98
  t100 = t89 * t99
  t102 = jnp.log(0.2e1)
  t103 = 0.1e1 - t102
  t104 = jnp.pi ** 2
  t106 = t103 / t104
  t107 = t63 ** 2
  t108 = f.my_piecewise3(t62, t107, 1)
  t109 = t108 ** 2
  t110 = t109 * t108
  t112 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e-1 * t13
  t114 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t13
  t115 = 0.1e1 / t114
  t116 = t112 * t115
  t117 = 0.1e1 / t103
  t126 = 0.1e1 / t110
  t127 = t104 * t126
  t129 = jnp.exp(-(-0.621814e-1 * t36 * t31 + 0.19751673498613801407483339618206552048944131217655e-1 * t72 * t88 * t82) * t117 * t127)
  t130 = t129 - 0.1e1
  t131 = 0.1e1 / t130
  t132 = t104 * t131
  t133 = t132 * s0
  t134 = t116 * t117 * t133
  t135 = r0 ** 2
  t137 = 0.1e1 / t7 / t135
  t139 = 0.1e1 / t109
  t141 = 0.1e1 / t3
  t143 = t19 * t141 * t5
  t147 = 0.1e1 + 0.27801896084645508333333333333333333333333333333333e-2 * t134 * t137 * t68 * t139 * t143
  t148 = t147 ** (0.1e1 / 0.4e1)
  t150 = 0.1e1 / t148 / t147
  t151 = t135 * r0
  t153 = 0.1e1 / t22 / t151
  t154 = t153 * t115
  t155 = t117 * t104
  t157 = t131 * s0
  t159 = t157 * t68 * t139
  t162 = t114 ** 2
  t163 = 0.1e1 / t162
  t164 = t112 * t163
  t165 = t164 * t155
  t171 = t103 ** 2
  t172 = 0.1e1 / t171
  t173 = t116 * t172
  t174 = t104 ** 2
  t175 = t130 ** 2
  t176 = 0.1e1 / t175
  t177 = t174 * t176
  t178 = s0 * t137
  t180 = t173 * t177 * t178
  t181 = t109 ** 2
  t183 = 0.1e1 / t181 / t108
  t185 = t68 * t183 * t19
  t186 = t141 * t5
  t191 = 0.11073470983333333333333333333333333333333333333333e-2 * t33 + 0.10000000000000000000000000000000000000000000000000e1 * t60 - 0.18311447306006545054854346104378990962041954983034e-3 * t85 - 0.58482236226346462072622386637590534819724553404280e0 * t100
  t194 = t185 * t186 * t191 * t129
  t198 = 0.1e1 / t7 / t151
  t204 = -0.27801896084645508333333333333333333333333333333333e-3 * t154 * t155 * t159 + 0.49431771238499713816666666666666666666666666666666e-3 * t165 * t157 * t153 * t68 * t139 + 0.27801896084645508333333333333333333333333333333333e-2 * t180 * t194 - 0.64871090864172852777777777777777777777777777777777e-2 * t134 * t198 * t68 * t139 * t143
  t205 = t150 * t204
  t209 = 0.1e1 - 0.1e1 / t148
  t212 = t127 * t129
  t215 = 0.25000000000000000000000000000000000000000000000000e0 * t205 * t130 - 0.10000000000000000000000000000000000000000000000000e1 * t209 * t191 * t117 * t212
  t219 = 0.1e1 + 0.10000000000000000000000000000000000000000000000000e1 * t209 * t130
  t220 = 0.1e1 / t219
  t224 = t6 * t137
  t227 = 0.14764627977777777777777777777777777777777777777777e-2 * t4 * t224 * t31
  t228 = t4 * t6
  t232 = 0.35616666666666666666666666666666666666666666666666e-1 * t228 * t9 * t38 * t59
  t236 = t57 ** 2
  t239 = 0.20000000000000000000000000000000000000000000000000e1 * t36 / t37 / t27 * t236 * t58
  t245 = 0.1e1 / t22 / t135
  t246 = t20 * t5 * t245
  t247 = 0.1e1 / t14 / t13 * t19 * t246
  t249 = t42 * t137
  t250 = t41 * t249
  t252 = t4 * t224
  t254 = t13 ** (-0.5e0)
  t256 = t254 * t19 * t246
  t258 = t49 * t249
  t261 = t21 * t5 * t245
  t266 = 0.10000000000000000000000000000000000000000000000000e1 * t39 * (-0.42198333333333333333333333333333333333333333333333e0 * t247 + 0.84396666666666666666666666666666666666666666666666e0 * t250 + 0.39862222222222222222222222222222222222222222222223e0 * t252 + 0.68258333333333333333333333333333333333333333333333e-1 * t256 + 0.13651666666666666666666666666666666666666666666667e0 * t258 + 0.13692777777777777777777777777777777777777777777778e0 * t261) * t58
  t267 = t37 ** 2
  t270 = t30 ** 2
  t274 = 0.16081979498692535066756296899072713062105388428051e2 * t36 / t267 * t236 / t270
  t278 = 0.24415263074675393406472461472505321282722606644045e-3 * t73 * t42 * t137 * t82
  t282 = 0.10843581300301739842632067522386578331157260943710e-1 * t72 * t4 * t10 * t99
  t285 = t96 ** 2
  t289 = 0.11696447245269292414524477327518106963944910680856e1 * t89 / t90 / t78 * t285 * t98
  t300 = 0.58482236226346462072622386637590534819724553404280e0 * t89 * t91 * (-0.57538888888888888888888888888888888888888888888889e0 * t247 + 0.11507777777777777777777777777777777777777777777778e1 * t250 + 0.40256666666666666666666666666666666666666666666667e0 * t252 + 0.36677500000000000000000000000000000000000000000000e-1 * t256 + 0.73355000000000000000000000000000000000000000000000e-1 * t258 + 0.13797500000000000000000000000000000000000000000000e0 * t261) * t98
  t301 = t90 ** 2
  t304 = t81 ** 2
  t308 = 0.17315859105681463759666483083807725165579399831905e2 * t89 / t301 * t285 / t304
  t309 = t147 ** 2
  t311 = 0.1e1 / t148 / t309
  t312 = t204 ** 2
  t316 = t135 ** 2
  t318 = 0.1e1 / t22 / t316
  t324 = 0.1e1 / t316 / r0
  t328 = s0 * t68
  t334 = t172 * t174 * t176
  t337 = t183 * t191 * t129
  t364 = t116 / t171 / t103
  t365 = t174 * t104
  t371 = t181 ** 2
  t374 = t68 / t371 * t19
  t375 = t191 ** 2
  t376 = t129 ** 2
  t387 = -t227 - t232 - t239 + t266 + t274 + t278 + t282 + t289 - t300 - t308
  t408 = 0.16681137650787305000000000000000000000000000000000e-2 * t318 * t115 * t155 * t159 - 0.82386285397499523027777777777777777777777777777777e-5 * t324 * t163 * t155 * t131 * t328 * t139 * t228 - 0.55603792169291016666666666666666666666666666666666e-3 * t154 * t334 * t328 * t337 + 0.14648281543675415194338888888888888888888888888889e-4 * t112 / t162 / t114 * t117 * t133 * t324 * t68 * t139 * t228 + 0.98863542476999427633333333333333333333333333333332e-3 * t164 * t334 * s0 * t153 * t68 * t337 - 0.29659062743099828290000000000000000000000000000000e-2 * t165 * t157 * t318 * t68 * t139 + 0.55603792169291016666666666666666666666666666666666e-2 * t364 * t365 / t175 / t130 * t178 * t374 * t186 * t375 * t376 - 0.12974218172834570555555555555555555555555555555555e-1 * t173 * t177 * s0 * t198 * t194 + 0.27801896084645508333333333333333333333333333333333e-2 * t180 * t185 * t186 * t387 * t129 - 0.27801896084645508333333333333333333333333333333333e-2 * t364 * t365 * t176 * t178 * t374 * t186 * t375 * t129 + 0.21623696954724284259259259259259259259259259259259e-1 * t134 / t7 / t316 * t68 * t139 * t143
  t433 = t215 ** 2
  t435 = t219 ** 2
  t436 = 0.1e1 / t435
  t439 = -t227 - t232 - t239 + t266 + t274 + t278 + t282 + t289 - t300 - t308 + t106 * t110 * (-0.31250000000000000000000000000000000000000000000000e0 * t311 * t312 * t130 + 0.25000000000000000000000000000000000000000000000000e0 * t150 * t408 * t130 - 0.50000000000000000000000000000000000000000000000000e0 * t205 * t191 * t155 * t126 * t129 - 0.10000000000000000000000000000000000000000000000000e1 * t209 * t387 * t117 * t212 + 0.10000000000000000000000000000000000000000000000000e1 * t209 * t375 * t172 * t174 / t181 / t109 * t129) * t220 - t106 * t110 * t433 * t436
  v2rho2_0_ = 0.22146941966666666666666666666666666666666666666666e-2 * t33 + 0.20000000000000000000000000000000000000000000000000e1 * t60 - 0.36622894612013090109708692208757981924083909966068e-3 * t85 - 0.11696447245269292414524477327518106963944910680856e1 * t100 + 0.2e1 * t106 * t110 * t215 * t220 + r0 * t439
  t443 = t150 * t112 * t115
  t445 = t68 * t19
  t450 = t9 * t108
  t454 = t445 * t141
  t461 = t245 * t108 * t150
  v2rhosigma_0_ = -0.92672986948818361111111111111111111111111111111109e-3 * t137 * t108 * t443 * t445 * t186 * t220 - 0.86880925264517213541666666666666666666666666666665e-3 * t450 * t311 * t112 * t115 * t454 * t5 * t220 * t204 - 0.69504740211613770833333333333333333333333333333332e-4 * t461 * t115 * t68 * t220 + 0.12357942809624928454166666666666666666666666666666e-3 * t461 * t164 * t68 * t220 - 0.69504740211613770833333333333333333333333333333332e-3 * t450 * t443 * t454 * t5 * t436 * t215
  t477 = t153 / t108
  t479 = t112 ** 2
  t481 = t68 ** 2
  t482 = t479 * t163 * t481
  t486 = t1 / t20 * t6
  t492 = jnp.sqrt(t147)
  v2sigma2_0_ = -0.72463633678258804337418320094537760416666666666665e-5 * t477 * t311 * t482 * t486 * t220 * t117 * t132 - 0.14492726735651760867483664018907552083333333333333e-5 * t477 / t492 / t309 * t482 * t486 * t436 * t117 * t104
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t10 = t4 * t6 / t7
  t12 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t24 = t20 * t5 / t21
  t26 = 0.37978500000000000000000000000000000000000000000000e1 * t13 + 0.89690000000000000000000000000000000000000000000000e0 * t10 + 0.20477500000000000000000000000000000000000000000000e0 * t16 + 0.12323500000000000000000000000000000000000000000000e0 * t24
  t27 = t26 ** 2
  t29 = 0.1e1 / t27 / t26
  t30 = t12 * t29
  t32 = 0.1e1 / t13 * t1
  t33 = t3 * t6
  t35 = 0.1e1 / t7 / r0
  t36 = t33 * t35
  t37 = t32 * t36
  t39 = t6 * t35
  t40 = t4 * t39
  t42 = t10 ** 0.5e0
  t43 = t42 * t1
  t44 = t43 * t36
  t49 = t20 * t5 / t21 / r0
  t51 = -0.63297500000000000000000000000000000000000000000000e0 * t37 - 0.29896666666666666666666666666666666666666666666667e0 * t40 - 0.10238750000000000000000000000000000000000000000000e0 * t44 - 0.82156666666666666666666666666666666666666666666667e-1 * t49
  t52 = t51 ** 2
  t55 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t26
  t56 = 0.1e1 / t55
  t57 = t52 * t56
  t58 = t30 * t57
  t60 = 0.1e1 / t27
  t61 = t12 * t60
  t64 = 0.1e1 / t13 / t10 * t18
  t65 = t19 * t5
  t66 = r0 ** 2
  t68 = 0.1e1 / t21 / t66
  t69 = t65 * t68
  t70 = t64 * t69
  t73 = 0.1e1 / t7 / t66
  t74 = t33 * t73
  t75 = t32 * t74
  t77 = t6 * t73
  t78 = t4 * t77
  t80 = t10 ** (-0.5e0)
  t81 = t80 * t18
  t82 = t81 * t69
  t84 = t43 * t74
  t87 = t20 * t5 * t68
  t89 = -0.42198333333333333333333333333333333333333333333333e0 * t70 + 0.84396666666666666666666666666666666666666666666666e0 * t75 + 0.39862222222222222222222222222222222222222222222223e0 * t78 + 0.68258333333333333333333333333333333333333333333333e-1 * t82 + 0.13651666666666666666666666666666666666666666666667e0 * t84 + 0.13692777777777777777777777777777777777777777777778e0 * t87
  t90 = t89 * t56
  t91 = t61 * t90
  t93 = t27 ** 2
  t94 = 0.1e1 / t93
  t95 = t12 * t94
  t96 = t55 ** 2
  t97 = 0.1e1 / t96
  t98 = t52 * t97
  t99 = t95 * t98
  t101 = jnp.log(t55)
  t103 = t4 * t77 * t101
  t105 = 0.1e1 <= f.p.zeta_threshold
  t106 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t108 = f.my_piecewise3(t105, t106 * f.p.zeta_threshold, 1)
  t111 = 2 ** (0.1e1 / 0.3e1)
  t115 = (0.2e1 * t108 - 0.2e1) / (0.2e1 * t111 - 0.2e1)
  t116 = t115 * t4
  t121 = 0.51785000000000000000000000000000000000000000000000e1 * t13 + 0.90577500000000000000000000000000000000000000000000e0 * t10 + 0.11003250000000000000000000000000000000000000000000e0 * t16 + 0.12417750000000000000000000000000000000000000000000e0 * t24
  t122 = t121 ** 2
  t123 = 0.1e1 / t122
  t128 = -0.86308333333333333333333333333333333333333333333334e0 * t37 - 0.30192500000000000000000000000000000000000000000000e0 * t40 - 0.55016250000000000000000000000000000000000000000000e-1 * t44 - 0.82785000000000000000000000000000000000000000000000e-1 * t49
  t132 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t121
  t133 = 0.1e1 / t132
  t134 = t123 * t128 * t133
  t136 = t116 * t39 * t134
  t138 = t4 * t6
  t139 = t35 * t60
  t140 = t51 * t56
  t142 = t138 * t139 * t140
  t144 = t115 * t1
  t145 = jnp.log(t132)
  t148 = t144 * t33 * t73 * t145
  t151 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t10
  t152 = t115 * t151
  t153 = t122 ** 2
  t156 = t128 ** 2
  t157 = t156 * t128
  t159 = t132 ** 2
  t160 = 0.1e1 / t159
  t163 = 0.10389515463408878255799889850284635099347639899143e3 * t152 / t153 / t121 * t157 * t160
  t168 = t66 ** 2
  t169 = 0.1e1 / t168
  t170 = 0.1e1 / t13 / t24 * t2 * t169 / 0.4e1
  t172 = t66 * r0
  t174 = 0.1e1 / t21 / t172
  t175 = t65 * t174
  t176 = t64 * t175
  t179 = 0.1e1 / t7 / t172
  t180 = t33 * t179
  t181 = t32 * t180
  t183 = t6 * t179
  t184 = t4 * t183
  t186 = t10 ** (-0.15e1)
  t188 = t186 * t2 * t169
  t190 = t81 * t175
  t192 = t43 * t180
  t195 = t20 * t5 * t174
  t201 = 0.58482236226346462072622386637590534819724553404280e0 * t152 * t123 * (-0.34523333333333333333333333333333333333333333333333e1 * t170 + 0.23015555555555555555555555555555555555555555555556e1 * t176 - 0.26851481481481481481481481481481481481481481481482e1 * t181 - 0.93932222222222222222222222222222222222222222222223e0 * t184 + 0.73355000000000000000000000000000000000000000000000e-1 * t188 - 0.14671000000000000000000000000000000000000000000000e0 * t190 - 0.17116166666666666666666666666666666666666666666667e0 * t192 - 0.36793333333333333333333333333333333333333333333333e0 * t195) * t133
  t209 = 0.10254018858216406658218194626490193680059335835414e4 * t152 / t153 / t122 * t157 / t159 / t132
  t210 = 0.1e1 / t153
  t214 = 0.35089341735807877243573431982554320891834732042568e1 * t152 * t210 * t157 * t133
  t215 = jnp.log(0.2e1)
  t216 = 0.1e1 - t215
  t217 = jnp.pi ** 2
  t219 = t216 / t217
  t220 = t106 ** 2
  t221 = f.my_piecewise3(t105, t220, 1)
  t222 = t221 ** 2
  t223 = t222 * t221
  t225 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e-1 * t10
  t227 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t10
  t228 = 0.1e1 / t227
  t229 = t225 * t228
  t230 = 0.1e1 / t216
  t239 = 0.1e1 / t223
  t240 = t217 * t239
  t242 = jnp.exp(-(-0.621814e-1 * t12 * t101 + 0.19751673498613801407483339618206552048944131217655e-1 * t115 * t151 * t145) * t230 * t240)
  t243 = t242 - 0.1e1
  t244 = 0.1e1 / t243
  t246 = t217 * t244 * s0
  t247 = t229 * t230 * t246
  t249 = 0.1e1 / t222
  t251 = 0.1e1 / t3
  t252 = t18 * t251
  t253 = t252 * t5
  t257 = 0.1e1 + 0.27801896084645508333333333333333333333333333333333e-2 * t247 * t73 * t111 * t249 * t253
  t258 = t257 ** 2
  t260 = t257 ** (0.1e1 / 0.4e1)
  t263 = t174 * t228
  t264 = t230 * t217
  t266 = t244 * s0
  t268 = t266 * t111 * t249
  t271 = t227 ** 2
  t272 = 0.1e1 / t271
  t273 = t225 * t272
  t274 = t273 * t264
  t280 = t216 ** 2
  t281 = 0.1e1 / t280
  t282 = t229 * t281
  t283 = t217 ** 2
  t284 = t243 ** 2
  t285 = 0.1e1 / t284
  t286 = t283 * t285
  t287 = s0 * t73
  t289 = t282 * t286 * t287
  t290 = t222 ** 2
  t292 = 0.1e1 / t290 / t221
  t293 = t111 * t292
  t294 = t293 * t18
  t295 = t251 * t5
  t307 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t39 * t101 + 0.10000000000000000000000000000000000000000000000000e1 * t61 * t140 - 0.18311447306006545054854346104378990962041954983034e-3 * t144 * t33 * t35 * t145 - 0.58482236226346462072622386637590534819724553404280e0 * t152 * t134
  t308 = t307 * t242
  t310 = t294 * t295 * t308
  t318 = -0.27801896084645508333333333333333333333333333333333e-3 * t263 * t264 * t268 + 0.49431771238499713816666666666666666666666666666666e-3 * t274 * t266 * t174 * t111 * t249 + 0.27801896084645508333333333333333333333333333333333e-2 * t289 * t310 - 0.64871090864172852777777777777777777777777777777777e-2 * t247 * t179 * t111 * t249 * t253
  t319 = t318 ** 2
  t325 = 0.1e1 / t260 / t258
  t328 = 0.1e1 / t21 / t168
  t329 = t328 * t228
  t333 = t168 * r0
  t334 = 0.1e1 / t333
  t335 = t334 * t272
  t336 = t264 * t244
  t338 = s0 * t111
  t339 = t338 * t249
  t340 = t339 * t138
  t343 = t281 * t283
  t344 = t343 * t285
  t345 = t263 * t344
  t347 = t292 * t307 * t242
  t348 = t338 * t347
  t352 = 0.1e1 / t271 / t227
  t353 = t225 * t352
  t355 = t353 * t230 * t246
  t361 = t273 * t344
  t363 = s0 * t174 * t111
  t373 = 0.1e1 / t280 / t216
  t374 = t229 * t373
  t375 = t283 * t217
  t377 = 0.1e1 / t284 / t243
  t378 = t375 * t377
  t380 = t374 * t378 * t287
  t381 = t290 ** 2
  t382 = 0.1e1 / t381
  t383 = t111 * t382
  t384 = t383 * t18
  t385 = t307 ** 2
  t386 = t242 ** 2
  t389 = t384 * t295 * t385 * t386
  t392 = s0 * t179
  t394 = t282 * t286 * t392
  t405 = 0.1e1 / t122 / t121
  t407 = t405 * t156 * t133
  t408 = t152 * t407
  t416 = -0.57538888888888888888888888888888888888888888888889e0 * t70 + 0.11507777777777777777777777777777777777777777777778e1 * t75 + 0.40256666666666666666666666666666666666666666666667e0 * t78 + 0.36677500000000000000000000000000000000000000000000e-1 * t82 + 0.73355000000000000000000000000000000000000000000000e-1 * t84 + 0.13797500000000000000000000000000000000000000000000e0 * t87
  t418 = t123 * t416 * t133
  t419 = t152 * t418
  t422 = t210 * t156 * t160
  t423 = t152 * t422
  t425 = -0.14764627977777777777777777777777777777777777777777e-2 * t103 - 0.35616666666666666666666666666666666666666666666666e-1 * t142 - 0.20000000000000000000000000000000000000000000000000e1 * t58 + 0.10000000000000000000000000000000000000000000000000e1 * t91 + 0.16081979498692535066756296899072713062105388428051e2 * t99 + 0.24415263074675393406472461472505321282722606644045e-3 * t148 + 0.10843581300301739842632067522386578331157260943710e-1 * t136 + 0.11696447245269292414524477327518106963944910680856e1 * t408 - 0.58482236226346462072622386637590534819724553404280e0 * t419 - 0.17315859105681463759666483083807725165579399831905e2 * t423
  t428 = t294 * t295 * t425 * t242
  t431 = t375 * t285
  t433 = t374 * t431 * t287
  t436 = t384 * t295 * t385 * t242
  t440 = 0.1e1 / t7 / t168
  t446 = 0.16681137650787305000000000000000000000000000000000e-2 * t329 * t264 * t268 - 0.82386285397499523027777777777777777777777777777777e-5 * t335 * t336 * t340 - 0.55603792169291016666666666666666666666666666666666e-3 * t345 * t348 + 0.14648281543675415194338888888888888888888888888889e-4 * t355 * t334 * t111 * t249 * t138 + 0.98863542476999427633333333333333333333333333333332e-3 * t361 * t363 * t347 - 0.29659062743099828290000000000000000000000000000000e-2 * t274 * t266 * t328 * t111 * t249 + 0.55603792169291016666666666666666666666666666666666e-2 * t380 * t389 - 0.12974218172834570555555555555555555555555555555555e-1 * t394 * t310 + 0.27801896084645508333333333333333333333333333333333e-2 * t289 * t428 - 0.27801896084645508333333333333333333333333333333333e-2 * t433 * t436 + 0.21623696954724284259259259259259259259259259259259e-1 * t247 * t440 * t111 * t249 * t253
  t450 = t325 * t319
  t453 = t264 * t239 * t242
  t457 = 0.1e1 / t260 / t257
  t473 = t293 * t1 * t33 * t308
  t476 = t280 ** 2
  t478 = t229 / t476
  t479 = t283 ** 2
  t480 = t284 ** 2
  t488 = t111 / t381 / t223 * t18
  t489 = t385 * t307
  t512 = 0.34450798614814814814814814814814814814814814814813e-2 * t4 * t183 * t101
  t515 = 0.32530743900905219527896202567159734993471782831130e-1 * t116 * t39 * t407
  t518 = 0.21687162600603479685264135044773156662314521887420e-1 * t116 * t77 * t134
  t521 = 0.16265371950452609763948101283579867496735891415565e-1 * t116 * t39 * t418
  t524 = 0.48159733137676571081572406076840235616767705782485e0 * t116 * t39 * t422
  t529 = 0.35089341735807877243573431982554320891834732042568e1 * t152 * t405 * t128 * t133 * t416
  t534 = 0.51947577317044391278999449251423175496738199495715e2 * t152 * t210 * t416 * t160 * t128
  t538 = 0.71233333333333333333333333333333333333333333333331e-1 * t138 * t73 * t60 * t140
  t541 = 0.53424999999999999999999999999999999999999999999999e-1 * t138 * t139 * t90
  t545 = 0.85917975471764868594145516183295969534298037676861e0 * t138 * t35 * t94 * t98
  t546 = t512 - t515 - t518 + t521 + t524 - t214 + t529 - t534 + t538 - t541 - t545
  t550 = 0.48245938496077605200268890697218139186316165284153e2 * t95 * t89 * t97 * t51
  t551 = t52 * t51
  t554 = 0.60000000000000000000000000000000000000000000000000e1 * t95 * t551 * t56
  t557 = 0.60000000000000000000000000000000000000000000000000e1 * t30 * t140 * t89
  t561 = 0.10685000000000000000000000000000000000000000000000e0 * t138 * t35 * t29 * t57
  t565 = 0.56968947174242584615102410102512416326352748836105e-3 * t144 * t33 * t179 * t145
  t571 = 0.96491876992155210400537781394436278372632330568306e2 * t12 / t93 / t26 * t551 * t97
  t583 = 0.10000000000000000000000000000000000000000000000000e1 * t61 * (-0.25319000000000000000000000000000000000000000000000e1 * t170 + 0.16879333333333333333333333333333333333333333333333e1 * t176 - 0.19692555555555555555555555555555555555555555555555e1 * t181 - 0.93011851851851851851851851851851851851851851851854e0 * t184 + 0.13651666666666666666666666666666666666666666666667e0 * t188 - 0.27303333333333333333333333333333333333333333333333e0 * t190 - 0.31853888888888888888888888888888888888888888888890e0 * t192 - 0.36514074074074074074074074074074074074074074074075e0 * t195) * t56
  t591 = 0.51726012919273400298984252201052768390886626637712e3 * t12 / t93 / t27 * t551 / t96 / t55
  t592 = t550 + t554 - t557 + t163 - t201 - t209 + t561 - t565 - t571 + t583 + t591
  t593 = t546 + t592
  t608 = 0.1e1 / t21 / t333
  t613 = t383 * t252
  t625 = t373 * t375
  t626 = t625 * t377
  t628 = t382 * t385
  t629 = t628 * t386
  t633 = 0.64871090864172852777777777777777777777777777777776e-1 * t282 * t286 * s0 * t440 * t310 - 0.38922654518503711666666666666666666666666666666665e-1 * t374 * t378 * t392 * t389 + 0.43944844631026245583016666666666666666666666666667e-4 * t353 * t281 * t286 * s0 * t334 * t473 + 0.16681137650787305000000000000000000000000000000000e-1 * t478 * t479 / t480 * t287 * t488 * t295 * t489 * t386 * t242 - 0.16681137650787305000000000000000000000000000000000e-1 * t478 * t479 * t377 * t287 * t488 * t295 * t489 * t386 - 0.19461327259251855833333333333333333333333333333333e-1 * t394 * t428 + 0.19461327259251855833333333333333333333333333333333e-1 * t374 * t431 * t392 * t436 + 0.27801896084645508333333333333333333333333333333333e-2 * t289 * t294 * t295 * t593 * t242 + 0.27801896084645508333333333333333333333333333333333e-2 * t478 * t479 * t285 * t287 * t488 * t295 * t489 * t242 - 0.99469005991731707592592592592592592592592592592592e-2 * t608 * t228 * t264 * t268 - 0.83405688253936524999999999999999999999999999999999e-2 * t433 * t613 * t5 * t425 * t308 + 0.16681137650787305000000000000000000000000000000000e-1 * t380 * t613 * t5 * t307 * t386 * t425 - 0.16681137650787305000000000000000000000000000000000e-2 * t263 * t626 * t338 * t629
  t634 = t625 * t285
  t636 = t628 * t242
  t644 = t292 * t425 * t242
  t653 = t271 ** 2
  t658 = t168 * t66
  t660 = 0.1e1 / t7 / t658
  t663 = t20 * t5
  t674 = 0.1e1 / t658
  t710 = 0.83405688253936524999999999999999999999999999999999e-3 * t263 * t634 * t338 * t636 + 0.50043412952361914999999999999999999999999999999999e-2 * t329 * t344 * t348 - 0.83405688253936524999999999999999999999999999999999e-3 * t345 * t338 * t644 + 0.17685589265329897609962962962962962962962962962963e-1 * t274 * t266 * t608 * t111 * t249 + 0.26044644584654888215534544444444444444444444444445e-5 * t225 / t653 * t230 * t246 * t660 * t111 * t249 * t663 - 0.93702686803805231790123456790123456790123456790122e-1 * t247 / t7 / t333 * t111 * t249 * t253 - 0.16113109698042956713772777777777777777777777777778e-3 * t355 * t674 * t111 * t249 * t138 - 0.24715885619249856908333333333333333333333333333334e-4 * t335 * t281 * t286 * s0 * t473 + 0.14829531371549914145000000000000000000000000000000e-2 * t361 * t363 * t644 - 0.88977188229299484869999999999999999999999999999999e-2 * t361 * s0 * t328 * t111 * t347 + 0.29659062743099828289999999999999999999999999999999e-2 * t273 * t626 * t363 * t629 - 0.14829531371549914145000000000000000000000000000000e-2 * t273 * t634 * t363 * t636 + 0.90624913937249475330555555555555555555555555555555e-4 * t674 * t272 * t336 * t340 - 0.14648281543675415194338888888888888888888888888889e-5 * t660 * t352 * t336 * t339 * t663
  t715 = t457 * t446
  t719 = t457 * t318
  t725 = 0.1e1 / t290 / t222
  t731 = 0.1e1 - 0.1e1 / t260
  t734 = t240 * t242
  t737 = t731 * t425
  t739 = t283 * t725
  t755 = 0.1e1 + 0.10000000000000000000000000000000000000000000000000e1 * t731 * t243
  t756 = 0.1e1 / t755
  t765 = 0.25000000000000000000000000000000000000000000000000e0 * t719 * t243 - 0.10000000000000000000000000000000000000000000000000e1 * t731 * t307 * t230 * t734
  t766 = t765 ** 2
  t769 = t755 ** 2
  t775 = t163 - t201 - t209 - t214 + t219 * t223 * (0.70312500000000000000000000000000000000000000000000e0 / t260 / t258 / t257 * t319 * t318 * t243 - 0.93750000000000000000000000000000000000000000000000e0 * t325 * t318 * t243 * t446 + 0.93750000000000000000000000000000000000000000000000e0 * t450 * t307 * t453 + 0.25000000000000000000000000000000000000000000000000e0 * t457 * (t633 + t710) * t243 - 0.75000000000000000000000000000000000000000000000000e0 * t715 * t307 * t453 - 0.75000000000000000000000000000000000000000000000000e0 * t719 * t425 * t453 + 0.75000000000000000000000000000000000000000000000000e0 * t719 * t385 * t343 * t725 * t242 - 0.10000000000000000000000000000000000000000000000000e1 * t731 * t593 * t230 * t734 + 0.30000000000000000000000000000000000000000000000000e1 * t737 * t281 * t739 * t308 - 0.10000000000000000000000000000000000000000000000000e1 * t731 * t489 * t373 * t375 / t381 / t221 * t242) * t756 + 0.2e1 * t219 * t223 * t766 * t765 / t769 / t755 + t591 + t554 - t571 + t583 - t557 + t550
  t792 = -0.31250000000000000000000000000000000000000000000000e0 * t450 * t243 + 0.25000000000000000000000000000000000000000000000000e0 * t715 * t243 - 0.50000000000000000000000000000000000000000000000000e0 * t719 * t307 * t453 - 0.10000000000000000000000000000000000000000000000000e1 * t737 * t230 * t734 + 0.10000000000000000000000000000000000000000000000000e1 * t731 * t385 * t281 * t739 * t242
  t793 = 0.1e1 / t769
  t798 = -0.3e1 * t219 * t223 * t792 * t793 * t765 + t512 - t515 - t518 + t521 + t524 + t529 - t534 + t538 - t541 - t545 + t561 - t565
  v3rho3_0_ = -0.60000000000000000000000000000000000000000000000000e1 * t58 + 0.30000000000000000000000000000000000000000000000000e1 * t91 + 0.48245938496077605200268890697218139186316165284153e2 * t99 - 0.44293883933333333333333333333333333333333333333332e-2 * t103 + 0.32530743900905219527896202567159734993471782831130e-1 * t136 - 0.10685000000000000000000000000000000000000000000000e0 * t142 + 0.73245789224026180219417384417515963848167819932136e-3 * t148 + r0 * (t775 + t798) + 0.3e1 * t219 * t223 * t792 * t756 + 0.35089341735807877243573431982554320891834732042568e1 * t408 - 0.17544670867903938621786715991277160445917366021284e1 * t419 - 0.51947577317044391278999449251423175496738199495715e2 * t423 - 0.3e1 * t219 * t223 * t766 * t793

  res = {'v3rho3': v3rho3_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t14 = t4 * t6 / t8
  t15 = jnp.sqrt(t14)
  t18 = t14 ** 0.15e1
  t20 = t1 ** 2
  t21 = t3 ** 2
  t22 = t20 * t21
  t23 = t8 ** 2
  t26 = t22 * t5 / t23
  t28 = 0.37978500000000000000000000000000000000000000000000e1 * t15 + 0.89690000000000000000000000000000000000000000000000e0 * t14 + 0.20477500000000000000000000000000000000000000000000e0 * t18 + 0.12323500000000000000000000000000000000000000000000e0 * t26
  t31 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t28
  t32 = jnp.log(t31)
  t34 = t4 * t11 * t32
  t35 = 0.22146941966666666666666666666666666666666666666666e-2 * t34
  t37 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t14
  t38 = t28 ** 2
  t39 = 0.1e1 / t38
  t40 = t37 * t39
  t42 = 0.1e1 / t15 * t1
  t43 = t3 * t6
  t44 = t43 * t10
  t45 = t42 * t44
  t47 = t4 * t11
  t49 = t14 ** 0.5e0
  t50 = t49 * t1
  t51 = t50 * t44
  t56 = t22 * t5 / t23 / t7
  t58 = -0.63297500000000000000000000000000000000000000000000e0 * t45 - 0.29896666666666666666666666666666666666666666666667e0 * t47 - 0.10238750000000000000000000000000000000000000000000e0 * t51 - 0.82156666666666666666666666666666666666666666666667e-1 * t56
  t59 = 0.1e1 / t31
  t60 = t58 * t59
  t61 = t40 * t60
  t62 = 0.20000000000000000000000000000000000000000000000000e1 * t61
  t63 = r0 - r1
  t64 = t63 ** 2
  t65 = t64 * t63
  t66 = t7 ** 2
  t67 = t66 ** 2
  t68 = 0.1e1 / t67
  t69 = t65 * t68
  t70 = 0.1e1 / t7
  t71 = t63 * t70
  t72 = 0.1e1 + t71
  t73 = t72 <= f.p.zeta_threshold
  t74 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t75 = t74 * f.p.zeta_threshold
  t76 = t72 ** (0.1e1 / 0.3e1)
  t77 = t76 * t72
  t78 = f.my_piecewise3(t73, t75, t77)
  t79 = 0.1e1 - t71
  t80 = t79 <= f.p.zeta_threshold
  t81 = t79 ** (0.1e1 / 0.3e1)
  t82 = t81 * t79
  t83 = f.my_piecewise3(t80, t75, t82)
  t85 = 2 ** (0.1e1 / 0.3e1)
  t88 = 0.1e1 / (0.2e1 * t85 - 0.2e1)
  t89 = (t78 + t83 - 0.2e1) * t88
  t91 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t14
  t96 = 0.70594500000000000000000000000000000000000000000000e1 * t15 + 0.15494250000000000000000000000000000000000000000000e1 * t14 + 0.42077500000000000000000000000000000000000000000000e0 * t18 + 0.15629250000000000000000000000000000000000000000000e0 * t26
  t99 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t96
  t100 = jnp.log(t99)
  t104 = 0.621814e-1 * t37 * t32
  t106 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t14
  t111 = 0.51785000000000000000000000000000000000000000000000e1 * t15 + 0.90577500000000000000000000000000000000000000000000e0 * t14 + 0.11003250000000000000000000000000000000000000000000e0 * t18 + 0.12417750000000000000000000000000000000000000000000e0 * t26
  t114 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t111
  t115 = jnp.log(t114)
  t116 = t106 * t115
  t118 = -0.3109070e-1 * t91 * t100 + t104 - 0.19751673498613801407483339618206552048944131217655e-1 * t116
  t119 = t89 * t118
  t120 = t69 * t119
  t121 = 0.8e1 * t120
  t122 = t64 ** 2
  t124 = 0.1e1 / t67 / t7
  t125 = t122 * t124
  t126 = t125 * t119
  t127 = 0.8e1 * t126
  t128 = t122 * t68
  t129 = 0.1e1 / t66
  t130 = t63 * t129
  t131 = t70 - t130
  t134 = f.my_piecewise3(t73, 0, 0.4e1 / 0.3e1 * t76 * t131)
  t135 = -t131
  t138 = f.my_piecewise3(t80, 0, 0.4e1 / 0.3e1 * t81 * t135)
  t140 = (t134 + t138) * t88
  t141 = t140 * t118
  t142 = t128 * t141
  t147 = t96 ** 2
  t148 = 0.1e1 / t147
  t149 = t91 * t148
  t154 = -0.11765750000000000000000000000000000000000000000000e1 * t45 - 0.51647500000000000000000000000000000000000000000000e0 * t47 - 0.21038750000000000000000000000000000000000000000000e0 * t51 - 0.10419500000000000000000000000000000000000000000000e0 * t56
  t155 = 0.1e1 / t99
  t156 = t154 * t155
  t159 = 0.11073470983333333333333333333333333333333333333333e-2 * t34
  t160 = 0.10000000000000000000000000000000000000000000000000e1 * t61
  t164 = t111 ** 2
  t165 = 0.1e1 / t164
  t166 = t106 * t165
  t171 = -0.86308333333333333333333333333333333333333333333334e0 * t45 - 0.30192500000000000000000000000000000000000000000000e0 * t47 - 0.55016250000000000000000000000000000000000000000000e-1 * t51 - 0.82785000000000000000000000000000000000000000000000e-1 * t56
  t172 = 0.1e1 / t114
  t173 = t171 * t172
  t176 = 0.53237641966666666666666666666666666666666666666666e-3 * t4 * t11 * t100 + 0.10000000000000000000000000000000000000000000000000e1 * t149 * t156 - t159 - t160 + 0.18311447306006545054854346104378990962041954983034e-3 * t4 * t11 * t115 + 0.58482236226346462072622386637590534819724553404280e0 * t166 * t173
  t177 = t89 * t176
  t178 = t128 * t177
  t179 = 0.2e1 * t178
  t180 = t140 * t116
  t182 = t89 * t1
  t184 = t43 * t10 * t115
  t185 = t182 * t184
  t186 = 0.36622894612013090109708692208757981924083909966068e-3 * t185
  t187 = t89 * t106
  t189 = t165 * t171 * t172
  t190 = t187 * t189
  t191 = 0.11696447245269292414524477327518106963944910680856e1 * t190
  t192 = jnp.log(0.2e1)
  t193 = 0.1e1 - t192
  t194 = jnp.pi ** 2
  t196 = t193 / t194
  t197 = t74 ** 2
  t198 = t76 ** 2
  t199 = f.my_piecewise3(t73, t197, t198)
  t200 = t81 ** 2
  t201 = f.my_piecewise3(t80, t197, t200)
  t203 = t199 / 0.2e1 + t201 / 0.2e1
  t204 = t203 ** 2
  t206 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e-1 * t14
  t208 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t14
  t209 = 0.1e1 / t208
  t211 = 0.1e1 / t193
  t212 = t206 * t209 * t211
  t217 = (-t104 + t128 * t119 + 0.19751673498613801407483339618206552048944131217655e-1 * t89 * t116) * t211
  t218 = t204 * t203
  t219 = 0.1e1 / t218
  t220 = t194 * t219
  t222 = jnp.exp(-t217 * t220)
  t223 = t222 - 0.1e1
  t224 = 0.1e1 / t223
  t225 = t194 * t224
  t227 = s0 + 0.2e1 * s1 + s2
  t228 = t225 * t227
  t229 = t212 * t228
  t231 = 0.1e1 / t8 / t66
  t232 = t231 * t85
  t233 = 0.1e1 / t204
  t235 = 0.1e1 / t3
  t236 = t20 * t235
  t237 = t236 * t5
  t241 = 0.1e1 + 0.27801896084645508333333333333333333333333333333333e-2 * t229 * t232 * t233 * t237
  t242 = t241 ** (0.1e1 / 0.4e1)
  t244 = 0.1e1 - 0.1e1 / t242
  t247 = 0.1e1 + 0.10000000000000000000000000000000000000000000000000e1 * t244 * t223
  t248 = jnp.log(t247)
  t249 = t204 * t248
  t250 = 0.1e1 / t76
  t253 = f.my_piecewise3(t73, 0, 0.2e1 / 0.3e1 * t250 * t131)
  t254 = 0.1e1 / t81
  t257 = f.my_piecewise3(t80, 0, 0.2e1 / 0.3e1 * t254 * t135)
  t259 = t253 / 0.2e1 + t257 / 0.2e1
  t261 = t196 * t249 * t259
  t264 = 0.1e1 / t242 / t241
  t265 = t66 * t7
  t267 = 0.1e1 / t23 / t265
  t268 = t267 * t209
  t269 = t211 * t194
  t270 = t268 * t269
  t271 = t224 * t227
  t272 = t85 * t233
  t273 = t271 * t272
  t275 = 0.27801896084645508333333333333333333333333333333333e-3 * t270 * t273
  t276 = t208 ** 2
  t277 = 0.1e1 / t276
  t278 = t206 * t277
  t279 = t278 * t269
  t284 = 0.49431771238499713816666666666666666666666666666666e-3 * t279 * t271 * t267 * t85 * t233
  t285 = t223 ** 2
  t286 = 0.1e1 / t285
  t287 = t194 * t286
  t288 = t227 * t231
  t290 = t212 * t287 * t288
  t291 = t272 * t20
  t292 = t235 * t5
  t293 = 0.4e1 * t120
  t294 = 0.4e1 * t126
  t295 = 0.19751673498613801407483339618206552048944131217655e-1 * t180
  t296 = 0.18311447306006545054854346104378990962041954983034e-3 * t185
  t297 = 0.58482236226346462072622386637590534819724553404280e0 * t190
  t299 = (t159 + t160 + t293 - t294 + t142 + t178 + t295 - t296 - t297) * t211
  t301 = t204 ** 2
  t302 = 0.1e1 / t301
  t303 = t194 * t302
  t304 = t303 * t259
  t307 = 0.3e1 * t217 * t304 - t299 * t220
  t308 = t307 * t222
  t310 = t291 * t292 * t308
  t314 = 0.1e1 / t8 / t265
  t315 = t314 * t85
  t319 = 0.64871090864172852777777777777777777777777777777777e-2 * t229 * t315 * t233 * t237
  t320 = t232 * t219
  t322 = t236 * t5 * t259
  t326 = -t275 + t284 - 0.27801896084645508333333333333333333333333333333333e-2 * t290 * t310 - t319 - 0.55603792169291016666666666666666666666666666666666e-2 * t229 * t320 * t322
  t327 = t264 * t326
  t333 = 0.25000000000000000000000000000000000000000000000000e0 * t327 * t223 + 0.10000000000000000000000000000000000000000000000000e1 * t244 * t307 * t222
  t335 = 0.1e1 / t247
  t337 = t196 * t218 * t333 * t335
  t340 = t140 * t1 * t184
  t341 = 0.36622894612013090109708692208757981924083909966068e-3 * t340
  t345 = 0.24415263074675393406472461472505321282722606644045e-3 * t182 * t43 * t231 * t115
  t346 = t4 * t6
  t350 = 0.35616666666666666666666666666666666666666666666666e-1 * t346 * t10 * t39 * t60
  t351 = t125 * t141
  t352 = 0.8e1 * t351
  t354 = 0.8e1 * t125 * t177
  t355 = t69 * t141
  t356 = 0.8e1 * t355
  t358 = t128 * t140 * t176
  t359 = 0.2e1 * t358
  t360 = t241 ** 2
  t362 = 0.1e1 / t242 / t360
  t363 = t326 ** 2
  t373 = 0.21623696954724284259259259259259259259259259259259e-1 * t229 / t8 / t67 * t85 * t233 * t237
  t374 = t315 * t219
  t376 = t229 * t374 * t322
  t378 = 0.1e1 / t77
  t379 = t131 ** 2
  t382 = 0.1e1 / t265
  t383 = t63 * t382
  t385 = -0.2e1 * t129 + 0.2e1 * t383
  t389 = f.my_piecewise3(t73, 0, -0.2e1 / 0.9e1 * t378 * t379 + 0.2e1 / 0.3e1 * t250 * t385)
  t390 = 0.1e1 / t82
  t391 = t135 ** 2
  t394 = -t385
  t398 = f.my_piecewise3(t80, 0, -0.2e1 / 0.9e1 * t390 * t391 + 0.2e1 / 0.3e1 * t254 * t394)
  t400 = t389 / 0.2e1 + t398 / 0.2e1
  t406 = t269 * t224
  t407 = t278 * t406
  t408 = t227 * t267
  t409 = t85 * t219
  t410 = t409 * t259
  t412 = t407 * t408 * t410
  t415 = t270 * t271 * t410
  t418 = 0.1e1 / t23 / t67
  t422 = 0.16681137650787305000000000000000000000000000000000e-2 * t418 * t209 * t269 * t273
  t427 = 0.29659062743099828290000000000000000000000000000000e-2 * t279 * t271 * t418 * t85 * t233
  t428 = t269 * t286
  t429 = t268 * t428
  t430 = t227 * t85
  t432 = t233 * t307 * t222
  t434 = t429 * t430 * t432
  t441 = 0.82386285397499523027777777777777777777777777777777e-5 * t124 * t277 * t406 * t430 * t233 * t346
  t442 = t278 * t428
  t443 = t408 * t85
  t445 = t442 * t443 * t432
  t456 = 0.14648281543675415194338888888888888888888888888889e-4 * t206 / t276 / t208 * t211 * t228 * t124 * t85 * t233 * t346
  t459 = t212 * t287 * t227 * t314
  t460 = t459 * t310
  t462 = t409 * t236
  t464 = t222 * t259
  t469 = t307 ** 2
  t479 = t212 * t194 / t285 / t223 * t288
  t480 = t222 ** 2
  t486 = 0.1e1 / t198
  t492 = f.my_piecewise3(t73, 0, 0.4e1 / 0.9e1 * t486 * t379 + 0.4e1 / 0.3e1 * t76 * t385)
  t493 = 0.1e1 / t200
  t499 = f.my_piecewise3(t80, 0, 0.4e1 / 0.9e1 * t493 * t391 + 0.4e1 / 0.3e1 * t81 * t394)
  t501 = (t492 + t499) * t88
  t503 = 0.19751673498613801407483339618206552048944131217655e-1 * t501 * t116
  t509 = 0.1e1 / t23 / t66
  t510 = t21 * t5 * t509
  t511 = 0.1e1 / t15 / t14 * t20 * t510
  t513 = t43 * t231
  t514 = t42 * t513
  t516 = t6 * t231
  t517 = t4 * t516
  t519 = t14 ** (-0.5e0)
  t521 = t519 * t20 * t510
  t523 = t50 * t513
  t526 = t22 * t5 * t509
  t531 = 0.10000000000000000000000000000000000000000000000000e1 * t40 * (-0.42198333333333333333333333333333333333333333333333e0 * t511 + 0.84396666666666666666666666666666666666666666666666e0 * t514 + 0.39862222222222222222222222222222222222222222222223e0 * t517 + 0.68258333333333333333333333333333333333333333333333e-1 * t521 + 0.13651666666666666666666666666666666666666666666667e0 * t523 + 0.13692777777777777777777777777777777777777777777778e0 * t526) * t59
  t532 = t38 ** 2
  t535 = t58 ** 2
  t536 = t31 ** 2
  t540 = 0.16081979498692535066756296899072713062105388428051e2 * t37 / t532 * t535 / t536
  t542 = 0.1e1 / t164 / t111
  t543 = t171 ** 2
  t547 = 0.11696447245269292414524477327518106963944910680856e1 * t187 * t542 * t543 * t172
  t548 = t164 ** 2
  t549 = 0.1e1 / t548
  t551 = t114 ** 2
  t552 = 0.1e1 / t551
  t555 = 0.17315859105681463759666483083807725165579399831905e2 * t187 * t549 * t543 * t552
  t562 = -0.57538888888888888888888888888888888888888888888889e0 * t511 + 0.11507777777777777777777777777777777777777777777778e1 * t514 + 0.40256666666666666666666666666666666666666666666667e0 * t517 + 0.36677500000000000000000000000000000000000000000000e-1 * t521 + 0.73355000000000000000000000000000000000000000000000e-1 * t523 + 0.13797500000000000000000000000000000000000000000000e0 * t526
  t566 = 0.58482236226346462072622386637590534819724553404280e0 * t187 * t165 * t562 * t172
  t568 = t140 * t106 * t189
  t569 = 0.11696447245269292414524477327518106963944910680856e1 * t568
  t580 = t154 ** 2
  t594 = t147 ** 2
  t597 = t99 ** 2
  t604 = 0.14764627977777777777777777777777777777777777777777e-2 * t4 * t516 * t32
  t610 = 0.20000000000000000000000000000000000000000000000000e1 * t37 / t38 / t28 * t535 * t59
  t629 = -0.70983522622222222222222222222222222222222222222221e-3 * t4 * t516 * t100 - 0.34246666666666666666666666666666666666666666666666e-1 * t346 * t10 * t148 * t156 - 0.20000000000000000000000000000000000000000000000000e1 * t91 / t147 / t96 * t580 * t155 + 0.10000000000000000000000000000000000000000000000000e1 * t149 * (-0.78438333333333333333333333333333333333333333333333e0 * t511 + 0.15687666666666666666666666666666666666666666666667e1 * t514 + 0.68863333333333333333333333333333333333333333333333e0 * t517 + 0.14025833333333333333333333333333333333333333333333e0 * t521 + 0.28051666666666666666666666666666666666666666666667e0 * t523 + 0.17365833333333333333333333333333333333333333333333e0 * t526) * t155 + 0.32163958997385070133512593798145426124210776856102e2 * t91 / t594 * t580 / t597 + t604 + t350 + t610 - t531 - t540 - 0.24415263074675393406472461472505321282722606644045e-3 * t4 * t516 * t115 - 0.10843581300301739842632067522386578331157260943710e-1 * t346 * t10 * t165 * t173 - 0.11696447245269292414524477327518106963944910680856e1 * t106 * t542 * t543 * t172 + 0.58482236226346462072622386637590534819724553404280e0 * t166 * t562 * t172 + 0.17315859105681463759666483083807725165579399831905e2 * t106 * t549 * t543 * t552
  t631 = t128 * t89 * t629
  t633 = t128 * t501 * t118
  t634 = t503 + t531 + t540 - t341 + t547 - t350 - t555 - t566 - t569 + t631 + t633
  t638 = 0.10843581300301739842632067522386578331157260943710e-1 * t89 * t4 * t11 * t189
  t640 = 0.8e1 * t69 * t177
  t643 = 0.12e2 * t64 * t68 * t119
  t646 = 0.32e2 * t65 * t124 * t119
  t651 = 0.20e2 * t122 / t67 / t66 * t119
  t652 = t359 - t352 - t354 + t638 - t610 + t356 + t640 - t604 + t643 - t646 + t651 + t345
  t659 = 0.1e1 / t301 / t203
  t660 = t194 * t659
  t661 = t259 ** 2
  t668 = -(t634 + t652) * t211 * t220 + 0.6e1 * t299 * t304 - 0.12e2 * t217 * t660 * t661 + 0.3e1 * t217 * t303 * t400
  t674 = t232 * t302
  t680 = t373 + 0.25948436345669141111111111111111111111111111111110e-1 * t376 - 0.55603792169291016666666666666666666666666666666666e-2 * t229 * t320 * t236 * t5 * t400 - 0.19772708495399885526666666666666666666666666666666e-2 * t412 + 0.11120758433858203333333333333333333333333333333333e-2 * t415 + t422 - t427 + 0.55603792169291016666666666666666666666666666666666e-3 * t434 - t441 - 0.98863542476999427633333333333333333333333333333332e-3 * t445 + t456 + 0.12974218172834570555555555555555555555555555555555e-1 * t460 + 0.11120758433858203333333333333333333333333333333333e-1 * t290 * t462 * t5 * t307 * t464 - 0.27801896084645508333333333333333333333333333333333e-2 * t290 * t291 * t292 * t469 * t222 + 0.55603792169291016666666666666666666666666666666666e-2 * t479 * t291 * t292 * t469 * t480 - 0.27801896084645508333333333333333333333333333333333e-2 * t290 * t291 * t292 * t668 * t222 + 0.16681137650787305000000000000000000000000000000000e-1 * t229 * t674 * t236 * t5 * t661
  t696 = t333 ** 2
  t698 = t247 ** 2
  t699 = 0.1e1 / t698
  t702 = -t341 + t345 - t350 - t352 - t354 + t356 + t359 + t196 * t218 * (-0.31250000000000000000000000000000000000000000000000e0 * t362 * t363 * t223 + 0.25000000000000000000000000000000000000000000000000e0 * t264 * t680 * t223 + 0.50000000000000000000000000000000000000000000000000e0 * t327 * t308 + 0.10000000000000000000000000000000000000000000000000e1 * t244 * t668 * t222 + 0.10000000000000000000000000000000000000000000000000e1 * t244 * t469 * t222) * t335 + t633 - t196 * t218 * t696 * t699 - t604 - t610 + t531 + t540
  t703 = t203 * t248
  t710 = t196 * t204
  t711 = t333 * t335
  t715 = 0.3e1 * t196 * t249 * t400 + 0.6e1 * t196 * t703 * t661 + 0.6e1 * t710 * t711 * t259 + t503 + t547 - t555 - t566 - t569 + t631 + t638 + t640 + t643 - t646 + t651
  d11 = t35 + t62 + t121 - t127 + 0.2e1 * t142 + t179 + 0.39503346997227602814966679236413104097888262435310e-1 * t180 - t186 - t191 + 0.6e1 * t261 + 0.2e1 * t337 + t7 * (t702 + t715)
  t719 = -t70 - t130
  t722 = f.my_piecewise3(t73, 0, 0.4e1 / 0.3e1 * t76 * t719)
  t723 = -t719
  t726 = f.my_piecewise3(t80, 0, 0.4e1 / 0.3e1 * t81 * t723)
  t728 = (t722 + t726) * t88
  t729 = t728 * t118
  t730 = t128 * t729
  t731 = t728 * t116
  t732 = 0.19751673498613801407483339618206552048944131217655e-1 * t731
  t735 = f.my_piecewise3(t73, 0, 0.2e1 / 0.3e1 * t250 * t719)
  t738 = f.my_piecewise3(t80, 0, 0.2e1 / 0.3e1 * t254 * t723)
  t740 = t735 / 0.2e1 + t738 / 0.2e1
  t742 = t196 * t249 * t740
  t745 = (t159 + t160 - t293 - t294 + t730 + t178 + t732 - t296 - t297) * t211
  t747 = t303 * t740
  t750 = 0.3e1 * t217 * t747 - t745 * t220
  t751 = t750 * t222
  t753 = t291 * t292 * t751
  t756 = t5 * t740
  t757 = t236 * t756
  t761 = -t275 + t284 - 0.27801896084645508333333333333333333333333333333333e-2 * t290 * t753 - t319 - 0.55603792169291016666666666666666666666666666666666e-2 * t229 * t320 * t757
  t762 = t264 * t761
  t765 = t244 * t750
  t768 = 0.25000000000000000000000000000000000000000000000000e0 * t762 * t223 + 0.10000000000000000000000000000000000000000000000000e1 * t765 * t222
  t771 = t196 * t218 * t768 * t335
  t773 = t728 * t1 * t184
  t774 = 0.18311447306006545054854346104378990962041954983034e-3 * t773
  t775 = 0.18311447306006545054854346104378990962041954983034e-3 * t340
  t776 = 0.4e1 * t351
  t777 = 0.4e1 * t355
  t790 = f.my_piecewise3(t73, 0, -0.2e1 / 0.9e1 * t378 * t719 * t131 + 0.4e1 / 0.3e1 * t250 * t63 * t382)
  t798 = f.my_piecewise3(t80, 0, -0.2e1 / 0.9e1 * t390 * t723 * t135 - 0.4e1 / 0.3e1 * t254 * t63 * t382)
  t800 = t790 / 0.2e1 + t798 / 0.2e1
  t806 = t5 * t750
  t811 = t272 * t236
  t820 = t459 * t753
  t825 = t233 * t750 * t222
  t827 = t429 * t430 * t825
  t829 = t456 + t373 + 0.12974218172834570555555555555555555555555555555555e-1 * t376 - 0.55603792169291016666666666666666666666666666666666e-2 * t229 * t320 * t236 * t5 * t800 + 0.55603792169291016666666666666666666666666666666666e-2 * t290 * t462 * t806 * t464 - 0.27801896084645508333333333333333333333333333333333e-2 * t290 * t811 * t806 * t308 + 0.55603792169291016666666666666666666666666666666666e-2 * t290 * t462 * t756 * t308 + 0.64871090864172852777777777777777777777777777777777e-2 * t820 + 0.27801896084645508333333333333333333333333333333333e-3 * t434 - t427 - 0.98863542476999427633333333333333333333333333333332e-3 * t412 + 0.27801896084645508333333333333333333333333333333333e-3 * t827
  t830 = t409 * t740
  t832 = t407 * t408 * t830
  t835 = t270 * t271 * t830
  t840 = t442 * t443 * t825
  t847 = t69 * t729
  t848 = 0.4e1 * t847
  t849 = t125 * t729
  t850 = 0.4e1 * t849
  t858 = f.my_piecewise3(t73, 0, 0.4e1 / 0.9e1 * t486 * t719 * t131 + 0.8e1 / 0.3e1 * t76 * t63 * t382)
  t866 = f.my_piecewise3(t80, 0, 0.4e1 / 0.9e1 * t493 * t723 * t135 - 0.8e1 / 0.3e1 * t81 * t63 * t382)
  t868 = (t858 + t866) * t88
  t870 = t128 * t868 * t118
  t872 = t128 * t728 * t176
  t873 = -t774 - t775 + t345 - t350 - t776 - t354 - t777 + t848 - t850 + t870 + t872 + t358 - t604
  t875 = 0.19751673498613801407483339618206552048944131217655e-1 * t868 * t116
  t877 = t728 * t106 * t189
  t878 = 0.58482236226346462072622386637590534819724553404280e0 * t877
  t879 = 0.58482236226346462072622386637590534819724553404280e0 * t568
  t880 = -t610 + t531 + t540 - t643 + t651 + t631 + t875 + t638 - t878 + t547 - t555 - t566 - t879
  t896 = -(t873 + t880) * t211 * t220 + 0.3e1 * t745 * t304 + 0.3e1 * t299 * t747 - 0.12e2 * t217 * t194 * t659 * t740 * t259 + 0.3e1 * t217 * t303 * t800
  t904 = t229 * t374 * t757
  t915 = -0.98863542476999427633333333333333333333333333333332e-3 * t832 + 0.55603792169291016666666666666666666666666666666666e-3 * t835 + t422 + 0.55603792169291016666666666666666666666666666666666e-3 * t415 - 0.49431771238499713816666666666666666666666666666666e-3 * t445 - 0.49431771238499713816666666666666666666666666666666e-3 * t840 - t441 + 0.55603792169291016666666666666666666666666666666666e-2 * t479 * t811 * t806 * t480 * t307 - 0.27801896084645508333333333333333333333333333333333e-2 * t290 * t291 * t292 * t896 * t222 + 0.64871090864172852777777777777777777777777777777777e-2 * t460 + 0.12974218172834570555555555555555555555555555555555e-1 * t904 + 0.16681137650787305000000000000000000000000000000000e-1 * t212 * t225 * t288 * t85 * t302 * t20 * t292 * t740 * t259
  t941 = -t774 - t775 + t345 - t350 - t776 - t354 - t777 + t196 * t218 * (-0.31250000000000000000000000000000000000000000000000e0 * t362 * t761 * t223 * t326 + 0.25000000000000000000000000000000000000000000000000e0 * t264 * (t829 + t915) * t223 + 0.25000000000000000000000000000000000000000000000000e0 * t762 * t308 + 0.25000000000000000000000000000000000000000000000000e0 * t327 * t751 + 0.10000000000000000000000000000000000000000000000000e1 * t244 * t896 * t222 + 0.10000000000000000000000000000000000000000000000000e1 * t765 * t308) * t335 + 0.6e1 * t196 * t203 * t248 * t740 * t259 + t848 - t850 + 0.3e1 * t196 * t249 * t800 + t870 + t872 + t358 - t604
  t942 = t768 * t335
  t953 = -t196 * t218 * t768 * t699 * t333 + 0.3e1 * t710 * t942 * t259 + 0.3e1 * t710 * t711 * t740 + t531 + t540 + t547 - t555 - t566 - t610 + t631 + t638 - t643 + t651 + t875 - t878 - t879
  d12 = t35 + t62 - t127 + t142 + t179 + t295 - t186 - t191 + 0.3e1 * t261 + t337 + t730 + t732 + 0.3e1 * t742 + t771 + t7 * (t941 + t953)
  t960 = 0.36622894612013090109708692208757981924083909966068e-3 * t773
  t961 = t719 ** 2
  t965 = 0.2e1 * t129 + 0.2e1 * t383
  t969 = f.my_piecewise3(t73, 0, 0.4e1 / 0.9e1 * t486 * t961 + 0.4e1 / 0.3e1 * t76 * t965)
  t970 = t723 ** 2
  t973 = -t965
  t977 = f.my_piecewise3(t80, 0, 0.4e1 / 0.9e1 * t493 * t970 + 0.4e1 / 0.3e1 * t81 * t973)
  t979 = (t969 + t977) * t88
  t981 = 0.19751673498613801407483339618206552048944131217655e-1 * t979 * t116
  t985 = 0.8e1 * t847
  t986 = 0.8e1 * t849
  t987 = 0.2e1 * t872
  t989 = t128 * t979 * t118
  t990 = 0.6e1 * t710 * t942 * t740 + t345 - t350 - t354 + t531 + t540 - t604 - t610 - t960 + t981 - t985 - t986 + t987 + t989
  t991 = t761 ** 2
  t1001 = f.my_piecewise3(t73, 0, -0.2e1 / 0.9e1 * t378 * t961 + 0.2e1 / 0.3e1 * t250 * t965)
  t1007 = f.my_piecewise3(t80, 0, -0.2e1 / 0.9e1 * t390 * t970 + 0.2e1 / 0.3e1 * t254 * t973)
  t1009 = t1001 / 0.2e1 + t1007 / 0.2e1
  t1019 = t750 ** 2
  t1036 = -t960 + t547 - t350 + t989 + t987 + t643 - t986 - t354 - t985 - t640 - t610
  t1037 = 0.11696447245269292414524477327518106963944910680856e1 * t877
  t1038 = t981 - t555 - t1037 - t566 + t531 + t540 + t638 + t651 + t646 - t604 + t631 + t345
  t1044 = t740 ** 2
  t1051 = -(t1036 + t1038) * t211 * t220 + 0.6e1 * t745 * t747 - 0.12e2 * t217 * t660 * t1044 + 0.3e1 * t217 * t303 * t1009
  t1062 = t373 + 0.25948436345669141111111111111111111111111111111110e-1 * t904 - 0.55603792169291016666666666666666666666666666666666e-2 * t229 * t320 * t236 * t5 * t1009 - t441 - 0.98863542476999427633333333333333333333333333333332e-3 * t840 + 0.55603792169291016666666666666666666666666666666666e-3 * t827 - t427 - 0.19772708495399885526666666666666666666666666666666e-2 * t832 + t422 + 0.11120758433858203333333333333333333333333333333333e-2 * t835 + 0.55603792169291016666666666666666666666666666666666e-2 * t479 * t291 * t292 * t1019 * t480 + 0.12974218172834570555555555555555555555555555555555e-1 * t820 + 0.11120758433858203333333333333333333333333333333333e-1 * t290 * t462 * t806 * t222 * t740 - 0.27801896084645508333333333333333333333333333333333e-2 * t290 * t291 * t292 * t1019 * t222 - 0.27801896084645508333333333333333333333333333333333e-2 * t290 * t291 * t292 * t1051 * t222 + 0.16681137650787305000000000000000000000000000000000e-1 * t229 * t674 * t236 * t5 * t1044 + t456
  t1084 = t768 ** 2
  t1088 = t196 * t218 * (-0.31250000000000000000000000000000000000000000000000e0 * t362 * t991 * t223 + 0.25000000000000000000000000000000000000000000000000e0 * t264 * t1062 * t223 + 0.50000000000000000000000000000000000000000000000000e0 * t762 * t751 + 0.10000000000000000000000000000000000000000000000000e1 * t244 * t1051 * t222 + 0.10000000000000000000000000000000000000000000000000e1 * t244 * t1019 * t222) * t335 - t640 + t643 + t646 + t651 + t631 + t638 - t1037 + 0.3e1 * t196 * t249 * t1009 + 0.6e1 * t196 * t703 * t1044 - t196 * t218 * t1084 * t699 + t547 - t555 - t566
  d22 = t35 + t62 - t121 - t127 + 0.2e1 * t730 + t179 + 0.39503346997227602814966679236413104097888262435310e-1 * t731 - t186 - t191 + 0.6e1 * t742 + 0.2e1 * t771 + t7 * (t990 + t1088)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = 0.1e1 + t4
  t6 = t5 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t8 = t7 * f.p.zeta_threshold
  t9 = t5 ** (0.1e1 / 0.3e1)
  t10 = t9 * t5
  t11 = f.my_piecewise3(t6, t8, t10)
  t12 = 0.1e1 - t4
  t13 = t12 <= f.p.zeta_threshold
  t14 = t12 ** (0.1e1 / 0.3e1)
  t15 = t14 * t12
  t16 = f.my_piecewise3(t13, t8, t15)
  t18 = 2 ** (0.1e1 / 0.3e1)
  t21 = 0.1e1 / (0.2e1 * t18 - 0.2e1)
  t22 = (t11 + t16 - 0.2e1) * t21
  t23 = 3 ** (0.1e1 / 0.3e1)
  t24 = 0.1e1 / jnp.pi
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t23 * t25
  t27 = t22 * t26
  t28 = 4 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = t2 ** (0.1e1 / 0.3e1)
  t32 = 0.1e1 / t30 / t2
  t33 = t29 * t32
  t36 = t26 * t29 / t30
  t37 = jnp.sqrt(t36)
  t40 = t36 ** 0.15e1
  t42 = t23 ** 2
  t43 = t25 ** 2
  t44 = t42 * t43
  t45 = t30 ** 2
  t48 = t44 * t28 / t45
  t50 = 0.51785000000000000000000000000000000000000000000000e1 * t37 + 0.90577500000000000000000000000000000000000000000000e0 * t36 + 0.11003250000000000000000000000000000000000000000000e0 * t40 + 0.12417750000000000000000000000000000000000000000000e0 * t48
  t51 = t50 ** 2
  t52 = 0.1e1 / t51
  t54 = 0.1e1 / t37 * t23
  t55 = t25 * t29
  t56 = t55 * t32
  t57 = t54 * t56
  t59 = t26 * t33
  t61 = t36 ** 0.5e0
  t62 = t61 * t23
  t63 = t62 * t56
  t68 = t44 * t28 / t45 / t2
  t70 = -0.86308333333333333333333333333333333333333333333334e0 * t57 - 0.30192500000000000000000000000000000000000000000000e0 * t59 - 0.55016250000000000000000000000000000000000000000000e-1 * t63 - 0.82785000000000000000000000000000000000000000000000e-1 * t68
  t74 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t50
  t75 = 0.1e1 / t74
  t76 = t52 * t70 * t75
  t77 = t33 * t76
  t78 = t27 * t77
  t81 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t36
  t86 = 0.37978500000000000000000000000000000000000000000000e1 * t37 + 0.89690000000000000000000000000000000000000000000000e0 * t36 + 0.20477500000000000000000000000000000000000000000000e0 * t40 + 0.12323500000000000000000000000000000000000000000000e0 * t48
  t87 = t86 ** 2
  t89 = 0.1e1 / t87 / t86
  t90 = t81 * t89
  t95 = -0.63297500000000000000000000000000000000000000000000e0 * t57 - 0.29896666666666666666666666666666666666666666666667e0 * t59 - 0.10238750000000000000000000000000000000000000000000e0 * t63 - 0.82156666666666666666666666666666666666666666666667e-1 * t68
  t96 = t95 ** 2
  t99 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t86
  t100 = 0.1e1 / t99
  t101 = t96 * t100
  t102 = t90 * t101
  t104 = jnp.log(0.2e1)
  t105 = 0.1e1 - t104
  t106 = jnp.pi ** 2
  t108 = t105 / t106
  t109 = t7 ** 2
  t110 = t9 ** 2
  t111 = f.my_piecewise3(t6, t109, t110)
  t112 = t14 ** 2
  t113 = f.my_piecewise3(t13, t109, t112)
  t115 = t111 / 0.2e1 + t113 / 0.2e1
  t116 = t115 ** 2
  t117 = t116 * t115
  t119 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e-1 * t36
  t121 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t36
  t122 = 0.1e1 / t121
  t124 = 0.1e1 / t105
  t125 = t119 * t122 * t124
  t126 = jnp.log(t99)
  t128 = 0.621814e-1 * t81 * t126
  t129 = t1 ** 2
  t130 = t129 ** 2
  t131 = t2 ** 2
  t132 = t131 ** 2
  t133 = 0.1e1 / t132
  t134 = t130 * t133
  t136 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t36
  t141 = 0.70594500000000000000000000000000000000000000000000e1 * t37 + 0.15494250000000000000000000000000000000000000000000e1 * t36 + 0.42077500000000000000000000000000000000000000000000e0 * t40 + 0.15629250000000000000000000000000000000000000000000e0 * t48
  t144 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t141
  t145 = jnp.log(t144)
  t149 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t36
  t150 = jnp.log(t74)
  t151 = t149 * t150
  t153 = -0.3109070e-1 * t136 * t145 + t128 - 0.19751673498613801407483339618206552048944131217655e-1 * t151
  t154 = t22 * t153
  t159 = (-t128 + t134 * t154 + 0.19751673498613801407483339618206552048944131217655e-1 * t22 * t151) * t124
  t160 = 0.1e1 / t117
  t161 = t106 * t160
  t163 = jnp.exp(-t159 * t161)
  t164 = t163 - 0.1e1
  t165 = 0.1e1 / t164
  t166 = t106 * t165
  t168 = s0 + 0.2e1 * s1 + s2
  t169 = t166 * t168
  t170 = t125 * t169
  t172 = 0.1e1 / t30 / t131
  t173 = t172 * t18
  t174 = 0.1e1 / t116
  t176 = 0.1e1 / t25
  t177 = t42 * t176
  t178 = t177 * t28
  t182 = 0.1e1 + 0.27801896084645508333333333333333333333333333333333e-2 * t170 * t173 * t174 * t178
  t183 = t182 ** 2
  t184 = t182 ** (0.1e1 / 0.4e1)
  t186 = 0.1e1 / t184 / t183
  t187 = t131 * t2
  t189 = 0.1e1 / t45 / t187
  t190 = t189 * t122
  t191 = t124 * t106
  t192 = t190 * t191
  t193 = t165 * t168
  t194 = t18 * t174
  t195 = t193 * t194
  t198 = t121 ** 2
  t199 = 0.1e1 / t198
  t200 = t119 * t199
  t201 = t200 * t191
  t202 = t189 * t18
  t207 = t164 ** 2
  t208 = 0.1e1 / t207
  t209 = t106 * t208
  t210 = t168 * t172
  t212 = t125 * t209 * t210
  t213 = t194 * t42
  t214 = t176 * t28
  t217 = 0.11073470983333333333333333333333333333333333333333e-2 * t26 * t33 * t126
  t218 = 0.1e1 / t87
  t219 = t81 * t218
  t220 = t95 * t100
  t222 = 0.10000000000000000000000000000000000000000000000000e1 * t219 * t220
  t223 = t129 * t1
  t224 = t223 * t133
  t227 = t132 * t2
  t228 = 0.1e1 / t227
  t229 = t130 * t228
  t232 = 0.1e1 / t131
  t234 = -t1 * t232 + t3
  t237 = f.my_piecewise3(t6, 0, 0.4e1 / 0.3e1 * t9 * t234)
  t238 = -t234
  t241 = f.my_piecewise3(t13, 0, 0.4e1 / 0.3e1 * t14 * t238)
  t243 = (t237 + t241) * t21
  t244 = t243 * t153
  t249 = t141 ** 2
  t250 = 0.1e1 / t249
  t251 = t136 * t250
  t256 = -0.11765750000000000000000000000000000000000000000000e1 * t57 - 0.51647500000000000000000000000000000000000000000000e0 * t59 - 0.21038750000000000000000000000000000000000000000000e0 * t63 - 0.10419500000000000000000000000000000000000000000000e0 * t68
  t257 = 0.1e1 / t144
  t258 = t256 * t257
  t264 = t149 * t52
  t265 = t70 * t75
  t268 = 0.53237641966666666666666666666666666666666666666666e-3 * t26 * t33 * t145 + 0.10000000000000000000000000000000000000000000000000e1 * t251 * t258 - t217 - t222 + 0.18311447306006545054854346104378990962041954983034e-3 * t26 * t33 * t150 + 0.58482236226346462072622386637590534819724553404280e0 * t264 * t265
  t269 = t22 * t268
  t273 = t22 * t23
  t275 = t55 * t32 * t150
  t278 = t22 * t149
  t282 = (t217 + t222 + 0.4e1 * t224 * t154 - 0.4e1 * t229 * t154 + t134 * t244 + t134 * t269 + 0.19751673498613801407483339618206552048944131217655e-1 * t243 * t151 - 0.18311447306006545054854346104378990962041954983034e-3 * t273 * t275 - 0.58482236226346462072622386637590534819724553404280e0 * t278 * t76) * t124
  t284 = t116 ** 2
  t285 = 0.1e1 / t284
  t286 = t106 * t285
  t287 = 0.1e1 / t9
  t290 = f.my_piecewise3(t6, 0, 0.2e1 / 0.3e1 * t287 * t234)
  t291 = 0.1e1 / t14
  t294 = f.my_piecewise3(t13, 0, 0.2e1 / 0.3e1 * t291 * t238)
  t296 = t290 / 0.2e1 + t294 / 0.2e1
  t297 = t286 * t296
  t300 = 0.3e1 * t159 * t297 - t282 * t161
  t301 = t300 * t163
  t303 = t213 * t214 * t301
  t307 = 0.1e1 / t30 / t187
  t308 = t307 * t18
  t313 = t173 * t160
  t315 = t177 * t28 * t296
  t319 = -0.27801896084645508333333333333333333333333333333333e-3 * t192 * t195 + 0.49431771238499713816666666666666666666666666666666e-3 * t201 * t193 * t202 * t174 - 0.27801896084645508333333333333333333333333333333333e-2 * t212 * t303 - 0.64871090864172852777777777777777777777777777777777e-2 * t170 * t308 * t174 * t178 - 0.55603792169291016666666666666666666666666666666666e-2 * t170 * t313 * t315
  t320 = t319 ** 2
  t321 = t186 * t320
  t325 = 0.1e1 / t184 / t182
  t327 = 0.1e1 / t30 / t132
  t328 = t327 * t18
  t333 = t308 * t160
  t337 = 0.1e1 / t10
  t338 = t234 ** 2
  t341 = 0.1e1 / t187
  t344 = 0.2e1 * t1 * t341 - 0.2e1 * t232
  t348 = f.my_piecewise3(t6, 0, -0.2e1 / 0.9e1 * t337 * t338 + 0.2e1 / 0.3e1 * t287 * t344)
  t349 = 0.1e1 / t15
  t350 = t238 ** 2
  t353 = -t344
  t357 = f.my_piecewise3(t13, 0, -0.2e1 / 0.9e1 * t349 * t350 + 0.2e1 / 0.3e1 * t291 * t353)
  t359 = t348 / 0.2e1 + t357 / 0.2e1
  t360 = t28 * t359
  t361 = t177 * t360
  t365 = t191 * t165
  t366 = t200 * t365
  t367 = t168 * t189
  t368 = t18 * t160
  t369 = t368 * t296
  t373 = t193 * t369
  t377 = 0.1e1 / t45 / t132
  t378 = t377 * t122
  t379 = t378 * t191
  t387 = t191 * t208
  t388 = t190 * t387
  t389 = t168 * t18
  t391 = t174 * t300 * t163
  t392 = t389 * t391
  t395 = t228 * t199
  t397 = t389 * t174
  t398 = t26 * t29
  t399 = t397 * t398
  t402 = t200 * t387
  t403 = t367 * t18
  t408 = 0.1e1 / t198 / t121
  t410 = t119 * t408 * t124
  t411 = t410 * t169
  t412 = t228 * t18
  t417 = t168 * t307
  t419 = t125 * t209 * t417
  t422 = t368 * t177
  t423 = t28 * t300
  t424 = t163 * t296
  t426 = t422 * t423 * t424
  t429 = t300 ** 2
  t430 = t429 * t163
  t432 = t213 * t214 * t430
  t436 = 0.1e1 / t207 / t164
  t437 = t106 * t436
  t439 = t125 * t437 * t210
  t440 = t163 ** 2
  t443 = t213 * t214 * t429 * t440
  t446 = 0.1e1 / t110
  t452 = f.my_piecewise3(t6, 0, 0.4e1 / 0.9e1 * t446 * t338 + 0.4e1 / 0.3e1 * t9 * t344)
  t453 = 0.1e1 / t112
  t459 = f.my_piecewise3(t13, 0, 0.4e1 / 0.9e1 * t453 * t350 + 0.4e1 / 0.3e1 * t14 * t353)
  t461 = (t452 + t459) * t21
  t462 = t461 * t151
  t466 = 0.1e1 / t37 / t36 * t42
  t467 = t43 * t28
  t469 = 0.1e1 / t45 / t131
  t470 = t467 * t469
  t471 = t466 * t470
  t473 = t55 * t172
  t474 = t54 * t473
  t476 = t29 * t172
  t477 = t26 * t476
  t479 = t36 ** (-0.5e0)
  t480 = t479 * t42
  t481 = t480 * t470
  t483 = t62 * t473
  t486 = t44 * t28 * t469
  t488 = -0.42198333333333333333333333333333333333333333333333e0 * t471 + 0.84396666666666666666666666666666666666666666666666e0 * t474 + 0.39862222222222222222222222222222222222222222222223e0 * t477 + 0.68258333333333333333333333333333333333333333333333e-1 * t481 + 0.13651666666666666666666666666666666666666666666667e0 * t483 + 0.13692777777777777777777777777777777777777777777778e0 * t486
  t489 = t488 * t100
  t490 = t219 * t489
  t491 = 0.10000000000000000000000000000000000000000000000000e1 * t490
  t492 = t87 ** 2
  t493 = 0.1e1 / t492
  t494 = t81 * t493
  t495 = t99 ** 2
  t496 = 0.1e1 / t495
  t497 = t96 * t496
  t498 = t494 * t497
  t499 = 0.16081979498692535066756296899072713062105388428051e2 * t498
  t500 = t243 * t23
  t501 = t500 * t275
  t504 = 0.1e1 / t51 / t50
  t505 = t70 ** 2
  t507 = t504 * t505 * t75
  t508 = t278 * t507
  t510 = t32 * t218
  t512 = t398 * t510 * t220
  t513 = 0.35616666666666666666666666666666666666666666666666e-1 * t512
  t514 = t51 ** 2
  t515 = 0.1e1 / t514
  t517 = t74 ** 2
  t518 = 0.1e1 / t517
  t519 = t515 * t505 * t518
  t520 = t278 * t519
  t522 = t243 * t149
  t523 = t522 * t76
  t531 = -0.57538888888888888888888888888888888888888888888889e0 * t471 + 0.11507777777777777777777777777777777777777777777778e1 * t474 + 0.40256666666666666666666666666666666666666666666667e0 * t477 + 0.36677500000000000000000000000000000000000000000000e-1 * t481 + 0.73355000000000000000000000000000000000000000000000e-1 * t483 + 0.13797500000000000000000000000000000000000000000000e0 * t486
  t533 = t52 * t531 * t75
  t534 = t278 * t533
  t539 = t32 * t250
  t544 = 0.1e1 / t249 / t141
  t545 = t136 * t544
  t546 = t256 ** 2
  t547 = t546 * t257
  t556 = -0.78438333333333333333333333333333333333333333333333e0 * t471 + 0.15687666666666666666666666666666666666666666666667e1 * t474 + 0.68863333333333333333333333333333333333333333333333e0 * t477 + 0.14025833333333333333333333333333333333333333333333e0 * t481 + 0.28051666666666666666666666666666666666666666666667e0 * t483 + 0.17365833333333333333333333333333333333333333333333e0 * t486
  t557 = t556 * t257
  t560 = t249 ** 2
  t561 = 0.1e1 / t560
  t562 = t136 * t561
  t563 = t144 ** 2
  t564 = 0.1e1 / t563
  t565 = t546 * t564
  t569 = t26 * t476 * t126
  t570 = 0.14764627977777777777777777777777777777777777777777e-2 * t569
  t571 = 0.20000000000000000000000000000000000000000000000000e1 * t102
  t575 = t32 * t52
  t579 = t149 * t504
  t580 = t505 * t75
  t583 = t531 * t75
  t586 = t149 * t515
  t587 = t505 * t518
  t590 = -0.70983522622222222222222222222222222222222222222221e-3 * t26 * t476 * t145 - 0.34246666666666666666666666666666666666666666666666e-1 * t398 * t539 * t258 - 0.20000000000000000000000000000000000000000000000000e1 * t545 * t547 + 0.10000000000000000000000000000000000000000000000000e1 * t251 * t557 + 0.32163958997385070133512593798145426124210776856102e2 * t562 * t565 + t570 + t513 + t571 - t491 - t499 - 0.24415263074675393406472461472505321282722606644045e-3 * t26 * t476 * t150 - 0.10843581300301739842632067522386578331157260943710e-1 * t398 * t575 * t265 - 0.11696447245269292414524477327518106963944910680856e1 * t579 * t580 + 0.58482236226346462072622386637590534819724553404280e0 * t264 * t583 + 0.17315859105681463759666483083807725165579399831905e2 * t586 * t587
  t591 = t22 * t590
  t592 = t134 * t591
  t593 = t461 * t153
  t594 = t134 * t593
  t595 = 0.19751673498613801407483339618206552048944131217655e-1 * t462 + t491 + t499 - 0.36622894612013090109708692208757981924083909966068e-3 * t501 + 0.11696447245269292414524477327518106963944910680856e1 * t508 - t513 - 0.17315859105681463759666483083807725165579399831905e2 * t520 - 0.11696447245269292414524477327518106963944910680856e1 * t523 - 0.58482236226346462072622386637590534819724553404280e0 * t534 + t592 + t594
  t596 = t243 * t268
  t597 = t134 * t596
  t599 = t229 * t244
  t601 = t229 * t269
  t604 = t224 * t244
  t606 = t224 * t269
  t608 = t129 * t133
  t609 = t608 * t154
  t611 = t223 * t228
  t612 = t611 * t154
  t614 = t132 * t131
  t615 = 0.1e1 / t614
  t616 = t130 * t615
  t617 = t616 * t154
  t620 = t55 * t172 * t150
  t621 = t273 * t620
  t623 = 0.2e1 * t597 - 0.8e1 * t599 - 0.8e1 * t601 + 0.10843581300301739842632067522386578331157260943710e-1 * t78 - t571 + 0.8e1 * t604 + 0.8e1 * t606 - t570 + 0.12e2 * t609 - 0.32e2 * t612 + 0.20e2 * t617 + 0.24415263074675393406472461472505321282722606644045e-3 * t621
  t625 = (t595 + t623) * t124
  t630 = 0.1e1 / t284 / t115
  t632 = t296 ** 2
  t633 = t106 * t630 * t632
  t636 = t286 * t359
  t639 = -0.12e2 * t159 * t633 + 0.3e1 * t159 * t636 - t625 * t161 + 0.6e1 * t282 * t297
  t640 = t639 * t163
  t642 = t213 * t214 * t640
  t647 = t177 * t28 * t632
  t651 = 0.21623696954724284259259259259259259259259259259259e-1 * t170 * t328 * t174 * t178 + 0.25948436345669141111111111111111111111111111111110e-1 * t170 * t333 * t315 - 0.55603792169291016666666666666666666666666666666666e-2 * t170 * t313 * t361 - 0.19772708495399885526666666666666666666666666666666e-2 * t366 * t367 * t369 + 0.11120758433858203333333333333333333333333333333333e-2 * t192 * t373 + 0.16681137650787305000000000000000000000000000000000e-2 * t379 * t195 - 0.29659062743099828290000000000000000000000000000000e-2 * t201 * t193 * t377 * t18 * t174 + 0.55603792169291016666666666666666666666666666666666e-3 * t388 * t392 - 0.82386285397499523027777777777777777777777777777777e-5 * t395 * t365 * t399 - 0.98863542476999427633333333333333333333333333333332e-3 * t402 * t403 * t391 + 0.14648281543675415194338888888888888888888888888889e-4 * t411 * t412 * t174 * t398 + 0.12974218172834570555555555555555555555555555555555e-1 * t419 * t303 + 0.11120758433858203333333333333333333333333333333333e-1 * t212 * t426 - 0.27801896084645508333333333333333333333333333333333e-2 * t212 * t432 + 0.55603792169291016666666666666666666666666666666666e-2 * t439 * t443 - 0.27801896084645508333333333333333333333333333333333e-2 * t212 * t642 + 0.16681137650787305000000000000000000000000000000000e-1 * t170 * t173 * t285 * t647
  t652 = t325 * t651
  t655 = t325 * t319
  t659 = 0.1e1 - 0.1e1 / t184
  t660 = t659 * t639
  t666 = -0.31250000000000000000000000000000000000000000000000e0 * t321 * t164 + 0.25000000000000000000000000000000000000000000000000e0 * t652 * t164 + 0.50000000000000000000000000000000000000000000000000e0 * t655 * t301 + 0.10000000000000000000000000000000000000000000000000e1 * t660 * t163 + 0.10000000000000000000000000000000000000000000000000e1 * t659 * t429 * t163
  t670 = 0.1e1 + 0.10000000000000000000000000000000000000000000000000e1 * t659 * t164
  t671 = 0.1e1 / t670
  t675 = jnp.log(t670)
  t684 = t116 * t675
  t696 = 0.25000000000000000000000000000000000000000000000000e0 * t655 * t164 + 0.10000000000000000000000000000000000000000000000000e1 * t659 * t300 * t163
  t697 = t696 ** 2
  t699 = t670 ** 2
  t700 = 0.1e1 / t699
  t706 = 0.32530743900905219527896202567159734993471782831130e-1 * t27 * t33 * t507
  t709 = 0.32530743900905219527896202567159734993471782831130e-1 * t243 * t26 * t77
  t712 = 0.16265371950452609763948101283579867496735891415565e-1 * t27 * t33 * t533
  t715 = 0.48159733137676571081572406076840235616767705782485e0 * t27 * t33 * t519
  t718 = 0.21687162600603479685264135044773156662314521887420e-1 * t27 * t476 * t76
  t719 = t632 * t296
  t724 = 0.24e2 * t224 * t596
  t726 = 0.60e2 * t616 * t269
  t729 = 0.144e3 * t129 * t228 * t154
  t732 = 0.240e3 * t223 * t615 * t154
  t737 = 0.120e3 * t130 / t132 / t187 * t154
  t739 = 0.60e2 * t616 * t244
  t740 = t108 * t116
  t741 = t696 * t671
  t758 = t395 * t124
  t759 = t209 * t168
  t764 = t194 * t300 * t163 * t23 * t55
  t784 = t5 ** 2
  t787 = t338 * t234
  t793 = t1 * t133
  t795 = 0.6e1 * t341 - 0.6e1 * t793
  t799 = f.my_piecewise3(t6, 0, 0.8e1 / 0.27e2 / t9 / t784 * t787 - 0.2e1 / 0.3e1 * t337 * t234 * t344 + 0.2e1 / 0.3e1 * t287 * t795)
  t800 = t12 ** 2
  t803 = t350 * t238
  t809 = -t795
  t813 = f.my_piecewise3(t13, 0, 0.8e1 / 0.27e2 / t14 / t800 * t803 - 0.2e1 / 0.3e1 * t349 * t238 * t353 + 0.2e1 / 0.3e1 * t291 * t809)
  t815 = t799 / 0.2e1 + t813 / 0.2e1
  t828 = 0.1e1 / t45 / t227
  t833 = t194 * t177
  t850 = 0.24715885619249856908333333333333333333333333333334e-4 * t758 * t759 * t764 - 0.12974218172834570555555555555555555555555555555555e0 * t170 * t328 * t160 * t315 + 0.38922654518503711666666666666666666666666666666665e-1 * t170 * t333 * t361 - 0.66724550603149220000000000000000000000000000000000e-1 * t170 * t173 * t630 * t177 * t28 * t719 - 0.11676796355551113500000000000000000000000000000000e0 * t170 * t308 * t285 * t647 - 0.55603792169291016666666666666666666666666666666666e-2 * t170 * t313 * t177 * t28 * t815 - 0.87889689262052491166033333333333333333333333333333e-4 * t411 * t412 * t160 * t296 * t23 * t55 - 0.99469005991731707592592592592592592592592592592592e-2 * t828 * t122 * t191 * t195 - 0.83405688253936524999999999999999999999999999999999e-2 * t212 * t833 * t423 * t640 + 0.16681137650787305000000000000000000000000000000000e-1 * t439 * t833 * t423 * t440 * t639 + 0.16681137650787305000000000000000000000000000000000e-1 * t212 * t422 * t28 * t639 * t424 - 0.77845309037007423333333333333333333333333333333330e-1 * t419 * t426
  t855 = t28 * t429
  t861 = t18 * t285
  t872 = t429 * t300
  t878 = t207 ** 2
  t909 = 0.3e1 * t134 * t243 * t590
  t910 = -t706 + t709 + t712 + t715 - t718 + t724 + t726 - t729 + t732 - t737 + t739 + t909
  t912 = t518 * t531
  t915 = 0.51947577317044391278999449251423175496738199495715e2 * t278 * t515 * t70 * t912
  t919 = 0.35089341735807877243573431982554320891834732042568e1 * t278 * t504 * t70 * t583
  t921 = 0.73245789224026180219417384417515963848167819932136e-3 * t500 * t620
  t924 = 0.54934341918019635164563038313136972886125864949102e-3 * t461 * t23 * t275
  t928 = 0.56968947174242584615102410102512416326352748836105e-3 * t273 * t55 * t307 * t150
  t932 = 0.71233333333333333333333333333333333333333333333331e-1 * t398 * t172 * t218 * t220
  t936 = 0.10685000000000000000000000000000000000000000000000e0 * t398 * t32 * t89 * t101
  t939 = 0.53424999999999999999999999999999999999999999999999e-1 * t398 * t510 * t489
  t943 = 0.85917975471764868594145516183295969534298037676861e0 * t398 * t32 * t493 * t497
  t954 = f.my_piecewise3(t6, 0, -0.8e1 / 0.27e2 / t110 / t5 * t787 + 0.4e1 / 0.3e1 * t446 * t234 * t344 + 0.4e1 / 0.3e1 * t9 * t795)
  t965 = f.my_piecewise3(t13, 0, -0.8e1 / 0.27e2 / t112 / t12 * t803 + 0.4e1 / 0.3e1 * t453 * t238 * t353 + 0.4e1 / 0.3e1 * t14 * t809)
  t967 = (t954 + t965) * t21
  t969 = 0.19751673498613801407483339618206552048944131217655e-1 * t967 * t151
  t973 = t96 * t95
  t978 = 0.51726012919273400298984252201052768390886626637712e3 * t81 / t492 / t87 * t973 / t495 / t99
  t983 = 0.1e1 / t37 / t48 * t24 * t133 / 0.4e1
  t985 = t467 * t189
  t986 = t466 * t985
  t988 = t55 * t307
  t989 = t54 * t988
  t991 = t29 * t307
  t992 = t26 * t991
  t994 = t36 ** (-0.15e1)
  t996 = t994 * t24 * t133
  t998 = t480 * t985
  t1000 = t62 * t988
  t1003 = t44 * t28 * t189
  t1008 = 0.10000000000000000000000000000000000000000000000000e1 * t219 * (-0.25319000000000000000000000000000000000000000000000e1 * t983 + 0.16879333333333333333333333333333333333333333333333e1 * t986 - 0.19692555555555555555555555555555555555555555555555e1 * t989 - 0.93011851851851851851851851851851851851851851851854e0 * t992 + 0.13651666666666666666666666666666666666666666666667e0 * t996 - 0.27303333333333333333333333333333333333333333333333e0 * t998 - 0.31853888888888888888888888888888888888888888888890e0 * t1000 - 0.36514074074074074074074074074074074074074074074075e0 * t1003) * t100
  t1014 = 0.96491876992155210400537781394436278372632330568306e2 * t81 / t492 / t86 * t973 * t496
  t1015 = -t915 + t919 + t921 - t924 - t928 + t932 + t936 - t939 - t943 + t969 + t978 + t1008 - t1014
  t1019 = 0.34450798614814814814814814814814814814814814814813e-2 * t26 * t991 * t126
  t1023 = 0.48245938496077605200268890697218139186316165284153e2 * t494 * t488 * t496 * t95
  t1057 = t546 * t256
  t1062 = 0.1e1 / t514 / t51
  t1064 = t505 * t70
  t1066 = 0.1e1 / t517 / t74
  t1070 = -0.16522625736956710527585419434107305400007076070979e1 * t398 * t32 * t561 * t565 + 0.10274000000000000000000000000000000000000000000000e0 * t398 * t32 * t544 * t547 + 0.32530743900905219527896202567159734993471782831130e-1 * t398 * t32 * t504 * t580 - t932 - t936 + 0.21687162600603479685264135044773156662314521887420e-1 * t398 * t172 * t52 * t265 - 0.16265371950452609763948101283579867496735891415565e-1 * t398 * t575 * t583 - 0.48159733137676571081572406076840235616767705782485e0 * t398 * t32 * t515 * t587 + t939 + t943 + 0.68493333333333333333333333333333333333333333333332e-1 * t398 * t172 * t250 * t258 - 0.51369999999999999999999999999999999999999999999999e-1 * t398 * t539 * t557 - t978 - t1008 - 0.19298375398431042080107556278887255674526466113661e3 * t136 / t560 / t141 * t1057 * t564 + 0.10254018858216406658218194626490193680059335835414e4 * t149 * t1062 * t1064 * t1066
  t1072 = 0.1e1 / t514 / t50
  t1100 = -0.34523333333333333333333333333333333333333333333333e1 * t983 + 0.23015555555555555555555555555555555555555555555556e1 * t986 - 0.26851481481481481481481481481481481481481481481482e1 * t989 - 0.93932222222222222222222222222222222222222222222223e0 * t992 + 0.73355000000000000000000000000000000000000000000000e-1 * t996 - 0.14671000000000000000000000000000000000000000000000e0 * t998 - 0.17116166666666666666666666666666666666666666666667e0 * t1000 - 0.36793333333333333333333333333333333333333333333333e0 * t1003
  t1125 = 0.60000000000000000000000000000000000000000000000000e1 * t90 * t220 * t488
  t1128 = 0.60000000000000000000000000000000000000000000000000e1 * t494 * t973 * t100
  t1140 = t1014 - 0.10389515463408878255799889850284635099347639899143e3 * t149 * t1072 * t1064 * t518 + 0.60000000000000000000000000000000000000000000000000e1 * t562 * t1057 * t257 + 0.10000000000000000000000000000000000000000000000000e1 * t251 * (-0.47063000000000000000000000000000000000000000000000e1 * t983 + 0.31375333333333333333333333333333333333333333333334e1 * t986 - 0.36604555555555555555555555555555555555555555555556e1 * t989 - 0.16068111111111111111111111111111111111111111111111e1 * t992 + 0.28051666666666666666666666666666666666666666666666e0 * t996 - 0.56103333333333333333333333333333333333333333333332e0 * t998 - 0.65453888888888888888888888888888888888888888888890e0 * t1000 - 0.46308888888888888888888888888888888888888888888888e0 * t1003) * t257 + 0.58482236226346462072622386637590534819724553404280e0 * t264 * t1100 * t75 + 0.96491876992155210400537781394436278372632330568306e2 * t562 * t556 * t564 * t256 - 0.60000000000000000000000000000000000000000000000000e1 * t545 * t258 * t556 - t1019 + 0.16562821945185185185185185185185185185185185185185e-2 * t26 * t991 * t145 - 0.35089341735807877243573431982554320891834732042568e1 * t579 * t265 * t531 + 0.51947577317044391278999449251423175496738199495715e2 * t586 * t912 * t70 + 0.56968947174242584615102410102512416326352748836105e-3 * t26 * t991 * t150 - t1023 + t1125 - t1128 + 0.20690405167709360119593700880421107356354650655085e4 * t136 / t560 / t249 * t1057 / t563 / t144 + 0.35089341735807877243573431982554320891834732042568e1 * t586 * t1064 * t75
  t1143 = t134 * t22 * (t1070 + t1140)
  t1145 = 0.12e2 * t229 * t591
  t1149 = 0.35089341735807877243573431982554320891834732042568e1 * t278 * t515 * t1064 * t75
  t1153 = 0.58482236226346462072622386637590534819724553404280e0 * t278 * t52 * t1100 * t75
  t1155 = 0.17544670867903938621786715991277160445917366021284e1 * t522 * t533
  t1159 = 0.10254018858216406658218194626490193680059335835414e4 * t278 * t1062 * t1064 * t1066
  t1162 = 0.17544670867903938621786715991277160445917366021284e1 * t461 * t149 * t76
  t1164 = 0.51947577317044391278999449251423175496738199495715e2 * t522 * t519
  t1168 = 0.10389515463408878255799889850284635099347639899143e3 * t278 * t1072 * t1064 * t518
  t1169 = t1019 + t1023 + t1143 - t1145 - t1125 - t1149 - t1153 - t1155 - t1159 - t1162 - t1164 + t1168
  t1171 = 0.35089341735807877243573431982554320891834732042568e1 * t522 * t507
  t1173 = 0.12e2 * t224 * t591
  t1175 = 0.36e2 * t608 * t269
  t1177 = 0.12e2 * t229 * t593
  t1179 = 0.24e2 * t793 * t154
  t1182 = 0.3e1 * t134 * t461 * t268
  t1184 = 0.12e2 * t224 * t593
  t1186 = 0.96e2 * t611 * t244
  t1188 = 0.36e2 * t608 * t244
  t1190 = t134 * t967 * t153
  t1192 = 0.24e2 * t229 * t596
  t1194 = 0.96e2 * t611 * t269
  t1195 = t1171 + t1173 + t1175 - t1177 + t1179 + t1182 + t1184 - t1186 + t1188 + t1190 - t1192 - t1194 + t1128
  t1220 = -(t910 + t1015 + t1169 + t1195) * t124 * t161 + 0.9e1 * t625 * t297 - 0.36e2 * t282 * t633 + 0.9e1 * t282 * t636 + 0.60e2 * t159 * t106 / t284 / t116 * t719 - 0.36e2 * t159 * t106 * t630 * t296 * t359 + 0.3e1 * t159 * t286 * t815
  t1226 = 0.16681137650787305000000000000000000000000000000000e-1 * t212 * t422 * t360 * t301 - 0.33362275301574609999999999999999999999999999999999e-1 * t439 * t422 * t855 * t440 * t296 - 0.50043412952361914999999999999999999999999999999999e-1 * t212 * t861 * t177 * t423 * t163 * t632 + 0.16681137650787305000000000000000000000000000000000e-1 * t212 * t422 * t855 * t424 + 0.16681137650787305000000000000000000000000000000000e-1 * t439 * t213 * t214 * t872 * t440 - 0.16681137650787305000000000000000000000000000000000e-1 * t125 * t106 / t878 * t210 * t213 * t214 * t872 * t440 * t163 - 0.38922654518503711666666666666666666666666666666665e-1 * t125 * t437 * t417 * t443 - 0.27801896084645508333333333333333333333333333333333e-2 * t212 * t213 * t214 * t872 * t163 + 0.19461327259251855833333333333333333333333333333333e-1 * t419 * t432 - 0.43944844631026245583016666666666666666666666666667e-4 * t410 * t209 * t168 * t228 * t764 + 0.19461327259251855833333333333333333333333333333333e-1 * t419 * t642 - 0.27801896084645508333333333333333333333333333333333e-2 * t212 * t213 * t214 * t1220 * t163
  t1241 = t191 * t436
  t1243 = t174 * t429
  t1244 = t1243 * t440
  t1248 = t1243 * t163
  t1253 = 0.1e1 / t30 / t614
  t1256 = t44 * t28
  t1261 = t174 * t639 * t163
  t1267 = t296 * t300 * t163
  t1275 = t168 * t377
  t1287 = t368 * t359
  t1291 = -0.64871090864172852777777777777777777777777777777776e-1 * t125 * t209 * t168 * t327 * t303 + 0.50043412952361915000000000000000000000000000000000e-1 * t125 * t166 * t210 * t861 * t42 * t214 * t359 * t296 + 0.29659062743099828289999999999999999999999999999999e-2 * t200 * t1241 * t403 * t1244 - 0.14829531371549914145000000000000000000000000000000e-2 * t402 * t403 * t1248 - 0.14648281543675415194338888888888888888888888888889e-5 * t1253 * t408 * t365 * t397 * t1256 - 0.14829531371549914145000000000000000000000000000000e-2 * t402 * t403 * t1261 - 0.33362275301574609999999999999999999999999999999999e-2 * t388 * t389 * t160 * t1267 + 0.90624913937249475330555555555555555555555555555555e-4 * t615 * t199 * t365 * t399 + 0.88977188229299484869999999999999999999999999999999e-2 * t402 * t1275 * t18 * t391 + 0.17685589265329897609962962962962962962962962962963e-1 * t201 * t193 * t828 * t18 * t174 - 0.10008682590472383000000000000000000000000000000000e-1 * t379 * t373 + 0.16681137650787305000000000000000000000000000000000e-2 * t192 * t193 * t1287
  t1292 = t861 * t632
  t1340 = t198 ** 2
  t1350 = -0.50043412952361914999999999999999999999999999999999e-2 * t192 * t193 * t1292 + 0.83405688253936524999999999999999999999999999999999e-3 * t388 * t389 * t1248 + 0.88977188229299484869999999999999999999999999999998e-2 * t366 * t367 * t1292 + 0.83405688253936524999999999999999999999999999999999e-3 * t388 * t389 * t1261 + 0.17795437645859896974000000000000000000000000000000e-1 * t366 * t1275 * t369 - 0.29659062743099828289999999999999999999999999999999e-2 * t366 * t367 * t1287 - 0.50043412952361914999999999999999999999999999999999e-2 * t378 * t387 * t392 - 0.16681137650787305000000000000000000000000000000000e-2 * t190 * t1241 * t389 * t1244 - 0.93702686803805231790123456790123456790123456790122e-1 * t170 / t30 / t227 * t18 * t174 * t178 + 0.49431771238499713816666666666666666666666666666665e-4 * t398 * t758 * t169 * t369 + 0.59318125486199656579999999999999999999999999999998e-2 * t200 * t124 * t759 * t202 * t160 * t1267 - 0.16113109698042956713772777777777777777777777777778e-3 * t411 * t615 * t18 * t174 * t398 + 0.26044644584654888215534544444444444444444444444445e-5 * t119 / t1340 * t124 * t169 * t1253 * t18 * t174 * t1256
  t1374 = -t706 + t709 + t712 + t715 - t718 + 0.6e1 * t108 * t719 * t675 + t724 + t726 - t729 + t732 - t737 + t739 + 0.9e1 * t740 * t741 * t359 + t108 * t117 * (0.70312500000000000000000000000000000000000000000000e0 / t184 / t183 / t182 * t320 * t319 * t164 - 0.93750000000000000000000000000000000000000000000000e0 * t186 * t319 * t164 * t651 - 0.93750000000000000000000000000000000000000000000000e0 * t321 * t301 + 0.25000000000000000000000000000000000000000000000000e0 * t325 * (t850 + t1226 + t1291 + t1350) * t164 + 0.75000000000000000000000000000000000000000000000000e0 * t652 * t301 + 0.75000000000000000000000000000000000000000000000000e0 * t655 * t640 + 0.75000000000000000000000000000000000000000000000000e0 * t655 * t430 + 0.10000000000000000000000000000000000000000000000000e1 * t659 * t1220 * t163 + 0.30000000000000000000000000000000000000000000000000e1 * t660 * t301 + 0.10000000000000000000000000000000000000000000000000e1 * t659 * t872 * t163) * t671 + t909
  t1379 = t108 * t115
  t1390 = 0.18e2 * t1379 * t675 * t296 * t359 + 0.9e1 * t740 * t666 * t671 * t296 + 0.3e1 * t108 * t684 * t815 + 0.18e2 * t1379 * t741 * t632 - t915 + t919 + t921 - t924 - t928 + t932 + t936 - t939 - t943 + t969 + t978
  t1392 = t1008 - t1014 + t1019 + t1023 + t1143 - t1145 - t1125 - t1149 - t1153 - t1155 - t1159 - t1162 - t1164 + t1168 + t1171
  t1409 = -0.9e1 * t740 * t697 * t700 * t296 + t1173 + t1175 - t1177 + t1179 + t1182 + t1184 - t1186 + t1188 + t1190 - t1192 - t1194 - 0.3e1 * t108 * t117 * t696 * t700 * t666 + 0.2e1 * t108 * t117 * t697 * t696 / t699 / t670 + t1128
  t1413 = 0.32530743900905219527896202567159734993471782831130e-1 * t78 - 0.60000000000000000000000000000000000000000000000000e1 * t102 + 0.3e1 * t108 * t117 * t666 * t671 + 0.18e2 * t108 * t115 * t675 * t632 + 0.3e1 * t594 + 0.60e2 * t617 - 0.44293883933333333333333333333333333333333333333332e-2 * t569 + 0.3e1 * t592 + 0.9e1 * t108 * t684 * t359 - 0.10986868383603927032912607662627394577225172989820e-2 * t501 - 0.10685000000000000000000000000000000000000000000000e0 * t512 + 0.73245789224026180219417384417515963848167819932136e-3 * t621 - 0.3e1 * t108 * t117 * t697 * t700 + t2 * (t1374 + t1390 + t1392 + t1409)
  t1431 = 0.59255020495841404222450018854619656146832393652965e-1 * t462 + 0.35089341735807877243573431982554320891834732042568e1 * t508 - 0.51947577317044391278999449251423175496738199495715e2 * t520 - 0.35089341735807877243573431982554320891834732042568e1 * t523 - 0.17544670867903938621786715991277160445917366021284e1 * t534 + 0.6e1 * t597 - 0.24e2 * t599 + 0.30000000000000000000000000000000000000000000000000e1 * t490 + 0.48245938496077605200268890697218139186316165284153e2 * t498 + 0.24e2 * t604 + 0.24e2 * t606 + 0.36e2 * t609 - 0.96e2 * t612 - 0.24e2 * t601 + 0.18e2 * t740 * t741 * t296
  d111 = t1413 + t1431

  res = {'v3rho3': d111}
  return res
