"""Generated from gga_c_tca.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  AA = -0.655868

  BB = 4.88827

  CC = 3.177037

  DD = 0.897889

  phi = lambda z: 1 / 2 * (f.opz_pow_n(z, 2 / 3) + f.opz_pow_n(-z, 2 / 3))

  msigma = 1.43

  malpha = 2.3

  f_rc04 = lambda rs, zeta: phi(zeta) ** 3 * (AA * jnp.arctan(BB + CC * rs) + DD) / rs

  Bs = lambda s: 1 / (1 + msigma * s ** malpha)

  f_tcs = lambda rs, z, xt: f_rc04(rs, z) * Bs(X2S * 2 ** (1 / 3) * xt)

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_tcs(rs, z, xt)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  AA = -0.655868

  BB = 4.88827

  CC = 3.177037

  DD = 0.897889

  phi = lambda z: 1 / 2 * (f.opz_pow_n(z, 2 / 3) + f.opz_pow_n(-z, 2 / 3))

  msigma = 1.43

  malpha = 2.3

  f_rc04 = lambda rs, zeta: phi(zeta) ** 3 * (AA * jnp.arctan(BB + CC * rs) + DD) / rs

  Bs = lambda s: 1 / (1 + msigma * s ** malpha)

  f_tcs = lambda rs, z, xt: f_rc04(rs, z) * Bs(X2S * 2 ** (1 / 3) * xt)

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_tcs(rs, z, xt)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  AA = -0.655868

  BB = 4.88827

  CC = 3.177037

  DD = 0.897889

  phi = lambda z: 1 / 2 * (f.opz_pow_n(z, 2 / 3) + f.opz_pow_n(-z, 2 / 3))

  msigma = 1.43

  malpha = 2.3

  f_rc04 = lambda rs, zeta: phi(zeta) ** 3 * (AA * jnp.arctan(BB + CC * rs) + DD) / rs

  Bs = lambda s: 1 / (1 + msigma * s ** malpha)

  f_tcs = lambda rs, z, xt: f_rc04(rs, z) * Bs(X2S * 2 ** (1 / 3) * xt)

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_tcs(rs, z, xt)

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = 0.1e1 + t4
  t6 = t5 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = t5 ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t11 = f.my_piecewise3(t6, t8, t10)
  t12 = 0.1e1 - t4
  t13 = t12 <= f.p.zeta_threshold
  t14 = t12 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t16 = f.my_piecewise3(t13, t8, t15)
  t18 = t11 / 0.2e1 + t16 / 0.2e1
  t19 = t18 ** 2
  t20 = t19 * t18
  t21 = 3 ** (0.1e1 / 0.3e1)
  t23 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t25 = 4 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = t2 ** (0.1e1 / 0.3e1)
  t32 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t21 * t23 * t26 / t27
  t33 = jnp.arctan(t32)
  t35 = -0.655868e0 * t33 + 0.897889e0
  t36 = t20 * t35
  t37 = t21 ** 2
  t39 = 0.1e1 / t23
  t40 = t39 * t25
  t41 = 6 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t43 = jnp.pi ** 2
  t44 = t43 ** (0.1e1 / 0.3e1)
  t45 = 0.1e1 / t44
  t47 = 2 ** (0.1e1 / 0.3e1)
  t50 = jnp.sqrt(s0 + 0.2e1 * s1 + s2)
  t52 = t27 * t2
  t55 = t42 * t45 * t47 * t50 / t52
  t56 = t55 ** 0.230e1
  t58 = 0.1e1 + 0.47121507034422759993521593627179705180398847183874e-2 * t56
  t59 = 0.1e1 / t58
  t63 = 0.4e1 / 0.9e1 * t36 * t37 * t40 * t27 * t59
  t66 = t52 * t19 * t35 * t37
  t67 = 0.1e1 / t9
  t68 = t2 ** 2
  t70 = t1 / t68
  t71 = t3 - t70
  t74 = f.my_piecewise3(t6, 0, 0.2e1 / 0.3e1 * t67 * t71)
  t75 = 0.1e1 / t14
  t79 = f.my_piecewise3(t13, 0, -0.2e1 / 0.3e1 * t75 * t71)
  t85 = t32 ** 2
  t90 = 0.69457230103866666666666666666666666666666666666663e0 * t20 / (0.1e1 + t85) * t59
  t94 = t37 * t39 * t25
  t96 = t58 ** 2
  t98 = t55 ** 0.130e1
  t100 = 0.1e1 / t96 * t98 * t42
  t101 = t45 * t47
  t105 = 0.48168651635187710215599851263339254184407710454627e-2 * t3 * t20 * t35 * t94 * t100 * t101 * t50
  vrho_0_ = t63 + t66 * t40 * t59 * (t74 / 0.2e1 + t79 / 0.2e1) + t90 + t105
  t106 = -t3 - t70
  t109 = f.my_piecewise3(t6, 0, 0.2e1 / 0.3e1 * t67 * t106)
  t113 = f.my_piecewise3(t13, 0, -0.2e1 / 0.3e1 * t75 * t106)
  vrho_1_ = t63 + t66 * t40 * t59 * (t109 / 0.2e1 + t113 / 0.2e1) + t90 + t105
  t123 = t36 * t94 * t100 * t101 / t50
  vsigma_0_ = -0.18063244363195391330849944223752220319152891420485e-2 * t123
  vsigma_1_ = -0.36126488726390782661699888447504440638305782840970e-2 * t123
  vsigma_2_ = vsigma_0_
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  AA = -0.655868

  BB = 4.88827

  CC = 3.177037

  DD = 0.897889

  phi = lambda z: 1 / 2 * (f.opz_pow_n(z, 2 / 3) + f.opz_pow_n(-z, 2 / 3))

  msigma = 1.43

  malpha = 2.3

  f_rc04 = lambda rs, zeta: phi(zeta) ** 3 * (AA * jnp.arctan(BB + CC * rs) + DD) / rs

  Bs = lambda s: 1 / (1 + msigma * s ** malpha)

  f_tcs = lambda rs, z, xt: f_rc04(rs, z) * Bs(X2S * 2 ** (1 / 3) * xt)

  functional_body = lambda rs, z, xt, xs0=None, xs1=None: f_tcs(rs, z, xt)

  t2 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t3, 1)
  t5 = t4 ** 2
  t6 = t5 * t4
  t7 = 3 ** (0.1e1 / 0.3e1)
  t9 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t11 = 4 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t13 = r0 ** (0.1e1 / 0.3e1)
  t18 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t7 * t9 * t12 / t13
  t19 = jnp.arctan(t18)
  t21 = -0.655868e0 * t19 + 0.897889e0
  t22 = t6 * t21
  t23 = t7 ** 2
  t25 = 0.1e1 / t9
  t27 = 6 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t29 = jnp.pi ** 2
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = 0.1e1 / t30
  t33 = 2 ** (0.1e1 / 0.3e1)
  t34 = jnp.sqrt(s0)
  t39 = t28 * t31 * t33 * t34 / t13 / r0
  t40 = t39 ** 0.230e1
  t42 = 0.1e1 + 0.47121507034422759993521593627179705180398847183874e-2 * t40
  t43 = 0.1e1 / t42
  t48 = t18 ** 2
  t58 = t23 * t25 * t11
  t60 = t42 ** 2
  t62 = t39 ** 0.130e1
  t64 = 0.1e1 / t60 * t62 * t28
  t65 = t31 * t33
  vrho_0_ = 0.4e1 / 0.9e1 * t22 * t23 * t25 * t11 * t13 * t43 + 0.69457230103866666666666666666666666666666666666663e0 * t6 / (0.1e1 + t48) * t43 + 0.48168651635187710215599851263339254184407710454627e-2 / r0 * t6 * t21 * t58 * t64 * t65 * t34
  vsigma_0_ = -0.18063244363195391330849944223752220319152891420485e-2 * t22 * t58 * t64 * t65 / t34
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t5 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t6, 1)
  t8 = t7 ** 2
  t9 = t8 * t7
  t11 = 3 ** (0.1e1 / 0.3e1)
  t13 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t14 = t11 * t13
  t15 = 4 ** (0.1e1 / 0.3e1)
  t16 = t15 ** 2
  t21 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t14 * t16 / t1
  t22 = jnp.arctan(t21)
  t24 = -0.655868e0 * t22 + 0.897889e0
  t26 = t11 ** 2
  t27 = 0.1e1 / t13
  t28 = t26 * t27
  t29 = 6 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = jnp.pi ** 2
  t32 = t31 ** (0.1e1 / 0.3e1)
  t33 = 0.1e1 / t32
  t34 = t30 * t33
  t35 = 2 ** (0.1e1 / 0.3e1)
  t36 = jnp.sqrt(s0)
  t37 = t35 * t36
  t39 = 0.1e1 / t1 / r0
  t41 = t34 * t37 * t39
  t42 = t41 ** 0.230e1
  t44 = 0.1e1 + 0.47121507034422759993521593627179705180398847183874e-2 * t42
  t45 = 0.1e1 / t44
  t52 = t21 ** 2
  t53 = 0.1e1 + t52
  t54 = 0.1e1 / t53
  t58 = r0 ** 2
  t62 = t28 * t15
  t64 = t44 ** 2
  t65 = 0.1e1 / t64
  t66 = t41 ** 0.130e1
  t67 = t65 * t66
  t68 = t67 * t30
  t69 = t33 * t35
  t74 = t53 ** 2
  t86 = 0.1e1 / t1 / t58
  t96 = 0.1e1 / t1 / t58 / r0 * t9 * t24 * t62
  t98 = 0.1e1 / t64 / t44
  t99 = t41 ** 0.260e1
  t101 = t98 * t99 * t29
  t102 = t32 ** 2
  t103 = 0.1e1 / t102
  t104 = t35 ** 2
  t105 = t103 * t104
  t106 = t105 * s0
  t110 = t41 ** 0.30e0
  t112 = t65 * t110 * t29
  v2rho2_0_ = 0.4e1 / 0.27e2 / t2 * t9 * t24 * t28 * t15 * t45 + 0.92609640138488888888888888888888888888888888888884e0 / r0 * t9 * t54 * t45 + 0.16056217211729236738533283754446418061469236818208e-2 / t58 * t9 * t24 * t62 * t68 * t69 * t36 + 0.36778031659583040511111111111111111111111111111109e0 * t9 / t74 * t45 * t21 * t14 * t16 * t39 + 0.20073966722509356988758591749343098182802235760644e-1 * t9 * t54 * t67 * t34 * t37 * t86 + 0.83527884012674580090917586884936888612525308619053e-3 * t96 * t101 * t106 - 0.50095397700595218624223845313872824351784018872812e-1 * t96 * t112 * t106
  t125 = t9 * t24
  t126 = t125 * t62
  t127 = t105 * t86
  v2rhosigma_0_ = -0.37638687604705044353922359530018309092754192051208e-2 * t9 * t39 * t54 * t65 * t66 * t30 * t69 / t36 - 0.31322956504752967534094095081851333229696990732145e-3 * t126 * t101 * t127 + 0.18785774137723206984083941992702309131919007077304e-1 * t126 * t112 * t127
  t134 = t125 * t26
  t135 = t27 * t15
  t142 = t104 / s0 * t39
  v2sigma2_0_ = 0.11746108689282362825285285655694249961136371524554e-3 * t134 * t135 * t98 * t99 * t29 * t103 * t142 - 0.70446653016462026190314782472633659244696276539892e-2 * t134 * t135 * t65 * t110 * t29 * t103 * t142 + 0.90316221815976956654249721118761101595764457102425e-3 * t126 * t68 * t69 / t36 / s0
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t3, 1)
  t5 = t4 ** 2
  t6 = t5 * t4
  t7 = 3 ** (0.1e1 / 0.3e1)
  t9 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t11 = 4 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t13 = r0 ** (0.1e1 / 0.3e1)
  t18 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t7 * t9 * t12 / t13
  t19 = t18 ** 2
  t20 = 0.1e1 + t19
  t21 = 0.1e1 / t20
  t22 = t6 * t21
  t23 = 6 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = 0.1e1 / t26
  t28 = t24 * t27
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = jnp.sqrt(s0)
  t31 = t29 * t30
  t35 = t28 * t31 / t13 / r0
  t36 = t35 ** 0.230e1
  t38 = 0.1e1 + 0.47121507034422759993521593627179705180398847183874e-2 * t36
  t39 = t38 ** 2
  t41 = 0.1e1 / t39 / t38
  t42 = t35 ** 0.260e1
  t43 = t41 * t42
  t45 = t26 ** 2
  t46 = 0.1e1 / t45
  t48 = t29 ** 2
  t50 = r0 ** 2
  t51 = t50 ** 2
  t52 = t13 ** 2
  t56 = t23 * t46 * t48 * s0 / t52 / t51
  t59 = 0.1e1 / t39
  t60 = t35 ** 0.30e0
  t61 = t59 * t60
  t65 = t50 * r0
  t71 = t35 ** 0.130e1
  t74 = t27 * t29 * t30
  t82 = jnp.atan(t18)
  t84 = -0.655868e0 * t82 + 0.897889e0
  t85 = t7 ** 2
  t87 = 0.1e1 / t9
  t89 = 0.1e1 / t52 / t51 / r0 * t6 * t84 * t85 * t87
  t90 = t39 ** 2
  t93 = t35 ** 0.390e1
  t94 = 0.1e1 / t25
  t96 = t30 * s0
  t102 = t35 ** 0.160e1
  t109 = t35 ** (-0.70e0)
  t115 = t20 ** 2
  t116 = 0.1e1 / t115
  t117 = t6 * t116
  t119 = t18 * t7
  t132 = 0.1e1 / t38
  t140 = t85 * t87
  t159 = t9 ** 2
  t164 = t85 * t159 * t11 / t52 / t50
  t173 = t140 * t11
  t184 = 0.1e1 / t13 / t51 * t6 * t84 * t173
  t187 = t46 * t48 * s0
  v3rho3_0_ = 0.52214539139616816995802751158798165290639964649157e-2 * t22 * t43 * t56 - 0.31315388087114596902463403128975233165171487786605e0 * t22 * t61 * t56 - 0.30110950083764035483137887624014647274203353640966e-1 / t13 / t65 * t6 * t21 * t59 * t71 * t24 * t74 + 0.43452995905773577549468091358629944725893789807942e-3 * t89 * t11 / t90 * t93 * t94 * t96 - 0.52121399623908937976732574216200618494215792578289e-1 * t89 * t11 * t41 * t102 * t94 * t96 + 0.24045790896285704939627445750658955688856329058950e0 * t89 * t11 * t59 * t109 * t94 * t96 + 0.15943933753545239999873657513889437155348866673572e-1 * t117 * t59 * t119 * t9 * t12 / t52 / t65 * t71 * t28 * t31 - 0.61739760092325925925925925925925925925925925925923e0 / t50 * t6 * t21 * t132 - 0.8e1 / 0.81e2 / t52 / r0 * t6 * t84 * t140 * t11 * t132 - 0.1e-49 / t13 / t50 * t6 * t116 * t132 * t119 * t9 * t12 + 0.15579355649288896570173188148148148148148148148147e1 * t6 / t115 / t20 * t132 * t19 * t164 - 0.38948389123222241425432970370370370370370370370367e0 * t117 * t132 * t164 - 0.10704144807819491159022189169630945374312824545471e-2 / t65 * t6 * t84 * t173 * t59 * t71 * t24 * t74 - 0.25058365203802374027275276065481066583757592585716e-2 * t184 * t43 * t23 * t187 + 0.15028619310178565587267153594161847305535205661843e0 * t184 * t61 * t23 * t187

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** 2
  t2 = t1 * r0
  t3 = r0 ** (0.1e1 / 0.3e1)
  t4 = t3 ** 2
  t8 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t10 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t9, 1)
  t11 = t10 ** 2
  t12 = t11 * t10
  t13 = 0.1e1 / t4 / t2 * t12
  t14 = 3 ** (0.1e1 / 0.3e1)
  t15 = 0.1e1 / jnp.pi
  t16 = t15 ** (0.1e1 / 0.3e1)
  t18 = 4 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t24 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t14 * t16 * t19 / t3
  t25 = t24 ** 2
  t26 = 0.1e1 + t25
  t27 = t26 ** 2
  t29 = 0.1e1 / t27 / t26
  t30 = 6 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = jnp.pi ** 2
  t33 = t32 ** (0.1e1 / 0.3e1)
  t34 = 0.1e1 / t33
  t35 = t31 * t34
  t36 = 2 ** (0.1e1 / 0.3e1)
  t37 = jnp.sqrt(s0)
  t38 = t36 * t37
  t42 = t35 * t38 / t3 / r0
  t43 = t42 ** 0.230e1
  t45 = 0.1e1 + 0.47121507034422759993521593627179705180398847183874e-2 * t43
  t46 = 0.1e1 / t45
  t49 = t14 ** 2
  t50 = t25 * t49
  t51 = t16 ** 2
  t52 = t51 * t18
  t59 = 0.1e1 / t27
  t64 = t24 * t14 * t16 * t19
  t67 = t1 ** 2
  t68 = t67 * t1
  t72 = jnp.atan(t24)
  t74 = -0.655868e0 * t72 + 0.897889e0
  t76 = 0.1e1 / t16
  t78 = 0.1e1 / t4 / t68 * t12 * t74 * t49 * t76
  t79 = t45 ** 2
  t80 = 0.1e1 / t79
  t82 = t42 ** (-0.70e0)
  t83 = 0.1e1 / t32
  t84 = t82 * t83
  t85 = t37 * s0
  t90 = t79 ** 2
  t91 = 0.1e1 / t90
  t93 = t42 ** 0.390e1
  t94 = t93 * t83
  t100 = 0.1e1 / t79 / t45
  t102 = t42 ** 0.160e1
  t103 = t102 * t83
  t108 = 0.1e1 / t26
  t109 = t12 * t108
  t110 = t42 ** 0.260e1
  t111 = t100 * t110
  t113 = t33 ** 2
  t114 = 0.1e1 / t113
  t116 = t36 ** 2
  t117 = t116 * s0
  t118 = t67 * r0
  t122 = t30 * t114 * t117 / t4 / t118
  t125 = t42 ** 0.30e0
  t126 = t80 * t125
  t135 = t42 ** 0.130e1
  t137 = t34 * t36
  t138 = t137 * t37
  t142 = t67 ** 2
  t146 = t49 * t76
  t147 = t146 * t18
  t148 = 0.1e1 / t142 * t12 * t74 * t147
  t151 = t42 ** 0.520e1
  t154 = s0 ** 2
  t156 = t154 * t31 * t137
  t160 = t42 ** 0.290e1
  t166 = t42 ** 0.60e0
  t172 = t42 ** (-0.170e1)
  t178 = t12 * t29
  t182 = 0.1e1 / t118
  t189 = t12 * t59
  t196 = t117 / t68 * t64
  t199 = -0.41544948398103724187128501728395061728395061728392e1 * t13 * t29 * t46 * t50 * t52 - 0.32691583697407147120987654320987654320987654320984e0 / t3 / t2 * t12 * t59 * t46 * t64 - 0.20839685443447610947677119650571094930342151851090e1 * t78 * t18 * t80 * t84 * t85 - 0.37659263118337100542872345844145952095774617833550e-2 * t78 * t18 * t91 * t94 * t85 + 0.45171879674054412913168230987373869361653686901184e0 * t78 * t18 * t100 * t103 * t85 - 0.34809692759744544663868500772532110193759976432772e-1 * t109 * t111 * t122 + 0.20876925391409731268308935419316822110114325191070e1 * t109 * t126 * t122 + 0.89217629877819364394482629997080436368009936713973e-1 / t3 / t67 * t12 * t108 * t80 * t135 * t31 * t138 + 0.25116866667485343760775012216103398485399359246411e-4 * t148 / t90 / t45 * t151 * t83 * t156 - 0.45191115742004520651446815012975142514929541400259e-2 * t148 * t91 * t160 * t83 * t156 + 0.11814183914752692608059383489005473525355579651079e0 * t148 * t100 * t166 * t83 * t156 + 0.22442738169866657943652282700615025309599240455020e0 * t148 * t80 * t172 * t83 * t156 + 0.90052386596554859828406409327919565780832173031118e-1 * t178 * t80 * t50 * t51 * t18 * t182 * t135 * t35 * t38 + 0.55295840928170264472631395044431548886826307123020e-2 * t189 * t100 * t110 * t30 * t114 * t196
  t200 = t189 * t80
  t211 = t80 * t135 * t31
  t221 = t27 ** 2
  t227 = 0.1e1 / t67
  t247 = t85 / t67 / t2
  t282 = 0.1e1 / t3 / t118 * t12 * t74 * t147
  t285 = t114 * t116 * s0
  t293 = -0.33163382207374099199737207628890029283125642681030e0 * t200 * t125 * t30 * t114 * t196 - 0.74405024183211119999410401731484040058294711143336e-1 / t4 / t67 * t12 * t59 * t211 * t138 * t64 + 0.10289960015387654320987654320987654320987654320988e1 / t2 * t12 * t108 * t46 + 0.29697713600369908855567989092776888888888888888887e2 * t12 / t221 * t46 * t25 * t24 * t15 * t227 - 0.14848856800184954427783994546388444444444444444443e2 * t178 * t46 * t24 * t15 * t227 + 0.40e2 / 0.243e3 / t4 / t1 * t12 * t74 * t146 * t18 * t46 + 0.36217496823956298542271086247545499737960666077495e-2 * t109 * t91 * t94 * t247 - 0.43442496564161191740507888964120073521812450588099e0 * t109 * t100 * t103 * t247 + 0.20041848375753342017576578002544149225709752183427e1 * t109 * t80 * t84 * t247 + 0.10386237099525931046782125432098765432098765432098e1 * t13 * t59 * t46 * t49 * t52 - 0.22513096649138714957101602331979891445208043257780e-1 * t200 * t49 * t51 * t18 * t182 * t135 * t31 * t138 + 0.17840241346365818598370315282718242290521374242450e-2 * t227 * t12 * t74 * t147 * t211 * t138 + 0.10673007401619529678283913879741935767156011656879e-1 * t282 * t111 * t30 * t285 - 0.64010785950760557130952691234393053338390690781924e0 * t282 * t126 * t30 * t285
  v4rho4_0_ = t199 + t293

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 + r1
  t2 = t1 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t5 = r0 - r1
  t6 = 0.1e1 / t1
  t7 = t5 * t6
  t8 = 0.1e1 + t7
  t9 = t8 <= f.p.zeta_threshold
  t10 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t11 = t10 ** 2
  t12 = t8 ** (0.1e1 / 0.3e1)
  t13 = t12 ** 2
  t14 = f.my_piecewise3(t9, t11, t13)
  t15 = 0.1e1 - t7
  t16 = t15 <= f.p.zeta_threshold
  t17 = t15 ** (0.1e1 / 0.3e1)
  t18 = t17 ** 2
  t19 = f.my_piecewise3(t16, t11, t18)
  t21 = t14 / 0.2e1 + t19 / 0.2e1
  t22 = t21 ** 2
  t23 = t22 * t21
  t25 = 3 ** (0.1e1 / 0.3e1)
  t27 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t28 = t25 * t27
  t29 = 4 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t35 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t28 * t30 / t2
  t36 = jnp.arctan(t35)
  t38 = -0.655868e0 * t36 + 0.897889e0
  t40 = t25 ** 2
  t41 = 0.1e1 / t27
  t42 = t40 * t41
  t43 = 6 ** (0.1e1 / 0.3e1)
  t44 = t43 ** 2
  t45 = jnp.pi ** 2
  t46 = t45 ** (0.1e1 / 0.3e1)
  t47 = 0.1e1 / t46
  t48 = t44 * t47
  t49 = 2 ** (0.1e1 / 0.3e1)
  t51 = s0 + 0.2e1 * s1 + s2
  t52 = jnp.sqrt(t51)
  t53 = t49 * t52
  t54 = t2 * t1
  t55 = 0.1e1 / t54
  t57 = t48 * t53 * t55
  t58 = t57 ** 0.230e1
  t60 = 0.1e1 + 0.47121507034422759993521593627179705180398847183874e-2 * t58
  t61 = 0.1e1 / t60
  t65 = 0.4e1 / 0.27e2 / t3 * t23 * t38 * t42 * t29 * t61
  t67 = t38 * t40
  t68 = t2 * t22 * t67
  t69 = t41 * t29
  t70 = 0.1e1 / t12
  t71 = t1 ** 2
  t72 = 0.1e1 / t71
  t73 = t5 * t72
  t74 = t6 - t73
  t77 = f.my_piecewise3(t9, 0, 0.2e1 / 0.3e1 * t70 * t74)
  t78 = 0.1e1 / t17
  t79 = -t74
  t82 = f.my_piecewise3(t16, 0, 0.2e1 / 0.3e1 * t78 * t79)
  t84 = t77 / 0.2e1 + t82 / 0.2e1
  t85 = t61 * t84
  t87 = t68 * t69 * t85
  t90 = t35 ** 2
  t91 = 0.1e1 + t90
  t92 = 0.1e1 / t91
  t95 = 0.92609640138488888888888888888888888888888888888884e0 * t6 * t23 * t92 * t61
  t98 = t42 * t29
  t100 = t60 ** 2
  t101 = 0.1e1 / t100
  t102 = t57 ** 0.130e1
  t103 = t101 * t102
  t109 = 0.16056217211729236738533283754446418061469236818208e-2 * t72 * t23 * t38 * t98 * t103 * t44 * t47 * t49 * t52
  t111 = t54 * t21 * t67
  t112 = t84 ** 2
  t117 = t22 * t92
  t118 = t117 * t85
  t122 = t6 * t22 * t38 * t98
  t125 = t48 * t53
  t127 = t122 * t101 * t84 * t102 * t125
  t130 = t54 * t22 * t67
  t132 = 0.1e1 / t12 / t8
  t133 = t74 ** 2
  t136 = t71 * t1
  t137 = 0.1e1 / t136
  t138 = t5 * t137
  t140 = -0.2e1 * t72 + 0.2e1 * t138
  t144 = f.my_piecewise3(t9, 0, -0.2e1 / 0.9e1 * t132 * t133 + 0.2e1 / 0.3e1 * t70 * t140)
  t146 = 0.1e1 / t17 / t15
  t147 = t79 ** 2
  t154 = f.my_piecewise3(t16, 0, -0.2e1 / 0.9e1 * t146 * t147 - 0.2e1 / 0.3e1 * t78 * t140)
  t160 = t91 ** 2
  t168 = 0.36778031659583040511111111111111111111111111111109e0 * t23 / t160 * t61 * t35 * t28 * t30 * t55
  t176 = 0.20073966722509356988758591749343098182802235760644e-1 * t23 * t92 * t103 * t48 * t53 / t2 / t71
  t181 = 0.1e1 / t2 / t136 * t23 * t38 * t98
  t184 = t57 ** 0.260e1
  t187 = t46 ** 2
  t189 = t49 ** 2
  t191 = 0.1e1 / t187 * t189 * t51
  t194 = 0.83527884012674580090917586884936888612525308619053e-3 * t181 / t100 / t60 * t184 * t43 * t191
  t195 = t57 ** 0.30e0
  t200 = 0.50095397700595218624223845313872824351784018872812e-1 * t181 * t101 * t195 * t43 * t191
  d11 = t65 + 0.8e1 / 0.3e1 * t87 + t95 + t109 + 0.2e1 * t111 * t69 * t61 * t112 + 0.41674338062319999999999999999999999999999999999998e1 * t118 + 0.28901190981112626129359910758003552510644626272776e-1 * t127 + t130 * t69 * t61 * (t144 / 0.2e1 + t154 / 0.2e1) + t168 + t176 + t194 - t200
  t202 = -t6 - t73
  t205 = f.my_piecewise3(t9, 0, 0.2e1 / 0.3e1 * t70 * t202)
  t206 = -t202
  t209 = f.my_piecewise3(t16, 0, 0.2e1 / 0.3e1 * t78 * t206)
  t211 = t205 / 0.2e1 + t209 / 0.2e1
  t212 = t61 * t211
  t214 = t68 * t69 * t212
  t220 = t117 * t212
  t225 = t122 * t101 * t211 * t102 * t125
  t234 = f.my_piecewise3(t9, 0, -0.2e1 / 0.9e1 * t132 * t202 * t74 + 0.4e1 / 0.3e1 * t70 * t5 * t137)
  t242 = f.my_piecewise3(t16, 0, -0.2e1 / 0.9e1 * t146 * t206 * t79 - 0.4e1 / 0.3e1 * t78 * t5 * t137)
  d12 = t65 + 0.4e1 / 0.3e1 * t87 + t95 + t109 + 0.4e1 / 0.3e1 * t214 + 0.2e1 * t111 * t69 * t212 * t84 + 0.20837169031159999999999999999999999999999999999999e1 * t220 + 0.14450595490556313064679955379001776255322313136388e-1 * t225 + t130 * t69 * t61 * (t234 / 0.2e1 + t242 / 0.2e1) + 0.20837169031159999999999999999999999999999999999999e1 * t118 + t168 + t176 + 0.14450595490556313064679955379001776255322313136388e-1 * t127 + t194 - t200
  t251 = t211 ** 2
  t258 = t202 ** 2
  t262 = 0.2e1 * t72 + 0.2e1 * t138
  t266 = f.my_piecewise3(t9, 0, -0.2e1 / 0.9e1 * t132 * t258 + 0.2e1 / 0.3e1 * t70 * t262)
  t267 = t206 ** 2
  t274 = f.my_piecewise3(t16, 0, -0.2e1 / 0.9e1 * t146 * t267 - 0.2e1 / 0.3e1 * t78 * t262)
  d22 = t65 + 0.8e1 / 0.3e1 * t214 + t95 + t109 + 0.2e1 * t111 * t69 * t61 * t251 + 0.41674338062319999999999999999999999999999999999998e1 * t220 + 0.28901190981112626129359910758003552510644626272776e-1 * t225 + t130 * t69 * t61 * (t266 / 0.2e1 + t274 / 0.2e1) + t168 + t176 + t194 - t200
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 + r1
  t2 = t1 ** (0.1e1 / 0.3e1)
  t3 = t2 * t1
  t4 = r0 - r1
  t5 = 0.1e1 / t1
  t6 = t4 * t5
  t7 = 0.1e1 + t6
  t8 = t7 <= f.p.zeta_threshold
  t9 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t11 = t7 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t13 = f.my_piecewise3(t8, t10, t12)
  t14 = 0.1e1 - t6
  t15 = t14 <= f.p.zeta_threshold
  t16 = t14 ** (0.1e1 / 0.3e1)
  t17 = t16 ** 2
  t18 = f.my_piecewise3(t15, t10, t17)
  t20 = t13 / 0.2e1 + t18 / 0.2e1
  t21 = t20 ** 2
  t23 = 3 ** (0.1e1 / 0.3e1)
  t25 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t27 = 4 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t33 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t23 * t25 * t28 / t2
  t34 = jnp.atan(t33)
  t36 = -0.655868e0 * t34 + 0.897889e0
  t37 = t23 ** 2
  t38 = t36 * t37
  t40 = 0.1e1 / t25
  t41 = t40 * t27
  t42 = 6 ** (0.1e1 / 0.3e1)
  t43 = t42 ** 2
  t44 = jnp.pi ** 2
  t45 = t44 ** (0.1e1 / 0.3e1)
  t46 = 0.1e1 / t45
  t47 = t43 * t46
  t48 = 2 ** (0.1e1 / 0.3e1)
  t50 = s0 + 0.2e1 * s1 + s2
  t51 = jnp.sqrt(t50)
  t52 = t48 * t51
  t53 = 0.1e1 / t3
  t55 = t47 * t52 * t53
  t56 = t55 ** 0.230e1
  t58 = 0.1e1 + 0.47121507034422759993521593627179705180398847183874e-2 * t56
  t59 = 0.1e1 / t58
  t60 = t7 ** 2
  t63 = t1 ** 2
  t64 = 0.1e1 / t63
  t66 = -t4 * t64 + t5
  t67 = t66 ** 2
  t72 = 0.1e1 / t11 / t7
  t74 = t63 * t1
  t75 = 0.1e1 / t74
  t78 = 0.2e1 * t4 * t75 - 0.2e1 * t64
  t81 = 0.1e1 / t11
  t82 = t63 ** 2
  t86 = 0.6e1 * t75 - 0.6e1 * t4 / t82
  t90 = f.my_piecewise3(t8, 0, 0.8e1 / 0.27e2 / t11 / t60 * t67 * t66 - 0.2e1 / 0.3e1 * t72 * t66 * t78 + 0.2e1 / 0.3e1 * t81 * t86)
  t91 = t14 ** 2
  t94 = -t66
  t95 = t94 ** 2
  t100 = 0.1e1 / t16 / t14
  t102 = -t78
  t105 = 0.1e1 / t16
  t110 = f.my_piecewise3(t15, 0, 0.8e1 / 0.27e2 / t16 / t91 * t95 * t94 - 0.2e1 / 0.3e1 * t100 * t94 * t102 - 0.2e1 / 0.3e1 * t105 * t86)
  t116 = t21 * t20
  t117 = t33 ** 2
  t118 = 0.1e1 + t117
  t119 = t118 ** 2
  t125 = t25 ** 2
  t127 = t2 ** 2
  t131 = t37 * t125 * t27 / t127 / t63
  t138 = f.my_piecewise3(t8, 0, 0.2e1 / 0.3e1 * t81 * t66)
  t141 = f.my_piecewise3(t15, 0, 0.2e1 / 0.3e1 * t105 * t94)
  t143 = t138 / 0.2e1 + t141 / 0.2e1
  t144 = t143 ** 2
  t145 = t59 * t144
  t152 = t59 * t143
  t163 = f.my_piecewise3(t8, 0, -0.2e1 / 0.9e1 * t72 * t67 + 0.2e1 / 0.3e1 * t81 * t78)
  t169 = f.my_piecewise3(t15, 0, -0.2e1 / 0.9e1 * t100 * t95 + 0.2e1 / 0.3e1 * t105 * t102)
  t171 = t163 / 0.2e1 + t169 / 0.2e1
  t172 = t59 * t171
  t177 = 0.1e1 / t2 / t63
  t179 = 0.1e1 / t119
  t182 = t33 * t23
  t183 = t25 * t28
  t187 = t5 * t21
  t188 = 0.1e1 / t118
  t189 = t188 * t59
  t193 = t21 * t188
  t194 = t58 ** 2
  t195 = 0.1e1 / t194
  t196 = t195 * t143
  t197 = t55 ** 0.130e1
  t198 = t196 * t197
  t209 = 0.1e1 / t127 / t82 / t1 * t116 * t38 * t40
  t210 = t194 ** 2
  t213 = t55 ** 0.390e1
  t214 = 0.1e1 / t44
  t216 = t51 * t50
  t222 = 0.1e1 / t194 / t58
  t224 = t55 ** 0.160e1
  t231 = t55 ** (-0.70e0)
  t239 = t37 * t40
  t240 = t239 * t27
  t245 = t46 * t48 * t51
  t253 = 0.1e1 / t2 / t82 * t116 * t36 * t240
  t254 = t55 ** 0.260e1
  t255 = t222 * t254
  t257 = t45 ** 2
  t258 = 0.1e1 / t257
  t259 = t48 ** 2
  t261 = t258 * t259 * t50
  t265 = t55 ** 0.30e0
  t266 = t195 * t265
  t277 = t3 * t21 * t38 * t41 * t59 * (t90 / 0.2e1 + t110 / 0.2e1) + 0.15579355649288896570173188148148148148148148148147e1 * t116 / t119 / t118 * t59 * t117 * t131 + 0.8e1 * t2 * t20 * t38 * t41 * t145 + 0.4e1 / 0.3e1 / t127 * t21 * t38 * t41 * t152 + 0.4e1 * t2 * t21 * t38 * t41 * t172 - 0.1e-49 * t177 * t116 * t179 * t59 * t182 * t183 + 0.83348676124639999999999999999999999999999999999996e1 * t187 * t189 * t143 + 0.18066570050258421289882732574408788364522012184580e0 * t193 * t198 * t47 * t52 * t177 + 0.43452995905773577549468091358629944725893789807942e-3 * t209 * t27 / t210 * t213 * t214 * t216 - 0.52121399623908937976732574216200618494215792578289e-1 * t209 * t27 * t222 * t224 * t214 * t216 + 0.24045790896285704939627445750658955688856329058950e0 * t209 * t27 * t195 * t231 * t214 * t216 - 0.10704144807819491159022189169630945374312824545471e-2 * t75 * t116 * t36 * t240 * t195 * t197 * t43 * t245 - 0.25058365203802374027275276065481066583757592585716e-2 * t253 * t255 * t42 * t261 + 0.15028619310178565587267153594161847305535205661843e0 * t253 * t266 * t42 * t261 + 0.6e1 * t3 * t20 * t38 * t41 * t152 * t171
  t284 = t116 * t188
  t286 = t42 * t258
  t287 = t259 * t50
  t291 = t286 * t287 / t127 / t82
  t298 = 0.1e1 / t2 / t74
  t319 = t239 * t27 * t59
  t327 = t116 * t179
  t334 = t47 * t52
  t355 = t298 * t21 * t36 * t240
  t358 = t286 * t287
  t376 = 0.33100228493624736459999999999999999999999999999998e1 * t21 * t179 * t152 * t182 * t183 * t53 + 0.52214539139616816995802751158798165290639964649157e-2 * t284 * t255 * t291 - 0.31315388087114596902463403128975233165171487786605e0 * t284 * t266 * t291 - 0.30110950083764035483137887624014647274203353640966e-1 * t298 * t116 * t188 * t195 * t197 * t43 * t245 - 0.61739760092325925925925925925925925925925925925923e0 * t64 * t116 * t189 + 0.12502301418695999999999999999999999999999999999999e2 * t20 * t188 * t145 + 0.62511507093479999999999999999999999999999999999997e1 * t193 * t172 - 0.8e1 / 0.81e2 / t127 / t1 * t116 * t36 * t319 + 0.2e1 * t3 * t144 * t143 * t36 * t319 - 0.38948389123222241425432970370370370370370370370367e0 * t327 * t59 * t131 + 0.14450595490556313064679955379001776255322313136387e-1 * t64 * t21 * t36 * t240 * t198 * t334 + 0.86703572943337878388079732274010657531933878818328e-1 * t5 * t20 * t36 * t240 * t195 * t144 * t197 * t334 + 0.43351786471668939194039866137005328765966939409164e-1 * t187 * t36 * t240 * t195 * t171 * t197 * t334 + 0.75175095611407122081825828196443199751272777757148e-2 * t355 * t222 * t143 * t254 * t358 - 0.45085857930535696761801460782485541916605616985531e0 * t355 * t196 * t265 * t358 + 0.15943933753545239999873657513889437155348866673572e-1 * t327 * t195 * t182 * t25 * t28 / t127 / t74 * t197 * t334
  d111 = t277 + t376

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 - r1
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t4 = t1 * t3
  t5 = 0.1e1 + t4
  t6 = t5 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t8 = t7 ** 2
  t9 = t5 ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t11 = f.my_piecewise3(t6, t8, t10)
  t12 = 0.1e1 - t4
  t13 = t12 <= f.p.zeta_threshold
  t14 = t12 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t16 = f.my_piecewise3(t13, t8, t15)
  t18 = t11 / 0.2e1 + t16 / 0.2e1
  t19 = t18 ** 2
  t20 = t19 * t18
  t21 = 3 ** (0.1e1 / 0.3e1)
  t22 = 0.1e1 / jnp.pi
  t23 = t22 ** (0.1e1 / 0.3e1)
  t24 = t21 * t23
  t25 = 4 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = t2 ** (0.1e1 / 0.3e1)
  t32 = 0.4888270e1 + 0.79425925000000000000000000000000000000000000000000e0 * t24 * t26 / t27
  t33 = t32 ** 2
  t34 = 0.1e1 + t33
  t35 = t34 ** 2
  t36 = t35 ** 2
  t39 = 6 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t41 = jnp.pi ** 2
  t42 = t41 ** (0.1e1 / 0.3e1)
  t43 = 0.1e1 / t42
  t44 = t40 * t43
  t45 = 2 ** (0.1e1 / 0.3e1)
  t47 = s0 + 0.2e1 * s1 + s2
  t48 = jnp.sqrt(t47)
  t49 = t45 * t48
  t50 = t27 * t2
  t51 = 0.1e1 / t50
  t53 = t44 * t49 * t51
  t54 = t53 ** 0.230e1
  t56 = 0.1e1 + 0.47121507034422759993521593627179705180398847183874e-2 * t54
  t57 = 0.1e1 / t56
  t61 = t2 ** 2
  t62 = t61 ** 2
  t63 = 0.1e1 / t62
  t68 = 0.1e1 / t35 / t34
  t69 = t20 * t68
  t75 = 0.1e1 / t61
  t76 = t75 * t19
  t77 = 0.1e1 / t34
  t78 = t77 * t57
  t79 = 0.1e1 / t9
  t81 = -t1 * t75 + t3
  t84 = f.my_piecewise3(t6, 0, 0.2e1 / 0.3e1 * t79 * t81)
  t85 = 0.1e1 / t14
  t86 = -t81
  t89 = f.my_piecewise3(t13, 0, 0.2e1 / 0.3e1 * t85 * t86)
  t91 = t84 / 0.2e1 + t89 / 0.2e1
  t95 = t3 * t18
  t96 = t91 ** 2
  t100 = t18 * t77
  t101 = t57 * t91
  t103 = 0.1e1 / t9 / t5
  t104 = t81 ** 2
  t107 = t61 * t2
  t108 = 0.1e1 / t107
  t111 = 0.2e1 * t1 * t108 - 0.2e1 * t75
  t115 = f.my_piecewise3(t6, 0, -0.2e1 / 0.9e1 * t103 * t104 + 0.2e1 / 0.3e1 * t79 * t111)
  t117 = 0.1e1 / t14 / t12
  t118 = t86 ** 2
  t121 = -t111
  t125 = f.my_piecewise3(t13, 0, -0.2e1 / 0.9e1 * t117 * t118 + 0.2e1 / 0.3e1 * t85 * t121)
  t127 = t115 / 0.2e1 + t125 / 0.2e1
  t128 = t101 * t127
  t131 = t3 * t19
  t135 = 0.1e1 / t35
  t136 = t19 * t135
  t137 = t56 ** 2
  t138 = 0.1e1 / t137
  t140 = t53 ** 0.130e1
  t144 = t27 ** 2
  t146 = 0.1e1 / t144 / t107
  t148 = t32 * t21
  t149 = t23 * t26
  t150 = t148 * t149
  t154 = jnp.atan(t32)
  t156 = -0.655868e0 * t154 + 0.897889e0
  t158 = t21 ** 2
  t159 = 0.1e1 / t23
  t160 = t158 * t159
  t161 = t25 * t138
  t166 = t44 * t49
  t173 = t19 * t77
  t174 = t5 ** 2
  t176 = 0.1e1 / t9 / t174
  t180 = t103 * t81
  t185 = -0.6e1 * t1 * t63 + 0.6e1 * t108
  t189 = f.my_piecewise3(t6, 0, 0.8e1 / 0.27e2 * t176 * t104 * t81 - 0.2e1 / 0.3e1 * t180 * t111 + 0.2e1 / 0.3e1 * t79 * t185)
  t190 = t12 ** 2
  t192 = 0.1e1 / t14 / t190
  t196 = t117 * t86
  t199 = -t185
  t203 = f.my_piecewise3(t13, 0, 0.8e1 / 0.27e2 * t192 * t118 * t86 - 0.2e1 / 0.3e1 * t196 * t121 + 0.2e1 / 0.3e1 * t85 * t199)
  t205 = t189 / 0.2e1 + t203 / 0.2e1
  t206 = t57 * t205
  t209 = t96 * t91
  t213 = 0.1e1 / t144
  t215 = t156 * t158
  t217 = t159 * t25
  t218 = t57 * t96
  t231 = t57 * t127
  t232 = t217 * t231
  t236 = t50 * t18 * t215
  t237 = t127 ** 2
  t243 = t23 ** 2
  t244 = t158 * t243
  t246 = 0.1e1 / t144 / t61
  t252 = 0.1e1 / t27 / t107
  t254 = t135 * t57
  t258 = 0.29697713600369908855567989092776888888888888888887e2 * t20 / t36 * t57 * t33 * t32 * t22 * t63 - 0.14848856800184954427783994546388444444444444444443e2 * t69 * t57 * t32 * t22 * t63 - 0.74087712110791111111111111111111111111111111111105e1 * t76 * t78 * t91 + 0.33339470449855999999999999999999999999999999999998e2 * t95 * t78 * t96 + 0.50009205674783999999999999999999999999999999999996e2 * t100 * t128 + 0.16669735224927999999999999999999999999999999999999e2 * t131 * t78 * t127 + 0.19132720504254287999848389016667324586418640008287e0 * t136 * t138 * t91 * t140 * t44 * t49 * t146 * t150 + 0.34681429177335151355231892909604263012773551527332e0 * t95 * t156 * t160 * t161 * t91 * t127 * t140 * t166 + 0.10289960015387654320987654320987654320987654320988e1 * t108 * t20 * t78 + 0.83348676124639999999999999999999999999999999999996e1 * t173 * t206 + 0.16669735224927999999999999999999999999999999999999e2 * t209 * t77 * t57 + 0.16e2 / 0.3e1 * t213 * t18 * t215 * t217 * t218 - 0.32e2 / 0.27e2 / t144 / t2 * t19 * t215 * t217 * t101 + 0.12e2 * t50 * t96 * t215 * t232 + 0.6e1 * t236 * t217 * t57 * t237 - 0.46738066947866689710519564444444444444444444444440e1 * t136 * t101 * t244 * t25 * t246 - 0.32691583697407147120987654320987654320987654320984e0 * t252 * t20 * t254 * t150
  t268 = t146 * t20
  t271 = t33 * t158
  t272 = t243 * t25
  t281 = t104 ** 2
  t287 = t111 ** 2
  t292 = t62 * t2
  t293 = 0.1e1 / t292
  t296 = 0.24e2 * t1 * t293 - 0.24e2 * t63
  t300 = f.my_piecewise3(t6, 0, -0.56e2 / 0.81e2 / t9 / t174 / t5 * t281 + 0.16e2 / 0.9e1 * t176 * t104 * t111 - 0.2e1 / 0.3e1 * t103 * t287 - 0.8e1 / 0.9e1 * t180 * t185 + 0.2e1 / 0.3e1 * t79 * t296)
  t304 = t118 ** 2
  t310 = t121 ** 2
  t319 = f.my_piecewise3(t13, 0, -0.56e2 / 0.81e2 / t14 / t190 / t12 * t304 + 0.16e2 / 0.9e1 * t192 * t118 * t121 - 0.2e1 / 0.3e1 * t117 * t310 - 0.8e1 / 0.9e1 * t196 * t199 - 0.2e1 / 0.3e1 * t85 * t296)
  t326 = 0.1e1 / t144 / t292
  t328 = t215 * t159
  t329 = t326 * t19 * t328
  t331 = 0.1e1 / t137 / t56
  t332 = t25 * t331
  t333 = t53 ** 0.160e1
  t335 = 0.1e1 / t41
  t336 = t48 * t47
  t337 = t335 * t336
  t338 = t337 * t91
  t342 = t53 ** (-0.70e0)
  t347 = t137 ** 2
  t348 = 0.1e1 / t347
  t349 = t25 * t348
  t350 = t53 ** 0.390e1
  t355 = t62 * t61
  t359 = 0.1e1 / t144 / t355 * t20 * t328
  t365 = t252 * t19
  t366 = t77 * t138
  t370 = t43 * t45
  t371 = t370 * t48
  t372 = t140 * t40 * t371
  t375 = t138 * t127
  t376 = t375 * t140
  t379 = 0.1e1 / t27 / t61
  t381 = t44 * t49 * t379
  t385 = t53 ** 0.260e1
  t388 = t42 ** 2
  t389 = 0.1e1 / t388
  t390 = t39 * t389
  t391 = t45 ** 2
  t392 = t391 * t47
  t394 = 0.1e1 / t144 / t62
  t396 = t390 * t392 * t394
  t400 = t53 ** 0.30e0
  t410 = t138 * t96
  t411 = t410 * t140
  t422 = t160 * t25
  t425 = t138 * t140 * t40
  t426 = t425 * t371
  t429 = t20 * t135
  t430 = t429 * t138
  t442 = 0.1e1 / t27 / t292 * t20 * t156 * t422
  t444 = t331 * t385 * t39
  t445 = t389 * t391
  t446 = t445 * t47
  t450 = 0.8e1 / 0.3e1 * t213 * t19 * t215 * t232 + 0.16e2 / 0.3e1 * t27 * t19 * t215 * t217 * t206 - 0.41544948398103724187128501728395061728395061728392e1 * t268 * t68 * t57 * t271 * t272 + t50 * t19 * t215 * t217 * t57 * (t300 / 0.2e1 + t319 / 0.2e1) - 0.62545679548690725572079089059440742193058951093948e0 * t329 * t332 * t333 * t338 + 0.28854949075542845927552934900790746826627594870740e1 * t329 * t161 * t342 * t338 + 0.52143595086928293059361709630355933671072547769531e-2 * t329 * t349 * t350 * t338 - 0.20839685443447610947677119650571094930342151851090e1 * t359 * t161 * t342 * t335 * t336 - 0.36133140100516842579765465148817576729044024369160e0 * t365 * t366 * t91 * t372 + 0.36133140100516842579765465148817576729044024369160e0 * t173 * t376 * t381 + 0.62657446967540180394963301390557798348767957578988e-1 * t173 * t331 * t91 * t385 * t396 - 0.37578465704537516282956083754770279798205785343926e1 * t173 * t138 * t91 * t400 * t396 - 0.37659263118337100542872345844145952095774617833550e-2 * t359 * t349 * t350 * t335 * t336 + 0.72266280201033685159530930297635153458088048738319e0 * t100 * t411 * t381 + 0.45171879674054412913168230987373869361653686901184e0 * t359 * t332 * t333 * t335 * t336 + 0.11560476392445050451743964303201421004257850509110e0 * t3 * t209 * t156 * t422 * t426 - 0.22513096649138714957101602331979891445208043257780e-1 * t430 * t244 * t25 * t293 * t140 * t40 * t371 + 0.10673007401619529678283913879741935767156011656879e-1 * t442 * t444 * t446
  t453 = t138 * t400 * t39
  t470 = 0.1e1 / t27 / t62
  t475 = t326 * t20
  t478 = t385 * t39
  t483 = t400 * t39
  t493 = t148 * t149 * t51
  t514 = t160 * t25 * t57
  t524 = 0.1e1 / t62 / t107 * t20 * t77
  t542 = -0.64010785950760557130952691234393053338390690781924e0 * t442 * t453 * t446 + 0.17840241346365818598370315282718242290521374242450e-2 * t63 * t20 * t156 * t422 * t426 - 0.3e-49 * t379 * t19 * t254 * t91 * t32 * t24 * t26 + 0.89217629877819364394482629997080436368009936713974e-1 * t470 * t20 * t366 * t372 - 0.34809692759744544663868500772532110193759976432772e-1 * t475 * t77 * t331 * t478 * t446 + 0.20876925391409731268308935419316822110114325191070e1 * t475 * t366 * t483 * t446 + 0.8e1 * t236 * t217 * t101 * t205 + 0.66200456987249472919999999999999999999999999999996e1 * t136 * t231 * t493 + 0.32e2 * t27 * t18 * t215 * t217 * t128 + 0.13240091397449894583999999999999999999999999999999e2 * t18 * t135 * t218 * t493 + 0.18695226779146675884207825777777777777777777777776e2 * t19 * t68 * t101 * t271 * t272 * t246 + 0.32e2 / 0.3e1 * t27 * t209 * t156 * t514 + 0.40e2 / 0.243e3 * t246 * t20 * t156 * t514 + 0.36217496823956298542271086247545499737960666077495e-2 * t524 * t348 * t350 * t337 - 0.43442496564161191740507888964120073521812450588099e0 * t524 * t331 * t333 * t337 + 0.20041848375753342017576578002544149225709752183427e1 * t524 * t138 * t342 * t337 + 0.10386237099525931046782125432098765432098765432098e1 * t268 * t135 * t57 * t158 * t272
  t543 = t62 ** 2
  t547 = 0.1e1 / t543 * t20 * t156 * t422
  t550 = t53 ** 0.520e1
  t553 = t47 ** 2
  t555 = t553 * t40 * t370
  t559 = t53 ** 0.290e1
  t565 = t53 ** 0.60e0
  t571 = t53 ** (-0.170e1)
  t587 = t470 * t19 * t156 * t422
  t589 = t445 * t47 * t91
  t601 = t392 / t355 * t150
  t642 = t252 * t18 * t156 * t422
  t645 = t390 * t392
  t654 = t365 * t156 * t422
  t664 = 0.25116866667485343760775012216103398485399359246411e-4 * t547 / t347 / t56 * t550 * t335 * t555 - 0.45191115742004520651446815012975142514929541400259e-2 * t547 * t348 * t559 * t335 * t555 + 0.11814183914752692608059383489005473525355579651079e0 * t547 * t331 * t565 * t335 * t555 + 0.22442738169866657943652282700615025309599240455020e0 * t547 * t138 * t571 * t335 * t555 - 0.12844973769383389390826627003557134449175389454564e-1 * t108 * t19 * t156 * t422 * t425 * t370 * t48 * t91 - 0.30070038244562848832730331278577279900509111102859e-1 * t587 * t444 * t589 + 0.18034343172214278704720584312994216766642246794213e1 * t587 * t453 * t589 + 0.55295840928170264472631395044431548886826307123020e-2 * t429 * t331 * t478 * t389 * t601 - 0.33163382207374099199737207628890029283125642681030e0 * t430 * t483 * t389 * t601 - 0.74405024183211119999410401731484040058294711143336e-1 * t394 * t20 * t135 * t425 * t371 * t150 + 0.57802381962225252258719821516007105021289252545542e-1 * t75 * t18 * t156 * t422 * t411 * t166 + 0.28901190981112626129359910758003552510644626272775e-1 * t76 * t156 * t422 * t376 * t166 + 0.57802381962225252258719821516007105021289252545552e-1 * t131 * t156 * t422 * t138 * t205 * t140 * t166 + 0.90052386596554859828406409327919565780832173031118e-1 * t69 * t138 * t271 * t243 * t25 * t293 * t140 * t166 + 0.30070038244562848832730331278577279900509111102860e-1 * t642 * t331 * t96 * t385 * t645 - 0.18034343172214278704720584312994216766642246794212e1 * t642 * t410 * t400 * t645 + 0.15035019122281424416365165639288639950254555551430e-1 * t654 * t331 * t127 * t385 * t645 - 0.90171715861071393523602921564971083833211233971062e0 * t654 * t375 * t400 * t645
  d1111 = t258 + t450 + t542 + t664

  res = {'v4rho4': d1111}
  return res
