"""Generated from gga_x_bpccac.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_kappa = 1.227

  params_mu = 0.2195149727645171

  params_a = 0.19645

  params_b = 7.7956

  params_c = 0.2743

  params_d = -0.1508

  params_f = 0.004

  params_alpha = 100

  params_expo = 4

  bpccac_malpha = 1

  bpccac_mbeta = 19

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  pw91_num = lambda s: (params_c + params_d * jnp.exp(-params_alpha * s ** 2)) * s ** 2 - params_f * s ** params_expo

  pw91_den = lambda s: 1 + s * params_a * jnp.arcsinh(params_b * s) + params_f * s ** params_expo

  bpccac_fab = lambda x: 1 / (1 + jnp.exp(-bpccac_malpha * (x - bpccac_mbeta)))

  pbe_f = lambda x: pbe_f0(X2S * x)

  pw91_f = lambda x: 1 + pw91_num(X2S * x) / pw91_den(X2S * x)

  bpccac_f = lambda x: (1 - bpccac_fab(x)) * pbe_f(x) + bpccac_fab(x) * pw91_f(x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, bpccac_f, rs, z, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_kappa = 1.227

  params_mu = 0.2195149727645171

  params_a = 0.19645

  params_b = 7.7956

  params_c = 0.2743

  params_d = -0.1508

  params_f = 0.004

  params_alpha = 100

  params_expo = 4

  bpccac_malpha = 1

  bpccac_mbeta = 19

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  pw91_num = lambda s: (params_c + params_d * jnp.exp(-params_alpha * s ** 2)) * s ** 2 - params_f * s ** params_expo

  pw91_den = lambda s: 1 + s * params_a * jnp.arcsinh(params_b * s) + params_f * s ** params_expo

  bpccac_fab = lambda x: 1 / (1 + jnp.exp(-bpccac_malpha * (x - bpccac_mbeta)))

  pbe_f = lambda x: pbe_f0(X2S * x)

  pw91_f = lambda x: 1 + pw91_num(X2S * x) / pw91_den(X2S * x)

  bpccac_f = lambda x: (1 - bpccac_fab(x)) * pbe_f(x) + bpccac_fab(x) * pw91_f(x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, bpccac_f, rs, z, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_kappa = 1.227

  params_mu = 0.2195149727645171

  params_a = 0.19645

  params_b = 7.7956

  params_c = 0.2743

  params_d = -0.1508

  params_f = 0.004

  params_alpha = 100

  params_expo = 4

  bpccac_malpha = 1

  bpccac_mbeta = 19

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  pw91_num = lambda s: (params_c + params_d * jnp.exp(-params_alpha * s ** 2)) * s ** 2 - params_f * s ** params_expo

  pw91_den = lambda s: 1 + s * params_a * jnp.arcsinh(params_b * s) + params_f * s ** params_expo

  bpccac_fab = lambda x: 1 / (1 + jnp.exp(-bpccac_malpha * (x - bpccac_mbeta)))

  pbe_f = lambda x: pbe_f0(X2S * x)

  pw91_f = lambda x: 1 + pw91_num(X2S * x) / pw91_den(X2S * x)

  bpccac_f = lambda x: (1 - bpccac_fab(x)) * pbe_f(x) + bpccac_fab(x) * pw91_f(x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, bpccac_f, rs, z, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = jnp.sqrt(s0)
  t29 = r0 ** (0.1e1 / 0.3e1)
  t31 = 0.1e1 / t29 / r0
  t32 = t28 * t31
  t34 = jnp.exp(-t32 + 0.19e2)
  t35 = 0.1e1 + t34
  t36 = 0.1e1 / t35
  t37 = 0.1e1 - t36
  t38 = 6 ** (0.1e1 / 0.3e1)
  t39 = jnp.pi ** 2
  t40 = t39 ** (0.1e1 / 0.3e1)
  t41 = t40 ** 2
  t42 = 0.1e1 / t41
  t43 = t38 * t42
  t44 = r0 ** 2
  t45 = t29 ** 2
  t47 = 0.1e1 / t45 / t44
  t49 = t43 * s0 * t47
  t51 = 0.1227e1 + 0.91464571985215458333333333333333333333333333333333e-2 * t49
  t54 = 0.2227e1 - 0.1505529e1 / t51
  t57 = jnp.exp(-0.25e2 / 0.6e1 * t49)
  t60 = (0.2743e0 - 0.1508e0 * t57) * t38
  t61 = t42 * s0
  t65 = t38 ** 2
  t68 = t65 / t40 / t39
  t69 = s0 ** 2
  t70 = t44 ** 2
  t73 = 0.1e1 / t29 / t70 / r0
  t76 = 0.69444444444444444444444444444444444444444444444444e-5 * t68 * t69 * t73
  t77 = t60 * t61 * t47 / 0.24e2 - t76
  t79 = t65 / t40
  t82 = jnp.arcsinh(0.64963333333333333333333333333333333333333333333333e0 * t79 * t32)
  t86 = 0.1e1 + 0.16370833333333333333333333333333333333333333333333e-1 * t79 * t32 * t82 + t76
  t87 = 0.1e1 / t86
  t89 = t77 * t87 + 0.1e1
  t91 = t36 * t89 + t37 * t54
  t95 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t91)
  t96 = r1 <= f.p.dens_threshold
  t97 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t98 = 0.1e1 + t97
  t99 = t98 <= f.p.zeta_threshold
  t100 = t98 ** (0.1e1 / 0.3e1)
  t102 = f.my_piecewise3(t99, t22, t100 * t98)
  t103 = t102 * t26
  t104 = jnp.sqrt(s2)
  t105 = r1 ** (0.1e1 / 0.3e1)
  t107 = 0.1e1 / t105 / r1
  t108 = t104 * t107
  t110 = jnp.exp(-t108 + 0.19e2)
  t111 = 0.1e1 + t110
  t112 = 0.1e1 / t111
  t113 = 0.1e1 - t112
  t114 = r1 ** 2
  t115 = t105 ** 2
  t117 = 0.1e1 / t115 / t114
  t119 = t43 * s2 * t117
  t121 = 0.1227e1 + 0.91464571985215458333333333333333333333333333333333e-2 * t119
  t124 = 0.2227e1 - 0.1505529e1 / t121
  t127 = jnp.exp(-0.25e2 / 0.6e1 * t119)
  t130 = (0.2743e0 - 0.1508e0 * t127) * t38
  t131 = t42 * s2
  t135 = s2 ** 2
  t136 = t114 ** 2
  t139 = 0.1e1 / t105 / t136 / r1
  t142 = 0.69444444444444444444444444444444444444444444444444e-5 * t68 * t135 * t139
  t143 = t130 * t131 * t117 / 0.24e2 - t142
  t146 = jnp.arcsinh(0.64963333333333333333333333333333333333333333333333e0 * t79 * t108)
  t150 = 0.1e1 + 0.16370833333333333333333333333333333333333333333333e-1 * t79 * t108 * t146 + t142
  t151 = 0.1e1 / t150
  t153 = t143 * t151 + 0.1e1
  t155 = t112 * t153 + t113 * t124
  t159 = f.my_piecewise3(t96, 0, -0.3e1 / 0.8e1 * t5 * t103 * t155)
  t160 = t6 ** 2
  t162 = t16 / t160
  t163 = t7 - t162
  t164 = f.my_piecewise5(t10, 0, t14, 0, t163)
  t167 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t164)
  t172 = t26 ** 2
  t173 = 0.1e1 / t172
  t177 = t5 * t25 * t173 * t91 / 0.8e1
  t178 = t35 ** 2
  t179 = 0.1e1 / t178
  t182 = 0.1e1 / t29 / t44
  t187 = t51 ** 2
  t189 = t37 / t187
  t193 = 0.1e1 / t45 / t44 / r0
  t194 = t61 * t193
  t197 = t179 * t89
  t198 = t28 * t182
  t205 = t69 / t29 / t70 / t44
  t212 = 0.37037037037037037037037037037037037037037037037037e-4 * t68 * t205
  t215 = t86 ** 2
  t217 = t77 / t215
  t224 = jnp.sqrt(0.1e1 + 0.25321408066666666666666666666666666666666666666666e1 * t49)
  t225 = 0.1e1 / t224
  t238 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t167 * t26 * t91 - t177 - 0.3e1 / 0.8e1 * t5 * t27 * (0.4e1 / 0.3e1 * t179 * t28 * t182 * t34 * t54 - 0.36720684159021185005100000000000000000000000000000e-1 * t189 * t38 * t194 - 0.4e1 / 0.3e1 * t197 * t198 * t34 + t36 * ((-0.69814814814814814814814814814814814814814814814817e-1 * t68 * t205 * t57 - t60 * t194 / 0.9e1 + t212) * t87 - t217 * (-0.21827777777777777777777777777777777777777777777777e-1 * t79 * t198 * t82 - 0.85080312222222222222222222222222222222222222222219e-1 * t43 * s0 * t193 * t225 - t212))))
  t240 = f.my_piecewise5(t14, 0, t10, 0, -t163)
  t243 = f.my_piecewise3(t99, 0, 0.4e1 / 0.3e1 * t100 * t240)
  t251 = t5 * t102 * t173 * t155 / 0.8e1
  t253 = f.my_piecewise3(t96, 0, -0.3e1 / 0.8e1 * t5 * t243 * t26 * t155 - t251)
  vrho_0_ = t95 + t159 + t6 * (t238 + t253)
  t256 = -t7 - t162
  t257 = f.my_piecewise5(t10, 0, t14, 0, t256)
  t260 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t257)
  t266 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t260 * t26 * t91 - t177)
  t268 = f.my_piecewise5(t14, 0, t10, 0, -t256)
  t271 = f.my_piecewise3(t99, 0, 0.4e1 / 0.3e1 * t100 * t268)
  t276 = t111 ** 2
  t277 = 0.1e1 / t276
  t280 = 0.1e1 / t105 / t114
  t285 = t121 ** 2
  t287 = t113 / t285
  t291 = 0.1e1 / t115 / t114 / r1
  t292 = t131 * t291
  t295 = t277 * t153
  t296 = t104 * t280
  t303 = t135 / t105 / t136 / t114
  t310 = 0.37037037037037037037037037037037037037037037037037e-4 * t68 * t303
  t313 = t150 ** 2
  t315 = t143 / t313
  t322 = jnp.sqrt(0.1e1 + 0.25321408066666666666666666666666666666666666666666e1 * t119)
  t323 = 0.1e1 / t322
  t336 = f.my_piecewise3(t96, 0, -0.3e1 / 0.8e1 * t5 * t271 * t26 * t155 - t251 - 0.3e1 / 0.8e1 * t5 * t103 * (0.4e1 / 0.3e1 * t277 * t104 * t280 * t110 * t124 - 0.36720684159021185005100000000000000000000000000000e-1 * t287 * t38 * t292 - 0.4e1 / 0.3e1 * t295 * t296 * t110 + t112 * ((-0.69814814814814814814814814814814814814814814814817e-1 * t68 * t303 * t127 - t130 * t292 / 0.9e1 + t310) * t151 - t315 * (-0.21827777777777777777777777777777777777777777777777e-1 * t79 * t296 * t146 - 0.85080312222222222222222222222222222222222222222219e-1 * t43 * s2 * t291 * t323 - t310))))
  vrho_1_ = t95 + t159 + t6 * (t266 + t336)
  t339 = 0.1e1 / t28
  t348 = t339 * t31
  t361 = 0.13888888888888888888888888888888888888888888888889e-4 * t68 * s0 * t73
  t378 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (-t179 * t339 * t31 * t34 * t54 / 0.2e1 + 0.13770256559632944376912500000000000000000000000000e-1 * t189 * t43 * t47 + t197 * t348 * t34 / 0.2e1 + t36 * ((0.26180555555555555555555555555555555555555555555555e-1 * t68 * t73 * t57 * s0 + t60 * t42 * t47 / 0.24e2 - t361) * t87 - t217 * (0.81854166666666666666666666666666666666666666666665e-2 * t79 * t348 * t82 + 0.31905117083333333333333333333333333333333333333333e-1 * t43 * t47 * t225 + t361))))
  vsigma_0_ = t6 * t378
  vsigma_1_ = 0.0e0
  t379 = 0.1e1 / t104
  t388 = t379 * t107
  t401 = 0.13888888888888888888888888888888888888888888888889e-4 * t68 * s2 * t139
  t418 = f.my_piecewise3(t96, 0, -0.3e1 / 0.8e1 * t5 * t103 * (-t277 * t379 * t107 * t110 * t124 / 0.2e1 + 0.13770256559632944376912500000000000000000000000000e-1 * t287 * t43 * t117 + t295 * t388 * t110 / 0.2e1 + t112 * ((0.26180555555555555555555555555555555555555555555555e-1 * t68 * t139 * t127 * s2 + t130 * t42 * t117 / 0.24e2 - t401) * t151 - t315 * (0.81854166666666666666666666666666666666666666666665e-2 * t79 * t388 * t146 + 0.31905117083333333333333333333333333333333333333333e-1 * t43 * t117 * t323 + t401))))
  vsigma_2_ = t6 * t418
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_kappa = 1.227

  params_mu = 0.2195149727645171

  params_a = 0.19645

  params_b = 7.7956

  params_c = 0.2743

  params_d = -0.1508

  params_f = 0.004

  params_alpha = 100

  params_expo = 4

  bpccac_malpha = 1

  bpccac_mbeta = 19

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  pw91_num = lambda s: (params_c + params_d * jnp.exp(-params_alpha * s ** 2)) * s ** 2 - params_f * s ** params_expo

  pw91_den = lambda s: 1 + s * params_a * jnp.arcsinh(params_b * s) + params_f * s ** params_expo

  bpccac_fab = lambda x: 1 / (1 + jnp.exp(-bpccac_malpha * (x - bpccac_mbeta)))

  pbe_f = lambda x: pbe_f0(X2S * x)

  pw91_f = lambda x: 1 + pw91_num(X2S * x) / pw91_den(X2S * x)

  bpccac_f = lambda x: (1 - bpccac_fab(x)) * pbe_f(x) + bpccac_fab(x) * pw91_f(x)

  functional_body = lambda rs, z, xt, xs0, xs1: gga_exchange(f, params, bpccac_f, rs, z, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = jnp.sqrt(s0)
  t21 = 2 ** (0.1e1 / 0.3e1)
  t24 = 0.1e1 / t18 / r0
  t25 = t20 * t21 * t24
  t27 = jnp.exp(-t25 + 0.19e2)
  t28 = 0.1e1 + t27
  t29 = 0.1e1 / t28
  t30 = 0.1e1 - t29
  t31 = 6 ** (0.1e1 / 0.3e1)
  t32 = jnp.pi ** 2
  t33 = t32 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t35 = 0.1e1 / t34
  t36 = t31 * t35
  t37 = t21 ** 2
  t38 = s0 * t37
  t39 = r0 ** 2
  t40 = t18 ** 2
  t42 = 0.1e1 / t40 / t39
  t43 = t38 * t42
  t44 = t36 * t43
  t46 = 0.1227e1 + 0.91464571985215458333333333333333333333333333333333e-2 * t44
  t49 = 0.2227e1 - 0.1505529e1 / t46
  t52 = jnp.exp(-0.25e2 / 0.6e1 * t44)
  t55 = (0.2743e0 - 0.1508e0 * t52) * t31
  t56 = t55 * t35
  t59 = t31 ** 2
  t62 = t59 / t33 / t32
  t63 = s0 ** 2
  t64 = t63 * t21
  t65 = t39 ** 2
  t68 = 0.1e1 / t18 / t65 / r0
  t71 = 0.13888888888888888888888888888888888888888888888889e-4 * t62 * t64 * t68
  t72 = t56 * t43 / 0.24e2 - t71
  t74 = t59 / t33
  t75 = t74 * t20
  t76 = t21 * t24
  t79 = jnp.arcsinh(0.64963333333333333333333333333333333333333333333333e0 * t74 * t25)
  t80 = t76 * t79
  t83 = 0.1e1 + 0.16370833333333333333333333333333333333333333333333e-1 * t75 * t80 + t71
  t84 = 0.1e1 / t83
  t86 = t72 * t84 + 0.1e1
  t88 = t29 * t86 + t30 * t49
  t92 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t88)
  t98 = t28 ** 2
  t99 = 0.1e1 / t98
  t103 = 0.1e1 / t18 / t39
  t108 = t46 ** 2
  t111 = t30 / t108 * t31
  t115 = 0.1e1 / t40 / t39 / r0
  t116 = t37 * t115
  t120 = t99 * t86
  t122 = t21 * t103
  t129 = 0.1e1 / t18 / t65 / t39
  t139 = 0.74074074074074074074074074074074074074074074074075e-4 * t62 * t64 * t129
  t142 = t83 ** 2
  t144 = t72 / t142
  t151 = jnp.sqrt(0.1e1 + 0.25321408066666666666666666666666666666666666666666e1 * t44)
  t152 = 0.1e1 / t151
  t165 = f.my_piecewise3(t2, 0, -t6 * t17 / t40 * t88 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (0.4e1 / 0.3e1 * t99 * t20 * t21 * t103 * t27 * t49 - 0.36720684159021185005100000000000000000000000000000e-1 * t111 * t35 * s0 * t116 - 0.4e1 / 0.3e1 * t120 * t20 * t122 * t27 + t29 * ((-0.13962962962962962962962962962962962962962962962963e0 * t62 * t63 * t21 * t129 * t52 - t56 * t38 * t115 / 0.9e1 + t139) * t84 - t144 * (-0.21827777777777777777777777777777777777777777777777e-1 * t75 * t122 * t79 - 0.85080312222222222222222222222222222222222222222219e-1 * t36 * s0 * t116 * t152 - t139))))
  vrho_0_ = 0.2e1 * r0 * t165 + 0.2e1 * t92
  t168 = 0.1e1 / t20
  t176 = t35 * t37 * t42
  t193 = 0.27777777777777777777777777777777777777777777777778e-4 * t62 * s0 * t21 * t68
  t211 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (-t99 * t168 * t21 * t24 * t27 * t49 / 0.2e1 + 0.13770256559632944376912500000000000000000000000000e-1 * t111 * t176 + t120 * t168 * t76 * t27 / 0.2e1 + t29 * ((0.52361111111111111111111111111111111111111111111112e-1 * t62 * t21 * t68 * t52 * s0 + t55 * t176 / 0.24e2 - t193) * t84 - t144 * (0.81854166666666666666666666666666666666666666666665e-2 * t74 * t168 * t80 + 0.31905117083333333333333333333333333333333333333333e-1 * t36 * t37 * t42 * t152 + t193))))
  vsigma_0_ = 0.2e1 * r0 * t211
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t22 = jnp.sqrt(s0)
  t23 = 2 ** (0.1e1 / 0.3e1)
  t26 = 0.1e1 / t18 / r0
  t27 = t22 * t23 * t26
  t29 = jnp.exp(-t27 + 0.19e2)
  t30 = 0.1e1 + t29
  t31 = 0.1e1 / t30
  t32 = 0.1e1 - t31
  t33 = 6 ** (0.1e1 / 0.3e1)
  t34 = jnp.pi ** 2
  t35 = t34 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t38 = t33 * t37
  t39 = t23 ** 2
  t40 = s0 * t39
  t41 = r0 ** 2
  t43 = 0.1e1 / t19 / t41
  t44 = t40 * t43
  t45 = t38 * t44
  t47 = 0.1227e1 + 0.91464571985215458333333333333333333333333333333336e-2 * t45
  t50 = 0.2227e1 - 0.1505529e1 / t47
  t53 = jnp.exp(-0.25e2 / 0.6e1 * t45)
  t56 = (0.2743e0 - 0.1508e0 * t53) * t33
  t57 = t56 * t37
  t60 = t33 ** 2
  t62 = 0.1e1 / t35 / t34
  t63 = t60 * t62
  t64 = s0 ** 2
  t65 = t64 * t23
  t66 = t41 ** 2
  t67 = t66 * r0
  t69 = 0.1e1 / t18 / t67
  t72 = 0.13888888888888888888888888888888888888888888888889e-4 * t63 * t65 * t69
  t73 = t57 * t44 / 0.24e2 - t72
  t75 = t60 / t35
  t76 = t75 * t22
  t77 = t23 * t26
  t80 = jnp.arcsinh(0.64963333333333333333333333333333333333333333333333e0 * t75 * t27)
  t81 = t77 * t80
  t84 = 0.1e1 + 0.16370833333333333333333333333333333333333333333333e-1 * t76 * t81 + t72
  t85 = 0.1e1 / t84
  t87 = t73 * t85 + 0.1e1
  t89 = t31 * t87 + t32 * t50
  t93 = t17 * t18
  t94 = t30 ** 2
  t95 = 0.1e1 / t94
  t96 = t95 * t22
  t97 = t96 * t23
  t99 = 0.1e1 / t18 / t41
  t101 = t99 * t29 * t50
  t104 = t47 ** 2
  t105 = 0.1e1 / t104
  t107 = t32 * t105 * t33
  t108 = t37 * s0
  t109 = t41 * r0
  t111 = 0.1e1 / t19 / t109
  t112 = t39 * t111
  t116 = t95 * t87
  t117 = t116 * t22
  t118 = t23 * t99
  t119 = t118 * t29
  t122 = t63 * t64
  t123 = t66 * t41
  t125 = 0.1e1 / t18 / t123
  t135 = 0.74074074074074074074074074074074074074074074074075e-4 * t63 * t65 * t125
  t136 = -0.13962962962962962962962962962962962962962962962963e0 * t122 * t23 * t125 * t53 - t57 * t40 * t111 / 0.9e1 + t135
  t138 = t84 ** 2
  t139 = 0.1e1 / t138
  t140 = t73 * t139
  t141 = t118 * t80
  t144 = t38 * s0
  t146 = 0.1e1 + 0.25321408066666666666666666666666666666666666666666e1 * t45
  t147 = jnp.sqrt(t146)
  t148 = 0.1e1 / t147
  t149 = t112 * t148
  t152 = -0.21827777777777777777777777777777777777777777777777e-1 * t76 * t141 - 0.85080312222222222222222222222222222222222222222219e-1 * t144 * t149 - t135
  t154 = t136 * t85 - t140 * t152
  t156 = 0.4e1 / 0.3e1 * t97 * t101 - 0.36720684159021185005100000000000000000000000000002e-1 * t107 * t108 * t112 - 0.4e1 / 0.3e1 * t117 * t119 + t31 * t154
  t161 = f.my_piecewise3(t2, 0, -t6 * t21 * t89 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t93 * t156)
  t173 = 0.1e1 / t94 / t30
  t177 = 0.1e1 / t19 / t66
  t178 = t29 ** 2
  t184 = 0.1e1 / t18 / t109
  t195 = t22 * s0
  t200 = t29 * t105 * t38
  t206 = t32 / t104 / t47 * t60
  t210 = 0.1e1 / t18 / t66 / t109
  t211 = t23 * t210
  t215 = t39 * t177
  t219 = t173 * t87
  t224 = t95 * t154
  t228 = t23 * t184
  t239 = t34 ** 2
  t240 = 0.1e1 / t239
  t243 = t66 ** 2
  t254 = 0.46913580246913580246913580246913580246913580246914e-3 * t63 * t65 * t210
  t257 = t136 * t139
  t262 = t73 / t138 / t84
  t263 = t152 ** 2
  t273 = 0.1e1 / t147 / t146
  t281 = -0.32e2 / 0.9e1 * t173 * s0 * t39 * t177 * t178 * t50 - 0.28e2 / 0.9e1 * t97 * t184 * t29 * t50 + 0.16e2 / 0.9e1 * t95 * s0 * t39 * t177 * t29 * t50 - 0.19584364884811298669386666666666666666666666666668e0 * t95 * t195 / t123 * t200 - 0.35825511035830977498098495803833498711111111111115e-2 * t206 * t62 * t64 * t211 + 0.13464250858307767835203333333333333333333333333334e0 * t107 * t108 * t215 + 0.32e2 / 0.9e1 * t219 * s0 * t215 * t178 - 0.8e1 / 0.3e1 * t224 * t22 * t119 + 0.28e2 / 0.9e1 * t117 * t228 * t29 - 0.16e2 / 0.9e1 * t116 * s0 * t215 * t29 + t31 * ((0.12566666666666666666666666666666666666666666666667e1 * t122 * t211 * t53 - 0.18617283950617283950617283950617283950617283950617e2 * t240 * t64 * s0 / t243 / t41 * t53 + 0.11e2 / 0.27e2 * t57 * t40 * t177 - t254) * t85 - 0.2e1 * t257 * t152 + 0.2e1 * t262 * t263 - t140 * (0.50931481481481481481481481481481481481481481481480e-1 * t76 * t228 * t80 + 0.42540156111111111111111111111111111111111111111109e0 * t144 * t215 * t148 - 0.57449421445821236543209876543209876543209876543208e0 * t122 * t211 * t273 + t254))
  t286 = f.my_piecewise3(t2, 0, t6 * t17 / t19 / r0 * t89 / 0.12e2 - t6 * t21 * t156 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t93 * t281)
  v2rho2_0_ = 0.2e1 * r0 * t286 + 0.4e1 * t161
  t289 = 0.1e1 / t22
  t290 = t95 * t289
  t291 = t290 * t23
  t293 = t26 * t29 * t50
  t296 = t37 * t39
  t297 = t296 * t43
  t300 = t116 * t289
  t301 = t77 * t29
  t304 = t63 * t23
  t311 = s0 * t23
  t314 = 0.27777777777777777777777777777777777777777777777778e-4 * t63 * t311 * t69
  t315 = 0.52361111111111111111111111111111111111111111111112e-1 * t304 * t69 * t53 * s0 + t56 * t297 / 0.24e2 - t314
  t317 = t75 * t289
  t320 = t39 * t43
  t321 = t320 * t148
  t324 = 0.81854166666666666666666666666666666666666666666665e-2 * t317 * t81 + 0.31905117083333333333333333333333333333333333333333e-1 * t38 * t321 + t314
  t326 = -t140 * t324 + t315 * t85
  t328 = -t291 * t293 / 0.2e1 + 0.13770256559632944376912500000000000000000000000000e-1 * t107 * t297 + t300 * t301 / 0.2e1 + t31 * t326
  t332 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t93 * t328)
  t352 = t62 * t23
  t357 = t296 * t111
  t371 = t95 * t326
  t389 = 0.14814814814814814814814814814814814814814814814815e-3 * t63 * t311 * t125
  t392 = t315 * t139
  t410 = 0.4e1 / 0.3e1 * t173 * t39 * t111 * t178 * t50 + 0.2e1 / 0.3e1 * t291 * t101 - 0.2e1 / 0.3e1 * t95 * t39 * t111 * t29 * t50 + 0.73441368318042370010200000000000000000000000000002e-1 * t96 / t67 * t200 + 0.13434566638436616561786935926437562016666666666667e-2 * t206 * t352 * t125 * s0 - 0.36720684159021185005100000000000000000000000000000e-1 * t107 * t357 - 0.4e1 / 0.3e1 * t219 * t112 * t178 + t224 * t289 * t301 / 0.2e1 - 0.2e1 / 0.3e1 * t300 * t119 + 0.2e1 / 0.3e1 * t116 * t112 * t29 - 0.4e1 / 0.3e1 * t371 * t22 * t119 + t31 * ((-0.41888888888888888888888888888888888888888888888889e0 * t304 * t125 * t53 * s0 + 0.69814814814814814814814814814814814814814814814816e1 * t240 / t243 / r0 * t64 * t53 - t56 * t357 / 0.9e1 + t389) * t85 - t392 * t152 - t257 * t324 + 0.2e1 * t262 * t324 * t152 - t140 * (-0.10913888888888888888888888888888888888888888888889e-1 * t317 * t141 - 0.12762046833333333333333333333333333333333333333333e0 * t38 * t149 + 0.21543533042182963703703703703703703703703703703704e0 * t304 * t125 * t273 * s0 - t389))
  t415 = f.my_piecewise3(t2, 0, -t6 * t21 * t328 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t93 * t410)
  v2rhosigma_0_ = 0.2e1 * r0 * t415 + 0.2e1 * t332
  t418 = 0.1e1 / s0
  t425 = 0.1e1 / t195
  t461 = t23 * t69
  t466 = 0.27777777777777777777777777777777777777777777777778e-4 * t63 * t461
  t471 = t324 ** 2
  t491 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t93 * (-t173 * t418 * t39 * t43 * t178 * t50 / 0.2e1 + t95 * t425 * t23 * t293 / 0.4e1 + t95 * t418 * t39 * t43 * t29 * t50 / 0.4e1 - 0.27540513119265888753825000000000000000000000000000e-1 * t290 / t66 * t200 - 0.50379624894137312106701009724140857562500000000001e-3 * t206 * t352 * t69 + t219 * t418 * t320 * t178 / 0.2e1 + t371 * t289 * t301 - t116 * t425 * t301 / 0.4e1 - t116 * t418 * t320 * t29 / 0.4e1 + t31 * ((-0.26180555555555555555555555555555555555555555555556e1 * t240 / t243 * t53 * s0 + 0.10472222222222222222222222222222222222222222222222e0 * t63 * t461 * t53 - t466) * t85 - 0.2e1 * t392 * t324 + 0.2e1 * t262 * t471 - t140 * (-0.40927083333333333333333333333333333333333333333332e-2 * t75 * t425 * t81 + 0.15952558541666666666666666666666666666666666666666e-1 * t38 * t418 * t321 - 0.80788248908186113888888888888888888888888888888886e-1 * t63 * t461 * t273 + t466))))
  v2sigma2_0_ = 0.2e1 * r0 * t491
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t22 = t17 / t19 / r0
  t23 = jnp.sqrt(s0)
  t24 = 2 ** (0.1e1 / 0.3e1)
  t27 = 0.1e1 / t18 / r0
  t28 = t23 * t24 * t27
  t30 = jnp.exp(-t28 + 0.19e2)
  t31 = 0.1e1 + t30
  t32 = 0.1e1 / t31
  t33 = 0.1e1 - t32
  t34 = 6 ** (0.1e1 / 0.3e1)
  t35 = jnp.pi ** 2
  t36 = t35 ** (0.1e1 / 0.3e1)
  t37 = t36 ** 2
  t38 = 0.1e1 / t37
  t39 = t34 * t38
  t40 = t24 ** 2
  t41 = s0 * t40
  t42 = r0 ** 2
  t44 = 0.1e1 / t19 / t42
  t45 = t41 * t44
  t46 = t39 * t45
  t48 = 0.1227e1 + 0.91464571985215458333333333333333333333333333333336e-2 * t46
  t51 = 0.2227e1 - 0.1505529e1 / t48
  t54 = jnp.exp(-0.25e2 / 0.6e1 * t46)
  t58 = (0.2743e0 - 0.1508e0 * t54) * t34 * t38
  t61 = t34 ** 2
  t63 = 0.1e1 / t36 / t35
  t64 = t61 * t63
  t65 = s0 ** 2
  t66 = t65 * t24
  t67 = t42 ** 2
  t68 = t67 * r0
  t73 = 0.13888888888888888888888888888888888888888888888889e-4 * t64 * t66 / t18 / t68
  t74 = t58 * t45 / 0.24e2 - t73
  t76 = t61 / t36
  t77 = t76 * t23
  t81 = jnp.asinh(0.64963333333333333333333333333333333333333333333333e0 * t76 * t28)
  t85 = 0.1e1 + 0.16370833333333333333333333333333333333333333333333e-1 * t77 * t24 * t27 * t81 + t73
  t86 = 0.1e1 / t85
  t88 = t74 * t86 + 0.1e1
  t90 = t32 * t88 + t33 * t51
  t95 = t17 / t19
  t96 = t31 ** 2
  t97 = 0.1e1 / t96
  t99 = t97 * t23 * t24
  t101 = 0.1e1 / t18 / t42
  t106 = t48 ** 2
  t107 = 0.1e1 / t106
  t109 = t33 * t107 * t34
  t110 = t38 * s0
  t111 = t42 * r0
  t113 = 0.1e1 / t19 / t111
  t114 = t40 * t113
  t118 = t97 * t88
  t119 = t118 * t23
  t120 = t24 * t101
  t121 = t120 * t30
  t124 = t64 * t65
  t125 = t67 * t42
  t127 = 0.1e1 / t18 / t125
  t137 = 0.74074074074074074074074074074074074074074074074075e-4 * t64 * t66 * t127
  t138 = -0.13962962962962962962962962962962962962962962962963e0 * t124 * t24 * t127 * t54 - t58 * t41 * t113 / 0.9e1 + t137
  t140 = t85 ** 2
  t141 = 0.1e1 / t140
  t142 = t74 * t141
  t146 = t39 * s0
  t148 = 0.1e1 + 0.25321408066666666666666666666666666666666666666666e1 * t46
  t149 = jnp.sqrt(t148)
  t150 = 0.1e1 / t149
  t154 = -0.21827777777777777777777777777777777777777777777777e-1 * t77 * t120 * t81 - 0.85080312222222222222222222222222222222222222222219e-1 * t146 * t114 * t150 - t137
  t156 = t138 * t86 - t142 * t154
  t158 = 0.4e1 / 0.3e1 * t99 * t101 * t30 * t51 - 0.36720684159021185005100000000000000000000000000002e-1 * t109 * t110 * t114 - 0.4e1 / 0.3e1 * t119 * t121 + t32 * t156
  t162 = t17 * t18
  t164 = 0.1e1 / t96 / t31
  t166 = t164 * s0 * t40
  t168 = 0.1e1 / t19 / t67
  t169 = t30 ** 2
  t175 = 0.1e1 / t18 / t111
  t181 = t97 * s0 * t40
  t186 = t23 * s0
  t187 = t97 * t186
  t191 = t30 * t107 * t39
  t195 = 0.1e1 / t106 / t48
  t197 = t33 * t195 * t61
  t198 = t63 * t65
  t199 = t67 * t111
  t201 = 0.1e1 / t18 / t199
  t202 = t24 * t201
  t206 = t40 * t168
  t210 = t164 * t88
  t211 = t210 * s0
  t212 = t206 * t169
  t215 = t97 * t156
  t216 = t215 * t23
  t219 = t24 * t175
  t220 = t219 * t30
  t223 = t118 * s0
  t224 = t206 * t30
  t230 = t35 ** 2
  t231 = 0.1e1 / t230
  t233 = t231 * t65 * s0
  t234 = t67 ** 2
  t245 = 0.46913580246913580246913580246913580246913580246914e-3 * t64 * t66 * t201
  t246 = 0.12566666666666666666666666666666666666666666666667e1 * t124 * t202 * t54 - 0.18617283950617283950617283950617283950617283950617e2 * t233 / t234 / t42 * t54 + 0.11e2 / 0.27e2 * t58 * t41 * t168 - t245
  t248 = t138 * t141
  t252 = 0.1e1 / t140 / t85
  t253 = t74 * t252
  t254 = t154 ** 2
  t264 = 0.1e1 / t149 / t148
  t268 = 0.50931481481481481481481481481481481481481481481480e-1 * t77 * t219 * t81 + 0.42540156111111111111111111111111111111111111111109e0 * t146 * t206 * t150 - 0.57449421445821236543209876543209876543209876543208e0 * t124 * t202 * t264 + t245
  t270 = -t142 * t268 - 0.2e1 * t248 * t154 + t246 * t86 + 0.2e1 * t253 * t254
  t272 = -0.32e2 / 0.9e1 * t166 * t168 * t169 * t51 - 0.28e2 / 0.9e1 * t99 * t175 * t30 * t51 + 0.16e2 / 0.9e1 * t181 * t168 * t30 * t51 - 0.19584364884811298669386666666666666666666666666668e0 * t187 / t125 * t191 - 0.35825511035830977498098495803833498711111111111115e-2 * t197 * t198 * t202 + 0.13464250858307767835203333333333333333333333333334e0 * t109 * t110 * t206 + 0.32e2 / 0.9e1 * t211 * t212 - 0.8e1 / 0.3e1 * t216 * t121 + 0.28e2 / 0.9e1 * t119 * t220 - 0.16e2 / 0.9e1 * t223 * t224 + t32 * t270
  t277 = f.my_piecewise3(t2, 0, t6 * t22 * t90 / 0.12e2 - t6 * t95 * t158 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t162 * t272)
  t290 = 0.1e1 / t18 / t67
  t291 = t24 * t290
  t296 = 0.1e1 / t19 / t68
  t297 = t40 * t296
  t309 = 0.1e1 / t18 / t234
  t310 = t24 * t309
  t315 = 0.1e1 / t234 / t111
  t319 = t65 ** 2
  t334 = 0.34403292181069958847736625514403292181069958847737e-2 * t64 * t66 * t309
  t345 = t140 ** 2
  t363 = t148 ** 2
  t378 = 0.1e1 / t199
  t390 = t186 * t378
  t394 = t106 ** 2
  t400 = -0.280e3 / 0.27e2 * t119 * t291 * t30 + 0.112e3 / 0.9e1 * t223 * t297 * t30 - 0.4e1 * t97 * t270 * t23 * t121 - 0.16e2 / 0.3e1 * t215 * s0 * t224 + t32 * ((-0.10580823045267489711934156378600823045267489711934e2 * t124 * t310 * t54 + 0.35372839506172839506172839506172839506172839506173e3 * t233 * t315 * t54 - 0.20685871056241426611796982167352537722908093278463e3 * t231 * t319 / t19 / t234 / t68 * t39 * t40 * t54 - 0.154e3 / 0.81e2 * t58 * t41 * t296 + t334) * t86 - 0.3e1 * t246 * t141 * t154 + 0.6e1 * t138 * t252 * t254 - 0.3e1 * t248 * t268 - 0.6e1 * t74 / t345 * t254 * t154 + 0.6e1 * t253 * t154 * t268 - t142 * (-0.16977160493827160493827160493827160493827160493827e0 * t77 * t291 * t81 - 0.22499015898765432098765432098765432098765432098764e1 * t146 * t297 * t150 + 0.70854286449846191736625514403292181069958847736623e1 * t124 * t310 * t264 - 0.69825611693930441054234048790123456790123456790121e2 * t233 * t315 / t149 / t363 - t334)) + 0.28e2 / 0.3e1 * t216 * t220 - 0.224e3 / 0.9e1 * t211 * t297 * t169 + 0.17625928396330168802448000000000000000000000000002e1 * t187 * t378 * t191 + 0.224e3 / 0.9e1 * t166 * t296 * t169 * t51 + 0.280e3 / 0.27e2 * t99 * t290 * t30 * t51 - 0.128e3 / 0.27e2 * t118 * t390 * t30 - 0.31456944317221375301436865466528581954162187847672e-2 * t33 / t394 * t233 * t315
  t401 = t96 ** 2
  t402 = 0.1e1 / t401
  t404 = t169 * t30
  t461 = -0.256e3 / 0.9e1 * t402 * t88 * t390 * t404 + 0.256e3 / 0.9e1 * t210 * t390 * t169 + 0.256e3 / 0.9e1 * t402 * t186 * t378 * t404 * t51 - 0.256e3 / 0.9e1 * t164 * t186 * t378 * t169 * t51 + 0.128e3 / 0.27e2 * t187 * t378 * t30 * t51 - 0.62833170672102916564282222222222222222222222222225e0 * t109 * t110 * t297 + 0.78337459539245194677546666666666666666666666666672e0 * t164 * t65 * t310 * t169 * t107 * t39 - 0.39168729769622597338773333333333333333333333333336e0 * t97 * t65 * t310 * t191 - 0.14330204414332390999239398321533399484444444444446e-1 * t97 * t23 * t65 / t19 / t234 / r0 * t30 * t195 * t61 * t63 * t40 + 0.39408062139414075247908345384216848582222222222226e-1 * t197 * t198 * t310 - 0.112e3 / 0.9e1 * t181 * t296 * t30 * t51 + 0.32e2 / 0.3e1 * t164 * t156 * s0 * t212
  t467 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t44 * t90 + t6 * t22 * t158 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t95 * t272 - 0.3e1 / 0.8e1 * t6 * t162 * (t400 + t461))
  v3rho3_0_ = 0.2e1 * r0 * t467 + 0.6e1 * t277

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t23 = t17 * t22
  t24 = jnp.sqrt(s0)
  t25 = 2 ** (0.1e1 / 0.3e1)
  t28 = 0.1e1 / t19 / r0
  t29 = t24 * t25 * t28
  t31 = jnp.exp(-t29 + 0.19e2)
  t32 = 0.1e1 + t31
  t33 = 0.1e1 / t32
  t34 = 0.1e1 - t33
  t35 = 6 ** (0.1e1 / 0.3e1)
  t36 = jnp.pi ** 2
  t37 = t36 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t39 = 0.1e1 / t38
  t40 = t35 * t39
  t41 = t25 ** 2
  t42 = s0 * t41
  t43 = t42 * t22
  t44 = t40 * t43
  t46 = 0.1227e1 + 0.91464571985215458333333333333333333333333333333336e-2 * t44
  t49 = 0.2227e1 - 0.1505529e1 / t46
  t52 = jnp.exp(-0.25e2 / 0.6e1 * t44)
  t56 = (0.2743e0 - 0.1508e0 * t52) * t35 * t39
  t59 = t35 ** 2
  t61 = 0.1e1 / t37 / t36
  t62 = t59 * t61
  t63 = s0 ** 2
  t64 = t63 * t25
  t65 = t18 ** 2
  t66 = t65 * r0
  t68 = 0.1e1 / t19 / t66
  t71 = 0.13888888888888888888888888888888888888888888888889e-4 * t62 * t64 * t68
  t72 = t56 * t43 / 0.24e2 - t71
  t74 = t59 / t37
  t75 = t74 * t24
  t79 = jnp.asinh(0.64963333333333333333333333333333333333333333333333e0 * t74 * t29)
  t83 = 0.1e1 + 0.16370833333333333333333333333333333333333333333333e-1 * t75 * t25 * t28 * t79 + t71
  t84 = 0.1e1 / t83
  t86 = t72 * t84 + 0.1e1
  t88 = t33 * t86 + t34 * t49
  t94 = t17 / t20 / r0
  t95 = t32 ** 2
  t96 = 0.1e1 / t95
  t98 = t96 * t24 * t25
  t100 = 0.1e1 / t19 / t18
  t105 = t46 ** 2
  t106 = 0.1e1 / t105
  t108 = t34 * t106 * t35
  t109 = t39 * s0
  t110 = t18 * r0
  t112 = 0.1e1 / t20 / t110
  t113 = t41 * t112
  t117 = t96 * t86
  t118 = t117 * t24
  t119 = t25 * t100
  t120 = t119 * t31
  t123 = t62 * t63
  t124 = t65 * t18
  t126 = 0.1e1 / t19 / t124
  t136 = 0.74074074074074074074074074074074074074074074074075e-4 * t62 * t64 * t126
  t137 = -0.13962962962962962962962962962962962962962962962963e0 * t123 * t25 * t126 * t52 - t56 * t42 * t112 / 0.9e1 + t136
  t139 = t83 ** 2
  t140 = 0.1e1 / t139
  t141 = t72 * t140
  t145 = t40 * s0
  t147 = 0.1e1 + 0.25321408066666666666666666666666666666666666666666e1 * t44
  t148 = jnp.sqrt(t147)
  t149 = 0.1e1 / t148
  t153 = -0.21827777777777777777777777777777777777777777777777e-1 * t75 * t119 * t79 - 0.85080312222222222222222222222222222222222222222219e-1 * t145 * t113 * t149 - t136
  t155 = t137 * t84 - t141 * t153
  t157 = 0.4e1 / 0.3e1 * t98 * t100 * t31 * t49 - 0.36720684159021185005100000000000000000000000000002e-1 * t108 * t109 * t113 - 0.4e1 / 0.3e1 * t118 * t120 + t33 * t155
  t162 = t17 / t20
  t164 = 0.1e1 / t95 / t32
  t166 = t164 * s0 * t41
  t168 = 0.1e1 / t20 / t65
  t169 = t31 ** 2
  t175 = 0.1e1 / t19 / t110
  t181 = t96 * s0 * t41
  t186 = t24 * s0
  t187 = t96 * t186
  t191 = t31 * t106 * t40
  t195 = 0.1e1 / t105 / t46
  t197 = t34 * t195 * t59
  t198 = t61 * t63
  t199 = t65 * t110
  t201 = 0.1e1 / t19 / t199
  t202 = t25 * t201
  t206 = t41 * t168
  t210 = t164 * t86
  t211 = t210 * s0
  t212 = t206 * t169
  t215 = t96 * t155
  t216 = t215 * t24
  t219 = t25 * t175
  t220 = t219 * t31
  t223 = t117 * s0
  t224 = t206 * t31
  t230 = t36 ** 2
  t231 = 0.1e1 / t230
  t232 = t63 * s0
  t233 = t231 * t232
  t234 = t65 ** 2
  t235 = t234 * t18
  t245 = 0.46913580246913580246913580246913580246913580246914e-3 * t62 * t64 * t201
  t246 = 0.12566666666666666666666666666666666666666666666667e1 * t123 * t202 * t52 - 0.18617283950617283950617283950617283950617283950617e2 * t233 / t235 * t52 + 0.11e2 / 0.27e2 * t56 * t42 * t168 - t245
  t248 = t137 * t140
  t252 = 0.1e1 / t139 / t83
  t253 = t72 * t252
  t254 = t153 ** 2
  t264 = 0.1e1 / t148 / t147
  t268 = 0.50931481481481481481481481481481481481481481481480e-1 * t75 * t219 * t79 + 0.42540156111111111111111111111111111111111111111109e0 * t145 * t206 * t149 - 0.57449421445821236543209876543209876543209876543208e0 * t123 * t202 * t264 + t245
  t270 = -t141 * t268 - 0.2e1 * t248 * t153 + t246 * t84 + 0.2e1 * t253 * t254
  t272 = -0.32e2 / 0.9e1 * t166 * t168 * t169 * t49 - 0.28e2 / 0.9e1 * t98 * t175 * t31 * t49 + 0.16e2 / 0.9e1 * t181 * t168 * t31 * t49 - 0.19584364884811298669386666666666666666666666666668e0 * t187 / t124 * t191 - 0.35825511035830977498098495803833498711111111111115e-2 * t197 * t198 * t202 + 0.13464250858307767835203333333333333333333333333334e0 * t108 * t109 * t206 + 0.32e2 / 0.9e1 * t211 * t212 - 0.8e1 / 0.3e1 * t216 * t120 + 0.28e2 / 0.9e1 * t118 * t220 - 0.16e2 / 0.9e1 * t223 * t224 + t33 * t270
  t276 = t17 * t19
  t278 = 0.1e1 / t19 / t65
  t279 = t25 * t278
  t280 = t279 * t31
  t284 = 0.1e1 / t20 / t66
  t285 = t41 * t284
  t286 = t285 * t31
  t289 = t96 * t270
  t290 = t289 * t24
  t293 = t215 * s0
  t297 = 0.1e1 / t19 / t234
  t298 = t25 * t297
  t303 = 0.1e1 / t234 / t110
  t307 = t63 ** 2
  t308 = t231 * t307
  t309 = t234 * t66
  t314 = t40 * t41 * t52
  t322 = 0.34403292181069958847736625514403292181069958847737e-2 * t62 * t64 * t297
  t323 = -0.10580823045267489711934156378600823045267489711934e2 * t123 * t298 * t52 + 0.35372839506172839506172839506172839506172839506173e3 * t233 * t303 * t52 - 0.20685871056241426611796982167352537722908093278463e3 * t308 / t20 / t309 * t314 - 0.154e3 / 0.81e2 * t56 * t42 * t284 + t322
  t325 = t246 * t140
  t328 = t137 * t252
  t333 = t139 ** 2
  t334 = 0.1e1 / t333
  t335 = t72 * t334
  t336 = t254 * t153
  t339 = t153 * t268
  t351 = t147 ** 2
  t353 = 0.1e1 / t148 / t351
  t357 = -0.16977160493827160493827160493827160493827160493827e0 * t75 * t279 * t79 - 0.22499015898765432098765432098765432098765432098764e1 * t145 * t285 * t149 + 0.70854286449846191736625514403292181069958847736623e1 * t123 * t298 * t264 - 0.69825611693930441054234048790123456790123456790121e2 * t233 * t303 * t353 - t322
  t359 = -t141 * t357 - 0.3e1 * t325 * t153 - 0.3e1 * t248 * t268 + 0.6e1 * t253 * t339 + 0.6e1 * t328 * t254 + t323 * t84 - 0.6e1 * t335 * t336
  t363 = t285 * t169
  t366 = 0.1e1 / t199
  t378 = t186 * t366
  t379 = t378 * t31
  t382 = t105 ** 2
  t383 = 0.1e1 / t382
  t384 = t34 * t383
  t388 = -0.280e3 / 0.27e2 * t118 * t280 + 0.112e3 / 0.9e1 * t223 * t286 - 0.4e1 * t290 * t120 - 0.16e2 / 0.3e1 * t293 * t224 + t33 * t359 + 0.28e2 / 0.3e1 * t216 * t220 - 0.224e3 / 0.9e1 * t211 * t363 + 0.17625928396330168802448000000000000000000000000002e1 * t187 * t366 * t191 + 0.224e3 / 0.9e1 * t166 * t284 * t169 * t49 + 0.280e3 / 0.27e2 * t98 * t278 * t31 * t49 - 0.128e3 / 0.27e2 * t117 * t379 - 0.31456944317221375301436865466528581954162187847672e-2 * t384 * t233 * t303
  t389 = t95 ** 2
  t390 = 0.1e1 / t389
  t391 = t390 * t86
  t392 = t169 * t31
  t393 = t378 * t392
  t396 = t378 * t169
  t399 = t390 * t186
  t404 = t164 * t186
  t413 = t96 * t63
  t417 = t24 * t63
  t418 = t96 * t417
  t419 = t234 * r0
  t426 = t195 * t59 * t61 * t41
  t435 = t164 * t63
  t445 = t164 * t155
  t446 = t445 * s0
  t449 = -0.256e3 / 0.9e1 * t391 * t393 + 0.256e3 / 0.9e1 * t210 * t396 + 0.256e3 / 0.9e1 * t399 * t366 * t392 * t49 - 0.256e3 / 0.9e1 * t404 * t366 * t169 * t49 + 0.128e3 / 0.27e2 * t187 * t366 * t31 * t49 - 0.39168729769622597338773333333333333333333333333336e0 * t413 * t298 * t191 - 0.14330204414332390999239398321533399484444444444446e-1 * t418 / t20 / t419 * t31 * t426 + 0.39408062139414075247908345384216848582222222222226e-1 * t197 * t198 * t298 - 0.62833170672102916564282222222222222222222222222225e0 * t108 * t109 * t285 + 0.78337459539245194677546666666666666666666666666672e0 * t435 * t298 * t169 * t106 * t40 - 0.112e3 / 0.9e1 * t181 * t284 * t31 * t49 + 0.32e2 / 0.3e1 * t446 * t212
  t450 = t388 + t449
  t455 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t23 * t88 + t6 * t94 * t157 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t162 * t272 - 0.3e1 / 0.8e1 * t6 * t276 * t450)
  t477 = 0.1e1 / t20 / t124
  t478 = t41 * t477
  t487 = 0.1e1 / t234
  t493 = 0.1e1 / t234 / t65
  t516 = 0.1e1 / t19 / t419
  t517 = t25 * t516
  t523 = -0.1120e4 / 0.27e2 * t216 * t280 - 0.16e2 / 0.3e1 * t96 * t359 * t24 * t120 - 0.6832e4 / 0.81e2 * t223 * t478 * t31 + 0.448e3 / 0.9e1 * t293 * t286 + 0.35605463380858319386426592592592592592592592592594e1 * t108 * t109 * t478 - 0.14775315285318746440570607407407407407407407407409e2 * t187 * t487 * t191 - 0.76427756876439418662610124381511463917037037037046e-1 * t96 * t232 * t493 * t31 * t195 * t62 + 0.15285551375287883732522024876302292783407407407409e0 * t164 * t232 * t493 * t169 * t195 * t62 - 0.16777036969184733494099661582148577042219833518759e-1 * t96 * t24 * t232 * t25 / t19 / t309 * t31 * t383 * t231 - 0.38970194782309474411820474879947772486864197530868e0 * t197 * t198 * t517 + 0.1024e4 / 0.9e1 * t445 * t396
  t530 = t186 * t487
  t558 = 0.1e1 / t389 / t32
  t561 = t169 ** 2
  t566 = -0.512e3 / 0.27e2 * t215 * t379 - 0.1792e4 / 0.27e2 * t187 * t487 * t31 * t49 + 0.1792e4 / 0.27e2 * t117 * t530 * t31 - 0.3584e4 / 0.9e1 * t210 * t530 * t169 - 0.1024e4 / 0.9e1 * t390 * t155 * t393 + 0.69205277497887025663161104026362880299156813264878e-1 * t384 * t233 * t493 + 0.3584e4 / 0.9e1 * t391 * t530 * t392 - 0.3584e4 / 0.9e1 * t399 * t487 * t392 * t49 + 0.3584e4 / 0.9e1 * t404 * t487 * t169 * t49 - 0.32e2 / 0.3e1 * t289 * s0 * t224 + 0.4096e4 / 0.27e2 * t558 * t86 * t63 * t516 * t561 * t25
  t595 = t516 * t169
  t608 = t25 * t68
  t617 = -0.2048e4 / 0.9e1 * t391 * t63 * t516 * t392 * t25 - 0.4096e4 / 0.27e2 * t558 * t63 * t516 * t561 * t49 * t25 + 0.2048e4 / 0.9e1 * t390 * t63 * t516 * t392 * t49 * t25 - 0.7168e4 / 0.81e2 * t435 * t516 * t169 * t49 * t25 + 0.6832e4 / 0.81e2 * t181 * t477 * t31 * t49 + 0.7168e4 / 0.81e2 * t210 * t63 * t595 * t25 - 0.512e3 / 0.81e2 * t117 * t63 * t517 * t31 + 0.13664e5 / 0.81e2 * t211 * t478 * t169 + 0.56e2 / 0.3e1 * t290 * t220 + 0.3640e4 / 0.81e2 * t118 * t608 * t31 + 0.512e3 / 0.81e2 * t413 * t516 * t25 * t31 * t49
  t640 = 0.1e1 / t20 / t234 / t124
  t641 = t308 * t640
  t646 = t234 ** 2
  t660 = 0.28669410150891632373113854595336076817558299039781e-1 * t62 * t64 * t516
  t681 = t254 ** 2
  t687 = t268 ** 2
  t709 = t39 * t41
  t715 = (0.94544773662551440329218106995884773662551440329217e2 * t123 * t517 * t52 - 0.53017887517146776406035665294924554183813443072702e4 * t233 * t493 * t52 + 0.67573845450388660265203475080018289894833104709647e4 * t641 * t314 - 0.45968602347203170248437738149672306050906873952140e4 * t231 * t307 * s0 / t19 / t646 / r0 * t62 * t25 * t52 + 0.2618e4 / 0.243e3 * t56 * t42 * t477 - t660) * t84 - 0.4e1 * t323 * t140 * t153 + 0.12e2 * t246 * t252 * t254 - 0.6e1 * t325 * t268 - 0.24e2 * t137 * t334 * t336 + 0.24e2 * t328 * t339 - 0.4e1 * t248 * t357 + 0.24e2 * t72 / t333 / t83 * t681 - 0.36e2 * t335 * t254 * t268 + 0.6e1 * t253 * t687 + 0.8e1 * t253 * t153 * t357 - t141 * (0.73567695473251028806584362139917695473251028806584e0 * t75 * t608 * t79 + 0.13631756691604938271604938271604938271604938271604e2 * t145 * t478 * t149 - 0.74237419046100108999725651577503429355281207133056e2 * t123 * t517 * t264 + 0.16292642728583769579321278051028806584362139917695e4 * t233 * t493 * t353 - 0.11787218714710830674330488092370393371742112482853e4 * t641 / t148 / t351 / t147 * t35 * t709 + t660)
  t719 = 0.1e1 / t20 / t235
  t722 = t106 * t35
  t723 = t722 * t709
  t732 = t418 * t719 * t31
  t753 = 0.64e2 / 0.3e1 * t164 * t270 * s0 * t212 - 0.3640e4 / 0.81e2 * t98 * t68 * t31 * t49 - 0.13664e5 / 0.81e2 * t166 * t477 * t169 * t49 - 0.896e3 / 0.9e1 * t446 * t363 + t33 * t715 - 0.41779978420930770494691555555555555555555555555558e1 * t390 * t417 * t719 * t392 * t723 + 0.41779978420930770494691555555555555555555555555558e1 * t164 * t417 * t719 * t169 * t723 - 0.69633297368217950824485925925925925925925925925930e0 * t732 * t723 - 0.13056243256540865779591111111111111111111111111112e2 * t435 * t595 * t722 * t39 * t25 + 0.65281216282704328897955555555555555555555555555561e1 * t413 * t517 * t191 + 0.27705061867709289265196170088297905669925925925929e0 * t732 * t426 - 0.30690090111332360717155426604973008108569762184663e-3 * t34 / t382 / t46 * t308 * t640 * t35 * t709
  t760 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t17 * t112 * t88 - 0.5e1 / 0.9e1 * t6 * t23 * t157 + t6 * t94 * t272 / 0.2e1 - t6 * t162 * t450 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t276 * (t523 + t566 + t617 + t753))
  v4rho4_0_ = 0.2e1 * r0 * t760 + 0.8e1 * t455

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = jnp.sqrt(s0)
  t33 = r0 ** (0.1e1 / 0.3e1)
  t36 = t32 / t33 / r0
  t38 = jnp.exp(-t36 + 0.19e2)
  t39 = 0.1e1 + t38
  t40 = 0.1e1 / t39
  t41 = 0.1e1 - t40
  t42 = 6 ** (0.1e1 / 0.3e1)
  t43 = jnp.pi ** 2
  t44 = t43 ** (0.1e1 / 0.3e1)
  t45 = t44 ** 2
  t46 = 0.1e1 / t45
  t47 = t42 * t46
  t48 = r0 ** 2
  t49 = t33 ** 2
  t51 = 0.1e1 / t49 / t48
  t53 = t47 * s0 * t51
  t55 = 0.1227e1 + 0.91464571985215458333333333333333333333333333333336e-2 * t53
  t58 = 0.2227e1 - 0.1505529e1 / t55
  t61 = jnp.exp(-0.25e2 / 0.6e1 * t53)
  t64 = (0.2743e0 - 0.1508e0 * t61) * t42
  t65 = t46 * s0
  t69 = t42 ** 2
  t71 = 0.1e1 / t44 / t43
  t72 = t69 * t71
  t73 = s0 ** 2
  t74 = t48 ** 2
  t80 = 0.69444444444444444444444444444444444444444444444444e-5 * t72 * t73 / t33 / t74 / r0
  t81 = t64 * t65 * t51 / 0.24e2 - t80
  t83 = t69 / t44
  t86 = jnp.arcsinh(0.64963333333333333333333333333333333333333333333333e0 * t83 * t36)
  t90 = 0.1e1 + 0.16370833333333333333333333333333333333333333333333e-1 * t83 * t36 * t86 + t80
  t91 = 0.1e1 / t90
  t93 = t81 * t91 + 0.1e1
  t95 = t40 * t93 + t41 * t58
  t99 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t100 = t99 * f.p.zeta_threshold
  t102 = f.my_piecewise3(t20, t100, t21 * t19)
  t103 = t30 ** 2
  t104 = 0.1e1 / t103
  t105 = t102 * t104
  t108 = t5 * t105 * t95 / 0.8e1
  t109 = t102 * t30
  t110 = t39 ** 2
  t111 = 0.1e1 / t110
  t112 = t111 * t32
  t114 = 0.1e1 / t33 / t48
  t119 = t55 ** 2
  t120 = 0.1e1 / t119
  t122 = t41 * t120 * t42
  t123 = t48 * r0
  t125 = 0.1e1 / t49 / t123
  t126 = t65 * t125
  t129 = t111 * t93
  t130 = t32 * t114
  t131 = t130 * t38
  t134 = t74 * t48
  t137 = t73 / t33 / t134
  t144 = 0.37037037037037037037037037037037037037037037037037e-4 * t72 * t137
  t145 = -0.69814814814814814814814814814814814814814814814817e-1 * t72 * t137 * t61 - t64 * t126 / 0.9e1 + t144
  t147 = t90 ** 2
  t148 = 0.1e1 / t147
  t149 = t81 * t148
  t155 = 0.1e1 + 0.25321408066666666666666666666666666666666666666666e1 * t53
  t156 = jnp.sqrt(t155)
  t157 = 0.1e1 / t156
  t161 = -0.21827777777777777777777777777777777777777777777777e-1 * t83 * t130 * t86 - 0.85080312222222222222222222222222222222222222222219e-1 * t47 * s0 * t125 * t157 - t144
  t163 = t145 * t91 - t149 * t161
  t165 = 0.4e1 / 0.3e1 * t112 * t114 * t38 * t58 - 0.36720684159021185005100000000000000000000000000002e-1 * t122 * t126 - 0.4e1 / 0.3e1 * t129 * t131 + t40 * t163
  t170 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t95 - t108 - 0.3e1 / 0.8e1 * t5 * t109 * t165)
  t172 = r1 <= f.p.dens_threshold
  t173 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t174 = 0.1e1 + t173
  t175 = t174 <= f.p.zeta_threshold
  t176 = t174 ** (0.1e1 / 0.3e1)
  t178 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t181 = f.my_piecewise3(t175, 0, 0.4e1 / 0.3e1 * t176 * t178)
  t182 = t181 * t30
  t183 = jnp.sqrt(s2)
  t184 = r1 ** (0.1e1 / 0.3e1)
  t187 = t183 / t184 / r1
  t189 = jnp.exp(-t187 + 0.19e2)
  t190 = 0.1e1 + t189
  t191 = 0.1e1 / t190
  t192 = 0.1e1 - t191
  t193 = r1 ** 2
  t194 = t184 ** 2
  t196 = 0.1e1 / t194 / t193
  t198 = t47 * s2 * t196
  t200 = 0.1227e1 + 0.91464571985215458333333333333333333333333333333336e-2 * t198
  t203 = 0.2227e1 - 0.1505529e1 / t200
  t206 = jnp.exp(-0.25e2 / 0.6e1 * t198)
  t209 = (0.2743e0 - 0.1508e0 * t206) * t42
  t210 = t46 * s2
  t214 = s2 ** 2
  t215 = t193 ** 2
  t221 = 0.69444444444444444444444444444444444444444444444444e-5 * t72 * t214 / t184 / t215 / r1
  t222 = t209 * t210 * t196 / 0.24e2 - t221
  t225 = jnp.arcsinh(0.64963333333333333333333333333333333333333333333333e0 * t83 * t187)
  t229 = 0.1e1 + 0.16370833333333333333333333333333333333333333333333e-1 * t83 * t187 * t225 + t221
  t230 = 0.1e1 / t229
  t232 = t222 * t230 + 0.1e1
  t234 = t191 * t232 + t192 * t203
  t239 = f.my_piecewise3(t175, t100, t176 * t174)
  t240 = t239 * t104
  t243 = t5 * t240 * t234 / 0.8e1
  t245 = f.my_piecewise3(t172, 0, -0.3e1 / 0.8e1 * t5 * t182 * t234 - t243)
  t247 = t21 ** 2
  t248 = 0.1e1 / t247
  t249 = t26 ** 2
  t254 = t16 / t22 / t6
  t256 = -0.2e1 * t23 + 0.2e1 * t254
  t257 = f.my_piecewise5(t10, 0, t14, 0, t256)
  t261 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t248 * t249 + 0.4e1 / 0.3e1 * t21 * t257)
  t268 = t5 * t29 * t104 * t95
  t274 = 0.1e1 / t103 / t6
  t278 = t5 * t102 * t274 * t95 / 0.12e2
  t280 = t5 * t105 * t165
  t283 = 0.1e1 / t110 / t39
  t286 = 0.1e1 / t49 / t74
  t287 = t38 ** 2
  t293 = 0.1e1 / t33 / t123
  t318 = 0.1e1 / t33 / t74 / t123
  t322 = t65 * t286
  t326 = s0 * t286
  t333 = t32 * t293
  t340 = t73 * t318
  t344 = t43 ** 2
  t345 = 0.1e1 / t344
  t348 = t74 ** 2
  t357 = 0.23456790123456790123456790123456790123456790123457e-3 * t72 * t340
  t366 = t161 ** 2
  t384 = -0.32e2 / 0.9e1 * t283 * s0 * t286 * t287 * t58 - 0.28e2 / 0.9e1 * t112 * t293 * t38 * t58 + 0.16e2 / 0.9e1 * t111 * s0 * t286 * t38 * t58 - 0.97921824424056493346933333333333333333333333333338e-1 * t111 * t32 * s0 / t134 * t38 * t120 * t47 - 0.17912755517915488749049247901916749355555555555557e-2 * t41 / t119 / t55 * t69 * t71 * t73 * t318 + 0.13464250858307767835203333333333333333333333333334e0 * t122 * t322 + 0.32e2 / 0.9e1 * t283 * t93 * t326 * t287 - 0.8e1 / 0.3e1 * t111 * t163 * t131 + 0.28e2 / 0.9e1 * t129 * t333 * t38 - 0.16e2 / 0.9e1 * t129 * t326 * t38 + t40 * ((0.62833333333333333333333333333333333333333333333335e0 * t72 * t340 * t61 - 0.46543209876543209876543209876543209876543209876545e1 * t345 * t73 * s0 / t348 / t48 * t61 + 0.11e2 / 0.27e2 * t64 * t322 - t357) * t91 - 0.2e1 * t145 * t148 * t161 + 0.2e1 * t81 / t147 / t90 * t366 - t149 * (0.50931481481481481481481481481481481481481481481480e-1 * t83 * t333 * t86 + 0.42540156111111111111111111111111111111111111111109e0 * t47 * t326 * t157 - 0.28724710722910618271604938271604938271604938271604e0 * t72 * t340 / t156 / t155 + t357))
  t389 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t261 * t30 * t95 - t268 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t165 + t278 - t280 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t109 * t384)
  t390 = t176 ** 2
  t391 = 0.1e1 / t390
  t392 = t178 ** 2
  t396 = f.my_piecewise5(t14, 0, t10, 0, -t256)
  t400 = f.my_piecewise3(t175, 0, 0.4e1 / 0.9e1 * t391 * t392 + 0.4e1 / 0.3e1 * t176 * t396)
  t407 = t5 * t181 * t104 * t234
  t412 = t5 * t239 * t274 * t234 / 0.12e2
  t414 = f.my_piecewise3(t172, 0, -0.3e1 / 0.8e1 * t5 * t400 * t30 * t234 - t407 / 0.4e1 + t412)
  d11 = 0.2e1 * t170 + 0.2e1 * t245 + t6 * (t389 + t414)
  t417 = -t7 - t24
  t418 = f.my_piecewise5(t10, 0, t14, 0, t417)
  t421 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t418)
  t422 = t421 * t30
  t427 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t422 * t95 - t108)
  t429 = f.my_piecewise5(t14, 0, t10, 0, -t417)
  t432 = f.my_piecewise3(t175, 0, 0.4e1 / 0.3e1 * t176 * t429)
  t433 = t432 * t30
  t437 = t239 * t30
  t438 = t190 ** 2
  t439 = 0.1e1 / t438
  t440 = t439 * t183
  t442 = 0.1e1 / t184 / t193
  t447 = t200 ** 2
  t448 = 0.1e1 / t447
  t450 = t192 * t448 * t42
  t451 = t193 * r1
  t453 = 0.1e1 / t194 / t451
  t454 = t210 * t453
  t457 = t439 * t232
  t458 = t183 * t442
  t459 = t458 * t189
  t462 = t215 * t193
  t465 = t214 / t184 / t462
  t472 = 0.37037037037037037037037037037037037037037037037037e-4 * t72 * t465
  t473 = -0.69814814814814814814814814814814814814814814814817e-1 * t72 * t465 * t206 - t209 * t454 / 0.9e1 + t472
  t475 = t229 ** 2
  t476 = 0.1e1 / t475
  t477 = t222 * t476
  t483 = 0.1e1 + 0.25321408066666666666666666666666666666666666666666e1 * t198
  t484 = jnp.sqrt(t483)
  t485 = 0.1e1 / t484
  t489 = -0.21827777777777777777777777777777777777777777777777e-1 * t83 * t458 * t225 - 0.85080312222222222222222222222222222222222222222219e-1 * t47 * s2 * t453 * t485 - t472
  t491 = t473 * t230 - t477 * t489
  t493 = 0.4e1 / 0.3e1 * t440 * t442 * t189 * t203 - 0.36720684159021185005100000000000000000000000000002e-1 * t450 * t454 - 0.4e1 / 0.3e1 * t457 * t459 + t191 * t491
  t498 = f.my_piecewise3(t172, 0, -0.3e1 / 0.8e1 * t5 * t433 * t234 - t243 - 0.3e1 / 0.8e1 * t5 * t437 * t493)
  t502 = 0.2e1 * t254
  t503 = f.my_piecewise5(t10, 0, t14, 0, t502)
  t507 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t248 * t418 * t26 + 0.4e1 / 0.3e1 * t21 * t503)
  t514 = t5 * t421 * t104 * t95
  t522 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t507 * t30 * t95 - t514 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t422 * t165 - t268 / 0.8e1 + t278 - t280 / 0.8e1)
  t526 = f.my_piecewise5(t14, 0, t10, 0, -t502)
  t530 = f.my_piecewise3(t175, 0, 0.4e1 / 0.9e1 * t391 * t429 * t178 + 0.4e1 / 0.3e1 * t176 * t526)
  t537 = t5 * t432 * t104 * t234
  t544 = t5 * t240 * t493
  t547 = f.my_piecewise3(t172, 0, -0.3e1 / 0.8e1 * t5 * t530 * t30 * t234 - t537 / 0.8e1 - t407 / 0.8e1 + t412 - 0.3e1 / 0.8e1 * t5 * t182 * t493 - t544 / 0.8e1)
  d12 = t170 + t245 + t427 + t498 + t6 * (t522 + t547)
  t552 = t418 ** 2
  t556 = 0.2e1 * t23 + 0.2e1 * t254
  t557 = f.my_piecewise5(t10, 0, t14, 0, t556)
  t561 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t248 * t552 + 0.4e1 / 0.3e1 * t21 * t557)
  t568 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t561 * t30 * t95 - t514 / 0.4e1 + t278)
  t569 = t429 ** 2
  t573 = f.my_piecewise5(t14, 0, t10, 0, -t556)
  t577 = f.my_piecewise3(t175, 0, 0.4e1 / 0.9e1 * t391 * t569 + 0.4e1 / 0.3e1 * t176 * t573)
  t588 = 0.1e1 / t438 / t190
  t591 = 0.1e1 / t194 / t215
  t592 = t189 ** 2
  t598 = 0.1e1 / t184 / t451
  t623 = 0.1e1 / t184 / t215 / t451
  t627 = t210 * t591
  t631 = s2 * t591
  t638 = t183 * t598
  t645 = t214 * t623
  t651 = t215 ** 2
  t660 = 0.23456790123456790123456790123456790123456790123457e-3 * t72 * t645
  t669 = t489 ** 2
  t687 = -0.32e2 / 0.9e1 * t588 * s2 * t591 * t592 * t203 - 0.28e2 / 0.9e1 * t440 * t598 * t189 * t203 + 0.16e2 / 0.9e1 * t439 * s2 * t591 * t189 * t203 - 0.97921824424056493346933333333333333333333333333338e-1 * t439 * t183 * s2 / t462 * t189 * t448 * t47 - 0.17912755517915488749049247901916749355555555555557e-2 * t192 / t447 / t200 * t69 * t71 * t214 * t623 + 0.13464250858307767835203333333333333333333333333334e0 * t450 * t627 + 0.32e2 / 0.9e1 * t588 * t232 * t631 * t592 - 0.8e1 / 0.3e1 * t439 * t491 * t459 + 0.28e2 / 0.9e1 * t457 * t638 * t189 - 0.16e2 / 0.9e1 * t457 * t631 * t189 + t191 * ((0.62833333333333333333333333333333333333333333333335e0 * t72 * t645 * t206 - 0.46543209876543209876543209876543209876543209876545e1 * t345 * t214 * s2 / t651 / t193 * t206 + 0.11e2 / 0.27e2 * t209 * t627 - t660) * t230 - 0.2e1 * t473 * t476 * t489 + 0.2e1 * t222 / t475 / t229 * t669 - t477 * (0.50931481481481481481481481481481481481481481481480e-1 * t83 * t638 * t225 + 0.42540156111111111111111111111111111111111111111109e0 * t47 * t631 * t485 - 0.28724710722910618271604938271604938271604938271604e0 * t72 * t645 / t484 / t483 + t660))
  t692 = f.my_piecewise3(t172, 0, -0.3e1 / 0.8e1 * t5 * t577 * t30 * t234 - t537 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t433 * t493 + t412 - t544 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t437 * t687)
  d22 = 0.2e1 * t427 + 0.2e1 * t498 + t6 * (t568 + t692)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = jnp.sqrt(s0)
  t45 = r0 ** (0.1e1 / 0.3e1)
  t48 = t44 / t45 / r0
  t50 = jnp.exp(-t48 + 0.19e2)
  t51 = 0.1e1 + t50
  t52 = 0.1e1 / t51
  t53 = 0.1e1 - t52
  t54 = 6 ** (0.1e1 / 0.3e1)
  t55 = jnp.pi ** 2
  t56 = t55 ** (0.1e1 / 0.3e1)
  t57 = t56 ** 2
  t58 = 0.1e1 / t57
  t59 = t54 * t58
  t60 = r0 ** 2
  t61 = t45 ** 2
  t63 = 0.1e1 / t61 / t60
  t65 = t59 * s0 * t63
  t67 = 0.1227e1 + 0.91464571985215458333333333333333333333333333333336e-2 * t65
  t70 = 0.2227e1 - 0.1505529e1 / t67
  t73 = jnp.exp(-0.25e2 / 0.6e1 * t65)
  t76 = (0.2743e0 - 0.1508e0 * t73) * t54
  t77 = t58 * s0
  t81 = t54 ** 2
  t83 = 0.1e1 / t56 / t55
  t84 = t81 * t83
  t85 = s0 ** 2
  t86 = t60 ** 2
  t87 = t86 * r0
  t92 = 0.69444444444444444444444444444444444444444444444444e-5 * t84 * t85 / t45 / t87
  t93 = t76 * t77 * t63 / 0.24e2 - t92
  t95 = t81 / t56
  t98 = jnp.asinh(0.64963333333333333333333333333333333333333333333333e0 * t95 * t48)
  t102 = 0.1e1 + 0.16370833333333333333333333333333333333333333333333e-1 * t95 * t48 * t98 + t92
  t103 = 0.1e1 / t102
  t105 = t93 * t103 + 0.1e1
  t107 = t52 * t105 + t53 * t70
  t113 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t114 = t42 ** 2
  t115 = 0.1e1 / t114
  t116 = t113 * t115
  t120 = t113 * t42
  t121 = t51 ** 2
  t122 = 0.1e1 / t121
  t123 = t122 * t44
  t125 = 0.1e1 / t45 / t60
  t130 = t67 ** 2
  t131 = 0.1e1 / t130
  t133 = t53 * t131 * t54
  t134 = t60 * r0
  t136 = 0.1e1 / t61 / t134
  t137 = t77 * t136
  t140 = t122 * t105
  t141 = t44 * t125
  t142 = t141 * t50
  t145 = t86 * t60
  t148 = t85 / t45 / t145
  t155 = 0.37037037037037037037037037037037037037037037037037e-4 * t84 * t148
  t156 = -0.69814814814814814814814814814814814814814814814817e-1 * t84 * t148 * t73 - t76 * t137 / 0.9e1 + t155
  t158 = t102 ** 2
  t159 = 0.1e1 / t158
  t160 = t93 * t159
  t166 = 0.1e1 + 0.25321408066666666666666666666666666666666666666666e1 * t65
  t167 = jnp.sqrt(t166)
  t168 = 0.1e1 / t167
  t172 = -0.21827777777777777777777777777777777777777777777777e-1 * t95 * t141 * t98 - 0.85080312222222222222222222222222222222222222222219e-1 * t59 * s0 * t136 * t168 - t155
  t174 = t156 * t103 - t160 * t172
  t176 = 0.4e1 / 0.3e1 * t123 * t125 * t50 * t70 - 0.36720684159021185005100000000000000000000000000002e-1 * t133 * t137 - 0.4e1 / 0.3e1 * t140 * t142 + t52 * t174
  t180 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t181 = t180 * f.p.zeta_threshold
  t183 = f.my_piecewise3(t20, t181, t21 * t19)
  t185 = 0.1e1 / t114 / t6
  t186 = t183 * t185
  t190 = t183 * t115
  t194 = t183 * t42
  t196 = 0.1e1 / t121 / t51
  t197 = t196 * s0
  t199 = 0.1e1 / t61 / t86
  t200 = t50 ** 2
  t206 = 0.1e1 / t45 / t134
  t211 = t122 * s0
  t216 = t44 * s0
  t217 = t122 * t216
  t221 = t50 * t131 * t59
  t225 = 0.1e1 / t130 / t67
  t227 = t53 * t225 * t81
  t228 = t83 * t85
  t229 = t86 * t134
  t231 = 0.1e1 / t45 / t229
  t235 = t77 * t199
  t238 = t196 * t105
  t239 = s0 * t199
  t240 = t239 * t200
  t243 = t122 * t174
  t246 = t44 * t206
  t247 = t246 * t50
  t250 = t239 * t50
  t253 = t85 * t231
  t257 = t55 ** 2
  t258 = 0.1e1 / t257
  t260 = t258 * t85 * s0
  t261 = t86 ** 2
  t270 = 0.23456790123456790123456790123456790123456790123457e-3 * t84 * t253
  t271 = 0.62833333333333333333333333333333333333333333333335e0 * t84 * t253 * t73 - 0.46543209876543209876543209876543209876543209876545e1 * t260 / t261 / t60 * t73 + 0.11e2 / 0.27e2 * t76 * t235 - t270
  t273 = t156 * t159
  t277 = 0.1e1 / t158 / t102
  t278 = t93 * t277
  t279 = t172 ** 2
  t289 = 0.1e1 / t167 / t166
  t293 = 0.50931481481481481481481481481481481481481481481480e-1 * t95 * t246 * t98 + 0.42540156111111111111111111111111111111111111111109e0 * t59 * t239 * t168 - 0.28724710722910618271604938271604938271604938271604e0 * t84 * t253 * t289 + t270
  t295 = t271 * t103 - t160 * t293 - 0.2e1 * t273 * t172 + 0.2e1 * t278 * t279
  t297 = -0.32e2 / 0.9e1 * t197 * t199 * t200 * t70 - 0.28e2 / 0.9e1 * t123 * t206 * t50 * t70 + 0.16e2 / 0.9e1 * t211 * t199 * t50 * t70 - 0.97921824424056493346933333333333333333333333333338e-1 * t217 / t145 * t221 - 0.17912755517915488749049247901916749355555555555557e-2 * t227 * t228 * t231 + 0.13464250858307767835203333333333333333333333333334e0 * t133 * t235 + 0.32e2 / 0.9e1 * t238 * t240 - 0.8e1 / 0.3e1 * t243 * t142 + 0.28e2 / 0.9e1 * t140 * t247 - 0.16e2 / 0.9e1 * t140 * t250 + t52 * t295
  t302 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t107 - t5 * t116 * t107 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t120 * t176 + t5 * t186 * t107 / 0.12e2 - t5 * t190 * t176 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t194 * t297)
  t304 = r1 <= f.p.dens_threshold
  t305 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t306 = 0.1e1 + t305
  t307 = t306 <= f.p.zeta_threshold
  t308 = t306 ** (0.1e1 / 0.3e1)
  t309 = t308 ** 2
  t310 = 0.1e1 / t309
  t312 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t313 = t312 ** 2
  t317 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t321 = f.my_piecewise3(t307, 0, 0.4e1 / 0.9e1 * t310 * t313 + 0.4e1 / 0.3e1 * t308 * t317)
  t323 = jnp.sqrt(s2)
  t324 = r1 ** (0.1e1 / 0.3e1)
  t327 = t323 / t324 / r1
  t329 = jnp.exp(-t327 + 0.19e2)
  t331 = 0.1e1 / (0.1e1 + t329)
  t333 = r1 ** 2
  t334 = t324 ** 2
  t336 = 0.1e1 / t334 / t333
  t338 = t59 * s2 * t336
  t346 = jnp.exp(-0.25e2 / 0.6e1 * t338)
  t354 = s2 ** 2
  t355 = t333 ** 2
  t361 = 0.69444444444444444444444444444444444444444444444444e-5 * t84 * t354 / t324 / t355 / r1
  t365 = jnp.asinh(0.64963333333333333333333333333333333333333333333333e0 * t95 * t327)
  t374 = (0.1e1 - t331) * (0.2227e1 - 0.1505529e1 / (0.1227e1 + 0.91464571985215458333333333333333333333333333333336e-2 * t338)) + t331 * (0.1e1 + ((0.2743e0 - 0.1508e0 * t346) * t54 * t58 * s2 * t336 / 0.24e2 - t361) / (0.1e1 + 0.16370833333333333333333333333333333333333333333333e-1 * t95 * t327 * t365 + t361))
  t380 = f.my_piecewise3(t307, 0, 0.4e1 / 0.3e1 * t308 * t312)
  t386 = f.my_piecewise3(t307, t181, t308 * t306)
  t392 = f.my_piecewise3(t304, 0, -0.3e1 / 0.8e1 * t5 * t321 * t42 * t374 - t5 * t380 * t115 * t374 / 0.4e1 + t5 * t386 * t185 * t374 / 0.12e2)
  t402 = t24 ** 2
  t406 = 0.6e1 * t33 - 0.6e1 * t16 / t402
  t407 = f.my_piecewise5(t10, 0, t14, 0, t406)
  t411 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t407)
  t434 = 0.1e1 / t114 / t24
  t446 = 0.1e1 / t45 / t86
  t447 = t44 * t446
  t458 = 0.1e1 / t61 / t87
  t459 = s0 * t458
  t468 = 0.1e1 / t45 / t261
  t469 = t85 * t468
  t474 = 0.1e1 / t261 / t134
  t478 = t85 ** 2
  t487 = t77 * t458
  t491 = 0.17201646090534979423868312757201646090534979423868e-2 * t84 * t469
  t502 = t158 ** 2
  t520 = t166 ** 2
  t535 = 0.1e1 / t229
  t536 = t216 * t535
  t540 = t130 ** 2
  t549 = t121 ** 2
  t550 = 0.1e1 / t549
  t552 = t200 * t50
  t556 = -0.280e3 / 0.27e2 * t140 * t447 * t50 + 0.28e2 / 0.3e1 * t243 * t247 + 0.280e3 / 0.27e2 * t123 * t446 * t50 * t70 - 0.224e3 / 0.9e1 * t238 * t459 * t200 + 0.224e3 / 0.9e1 * t197 * t458 * t200 * t70 + t52 * ((-0.52904115226337448559670781893004115226337448559672e1 * t84 * t469 * t73 + 0.88432098765432098765432098765432098765432098765435e2 * t260 * t474 * t73 - 0.51714677640603566529492455418381344307270233196161e2 * t258 * t478 / t61 / t261 / t87 * t59 * t73 - 0.154e3 / 0.81e2 * t76 * t487 + t491) * t103 - 0.3e1 * t271 * t159 * t172 + 0.6e1 * t156 * t277 * t279 - 0.3e1 * t273 * t293 - 0.6e1 * t93 / t502 * t279 * t172 + 0.6e1 * t278 * t172 * t293 - t160 * (-0.16977160493827160493827160493827160493827160493827e0 * t95 * t447 * t98 - 0.22499015898765432098765432098765432098765432098764e1 * t59 * t459 * t168 + 0.35427143224923095868312757201646090534979423868312e1 * t84 * t469 * t289 - 0.17456402923482610263558512197530864197530864197530e2 * t260 * t474 / t167 / t520 - t491)) - 0.16e2 / 0.3e1 * t243 * t250 + 0.112e3 / 0.9e1 * t140 * t459 * t50 - 0.64e2 / 0.27e2 * t140 * t536 * t50 - 0.78642360793053438253592163666321454885405469619178e-3 * t53 / t540 * t260 * t474 + 0.32e2 / 0.3e1 * t196 * t174 * t240 - 0.128e3 / 0.9e1 * t550 * t105 * t536 * t552
  t609 = 0.128e3 / 0.9e1 * t238 * t536 * t200 - 0.4e1 * t122 * t295 * t142 + 0.128e3 / 0.9e1 * t550 * t216 * t535 * t552 * t70 - 0.128e3 / 0.9e1 * t196 * t216 * t535 * t200 * t70 - 0.112e3 / 0.9e1 * t211 * t458 * t50 * t70 + 0.64e2 / 0.27e2 * t217 * t535 * t50 * t70 + 0.39168729769622597338773333333333333333333333333335e0 * t196 * t85 * t468 * t200 * t131 * t59 + 0.88129641981650844012240000000000000000000000000005e0 * t217 * t535 * t221 - 0.19584364884811298669386666666666666666666666666668e0 * t122 * t85 * t468 * t221 - 0.71651022071661954996196991607666997422222222222229e-2 * t122 * t44 * t85 / t61 / t261 / r0 * t50 * t225 * t84 + 0.19704031069707037623954172692108424291111111111113e-1 * t227 * t228 * t468 - 0.62833170672102916564282222222222222222222222222225e0 * t133 * t487
  t615 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t411 * t42 * t107 - 0.3e1 / 0.8e1 * t5 * t41 * t115 * t107 - 0.9e1 / 0.8e1 * t5 * t43 * t176 + t5 * t113 * t185 * t107 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t116 * t176 - 0.9e1 / 0.8e1 * t5 * t120 * t297 - 0.5e1 / 0.36e2 * t5 * t183 * t434 * t107 + t5 * t186 * t176 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t190 * t297 - 0.3e1 / 0.8e1 * t5 * t194 * (t556 + t609))
  t625 = f.my_piecewise5(t14, 0, t10, 0, -t406)
  t629 = f.my_piecewise3(t307, 0, -0.8e1 / 0.27e2 / t309 / t306 * t313 * t312 + 0.4e1 / 0.3e1 * t310 * t312 * t317 + 0.4e1 / 0.3e1 * t308 * t625)
  t647 = f.my_piecewise3(t304, 0, -0.3e1 / 0.8e1 * t5 * t629 * t42 * t374 - 0.3e1 / 0.8e1 * t5 * t321 * t115 * t374 + t5 * t380 * t185 * t374 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t386 * t434 * t374)
  d111 = 0.3e1 * t302 + 0.3e1 * t392 + t6 * (t615 + t647)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 0.1e1 / t22 / t19
  t25 = t6 ** 2
  t26 = 0.1e1 / t25
  t28 = -t16 * t26 + t7
  t29 = f.my_piecewise5(t10, 0, t14, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t6
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t16 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t10, 0, t14, 0, t40)
  t44 = t25 ** 2
  t45 = 0.1e1 / t44
  t48 = -0.6e1 * t16 * t45 + 0.6e1 * t37
  t49 = f.my_piecewise5(t10, 0, t14, 0, t48)
  t53 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t24 * t30 * t29 + 0.4e1 / 0.3e1 * t35 * t41 + 0.4e1 / 0.3e1 * t21 * t49)
  t54 = t6 ** (0.1e1 / 0.3e1)
  t55 = t53 * t54
  t56 = jnp.sqrt(s0)
  t57 = r0 ** (0.1e1 / 0.3e1)
  t60 = t56 / t57 / r0
  t62 = jnp.exp(-t60 + 0.19e2)
  t63 = 0.1e1 + t62
  t64 = 0.1e1 / t63
  t65 = 0.1e1 - t64
  t66 = 6 ** (0.1e1 / 0.3e1)
  t67 = jnp.pi ** 2
  t68 = t67 ** (0.1e1 / 0.3e1)
  t69 = t68 ** 2
  t70 = 0.1e1 / t69
  t71 = t66 * t70
  t72 = r0 ** 2
  t73 = t57 ** 2
  t75 = 0.1e1 / t73 / t72
  t77 = t71 * s0 * t75
  t79 = 0.1227e1 + 0.91464571985215458333333333333333333333333333333336e-2 * t77
  t82 = 0.2227e1 - 0.1505529e1 / t79
  t85 = jnp.exp(-0.25e2 / 0.6e1 * t77)
  t88 = (0.2743e0 - 0.1508e0 * t85) * t66
  t89 = t70 * s0
  t93 = t66 ** 2
  t95 = 0.1e1 / t68 / t67
  t96 = t93 * t95
  t97 = s0 ** 2
  t98 = t72 ** 2
  t99 = t98 * r0
  t101 = 0.1e1 / t57 / t99
  t104 = 0.69444444444444444444444444444444444444444444444444e-5 * t96 * t97 * t101
  t105 = t88 * t89 * t75 / 0.24e2 - t104
  t107 = t93 / t68
  t110 = jnp.asinh(0.64963333333333333333333333333333333333333333333333e0 * t107 * t60)
  t114 = 0.1e1 + 0.16370833333333333333333333333333333333333333333333e-1 * t107 * t60 * t110 + t104
  t115 = 0.1e1 / t114
  t117 = t105 * t115 + 0.1e1
  t119 = t64 * t117 + t65 * t82
  t128 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t34 * t30 + 0.4e1 / 0.3e1 * t21 * t41)
  t129 = t54 ** 2
  t130 = 0.1e1 / t129
  t131 = t128 * t130
  t135 = t128 * t54
  t136 = t63 ** 2
  t137 = 0.1e1 / t136
  t138 = t137 * t56
  t140 = 0.1e1 / t57 / t72
  t145 = t79 ** 2
  t146 = 0.1e1 / t145
  t148 = t65 * t146 * t66
  t149 = t72 * r0
  t151 = 0.1e1 / t73 / t149
  t152 = t89 * t151
  t155 = t137 * t117
  t156 = t56 * t140
  t157 = t156 * t62
  t160 = t98 * t72
  t163 = t97 / t57 / t160
  t170 = 0.37037037037037037037037037037037037037037037037037e-4 * t96 * t163
  t171 = -0.69814814814814814814814814814814814814814814814817e-1 * t96 * t163 * t85 - t88 * t152 / 0.9e1 + t170
  t173 = t114 ** 2
  t174 = 0.1e1 / t173
  t175 = t105 * t174
  t181 = 0.1e1 + 0.25321408066666666666666666666666666666666666666666e1 * t77
  t182 = jnp.sqrt(t181)
  t183 = 0.1e1 / t182
  t187 = -0.21827777777777777777777777777777777777777777777777e-1 * t107 * t156 * t110 - 0.85080312222222222222222222222222222222222222222219e-1 * t71 * s0 * t151 * t183 - t170
  t189 = t171 * t115 - t175 * t187
  t191 = 0.4e1 / 0.3e1 * t138 * t140 * t62 * t82 - 0.36720684159021185005100000000000000000000000000002e-1 * t148 * t152 - 0.4e1 / 0.3e1 * t155 * t157 + t64 * t189
  t197 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t29)
  t199 = 0.1e1 / t129 / t6
  t200 = t197 * t199
  t204 = t197 * t130
  t208 = t197 * t54
  t210 = 0.1e1 / t136 / t63
  t211 = t210 * s0
  t213 = 0.1e1 / t73 / t98
  t214 = t62 ** 2
  t220 = 0.1e1 / t57 / t149
  t225 = t137 * s0
  t230 = t56 * s0
  t231 = t137 * t230
  t235 = t62 * t146 * t71
  t239 = 0.1e1 / t145 / t79
  t241 = t65 * t239 * t93
  t242 = t95 * t97
  t243 = t98 * t149
  t245 = 0.1e1 / t57 / t243
  t249 = t89 * t213
  t252 = t210 * t117
  t253 = s0 * t213
  t254 = t253 * t214
  t257 = t137 * t189
  t260 = t56 * t220
  t261 = t260 * t62
  t264 = t253 * t62
  t267 = t97 * t245
  t271 = t67 ** 2
  t272 = 0.1e1 / t271
  t273 = t97 * s0
  t274 = t272 * t273
  t275 = t98 ** 2
  t276 = t275 * t72
  t284 = 0.23456790123456790123456790123456790123456790123457e-3 * t96 * t267
  t285 = 0.62833333333333333333333333333333333333333333333335e0 * t96 * t267 * t85 - 0.46543209876543209876543209876543209876543209876545e1 * t274 / t276 * t85 + 0.11e2 / 0.27e2 * t88 * t249 - t284
  t287 = t171 * t174
  t291 = 0.1e1 / t173 / t114
  t292 = t105 * t291
  t293 = t187 ** 2
  t303 = 0.1e1 / t182 / t181
  t307 = 0.50931481481481481481481481481481481481481481481480e-1 * t107 * t260 * t110 + 0.42540156111111111111111111111111111111111111111109e0 * t71 * t253 * t183 - 0.28724710722910618271604938271604938271604938271604e0 * t96 * t267 * t303 + t284
  t309 = t285 * t115 - t175 * t307 - 0.2e1 * t287 * t187 + 0.2e1 * t292 * t293
  t311 = -0.32e2 / 0.9e1 * t211 * t213 * t214 * t82 - 0.28e2 / 0.9e1 * t138 * t220 * t62 * t82 + 0.16e2 / 0.9e1 * t225 * t213 * t62 * t82 - 0.97921824424056493346933333333333333333333333333338e-1 * t231 / t160 * t235 - 0.17912755517915488749049247901916749355555555555557e-2 * t241 * t242 * t245 + 0.13464250858307767835203333333333333333333333333334e0 * t148 * t249 + 0.32e2 / 0.9e1 * t252 * t254 - 0.8e1 / 0.3e1 * t257 * t157 + 0.28e2 / 0.9e1 * t155 * t261 - 0.16e2 / 0.9e1 * t155 * t264 + t64 * t309
  t315 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t316 = t315 * f.p.zeta_threshold
  t318 = f.my_piecewise3(t20, t316, t21 * t19)
  t320 = 0.1e1 / t129 / t25
  t321 = t318 * t320
  t325 = t318 * t199
  t329 = t318 * t130
  t333 = t318 * t54
  t335 = 0.1e1 / t57 / t98
  t336 = t56 * t335
  t337 = t336 * t62
  t347 = 0.1e1 / t73 / t99
  t348 = s0 * t347
  t349 = t348 * t214
  t357 = 0.1e1 / t57 / t275
  t358 = t97 * t357
  t363 = 0.1e1 / t275 / t149
  t367 = t97 ** 2
  t368 = t272 * t367
  t369 = t275 * t99
  t373 = t71 * t85
  t376 = t89 * t347
  t380 = 0.17201646090534979423868312757201646090534979423868e-2 * t96 * t358
  t381 = -0.52904115226337448559670781893004115226337448559672e1 * t96 * t358 * t85 + 0.88432098765432098765432098765432098765432098765435e2 * t274 * t363 * t85 - 0.51714677640603566529492455418381344307270233196161e2 * t368 / t73 / t369 * t373 - 0.154e3 / 0.81e2 * t88 * t376 + t380
  t383 = t285 * t174
  t386 = t171 * t291
  t391 = t173 ** 2
  t392 = 0.1e1 / t391
  t393 = t105 * t392
  t394 = t293 * t187
  t397 = t187 * t307
  t409 = t181 ** 2
  t411 = 0.1e1 / t182 / t409
  t415 = -0.16977160493827160493827160493827160493827160493827e0 * t107 * t336 * t110 - 0.22499015898765432098765432098765432098765432098764e1 * t71 * t348 * t183 + 0.35427143224923095868312757201646090534979423868312e1 * t96 * t358 * t303 - 0.17456402923482610263558512197530864197530864197530e2 * t274 * t363 * t411 - t380
  t417 = t381 * t115 - t175 * t415 - 0.3e1 * t383 * t187 - 0.3e1 * t287 * t307 + 0.6e1 * t292 * t397 + 0.6e1 * t386 * t293 - 0.6e1 * t393 * t394
  t421 = t348 * t62
  t424 = 0.1e1 / t243
  t425 = t230 * t424
  t426 = t425 * t62
  t429 = t145 ** 2
  t430 = 0.1e1 / t429
  t431 = t65 * t430
  t435 = t210 * t189
  t438 = t136 ** 2
  t439 = 0.1e1 / t438
  t440 = t439 * t117
  t441 = t214 * t62
  t442 = t425 * t441
  t445 = -0.280e3 / 0.27e2 * t155 * t337 + 0.28e2 / 0.3e1 * t257 * t261 + 0.280e3 / 0.27e2 * t138 * t335 * t62 * t82 - 0.224e3 / 0.9e1 * t252 * t349 + 0.224e3 / 0.9e1 * t211 * t347 * t214 * t82 + t64 * t417 - 0.16e2 / 0.3e1 * t257 * t264 + 0.112e3 / 0.9e1 * t155 * t421 - 0.64e2 / 0.27e2 * t155 * t426 - 0.78642360793053438253592163666321454885405469619178e-3 * t431 * t274 * t363 + 0.32e2 / 0.3e1 * t435 * t254 - 0.128e3 / 0.9e1 * t440 * t442
  t446 = t425 * t214
  t449 = t137 * t309
  t452 = t439 * t230
  t457 = t210 * t230
  t470 = t210 * t97
  t473 = t214 * t146 * t71
  t479 = t137 * t97
  t483 = t56 * t97
  t484 = t137 * t483
  t485 = t275 * r0
  t490 = t62 * t239 * t96
  t498 = 0.128e3 / 0.9e1 * t252 * t446 - 0.4e1 * t449 * t157 + 0.128e3 / 0.9e1 * t452 * t424 * t441 * t82 - 0.128e3 / 0.9e1 * t457 * t424 * t214 * t82 - 0.112e3 / 0.9e1 * t225 * t347 * t62 * t82 + 0.64e2 / 0.27e2 * t231 * t424 * t62 * t82 + 0.39168729769622597338773333333333333333333333333335e0 * t470 * t357 * t473 + 0.88129641981650844012240000000000000000000000000005e0 * t231 * t424 * t235 - 0.19584364884811298669386666666666666666666666666668e0 * t479 * t357 * t235 - 0.71651022071661954996196991607666997422222222222229e-2 * t484 / t73 / t485 * t490 + 0.19704031069707037623954172692108424291111111111113e-1 * t241 * t242 * t357 - 0.62833170672102916564282222222222222222222222222225e0 * t148 * t376
  t499 = t445 + t498
  t504 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t55 * t119 - 0.3e1 / 0.8e1 * t5 * t131 * t119 - 0.9e1 / 0.8e1 * t5 * t135 * t191 + t5 * t200 * t119 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t204 * t191 - 0.9e1 / 0.8e1 * t5 * t208 * t311 - 0.5e1 / 0.36e2 * t5 * t321 * t119 + t5 * t325 * t191 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t329 * t311 - 0.3e1 / 0.8e1 * t5 * t333 * t499)
  t506 = r1 <= f.p.dens_threshold
  t507 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t508 = 0.1e1 + t507
  t509 = t508 <= f.p.zeta_threshold
  t510 = t508 ** (0.1e1 / 0.3e1)
  t511 = t510 ** 2
  t513 = 0.1e1 / t511 / t508
  t515 = f.my_piecewise5(t14, 0, t10, 0, -t28)
  t516 = t515 ** 2
  t520 = 0.1e1 / t511
  t521 = t520 * t515
  t523 = f.my_piecewise5(t14, 0, t10, 0, -t40)
  t527 = f.my_piecewise5(t14, 0, t10, 0, -t48)
  t531 = f.my_piecewise3(t509, 0, -0.8e1 / 0.27e2 * t513 * t516 * t515 + 0.4e1 / 0.3e1 * t521 * t523 + 0.4e1 / 0.3e1 * t510 * t527)
  t533 = jnp.sqrt(s2)
  t534 = r1 ** (0.1e1 / 0.3e1)
  t537 = t533 / t534 / r1
  t539 = jnp.exp(-t537 + 0.19e2)
  t541 = 0.1e1 / (0.1e1 + t539)
  t543 = r1 ** 2
  t544 = t534 ** 2
  t546 = 0.1e1 / t544 / t543
  t548 = t71 * s2 * t546
  t556 = jnp.exp(-0.25e2 / 0.6e1 * t548)
  t564 = s2 ** 2
  t565 = t543 ** 2
  t571 = 0.69444444444444444444444444444444444444444444444444e-5 * t96 * t564 / t534 / t565 / r1
  t575 = jnp.asinh(0.64963333333333333333333333333333333333333333333333e0 * t107 * t537)
  t584 = (0.1e1 - t541) * (0.2227e1 - 0.1505529e1 / (0.1227e1 + 0.91464571985215458333333333333333333333333333333336e-2 * t548)) + t541 * (0.1e1 + ((0.2743e0 - 0.1508e0 * t556) * t66 * t70 * s2 * t546 / 0.24e2 - t571) / (0.1e1 + 0.16370833333333333333333333333333333333333333333333e-1 * t107 * t537 * t575 + t571))
  t593 = f.my_piecewise3(t509, 0, 0.4e1 / 0.9e1 * t520 * t516 + 0.4e1 / 0.3e1 * t510 * t523)
  t600 = f.my_piecewise3(t509, 0, 0.4e1 / 0.3e1 * t510 * t515)
  t606 = f.my_piecewise3(t509, t316, t510 * t508)
  t612 = f.my_piecewise3(t506, 0, -0.3e1 / 0.8e1 * t5 * t531 * t54 * t584 - 0.3e1 / 0.8e1 * t5 * t593 * t130 * t584 + t5 * t600 * t199 * t584 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t606 * t320 * t584)
  t616 = 0.1e1 / t73 / t276
  t621 = 0.1e1 / t57 / t485
  t625 = t484 * t616
  t630 = 0.1e1 / t275 / t98
  t654 = 0.1e1 / t73 / t275 / t160
  t659 = 0.1e1 / t275
  t666 = t230 * t659
  t670 = 0.20889989210465385247345777777777777777777777777779e1 * t210 * t483 * t616 * t473 + 0.32640608141352164448977777777777777777777777777780e1 * t479 * t621 * t235 - 0.34816648684108975412242962962962962962962962962965e0 * t625 * t235 + 0.38213878438219709331305062190755731958518518518522e-1 * t210 * t273 * t630 * t214 * t239 * t96 + 0.13852530933854644632598085044148952834962962962964e0 * t625 * t490 - 0.19106939219109854665652531095377865979259259259261e-1 * t137 * t273 * t630 * t490 - 0.20889989210465385247345777777777777777777777777779e1 * t439 * t483 * t616 * t441 * t146 * t71 - 0.76725225278330901792888566512432520271424405461656e-4 * t65 / t429 / t79 * t272 * t367 * t654 * t71 - 0.73876576426593732202853037037037037037037037037041e1 * t231 * t659 * t235 - 0.65281216282704328897955555555555555555555555555558e1 * t470 * t621 * t473 - 0.1792e4 / 0.9e1 * t252 * t666 * t214
  t672 = 0.1e1 / t73 / t160
  t673 = s0 * t672
  t707 = 0.13664e5 / 0.81e2 * t252 * t673 * t214 + 0.56e2 / 0.3e1 * t449 * t261 - 0.1120e4 / 0.27e2 * t257 * t337 - 0.1792e4 / 0.9e1 * t452 * t659 * t441 * t82 + 0.1792e4 / 0.9e1 * t457 * t659 * t214 * t82 - 0.896e3 / 0.9e1 * t435 * t349 + 0.448e3 / 0.9e1 * t257 * t421 - 0.13664e5 / 0.81e2 * t211 * t672 * t214 * t82 + 0.6832e4 / 0.81e2 * t225 * t672 * t62 * t82 + 0.1792e4 / 0.9e1 * t440 * t666 * t441 - 0.16e2 / 0.3e1 * t137 * t417 * t157
  t716 = t56 * t101
  t720 = t89 * t672
  t749 = 0.17301319374471756415790276006590720074789203316219e-1 * t431 * t274 * t630 - 0.3640e4 / 0.81e2 * t138 * t101 * t62 * t82 + 0.3640e4 / 0.81e2 * t155 * t716 * t62 + 0.35605463380858319386426592592592592592592592592594e1 * t148 * t720 - 0.19485097391154737205910237439973886243432098765433e0 * t241 * t242 * t621 - 0.41942592422961833735249153955371442605549583796896e-2 * t137 * t56 * t273 / t57 / t369 * t62 * t430 * t272 + 0.64e2 / 0.3e1 * t210 * t309 * t254 - 0.512e3 / 0.9e1 * t439 * t189 * t442 - 0.6832e4 / 0.81e2 * t155 * t673 * t62 + 0.896e3 / 0.27e2 * t155 * t666 * t62 - 0.32e2 / 0.3e1 * t449 * t264
  t750 = t97 * t621
  t763 = 0.1e1 / t438 / t63
  t765 = t214 ** 2
  t799 = t368 * t654
  t804 = t275 ** 2
  t815 = 0.14334705075445816186556927297668038408779149519890e-1 * t96 * t750
  t836 = t293 ** 2
  t842 = t307 ** 2
  t869 = (0.47272386831275720164609053497942386831275720164610e2 * t96 * t750 * t85 - 0.13254471879286694101508916323731138545953360768176e4 * t274 * t630 * t85 + 0.16893461362597165066300868770004572473708276177412e4 * t799 * t373 - 0.57460752934003962810547172687090382563633592440179e3 * t272 * t367 * s0 / t57 / t804 / r0 * t96 * t85 + 0.2618e4 / 0.243e3 * t88 * t720 - t815) * t115 - 0.4e1 * t381 * t174 * t187 + 0.12e2 * t285 * t291 * t293 - 0.6e1 * t383 * t307 - 0.24e2 * t171 * t392 * t394 + 0.24e2 * t386 * t397 - 0.4e1 * t287 * t415 + 0.24e2 * t105 / t391 / t114 * t836 - 0.36e2 * t393 * t293 * t307 + 0.6e1 * t292 * t842 + 0.8e1 * t292 * t187 * t415 - t175 * (0.73567695473251028806584362139917695473251028806584e0 * t107 * t716 * t110 + 0.13631756691604938271604938271604938271604938271604e2 * t71 * t673 * t183 - 0.37118709523050054499862825788751714677640603566528e2 * t96 * t750 * t303 + 0.40731606821459423948303195127572016460905349794237e3 * t274 * t630 * t411 - 0.29468046786777076685826220230925983429355281207131e3 * t799 / t182 / t409 / t181 * t66 * t70 + t815)
  t871 = -0.256e3 / 0.81e2 * t155 * t750 * t62 + 0.512e3 / 0.9e1 * t435 * t446 - 0.256e3 / 0.27e2 * t257 * t426 + 0.256e3 / 0.81e2 * t479 * t621 * t62 * t82 - 0.2048e4 / 0.27e2 * t763 * t97 * t621 * t765 * t82 + 0.1024e4 / 0.9e1 * t439 * t97 * t621 * t441 * t82 - 0.3584e4 / 0.81e2 * t470 * t621 * t214 * t82 - 0.896e3 / 0.27e2 * t231 * t659 * t62 * t82 + 0.2048e4 / 0.27e2 * t763 * t117 * t750 * t765 - 0.1024e4 / 0.9e1 * t440 * t750 * t441 + 0.3584e4 / 0.81e2 * t252 * t750 * t214 + t64 * t869
  t881 = 0.1e1 / t129 / t36
  t918 = t19 ** 2
  t921 = t30 ** 2
  t927 = t41 ** 2
  t936 = -0.24e2 * t45 + 0.24e2 * t16 / t44 / t6
  t937 = f.my_piecewise5(t10, 0, t14, 0, t936)
  t941 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t22 / t918 * t921 - 0.16e2 / 0.9e1 * t24 * t30 * t41 + 0.4e1 / 0.3e1 * t34 * t927 + 0.16e2 / 0.9e1 * t35 * t49 + 0.4e1 / 0.3e1 * t21 * t937)
  t949 = -0.3e1 / 0.8e1 * t5 * t333 * (t670 + t707 + t749 + t871) - t5 * t329 * t499 / 0.2e1 + 0.10e2 / 0.27e2 * t5 * t318 * t881 * t119 - 0.5e1 / 0.9e1 * t5 * t197 * t320 * t119 - t5 * t53 * t130 * t119 / 0.2e1 + t5 * t128 * t199 * t119 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t321 * t191 + t5 * t325 * t311 / 0.2e1 - 0.3e1 / 0.2e1 * t5 * t208 * t499 - 0.3e1 / 0.2e1 * t5 * t204 * t311 + t5 * t200 * t191 - 0.3e1 / 0.2e1 * t5 * t131 * t191 - 0.9e1 / 0.4e1 * t5 * t135 * t311 - 0.3e1 / 0.8e1 * t5 * t941 * t54 * t119 - 0.3e1 / 0.2e1 * t5 * t55 * t191
  t950 = f.my_piecewise3(t1, 0, t949)
  t951 = t508 ** 2
  t954 = t516 ** 2
  t960 = t523 ** 2
  t966 = f.my_piecewise5(t14, 0, t10, 0, -t936)
  t970 = f.my_piecewise3(t509, 0, 0.40e2 / 0.81e2 / t511 / t951 * t954 - 0.16e2 / 0.9e1 * t513 * t516 * t523 + 0.4e1 / 0.3e1 * t520 * t960 + 0.16e2 / 0.9e1 * t521 * t527 + 0.4e1 / 0.3e1 * t510 * t966)
  t992 = f.my_piecewise3(t506, 0, -0.3e1 / 0.8e1 * t5 * t970 * t54 * t584 - t5 * t531 * t130 * t584 / 0.2e1 + t5 * t593 * t199 * t584 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t600 * t320 * t584 + 0.10e2 / 0.27e2 * t5 * t606 * t881 * t584)
  d1111 = 0.4e1 * t504 + 0.4e1 * t612 + t6 * (t950 + t992)

  res = {'v4rho4': d1111}
  return res
