"""Generated from gga_x_lg93.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  lg93_ad = 1e-08

  lg93_b = 0.024974

  lg93_a4 = 29.79

  lg93_a6 = 22.417

  lg93_a8 = 12.119

  lg93_a10 = 1570.1

  lg93_a12 = 55.944

  lg93_a2 = (lg93_ad + 0.1234) / lg93_b

  lg93_f0 = lambda s: 1 + lg93_a2 * s ** 2 + lg93_a4 * s ** 4 + lg93_a6 * s ** 6 + lg93_a8 * s ** 8 + lg93_a10 * s ** 10 + lg93_a12 * s ** 12

  lg93_f1 = lambda s: lg93_f0(s) ** lg93_b / (1 + lg93_ad * s ** 2)

  lg93_f = lambda x: lg93_f1(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, lg93_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  lg93_ad = 1e-08

  lg93_b = 0.024974

  lg93_a4 = 29.79

  lg93_a6 = 22.417

  lg93_a8 = 12.119

  lg93_a10 = 1570.1

  lg93_a12 = 55.944

  lg93_a2 = (lg93_ad + 0.1234) / lg93_b

  lg93_f0 = lambda s: 1 + lg93_a2 * s ** 2 + lg93_a4 * s ** 4 + lg93_a6 * s ** 6 + lg93_a8 * s ** 8 + lg93_a10 * s ** 10 + lg93_a12 * s ** 12

  lg93_f1 = lambda s: lg93_f0(s) ** lg93_b / (1 + lg93_ad * s ** 2)

  lg93_f = lambda x: lg93_f1(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, lg93_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  lg93_ad = 1e-08

  lg93_b = 0.024974

  lg93_a4 = 29.79

  lg93_a6 = 22.417

  lg93_a8 = 12.119

  lg93_a10 = 1570.1

  lg93_a12 = 55.944

  lg93_a2 = (lg93_ad + 0.1234) / lg93_b

  lg93_f0 = lambda s: 1 + lg93_a2 * s ** 2 + lg93_a4 * s ** 4 + lg93_a6 * s ** 6 + lg93_a8 * s ** 8 + lg93_a10 * s ** 10 + lg93_a12 * s ** 12

  lg93_f1 = lambda s: lg93_f0(s) ** lg93_b / (1 + lg93_ad * s ** 2)

  lg93_f = lambda x: lg93_f1(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, lg93_f, rs, zeta, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t5 * t25
  t27 = t6 ** (0.1e1 / 0.3e1)
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = jnp.pi ** 2
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = 0.1e1 / t31
  t33 = t28 * t32
  t34 = r0 ** 2
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / t34
  t40 = t33 * s0 * t38
  t42 = t28 ** 2
  t45 = t42 / t30 / t29
  t46 = s0 ** 2
  t47 = t34 ** 2
  t48 = t47 * r0
  t50 = 0.1e1 / t35 / t48
  t54 = t29 ** 2
  t55 = 0.1e1 / t54
  t56 = t46 * s0
  t57 = t55 * t56
  t58 = t47 ** 2
  t59 = 0.1e1 / t58
  t64 = t28 / t31 / t54
  t65 = t46 ** 2
  t68 = 0.1e1 / t36 / t58 / t34
  t75 = t42 / t30 / t54 / t29
  t76 = t65 * s0
  t79 = 0.1e1 / t35 / t58 / t48
  t83 = t54 ** 2
  t84 = 0.1e1 / t83
  t86 = t84 * t65 * t46
  t87 = t58 ** 2
  t88 = 0.1e1 / t87
  t91 = 0.1e1 + 0.20588079936467259282987640479431942553589065961934e0 * t40 + 0.51718750000000000000000000000000000000000000000000e-1 * t45 * t46 * t50 + 0.97296006944444444444444444444444444444444444444444e-2 * t57 * t59 + 0.21916594328703703703703703703703703703703703703704e-3 * t64 * t65 * t68 + 0.11831024546682098765432098765432098765432098765432e-2 * t75 * t76 * t79 + 0.10538736979166666666666666666666666666666666666667e-4 * t86 * t88
  t92 = t91 ** 0.24974e-1
  t95 = 0.1e1 + 0.41666666666666666666666666666666666666666666666667e-9 * t40
  t96 = 0.1e1 / t95
  t97 = t27 * t92 * t96
  t100 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t26 * t97)
  t101 = r1 <= f.p.dens_threshold
  t102 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t103 = 0.1e1 + t102
  t104 = t103 <= f.p.zeta_threshold
  t105 = t103 ** (0.1e1 / 0.3e1)
  t107 = f.my_piecewise3(t104, t22, t105 * t103)
  t108 = t5 * t107
  t109 = r1 ** 2
  t110 = r1 ** (0.1e1 / 0.3e1)
  t111 = t110 ** 2
  t113 = 0.1e1 / t111 / t109
  t115 = t33 * s2 * t113
  t117 = s2 ** 2
  t118 = t109 ** 2
  t119 = t118 * r1
  t121 = 0.1e1 / t110 / t119
  t125 = t117 * s2
  t126 = t55 * t125
  t127 = t118 ** 2
  t128 = 0.1e1 / t127
  t131 = t117 ** 2
  t134 = 0.1e1 / t111 / t127 / t109
  t138 = t131 * s2
  t141 = 0.1e1 / t110 / t127 / t119
  t146 = t84 * t131 * t117
  t147 = t127 ** 2
  t148 = 0.1e1 / t147
  t151 = 0.1e1 + 0.20588079936467259282987640479431942553589065961934e0 * t115 + 0.51718750000000000000000000000000000000000000000000e-1 * t45 * t117 * t121 + 0.97296006944444444444444444444444444444444444444444e-2 * t126 * t128 + 0.21916594328703703703703703703703703703703703703704e-3 * t64 * t131 * t134 + 0.11831024546682098765432098765432098765432098765432e-2 * t75 * t138 * t141 + 0.10538736979166666666666666666666666666666666666667e-4 * t146 * t148
  t152 = t151 ** 0.24974e-1
  t155 = 0.1e1 + 0.41666666666666666666666666666666666666666666666667e-9 * t115
  t156 = 0.1e1 / t155
  t157 = t27 * t152 * t156
  t160 = f.my_piecewise3(t101, 0, -0.3e1 / 0.8e1 * t108 * t157)
  t161 = t6 ** 2
  t163 = t16 / t161
  t164 = t7 - t163
  t165 = f.my_piecewise5(t10, 0, t14, 0, t164)
  t168 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t165)
  t172 = t27 ** 2
  t173 = 0.1e1 / t172
  t177 = t26 * t173 * t92 * t96 / 0.8e1
  t178 = t91 ** (-0.975026e0)
  t179 = t27 * t178
  t180 = t34 * r0
  t182 = 0.1e1 / t36 / t180
  t186 = t47 * t34
  t217 = t25 * t27
  t220 = t95 ** 2
  t221 = 0.1e1 / t220
  t229 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t168 * t97 - t177 - 0.93652500000000000000000000000000000000000000000000e-2 * t26 * t179 * t96 * (-0.54901546497246024754633707945151846809570842565157e0 * t33 * s0 * t182 - 0.27583333333333333333333333333333333333333333333333e0 * t45 * t46 / t35 / t186 - 0.77836805555555555555555555555555555555555555555555e-1 * t57 / t58 / r0 - 0.23377700617283950617283950617283950617283950617284e-2 * t64 * t65 / t36 / t58 / t180 - 0.15774699395576131687242798353909465020576131687243e-1 * t75 * t76 / t35 / t58 / t186 - 0.16861979166666666666666666666666666666666666666667e-3 * t86 / t87 / r0) - 0.41666666666666666666666666666666666666666666666666e-9 * t5 * t217 * t92 * t221 * t28 * t32 * s0 * t182)
  t231 = f.my_piecewise5(t14, 0, t10, 0, -t164)
  t234 = f.my_piecewise3(t104, 0, 0.4e1 / 0.3e1 * t105 * t231)
  t241 = t108 * t173 * t152 * t156 / 0.8e1
  t243 = f.my_piecewise3(t101, 0, -0.3e1 / 0.8e1 * t5 * t234 * t157 - t241)
  vrho_0_ = t100 + t160 + t6 * (t229 + t243)
  t246 = -t7 - t163
  t247 = f.my_piecewise5(t10, 0, t14, 0, t246)
  t250 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t247)
  t255 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t250 * t97 - t177)
  t257 = f.my_piecewise5(t14, 0, t10, 0, -t246)
  t260 = f.my_piecewise3(t104, 0, 0.4e1 / 0.3e1 * t105 * t257)
  t264 = t151 ** (-0.975026e0)
  t265 = t27 * t264
  t266 = t109 * r1
  t268 = 0.1e1 / t111 / t266
  t272 = t118 * t109
  t303 = t107 * t27
  t306 = t155 ** 2
  t307 = 0.1e1 / t306
  t315 = f.my_piecewise3(t101, 0, -0.3e1 / 0.8e1 * t5 * t260 * t157 - t241 - 0.93652500000000000000000000000000000000000000000000e-2 * t108 * t265 * t156 * (-0.54901546497246024754633707945151846809570842565157e0 * t33 * s2 * t268 - 0.27583333333333333333333333333333333333333333333333e0 * t45 * t117 / t110 / t272 - 0.77836805555555555555555555555555555555555555555555e-1 * t126 / t127 / r1 - 0.23377700617283950617283950617283950617283950617284e-2 * t64 * t131 / t111 / t127 / t266 - 0.15774699395576131687242798353909465020576131687243e-1 * t75 * t138 / t110 / t127 / t272 - 0.16861979166666666666666666666666666666666666666667e-3 * t146 / t147 / r1) - 0.41666666666666666666666666666666666666666666666666e-9 * t5 * t303 * t152 * t307 * t28 * t32 * s2 * t268)
  vrho_1_ = t100 + t160 + t6 * (t255 + t315)
  t318 = t33 * t38
  t346 = f.my_piecewise3(t1, 0, -0.93652500000000000000000000000000000000000000000000e-2 * t26 * t179 * t96 * (0.20588079936467259282987640479431942553589065961934e0 * t318 + 0.10343750000000000000000000000000000000000000000000e0 * t45 * s0 * t50 + 0.29188802083333333333333333333333333333333333333333e-1 * t55 * t46 * t59 + 0.87666377314814814814814814814814814814814814814816e-3 * t64 * t56 * t68 + 0.59155122733410493827160493827160493827160493827160e-2 * t75 * t65 * t79 + 0.63232421875000000000000000000000000000000000000002e-4 * t84 * t76 * t88) + 0.15625000000000000000000000000000000000000000000000e-9 * t5 * t217 * t92 * t221 * t318)
  vsigma_0_ = t6 * t346
  vsigma_1_ = 0.0e0
  t347 = t33 * t113
  t375 = f.my_piecewise3(t101, 0, -0.93652500000000000000000000000000000000000000000000e-2 * t108 * t265 * t156 * (0.20588079936467259282987640479431942553589065961934e0 * t347 + 0.10343750000000000000000000000000000000000000000000e0 * t45 * s2 * t121 + 0.29188802083333333333333333333333333333333333333333e-1 * t55 * t117 * t128 + 0.87666377314814814814814814814814814814814814814816e-3 * t64 * t125 * t134 + 0.59155122733410493827160493827160493827160493827160e-2 * t75 * t131 * t141 + 0.63232421875000000000000000000000000000000000000002e-4 * t84 * t138 * t148) + 0.15625000000000000000000000000000000000000000000000e-9 * t5 * t303 * t152 * t307 * t347)
  vsigma_2_ = t6 * t375
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  lg93_ad = 1e-08

  lg93_b = 0.024974

  lg93_a4 = 29.79

  lg93_a6 = 22.417

  lg93_a8 = 12.119

  lg93_a10 = 1570.1

  lg93_a12 = 55.944

  lg93_a2 = (lg93_ad + 0.1234) / lg93_b

  lg93_f0 = lambda s: 1 + lg93_a2 * s ** 2 + lg93_a4 * s ** 4 + lg93_a6 * s ** 6 + lg93_a8 * s ** 8 + lg93_a10 * s ** 10 + lg93_a12 * s ** 12

  lg93_f1 = lambda s: lg93_f0(s) ** lg93_b / (1 + lg93_ad * s ** 2)

  lg93_f = lambda x: lg93_f1(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, lg93_f, rs, zeta, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** 2
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = 0.1e1 / t23
  t25 = t20 * t24
  t26 = 2 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = s0 * t27
  t29 = r0 ** 2
  t30 = t19 ** 2
  t32 = 0.1e1 / t30 / t29
  t34 = t25 * t28 * t32
  t36 = t20 ** 2
  t39 = t36 / t22 / t21
  t40 = s0 ** 2
  t41 = t40 * t26
  t42 = t29 ** 2
  t43 = t42 * r0
  t45 = 0.1e1 / t19 / t43
  t49 = t21 ** 2
  t50 = 0.1e1 / t49
  t51 = t40 * s0
  t52 = t50 * t51
  t53 = t42 ** 2
  t54 = 0.1e1 / t53
  t59 = t20 / t23 / t49
  t60 = t40 ** 2
  t61 = t60 * t27
  t64 = 0.1e1 / t30 / t53 / t29
  t71 = t36 / t22 / t49 / t21
  t72 = t60 * s0
  t73 = t72 * t26
  t76 = 0.1e1 / t19 / t53 / t43
  t80 = t49 ** 2
  t81 = 0.1e1 / t80
  t83 = t81 * t60 * t40
  t84 = t53 ** 2
  t85 = 0.1e1 / t84
  t88 = 0.1e1 + 0.20588079936467259282987640479431942553589065961934e0 * t34 + 0.10343750000000000000000000000000000000000000000000e0 * t39 * t41 * t45 + 0.38918402777777777777777777777777777777777777777778e-1 * t52 * t54 + 0.87666377314814814814814814814814814814814814814815e-3 * t59 * t61 * t64 + 0.94648196373456790123456790123456790123456790123457e-2 * t71 * t73 * t76 + 0.16861979166666666666666666666666666666666666666667e-3 * t83 * t85
  t89 = t88 ** 0.24974e-1
  t92 = 0.1e1 + 0.41666666666666666666666666666666666666666666666667e-9 * t34
  t93 = 0.1e1 / t92
  t97 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t18 * t19 * t89 * t93)
  t103 = t88 ** (-0.975026e0)
  t104 = t19 * t103
  t105 = t29 * r0
  t111 = t42 * t29
  t147 = t92 ** 2
  t148 = 0.1e1 / t147
  t156 = f.my_piecewise3(t2, 0, -t18 / t30 * t89 * t93 / 0.8e1 - 0.93652500000000000000000000000000000000000000000000e-2 * t18 * t104 * t93 * (-0.54901546497246024754633707945151846809570842565157e0 * t25 * t28 / t30 / t105 - 0.55166666666666666666666666666666666666666666666667e0 * t39 * t41 / t19 / t111 - 0.31134722222222222222222222222222222222222222222222e0 * t52 / t53 / r0 - 0.93510802469135802469135802469135802469135802469136e-2 * t59 * t61 / t30 / t53 / t105 - 0.12619759516460905349794238683127572016460905349794e0 * t71 * t73 / t19 / t53 / t111 - 0.26979166666666666666666666666666666666666666666667e-2 * t83 / t84 / r0) - 0.41666666666666666666666666666666666666666666666666e-9 * t6 * t17 / t19 / t105 * t89 * t148 * t20 * t24 * s0 * t27)
  vrho_0_ = 0.2e1 * r0 * t156 + 0.2e1 * t97
  t195 = f.my_piecewise3(t2, 0, -0.93652500000000000000000000000000000000000000000000e-2 * t18 * t104 * t93 * (0.20588079936467259282987640479431942553589065961934e0 * t25 * t27 * t32 + 0.20687500000000000000000000000000000000000000000000e0 * t39 * s0 * t26 * t45 + 0.11675520833333333333333333333333333333333333333333e0 * t50 * t40 * t54 + 0.35066550925925925925925925925925925925925925925926e-2 * t59 * t51 * t27 * t64 + 0.47324098186728395061728395061728395061728395061728e-1 * t71 * t60 * t26 * t76 + 0.10117187500000000000000000000000000000000000000000e-2 * t81 * t72 * t85) + 0.15625000000000000000000000000000000000000000000000e-9 * t6 * t17 / t19 / t29 * t89 * t148 * t25 * t27)
  vsigma_0_ = 0.2e1 * r0 * t195
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = 0.1e1 / t20
  t22 = 6 ** (0.1e1 / 0.3e1)
  t23 = jnp.pi ** 2
  t24 = t23 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = 0.1e1 / t25
  t27 = t22 * t26
  t28 = 2 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = s0 * t29
  t31 = r0 ** 2
  t33 = 0.1e1 / t20 / t31
  t35 = t27 * t30 * t33
  t37 = t22 ** 2
  t39 = 0.1e1 / t24 / t23
  t40 = t37 * t39
  t41 = s0 ** 2
  t42 = t41 * t28
  t43 = t31 ** 2
  t44 = t43 * r0
  t46 = 0.1e1 / t19 / t44
  t50 = t23 ** 2
  t51 = 0.1e1 / t50
  t52 = t41 * s0
  t53 = t51 * t52
  t54 = t43 ** 2
  t55 = 0.1e1 / t54
  t60 = t22 / t25 / t50
  t61 = t41 ** 2
  t62 = t61 * t29
  t63 = t54 * t31
  t65 = 0.1e1 / t20 / t63
  t72 = t37 / t24 / t50 / t23
  t73 = t61 * s0
  t74 = t73 * t28
  t77 = 0.1e1 / t19 / t54 / t44
  t81 = t50 ** 2
  t82 = 0.1e1 / t81
  t84 = t82 * t61 * t41
  t85 = t54 ** 2
  t86 = 0.1e1 / t85
  t89 = 0.1e1 + 0.20588079936467259282987640479431942553589065961934e0 * t35 + 0.10343750000000000000000000000000000000000000000000e0 * t40 * t42 * t46 + 0.38918402777777777777777777777777777777777777777778e-1 * t53 * t55 + 0.87666377314814814814814814814814814814814814814816e-3 * t60 * t62 * t65 + 0.94648196373456790123456790123456790123456790123456e-2 * t72 * t74 * t77 + 0.16861979166666666666666666666666666666666666666667e-3 * t84 * t86
  t90 = t89 ** 0.24974e-1
  t93 = 0.1e1 + 0.41666666666666666666666666666666666666666666666666e-9 * t35
  t94 = 0.1e1 / t93
  t98 = t89 ** (-0.975026e0)
  t99 = t19 * t98
  t100 = t31 * r0
  t102 = 0.1e1 / t20 / t100
  t106 = t43 * t31
  t108 = 0.1e1 / t19 / t106
  t113 = 0.1e1 / t54 / r0
  t118 = 0.1e1 / t20 / t54 / t100
  t124 = 0.1e1 / t19 / t54 / t106
  t129 = 0.1e1 / t85 / r0
  t132 = -0.54901546497246024754633707945151846809570842565157e0 * t27 * t30 * t102 - 0.55166666666666666666666666666666666666666666666667e0 * t40 * t42 * t108 - 0.31134722222222222222222222222222222222222222222222e0 * t53 * t113 - 0.93510802469135802469135802469135802469135802469137e-2 * t60 * t62 * t118 - 0.12619759516460905349794238683127572016460905349794e0 * t72 * t74 * t124 - 0.26979166666666666666666666666666666666666666666667e-2 * t84 * t129
  t133 = t94 * t132
  t139 = t17 / t19 / t100
  t142 = t93 ** 2
  t143 = 0.1e1 / t142
  t144 = t143 * t22
  t146 = t26 * s0 * t29
  t147 = t144 * t146
  t151 = f.my_piecewise3(t2, 0, -t18 * t21 * t90 * t94 / 0.8e1 - 0.93652500000000000000000000000000000000000000000000e-2 * t18 * t99 * t133 - 0.41666666666666666666666666666666666666666666666666e-9 * t6 * t139 * t90 * t147)
  t159 = t21 * t98
  t170 = t89 ** (-0.1975026e1)
  t171 = t19 * t170
  t172 = t132 ** 2
  t178 = t6 * t139 * t98
  t189 = t43 * t100
  t224 = 0.1e1 / t142 / t93
  t225 = t224 * t37
  t232 = f.my_piecewise3(t2, 0, t18 / t20 / r0 * t90 * t94 / 0.12e2 - 0.62435000000000000000000000000000000000000000000000e-2 * t18 * t159 * t133 + 0.12500000000000000000000000000000000000000000000000e-8 * t6 * t17 / t19 / t43 * t90 * t147 + 0.91313622465000000000000000000000000000000000000000e-2 * t18 * t171 * t94 * t172 - 0.20811666666666666666666666666666666666666666666666e-10 * t178 * t143 * t132 * t22 * t146 - 0.93652500000000000000000000000000000000000000000000e-2 * t18 * t99 * t94 * (0.20130567048990209076699026246555677163509308940558e1 * t27 * t30 / t20 / t43 + 0.34938888888888888888888888888888888888888888888889e1 * t40 * t42 / t19 / t189 + 0.28021250000000000000000000000000000000000000000000e1 * t53 / t63 + 0.10909593621399176954732510288065843621399176954733e0 * t60 * t62 / t20 / t54 / t43 + 0.18088321973593964334705075445816186556927297668038e1 * t72 * t74 / t19 / t54 / t189 + 0.45864583333333333333333333333333333333333333333334e-1 * t84 / t85 / t31) - 0.18518518518518518518518518518518518518518518518518e-17 * t6 * t17 / t189 * t90 * t225 * t39 * t41 * t28)
  v2rho2_0_ = 0.2e1 * r0 * t232 + 0.4e1 * t151
  t238 = s0 * t28
  t242 = t51 * t41
  t245 = t52 * t29
  t249 = t61 * t28
  t253 = t82 * t73
  t256 = 0.20588079936467259282987640479431942553589065961934e0 * t27 * t29 * t33 + 0.20687500000000000000000000000000000000000000000000e0 * t40 * t238 * t46 + 0.11675520833333333333333333333333333333333333333333e0 * t242 * t55 + 0.35066550925925925925925925925925925925925925925926e-2 * t60 * t245 * t65 + 0.47324098186728395061728395061728395061728395061728e-1 * t72 * t249 * t77 + 0.10117187500000000000000000000000000000000000000000e-2 * t253 * t86
  t257 = t94 * t256
  t263 = t17 / t19 / t31
  t266 = t27 * t29
  t267 = t90 * t143 * t266
  t271 = f.my_piecewise3(t2, 0, -0.93652500000000000000000000000000000000000000000000e-2 * t18 * t99 * t257 + 0.15625000000000000000000000000000000000000000000000e-9 * t6 * t263 * t267)
  t282 = t143 * t256
  t312 = t6 * t263 * t98
  t328 = f.my_piecewise3(t2, 0, -0.31217500000000000000000000000000000000000000000000e-2 * t18 * t159 * t257 + 0.91313622465000000000000000000000000000000000000000e-2 * t6 * t17 * t19 * t170 * t94 * t256 * t132 - 0.10405833333333333333333333333333333333333333333333e-10 * t178 * t282 * t22 * t146 - 0.93652500000000000000000000000000000000000000000000e-2 * t18 * t99 * t94 * (-0.54901546497246024754633707945151846809570842565157e0 * t27 * t29 * t102 - 0.11033333333333333333333333333333333333333333333333e1 * t40 * t238 * t108 - 0.93404166666666666666666666666666666666666666666664e0 * t242 * t113 - 0.37404320987654320987654320987654320987654320987655e-1 * t60 * t245 * t118 - 0.63098797582304526748971193415637860082304526748971e0 * t72 * t249 * t124 - 0.16187500000000000000000000000000000000000000000000e-1 * t253 * t129) - 0.36458333333333333333333333333333333333333333333333e-9 * t6 * t139 * t267 + 0.39021875000000000000000000000000000000000000000000e-11 * t312 * t144 * t26 * t29 * t132 + 0.69444444444444444444444444444444444444444444444444e-18 * t6 * t17 / t106 * t90 * t225 * t39 * t28 * s0)
  v2rhosigma_0_ = 0.2e1 * r0 * t328 + 0.2e1 * t271
  t331 = t256 ** 2
  t370 = f.my_piecewise3(t2, 0, 0.91313622465000000000000000000000000000000000000000e-2 * t18 * t171 * t94 * t331 + 0.78043749999999999999999999999999999999999999999999e-11 * t312 * t282 * t266 - 0.93652500000000000000000000000000000000000000000000e-2 * t18 * t99 * t94 * (0.20687500000000000000000000000000000000000000000000e0 * t40 * t28 * t46 + 0.23351041666666666666666666666666666666666666666666e0 * t51 * s0 * t55 + 0.10519965277777777777777777777777777777777777777778e-1 * t60 * t41 * t29 * t65 + 0.18929639274691358024691358024691358024691358024691e0 * t72 * t52 * t28 * t77 + 0.50585937500000000000000000000000000000000000000000e-2 * t82 * t61 * t86) - 0.26041666666666666666666666666666666666666666666666e-18 * t6 * t17 / t44 * t90 * t224 * t40 * t28)
  v2sigma2_0_ = 0.2e1 * r0 * t370
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = t6 * t17
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / r0
  t23 = 6 ** (0.1e1 / 0.3e1)
  t24 = jnp.pi ** 2
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = 0.1e1 / t26
  t28 = t23 * t27
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = s0 * t30
  t32 = r0 ** 2
  t34 = 0.1e1 / t20 / t32
  t36 = t28 * t31 * t34
  t38 = t23 ** 2
  t40 = 0.1e1 / t25 / t24
  t41 = t38 * t40
  t42 = s0 ** 2
  t43 = t42 * t29
  t44 = t32 ** 2
  t45 = t44 * r0
  t47 = 0.1e1 / t19 / t45
  t51 = t24 ** 2
  t53 = t42 * s0
  t54 = 0.1e1 / t51 * t53
  t55 = t44 ** 2
  t56 = 0.1e1 / t55
  t61 = t23 / t26 / t51
  t62 = t42 ** 2
  t63 = t62 * t30
  t64 = t55 * t32
  t66 = 0.1e1 / t20 / t64
  t73 = t38 / t25 / t51 / t24
  t75 = t62 * s0 * t29
  t76 = t55 * t45
  t82 = t51 ** 2
  t85 = 0.1e1 / t82 * t62 * t42
  t86 = t55 ** 2
  t90 = 0.1e1 + 0.20588079936467259282987640479431942553589065961934e0 * t36 + 0.10343750000000000000000000000000000000000000000000e0 * t41 * t43 * t47 + 0.38918402777777777777777777777777777777777777777778e-1 * t54 * t56 + 0.87666377314814814814814814814814814814814814814816e-3 * t61 * t63 * t66 + 0.94648196373456790123456790123456790123456790123456e-2 * t73 * t75 / t19 / t76 + 0.16861979166666666666666666666666666666666666666667e-3 * t85 / t86
  t91 = t90 ** 0.24974e-1
  t94 = 0.1e1 + 0.41666666666666666666666666666666666666666666666666e-9 * t36
  t95 = 0.1e1 / t94
  t99 = 0.1e1 / t20
  t100 = t90 ** (-0.975026e0)
  t101 = t99 * t100
  t102 = t32 * r0
  t108 = t44 * t32
  t118 = t55 * t102
  t134 = -0.54901546497246024754633707945151846809570842565157e0 * t28 * t31 / t20 / t102 - 0.55166666666666666666666666666666666666666666666667e0 * t41 * t43 / t19 / t108 - 0.31134722222222222222222222222222222222222222222222e0 * t54 / t55 / r0 - 0.93510802469135802469135802469135802469135802469137e-2 * t61 * t63 / t20 / t118 - 0.12619759516460905349794238683127572016460905349794e0 * t73 * t75 / t19 / t55 / t108 - 0.26979166666666666666666666666666666666666666666667e-2 * t85 / t86 / r0
  t135 = t95 * t134
  t141 = t17 / t19 / t44
  t144 = t94 ** 2
  t145 = 0.1e1 / t144
  t148 = t27 * s0 * t30
  t149 = t145 * t23 * t148
  t152 = t90 ** (-0.1975026e1)
  t154 = t134 ** 2
  t155 = t95 * t154
  t161 = t17 / t19 / t102
  t163 = t6 * t161 * t100
  t166 = t145 * t134 * t23 * t148
  t169 = t19 * t100
  t175 = t44 * t102
  t200 = 0.20130567048990209076699026246555677163509308940558e1 * t28 * t31 / t20 / t44 + 0.34938888888888888888888888888888888888888888888889e1 * t41 * t43 / t19 / t175 + 0.28021250000000000000000000000000000000000000000000e1 * t54 / t64 + 0.10909593621399176954732510288065843621399176954733e0 * t61 * t63 / t20 / t55 / t44 + 0.18088321973593964334705075445816186556927297668038e1 * t73 * t75 / t19 / t55 / t175 + 0.45864583333333333333333333333333333333333333333334e-1 * t85 / t86 / t32
  t201 = t95 * t200
  t206 = t17 / t175
  t210 = 0.1e1 / t144 / t94
  t213 = t40 * t42 * t29
  t214 = t210 * t38 * t213
  t218 = f.my_piecewise3(t2, 0, t18 * t22 * t91 * t95 / 0.12e2 - 0.62435000000000000000000000000000000000000000000000e-2 * t18 * t101 * t135 + 0.12500000000000000000000000000000000000000000000000e-8 * t6 * t141 * t91 * t149 + 0.91313622465000000000000000000000000000000000000000e-2 * t18 * t19 * t152 * t155 - 0.20811666666666666666666666666666666666666666666666e-10 * t163 * t166 - 0.93652500000000000000000000000000000000000000000000e-2 * t18 * t169 * t201 - 0.18518518518518518518518518518518518518518518518518e-17 * t6 * t206 * t91 * t214)
  t270 = t144 ** 2
  t288 = t90 ** (-0.2975026e1)
  t325 = -0.53240740740740740740740740740740740740740740740741e-8 * t6 * t17 * t47 * t91 * t149 + 0.18518518518518518518518518518518518518518518518518e-16 * t6 * t17 * t56 * t91 * t214 - 0.93652500000000000000000000000000000000000000000000e-2 * t18 * t101 * t201 - 0.93652500000000000000000000000000000000000000000000e-2 * t18 * t169 * t95 * (-0.93942646228620975691262122483926493429710108389271e1 * t28 * t31 / t20 / t45 - 0.25621851851851851851851851851851851851851851851852e2 * t41 * t43 / t19 / t55 - 0.28021250000000000000000000000000000000000000000000e2 * t54 / t118 - 0.13818818587105624142661179698216735253772290809329e1 * t61 * t63 / t20 / t76 - 0.27735427026177411979881115683584819387288523090992e2 * t73 * t75 / t19 / t86 - 0.82556250000000000000000000000000000000000000000001e0 * t85 / t86 / t102) - 0.74074074074074074074074074074074074074074074074070e-25 * t3 / t4 / t51 * t17 * t66 * t91 / t270 * t53 - 0.5e1 / 0.36e2 * t18 * t34 * t91 * t95 + 0.62435000000000000000000000000000000000000000000000e-2 * t18 * t22 * t100 * t135 + 0.91313622465000000000000000000000000000000000000000e-2 * t18 * t99 * t152 * t155 - 0.18034677852255909000000000000000000000000000000000e-1 * t18 * t19 * t288 * t95 * t154 * t134 + 0.27394086739500000000000000000000000000000000000000e-1 * t6 * t17 * t19 * t152 * t95 * t134 * t200 + 0.93652499999999999999999999999999999999999999999998e-10 * t6 * t141 * t100 * t166 + 0.30437874155000000000000000000000000000000000000000e-10 * t6 * t161 * t152 * t145 * t154 * t23 * t148 - 0.31217499999999999999999999999999999999999999999999e-10 * t163 * t145 * t200 * t23 * t148 - 0.13874444444444444444444444444444444444444444444444e-18 * t6 * t206 * t100 * t210 * t134 * t38 * t213
  t326 = f.my_piecewise3(t2, 0, t325)
  v3rho3_0_ = 0.2e1 * r0 * t326 + 0.6e1 * t218

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = t18 ** 2
  t20 = t19 * r0
  t21 = r0 ** (0.1e1 / 0.3e1)
  t23 = 0.1e1 / t21 / t20
  t24 = t17 * t23
  t25 = 6 ** (0.1e1 / 0.3e1)
  t26 = jnp.pi ** 2
  t27 = t26 ** (0.1e1 / 0.3e1)
  t28 = t27 ** 2
  t29 = 0.1e1 / t28
  t30 = t25 * t29
  t31 = 2 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t33 = s0 * t32
  t34 = t21 ** 2
  t36 = 0.1e1 / t34 / t18
  t38 = t30 * t33 * t36
  t40 = t25 ** 2
  t42 = 0.1e1 / t27 / t26
  t43 = t40 * t42
  t44 = s0 ** 2
  t45 = t44 * t31
  t49 = t26 ** 2
  t51 = t44 * s0
  t52 = 0.1e1 / t49 * t51
  t53 = t19 ** 2
  t54 = 0.1e1 / t53
  t59 = t25 / t28 / t49
  t60 = t44 ** 2
  t61 = t60 * t32
  t62 = t53 * t18
  t64 = 0.1e1 / t34 / t62
  t71 = t40 / t27 / t49 / t26
  t73 = t60 * s0 * t31
  t74 = t53 * t20
  t80 = t49 ** 2
  t83 = 0.1e1 / t80 * t60 * t44
  t84 = t53 ** 2
  t88 = 0.1e1 + 0.20588079936467259282987640479431942553589065961934e0 * t38 + 0.10343750000000000000000000000000000000000000000000e0 * t43 * t45 * t23 + 0.38918402777777777777777777777777777777777777777778e-1 * t52 * t54 + 0.87666377314814814814814814814814814814814814814816e-3 * t59 * t61 * t64 + 0.94648196373456790123456790123456790123456790123456e-2 * t71 * t73 / t21 / t74 + 0.16861979166666666666666666666666666666666666666667e-3 * t83 / t84
  t89 = t88 ** 0.24974e-1
  t93 = 0.1e1 + 0.41666666666666666666666666666666666666666666666666e-9 * t38
  t94 = t93 ** 2
  t95 = 0.1e1 / t94
  t98 = t29 * s0 * t32
  t99 = t95 * t25 * t98
  t102 = t17 * t54
  t106 = 0.1e1 / t94 / t93
  t109 = t42 * t44 * t31
  t110 = t106 * t40 * t109
  t113 = t6 * t17
  t114 = 0.1e1 / t34
  t115 = t88 ** (-0.975026e0)
  t116 = t114 * t115
  t117 = 0.1e1 / t93
  t123 = t18 * r0
  t124 = t19 * t123
  t133 = t53 * t19
  t149 = 0.20130567048990209076699026246555677163509308940558e1 * t30 * t33 / t34 / t19 + 0.34938888888888888888888888888888888888888888888889e1 * t43 * t45 / t21 / t124 + 0.28021250000000000000000000000000000000000000000000e1 * t52 / t62 + 0.10909593621399176954732510288065843621399176954733e0 * t59 * t61 / t34 / t133 + 0.18088321973593964334705075445816186556927297668038e1 * t71 * t73 / t21 / t53 / t124 + 0.45864583333333333333333333333333333333333333333334e-1 * t83 / t84 / t18
  t150 = t117 * t149
  t154 = t21 * t115
  t165 = t53 * t123
  t183 = -0.93942646228620975691262122483926493429710108389271e1 * t30 * t33 / t34 / t20 - 0.25621851851851851851851851851851851851851851851852e2 * t43 * t45 / t21 / t53 - 0.28021250000000000000000000000000000000000000000000e2 * t52 / t165 - 0.13818818587105624142661179698216735253772290809329e1 * t59 * t61 / t34 / t74 - 0.27735427026177411979881115683584819387288523090992e2 * t71 * t73 / t21 / t84 - 0.82556250000000000000000000000000000000000000000001e0 * t83 / t84 / t123
  t184 = t117 * t183
  t190 = t3 / t4 / t49
  t191 = t190 * t17
  t193 = t94 ** 2
  t194 = 0.1e1 / t193
  t195 = t194 * t51
  t204 = 0.1e1 / t34 / r0
  t205 = t204 * t115
  t207 = 0.1e1 / t34 / t123
  t211 = t19 * t18
  t213 = 0.1e1 / t21 / t211
  t217 = t53 * r0
  t218 = 0.1e1 / t217
  t222 = 0.1e1 / t34 / t165
  t226 = t53 * t211
  t228 = 0.1e1 / t21 / t226
  t232 = t84 * r0
  t236 = -0.54901546497246024754633707945151846809570842565157e0 * t30 * t33 * t207 - 0.55166666666666666666666666666666666666666666666667e0 * t43 * t45 * t213 - 0.31134722222222222222222222222222222222222222222222e0 * t52 * t218 - 0.93510802469135802469135802469135802469135802469137e-2 * t59 * t61 * t222 - 0.12619759516460905349794238683127572016460905349794e0 * t71 * t73 * t228 - 0.26979166666666666666666666666666666666666666666667e-2 * t83 / t232
  t237 = t117 * t236
  t241 = t88 ** (-0.1975026e1)
  t243 = t236 ** 2
  t244 = t117 * t243
  t248 = t88 ** (-0.2975026e1)
  t250 = t243 * t236
  t251 = t117 * t250
  t256 = t6 * t17 * t21
  t257 = t241 * t117
  t258 = t236 * t149
  t259 = t257 * t258
  t264 = t17 / t21 / t19
  t266 = t6 * t264 * t115
  t269 = t95 * t236 * t25 * t98
  t273 = 0.1e1 / t21 / t123
  t274 = t17 * t273
  t279 = t95 * t243 * t25 * t98
  t283 = t6 * t274 * t115
  t286 = t95 * t149 * t25 * t98
  t290 = t17 / t124
  t292 = t6 * t290 * t115
  t295 = t106 * t236 * t40 * t109
  t298 = -0.53240740740740740740740740740740740740740740740741e-8 * t6 * t24 * t89 * t99 + 0.18518518518518518518518518518518518518518518518518e-16 * t6 * t102 * t89 * t110 - 0.93652500000000000000000000000000000000000000000000e-2 * t113 * t116 * t150 - 0.93652500000000000000000000000000000000000000000000e-2 * t113 * t154 * t184 - 0.74074074074074074074074074074074074074074074074070e-25 * t191 * t64 * t89 * t195 - 0.5e1 / 0.36e2 * t113 * t36 * t89 * t117 + 0.62435000000000000000000000000000000000000000000000e-2 * t113 * t205 * t237 + 0.91313622465000000000000000000000000000000000000000e-2 * t113 * t114 * t241 * t244 - 0.18034677852255909000000000000000000000000000000000e-1 * t113 * t21 * t248 * t251 + 0.27394086739500000000000000000000000000000000000000e-1 * t256 * t259 + 0.93652499999999999999999999999999999999999999999998e-10 * t266 * t269 + 0.30437874155000000000000000000000000000000000000000e-10 * t6 * t274 * t241 * t279 - 0.31217499999999999999999999999999999999999999999999e-10 * t283 * t286 - 0.13874444444444444444444444444444444444444444444444e-18 * t292 * t295
  t299 = f.my_piecewise3(t2, 0, t298)
  t356 = t149 ** 2
  t369 = 0.10e2 / 0.27e2 * t113 * t207 * t89 * t117 + 0.36525448986000000000000000000000000000000000000000e-1 * t256 * t257 * t183 * t236 - 0.73997037037037037037037037037037037037037037037033e-26 * t190 * t17 * t64 * t115 * t194 * t51 * t236 - 0.10820806711353545400000000000000000000000000000000e0 * t256 * t248 * t117 * t243 * t149 + 0.36525448986000000000000000000000000000000000000000e-1 * t6 * t17 * t114 * t259 + 0.12175149662000000000000000000000000000000000000000e-9 * t113 * t273 * t241 * t95 * t258 * t25 * t98 - 0.17181069958847736625514403292181069958847736625514e-15 * t6 * t17 * t218 * t89 * t110 - 0.32921810699588477366255144032921810699588477366253e-33 * t190 * t17 * t228 * t89 / t193 / t93 * t60 * t30 * t32 + 0.28240740740740740740740740740740740740740740740741e-7 * t6 * t17 * t213 * t89 * t99 + 0.12487000000000000000000000000000000000000000000000e-1 * t113 * t205 * t150 + 0.27394086739500000000000000000000000000000000000000e-1 * t113 * t21 * t241 * t117 * t356 - 0.13874444444444444444444444444444444444444444444444e-1 * t113 * t36 * t115 * t237 + 0.15308641975308641975308641975308641975308641975308e-23 * t191 * t222 * t89 * t195
  t413 = t88 ** (-0.3975026e1)
  t415 = t243 ** 2
  t458 = -0.12487000000000000000000000000000000000000000000000e-1 * t113 * t116 * t184 - 0.93652500000000000000000000000000000000000000000000e-2 * t113 * t154 * t117 * (0.53234166196218552891715202740891679610169061420587e2 * t30 * t33 / t34 / t211 + 0.21351543209876543209876543209876543209876543209877e3 * t43 * t45 / t21 / t217 + 0.30823375000000000000000000000000000000000000000000e3 * t52 / t133 + 0.18885718735711019661636945587562871513488797439416e2 * t59 * t61 / t34 / t226 + 0.45301197476089772900472488949855204999237921048620e3 * t71 * t73 / t21 / t232 + 0.15685687500000000000000000000000000000000000000000e2 * t83 / t84 / t19) - 0.12175149662000000000000000000000000000000000000000e-1 * t113 * t204 * t241 * t244 - 0.24046237136341212000000000000000000000000000000000e-1 * t113 * t114 * t248 * t251 + 0.53653635512085487928634000000000000000000000000000e-1 * t113 * t21 * t413 * t117 * t415 - 0.53185370370370370370370370370370370370370370370370e-9 * t6 * t24 * t115 * t269 + 0.18499259259259259259259259259259259259259259259259e-17 * t6 * t102 * t115 * t295 + 0.18730500000000000000000000000000000000000000000000e-9 * t266 * t286 - 0.41623333333333333333333333333333333333333333333332e-10 * t283 * t95 * t183 * t25 * t98 - 0.18262724493000000000000000000000000000000000000000e-9 * t6 * t264 * t241 * t279 - 0.80154123787804040000000000000000000000000000000000e-10 * t6 * t274 * t248 * t95 * t250 * t25 * t98 + 0.27055888137777777777777777777777777777777777777777e-18 * t6 * t290 * t241 * t106 * t243 * t40 * t109 - 0.27748888888888888888888888888888888888888888888888e-18 * t292 * t106 * t149 * t40 * t109
  t460 = f.my_piecewise3(t2, 0, t369 + t458)
  v4rho4_0_ = 0.2e1 * r0 * t460 + 0.8e1 * t299

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t5 * t29
  t31 = t6 ** (0.1e1 / 0.3e1)
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t36 = 0.1e1 / t35
  t37 = t32 * t36
  t38 = r0 ** 2
  t39 = r0 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t44 = t37 * s0 / t40 / t38
  t46 = t32 ** 2
  t48 = 0.1e1 / t34 / t33
  t49 = t46 * t48
  t50 = s0 ** 2
  t51 = t38 ** 2
  t52 = t51 * r0
  t58 = t33 ** 2
  t59 = 0.1e1 / t58
  t61 = t59 * t50 * s0
  t62 = t51 ** 2
  t68 = t32 / t35 / t58
  t69 = t50 ** 2
  t70 = t62 * t38
  t79 = t46 / t34 / t58 / t33
  t80 = t69 * s0
  t87 = t58 ** 2
  t88 = 0.1e1 / t87
  t90 = t88 * t69 * t50
  t91 = t62 ** 2
  t95 = 0.1e1 + 0.20588079936467259282987640479431942553589065961934e0 * t44 + 0.51718749999999999999999999999999999999999999999998e-1 * t49 * t50 / t39 / t52 + 0.97296006944444444444444444444444444444444444444445e-2 * t61 / t62 + 0.21916594328703703703703703703703703703703703703704e-3 * t68 * t69 / t40 / t70 + 0.11831024546682098765432098765432098765432098765432e-2 * t79 * t80 / t39 / t62 / t52 + 0.10538736979166666666666666666666666666666666666667e-4 * t90 / t91
  t96 = t95 ** 0.24974e-1
  t99 = 0.1e1 + 0.41666666666666666666666666666666666666666666666666e-9 * t44
  t100 = 0.1e1 / t99
  t101 = t31 * t96 * t100
  t104 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t105 = t104 * f.p.zeta_threshold
  t107 = f.my_piecewise3(t20, t105, t21 * t19)
  t108 = t5 * t107
  t109 = t31 ** 2
  t110 = 0.1e1 / t109
  t112 = t110 * t96 * t100
  t114 = t108 * t112 / 0.8e1
  t115 = t95 ** (-0.975026e0)
  t116 = t31 * t115
  t117 = t38 * r0
  t119 = 0.1e1 / t40 / t117
  t123 = t51 * t38
  t149 = -0.54901546497246024754633707945151846809570842565157e0 * t37 * s0 * t119 - 0.27583333333333333333333333333333333333333333333332e0 * t49 * t50 / t39 / t123 - 0.77836805555555555555555555555555555555555555555556e-1 * t61 / t62 / r0 - 0.23377700617283950617283950617283950617283950617284e-2 * t68 * t69 / t40 / t62 / t117 - 0.15774699395576131687242798353909465020576131687243e-1 * t79 * t80 / t39 / t62 / t123 - 0.16861979166666666666666666666666666666666666666667e-3 * t90 / t91 / r0
  t150 = t100 * t149
  t151 = t116 * t150
  t154 = t107 * t31
  t156 = t5 * t154 * t96
  t157 = t99 ** 2
  t158 = 0.1e1 / t157
  t159 = t158 * t32
  t160 = t36 * s0
  t161 = t160 * t119
  t162 = t159 * t161
  t166 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t30 * t101 - t114 - 0.93652500000000000000000000000000000000000000000000e-2 * t108 * t151 - 0.41666666666666666666666666666666666666666666666666e-9 * t156 * t162)
  t168 = r1 <= f.p.dens_threshold
  t169 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t170 = 0.1e1 + t169
  t171 = t170 <= f.p.zeta_threshold
  t172 = t170 ** (0.1e1 / 0.3e1)
  t174 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t177 = f.my_piecewise3(t171, 0, 0.4e1 / 0.3e1 * t172 * t174)
  t178 = t5 * t177
  t179 = r1 ** 2
  t180 = r1 ** (0.1e1 / 0.3e1)
  t181 = t180 ** 2
  t185 = t37 * s2 / t181 / t179
  t187 = s2 ** 2
  t188 = t179 ** 2
  t189 = t188 * r1
  t196 = t59 * t187 * s2
  t197 = t188 ** 2
  t201 = t187 ** 2
  t202 = t197 * t179
  t208 = t201 * s2
  t216 = t88 * t201 * t187
  t217 = t197 ** 2
  t221 = 0.1e1 + 0.20588079936467259282987640479431942553589065961934e0 * t185 + 0.51718749999999999999999999999999999999999999999998e-1 * t49 * t187 / t180 / t189 + 0.97296006944444444444444444444444444444444444444445e-2 * t196 / t197 + 0.21916594328703703703703703703703703703703703703704e-3 * t68 * t201 / t181 / t202 + 0.11831024546682098765432098765432098765432098765432e-2 * t79 * t208 / t180 / t197 / t189 + 0.10538736979166666666666666666666666666666666666667e-4 * t216 / t217
  t222 = t221 ** 0.24974e-1
  t225 = 0.1e1 + 0.41666666666666666666666666666666666666666666666666e-9 * t185
  t226 = 0.1e1 / t225
  t227 = t31 * t222 * t226
  t231 = f.my_piecewise3(t171, t105, t172 * t170)
  t232 = t5 * t231
  t234 = t110 * t222 * t226
  t236 = t232 * t234 / 0.8e1
  t238 = f.my_piecewise3(t168, 0, -0.3e1 / 0.8e1 * t178 * t227 - t236)
  t240 = t21 ** 2
  t241 = 0.1e1 / t240
  t242 = t26 ** 2
  t247 = t16 / t22 / t6
  t249 = -0.2e1 * t23 + 0.2e1 * t247
  t250 = f.my_piecewise5(t10, 0, t14, 0, t249)
  t254 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t241 * t242 + 0.4e1 / 0.3e1 * t21 * t250)
  t258 = t30 * t112
  t268 = 0.1e1 / t109 / t6
  t272 = t108 * t268 * t96 * t100 / 0.12e2
  t275 = t108 * t110 * t115 * t150
  t280 = t5 * t107 * t110 * t96 * t162
  t282 = t95 ** (-0.1975026e1)
  t284 = t149 ** 2
  t297 = 0.1e1 / t40 / t51
  t301 = t51 * t117
  t303 = 0.1e1 / t39 / t301
  t343 = -0.3e1 / 0.8e1 * t5 * t254 * t101 - t258 / 0.4e1 - 0.18730500000000000000000000000000000000000000000000e-1 * t30 * t151 - 0.83333333333333333333333333333333333333333333333332e-9 * t5 * t29 * t31 * t96 * t162 + t272 - 0.62435000000000000000000000000000000000000000000000e-2 * t275 - 0.27777777777777777777777777777777777777777777777778e-9 * t280 + 0.91313622465000000000000000000000000000000000000000e-2 * t108 * t31 * t282 * t100 * t284 - 0.20811666666666666666666666666666666666666666666666e-10 * t5 * t154 * t115 * t158 * t149 * t32 * t161 - 0.93652500000000000000000000000000000000000000000000e-2 * t108 * t116 * t100 * (0.20130567048990209076699026246555677163509308940558e1 * t37 * s0 * t297 + 0.17469444444444444444444444444444444444444444444444e1 * t49 * t50 * t303 + 0.70053125000000000000000000000000000000000000000000e0 * t61 / t70 + 0.27273984053497942386831275720164609053497942386831e-1 * t68 * t69 / t40 / t62 / t51 + 0.22610402466992455418381344307270233196159122085048e0 * t79 * t80 / t39 / t62 / t301 + 0.28665364583333333333333333333333333333333333333334e-2 * t90 / t91 / t38) - 0.92592592592592592592592592592592592592592592592590e-18 * t156 / t157 / t99 * t46 * t48 * t50 * t303 + 0.15277777777777777777777777777777777777777777777778e-8 * t156 * t159 * t160 * t297
  t344 = f.my_piecewise3(t1, 0, t343)
  t345 = t172 ** 2
  t346 = 0.1e1 / t345
  t347 = t174 ** 2
  t351 = f.my_piecewise5(t14, 0, t10, 0, -t249)
  t355 = f.my_piecewise3(t171, 0, 0.4e1 / 0.9e1 * t346 * t347 + 0.4e1 / 0.3e1 * t172 * t351)
  t359 = t178 * t234
  t364 = t232 * t268 * t222 * t226 / 0.12e2
  t366 = f.my_piecewise3(t168, 0, -0.3e1 / 0.8e1 * t5 * t355 * t227 - t359 / 0.4e1 + t364)
  d11 = 0.2e1 * t166 + 0.2e1 * t238 + t6 * (t344 + t366)
  t369 = -t7 - t24
  t370 = f.my_piecewise5(t10, 0, t14, 0, t369)
  t373 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t370)
  t374 = t5 * t373
  t378 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t374 * t101 - t114)
  t380 = f.my_piecewise5(t14, 0, t10, 0, -t369)
  t383 = f.my_piecewise3(t171, 0, 0.4e1 / 0.3e1 * t172 * t380)
  t384 = t5 * t383
  t387 = t221 ** (-0.975026e0)
  t388 = t31 * t387
  t389 = t179 * r1
  t391 = 0.1e1 / t181 / t389
  t395 = t188 * t179
  t421 = -0.54901546497246024754633707945151846809570842565157e0 * t37 * s2 * t391 - 0.27583333333333333333333333333333333333333333333332e0 * t49 * t187 / t180 / t395 - 0.77836805555555555555555555555555555555555555555556e-1 * t196 / t197 / r1 - 0.23377700617283950617283950617283950617283950617284e-2 * t68 * t201 / t181 / t197 / t389 - 0.15774699395576131687242798353909465020576131687243e-1 * t79 * t208 / t180 / t197 / t395 - 0.16861979166666666666666666666666666666666666666667e-3 * t216 / t217 / r1
  t422 = t226 * t421
  t423 = t388 * t422
  t426 = t231 * t31
  t428 = t5 * t426 * t222
  t429 = t225 ** 2
  t430 = 0.1e1 / t429
  t431 = t430 * t32
  t432 = t36 * s2
  t433 = t432 * t391
  t434 = t431 * t433
  t438 = f.my_piecewise3(t168, 0, -0.3e1 / 0.8e1 * t384 * t227 - t236 - 0.93652500000000000000000000000000000000000000000000e-2 * t232 * t423 - 0.41666666666666666666666666666666666666666666666666e-9 * t428 * t434)
  t442 = 0.2e1 * t247
  t443 = f.my_piecewise5(t10, 0, t14, 0, t442)
  t447 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t241 * t370 * t26 + 0.4e1 / 0.3e1 * t21 * t443)
  t451 = t374 * t112
  t464 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t447 * t101 - t451 / 0.8e1 - 0.93652500000000000000000000000000000000000000000000e-2 * t374 * t151 - 0.41666666666666666666666666666666666666666666666666e-9 * t5 * t373 * t31 * t96 * t162 - t258 / 0.8e1 + t272 - 0.31217500000000000000000000000000000000000000000000e-2 * t275 - 0.13888888888888888888888888888888888888888888888889e-9 * t280)
  t468 = f.my_piecewise5(t14, 0, t10, 0, -t442)
  t472 = f.my_piecewise3(t171, 0, 0.4e1 / 0.9e1 * t346 * t380 * t174 + 0.4e1 / 0.3e1 * t172 * t468)
  t476 = t384 * t234
  t483 = t232 * t110 * t387 * t422
  t493 = t5 * t231 * t110 * t222 * t434
  t496 = f.my_piecewise3(t168, 0, -0.3e1 / 0.8e1 * t5 * t472 * t227 - t476 / 0.8e1 - t359 / 0.8e1 + t364 - 0.93652500000000000000000000000000000000000000000000e-2 * t178 * t423 - 0.31217500000000000000000000000000000000000000000000e-2 * t483 - 0.41666666666666666666666666666666666666666666666666e-9 * t5 * t177 * t31 * t222 * t434 - 0.13888888888888888888888888888888888888888888888889e-9 * t493)
  d12 = t166 + t238 + t378 + t438 + t6 * (t464 + t496)
  t501 = t370 ** 2
  t505 = 0.2e1 * t23 + 0.2e1 * t247
  t506 = f.my_piecewise5(t10, 0, t14, 0, t505)
  t510 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t241 * t501 + 0.4e1 / 0.3e1 * t21 * t506)
  t516 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t510 * t101 - t451 / 0.4e1 + t272)
  t517 = t380 ** 2
  t521 = f.my_piecewise5(t14, 0, t10, 0, -t505)
  t525 = f.my_piecewise3(t171, 0, 0.4e1 / 0.9e1 * t346 * t517 + 0.4e1 / 0.3e1 * t172 * t521)
  t539 = t221 ** (-0.1975026e1)
  t541 = t421 ** 2
  t554 = 0.1e1 / t181 / t188
  t558 = t188 * t389
  t560 = 0.1e1 / t180 / t558
  t600 = -0.3e1 / 0.8e1 * t5 * t525 * t227 - t476 / 0.4e1 - 0.18730500000000000000000000000000000000000000000000e-1 * t384 * t423 - 0.83333333333333333333333333333333333333333333333332e-9 * t5 * t383 * t31 * t222 * t434 + t364 - 0.62435000000000000000000000000000000000000000000000e-2 * t483 - 0.27777777777777777777777777777777777777777777777778e-9 * t493 + 0.91313622465000000000000000000000000000000000000000e-2 * t232 * t31 * t539 * t226 * t541 - 0.20811666666666666666666666666666666666666666666666e-10 * t5 * t426 * t387 * t430 * t421 * t32 * t433 - 0.93652500000000000000000000000000000000000000000000e-2 * t232 * t388 * t226 * (0.20130567048990209076699026246555677163509308940558e1 * t37 * s2 * t554 + 0.17469444444444444444444444444444444444444444444444e1 * t49 * t187 * t560 + 0.70053125000000000000000000000000000000000000000000e0 * t196 / t202 + 0.27273984053497942386831275720164609053497942386831e-1 * t68 * t201 / t181 / t197 / t188 + 0.22610402466992455418381344307270233196159122085048e0 * t79 * t208 / t180 / t197 / t558 + 0.28665364583333333333333333333333333333333333333334e-2 * t216 / t217 / t179) - 0.92592592592592592592592592592592592592592592592590e-18 * t428 / t429 / t225 * t46 * t48 * t187 * t560 + 0.15277777777777777777777777777777777777777777777778e-8 * t428 * t431 * t432 * t554
  t601 = f.my_piecewise3(t168, 0, t600)
  d22 = 0.2e1 * t378 + 0.2e1 * t438 + t6 * (t516 + t601)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t5 * t41
  t43 = t6 ** (0.1e1 / 0.3e1)
  t44 = 6 ** (0.1e1 / 0.3e1)
  t45 = jnp.pi ** 2
  t46 = t45 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t48 = 0.1e1 / t47
  t49 = t44 * t48
  t50 = r0 ** 2
  t51 = r0 ** (0.1e1 / 0.3e1)
  t52 = t51 ** 2
  t56 = t49 * s0 / t52 / t50
  t58 = t44 ** 2
  t60 = 0.1e1 / t46 / t45
  t61 = t58 * t60
  t62 = s0 ** 2
  t63 = t50 ** 2
  t64 = t63 * r0
  t70 = t45 ** 2
  t71 = 0.1e1 / t70
  t72 = t62 * s0
  t73 = t71 * t72
  t74 = t63 ** 2
  t80 = t44 / t47 / t70
  t81 = t62 ** 2
  t82 = t74 * t50
  t91 = t58 / t46 / t70 / t45
  t92 = t81 * s0
  t93 = t74 * t64
  t99 = t70 ** 2
  t100 = 0.1e1 / t99
  t102 = t100 * t81 * t62
  t103 = t74 ** 2
  t107 = 0.1e1 + 0.20588079936467259282987640479431942553589065961934e0 * t56 + 0.51718749999999999999999999999999999999999999999998e-1 * t61 * t62 / t51 / t64 + 0.97296006944444444444444444444444444444444444444445e-2 * t73 / t74 + 0.21916594328703703703703703703703703703703703703704e-3 * t80 * t81 / t52 / t82 + 0.11831024546682098765432098765432098765432098765432e-2 * t91 * t92 / t51 / t93 + 0.10538736979166666666666666666666666666666666666667e-4 * t102 / t103
  t108 = t107 ** 0.24974e-1
  t111 = 0.1e1 + 0.41666666666666666666666666666666666666666666666666e-9 * t56
  t112 = 0.1e1 / t111
  t113 = t43 * t108 * t112
  t118 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t119 = t5 * t118
  t120 = t43 ** 2
  t121 = 0.1e1 / t120
  t123 = t121 * t108 * t112
  t126 = t107 ** (-0.975026e0)
  t127 = t43 * t126
  t128 = t50 * r0
  t130 = 0.1e1 / t52 / t128
  t134 = t63 * t50
  t144 = t74 * t128
  t160 = -0.54901546497246024754633707945151846809570842565157e0 * t49 * s0 * t130 - 0.27583333333333333333333333333333333333333333333332e0 * t61 * t62 / t51 / t134 - 0.77836805555555555555555555555555555555555555555556e-1 * t73 / t74 / r0 - 0.23377700617283950617283950617283950617283950617284e-2 * t80 * t81 / t52 / t144 - 0.15774699395576131687242798353909465020576131687243e-1 * t91 * t92 / t51 / t74 / t134 - 0.16861979166666666666666666666666666666666666666667e-3 * t102 / t103 / r0
  t161 = t112 * t160
  t162 = t127 * t161
  t165 = t118 * t43
  t167 = t5 * t165 * t108
  t168 = t111 ** 2
  t169 = 0.1e1 / t168
  t170 = t169 * t44
  t171 = t48 * s0
  t172 = t171 * t130
  t173 = t170 * t172
  t176 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t177 = t176 * f.p.zeta_threshold
  t179 = f.my_piecewise3(t20, t177, t21 * t19)
  t180 = t5 * t179
  t182 = 0.1e1 / t120 / t6
  t184 = t182 * t108 * t112
  t187 = t121 * t126
  t188 = t187 * t161
  t191 = t179 * t121
  t193 = t5 * t191 * t108
  t196 = t107 ** (-0.1975026e1)
  t198 = t160 ** 2
  t199 = t112 * t198
  t200 = t43 * t196 * t199
  t203 = t179 * t43
  t205 = t5 * t203 * t126
  t207 = t169 * t160 * t44
  t208 = t207 * t172
  t212 = 0.1e1 / t52 / t63
  t216 = t63 * t128
  t218 = 0.1e1 / t51 / t216
  t241 = 0.20130567048990209076699026246555677163509308940558e1 * t49 * s0 * t212 + 0.17469444444444444444444444444444444444444444444444e1 * t61 * t62 * t218 + 0.70053125000000000000000000000000000000000000000000e0 * t73 / t82 + 0.27273984053497942386831275720164609053497942386831e-1 * t80 * t81 / t52 / t74 / t63 + 0.22610402466992455418381344307270233196159122085048e0 * t91 * t92 / t51 / t74 / t216 + 0.28665364583333333333333333333333333333333333333334e-2 * t102 / t103 / t50
  t242 = t112 * t241
  t243 = t127 * t242
  t247 = t5 * t203 * t108
  t249 = 0.1e1 / t168 / t111
  t250 = t249 * t58
  t251 = t60 * t62
  t252 = t251 * t218
  t253 = t250 * t252
  t256 = t171 * t212
  t257 = t170 * t256
  t260 = -0.3e1 / 0.8e1 * t42 * t113 - t119 * t123 / 0.4e1 - 0.18730500000000000000000000000000000000000000000000e-1 * t119 * t162 - 0.83333333333333333333333333333333333333333333333332e-9 * t167 * t173 + t180 * t184 / 0.12e2 - 0.62435000000000000000000000000000000000000000000000e-2 * t180 * t188 - 0.27777777777777777777777777777777777777777777777778e-9 * t193 * t173 + 0.91313622465000000000000000000000000000000000000000e-2 * t180 * t200 - 0.20811666666666666666666666666666666666666666666666e-10 * t205 * t208 - 0.93652500000000000000000000000000000000000000000000e-2 * t180 * t243 - 0.92592592592592592592592592592592592592592592592590e-18 * t247 * t253 + 0.15277777777777777777777777777777777777777777777778e-8 * t247 * t257
  t261 = f.my_piecewise3(t1, 0, t260)
  t263 = r1 <= f.p.dens_threshold
  t264 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t265 = 0.1e1 + t264
  t266 = t265 <= f.p.zeta_threshold
  t267 = t265 ** (0.1e1 / 0.3e1)
  t268 = t267 ** 2
  t269 = 0.1e1 / t268
  t271 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t272 = t271 ** 2
  t276 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t280 = f.my_piecewise3(t266, 0, 0.4e1 / 0.9e1 * t269 * t272 + 0.4e1 / 0.3e1 * t267 * t276)
  t281 = t5 * t280
  t282 = r1 ** 2
  t283 = r1 ** (0.1e1 / 0.3e1)
  t284 = t283 ** 2
  t288 = t49 * s2 / t284 / t282
  t290 = s2 ** 2
  t291 = t282 ** 2
  t292 = t291 * r1
  t300 = t291 ** 2
  t304 = t290 ** 2
  t320 = t300 ** 2
  t325 = (0.1e1 + 0.20588079936467259282987640479431942553589065961934e0 * t288 + 0.51718749999999999999999999999999999999999999999998e-1 * t61 * t290 / t283 / t292 + 0.97296006944444444444444444444444444444444444444445e-2 * t71 * t290 * s2 / t300 + 0.21916594328703703703703703703703703703703703703704e-3 * t80 * t304 / t284 / t300 / t282 + 0.11831024546682098765432098765432098765432098765432e-2 * t91 * t304 * s2 / t283 / t300 / t292 + 0.10538736979166666666666666666666666666666666666667e-4 * t100 * t304 * t290 / t320) ** 0.24974e-1
  t329 = 0.1e1 / (0.1e1 + 0.41666666666666666666666666666666666666666666666666e-9 * t288)
  t330 = t43 * t325 * t329
  t335 = f.my_piecewise3(t266, 0, 0.4e1 / 0.3e1 * t267 * t271)
  t336 = t5 * t335
  t338 = t121 * t325 * t329
  t342 = f.my_piecewise3(t266, t177, t267 * t265)
  t343 = t5 * t342
  t345 = t182 * t325 * t329
  t349 = f.my_piecewise3(t263, 0, -0.3e1 / 0.8e1 * t281 * t330 - t336 * t338 / 0.4e1 + t343 * t345 / 0.12e2)
  t355 = t168 ** 2
  t358 = 0.1e1 / t144
  t384 = 0.1e1 / t52 / t64
  t390 = 0.1e1 / t51 / t74
  t423 = -0.18518518518518518518518518518518518518518518518518e-25 * t2 / t3 / t70 * t203 * t108 / t355 * t72 * t358 + 0.27394086739500000000000000000000000000000000000000e-1 * t5 * t203 * t196 * t112 * t160 * t241 - 0.92592592592592592592592592592592592592592592592591e-18 * t193 * t253 - 0.12500000000000000000000000000000000000000000000000e-8 * t5 * t41 * t43 * t108 * t173 - 0.83333333333333333333333333333333333333333333333333e-9 * t5 * t118 * t121 * t108 * t173 - 0.27777777777777777777777777777777777777777777777777e-17 * t167 * t253 - 0.71296296296296296296296296296296296296296296296297e-8 * t247 * t170 * t171 * t384 + 0.10185185185185185185185185185185185185185185185185e-16 * t247 * t250 * t251 * t390 + 0.45833333333333333333333333333333333333333333333333e-8 * t167 * t257 + 0.15277777777777777777777777777777777777777777777778e-8 * t193 * t257 + 0.27777777777777777777777777777777777777777777777778e-9 * t5 * t179 * t182 * t108 * t173 - 0.20811666666666666666666666666666666666666666666666e-10 * t5 * t191 * t126 * t208 + 0.11446416666666666666666666666666666666666666666666e-9 * t205 * t207 * t256 + 0.30437874155000000000000000000000000000000000000000e-10 * t5 * t203 * t196 * t169 * t198 * t44 * t172 - 0.31217499999999999999999999999999999999999999999999e-10 * t205 * t169 * t241 * t44 * t172
  t475 = t107 ** (-0.2975026e1)
  t487 = 0.1e1 / t120 / t24
  t504 = t24 ** 2
  t508 = 0.6e1 * t33 - 0.6e1 * t16 / t504
  t509 = f.my_piecewise5(t10, 0, t14, 0, t508)
  t513 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t509)
  t517 = -0.69372222222222222222222222222222222222222222222219e-19 * t205 * t249 * t160 * t58 * t252 - 0.62434999999999999999999999999999999999999999999998e-10 * t5 * t165 * t126 * t208 - 0.93652500000000000000000000000000000000000000000000e-2 * t180 * t187 * t242 - 0.93652500000000000000000000000000000000000000000000e-2 * t180 * t127 * t112 * (-0.93942646228620975691262122483926493429710108389271e1 * t49 * s0 * t384 - 0.12810925925925925925925925925925925925925925925926e2 * t61 * t62 * t390 - 0.70053125000000000000000000000000000000000000000000e1 * t73 * t358 - 0.34547046467764060356652949245541838134430727023319e0 * t80 * t81 / t52 / t93 - 0.34669283782721764974851394604481024234110653863740e1 * t91 * t92 / t51 / t103 - 0.51597656250000000000000000000000000000000000000001e-1 * t102 / t103 / t128) - 0.28095750000000000000000000000000000000000000000000e-1 * t42 * t162 - 0.18730500000000000000000000000000000000000000000000e-1 * t119 * t188 - 0.28095750000000000000000000000000000000000000000000e-1 * t119 * t243 + 0.27394086739500000000000000000000000000000000000000e-1 * t119 * t200 + 0.91313622465000000000000000000000000000000000000000e-2 * t180 * t121 * t196 * t199 - 0.18034677852255909000000000000000000000000000000000e-1 * t180 * t43 * t475 * t112 * t198 * t160 + 0.62435000000000000000000000000000000000000000000000e-2 * t180 * t182 * t126 * t161 - 0.5e1 / 0.36e2 * t180 * t487 * t108 * t112 - 0.3e1 / 0.8e1 * t42 * t123 + t119 * t184 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t513 * t113
  t519 = f.my_piecewise3(t1, 0, t423 + t517)
  t529 = f.my_piecewise5(t14, 0, t10, 0, -t508)
  t533 = f.my_piecewise3(t266, 0, -0.8e1 / 0.27e2 / t268 / t265 * t272 * t271 + 0.4e1 / 0.3e1 * t269 * t271 * t276 + 0.4e1 / 0.3e1 * t267 * t529)
  t546 = f.my_piecewise3(t263, 0, -0.3e1 / 0.8e1 * t5 * t533 * t330 - 0.3e1 / 0.8e1 * t281 * t338 + t336 * t345 / 0.4e1 - 0.5e1 / 0.36e2 * t343 * t487 * t325 * t329)
  d111 = 0.3e1 * t261 + 0.3e1 * t349 + t6 * (t519 + t546)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t25 = -t16 * t23 + t7
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t5 * t29
  t31 = t6 ** (0.1e1 / 0.3e1)
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t36 = 0.1e1 / t35
  t37 = t32 * t36
  t38 = r0 ** 2
  t39 = r0 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t44 = t37 * s0 / t40 / t38
  t46 = t32 ** 2
  t48 = 0.1e1 / t34 / t33
  t49 = t46 * t48
  t50 = s0 ** 2
  t51 = t38 ** 2
  t52 = t51 * r0
  t58 = t33 ** 2
  t59 = 0.1e1 / t58
  t60 = t50 * s0
  t61 = t59 * t60
  t62 = t51 ** 2
  t68 = t32 / t35 / t58
  t69 = t50 ** 2
  t70 = t62 * t38
  t79 = t46 / t34 / t58 / t33
  t80 = t69 * s0
  t81 = t62 * t52
  t87 = t58 ** 2
  t88 = 0.1e1 / t87
  t90 = t88 * t69 * t50
  t91 = t62 ** 2
  t95 = 0.1e1 + 0.20588079936467259282987640479431942553589065961934e0 * t44 + 0.51718749999999999999999999999999999999999999999998e-1 * t49 * t50 / t39 / t52 + 0.97296006944444444444444444444444444444444444444445e-2 * t61 / t62 + 0.21916594328703703703703703703703703703703703703704e-3 * t68 * t69 / t40 / t70 + 0.11831024546682098765432098765432098765432098765432e-2 * t79 * t80 / t39 / t81 + 0.10538736979166666666666666666666666666666666666667e-4 * t90 / t91
  t96 = t95 ** (-0.975026e0)
  t97 = t31 * t96
  t99 = 0.1e1 + 0.41666666666666666666666666666666666666666666666666e-9 * t44
  t100 = 0.1e1 / t99
  t102 = 0.1e1 / t40 / t51
  t106 = t38 * r0
  t107 = t51 * t106
  t109 = 0.1e1 / t39 / t107
  t116 = t62 * t51
  t132 = 0.20130567048990209076699026246555677163509308940558e1 * t37 * s0 * t102 + 0.17469444444444444444444444444444444444444444444444e1 * t49 * t50 * t109 + 0.70053125000000000000000000000000000000000000000000e0 * t61 / t70 + 0.27273984053497942386831275720164609053497942386831e-1 * t68 * t69 / t40 / t116 + 0.22610402466992455418381344307270233196159122085048e0 * t79 * t80 / t39 / t62 / t107 + 0.28665364583333333333333333333333333333333333333334e-2 * t90 / t91 / t38
  t133 = t100 * t132
  t134 = t97 * t133
  t137 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t138 = t137 * f.p.zeta_threshold
  t140 = f.my_piecewise3(t20, t138, t21 * t19)
  t141 = t5 * t140
  t142 = t95 ** (-0.2975026e1)
  t145 = 0.1e1 / t40 / t106
  t146 = s0 * t145
  t149 = t51 * t38
  t155 = t62 * r0
  t159 = t62 * t106
  t165 = t62 * t149
  t171 = t91 * r0
  t175 = -0.54901546497246024754633707945151846809570842565157e0 * t37 * t146 - 0.27583333333333333333333333333333333333333333333332e0 * t49 * t50 / t39 / t149 - 0.77836805555555555555555555555555555555555555555556e-1 * t61 / t155 - 0.23377700617283950617283950617283950617283950617284e-2 * t68 * t69 / t40 / t159 - 0.15774699395576131687242798353909465020576131687243e-1 * t79 * t80 / t39 / t165 - 0.16861979166666666666666666666666666666666666666667e-3 * t90 / t171
  t176 = t175 ** 2
  t177 = t176 * t175
  t178 = t100 * t177
  t179 = t31 * t142 * t178
  t182 = t95 ** (-0.1975026e1)
  t183 = t31 * t182
  t184 = t100 * t176
  t185 = t183 * t184
  t188 = t31 ** 2
  t189 = 0.1e1 / t188
  t191 = t189 * t182 * t184
  t195 = 0.1e1 / t188 / t6
  t196 = t195 * t96
  t197 = t100 * t175
  t198 = t196 * t197
  t201 = t189 * t96
  t202 = t201 * t133
  t206 = 0.1e1 / t40 / t52
  t207 = s0 * t206
  t211 = 0.1e1 / t39 / t62
  t212 = t50 * t211
  t215 = 0.1e1 / t159
  t232 = -0.93942646228620975691262122483926493429710108389271e1 * t37 * t207 - 0.12810925925925925925925925925925925925925925925926e2 * t49 * t212 - 0.70053125000000000000000000000000000000000000000000e1 * t61 * t215 - 0.34547046467764060356652949245541838134430727023319e0 * t68 * t69 / t40 / t81 - 0.34669283782721764974851394604481024234110653863740e1 * t79 * t80 / t39 / t91 - 0.51597656250000000000000000000000000000000000000001e-1 * t90 / t91 / t106
  t233 = t100 * t232
  t234 = t97 * t233
  t237 = t21 ** 2
  t238 = 0.1e1 / t237
  t239 = t26 ** 2
  t242 = t22 * t6
  t243 = 0.1e1 / t242
  t246 = 0.2e1 * t16 * t243 - 0.2e1 * t23
  t247 = f.my_piecewise5(t10, 0, t14, 0, t246)
  t251 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t238 * t239 + 0.4e1 / 0.3e1 * t21 * t247)
  t252 = t5 * t251
  t253 = t97 * t197
  t256 = t201 * t197
  t259 = t140 * t31
  t260 = t5 * t259
  t261 = t182 * t100
  t263 = t261 * t175 * t132
  t268 = t2 / t3 / t58
  t269 = t268 * t259
  t270 = t95 ** 0.24974e-1
  t271 = t99 ** 2
  t272 = t271 ** 2
  t273 = 0.1e1 / t272
  t274 = t270 * t273
  t275 = t60 * t215
  t276 = t274 * t275
  t279 = t29 * t31
  t281 = t5 * t279 * t270
  t282 = 0.1e1 / t271
  t283 = t282 * t32
  t284 = t36 * s0
  t285 = t284 * t102
  t286 = t283 * t285
  t289 = t140 * t189
  t291 = t5 * t289 * t270
  t294 = t140 * t195
  t296 = t5 * t294 * t270
  t297 = t284 * t145
  t298 = t283 * t297
  t302 = 0.1e1 / t271 / t99
  t303 = t302 * t46
  t304 = t48 * t50
  t305 = t304 * t109
  t306 = t303 * t305
  t309 = -0.28095750000000000000000000000000000000000000000000e-1 * t30 * t134 - 0.18034677852255909000000000000000000000000000000000e-1 * t141 * t179 + 0.27394086739500000000000000000000000000000000000000e-1 * t30 * t185 + 0.91313622465000000000000000000000000000000000000000e-2 * t141 * t191 + 0.62435000000000000000000000000000000000000000000000e-2 * t141 * t198 - 0.93652500000000000000000000000000000000000000000000e-2 * t141 * t202 - 0.93652500000000000000000000000000000000000000000000e-2 * t141 * t234 - 0.28095750000000000000000000000000000000000000000000e-1 * t252 * t253 - 0.18730500000000000000000000000000000000000000000000e-1 * t30 * t256 + 0.27394086739500000000000000000000000000000000000000e-1 * t260 * t263 - 0.18518518518518518518518518518518518518518518518518e-25 * t269 * t276 + 0.45833333333333333333333333333333333333333333333333e-8 * t281 * t286 + 0.15277777777777777777777777777777777777777777777778e-8 * t291 * t286 + 0.27777777777777777777777777777777777777777777777778e-9 * t296 * t298 - 0.92592592592592592592592592592592592592592592592591e-18 * t291 * t306
  t310 = t251 * t31
  t312 = t5 * t310 * t270
  t315 = t29 * t189
  t317 = t5 * t315 * t270
  t322 = t259 * t270
  t323 = t5 * t322
  t325 = t283 * t284 * t206
  t329 = t303 * t304 * t211
  t333 = t5 * t259 * t96
  t335 = t282 * t175 * t32
  t336 = t335 * t285
  t340 = t5 * t259 * t182
  t342 = t282 * t176 * t32
  t343 = t342 * t297
  t347 = t282 * t132 * t32
  t348 = t347 * t297
  t353 = t302 * t175 * t46 * t305
  t357 = t5 * t279 * t96
  t358 = t335 * t297
  t362 = t5 * t289 * t96
  t366 = 0.1e1 / t188 / t22
  t368 = t366 * t270 * t100
  t372 = t189 * t270 * t100
  t376 = t195 * t270 * t100
  t380 = 0.1e1 / t237 / t19
  t384 = t238 * t26
  t387 = t22 ** 2
  t388 = 0.1e1 / t387
  t391 = -0.6e1 * t16 * t388 + 0.6e1 * t243
  t392 = f.my_piecewise5(t10, 0, t14, 0, t391)
  t396 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t380 * t239 * t26 + 0.4e1 / 0.3e1 * t384 * t247 + 0.4e1 / 0.3e1 * t21 * t392)
  t397 = t5 * t396
  t399 = t31 * t270 * t100
  t402 = -0.12500000000000000000000000000000000000000000000000e-8 * t312 * t298 - 0.83333333333333333333333333333333333333333333333333e-9 * t317 * t298 - 0.27777777777777777777777777777777777777777777777777e-17 * t281 * t306 - 0.71296296296296296296296296296296296296296296296297e-8 * t323 * t325 + 0.10185185185185185185185185185185185185185185185185e-16 * t323 * t329 + 0.11446416666666666666666666666666666666666666666666e-9 * t333 * t336 + 0.30437874155000000000000000000000000000000000000000e-10 * t340 * t343 - 0.31217499999999999999999999999999999999999999999999e-10 * t333 * t348 - 0.69372222222222222222222222222222222222222222222219e-19 * t333 * t353 - 0.62434999999999999999999999999999999999999999999998e-10 * t357 * t358 - 0.20811666666666666666666666666666666666666666666666e-10 * t362 * t358 - 0.5e1 / 0.36e2 * t141 * t368 - 0.3e1 / 0.8e1 * t252 * t372 + t30 * t376 / 0.4e1 - 0.3e1 / 0.8e1 * t397 * t399
  t404 = f.my_piecewise3(t1, 0, t309 + t402)
  t406 = r1 <= f.p.dens_threshold
  t407 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t408 = 0.1e1 + t407
  t409 = t408 <= f.p.zeta_threshold
  t410 = t408 ** (0.1e1 / 0.3e1)
  t411 = t410 ** 2
  t413 = 0.1e1 / t411 / t408
  t415 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t416 = t415 ** 2
  t420 = 0.1e1 / t411
  t421 = t420 * t415
  t423 = f.my_piecewise5(t14, 0, t10, 0, -t246)
  t427 = f.my_piecewise5(t14, 0, t10, 0, -t391)
  t431 = f.my_piecewise3(t409, 0, -0.8e1 / 0.27e2 * t413 * t416 * t415 + 0.4e1 / 0.3e1 * t421 * t423 + 0.4e1 / 0.3e1 * t410 * t427)
  t432 = t5 * t431
  t433 = r1 ** 2
  t434 = r1 ** (0.1e1 / 0.3e1)
  t435 = t434 ** 2
  t439 = t37 * s2 / t435 / t433
  t441 = s2 ** 2
  t442 = t433 ** 2
  t443 = t442 * r1
  t451 = t442 ** 2
  t455 = t441 ** 2
  t471 = t451 ** 2
  t476 = (0.1e1 + 0.20588079936467259282987640479431942553589065961934e0 * t439 + 0.51718749999999999999999999999999999999999999999998e-1 * t49 * t441 / t434 / t443 + 0.97296006944444444444444444444444444444444444444445e-2 * t59 * t441 * s2 / t451 + 0.21916594328703703703703703703703703703703703703704e-3 * t68 * t455 / t435 / t451 / t433 + 0.11831024546682098765432098765432098765432098765432e-2 * t79 * t455 * s2 / t434 / t451 / t443 + 0.10538736979166666666666666666666666666666666666667e-4 * t88 * t455 * t441 / t471) ** 0.24974e-1
  t480 = 0.1e1 / (0.1e1 + 0.41666666666666666666666666666666666666666666666666e-9 * t439)
  t481 = t31 * t476 * t480
  t489 = f.my_piecewise3(t409, 0, 0.4e1 / 0.9e1 * t420 * t416 + 0.4e1 / 0.3e1 * t410 * t423)
  t490 = t5 * t489
  t492 = t189 * t476 * t480
  t497 = f.my_piecewise3(t409, 0, 0.4e1 / 0.3e1 * t410 * t415)
  t498 = t5 * t497
  t500 = t195 * t476 * t480
  t504 = f.my_piecewise3(t409, t138, t410 * t408)
  t505 = t5 * t504
  t507 = t366 * t476 * t480
  t511 = f.my_piecewise3(t406, 0, -0.3e1 / 0.8e1 * t432 * t481 - 0.3e1 / 0.8e1 * t490 * t492 + t498 * t500 / 0.4e1 - 0.5e1 / 0.36e2 * t505 * t507)
  t519 = 0.1e1 / t40 / t149
  t524 = 0.1e1 / t39 / t155
  t528 = 0.1e1 / t116
  t532 = 0.1e1 / t40 / t165
  t558 = t95 ** (-0.3975026e1)
  t560 = t176 ** 2
  t573 = t132 ** 2
  t591 = 0.12487000000000000000000000000000000000000000000000e-1 * t141 * t196 * t133 - 0.37461000000000000000000000000000000000000000000000e-1 * t30 * t234 - 0.93652500000000000000000000000000000000000000000000e-2 * t141 * t97 * t100 * (0.53234166196218552891715202740891679610169061420587e2 * t37 * s0 * t519 + 0.10675771604938271604938271604938271604938271604938e3 * t49 * t50 * t524 + 0.77058437500000000000000000000000000000000000000000e2 * t61 * t528 + 0.47214296839277549154092363968907178783721993598536e1 * t68 * t69 * t532 + 0.56626496845112216125590611187319006249047401310775e2 * t79 * t80 / t39 / t171 + 0.98035546875000000000000000000000000000000000000002e0 * t90 / t91 / t51) + 0.24974000000000000000000000000000000000000000000000e-1 * t30 * t198 + 0.36525448986000000000000000000000000000000000000000e-1 * t30 * t191 - 0.24046237136341212000000000000000000000000000000000e-1 * t141 * t189 * t142 * t178 + 0.53653635512085487928634000000000000000000000000000e-1 * t141 * t31 * t558 * t100 * t560 - 0.12175149662000000000000000000000000000000000000000e-1 * t141 * t195 * t182 * t184 - 0.13874444444444444444444444444444444444444444444444e-1 * t141 * t366 * t96 * t197 + 0.27394086739500000000000000000000000000000000000000e-1 * t141 * t183 * t100 * t573 - 0.12487000000000000000000000000000000000000000000000e-1 * t141 * t201 * t233 - 0.37461000000000000000000000000000000000000000000000e-1 * t252 * t256 + 0.54788173479000000000000000000000000000000000000000e-1 * t252 * t185 - 0.37461000000000000000000000000000000000000000000000e-1 * t397 * t253 - 0.56191500000000000000000000000000000000000000000000e-1 * t252 * t134 - 0.37461000000000000000000000000000000000000000000000e-1 * t30 * t202
  t652 = -0.72138711409023636000000000000000000000000000000000e-1 * t30 * t179 + 0.12175149662000000000000000000000000000000000000000e-9 * t141 * t183 * t282 * t175 * t32 * t36 * t146 * t132 + 0.40401234567901234567901234567901234567901234567902e-7 * t323 * t283 * t284 * t519 - 0.95061728395061728395061728395061728395061728395063e-8 * t291 * t325 - 0.61728395061728395061728395061728395061728395061729e-9 * t5 * t140 * t366 * t270 * t298 - 0.16666666666666666666666666666666666666666666666667e-8 * t5 * t251 * t189 * t270 * t298 + 0.61111111111111111111111111111111111111111111111111e-8 * t317 * t286 - 0.28518518518518518518518518518518518518518518518519e-7 * t281 * t325 - 0.20370370370370370370370370370370370370370370370370e-8 * t296 * t286 + 0.12345679012345679012345679012345679012345679012346e-17 * t296 * t306 - 0.37037037037037037037037037037037037037037037037036e-17 * t317 * t306 - 0.16666666666666666666666666666666666666666666666667e-8 * t5 * t396 * t31 * t270 * t298 - 0.55555555555555555555555555555555555555555555555555e-17 * t312 * t306 - 0.10072016460905349794238683127572016460905349794238e-15 * t323 * t303 * t304 * t524 - 0.82304526748971193415637860082304526748971193415635e-34 * t268 * t322 / t272 / t99 * t69 * t532 * t32 * t36 + 0.91666666666666666666666666666666666666666666666666e-8 * t312 * t286 + 0.40740740740740740740740740740740740740740740740740e-16 * t281 * t329
  t714 = 0.13580246913580246913580246913580246913580246913580e-16 * t291 * t329 + 0.11111111111111111111111111111111111111111111111111e-8 * t5 * t29 * t195 * t270 * t298 - 0.71222148148148148148148148148148148148148148148145e-9 * t333 * t283 * t36 * t207 * t175 + 0.10174592592592592592592592592592592592592592592592e-17 * t333 * t303 * t48 * t212 * t175 + 0.22892833333333333333333333333333333333333333333332e-9 * t333 * t347 * t285 - 0.12487000000000000000000000000000000000000000000000e-9 * t5 * t310 * t96 * t358 - 0.83246666666666666666666666666666666666666666666665e-10 * t5 * t315 * t96 * t358 - 0.27748888888888888888888888888888888888888888888888e-18 * t357 * t353 + 0.27748888888888888888888888888888888888888888888888e-10 * t5 * t294 * t96 * t358 - 0.92496296296296296296296296296296296296296296296293e-19 * t362 * t353 + 0.45785666666666666666666666666666666666666666666666e-9 * t357 * t336 + 0.15261888888888888888888888888888888888888888888888e-9 * t362 * t336 - 0.22321107713666666666666666666666666666666666666666e-9 * t340 * t342 * t285 + 0.40583832206666666666666666666666666666666666666667e-10 * t5 * t289 * t182 * t343 - 0.80154123787804040000000000000000000000000000000000e-10 * t5 * t259 * t142 * t282 * t177 * t32 * t297 - 0.41623333333333333333333333333333333333333333333332e-10 * t362 * t348 + 0.12175149662000000000000000000000000000000000000000e-9 * t5 * t279 * t182 * t343
  t760 = 0.1e1 / t188 / t242
  t769 = t19 ** 2
  t772 = t239 ** 2
  t778 = t247 ** 2
  t787 = -0.24e2 * t388 + 0.24e2 * t16 / t387 / t6
  t788 = f.my_piecewise5(t10, 0, t14, 0, t787)
  t792 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t237 / t769 * t772 - 0.16e2 / 0.9e1 * t380 * t239 * t247 + 0.4e1 / 0.3e1 * t238 * t778 + 0.16e2 / 0.9e1 * t384 * t392 + 0.4e1 / 0.3e1 * t21 * t788)
  t801 = 0.13527944068888888888888888888888888888888888888888e-18 * t340 * t302 * t176 * t46 * t305 - 0.12487000000000000000000000000000000000000000000000e-9 * t357 * t348 - 0.41623333333333333333333333333333333333333333333332e-10 * t333 * t282 * t232 * t32 * t297 - 0.13874444444444444444444444444444444444444444444444e-18 * t333 * t302 * t132 * t46 * t305 + 0.36525448986000000000000000000000000000000000000000e-1 * t260 * t261 * t175 * t232 - 0.24691358024691358024691358024691358024691358024691e-25 * t268 * t289 * t276 + 0.40740740740740740740740740740740740740740740740740e-24 * t269 * t274 * t60 * t528 + 0.36525448986000000000000000000000000000000000000000e-1 * t5 * t289 * t263 - 0.10820806711353545400000000000000000000000000000000e0 * t260 * t142 * t100 * t176 * t132 - 0.74074074074074074074074074074074074074074074074072e-25 * t268 * t279 * t276 + 0.10957634695800000000000000000000000000000000000000e0 * t5 * t279 * t263 + t252 * t376 / 0.2e1 + 0.10e2 / 0.27e2 * t141 * t760 * t270 * t100 - 0.5e1 / 0.9e1 * t30 * t368 - t397 * t372 / 0.2e1 - 0.3e1 / 0.8e1 * t5 * t792 * t399 - 0.18499259259259259259259259259259259259259259259259e-26 * t269 * t96 * t273 * t275 * t175
  t804 = f.my_piecewise3(t1, 0, t591 + t652 + t714 + t801)
  t805 = t408 ** 2
  t808 = t416 ** 2
  t814 = t423 ** 2
  t820 = f.my_piecewise5(t14, 0, t10, 0, -t787)
  t824 = f.my_piecewise3(t409, 0, 0.40e2 / 0.81e2 / t411 / t805 * t808 - 0.16e2 / 0.9e1 * t413 * t416 * t423 + 0.4e1 / 0.3e1 * t420 * t814 + 0.16e2 / 0.9e1 * t421 * t427 + 0.4e1 / 0.3e1 * t410 * t820)
  t839 = f.my_piecewise3(t406, 0, -0.3e1 / 0.8e1 * t5 * t824 * t481 - t432 * t492 / 0.2e1 + t490 * t500 / 0.2e1 - 0.5e1 / 0.9e1 * t498 * t507 + 0.10e2 / 0.27e2 * t505 * t760 * t476 * t480)
  d1111 = 0.4e1 * t404 + 0.4e1 * t511 + t6 * (t804 + t839)

  res = {'v4rho4': d1111}
  return res
