"""Generated from gga_x_q1d.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_kappa = 0.804

  params_mu = MU_GE

  q1d_a = 0.06525

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  q1d_f1 = lambda s: pbe_f0(s) + (s ** 2 + s ** 4) / (1 + s ** 4 + s ** 6) * (-pbe_f0(s) * s ** 2 + q1d_a)

  q1d_f = lambda x: q1d_f1(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, q1d_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_kappa = 0.804

  params_mu = MU_GE

  q1d_a = 0.06525

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  q1d_f1 = lambda s: pbe_f0(s) + (s ** 2 + s ** 4) / (1 + s ** 4 + s ** 6) * (-pbe_f0(s) * s ** 2 + q1d_a)

  q1d_f = lambda x: q1d_f1(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, q1d_f, rs, zeta, xs0, xs1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_kappa = 0.804

  params_mu = MU_GE

  q1d_a = 0.06525

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  q1d_f1 = lambda s: pbe_f0(s) + (s ** 2 + s ** 4) / (1 + s ** 4 + s ** 6) * (-pbe_f0(s) * s ** 2 + q1d_a)

  q1d_f = lambda x: q1d_f1(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, q1d_f, rs, zeta, xs0, xs1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = jnp.pi ** 2
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = 0.1e1 / t31
  t33 = t28 * t32
  t34 = r0 ** 2
  t35 = r0 ** (0.1e1 / 0.3e1)
  t36 = t35 ** 2
  t38 = 0.1e1 / t36 / t34
  t40 = t33 * s0 * t38
  t42 = 0.8040e0 + 0.5e1 / 0.972e3 * t40
  t44 = 0.64641600e0 / t42
  t46 = t28 ** 2
  t48 = 0.1e1 / t30 / t29
  t49 = t46 * t48
  t50 = s0 ** 2
  t51 = t34 ** 2
  t54 = 0.1e1 / t35 / t51 / r0
  t57 = t49 * t50 * t54 / 0.576e3
  t58 = t40 / 0.24e2 + t57
  t59 = t29 ** 2
  t60 = 0.1e1 / t59
  t62 = t60 * t50 * s0
  t63 = t51 ** 2
  t64 = 0.1e1 / t63
  t67 = 0.1e1 + t57 + t62 * t64 / 0.2304e4
  t68 = 0.1e1 / t67
  t69 = t58 * t68
  t71 = (0.18040e1 - t44) * t28
  t72 = t32 * s0
  t76 = -t71 * t72 * t38 / 0.24e2 + 0.6525e-1
  t78 = 0.18040e1 - t44 + t69 * t76
  t82 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * t78)
  t83 = r1 <= f.p.dens_threshold
  t84 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t85 = 0.1e1 + t84
  t86 = t85 <= f.p.zeta_threshold
  t87 = t85 ** (0.1e1 / 0.3e1)
  t89 = f.my_piecewise3(t86, t22, t87 * t85)
  t90 = t89 * t26
  t91 = r1 ** 2
  t92 = r1 ** (0.1e1 / 0.3e1)
  t93 = t92 ** 2
  t95 = 0.1e1 / t93 / t91
  t97 = t33 * s2 * t95
  t99 = 0.8040e0 + 0.5e1 / 0.972e3 * t97
  t101 = 0.64641600e0 / t99
  t103 = s2 ** 2
  t104 = t91 ** 2
  t107 = 0.1e1 / t92 / t104 / r1
  t110 = t49 * t103 * t107 / 0.576e3
  t111 = t97 / 0.24e2 + t110
  t113 = t60 * t103 * s2
  t114 = t104 ** 2
  t115 = 0.1e1 / t114
  t118 = 0.1e1 + t110 + t113 * t115 / 0.2304e4
  t119 = 0.1e1 / t118
  t120 = t111 * t119
  t122 = (0.18040e1 - t101) * t28
  t123 = t32 * s2
  t127 = -t122 * t123 * t95 / 0.24e2 + 0.6525e-1
  t129 = 0.18040e1 - t101 + t120 * t127
  t133 = f.my_piecewise3(t83, 0, -0.3e1 / 0.8e1 * t5 * t90 * t129)
  t134 = t6 ** 2
  t136 = t16 / t134
  t137 = t7 - t136
  t138 = f.my_piecewise5(t10, 0, t14, 0, t137)
  t141 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t138)
  t146 = t26 ** 2
  t147 = 0.1e1 / t146
  t151 = t5 * t25 * t147 * t78 / 0.8e1
  t152 = t42 ** 2
  t153 = 0.1e1 / t152
  t154 = t153 * t28
  t157 = 0.1e1 / t36 / t34 / r0
  t158 = t72 * t157
  t166 = 0.1e1 / t35 / t51 / t34
  t169 = t49 * t50 * t166 / 0.108e3
  t173 = t67 ** 2
  t175 = t58 / t173
  t183 = t153 * t46
  t197 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t141 * t26 * t78 - t151 - 0.3e1 / 0.8e1 * t5 * t27 * (-0.88671604938271604938271604938271604938271604938272e-2 * t154 * t158 + (-t33 * s0 * t157 / 0.9e1 - t169) * t68 * t76 - t175 * t76 * (-t169 - t62 / t63 / r0 / 0.288e3) + t69 * (0.36946502057613168724279835390946502057613168724280e-3 * t183 * t48 * t50 * t166 + t71 * t158 / 0.9e1)))
  t199 = f.my_piecewise5(t14, 0, t10, 0, -t137)
  t202 = f.my_piecewise3(t86, 0, 0.4e1 / 0.3e1 * t87 * t199)
  t210 = t5 * t89 * t147 * t129 / 0.8e1
  t212 = f.my_piecewise3(t83, 0, -0.3e1 / 0.8e1 * t5 * t202 * t26 * t129 - t210)
  vrho_0_ = t82 + t133 + t6 * (t197 + t212)
  t215 = -t7 - t136
  t216 = f.my_piecewise5(t10, 0, t14, 0, t215)
  t219 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t216)
  t225 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t219 * t26 * t78 - t151)
  t227 = f.my_piecewise5(t14, 0, t10, 0, -t215)
  t230 = f.my_piecewise3(t86, 0, 0.4e1 / 0.3e1 * t87 * t227)
  t235 = t99 ** 2
  t236 = 0.1e1 / t235
  t237 = t236 * t28
  t240 = 0.1e1 / t93 / t91 / r1
  t241 = t123 * t240
  t249 = 0.1e1 / t92 / t104 / t91
  t252 = t49 * t103 * t249 / 0.108e3
  t256 = t118 ** 2
  t258 = t111 / t256
  t266 = t236 * t46
  t280 = f.my_piecewise3(t83, 0, -0.3e1 / 0.8e1 * t5 * t230 * t26 * t129 - t210 - 0.3e1 / 0.8e1 * t5 * t90 * (-0.88671604938271604938271604938271604938271604938272e-2 * t237 * t241 + (-t33 * s2 * t240 / 0.9e1 - t252) * t119 * t127 - t258 * t127 * (-t252 - t113 / t114 / r1 / 0.288e3) + t120 * (0.36946502057613168724279835390946502057613168724280e-3 * t266 * t48 * t103 * t249 + t122 * t241 / 0.9e1)))
  vrho_1_ = t82 + t133 + t6 * (t225 + t280)
  t283 = t32 * t38
  t290 = t49 * s0 * t54 / 0.288e3
  t312 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t27 * (0.33251851851851851851851851851851851851851851851852e-2 * t154 * t283 + (t33 * t38 / 0.24e2 + t290) * t68 * t76 - t175 * t76 * (t290 + t60 * t50 * t64 / 0.768e3) + t69 * (-0.13854938271604938271604938271604938271604938271605e-3 * t183 * t48 * t54 * s0 - t71 * t283 / 0.24e2)))
  vsigma_0_ = t6 * t312
  vsigma_1_ = 0.0e0
  t313 = t32 * t95
  t320 = t49 * s2 * t107 / 0.288e3
  t342 = f.my_piecewise3(t83, 0, -0.3e1 / 0.8e1 * t5 * t90 * (0.33251851851851851851851851851851851851851851851852e-2 * t237 * t313 + (t33 * t95 / 0.24e2 + t320) * t119 * t127 - t258 * t127 * (t320 + t60 * t103 * t115 / 0.768e3) + t120 * (-0.13854938271604938271604938271604938271604938271605e-3 * t266 * t48 * t107 * s2 - t122 * t313 / 0.24e2)))
  vsigma_2_ = t6 * t342
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_kappa = 0.804

  params_mu = MU_GE

  q1d_a = 0.06525

  pbe_f0 = lambda s: 1 + params_kappa * (1 - params_kappa / (params_kappa + params_mu * s ** 2))

  q1d_f1 = lambda s: pbe_f0(s) + (s ** 2 + s ** 4) / (1 + s ** 4 + s ** 6) * (-pbe_f0(s) * s ** 2 + q1d_a)

  q1d_f = lambda x: q1d_f1(X2S * x)

  functional_body = lambda rs, zeta, xt, xs0, xs1: gga_exchange(f, params, q1d_f, rs, zeta, xs0, xs1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = 6 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** 2
  t22 = t21 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = 0.1e1 / t23
  t25 = t20 * t24
  t26 = 2 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = s0 * t27
  t29 = r0 ** 2
  t30 = t18 ** 2
  t32 = 0.1e1 / t30 / t29
  t33 = t28 * t32
  t34 = t25 * t33
  t36 = 0.8040e0 + 0.5e1 / 0.972e3 * t34
  t38 = 0.64641600e0 / t36
  t40 = t20 ** 2
  t42 = 0.1e1 / t22 / t21
  t43 = t40 * t42
  t44 = s0 ** 2
  t45 = t44 * t26
  t46 = t29 ** 2
  t49 = 0.1e1 / t18 / t46 / r0
  t52 = t43 * t45 * t49 / 0.288e3
  t53 = t34 / 0.24e2 + t52
  t54 = t21 ** 2
  t55 = 0.1e1 / t54
  t57 = t55 * t44 * s0
  t58 = t46 ** 2
  t59 = 0.1e1 / t58
  t62 = 0.1e1 + t52 + t57 * t59 / 0.576e3
  t63 = 0.1e1 / t62
  t64 = t53 * t63
  t66 = (0.18040e1 - t38) * t20
  t67 = t66 * t24
  t70 = -t67 * t33 / 0.24e2 + 0.6525e-1
  t72 = 0.18040e1 - t38 + t64 * t70
  t76 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * t72)
  t82 = t36 ** 2
  t83 = 0.1e1 / t82
  t84 = t83 * t20
  t89 = t28 / t30 / t29 / r0
  t97 = t45 / t18 / t46 / t29
  t99 = t43 * t97 / 0.54e2
  t103 = t62 ** 2
  t105 = t53 / t103
  t114 = t83 * t40 * t42
  t126 = f.my_piecewise3(t2, 0, -t6 * t17 / t30 * t72 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t19 * (-0.88671604938271604938271604938271604938271604938272e-2 * t84 * t24 * t89 + (-t25 * t89 / 0.9e1 - t99) * t63 * t70 - t105 * t70 * (-t99 - t57 / t58 / r0 / 0.72e2) + t64 * (0.73893004115226337448559670781893004115226337448558e-3 * t114 * t97 + t67 * t89 / 0.9e1)))
  vrho_0_ = 0.2e1 * r0 * t126 + 0.2e1 * t76
  t130 = t24 * t27 * t32
  t137 = s0 * t26 * t49
  t139 = t43 * t137 / 0.144e3
  t159 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t19 * (0.33251851851851851851851851851851851851851851851852e-2 * t84 * t130 + (t25 * t27 * t32 / 0.24e2 + t139) * t63 * t70 - t105 * t70 * (t139 + t55 * t44 * t59 / 0.192e3) + t64 * (-0.27709876543209876543209876543209876543209876543210e-3 * t114 * t137 - t66 * t130 / 0.24e2)))
  vsigma_0_ = 0.2e1 * r0 * t159
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t22 = 6 ** (0.1e1 / 0.3e1)
  t23 = jnp.pi ** 2
  t24 = t23 ** (0.1e1 / 0.3e1)
  t25 = t24 ** 2
  t26 = 0.1e1 / t25
  t27 = t22 * t26
  t28 = 2 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = s0 * t29
  t31 = r0 ** 2
  t33 = 0.1e1 / t19 / t31
  t34 = t30 * t33
  t35 = t27 * t34
  t37 = 0.8040e0 + 0.5e1 / 0.972e3 * t35
  t39 = 0.64641600e0 / t37
  t41 = t22 ** 2
  t43 = 0.1e1 / t24 / t23
  t44 = t41 * t43
  t45 = s0 ** 2
  t46 = t45 * t28
  t47 = t31 ** 2
  t50 = 0.1e1 / t18 / t47 / r0
  t53 = t44 * t46 * t50 / 0.288e3
  t54 = t35 / 0.24e2 + t53
  t55 = t23 ** 2
  t56 = 0.1e1 / t55
  t57 = t45 * s0
  t58 = t56 * t57
  t59 = t47 ** 2
  t60 = 0.1e1 / t59
  t63 = 0.1e1 + t53 + t58 * t60 / 0.576e3
  t64 = 0.1e1 / t63
  t65 = t54 * t64
  t67 = (0.18040e1 - t39) * t22
  t68 = t67 * t26
  t71 = -t68 * t34 / 0.24e2 + 0.6525e-1
  t73 = 0.18040e1 - t39 + t65 * t71
  t77 = t17 * t18
  t78 = t37 ** 2
  t79 = 0.1e1 / t78
  t80 = t79 * t22
  t81 = t80 * t26
  t82 = t31 * r0
  t84 = 0.1e1 / t19 / t82
  t85 = t30 * t84
  t92 = 0.1e1 / t18 / t47 / t31
  t93 = t46 * t92
  t95 = t44 * t93 / 0.54e2
  t96 = -t27 * t85 / 0.9e1 - t95
  t97 = t96 * t64
  t99 = t63 ** 2
  t100 = 0.1e1 / t99
  t101 = t54 * t100
  t103 = 0.1e1 / t59 / r0
  t106 = -t95 - t58 * t103 / 0.72e2
  t107 = t71 * t106
  t109 = t79 * t41
  t110 = t109 * t43
  t115 = 0.73893004115226337448559670781893004115226337448558e-3 * t110 * t93 + t68 * t85 / 0.9e1
  t117 = -0.88671604938271604938271604938271604938271604938272e-2 * t81 * t85 + t97 * t71 - t101 * t107 + t65 * t115
  t122 = f.my_piecewise3(t2, 0, -t6 * t21 * t73 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t77 * t117)
  t134 = 0.1e1 / t78 / t37
  t135 = t134 * t41
  t136 = t135 * t43
  t140 = t46 / t18 / t47 / t82
  t145 = t30 / t19 / t47
  t151 = 0.19e2 / 0.162e3 * t44 * t140
  t155 = t96 * t100
  t162 = t54 / t99 / t63
  t163 = t106 ** 2
  t171 = 0.1e1 / t59 / t31
  t177 = t134 * t56
  t192 = f.my_piecewise3(t2, 0, t6 * t17 / t19 / r0 * t73 / 0.12e2 - t6 * t21 * t117 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t77 * (-0.48653829870107876509339700926349303121136683093702e-3 * t136 * t140 + 0.32512921810699588477366255144032921810699588477366e-1 * t81 * t145 + (0.11e2 / 0.27e2 * t27 * t145 + t151) * t64 * t71 - 0.2e1 * t155 * t107 + 0.2e1 * t97 * t115 + 0.2e1 * t162 * t71 * t163 - 0.2e1 * t101 * t115 * t106 - t101 * t71 * (t151 + t58 * t171 / 0.8e1) + t65 * (0.24326914935053938254669850463174651560568341546850e-3 * t177 * t57 * t171 - 0.66503703703703703703703703703703703703703703703702e-2 * t110 * t140 - 0.11e2 / 0.27e2 * t68 * t145)))
  v2rho2_0_ = 0.2e1 * r0 * t192 + 0.4e1 * t122
  t195 = t26 * t29
  t196 = t195 * t33
  t203 = s0 * t28 * t50
  t205 = t44 * t203 / 0.144e3
  t206 = t27 * t29 * t33 / 0.24e2 + t205
  t207 = t206 * t64
  t209 = t56 * t45
  t212 = t205 + t209 * t60 / 0.192e3
  t213 = t71 * t212
  t219 = -0.27709876543209876543209876543209876543209876543210e-3 * t110 * t203 - t67 * t196 / 0.24e2
  t221 = 0.33251851851851851851851851851851851851851851851852e-2 * t80 * t196 + t207 * t71 - t101 * t213 + t65 * t219
  t225 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t77 * t221)
  t230 = t28 * t92 * s0
  t233 = t195 * t84
  t240 = t44 * t230 / 0.27e2
  t244 = t206 * t100
  t270 = 0.18245186201290453691002387847380988670426256160138e-3 * t136 * t230 - 0.88671604938271604938271604938271604938271604938272e-2 * t80 * t233 + (-t27 * t29 * t84 / 0.9e1 - t240) * t64 * t71 - t244 * t107 + t207 * t115 - t155 * t213 + 0.2e1 * t162 * t213 * t106 - t101 * t115 * t212 - t101 * t71 * (-t240 - t209 * t103 / 0.24e2) + t97 * t219 - t101 * t219 * t106 + t65 * (-0.91225931006452268455011939236904943352131280800691e-4 * t177 * t103 * t45 + 0.22167901234567901234567901234567901234567901234568e-2 * t110 * t230 + t67 * t233 / 0.9e1)
  t275 = f.my_piecewise3(t2, 0, -t6 * t21 * t221 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t77 * t270)
  v2rhosigma_0_ = 0.2e1 * r0 * t275 + 0.2e1 * t225
  t279 = t43 * t28 * t50
  t291 = t212 ** 2
  t318 = f.my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t77 * (-0.68419448254839201341258954427678707514098460600519e-4 * t135 * t279 + t44 * t28 * t50 * t64 * t71 / 0.144e3 - 0.2e1 * t244 * t213 + 0.2e1 * t207 * t219 + 0.2e1 * t162 * t71 * t291 - 0.2e1 * t101 * t219 * t212 - t101 * t71 * (t44 * t28 * t50 / 0.144e3 + t56 * s0 * t60 / 0.96e2) + t65 * (0.34209724127419600670629477213839353757049230300259e-4 * t177 * t60 * s0 - 0.55419753086419753086419753086419753086419753086420e-3 * t109 * t279)))
  v2sigma2_0_ = 0.2e1 * r0 * t318
  res = {'v2rho2': v2rho2_0_, 'v2rhosigma': v2rhosigma_0_, 'v2sigma2': v2sigma2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t22 = t17 / t19 / r0
  t23 = 6 ** (0.1e1 / 0.3e1)
  t24 = jnp.pi ** 2
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = 0.1e1 / t26
  t28 = t23 * t27
  t29 = 2 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = s0 * t30
  t32 = r0 ** 2
  t34 = 0.1e1 / t19 / t32
  t35 = t31 * t34
  t36 = t28 * t35
  t38 = 0.8040e0 + 0.5e1 / 0.972e3 * t36
  t40 = 0.64641600e0 / t38
  t42 = t23 ** 2
  t44 = 0.1e1 / t25 / t24
  t45 = t42 * t44
  t46 = s0 ** 2
  t47 = t46 * t29
  t48 = t32 ** 2
  t49 = t48 * r0
  t54 = t45 * t47 / t18 / t49 / 0.288e3
  t55 = t36 / 0.24e2 + t54
  t56 = t24 ** 2
  t57 = 0.1e1 / t56
  t58 = t46 * s0
  t59 = t57 * t58
  t60 = t48 ** 2
  t64 = 0.1e1 + t54 + t59 / t60 / 0.576e3
  t65 = 0.1e1 / t64
  t66 = t55 * t65
  t69 = (0.18040e1 - t40) * t23 * t27
  t72 = -t69 * t35 / 0.24e2 + 0.6525e-1
  t74 = 0.18040e1 - t40 + t66 * t72
  t79 = t17 / t19
  t80 = t38 ** 2
  t81 = 0.1e1 / t80
  t83 = t81 * t23 * t27
  t84 = t32 * r0
  t87 = t31 / t19 / t84
  t95 = t47 / t18 / t48 / t32
  t97 = t45 * t95 / 0.54e2
  t98 = -t28 * t87 / 0.9e1 - t97
  t99 = t98 * t65
  t101 = t64 ** 2
  t102 = 0.1e1 / t101
  t103 = t55 * t102
  t108 = -t97 - t59 / t60 / r0 / 0.72e2
  t109 = t72 * t108
  t112 = t81 * t42 * t44
  t117 = 0.73893004115226337448559670781893004115226337448558e-3 * t112 * t95 + t69 * t87 / 0.9e1
  t119 = -0.88671604938271604938271604938271604938271604938272e-2 * t83 * t87 + t99 * t72 - t103 * t109 + t66 * t117
  t123 = t17 * t18
  t125 = 0.1e1 / t80 / t38
  t127 = t125 * t42 * t44
  t131 = t47 / t18 / t48 / t84
  t136 = t31 / t19 / t48
  t142 = 0.19e2 / 0.162e3 * t45 * t131
  t143 = 0.11e2 / 0.27e2 * t28 * t136 + t142
  t144 = t143 * t65
  t146 = t98 * t102
  t152 = 0.1e1 / t101 / t64
  t153 = t55 * t152
  t154 = t108 ** 2
  t155 = t72 * t154
  t158 = t117 * t108
  t162 = 0.1e1 / t60 / t32
  t165 = t142 + t59 * t162 / 0.8e1
  t166 = t72 * t165
  t168 = t125 * t57
  t176 = 0.24326914935053938254669850463174651560568341546850e-3 * t168 * t58 * t162 - 0.66503703703703703703703703703703703703703703703702e-2 * t112 * t131 - 0.11e2 / 0.27e2 * t69 * t136
  t178 = -0.48653829870107876509339700926349303121136683093702e-3 * t127 * t131 + 0.32512921810699588477366255144032921810699588477366e-1 * t83 * t136 + t144 * t72 - 0.2e1 * t146 * t109 + 0.2e1 * t99 * t117 + 0.2e1 * t153 * t155 - 0.2e1 * t103 * t158 - t103 * t166 + t66 * t176
  t183 = f.my_piecewise3(t2, 0, t6 * t22 * t74 / 0.12e2 - t6 * t79 * t119 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t123 * t178)
  t197 = t80 ** 2
  t199 = 0.1e1 / t197 * t57
  t200 = t46 ** 2
  t211 = 0.1e1 / t60 / t84
  t212 = t58 * t211
  t217 = t47 / t18 / t60
  t222 = t31 / t19 / t49
  t230 = 0.209e3 / 0.243e3 * t45 * t217
  t243 = t101 ** 2
  t276 = 0.3e1 * t99 * t176 + t66 * (0.10011076104960468417559609244104794880892321624218e-4 * t199 * t200 / t19 / t60 / t49 * t23 * t27 * t30 - 0.46221138376602482683872715880031837965079848939015e-2 * t168 * t212 + 0.55994476451760402377686328303612254229538180155463e-1 * t112 * t217 + 0.154e3 / 0.81e2 * t69 * t222) + (-0.154e3 / 0.81e2 * t28 * t222 - t230) * t65 * t72 + 0.3e1 * t144 * t117 + 0.53519212857118664160273671018984233433250351403072e-2 * t127 * t217 - 0.15172696844993141289437585733882030178326474622771e0 * t83 * t222 + 0.6e1 * t98 * t152 * t155 - 0.6e1 * t55 / t243 * t72 * t154 * t108 + 0.6e1 * t153 * t109 * t165 - 0.24026582651905124202143062185851507714141571898124e-3 * t199 * t212 - 0.3e1 * t143 * t102 * t109 - 0.6e1 * t146 * t158 - 0.3e1 * t146 * t166 + 0.6e1 * t153 * t117 * t154 - 0.3e1 * t103 * t176 * t108 - 0.3e1 * t103 * t117 * t165 - t103 * t72 * (-t230 - 0.5e1 / 0.4e1 * t59 * t211)
  t281 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t17 * t34 * t74 + t6 * t22 * t119 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t79 * t178 - 0.3e1 / 0.8e1 * t6 * t123 * t276)
  v3rho3_0_ = 0.2e1 * r0 * t281 + 0.6e1 * t183

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t22 = 0.1e1 / t20 / t18
  t23 = t17 * t22
  t24 = 6 ** (0.1e1 / 0.3e1)
  t25 = jnp.pi ** 2
  t26 = t25 ** (0.1e1 / 0.3e1)
  t27 = t26 ** 2
  t28 = 0.1e1 / t27
  t29 = t24 * t28
  t30 = 2 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = s0 * t31
  t33 = t32 * t22
  t34 = t29 * t33
  t36 = 0.8040e0 + 0.5e1 / 0.972e3 * t34
  t38 = 0.64641600e0 / t36
  t40 = t24 ** 2
  t42 = 0.1e1 / t26 / t25
  t43 = t40 * t42
  t44 = s0 ** 2
  t45 = t44 * t30
  t46 = t18 ** 2
  t47 = t46 * r0
  t52 = t43 * t45 / t19 / t47 / 0.288e3
  t53 = t34 / 0.24e2 + t52
  t54 = t25 ** 2
  t55 = 0.1e1 / t54
  t56 = t44 * s0
  t57 = t55 * t56
  t58 = t46 ** 2
  t62 = 0.1e1 + t52 + t57 / t58 / 0.576e3
  t63 = 0.1e1 / t62
  t64 = t53 * t63
  t67 = (0.18040e1 - t38) * t24 * t28
  t70 = -t67 * t33 / 0.24e2 + 0.6525e-1
  t72 = 0.18040e1 - t38 + t64 * t70
  t78 = t17 / t20 / r0
  t79 = t36 ** 2
  t80 = 0.1e1 / t79
  t82 = t80 * t24 * t28
  t83 = t18 * r0
  t85 = 0.1e1 / t20 / t83
  t86 = t32 * t85
  t91 = t46 * t18
  t94 = t45 / t19 / t91
  t96 = t43 * t94 / 0.54e2
  t97 = -t29 * t86 / 0.9e1 - t96
  t98 = t97 * t63
  t100 = t62 ** 2
  t101 = 0.1e1 / t100
  t102 = t53 * t101
  t103 = t58 * r0
  t107 = -t96 - t57 / t103 / 0.72e2
  t108 = t70 * t107
  t111 = t80 * t40 * t42
  t116 = 0.73893004115226337448559670781893004115226337448558e-3 * t111 * t94 + t67 * t86 / 0.9e1
  t118 = -0.88671604938271604938271604938271604938271604938272e-2 * t82 * t86 + t98 * t70 - t102 * t108 + t64 * t116
  t123 = t17 / t20
  t125 = 0.1e1 / t79 / t36
  t127 = t125 * t40 * t42
  t131 = t45 / t19 / t46 / t83
  t136 = t32 / t20 / t46
  t142 = 0.19e2 / 0.162e3 * t43 * t131
  t143 = 0.11e2 / 0.27e2 * t29 * t136 + t142
  t144 = t143 * t63
  t146 = t97 * t101
  t152 = 0.1e1 / t100 / t62
  t153 = t53 * t152
  t154 = t107 ** 2
  t155 = t70 * t154
  t158 = t116 * t107
  t162 = 0.1e1 / t58 / t18
  t165 = t142 + t57 * t162 / 0.8e1
  t166 = t70 * t165
  t168 = t125 * t55
  t176 = 0.24326914935053938254669850463174651560568341546850e-3 * t168 * t56 * t162 - 0.66503703703703703703703703703703703703703703703702e-2 * t111 * t131 - 0.11e2 / 0.27e2 * t67 * t136
  t178 = -0.48653829870107876509339700926349303121136683093702e-3 * t127 * t131 + 0.32512921810699588477366255144032921810699588477366e-1 * t82 * t136 + t144 * t70 - 0.2e1 * t146 * t108 + 0.2e1 * t98 * t116 + 0.2e1 * t153 * t155 - 0.2e1 * t102 * t158 - t102 * t166 + t64 * t176
  t182 = t17 * t19
  t183 = t79 ** 2
  t185 = 0.1e1 / t183 * t55
  t186 = t44 ** 2
  t187 = t185 * t186
  t192 = t28 * t31
  t197 = 0.1e1 / t58 / t83
  t198 = t56 * t197
  t203 = t45 / t19 / t58
  t208 = t32 / t20 / t47
  t211 = 0.10011076104960468417559609244104794880892321624218e-4 * t187 / t20 / t58 / t47 * t24 * t192 - 0.46221138376602482683872715880031837965079848939015e-2 * t168 * t198 + 0.55994476451760402377686328303612254229538180155463e-1 * t111 * t203 + 0.154e3 / 0.81e2 * t67 * t208
  t220 = 0.209e3 / 0.243e3 * t43 * t203
  t221 = -0.154e3 / 0.81e2 * t29 * t208 - t220
  t222 = t221 * t63
  t228 = t97 * t152
  t231 = t100 ** 2
  t232 = 0.1e1 / t231
  t233 = t53 * t232
  t234 = t154 * t107
  t235 = t70 * t234
  t238 = t108 * t165
  t243 = t143 * t101
  t250 = t116 * t154
  t253 = t176 * t107
  t256 = t116 * t165
  t261 = -t220 - 0.5e1 / 0.4e1 * t57 * t197
  t262 = t70 * t261
  t264 = t64 * t211 + 0.3e1 * t144 * t116 + 0.3e1 * t98 * t176 + t222 * t70 + 0.53519212857118664160273671018984233433250351403072e-2 * t127 * t203 - 0.15172696844993141289437585733882030178326474622771e0 * t82 * t208 + 0.6e1 * t228 * t155 - 0.6e1 * t233 * t235 + 0.6e1 * t153 * t238 - 0.24026582651905124202143062185851507714141571898124e-3 * t185 * t198 - 0.3e1 * t243 * t108 - 0.6e1 * t146 * t158 - 0.3e1 * t146 * t166 + 0.6e1 * t153 * t250 - 0.3e1 * t102 * t253 - 0.3e1 * t102 * t256 - t102 * t262
  t269 = f.my_piecewise3(t2, 0, -0.5e1 / 0.36e2 * t6 * t23 * t72 + t6 * t78 * t118 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t123 * t178 - 0.3e1 / 0.8e1 * t6 * t182 * t264)
  t286 = t32 / t20 / t91
  t291 = t45 / t19 / t103
  t293 = 0.5225e4 / 0.729e3 * t43 * t291
  t301 = 0.1e1 / t183 / t36 * t55
  t304 = t58 ** 2
  t317 = 0.1e1 / t20 / t58 / t91 * t24 * t192
  t321 = 0.1e1 / t58 / t46
  t322 = t56 * t321
  t360 = (0.2618e4 / 0.243e3 * t29 * t286 + t293) * t63 * t70 + 0.4e1 * t98 * t211 + t64 * (0.10986091747556069594029749513420899732117774073216e-5 * t301 * t186 * s0 / t19 / t304 / r0 * t40 * t42 * t30 - 0.32702848609537530164028056864075663277581583972445e-3 * t187 * t317 + 0.69277647753936937496354251930129591055262954871752e-1 * t168 * t322 - 0.50033774119798811156835848193872885230909922267946e0 * t111 * t291 - 0.2618e4 / 0.243e3 * t67 * t286) + 0.4e1 * t222 * t116 + 0.6e1 * t144 * t176 - 0.36e2 * t233 * t155 * t165 + 0.24e2 * t153 * t158 * t165 + 0.8e1 * t153 * t108 * t261 + 0.24e2 * t228 * t238 + 0.85978615454961133973479652491998171010516689529036e0 * t82 * t286 - 0.52924554936484012336270630229884408617325347498593e-1 * t127 * t291 - 0.4e1 * t221 * t101 * t108 + 0.52858481834191273244714736808873316971111458175873e-2 * t185 * t322 + 0.12e2 * t143 * t152 * t155 + 0.24e2 * t228 * t250
  t390 = t154 ** 2
  t394 = t165 ** 2
  t408 = -0.24e2 * t233 * t116 * t234 - 0.6e1 * t243 * t166 - 0.12e2 * t146 * t256 - 0.4e1 * t146 * t262 + 0.12e2 * t153 * t176 * t154 - 0.6e1 * t102 * t176 * t165 - 0.4e1 * t102 * t116 * t261 - t102 * t70 * (t293 + 0.55e2 / 0.4e1 * t57 * t321) - 0.24e2 * t97 * t232 * t235 + 0.24e2 * t53 / t231 / t62 * t70 * t390 + 0.6e1 * t153 * t70 * t394 - 0.4e1 * t102 * t211 * t107 - 0.12e2 * t243 * t158 - 0.12e2 * t146 * t253 - 0.13183310097067283512835699416105079678541328887860e-4 * t301 * t186 * t317
  t414 = f.my_piecewise3(t2, 0, 0.10e2 / 0.27e2 * t6 * t17 * t85 * t72 - 0.5e1 / 0.9e1 * t6 * t23 * t118 + t6 * t78 * t178 / 0.2e1 - t6 * t123 * t264 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t182 * (t360 + t408))
  v4rho4_0_ = 0.2e1 * r0 * t414 + 0.8e1 * t269

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = 6 ** (0.1e1 / 0.3e1)
  t33 = jnp.pi ** 2
  t34 = t33 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t36 = 0.1e1 / t35
  t37 = t32 * t36
  t38 = r0 ** 2
  t39 = r0 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t42 = 0.1e1 / t40 / t38
  t44 = t37 * s0 * t42
  t46 = 0.8040e0 + 0.5e1 / 0.972e3 * t44
  t48 = 0.64641600e0 / t46
  t50 = t32 ** 2
  t52 = 0.1e1 / t34 / t33
  t53 = t50 * t52
  t54 = s0 ** 2
  t55 = t38 ** 2
  t61 = t53 * t54 / t39 / t55 / r0 / 0.576e3
  t62 = t44 / 0.24e2 + t61
  t63 = t33 ** 2
  t64 = 0.1e1 / t63
  t65 = t54 * s0
  t66 = t64 * t65
  t67 = t55 ** 2
  t71 = 0.1e1 + t61 + t66 / t67 / 0.2304e4
  t72 = 0.1e1 / t71
  t73 = t62 * t72
  t75 = (0.18040e1 - t48) * t32
  t76 = t36 * s0
  t80 = -t75 * t76 * t42 / 0.24e2 + 0.6525e-1
  t82 = 0.18040e1 - t48 + t73 * t80
  t86 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t87 = t86 * f.p.zeta_threshold
  t89 = f.my_piecewise3(t20, t87, t21 * t19)
  t90 = t30 ** 2
  t91 = 0.1e1 / t90
  t92 = t89 * t91
  t95 = t5 * t92 * t82 / 0.8e1
  t96 = t89 * t30
  t97 = t46 ** 2
  t98 = 0.1e1 / t97
  t99 = t98 * t32
  t100 = t38 * r0
  t102 = 0.1e1 / t40 / t100
  t103 = t76 * t102
  t111 = 0.1e1 / t39 / t55 / t38
  t114 = t53 * t54 * t111 / 0.108e3
  t115 = -t37 * s0 * t102 / 0.9e1 - t114
  t116 = t115 * t72
  t118 = t71 ** 2
  t119 = 0.1e1 / t118
  t120 = t62 * t119
  t125 = -t114 - t66 / t67 / r0 / 0.288e3
  t126 = t80 * t125
  t128 = t98 * t50
  t129 = t52 * t54
  t135 = 0.36946502057613168724279835390946502057613168724280e-3 * t128 * t129 * t111 + t75 * t103 / 0.9e1
  t137 = -0.88671604938271604938271604938271604938271604938272e-2 * t99 * t103 + t116 * t80 - t120 * t126 + t73 * t135
  t142 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t31 * t82 - t95 - 0.3e1 / 0.8e1 * t5 * t96 * t137)
  t144 = r1 <= f.p.dens_threshold
  t145 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t146 = 0.1e1 + t145
  t147 = t146 <= f.p.zeta_threshold
  t148 = t146 ** (0.1e1 / 0.3e1)
  t150 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t153 = f.my_piecewise3(t147, 0, 0.4e1 / 0.3e1 * t148 * t150)
  t154 = t153 * t30
  t155 = r1 ** 2
  t156 = r1 ** (0.1e1 / 0.3e1)
  t157 = t156 ** 2
  t159 = 0.1e1 / t157 / t155
  t161 = t37 * s2 * t159
  t163 = 0.8040e0 + 0.5e1 / 0.972e3 * t161
  t165 = 0.64641600e0 / t163
  t167 = s2 ** 2
  t168 = t155 ** 2
  t174 = t53 * t167 / t156 / t168 / r1 / 0.576e3
  t175 = t161 / 0.24e2 + t174
  t176 = t167 * s2
  t177 = t64 * t176
  t178 = t168 ** 2
  t182 = 0.1e1 + t174 + t177 / t178 / 0.2304e4
  t183 = 0.1e1 / t182
  t184 = t175 * t183
  t186 = (0.18040e1 - t165) * t32
  t187 = t36 * s2
  t191 = -t186 * t187 * t159 / 0.24e2 + 0.6525e-1
  t193 = 0.18040e1 - t165 + t184 * t191
  t198 = f.my_piecewise3(t147, t87, t148 * t146)
  t199 = t198 * t91
  t202 = t5 * t199 * t193 / 0.8e1
  t204 = f.my_piecewise3(t144, 0, -0.3e1 / 0.8e1 * t5 * t154 * t193 - t202)
  t206 = t21 ** 2
  t207 = 0.1e1 / t206
  t208 = t26 ** 2
  t213 = t16 / t22 / t6
  t215 = -0.2e1 * t23 + 0.2e1 * t213
  t216 = f.my_piecewise5(t10, 0, t14, 0, t215)
  t220 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t207 * t208 + 0.4e1 / 0.3e1 * t21 * t216)
  t227 = t5 * t29 * t91 * t82
  t233 = 0.1e1 / t90 / t6
  t237 = t5 * t89 * t233 * t82 / 0.12e2
  t239 = t5 * t92 * t137
  t242 = 0.1e1 / t97 / t46
  t246 = 0.1e1 / t39 / t55 / t100
  t247 = t129 * t246
  t251 = 0.1e1 / t40 / t55
  t252 = t76 * t251
  t260 = 0.19e2 / 0.324e3 * t53 * t54 * t246
  t272 = t125 ** 2
  t280 = 0.1e1 / t67 / t38
  t301 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t220 * t30 * t82 - t227 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t31 * t137 + t237 - t239 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t96 * (-0.24326914935053938254669850463174651560568341546851e-3 * t242 * t50 * t247 + 0.32512921810699588477366255144032921810699588477366e-1 * t99 * t252 + (0.11e2 / 0.27e2 * t37 * s0 * t251 + t260) * t72 * t80 - 0.2e1 * t115 * t119 * t126 + 0.2e1 * t116 * t135 + 0.2e1 * t62 / t118 / t71 * t80 * t272 - 0.2e1 * t120 * t135 * t125 - t120 * t80 * (t260 + t66 * t280 / 0.32e2) + t73 * (0.60817287337634845636674626157936628901420853867128e-4 * t242 * t64 * t65 * t280 - 0.33251851851851851851851851851851851851851851851852e-2 * t128 * t247 - 0.11e2 / 0.27e2 * t75 * t252)))
  t302 = t148 ** 2
  t303 = 0.1e1 / t302
  t304 = t150 ** 2
  t308 = f.my_piecewise5(t14, 0, t10, 0, -t215)
  t312 = f.my_piecewise3(t147, 0, 0.4e1 / 0.9e1 * t303 * t304 + 0.4e1 / 0.3e1 * t148 * t308)
  t319 = t5 * t153 * t91 * t193
  t324 = t5 * t198 * t233 * t193 / 0.12e2
  t326 = f.my_piecewise3(t144, 0, -0.3e1 / 0.8e1 * t5 * t312 * t30 * t193 - t319 / 0.4e1 + t324)
  d11 = 0.2e1 * t142 + 0.2e1 * t204 + t6 * (t301 + t326)
  t329 = -t7 - t24
  t330 = f.my_piecewise5(t10, 0, t14, 0, t329)
  t333 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t330)
  t334 = t333 * t30
  t339 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t334 * t82 - t95)
  t341 = f.my_piecewise5(t14, 0, t10, 0, -t329)
  t344 = f.my_piecewise3(t147, 0, 0.4e1 / 0.3e1 * t148 * t341)
  t345 = t344 * t30
  t349 = t198 * t30
  t350 = t163 ** 2
  t351 = 0.1e1 / t350
  t352 = t351 * t32
  t353 = t155 * r1
  t355 = 0.1e1 / t157 / t353
  t356 = t187 * t355
  t364 = 0.1e1 / t156 / t168 / t155
  t367 = t53 * t167 * t364 / 0.108e3
  t368 = -t37 * s2 * t355 / 0.9e1 - t367
  t369 = t368 * t183
  t371 = t182 ** 2
  t372 = 0.1e1 / t371
  t373 = t175 * t372
  t378 = -t367 - t177 / t178 / r1 / 0.288e3
  t379 = t191 * t378
  t381 = t351 * t50
  t382 = t52 * t167
  t388 = 0.36946502057613168724279835390946502057613168724280e-3 * t381 * t382 * t364 + t186 * t356 / 0.9e1
  t390 = -0.88671604938271604938271604938271604938271604938272e-2 * t352 * t356 + t369 * t191 - t373 * t379 + t184 * t388
  t395 = f.my_piecewise3(t144, 0, -0.3e1 / 0.8e1 * t5 * t345 * t193 - t202 - 0.3e1 / 0.8e1 * t5 * t349 * t390)
  t399 = 0.2e1 * t213
  t400 = f.my_piecewise5(t10, 0, t14, 0, t399)
  t404 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t207 * t330 * t26 + 0.4e1 / 0.3e1 * t21 * t400)
  t411 = t5 * t333 * t91 * t82
  t419 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t404 * t30 * t82 - t411 / 0.8e1 - 0.3e1 / 0.8e1 * t5 * t334 * t137 - t227 / 0.8e1 + t237 - t239 / 0.8e1)
  t423 = f.my_piecewise5(t14, 0, t10, 0, -t399)
  t427 = f.my_piecewise3(t147, 0, 0.4e1 / 0.9e1 * t303 * t341 * t150 + 0.4e1 / 0.3e1 * t148 * t423)
  t434 = t5 * t344 * t91 * t193
  t441 = t5 * t199 * t390
  t444 = f.my_piecewise3(t144, 0, -0.3e1 / 0.8e1 * t5 * t427 * t30 * t193 - t434 / 0.8e1 - t319 / 0.8e1 + t324 - 0.3e1 / 0.8e1 * t5 * t154 * t390 - t441 / 0.8e1)
  d12 = t142 + t204 + t339 + t395 + t6 * (t419 + t444)
  t449 = t330 ** 2
  t453 = 0.2e1 * t23 + 0.2e1 * t213
  t454 = f.my_piecewise5(t10, 0, t14, 0, t453)
  t458 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t207 * t449 + 0.4e1 / 0.3e1 * t21 * t454)
  t465 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t458 * t30 * t82 - t411 / 0.4e1 + t237)
  t466 = t341 ** 2
  t470 = f.my_piecewise5(t14, 0, t10, 0, -t453)
  t474 = f.my_piecewise3(t147, 0, 0.4e1 / 0.9e1 * t303 * t466 + 0.4e1 / 0.3e1 * t148 * t470)
  t485 = 0.1e1 / t350 / t163
  t489 = 0.1e1 / t156 / t168 / t353
  t490 = t382 * t489
  t494 = 0.1e1 / t157 / t168
  t495 = t187 * t494
  t503 = 0.19e2 / 0.324e3 * t53 * t167 * t489
  t515 = t378 ** 2
  t523 = 0.1e1 / t178 / t155
  t544 = f.my_piecewise3(t144, 0, -0.3e1 / 0.8e1 * t5 * t474 * t30 * t193 - t434 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t345 * t390 + t324 - t441 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t349 * (-0.24326914935053938254669850463174651560568341546851e-3 * t485 * t50 * t490 + 0.32512921810699588477366255144032921810699588477366e-1 * t352 * t495 + (0.11e2 / 0.27e2 * t37 * s2 * t494 + t503) * t183 * t191 - 0.2e1 * t368 * t372 * t379 + 0.2e1 * t369 * t388 + 0.2e1 * t175 / t371 / t182 * t191 * t515 - 0.2e1 * t373 * t388 * t378 - t373 * t191 * (t503 + t177 * t523 / 0.32e2) + t184 * (0.60817287337634845636674626157936628901420853867128e-4 * t485 * t64 * t176 * t523 - 0.33251851851851851851851851851851851851851851851852e-2 * t381 * t490 - 0.11e2 / 0.27e2 * t186 * t495)))
  d22 = 0.2e1 * t339 + 0.2e1 * t395 + t6 * (t465 + t544)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = 6 ** (0.1e1 / 0.3e1)
  t45 = jnp.pi ** 2
  t46 = t45 ** (0.1e1 / 0.3e1)
  t47 = t46 ** 2
  t48 = 0.1e1 / t47
  t49 = t44 * t48
  t50 = r0 ** 2
  t51 = r0 ** (0.1e1 / 0.3e1)
  t52 = t51 ** 2
  t54 = 0.1e1 / t52 / t50
  t56 = t49 * s0 * t54
  t58 = 0.8040e0 + 0.5e1 / 0.972e3 * t56
  t60 = 0.64641600e0 / t58
  t62 = t44 ** 2
  t64 = 0.1e1 / t46 / t45
  t65 = t62 * t64
  t66 = s0 ** 2
  t67 = t50 ** 2
  t68 = t67 * r0
  t73 = t65 * t66 / t51 / t68 / 0.576e3
  t74 = t56 / 0.24e2 + t73
  t75 = t45 ** 2
  t76 = 0.1e1 / t75
  t77 = t66 * s0
  t78 = t76 * t77
  t79 = t67 ** 2
  t83 = 0.1e1 + t73 + t78 / t79 / 0.2304e4
  t84 = 0.1e1 / t83
  t85 = t74 * t84
  t87 = (0.18040e1 - t60) * t44
  t88 = t48 * s0
  t92 = -t87 * t88 * t54 / 0.24e2 + 0.6525e-1
  t94 = 0.18040e1 - t60 + t85 * t92
  t100 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t101 = t42 ** 2
  t102 = 0.1e1 / t101
  t103 = t100 * t102
  t107 = t100 * t42
  t108 = t58 ** 2
  t109 = 0.1e1 / t108
  t110 = t109 * t44
  t111 = t50 * r0
  t113 = 0.1e1 / t52 / t111
  t114 = t88 * t113
  t122 = 0.1e1 / t51 / t67 / t50
  t125 = t65 * t66 * t122 / 0.108e3
  t126 = -t49 * s0 * t113 / 0.9e1 - t125
  t127 = t126 * t84
  t129 = t83 ** 2
  t130 = 0.1e1 / t129
  t131 = t74 * t130
  t136 = -t125 - t78 / t79 / r0 / 0.288e3
  t137 = t92 * t136
  t139 = t109 * t62
  t140 = t64 * t66
  t146 = 0.36946502057613168724279835390946502057613168724280e-3 * t139 * t140 * t122 + t87 * t114 / 0.9e1
  t148 = -0.88671604938271604938271604938271604938271604938272e-2 * t110 * t114 + t127 * t92 - t131 * t137 + t85 * t146
  t152 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t153 = t152 * f.p.zeta_threshold
  t155 = f.my_piecewise3(t20, t153, t21 * t19)
  t157 = 0.1e1 / t101 / t6
  t158 = t155 * t157
  t162 = t155 * t102
  t166 = t155 * t42
  t168 = 0.1e1 / t108 / t58
  t169 = t168 * t62
  t172 = 0.1e1 / t51 / t67 / t111
  t173 = t140 * t172
  t177 = 0.1e1 / t52 / t67
  t178 = t88 * t177
  t186 = 0.19e2 / 0.324e3 * t65 * t66 * t172
  t187 = 0.11e2 / 0.27e2 * t49 * s0 * t177 + t186
  t188 = t187 * t84
  t190 = t126 * t130
  t196 = 0.1e1 / t129 / t83
  t197 = t74 * t196
  t198 = t136 ** 2
  t199 = t92 * t198
  t202 = t146 * t136
  t206 = 0.1e1 / t79 / t50
  t209 = t186 + t78 * t206 / 0.32e2
  t210 = t92 * t209
  t212 = t168 * t76
  t220 = 0.60817287337634845636674626157936628901420853867128e-4 * t212 * t77 * t206 - 0.33251851851851851851851851851851851851851851851852e-2 * t139 * t173 - 0.11e2 / 0.27e2 * t87 * t178
  t222 = -0.24326914935053938254669850463174651560568341546851e-3 * t169 * t173 + 0.32512921810699588477366255144032921810699588477366e-1 * t110 * t178 + t188 * t92 - 0.2e1 * t190 * t137 + 0.2e1 * t127 * t146 + 0.2e1 * t197 * t199 - 0.2e1 * t131 * t202 - t131 * t210 + t85 * t220
  t227 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t43 * t94 - t5 * t103 * t94 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t107 * t148 + t5 * t158 * t94 / 0.12e2 - t5 * t162 * t148 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t166 * t222)
  t229 = r1 <= f.p.dens_threshold
  t230 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t231 = 0.1e1 + t230
  t232 = t231 <= f.p.zeta_threshold
  t233 = t231 ** (0.1e1 / 0.3e1)
  t234 = t233 ** 2
  t235 = 0.1e1 / t234
  t237 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t238 = t237 ** 2
  t242 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t246 = f.my_piecewise3(t232, 0, 0.4e1 / 0.9e1 * t235 * t238 + 0.4e1 / 0.3e1 * t233 * t242)
  t248 = r1 ** 2
  t249 = r1 ** (0.1e1 / 0.3e1)
  t250 = t249 ** 2
  t252 = 0.1e1 / t250 / t248
  t254 = t49 * s2 * t252
  t258 = 0.64641600e0 / (0.8040e0 + 0.5e1 / 0.972e3 * t254)
  t260 = s2 ** 2
  t261 = t248 ** 2
  t267 = t65 * t260 / t249 / t261 / r1 / 0.576e3
  t271 = t261 ** 2
  t286 = 0.18040e1 - t258 + (t254 / 0.24e2 + t267) / (0.1e1 + t267 + t76 * t260 * s2 / t271 / 0.2304e4) * (-(0.18040e1 - t258) * t44 * t48 * s2 * t252 / 0.24e2 + 0.6525e-1)
  t292 = f.my_piecewise3(t232, 0, 0.4e1 / 0.3e1 * t233 * t237)
  t298 = f.my_piecewise3(t232, t153, t233 * t231)
  t304 = f.my_piecewise3(t229, 0, -0.3e1 / 0.8e1 * t5 * t246 * t42 * t286 - t5 * t292 * t102 * t286 / 0.4e1 + t5 * t298 * t157 * t286 / 0.12e2)
  t314 = t24 ** 2
  t318 = 0.6e1 * t33 - 0.6e1 * t16 / t314
  t319 = f.my_piecewise5(t10, 0, t14, 0, t318)
  t323 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t319)
  t346 = 0.1e1 / t101 / t24
  t359 = t108 ** 2
  t361 = 0.1e1 / t359 * t76
  t362 = t66 ** 2
  t372 = 0.1e1 / t79 / t111
  t373 = t77 * t372
  t377 = 0.1e1 / t51 / t79
  t378 = t140 * t377
  t382 = 0.1e1 / t52 / t68
  t383 = t88 * t382
  t396 = 0.209e3 / 0.486e3 * t65 * t66 * t377
  t425 = t129 ** 2
  t439 = 0.3e1 * t127 * t220 + t85 * (0.25027690262401171043899023110261987202230804060546e-5 * t361 * t362 / t52 / t79 / t68 * t44 * t48 - 0.11555284594150620670968178970007959491269962234754e-2 * t212 * t373 + 0.27997238225880201188843164151806127114769090077732e-1 * t139 * t378 + 0.154e3 / 0.81e2 * t87 * t383) - 0.3e1 * t131 * t220 * t136 - 0.3e1 * t131 * t146 * t209 - t131 * t92 * (-t396 - 0.5e1 / 0.16e2 * t78 * t372) - 0.60066456629762810505357655464628769285353929745311e-4 * t361 * t373 - 0.3e1 * t187 * t130 * t137 - 0.6e1 * t190 * t202 - 0.3e1 * t190 * t210 + 0.6e1 * t197 * t146 * t198 + (-0.154e3 / 0.81e2 * t49 * s0 * t382 - t396) * t84 * t92 + 0.3e1 * t188 * t146 + 0.6e1 * t126 * t196 * t199 - 0.6e1 * t74 / t425 * t92 * t198 * t136 + 0.6e1 * t197 * t137 * t209 + 0.26759606428559332080136835509492116716625175701536e-2 * t169 * t378 - 0.15172696844993141289437585733882030178326474622771e0 * t110 * t383
  t444 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t323 * t42 * t94 - 0.3e1 / 0.8e1 * t5 * t41 * t102 * t94 - 0.9e1 / 0.8e1 * t5 * t43 * t148 + t5 * t100 * t157 * t94 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t103 * t148 - 0.9e1 / 0.8e1 * t5 * t107 * t222 - 0.5e1 / 0.36e2 * t5 * t155 * t346 * t94 + t5 * t158 * t148 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t162 * t222 - 0.3e1 / 0.8e1 * t5 * t166 * t439)
  t454 = f.my_piecewise5(t14, 0, t10, 0, -t318)
  t458 = f.my_piecewise3(t232, 0, -0.8e1 / 0.27e2 / t234 / t231 * t238 * t237 + 0.4e1 / 0.3e1 * t235 * t237 * t242 + 0.4e1 / 0.3e1 * t233 * t454)
  t476 = f.my_piecewise3(t229, 0, -0.3e1 / 0.8e1 * t5 * t458 * t42 * t286 - 0.3e1 / 0.8e1 * t5 * t246 * t102 * t286 + t5 * t292 * t157 * t286 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t298 * t346 * t286)
  d111 = 0.3e1 * t227 + 0.3e1 * t304 + t6 * (t444 + t476)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 0.1e1 / t22 / t19
  t25 = t6 ** 2
  t26 = 0.1e1 / t25
  t28 = -t16 * t26 + t7
  t29 = f.my_piecewise5(t10, 0, t14, 0, t28)
  t30 = t29 ** 2
  t34 = 0.1e1 / t22
  t35 = t34 * t29
  t36 = t25 * t6
  t37 = 0.1e1 / t36
  t40 = 0.2e1 * t16 * t37 - 0.2e1 * t26
  t41 = f.my_piecewise5(t10, 0, t14, 0, t40)
  t44 = t25 ** 2
  t45 = 0.1e1 / t44
  t48 = -0.6e1 * t16 * t45 + 0.6e1 * t37
  t49 = f.my_piecewise5(t10, 0, t14, 0, t48)
  t53 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 * t24 * t30 * t29 + 0.4e1 / 0.3e1 * t35 * t41 + 0.4e1 / 0.3e1 * t21 * t49)
  t54 = t6 ** (0.1e1 / 0.3e1)
  t55 = t53 * t54
  t56 = 6 ** (0.1e1 / 0.3e1)
  t57 = jnp.pi ** 2
  t58 = t57 ** (0.1e1 / 0.3e1)
  t59 = t58 ** 2
  t60 = 0.1e1 / t59
  t61 = t56 * t60
  t62 = r0 ** 2
  t63 = r0 ** (0.1e1 / 0.3e1)
  t64 = t63 ** 2
  t66 = 0.1e1 / t64 / t62
  t68 = t61 * s0 * t66
  t70 = 0.8040e0 + 0.5e1 / 0.972e3 * t68
  t72 = 0.64641600e0 / t70
  t74 = t56 ** 2
  t76 = 0.1e1 / t58 / t57
  t77 = t74 * t76
  t78 = s0 ** 2
  t79 = t62 ** 2
  t80 = t79 * r0
  t85 = t77 * t78 / t63 / t80 / 0.576e3
  t86 = t68 / 0.24e2 + t85
  t87 = t57 ** 2
  t88 = 0.1e1 / t87
  t89 = t78 * s0
  t90 = t88 * t89
  t91 = t79 ** 2
  t95 = 0.1e1 + t85 + t90 / t91 / 0.2304e4
  t96 = 0.1e1 / t95
  t97 = t86 * t96
  t99 = (0.18040e1 - t72) * t56
  t100 = t60 * s0
  t104 = -t99 * t100 * t66 / 0.24e2 + 0.6525e-1
  t106 = 0.18040e1 - t72 + t97 * t104
  t115 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t34 * t30 + 0.4e1 / 0.3e1 * t21 * t41)
  t116 = t54 ** 2
  t117 = 0.1e1 / t116
  t118 = t115 * t117
  t122 = t115 * t54
  t123 = t70 ** 2
  t124 = 0.1e1 / t123
  t125 = t124 * t56
  t126 = t62 * r0
  t128 = 0.1e1 / t64 / t126
  t129 = t100 * t128
  t135 = t79 * t62
  t137 = 0.1e1 / t63 / t135
  t140 = t77 * t78 * t137 / 0.108e3
  t141 = -t61 * s0 * t128 / 0.9e1 - t140
  t142 = t141 * t96
  t144 = t95 ** 2
  t145 = 0.1e1 / t144
  t146 = t86 * t145
  t147 = t91 * r0
  t151 = -t140 - t90 / t147 / 0.288e3
  t152 = t104 * t151
  t154 = t124 * t74
  t155 = t76 * t78
  t161 = 0.36946502057613168724279835390946502057613168724280e-3 * t154 * t155 * t137 + t99 * t129 / 0.9e1
  t163 = -0.88671604938271604938271604938271604938271604938272e-2 * t125 * t129 + t142 * t104 - t146 * t152 + t97 * t161
  t169 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t29)
  t171 = 0.1e1 / t116 / t6
  t172 = t169 * t171
  t176 = t169 * t117
  t180 = t169 * t54
  t182 = 0.1e1 / t123 / t70
  t183 = t182 * t74
  t186 = 0.1e1 / t63 / t79 / t126
  t187 = t155 * t186
  t191 = 0.1e1 / t64 / t79
  t192 = t100 * t191
  t200 = 0.19e2 / 0.324e3 * t77 * t78 * t186
  t201 = 0.11e2 / 0.27e2 * t61 * s0 * t191 + t200
  t202 = t201 * t96
  t204 = t141 * t145
  t210 = 0.1e1 / t144 / t95
  t211 = t86 * t210
  t212 = t151 ** 2
  t213 = t104 * t212
  t216 = t161 * t151
  t220 = 0.1e1 / t91 / t62
  t223 = t200 + t90 * t220 / 0.32e2
  t224 = t104 * t223
  t226 = t182 * t88
  t234 = 0.60817287337634845636674626157936628901420853867128e-4 * t226 * t89 * t220 - 0.33251851851851851851851851851851851851851851851852e-2 * t154 * t187 - 0.11e2 / 0.27e2 * t99 * t192
  t236 = -0.24326914935053938254669850463174651560568341546851e-3 * t183 * t187 + 0.32512921810699588477366255144032921810699588477366e-1 * t125 * t192 + t202 * t104 - 0.2e1 * t204 * t152 + 0.2e1 * t142 * t161 + 0.2e1 * t211 * t213 - 0.2e1 * t146 * t216 - t146 * t224 + t97 * t234
  t240 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t241 = t240 * f.p.zeta_threshold
  t243 = f.my_piecewise3(t20, t241, t21 * t19)
  t245 = 0.1e1 / t116 / t25
  t246 = t243 * t245
  t250 = t243 * t171
  t254 = t243 * t117
  t258 = t243 * t54
  t261 = t123 ** 2
  t263 = 0.1e1 / t261 * t88
  t264 = t78 ** 2
  t265 = t263 * t264
  t274 = 0.1e1 / t91 / t126
  t275 = t89 * t274
  t279 = 0.1e1 / t63 / t91
  t280 = t155 * t279
  t284 = 0.1e1 / t64 / t80
  t285 = t100 * t284
  t288 = 0.25027690262401171043899023110261987202230804060546e-5 * t265 / t64 / t91 / t80 * t56 * t60 - 0.11555284594150620670968178970007959491269962234754e-2 * t226 * t275 + 0.27997238225880201188843164151806127114769090077732e-1 * t154 * t280 + 0.154e3 / 0.81e2 * t99 * t285
  t290 = t234 * t151
  t293 = t161 * t223
  t298 = 0.209e3 / 0.486e3 * t77 * t78 * t279
  t301 = -t298 - 0.5e1 / 0.16e2 * t90 * t274
  t302 = t104 * t301
  t306 = t201 * t145
  t313 = t161 * t212
  t319 = -0.154e3 / 0.81e2 * t61 * s0 * t284 - t298
  t320 = t319 * t96
  t324 = t141 * t210
  t327 = t144 ** 2
  t328 = 0.1e1 / t327
  t329 = t86 * t328
  t330 = t212 * t151
  t331 = t104 * t330
  t334 = t152 * t223
  t341 = 0.3e1 * t142 * t234 + t97 * t288 - 0.3e1 * t146 * t290 - 0.3e1 * t146 * t293 - t146 * t302 - 0.60066456629762810505357655464628769285353929745311e-4 * t263 * t275 - 0.3e1 * t306 * t152 - 0.6e1 * t204 * t216 - 0.3e1 * t204 * t224 + 0.6e1 * t211 * t313 + t320 * t104 + 0.3e1 * t202 * t161 + 0.6e1 * t324 * t213 - 0.6e1 * t329 * t331 + 0.6e1 * t211 * t334 + 0.26759606428559332080136835509492116716625175701536e-2 * t183 * t280 - 0.15172696844993141289437585733882030178326474622771e0 * t125 * t285
  t346 = f.my_piecewise3(t1, 0, -0.3e1 / 0.8e1 * t5 * t55 * t106 - 0.3e1 / 0.8e1 * t5 * t118 * t106 - 0.9e1 / 0.8e1 * t5 * t122 * t163 + t5 * t172 * t106 / 0.4e1 - 0.3e1 / 0.4e1 * t5 * t176 * t163 - 0.9e1 / 0.8e1 * t5 * t180 * t236 - 0.5e1 / 0.36e2 * t5 * t246 * t106 + t5 * t250 * t163 / 0.4e1 - 0.3e1 / 0.8e1 * t5 * t254 * t236 - 0.3e1 / 0.8e1 * t5 * t258 * t341)
  t348 = r1 <= f.p.dens_threshold
  t349 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t350 = 0.1e1 + t349
  t351 = t350 <= f.p.zeta_threshold
  t352 = t350 ** (0.1e1 / 0.3e1)
  t353 = t352 ** 2
  t355 = 0.1e1 / t353 / t350
  t357 = f.my_piecewise5(t14, 0, t10, 0, -t28)
  t358 = t357 ** 2
  t362 = 0.1e1 / t353
  t363 = t362 * t357
  t365 = f.my_piecewise5(t14, 0, t10, 0, -t40)
  t369 = f.my_piecewise5(t14, 0, t10, 0, -t48)
  t373 = f.my_piecewise3(t351, 0, -0.8e1 / 0.27e2 * t355 * t358 * t357 + 0.4e1 / 0.3e1 * t363 * t365 + 0.4e1 / 0.3e1 * t352 * t369)
  t375 = r1 ** 2
  t376 = r1 ** (0.1e1 / 0.3e1)
  t377 = t376 ** 2
  t379 = 0.1e1 / t377 / t375
  t381 = t61 * s2 * t379
  t385 = 0.64641600e0 / (0.8040e0 + 0.5e1 / 0.972e3 * t381)
  t387 = s2 ** 2
  t388 = t375 ** 2
  t394 = t77 * t387 / t376 / t388 / r1 / 0.576e3
  t398 = t388 ** 2
  t413 = 0.18040e1 - t385 + (t381 / 0.24e2 + t394) / (0.1e1 + t394 + t88 * t387 * s2 / t398 / 0.2304e4) * (-(0.18040e1 - t385) * t56 * t60 * s2 * t379 / 0.24e2 + 0.6525e-1)
  t422 = f.my_piecewise3(t351, 0, 0.4e1 / 0.9e1 * t362 * t358 + 0.4e1 / 0.3e1 * t352 * t365)
  t429 = f.my_piecewise3(t351, 0, 0.4e1 / 0.3e1 * t352 * t357)
  t435 = f.my_piecewise3(t351, t241, t352 * t350)
  t441 = f.my_piecewise3(t348, 0, -0.3e1 / 0.8e1 * t5 * t373 * t54 * t413 - 0.3e1 / 0.8e1 * t5 * t422 * t117 * t413 + t5 * t429 * t171 * t413 / 0.4e1 - 0.5e1 / 0.36e2 * t5 * t435 * t245 * t413)
  t445 = 0.1e1 / t261 / t70 * t88
  t451 = 0.1e1 / t64 / t91 / t135 * t56 * t60
  t460 = 0.1e1 / t63 / t147
  t461 = t155 * t460
  t465 = 0.1e1 / t64 / t135
  t466 = t100 * t465
  t479 = t91 ** 2
  t490 = 0.1e1 / t91 / t79
  t491 = t89 * t490
  t505 = 0.5225e4 / 0.1458e4 * t77 * t78 * t460
  t520 = -0.32958275242668208782089248540262699196353322219649e-5 * t445 * t264 * t451 + 0.8e1 * t211 * t302 * t151 + 0.24e2 * t324 * t334 - 0.26462277468242006168135315114942204308662673749297e-1 * t183 * t461 + 0.85978615454961133973479652491998171010516689529036e0 * t125 * t466 - 0.36e2 * t329 * t213 * t223 + 0.24e2 * t211 * t293 * t151 + 0.4e1 * t142 * t288 + t97 * (0.13732614684445086992537186891776124665147217591520e-6 * t445 * t264 * s0 / t63 / t479 / r0 * t74 * t76 - 0.81757121523843825410070142160189158193953959931117e-4 * t265 * t451 + 0.17319411938484234374088562982532397763815738717938e-1 * t226 * t491 - 0.25016887059899405578417924096936442615454961133974e0 * t154 * t461 - 0.2618e4 / 0.243e3 * t99 * t466) + (0.2618e4 / 0.243e3 * t61 * s0 * t465 + t505) * t96 * t104 + 0.4e1 * t320 * t161 + 0.6e1 * t202 * t234 - 0.4e1 * t319 * t145 * t152 - 0.12e2 * t306 * t216 - 0.6e1 * t306 * t224
  t538 = t223 ** 2
  t556 = t212 ** 2
  t568 = -0.12e2 * t204 * t290 - 0.6e1 * t146 * t234 * t223 - 0.12e2 * t204 * t293 - 0.4e1 * t146 * t161 * t301 - 0.4e1 * t204 * t302 - t146 * t104 * (t505 + 0.55e2 / 0.16e2 * t90 * t490) + 0.6e1 * t211 * t104 * t538 + 0.24e2 * t324 * t313 + 0.12e2 * t211 * t234 * t212 - 0.24e2 * t329 * t161 * t330 - 0.24e2 * t141 * t328 * t331 + 0.24e2 * t86 / t327 / t95 * t104 * t556 - 0.4e1 * t146 * t288 * t151 + 0.13214620458547818311178684202218329242777864543968e-2 * t263 * t491 + 0.12e2 * t201 * t210 * t213
  t596 = t19 ** 2
  t599 = t30 ** 2
  t605 = t41 ** 2
  t614 = -0.24e2 * t45 + 0.24e2 * t16 / t44 / t6
  t615 = f.my_piecewise5(t10, 0, t14, 0, t614)
  t619 = f.my_piecewise3(t20, 0, 0.40e2 / 0.81e2 / t22 / t596 * t599 - 0.16e2 / 0.9e1 * t24 * t30 * t41 + 0.4e1 / 0.3e1 * t34 * t605 + 0.16e2 / 0.9e1 * t35 * t49 + 0.4e1 / 0.3e1 * t21 * t615)
  t628 = 0.1e1 / t116 / t36
  t645 = -0.3e1 / 0.8e1 * t5 * t258 * (t520 + t568) - t5 * t254 * t341 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t246 * t163 + t5 * t250 * t236 / 0.2e1 - 0.3e1 / 0.2e1 * t5 * t180 * t341 - 0.3e1 / 0.2e1 * t5 * t118 * t163 - 0.9e1 / 0.4e1 * t5 * t122 * t236 + t5 * t172 * t163 - 0.3e1 / 0.2e1 * t5 * t176 * t236 - 0.3e1 / 0.8e1 * t5 * t619 * t54 * t106 - 0.3e1 / 0.2e1 * t5 * t55 * t163 + 0.10e2 / 0.27e2 * t5 * t243 * t628 * t106 - 0.5e1 / 0.9e1 * t5 * t169 * t245 * t106 - t5 * t53 * t117 * t106 / 0.2e1 + t5 * t115 * t171 * t106 / 0.2e1
  t646 = f.my_piecewise3(t1, 0, t645)
  t647 = t350 ** 2
  t650 = t358 ** 2
  t656 = t365 ** 2
  t662 = f.my_piecewise5(t14, 0, t10, 0, -t614)
  t666 = f.my_piecewise3(t351, 0, 0.40e2 / 0.81e2 / t353 / t647 * t650 - 0.16e2 / 0.9e1 * t355 * t358 * t365 + 0.4e1 / 0.3e1 * t362 * t656 + 0.16e2 / 0.9e1 * t363 * t369 + 0.4e1 / 0.3e1 * t352 * t662)
  t688 = f.my_piecewise3(t348, 0, -0.3e1 / 0.8e1 * t5 * t666 * t54 * t413 - t5 * t373 * t117 * t413 / 0.2e1 + t5 * t422 * t171 * t413 / 0.2e1 - 0.5e1 / 0.9e1 * t5 * t429 * t245 * t413 + 0.10e2 / 0.27e2 * t5 * t435 * t628 * t413)
  d1111 = 0.4e1 * t346 + 0.4e1 * t441 + t6 * (t646 + t688)

  res = {'v4rho4': d1111}
  return res
