"""Generated from lda_c_1d_loos.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import jax.scipy.special as jsp_special
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *


def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  eta0 = -jnp.log(jnp.sqrt(2 * jnp.pi)) - 3 / 4

  eta1 = 0.359933

  eps0 = -jnp.pi ** 2 / 360

  eps1 = 0.00714

  kappa = 0.3083

  c3 = eps1

  c0 = kappa * eta0

  c1 = 4 * kappa * eta0 + kappa * jnp.sqrt(kappa) * eta1

  c2 = 5 * eps0 + eps1 / kappa

  t = lambda rs: (jnp.sqrt(1 + 4 * kappa * rs) - 1) / (2 * kappa * rs)

  functional_body = lambda rs, z=None: t(rs) ** 2 * (c0 * (1 - t(rs)) ** 3 + c1 * t(rs) * (1 - t(rs)) ** 2 + c2 * t(rs) ** 2 * (1 - t(rs)) + c3 * t(rs) ** 3)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
  )
  return res


def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  eta0 = -jnp.log(jnp.sqrt(2 * jnp.pi)) - 3 / 4

  eta1 = 0.359933

  eps0 = -jnp.pi ** 2 / 360

  eps1 = 0.00714

  kappa = 0.3083

  c3 = eps1

  c0 = kappa * eta0

  c1 = 4 * kappa * eta0 + kappa * jnp.sqrt(kappa) * eta1

  c2 = 5 * eps0 + eps1 / kappa

  t = lambda rs: (jnp.sqrt(1 + 4 * kappa * rs) - 1) / (2 * kappa * rs)

  functional_body = lambda rs, z=None: t(rs) ** 2 * (c0 * (1 - t(rs)) ** 3 + c1 * t(rs) * (1 - t(rs)) ** 2 + c2 * t(rs) ** 2 * (1 - t(rs)) + c3 * t(rs) ** 3)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t8
  t14 = jnp.sqrt(0.1e1 + 0.30830000000000000000000000000000000000000000000000e0 * t1 * t3 * t6 * t9)
  t15 = t14 - 0.1e1
  t16 = t15 ** 2
  t18 = t3 ** 2
  t19 = 0.1e1 / t18
  t21 = t8 ** 2
  t23 = jnp.sqrt(0.2e1)
  t24 = jnp.sqrt(jnp.pi)
  t26 = jnp.log(t23 * t24)
  t28 = -0.3083e0 * t26 - 0.23122500000000000000000000000000000000000000000000e0
  t29 = t1 ** 2
  t30 = t15 * t29
  t31 = 0.1e1 / t3
  t32 = t31 * t5
  t36 = 0.1e1 - 0.54059898367391069304789706995350848740404368039790e0 * t30 * t32 * t8
  t37 = t36 ** 2
  t41 = -0.12332e1 * t26 - 0.86328563835932653792854789975522405293701503670331e0
  t42 = t41 * t15
  t43 = t42 * t29
  t48 = jnp.pi ** 2
  t50 = -t48 / 0.72e2 + 0.23159260460590334090171910476808303600389231268245e-1
  t52 = t50 * t16 * t1
  t53 = t19 * t6
  t59 = t16 * t15 * jnp.pi
  t62 = t28 * t37 * t36 + 0.54059898367391069304789706995350848740404368039790e0 * t43 * t32 * t8 * t37 + 0.87674178344779548012957682444617010607207862536154e0 * t52 * t53 * t21 * t36 + 0.40609382639099965800357953464454457070091737820836e-1 * t59 * t7
  t68 = 0.1e1 / t14
  t77 = 0.1e1 / t7
  t80 = 0.1e1 / t21
  t84 = 0.33333333333333333333333333333333333333333333333335e0 * t68 * t77 - 0.18019966122463689768263235665116949580134789346597e0 * t30 * t32 * t80
  t95 = t29 * t31
  vrho_0_ = 0.14612363057463258002159613740769501767867977089359e1 * t16 * t1 * t19 * t6 * t21 * t62 - 0.36039932244927379536526471330233899160269578693196e0 * t8 * t15 * t29 * t32 * t62 * t68 + 0.87674178344779548012957682444617010607207862536154e0 * t21 * t7 * t16 * t1 * t53 * (0.3e1 * t28 * t37 * t84 - 0.33333333333333333333333333333333333333333333333335e0 * t41 * t68 * t77 * t37 + 0.18019966122463689768263235665116949580134789346597e0 * t43 * t32 * t80 * t37 + 0.10811979673478213860957941399070169748080873607958e1 * t42 * t95 * t5 * t8 * t36 * t84 - 0.36039932244927379536526471330233899160269578693196e0 * t50 * t15 * t95 * t5 * t80 * t36 * t68 + 0.58449452229853032008638454963078007071471908357436e0 * t52 * t53 * t9 * t36 + 0.87674178344779548012957682444617010607207862536154e0 * t52 * t53 * t21 * t84 - 0.62599363338172597281251785265456545573546413850819e-2 * t16 * jnp.pi * t9 * t68 * t1 * t3 * t6 + 0.40609382639099965800357953464454457070091737820836e-1 * t59)
  vrho_1_ = vrho_0_

  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1)}
  return res


def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t7
  t13 = jnp.sqrt(0.1e1 + 0.30830000000000000000000000000000000000000000000000e0 * t1 * t3 * t6 * t8)
  t14 = t13 - 0.1e1
  t15 = t14 ** 2
  t17 = t3 ** 2
  t18 = 0.1e1 / t17
  t20 = t7 ** 2
  t22 = jnp.sqrt(0.2e1)
  t23 = jnp.sqrt(jnp.pi)
  t25 = jnp.log(t22 * t23)
  t27 = -0.3083e0 * t25 - 0.23122500000000000000000000000000000000000000000000e0
  t28 = t1 ** 2
  t29 = t14 * t28
  t30 = 0.1e1 / t3
  t31 = t30 * t5
  t35 = 0.1e1 - 0.54059898367391069304789706995350848740404368039790e0 * t29 * t31 * t7
  t36 = t35 ** 2
  t40 = -0.12332e1 * t25 - 0.86328563835932653792854789975522405293701503670331e0
  t41 = t40 * t14
  t42 = t41 * t28
  t47 = jnp.pi ** 2
  t49 = -t47 / 0.72e2 + 0.23159260460590334090171910476808303600389231268245e-1
  t51 = t49 * t15 * t1
  t52 = t18 * t6
  t58 = t15 * t14 * jnp.pi
  t61 = t27 * t36 * t35 + 0.54059898367391069304789706995350848740404368039790e0 * t42 * t31 * t7 * t36 + 0.87674178344779548012957682444617010607207862536154e0 * t51 * t52 * t20 * t35 + 0.40609382639099965800357953464454457070091737820836e-1 * t58 * r0
  t67 = 0.1e1 / t13
  t76 = 0.1e1 / r0
  t79 = 0.1e1 / t20
  t83 = 0.33333333333333333333333333333333333333333333333335e0 * t67 * t76 - 0.18019966122463689768263235665116949580134789346597e0 * t29 * t31 * t79
  t94 = t28 * t30
  vrho_0_ = 0.14612363057463258002159613740769501767867977089359e1 * t15 * t1 * t18 * t6 * t20 * t61 - 0.36039932244927379536526471330233899160269578693196e0 * t7 * t14 * t28 * t31 * t61 * t67 + 0.87674178344779548012957682444617010607207862536154e0 * t20 * r0 * t15 * t1 * t52 * (0.3e1 * t27 * t36 * t83 - 0.33333333333333333333333333333333333333333333333335e0 * t40 * t67 * t76 * t36 + 0.18019966122463689768263235665116949580134789346597e0 * t42 * t31 * t79 * t36 + 0.10811979673478213860957941399070169748080873607958e1 * t41 * t94 * t5 * t7 * t35 * t83 - 0.36039932244927379536526471330233899160269578693196e0 * t49 * t14 * t94 * t5 * t79 * t35 * t67 + 0.58449452229853032008638454963078007071471908357436e0 * t51 * t52 * t8 * t35 + 0.87674178344779548012957682444617010607207862536154e0 * t51 * t52 * t20 * t83 - 0.62599363338172597281251785265456545573546413850819e-2 * t15 * jnp.pi * t8 * t67 * t1 * t3 * t6 + 0.40609382639099965800357953464454457070091737820836e-1 * t58)

  res = {'vrho': vrho_0_}
  return res
