"""Generated from lda_c_vwn_1.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) * (1 - f.f_zeta(z)) + f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) * f.f_zeta(z)

  functional_body = lambda rs, z: f_vwn(rs, z)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) * (1 - f.f_zeta(z)) + f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) * f.f_zeta(z)

  functional_body = lambda rs, z: f_vwn(rs, z)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) * (1 - f.f_zeta(z)) + f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) * f.f_zeta(z)

  functional_body = lambda rs, z: f_vwn(rs, z)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t8
  t10 = t6 * t9
  t11 = t4 * t10
  t12 = t11 / 0.4e1
  t13 = jnp.sqrt(t11)
  t15 = t12 + 0.18637200000000000000000000000000000000000000000000e1 * t13 + 0.129352e2
  t16 = 0.1e1 / t15
  t20 = jnp.log(t4 * t10 * t16 / 0.4e1)
  t22 = t13 + 0.372744e1
  t25 = jnp.arctan(0.61519908197590802321728722658814145360143502774884e1 / t22)
  t27 = t13 / 0.2e1
  t28 = t27 + 0.10498e0
  t29 = t28 ** 2
  t31 = jnp.log(t29 * t16)
  t33 = 0.310907e-1 * t20 + 0.38783294878113014394824731224995739188004877421366e-1 * t25 + 0.96902277115443742137603943210562149050493484994510e-3 * t31
  t34 = r0 - r1
  t35 = 0.1e1 / t7
  t36 = t34 * t35
  t37 = 0.1e1 + t36
  t38 = t37 <= f.p.zeta_threshold
  t39 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t40 = t39 * f.p.zeta_threshold
  t41 = t37 ** (0.1e1 / 0.3e1)
  t43 = f.my_piecewise3(t38, t40, t41 * t37)
  t44 = 0.1e1 - t36
  t45 = t44 <= f.p.zeta_threshold
  t46 = t44 ** (0.1e1 / 0.3e1)
  t48 = f.my_piecewise3(t45, t40, t46 * t44)
  t49 = t43 + t48 - 0.2e1
  t50 = 2 ** (0.1e1 / 0.3e1)
  t53 = 0.1e1 / (0.2e1 * t50 - 0.2e1)
  t55 = -t49 * t53 + 0.1e1
  t56 = t33 * t55
  t58 = t12 + 0.35302100000000000000000000000000000000000000000000e1 * t13 + 0.180578e2
  t59 = 0.1e1 / t58
  t63 = jnp.log(t4 * t10 * t59 / 0.4e1)
  t65 = t13 + 0.706042e1
  t68 = jnp.arctan(0.47309269095601128299619512910246923284397083311420e1 / t65)
  t70 = t27 + 0.32500e0
  t71 = t70 ** 2
  t73 = jnp.log(t71 * t59)
  t75 = 0.1554535e-1 * t63 + 0.52491393169780936217021346072241076933841385384498e-1 * t68 + 0.22478670955426118383265363956423012380560746650571e-2 * t73
  t77 = t75 * t49 * t53
  t79 = 0.1e1 / t8 / t7
  t80 = t6 * t79
  t84 = t4 * t6
  t85 = t15 ** 2
  t86 = 0.1e1 / t85
  t88 = t4 * t80
  t89 = t88 / 0.12e2
  t90 = 0.1e1 / t13
  t92 = t3 * t6
  t94 = t90 * t1 * t92 * t79
  t96 = -t89 - 0.31062000000000000000000000000000000000000000000000e0 * t94
  t101 = t1 ** 2
  t103 = 0.1e1 / t3
  t105 = t5 * t8
  t109 = t22 ** 2
  t110 = 0.1e1 / t109
  t132 = (0.10363566666666666666666666666666666666666666666667e-1 * (-t4 * t80 * t16 / 0.12e2 - t84 * t9 * t86 * t96 / 0.4e1) * t101 * t103 * t105 * t15 + 0.39765745675026770180313930393880960493473766078662e-1 * t110 * t90 * t1 * t92 * t79 / (0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t110) + 0.96902277115443742137603943210562149050493484994510e-3 * (-t28 * t16 * t90 * t88 / 0.6e1 - t29 * t86 * t96) / t29 * t15) * t55
  t133 = t7 ** 2
  t135 = t34 / t133
  t136 = t35 - t135
  t139 = f.my_piecewise3(t38, 0, 0.4e1 / 0.3e1 * t41 * t136)
  t143 = f.my_piecewise3(t45, 0, -0.4e1 / 0.3e1 * t46 * t136)
  t144 = t139 + t143
  t150 = t58 ** 2
  t151 = 0.1e1 / t150
  t154 = -t89 - 0.58836833333333333333333333333333333333333333333333e0 * t94
  t164 = t65 ** 2
  t165 = 0.1e1 / t164
  t188 = (0.51817833333333333333333333333333333333333333333333e-2 * (-t4 * t80 * t59 / 0.12e2 - t84 * t9 * t151 * t154 / 0.4e1) * t101 * t103 * t105 * t58 + 0.41388824077869423260215065147117773567486474051459e-1 * t165 * t90 * t1 * t92 * t79 / (0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t165) + 0.22478670955426118383265363956423012380560746650571e-2 * (-t70 * t59 * t90 * t88 / 0.6e1 - t71 * t151 * t154) / t71 * t58) * t49 * t53
  vrho_0_ = t56 + t77 + t7 * (-t33 * t144 * t53 + t75 * t144 * t53 + t132 + t188)
  t193 = -t35 - t135
  t196 = f.my_piecewise3(t38, 0, 0.4e1 / 0.3e1 * t41 * t193)
  t200 = f.my_piecewise3(t45, 0, -0.4e1 / 0.3e1 * t46 * t193)
  t201 = t196 + t200
  vrho_1_ = t56 + t77 + t7 * (-t33 * t201 * t53 + t75 * t201 * t53 + t132 + t188)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  A_vwn = [None, 0.0310907, 0.01554535, -1 / (6 * jnp.pi ** 2)]

  b_vwn = np.array([np.nan, 3.72744, 7.06042, 1.13107], dtype=np.float64)

  c_vwn = np.array([np.nan, 12.9352, 18.0578, 13.0045], dtype=np.float64)

  x0_vwn = np.array([np.nan, -0.10498, -0.325, -0.0047584], dtype=np.float64)

  Q_vwn = lambda b, c: jnp.sqrt(4 * c - b ** 2)

  f2_vwn = lambda b, c, x0: b * x0 / (x0 ** 2 + b * x0 + c)

  fx_vwn = lambda b, c, rs: rs + b * jnp.sqrt(rs) + c

  f1_vwn = lambda b, c: 2 * b / Q_vwn(b, c)

  f3_vwn = lambda b, c, x0: 2 * (2 * x0 + b) / Q_vwn(b, c)

  f_aux = lambda A, b, c, x0, rs: A * (+jnp.log(rs / fx_vwn(b, c, rs)) + (f1_vwn(b, c) - f2_vwn(b, c, x0) * f3_vwn(b, c, x0)) * jnp.arctan(Q_vwn(b, c) / (2 * jnp.sqrt(rs) + b)) - f2_vwn(b, c, x0) * jnp.log((jnp.sqrt(rs) - x0) ** 2 / fx_vwn(b, c, rs)))

  f_vwn = lambda rs, z: +f_aux(A_vwn[1], b_vwn[1], c_vwn[1], x0_vwn[1], rs) * (1 - f.f_zeta(z)) + f_aux(A_vwn[2], b_vwn[2], c_vwn[2], x0_vwn[2], rs) * f.f_zeta(z)

  functional_body = lambda rs, z: f_vwn(rs, z)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t10 = t4 * t9
  t11 = t10 / 0.4e1
  t12 = jnp.sqrt(t10)
  t14 = t11 + 0.18637200000000000000000000000000000000000000000000e1 * t12 + 0.129352e2
  t15 = 0.1e1 / t14
  t19 = jnp.log(t4 * t9 * t15 / 0.4e1)
  t21 = t12 + 0.372744e1
  t24 = jnp.arctan(0.61519908197590802321728722658814145360143502774884e1 / t21)
  t26 = t12 / 0.2e1
  t27 = t26 + 0.10498e0
  t28 = t27 ** 2
  t30 = jnp.log(t28 * t15)
  t34 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t36 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t34 * f.p.zeta_threshold, 1)
  t38 = 0.2e1 * t36 - 0.2e1
  t39 = 2 ** (0.1e1 / 0.3e1)
  t42 = 0.1e1 / (0.2e1 * t39 - 0.2e1)
  t44 = -t38 * t42 + 0.1e1
  t47 = t11 + 0.35302100000000000000000000000000000000000000000000e1 * t12 + 0.180578e2
  t48 = 0.1e1 / t47
  t52 = jnp.log(t4 * t9 * t48 / 0.4e1)
  t54 = t12 + 0.706042e1
  t57 = jnp.arctan(0.47309269095601128299619512910246923284397083311420e1 / t54)
  t59 = t26 + 0.32500e0
  t60 = t59 ** 2
  t62 = jnp.log(t60 * t48)
  t68 = 0.1e1 / t7 / r0
  t69 = t6 * t68
  t73 = t4 * t6
  t74 = t14 ** 2
  t75 = 0.1e1 / t74
  t77 = t4 * t69
  t78 = t77 / 0.12e2
  t79 = 0.1e1 / t12
  t81 = t3 * t6
  t83 = t79 * t1 * t81 * t68
  t85 = -t78 - 0.31062000000000000000000000000000000000000000000000e0 * t83
  t90 = t1 ** 2
  t92 = 0.1e1 / t3
  t94 = t5 * t7
  t98 = t21 ** 2
  t99 = 0.1e1 / t98
  t125 = t47 ** 2
  t126 = 0.1e1 / t125
  t129 = -t78 - 0.58836833333333333333333333333333333333333333333333e0 * t83
  t139 = t54 ** 2
  t140 = 0.1e1 / t139
  vrho_0_ = (0.310907e-1 * t19 + 0.38783294878113014394824731224995739188004877421366e-1 * t24 + 0.96902277115443742137603943210562149050493484994510e-3 * t30) * t44 + (0.1554535e-1 * t52 + 0.52491393169780936217021346072241076933841385384498e-1 * t57 + 0.22478670955426118383265363956423012380560746650571e-2 * t62) * t38 * t42 + r0 * ((0.10363566666666666666666666666666666666666666666667e-1 * (-t4 * t69 * t15 / 0.12e2 - t73 * t8 * t75 * t85 / 0.4e1) * t90 * t92 * t94 * t14 + 0.39765745675026770180313930393880960493473766078662e-1 * t99 * t79 * t1 * t81 * t68 / (0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t99) + 0.96902277115443742137603943210562149050493484994510e-3 * (-t27 * t15 * t79 * t77 / 0.6e1 - t28 * t75 * t85) / t28 * t14) * t44 + (0.51817833333333333333333333333333333333333333333333e-2 * (-t4 * t69 * t48 / 0.12e2 - t73 * t8 * t126 * t129 / 0.4e1) * t90 * t92 * t94 * t47 + 0.41388824077869423260215065147117773567486474051459e-1 * t140 * t79 * t1 * t81 * t68 / (0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t140) + 0.22478670955426118383265363956423012380560746650571e-2 * (-t59 * t48 * t79 * t77 / 0.6e1 - t60 * t126 * t129) / t60 * t47) * t38 * t42)
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  res = {'vrho': vrho_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t7 / r0
  t10 = t6 * t9
  t11 = 0.1e1 / t7
  t13 = t4 * t6 * t11
  t14 = t13 / 0.4e1
  t15 = jnp.sqrt(t13)
  t17 = t14 + 0.18637200000000000000000000000000000000000000000000e1 * t15 + 0.129352e2
  t18 = 0.1e1 / t17
  t22 = t4 * t6
  t23 = t17 ** 2
  t24 = 0.1e1 / t23
  t25 = t11 * t24
  t26 = t4 * t10
  t27 = t26 / 0.12e2
  t28 = 0.1e1 / t15
  t29 = t28 * t1
  t30 = t3 * t6
  t32 = t29 * t30 * t9
  t34 = -t27 - 0.31062000000000000000000000000000000000000000000000e0 * t32
  t39 = t1 ** 2
  t41 = 0.1e1 / t3
  t42 = (-t4 * t10 * t18 / 0.12e2 - t22 * t25 * t34 / 0.4e1) * t39 * t41
  t43 = t5 * t7
  t44 = t43 * t17
  t47 = t15 + 0.372744e1
  t48 = t47 ** 2
  t49 = 0.1e1 / t48
  t51 = t49 * t28 * t1
  t53 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t49
  t54 = 0.1e1 / t53
  t59 = t15 / 0.2e1
  t60 = t59 + 0.10498e0
  t61 = t60 * t18
  t62 = t61 * t28
  t65 = t60 ** 2
  t66 = t65 * t24
  t68 = -t62 * t26 / 0.6e1 - t66 * t34
  t69 = 0.1e1 / t65
  t70 = t68 * t69
  t75 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t77 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t75 * f.p.zeta_threshold, 1)
  t79 = 0.2e1 * t77 - 0.2e1
  t80 = 2 ** (0.1e1 / 0.3e1)
  t83 = 0.1e1 / (0.2e1 * t80 - 0.2e1)
  t85 = -t79 * t83 + 0.1e1
  t89 = t14 + 0.35302100000000000000000000000000000000000000000000e1 * t15 + 0.180578e2
  t90 = 0.1e1 / t89
  t94 = t89 ** 2
  t95 = 0.1e1 / t94
  t96 = t11 * t95
  t98 = -t27 - 0.58836833333333333333333333333333333333333333333333e0 * t32
  t104 = (-t4 * t10 * t90 / 0.12e2 - t22 * t96 * t98 / 0.4e1) * t39 * t41
  t105 = t43 * t89
  t108 = t15 + 0.706042e1
  t109 = t108 ** 2
  t110 = 0.1e1 / t109
  t112 = t110 * t28 * t1
  t114 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t110
  t115 = 0.1e1 / t114
  t120 = t59 + 0.32500e0
  t121 = t120 * t90
  t122 = t121 * t28
  t125 = t120 ** 2
  t126 = t125 * t95
  t128 = -t122 * t26 / 0.6e1 - t126 * t98
  t129 = 0.1e1 / t125
  t130 = t128 * t129
  t137 = r0 ** 2
  t139 = 0.1e1 / t7 / t137
  t140 = t6 * t139
  t142 = t4 * t140 * t18
  t149 = 0.1e1 / t23 / t17
  t151 = t34 ** 2
  t155 = t4 * t140
  t156 = t155 / 0.9e1
  t158 = 0.1e1 / t15 / t13
  t160 = t3 ** 2
  t161 = t160 * t5
  t162 = t7 ** 2
  t164 = 0.1e1 / t162 / t137
  t166 = t158 * t39 * t161 * t164
  t169 = t29 * t30 * t139
  t171 = t156 - 0.20708000000000000000000000000000000000000000000000e0 * t166 + 0.41416000000000000000000000000000000000000000000000e0 * t169
  t181 = t5 / t162
  t205 = t48 ** 2
  t210 = t53 ** 2
  t225 = t39 * t160 * t5 * t164
  t250 = t4 * t140 * t90
  t257 = 0.1e1 / t94 / t89
  t259 = t98 ** 2
  t265 = t156 - 0.39224555555555555555555555555555555555555555555555e0 * t166 + 0.78449111111111111111111111111111111111111111111110e0 * t169
  t297 = t109 ** 2
  t302 = t114 ** 2
  v2rho2_0_ = 0.2e1 * (0.10363566666666666666666666666666666666666666666667e-1 * t42 * t44 + 0.39765745675026770180313930393880960493473766078662e-1 * t51 * t30 * t9 * t54 + 0.96902277115443742137603943210562149050493484994510e-3 * t70 * t17) * t85 + 0.2e1 * (0.51817833333333333333333333333333333333333333333333e-2 * t104 * t105 + 0.41388824077869423260215065147117773567486474051458e-1 * t112 * t30 * t9 * t115 + 0.22478670955426118383265363956423012380560746650571e-2 * t130 * t89) * t79 * t83 + r0 * ((0.10363566666666666666666666666666666666666666666667e-1 * (t142 / 0.9e1 + t22 * t9 * t24 * t34 / 0.6e1 + t22 * t11 * t149 * t151 / 0.2e1 - t22 * t25 * t171 / 0.4e1) * t39 * t41 * t44 + 0.34545222222222222222222222222222222222222222222223e-2 * t42 * t181 * t17 + 0.10363566666666666666666666666666666666666666666667e-1 * t42 * t43 * t34 + 0.13255248558342256726771310131293653497824588692887e-1 / t48 / t47 * t1 * t3 * t140 * t54 + 0.26510497116684513453542620262587306995649177385775e-1 * t49 * t158 * t39 * t161 * t164 * t54 - 0.53020994233369026907085240525174613991298354771549e-1 * t51 * t30 * t139 * t54 - 0.50167127350538589836488394571946851238131125013746e0 / t205 / t47 * t1 * t3 * t140 / t210 + 0.96902277115443742137603943210562149050493484994510e-3 * (t142 / 0.72e2 + t60 * t24 * t29 * t30 * t9 * t34 / 0.3e1 - t61 * t158 * t225 / 0.9e1 + 0.2e1 / 0.9e1 * t62 * t155 + 0.2e1 * t65 * t149 * t151 - t66 * t171) * t69 * t17 + 0.16150379519240623689600657201760358175082247499085e-3 * t68 / t65 / t60 * t17 * t28 * t26 + 0.96902277115443742137603943210562149050493484994510e-3 * t70 * t34) * t85 + (0.51817833333333333333333333333333333333333333333333e-2 * (t250 / 0.9e1 + t22 * t9 * t95 * t98 / 0.6e1 + t22 * t11 * t257 * t259 / 0.2e1 - t22 * t96 * t265 / 0.4e1) * t39 * t41 * t105 + 0.17272611111111111111111111111111111111111111111111e-2 * t104 * t181 * t89 + 0.51817833333333333333333333333333333333333333333333e-2 * t104 * t43 * t98 + 0.13796274692623141086738355049039257855828824683819e-1 / t109 / t108 * t1 * t3 * t140 * t115 + 0.27592549385246282173476710098078515711657649367639e-1 * t110 * t158 * t39 * t161 * t164 * t115 - 0.55185098770492564346953420196157031423315298735277e-1 * t112 * t30 * t139 * t115 - 0.30878365944746984533884071665444263610784010246137e0 / t297 / t108 * t1 * t3 * t140 / t302 + 0.22478670955426118383265363956423012380560746650571e-2 * (t250 / 0.72e2 + t120 * t95 * t29 * t30 * t9 * t98 / 0.3e1 - t121 * t158 * t225 / 0.9e1 + 0.2e1 / 0.9e1 * t122 * t155 + 0.2e1 * t125 * t257 * t259 - t126 * t265) * t129 * t89 + 0.37464451592376863972108939927371687300934577750952e-3 * t128 / t125 / t120 * t89 * t28 * t26 + 0.22478670955426118383265363956423012380560746650571e-2 * t130 * t98) * t79 * t83)
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** 2
  t8 = r0 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t12 = 0.1e1 / t8
  t14 = t4 * t6 * t12
  t15 = t14 / 0.4e1
  t16 = jnp.sqrt(t14)
  t18 = t15 + 0.18637200000000000000000000000000000000000000000000e1 * t16 + 0.129352e2
  t19 = 0.1e1 / t18
  t21 = t4 * t11 * t19
  t23 = t4 * t6
  t25 = 0.1e1 / t8 / r0
  t26 = t18 ** 2
  t27 = 0.1e1 / t26
  t28 = t25 * t27
  t29 = t6 * t25
  t30 = t4 * t29
  t31 = t30 / 0.12e2
  t32 = 0.1e1 / t16
  t33 = t32 * t1
  t34 = t3 * t6
  t36 = t33 * t34 * t25
  t38 = -t31 - 0.31062000000000000000000000000000000000000000000000e0 * t36
  t43 = 0.1e1 / t26 / t18
  t44 = t12 * t43
  t45 = t38 ** 2
  t49 = t12 * t27
  t50 = t4 * t11
  t51 = t50 / 0.9e1
  t53 = 0.1e1 / t16 / t14
  t54 = t1 ** 2
  t55 = t53 * t54
  t56 = t3 ** 2
  t57 = t56 * t5
  t58 = t8 ** 2
  t60 = 0.1e1 / t58 / t7
  t62 = t55 * t57 * t60
  t65 = t33 * t34 * t10
  t67 = t51 - 0.20708000000000000000000000000000000000000000000000e0 * t62 + 0.41416000000000000000000000000000000000000000000000e0 * t65
  t73 = 0.1e1 / t3
  t74 = (t21 / 0.9e1 + t23 * t28 * t38 / 0.6e1 + t23 * t44 * t45 / 0.2e1 - t23 * t49 * t67 / 0.4e1) * t54 * t73
  t75 = t5 * t8
  t76 = t75 * t18
  t87 = (-t4 * t29 * t19 / 0.12e2 - t23 * t49 * t38 / 0.4e1) * t54 * t73
  t89 = t5 / t58
  t90 = t89 * t18
  t93 = t75 * t38
  t96 = t16 + 0.372744e1
  t97 = t96 ** 2
  t100 = 0.1e1 / t97 / t96 * t1
  t101 = t100 * t3
  t102 = 0.1e1 / t97
  t104 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t102
  t105 = 0.1e1 / t104
  t110 = t102 * t53 * t54
  t116 = t102 * t32 * t1
  t121 = t97 ** 2
  t124 = 0.1e1 / t121 / t96 * t1
  t125 = t124 * t3
  t126 = t104 ** 2
  t127 = 0.1e1 / t126
  t132 = t16 / 0.2e1
  t133 = t132 + 0.10498e0
  t134 = t133 * t27
  t135 = t134 * t33
  t140 = t133 * t19
  t141 = t140 * t53
  t142 = t54 * t56
  t144 = t142 * t5 * t60
  t147 = t140 * t32
  t150 = t133 ** 2
  t151 = t150 * t43
  t154 = t150 * t27
  t156 = t21 / 0.72e2 + t135 * t34 * t25 * t38 / 0.3e1 - t141 * t144 / 0.9e1 + 0.2e1 / 0.9e1 * t147 * t50 + 0.2e1 * t151 * t45 - t154 * t67
  t157 = 0.1e1 / t150
  t158 = t156 * t157
  t164 = -t147 * t30 / 0.6e1 - t154 * t38
  t166 = 0.1e1 / t150 / t133
  t167 = t164 * t166
  t168 = t18 * t32
  t169 = t167 * t168
  t172 = t164 * t157
  t177 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t179 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t177 * f.p.zeta_threshold, 1)
  t181 = 0.2e1 * t179 - 0.2e1
  t182 = 2 ** (0.1e1 / 0.3e1)
  t185 = 0.1e1 / (0.2e1 * t182 - 0.2e1)
  t187 = -t181 * t185 + 0.1e1
  t191 = t15 + 0.35302100000000000000000000000000000000000000000000e1 * t16 + 0.180578e2
  t192 = 0.1e1 / t191
  t194 = t4 * t11 * t192
  t196 = t191 ** 2
  t197 = 0.1e1 / t196
  t198 = t25 * t197
  t200 = -t31 - 0.58836833333333333333333333333333333333333333333333e0 * t36
  t205 = 0.1e1 / t196 / t191
  t206 = t12 * t205
  t207 = t200 ** 2
  t211 = t12 * t197
  t214 = t51 - 0.39224555555555555555555555555555555555555555555555e0 * t62 + 0.78449111111111111111111111111111111111111111111110e0 * t65
  t220 = (t194 / 0.9e1 + t23 * t198 * t200 / 0.6e1 + t23 * t206 * t207 / 0.2e1 - t23 * t211 * t214 / 0.4e1) * t54 * t73
  t221 = t75 * t191
  t232 = (-t4 * t29 * t192 / 0.12e2 - t23 * t211 * t200 / 0.4e1) * t54 * t73
  t233 = t89 * t191
  t236 = t75 * t200
  t239 = t16 + 0.706042e1
  t240 = t239 ** 2
  t243 = 0.1e1 / t240 / t239 * t1
  t244 = t243 * t3
  t245 = 0.1e1 / t240
  t247 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t245
  t248 = 0.1e1 / t247
  t253 = t245 * t53 * t54
  t259 = t245 * t32 * t1
  t264 = t240 ** 2
  t267 = 0.1e1 / t264 / t239 * t1
  t268 = t267 * t3
  t269 = t247 ** 2
  t270 = 0.1e1 / t269
  t275 = t132 + 0.32500e0
  t276 = t275 * t197
  t277 = t276 * t33
  t282 = t275 * t192
  t283 = t282 * t53
  t286 = t282 * t32
  t289 = t275 ** 2
  t290 = t289 * t205
  t293 = t289 * t197
  t295 = t194 / 0.72e2 + t277 * t34 * t25 * t200 / 0.3e1 - t283 * t144 / 0.9e1 + 0.2e1 / 0.9e1 * t286 * t50 + 0.2e1 * t290 * t207 - t293 * t214
  t296 = 0.1e1 / t289
  t297 = t295 * t296
  t303 = -t286 * t30 / 0.6e1 - t293 * t200
  t305 = 0.1e1 / t289 / t275
  t306 = t303 * t305
  t307 = t191 * t32
  t308 = t306 * t307
  t311 = t303 * t296
  t318 = t150 ** 2
  t327 = 0.1e1 / t16 / t142 / t89 / 0.4e1
  t329 = t7 ** 2
  t330 = 0.1e1 / t329
  t331 = t2 * t330
  t337 = t121 ** 2
  t341 = t7 * r0
  t343 = 0.1e1 / t58 / t341
  t344 = t5 * t343
  t352 = 0.1e1 / t8 / t341
  t353 = t6 * t352
  t355 = t4 * t353 * t19
  t359 = t23 * t10 * t27 * t38
  t379 = 0.1e1 / t56
  t381 = t1 * t379 * t6
  t382 = t352 * t2
  t387 = t327 * t2 * t330
  t390 = t142 * t344
  t393 = t4 * t353
  t396 = t26 ** 2
  t397 = 0.1e1 / t396
  t399 = t45 * t38
  t402 = t38 * t67
  t405 = 0.7e1 / 0.27e2 * t393
  t408 = t55 * t57 * t343
  t411 = t33 * t34 * t352
  t413 = -t405 - 0.12424800000000000000000000000000000000000000000000e1 * t387 + 0.82832000000000000000000000000000000000000000000000e0 * t408 - 0.96637333333333333333333333333333333333333333333333e0 * t411
  t415 = -0.11e2 / 0.216e3 * t355 - t359 / 0.24e2 - t133 * t43 * t33 * t34 * t25 * t45 + t134 * t55 * t57 * t60 * t38 / 0.3e1 - 0.2e1 / 0.3e1 * t135 * t34 * t10 * t38 + t135 * t34 * t25 * t67 / 0.2e1 + t381 * t382 * t19 / 0.432e3 - 0.2e1 / 0.3e1 * t140 * t387 + 0.4e1 / 0.9e1 * t141 * t390 - 0.14e2 / 0.27e2 * t147 * t393 - 0.6e1 * t150 * t397 * t399 + 0.6e1 * t151 * t402 - t154 * t413
  t443 = 0.40375948798101559224001643004400895437705618747712e-4 * t164 / t318 * t18 * t50 + 0.15906298270010708072125572157552384197389506431465e0 * t102 * t327 * t331 * t105 - 0.21533839358987498252800876269013810900109663332113e-3 * t169 * t50 + 0.50631328524251801700246888250186209051365905137714e2 / t337 * t54 * t56 * t344 / t126 / t104 * t32 + 0.96902277115443742137603943210562149050493484994510e-3 * t415 * t157 * t18 + 0.19380455423088748427520788642112429810098696998902e-2 * t158 * t38 + 0.96902277115443742137603943210562149050493484994510e-3 * t172 * t67 - 0.10604198846673805381417048105034922798259670954310e0 * t110 * t57 * t343 * t105 + 0.12371565321119439611653222789207409931302949446695e0 * t116 * t34 * t352 * t105 + 0.32300759038481247379201314403520716350164494998170e-3 * t156 * t166 * t168 * t30 + 0.32300759038481247379201314403520716350164494998170e-3 * t167 * t38 * t32 * t30 + 0.10766919679493749126400438134506905450054831666057e-3 * t167 * t18 * t53 * t144
  t483 = t5 / t58 / r0
  t515 = 0.10363566666666666666666666666666666666666666666667e-1 * (-0.7e1 / 0.27e2 * t355 - t359 / 0.3e1 - t23 * t25 * t43 * t45 / 0.2e1 + t23 * t28 * t67 / 0.4e1 - 0.3e1 / 0.2e1 * t23 * t12 * t397 * t399 + 0.3e1 / 0.2e1 * t23 * t44 * t402 - t23 * t49 * t413 / 0.4e1) * t54 * t73 * t76 + 0.20727133333333333333333333333333333333333333333334e-1 * t74 * t93 + 0.69090444444444444444444444444444444444444444444446e-2 * t87 * t89 * t38 + 0.10363566666666666666666666666666666666666666666667e-1 * t87 * t75 * t67 + 0.18394613361864149606712411343047178787314745838373e1 * t125 * t353 * t127 + 0.69090444444444444444444444444444444444444444444446e-2 * t74 * t90 - 0.23030148148148148148148148148148148148148148148149e-2 * t87 * t483 * t18 - 0.48602578047254941331494803814743396158690158540586e-1 * t101 * t353 * t105 + 0.26510497116684513453542620262587306995649177385774e-1 / t121 * t54 * t56 * t344 * t105 * t32 - 0.23411326096918008590361250800241863911127858339748e1 / t121 / t97 * t54 * t56 * t344 * t127 * t32 + 0.22092080930570427877952183552156089163040981154812e-2 * t100 * t379 * t353 * t2 * t105 - 0.83611878917564316394147324286578085396885208356242e-1 * t124 * t379 * t353 * t2 * t127
  t534 = t4 * t353 * t192
  t538 = t23 * t10 * t197 * t200
  t547 = t196 ** 2
  t548 = 0.1e1 / t547
  t550 = t207 * t200
  t554 = t200 * t214
  t561 = -t405 - 0.23534733333333333333333333333333333333333333333333e1 * t387 + 0.15689822222222222222222222222222222222222222222222e1 * t408 - 0.18304792592592592592592592592592592592592592592592e1 * t411
  t570 = t289 ** 2
  t604 = 0.16555529631147769304086026058847109426994589620583e0 * t245 * t327 * t331 * t248 + 0.11322067513073894329090826277329563323954137090250e1 * t268 * t353 * t270 + 0.51817833333333333333333333333333333333333333333333e-2 * t232 * t75 * t214 + 0.34545222222222222222222222222222222222222222222222e-2 * t232 * t89 * t200 + 0.10363566666666666666666666666666666666666666666667e-1 * t220 * t236 + 0.51817833333333333333333333333333333333333333333333e-2 * (-0.7e1 / 0.27e2 * t534 - t538 / 0.3e1 - t23 * t25 * t205 * t207 / 0.2e1 + t23 * t198 * t214 / 0.4e1 - 0.3e1 / 0.2e1 * t23 * t12 * t548 * t550 + 0.3e1 / 0.2e1 * t23 * t206 * t554 - t23 * t211 * t561 / 0.4e1) * t54 * t73 * t221 + 0.93661128980942159930272349818429218252336444377380e-4 * t303 / t570 * t191 * t50 - 0.50586340539618183984707301846477278804705690507337e-1 * t244 * t353 * t248 + 0.27592549385246282173476710098078515711657649367638e-1 / t264 * t54 * t56 * t344 * t248 * t32 - 0.14409904107548592782479233443873989685032538114864e1 / t264 / t240 * t54 * t56 * t344 * t270 * t32 + 0.22993791154371901811230591748398763093048041139699e-2 * t243 * t379 * t353 * t2 * t248 - 0.51463943241244974223140119442407106017973350410227e-1 * t267 * t379 * t353 * t2 * t270
  t605 = t264 ** 2
  t657 = -0.11e2 / 0.216e3 * t534 - t538 / 0.24e2 - t275 * t205 * t33 * t34 * t25 * t207 + t276 * t55 * t57 * t60 * t200 / 0.3e1 - 0.2e1 / 0.3e1 * t277 * t34 * t10 * t200 + t277 * t34 * t25 * t214 / 0.2e1 + t381 * t382 * t192 / 0.432e3 - 0.2e1 / 0.3e1 * t282 * t387 + 0.4e1 / 0.9e1 * t283 * t390 - 0.14e2 / 0.27e2 * t286 * t393 - 0.6e1 * t289 * t548 * t550 + 0.6e1 * t290 * t554 - t293 * t561
  t685 = 0.18429583437767336287475605998441200095133403022660e2 / t605 * t54 * t56 * t344 / t269 / t247 * t32 - 0.11515074074074074074074074074074074074074074074074e-2 * t232 * t483 * t191 + 0.34545222222222222222222222222222222222222222222222e-2 * t220 * t233 - 0.49952602123169151962811919903162249734579437001269e-3 * t308 * t50 + 0.22478670955426118383265363956423012380560746650571e-2 * t657 * t296 * t191 + 0.44957341910852236766530727912846024761121493301142e-2 * t297 * t200 + 0.22478670955426118383265363956423012380560746650571e-2 * t311 * t214 - 0.11037019754098512869390684039231406284663059747056e0 * t253 * t57 * t343 * t248 + 0.12876523046448265014289131379103307332106903038231e0 * t259 * t34 * t352 * t248 + 0.74928903184753727944217879854743374601869155501904e-3 * t295 * t305 * t307 * t30 + 0.74928903184753727944217879854743374601869155501904e-3 * t306 * t200 * t32 * t30 + 0.24976301061584575981405959951581124867289718500635e-3 * t306 * t191 * t53 * t144
  v3rho3_0_ = 0.3e1 * (0.10363566666666666666666666666666666666666666666667e-1 * t74 * t76 + 0.34545222222222222222222222222222222222222222222223e-2 * t87 * t90 + 0.10363566666666666666666666666666666666666666666667e-1 * t87 * t93 + 0.13255248558342256726771310131293653497824588692887e-1 * t101 * t11 * t105 + 0.26510497116684513453542620262587306995649177385775e-1 * t110 * t57 * t60 * t105 - 0.53020994233369026907085240525174613991298354771549e-1 * t116 * t34 * t10 * t105 - 0.50167127350538589836488394571946851238131125013746e0 * t125 * t11 * t127 + 0.96902277115443742137603943210562149050493484994510e-3 * t158 * t18 + 0.16150379519240623689600657201760358175082247499085e-3 * t169 * t30 + 0.96902277115443742137603943210562149050493484994510e-3 * t172 * t38) * t187 + 0.3e1 * (0.51817833333333333333333333333333333333333333333333e-2 * t220 * t221 + 0.17272611111111111111111111111111111111111111111111e-2 * t232 * t233 + 0.51817833333333333333333333333333333333333333333333e-2 * t232 * t236 + 0.13796274692623141086738355049039257855828824683819e-1 * t244 * t11 * t248 + 0.27592549385246282173476710098078515711657649367639e-1 * t253 * t57 * t60 * t248 - 0.55185098770492564346953420196157031423315298735277e-1 * t259 * t34 * t10 * t248 - 0.30878365944746984533884071665444263610784010246137e0 * t268 * t11 * t270 + 0.22478670955426118383265363956423012380560746650571e-2 * t297 * t191 + 0.37464451592376863972108939927371687300934577750952e-3 * t308 * t30 + 0.22478670955426118383265363956423012380560746650571e-2 * t311 * t200) * t181 * t185 + r0 * ((t443 + t515) * t187 + (t604 + t685) * t181 * t185)

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t7
  t10 = t4 * t6 * t8
  t11 = jnp.sqrt(t10)
  t12 = t11 / 0.2e1
  t13 = t12 + 0.10498e0
  t14 = t10 / 0.4e1
  t16 = t14 + 0.18637200000000000000000000000000000000000000000000e1 * t11 + 0.129352e2
  t17 = 0.1e1 / t16
  t18 = t13 * t17
  t19 = 0.1e1 / t11
  t20 = t18 * t19
  t22 = 0.1e1 / t7 / r0
  t23 = t6 * t22
  t24 = t4 * t23
  t27 = t13 ** 2
  t28 = t16 ** 2
  t29 = 0.1e1 / t28
  t30 = t27 * t29
  t31 = t24 / 0.12e2
  t32 = t19 * t1
  t33 = t3 * t6
  t35 = t32 * t33 * t22
  t37 = -t31 - 0.31062000000000000000000000000000000000000000000000e0 * t35
  t39 = -t20 * t24 / 0.6e1 - t30 * t37
  t40 = t27 ** 2
  t41 = 0.1e1 / t40
  t42 = t39 * t41
  t43 = t42 * t16
  t44 = r0 ** 2
  t46 = 0.1e1 / t7 / t44
  t47 = t6 * t46
  t48 = t4 * t47
  t51 = t11 + 0.372744e1
  t52 = t51 ** 2
  t53 = 0.1e1 / t52
  t54 = t1 ** 2
  t55 = t3 ** 2
  t56 = t54 * t55
  t57 = t7 ** 2
  t59 = t5 / t57
  t63 = 0.1e1 / t11 / t56 / t59 / 0.4e1
  t64 = t53 * t63
  t65 = t44 ** 2
  t66 = 0.1e1 / t65
  t67 = t2 * t66
  t69 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t53
  t70 = 0.1e1 / t69
  t75 = 0.1e1 / t27 / t13
  t76 = t39 * t75
  t77 = t16 * t19
  t78 = t76 * t77
  t81 = t52 ** 2
  t82 = t81 ** 2
  t83 = 0.1e1 / t82
  t84 = t83 * t54
  t85 = t84 * t55
  t86 = t44 * r0
  t88 = 0.1e1 / t57 / t86
  t89 = t5 * t88
  t90 = t69 ** 2
  t92 = 0.1e1 / t90 / t69
  t93 = t92 * t19
  t98 = 0.1e1 / t7 / t86
  t99 = t6 * t98
  t101 = t4 * t99 * t17
  t103 = t4 * t6
  t104 = t46 * t29
  t106 = t103 * t104 * t37
  t109 = 0.1e1 / t28 / t16
  t110 = t13 * t109
  t111 = t110 * t32
  t112 = t37 ** 2
  t116 = t13 * t29
  t118 = 0.1e1 / t11 / t10
  t119 = t118 * t54
  t120 = t116 * t119
  t121 = t55 * t5
  t123 = 0.1e1 / t57 / t44
  t128 = t116 * t32
  t133 = t48 / 0.9e1
  t135 = t119 * t121 * t123
  t138 = t32 * t33 * t46
  t140 = t133 - 0.20708000000000000000000000000000000000000000000000e0 * t135 + 0.41416000000000000000000000000000000000000000000000e0 * t138
  t145 = 0.1e1 / t55
  t147 = t1 * t145 * t6
  t148 = t98 * t2
  t152 = t63 * t2
  t153 = t152 * t66
  t156 = t18 * t118
  t157 = t56 * t89
  t160 = t4 * t99
  t163 = t28 ** 2
  t164 = 0.1e1 / t163
  t165 = t27 * t164
  t166 = t112 * t37
  t169 = t27 * t109
  t170 = t37 * t140
  t173 = 0.7e1 / 0.27e2 * t160
  t176 = t119 * t121 * t88
  t179 = t32 * t33 * t98
  t181 = -t173 - 0.12424800000000000000000000000000000000000000000000e1 * t153 + 0.82832000000000000000000000000000000000000000000000e0 * t176 - 0.96637333333333333333333333333333333333333333333333e0 * t179
  t183 = -0.11e2 / 0.216e3 * t101 - t106 / 0.24e2 - t111 * t33 * t22 * t112 + t120 * t121 * t123 * t37 / 0.3e1 - 0.2e1 / 0.3e1 * t128 * t33 * t46 * t37 + t128 * t33 * t22 * t140 / 0.2e1 + t147 * t148 * t17 / 0.432e3 - 0.2e1 / 0.3e1 * t18 * t153 + 0.4e1 / 0.9e1 * t156 * t157 - 0.14e2 / 0.27e2 * t20 * t160 - 0.6e1 * t165 * t166 + 0.6e1 * t169 * t170 - t30 * t181
  t184 = 0.1e1 / t27
  t185 = t183 * t184
  t189 = t4 * t47 * t17
  t191 = t22 * t37
  t195 = t5 * t123
  t196 = t56 * t195
  t204 = t189 / 0.72e2 + t128 * t33 * t191 / 0.3e1 - t156 * t196 / 0.9e1 + 0.2e1 / 0.9e1 * t20 * t48 + 0.2e1 * t169 * t112 - t30 * t140
  t205 = t204 * t184
  t208 = t39 * t184
  t212 = t53 * t118 * t54
  t218 = t53 * t19 * t1
  t223 = t204 * t75
  t224 = t223 * t77
  t227 = t37 * t19
  t228 = t76 * t227
  t231 = t16 * t118
  t232 = t76 * t231
  t235 = 0.40375948798101559224001643004400895437705618747712e-4 * t43 * t48 + 0.15906298270010708072125572157552384197389506431465e0 * t64 * t67 * t70 - 0.21533839358987498252800876269013810900109663332113e-3 * t78 * t48 + 0.50631328524251801700246888250186209051365905137714e2 * t85 * t89 * t93 + 0.96902277115443742137603943210562149050493484994510e-3 * t185 * t16 + 0.19380455423088748427520788642112429810098696998902e-2 * t205 * t37 + 0.96902277115443742137603943210562149050493484994510e-3 * t208 * t140 - 0.10604198846673805381417048105034922798259670954310e0 * t212 * t121 * t88 * t70 + 0.12371565321119439611653222789207409931302949446695e0 * t218 * t33 * t98 * t70 + 0.32300759038481247379201314403520716350164494998170e-3 * t224 * t24 + 0.32300759038481247379201314403520716350164494998170e-3 * t228 * t24 + 0.10766919679493749126400438134506905450054831666057e-3 * t232 * t196
  t238 = t22 * t109
  t242 = t22 * t29
  t246 = t8 * t164
  t250 = t8 * t109
  t254 = t8 * t29
  t260 = 0.1e1 / t3
  t261 = (-0.7e1 / 0.27e2 * t101 - t106 / 0.3e1 - t103 * t238 * t112 / 0.2e1 + t103 * t242 * t140 / 0.4e1 - 0.3e1 / 0.2e1 * t103 * t246 * t166 + 0.3e1 / 0.2e1 * t103 * t250 * t170 - t103 * t254 * t181 / 0.4e1) * t54 * t260
  t262 = t5 * t7
  t263 = t262 * t16
  t278 = (t189 / 0.9e1 + t103 * t242 * t37 / 0.6e1 + t103 * t250 * t112 / 0.2e1 - t103 * t254 * t140 / 0.4e1) * t54 * t260
  t279 = t262 * t37
  t290 = (-t4 * t23 * t17 / 0.12e2 - t103 * t254 * t37 / 0.4e1) * t54 * t260
  t291 = t59 * t37
  t294 = t262 * t140
  t298 = 0.1e1 / t81 / t51
  t299 = t298 * t1
  t301 = 0.1e1 / t90
  t305 = t59 * t16
  t310 = t5 / t57 / r0
  t311 = t310 * t16
  t314 = t52 * t51
  t315 = 0.1e1 / t314
  t316 = t315 * t1
  t321 = 0.1e1 / t81
  t322 = t321 * t54
  t323 = t322 * t55
  t324 = t70 * t19
  t329 = 0.1e1 / t81 / t52
  t330 = t329 * t54
  t331 = t330 * t55
  t332 = t301 * t19
  t336 = t316 * t145
  t337 = t2 * t70
  t341 = t299 * t145
  t342 = t2 * t301
  t346 = 0.10363566666666666666666666666666666666666666666667e-1 * t261 * t263 + 0.20727133333333333333333333333333333333333333333334e-1 * t278 * t279 + 0.69090444444444444444444444444444444444444444444446e-2 * t290 * t291 + 0.10363566666666666666666666666666666666666666666667e-1 * t290 * t294 + 0.18394613361864149606712411343047178787314745838373e1 * t299 * t3 * t99 * t301 + 0.69090444444444444444444444444444444444444444444446e-2 * t278 * t305 - 0.23030148148148148148148148148148148148148148148149e-2 * t290 * t311 - 0.48602578047254941331494803814743396158690158540586e-1 * t316 * t3 * t99 * t70 + 0.26510497116684513453542620262587306995649177385774e-1 * t323 * t89 * t324 - 0.23411326096918008590361250800241863911127858339748e1 * t331 * t89 * t332 + 0.22092080930570427877952183552156089163040981154812e-2 * t336 * t99 * t337 - 0.83611878917564316394147324286578085396885208356242e-1 * t341 * t99 * t342
  t349 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t351 = f.my_piecewise3(0.1e1 <= f.p.zeta_threshold, t349 * f.p.zeta_threshold, 1)
  t353 = 0.2e1 * t351 - 0.2e1
  t354 = 2 ** (0.1e1 / 0.3e1)
  t357 = 0.1e1 / (0.2e1 * t354 - 0.2e1)
  t359 = -t353 * t357 + 0.1e1
  t362 = t11 + 0.706042e1
  t363 = t362 ** 2
  t364 = 0.1e1 / t363
  t365 = t364 * t63
  t367 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t364
  t368 = 0.1e1 / t367
  t372 = t363 ** 2
  t374 = 0.1e1 / t372 / t362
  t375 = t374 * t1
  t377 = t367 ** 2
  t378 = 0.1e1 / t377
  t383 = t14 + 0.35302100000000000000000000000000000000000000000000e1 * t11 + 0.180578e2
  t384 = 0.1e1 / t383
  t388 = t383 ** 2
  t389 = 0.1e1 / t388
  t390 = t8 * t389
  t392 = -t31 - 0.58836833333333333333333333333333333333333333333333e0 * t35
  t398 = (-t4 * t23 * t384 / 0.12e2 - t103 * t390 * t392 / 0.4e1) * t54 * t260
  t401 = t133 - 0.39224555555555555555555555555555555555555555555555e0 * t135 + 0.78449111111111111111111111111111111111111111111110e0 * t138
  t402 = t262 * t401
  t405 = t59 * t392
  t409 = t4 * t47 * t384
  t411 = t22 * t389
  t416 = 0.1e1 / t388 / t383
  t417 = t8 * t416
  t418 = t392 ** 2
  t427 = (t409 / 0.9e1 + t103 * t411 * t392 / 0.6e1 + t103 * t417 * t418 / 0.2e1 - t103 * t390 * t401 / 0.4e1) * t54 * t260
  t428 = t262 * t392
  t432 = t4 * t99 * t384
  t434 = t46 * t389
  t436 = t103 * t434 * t392
  t438 = t22 * t416
  t445 = t388 ** 2
  t446 = 0.1e1 / t445
  t447 = t8 * t446
  t448 = t418 * t392
  t452 = t392 * t401
  t459 = -t173 - 0.23534733333333333333333333333333333333333333333333e1 * t153 + 0.15689822222222222222222222222222222222222222222222e1 * t176 - 0.18304792592592592592592592592592592592592592592592e1 * t179
  t465 = (-0.7e1 / 0.27e2 * t432 - t436 / 0.3e1 - t103 * t438 * t418 / 0.2e1 + t103 * t411 * t401 / 0.4e1 - 0.3e1 / 0.2e1 * t103 * t447 * t448 + 0.3e1 / 0.2e1 * t103 * t417 * t452 - t103 * t390 * t459 / 0.4e1) * t54 * t260
  t466 = t262 * t383
  t469 = t12 + 0.32500e0
  t470 = t469 * t384
  t471 = t470 * t19
  t474 = t469 ** 2
  t475 = t474 * t389
  t477 = -t471 * t24 / 0.6e1 - t475 * t392
  t478 = t474 ** 2
  t479 = 0.1e1 / t478
  t480 = t477 * t479
  t481 = t480 * t383
  t484 = t363 * t362
  t485 = 0.1e1 / t484
  t486 = t485 * t1
  t491 = 0.1e1 / t372
  t492 = t491 * t54
  t493 = t492 * t55
  t494 = t368 * t19
  t499 = 0.1e1 / t372 / t363
  t500 = t499 * t54
  t501 = t500 * t55
  t502 = t378 * t19
  t506 = t486 * t145
  t507 = t2 * t368
  t511 = t375 * t145
  t512 = t2 * t378
  t516 = 0.16555529631147769304086026058847109426994589620583e0 * t365 * t67 * t368 + 0.11322067513073894329090826277329563323954137090250e1 * t375 * t3 * t99 * t378 + 0.51817833333333333333333333333333333333333333333333e-2 * t398 * t402 + 0.34545222222222222222222222222222222222222222222222e-2 * t398 * t405 + 0.10363566666666666666666666666666666666666666666667e-1 * t427 * t428 + 0.51817833333333333333333333333333333333333333333333e-2 * t465 * t466 + 0.93661128980942159930272349818429218252336444377380e-4 * t481 * t48 - 0.50586340539618183984707301846477278804705690507337e-1 * t486 * t3 * t99 * t368 + 0.27592549385246282173476710098078515711657649367638e-1 * t493 * t89 * t494 - 0.14409904107548592782479233443873989685032538114864e1 * t501 * t89 * t502 + 0.22993791154371901811230591748398763093048041139699e-2 * t506 * t99 * t507 - 0.51463943241244974223140119442407106017973350410227e-1 * t511 * t99 * t512
  t517 = t372 ** 2
  t518 = 0.1e1 / t517
  t519 = t518 * t54
  t520 = t519 * t55
  t522 = 0.1e1 / t377 / t367
  t523 = t522 * t19
  t527 = t310 * t383
  t530 = t59 * t383
  t534 = 0.1e1 / t474 / t469
  t535 = t477 * t534
  t536 = t383 * t19
  t537 = t535 * t536
  t542 = t469 * t416
  t543 = t542 * t32
  t547 = t469 * t389
  t548 = t547 * t119
  t553 = t547 * t32
  t567 = t470 * t118
  t572 = t474 * t446
  t575 = t474 * t416
  t579 = -0.11e2 / 0.216e3 * t432 - t436 / 0.24e2 - t543 * t33 * t22 * t418 + t548 * t121 * t123 * t392 / 0.3e1 - 0.2e1 / 0.3e1 * t553 * t33 * t46 * t392 + t553 * t33 * t22 * t401 / 0.2e1 + t147 * t148 * t384 / 0.432e3 - 0.2e1 / 0.3e1 * t470 * t153 + 0.4e1 / 0.9e1 * t567 * t157 - 0.14e2 / 0.27e2 * t471 * t160 - 0.6e1 * t572 * t448 + 0.6e1 * t575 * t452 - t475 * t459
  t580 = 0.1e1 / t474
  t581 = t579 * t580
  t585 = t22 * t392
  t596 = t409 / 0.72e2 + t553 * t33 * t585 / 0.3e1 - t567 * t196 / 0.9e1 + 0.2e1 / 0.9e1 * t471 * t48 + 0.2e1 * t575 * t418 - t475 * t401
  t597 = t596 * t580
  t600 = t477 * t580
  t604 = t364 * t118 * t54
  t610 = t364 * t19 * t1
  t615 = t596 * t534
  t616 = t615 * t536
  t619 = t392 * t19
  t620 = t535 * t619
  t623 = t383 * t118
  t624 = t535 * t623
  t627 = 0.18429583437767336287475605998441200095133403022660e2 * t520 * t89 * t523 - 0.11515074074074074074074074074074074074074074074074e-2 * t398 * t527 + 0.34545222222222222222222222222222222222222222222222e-2 * t427 * t530 - 0.49952602123169151962811919903162249734579437001269e-3 * t537 * t48 + 0.22478670955426118383265363956423012380560746650571e-2 * t581 * t383 + 0.44957341910852236766530727912846024761121493301142e-2 * t597 * t392 + 0.22478670955426118383265363956423012380560746650571e-2 * t600 * t401 - 0.11037019754098512869390684039231406284663059747056e0 * t604 * t121 * t88 * t368 + 0.12876523046448265014289131379103307332106903038231e0 * t610 * t33 * t98 * t368 + 0.74928903184753727944217879854743374601869155501904e-3 * t616 * t24 + 0.74928903184753727944217879854743374601869155501904e-3 * t620 * t24 + 0.24976301061584575981405959951581124867289718500635e-3 * t624 * t196
  t632 = t260 * t5
  t635 = 0.1e1 / t57 / t65
  t636 = t635 * t2
  t651 = t145 * t6 * t148
  t678 = t121 * t88 * t19
  t685 = 0.1e1 / t11 / t2 * r0 / 0.48e2
  t687 = t65 * r0
  t689 = 0.1e1 / t7 / t687
  t690 = t2 * t689
  t698 = 0.84385547540419669500411480416977015085609841896189e1 * t84 * t632 * t636 * t93 + 0.44184161861140855755904367104312178326081962309624e-2 * t322 * t632 * t636 * t324 - 0.39018876828196680983935418000403106518546430566246e0 * t330 * t632 * t636 * t332 + 0.67293247996835932040002738340668159062842697912856e-5 * t42 * t16 * t1 * t651 + 0.32300759038481247379201314403520716350164494998170e-3 * t223 * t231 * t196 + 0.32300759038481247379201314403520716350164494998170e-3 * t76 * t37 * t118 * t196 + 0.48451138557721871068801971605281074525246742497255e-3 * t76 * t140 * t19 * t24 + 0.48451138557721871068801971605281074525246742497255e-3 * t183 * t75 * t77 * t24 + 0.96902277115443742137603943210562149050493484994510e-3 * t223 * t227 * t24 + 0.53834598397468745632002190672534527250274158330283e-4 * t39 / t40 / t13 * t16 * t54 * t678 + 0.13255248558342256726771310131293653497824588692887e0 * t53 * t685 * t690 * t70 * t1 * t33 - 0.64601518076962494758402628807041432700328989996340e-3 * t224 * t48
  t705 = 0.1e1 / t687
  t706 = t2 * t705
  t733 = t5 * t635
  t738 = 0.1e1 / t7 / t65
  t739 = t6 * t738
  t758 = t90 ** 2
  t764 = -0.64601518076962494758402628807041432700328989996340e-3 * t228 * t48 - 0.43067678717974996505601752538027621800219326664227e-3 * t232 * t157 + 0.50245625170970829256535377961032225433589214441597e-3 * t78 * t160 - 0.12725038616008566457700457726041907357911605145172e1 * t64 * t706 * t70 + 0.10126265704850360340049377650037241810273181027543e3 * t83 * t2 * t705 * t92 * t118 + 0.53020994233369026907085240525174613991298354771548e-1 * t321 * t2 * t705 * t70 * t118 - 0.46822652193836017180722501600483727822255716679496e1 * t329 * t2 * t705 * t301 * t118 - 0.26755801253620581246127143771704987327003266673998e1 / t81 / t314 * t2 * t635 * t301 * t54 * t632 + 0.17168305804406539632931583920177366868160429449148e2 * t331 * t733 * t332 - 0.16200859349084980443831601271581132052896719513529e-1 * t336 * t739 * t337 + 0.61315377872880498689041371143490595957715819461244e0 * t341 * t739 * t342 + 0.12657832131062950425061722062546552262841476284429e3 / t82 / t51 * t2 * t635 * t92 * t54 * t632 - 0.19162434373246948642083122762742588170998040494372e4 / t82 / t314 * t2 * t635 / t758 * t54 * t632
  t816 = t685 * t2
  t819 = t689 * t1 * t33
  t840 = t152 * t705
  t844 = t4 * t739 * t17
  t846 = t4 * t739
  t849 = -0.4e1 / 0.3e1 * t110 * t119 * t121 * t123 * t112 + 0.2e1 / 0.3e1 * t120 * t121 * t123 * t140 - 0.4e1 / 0.3e1 * t128 * t33 * t46 * t140 + 0.2e1 / 0.3e1 * t128 * t33 * t22 * t181 - 0.5e1 / 0.9e1 * t18 * t816 * t819 - 0.16e2 / 0.9e1 * t120 * t121 * t88 * t37 + 0.56e2 / 0.27e2 * t128 * t33 * t98 * t37 + 0.4e1 * t13 * t164 * t32 * t33 * t22 * t166 + 0.8e1 / 0.3e1 * t111 * t33 * t46 * t112 + 0.16e2 / 0.3e1 * t18 * t840 + 0.185e3 / 0.864e3 * t844 + 0.140e3 / 0.81e2 * t20 * t846
  t854 = t56 * t733
  t857 = t37 * t181
  t860 = t112 * t140
  t868 = t103 * t104 * t140
  t872 = t103 * t98 * t29 * t37
  t874 = t738 * t2
  t884 = t103 * t46 * t109 * t112
  t886 = 0.70e2 / 0.81e2 * t846
  t888 = t816 * t689 * t103
  t892 = t119 * t121 * t635
  t895 = t32 * t33 * t738
  t897 = t886 - 0.10354000000000000000000000000000000000000000000000e1 * t888 + 0.99398400000000000000000000000000000000000000000000e1 * t840 - 0.36814222222222222222222222222222222222222222222222e1 * t892 + 0.32212444444444444444444444444444444444444444444444e1 * t895
  t900 = 0.1e1 / t163 / t16
  t902 = t112 ** 2
  t905 = t140 ** 2
  t908 = -t147 * t148 * t29 * t37 / 0.108e3 - 0.160e3 / 0.81e2 * t156 * t854 + 0.8e1 * t169 * t857 - 0.36e2 * t165 * t860 + 0.8e1 / 0.3e1 * t116 * t63 * t67 * t37 - t868 / 0.12e2 + 0.11e2 / 0.54e2 * t872 - 0.11e2 / 0.648e3 * t147 * t874 * t17 - 0.4e1 * t111 * t33 * t191 * t140 + t884 / 0.6e1 - t30 * t897 + 0.24e2 * t27 * t900 * t902 + 0.6e1 * t169 * t905
  t915 = 0.12112784639430467767200492901320268631311685624314e-3 * t204 * t41 * t16 * t48 + 0.12112784639430467767200492901320268631311685624314e-3 * t42 * t37 * t48 + 0.47129772651883579472964658244599656881154093130267e0 * t212 * t121 * t635 * t70 - 0.41238551070398132038844075964024699771009831488983e0 * t218 * t33 * t738 * t70 - 0.14804514559303905048800602434946994993825393540828e-3 * t43 * t160 - 0.37129640917784654580181051383469886637668330434323e3 * t85 * t733 * t93 - 0.19441031218901976532597921525897358463476063416234e0 * t323 * t733 * t324 + 0.17673664744456342302361746841724871330432784923849e-1 * t298 * t2 * t635 * t70 * t54 * t632 + 0.96902277115443742137603943210562149050493484994510e-3 * t208 * t181 + 0.29070683134633122641281182963168644715148045498353e-2 * t185 * t37 + 0.96902277115443742137603943210562149050493484994510e-3 * (t849 + t908) * t184 * t16 + 0.29070683134633122641281182963168644715148045498353e-2 * t205 * t140
  t953 = 0.70e2 / 0.81e2 * t844 + 0.28e2 / 0.27e2 * t872 + 0.4e1 / 0.3e1 * t884 - 0.2e1 / 0.3e1 * t868 + 0.2e1 * t103 * t22 * t164 * t166 - 0.2e1 * t103 * t238 * t170 + t103 * t242 * t181 / 0.3e1 + 0.6e1 * t103 * t8 * t900 * t902 - 0.9e1 * t103 * t246 * t860 + 0.3e1 / 0.2e1 * t103 * t250 * t905 + 0.2e1 * t103 * t250 * t857 - t103 * t254 * t897 / 0.4e1
  t984 = 0.31090700000000000000000000000000000000000000000001e-1 * t278 * t294 + 0.31090700000000000000000000000000000000000000000001e-1 * t261 * t279 + 0.64601518076962494758402628807041432700328989996342e-3 * t76 * t16 * t153 + 0.10363566666666666666666666666666666666666666666667e-1 * t953 * t54 * t260 * t263 + 0.20435174860777645787105769785744382475812907568201e0 * t315 * t738 * t70 * t103 - 0.77340987998746992664586274965084728992118817729523e1 * t298 * t738 * t301 * t103 - 0.69090444444444444444444444444444444444444444444446e-2 * t278 * t311 + 0.38383580246913580246913580246913580246913580246915e-2 * t290 * t195 * t16 + 0.20727133333333333333333333333333333333333333333334e-1 * t278 * t291 - 0.69090444444444444444444444444444444444444444444446e-2 * t290 * t310 * t37 + 0.10363566666666666666666666666666666666666666666667e-1 * t261 * t305 + 0.10363566666666666666666666666666666666666666666667e-1 * t290 * t262 * t181 + 0.10363566666666666666666666666666666666666666666667e-1 * t290 * t59 * t140
  t1032 = 0.11239335477713059191632681978211506190280373325286e-2 * t579 * t534 * t536 * t24 - 0.14985780636950745588843575970948674920373831100381e-2 * t620 * t48 - 0.99905204246338303925623839806324499469158874002539e-3 * t624 * t157 + 0.30715972396278893812459343330735333491889005037766e1 * t519 * t632 * t636 * t523 - 0.14985780636950745588843575970948674920373831100381e-2 * t616 * t48 + 0.45987582308743803622461183496797526186096082279398e-2 * t492 * t632 * t636 * t494 - 0.24016506845914321304132055739789982808387563524773e0 * t500 * t632 * t636 * t502 + 0.12488150530792287990702979975790562433644859250317e-3 * t477 / t478 / t469 * t383 * t54 * t678 + 0.13796274692623141086738355049039257855828824683819e0 * t364 * t685 * t690 * t368 * t1 * t33 + 0.11655607162072802124656114644071191604735201966963e-2 * t537 * t160 + 0.15610188163490359988378724969738203042056074062897e-4 * t480 * t383 * t1 * t651 + 0.74928903184753727944217879854743374601869155501904e-3 * t615 * t623 * t196
  t1088 = 0.74928903184753727944217879854743374601869155501904e-3 * t535 * t392 * t118 * t196 + 0.22478670955426118383265363956423012380560746650571e-2 * t615 * t619 * t24 + 0.11239335477713059191632681978211506190280373325286e-2 * t535 * t401 * t19 * t24 + 0.28098338694282647979081704945528765475700933313214e-3 * t480 * t392 * t48 - 0.20234536215847273593882920738590911521882276202934e0 * t493 * t733 * t494 + 0.18395032923497521448984473398719010474438432911759e-1 * t374 * t2 * t635 * t368 * t54 * t632 - 0.16468461837198391751404838221570273925751472131273e1 / t372 / t484 * t2 * t635 * t378 * t54 * t632 + 0.46073958594418340718689014996103000237833507556650e2 / t517 / t362 * t2 * t635 * t522 * t54 * t632 + 0.10567263012202301373818104525507592435690527950900e2 * t501 * t733 * t502 - 0.13515027854362713277482111065523546736431162216617e3 * t520 * t733 * t523 - 0.34342413959678791974433194933424046692523362938372e-3 * t481 * t160 + 0.49053421129326723863958595729917361265169154431359e0 * t604 * t121 * t635 * t368 - 0.42921743488160883380963771263677691107023010127437e0 * t610 * t33 * t738 * t368
  t1100 = t377 ** 2
  t1124 = t4 * t739 * t384
  t1128 = t103 * t98 * t389 * t392
  t1132 = t103 * t46 * t416 * t418
  t1135 = t103 * t434 * t401
  t1148 = 0.1e1 / t445 / t383
  t1150 = t418 ** 2
  t1154 = t418 * t401
  t1158 = t401 ** 2
  t1162 = t392 * t459
  t1170 = t886 - 0.19612277777777777777777777777777777777777777777777e1 * t888 + 0.18827786666666666666666666666666666666666666666666e2 * t840 - 0.69732543209876543209876543209876543209876543209875e1 * t892 + 0.61015975308641975308641975308641975308641975308640e1 * t895
  t1174 = 0.70e2 / 0.81e2 * t1124 + 0.28e2 / 0.27e2 * t1128 + 0.4e1 / 0.3e1 * t1132 - 0.2e1 / 0.3e1 * t1135 + 0.2e1 * t103 * t22 * t446 * t448 - 0.2e1 * t103 * t438 * t452 + t103 * t411 * t459 / 0.3e1 + 0.6e1 * t103 * t8 * t1148 * t1150 - 0.9e1 * t103 * t447 * t1154 + 0.3e1 / 0.2e1 * t103 * t417 * t1158 + 0.2e1 * t103 * t417 * t1162 - t103 * t390 * t1170 / 0.4e1
  t1186 = -0.16862113513206061328235767282159092934901896835780e-1 * t506 * t739 * t507 + 0.37740225043579647763636087591098544413180456967501e0 * t511 * t739 * t512 - 0.41248484411876216403621151040619215743173669759529e3 / t517 / t484 * t2 * t635 / t1100 * t54 * t632 + 0.28098338694282647979081704945528765475700933313214e-3 * t596 * t479 * t383 * t48 + 0.10363566666666666666666666666666666666666666666667e-1 * t427 * t405 + 0.21269256817794009175388297367268855861069438054221e0 * t485 * t738 * t368 * t103 - 0.47604147498151601156404610484226573066625349129460e1 * t374 * t738 * t378 * t103 + 0.14985780636950745588843575970948674920373831100381e-2 * t535 * t383 * t153 + 0.51817833333333333333333333333333333333333333333333e-2 * t1174 * t54 * t260 * t466 + 0.15545350000000000000000000000000000000000000000000e-1 * t465 * t428 + 0.51817833333333333333333333333333333333333333333333e-2 * t465 * t530 - 0.34545222222222222222222222222222222222222222222222e-2 * t398 * t310 * t392
  t1266 = 0.8e1 / 0.3e1 * t543 * t33 * t46 * t418 - 0.16e2 / 0.9e1 * t548 * t121 * t88 * t392 + 0.56e2 / 0.27e2 * t553 * t33 * t98 * t392 + 0.4e1 * t469 * t446 * t32 * t33 * t22 * t448 - 0.4e1 / 0.3e1 * t542 * t119 * t121 * t123 * t418 + 0.2e1 / 0.3e1 * t548 * t121 * t123 * t401 - 0.4e1 / 0.3e1 * t553 * t33 * t46 * t401 + 0.2e1 / 0.3e1 * t553 * t33 * t22 * t459 - 0.5e1 / 0.9e1 * t470 * t816 * t819 + 0.140e3 / 0.81e2 * t471 * t846 - 0.160e3 / 0.81e2 * t567 * t854 - t147 * t148 * t389 * t392 / 0.108e3
  t1294 = 0.8e1 / 0.3e1 * t547 * t63 * t67 * t392 - 0.11e2 / 0.648e3 * t147 * t874 * t384 + t1132 / 0.6e1 + 0.11e2 / 0.54e2 * t1128 - t1135 / 0.12e2 - 0.4e1 * t543 * t33 * t585 * t401 - 0.36e2 * t572 * t1154 + 0.8e1 * t575 * t1162 + 0.16e2 / 0.3e1 * t470 * t840 + 0.185e3 / 0.864e3 * t1124 - t475 * t1170 + 0.24e2 * t474 * t1148 * t1150 + 0.6e1 * t575 * t1158
  t1303 = -0.34545222222222222222222222222222222222222222222222e-2 * t427 * t527 + 0.19191790123456790123456790123456790123456790123457e-2 * t398 * t195 * t383 + 0.15545350000000000000000000000000000000000000000000e-1 * t427 * t402 + 0.51817833333333333333333333333333333333333333333333e-2 * t398 * t262 * t459 + 0.51817833333333333333333333333333333333333333333333e-2 * t398 * t59 * t401 - 0.13244423704918215443268820847077687541595671696467e1 * t365 * t706 * t368 - 0.28819808215097185564958466887747979370065076229728e1 * t499 * t2 * t705 * t378 * t118 + 0.36859166875534672574951211996882400190266806045320e2 * t518 * t2 * t705 * t522 * t118 + 0.55185098770492564346953420196157031423315298735276e-1 * t491 * t2 * t705 * t368 * t118 + 0.67436012866278355149796091869269037141682239951713e-2 * t581 * t392 + 0.22478670955426118383265363956423012380560746650571e-2 * (t1266 + t1294) * t580 * t383 + 0.22478670955426118383265363956423012380560746650571e-2 * t600 * t459 + 0.67436012866278355149796091869269037141682239951713e-2 * t597 * t401
  v4rho4_0_ = 0.4e1 * (t235 + t346) * t359 + 0.4e1 * (t516 + t627) * t353 * t357 + r0 * ((t698 + t764 + t915 + t984) * t359 + (t1032 + t1088 + t1186 + t1303) * t353 * t357)

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t12 = 0.1e1 / t8
  t13 = t6 * t12
  t14 = t4 * t13
  t15 = t14 / 0.4e1
  t16 = jnp.sqrt(t14)
  t18 = t15 + 0.18637200000000000000000000000000000000000000000000e1 * t16 + 0.129352e2
  t19 = 0.1e1 / t18
  t23 = t4 * t6
  t24 = t18 ** 2
  t25 = 0.1e1 / t24
  t26 = t12 * t25
  t27 = t4 * t11
  t28 = t27 / 0.12e2
  t29 = 0.1e1 / t16
  t30 = t29 * t1
  t31 = t3 * t6
  t33 = t30 * t31 * t10
  t35 = -t28 - 0.31062000000000000000000000000000000000000000000000e0 * t33
  t40 = t1 ** 2
  t42 = 0.1e1 / t3
  t43 = (-t4 * t11 * t19 / 0.12e2 - t23 * t26 * t35 / 0.4e1) * t40 * t42
  t44 = t5 * t8
  t45 = t44 * t18
  t48 = t16 + 0.372744e1
  t49 = t48 ** 2
  t50 = 0.1e1 / t49
  t52 = t50 * t29 * t1
  t54 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t50
  t55 = 0.1e1 / t54
  t60 = t16 / 0.2e1
  t61 = t60 + 0.10498e0
  t62 = t61 * t19
  t63 = t62 * t29
  t66 = t61 ** 2
  t67 = t66 * t25
  t69 = -t63 * t27 / 0.6e1 - t67 * t35
  t70 = 0.1e1 / t66
  t71 = t69 * t70
  t74 = 0.10363566666666666666666666666666666666666666666667e-1 * t43 * t45 + 0.39765745675026770180313930393880960493473766078662e-1 * t52 * t31 * t10 * t55 + 0.96902277115443742137603943210562149050493484994510e-3 * t71 * t18
  t75 = r0 - r1
  t76 = 0.1e1 / t7
  t77 = t75 * t76
  t78 = 0.1e1 + t77
  t79 = t78 <= f.p.zeta_threshold
  t80 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t81 = t80 * f.p.zeta_threshold
  t82 = t78 ** (0.1e1 / 0.3e1)
  t84 = f.my_piecewise3(t79, t81, t82 * t78)
  t85 = 0.1e1 - t77
  t86 = t85 <= f.p.zeta_threshold
  t87 = t85 ** (0.1e1 / 0.3e1)
  t89 = f.my_piecewise3(t86, t81, t87 * t85)
  t90 = t84 + t89 - 0.2e1
  t91 = 2 ** (0.1e1 / 0.3e1)
  t94 = 0.1e1 / (0.2e1 * t91 - 0.2e1)
  t96 = -t90 * t94 + 0.1e1
  t98 = 0.2e1 * t74 * t96
  t102 = jnp.log(t4 * t13 * t19 / 0.4e1)
  t106 = jnp.arctan(0.61519908197590802321728722658814145360143502774884e1 / t48)
  t109 = jnp.log(t66 * t19)
  t111 = 0.310907e-1 * t102 + 0.38783294878113014394824731224995739188004877421366e-1 * t106 + 0.96902277115443742137603943210562149050493484994510e-3 * t109
  t112 = t7 ** 2
  t113 = 0.1e1 / t112
  t114 = t75 * t113
  t115 = t76 - t114
  t118 = f.my_piecewise3(t79, 0, 0.4e1 / 0.3e1 * t82 * t115)
  t119 = -t115
  t122 = f.my_piecewise3(t86, 0, 0.4e1 / 0.3e1 * t87 * t119)
  t123 = t118 + t122
  t125 = t111 * t123 * t94
  t128 = t15 + 0.35302100000000000000000000000000000000000000000000e1 * t16 + 0.180578e2
  t129 = 0.1e1 / t128
  t133 = t128 ** 2
  t134 = 0.1e1 / t133
  t135 = t12 * t134
  t137 = -t28 - 0.58836833333333333333333333333333333333333333333333e0 * t33
  t143 = (-t4 * t11 * t129 / 0.12e2 - t23 * t135 * t137 / 0.4e1) * t40 * t42
  t144 = t44 * t128
  t147 = t16 + 0.706042e1
  t148 = t147 ** 2
  t149 = 0.1e1 / t148
  t151 = t149 * t29 * t1
  t153 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t149
  t154 = 0.1e1 / t153
  t159 = t60 + 0.32500e0
  t160 = t159 * t129
  t161 = t160 * t29
  t164 = t159 ** 2
  t165 = t164 * t134
  t167 = -t161 * t27 / 0.6e1 - t165 * t137
  t168 = 0.1e1 / t164
  t169 = t167 * t168
  t172 = 0.51817833333333333333333333333333333333333333333333e-2 * t143 * t144 + 0.41388824077869423260215065147117773567486474051458e-1 * t151 * t31 * t10 * t154 + 0.22478670955426118383265363956423012380560746650571e-2 * t169 * t128
  t175 = 0.2e1 * t172 * t90 * t94
  t179 = jnp.log(t4 * t13 * t129 / 0.4e1)
  t183 = jnp.arctan(0.47309269095601128299619512910246923284397083311420e1 / t147)
  t186 = jnp.log(t164 * t129)
  t188 = 0.1554535e-1 * t179 + 0.52491393169780936217021346072241076933841385384497e-1 * t183 + 0.22478670955426118383265363956423012380560746650571e-2 * t186
  t190 = t188 * t123 * t94
  t193 = 0.1e1 / t8 / t112
  t194 = t6 * t193
  t196 = t4 * t194 * t19
  t203 = 0.1e1 / t24 / t18
  t205 = t35 ** 2
  t209 = t4 * t194
  t210 = t209 / 0.9e1
  t212 = 0.1e1 / t16 / t14
  t214 = t3 ** 2
  t215 = t214 * t5
  t216 = t8 ** 2
  t218 = 0.1e1 / t216 / t112
  t220 = t212 * t40 * t215 * t218
  t223 = t30 * t31 * t193
  t225 = t210 - 0.20708000000000000000000000000000000000000000000000e0 * t220 + 0.41416000000000000000000000000000000000000000000000e0 * t223
  t235 = t5 / t216
  t259 = t49 ** 2
  t264 = t54 ** 2
  t279 = t40 * t214 * t5 * t218
  t302 = (0.10363566666666666666666666666666666666666666666667e-1 * (t196 / 0.9e1 + t23 * t10 * t25 * t35 / 0.6e1 + t23 * t12 * t203 * t205 / 0.2e1 - t23 * t26 * t225 / 0.4e1) * t40 * t42 * t45 + 0.34545222222222222222222222222222222222222222222223e-2 * t43 * t235 * t18 + 0.10363566666666666666666666666666666666666666666667e-1 * t43 * t44 * t35 + 0.13255248558342256726771310131293653497824588692887e-1 / t49 / t48 * t1 * t3 * t194 * t55 + 0.26510497116684513453542620262587306995649177385775e-1 * t50 * t212 * t40 * t215 * t218 * t55 - 0.53020994233369026907085240525174613991298354771549e-1 * t52 * t31 * t193 * t55 - 0.50167127350538589836488394571946851238131125013746e0 / t259 / t48 * t1 * t3 * t194 / t264 + 0.96902277115443742137603943210562149050493484994510e-3 * (t196 / 0.72e2 + t61 * t25 * t30 * t31 * t10 * t35 / 0.3e1 - t62 * t212 * t279 / 0.9e1 + 0.2e1 / 0.9e1 * t63 * t209 + 0.2e1 * t66 * t203 * t205 - t67 * t225) * t70 * t18 + 0.16150379519240623689600657201760358175082247499085e-3 * t69 / t66 / t61 * t18 * t29 * t27 + 0.96902277115443742137603943210562149050493484994510e-3 * t71 * t35) * t96
  t304 = t74 * t123 * t94
  t306 = t82 ** 2
  t307 = 0.1e1 / t306
  t308 = t115 ** 2
  t312 = 0.1e1 / t112 / t7
  t313 = t75 * t312
  t315 = -0.2e1 * t113 + 0.2e1 * t313
  t319 = f.my_piecewise3(t79, 0, 0.4e1 / 0.9e1 * t307 * t308 + 0.4e1 / 0.3e1 * t82 * t315)
  t320 = t87 ** 2
  t321 = 0.1e1 / t320
  t322 = t119 ** 2
  t329 = f.my_piecewise3(t86, 0, 0.4e1 / 0.9e1 * t321 * t322 - 0.4e1 / 0.3e1 * t87 * t315)
  t330 = t319 + t329
  t334 = t4 * t194 * t129
  t341 = 0.1e1 / t133 / t128
  t343 = t137 ** 2
  t349 = t210 - 0.39224555555555555555555555555555555555555555555555e0 * t220 + 0.78449111111111111111111111111111111111111111111110e0 * t223
  t381 = t148 ** 2
  t386 = t153 ** 2
  t422 = (0.51817833333333333333333333333333333333333333333333e-2 * (t334 / 0.9e1 + t23 * t10 * t134 * t137 / 0.6e1 + t23 * t12 * t341 * t343 / 0.2e1 - t23 * t135 * t349 / 0.4e1) * t40 * t42 * t144 + 0.17272611111111111111111111111111111111111111111111e-2 * t143 * t235 * t128 + 0.51817833333333333333333333333333333333333333333333e-2 * t143 * t44 * t137 + 0.13796274692623141086738355049039257855828824683819e-1 / t148 / t147 * t1 * t3 * t194 * t154 + 0.27592549385246282173476710098078515711657649367639e-1 * t149 * t212 * t40 * t215 * t218 * t154 - 0.55185098770492564346953420196157031423315298735277e-1 * t151 * t31 * t193 * t154 - 0.30878365944746984533884071665444263610784010246137e0 / t381 / t147 * t1 * t3 * t194 / t386 + 0.22478670955426118383265363956423012380560746650571e-2 * (t334 / 0.72e2 + t159 * t134 * t30 * t31 * t10 * t137 / 0.3e1 - t160 * t212 * t279 / 0.9e1 + 0.2e1 / 0.9e1 * t161 * t209 + 0.2e1 * t164 * t341 * t343 - t165 * t349) * t168 * t128 + 0.37464451592376863972108939927371687300934577750952e-3 * t167 / t164 / t159 * t128 * t29 * t27 + 0.22478670955426118383265363956423012380560746650571e-2 * t169 * t137) * t90 * t94
  t424 = t172 * t123 * t94
  d11 = t98 - 0.2e1 * t125 + t175 + 0.2e1 * t190 + t7 * (-t111 * t330 * t94 + t188 * t330 * t94 + t302 - 0.2e1 * t304 + t422 + 0.2e1 * t424)
  t430 = -t76 - t114
  t433 = f.my_piecewise3(t79, 0, 0.4e1 / 0.3e1 * t82 * t430)
  t434 = -t430
  t437 = f.my_piecewise3(t86, 0, 0.4e1 / 0.3e1 * t87 * t434)
  t438 = t433 + t437
  t440 = t111 * t438 * t94
  t442 = t188 * t438 * t94
  t444 = t74 * t438 * t94
  t452 = f.my_piecewise3(t79, 0, 0.4e1 / 0.9e1 * t307 * t430 * t115 + 0.8e1 / 0.3e1 * t82 * t75 * t312)
  t460 = f.my_piecewise3(t86, 0, 0.4e1 / 0.9e1 * t321 * t434 * t119 - 0.8e1 / 0.3e1 * t87 * t75 * t312)
  t461 = t452 + t460
  t465 = t172 * t438 * t94
  d12 = t98 - t125 + t175 + t190 - t440 + t442 + t7 * (-t111 * t461 * t94 + t188 * t461 * t94 + t302 - t304 + t422 + t424 - t444 + t465)
  t473 = t430 ** 2
  t477 = 0.2e1 * t113 + 0.2e1 * t313
  t481 = f.my_piecewise3(t79, 0, 0.4e1 / 0.9e1 * t307 * t473 + 0.4e1 / 0.3e1 * t82 * t477)
  t482 = t434 ** 2
  t489 = f.my_piecewise3(t86, 0, 0.4e1 / 0.9e1 * t321 * t482 - 0.4e1 / 0.3e1 * t87 * t477)
  t490 = t481 + t489
  d22 = t98 - 0.2e1 * t440 + t175 + 0.2e1 * t442 + t7 * (-t111 * t490 * t94 + t188 * t490 * t94 + t302 + t422 - 0.2e1 * t444 + 0.2e1 * t465)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** 2
  t9 = t7 ** (0.1e1 / 0.3e1)
  t11 = 0.1e1 / t9 / t8
  t12 = t6 * t11
  t13 = 0.1e1 / t9
  t14 = t6 * t13
  t15 = t4 * t14
  t16 = t15 / 0.4e1
  t17 = jnp.sqrt(t15)
  t19 = t16 + 0.18637200000000000000000000000000000000000000000000e1 * t17 + 0.129352e2
  t20 = 0.1e1 / t19
  t22 = t4 * t12 * t20
  t24 = t4 * t6
  t26 = 0.1e1 / t9 / t7
  t27 = t19 ** 2
  t28 = 0.1e1 / t27
  t29 = t26 * t28
  t30 = t6 * t26
  t31 = t4 * t30
  t32 = t31 / 0.12e2
  t33 = 0.1e1 / t17
  t34 = t33 * t1
  t35 = t3 * t6
  t37 = t34 * t35 * t26
  t39 = -t32 - 0.31062000000000000000000000000000000000000000000000e0 * t37
  t44 = 0.1e1 / t27 / t19
  t45 = t13 * t44
  t46 = t39 ** 2
  t50 = t13 * t28
  t51 = t4 * t12
  t52 = t51 / 0.9e1
  t54 = 0.1e1 / t17 / t15
  t55 = t1 ** 2
  t56 = t54 * t55
  t57 = t3 ** 2
  t58 = t57 * t5
  t59 = t9 ** 2
  t61 = 0.1e1 / t59 / t8
  t63 = t56 * t58 * t61
  t66 = t34 * t35 * t11
  t68 = t52 - 0.20708000000000000000000000000000000000000000000000e0 * t63 + 0.41416000000000000000000000000000000000000000000000e0 * t66
  t74 = 0.1e1 / t3
  t75 = (t22 / 0.9e1 + t24 * t29 * t39 / 0.6e1 + t24 * t45 * t46 / 0.2e1 - t24 * t50 * t68 / 0.4e1) * t55 * t74
  t76 = t5 * t9
  t77 = t76 * t19
  t88 = (-t4 * t30 * t20 / 0.12e2 - t24 * t50 * t39 / 0.4e1) * t55 * t74
  t90 = t5 / t59
  t91 = t90 * t19
  t94 = t76 * t39
  t97 = t17 + 0.372744e1
  t98 = t97 ** 2
  t101 = 0.1e1 / t98 / t97 * t1
  t102 = t101 * t3
  t103 = 0.1e1 / t98
  t105 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t103
  t106 = 0.1e1 / t105
  t111 = t103 * t54 * t55
  t117 = t103 * t33 * t1
  t122 = t98 ** 2
  t125 = 0.1e1 / t122 / t97 * t1
  t126 = t125 * t3
  t127 = t105 ** 2
  t128 = 0.1e1 / t127
  t133 = t17 / 0.2e1
  t134 = t133 + 0.10498e0
  t135 = t134 * t28
  t136 = t135 * t34
  t141 = t134 * t20
  t142 = t141 * t54
  t143 = t55 * t57
  t145 = t143 * t5 * t61
  t148 = t141 * t33
  t151 = t134 ** 2
  t152 = t151 * t44
  t155 = t151 * t28
  t157 = t22 / 0.72e2 + t136 * t35 * t26 * t39 / 0.3e1 - t142 * t145 / 0.9e1 + 0.2e1 / 0.9e1 * t148 * t51 + 0.2e1 * t152 * t46 - t155 * t68
  t158 = 0.1e1 / t151
  t159 = t157 * t158
  t165 = -t148 * t31 / 0.6e1 - t155 * t39
  t167 = 0.1e1 / t151 / t134
  t168 = t165 * t167
  t169 = t19 * t33
  t170 = t168 * t169
  t173 = t165 * t158
  t176 = 0.10363566666666666666666666666666666666666666666667e-1 * t75 * t77 + 0.34545222222222222222222222222222222222222222222223e-2 * t88 * t91 + 0.10363566666666666666666666666666666666666666666667e-1 * t88 * t94 + 0.13255248558342256726771310131293653497824588692887e-1 * t102 * t12 * t106 + 0.26510497116684513453542620262587306995649177385775e-1 * t111 * t58 * t61 * t106 - 0.53020994233369026907085240525174613991298354771549e-1 * t117 * t35 * t11 * t106 - 0.50167127350538589836488394571946851238131125013746e0 * t126 * t12 * t128 + 0.96902277115443742137603943210562149050493484994510e-3 * t159 * t19 + 0.16150379519240623689600657201760358175082247499085e-3 * t170 * t31 + 0.96902277115443742137603943210562149050493484994510e-3 * t173 * t39
  t177 = r0 - r1
  t178 = 0.1e1 / t7
  t179 = t177 * t178
  t180 = 0.1e1 + t179
  t181 = t180 <= f.p.zeta_threshold
  t182 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t183 = t182 * f.p.zeta_threshold
  t184 = t180 ** (0.1e1 / 0.3e1)
  t186 = f.my_piecewise3(t181, t183, t184 * t180)
  t187 = 0.1e1 - t179
  t188 = t187 <= f.p.zeta_threshold
  t189 = t187 ** (0.1e1 / 0.3e1)
  t191 = f.my_piecewise3(t188, t183, t189 * t187)
  t192 = t186 + t191 - 0.2e1
  t193 = 2 ** (0.1e1 / 0.3e1)
  t196 = 0.1e1 / (0.2e1 * t193 - 0.2e1)
  t198 = -t192 * t196 + 0.1e1
  t209 = 0.10363566666666666666666666666666666666666666666667e-1 * t88 * t77 + 0.39765745675026770180313930393880960493473766078662e-1 * t117 * t35 * t26 * t106 + 0.96902277115443742137603943210562149050493484994510e-3 * t173 * t19
  t210 = 0.1e1 / t8
  t212 = -t177 * t210 + t178
  t215 = f.my_piecewise3(t181, 0, 0.4e1 / 0.3e1 * t184 * t212)
  t216 = -t212
  t219 = f.my_piecewise3(t188, 0, 0.4e1 / 0.3e1 * t189 * t216)
  t220 = t215 + t219
  t227 = jnp.log(t4 * t14 * t20 / 0.4e1)
  t231 = jnp.atan(0.61519908197590802321728722658814145360143502774884e1 / t97)
  t234 = jnp.log(t151 * t20)
  t236 = 0.310907e-1 * t227 + 0.38783294878113014394824731224995739188004877421366e-1 * t231 + 0.96902277115443742137603943210562149050493484994510e-3 * t234
  t237 = t184 ** 2
  t238 = 0.1e1 / t237
  t239 = t212 ** 2
  t242 = t8 * t7
  t243 = 0.1e1 / t242
  t246 = 0.2e1 * t177 * t243 - 0.2e1 * t210
  t250 = f.my_piecewise3(t181, 0, 0.4e1 / 0.9e1 * t238 * t239 + 0.4e1 / 0.3e1 * t184 * t246)
  t251 = t189 ** 2
  t252 = 0.1e1 / t251
  t253 = t216 ** 2
  t256 = -t246
  t260 = f.my_piecewise3(t188, 0, 0.4e1 / 0.9e1 * t252 * t253 + 0.4e1 / 0.3e1 * t189 * t256)
  t261 = t250 + t260
  t266 = t16 + 0.35302100000000000000000000000000000000000000000000e1 * t17 + 0.180578e2
  t267 = 0.1e1 / t266
  t269 = t4 * t12 * t267
  t271 = t266 ** 2
  t272 = 0.1e1 / t271
  t273 = t26 * t272
  t275 = -t32 - 0.58836833333333333333333333333333333333333333333333e0 * t37
  t280 = 0.1e1 / t271 / t266
  t281 = t13 * t280
  t282 = t275 ** 2
  t286 = t13 * t272
  t289 = t52 - 0.39224555555555555555555555555555555555555555555555e0 * t63 + 0.78449111111111111111111111111111111111111111111110e0 * t66
  t295 = (t269 / 0.9e1 + t24 * t273 * t275 / 0.6e1 + t24 * t281 * t282 / 0.2e1 - t24 * t286 * t289 / 0.4e1) * t55 * t74
  t296 = t76 * t266
  t307 = (-t4 * t30 * t267 / 0.12e2 - t24 * t286 * t275 / 0.4e1) * t55 * t74
  t308 = t90 * t266
  t311 = t76 * t275
  t314 = t17 + 0.706042e1
  t315 = t314 ** 2
  t318 = 0.1e1 / t315 / t314 * t1
  t319 = t318 * t3
  t320 = 0.1e1 / t315
  t322 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t320
  t323 = 0.1e1 / t322
  t328 = t320 * t54 * t55
  t334 = t320 * t33 * t1
  t339 = t315 ** 2
  t342 = 0.1e1 / t339 / t314 * t1
  t343 = t342 * t3
  t344 = t322 ** 2
  t345 = 0.1e1 / t344
  t350 = t133 + 0.32500e0
  t351 = t350 * t272
  t352 = t351 * t34
  t357 = t350 * t267
  t358 = t357 * t54
  t361 = t357 * t33
  t364 = t350 ** 2
  t365 = t364 * t280
  t368 = t364 * t272
  t370 = t269 / 0.72e2 + t352 * t35 * t26 * t275 / 0.3e1 - t358 * t145 / 0.9e1 + 0.2e1 / 0.9e1 * t361 * t51 + 0.2e1 * t365 * t282 - t368 * t289
  t371 = 0.1e1 / t364
  t372 = t370 * t371
  t378 = -t361 * t31 / 0.6e1 - t368 * t275
  t380 = 0.1e1 / t364 / t350
  t381 = t378 * t380
  t382 = t266 * t33
  t383 = t381 * t382
  t386 = t378 * t371
  t389 = 0.51817833333333333333333333333333333333333333333333e-2 * t295 * t296 + 0.17272611111111111111111111111111111111111111111111e-2 * t307 * t308 + 0.51817833333333333333333333333333333333333333333333e-2 * t307 * t311 + 0.13796274692623141086738355049039257855828824683819e-1 * t319 * t12 * t323 + 0.27592549385246282173476710098078515711657649367639e-1 * t328 * t58 * t61 * t323 - 0.55185098770492564346953420196157031423315298735277e-1 * t334 * t35 * t11 * t323 - 0.30878365944746984533884071665444263610784010246137e0 * t343 * t12 * t345 + 0.22478670955426118383265363956423012380560746650571e-2 * t372 * t266 + 0.37464451592376863972108939927371687300934577750952e-3 * t383 * t31 + 0.22478670955426118383265363956423012380560746650571e-2 * t386 * t275
  t401 = 0.51817833333333333333333333333333333333333333333333e-2 * t307 * t296 + 0.41388824077869423260215065147117773567486474051458e-1 * t334 * t35 * t26 * t323 + 0.22478670955426118383265363956423012380560746650571e-2 * t386 * t266
  t408 = jnp.log(t4 * t14 * t267 / 0.4e1)
  t412 = jnp.atan(0.47309269095601128299619512910246923284397083311420e1 / t314)
  t415 = jnp.log(t364 * t267)
  t417 = 0.1554535e-1 * t408 + 0.52491393169780936217021346072241076933841385384497e-1 * t412 + 0.22478670955426118383265363956423012380560746650571e-2 * t415
  t424 = 0.1e1 / t17 / t143 / t90 / 0.4e1
  t426 = t8 ** 2
  t427 = 0.1e1 / t426
  t428 = t2 * t427
  t433 = 0.1e1 / t9 / t242
  t434 = t6 * t433
  t447 = t4 * t434 * t20
  t451 = t24 * t11 * t28 * t39
  t460 = t27 ** 2
  t461 = 0.1e1 / t460
  t463 = t46 * t39
  t467 = t39 * t68
  t471 = t4 * t434
  t472 = 0.7e1 / 0.27e2 * t471
  t474 = t424 * t2 * t427
  t477 = 0.1e1 / t59 / t242
  t479 = t56 * t58 * t477
  t482 = t34 * t35 * t433
  t484 = -t472 - 0.12424800000000000000000000000000000000000000000000e1 * t474 + 0.82832000000000000000000000000000000000000000000000e0 * t479 - 0.96637333333333333333333333333333333333333333333333e0 * t482
  t495 = t151 ** 2
  t507 = t5 * t477
  t520 = 0.1e1 / t57
  t526 = 0.15906298270010708072125572157552384197389506431465e0 * t103 * t424 * t428 * t106 + 0.18394613361864149606712411343047178787314745838373e1 * t126 * t434 * t128 + 0.10363566666666666666666666666666666666666666666667e-1 * t88 * t76 * t68 + 0.69090444444444444444444444444444444444444444444446e-2 * t88 * t90 * t39 + 0.20727133333333333333333333333333333333333333333334e-1 * t75 * t94 + 0.10363566666666666666666666666666666666666666666667e-1 * (-0.7e1 / 0.27e2 * t447 - t451 / 0.3e1 - t24 * t26 * t44 * t46 / 0.2e1 + t24 * t29 * t68 / 0.4e1 - 0.3e1 / 0.2e1 * t24 * t13 * t461 * t463 + 0.3e1 / 0.2e1 * t24 * t45 * t467 - t24 * t50 * t484 / 0.4e1) * t55 * t74 * t77 - 0.21533839358987498252800876269013810900109663332113e-3 * t170 * t51 + 0.40375948798101559224001643004400895437705618747712e-4 * t165 / t495 * t19 * t51 - 0.48602578047254941331494803814743396158690158540586e-1 * t102 * t434 * t106 + 0.26510497116684513453542620262587306995649177385774e-1 / t122 * t55 * t57 * t507 * t106 * t33 - 0.23411326096918008590361250800241863911127858339748e1 / t122 / t98 * t55 * t57 * t507 * t128 * t33 + 0.22092080930570427877952183552156089163040981154812e-2 * t101 * t520 * t434 * t2 * t106
  t532 = t122 ** 2
  t546 = t5 / t59 / t7
  t571 = t1 * t520 * t6
  t572 = t433 * t2
  t578 = t143 * t507
  t589 = -0.11e2 / 0.216e3 * t447 - t451 / 0.24e2 - t134 * t44 * t34 * t35 * t26 * t46 + t135 * t56 * t58 * t61 * t39 / 0.3e1 - 0.2e1 / 0.3e1 * t136 * t35 * t11 * t39 + t136 * t35 * t26 * t68 / 0.2e1 + t571 * t572 * t20 / 0.432e3 - 0.2e1 / 0.3e1 * t141 * t474 + 0.4e1 / 0.9e1 * t142 * t578 - 0.14e2 / 0.27e2 * t148 * t471 - 0.6e1 * t151 * t461 * t463 + 0.6e1 * t152 * t467 - t155 * t484
  t617 = -0.83611878917564316394147324286578085396885208356242e-1 * t125 * t520 * t434 * t2 * t128 + 0.50631328524251801700246888250186209051365905137714e2 / t532 * t55 * t57 * t507 / t127 / t105 * t33 + 0.69090444444444444444444444444444444444444444444446e-2 * t75 * t91 - 0.23030148148148148148148148148148148148148148148149e-2 * t88 * t546 * t19 + 0.96902277115443742137603943210562149050493484994510e-3 * t589 * t158 * t19 + 0.19380455423088748427520788642112429810098696998902e-2 * t159 * t39 + 0.96902277115443742137603943210562149050493484994510e-3 * t173 * t68 - 0.10604198846673805381417048105034922798259670954310e0 * t111 * t58 * t477 * t106 + 0.12371565321119439611653222789207409931302949446695e0 * t117 * t35 * t433 * t106 + 0.32300759038481247379201314403520716350164494998170e-3 * t157 * t167 * t169 * t31 + 0.32300759038481247379201314403520716350164494998170e-3 * t168 * t39 * t33 * t31 + 0.10766919679493749126400438134506905450054831666057e-3 * t168 * t19 * t54 * t145
  t636 = -0.6e1 * t177 * t427 + 0.6e1 * t243
  t640 = f.my_piecewise3(t181, 0, -0.8e1 / 0.27e2 / t237 / t180 * t239 * t212 + 0.4e1 / 0.3e1 * t238 * t212 * t246 + 0.4e1 / 0.3e1 * t184 * t636)
  t653 = f.my_piecewise3(t188, 0, -0.8e1 / 0.27e2 / t251 / t187 * t253 * t216 + 0.4e1 / 0.3e1 * t252 * t216 * t256 - 0.4e1 / 0.3e1 * t189 * t636)
  t654 = t640 + t653
  t673 = t4 * t434 * t267
  t677 = t24 * t11 * t272 * t275
  t686 = t271 ** 2
  t687 = 0.1e1 / t686
  t689 = t282 * t275
  t693 = t275 * t289
  t700 = -t472 - 0.23534733333333333333333333333333333333333333333333e1 * t474 + 0.15689822222222222222222222222222222222222222222222e1 * t479 - 0.18304792592592592592592592592592592592592592592592e1 * t482
  t711 = t364 ** 2
  t740 = 0.11322067513073894329090826277329563323954137090250e1 * t343 * t434 * t345 + 0.16555529631147769304086026058847109426994589620583e0 * t320 * t424 * t428 * t323 + 0.51817833333333333333333333333333333333333333333333e-2 * t307 * t76 * t289 + 0.34545222222222222222222222222222222222222222222222e-2 * t307 * t90 * t275 + 0.10363566666666666666666666666666666666666666666667e-1 * t295 * t311 + 0.51817833333333333333333333333333333333333333333333e-2 * (-0.7e1 / 0.27e2 * t673 - t677 / 0.3e1 - t24 * t26 * t280 * t282 / 0.2e1 + t24 * t273 * t289 / 0.4e1 - 0.3e1 / 0.2e1 * t24 * t13 * t687 * t689 + 0.3e1 / 0.2e1 * t24 * t281 * t693 - t24 * t286 * t700 / 0.4e1) * t55 * t74 * t296 - 0.49952602123169151962811919903162249734579437001269e-3 * t383 * t51 + 0.93661128980942159930272349818429218252336444377380e-4 * t378 / t711 * t266 * t51 - 0.50586340539618183984707301846477278804705690507337e-1 * t319 * t434 * t323 + 0.27592549385246282173476710098078515711657649367638e-1 / t339 * t55 * t57 * t507 * t323 * t33 - 0.14409904107548592782479233443873989685032538114864e1 / t339 / t315 * t55 * t57 * t507 * t345 * t33 + 0.22993791154371901811230591748398763093048041139699e-2 * t318 * t520 * t434 * t2 * t323
  t746 = t339 ** 2
  t796 = -0.11e2 / 0.216e3 * t673 - t677 / 0.24e2 - t350 * t280 * t34 * t35 * t26 * t282 + t351 * t56 * t58 * t61 * t275 / 0.3e1 - 0.2e1 / 0.3e1 * t352 * t35 * t11 * t275 + t352 * t35 * t26 * t289 / 0.2e1 + t571 * t572 * t267 / 0.432e3 - 0.2e1 / 0.3e1 * t357 * t474 + 0.4e1 / 0.9e1 * t358 * t578 - 0.14e2 / 0.27e2 * t361 * t471 - 0.6e1 * t364 * t687 * t689 + 0.6e1 * t365 * t693 - t368 * t700
  t824 = -0.51463943241244974223140119442407106017973350410227e-1 * t342 * t520 * t434 * t2 * t345 + 0.18429583437767336287475605998441200095133403022660e2 / t746 * t55 * t57 * t507 / t344 / t322 * t33 + 0.34545222222222222222222222222222222222222222222222e-2 * t295 * t308 - 0.11515074074074074074074074074074074074074074074074e-2 * t307 * t546 * t266 + 0.22478670955426118383265363956423012380560746650571e-2 * t796 * t371 * t266 + 0.44957341910852236766530727912846024761121493301142e-2 * t372 * t275 + 0.22478670955426118383265363956423012380560746650571e-2 * t386 * t289 - 0.11037019754098512869390684039231406284663059747056e0 * t328 * t58 * t477 * t323 + 0.12876523046448265014289131379103307332106903038231e0 * t334 * t35 * t433 * t323 + 0.74928903184753727944217879854743374601869155501904e-3 * t370 * t380 * t382 * t31 + 0.74928903184753727944217879854743374601869155501904e-3 * t381 * t275 * t33 * t31 + 0.24976301061584575981405959951581124867289718500635e-3 * t381 * t266 * t54 * t145
  d111 = 0.3e1 * t176 * t198 - 0.6e1 * t209 * t220 * t196 - 0.3e1 * t236 * t261 * t196 + 0.3e1 * t389 * t192 * t196 + 0.6e1 * t401 * t220 * t196 + 0.3e1 * t417 * t261 * t196 + t7 * ((t526 + t617) * t198 - 0.3e1 * t176 * t220 * t196 - 0.3e1 * t209 * t261 * t196 - t236 * t654 * t196 + (t740 + t824) * t192 * t196 + 0.3e1 * t389 * t220 * t196 + 0.3e1 * t401 * t261 * t196 + t417 * t654 * t196)

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t8
  t10 = t6 * t9
  t11 = t4 * t10
  t12 = jnp.sqrt(t11)
  t13 = t12 + 0.372744e1
  t14 = t13 ** 2
  t15 = 0.1e1 / t14
  t16 = t1 ** 2
  t17 = t3 ** 2
  t18 = t16 * t17
  t19 = t8 ** 2
  t21 = t5 / t19
  t25 = 0.1e1 / t12 / t18 / t21 / 0.4e1
  t26 = t15 * t25
  t27 = t7 ** 2
  t28 = t27 ** 2
  t29 = 0.1e1 / t28
  t30 = t2 * t29
  t32 = 0.1e1 + 0.37846991046400000000000000000000000000000000000000e2 * t15
  t33 = 0.1e1 / t32
  t37 = t14 ** 2
  t39 = 0.1e1 / t37 / t13
  t40 = t39 * t1
  t41 = t40 * t3
  t42 = t27 * t7
  t44 = 0.1e1 / t8 / t42
  t45 = t6 * t44
  t46 = t32 ** 2
  t47 = 0.1e1 / t46
  t52 = 0.1e1 / t8 / t7
  t53 = t6 * t52
  t54 = t11 / 0.4e1
  t56 = t54 + 0.18637200000000000000000000000000000000000000000000e1 * t12 + 0.129352e2
  t57 = 0.1e1 / t56
  t61 = t4 * t6
  t62 = t56 ** 2
  t63 = 0.1e1 / t62
  t64 = t9 * t63
  t65 = t4 * t53
  t66 = t65 / 0.12e2
  t67 = 0.1e1 / t12
  t68 = t67 * t1
  t69 = t3 * t6
  t71 = t68 * t69 * t52
  t73 = -t66 - 0.31062000000000000000000000000000000000000000000000e0 * t71
  t79 = 0.1e1 / t3
  t80 = (-t4 * t53 * t57 / 0.12e2 - t61 * t64 * t73 / 0.4e1) * t16 * t79
  t81 = t5 * t8
  t83 = 0.1e1 / t8 / t27
  t84 = t6 * t83
  t85 = t4 * t84
  t86 = t85 / 0.9e1
  t88 = 0.1e1 / t12 / t11
  t89 = t88 * t16
  t90 = t17 * t5
  t92 = 0.1e1 / t19 / t27
  t94 = t89 * t90 * t92
  t97 = t68 * t69 * t83
  t99 = t86 - 0.20708000000000000000000000000000000000000000000000e0 * t94 + 0.41416000000000000000000000000000000000000000000000e0 * t97
  t100 = t81 * t99
  t103 = t21 * t73
  t107 = t4 * t84 * t57
  t109 = t52 * t63
  t114 = 0.1e1 / t62 / t56
  t115 = t9 * t114
  t116 = t73 ** 2
  t125 = (t107 / 0.9e1 + t61 * t109 * t73 / 0.6e1 + t61 * t115 * t116 / 0.2e1 - t61 * t64 * t99 / 0.4e1) * t16 * t79
  t126 = t81 * t73
  t130 = t4 * t45 * t57
  t132 = t83 * t63
  t134 = t61 * t132 * t73
  t136 = t52 * t114
  t143 = t62 ** 2
  t144 = 0.1e1 / t143
  t145 = t9 * t144
  t146 = t116 * t73
  t150 = t73 * t99
  t154 = t4 * t45
  t155 = 0.7e1 / 0.27e2 * t154
  t156 = t25 * t2
  t157 = t156 * t29
  t160 = 0.1e1 / t19 / t42
  t162 = t89 * t90 * t160
  t165 = t68 * t69 * t44
  t167 = -t155 - 0.12424800000000000000000000000000000000000000000000e1 * t157 + 0.82832000000000000000000000000000000000000000000000e0 * t162 - 0.96637333333333333333333333333333333333333333333333e0 * t165
  t173 = (-0.7e1 / 0.27e2 * t130 - t134 / 0.3e1 - t61 * t136 * t116 / 0.2e1 + t61 * t109 * t99 / 0.4e1 - 0.3e1 / 0.2e1 * t61 * t145 * t146 + 0.3e1 / 0.2e1 * t61 * t115 * t150 - t61 * t64 * t167 / 0.4e1) * t16 * t79
  t174 = t81 * t56
  t177 = t12 / 0.2e1
  t178 = t177 + 0.10498e0
  t179 = t178 * t57
  t180 = t179 * t67
  t183 = t178 ** 2
  t184 = t183 * t63
  t186 = -t180 * t65 / 0.6e1 - t184 * t73
  t188 = 0.1e1 / t183 / t178
  t189 = t186 * t188
  t190 = t56 * t67
  t191 = t189 * t190
  t194 = t183 ** 2
  t195 = 0.1e1 / t194
  t196 = t186 * t195
  t197 = t196 * t56
  t200 = t14 * t13
  t201 = 0.1e1 / t200
  t202 = t201 * t1
  t203 = t202 * t3
  t207 = 0.1e1 / t37
  t208 = t207 * t16
  t209 = t208 * t17
  t210 = t5 * t160
  t211 = t33 * t67
  t216 = 0.1e1 / t37 / t14
  t217 = t216 * t16
  t218 = t217 * t17
  t219 = t47 * t67
  t223 = 0.1e1 / t17
  t224 = t202 * t223
  t225 = t2 * t33
  t229 = 0.15906298270010708072125572157552384197389506431465e0 * t26 * t30 * t33 + 0.18394613361864149606712411343047178787314745838373e1 * t41 * t45 * t47 + 0.10363566666666666666666666666666666666666666666667e-1 * t80 * t100 + 0.69090444444444444444444444444444444444444444444446e-2 * t80 * t103 + 0.20727133333333333333333333333333333333333333333334e-1 * t125 * t126 + 0.10363566666666666666666666666666666666666666666667e-1 * t173 * t174 - 0.21533839358987498252800876269013810900109663332113e-3 * t191 * t85 + 0.40375948798101559224001643004400895437705618747712e-4 * t197 * t85 - 0.48602578047254941331494803814743396158690158540586e-1 * t203 * t45 * t33 + 0.26510497116684513453542620262587306995649177385774e-1 * t209 * t210 * t211 - 0.23411326096918008590361250800241863911127858339748e1 * t218 * t210 * t219 + 0.22092080930570427877952183552156089163040981154812e-2 * t224 * t45 * t225
  t230 = t40 * t223
  t231 = t2 * t47
  t235 = t37 ** 2
  t236 = 0.1e1 / t235
  t237 = t236 * t16
  t238 = t237 * t17
  t240 = 0.1e1 / t46 / t32
  t241 = t240 * t67
  t245 = t21 * t56
  t250 = t5 / t19 / t7
  t251 = t250 * t56
  t256 = t178 * t114
  t257 = t256 * t68
  t261 = t178 * t63
  t262 = t261 * t89
  t267 = t261 * t68
  t277 = t1 * t223 * t6
  t278 = t44 * t2
  t284 = t179 * t88
  t285 = t18 * t210
  t290 = t183 * t144
  t293 = t183 * t114
  t297 = -0.11e2 / 0.216e3 * t130 - t134 / 0.24e2 - t257 * t69 * t52 * t116 + t262 * t90 * t92 * t73 / 0.3e1 - 0.2e1 / 0.3e1 * t267 * t69 * t83 * t73 + t267 * t69 * t52 * t99 / 0.2e1 + t277 * t278 * t57 / 0.432e3 - 0.2e1 / 0.3e1 * t179 * t157 + 0.4e1 / 0.9e1 * t284 * t285 - 0.14e2 / 0.27e2 * t180 * t154 - 0.6e1 * t290 * t146 + 0.6e1 * t293 * t150 - t184 * t167
  t298 = 0.1e1 / t183
  t299 = t297 * t298
  t303 = t52 * t73
  t307 = t5 * t92
  t308 = t18 * t307
  t316 = t107 / 0.72e2 + t267 * t69 * t303 / 0.3e1 - t284 * t308 / 0.9e1 + 0.2e1 / 0.9e1 * t180 * t85 + 0.2e1 * t293 * t116 - t184 * t99
  t317 = t316 * t298
  t320 = t186 * t298
  t324 = t15 * t88 * t16
  t330 = t15 * t67 * t1
  t335 = t316 * t188
  t336 = t335 * t190
  t339 = t73 * t67
  t340 = t189 * t339
  t343 = t56 * t88
  t344 = t189 * t343
  t347 = -0.83611878917564316394147324286578085396885208356242e-1 * t230 * t45 * t231 + 0.50631328524251801700246888250186209051365905137714e2 * t238 * t210 * t241 + 0.69090444444444444444444444444444444444444444444446e-2 * t125 * t245 - 0.23030148148148148148148148148148148148148148148149e-2 * t80 * t251 + 0.96902277115443742137603943210562149050493484994510e-3 * t299 * t56 + 0.19380455423088748427520788642112429810098696998902e-2 * t317 * t73 + 0.96902277115443742137603943210562149050493484994510e-3 * t320 * t99 - 0.10604198846673805381417048105034922798259670954310e0 * t324 * t90 * t160 * t33 + 0.12371565321119439611653222789207409931302949446695e0 * t330 * t69 * t44 * t33 + 0.32300759038481247379201314403520716350164494998170e-3 * t336 * t65 + 0.32300759038481247379201314403520716350164494998170e-3 * t340 * t65 + 0.10766919679493749126400438134506905450054831666057e-3 * t344 * t308
  t348 = t229 + t347
  t349 = r0 - r1
  t350 = 0.1e1 / t7
  t351 = t349 * t350
  t352 = 0.1e1 + t351
  t353 = t352 <= f.p.zeta_threshold
  t354 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t355 = t354 * f.p.zeta_threshold
  t356 = t352 ** (0.1e1 / 0.3e1)
  t358 = f.my_piecewise3(t353, t355, t356 * t352)
  t359 = 0.1e1 - t351
  t360 = t359 <= f.p.zeta_threshold
  t361 = t359 ** (0.1e1 / 0.3e1)
  t363 = f.my_piecewise3(t360, t355, t361 * t359)
  t364 = t358 + t363 - 0.2e1
  t365 = 2 ** (0.1e1 / 0.3e1)
  t368 = 0.1e1 / (0.2e1 * t365 - 0.2e1)
  t370 = -t364 * t368 + 0.1e1
  t399 = 0.10363566666666666666666666666666666666666666666667e-1 * t125 * t174 + 0.34545222222222222222222222222222222222222222222223e-2 * t80 * t245 + 0.10363566666666666666666666666666666666666666666667e-1 * t80 * t126 + 0.13255248558342256726771310131293653497824588692887e-1 * t203 * t84 * t33 + 0.26510497116684513453542620262587306995649177385775e-1 * t324 * t90 * t92 * t33 - 0.53020994233369026907085240525174613991298354771549e-1 * t330 * t69 * t83 * t33 - 0.50167127350538589836488394571946851238131125013746e0 * t41 * t84 * t47 + 0.96902277115443742137603943210562149050493484994510e-3 * t317 * t56 + 0.16150379519240623689600657201760358175082247499085e-3 * t191 * t65 + 0.96902277115443742137603943210562149050493484994510e-3 * t320 * t73
  t400 = 0.1e1 / t27
  t402 = -t349 * t400 + t350
  t405 = f.my_piecewise3(t353, 0, 0.4e1 / 0.3e1 * t356 * t402)
  t406 = -t402
  t409 = f.my_piecewise3(t360, 0, 0.4e1 / 0.3e1 * t361 * t406)
  t410 = t405 + t409
  t422 = 0.10363566666666666666666666666666666666666666666667e-1 * t80 * t174 + 0.39765745675026770180313930393880960493473766078662e-1 * t330 * t69 * t52 * t33 + 0.96902277115443742137603943210562149050493484994510e-3 * t320 * t56
  t423 = t356 ** 2
  t424 = 0.1e1 / t423
  t425 = t402 ** 2
  t428 = 0.1e1 / t42
  t431 = 0.2e1 * t349 * t428 - 0.2e1 * t400
  t435 = f.my_piecewise3(t353, 0, 0.4e1 / 0.9e1 * t424 * t425 + 0.4e1 / 0.3e1 * t356 * t431)
  t436 = t361 ** 2
  t437 = 0.1e1 / t436
  t438 = t406 ** 2
  t441 = -t431
  t445 = f.my_piecewise3(t360, 0, 0.4e1 / 0.9e1 * t437 * t438 + 0.4e1 / 0.3e1 * t361 * t441)
  t446 = t435 + t445
  t453 = jnp.log(t4 * t10 * t57 / 0.4e1)
  t457 = jnp.atan(0.61519908197590802321728722658814145360143502774884e1 / t13)
  t460 = jnp.log(t183 * t57)
  t462 = 0.310907e-1 * t453 + 0.38783294878113014394824731224995739188004877421366e-1 * t457 + 0.96902277115443742137603943210562149050493484994510e-3 * t460
  t464 = 0.1e1 / t423 / t352
  t468 = t424 * t402
  t473 = -0.6e1 * t349 * t29 + 0.6e1 * t428
  t477 = f.my_piecewise3(t353, 0, -0.8e1 / 0.27e2 * t464 * t425 * t402 + 0.4e1 / 0.3e1 * t468 * t431 + 0.4e1 / 0.3e1 * t356 * t473)
  t479 = 0.1e1 / t436 / t359
  t483 = t437 * t406
  t486 = -t473
  t490 = f.my_piecewise3(t360, 0, -0.8e1 / 0.27e2 * t479 * t438 * t406 + 0.4e1 / 0.3e1 * t483 * t441 + 0.4e1 / 0.3e1 * t361 * t486)
  t491 = t477 + t490
  t495 = t12 + 0.706042e1
  t496 = t495 ** 2
  t497 = t496 ** 2
  t499 = 0.1e1 / t497 / t495
  t500 = t499 * t1
  t501 = t500 * t3
  t502 = 0.1e1 / t496
  t504 = 0.1e1 + 0.22381669423600000000000000000000000000000000000000e2 * t502
  t505 = t504 ** 2
  t506 = 0.1e1 / t505
  t510 = t502 * t25
  t511 = 0.1e1 / t504
  t516 = t54 + 0.35302100000000000000000000000000000000000000000000e1 * t12 + 0.180578e2
  t517 = 0.1e1 / t516
  t521 = t516 ** 2
  t522 = 0.1e1 / t521
  t523 = t9 * t522
  t525 = -t66 - 0.58836833333333333333333333333333333333333333333333e0 * t71
  t531 = (-t4 * t53 * t517 / 0.12e2 - t61 * t523 * t525 / 0.4e1) * t16 * t79
  t534 = t86 - 0.39224555555555555555555555555555555555555555555555e0 * t94 + 0.78449111111111111111111111111111111111111111111110e0 * t97
  t535 = t81 * t534
  t538 = t21 * t525
  t542 = t4 * t84 * t517
  t544 = t52 * t522
  t549 = 0.1e1 / t521 / t516
  t550 = t9 * t549
  t551 = t525 ** 2
  t560 = (t542 / 0.9e1 + t61 * t544 * t525 / 0.6e1 + t61 * t550 * t551 / 0.2e1 - t61 * t523 * t534 / 0.4e1) * t16 * t79
  t561 = t81 * t525
  t565 = t4 * t45 * t517
  t567 = t83 * t522
  t569 = t61 * t567 * t525
  t571 = t52 * t549
  t578 = t521 ** 2
  t579 = 0.1e1 / t578
  t580 = t9 * t579
  t581 = t551 * t525
  t585 = t525 * t534
  t592 = -t155 - 0.23534733333333333333333333333333333333333333333333e1 * t157 + 0.15689822222222222222222222222222222222222222222222e1 * t162 - 0.18304792592592592592592592592592592592592592592592e1 * t165
  t598 = (-0.7e1 / 0.27e2 * t565 - t569 / 0.3e1 - t61 * t571 * t551 / 0.2e1 + t61 * t544 * t534 / 0.4e1 - 0.3e1 / 0.2e1 * t61 * t580 * t581 + 0.3e1 / 0.2e1 * t61 * t550 * t585 - t61 * t523 * t592 / 0.4e1) * t16 * t79
  t599 = t81 * t516
  t602 = t177 + 0.32500e0
  t603 = t602 * t517
  t604 = t603 * t67
  t607 = t602 ** 2
  t608 = t607 * t522
  t610 = -t604 * t65 / 0.6e1 - t608 * t525
  t612 = 0.1e1 / t607 / t602
  t613 = t610 * t612
  t614 = t516 * t67
  t615 = t613 * t614
  t618 = t607 ** 2
  t619 = 0.1e1 / t618
  t620 = t610 * t619
  t621 = t620 * t516
  t624 = t496 * t495
  t625 = 0.1e1 / t624
  t626 = t625 * t1
  t627 = t626 * t3
  t631 = 0.1e1 / t497
  t632 = t631 * t16
  t633 = t632 * t17
  t634 = t511 * t67
  t639 = 0.1e1 / t497 / t496
  t640 = t639 * t16
  t641 = t640 * t17
  t642 = t506 * t67
  t646 = t626 * t223
  t647 = t2 * t511
  t651 = 0.11322067513073894329090826277329563323954137090250e1 * t501 * t45 * t506 + 0.16555529631147769304086026058847109426994589620583e0 * t510 * t30 * t511 + 0.51817833333333333333333333333333333333333333333333e-2 * t531 * t535 + 0.34545222222222222222222222222222222222222222222222e-2 * t531 * t538 + 0.10363566666666666666666666666666666666666666666667e-1 * t560 * t561 + 0.51817833333333333333333333333333333333333333333333e-2 * t598 * t599 - 0.49952602123169151962811919903162249734579437001269e-3 * t615 * t85 + 0.93661128980942159930272349818429218252336444377380e-4 * t621 * t85 - 0.50586340539618183984707301846477278804705690507337e-1 * t627 * t45 * t511 + 0.27592549385246282173476710098078515711657649367638e-1 * t633 * t210 * t634 - 0.14409904107548592782479233443873989685032538114864e1 * t641 * t210 * t642 + 0.22993791154371901811230591748398763093048041139699e-2 * t646 * t45 * t647
  t652 = t500 * t223
  t653 = t2 * t506
  t657 = t497 ** 2
  t658 = 0.1e1 / t657
  t659 = t658 * t16
  t660 = t659 * t17
  t662 = 0.1e1 / t505 / t504
  t663 = t662 * t67
  t667 = t21 * t516
  t670 = t250 * t516
  t675 = t602 * t549
  t676 = t675 * t68
  t680 = t602 * t522
  t681 = t680 * t89
  t686 = t680 * t68
  t700 = t603 * t88
  t705 = t607 * t579
  t708 = t607 * t549
  t712 = -0.11e2 / 0.216e3 * t565 - t569 / 0.24e2 - t676 * t69 * t52 * t551 + t681 * t90 * t92 * t525 / 0.3e1 - 0.2e1 / 0.3e1 * t686 * t69 * t83 * t525 + t686 * t69 * t52 * t534 / 0.2e1 + t277 * t278 * t517 / 0.432e3 - 0.2e1 / 0.3e1 * t603 * t157 + 0.4e1 / 0.9e1 * t700 * t285 - 0.14e2 / 0.27e2 * t604 * t154 - 0.6e1 * t705 * t581 + 0.6e1 * t708 * t585 - t608 * t592
  t713 = 0.1e1 / t607
  t714 = t712 * t713
  t718 = t52 * t525
  t729 = t542 / 0.72e2 + t686 * t69 * t718 / 0.3e1 - t700 * t308 / 0.9e1 + 0.2e1 / 0.9e1 * t604 * t85 + 0.2e1 * t708 * t551 - t608 * t534
  t730 = t729 * t713
  t733 = t610 * t713
  t737 = t502 * t88 * t16
  t743 = t502 * t67 * t1
  t748 = t729 * t612
  t749 = t748 * t614
  t752 = t525 * t67
  t753 = t613 * t752
  t756 = t516 * t88
  t757 = t613 * t756
  t760 = -0.51463943241244974223140119442407106017973350410227e-1 * t652 * t45 * t653 + 0.18429583437767336287475605998441200095133403022660e2 * t660 * t210 * t663 + 0.34545222222222222222222222222222222222222222222222e-2 * t560 * t667 - 0.11515074074074074074074074074074074074074074074074e-2 * t531 * t670 + 0.22478670955426118383265363956423012380560746650571e-2 * t714 * t516 + 0.44957341910852236766530727912846024761121493301142e-2 * t730 * t525 + 0.22478670955426118383265363956423012380560746650571e-2 * t733 * t534 - 0.11037019754098512869390684039231406284663059747056e0 * t737 * t90 * t160 * t511 + 0.12876523046448265014289131379103307332106903038231e0 * t743 * t69 * t44 * t511 + 0.74928903184753727944217879854743374601869155501904e-3 * t749 * t65 + 0.74928903184753727944217879854743374601869155501904e-3 * t753 * t65 + 0.24976301061584575981405959951581124867289718500635e-3 * t757 * t308
  t761 = t651 + t760
  t791 = 0.51817833333333333333333333333333333333333333333333e-2 * t560 * t599 + 0.17272611111111111111111111111111111111111111111111e-2 * t531 * t667 + 0.51817833333333333333333333333333333333333333333333e-2 * t531 * t561 + 0.13796274692623141086738355049039257855828824683819e-1 * t627 * t84 * t511 + 0.27592549385246282173476710098078515711657649367639e-1 * t737 * t90 * t92 * t511 - 0.55185098770492564346953420196157031423315298735277e-1 * t743 * t69 * t83 * t511 - 0.30878365944746984533884071665444263610784010246137e0 * t501 * t84 * t506 + 0.22478670955426118383265363956423012380560746650571e-2 * t730 * t516 + 0.37464451592376863972108939927371687300934577750952e-3 * t615 * t65 + 0.22478670955426118383265363956423012380560746650571e-2 * t733 * t525
  t803 = 0.51817833333333333333333333333333333333333333333333e-2 * t531 * t599 + 0.41388824077869423260215065147117773567486474051458e-1 * t743 * t69 * t52 * t511 + 0.22478670955426118383265363956423012380560746650571e-2 * t733 * t516
  t810 = jnp.log(t4 * t10 * t517 / 0.4e1)
  t814 = jnp.atan(0.47309269095601128299619512910246923284397083311420e1 / t495)
  t817 = jnp.log(t607 * t517)
  t819 = 0.1554535e-1 * t810 + 0.52491393169780936217021346072241076933841385384497e-1 * t814 + 0.22478670955426118383265363956423012380560746650571e-2 * t817
  t830 = 0.1e1 / t8 / t28
  t853 = t6 * t830
  t855 = t4 * t853 * t57
  t859 = t61 * t44 * t63 * t73
  t863 = t61 * t83 * t114 * t116
  t866 = t61 * t132 * t99
  t879 = 0.1e1 / t143 / t56
  t881 = t116 ** 2
  t885 = t116 * t99
  t889 = t99 ** 2
  t893 = t73 * t167
  t897 = t4 * t853
  t898 = 0.70e2 / 0.81e2 * t897
  t902 = 0.1e1 / t12 / t2 / t350 / 0.48e2
  t903 = t902 * t2
  t904 = t28 * t7
  t906 = 0.1e1 / t8 / t904
  t908 = t903 * t906 * t61
  t910 = 0.1e1 / t904
  t911 = t156 * t910
  t914 = 0.1e1 / t19 / t28
  t916 = t89 * t90 * t914
  t919 = t68 * t69 * t830
  t921 = t898 - 0.10354000000000000000000000000000000000000000000000e1 * t908 + 0.99398400000000000000000000000000000000000000000000e1 * t911 - 0.36814222222222222222222222222222222222222222222222e1 * t916 + 0.32212444444444444444444444444444444444444444444444e1 * t919
  t925 = 0.70e2 / 0.81e2 * t855 + 0.28e2 / 0.27e2 * t859 + 0.4e1 / 0.3e1 * t863 - 0.2e1 / 0.3e1 * t866 + 0.2e1 * t61 * t52 * t144 * t146 - 0.2e1 * t61 * t136 * t150 + t61 * t109 * t167 / 0.3e1 + 0.6e1 * t61 * t9 * t879 * t881 - 0.9e1 * t61 * t145 * t885 + 0.3e1 / 0.2e1 * t61 * t115 * t889 + 0.2e1 * t61 * t115 * t893 - t61 * t64 * t921 / 0.4e1
  t932 = -0.69090444444444444444444444444444444444444444444446e-2 * t125 * t251 + 0.10363566666666666666666666666666666666666666666667e-1 * t173 * t245 + 0.20727133333333333333333333333333333333333333333334e-1 * t125 * t103 + 0.20435174860777645787105769785744382475812907568201e0 * t201 * t830 * t33 * t61 - 0.77340987998746992664586274965084728992118817729523e1 * t39 * t830 * t47 * t61 + 0.31090700000000000000000000000000000000000000000001e-1 * t125 * t100 + 0.64601518076962494758402628807041432700328989996342e-3 * t189 * t56 * t157 - 0.69090444444444444444444444444444444444444444444446e-2 * t80 * t250 * t73 + 0.10363566666666666666666666666666666666666666666667e-1 * t80 * t21 * t99 + 0.38383580246913580246913580246913580246913580246915e-2 * t80 * t307 * t56 + 0.10363566666666666666666666666666666666666666666667e-1 * t925 * t16 * t79 * t174 + 0.31090700000000000000000000000000000000000000000001e-1 * t173 * t126
  t940 = t830 * t2
  t965 = 0.8e1 / 0.3e1 * t261 * t25 * t30 * t73 - 0.11e2 / 0.648e3 * t277 * t940 * t57 + 0.11e2 / 0.54e2 * t859 + t863 / 0.6e1 - t866 / 0.12e2 + 0.24e2 * t183 * t879 * t881 - t184 * t921 + 0.6e1 * t293 * t889 - 0.36e2 * t290 * t885 + 0.8e1 * t293 * t893 - 0.4e1 * t257 * t69 * t303 * t99 - t277 * t278 * t63 * t73 / 0.108e3
  t966 = t5 * t914
  t967 = t18 * t966
  t994 = t906 * t1 * t69
  t1015 = -0.160e3 / 0.81e2 * t284 * t967 + 0.140e3 / 0.81e2 * t180 * t897 + 0.16e2 / 0.3e1 * t179 * t911 + 0.185e3 / 0.864e3 * t855 - 0.4e1 / 0.3e1 * t256 * t89 * t90 * t92 * t116 + 0.2e1 / 0.3e1 * t262 * t90 * t92 * t99 - 0.4e1 / 0.3e1 * t267 * t69 * t83 * t99 + 0.2e1 / 0.3e1 * t267 * t69 * t52 * t167 - 0.5e1 / 0.9e1 * t179 * t903 * t994 - 0.16e2 / 0.9e1 * t262 * t90 * t160 * t73 + 0.56e2 / 0.27e2 * t267 * t69 * t44 * t73 + 0.4e1 * t178 * t144 * t68 * t69 * t52 * t146 + 0.8e1 / 0.3e1 * t257 * t69 * t83 * t116
  t1053 = 0.10363566666666666666666666666666666666666666666667e-1 * t80 * t81 * t167 + 0.96902277115443742137603943210562149050493484994510e-3 * (t965 + t1015) * t298 * t56 + 0.29070683134633122641281182963168644715148045498353e-2 * t299 * t73 + 0.29070683134633122641281182963168644715148045498353e-2 * t317 * t99 + 0.96902277115443742137603943210562149050493484994510e-3 * t320 * t167 + 0.12112784639430467767200492901320268631311685624314e-3 * t316 * t195 * t56 * t85 + 0.47129772651883579472964658244599656881154093130267e0 * t324 * t90 * t914 * t33 - 0.41238551070398132038844075964024699771009831488983e0 * t330 * t69 * t830 * t33 - 0.16200859349084980443831601271581132052896719513529e-1 * t224 * t853 * t225 + 0.61315377872880498689041371143490595957715819461244e0 * t230 * t853 * t231 + 0.17168305804406539632931583920177366868160429449148e2 * t218 * t966 * t219 - 0.37129640917784654580181051383469886637668330434323e3 * t238 * t966 * t241 + 0.12112784639430467767200492901320268631311685624314e-3 * t196 * t73 * t85
  t1061 = t79 * t5
  t1085 = t46 ** 2
  t1093 = t2 * t910
  t1118 = t90 * t160 * t67
  t1122 = t2 * t906
  t1128 = -0.19441031218901976532597921525897358463476063416234e0 * t209 * t966 * t211 + 0.17673664744456342302361746841724871330432784923849e-1 * t39 * t2 * t914 * t33 * t16 * t1061 - 0.26755801253620581246127143771704987327003266673998e1 / t37 / t200 * t2 * t914 * t47 * t16 * t1061 + 0.12657832131062950425061722062546552262841476284429e3 / t235 / t13 * t2 * t914 * t240 * t16 * t1061 - 0.19162434373246948642083122762742588170998040494372e4 / t235 / t200 * t2 * t914 / t1085 * t16 * t1061 - 0.14804514559303905048800602434946994993825393540828e-3 * t197 * t154 - 0.12725038616008566457700457726041907357911605145172e1 * t26 * t1093 * t33 - 0.46822652193836017180722501600483727822255716679496e1 * t216 * t2 * t910 * t47 * t88 + 0.10126265704850360340049377650037241810273181027543e3 * t236 * t2 * t910 * t240 * t88 + 0.53020994233369026907085240525174613991298354771548e-1 * t207 * t2 * t910 * t33 * t88 + 0.53834598397468745632002190672534527250274158330283e-4 * t186 / t194 / t178 * t56 * t16 * t1118 + 0.13255248558342256726771310131293653497824588692887e0 * t15 * t902 * t1122 * t33 * t1 * t69
  t1132 = t223 * t6 * t278
  t1138 = t914 * t2
  t1174 = 0.67293247996835932040002738340668159062842697912856e-5 * t196 * t56 * t1 * t1132 + 0.50245625170970829256535377961032225433589214441597e-3 * t191 * t154 + 0.84385547540419669500411480416977015085609841896189e1 * t237 * t1061 * t1138 * t241 + 0.48451138557721871068801971605281074525246742497255e-3 * t297 * t188 * t190 * t65 + 0.96902277115443742137603943210562149050493484994510e-3 * t335 * t339 * t65 + 0.48451138557721871068801971605281074525246742497255e-3 * t189 * t99 * t67 * t65 + 0.32300759038481247379201314403520716350164494998170e-3 * t335 * t343 * t308 + 0.32300759038481247379201314403520716350164494998170e-3 * t189 * t73 * t88 * t308 + 0.44184161861140855755904367104312178326081962309624e-2 * t208 * t1061 * t1138 * t211 - 0.39018876828196680983935418000403106518546430566246e0 * t217 * t1061 * t1138 * t219 - 0.64601518076962494758402628807041432700328989996340e-3 * t336 * t85 - 0.64601518076962494758402628807041432700328989996340e-3 * t340 * t85 - 0.43067678717974996505601752538027621800219326664227e-3 * t344 * t285
  t1187 = t352 ** 2
  t1190 = t425 ** 2
  t1196 = t431 ** 2
  t1203 = 0.24e2 * t349 * t910 - 0.24e2 * t29
  t1207 = f.my_piecewise3(t353, 0, 0.40e2 / 0.81e2 / t423 / t1187 * t1190 - 0.16e2 / 0.9e1 * t464 * t425 * t431 + 0.4e1 / 0.3e1 * t424 * t1196 + 0.16e2 / 0.9e1 * t468 * t473 + 0.4e1 / 0.3e1 * t356 * t1203)
  t1208 = t359 ** 2
  t1211 = t438 ** 2
  t1217 = t441 ** 2
  t1226 = f.my_piecewise3(t360, 0, 0.40e2 / 0.81e2 / t436 / t1208 * t1211 - 0.16e2 / 0.9e1 * t479 * t438 * t441 + 0.4e1 / 0.3e1 * t437 * t1217 + 0.16e2 / 0.9e1 * t483 * t486 - 0.4e1 / 0.3e1 * t361 * t1203)
  t1227 = t1207 + t1226
  t1262 = 0.15545350000000000000000000000000000000000000000000e-1 * t560 * t535 - 0.34545222222222222222222222222222222222222222222222e-2 * t531 * t250 * t525 - 0.47604147498151601156404610484226573066625349129460e1 * t501 * t853 * t506 + 0.51817833333333333333333333333333333333333333333333e-2 * t531 * t21 * t534 + 0.14985780636950745588843575970948674920373831100381e-2 * t613 * t516 * t157 + 0.19191790123456790123456790123456790123456790123457e-2 * t531 * t307 * t516 - 0.34545222222222222222222222222222222222222222222222e-2 * t560 * t670 + 0.15545350000000000000000000000000000000000000000000e-1 * t598 * t561 + 0.10363566666666666666666666666666666666666666666667e-1 * t560 * t538 + 0.51817833333333333333333333333333333333333333333333e-2 * t531 * t81 * t592 + 0.21269256817794009175388297367268855861069438054221e0 * t625 * t830 * t511 * t61 + 0.51817833333333333333333333333333333333333333333333e-2 * t598 * t667
  t1264 = t4 * t853 * t517
  t1268 = t61 * t44 * t522 * t525
  t1272 = t61 * t83 * t549 * t551
  t1275 = t61 * t567 * t534
  t1288 = 0.1e1 / t578 / t516
  t1290 = t551 ** 2
  t1294 = t551 * t534
  t1298 = t534 ** 2
  t1302 = t525 * t592
  t1310 = t898 - 0.19612277777777777777777777777777777777777777777777e1 * t908 + 0.18827786666666666666666666666666666666666666666666e2 * t911 - 0.69732543209876543209876543209876543209876543209875e1 * t916 + 0.61015975308641975308641975308641975308641975308640e1 * t919
  t1314 = 0.70e2 / 0.81e2 * t1264 + 0.28e2 / 0.27e2 * t1268 + 0.4e1 / 0.3e1 * t1272 - 0.2e1 / 0.3e1 * t1275 + 0.2e1 * t61 * t52 * t579 * t581 - 0.2e1 * t61 * t571 * t585 + t61 * t544 * t592 / 0.3e1 + 0.6e1 * t61 * t9 * t1288 * t1290 - 0.9e1 * t61 * t580 * t1294 + 0.3e1 / 0.2e1 * t61 * t550 * t1298 + 0.2e1 * t61 * t550 * t1302 - t61 * t523 * t1310 / 0.4e1
  t1364 = -0.11e2 / 0.648e3 * t277 * t940 * t517 + 0.8e1 / 0.3e1 * t680 * t25 * t30 * t525 + 0.11e2 / 0.54e2 * t1268 + t1272 / 0.6e1 - t1275 / 0.12e2 + 0.16e2 / 0.3e1 * t603 * t911 + 0.185e3 / 0.864e3 * t1264 - t608 * t1310 + 0.24e2 * t607 * t1288 * t1290 + 0.6e1 * t708 * t1298 - 0.4e1 * t676 * t69 * t718 * t534 - t277 * t278 * t522 * t525 / 0.108e3
  t1411 = -0.160e3 / 0.81e2 * t700 * t967 + 0.140e3 / 0.81e2 * t604 * t897 - 0.5e1 / 0.9e1 * t603 * t903 * t994 + 0.4e1 * t602 * t579 * t68 * t69 * t52 * t581 + 0.8e1 / 0.3e1 * t676 * t69 * t83 * t551 - 0.16e2 / 0.9e1 * t681 * t90 * t160 * t525 + 0.56e2 / 0.27e2 * t686 * t69 * t44 * t525 - 0.4e1 / 0.3e1 * t675 * t89 * t90 * t92 * t551 + 0.2e1 / 0.3e1 * t681 * t90 * t92 * t534 - 0.4e1 / 0.3e1 * t686 * t69 * t83 * t534 + 0.2e1 / 0.3e1 * t686 * t69 * t52 * t592 + 0.8e1 * t708 * t1302 - 0.36e2 * t705 * t1294
  t1434 = t505 ** 2
  t1445 = 0.51817833333333333333333333333333333333333333333333e-2 * t1314 * t16 * t79 * t599 - 0.28819808215097185564958466887747979370065076229728e1 * t639 * t2 * t910 * t506 * t88 - 0.13244423704918215443268820847077687541595671696467e1 * t510 * t1093 * t511 + 0.36859166875534672574951211996882400190266806045320e2 * t658 * t2 * t910 * t662 * t88 + 0.55185098770492564346953420196157031423315298735276e-1 * t631 * t2 * t910 * t511 * t88 + 0.22478670955426118383265363956423012380560746650571e-2 * (t1364 + t1411) * t713 * t516 + 0.67436012866278355149796091869269037141682239951713e-2 * t730 * t534 + 0.22478670955426118383265363956423012380560746650571e-2 * t733 * t592 + 0.67436012866278355149796091869269037141682239951713e-2 * t714 * t525 + 0.46073958594418340718689014996103000237833507556650e2 / t657 / t495 * t2 * t914 * t662 * t16 * t1061 - 0.41248484411876216403621151040619215743173669759529e3 / t657 / t624 * t2 * t914 / t1434 * t16 * t1061 - 0.34342413959678791974433194933424046692523362938372e-3 * t621 * t154 + 0.10567263012202301373818104525507592435690527950900e2 * t641 * t966 * t642
  t1494 = -0.13515027854362713277482111065523546736431162216617e3 * t660 * t966 * t663 + 0.28098338694282647979081704945528765475700933313214e-3 * t729 * t619 * t516 * t85 + 0.28098338694282647979081704945528765475700933313214e-3 * t620 * t525 * t85 - 0.20234536215847273593882920738590911521882276202934e0 * t633 * t966 * t634 + 0.49053421129326723863958595729917361265169154431359e0 * t737 * t90 * t914 * t511 - 0.42921743488160883380963771263677691107023010127437e0 * t743 * t69 * t830 * t511 + 0.37740225043579647763636087591098544413180456967501e0 * t652 * t853 * t653 - 0.16862113513206061328235767282159092934901896835780e-1 * t646 * t853 * t647 + 0.18395032923497521448984473398719010474438432911759e-1 * t499 * t2 * t914 * t511 * t16 * t1061 - 0.16468461837198391751404838221570273925751472131273e1 / t497 / t624 * t2 * t914 * t506 * t16 * t1061 - 0.24016506845914321304132055739789982808387563524773e0 * t640 * t1061 * t1138 * t642 - 0.14985780636950745588843575970948674920373831100381e-2 * t749 * t85
  t1544 = -0.14985780636950745588843575970948674920373831100381e-2 * t753 * t85 - 0.99905204246338303925623839806324499469158874002539e-3 * t757 * t285 + 0.13796274692623141086738355049039257855828824683819e0 * t502 * t902 * t1122 * t511 * t1 * t69 + 0.11655607162072802124656114644071191604735201966963e-2 * t615 * t154 + 0.15610188163490359988378724969738203042056074062897e-4 * t620 * t516 * t1 * t1132 + 0.74928903184753727944217879854743374601869155501904e-3 * t748 * t756 * t308 + 0.74928903184753727944217879854743374601869155501904e-3 * t613 * t525 * t88 * t308 + 0.11239335477713059191632681978211506190280373325286e-2 * t613 * t534 * t67 * t65 + 0.11239335477713059191632681978211506190280373325286e-2 * t712 * t612 * t614 * t65 + 0.22478670955426118383265363956423012380560746650571e-2 * t748 * t752 * t65 + 0.30715972396278893812459343330735333491889005037766e1 * t659 * t1061 * t1138 * t663 + 0.12488150530792287990702979975790562433644859250317e-3 * t610 / t618 / t602 * t516 * t16 * t1118 + 0.45987582308743803622461183496797526186096082279398e-2 * t632 * t1061 * t1138 * t634
  d1111 = 0.4e1 * t348 * t370 - 0.12e2 * t399 * t410 * t368 - 0.12e2 * t422 * t446 * t368 - 0.4e1 * t462 * t491 * t368 + 0.4e1 * t761 * t364 * t368 + 0.12e2 * t791 * t410 * t368 + 0.12e2 * t803 * t446 * t368 + 0.4e1 * t819 * t491 * t368 + t7 * ((t932 + t1053 + t1128 + t1174) * t370 - 0.4e1 * t348 * t410 * t368 - 0.6e1 * t399 * t446 * t368 - 0.4e1 * t422 * t491 * t368 - t462 * t1227 * t368 + (t1262 + t1445 + t1494 + t1544) * t364 * t368 + 0.4e1 * t761 * t410 * t368 + 0.6e1 * t791 * t446 * t368 + 0.4e1 * t803 * t491 * t368 + t819 * t1227 * t368)

  res = {'v4rho4': d1111}
  return res
