"""Generated from mgga_c_rregtm.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  beta_a = 0.06672455060314922

  beta_b = 0.1

  beta_c = 0.1778

  scan_alpha = lambda z, xt, ts0, ts1: (f.t_total(z, ts0, ts1) - xt ** 2 / 8) / (K_FACTOR_C * f.t_total(z, 1, 1))

  scan_b1c = 0.0285764

  scan_b2c = 0.0889

  scan_b3c = 0.125541

  scan_chi_infty = 0.12802585262625815

  scan_G_cnst = 2.363

  params_c1 = 0.64

  params_c2 = 1.5

  params_d = 0.7

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  mbeta = lambda rs, t=None: beta_a * (1 + beta_b * rs) / (1 + beta_c * rs)

  scan_eclda0 = lambda rs: -scan_b1c / (1 + scan_b2c * jnp.sqrt(rs) + scan_b3c * rs)

  scan_g_infty = lambda s: 1 / (1 + 4 * scan_chi_infty * s ** 2) ** (1 / 4)

  scan_Gc = lambda z: (1 - scan_G_cnst * (2 ** (1 / 3) - 1) * f.f_zeta(z)) * (1 - z ** 12)

  scan_f_alpha_left0 = lambda a: jnp.exp(-params_c1 * a / (1 - a))

  scan_f_alpha_left_cutoff = -jnp.log(DBL_EPSILON) / (-jnp.log(DBL_EPSILON) + params_c1)

  scan_f_alpha_right0 = lambda a: -params_d * jnp.exp(params_c2 / (1 - a))

  scan_f_alpha_right_cutoff = (-jnp.log(DBL_EPSILON / jnp.abs(params_d)) + params_c2) / -jnp.log(DBL_EPSILON / jnp.abs(params_d))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  scan_H0 = lambda rs, s: scan_b1c * jnp.log(1 + (jnp.exp(-scan_eclda0(rs) / scan_b1c) - 1) * (1 - scan_g_infty(s)))

  scan_f_alpha_left = lambda a: f.my_piecewise3(a > scan_f_alpha_left_cutoff, 0, scan_f_alpha_left0(jnp.minimum(scan_f_alpha_left_cutoff, a)))

  scan_f_alpha_right = lambda a: f.my_piecewise3(a < scan_f_alpha_right_cutoff, 0, scan_f_alpha_right0(jnp.maximum(scan_f_alpha_right_cutoff, a)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  scan_e0 = lambda rs, z, s: (scan_eclda0(rs) + scan_H0(rs, s)) * scan_Gc(z)

  scan_f_alpha = lambda a: f.my_piecewise3(a <= 1, scan_f_alpha_left(a), scan_f_alpha_right(a))

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  scan_e0_g = lambda rs, z, t: (1 + 4 * A(rs, z, t) * t ** 2) ** (-1 / 4)

  f2 = lambda rs, z, t: mbeta(rs, t) * (1 - scan_e0_g(rs, z, t)) / (mgamma * A(rs, z, t))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  scan_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: f_pbe(rs, z, xt, xs0, xs1) + scan_f_alpha(scan_alpha(z, xt, ts0, ts1)) * (+scan_e0(rs, z, X2S * 2 ** (1 / 3) * xt) - f_pbe(rs, z, xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: scan_f(rs, z, xt, xs0, xs1, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  beta_a = 0.06672455060314922

  beta_b = 0.1

  beta_c = 0.1778

  scan_alpha = lambda z, xt, ts0, ts1: (f.t_total(z, ts0, ts1) - xt ** 2 / 8) / (K_FACTOR_C * f.t_total(z, 1, 1))

  scan_b1c = 0.0285764

  scan_b2c = 0.0889

  scan_b3c = 0.125541

  scan_chi_infty = 0.12802585262625815

  scan_G_cnst = 2.363

  params_c1 = 0.64

  params_c2 = 1.5

  params_d = 0.7

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  mbeta = lambda rs, t=None: beta_a * (1 + beta_b * rs) / (1 + beta_c * rs)

  scan_eclda0 = lambda rs: -scan_b1c / (1 + scan_b2c * jnp.sqrt(rs) + scan_b3c * rs)

  scan_g_infty = lambda s: 1 / (1 + 4 * scan_chi_infty * s ** 2) ** (1 / 4)

  scan_Gc = lambda z: (1 - scan_G_cnst * (2 ** (1 / 3) - 1) * f.f_zeta(z)) * (1 - z ** 12)

  scan_f_alpha_left0 = lambda a: jnp.exp(-params_c1 * a / (1 - a))

  scan_f_alpha_left_cutoff = -jnp.log(DBL_EPSILON) / (-jnp.log(DBL_EPSILON) + params_c1)

  scan_f_alpha_right0 = lambda a: -params_d * jnp.exp(params_c2 / (1 - a))

  scan_f_alpha_right_cutoff = (-jnp.log(DBL_EPSILON / jnp.abs(params_d)) + params_c2) / -jnp.log(DBL_EPSILON / jnp.abs(params_d))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  scan_H0 = lambda rs, s: scan_b1c * jnp.log(1 + (jnp.exp(-scan_eclda0(rs) / scan_b1c) - 1) * (1 - scan_g_infty(s)))

  scan_f_alpha_left = lambda a: f.my_piecewise3(a > scan_f_alpha_left_cutoff, 0, scan_f_alpha_left0(jnp.minimum(scan_f_alpha_left_cutoff, a)))

  scan_f_alpha_right = lambda a: f.my_piecewise3(a < scan_f_alpha_right_cutoff, 0, scan_f_alpha_right0(jnp.maximum(scan_f_alpha_right_cutoff, a)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  scan_e0 = lambda rs, z, s: (scan_eclda0(rs) + scan_H0(rs, s)) * scan_Gc(z)

  scan_f_alpha = lambda a: f.my_piecewise3(a <= 1, scan_f_alpha_left(a), scan_f_alpha_right(a))

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  scan_e0_g = lambda rs, z, t: (1 + 4 * A(rs, z, t) * t ** 2) ** (-1 / 4)

  f2 = lambda rs, z, t: mbeta(rs, t) * (1 - scan_e0_g(rs, z, t)) / (mgamma * A(rs, z, t))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  scan_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: f_pbe(rs, z, xt, xs0, xs1) + scan_f_alpha(scan_alpha(z, xt, ts0, ts1)) * (+scan_e0(rs, z, X2S * 2 ** (1 / 3) * xt) - f_pbe(rs, z, xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: scan_f(rs, z, xt, xs0, xs1, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  beta_a = 0.06672455060314922

  beta_b = 0.1

  beta_c = 0.1778

  scan_alpha = lambda z, xt, ts0, ts1: (f.t_total(z, ts0, ts1) - xt ** 2 / 8) / (K_FACTOR_C * f.t_total(z, 1, 1))

  scan_b1c = 0.0285764

  scan_b2c = 0.0889

  scan_b3c = 0.125541

  scan_chi_infty = 0.12802585262625815

  scan_G_cnst = 2.363

  params_c1 = 0.64

  params_c2 = 1.5

  params_d = 0.7

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  mbeta = lambda rs, t=None: beta_a * (1 + beta_b * rs) / (1 + beta_c * rs)

  scan_eclda0 = lambda rs: -scan_b1c / (1 + scan_b2c * jnp.sqrt(rs) + scan_b3c * rs)

  scan_g_infty = lambda s: 1 / (1 + 4 * scan_chi_infty * s ** 2) ** (1 / 4)

  scan_Gc = lambda z: (1 - scan_G_cnst * (2 ** (1 / 3) - 1) * f.f_zeta(z)) * (1 - z ** 12)

  scan_f_alpha_left0 = lambda a: jnp.exp(-params_c1 * a / (1 - a))

  scan_f_alpha_left_cutoff = -jnp.log(DBL_EPSILON) / (-jnp.log(DBL_EPSILON) + params_c1)

  scan_f_alpha_right0 = lambda a: -params_d * jnp.exp(params_c2 / (1 - a))

  scan_f_alpha_right_cutoff = (-jnp.log(DBL_EPSILON / jnp.abs(params_d)) + params_c2) / -jnp.log(DBL_EPSILON / jnp.abs(params_d))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  scan_H0 = lambda rs, s: scan_b1c * jnp.log(1 + (jnp.exp(-scan_eclda0(rs) / scan_b1c) - 1) * (1 - scan_g_infty(s)))

  scan_f_alpha_left = lambda a: f.my_piecewise3(a > scan_f_alpha_left_cutoff, 0, scan_f_alpha_left0(jnp.minimum(scan_f_alpha_left_cutoff, a)))

  scan_f_alpha_right = lambda a: f.my_piecewise3(a < scan_f_alpha_right_cutoff, 0, scan_f_alpha_right0(jnp.maximum(scan_f_alpha_right_cutoff, a)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  scan_e0 = lambda rs, z, s: (scan_eclda0(rs) + scan_H0(rs, s)) * scan_Gc(z)

  scan_f_alpha = lambda a: f.my_piecewise3(a <= 1, scan_f_alpha_left(a), scan_f_alpha_right(a))

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  scan_e0_g = lambda rs, z, t: (1 + 4 * A(rs, z, t) * t ** 2) ** (-1 / 4)

  f2 = lambda rs, z, t: mbeta(rs, t) * (1 - scan_e0_g(rs, z, t)) / (mgamma * A(rs, z, t))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  scan_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: f_pbe(rs, z, xt, xs0, xs1) + scan_f_alpha(scan_alpha(z, xt, ts0, ts1)) * (+scan_e0(rs, z, X2S * 2 ** (1 / 3) * xt) - f_pbe(rs, z, xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: scan_f(rs, z, xt, xs0, xs1, ts0, ts1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 + r1
  t8 = t7 ** (0.1e1 / 0.3e1)
  t11 = t4 * t6 / t8
  t13 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t11
  t14 = jnp.sqrt(t11)
  t17 = t11 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t8 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.23615562999000000000000000000000000000000000000000e0 * t14 + 0.55770497660000000000000000000000000000000000000000e-1 * t11 + 0.12733196185000000000000000000000000000000000000000e-1 * t17 + 0.76629248290000000000000000000000000000000000000000e-2 * t25
  t29 = 0.1e1 + 0.1e1 / t27
  t30 = jnp.log(t29)
  t31 = t13 * t30
  t32 = r0 - r1
  t33 = t32 ** 2
  t34 = t33 ** 2
  t35 = t7 ** 2
  t36 = t35 ** 2
  t37 = 0.1e1 / t36
  t38 = t34 * t37
  t39 = 0.1e1 / t7
  t40 = t32 * t39
  t41 = 0.1e1 + t40
  t42 = t41 <= f.p.zeta_threshold
  t43 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t44 = t43 * f.p.zeta_threshold
  t45 = t41 ** (0.1e1 / 0.3e1)
  t47 = f.my_piecewise3(t42, t44, t45 * t41)
  t48 = 0.1e1 - t40
  t49 = t48 <= f.p.zeta_threshold
  t50 = t48 ** (0.1e1 / 0.3e1)
  t52 = f.my_piecewise3(t49, t44, t50 * t48)
  t53 = t47 + t52 - 0.2e1
  t54 = 2 ** (0.1e1 / 0.3e1)
  t57 = 0.1e1 / (0.2e1 * t54 - 0.2e1)
  t58 = t53 * t57
  t60 = 0.3109070e-1 + 0.15971292590000000000000000000000000000000000000000e-2 * t11
  t65 = 0.21948324211500000000000000000000000000000000000000e0 * t14 + 0.48172707847500000000000000000000000000000000000000e-1 * t11 + 0.13082189292500000000000000000000000000000000000000e-1 * t17 + 0.48592432297500000000000000000000000000000000000000e-2 * t25
  t67 = 0.1e1 + 0.1e1 / t65
  t68 = jnp.log(t67)
  t71 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t11
  t76 = 0.17489762330000000000000000000000000000000000000000e0 * t14 + 0.30591463695000000000000000000000000000000000000000e-1 * t11 + 0.37162156485000000000000000000000000000000000000000e-2 * t17 + 0.41939460495000000000000000000000000000000000000000e-2 * t25
  t78 = 0.1e1 + 0.1e1 / t76
  t79 = jnp.log(t78)
  t80 = t71 * t79
  t82 = -t60 * t68 + t31 - 0.58482236226346462072622386637590534819724553404281e0 * t80
  t83 = t58 * t82
  t84 = t38 * t83
  t86 = 0.58482236226346462072622386637590534819724553404281e0 * t58 * t80
  t87 = jnp.log(0.2e1)
  t88 = 0.1e1 - t87
  t89 = jnp.pi ** 2
  t91 = t88 / t89
  t92 = t43 ** 2
  t93 = t45 ** 2
  t94 = f.my_piecewise3(t42, t92, t93)
  t95 = t50 ** 2
  t96 = f.my_piecewise3(t49, t92, t95)
  t98 = t94 / 0.2e1 + t96 / 0.2e1
  t99 = t98 ** 2
  t100 = t99 * t98
  t102 = 0.66724550603149220e-1 + 0.16681137650787305000000000000000000000000000000000e-2 * t11
  t104 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t11
  t105 = 0.1e1 / t104
  t106 = t102 * t105
  t107 = 0.1e1 / t88
  t108 = t106 * t107
  t110 = (-t31 + t84 + t86) * t107
  t111 = 0.1e1 / t100
  t112 = t89 * t111
  t114 = jnp.exp(-t110 * t112)
  t115 = t114 - 0.1e1
  t116 = 0.1e1 / t115
  t119 = s0 + 0.2e1 * s1 + s2
  t121 = t108 * t89 * t116 * t119
  t123 = 0.1e1 / t8 / t35
  t124 = t123 * t54
  t125 = 0.1e1 / t99
  t127 = 0.1e1 / t3
  t128 = t19 * t127
  t129 = t128 * t5
  t133 = 0.1e1 + t121 * t124 * t125 * t129 / 0.24e2
  t134 = t133 ** (0.1e1 / 0.4e1)
  t136 = 0.1e1 - 0.1e1 / t134
  t138 = t136 * t115 + 0.1e1
  t139 = jnp.log(t138)
  t141 = t91 * t100 * t139
  t142 = r0 ** (0.1e1 / 0.3e1)
  t143 = t142 ** 2
  t145 = 0.1e1 / t143 / r0
  t146 = tau0 * t145
  t147 = t41 / 0.2e1
  t148 = t147 ** (0.1e1 / 0.3e1)
  t149 = t148 ** 2
  t150 = t149 * t147
  t152 = r1 ** (0.1e1 / 0.3e1)
  t153 = t152 ** 2
  t155 = 0.1e1 / t153 / r1
  t156 = tau1 * t155
  t157 = t48 / 0.2e1
  t158 = t157 ** (0.1e1 / 0.3e1)
  t159 = t158 ** 2
  t160 = t159 * t157
  t163 = 0.1e1 / t22 / t35
  t167 = 6 ** (0.1e1 / 0.3e1)
  t168 = (t146 * t150 + t156 * t160 - t119 * t163 / 0.8e1) * t167
  t169 = t89 ** (0.1e1 / 0.3e1)
  t170 = t169 ** 2
  t171 = 0.1e1 / t170
  t172 = t150 + t160
  t173 = 0.1e1 / t172
  t174 = t171 * t173
  t176 = 0.5e1 / 0.9e1 * t168 * t174
  t177 = t176 <= 0.1e1
  t178 = jnp.log(DBL_EPSILON)
  t181 = t178 / (-t178 + 0.64e0)
  t182 = -t181 < t176
  t183 = t176 < -t181
  t184 = f.my_piecewise3(t183, t176, -t181)
  t185 = 0.1e1 - t184
  t186 = 0.1e1 / t185
  t189 = jnp.exp(-0.64e0 * t184 * t186)
  t190 = f.my_piecewise3(t182, 0, t189)
  t192 = jnp.log(0.14285714285714285714285714285714285714285714285714e1 * DBL_EPSILON)
  t195 = (-t192 + 0.15e1) / t192
  t196 = t176 < -t195
  t197 = f.my_piecewise3(t196, -t195, t176)
  t198 = 0.1e1 - t197
  t201 = jnp.exp(0.15e1 / t198)
  t203 = f.my_piecewise3(t196, 0, -0.7e0 * t201)
  t204 = f.my_piecewise3(t177, t190, t203)
  t207 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t14 + 0.31385250000000000000000000000000000000000000000000e-1 * t11
  t208 = 0.1e1 / t207
  t211 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t208)
  t212 = t211 - 0.1e1
  t213 = t167 * t171
  t214 = t54 ** 2
  t219 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t213 * t214 * t119 * t163
  t220 = t219 ** (0.1e1 / 0.4e1)
  t222 = 0.1e1 - 0.1e1 / t220
  t224 = t212 * t222 + 0.1e1
  t225 = jnp.log(t224)
  t227 = -0.285764e-1 * t208 + 0.285764e-1 * t225
  t229 = 0.2363e1 * t54 - 0.2363e1
  t232 = -t229 * t53 * t57 + 0.1e1
  t233 = t227 * t232
  t234 = t34 ** 2
  t235 = t234 * t34
  t236 = t36 ** 2
  t238 = 0.1e1 / t236 / t36
  t240 = -t235 * t238 + 0.1e1
  t242 = t233 * t240 - t141 + t31 - t84 - t86
  t243 = t204 * t242
  t245 = 0.1e1 / t8 / t7
  t246 = t6 * t245
  t249 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t246 * t30
  t250 = t27 ** 2
  t255 = t3 * t6
  t256 = t255 * t245
  t257 = 0.1e1 / t14 * t1 * t256
  t259 = t4 * t246
  t261 = t11 ** 0.5e0
  t263 = t261 * t1 * t256
  t268 = t21 * t5 / t22 / t7
  t273 = t13 / t250 * (-0.39359271665000000000000000000000000000000000000000e-1 * t257 - 0.18590165886666666666666666666666666666666666666667e-1 * t259 - 0.63665980925000000000000000000000000000000000000000e-2 * t263 - 0.51086165526666666666666666666666666666666666666667e-2 * t268) / t29
  t274 = t33 * t32
  t277 = 0.4e1 * t274 * t37 * t83
  t278 = t36 * t7
  t282 = 0.4e1 * t34 / t278 * t83
  t284 = t32 / t35
  t285 = t39 - t284
  t288 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t285)
  t289 = -t285
  t292 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t289)
  t294 = (t288 + t292) * t57
  t296 = t38 * t294 * t82
  t300 = t65 ** 2
  t314 = t76 ** 2
  t315 = 0.1e1 / t314
  t321 = -0.29149603883333333333333333333333333333333333333333e-1 * t257 - 0.10197154565000000000000000000000000000000000000000e-1 * t259 - 0.18581078242500000000000000000000000000000000000000e-2 * t263 - 0.27959640330000000000000000000000000000000000000000e-2 * t268
  t322 = 0.1e1 / t78
  t328 = t38 * t58 * (0.53237641966666666666666666666666666666666666666667e-3 * t4 * t246 * t68 + t60 / t300 * (-0.36580540352500000000000000000000000000000000000000e-1 * t257 - 0.16057569282500000000000000000000000000000000000000e-1 * t259 - 0.65410946462500000000000000000000000000000000000000e-2 * t263 - 0.32394954865000000000000000000000000000000000000000e-2 * t268) / t67 - t249 - t273 + 0.18311447306006545054854346104378990962041954983034e-3 * t4 * t246 * t79 + 0.58482236226346462072622386637590534819724553404281e0 * t71 * t315 * t321 * t322)
  t330 = 0.58482236226346462072622386637590534819724553404281e0 * t294 * t80
  t335 = 0.18311447306006545054854346104378990962041954983034e-3 * t58 * t1 * t255 * t245 * t79
  t340 = 0.58482236226346462072622386637590534819724553404281e0 * t58 * t71 * t315 * t321 * t322
  t341 = t99 * t139
  t342 = 0.1e1 / t45
  t345 = f.my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t342 * t285)
  t346 = 0.1e1 / t50
  t349 = f.my_piecewise3(t49, 0, 0.2e1 / 0.3e1 * t346 * t289)
  t351 = t345 / 0.2e1 + t349 / 0.2e1
  t354 = 0.3e1 * t91 * t341 * t351
  t356 = 0.1e1 / t134 / t133
  t357 = t35 * t7
  t359 = 0.1e1 / t22 / t357
  t361 = t107 * t89
  t363 = t116 * t119
  t364 = t54 * t125
  t367 = 0.27801896084645508333333333333333333333333333333333e-3 * t359 * t105 * t361 * t363 * t364
  t368 = t104 ** 2
  t376 = 0.74083333333333333333333333333333333333333333333333e-2 * t102 / t368 * t361 * t363 * t359 * t54 * t125
  t377 = t115 ** 2
  t382 = t108 * t89 / t377 * t119 * t123
  t383 = t364 * t19
  t384 = t127 * t5
  t388 = t99 ** 2
  t390 = t89 / t388
  t394 = -(t249 + t273 + t277 - t282 + t296 + t328 + t330 - t335 - t340) * t107 * t112 + 0.3e1 * t110 * t390 * t351
  t406 = 0.7e1 / 0.72e2 * t121 / t8 / t357 * t54 * t125 * t129
  t407 = t124 * t111
  t421 = 0.1e1 / t138
  t423 = t91 * t100 * (t356 * (-t367 + t376 - t382 * t383 * t384 * t394 * t114 / 0.24e2 - t406 - t121 * t407 * t128 * t5 * t351 / 0.12e2) * t115 / 0.4e1 + t136 * t394 * t114) * t421
  t424 = r0 ** 2
  t430 = t285 / 0.2e1
  t431 = t149 * t430
  t435 = -t159 * t430
  t438 = t119 * t359
  t439 = t438 / 0.3e1
  t443 = t172 ** 2
  t445 = t171 / t443
  t451 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau0 / t143 / t424 * t150 + 0.5e1 / 0.3e1 * t146 * t431 + 0.5e1 / 0.3e1 * t156 * t435 + t439) * t167 * t174 - 0.5e1 / 0.9e1 * t168 * t445 * (0.5e1 / 0.3e1 * t431 + 0.5e1 / 0.3e1 * t435)
  t452 = f.my_piecewise3(t183, t451, 0)
  t455 = t185 ** 2
  t457 = t184 / t455
  t462 = f.my_piecewise3(t182, 0, (-0.64e0 * t452 * t186 - 0.64e0 * t457 * t452) * t189)
  t463 = t198 ** 2
  t464 = 0.1e1 / t463
  t465 = f.my_piecewise3(t196, 0, t451)
  t469 = f.my_piecewise3(t196, 0, -0.105e1 * t464 * t465 * t201)
  t470 = f.my_piecewise3(t177, t462, t469)
  t472 = t207 ** 2
  t477 = 0.1e1 / t472 * (-0.74083333333333333333333333333333333333333333333333e-2 * t257 - 0.10461750000000000000000000000000000000000000000000e-1 * t259)
  t484 = t212 / t220 / t219
  t491 = 0.1e1 / t224
  t496 = (0.285764e-1 * t477 + 0.285764e-1 * (-0.10000000000000000000000000000000000000000000000000e1 * t477 * t211 * t222 - 0.14225094736250905555555555555555555555555555555555e-1 * t484 * t167 * t171 * t214 * t438) * t491) * t232 * t240
  t497 = t227 * t229
  t501 = t234 * t274 * t238
  t504 = t235 / t236 / t278
  t508 = t496 - t497 * t294 * t240 + t233 * (-0.12e2 * t501 + 0.12e2 * t504) - t249 - t273 - t277 + t282 - t296 - t328 - t330 + t335 + t340 - t354 - t423
  t510 = t204 * t508 + t470 * t242 + t249 + t273 + t277 - t282 + t296 + t328 + t330 - t335 - t340 + t354 + t423
  vrho_0_ = t7 * t510 + t141 + t243 - t31 + t84 + t86
  t512 = -t39 - t284
  t515 = f.my_piecewise3(t42, 0, 0.4e1 / 0.3e1 * t45 * t512)
  t516 = -t512
  t519 = f.my_piecewise3(t49, 0, 0.4e1 / 0.3e1 * t50 * t516)
  t521 = (t515 + t519) * t57
  t523 = t38 * t521 * t82
  t525 = 0.58482236226346462072622386637590534819724553404281e0 * t521 * t80
  t528 = f.my_piecewise3(t42, 0, 0.2e1 / 0.3e1 * t342 * t512)
  t531 = f.my_piecewise3(t49, 0, 0.2e1 / 0.3e1 * t346 * t516)
  t533 = t528 / 0.2e1 + t531 / 0.2e1
  t536 = 0.3e1 * t91 * t341 * t533
  t543 = -(t249 + t273 - t277 - t282 + t523 + t328 + t525 - t335 - t340) * t107 * t112 + 0.3e1 * t110 * t390 * t533
  t563 = t91 * t100 * (t356 * (-t367 + t376 - t382 * t383 * t384 * t543 * t114 / 0.24e2 - t406 - t121 * t407 * t128 * t5 * t533 / 0.12e2) * t115 / 0.4e1 + t136 * t543 * t114) * t421
  t564 = t512 / 0.2e1
  t565 = t149 * t564
  t568 = r1 ** 2
  t575 = -t159 * t564
  t586 = 0.5e1 / 0.9e1 * (0.5e1 / 0.3e1 * t146 * t565 - 0.5e1 / 0.3e1 * tau1 / t153 / t568 * t160 + 0.5e1 / 0.3e1 * t156 * t575 + t439) * t167 * t174 - 0.5e1 / 0.9e1 * t168 * t445 * (0.5e1 / 0.3e1 * t565 + 0.5e1 / 0.3e1 * t575)
  t587 = f.my_piecewise3(t183, t586, 0)
  t594 = f.my_piecewise3(t182, 0, (-0.64e0 * t587 * t186 - 0.64e0 * t457 * t587) * t189)
  t595 = f.my_piecewise3(t196, 0, t586)
  t599 = f.my_piecewise3(t196, 0, -0.105e1 * t464 * t595 * t201)
  t600 = f.my_piecewise3(t177, t594, t599)
  t607 = t496 - t497 * t521 * t240 + t233 * (0.12e2 * t501 + 0.12e2 * t504) - t249 - t273 + t277 + t282 - t523 - t328 - t525 + t335 + t340 - t536 - t563
  t609 = t204 * t607 + t600 * t242 + t249 + t273 - t277 - t282 + t328 - t335 - t340 + t523 + t525 + t536 + t563
  vrho_1_ = t7 * t609 + t141 + t243 - t31 + t84 + t86
  t617 = t98 * t356 * t106 * t123 * t54 * t19 * t384 * t421
  t618 = t617 / 0.96e2
  t620 = t163 * t167 * t174
  t621 = 0.5e1 / 0.72e2 * t620
  t622 = f.my_piecewise3(t183, -t621, 0)
  t629 = f.my_piecewise3(t182, 0, (-0.64e0 * t622 * t186 - 0.64e0 * t457 * t622) * t189)
  t630 = f.my_piecewise3(t196, 0, -t621)
  t634 = f.my_piecewise3(t196, 0, -0.105e1 * t464 * t630 * t201)
  t635 = f.my_piecewise3(t177, t629, t634)
  t642 = t484 * t213 * t214 * t163 * t491 * t232 * t240
  vsigma_0_ = t7 * (t618 + t635 * t242 + t204 * (0.15243824895787514156916666666666666666666666666666e-3 * t642 - t618))
  t647 = t617 / 0.48e2
  t648 = 0.5e1 / 0.36e2 * t620
  t649 = f.my_piecewise3(t183, -t648, 0)
  t656 = f.my_piecewise3(t182, 0, (-0.64e0 * t649 * t186 - 0.64e0 * t457 * t649) * t189)
  t657 = f.my_piecewise3(t196, 0, -t648)
  t661 = f.my_piecewise3(t196, 0, -0.105e1 * t464 * t657 * t201)
  t662 = f.my_piecewise3(t177, t656, t661)
  vsigma_1_ = t7 * (t647 + t662 * t242 + t204 * (0.30487649791575028313833333333333333333333333333331e-3 * t642 - t647))
  vsigma_2_ = vsigma_0_
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t669 = t213 * t173
  t671 = 0.5e1 / 0.9e1 * t145 * t150 * t669
  t672 = f.my_piecewise3(t183, t671, 0)
  t679 = f.my_piecewise3(t182, 0, (-0.64e0 * t672 * t186 - 0.64e0 * t457 * t672) * t189)
  t680 = f.my_piecewise3(t196, 0, t671)
  t684 = f.my_piecewise3(t196, 0, -0.105e1 * t464 * t680 * t201)
  t685 = f.my_piecewise3(t177, t679, t684)
  vtau_0_ = t7 * t685 * t242
  t689 = 0.5e1 / 0.9e1 * t155 * t160 * t669
  t690 = f.my_piecewise3(t183, t689, 0)
  t697 = f.my_piecewise3(t182, 0, (-0.64e0 * t690 * t186 - 0.64e0 * t457 * t690) * t189)
  t698 = f.my_piecewise3(t196, 0, t689)
  t702 = f.my_piecewise3(t196, 0, -0.105e1 * t464 * t698 * t201)
  t703 = f.my_piecewise3(t177, t697, t702)
  vtau_1_ = t7 * t703 * t242
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  params_gamma = (1 - jnp.log(2)) / jnp.pi ** 2

  tp = lambda rs, z, xt: f.tt(rs, z, xt)

  beta_a = 0.06672455060314922

  beta_b = 0.1

  beta_c = 0.1778

  scan_alpha = lambda z, xt, ts0, ts1: (f.t_total(z, ts0, ts1) - xt ** 2 / 8) / (K_FACTOR_C * f.t_total(z, 1, 1))

  scan_b1c = 0.0285764

  scan_b2c = 0.0889

  scan_b3c = 0.125541

  scan_chi_infty = 0.12802585262625815

  scan_G_cnst = 2.363

  params_c1 = 0.64

  params_c2 = 1.5

  params_d = 0.7

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  mgamma = params_gamma

  mbeta = lambda rs, t=None: beta_a * (1 + beta_b * rs) / (1 + beta_c * rs)

  scan_eclda0 = lambda rs: -scan_b1c / (1 + scan_b2c * jnp.sqrt(rs) + scan_b3c * rs)

  scan_g_infty = lambda s: 1 / (1 + 4 * scan_chi_infty * s ** 2) ** (1 / 4)

  scan_Gc = lambda z: (1 - scan_G_cnst * (2 ** (1 / 3) - 1) * f.f_zeta(z)) * (1 - z ** 12)

  scan_f_alpha_left0 = lambda a: jnp.exp(-params_c1 * a / (1 - a))

  scan_f_alpha_left_cutoff = -jnp.log(DBL_EPSILON) / (-jnp.log(DBL_EPSILON) + params_c1)

  scan_f_alpha_right0 = lambda a: -params_d * jnp.exp(params_c2 / (1 - a))

  scan_f_alpha_right_cutoff = (-jnp.log(DBL_EPSILON / jnp.abs(params_d)) + params_c2) / -jnp.log(DBL_EPSILON / jnp.abs(params_d))

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  scan_H0 = lambda rs, s: scan_b1c * jnp.log(1 + (jnp.exp(-scan_eclda0(rs) / scan_b1c) - 1) * (1 - scan_g_infty(s)))

  scan_f_alpha_left = lambda a: f.my_piecewise3(a > scan_f_alpha_left_cutoff, 0, scan_f_alpha_left0(jnp.minimum(scan_f_alpha_left_cutoff, a)))

  scan_f_alpha_right = lambda a: f.my_piecewise3(a < scan_f_alpha_right_cutoff, 0, scan_f_alpha_right0(jnp.maximum(scan_f_alpha_right_cutoff, a)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  scan_e0 = lambda rs, z, s: (scan_eclda0(rs) + scan_H0(rs, s)) * scan_Gc(z)

  scan_f_alpha = lambda a: f.my_piecewise3(a <= 1, scan_f_alpha_left(a), scan_f_alpha_right(a))

  A = lambda rs, z, t: mbeta(rs, t) / (mgamma * (jnp.exp(-f_pw(rs, z) / (mgamma * f.mphi(z) ** 3)) - 1))

  scan_e0_g = lambda rs, z, t: (1 + 4 * A(rs, z, t) * t ** 2) ** (-1 / 4)

  f2 = lambda rs, z, t: mbeta(rs, t) * (1 - scan_e0_g(rs, z, t)) / (mgamma * A(rs, z, t))

  fH = lambda rs, z, t: mgamma * f.mphi(z) ** 3 * jnp.log(1 + f2(rs, z, t))

  f_pbe = lambda rs, z, xt, xs0=None, xs1=None: f_pw(rs, z) + fH(rs, z, tp(rs, z, xt))

  scan_f = lambda rs, z, xt, xs0, xs1, ts0, ts1: f_pbe(rs, z, xt, xs0, xs1) + scan_f_alpha(scan_alpha(z, xt, ts0, ts1)) * (+scan_e0(rs, z, X2S * 2 ** (1 / 3) * xt) - f_pbe(rs, z, xt, xs0, xs1))

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: scan_f(rs, z, xt, xs0, xs1, ts0, ts1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t10 = t4 * t6 / t7
  t12 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t24 = t20 * t5 / t21
  t26 = 0.23615562999000000000000000000000000000000000000000e0 * t13 + 0.55770497660000000000000000000000000000000000000000e-1 * t10 + 0.12733196185000000000000000000000000000000000000000e-1 * t16 + 0.76629248290000000000000000000000000000000000000000e-2 * t24
  t28 = 0.1e1 + 0.1e1 / t26
  t29 = jnp.log(t28)
  t30 = t12 * t29
  t31 = 0.1e1 <= f.p.zeta_threshold
  t32 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t34 = f.my_piecewise3(t31, t32 * f.p.zeta_threshold, 1)
  t36 = 0.2e1 * t34 - 0.2e1
  t37 = 2 ** (0.1e1 / 0.3e1)
  t40 = 0.1e1 / (0.2e1 * t37 - 0.2e1)
  t41 = t36 * t40
  t43 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t10
  t48 = 0.17489762330000000000000000000000000000000000000000e0 * t13 + 0.30591463695000000000000000000000000000000000000000e-1 * t10 + 0.37162156485000000000000000000000000000000000000000e-2 * t16 + 0.41939460495000000000000000000000000000000000000000e-2 * t24
  t50 = 0.1e1 + 0.1e1 / t48
  t51 = jnp.log(t50)
  t54 = 0.58482236226346462072622386637590534819724553404281e0 * t41 * t43 * t51
  t55 = jnp.log(0.2e1)
  t56 = 0.1e1 - t55
  t57 = jnp.pi ** 2
  t59 = t56 / t57
  t60 = t32 ** 2
  t61 = f.my_piecewise3(t31, t60, 1)
  t62 = t61 ** 2
  t63 = t62 * t61
  t65 = 0.66724550603149220e-1 + 0.16681137650787305000000000000000000000000000000000e-2 * t10
  t67 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t10
  t68 = 0.1e1 / t67
  t69 = t65 * t68
  t70 = 0.1e1 / t56
  t75 = t57 / t63
  t77 = jnp.exp(-(-t30 + t54) * t70 * t75)
  t78 = t77 - 0.1e1
  t79 = 0.1e1 / t78
  t82 = t69 * t70 * t57 * t79 * s0
  t83 = r0 ** 2
  t85 = 0.1e1 / t7 / t83
  t87 = 0.1e1 / t62
  t89 = 0.1e1 / t3
  t91 = t18 * t89 * t5
  t95 = 0.1e1 + t82 * t85 * t37 * t87 * t91 / 0.24e2
  t96 = t95 ** (0.1e1 / 0.4e1)
  t98 = 0.1e1 - 0.1e1 / t96
  t100 = t98 * t78 + 0.1e1
  t101 = jnp.log(t100)
  t103 = t59 * t63 * t101
  t105 = 0.1e1 / t21 / r0
  t108 = 0.1e1 / t21 / t83
  t112 = 6 ** (0.1e1 / 0.3e1)
  t114 = t57 ** (0.1e1 / 0.3e1)
  t115 = t114 ** 2
  t116 = 0.1e1 / t115
  t117 = t37 ** 2
  t118 = t116 * t117
  t120 = 0.5e1 / 0.9e1 * (tau0 * t105 - s0 * t108 / 0.8e1) * t112 * t118
  t121 = t120 <= 0.1e1
  t122 = jnp.log(DBL_EPSILON)
  t125 = t122 / (-t122 + 0.64e0)
  t126 = -t125 < t120
  t127 = t120 < -t125
  t128 = f.my_piecewise3(t127, t120, -t125)
  t129 = 0.1e1 - t128
  t130 = 0.1e1 / t129
  t133 = jnp.exp(-0.64e0 * t128 * t130)
  t134 = f.my_piecewise3(t126, 0, t133)
  t136 = jnp.log(0.14285714285714285714285714285714285714285714285714e1 * DBL_EPSILON)
  t139 = (-t136 + 0.15e1) / t136
  t140 = t120 < -t139
  t141 = f.my_piecewise3(t140, -t139, t120)
  t142 = 0.1e1 - t141
  t145 = jnp.exp(0.15e1 / t142)
  t147 = f.my_piecewise3(t140, 0, -0.7e0 * t145)
  t148 = f.my_piecewise3(t121, t134, t147)
  t151 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t13 + 0.31385250000000000000000000000000000000000000000000e-1 * t10
  t152 = 0.1e1 / t151
  t155 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t152)
  t156 = t155 - 0.1e1
  t162 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t112 * t116 * t117 * s0 * t108
  t163 = t162 ** (0.1e1 / 0.4e1)
  t165 = 0.1e1 - 0.1e1 / t163
  t167 = t156 * t165 + 0.1e1
  t168 = jnp.log(t167)
  t175 = 0.1e1 - (0.2363e1 * t37 - 0.2363e1) * t36 * t40
  t177 = (-0.285764e-1 * t152 + 0.285764e-1 * t168) * t175 + t30 - t54 - t103
  t180 = 0.1e1 / t7 / r0
  t181 = t6 * t180
  t184 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t181 * t29
  t185 = t26 ** 2
  t190 = t3 * t6
  t191 = t190 * t180
  t192 = 0.1e1 / t13 * t1 * t191
  t194 = t4 * t181
  t196 = t10 ** 0.5e0
  t198 = t196 * t1 * t191
  t201 = t20 * t5 * t105
  t206 = t12 / t185 * (-0.39359271665000000000000000000000000000000000000000e-1 * t192 - 0.18590165886666666666666666666666666666666666666667e-1 * t194 - 0.63665980925000000000000000000000000000000000000000e-2 * t198 - 0.51086165526666666666666666666666666666666666666667e-2 * t201) / t28
  t211 = 0.18311447306006545054854346104378990962041954983034e-3 * t41 * t1 * t190 * t180 * t51
  t213 = t48 ** 2
  t224 = 0.58482236226346462072622386637590534819724553404281e0 * t41 * t43 / t213 * (-0.29149603883333333333333333333333333333333333333333e-1 * t192 - 0.10197154565000000000000000000000000000000000000000e-1 * t194 - 0.18581078242500000000000000000000000000000000000000e-2 * t198 - 0.27959640330000000000000000000000000000000000000000e-2 * t201) / t50
  t226 = 0.1e1 / t96 / t95
  t227 = t83 * r0
  t229 = 0.1e1 / t21 / t227
  t231 = t70 * t57
  t233 = t79 * s0
  t238 = t67 ** 2
  t247 = t56 ** 2
  t250 = t57 ** 2
  t251 = t78 ** 2
  t257 = t62 ** 2
  t262 = t89 * t5
  t263 = t184 + t206 - t211 - t224
  t286 = 0.1e1 / t100
  t288 = t59 * t63 * (t226 * (-0.27801896084645508333333333333333333333333333333333e-3 * t229 * t68 * t231 * t233 * t37 * t87 + 0.74083333333333333333333333333333333333333333333333e-2 * t65 / t238 * t231 * t233 * t229 * t37 * t87 + t69 / t247 * t250 / t251 * s0 * t85 * t37 / t257 / t61 * t18 * t262 * t263 * t77 / 0.24e2 - 0.7e1 / 0.72e2 * t82 / t7 / t227 * t37 * t87 * t91) * t78 / 0.4e1 - t98 * t263 * t70 * t75 * t77) * t286
  t291 = s0 * t229
  t296 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau0 * t108 + t291 / 0.3e1) * t112 * t118
  t297 = f.my_piecewise3(t127, t296, 0)
  t300 = t129 ** 2
  t302 = t128 / t300
  t307 = f.my_piecewise3(t126, 0, (-0.64e0 * t297 * t130 - 0.64e0 * t302 * t297) * t133)
  t308 = t142 ** 2
  t309 = 0.1e1 / t308
  t310 = f.my_piecewise3(t140, 0, t296)
  t314 = f.my_piecewise3(t140, 0, -0.105e1 * t309 * t310 * t145)
  t315 = f.my_piecewise3(t121, t307, t314)
  t317 = t151 ** 2
  t322 = 0.1e1 / t317 * (-0.74083333333333333333333333333333333333333333333333e-2 * t192 - 0.10461750000000000000000000000000000000000000000000e-1 * t194)
  t329 = t156 / t163 / t162
  t335 = 0.1e1 / t167
  vrho_0_ = -t30 + t54 + t103 + t148 * t177 + r0 * (t184 + t206 - t211 - t224 + t288 + t315 * t177 + t148 * ((0.285764e-1 * t322 + 0.285764e-1 * (-0.10000000000000000000000000000000000000000000000000e1 * t322 * t155 * t165 - 0.14225094736250905555555555555555555555555555555555e-1 * t329 * t112 * t118 * t291) * t335) * t175 - t184 - t206 + t211 + t224 - t288))
  t351 = t61 * t226 * t69 * t85 * t37 * t18 * t262 * t286 / 0.96e2
  t352 = t108 * t112
  t354 = 0.5e1 / 0.72e2 * t352 * t118
  t355 = f.my_piecewise3(t127, -t354, 0)
  t362 = f.my_piecewise3(t126, 0, (-0.64e0 * t355 * t130 - 0.64e0 * t302 * t355) * t133)
  t363 = f.my_piecewise3(t140, 0, -t354)
  t367 = f.my_piecewise3(t140, 0, -0.105e1 * t309 * t363 * t145)
  t368 = f.my_piecewise3(t121, t362, t367)
  vsigma_0_ = r0 * (t351 + t368 * t177 + t148 * (0.15243824895787514156916666666666666666666666666666e-3 * t329 * t352 * t118 * t335 * t175 - t351))
  vlapl_0_ = 0.0e0
  t380 = 0.5e1 / 0.9e1 * t105 * t112 * t118
  t381 = f.my_piecewise3(t127, t380, 0)
  t388 = f.my_piecewise3(t126, 0, (-0.64e0 * t381 * t130 - 0.64e0 * t302 * t381) * t133)
  t389 = f.my_piecewise3(t140, 0, t380)
  t393 = f.my_piecewise3(t140, 0, -0.105e1 * t309 * t389 * t145)
  t394 = f.my_piecewise3(t121, t388, t393)
  vtau_0_ = r0 * t394 * t177
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t9 = 0.1e1 / t7 / r0
  t10 = t6 * t9
  t13 = t4 * t6 / t7
  t14 = jnp.sqrt(t13)
  t17 = t13 ** 0.15e1
  t19 = t1 ** 2
  t20 = t3 ** 2
  t21 = t19 * t20
  t22 = t7 ** 2
  t25 = t21 * t5 / t22
  t27 = 0.37978500000000000000000000000000000000000000000000e1 * t14 + 0.89690000000000000000000000000000000000000000000000e0 * t13 + 0.20477500000000000000000000000000000000000000000000e0 * t17 + 0.12323500000000000000000000000000000000000000000000e0 * t25
  t30 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t27
  t31 = jnp.log(t30)
  t33 = t4 * t10 * t31
  t36 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t13
  t37 = t27 ** 2
  t38 = 0.1e1 / t37
  t39 = t36 * t38
  t41 = 0.1e1 / t14 * t1
  t42 = t3 * t6
  t43 = t42 * t9
  t44 = t41 * t43
  t46 = t4 * t10
  t48 = t13 ** 0.5e0
  t49 = t48 * t1
  t50 = t49 * t43
  t53 = 0.1e1 / t22 / r0
  t55 = t21 * t5 * t53
  t57 = -0.63297500000000000000000000000000000000000000000000e0 * t44 - 0.29896666666666666666666666666666666666666666666667e0 * t46 - 0.10238750000000000000000000000000000000000000000000e0 * t50 - 0.82156666666666666666666666666666666666666666666667e-1 * t55
  t58 = 0.1e1 / t30
  t59 = t57 * t58
  t60 = t39 * t59
  t62 = 0.1e1 <= f.p.zeta_threshold
  t63 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t65 = f.my_piecewise3(t62, t63 * f.p.zeta_threshold, 1)
  t67 = 0.2e1 * t65 - 0.2e1
  t68 = 2 ** (0.1e1 / 0.3e1)
  t69 = t68 - 0.1e1
  t71 = 0.1e1 / t69 / 0.2e1
  t72 = t67 * t71
  t73 = t72 * t1
  t78 = 0.51785000000000000000000000000000000000000000000000e1 * t14 + 0.90577500000000000000000000000000000000000000000000e0 * t13 + 0.11003250000000000000000000000000000000000000000000e0 * t17 + 0.12417750000000000000000000000000000000000000000000e0 * t25
  t81 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t78
  t82 = jnp.log(t81)
  t85 = t73 * t42 * t9 * t82
  t88 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t13
  t89 = t72 * t88
  t90 = t78 ** 2
  t91 = 0.1e1 / t90
  t96 = -0.86308333333333333333333333333333333333333333333334e0 * t44 - 0.30192500000000000000000000000000000000000000000000e0 * t46 - 0.55016250000000000000000000000000000000000000000000e-1 * t50 - 0.82785000000000000000000000000000000000000000000000e-1 * t55
  t98 = 0.1e1 / t81
  t99 = t91 * t96 * t98
  t100 = t89 * t99
  t102 = jnp.log(0.2e1)
  t103 = 0.1e1 - t102
  t104 = jnp.pi ** 2
  t106 = t103 / t104
  t107 = t63 ** 2
  t108 = f.my_piecewise3(t62, t107, 1)
  t109 = t108 ** 2
  t110 = t109 * t108
  t112 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e-1 * t13
  t114 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t13
  t115 = 0.1e1 / t114
  t116 = t112 * t115
  t117 = 0.1e1 / t103
  t120 = 0.621814e-1 * t36 * t31
  t123 = 0.19751673498613801407483339618206552048944131217655e-1 * t72 * t88 * t82
  t126 = 0.1e1 / t110
  t127 = t104 * t126
  t129 = jnp.exp(-(-t120 + t123) * t117 * t127)
  t130 = t129 - 0.1e1
  t131 = 0.1e1 / t130
  t133 = t104 * t131 * s0
  t134 = t116 * t117 * t133
  t135 = r0 ** 2
  t137 = 0.1e1 / t7 / t135
  t139 = 0.1e1 / t109
  t141 = 0.1e1 / t3
  t143 = t19 * t141 * t5
  t147 = 0.1e1 + 0.27801896084645508333333333333333333333333333333333e-2 * t134 * t137 * t68 * t139 * t143
  t148 = t147 ** (0.1e1 / 0.4e1)
  t150 = 0.1e1 / t148 / t147
  t151 = t135 * r0
  t153 = 0.1e1 / t22 / t151
  t154 = t153 * t115
  t155 = t117 * t104
  t157 = t131 * s0
  t159 = t157 * t68 * t139
  t162 = t114 ** 2
  t163 = 0.1e1 / t162
  t164 = t112 * t163
  t165 = t164 * t155
  t171 = t103 ** 2
  t172 = 0.1e1 / t171
  t173 = t116 * t172
  t174 = t104 ** 2
  t175 = t130 ** 2
  t176 = 0.1e1 / t175
  t177 = t174 * t176
  t178 = s0 * t137
  t180 = t173 * t177 * t178
  t181 = t109 ** 2
  t183 = 0.1e1 / t181 / t108
  t185 = t68 * t183 * t19
  t186 = t141 * t5
  t187 = 0.11073470983333333333333333333333333333333333333333e-2 * t33
  t188 = 0.10000000000000000000000000000000000000000000000000e1 * t60
  t189 = 0.18311447306006545054854346104378990962041954983034e-3 * t85
  t190 = 0.58482236226346462072622386637590534819724553404280e0 * t100
  t191 = t187 + t188 - t189 - t190
  t194 = t185 * t186 * t191 * t129
  t198 = 0.1e1 / t7 / t151
  t204 = -0.27801896084645508333333333333333333333333333333333e-3 * t154 * t155 * t159 + 0.49431771238499713816666666666666666666666666666666e-3 * t165 * t157 * t153 * t68 * t139 + 0.27801896084645508333333333333333333333333333333333e-2 * t180 * t194 - 0.64871090864172852777777777777777777777777777777777e-2 * t134 * t198 * t68 * t139 * t143
  t205 = t150 * t204
  t209 = 0.1e1 - 0.1e1 / t148
  t212 = t127 * t129
  t215 = 0.25000000000000000000000000000000000000000000000000e0 * t205 * t130 - 0.10000000000000000000000000000000000000000000000000e1 * t209 * t191 * t117 * t212
  t219 = 0.1e1 + 0.10000000000000000000000000000000000000000000000000e1 * t209 * t130
  t220 = 0.1e1 / t219
  t222 = t106 * t110 * t215 * t220
  t226 = 0.1e1 / t22 / t135
  t230 = 6 ** (0.1e1 / 0.3e1)
  t232 = t104 ** (0.1e1 / 0.3e1)
  t233 = t232 ** 2
  t234 = 0.1e1 / t233
  t235 = t68 ** 2
  t236 = t234 * t235
  t238 = 0.5e1 / 0.9e1 * (tau0 * t53 - s0 * t226 / 0.8e1) * t230 * t236
  t239 = t238 <= 0.1e1
  t240 = jnp.log(DBL_EPSILON)
  t243 = t240 / (-t240 + 0.64e0)
  t244 = -t243 < t238
  t245 = t238 < -t243
  t248 = s0 * t153
  t253 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau0 * t226 + t248 / 0.3e1) * t230 * t236
  t254 = f.my_piecewise3(t245, t253, 0)
  t255 = f.my_piecewise3(t245, t238, -t243)
  t256 = 0.1e1 - t255
  t257 = 0.1e1 / t256
  t260 = t256 ** 2
  t261 = 0.1e1 / t260
  t262 = t255 * t261
  t265 = -0.64e0 * t254 * t257 - 0.64e0 * t262 * t254
  t268 = jnp.exp(-0.64e0 * t255 * t257)
  t270 = f.my_piecewise3(t244, 0, t265 * t268)
  t272 = jnp.log(0.14285714285714285714285714285714285714285714285714e1 * DBL_EPSILON)
  t275 = (-t272 + 0.15e1) / t272
  t276 = t238 < -t275
  t277 = f.my_piecewise3(t276, -t275, t238)
  t278 = 0.1e1 - t277
  t279 = t278 ** 2
  t280 = 0.1e1 / t279
  t281 = f.my_piecewise3(t276, 0, t253)
  t285 = jnp.exp(0.15e1 / t278)
  t288 = f.my_piecewise3(t276, 0, -0.105e1 * t280 * t281 * t285)
  t289 = f.my_piecewise3(t239, t270, t288)
  t292 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t14 + 0.31385250000000000000000000000000000000000000000000e-1 * t13
  t293 = 0.1e1 / t292
  t296 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t293)
  t297 = t296 - 0.1e1
  t298 = t230 * t234
  t299 = t235 * s0
  t303 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t298 * t299 * t226
  t304 = t303 ** (0.1e1 / 0.4e1)
  t306 = 0.1e1 - 0.1e1 / t304
  t308 = t297 * t306 + 0.1e1
  t309 = jnp.log(t308)
  t315 = 0.1e1 - 0.2363e1 * t69 * t67 * t71
  t317 = jnp.log(t219)
  t320 = (-0.285764e-1 * t293 + 0.285764e-1 * t309) * t315 + t120 - t123 - t106 * t110 * t317
  t323 = f.my_piecewise3(t244, 0, t268)
  t325 = f.my_piecewise3(t276, 0, -0.7e0 * t285)
  t326 = f.my_piecewise3(t239, t323, t325)
  t327 = t292 ** 2
  t328 = 0.1e1 / t327
  t331 = -0.74083333333333333333333333333333333333333333333333e-2 * t44 - 0.10461750000000000000000000000000000000000000000000e-1 * t46
  t332 = t328 * t331
  t334 = t296 * t306
  t338 = 0.1e1 / t304 / t303
  t340 = t297 * t338 * t230
  t344 = -0.10000000000000000000000000000000000000000000000000e1 * t332 * t334 - 0.14225094736250905555555555555555555555555555555555e-1 * t340 * t236 * t248
  t345 = 0.1e1 / t308
  t350 = (0.285764e-1 * t332 + 0.285764e-1 * t344 * t345) * t315 - t187 - t188 + t189 + t190 - t222
  t353 = t6 * t137
  t356 = 0.14764627977777777777777777777777777777777777777777e-2 * t4 * t353 * t31
  t357 = t4 * t6
  t361 = 0.35616666666666666666666666666666666666666666666666e-1 * t357 * t9 * t38 * t59
  t365 = t57 ** 2
  t368 = 0.20000000000000000000000000000000000000000000000000e1 * t36 / t37 / t27 * t365 * t58
  t373 = t20 * t5 * t226
  t374 = 0.1e1 / t14 / t13 * t19 * t373
  t376 = t42 * t137
  t377 = t41 * t376
  t379 = t4 * t353
  t381 = t13 ** (-0.5e0)
  t383 = t381 * t19 * t373
  t385 = t49 * t376
  t388 = t21 * t5 * t226
  t393 = 0.10000000000000000000000000000000000000000000000000e1 * t39 * (-0.42198333333333333333333333333333333333333333333333e0 * t374 + 0.84396666666666666666666666666666666666666666666666e0 * t377 + 0.39862222222222222222222222222222222222222222222223e0 * t379 + 0.68258333333333333333333333333333333333333333333333e-1 * t383 + 0.13651666666666666666666666666666666666666666666667e0 * t385 + 0.13692777777777777777777777777777777777777777777778e0 * t388) * t58
  t394 = t37 ** 2
  t397 = t30 ** 2
  t401 = 0.16081979498692535066756296899072713062105388428051e2 * t36 / t394 * t365 / t397
  t405 = 0.24415263074675393406472461472505321282722606644045e-3 * t73 * t42 * t137 * t82
  t409 = 0.10843581300301739842632067522386578331157260943710e-1 * t72 * t4 * t10 * t99
  t412 = t96 ** 2
  t416 = 0.11696447245269292414524477327518106963944910680856e1 * t89 / t90 / t78 * t412 * t98
  t427 = 0.58482236226346462072622386637590534819724553404280e0 * t89 * t91 * (-0.57538888888888888888888888888888888888888888888889e0 * t374 + 0.11507777777777777777777777777777777777777777777778e1 * t377 + 0.40256666666666666666666666666666666666666666666667e0 * t379 + 0.36677500000000000000000000000000000000000000000000e-1 * t383 + 0.73355000000000000000000000000000000000000000000000e-1 * t385 + 0.13797500000000000000000000000000000000000000000000e0 * t388) * t98
  t428 = t90 ** 2
  t431 = t81 ** 2
  t435 = 0.17315859105681463759666483083807725165579399831905e2 * t89 / t428 * t412 / t431
  t436 = t147 ** 2
  t439 = t204 ** 2
  t443 = t135 ** 2
  t445 = 0.1e1 / t22 / t443
  t451 = 0.1e1 / t443 / r0
  t455 = s0 * t68
  t461 = t172 * t174 * t176
  t464 = t183 * t191 * t129
  t490 = t116 / t171 / t103
  t491 = t174 * t104
  t497 = t181 ** 2
  t500 = t68 / t497 * t19
  t501 = t191 ** 2
  t502 = t129 ** 2
  t513 = -t356 - t361 - t368 + t393 + t401 + t405 + t409 + t416 - t427 - t435
  t534 = 0.16681137650787305000000000000000000000000000000000e-2 * t445 * t115 * t155 * t159 - 0.82386285397499523027777777777777777777777777777777e-5 * t451 * t163 * t155 * t131 * t455 * t139 * t357 - 0.55603792169291016666666666666666666666666666666666e-3 * t154 * t461 * t455 * t464 + 0.14648281543675415194338888888888888888888888888889e-4 * t112 / t162 / t114 * t117 * t133 * t451 * t68 * t139 * t357 + 0.98863542476999427633333333333333333333333333333332e-3 * t164 * t461 * t248 * t68 * t464 - 0.29659062743099828290000000000000000000000000000000e-2 * t165 * t157 * t445 * t68 * t139 + 0.55603792169291016666666666666666666666666666666666e-2 * t490 * t491 / t175 / t130 * t178 * t500 * t186 * t501 * t502 - 0.12974218172834570555555555555555555555555555555555e-1 * t173 * t177 * s0 * t198 * t194 + 0.27801896084645508333333333333333333333333333333333e-2 * t180 * t185 * t186 * t513 * t129 - 0.27801896084645508333333333333333333333333333333333e-2 * t490 * t491 * t176 * t178 * t500 * t186 * t501 * t129 + 0.21623696954724284259259259259259259259259259259259e-1 * t134 / t7 / t443 * t68 * t139 * t143
  t558 = t106 * t110 * (-0.31250000000000000000000000000000000000000000000000e0 / t148 / t436 * t439 * t130 + 0.25000000000000000000000000000000000000000000000000e0 * t150 * t534 * t130 - 0.50000000000000000000000000000000000000000000000000e0 * t205 * t191 * t155 * t126 * t129 - 0.10000000000000000000000000000000000000000000000000e1 * t209 * t513 * t117 * t212 + 0.10000000000000000000000000000000000000000000000000e1 * t209 * t501 * t172 * t174 / t181 / t109 * t129) * t220
  t559 = t215 ** 2
  t561 = t219 ** 2
  t564 = t106 * t110 * t559 / t561
  t567 = s0 * t445
  t572 = 0.5e1 / 0.9e1 * (0.40e2 / 0.9e1 * tau0 * t153 - 0.11e2 / 0.9e1 * t567) * t230 * t236
  t573 = f.my_piecewise3(t245, t572, 0)
  t576 = t254 ** 2
  t588 = t265 ** 2
  t591 = f.my_piecewise3(t244, 0, (-0.64e0 * t573 * t257 - 0.128e1 * t576 * t261 - 0.128e1 * t255 / t260 / t256 * t576 - 0.64e0 * t262 * t573) * t268 + t588 * t268)
  t594 = t281 ** 2
  t598 = f.my_piecewise3(t276, 0, t572)
  t602 = t279 ** 2
  t608 = f.my_piecewise3(t276, 0, -0.210e1 / t279 / t278 * t594 * t285 - 0.105e1 * t280 * t598 * t285 - 0.1575e1 / t602 * t594 * t285)
  t609 = f.my_piecewise3(t239, t591, t608)
  t615 = t331 ** 2
  t616 = 0.1e1 / t327 / t292 * t615
  t622 = t328 * (-0.49388888888888888888888888888888888888888888888889e-2 * t374 + 0.98777777777777777777777777777777777777777777777777e-2 * t377 + 0.13949000000000000000000000000000000000000000000000e-1 * t379)
  t628 = t327 ** 2
  t639 = t303 ** 2
  t643 = t230 ** 2
  t648 = s0 ** 2
  t662 = t344 ** 2
  t663 = t308 ** 2
  t669 = (-0.571528e-1 * t616 + 0.285764e-1 * t622 + 0.285764e-1 * (0.20000000000000000000000000000000000000000000000000e1 * t616 * t334 - 0.10000000000000000000000000000000000000000000000000e1 * t622 * t334 + 0.10000000000000000000000000000000000000000000000000e1 / t628 * t615 * t334 + 0.28450189472501811111111111111111111111111111111110e-1 * t332 * t296 * t338 * t298 * t299 * t153 - 0.20235332025531322029119593137558641975308641975307e-2 * t297 / t304 / t639 * t643 / t232 / t104 * t68 * t648 / t7 / t443 / t151 + 0.52158680699586653703703703703703703703703703703702e-1 * t340 * t236 * t567) * t345 - 0.285764e-1 * t662 / t663) * t315 + t356 + t361 + t368 - t393 - t401 - t405 - t409 - t416 + t427 + t435 - t558 + t564
  t671 = 0.2e1 * t289 * t350 + t609 * t320 + t326 * t669 - t356 - t361 - t368 + t393 + t401 + t405 + t409 + t416 - t427 - t435 + t558 - t564
  v2rho2_0_ = 0.22146941966666666666666666666666666666666666666666e-2 * t33 + 0.20000000000000000000000000000000000000000000000000e1 * t60 - 0.36622894612013090109708692208757981924083909966068e-3 * t85 - 0.11696447245269292414524477327518106963944910680856e1 * t100 + 0.2e1 * t222 + 0.2e1 * t289 * t320 + 0.2e1 * t326 * t350 + r0 * t671
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t4 = 0.1e1 / t2 / r0
  t6 = r0 ** 2
  t8 = 0.1e1 / t2 / t6
  t12 = 6 ** (0.1e1 / 0.3e1)
  t14 = jnp.pi ** 2
  t15 = t14 ** (0.1e1 / 0.3e1)
  t16 = t15 ** 2
  t17 = 0.1e1 / t16
  t18 = 2 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t20 = t17 * t19
  t22 = 0.5e1 / 0.9e1 * (tau0 * t4 - s0 * t8 / 0.8e1) * t12 * t20
  t23 = t22 <= 0.1e1
  t24 = jnp.log(DBL_EPSILON)
  t27 = t24 / (-t24 + 0.64e0)
  t28 = -t27 < t22
  t29 = t22 < -t27
  t30 = t6 * r0
  t32 = 0.1e1 / t2 / t30
  t35 = t6 ** 2
  t37 = 0.1e1 / t2 / t35
  t38 = s0 * t37
  t43 = 0.5e1 / 0.9e1 * (0.40e2 / 0.9e1 * tau0 * t32 - 0.11e2 / 0.9e1 * t38) * t12 * t20
  t44 = f.my_piecewise3(t29, t43, 0)
  t45 = f.my_piecewise3(t29, t22, -t27)
  t46 = 0.1e1 - t45
  t47 = 0.1e1 / t46
  t52 = s0 * t32
  t57 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau0 * t8 + t52 / 0.3e1) * t12 * t20
  t58 = f.my_piecewise3(t29, t57, 0)
  t59 = t58 ** 2
  t60 = t46 ** 2
  t61 = 0.1e1 / t60
  t65 = 0.1e1 / t60 / t46
  t66 = t45 * t65
  t69 = t45 * t61
  t72 = -0.64e0 * t44 * t47 - 0.128e1 * t59 * t61 - 0.128e1 * t66 * t59 - 0.64e0 * t69 * t44
  t75 = jnp.exp(-0.64e0 * t45 * t47)
  t81 = -0.64e0 * t58 * t47 - 0.64e0 * t69 * t58
  t82 = t81 ** 2
  t85 = f.my_piecewise3(t28, 0, t72 * t75 + t82 * t75)
  t87 = jnp.log(0.14285714285714285714285714285714285714285714285714e1 * DBL_EPSILON)
  t90 = (-t87 + 0.15e1) / t87
  t91 = t22 < -t90
  t92 = f.my_piecewise3(t91, -t90, t22)
  t93 = 0.1e1 - t92
  t94 = t93 ** 2
  t96 = 0.1e1 / t94 / t93
  t97 = f.my_piecewise3(t91, 0, t57)
  t98 = t97 ** 2
  t102 = jnp.exp(0.15e1 / t93)
  t105 = 0.1e1 / t94
  t106 = f.my_piecewise3(t91, 0, t43)
  t110 = t94 ** 2
  t111 = 0.1e1 / t110
  t116 = f.my_piecewise3(t91, 0, -0.210e1 * t96 * t98 * t102 - 0.105e1 * t105 * t106 * t102 - 0.1575e1 * t111 * t98 * t102)
  t117 = f.my_piecewise3(t23, t85, t116)
  t118 = 3 ** (0.1e1 / 0.3e1)
  t119 = 0.1e1 / jnp.pi
  t120 = t119 ** (0.1e1 / 0.3e1)
  t121 = t118 * t120
  t122 = 4 ** (0.1e1 / 0.3e1)
  t123 = t122 ** 2
  t126 = t121 * t123 / t1
  t127 = jnp.sqrt(t126)
  t130 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t127 + 0.31385250000000000000000000000000000000000000000000e-1 * t126
  t131 = 0.1e1 / t130
  t134 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t131)
  t135 = t134 - 0.1e1
  t136 = t12 * t17
  t137 = t19 * s0
  t141 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t136 * t137 * t8
  t142 = t141 ** (0.1e1 / 0.4e1)
  t144 = 0.1e1 - 0.1e1 / t142
  t146 = t135 * t144 + 0.1e1
  t147 = jnp.log(t146)
  t150 = t18 - 0.1e1
  t151 = 0.1e1 <= f.p.zeta_threshold
  t152 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t154 = f.my_piecewise3(t151, t152 * f.p.zeta_threshold, 1)
  t156 = 0.2e1 * t154 - 0.2e1
  t159 = 0.1e1 / t150 / 0.2e1
  t162 = 0.1e1 - 0.2363e1 * t150 * t156 * t159
  t165 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t126
  t168 = t126 ** 0.15e1
  t170 = t118 ** 2
  t171 = t120 ** 2
  t172 = t170 * t171
  t175 = t172 * t122 / t2
  t177 = 0.37978500000000000000000000000000000000000000000000e1 * t127 + 0.89690000000000000000000000000000000000000000000000e0 * t126 + 0.20477500000000000000000000000000000000000000000000e0 * t168 + 0.12323500000000000000000000000000000000000000000000e0 * t175
  t180 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t177
  t181 = jnp.log(t180)
  t183 = 0.621814e-1 * t165 * t181
  t184 = t156 * t159
  t186 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t126
  t191 = 0.51785000000000000000000000000000000000000000000000e1 * t127 + 0.90577500000000000000000000000000000000000000000000e0 * t126 + 0.11003250000000000000000000000000000000000000000000e0 * t168 + 0.12417750000000000000000000000000000000000000000000e0 * t175
  t194 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t191
  t195 = jnp.log(t194)
  t198 = 0.19751673498613801407483339618206552048944131217655e-1 * t184 * t186 * t195
  t199 = jnp.log(0.2e1)
  t200 = 0.1e1 - t199
  t202 = t200 / t14
  t203 = t152 ** 2
  t204 = f.my_piecewise3(t151, t203, 1)
  t205 = t204 ** 2
  t206 = t205 * t204
  t208 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e-1 * t126
  t210 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t126
  t211 = 0.1e1 / t210
  t212 = t208 * t211
  t213 = 0.1e1 / t200
  t217 = 0.1e1 / t206
  t218 = t14 * t217
  t220 = jnp.exp(-(-t183 + t198) * t213 * t218)
  t221 = t220 - 0.1e1
  t222 = 0.1e1 / t221
  t224 = t14 * t222 * s0
  t225 = t212 * t213 * t224
  t227 = 0.1e1 / t1 / t6
  t229 = 0.1e1 / t205
  t231 = 0.1e1 / t120
  t232 = t170 * t231
  t233 = t232 * t122
  t237 = 0.1e1 + 0.27801896084645508333333333333333333333333333333333e-2 * t225 * t227 * t18 * t229 * t233
  t238 = t237 ** (0.1e1 / 0.4e1)
  t240 = 0.1e1 - 0.1e1 / t238
  t243 = 0.1e1 + 0.10000000000000000000000000000000000000000000000000e1 * t240 * t221
  t244 = jnp.log(t243)
  t247 = (-0.285764e-1 * t131 + 0.285764e-1 * t147) * t162 + t183 - t198 - t202 * t206 * t244
  t251 = f.my_piecewise3(t28, 0, t81 * t75)
  t255 = f.my_piecewise3(t91, 0, -0.105e1 * t105 * t97 * t102)
  t256 = f.my_piecewise3(t23, t251, t255)
  t257 = t130 ** 2
  t258 = 0.1e1 / t257
  t260 = 0.1e1 / t127 * t118
  t261 = t120 * t123
  t263 = 0.1e1 / t1 / r0
  t264 = t261 * t263
  t265 = t260 * t264
  t267 = t123 * t263
  t268 = t121 * t267
  t270 = -0.74083333333333333333333333333333333333333333333333e-2 * t265 - 0.10461750000000000000000000000000000000000000000000e-1 * t268
  t271 = t258 * t270
  t273 = t134 * t144
  t277 = 0.1e1 / t142 / t141
  t279 = t135 * t277 * t12
  t283 = -0.10000000000000000000000000000000000000000000000000e1 * t271 * t273 - 0.14225094736250905555555555555555555555555555555555e-1 * t279 * t20 * t52
  t284 = 0.1e1 / t146
  t291 = 0.11073470983333333333333333333333333333333333333333e-2 * t121 * t267 * t181
  t292 = t177 ** 2
  t293 = 0.1e1 / t292
  t294 = t165 * t293
  t297 = t126 ** 0.5e0
  t298 = t297 * t118
  t299 = t298 * t264
  t302 = t172 * t122 * t4
  t304 = -0.63297500000000000000000000000000000000000000000000e0 * t265 - 0.29896666666666666666666666666666666666666666666667e0 * t268 - 0.10238750000000000000000000000000000000000000000000e0 * t299 - 0.82156666666666666666666666666666666666666666666667e-1 * t302
  t305 = 0.1e1 / t180
  t306 = t304 * t305
  t308 = 0.10000000000000000000000000000000000000000000000000e1 * t294 * t306
  t309 = t184 * t118
  t313 = 0.18311447306006545054854346104378990962041954983034e-3 * t309 * t261 * t263 * t195
  t314 = t184 * t186
  t315 = t191 ** 2
  t316 = 0.1e1 / t315
  t321 = -0.86308333333333333333333333333333333333333333333334e0 * t265 - 0.30192500000000000000000000000000000000000000000000e0 * t268 - 0.55016250000000000000000000000000000000000000000000e-1 * t299 - 0.82785000000000000000000000000000000000000000000000e-1 * t302
  t323 = 0.1e1 / t194
  t324 = t316 * t321 * t323
  t326 = 0.58482236226346462072622386637590534819724553404280e0 * t314 * t324
  t328 = 0.1e1 / t238 / t237
  t329 = t32 * t211
  t330 = t213 * t14
  t332 = t222 * s0
  t334 = t332 * t18 * t229
  t337 = t210 ** 2
  t338 = 0.1e1 / t337
  t339 = t208 * t338
  t340 = t339 * t330
  t346 = t200 ** 2
  t347 = 0.1e1 / t346
  t348 = t212 * t347
  t349 = t14 ** 2
  t350 = t221 ** 2
  t351 = 0.1e1 / t350
  t352 = t349 * t351
  t353 = s0 * t227
  t355 = t348 * t352 * t353
  t356 = t205 ** 2
  t358 = 0.1e1 / t356 / t204
  t359 = t18 * t358
  t360 = t359 * t170
  t361 = t231 * t122
  t362 = t291 + t308 - t313 - t326
  t363 = t362 * t220
  t365 = t360 * t361 * t363
  t369 = 0.1e1 / t1 / t30
  t375 = -0.27801896084645508333333333333333333333333333333333e-3 * t329 * t330 * t334 + 0.49431771238499713816666666666666666666666666666666e-3 * t340 * t332 * t32 * t18 * t229 + 0.27801896084645508333333333333333333333333333333333e-2 * t355 * t365 - 0.64871090864172852777777777777777777777777777777777e-2 * t225 * t369 * t18 * t229 * t233
  t376 = t328 * t375
  t381 = t218 * t220
  t384 = 0.25000000000000000000000000000000000000000000000000e0 * t376 * t221 - 0.10000000000000000000000000000000000000000000000000e1 * t240 * t362 * t213 * t381
  t386 = 0.1e1 / t243
  t389 = (0.285764e-1 * t271 + 0.285764e-1 * t283 * t284) * t162 - t291 - t308 + t313 + t326 - t202 * t206 * t384 * t386
  t392 = f.my_piecewise3(t28, 0, t75)
  t394 = f.my_piecewise3(t91, 0, -0.7e0 * t102)
  t395 = f.my_piecewise3(t23, t392, t394)
  t397 = 0.1e1 / t257 / t130
  t398 = t270 ** 2
  t399 = t397 * t398
  t403 = 0.1e1 / t127 / t126 * t170
  t404 = t171 * t122
  t405 = t404 * t8
  t406 = t403 * t405
  t408 = t261 * t227
  t409 = t260 * t408
  t411 = t123 * t227
  t412 = t121 * t411
  t414 = -0.49388888888888888888888888888888888888888888888889e-2 * t406 + 0.98777777777777777777777777777777777777777777777777e-2 * t409 + 0.13949000000000000000000000000000000000000000000000e-1 * t412
  t415 = t258 * t414
  t421 = t257 ** 2
  t422 = 0.1e1 / t421
  t423 = t422 * t398
  t426 = t134 * t277
  t427 = t271 * t426
  t429 = t136 * t137 * t32
  t432 = t141 ** 2
  t434 = 0.1e1 / t142 / t432
  t436 = t12 ** 2
  t437 = t135 * t434 * t436
  t439 = 0.1e1 / t15 / t14
  t440 = t439 * t18
  t441 = s0 ** 2
  t444 = 0.1e1 / t1 / t35 / t30
  t452 = 0.20000000000000000000000000000000000000000000000000e1 * t399 * t273 - 0.10000000000000000000000000000000000000000000000000e1 * t415 * t273 + 0.10000000000000000000000000000000000000000000000000e1 * t423 * t273 + 0.28450189472501811111111111111111111111111111111110e-1 * t427 * t429 - 0.20235332025531322029119593137558641975308641975307e-2 * t437 * t440 * t441 * t444 + 0.52158680699586653703703703703703703703703703703702e-1 * t279 * t20 * t38
  t455 = t283 ** 2
  t456 = t146 ** 2
  t457 = 0.1e1 / t456
  t463 = t121 * t411 * t181
  t464 = 0.14764627977777777777777777777777777777777777777777e-2 * t463
  t465 = t121 * t123
  t466 = t263 * t293
  t468 = t465 * t466 * t306
  t469 = 0.35616666666666666666666666666666666666666666666666e-1 * t468
  t471 = 0.1e1 / t292 / t177
  t472 = t165 * t471
  t473 = t304 ** 2
  t474 = t473 * t305
  t475 = t472 * t474
  t476 = 0.20000000000000000000000000000000000000000000000000e1 * t475
  t480 = t126 ** (-0.5e0)
  t481 = t480 * t170
  t482 = t481 * t405
  t484 = t298 * t408
  t487 = t172 * t122 * t8
  t489 = -0.42198333333333333333333333333333333333333333333333e0 * t406 + 0.84396666666666666666666666666666666666666666666666e0 * t409 + 0.39862222222222222222222222222222222222222222222223e0 * t412 + 0.68258333333333333333333333333333333333333333333333e-1 * t482 + 0.13651666666666666666666666666666666666666666666667e0 * t484 + 0.13692777777777777777777777777777777777777777777778e0 * t487
  t490 = t489 * t305
  t491 = t294 * t490
  t492 = 0.10000000000000000000000000000000000000000000000000e1 * t491
  t493 = t292 ** 2
  t494 = 0.1e1 / t493
  t495 = t165 * t494
  t496 = t180 ** 2
  t497 = 0.1e1 / t496
  t498 = t473 * t497
  t499 = t495 * t498
  t500 = 0.16081979498692535066756296899072713062105388428051e2 * t499
  t503 = t309 * t261 * t227 * t195
  t504 = 0.24415263074675393406472461472505321282722606644045e-3 * t503
  t505 = t184 * t121
  t507 = t505 * t267 * t324
  t508 = 0.10843581300301739842632067522386578331157260943710e-1 * t507
  t510 = 0.1e1 / t315 / t191
  t511 = t321 ** 2
  t513 = t510 * t511 * t323
  t514 = t314 * t513
  t515 = 0.11696447245269292414524477327518106963944910680856e1 * t514
  t522 = -0.57538888888888888888888888888888888888888888888889e0 * t406 + 0.11507777777777777777777777777777777777777777777778e1 * t409 + 0.40256666666666666666666666666666666666666666666667e0 * t412 + 0.36677500000000000000000000000000000000000000000000e-1 * t482 + 0.73355000000000000000000000000000000000000000000000e-1 * t484 + 0.13797500000000000000000000000000000000000000000000e0 * t487
  t524 = t316 * t522 * t323
  t525 = t314 * t524
  t526 = 0.58482236226346462072622386637590534819724553404280e0 * t525
  t527 = t315 ** 2
  t528 = 0.1e1 / t527
  t530 = t194 ** 2
  t531 = 0.1e1 / t530
  t532 = t528 * t511 * t531
  t533 = t314 * t532
  t534 = 0.17315859105681463759666483083807725165579399831905e2 * t533
  t535 = t237 ** 2
  t537 = 0.1e1 / t238 / t535
  t538 = t375 ** 2
  t539 = t537 * t538
  t542 = t37 * t211
  t546 = t35 * r0
  t547 = 0.1e1 / t546
  t548 = t547 * t338
  t549 = t330 * t222
  t551 = s0 * t18
  t552 = t551 * t229
  t553 = t552 * t465
  t556 = t347 * t349
  t557 = t556 * t351
  t558 = t329 * t557
  t560 = t358 * t362 * t220
  t561 = t551 * t560
  t565 = 0.1e1 / t337 / t210
  t566 = t208 * t565
  t568 = t566 * t213 * t224
  t574 = t339 * t557
  t575 = t52 * t18
  t585 = 0.1e1 / t346 / t200
  t586 = t212 * t585
  t587 = t349 * t14
  t589 = 0.1e1 / t350 / t221
  t590 = t587 * t589
  t592 = t586 * t590 * t353
  t593 = t356 ** 2
  t594 = 0.1e1 / t593
  t595 = t18 * t594
  t596 = t595 * t170
  t597 = t362 ** 2
  t598 = t220 ** 2
  t601 = t596 * t361 * t597 * t598
  t604 = s0 * t369
  t606 = t348 * t352 * t604
  t609 = -t464 - t469 - t476 + t492 + t500 + t504 + t508 + t515 - t526 - t534
  t612 = t360 * t361 * t609 * t220
  t615 = t587 * t351
  t617 = t586 * t615 * t353
  t620 = t596 * t361 * t597 * t220
  t624 = 0.1e1 / t1 / t35
  t630 = 0.16681137650787305000000000000000000000000000000000e-2 * t542 * t330 * t334 - 0.82386285397499523027777777777777777777777777777777e-5 * t548 * t549 * t553 - 0.55603792169291016666666666666666666666666666666666e-3 * t558 * t561 + 0.14648281543675415194338888888888888888888888888889e-4 * t568 * t547 * t18 * t229 * t465 + 0.98863542476999427633333333333333333333333333333332e-3 * t574 * t575 * t560 - 0.29659062743099828290000000000000000000000000000000e-2 * t340 * t332 * t37 * t18 * t229 + 0.55603792169291016666666666666666666666666666666666e-2 * t592 * t601 - 0.12974218172834570555555555555555555555555555555555e-1 * t606 * t365 + 0.27801896084645508333333333333333333333333333333333e-2 * t355 * t612 - 0.27801896084645508333333333333333333333333333333333e-2 * t617 * t620 + 0.21623696954724284259259259259259259259259259259259e-1 * t225 * t624 * t18 * t229 * t233
  t631 = t328 * t630
  t636 = t330 * t217 * t220
  t639 = t240 * t609
  t646 = 0.1e1 / t356 / t205
  t647 = t349 * t646
  t651 = -0.31250000000000000000000000000000000000000000000000e0 * t539 * t221 + 0.25000000000000000000000000000000000000000000000000e0 * t631 * t221 - 0.50000000000000000000000000000000000000000000000000e0 * t376 * t362 * t636 - 0.10000000000000000000000000000000000000000000000000e1 * t639 * t213 * t381 + 0.10000000000000000000000000000000000000000000000000e1 * t240 * t597 * t347 * t647 * t220
  t654 = t202 * t206 * t651 * t386
  t655 = t384 ** 2
  t657 = t243 ** 2
  t658 = 0.1e1 / t657
  t660 = t202 * t206 * t655 * t658
  t661 = (-0.571528e-1 * t399 + 0.285764e-1 * t415 + 0.285764e-1 * t452 * t284 - 0.285764e-1 * t455 * t457) * t162 + t464 + t469 + t476 - t492 - t500 - t504 - t508 - t515 + t526 + t534 - t654 + t660
  t671 = t123 * t369
  t674 = 0.34450798614814814814814814814814814814814814814813e-2 * t121 * t671 * t181
  t677 = 0.32530743900905219527896202567159734993471782831130e-1 * t505 * t267 * t513
  t680 = 0.21687162600603479685264135044773156662314521887420e-1 * t505 * t411 * t324
  t683 = 0.16265371950452609763948101283579867496735891415565e-1 * t505 * t267 * t524
  t686 = 0.48159733137676571081572406076840235616767705782485e0 * t505 * t267 * t532
  t690 = t473 * t304
  t693 = 0.96491876992155210400537781394436278372632330568306e2 * t165 / t493 / t177 * t690 * t497
  t696 = 0.60000000000000000000000000000000000000000000000000e1 * t495 * t690 * t305
  t701 = 0.1e1 / t35
  t702 = 0.1e1 / t127 / t175 * t119 * t701 / 0.4e1
  t704 = t404 * t32
  t705 = t403 * t704
  t707 = t261 * t369
  t708 = t260 * t707
  t710 = t121 * t671
  t712 = t126 ** (-0.15e1)
  t714 = t712 * t119 * t701
  t716 = t481 * t704
  t718 = t298 * t707
  t721 = t172 * t122 * t32
  t726 = 0.10000000000000000000000000000000000000000000000000e1 * t294 * (-0.25319000000000000000000000000000000000000000000000e1 * t702 + 0.16879333333333333333333333333333333333333333333333e1 * t705 - 0.19692555555555555555555555555555555555555555555555e1 * t708 - 0.93011851851851851851851851851851851851851851851854e0 * t710 + 0.13651666666666666666666666666666666666666666666667e0 * t714 - 0.27303333333333333333333333333333333333333333333333e0 * t716 - 0.31853888888888888888888888888888888888888888888890e0 * t718 - 0.36514074074074074074074074074074074074074074074075e0 * t721) * t305
  t734 = 0.51726012919273400298984252201052768390886626637712e3 * t165 / t493 / t292 * t690 / t496 / t180
  t741 = 0.3e1 * t202 * t206 * t651 * t658 * t384
  t742 = t511 * t321
  t746 = 0.35089341735807877243573431982554320891834732042568e1 * t314 * t528 * t742 * t323
  t754 = 0.10254018858216406658218194626490193680059335835414e4 * t314 / t527 / t315 * t742 / t530 / t194
  t767 = 0.58482236226346462072622386637590534819724553404280e0 * t314 * t316 * (-0.34523333333333333333333333333333333333333333333333e1 * t702 + 0.23015555555555555555555555555555555555555555555556e1 * t705 - 0.26851481481481481481481481481481481481481481481482e1 * t708 - 0.93932222222222222222222222222222222222222222222223e0 * t710 + 0.73355000000000000000000000000000000000000000000000e-1 * t714 - 0.14671000000000000000000000000000000000000000000000e0 * t716 - 0.17116166666666666666666666666666666666666666666667e0 * t718 - 0.36793333333333333333333333333333333333333333333333e0 * t721) * t323
  t768 = 0.3e1 * t117 * t389 + t674 - t677 - t680 + t683 + t686 - t693 + t696 + t726 + t734 - t741 - t746 - t754 - t767
  t771 = -t674 + t677 + t680 - t683 - t686 + t693 - t696 - t726 - t734 + t741 + t746 + t754 + t767
  t775 = 0.71233333333333333333333333333333333333333333333331e-1 * t465 * t227 * t293 * t306
  t778 = 0.53424999999999999999999999999999999999999999999999e-1 * t465 * t466 * t490
  t782 = 0.85917975471764868594145516183295969534298037676861e0 * t465 * t263 * t494 * t498
  t786 = 0.10685000000000000000000000000000000000000000000000e0 * t465 * t263 * t471 * t474
  t790 = 0.56968947174242584615102410102512416326352748836105e-3 * t309 * t261 * t369 * t195
  t795 = 0.51947577317044391278999449251423175496738199495715e2 * t314 * t528 * t522 * t531 * t321
  t800 = 0.35089341735807877243573431982554320891834732042568e1 * t314 * t510 * t321 * t323 * t522
  t816 = 0.1e1 / t2 / t546
  t822 = t337 ** 2
  t827 = t35 * t6
  t829 = 0.1e1 / t1 / t827
  t832 = t172 * t122
  t836 = 0.1e1 / t827
  t849 = t595 * t232
  t875 = t358 * t609 * t220
  t879 = t585 * t587
  t880 = t879 * t589
  t882 = t594 * t597
  t883 = t882 * t598
  t887 = t879 * t351
  t889 = t882 * t220
  t898 = t359 * t118 * t261 * t363
  t901 = 0.17685589265329897609962962962962962962962962962963e-1 * t340 * t332 * t816 * t18 * t229 + 0.26044644584654888215534544444444444444444444444445e-5 * t208 / t822 * t213 * t224 * t829 * t18 * t229 * t832 - 0.16113109698042956713772777777777777777777777777778e-3 * t568 * t836 * t18 * t229 * t465 - 0.93702686803805231790123456790123456790123456790122e-1 * t225 / t1 / t546 * t18 * t229 * t233 + 0.16681137650787305000000000000000000000000000000000e-1 * t592 * t849 * t122 * t362 * t598 * t609 - 0.83405688253936524999999999999999999999999999999999e-2 * t617 * t849 * t122 * t609 * t363 + 0.90624913937249475330555555555555555555555555555555e-4 * t836 * t338 * t549 * t553 - 0.14648281543675415194338888888888888888888888888889e-5 * t829 * t565 * t549 * t552 * t832 - 0.88977188229299484869999999999999999999999999999999e-2 * t574 * t38 * t18 * t560 + 0.14829531371549914145000000000000000000000000000000e-2 * t574 * t575 * t875 + 0.29659062743099828289999999999999999999999999999999e-2 * t339 * t880 * t575 * t883 - 0.14829531371549914145000000000000000000000000000000e-2 * t339 * t887 * t575 * t889 - 0.24715885619249856908333333333333333333333333333334e-4 * t548 * t347 * t352 * s0 * t898
  t920 = t346 ** 2
  t922 = t212 / t920
  t923 = t349 ** 2
  t930 = t18 / t593 / t206 * t170
  t931 = t597 * t362
  t943 = -t795 - t746 + t800 - t677 - t680 + t683 + t686 + t734 - t693 + t726 - t754
  t949 = 0.10389515463408878255799889850284635099347639899143e3 * t314 / t527 / t191 * t742 * t531
  t953 = 0.48245938496077605200268890697218139186316165284153e2 * t495 * t489 * t497 * t304
  t956 = 0.60000000000000000000000000000000000000000000000000e1 * t472 * t306 * t489
  t957 = -t767 + t949 + t674 + t953 + t696 - t956 + t775 - t778 - t782 + t786 - t790
  t958 = t943 + t957
  t987 = t350 ** 2
  t998 = -0.83405688253936524999999999999999999999999999999999e-3 * t558 * t551 * t875 - 0.16681137650787305000000000000000000000000000000000e-2 * t329 * t880 * t551 * t883 + 0.83405688253936524999999999999999999999999999999999e-3 * t329 * t887 * t551 * t889 + 0.50043412952361914999999999999999999999999999999999e-2 * t542 * t557 * t561 - 0.99469005991731707592592592592592592592592592592592e-2 * t816 * t211 * t330 * t334 - 0.16681137650787305000000000000000000000000000000000e-1 * t922 * t923 * t589 * t353 * t930 * t361 * t931 * t598 - 0.19461327259251855833333333333333333333333333333333e-1 * t606 * t612 + 0.19461327259251855833333333333333333333333333333333e-1 * t586 * t615 * t604 * t620 + 0.27801896084645508333333333333333333333333333333333e-2 * t355 * t360 * t361 * t958 * t220 + 0.27801896084645508333333333333333333333333333333333e-2 * t922 * t923 * t351 * t353 * t930 * t361 * t931 * t220 + 0.64871090864172852777777777777777777777777777777776e-1 * t348 * t352 * s0 * t624 * t365 - 0.38922654518503711666666666666666666666666666666665e-1 * t586 * t590 * t604 * t601 + 0.43944844631026245583016666666666666666666666666667e-4 * t566 * t347 * t352 * s0 * t547 * t898 + 0.16681137650787305000000000000000000000000000000000e-1 * t922 * t923 / t987 * t353 * t930 * t361 * t931 * t598 * t220
  t1033 = t202 * t206 * (0.70312500000000000000000000000000000000000000000000e0 / t238 / t535 / t237 * t538 * t375 * t221 - 0.93750000000000000000000000000000000000000000000000e0 * t537 * t375 * t221 * t630 + 0.93750000000000000000000000000000000000000000000000e0 * t539 * t362 * t636 + 0.25000000000000000000000000000000000000000000000000e0 * t328 * (t901 + t998) * t221 - 0.75000000000000000000000000000000000000000000000000e0 * t631 * t362 * t636 - 0.75000000000000000000000000000000000000000000000000e0 * t376 * t609 * t636 + 0.75000000000000000000000000000000000000000000000000e0 * t376 * t597 * t556 * t646 * t220 - 0.10000000000000000000000000000000000000000000000000e1 * t240 * t958 * t213 * t381 + 0.30000000000000000000000000000000000000000000000000e1 * t639 * t347 * t647 * t363 - 0.10000000000000000000000000000000000000000000000000e1 * t240 * t931 * t585 * t587 / t593 / t204 * t220) * t386
  t1040 = 0.2e1 * t202 * t206 * t655 * t384 / t657 / t243
  t1041 = t398 * t270
  t1042 = t422 * t1041
  t1044 = t397 * t270
  t1052 = t258 * (-0.29633333333333333333333333333333333333333333333333e-1 * t702 + 0.19755555555555555555555555555555555555555555555555e-1 * t705 - 0.23048148148148148148148148148148148148148148148148e-1 * t708 - 0.32547666666666666666666666666666666666666666666667e-1 * t710)
  t1104 = t35 ** 2
  t1116 = s0 * t816
  t1120 = -0.60000000000000000000000000000000000000000000000000e1 * t1042 * t273 + 0.60000000000000000000000000000000000000000000000000e1 * t1044 * t273 * t414 - 0.60000000000000000000000000000000000000000000000000e1 / t421 / t130 * t1041 * t273 - 0.85350568417505433333333333333333333333333333333330e-1 * t399 * t426 * t429 - 0.10000000000000000000000000000000000000000000000000e1 * t1052 * t273 + 0.30000000000000000000000000000000000000000000000000e1 * t422 * t414 * t270 * t134 * t144 + 0.42675284208752716666666666666666666666666666666665e-1 * t415 * t426 * t429 - 0.10000000000000000000000000000000000000000000000000e1 / t421 / t257 * t1041 * t273 - 0.42675284208752716666666666666666666666666666666665e-1 * t423 * t426 * t429 + 0.60705996076593966087358779412675925925925925925921e-2 * t271 * t134 * t434 * t436 * t439 * t18 * t441 * t444 - 0.15647604209875996111111111111111111111111111111110e0 * t427 * t136 * t137 * t37 - 0.31087747628928898252912838668079770391184269901849e-2 * t135 / t142 / t432 / t141 / t349 * t441 * s0 / t1104 / t30 + 0.22258865228084454232031552451314506172839506172838e-1 * t437 * t440 * t441 / t1 / t1104 - 0.24340717659807105061728395061728395061728395061728e0 * t279 * t20 * t1116
  t1133 = -t775 + t778 + t782 - t786 + t790 + t795 - t800 - t1033 - t953 + t956 - t1040 - t949 + (0.1714584e0 * t1042 - 0.1714584e0 * t1044 * t414 + 0.285764e-1 * t1052 + 0.285764e-1 * t1120 * t284 - 0.857292e-1 * t452 * t457 * t283 + 0.571528e-1 * t455 * t283 / t456 / t146) * t162
  t1142 = 0.5e1 / 0.9e1 * (-0.440e3 / 0.27e2 * tau0 * t37 + 0.154e3 / 0.27e2 * t1116) * t12 * t20
  t1143 = f.my_piecewise3(t29, t1142, 0)
  t1149 = t59 * t58
  t1152 = t60 ** 2
  t1170 = f.my_piecewise3(t28, 0, (-0.64e0 * t1143 * t47 - 0.384e1 * t44 * t61 * t58 - 0.384e1 * t1149 * t65 - 0.384e1 * t45 / t1152 * t1149 - 0.384e1 * t66 * t58 * t44 - 0.64e0 * t69 * t1143) * t75 + 0.3e1 * t72 * t81 * t75 + t82 * t81 * t75)
  t1171 = t98 * t97
  t1184 = f.my_piecewise3(t91, 0, t1142)
  t1198 = f.my_piecewise3(t91, 0, -0.630e1 * t111 * t1171 * t102 - 0.630e1 * t96 * t97 * t102 * t106 - 0.9450e1 / t110 / t93 * t1171 * t102 - 0.105e1 * t105 * t1184 * t102 - 0.4725e1 * t111 * t106 * t97 * t102 - 0.23625e1 / t110 / t94 * t1171 * t102)
  t1199 = f.my_piecewise3(t23, t1170, t1198)
  t1201 = 0.3e1 * t256 * t661 + t395 * (t771 + t1133) + t775 - t778 - t782 + t786 - t790 - t795 + t800 + t1033 + t953 - t956 + t1040 + t949 + t1199 * t247
  v3rho3_0_ = 0.3e1 * t117 * t247 + 0.6e1 * t256 * t389 + 0.3e1 * t395 * t661 + 0.48245938496077605200268890697218139186316165284153e2 * t499 - 0.60000000000000000000000000000000000000000000000000e1 * t475 + 0.30000000000000000000000000000000000000000000000000e1 * t491 - 0.51947577317044391278999449251423175496738199495715e2 * t533 + 0.35089341735807877243573431982554320891834732042568e1 * t514 - 0.17544670867903938621786715991277160445917366021284e1 * t525 + 0.32530743900905219527896202567159734993471782831130e-1 * t507 + r0 * (t768 + t1201) - 0.10685000000000000000000000000000000000000000000000e0 * t468 + 0.73245789224026180219417384417515963848167819932136e-3 * t503 - 0.3e1 * t660 + 0.3e1 * t654 - 0.44293883933333333333333333333333333333333333333332e-2 * t463

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** 2
  t8 = t7 * r0
  t9 = r0 ** (0.1e1 / 0.3e1)
  t11 = 0.1e1 / t9 / t8
  t12 = t6 * t11
  t15 = t4 * t6 / t9
  t16 = jnp.sqrt(t15)
  t19 = t15 ** 0.15e1
  t21 = t1 ** 2
  t22 = t3 ** 2
  t23 = t21 * t22
  t24 = t9 ** 2
  t27 = t23 * t5 / t24
  t29 = 0.37978500000000000000000000000000000000000000000000e1 * t16 + 0.89690000000000000000000000000000000000000000000000e0 * t15 + 0.20477500000000000000000000000000000000000000000000e0 * t19 + 0.12323500000000000000000000000000000000000000000000e0 * t27
  t32 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t29
  t33 = jnp.log(t32)
  t35 = t4 * t12 * t33
  t37 = 0.1e1 <= f.p.zeta_threshold
  t38 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t40 = f.my_piecewise3(t37, t38 * f.p.zeta_threshold, 1)
  t42 = 0.2e1 * t40 - 0.2e1
  t43 = 2 ** (0.1e1 / 0.3e1)
  t44 = t43 - 0.1e1
  t46 = 0.1e1 / t44 / 0.2e1
  t47 = t42 * t46
  t49 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t15
  t50 = t47 * t49
  t55 = 0.51785000000000000000000000000000000000000000000000e1 * t16 + 0.90577500000000000000000000000000000000000000000000e0 * t15 + 0.11003250000000000000000000000000000000000000000000e0 * t19 + 0.12417750000000000000000000000000000000000000000000e0 * t27
  t56 = t55 ** 2
  t57 = t56 ** 2
  t58 = 0.1e1 / t57
  t61 = 0.1e1 / t16 / t15 * t21
  t62 = t22 * t5
  t64 = 0.1e1 / t24 / t7
  t65 = t62 * t64
  t66 = t61 * t65
  t69 = 0.1e1 / t16 * t1
  t70 = t3 * t6
  t72 = 0.1e1 / t9 / t7
  t73 = t70 * t72
  t74 = t69 * t73
  t76 = t6 * t72
  t77 = t4 * t76
  t79 = t15 ** (-0.5e0)
  t80 = t79 * t21
  t81 = t80 * t65
  t83 = t15 ** 0.5e0
  t84 = t83 * t1
  t85 = t84 * t73
  t88 = t23 * t5 * t64
  t90 = -0.57538888888888888888888888888888888888888888888889e0 * t66 + 0.11507777777777777777777777777777777777777777777778e1 * t74 + 0.40256666666666666666666666666666666666666666666667e0 * t77 + 0.36677500000000000000000000000000000000000000000000e-1 * t81 + 0.73355000000000000000000000000000000000000000000000e-1 * t85 + 0.13797500000000000000000000000000000000000000000000e0 * t88
  t94 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t55
  t95 = t94 ** 2
  t96 = 0.1e1 / t95
  t98 = 0.1e1 / t9 / r0
  t99 = t70 * t98
  t100 = t69 * t99
  t102 = t6 * t98
  t103 = t4 * t102
  t105 = t84 * t99
  t108 = 0.1e1 / t24 / r0
  t110 = t23 * t5 * t108
  t112 = -0.86308333333333333333333333333333333333333333333334e0 * t100 - 0.30192500000000000000000000000000000000000000000000e0 * t103 - 0.55016250000000000000000000000000000000000000000000e-1 * t105 - 0.82785000000000000000000000000000000000000000000000e-1 * t110
  t113 = t96 * t112
  t115 = t50 * t58 * t90 * t113
  t118 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t15
  t119 = t29 ** 2
  t120 = 0.1e1 / t119
  t121 = t118 * t120
  t125 = 0.1e1 / t16 / t27 * t2 / 0.4e1
  t126 = t7 ** 2
  t127 = 0.1e1 / t126
  t128 = t125 * t127
  t131 = 0.1e1 / t24 / t8
  t132 = t62 * t131
  t133 = t61 * t132
  t135 = t70 * t11
  t136 = t69 * t135
  t138 = t4 * t12
  t140 = t15 ** (-0.15e1)
  t141 = t140 * t2
  t142 = t141 * t127
  t144 = t80 * t132
  t146 = t84 * t135
  t149 = t23 * t5 * t131
  t151 = -0.25319000000000000000000000000000000000000000000000e1 * t128 + 0.16879333333333333333333333333333333333333333333333e1 * t133 - 0.19692555555555555555555555555555555555555555555555e1 * t136 - 0.93011851851851851851851851851851851851851851851854e0 * t138 + 0.13651666666666666666666666666666666666666666666667e0 * t142 - 0.27303333333333333333333333333333333333333333333333e0 * t144 - 0.31853888888888888888888888888888888888888888888890e0 * t146 - 0.36514074074074074074074074074074074074074074074075e0 * t149
  t152 = 0.1e1 / t32
  t153 = t151 * t152
  t154 = t121 * t153
  t156 = t119 ** 2
  t158 = 0.1e1 / t156 / t119
  t159 = t118 * t158
  t164 = -0.63297500000000000000000000000000000000000000000000e0 * t100 - 0.29896666666666666666666666666666666666666666666667e0 * t103 - 0.10238750000000000000000000000000000000000000000000e0 * t105 - 0.82156666666666666666666666666666666666666666666667e-1 * t110
  t165 = t164 ** 2
  t166 = t165 * t164
  t167 = t32 ** 2
  t169 = 0.1e1 / t167 / t32
  t170 = t166 * t169
  t171 = t159 * t170
  t174 = 0.1e1 / t156 / t29
  t175 = t118 * t174
  t176 = 0.1e1 / t167
  t177 = t166 * t176
  t178 = t175 * t177
  t184 = 6 ** (0.1e1 / 0.3e1)
  t186 = jnp.pi ** 2
  t187 = t186 ** (0.1e1 / 0.3e1)
  t188 = t187 ** 2
  t189 = 0.1e1 / t188
  t190 = t43 ** 2
  t191 = t189 * t190
  t193 = 0.5e1 / 0.9e1 * (tau0 * t108 - s0 * t64 / 0.8e1) * t184 * t191
  t194 = t193 <= 0.1e1
  t195 = jnp.log(DBL_EPSILON)
  t198 = t195 / (-t195 + 0.64e0)
  t199 = -t198 < t193
  t200 = t193 < -t198
  t204 = 0.1e1 / t24 / t126
  t205 = s0 * t204
  t210 = 0.5e1 / 0.9e1 * (0.40e2 / 0.9e1 * tau0 * t131 - 0.11e2 / 0.9e1 * t205) * t184 * t191
  t211 = f.my_piecewise3(t200, t210, 0)
  t212 = f.my_piecewise3(t200, t193, -t198)
  t213 = 0.1e1 - t212
  t214 = 0.1e1 / t213
  t219 = s0 * t131
  t224 = 0.5e1 / 0.9e1 * (-0.5e1 / 0.3e1 * tau0 * t64 + t219 / 0.3e1) * t184 * t191
  t225 = f.my_piecewise3(t200, t224, 0)
  t226 = t225 ** 2
  t227 = t213 ** 2
  t228 = 0.1e1 / t227
  t232 = 0.1e1 / t227 / t213
  t233 = t212 * t232
  t236 = t212 * t228
  t239 = -0.64e0 * t211 * t214 - 0.128e1 * t226 * t228 - 0.128e1 * t233 * t226 - 0.64e0 * t236 * t211
  t242 = jnp.exp(-0.64e0 * t212 * t214)
  t248 = -0.64e0 * t225 * t214 - 0.64e0 * t236 * t225
  t249 = t248 ** 2
  t252 = f.my_piecewise3(t199, 0, t239 * t242 + t249 * t242)
  t254 = jnp.log(0.14285714285714285714285714285714285714285714285714e1 * DBL_EPSILON)
  t257 = (-t254 + 0.15e1) / t254
  t258 = t193 < -t257
  t259 = f.my_piecewise3(t258, -t257, t193)
  t260 = 0.1e1 - t259
  t261 = t260 ** 2
  t262 = t261 * t260
  t263 = 0.1e1 / t262
  t264 = f.my_piecewise3(t258, 0, t224)
  t265 = t264 ** 2
  t269 = jnp.exp(0.15e1 / t260)
  t272 = 0.1e1 / t261
  t273 = f.my_piecewise3(t258, 0, t210)
  t277 = t261 ** 2
  t278 = 0.1e1 / t277
  t279 = t278 * t265
  t283 = f.my_piecewise3(t258, 0, -0.210e1 * t263 * t265 * t269 - 0.105e1 * t272 * t273 * t269 - 0.1575e1 * t279 * t269)
  t284 = f.my_piecewise3(t194, t252, t283)
  t287 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t16 + 0.31385250000000000000000000000000000000000000000000e-1 * t15
  t288 = t287 ** 2
  t289 = 0.1e1 / t288
  t292 = -0.74083333333333333333333333333333333333333333333333e-2 * t100 - 0.10461750000000000000000000000000000000000000000000e-1 * t103
  t293 = t289 * t292
  t295 = 0.1e1 / t287
  t297 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t295)
  t298 = t184 * t189
  t299 = t190 * s0
  t303 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t298 * t299 * t64
  t304 = t303 ** (0.1e1 / 0.4e1)
  t306 = 0.1e1 - 0.1e1 / t304
  t307 = t297 * t306
  t310 = t297 - 0.1e1
  t312 = 0.1e1 / t304 / t303
  t314 = t310 * t312 * t184
  t318 = -0.10000000000000000000000000000000000000000000000000e1 * t293 * t307 - 0.14225094736250905555555555555555555555555555555555e-1 * t314 * t191 * t219
  t320 = t310 * t306 + 0.1e1
  t321 = 0.1e1 / t320
  t328 = 0.1e1 - 0.2363e1 * t44 * t42 * t46
  t332 = 0.11073470983333333333333333333333333333333333333333e-2 * t4 * t102 * t33
  t333 = t164 * t152
  t335 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * t333
  t336 = t47 * t1
  t337 = jnp.log(t94)
  t341 = 0.18311447306006545054854346104378990962041954983034e-3 * t336 * t70 * t98 * t337
  t342 = 0.1e1 / t56
  t344 = 0.1e1 / t94
  t345 = t342 * t112 * t344
  t347 = 0.58482236226346462072622386637590534819724553404280e0 * t50 * t345
  t348 = jnp.log(0.2e1)
  t349 = 0.1e1 - t348
  t351 = t349 / t186
  t352 = t38 ** 2
  t353 = f.my_piecewise3(t37, t352, 1)
  t354 = t353 ** 2
  t355 = t354 * t353
  t357 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e-1 * t15
  t359 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t15
  t360 = 0.1e1 / t359
  t361 = t357 * t360
  t362 = 0.1e1 / t349
  t365 = 0.621814e-1 * t118 * t33
  t368 = 0.19751673498613801407483339618206552048944131217655e-1 * t47 * t49 * t337
  t371 = 0.1e1 / t355
  t372 = t186 * t371
  t374 = jnp.exp(-(-t365 + t368) * t362 * t372)
  t375 = t374 - 0.1e1
  t376 = 0.1e1 / t375
  t378 = t186 * t376 * s0
  t379 = t361 * t362 * t378
  t381 = 0.1e1 / t354
  t383 = 0.1e1 / t3
  t384 = t21 * t383
  t385 = t384 * t5
  t389 = 0.1e1 + 0.27801896084645508333333333333333333333333333333333e-2 * t379 * t72 * t43 * t381 * t385
  t390 = t389 ** (0.1e1 / 0.4e1)
  t392 = 0.1e1 / t390 / t389
  t393 = t131 * t360
  t394 = t362 * t186
  t396 = t376 * s0
  t398 = t396 * t43 * t381
  t401 = t359 ** 2
  t402 = 0.1e1 / t401
  t403 = t357 * t402
  t404 = t403 * t394
  t405 = t131 * t43
  t410 = t349 ** 2
  t411 = 0.1e1 / t410
  t412 = t361 * t411
  t413 = t186 ** 2
  t414 = t375 ** 2
  t415 = 0.1e1 / t414
  t416 = t413 * t415
  t417 = s0 * t72
  t419 = t412 * t416 * t417
  t420 = t354 ** 2
  t422 = 0.1e1 / t420 / t353
  t423 = t43 * t422
  t424 = t423 * t21
  t425 = t383 * t5
  t426 = t332 + t335 - t341 - t347
  t427 = t426 * t374
  t429 = t424 * t425 * t427
  t437 = -0.27801896084645508333333333333333333333333333333333e-3 * t393 * t394 * t398 + 0.49431771238499713816666666666666666666666666666666e-3 * t404 * t396 * t405 * t381 + 0.27801896084645508333333333333333333333333333333333e-2 * t419 * t429 - 0.64871090864172852777777777777777777777777777777777e-2 * t379 * t11 * t43 * t381 * t385
  t438 = t392 * t437
  t442 = 0.1e1 - 0.1e1 / t390
  t445 = t372 * t374
  t448 = 0.25000000000000000000000000000000000000000000000000e0 * t438 * t375 - 0.10000000000000000000000000000000000000000000000000e1 * t442 * t426 * t362 * t445
  t452 = 0.1e1 + 0.10000000000000000000000000000000000000000000000000e1 * t442 * t375
  t453 = 0.1e1 / t452
  t456 = (0.285764e-1 * t293 + 0.285764e-1 * t318 * t321) * t328 - t332 - t335 + t341 + t347 - t351 * t355 * t448 * t453
  t459 = 0.1e1 / t156
  t460 = t118 * t459
  t461 = t166 * t152
  t462 = t460 * t461
  t464 = t47 * t4
  t465 = t56 * t55
  t466 = 0.1e1 / t465
  t467 = t112 ** 2
  t469 = t466 * t467 * t344
  t471 = t464 * t102 * t469
  t474 = t464 * t76 * t345
  t477 = t342 * t90 * t344
  t479 = t464 * t102 * t477
  t481 = t58 * t467
  t482 = t481 * t96
  t484 = t464 * t102 * t482
  t486 = t389 ** 2
  t489 = 0.1e1 / t390 / t486 / t389
  t490 = t437 ** 2
  t492 = t489 * t490 * t437
  t496 = 0.1e1 / t390 / t486
  t497 = t496 * t437
  t498 = t204 * t360
  t502 = t126 * r0
  t503 = 0.1e1 / t502
  t504 = t503 * t402
  t505 = t394 * t376
  t507 = s0 * t43
  t508 = t507 * t381
  t509 = t4 * t6
  t510 = t508 * t509
  t513 = t411 * t413
  t514 = t513 * t415
  t515 = t393 * t514
  t517 = t422 * t426 * t374
  t518 = t507 * t517
  t522 = 0.1e1 / t401 / t359
  t523 = t357 * t522
  t525 = t523 * t362 * t378
  t531 = t403 * t514
  t532 = t219 * t43
  t542 = 0.1e1 / t410 / t349
  t543 = t361 * t542
  t544 = t413 * t186
  t546 = 0.1e1 / t414 / t375
  t547 = t544 * t546
  t549 = t543 * t547 * t417
  t550 = t420 ** 2
  t551 = 0.1e1 / t550
  t552 = t43 * t551
  t553 = t552 * t21
  t554 = t426 ** 2
  t555 = t374 ** 2
  t556 = t554 * t555
  t558 = t553 * t425 * t556
  t561 = s0 * t11
  t563 = t412 * t416 * t561
  t568 = 0.14764627977777777777777777777777777777777777777777e-2 * t4 * t76 * t33
  t569 = t98 * t120
  t572 = 0.35616666666666666666666666666666666666666666666666e-1 * t509 * t569 * t333
  t573 = t119 * t29
  t574 = 0.1e1 / t573
  t575 = t118 * t574
  t576 = t165 * t152
  t578 = 0.20000000000000000000000000000000000000000000000000e1 * t575 * t576
  t585 = -0.42198333333333333333333333333333333333333333333333e0 * t66 + 0.84396666666666666666666666666666666666666666666666e0 * t74 + 0.39862222222222222222222222222222222222222222222223e0 * t77 + 0.68258333333333333333333333333333333333333333333333e-1 * t81 + 0.13651666666666666666666666666666666666666666666667e0 * t85 + 0.13692777777777777777777777777777777777777777777778e0 * t88
  t586 = t585 * t152
  t588 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * t586
  t589 = t165 * t176
  t591 = 0.16081979498692535066756296899072713062105388428051e2 * t460 * t589
  t595 = 0.24415263074675393406472461472505321282722606644045e-3 * t336 * t70 * t72 * t337
  t598 = 0.10843581300301739842632067522386578331157260943710e-1 * t464 * t102 * t345
  t600 = 0.11696447245269292414524477327518106963944910680856e1 * t50 * t469
  t602 = 0.58482236226346462072622386637590534819724553404280e0 * t50 * t477
  t604 = 0.17315859105681463759666483083807725165579399831905e2 * t50 * t482
  t605 = -t568 - t572 - t578 + t588 + t591 + t595 + t598 + t600 - t602 - t604
  t606 = t605 * t374
  t608 = t424 * t425 * t606
  t611 = t544 * t415
  t613 = t543 * t611 * t417
  t614 = t554 * t374
  t616 = t553 * t425 * t614
  t620 = 0.1e1 / t9 / t126
  t626 = 0.16681137650787305000000000000000000000000000000000e-2 * t498 * t394 * t398 - 0.82386285397499523027777777777777777777777777777777e-5 * t504 * t505 * t510 - 0.55603792169291016666666666666666666666666666666666e-3 * t515 * t518 + 0.14648281543675415194338888888888888888888888888889e-4 * t525 * t503 * t43 * t381 * t509 + 0.98863542476999427633333333333333333333333333333332e-3 * t531 * t532 * t517 - 0.29659062743099828290000000000000000000000000000000e-2 * t404 * t396 * t204 * t43 * t381 + 0.55603792169291016666666666666666666666666666666666e-2 * t549 * t558 - 0.12974218172834570555555555555555555555555555555555e-1 * t563 * t429 + 0.27801896084645508333333333333333333333333333333333e-2 * t419 * t608 - 0.27801896084645508333333333333333333333333333333333e-2 * t613 * t616 + 0.21623696954724284259259259259259259259259259259259e-1 * t379 * t620 * t43 * t381 * t385
  t627 = t375 * t626
  t630 = t496 * t490
  t633 = t394 * t371 * t374
  t636 = t552 * t384
  t639 = t636 * t5 * t605 * t427
  t643 = t555 * t605
  t645 = t636 * t5 * t426 * t643
  t648 = t498 * t514
  t652 = t422 * t605 * t374
  t653 = t507 * t652
  t656 = t542 * t544
  t657 = t656 * t546
  t658 = t393 * t657
  t659 = t551 * t554
  t660 = t659 * t555
  t661 = t507 * t660
  t664 = t656 * t415
  t665 = t393 * t664
  t666 = t659 * t374
  t667 = t507 * t666
  t671 = 0.1e1 / t24 / t502
  t677 = t401 ** 2
  t678 = 0.1e1 / t677
  t679 = t357 * t678
  t681 = t679 * t362 * t378
  t682 = t126 * t7
  t684 = 0.1e1 / t9 / t682
  t686 = t684 * t43 * t381
  t687 = t23 * t5
  t691 = 0.1e1 / t682
  t698 = 0.1e1 / t9 / t502
  t704 = t403 * t657
  t708 = t403 * t664
  t712 = t691 * t402
  t716 = -0.83405688253936524999999999999999999999999999999999e-2 * t613 * t639 + 0.16681137650787305000000000000000000000000000000000e-1 * t549 * t645 + 0.50043412952361914999999999999999999999999999999999e-2 * t648 * t518 - 0.83405688253936524999999999999999999999999999999999e-3 * t515 * t653 - 0.16681137650787305000000000000000000000000000000000e-2 * t658 * t661 + 0.83405688253936524999999999999999999999999999999999e-3 * t665 * t667 + 0.17685589265329897609962962962962962962962962962963e-1 * t404 * t396 * t671 * t43 * t381 + 0.26044644584654888215534544444444444444444444444445e-5 * t681 * t686 * t687 - 0.16113109698042956713772777777777777777777777777778e-3 * t525 * t691 * t43 * t381 * t509 - 0.93702686803805231790123456790123456790123456790122e-1 * t379 * t698 * t43 * t381 * t385 + 0.29659062743099828289999999999999999999999999999999e-2 * t704 * t532 * t660 - 0.14829531371549914145000000000000000000000000000000e-2 * t708 * t532 * t666 + 0.90624913937249475330555555555555555555555555555555e-4 * t712 * t505 * t510
  t717 = t684 * t522
  t719 = t508 * t687
  t722 = t205 * t43
  t726 = t410 ** 2
  t727 = 0.1e1 / t726
  t728 = t361 * t727
  t729 = t413 ** 2
  t730 = t414 ** 2
  t731 = 0.1e1 / t730
  t732 = t729 * t731
  t734 = t728 * t732 * t417
  t736 = 0.1e1 / t550 / t355
  t737 = t43 * t736
  t738 = t737 * t21
  t739 = t554 * t426
  t740 = t555 * t374
  t743 = t738 * t425 * t739 * t740
  t746 = t729 * t546
  t748 = t728 * t746 * t417
  t751 = t738 * t425 * t739 * t555
  t757 = t543 * t611 * t561
  t760 = 0.32530743900905219527896202567159734993471782831130e-1 * t471
  t761 = 0.21687162600603479685264135044773156662314521887420e-1 * t474
  t762 = 0.16265371950452609763948101283579867496735891415565e-1 * t479
  t763 = 0.48159733137676571081572406076840235616767705782485e0 * t484
  t764 = 0.51947577317044391278999449251423175496738199495715e2 * t115
  t765 = t467 * t112
  t767 = t58 * t765 * t344
  t768 = t50 * t767
  t769 = 0.35089341735807877243573431982554320891834732042568e1 * t768
  t771 = t344 * t90
  t773 = t50 * t466 * t112 * t771
  t774 = 0.35089341735807877243573431982554320891834732042568e1 * t773
  t775 = 0.51726012919273400298984252201052768390886626637712e3 * t171
  t776 = 0.96491876992155210400537781394436278372632330568306e2 * t178
  t777 = 0.10000000000000000000000000000000000000000000000000e1 * t154
  t779 = 0.1e1 / t57 / t56
  t782 = 0.1e1 / t95 / t94
  t783 = t779 * t765 * t782
  t784 = t50 * t783
  t785 = 0.10254018858216406658218194626490193680059335835414e4 * t784
  t786 = -t760 - t761 + t762 + t763 - t764 - t769 + t774 + t775 - t776 + t777 - t785
  t795 = -0.34523333333333333333333333333333333333333333333333e1 * t128 + 0.23015555555555555555555555555555555555555555555556e1 * t133 - 0.26851481481481481481481481481481481481481481481482e1 * t136 - 0.93932222222222222222222222222222222222222222222223e0 * t138 + 0.73355000000000000000000000000000000000000000000000e-1 * t142 - 0.14671000000000000000000000000000000000000000000000e0 * t144 - 0.17116166666666666666666666666666666666666666666667e0 * t146 - 0.36793333333333333333333333333333333333333333333333e0 * t149
  t797 = t342 * t795 * t344
  t798 = t50 * t797
  t799 = 0.58482236226346462072622386637590534819724553404280e0 * t798
  t801 = 0.1e1 / t57 / t55
  t803 = t801 * t765 * t96
  t804 = t50 * t803
  t805 = 0.10389515463408878255799889850284635099347639899143e3 * t804
  t806 = 0.34450798614814814814814814814814814814814814814813e-2 * t35
  t807 = t585 * t176
  t809 = t460 * t807 * t164
  t810 = 0.48245938496077605200268890697218139186316165284153e2 * t809
  t811 = 0.60000000000000000000000000000000000000000000000000e1 * t462
  t813 = t575 * t333 * t585
  t814 = 0.60000000000000000000000000000000000000000000000000e1 * t813
  t815 = t72 * t120
  t817 = t509 * t815 * t333
  t818 = 0.71233333333333333333333333333333333333333333333331e-1 * t817
  t820 = t509 * t569 * t586
  t821 = 0.53424999999999999999999999999999999999999999999999e-1 * t820
  t822 = t98 * t459
  t824 = t509 * t822 * t589
  t825 = 0.85917975471764868594145516183295969534298037676861e0 * t824
  t828 = t509 * t98 * t574 * t576
  t829 = 0.10685000000000000000000000000000000000000000000000e0 * t828
  t832 = t336 * t70 * t11 * t337
  t833 = 0.56968947174242584615102410102512416326352748836105e-3 * t832
  t834 = -t799 + t805 + t806 + t810 + t811 - t814 + t818 - t821 - t825 + t829 - t833
  t835 = t786 + t834
  t838 = t424 * t425 * t835 * t374
  t841 = t729 * t415
  t843 = t728 * t841 * t417
  t846 = t738 * t425 * t739 * t374
  t849 = s0 * t620
  t851 = t412 * t416 * t849
  t855 = t543 * t547 * t561
  t858 = t523 * t411
  t859 = s0 * t503
  t861 = t858 * t416 * t859
  t862 = t423 * t1
  t864 = t862 * t70 * t427
  t867 = t504 * t411
  t868 = t416 * s0
  t872 = t671 * t360
  t879 = -0.14648281543675415194338888888888888888888888888889e-5 * t717 * t505 * t719 - 0.88977188229299484869999999999999999999999999999999e-2 * t531 * t722 * t517 + 0.16681137650787305000000000000000000000000000000000e-1 * t734 * t743 - 0.16681137650787305000000000000000000000000000000000e-1 * t748 * t751 - 0.19461327259251855833333333333333333333333333333333e-1 * t563 * t608 + 0.19461327259251855833333333333333333333333333333333e-1 * t757 * t616 + 0.27801896084645508333333333333333333333333333333333e-2 * t419 * t838 + 0.27801896084645508333333333333333333333333333333333e-2 * t843 * t846 + 0.64871090864172852777777777777777777777777777777776e-1 * t851 * t429 - 0.38922654518503711666666666666666666666666666666665e-1 * t855 * t558 + 0.43944844631026245583016666666666666666666666666667e-4 * t861 * t864 - 0.24715885619249856908333333333333333333333333333334e-4 * t867 * t868 * t864 - 0.99469005991731707592592592592592592592592592592592e-2 * t872 * t394 * t398 + 0.14829531371549914145000000000000000000000000000000e-2 * t531 * t532 * t652
  t880 = t716 + t879
  t881 = t392 * t880
  t884 = t392 * t626
  t892 = t420 * t354
  t893 = 0.1e1 / t892
  t895 = t513 * t893 * t374
  t898 = t442 * t835
  t902 = t442 * t605
  t904 = t413 * t893
  t905 = t904 * t427
  t911 = 0.1e1 / t550 / t353
  t912 = t544 * t911
  t916 = 0.70312500000000000000000000000000000000000000000000e0 * t492 * t375 - 0.93750000000000000000000000000000000000000000000000e0 * t497 * t627 + 0.93750000000000000000000000000000000000000000000000e0 * t630 * t426 * t633 + 0.25000000000000000000000000000000000000000000000000e0 * t881 * t375 - 0.75000000000000000000000000000000000000000000000000e0 * t884 * t426 * t633 - 0.75000000000000000000000000000000000000000000000000e0 * t438 * t605 * t633 + 0.75000000000000000000000000000000000000000000000000e0 * t438 * t554 * t895 - 0.10000000000000000000000000000000000000000000000000e1 * t898 * t362 * t445 + 0.30000000000000000000000000000000000000000000000000e1 * t902 * t411 * t905 - 0.10000000000000000000000000000000000000000000000000e1 * t442 * t739 * t542 * t912 * t374
  t919 = t351 * t355 * t916 * t453
  t924 = 0.13780319445925925925925925925925925925925925925925e-1 * t35 - 0.20779030926817756511599779700569270198695279798286e3 * t115 + 0.40000000000000000000000000000000000000000000000000e1 * t154 + 0.20690405167709360119593700880421107356354650655085e4 * t171 - 0.38596750796862084160215112557774511349052932227323e3 * t178 + 0.12e2 * t284 * t456 + 0.24000000000000000000000000000000000000000000000000e2 * t462 - 0.13012297560362087811158481026863893997388713132452e0 * t471 - 0.86748650402413918741056540179092626649258087549680e-1 * t474 + 0.65061487801810439055792405134319469986943565662260e-1 * t479 + 0.19263893255070628432628962430736094246707082312994e1 * t484 + 0.4e1 * t919 - 0.23392894490538584829048954655036213927889821361712e1 * t798 + 0.41558061853635513023199559401138540397390559596572e3 * t804 + 0.14035736694323150897429372793021728356733892817027e2 * t773
  t930 = t351 * t355
  t943 = t904 * t374
  t946 = -0.31250000000000000000000000000000000000000000000000e0 * t630 * t375 + 0.25000000000000000000000000000000000000000000000000e0 * t884 * t375 - 0.50000000000000000000000000000000000000000000000000e0 * t438 * t426 * t633 - 0.10000000000000000000000000000000000000000000000000e1 * t902 * t362 * t445 + 0.10000000000000000000000000000000000000000000000000e1 * t442 * t554 * t411 * t943
  t947 = t452 ** 2
  t948 = 0.1e1 / t947
  t951 = t930 * t946 * t948 * t448
  t955 = t448 ** 2
  t959 = 0.1e1 / t947 / t452
  t961 = t351 * t355 * t955 * t448 * t959
  t965 = f.my_piecewise3(t199, 0, t242)
  t967 = f.my_piecewise3(t258, 0, -0.7e0 * t269)
  t968 = f.my_piecewise3(t194, t965, t967)
  t969 = -t806 + t764 - t777 - t775 + t776 - t811 + t760 + t761 - t762 - t763 - t919 + t799 - t805
  t971 = t288 ** 2
  t972 = 0.1e1 / t971
  t973 = t292 ** 2
  t974 = t973 * t292
  t975 = t972 * t974
  t977 = t288 * t287
  t978 = 0.1e1 / t977
  t979 = t978 * t292
  t983 = -0.49388888888888888888888888888888888888888888888889e-2 * t66 + 0.98777777777777777777777777777777777777777777777777e-2 * t74 + 0.13949000000000000000000000000000000000000000000000e-1 * t77
  t990 = -0.29633333333333333333333333333333333333333333333333e-1 * t128 + 0.19755555555555555555555555555555555555555555555555e-1 * t133 - 0.23048148148148148148148148148148148148148148148148e-1 * t136 - 0.32547666666666666666666666666666666666666666666667e-1 * t138
  t991 = t289 * t990
  t995 = t307 * t983
  t999 = 0.1e1 / t971 / t287
  t1000 = t999 * t974
  t1003 = t978 * t973
  t1004 = t297 * t312
  t1005 = t1003 * t1004
  t1007 = t298 * t299 * t131
  t1012 = t972 * t983
  t1013 = t292 * t297
  t1014 = t1013 * t306
  t1017 = t289 * t983
  t1018 = t1017 * t1004
  t1022 = 0.1e1 / t971 / t288
  t1023 = t1022 * t974
  t1026 = t972 * t973
  t1027 = t1026 * t1004
  t1030 = t303 ** 2
  t1032 = 0.1e1 / t304 / t1030
  t1033 = t297 * t1032
  t1034 = t293 * t1033
  t1035 = t184 ** 2
  t1037 = 0.1e1 / t187 / t186
  t1038 = t1035 * t1037
  t1039 = s0 ** 2
  t1040 = t43 * t1039
  t1041 = t126 * t8
  t1043 = 0.1e1 / t9 / t1041
  t1045 = t1038 * t1040 * t1043
  t1048 = t293 * t1004
  t1050 = t298 * t299 * t204
  t1055 = 0.1e1 / t304 / t1030 / t303
  t1056 = t310 * t1055
  t1057 = 0.1e1 / t413
  t1058 = t1039 * s0
  t1059 = t1057 * t1058
  t1060 = t126 ** 2
  t1062 = 0.1e1 / t1060 / t8
  t1067 = t310 * t1032 * t1035
  t1068 = t1037 * t43
  t1070 = 0.1e1 / t9 / t1060
  t1075 = s0 * t671
  t1079 = -0.60000000000000000000000000000000000000000000000000e1 * t975 * t307 + 0.60000000000000000000000000000000000000000000000000e1 * t979 * t995 - 0.60000000000000000000000000000000000000000000000000e1 * t1000 * t307 - 0.85350568417505433333333333333333333333333333333330e-1 * t1005 * t1007 - 0.10000000000000000000000000000000000000000000000000e1 * t991 * t307 + 0.30000000000000000000000000000000000000000000000000e1 * t1012 * t1014 + 0.42675284208752716666666666666666666666666666666665e-1 * t1018 * t1007 - 0.10000000000000000000000000000000000000000000000000e1 * t1023 * t307 - 0.42675284208752716666666666666666666666666666666665e-1 * t1027 * t1007 + 0.60705996076593966087358779412675925925925925925921e-2 * t1034 * t1045 - 0.15647604209875996111111111111111111111111111111110e0 * t1048 * t1050 - 0.31087747628928898252912838668079770391184269901849e-2 * t1056 * t1059 * t1062 + 0.22258865228084454232031552451314506172839506172838e-1 * t1067 * t1068 * t1039 * t1070 - 0.24340717659807105061728395061728395061728395061728e0 * t314 * t191 * t1075
  t1097 = 0.20000000000000000000000000000000000000000000000000e1 * t1003 * t307 - 0.10000000000000000000000000000000000000000000000000e1 * t1017 * t307 + 0.10000000000000000000000000000000000000000000000000e1 * t1026 * t307 + 0.28450189472501811111111111111111111111111111111110e-1 * t1048 * t1007 - 0.20235332025531322029119593137558641975308641975307e-2 * t1067 * t1068 * t1039 * t1043 + 0.52158680699586653703703703703703703703703703703702e-1 * t314 * t191 * t205
  t1098 = t320 ** 2
  t1099 = 0.1e1 / t1098
  t1103 = t318 ** 2
  t1106 = 0.1e1 / t1098 / t320
  t1112 = -t774 - t818 + t821 + t825 - t829 + t833 + 0.3e1 * t951 - t810 + t814 + (0.1714584e0 * t975 - 0.1714584e0 * t979 * t983 + 0.285764e-1 * t991 + 0.285764e-1 * t1079 * t321 - 0.857292e-1 * t1097 * t1099 * t318 + 0.571528e-1 * t1103 * t318 * t1106) * t328 - 0.2e1 * t961 + t769 + t785
  t1113 = t969 + t1112
  t1117 = f.my_piecewise3(t199, 0, t248 * t242)
  t1121 = f.my_piecewise3(t258, 0, -0.105e1 * t272 * t264 * t269)
  t1122 = f.my_piecewise3(t194, t1117, t1121)
  t1137 = (-0.571528e-1 * t1003 + 0.285764e-1 * t1017 + 0.285764e-1 * t1097 * t321 - 0.285764e-1 * t1103 * t1099) * t328 + t568 + t572 + t578 - t588 - t591 - t595 - t598 - t600 + t602 + t604 - t351 * t355 * t946 * t453 + t351 * t355 * t955 * t948
  t1146 = 0.5e1 / 0.9e1 * (-0.440e3 / 0.27e2 * tau0 * t204 + 0.154e3 / 0.27e2 * t1075) * t184 * t191
  t1147 = f.my_piecewise3(t200, t1146, 0)
  t1153 = t226 * t225
  t1156 = t227 ** 2
  t1157 = 0.1e1 / t1156
  t1158 = t212 * t1157
  t1166 = -0.64e0 * t1147 * t214 - 0.384e1 * t211 * t228 * t225 - 0.384e1 * t1153 * t232 - 0.384e1 * t1158 * t1153 - 0.384e1 * t233 * t225 * t211 - 0.64e0 * t236 * t1147
  t1174 = f.my_piecewise3(t199, 0, 0.3e1 * t239 * t248 * t242 + t249 * t248 * t242 + t1166 * t242)
  t1175 = t265 * t264
  t1179 = t263 * t264
  t1180 = t269 * t273
  t1184 = 0.1e1 / t277 / t260
  t1188 = f.my_piecewise3(t258, 0, t1146)
  t1193 = t264 * t269
  t1197 = 0.1e1 / t277 / t261
  t1202 = f.my_piecewise3(t258, 0, -0.630e1 * t278 * t1175 * t269 - 0.630e1 * t1179 * t1180 - 0.9450e1 * t1184 * t1175 * t269 - 0.105e1 * t272 * t1188 * t269 - 0.4725e1 * t278 * t273 * t1193 - 0.23625e1 * t1197 * t1175 * t269)
  t1203 = f.my_piecewise3(t194, t1174, t1202)
  t1205 = jnp.log(t320)
  t1209 = jnp.log(t452)
  t1212 = (-0.285764e-1 * t295 + 0.285764e-1 * t1205) * t328 + t365 - t368 - t351 * t355 * t1209
  t1218 = 0.12e2 * t930 * t946 * t959 * t955
  t1224 = 0.1e1 / t24 / t682
  t1225 = s0 * t1224
  t1230 = 0.5e1 / 0.9e1 * (0.6160e4 / 0.81e2 * tau0 * t671 - 0.2618e4 / 0.81e2 * t1225) * t184 * t191
  t1231 = f.my_piecewise3(t200, t1230, 0)
  t1240 = t211 ** 2
  t1243 = t226 ** 2
  t1266 = t239 ** 2
  t1272 = t249 ** 2
  t1275 = f.my_piecewise3(t199, 0, (-0.64e0 * t1231 * t214 - 0.512e1 * t1147 * t228 * t225 - 0.2304e2 * t211 * t232 * t226 - 0.384e1 * t1240 * t228 - 0.1536e2 * t1243 * t1157 - 0.1536e2 * t212 / t1156 / t213 * t1243 - 0.2304e2 * t1158 * t226 * t211 - 0.384e1 * t233 * t1240 - 0.512e1 * t233 * t225 * t1147 - 0.64e0 * t236 * t1231) * t242 + 0.4e1 * t1166 * t248 * t242 + 0.3e1 * t1266 * t242 + 0.6e1 * t239 * t249 * t242 + t1272 * t242)
  t1276 = t265 ** 2
  t1285 = t273 ** 2
  t1300 = f.my_piecewise3(t258, 0, t1230)
  t1314 = t277 ** 2
  t1319 = -0.2520e2 * t1184 * t1276 * t269 - 0.3780e2 * t279 * t1180 - 0.56700e2 * t1197 * t1276 * t269 - 0.630e1 * t263 * t1285 * t269 - 0.56700e2 * t1184 * t265 * t1180 - 0.840e1 * t1179 * t269 * t1188 - 0.283500e2 / t277 / t262 * t1276 * t269 - 0.105e1 * t272 * t1300 * t269 - 0.6300e1 * t278 * t1188 * t1193 - 0.4725e1 * t278 * t1285 * t269 - 0.141750e2 * t1197 * t273 * t265 * t269 - 0.354375e1 / t1314 * t1276 * t269
  t1320 = f.my_piecewise3(t258, 0, t1319)
  t1321 = f.my_piecewise3(t194, t1275, t1320)
  t1323 = t90 ** 2
  t1327 = 0.51947577317044391278999449251423175496738199495715e2 * t50 * t58 * t1323 * t96
  t1331 = 0.35089341735807877243573431982554320891834732042568e1 * t50 * t466 * t1323 * t344
  t1332 = t467 ** 2
  t1336 = 0.62337092780453269534799339101707810596085839394858e3 * t50 * t779 * t1332 * t96
  t1342 = 0.12304822629859687989861833551788232416071203002497e5 * t50 / t57 / t465 * t1332 * t782
  t1346 = 0.14035736694323150897429372793021728356733892817027e2 * t50 * t801 * t1332 * t344
  t1349 = 0.80000000000000000000000000000000000000000000000000e1 * t575 * t333 * t151
  t1354 = 0.34367190188705947437658206473318387813719215070744e1 * t103 * t459 * t585 * t176 * t164
  t1358 = 0.42740000000000000000000000000000000000000000000000e0 * t103 * t574 * t164 * t586
  t1359 = t946 ** 2
  t1363 = 0.3e1 * t351 * t355 * t1359 * t948
  t1364 = t585 ** 2
  t1367 = 0.48245938496077605200268890697218139186316165284153e2 * t460 * t1364 * t176
  t1371 = t165 ** 2
  t1374 = 0.62071215503128080358781102641263322069063951965254e4 * t118 / t156 / t573 * t1371 * t169
  t1375 = 0.6e1 * t284 * t1137 + t1321 * t1212 + t1218 - t1327 + t1331 - t1336 + t1342 + t1346 - t1349 - t1354 + t1358 - t1363 + t1367 - t1374
  t1378 = 0.57895126195293126240322668836661767023579398340984e3 * t159 * t1371 * t176
  t1381 = t6 * t620
  t1384 = 0.11483599538271604938271604938271604938271604938271e-1 * t4 * t1381 * t33
  t1387 = 0.57895126195293126240322668836661767023579398340984e3 * t175 * t807 * t165
  t1388 = t955 ** 2
  t1390 = t947 ** 2
  t1394 = 0.6e1 * t351 * t355 * t1388 / t1390
  t1397 = 0.60000000000000000000000000000000000000000000000000e1 * t575 * t1364 * t152
  t1401 = 0.31035607751564040179390551320631661034531975982628e4 * t159 * t585 * t169 * t165
  t1402 = t156 ** 2
  t1405 = t167 ** 2
  t1409 = 0.24955700379505800914252936827276051226357058527653e5 * t118 / t1402 * t1371 / t1405
  t1412 = 0.24000000000000000000000000000000000000000000000000e2 * t175 * t1371 * t152
  t1415 = 0.86748650402413918741056540179092626649258087549680e-1 * t464 * t76 * t469
  t1418 = 0.67471172535210825687488420139294265171645179205307e-1 * t464 * t12 * t345
  t1421 = 0.21687162600603479685264135044773156662314521887420e-1 * t464 * t102 * t797
  t1424 = 0.38527786510141256865257924861472188493414164625988e1 * t464 * t102 * t803
  t1427 = 0.43374325201206959370528270089546313324629043774840e-1 * t464 * t76 * t477
  t1428 = 0.4e1 * t1122 * t1113 + t1378 - t1384 - t1387 - t1394 - t1397 + t1401 + t1409 - t1412 + t1415 + t1418 + t1421 - t1424 - t1427
  t1432 = 0.12842595503380418955085974953824062831138054875329e1 * t464 * t76 * t482
  t1435 = 0.13012297560362087811158481026863893997388713132452e0 * t464 * t102 * t767
  t1438 = 0.38025319932552508024225805073234468230220037056326e2 * t464 * t102 * t783
  t1442 = 0.22911460125803964958438804315545591875812810047162e1 * t509 * t72 * t459 * t589
  t1450 = 0.1e1 / t16 * r0 * t698 * t509 / 0.48e2
  t1452 = t125 * t503
  t1454 = t62 * t204
  t1455 = t61 * t1454
  t1457 = t70 * t620
  t1458 = t69 * t1457
  t1460 = t4 * t1381
  t1462 = t15 ** (-0.25e1)
  t1465 = t1462 * t2 * t698 * t509
  t1467 = t141 * t503
  t1469 = t80 * t1454
  t1471 = t84 * t1457
  t1474 = t23 * t5 * t204
  t1479 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * (-0.21099166666666666666666666666666666666666666666667e1 * t1450 + 0.20255200000000000000000000000000000000000000000000e2 * t1452 - 0.75019259259259259259259259259259259259259259259258e1 * t1455 + 0.65641851851851851851851851851851851851851851851850e1 * t1458 + 0.31003950617283950617283950617283950617283950617285e1 * t1460 + 0.68258333333333333333333333333333333333333333333335e-1 * t1465 - 0.10921333333333333333333333333333333333333333333333e1 * t1467 + 0.12134814814814814814814814814814814814814814814815e1 * t1469 + 0.10617962962962962962962962962962962962962962962963e1 * t1471 + 0.13388493827160493827160493827160493827160493827161e1 * t1474) * t152
  t1482 = 0.36000000000000000000000000000000000000000000000000e2 * t460 * t576 * t585
  t1483 = t47 * t509
  t1485 = t90 * t96
  t1489 = 0.19263893255070628432628962430736094246707082312995e1 * t1483 * t98 * t58 * t1485 * t112
  t1491 = t112 * t344
  t1495 = 0.13012297560362087811158481026863893997388713132452e0 * t1483 * t98 * t466 * t1491 * t90
  t1499 = 0.4e1 * t930 * t916 * t948 * t448
  t1500 = t57 ** 2
  t1503 = t95 ** 2
  t1507 = 0.91082604192152556048340974007871726131433263376469e5 * t50 / t1500 * t1332 / t1503
  t1522 = 0.58482236226346462072622386637590534819724553404280e0 * t50 * t342 * (-0.28769444444444444444444444444444444444444444444444e1 * t1450 + 0.27618666666666666666666666666666666666666666666667e2 * t1452 - 0.10229135802469135802469135802469135802469135802469e2 * t1455 + 0.89504938271604938271604938271604938271604938271607e1 * t1458 + 0.31310740740740740740740740740740740740740740740741e1 * t1460 + 0.36677500000000000000000000000000000000000000000000e-1 * t1465 - 0.58684000000000000000000000000000000000000000000000e0 * t1467 + 0.65204444444444444444444444444444444444444444444445e0 * t1469 + 0.57053888888888888888888888888888888888888888888890e0 * t1471 + 0.13490888888888888888888888888888888888888888888889e1 * t1474) * t344
  t1523 = -t1218 + t1327 - t1331 + t1336 - t1342 - t1346 + t1349 + t1354 - t1358 + t1363 - t1367 + t1374 - t1378
  t1524 = t1384 + t1387 + t1394 + t1397 - t1401 - t1409 + t1412 - t1415 - t1418 - t1421 + t1424 + t1427 + t1432
  t1526 = t973 ** 2
  t1527 = t999 * t1526
  t1531 = t983 ** 2
  t1532 = t978 * t1531
  t1542 = t289 * (-0.24694444444444444444444444444444444444444444444444e-1 * t1450 + 0.23706666666666666666666666666666666666666666666666e0 * t1452 - 0.87802469135802469135802469135802469135802469135800e-1 * t1455 + 0.76827160493827160493827160493827160493827160493827e-1 * t1458 + 0.10849222222222222222222222222222222222222222222222e0 * t1460)
  t1577 = t971 ** 2
  t1597 = -0.17070113683501086666666666666666666666666666666666e0 * t1012 * t1013 * t312 * t1007 - 0.34140227367002173333333333333333333333333333333332e0 * t979 * t1004 * t184 * t191 * t219 * t983 + 0.80000000000000000000000000000000000000000000000000e1 * t979 * t307 * t990 - 0.60000000000000000000000000000000000000000000000000e1 * t1022 * t983 * t973 * t297 * t306 + 0.40000000000000000000000000000000000000000000000000e1 * t972 * t990 * t1014 - 0.36000000000000000000000000000000000000000000000000e2 * t999 * t973 * t995 - 0.36000000000000000000000000000000000000000000000000e2 * t1026 * t995 + 0.68393044783643576156408245069775494860605393784069e-1 * t1056 * t1059 / t1060 / t126 + 0.60000000000000000000000000000000000000000000000000e1 * t1532 * t307 + 0.10000000000000000000000000000000000000000000000000e1 / t1577 * t1526 * t307 - 0.10000000000000000000000000000000000000000000000000e1 * t1542 * t307 + 0.30000000000000000000000000000000000000000000000000e1 * t972 * t1531 * t307 + 0.24000000000000000000000000000000000000000000000000e2 * t1527 * t307 + 0.36000000000000000000000000000000000000000000000000e2 * t1022 * t1526 * t307 + 0.12000000000000000000000000000000000000000000000000e2 / t971 / t977 * t1526 * t307
  t1649 = t1030 ** 2
  t1653 = t1039 ** 2
  t1663 = -0.24282398430637586434943511765070370370370370370368e-1 * t1003 * t1033 * t1045 + 0.56900378945003622222222222222222222222222222222220e-1 * t991 * t1004 * t1007 + 0.12141199215318793217471755882535185185185185185184e-1 * t1017 * t1033 * t1045 + 0.56900378945003622222222222222222222222222222222220e-1 * t1023 * t1004 * t1007 - 0.12141199215318793217471755882535185185185185185184e-1 * t1026 * t1033 * t1045 + 0.34140227367002173333333333333333333333333333333332e0 * t975 * t1004 * t1007 + 0.34140227367002173333333333333333333333333333333332e0 * t1000 * t1004 * t1007 + 0.31295208419751992222222222222222222222222222222221e0 * t1027 * t1050 - 0.89035460912337816928126209805258024691358024691350e-1 * t1034 * t1038 * t1040 * t1070 + 0.97362870639228420246913580246913580246913580246908e0 * t1048 * t298 * t299 * t671 - 0.31295208419751992222222222222222222222222222222221e0 * t1018 * t1050 + 0.62590416839503984444444444444444444444444444444441e0 * t1005 * t1050 + 0.12435099051571559301165135467231908156473707960740e-1 * t293 * t297 * t1055 * t1057 * t1058 * t1062 - 0.22011544503327960296120090757411011659807956104251e0 * t1067 * t1068 * t1039 / t9 / t1060 / r0 + 0.13793073340557359534979423868312757201646090534979e1 * t314 * t191 * t1225 - 0.57489400170562495257927652663499439366228807233633e-3 * t310 / t304 / t1649 * t1057 * t1653 / t24 / t1060 / t682 * t184 * t191
  t1673 = t1097 ** 2
  t1676 = t1103 ** 2
  t1677 = t1098 ** 2
  t1686 = t727 * t729
  t1687 = t1686 * t415
  t1689 = t736 * t739
  t1690 = t1689 * t374
  t1699 = t1686 * t546
  t1701 = t1689 * t555
  t1719 = t362 * jnp.pi
  t1722 = 0.1e1 / t24 / t1041
  t1748 = t605 ** 2
  t1759 = -0.11120758433858203333333333333333333333333333333333e-2 * t393 * t1687 * t507 * t1690 + 0.10008682590472383000000000000000000000000000000000e-1 * t648 * t653 - 0.10008682590472383000000000000000000000000000000000e-1 * t498 * t664 * t667 + 0.66724550603149220000000000000000000000000000000000e-2 * t393 * t1699 * t507 * t1701 - 0.39787602396692683037037037037037037037037037037037e-1 * t872 * t514 * t518 + 0.20017365180944765999999999999999999999999999999999e-1 * t498 * t657 * t661 - 0.11687867688391932333540740740740740740740740740740e0 * t404 * t396 * t1224 * t43 * t381 + 0.18522951228606556498888168008888888888888888888889e-5 * t357 / t677 / t359 * t1719 * t396 * t1722 * t43 * t381 - 0.37481074721522092716049382716049382716049382716048e0 * t412 * t416 * s0 * t698 * t429 - 0.12974218172834570555555555555555555555555555555555e0 * t543 * t611 * t849 * t616 + 0.15569061807401484666666666666666666666666666666666e0 * t728 * t746 * t561 * t751 + 0.12974218172834570555555555555555555555555555555555e0 * t851 * t608 - 0.64452438792171826855091111111111111111111111111112e-3 * t858 * t416 * s0 * t691 * t864 - 0.83405688253936524999999999999999999999999999999999e-2 * t613 * t553 * t425 * t1748 * t374 + 0.16681137650787305000000000000000000000000000000000e-1 * t549 * t553 * t425 * t1748 * t555
  t1762 = t361 / t726 / t349
  t1763 = t729 * t186
  t1770 = t43 / t550 / t892 * t21
  t1771 = t554 ** 2
  t1785 = t507 * t551
  t1786 = t426 * t555
  t1787 = t1786 * t605
  t1791 = 0.1e1 / t1041
  t1797 = t422 * t835 * t374
  t1812 = t1686 * t731
  t1814 = t1689 * t740
  t1819 = t605 * t426 * t374
  t1841 = -0.10008682590472383000000000000000000000000000000000e0 * t1762 * t1763 * t731 * t417 * t1770 * t425 * t1771 * t740 + 0.38922654518503711666666666666666666666666666666667e-1 * t1762 * t1763 * t546 * t417 * t1770 * t425 * t1771 * t555 - 0.66724550603149220000000000000000000000000000000000e-2 * t658 * t1785 * t1787 - 0.83850930471232847881604938271604938271604938271605e-3 * t1791 * t402 * t505 * t510 + 0.19772708495399885526666666666666666666666666666667e-2 * t531 * t532 * t1797 + 0.19772708495399885526666666666666666666666666666667e-2 * t403 * t1687 * t532 * t1690 + 0.70742357061319590439851851851851851851851851851852e-1 * t531 * t1075 * t43 * t517 - 0.35590875291719793947999999999999999999999999999999e-1 * t704 * t722 * t660 + 0.11863625097239931316000000000000000000000000000000e-1 * t403 * t1812 * t532 * t1814 + 0.33362275301574610000000000000000000000000000000000e-2 * t665 * t1785 * t1819 - 0.11863625097239931316000000000000000000000000000000e-1 * t403 * t1699 * t532 * t1701 - 0.17795437645859896974000000000000000000000000000000e-1 * t531 * t722 * t652 + 0.17795437645859896974000000000000000000000000000000e-1 * t708 * t722 * t666 + 0.25390354675704053003520740740740740740740740740741e-4 * t1043 * t522 * t505 * t719 - 0.10417857833861955286213817777777777777777777777778e-5 * t1722 * t678 * t1719 * t398
  t1853 = -t1327 + t1331 - t1336 + t1342 + t1346 - t1349 - t1354 + t1358 + t1367 - t1374 + t1378
  t1854 = -t1384 - t1387 - t1397 + t1401 + t1409 - t1412 + t1415 + t1418 + t1421 - t1424 - t1427 - t1432
  t1859 = 0.68734380377411894875316412946636775627438430141488e1 * t509 * t98 * t174 * t177
  t1862 = 0.71233333333333333333333333333333333333333333333332e-1 * t509 * t569 * t153
  t1863 = t1435 + t1438 + t1442 + t1479 + t1482 + t1489 - t1495 - t1507 - t1522 + t1859 - t1862
  t1867 = 0.28493333333333333333333333333333333333333333333333e0 * t509 * t72 * t574 * t576
  t1871 = 0.36846163202829085479643115651216588683774907041596e2 * t509 * t98 * t158 * t170
  t1874 = 0.14246666666666666666666666666666666666666666666666e0 * t509 * t815 * t586
  t1879 = 0.61524113149298439949309167758941162080356015012483e4 * t50 * t779 * t467 * t782 * t90
  t1883 = 0.46785788981077169658097909310072427855779642723424e1 * t50 * t466 * t795 * t1491
  t1886 = 0.21053605041484726346144059189532592535100839225540e2 * t50 * t481 * t771
  t1890 = 0.22161481481481481481481481481481481481481481481481e0 * t509 * t11 * t120 * t333
  t1894 = 0.18989649058080861538367470034170805442117582945368e-2 * t336 * t70 * t620 * t337
  t1897 = 0.42740000000000000000000000000000000000000000000000e0 * t509 * t822 * t461
  t1901 = 0.69263436422725855038665932335230900662317599327620e2 * t50 * t58 * t795 * t113
  t1905 = 0.62337092780453269534799339101707810596085839394858e3 * t50 * t801 * t467 * t1485
  t1909 = 0.64327917994770140267025187596290852248421553712204e2 * t460 * t151 * t176 * t164
  t1910 = -t1867 - t1871 + t1874 - t1879 + t1883 - t1886 - t1890 + t1894 - t1897 - t1901 + t1905 + t1909
  t1912 = t1853 + t1854 + t1863 + t1910
  t1946 = t523 * t542
  t1949 = t552 * t1
  t1965 = t555 ** 2
  t1979 = t509 * t504 * t542
  t1980 = t611 * s0
  t1985 = 0.65736038742361824148148148148148148148148148148147e-1 * t1224 * t360 * t394 * t398 - 0.25948436345669141111111111111111111111111111111111e-1 * t563 * t838 - 0.25948436345669141111111111111111111111111111111111e-1 * t728 * t841 * t561 * t846 + 0.27801896084645508333333333333333333333333333333333e-2 * t419 * t424 * t425 * t1912 * t374 - 0.27801896084645508333333333333333333333333333333333e-2 * t1762 * t1763 * t415 * t417 * t1770 * t425 * t1771 * t374 + 0.25948436345669141111111111111111111111111111111110e0 * t543 * t547 * t849 * t558 - 0.15569061807401484666666666666666666666666666666667e0 * t728 * t732 * t561 * t743 + 0.87889689262052491166033333333333333333333333333335e-4 * t861 * t862 * t70 * t606 + 0.10417857833861955286213817777777777777777777777778e-4 * t679 * t411 * t416 * s0 * t684 * t424 * t62 * t427 + 0.17577937852410498233206666666666666666666666666667e-3 * t1946 * t547 * t859 * t1949 * t70 * t556 - 0.87889689262052491166033333333333333333333333333335e-4 * t1946 * t611 * t859 * t1949 * t70 * t614 + 0.66724550603149220000000000000000000000000000000000e-1 * t1762 * t1763 / t730 / t375 * t417 * t1770 * t425 * t1771 * t1965 - 0.66724550603149220000000000000000000000000000000000e-2 * t393 * t1812 * t507 * t1814 - 0.11120758433858203333333333333333333333333333333333e-2 * t515 * t507 * t1797 + 0.49431771238499713816666666666666666666666666666668e-4 * t1979 * t1980 * t552 * t614
  t2001 = t547 * s0
  t2006 = t5 * t835
  t2011 = t737 * t384
  t2012 = t5 * t554
  t2042 = t403 * t542
  t2044 = t405 * t551
  t2057 = 0.36249965574899790132222222222222222222222222222222e-3 * t712 * t411 * t868 * t864 - 0.58593126174701660777355555555555555555555555555558e-5 * t687 * t717 * t411 * t868 * t423 * t427 - 0.49431771238499713816666666666666666666666666666668e-4 * t509 * t867 * t868 * t423 * t606 - 0.98863542476999427633333333333333333333333333333334e-4 * t1979 * t2001 * t552 * t556 - 0.11120758433858203333333333333333333333333333333333e-1 * t613 * t636 * t2006 * t427 + 0.16681137650787305000000000000000000000000000000000e-1 * t843 * t2011 * t2012 * t606 + 0.10008682590472383000000000000000000000000000000000e0 * t734 * t2011 * t2012 * t740 * t605 - 0.15569061807401484666666666666666666666666666666667e0 * t855 * t645 + 0.77845309037007423333333333333333333333333333333332e-1 * t757 * t639 - 0.10008682590472383000000000000000000000000000000000e0 * t748 * t2011 * t2012 * t643 + 0.22241516867716406666666666666666666666666666666667e-1 * t549 * t636 * t2006 * t1786 + 0.49974766295362790288065843621399176954732510288065e0 * t379 * t686 * t385 - 0.45144050613401806240259877037037037037037037037037e-4 * t681 * t1043 * t43 * t381 * t687 + 0.11863625097239931316000000000000000000000000000000e-1 * t2042 * t2001 * t2044 * t1787 - 0.59318125486199656580000000000000000000000000000000e-2 * t2042 * t1980 * t2044 * t1819 + 0.14908695437785200353349358024691358024691358024692e-2 * t525 * t1791 * t43 * t381 * t509
  t2101 = t626 ** 2
  t2108 = t486 ** 2
  t2111 = t490 ** 2
  t2136 = -0.10000000000000000000000000000000000000000000000000e1 * t881 * t426 * t633 + 0.25000000000000000000000000000000000000000000000000e0 * t392 * (t1759 + t1841 + t1985 + t2057) * t375 + 0.37500000000000000000000000000000000000000000000000e1 * t497 * t426 * t362 * t372 * t374 * t626 - 0.10000000000000000000000000000000000000000000000000e1 * t442 * t1912 * t362 * t445 + 0.30000000000000000000000000000000000000000000000000e1 * t438 * t605 * t411 * t905 - 0.10000000000000000000000000000000000000000000000000e1 * t438 * t835 * t633 - 0.18750000000000000000000000000000000000000000000000e1 * t630 * t554 * t895 + 0.30000000000000000000000000000000000000000000000000e1 * t442 * t1748 * t411 * t943 + 0.40000000000000000000000000000000000000000000000000e1 * t898 * t411 * t905 + 0.15000000000000000000000000000000000000000000000000e1 * t884 * t554 * t895 - 0.10000000000000000000000000000000000000000000000000e1 * t438 * t739 * t656 * t911 * t374 + 0.18750000000000000000000000000000000000000000000000e1 * t630 * t605 * t633 - 0.93750000000000000000000000000000000000000000000000e0 * t496 * t2101 * t375 - 0.15000000000000000000000000000000000000000000000000e1 * t884 * t605 * t633 - 0.22851562500000000000000000000000000000000000000000e1 / t390 / t2108 * t2111 * t375 + 0.42187500000000000000000000000000000000000000000000e1 * t489 * t490 * t627 - 0.28125000000000000000000000000000000000000000000000e1 * t492 * t426 * t633 + 0.10000000000000000000000000000000000000000000000000e1 * t442 * t1771 * t727 * t729 / t550 / t420 * t374 - 0.60000000000000000000000000000000000000000000000000e1 * t902 * t542 * t912 * t614 - 0.12500000000000000000000000000000000000000000000000e1 * t497 * t375 * t880
  t2139 = t351 * t355 * t2136 * t453
  t2140 = -t1435 - t1438 - t1442 - t1479 - t1482 - t1489 + t1495 + t1499 + t1507 + t1522 + (-0.6858336e0 * t1527 + 0.10287504e1 * t1026 * t983 - 0.1714584e0 * t1532 - 0.2286112e0 * t979 * t990 + 0.285764e-1 * t1542 + 0.285764e-1 * (t1597 + t1663) * t321 - 0.1143056e0 * t1079 * t1099 * t318 + 0.3429168e0 * t1097 * t1106 * t1103 - 0.857292e-1 * t1673 * t1099 - 0.1714584e0 * t1676 / t1677) * t328 - t2139 - t1859
  t2141 = t1862 + t1867 + t1871 - t1874 + t1879 - t1883 + t1886 + t1890 - t1894 + t1897 + t1901 - t1905 - t1909
  t2145 = -t1432 + t1435 + t1438 + t1442 + t1479 + t1482 + t1489 - t1495 - t1499 - t1507 - t1522 + t968 * (t1523 + t1524 + t2140 + t2141) + t2139 + t1859
  t2148 = 0.4e1 * t1203 * t456 - t1862 - t1867 - t1871 + t1874 - t1879 + t1883 - t1886 - t1890 + t1894 - t1897 - t1901 + t1905 + t1909
  t2152 = 0.28493333333333333333333333333333333333333333333333e0 * t817 - 0.21370000000000000000000000000000000000000000000000e0 * t820 - 0.34367190188705947437658206473318387813719215070744e1 * t824 + 0.42740000000000000000000000000000000000000000000000e0 * t828 - 0.22787578869697033846040964041004966530541099534442e-2 * t832 - 0.12e2 * t951 + 0.19298375398431042080107556278887255674526466113661e3 * t809 - 0.24000000000000000000000000000000000000000000000000e2 * t813 + 0.8e1 * t961 - 0.14035736694323150897429372793021728356733892817027e2 * t768 - 0.41016075432865626632872778505960774720237343341655e4 * t784 + 0.4e1 * t968 * t1113 + 0.12e2 * t1122 * t1137 + 0.4e1 * t1203 * t1212 + r0 * (t1375 + t1428 + t2145 + t2148)
  v4rho4_0_ = t924 + t2152

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = jnp.log(0.2e1)
  t2 = 0.1e1 - t1
  t3 = jnp.pi ** 2
  t5 = t2 / t3
  t6 = r0 - r1
  t7 = r0 + r1
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t10 = 0.1e1 + t9
  t11 = t10 <= f.p.zeta_threshold
  t12 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t13 = t12 ** 2
  t14 = t10 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t16 = f.my_piecewise3(t11, t13, t15)
  t17 = 0.1e1 - t9
  t18 = t17 <= f.p.zeta_threshold
  t19 = t17 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = f.my_piecewise3(t18, t13, t20)
  t23 = t16 / 0.2e1 + t21 / 0.2e1
  t24 = t23 ** 2
  t25 = t24 * t23
  t26 = 3 ** (0.1e1 / 0.3e1)
  t28 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t29 = t26 * t28
  t30 = 4 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = t7 ** (0.1e1 / 0.3e1)
  t35 = t29 * t31 / t32
  t37 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e-1 * t35
  t39 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t35
  t40 = 0.1e1 / t39
  t42 = 0.1e1 / t2
  t43 = t37 * t40 * t42
  t45 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t35
  t46 = jnp.sqrt(t35)
  t49 = t35 ** 0.15e1
  t51 = t26 ** 2
  t52 = t28 ** 2
  t53 = t51 * t52
  t54 = t32 ** 2
  t57 = t53 * t30 / t54
  t59 = 0.37978500000000000000000000000000000000000000000000e1 * t46 + 0.89690000000000000000000000000000000000000000000000e0 * t35 + 0.20477500000000000000000000000000000000000000000000e0 * t49 + 0.12323500000000000000000000000000000000000000000000e0 * t57
  t62 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t59
  t63 = jnp.log(t62)
  t65 = 0.621814e-1 * t45 * t63
  t66 = t6 ** 2
  t67 = t66 ** 2
  t68 = t7 ** 2
  t69 = t68 ** 2
  t70 = 0.1e1 / t69
  t71 = t67 * t70
  t72 = t12 * f.p.zeta_threshold
  t73 = t14 * t10
  t74 = f.my_piecewise3(t11, t72, t73)
  t75 = t19 * t17
  t76 = f.my_piecewise3(t18, t72, t75)
  t77 = t74 + t76 - 0.2e1
  t78 = 2 ** (0.1e1 / 0.3e1)
  t79 = t78 - 0.1e1
  t81 = 0.1e1 / t79 / 0.2e1
  t82 = t77 * t81
  t84 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t35
  t89 = 0.70594500000000000000000000000000000000000000000000e1 * t46 + 0.15494250000000000000000000000000000000000000000000e1 * t35 + 0.42077500000000000000000000000000000000000000000000e0 * t49 + 0.15629250000000000000000000000000000000000000000000e0 * t57
  t92 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t89
  t93 = jnp.log(t92)
  t97 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t35
  t102 = 0.51785000000000000000000000000000000000000000000000e1 * t46 + 0.90577500000000000000000000000000000000000000000000e0 * t35 + 0.11003250000000000000000000000000000000000000000000e0 * t49 + 0.12417750000000000000000000000000000000000000000000e0 * t57
  t105 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t102
  t106 = jnp.log(t105)
  t107 = t97 * t106
  t109 = -0.3109070e-1 * t84 * t93 + t65 - 0.19751673498613801407483339618206552048944131217655e-1 * t107
  t110 = t82 * t109
  t111 = t71 * t110
  t113 = 0.19751673498613801407483339618206552048944131217655e-1 * t82 * t107
  t115 = (-t65 + t111 + t113) * t42
  t116 = 0.1e1 / t25
  t117 = t3 * t116
  t119 = jnp.exp(-t115 * t117)
  t120 = t119 - 0.1e1
  t121 = 0.1e1 / t120
  t122 = t3 * t121
  t124 = s0 + 0.2e1 * s1 + s2
  t125 = t122 * t124
  t126 = t43 * t125
  t128 = 0.1e1 / t32 / t68
  t129 = t128 * t78
  t130 = 0.1e1 / t24
  t132 = 0.1e1 / t28
  t133 = t51 * t132
  t134 = t133 * t30
  t138 = 0.1e1 + 0.27801896084645508333333333333333333333333333333333e-2 * t126 * t129 * t130 * t134
  t139 = t138 ** (0.1e1 / 0.4e1)
  t141 = 0.1e1 / t139 / t138
  t142 = t68 * t7
  t144 = 0.1e1 / t54 / t142
  t145 = t144 * t40
  t146 = t42 * t3
  t147 = t145 * t146
  t148 = t121 * t124
  t149 = t78 * t130
  t150 = t148 * t149
  t152 = 0.27801896084645508333333333333333333333333333333333e-3 * t147 * t150
  t153 = t39 ** 2
  t154 = 0.1e1 / t153
  t155 = t37 * t154
  t156 = t155 * t146
  t161 = 0.49431771238499713816666666666666666666666666666666e-3 * t156 * t148 * t144 * t78 * t130
  t162 = t120 ** 2
  t163 = 0.1e1 / t162
  t164 = t3 * t163
  t165 = t124 * t128
  t167 = t43 * t164 * t165
  t168 = t149 * t51
  t169 = t132 * t30
  t171 = 0.1e1 / t32 / t7
  t172 = t31 * t171
  t174 = t29 * t172 * t63
  t175 = 0.11073470983333333333333333333333333333333333333333e-2 * t174
  t176 = t59 ** 2
  t177 = 0.1e1 / t176
  t178 = t45 * t177
  t180 = 0.1e1 / t46 * t26
  t181 = t28 * t31
  t182 = t181 * t171
  t183 = t180 * t182
  t185 = t29 * t172
  t187 = t35 ** 0.5e0
  t188 = t187 * t26
  t189 = t188 * t182
  t194 = t53 * t30 / t54 / t7
  t196 = -0.63297500000000000000000000000000000000000000000000e0 * t183 - 0.29896666666666666666666666666666666666666666666667e0 * t185 - 0.10238750000000000000000000000000000000000000000000e0 * t189 - 0.82156666666666666666666666666666666666666666666667e-1 * t194
  t197 = 0.1e1 / t62
  t198 = t196 * t197
  t199 = t178 * t198
  t200 = 0.10000000000000000000000000000000000000000000000000e1 * t199
  t201 = t66 * t6
  t202 = t201 * t70
  t203 = t202 * t110
  t204 = 0.4e1 * t203
  t205 = t69 * t7
  t206 = 0.1e1 / t205
  t207 = t67 * t206
  t208 = t207 * t110
  t209 = 0.4e1 * t208
  t210 = 0.1e1 / t68
  t211 = t6 * t210
  t212 = t8 - t211
  t215 = f.my_piecewise3(t11, 0, 0.4e1 / 0.3e1 * t14 * t212)
  t216 = -t212
  t219 = f.my_piecewise3(t18, 0, 0.4e1 / 0.3e1 * t19 * t216)
  t221 = (t215 + t219) * t81
  t222 = t221 * t109
  t223 = t71 * t222
  t227 = t89 ** 2
  t228 = 0.1e1 / t227
  t229 = t84 * t228
  t234 = -0.11765750000000000000000000000000000000000000000000e1 * t183 - 0.51647500000000000000000000000000000000000000000000e0 * t185 - 0.21038750000000000000000000000000000000000000000000e0 * t189 - 0.10419500000000000000000000000000000000000000000000e0 * t194
  t235 = 0.1e1 / t92
  t236 = t234 * t235
  t242 = t102 ** 2
  t243 = 0.1e1 / t242
  t244 = t97 * t243
  t249 = -0.86308333333333333333333333333333333333333333333334e0 * t183 - 0.30192500000000000000000000000000000000000000000000e0 * t185 - 0.55016250000000000000000000000000000000000000000000e-1 * t189 - 0.82785000000000000000000000000000000000000000000000e-1 * t194
  t250 = 0.1e1 / t105
  t251 = t249 * t250
  t254 = 0.53237641966666666666666666666666666666666666666666e-3 * t29 * t172 * t93 + 0.10000000000000000000000000000000000000000000000000e1 * t229 * t236 - t175 - t200 + 0.18311447306006545054854346104378990962041954983034e-3 * t29 * t172 * t106 + 0.58482236226346462072622386637590534819724553404280e0 * t244 * t251
  t255 = t82 * t254
  t256 = t71 * t255
  t257 = t221 * t107
  t258 = 0.19751673498613801407483339618206552048944131217655e-1 * t257
  t259 = t82 * t26
  t261 = t181 * t171 * t106
  t262 = t259 * t261
  t263 = 0.18311447306006545054854346104378990962041954983034e-3 * t262
  t264 = t82 * t97
  t266 = t243 * t249 * t250
  t267 = t264 * t266
  t268 = 0.58482236226346462072622386637590534819724553404280e0 * t267
  t270 = (t175 + t200 + t204 - t209 + t223 + t256 + t258 - t263 - t268) * t42
  t272 = t24 ** 2
  t273 = 0.1e1 / t272
  t274 = t3 * t273
  t275 = 0.1e1 / t14
  t278 = f.my_piecewise3(t11, 0, 0.2e1 / 0.3e1 * t275 * t212)
  t279 = 0.1e1 / t19
  t282 = f.my_piecewise3(t18, 0, 0.2e1 / 0.3e1 * t279 * t216)
  t284 = t278 / 0.2e1 + t282 / 0.2e1
  t285 = t274 * t284
  t288 = 0.3e1 * t115 * t285 - t270 * t117
  t289 = t288 * t119
  t291 = t168 * t169 * t289
  t295 = 0.1e1 / t32 / t142
  t296 = t295 * t78
  t300 = 0.64871090864172852777777777777777777777777777777777e-2 * t126 * t296 * t130 * t134
  t301 = t129 * t116
  t303 = t133 * t30 * t284
  t307 = -t152 + t161 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t291 - t300 - 0.55603792169291016666666666666666666666666666666666e-2 * t126 * t301 * t303
  t308 = t141 * t307
  t312 = 0.1e1 - 0.1e1 / t139
  t316 = 0.25000000000000000000000000000000000000000000000000e0 * t308 * t120 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t288 * t119
  t320 = 0.1e1 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t120
  t321 = 0.1e1 / t320
  t323 = t5 * t25 * t316 * t321
  t325 = r0 ** (0.1e1 / 0.3e1)
  t326 = t325 ** 2
  t329 = tau0 / t326 / r0
  t330 = t10 / 0.2e1
  t331 = t330 ** (0.1e1 / 0.3e1)
  t332 = t331 ** 2
  t333 = t332 * t330
  t335 = r1 ** (0.1e1 / 0.3e1)
  t336 = t335 ** 2
  t339 = tau1 / t336 / r1
  t340 = t17 / 0.2e1
  t341 = t340 ** (0.1e1 / 0.3e1)
  t342 = t341 ** 2
  t343 = t342 * t340
  t346 = 0.1e1 / t54 / t68
  t350 = 6 ** (0.1e1 / 0.3e1)
  t351 = (t329 * t333 + t339 * t343 - t124 * t346 / 0.8e1) * t350
  t352 = t3 ** (0.1e1 / 0.3e1)
  t353 = t352 ** 2
  t354 = 0.1e1 / t353
  t355 = t333 + t343
  t357 = t354 / t355
  t359 = 0.5e1 / 0.9e1 * t351 * t357
  t360 = t359 <= 0.1e1
  t361 = jnp.log(DBL_EPSILON)
  t364 = t361 / (-t361 + 0.64e0)
  t365 = -t364 < t359
  t366 = t359 < -t364
  t367 = r0 ** 2
  t370 = tau0 / t326 / t367
  t373 = t212 / 0.2e1
  t374 = t332 * t373
  t377 = -t373
  t378 = t342 * t377
  t381 = t124 * t144
  t382 = t381 / 0.3e1
  t384 = (-0.5e1 / 0.3e1 * t370 * t333 + 0.5e1 / 0.3e1 * t329 * t374 + 0.5e1 / 0.3e1 * t339 * t378 + t382) * t350
  t386 = t355 ** 2
  t388 = t354 / t386
  t390 = 0.5e1 / 0.3e1 * t374 + 0.5e1 / 0.3e1 * t378
  t391 = t388 * t390
  t394 = -0.5e1 / 0.9e1 * t351 * t391 + 0.5e1 / 0.9e1 * t384 * t357
  t395 = f.my_piecewise3(t366, t394, 0)
  t396 = f.my_piecewise3(t366, t359, -t364)
  t397 = 0.1e1 - t396
  t398 = 0.1e1 / t397
  t401 = t397 ** 2
  t402 = 0.1e1 / t401
  t403 = t396 * t402
  t406 = -0.64e0 * t395 * t398 - 0.64e0 * t403 * t395
  t409 = jnp.exp(-0.64e0 * t396 * t398)
  t411 = f.my_piecewise3(t365, 0, t406 * t409)
  t413 = jnp.log(0.14285714285714285714285714285714285714285714285714e1 * DBL_EPSILON)
  t416 = (-t413 + 0.15e1) / t413
  t417 = t359 < -t416
  t418 = f.my_piecewise3(t417, -t416, t359)
  t419 = 0.1e1 - t418
  t420 = t419 ** 2
  t421 = 0.1e1 / t420
  t422 = f.my_piecewise3(t417, 0, t394)
  t426 = jnp.exp(0.15e1 / t419)
  t429 = f.my_piecewise3(t417, 0, -0.105e1 * t421 * t422 * t426)
  t430 = f.my_piecewise3(t360, t411, t429)
  t433 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t46 + 0.31385250000000000000000000000000000000000000000000e-1 * t35
  t434 = 0.1e1 / t433
  t437 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t434)
  t438 = t437 - 0.1e1
  t439 = t350 * t354
  t440 = t78 ** 2
  t441 = t440 * t124
  t445 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t439 * t441 * t346
  t446 = t445 ** (0.1e1 / 0.4e1)
  t448 = 0.1e1 - 0.1e1 / t446
  t450 = t438 * t448 + 0.1e1
  t451 = jnp.log(t450)
  t453 = -0.285764e-1 * t434 + 0.285764e-1 * t451
  t457 = 0.1e1 - 0.2363e1 * t79 * t77 * t81
  t458 = t453 * t457
  t459 = t67 ** 2
  t460 = t459 * t67
  t461 = t69 ** 2
  t463 = 0.1e1 / t461 / t69
  t465 = -t460 * t463 + 0.1e1
  t467 = jnp.log(t320)
  t470 = -t5 * t25 * t467 + t458 * t465 - t111 - t113 + t65
  t471 = t430 * t470
  t473 = t23 * t467
  t474 = t284 ** 2
  t477 = 0.6e1 * t5 * t473 * t474
  t478 = t316 ** 2
  t480 = t320 ** 2
  t481 = 0.1e1 / t480
  t483 = t5 * t25 * t478 * t481
  t486 = 0.12e2 * t66 * t70 * t110
  t489 = 0.32e2 * t201 * t206 * t110
  t490 = f.my_piecewise3(t365, 0, t409)
  t492 = f.my_piecewise3(t417, 0, -0.7e0 * t426)
  t493 = f.my_piecewise3(t360, t490, t492)
  t494 = t453 * t79
  t495 = 0.1e1 / t15
  t496 = t212 ** 2
  t499 = 0.1e1 / t142
  t500 = t6 * t499
  t501 = -t210 + t500
  t502 = 0.2e1 * t501
  t506 = f.my_piecewise3(t11, 0, 0.4e1 / 0.9e1 * t495 * t496 + 0.4e1 / 0.3e1 * t14 * t502)
  t507 = 0.1e1 / t20
  t508 = t216 ** 2
  t511 = -t502
  t515 = f.my_piecewise3(t18, 0, 0.4e1 / 0.9e1 * t507 * t508 + 0.4e1 / 0.3e1 * t19 * t511)
  t517 = (t506 + t515) * t81
  t521 = t459 * t201
  t522 = t521 * t463
  t524 = 0.1e1 / t461 / t205
  t525 = t460 * t524
  t527 = -0.12e2 * t522 + 0.12e2 * t525
  t531 = t433 ** 2
  t532 = 0.1e1 / t531
  t535 = -0.74083333333333333333333333333333333333333333333333e-2 * t183 - 0.10461750000000000000000000000000000000000000000000e-1 * t185
  t536 = t532 * t535
  t538 = t437 * t448
  t542 = 0.1e1 / t446 / t445
  t544 = t438 * t542 * t350
  t545 = t354 * t440
  t549 = -0.10000000000000000000000000000000000000000000000000e1 * t536 * t538 - 0.14225094736250905555555555555555555555555555555555e-1 * t544 * t545 * t381
  t550 = 0.1e1 / t450
  t553 = 0.285764e-1 * t536 + 0.285764e-1 * t549 * t550
  t554 = t553 * t79
  t555 = t221 * t465
  t556 = t554 * t555
  t559 = 0.8e1 * t202 * t255
  t561 = 0.19751673498613801407483339618206552048944131217655e-1 * t517 * t107
  t565 = 0.10843581300301739842632067522386578331157260943710e-1 * t82 * t29 * t172 * t266
  t568 = t535 ** 2
  t569 = 0.1e1 / t531 / t433 * t568
  t575 = t52 * t30 * t346
  t576 = 0.1e1 / t46 / t35 * t51 * t575
  t578 = t181 * t128
  t579 = t180 * t578
  t581 = t31 * t128
  t582 = t29 * t581
  t585 = t532 * (-0.49388888888888888888888888888888888888888888888889e-2 * t576 + 0.98777777777777777777777777777777777777777777777777e-2 * t579 + 0.13949000000000000000000000000000000000000000000000e-1 * t582)
  t591 = t531 ** 2
  t602 = t445 ** 2
  t606 = t350 ** 2
  t611 = t124 ** 2
  t620 = 0.1e1 / t54 / t69
  t621 = t124 * t620
  t628 = t549 ** 2
  t629 = t450 ** 2
  t635 = (-0.571528e-1 * t569 + 0.285764e-1 * t585 + 0.285764e-1 * (0.20000000000000000000000000000000000000000000000000e1 * t569 * t538 - 0.10000000000000000000000000000000000000000000000000e1 * t585 * t538 + 0.10000000000000000000000000000000000000000000000000e1 / t591 * t568 * t538 + 0.28450189472501811111111111111111111111111111111110e-1 * t536 * t437 * t542 * t439 * t441 * t144 - 0.20235332025531322029119593137558641975308641975307e-2 * t438 / t446 / t602 * t606 / t352 / t3 * t78 * t611 / t32 / t69 / t142 + 0.52158680699586653703703703703703703703703703703702e-1 * t544 * t545 * t621) * t550 - 0.285764e-1 * t628 / t629) * t457 * t465
  t636 = t553 * t457
  t637 = t636 * t527
  t641 = 0.132e3 * t459 * t66 * t463
  t643 = 0.288e3 * t521 * t524
  t644 = t69 * t68
  t648 = 0.156e3 * t460 / t461 / t644
  t654 = t196 ** 2
  t657 = 0.20000000000000000000000000000000000000000000000000e1 * t45 / t176 / t59 * t654 * t197
  t661 = t35 ** (-0.5e0)
  t663 = t661 * t51 * t575
  t665 = t188 * t578
  t668 = t53 * t30 * t346
  t673 = 0.10000000000000000000000000000000000000000000000000e1 * t178 * (-0.42198333333333333333333333333333333333333333333333e0 * t576 + 0.84396666666666666666666666666666666666666666666666e0 * t579 + 0.39862222222222222222222222222222222222222222222223e0 * t582 + 0.68258333333333333333333333333333333333333333333333e-1 * t663 + 0.13651666666666666666666666666666666666666666666667e0 * t665 + 0.13692777777777777777777777777777777777777777777778e0 * t668) * t197
  t674 = t176 ** 2
  t677 = t62 ** 2
  t681 = 0.16081979498692535066756296899072713062105388428051e2 * t45 / t674 * t654 / t677
  t682 = t29 * t31
  t686 = 0.35616666666666666666666666666666666666666666666666e-1 * t682 * t171 * t177 * t198
  t687 = -t477 - 0.2363e1 * t494 * t517 * t465 - 0.4726e1 * t494 * t221 * t527 - 0.4726e1 * t556 + t483 - t486 + t489 - t559 - t561 - t565 + t635 + 0.2e1 * t637 + t458 * (-t641 + t643 - t648) + t657 - t673 - t681 + t686
  t689 = t221 * t26 * t261
  t690 = 0.36622894612013090109708692208757981924083909966068e-3 * t689
  t694 = 0.24415263074675393406472461472505321282722606644045e-3 * t259 * t181 * t128 * t106
  t697 = 0.14764627977777777777777777777777777777777777777777e-2 * t29 * t581 * t63
  t698 = t24 * t467
  t699 = 0.1e1 / t73
  t705 = f.my_piecewise3(t11, 0, -0.2e1 / 0.9e1 * t699 * t496 + 0.2e1 / 0.3e1 * t275 * t502)
  t706 = 0.1e1 / t75
  t712 = f.my_piecewise3(t18, 0, -0.2e1 / 0.9e1 * t706 * t508 + 0.2e1 / 0.3e1 * t279 * t511)
  t714 = t705 / 0.2e1 + t712 / 0.2e1
  t717 = 0.3e1 * t5 * t698 * t714
  t719 = t71 * t221 * t254
  t720 = 0.2e1 * t719
  t721 = t207 * t222
  t722 = 0.8e1 * t721
  t724 = 0.8e1 * t207 * t255
  t725 = t202 * t222
  t726 = 0.8e1 * t725
  t728 = t71 * t517 * t109
  t729 = t138 ** 2
  t731 = 0.1e1 / t139 / t729
  t732 = t307 ** 2
  t736 = t288 ** 2
  t745 = 0.16681137650787305000000000000000000000000000000000e-2 * t620 * t40 * t146 * t150
  t746 = t78 * t116
  t747 = t746 * t284
  t749 = t147 * t148 * t747
  t760 = 0.14648281543675415194338888888888888888888888888889e-4 * t37 / t153 / t39 * t42 * t125 * t206 * t78 * t130 * t682
  t761 = t146 * t163
  t762 = t145 * t761
  t763 = t124 * t78
  t765 = t130 * t288 * t119
  t767 = t762 * t763 * t765
  t773 = 0.29659062743099828290000000000000000000000000000000e-2 * t156 * t148 * t620 * t78 * t130
  t774 = t146 * t121
  t775 = t155 * t774
  t777 = t775 * t381 * t747
  t790 = 0.21623696954724284259259259259259259259259259259259e-1 * t126 / t32 / t69 * t78 * t130 * t134
  t791 = t296 * t116
  t793 = t126 * t791 * t303
  t800 = 0.82386285397499523027777777777777777777777777777777e-5 * t206 * t154 * t774 * t763 * t130 * t682
  t801 = t155 * t761
  t802 = t381 * t78
  t804 = t801 * t802 * t765
  t808 = t43 * t164 * t124 * t295
  t809 = t808 * t291
  t811 = t746 * t133
  t813 = t119 * t284
  t822 = t43 * t3 / t162 / t120 * t165
  t823 = t119 ** 2
  t829 = t242 ** 2
  t830 = 0.1e1 / t829
  t831 = t249 ** 2
  t833 = t105 ** 2
  t834 = 0.1e1 / t833
  t837 = 0.17315859105681463759666483083807725165579399831905e2 * t264 * t830 * t831 * t834
  t839 = t221 * t97 * t266
  t840 = 0.11696447245269292414524477327518106963944910680856e1 * t839
  t847 = -0.57538888888888888888888888888888888888888888888889e0 * t576 + 0.11507777777777777777777777777777777777777777777778e1 * t579 + 0.40256666666666666666666666666666666666666666666667e0 * t582 + 0.36677500000000000000000000000000000000000000000000e-1 * t663 + 0.73355000000000000000000000000000000000000000000000e-1 * t665 + 0.13797500000000000000000000000000000000000000000000e0 * t668
  t851 = 0.58482236226346462072622386637590534819724553404280e0 * t264 * t243 * t847 * t250
  t855 = 0.20e2 * t67 / t644 * t110
  t866 = t234 ** 2
  t880 = t227 ** 2
  t883 = t92 ** 2
  t896 = 0.1e1 / t242 / t102
  t908 = -0.70983522622222222222222222222222222222222222222221e-3 * t29 * t581 * t93 - 0.34246666666666666666666666666666666666666666666666e-1 * t682 * t171 * t228 * t236 - 0.20000000000000000000000000000000000000000000000000e1 * t84 / t227 / t89 * t866 * t235 + 0.10000000000000000000000000000000000000000000000000e1 * t229 * (-0.78438333333333333333333333333333333333333333333333e0 * t576 + 0.15687666666666666666666666666666666666666666666667e1 * t579 + 0.68863333333333333333333333333333333333333333333333e0 * t582 + 0.14025833333333333333333333333333333333333333333333e0 * t663 + 0.28051666666666666666666666666666666666666666666667e0 * t665 + 0.17365833333333333333333333333333333333333333333333e0 * t668) * t235 + 0.32163958997385070133512593798145426124210776856102e2 * t84 / t880 * t866 / t883 + t697 + t686 + t657 - t673 - t681 - 0.24415263074675393406472461472505321282722606644045e-3 * t29 * t581 * t106 - 0.10843581300301739842632067522386578331157260943710e-1 * t682 * t171 * t243 * t251 - 0.11696447245269292414524477327518106963944910680856e1 * t97 * t896 * t831 * t250 + 0.58482236226346462072622386637590534819724553404280e0 * t244 * t847 * t250 + 0.17315859105681463759666483083807725165579399831905e2 * t97 * t830 * t831 * t834
  t910 = t71 * t82 * t908
  t911 = t681 + t673 + t561 - t837 - t840 - t851 + t855 + t910 + t728 + t720 - t722
  t915 = 0.11696447245269292414524477327518106963944910680856e1 * t264 * t896 * t831 * t250
  t916 = -t724 + t726 + t559 - t657 - t690 + t915 - t686 - t697 + t565 + t486 - t489 + t694
  t923 = 0.1e1 / t272 / t23
  t924 = t3 * t923
  t931 = -(t911 + t916) * t42 * t117 + 0.6e1 * t270 * t285 - 0.12e2 * t115 * t924 * t474 + 0.3e1 * t115 * t274 * t714
  t937 = t129 * t273
  t943 = -0.27801896084645508333333333333333333333333333333333e-2 * t167 * t168 * t169 * t736 * t119 + t745 + 0.11120758433858203333333333333333333333333333333333e-2 * t749 + t760 + 0.55603792169291016666666666666666666666666666666666e-3 * t767 - t773 - 0.19772708495399885526666666666666666666666666666666e-2 * t777 - 0.55603792169291016666666666666666666666666666666666e-2 * t126 * t301 * t133 * t30 * t714 + t790 + 0.25948436345669141111111111111111111111111111111110e-1 * t793 - t800 - 0.98863542476999427633333333333333333333333333333332e-3 * t804 + 0.12974218172834570555555555555555555555555555555555e-1 * t809 + 0.11120758433858203333333333333333333333333333333333e-1 * t167 * t811 * t30 * t288 * t813 + 0.55603792169291016666666666666666666666666666666666e-2 * t822 * t168 * t169 * t736 * t823 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t168 * t169 * t931 * t119 + 0.16681137650787305000000000000000000000000000000000e-1 * t126 * t937 * t133 * t30 * t474
  t958 = t5 * t25 * (-0.31250000000000000000000000000000000000000000000000e0 * t731 * t732 * t120 + 0.25000000000000000000000000000000000000000000000000e0 * t141 * t943 * t120 + 0.50000000000000000000000000000000000000000000000000e0 * t308 * t289 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t931 * t119 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t736 * t119) * t321
  t959 = t5 * t24
  t960 = t316 * t321
  t963 = 0.6e1 * t959 * t960 * t284
  t964 = t690 - t694 + t697 - t717 - t720 + t722 + t724 - t726 - t728 - t958 - t963 + t840 + t851 - t915 + t837 - t855 - t910
  t967 = t477 - t483 + t486 - t489 + t493 * (t687 + t964) + t559 + t561 + t565 - t657 + t673 + t681 - t686 - t690 + t694 - t697
  t968 = t636 * t465
  t973 = t5 * t698 * t284
  t974 = 0.3e1 * t973
  t975 = t968 - 0.2363e1 * t494 * t555 + t458 * t527 - t175 - t200 - t204 + t209 - t223 - t256 - t258 + t263 + t268 - t974 - t323
  t986 = 0.1e1 / t331
  t987 = t373 ** 2
  t988 = t986 * t987
  t991 = t332 * t501
  t994 = 0.1e1 / t341
  t995 = t377 ** 2
  t996 = t994 * t995
  t1000 = -t342 * t501
  t1003 = 0.11e2 / 0.9e1 * t621
  t1011 = 0.1e1 / t386 / t355
  t1012 = t354 * t1011
  t1013 = t390 ** 2
  t1025 = 0.5e1 / 0.9e1 * (0.40e2 / 0.9e1 * tau0 / t326 / t367 / r0 * t333 - 0.50e2 / 0.9e1 * t370 * t374 + 0.10e2 / 0.9e1 * t329 * t988 + 0.5e1 / 0.3e1 * t329 * t991 + 0.10e2 / 0.9e1 * t339 * t996 + 0.5e1 / 0.3e1 * t339 * t1000 - t1003) * t350 * t357 - 0.10e2 / 0.9e1 * t384 * t391 + 0.10e2 / 0.9e1 * t351 * t1012 * t1013 - 0.5e1 / 0.9e1 * t351 * t388 * (0.10e2 / 0.9e1 * t988 + 0.5e1 / 0.3e1 * t991 + 0.10e2 / 0.9e1 * t996 + 0.5e1 / 0.3e1 * t1000)
  t1026 = f.my_piecewise3(t366, t1025, 0)
  t1029 = t395 ** 2
  t1034 = t396 / t401 / t397
  t1041 = t406 ** 2
  t1044 = f.my_piecewise3(t365, 0, (-0.64e0 * t1026 * t398 - 0.128e1 * t1029 * t402 - 0.128e1 * t1034 * t1029 - 0.64e0 * t403 * t1026) * t409 + t1041 * t409)
  t1046 = 0.1e1 / t420 / t419
  t1047 = t422 ** 2
  t1051 = f.my_piecewise3(t417, 0, t1025)
  t1055 = t420 ** 2
  t1056 = 0.1e1 / t1055
  t1061 = f.my_piecewise3(t417, 0, -0.210e1 * t1046 * t1047 * t426 - 0.105e1 * t421 * t1051 * t426 - 0.1575e1 * t1056 * t1047 * t426)
  t1062 = f.my_piecewise3(t360, t1044, t1061)
  t1064 = t1062 * t470 + 0.2e1 * t430 * t975 + t717 + t720 - t722 - t724 + t726 + t728 - t837 - t840 - t851 + t855 + t910 + t915 + t958 + t963
  t1068 = 0.20000000000000000000000000000000000000000000000000e1 * t199
  t1069 = 0.36622894612013090109708692208757981924083909966068e-3 * t262
  t1071 = 0.2e1 * t256
  t1073 = 0.22146941966666666666666666666666666666666666666666e-2 * t174
  t1074 = 0.8e1 * t203
  t1075 = 0.8e1 * t208
  t1076 = t493 * t975
  t1078 = 0.11696447245269292414524477327518106963944910680856e1 * t267
  d11 = 0.2e1 * t323 + 0.2e1 * t471 + t7 * (t967 + t1064) + 0.39503346997227602814966679236413104097888262435310e-1 * t257 + t1068 - t1069 + 0.6e1 * t973 + t1071 + 0.2e1 * t223 + t1073 + t1074 - t1075 + 0.2e1 * t1076 - t1078
  t1079 = -t8 - t211
  t1080 = t1079 / 0.2e1
  t1081 = t332 * t1080
  t1084 = r1 ** 2
  t1087 = tau1 / t336 / t1084
  t1090 = -t1080
  t1091 = t342 * t1090
  t1095 = (0.5e1 / 0.3e1 * t329 * t1081 - 0.5e1 / 0.3e1 * t1087 * t343 + 0.5e1 / 0.3e1 * t339 * t1091 + t382) * t350
  t1098 = 0.5e1 / 0.3e1 * t1081 + 0.5e1 / 0.3e1 * t1091
  t1099 = t388 * t1098
  t1102 = 0.5e1 / 0.9e1 * t1095 * t357 - 0.5e1 / 0.9e1 * t351 * t1099
  t1103 = f.my_piecewise3(t366, t1102, 0)
  t1108 = -0.64e0 * t1103 * t398 - 0.64e0 * t403 * t1103
  t1110 = f.my_piecewise3(t365, 0, t1108 * t409)
  t1111 = f.my_piecewise3(t417, 0, t1102)
  t1115 = f.my_piecewise3(t417, 0, -0.105e1 * t421 * t1111 * t426)
  t1116 = f.my_piecewise3(t360, t1110, t1115)
  t1117 = t1116 * t470
  t1120 = f.my_piecewise3(t11, 0, 0.4e1 / 0.3e1 * t14 * t1079)
  t1121 = -t1079
  t1124 = f.my_piecewise3(t18, 0, 0.4e1 / 0.3e1 * t19 * t1121)
  t1126 = (t1120 + t1124) * t81
  t1127 = t1126 * t107
  t1128 = 0.19751673498613801407483339618206552048944131217655e-1 * t1127
  t1130 = t1126 * t109
  t1131 = t71 * t1130
  t1133 = (t175 + t200 - t204 - t209 + t1131 + t256 + t1128 - t263 - t268) * t42
  t1137 = f.my_piecewise3(t11, 0, 0.2e1 / 0.3e1 * t275 * t1079)
  t1140 = f.my_piecewise3(t18, 0, 0.2e1 / 0.3e1 * t279 * t1121)
  t1142 = t1137 / 0.2e1 + t1140 / 0.2e1
  t1143 = t274 * t1142
  t1146 = -t1133 * t117 + 0.3e1 * t115 * t1143
  t1147 = t1146 * t119
  t1149 = t168 * t169 * t1147
  t1152 = t30 * t1142
  t1153 = t133 * t1152
  t1157 = -t152 + t161 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t1149 - t300 - 0.55603792169291016666666666666666666666666666666666e-2 * t126 * t301 * t1153
  t1158 = t141 * t1157
  t1161 = t312 * t1146
  t1164 = 0.25000000000000000000000000000000000000000000000000e0 * t1158 * t120 + 0.10000000000000000000000000000000000000000000000000e1 * t1161 * t119
  t1167 = t5 * t25 * t1164 * t481 * t316
  t1168 = t1164 * t321
  t1171 = 0.3e1 * t959 * t1168 * t284
  t1174 = 0.3e1 * t959 * t960 * t1142
  t1183 = f.my_piecewise3(t11, 0, 0.4e1 / 0.9e1 * t495 * t1079 * t212 + 0.8e1 / 0.3e1 * t14 * t6 * t499)
  t1191 = f.my_piecewise3(t18, 0, 0.4e1 / 0.9e1 * t507 * t1121 * t216 - 0.8e1 / 0.3e1 * t19 * t6 * t499)
  t1193 = (t1183 + t1191) * t81
  t1195 = 0.19751673498613801407483339618206552048944131217655e-1 * t1193 * t107
  t1200 = t149 * t133
  t1201 = t30 * t1146
  t1207 = t808 * t1149
  t1222 = t746 * t1142
  t1224 = t147 * t148 * t1222
  t1227 = t130 * t1146 * t119
  t1229 = t762 * t763 * t1227
  t1232 = t775 * t381 * t1222
  t1235 = 0.55603792169291016666666666666666666666666666666666e-2 * t822 * t1200 * t1201 * t823 * t288 + 0.64871090864172852777777777777777777777777777777777e-2 * t1207 + 0.55603792169291016666666666666666666666666666666666e-2 * t167 * t811 * t1201 * t813 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t1200 * t1201 * t289 + 0.55603792169291016666666666666666666666666666666666e-2 * t167 * t811 * t1152 * t289 + 0.55603792169291016666666666666666666666666666666666e-3 * t749 + 0.55603792169291016666666666666666666666666666666666e-3 * t1224 + t745 + t760 + 0.27801896084645508333333333333333333333333333333333e-3 * t1229 - 0.98863542476999427633333333333333333333333333333332e-3 * t1232 + 0.27801896084645508333333333333333333333333333333333e-3 * t767
  t1244 = f.my_piecewise3(t11, 0, -0.2e1 / 0.9e1 * t699 * t1079 * t212 + 0.4e1 / 0.3e1 * t275 * t6 * t499)
  t1252 = f.my_piecewise3(t18, 0, -0.2e1 / 0.9e1 * t706 * t1121 * t216 - 0.4e1 / 0.3e1 * t279 * t6 * t499)
  t1254 = t1244 / 0.2e1 + t1252 / 0.2e1
  t1263 = t801 * t802 * t1227
  t1265 = 0.18311447306006545054854346104378990962041954983034e-3 * t689
  t1267 = t1126 * t97 * t266
  t1268 = 0.58482236226346462072622386637590534819724553404280e0 * t1267
  t1269 = 0.4e1 * t721
  t1270 = -t486 + t1195 + t565 - t657 + t673 + t681 - t686 - t1265 + t694 - t1268 - t697 + t719 - t1269
  t1271 = 0.4e1 * t725
  t1272 = 0.58482236226346462072622386637590534819724553404280e0 * t839
  t1274 = t71 * t1193 * t109
  t1276 = t71 * t1126 * t254
  t1277 = t202 * t1130
  t1278 = 0.4e1 * t1277
  t1279 = t207 * t1130
  t1280 = 0.4e1 * t1279
  t1282 = t1126 * t26 * t261
  t1283 = 0.18311447306006545054854346104378990962041954983034e-3 * t1282
  t1284 = -t724 - t1271 - t1272 - t851 + t915 - t837 + t855 + t910 + t1274 + t1276 + t1278 - t1280 - t1283
  t1300 = -(t1270 + t1284) * t42 * t117 + 0.3e1 * t1133 * t285 + 0.3e1 * t270 * t1143 - 0.12e2 * t115 * t3 * t923 * t1142 * t284 + 0.3e1 * t115 * t274 * t1254
  t1308 = t126 * t791 * t1153
  t1319 = -t773 - 0.98863542476999427633333333333333333333333333333332e-3 * t777 - 0.55603792169291016666666666666666666666666666666666e-2 * t126 * t301 * t133 * t30 * t1254 + t790 + 0.12974218172834570555555555555555555555555555555555e-1 * t793 - t800 - 0.49431771238499713816666666666666666666666666666666e-3 * t804 - 0.49431771238499713816666666666666666666666666666666e-3 * t1263 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t168 * t169 * t1300 * t119 + 0.64871090864172852777777777777777777777777777777777e-2 * t809 + 0.12974218172834570555555555555555555555555555555555e-1 * t1308 + 0.16681137650787305000000000000000000000000000000000e-1 * t43 * t122 * t165 * t78 * t273 * t51 * t169 * t1142 * t284
  t1336 = t5 * t25 * (-0.31250000000000000000000000000000000000000000000000e0 * t731 * t1157 * t120 * t307 + 0.25000000000000000000000000000000000000000000000000e0 * t141 * (t1235 + t1319) * t120 + 0.25000000000000000000000000000000000000000000000000e0 * t1158 * t289 + 0.25000000000000000000000000000000000000000000000000e0 * t308 * t1147 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t1300 * t119 + 0.10000000000000000000000000000000000000000000000000e1 * t1161 * t289) * t321
  t1337 = t1167 - 0.2363e1 * t556 + t486 - t1171 - t1174 - t1195 - t565 + t635 + t637 - t1336 + t657 - t673 - t681 + t686 + t1265 - t694 + t1268 + t697 - t719 + t1269
  t1339 = 0.12e2 * t522 + 0.12e2 * t525
  t1343 = t1126 * t465
  t1344 = t554 * t1343
  t1354 = 0.3e1 * t5 * t698 * t1254
  t1357 = t636 * t1339
  t1362 = 0.6e1 * t5 * t23 * t467 * t1142 * t284
  t1364 = t1272 + t851 - t915 + t837 - t855 - t910 - t1274 - t1276 - t1278 + t1280 + t1283
  t1372 = t5 * t698 * t1142
  t1373 = 0.3e1 * t1372
  t1376 = t5 * t25 * t1164 * t321
  t1377 = t968 - 0.2363e1 * t494 * t1343 + t458 * t1339 - t175 - t200 + t204 + t209 - t1131 - t256 - t1128 + t263 + t268 - t1373 - t1376
  t1379 = -t1167 - t486 + t1171 + t1174 + t493 * (t1337 + t724 + t1271 - 0.2363e1 * t494 * t221 * t1339 - 0.2363e1 * t1344 - 0.2363e1 * t494 * t1193 * t465 - 0.2363e1 * t494 * t1126 * t527 - t1354 + t458 * (t641 - t648) + t1357 - t1362 + t1364) + t430 * t1377 + t1195 + t565 + t1336 - t657 + t673 + t681 - t686 - t1265 + t694 - t1268 - t697 + t719
  t1384 = t986 * t1080 * t373
  t1388 = t332 * t6 * t499
  t1394 = t994 * t1090 * t377
  t1398 = t342 * t6 * t499
  t1422 = 0.5e1 / 0.9e1 * (-0.25e2 / 0.9e1 * t370 * t1081 + 0.10e2 / 0.9e1 * t329 * t1384 + 0.5e1 / 0.3e1 * t329 * t1388 - 0.25e2 / 0.9e1 * t1087 * t378 + 0.10e2 / 0.9e1 * t339 * t1394 - 0.5e1 / 0.3e1 * t339 * t1398 - t1003) * t350 * t357 - 0.5e1 / 0.9e1 * t1095 * t391 - 0.5e1 / 0.9e1 * t384 * t1099 + 0.10e2 / 0.9e1 * t351 * t354 * t1011 * t1098 * t390 - 0.5e1 / 0.9e1 * t351 * t388 * (0.10e2 / 0.9e1 * t1384 + 0.5e1 / 0.3e1 * t1388 + 0.10e2 / 0.9e1 * t1394 - 0.5e1 / 0.3e1 * t1398)
  t1423 = f.my_piecewise3(t366, t1422, 0)
  t1439 = f.my_piecewise3(t365, 0, (-0.64e0 * t1423 * t398 - 0.128e1 * t1103 * t402 * t395 - 0.128e1 * t1034 * t1103 * t395 - 0.64e0 * t403 * t1423) * t409 + t1108 * t406 * t409)
  t1441 = t426 * t422
  t1444 = f.my_piecewise3(t417, 0, t1422)
  t1452 = f.my_piecewise3(t417, 0, -0.210e1 * t1046 * t1111 * t1441 - 0.105e1 * t421 * t1444 * t426 - 0.1575e1 * t1056 * t1111 * t1441)
  t1453 = f.my_piecewise3(t360, t1439, t1452)
  t1455 = t1116 * t975 + t1453 * t470 - t1269 - t1271 - t1272 + t1274 + t1276 + t1278 - t1280 - t1283 + t1354 + t1362 - t724 - t837 - t851 + t855 + t910 + t915
  t1458 = t493 * t1377
  d12 = t1117 + t1128 + t1068 + t7 * (t1379 + t1455) + t471 + t1076 + t1458 + t258 + t1376 + t1373 + t1071 - t1075 + t1131 + t974 + t1073 + t223 - t1078 + t323 - t1069
  t1461 = t1164 ** 2
  t1464 = t5 * t25 * t1461 * t481
  t1465 = t1079 ** 2
  t1468 = t210 + t500
  t1469 = 0.2e1 * t1468
  t1473 = f.my_piecewise3(t11, 0, -0.2e1 / 0.9e1 * t699 * t1465 + 0.2e1 / 0.3e1 * t275 * t1469)
  t1474 = t1121 ** 2
  t1477 = -t1469
  t1481 = f.my_piecewise3(t18, 0, -0.2e1 / 0.9e1 * t706 * t1474 + 0.2e1 / 0.3e1 * t279 * t1477)
  t1483 = t1473 / 0.2e1 + t1481 / 0.2e1
  t1486 = 0.3e1 * t5 * t698 * t1483
  t1487 = t1142 ** 2
  t1490 = 0.6e1 * t5 * t473 * t1487
  t1491 = 0.11696447245269292414524477327518106963944910680856e1 * t1267
  t1492 = t486 + t489 - t1464 + t1486 + t1490 - t559 + t565 - t657 + t673 + t681 - t686 + t694 - t1491 - t697 - t724
  t1498 = f.my_piecewise3(t11, 0, 0.4e1 / 0.9e1 * t495 * t1465 + 0.4e1 / 0.3e1 * t14 * t1469)
  t1504 = f.my_piecewise3(t18, 0, 0.4e1 / 0.9e1 * t507 * t1474 + 0.4e1 / 0.3e1 * t19 * t1477)
  t1506 = (t1498 + t1504) * t81
  t1508 = t71 * t1506 * t109
  t1511 = 0.6e1 * t959 * t1168 * t1142
  t1513 = 0.19751673498613801407483339618206552048944131217655e-1 * t1506 * t107
  t1514 = t1080 ** 2
  t1515 = t986 * t1514
  t1518 = t332 * t1468
  t1529 = t1090 ** 2
  t1530 = t994 * t1529
  t1534 = -t342 * t1468
  t1543 = t1098 ** 2
  t1555 = 0.5e1 / 0.9e1 * (0.10e2 / 0.9e1 * t329 * t1515 + 0.5e1 / 0.3e1 * t329 * t1518 + 0.40e2 / 0.9e1 * tau1 / t336 / t1084 / r1 * t343 - 0.50e2 / 0.9e1 * t1087 * t1091 + 0.10e2 / 0.9e1 * t339 * t1530 + 0.5e1 / 0.3e1 * t339 * t1534 - t1003) * t350 * t357 - 0.10e2 / 0.9e1 * t1095 * t1099 + 0.10e2 / 0.9e1 * t351 * t1012 * t1543 - 0.5e1 / 0.9e1 * t351 * t388 * (0.10e2 / 0.9e1 * t1515 + 0.5e1 / 0.3e1 * t1518 + 0.10e2 / 0.9e1 * t1530 + 0.5e1 / 0.3e1 * t1534)
  t1556 = f.my_piecewise3(t366, t1555, 0)
  t1559 = t1103 ** 2
  t1568 = t1108 ** 2
  t1571 = f.my_piecewise3(t365, 0, (-0.64e0 * t1556 * t398 - 0.128e1 * t1559 * t402 - 0.128e1 * t1034 * t1559 - 0.64e0 * t403 * t1556) * t409 + t1568 * t409)
  t1572 = t1111 ** 2
  t1576 = f.my_piecewise3(t417, 0, t1555)
  t1584 = f.my_piecewise3(t417, 0, -0.210e1 * t1046 * t1572 * t426 - 0.105e1 * t421 * t1576 * t426 - 0.1575e1 * t1056 * t1572 * t426)
  t1585 = f.my_piecewise3(t360, t1571, t1584)
  t1591 = -t486 - t489 + t1464 - t1486 - t1490 + t458 * (-t641 - t643 - t648) + t559 - t565 + t635 + t657 - t673 - t681 + t686 - t694 + t1491 + t697 + t724
  t1594 = t1157 ** 2
  t1598 = t1146 ** 2
  t1625 = 0.8e1 * t1279
  t1626 = 0.8e1 * t1277
  t1627 = t1513 + t673 + t681 - t657 + t565 + t910 + t486 - t1625 - t724 - t1626 - t559
  t1628 = 0.36622894612013090109708692208757981924083909966068e-3 * t1282
  t1629 = 0.2e1 * t1276
  t1630 = t855 + t489 - t697 - t1628 + t915 - t686 - t837 - t851 - t1491 + t1508 + t1629 + t694
  t1642 = -(t1627 + t1630) * t42 * t117 + 0.6e1 * t1133 * t1143 - 0.12e2 * t115 * t924 * t1487 + 0.3e1 * t115 * t274 * t1483
  t1653 = 0.55603792169291016666666666666666666666666666666666e-2 * t822 * t168 * t169 * t1598 * t823 + 0.12974218172834570555555555555555555555555555555555e-1 * t1207 + 0.11120758433858203333333333333333333333333333333333e-1 * t167 * t811 * t1201 * t119 * t1142 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t168 * t169 * t1598 * t119 + t745 + 0.11120758433858203333333333333333333333333333333333e-2 * t1224 + t760 + 0.55603792169291016666666666666666666666666666666666e-3 * t1229 - t773 - 0.19772708495399885526666666666666666666666666666666e-2 * t1232 - 0.55603792169291016666666666666666666666666666666666e-2 * t126 * t301 * t133 * t30 * t1483 + t790 + 0.25948436345669141111111111111111111111111111111110e-1 * t1308 - t800 - 0.98863542476999427633333333333333333333333333333332e-3 * t1263 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t168 * t169 * t1642 * t119 + 0.16681137650787305000000000000000000000000000000000e-1 * t126 * t937 * t133 * t30 * t1487
  t1668 = t5 * t25 * (-0.31250000000000000000000000000000000000000000000000e0 * t731 * t1594 * t120 + 0.25000000000000000000000000000000000000000000000000e0 * t141 * t1653 * t120 + 0.50000000000000000000000000000000000000000000000000e0 * t1158 * t1147 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t1642 * t119 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t1598 * t119) * t321
  t1675 = -0.4726e1 * t1344 - t1508 + 0.2e1 * t1357 + t851 - t915 + t837 - t1511 - t855 - t910 - t1513 - t1668 - 0.2363e1 * t494 * t1506 * t465 - 0.4726e1 * t494 * t1126 * t1339 - t1629 + t1626 + t1625 + t1628
  t1678 = t1508 - t851 + t915 - t837 + t1511 + t855 + t910 + t1513 + t1585 * t470 + 0.2e1 * t1116 * t1377 + t493 * (t1591 + t1675) + t1668 + t1629 - t1626 - t1625 - t1628
  d22 = -t1078 + 0.2e1 * t1117 + 0.2e1 * t1458 + t7 * (t1492 + t1678) + 0.39503346997227602814966679236413104097888262435310e-1 * t1127 + 0.6e1 * t1372 + t1071 - t1074 - t1075 + 0.2e1 * t1131 + t1073 - t1069 + t1068 + 0.2e1 * t1376
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = jnp.log(0.2e1)
  t2 = 0.1e1 - t1
  t3 = jnp.pi ** 2
  t5 = t2 / t3
  t6 = r0 - r1
  t7 = r0 + r1
  t8 = 0.1e1 / t7
  t9 = t6 * t8
  t10 = 0.1e1 + t9
  t11 = t10 <= f.p.zeta_threshold
  t12 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t13 = t12 ** 2
  t14 = t10 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t16 = f.my_piecewise3(t11, t13, t15)
  t17 = 0.1e1 - t9
  t18 = t17 <= f.p.zeta_threshold
  t19 = t17 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t21 = f.my_piecewise3(t18, t13, t20)
  t23 = t16 / 0.2e1 + t21 / 0.2e1
  t24 = t23 ** 2
  t25 = t24 * t23
  t26 = 3 ** (0.1e1 / 0.3e1)
  t28 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t29 = t26 * t28
  t30 = 4 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = t7 ** (0.1e1 / 0.3e1)
  t35 = t29 * t31 / t32
  t37 = 0.1e1 + 0.25000000000000000000000000000000000000000000000000e-1 * t35
  t39 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t35
  t40 = 0.1e1 / t39
  t42 = 0.1e1 / t2
  t43 = t37 * t40 * t42
  t45 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t35
  t46 = jnp.sqrt(t35)
  t49 = t35 ** 0.15e1
  t51 = t26 ** 2
  t52 = t28 ** 2
  t53 = t51 * t52
  t54 = t32 ** 2
  t57 = t53 * t30 / t54
  t59 = 0.37978500000000000000000000000000000000000000000000e1 * t46 + 0.89690000000000000000000000000000000000000000000000e0 * t35 + 0.20477500000000000000000000000000000000000000000000e0 * t49 + 0.12323500000000000000000000000000000000000000000000e0 * t57
  t62 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t59
  t63 = jnp.log(t62)
  t65 = 0.621814e-1 * t45 * t63
  t66 = t6 ** 2
  t67 = t66 ** 2
  t68 = t7 ** 2
  t69 = t68 ** 2
  t70 = 0.1e1 / t69
  t71 = t67 * t70
  t72 = t12 * f.p.zeta_threshold
  t73 = t14 * t10
  t74 = f.my_piecewise3(t11, t72, t73)
  t75 = t19 * t17
  t76 = f.my_piecewise3(t18, t72, t75)
  t77 = t74 + t76 - 0.2e1
  t78 = 2 ** (0.1e1 / 0.3e1)
  t79 = t78 - 0.1e1
  t81 = 0.1e1 / t79 / 0.2e1
  t82 = t77 * t81
  t84 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t35
  t89 = 0.70594500000000000000000000000000000000000000000000e1 * t46 + 0.15494250000000000000000000000000000000000000000000e1 * t35 + 0.42077500000000000000000000000000000000000000000000e0 * t49 + 0.15629250000000000000000000000000000000000000000000e0 * t57
  t92 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t89
  t93 = jnp.log(t92)
  t97 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t35
  t102 = 0.51785000000000000000000000000000000000000000000000e1 * t46 + 0.90577500000000000000000000000000000000000000000000e0 * t35 + 0.11003250000000000000000000000000000000000000000000e0 * t49 + 0.12417750000000000000000000000000000000000000000000e0 * t57
  t105 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t102
  t106 = jnp.log(t105)
  t107 = t97 * t106
  t109 = -0.3109070e-1 * t84 * t93 + t65 - 0.19751673498613801407483339618206552048944131217655e-1 * t107
  t110 = t82 * t109
  t111 = t71 * t110
  t113 = 0.19751673498613801407483339618206552048944131217655e-1 * t82 * t107
  t115 = (-t65 + t111 + t113) * t42
  t116 = 0.1e1 / t25
  t117 = t3 * t116
  t119 = jnp.exp(-t115 * t117)
  t120 = t119 - 0.1e1
  t121 = 0.1e1 / t120
  t122 = t3 * t121
  t124 = s0 + 0.2e1 * s1 + s2
  t125 = t122 * t124
  t126 = t43 * t125
  t128 = 0.1e1 / t32 / t68
  t129 = t128 * t78
  t130 = 0.1e1 / t24
  t132 = 0.1e1 / t28
  t133 = t51 * t132
  t134 = t133 * t30
  t138 = 0.1e1 + 0.27801896084645508333333333333333333333333333333333e-2 * t126 * t129 * t130 * t134
  t139 = t138 ** (0.1e1 / 0.4e1)
  t141 = 0.1e1 / t139 / t138
  t142 = t68 * t7
  t144 = 0.1e1 / t54 / t142
  t145 = t144 * t40
  t146 = t42 * t3
  t147 = t145 * t146
  t148 = t121 * t124
  t149 = t78 * t130
  t150 = t148 * t149
  t152 = 0.27801896084645508333333333333333333333333333333333e-3 * t147 * t150
  t153 = t39 ** 2
  t154 = 0.1e1 / t153
  t155 = t37 * t154
  t156 = t155 * t146
  t161 = 0.49431771238499713816666666666666666666666666666666e-3 * t156 * t148 * t144 * t78 * t130
  t162 = t120 ** 2
  t163 = 0.1e1 / t162
  t164 = t3 * t163
  t165 = t124 * t128
  t167 = t43 * t164 * t165
  t168 = t149 * t51
  t169 = t132 * t30
  t171 = 0.1e1 / t32 / t7
  t172 = t31 * t171
  t174 = t29 * t172 * t63
  t175 = 0.11073470983333333333333333333333333333333333333333e-2 * t174
  t176 = t59 ** 2
  t177 = 0.1e1 / t176
  t178 = t45 * t177
  t180 = 0.1e1 / t46 * t26
  t181 = t28 * t31
  t182 = t181 * t171
  t183 = t180 * t182
  t185 = t29 * t172
  t187 = t35 ** 0.5e0
  t188 = t187 * t26
  t189 = t188 * t182
  t194 = t53 * t30 / t54 / t7
  t196 = -0.63297500000000000000000000000000000000000000000000e0 * t183 - 0.29896666666666666666666666666666666666666666666667e0 * t185 - 0.10238750000000000000000000000000000000000000000000e0 * t189 - 0.82156666666666666666666666666666666666666666666667e-1 * t194
  t197 = 0.1e1 / t62
  t198 = t196 * t197
  t199 = t178 * t198
  t200 = 0.10000000000000000000000000000000000000000000000000e1 * t199
  t201 = t66 * t6
  t202 = t201 * t70
  t203 = t202 * t110
  t204 = 0.4e1 * t203
  t205 = t69 * t7
  t206 = 0.1e1 / t205
  t207 = t67 * t206
  t208 = t207 * t110
  t209 = 0.4e1 * t208
  t210 = 0.1e1 / t68
  t211 = t6 * t210
  t212 = t8 - t211
  t215 = f.my_piecewise3(t11, 0, 0.4e1 / 0.3e1 * t14 * t212)
  t216 = -t212
  t219 = f.my_piecewise3(t18, 0, 0.4e1 / 0.3e1 * t19 * t216)
  t221 = (t215 + t219) * t81
  t222 = t221 * t109
  t223 = t71 * t222
  t227 = t89 ** 2
  t228 = 0.1e1 / t227
  t229 = t84 * t228
  t234 = -0.11765750000000000000000000000000000000000000000000e1 * t183 - 0.51647500000000000000000000000000000000000000000000e0 * t185 - 0.21038750000000000000000000000000000000000000000000e0 * t189 - 0.10419500000000000000000000000000000000000000000000e0 * t194
  t235 = 0.1e1 / t92
  t236 = t234 * t235
  t242 = t102 ** 2
  t243 = 0.1e1 / t242
  t244 = t97 * t243
  t249 = -0.86308333333333333333333333333333333333333333333334e0 * t183 - 0.30192500000000000000000000000000000000000000000000e0 * t185 - 0.55016250000000000000000000000000000000000000000000e-1 * t189 - 0.82785000000000000000000000000000000000000000000000e-1 * t194
  t250 = 0.1e1 / t105
  t251 = t249 * t250
  t254 = 0.53237641966666666666666666666666666666666666666666e-3 * t29 * t172 * t93 + 0.10000000000000000000000000000000000000000000000000e1 * t229 * t236 - t175 - t200 + 0.18311447306006545054854346104378990962041954983034e-3 * t29 * t172 * t106 + 0.58482236226346462072622386637590534819724553404280e0 * t244 * t251
  t255 = t82 * t254
  t256 = t71 * t255
  t257 = t221 * t107
  t258 = 0.19751673498613801407483339618206552048944131217655e-1 * t257
  t259 = t82 * t26
  t261 = t181 * t171 * t106
  t262 = t259 * t261
  t263 = 0.18311447306006545054854346104378990962041954983034e-3 * t262
  t264 = t82 * t97
  t266 = t243 * t249 * t250
  t267 = t264 * t266
  t268 = 0.58482236226346462072622386637590534819724553404280e0 * t267
  t270 = (t175 + t200 + t204 - t209 + t223 + t256 + t258 - t263 - t268) * t42
  t272 = t24 ** 2
  t273 = 0.1e1 / t272
  t274 = t3 * t273
  t275 = 0.1e1 / t14
  t278 = f.my_piecewise3(t11, 0, 0.2e1 / 0.3e1 * t275 * t212)
  t279 = 0.1e1 / t19
  t282 = f.my_piecewise3(t18, 0, 0.2e1 / 0.3e1 * t279 * t216)
  t284 = t278 / 0.2e1 + t282 / 0.2e1
  t285 = t274 * t284
  t288 = 0.3e1 * t115 * t285 - t270 * t117
  t289 = t288 * t119
  t291 = t168 * t169 * t289
  t295 = 0.1e1 / t32 / t142
  t296 = t295 * t78
  t300 = 0.64871090864172852777777777777777777777777777777777e-2 * t126 * t296 * t130 * t134
  t301 = t129 * t116
  t303 = t133 * t30 * t284
  t307 = -t152 + t161 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t291 - t300 - 0.55603792169291016666666666666666666666666666666666e-2 * t126 * t301 * t303
  t308 = t141 * t307
  t312 = 0.1e1 - 0.1e1 / t139
  t316 = 0.25000000000000000000000000000000000000000000000000e0 * t308 * t120 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t288 * t119
  t320 = 0.1e1 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t120
  t321 = 0.1e1 / t320
  t323 = t5 * t25 * t316 * t321
  t325 = r0 ** (0.1e1 / 0.3e1)
  t326 = t325 ** 2
  t329 = tau0 / t326 / r0
  t330 = t10 / 0.2e1
  t331 = t330 ** (0.1e1 / 0.3e1)
  t332 = t331 ** 2
  t333 = t332 * t330
  t335 = r1 ** (0.1e1 / 0.3e1)
  t336 = t335 ** 2
  t339 = tau1 / t336 / r1
  t340 = t17 / 0.2e1
  t341 = t340 ** (0.1e1 / 0.3e1)
  t342 = t341 ** 2
  t343 = t342 * t340
  t346 = 0.1e1 / t54 / t68
  t350 = 6 ** (0.1e1 / 0.3e1)
  t351 = (t329 * t333 + t339 * t343 - t124 * t346 / 0.8e1) * t350
  t352 = t3 ** (0.1e1 / 0.3e1)
  t353 = t352 ** 2
  t354 = 0.1e1 / t353
  t355 = t333 + t343
  t357 = t354 / t355
  t359 = 0.5e1 / 0.9e1 * t351 * t357
  t360 = t359 <= 0.1e1
  t361 = jnp.log(DBL_EPSILON)
  t364 = t361 / (-t361 + 0.64e0)
  t365 = -t364 < t359
  t366 = t359 < -t364
  t367 = r0 ** 2
  t370 = tau0 / t326 / t367
  t373 = t212 / 0.2e1
  t374 = t332 * t373
  t377 = -t373
  t378 = t342 * t377
  t381 = t124 * t144
  t382 = t381 / 0.3e1
  t384 = (-0.5e1 / 0.3e1 * t370 * t333 + 0.5e1 / 0.3e1 * t329 * t374 + 0.5e1 / 0.3e1 * t339 * t378 + t382) * t350
  t386 = t355 ** 2
  t388 = t354 / t386
  t390 = 0.5e1 / 0.3e1 * t374 + 0.5e1 / 0.3e1 * t378
  t391 = t388 * t390
  t394 = -0.5e1 / 0.9e1 * t351 * t391 + 0.5e1 / 0.9e1 * t384 * t357
  t395 = f.my_piecewise3(t366, t394, 0)
  t396 = f.my_piecewise3(t366, t359, -t364)
  t397 = 0.1e1 - t396
  t398 = 0.1e1 / t397
  t401 = t397 ** 2
  t402 = 0.1e1 / t401
  t403 = t396 * t402
  t406 = -0.64e0 * t395 * t398 - 0.64e0 * t403 * t395
  t409 = jnp.exp(-0.64e0 * t396 * t398)
  t411 = f.my_piecewise3(t365, 0, t406 * t409)
  t413 = jnp.log(0.14285714285714285714285714285714285714285714285714e1 * DBL_EPSILON)
  t416 = (-t413 + 0.15e1) / t413
  t417 = t359 < -t416
  t418 = f.my_piecewise3(t417, -t416, t359)
  t419 = 0.1e1 - t418
  t420 = t419 ** 2
  t421 = 0.1e1 / t420
  t422 = f.my_piecewise3(t417, 0, t394)
  t426 = jnp.exp(0.15e1 / t419)
  t429 = f.my_piecewise3(t417, 0, -0.105e1 * t421 * t422 * t426)
  t430 = f.my_piecewise3(t360, t411, t429)
  t433 = 0.1e1 + 0.44450000000000000000000000000000000000000000000000e-1 * t46 + 0.31385250000000000000000000000000000000000000000000e-1 * t35
  t434 = 0.1e1 / t433
  t437 = jnp.exp(0.10000000000000000000000000000000000000000000000000e1 * t434)
  t438 = t437 - 0.1e1
  t439 = t350 * t354
  t440 = t78 ** 2
  t441 = t440 * t124
  t445 = 0.1e1 + 0.21337642104376358333333333333333333333333333333333e-1 * t439 * t441 * t346
  t446 = t445 ** (0.1e1 / 0.4e1)
  t448 = 0.1e1 - 0.1e1 / t446
  t450 = t438 * t448 + 0.1e1
  t451 = jnp.log(t450)
  t453 = -0.285764e-1 * t434 + 0.285764e-1 * t451
  t457 = 0.1e1 - 0.2363e1 * t79 * t77 * t81
  t458 = t453 * t457
  t459 = t67 ** 2
  t460 = t459 * t67
  t461 = t69 ** 2
  t463 = 0.1e1 / t461 / t69
  t465 = -t460 * t463 + 0.1e1
  t467 = jnp.log(t320)
  t470 = -t5 * t25 * t467 + t458 * t465 - t111 - t113 + t65
  t471 = t430 * t470
  t474 = 0.20000000000000000000000000000000000000000000000000e1 * t199
  t475 = 0.36622894612013090109708692208757981924083909966068e-3 * t262
  t476 = t24 * t467
  t478 = t5 * t476 * t284
  t480 = 0.2e1 * t256
  t482 = 0.22146941966666666666666666666666666666666666666666e-2 * t174
  t483 = 0.8e1 * t203
  t484 = 0.8e1 * t208
  t488 = t196 ** 2
  t491 = 0.20000000000000000000000000000000000000000000000000e1 * t45 / t176 / t59 * t488 * t197
  t496 = t52 * t30 * t346
  t497 = 0.1e1 / t46 / t35 * t51 * t496
  t499 = t181 * t128
  t500 = t180 * t499
  t502 = t31 * t128
  t503 = t29 * t502
  t505 = t35 ** (-0.5e0)
  t507 = t505 * t51 * t496
  t509 = t188 * t499
  t512 = t53 * t30 * t346
  t517 = 0.10000000000000000000000000000000000000000000000000e1 * t178 * (-0.42198333333333333333333333333333333333333333333333e0 * t497 + 0.84396666666666666666666666666666666666666666666666e0 * t500 + 0.39862222222222222222222222222222222222222222222223e0 * t503 + 0.68258333333333333333333333333333333333333333333333e-1 * t507 + 0.13651666666666666666666666666666666666666666666667e0 * t509 + 0.13692777777777777777777777777777777777777777777778e0 * t512) * t197
  t521 = 0.24415263074675393406472461472505321282722606644045e-3 * t259 * t181 * t128 * t106
  t522 = t29 * t31
  t526 = 0.35616666666666666666666666666666666666666666666666e-1 * t522 * t171 * t177 * t198
  t528 = t221 * t26 * t261
  t529 = 0.36622894612013090109708692208757981924083909966068e-3 * t528
  t530 = f.my_piecewise3(t365, 0, t409)
  t532 = f.my_piecewise3(t417, 0, -0.7e0 * t426)
  t533 = f.my_piecewise3(t360, t530, t532)
  t536 = 0.132e3 * t459 * t66 * t463
  t537 = t459 * t201
  t539 = 0.1e1 / t461 / t205
  t541 = 0.288e3 * t537 * t539
  t542 = t69 * t68
  t546 = 0.156e3 * t460 / t461 / t542
  t549 = t433 ** 2
  t550 = 0.1e1 / t549
  t553 = -0.74083333333333333333333333333333333333333333333333e-2 * t183 - 0.10461750000000000000000000000000000000000000000000e-1 * t185
  t554 = t550 * t553
  t556 = t437 * t448
  t560 = 0.1e1 / t446 / t445
  t562 = t438 * t560 * t350
  t563 = t354 * t440
  t567 = -0.10000000000000000000000000000000000000000000000000e1 * t554 * t556 - 0.14225094736250905555555555555555555555555555555555e-1 * t562 * t563 * t381
  t568 = 0.1e1 / t450
  t571 = 0.285764e-1 * t554 + 0.285764e-1 * t567 * t568
  t572 = t571 * t457
  t573 = t537 * t463
  t574 = t460 * t539
  t576 = -0.12e2 * t573 + 0.12e2 * t574
  t577 = t572 * t576
  t581 = t553 ** 2
  t582 = 0.1e1 / t549 / t433 * t581
  t588 = t550 * (-0.49388888888888888888888888888888888888888888888889e-2 * t497 + 0.98777777777777777777777777777777777777777777777777e-2 * t500 + 0.13949000000000000000000000000000000000000000000000e-1 * t503)
  t594 = t549 ** 2
  t605 = t445 ** 2
  t609 = t350 ** 2
  t614 = t124 ** 2
  t623 = 0.1e1 / t54 / t69
  t624 = t124 * t623
  t631 = t567 ** 2
  t632 = t450 ** 2
  t638 = (-0.571528e-1 * t582 + 0.285764e-1 * t588 + 0.285764e-1 * (0.20000000000000000000000000000000000000000000000000e1 * t582 * t556 - 0.10000000000000000000000000000000000000000000000000e1 * t588 * t556 + 0.10000000000000000000000000000000000000000000000000e1 / t594 * t581 * t556 + 0.28450189472501811111111111111111111111111111111110e-1 * t554 * t437 * t560 * t439 * t441 * t144 - 0.20235332025531322029119593137558641975308641975307e-2 * t438 / t446 / t605 * t609 / t352 / t3 * t78 * t614 / t32 / t69 / t142 + 0.52158680699586653703703703703703703703703703703702e-1 * t562 * t563 * t624) * t568 - 0.285764e-1 * t631 / t632) * t457 * t465
  t640 = 0.8e1 * t202 * t255
  t643 = 0.12e2 * t66 * t70 * t110
  t646 = 0.32e2 * t201 * t206 * t110
  t650 = 0.10843581300301739842632067522386578331157260943710e-1 * t82 * t29 * t172 * t266
  t651 = 0.1e1 / t15
  t652 = t212 ** 2
  t655 = 0.1e1 / t142
  t656 = t6 * t655
  t657 = -t210 + t656
  t658 = 0.2e1 * t657
  t662 = f.my_piecewise3(t11, 0, 0.4e1 / 0.9e1 * t651 * t652 + 0.4e1 / 0.3e1 * t14 * t658)
  t663 = 0.1e1 / t20
  t664 = t216 ** 2
  t667 = -t658
  t671 = f.my_piecewise3(t18, 0, 0.4e1 / 0.9e1 * t663 * t664 + 0.4e1 / 0.3e1 * t19 * t667)
  t673 = (t662 + t671) * t81
  t675 = t71 * t673 * t109
  t686 = t234 ** 2
  t700 = t227 ** 2
  t703 = t92 ** 2
  t710 = 0.14764627977777777777777777777777777777777777777777e-2 * t29 * t502 * t63
  t711 = t176 ** 2
  t714 = t62 ** 2
  t718 = 0.16081979498692535066756296899072713062105388428051e2 * t45 / t711 * t488 / t714
  t727 = 0.1e1 / t242 / t102
  t729 = t249 ** 2
  t739 = -0.57538888888888888888888888888888888888888888888889e0 * t497 + 0.11507777777777777777777777777777777777777777777778e1 * t500 + 0.40256666666666666666666666666666666666666666666667e0 * t503 + 0.36677500000000000000000000000000000000000000000000e-1 * t507 + 0.73355000000000000000000000000000000000000000000000e-1 * t509 + 0.13797500000000000000000000000000000000000000000000e0 * t512
  t743 = t242 ** 2
  t744 = 0.1e1 / t743
  t746 = t105 ** 2
  t747 = 0.1e1 / t746
  t751 = -0.70983522622222222222222222222222222222222222222221e-3 * t29 * t502 * t93 - 0.34246666666666666666666666666666666666666666666666e-1 * t522 * t171 * t228 * t236 - 0.20000000000000000000000000000000000000000000000000e1 * t84 / t227 / t89 * t686 * t235 + 0.10000000000000000000000000000000000000000000000000e1 * t229 * (-0.78438333333333333333333333333333333333333333333333e0 * t497 + 0.15687666666666666666666666666666666666666666666667e1 * t500 + 0.68863333333333333333333333333333333333333333333333e0 * t503 + 0.14025833333333333333333333333333333333333333333333e0 * t507 + 0.28051666666666666666666666666666666666666666666667e0 * t509 + 0.17365833333333333333333333333333333333333333333333e0 * t512) * t235 + 0.32163958997385070133512593798145426124210776856102e2 * t84 / t700 * t686 / t703 + t710 + t526 + t491 - t517 - t718 - 0.24415263074675393406472461472505321282722606644045e-3 * t29 * t502 * t106 - 0.10843581300301739842632067522386578331157260943710e-1 * t522 * t171 * t243 * t251 - 0.11696447245269292414524477327518106963944910680856e1 * t97 * t727 * t729 * t250 + 0.58482236226346462072622386637590534819724553404280e0 * t244 * t739 * t250 + 0.17315859105681463759666483083807725165579399831905e2 * t97 * t744 * t729 * t747
  t753 = t71 * t82 * t751
  t754 = 0.1e1 / t73
  t760 = f.my_piecewise3(t11, 0, -0.2e1 / 0.9e1 * t754 * t652 + 0.2e1 / 0.3e1 * t275 * t658)
  t761 = 0.1e1 / t75
  t767 = f.my_piecewise3(t18, 0, -0.2e1 / 0.9e1 * t761 * t664 + 0.2e1 / 0.3e1 * t279 * t667)
  t769 = t760 / 0.2e1 + t767 / 0.2e1
  t772 = 0.3e1 * t5 * t476 * t769
  t773 = t491 - t517 + t458 * (-t536 + t541 - t546) + 0.2e1 * t577 - t521 + t526 + t529 + t638 - t640 - t643 + t646 - t650 - t675 - t753 + t710 - t718 - t772
  t774 = t5 * t24
  t775 = t316 * t321
  t778 = 0.6e1 * t774 * t775 * t284
  t780 = t221 * t97 * t266
  t781 = 0.11696447245269292414524477327518106963944910680856e1 * t780
  t785 = 0.58482236226346462072622386637590534819724553404280e0 * t264 * t243 * t739 * t250
  t789 = 0.11696447245269292414524477327518106963944910680856e1 * t264 * t727 * t729 * t250
  t793 = 0.17315859105681463759666483083807725165579399831905e2 * t264 * t744 * t729 * t747
  t795 = 0.8e1 * t207 * t255
  t796 = t202 * t222
  t797 = 0.8e1 * t796
  t799 = t71 * t221 * t254
  t800 = 0.2e1 * t799
  t801 = t207 * t222
  t802 = 0.8e1 * t801
  t803 = t571 * t79
  t804 = t221 * t465
  t805 = t803 * t804
  t807 = t453 * t79
  t814 = t316 ** 2
  t816 = t320 ** 2
  t817 = 0.1e1 / t816
  t819 = t5 * t25 * t814 * t817
  t823 = 0.20e2 * t67 / t542 * t110
  t825 = 0.19751673498613801407483339618206552048944131217655e-1 * t673 * t107
  t826 = t138 ** 2
  t828 = 0.1e1 / t139 / t826
  t829 = t307 ** 2
  t833 = t288 ** 2
  t842 = 0.16681137650787305000000000000000000000000000000000e-2 * t623 * t40 * t146 * t150
  t843 = t78 * t116
  t844 = t843 * t284
  t846 = t147 * t148 * t844
  t857 = 0.14648281543675415194338888888888888888888888888889e-4 * t37 / t153 / t39 * t42 * t125 * t206 * t78 * t130 * t522
  t858 = t146 * t163
  t859 = t145 * t858
  t860 = t124 * t78
  t862 = t130 * t288 * t119
  t864 = t859 * t860 * t862
  t870 = 0.29659062743099828290000000000000000000000000000000e-2 * t156 * t148 * t623 * t78 * t130
  t871 = t146 * t121
  t872 = t155 * t871
  t874 = t872 * t381 * t844
  t887 = 0.21623696954724284259259259259259259259259259259259e-1 * t126 / t32 / t69 * t78 * t130 * t134
  t888 = t296 * t116
  t890 = t126 * t888 * t303
  t897 = 0.82386285397499523027777777777777777777777777777777e-5 * t206 * t154 * t871 * t860 * t130 * t522
  t898 = t155 * t858
  t899 = t381 * t78
  t901 = t898 * t899 * t862
  t905 = t43 * t164 * t124 * t295
  t906 = t905 * t291
  t908 = t843 * t133
  t910 = t119 * t284
  t919 = t43 * t3 / t162 / t120 * t165
  t920 = t119 ** 2
  t926 = t718 + t825 - t793 - t781 - t785 + t823 + t753 + t675 + t800 - t802 - t795
  t927 = t797 + t640 - t491 - t529 + t789 - t526 - t710 + t650 + t517 + t643 - t646 + t521
  t934 = 0.1e1 / t272 / t23
  t935 = t3 * t934
  t936 = t284 ** 2
  t943 = -(t926 + t927) * t42 * t117 + 0.6e1 * t270 * t285 - 0.12e2 * t115 * t935 * t936 + 0.3e1 * t115 * t274 * t769
  t949 = t129 * t273
  t955 = -0.27801896084645508333333333333333333333333333333333e-2 * t167 * t168 * t169 * t833 * t119 + t842 + 0.11120758433858203333333333333333333333333333333333e-2 * t846 + t857 + 0.55603792169291016666666666666666666666666666666666e-3 * t864 - t870 - 0.19772708495399885526666666666666666666666666666666e-2 * t874 - 0.55603792169291016666666666666666666666666666666666e-2 * t126 * t301 * t133 * t30 * t769 + t887 + 0.25948436345669141111111111111111111111111111111110e-1 * t890 - t897 - 0.98863542476999427633333333333333333333333333333332e-3 * t901 + 0.12974218172834570555555555555555555555555555555555e-1 * t906 + 0.11120758433858203333333333333333333333333333333333e-1 * t167 * t908 * t30 * t288 * t910 + 0.55603792169291016666666666666666666666666666666666e-2 * t919 * t168 * t169 * t833 * t920 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t168 * t169 * t943 * t119 + 0.16681137650787305000000000000000000000000000000000e-1 * t126 * t949 * t133 * t30 * t936
  t970 = t5 * t25 * (-0.31250000000000000000000000000000000000000000000000e0 * t828 * t829 * t120 + 0.25000000000000000000000000000000000000000000000000e0 * t141 * t955 * t120 + 0.50000000000000000000000000000000000000000000000000e0 * t308 * t289 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t943 * t119 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t833 * t119) * t321
  t971 = t23 * t467
  t974 = 0.6e1 * t5 * t971 * t936
  t975 = -t778 + t781 + t785 - t789 + t793 + t795 - t797 - t800 + t802 - 0.4726e1 * t805 - 0.2363e1 * t807 * t673 * t465 - 0.4726e1 * t807 * t221 * t576 + t819 - t823 - t825 - t970 - t974
  t978 = -t491 + t517 + t521 - t526 - t529 + t533 * (t773 + t975) + t640 + t643 - t646 + t650 + t675 + t753 - t710 + t718 + t772
  t987 = 0.1e1 / t331
  t988 = t373 ** 2
  t989 = t987 * t988
  t992 = t332 * t657
  t995 = 0.1e1 / t341
  t996 = t377 ** 2
  t997 = t995 * t996
  t1001 = -t342 * t657
  t1004 = 0.11e2 / 0.9e1 * t624
  t1012 = 0.1e1 / t386 / t355
  t1013 = t354 * t1012
  t1014 = t390 ** 2
  t1026 = 0.5e1 / 0.9e1 * (0.40e2 / 0.9e1 * tau0 / t326 / t367 / r0 * t333 - 0.50e2 / 0.9e1 * t370 * t374 + 0.10e2 / 0.9e1 * t329 * t989 + 0.5e1 / 0.3e1 * t329 * t992 + 0.10e2 / 0.9e1 * t339 * t997 + 0.5e1 / 0.3e1 * t339 * t1001 - t1004) * t350 * t357 - 0.10e2 / 0.9e1 * t384 * t391 + 0.10e2 / 0.9e1 * t351 * t1013 * t1014 - 0.5e1 / 0.9e1 * t351 * t388 * (0.10e2 / 0.9e1 * t989 + 0.5e1 / 0.3e1 * t992 + 0.10e2 / 0.9e1 * t997 + 0.5e1 / 0.3e1 * t1001)
  t1027 = f.my_piecewise3(t366, t1026, 0)
  t1030 = t395 ** 2
  t1035 = t396 / t401 / t397
  t1042 = t406 ** 2
  t1045 = f.my_piecewise3(t365, 0, (-0.64e0 * t1027 * t398 - 0.128e1 * t1030 * t402 - 0.128e1 * t1035 * t1030 - 0.64e0 * t403 * t1027) * t409 + t1042 * t409)
  t1047 = 0.1e1 / t420 / t419
  t1048 = t422 ** 2
  t1052 = f.my_piecewise3(t417, 0, t1026)
  t1056 = t420 ** 2
  t1057 = 0.1e1 / t1056
  t1062 = f.my_piecewise3(t417, 0, -0.210e1 * t1047 * t1048 * t426 - 0.105e1 * t421 * t1052 * t426 - 0.1575e1 * t1057 * t1048 * t426)
  t1063 = f.my_piecewise3(t360, t1045, t1062)
  t1065 = t572 * t465
  t1069 = 0.3e1 * t478
  t1070 = t1065 - 0.2363e1 * t807 * t804 + t458 * t576 - t175 - t200 - t204 + t209 - t223 - t256 - t258 + t263 + t268 - t1069 - t323
  t1073 = t1063 * t470 + 0.2e1 * t430 * t1070 + t778 - t781 - t785 + t789 - t793 - t795 + t797 + t800 - t802 - t819 + t823 + t825 + t970 + t974
  t1076 = t533 * t1070
  t1078 = 0.11696447245269292414524477327518106963944910680856e1 * t267
  d11 = 0.2e1 * t323 + 0.2e1 * t471 + 0.39503346997227602814966679236413104097888262435310e-1 * t257 + t474 - t475 + 0.6e1 * t478 + t480 + 0.2e1 * t223 + t482 + t483 - t484 + t7 * (t978 + t1073) + 0.2e1 * t1076 - t1078
  t1079 = -t8 - t211
  t1082 = f.my_piecewise3(t11, 0, 0.4e1 / 0.3e1 * t14 * t1079)
  t1083 = -t1079
  t1086 = f.my_piecewise3(t18, 0, 0.4e1 / 0.3e1 * t19 * t1083)
  t1088 = (t1082 + t1086) * t81
  t1089 = t1088 * t465
  t1093 = 0.12e2 * t573 + 0.12e2 * t574
  t1095 = t1088 * t109
  t1096 = t71 * t1095
  t1097 = t1088 * t107
  t1098 = 0.19751673498613801407483339618206552048944131217655e-1 * t1097
  t1101 = f.my_piecewise3(t11, 0, 0.2e1 / 0.3e1 * t275 * t1079)
  t1104 = f.my_piecewise3(t18, 0, 0.2e1 / 0.3e1 * t279 * t1083)
  t1106 = t1101 / 0.2e1 + t1104 / 0.2e1
  t1108 = t5 * t476 * t1106
  t1109 = 0.3e1 * t1108
  t1111 = (t175 + t200 - t204 - t209 + t1096 + t256 + t1098 - t263 - t268) * t42
  t1113 = t274 * t1106
  t1116 = -t1111 * t117 + 0.3e1 * t115 * t1113
  t1117 = t1116 * t119
  t1119 = t168 * t169 * t1117
  t1122 = t30 * t1106
  t1123 = t133 * t1122
  t1127 = -t152 + t161 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t1119 - t300 - 0.55603792169291016666666666666666666666666666666666e-2 * t126 * t301 * t1123
  t1128 = t141 * t1127
  t1131 = t312 * t1116
  t1134 = 0.25000000000000000000000000000000000000000000000000e0 * t1128 * t120 + 0.10000000000000000000000000000000000000000000000000e1 * t1131 * t119
  t1137 = t5 * t25 * t1134 * t321
  t1138 = t1065 - 0.2363e1 * t807 * t1089 + t458 * t1093 - t175 - t200 + t204 + t209 - t1096 - t256 - t1098 + t263 + t268 - t1109 - t1137
  t1139 = t533 * t1138
  t1140 = t1079 / 0.2e1
  t1141 = t332 * t1140
  t1144 = r1 ** 2
  t1147 = tau1 / t336 / t1144
  t1150 = -t1140
  t1151 = t342 * t1150
  t1155 = (0.5e1 / 0.3e1 * t329 * t1141 - 0.5e1 / 0.3e1 * t1147 * t343 + 0.5e1 / 0.3e1 * t339 * t1151 + t382) * t350
  t1158 = 0.5e1 / 0.3e1 * t1141 + 0.5e1 / 0.3e1 * t1151
  t1159 = t388 * t1158
  t1162 = 0.5e1 / 0.9e1 * t1155 * t357 - 0.5e1 / 0.9e1 * t351 * t1159
  t1163 = f.my_piecewise3(t366, t1162, 0)
  t1168 = -0.64e0 * t1163 * t398 - 0.64e0 * t403 * t1163
  t1170 = f.my_piecewise3(t365, 0, t1168 * t409)
  t1171 = f.my_piecewise3(t417, 0, t1162)
  t1175 = f.my_piecewise3(t417, 0, -0.105e1 * t421 * t1171 * t426)
  t1176 = f.my_piecewise3(t360, t1170, t1175)
  t1177 = t1176 * t470
  t1178 = 0.18311447306006545054854346104378990962041954983034e-3 * t528
  t1181 = 0.3e1 * t774 * t775 * t1106
  t1189 = f.my_piecewise3(t11, 0, 0.4e1 / 0.9e1 * t651 * t1079 * t212 + 0.8e1 / 0.3e1 * t14 * t6 * t655)
  t1197 = f.my_piecewise3(t18, 0, 0.4e1 / 0.9e1 * t663 * t1083 * t216 - 0.8e1 / 0.3e1 * t19 * t6 * t655)
  t1199 = (t1189 + t1197) * t81
  t1201 = 0.19751673498613801407483339618206552048944131217655e-1 * t1199 * t107
  t1205 = t987 * t1140 * t373
  t1209 = t332 * t6 * t655
  t1215 = t995 * t1150 * t377
  t1219 = t342 * t6 * t655
  t1243 = 0.5e1 / 0.9e1 * (-0.25e2 / 0.9e1 * t370 * t1141 + 0.10e2 / 0.9e1 * t329 * t1205 + 0.5e1 / 0.3e1 * t329 * t1209 - 0.25e2 / 0.9e1 * t1147 * t378 + 0.10e2 / 0.9e1 * t339 * t1215 - 0.5e1 / 0.3e1 * t339 * t1219 - t1004) * t350 * t357 - 0.5e1 / 0.9e1 * t1155 * t391 - 0.5e1 / 0.9e1 * t384 * t1159 + 0.10e2 / 0.9e1 * t351 * t354 * t1012 * t1158 * t390 - 0.5e1 / 0.9e1 * t351 * t388 * (0.10e2 / 0.9e1 * t1205 + 0.5e1 / 0.3e1 * t1209 + 0.10e2 / 0.9e1 * t1215 - 0.5e1 / 0.3e1 * t1219)
  t1244 = f.my_piecewise3(t366, t1243, 0)
  t1260 = f.my_piecewise3(t365, 0, (-0.64e0 * t1244 * t398 - 0.128e1 * t1163 * t402 * t395 - 0.128e1 * t1035 * t1163 * t395 - 0.64e0 * t403 * t1244) * t409 + t1168 * t406 * t409)
  t1262 = t426 * t422
  t1265 = f.my_piecewise3(t417, 0, t1243)
  t1273 = f.my_piecewise3(t417, 0, -0.210e1 * t1047 * t1171 * t1262 - 0.105e1 * t421 * t1265 * t426 - 0.1575e1 * t1057 * t1171 * t1262)
  t1274 = f.my_piecewise3(t360, t1260, t1273)
  t1277 = t1088 * t26 * t261
  t1278 = 0.18311447306006545054854346104378990962041954983034e-3 * t1277
  t1279 = t202 * t1095
  t1280 = 0.4e1 * t1279
  t1281 = t207 * t1095
  t1282 = 0.4e1 * t1281
  t1284 = t71 * t1199 * t109
  t1286 = t71 * t1088 * t254
  t1287 = t1134 * t321
  t1290 = 0.3e1 * t774 * t1287 * t284
  t1294 = t5 * t25 * t1134 * t817 * t316
  t1302 = f.my_piecewise3(t11, 0, -0.2e1 / 0.9e1 * t754 * t1079 * t212 + 0.4e1 / 0.3e1 * t275 * t6 * t655)
  t1310 = f.my_piecewise3(t18, 0, -0.2e1 / 0.9e1 * t761 * t1083 * t216 - 0.4e1 / 0.3e1 * t279 * t6 * t655)
  t1312 = t1302 / 0.2e1 + t1310 / 0.2e1
  t1315 = 0.3e1 * t5 * t476 * t1312
  t1316 = t1274 * t470 - t1178 + t1181 + t1201 - t1278 + t1280 - t1282 + t1284 + t1286 + t1290 - t1294 + t1315 - t491 + t517 + t521 - t526 - t643 + t650
  t1317 = t803 * t1089
  t1328 = t491 - t517 + t577 - t521 + t526 + t1178 - t1181 + t638 - t1201 + t1278 - t1280 + t1282 - t1284 - t1286 - t1290 + t1294 - 0.2363e1 * t1317 - 0.2363e1 * t807 * t1199 * t465 - 0.2363e1 * t807 * t1088 * t576 - 0.2363e1 * t807 * t221 * t1093
  t1329 = t572 * t1093
  t1336 = 0.6e1 * t5 * t23 * t467 * t1106 * t284
  t1341 = t149 * t133
  t1342 = t30 * t1116
  t1348 = t905 * t1119
  t1363 = t843 * t1106
  t1365 = t147 * t148 * t1363
  t1368 = t130 * t1116 * t119
  t1370 = t859 * t860 * t1368
  t1373 = t872 * t381 * t1363
  t1376 = 0.55603792169291016666666666666666666666666666666666e-2 * t919 * t1341 * t1342 * t920 * t288 + 0.64871090864172852777777777777777777777777777777777e-2 * t1348 + 0.55603792169291016666666666666666666666666666666666e-2 * t167 * t908 * t1342 * t910 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t1341 * t1342 * t289 + 0.55603792169291016666666666666666666666666666666666e-2 * t167 * t908 * t1122 * t289 + 0.55603792169291016666666666666666666666666666666666e-3 * t846 + 0.55603792169291016666666666666666666666666666666666e-3 * t1365 + t842 + t857 + 0.27801896084645508333333333333333333333333333333333e-3 * t1370 - 0.98863542476999427633333333333333333333333333333332e-3 * t1373 + 0.27801896084645508333333333333333333333333333333333e-3 * t864
  t1386 = t898 * t899 * t1368
  t1388 = -t491 + t517 + t521 - t526 - t1178 + t1201 - t1278 + t1280 - t1282 + t1284 + t1286 - t643 + t650
  t1389 = 0.58482236226346462072622386637590534819724553404280e0 * t780
  t1390 = 0.4e1 * t796
  t1391 = 0.4e1 * t801
  t1393 = t1088 * t97 * t266
  t1394 = 0.58482236226346462072622386637590534819724553404280e0 * t1393
  t1395 = t753 - t710 + t718 - t1389 - t785 + t789 - t793 - t795 - t1390 + t799 - t1391 + t823 - t1394
  t1411 = -(t1388 + t1395) * t42 * t117 + 0.3e1 * t1111 * t285 + 0.3e1 * t270 * t1113 - 0.12e2 * t115 * t3 * t934 * t1106 * t284 + 0.3e1 * t115 * t274 * t1312
  t1419 = t126 * t888 * t1123
  t1430 = -t870 - 0.98863542476999427633333333333333333333333333333332e-3 * t874 - 0.55603792169291016666666666666666666666666666666666e-2 * t126 * t301 * t133 * t30 * t1312 + t887 + 0.12974218172834570555555555555555555555555555555555e-1 * t890 - t897 - 0.49431771238499713816666666666666666666666666666666e-3 * t901 - 0.49431771238499713816666666666666666666666666666666e-3 * t1386 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t168 * t169 * t1411 * t119 + 0.64871090864172852777777777777777777777777777777777e-2 * t906 + 0.12974218172834570555555555555555555555555555555555e-1 * t1419 + 0.16681137650787305000000000000000000000000000000000e-1 * t43 * t122 * t165 * t78 * t273 * t51 * t169 * t1106 * t284
  t1447 = t5 * t25 * (-0.31250000000000000000000000000000000000000000000000e0 * t828 * t1127 * t120 * t307 + 0.25000000000000000000000000000000000000000000000000e0 * t141 * (t1376 + t1430) * t120 + 0.25000000000000000000000000000000000000000000000000e0 * t1128 * t289 + 0.25000000000000000000000000000000000000000000000000e0 * t308 * t1117 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t1411 * t119 + 0.10000000000000000000000000000000000000000000000000e1 * t1131 * t289) * t321
  t1450 = t1389 + t785 - t789 + t793 + t795 + t1390 - t799 + t1391 - 0.2363e1 * t805 - t823 + t1394
  t1456 = t533 * (t1328 - t1315 + t643 - t650 - t753 + t710 - t718 + t1329 + t458 * (t536 - t546) - t1336 - t1447 + t1450) + t753 - t710 + t718 + t1336 + t430 * t1138 + t1447 - t1389 - t785 + t789 - t793 - t795 - t1390 + t799 - t1391 + t1176 * t1070 + t823 - t1394
  d12 = -t475 - t1078 + t1139 + t258 + t1177 + t1109 + t480 + t1096 - t484 + t323 + t482 + t1069 + t7 * (t1316 + t1456) + t471 + t1076 + t1098 + t223 + t474 + t1137
  t1463 = t1079 ** 2
  t1466 = t210 + t656
  t1467 = 0.2e1 * t1466
  t1471 = f.my_piecewise3(t11, 0, 0.4e1 / 0.9e1 * t651 * t1463 + 0.4e1 / 0.3e1 * t14 * t1467)
  t1472 = t1083 ** 2
  t1475 = -t1467
  t1479 = f.my_piecewise3(t18, 0, 0.4e1 / 0.9e1 * t663 * t1472 + 0.4e1 / 0.3e1 * t19 * t1475)
  t1481 = (t1471 + t1479) * t81
  t1483 = 0.19751673498613801407483339618206552048944131217655e-1 * t1481 * t107
  t1489 = f.my_piecewise3(t11, 0, -0.2e1 / 0.9e1 * t754 * t1463 + 0.2e1 / 0.3e1 * t275 * t1467)
  t1495 = f.my_piecewise3(t18, 0, -0.2e1 / 0.9e1 * t761 * t1472 + 0.2e1 / 0.3e1 * t279 * t1475)
  t1497 = t1489 / 0.2e1 + t1495 / 0.2e1
  t1500 = 0.3e1 * t5 * t476 * t1497
  t1501 = t1127 ** 2
  t1505 = t1116 ** 2
  t1532 = 0.11696447245269292414524477327518106963944910680856e1 * t1393
  t1533 = 0.36622894612013090109708692208757981924083909966068e-3 * t1277
  t1534 = t517 + t823 + t646 - t710 + t1483 - t785 - t793 + t650 - t1532 - t1533 + t789
  t1536 = t71 * t1481 * t109
  t1537 = 0.2e1 * t1286
  t1538 = 0.8e1 * t1281
  t1539 = 0.8e1 * t1279
  t1540 = t753 - t526 + t1536 + t1537 + t643 - t1538 - t795 + t718 - t491 - t1539 - t640 + t521
  t1546 = t1106 ** 2
  t1553 = -(t1534 + t1540) * t42 * t117 + 0.6e1 * t1111 * t1113 - 0.12e2 * t115 * t935 * t1546 + 0.3e1 * t115 * t274 * t1497
  t1564 = 0.55603792169291016666666666666666666666666666666666e-2 * t919 * t168 * t169 * t1505 * t920 + 0.12974218172834570555555555555555555555555555555555e-1 * t1348 + 0.11120758433858203333333333333333333333333333333333e-1 * t167 * t908 * t1342 * t119 * t1106 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t168 * t169 * t1505 * t119 + t842 + 0.11120758433858203333333333333333333333333333333333e-2 * t1365 + t857 + 0.55603792169291016666666666666666666666666666666666e-3 * t1370 - t870 - 0.19772708495399885526666666666666666666666666666666e-2 * t1373 - 0.55603792169291016666666666666666666666666666666666e-2 * t126 * t301 * t133 * t30 * t1497 + t887 + 0.25948436345669141111111111111111111111111111111110e-1 * t1419 - t897 - 0.98863542476999427633333333333333333333333333333332e-3 * t1386 - 0.27801896084645508333333333333333333333333333333333e-2 * t167 * t168 * t169 * t1553 * t119 + 0.16681137650787305000000000000000000000000000000000e-1 * t126 * t949 * t133 * t30 * t1546
  t1579 = t5 * t25 * (-0.31250000000000000000000000000000000000000000000000e0 * t828 * t1501 * t120 + 0.25000000000000000000000000000000000000000000000000e0 * t141 * t1564 * t120 + 0.50000000000000000000000000000000000000000000000000e0 * t1128 * t1117 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t1553 * t119 + 0.10000000000000000000000000000000000000000000000000e1 * t312 * t1505 * t119) * t321
  t1582 = 0.6e1 * t5 * t971 * t1546
  t1584 = t491 - t517 - t1483 - t521 + t526 - t1500 - t1579 + t638 - t1536 + t1533 - t1582 + t1539 + t1538 - t1537 + t640 - 0.4726e1 * t1317 - t643
  t1586 = t1134 ** 2
  t1589 = t5 * t25 * t1586 * t817
  t1592 = 0.6e1 * t774 * t1287 * t1106
  t1601 = -t646 - t650 - t753 + t710 - t718 + 0.2e1 * t1329 + t1589 - t1592 + t785 - t789 + t793 + t795 - t823 + t1532 - 0.2363e1 * t807 * t1481 * t465 - 0.4726e1 * t807 * t1088 * t1093 + t458 * (-t536 - t541 - t546)
  t1604 = -t491 + t517 + t1483 + t521 - t526 + t1500 + t1579 + t1536 - t1533 + t1582 - t1539 - t1538 + t1537 - t640 + t533 * (t1584 + t1601)
  t1605 = t1140 ** 2
  t1606 = t987 * t1605
  t1609 = t332 * t1466
  t1620 = t1150 ** 2
  t1621 = t995 * t1620
  t1625 = -t342 * t1466
  t1634 = t1158 ** 2
  t1646 = 0.5e1 / 0.9e1 * (0.10e2 / 0.9e1 * t329 * t1606 + 0.5e1 / 0.3e1 * t329 * t1609 + 0.40e2 / 0.9e1 * tau1 / t336 / t1144 / r1 * t343 - 0.50e2 / 0.9e1 * t1147 * t1151 + 0.10e2 / 0.9e1 * t339 * t1621 + 0.5e1 / 0.3e1 * t339 * t1625 - t1004) * t350 * t357 - 0.10e2 / 0.9e1 * t1155 * t1159 + 0.10e2 / 0.9e1 * t351 * t1013 * t1634 - 0.5e1 / 0.9e1 * t351 * t388 * (0.10e2 / 0.9e1 * t1606 + 0.5e1 / 0.3e1 * t1609 + 0.10e2 / 0.9e1 * t1621 + 0.5e1 / 0.3e1 * t1625)
  t1647 = f.my_piecewise3(t366, t1646, 0)
  t1650 = t1163 ** 2
  t1659 = t1168 ** 2
  t1662 = f.my_piecewise3(t365, 0, (-0.64e0 * t1647 * t398 - 0.128e1 * t1650 * t402 - 0.128e1 * t1035 * t1650 - 0.64e0 * t403 * t1647) * t409 + t1659 * t409)
  t1663 = t1171 ** 2
  t1667 = f.my_piecewise3(t417, 0, t1646)
  t1675 = f.my_piecewise3(t417, 0, -0.210e1 * t1047 * t1663 * t426 - 0.105e1 * t421 * t1667 * t426 - 0.1575e1 * t1057 * t1663 * t426)
  t1676 = f.my_piecewise3(t360, t1662, t1675)
  t1680 = 0.2e1 * t1176 * t1138 + t1676 * t470 - t1532 - t1589 + t1592 + t643 + t646 + t650 - t710 + t718 + t753 - t785 + t789 - t793 - t795 + t823
  d22 = -t475 + t482 - t1078 + 0.2e1 * t1177 + 0.2e1 * t1139 + 0.2e1 * t1096 - t483 - t484 + 0.6e1 * t1108 + t480 + t7 * (t1604 + t1680) + 0.39503346997227602814966679236413104097888262435310e-1 * t1097 + t474 + 0.2e1 * t1137
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

