"""Generated from mgga_c_vsxc.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_alpha_ab_raw = params.alpha_ab
  if isinstance(params_alpha_ab_raw, (str, bytes, dict)):
    params_alpha_ab = params_alpha_ab_raw
  else:
    try:
      params_alpha_ab_seq = list(params_alpha_ab_raw)
    except TypeError:
      params_alpha_ab = params_alpha_ab_raw
    else:
      params_alpha_ab_seq = np.asarray(params_alpha_ab_seq, dtype=np.float64)
      params_alpha_ab = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_ab_seq))
  params_alpha_ss_raw = params.alpha_ss
  if isinstance(params_alpha_ss_raw, (str, bytes, dict)):
    params_alpha_ss = params_alpha_ss_raw
  else:
    try:
      params_alpha_ss_seq = list(params_alpha_ss_raw)
    except TypeError:
      params_alpha_ss = params_alpha_ss_raw
    else:
      params_alpha_ss_seq = np.asarray(params_alpha_ss_seq, dtype=np.float64)
      params_alpha_ss = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_ss_seq))
  params_dab_raw = params.dab
  if isinstance(params_dab_raw, (str, bytes, dict)):
    params_dab = params_dab_raw
  else:
    try:
      params_dab_seq = list(params_dab_raw)
    except TypeError:
      params_dab = params_dab_raw
    else:
      params_dab_seq = np.asarray(params_dab_seq, dtype=np.float64)
      params_dab = np.concatenate((np.array([np.nan], dtype=np.float64), params_dab_seq))
  params_dss_raw = params.dss
  if isinstance(params_dss_raw, (str, bytes, dict)):
    params_dss = params_dss_raw
  else:
    try:
      params_dss_seq = list(params_dss_raw)
    except TypeError:
      params_dss = params_dss_raw
    else:
      params_dss_seq = np.asarray(params_dss_seq, dtype=np.float64)
      params_dss = np.concatenate((np.array([np.nan], dtype=np.float64), params_dss_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  gvt4_gamm = lambda alpha, x, z: 1 + alpha * (x ** 2 + z)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  gtv4 = lambda alpha, dd, x, z: dd[1] / gvt4_gamm(alpha, x, z) + (dd[2] * x ** 2 + dd[3] * z) / gvt4_gamm(alpha, x, z) ** 2 + (dd[4] * x ** 4 + dd[5] * x ** 2 * z + dd[6] * z ** 2) / gvt4_gamm(alpha, x, z) ** 3

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  vsxc_comp = lambda rs, z, spin, xs, ts: +lda_stoll_par(f, params, f_pw, rs, z, 1) * gtv4(params_alpha_ss, params_dss, xs, 2 * (ts - K_FACTOR_C)) * f.Fermi_D(xs, ts)

  vsxc_fperp = lambda rs, z, xs0, xs1, ts0, ts1: +lda_stoll_perp(f, params, f_pw, rs, z) * gtv4(params_alpha_ab, params_dab, jnp.sqrt(xs0 ** 2 + xs1 ** 2), 2 * (ts0 + ts1 - 2 * K_FACTOR_C))

  vsxc_fpar = lambda rs, z, xs0, xs1, ts0, ts1: +vsxc_comp(rs, z, 1, xs0, ts0) + vsxc_comp(rs, -z, -1, xs1, ts1)

  vsxc_f = lambda rs, z, xs0, xs1, ts0, ts1: +vsxc_fpar(rs, z, xs0, xs1, ts0, ts1) + vsxc_fperp(rs, z, xs0, xs1, ts0, ts1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: vsxc_f(rs, z, xs0, xs1, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_alpha_ab_raw = params.alpha_ab
  if isinstance(params_alpha_ab_raw, (str, bytes, dict)):
    params_alpha_ab = params_alpha_ab_raw
  else:
    try:
      params_alpha_ab_seq = list(params_alpha_ab_raw)
    except TypeError:
      params_alpha_ab = params_alpha_ab_raw
    else:
      params_alpha_ab_seq = np.asarray(params_alpha_ab_seq, dtype=np.float64)
      params_alpha_ab = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_ab_seq))
  params_alpha_ss_raw = params.alpha_ss
  if isinstance(params_alpha_ss_raw, (str, bytes, dict)):
    params_alpha_ss = params_alpha_ss_raw
  else:
    try:
      params_alpha_ss_seq = list(params_alpha_ss_raw)
    except TypeError:
      params_alpha_ss = params_alpha_ss_raw
    else:
      params_alpha_ss_seq = np.asarray(params_alpha_ss_seq, dtype=np.float64)
      params_alpha_ss = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_ss_seq))
  params_dab_raw = params.dab
  if isinstance(params_dab_raw, (str, bytes, dict)):
    params_dab = params_dab_raw
  else:
    try:
      params_dab_seq = list(params_dab_raw)
    except TypeError:
      params_dab = params_dab_raw
    else:
      params_dab_seq = np.asarray(params_dab_seq, dtype=np.float64)
      params_dab = np.concatenate((np.array([np.nan], dtype=np.float64), params_dab_seq))
  params_dss_raw = params.dss
  if isinstance(params_dss_raw, (str, bytes, dict)):
    params_dss = params_dss_raw
  else:
    try:
      params_dss_seq = list(params_dss_raw)
    except TypeError:
      params_dss = params_dss_raw
    else:
      params_dss_seq = np.asarray(params_dss_seq, dtype=np.float64)
      params_dss = np.concatenate((np.array([np.nan], dtype=np.float64), params_dss_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  gvt4_gamm = lambda alpha, x, z: 1 + alpha * (x ** 2 + z)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  gtv4 = lambda alpha, dd, x, z: dd[1] / gvt4_gamm(alpha, x, z) + (dd[2] * x ** 2 + dd[3] * z) / gvt4_gamm(alpha, x, z) ** 2 + (dd[4] * x ** 4 + dd[5] * x ** 2 * z + dd[6] * z ** 2) / gvt4_gamm(alpha, x, z) ** 3

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  vsxc_comp = lambda rs, z, spin, xs, ts: +lda_stoll_par(f, params, f_pw, rs, z, 1) * gtv4(params_alpha_ss, params_dss, xs, 2 * (ts - K_FACTOR_C)) * f.Fermi_D(xs, ts)

  vsxc_fperp = lambda rs, z, xs0, xs1, ts0, ts1: +lda_stoll_perp(f, params, f_pw, rs, z) * gtv4(params_alpha_ab, params_dab, jnp.sqrt(xs0 ** 2 + xs1 ** 2), 2 * (ts0 + ts1 - 2 * K_FACTOR_C))

  vsxc_fpar = lambda rs, z, xs0, xs1, ts0, ts1: +vsxc_comp(rs, z, 1, xs0, ts0) + vsxc_comp(rs, -z, -1, xs1, ts1)

  vsxc_f = lambda rs, z, xs0, xs1, ts0, ts1: +vsxc_fpar(rs, z, xs0, xs1, ts0, ts1) + vsxc_fperp(rs, z, xs0, xs1, ts0, ts1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: vsxc_f(rs, z, xs0, xs1, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_alpha_ab_raw = params.alpha_ab
  if isinstance(params_alpha_ab_raw, (str, bytes, dict)):
    params_alpha_ab = params_alpha_ab_raw
  else:
    try:
      params_alpha_ab_seq = list(params_alpha_ab_raw)
    except TypeError:
      params_alpha_ab = params_alpha_ab_raw
    else:
      params_alpha_ab_seq = np.asarray(params_alpha_ab_seq, dtype=np.float64)
      params_alpha_ab = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_ab_seq))
  params_alpha_ss_raw = params.alpha_ss
  if isinstance(params_alpha_ss_raw, (str, bytes, dict)):
    params_alpha_ss = params_alpha_ss_raw
  else:
    try:
      params_alpha_ss_seq = list(params_alpha_ss_raw)
    except TypeError:
      params_alpha_ss = params_alpha_ss_raw
    else:
      params_alpha_ss_seq = np.asarray(params_alpha_ss_seq, dtype=np.float64)
      params_alpha_ss = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_ss_seq))
  params_dab_raw = params.dab
  if isinstance(params_dab_raw, (str, bytes, dict)):
    params_dab = params_dab_raw
  else:
    try:
      params_dab_seq = list(params_dab_raw)
    except TypeError:
      params_dab = params_dab_raw
    else:
      params_dab_seq = np.asarray(params_dab_seq, dtype=np.float64)
      params_dab = np.concatenate((np.array([np.nan], dtype=np.float64), params_dab_seq))
  params_dss_raw = params.dss
  if isinstance(params_dss_raw, (str, bytes, dict)):
    params_dss = params_dss_raw
  else:
    try:
      params_dss_seq = list(params_dss_raw)
    except TypeError:
      params_dss = params_dss_raw
    else:
      params_dss_seq = np.asarray(params_dss_seq, dtype=np.float64)
      params_dss = np.concatenate((np.array([np.nan], dtype=np.float64), params_dss_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  gvt4_gamm = lambda alpha, x, z: 1 + alpha * (x ** 2 + z)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  gtv4 = lambda alpha, dd, x, z: dd[1] / gvt4_gamm(alpha, x, z) + (dd[2] * x ** 2 + dd[3] * z) / gvt4_gamm(alpha, x, z) ** 2 + (dd[4] * x ** 4 + dd[5] * x ** 2 * z + dd[6] * z ** 2) / gvt4_gamm(alpha, x, z) ** 3

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  vsxc_comp = lambda rs, z, spin, xs, ts: +lda_stoll_par(f, params, f_pw, rs, z, 1) * gtv4(params_alpha_ss, params_dss, xs, 2 * (ts - K_FACTOR_C)) * f.Fermi_D(xs, ts)

  vsxc_fperp = lambda rs, z, xs0, xs1, ts0, ts1: +lda_stoll_perp(f, params, f_pw, rs, z) * gtv4(params_alpha_ab, params_dab, jnp.sqrt(xs0 ** 2 + xs1 ** 2), 2 * (ts0 + ts1 - 2 * K_FACTOR_C))

  vsxc_fpar = lambda rs, z, xs0, xs1, ts0, ts1: +vsxc_comp(rs, z, 1, xs0, ts0) + vsxc_comp(rs, -z, -1, xs1, ts1)

  vsxc_f = lambda rs, z, xs0, xs1, ts0, ts1: +vsxc_fpar(rs, z, xs0, xs1, ts0, ts1) + vsxc_fperp(rs, z, xs0, xs1, ts0, ts1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: vsxc_f(rs, z, xs0, xs1, ts0, ts1)

  t2 = r0 - r1
  t3 = r0 + r1
  t4 = 0.1e1 / t3
  t5 = t2 * t4
  t6 = 0.1e1 + t5
  t7 = t6 <= f.p.zeta_threshold
  t8 = r0 <= f.p.dens_threshold or t7
  t9 = f.my_piecewise3(t7, f.p.zeta_threshold, t6)
  t10 = 3 ** (0.1e1 / 0.3e1)
  t12 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t13 = t10 * t12
  t14 = 4 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t16 = t13 * t15
  t17 = t3 ** (0.1e1 / 0.3e1)
  t18 = 0.1e1 / t17
  t19 = 2 ** (0.1e1 / 0.3e1)
  t20 = t18 * t19
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = 0.1e1 / t21
  t23 = t6 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t7, t22, 0.1e1 / t23)
  t27 = t16 * t20 * t25
  t29 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t27
  t30 = jnp.sqrt(t27)
  t33 = t27 ** 0.15e1
  t35 = t10 ** 2
  t36 = t12 ** 2
  t37 = t35 * t36
  t38 = t37 * t14
  t39 = t17 ** 2
  t40 = 0.1e1 / t39
  t41 = t19 ** 2
  t42 = t40 * t41
  t43 = t25 ** 2
  t45 = t38 * t42 * t43
  t47 = 0.23615562999000000000000000000000000000000000000000e0 * t30 + 0.55770497660000000000000000000000000000000000000000e-1 * t27 + 0.12733196185000000000000000000000000000000000000000e-1 * t33 + 0.76629248290000000000000000000000000000000000000000e-2 * t45
  t49 = 0.1e1 + 0.1e1 / t47
  t50 = jnp.log(t49)
  t51 = t29 * t50
  t53 = t21 * f.p.zeta_threshold
  t55 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t53, 0.2e1 * t19)
  t57 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t53, 0)
  t61 = 0.1e1 / (0.2e1 * t19 - 0.2e1)
  t62 = (t55 + t57 - 0.2e1) * t61
  t64 = 0.3109070e-1 + 0.15971292590000000000000000000000000000000000000000e-2 * t27
  t69 = 0.21948324211500000000000000000000000000000000000000e0 * t30 + 0.48172707847500000000000000000000000000000000000000e-1 * t27 + 0.13082189292500000000000000000000000000000000000000e-1 * t33 + 0.48592432297500000000000000000000000000000000000000e-2 * t45
  t71 = 0.1e1 + 0.1e1 / t69
  t72 = jnp.log(t71)
  t75 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t27
  t80 = 0.17489762330000000000000000000000000000000000000000e0 * t30 + 0.30591463695000000000000000000000000000000000000000e-1 * t27 + 0.37162156485000000000000000000000000000000000000000e-2 * t33 + 0.41939460495000000000000000000000000000000000000000e-2 * t45
  t82 = 0.1e1 + 0.1e1 / t80
  t83 = jnp.log(t82)
  t84 = t75 * t83
  t90 = -t51 + t62 * (-t64 * t72 + t51 - 0.58482236226346462072622386637590534819724553404281e0 * t84) + 0.58482236226346462072622386637590534819724553404281e0 * t62 * t84
  t93 = f.my_piecewise3(t8, 0, t9 * t90 / 0.2e1)
  t94 = params.dss[0]
  t95 = r0 ** 2
  t96 = r0 ** (0.1e1 / 0.3e1)
  t97 = t96 ** 2
  t99 = 0.1e1 / t97 / t95
  t100 = s0 * t99
  t102 = 0.1e1 / t97 / r0
  t104 = 0.2e1 * tau0 * t102
  t105 = 6 ** (0.1e1 / 0.3e1)
  t106 = t105 ** 2
  t107 = jnp.pi ** 2
  t108 = t107 ** (0.1e1 / 0.3e1)
  t109 = t108 ** 2
  t110 = t106 * t109
  t111 = 0.3e1 / 0.5e1 * t110
  t114 = 0.1e1 + params.alpha_ss * (t100 + t104 - t111)
  t117 = params.dss[1]
  t118 = t117 * s0
  t120 = params.dss[2]
  t121 = t104 - t111
  t123 = t118 * t99 + t120 * t121
  t124 = t114 ** 2
  t125 = 0.1e1 / t124
  t127 = params.dss[3]
  t128 = s0 ** 2
  t129 = t127 * t128
  t130 = t95 ** 2
  t133 = 0.1e1 / t96 / t130 / r0
  t135 = params.dss[4]
  t136 = t135 * s0
  t139 = params.dss[5]
  t140 = t121 ** 2
  t142 = t136 * t99 * t121 + t129 * t133 + t139 * t140
  t144 = 0.1e1 / t124 / t114
  t146 = t94 / t114 + t123 * t125 + t142 * t144
  t147 = t93 * t146
  t148 = 0.1e1 / r0
  t149 = s0 * t148
  t150 = 0.1e1 / tau0
  t153 = 0.1e1 - t149 * t150 / 0.8e1
  t154 = t147 * t153
  t156 = 0.1e1 - t5
  t157 = t156 <= f.p.zeta_threshold
  t158 = r1 <= f.p.dens_threshold or t157
  t159 = f.my_piecewise3(t157, f.p.zeta_threshold, t156)
  t160 = t156 ** (0.1e1 / 0.3e1)
  t162 = f.my_piecewise3(t157, t22, 0.1e1 / t160)
  t164 = t16 * t20 * t162
  t166 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t164
  t167 = jnp.sqrt(t164)
  t170 = t164 ** 0.15e1
  t172 = t162 ** 2
  t174 = t38 * t42 * t172
  t176 = 0.23615562999000000000000000000000000000000000000000e0 * t167 + 0.55770497660000000000000000000000000000000000000000e-1 * t164 + 0.12733196185000000000000000000000000000000000000000e-1 * t170 + 0.76629248290000000000000000000000000000000000000000e-2 * t174
  t178 = 0.1e1 + 0.1e1 / t176
  t179 = jnp.log(t178)
  t180 = t166 * t179
  t182 = 0.3109070e-1 + 0.15971292590000000000000000000000000000000000000000e-2 * t164
  t187 = 0.21948324211500000000000000000000000000000000000000e0 * t167 + 0.48172707847500000000000000000000000000000000000000e-1 * t164 + 0.13082189292500000000000000000000000000000000000000e-1 * t170 + 0.48592432297500000000000000000000000000000000000000e-2 * t174
  t189 = 0.1e1 + 0.1e1 / t187
  t190 = jnp.log(t189)
  t193 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t164
  t198 = 0.17489762330000000000000000000000000000000000000000e0 * t167 + 0.30591463695000000000000000000000000000000000000000e-1 * t164 + 0.37162156485000000000000000000000000000000000000000e-2 * t170 + 0.41939460495000000000000000000000000000000000000000e-2 * t174
  t200 = 0.1e1 + 0.1e1 / t198
  t201 = jnp.log(t200)
  t202 = t193 * t201
  t208 = -t180 + t62 * (-t182 * t190 + t180 - 0.58482236226346462072622386637590534819724553404281e0 * t202) + 0.58482236226346462072622386637590534819724553404281e0 * t62 * t202
  t211 = f.my_piecewise3(t158, 0, t159 * t208 / 0.2e1)
  t212 = r1 ** 2
  t213 = r1 ** (0.1e1 / 0.3e1)
  t214 = t213 ** 2
  t216 = 0.1e1 / t214 / t212
  t217 = s2 * t216
  t219 = 0.1e1 / t214 / r1
  t221 = 0.2e1 * tau1 * t219
  t224 = 0.1e1 + params.alpha_ss * (t217 + t221 - t111)
  t227 = t117 * s2
  t229 = t221 - t111
  t231 = t120 * t229 + t227 * t216
  t232 = t224 ** 2
  t233 = 0.1e1 / t232
  t235 = s2 ** 2
  t236 = t127 * t235
  t237 = t212 ** 2
  t240 = 0.1e1 / t213 / t237 / r1
  t242 = t135 * s2
  t245 = t229 ** 2
  t247 = t242 * t216 * t229 + t139 * t245 + t236 * t240
  t249 = 0.1e1 / t232 / t224
  t251 = t94 / t224 + t231 * t233 + t247 * t249
  t252 = t211 * t251
  t253 = 0.1e1 / r1
  t254 = s2 * t253
  t255 = 0.1e1 / tau1
  t258 = 0.1e1 - t254 * t255 / 0.8e1
  t259 = t252 * t258
  t261 = t13 * t15 * t18
  t263 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t261
  t264 = jnp.sqrt(t261)
  t267 = t261 ** 0.15e1
  t270 = t37 * t14 * t40
  t272 = 0.23615562999000000000000000000000000000000000000000e0 * t264 + 0.55770497660000000000000000000000000000000000000000e-1 * t261 + 0.12733196185000000000000000000000000000000000000000e-1 * t267 + 0.76629248290000000000000000000000000000000000000000e-2 * t270
  t274 = 0.1e1 + 0.1e1 / t272
  t275 = jnp.log(t274)
  t276 = t263 * t275
  t277 = t2 ** 2
  t278 = t277 ** 2
  t279 = t3 ** 2
  t280 = t279 ** 2
  t281 = 0.1e1 / t280
  t282 = t278 * t281
  t283 = t23 * t6
  t284 = f.my_piecewise3(t7, t53, t283)
  t285 = t160 * t156
  t286 = f.my_piecewise3(t157, t53, t285)
  t288 = (t284 + t286 - 0.2e1) * t61
  t290 = 0.3109070e-1 + 0.15971292590000000000000000000000000000000000000000e-2 * t261
  t295 = 0.21948324211500000000000000000000000000000000000000e0 * t264 + 0.48172707847500000000000000000000000000000000000000e-1 * t261 + 0.13082189292500000000000000000000000000000000000000e-1 * t267 + 0.48592432297500000000000000000000000000000000000000e-2 * t270
  t297 = 0.1e1 + 0.1e1 / t295
  t298 = jnp.log(t297)
  t301 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t261
  t306 = 0.17489762330000000000000000000000000000000000000000e0 * t264 + 0.30591463695000000000000000000000000000000000000000e-1 * t261 + 0.37162156485000000000000000000000000000000000000000e-2 * t267 + 0.41939460495000000000000000000000000000000000000000e-2 * t270
  t308 = 0.1e1 + 0.1e1 / t306
  t309 = jnp.log(t308)
  t310 = t301 * t309
  t312 = -t290 * t298 + t276 - 0.58482236226346462072622386637590534819724553404281e0 * t310
  t313 = t288 * t312
  t317 = -t276 + t282 * t313 + 0.58482236226346462072622386637590534819724553404281e0 * t288 * t310 - t93 - t211
  t318 = params.dab[0]
  t319 = 0.6e1 / 0.5e1 * t110
  t322 = 0.1e1 + params.alpha_ab * (t100 + t217 + t104 + t221 - t319)
  t325 = params.dab[1]
  t326 = t100 + t217
  t328 = params.dab[2]
  t329 = t104 + t221 - t319
  t331 = t325 * t326 + t328 * t329
  t332 = t322 ** 2
  t333 = 0.1e1 / t332
  t335 = params.dab[3]
  t336 = t326 ** 2
  t338 = params.dab[4]
  t339 = t338 * t326
  t341 = params.dab[5]
  t342 = t329 ** 2
  t344 = t339 * t329 + t335 * t336 + t341 * t342
  t346 = 0.1e1 / t332 / t322
  t348 = t318 / t322 + t331 * t333 + t344 * t346
  t349 = t317 * t348
  t351 = t2 / t279
  t352 = t4 - t351
  t353 = f.my_piecewise3(t7, 0, t352)
  t356 = 0.1e1 / t17 / t3
  t357 = t356 * t19
  t359 = t16 * t357 * t25
  t360 = 0.11073470983333333333333333333333333333333333333333e-2 * t359
  t361 = 0.1e1 / t283
  t364 = f.my_piecewise3(t7, 0, -t361 * t352 / 0.3e1)
  t366 = t16 * t20 * t364
  t369 = (-t360 + 0.33220412950000000000000000000000000000000000000000e-2 * t366) * t50
  t370 = t47 ** 2
  t372 = t29 / t370
  t373 = 0.1e1 / t30
  t374 = t359 / 0.3e1
  t375 = -t374 + t366
  t376 = t373 * t375
  t378 = 0.18590165886666666666666666666666666666666666666667e-1 * t359
  t380 = t27 ** 0.5e0
  t381 = t380 * t375
  t384 = 0.1e1 / t39 / t3
  t385 = t384 * t41
  t387 = t38 * t385 * t43
  t388 = 0.51086165526666666666666666666666666666666666666667e-2 * t387
  t391 = t38 * t42 * t25 * t364
  t394 = 0.1e1 / t49
  t396 = t372 * (0.11807781499500000000000000000000000000000000000000e0 * t376 - t378 + 0.55770497660000000000000000000000000000000000000000e-1 * t366 + 0.19099794277500000000000000000000000000000000000000e-1 * t381 - t388 + 0.15325849658000000000000000000000000000000000000000e-1 * t391) * t394
  t397 = 0.53237641966666666666666666666666666666666666666667e-3 * t359
  t401 = t69 ** 2
  t403 = t64 / t401
  t405 = 0.16057569282500000000000000000000000000000000000000e-1 * t359
  t408 = 0.32394954865000000000000000000000000000000000000000e-2 * t387
  t411 = 0.1e1 / t71
  t414 = 0.31311127083333333333333333333333333333333333333333e-3 * t359
  t417 = (-t414 + 0.93933381250000000000000000000000000000000000000000e-3 * t366) * t83
  t419 = t80 ** 2
  t420 = 0.1e1 / t419
  t421 = t75 * t420
  t423 = 0.10197154565000000000000000000000000000000000000000e-1 * t359
  t426 = 0.27959640330000000000000000000000000000000000000000e-2 * t387
  t428 = 0.87448811650000000000000000000000000000000000000000e-1 * t376 - t423 + 0.30591463695000000000000000000000000000000000000000e-1 * t366 + 0.55743234727500000000000000000000000000000000000000e-2 * t381 - t426 + 0.83878920990000000000000000000000000000000000000000e-2 * t391
  t429 = 0.1e1 / t82
  t437 = t62 * t75
  t446 = f.my_piecewise3(t8, 0, t353 * t90 / 0.2e1 + t9 * (-t369 + t396 + t62 * (-(-t397 + 0.15971292590000000000000000000000000000000000000000e-2 * t366) * t72 + t403 * (0.10974162105750000000000000000000000000000000000000e0 * t376 - t405 + 0.48172707847500000000000000000000000000000000000000e-1 * t366 + 0.19623283938750000000000000000000000000000000000000e-1 * t381 - t408 + 0.97184864595000000000000000000000000000000000000000e-2 * t391) * t411 + t369 - t396 - 0.58482236226346462072622386637590534819724553404281e0 * t417 + 0.58482236226346462072622386637590534819724553404281e0 * t421 * t428 * t429) + 0.58482236226346462072622386637590534819724553404281e0 * t62 * t417 - 0.58482236226346462072622386637590534819724553404281e0 * t437 * t420 * t428 * t429) / 0.2e1)
  t449 = t94 * t125
  t452 = 0.1e1 / t97 / t95 / r0
  t453 = s0 * t452
  t455 = tau0 * t99
  t457 = -0.8e1 / 0.3e1 * t453 - 0.10e2 / 0.3e1 * t455
  t458 = params.alpha_ss * t457
  t467 = t123 * t144
  t481 = t139 * t121
  t486 = t124 ** 2
  t488 = t142 / t486
  t499 = -t352
  t500 = f.my_piecewise3(t157, 0, t499)
  t503 = t16 * t357 * t162
  t504 = 0.11073470983333333333333333333333333333333333333333e-2 * t503
  t505 = 0.1e1 / t285
  t508 = f.my_piecewise3(t157, 0, -t505 * t499 / 0.3e1)
  t510 = t16 * t20 * t508
  t513 = (-t504 + 0.33220412950000000000000000000000000000000000000000e-2 * t510) * t179
  t514 = t176 ** 2
  t516 = t166 / t514
  t517 = 0.1e1 / t167
  t518 = t503 / 0.3e1
  t519 = -t518 + t510
  t520 = t517 * t519
  t522 = 0.18590165886666666666666666666666666666666666666667e-1 * t503
  t524 = t164 ** 0.5e0
  t525 = t524 * t519
  t528 = t38 * t385 * t172
  t529 = 0.51086165526666666666666666666666666666666666666667e-2 * t528
  t532 = t38 * t42 * t162 * t508
  t535 = 0.1e1 / t178
  t537 = t516 * (0.11807781499500000000000000000000000000000000000000e0 * t520 - t522 + 0.55770497660000000000000000000000000000000000000000e-1 * t510 + 0.19099794277500000000000000000000000000000000000000e-1 * t525 - t529 + 0.15325849658000000000000000000000000000000000000000e-1 * t532) * t535
  t538 = 0.53237641966666666666666666666666666666666666666667e-3 * t503
  t542 = t187 ** 2
  t544 = t182 / t542
  t546 = 0.16057569282500000000000000000000000000000000000000e-1 * t503
  t549 = 0.32394954865000000000000000000000000000000000000000e-2 * t528
  t552 = 0.1e1 / t189
  t555 = 0.31311127083333333333333333333333333333333333333333e-3 * t503
  t558 = (-t555 + 0.93933381250000000000000000000000000000000000000000e-3 * t510) * t201
  t560 = t198 ** 2
  t561 = 0.1e1 / t560
  t562 = t193 * t561
  t564 = 0.10197154565000000000000000000000000000000000000000e-1 * t503
  t567 = 0.27959640330000000000000000000000000000000000000000e-2 * t528
  t569 = 0.87448811650000000000000000000000000000000000000000e-1 * t520 - t564 + 0.30591463695000000000000000000000000000000000000000e-1 * t510 + 0.55743234727500000000000000000000000000000000000000e-2 * t525 - t567 + 0.83878920990000000000000000000000000000000000000000e-2 * t532
  t570 = 0.1e1 / t200
  t578 = t62 * t193
  t587 = f.my_piecewise3(t158, 0, t500 * t208 / 0.2e1 + t159 * (-t513 + t537 + t62 * (-(-t538 + 0.15971292590000000000000000000000000000000000000000e-2 * t510) * t190 + t544 * (0.10974162105750000000000000000000000000000000000000e0 * t520 - t546 + 0.48172707847500000000000000000000000000000000000000e-1 * t510 + 0.19623283938750000000000000000000000000000000000000e-1 * t525 - t549 + 0.97184864595000000000000000000000000000000000000000e-2 * t532) * t552 + t513 - t537 - 0.58482236226346462072622386637590534819724553404281e0 * t558 + 0.58482236226346462072622386637590534819724553404281e0 * t562 * t569 * t570) + 0.58482236226346462072622386637590534819724553404281e0 * t62 * t558 - 0.58482236226346462072622386637590534819724553404281e0 * t578 * t561 * t569 * t570) / 0.2e1)
  t590 = t15 * t356
  t593 = 0.11073470983333333333333333333333333333333333333333e-2 * t13 * t590 * t275
  t594 = t272 ** 2
  t599 = t12 * t15
  t600 = t599 * t356
  t601 = 0.1e1 / t264 * t10 * t600
  t603 = t13 * t590
  t605 = t261 ** 0.5e0
  t607 = t605 * t10 * t600
  t610 = t37 * t14 * t384
  t615 = t263 / t594 * (-0.39359271665000000000000000000000000000000000000000e-1 * t601 - 0.18590165886666666666666666666666666666666666666667e-1 * t603 - 0.63665980925000000000000000000000000000000000000000e-2 * t607 - 0.51086165526666666666666666666666666666666666666667e-2 * t610) / t274
  t619 = 0.4e1 * t277 * t2 * t281 * t313
  t624 = 0.4e1 * t278 / t280 / t3 * t313
  t627 = f.my_piecewise3(t7, 0, 0.4e1 / 0.3e1 * t23 * t352)
  t630 = f.my_piecewise3(t157, 0, 0.4e1 / 0.3e1 * t160 * t499)
  t632 = (t627 + t630) * t61
  t638 = t295 ** 2
  t652 = t306 ** 2
  t653 = 0.1e1 / t652
  t659 = -0.29149603883333333333333333333333333333333333333333e-1 * t601 - 0.10197154565000000000000000000000000000000000000000e-1 * t603 - 0.18581078242500000000000000000000000000000000000000e-2 * t607 - 0.27959640330000000000000000000000000000000000000000e-2 * t610
  t660 = 0.1e1 / t308
  t666 = t282 * t288 * (0.53237641966666666666666666666666666666666666666667e-3 * t13 * t590 * t298 + t290 / t638 * (-0.36580540352500000000000000000000000000000000000000e-1 * t601 - 0.16057569282500000000000000000000000000000000000000e-1 * t603 - 0.65410946462500000000000000000000000000000000000000e-2 * t607 - 0.32394954865000000000000000000000000000000000000000e-2 * t610) / t297 - t593 - t615 + 0.18311447306006545054854346104378990962041954983034e-3 * t13 * t590 * t309 + 0.58482236226346462072622386637590534819724553404281e0 * t301 * t653 * t659 * t660)
  t673 = 0.18311447306006545054854346104378990962041954983034e-3 * t288 * t10 * t599 * t356 * t309
  t678 = 0.58482236226346462072622386637590534819724553404281e0 * t288 * t301 * t653 * t659 * t660
  t679 = t593 + t615 + t619 - t624 + t282 * t632 * t312 + t666 + 0.58482236226346462072622386637590534819724553404281e0 * t632 * t310 - t673 - t678 - t446 - t587
  t681 = t318 * t333
  t682 = params.alpha_ab * t457
  t692 = t331 * t346
  t695 = t335 * t326
  t704 = t341 * t329
  t709 = t332 ** 2
  t711 = t344 / t709
  vrho_0_ = t154 + t259 + t349 + t3 * (t446 * t146 * t153 + t93 * (-t449 * t458 + (-0.8e1 / 0.3e1 * t118 * t452 - 0.10e2 / 0.3e1 * t120 * tau0 * t99) * t125 - 0.2e1 * t467 * t458 + (-0.16e2 / 0.3e1 * t129 / t96 / t130 / t95 - 0.8e1 / 0.3e1 * t136 * t452 * t121 - 0.10e2 / 0.3e1 * t136 * t133 * tau0 - 0.20e2 / 0.3e1 * t481 * t455) * t144 - 0.3e1 * t488 * t458) * t153 + t147 * s0 / t95 * t150 / 0.8e1 + t587 * t251 * t258 + t679 * t348 + t317 * (-t681 * t682 + (-0.8e1 / 0.3e1 * t325 * s0 * t452 - 0.10e2 / 0.3e1 * t328 * tau0 * t99) * t333 - 0.2e1 * t692 * t682 + (-0.16e2 / 0.3e1 * t695 * t453 - 0.8e1 / 0.3e1 * t338 * s0 * t452 * t329 - 0.10e2 / 0.3e1 * t339 * t455 - 0.20e2 / 0.3e1 * t704 * t455) * t346 - 0.3e1 * t711 * t682))
  t718 = -t4 - t351
  t719 = f.my_piecewise3(t7, 0, t718)
  t723 = f.my_piecewise3(t7, 0, -t361 * t718 / 0.3e1)
  t725 = t16 * t20 * t723
  t728 = (-t360 + 0.33220412950000000000000000000000000000000000000000e-2 * t725) * t50
  t729 = -t374 + t725
  t730 = t373 * t729
  t733 = t380 * t729
  t737 = t38 * t42 * t25 * t723
  t741 = t372 * (0.11807781499500000000000000000000000000000000000000e0 * t730 - t378 + 0.55770497660000000000000000000000000000000000000000e-1 * t725 + 0.19099794277500000000000000000000000000000000000000e-1 * t733 - t388 + 0.15325849658000000000000000000000000000000000000000e-1 * t737) * t394
  t754 = (-t414 + 0.93933381250000000000000000000000000000000000000000e-3 * t725) * t83
  t760 = 0.87448811650000000000000000000000000000000000000000e-1 * t730 - t423 + 0.30591463695000000000000000000000000000000000000000e-1 * t725 + 0.55743234727500000000000000000000000000000000000000e-2 * t733 - t426 + 0.83878920990000000000000000000000000000000000000000e-2 * t737
  t776 = f.my_piecewise3(t8, 0, t719 * t90 / 0.2e1 + t9 * (-t728 + t741 + t62 * (-(-t397 + 0.15971292590000000000000000000000000000000000000000e-2 * t725) * t72 + t403 * (0.10974162105750000000000000000000000000000000000000e0 * t730 - t405 + 0.48172707847500000000000000000000000000000000000000e-1 * t725 + 0.19623283938750000000000000000000000000000000000000e-1 * t733 - t408 + 0.97184864595000000000000000000000000000000000000000e-2 * t737) * t411 + t728 - t741 - 0.58482236226346462072622386637590534819724553404281e0 * t754 + 0.58482236226346462072622386637590534819724553404281e0 * t421 * t760 * t429) + 0.58482236226346462072622386637590534819724553404281e0 * t62 * t754 - 0.58482236226346462072622386637590534819724553404281e0 * t437 * t420 * t760 * t429) / 0.2e1)
  t779 = -t718
  t780 = f.my_piecewise3(t157, 0, t779)
  t784 = f.my_piecewise3(t157, 0, -t505 * t779 / 0.3e1)
  t786 = t16 * t20 * t784
  t789 = (-t504 + 0.33220412950000000000000000000000000000000000000000e-2 * t786) * t179
  t790 = -t518 + t786
  t791 = t517 * t790
  t794 = t524 * t790
  t798 = t38 * t42 * t162 * t784
  t802 = t516 * (0.11807781499500000000000000000000000000000000000000e0 * t791 - t522 + 0.55770497660000000000000000000000000000000000000000e-1 * t786 + 0.19099794277500000000000000000000000000000000000000e-1 * t794 - t529 + 0.15325849658000000000000000000000000000000000000000e-1 * t798) * t535
  t815 = (-t555 + 0.93933381250000000000000000000000000000000000000000e-3 * t786) * t201
  t821 = 0.87448811650000000000000000000000000000000000000000e-1 * t791 - t564 + 0.30591463695000000000000000000000000000000000000000e-1 * t786 + 0.55743234727500000000000000000000000000000000000000e-2 * t794 - t567 + 0.83878920990000000000000000000000000000000000000000e-2 * t798
  t837 = f.my_piecewise3(t158, 0, t780 * t208 / 0.2e1 + t159 * (-t789 + t802 + t62 * (-(-t538 + 0.15971292590000000000000000000000000000000000000000e-2 * t786) * t190 + t544 * (0.10974162105750000000000000000000000000000000000000e0 * t791 - t546 + 0.48172707847500000000000000000000000000000000000000e-1 * t786 + 0.19623283938750000000000000000000000000000000000000e-1 * t794 - t549 + 0.97184864595000000000000000000000000000000000000000e-2 * t798) * t552 + t789 - t802 - 0.58482236226346462072622386637590534819724553404281e0 * t815 + 0.58482236226346462072622386637590534819724553404281e0 * t562 * t821 * t570) + 0.58482236226346462072622386637590534819724553404281e0 * t62 * t815 - 0.58482236226346462072622386637590534819724553404281e0 * t578 * t561 * t821 * t570) / 0.2e1)
  t840 = t94 * t233
  t843 = 0.1e1 / t214 / t212 / r1
  t844 = s2 * t843
  t846 = tau1 * t216
  t848 = -0.8e1 / 0.3e1 * t844 - 0.10e2 / 0.3e1 * t846
  t849 = params.alpha_ss * t848
  t858 = t231 * t249
  t872 = t139 * t229
  t877 = t232 ** 2
  t879 = t247 / t877
  t892 = f.my_piecewise3(t7, 0, 0.4e1 / 0.3e1 * t23 * t718)
  t895 = f.my_piecewise3(t157, 0, 0.4e1 / 0.3e1 * t160 * t779)
  t897 = (t892 + t895) * t61
  t902 = t593 + t615 - t619 - t624 + t282 * t897 * t312 + t666 + 0.58482236226346462072622386637590534819724553404281e0 * t897 * t310 - t673 - t678 - t776 - t837
  t904 = params.alpha_ab * t848
  vrho_1_ = t154 + t259 + t349 + t3 * (t776 * t146 * t153 + t837 * t251 * t258 + t211 * (-t840 * t849 + (-0.8e1 / 0.3e1 * t227 * t843 - 0.10e2 / 0.3e1 * t120 * tau1 * t216) * t233 - 0.2e1 * t858 * t849 + (-0.16e2 / 0.3e1 * t236 / t213 / t237 / t212 - 0.8e1 / 0.3e1 * t242 * t843 * t229 - 0.10e2 / 0.3e1 * t242 * t240 * tau1 - 0.20e2 / 0.3e1 * t872 * t846) * t249 - 0.3e1 * t879 * t849) * t258 + t252 * s2 / t212 * t255 / 0.8e1 + t902 * t348 + t317 * (-t681 * t904 + (-0.8e1 / 0.3e1 * t325 * s2 * t843 - 0.10e2 / 0.3e1 * t328 * tau1 * t216) * t333 - 0.2e1 * t692 * t904 + (-0.16e2 / 0.3e1 * t695 * t844 - 0.8e1 / 0.3e1 * t338 * s2 * t843 * t329 - 0.10e2 / 0.3e1 * t339 * t846 - 0.20e2 / 0.3e1 * t704 * t846) * t346 - 0.3e1 * t711 * t904))
  t934 = params.alpha_ss * t99
  t955 = params.alpha_ab * t99
  vsigma_0_ = t3 * (t93 * (-t449 * t934 + t117 * t99 * t125 - 0.2e1 * t467 * t934 + (0.2e1 * t127 * s0 * t133 + t135 * t99 * t121) * t144 - 0.3e1 * t488 * t934) * t153 - t147 * t148 * t150 / 0.8e1 + t317 * (-t681 * t955 + t325 * t99 * t333 - 0.2e1 * t692 * t955 + (t338 * t99 * t329 + 0.2e1 * t695 * t99) * t346 - 0.3e1 * t711 * t955))
  vsigma_1_ = 0.0e0
  t972 = params.alpha_ss * t216
  t993 = params.alpha_ab * t216
  vsigma_2_ = t3 * (t211 * (-t840 * t972 + t117 * t216 * t233 - 0.2e1 * t858 * t972 + (0.2e1 * t127 * s2 * t240 + t135 * t216 * t229) * t249 - 0.3e1 * t879 * t972) * t258 - t252 * t253 * t255 / 0.8e1 + t317 * (-t681 * t993 + t325 * t216 * t333 - 0.2e1 * t692 * t993 + (t338 * t216 * t329 + 0.2e1 * t695 * t216) * t346 - 0.3e1 * t711 * t993))
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t1010 = params.alpha_ss * t102
  t1031 = tau0 ** 2
  t1036 = params.alpha_ab * t102
  vtau_0_ = t3 * (t93 * (-0.2e1 * t449 * t1010 + 0.2e1 * t120 * t102 * t125 - 0.4e1 * t467 * t1010 + (0.2e1 * t136 / t96 / t130 + 0.4e1 * t481 * t102) * t144 - 0.6e1 * t488 * t1010) * t153 + t147 * t149 / t1031 / 0.8e1 + t317 * (-0.2e1 * t681 * t1036 + 0.2e1 * t328 * t102 * t333 - 0.4e1 * t692 * t1036 + (0.2e1 * t339 * t102 + 0.4e1 * t704 * t102) * t346 - 0.6e1 * t711 * t1036))
  t1055 = params.alpha_ss * t219
  t1076 = tau1 ** 2
  t1081 = params.alpha_ab * t219
  vtau_1_ = t3 * (t211 * (-0.2e1 * t840 * t1055 + 0.2e1 * t120 * t219 * t233 - 0.4e1 * t858 * t1055 + (0.2e1 * t242 / t213 / t237 + 0.4e1 * t872 * t219) * t249 - 0.6e1 * t879 * t1055) * t258 + t252 * t254 / t1076 / 0.8e1 + t317 * (-0.2e1 * t681 * t1081 + 0.2e1 * t328 * t219 * t333 - 0.4e1 * t692 * t1081 + (0.2e1 * t339 * t219 + 0.4e1 * t704 * t219) * t346 - 0.6e1 * t711 * t1081))
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_alpha_ab_raw = params.alpha_ab
  if isinstance(params_alpha_ab_raw, (str, bytes, dict)):
    params_alpha_ab = params_alpha_ab_raw
  else:
    try:
      params_alpha_ab_seq = list(params_alpha_ab_raw)
    except TypeError:
      params_alpha_ab = params_alpha_ab_raw
    else:
      params_alpha_ab_seq = np.asarray(params_alpha_ab_seq, dtype=np.float64)
      params_alpha_ab = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_ab_seq))
  params_alpha_ss_raw = params.alpha_ss
  if isinstance(params_alpha_ss_raw, (str, bytes, dict)):
    params_alpha_ss = params_alpha_ss_raw
  else:
    try:
      params_alpha_ss_seq = list(params_alpha_ss_raw)
    except TypeError:
      params_alpha_ss = params_alpha_ss_raw
    else:
      params_alpha_ss_seq = np.asarray(params_alpha_ss_seq, dtype=np.float64)
      params_alpha_ss = np.concatenate((np.array([np.nan], dtype=np.float64), params_alpha_ss_seq))
  params_dab_raw = params.dab
  if isinstance(params_dab_raw, (str, bytes, dict)):
    params_dab = params_dab_raw
  else:
    try:
      params_dab_seq = list(params_dab_raw)
    except TypeError:
      params_dab = params_dab_raw
    else:
      params_dab_seq = np.asarray(params_dab_seq, dtype=np.float64)
      params_dab = np.concatenate((np.array([np.nan], dtype=np.float64), params_dab_seq))
  params_dss_raw = params.dss
  if isinstance(params_dss_raw, (str, bytes, dict)):
    params_dss = params_dss_raw
  else:
    try:
      params_dss_seq = list(params_dss_raw)
    except TypeError:
      params_dss = params_dss_raw
    else:
      params_dss_seq = np.asarray(params_dss_seq, dtype=np.float64)
      params_dss = np.concatenate((np.array([np.nan], dtype=np.float64), params_dss_seq))

  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.0310907, 0.01554535, 0.0168869], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.7099209341613657

  gvt4_gamm = lambda alpha, x, z: 1 + alpha * (x ** 2 + z)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  gtv4 = lambda alpha, dd, x, z: dd[1] / gvt4_gamm(alpha, x, z) + (dd[2] * x ** 2 + dd[3] * z) / gvt4_gamm(alpha, x, z) ** 2 + (dd[4] * x ** 4 + dd[5] * x ** 2 * z + dd[6] * z ** 2) / gvt4_gamm(alpha, x, z) ** 3

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  vsxc_comp = lambda rs, z, spin, xs, ts: +lda_stoll_par(f, params, f_pw, rs, z, 1) * gtv4(params_alpha_ss, params_dss, xs, 2 * (ts - K_FACTOR_C)) * f.Fermi_D(xs, ts)

  vsxc_fperp = lambda rs, z, xs0, xs1, ts0, ts1: +lda_stoll_perp(f, params, f_pw, rs, z) * gtv4(params_alpha_ab, params_dab, jnp.sqrt(xs0 ** 2 + xs1 ** 2), 2 * (ts0 + ts1 - 2 * K_FACTOR_C))

  vsxc_fpar = lambda rs, z, xs0, xs1, ts0, ts1: +vsxc_comp(rs, z, 1, xs0, ts0) + vsxc_comp(rs, -z, -1, xs1, ts1)

  vsxc_f = lambda rs, z, xs0, xs1, ts0, ts1: +vsxc_fpar(rs, z, xs0, xs1, ts0, ts1) + vsxc_fperp(rs, z, xs0, xs1, ts0, ts1)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: vsxc_f(rs, z, xs0, xs1, ts0, ts1)

  t3 = 0.1e1 <= f.p.zeta_threshold
  t4 = r0 / 0.2e1 <= f.p.dens_threshold or t3
  t5 = f.my_piecewise3(t3, f.p.zeta_threshold, 1)
  t6 = 3 ** (0.1e1 / 0.3e1)
  t8 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t9 = t6 * t8
  t10 = 4 ** (0.1e1 / 0.3e1)
  t11 = t10 ** 2
  t12 = t9 * t11
  t13 = r0 ** (0.1e1 / 0.3e1)
  t14 = 0.1e1 / t13
  t15 = 2 ** (0.1e1 / 0.3e1)
  t17 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t19 = f.my_piecewise3(t3, 0.1e1 / t17, 1)
  t21 = t12 * t14 * t15 * t19
  t23 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t21
  t24 = jnp.sqrt(t21)
  t27 = t21 ** 0.15e1
  t29 = t6 ** 2
  t30 = t8 ** 2
  t31 = t29 * t30
  t32 = t31 * t10
  t33 = t13 ** 2
  t34 = 0.1e1 / t33
  t35 = t15 ** 2
  t37 = t19 ** 2
  t39 = t32 * t34 * t35 * t37
  t41 = 0.23615562999000000000000000000000000000000000000000e0 * t24 + 0.55770497660000000000000000000000000000000000000000e-1 * t21 + 0.12733196185000000000000000000000000000000000000000e-1 * t27 + 0.76629248290000000000000000000000000000000000000000e-2 * t39
  t43 = 0.1e1 + 0.1e1 / t41
  t44 = jnp.log(t43)
  t45 = t23 * t44
  t47 = t17 * f.p.zeta_threshold
  t49 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t47, 0.2e1 * t15)
  t51 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t47, 0)
  t55 = 0.1e1 / (0.2e1 * t15 - 0.2e1)
  t56 = (t49 + t51 - 0.2e1) * t55
  t58 = 0.3109070e-1 + 0.15971292590000000000000000000000000000000000000000e-2 * t21
  t63 = 0.21948324211500000000000000000000000000000000000000e0 * t24 + 0.48172707847500000000000000000000000000000000000000e-1 * t21 + 0.13082189292500000000000000000000000000000000000000e-1 * t27 + 0.48592432297500000000000000000000000000000000000000e-2 * t39
  t65 = 0.1e1 + 0.1e1 / t63
  t66 = jnp.log(t65)
  t69 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t21
  t74 = 0.17489762330000000000000000000000000000000000000000e0 * t24 + 0.30591463695000000000000000000000000000000000000000e-1 * t21 + 0.37162156485000000000000000000000000000000000000000e-2 * t27 + 0.41939460495000000000000000000000000000000000000000e-2 * t39
  t76 = 0.1e1 + 0.1e1 / t74
  t77 = jnp.log(t76)
  t78 = t69 * t77
  t87 = f.my_piecewise3(t4, 0, t5 * (-t45 + t56 * (-t58 * t66 + t45 - 0.58482236226346462072622386637590534819724553404281e0 * t78) + 0.58482236226346462072622386637590534819724553404281e0 * t56 * t78) / 0.2e1)
  t88 = params.dss[0]
  t89 = s0 * t35
  t90 = r0 ** 2
  t92 = 0.1e1 / t33 / t90
  t93 = t89 * t92
  t94 = tau0 * t35
  t96 = 0.1e1 / t33 / r0
  t97 = t94 * t96
  t98 = 0.2e1 * t97
  t99 = 6 ** (0.1e1 / 0.3e1)
  t100 = t99 ** 2
  t101 = jnp.pi ** 2
  t102 = t101 ** (0.1e1 / 0.3e1)
  t103 = t102 ** 2
  t104 = t100 * t103
  t105 = 0.3e1 / 0.5e1 * t104
  t108 = 0.1e1 + params.alpha_ss * (t93 + t98 - t105)
  t111 = params.dss[1]
  t112 = t111 * s0
  t113 = t35 * t92
  t115 = params.dss[2]
  t116 = t98 - t105
  t118 = t112 * t113 + t115 * t116
  t119 = t108 ** 2
  t120 = 0.1e1 / t119
  t122 = params.dss[3]
  t123 = s0 ** 2
  t124 = t122 * t123
  t125 = t90 ** 2
  t129 = t15 / t13 / t125 / r0
  t132 = params.dss[4]
  t133 = t132 * s0
  t136 = params.dss[5]
  t137 = t116 ** 2
  t139 = t133 * t113 * t116 + 0.2e1 * t124 * t129 + t136 * t137
  t141 = 0.1e1 / t119 / t108
  t143 = t88 / t108 + t118 * t120 + t139 * t141
  t144 = t87 * t143
  t145 = 0.1e1 / r0
  t146 = s0 * t145
  t147 = 0.1e1 / tau0
  t150 = 0.1e1 - t146 * t147 / 0.8e1
  t154 = t9 * t11 * t14
  t156 = 0.621814e-1 + 0.33220412950000000000000000000000000000000000000000e-2 * t154
  t157 = jnp.sqrt(t154)
  t160 = t154 ** 0.15e1
  t163 = t31 * t10 * t34
  t165 = 0.23615562999000000000000000000000000000000000000000e0 * t157 + 0.55770497660000000000000000000000000000000000000000e-1 * t154 + 0.12733196185000000000000000000000000000000000000000e-1 * t160 + 0.76629248290000000000000000000000000000000000000000e-2 * t163
  t167 = 0.1e1 + 0.1e1 / t165
  t168 = jnp.log(t167)
  t170 = f.my_piecewise3(t3, t47, 1)
  t173 = (0.2e1 * t170 - 0.2e1) * t55
  t175 = 0.337738e-1 + 0.93933381250000000000000000000000000000000000000000e-3 * t154
  t180 = 0.17489762330000000000000000000000000000000000000000e0 * t157 + 0.30591463695000000000000000000000000000000000000000e-1 * t154 + 0.37162156485000000000000000000000000000000000000000e-2 * t160 + 0.41939460495000000000000000000000000000000000000000e-2 * t163
  t182 = 0.1e1 + 0.1e1 / t180
  t183 = jnp.log(t182)
  t188 = -t156 * t168 + 0.58482236226346462072622386637590534819724553404281e0 * t173 * t175 * t183 - 0.2e1 * t87
  t189 = params.dab[0]
  t191 = 0.4e1 * t97
  t192 = 0.6e1 / 0.5e1 * t104
  t195 = 0.1e1 + params.alpha_ab * (0.2e1 * t93 + t191 - t192)
  t198 = params.dab[1]
  t199 = t198 * s0
  t202 = params.dab[2]
  t203 = t191 - t192
  t205 = 0.2e1 * t199 * t113 + t202 * t203
  t206 = t195 ** 2
  t207 = 0.1e1 / t206
  t209 = params.dab[3]
  t210 = t209 * t123
  t213 = params.dab[4]
  t214 = t213 * s0
  t218 = params.dab[5]
  t219 = t203 ** 2
  t221 = 0.2e1 * t214 * t113 * t203 + 0.8e1 * t210 * t129 + t218 * t219
  t223 = 0.1e1 / t206 / t195
  t225 = t189 / t195 + t205 * t207 + t221 * t223
  t228 = 0.1e1 / t13 / r0
  t229 = t228 * t15
  t233 = 0.11073470983333333333333333333333333333333333333333e-2 * t12 * t229 * t19 * t44
  t234 = t41 ** 2
  t240 = t11 * t228
  t241 = t15 * t19
  t242 = t240 * t241
  t243 = 0.1e1 / t24 * t6 * t8 * t242
  t246 = t12 * t229 * t19
  t248 = t21 ** 0.5e0
  t251 = t248 * t6 * t8 * t242
  t253 = t96 * t35
  t255 = t32 * t253 * t37
  t260 = t23 / t234 * (-0.39359271665000000000000000000000000000000000000000e-1 * t243 - 0.18590165886666666666666666666666666666666666666667e-1 * t246 - 0.63665980925000000000000000000000000000000000000000e-2 * t251 - 0.51086165526666666666666666666666666666666666666667e-2 * t255) / t43
  t265 = t63 ** 2
  t280 = t74 ** 2
  t281 = 0.1e1 / t280
  t287 = -0.29149603883333333333333333333333333333333333333333e-1 * t243 - 0.10197154565000000000000000000000000000000000000000e-1 * t246 - 0.18581078242500000000000000000000000000000000000000e-2 * t251 - 0.27959640330000000000000000000000000000000000000000e-2 * t255
  t288 = 0.1e1 / t76
  t307 = f.my_piecewise3(t4, 0, t5 * (t233 + t260 + t56 * (0.53237641966666666666666666666666666666666666666667e-3 * t12 * t229 * t19 * t66 + t58 / t265 * (-0.36580540352500000000000000000000000000000000000000e-1 * t243 - 0.16057569282500000000000000000000000000000000000000e-1 * t246 - 0.65410946462500000000000000000000000000000000000000e-2 * t251 - 0.32394954865000000000000000000000000000000000000000e-2 * t255) / t65 - t233 - t260 + 0.18311447306006545054854346104378990962041954983034e-3 * t12 * t229 * t19 * t77 + 0.58482236226346462072622386637590534819724553404281e0 * t69 * t281 * t287 * t288) - 0.18311447306006545054854346104378990962041954983034e-3 * t56 * t9 * t240 * t241 * t77 - 0.58482236226346462072622386637590534819724553404281e0 * t56 * t69 * t281 * t287 * t288) / 0.2e1)
  t311 = t88 * t120
  t314 = 0.1e1 / t33 / t90 / r0
  t315 = t89 * t314
  t317 = t94 * t92
  t320 = params.alpha_ss * (-0.8e1 / 0.3e1 * t315 - 0.10e2 / 0.3e1 * t317)
  t322 = t35 * t314
  t330 = t118 * t141
  t336 = t15 / t13 / t125 / t90
  t342 = t129 * tau0
  t345 = t136 * t116
  t350 = t119 ** 2
  t352 = t139 / t350
  t367 = t165 ** 2
  t372 = t8 * t11
  t373 = t372 * t228
  t374 = 0.1e1 / t157 * t6 * t373
  t376 = t9 * t240
  t378 = t154 ** 0.5e0
  t380 = t378 * t6 * t373
  t383 = t31 * t10 * t96
  t395 = t180 ** 2
  t410 = t189 * t207
  t414 = params.alpha_ab * (-0.16e2 / 0.3e1 * t315 - 0.20e2 / 0.3e1 * t317)
  t423 = t205 * t223
  t433 = t218 * t203
  t438 = t206 ** 2
  t440 = t221 / t438
  vrho_0_ = 0.2e1 * t144 * t150 + t188 * t225 + r0 * (0.2e1 * t307 * t143 * t150 + 0.2e1 * t87 * (-t311 * t320 + (-0.8e1 / 0.3e1 * t112 * t322 - 0.10e2 / 0.3e1 * t115 * tau0 * t113) * t120 - 0.2e1 * t330 * t320 + (-0.32e2 / 0.3e1 * t124 * t336 - 0.8e1 / 0.3e1 * t133 * t322 * t116 - 0.20e2 / 0.3e1 * t133 * t342 - 0.20e2 / 0.3e1 * t345 * t317) * t141 - 0.3e1 * t352 * t320) * t150 + t144 * s0 / t90 * t147 / 0.4e1 + (0.11073470983333333333333333333333333333333333333333e-2 * t9 * t240 * t168 + t156 / t367 * (-0.39359271665000000000000000000000000000000000000000e-1 * t374 - 0.18590165886666666666666666666666666666666666666667e-1 * t376 - 0.63665980925000000000000000000000000000000000000000e-2 * t380 - 0.51086165526666666666666666666666666666666666666667e-2 * t383) / t167 - 0.18311447306006545054854346104378990962041954983034e-3 * t173 * t6 * t372 * t228 * t183 - 0.58482236226346462072622386637590534819724553404281e0 * t173 * t175 / t395 * (-0.29149603883333333333333333333333333333333333333333e-1 * t374 - 0.10197154565000000000000000000000000000000000000000e-1 * t376 - 0.18581078242500000000000000000000000000000000000000e-2 * t380 - 0.27959640330000000000000000000000000000000000000000e-2 * t383) / t182 - 0.2e1 * t307) * t225 + t188 * (-t410 * t414 + (-0.16e2 / 0.3e1 * t199 * t322 - 0.20e2 / 0.3e1 * t202 * tau0 * t113) * t207 - 0.2e1 * t423 * t414 + (-0.128e3 / 0.3e1 * t210 * t336 - 0.16e2 / 0.3e1 * t214 * t322 * t203 - 0.80e2 / 0.3e1 * t214 * t342 - 0.40e2 / 0.3e1 * t433 * t317) * t223 - 0.3e1 * t440 * t414))
  t447 = params.alpha_ss * t35
  t448 = t447 * t92
  t472 = params.alpha_ab * t35
  t473 = t472 * t92
  vsigma_0_ = r0 * (0.2e1 * t87 * (-t311 * t448 + t111 * t35 * t92 * t120 - 0.2e1 * t330 * t448 + (t132 * t35 * t92 * t116 + 0.4e1 * t122 * s0 * t129) * t141 - 0.3e1 * t352 * t448) * t150 - t144 * t145 * t147 / 0.4e1 + t188 * (-0.2e1 * t410 * t473 + 0.2e1 * t198 * t35 * t92 * t207 - 0.4e1 * t423 * t473 + (0.2e1 * t213 * t35 * t92 * t203 + 0.16e2 * t209 * s0 * t129) * t223 - 0.6e1 * t440 * t473))
  vlapl_0_ = 0.0e0
  t496 = t447 * t96
  t507 = t15 / t13 / t125
  t519 = tau0 ** 2
  t524 = t472 * t96
  vtau_0_ = r0 * (0.2e1 * t87 * (-0.2e1 * t311 * t496 + 0.2e1 * t115 * t35 * t96 * t120 - 0.4e1 * t330 * t496 + (0.4e1 * t133 * t507 + 0.4e1 * t345 * t253) * t141 - 0.6e1 * t352 * t496) * t150 + t144 * t146 / t519 / 0.4e1 + t188 * (-0.4e1 * t410 * t524 + 0.4e1 * t202 * t35 * t96 * t207 - 0.8e1 * t423 * t524 + (0.16e2 * t214 * t507 + 0.8e1 * t433 * t253) * t223 - 0.12e2 * t440 * t524))
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t3 = 0.1e1 <= f.p.zeta_threshold
  t4 = r0 / 0.2e1 <= f.p.dens_threshold or t3
  t5 = f.my_piecewise3(t3, f.p.zeta_threshold, 1)
  t6 = 3 ** (0.1e1 / 0.3e1)
  t8 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t9 = t6 * t8
  t10 = 4 ** (0.1e1 / 0.3e1)
  t11 = t10 ** 2
  t12 = t9 * t11
  t13 = r0 ** (0.1e1 / 0.3e1)
  t15 = 0.1e1 / t13 / r0
  t16 = 2 ** (0.1e1 / 0.3e1)
  t17 = t15 * t16
  t18 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t20 = f.my_piecewise3(t3, 0.1e1 / t18, 1)
  t21 = 0.1e1 / t13
  t24 = t12 * t21 * t16 * t20
  t25 = jnp.sqrt(t24)
  t28 = t24 ** 0.15e1
  t30 = t6 ** 2
  t31 = t8 ** 2
  t32 = t30 * t31
  t33 = t32 * t10
  t34 = t13 ** 2
  t35 = 0.1e1 / t34
  t36 = t16 ** 2
  t38 = t20 ** 2
  t40 = t33 * t35 * t36 * t38
  t42 = 0.37978500000000000000000000000000000000000000000000e1 * t25 + 0.89690000000000000000000000000000000000000000000000e0 * t24 + 0.20477500000000000000000000000000000000000000000000e0 * t28 + 0.12323500000000000000000000000000000000000000000000e0 * t40
  t45 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t42
  t46 = jnp.log(t45)
  t47 = t20 * t46
  t50 = 0.11073470983333333333333333333333333333333333333333e-2 * t12 * t17 * t47
  t52 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t24
  t53 = t42 ** 2
  t54 = 0.1e1 / t53
  t55 = t52 * t54
  t58 = 0.1e1 / t25 * t6 * t8
  t59 = t11 * t15
  t60 = t16 * t20
  t61 = t59 * t60
  t62 = t58 * t61
  t64 = t17 * t20
  t65 = t12 * t64
  t67 = t24 ** 0.5e0
  t69 = t67 * t6 * t8
  t70 = t69 * t61
  t73 = 0.1e1 / t34 / r0
  t76 = t33 * t73 * t36 * t38
  t78 = -0.63297500000000000000000000000000000000000000000000e0 * t62 - 0.29896666666666666666666666666666666666666666666667e0 * t65 - 0.10238750000000000000000000000000000000000000000000e0 * t70 - 0.82156666666666666666666666666666666666666666666667e-1 * t76
  t79 = 0.1e1 / t45
  t82 = 0.10000000000000000000000000000000000000000000000000e1 * t55 * t78 * t79
  t84 = t18 * f.p.zeta_threshold
  t86 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t84, 0.2e1 * t16)
  t88 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t84, 0)
  t92 = 0.1e1 / (0.2e1 * t16 - 0.2e1)
  t93 = (t86 + t88 - 0.2e1) * t92
  t98 = 0.70594500000000000000000000000000000000000000000000e1 * t25 + 0.15494250000000000000000000000000000000000000000000e1 * t24 + 0.42077500000000000000000000000000000000000000000000e0 * t28 + 0.15629250000000000000000000000000000000000000000000e0 * t40
  t101 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t98
  t102 = jnp.log(t101)
  t103 = t20 * t102
  t108 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t24
  t109 = t98 ** 2
  t110 = 0.1e1 / t109
  t111 = t108 * t110
  t116 = -0.11765750000000000000000000000000000000000000000000e1 * t62 - 0.51647500000000000000000000000000000000000000000000e0 * t65 - 0.21038750000000000000000000000000000000000000000000e0 * t70 - 0.10419500000000000000000000000000000000000000000000e0 * t76
  t117 = 0.1e1 / t101
  t125 = 0.51785000000000000000000000000000000000000000000000e1 * t25 + 0.90577500000000000000000000000000000000000000000000e0 * t24 + 0.11003250000000000000000000000000000000000000000000e0 * t28 + 0.12417750000000000000000000000000000000000000000000e0 * t40
  t128 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t125
  t129 = jnp.log(t128)
  t130 = t20 * t129
  t135 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t24
  t136 = t125 ** 2
  t137 = 0.1e1 / t136
  t138 = t135 * t137
  t143 = -0.86308333333333333333333333333333333333333333333334e0 * t62 - 0.30192500000000000000000000000000000000000000000000e0 * t65 - 0.55016250000000000000000000000000000000000000000000e-1 * t70 - 0.82785000000000000000000000000000000000000000000000e-1 * t76
  t144 = 0.1e1 / t128
  t150 = t93 * t9
  t151 = t60 * t129
  t155 = t93 * t135
  t157 = t137 * t143 * t144
  t163 = f.my_piecewise3(t4, 0, t5 * (t50 + t82 + t93 * (0.53237641966666666666666666666666666666666666666666e-3 * t12 * t17 * t103 + 0.10000000000000000000000000000000000000000000000000e1 * t111 * t116 * t117 - t50 - t82 + 0.18311447306006545054854346104378990962041954983034e-3 * t12 * t17 * t130 + 0.58482236226346462072622386637590534819724553404280e0 * t138 * t143 * t144) - 0.18311447306006545054854346104378990962041954983034e-3 * t150 * t59 * t151 - 0.58482236226346462072622386637590534819724553404280e0 * t155 * t157) / 0.2e1)
  t164 = params.dss[0]
  t165 = s0 * t36
  t166 = r0 ** 2
  t168 = 0.1e1 / t34 / t166
  t169 = t165 * t168
  t170 = tau0 * t36
  t171 = t170 * t73
  t172 = 0.2e1 * t171
  t173 = 6 ** (0.1e1 / 0.3e1)
  t174 = t173 ** 2
  t175 = jnp.pi ** 2
  t176 = t175 ** (0.1e1 / 0.3e1)
  t177 = t176 ** 2
  t178 = t174 * t177
  t179 = 0.3e1 / 0.5e1 * t178
  t182 = 0.1e1 + params.alpha_ss * (t169 + t172 - t179)
  t186 = params.dss[1] * s0
  t187 = t36 * t168
  t189 = params.dss[2]
  t190 = t172 - t179
  t192 = t186 * t187 + t189 * t190
  t193 = t182 ** 2
  t194 = 0.1e1 / t193
  t197 = s0 ** 2
  t198 = params.dss[3] * t197
  t199 = t166 ** 2
  t203 = t16 / t13 / t199 / r0
  t207 = params.dss[4] * s0
  t210 = params.dss[5]
  t211 = t190 ** 2
  t213 = t207 * t187 * t190 + 0.2e1 * t198 * t203 + t210 * t211
  t215 = 0.1e1 / t193 / t182
  t217 = t164 / t182 + t192 * t194 + t213 * t215
  t218 = t163 * t217
  t221 = 0.1e1 / tau0
  t224 = 0.1e1 - s0 / r0 * t221 / 0.8e1
  t228 = 0.621814e-1 * t52 * t46
  t231 = t135 * t129
  t240 = f.my_piecewise3(t4, 0, t5 * (-t228 + t93 * (-0.3109070e-1 * t108 * t102 + t228 - 0.19751673498613801407483339618206552048944131217655e-1 * t231) + 0.19751673498613801407483339618206552048944131217655e-1 * t93 * t231) / 0.2e1)
  t241 = t164 * t194
  t242 = t166 * r0
  t244 = 0.1e1 / t34 / t242
  t245 = t165 * t244
  t247 = t170 * t168
  t249 = -0.8e1 / 0.3e1 * t245 - 0.10e2 / 0.3e1 * t247
  t250 = params.alpha_ss * t249
  t252 = t36 * t244
  t255 = t189 * tau0
  t258 = -0.8e1 / 0.3e1 * t186 * t252 - 0.10e2 / 0.3e1 * t255 * t187
  t260 = t192 * t215
  t266 = t16 / t13 / t199 / t166
  t272 = t203 * tau0
  t275 = t210 * t190
  t278 = -0.32e2 / 0.3e1 * t198 * t266 - 0.8e1 / 0.3e1 * t207 * t252 * t190 - 0.20e2 / 0.3e1 * t207 * t272 - 0.20e2 / 0.3e1 * t275 * t247
  t280 = t193 ** 2
  t281 = 0.1e1 / t280
  t282 = t213 * t281
  t285 = t258 * t194 + t278 * t215 - t241 * t250 - 0.2e1 * t260 * t250 - 0.3e1 * t282 * t250
  t286 = t240 * t285
  t289 = t240 * t217
  t292 = s0 / t166 * t221
  t296 = t9 * t11 * t21
  t297 = jnp.sqrt(t296)
  t300 = t296 ** 0.15e1
  t303 = t32 * t10 * t35
  t305 = 0.37978500000000000000000000000000000000000000000000e1 * t297 + 0.89690000000000000000000000000000000000000000000000e0 * t296 + 0.20477500000000000000000000000000000000000000000000e0 * t300 + 0.12323500000000000000000000000000000000000000000000e0 * t303
  t308 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t305
  t309 = jnp.log(t308)
  t314 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t296
  t315 = t305 ** 2
  t316 = 0.1e1 / t315
  t317 = t314 * t316
  t319 = 0.1e1 / t297 * t6
  t320 = t8 * t11
  t321 = t320 * t15
  t322 = t319 * t321
  t324 = t9 * t59
  t326 = t296 ** 0.5e0
  t327 = t326 * t6
  t328 = t327 * t321
  t331 = t32 * t10 * t73
  t333 = -0.63297500000000000000000000000000000000000000000000e0 * t322 - 0.29896666666666666666666666666666666666666666666667e0 * t324 - 0.10238750000000000000000000000000000000000000000000e0 * t328 - 0.82156666666666666666666666666666666666666666666667e-1 * t331
  t334 = 0.1e1 / t308
  t335 = t333 * t334
  t338 = f.my_piecewise3(t3, t84, 1)
  t341 = (0.2e1 * t338 - 0.2e1) * t92
  t342 = t341 * t6
  t347 = 0.51785000000000000000000000000000000000000000000000e1 * t297 + 0.90577500000000000000000000000000000000000000000000e0 * t296 + 0.11003250000000000000000000000000000000000000000000e0 * t300 + 0.12417750000000000000000000000000000000000000000000e0 * t303
  t350 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t347
  t351 = jnp.log(t350)
  t357 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t296
  t358 = t341 * t357
  t359 = t347 ** 2
  t360 = 0.1e1 / t359
  t365 = -0.86308333333333333333333333333333333333333333333334e0 * t322 - 0.30192500000000000000000000000000000000000000000000e0 * t324 - 0.55016250000000000000000000000000000000000000000000e-1 * t328 - 0.82785000000000000000000000000000000000000000000000e-1 * t331
  t367 = 0.1e1 / t350
  t368 = t360 * t365 * t367
  t372 = 0.11073470983333333333333333333333333333333333333333e-2 * t9 * t59 * t309 + 0.10000000000000000000000000000000000000000000000000e1 * t317 * t335 - 0.18311447306006545054854346104378990962041954983034e-3 * t342 * t320 * t15 * t351 - 0.58482236226346462072622386637590534819724553404280e0 * t358 * t368 - 0.2e1 * t163
  t373 = params.dab[0]
  t375 = 0.4e1 * t171
  t376 = 0.6e1 / 0.5e1 * t178
  t379 = 0.1e1 + params.alpha_ab * (0.2e1 * t169 + t375 - t376)
  t383 = params.dab[1] * s0
  t386 = params.dab[2]
  t387 = t375 - t376
  t389 = 0.2e1 * t383 * t187 + t386 * t387
  t390 = t379 ** 2
  t391 = 0.1e1 / t390
  t394 = params.dab[3] * t197
  t398 = params.dab[4] * s0
  t402 = params.dab[5]
  t403 = t387 ** 2
  t405 = 0.2e1 * t398 * t187 * t387 + 0.8e1 * t394 * t203 + t402 * t403
  t407 = 0.1e1 / t390 / t379
  t409 = t373 / t379 + t389 * t391 + t405 * t407
  t418 = -0.621814e-1 * t314 * t309 + 0.19751673498613801407483339618206552048944131217655e-1 * t341 * t357 * t351 - 0.2e1 * t240
  t419 = t373 * t391
  t422 = -0.16e2 / 0.3e1 * t245 - 0.20e2 / 0.3e1 * t247
  t423 = params.alpha_ab * t422
  t427 = t386 * tau0
  t430 = -0.16e2 / 0.3e1 * t383 * t252 - 0.20e2 / 0.3e1 * t427 * t187
  t432 = t389 * t407
  t442 = t402 * t387
  t445 = -0.128e3 / 0.3e1 * t394 * t266 - 0.16e2 / 0.3e1 * t398 * t252 * t387 - 0.80e2 / 0.3e1 * t398 * t272 - 0.40e2 / 0.3e1 * t442 * t247
  t447 = t390 ** 2
  t448 = 0.1e1 / t447
  t449 = t405 * t448
  t452 = t430 * t391 + t445 * t407 - t419 * t423 - 0.2e1 * t432 * t423 - 0.3e1 * t449 * t423
  t456 = 0.1e1 / t13 / t166
  t457 = t456 * t16
  t460 = 0.14764627977777777777777777777777777777777777777777e-2 * t12 * t457 * t47
  t465 = 0.35616666666666666666666666666666666666666666666666e-1 * t324 * t60 * t54 * t78 * t79
  t469 = t78 ** 2
  t472 = 0.20000000000000000000000000000000000000000000000000e1 * t52 / t53 / t42 * t469 * t79
  t477 = t10 * t168
  t479 = t477 * t36 * t38
  t480 = 0.1e1 / t25 / t24 * t30 * t31 * t479
  t482 = t11 * t456
  t483 = t482 * t60
  t484 = t58 * t483
  t487 = t12 * t457 * t20
  t489 = t24 ** (-0.5e0)
  t492 = t489 * t30 * t31 * t479
  t494 = t69 * t483
  t497 = t33 * t187 * t38
  t502 = 0.10000000000000000000000000000000000000000000000000e1 * t55 * (-0.42198333333333333333333333333333333333333333333333e0 * t480 + 0.84396666666666666666666666666666666666666666666666e0 * t484 + 0.39862222222222222222222222222222222222222222222223e0 * t487 + 0.68258333333333333333333333333333333333333333333333e-1 * t492 + 0.13651666666666666666666666666666666666666666666667e0 * t494 + 0.13692777777777777777777777777777777777777777777778e0 * t497) * t79
  t503 = t53 ** 2
  t506 = t45 ** 2
  t510 = 0.16081979498692535066756296899072713062105388428051e2 * t52 / t503 * t469 / t506
  t522 = t116 ** 2
  t536 = t109 ** 2
  t539 = t101 ** 2
  t551 = 0.1e1 / t136 / t125
  t553 = t143 ** 2
  t563 = -0.57538888888888888888888888888888888888888888888889e0 * t480 + 0.11507777777777777777777777777777777777777777777778e1 * t484 + 0.40256666666666666666666666666666666666666666666667e0 * t487 + 0.36677500000000000000000000000000000000000000000000e-1 * t492 + 0.73355000000000000000000000000000000000000000000000e-1 * t494 + 0.13797500000000000000000000000000000000000000000000e0 * t497
  t567 = t136 ** 2
  t568 = 0.1e1 / t567
  t570 = t128 ** 2
  t571 = 0.1e1 / t570
  t575 = -0.70983522622222222222222222222222222222222222222221e-3 * t12 * t457 * t103 - 0.34246666666666666666666666666666666666666666666666e-1 * t324 * t60 * t110 * t116 * t117 - 0.20000000000000000000000000000000000000000000000000e1 * t108 / t109 / t98 * t522 * t117 + 0.10000000000000000000000000000000000000000000000000e1 * t111 * (-0.78438333333333333333333333333333333333333333333333e0 * t480 + 0.15687666666666666666666666666666666666666666666667e1 * t484 + 0.68863333333333333333333333333333333333333333333333e0 * t487 + 0.14025833333333333333333333333333333333333333333333e0 * t492 + 0.28051666666666666666666666666666666666666666666667e0 * t494 + 0.17365833333333333333333333333333333333333333333333e0 * t497) * t117 + 0.32163958997385070133512593798145426124210776856102e2 * t108 / t536 * t522 / t539 + t460 + t465 + t472 - t502 - t510 - 0.24415263074675393406472461472505321282722606644045e-3 * t12 * t457 * t130 - 0.10843581300301739842632067522386578331157260943710e-1 * t324 * t60 * t157 - 0.11696447245269292414524477327518106963944910680856e1 * t135 * t551 * t553 * t144 + 0.58482236226346462072622386637590534819724553404280e0 * t138 * t563 * t144 + 0.17315859105681463759666483083807725165579399831905e2 * t135 * t568 * t553 * t571
  t596 = -t460 - t465 - t472 + t502 + t510 + t93 * t575 + 0.24415263074675393406472461472505321282722606644045e-3 * t150 * t482 * t151 + 0.10843581300301739842632067522386578331157260943710e-1 * t93 * t12 * t64 * t157 + 0.11696447245269292414524477327518106963944910680856e1 * t155 * t551 * t553 * t144 - 0.58482236226346462072622386637590534819724553404280e0 * t155 * t137 * t563 * t144 - 0.17315859105681463759666483083807725165579399831905e2 * t155 * t568 * t553 * t571
  t599 = f.my_piecewise3(t4, 0, t5 * t596 / 0.2e1)
  t609 = params.alpha_ss ** 2
  t610 = t249 ** 2
  t611 = t609 * t610
  t615 = 0.1e1 / t34 / t199
  t616 = t165 * t615
  t618 = t170 * t244
  t621 = params.alpha_ss * (0.88e2 / 0.9e1 * t616 + 0.80e2 / 0.9e1 * t618)
  t623 = t36 * t615
  t641 = t16 / t13 / t199 / t242
  t647 = t266 * tau0
  t650 = tau0 ** 2
  t689 = t333 ** 2
  t697 = t31 * t10 * t168
  t698 = 0.1e1 / t297 / t296 * t30 * t697
  t700 = t320 * t456
  t701 = t319 * t700
  t703 = t9 * t482
  t705 = t296 ** (-0.5e0)
  t707 = t705 * t30 * t697
  t709 = t327 * t700
  t711 = t32 * t477
  t717 = t315 ** 2
  t720 = t308 ** 2
  t735 = t365 ** 2
  t751 = t359 ** 2
  t754 = t350 ** 2
  t760 = -0.14764627977777777777777777777777777777777777777777e-2 * t9 * t482 * t309 - 0.35616666666666666666666666666666666666666666666666e-1 * t12 * t15 * t316 * t335 - 0.20000000000000000000000000000000000000000000000000e1 * t314 / t315 / t305 * t689 * t334 + 0.10000000000000000000000000000000000000000000000000e1 * t317 * (-0.42198333333333333333333333333333333333333333333333e0 * t698 + 0.84396666666666666666666666666666666666666666666666e0 * t701 + 0.39862222222222222222222222222222222222222222222223e0 * t703 + 0.68258333333333333333333333333333333333333333333333e-1 * t707 + 0.13651666666666666666666666666666666666666666666667e0 * t709 + 0.13692777777777777777777777777777777777777777777778e0 * t711) * t334 + 0.16081979498692535066756296899072713062105388428051e2 * t314 / t717 * t689 / t720 + 0.24415263074675393406472461472505321282722606644045e-3 * t342 * t320 * t456 * t351 + 0.10843581300301739842632067522386578331157260943710e-1 * t341 * t9 * t59 * t368 + 0.11696447245269292414524477327518106963944910680856e1 * t358 / t359 / t347 * t735 * t367 - 0.58482236226346462072622386637590534819724553404280e0 * t358 * t360 * (-0.57538888888888888888888888888888888888888888888889e0 * t698 + 0.11507777777777777777777777777777777777777777777778e1 * t701 + 0.40256666666666666666666666666666666666666666666667e0 * t703 + 0.36677500000000000000000000000000000000000000000000e-1 * t707 + 0.73355000000000000000000000000000000000000000000000e-1 * t709 + 0.13797500000000000000000000000000000000000000000000e0 * t711) * t367 - 0.17315859105681463759666483083807725165579399831905e2 * t358 / t751 * t735 / t754 - 0.2e1 * t599
  t765 = params.alpha_ab ** 2
  t766 = t422 ** 2
  t767 = t765 * t766
  t773 = params.alpha_ab * (0.176e3 / 0.9e1 * t616 + 0.160e3 / 0.9e1 * t618)
  v2rho2_0_ = 0.4e1 * t218 * t224 + 0.4e1 * t286 * t224 + t289 * t292 / 0.2e1 + 0.2e1 * t372 * t409 + 0.2e1 * t418 * t452 + r0 * (0.2e1 * t599 * t217 * t224 + 0.4e1 * t163 * t285 * t224 + t218 * t292 / 0.2e1 + 0.2e1 * t240 * (0.2e1 * t164 * t215 * t611 - t241 * t621 + (0.88e2 / 0.9e1 * t186 * t623 + 0.80e2 / 0.9e1 * t255 * t252) * t194 - 0.4e1 * t258 * t215 * t250 + 0.6e1 * t192 * t281 * t611 - 0.2e1 * t260 * t621 + (0.608e3 / 0.9e1 * t198 * t641 + 0.88e2 / 0.9e1 * t207 * t623 * t190 + 0.160e3 / 0.3e1 * t207 * t647 + 0.400e3 / 0.9e1 * t210 * t650 * t203 + 0.160e3 / 0.9e1 * t275 * t618) * t215 - 0.6e1 * t278 * t281 * t250 + 0.12e2 * t213 / t280 / t182 * t611 - 0.3e1 * t282 * t621) * t224 + t286 * t292 / 0.2e1 - t289 * s0 / t242 * t221 / 0.2e1 + t760 * t409 + 0.2e1 * t372 * t452 + t418 * (0.2e1 * t373 * t407 * t767 - t419 * t773 + (0.176e3 / 0.9e1 * t383 * t623 + 0.160e3 / 0.9e1 * t427 * t252) * t391 - 0.4e1 * t430 * t407 * t423 + 0.6e1 * t389 * t448 * t767 - 0.2e1 * t432 * t773 + (0.2432e4 / 0.9e1 * t394 * t641 + 0.176e3 / 0.9e1 * t398 * t623 * t387 + 0.640e3 / 0.3e1 * t398 * t647 + 0.1600e4 / 0.9e1 * t402 * t650 * t203 + 0.320e3 / 0.9e1 * t442 * t618) * t407 - 0.6e1 * t445 * t448 * t423 + 0.12e2 * t405 / t447 / t379 * t767 - 0.3e1 * t449 * t773))
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t3 = 0.1e1 <= f.p.zeta_threshold
  t4 = r0 / 0.2e1 <= f.p.dens_threshold or t3
  t5 = f.my_piecewise3(t3, f.p.zeta_threshold, 1)
  t6 = 3 ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 / jnp.pi
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = t6 * t8
  t10 = 4 ** (0.1e1 / 0.3e1)
  t11 = t10 ** 2
  t12 = t9 * t11
  t13 = r0 ** 2
  t14 = r0 ** (0.1e1 / 0.3e1)
  t16 = 0.1e1 / t14 / t13
  t17 = 2 ** (0.1e1 / 0.3e1)
  t18 = t16 * t17
  t19 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t21 = f.my_piecewise3(t3, 0.1e1 / t19, 1)
  t22 = 0.1e1 / t14
  t25 = t12 * t22 * t17 * t21
  t26 = jnp.sqrt(t25)
  t29 = t25 ** 0.15e1
  t31 = t6 ** 2
  t32 = t8 ** 2
  t33 = t31 * t32
  t34 = t33 * t10
  t35 = t14 ** 2
  t36 = 0.1e1 / t35
  t37 = t17 ** 2
  t39 = t21 ** 2
  t41 = t34 * t36 * t37 * t39
  t43 = 0.37978500000000000000000000000000000000000000000000e1 * t26 + 0.89690000000000000000000000000000000000000000000000e0 * t25 + 0.20477500000000000000000000000000000000000000000000e0 * t29 + 0.12323500000000000000000000000000000000000000000000e0 * t41
  t46 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t43
  t47 = jnp.log(t46)
  t48 = t21 * t47
  t51 = 0.14764627977777777777777777777777777777777777777777e-2 * t12 * t18 * t48
  t53 = 0.1e1 / t14 / r0
  t54 = t11 * t53
  t55 = t9 * t54
  t56 = t17 * t21
  t57 = t43 ** 2
  t58 = 0.1e1 / t57
  t61 = 0.1e1 / t26 * t6 * t8
  t62 = t54 * t56
  t63 = t61 * t62
  t65 = t53 * t17
  t66 = t65 * t21
  t67 = t12 * t66
  t69 = t25 ** 0.5e0
  t71 = t69 * t6 * t8
  t72 = t71 * t62
  t75 = 0.1e1 / t35 / r0
  t78 = t34 * t75 * t37 * t39
  t80 = -0.63297500000000000000000000000000000000000000000000e0 * t63 - 0.29896666666666666666666666666666666666666666666667e0 * t67 - 0.10238750000000000000000000000000000000000000000000e0 * t72 - 0.82156666666666666666666666666666666666666666666667e-1 * t78
  t82 = 0.1e1 / t46
  t84 = t56 * t58 * t80 * t82
  t86 = 0.35616666666666666666666666666666666666666666666666e-1 * t55 * t84
  t88 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t25
  t90 = 0.1e1 / t57 / t43
  t91 = t88 * t90
  t92 = t80 ** 2
  t95 = 0.20000000000000000000000000000000000000000000000000e1 * t91 * t92 * t82
  t96 = t88 * t58
  t100 = 0.1e1 / t26 / t25 * t31 * t32
  t102 = 0.1e1 / t35 / t13
  t103 = t10 * t102
  t104 = t37 * t39
  t105 = t103 * t104
  t106 = t100 * t105
  t108 = t11 * t16
  t109 = t108 * t56
  t110 = t61 * t109
  t112 = t18 * t21
  t113 = t12 * t112
  t115 = t25 ** (-0.5e0)
  t117 = t115 * t31 * t32
  t118 = t117 * t105
  t120 = t71 * t109
  t122 = t102 * t37
  t124 = t34 * t122 * t39
  t126 = -0.42198333333333333333333333333333333333333333333333e0 * t106 + 0.84396666666666666666666666666666666666666666666666e0 * t110 + 0.39862222222222222222222222222222222222222222222223e0 * t113 + 0.68258333333333333333333333333333333333333333333333e-1 * t118 + 0.13651666666666666666666666666666666666666666666667e0 * t120 + 0.13692777777777777777777777777777777777777777777778e0 * t124
  t129 = 0.10000000000000000000000000000000000000000000000000e1 * t96 * t126 * t82
  t130 = t57 ** 2
  t131 = 0.1e1 / t130
  t132 = t88 * t131
  t133 = t46 ** 2
  t134 = 0.1e1 / t133
  t137 = 0.16081979498692535066756296899072713062105388428051e2 * t132 * t92 * t134
  t139 = t19 * f.p.zeta_threshold
  t141 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t139, 0.2e1 * t17)
  t143 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t139, 0)
  t147 = 0.1e1 / (0.2e1 * t17 - 0.2e1)
  t148 = (t141 + t143 - 0.2e1) * t147
  t153 = 0.70594500000000000000000000000000000000000000000000e1 * t26 + 0.15494250000000000000000000000000000000000000000000e1 * t25 + 0.42077500000000000000000000000000000000000000000000e0 * t29 + 0.15629250000000000000000000000000000000000000000000e0 * t41
  t156 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t153
  t157 = jnp.log(t156)
  t158 = t21 * t157
  t162 = t153 ** 2
  t163 = 0.1e1 / t162
  t168 = -0.11765750000000000000000000000000000000000000000000e1 * t63 - 0.51647500000000000000000000000000000000000000000000e0 * t67 - 0.21038750000000000000000000000000000000000000000000e0 * t72 - 0.10419500000000000000000000000000000000000000000000e0 * t78
  t170 = 0.1e1 / t156
  t172 = t56 * t163 * t168 * t170
  t176 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t25
  t178 = 0.1e1 / t162 / t153
  t179 = t176 * t178
  t180 = t168 ** 2
  t184 = t176 * t163
  t191 = -0.78438333333333333333333333333333333333333333333333e0 * t106 + 0.15687666666666666666666666666666666666666666666667e1 * t110 + 0.68863333333333333333333333333333333333333333333333e0 * t113 + 0.14025833333333333333333333333333333333333333333333e0 * t118 + 0.28051666666666666666666666666666666666666666666667e0 * t120 + 0.17365833333333333333333333333333333333333333333333e0 * t124
  t195 = t162 ** 2
  t196 = 0.1e1 / t195
  t197 = t176 * t196
  t198 = t156 ** 2
  t199 = 0.1e1 / t198
  t207 = 0.51785000000000000000000000000000000000000000000000e1 * t26 + 0.90577500000000000000000000000000000000000000000000e0 * t25 + 0.11003250000000000000000000000000000000000000000000e0 * t29 + 0.12417750000000000000000000000000000000000000000000e0 * t41
  t210 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t207
  t211 = jnp.log(t210)
  t212 = t21 * t211
  t216 = t207 ** 2
  t217 = 0.1e1 / t216
  t222 = -0.86308333333333333333333333333333333333333333333334e0 * t63 - 0.30192500000000000000000000000000000000000000000000e0 * t67 - 0.55016250000000000000000000000000000000000000000000e-1 * t72 - 0.82785000000000000000000000000000000000000000000000e-1 * t78
  t224 = 0.1e1 / t210
  t225 = t217 * t222 * t224
  t226 = t56 * t225
  t230 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t25
  t232 = 0.1e1 / t216 / t207
  t233 = t230 * t232
  t234 = t222 ** 2
  t238 = t230 * t217
  t245 = -0.57538888888888888888888888888888888888888888888889e0 * t106 + 0.11507777777777777777777777777777777777777777777778e1 * t110 + 0.40256666666666666666666666666666666666666666666667e0 * t113 + 0.36677500000000000000000000000000000000000000000000e-1 * t118 + 0.73355000000000000000000000000000000000000000000000e-1 * t120 + 0.13797500000000000000000000000000000000000000000000e0 * t124
  t246 = t245 * t224
  t249 = t216 ** 2
  t250 = 0.1e1 / t249
  t251 = t230 * t250
  t252 = t210 ** 2
  t253 = 0.1e1 / t252
  t257 = -0.70983522622222222222222222222222222222222222222221e-3 * t12 * t18 * t158 - 0.34246666666666666666666666666666666666666666666666e-1 * t55 * t172 - 0.20000000000000000000000000000000000000000000000000e1 * t179 * t180 * t170 + 0.10000000000000000000000000000000000000000000000000e1 * t184 * t191 * t170 + 0.32163958997385070133512593798145426124210776856102e2 * t197 * t180 * t199 + t51 + t86 + t95 - t129 - t137 - 0.24415263074675393406472461472505321282722606644045e-3 * t12 * t18 * t212 - 0.10843581300301739842632067522386578331157260943710e-1 * t55 * t226 - 0.11696447245269292414524477327518106963944910680856e1 * t233 * t234 * t224 + 0.58482236226346462072622386637590534819724553404280e0 * t238 * t246 + 0.17315859105681463759666483083807725165579399831905e2 * t251 * t234 * t253
  t259 = t148 * t9
  t260 = t56 * t211
  t264 = t148 * t12
  t268 = t148 * t230
  t270 = t232 * t234 * t224
  t274 = t217 * t245 * t224
  t278 = t250 * t234 * t253
  t281 = -t51 - t86 - t95 + t129 + t137 + t148 * t257 + 0.24415263074675393406472461472505321282722606644045e-3 * t259 * t108 * t260 + 0.10843581300301739842632067522386578331157260943710e-1 * t264 * t66 * t225 + 0.11696447245269292414524477327518106963944910680856e1 * t268 * t270 - 0.58482236226346462072622386637590534819724553404280e0 * t268 * t274 - 0.17315859105681463759666483083807725165579399831905e2 * t268 * t278
  t284 = f.my_piecewise3(t4, 0, t5 * t281 / 0.2e1)
  t285 = params.dss[0]
  t286 = s0 * t37
  t287 = t286 * t102
  t288 = tau0 * t37
  t289 = t288 * t75
  t290 = 0.2e1 * t289
  t291 = 6 ** (0.1e1 / 0.3e1)
  t292 = t291 ** 2
  t293 = jnp.pi ** 2
  t294 = t293 ** (0.1e1 / 0.3e1)
  t295 = t294 ** 2
  t296 = t292 * t295
  t297 = 0.3e1 / 0.5e1 * t296
  t300 = 0.1e1 + params.alpha_ss * (t287 + t290 - t297)
  t304 = params.dss[1] * s0
  t306 = params.dss[2]
  t307 = t290 - t297
  t309 = t304 * t122 + t306 * t307
  t310 = t300 ** 2
  t311 = 0.1e1 / t310
  t314 = s0 ** 2
  t315 = params.dss[3] * t314
  t316 = t13 ** 2
  t317 = t316 * r0
  t320 = t17 / t14 / t317
  t324 = params.dss[4] * s0
  t327 = params.dss[5]
  t328 = t307 ** 2
  t330 = t324 * t122 * t307 + 0.2e1 * t315 * t320 + t327 * t328
  t332 = 0.1e1 / t310 / t300
  t334 = t285 / t300 + t309 * t311 + t330 * t332
  t335 = t284 * t334
  t338 = 0.1e1 / tau0
  t341 = 0.1e1 - s0 / r0 * t338 / 0.8e1
  t346 = 0.11073470983333333333333333333333333333333333333333e-2 * t12 * t65 * t48
  t347 = t80 * t82
  t349 = 0.10000000000000000000000000000000000000000000000000e1 * t96 * t347
  t353 = t168 * t170
  t359 = t222 * t224
  t372 = f.my_piecewise3(t4, 0, t5 * (t346 + t349 + t148 * (0.53237641966666666666666666666666666666666666666666e-3 * t12 * t65 * t158 + 0.10000000000000000000000000000000000000000000000000e1 * t184 * t353 - t346 - t349 + 0.18311447306006545054854346104378990962041954983034e-3 * t12 * t65 * t212 + 0.58482236226346462072622386637590534819724553404280e0 * t238 * t359) - 0.18311447306006545054854346104378990962041954983034e-3 * t259 * t54 * t260 - 0.58482236226346462072622386637590534819724553404280e0 * t268 * t225) / 0.2e1)
  t373 = t285 * t311
  t374 = t13 * r0
  t376 = 0.1e1 / t35 / t374
  t377 = t286 * t376
  t379 = t288 * t102
  t381 = -0.8e1 / 0.3e1 * t377 - 0.10e2 / 0.3e1 * t379
  t382 = params.alpha_ss * t381
  t384 = t37 * t376
  t387 = t306 * tau0
  t390 = -0.8e1 / 0.3e1 * t304 * t384 - 0.10e2 / 0.3e1 * t387 * t122
  t392 = t309 * t332
  t398 = t17 / t14 / t316 / t13
  t404 = t320 * tau0
  t407 = t327 * t307
  t410 = -0.32e2 / 0.3e1 * t315 * t398 - 0.8e1 / 0.3e1 * t324 * t384 * t307 - 0.20e2 / 0.3e1 * t324 * t404 - 0.20e2 / 0.3e1 * t407 * t379
  t412 = t310 ** 2
  t413 = 0.1e1 / t412
  t414 = t330 * t413
  t417 = t390 * t311 + t410 * t332 - t373 * t382 - 0.2e1 * t392 * t382 - 0.3e1 * t414 * t382
  t418 = t372 * t417
  t421 = t372 * t334
  t424 = s0 / t13 * t338
  t428 = 0.621814e-1 * t88 * t47
  t431 = t230 * t211
  t440 = f.my_piecewise3(t4, 0, t5 * (-t428 + t148 * (-0.3109070e-1 * t176 * t157 + t428 - 0.19751673498613801407483339618206552048944131217655e-1 * t431) + 0.19751673498613801407483339618206552048944131217655e-1 * t148 * t431) / 0.2e1)
  t441 = t285 * t332
  t442 = params.alpha_ss ** 2
  t443 = t381 ** 2
  t444 = t442 * t443
  t448 = 0.1e1 / t35 / t316
  t449 = t286 * t448
  t451 = t288 * t376
  t453 = 0.88e2 / 0.9e1 * t449 + 0.80e2 / 0.9e1 * t451
  t454 = params.alpha_ss * t453
  t456 = t37 * t448
  t461 = 0.88e2 / 0.9e1 * t304 * t456 + 0.80e2 / 0.9e1 * t387 * t384
  t463 = t390 * t332
  t466 = t309 * t413
  t474 = t17 / t14 / t316 / t374
  t480 = t398 * tau0
  t483 = tau0 ** 2
  t484 = t327 * t483
  t489 = 0.608e3 / 0.9e1 * t315 * t474 + 0.88e2 / 0.9e1 * t324 * t456 * t307 + 0.160e3 / 0.3e1 * t324 * t480 + 0.400e3 / 0.9e1 * t484 * t320 + 0.160e3 / 0.9e1 * t407 * t451
  t491 = t410 * t413
  t495 = 0.1e1 / t412 / t300
  t496 = t330 * t495
  t501 = t461 * t311 + t489 * t332 - t373 * t454 - 0.4e1 * t463 * t382 - 0.6e1 * t491 * t382 - 0.2e1 * t392 * t454 - 0.3e1 * t414 * t454 + 0.2e1 * t441 * t444 + 0.6e1 * t466 * t444 + 0.12e2 * t496 * t444
  t502 = t440 * t501
  t505 = t440 * t417
  t508 = t440 * t334
  t511 = s0 / t374 * t338
  t515 = t9 * t11 * t22
  t516 = jnp.sqrt(t515)
  t519 = t515 ** 0.15e1
  t522 = t33 * t10 * t36
  t524 = 0.37978500000000000000000000000000000000000000000000e1 * t516 + 0.89690000000000000000000000000000000000000000000000e0 * t515 + 0.20477500000000000000000000000000000000000000000000e0 * t519 + 0.12323500000000000000000000000000000000000000000000e0 * t522
  t527 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t524
  t528 = jnp.log(t527)
  t532 = t524 ** 2
  t533 = 0.1e1 / t532
  t534 = t53 * t533
  t536 = 0.1e1 / t516 * t6
  t537 = t8 * t11
  t538 = t537 * t53
  t539 = t536 * t538
  t542 = t515 ** 0.5e0
  t543 = t542 * t6
  t544 = t543 * t538
  t547 = t33 * t10 * t75
  t549 = -0.63297500000000000000000000000000000000000000000000e0 * t539 - 0.29896666666666666666666666666666666666666666666667e0 * t55 - 0.10238750000000000000000000000000000000000000000000e0 * t544 - 0.82156666666666666666666666666666666666666666666667e-1 * t547
  t550 = 0.1e1 / t527
  t551 = t549 * t550
  t556 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t515
  t558 = 0.1e1 / t532 / t524
  t559 = t556 * t558
  t560 = t549 ** 2
  t561 = t560 * t550
  t564 = t556 * t533
  t567 = 0.1e1 / t516 / t515 * t31
  t568 = t32 * t10
  t569 = t568 * t102
  t570 = t567 * t569
  t572 = t537 * t16
  t573 = t536 * t572
  t575 = t9 * t108
  t577 = t515 ** (-0.5e0)
  t578 = t577 * t31
  t579 = t578 * t569
  t581 = t543 * t572
  t583 = t33 * t103
  t585 = -0.42198333333333333333333333333333333333333333333333e0 * t570 + 0.84396666666666666666666666666666666666666666666666e0 * t573 + 0.39862222222222222222222222222222222222222222222223e0 * t575 + 0.68258333333333333333333333333333333333333333333333e-1 * t579 + 0.13651666666666666666666666666666666666666666666667e0 * t581 + 0.13692777777777777777777777777777777777777777777778e0 * t583
  t586 = t585 * t550
  t589 = t532 ** 2
  t590 = 0.1e1 / t589
  t591 = t556 * t590
  t592 = t527 ** 2
  t593 = 0.1e1 / t592
  t594 = t560 * t593
  t597 = f.my_piecewise3(t3, t139, 1)
  t600 = (0.2e1 * t597 - 0.2e1) * t147
  t601 = t600 * t6
  t606 = 0.51785000000000000000000000000000000000000000000000e1 * t516 + 0.90577500000000000000000000000000000000000000000000e0 * t515 + 0.11003250000000000000000000000000000000000000000000e0 * t519 + 0.12417750000000000000000000000000000000000000000000e0 * t522
  t609 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t606
  t610 = jnp.log(t609)
  t615 = t600 * t9
  t616 = t606 ** 2
  t617 = 0.1e1 / t616
  t622 = -0.86308333333333333333333333333333333333333333333334e0 * t539 - 0.30192500000000000000000000000000000000000000000000e0 * t55 - 0.55016250000000000000000000000000000000000000000000e-1 * t544 - 0.82785000000000000000000000000000000000000000000000e-1 * t547
  t624 = 0.1e1 / t609
  t625 = t617 * t622 * t624
  t630 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t515
  t631 = t600 * t630
  t633 = 0.1e1 / t616 / t606
  t634 = t622 ** 2
  t636 = t633 * t634 * t624
  t645 = -0.57538888888888888888888888888888888888888888888889e0 * t570 + 0.11507777777777777777777777777777777777777777777778e1 * t573 + 0.40256666666666666666666666666666666666666666666667e0 * t575 + 0.36677500000000000000000000000000000000000000000000e-1 * t579 + 0.73355000000000000000000000000000000000000000000000e-1 * t581 + 0.13797500000000000000000000000000000000000000000000e0 * t583
  t647 = t617 * t645 * t624
  t650 = t616 ** 2
  t651 = 0.1e1 / t650
  t653 = t609 ** 2
  t654 = 0.1e1 / t653
  t655 = t651 * t634 * t654
  t659 = -0.14764627977777777777777777777777777777777777777777e-2 * t9 * t108 * t528 - 0.35616666666666666666666666666666666666666666666666e-1 * t12 * t534 * t551 - 0.20000000000000000000000000000000000000000000000000e1 * t559 * t561 + 0.10000000000000000000000000000000000000000000000000e1 * t564 * t586 + 0.16081979498692535066756296899072713062105388428051e2 * t591 * t594 + 0.24415263074675393406472461472505321282722606644045e-3 * t601 * t537 * t16 * t610 + 0.10843581300301739842632067522386578331157260943710e-1 * t615 * t54 * t625 + 0.11696447245269292414524477327518106963944910680856e1 * t631 * t636 - 0.58482236226346462072622386637590534819724553404280e0 * t631 * t647 - 0.17315859105681463759666483083807725165579399831905e2 * t631 * t655 - 0.2e1 * t284
  t660 = params.dab[0]
  t662 = 0.4e1 * t289
  t663 = 0.6e1 / 0.5e1 * t296
  t666 = 0.1e1 + params.alpha_ab * (0.2e1 * t287 + t662 - t663)
  t670 = params.dab[1] * s0
  t673 = params.dab[2]
  t674 = t662 - t663
  t676 = 0.2e1 * t670 * t122 + t673 * t674
  t677 = t666 ** 2
  t678 = 0.1e1 / t677
  t681 = params.dab[3] * t314
  t685 = params.dab[4] * s0
  t689 = params.dab[5]
  t690 = t674 ** 2
  t692 = 0.2e1 * t685 * t122 * t674 + 0.8e1 * t681 * t320 + t689 * t690
  t694 = 0.1e1 / t677 / t666
  t696 = t660 / t666 + t676 * t678 + t692 * t694
  t711 = 0.11073470983333333333333333333333333333333333333333e-2 * t9 * t54 * t528 + 0.10000000000000000000000000000000000000000000000000e1 * t564 * t551 - 0.18311447306006545054854346104378990962041954983034e-3 * t601 * t537 * t53 * t610 - 0.58482236226346462072622386637590534819724553404280e0 * t631 * t625 - 0.2e1 * t372
  t712 = t660 * t678
  t715 = -0.16e2 / 0.3e1 * t377 - 0.20e2 / 0.3e1 * t379
  t716 = params.alpha_ab * t715
  t720 = t673 * tau0
  t723 = -0.16e2 / 0.3e1 * t670 * t384 - 0.20e2 / 0.3e1 * t720 * t122
  t725 = t676 * t694
  t735 = t689 * t674
  t738 = -0.128e3 / 0.3e1 * t681 * t398 - 0.16e2 / 0.3e1 * t685 * t384 * t674 - 0.80e2 / 0.3e1 * t685 * t404 - 0.40e2 / 0.3e1 * t735 * t379
  t740 = t677 ** 2
  t741 = 0.1e1 / t740
  t742 = t692 * t741
  t745 = t723 * t678 + t738 * t694 - t712 * t716 - 0.2e1 * t725 * t716 - 0.3e1 * t742 * t716
  t754 = -0.621814e-1 * t556 * t528 + 0.19751673498613801407483339618206552048944131217655e-1 * t600 * t630 * t610 - 0.2e1 * t440
  t755 = t660 * t694
  t756 = params.alpha_ab ** 2
  t757 = t715 ** 2
  t758 = t756 * t757
  t763 = 0.176e3 / 0.9e1 * t449 + 0.160e3 / 0.9e1 * t451
  t764 = params.alpha_ab * t763
  t770 = 0.176e3 / 0.9e1 * t670 * t456 + 0.160e3 / 0.9e1 * t720 * t384
  t772 = t723 * t694
  t775 = t676 * t741
  t787 = t689 * t483
  t792 = 0.2432e4 / 0.9e1 * t681 * t474 + 0.176e3 / 0.9e1 * t685 * t456 * t674 + 0.640e3 / 0.3e1 * t685 * t480 + 0.1600e4 / 0.9e1 * t787 * t320 + 0.320e3 / 0.9e1 * t735 * t451
  t794 = t738 * t741
  t798 = 0.1e1 / t740 / t666
  t799 = t692 * t798
  t804 = t770 * t678 + t792 * t694 - t712 * t764 - 0.4e1 * t772 * t716 - 0.6e1 * t794 * t716 - 0.2e1 * t725 * t764 - 0.3e1 * t742 * t764 + 0.2e1 * t755 * t758 + 0.6e1 * t775 * t758 + 0.12e2 * t799 * t758
  t810 = 0.48245938496077605200268890697218139186316165284153e2 * t132 * t126 * t134 * t80
  t823 = t92 * t80
  t826 = 0.96491876992155210400537781394436278372632330568306e2 * t88 / t130 / t43 * t823 * t134
  t831 = 0.1e1 / t316
  t833 = t831 * t39 * t21
  t834 = 0.1e1 / t26 / t41 * t7 * t833 / 0.4e1
  t836 = t10 * t376
  t837 = t836 * t104
  t838 = t100 * t837
  t841 = 0.1e1 / t14 / t374
  t842 = t11 * t841
  t843 = t842 * t56
  t844 = t61 * t843
  t846 = t841 * t17
  t848 = t12 * t846 * t21
  t850 = t25 ** (-0.15e1)
  t852 = t850 * t7 * t833
  t854 = t117 * t837
  t856 = t71 * t843
  t859 = t34 * t384 * t39
  t864 = 0.10000000000000000000000000000000000000000000000000e1 * t96 * (-0.50638000000000000000000000000000000000000000000000e1 * t834 + 0.16879333333333333333333333333333333333333333333333e1 * t838 - 0.19692555555555555555555555555555555555555555555555e1 * t844 - 0.93011851851851851851851851851851851851851851851854e0 * t848 + 0.27303333333333333333333333333333333333333333333333e0 * t852 - 0.27303333333333333333333333333333333333333333333333e0 * t854 - 0.31853888888888888888888888888888888888888888888890e0 * t856 - 0.36514074074074074074074074074074074074074074074075e0 * t859) * t82
  t872 = 0.51726012919273400298984252201052768390886626637712e3 * t88 / t130 / t57 * t823 / t133 / t46
  t875 = 0.34450798614814814814814814814814814814814814814813e-2 * t12 * t846 * t48
  t877 = 0.1e1 / t249 / t207
  t878 = t234 * t222
  t890 = 0.10685000000000000000000000000000000000000000000000e0 * t55 * t56 * t90 * t92 * t82
  t891 = t810 + 0.48159733137676571081572406076840235616767705782485e0 * t264 * t66 * t278 - 0.21687162600603479685264135044773156662314521887420e-1 * t264 * t112 * t225 + 0.16265371950452609763948101283579867496735891415565e-1 * t264 * t66 * t274 - t826 + t864 + t872 + t875 + 0.10389515463408878255799889850284635099347639899143e3 * t268 * t877 * t878 * t253 - 0.56968947174242584615102410102512416326352748836105e-3 * t259 * t842 * t260 + t890
  t893 = 0.71233333333333333333333333333333333333333333333331e-1 * t575 * t84
  t898 = 0.53424999999999999999999999999999999999999999999999e-1 * t55 * t56 * t58 * t126 * t82
  t903 = 0.85917975471764868594145516183295969534298037676861e0 * t55 * t56 * t131 * t92 * t134
  t906 = 0.60000000000000000000000000000000000000000000000000e1 * t132 * t823 * t82
  t909 = 0.60000000000000000000000000000000000000000000000000e1 * t91 * t347 * t126
  t911 = 0.1e1 / t249 / t216
  t914 = 0.1e1 / t252 / t210
  t926 = -0.69046666666666666666666666666666666666666666666667e1 * t834 + 0.23015555555555555555555555555555555555555555555556e1 * t838 - 0.26851481481481481481481481481481481481481481481482e1 * t844 - 0.93932222222222222222222222222222222222222222222223e0 * t848 + 0.14671000000000000000000000000000000000000000000000e0 * t852 - 0.14671000000000000000000000000000000000000000000000e0 * t854 - 0.17116166666666666666666666666666666666666666666667e0 * t856 - 0.36793333333333333333333333333333333333333333333333e0 * t859
  t961 = t180 * t168
  t1005 = 0.58482236226346462072622386637590534819724553404280e0 * t238 * t926 * t224 + 0.10254018858216406658218194626490193680059335835414e4 * t230 * t911 * t878 * t914 - 0.10389515463408878255799889850284635099347639899143e3 * t230 * t877 * t878 * t253 + 0.20690405167709360119593700880421107356354650655085e4 * t176 / t195 / t162 * t961 / t198 / t156 - 0.19298375398431042080107556278887255674526466113661e3 * t176 / t195 / t153 * t961 * t199 + 0.10000000000000000000000000000000000000000000000000e1 * t184 * (-0.94126000000000000000000000000000000000000000000000e1 * t834 + 0.31375333333333333333333333333333333333333333333334e1 * t838 - 0.36604555555555555555555555555555555555555555555556e1 * t844 - 0.16068111111111111111111111111111111111111111111111e1 * t848 + 0.56103333333333333333333333333333333333333333333332e0 * t852 - 0.56103333333333333333333333333333333333333333333332e0 * t854 - 0.65453888888888888888888888888888888888888888888890e0 * t856 - 0.46308888888888888888888888888888888888888888888888e0 * t859) * t170 + 0.60000000000000000000000000000000000000000000000000e1 * t197 * t961 * t170 + 0.35089341735807877243573431982554320891834732042568e1 * t251 * t878 * t224 + t826 - t864 - t872 - t906 - 0.60000000000000000000000000000000000000000000000000e1 * t179 * t353 * t191 + 0.96491876992155210400537781394436278372632330568306e2 * t197 * t191 * t199 * t168 - 0.35089341735807877243573431982554320891834732042568e1 * t233 * t359 * t245 + 0.51947577317044391278999449251423175496738199495715e2 * t251 * t245 * t253 * t222
  t1040 = -t810 + t909 - t890 - t893 + t898 + t903 + 0.68493333333333333333333333333333333333333333333332e-1 * t575 * t172 - 0.51369999999999999999999999999999999999999999999999e-1 * t55 * t56 * t163 * t191 * t170 + 0.21687162600603479685264135044773156662314521887420e-1 * t575 * t226 - 0.16265371950452609763948101283579867496735891415565e-1 * t55 * t56 * t274 - 0.48159733137676571081572406076840235616767705782485e0 * t55 * t56 * t278 + 0.32530743900905219527896202567159734993471782831130e-1 * t55 * t56 * t270 + 0.10274000000000000000000000000000000000000000000000e0 * t55 * t56 * t178 * t180 * t170 - 0.16522625736956710527585419434107305400007076070979e1 * t55 * t56 * t196 * t180 * t199 - t875 + 0.56968947174242584615102410102512416326352748836105e-3 * t12 * t846 * t212 + 0.16562821945185185185185185185185185185185185185185e-2 * t12 * t846 * t158
  t1043 = t893 - t898 - t903 + t906 - t909 - 0.10254018858216406658218194626490193680059335835414e4 * t268 * t911 * t878 * t914 - 0.58482236226346462072622386637590534819724553404280e0 * t268 * t217 * t926 * t224 - 0.32530743900905219527896202567159734993471782831130e-1 * t264 * t66 * t270 - 0.51947577317044391278999449251423175496738199495715e2 * t268 * t250 * t245 * t253 * t222 - 0.35089341735807877243573431982554320891834732042568e1 * t268 * t250 * t878 * t224 + 0.35089341735807877243573431982554320891834732042568e1 * t268 * t232 * t222 * t246 + t148 * (t1005 + t1040)
  t1047 = f.my_piecewise3(t4, 0, t5 * (t891 + t1043) / 0.2e1)
  t1063 = t316 ** 2
  t1066 = t17 / t14 / t1063
  t1070 = 0.1e1 / t35 / t317
  t1071 = t37 * t1070
  t1075 = t474 * tau0
  t1080 = t288 * t448
  t1092 = t442 * t381 * t453
  t1099 = t286 * t1070
  t1103 = params.alpha_ss * (-0.1232e4 / 0.27e2 * t1099 - 0.880e3 / 0.27e2 * t1080)
  t1127 = t442 * params.alpha_ss * t443 * t381
  t1139 = (-0.13376e5 / 0.27e2 * t315 * t1066 - 0.1232e4 / 0.27e2 * t324 * t1071 * t307 - 0.10880e5 / 0.27e2 * t324 * t1075 - 0.3200e4 / 0.9e1 * t484 * t398 - 0.1760e4 / 0.27e2 * t407 * t1080) * t332 + (-0.1232e4 / 0.27e2 * t304 * t1071 - 0.880e3 / 0.27e2 * t387 * t456) * t311 + 0.36e2 * t496 * t1092 + 0.6e1 * t441 * t1092 + 0.18e2 * t466 * t1092 - 0.3e1 * t414 * t1103 - t373 * t1103 - 0.6e1 * t461 * t332 * t382 - 0.6e1 * t463 * t454 - 0.2e1 * t392 * t1103 - 0.9e1 * t489 * t413 * t382 - 0.9e1 * t491 * t454 + 0.36e2 * t410 * t495 * t444 - 0.60e2 * t330 / t412 / t310 * t1127 - 0.6e1 * t285 * t413 * t1127 + 0.18e2 * t390 * t413 * t444 - 0.24e2 * t309 * t495 * t1127
  t1158 = t560 * t549
  t1167 = t634 * t622
  t1184 = 0.1e1 / t516 / t522 * t7 * t831 / 0.4e1
  t1186 = t568 * t376
  t1187 = t567 * t1186
  t1189 = t537 * t841
  t1190 = t536 * t1189
  t1192 = t9 * t842
  t1194 = t515 ** (-0.15e1)
  t1196 = t1194 * t7 * t831
  t1198 = t578 * t1186
  t1200 = t543 * t1189
  t1202 = t33 * t836
  t1227 = 0.48245938496077605200268890697218139186316165284153e2 * t591 * t585 * t593 * t549 - 0.60000000000000000000000000000000000000000000000000e1 * t559 * t551 * t585 + 0.60000000000000000000000000000000000000000000000000e1 * t591 * t1158 * t550 - 0.32530743900905219527896202567159734993471782831130e-1 * t615 * t54 * t636 - 0.10254018858216406658218194626490193680059335835414e4 * t631 / t650 / t616 * t1167 / t653 / t609 + 0.10389515463408878255799889850284635099347639899143e3 * t631 / t650 / t606 * t1167 * t654 - 0.58482236226346462072622386637590534819724553404280e0 * t631 * t617 * (-0.34523333333333333333333333333333333333333333333333e1 * t1184 + 0.23015555555555555555555555555555555555555555555556e1 * t1187 - 0.26851481481481481481481481481481481481481481481482e1 * t1190 - 0.93932222222222222222222222222222222222222222222223e0 * t1192 + 0.73355000000000000000000000000000000000000000000000e-1 * t1196 - 0.14671000000000000000000000000000000000000000000000e0 * t1198 - 0.17116166666666666666666666666666666666666666666667e0 * t1200 - 0.36793333333333333333333333333333333333333333333333e0 * t1202) * t624 - 0.51947577317044391278999449251423175496738199495715e2 * t631 * t651 * t645 * t654 * t622 - 0.35089341735807877243573431982554320891834732042568e1 * t631 * t651 * t1167 * t624 + 0.35089341735807877243573431982554320891834732042568e1 * t631 * t633 * t622 * t624 * t645 + 0.71233333333333333333333333333333333333333333333331e-1 * t12 * t16 * t533 * t551
  t1282 = -0.53424999999999999999999999999999999999999999999999e-1 * t12 * t534 * t586 - 0.85917975471764868594145516183295969534298037676861e0 * t12 * t53 * t590 * t594 + 0.51726012919273400298984252201052768390886626637712e3 * t556 / t589 / t532 * t1158 / t592 / t527 - 0.96491876992155210400537781394436278372632330568306e2 * t556 / t589 / t524 * t1158 * t593 + 0.10000000000000000000000000000000000000000000000000e1 * t564 * (-0.25319000000000000000000000000000000000000000000000e1 * t1184 + 0.16879333333333333333333333333333333333333333333333e1 * t1187 - 0.19692555555555555555555555555555555555555555555555e1 * t1190 - 0.93011851851851851851851851851851851851851851851854e0 * t1192 + 0.13651666666666666666666666666666666666666666666667e0 * t1196 - 0.27303333333333333333333333333333333333333333333333e0 * t1198 - 0.31853888888888888888888888888888888888888888888890e0 * t1200 - 0.36514074074074074074074074074074074074074074074075e0 * t1202) * t550 + 0.10685000000000000000000000000000000000000000000000e0 * t12 * t53 * t558 * t561 - 0.56968947174242584615102410102512416326352748836105e-3 * t601 * t537 * t841 * t610 + 0.34450798614814814814814814814814814814814814814813e-2 * t9 * t842 * t528 - 0.21687162600603479685264135044773156662314521887420e-1 * t615 * t108 * t625 + 0.16265371950452609763948101283579867496735891415565e-1 * t615 * t54 * t647 + 0.48159733137676571081572406076840235616767705782485e0 * t615 * t54 * t655 - 0.2e1 * t1047
  t1290 = t756 * t715 * t763
  t1305 = t756 * params.alpha_ab * t757 * t715
  t1325 = params.alpha_ab * (-0.2464e4 / 0.27e2 * t1099 - 0.1760e4 / 0.27e2 * t1080)
  t1355 = 0.36e2 * t799 * t1290 + 0.6e1 * t755 * t1290 + 0.18e2 * t775 * t1290 + 0.36e2 * t738 * t798 * t758 - 0.60e2 * t692 / t740 / t677 * t1305 - 0.6e1 * t660 * t741 * t1305 + 0.18e2 * t723 * t741 * t758 - 0.24e2 * t676 * t798 * t1305 - 0.6e1 * t770 * t694 * t716 - 0.6e1 * t772 * t764 - 0.2e1 * t725 * t1325 - 0.9e1 * t792 * t741 * t716 - 0.9e1 * t794 * t764 - 0.3e1 * t742 * t1325 - t712 * t1325 + (-0.2464e4 / 0.27e2 * t670 * t1071 - 0.1760e4 / 0.27e2 * t720 * t456) * t678 + (-0.53504e5 / 0.27e2 * t681 * t1066 - 0.2464e4 / 0.27e2 * t685 * t1071 * t674 - 0.43520e5 / 0.27e2 * t685 * t1075 - 0.12800e5 / 0.9e1 * t787 * t398 - 0.3520e4 / 0.27e2 * t735 * t1080) * t694
  t1357 = 0.2e1 * t1047 * t334 * t341 + 0.6e1 * t284 * t417 * t341 + 0.3e1 / 0.4e1 * t335 * t424 + 0.6e1 * t372 * t501 * t341 + 0.3e1 / 0.2e1 * t418 * t424 - 0.3e1 / 0.2e1 * t421 * t511 + 0.2e1 * t440 * t1139 * t341 + 0.3e1 / 0.4e1 * t502 * t424 - 0.3e1 / 0.2e1 * t505 * t511 + 0.3e1 / 0.2e1 * t508 * s0 * t831 * t338 + (t1227 + t1282) * t696 + 0.3e1 * t659 * t745 + 0.3e1 * t711 * t804 + t754 * t1355
  v3rho3_0_ = 0.6e1 * t335 * t341 + 0.12e2 * t418 * t341 + 0.3e1 / 0.2e1 * t421 * t424 + 0.6e1 * t502 * t341 + 0.3e1 / 0.2e1 * t505 * t424 - 0.3e1 / 0.2e1 * t508 * t511 + 0.3e1 * t659 * t696 + 0.6e1 * t711 * t745 + 0.3e1 * t754 * t804 + r0 * t1357

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t3 = 0.1e1 <= f.p.zeta_threshold
  t4 = r0 / 0.2e1 <= f.p.dens_threshold or t3
  t5 = f.my_piecewise3(t3, f.p.zeta_threshold, 1)
  t6 = 3 ** (0.1e1 / 0.3e1)
  t7 = 0.1e1 / jnp.pi
  t8 = t7 ** (0.1e1 / 0.3e1)
  t9 = t6 * t8
  t10 = 4 ** (0.1e1 / 0.3e1)
  t11 = t10 ** 2
  t12 = t9 * t11
  t13 = r0 ** (0.1e1 / 0.3e1)
  t15 = 0.1e1 / t13 / r0
  t16 = 2 ** (0.1e1 / 0.3e1)
  t17 = t15 * t16
  t18 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t20 = f.my_piecewise3(t3, 0.1e1 / t18, 1)
  t21 = 0.1e1 / t13
  t24 = t12 * t21 * t16 * t20
  t25 = jnp.sqrt(t24)
  t28 = t24 ** 0.15e1
  t30 = t6 ** 2
  t31 = t8 ** 2
  t32 = t30 * t31
  t33 = t32 * t10
  t34 = t13 ** 2
  t35 = 0.1e1 / t34
  t36 = t16 ** 2
  t38 = t20 ** 2
  t40 = t33 * t35 * t36 * t38
  t42 = 0.37978500000000000000000000000000000000000000000000e1 * t25 + 0.89690000000000000000000000000000000000000000000000e0 * t24 + 0.20477500000000000000000000000000000000000000000000e0 * t28 + 0.12323500000000000000000000000000000000000000000000e0 * t40
  t45 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t42
  t46 = jnp.log(t45)
  t47 = t20 * t46
  t50 = 0.11073470983333333333333333333333333333333333333333e-2 * t12 * t17 * t47
  t52 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t24
  t53 = t42 ** 2
  t54 = 0.1e1 / t53
  t55 = t52 * t54
  t58 = 0.1e1 / t25 * t6 * t8
  t59 = t11 * t15
  t60 = t16 * t20
  t61 = t59 * t60
  t62 = t58 * t61
  t64 = t17 * t20
  t65 = t12 * t64
  t67 = t24 ** 0.5e0
  t69 = t67 * t6 * t8
  t70 = t69 * t61
  t73 = 0.1e1 / t34 / r0
  t76 = t33 * t73 * t36 * t38
  t78 = -0.63297500000000000000000000000000000000000000000000e0 * t62 - 0.29896666666666666666666666666666666666666666666667e0 * t65 - 0.10238750000000000000000000000000000000000000000000e0 * t70 - 0.82156666666666666666666666666666666666666666666667e-1 * t76
  t79 = 0.1e1 / t45
  t80 = t78 * t79
  t82 = 0.10000000000000000000000000000000000000000000000000e1 * t55 * t80
  t84 = t18 * f.p.zeta_threshold
  t86 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t84, 0.2e1 * t16)
  t88 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t84, 0)
  t92 = 0.1e1 / (0.2e1 * t16 - 0.2e1)
  t93 = (t86 + t88 - 0.2e1) * t92
  t98 = 0.70594500000000000000000000000000000000000000000000e1 * t25 + 0.15494250000000000000000000000000000000000000000000e1 * t24 + 0.42077500000000000000000000000000000000000000000000e0 * t28 + 0.15629250000000000000000000000000000000000000000000e0 * t40
  t101 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t98
  t102 = jnp.log(t101)
  t103 = t20 * t102
  t108 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t24
  t109 = t98 ** 2
  t110 = 0.1e1 / t109
  t111 = t108 * t110
  t116 = -0.11765750000000000000000000000000000000000000000000e1 * t62 - 0.51647500000000000000000000000000000000000000000000e0 * t65 - 0.21038750000000000000000000000000000000000000000000e0 * t70 - 0.10419500000000000000000000000000000000000000000000e0 * t76
  t117 = 0.1e1 / t101
  t118 = t116 * t117
  t125 = 0.51785000000000000000000000000000000000000000000000e1 * t25 + 0.90577500000000000000000000000000000000000000000000e0 * t24 + 0.11003250000000000000000000000000000000000000000000e0 * t28 + 0.12417750000000000000000000000000000000000000000000e0 * t40
  t128 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t125
  t129 = jnp.log(t128)
  t130 = t20 * t129
  t135 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t24
  t136 = t125 ** 2
  t137 = 0.1e1 / t136
  t138 = t135 * t137
  t143 = -0.86308333333333333333333333333333333333333333333334e0 * t62 - 0.30192500000000000000000000000000000000000000000000e0 * t65 - 0.55016250000000000000000000000000000000000000000000e-1 * t70 - 0.82785000000000000000000000000000000000000000000000e-1 * t76
  t144 = 0.1e1 / t128
  t145 = t143 * t144
  t150 = t93 * t9
  t151 = t60 * t129
  t155 = t93 * t135
  t157 = t137 * t143 * t144
  t163 = f.my_piecewise3(t4, 0, t5 * (t50 + t82 + t93 * (0.53237641966666666666666666666666666666666666666666e-3 * t12 * t17 * t103 + 0.10000000000000000000000000000000000000000000000000e1 * t111 * t118 - t50 - t82 + 0.18311447306006545054854346104378990962041954983034e-3 * t12 * t17 * t130 + 0.58482236226346462072622386637590534819724553404280e0 * t138 * t145) - 0.18311447306006545054854346104378990962041954983034e-3 * t150 * t59 * t151 - 0.58482236226346462072622386637590534819724553404280e0 * t155 * t157) / 0.2e1)
  t164 = params.dss[0]
  t165 = s0 * t36
  t166 = r0 ** 2
  t168 = 0.1e1 / t34 / t166
  t169 = t165 * t168
  t170 = tau0 * t36
  t171 = t170 * t73
  t172 = 0.2e1 * t171
  t173 = 6 ** (0.1e1 / 0.3e1)
  t174 = t173 ** 2
  t175 = jnp.pi ** 2
  t176 = t175 ** (0.1e1 / 0.3e1)
  t177 = t176 ** 2
  t178 = t174 * t177
  t179 = 0.3e1 / 0.5e1 * t178
  t182 = 0.1e1 + params.alpha_ss * (t169 + t172 - t179)
  t183 = t182 ** 2
  t184 = t183 * t182
  t185 = 0.1e1 / t184
  t186 = t164 * t185
  t187 = params.alpha_ss ** 2
  t188 = t166 * r0
  t190 = 0.1e1 / t34 / t188
  t191 = t165 * t190
  t193 = t170 * t168
  t195 = -0.8e1 / 0.3e1 * t191 - 0.10e2 / 0.3e1 * t193
  t196 = t195 ** 2
  t197 = t187 * t196
  t200 = 0.1e1 / t183
  t201 = t164 * t200
  t202 = t166 ** 2
  t204 = 0.1e1 / t34 / t202
  t205 = t165 * t204
  t207 = t170 * t190
  t209 = 0.88e2 / 0.9e1 * t205 + 0.80e2 / 0.9e1 * t207
  t210 = params.alpha_ss * t209
  t213 = params.dss[1] * s0
  t214 = t36 * t204
  t217 = params.dss[2]
  t218 = t217 * tau0
  t219 = t36 * t190
  t222 = 0.88e2 / 0.9e1 * t213 * t214 + 0.80e2 / 0.9e1 * t218 * t219
  t226 = t36 * t168
  t229 = -0.8e1 / 0.3e1 * t213 * t219 - 0.10e2 / 0.3e1 * t218 * t226
  t230 = t229 * t185
  t231 = params.alpha_ss * t195
  t235 = t172 - t179
  t237 = t213 * t226 + t217 * t235
  t238 = t183 ** 2
  t239 = 0.1e1 / t238
  t240 = t237 * t239
  t243 = t237 * t185
  t247 = s0 ** 2
  t248 = params.dss[3] * t247
  t252 = t16 / t13 / t202 / t188
  t256 = params.dss[4] * s0
  t260 = t202 * t166
  t263 = t16 / t13 / t260
  t264 = t263 * tau0
  t267 = params.dss[5]
  t268 = tau0 ** 2
  t269 = t267 * t268
  t270 = t202 * r0
  t272 = 0.1e1 / t13 / t270
  t273 = t16 * t272
  t276 = t267 * t235
  t279 = 0.608e3 / 0.9e1 * t248 * t252 + 0.88e2 / 0.9e1 * t256 * t214 * t235 + 0.160e3 / 0.3e1 * t256 * t264 + 0.400e3 / 0.9e1 * t269 * t273 + 0.160e3 / 0.9e1 * t276 * t207
  t286 = t273 * tau0
  t291 = -0.32e2 / 0.3e1 * t248 * t263 - 0.8e1 / 0.3e1 * t256 * t219 * t235 - 0.20e2 / 0.3e1 * t256 * t286 - 0.20e2 / 0.3e1 * t276 * t193
  t292 = t291 * t239
  t299 = t235 ** 2
  t301 = t256 * t226 * t235 + 0.2e1 * t248 * t273 + t267 * t299
  t303 = 0.1e1 / t238 / t182
  t304 = t301 * t303
  t307 = t301 * t239
  t310 = t279 * t185 + 0.2e1 * t186 * t197 + 0.6e1 * t240 * t197 + 0.12e2 * t304 * t197 + t222 * t200 - t201 * t210 - 0.2e1 * t243 * t210 - 0.3e1 * t307 * t210 - 0.4e1 * t230 * t231 - 0.6e1 * t292 * t231
  t311 = t163 * t310
  t312 = 0.1e1 / r0
  t314 = 0.1e1 / tau0
  t317 = 0.1e1 - s0 * t312 * t314 / 0.8e1
  t321 = t9 * t11 * t21
  t323 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t321
  t324 = jnp.sqrt(t321)
  t327 = t321 ** 0.15e1
  t330 = t32 * t10 * t35
  t332 = 0.37978500000000000000000000000000000000000000000000e1 * t324 + 0.89690000000000000000000000000000000000000000000000e0 * t321 + 0.20477500000000000000000000000000000000000000000000e0 * t327 + 0.12323500000000000000000000000000000000000000000000e0 * t330
  t335 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t332
  t336 = jnp.log(t335)
  t339 = f.my_piecewise3(t3, t84, 1)
  t342 = (0.2e1 * t339 - 0.2e1) * t92
  t344 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t321
  t349 = 0.51785000000000000000000000000000000000000000000000e1 * t324 + 0.90577500000000000000000000000000000000000000000000e0 * t321 + 0.11003250000000000000000000000000000000000000000000e0 * t327 + 0.12417750000000000000000000000000000000000000000000e0 * t330
  t352 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t349
  t353 = jnp.log(t352)
  t358 = 0.621814e-1 * t52 * t46
  t361 = t135 * t129
  t370 = f.my_piecewise3(t4, 0, t5 * (-t358 + t93 * (-0.3109070e-1 * t108 * t102 + t358 - 0.19751673498613801407483339618206552048944131217655e-1 * t361) + 0.19751673498613801407483339618206552048944131217655e-1 * t93 * t361) / 0.2e1)
  t372 = -0.621814e-1 * t323 * t336 + 0.19751673498613801407483339618206552048944131217655e-1 * t342 * t344 * t353 - 0.2e1 * t370
  t374 = params.dab[1] * s0
  t376 = 0.1e1 / t34 / t270
  t377 = t36 * t376
  t380 = params.dab[2]
  t381 = t380 * tau0
  t384 = -0.2464e4 / 0.27e2 * t374 * t377 - 0.1760e4 / 0.27e2 * t381 * t214
  t386 = 0.4e1 * t171
  t387 = 0.6e1 / 0.5e1 * t178
  t390 = 0.1e1 + params.alpha_ab * (0.2e1 * t169 + t386 - t387)
  t391 = t390 ** 2
  t392 = 0.1e1 / t391
  t395 = params.dab[3] * t247
  t396 = t202 ** 2
  t399 = t16 / t13 / t396
  t403 = params.dab[4] * s0
  t404 = t386 - t387
  t408 = t252 * tau0
  t411 = params.dab[5]
  t412 = t411 * t268
  t415 = t411 * t404
  t416 = t170 * t204
  t419 = -0.53504e5 / 0.27e2 * t395 * t399 - 0.2464e4 / 0.27e2 * t403 * t377 * t404 - 0.43520e5 / 0.27e2 * t403 * t408 - 0.12800e5 / 0.9e1 * t412 * t263 - 0.3520e4 / 0.27e2 * t415 * t416
  t420 = t391 * t390
  t421 = 0.1e1 / t420
  t428 = t404 ** 2
  t430 = 0.2e1 * t403 * t226 * t404 + 0.8e1 * t395 * t273 + t411 * t428
  t431 = t391 ** 2
  t433 = 0.1e1 / t431 / t390
  t434 = t430 * t433
  t435 = params.alpha_ab ** 2
  t438 = -0.16e2 / 0.3e1 * t191 - 0.20e2 / 0.3e1 * t193
  t439 = t435 * t438
  t442 = 0.176e3 / 0.9e1 * t205 + 0.160e3 / 0.9e1 * t207
  t443 = t439 * t442
  t446 = params.dab[0]
  t447 = t446 * t421
  t453 = 0.2e1 * t374 * t226 + t380 * t404
  t454 = 0.1e1 / t431
  t455 = t453 * t454
  t467 = -0.128e3 / 0.3e1 * t395 * t263 - 0.16e2 / 0.3e1 * t403 * t219 * t404 - 0.80e2 / 0.3e1 * t403 * t286 - 0.40e2 / 0.3e1 * t415 * t193
  t468 = t467 * t433
  t469 = t438 ** 2
  t470 = t435 * t469
  t474 = 0.1e1 / t431 / t391
  t475 = t430 * t474
  t476 = t435 * params.alpha_ab
  t478 = t476 * t469 * t438
  t481 = t446 * t454
  t488 = -0.16e2 / 0.3e1 * t374 * t219 - 0.20e2 / 0.3e1 * t381 * t226
  t489 = t488 * t454
  t492 = t453 * t433
  t499 = 0.176e3 / 0.9e1 * t374 * t214 + 0.160e3 / 0.9e1 * t381 * t219
  t500 = t499 * t421
  t501 = params.alpha_ab * t438
  t504 = t488 * t421
  t505 = params.alpha_ab * t442
  t508 = t453 * t421
  t509 = t165 * t376
  t512 = -0.2464e4 / 0.27e2 * t509 - 0.1760e4 / 0.27e2 * t416
  t513 = params.alpha_ab * t512
  t527 = 0.2432e4 / 0.9e1 * t395 * t252 + 0.176e3 / 0.9e1 * t403 * t214 * t404 + 0.640e3 / 0.3e1 * t403 * t264 + 0.1600e4 / 0.9e1 * t412 * t273 + 0.320e3 / 0.9e1 * t415 * t207
  t528 = t527 * t454
  t531 = t467 * t454
  t534 = t430 * t454
  t537 = t446 * t392
  t539 = t384 * t392 + t419 * t421 + 0.36e2 * t434 * t443 + 0.6e1 * t447 * t443 + 0.18e2 * t455 * t443 + 0.36e2 * t468 * t470 + 0.18e2 * t489 * t470 - 0.60e2 * t475 * t478 - 0.6e1 * t481 * t478 - 0.24e2 * t492 * t478 - 0.6e1 * t500 * t501 - 0.9e1 * t528 * t501 - 0.6e1 * t504 * t505 - 0.9e1 * t531 * t505 - 0.2e1 * t508 * t513 - 0.3e1 * t534 * t513 - t537 * t513
  t543 = 0.1e1 / t13 / t166
  t544 = t11 * t543
  t548 = t332 ** 2
  t549 = 0.1e1 / t548
  t550 = t15 * t549
  t552 = 0.1e1 / t324 * t6
  t553 = t8 * t11
  t554 = t553 * t15
  t555 = t552 * t554
  t557 = t9 * t59
  t559 = t321 ** 0.5e0
  t560 = t559 * t6
  t561 = t560 * t554
  t564 = t32 * t10 * t73
  t566 = -0.63297500000000000000000000000000000000000000000000e0 * t555 - 0.29896666666666666666666666666666666666666666666667e0 * t557 - 0.10238750000000000000000000000000000000000000000000e0 * t561 - 0.82156666666666666666666666666666666666666666666667e-1 * t564
  t567 = 0.1e1 / t335
  t568 = t566 * t567
  t572 = t548 * t332
  t573 = 0.1e1 / t572
  t574 = t323 * t573
  t575 = t566 ** 2
  t576 = t575 * t567
  t579 = t323 * t549
  t582 = 0.1e1 / t324 / t321 * t30
  t583 = t31 * t10
  t584 = t583 * t168
  t585 = t582 * t584
  t587 = t553 * t543
  t588 = t552 * t587
  t590 = t9 * t544
  t592 = t321 ** (-0.5e0)
  t593 = t592 * t30
  t594 = t593 * t584
  t596 = t560 * t587
  t598 = t10 * t168
  t599 = t32 * t598
  t601 = -0.42198333333333333333333333333333333333333333333333e0 * t585 + 0.84396666666666666666666666666666666666666666666666e0 * t588 + 0.39862222222222222222222222222222222222222222222223e0 * t590 + 0.68258333333333333333333333333333333333333333333333e-1 * t594 + 0.13651666666666666666666666666666666666666666666667e0 * t596 + 0.13692777777777777777777777777777777777777777777778e0 * t599
  t602 = t601 * t567
  t605 = t548 ** 2
  t606 = 0.1e1 / t605
  t607 = t323 * t606
  t608 = t335 ** 2
  t609 = 0.1e1 / t608
  t610 = t575 * t609
  t613 = t342 * t6
  t618 = t342 * t9
  t619 = t349 ** 2
  t620 = 0.1e1 / t619
  t625 = -0.86308333333333333333333333333333333333333333333334e0 * t555 - 0.30192500000000000000000000000000000000000000000000e0 * t557 - 0.55016250000000000000000000000000000000000000000000e-1 * t561 - 0.82785000000000000000000000000000000000000000000000e-1 * t564
  t627 = 0.1e1 / t352
  t628 = t620 * t625 * t627
  t632 = t342 * t344
  t633 = t619 * t349
  t634 = 0.1e1 / t633
  t635 = t625 ** 2
  t637 = t634 * t635 * t627
  t646 = -0.57538888888888888888888888888888888888888888888889e0 * t585 + 0.11507777777777777777777777777777777777777777777778e1 * t588 + 0.40256666666666666666666666666666666666666666666667e0 * t590 + 0.36677500000000000000000000000000000000000000000000e-1 * t594 + 0.73355000000000000000000000000000000000000000000000e-1 * t596 + 0.13797500000000000000000000000000000000000000000000e0 * t599
  t648 = t620 * t646 * t627
  t651 = t619 ** 2
  t652 = 0.1e1 / t651
  t653 = t652 * t635
  t654 = t352 ** 2
  t655 = 0.1e1 / t654
  t656 = t653 * t655
  t659 = t543 * t16
  t662 = 0.14764627977777777777777777777777777777777777777777e-2 * t12 * t659 * t47
  t665 = t60 * t54 * t78 * t79
  t667 = 0.35616666666666666666666666666666666666666666666666e-1 * t557 * t665
  t668 = t53 * t42
  t669 = 0.1e1 / t668
  t670 = t52 * t669
  t671 = t78 ** 2
  t672 = t671 * t79
  t674 = 0.20000000000000000000000000000000000000000000000000e1 * t670 * t672
  t678 = 0.1e1 / t25 / t24 * t30 * t31
  t679 = t36 * t38
  t680 = t598 * t679
  t681 = t678 * t680
  t683 = t544 * t60
  t684 = t58 * t683
  t686 = t659 * t20
  t687 = t12 * t686
  t689 = t24 ** (-0.5e0)
  t691 = t689 * t30 * t31
  t692 = t691 * t680
  t694 = t69 * t683
  t697 = t33 * t226 * t38
  t699 = -0.42198333333333333333333333333333333333333333333333e0 * t681 + 0.84396666666666666666666666666666666666666666666666e0 * t684 + 0.39862222222222222222222222222222222222222222222223e0 * t687 + 0.68258333333333333333333333333333333333333333333333e-1 * t692 + 0.13651666666666666666666666666666666666666666666667e0 * t694 + 0.13692777777777777777777777777777777777777777777778e0 * t697
  t702 = 0.10000000000000000000000000000000000000000000000000e1 * t55 * t699 * t79
  t703 = t53 ** 2
  t704 = 0.1e1 / t703
  t705 = t52 * t704
  t706 = t45 ** 2
  t707 = 0.1e1 / t706
  t710 = 0.16081979498692535066756296899072713062105388428051e2 * t705 * t671 * t707
  t716 = t60 * t110 * t116 * t117
  t719 = t109 * t98
  t720 = 0.1e1 / t719
  t721 = t108 * t720
  t722 = t116 ** 2
  t723 = t722 * t117
  t732 = -0.78438333333333333333333333333333333333333333333333e0 * t681 + 0.15687666666666666666666666666666666666666666666667e1 * t684 + 0.68863333333333333333333333333333333333333333333333e0 * t687 + 0.14025833333333333333333333333333333333333333333333e0 * t692 + 0.28051666666666666666666666666666666666666666666667e0 * t694 + 0.17365833333333333333333333333333333333333333333333e0 * t697
  t736 = t109 ** 2
  t737 = 0.1e1 / t736
  t738 = t108 * t737
  t739 = t101 ** 2
  t740 = 0.1e1 / t739
  t741 = t722 * t740
  t747 = t60 * t157
  t750 = t136 * t125
  t751 = 0.1e1 / t750
  t752 = t135 * t751
  t753 = t143 ** 2
  t754 = t753 * t144
  t763 = -0.57538888888888888888888888888888888888888888888889e0 * t681 + 0.11507777777777777777777777777777777777777777777778e1 * t684 + 0.40256666666666666666666666666666666666666666666667e0 * t687 + 0.36677500000000000000000000000000000000000000000000e-1 * t692 + 0.73355000000000000000000000000000000000000000000000e-1 * t694 + 0.13797500000000000000000000000000000000000000000000e0 * t697
  t764 = t763 * t144
  t767 = t136 ** 2
  t768 = 0.1e1 / t767
  t769 = t135 * t768
  t770 = t128 ** 2
  t771 = 0.1e1 / t770
  t772 = t753 * t771
  t775 = -0.70983522622222222222222222222222222222222222222221e-3 * t12 * t659 * t103 - 0.34246666666666666666666666666666666666666666666666e-1 * t557 * t716 - 0.20000000000000000000000000000000000000000000000000e1 * t721 * t723 + 0.10000000000000000000000000000000000000000000000000e1 * t111 * t732 * t117 + 0.32163958997385070133512593798145426124210776856102e2 * t738 * t741 + t662 + t667 + t674 - t702 - t710 - 0.24415263074675393406472461472505321282722606644045e-3 * t12 * t659 * t130 - 0.10843581300301739842632067522386578331157260943710e-1 * t557 * t747 - 0.11696447245269292414524477327518106963944910680856e1 * t752 * t754 + 0.58482236226346462072622386637590534819724553404280e0 * t138 * t764 + 0.17315859105681463759666483083807725165579399831905e2 * t769 * t772
  t780 = t93 * t12
  t785 = t751 * t753 * t144
  t789 = t137 * t763 * t144
  t792 = t768 * t753
  t793 = t792 * t771
  t796 = -t662 - t667 - t674 + t702 + t710 + t93 * t775 + 0.24415263074675393406472461472505321282722606644045e-3 * t150 * t544 * t151 + 0.10843581300301739842632067522386578331157260943710e-1 * t780 * t64 * t157 + 0.11696447245269292414524477327518106963944910680856e1 * t155 * t785 - 0.58482236226346462072622386637590534819724553404280e0 * t155 * t789 - 0.17315859105681463759666483083807725165579399831905e2 * t155 * t793
  t799 = f.my_piecewise3(t4, 0, t5 * t796 / 0.2e1)
  t801 = -0.14764627977777777777777777777777777777777777777777e-2 * t9 * t544 * t336 - 0.35616666666666666666666666666666666666666666666666e-1 * t12 * t550 * t568 - 0.20000000000000000000000000000000000000000000000000e1 * t574 * t576 + 0.10000000000000000000000000000000000000000000000000e1 * t579 * t602 + 0.16081979498692535066756296899072713062105388428051e2 * t607 * t610 + 0.24415263074675393406472461472505321282722606644045e-3 * t613 * t553 * t543 * t353 + 0.10843581300301739842632067522386578331157260943710e-1 * t618 * t59 * t628 + 0.11696447245269292414524477327518106963944910680856e1 * t632 * t637 - 0.58482236226346462072622386637590534819724553404280e0 * t632 * t648 - 0.17315859105681463759666483083807725165579399831905e2 * t632 * t656 - 0.2e1 * t799
  t809 = t488 * t392 + t467 * t421 - 0.2e1 * t508 * t501 - 0.3e1 * t534 * t501 - t537 * t501
  t816 = t164 / t182 + t237 * t200 + t301 * t185
  t817 = t799 * t816
  t820 = s0 / t166 * t314
  t827 = 0.1e1 / t767 / t125
  t828 = t753 ** 2
  t833 = t767 ** 2
  t834 = 0.1e1 / t833
  t836 = t770 ** 2
  t837 = 0.1e1 / t836
  t841 = t7 * t312
  t842 = t38 * t20
  t848 = t38 ** 2
  t849 = t272 * t848
  t852 = t9 * t11 * t16
  t853 = 0.1e1 / t25 / t841 / t842 * t7 * t849 * t852 / 0.96e2
  t858 = 0.1e1 / t25 / t40 * t7 / 0.4e1
  t859 = 0.1e1 / t270
  t860 = t859 * t842
  t861 = t858 * t860
  t863 = t10 * t204
  t864 = t863 * t679
  t865 = t678 * t864
  t868 = 0.1e1 / t13 / t202
  t869 = t11 * t868
  t870 = t869 * t60
  t871 = t58 * t870
  t873 = t868 * t16
  t875 = t12 * t873 * t20
  t877 = t24 ** (-0.25e1)
  t880 = t877 * t7 * t849 * t852
  t882 = t24 ** (-0.15e1)
  t883 = t882 * t7
  t884 = t883 * t860
  t886 = t691 * t864
  t888 = t69 * t870
  t891 = t33 * t214 * t38
  t893 = -0.57538888888888888888888888888888888888888888888889e1 * t853 + 0.55237333333333333333333333333333333333333333333334e2 * t861 - 0.10229135802469135802469135802469135802469135802469e2 * t865 + 0.89504938271604938271604938271604938271604938271607e1 * t871 + 0.31310740740740740740740740740740740740740740740741e1 * t875 + 0.73355000000000000000000000000000000000000000000000e-1 * t880 - 0.11736800000000000000000000000000000000000000000000e1 * t884 + 0.65204444444444444444444444444444444444444444444445e0 * t886 + 0.57053888888888888888888888888888888888888888888890e0 * t888 + 0.13490888888888888888888888888888888888888888888889e1 * t891
  t900 = 0.11483599538271604938271604938271604938271604938271e-1 * t12 * t873 * t47
  t902 = 0.1e1 / t767 / t136
  t909 = t60 * t669 * t671 * t79
  t911 = 0.28493333333333333333333333333333333333333333333333e0 * t590 * t909
  t912 = t671 * t78
  t917 = 0.42740000000000000000000000000000000000000000000000e0 * t557 * t60 * t704 * t912 * t79
  t920 = t60 * t704 * t671 * t707
  t922 = 0.22911460125803964958438804315545591875812810047162e1 * t590 * t920
  t925 = t60 * t54 * t699 * t79
  t927 = 0.14246666666666666666666666666666666666666666666666e0 * t590 * t925
  t929 = 0.1e1 / t703 / t53
  t932 = 0.1e1 / t706 / t45
  t936 = 0.36846163202829085479643115651216588683774907041596e2 * t557 * t60 * t929 * t912 * t932
  t938 = 0.1e1 / t13 / t188
  t939 = t11 * t938
  t940 = t9 * t939
  t942 = 0.22161481481481481481481481481481481481481481481481e0 * t940 * t665
  t943 = 0.14035736694323150897429372793021728356733892817027e2 * t155 * t827 * t828 * t144 - 0.91082604192152556048340974007871726131433263376469e5 * t155 * t834 * t828 * t837 - 0.58482236226346462072622386637590534819724553404280e0 * t155 * t137 * t893 * t144 - t900 - 0.62337092780453269534799339101707810596085839394858e3 * t155 * t902 * t828 * t771 - t911 - t917 + t922 + t927 - t936 - t942
  t945 = 0.1e1 / t703 / t42
  t950 = 0.68734380377411894875316412946636775627438430141488e1 * t557 * t60 * t945 * t912 * t707
  t951 = 0.1e1 / t202
  t952 = t951 * t842
  t953 = t858 * t952
  t955 = t10 * t190
  t956 = t955 * t679
  t957 = t678 * t956
  t959 = t939 * t60
  t960 = t58 * t959
  t962 = t938 * t16
  t963 = t962 * t20
  t964 = t12 * t963
  t966 = t883 * t952
  t968 = t691 * t956
  t970 = t69 * t959
  t973 = t33 * t219 * t38
  t975 = -0.50638000000000000000000000000000000000000000000000e1 * t953 + 0.16879333333333333333333333333333333333333333333333e1 * t957 - 0.19692555555555555555555555555555555555555555555555e1 * t960 - 0.93011851851851851851851851851851851851851851851854e0 * t964 + 0.27303333333333333333333333333333333333333333333333e0 * t966 - 0.27303333333333333333333333333333333333333333333333e0 * t968 - 0.31853888888888888888888888888888888888888888888890e0 * t970 - 0.36514074074074074074074074074074074074074074074075e0 * t973
  t980 = 0.71233333333333333333333333333333333333333333333332e-1 * t557 * t60 * t54 * t975 * t79
  t981 = t699 ** 2
  t984 = 0.48245938496077605200268890697218139186316165284153e2 * t705 * t981 * t707
  t985 = t52 * t929
  t986 = t671 ** 2
  t989 = 0.57895126195293126240322668836661767023579398340984e3 * t985 * t986 * t707
  t990 = t975 * t79
  t993 = 0.80000000000000000000000000000000000000000000000000e1 * t670 * t990 * t78
  t996 = 0.36000000000000000000000000000000000000000000000000e2 * t705 * t672 * t699
  t997 = t52 * t945
  t998 = t699 * t707
  t1001 = 0.57895126195293126240322668836661767023579398340984e3 * t997 * t998 * t671
  t1005 = 0.64327917994770140267025187596290852248421553712204e2 * t705 * t975 * t707 * t78
  t1009 = 0.31035607751564040179390551320631661034531975982628e4 * t985 * t699 * t932 * t671
  t1026 = -0.69046666666666666666666666666666666666666666666667e1 * t953 + 0.23015555555555555555555555555555555555555555555556e1 * t957 - 0.26851481481481481481481481481481481481481481481482e1 * t960 - 0.93932222222222222222222222222222222222222222222223e0 * t964 + 0.14671000000000000000000000000000000000000000000000e0 * t966 - 0.14671000000000000000000000000000000000000000000000e0 * t968 - 0.17116166666666666666666666666666666666666666666667e0 * t970 - 0.36793333333333333333333333333333333333333333333333e0 * t973
  t1028 = t771 * t143
  t1032 = t950 - t980 + t984 + t989 - t993 + t996 - t1001 + t1005 + t1009 + 0.18989649058080861538367470034170805442117582945368e-2 * t150 * t869 * t151 + 0.62337092780453269534799339101707810596085839394858e3 * t155 * t827 * t753 * t771 * t763 - 0.69263436422725855038665932335230900662317599327620e2 * t155 * t768 * t1026 * t1028
  t1037 = t763 ** 2
  t1042 = t703 ** 2
  t1045 = t706 ** 2
  t1049 = 0.24955700379505800914252936827276051226357058527653e5 * t52 / t1042 * t986 / t1045
  t1052 = 0.24000000000000000000000000000000000000000000000000e2 * t997 * t986 * t79
  t1055 = 0.60000000000000000000000000000000000000000000000000e1 * t670 * t981 * t79
  t1061 = 0.1e1 / t767 / t750
  t1064 = 0.1e1 / t770 / t128
  t1069 = t93 * t6 * t554
  t1071 = t1028 * t763
  t1076 = t764 * t143
  t1080 = t753 * t143
  t1082 = t902 * t1080 * t1064
  t1090 = t137 * t1026 * t144
  t1094 = -0.21053605041484726346144059189532592535100839225540e2 * t155 * t792 * t764 - 0.51947577317044391278999449251423175496738199495715e2 * t155 * t768 * t1037 * t771 + t1049 - t1052 - t1055 + 0.35089341735807877243573431982554320891834732042568e1 * t155 * t751 * t1037 * t144 + 0.12304822629859687989861833551788232416071203002497e5 * t155 * t1061 * t828 * t1064 + 0.19263893255070628432628962430736094246707082312995e1 * t1069 * t60 * t768 * t1071 - 0.13012297560362087811158481026863893997388713132452e0 * t1069 * t60 * t751 * t1076 + 0.38025319932552508024225805073234468230220037056326e2 * t780 * t64 * t1082 - 0.43374325201206959370528270089546313324629043774840e-1 * t780 * t686 * t789 + 0.21687162600603479685264135044773156662314521887420e-1 * t780 * t64 * t1090
  t1096 = t768 * t1080 * t144
  t1110 = t827 * t1080 * t771
  t1120 = t60 * t789
  t1123 = t60 * t793
  t1128 = t60 * t110 * t732 * t117
  t1140 = t900 - 0.55209406483950617283950617283950617283950617283950e-2 * t12 * t873 * t103 - 0.18989649058080861538367470034170805442117582945368e-2 * t12 * t873 * t130 + t911 + t917 + 0.43374325201206959370528270089546313324629043774840e-1 * t590 * t1120 + 0.12842595503380418955085974953824062831138054875329e1 * t590 * t1123 + 0.13698666666666666666666666666666666666666666666666e0 * t590 * t1128 - t922 - t927 + t936 + t942 - t950 + t980 - 0.21687162600603479685264135044773156662314521887420e-1 * t557 * t60 * t1090 - 0.38025319932552508024225805073234468230220037056326e2 * t557 * t60 * t1082 + 0.38527786510141256865257924861472188493414164625988e1 * t557 * t60 * t1110
  t1145 = t135 * t902
  t1152 = t722 ** 2
  t1154 = 0.1e1 / t739 / t101
  t1159 = 0.1e1 / t736 / t109
  t1160 = t108 * t1159
  t1170 = t1026 * t144
  t1182 = t135 * t827
  t1191 = 0.1e1 / t736 / t98
  t1192 = t108 * t1191
  t1196 = -t984 - t989 - 0.12304822629859687989861833551788232416071203002497e5 * t135 * t1061 * t828 * t1064 + 0.62337092780453269534799339101707810596085839394858e3 * t1145 * t828 * t771 - 0.24828486201251232143512441056505328827625580786102e5 * t108 / t736 / t719 * t1152 * t1154 + 0.11579025239058625248064533767332353404715879668197e4 * t1160 * t1152 * t740 + t993 - t996 + 0.36000000000000000000000000000000000000000000000000e2 * t738 * t723 * t732 + 0.21053605041484726346144059189532592535100839225540e2 * t769 * t754 * t763 + t1001 - 0.46785788981077169658097909310072427855779642723424e1 * t752 * t1170 * t143 + 0.69263436422725855038665932335230900662317599327620e2 * t769 * t1026 * t771 * t143 + 0.61524113149298439949309167758941162080356015012483e4 * t1145 * t753 * t1064 * t763 - 0.62337092780453269534799339101707810596085839394858e3 * t1182 * t772 * t763 + 0.12414243100625616071756220528252664413812790393051e5 * t1160 * t722 * t1154 * t732 - 0.11579025239058625248064533767332353404715879668197e4 * t1192 * t741 * t732
  t1206 = -0.94126000000000000000000000000000000000000000000000e1 * t953 + 0.31375333333333333333333333333333333333333333333334e1 * t957 - 0.36604555555555555555555555555555555555555555555556e1 * t960 - 0.16068111111111111111111111111111111111111111111111e1 * t964 + 0.56103333333333333333333333333333333333333333333332e0 * t966 - 0.56103333333333333333333333333333333333333333333332e0 * t968 - 0.65453888888888888888888888888888888888888888888890e0 * t970 - 0.46308888888888888888888888888888888888888888888888e0 * t973
  t1207 = t1206 * t117
  t1227 = t722 * t116
  t1245 = t60 * t737 * t722 * t740
  t1248 = t60 * t785
  t1253 = t60 * t720 * t722 * t117
  t1256 = t732 ** 2
  t1267 = -0.80000000000000000000000000000000000000000000000000e1 * t721 * t1207 * t116 + 0.12865583598954028053405037519258170449684310742441e3 * t738 * t1206 * t740 * t116 - t1005 - t1009 - 0.67471172535210825687488420139294265171645179205307e-1 * t940 * t747 - 0.21309037037037037037037037037037037037037037037036e0 * t940 * t716 - 0.13012297560362087811158481026863893997388713132452e0 * t557 * t60 * t1096 - 0.68493333333333333333333333333333333333333333333332e-1 * t557 * t60 * t110 * t1206 * t117 - 0.41096000000000000000000000000000000000000000000000e0 * t557 * t60 * t737 * t1227 * t117 - 0.14171548179536397724580378856363097131945845388689e3 * t557 * t60 * t1159 * t1227 * t1154 + 0.13218100589565368422068335547285844320005660856783e2 * t557 * t60 * t1191 * t1227 * t740 + 0.44060335298551228073561118490952814400018869522611e1 * t590 * t1245 - 0.86748650402413918741056540179092626649258087549680e-1 * t590 * t1248 - 0.27397333333333333333333333333333333333333333333333e0 * t590 * t1253 + 0.96491876992155210400537781394436278372632330568306e2 * t738 * t1256 * t740 - 0.35089341735807877243573431982554320891834732042568e1 * t752 * t1037 * t144 + 0.91082604192152556048340974007871726131433263376469e5 * t135 * t834 * t828 * t837
  t1271 = t736 ** 2
  t1274 = t739 ** 2
  t1306 = t9 * t59 * t16
  t1309 = t732 * t740 * t116
  t1322 = t118 * t732
  t1327 = t998 * t78
  t1330 = 0.34367190188705947437658206473318387813719215070744e1 * t1306 * t20 * t704 * t1327
  t1332 = t80 * t699
  t1335 = 0.42740000000000000000000000000000000000000000000000e0 * t1306 * t20 * t669 * t1332
  t1341 = 0.62071215503128080358781102641263322069063951965254e4 * t52 / t703 / t668 * t986 * t932
  t1355 = 0.10000000000000000000000000000000000000000000000000e1 * t55 * (-0.42198333333333333333333333333333333333333333333333e1 * t853 + 0.40510400000000000000000000000000000000000000000000e2 * t861 - 0.75019259259259259259259259259259259259259259259258e1 * t865 + 0.65641851851851851851851851851851851851851851851850e1 * t871 + 0.31003950617283950617283950617283950617283950617285e1 * t875 + 0.13651666666666666666666666666666666666666666666666e0 * t880 - 0.21842666666666666666666666666666666666666666666666e1 * t884 + 0.12134814814814814814814814814814814814814814814815e1 * t886 + 0.10617962962962962962962962962962962962962962962963e1 * t888 + 0.13388493827160493827160493827160493827160493827161e1 * t891) * t79
  t1356 = 0.58482236226346462072622386637590534819724553404280e0 * t138 * t893 * t144 - t1049 + 0.19964560303604640731402349461820840981085646822122e6 * t108 / t1271 * t1152 / t1274 + 0.10000000000000000000000000000000000000000000000000e1 * t111 * (-0.78438333333333333333333333333333333333333333333333e1 * t853 + 0.75300800000000000000000000000000000000000000000001e2 * t861 - 0.13944592592592592592592592592592592592592592592593e2 * t865 + 0.12201518518518518518518518518518518518518518518519e2 * t871 + 0.53560370370370370370370370370370370370370370370370e1 * t875 + 0.28051666666666666666666666666666666666666666666666e0 * t880 - 0.44882666666666666666666666666666666666666666666666e1 * t884 + 0.24934814814814814814814814814814814814814814814815e1 * t886 + 0.21817962962962962962962962962962962962962962962963e1 * t888 + 0.16979925925925925925925925925925925925925925925926e1 * t891) * t117 + t1052 + t1055 + 0.51947577317044391278999449251423175496738199495715e2 * t769 * t1037 * t771 - 0.24000000000000000000000000000000000000000000000000e2 * t1192 * t1152 * t117 - 0.14035736694323150897429372793021728356733892817027e2 * t1182 * t828 * t144 - 0.60000000000000000000000000000000000000000000000000e1 * t721 * t1256 * t117 - 0.66090502947826842110341677736429221600028304283916e1 * t1306 * t20 * t737 * t1309 + 0.13012297560362087811158481026863893997388713132452e0 * t1306 * t20 * t751 * t1076 - 0.19263893255070628432628962430736094246707082312994e1 * t1306 * t20 * t768 * t1071 + 0.41096000000000000000000000000000000000000000000000e0 * t1306 * t20 * t720 * t1322 + t1330 - t1335 + t1341 - t1355
  t1369 = 0.13012297560362087811158481026863893997388713132452e0 * t780 * t64 * t1096 + 0.67471172535210825687488420139294265171645179205307e-1 * t780 * t963 * t157 + 0.86748650402413918741056540179092626649258087549680e-1 * t780 * t686 * t785 - 0.12842595503380418955085974953824062831138054875329e1 * t780 * t686 * t793 - 0.38527786510141256865257924861472188493414164625988e1 * t780 * t64 * t1110 + t93 * (t1140 + t1196 + t1267 + t1356) - 0.61524113149298439949309167758941162080356015012483e4 * t155 * t902 * t753 * t1064 * t763 + 0.46785788981077169658097909310072427855779642723424e1 * t155 * t751 * t1026 * t145 - t1330 + t1335 - t1341 + t1355
  t1374 = f.my_piecewise3(t4, 0, t5 * (t943 + t1032 + t1094 + t1369) / 0.2e1)
  t1380 = t439 * t512
  t1386 = 0.1e1 / t34 / t260
  t1387 = t165 * t1386
  t1389 = t170 * t376
  t1392 = params.alpha_ab * (0.41888e5 / 0.81e2 * t1387 + 0.24640e5 / 0.81e2 * t1389)
  t1418 = -0.8e1 * t384 * t421 * t501 - 0.12e2 * t419 * t454 * t501 + 0.72e2 * t527 * t433 * t470 + 0.36e2 * t499 * t454 * t470 + 0.24e2 * t455 * t1380 - 0.2e1 * t508 * t1392 - 0.3e1 * t534 * t1392 - t537 * t1392 + 0.144e3 * t468 * t443 + 0.72e2 * t489 * t443 - 0.12e2 * t500 * t505 - 0.8e1 * t504 * t513 - 0.18e2 * t528 * t505 - 0.12e2 * t531 * t513
  t1420 = t435 ** 2
  t1421 = t469 ** 2
  t1422 = t1420 * t1421
  t1439 = t442 ** 2
  t1440 = t435 * t1439
  t1447 = t36 * t1386
  t1457 = t16 / t13 / t396 / r0
  t1463 = t399 * tau0
  t1473 = t476 * t469 * t442
  t1484 = 0.120e3 * t453 * t474 * t1422 - 0.240e3 * t467 * t474 * t478 + 0.360e3 * t430 / t431 / t420 * t1422 + 0.24e2 * t446 * t433 * t1422 - 0.96e2 * t488 * t433 * t478 + 0.36e2 * t434 * t1440 + 0.6e1 * t447 * t1440 + 0.18e2 * t455 * t1440 + (0.41888e5 / 0.81e2 * t374 * t1447 + 0.24640e5 / 0.81e2 * t381 * t377) * t392 + (0.1337600e7 / 0.81e2 * t395 * t1457 + 0.41888e5 / 0.81e2 * t403 * t1447 * t404 + 0.352000e6 / 0.27e2 * t403 * t1463 + 0.870400e6 / 0.81e2 * t412 * t252 + 0.49280e5 / 0.81e2 * t415 * t1389) * t421 - 0.360e3 * t475 * t1473 - 0.36e2 * t481 * t1473 - 0.144e3 * t492 * t1473 + 0.48e2 * t434 * t1380 + 0.8e1 * t447 * t1380
  t1487 = t163 * t816
  t1489 = s0 * t951 * t314
  t1499 = t291 * t185 + t229 * t200 - t201 * t231 - 0.2e1 * t243 * t231 - 0.3e1 * t307 * t231
  t1500 = t370 * t1499
  t1503 = t370 * t310
  t1506 = s0 / t188 * t314
  t1509 = t163 * t1499
  t1512 = t209 ** 2
  t1513 = t187 * t1512
  t1522 = -0.1232e4 / 0.27e2 * t213 * t377 - 0.880e3 / 0.27e2 * t218 * t214
  t1537 = -0.13376e5 / 0.27e2 * t248 * t399 - 0.1232e4 / 0.27e2 * t256 * t377 * t235 - 0.10880e5 / 0.27e2 * t256 * t408 - 0.3200e4 / 0.9e1 * t269 * t263 - 0.1760e4 / 0.27e2 * t276 * t416
  t1543 = -0.1232e4 / 0.27e2 * t509 - 0.880e3 / 0.27e2 * t416
  t1544 = params.alpha_ss * t1543
  t1550 = params.alpha_ss * (0.20944e5 / 0.81e2 * t1387 + 0.12320e5 / 0.81e2 * t1389)
  t1562 = t291 * t303
  t1563 = t187 * t195
  t1564 = t1563 * t209
  t1567 = t1563 * t1543
  t1572 = t229 * t239
  t1575 = -0.8e1 * t1522 * t185 * t231 - 0.12e2 * t1537 * t239 * t231 + 0.36e2 * t222 * t239 * t197 + 0.72e2 * t279 * t303 * t197 + 0.6e1 * t186 * t1513 + 0.18e2 * t240 * t1513 + 0.36e2 * t304 * t1513 - 0.12e2 * t292 * t1544 - t201 * t1550 - 0.3e1 * t307 * t1550 + 0.144e3 * t1562 * t1564 + 0.72e2 * t1572 * t1564 + 0.8e1 * t186 * t1567 + 0.48e2 * t304 * t1567
  t1579 = 0.1e1 / t238 / t183
  t1580 = t301 * t1579
  t1581 = t187 * params.alpha_ss
  t1583 = t1581 * t196 * t209
  t1586 = t164 * t239
  t1589 = t237 * t303
  t1611 = t222 * t185
  t1618 = t279 * t239
  t1623 = t1581 * t196 * t195
  t1629 = t187 ** 2
  t1630 = t196 ** 2
  t1631 = t1629 * t1630
  t1643 = 0.24e2 * t240 * t1567 - 0.360e3 * t1580 * t1583 - 0.36e2 * t1586 * t1583 - 0.144e3 * t1589 * t1583 + (0.20944e5 / 0.81e2 * t213 * t1447 + 0.12320e5 / 0.81e2 * t218 * t377) * t200 + (0.334400e6 / 0.81e2 * t248 * t1457 + 0.20944e5 / 0.81e2 * t256 * t1447 * t235 + 0.88000e5 / 0.27e2 * t256 * t1463 + 0.217600e6 / 0.81e2 * t269 * t252 + 0.24640e5 / 0.81e2 * t276 * t1389) * t185 - 0.12e2 * t1611 * t210 - 0.8e1 * t230 * t1544 - 0.2e1 * t243 * t1550 - 0.18e2 * t1618 * t210 - 0.240e3 * t291 * t1579 * t1623 + 0.360e3 * t301 / t238 / t184 * t1631 + 0.24e2 * t164 * t303 * t1631 - 0.96e2 * t229 * t303 * t1623 + 0.120e3 * t237 * t1579 * t1631
  t1660 = 0.11073470983333333333333333333333333333333333333333e-2 * t9 * t59 * t336 + 0.10000000000000000000000000000000000000000000000000e1 * t579 * t568 - 0.18311447306006545054854346104378990962041954983034e-3 * t613 * t553 * t15 * t353 - 0.58482236226346462072622386637590534819724553404280e0 * t632 * t628 - 0.2e1 * t163
  t1663 = t370 * t816
  t1687 = t499 * t392 + t527 * t421 + 0.12e2 * t434 * t470 + 0.2e1 * t447 * t470 + 0.6e1 * t455 * t470 - 0.4e1 * t504 * t501 - 0.6e1 * t531 * t501 - 0.2e1 * t508 * t505 - 0.3e1 * t534 * t505 - t537 * t505
  t1690 = t601 * t609
  t1697 = t575 * t566
  t1698 = t1697 * t567
  t1705 = 0.1e1 / t651 / t619
  t1706 = t635 * t625
  t1709 = 0.1e1 / t654 / t352
  t1710 = t1705 * t1706 * t1709
  t1714 = 0.1e1 / t651 / t349
  t1716 = t1714 * t1706 * t655
  t1722 = 0.1e1 / t324 / t330 * t7 / 0.4e1
  t1723 = t1722 * t951
  t1725 = t583 * t190
  t1726 = t582 * t1725
  t1728 = t553 * t938
  t1729 = t552 * t1728
  t1732 = t321 ** (-0.15e1)
  t1733 = t1732 * t7
  t1734 = t1733 * t951
  t1736 = t593 * t1725
  t1738 = t560 * t1728
  t1740 = t32 * t955
  t1742 = -0.34523333333333333333333333333333333333333333333333e1 * t1723 + 0.23015555555555555555555555555555555555555555555556e1 * t1726 - 0.26851481481481481481481481481481481481481481481482e1 * t1729 - 0.93932222222222222222222222222222222222222222222223e0 * t940 + 0.73355000000000000000000000000000000000000000000000e-1 * t1734 - 0.14671000000000000000000000000000000000000000000000e0 * t1736 - 0.17116166666666666666666666666666666666666666666667e0 * t1738 - 0.36793333333333333333333333333333333333333333333333e0 * t1740
  t1744 = t620 * t1742 * t627
  t1748 = t655 * t625
  t1753 = t652 * t1706 * t627
  t1757 = t627 * t646
  t1761 = t543 * t549
  t1765 = 0.48245938496077605200268890697218139186316165284153e2 * t607 * t1690 * t566 - 0.60000000000000000000000000000000000000000000000000e1 * t574 * t568 * t601 + 0.60000000000000000000000000000000000000000000000000e1 * t607 * t1698 - 0.32530743900905219527896202567159734993471782831130e-1 * t618 * t59 * t637 - 0.10254018858216406658218194626490193680059335835414e4 * t632 * t1710 + 0.10389515463408878255799889850284635099347639899143e3 * t632 * t1716 - 0.58482236226346462072622386637590534819724553404280e0 * t632 * t1744 - 0.51947577317044391278999449251423175496738199495715e2 * t632 * t652 * t646 * t1748 - 0.35089341735807877243573431982554320891834732042568e1 * t632 * t1753 + 0.35089341735807877243573431982554320891834732042568e1 * t632 * t634 * t625 * t1757 + 0.71233333333333333333333333333333333333333333333331e-1 * t12 * t1761 * t568
  t1769 = t15 * t606
  t1774 = 0.1e1 / t605 / t548
  t1775 = t323 * t1774
  t1777 = 0.1e1 / t608 / t335
  t1778 = t1697 * t1777
  t1782 = 0.1e1 / t605 / t332
  t1783 = t323 * t1782
  t1784 = t1697 * t609
  t1795 = -0.25319000000000000000000000000000000000000000000000e1 * t1723 + 0.16879333333333333333333333333333333333333333333333e1 * t1726 - 0.19692555555555555555555555555555555555555555555555e1 * t1729 - 0.93011851851851851851851851851851851851851851851854e0 * t940 + 0.13651666666666666666666666666666666666666666666667e0 * t1734 - 0.27303333333333333333333333333333333333333333333333e0 * t1736 - 0.31853888888888888888888888888888888888888888888890e0 * t1738 - 0.36514074074074074074074074074074074074074074074075e0 * t1740
  t1796 = t1795 * t567
  t1808 = 0.48245938496077605200268890697218139186316165284153e2 * t705 * t1327
  t1820 = 0.96491876992155210400537781394436278372632330568306e2 * t997 * t912 * t707
  t1822 = 0.10000000000000000000000000000000000000000000000000e1 * t55 * t990
  t1825 = 0.51726012919273400298984252201052768390886626637712e3 * t985 * t912 * t932
  t1828 = 0.34450798614814814814814814814814814814814814814813e-2 * t12 * t962 * t47
  t1835 = 0.10685000000000000000000000000000000000000000000000e0 * t557 * t909
  t1836 = t1808 + 0.48159733137676571081572406076840235616767705782485e0 * t780 * t64 * t793 - 0.21687162600603479685264135044773156662314521887420e-1 * t780 * t686 * t157 + 0.16265371950452609763948101283579867496735891415565e-1 * t780 * t64 * t789 - t1820 + t1822 + t1825 + t1828 + 0.10389515463408878255799889850284635099347639899143e3 * t155 * t1110 - 0.56968947174242584615102410102512416326352748836105e-3 * t150 * t939 * t151 + t1835
  t1838 = 0.71233333333333333333333333333333333333333333333331e-1 * t590 * t665
  t1840 = 0.53424999999999999999999999999999999999999999999999e-1 * t557 * t925
  t1842 = 0.85917975471764868594145516183295969534298037676861e0 * t557 * t920
  t1845 = 0.60000000000000000000000000000000000000000000000000e1 * t705 * t912 * t79
  t1847 = 0.60000000000000000000000000000000000000000000000000e1 * t670 * t1332
  t1891 = 0.10000000000000000000000000000000000000000000000000e1 * t111 * t1207 + 0.60000000000000000000000000000000000000000000000000e1 * t738 * t1227 * t117 + 0.35089341735807877243573431982554320891834732042568e1 * t769 * t1080 * t144 + 0.58482236226346462072622386637590534819724553404280e0 * t138 * t1170 + 0.10254018858216406658218194626490193680059335835414e4 * t1145 * t1080 * t1064 - 0.10389515463408878255799889850284635099347639899143e3 * t1182 * t1080 * t771 + 0.20690405167709360119593700880421107356354650655085e4 * t1160 * t1227 * t1154 - 0.19298375398431042080107556278887255674526466113661e3 * t1192 * t1227 * t740 - t1825 - t1845 + t1820 - t1822 - t1808 + t1847 - 0.60000000000000000000000000000000000000000000000000e1 * t721 * t1322 + 0.96491876992155210400537781394436278372632330568306e2 * t738 * t1309
  t1918 = -0.35089341735807877243573431982554320891834732042568e1 * t752 * t1076 + 0.51947577317044391278999449251423175496738199495715e2 * t769 * t1071 - t1828 - t1835 - t1838 + t1840 + t1842 - 0.51369999999999999999999999999999999999999999999999e-1 * t557 * t1128 + 0.21687162600603479685264135044773156662314521887420e-1 * t590 * t747 - 0.16265371950452609763948101283579867496735891415565e-1 * t557 * t1120 - 0.48159733137676571081572406076840235616767705782485e0 * t557 * t1123 + 0.32530743900905219527896202567159734993471782831130e-1 * t557 * t1248 + 0.10274000000000000000000000000000000000000000000000e0 * t557 * t1253 - 0.16522625736956710527585419434107305400007076070979e1 * t557 * t1245 + 0.68493333333333333333333333333333333333333333333332e-1 * t590 * t716 + 0.56968947174242584615102410102512416326352748836105e-3 * t12 * t962 * t130 + 0.16562821945185185185185185185185185185185185185185e-2 * t12 * t962 * t103
  t1921 = t1838 - t1840 - t1842 + t1845 - t1847 - 0.10254018858216406658218194626490193680059335835414e4 * t155 * t1082 - 0.58482236226346462072622386637590534819724553404280e0 * t155 * t1090 - 0.32530743900905219527896202567159734993471782831130e-1 * t780 * t64 * t785 - 0.51947577317044391278999449251423175496738199495715e2 * t155 * t768 * t763 * t1028 - 0.35089341735807877243573431982554320891834732042568e1 * t155 * t1096 + 0.35089341735807877243573431982554320891834732042568e1 * t155 * t751 * t143 * t764 + t93 * (t1891 + t1918)
  t1925 = f.my_piecewise3(t4, 0, t5 * (t1836 + t1921) / 0.2e1)
  t1939 = -0.53424999999999999999999999999999999999999999999999e-1 * t12 * t550 * t602 - 0.85917975471764868594145516183295969534298037676861e0 * t12 * t1769 * t610 + 0.51726012919273400298984252201052768390886626637712e3 * t1775 * t1778 - 0.96491876992155210400537781394436278372632330568306e2 * t1783 * t1784 + 0.10000000000000000000000000000000000000000000000000e1 * t579 * t1796 + 0.10685000000000000000000000000000000000000000000000e0 * t12 * t15 * t573 * t576 - 0.56968947174242584615102410102512416326352748836105e-3 * t613 * t553 * t938 * t353 - 0.2e1 * t1925 + 0.34450798614814814814814814814814814814814814814813e-2 * t9 * t939 * t336 - 0.21687162600603479685264135044773156662314521887420e-1 * t618 * t544 * t628 + 0.16265371950452609763948101283579867496735891415565e-1 * t618 * t59 * t648 + 0.48159733137676571081572406076840235616767705782485e0 * t618 * t59 * t656
  t1940 = t1765 + t1939
  t1961 = t601 ** 2
  t1984 = -0.57895126195293126240322668836661767023579398340984e3 * t1783 * t1690 * t575 + 0.36000000000000000000000000000000000000000000000000e2 * t607 * t576 * t601 - 0.2e1 * t1374 - 0.34367190188705947437658206473318387813719215070744e1 * t557 * t606 * t601 * t609 * t566 + 0.42740000000000000000000000000000000000000000000000e0 * t557 * t573 * t566 * t602 + 0.48245938496077605200268890697218139186316165284153e2 * t607 * t1961 * t609 - 0.42740000000000000000000000000000000000000000000000e0 * t12 * t1769 * t1698 + 0.68734380377411894875316412946636775627438430141488e1 * t12 * t15 * t1782 * t1784 + 0.18989649058080861538367470034170805442117582945368e-2 * t613 * t553 * t868 * t353 - 0.22161481481481481481481481481481481481481481481481e0 * t12 * t938 * t549 * t568 - 0.28493333333333333333333333333333333333333333333333e0 * t12 * t543 * t573 * t576
  t2012 = t655 * t646
  t2017 = t627 * t625
  t2024 = t575 ** 2
  t2031 = -0.21053605041484726346144059189532592535100839225540e2 * t632 * t653 * t1757 - 0.69263436422725855038665932335230900662317599327620e2 * t632 * t652 * t1742 * t1748 - 0.36846163202829085479643115651216588683774907041596e2 * t12 * t15 * t1774 * t1778 + 0.14246666666666666666666666666666666666666666666666e0 * t12 * t1761 * t602 + 0.22911460125803964958438804315545591875812810047162e1 * t12 * t543 * t606 * t610 - 0.71233333333333333333333333333333333333333333333332e-1 * t12 * t550 * t1796 - 0.61524113149298439949309167758941162080356015012483e4 * t632 * t1705 * t635 * t1709 * t646 + 0.62337092780453269534799339101707810596085839394858e3 * t632 * t1714 * t635 * t2012 + 0.46785788981077169658097909310072427855779642723424e1 * t632 * t634 * t1742 * t2017 + 0.86748650402413918741056540179092626649258087549680e-1 * t618 * t544 * t637 - 0.24000000000000000000000000000000000000000000000000e2 * t1783 * t2024 * t567 + 0.57895126195293126240322668836661767023579398340984e3 * t1775 * t2024 * t609
  t2033 = t342 * t12
  t2058 = t605 ** 2
  t2061 = t608 ** 2
  t2080 = 0.1e1 / t324 / t841 * t7 * t272 * t12 / 0.48e2
  t2082 = t1722 * t859
  t2084 = t583 * t204
  t2085 = t582 * t2084
  t2087 = t553 * t868
  t2088 = t552 * t2087
  t2090 = t9 * t869
  t2092 = t321 ** (-0.25e1)
  t2095 = t2092 * t7 * t272 * t12
  t2097 = t1733 * t859
  t2099 = t593 * t2084
  t2101 = t560 * t2087
  t2103 = t32 * t863
  t2115 = -0.13012297560362087811158481026863893997388713132452e0 * t2033 * t15 * t634 * t2017 * t646 + 0.19263893255070628432628962430736094246707082312994e1 * t2033 * t15 * t652 * t2012 * t625 + 0.31035607751564040179390551320631661034531975982628e4 * t1775 * t601 * t1777 * t575 - 0.80000000000000000000000000000000000000000000000000e1 * t574 * t568 * t1795 + 0.64327917994770140267025187596290852248421553712204e2 * t607 * t1795 * t609 * t566 - 0.11483599538271604938271604938271604938271604938271e-1 * t9 * t869 * t336 + 0.24955700379505800914252936827276051226357058527653e5 * t323 / t2058 * t2024 / t2061 - 0.60000000000000000000000000000000000000000000000000e1 * t574 * t1961 * t567 - 0.62071215503128080358781102641263322069063951965254e4 * t323 / t605 / t572 * t2024 * t1777 + 0.10000000000000000000000000000000000000000000000000e1 * t579 * (-0.21099166666666666666666666666666666666666666666667e1 * t2080 + 0.20255200000000000000000000000000000000000000000000e2 * t2082 - 0.75019259259259259259259259259259259259259259259258e1 * t2085 + 0.65641851851851851851851851851851851851851851851850e1 * t2088 + 0.31003950617283950617283950617283950617283950617285e1 * t2090 + 0.68258333333333333333333333333333333333333333333335e-1 * t2095 - 0.10921333333333333333333333333333333333333333333333e1 * t2097 + 0.12134814814814814814814814814814814814814814814815e1 * t2099 + 0.10617962962962962962962962962962962962962962962963e1 * t2101 + 0.13388493827160493827160493827160493827160493827161e1 * t2103) * t567 + 0.13012297560362087811158481026863893997388713132452e0 * t618 * t59 * t1753 - 0.43374325201206959370528270089546313324629043774840e-1 * t618 * t544 * t648
  t2148 = t635 ** 2
  t2157 = t651 ** 2
  t2160 = t654 ** 2
  t2169 = t646 ** 2
  t2178 = -0.12842595503380418955085974953824062831138054875329e1 * t618 * t544 * t656 + 0.67471172535210825687488420139294265171645179205307e-1 * t618 * t939 * t628 - 0.38527786510141256865257924861472188493414164625988e1 * t618 * t59 * t1716 + 0.38025319932552508024225805073234468230220037056326e2 * t618 * t59 * t1710 + 0.21687162600603479685264135044773156662314521887420e-1 * t618 * t59 * t1744 - 0.58482236226346462072622386637590534819724553404280e0 * t632 * t620 * (-0.28769444444444444444444444444444444444444444444444e1 * t2080 + 0.27618666666666666666666666666666666666666666666667e2 * t2082 - 0.10229135802469135802469135802469135802469135802469e2 * t2085 + 0.89504938271604938271604938271604938271604938271607e1 * t2088 + 0.31310740740740740740740740740740740740740740740741e1 * t2090 + 0.36677500000000000000000000000000000000000000000000e-1 * t2095 - 0.58684000000000000000000000000000000000000000000000e0 * t2097 + 0.65204444444444444444444444444444444444444444444445e0 * t2099 + 0.57053888888888888888888888888888888888888888888890e0 * t2101 + 0.13490888888888888888888888888888888888888888888889e1 * t2103) * t627 + 0.12304822629859687989861833551788232416071203002497e5 * t632 / t651 / t633 * t2148 * t1709 - 0.62337092780453269534799339101707810596085839394858e3 * t632 * t1705 * t2148 * t655 - 0.91082604192152556048340974007871726131433263376469e5 * t632 / t2157 * t2148 / t2160 + 0.14035736694323150897429372793021728356733892817027e2 * t632 * t1714 * t2148 * t627 + 0.35089341735807877243573431982554320891834732042568e1 * t632 * t634 * t2169 * t627 - 0.51947577317044391278999449251423175496738199495715e2 * t632 * t652 * t2169 * t655
  t2185 = t446 / t390 + t453 * t392 + t430 * t421
  t2218 = t1522 * t200 + t1537 * t185 - t201 * t1544 - 0.2e1 * t243 * t1544 - 0.3e1 * t307 * t1544 + 0.36e2 * t1562 * t197 + 0.6e1 * t186 * t1564 + 0.18e2 * t240 * t1564 + 0.36e2 * t304 * t1564 + 0.18e2 * t1572 * t197 - 0.60e2 * t1580 * t1623 - 0.6e1 * t1586 * t1623 - 0.24e2 * t1589 * t1623 - 0.6e1 * t1611 * t231 - 0.9e1 * t1618 * t231 - 0.6e1 * t230 * t210 - 0.9e1 * t292 * t210
  t2219 = t370 * t2218
  t2221 = t799 * t1499
  t2224 = t1925 * t816
  t2232 = 0.12e2 * t799 * t310 * t317 + 0.2e1 * t1374 * t816 * t317 + t372 * (t1418 + t1484) + 0.6e1 * t1487 * t1489 + 0.6e1 * t1500 * t1489 - 0.3e1 * t1503 * t1506 - 0.6e1 * t1509 * t1506 + 0.2e1 * t370 * (t1575 + t1643) * t317 + 0.4e1 * t1660 * t539 - 0.6e1 * t1663 * s0 * t859 * t314 - 0.3e1 * t817 * t1506 + 0.6e1 * t801 * t1687 + 0.4e1 * t1940 * t809 + 0.3e1 * t311 * t820 + (t1984 + t2031 + t2115 + t2178) * t2185 + t2219 * t820 + 0.3e1 * t2221 * t820 + t2224 * t820 + 0.8e1 * t1925 * t1499 * t317 + 0.8e1 * t163 * t2218 * t317
  v4rho4_0_ = r0 * t2232 - 0.6e1 * t1487 * t1506 + 0.6e1 * t1663 * t1489 - 0.6e1 * t1500 * t1506 + 0.3e1 * t1503 * t820 + 0.6e1 * t1509 * t820 + 0.12e2 * t1660 * t1687 + 0.4e1 * t1940 * t2185 + 0.8e1 * t2219 * t317 + 0.24e2 * t2221 * t317 + 0.8e1 * t2224 * t317 + 0.24e2 * t311 * t317 + 0.4e1 * t372 * t539 + 0.12e2 * t801 * t809 + 0.3e1 * t817 * t820

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t2 = r0 - r1
  t3 = r0 + r1
  t4 = 0.1e1 / t3
  t5 = t2 * t4
  t6 = 0.1e1 + t5
  t7 = t6 <= f.p.zeta_threshold
  t8 = r0 <= f.p.dens_threshold or t7
  t9 = t3 ** 2
  t10 = 0.1e1 / t9
  t11 = t2 * t10
  t12 = t4 - t11
  t13 = f.my_piecewise3(t7, 0, t12)
  t14 = 3 ** (0.1e1 / 0.3e1)
  t16 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t17 = t14 * t16
  t18 = 4 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t20 = t17 * t19
  t21 = t3 ** (0.1e1 / 0.3e1)
  t22 = 0.1e1 / t21
  t23 = 2 ** (0.1e1 / 0.3e1)
  t24 = t22 * t23
  t25 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t26 = 0.1e1 / t25
  t27 = t6 ** (0.1e1 / 0.3e1)
  t29 = f.my_piecewise3(t7, t26, 0.1e1 / t27)
  t31 = t20 * t24 * t29
  t33 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t31
  t34 = jnp.sqrt(t31)
  t37 = t31 ** 0.15e1
  t39 = t14 ** 2
  t40 = t16 ** 2
  t41 = t39 * t40
  t42 = t41 * t18
  t43 = t21 ** 2
  t44 = 0.1e1 / t43
  t45 = t23 ** 2
  t46 = t44 * t45
  t47 = t29 ** 2
  t49 = t42 * t46 * t47
  t51 = 0.37978500000000000000000000000000000000000000000000e1 * t34 + 0.89690000000000000000000000000000000000000000000000e0 * t31 + 0.20477500000000000000000000000000000000000000000000e0 * t37 + 0.12323500000000000000000000000000000000000000000000e0 * t49
  t54 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t51
  t55 = jnp.log(t54)
  t57 = 0.621814e-1 * t33 * t55
  t59 = t25 * f.p.zeta_threshold
  t61 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t59, 0.2e1 * t23)
  t63 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t59, 0)
  t67 = 0.1e1 / (0.2e1 * t23 - 0.2e1)
  t68 = (t61 + t63 - 0.2e1) * t67
  t70 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t31
  t75 = 0.70594500000000000000000000000000000000000000000000e1 * t34 + 0.15494250000000000000000000000000000000000000000000e1 * t31 + 0.42077500000000000000000000000000000000000000000000e0 * t37 + 0.15629250000000000000000000000000000000000000000000e0 * t49
  t78 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t75
  t79 = jnp.log(t78)
  t83 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t31
  t88 = 0.51785000000000000000000000000000000000000000000000e1 * t34 + 0.90577500000000000000000000000000000000000000000000e0 * t31 + 0.11003250000000000000000000000000000000000000000000e0 * t37 + 0.12417750000000000000000000000000000000000000000000e0 * t49
  t91 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t88
  t92 = jnp.log(t91)
  t93 = t83 * t92
  t99 = -t57 + t68 * (-0.3109070e-1 * t70 * t79 + t57 - 0.19751673498613801407483339618206552048944131217655e-1 * t93) + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t93
  t101 = f.my_piecewise3(t7, f.p.zeta_threshold, t6)
  t103 = 0.1e1 / t21 / t3
  t104 = t103 * t23
  t106 = t20 * t104 * t29
  t107 = 0.17808333333333333333333333333333333333333333333333e-1 * t106
  t108 = t27 * t6
  t109 = 0.1e1 / t108
  t112 = f.my_piecewise3(t7, 0, -t109 * t12 / 0.3e1)
  t114 = t20 * t24 * t112
  t116 = -t107 + 0.53425000000000000000000000000000000000000000000000e-1 * t114
  t118 = 0.621814e-1 * t116 * t55
  t119 = t51 ** 2
  t120 = 0.1e1 / t119
  t121 = t33 * t120
  t122 = 0.1e1 / t34
  t123 = t106 / 0.3e1
  t124 = -t123 + t114
  t125 = t122 * t124
  t127 = 0.29896666666666666666666666666666666666666666666667e0 * t106
  t129 = t31 ** 0.5e0
  t130 = t129 * t124
  t133 = 0.1e1 / t43 / t3
  t134 = t133 * t45
  t136 = t42 * t134 * t47
  t137 = 0.82156666666666666666666666666666666666666666666667e-1 * t136
  t138 = t29 * t112
  t140 = t42 * t46 * t138
  t142 = 0.18989250000000000000000000000000000000000000000000e1 * t125 - t127 + 0.89690000000000000000000000000000000000000000000000e0 * t114 + 0.30716250000000000000000000000000000000000000000000e0 * t130 - t137 + 0.24647000000000000000000000000000000000000000000000e0 * t140
  t143 = 0.1e1 / t54
  t144 = t142 * t143
  t146 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * t144
  t147 = 0.17123333333333333333333333333333333333333333333333e-1 * t106
  t149 = -t147 + 0.51370000000000000000000000000000000000000000000000e-1 * t114
  t152 = t75 ** 2
  t153 = 0.1e1 / t152
  t154 = t70 * t153
  t156 = 0.51647500000000000000000000000000000000000000000000e0 * t106
  t159 = 0.10419500000000000000000000000000000000000000000000e0 * t136
  t161 = 0.35297250000000000000000000000000000000000000000000e1 * t125 - t156 + 0.15494250000000000000000000000000000000000000000000e1 * t114 + 0.63116250000000000000000000000000000000000000000000e0 * t130 - t159 + 0.31258500000000000000000000000000000000000000000000e0 * t140
  t162 = 0.1e1 / t78
  t163 = t161 * t162
  t166 = 0.92708333333333333333333333333333333333333333333333e-2 * t106
  t168 = -t166 + 0.27812500000000000000000000000000000000000000000000e-1 * t114
  t169 = t168 * t92
  t171 = t88 ** 2
  t172 = 0.1e1 / t171
  t173 = t83 * t172
  t175 = 0.30192500000000000000000000000000000000000000000000e0 * t106
  t178 = 0.82785000000000000000000000000000000000000000000000e-1 * t136
  t180 = 0.25892500000000000000000000000000000000000000000000e1 * t125 - t175 + 0.90577500000000000000000000000000000000000000000000e0 * t114 + 0.16504875000000000000000000000000000000000000000000e0 * t130 - t178 + 0.24835500000000000000000000000000000000000000000000e0 * t140
  t181 = 0.1e1 / t91
  t182 = t180 * t181
  t189 = t68 * t83
  t191 = t172 * t180 * t181
  t194 = -t118 + t146 + t68 * (-0.3109070e-1 * t149 * t79 + 0.10000000000000000000000000000000000000000000000000e1 * t154 * t163 + t118 - t146 - 0.19751673498613801407483339618206552048944131217655e-1 * t169 + 0.58482236226346462072622386637590534819724553404280e0 * t173 * t182) + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t169 - 0.58482236226346462072622386637590534819724553404280e0 * t189 * t191
  t198 = f.my_piecewise3(t8, 0, t101 * t194 / 0.2e1 + t13 * t99 / 0.2e1)
  t199 = params.dss[0]
  t200 = r0 ** 2
  t201 = r0 ** (0.1e1 / 0.3e1)
  t202 = t201 ** 2
  t204 = 0.1e1 / t202 / t200
  t205 = s0 * t204
  t209 = 0.2e1 * tau0 / t202 / r0
  t210 = 6 ** (0.1e1 / 0.3e1)
  t211 = t210 ** 2
  t212 = jnp.pi ** 2
  t213 = t212 ** (0.1e1 / 0.3e1)
  t214 = t213 ** 2
  t215 = t211 * t214
  t216 = 0.3e1 / 0.5e1 * t215
  t219 = 0.1e1 + params.alpha_ss * (t205 + t209 - t216)
  t222 = params.dss[1]
  t223 = t222 * s0
  t225 = params.dss[2]
  t226 = t209 - t216
  t228 = t223 * t204 + t225 * t226
  t229 = t219 ** 2
  t230 = 0.1e1 / t229
  t232 = params.dss[3]
  t233 = s0 ** 2
  t234 = t232 * t233
  t235 = t200 ** 2
  t238 = 0.1e1 / t201 / t235 / r0
  t240 = params.dss[4]
  t241 = t240 * s0
  t244 = params.dss[5]
  t245 = t226 ** 2
  t247 = t241 * t204 * t226 + t234 * t238 + t244 * t245
  t249 = 0.1e1 / t229 / t219
  t251 = t199 / t219 + t228 * t230 + t247 * t249
  t252 = t198 * t251
  t255 = 0.1e1 / tau0
  t258 = 0.1e1 - s0 / r0 * t255 / 0.8e1
  t259 = t252 * t258
  t263 = f.my_piecewise3(t8, 0, t101 * t99 / 0.2e1)
  t264 = t199 * t230
  t265 = t200 * r0
  t267 = 0.1e1 / t202 / t265
  t268 = s0 * t267
  t270 = tau0 * t204
  t272 = -0.8e1 / 0.3e1 * t268 - 0.10e2 / 0.3e1 * t270
  t273 = params.alpha_ss * t272
  t277 = t225 * tau0
  t280 = -0.8e1 / 0.3e1 * t223 * t267 - 0.10e2 / 0.3e1 * t277 * t204
  t282 = t228 * t249
  t287 = 0.1e1 / t201 / t235 / t200
  t296 = t244 * t226
  t299 = -0.16e2 / 0.3e1 * t234 * t287 - 0.8e1 / 0.3e1 * t241 * t267 * t226 - 0.10e2 / 0.3e1 * t241 * t238 * tau0 - 0.20e2 / 0.3e1 * t296 * t270
  t301 = t229 ** 2
  t302 = 0.1e1 / t301
  t303 = t247 * t302
  t306 = t280 * t230 + t299 * t249 - t264 * t273 - 0.2e1 * t282 * t273 - 0.3e1 * t303 * t273
  t307 = t263 * t306
  t308 = t307 * t258
  t310 = t263 * t251
  t313 = s0 / t200 * t255
  t314 = t310 * t313
  t317 = 0.1e1 - t5
  t318 = t317 <= f.p.zeta_threshold
  t319 = r1 <= f.p.dens_threshold or t318
  t320 = -t12
  t321 = f.my_piecewise3(t318, 0, t320)
  t322 = t317 ** (0.1e1 / 0.3e1)
  t324 = f.my_piecewise3(t318, t26, 0.1e1 / t322)
  t326 = t20 * t24 * t324
  t328 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t326
  t329 = jnp.sqrt(t326)
  t332 = t326 ** 0.15e1
  t334 = t324 ** 2
  t336 = t42 * t46 * t334
  t338 = 0.37978500000000000000000000000000000000000000000000e1 * t329 + 0.89690000000000000000000000000000000000000000000000e0 * t326 + 0.20477500000000000000000000000000000000000000000000e0 * t332 + 0.12323500000000000000000000000000000000000000000000e0 * t336
  t341 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t338
  t342 = jnp.log(t341)
  t344 = 0.621814e-1 * t328 * t342
  t346 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t326
  t351 = 0.70594500000000000000000000000000000000000000000000e1 * t329 + 0.15494250000000000000000000000000000000000000000000e1 * t326 + 0.42077500000000000000000000000000000000000000000000e0 * t332 + 0.15629250000000000000000000000000000000000000000000e0 * t336
  t354 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t351
  t355 = jnp.log(t354)
  t359 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t326
  t364 = 0.51785000000000000000000000000000000000000000000000e1 * t329 + 0.90577500000000000000000000000000000000000000000000e0 * t326 + 0.11003250000000000000000000000000000000000000000000e0 * t332 + 0.12417750000000000000000000000000000000000000000000e0 * t336
  t367 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t364
  t368 = jnp.log(t367)
  t369 = t359 * t368
  t375 = -t344 + t68 * (-0.3109070e-1 * t346 * t355 + t344 - 0.19751673498613801407483339618206552048944131217655e-1 * t369) + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t369
  t377 = f.my_piecewise3(t318, f.p.zeta_threshold, t317)
  t379 = t20 * t104 * t324
  t380 = 0.17808333333333333333333333333333333333333333333333e-1 * t379
  t381 = t322 * t317
  t382 = 0.1e1 / t381
  t385 = f.my_piecewise3(t318, 0, -t382 * t320 / 0.3e1)
  t387 = t20 * t24 * t385
  t389 = -t380 + 0.53425000000000000000000000000000000000000000000000e-1 * t387
  t391 = 0.621814e-1 * t389 * t342
  t392 = t338 ** 2
  t393 = 0.1e1 / t392
  t394 = t328 * t393
  t395 = 0.1e1 / t329
  t396 = t379 / 0.3e1
  t397 = -t396 + t387
  t398 = t395 * t397
  t400 = 0.29896666666666666666666666666666666666666666666667e0 * t379
  t402 = t326 ** 0.5e0
  t403 = t402 * t397
  t406 = t42 * t134 * t334
  t407 = 0.82156666666666666666666666666666666666666666666667e-1 * t406
  t408 = t324 * t385
  t410 = t42 * t46 * t408
  t412 = 0.18989250000000000000000000000000000000000000000000e1 * t398 - t400 + 0.89690000000000000000000000000000000000000000000000e0 * t387 + 0.30716250000000000000000000000000000000000000000000e0 * t403 - t407 + 0.24647000000000000000000000000000000000000000000000e0 * t410
  t413 = 0.1e1 / t341
  t414 = t412 * t413
  t416 = 0.10000000000000000000000000000000000000000000000000e1 * t394 * t414
  t417 = 0.17123333333333333333333333333333333333333333333333e-1 * t379
  t419 = -t417 + 0.51370000000000000000000000000000000000000000000000e-1 * t387
  t422 = t351 ** 2
  t423 = 0.1e1 / t422
  t424 = t346 * t423
  t426 = 0.51647500000000000000000000000000000000000000000000e0 * t379
  t429 = 0.10419500000000000000000000000000000000000000000000e0 * t406
  t431 = 0.35297250000000000000000000000000000000000000000000e1 * t398 - t426 + 0.15494250000000000000000000000000000000000000000000e1 * t387 + 0.63116250000000000000000000000000000000000000000000e0 * t403 - t429 + 0.31258500000000000000000000000000000000000000000000e0 * t410
  t432 = 0.1e1 / t354
  t433 = t431 * t432
  t436 = 0.92708333333333333333333333333333333333333333333333e-2 * t379
  t438 = -t436 + 0.27812500000000000000000000000000000000000000000000e-1 * t387
  t439 = t438 * t368
  t441 = t364 ** 2
  t442 = 0.1e1 / t441
  t443 = t359 * t442
  t445 = 0.30192500000000000000000000000000000000000000000000e0 * t379
  t448 = 0.82785000000000000000000000000000000000000000000000e-1 * t406
  t450 = 0.25892500000000000000000000000000000000000000000000e1 * t398 - t445 + 0.90577500000000000000000000000000000000000000000000e0 * t387 + 0.16504875000000000000000000000000000000000000000000e0 * t403 - t448 + 0.24835500000000000000000000000000000000000000000000e0 * t410
  t451 = 0.1e1 / t367
  t452 = t450 * t451
  t459 = t68 * t359
  t461 = t442 * t450 * t451
  t464 = -t391 + t416 + t68 * (-0.3109070e-1 * t419 * t355 + 0.10000000000000000000000000000000000000000000000000e1 * t424 * t433 + t391 - t416 - 0.19751673498613801407483339618206552048944131217655e-1 * t439 + 0.58482236226346462072622386637590534819724553404280e0 * t443 * t452) + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t439 - 0.58482236226346462072622386637590534819724553404280e0 * t459 * t461
  t468 = f.my_piecewise3(t319, 0, t321 * t375 / 0.2e1 + t377 * t464 / 0.2e1)
  t469 = r1 ** 2
  t470 = r1 ** (0.1e1 / 0.3e1)
  t471 = t470 ** 2
  t473 = 0.1e1 / t471 / t469
  t474 = s2 * t473
  t478 = 0.2e1 * tau1 / t471 / r1
  t481 = 0.1e1 + params.alpha_ss * (t474 + t478 - t216)
  t484 = t222 * s2
  t486 = t478 - t216
  t488 = t225 * t486 + t484 * t473
  t489 = t481 ** 2
  t490 = 0.1e1 / t489
  t492 = s2 ** 2
  t493 = t232 * t492
  t494 = t469 ** 2
  t497 = 0.1e1 / t470 / t494 / r1
  t499 = t240 * s2
  t502 = t486 ** 2
  t504 = t499 * t473 * t486 + t244 * t502 + t493 * t497
  t506 = 0.1e1 / t489 / t481
  t508 = t199 / t481 + t488 * t490 + t504 * t506
  t509 = t468 * t508
  t512 = 0.1e1 / tau1
  t515 = 0.1e1 - s2 / r1 * t512 / 0.8e1
  t516 = t509 * t515
  t518 = t19 * t103
  t520 = t17 * t19 * t22
  t521 = jnp.sqrt(t520)
  t524 = t520 ** 0.15e1
  t527 = t41 * t18 * t44
  t529 = 0.37978500000000000000000000000000000000000000000000e1 * t521 + 0.89690000000000000000000000000000000000000000000000e0 * t520 + 0.20477500000000000000000000000000000000000000000000e0 * t524 + 0.12323500000000000000000000000000000000000000000000e0 * t527
  t532 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t529
  t533 = jnp.log(t532)
  t536 = 0.11073470983333333333333333333333333333333333333333e-2 * t17 * t518 * t533
  t538 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t520
  t539 = t529 ** 2
  t540 = 0.1e1 / t539
  t541 = t538 * t540
  t543 = 0.1e1 / t521 * t14
  t544 = t16 * t19
  t545 = t544 * t103
  t546 = t543 * t545
  t548 = t17 * t518
  t550 = t520 ** 0.5e0
  t551 = t550 * t14
  t552 = t551 * t545
  t555 = t41 * t18 * t133
  t557 = -0.63297500000000000000000000000000000000000000000000e0 * t546 - 0.29896666666666666666666666666666666666666666666667e0 * t548 - 0.10238750000000000000000000000000000000000000000000e0 * t552 - 0.82156666666666666666666666666666666666666666666667e-1 * t555
  t558 = 0.1e1 / t532
  t559 = t557 * t558
  t561 = 0.10000000000000000000000000000000000000000000000000e1 * t541 * t559
  t562 = t2 ** 2
  t563 = t562 * t2
  t564 = t9 ** 2
  t565 = 0.1e1 / t564
  t566 = t563 * t565
  t567 = f.my_piecewise3(t7, t59, t108)
  t568 = f.my_piecewise3(t318, t59, t381)
  t570 = (t567 + t568 - 0.2e1) * t67
  t572 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t520
  t577 = 0.70594500000000000000000000000000000000000000000000e1 * t521 + 0.15494250000000000000000000000000000000000000000000e1 * t520 + 0.42077500000000000000000000000000000000000000000000e0 * t524 + 0.15629250000000000000000000000000000000000000000000e0 * t527
  t580 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t577
  t581 = jnp.log(t580)
  t585 = 0.621814e-1 * t538 * t533
  t587 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t520
  t592 = 0.51785000000000000000000000000000000000000000000000e1 * t521 + 0.90577500000000000000000000000000000000000000000000e0 * t520 + 0.11003250000000000000000000000000000000000000000000e0 * t524 + 0.12417750000000000000000000000000000000000000000000e0 * t527
  t595 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t592
  t596 = jnp.log(t595)
  t597 = t587 * t596
  t599 = -0.3109070e-1 * t572 * t581 + t585 - 0.19751673498613801407483339618206552048944131217655e-1 * t597
  t600 = t570 * t599
  t602 = 0.4e1 * t566 * t600
  t603 = t562 ** 2
  t605 = 0.1e1 / t564 / t3
  t606 = t603 * t605
  t608 = 0.4e1 * t606 * t600
  t609 = t603 * t565
  t612 = f.my_piecewise3(t7, 0, 0.4e1 / 0.3e1 * t27 * t12)
  t615 = f.my_piecewise3(t318, 0, 0.4e1 / 0.3e1 * t322 * t320)
  t617 = (t612 + t615) * t67
  t618 = t617 * t599
  t623 = t577 ** 2
  t624 = 0.1e1 / t623
  t625 = t572 * t624
  t630 = -0.11765750000000000000000000000000000000000000000000e1 * t546 - 0.51647500000000000000000000000000000000000000000000e0 * t548 - 0.21038750000000000000000000000000000000000000000000e0 * t552 - 0.10419500000000000000000000000000000000000000000000e0 * t555
  t631 = 0.1e1 / t580
  t632 = t630 * t631
  t638 = t592 ** 2
  t639 = 0.1e1 / t638
  t640 = t587 * t639
  t645 = -0.86308333333333333333333333333333333333333333333334e0 * t546 - 0.30192500000000000000000000000000000000000000000000e0 * t548 - 0.55016250000000000000000000000000000000000000000000e-1 * t552 - 0.82785000000000000000000000000000000000000000000000e-1 * t555
  t646 = 0.1e1 / t595
  t647 = t645 * t646
  t650 = 0.53237641966666666666666666666666666666666666666666e-3 * t17 * t518 * t581 + 0.10000000000000000000000000000000000000000000000000e1 * t625 * t632 - t536 - t561 + 0.18311447306006545054854346104378990962041954983034e-3 * t17 * t518 * t596 + 0.58482236226346462072622386637590534819724553404280e0 * t640 * t647
  t651 = t570 * t650
  t652 = t609 * t651
  t655 = t570 * t14
  t657 = t544 * t103 * t596
  t659 = 0.18311447306006545054854346104378990962041954983034e-3 * t655 * t657
  t660 = t570 * t587
  t662 = t639 * t645 * t646
  t664 = 0.58482236226346462072622386637590534819724553404280e0 * t660 * t662
  t665 = t536 + t561 + t602 - t608 + t609 * t618 + t652 + 0.19751673498613801407483339618206552048944131217655e-1 * t617 * t597 - t659 - t664 - t198 - t468
  t666 = params.dab[0]
  t667 = 0.6e1 / 0.5e1 * t215
  t670 = 0.1e1 + params.alpha_ab * (t205 + t474 + t209 + t478 - t667)
  t673 = params.dab[1]
  t674 = t205 + t474
  t676 = params.dab[2]
  t677 = t209 + t478 - t667
  t679 = t673 * t674 + t676 * t677
  t680 = t670 ** 2
  t681 = 0.1e1 / t680
  t683 = params.dab[3]
  t684 = t674 ** 2
  t686 = params.dab[4]
  t687 = t686 * t674
  t689 = params.dab[5]
  t690 = t677 ** 2
  t692 = t687 * t677 + t683 * t684 + t689 * t690
  t694 = 0.1e1 / t680 / t670
  t696 = t666 / t670 + t679 * t681 + t692 * t694
  t697 = t665 * t696
  t704 = f.my_piecewise3(t319, 0, t377 * t375 / 0.2e1)
  t705 = -t585 + t609 * t600 + 0.19751673498613801407483339618206552048944131217655e-1 * t570 * t597 - t263 - t704
  t706 = t666 * t681
  t707 = params.alpha_ab * t272
  t709 = t673 * s0
  t712 = t676 * tau0
  t715 = -0.8e1 / 0.3e1 * t709 * t267 - 0.10e2 / 0.3e1 * t712 * t204
  t717 = t679 * t694
  t720 = t683 * t674
  t723 = t686 * s0
  t729 = t689 * t677
  t732 = -0.16e2 / 0.3e1 * t720 * t268 - 0.8e1 / 0.3e1 * t723 * t267 * t677 - 0.10e2 / 0.3e1 * t687 * t270 - 0.20e2 / 0.3e1 * t729 * t270
  t734 = t680 ** 2
  t735 = 0.1e1 / t734
  t736 = t692 * t735
  t739 = t715 * t681 + t732 * t694 - t706 * t707 - 0.2e1 * t717 * t707 - 0.3e1 * t736 * t707
  t740 = t705 * t739
  t743 = 0.1e1 / t9 / t3
  t744 = t2 * t743
  t746 = -0.2e1 * t10 + 0.2e1 * t744
  t747 = f.my_piecewise3(t7, 0, t746)
  t752 = 0.1e1 / t21 / t9
  t753 = t752 * t23
  t755 = t20 * t753 * t29
  t756 = 0.23744444444444444444444444444444444444444444444444e-1 * t755
  t758 = t20 * t104 * t112
  t760 = t6 ** 2
  t762 = 0.1e1 / t27 / t760
  t763 = t12 ** 2
  t769 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t762 * t763 - t109 * t746 / 0.3e1)
  t771 = t20 * t24 * t769
  t775 = 0.621814e-1 * (t756 - 0.35616666666666666666666666666666666666666666666666e-1 * t758 + 0.53425000000000000000000000000000000000000000000000e-1 * t771) * t55
  t776 = t116 * t120
  t778 = 0.20000000000000000000000000000000000000000000000000e1 * t776 * t144
  t781 = t33 / t119 / t51
  t782 = t142 ** 2
  t785 = 0.20000000000000000000000000000000000000000000000000e1 * t781 * t782 * t143
  t787 = 0.1e1 / t34 / t31
  t788 = t124 ** 2
  t789 = t787 * t788
  t791 = 0.4e1 / 0.9e1 * t755
  t793 = t791 - 0.2e1 / 0.3e1 * t758 + t771
  t794 = t122 * t793
  t796 = 0.39862222222222222222222222222222222222222222222223e0 * t755
  t799 = t31 ** (-0.5e0)
  t800 = t799 * t788
  t802 = t129 * t793
  t805 = 0.1e1 / t43 / t9
  t806 = t805 * t45
  t808 = t42 * t806 * t47
  t809 = 0.13692777777777777777777777777777777777777777777778e0 * t808
  t811 = t42 * t134 * t138
  t813 = t112 ** 2
  t815 = t42 * t46 * t813
  t819 = t42 * t46 * t29 * t769
  t821 = -0.94946250000000000000000000000000000000000000000000e0 * t789 + 0.18989250000000000000000000000000000000000000000000e1 * t794 + t796 - 0.59793333333333333333333333333333333333333333333334e0 * t758 + 0.89690000000000000000000000000000000000000000000000e0 * t771 + 0.15358125000000000000000000000000000000000000000000e0 * t800 + 0.30716250000000000000000000000000000000000000000000e0 * t802 + t809 - 0.32862666666666666666666666666666666666666666666666e0 * t811 + 0.24647000000000000000000000000000000000000000000000e0 * t815 + 0.24647000000000000000000000000000000000000000000000e0 * t819
  t824 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * t821 * t143
  t825 = t119 ** 2
  t827 = t33 / t825
  t828 = t54 ** 2
  t829 = 0.1e1 / t828
  t832 = 0.16081979498692535066756296899072713062105388428051e2 * t827 * t782 * t829
  t833 = 0.22831111111111111111111111111111111111111111111111e-1 * t755
  t839 = t149 * t153
  t844 = t70 / t152 / t75
  t845 = t161 ** 2
  t851 = 0.68863333333333333333333333333333333333333333333333e0 * t755
  t856 = 0.17365833333333333333333333333333333333333333333333e0 * t808
  t860 = -0.17648625000000000000000000000000000000000000000000e1 * t789 + 0.35297250000000000000000000000000000000000000000000e1 * t794 + t851 - 0.10329500000000000000000000000000000000000000000000e1 * t758 + 0.15494250000000000000000000000000000000000000000000e1 * t771 + 0.31558125000000000000000000000000000000000000000000e0 * t800 + 0.63116250000000000000000000000000000000000000000000e0 * t802 + t856 - 0.41678000000000000000000000000000000000000000000000e0 * t811 + 0.31258500000000000000000000000000000000000000000000e0 * t815 + 0.31258500000000000000000000000000000000000000000000e0 * t819
  t864 = t152 ** 2
  t866 = t70 / t864
  t867 = t78 ** 2
  t868 = 0.1e1 / t867
  t872 = 0.12361111111111111111111111111111111111111111111111e-1 * t755
  t876 = (t872 - 0.18541666666666666666666666666666666666666666666667e-1 * t758 + 0.27812500000000000000000000000000000000000000000000e-1 * t771) * t92
  t878 = t168 * t172
  t882 = 0.1e1 / t171 / t88
  t883 = t83 * t882
  t884 = t180 ** 2
  t890 = 0.40256666666666666666666666666666666666666666666667e0 * t755
  t895 = 0.13797500000000000000000000000000000000000000000000e0 * t808
  t899 = -0.12946250000000000000000000000000000000000000000000e1 * t789 + 0.25892500000000000000000000000000000000000000000000e1 * t794 + t890 - 0.60385000000000000000000000000000000000000000000000e0 * t758 + 0.90577500000000000000000000000000000000000000000000e0 * t771 + 0.82524375000000000000000000000000000000000000000000e-1 * t800 + 0.16504875000000000000000000000000000000000000000000e0 * t802 + t895 - 0.33114000000000000000000000000000000000000000000000e0 * t811 + 0.24835500000000000000000000000000000000000000000000e0 * t815 + 0.24835500000000000000000000000000000000000000000000e0 * t819
  t903 = t171 ** 2
  t904 = 0.1e1 / t903
  t905 = t83 * t904
  t906 = t91 ** 2
  t907 = 0.1e1 / t906
  t911 = -0.3109070e-1 * (t833 - 0.34246666666666666666666666666666666666666666666666e-1 * t758 + 0.51370000000000000000000000000000000000000000000000e-1 * t771) * t79 + 0.20000000000000000000000000000000000000000000000000e1 * t839 * t163 - 0.20000000000000000000000000000000000000000000000000e1 * t844 * t845 * t162 + 0.10000000000000000000000000000000000000000000000000e1 * t154 * t860 * t162 + 0.32163958997385070133512593798145426124210776856102e2 * t866 * t845 * t868 + t775 - t778 + t785 - t824 - t832 - 0.19751673498613801407483339618206552048944131217655e-1 * t876 + 0.11696447245269292414524477327518106963944910680856e1 * t878 * t182 - 0.11696447245269292414524477327518106963944910680856e1 * t883 * t884 * t181 + 0.58482236226346462072622386637590534819724553404280e0 * t173 * t899 * t181 + 0.17315859105681463759666483083807725165579399831905e2 * t905 * t884 * t907
  t915 = t68 * t168
  t930 = -t775 + t778 - t785 + t824 + t832 + t68 * t911 + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t876 - 0.11696447245269292414524477327518106963944910680856e1 * t915 * t191 + 0.11696447245269292414524477327518106963944910680856e1 * t189 * t882 * t884 * t181 - 0.58482236226346462072622386637590534819724553404280e0 * t189 * t172 * t899 * t181 - 0.17315859105681463759666483083807725165579399831905e2 * t189 * t904 * t884 * t907
  t934 = f.my_piecewise3(t8, 0, t747 * t99 / 0.2e1 + t13 * t194 + t101 * t930 / 0.2e1)
  t943 = params.alpha_ss ** 2
  t944 = t272 ** 2
  t945 = t943 * t944
  t949 = 0.1e1 / t202 / t235
  t950 = s0 * t949
  t952 = tau0 * t267
  t954 = 0.88e2 / 0.9e1 * t950 + 0.80e2 / 0.9e1 * t952
  t955 = params.alpha_ss * t954
  t973 = 0.1e1 / t201 / t235 / t265
  t979 = t287 * tau0
  t982 = tau0 ** 2
  t1010 = -t746
  t1011 = f.my_piecewise3(t318, 0, t1010)
  t1016 = t20 * t753 * t324
  t1017 = 0.23744444444444444444444444444444444444444444444444e-1 * t1016
  t1019 = t20 * t104 * t385
  t1021 = t317 ** 2
  t1023 = 0.1e1 / t322 / t1021
  t1024 = t320 ** 2
  t1030 = f.my_piecewise3(t318, 0, 0.4e1 / 0.9e1 * t1023 * t1024 - t382 * t1010 / 0.3e1)
  t1032 = t20 * t24 * t1030
  t1036 = 0.621814e-1 * (t1017 - 0.35616666666666666666666666666666666666666666666666e-1 * t1019 + 0.53425000000000000000000000000000000000000000000000e-1 * t1032) * t342
  t1037 = t389 * t393
  t1039 = 0.20000000000000000000000000000000000000000000000000e1 * t1037 * t414
  t1042 = t328 / t392 / t338
  t1043 = t412 ** 2
  t1046 = 0.20000000000000000000000000000000000000000000000000e1 * t1042 * t1043 * t413
  t1048 = 0.1e1 / t329 / t326
  t1049 = t397 ** 2
  t1050 = t1048 * t1049
  t1052 = 0.4e1 / 0.9e1 * t1016
  t1054 = t1052 - 0.2e1 / 0.3e1 * t1019 + t1032
  t1055 = t395 * t1054
  t1057 = 0.39862222222222222222222222222222222222222222222223e0 * t1016
  t1060 = t326 ** (-0.5e0)
  t1061 = t1060 * t1049
  t1063 = t402 * t1054
  t1066 = t42 * t806 * t334
  t1067 = 0.13692777777777777777777777777777777777777777777778e0 * t1066
  t1069 = t42 * t134 * t408
  t1071 = t385 ** 2
  t1073 = t42 * t46 * t1071
  t1077 = t42 * t46 * t324 * t1030
  t1079 = -0.94946250000000000000000000000000000000000000000000e0 * t1050 + 0.18989250000000000000000000000000000000000000000000e1 * t1055 + t1057 - 0.59793333333333333333333333333333333333333333333334e0 * t1019 + 0.89690000000000000000000000000000000000000000000000e0 * t1032 + 0.15358125000000000000000000000000000000000000000000e0 * t1061 + 0.30716250000000000000000000000000000000000000000000e0 * t1063 + t1067 - 0.32862666666666666666666666666666666666666666666666e0 * t1069 + 0.24647000000000000000000000000000000000000000000000e0 * t1073 + 0.24647000000000000000000000000000000000000000000000e0 * t1077
  t1082 = 0.10000000000000000000000000000000000000000000000000e1 * t394 * t1079 * t413
  t1083 = t392 ** 2
  t1085 = t328 / t1083
  t1086 = t341 ** 2
  t1087 = 0.1e1 / t1086
  t1090 = 0.16081979498692535066756296899072713062105388428051e2 * t1085 * t1043 * t1087
  t1091 = 0.22831111111111111111111111111111111111111111111111e-1 * t1016
  t1097 = t419 * t423
  t1102 = t346 / t422 / t351
  t1103 = t431 ** 2
  t1109 = 0.68863333333333333333333333333333333333333333333333e0 * t1016
  t1114 = 0.17365833333333333333333333333333333333333333333333e0 * t1066
  t1118 = -0.17648625000000000000000000000000000000000000000000e1 * t1050 + 0.35297250000000000000000000000000000000000000000000e1 * t1055 + t1109 - 0.10329500000000000000000000000000000000000000000000e1 * t1019 + 0.15494250000000000000000000000000000000000000000000e1 * t1032 + 0.31558125000000000000000000000000000000000000000000e0 * t1061 + 0.63116250000000000000000000000000000000000000000000e0 * t1063 + t1114 - 0.41678000000000000000000000000000000000000000000000e0 * t1069 + 0.31258500000000000000000000000000000000000000000000e0 * t1073 + 0.31258500000000000000000000000000000000000000000000e0 * t1077
  t1122 = t422 ** 2
  t1124 = t346 / t1122
  t1125 = t354 ** 2
  t1126 = 0.1e1 / t1125
  t1130 = 0.12361111111111111111111111111111111111111111111111e-1 * t1016
  t1134 = (t1130 - 0.18541666666666666666666666666666666666666666666667e-1 * t1019 + 0.27812500000000000000000000000000000000000000000000e-1 * t1032) * t368
  t1136 = t438 * t442
  t1140 = 0.1e1 / t441 / t364
  t1141 = t359 * t1140
  t1142 = t450 ** 2
  t1148 = 0.40256666666666666666666666666666666666666666666667e0 * t1016
  t1153 = 0.13797500000000000000000000000000000000000000000000e0 * t1066
  t1157 = -0.12946250000000000000000000000000000000000000000000e1 * t1050 + 0.25892500000000000000000000000000000000000000000000e1 * t1055 + t1148 - 0.60385000000000000000000000000000000000000000000000e0 * t1019 + 0.90577500000000000000000000000000000000000000000000e0 * t1032 + 0.82524375000000000000000000000000000000000000000000e-1 * t1061 + 0.16504875000000000000000000000000000000000000000000e0 * t1063 + t1153 - 0.33114000000000000000000000000000000000000000000000e0 * t1069 + 0.24835500000000000000000000000000000000000000000000e0 * t1073 + 0.24835500000000000000000000000000000000000000000000e0 * t1077
  t1161 = t441 ** 2
  t1162 = 0.1e1 / t1161
  t1163 = t359 * t1162
  t1164 = t367 ** 2
  t1165 = 0.1e1 / t1164
  t1169 = -0.3109070e-1 * (t1091 - 0.34246666666666666666666666666666666666666666666666e-1 * t1019 + 0.51370000000000000000000000000000000000000000000000e-1 * t1032) * t355 + 0.20000000000000000000000000000000000000000000000000e1 * t1097 * t433 - 0.20000000000000000000000000000000000000000000000000e1 * t1102 * t1103 * t432 + 0.10000000000000000000000000000000000000000000000000e1 * t424 * t1118 * t432 + 0.32163958997385070133512593798145426124210776856102e2 * t1124 * t1103 * t1126 + t1036 - t1039 + t1046 - t1082 - t1090 - 0.19751673498613801407483339618206552048944131217655e-1 * t1134 + 0.11696447245269292414524477327518106963944910680856e1 * t1136 * t452 - 0.11696447245269292414524477327518106963944910680856e1 * t1141 * t1142 * t451 + 0.58482236226346462072622386637590534819724553404280e0 * t443 * t1157 * t451 + 0.17315859105681463759666483083807725165579399831905e2 * t1163 * t1142 * t1165
  t1173 = t68 * t438
  t1188 = -t1036 + t1039 - t1046 + t1082 + t1090 + t68 * t1169 + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t1134 - 0.11696447245269292414524477327518106963944910680856e1 * t1173 * t461 + 0.11696447245269292414524477327518106963944910680856e1 * t459 * t1140 * t1142 * t451 - 0.58482236226346462072622386637590534819724553404280e0 * t459 * t442 * t1157 * t451 - 0.17315859105681463759666483083807725165579399831905e2 * t459 * t1162 * t1142 * t1165
  t1192 = f.my_piecewise3(t319, 0, t1011 * t375 / 0.2e1 + t321 * t464 + t377 * t1188 / 0.2e1)
  t1198 = 0.10843581300301739842632067522386578331157260943710e-1 * t570 * t17 * t518 * t662
  t1203 = t40 * t18 * t805
  t1204 = 0.1e1 / t521 / t520 * t39 * t1203
  t1206 = t544 * t752
  t1207 = t543 * t1206
  t1209 = t19 * t752
  t1210 = t17 * t1209
  t1212 = t520 ** (-0.5e0)
  t1214 = t1212 * t39 * t1203
  t1216 = t551 * t1206
  t1219 = t41 * t18 * t805
  t1224 = 0.10000000000000000000000000000000000000000000000000e1 * t541 * (-0.42198333333333333333333333333333333333333333333333e0 * t1204 + 0.84396666666666666666666666666666666666666666666666e0 * t1207 + 0.39862222222222222222222222222222222222222222222223e0 * t1210 + 0.68258333333333333333333333333333333333333333333333e-1 * t1214 + 0.13651666666666666666666666666666666666666666666667e0 * t1216 + 0.13692777777777777777777777777777777777777777777778e0 * t1219) * t558
  t1225 = t539 ** 2
  t1228 = t557 ** 2
  t1229 = t532 ** 2
  t1233 = 0.16081979498692535066756296899072713062105388428051e2 * t538 / t1225 * t1228 / t1229
  t1239 = 0.20000000000000000000000000000000000000000000000000e1 * t538 / t539 / t529 * t1228 * t558
  t1243 = 0.35616666666666666666666666666666666666666666666666e-1 * t20 * t103 * t540 * t559
  t1245 = t617 * t14 * t657
  t1250 = 0.24415263074675393406472461472505321282722606644045e-3 * t655 * t544 * t752 * t596
  t1251 = t638 ** 2
  t1252 = 0.1e1 / t1251
  t1253 = t645 ** 2
  t1255 = t595 ** 2
  t1256 = 0.1e1 / t1255
  t1259 = 0.17315859105681463759666483083807725165579399831905e2 * t660 * t1252 * t1253 * t1256
  t1261 = t617 * t587 * t662
  t1269 = -0.57538888888888888888888888888888888888888888888889e0 * t1204 + 0.11507777777777777777777777777777777777777777777778e1 * t1207 + 0.40256666666666666666666666666666666666666666666667e0 * t1210 + 0.36677500000000000000000000000000000000000000000000e-1 * t1214 + 0.73355000000000000000000000000000000000000000000000e-1 * t1216 + 0.13797500000000000000000000000000000000000000000000e0 * t1219
  t1273 = 0.58482236226346462072622386637590534819724553404280e0 * t660 * t639 * t1269 * t646
  t1274 = -t934 + t1198 - t1192 + t1224 + t1233 - t1239 - t1243 - 0.36622894612013090109708692208757981924083909966068e-3 * t1245 + t1250 - t1259 - 0.11696447245269292414524477327518106963944910680856e1 * t1261 - t1273
  t1276 = 0.1e1 / t638 / t592
  t1280 = 0.11696447245269292414524477327518106963944910680856e1 * t660 * t1276 * t1253 * t646
  t1281 = t27 ** 2
  t1282 = 0.1e1 / t1281
  t1288 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t1282 * t763 + 0.4e1 / 0.3e1 * t27 * t746)
  t1289 = t322 ** 2
  t1290 = 0.1e1 / t1289
  t1296 = f.my_piecewise3(t318, 0, 0.4e1 / 0.9e1 * t1290 * t1024 + 0.4e1 / 0.3e1 * t322 * t1010)
  t1298 = (t1288 + t1296) * t67
  t1304 = 0.8e1 * t566 * t651
  t1305 = t606 * t618
  t1308 = 0.8e1 * t606 * t651
  t1309 = t566 * t618
  t1313 = 0.14764627977777777777777777777777777777777777777777e-2 * t17 * t1209 * t533
  t1315 = t609 * t617 * t650
  t1321 = 0.20e2 * t603 / t564 / t9 * t600
  t1324 = 0.32e2 * t563 * t605 * t600
  t1327 = 0.12e2 * t562 * t565 * t600
  t1338 = t630 ** 2
  t1352 = t623 ** 2
  t1355 = t580 ** 2
  t1378 = -0.70983522622222222222222222222222222222222222222221e-3 * t17 * t1209 * t581 - 0.34246666666666666666666666666666666666666666666666e-1 * t20 * t103 * t624 * t632 - 0.20000000000000000000000000000000000000000000000000e1 * t572 / t623 / t577 * t1338 * t631 + 0.10000000000000000000000000000000000000000000000000e1 * t625 * (-0.78438333333333333333333333333333333333333333333333e0 * t1204 + 0.15687666666666666666666666666666666666666666666667e1 * t1207 + 0.68863333333333333333333333333333333333333333333333e0 * t1210 + 0.14025833333333333333333333333333333333333333333333e0 * t1214 + 0.28051666666666666666666666666666666666666666666667e0 * t1216 + 0.17365833333333333333333333333333333333333333333333e0 * t1219) * t631 + 0.32163958997385070133512593798145426124210776856102e2 * t572 / t1352 * t1338 / t1355 + t1313 + t1243 + t1239 - t1224 - t1233 - 0.24415263074675393406472461472505321282722606644045e-3 * t17 * t1209 * t596 - 0.10843581300301739842632067522386578331157260943710e-1 * t20 * t103 * t639 * t647 - 0.11696447245269292414524477327518106963944910680856e1 * t587 * t1276 * t1253 * t646 + 0.58482236226346462072622386637590534819724553404280e0 * t640 * t1269 * t646 + 0.17315859105681463759666483083807725165579399831905e2 * t587 * t1252 * t1253 * t1256
  t1380 = t609 * t570 * t1378
  t1381 = t1280 + t609 * t1298 * t599 + 0.19751673498613801407483339618206552048944131217655e-1 * t1298 * t597 + t1304 - 0.8e1 * t1305 - t1308 + 0.8e1 * t1309 - t1313 + 0.2e1 * t1315 + t1321 - t1324 + t1327 + t1380
  t1386 = t666 * t694
  t1387 = params.alpha_ab ** 2
  t1388 = t1387 * t944
  t1391 = params.alpha_ab * t954
  t1399 = t715 * t694
  t1402 = t679 * t735
  t1426 = t732 * t735
  t1431 = t692 / t734 / t670
  d11 = 0.2e1 * t259 + 0.2e1 * t308 + t314 / 0.4e1 + 0.2e1 * t516 + 0.2e1 * t697 + 0.2e1 * t740 + t3 * (t934 * t251 * t258 + 0.2e1 * t198 * t306 * t258 + t252 * t313 / 0.4e1 + t263 * (0.2e1 * t199 * t249 * t945 - t264 * t955 + (0.88e2 / 0.9e1 * t223 * t949 + 0.80e2 / 0.9e1 * t277 * t267) * t230 - 0.4e1 * t280 * t249 * t273 + 0.6e1 * t228 * t302 * t945 - 0.2e1 * t282 * t955 + (0.304e3 / 0.9e1 * t234 * t973 + 0.88e2 / 0.9e1 * t241 * t949 * t226 + 0.80e2 / 0.3e1 * t241 * t979 + 0.200e3 / 0.9e1 * t244 * t982 * t238 + 0.160e3 / 0.9e1 * t296 * t952) * t249 - 0.6e1 * t299 * t302 * t273 + 0.12e2 * t247 / t301 / t219 * t945 - 0.3e1 * t303 * t955) * t258 + t307 * t313 / 0.4e1 - t310 * s0 / t265 * t255 / 0.4e1 + t1192 * t508 * t515 + (t1274 + t1381) * t696 + 0.2e1 * t665 * t739 + t705 * (0.2e1 * t1386 * t1388 - t706 * t1391 + (0.88e2 / 0.9e1 * t709 * t949 + 0.80e2 / 0.9e1 * t712 * t267) * t681 - 0.4e1 * t1399 * t707 + 0.6e1 * t1402 * t1388 - 0.2e1 * t717 * t1391 + (0.128e3 / 0.9e1 * t683 * t233 * t973 + 0.176e3 / 0.9e1 * t720 * t950 + 0.88e2 / 0.9e1 * t723 * t949 * t677 + 0.160e3 / 0.9e1 * t723 * t979 + 0.80e2 / 0.9e1 * t687 * t952 + 0.200e3 / 0.9e1 * t689 * t982 * t238 + 0.160e3 / 0.9e1 * t729 * t952) * t694 - 0.6e1 * t1426 * t707 + 0.12e2 * t1431 * t1388 - 0.3e1 * t736 * t1391))
  t1441 = -t4 - t11
  t1442 = f.my_piecewise3(t7, 0, t1441)
  t1446 = f.my_piecewise3(t7, 0, -t109 * t1441 / 0.3e1)
  t1448 = t20 * t24 * t1446
  t1450 = -t107 + 0.53425000000000000000000000000000000000000000000000e-1 * t1448
  t1452 = 0.621814e-1 * t1450 * t55
  t1453 = -t123 + t1448
  t1454 = t122 * t1453
  t1457 = t129 * t1453
  t1459 = t29 * t1446
  t1461 = t42 * t46 * t1459
  t1463 = 0.18989250000000000000000000000000000000000000000000e1 * t1454 - t127 + 0.89690000000000000000000000000000000000000000000000e0 * t1448 + 0.30716250000000000000000000000000000000000000000000e0 * t1457 - t137 + 0.24647000000000000000000000000000000000000000000000e0 * t1461
  t1464 = t1463 * t143
  t1466 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * t1464
  t1468 = -t147 + 0.51370000000000000000000000000000000000000000000000e-1 * t1448
  t1475 = 0.35297250000000000000000000000000000000000000000000e1 * t1454 - t156 + 0.15494250000000000000000000000000000000000000000000e1 * t1448 + 0.63116250000000000000000000000000000000000000000000e0 * t1457 - t159 + 0.31258500000000000000000000000000000000000000000000e0 * t1461
  t1476 = t1475 * t162
  t1480 = -t166 + 0.27812500000000000000000000000000000000000000000000e-1 * t1448
  t1481 = t1480 * t92
  t1487 = 0.25892500000000000000000000000000000000000000000000e1 * t1454 - t175 + 0.90577500000000000000000000000000000000000000000000e0 * t1448 + 0.16504875000000000000000000000000000000000000000000e0 * t1457 - t178 + 0.24835500000000000000000000000000000000000000000000e0 * t1461
  t1488 = t1487 * t181
  t1496 = t172 * t1487 * t181
  t1499 = -t1452 + t1466 + t68 * (-0.3109070e-1 * t1468 * t79 + 0.10000000000000000000000000000000000000000000000000e1 * t154 * t1476 + t1452 - t1466 - 0.19751673498613801407483339618206552048944131217655e-1 * t1481 + 0.58482236226346462072622386637590534819724553404280e0 * t173 * t1488) + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t1481 - 0.58482236226346462072622386637590534819724553404280e0 * t189 * t1496
  t1503 = f.my_piecewise3(t8, 0, t101 * t1499 / 0.2e1 + t1442 * t99 / 0.2e1)
  t1504 = t1503 * t251
  t1505 = t1504 * t258
  t1506 = -t1441
  t1507 = f.my_piecewise3(t318, 0, t1506)
  t1511 = f.my_piecewise3(t318, 0, -t382 * t1506 / 0.3e1)
  t1513 = t20 * t24 * t1511
  t1515 = -t380 + 0.53425000000000000000000000000000000000000000000000e-1 * t1513
  t1517 = 0.621814e-1 * t1515 * t342
  t1518 = -t396 + t1513
  t1519 = t395 * t1518
  t1522 = t402 * t1518
  t1524 = t324 * t1511
  t1526 = t42 * t46 * t1524
  t1528 = 0.18989250000000000000000000000000000000000000000000e1 * t1519 - t400 + 0.89690000000000000000000000000000000000000000000000e0 * t1513 + 0.30716250000000000000000000000000000000000000000000e0 * t1522 - t407 + 0.24647000000000000000000000000000000000000000000000e0 * t1526
  t1529 = t1528 * t413
  t1531 = 0.10000000000000000000000000000000000000000000000000e1 * t394 * t1529
  t1533 = -t417 + 0.51370000000000000000000000000000000000000000000000e-1 * t1513
  t1540 = 0.35297250000000000000000000000000000000000000000000e1 * t1519 - t426 + 0.15494250000000000000000000000000000000000000000000e1 * t1513 + 0.63116250000000000000000000000000000000000000000000e0 * t1522 - t429 + 0.31258500000000000000000000000000000000000000000000e0 * t1526
  t1541 = t1540 * t432
  t1545 = -t436 + 0.27812500000000000000000000000000000000000000000000e-1 * t1513
  t1546 = t1545 * t368
  t1552 = 0.25892500000000000000000000000000000000000000000000e1 * t1519 - t445 + 0.90577500000000000000000000000000000000000000000000e0 * t1513 + 0.16504875000000000000000000000000000000000000000000e0 * t1522 - t448 + 0.24835500000000000000000000000000000000000000000000e0 * t1526
  t1553 = t1552 * t451
  t1561 = t442 * t1552 * t451
  t1564 = -t1517 + t1531 + t68 * (-0.3109070e-1 * t1533 * t355 + 0.10000000000000000000000000000000000000000000000000e1 * t424 * t1541 + t1517 - t1531 - 0.19751673498613801407483339618206552048944131217655e-1 * t1546 + 0.58482236226346462072622386637590534819724553404280e0 * t443 * t1553) + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t1546 - 0.58482236226346462072622386637590534819724553404280e0 * t459 * t1561
  t1568 = f.my_piecewise3(t319, 0, t1507 * t375 / 0.2e1 + t377 * t1564 / 0.2e1)
  t1569 = t1568 * t508
  t1570 = t1569 * t515
  t1571 = t199 * t490
  t1572 = t469 * r1
  t1574 = 0.1e1 / t471 / t1572
  t1575 = s2 * t1574
  t1577 = tau1 * t473
  t1579 = -0.8e1 / 0.3e1 * t1575 - 0.10e2 / 0.3e1 * t1577
  t1580 = params.alpha_ss * t1579
  t1584 = t225 * tau1
  t1587 = -0.8e1 / 0.3e1 * t484 * t1574 - 0.10e2 / 0.3e1 * t1584 * t473
  t1589 = t488 * t506
  t1594 = 0.1e1 / t470 / t494 / t469
  t1603 = t244 * t486
  t1606 = -0.16e2 / 0.3e1 * t493 * t1594 - 0.8e1 / 0.3e1 * t499 * t1574 * t486 - 0.10e2 / 0.3e1 * t499 * t497 * tau1 - 0.20e2 / 0.3e1 * t1603 * t1577
  t1608 = t489 ** 2
  t1609 = 0.1e1 / t1608
  t1610 = t504 * t1609
  t1613 = -t1571 * t1580 - 0.2e1 * t1589 * t1580 - 0.3e1 * t1610 * t1580 + t1587 * t490 + t1606 * t506
  t1614 = t704 * t1613
  t1615 = t1614 * t515
  t1616 = t704 * t508
  t1619 = s2 / t469 * t512
  t1620 = t1616 * t1619
  t1624 = f.my_piecewise3(t7, 0, 0.4e1 / 0.3e1 * t27 * t1441)
  t1627 = f.my_piecewise3(t318, 0, 0.4e1 / 0.3e1 * t322 * t1506)
  t1629 = (t1624 + t1627) * t67
  t1630 = t1629 * t599
  t1634 = t536 + t561 - t602 - t608 + t609 * t1630 + t652 + 0.19751673498613801407483339618206552048944131217655e-1 * t1629 * t597 - t659 - t664 - t1503 - t1568
  t1635 = t1634 * t696
  t1636 = params.alpha_ab * t1579
  t1638 = t673 * s2
  t1641 = t676 * tau1
  t1644 = -0.8e1 / 0.3e1 * t1638 * t1574 - 0.10e2 / 0.3e1 * t1641 * t473
  t1650 = t686 * s2
  t1658 = -0.16e2 / 0.3e1 * t720 * t1575 - 0.8e1 / 0.3e1 * t1650 * t1574 * t677 - 0.10e2 / 0.3e1 * t687 * t1577 - 0.20e2 / 0.3e1 * t729 * t1577
  t1662 = -t706 * t1636 - 0.2e1 * t717 * t1636 - 0.3e1 * t736 * t1636 + t1644 * t681 + t1658 * t694
  t1663 = t705 * t1662
  t1664 = 0.2e1 * t744
  t1665 = f.my_piecewise3(t7, 0, t1664)
  t1671 = t20 * t104 * t1446
  t1680 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t762 * t1441 * t12 - 0.2e1 / 0.3e1 * t109 * t2 * t743)
  t1682 = t20 * t24 * t1680
  t1686 = 0.621814e-1 * (t756 - 0.17808333333333333333333333333333333333333333333333e-1 * t758 - 0.17808333333333333333333333333333333333333333333333e-1 * t1671 + 0.53425000000000000000000000000000000000000000000000e-1 * t1682) * t55
  t1687 = t1450 * t120
  t1689 = 0.10000000000000000000000000000000000000000000000000e1 * t1687 * t144
  t1691 = 0.10000000000000000000000000000000000000000000000000e1 * t776 * t1464
  t1694 = 0.20000000000000000000000000000000000000000000000000e1 * t781 * t1464 * t142
  t1696 = t787 * t1453 * t124
  t1700 = t791 - t758 / 0.3e1 - t1671 / 0.3e1 + t1682
  t1701 = t122 * t1700
  t1707 = t799 * t1453 * t124
  t1709 = t129 * t1700
  t1713 = t42 * t134 * t1459
  t1717 = t42 * t46 * t112 * t1446
  t1721 = t42 * t46 * t29 * t1680
  t1723 = -0.94946250000000000000000000000000000000000000000000e0 * t1696 + 0.18989250000000000000000000000000000000000000000000e1 * t1701 + t796 - 0.29896666666666666666666666666666666666666666666667e0 * t758 - 0.29896666666666666666666666666666666666666666666667e0 * t1671 + 0.89690000000000000000000000000000000000000000000000e0 * t1682 + 0.15358125000000000000000000000000000000000000000000e0 * t1707 + 0.30716250000000000000000000000000000000000000000000e0 * t1709 + t809 - 0.16431333333333333333333333333333333333333333333333e0 * t811 - 0.16431333333333333333333333333333333333333333333333e0 * t1713 + 0.24647000000000000000000000000000000000000000000000e0 * t1717 + 0.24647000000000000000000000000000000000000000000000e0 * t1721
  t1726 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * t1723 * t143
  t1730 = 0.16081979498692535066756296899072713062105388428051e2 * t827 * t1463 * t829 * t142
  t1737 = t1468 * t153
  t1756 = -0.17648625000000000000000000000000000000000000000000e1 * t1696 + 0.35297250000000000000000000000000000000000000000000e1 * t1701 + t851 - 0.51647500000000000000000000000000000000000000000000e0 * t758 - 0.51647500000000000000000000000000000000000000000000e0 * t1671 + 0.15494250000000000000000000000000000000000000000000e1 * t1682 + 0.31558125000000000000000000000000000000000000000000e0 * t1707 + 0.63116250000000000000000000000000000000000000000000e0 * t1709 + t856 - 0.20839000000000000000000000000000000000000000000000e0 * t811 - 0.20839000000000000000000000000000000000000000000000e0 * t1713 + 0.31258500000000000000000000000000000000000000000000e0 * t1717 + 0.31258500000000000000000000000000000000000000000000e0 * t1721
  t1768 = (t872 - 0.92708333333333333333333333333333333333333333333333e-2 * t758 - 0.92708333333333333333333333333333333333333333333333e-2 * t1671 + 0.27812500000000000000000000000000000000000000000000e-1 * t1682) * t92
  t1770 = t1480 * t172
  t1789 = -0.12946250000000000000000000000000000000000000000000e1 * t1696 + 0.25892500000000000000000000000000000000000000000000e1 * t1701 + t890 - 0.30192500000000000000000000000000000000000000000000e0 * t758 - 0.30192500000000000000000000000000000000000000000000e0 * t1671 + 0.90577500000000000000000000000000000000000000000000e0 * t1682 + 0.82524375000000000000000000000000000000000000000000e-1 * t1707 + 0.16504875000000000000000000000000000000000000000000e0 * t1709 + t895 - 0.16557000000000000000000000000000000000000000000000e0 * t811 - 0.16557000000000000000000000000000000000000000000000e0 * t1713 + 0.24835500000000000000000000000000000000000000000000e0 * t1717 + 0.24835500000000000000000000000000000000000000000000e0 * t1721
  t1797 = -0.3109070e-1 * (t833 - 0.17123333333333333333333333333333333333333333333333e-1 * t758 - 0.17123333333333333333333333333333333333333333333333e-1 * t1671 + 0.51370000000000000000000000000000000000000000000000e-1 * t1682) * t79 + 0.10000000000000000000000000000000000000000000000000e1 * t1737 * t163 + 0.10000000000000000000000000000000000000000000000000e1 * t839 * t1476 - 0.20000000000000000000000000000000000000000000000000e1 * t844 * t1476 * t161 + 0.10000000000000000000000000000000000000000000000000e1 * t154 * t1756 * t162 + 0.32163958997385070133512593798145426124210776856102e2 * t866 * t1475 * t868 * t161 + t1686 - t1689 - t1691 + t1694 - t1726 - t1730 - 0.19751673498613801407483339618206552048944131217655e-1 * t1768 + 0.58482236226346462072622386637590534819724553404280e0 * t1770 * t182 + 0.58482236226346462072622386637590534819724553404280e0 * t878 * t1488 - 0.11696447245269292414524477327518106963944910680856e1 * t883 * t1488 * t180 + 0.58482236226346462072622386637590534819724553404280e0 * t173 * t1789 * t181 + 0.17315859105681463759666483083807725165579399831905e2 * t905 * t1487 * t907 * t180
  t1801 = t68 * t1480
  t1819 = -t1686 + t1689 + t1691 - t1694 + t1726 + t1730 + t68 * t1797 + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t1768 - 0.58482236226346462072622386637590534819724553404280e0 * t1801 * t191 - 0.58482236226346462072622386637590534819724553404280e0 * t915 * t1496 + 0.11696447245269292414524477327518106963944910680856e1 * t189 * t882 * t1487 * t182 - 0.58482236226346462072622386637590534819724553404280e0 * t189 * t172 * t1789 * t181 - 0.17315859105681463759666483083807725165579399831905e2 * t189 * t904 * t1487 * t907 * t180
  t1823 = f.my_piecewise3(t8, 0, t101 * t1819 / 0.2e1 + t13 * t1499 / 0.2e1 + t1442 * t194 / 0.2e1 + t1665 * t99 / 0.2e1)
  t1830 = f.my_piecewise3(t318, 0, -t1664)
  t1836 = t20 * t104 * t1511
  t1845 = f.my_piecewise3(t318, 0, 0.4e1 / 0.9e1 * t1023 * t1506 * t320 + 0.2e1 / 0.3e1 * t382 * t2 * t743)
  t1847 = t20 * t24 * t1845
  t1851 = 0.621814e-1 * (t1017 - 0.17808333333333333333333333333333333333333333333333e-1 * t1019 - 0.17808333333333333333333333333333333333333333333333e-1 * t1836 + 0.53425000000000000000000000000000000000000000000000e-1 * t1847) * t342
  t1852 = t1515 * t393
  t1854 = 0.10000000000000000000000000000000000000000000000000e1 * t1852 * t414
  t1856 = 0.10000000000000000000000000000000000000000000000000e1 * t1037 * t1529
  t1859 = 0.20000000000000000000000000000000000000000000000000e1 * t1042 * t1529 * t412
  t1861 = t1048 * t1518 * t397
  t1865 = t1052 - t1019 / 0.3e1 - t1836 / 0.3e1 + t1847
  t1866 = t395 * t1865
  t1872 = t1060 * t1518 * t397
  t1874 = t402 * t1865
  t1878 = t42 * t134 * t1524
  t1882 = t42 * t46 * t385 * t1511
  t1886 = t42 * t46 * t324 * t1845
  t1888 = -0.94946250000000000000000000000000000000000000000000e0 * t1861 + 0.18989250000000000000000000000000000000000000000000e1 * t1866 + t1057 - 0.29896666666666666666666666666666666666666666666667e0 * t1019 - 0.29896666666666666666666666666666666666666666666667e0 * t1836 + 0.89690000000000000000000000000000000000000000000000e0 * t1847 + 0.15358125000000000000000000000000000000000000000000e0 * t1872 + 0.30716250000000000000000000000000000000000000000000e0 * t1874 + t1067 - 0.16431333333333333333333333333333333333333333333333e0 * t1069 - 0.16431333333333333333333333333333333333333333333333e0 * t1878 + 0.24647000000000000000000000000000000000000000000000e0 * t1882 + 0.24647000000000000000000000000000000000000000000000e0 * t1886
  t1891 = 0.10000000000000000000000000000000000000000000000000e1 * t394 * t1888 * t413
  t1895 = 0.16081979498692535066756296899072713062105388428051e2 * t1085 * t1528 * t1087 * t412
  t1902 = t1533 * t423
  t1921 = -0.17648625000000000000000000000000000000000000000000e1 * t1861 + 0.35297250000000000000000000000000000000000000000000e1 * t1866 + t1109 - 0.51647500000000000000000000000000000000000000000000e0 * t1019 - 0.51647500000000000000000000000000000000000000000000e0 * t1836 + 0.15494250000000000000000000000000000000000000000000e1 * t1847 + 0.31558125000000000000000000000000000000000000000000e0 * t1872 + 0.63116250000000000000000000000000000000000000000000e0 * t1874 + t1114 - 0.20839000000000000000000000000000000000000000000000e0 * t1069 - 0.20839000000000000000000000000000000000000000000000e0 * t1878 + 0.31258500000000000000000000000000000000000000000000e0 * t1882 + 0.31258500000000000000000000000000000000000000000000e0 * t1886
  t1933 = (t1130 - 0.92708333333333333333333333333333333333333333333333e-2 * t1019 - 0.92708333333333333333333333333333333333333333333333e-2 * t1836 + 0.27812500000000000000000000000000000000000000000000e-1 * t1847) * t368
  t1935 = t1545 * t442
  t1954 = -0.12946250000000000000000000000000000000000000000000e1 * t1861 + 0.25892500000000000000000000000000000000000000000000e1 * t1866 + t1148 - 0.30192500000000000000000000000000000000000000000000e0 * t1019 - 0.30192500000000000000000000000000000000000000000000e0 * t1836 + 0.90577500000000000000000000000000000000000000000000e0 * t1847 + 0.82524375000000000000000000000000000000000000000000e-1 * t1872 + 0.16504875000000000000000000000000000000000000000000e0 * t1874 + t1153 - 0.16557000000000000000000000000000000000000000000000e0 * t1069 - 0.16557000000000000000000000000000000000000000000000e0 * t1878 + 0.24835500000000000000000000000000000000000000000000e0 * t1882 + 0.24835500000000000000000000000000000000000000000000e0 * t1886
  t1962 = -0.3109070e-1 * (t1091 - 0.17123333333333333333333333333333333333333333333333e-1 * t1019 - 0.17123333333333333333333333333333333333333333333333e-1 * t1836 + 0.51370000000000000000000000000000000000000000000000e-1 * t1847) * t355 + 0.10000000000000000000000000000000000000000000000000e1 * t1902 * t433 + 0.10000000000000000000000000000000000000000000000000e1 * t1097 * t1541 - 0.20000000000000000000000000000000000000000000000000e1 * t1102 * t1541 * t431 + 0.10000000000000000000000000000000000000000000000000e1 * t424 * t1921 * t432 + 0.32163958997385070133512593798145426124210776856102e2 * t1124 * t1540 * t1126 * t431 + t1851 - t1854 - t1856 + t1859 - t1891 - t1895 - 0.19751673498613801407483339618206552048944131217655e-1 * t1933 + 0.58482236226346462072622386637590534819724553404280e0 * t1935 * t452 + 0.58482236226346462072622386637590534819724553404280e0 * t1136 * t1553 - 0.11696447245269292414524477327518106963944910680856e1 * t1141 * t1553 * t450 + 0.58482236226346462072622386637590534819724553404280e0 * t443 * t1954 * t451 + 0.17315859105681463759666483083807725165579399831905e2 * t1163 * t1552 * t1165 * t450
  t1966 = t68 * t1545
  t1984 = -t1851 + t1854 + t1856 - t1859 + t1891 + t1895 + t68 * t1962 + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t1933 - 0.58482236226346462072622386637590534819724553404280e0 * t1966 * t461 - 0.58482236226346462072622386637590534819724553404280e0 * t1173 * t1561 + 0.11696447245269292414524477327518106963944910680856e1 * t459 * t1140 * t1552 * t452 - 0.58482236226346462072622386637590534819724553404280e0 * t459 * t442 * t1954 * t451 - 0.17315859105681463759666483083807725165579399831905e2 * t459 * t1162 * t1552 * t1165 * t450
  t1988 = f.my_piecewise3(t319, 0, t1507 * t464 / 0.2e1 + t321 * t1564 / 0.2e1 + t1830 * t375 / 0.2e1 + t377 * t1984 / 0.2e1)
  t1996 = t1629 * t587 * t662
  t1999 = t1629 * t14 * t657
  t2009 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t1282 * t1441 * t12 + 0.8e1 / 0.3e1 * t27 * t2 * t743)
  t2017 = f.my_piecewise3(t318, 0, 0.4e1 / 0.9e1 * t1290 * t1506 * t320 - 0.8e1 / 0.3e1 * t322 * t2 * t743)
  t2019 = (t2009 + t2017) * t67
  t2023 = t1198 - 0.58482236226346462072622386637590534819724553404280e0 * t1996 - 0.18311447306006545054854346104378990962041954983034e-3 * t1999 + t1224 + t1233 - t1239 - t1823 - t1243 - 0.18311447306006545054854346104378990962041954983034e-3 * t1245 + t1250 + 0.19751673498613801407483339618206552048944131217655e-1 * t2019 * t597 - t1259 - 0.58482236226346462072622386637590534819724553404280e0 * t1261 - t1273
  t2026 = t566 * t1630
  t2028 = t606 * t1630
  t2033 = t609 * t1629 * t650
  t2034 = t609 * t2019 * t599 + t1280 - 0.4e1 * t1305 - t1308 - 0.4e1 * t1309 - t1313 + t1315 + t1321 - t1327 + t1380 - t1988 + 0.4e1 * t2026 - 0.4e1 * t2028 + t2033
  t2040 = t1387 * t1579 * t272
  t2043 = t1644 * t694
  t2070 = t1658 * t735
  d12 = t259 + t308 + t314 / 0.8e1 + t516 + t697 + t740 + t1505 + t1570 + t1615 + t1620 / 0.8e1 + t1635 + t1663 + t3 * (t1823 * t251 * t258 + t1503 * t306 * t258 + t1504 * t313 / 0.8e1 + t1988 * t508 * t515 + t468 * t1613 * t515 + t509 * t1619 / 0.8e1 + (t2023 + t2034) * t696 + t1634 * t739 + t665 * t1662 + t705 * (0.2e1 * t1386 * t2040 - 0.2e1 * t2043 * t707 - 0.2e1 * t1399 * t1636 + 0.6e1 * t1402 * t2040 + (0.128e3 / 0.9e1 * t683 * s0 * t267 * s2 * t1574 + 0.80e2 / 0.9e1 * t1650 * t1574 * tau0 * t204 + 0.80e2 / 0.9e1 * t723 * t267 * tau1 * t473 + 0.200e3 / 0.9e1 * t689 * tau0 * t204 * tau1 * t473) * t694 - 0.3e1 * t2070 * t707 - 0.3e1 * t1426 * t1636 + 0.12e2 * t1431 * t2040))
  t2088 = 0.2e1 * t10 + 0.2e1 * t744
  t2089 = f.my_piecewise3(t7, 0, t2088)
  t2094 = t1441 ** 2
  t2100 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t762 * t2094 - t109 * t2088 / 0.3e1)
  t2102 = t20 * t24 * t2100
  t2106 = 0.621814e-1 * (t756 - 0.35616666666666666666666666666666666666666666666666e-1 * t1671 + 0.53425000000000000000000000000000000000000000000000e-1 * t2102) * t55
  t2108 = 0.20000000000000000000000000000000000000000000000000e1 * t1687 * t1464
  t2109 = t1463 ** 2
  t2112 = 0.20000000000000000000000000000000000000000000000000e1 * t781 * t2109 * t143
  t2113 = t1453 ** 2
  t2114 = t787 * t2113
  t2117 = t791 - 0.2e1 / 0.3e1 * t1671 + t2102
  t2118 = t122 * t2117
  t2122 = t799 * t2113
  t2124 = t129 * t2117
  t2127 = t1446 ** 2
  t2129 = t42 * t46 * t2127
  t2133 = t42 * t46 * t29 * t2100
  t2135 = -0.94946250000000000000000000000000000000000000000000e0 * t2114 + 0.18989250000000000000000000000000000000000000000000e1 * t2118 + t796 - 0.59793333333333333333333333333333333333333333333334e0 * t1671 + 0.89690000000000000000000000000000000000000000000000e0 * t2102 + 0.15358125000000000000000000000000000000000000000000e0 * t2122 + 0.30716250000000000000000000000000000000000000000000e0 * t2124 + t809 - 0.32862666666666666666666666666666666666666666666666e0 * t1713 + 0.24647000000000000000000000000000000000000000000000e0 * t2129 + 0.24647000000000000000000000000000000000000000000000e0 * t2133
  t2138 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * t2135 * t143
  t2141 = 0.16081979498692535066756296899072713062105388428051e2 * t827 * t2109 * t829
  t2149 = t1475 ** 2
  t2162 = -0.17648625000000000000000000000000000000000000000000e1 * t2114 + 0.35297250000000000000000000000000000000000000000000e1 * t2118 + t851 - 0.10329500000000000000000000000000000000000000000000e1 * t1671 + 0.15494250000000000000000000000000000000000000000000e1 * t2102 + 0.31558125000000000000000000000000000000000000000000e0 * t2122 + 0.63116250000000000000000000000000000000000000000000e0 * t2124 + t856 - 0.41678000000000000000000000000000000000000000000000e0 * t1713 + 0.31258500000000000000000000000000000000000000000000e0 * t2129 + 0.31258500000000000000000000000000000000000000000000e0 * t2133
  t2172 = (t872 - 0.18541666666666666666666666666666666666666666666667e-1 * t1671 + 0.27812500000000000000000000000000000000000000000000e-1 * t2102) * t92
  t2176 = t1487 ** 2
  t2189 = -0.12946250000000000000000000000000000000000000000000e1 * t2114 + 0.25892500000000000000000000000000000000000000000000e1 * t2118 + t890 - 0.60385000000000000000000000000000000000000000000000e0 * t1671 + 0.90577500000000000000000000000000000000000000000000e0 * t2102 + 0.82524375000000000000000000000000000000000000000000e-1 * t2122 + 0.16504875000000000000000000000000000000000000000000e0 * t2124 + t895 - 0.33114000000000000000000000000000000000000000000000e0 * t1713 + 0.24835500000000000000000000000000000000000000000000e0 * t2129 + 0.24835500000000000000000000000000000000000000000000e0 * t2133
  t2196 = -0.3109070e-1 * (t833 - 0.34246666666666666666666666666666666666666666666666e-1 * t1671 + 0.51370000000000000000000000000000000000000000000000e-1 * t2102) * t79 + 0.20000000000000000000000000000000000000000000000000e1 * t1737 * t1476 - 0.20000000000000000000000000000000000000000000000000e1 * t844 * t2149 * t162 + 0.10000000000000000000000000000000000000000000000000e1 * t154 * t2162 * t162 + 0.32163958997385070133512593798145426124210776856102e2 * t866 * t2149 * t868 + t2106 - t2108 + t2112 - t2138 - t2141 - 0.19751673498613801407483339618206552048944131217655e-1 * t2172 + 0.11696447245269292414524477327518106963944910680856e1 * t1770 * t1488 - 0.11696447245269292414524477327518106963944910680856e1 * t883 * t2176 * t181 + 0.58482236226346462072622386637590534819724553404280e0 * t173 * t2189 * t181 + 0.17315859105681463759666483083807725165579399831905e2 * t905 * t2176 * t907
  t2214 = -t2106 + t2108 - t2112 + t2138 + t2141 + t68 * t2196 + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t2172 - 0.11696447245269292414524477327518106963944910680856e1 * t1801 * t1496 + 0.11696447245269292414524477327518106963944910680856e1 * t189 * t882 * t2176 * t181 - 0.58482236226346462072622386637590534819724553404280e0 * t189 * t172 * t2189 * t181 - 0.17315859105681463759666483083807725165579399831905e2 * t189 * t904 * t2176 * t907
  t2218 = f.my_piecewise3(t8, 0, t2089 * t99 / 0.2e1 + t1442 * t1499 + t101 * t2214 / 0.2e1)
  t2221 = -t2088
  t2222 = f.my_piecewise3(t318, 0, t2221)
  t2227 = t1506 ** 2
  t2233 = f.my_piecewise3(t318, 0, 0.4e1 / 0.9e1 * t1023 * t2227 - t382 * t2221 / 0.3e1)
  t2235 = t20 * t24 * t2233
  t2239 = 0.621814e-1 * (t1017 - 0.35616666666666666666666666666666666666666666666666e-1 * t1836 + 0.53425000000000000000000000000000000000000000000000e-1 * t2235) * t342
  t2241 = 0.20000000000000000000000000000000000000000000000000e1 * t1852 * t1529
  t2242 = t1528 ** 2
  t2245 = 0.20000000000000000000000000000000000000000000000000e1 * t1042 * t2242 * t413
  t2246 = t1518 ** 2
  t2247 = t1048 * t2246
  t2250 = t1052 - 0.2e1 / 0.3e1 * t1836 + t2235
  t2251 = t395 * t2250
  t2255 = t1060 * t2246
  t2257 = t402 * t2250
  t2260 = t1511 ** 2
  t2262 = t42 * t46 * t2260
  t2266 = t42 * t46 * t324 * t2233
  t2268 = -0.94946250000000000000000000000000000000000000000000e0 * t2247 + 0.18989250000000000000000000000000000000000000000000e1 * t2251 + t1057 - 0.59793333333333333333333333333333333333333333333334e0 * t1836 + 0.89690000000000000000000000000000000000000000000000e0 * t2235 + 0.15358125000000000000000000000000000000000000000000e0 * t2255 + 0.30716250000000000000000000000000000000000000000000e0 * t2257 + t1067 - 0.32862666666666666666666666666666666666666666666666e0 * t1878 + 0.24647000000000000000000000000000000000000000000000e0 * t2262 + 0.24647000000000000000000000000000000000000000000000e0 * t2266
  t2271 = 0.10000000000000000000000000000000000000000000000000e1 * t394 * t2268 * t413
  t2274 = 0.16081979498692535066756296899072713062105388428051e2 * t1085 * t2242 * t1087
  t2282 = t1540 ** 2
  t2295 = -0.17648625000000000000000000000000000000000000000000e1 * t2247 + 0.35297250000000000000000000000000000000000000000000e1 * t2251 + t1109 - 0.10329500000000000000000000000000000000000000000000e1 * t1836 + 0.15494250000000000000000000000000000000000000000000e1 * t2235 + 0.31558125000000000000000000000000000000000000000000e0 * t2255 + 0.63116250000000000000000000000000000000000000000000e0 * t2257 + t1114 - 0.41678000000000000000000000000000000000000000000000e0 * t1878 + 0.31258500000000000000000000000000000000000000000000e0 * t2262 + 0.31258500000000000000000000000000000000000000000000e0 * t2266
  t2305 = (t1130 - 0.18541666666666666666666666666666666666666666666667e-1 * t1836 + 0.27812500000000000000000000000000000000000000000000e-1 * t2235) * t368
  t2309 = t1552 ** 2
  t2322 = -0.12946250000000000000000000000000000000000000000000e1 * t2247 + 0.25892500000000000000000000000000000000000000000000e1 * t2251 + t1148 - 0.60385000000000000000000000000000000000000000000000e0 * t1836 + 0.90577500000000000000000000000000000000000000000000e0 * t2235 + 0.82524375000000000000000000000000000000000000000000e-1 * t2255 + 0.16504875000000000000000000000000000000000000000000e0 * t2257 + t1153 - 0.33114000000000000000000000000000000000000000000000e0 * t1878 + 0.24835500000000000000000000000000000000000000000000e0 * t2262 + 0.24835500000000000000000000000000000000000000000000e0 * t2266
  t2329 = -0.3109070e-1 * (t1091 - 0.34246666666666666666666666666666666666666666666666e-1 * t1836 + 0.51370000000000000000000000000000000000000000000000e-1 * t2235) * t355 + 0.20000000000000000000000000000000000000000000000000e1 * t1902 * t1541 - 0.20000000000000000000000000000000000000000000000000e1 * t1102 * t2282 * t432 + 0.10000000000000000000000000000000000000000000000000e1 * t424 * t2295 * t432 + 0.32163958997385070133512593798145426124210776856102e2 * t1124 * t2282 * t1126 + t2239 - t2241 + t2245 - t2271 - t2274 - 0.19751673498613801407483339618206552048944131217655e-1 * t2305 + 0.11696447245269292414524477327518106963944910680856e1 * t1935 * t1553 - 0.11696447245269292414524477327518106963944910680856e1 * t1141 * t2309 * t451 + 0.58482236226346462072622386637590534819724553404280e0 * t443 * t2322 * t451 + 0.17315859105681463759666483083807725165579399831905e2 * t1163 * t2309 * t1165
  t2347 = -t2239 + t2241 - t2245 + t2271 + t2274 + t68 * t2329 + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t2305 - 0.11696447245269292414524477327518106963944910680856e1 * t1966 * t1561 + 0.11696447245269292414524477327518106963944910680856e1 * t459 * t1140 * t2309 * t451 - 0.58482236226346462072622386637590534819724553404280e0 * t459 * t442 * t2322 * t451 - 0.17315859105681463759666483083807725165579399831905e2 * t459 * t1162 * t2309 * t1165
  t2351 = f.my_piecewise3(t319, 0, t2222 * t375 / 0.2e1 + t1507 * t1564 + t377 * t2347 / 0.2e1)
  t2360 = t1579 ** 2
  t2361 = t943 * t2360
  t2365 = 0.1e1 / t471 / t494
  t2366 = s2 * t2365
  t2368 = tau1 * t1574
  t2370 = 0.88e2 / 0.9e1 * t2366 + 0.80e2 / 0.9e1 * t2368
  t2371 = params.alpha_ss * t2370
  t2389 = 0.1e1 / t470 / t494 / t1572
  t2395 = t1594 * tau1
  t2398 = tau1 ** 2
  t2428 = -t2218 - t2351 + t1198 - 0.11696447245269292414524477327518106963944910680856e1 * t1996 - 0.36622894612013090109708692208757981924083909966068e-3 * t1999 + t1224 + t1233 - t1239 - t1243 + t1250 - t1259 - t1273
  t2434 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t1282 * t2094 + 0.4e1 / 0.3e1 * t27 * t2088)
  t2440 = f.my_piecewise3(t318, 0, 0.4e1 / 0.9e1 * t1290 * t2227 + 0.4e1 / 0.3e1 * t322 * t2221)
  t2442 = (t2434 + t2440) * t67
  t2450 = t1280 - t1304 - t1308 + t609 * t2442 * t599 - t1313 + t1321 + t1324 + t1327 + t1380 - 0.8e1 * t2026 - 0.8e1 * t2028 + 0.2e1 * t2033 + 0.19751673498613801407483339618206552048944131217655e-1 * t2442 * t597
  t2455 = t1387 * t2360
  t2458 = params.alpha_ab * t2370
  d22 = 0.2e1 * t1505 + 0.2e1 * t1570 + 0.2e1 * t1615 + t1620 / 0.4e1 + 0.2e1 * t1635 + 0.2e1 * t1663 + t3 * (t2218 * t251 * t258 + t2351 * t508 * t515 + 0.2e1 * t1568 * t1613 * t515 + t1569 * t1619 / 0.4e1 + t704 * (0.2e1 * t199 * t506 * t2361 - t1571 * t2371 + (0.88e2 / 0.9e1 * t484 * t2365 + 0.80e2 / 0.9e1 * t1584 * t1574) * t490 - 0.4e1 * t1587 * t506 * t1580 + 0.6e1 * t488 * t1609 * t2361 - 0.2e1 * t1589 * t2371 + (0.304e3 / 0.9e1 * t493 * t2389 + 0.88e2 / 0.9e1 * t499 * t2365 * t486 + 0.80e2 / 0.3e1 * t499 * t2395 + 0.200e3 / 0.9e1 * t244 * t2398 * t497 + 0.160e3 / 0.9e1 * t1603 * t2368) * t506 - 0.6e1 * t1606 * t1609 * t1580 + 0.12e2 * t504 / t1608 / t481 * t2361 - 0.3e1 * t1610 * t2371) * t515 + t1614 * t1619 / 0.4e1 - t1616 * s2 / t1572 * t512 / 0.4e1 + (t2428 + t2450) * t696 + 0.2e1 * t1634 * t1662 + t705 * (0.2e1 * t1386 * t2455 - t706 * t2458 + (0.88e2 / 0.9e1 * t1638 * t2365 + 0.80e2 / 0.9e1 * t1641 * t1574) * t681 - 0.4e1 * t2043 * t1636 + 0.6e1 * t1402 * t2455 - 0.2e1 * t717 * t2458 + (0.128e3 / 0.9e1 * t683 * t492 * t2389 + 0.176e3 / 0.9e1 * t720 * t2366 + 0.88e2 / 0.9e1 * t1650 * t2365 * t677 + 0.160e3 / 0.9e1 * t1650 * t2395 + 0.80e2 / 0.9e1 * t687 * t2368 + 0.200e3 / 0.9e1 * t689 * t2398 * t497 + 0.160e3 / 0.9e1 * t729 * t2368) * t694 - 0.6e1 * t2070 * t1636 + 0.12e2 * t1431 * t2455 - 0.3e1 * t736 * t2458))
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t2 = r0 - r1
  t3 = r0 + r1
  t4 = 0.1e1 / t3
  t5 = t2 * t4
  t6 = 0.1e1 + t5
  t7 = t6 <= f.p.zeta_threshold
  t8 = r0 <= f.p.dens_threshold or t7
  t9 = t3 ** 2
  t10 = 0.1e1 / t9
  t11 = t2 * t10
  t12 = t4 - t11
  t13 = f.my_piecewise3(t7, 0, t12)
  t14 = 3 ** (0.1e1 / 0.3e1)
  t16 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t17 = t14 * t16
  t18 = 4 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t20 = t17 * t19
  t21 = t3 ** (0.1e1 / 0.3e1)
  t22 = 0.1e1 / t21
  t23 = 2 ** (0.1e1 / 0.3e1)
  t24 = t22 * t23
  t25 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t26 = 0.1e1 / t25
  t27 = t6 ** (0.1e1 / 0.3e1)
  t29 = f.my_piecewise3(t7, t26, 0.1e1 / t27)
  t31 = t20 * t24 * t29
  t33 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t31
  t34 = jnp.sqrt(t31)
  t37 = t31 ** 0.15e1
  t39 = t14 ** 2
  t40 = t16 ** 2
  t41 = t39 * t40
  t42 = t41 * t18
  t43 = t21 ** 2
  t44 = 0.1e1 / t43
  t45 = t23 ** 2
  t46 = t44 * t45
  t47 = t29 ** 2
  t49 = t42 * t46 * t47
  t51 = 0.37978500000000000000000000000000000000000000000000e1 * t34 + 0.89690000000000000000000000000000000000000000000000e0 * t31 + 0.20477500000000000000000000000000000000000000000000e0 * t37 + 0.12323500000000000000000000000000000000000000000000e0 * t49
  t54 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t51
  t55 = jnp.log(t54)
  t57 = 0.621814e-1 * t33 * t55
  t59 = t25 * f.p.zeta_threshold
  t61 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t59, 0.2e1 * t23)
  t63 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t59, 0)
  t67 = 0.1e1 / (0.2e1 * t23 - 0.2e1)
  t68 = (t61 + t63 - 0.2e1) * t67
  t70 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t31
  t75 = 0.70594500000000000000000000000000000000000000000000e1 * t34 + 0.15494250000000000000000000000000000000000000000000e1 * t31 + 0.42077500000000000000000000000000000000000000000000e0 * t37 + 0.15629250000000000000000000000000000000000000000000e0 * t49
  t78 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t75
  t79 = jnp.log(t78)
  t83 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t31
  t88 = 0.51785000000000000000000000000000000000000000000000e1 * t34 + 0.90577500000000000000000000000000000000000000000000e0 * t31 + 0.11003250000000000000000000000000000000000000000000e0 * t37 + 0.12417750000000000000000000000000000000000000000000e0 * t49
  t91 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t88
  t92 = jnp.log(t91)
  t93 = t83 * t92
  t99 = -t57 + t68 * (-0.3109070e-1 * t70 * t79 + t57 - 0.19751673498613801407483339618206552048944131217655e-1 * t93) + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t93
  t101 = f.my_piecewise3(t7, f.p.zeta_threshold, t6)
  t103 = 0.1e1 / t21 / t3
  t104 = t103 * t23
  t106 = t20 * t104 * t29
  t107 = 0.17808333333333333333333333333333333333333333333333e-1 * t106
  t108 = t27 * t6
  t109 = 0.1e1 / t108
  t112 = f.my_piecewise3(t7, 0, -t109 * t12 / 0.3e1)
  t114 = t20 * t24 * t112
  t116 = -t107 + 0.53425000000000000000000000000000000000000000000000e-1 * t114
  t118 = 0.621814e-1 * t116 * t55
  t119 = t51 ** 2
  t120 = 0.1e1 / t119
  t121 = t33 * t120
  t122 = 0.1e1 / t34
  t123 = t106 / 0.3e1
  t124 = -t123 + t114
  t125 = t122 * t124
  t127 = 0.29896666666666666666666666666666666666666666666667e0 * t106
  t129 = t31 ** 0.5e0
  t130 = t129 * t124
  t133 = 0.1e1 / t43 / t3
  t134 = t133 * t45
  t136 = t42 * t134 * t47
  t137 = 0.82156666666666666666666666666666666666666666666667e-1 * t136
  t138 = t29 * t112
  t140 = t42 * t46 * t138
  t142 = 0.18989250000000000000000000000000000000000000000000e1 * t125 - t127 + 0.89690000000000000000000000000000000000000000000000e0 * t114 + 0.30716250000000000000000000000000000000000000000000e0 * t130 - t137 + 0.24647000000000000000000000000000000000000000000000e0 * t140
  t143 = 0.1e1 / t54
  t144 = t142 * t143
  t146 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * t144
  t147 = 0.17123333333333333333333333333333333333333333333333e-1 * t106
  t149 = -t147 + 0.51370000000000000000000000000000000000000000000000e-1 * t114
  t152 = t75 ** 2
  t153 = 0.1e1 / t152
  t154 = t70 * t153
  t156 = 0.51647500000000000000000000000000000000000000000000e0 * t106
  t159 = 0.10419500000000000000000000000000000000000000000000e0 * t136
  t161 = 0.35297250000000000000000000000000000000000000000000e1 * t125 - t156 + 0.15494250000000000000000000000000000000000000000000e1 * t114 + 0.63116250000000000000000000000000000000000000000000e0 * t130 - t159 + 0.31258500000000000000000000000000000000000000000000e0 * t140
  t162 = 0.1e1 / t78
  t163 = t161 * t162
  t166 = 0.92708333333333333333333333333333333333333333333333e-2 * t106
  t168 = -t166 + 0.27812500000000000000000000000000000000000000000000e-1 * t114
  t169 = t168 * t92
  t171 = t88 ** 2
  t172 = 0.1e1 / t171
  t173 = t83 * t172
  t175 = 0.30192500000000000000000000000000000000000000000000e0 * t106
  t178 = 0.82785000000000000000000000000000000000000000000000e-1 * t136
  t180 = 0.25892500000000000000000000000000000000000000000000e1 * t125 - t175 + 0.90577500000000000000000000000000000000000000000000e0 * t114 + 0.16504875000000000000000000000000000000000000000000e0 * t130 - t178 + 0.24835500000000000000000000000000000000000000000000e0 * t140
  t181 = 0.1e1 / t91
  t182 = t180 * t181
  t189 = t68 * t83
  t191 = t172 * t180 * t181
  t194 = -t118 + t146 + t68 * (-0.3109070e-1 * t149 * t79 + 0.10000000000000000000000000000000000000000000000000e1 * t154 * t163 + t118 - t146 - 0.19751673498613801407483339618206552048944131217655e-1 * t169 + 0.58482236226346462072622386637590534819724553404280e0 * t173 * t182) + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t169 - 0.58482236226346462072622386637590534819724553404280e0 * t189 * t191
  t198 = f.my_piecewise3(t8, 0, t101 * t194 / 0.2e1 + t13 * t99 / 0.2e1)
  t199 = params.dss[0]
  t200 = r0 ** 2
  t201 = r0 ** (0.1e1 / 0.3e1)
  t202 = t201 ** 2
  t204 = 0.1e1 / t202 / t200
  t205 = s0 * t204
  t209 = 0.2e1 * tau0 / t202 / r0
  t210 = 6 ** (0.1e1 / 0.3e1)
  t211 = t210 ** 2
  t212 = jnp.pi ** 2
  t213 = t212 ** (0.1e1 / 0.3e1)
  t214 = t213 ** 2
  t215 = t211 * t214
  t216 = 0.3e1 / 0.5e1 * t215
  t219 = 0.1e1 + params.alpha_ss * (t205 + t209 - t216)
  t222 = params.dss[1]
  t223 = t222 * s0
  t225 = params.dss[2]
  t226 = t209 - t216
  t228 = t223 * t204 + t225 * t226
  t229 = t219 ** 2
  t230 = 0.1e1 / t229
  t232 = params.dss[3]
  t233 = s0 ** 2
  t234 = t232 * t233
  t235 = t200 ** 2
  t238 = 0.1e1 / t201 / t235 / r0
  t240 = params.dss[4]
  t241 = t240 * s0
  t244 = params.dss[5]
  t245 = t226 ** 2
  t247 = t241 * t204 * t226 + t234 * t238 + t244 * t245
  t249 = 0.1e1 / t229 / t219
  t251 = t199 / t219 + t228 * t230 + t247 * t249
  t252 = t198 * t251
  t255 = 0.1e1 / tau0
  t258 = 0.1e1 - s0 / r0 * t255 / 0.8e1
  t259 = t252 * t258
  t263 = f.my_piecewise3(t8, 0, t101 * t99 / 0.2e1)
  t264 = t199 * t230
  t265 = t200 * r0
  t267 = 0.1e1 / t202 / t265
  t268 = s0 * t267
  t270 = tau0 * t204
  t272 = -0.8e1 / 0.3e1 * t268 - 0.10e2 / 0.3e1 * t270
  t273 = params.alpha_ss * t272
  t277 = t225 * tau0
  t280 = -0.8e1 / 0.3e1 * t223 * t267 - 0.10e2 / 0.3e1 * t277 * t204
  t282 = t228 * t249
  t287 = 0.1e1 / t201 / t235 / t200
  t296 = t244 * t226
  t299 = -0.16e2 / 0.3e1 * t234 * t287 - 0.8e1 / 0.3e1 * t241 * t267 * t226 - 0.10e2 / 0.3e1 * t241 * t238 * tau0 - 0.20e2 / 0.3e1 * t296 * t270
  t301 = t229 ** 2
  t302 = 0.1e1 / t301
  t303 = t247 * t302
  t306 = t280 * t230 + t299 * t249 - t264 * t273 - 0.2e1 * t282 * t273 - 0.3e1 * t303 * t273
  t307 = t263 * t306
  t308 = t307 * t258
  t310 = t263 * t251
  t313 = s0 / t200 * t255
  t314 = t310 * t313
  t317 = 0.1e1 - t5
  t318 = t317 <= f.p.zeta_threshold
  t319 = r1 <= f.p.dens_threshold or t318
  t320 = -t12
  t321 = f.my_piecewise3(t318, 0, t320)
  t322 = t317 ** (0.1e1 / 0.3e1)
  t324 = f.my_piecewise3(t318, t26, 0.1e1 / t322)
  t326 = t20 * t24 * t324
  t328 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t326
  t329 = jnp.sqrt(t326)
  t332 = t326 ** 0.15e1
  t334 = t324 ** 2
  t336 = t42 * t46 * t334
  t338 = 0.37978500000000000000000000000000000000000000000000e1 * t329 + 0.89690000000000000000000000000000000000000000000000e0 * t326 + 0.20477500000000000000000000000000000000000000000000e0 * t332 + 0.12323500000000000000000000000000000000000000000000e0 * t336
  t341 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t338
  t342 = jnp.log(t341)
  t344 = 0.621814e-1 * t328 * t342
  t346 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t326
  t351 = 0.70594500000000000000000000000000000000000000000000e1 * t329 + 0.15494250000000000000000000000000000000000000000000e1 * t326 + 0.42077500000000000000000000000000000000000000000000e0 * t332 + 0.15629250000000000000000000000000000000000000000000e0 * t336
  t354 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t351
  t355 = jnp.log(t354)
  t359 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t326
  t364 = 0.51785000000000000000000000000000000000000000000000e1 * t329 + 0.90577500000000000000000000000000000000000000000000e0 * t326 + 0.11003250000000000000000000000000000000000000000000e0 * t332 + 0.12417750000000000000000000000000000000000000000000e0 * t336
  t367 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t364
  t368 = jnp.log(t367)
  t369 = t359 * t368
  t375 = -t344 + t68 * (-0.3109070e-1 * t346 * t355 + t344 - 0.19751673498613801407483339618206552048944131217655e-1 * t369) + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t369
  t377 = f.my_piecewise3(t318, f.p.zeta_threshold, t317)
  t379 = t20 * t104 * t324
  t380 = 0.17808333333333333333333333333333333333333333333333e-1 * t379
  t381 = t322 * t317
  t382 = 0.1e1 / t381
  t385 = f.my_piecewise3(t318, 0, -t382 * t320 / 0.3e1)
  t387 = t20 * t24 * t385
  t389 = -t380 + 0.53425000000000000000000000000000000000000000000000e-1 * t387
  t391 = 0.621814e-1 * t389 * t342
  t392 = t338 ** 2
  t393 = 0.1e1 / t392
  t394 = t328 * t393
  t395 = 0.1e1 / t329
  t396 = t379 / 0.3e1
  t397 = -t396 + t387
  t398 = t395 * t397
  t400 = 0.29896666666666666666666666666666666666666666666667e0 * t379
  t402 = t326 ** 0.5e0
  t403 = t402 * t397
  t406 = t42 * t134 * t334
  t407 = 0.82156666666666666666666666666666666666666666666667e-1 * t406
  t408 = t324 * t385
  t410 = t42 * t46 * t408
  t412 = 0.18989250000000000000000000000000000000000000000000e1 * t398 - t400 + 0.89690000000000000000000000000000000000000000000000e0 * t387 + 0.30716250000000000000000000000000000000000000000000e0 * t403 - t407 + 0.24647000000000000000000000000000000000000000000000e0 * t410
  t413 = 0.1e1 / t341
  t414 = t412 * t413
  t416 = 0.10000000000000000000000000000000000000000000000000e1 * t394 * t414
  t417 = 0.17123333333333333333333333333333333333333333333333e-1 * t379
  t419 = -t417 + 0.51370000000000000000000000000000000000000000000000e-1 * t387
  t422 = t351 ** 2
  t423 = 0.1e1 / t422
  t424 = t346 * t423
  t426 = 0.51647500000000000000000000000000000000000000000000e0 * t379
  t429 = 0.10419500000000000000000000000000000000000000000000e0 * t406
  t431 = 0.35297250000000000000000000000000000000000000000000e1 * t398 - t426 + 0.15494250000000000000000000000000000000000000000000e1 * t387 + 0.63116250000000000000000000000000000000000000000000e0 * t403 - t429 + 0.31258500000000000000000000000000000000000000000000e0 * t410
  t432 = 0.1e1 / t354
  t433 = t431 * t432
  t436 = 0.92708333333333333333333333333333333333333333333333e-2 * t379
  t438 = -t436 + 0.27812500000000000000000000000000000000000000000000e-1 * t387
  t439 = t438 * t368
  t441 = t364 ** 2
  t442 = 0.1e1 / t441
  t443 = t359 * t442
  t445 = 0.30192500000000000000000000000000000000000000000000e0 * t379
  t448 = 0.82785000000000000000000000000000000000000000000000e-1 * t406
  t450 = 0.25892500000000000000000000000000000000000000000000e1 * t398 - t445 + 0.90577500000000000000000000000000000000000000000000e0 * t387 + 0.16504875000000000000000000000000000000000000000000e0 * t403 - t448 + 0.24835500000000000000000000000000000000000000000000e0 * t410
  t451 = 0.1e1 / t367
  t452 = t450 * t451
  t459 = t68 * t359
  t461 = t442 * t450 * t451
  t464 = -t391 + t416 + t68 * (-0.3109070e-1 * t419 * t355 + 0.10000000000000000000000000000000000000000000000000e1 * t424 * t433 + t391 - t416 - 0.19751673498613801407483339618206552048944131217655e-1 * t439 + 0.58482236226346462072622386637590534819724553404280e0 * t443 * t452) + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t439 - 0.58482236226346462072622386637590534819724553404280e0 * t459 * t461
  t468 = f.my_piecewise3(t319, 0, t321 * t375 / 0.2e1 + t377 * t464 / 0.2e1)
  t469 = r1 ** 2
  t470 = r1 ** (0.1e1 / 0.3e1)
  t471 = t470 ** 2
  t473 = 0.1e1 / t471 / t469
  t474 = s2 * t473
  t478 = 0.2e1 * tau1 / t471 / r1
  t481 = 0.1e1 + params.alpha_ss * (t474 + t478 - t216)
  t484 = t222 * s2
  t486 = t478 - t216
  t488 = t225 * t486 + t484 * t473
  t489 = t481 ** 2
  t490 = 0.1e1 / t489
  t492 = s2 ** 2
  t493 = t232 * t492
  t494 = t469 ** 2
  t497 = 0.1e1 / t470 / t494 / r1
  t499 = t240 * s2
  t502 = t486 ** 2
  t504 = t499 * t473 * t486 + t244 * t502 + t493 * t497
  t506 = 0.1e1 / t489 / t481
  t508 = t199 / t481 + t488 * t490 + t504 * t506
  t509 = t468 * t508
  t512 = 0.1e1 / tau1
  t515 = 0.1e1 - s2 / r1 * t512 / 0.8e1
  t516 = t509 * t515
  t518 = t19 * t103
  t520 = t17 * t19 * t22
  t521 = jnp.sqrt(t520)
  t524 = t520 ** 0.15e1
  t527 = t41 * t18 * t44
  t529 = 0.37978500000000000000000000000000000000000000000000e1 * t521 + 0.89690000000000000000000000000000000000000000000000e0 * t520 + 0.20477500000000000000000000000000000000000000000000e0 * t524 + 0.12323500000000000000000000000000000000000000000000e0 * t527
  t532 = 0.1e1 + 0.16081979498692535066756296899072713062105388428051e2 / t529
  t533 = jnp.log(t532)
  t536 = 0.11073470983333333333333333333333333333333333333333e-2 * t17 * t518 * t533
  t538 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t520
  t539 = t529 ** 2
  t540 = 0.1e1 / t539
  t541 = t538 * t540
  t543 = 0.1e1 / t521 * t14
  t544 = t16 * t19
  t545 = t544 * t103
  t546 = t543 * t545
  t548 = t17 * t518
  t550 = t520 ** 0.5e0
  t551 = t550 * t14
  t552 = t551 * t545
  t555 = t41 * t18 * t133
  t557 = -0.63297500000000000000000000000000000000000000000000e0 * t546 - 0.29896666666666666666666666666666666666666666666667e0 * t548 - 0.10238750000000000000000000000000000000000000000000e0 * t552 - 0.82156666666666666666666666666666666666666666666667e-1 * t555
  t558 = 0.1e1 / t532
  t559 = t557 * t558
  t561 = 0.10000000000000000000000000000000000000000000000000e1 * t541 * t559
  t562 = t2 ** 2
  t563 = t562 * t2
  t564 = t9 ** 2
  t565 = 0.1e1 / t564
  t566 = t563 * t565
  t567 = f.my_piecewise3(t7, t59, t108)
  t568 = f.my_piecewise3(t318, t59, t381)
  t570 = (t567 + t568 - 0.2e1) * t67
  t572 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t520
  t577 = 0.70594500000000000000000000000000000000000000000000e1 * t521 + 0.15494250000000000000000000000000000000000000000000e1 * t520 + 0.42077500000000000000000000000000000000000000000000e0 * t524 + 0.15629250000000000000000000000000000000000000000000e0 * t527
  t580 = 0.1e1 + 0.32163958997385070133512593798145426124210776856102e2 / t577
  t581 = jnp.log(t580)
  t585 = 0.621814e-1 * t538 * t533
  t587 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t520
  t592 = 0.51785000000000000000000000000000000000000000000000e1 * t521 + 0.90577500000000000000000000000000000000000000000000e0 * t520 + 0.11003250000000000000000000000000000000000000000000e0 * t524 + 0.12417750000000000000000000000000000000000000000000e0 * t527
  t595 = 0.1e1 + 0.29608749977793437516654921862508808603118393547661e2 / t592
  t596 = jnp.log(t595)
  t597 = t587 * t596
  t599 = -0.3109070e-1 * t572 * t581 + t585 - 0.19751673498613801407483339618206552048944131217655e-1 * t597
  t600 = t570 * t599
  t602 = 0.4e1 * t566 * t600
  t603 = t562 ** 2
  t605 = 0.1e1 / t564 / t3
  t606 = t603 * t605
  t608 = 0.4e1 * t606 * t600
  t609 = t603 * t565
  t612 = f.my_piecewise3(t7, 0, 0.4e1 / 0.3e1 * t27 * t12)
  t615 = f.my_piecewise3(t318, 0, 0.4e1 / 0.3e1 * t322 * t320)
  t617 = (t612 + t615) * t67
  t618 = t617 * t599
  t623 = t577 ** 2
  t624 = 0.1e1 / t623
  t625 = t572 * t624
  t630 = -0.11765750000000000000000000000000000000000000000000e1 * t546 - 0.51647500000000000000000000000000000000000000000000e0 * t548 - 0.21038750000000000000000000000000000000000000000000e0 * t552 - 0.10419500000000000000000000000000000000000000000000e0 * t555
  t631 = 0.1e1 / t580
  t632 = t630 * t631
  t638 = t592 ** 2
  t639 = 0.1e1 / t638
  t640 = t587 * t639
  t645 = -0.86308333333333333333333333333333333333333333333334e0 * t546 - 0.30192500000000000000000000000000000000000000000000e0 * t548 - 0.55016250000000000000000000000000000000000000000000e-1 * t552 - 0.82785000000000000000000000000000000000000000000000e-1 * t555
  t646 = 0.1e1 / t595
  t647 = t645 * t646
  t650 = 0.53237641966666666666666666666666666666666666666666e-3 * t17 * t518 * t581 + 0.10000000000000000000000000000000000000000000000000e1 * t625 * t632 - t536 - t561 + 0.18311447306006545054854346104378990962041954983034e-3 * t17 * t518 * t596 + 0.58482236226346462072622386637590534819724553404280e0 * t640 * t647
  t651 = t570 * t650
  t652 = t609 * t651
  t655 = t570 * t14
  t657 = t544 * t103 * t596
  t659 = 0.18311447306006545054854346104378990962041954983034e-3 * t655 * t657
  t660 = t570 * t587
  t662 = t639 * t645 * t646
  t664 = 0.58482236226346462072622386637590534819724553404280e0 * t660 * t662
  t665 = t536 + t561 + t602 - t608 + t609 * t618 + t652 + 0.19751673498613801407483339618206552048944131217655e-1 * t617 * t597 - t659 - t664 - t198 - t468
  t666 = params.dab[0]
  t667 = 0.6e1 / 0.5e1 * t215
  t670 = 0.1e1 + params.alpha_ab * (t205 + t474 + t209 + t478 - t667)
  t673 = params.dab[1]
  t674 = t205 + t474
  t676 = params.dab[2]
  t677 = t209 + t478 - t667
  t679 = t673 * t674 + t676 * t677
  t680 = t670 ** 2
  t681 = 0.1e1 / t680
  t683 = params.dab[3]
  t684 = t674 ** 2
  t686 = params.dab[4]
  t687 = t686 * t674
  t689 = params.dab[5]
  t690 = t677 ** 2
  t692 = t687 * t677 + t683 * t684 + t689 * t690
  t694 = 0.1e1 / t680 / t670
  t696 = t666 / t670 + t679 * t681 + t692 * t694
  t697 = t665 * t696
  t704 = f.my_piecewise3(t319, 0, t377 * t375 / 0.2e1)
  t705 = -t585 + t609 * t600 + 0.19751673498613801407483339618206552048944131217655e-1 * t570 * t597 - t263 - t704
  t706 = t666 * t681
  t707 = params.alpha_ab * t272
  t709 = t673 * s0
  t712 = t676 * tau0
  t715 = -0.8e1 / 0.3e1 * t709 * t267 - 0.10e2 / 0.3e1 * t712 * t204
  t717 = t679 * t694
  t720 = t683 * t674
  t723 = t686 * s0
  t729 = t689 * t677
  t732 = -0.16e2 / 0.3e1 * t720 * t268 - 0.8e1 / 0.3e1 * t723 * t267 * t677 - 0.10e2 / 0.3e1 * t687 * t270 - 0.20e2 / 0.3e1 * t729 * t270
  t734 = t680 ** 2
  t735 = 0.1e1 / t734
  t736 = t692 * t735
  t739 = t715 * t681 + t732 * t694 - t706 * t707 - 0.2e1 * t717 * t707 - 0.3e1 * t736 * t707
  t740 = t705 * t739
  t743 = 0.1e1 / t9 / t3
  t744 = t2 * t743
  t746 = -0.2e1 * t10 + 0.2e1 * t744
  t747 = f.my_piecewise3(t7, 0, t746)
  t752 = 0.1e1 / t21 / t9
  t753 = t752 * t23
  t755 = t20 * t753 * t29
  t756 = 0.23744444444444444444444444444444444444444444444444e-1 * t755
  t758 = t20 * t104 * t112
  t760 = t6 ** 2
  t762 = 0.1e1 / t27 / t760
  t763 = t12 ** 2
  t769 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t762 * t763 - t109 * t746 / 0.3e1)
  t771 = t20 * t24 * t769
  t775 = 0.621814e-1 * (t756 - 0.35616666666666666666666666666666666666666666666666e-1 * t758 + 0.53425000000000000000000000000000000000000000000000e-1 * t771) * t55
  t776 = t116 * t120
  t778 = 0.20000000000000000000000000000000000000000000000000e1 * t776 * t144
  t781 = t33 / t119 / t51
  t782 = t142 ** 2
  t785 = 0.20000000000000000000000000000000000000000000000000e1 * t781 * t782 * t143
  t787 = 0.1e1 / t34 / t31
  t788 = t124 ** 2
  t789 = t787 * t788
  t791 = 0.4e1 / 0.9e1 * t755
  t793 = t791 - 0.2e1 / 0.3e1 * t758 + t771
  t794 = t122 * t793
  t796 = 0.39862222222222222222222222222222222222222222222223e0 * t755
  t799 = t31 ** (-0.5e0)
  t800 = t799 * t788
  t802 = t129 * t793
  t805 = 0.1e1 / t43 / t9
  t806 = t805 * t45
  t808 = t42 * t806 * t47
  t809 = 0.13692777777777777777777777777777777777777777777778e0 * t808
  t811 = t42 * t134 * t138
  t813 = t112 ** 2
  t815 = t42 * t46 * t813
  t819 = t42 * t46 * t29 * t769
  t821 = -0.94946250000000000000000000000000000000000000000000e0 * t789 + 0.18989250000000000000000000000000000000000000000000e1 * t794 + t796 - 0.59793333333333333333333333333333333333333333333334e0 * t758 + 0.89690000000000000000000000000000000000000000000000e0 * t771 + 0.15358125000000000000000000000000000000000000000000e0 * t800 + 0.30716250000000000000000000000000000000000000000000e0 * t802 + t809 - 0.32862666666666666666666666666666666666666666666666e0 * t811 + 0.24647000000000000000000000000000000000000000000000e0 * t815 + 0.24647000000000000000000000000000000000000000000000e0 * t819
  t824 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * t821 * t143
  t825 = t119 ** 2
  t827 = t33 / t825
  t828 = t54 ** 2
  t829 = 0.1e1 / t828
  t832 = 0.16081979498692535066756296899072713062105388428051e2 * t827 * t782 * t829
  t833 = 0.22831111111111111111111111111111111111111111111111e-1 * t755
  t839 = t149 * t153
  t844 = t70 / t152 / t75
  t845 = t161 ** 2
  t851 = 0.68863333333333333333333333333333333333333333333333e0 * t755
  t856 = 0.17365833333333333333333333333333333333333333333333e0 * t808
  t860 = -0.17648625000000000000000000000000000000000000000000e1 * t789 + 0.35297250000000000000000000000000000000000000000000e1 * t794 + t851 - 0.10329500000000000000000000000000000000000000000000e1 * t758 + 0.15494250000000000000000000000000000000000000000000e1 * t771 + 0.31558125000000000000000000000000000000000000000000e0 * t800 + 0.63116250000000000000000000000000000000000000000000e0 * t802 + t856 - 0.41678000000000000000000000000000000000000000000000e0 * t811 + 0.31258500000000000000000000000000000000000000000000e0 * t815 + 0.31258500000000000000000000000000000000000000000000e0 * t819
  t864 = t152 ** 2
  t866 = t70 / t864
  t867 = t78 ** 2
  t868 = 0.1e1 / t867
  t872 = 0.12361111111111111111111111111111111111111111111111e-1 * t755
  t876 = (t872 - 0.18541666666666666666666666666666666666666666666667e-1 * t758 + 0.27812500000000000000000000000000000000000000000000e-1 * t771) * t92
  t878 = t168 * t172
  t882 = 0.1e1 / t171 / t88
  t883 = t83 * t882
  t884 = t180 ** 2
  t890 = 0.40256666666666666666666666666666666666666666666667e0 * t755
  t895 = 0.13797500000000000000000000000000000000000000000000e0 * t808
  t899 = -0.12946250000000000000000000000000000000000000000000e1 * t789 + 0.25892500000000000000000000000000000000000000000000e1 * t794 + t890 - 0.60385000000000000000000000000000000000000000000000e0 * t758 + 0.90577500000000000000000000000000000000000000000000e0 * t771 + 0.82524375000000000000000000000000000000000000000000e-1 * t800 + 0.16504875000000000000000000000000000000000000000000e0 * t802 + t895 - 0.33114000000000000000000000000000000000000000000000e0 * t811 + 0.24835500000000000000000000000000000000000000000000e0 * t815 + 0.24835500000000000000000000000000000000000000000000e0 * t819
  t903 = t171 ** 2
  t904 = 0.1e1 / t903
  t905 = t83 * t904
  t906 = t91 ** 2
  t907 = 0.1e1 / t906
  t911 = -0.3109070e-1 * (t833 - 0.34246666666666666666666666666666666666666666666666e-1 * t758 + 0.51370000000000000000000000000000000000000000000000e-1 * t771) * t79 + 0.20000000000000000000000000000000000000000000000000e1 * t839 * t163 - 0.20000000000000000000000000000000000000000000000000e1 * t844 * t845 * t162 + 0.10000000000000000000000000000000000000000000000000e1 * t154 * t860 * t162 + 0.32163958997385070133512593798145426124210776856102e2 * t866 * t845 * t868 + t775 - t778 + t785 - t824 - t832 - 0.19751673498613801407483339618206552048944131217655e-1 * t876 + 0.11696447245269292414524477327518106963944910680856e1 * t878 * t182 - 0.11696447245269292414524477327518106963944910680856e1 * t883 * t884 * t181 + 0.58482236226346462072622386637590534819724553404280e0 * t173 * t899 * t181 + 0.17315859105681463759666483083807725165579399831905e2 * t905 * t884 * t907
  t915 = t68 * t168
  t930 = -t775 + t778 - t785 + t824 + t832 + t68 * t911 + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t876 - 0.11696447245269292414524477327518106963944910680856e1 * t915 * t191 + 0.11696447245269292414524477327518106963944910680856e1 * t189 * t882 * t884 * t181 - 0.58482236226346462072622386637590534819724553404280e0 * t189 * t172 * t899 * t181 - 0.17315859105681463759666483083807725165579399831905e2 * t189 * t904 * t884 * t907
  t934 = f.my_piecewise3(t8, 0, t747 * t99 / 0.2e1 + t13 * t194 + t101 * t930 / 0.2e1)
  t943 = params.alpha_ss ** 2
  t944 = t272 ** 2
  t945 = t943 * t944
  t949 = 0.1e1 / t202 / t235
  t950 = s0 * t949
  t952 = tau0 * t267
  t954 = 0.88e2 / 0.9e1 * t950 + 0.80e2 / 0.9e1 * t952
  t955 = params.alpha_ss * t954
  t973 = 0.1e1 / t201 / t235 / t265
  t979 = t287 * tau0
  t982 = tau0 ** 2
  t1010 = -t746
  t1011 = f.my_piecewise3(t318, 0, t1010)
  t1016 = t20 * t753 * t324
  t1017 = 0.23744444444444444444444444444444444444444444444444e-1 * t1016
  t1019 = t20 * t104 * t385
  t1021 = t317 ** 2
  t1023 = 0.1e1 / t322 / t1021
  t1024 = t320 ** 2
  t1030 = f.my_piecewise3(t318, 0, 0.4e1 / 0.9e1 * t1023 * t1024 - t382 * t1010 / 0.3e1)
  t1032 = t20 * t24 * t1030
  t1036 = 0.621814e-1 * (t1017 - 0.35616666666666666666666666666666666666666666666666e-1 * t1019 + 0.53425000000000000000000000000000000000000000000000e-1 * t1032) * t342
  t1037 = t389 * t393
  t1039 = 0.20000000000000000000000000000000000000000000000000e1 * t1037 * t414
  t1042 = t328 / t392 / t338
  t1043 = t412 ** 2
  t1046 = 0.20000000000000000000000000000000000000000000000000e1 * t1042 * t1043 * t413
  t1048 = 0.1e1 / t329 / t326
  t1049 = t397 ** 2
  t1050 = t1048 * t1049
  t1052 = 0.4e1 / 0.9e1 * t1016
  t1054 = t1052 - 0.2e1 / 0.3e1 * t1019 + t1032
  t1055 = t395 * t1054
  t1057 = 0.39862222222222222222222222222222222222222222222223e0 * t1016
  t1060 = t326 ** (-0.5e0)
  t1061 = t1060 * t1049
  t1063 = t402 * t1054
  t1066 = t42 * t806 * t334
  t1067 = 0.13692777777777777777777777777777777777777777777778e0 * t1066
  t1069 = t42 * t134 * t408
  t1071 = t385 ** 2
  t1073 = t42 * t46 * t1071
  t1077 = t42 * t46 * t324 * t1030
  t1079 = -0.94946250000000000000000000000000000000000000000000e0 * t1050 + 0.18989250000000000000000000000000000000000000000000e1 * t1055 + t1057 - 0.59793333333333333333333333333333333333333333333334e0 * t1019 + 0.89690000000000000000000000000000000000000000000000e0 * t1032 + 0.15358125000000000000000000000000000000000000000000e0 * t1061 + 0.30716250000000000000000000000000000000000000000000e0 * t1063 + t1067 - 0.32862666666666666666666666666666666666666666666666e0 * t1069 + 0.24647000000000000000000000000000000000000000000000e0 * t1073 + 0.24647000000000000000000000000000000000000000000000e0 * t1077
  t1082 = 0.10000000000000000000000000000000000000000000000000e1 * t394 * t1079 * t413
  t1083 = t392 ** 2
  t1085 = t328 / t1083
  t1086 = t341 ** 2
  t1087 = 0.1e1 / t1086
  t1090 = 0.16081979498692535066756296899072713062105388428051e2 * t1085 * t1043 * t1087
  t1091 = 0.22831111111111111111111111111111111111111111111111e-1 * t1016
  t1097 = t419 * t423
  t1102 = t346 / t422 / t351
  t1103 = t431 ** 2
  t1109 = 0.68863333333333333333333333333333333333333333333333e0 * t1016
  t1114 = 0.17365833333333333333333333333333333333333333333333e0 * t1066
  t1118 = -0.17648625000000000000000000000000000000000000000000e1 * t1050 + 0.35297250000000000000000000000000000000000000000000e1 * t1055 + t1109 - 0.10329500000000000000000000000000000000000000000000e1 * t1019 + 0.15494250000000000000000000000000000000000000000000e1 * t1032 + 0.31558125000000000000000000000000000000000000000000e0 * t1061 + 0.63116250000000000000000000000000000000000000000000e0 * t1063 + t1114 - 0.41678000000000000000000000000000000000000000000000e0 * t1069 + 0.31258500000000000000000000000000000000000000000000e0 * t1073 + 0.31258500000000000000000000000000000000000000000000e0 * t1077
  t1122 = t422 ** 2
  t1124 = t346 / t1122
  t1125 = t354 ** 2
  t1126 = 0.1e1 / t1125
  t1130 = 0.12361111111111111111111111111111111111111111111111e-1 * t1016
  t1134 = (t1130 - 0.18541666666666666666666666666666666666666666666667e-1 * t1019 + 0.27812500000000000000000000000000000000000000000000e-1 * t1032) * t368
  t1136 = t438 * t442
  t1140 = 0.1e1 / t441 / t364
  t1141 = t359 * t1140
  t1142 = t450 ** 2
  t1148 = 0.40256666666666666666666666666666666666666666666667e0 * t1016
  t1153 = 0.13797500000000000000000000000000000000000000000000e0 * t1066
  t1157 = -0.12946250000000000000000000000000000000000000000000e1 * t1050 + 0.25892500000000000000000000000000000000000000000000e1 * t1055 + t1148 - 0.60385000000000000000000000000000000000000000000000e0 * t1019 + 0.90577500000000000000000000000000000000000000000000e0 * t1032 + 0.82524375000000000000000000000000000000000000000000e-1 * t1061 + 0.16504875000000000000000000000000000000000000000000e0 * t1063 + t1153 - 0.33114000000000000000000000000000000000000000000000e0 * t1069 + 0.24835500000000000000000000000000000000000000000000e0 * t1073 + 0.24835500000000000000000000000000000000000000000000e0 * t1077
  t1161 = t441 ** 2
  t1162 = 0.1e1 / t1161
  t1163 = t359 * t1162
  t1164 = t367 ** 2
  t1165 = 0.1e1 / t1164
  t1169 = -0.3109070e-1 * (t1091 - 0.34246666666666666666666666666666666666666666666666e-1 * t1019 + 0.51370000000000000000000000000000000000000000000000e-1 * t1032) * t355 + 0.20000000000000000000000000000000000000000000000000e1 * t1097 * t433 - 0.20000000000000000000000000000000000000000000000000e1 * t1102 * t1103 * t432 + 0.10000000000000000000000000000000000000000000000000e1 * t424 * t1118 * t432 + 0.32163958997385070133512593798145426124210776856102e2 * t1124 * t1103 * t1126 + t1036 - t1039 + t1046 - t1082 - t1090 - 0.19751673498613801407483339618206552048944131217655e-1 * t1134 + 0.11696447245269292414524477327518106963944910680856e1 * t1136 * t452 - 0.11696447245269292414524477327518106963944910680856e1 * t1141 * t1142 * t451 + 0.58482236226346462072622386637590534819724553404280e0 * t443 * t1157 * t451 + 0.17315859105681463759666483083807725165579399831905e2 * t1163 * t1142 * t1165
  t1173 = t68 * t438
  t1188 = -t1036 + t1039 - t1046 + t1082 + t1090 + t68 * t1169 + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t1134 - 0.11696447245269292414524477327518106963944910680856e1 * t1173 * t461 + 0.11696447245269292414524477327518106963944910680856e1 * t459 * t1140 * t1142 * t451 - 0.58482236226346462072622386637590534819724553404280e0 * t459 * t442 * t1157 * t451 - 0.17315859105681463759666483083807725165579399831905e2 * t459 * t1162 * t1142 * t1165
  t1192 = f.my_piecewise3(t319, 0, t1011 * t375 / 0.2e1 + t321 * t464 + t377 * t1188 / 0.2e1)
  t1195 = t27 ** 2
  t1196 = 0.1e1 / t1195
  t1202 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t1196 * t763 + 0.4e1 / 0.3e1 * t27 * t746)
  t1203 = t322 ** 2
  t1204 = 0.1e1 / t1203
  t1210 = f.my_piecewise3(t318, 0, 0.4e1 / 0.9e1 * t1204 * t1024 + 0.4e1 / 0.3e1 * t322 * t1010)
  t1212 = (t1202 + t1210) * t67
  t1218 = 0.10843581300301739842632067522386578331157260943710e-1 * t570 * t17 * t518 * t662
  t1219 = t638 ** 2
  t1220 = 0.1e1 / t1219
  t1221 = t645 ** 2
  t1223 = t595 ** 2
  t1224 = 0.1e1 / t1223
  t1227 = 0.17315859105681463759666483083807725165579399831905e2 * t660 * t1220 * t1221 * t1224
  t1229 = t617 * t587 * t662
  t1235 = t40 * t18 * t805
  t1236 = 0.1e1 / t521 / t520 * t39 * t1235
  t1238 = t544 * t752
  t1239 = t543 * t1238
  t1241 = t19 * t752
  t1242 = t17 * t1241
  t1244 = t520 ** (-0.5e0)
  t1246 = t1244 * t39 * t1235
  t1248 = t551 * t1238
  t1251 = t41 * t18 * t805
  t1253 = -0.57538888888888888888888888888888888888888888888889e0 * t1236 + 0.11507777777777777777777777777777777777777777777778e1 * t1239 + 0.40256666666666666666666666666666666666666666666667e0 * t1242 + 0.36677500000000000000000000000000000000000000000000e-1 * t1246 + 0.73355000000000000000000000000000000000000000000000e-1 * t1248 + 0.13797500000000000000000000000000000000000000000000e0 * t1251
  t1257 = 0.58482236226346462072622386637590534819724553404280e0 * t660 * t639 * t1253 * t646
  t1259 = 0.1e1 / t638 / t592
  t1263 = 0.11696447245269292414524477327518106963944910680856e1 * t660 * t1259 * t1221 * t646
  t1267 = 0.35616666666666666666666666666666666666666666666666e-1 * t20 * t103 * t540 * t559
  t1269 = t617 * t14 * t657
  t1274 = 0.24415263074675393406472461472505321282722606644045e-3 * t655 * t544 * t752 * t596
  t1276 = 0.8e1 * t606 * t651
  t1277 = 0.19751673498613801407483339618206552048944131217655e-1 * t1212 * t597 + t1218 - t1227 - 0.11696447245269292414524477327518106963944910680856e1 * t1229 - t1257 + t1263 - t1267 - 0.36622894612013090109708692208757981924083909966068e-3 * t1269 + t1274 - t1192 - t934 - t1276
  t1279 = 0.8e1 * t566 * t651
  t1280 = t606 * t618
  t1282 = t566 * t618
  t1286 = 0.14764627977777777777777777777777777777777777777777e-2 * t17 * t1241 * t533
  t1288 = t609 * t617 * t650
  t1294 = 0.20e2 * t603 / t564 / t9 * t600
  t1297 = 0.32e2 * t563 * t605 * t600
  t1300 = 0.12e2 * t562 * t565 * t600
  t1311 = t630 ** 2
  t1325 = t623 ** 2
  t1328 = t580 ** 2
  t1336 = t557 ** 2
  t1339 = 0.20000000000000000000000000000000000000000000000000e1 * t538 / t539 / t529 * t1336 * t558
  t1349 = 0.10000000000000000000000000000000000000000000000000e1 * t541 * (-0.42198333333333333333333333333333333333333333333333e0 * t1236 + 0.84396666666666666666666666666666666666666666666666e0 * t1239 + 0.39862222222222222222222222222222222222222222222223e0 * t1242 + 0.68258333333333333333333333333333333333333333333333e-1 * t1246 + 0.13651666666666666666666666666666666666666666666667e0 * t1248 + 0.13692777777777777777777777777777777777777777777778e0 * t1251) * t558
  t1350 = t539 ** 2
  t1353 = t532 ** 2
  t1357 = 0.16081979498692535066756296899072713062105388428051e2 * t538 / t1350 * t1336 / t1353
  t1376 = -0.70983522622222222222222222222222222222222222222221e-3 * t17 * t1241 * t581 - 0.34246666666666666666666666666666666666666666666666e-1 * t20 * t103 * t624 * t632 - 0.20000000000000000000000000000000000000000000000000e1 * t572 / t623 / t577 * t1311 * t631 + 0.10000000000000000000000000000000000000000000000000e1 * t625 * (-0.78438333333333333333333333333333333333333333333333e0 * t1236 + 0.15687666666666666666666666666666666666666666666667e1 * t1239 + 0.68863333333333333333333333333333333333333333333333e0 * t1242 + 0.14025833333333333333333333333333333333333333333333e0 * t1246 + 0.28051666666666666666666666666666666666666666666667e0 * t1248 + 0.17365833333333333333333333333333333333333333333333e0 * t1251) * t631 + 0.32163958997385070133512593798145426124210776856102e2 * t572 / t1325 * t1311 / t1328 + t1286 + t1267 + t1339 - t1349 - t1357 - 0.24415263074675393406472461472505321282722606644045e-3 * t17 * t1241 * t596 - 0.10843581300301739842632067522386578331157260943710e-1 * t20 * t103 * t639 * t647 - 0.11696447245269292414524477327518106963944910680856e1 * t587 * t1259 * t1221 * t646 + 0.58482236226346462072622386637590534819724553404280e0 * t640 * t1253 * t646 + 0.17315859105681463759666483083807725165579399831905e2 * t587 * t1220 * t1221 * t1224
  t1378 = t609 * t570 * t1376
  t1381 = t609 * t1212 * t599 + t1279 - 0.8e1 * t1280 + 0.8e1 * t1282 - t1286 + 0.2e1 * t1288 + t1294 - t1297 + t1300 - t1339 + t1349 + t1357 + t1378
  t1386 = t666 * t694
  t1387 = params.alpha_ab ** 2
  t1388 = t1387 * t944
  t1391 = params.alpha_ab * t954
  t1399 = t715 * t694
  t1402 = t679 * t735
  t1426 = t732 * t735
  t1431 = t692 / t734 / t670
  d11 = 0.2e1 * t259 + 0.2e1 * t308 + t314 / 0.4e1 + 0.2e1 * t516 + 0.2e1 * t697 + 0.2e1 * t740 + t3 * (t934 * t251 * t258 + 0.2e1 * t198 * t306 * t258 + t252 * t313 / 0.4e1 + t263 * (0.2e1 * t199 * t249 * t945 - t264 * t955 + (0.88e2 / 0.9e1 * t223 * t949 + 0.80e2 / 0.9e1 * t277 * t267) * t230 - 0.4e1 * t280 * t249 * t273 + 0.6e1 * t228 * t302 * t945 - 0.2e1 * t282 * t955 + (0.304e3 / 0.9e1 * t234 * t973 + 0.88e2 / 0.9e1 * t241 * t949 * t226 + 0.80e2 / 0.3e1 * t241 * t979 + 0.200e3 / 0.9e1 * t244 * t982 * t238 + 0.160e3 / 0.9e1 * t296 * t952) * t249 - 0.6e1 * t299 * t302 * t273 + 0.12e2 * t247 / t301 / t219 * t945 - 0.3e1 * t303 * t955) * t258 + t307 * t313 / 0.4e1 - t310 * s0 / t265 * t255 / 0.4e1 + t1192 * t508 * t515 + (t1277 + t1381) * t696 + 0.2e1 * t665 * t739 + t705 * (0.2e1 * t1386 * t1388 - t706 * t1391 + (0.88e2 / 0.9e1 * t709 * t949 + 0.80e2 / 0.9e1 * t712 * t267) * t681 - 0.4e1 * t1399 * t707 + 0.6e1 * t1402 * t1388 - 0.2e1 * t717 * t1391 + (0.128e3 / 0.9e1 * t683 * t233 * t973 + 0.176e3 / 0.9e1 * t720 * t950 + 0.88e2 / 0.9e1 * t723 * t949 * t677 + 0.160e3 / 0.9e1 * t723 * t979 + 0.80e2 / 0.9e1 * t687 * t952 + 0.200e3 / 0.9e1 * t689 * t982 * t238 + 0.160e3 / 0.9e1 * t729 * t952) * t694 - 0.6e1 * t1426 * t707 + 0.12e2 * t1431 * t1388 - 0.3e1 * t736 * t1391))
  t1441 = -t4 - t11
  t1442 = f.my_piecewise3(t7, 0, t1441)
  t1446 = f.my_piecewise3(t7, 0, -t109 * t1441 / 0.3e1)
  t1448 = t20 * t24 * t1446
  t1450 = -t107 + 0.53425000000000000000000000000000000000000000000000e-1 * t1448
  t1452 = 0.621814e-1 * t1450 * t55
  t1453 = -t123 + t1448
  t1454 = t122 * t1453
  t1457 = t129 * t1453
  t1459 = t29 * t1446
  t1461 = t42 * t46 * t1459
  t1463 = 0.18989250000000000000000000000000000000000000000000e1 * t1454 - t127 + 0.89690000000000000000000000000000000000000000000000e0 * t1448 + 0.30716250000000000000000000000000000000000000000000e0 * t1457 - t137 + 0.24647000000000000000000000000000000000000000000000e0 * t1461
  t1464 = t1463 * t143
  t1466 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * t1464
  t1468 = -t147 + 0.51370000000000000000000000000000000000000000000000e-1 * t1448
  t1475 = 0.35297250000000000000000000000000000000000000000000e1 * t1454 - t156 + 0.15494250000000000000000000000000000000000000000000e1 * t1448 + 0.63116250000000000000000000000000000000000000000000e0 * t1457 - t159 + 0.31258500000000000000000000000000000000000000000000e0 * t1461
  t1476 = t1475 * t162
  t1480 = -t166 + 0.27812500000000000000000000000000000000000000000000e-1 * t1448
  t1481 = t1480 * t92
  t1487 = 0.25892500000000000000000000000000000000000000000000e1 * t1454 - t175 + 0.90577500000000000000000000000000000000000000000000e0 * t1448 + 0.16504875000000000000000000000000000000000000000000e0 * t1457 - t178 + 0.24835500000000000000000000000000000000000000000000e0 * t1461
  t1488 = t1487 * t181
  t1496 = t172 * t1487 * t181
  t1499 = -t1452 + t1466 + t68 * (-0.3109070e-1 * t1468 * t79 + 0.10000000000000000000000000000000000000000000000000e1 * t154 * t1476 + t1452 - t1466 - 0.19751673498613801407483339618206552048944131217655e-1 * t1481 + 0.58482236226346462072622386637590534819724553404280e0 * t173 * t1488) + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t1481 - 0.58482236226346462072622386637590534819724553404280e0 * t189 * t1496
  t1503 = f.my_piecewise3(t8, 0, t101 * t1499 / 0.2e1 + t1442 * t99 / 0.2e1)
  t1504 = t1503 * t251
  t1505 = t1504 * t258
  t1506 = -t1441
  t1507 = f.my_piecewise3(t318, 0, t1506)
  t1511 = f.my_piecewise3(t318, 0, -t382 * t1506 / 0.3e1)
  t1513 = t20 * t24 * t1511
  t1515 = -t380 + 0.53425000000000000000000000000000000000000000000000e-1 * t1513
  t1517 = 0.621814e-1 * t1515 * t342
  t1518 = -t396 + t1513
  t1519 = t395 * t1518
  t1522 = t402 * t1518
  t1524 = t324 * t1511
  t1526 = t42 * t46 * t1524
  t1528 = 0.18989250000000000000000000000000000000000000000000e1 * t1519 - t400 + 0.89690000000000000000000000000000000000000000000000e0 * t1513 + 0.30716250000000000000000000000000000000000000000000e0 * t1522 - t407 + 0.24647000000000000000000000000000000000000000000000e0 * t1526
  t1529 = t1528 * t413
  t1531 = 0.10000000000000000000000000000000000000000000000000e1 * t394 * t1529
  t1533 = -t417 + 0.51370000000000000000000000000000000000000000000000e-1 * t1513
  t1540 = 0.35297250000000000000000000000000000000000000000000e1 * t1519 - t426 + 0.15494250000000000000000000000000000000000000000000e1 * t1513 + 0.63116250000000000000000000000000000000000000000000e0 * t1522 - t429 + 0.31258500000000000000000000000000000000000000000000e0 * t1526
  t1541 = t1540 * t432
  t1545 = -t436 + 0.27812500000000000000000000000000000000000000000000e-1 * t1513
  t1546 = t1545 * t368
  t1552 = 0.25892500000000000000000000000000000000000000000000e1 * t1519 - t445 + 0.90577500000000000000000000000000000000000000000000e0 * t1513 + 0.16504875000000000000000000000000000000000000000000e0 * t1522 - t448 + 0.24835500000000000000000000000000000000000000000000e0 * t1526
  t1553 = t1552 * t451
  t1561 = t442 * t1552 * t451
  t1564 = -t1517 + t1531 + t68 * (-0.3109070e-1 * t1533 * t355 + 0.10000000000000000000000000000000000000000000000000e1 * t424 * t1541 + t1517 - t1531 - 0.19751673498613801407483339618206552048944131217655e-1 * t1546 + 0.58482236226346462072622386637590534819724553404280e0 * t443 * t1553) + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t1546 - 0.58482236226346462072622386637590534819724553404280e0 * t459 * t1561
  t1568 = f.my_piecewise3(t319, 0, t1507 * t375 / 0.2e1 + t377 * t1564 / 0.2e1)
  t1569 = t1568 * t508
  t1570 = t1569 * t515
  t1571 = t199 * t490
  t1572 = t469 * r1
  t1574 = 0.1e1 / t471 / t1572
  t1575 = s2 * t1574
  t1577 = tau1 * t473
  t1579 = -0.8e1 / 0.3e1 * t1575 - 0.10e2 / 0.3e1 * t1577
  t1580 = params.alpha_ss * t1579
  t1584 = t225 * tau1
  t1587 = -0.8e1 / 0.3e1 * t484 * t1574 - 0.10e2 / 0.3e1 * t1584 * t473
  t1589 = t488 * t506
  t1594 = 0.1e1 / t470 / t494 / t469
  t1603 = t244 * t486
  t1606 = -0.16e2 / 0.3e1 * t493 * t1594 - 0.8e1 / 0.3e1 * t499 * t1574 * t486 - 0.10e2 / 0.3e1 * t499 * t497 * tau1 - 0.20e2 / 0.3e1 * t1603 * t1577
  t1608 = t489 ** 2
  t1609 = 0.1e1 / t1608
  t1610 = t504 * t1609
  t1613 = -t1571 * t1580 - 0.2e1 * t1589 * t1580 - 0.3e1 * t1610 * t1580 + t1587 * t490 + t1606 * t506
  t1614 = t704 * t1613
  t1615 = t1614 * t515
  t1616 = t704 * t508
  t1619 = s2 / t469 * t512
  t1620 = t1616 * t1619
  t1624 = f.my_piecewise3(t7, 0, 0.4e1 / 0.3e1 * t27 * t1441)
  t1627 = f.my_piecewise3(t318, 0, 0.4e1 / 0.3e1 * t322 * t1506)
  t1629 = (t1624 + t1627) * t67
  t1630 = t1629 * t599
  t1634 = t536 + t561 - t602 - t608 + t609 * t1630 + t652 + 0.19751673498613801407483339618206552048944131217655e-1 * t1629 * t597 - t659 - t664 - t1503 - t1568
  t1635 = t1634 * t696
  t1636 = params.alpha_ab * t1579
  t1638 = t673 * s2
  t1641 = t676 * tau1
  t1644 = -0.8e1 / 0.3e1 * t1638 * t1574 - 0.10e2 / 0.3e1 * t1641 * t473
  t1650 = t686 * s2
  t1658 = -0.16e2 / 0.3e1 * t720 * t1575 - 0.8e1 / 0.3e1 * t1650 * t1574 * t677 - 0.10e2 / 0.3e1 * t687 * t1577 - 0.20e2 / 0.3e1 * t729 * t1577
  t1662 = -t706 * t1636 - 0.2e1 * t717 * t1636 - 0.3e1 * t736 * t1636 + t1644 * t681 + t1658 * t694
  t1663 = t705 * t1662
  t1664 = 0.2e1 * t744
  t1665 = f.my_piecewise3(t7, 0, t1664)
  t1671 = t20 * t104 * t1446
  t1680 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t762 * t1441 * t12 - 0.2e1 / 0.3e1 * t109 * t2 * t743)
  t1682 = t20 * t24 * t1680
  t1686 = 0.621814e-1 * (t756 - 0.17808333333333333333333333333333333333333333333333e-1 * t758 - 0.17808333333333333333333333333333333333333333333333e-1 * t1671 + 0.53425000000000000000000000000000000000000000000000e-1 * t1682) * t55
  t1687 = t1450 * t120
  t1689 = 0.10000000000000000000000000000000000000000000000000e1 * t1687 * t144
  t1691 = 0.10000000000000000000000000000000000000000000000000e1 * t776 * t1464
  t1694 = 0.20000000000000000000000000000000000000000000000000e1 * t781 * t1464 * t142
  t1696 = t787 * t1453 * t124
  t1700 = t791 - t758 / 0.3e1 - t1671 / 0.3e1 + t1682
  t1701 = t122 * t1700
  t1707 = t799 * t1453 * t124
  t1709 = t129 * t1700
  t1713 = t42 * t134 * t1459
  t1717 = t42 * t46 * t112 * t1446
  t1721 = t42 * t46 * t29 * t1680
  t1723 = -0.94946250000000000000000000000000000000000000000000e0 * t1696 + 0.18989250000000000000000000000000000000000000000000e1 * t1701 + t796 - 0.29896666666666666666666666666666666666666666666667e0 * t758 - 0.29896666666666666666666666666666666666666666666667e0 * t1671 + 0.89690000000000000000000000000000000000000000000000e0 * t1682 + 0.15358125000000000000000000000000000000000000000000e0 * t1707 + 0.30716250000000000000000000000000000000000000000000e0 * t1709 + t809 - 0.16431333333333333333333333333333333333333333333333e0 * t811 - 0.16431333333333333333333333333333333333333333333333e0 * t1713 + 0.24647000000000000000000000000000000000000000000000e0 * t1717 + 0.24647000000000000000000000000000000000000000000000e0 * t1721
  t1726 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * t1723 * t143
  t1730 = 0.16081979498692535066756296899072713062105388428051e2 * t827 * t1463 * t829 * t142
  t1737 = t1468 * t153
  t1756 = -0.17648625000000000000000000000000000000000000000000e1 * t1696 + 0.35297250000000000000000000000000000000000000000000e1 * t1701 + t851 - 0.51647500000000000000000000000000000000000000000000e0 * t758 - 0.51647500000000000000000000000000000000000000000000e0 * t1671 + 0.15494250000000000000000000000000000000000000000000e1 * t1682 + 0.31558125000000000000000000000000000000000000000000e0 * t1707 + 0.63116250000000000000000000000000000000000000000000e0 * t1709 + t856 - 0.20839000000000000000000000000000000000000000000000e0 * t811 - 0.20839000000000000000000000000000000000000000000000e0 * t1713 + 0.31258500000000000000000000000000000000000000000000e0 * t1717 + 0.31258500000000000000000000000000000000000000000000e0 * t1721
  t1768 = (t872 - 0.92708333333333333333333333333333333333333333333333e-2 * t758 - 0.92708333333333333333333333333333333333333333333333e-2 * t1671 + 0.27812500000000000000000000000000000000000000000000e-1 * t1682) * t92
  t1770 = t1480 * t172
  t1789 = -0.12946250000000000000000000000000000000000000000000e1 * t1696 + 0.25892500000000000000000000000000000000000000000000e1 * t1701 + t890 - 0.30192500000000000000000000000000000000000000000000e0 * t758 - 0.30192500000000000000000000000000000000000000000000e0 * t1671 + 0.90577500000000000000000000000000000000000000000000e0 * t1682 + 0.82524375000000000000000000000000000000000000000000e-1 * t1707 + 0.16504875000000000000000000000000000000000000000000e0 * t1709 + t895 - 0.16557000000000000000000000000000000000000000000000e0 * t811 - 0.16557000000000000000000000000000000000000000000000e0 * t1713 + 0.24835500000000000000000000000000000000000000000000e0 * t1717 + 0.24835500000000000000000000000000000000000000000000e0 * t1721
  t1797 = -0.3109070e-1 * (t833 - 0.17123333333333333333333333333333333333333333333333e-1 * t758 - 0.17123333333333333333333333333333333333333333333333e-1 * t1671 + 0.51370000000000000000000000000000000000000000000000e-1 * t1682) * t79 + 0.10000000000000000000000000000000000000000000000000e1 * t1737 * t163 + 0.10000000000000000000000000000000000000000000000000e1 * t839 * t1476 - 0.20000000000000000000000000000000000000000000000000e1 * t844 * t1476 * t161 + 0.10000000000000000000000000000000000000000000000000e1 * t154 * t1756 * t162 + 0.32163958997385070133512593798145426124210776856102e2 * t866 * t1475 * t868 * t161 + t1686 - t1689 - t1691 + t1694 - t1726 - t1730 - 0.19751673498613801407483339618206552048944131217655e-1 * t1768 + 0.58482236226346462072622386637590534819724553404280e0 * t1770 * t182 + 0.58482236226346462072622386637590534819724553404280e0 * t878 * t1488 - 0.11696447245269292414524477327518106963944910680856e1 * t883 * t1488 * t180 + 0.58482236226346462072622386637590534819724553404280e0 * t173 * t1789 * t181 + 0.17315859105681463759666483083807725165579399831905e2 * t905 * t1487 * t907 * t180
  t1801 = t68 * t1480
  t1819 = -t1686 + t1689 + t1691 - t1694 + t1726 + t1730 + t68 * t1797 + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t1768 - 0.58482236226346462072622386637590534819724553404280e0 * t1801 * t191 - 0.58482236226346462072622386637590534819724553404280e0 * t915 * t1496 + 0.11696447245269292414524477327518106963944910680856e1 * t189 * t882 * t1487 * t182 - 0.58482236226346462072622386637590534819724553404280e0 * t189 * t172 * t1789 * t181 - 0.17315859105681463759666483083807725165579399831905e2 * t189 * t904 * t1487 * t907 * t180
  t1823 = f.my_piecewise3(t8, 0, t101 * t1819 / 0.2e1 + t13 * t1499 / 0.2e1 + t1442 * t194 / 0.2e1 + t1665 * t99 / 0.2e1)
  t1830 = f.my_piecewise3(t318, 0, -t1664)
  t1836 = t20 * t104 * t1511
  t1845 = f.my_piecewise3(t318, 0, 0.4e1 / 0.9e1 * t1023 * t1506 * t320 + 0.2e1 / 0.3e1 * t382 * t2 * t743)
  t1847 = t20 * t24 * t1845
  t1851 = 0.621814e-1 * (t1017 - 0.17808333333333333333333333333333333333333333333333e-1 * t1019 - 0.17808333333333333333333333333333333333333333333333e-1 * t1836 + 0.53425000000000000000000000000000000000000000000000e-1 * t1847) * t342
  t1852 = t1515 * t393
  t1854 = 0.10000000000000000000000000000000000000000000000000e1 * t1852 * t414
  t1856 = 0.10000000000000000000000000000000000000000000000000e1 * t1037 * t1529
  t1859 = 0.20000000000000000000000000000000000000000000000000e1 * t1042 * t1529 * t412
  t1861 = t1048 * t1518 * t397
  t1865 = t1052 - t1019 / 0.3e1 - t1836 / 0.3e1 + t1847
  t1866 = t395 * t1865
  t1872 = t1060 * t1518 * t397
  t1874 = t402 * t1865
  t1878 = t42 * t134 * t1524
  t1882 = t42 * t46 * t385 * t1511
  t1886 = t42 * t46 * t324 * t1845
  t1888 = -0.94946250000000000000000000000000000000000000000000e0 * t1861 + 0.18989250000000000000000000000000000000000000000000e1 * t1866 + t1057 - 0.29896666666666666666666666666666666666666666666667e0 * t1019 - 0.29896666666666666666666666666666666666666666666667e0 * t1836 + 0.89690000000000000000000000000000000000000000000000e0 * t1847 + 0.15358125000000000000000000000000000000000000000000e0 * t1872 + 0.30716250000000000000000000000000000000000000000000e0 * t1874 + t1067 - 0.16431333333333333333333333333333333333333333333333e0 * t1069 - 0.16431333333333333333333333333333333333333333333333e0 * t1878 + 0.24647000000000000000000000000000000000000000000000e0 * t1882 + 0.24647000000000000000000000000000000000000000000000e0 * t1886
  t1891 = 0.10000000000000000000000000000000000000000000000000e1 * t394 * t1888 * t413
  t1895 = 0.16081979498692535066756296899072713062105388428051e2 * t1085 * t1528 * t1087 * t412
  t1902 = t1533 * t423
  t1921 = -0.17648625000000000000000000000000000000000000000000e1 * t1861 + 0.35297250000000000000000000000000000000000000000000e1 * t1866 + t1109 - 0.51647500000000000000000000000000000000000000000000e0 * t1019 - 0.51647500000000000000000000000000000000000000000000e0 * t1836 + 0.15494250000000000000000000000000000000000000000000e1 * t1847 + 0.31558125000000000000000000000000000000000000000000e0 * t1872 + 0.63116250000000000000000000000000000000000000000000e0 * t1874 + t1114 - 0.20839000000000000000000000000000000000000000000000e0 * t1069 - 0.20839000000000000000000000000000000000000000000000e0 * t1878 + 0.31258500000000000000000000000000000000000000000000e0 * t1882 + 0.31258500000000000000000000000000000000000000000000e0 * t1886
  t1933 = (t1130 - 0.92708333333333333333333333333333333333333333333333e-2 * t1019 - 0.92708333333333333333333333333333333333333333333333e-2 * t1836 + 0.27812500000000000000000000000000000000000000000000e-1 * t1847) * t368
  t1935 = t1545 * t442
  t1954 = -0.12946250000000000000000000000000000000000000000000e1 * t1861 + 0.25892500000000000000000000000000000000000000000000e1 * t1866 + t1148 - 0.30192500000000000000000000000000000000000000000000e0 * t1019 - 0.30192500000000000000000000000000000000000000000000e0 * t1836 + 0.90577500000000000000000000000000000000000000000000e0 * t1847 + 0.82524375000000000000000000000000000000000000000000e-1 * t1872 + 0.16504875000000000000000000000000000000000000000000e0 * t1874 + t1153 - 0.16557000000000000000000000000000000000000000000000e0 * t1069 - 0.16557000000000000000000000000000000000000000000000e0 * t1878 + 0.24835500000000000000000000000000000000000000000000e0 * t1882 + 0.24835500000000000000000000000000000000000000000000e0 * t1886
  t1962 = -0.3109070e-1 * (t1091 - 0.17123333333333333333333333333333333333333333333333e-1 * t1019 - 0.17123333333333333333333333333333333333333333333333e-1 * t1836 + 0.51370000000000000000000000000000000000000000000000e-1 * t1847) * t355 + 0.10000000000000000000000000000000000000000000000000e1 * t1902 * t433 + 0.10000000000000000000000000000000000000000000000000e1 * t1097 * t1541 - 0.20000000000000000000000000000000000000000000000000e1 * t1102 * t1541 * t431 + 0.10000000000000000000000000000000000000000000000000e1 * t424 * t1921 * t432 + 0.32163958997385070133512593798145426124210776856102e2 * t1124 * t1540 * t1126 * t431 + t1851 - t1854 - t1856 + t1859 - t1891 - t1895 - 0.19751673498613801407483339618206552048944131217655e-1 * t1933 + 0.58482236226346462072622386637590534819724553404280e0 * t1935 * t452 + 0.58482236226346462072622386637590534819724553404280e0 * t1136 * t1553 - 0.11696447245269292414524477327518106963944910680856e1 * t1141 * t1553 * t450 + 0.58482236226346462072622386637590534819724553404280e0 * t443 * t1954 * t451 + 0.17315859105681463759666483083807725165579399831905e2 * t1163 * t1552 * t1165 * t450
  t1966 = t68 * t1545
  t1984 = -t1851 + t1854 + t1856 - t1859 + t1891 + t1895 + t68 * t1962 + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t1933 - 0.58482236226346462072622386637590534819724553404280e0 * t1966 * t461 - 0.58482236226346462072622386637590534819724553404280e0 * t1173 * t1561 + 0.11696447245269292414524477327518106963944910680856e1 * t459 * t1140 * t1552 * t452 - 0.58482236226346462072622386637590534819724553404280e0 * t459 * t442 * t1954 * t451 - 0.17315859105681463759666483083807725165579399831905e2 * t459 * t1162 * t1552 * t1165 * t450
  t1988 = f.my_piecewise3(t319, 0, t1507 * t464 / 0.2e1 + t321 * t1564 / 0.2e1 + t1830 * t375 / 0.2e1 + t377 * t1984 / 0.2e1)
  t1998 = t1629 * t587 * t662
  t2000 = t566 * t1630
  t2002 = t606 * t1630
  t2011 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t1196 * t1441 * t12 + 0.8e1 / 0.3e1 * t27 * t2 * t743)
  t2019 = f.my_piecewise3(t318, 0, 0.4e1 / 0.9e1 * t1204 * t1506 * t320 - 0.8e1 / 0.3e1 * t322 * t2 * t743)
  t2021 = (t2011 + t2019) * t67
  t2024 = -t1823 - t1988 + t1218 - t1227 - 0.58482236226346462072622386637590534819724553404280e0 * t1229 - t1257 + t1263 - t1267 - 0.18311447306006545054854346104378990962041954983034e-3 * t1269 + t1274 - 0.58482236226346462072622386637590534819724553404280e0 * t1998 + 0.4e1 * t2000 - 0.4e1 * t2002 + t609 * t2021 * t599
  t2026 = t609 * t1629 * t650
  t2028 = t1629 * t14 * t657
  t2034 = t2026 - 0.18311447306006545054854346104378990962041954983034e-3 * t2028 - t1276 - 0.4e1 * t1280 - 0.4e1 * t1282 - t1286 + t1288 + t1294 - t1300 + t1378 + t1349 + t1357 - t1339 + 0.19751673498613801407483339618206552048944131217655e-1 * t2021 * t597
  t2040 = t1387 * t1579 * t272
  t2043 = t1644 * t694
  t2070 = t1658 * t735
  d12 = t259 + t308 + t314 / 0.8e1 + t516 + t697 + t740 + t1505 + t1570 + t1615 + t1620 / 0.8e1 + t1635 + t1663 + t3 * (t1823 * t251 * t258 + t1503 * t306 * t258 + t1504 * t313 / 0.8e1 + t1988 * t508 * t515 + t468 * t1613 * t515 + t509 * t1619 / 0.8e1 + (t2024 + t2034) * t696 + t1634 * t739 + t665 * t1662 + t705 * (0.2e1 * t1386 * t2040 - 0.2e1 * t2043 * t707 - 0.2e1 * t1399 * t1636 + 0.6e1 * t1402 * t2040 + (0.128e3 / 0.9e1 * t683 * s0 * t267 * s2 * t1574 + 0.80e2 / 0.9e1 * t1650 * t1574 * tau0 * t204 + 0.80e2 / 0.9e1 * t723 * t267 * tau1 * t473 + 0.200e3 / 0.9e1 * t689 * tau0 * t204 * tau1 * t473) * t694 - 0.3e1 * t2070 * t707 - 0.3e1 * t1426 * t1636 + 0.12e2 * t1431 * t2040))
  t2088 = 0.2e1 * t10 + 0.2e1 * t744
  t2089 = f.my_piecewise3(t7, 0, t2088)
  t2094 = t1441 ** 2
  t2100 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t762 * t2094 - t109 * t2088 / 0.3e1)
  t2102 = t20 * t24 * t2100
  t2106 = 0.621814e-1 * (t756 - 0.35616666666666666666666666666666666666666666666666e-1 * t1671 + 0.53425000000000000000000000000000000000000000000000e-1 * t2102) * t55
  t2108 = 0.20000000000000000000000000000000000000000000000000e1 * t1687 * t1464
  t2109 = t1463 ** 2
  t2112 = 0.20000000000000000000000000000000000000000000000000e1 * t781 * t2109 * t143
  t2113 = t1453 ** 2
  t2114 = t787 * t2113
  t2117 = t791 - 0.2e1 / 0.3e1 * t1671 + t2102
  t2118 = t122 * t2117
  t2122 = t799 * t2113
  t2124 = t129 * t2117
  t2127 = t1446 ** 2
  t2129 = t42 * t46 * t2127
  t2133 = t42 * t46 * t29 * t2100
  t2135 = -0.94946250000000000000000000000000000000000000000000e0 * t2114 + 0.18989250000000000000000000000000000000000000000000e1 * t2118 + t796 - 0.59793333333333333333333333333333333333333333333334e0 * t1671 + 0.89690000000000000000000000000000000000000000000000e0 * t2102 + 0.15358125000000000000000000000000000000000000000000e0 * t2122 + 0.30716250000000000000000000000000000000000000000000e0 * t2124 + t809 - 0.32862666666666666666666666666666666666666666666666e0 * t1713 + 0.24647000000000000000000000000000000000000000000000e0 * t2129 + 0.24647000000000000000000000000000000000000000000000e0 * t2133
  t2138 = 0.10000000000000000000000000000000000000000000000000e1 * t121 * t2135 * t143
  t2141 = 0.16081979498692535066756296899072713062105388428051e2 * t827 * t2109 * t829
  t2149 = t1475 ** 2
  t2162 = -0.17648625000000000000000000000000000000000000000000e1 * t2114 + 0.35297250000000000000000000000000000000000000000000e1 * t2118 + t851 - 0.10329500000000000000000000000000000000000000000000e1 * t1671 + 0.15494250000000000000000000000000000000000000000000e1 * t2102 + 0.31558125000000000000000000000000000000000000000000e0 * t2122 + 0.63116250000000000000000000000000000000000000000000e0 * t2124 + t856 - 0.41678000000000000000000000000000000000000000000000e0 * t1713 + 0.31258500000000000000000000000000000000000000000000e0 * t2129 + 0.31258500000000000000000000000000000000000000000000e0 * t2133
  t2172 = (t872 - 0.18541666666666666666666666666666666666666666666667e-1 * t1671 + 0.27812500000000000000000000000000000000000000000000e-1 * t2102) * t92
  t2176 = t1487 ** 2
  t2189 = -0.12946250000000000000000000000000000000000000000000e1 * t2114 + 0.25892500000000000000000000000000000000000000000000e1 * t2118 + t890 - 0.60385000000000000000000000000000000000000000000000e0 * t1671 + 0.90577500000000000000000000000000000000000000000000e0 * t2102 + 0.82524375000000000000000000000000000000000000000000e-1 * t2122 + 0.16504875000000000000000000000000000000000000000000e0 * t2124 + t895 - 0.33114000000000000000000000000000000000000000000000e0 * t1713 + 0.24835500000000000000000000000000000000000000000000e0 * t2129 + 0.24835500000000000000000000000000000000000000000000e0 * t2133
  t2196 = -0.3109070e-1 * (t833 - 0.34246666666666666666666666666666666666666666666666e-1 * t1671 + 0.51370000000000000000000000000000000000000000000000e-1 * t2102) * t79 + 0.20000000000000000000000000000000000000000000000000e1 * t1737 * t1476 - 0.20000000000000000000000000000000000000000000000000e1 * t844 * t2149 * t162 + 0.10000000000000000000000000000000000000000000000000e1 * t154 * t2162 * t162 + 0.32163958997385070133512593798145426124210776856102e2 * t866 * t2149 * t868 + t2106 - t2108 + t2112 - t2138 - t2141 - 0.19751673498613801407483339618206552048944131217655e-1 * t2172 + 0.11696447245269292414524477327518106963944910680856e1 * t1770 * t1488 - 0.11696447245269292414524477327518106963944910680856e1 * t883 * t2176 * t181 + 0.58482236226346462072622386637590534819724553404280e0 * t173 * t2189 * t181 + 0.17315859105681463759666483083807725165579399831905e2 * t905 * t2176 * t907
  t2214 = -t2106 + t2108 - t2112 + t2138 + t2141 + t68 * t2196 + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t2172 - 0.11696447245269292414524477327518106963944910680856e1 * t1801 * t1496 + 0.11696447245269292414524477327518106963944910680856e1 * t189 * t882 * t2176 * t181 - 0.58482236226346462072622386637590534819724553404280e0 * t189 * t172 * t2189 * t181 - 0.17315859105681463759666483083807725165579399831905e2 * t189 * t904 * t2176 * t907
  t2218 = f.my_piecewise3(t8, 0, t2089 * t99 / 0.2e1 + t1442 * t1499 + t101 * t2214 / 0.2e1)
  t2221 = -t2088
  t2222 = f.my_piecewise3(t318, 0, t2221)
  t2227 = t1506 ** 2
  t2233 = f.my_piecewise3(t318, 0, 0.4e1 / 0.9e1 * t1023 * t2227 - t382 * t2221 / 0.3e1)
  t2235 = t20 * t24 * t2233
  t2239 = 0.621814e-1 * (t1017 - 0.35616666666666666666666666666666666666666666666666e-1 * t1836 + 0.53425000000000000000000000000000000000000000000000e-1 * t2235) * t342
  t2241 = 0.20000000000000000000000000000000000000000000000000e1 * t1852 * t1529
  t2242 = t1528 ** 2
  t2245 = 0.20000000000000000000000000000000000000000000000000e1 * t1042 * t2242 * t413
  t2246 = t1518 ** 2
  t2247 = t1048 * t2246
  t2250 = t1052 - 0.2e1 / 0.3e1 * t1836 + t2235
  t2251 = t395 * t2250
  t2255 = t1060 * t2246
  t2257 = t402 * t2250
  t2260 = t1511 ** 2
  t2262 = t42 * t46 * t2260
  t2266 = t42 * t46 * t324 * t2233
  t2268 = -0.94946250000000000000000000000000000000000000000000e0 * t2247 + 0.18989250000000000000000000000000000000000000000000e1 * t2251 + t1057 - 0.59793333333333333333333333333333333333333333333334e0 * t1836 + 0.89690000000000000000000000000000000000000000000000e0 * t2235 + 0.15358125000000000000000000000000000000000000000000e0 * t2255 + 0.30716250000000000000000000000000000000000000000000e0 * t2257 + t1067 - 0.32862666666666666666666666666666666666666666666666e0 * t1878 + 0.24647000000000000000000000000000000000000000000000e0 * t2262 + 0.24647000000000000000000000000000000000000000000000e0 * t2266
  t2271 = 0.10000000000000000000000000000000000000000000000000e1 * t394 * t2268 * t413
  t2274 = 0.16081979498692535066756296899072713062105388428051e2 * t1085 * t2242 * t1087
  t2282 = t1540 ** 2
  t2295 = -0.17648625000000000000000000000000000000000000000000e1 * t2247 + 0.35297250000000000000000000000000000000000000000000e1 * t2251 + t1109 - 0.10329500000000000000000000000000000000000000000000e1 * t1836 + 0.15494250000000000000000000000000000000000000000000e1 * t2235 + 0.31558125000000000000000000000000000000000000000000e0 * t2255 + 0.63116250000000000000000000000000000000000000000000e0 * t2257 + t1114 - 0.41678000000000000000000000000000000000000000000000e0 * t1878 + 0.31258500000000000000000000000000000000000000000000e0 * t2262 + 0.31258500000000000000000000000000000000000000000000e0 * t2266
  t2305 = (t1130 - 0.18541666666666666666666666666666666666666666666667e-1 * t1836 + 0.27812500000000000000000000000000000000000000000000e-1 * t2235) * t368
  t2309 = t1552 ** 2
  t2322 = -0.12946250000000000000000000000000000000000000000000e1 * t2247 + 0.25892500000000000000000000000000000000000000000000e1 * t2251 + t1148 - 0.60385000000000000000000000000000000000000000000000e0 * t1836 + 0.90577500000000000000000000000000000000000000000000e0 * t2235 + 0.82524375000000000000000000000000000000000000000000e-1 * t2255 + 0.16504875000000000000000000000000000000000000000000e0 * t2257 + t1153 - 0.33114000000000000000000000000000000000000000000000e0 * t1878 + 0.24835500000000000000000000000000000000000000000000e0 * t2262 + 0.24835500000000000000000000000000000000000000000000e0 * t2266
  t2329 = -0.3109070e-1 * (t1091 - 0.34246666666666666666666666666666666666666666666666e-1 * t1836 + 0.51370000000000000000000000000000000000000000000000e-1 * t2235) * t355 + 0.20000000000000000000000000000000000000000000000000e1 * t1902 * t1541 - 0.20000000000000000000000000000000000000000000000000e1 * t1102 * t2282 * t432 + 0.10000000000000000000000000000000000000000000000000e1 * t424 * t2295 * t432 + 0.32163958997385070133512593798145426124210776856102e2 * t1124 * t2282 * t1126 + t2239 - t2241 + t2245 - t2271 - t2274 - 0.19751673498613801407483339618206552048944131217655e-1 * t2305 + 0.11696447245269292414524477327518106963944910680856e1 * t1935 * t1553 - 0.11696447245269292414524477327518106963944910680856e1 * t1141 * t2309 * t451 + 0.58482236226346462072622386637590534819724553404280e0 * t443 * t2322 * t451 + 0.17315859105681463759666483083807725165579399831905e2 * t1163 * t2309 * t1165
  t2347 = -t2239 + t2241 - t2245 + t2271 + t2274 + t68 * t2329 + 0.19751673498613801407483339618206552048944131217655e-1 * t68 * t2305 - 0.11696447245269292414524477327518106963944910680856e1 * t1966 * t1561 + 0.11696447245269292414524477327518106963944910680856e1 * t459 * t1140 * t2309 * t451 - 0.58482236226346462072622386637590534819724553404280e0 * t459 * t442 * t2322 * t451 - 0.17315859105681463759666483083807725165579399831905e2 * t459 * t1162 * t2309 * t1165
  t2351 = f.my_piecewise3(t319, 0, t2222 * t375 / 0.2e1 + t1507 * t1564 + t377 * t2347 / 0.2e1)
  t2360 = t1579 ** 2
  t2361 = t943 * t2360
  t2365 = 0.1e1 / t471 / t494
  t2366 = s2 * t2365
  t2368 = tau1 * t1574
  t2370 = 0.88e2 / 0.9e1 * t2366 + 0.80e2 / 0.9e1 * t2368
  t2371 = params.alpha_ss * t2370
  t2389 = 0.1e1 / t470 / t494 / t1572
  t2395 = t1594 * tau1
  t2398 = tau1 ** 2
  t2435 = f.my_piecewise3(t7, 0, 0.4e1 / 0.9e1 * t1196 * t2094 + 0.4e1 / 0.3e1 * t27 * t2088)
  t2441 = f.my_piecewise3(t318, 0, 0.4e1 / 0.9e1 * t1204 * t2227 + 0.4e1 / 0.3e1 * t322 * t2221)
  t2443 = (t2435 + t2441) * t67
  t2446 = -t2218 + t1218 - t1227 - t1257 + t1263 - t1267 + t1274 - 0.11696447245269292414524477327518106963944910680856e1 * t1998 - 0.8e1 * t2000 - 0.8e1 * t2002 + 0.2e1 * t2026 + 0.19751673498613801407483339618206552048944131217655e-1 * t2443 * t597
  t2450 = -0.36622894612013090109708692208757981924083909966068e-3 * t2028 - t1276 - t1279 + t609 * t2443 * t599 - t1286 + t1294 + t1297 + t1300 + t1378 + t1349 + t1357 - t1339 - t2351
  t2455 = t1387 * t2360
  t2458 = params.alpha_ab * t2370
  d22 = 0.2e1 * t1505 + 0.2e1 * t1570 + 0.2e1 * t1615 + t1620 / 0.4e1 + 0.2e1 * t1635 + 0.2e1 * t1663 + t3 * (t2218 * t251 * t258 + t2351 * t508 * t515 + 0.2e1 * t1568 * t1613 * t515 + t1569 * t1619 / 0.4e1 + t704 * (0.2e1 * t199 * t506 * t2361 - t1571 * t2371 + (0.88e2 / 0.9e1 * t484 * t2365 + 0.80e2 / 0.9e1 * t1584 * t1574) * t490 - 0.4e1 * t1587 * t506 * t1580 + 0.6e1 * t488 * t1609 * t2361 - 0.2e1 * t1589 * t2371 + (0.304e3 / 0.9e1 * t493 * t2389 + 0.88e2 / 0.9e1 * t499 * t2365 * t486 + 0.80e2 / 0.3e1 * t499 * t2395 + 0.200e3 / 0.9e1 * t244 * t2398 * t497 + 0.160e3 / 0.9e1 * t1603 * t2368) * t506 - 0.6e1 * t1606 * t1609 * t1580 + 0.12e2 * t504 / t1608 / t481 * t2361 - 0.3e1 * t1610 * t2371) * t515 + t1614 * t1619 / 0.4e1 - t1616 * s2 / t1572 * t512 / 0.4e1 + (t2446 + t2450) * t696 + 0.2e1 * t1634 * t1662 + t705 * (0.2e1 * t1386 * t2455 - t706 * t2458 + (0.88e2 / 0.9e1 * t1638 * t2365 + 0.80e2 / 0.9e1 * t1641 * t1574) * t681 - 0.4e1 * t2043 * t1636 + 0.6e1 * t1402 * t2455 - 0.2e1 * t717 * t2458 + (0.128e3 / 0.9e1 * t683 * t492 * t2389 + 0.176e3 / 0.9e1 * t720 * t2366 + 0.88e2 / 0.9e1 * t1650 * t2365 * t677 + 0.160e3 / 0.9e1 * t1650 * t2395 + 0.80e2 / 0.9e1 * t687 * t2368 + 0.200e3 / 0.9e1 * t689 * t2398 * t497 + 0.160e3 / 0.9e1 * t729 * t2368) * t694 - 0.6e1 * t2070 * t1636 + 0.12e2 * t1431 * t2455 - 0.3e1 * t736 * t2458))
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

