"""Generated from mgga_x_br89_explicit.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_gamma_raw = params.gamma
  if isinstance(params_gamma_raw, (str, bytes, dict)):
    params_gamma = params_gamma_raw
  else:
    try:
      params_gamma_seq = list(params_gamma_raw)
    except TypeError:
      params_gamma = params_gamma_raw
    else:
      params_gamma_seq = np.asarray(params_gamma_seq, dtype=np.float64)
      params_gamma = np.concatenate((np.array([np.nan], dtype=np.float64), params_gamma_seq))

  br89_Q = lambda x, u, t: (u - 4 * params_gamma * t + params_gamma * x ** 2 / 2) / 6

  br89_min_Q = 5e-13

  br89_v = lambda x: -2 * jnp.pi ** (1 / 3) / X_FACTOR_C * jnp.exp(x / 3) * (1 - jnp.exp(-x) * (1 + x / 2)) / x

  params_at = 0

  br89_y = lambda Q: 2 * jnp.pi ** (2 / 3) / (3 * Q)

  pgk_a1 = 1.525525181200953

  pgk_a2 = 0.4576575543602858

  pgk_a3 = 0.4292036732051034

  pgk_b = np.array([np.nan, 0.4771976183772063, -1.779981349455627, 3.843384186230215, -9.591205088051849, 2.173018028591672, -30.42513385160366], dtype=np.float64)

  pgk_c = np.array([np.nan, 0.7566445420735584, -2.636397787137096, 5.474515996423288, -12.65730812710829, 4.125058472512136, -30.42513395716384], dtype=np.float64)

  pgk_d = np.array([np.nan, 4.435009886795587e-05, 0.5812865360445791, 66.7427645159406, 434.2678089722977, 824.7765766052239, 1657.965273158212], dtype=np.float64)

  pgk_e = np.array([np.nan, 3.347285060926091e-05, 0.4791793102397135, 62.39226833857424, 463.1481642793812, 785.2360350104029, 1657.962968223273], dtype=np.float64)

  pgk_UB = 2.085749716493756

  br89_cQ = lambda Q: f.my_piecewise3(jnp.abs(Q) < br89_min_Q, f.my_piecewise3(Q > 0, br89_min_Q, -br89_min_Q), Q)

  pgk_x_lower = lambda y: (-jnp.arctan(pgk_a1 * y + pgk_a2) + pgk_a3) * jnp.sum(jnp.array([pgk_c[i] * y ** (i - 1) for i in range(1, 6 + 1)]), axis=0) / jnp.sum(jnp.array([pgk_b[i] * y ** (i - 1) for i in range(1, 6 + 1)]), axis=0)

  pgk_x_upper = lambda y: (arccsch(pgk_UB * y) + 2) * jnp.sum(jnp.array([pgk_d[i] * y ** (i - 1) for i in range(1, 6 + 1)]), axis=0) / jnp.sum(jnp.array([pgk_e[i] * y ** (i - 1) for i in range(1, 6 + 1)]), axis=0)

  br89_mx = lambda Q: f.my_piecewise3(br89_y(Q) <= 0, pgk_x_lower(jnp.minimum(br89_y(Q), -br89_min_Q)), pgk_x_upper(jnp.maximum(br89_y(Q), br89_min_Q)))

  br89_f = lambda x, u, t: -br89_v(br89_mx(br89_cQ(br89_Q(x, u, t)))) / 2 * (1 + params_at * mgga_series_w(np.array([np.nan, 0, 1, 0, -2, 0, 1], dtype=np.float64), 6, t))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, br89_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_gamma_raw = params.gamma
  if isinstance(params_gamma_raw, (str, bytes, dict)):
    params_gamma = params_gamma_raw
  else:
    try:
      params_gamma_seq = list(params_gamma_raw)
    except TypeError:
      params_gamma = params_gamma_raw
    else:
      params_gamma_seq = np.asarray(params_gamma_seq, dtype=np.float64)
      params_gamma = np.concatenate((np.array([np.nan], dtype=np.float64), params_gamma_seq))

  br89_Q = lambda x, u, t: (u - 4 * params_gamma * t + params_gamma * x ** 2 / 2) / 6

  br89_min_Q = 5e-13

  br89_v = lambda x: -2 * jnp.pi ** (1 / 3) / X_FACTOR_C * jnp.exp(x / 3) * (1 - jnp.exp(-x) * (1 + x / 2)) / x

  params_at = 0

  br89_y = lambda Q: 2 * jnp.pi ** (2 / 3) / (3 * Q)

  pgk_a1 = 1.525525181200953

  pgk_a2 = 0.4576575543602858

  pgk_a3 = 0.4292036732051034

  pgk_b = np.array([np.nan, 0.4771976183772063, -1.779981349455627, 3.843384186230215, -9.591205088051849, 2.173018028591672, -30.42513385160366], dtype=np.float64)

  pgk_c = np.array([np.nan, 0.7566445420735584, -2.636397787137096, 5.474515996423288, -12.65730812710829, 4.125058472512136, -30.42513395716384], dtype=np.float64)

  pgk_d = np.array([np.nan, 4.435009886795587e-05, 0.5812865360445791, 66.7427645159406, 434.2678089722977, 824.7765766052239, 1657.965273158212], dtype=np.float64)

  pgk_e = np.array([np.nan, 3.347285060926091e-05, 0.4791793102397135, 62.39226833857424, 463.1481642793812, 785.2360350104029, 1657.962968223273], dtype=np.float64)

  pgk_UB = 2.085749716493756

  br89_cQ = lambda Q: f.my_piecewise3(jnp.abs(Q) < br89_min_Q, f.my_piecewise3(Q > 0, br89_min_Q, -br89_min_Q), Q)

  pgk_x_lower = lambda y: (-jnp.arctan(pgk_a1 * y + pgk_a2) + pgk_a3) * jnp.sum(jnp.array([pgk_c[i] * y ** (i - 1) for i in range(1, 6 + 1)]), axis=0) / jnp.sum(jnp.array([pgk_b[i] * y ** (i - 1) for i in range(1, 6 + 1)]), axis=0)

  pgk_x_upper = lambda y: (arccsch(pgk_UB * y) + 2) * jnp.sum(jnp.array([pgk_d[i] * y ** (i - 1) for i in range(1, 6 + 1)]), axis=0) / jnp.sum(jnp.array([pgk_e[i] * y ** (i - 1) for i in range(1, 6 + 1)]), axis=0)

  br89_mx = lambda Q: f.my_piecewise3(br89_y(Q) <= 0, pgk_x_lower(jnp.minimum(br89_y(Q), -br89_min_Q)), pgk_x_upper(jnp.maximum(br89_y(Q), br89_min_Q)))

  br89_f = lambda x, u, t: -br89_v(br89_mx(br89_cQ(br89_Q(x, u, t)))) / 2 * (1 + params_at * mgga_series_w(np.array([np.nan, 0, 1, 0, -2, 0, 1], dtype=np.float64), 6, t))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, br89_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_gamma_raw = params.gamma
  if isinstance(params_gamma_raw, (str, bytes, dict)):
    params_gamma = params_gamma_raw
  else:
    try:
      params_gamma_seq = list(params_gamma_raw)
    except TypeError:
      params_gamma = params_gamma_raw
    else:
      params_gamma_seq = np.asarray(params_gamma_seq, dtype=np.float64)
      params_gamma = np.concatenate((np.array([np.nan], dtype=np.float64), params_gamma_seq))

  br89_Q = lambda x, u, t: (u - 4 * params_gamma * t + params_gamma * x ** 2 / 2) / 6

  br89_min_Q = 5e-13

  br89_v = lambda x: -2 * jnp.pi ** (1 / 3) / X_FACTOR_C * jnp.exp(x / 3) * (1 - jnp.exp(-x) * (1 + x / 2)) / x

  params_at = 0

  br89_y = lambda Q: 2 * jnp.pi ** (2 / 3) / (3 * Q)

  pgk_a1 = 1.525525181200953

  pgk_a2 = 0.4576575543602858

  pgk_a3 = 0.4292036732051034

  pgk_b = np.array([np.nan, 0.4771976183772063, -1.779981349455627, 3.843384186230215, -9.591205088051849, 2.173018028591672, -30.42513385160366], dtype=np.float64)

  pgk_c = np.array([np.nan, 0.7566445420735584, -2.636397787137096, 5.474515996423288, -12.65730812710829, 4.125058472512136, -30.42513395716384], dtype=np.float64)

  pgk_d = np.array([np.nan, 4.435009886795587e-05, 0.5812865360445791, 66.7427645159406, 434.2678089722977, 824.7765766052239, 1657.965273158212], dtype=np.float64)

  pgk_e = np.array([np.nan, 3.347285060926091e-05, 0.4791793102397135, 62.39226833857424, 463.1481642793812, 785.2360350104029, 1657.962968223273], dtype=np.float64)

  pgk_UB = 2.085749716493756

  br89_cQ = lambda Q: f.my_piecewise3(jnp.abs(Q) < br89_min_Q, f.my_piecewise3(Q > 0, br89_min_Q, -br89_min_Q), Q)

  pgk_x_lower = lambda y: (-jnp.arctan(pgk_a1 * y + pgk_a2) + pgk_a3) * jnp.sum(jnp.array([pgk_c[i] * y ** (i - 1) for i in range(1, 6 + 1)]), axis=0) / jnp.sum(jnp.array([pgk_b[i] * y ** (i - 1) for i in range(1, 6 + 1)]), axis=0)

  pgk_x_upper = lambda y: (arccsch(pgk_UB * y) + 2) * jnp.sum(jnp.array([pgk_d[i] * y ** (i - 1) for i in range(1, 6 + 1)]), axis=0) / jnp.sum(jnp.array([pgk_e[i] * y ** (i - 1) for i in range(1, 6 + 1)]), axis=0)

  br89_mx = lambda Q: f.my_piecewise3(br89_y(Q) <= 0, pgk_x_lower(jnp.minimum(br89_y(Q), -br89_min_Q)), pgk_x_upper(jnp.maximum(br89_y(Q), br89_min_Q)))

  br89_f = lambda x, u, t: -br89_v(br89_mx(br89_cQ(br89_Q(x, u, t)))) / 2 * (1 + params_at * mgga_series_w(np.array([np.nan, 0, 1, 0, -2, 0, 1], dtype=np.float64), 6, t))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, br89_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 <= f.p.dens_threshold
  t2 = r0 + r1
  t3 = 0.1e1 / t2
  t6 = 0.2e1 * r0 * t3 <= f.p.zeta_threshold
  t7 = f.p.zeta_threshold - 0.1e1
  t10 = 0.2e1 * r1 * t3 <= f.p.zeta_threshold
  t11 = -t7
  t12 = r0 - r1
  t13 = t12 * t3
  t14 = f.my_piecewise5(t6, t7, t10, t11, t13)
  t15 = 0.1e1 + t14
  t16 = t15 <= f.p.zeta_threshold
  t17 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t18 = t17 * f.p.zeta_threshold
  t19 = t15 ** (0.1e1 / 0.3e1)
  t21 = f.my_piecewise3(t16, t18, t19 * t15)
  t22 = t2 ** (0.1e1 / 0.3e1)
  t23 = t21 * t22
  t25 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t26 = 0.1e1 / t25
  t27 = t23 * t26
  t28 = 4 ** (0.1e1 / 0.3e1)
  t29 = jnp.pi ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = r0 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t34 = 0.1e1 / t32 / r0
  t37 = params.gamma * tau0
  t40 = params.gamma * s0
  t41 = r0 ** 2
  t43 = 0.1e1 / t32 / t41
  t46 = l0 * t34 / 0.6e1 - 0.2e1 / 0.3e1 * t37 * t34 + t40 * t43 / 0.12e2
  t47 = abs(t46)
  t48 = t47 < 0.50e-12
  t49 = 0.0e0 < t46
  t50 = f.my_piecewise3(t49, 0.50e-12, -0.50e-12)
  t51 = f.my_piecewise3(t48, t50, t46)
  t54 = 0.2e1 / 0.3e1 * t30 / t51
  t55 = t54 <= 0.0e0
  t56 = -0.50e-12 < t54
  t57 = f.my_piecewise3(t56, -0.50e-12, t54)
  t59 = 0.15255251812009530e1 * t57 + 0.4576575543602858e0
  t60 = jnp.arctan(t59)
  t61 = -t60 + 0.4292036732051034e0
  t63 = t57 ** 2
  t65 = t63 * t57
  t67 = t63 ** 2
  t69 = t67 * t57
  t71 = 0.7566445420735584e0 - 0.26363977871370960e1 * t57 + 0.54745159964232880e1 * t63 - 0.12657308127108290e2 * t65 + 0.41250584725121360e1 * t67 - 0.30425133957163840e2 * t69
  t72 = t61 * t71
  t78 = 0.4771976183772063e0 - 0.17799813494556270e1 * t57 + 0.38433841862302150e1 * t63 - 0.95912050880518490e1 * t65 + 0.21730180285916720e1 * t67 - 0.30425133851603660e2 * t69
  t79 = 0.1e1 / t78
  t81 = 0.50e-12 < t54
  t82 = f.my_piecewise3(t81, t54, 0.50e-12)
  t84 = jnp.arcsinh(0.1e1 / (0.2085749716493756e1 * t82))
  t85 = t84 + 0.2e1
  t87 = t82 ** 2
  t89 = t87 * t82
  t91 = t87 ** 2
  t93 = t91 * t82
  t95 = 0.4435009886795587e-4 + 0.58128653604457910e0 * t82 + 0.66742764515940610e2 * t87 + 0.43426780897229770e3 * t89 + 0.8247765766052239000e3 * t91 + 0.16579652731582120e4 * t93
  t96 = t85 * t95
  t102 = 0.3347285060926091e-4 + 0.47917931023971350e0 * t82 + 0.62392268338574240e2 * t87 + 0.46314816427938120e3 * t89 + 0.7852360350104029000e3 * t91 + 0.1657962968223273000000e4 * t93
  t103 = 0.1e1 / t102
  t105 = f.my_piecewise3(t55, t72 * t79, t96 * t103)
  t107 = jnp.exp(t105 / 0.3e1)
  t108 = t28 * t107
  t109 = jnp.exp(-t105)
  t111 = 0.1e1 + t105 / 0.2e1
  t113 = -t109 * t111 + 0.1e1
  t114 = 0.1e1 / t105
  t115 = t113 * t114
  t116 = t108 * t115
  t119 = f.my_piecewise3(t1, 0, -t27 * t116 / 0.4e1)
  t120 = r1 <= f.p.dens_threshold
  t121 = f.my_piecewise5(t10, t7, t6, t11, -t13)
  t122 = 0.1e1 + t121
  t123 = t122 <= f.p.zeta_threshold
  t124 = t122 ** (0.1e1 / 0.3e1)
  t126 = f.my_piecewise3(t123, t18, t124 * t122)
  t127 = t126 * t22
  t128 = t127 * t26
  t129 = r1 ** (0.1e1 / 0.3e1)
  t130 = t129 ** 2
  t132 = 0.1e1 / t130 / r1
  t135 = params.gamma * tau1
  t138 = params.gamma * s2
  t139 = r1 ** 2
  t141 = 0.1e1 / t130 / t139
  t144 = l1 * t132 / 0.6e1 - 0.2e1 / 0.3e1 * t135 * t132 + t138 * t141 / 0.12e2
  t145 = abs(t144)
  t146 = t145 < 0.50e-12
  t147 = 0.0e0 < t144
  t148 = f.my_piecewise3(t147, 0.50e-12, -0.50e-12)
  t149 = f.my_piecewise3(t146, t148, t144)
  t152 = 0.2e1 / 0.3e1 * t30 / t149
  t153 = t152 <= 0.0e0
  t154 = -0.50e-12 < t152
  t155 = f.my_piecewise3(t154, -0.50e-12, t152)
  t157 = 0.15255251812009530e1 * t155 + 0.4576575543602858e0
  t158 = jnp.arctan(t157)
  t159 = -t158 + 0.4292036732051034e0
  t161 = t155 ** 2
  t163 = t161 * t155
  t165 = t161 ** 2
  t167 = t165 * t155
  t169 = 0.7566445420735584e0 - 0.26363977871370960e1 * t155 + 0.54745159964232880e1 * t161 - 0.12657308127108290e2 * t163 + 0.41250584725121360e1 * t165 - 0.30425133957163840e2 * t167
  t170 = t159 * t169
  t176 = 0.4771976183772063e0 - 0.17799813494556270e1 * t155 + 0.38433841862302150e1 * t161 - 0.95912050880518490e1 * t163 + 0.21730180285916720e1 * t165 - 0.30425133851603660e2 * t167
  t177 = 0.1e1 / t176
  t179 = 0.50e-12 < t152
  t180 = f.my_piecewise3(t179, t152, 0.50e-12)
  t182 = jnp.arcsinh(0.1e1 / (0.2085749716493756e1 * t180))
  t183 = t182 + 0.2e1
  t185 = t180 ** 2
  t187 = t185 * t180
  t189 = t185 ** 2
  t191 = t189 * t180
  t193 = 0.4435009886795587e-4 + 0.58128653604457910e0 * t180 + 0.66742764515940610e2 * t185 + 0.43426780897229770e3 * t187 + 0.8247765766052239000e3 * t189 + 0.16579652731582120e4 * t191
  t194 = t183 * t193
  t200 = 0.3347285060926091e-4 + 0.47917931023971350e0 * t180 + 0.62392268338574240e2 * t185 + 0.46314816427938120e3 * t187 + 0.7852360350104029000e3 * t189 + 0.1657962968223273000000e4 * t191
  t201 = 0.1e1 / t200
  t203 = f.my_piecewise3(t153, t170 * t177, t194 * t201)
  t205 = jnp.exp(t203 / 0.3e1)
  t206 = t28 * t205
  t207 = jnp.exp(-t203)
  t209 = 0.1e1 + t203 / 0.2e1
  t211 = -t207 * t209 + 0.1e1
  t212 = 0.1e1 / t203
  t213 = t211 * t212
  t214 = t206 * t213
  t217 = f.my_piecewise3(t120, 0, -t128 * t214 / 0.4e1)
  t218 = t2 ** 2
  t220 = t12 / t218
  t221 = t3 - t220
  t222 = f.my_piecewise5(t6, 0, t10, 0, t221)
  t225 = f.my_piecewise3(t16, 0, 0.4e1 / 0.3e1 * t19 * t222)
  t230 = t22 ** 2
  t231 = 0.1e1 / t230
  t235 = t21 * t231 * t26 * t116 / 0.12e2
  t236 = t26 * t28
  t237 = t23 * t236
  t238 = t51 ** 2
  t240 = t30 / t238
  t241 = f.my_piecewise3(t49, 0, 0)
  t252 = f.my_piecewise3(t48, t241, -0.5e1 / 0.18e2 * l0 * t43 + 0.10e2 / 0.9e1 * t37 * t43 - 0.2e1 / 0.9e1 * t40 / t32 / t41 / r0)
  t254 = 0.2e1 / 0.3e1 * t240 * t252
  t255 = f.my_piecewise3(t56, 0, -t254)
  t256 = t59 ** 2
  t258 = 0.1e1 / (0.1e1 + t256)
  t260 = t71 * t79
  t264 = t57 * t255
  t266 = t63 * t255
  t268 = t65 * t255
  t270 = t67 * t255
  t275 = t78 ** 2
  t276 = 0.1e1 / t275
  t286 = f.my_piecewise3(t81, -t254, 0)
  t287 = 0.1e1 / t87
  t291 = jnp.sqrt(0.1e1 + 0.22986646313162379473052514971156003214950381710772e0 * t287)
  t294 = 0.1e1 / t291 * t95 * t103
  t298 = t82 * t286
  t300 = t87 * t286
  t302 = t89 * t286
  t304 = t91 * t286
  t309 = t102 ** 2
  t310 = 0.1e1 / t309
  t320 = f.my_piecewise3(t55, -0.15255251812009530e1 * t255 * t258 * t260 + t61 * (-0.26363977871370960e1 * t255 + 0.109490319928465760e2 * t264 - 0.37971924381324870e2 * t266 + 0.165002338900485440e2 * t268 - 0.152125669785819200e3 * t270) * t79 - t72 * t276 * (-0.17799813494556270e1 * t255 + 0.76867683724604300e1 * t264 - 0.287736152641555470e2 * t266 + 0.86920721143666880e1 * t268 - 0.152125669258018300e3 * t270), -0.47944391030820674584805316593270899479375949130735e0 * t286 * t287 * t294 + t85 * (0.58128653604457910e0 * t286 + 0.133485529031881220e3 * t298 + 0.130280342691689310e4 * t300 + 0.32991063064208956000e4 * t302 + 0.82898263657910600e4 * t304) * t103 - t96 * t310 * (0.47917931023971350e0 * t286 + 0.124784536677148480e3 * t298 + 0.138944449283814360e4 * t300 + 0.31409441400416116000e4 * t302 + 0.8289814841116365000000e4 * t304))
  t325 = t320 * t109
  t333 = t107 * t113
  t334 = t105 ** 2
  t335 = 0.1e1 / t334
  t341 = f.my_piecewise3(t1, 0, -t225 * t22 * t26 * t116 / 0.4e1 - t235 - t237 * t320 * t107 * t115 / 0.12e2 - t27 * t108 * (t325 * t111 - t325 / 0.2e1) * t114 / 0.4e1 + t237 * t333 * t335 * t320 / 0.4e1)
  t343 = f.my_piecewise5(t10, 0, t6, 0, -t221)
  t346 = f.my_piecewise3(t123, 0, 0.4e1 / 0.3e1 * t124 * t343)
  t354 = t126 * t231 * t26 * t214 / 0.12e2
  t356 = f.my_piecewise3(t120, 0, -t346 * t22 * t26 * t214 / 0.4e1 - t354)
  vrho_0_ = t119 + t217 + t2 * (t341 + t356)
  t359 = -t3 - t220
  t360 = f.my_piecewise5(t6, 0, t10, 0, t359)
  t363 = f.my_piecewise3(t16, 0, 0.4e1 / 0.3e1 * t19 * t360)
  t369 = f.my_piecewise3(t1, 0, -t363 * t22 * t26 * t116 / 0.4e1 - t235)
  t371 = f.my_piecewise5(t10, 0, t6, 0, -t359)
  t374 = f.my_piecewise3(t123, 0, 0.4e1 / 0.3e1 * t124 * t371)
  t379 = t127 * t236
  t380 = t149 ** 2
  t382 = t30 / t380
  t383 = f.my_piecewise3(t147, 0, 0)
  t394 = f.my_piecewise3(t146, t383, -0.5e1 / 0.18e2 * l1 * t141 + 0.10e2 / 0.9e1 * t135 * t141 - 0.2e1 / 0.9e1 * t138 / t130 / t139 / r1)
  t396 = 0.2e1 / 0.3e1 * t382 * t394
  t397 = f.my_piecewise3(t154, 0, -t396)
  t398 = t157 ** 2
  t400 = 0.1e1 / (0.1e1 + t398)
  t402 = t169 * t177
  t406 = t155 * t397
  t408 = t161 * t397
  t410 = t163 * t397
  t412 = t165 * t397
  t417 = t176 ** 2
  t418 = 0.1e1 / t417
  t428 = f.my_piecewise3(t179, -t396, 0)
  t429 = 0.1e1 / t185
  t433 = jnp.sqrt(0.1e1 + 0.22986646313162379473052514971156003214950381710772e0 * t429)
  t436 = 0.1e1 / t433 * t193 * t201
  t440 = t180 * t428
  t442 = t185 * t428
  t444 = t187 * t428
  t446 = t189 * t428
  t451 = t200 ** 2
  t452 = 0.1e1 / t451
  t462 = f.my_piecewise3(t153, -0.15255251812009530e1 * t397 * t400 * t402 + t159 * (-0.26363977871370960e1 * t397 + 0.109490319928465760e2 * t406 - 0.37971924381324870e2 * t408 + 0.165002338900485440e2 * t410 - 0.152125669785819200e3 * t412) * t177 - t170 * t418 * (-0.17799813494556270e1 * t397 + 0.76867683724604300e1 * t406 - 0.287736152641555470e2 * t408 + 0.86920721143666880e1 * t410 - 0.152125669258018300e3 * t412), -0.47944391030820674584805316593270899479375949130735e0 * t428 * t429 * t436 + t183 * (0.58128653604457910e0 * t428 + 0.133485529031881220e3 * t440 + 0.130280342691689310e4 * t442 + 0.32991063064208956000e4 * t444 + 0.82898263657910600e4 * t446) * t201 - t194 * t452 * (0.47917931023971350e0 * t428 + 0.124784536677148480e3 * t440 + 0.138944449283814360e4 * t442 + 0.31409441400416116000e4 * t444 + 0.8289814841116365000000e4 * t446))
  t467 = t462 * t207
  t475 = t205 * t211
  t476 = t203 ** 2
  t477 = 0.1e1 / t476
  t483 = f.my_piecewise3(t120, 0, -t374 * t22 * t26 * t214 / 0.4e1 - t354 - t379 * t462 * t205 * t213 / 0.12e2 - t128 * t206 * (t467 * t209 - t467 / 0.2e1) * t212 / 0.4e1 + t379 * t475 * t477 * t462 / 0.4e1)
  vrho_1_ = t119 + t217 + t2 * (t369 + t483)
  t488 = f.my_piecewise3(t48, t241, params.gamma * t43 / 0.12e2)
  t490 = 0.2e1 / 0.3e1 * t240 * t488
  t491 = f.my_piecewise3(t56, 0, -t490)
  t496 = t57 * t491
  t498 = t63 * t491
  t500 = t65 * t491
  t502 = t67 * t491
  t516 = f.my_piecewise3(t81, -t490, 0)
  t521 = t82 * t516
  t523 = t87 * t516
  t525 = t89 * t516
  t527 = t91 * t516
  t541 = f.my_piecewise3(t55, -0.15255251812009530e1 * t491 * t258 * t260 + t61 * (-0.26363977871370960e1 * t491 + 0.109490319928465760e2 * t496 - 0.37971924381324870e2 * t498 + 0.165002338900485440e2 * t500 - 0.152125669785819200e3 * t502) * t79 - t72 * t276 * (-0.17799813494556270e1 * t491 + 0.76867683724604300e1 * t496 - 0.287736152641555470e2 * t498 + 0.86920721143666880e1 * t500 - 0.152125669258018300e3 * t502), -0.47944391030820674584805316593270899479375949130735e0 * t516 * t287 * t294 + t85 * (0.58128653604457910e0 * t516 + 0.133485529031881220e3 * t521 + 0.130280342691689310e4 * t523 + 0.32991063064208956000e4 * t525 + 0.82898263657910600e4 * t527) * t103 - t96 * t310 * (0.47917931023971350e0 * t516 + 0.124784536677148480e3 * t521 + 0.138944449283814360e4 * t523 + 0.31409441400416116000e4 * t525 + 0.8289814841116365000000e4 * t527))
  t546 = t541 * t109
  t559 = f.my_piecewise3(t1, 0, -t237 * t541 * t107 * t115 / 0.12e2 - t27 * t108 * (t546 * t111 - t546 / 0.2e1) * t114 / 0.4e1 + t237 * t333 * t335 * t541 / 0.4e1)
  vsigma_0_ = t2 * t559
  vsigma_1_ = 0.0e0
  t562 = f.my_piecewise3(t146, t383, params.gamma * t141 / 0.12e2)
  t564 = 0.2e1 / 0.3e1 * t382 * t562
  t565 = f.my_piecewise3(t154, 0, -t564)
  t570 = t155 * t565
  t572 = t161 * t565
  t574 = t163 * t565
  t576 = t165 * t565
  t590 = f.my_piecewise3(t179, -t564, 0)
  t595 = t180 * t590
  t597 = t185 * t590
  t599 = t187 * t590
  t601 = t189 * t590
  t615 = f.my_piecewise3(t153, -0.15255251812009530e1 * t565 * t400 * t402 + t159 * (-0.26363977871370960e1 * t565 + 0.109490319928465760e2 * t570 - 0.37971924381324870e2 * t572 + 0.165002338900485440e2 * t574 - 0.152125669785819200e3 * t576) * t177 - t170 * t418 * (-0.17799813494556270e1 * t565 + 0.76867683724604300e1 * t570 - 0.287736152641555470e2 * t572 + 0.86920721143666880e1 * t574 - 0.152125669258018300e3 * t576), -0.47944391030820674584805316593270899479375949130735e0 * t590 * t429 * t436 + t183 * (0.58128653604457910e0 * t590 + 0.133485529031881220e3 * t595 + 0.130280342691689310e4 * t597 + 0.32991063064208956000e4 * t599 + 0.82898263657910600e4 * t601) * t201 - t194 * t452 * (0.47917931023971350e0 * t590 + 0.124784536677148480e3 * t595 + 0.138944449283814360e4 * t597 + 0.31409441400416116000e4 * t599 + 0.8289814841116365000000e4 * t601))
  t620 = t615 * t207
  t633 = f.my_piecewise3(t120, 0, -t379 * t615 * t205 * t213 / 0.12e2 - t128 * t206 * (t620 * t209 - t620 / 0.2e1) * t212 / 0.4e1 + t379 * t475 * t477 * t615 / 0.4e1)
  vsigma_2_ = t2 * t633
  t635 = f.my_piecewise3(t48, t241, t34 / 0.6e1)
  t637 = 0.2e1 / 0.3e1 * t240 * t635
  t638 = f.my_piecewise3(t56, 0, -t637)
  t643 = t57 * t638
  t645 = t63 * t638
  t647 = t65 * t638
  t649 = t67 * t638
  t663 = f.my_piecewise3(t81, -t637, 0)
  t668 = t82 * t663
  t670 = t87 * t663
  t672 = t89 * t663
  t674 = t91 * t663
  t688 = f.my_piecewise3(t55, -0.15255251812009530e1 * t638 * t258 * t260 + t61 * (-0.26363977871370960e1 * t638 + 0.109490319928465760e2 * t643 - 0.37971924381324870e2 * t645 + 0.165002338900485440e2 * t647 - 0.152125669785819200e3 * t649) * t79 - t72 * t276 * (-0.17799813494556270e1 * t638 + 0.76867683724604300e1 * t643 - 0.287736152641555470e2 * t645 + 0.86920721143666880e1 * t647 - 0.152125669258018300e3 * t649), -0.47944391030820674584805316593270899479375949130735e0 * t663 * t287 * t294 + t85 * (0.58128653604457910e0 * t663 + 0.133485529031881220e3 * t668 + 0.130280342691689310e4 * t670 + 0.32991063064208956000e4 * t672 + 0.82898263657910600e4 * t674) * t103 - t96 * t310 * (0.47917931023971350e0 * t663 + 0.124784536677148480e3 * t668 + 0.138944449283814360e4 * t670 + 0.31409441400416116000e4 * t672 + 0.8289814841116365000000e4 * t674))
  t693 = t688 * t109
  t706 = f.my_piecewise3(t1, 0, -t237 * t688 * t107 * t115 / 0.12e2 - t27 * t108 * (t693 * t111 - t693 / 0.2e1) * t114 / 0.4e1 + t237 * t333 * t335 * t688 / 0.4e1)
  vlapl_0_ = t2 * t706
  t708 = f.my_piecewise3(t146, t383, t132 / 0.6e1)
  t710 = 0.2e1 / 0.3e1 * t382 * t708
  t711 = f.my_piecewise3(t154, 0, -t710)
  t716 = t155 * t711
  t718 = t161 * t711
  t720 = t163 * t711
  t722 = t165 * t711
  t736 = f.my_piecewise3(t179, -t710, 0)
  t741 = t180 * t736
  t743 = t185 * t736
  t745 = t187 * t736
  t747 = t189 * t736
  t761 = f.my_piecewise3(t153, -0.15255251812009530e1 * t711 * t400 * t402 + t159 * (-0.26363977871370960e1 * t711 + 0.109490319928465760e2 * t716 - 0.37971924381324870e2 * t718 + 0.165002338900485440e2 * t720 - 0.152125669785819200e3 * t722) * t177 - t170 * t418 * (-0.17799813494556270e1 * t711 + 0.76867683724604300e1 * t716 - 0.287736152641555470e2 * t718 + 0.86920721143666880e1 * t720 - 0.152125669258018300e3 * t722), -0.47944391030820674584805316593270899479375949130735e0 * t736 * t429 * t436 + t183 * (0.58128653604457910e0 * t736 + 0.133485529031881220e3 * t741 + 0.130280342691689310e4 * t743 + 0.32991063064208956000e4 * t745 + 0.82898263657910600e4 * t747) * t201 - t194 * t452 * (0.47917931023971350e0 * t736 + 0.124784536677148480e3 * t741 + 0.138944449283814360e4 * t743 + 0.31409441400416116000e4 * t745 + 0.8289814841116365000000e4 * t747))
  t766 = t761 * t207
  t779 = f.my_piecewise3(t120, 0, -t379 * t761 * t205 * t213 / 0.12e2 - t128 * t206 * (t766 * t209 - t766 / 0.2e1) * t212 / 0.4e1 + t379 * t475 * t477 * t761 / 0.4e1)
  vlapl_1_ = t2 * t779
  t782 = f.my_piecewise3(t48, t241, -0.2e1 / 0.3e1 * params.gamma * t34)
  t784 = 0.2e1 / 0.3e1 * t240 * t782
  t785 = f.my_piecewise3(t56, 0, -t784)
  t790 = t57 * t785
  t792 = t63 * t785
  t794 = t65 * t785
  t796 = t67 * t785
  t810 = f.my_piecewise3(t81, -t784, 0)
  t815 = t82 * t810
  t817 = t87 * t810
  t819 = t89 * t810
  t821 = t91 * t810
  t835 = f.my_piecewise3(t55, -0.15255251812009530e1 * t785 * t258 * t260 + t61 * (-0.26363977871370960e1 * t785 + 0.109490319928465760e2 * t790 - 0.37971924381324870e2 * t792 + 0.165002338900485440e2 * t794 - 0.152125669785819200e3 * t796) * t79 - t72 * t276 * (-0.17799813494556270e1 * t785 + 0.76867683724604300e1 * t790 - 0.287736152641555470e2 * t792 + 0.86920721143666880e1 * t794 - 0.152125669258018300e3 * t796), -0.47944391030820674584805316593270899479375949130735e0 * t810 * t287 * t294 + t85 * (0.58128653604457910e0 * t810 + 0.133485529031881220e3 * t815 + 0.130280342691689310e4 * t817 + 0.32991063064208956000e4 * t819 + 0.82898263657910600e4 * t821) * t103 - t96 * t310 * (0.47917931023971350e0 * t810 + 0.124784536677148480e3 * t815 + 0.138944449283814360e4 * t817 + 0.31409441400416116000e4 * t819 + 0.8289814841116365000000e4 * t821))
  t840 = t835 * t109
  t853 = f.my_piecewise3(t1, 0, -t237 * t835 * t107 * t115 / 0.12e2 - t27 * t108 * (t840 * t111 - t840 / 0.2e1) * t114 / 0.4e1 + t237 * t333 * t335 * t835 / 0.4e1)
  vtau_0_ = t2 * t853
  t856 = f.my_piecewise3(t146, t383, -0.2e1 / 0.3e1 * params.gamma * t132)
  t858 = 0.2e1 / 0.3e1 * t382 * t856
  t859 = f.my_piecewise3(t154, 0, -t858)
  t864 = t155 * t859
  t866 = t161 * t859
  t868 = t163 * t859
  t870 = t165 * t859
  t884 = f.my_piecewise3(t179, -t858, 0)
  t889 = t180 * t884
  t891 = t185 * t884
  t893 = t187 * t884
  t895 = t189 * t884
  t909 = f.my_piecewise3(t153, -0.15255251812009530e1 * t859 * t400 * t402 + t159 * (-0.26363977871370960e1 * t859 + 0.109490319928465760e2 * t864 - 0.37971924381324870e2 * t866 + 0.165002338900485440e2 * t868 - 0.152125669785819200e3 * t870) * t177 - t170 * t418 * (-0.17799813494556270e1 * t859 + 0.76867683724604300e1 * t864 - 0.287736152641555470e2 * t866 + 0.86920721143666880e1 * t868 - 0.152125669258018300e3 * t870), -0.47944391030820674584805316593270899479375949130735e0 * t884 * t429 * t436 + t183 * (0.58128653604457910e0 * t884 + 0.133485529031881220e3 * t889 + 0.130280342691689310e4 * t891 + 0.32991063064208956000e4 * t893 + 0.82898263657910600e4 * t895) * t201 - t194 * t452 * (0.47917931023971350e0 * t884 + 0.124784536677148480e3 * t889 + 0.138944449283814360e4 * t891 + 0.31409441400416116000e4 * t893 + 0.8289814841116365000000e4 * t895))
  t914 = t909 * t207
  t927 = f.my_piecewise3(t120, 0, -t379 * t909 * t205 * t213 / 0.12e2 - t128 * t206 * (t914 * t209 - t914 / 0.2e1) * t212 / 0.4e1 + t379 * t475 * t477 * t909 / 0.4e1)
  vtau_1_ = t2 * t927
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_gamma_raw = params.gamma
  if isinstance(params_gamma_raw, (str, bytes, dict)):
    params_gamma = params_gamma_raw
  else:
    try:
      params_gamma_seq = list(params_gamma_raw)
    except TypeError:
      params_gamma = params_gamma_raw
    else:
      params_gamma_seq = np.asarray(params_gamma_seq, dtype=np.float64)
      params_gamma = np.concatenate((np.array([np.nan], dtype=np.float64), params_gamma_seq))

  br89_Q = lambda x, u, t: (u - 4 * params_gamma * t + params_gamma * x ** 2 / 2) / 6

  br89_min_Q = 5e-13

  br89_v = lambda x: -2 * jnp.pi ** (1 / 3) / X_FACTOR_C * jnp.exp(x / 3) * (1 - jnp.exp(-x) * (1 + x / 2)) / x

  params_at = 0

  br89_y = lambda Q: 2 * jnp.pi ** (2 / 3) / (3 * Q)

  pgk_a1 = 1.525525181200953

  pgk_a2 = 0.4576575543602858

  pgk_a3 = 0.4292036732051034

  pgk_b = np.array([np.nan, 0.4771976183772063, -1.779981349455627, 3.843384186230215, -9.591205088051849, 2.173018028591672, -30.42513385160366], dtype=np.float64)

  pgk_c = np.array([np.nan, 0.7566445420735584, -2.636397787137096, 5.474515996423288, -12.65730812710829, 4.125058472512136, -30.42513395716384], dtype=np.float64)

  pgk_d = np.array([np.nan, 4.435009886795587e-05, 0.5812865360445791, 66.7427645159406, 434.2678089722977, 824.7765766052239, 1657.965273158212], dtype=np.float64)

  pgk_e = np.array([np.nan, 3.347285060926091e-05, 0.4791793102397135, 62.39226833857424, 463.1481642793812, 785.2360350104029, 1657.962968223273], dtype=np.float64)

  pgk_UB = 2.085749716493756

  br89_cQ = lambda Q: f.my_piecewise3(jnp.abs(Q) < br89_min_Q, f.my_piecewise3(Q > 0, br89_min_Q, -br89_min_Q), Q)

  pgk_x_lower = lambda y: (-jnp.arctan(pgk_a1 * y + pgk_a2) + pgk_a3) * jnp.sum(jnp.array([pgk_c[i] * y ** (i - 1) for i in range(1, 6 + 1)]), axis=0) / jnp.sum(jnp.array([pgk_b[i] * y ** (i - 1) for i in range(1, 6 + 1)]), axis=0)

  pgk_x_upper = lambda y: (arccsch(pgk_UB * y) + 2) * jnp.sum(jnp.array([pgk_d[i] * y ** (i - 1) for i in range(1, 6 + 1)]), axis=0) / jnp.sum(jnp.array([pgk_e[i] * y ** (i - 1) for i in range(1, 6 + 1)]), axis=0)

  br89_mx = lambda Q: f.my_piecewise3(br89_y(Q) <= 0, pgk_x_lower(jnp.minimum(br89_y(Q), -br89_min_Q)), pgk_x_upper(jnp.maximum(br89_y(Q), br89_min_Q)))

  br89_f = lambda x, u, t: -br89_v(br89_mx(br89_cQ(br89_Q(x, u, t)))) / 2 * (1 + params_at * mgga_series_w(np.array([np.nan, 0, 1, 0, -2, 0, 1], dtype=np.float64), 6, t))

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, br89_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 0.1e1 <= f.p.zeta_threshold
  t4 = f.p.zeta_threshold - 0.1e1
  t6 = f.my_piecewise5(t3, t4, t3, -t4, 0)
  t7 = 0.1e1 + t6
  t9 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t11 = t7 ** (0.1e1 / 0.3e1)
  t13 = f.my_piecewise3(t7 <= f.p.zeta_threshold, t9 * f.p.zeta_threshold, t11 * t7)
  t14 = r0 ** (0.1e1 / 0.3e1)
  t15 = t13 * t14
  t17 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t18 = 0.1e1 / t17
  t19 = t15 * t18
  t20 = 4 ** (0.1e1 / 0.3e1)
  t21 = jnp.pi ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 2 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = l0 * t24
  t26 = t14 ** 2
  t28 = 0.1e1 / t26 / r0
  t31 = params.gamma * tau0
  t32 = t24 * t28
  t35 = params.gamma * s0
  t36 = r0 ** 2
  t38 = 0.1e1 / t26 / t36
  t39 = t24 * t38
  t42 = t25 * t28 / 0.6e1 - 0.2e1 / 0.3e1 * t31 * t32 + t35 * t39 / 0.12e2
  t43 = abs(t42)
  t44 = t43 < 0.50e-12
  t45 = 0.0e0 < t42
  t46 = f.my_piecewise3(t45, 0.50e-12, -0.50e-12)
  t47 = f.my_piecewise3(t44, t46, t42)
  t50 = 0.2e1 / 0.3e1 * t22 / t47
  t51 = t50 <= 0.0e0
  t52 = -0.50e-12 < t50
  t53 = f.my_piecewise3(t52, -0.50e-12, t50)
  t55 = 0.15255251812009530e1 * t53 + 0.4576575543602858e0
  t56 = jnp.arctan(t55)
  t57 = -t56 + 0.4292036732051034e0
  t59 = t53 ** 2
  t61 = t59 * t53
  t63 = t59 ** 2
  t65 = t63 * t53
  t67 = 0.7566445420735584e0 - 0.26363977871370960e1 * t53 + 0.54745159964232880e1 * t59 - 0.12657308127108290e2 * t61 + 0.41250584725121360e1 * t63 - 0.30425133957163840e2 * t65
  t68 = t57 * t67
  t74 = 0.4771976183772063e0 - 0.17799813494556270e1 * t53 + 0.38433841862302150e1 * t59 - 0.95912050880518490e1 * t61 + 0.21730180285916720e1 * t63 - 0.30425133851603660e2 * t65
  t75 = 0.1e1 / t74
  t77 = 0.50e-12 < t50
  t78 = f.my_piecewise3(t77, t50, 0.50e-12)
  t80 = jnp.arcsinh(0.1e1 / (0.2085749716493756e1 * t78))
  t81 = t80 + 0.2e1
  t83 = t78 ** 2
  t85 = t83 * t78
  t87 = t83 ** 2
  t89 = t87 * t78
  t91 = 0.4435009886795587e-4 + 0.58128653604457910e0 * t78 + 0.66742764515940610e2 * t83 + 0.43426780897229770e3 * t85 + 0.8247765766052239000e3 * t87 + 0.16579652731582120e4 * t89
  t92 = t81 * t91
  t98 = 0.3347285060926091e-4 + 0.47917931023971350e0 * t78 + 0.62392268338574240e2 * t83 + 0.46314816427938120e3 * t85 + 0.7852360350104029000e3 * t87 + 0.1657962968223273000000e4 * t89
  t99 = 0.1e1 / t98
  t101 = f.my_piecewise3(t51, t68 * t75, t92 * t99)
  t103 = jnp.exp(t101 / 0.3e1)
  t104 = t20 * t103
  t105 = jnp.exp(-t101)
  t107 = 0.1e1 + t101 / 0.2e1
  t109 = -t105 * t107 + 0.1e1
  t110 = 0.1e1 / t101
  t111 = t109 * t110
  t112 = t104 * t111
  t115 = f.my_piecewise3(t2, 0, -t19 * t112 / 0.4e1)
  t122 = t15 * t18 * t20
  t123 = t47 ** 2
  t125 = t22 / t123
  t126 = f.my_piecewise3(t45, 0, 0)
  t138 = f.my_piecewise3(t44, t126, -0.5e1 / 0.18e2 * t25 * t38 + 0.10e2 / 0.9e1 * t31 * t39 - 0.2e1 / 0.9e1 * t35 * t24 / t26 / t36 / r0)
  t140 = 0.2e1 / 0.3e1 * t125 * t138
  t141 = f.my_piecewise3(t52, 0, -t140)
  t142 = t55 ** 2
  t144 = 0.1e1 / (0.1e1 + t142)
  t146 = t67 * t75
  t150 = t53 * t141
  t152 = t59 * t141
  t154 = t61 * t141
  t156 = t63 * t141
  t161 = t74 ** 2
  t162 = 0.1e1 / t161
  t172 = f.my_piecewise3(t77, -t140, 0)
  t173 = 0.1e1 / t83
  t177 = jnp.sqrt(0.1e1 + 0.22986646313162379473052514971156003214950381710772e0 * t173)
  t180 = 0.1e1 / t177 * t91 * t99
  t184 = t78 * t172
  t186 = t83 * t172
  t188 = t85 * t172
  t190 = t87 * t172
  t195 = t98 ** 2
  t196 = 0.1e1 / t195
  t206 = f.my_piecewise3(t51, -0.15255251812009530e1 * t141 * t144 * t146 + t57 * (-0.26363977871370960e1 * t141 + 0.109490319928465760e2 * t150 - 0.37971924381324870e2 * t152 + 0.165002338900485440e2 * t154 - 0.152125669785819200e3 * t156) * t75 - t68 * t162 * (-0.17799813494556270e1 * t141 + 0.76867683724604300e1 * t150 - 0.287736152641555470e2 * t152 + 0.86920721143666880e1 * t154 - 0.152125669258018300e3 * t156), -0.47944391030820674584805316593270899479375949130735e0 * t172 * t173 * t180 + t81 * (0.58128653604457910e0 * t172 + 0.133485529031881220e3 * t184 + 0.130280342691689310e4 * t186 + 0.32991063064208956000e4 * t188 + 0.82898263657910600e4 * t190) * t99 - t92 * t196 * (0.47917931023971350e0 * t172 + 0.124784536677148480e3 * t184 + 0.138944449283814360e4 * t186 + 0.31409441400416116000e4 * t188 + 0.8289814841116365000000e4 * t190))
  t211 = t206 * t105
  t219 = t103 * t109
  t220 = t101 ** 2
  t221 = 0.1e1 / t220
  t227 = f.my_piecewise3(t2, 0, -t13 / t26 * t18 * t112 / 0.12e2 - t122 * t206 * t103 * t111 / 0.12e2 - t19 * t104 * (t211 * t107 - t211 / 0.2e1) * t110 / 0.4e1 + t122 * t219 * t221 * t206 / 0.4e1)
  vrho_0_ = 0.2e1 * r0 * t227 + 0.2e1 * t115
  t230 = params.gamma * t24
  t233 = f.my_piecewise3(t44, t126, t230 * t38 / 0.12e2)
  t235 = 0.2e1 / 0.3e1 * t125 * t233
  t236 = f.my_piecewise3(t52, 0, -t235)
  t241 = t53 * t236
  t243 = t59 * t236
  t245 = t61 * t236
  t247 = t63 * t236
  t261 = f.my_piecewise3(t77, -t235, 0)
  t266 = t78 * t261
  t268 = t83 * t261
  t270 = t85 * t261
  t272 = t87 * t261
  t286 = f.my_piecewise3(t51, -0.15255251812009530e1 * t236 * t144 * t146 + t57 * (-0.26363977871370960e1 * t236 + 0.109490319928465760e2 * t241 - 0.37971924381324870e2 * t243 + 0.165002338900485440e2 * t245 - 0.152125669785819200e3 * t247) * t75 - t68 * t162 * (-0.17799813494556270e1 * t236 + 0.76867683724604300e1 * t241 - 0.287736152641555470e2 * t243 + 0.86920721143666880e1 * t245 - 0.152125669258018300e3 * t247), -0.47944391030820674584805316593270899479375949130735e0 * t261 * t173 * t180 + t81 * (0.58128653604457910e0 * t261 + 0.133485529031881220e3 * t266 + 0.130280342691689310e4 * t268 + 0.32991063064208956000e4 * t270 + 0.82898263657910600e4 * t272) * t99 - t92 * t196 * (0.47917931023971350e0 * t261 + 0.124784536677148480e3 * t266 + 0.138944449283814360e4 * t268 + 0.31409441400416116000e4 * t270 + 0.8289814841116365000000e4 * t272))
  t291 = t286 * t105
  t304 = f.my_piecewise3(t2, 0, -t122 * t286 * t103 * t111 / 0.12e2 - t19 * t104 * (t291 * t107 - t291 / 0.2e1) * t110 / 0.4e1 + t122 * t219 * t221 * t286 / 0.4e1)
  vsigma_0_ = 0.2e1 * r0 * t304
  t307 = f.my_piecewise3(t44, t126, t32 / 0.6e1)
  t309 = 0.2e1 / 0.3e1 * t125 * t307
  t310 = f.my_piecewise3(t52, 0, -t309)
  t315 = t53 * t310
  t317 = t59 * t310
  t319 = t61 * t310
  t321 = t63 * t310
  t335 = f.my_piecewise3(t77, -t309, 0)
  t340 = t78 * t335
  t342 = t83 * t335
  t344 = t85 * t335
  t346 = t87 * t335
  t360 = f.my_piecewise3(t51, -0.15255251812009530e1 * t310 * t144 * t146 + t57 * (-0.26363977871370960e1 * t310 + 0.109490319928465760e2 * t315 - 0.37971924381324870e2 * t317 + 0.165002338900485440e2 * t319 - 0.152125669785819200e3 * t321) * t75 - t68 * t162 * (-0.17799813494556270e1 * t310 + 0.76867683724604300e1 * t315 - 0.287736152641555470e2 * t317 + 0.86920721143666880e1 * t319 - 0.152125669258018300e3 * t321), -0.47944391030820674584805316593270899479375949130735e0 * t335 * t173 * t180 + t81 * (0.58128653604457910e0 * t335 + 0.133485529031881220e3 * t340 + 0.130280342691689310e4 * t342 + 0.32991063064208956000e4 * t344 + 0.82898263657910600e4 * t346) * t99 - t92 * t196 * (0.47917931023971350e0 * t335 + 0.124784536677148480e3 * t340 + 0.138944449283814360e4 * t342 + 0.31409441400416116000e4 * t344 + 0.8289814841116365000000e4 * t346))
  t365 = t360 * t105
  t378 = f.my_piecewise3(t2, 0, -t122 * t360 * t103 * t111 / 0.12e2 - t19 * t104 * (t365 * t107 - t365 / 0.2e1) * t110 / 0.4e1 + t122 * t219 * t221 * t360 / 0.4e1)
  vlapl_0_ = 0.2e1 * r0 * t378
  t382 = f.my_piecewise3(t44, t126, -0.2e1 / 0.3e1 * t230 * t28)
  t384 = 0.2e1 / 0.3e1 * t125 * t382
  t385 = f.my_piecewise3(t52, 0, -t384)
  t390 = t53 * t385
  t392 = t59 * t385
  t394 = t61 * t385
  t396 = t63 * t385
  t410 = f.my_piecewise3(t77, -t384, 0)
  t415 = t78 * t410
  t417 = t83 * t410
  t419 = t85 * t410
  t421 = t87 * t410
  t435 = f.my_piecewise3(t51, -0.15255251812009530e1 * t385 * t144 * t146 + t57 * (-0.26363977871370960e1 * t385 + 0.109490319928465760e2 * t390 - 0.37971924381324870e2 * t392 + 0.165002338900485440e2 * t394 - 0.152125669785819200e3 * t396) * t75 - t68 * t162 * (-0.17799813494556270e1 * t385 + 0.76867683724604300e1 * t390 - 0.287736152641555470e2 * t392 + 0.86920721143666880e1 * t394 - 0.152125669258018300e3 * t396), -0.47944391030820674584805316593270899479375949130735e0 * t410 * t173 * t180 + t81 * (0.58128653604457910e0 * t410 + 0.133485529031881220e3 * t415 + 0.130280342691689310e4 * t417 + 0.32991063064208956000e4 * t419 + 0.82898263657910600e4 * t421) * t99 - t92 * t196 * (0.47917931023971350e0 * t410 + 0.124784536677148480e3 * t415 + 0.138944449283814360e4 * t417 + 0.31409441400416116000e4 * t419 + 0.8289814841116365000000e4 * t421))
  t440 = t435 * t105
  t453 = f.my_piecewise3(t2, 0, -t122 * t435 * t103 * t111 / 0.12e2 - t19 * t104 * (t440 * t107 - t440 / 0.2e1) * t110 / 0.4e1 + t122 * t219 * t221 * t435 / 0.4e1)
  vtau_0_ = 0.2e1 * r0 * t453
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 0.1e1 <= f.p.zeta_threshold
  t4 = f.p.zeta_threshold - 0.1e1
  t6 = f.my_piecewise5(t3, t4, t3, -t4, 0)
  t7 = 0.1e1 + t6
  t9 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t11 = t7 ** (0.1e1 / 0.3e1)
  t13 = f.my_piecewise3(t7 <= f.p.zeta_threshold, t9 * f.p.zeta_threshold, t11 * t7)
  t14 = r0 ** (0.1e1 / 0.3e1)
  t15 = t14 ** 2
  t17 = t13 / t15
  t19 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t20 = 0.1e1 / t19
  t21 = t17 * t20
  t22 = 4 ** (0.1e1 / 0.3e1)
  t23 = jnp.pi ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = 2 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = l0 * t26
  t29 = 0.1e1 / t15 / r0
  t32 = params.gamma * tau0
  t36 = params.gamma * s0
  t37 = r0 ** 2
  t39 = 0.1e1 / t15 / t37
  t40 = t26 * t39
  t43 = t27 * t29 / 0.6e1 - 0.2e1 / 0.3e1 * t32 * t26 * t29 + t36 * t40 / 0.12e2
  t44 = abs(t43)
  t45 = t44 < 0.50e-12
  t46 = 0.0e0 < t43
  t47 = f.my_piecewise3(t46, 0.50e-12, -0.50e-12)
  t48 = f.my_piecewise3(t45, t47, t43)
  t51 = 0.2e1 / 0.3e1 * t24 / t48
  t52 = t51 <= 0.0e0
  t53 = -0.50e-12 < t51
  t54 = f.my_piecewise3(t53, -0.50e-12, t51)
  t56 = 0.15255251812009530e1 * t54 + 0.4576575543602858e0
  t57 = jnp.atan(t56)
  t58 = -t57 + 0.4292036732051034e0
  t60 = t54 ** 2
  t62 = t60 * t54
  t64 = t60 ** 2
  t66 = t64 * t54
  t68 = 0.7566445420735584e0 - 0.26363977871370960e1 * t54 + 0.54745159964232880e1 * t60 - 0.12657308127108290e2 * t62 + 0.41250584725121360e1 * t64 - 0.30425133957163840e2 * t66
  t69 = t58 * t68
  t75 = 0.4771976183772063e0 - 0.17799813494556270e1 * t54 + 0.38433841862302150e1 * t60 - 0.95912050880518490e1 * t62 + 0.21730180285916720e1 * t64 - 0.30425133851603660e2 * t66
  t76 = 0.1e1 / t75
  t78 = 0.50e-12 < t51
  t79 = f.my_piecewise3(t78, t51, 0.50e-12)
  t81 = jnp.asinh(0.1e1 / (0.2085749716493756e1 * t79))
  t82 = t81 + 0.2e1
  t84 = t79 ** 2
  t86 = t84 * t79
  t88 = t84 ** 2
  t90 = t88 * t79
  t92 = 0.4435009886795587e-4 + 0.58128653604457910e0 * t79 + 0.66742764515940610e2 * t84 + 0.43426780897229770e3 * t86 + 0.8247765766052239000e3 * t88 + 0.16579652731582120e4 * t90
  t93 = t82 * t92
  t99 = 0.3347285060926091e-4 + 0.47917931023971350e0 * t79 + 0.62392268338574240e2 * t84 + 0.46314816427938120e3 * t86 + 0.7852360350104029000e3 * t88 + 0.1657962968223273000000e4 * t90
  t100 = 0.1e1 / t99
  t102 = f.my_piecewise3(t52, t69 * t76, t93 * t100)
  t104 = jnp.exp(t102 / 0.3e1)
  t105 = t22 * t104
  t106 = jnp.exp(-t102)
  t108 = 0.1e1 + t102 / 0.2e1
  t110 = -t106 * t108 + 0.1e1
  t111 = 0.1e1 / t102
  t112 = t110 * t111
  t113 = t105 * t112
  t116 = t13 * t14
  t117 = t20 * t22
  t118 = t116 * t117
  t119 = t48 ** 2
  t121 = t24 / t119
  t122 = f.my_piecewise3(t46, 0, 0)
  t129 = 0.1e1 / t15 / t37 / r0
  t130 = t26 * t129
  t134 = f.my_piecewise3(t45, t122, -0.5e1 / 0.18e2 * t27 * t39 + 0.10e2 / 0.9e1 * t32 * t40 - 0.2e1 / 0.9e1 * t36 * t130)
  t136 = 0.2e1 / 0.3e1 * t121 * t134
  t137 = f.my_piecewise3(t53, 0, -t136)
  t138 = t56 ** 2
  t139 = 0.1e1 + t138
  t140 = 0.1e1 / t139
  t141 = t137 * t140
  t142 = t68 * t76
  t146 = t54 * t137
  t148 = t60 * t137
  t150 = t62 * t137
  t152 = t64 * t137
  t154 = -0.26363977871370960e1 * t137 + 0.109490319928465760e2 * t146 - 0.37971924381324870e2 * t148 + 0.165002338900485440e2 * t150 - 0.152125669785819200e3 * t152
  t155 = t58 * t154
  t157 = t75 ** 2
  t158 = 0.1e1 / t157
  t164 = -0.17799813494556270e1 * t137 + 0.76867683724604300e1 * t146 - 0.287736152641555470e2 * t148 + 0.86920721143666880e1 * t150 - 0.152125669258018300e3 * t152
  t165 = t158 * t164
  t168 = f.my_piecewise3(t78, -t136, 0)
  t169 = 0.1e1 / t84
  t170 = t168 * t169
  t172 = 0.1e1 + 0.22986646313162379473052514971156003214950381710772e0 * t169
  t173 = jnp.sqrt(t172)
  t174 = 0.1e1 / t173
  t176 = t174 * t92 * t100
  t180 = t79 * t168
  t182 = t84 * t168
  t184 = t86 * t168
  t186 = t88 * t168
  t188 = 0.58128653604457910e0 * t168 + 0.133485529031881220e3 * t180 + 0.130280342691689310e4 * t182 + 0.32991063064208956000e4 * t184 + 0.82898263657910600e4 * t186
  t189 = t82 * t188
  t191 = t99 ** 2
  t192 = 0.1e1 / t191
  t198 = 0.47917931023971350e0 * t168 + 0.124784536677148480e3 * t180 + 0.138944449283814360e4 * t182 + 0.31409441400416116000e4 * t184 + 0.8289814841116365000000e4 * t186
  t199 = t192 * t198
  t202 = f.my_piecewise3(t52, -0.15255251812009530e1 * t141 * t142 + t155 * t76 - t69 * t165, -0.47944391030820674584805316593270899479375949130735e0 * t170 * t176 + t189 * t100 - t93 * t199)
  t203 = t202 * t104
  t204 = t203 * t112
  t207 = t116 * t20
  t208 = t202 * t106
  t211 = t208 * t108 - t208 / 0.2e1
  t212 = t211 * t111
  t213 = t105 * t212
  t216 = t104 * t110
  t217 = t102 ** 2
  t218 = 0.1e1 / t217
  t219 = t218 * t202
  t220 = t216 * t219
  t224 = f.my_piecewise3(t2, 0, -t21 * t113 / 0.12e2 - t118 * t204 / 0.12e2 - t207 * t213 / 0.4e1 + t118 * t220 / 0.4e1)
  t230 = t17 * t117
  t240 = t134 ** 2
  t247 = t37 ** 2
  t254 = f.my_piecewise3(t45, t122, 0.20e2 / 0.27e2 * t27 * t129 - 0.80e2 / 0.27e2 * t32 * t130 + 0.22e2 / 0.27e2 * t36 * t26 / t15 / t247)
  t257 = 0.4e1 / 0.3e1 * t24 / t119 / t48 * t240 - 0.2e1 / 0.3e1 * t121 * t254
  t258 = f.my_piecewise3(t53, 0, t257)
  t262 = t137 ** 2
  t263 = t139 ** 2
  t278 = t54 * t258
  t280 = t54 * t262
  t282 = t60 * t258
  t284 = t60 * t262
  t286 = t62 * t258
  t288 = t62 * t262
  t290 = t64 * t258
  t299 = t164 ** 2
  t316 = f.my_piecewise3(t78, t257, 0)
  t320 = t168 ** 2
  t344 = t79 * t316
  t346 = t79 * t320
  t348 = t84 * t316
  t350 = t84 * t320
  t352 = t86 * t316
  t354 = t86 * t320
  t356 = t88 * t316
  t365 = t198 ** 2
  t382 = f.my_piecewise3(t52, -0.15255251812009530e1 * t258 * t140 * t142 + 0.465445415695640096887073621641800e1 * t262 / t263 * t142 * t56 - 0.30510503624019060e1 * t141 * t154 * t76 + 0.30510503624019060e1 * t141 * t68 * t158 * t164 + t58 * (-0.26363977871370960e1 * t258 + 0.109490319928465760e2 * t262 + 0.109490319928465760e2 * t278 - 0.75943848762649740e2 * t280 - 0.37971924381324870e2 * t282 + 0.495007016701456320e2 * t284 + 0.165002338900485440e2 * t286 - 0.608502679143276800e3 * t288 - 0.152125669785819200e3 * t290) * t76 - 0.2e1 * t155 * t165 + 0.2e1 * t69 / t157 / t75 * t299 - t69 * t158 * (-0.17799813494556270e1 * t258 + 0.76867683724604300e1 * t262 + 0.76867683724604300e1 * t278 - 0.575472305283110940e2 * t280 - 0.287736152641555470e2 * t282 + 0.260762163431000640e2 * t284 + 0.86920721143666880e1 * t286 - 0.608502677032073200e3 * t288 - 0.152125669258018300e3 * t290), -0.47944391030820674584805316593270899479375949130735e0 * t316 * t169 * t176 + 0.95888782061641349169610633186541798958751898261470e0 * t320 / t86 * t176 - 0.11020807593254295137603963227001691102154720235348e0 * t320 / t90 / t173 / t172 * t92 * t100 - 0.95888782061641349169610633186541798958751898261470e0 * t170 * t174 * t188 * t100 + 0.95888782061641349169610633186541798958751898261470e0 * t170 * t174 * t92 * t192 * t198 + t82 * (0.58128653604457910e0 * t316 + 0.133485529031881220e3 * t320 + 0.133485529031881220e3 * t344 + 0.260560685383378620e4 * t346 + 0.130280342691689310e4 * t348 + 0.98973189192626868000e4 * t350 + 0.32991063064208956000e4 * t352 + 0.331593054631642400e5 * t354 + 0.82898263657910600e4 * t356) * t100 - 0.2e1 * t189 * t199 + 0.2e1 * t93 / t191 / t99 * t365 - t93 * t192 * (0.47917931023971350e0 * t316 + 0.124784536677148480e3 * t320 + 0.124784536677148480e3 * t344 + 0.277888898567628720e4 * t346 + 0.138944449283814360e4 * t348 + 0.94228324201248348000e4 * t350 + 0.31409441400416116000e4 * t352 + 0.33159259364465460000000e5 * t354 + 0.8289814841116365000000e4 * t356))
  t387 = t202 ** 2
  t388 = t387 * t104
  t399 = t382 * t106
  t401 = t387 * t106
  t423 = t13 * t29 * t20 * t113 / 0.18e2 - t230 * t204 / 0.18e2 - t21 * t213 / 0.6e1 + t230 * t220 / 0.6e1 - t118 * t382 * t104 * t112 / 0.12e2 - t118 * t388 * t112 / 0.36e2 - t118 * t203 * t212 / 0.6e1 + t118 * t388 * t110 * t218 / 0.6e1 - t207 * t105 * (t399 * t108 - t401 * t108 + t401 - t399 / 0.2e1) * t111 / 0.4e1 + t118 * t104 * t211 * t219 / 0.2e1 - t118 * t216 / t217 / t102 * t387 / 0.2e1 + t118 * t216 * t218 * t382 / 0.4e1
  t424 = f.my_piecewise3(t2, 0, t423)
  v2rho2_0_ = 0.2e1 * r0 * t424 + 0.4e1 * t224

  res = {'v2rho2': v2rho2_0_}
  return res
