"""Generated from mgga_x_mbrxc_bg.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  mbrxc_a1 = 0.074746

  mbrxc_a2 = 0.147

  mbrxc_a3 = 0.0032

  mbrxc_v0 = lambda x: -(32 * jnp.pi) ** (1 / 3) / (8 * X_FACTOR_C) * jnp.exp(x / 3) * (8 - jnp.exp(-x) * (x ** 2 + 5 * x + 8)) / (x * (1 + x) ** (1 / 3))

  mbrxc_v_smallq = lambda x: -1 / 12 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) - 1 / 108 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 2 + 1 / 108 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 3 - 13 / 1620 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 4 + 67 / 9720 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 5 - 52 / 8505 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 6 + 1811 / 326592 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 7

  mbrxc_v_cutoff = DBL_EPSILON ** (1 / 4)

  mbrxc_Q = lambda x, t: mbrxc_a1 * (2 * t) - K_FACTOR_C + mbrxc_a2 * x ** 2 + mbrxc_a3 * x ** 4

  mbrxc_v = lambda x: f.my_piecewise3(x < mbrxc_v_cutoff, mbrxc_v_smallq(x), mbrxc_v0(jnp.maximum(x, mbrxc_v_cutoff)))

  mbrxc_f = lambda x, u, t: -mbrxc_v(mbrxc_x(mbrxc_Q(x, t))) / 2

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, mbrxc_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  mbrxc_a1 = 0.074746

  mbrxc_a2 = 0.147

  mbrxc_a3 = 0.0032

  mbrxc_v0 = lambda x: -(32 * jnp.pi) ** (1 / 3) / (8 * X_FACTOR_C) * jnp.exp(x / 3) * (8 - jnp.exp(-x) * (x ** 2 + 5 * x + 8)) / (x * (1 + x) ** (1 / 3))

  mbrxc_v_smallq = lambda x: -1 / 12 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) - 1 / 108 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 2 + 1 / 108 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 3 - 13 / 1620 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 4 + 67 / 9720 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 5 - 52 / 8505 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 6 + 1811 / 326592 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 7

  mbrxc_v_cutoff = DBL_EPSILON ** (1 / 4)

  mbrxc_Q = lambda x, t: mbrxc_a1 * (2 * t) - K_FACTOR_C + mbrxc_a2 * x ** 2 + mbrxc_a3 * x ** 4

  mbrxc_v = lambda x: f.my_piecewise3(x < mbrxc_v_cutoff, mbrxc_v_smallq(x), mbrxc_v0(jnp.maximum(x, mbrxc_v_cutoff)))

  mbrxc_f = lambda x, u, t: -mbrxc_v(mbrxc_x(mbrxc_Q(x, t))) / 2

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, mbrxc_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  mbrxc_a1 = 0.074746

  mbrxc_a2 = 0.147

  mbrxc_a3 = 0.0032

  mbrxc_v0 = lambda x: -(32 * jnp.pi) ** (1 / 3) / (8 * X_FACTOR_C) * jnp.exp(x / 3) * (8 - jnp.exp(-x) * (x ** 2 + 5 * x + 8)) / (x * (1 + x) ** (1 / 3))

  mbrxc_v_smallq = lambda x: -1 / 12 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) - 1 / 108 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 2 + 1 / 108 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 3 - 13 / 1620 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 4 + 67 / 9720 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 5 - 52 / 8505 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 6 + 1811 / 326592 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 7

  mbrxc_v_cutoff = DBL_EPSILON ** (1 / 4)

  mbrxc_Q = lambda x, t: mbrxc_a1 * (2 * t) - K_FACTOR_C + mbrxc_a2 * x ** 2 + mbrxc_a3 * x ** 4

  mbrxc_v = lambda x: f.my_piecewise3(x < mbrxc_v_cutoff, mbrxc_v_smallq(x), mbrxc_v0(jnp.maximum(x, mbrxc_v_cutoff)))

  mbrxc_f = lambda x, u, t: -mbrxc_v(mbrxc_x(mbrxc_Q(x, t))) / 2

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, mbrxc_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t22 = t21 * f.p.zeta_threshold
  t23 = t19 ** (0.1e1 / 0.3e1)
  t25 = f.my_piecewise3(t20, t22, t23 * t19)
  t26 = t6 ** (0.1e1 / 0.3e1)
  t27 = t25 * t26
  t28 = r0 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t31 = 0.1e1 / t29 / r0
  t34 = 6 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t36 = jnp.pi ** 2
  t37 = t36 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t40 = 0.3e1 / 0.10e2 * t35 * t38
  t41 = r0 ** 2
  t43 = 0.1e1 / t29 / t41
  t46 = s0 ** 2
  t47 = t41 ** 2
  t50 = 0.1e1 / t28 / t47 / r0
  t53 = 0.149492e0 * tau0 * t31 - t40 + 0.147e0 * s0 * t43 + 0.32e-2 * t46 * t50
  t54 = mbrxc_x(t53)
  t55 = DBL_EPSILON ** (0.1e1 / 0.4e1)
  t56 = t54 < t55
  t57 = 32 ** (0.1e1 / 0.3e1)
  t58 = t57 * t3
  t59 = t2 ** 2
  t61 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t62 = 0.1e1 / t61
  t63 = t59 * t62
  t64 = 4 ** (0.1e1 / 0.3e1)
  t66 = t58 * t63 * t64
  t67 = t66 / 0.12e2
  t68 = t58 * t59
  t69 = t62 * t64
  t70 = t54 ** 2
  t71 = t69 * t70
  t74 = t70 * t54
  t75 = t69 * t74
  t78 = t70 ** 2
  t79 = t69 * t78
  t83 = t69 * t78 * t54
  t87 = t69 * t78 * t70
  t95 = t58 * t63
  t96 = t55 < t54
  t97 = f.my_piecewise3(t96, t54, t55)
  t99 = jnp.exp(t97 / 0.3e1)
  t100 = t64 * t99
  t101 = jnp.exp(-t97)
  t102 = t97 ** 2
  t104 = t102 + 0.5e1 * t97 + 0.8e1
  t106 = -t101 * t104 + 0.8e1
  t107 = 0.1e1 / t97
  t109 = 0.1e1 + t97
  t110 = t109 ** (0.1e1 / 0.3e1)
  t111 = 0.1e1 / t110
  t112 = t106 * t107 * t111
  t116 = f.my_piecewise3(t56, -t67 - t68 * t71 / 0.108e3 + t68 * t75 / 0.108e3 - 0.13e2 / 0.1620e4 * t68 * t79 + 0.67e2 / 0.9720e4 * t68 * t83 - 0.52e2 / 0.8505e4 * t68 * t87 + 0.1811e4 / 0.326592e6 * t68 * t69 * t78 * t74, -t95 * t100 * t112 / 0.36e2)
  t120 = f.my_piecewise3(t1, 0, 0.3e1 / 0.16e2 * t5 * t27 * t116)
  t121 = r1 <= f.p.dens_threshold
  t122 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t123 = 0.1e1 + t122
  t124 = t123 <= f.p.zeta_threshold
  t125 = t123 ** (0.1e1 / 0.3e1)
  t127 = f.my_piecewise3(t124, t22, t125 * t123)
  t128 = t127 * t26
  t129 = r1 ** (0.1e1 / 0.3e1)
  t130 = t129 ** 2
  t132 = 0.1e1 / t130 / r1
  t135 = r1 ** 2
  t137 = 0.1e1 / t130 / t135
  t140 = s2 ** 2
  t141 = t135 ** 2
  t144 = 0.1e1 / t129 / t141 / r1
  t147 = 0.149492e0 * tau1 * t132 - t40 + 0.147e0 * s2 * t137 + 0.32e-2 * t140 * t144
  t148 = mbrxc_x(t147)
  t149 = t148 < t55
  t150 = t148 ** 2
  t151 = t69 * t150
  t154 = t150 * t148
  t155 = t69 * t154
  t158 = t150 ** 2
  t159 = t69 * t158
  t163 = t69 * t158 * t148
  t167 = t69 * t158 * t150
  t175 = t55 < t148
  t176 = f.my_piecewise3(t175, t148, t55)
  t178 = jnp.exp(t176 / 0.3e1)
  t179 = t64 * t178
  t180 = jnp.exp(-t176)
  t181 = t176 ** 2
  t183 = t181 + 0.5e1 * t176 + 0.8e1
  t185 = -t180 * t183 + 0.8e1
  t186 = 0.1e1 / t176
  t188 = 0.1e1 + t176
  t189 = t188 ** (0.1e1 / 0.3e1)
  t190 = 0.1e1 / t189
  t191 = t185 * t186 * t190
  t195 = f.my_piecewise3(t149, -t67 - t68 * t151 / 0.108e3 + t68 * t155 / 0.108e3 - 0.13e2 / 0.1620e4 * t68 * t159 + 0.67e2 / 0.9720e4 * t68 * t163 - 0.52e2 / 0.8505e4 * t68 * t167 + 0.1811e4 / 0.326592e6 * t68 * t69 * t158 * t154, -t95 * t179 * t191 / 0.36e2)
  t199 = f.my_piecewise3(t121, 0, 0.3e1 / 0.16e2 * t5 * t128 * t195)
  t200 = t6 ** 2
  t202 = t16 / t200
  t203 = t7 - t202
  t204 = f.my_piecewise5(t10, 0, t14, 0, t203)
  t207 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t204)
  t212 = t26 ** 2
  t213 = 0.1e1 / t212
  t217 = t5 * t25 * t213 * t116 / 0.16e2
  t218 = jnp.pi * t59
  t220 = t218 * t69 * t54
  t234 = t53 ** 2
  t235 = 0.1e1 / t234
  t236 = (-0.24915333333333333333333333333333333333333333333333e0 * tau0 * t43 - 0.39200000000000000000000000000000000000000000000000e0 * s0 / t29 / t41 / r0 - 0.17066666666666666666666666666666666666666666666667e-1 * t46 / t28 / t47 / t41) * t235
  t238 = (0.1e1 + t54) ** (0.1e1 / 0.3e1)
  t239 = t238 ** 2
  t240 = 0.1e1 / t239
  t243 = jnp.exp(-0.2e1 / 0.3e1 * t54)
  t244 = 0.1e1 / t243
  t247 = 0.1e1 / (t70 - 0.3e1 * t54 + 0.6e1)
  t250 = (t54 - 0.3e1) ** 2
  t251 = t244 * t247 * t250
  t252 = t236 * t240 * t251
  t255 = t218 * t71
  t258 = t218 * t75
  t261 = t218 * t79
  t264 = t218 * t83
  t267 = t218 * t87
  t271 = t57 ** 2
  t272 = t3 ** 2
  t273 = t271 * t272
  t277 = t240 * t244 * t247 * t250
  t280 = f.my_piecewise3(t96, t273 * t236 * t277 / 0.4e1, 0)
  t298 = t99 * t106
  t300 = 0.1e1 / t102 * t111
  t307 = t107 / t110 / t109
  t313 = f.my_piecewise3(t56, -0.4e1 / 0.27e2 * t220 * t252 + 0.2e1 / 0.9e1 * t255 * t252 - 0.104e3 / 0.405e3 * t258 * t252 + 0.67e2 / 0.243e3 * t261 * t252 - 0.832e3 / 0.2835e4 * t264 * t252 + 0.1811e4 / 0.5832e4 * t267 * t252, -t66 * t280 * t99 * t112 / 0.108e3 - t95 * t100 * (t280 * t101 * t104 - t101 * (0.2e1 * t97 * t280 + 0.5e1 * t280)) * t107 * t111 / 0.36e2 + t66 * t298 * t300 * t280 / 0.36e2 + t66 * t298 * t307 * t280 / 0.108e3)
  t318 = f.my_piecewise3(t1, 0, 0.3e1 / 0.16e2 * t5 * t207 * t26 * t116 + t217 + 0.3e1 / 0.16e2 * t5 * t27 * t313)
  t320 = f.my_piecewise5(t14, 0, t10, 0, -t203)
  t323 = f.my_piecewise3(t124, 0, 0.4e1 / 0.3e1 * t125 * t320)
  t331 = t5 * t127 * t213 * t195 / 0.16e2
  t333 = f.my_piecewise3(t121, 0, 0.3e1 / 0.16e2 * t5 * t323 * t26 * t195 + t331)
  vrho_0_ = t120 + t199 + t6 * (t318 + t333)
  t336 = -t7 - t202
  t337 = f.my_piecewise5(t10, 0, t14, 0, t336)
  t340 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t23 * t337)
  t346 = f.my_piecewise3(t1, 0, 0.3e1 / 0.16e2 * t5 * t340 * t26 * t116 + t217)
  t348 = f.my_piecewise5(t14, 0, t10, 0, -t336)
  t351 = f.my_piecewise3(t124, 0, 0.4e1 / 0.3e1 * t125 * t348)
  t357 = t218 * t69 * t148
  t371 = t147 ** 2
  t372 = 0.1e1 / t371
  t373 = (-0.24915333333333333333333333333333333333333333333333e0 * tau1 * t137 - 0.39200000000000000000000000000000000000000000000000e0 * s2 / t130 / t135 / r1 - 0.17066666666666666666666666666666666666666666666667e-1 * t140 / t129 / t141 / t135) * t372
  t375 = (0.1e1 + t148) ** (0.1e1 / 0.3e1)
  t376 = t375 ** 2
  t377 = 0.1e1 / t376
  t380 = jnp.exp(-0.2e1 / 0.3e1 * t148)
  t381 = 0.1e1 / t380
  t384 = 0.1e1 / (t150 - 0.3e1 * t148 + 0.6e1)
  t387 = (t148 - 0.3e1) ** 2
  t388 = t381 * t384 * t387
  t389 = t373 * t377 * t388
  t392 = t218 * t151
  t395 = t218 * t155
  t398 = t218 * t159
  t401 = t218 * t163
  t404 = t218 * t167
  t411 = t377 * t381 * t384 * t387
  t414 = f.my_piecewise3(t175, t273 * t373 * t411 / 0.4e1, 0)
  t432 = t178 * t185
  t434 = 0.1e1 / t181 * t190
  t441 = t186 / t189 / t188
  t447 = f.my_piecewise3(t149, -0.4e1 / 0.27e2 * t357 * t389 + 0.2e1 / 0.9e1 * t392 * t389 - 0.104e3 / 0.405e3 * t395 * t389 + 0.67e2 / 0.243e3 * t398 * t389 - 0.832e3 / 0.2835e4 * t401 * t389 + 0.1811e4 / 0.5832e4 * t404 * t389, -t66 * t414 * t178 * t191 / 0.108e3 - t95 * t179 * (t414 * t180 * t183 - t180 * (0.2e1 * t176 * t414 + 0.5e1 * t414)) * t186 * t190 / 0.36e2 + t66 * t432 * t434 * t414 / 0.36e2 + t66 * t432 * t441 * t414 / 0.108e3)
  t452 = f.my_piecewise3(t121, 0, 0.3e1 / 0.16e2 * t5 * t351 * t26 * t195 + t331 + 0.3e1 / 0.16e2 * t5 * t128 * t447)
  vrho_1_ = t120 + t199 + t6 * (t346 + t452)
  t459 = (0.147e0 * t43 + 0.64e-2 * s0 * t50) * t235
  t461 = t459 * t240 * t251
  t478 = f.my_piecewise3(t96, t273 * t459 * t277 / 0.4e1, 0)
  t505 = f.my_piecewise3(t56, -0.4e1 / 0.27e2 * t220 * t461 + 0.2e1 / 0.9e1 * t255 * t461 - 0.104e3 / 0.405e3 * t258 * t461 + 0.67e2 / 0.243e3 * t261 * t461 - 0.832e3 / 0.2835e4 * t264 * t461 + 0.1811e4 / 0.5832e4 * t267 * t461, -t66 * t478 * t99 * t112 / 0.108e3 - t95 * t100 * (t478 * t101 * t104 - t101 * (0.2e1 * t97 * t478 + 0.5e1 * t478)) * t107 * t111 / 0.36e2 + t66 * t298 * t300 * t478 / 0.36e2 + t66 * t298 * t307 * t478 / 0.108e3)
  t509 = f.my_piecewise3(t1, 0, 0.3e1 / 0.16e2 * t5 * t27 * t505)
  vsigma_0_ = t6 * t509
  vsigma_1_ = 0.0e0
  t514 = (0.147e0 * t137 + 0.64e-2 * s2 * t144) * t372
  t516 = t514 * t377 * t388
  t533 = f.my_piecewise3(t175, t273 * t514 * t411 / 0.4e1, 0)
  t560 = f.my_piecewise3(t149, -0.4e1 / 0.27e2 * t357 * t516 + 0.2e1 / 0.9e1 * t392 * t516 - 0.104e3 / 0.405e3 * t395 * t516 + 0.67e2 / 0.243e3 * t398 * t516 - 0.832e3 / 0.2835e4 * t401 * t516 + 0.1811e4 / 0.5832e4 * t404 * t516, -t66 * t533 * t178 * t191 / 0.108e3 - t95 * t179 * (t533 * t180 * t183 - t180 * (0.2e1 * t176 * t533 + 0.5e1 * t533)) * t186 * t190 / 0.36e2 + t66 * t432 * t434 * t533 / 0.36e2 + t66 * t432 * t441 * t533 / 0.108e3)
  t564 = f.my_piecewise3(t121, 0, 0.3e1 / 0.16e2 * t5 * t128 * t560)
  vsigma_2_ = t6 * t564
  vlapl_0_ = 0.0e0
  vlapl_1_ = 0.0e0
  t565 = t31 * t235
  t567 = t565 * t240 * t251
  t584 = f.my_piecewise3(t96, 0.37373000000000000000000000000000000000000000000000e-1 * t273 * t565 * t277, 0)
  t611 = f.my_piecewise3(t56, -0.22146962962962962962962962962962962962962962962963e-1 * t220 * t567 + 0.33220444444444444444444444444444444444444444444444e-1 * t255 * t567 - 0.38388069135802469135802469135802469135802469135802e-1 * t258 * t567 + 0.41217958847736625514403292181069958847736625514403e-1 * t261 * t567 - 0.43872079012345679012345679012345679012345679012346e-1 * t264 * t567 + 0.46421469821673525377229080932784636488340192043896e-1 * t267 * t567, -t66 * t584 * t99 * t112 / 0.108e3 - t95 * t100 * (t584 * t101 * t104 - t101 * (0.2e1 * t97 * t584 + 0.5e1 * t584)) * t107 * t111 / 0.36e2 + t66 * t298 * t300 * t584 / 0.36e2 + t66 * t298 * t307 * t584 / 0.108e3)
  t615 = f.my_piecewise3(t1, 0, 0.3e1 / 0.16e2 * t5 * t27 * t611)
  vtau_0_ = t6 * t615
  t616 = t132 * t372
  t618 = t616 * t377 * t388
  t635 = f.my_piecewise3(t175, 0.37373000000000000000000000000000000000000000000000e-1 * t273 * t616 * t411, 0)
  t662 = f.my_piecewise3(t149, -0.22146962962962962962962962962962962962962962962963e-1 * t357 * t618 + 0.33220444444444444444444444444444444444444444444444e-1 * t392 * t618 - 0.38388069135802469135802469135802469135802469135802e-1 * t395 * t618 + 0.41217958847736625514403292181069958847736625514403e-1 * t398 * t618 - 0.43872079012345679012345679012345679012345679012346e-1 * t401 * t618 + 0.46421469821673525377229080932784636488340192043896e-1 * t404 * t618, -t66 * t635 * t178 * t191 / 0.108e3 - t95 * t179 * (t635 * t180 * t183 - t180 * (0.2e1 * t176 * t635 + 0.5e1 * t635)) * t186 * t190 / 0.36e2 + t66 * t432 * t434 * t635 / 0.36e2 + t66 * t432 * t441 * t635 / 0.108e3)
  t666 = f.my_piecewise3(t121, 0, 0.3e1 / 0.16e2 * t5 * t128 * t662)
  vtau_1_ = t6 * t666
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  mbrxc_a1 = 0.074746

  mbrxc_a2 = 0.147

  mbrxc_a3 = 0.0032

  mbrxc_v0 = lambda x: -(32 * jnp.pi) ** (1 / 3) / (8 * X_FACTOR_C) * jnp.exp(x / 3) * (8 - jnp.exp(-x) * (x ** 2 + 5 * x + 8)) / (x * (1 + x) ** (1 / 3))

  mbrxc_v_smallq = lambda x: -1 / 12 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) - 1 / 108 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 2 + 1 / 108 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 3 - 13 / 1620 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 4 + 67 / 9720 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 5 - 52 / 8505 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 6 + 1811 / 326592 * 32 ** (1 / 3) * jnp.pi ** (1 / 3) * 3 ** (2 / 3) / (1 / jnp.pi) ** (1 / 3) * 4 ** (1 / 3) * x ** 7

  mbrxc_v_cutoff = DBL_EPSILON ** (1 / 4)

  mbrxc_Q = lambda x, t: mbrxc_a1 * (2 * t) - K_FACTOR_C + mbrxc_a2 * x ** 2 + mbrxc_a3 * x ** 4

  mbrxc_v = lambda x: f.my_piecewise3(x < mbrxc_v_cutoff, mbrxc_v_smallq(x), mbrxc_v0(jnp.maximum(x, mbrxc_v_cutoff)))

  mbrxc_f = lambda x, u, t: -mbrxc_v(mbrxc_x(mbrxc_Q(x, t))) / 2

  functional_body = lambda rs, z, xt, xs0, xs1, u0, u1, t0, t1: mgga_exchange(f, params, mbrxc_f, rs, z, xs0, xs1, u0, u1, t0, t1)

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t17 * t18
  t20 = 2 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t22 = tau0 * t21
  t23 = t18 ** 2
  t25 = 0.1e1 / t23 / r0
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = jnp.pi ** 2
  t31 = t30 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t35 = s0 * t21
  t36 = r0 ** 2
  t38 = 0.1e1 / t23 / t36
  t41 = s0 ** 2
  t42 = t41 * t20
  t43 = t36 ** 2
  t46 = 0.1e1 / t18 / t43 / r0
  t49 = 0.149492e0 * t22 * t25 - 0.3e1 / 0.10e2 * t29 * t32 + 0.147e0 * t35 * t38 + 0.64e-2 * t42 * t46
  t50 = mbrxc_x(t49)
  t51 = DBL_EPSILON ** (0.1e1 / 0.4e1)
  t52 = t50 < t51
  t53 = 32 ** (0.1e1 / 0.3e1)
  t54 = t53 * t4
  t55 = t3 ** 2
  t57 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t58 = 0.1e1 / t57
  t59 = t55 * t58
  t60 = 4 ** (0.1e1 / 0.3e1)
  t62 = t54 * t59 * t60
  t64 = t54 * t55
  t65 = t58 * t60
  t66 = t50 ** 2
  t67 = t65 * t66
  t70 = t66 * t50
  t71 = t65 * t70
  t74 = t66 ** 2
  t75 = t65 * t74
  t78 = t74 * t50
  t79 = t65 * t78
  t82 = t74 * t66
  t83 = t65 * t82
  t91 = t54 * t59
  t92 = t51 < t50
  t93 = f.my_piecewise3(t92, t50, t51)
  t95 = jnp.exp(t93 / 0.3e1)
  t96 = t60 * t95
  t97 = jnp.exp(-t93)
  t98 = t93 ** 2
  t100 = t98 + 0.5e1 * t93 + 0.8e1
  t102 = -t97 * t100 + 0.8e1
  t103 = 0.1e1 / t93
  t105 = 0.1e1 + t93
  t106 = t105 ** (0.1e1 / 0.3e1)
  t107 = 0.1e1 / t106
  t108 = t102 * t103 * t107
  t112 = f.my_piecewise3(t52, -t62 / 0.12e2 - t64 * t67 / 0.108e3 + t64 * t71 / 0.108e3 - 0.13e2 / 0.1620e4 * t64 * t75 + 0.67e2 / 0.9720e4 * t64 * t79 - 0.52e2 / 0.8505e4 * t64 * t83 + 0.1811e4 / 0.326592e6 * t64 * t65 * t74 * t70, -t91 * t96 * t108 / 0.36e2)
  t116 = f.my_piecewise3(t2, 0, 0.3e1 / 0.16e2 * t6 * t19 * t112)
  t122 = jnp.pi * t55
  t124 = t122 * t65 * t50
  t138 = t49 ** 2
  t139 = 0.1e1 / t138
  t140 = (-0.24915333333333333333333333333333333333333333333333e0 * t22 * t38 - 0.39200000000000000000000000000000000000000000000000e0 * t35 / t23 / t36 / r0 - 0.34133333333333333333333333333333333333333333333333e-1 * t42 / t18 / t43 / t36) * t139
  t142 = (0.1e1 + t50) ** (0.1e1 / 0.3e1)
  t143 = t142 ** 2
  t144 = 0.1e1 / t143
  t147 = jnp.exp(-0.2e1 / 0.3e1 * t50)
  t148 = 0.1e1 / t147
  t151 = 0.1e1 / (t66 - 0.3e1 * t50 + 0.6e1)
  t154 = (t50 - 0.3e1) ** 2
  t155 = t148 * t151 * t154
  t156 = t140 * t144 * t155
  t159 = t122 * t67
  t162 = t122 * t71
  t165 = t122 * t75
  t168 = t122 * t79
  t171 = t122 * t83
  t175 = t53 ** 2
  t176 = t4 ** 2
  t177 = t175 * t176
  t181 = t144 * t148 * t151 * t154
  t184 = f.my_piecewise3(t92, t177 * t140 * t181 / 0.4e1, 0)
  t202 = t95 * t102
  t204 = 0.1e1 / t98 * t107
  t211 = t103 / t106 / t105
  t217 = f.my_piecewise3(t52, -0.4e1 / 0.27e2 * t124 * t156 + 0.2e1 / 0.9e1 * t159 * t156 - 0.104e3 / 0.405e3 * t162 * t156 + 0.67e2 / 0.243e3 * t165 * t156 - 0.832e3 / 0.2835e4 * t168 * t156 + 0.1811e4 / 0.5832e4 * t171 * t156, -t62 * t184 * t95 * t108 / 0.108e3 - t91 * t96 * (t184 * t97 * t100 - t97 * (0.2e1 * t93 * t184 + 0.5e1 * t184)) * t103 * t107 / 0.36e2 + t62 * t202 * t204 * t184 / 0.36e2 + t62 * t202 * t211 * t184 / 0.108e3)
  t222 = f.my_piecewise3(t2, 0, t6 * t17 / t23 * t112 / 0.16e2 + 0.3e1 / 0.16e2 * t6 * t19 * t217)
  vrho_0_ = 0.2e1 * r0 * t222 + 0.2e1 * t116
  t231 = (0.147e0 * t21 * t38 + 0.128e-1 * s0 * t20 * t46) * t139
  t233 = t231 * t144 * t155
  t250 = f.my_piecewise3(t92, t177 * t231 * t181 / 0.4e1, 0)
  t277 = f.my_piecewise3(t52, -0.4e1 / 0.27e2 * t124 * t233 + 0.2e1 / 0.9e1 * t159 * t233 - 0.104e3 / 0.405e3 * t162 * t233 + 0.67e2 / 0.243e3 * t165 * t233 - 0.832e3 / 0.2835e4 * t168 * t233 + 0.1811e4 / 0.5832e4 * t171 * t233, -t62 * t250 * t95 * t108 / 0.108e3 - t91 * t96 * (t250 * t97 * t100 - t97 * (0.2e1 * t93 * t250 + 0.5e1 * t250)) * t103 * t107 / 0.36e2 + t62 * t202 * t204 * t250 / 0.36e2 + t62 * t202 * t211 * t250 / 0.108e3)
  t281 = f.my_piecewise3(t2, 0, 0.3e1 / 0.16e2 * t6 * t19 * t277)
  vsigma_0_ = 0.2e1 * r0 * t281
  vlapl_0_ = 0.0e0
  t283 = t122 * t58
  t289 = t25 * t139 * t144 * t155
  t324 = f.my_piecewise3(t92, 0.37373000000000000000000000000000000000000000000000e-1 * t177 * t21 * t25 * t139 * t144 * t155, 0)
  t351 = f.my_piecewise3(t52, -0.22146962962962962962962962962962962962962962962963e-1 * t283 * t60 * t50 * t21 * t289 + 0.33220444444444444444444444444444444444444444444444e-1 * t283 * t60 * t66 * t21 * t289 - 0.38388069135802469135802469135802469135802469135802e-1 * t283 * t60 * t70 * t21 * t289 + 0.41217958847736625514403292181069958847736625514403e-1 * t283 * t60 * t74 * t21 * t289 - 0.43872079012345679012345679012345679012345679012346e-1 * t283 * t60 * t78 * t21 * t289 + 0.46421469821673525377229080932784636488340192043896e-1 * t283 * t60 * t82 * t21 * t289, -t62 * t324 * t95 * t108 / 0.108e3 - t91 * t96 * (t324 * t97 * t100 - t97 * (0.2e1 * t93 * t324 + 0.5e1 * t324)) * t103 * t107 / 0.36e2 + t62 * t202 * t204 * t324 / 0.36e2 + t62 * t202 * t211 * t324 / 0.108e3)
  t355 = f.my_piecewise3(t2, 0, 0.3e1 / 0.16e2 * t6 * t19 * t351)
  vtau_0_ = 0.2e1 * r0 * t355
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = t17 / t19
  t22 = 2 ** (0.1e1 / 0.3e1)
  t23 = t22 ** 2
  t24 = tau0 * t23
  t26 = 0.1e1 / t19 / r0
  t29 = 6 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = jnp.pi ** 2
  t32 = t31 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t36 = s0 * t23
  t37 = r0 ** 2
  t39 = 0.1e1 / t19 / t37
  t42 = s0 ** 2
  t43 = t42 * t22
  t44 = t37 ** 2
  t50 = 0.149492e0 * t24 * t26 - 0.3e1 / 0.10e2 * t30 * t33 + 0.147e0 * t36 * t39 + 0.64e-2 * t43 / t18 / t44 / r0
  t51 = mbrxc_x(t50)
  t52 = DBL_EPSILON ** (0.1e1 / 0.4e1)
  t53 = t51 < t52
  t54 = 32 ** (0.1e1 / 0.3e1)
  t55 = t54 * t4
  t56 = t3 ** 2
  t58 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t59 = 0.1e1 / t58
  t60 = t56 * t59
  t61 = 4 ** (0.1e1 / 0.3e1)
  t63 = t55 * t60 * t61
  t65 = t55 * t56
  t66 = t59 * t61
  t67 = t51 ** 2
  t68 = t66 * t67
  t71 = t67 * t51
  t72 = t66 * t71
  t75 = t67 ** 2
  t76 = t66 * t75
  t79 = t75 * t51
  t80 = t66 * t79
  t83 = t75 * t67
  t84 = t66 * t83
  t92 = t55 * t60
  t93 = t52 < t51
  t94 = f.my_piecewise3(t93, t51, t52)
  t96 = jnp.exp(t94 / 0.3e1)
  t97 = t61 * t96
  t98 = jnp.exp(-t94)
  t99 = t94 ** 2
  t101 = t99 + 0.5e1 * t94 + 0.8e1
  t103 = -t98 * t101 + 0.8e1
  t104 = 0.1e1 / t94
  t105 = t103 * t104
  t106 = 0.1e1 + t94
  t107 = t106 ** (0.1e1 / 0.3e1)
  t108 = 0.1e1 / t107
  t109 = t105 * t108
  t113 = f.my_piecewise3(t53, -t63 / 0.12e2 - t65 * t68 / 0.108e3 + t65 * t72 / 0.108e3 - 0.13e2 / 0.1620e4 * t65 * t76 + 0.67e2 / 0.9720e4 * t65 * t80 - 0.52e2 / 0.8505e4 * t65 * t84 + 0.1811e4 / 0.326592e6 * t65 * t66 * t75 * t71, -t92 * t97 * t109 / 0.36e2)
  t117 = t17 * t18
  t118 = jnp.pi * t56
  t120 = t118 * t66 * t51
  t123 = t37 * r0
  t125 = 0.1e1 / t19 / t123
  t133 = -0.24915333333333333333333333333333333333333333333333e0 * t24 * t39 - 0.39200000000000000000000000000000000000000000000000e0 * t36 * t125 - 0.34133333333333333333333333333333333333333333333333e-1 * t43 / t18 / t44 / t37
  t134 = t50 ** 2
  t135 = 0.1e1 / t134
  t136 = t133 * t135
  t137 = 0.1e1 + t51
  t138 = t137 ** (0.1e1 / 0.3e1)
  t139 = t138 ** 2
  t140 = 0.1e1 / t139
  t143 = jnp.exp(-0.2e1 / 0.3e1 * t51)
  t144 = 0.1e1 / t143
  t146 = t67 - 0.3e1 * t51 + 0.6e1
  t147 = 0.1e1 / t146
  t149 = t51 - 0.3e1
  t150 = t149 ** 2
  t151 = t144 * t147 * t150
  t152 = t136 * t140 * t151
  t155 = t118 * t68
  t158 = t118 * t72
  t161 = t118 * t76
  t164 = t118 * t80
  t167 = t118 * t84
  t171 = t54 ** 2
  t172 = t4 ** 2
  t173 = t171 * t172
  t174 = t173 * t136
  t175 = t140 * t144
  t177 = t175 * t147 * t150
  t178 = t174 * t177
  t180 = f.my_piecewise3(t93, t178 / 0.4e1, 0)
  t181 = t180 * t96
  t185 = t180 * t98
  t190 = 0.2e1 * t94 * t180 + 0.5e1 * t180
  t192 = t185 * t101 - t98 * t190
  t194 = t192 * t104 * t108
  t198 = t96 * t103
  t199 = 0.1e1 / t99
  t200 = t199 * t108
  t201 = t200 * t180
  t206 = 0.1e1 / t107 / t106
  t207 = t104 * t206
  t208 = t207 * t180
  t213 = f.my_piecewise3(t53, -0.4e1 / 0.27e2 * t120 * t152 + 0.2e1 / 0.9e1 * t155 * t152 - 0.104e3 / 0.405e3 * t158 * t152 + 0.67e2 / 0.243e3 * t161 * t152 - 0.832e3 / 0.2835e4 * t164 * t152 + 0.1811e4 / 0.5832e4 * t167 * t152, -t63 * t181 * t109 / 0.108e3 - t92 * t97 * t194 / 0.36e2 + t63 * t198 * t201 / 0.36e2 + t63 * t198 * t208 / 0.108e3)
  t218 = f.my_piecewise3(t2, 0, t6 * t21 * t113 / 0.16e2 + 0.3e1 / 0.16e2 * t6 * t117 * t213)
  t228 = t172 * jnp.pi * t56
  t229 = t228 * t59
  t230 = t61 * t83
  t231 = t133 ** 2
  t233 = t229 * t230 * t231
  t234 = t134 ** 2
  t235 = 0.1e1 / t234
  t237 = 0.1e1 / t138 / t137
  t239 = t143 ** 2
  t240 = 0.1e1 / t239
  t241 = t235 * t237 * t240
  t242 = t146 ** 2
  t243 = 0.1e1 / t242
  t244 = t150 ** 2
  t245 = t243 * t244
  t246 = t245 * t171
  t247 = t241 * t246
  t250 = t61 * t79
  t252 = t229 * t250 * t231
  t255 = t137 ** 2
  t257 = 0.1e1 / t138 / t255
  t260 = t235 * t257 * t240 * t246
  t264 = t243 * t150 * t149
  t266 = t241 * t264 * t171
  t269 = t118 * t59
  t272 = t135 * t140
  t283 = t243 * t150 * (t51 * t171 * t172 * t133 * t272 * t151 / 0.2e1 - 0.3e1 / 0.4e1 * t178)
  t284 = t272 * t144 * t283
  t287 = t61 * t71
  t289 = t229 * t287 * t231
  t296 = t61 * t75
  t302 = t229 * t296 * t231
  t309 = t61 * t67
  t315 = t229 * t309 * t231
  t326 = t61 * t51
  t328 = t229 * t326 * t231
  t331 = 0.1811e4 / 0.34992e5 * t233 * t247 + 0.56729e5 / 0.136080e6 * t252 * t247 + 0.416e3 / 0.8505e4 * t252 * t260 - 0.416e3 / 0.2835e4 * t252 * t266 - 0.1811e4 / 0.5832e4 * t269 * t230 * t133 * t284 + 0.52e2 / 0.1215e4 * t289 * t260 + 0.283e3 / 0.1215e4 * t289 * t247 - 0.52e2 / 0.405e3 * t289 * t266 - 0.67e2 / 0.243e3 * t269 * t296 * t133 * t284 - 0.67e2 / 0.1458e4 * t302 * t260 - 0.3275e4 / 0.10206e5 * t302 * t247 + 0.67e2 / 0.486e3 * t302 * t266 - 0.2e1 / 0.9e1 * t269 * t309 * t133 * t284 - t315 * t260 / 0.27e2 - 0.7e1 / 0.45e2 * t315 * t247 + t315 * t266 / 0.9e1 + 0.104e3 / 0.405e3 * t269 * t287 * t133 * t284 + 0.2e1 / 0.81e2 * t328 * t260
  t350 = t231 / t134 / t50
  t352 = t350 * t140 * t151
  t377 = (0.66440888888888888888888888888888888888888888888888e0 * t24 * t125 + 0.14373333333333333333333333333333333333333333333333e1 * t36 / t19 / t44 + 0.21617777777777777777777777777777777777777777777778e0 * t43 / t18 / t44 / t123) * t135
  t379 = t377 * t140 * t151
  t384 = t231 * t235
  t401 = 0.7e1 / 0.81e2 * t328 * t247 - 0.2e1 / 0.27e2 * t328 * t266 + 0.4e1 / 0.27e2 * t269 * t326 * t133 * t284 - 0.1811e4 / 0.34992e5 * t233 * t260 + 0.1811e4 / 0.11664e5 * t233 * t266 + 0.832e3 / 0.2835e4 * t269 * t250 * t133 * t284 + 0.1664e4 / 0.2835e4 * t164 * t352 - 0.1811e4 / 0.2916e4 * t167 * t352 - 0.134e3 / 0.243e3 * t161 * t352 - 0.4e1 / 0.9e1 * t155 * t352 + 0.208e3 / 0.405e3 * t158 * t352 + 0.8e1 / 0.27e2 * t120 * t352 - 0.4e1 / 0.27e2 * t120 * t379 - t228 * t66 * t171 * t384 * t237 * t240 * t243 * t244 / 0.27e2 + 0.2e1 / 0.9e1 * t155 * t379 - 0.104e3 / 0.405e3 * t158 * t379 + 0.67e2 / 0.243e3 * t161 * t379 - 0.832e3 / 0.2835e4 * t164 * t379 + 0.1811e4 / 0.5832e4 * t167 * t379
  t411 = t54 * t4 * jnp.pi * t384
  t416 = t237 * t240
  t427 = f.my_piecewise3(t93, t173 * t377 * t177 / 0.4e1 - t173 * t350 * t177 / 0.2e1 - 0.4e1 / 0.3e1 * t411 * t257 * t240 * t245 + 0.4e1 / 0.3e1 * t411 * t416 * t245 - t174 * t175 * t283 / 0.4e1 + 0.4e1 * t411 * t416 * t264, 0)
  t432 = t180 ** 2
  t433 = t432 * t96
  t467 = t96 * t192
  t490 = t106 ** 2
  t502 = -t63 * t427 * t96 * t109 / 0.108e3 - t63 * t433 * t109 / 0.324e3 - t63 * t181 * t194 / 0.54e2 + t63 * t433 * t103 * t199 * t108 / 0.54e2 + t63 * t433 * t105 * t206 / 0.162e3 - t92 * t97 * (t427 * t98 * t101 - t432 * t98 * t101 + 0.2e1 * t185 * t190 - t98 * (0.2e1 * t94 * t427 + 0.5e1 * t427 + 0.2e1 * t432)) * t104 * t108 / 0.36e2 + t63 * t467 * t201 / 0.18e2 + t63 * t467 * t208 / 0.54e2 - t63 * t198 / t99 / t94 * t108 * t432 / 0.18e2 - t63 * t198 * t199 * t206 * t432 / 0.54e2 + t63 * t198 * t200 * t427 / 0.36e2 - t63 * t198 * t104 / t107 / t490 * t432 / 0.81e2 + t63 * t198 * t207 * t427 / 0.108e3
  t503 = f.my_piecewise3(t53, t331 + t401, t502)
  t508 = f.my_piecewise3(t2, 0, -t6 * t17 * t26 * t113 / 0.24e2 + t6 * t21 * t213 / 0.8e1 + 0.3e1 / 0.16e2 * t6 * t117 * t503)
  v2rho2_0_ = 0.2e1 * r0 * t508 + 0.4e1 * t218
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t2 = r0 / 0.2e1 <= f.p.dens_threshold
  t3 = 3 ** (0.1e1 / 0.3e1)
  t4 = jnp.pi ** (0.1e1 / 0.3e1)
  t6 = t3 / t4
  t7 = 0.1e1 <= f.p.zeta_threshold
  t8 = f.p.zeta_threshold - 0.1e1
  t10 = f.my_piecewise5(t7, t8, t7, -t8, 0)
  t11 = 0.1e1 + t10
  t13 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t15 = t11 ** (0.1e1 / 0.3e1)
  t17 = f.my_piecewise3(t11 <= f.p.zeta_threshold, t13 * f.p.zeta_threshold, t15 * t11)
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = 0.1e1 / t19 / r0
  t22 = t17 * t21
  t23 = 2 ** (0.1e1 / 0.3e1)
  t24 = t23 ** 2
  t25 = tau0 * t24
  t28 = 6 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = jnp.pi ** 2
  t31 = t30 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t35 = s0 * t24
  t36 = r0 ** 2
  t38 = 0.1e1 / t19 / t36
  t41 = s0 ** 2
  t42 = t41 * t23
  t43 = t36 ** 2
  t44 = t43 * r0
  t49 = 0.149492e0 * t25 * t21 - 0.3e1 / 0.10e2 * t29 * t32 + 0.147e0 * t35 * t38 + 0.64e-2 * t42 / t18 / t44
  t50 = mbrxc_x(t49)
  t51 = DBL_EPSILON ** (0.1e1 / 0.4e1)
  t52 = t50 < t51
  t53 = 32 ** (0.1e1 / 0.3e1)
  t54 = t53 * t4
  t55 = t3 ** 2
  t57 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t58 = 0.1e1 / t57
  t59 = t55 * t58
  t60 = 4 ** (0.1e1 / 0.3e1)
  t62 = t54 * t59 * t60
  t64 = t54 * t55
  t65 = t58 * t60
  t66 = t50 ** 2
  t67 = t65 * t66
  t70 = t66 * t50
  t71 = t65 * t70
  t74 = t66 ** 2
  t75 = t65 * t74
  t78 = t74 * t50
  t79 = t65 * t78
  t82 = t74 * t66
  t83 = t65 * t82
  t91 = t54 * t59
  t92 = t51 < t50
  t93 = f.my_piecewise3(t92, t50, t51)
  t95 = jnp.exp(t93 / 0.3e1)
  t96 = t60 * t95
  t97 = jnp.exp(-t93)
  t98 = t93 ** 2
  t100 = t98 + 0.5e1 * t93 + 0.8e1
  t101 = t97 * t100
  t102 = 0.8e1 - t101
  t103 = 0.1e1 / t93
  t104 = t102 * t103
  t105 = 0.1e1 + t93
  t106 = t105 ** (0.1e1 / 0.3e1)
  t107 = 0.1e1 / t106
  t108 = t104 * t107
  t112 = f.my_piecewise3(t52, -t62 / 0.12e2 - t64 * t67 / 0.108e3 + t64 * t71 / 0.108e3 - 0.13e2 / 0.1620e4 * t64 * t75 + 0.67e2 / 0.9720e4 * t64 * t79 - 0.52e2 / 0.8505e4 * t64 * t83 + 0.1811e4 / 0.326592e6 * t64 * t65 * t74 * t70, -t91 * t96 * t108 / 0.36e2)
  t117 = t17 / t19
  t118 = jnp.pi * t55
  t120 = t118 * t65 * t50
  t123 = t36 * r0
  t125 = 0.1e1 / t19 / t123
  t133 = -0.24915333333333333333333333333333333333333333333333e0 * t25 * t38 - 0.39200000000000000000000000000000000000000000000000e0 * t35 * t125 - 0.34133333333333333333333333333333333333333333333333e-1 * t42 / t18 / t43 / t36
  t134 = t49 ** 2
  t135 = 0.1e1 / t134
  t136 = t133 * t135
  t137 = 0.1e1 + t50
  t138 = t137 ** (0.1e1 / 0.3e1)
  t139 = t138 ** 2
  t140 = 0.1e1 / t139
  t143 = jnp.exp(-0.2e1 / 0.3e1 * t50)
  t144 = 0.1e1 / t143
  t146 = t66 - 0.3e1 * t50 + 0.6e1
  t147 = 0.1e1 / t146
  t149 = t50 - 0.3e1
  t150 = t149 ** 2
  t151 = t144 * t147 * t150
  t152 = t136 * t140 * t151
  t155 = t118 * t67
  t158 = t118 * t71
  t161 = t118 * t75
  t164 = t118 * t79
  t167 = t118 * t83
  t171 = t53 ** 2
  t172 = t4 ** 2
  t173 = t171 * t172
  t174 = t173 * t136
  t175 = t140 * t144
  t176 = t147 * t150
  t177 = t175 * t176
  t178 = t174 * t177
  t180 = f.my_piecewise3(t92, t178 / 0.4e1, 0)
  t181 = t180 * t95
  t185 = t180 * t97
  t190 = 0.2e1 * t93 * t180 + 0.5e1 * t180
  t192 = t185 * t100 - t97 * t190
  t193 = t192 * t103
  t194 = t193 * t107
  t198 = t95 * t102
  t199 = 0.1e1 / t98
  t200 = t199 * t107
  t201 = t200 * t180
  t206 = 0.1e1 / t106 / t105
  t207 = t103 * t206
  t208 = t207 * t180
  t213 = f.my_piecewise3(t52, -0.4e1 / 0.27e2 * t120 * t152 + 0.2e1 / 0.9e1 * t155 * t152 - 0.104e3 / 0.405e3 * t158 * t152 + 0.67e2 / 0.243e3 * t161 * t152 - 0.832e3 / 0.2835e4 * t164 * t152 + 0.1811e4 / 0.5832e4 * t167 * t152, -t62 * t181 * t108 / 0.108e3 - t91 * t96 * t194 / 0.36e2 + t62 * t198 * t201 / 0.36e2 + t62 * t198 * t208 / 0.108e3)
  t217 = t17 * t18
  t219 = t172 * jnp.pi * t55
  t220 = t219 * t58
  t221 = t60 * t78
  t222 = t133 ** 2
  t223 = t221 * t222
  t224 = t220 * t223
  t225 = t134 ** 2
  t226 = 0.1e1 / t225
  t228 = 0.1e1 / t138 / t137
  t229 = t226 * t228
  t230 = t143 ** 2
  t231 = 0.1e1 / t230
  t232 = t229 * t231
  t233 = t146 ** 2
  t234 = 0.1e1 / t233
  t235 = t150 * t149
  t236 = t234 * t235
  t237 = t236 * t171
  t238 = t232 * t237
  t241 = t118 * t58
  t242 = t60 * t82
  t243 = t242 * t133
  t244 = t241 * t243
  t245 = t135 * t140
  t246 = t245 * t144
  t247 = t234 * t150
  t248 = t50 * t171
  t249 = t172 * t133
  t251 = t245 * t151
  t255 = t248 * t249 * t251 / 0.2e1 - 0.3e1 / 0.4e1 * t178
  t256 = t247 * t255
  t257 = t246 * t256
  t260 = t60 * t70
  t261 = t260 * t222
  t262 = t220 * t261
  t263 = t137 ** 2
  t265 = 0.1e1 / t138 / t263
  t266 = t226 * t265
  t267 = t266 * t231
  t268 = t150 ** 2
  t269 = t234 * t268
  t270 = t269 * t171
  t271 = t267 * t270
  t274 = t232 * t270
  t279 = t60 * t74
  t280 = t279 * t133
  t281 = t241 * t280
  t284 = t279 * t222
  t285 = t220 * t284
  t292 = t60 * t66
  t293 = t292 * t133
  t294 = t241 * t293
  t297 = t292 * t222
  t298 = t220 * t297
  t305 = t260 * t133
  t306 = t241 * t305
  t309 = t60 * t50
  t310 = t309 * t222
  t311 = t220 * t310
  t318 = t309 * t133
  t319 = t241 * t318
  t322 = -0.416e3 / 0.2835e4 * t224 * t238 - 0.1811e4 / 0.5832e4 * t244 * t257 + 0.52e2 / 0.1215e4 * t262 * t271 + 0.283e3 / 0.1215e4 * t262 * t274 - 0.52e2 / 0.405e3 * t262 * t238 - 0.67e2 / 0.243e3 * t281 * t257 - 0.67e2 / 0.1458e4 * t285 * t271 - 0.3275e4 / 0.10206e5 * t285 * t274 + 0.67e2 / 0.486e3 * t285 * t238 - 0.2e1 / 0.9e1 * t294 * t257 - t298 * t271 / 0.27e2 - 0.7e1 / 0.45e2 * t298 * t274 + t298 * t238 / 0.9e1 + 0.104e3 / 0.405e3 * t306 * t257 + 0.2e1 / 0.81e2 * t311 * t271 + 0.7e1 / 0.81e2 * t311 * t274 - 0.2e1 / 0.27e2 * t311 * t238 + 0.4e1 / 0.27e2 * t319 * t257
  t323 = t242 * t222
  t324 = t220 * t323
  t331 = t221 * t133
  t332 = t241 * t331
  t340 = 0.1e1 / t134 / t49
  t341 = t222 * t340
  t343 = t341 * t140 * t151
  t359 = 0.1e1 / t19 / t43
  t367 = 0.66440888888888888888888888888888888888888888888888e0 * t25 * t125 + 0.14373333333333333333333333333333333333333333333333e1 * t35 * t359 + 0.21617777777777777777777777777777777777777777777778e0 * t42 / t18 / t43 / t123
  t368 = t367 * t135
  t370 = t368 * t140 * t151
  t374 = t219 * t65 * t171
  t375 = t222 * t226
  t377 = t231 * t234
  t378 = t377 * t268
  t392 = -0.1811e4 / 0.34992e5 * t324 * t271 + 0.1811e4 / 0.34992e5 * t324 * t274 + 0.1811e4 / 0.11664e5 * t324 * t238 + 0.832e3 / 0.2835e4 * t332 * t257 + 0.416e3 / 0.8505e4 * t224 * t271 + 0.56729e5 / 0.136080e6 * t224 * t274 + 0.1664e4 / 0.2835e4 * t164 * t343 - 0.1811e4 / 0.2916e4 * t167 * t343 - 0.134e3 / 0.243e3 * t161 * t343 - 0.4e1 / 0.9e1 * t155 * t343 + 0.208e3 / 0.405e3 * t158 * t343 + 0.8e1 / 0.27e2 * t120 * t343 - 0.4e1 / 0.27e2 * t120 * t370 - t374 * t375 * t228 * t378 / 0.27e2 + 0.2e1 / 0.9e1 * t155 * t370 - 0.104e3 / 0.405e3 * t158 * t370 + 0.67e2 / 0.243e3 * t161 * t370 - 0.832e3 / 0.2835e4 * t164 * t370 + 0.1811e4 / 0.5832e4 * t167 * t370
  t394 = t173 * t368
  t395 = t394 * t177
  t397 = t173 * t341
  t398 = t397 * t177
  t400 = t4 * jnp.pi
  t401 = t53 * t400
  t402 = t401 * t375
  t403 = t265 * t231
  t404 = t403 * t269
  t405 = t402 * t404
  t407 = t228 * t231
  t408 = t407 * t269
  t411 = t175 * t256
  t412 = t174 * t411
  t414 = t407 * t236
  t415 = t402 * t414
  t418 = f.my_piecewise3(t92, t395 / 0.4e1 - t398 / 0.2e1 - 0.4e1 / 0.3e1 * t405 + 0.4e1 / 0.3e1 * t402 * t408 - t412 / 0.4e1 + 0.4e1 * t415, 0)
  t419 = t418 * t95
  t423 = t180 ** 2
  t424 = t423 * t95
  t431 = t102 * t199
  t432 = t431 * t107
  t436 = t104 * t206
  t440 = t418 * t97
  t442 = t423 * t97
  t450 = 0.2e1 * t93 * t418 + 0.5e1 * t418 + 0.2e1 * t423
  t452 = t440 * t100 - t442 * t100 + 0.2e1 * t185 * t190 - t97 * t450
  t454 = t452 * t103 * t107
  t458 = t95 * t192
  t466 = 0.1e1 / t98 / t93
  t468 = t466 * t107 * t423
  t473 = t199 * t206 * t423
  t477 = t200 * t418
  t481 = t105 ** 2
  t483 = 0.1e1 / t106 / t481
  t485 = t103 * t483 * t423
  t489 = t207 * t418
  t493 = -t62 * t419 * t108 / 0.108e3 - t62 * t424 * t108 / 0.324e3 - t62 * t181 * t194 / 0.54e2 + t62 * t424 * t432 / 0.54e2 + t62 * t424 * t436 / 0.162e3 - t91 * t96 * t454 / 0.36e2 + t62 * t458 * t201 / 0.18e2 + t62 * t458 * t208 / 0.54e2 - t62 * t198 * t468 / 0.18e2 - t62 * t198 * t473 / 0.54e2 + t62 * t198 * t477 / 0.36e2 - t62 * t198 * t485 / 0.81e2 + t62 * t198 * t489 / 0.108e3
  t494 = f.my_piecewise3(t52, t322 + t392, t493)
  t499 = f.my_piecewise3(t2, 0, -t6 * t22 * t112 / 0.24e2 + t6 * t117 * t213 / 0.8e1 + 0.3e1 / 0.16e2 * t6 * t217 * t494)
  t512 = 0.1e1 / t233 / t146
  t513 = t512 * t235
  t514 = t255 * t171
  t516 = t232 * t513 * t514
  t519 = t220 * t293
  t520 = t171 * t367
  t522 = t232 * t236 * t520
  t525 = t269 * t520
  t526 = t267 * t525
  t529 = t232 * t525
  t534 = t512 * t268
  t535 = t534 * t514
  t536 = t232 * t535
  t539 = t267 * t535
  t546 = t220 * t280
  t557 = t220 * t331
  t560 = t220 * t243
  t565 = 0.52e2 / 0.135e3 * t262 * t516 + t519 * t522 / 0.3e1 - t519 * t526 / 0.9e1 - 0.7e1 / 0.15e2 * t519 * t529 - 0.67e2 / 0.162e3 * t285 * t516 - 0.7e1 / 0.27e2 * t311 * t536 + t298 * t539 / 0.9e1 + 0.7e1 / 0.15e2 * t298 * t536 - t298 * t516 / 0.3e1 + 0.67e2 / 0.162e3 * t546 * t522 + 0.3275e4 / 0.3402e4 * t285 * t536 - 0.416e3 / 0.2835e4 * t224 * t539 - 0.56729e5 / 0.45360e5 * t224 * t536 + 0.416e3 / 0.945e3 * t224 * t516 + 0.416e3 / 0.2835e4 * t557 * t526 + 0.1811e4 / 0.3888e4 * t560 * t522 - 0.1811e4 / 0.3888e4 * t324 * t516
  t574 = t220 * t318
  t595 = t220 * t305
  t602 = 0.1811e4 / 0.11664e5 * t324 * t539 + 0.1811e4 / 0.11664e5 * t560 * t529 - 0.1811e4 / 0.11664e5 * t324 * t536 - 0.1811e4 / 0.11664e5 * t560 * t526 - 0.2e1 / 0.9e1 * t574 * t522 + 0.2e1 / 0.9e1 * t311 * t516 + 0.2e1 / 0.27e2 * t574 * t526 - 0.2e1 / 0.27e2 * t311 * t539 + 0.7e1 / 0.27e2 * t574 * t529 - 0.52e2 / 0.405e3 * t262 * t539 - 0.283e3 / 0.405e3 * t262 * t536 - 0.67e2 / 0.486e3 * t546 * t526 - 0.3275e4 / 0.3402e4 * t546 * t529 + 0.67e2 / 0.486e3 * t285 * t539 + 0.283e3 / 0.405e3 * t595 * t529 - 0.52e2 / 0.135e3 * t595 * t522 + 0.52e2 / 0.405e3 * t595 * t526
  t609 = t4 * t30 * t55
  t610 = t609 * t58
  t611 = t222 * t133
  t612 = t221 * t611
  t613 = t610 * t612
  t615 = 0.1e1 / t225 / t134
  t617 = 0.1e1 / t263 / t137
  t620 = 0.1e1 / t230 / t143
  t621 = t615 * t617 * t620
  t622 = t268 * t150
  t623 = t512 * t622
  t624 = t623 * t53
  t625 = t621 * t624
  t628 = t242 * t611
  t629 = t610 * t628
  t630 = t263 ** 2
  t631 = 0.1e1 / t630
  t634 = t615 * t631 * t620 * t624
  t639 = t268 * t149
  t640 = t512 * t639
  t641 = t640 * t53
  t642 = t621 * t641
  t645 = t309 * t611
  t646 = t610 * t645
  t647 = 0.1e1 / t263
  t649 = t615 * t647 * t620
  t650 = t649 * t624
  t653 = t292 * t611
  t654 = t610 * t653
  t657 = t340 * t140
  t658 = t657 * t144
  t660 = t658 * t176 * t367
  t663 = t279 * t611
  t664 = t220 * t663
  t666 = 0.1e1 / t225 / t49
  t669 = t666 * t265 * t231 * t270
  t673 = t666 * t228 * t231
  t674 = t673 * t270
  t678 = t658 * t256
  t682 = t255 ** 2
  t683 = t512 * t150 * t682
  t684 = t246 * t683
  t687 = t260 * t611
  t688 = t220 * t687
  t691 = t673 * t237
  t699 = 0.56729e5 / 0.45360e5 * t557 * t529 - 0.416e3 / 0.945e3 * t557 * t522 - 0.163531e6 / 0.25515e5 * t613 * t625 + 0.12677e5 / 0.13122e5 * t629 * t634 - 0.7244e4 / 0.6561e4 * t629 * t625 - 0.7244e4 / 0.2187e4 * t629 * t642 - 0.1904e4 / 0.1215e4 * t646 * t650 + 0.1592e4 / 0.405e3 * t654 * t650 - 0.134e3 / 0.81e2 * t281 * t660 + 0.67e2 / 0.243e3 * t664 * t669 + 0.3275e4 / 0.1701e4 * t664 * t674 + 0.268e3 / 0.243e3 * t241 * t284 * t678 + 0.134e3 / 0.243e3 * t281 * t684 - 0.566e3 / 0.405e3 * t688 * t674 + 0.104e3 / 0.135e3 * t688 * t691 - 0.104e3 / 0.405e3 * t688 * t669 + 0.1811e4 / 0.1458e4 * t241 * t323 * t678
  t702 = t220 * t612
  t709 = t220 * t628
  t713 = t649 * t534 * t53
  t730 = t50 * t53 * t400 * t222
  t750 = t248 * t172 * t367 * t251 / 0.2e1 - t248 * t172 * t222 * t657 * t151 - 0.8e1 / 0.3e1 * t730 * t266 * t378 + 0.8e1 / 0.3e1 * t730 * t229 * t378 - t248 * t249 * t135 * t411 / 0.2e1 + 0.8e1 * t730 * t229 * t377 * t235 - 0.3e1 / 0.4e1 * t395 + 0.3e1 / 0.2e1 * t398 + 0.4e1 * t405 + 0.3e1 / 0.4e1 * t412 - 0.12e2 * t415
  t751 = t247 * t750
  t752 = t246 * t751
  t755 = t610 * t687
  t770 = t60 * t171
  t781 = 0.1811e4 / 0.2916e4 * t244 * t684 - 0.56729e5 / 0.22680e5 * t702 * t674 + 0.832e3 / 0.945e3 * t702 * t691 - 0.832e3 / 0.2835e4 * t702 * t669 - 0.1811e4 / 0.1944e4 * t709 * t691 - 0.3328e4 / 0.945e3 * t613 * t713 - 0.1811e4 / 0.2916e4 * t241 * t242 * t367 * t257 - 0.1811e4 / 0.5832e4 * t244 * t752 - 0.2912e4 / 0.3645e4 * t755 * t634 - 0.12752e5 / 0.3645e4 * t755 * t625 + 0.3328e4 / 0.1215e4 * t755 * t642 - 0.304e3 / 0.243e3 * t646 * t625 + 0.56e2 / 0.81e2 * t654 * t634 + 0.928e3 / 0.405e3 * t654 * t625 - 0.64e2 / 0.27e2 * t654 * t642 - t220 * t770 * t133 * t232 * t269 * t367 / 0.9e1 + 0.8e1 / 0.9e1 * t319 * t660 + 0.208e3 / 0.135e3 * t306 * t660
  t784 = t610 * t663
  t801 = t534 * t255
  t807 = t649 * t641
  t830 = 0.74848e5 / 0.15309e5 * t784 * t625 - 0.3328e4 / 0.3645e4 * t613 * t634 + 0.26624e5 / 0.8505e4 * t613 * t642 - 0.16e2 / 0.9e1 * t646 * t713 + 0.8e1 / 0.27e2 * t241 * t309 * t367 * t257 + 0.4e1 / 0.27e2 * t319 * t752 + t220 * t770 * t222 * t232 * t801 / 0.9e1 + 0.3622e4 / 0.6561e4 * t629 * t650 + 0.7244e4 / 0.2187e4 * t629 * t807 + 0.163531e6 / 0.8505e4 * t613 * t807 + 0.1811e4 / 0.486e3 * t629 * t713 + 0.1664e4 / 0.2835e4 * t241 * t221 * t367 * t257 + 0.832e3 / 0.2835e4 * t332 * t752 - 0.928e3 / 0.135e3 * t654 * t807 + 0.304e3 / 0.81e2 * t646 * t807 + 0.8e1 / 0.3e1 * t654 * t713 + 0.208e3 / 0.405e3 * t241 * t260 * t367 * t257
  t869 = 0.104e3 / 0.405e3 * t306 * t752 - 0.112e3 / 0.243e3 * t646 * t634 + 0.128e3 / 0.81e2 * t646 * t642 + 0.1664e4 / 0.945e3 * t332 * t660 - 0.198608e6 / 0.25515e5 * t755 * t650 - 0.416e3 / 0.135e3 * t755 * t713 - 0.134e3 / 0.243e3 * t241 * t279 * t367 * t257 - 0.67e2 / 0.243e3 * t281 * t752 + 0.1876e4 / 0.2187e4 * t784 * t634 + 0.405761e6 / 0.30618e5 * t784 * t650 + 0.176843e6 / 0.25515e5 * t613 * t650 + 0.12752e5 / 0.1215e4 * t755 * t807 - 0.2144e4 / 0.729e3 * t784 * t642 - 0.74848e5 / 0.5103e4 * t784 * t807 + 0.268e3 / 0.81e2 * t784 * t713 - 0.4e1 / 0.9e1 * t241 * t292 * t367 * t257 - 0.2e1 / 0.9e1 * t294 * t752
  t882 = t220 * t645
  t897 = t220 * t653
  t911 = -0.3328e4 / 0.2835e4 * t241 * t223 * t678 - 0.1664e4 / 0.2835e4 * t332 * t684 - 0.1811e4 / 0.5832e4 * t709 * t674 - 0.8e1 / 0.27e2 * t319 * t684 + 0.1811e4 / 0.5832e4 * t709 * t669 + 0.4e1 / 0.9e1 * t882 * t691 - 0.16e2 / 0.27e2 * t241 * t310 * t678 - 0.4e1 / 0.27e2 * t882 * t669 - 0.14e2 / 0.27e2 * t882 * t674 - 0.416e3 / 0.405e3 * t241 * t261 * t678 - 0.208e3 / 0.405e3 * t306 * t684 + 0.14e2 / 0.15e2 * t897 * t674 - 0.2e1 / 0.3e1 * t897 * t691 + 0.2e1 / 0.9e1 * t897 * t669 + 0.8e1 / 0.9e1 * t241 * t297 * t678 + 0.4e1 / 0.9e1 * t294 * t684 - 0.67e2 / 0.81e2 * t664 * t691
  t922 = t43 ** 2
  t928 = (-0.24361659259259259259259259259259259259259259259259e1 * t25 * t359 - 0.67075555555555555555555555555555555555555555555554e1 * t35 / t19 / t44 - 0.15853037037037037037037037037037037037037037037037e1 * t42 / t18 / t922) * t135
  t930 = t928 * t140 * t151
  t935 = t611 * t226
  t937 = t935 * t140 * t151
  t951 = t609 * t65 * t53
  t952 = t611 * t615
  t954 = t620 * t512
  t955 = t954 * t622
  t959 = t952 * t647
  t967 = t611 * t666
  t980 = -0.4e1 / 0.3e1 * t294 * t660 - 0.1811e4 / 0.972e3 * t244 * t660 - 0.832e3 / 0.2835e4 * t164 * t930 + 0.1811e4 / 0.5832e4 * t167 * t930 + 0.4e1 / 0.3e1 * t155 * t937 + 0.1811e4 / 0.972e3 * t167 * t937 + 0.134e3 / 0.81e2 * t161 * t937 - 0.1664e4 / 0.945e3 * t164 * t937 - 0.8e1 / 0.9e1 * t120 * t937 - 0.208e3 / 0.135e3 * t158 * t937 + 0.16e2 / 0.27e2 * t951 * t952 * t617 * t955 + 0.8e1 / 0.27e2 * t951 * t959 * t955 - 0.16e2 / 0.9e1 * t951 * t959 * t954 * t639 + 0.2e1 / 0.9e1 * t374 * t967 * t228 * t378 - 0.4e1 / 0.27e2 * t120 * t930 + 0.2e1 / 0.9e1 * t155 * t930 - 0.104e3 / 0.405e3 * t158 * t930 + 0.67e2 / 0.243e3 * t161 * t930
  t984 = t419 * t102
  t988 = t418 * t180
  t1017 = t423 * t180
  t1018 = t1017 * t95
  t1041 = t401 * t367 * t226
  t1042 = t269 * t133
  t1066 = t397 * t411 + 0.4e1 * t402 * t403 * t801 - 0.3e1 / 0.2e1 * t173 * t367 * t340 * t175 * t176 * t133 - t394 * t411 / 0.2e1 - 0.4e1 * t1041 * t403 * t1042 + 0.4e1 * t1041 * t407 * t1042 + 0.12e2 * t1041 * t407 * t236 * t133 + 0.3e1 / 0.2e1 * t173 * t935 * t177 - 0.12e2 * t402 * t407 * t513 * t255 - 0.4e1 * t402 * t407 * t801 - t174 * t175 * t751 / 0.4e1
  t1073 = t401 * t967
  t1081 = t30 * t611 * t615
  t1086 = t617 * t620
  t1093 = t647 * t620
  t1103 = t174 * t175 * t683 / 0.2e1 + t173 * t928 * t177 / 0.4e1 + 0.8e1 * t1073 * t404 - 0.8e1 * t1073 * t408 - 0.24e2 * t1073 * t414 + 0.224e3 / 0.9e1 * t1081 * t631 * t620 * t623 - 0.256e3 / 0.9e1 * t1081 * t1086 * t623 - 0.256e3 / 0.3e1 * t1081 * t1086 * t640 + 0.128e3 / 0.9e1 * t1081 * t1093 * t623 + 0.256e3 / 0.3e1 * t1081 * t1093 * t640 + 0.96e2 * t1081 * t1093 * t534
  t1105 = f.my_piecewise3(t92, t1066 + t1103, 0)
  t1114 = t98 ** 2
  t1139 = t62 * t984 * t208 / 0.54e2 - t62 * t988 * t95 * t108 / 0.108e3 - t62 * t198 * t466 * t107 * t180 * t418 / 0.6e1 - t62 * t198 * t199 * t206 * t180 * t418 / 0.18e2 - t62 * t198 * t103 * t483 * t180 * t418 / 0.27e2 + t62 * t984 * t201 / 0.18e2 - t62 * t424 * t194 / 0.108e3 - t62 * t1018 * t108 / 0.972e3 - t62 * t181 * t454 / 0.36e2 - t62 * t419 * t194 / 0.36e2 - t62 * t1105 * t95 * t108 / 0.108e3 + t62 * t198 * t207 * t1105 / 0.108e3 + t62 * t198 / t1114 * t107 * t1017 / 0.6e1 + t62 * t198 * t466 * t206 * t1017 / 0.18e2 + t62 * t198 * t199 * t483 * t1017 / 0.27e2 + 0.7e1 / 0.243e3 * t62 * t198 * t103 / t106 / t481 / t105 * t1017
  t1187 = t95 * t452
  t1218 = t62 * t1018 * t432 / 0.108e3 + t62 * t1018 * t436 / 0.324e3 + t62 * t424 * t192 * t199 * t107 / 0.18e2 + t62 * t424 * t193 * t206 / 0.54e2 - t62 * t1018 * t102 * t466 * t107 / 0.18e2 - t62 * t1018 * t431 * t206 / 0.54e2 - t62 * t1018 * t104 * t483 / 0.81e2 + t62 * t198 * t200 * t1105 / 0.36e2 - t62 * t458 * t468 / 0.6e1 - t62 * t458 * t473 / 0.18e2 - t62 * t458 * t485 / 0.27e2 + t62 * t458 * t489 / 0.36e2 + t62 * t458 * t477 / 0.12e2 + t62 * t1187 * t201 / 0.12e2 + t62 * t1187 * t208 / 0.36e2 - t91 * t96 * (t1105 * t97 * t100 - 0.3e1 * t988 * t101 + 0.3e1 * t440 * t190 + t1017 * t97 * t100 - 0.3e1 * t442 * t190 + 0.3e1 * t185 * t450 - t97 * (0.2e1 * t93 * t1105 + 0.5e1 * t1105 + 0.6e1 * t988)) * t103 * t107 / 0.36e2
  t1220 = f.my_piecewise3(t52, t565 + t602 + t699 + t781 + t830 + t869 + t911 + t980, t1139 + t1218)
  t1225 = f.my_piecewise3(t2, 0, 0.5e1 / 0.72e2 * t6 * t17 * t38 * t112 - t6 * t22 * t213 / 0.8e1 + 0.3e1 / 0.16e2 * t6 * t117 * t494 + 0.3e1 / 0.16e2 * t6 * t217 * t1220)
  v3rho3_0_ = 0.2e1 * r0 * t1225 + 0.6e1 * t499

  res = {'v3rho3': v3rho3_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t6 ** 2
  t23 = 0.1e1 / t22
  t24 = t16 * t23
  t25 = t7 - t24
  t26 = f.my_piecewise5(t10, 0, t14, 0, t25)
  t29 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t26)
  t30 = t6 ** (0.1e1 / 0.3e1)
  t31 = t29 * t30
  t32 = r0 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t38 = 6 ** (0.1e1 / 0.3e1)
  t39 = t38 ** 2
  t40 = jnp.pi ** 2
  t41 = t40 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t44 = 0.3e1 / 0.10e2 * t39 * t42
  t45 = r0 ** 2
  t47 = 0.1e1 / t33 / t45
  t50 = s0 ** 2
  t51 = t45 ** 2
  t57 = 0.149492e0 * tau0 / t33 / r0 - t44 + 0.147e0 * s0 * t47 + 0.32e-2 * t50 / t32 / t51 / r0
  t58 = mbrxc_x(t57)
  t59 = DBL_EPSILON ** (0.1e1 / 0.4e1)
  t60 = t58 < t59
  t61 = 32 ** (0.1e1 / 0.3e1)
  t62 = t61 * t3
  t63 = t2 ** 2
  t65 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t66 = 0.1e1 / t65
  t67 = t63 * t66
  t68 = 4 ** (0.1e1 / 0.3e1)
  t70 = t62 * t67 * t68
  t71 = t70 / 0.12e2
  t72 = t62 * t63
  t73 = t66 * t68
  t74 = t58 ** 2
  t75 = t73 * t74
  t78 = t74 * t58
  t79 = t73 * t78
  t82 = t74 ** 2
  t83 = t73 * t82
  t86 = t82 * t58
  t87 = t73 * t86
  t90 = t82 * t74
  t91 = t73 * t90
  t99 = t62 * t67
  t100 = t59 < t58
  t101 = f.my_piecewise3(t100, t58, t59)
  t103 = jnp.exp(t101 / 0.3e1)
  t104 = t68 * t103
  t105 = jnp.exp(-t101)
  t106 = t101 ** 2
  t108 = t106 + 0.5e1 * t101 + 0.8e1
  t110 = -t105 * t108 + 0.8e1
  t111 = 0.1e1 / t101
  t112 = t110 * t111
  t113 = 0.1e1 + t101
  t114 = t113 ** (0.1e1 / 0.3e1)
  t115 = 0.1e1 / t114
  t116 = t112 * t115
  t120 = f.my_piecewise3(t60, -t71 - t72 * t75 / 0.108e3 + t72 * t79 / 0.108e3 - 0.13e2 / 0.1620e4 * t72 * t83 + 0.67e2 / 0.9720e4 * t72 * t87 - 0.52e2 / 0.8505e4 * t72 * t91 + 0.1811e4 / 0.326592e6 * t72 * t73 * t82 * t78, -t99 * t104 * t116 / 0.36e2)
  t124 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t125 = t124 * f.p.zeta_threshold
  t127 = f.my_piecewise3(t20, t125, t21 * t19)
  t128 = t30 ** 2
  t129 = 0.1e1 / t128
  t130 = t127 * t129
  t133 = t5 * t130 * t120 / 0.16e2
  t134 = t127 * t30
  t135 = jnp.pi * t63
  t137 = t135 * t73 * t58
  t140 = t45 * r0
  t142 = 0.1e1 / t33 / t140
  t150 = -0.24915333333333333333333333333333333333333333333333e0 * tau0 * t47 - 0.39200000000000000000000000000000000000000000000000e0 * s0 * t142 - 0.17066666666666666666666666666666666666666666666667e-1 * t50 / t32 / t51 / t45
  t151 = t57 ** 2
  t152 = 0.1e1 / t151
  t153 = t150 * t152
  t154 = 0.1e1 + t58
  t155 = t154 ** (0.1e1 / 0.3e1)
  t156 = t155 ** 2
  t157 = 0.1e1 / t156
  t160 = jnp.exp(-0.2e1 / 0.3e1 * t58)
  t161 = 0.1e1 / t160
  t163 = t74 - 0.3e1 * t58 + 0.6e1
  t164 = 0.1e1 / t163
  t166 = t58 - 0.3e1
  t167 = t166 ** 2
  t168 = t161 * t164 * t167
  t169 = t153 * t157 * t168
  t172 = t135 * t75
  t175 = t135 * t79
  t178 = t135 * t83
  t181 = t135 * t87
  t184 = t135 * t91
  t188 = t61 ** 2
  t189 = t3 ** 2
  t190 = t188 * t189
  t191 = t190 * t153
  t192 = t157 * t161
  t194 = t192 * t164 * t167
  t195 = t191 * t194
  t197 = f.my_piecewise3(t100, t195 / 0.4e1, 0)
  t198 = t197 * t103
  t202 = t197 * t105
  t207 = 0.2e1 * t101 * t197 + 0.5e1 * t197
  t209 = -t105 * t207 + t202 * t108
  t211 = t209 * t111 * t115
  t215 = t103 * t110
  t216 = 0.1e1 / t106
  t217 = t216 * t115
  t218 = t217 * t197
  t223 = 0.1e1 / t114 / t113
  t224 = t111 * t223
  t225 = t224 * t197
  t230 = f.my_piecewise3(t60, -0.4e1 / 0.27e2 * t137 * t169 + 0.2e1 / 0.9e1 * t172 * t169 - 0.104e3 / 0.405e3 * t175 * t169 + 0.67e2 / 0.243e3 * t178 * t169 - 0.832e3 / 0.2835e4 * t181 * t169 + 0.1811e4 / 0.5832e4 * t184 * t169, -t70 * t198 * t116 / 0.108e3 - t99 * t104 * t211 / 0.36e2 + t70 * t215 * t218 / 0.36e2 + t70 * t215 * t225 / 0.108e3)
  t235 = f.my_piecewise3(t1, 0, 0.3e1 / 0.16e2 * t5 * t31 * t120 + t133 + 0.3e1 / 0.16e2 * t5 * t134 * t230)
  t237 = r1 <= f.p.dens_threshold
  t238 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t239 = 0.1e1 + t238
  t240 = t239 <= f.p.zeta_threshold
  t241 = t239 ** (0.1e1 / 0.3e1)
  t243 = f.my_piecewise5(t14, 0, t10, 0, -t25)
  t246 = f.my_piecewise3(t240, 0, 0.4e1 / 0.3e1 * t241 * t243)
  t247 = t246 * t30
  t248 = r1 ** (0.1e1 / 0.3e1)
  t249 = t248 ** 2
  t254 = r1 ** 2
  t256 = 0.1e1 / t249 / t254
  t259 = s2 ** 2
  t260 = t254 ** 2
  t266 = 0.149492e0 * tau1 / t249 / r1 - t44 + 0.147e0 * s2 * t256 + 0.32e-2 * t259 / t248 / t260 / r1
  t267 = mbrxc_x(t266)
  t268 = t267 < t59
  t269 = t267 ** 2
  t270 = t73 * t269
  t273 = t269 * t267
  t274 = t73 * t273
  t277 = t269 ** 2
  t278 = t73 * t277
  t281 = t277 * t267
  t282 = t73 * t281
  t285 = t277 * t269
  t286 = t73 * t285
  t294 = t59 < t267
  t295 = f.my_piecewise3(t294, t267, t59)
  t297 = jnp.exp(t295 / 0.3e1)
  t298 = t68 * t297
  t299 = jnp.exp(-t295)
  t300 = t295 ** 2
  t302 = t300 + 0.5e1 * t295 + 0.8e1
  t304 = -t299 * t302 + 0.8e1
  t305 = 0.1e1 / t295
  t306 = t304 * t305
  t307 = 0.1e1 + t295
  t308 = t307 ** (0.1e1 / 0.3e1)
  t309 = 0.1e1 / t308
  t310 = t306 * t309
  t314 = f.my_piecewise3(t268, -t71 - t72 * t270 / 0.108e3 + t72 * t274 / 0.108e3 - 0.13e2 / 0.1620e4 * t72 * t278 + 0.67e2 / 0.9720e4 * t72 * t282 - 0.52e2 / 0.8505e4 * t72 * t286 + 0.1811e4 / 0.326592e6 * t72 * t73 * t277 * t273, -t99 * t298 * t310 / 0.36e2)
  t319 = f.my_piecewise3(t240, t125, t241 * t239)
  t320 = t319 * t129
  t323 = t5 * t320 * t314 / 0.16e2
  t325 = f.my_piecewise3(t237, 0, 0.3e1 / 0.16e2 * t5 * t247 * t314 + t323)
  t327 = t21 ** 2
  t328 = 0.1e1 / t327
  t329 = t26 ** 2
  t334 = t16 / t22 / t6
  t336 = -0.2e1 * t23 + 0.2e1 * t334
  t337 = f.my_piecewise5(t10, 0, t14, 0, t336)
  t341 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t328 * t329 + 0.4e1 / 0.3e1 * t21 * t337)
  t348 = t5 * t29 * t129 * t120
  t354 = 0.1e1 / t128 / t6
  t358 = t5 * t127 * t354 * t120 / 0.24e2
  t360 = t5 * t130 * t230
  t362 = t135 * t66
  t363 = t68 * t82
  t366 = t152 * t157
  t368 = t163 ** 2
  t369 = 0.1e1 / t368
  t379 = t369 * t167 * (t58 * t188 * t189 * t150 * t366 * t168 / 0.2e1 - 0.3e1 / 0.4e1 * t195)
  t380 = t366 * t161 * t379
  t384 = t189 * jnp.pi * t63
  t385 = t384 * t66
  t386 = t150 ** 2
  t388 = t385 * t363 * t386
  t389 = t151 ** 2
  t390 = 0.1e1 / t389
  t391 = t154 ** 2
  t393 = 0.1e1 / t155 / t391
  t395 = t160 ** 2
  t396 = 0.1e1 / t395
  t398 = t167 ** 2
  t399 = t369 * t398
  t400 = t399 * t188
  t401 = t390 * t393 * t396 * t400
  t405 = 0.1e1 / t155 / t154
  t407 = t390 * t405 * t396
  t408 = t407 * t400
  t411 = t68 * t58
  t413 = t385 * t411 * t386
  t415 = t369 * t167 * t166
  t417 = t407 * t415 * t188
  t420 = t68 * t74
  t426 = t385 * t420 * t386
  t433 = t68 * t90
  t447 = t385 * t433 * t386
  t454 = t68 * t86
  t460 = t385 * t454 * t386
  t465 = -0.67e2 / 0.243e3 * t362 * t363 * t150 * t380 - 0.67e2 / 0.1458e4 * t388 * t401 - 0.3275e4 / 0.10206e5 * t388 * t408 - 0.2e1 / 0.27e2 * t413 * t417 - 0.2e1 / 0.9e1 * t362 * t420 * t150 * t380 - t426 * t401 / 0.27e2 - 0.7e1 / 0.45e2 * t426 * t408 + t426 * t417 / 0.9e1 - 0.1811e4 / 0.5832e4 * t362 * t433 * t150 * t380 + 0.4e1 / 0.27e2 * t362 * t411 * t150 * t380 + 0.2e1 / 0.81e2 * t413 * t401 + 0.7e1 / 0.81e2 * t413 * t408 - 0.1811e4 / 0.34992e5 * t447 * t401 + 0.1811e4 / 0.34992e5 * t447 * t408 + 0.1811e4 / 0.11664e5 * t447 * t417 + 0.832e3 / 0.2835e4 * t362 * t454 * t150 * t380 + 0.416e3 / 0.8505e4 * t460 * t401 + 0.56729e5 / 0.136080e6 * t460 * t408
  t468 = t68 * t78
  t474 = t385 * t468 * t386
  t495 = (0.66440888888888888888888888888888888888888888888888e0 * tau0 * t142 + 0.14373333333333333333333333333333333333333333333333e1 * s0 / t33 / t51 + 0.10808888888888888888888888888888888888888888888889e0 * t50 / t32 / t51 / t140) * t152
  t497 = t495 * t157 * t168
  t508 = t386 / t151 / t57
  t510 = t508 * t157 * t168
  t528 = t384 * t73 * t188
  t529 = t386 * t390
  t536 = -0.416e3 / 0.2835e4 * t460 * t417 + 0.104e3 / 0.405e3 * t362 * t468 * t150 * t380 + 0.52e2 / 0.1215e4 * t474 * t401 + 0.283e3 / 0.1215e4 * t474 * t408 - 0.52e2 / 0.405e3 * t474 * t417 + 0.67e2 / 0.486e3 * t388 * t417 + 0.2e1 / 0.9e1 * t172 * t497 - 0.104e3 / 0.405e3 * t175 * t497 + 0.67e2 / 0.243e3 * t178 * t497 - 0.832e3 / 0.2835e4 * t181 * t497 + 0.8e1 / 0.27e2 * t137 * t510 + 0.1664e4 / 0.2835e4 * t181 * t510 - 0.1811e4 / 0.2916e4 * t184 * t510 - 0.134e3 / 0.243e3 * t178 * t510 - 0.4e1 / 0.9e1 * t172 * t510 + 0.208e3 / 0.405e3 * t175 * t510 + 0.1811e4 / 0.5832e4 * t184 * t497 - 0.4e1 / 0.27e2 * t137 * t497 - t528 * t529 * t405 * t396 * t369 * t398 / 0.27e2
  t545 = t61 * t3 * jnp.pi
  t546 = t545 * t529
  t551 = t405 * t396
  t562 = f.my_piecewise3(t100, t190 * t495 * t194 / 0.4e1 - t190 * t508 * t194 / 0.2e1 - 0.4e1 / 0.3e1 * t546 * t393 * t396 * t399 + 0.4e1 / 0.3e1 * t546 * t551 * t399 - t191 * t192 * t379 / 0.4e1 + 0.4e1 * t546 * t551 * t415, 0)
  t567 = t197 ** 2
  t568 = t567 * t103
  t602 = t103 * t209
  t625 = t113 ** 2
  t637 = -t70 * t562 * t103 * t116 / 0.108e3 - t70 * t568 * t116 / 0.324e3 - t70 * t198 * t211 / 0.54e2 + t70 * t568 * t110 * t216 * t115 / 0.54e2 + t70 * t568 * t112 * t223 / 0.162e3 - t99 * t104 * (t562 * t105 * t108 - t567 * t105 * t108 + 0.2e1 * t202 * t207 - t105 * (0.2e1 * t101 * t562 + 0.5e1 * t562 + 0.2e1 * t567)) * t111 * t115 / 0.36e2 + t70 * t602 * t218 / 0.18e2 + t70 * t602 * t225 / 0.54e2 - t70 * t215 / t106 / t101 * t115 * t567 / 0.18e2 - t70 * t215 * t216 * t223 * t567 / 0.54e2 + t70 * t215 * t217 * t562 / 0.36e2 - t70 * t215 * t111 / t114 / t625 * t567 / 0.81e2 + t70 * t215 * t224 * t562 / 0.108e3
  t638 = f.my_piecewise3(t60, t465 + t536, t637)
  t643 = f.my_piecewise3(t1, 0, 0.3e1 / 0.16e2 * t5 * t341 * t30 * t120 + t348 / 0.8e1 + 0.3e1 / 0.8e1 * t5 * t31 * t230 - t358 + t360 / 0.8e1 + 0.3e1 / 0.16e2 * t5 * t134 * t638)
  t644 = t241 ** 2
  t645 = 0.1e1 / t644
  t646 = t243 ** 2
  t650 = f.my_piecewise5(t14, 0, t10, 0, -t336)
  t654 = f.my_piecewise3(t240, 0, 0.4e1 / 0.9e1 * t645 * t646 + 0.4e1 / 0.3e1 * t241 * t650)
  t661 = t5 * t246 * t129 * t314
  t666 = t5 * t319 * t354 * t314 / 0.24e2
  t668 = f.my_piecewise3(t237, 0, 0.3e1 / 0.16e2 * t5 * t654 * t30 * t314 + t661 / 0.8e1 - t666)
  d11 = 0.2e1 * t235 + 0.2e1 * t325 + t6 * (t643 + t668)
  t671 = -t7 - t24
  t672 = f.my_piecewise5(t10, 0, t14, 0, t671)
  t675 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t672)
  t676 = t675 * t30
  t681 = f.my_piecewise3(t1, 0, 0.3e1 / 0.16e2 * t5 * t676 * t120 + t133)
  t683 = f.my_piecewise5(t14, 0, t10, 0, -t671)
  t686 = f.my_piecewise3(t240, 0, 0.4e1 / 0.3e1 * t241 * t683)
  t687 = t686 * t30
  t691 = t319 * t30
  t693 = t135 * t73 * t267
  t696 = t254 * r1
  t698 = 0.1e1 / t249 / t696
  t706 = -0.24915333333333333333333333333333333333333333333333e0 * tau1 * t256 - 0.39200000000000000000000000000000000000000000000000e0 * s2 * t698 - 0.17066666666666666666666666666666666666666666666667e-1 * t259 / t248 / t260 / t254
  t707 = t266 ** 2
  t708 = 0.1e1 / t707
  t709 = t706 * t708
  t710 = 0.1e1 + t267
  t711 = t710 ** (0.1e1 / 0.3e1)
  t712 = t711 ** 2
  t713 = 0.1e1 / t712
  t716 = jnp.exp(-0.2e1 / 0.3e1 * t267)
  t717 = 0.1e1 / t716
  t719 = t269 - 0.3e1 * t267 + 0.6e1
  t720 = 0.1e1 / t719
  t722 = t267 - 0.3e1
  t723 = t722 ** 2
  t724 = t717 * t720 * t723
  t725 = t709 * t713 * t724
  t728 = t135 * t270
  t731 = t135 * t274
  t734 = t135 * t278
  t737 = t135 * t282
  t740 = t135 * t286
  t744 = t190 * t709
  t745 = t713 * t717
  t747 = t745 * t720 * t723
  t748 = t744 * t747
  t750 = f.my_piecewise3(t294, t748 / 0.4e1, 0)
  t751 = t750 * t297
  t755 = t750 * t299
  t760 = 0.2e1 * t295 * t750 + 0.5e1 * t750
  t762 = -t299 * t760 + t755 * t302
  t764 = t762 * t305 * t309
  t768 = t297 * t304
  t769 = 0.1e1 / t300
  t770 = t769 * t309
  t771 = t770 * t750
  t776 = 0.1e1 / t308 / t307
  t777 = t305 * t776
  t778 = t777 * t750
  t783 = f.my_piecewise3(t268, -0.4e1 / 0.27e2 * t693 * t725 + 0.2e1 / 0.9e1 * t728 * t725 - 0.104e3 / 0.405e3 * t731 * t725 + 0.67e2 / 0.243e3 * t734 * t725 - 0.832e3 / 0.2835e4 * t737 * t725 + 0.1811e4 / 0.5832e4 * t740 * t725, -t70 * t751 * t310 / 0.108e3 - t99 * t298 * t764 / 0.36e2 + t70 * t768 * t771 / 0.36e2 + t70 * t768 * t778 / 0.108e3)
  t788 = f.my_piecewise3(t237, 0, 0.3e1 / 0.16e2 * t5 * t687 * t314 + t323 + 0.3e1 / 0.16e2 * t5 * t691 * t783)
  t792 = 0.2e1 * t334
  t793 = f.my_piecewise5(t10, 0, t14, 0, t792)
  t797 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t328 * t672 * t26 + 0.4e1 / 0.3e1 * t21 * t793)
  t804 = t5 * t675 * t129 * t120
  t812 = f.my_piecewise3(t1, 0, 0.3e1 / 0.16e2 * t5 * t797 * t30 * t120 + t804 / 0.16e2 + 0.3e1 / 0.16e2 * t5 * t676 * t230 + t348 / 0.16e2 - t358 + t360 / 0.16e2)
  t816 = f.my_piecewise5(t14, 0, t10, 0, -t792)
  t820 = f.my_piecewise3(t240, 0, 0.4e1 / 0.9e1 * t645 * t683 * t243 + 0.4e1 / 0.3e1 * t241 * t816)
  t827 = t5 * t686 * t129 * t314
  t834 = t5 * t320 * t783
  t837 = f.my_piecewise3(t237, 0, 0.3e1 / 0.16e2 * t5 * t820 * t30 * t314 + t827 / 0.16e2 + t661 / 0.16e2 - t666 + 0.3e1 / 0.16e2 * t5 * t247 * t783 + t834 / 0.16e2)
  d12 = t235 + t325 + t681 + t788 + t6 * (t812 + t837)
  t842 = t672 ** 2
  t846 = 0.2e1 * t23 + 0.2e1 * t334
  t847 = f.my_piecewise5(t10, 0, t14, 0, t846)
  t851 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t328 * t842 + 0.4e1 / 0.3e1 * t21 * t847)
  t858 = f.my_piecewise3(t1, 0, 0.3e1 / 0.16e2 * t5 * t851 * t30 * t120 + t804 / 0.8e1 - t358)
  t859 = t683 ** 2
  t863 = f.my_piecewise5(t14, 0, t10, 0, -t846)
  t867 = f.my_piecewise3(t240, 0, 0.4e1 / 0.9e1 * t645 * t859 + 0.4e1 / 0.3e1 * t241 * t863)
  t877 = t68 * t269
  t878 = t706 ** 2
  t880 = t385 * t877 * t878
  t881 = t707 ** 2
  t882 = 0.1e1 / t881
  t884 = 0.1e1 / t711 / t710
  t886 = t716 ** 2
  t887 = 0.1e1 / t886
  t888 = t882 * t884 * t887
  t889 = t719 ** 2
  t890 = 0.1e1 / t889
  t892 = t890 * t723 * t722
  t894 = t888 * t892 * t188
  t897 = t68 * t273
  t900 = t708 * t713
  t911 = t890 * t723 * (t267 * t188 * t189 * t706 * t900 * t724 / 0.2e1 - 0.3e1 / 0.4e1 * t748)
  t912 = t900 * t717 * t911
  t915 = t68 * t267
  t921 = t385 * t915 * t878
  t922 = t710 ** 2
  t924 = 0.1e1 / t711 / t922
  t927 = t723 ** 2
  t928 = t890 * t927
  t929 = t928 * t188
  t930 = t882 * t924 * t887 * t929
  t933 = t888 * t929
  t938 = t68 * t285
  t940 = t385 * t938 * t878
  t947 = t68 * t281
  t953 = t385 * t947 * t878
  t965 = t385 * t897 * t878
  t972 = t68 * t277
  t977 = t880 * t894 / 0.9e1 + 0.104e3 / 0.405e3 * t362 * t897 * t706 * t912 + 0.4e1 / 0.27e2 * t362 * t915 * t706 * t912 + 0.2e1 / 0.81e2 * t921 * t930 + 0.7e1 / 0.81e2 * t921 * t933 - 0.2e1 / 0.27e2 * t921 * t894 - 0.1811e4 / 0.34992e5 * t940 * t930 + 0.1811e4 / 0.34992e5 * t940 * t933 + 0.1811e4 / 0.11664e5 * t940 * t894 + 0.832e3 / 0.2835e4 * t362 * t947 * t706 * t912 + 0.416e3 / 0.8505e4 * t953 * t930 + 0.56729e5 / 0.136080e6 * t953 * t933 - 0.416e3 / 0.2835e4 * t953 * t894 - 0.1811e4 / 0.5832e4 * t362 * t938 * t706 * t912 + 0.52e2 / 0.1215e4 * t965 * t930 + 0.283e3 / 0.1215e4 * t965 * t933 - 0.52e2 / 0.405e3 * t965 * t894 - 0.67e2 / 0.243e3 * t362 * t972 * t706 * t912
  t979 = t385 * t972 * t878
  t996 = t878 / t707 / t266
  t998 = t996 * t713 * t724
  t1023 = (0.66440888888888888888888888888888888888888888888888e0 * tau1 * t698 + 0.14373333333333333333333333333333333333333333333333e1 * s2 / t249 / t260 + 0.10808888888888888888888888888888888888888888888889e0 * t259 / t248 / t260 / t696) * t708
  t1025 = t1023 * t713 * t724
  t1034 = t878 * t882
  t1045 = -0.67e2 / 0.1458e4 * t979 * t930 - 0.3275e4 / 0.10206e5 * t979 * t933 + 0.67e2 / 0.486e3 * t979 * t894 - 0.2e1 / 0.9e1 * t362 * t877 * t706 * t912 - t880 * t930 / 0.27e2 - 0.7e1 / 0.45e2 * t880 * t933 + 0.1664e4 / 0.2835e4 * t737 * t998 - 0.1811e4 / 0.2916e4 * t740 * t998 - 0.134e3 / 0.243e3 * t734 * t998 - 0.4e1 / 0.9e1 * t728 * t998 + 0.208e3 / 0.405e3 * t731 * t998 + 0.8e1 / 0.27e2 * t693 * t998 + 0.67e2 / 0.243e3 * t734 * t1025 - 0.832e3 / 0.2835e4 * t737 * t1025 + 0.1811e4 / 0.5832e4 * t740 * t1025 - 0.4e1 / 0.27e2 * t693 * t1025 - t528 * t1034 * t884 * t887 * t890 * t927 / 0.27e2 + 0.2e1 / 0.9e1 * t728 * t1025 - 0.104e3 / 0.405e3 * t731 * t1025
  t1053 = t545 * t1034
  t1058 = t884 * t887
  t1069 = f.my_piecewise3(t294, t190 * t1023 * t747 / 0.4e1 - t190 * t996 * t747 / 0.2e1 - 0.4e1 / 0.3e1 * t1053 * t924 * t887 * t928 + 0.4e1 / 0.3e1 * t1053 * t1058 * t928 - t744 * t745 * t911 / 0.4e1 + 0.4e1 * t1053 * t1058 * t892, 0)
  t1074 = t750 ** 2
  t1075 = t1074 * t297
  t1109 = t297 * t762
  t1132 = t307 ** 2
  t1144 = -t70 * t1069 * t297 * t310 / 0.108e3 - t70 * t1075 * t310 / 0.324e3 - t70 * t751 * t764 / 0.54e2 + t70 * t1075 * t304 * t769 * t309 / 0.54e2 + t70 * t1075 * t306 * t776 / 0.162e3 - t99 * t298 * (t1069 * t299 * t302 - t1074 * t299 * t302 + 0.2e1 * t755 * t760 - t299 * (0.2e1 * t295 * t1069 + 0.5e1 * t1069 + 0.2e1 * t1074)) * t305 * t309 / 0.36e2 + t70 * t1109 * t771 / 0.18e2 + t70 * t1109 * t778 / 0.54e2 - t70 * t768 / t300 / t295 * t309 * t1074 / 0.18e2 - t70 * t768 * t769 * t776 * t1074 / 0.54e2 + t70 * t768 * t770 * t1069 / 0.36e2 - t70 * t768 * t305 / t308 / t1132 * t1074 / 0.81e2 + t70 * t768 * t777 * t1069 / 0.108e3
  t1145 = f.my_piecewise3(t268, t977 + t1045, t1144)
  t1150 = f.my_piecewise3(t237, 0, 0.3e1 / 0.16e2 * t5 * t867 * t30 * t314 + t827 / 0.8e1 + 0.3e1 / 0.8e1 * t5 * t687 * t783 - t666 + t834 / 0.8e1 + 0.3e1 / 0.16e2 * t5 * t691 * t1145)
  d22 = 0.2e1 * t681 + 0.2e1 * t788 + t6 * (t858 + t1150)
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 <= f.p.dens_threshold
  t2 = 3 ** (0.1e1 / 0.3e1)
  t3 = jnp.pi ** (0.1e1 / 0.3e1)
  t5 = t2 / t3
  t6 = r0 + r1
  t7 = 0.1e1 / t6
  t10 = 0.2e1 * r0 * t7 <= f.p.zeta_threshold
  t11 = f.p.zeta_threshold - 0.1e1
  t14 = 0.2e1 * r1 * t7 <= f.p.zeta_threshold
  t15 = -t11
  t16 = r0 - r1
  t17 = t16 * t7
  t18 = f.my_piecewise5(t10, t11, t14, t15, t17)
  t19 = 0.1e1 + t18
  t20 = t19 <= f.p.zeta_threshold
  t21 = t19 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t23 = 0.1e1 / t22
  t24 = t6 ** 2
  t25 = 0.1e1 / t24
  t27 = -t16 * t25 + t7
  t28 = f.my_piecewise5(t10, 0, t14, 0, t27)
  t29 = t28 ** 2
  t33 = 0.1e1 / t24 / t6
  t36 = 0.2e1 * t16 * t33 - 0.2e1 * t25
  t37 = f.my_piecewise5(t10, 0, t14, 0, t36)
  t41 = f.my_piecewise3(t20, 0, 0.4e1 / 0.9e1 * t23 * t29 + 0.4e1 / 0.3e1 * t21 * t37)
  t42 = t6 ** (0.1e1 / 0.3e1)
  t43 = t41 * t42
  t44 = r0 ** (0.1e1 / 0.3e1)
  t45 = t44 ** 2
  t50 = 6 ** (0.1e1 / 0.3e1)
  t51 = t50 ** 2
  t52 = jnp.pi ** 2
  t53 = t52 ** (0.1e1 / 0.3e1)
  t54 = t53 ** 2
  t56 = 0.3e1 / 0.10e2 * t51 * t54
  t57 = r0 ** 2
  t59 = 0.1e1 / t45 / t57
  t62 = s0 ** 2
  t63 = t57 ** 2
  t64 = t63 * r0
  t69 = 0.149492e0 * tau0 / t45 / r0 - t56 + 0.147e0 * s0 * t59 + 0.32e-2 * t62 / t44 / t64
  t70 = mbrxc_x(t69)
  t71 = DBL_EPSILON ** (0.1e1 / 0.4e1)
  t72 = t70 < t71
  t73 = 32 ** (0.1e1 / 0.3e1)
  t74 = t73 * t3
  t75 = t2 ** 2
  t77 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t78 = 0.1e1 / t77
  t79 = t75 * t78
  t80 = 4 ** (0.1e1 / 0.3e1)
  t82 = t74 * t79 * t80
  t83 = t82 / 0.12e2
  t84 = t74 * t75
  t85 = t78 * t80
  t86 = t70 ** 2
  t87 = t85 * t86
  t90 = t86 * t70
  t91 = t85 * t90
  t94 = t86 ** 2
  t95 = t85 * t94
  t98 = t94 * t70
  t99 = t85 * t98
  t102 = t94 * t86
  t103 = t85 * t102
  t111 = t74 * t79
  t112 = t71 < t70
  t113 = f.my_piecewise3(t112, t70, t71)
  t115 = jnp.exp(t113 / 0.3e1)
  t116 = t80 * t115
  t117 = jnp.exp(-t113)
  t118 = t113 ** 2
  t120 = t118 + 0.5e1 * t113 + 0.8e1
  t121 = t117 * t120
  t122 = 0.8e1 - t121
  t123 = 0.1e1 / t113
  t124 = t122 * t123
  t125 = 0.1e1 + t113
  t126 = t125 ** (0.1e1 / 0.3e1)
  t127 = 0.1e1 / t126
  t128 = t124 * t127
  t132 = f.my_piecewise3(t72, -t83 - t84 * t87 / 0.108e3 + t84 * t91 / 0.108e3 - 0.13e2 / 0.1620e4 * t84 * t95 + 0.67e2 / 0.9720e4 * t84 * t99 - 0.52e2 / 0.8505e4 * t84 * t103 + 0.1811e4 / 0.326592e6 * t84 * t85 * t94 * t90, -t111 * t116 * t128 / 0.36e2)
  t138 = f.my_piecewise3(t20, 0, 0.4e1 / 0.3e1 * t21 * t28)
  t139 = t42 ** 2
  t140 = 0.1e1 / t139
  t141 = t138 * t140
  t145 = t138 * t42
  t146 = jnp.pi * t75
  t148 = t146 * t85 * t70
  t151 = t57 * r0
  t153 = 0.1e1 / t45 / t151
  t161 = -0.24915333333333333333333333333333333333333333333333e0 * tau0 * t59 - 0.39200000000000000000000000000000000000000000000000e0 * s0 * t153 - 0.17066666666666666666666666666666666666666666666667e-1 * t62 / t44 / t63 / t57
  t162 = t69 ** 2
  t163 = 0.1e1 / t162
  t164 = t161 * t163
  t165 = 0.1e1 + t70
  t166 = t165 ** (0.1e1 / 0.3e1)
  t167 = t166 ** 2
  t168 = 0.1e1 / t167
  t171 = jnp.exp(-0.2e1 / 0.3e1 * t70)
  t172 = 0.1e1 / t171
  t174 = t86 - 0.3e1 * t70 + 0.6e1
  t175 = 0.1e1 / t174
  t177 = t70 - 0.3e1
  t178 = t177 ** 2
  t179 = t172 * t175 * t178
  t180 = t164 * t168 * t179
  t183 = t146 * t87
  t186 = t146 * t91
  t189 = t146 * t95
  t192 = t146 * t99
  t195 = t146 * t103
  t199 = t73 ** 2
  t200 = t3 ** 2
  t201 = t199 * t200
  t202 = t201 * t164
  t203 = t168 * t172
  t204 = t175 * t178
  t205 = t203 * t204
  t206 = t202 * t205
  t208 = f.my_piecewise3(t112, t206 / 0.4e1, 0)
  t209 = t208 * t115
  t213 = t208 * t117
  t218 = 0.2e1 * t113 * t208 + 0.5e1 * t208
  t220 = -t117 * t218 + t213 * t120
  t221 = t220 * t123
  t222 = t221 * t127
  t226 = t115 * t122
  t227 = 0.1e1 / t118
  t228 = t227 * t127
  t229 = t228 * t208
  t234 = 0.1e1 / t126 / t125
  t235 = t123 * t234
  t236 = t235 * t208
  t241 = f.my_piecewise3(t72, -0.4e1 / 0.27e2 * t148 * t180 + 0.2e1 / 0.9e1 * t183 * t180 - 0.104e3 / 0.405e3 * t186 * t180 + 0.67e2 / 0.243e3 * t189 * t180 - 0.832e3 / 0.2835e4 * t192 * t180 + 0.1811e4 / 0.5832e4 * t195 * t180, -t82 * t209 * t128 / 0.108e3 - t111 * t116 * t222 / 0.36e2 + t82 * t226 * t229 / 0.36e2 + t82 * t226 * t236 / 0.108e3)
  t245 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t246 = t245 * f.p.zeta_threshold
  t248 = f.my_piecewise3(t20, t246, t21 * t19)
  t250 = 0.1e1 / t139 / t6
  t251 = t248 * t250
  t255 = t248 * t140
  t259 = t248 * t42
  t261 = t200 * jnp.pi * t75
  t262 = t261 * t78
  t263 = t80 * t98
  t264 = t161 ** 2
  t265 = t263 * t264
  t266 = t262 * t265
  t267 = t162 ** 2
  t268 = 0.1e1 / t267
  t269 = t165 ** 2
  t271 = 0.1e1 / t166 / t269
  t272 = t268 * t271
  t273 = t171 ** 2
  t274 = 0.1e1 / t273
  t275 = t272 * t274
  t276 = t174 ** 2
  t277 = 0.1e1 / t276
  t278 = t178 ** 2
  t279 = t277 * t278
  t280 = t279 * t199
  t281 = t275 * t280
  t285 = 0.1e1 / t166 / t165
  t286 = t268 * t285
  t287 = t286 * t274
  t288 = t287 * t280
  t291 = t178 * t177
  t292 = t277 * t291
  t293 = t292 * t199
  t294 = t287 * t293
  t297 = t146 * t78
  t298 = t80 * t90
  t299 = t298 * t161
  t300 = t297 * t299
  t301 = t163 * t168
  t302 = t301 * t172
  t303 = t277 * t178
  t304 = t70 * t199
  t305 = t200 * t161
  t307 = t301 * t179
  t311 = t304 * t305 * t307 / 0.2e1 - 0.3e1 / 0.4e1 * t206
  t312 = t303 * t311
  t313 = t302 * t312
  t316 = t298 * t264
  t317 = t262 * t316
  t324 = t80 * t94
  t325 = t324 * t161
  t326 = t297 * t325
  t329 = t324 * t264
  t330 = t262 * t329
  t337 = t80 * t70
  t338 = t337 * t264
  t339 = t262 * t338
  t342 = t80 * t86
  t343 = t342 * t161
  t344 = t297 * t343
  t347 = t342 * t264
  t348 = t262 * t347
  t355 = t80 * t102
  t356 = t355 * t161
  t357 = t297 * t356
  t360 = t337 * t161
  t361 = t297 * t360
  t364 = 0.416e3 / 0.8505e4 * t266 * t281 + 0.56729e5 / 0.136080e6 * t266 * t288 - 0.416e3 / 0.2835e4 * t266 * t294 + 0.104e3 / 0.405e3 * t300 * t313 + 0.52e2 / 0.1215e4 * t317 * t281 + 0.283e3 / 0.1215e4 * t317 * t288 - 0.52e2 / 0.405e3 * t317 * t294 - 0.67e2 / 0.243e3 * t326 * t313 - 0.67e2 / 0.1458e4 * t330 * t281 - 0.3275e4 / 0.10206e5 * t330 * t288 + 0.67e2 / 0.486e3 * t330 * t294 - 0.2e1 / 0.27e2 * t339 * t294 - 0.2e1 / 0.9e1 * t344 * t313 - t348 * t281 / 0.27e2 - 0.7e1 / 0.45e2 * t348 * t288 + t348 * t294 / 0.9e1 - 0.1811e4 / 0.5832e4 * t357 * t313 + 0.4e1 / 0.27e2 * t361 * t313
  t369 = t355 * t264
  t370 = t262 * t369
  t377 = t263 * t161
  t378 = t297 * t377
  t382 = 0.1e1 / t162 / t69
  t383 = t264 * t382
  t385 = t383 * t168 * t179
  t399 = 0.1e1 / t45 / t63
  t407 = 0.66440888888888888888888888888888888888888888888888e0 * tau0 * t153 + 0.14373333333333333333333333333333333333333333333333e1 * s0 * t399 + 0.10808888888888888888888888888888888888888888888889e0 * t62 / t44 / t63 / t151
  t408 = t407 * t163
  t410 = t408 * t168 * t179
  t416 = t261 * t85 * t199
  t417 = t264 * t268
  t419 = t274 * t277
  t420 = t419 * t278
  t434 = 0.2e1 / 0.81e2 * t339 * t281 + 0.7e1 / 0.81e2 * t339 * t288 - 0.1811e4 / 0.34992e5 * t370 * t281 + 0.1811e4 / 0.34992e5 * t370 * t288 + 0.1811e4 / 0.11664e5 * t370 * t294 + 0.832e3 / 0.2835e4 * t378 * t313 + 0.1664e4 / 0.2835e4 * t192 * t385 - 0.1811e4 / 0.2916e4 * t195 * t385 - 0.134e3 / 0.243e3 * t189 * t385 - 0.4e1 / 0.9e1 * t183 * t385 + 0.208e3 / 0.405e3 * t186 * t385 + 0.1811e4 / 0.5832e4 * t195 * t410 - 0.4e1 / 0.27e2 * t148 * t410 - t416 * t417 * t285 * t420 / 0.27e2 + 0.2e1 / 0.9e1 * t183 * t410 - 0.104e3 / 0.405e3 * t186 * t410 + 0.67e2 / 0.243e3 * t189 * t410 - 0.832e3 / 0.2835e4 * t192 * t410 + 0.8e1 / 0.27e2 * t148 * t385
  t436 = t201 * t408
  t437 = t436 * t205
  t439 = t201 * t383
  t440 = t439 * t205
  t442 = t3 * jnp.pi
  t443 = t73 * t442
  t444 = t443 * t417
  t445 = t271 * t274
  t446 = t445 * t279
  t447 = t444 * t446
  t449 = t285 * t274
  t450 = t449 * t279
  t453 = t203 * t312
  t454 = t202 * t453
  t456 = t449 * t292
  t457 = t444 * t456
  t460 = f.my_piecewise3(t112, t437 / 0.4e1 - t440 / 0.2e1 - 0.4e1 / 0.3e1 * t447 + 0.4e1 / 0.3e1 * t444 * t450 - t454 / 0.4e1 + 0.4e1 * t457, 0)
  t461 = t460 * t115
  t465 = t208 ** 2
  t466 = t465 * t115
  t473 = t122 * t227
  t474 = t473 * t127
  t478 = t124 * t234
  t482 = t460 * t117
  t484 = t465 * t117
  t492 = 0.2e1 * t113 * t460 + 0.5e1 * t460 + 0.2e1 * t465
  t494 = -t117 * t492 + t482 * t120 - t484 * t120 + 0.2e1 * t213 * t218
  t496 = t494 * t123 * t127
  t500 = t115 * t220
  t508 = 0.1e1 / t118 / t113
  t510 = t508 * t127 * t465
  t515 = t227 * t234 * t465
  t519 = t228 * t460
  t523 = t125 ** 2
  t525 = 0.1e1 / t126 / t523
  t527 = t123 * t525 * t465
  t531 = t235 * t460
  t535 = -t82 * t461 * t128 / 0.108e3 - t82 * t466 * t128 / 0.324e3 - t82 * t209 * t222 / 0.54e2 + t82 * t466 * t474 / 0.54e2 + t82 * t466 * t478 / 0.162e3 - t111 * t116 * t496 / 0.36e2 + t82 * t500 * t229 / 0.18e2 + t82 * t500 * t236 / 0.54e2 - t82 * t226 * t510 / 0.18e2 - t82 * t226 * t515 / 0.54e2 + t82 * t226 * t519 / 0.36e2 - t82 * t226 * t527 / 0.81e2 + t82 * t226 * t531 / 0.108e3
  t536 = f.my_piecewise3(t72, t364 + t434, t535)
  t541 = f.my_piecewise3(t1, 0, 0.3e1 / 0.16e2 * t5 * t43 * t132 + t5 * t141 * t132 / 0.8e1 + 0.3e1 / 0.8e1 * t5 * t145 * t241 - t5 * t251 * t132 / 0.24e2 + t5 * t255 * t241 / 0.8e1 + 0.3e1 / 0.16e2 * t5 * t259 * t536)
  t543 = r1 <= f.p.dens_threshold
  t544 = f.my_piecewise5(t14, t11, t10, t15, -t17)
  t545 = 0.1e1 + t544
  t546 = t545 <= f.p.zeta_threshold
  t547 = t545 ** (0.1e1 / 0.3e1)
  t548 = t547 ** 2
  t549 = 0.1e1 / t548
  t551 = f.my_piecewise5(t14, 0, t10, 0, -t27)
  t552 = t551 ** 2
  t556 = f.my_piecewise5(t14, 0, t10, 0, -t36)
  t560 = f.my_piecewise3(t546, 0, 0.4e1 / 0.9e1 * t549 * t552 + 0.4e1 / 0.3e1 * t547 * t556)
  t562 = r1 ** (0.1e1 / 0.3e1)
  t563 = t562 ** 2
  t568 = r1 ** 2
  t573 = s2 ** 2
  t574 = t568 ** 2
  t581 = mbrxc_x(0.149492e0 * tau1 / t563 / r1 - t56 + 0.147e0 * s2 / t563 / t568 + 0.32e-2 * t573 / t562 / t574 / r1)
  t583 = t581 ** 2
  t587 = t583 * t581
  t591 = t583 ** 2
  t609 = f.my_piecewise3(t71 < t581, t581, t71)
  t611 = jnp.exp(t609 / 0.3e1)
  t613 = jnp.exp(-t609)
  t614 = t609 ** 2
  t622 = (0.1e1 + t609) ** (0.1e1 / 0.3e1)
  t628 = f.my_piecewise3(t581 < t71, -t83 - t84 * t85 * t583 / 0.108e3 + t84 * t85 * t587 / 0.108e3 - 0.13e2 / 0.1620e4 * t84 * t85 * t591 + 0.67e2 / 0.9720e4 * t84 * t85 * t591 * t581 - 0.52e2 / 0.8505e4 * t84 * t85 * t591 * t583 + 0.1811e4 / 0.326592e6 * t84 * t85 * t591 * t587, -t111 * t80 * t611 * (0.8e1 - t613 * (t614 + 0.5e1 * t609 + 0.8e1)) / t609 / t622 / 0.36e2)
  t634 = f.my_piecewise3(t546, 0, 0.4e1 / 0.3e1 * t547 * t551)
  t640 = f.my_piecewise3(t546, t246, t547 * t545)
  t646 = f.my_piecewise3(t543, 0, 0.3e1 / 0.16e2 * t5 * t560 * t42 * t628 + t5 * t634 * t140 * t628 / 0.8e1 - t5 * t640 * t250 * t628 / 0.24e2)
  t656 = t24 ** 2
  t660 = 0.6e1 * t33 - 0.6e1 * t16 / t656
  t661 = f.my_piecewise5(t10, 0, t14, 0, t660)
  t665 = f.my_piecewise3(t20, 0, -0.8e1 / 0.27e2 / t22 / t19 * t29 * t28 + 0.4e1 / 0.3e1 * t23 * t28 * t37 + 0.4e1 / 0.3e1 * t21 * t661)
  t688 = 0.1e1 / t139 / t24
  t699 = t262 * t360
  t700 = t199 * t407
  t701 = t279 * t700
  t702 = t275 * t701
  t705 = t287 * t701
  t709 = 0.1e1 / t276 / t174
  t710 = t709 * t278
  t711 = t311 * t199
  t712 = t710 * t711
  t713 = t287 * t712
  t716 = t275 * t712
  t721 = t709 * t291
  t723 = t287 * t721 * t711
  t730 = t262 * t343
  t732 = t287 * t292 * t700
  t741 = t262 * t325
  t752 = 0.2e1 / 0.27e2 * t699 * t702 + 0.7e1 / 0.27e2 * t699 * t705 - 0.56729e5 / 0.45360e5 * t266 * t713 + 0.1811e4 / 0.11664e5 * t370 * t716 - 0.1811e4 / 0.11664e5 * t370 * t713 - 0.1811e4 / 0.3888e4 * t370 * t723 - 0.2e1 / 0.27e2 * t339 * t716 + 0.2e1 / 0.9e1 * t339 * t723 + t730 * t732 / 0.3e1 - 0.7e1 / 0.15e2 * t730 * t705 - 0.7e1 / 0.27e2 * t339 * t713 + t348 * t716 / 0.9e1 + 0.67e2 / 0.162e3 * t741 * t732 - 0.2e1 / 0.9e1 * t699 * t732 - 0.3275e4 / 0.3402e4 * t741 * t705 + 0.67e2 / 0.486e3 * t330 * t716 - 0.67e2 / 0.162e3 * t330 * t723
  t755 = t262 * t299
  t768 = t262 * t377
  t775 = t262 * t356
  t790 = -0.67e2 / 0.486e3 * t741 * t702 - 0.52e2 / 0.135e3 * t755 * t732 + 0.52e2 / 0.405e3 * t755 * t702 + 0.283e3 / 0.405e3 * t755 * t705 - 0.52e2 / 0.405e3 * t317 * t716 - 0.283e3 / 0.405e3 * t317 * t713 + 0.52e2 / 0.135e3 * t317 * t723 + 0.56729e5 / 0.45360e5 * t768 * t705 - 0.416e3 / 0.945e3 * t768 * t732 + 0.416e3 / 0.945e3 * t266 * t723 + 0.1811e4 / 0.11664e5 * t775 * t705 + 0.1811e4 / 0.3888e4 * t775 * t732 - 0.1811e4 / 0.11664e5 * t775 * t702 + 0.416e3 / 0.2835e4 * t768 * t702 + 0.3275e4 / 0.3402e4 * t330 * t713 - 0.416e3 / 0.2835e4 * t266 * t716 + 0.7e1 / 0.15e2 * t348 * t713
  t797 = t3 * t52 * t75
  t798 = t797 * t78
  t799 = t264 * t161
  t800 = t342 * t799
  t801 = t798 * t800
  t803 = 0.1e1 / t267 / t162
  t804 = 0.1e1 / t269
  t807 = 0.1e1 / t273 / t171
  t808 = t803 * t804 * t807
  t809 = t278 * t177
  t810 = t709 * t809
  t811 = t810 * t73
  t812 = t808 * t811
  t815 = t337 * t799
  t816 = t798 * t815
  t818 = t808 * t710 * t73
  t821 = t382 * t168
  t822 = t821 * t172
  t824 = t822 * t204 * t407
  t827 = t324 * t799
  t828 = t798 * t827
  t845 = t70 * t73 * t442 * t264
  t865 = t304 * t200 * t407 * t307 / 0.2e1 - t304 * t200 * t264 * t821 * t179 - 0.8e1 / 0.3e1 * t845 * t272 * t420 + 0.8e1 / 0.3e1 * t845 * t286 * t420 - t304 * t305 * t163 * t453 / 0.2e1 + 0.8e1 * t845 * t286 * t419 * t291 - 0.3e1 / 0.4e1 * t437 + 0.3e1 / 0.2e1 * t440 + 0.4e1 * t447 + 0.3e1 / 0.4e1 * t454 - 0.12e2 * t457
  t866 = t303 * t865
  t867 = t302 * t866
  t870 = t355 * t799
  t871 = t798 * t870
  t874 = t263 * t799
  t875 = t798 * t874
  t888 = t298 * t799
  t889 = t798 * t888
  t894 = t80 * t199
  t901 = -t348 * t723 / 0.3e1 - t730 * t702 / 0.9e1 - 0.928e3 / 0.135e3 * t801 * t812 - 0.16e2 / 0.9e1 * t816 * t818 + 0.1664e4 / 0.945e3 * t378 * t824 + 0.268e3 / 0.81e2 * t828 * t818 - 0.134e3 / 0.243e3 * t297 * t324 * t407 * t313 - 0.67e2 / 0.243e3 * t326 * t867 + 0.7244e4 / 0.2187e4 * t871 * t812 + 0.163531e6 / 0.8505e4 * t875 * t812 + 0.1811e4 / 0.486e3 * t871 * t818 + 0.304e3 / 0.81e2 * t816 * t812 + 0.8e1 / 0.3e1 * t801 * t818 - 0.1811e4 / 0.2916e4 * t297 * t355 * t407 * t313 + 0.12752e5 / 0.1215e4 * t889 * t812 - 0.416e3 / 0.135e3 * t889 * t818 - t262 * t894 * t161 * t287 * t279 * t407 / 0.9e1
  t903 = t297 * t337 * t407
  t904 = t204 * t161
  t917 = 0.1e1 / t269 / t165
  t919 = t803 * t917 * t807
  t920 = t278 * t178
  t921 = t709 * t920
  t922 = t921 * t73
  t923 = t919 * t922
  t926 = t269 ** 2
  t927 = 0.1e1 / t926
  t930 = t803 * t927 * t807 * t922
  t935 = t919 * t811
  t938 = t808 * t922
  t944 = t822 * t312
  t948 = t311 ** 2
  t949 = t709 * t178 * t948
  t950 = t302 * t949
  t953 = t262 * t800
  t955 = 0.1e1 / t267 / t69
  t957 = t955 * t285 * t274
  t958 = t957 * t280
  t965 = t955 * t271 * t274 * t280
  t973 = 0.8e1 / 0.9e1 * t903 * t822 * t904 + 0.208e3 / 0.135e3 * t300 * t824 - 0.134e3 / 0.81e2 * t326 * t824 - 0.4e1 / 0.3e1 * t344 * t824 - 0.1811e4 / 0.972e3 * t357 * t824 - 0.304e3 / 0.243e3 * t816 * t923 + 0.56e2 / 0.81e2 * t801 * t930 + 0.928e3 / 0.405e3 * t801 * t923 - 0.64e2 / 0.27e2 * t801 * t935 - 0.1904e4 / 0.1215e4 * t816 * t938 + 0.1592e4 / 0.405e3 * t801 * t938 + 0.1811e4 / 0.1458e4 * t297 * t369 * t944 + 0.1811e4 / 0.2916e4 * t357 * t950 + 0.14e2 / 0.15e2 * t953 * t958 + 0.4e1 / 0.9e1 * t344 * t950 + 0.2e1 / 0.9e1 * t953 * t965 + 0.8e1 / 0.9e1 * t297 * t347 * t944 + 0.1876e4 / 0.2187e4 * t828 * t930
  t1004 = t262 * t888
  t1012 = t262 * t874
  t1015 = -0.2144e4 / 0.729e3 * t828 * t935 + 0.208e3 / 0.405e3 * t297 * t298 * t407 * t313 + 0.104e3 / 0.405e3 * t300 * t867 - 0.2912e4 / 0.3645e4 * t889 * t930 - 0.12752e5 / 0.3645e4 * t889 * t923 + 0.3328e4 / 0.1215e4 * t889 * t935 - 0.198608e6 / 0.25515e5 * t889 * t938 - 0.163531e6 / 0.25515e5 * t875 * t923 + 0.12677e5 / 0.13122e5 * t871 * t930 - 0.7244e4 / 0.6561e4 * t871 * t923 - 0.7244e4 / 0.2187e4 * t871 * t935 + 0.176843e6 / 0.25515e5 * t875 * t938 + 0.3622e4 / 0.6561e4 * t871 * t938 - 0.566e3 / 0.405e3 * t1004 * t958 - 0.416e3 / 0.405e3 * t297 * t316 * t944 - 0.208e3 / 0.405e3 * t300 * t950 - 0.56729e5 / 0.22680e5 * t1012 * t958
  t1024 = t710 * t311
  t1038 = t262 * t870
  t1041 = t262 * t815
  t1051 = t957 * t293
  t1061 = -0.1811e4 / 0.5832e4 * t357 * t867 + 0.8e1 / 0.27e2 * t903 * t313 + 0.4e1 / 0.27e2 * t361 * t867 + t262 * t894 * t264 * t287 * t1024 / 0.9e1 - 0.112e3 / 0.243e3 * t816 * t930 + 0.128e3 / 0.81e2 * t816 * t935 - 0.4e1 / 0.9e1 * t297 * t342 * t407 * t313 - 0.2e1 / 0.9e1 * t344 * t867 + 0.1811e4 / 0.5832e4 * t1038 * t965 - 0.4e1 / 0.27e2 * t1041 * t965 - 0.14e2 / 0.27e2 * t1041 * t958 - 0.16e2 / 0.27e2 * t297 * t338 * t944 - 0.8e1 / 0.27e2 * t361 * t950 - 0.2e1 / 0.3e1 * t953 * t1051 - 0.3328e4 / 0.2835e4 * t297 * t265 * t944 - 0.1664e4 / 0.2835e4 * t378 * t950 - 0.1811e4 / 0.5832e4 * t1038 * t958
  t1083 = t262 * t827
  t1101 = -0.1811e4 / 0.1944e4 * t1038 * t1051 + 0.1664e4 / 0.2835e4 * t297 * t263 * t407 * t313 + 0.832e3 / 0.2835e4 * t378 * t867 + 0.74848e5 / 0.15309e5 * t828 * t923 - 0.3328e4 / 0.3645e4 * t875 * t930 + 0.26624e5 / 0.8505e4 * t875 * t935 + 0.405761e6 / 0.30618e5 * t828 * t938 - 0.74848e5 / 0.5103e4 * t828 * t812 - 0.3328e4 / 0.945e3 * t875 * t818 - 0.67e2 / 0.81e2 * t1083 * t1051 + 0.4e1 / 0.9e1 * t1041 * t1051 + 0.3275e4 / 0.1701e4 * t1083 * t958 + 0.268e3 / 0.243e3 * t297 * t329 * t944 + 0.134e3 / 0.243e3 * t326 * t950 + 0.67e2 / 0.243e3 * t1083 * t965 + 0.104e3 / 0.135e3 * t1004 * t1051 - 0.104e3 / 0.405e3 * t1004 * t965
  t1106 = t799 * t268
  t1108 = t1106 * t168 * t179
  t1121 = t63 ** 2
  t1127 = (-0.24361659259259259259259259259259259259259259259259e1 * tau0 * t399 - 0.67075555555555555555555555555555555555555555555554e1 * s0 / t45 / t64 - 0.79265185185185185185185185185185185185185185185186e0 * t62 / t44 / t1121) * t163
  t1129 = t1127 * t168 * t179
  t1139 = t797 * t85 * t73
  t1140 = t799 * t803
  t1141 = t1140 * t804
  t1142 = t807 * t709
  t1151 = t1142 * t920
  t1163 = t799 * t955
  t1170 = 0.832e3 / 0.945e3 * t1012 * t1051 - 0.832e3 / 0.2835e4 * t1012 * t965 + 0.134e3 / 0.81e2 * t189 * t1108 + 0.4e1 / 0.3e1 * t183 * t1108 + 0.1811e4 / 0.972e3 * t195 * t1108 + 0.2e1 / 0.9e1 * t183 * t1129 - 0.104e3 / 0.405e3 * t186 * t1129 + 0.67e2 / 0.243e3 * t189 * t1129 - 0.832e3 / 0.2835e4 * t192 * t1129 - 0.16e2 / 0.9e1 * t1139 * t1141 * t1142 * t809 + 0.1811e4 / 0.5832e4 * t195 * t1129 - 0.4e1 / 0.27e2 * t148 * t1129 + 0.8e1 / 0.27e2 * t1139 * t1141 * t1151 + 0.16e2 / 0.27e2 * t1139 * t1140 * t917 * t1151 - 0.1664e4 / 0.945e3 * t192 * t1108 - 0.8e1 / 0.9e1 * t148 * t1108 + 0.2e1 / 0.9e1 * t416 * t1163 * t285 * t420 - 0.208e3 / 0.135e3 * t186 * t1108
  t1174 = t465 * t208
  t1175 = t1174 * t115
  t1200 = t118 ** 2
  t1230 = t443 * t1163
  t1259 = t202 * t203 * t949 / 0.2e1 + 0.8e1 * t1230 * t446 - 0.8e1 * t1230 * t450 - 0.24e2 * t1230 * t456 + t201 * t1127 * t205 / 0.4e1 - 0.12e2 * t444 * t449 * t721 * t311 - 0.4e1 * t444 * t449 * t1024 - t202 * t203 * t866 / 0.4e1 + t439 * t453 + 0.4e1 * t444 * t445 * t1024 - 0.3e1 / 0.2e1 * t201 * t407 * t382 * t203 * t904
  t1263 = t443 * t407 * t268
  t1264 = t279 * t161
  t1279 = t52 * t799 * t803
  t1280 = t804 * t807
  t1294 = t917 * t807
  t1301 = -t436 * t453 / 0.2e1 - 0.4e1 * t1263 * t445 * t1264 + 0.4e1 * t1263 * t449 * t1264 + 0.12e2 * t1263 * t449 * t292 * t161 + 0.3e1 / 0.2e1 * t201 * t1106 * t205 + 0.128e3 / 0.9e1 * t1279 * t1280 * t921 + 0.256e3 / 0.3e1 * t1279 * t1280 * t810 + 0.96e2 * t1279 * t1280 * t710 + 0.224e3 / 0.9e1 * t1279 * t927 * t807 * t921 - 0.256e3 / 0.9e1 * t1279 * t1294 * t921 - 0.256e3 / 0.3e1 * t1279 * t1294 * t810
  t1303 = f.my_piecewise3(t112, t1259 + t1301, 0)
  t1306 = t208 * t460
  t1341 = -t82 * t1175 * t473 * t234 / 0.54e2 - t82 * t1175 * t124 * t525 / 0.81e2 + 0.7e1 / 0.243e3 * t82 * t226 * t123 / t126 / t523 / t125 * t1174 + t82 * t226 * t227 * t525 * t1174 / 0.27e2 - t82 * t500 * t527 / 0.27e2 + t82 * t226 / t1200 * t127 * t1174 / 0.6e1 + t82 * t226 * t508 * t234 * t1174 / 0.18e2 - t82 * t500 * t510 / 0.6e1 - t82 * t500 * t515 / 0.18e2 - t82 * t209 * t496 / 0.36e2 - t82 * t461 * t222 / 0.36e2 - t82 * t466 * t222 / 0.108e3 - t111 * t116 * (t1303 * t117 * t120 - 0.3e1 * t1306 * t121 + 0.3e1 * t482 * t218 + t1174 * t117 * t120 - 0.3e1 * t484 * t218 + 0.3e1 * t213 * t492 - t117 * (0.2e1 * t113 * t1303 + 0.5e1 * t1303 + 0.6e1 * t1306)) * t123 * t127 / 0.36e2 - t82 * t1303 * t115 * t128 / 0.108e3 + t82 * t226 * t235 * t1303 / 0.108e3 + t82 * t226 * t228 * t1303 / 0.36e2
  t1348 = t115 * t494
  t1378 = t461 * t122
  t1407 = t82 * t500 * t531 / 0.36e2 + t82 * t500 * t519 / 0.12e2 + t82 * t1348 * t229 / 0.12e2 + t82 * t1348 * t236 / 0.36e2 + t82 * t1175 * t474 / 0.108e3 + t82 * t1175 * t478 / 0.324e3 + t82 * t466 * t220 * t227 * t127 / 0.18e2 + t82 * t466 * t221 * t234 / 0.54e2 - t82 * t1175 * t122 * t508 * t127 / 0.18e2 - t82 * t1175 * t128 / 0.972e3 + t82 * t1378 * t229 / 0.18e2 + t82 * t1378 * t236 / 0.54e2 - t82 * t1306 * t115 * t128 / 0.108e3 - t82 * t226 * t123 * t525 * t208 * t460 / 0.27e2 - t82 * t226 * t227 * t234 * t208 * t460 / 0.18e2 - t82 * t226 * t508 * t127 * t208 * t460 / 0.6e1
  t1409 = f.my_piecewise3(t72, t752 + t790 + t901 + t973 + t1015 + t1061 + t1101 + t1170, t1341 + t1407)
  t1414 = f.my_piecewise3(t1, 0, 0.3e1 / 0.16e2 * t5 * t665 * t42 * t132 + 0.3e1 / 0.16e2 * t5 * t41 * t140 * t132 + 0.9e1 / 0.16e2 * t5 * t43 * t241 - t5 * t138 * t250 * t132 / 0.8e1 + 0.3e1 / 0.8e1 * t5 * t141 * t241 + 0.9e1 / 0.16e2 * t5 * t145 * t536 + 0.5e1 / 0.72e2 * t5 * t248 * t688 * t132 - t5 * t251 * t241 / 0.8e1 + 0.3e1 / 0.16e2 * t5 * t255 * t536 + 0.3e1 / 0.16e2 * t5 * t259 * t1409)
  t1424 = f.my_piecewise5(t14, 0, t10, 0, -t660)
  t1428 = f.my_piecewise3(t546, 0, -0.8e1 / 0.27e2 / t548 / t545 * t552 * t551 + 0.4e1 / 0.3e1 * t549 * t551 * t556 + 0.4e1 / 0.3e1 * t547 * t1424)
  t1446 = f.my_piecewise3(t543, 0, 0.3e1 / 0.16e2 * t5 * t1428 * t42 * t628 + 0.3e1 / 0.16e2 * t5 * t560 * t140 * t628 - t5 * t634 * t250 * t628 / 0.8e1 + 0.5e1 / 0.72e2 * t5 * t640 * t688 * t628)
  d111 = 0.3e1 * t541 + 0.3e1 * t646 + t6 * (t1414 + t1446)

  res = {'v3rho3': d111}
  return res
