"""Generated from mgga_xc_b98.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  b98_gamma_x = 0.11

  b98_gamma_ss = 1.6

  b98_gamma_ab = 0.14

  params_c_x = np.array([np.nan, 0.8085, 0.6682, 0.142], dtype=np.float64)

  params_c_ss = np.array([np.nan, 0.2606, -0.9608, 0.9023], dtype=np.float64)

  params_c_ab = np.array([np.nan, 1.2033, -2.2717, 0.9596], dtype=np.float64)

  b98_q = lambda x, u, t: 1 - (t - x ** 2 / 8 - u / 4) / K_FACTOR_C

  b98_g = lambda gamma, cc, q: jnp.sum(jnp.array([cc[i] * (gamma * q / jnp.sqrt(1 + gamma ** 2 * q ** 2)) ** (i - 1) for i in range(1, 3 + 1)]), axis=0)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  b98_f = lambda rs, z, xs0, xs1, us0, us1, ts0, ts1: +f.lda_x_spin(rs, z) * b98_g(b98_gamma_x, params_c_x, b98_q(xs0, us0, ts0)) + f.lda_x_spin(rs, -z) * b98_g(b98_gamma_x, params_c_x, b98_q(xs1, us1, ts1)) + lda_stoll_par(f, params, f_pw, rs, z, 1) * b98_g(b98_gamma_ss, params_c_ss, b98_q(xs0, us0, ts0)) * f.Fermi_D(xs0, ts0) + lda_stoll_par(f, params, f_pw, rs, -z, -1) * b98_g(b98_gamma_ss, params_c_ss, b98_q(xs1, us1, ts1)) * f.Fermi_D(xs1, ts1) + lda_stoll_perp(f, params, f_pw, rs, z) * b98_g(b98_gamma_ab, params_c_ab, (b98_q(xs0, us0, ts0) + b98_q(xs1, us1, ts1)) / 2)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: b98_f(rs, z, xs0, xs1, us0, us1, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0, r1)),
      f.zeta(r0, r1),
      f.xt(r0, r1, s0, s1, s2),
      f.xs0(r0, r1, s0, s2),
      f.xs1(r0, r1, s0, s2),
      f.u0(r0, r1, l0, l1),
      f.u1(r0, r1, l0, l1),
      f.tt0(r0, r1, tau0, tau1),
      f.tt1(r0, r1, tau0, tau1),
  )
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  b98_gamma_x = 0.11

  b98_gamma_ss = 1.6

  b98_gamma_ab = 0.14

  params_c_x = np.array([np.nan, 0.8085, 0.6682, 0.142], dtype=np.float64)

  params_c_ss = np.array([np.nan, 0.2606, -0.9608, 0.9023], dtype=np.float64)

  params_c_ab = np.array([np.nan, 1.2033, -2.2717, 0.9596], dtype=np.float64)

  b98_q = lambda x, u, t: 1 - (t - x ** 2 / 8 - u / 4) / K_FACTOR_C

  b98_g = lambda gamma, cc, q: jnp.sum(jnp.array([cc[i] * (gamma * q / jnp.sqrt(1 + gamma ** 2 * q ** 2)) ** (i - 1) for i in range(1, 3 + 1)]), axis=0)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  b98_f = lambda rs, z, xs0, xs1, us0, us1, ts0, ts1: +f.lda_x_spin(rs, z) * b98_g(b98_gamma_x, params_c_x, b98_q(xs0, us0, ts0)) + f.lda_x_spin(rs, -z) * b98_g(b98_gamma_x, params_c_x, b98_q(xs1, us1, ts1)) + lda_stoll_par(f, params, f_pw, rs, z, 1) * b98_g(b98_gamma_ss, params_c_ss, b98_q(xs0, us0, ts0)) * f.Fermi_D(xs0, ts0) + lda_stoll_par(f, params, f_pw, rs, -z, -1) * b98_g(b98_gamma_ss, params_c_ss, b98_q(xs1, us1, ts1)) * f.Fermi_D(xs1, ts1) + lda_stoll_perp(f, params, f_pw, rs, z) * b98_g(b98_gamma_ab, params_c_ab, (b98_q(xs0, us0, ts0) + b98_q(xs1, us1, ts1)) / 2)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: b98_f(rs, z, xs0, xs1, us0, us1, ts0, ts1)

  res = functional_body(
      f.r_ws(f.dens(r0 / 2, r0 / 2)),
      f.zeta(r0 / 2, r0 / 2),
      f.xt(r0 / 2, r0 / 2, s0 / 4, s0 / 4, s0 / 4),
      f.xs0(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.xs1(r0 / 2, r0 / 2, s0 / 4, s0 / 4),
      f.u0(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.u1(r0 / 2, r0 / 2, l0 / 2, l0 / 2),
      f.tt0(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
      f.tt1(r0 / 2, r0 / 2, tau0 / 2, tau0 / 2),
  )
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  b98_gamma_x = 0.11

  b98_gamma_ss = 1.6

  b98_gamma_ab = 0.14

  params_c_x = np.array([np.nan, 0.8085, 0.6682, 0.142], dtype=np.float64)

  params_c_ss = np.array([np.nan, 0.2606, -0.9608, 0.9023], dtype=np.float64)

  params_c_ab = np.array([np.nan, 1.2033, -2.2717, 0.9596], dtype=np.float64)

  b98_q = lambda x, u, t: 1 - (t - x ** 2 / 8 - u / 4) / K_FACTOR_C

  b98_g = lambda gamma, cc, q: jnp.sum(jnp.array([cc[i] * (gamma * q / jnp.sqrt(1 + gamma ** 2 * q ** 2)) ** (i - 1) for i in range(1, 3 + 1)]), axis=0)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  b98_f = lambda rs, z, xs0, xs1, us0, us1, ts0, ts1: +f.lda_x_spin(rs, z) * b98_g(b98_gamma_x, params_c_x, b98_q(xs0, us0, ts0)) + f.lda_x_spin(rs, -z) * b98_g(b98_gamma_x, params_c_x, b98_q(xs1, us1, ts1)) + lda_stoll_par(f, params, f_pw, rs, z, 1) * b98_g(b98_gamma_ss, params_c_ss, b98_q(xs0, us0, ts0)) * f.Fermi_D(xs0, ts0) + lda_stoll_par(f, params, f_pw, rs, -z, -1) * b98_g(b98_gamma_ss, params_c_ss, b98_q(xs1, us1, ts1)) * f.Fermi_D(xs1, ts1) + lda_stoll_perp(f, params, f_pw, rs, z) * b98_g(b98_gamma_ab, params_c_ab, (b98_q(xs0, us0, ts0) + b98_q(xs1, us1, ts1)) / 2)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: b98_f(rs, z, xs0, xs1, us0, us1, ts0, ts1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = jnp.pi ** (0.1e1 / 0.3e1)
  t4 = t1 / t2
  t5 = r0 + r1
  t6 = 0.1e1 / t5
  t7 = r0 * t6
  t9 = 0.2e1 * t7 <= f.p.zeta_threshold
  t10 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t11 = t10 * f.p.zeta_threshold
  t12 = 2 ** (0.1e1 / 0.3e1)
  t13 = t12 * r0
  t14 = t7 ** (0.1e1 / 0.3e1)
  t18 = f.my_piecewise3(t9, t11, 0.2e1 * t13 * t6 * t14)
  t19 = t5 ** (0.1e1 / 0.3e1)
  t20 = t18 * t19
  t21 = r0 ** (0.1e1 / 0.3e1)
  t22 = t21 ** 2
  t24 = 0.1e1 / t22 / r0
  t26 = r0 ** 2
  t28 = 0.1e1 / t22 / t26
  t34 = 6 ** (0.1e1 / 0.3e1)
  t36 = jnp.pi ** 2
  t37 = t36 ** (0.1e1 / 0.3e1)
  t38 = t37 ** 2
  t39 = 0.1e1 / t38
  t40 = (tau0 * t24 - s0 * t28 / 0.8e1 - l0 * t24 / 0.4e1) * t34 * t39
  t42 = 0.11e0 - 0.61111111111111111111111111111111111111111111111111e-1 * t40
  t44 = 0.1e1 - 0.5e1 / 0.9e1 * t40
  t45 = t44 ** 2
  t47 = 0.1e1 + 0.121e-1 * t45
  t48 = jnp.sqrt(t47)
  t49 = 0.1e1 / t48
  t52 = t42 ** 2
  t53 = 0.1e1 / t47
  t56 = 0.8085e0 + 0.6682e0 * t42 * t49 + 0.1420e0 * t52 * t53
  t59 = 0.3e1 / 0.8e1 * t4 * t20 * t56
  t60 = r1 * t6
  t62 = 0.2e1 * t60 <= f.p.zeta_threshold
  t63 = t12 * r1
  t64 = t60 ** (0.1e1 / 0.3e1)
  t68 = f.my_piecewise3(t62, t11, 0.2e1 * t63 * t6 * t64)
  t69 = t68 * t19
  t70 = r1 ** (0.1e1 / 0.3e1)
  t71 = t70 ** 2
  t73 = 0.1e1 / t71 / r1
  t75 = r1 ** 2
  t77 = 0.1e1 / t71 / t75
  t84 = (tau1 * t73 - s2 * t77 / 0.8e1 - l1 * t73 / 0.4e1) * t34 * t39
  t86 = 0.11e0 - 0.61111111111111111111111111111111111111111111111111e-1 * t84
  t88 = 0.1e1 - 0.5e1 / 0.9e1 * t84
  t89 = t88 ** 2
  t91 = 0.1e1 + 0.121e-1 * t89
  t92 = jnp.sqrt(t91)
  t93 = 0.1e1 / t92
  t96 = t86 ** 2
  t97 = 0.1e1 / t91
  t100 = 0.8085e0 + 0.6682e0 * t86 * t93 + 0.1420e0 * t96 * t97
  t103 = 0.3e1 / 0.8e1 * t4 * t69 * t100
  t105 = r0 - r1
  t106 = t105 * t6
  t107 = 0.1e1 + t106
  t108 = t107 <= f.p.zeta_threshold
  t109 = r0 <= f.p.dens_threshold or t108
  t110 = f.my_piecewise3(t108, f.p.zeta_threshold, t107)
  t112 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t113 = t1 * t112
  t114 = 4 ** (0.1e1 / 0.3e1)
  t115 = t114 ** 2
  t116 = t113 * t115
  t117 = 0.1e1 / t19
  t118 = t117 * t12
  t119 = 0.1e1 / t10
  t120 = t107 ** (0.1e1 / 0.3e1)
  t122 = f.my_piecewise3(t108, t119, 0.1e1 / t120)
  t124 = t116 * t118 * t122
  t126 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t124
  t127 = jnp.sqrt(t124)
  t130 = t124 ** 0.15e1
  t132 = t1 ** 2
  t133 = t112 ** 2
  t134 = t132 * t133
  t135 = t134 * t114
  t136 = t19 ** 2
  t137 = 0.1e1 / t136
  t138 = t12 ** 2
  t139 = t137 * t138
  t140 = t122 ** 2
  t142 = t135 * t139 * t140
  t144 = 0.23615790870000000000000000000000000000000000000000e0 * t127 + 0.55771035800000000000000000000000000000000000000000e-1 * t124 + 0.12733319050000000000000000000000000000000000000000e-1 * t130 + 0.76629987700000000000000000000000000000000000000000e-2 * t142
  t146 = 0.1e1 + 0.1e1 / t144
  t147 = jnp.log(t146)
  t148 = t126 * t147
  t151 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t11, 0.2e1 * t12)
  t153 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t11, 0)
  t157 = 0.1e1 / (0.2e1 * t12 - 0.2e1)
  t158 = (t151 + t153 - 0.2e1) * t157
  t160 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t124
  t165 = 0.21947830050000000000000000000000000000000000000000e0 * t127 + 0.48171623250000000000000000000000000000000000000000e-1 * t124 + 0.13081894750000000000000000000000000000000000000000e-1 * t130 + 0.48591338250000000000000000000000000000000000000000e-2 * t142
  t167 = 0.1e1 + 0.1e1 / t165
  t168 = jnp.log(t167)
  t171 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t124
  t176 = 0.17489865900000000000000000000000000000000000000000e0 * t127 + 0.30591644850000000000000000000000000000000000000000e-1 * t124 + 0.37162376550000000000000000000000000000000000000000e-2 * t130 + 0.41939708850000000000000000000000000000000000000000e-2 * t142
  t178 = 0.1e1 + 0.1e1 / t176
  t179 = jnp.log(t178)
  t180 = t171 * t179
  t186 = -t148 + t158 * (-t160 * t168 + t148 - 0.58482233974552040708313425006184496242808878304904e0 * t180) + 0.58482233974552040708313425006184496242808878304904e0 * t158 * t180
  t189 = f.my_piecewise3(t109, 0, t110 * t186 / 0.2e1)
  t191 = 0.16e1 - 0.88888888888888888888888888888888888888888888888889e0 * t40
  t193 = 0.1e1 + 0.256e1 * t45
  t194 = jnp.sqrt(t193)
  t195 = 0.1e1 / t194
  t198 = t191 ** 2
  t199 = 0.1e1 / t193
  t202 = 0.2606e0 - 0.9608e0 * t191 * t195 + 0.9023e0 * t198 * t199
  t203 = t189 * t202
  t204 = 0.1e1 / r0
  t205 = s0 * t204
  t206 = 0.1e1 / tau0
  t209 = 0.1e1 - t205 * t206 / 0.8e1
  t210 = t203 * t209
  t212 = 0.1e1 - t106
  t213 = t212 <= f.p.zeta_threshold
  t214 = r1 <= f.p.dens_threshold or t213
  t215 = f.my_piecewise3(t213, f.p.zeta_threshold, t212)
  t216 = t212 ** (0.1e1 / 0.3e1)
  t218 = f.my_piecewise3(t213, t119, 0.1e1 / t216)
  t220 = t116 * t118 * t218
  t222 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t220
  t223 = jnp.sqrt(t220)
  t226 = t220 ** 0.15e1
  t228 = t218 ** 2
  t230 = t135 * t139 * t228
  t232 = 0.23615790870000000000000000000000000000000000000000e0 * t223 + 0.55771035800000000000000000000000000000000000000000e-1 * t220 + 0.12733319050000000000000000000000000000000000000000e-1 * t226 + 0.76629987700000000000000000000000000000000000000000e-2 * t230
  t234 = 0.1e1 + 0.1e1 / t232
  t235 = jnp.log(t234)
  t236 = t222 * t235
  t238 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t220
  t243 = 0.21947830050000000000000000000000000000000000000000e0 * t223 + 0.48171623250000000000000000000000000000000000000000e-1 * t220 + 0.13081894750000000000000000000000000000000000000000e-1 * t226 + 0.48591338250000000000000000000000000000000000000000e-2 * t230
  t245 = 0.1e1 + 0.1e1 / t243
  t246 = jnp.log(t245)
  t249 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t220
  t254 = 0.17489865900000000000000000000000000000000000000000e0 * t223 + 0.30591644850000000000000000000000000000000000000000e-1 * t220 + 0.37162376550000000000000000000000000000000000000000e-2 * t226 + 0.41939708850000000000000000000000000000000000000000e-2 * t230
  t256 = 0.1e1 + 0.1e1 / t254
  t257 = jnp.log(t256)
  t258 = t249 * t257
  t264 = -t236 + t158 * (-t238 * t246 + t236 - 0.58482233974552040708313425006184496242808878304904e0 * t258) + 0.58482233974552040708313425006184496242808878304904e0 * t158 * t258
  t267 = f.my_piecewise3(t214, 0, t215 * t264 / 0.2e1)
  t269 = 0.16e1 - 0.88888888888888888888888888888888888888888888888889e0 * t84
  t271 = 0.1e1 + 0.256e1 * t89
  t272 = jnp.sqrt(t271)
  t273 = 0.1e1 / t272
  t276 = t269 ** 2
  t277 = 0.1e1 / t271
  t280 = 0.2606e0 - 0.9608e0 * t269 * t273 + 0.9023e0 * t276 * t277
  t281 = t267 * t280
  t282 = 0.1e1 / r1
  t283 = s2 * t282
  t284 = 0.1e1 / tau1
  t287 = 0.1e1 - t283 * t284 / 0.8e1
  t288 = t281 * t287
  t290 = t113 * t115 * t117
  t292 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t290
  t293 = jnp.sqrt(t290)
  t296 = t290 ** 0.15e1
  t299 = t134 * t114 * t137
  t301 = 0.23615790870000000000000000000000000000000000000000e0 * t293 + 0.55771035800000000000000000000000000000000000000000e-1 * t290 + 0.12733319050000000000000000000000000000000000000000e-1 * t296 + 0.76629987700000000000000000000000000000000000000000e-2 * t299
  t303 = 0.1e1 + 0.1e1 / t301
  t304 = jnp.log(t303)
  t305 = t292 * t304
  t306 = t105 ** 2
  t307 = t306 ** 2
  t308 = t5 ** 2
  t309 = t308 ** 2
  t310 = 0.1e1 / t309
  t311 = t307 * t310
  t312 = t120 * t107
  t313 = f.my_piecewise3(t108, t11, t312)
  t314 = t216 * t212
  t315 = f.my_piecewise3(t213, t11, t314)
  t317 = (t313 + t315 - 0.2e1) * t157
  t319 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t290
  t324 = 0.21947830050000000000000000000000000000000000000000e0 * t293 + 0.48171623250000000000000000000000000000000000000000e-1 * t290 + 0.13081894750000000000000000000000000000000000000000e-1 * t296 + 0.48591338250000000000000000000000000000000000000000e-2 * t299
  t326 = 0.1e1 + 0.1e1 / t324
  t327 = jnp.log(t326)
  t330 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t290
  t335 = 0.17489865900000000000000000000000000000000000000000e0 * t293 + 0.30591644850000000000000000000000000000000000000000e-1 * t290 + 0.37162376550000000000000000000000000000000000000000e-2 * t296 + 0.41939708850000000000000000000000000000000000000000e-2 * t299
  t337 = 0.1e1 + 0.1e1 / t335
  t338 = jnp.log(t337)
  t339 = t330 * t338
  t341 = -t319 * t327 + t305 - 0.58482233974552040708313425006184496242808878304904e0 * t339
  t342 = t317 * t341
  t346 = -t305 + t311 * t342 + 0.58482233974552040708313425006184496242808878304904e0 * t317 * t339 - t189 - t267
  t349 = 0.14e0 - 0.38888888888888888888888888888888888888888888888889e-1 * t40 - 0.38888888888888888888888888888888888888888888888889e-1 * t84
  t352 = 0.1e1 - 0.5e1 / 0.18e2 * t40 - 0.5e1 / 0.18e2 * t84
  t353 = t352 ** 2
  t355 = 0.1e1 + 0.196e-1 * t353
  t356 = jnp.sqrt(t355)
  t357 = 0.1e1 / t356
  t360 = t349 ** 2
  t361 = 0.1e1 / t355
  t364 = 0.12033e1 - 0.22717e1 * t349 * t357 + 0.9596e0 * t360 * t361
  t365 = t346 * t364
  t366 = t12 * t6
  t369 = 0.1e1 / t308
  t372 = 0.2e1 * t13 * t369 * t14
  t373 = t14 ** 2
  t374 = 0.1e1 / t373
  t382 = f.my_piecewise3(t9, 0, 0.2e1 * t366 * t14 - t372 + 0.2e1 / 0.3e1 * t13 * t6 * t374 * (-r0 * t369 + t6))
  t390 = t4 * t18 * t137 * t56 / 0.8e1
  t401 = (-0.5e1 / 0.3e1 * tau0 * t28 + s0 / t22 / t26 / r0 / 0.3e1 + 0.5e1 / 0.12e2 * l0 * t28) * t34
  t402 = t39 * t49
  t408 = t42 / t48 / t47 * t44
  t409 = t401 * t39
  t412 = t42 * t53
  t415 = t47 ** 2
  t418 = t52 / t415 * t44
  t427 = 0.2e1 * t63 * t369 * t64
  t430 = 0.1e1 / t308 / t5
  t431 = t64 ** 2
  t432 = 0.1e1 / t431
  t437 = f.my_piecewise3(t62, 0, -t427 - 0.2e1 / 0.3e1 * t12 * t75 * t430 * t432)
  t445 = t4 * t68 * t137 * t100 / 0.8e1
  t446 = t105 * t369
  t447 = t6 - t446
  t448 = f.my_piecewise3(t108, 0, t447)
  t451 = 0.1e1 / t19 / t5
  t452 = t451 * t12
  t454 = t116 * t452 * t122
  t455 = 0.11073577833333333333333333333333333333333333333333e-2 * t454
  t456 = 0.1e1 / t312
  t459 = f.my_piecewise3(t108, 0, -t456 * t447 / 0.3e1)
  t461 = t116 * t118 * t459
  t464 = (-t455 + 0.33220733500000000000000000000000000000000000000000e-2 * t461) * t147
  t465 = t144 ** 2
  t467 = t126 / t465
  t468 = 0.1e1 / t127
  t469 = t454 / 0.3e1
  t470 = -t469 + t461
  t471 = t468 * t470
  t473 = 0.18590345266666666666666666666666666666666666666667e-1 * t454
  t475 = t124 ** 0.5e0
  t476 = t475 * t470
  t479 = 0.1e1 / t136 / t5
  t480 = t479 * t138
  t482 = t135 * t480 * t140
  t483 = 0.51086658466666666666666666666666666666666666666667e-2 * t482
  t486 = t135 * t139 * t122 * t459
  t489 = 0.1e1 / t146
  t491 = t467 * (0.11807895435000000000000000000000000000000000000000e0 * t471 - t473 + 0.55771035800000000000000000000000000000000000000000e-1 * t461 + 0.19099978575000000000000000000000000000000000000000e-1 * t476 - t483 + 0.15325997540000000000000000000000000000000000000000e-1 * t486) * t489
  t492 = 0.53236443333333333333333333333333333333333333333333e-3 * t454
  t496 = t165 ** 2
  t498 = t160 / t496
  t500 = 0.16057207750000000000000000000000000000000000000000e-1 * t454
  t503 = 0.32394225500000000000000000000000000000000000000000e-2 * t482
  t506 = 0.1e1 / t167
  t509 = 0.31311312500000000000000000000000000000000000000000e-3 * t454
  t512 = (-t509 + 0.93933937500000000000000000000000000000000000000000e-3 * t461) * t179
  t514 = t176 ** 2
  t515 = 0.1e1 / t514
  t516 = t171 * t515
  t518 = 0.10197214950000000000000000000000000000000000000000e-1 * t454
  t521 = 0.27959805900000000000000000000000000000000000000000e-2 * t482
  t523 = 0.87449329500000000000000000000000000000000000000000e-1 * t471 - t518 + 0.30591644850000000000000000000000000000000000000000e-1 * t461 + 0.55743564825000000000000000000000000000000000000000e-2 * t476 - t521 + 0.83879417700000000000000000000000000000000000000000e-2 * t486
  t524 = 0.1e1 / t178
  t532 = t158 * t171
  t541 = f.my_piecewise3(t109, 0, t448 * t186 / 0.2e1 + t110 * (-t464 + t491 + t158 * (-(-t492 + 0.15970933000000000000000000000000000000000000000000e-2 * t461) * t168 + t498 * (0.10973915025000000000000000000000000000000000000000e0 * t471 - t500 + 0.48171623250000000000000000000000000000000000000000e-1 * t461 + 0.19622842125000000000000000000000000000000000000000e-1 * t476 - t503 + 0.97182676500000000000000000000000000000000000000000e-2 * t486) * t506 + t464 - t491 - 0.58482233974552040708313425006184496242808878304904e0 * t512 + 0.58482233974552040708313425006184496242808878304904e0 * t516 * t523 * t524) + 0.58482233974552040708313425006184496242808878304904e0 * t158 * t512 - 0.58482233974552040708313425006184496242808878304904e0 * t532 * t515 * t523 * t524) / 0.2e1)
  t544 = t39 * t195
  t550 = t191 / t194 / t193 * t44
  t553 = t191 * t199
  t556 = t193 ** 2
  t559 = t198 / t556 * t44
  t570 = -t447
  t571 = f.my_piecewise3(t213, 0, t570)
  t574 = t116 * t452 * t218
  t575 = 0.11073577833333333333333333333333333333333333333333e-2 * t574
  t576 = 0.1e1 / t314
  t579 = f.my_piecewise3(t213, 0, -t576 * t570 / 0.3e1)
  t581 = t116 * t118 * t579
  t584 = (-t575 + 0.33220733500000000000000000000000000000000000000000e-2 * t581) * t235
  t585 = t232 ** 2
  t587 = t222 / t585
  t588 = 0.1e1 / t223
  t589 = t574 / 0.3e1
  t590 = -t589 + t581
  t591 = t588 * t590
  t593 = 0.18590345266666666666666666666666666666666666666667e-1 * t574
  t595 = t220 ** 0.5e0
  t596 = t595 * t590
  t599 = t135 * t480 * t228
  t600 = 0.51086658466666666666666666666666666666666666666667e-2 * t599
  t603 = t135 * t139 * t218 * t579
  t606 = 0.1e1 / t234
  t608 = t587 * (0.11807895435000000000000000000000000000000000000000e0 * t591 - t593 + 0.55771035800000000000000000000000000000000000000000e-1 * t581 + 0.19099978575000000000000000000000000000000000000000e-1 * t596 - t600 + 0.15325997540000000000000000000000000000000000000000e-1 * t603) * t606
  t609 = 0.53236443333333333333333333333333333333333333333333e-3 * t574
  t613 = t243 ** 2
  t615 = t238 / t613
  t617 = 0.16057207750000000000000000000000000000000000000000e-1 * t574
  t620 = 0.32394225500000000000000000000000000000000000000000e-2 * t599
  t623 = 0.1e1 / t245
  t626 = 0.31311312500000000000000000000000000000000000000000e-3 * t574
  t629 = (-t626 + 0.93933937500000000000000000000000000000000000000000e-3 * t581) * t257
  t631 = t254 ** 2
  t632 = 0.1e1 / t631
  t633 = t249 * t632
  t635 = 0.10197214950000000000000000000000000000000000000000e-1 * t574
  t638 = 0.27959805900000000000000000000000000000000000000000e-2 * t599
  t640 = 0.87449329500000000000000000000000000000000000000000e-1 * t591 - t635 + 0.30591644850000000000000000000000000000000000000000e-1 * t581 + 0.55743564825000000000000000000000000000000000000000e-2 * t596 - t638 + 0.83879417700000000000000000000000000000000000000000e-2 * t603
  t641 = 0.1e1 / t256
  t649 = t158 * t249
  t658 = f.my_piecewise3(t214, 0, t571 * t264 / 0.2e1 + t215 * (-t584 + t608 + t158 * (-(-t609 + 0.15970933000000000000000000000000000000000000000000e-2 * t581) * t246 + t615 * (0.10973915025000000000000000000000000000000000000000e0 * t591 - t617 + 0.48171623250000000000000000000000000000000000000000e-1 * t581 + 0.19622842125000000000000000000000000000000000000000e-1 * t596 - t620 + 0.97182676500000000000000000000000000000000000000000e-2 * t603) * t623 + t584 - t608 - 0.58482233974552040708313425006184496242808878304904e0 * t629 + 0.58482233974552040708313425006184496242808878304904e0 * t633 * t640 * t641) + 0.58482233974552040708313425006184496242808878304904e0 * t158 * t629 - 0.58482233974552040708313425006184496242808878304904e0 * t649 * t632 * t640 * t641) / 0.2e1)
  t661 = t115 * t451
  t664 = 0.11073577833333333333333333333333333333333333333333e-2 * t113 * t661 * t304
  t665 = t301 ** 2
  t670 = t112 * t115
  t671 = t670 * t451
  t672 = 0.1e1 / t293 * t1 * t671
  t674 = t113 * t661
  t676 = t290 ** 0.5e0
  t678 = t676 * t1 * t671
  t681 = t134 * t114 * t479
  t686 = t292 / t665 * (-0.39359651450000000000000000000000000000000000000000e-1 * t672 - 0.18590345266666666666666666666666666666666666666667e-1 * t674 - 0.63666595250000000000000000000000000000000000000000e-2 * t678 - 0.51086658466666666666666666666666666666666666666667e-2 * t681) / t303
  t690 = 0.4e1 * t306 * t105 * t310 * t342
  t695 = 0.4e1 * t307 / t309 / t5 * t342
  t698 = f.my_piecewise3(t108, 0, 0.4e1 / 0.3e1 * t120 * t447)
  t701 = f.my_piecewise3(t213, 0, 0.4e1 / 0.3e1 * t216 * t570)
  t703 = (t698 + t701) * t157
  t709 = t324 ** 2
  t723 = t335 ** 2
  t724 = 0.1e1 / t723
  t730 = -0.29149776500000000000000000000000000000000000000000e-1 * t672 - 0.10197214950000000000000000000000000000000000000000e-1 * t674 - 0.18581188275000000000000000000000000000000000000000e-2 * t678 - 0.27959805900000000000000000000000000000000000000000e-2 * t681
  t731 = 0.1e1 / t337
  t737 = t311 * t317 * (0.53236443333333333333333333333333333333333333333333e-3 * t113 * t661 * t327 + t319 / t709 * (-0.36579716750000000000000000000000000000000000000000e-1 * t672 - 0.16057207750000000000000000000000000000000000000000e-1 * t674 - 0.65409473750000000000000000000000000000000000000000e-2 * t678 - 0.32394225500000000000000000000000000000000000000000e-2 * t681) / t326 - t664 - t686 + 0.18311555036753159941307229983139571945136646663793e-3 * t113 * t661 * t338 + 0.58482233974552040708313425006184496242808878304904e0 * t330 * t724 * t730 * t731)
  t744 = 0.18311555036753159941307229983139571945136646663793e-3 * t317 * t1 * t670 * t451 * t338
  t749 = 0.58482233974552040708313425006184496242808878304904e0 * t317 * t330 * t724 * t730 * t731
  t750 = t664 + t686 + t690 - t695 + t311 * t703 * t341 + t737 + 0.58482233974552040708313425006184496242808878304904e0 * t703 * t339 - t744 - t749 - t541 - t658
  t752 = t39 * t357
  t758 = t349 / t356 / t355 * t352
  t761 = t349 * t361
  t764 = t355 ** 2
  t767 = t360 / t764 * t352
  t772 = -0.3e1 / 0.8e1 * t4 * t382 * t19 * t56 - t390 - 0.3e1 / 0.8e1 * t4 * t20 * (-0.40834444444444444444444444444444444444444444444444e-1 * t401 * t402 + 0.44917888888888888888888888888888888888888888888887e-2 * t408 * t409 - 0.17355555555555555555555555555555555555555555555555e-1 * t412 * t409 + 0.19091111111111111111111111111111111111111111111110e-2 * t418 * t409) - 0.3e1 / 0.8e1 * t4 * t437 * t19 * t100 - t445 + t541 * t202 * t209 + t189 * (0.85404444444444444444444444444444444444444444444445e0 * t401 * t544 - 0.13664711111111111111111111111111111111111111111111e1 * t550 * t409 - 0.16040888888888888888888888888888888888888888888889e1 * t553 * t409 + 0.25665422222222222222222222222222222222222222222222e1 * t559 * t409) * t209 + t203 * s0 / t26 * t206 / 0.8e1 + t658 * t280 * t287 + t750 * t364 + t346 * (0.88343888888888888888888888888888888888888888888889e-1 * t401 * t752 - 0.12368144444444444444444444444444444444444444444445e-1 * t758 * t409 - 0.74635555555555555555555555555555555555555555555556e-1 * t761 * t409 + 0.10448977777777777777777777777777777777777777777778e-1 * t767 * t409)
  vrho_0_ = t5 * t772 - t103 + t210 + t288 + t365 - t59
  t779 = f.my_piecewise3(t9, 0, -t372 - 0.2e1 / 0.3e1 * t12 * t26 * t430 * t374)
  t793 = f.my_piecewise3(t62, 0, 0.2e1 * t366 * t64 - t427 + 0.2e1 / 0.3e1 * t63 * t6 * t432 * (-r1 * t369 + t6))
  t808 = (-0.5e1 / 0.3e1 * tau1 * t77 + s2 / t71 / t75 / r1 / 0.3e1 + 0.5e1 / 0.12e2 * l1 * t77) * t34
  t809 = t39 * t93
  t815 = t86 / t92 / t91 * t88
  t816 = t808 * t39
  t819 = t86 * t97
  t822 = t91 ** 2
  t825 = t96 / t822 * t88
  t832 = -t6 - t446
  t833 = f.my_piecewise3(t108, 0, t832)
  t837 = f.my_piecewise3(t108, 0, -t456 * t832 / 0.3e1)
  t839 = t116 * t118 * t837
  t842 = (-t455 + 0.33220733500000000000000000000000000000000000000000e-2 * t839) * t147
  t843 = -t469 + t839
  t844 = t468 * t843
  t847 = t475 * t843
  t851 = t135 * t139 * t122 * t837
  t855 = t467 * (0.11807895435000000000000000000000000000000000000000e0 * t844 - t473 + 0.55771035800000000000000000000000000000000000000000e-1 * t839 + 0.19099978575000000000000000000000000000000000000000e-1 * t847 - t483 + 0.15325997540000000000000000000000000000000000000000e-1 * t851) * t489
  t868 = (-t509 + 0.93933937500000000000000000000000000000000000000000e-3 * t839) * t179
  t874 = 0.87449329500000000000000000000000000000000000000000e-1 * t844 - t518 + 0.30591644850000000000000000000000000000000000000000e-1 * t839 + 0.55743564825000000000000000000000000000000000000000e-2 * t847 - t521 + 0.83879417700000000000000000000000000000000000000000e-2 * t851
  t890 = f.my_piecewise3(t109, 0, t833 * t186 / 0.2e1 + t110 * (-t842 + t855 + t158 * (-(-t492 + 0.15970933000000000000000000000000000000000000000000e-2 * t839) * t168 + t498 * (0.10973915025000000000000000000000000000000000000000e0 * t844 - t500 + 0.48171623250000000000000000000000000000000000000000e-1 * t839 + 0.19622842125000000000000000000000000000000000000000e-1 * t847 - t503 + 0.97182676500000000000000000000000000000000000000000e-2 * t851) * t506 + t842 - t855 - 0.58482233974552040708313425006184496242808878304904e0 * t868 + 0.58482233974552040708313425006184496242808878304904e0 * t516 * t874 * t524) + 0.58482233974552040708313425006184496242808878304904e0 * t158 * t868 - 0.58482233974552040708313425006184496242808878304904e0 * t532 * t515 * t874 * t524) / 0.2e1)
  t893 = -t832
  t894 = f.my_piecewise3(t213, 0, t893)
  t898 = f.my_piecewise3(t213, 0, -t576 * t893 / 0.3e1)
  t900 = t116 * t118 * t898
  t903 = (-t575 + 0.33220733500000000000000000000000000000000000000000e-2 * t900) * t235
  t904 = -t589 + t900
  t905 = t588 * t904
  t908 = t595 * t904
  t912 = t135 * t139 * t218 * t898
  t916 = t587 * (0.11807895435000000000000000000000000000000000000000e0 * t905 - t593 + 0.55771035800000000000000000000000000000000000000000e-1 * t900 + 0.19099978575000000000000000000000000000000000000000e-1 * t908 - t600 + 0.15325997540000000000000000000000000000000000000000e-1 * t912) * t606
  t929 = (-t626 + 0.93933937500000000000000000000000000000000000000000e-3 * t900) * t257
  t935 = 0.87449329500000000000000000000000000000000000000000e-1 * t905 - t635 + 0.30591644850000000000000000000000000000000000000000e-1 * t900 + 0.55743564825000000000000000000000000000000000000000e-2 * t908 - t638 + 0.83879417700000000000000000000000000000000000000000e-2 * t912
  t951 = f.my_piecewise3(t214, 0, t894 * t264 / 0.2e1 + t215 * (-t903 + t916 + t158 * (-(-t609 + 0.15970933000000000000000000000000000000000000000000e-2 * t900) * t246 + t615 * (0.10973915025000000000000000000000000000000000000000e0 * t905 - t617 + 0.48171623250000000000000000000000000000000000000000e-1 * t900 + 0.19622842125000000000000000000000000000000000000000e-1 * t908 - t620 + 0.97182676500000000000000000000000000000000000000000e-2 * t912) * t623 + t903 - t916 - 0.58482233974552040708313425006184496242808878304904e0 * t929 + 0.58482233974552040708313425006184496242808878304904e0 * t633 * t935 * t641) + 0.58482233974552040708313425006184496242808878304904e0 * t158 * t929 - 0.58482233974552040708313425006184496242808878304904e0 * t649 * t632 * t935 * t641) / 0.2e1)
  t954 = t39 * t273
  t960 = t269 / t272 / t271 * t88
  t963 = t269 * t277
  t966 = t271 ** 2
  t969 = t276 / t966 * t88
  t982 = f.my_piecewise3(t108, 0, 0.4e1 / 0.3e1 * t120 * t832)
  t985 = f.my_piecewise3(t213, 0, 0.4e1 / 0.3e1 * t216 * t893)
  t987 = (t982 + t985) * t157
  t992 = t664 + t686 - t690 - t695 + t311 * t987 * t341 + t737 + 0.58482233974552040708313425006184496242808878304904e0 * t987 * t339 - t744 - t749 - t890 - t951
  t1004 = -0.3e1 / 0.8e1 * t4 * t779 * t19 * t56 - t390 - 0.3e1 / 0.8e1 * t4 * t793 * t19 * t100 - t445 - 0.3e1 / 0.8e1 * t4 * t69 * (-0.40834444444444444444444444444444444444444444444444e-1 * t808 * t809 + 0.44917888888888888888888888888888888888888888888887e-2 * t815 * t816 - 0.17355555555555555555555555555555555555555555555555e-1 * t819 * t816 + 0.19091111111111111111111111111111111111111111111110e-2 * t825 * t816) + t890 * t202 * t209 + t951 * t280 * t287 + t267 * (0.85404444444444444444444444444444444444444444444445e0 * t808 * t954 - 0.13664711111111111111111111111111111111111111111111e1 * t960 * t816 - 0.16040888888888888888888888888888888888888888888889e1 * t963 * t816 + 0.25665422222222222222222222222222222222222222222222e1 * t969 * t816) * t287 + t281 * s2 / t75 * t284 / 0.8e1 + t992 * t364 + t346 * (0.88343888888888888888888888888888888888888888888889e-1 * t808 * t752 - 0.12368144444444444444444444444444444444444444444445e-1 * t758 * t816 - 0.74635555555555555555555555555555555555555555555556e-1 * t761 * t816 + 0.10448977777777777777777777777777777777777777777778e-1 * t767 * t816)
  vrho_1_ = t5 * t1004 - t103 + t210 + t288 + t365 - t59
  t1006 = t28 * t34
  t1009 = t1006 * t39
  vsigma_0_ = t5 * (-0.3e1 / 0.8e1 * t4 * t20 * (0.51043055555555555555555555555555555555555555555556e-2 * t1006 * t402 - 0.56147361111111111111111111111111111111111111111113e-3 * t408 * t1009 + 0.21694444444444444444444444444444444444444444444445e-2 * t412 * t1009 - 0.23863888888888888888888888888888888888888888888890e-3 * t418 * t1009) + t189 * (-0.10675555555555555555555555555555555555555555555555e0 * t1006 * t544 + 0.17080888888888888888888888888888888888888888888889e0 * t550 * t1009 + 0.20051111111111111111111111111111111111111111111111e0 * t553 * t1009 - 0.32081777777777777777777777777777777777777777777778e0 * t559 * t1009) * t209 - t203 * t204 * t206 / 0.8e1 + t346 * (-0.11042986111111111111111111111111111111111111111111e-1 * t1006 * t752 + 0.15460180555555555555555555555555555555555555555555e-2 * t758 * t1009 + 0.93294444444444444444444444444444444444444444444444e-2 * t761 * t1009 - 0.13061222222222222222222222222222222222222222222222e-2 * t767 * t1009))
  vsigma_1_ = 0.0e0
  t1045 = t77 * t34
  t1048 = t1045 * t39
  vsigma_2_ = t5 * (-0.3e1 / 0.8e1 * t4 * t69 * (0.51043055555555555555555555555555555555555555555556e-2 * t1045 * t809 - 0.56147361111111111111111111111111111111111111111113e-3 * t815 * t1048 + 0.21694444444444444444444444444444444444444444444445e-2 * t819 * t1048 - 0.23863888888888888888888888888888888888888888888890e-3 * t825 * t1048) + t267 * (-0.10675555555555555555555555555555555555555555555555e0 * t1045 * t954 + 0.17080888888888888888888888888888888888888888888889e0 * t960 * t1048 + 0.20051111111111111111111111111111111111111111111111e0 * t963 * t1048 - 0.32081777777777777777777777777777777777777777777778e0 * t969 * t1048) * t287 - t281 * t282 * t284 / 0.8e1 + t346 * (-0.11042986111111111111111111111111111111111111111111e-1 * t1045 * t752 + 0.15460180555555555555555555555555555555555555555555e-2 * t758 * t1048 + 0.93294444444444444444444444444444444444444444444444e-2 * t761 * t1048 - 0.13061222222222222222222222222222222222222222222222e-2 * t767 * t1048))
  t1084 = t24 * t34
  t1085 = t1084 * t402
  t1087 = t1084 * t39
  t1088 = t408 * t1087
  t1090 = t412 * t1087
  t1092 = t418 * t1087
  t1098 = t1084 * t544
  t1100 = t550 * t1087
  t1102 = t553 * t1087
  t1104 = t559 * t1087
  t1109 = t1084 * t752
  t1111 = t758 * t1087
  t1113 = t761 * t1087
  t1115 = t767 * t1087
  vlapl_0_ = t5 * (-0.3e1 / 0.8e1 * t4 * t20 * (0.10208611111111111111111111111111111111111111111111e-1 * t1085 - 0.11229472222222222222222222222222222222222222222223e-2 * t1088 + 0.43388888888888888888888888888888888888888888888890e-2 * t1090 - 0.47727777777777777777777777777777777777777777777778e-3 * t1092) + t189 * (-0.21351111111111111111111111111111111111111111111111e0 * t1098 + 0.34161777777777777777777777777777777777777777777778e0 * t1100 + 0.40102222222222222222222222222222222222222222222222e0 * t1102 - 0.64163555555555555555555555555555555555555555555555e0 * t1104) * t209 + t346 * (-0.22085972222222222222222222222222222222222222222222e-1 * t1109 + 0.30920361111111111111111111111111111111111111111111e-2 * t1111 + 0.18658888888888888888888888888888888888888888888888e-1 * t1113 - 0.26122444444444444444444444444444444444444444444444e-2 * t1115))
  t1120 = t73 * t34
  t1121 = t1120 * t809
  t1123 = t1120 * t39
  t1124 = t815 * t1123
  t1126 = t819 * t1123
  t1128 = t825 * t1123
  t1134 = t1120 * t954
  t1136 = t960 * t1123
  t1138 = t963 * t1123
  t1140 = t969 * t1123
  t1145 = t1120 * t752
  t1147 = t758 * t1123
  t1149 = t761 * t1123
  t1151 = t767 * t1123
  vlapl_1_ = t5 * (-0.3e1 / 0.8e1 * t4 * t69 * (0.10208611111111111111111111111111111111111111111111e-1 * t1121 - 0.11229472222222222222222222222222222222222222222223e-2 * t1124 + 0.43388888888888888888888888888888888888888888888890e-2 * t1126 - 0.47727777777777777777777777777777777777777777777778e-3 * t1128) + t267 * (-0.21351111111111111111111111111111111111111111111111e0 * t1134 + 0.34161777777777777777777777777777777777777777777778e0 * t1136 + 0.40102222222222222222222222222222222222222222222222e0 * t1138 - 0.64163555555555555555555555555555555555555555555555e0 * t1140) * t287 + t346 * (-0.22085972222222222222222222222222222222222222222222e-1 * t1145 + 0.30920361111111111111111111111111111111111111111111e-2 * t1147 + 0.18658888888888888888888888888888888888888888888888e-1 * t1149 - 0.26122444444444444444444444444444444444444444444444e-2 * t1151))
  t1171 = tau0 ** 2
  vtau_0_ = t5 * (-0.3e1 / 0.8e1 * t4 * t20 * (-0.40834444444444444444444444444444444444444444444444e-1 * t1085 + 0.44917888888888888888888888888888888888888888888887e-2 * t1088 - 0.17355555555555555555555555555555555555555555555555e-1 * t1090 + 0.19091111111111111111111111111111111111111111111110e-2 * t1092) + t189 * (0.85404444444444444444444444444444444444444444444445e0 * t1098 - 0.13664711111111111111111111111111111111111111111111e1 * t1100 - 0.16040888888888888888888888888888888888888888888889e1 * t1102 + 0.25665422222222222222222222222222222222222222222222e1 * t1104) * t209 + t203 * t205 / t1171 / 0.8e1 + t346 * (0.88343888888888888888888888888888888888888888888889e-1 * t1109 - 0.12368144444444444444444444444444444444444444444445e-1 * t1111 - 0.74635555555555555555555555555555555555555555555556e-1 * t1113 + 0.10448977777777777777777777777777777777777777777778e-1 * t1115))
  t1198 = tau1 ** 2
  vtau_1_ = t5 * (-0.3e1 / 0.8e1 * t4 * t69 * (-0.40834444444444444444444444444444444444444444444444e-1 * t1121 + 0.44917888888888888888888888888888888888888888888887e-2 * t1124 - 0.17355555555555555555555555555555555555555555555555e-1 * t1126 + 0.19091111111111111111111111111111111111111111111110e-2 * t1128) + t267 * (0.85404444444444444444444444444444444444444444444445e0 * t1134 - 0.13664711111111111111111111111111111111111111111111e1 * t1136 - 0.16040888888888888888888888888888888888888888888889e1 * t1138 + 0.25665422222222222222222222222222222222222222222222e1 * t1140) * t287 + t281 * t283 / t1198 / 0.8e1 + t346 * (0.88343888888888888888888888888888888888888888888889e-1 * t1145 - 0.12368144444444444444444444444444444444444444444445e-1 * t1147 - 0.74635555555555555555555555555555555555555555555556e-1 * t1149 + 0.10448977777777777777777777777777777777777777777778e-1 * t1151))
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  params_pp = np.array([np.nan, 1, 1, 1], dtype=np.float64)

  params_a = np.array([np.nan, 0.031091, 0.015545, 0.016887], dtype=np.float64)

  params_alpha1 = np.array([np.nan, 0.2137, 0.20548, 0.11125], dtype=np.float64)

  params_beta1 = np.array([np.nan, 7.5957, 14.1189, 10.357], dtype=np.float64)

  params_beta2 = np.array([np.nan, 3.5876, 6.1977, 3.6231], dtype=np.float64)

  params_beta3 = np.array([np.nan, 1.6382, 3.3662, 0.88026], dtype=np.float64)

  params_beta4 = np.array([np.nan, 0.49294, 0.62517, 0.49671], dtype=np.float64)

  params_fz20 = 1.709921

  b98_gamma_x = 0.11

  b98_gamma_ss = 1.6

  b98_gamma_ab = 0.14

  params_c_x = np.array([np.nan, 0.8085, 0.6682, 0.142], dtype=np.float64)

  params_c_ss = np.array([np.nan, 0.2606, -0.9608, 0.9023], dtype=np.float64)

  params_c_ab = np.array([np.nan, 1.2033, -2.2717, 0.9596], dtype=np.float64)

  b98_q = lambda x, u, t: 1 - (t - x ** 2 / 8 - u / 4) / K_FACTOR_C

  b98_g = lambda gamma, cc, q: jnp.sum(jnp.array([cc[i] * (gamma * q / jnp.sqrt(1 + gamma ** 2 * q ** 2)) ** (i - 1) for i in range(1, 3 + 1)]), axis=0)

  g_aux = lambda k, rs: params_beta1[k] * jnp.sqrt(rs) + params_beta2[k] * rs + params_beta3[k] * rs ** 1.5 + params_beta4[k] * rs ** (params_pp[k] + 1)

  g = lambda k, rs: -2 * params_a[k] * (1 + params_alpha1[k] * rs) * jnp.log(1 + 1 / (2 * params_a[k] * g_aux(k, rs)))

  f_pw = lambda rs, zeta: g(1, rs) + zeta ** 4 * f.f_zeta(zeta) * (g(2, rs) - g(1, rs) + g(3, rs) / params_fz20) - f.f_zeta(zeta) * g(3, rs) / params_fz20

  b98_f = lambda rs, z, xs0, xs1, us0, us1, ts0, ts1: +f.lda_x_spin(rs, z) * b98_g(b98_gamma_x, params_c_x, b98_q(xs0, us0, ts0)) + f.lda_x_spin(rs, -z) * b98_g(b98_gamma_x, params_c_x, b98_q(xs1, us1, ts1)) + lda_stoll_par(f, params, f_pw, rs, z, 1) * b98_g(b98_gamma_ss, params_c_ss, b98_q(xs0, us0, ts0)) * f.Fermi_D(xs0, ts0) + lda_stoll_par(f, params, f_pw, rs, -z, -1) * b98_g(b98_gamma_ss, params_c_ss, b98_q(xs1, us1, ts1)) * f.Fermi_D(xs1, ts1) + lda_stoll_perp(f, params, f_pw, rs, z) * b98_g(b98_gamma_ab, params_c_ab, (b98_q(xs0, us0, ts0) + b98_q(xs1, us1, ts1)) / 2)

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0, ts1: b98_f(rs, z, xs0, xs1, us0, us1, ts0, ts1)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = jnp.pi ** (0.1e1 / 0.3e1)
  t4 = t1 / t2
  t5 = 0.1e1 <= f.p.zeta_threshold
  t6 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t7 = t6 * f.p.zeta_threshold
  t8 = f.my_piecewise3(t5, t7, 1)
  t9 = r0 ** (0.1e1 / 0.3e1)
  t10 = t8 * t9
  t11 = 2 ** (0.1e1 / 0.3e1)
  t12 = t11 ** 2
  t13 = tau0 * t12
  t14 = t9 ** 2
  t16 = 0.1e1 / t14 / r0
  t18 = s0 * t12
  t19 = r0 ** 2
  t21 = 0.1e1 / t14 / t19
  t24 = l0 * t12
  t28 = 6 ** (0.1e1 / 0.3e1)
  t30 = jnp.pi ** 2
  t31 = t30 ** (0.1e1 / 0.3e1)
  t32 = t31 ** 2
  t33 = 0.1e1 / t32
  t34 = (t13 * t16 - t18 * t21 / 0.8e1 - t24 * t16 / 0.4e1) * t28 * t33
  t36 = 0.11e0 - 0.61111111111111111111111111111111111111111111111111e-1 * t34
  t38 = 0.1e1 - 0.5e1 / 0.9e1 * t34
  t39 = t38 ** 2
  t41 = 0.1e1 + 0.121e-1 * t39
  t42 = jnp.sqrt(t41)
  t43 = 0.1e1 / t42
  t46 = t36 ** 2
  t47 = 0.1e1 / t41
  t50 = 0.8085e0 + 0.6682e0 * t36 * t43 + 0.1420e0 * t46 * t47
  t56 = r0 / 0.2e1 <= f.p.dens_threshold or t5
  t57 = f.my_piecewise3(t5, f.p.zeta_threshold, 1)
  t59 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t60 = t1 * t59
  t61 = 4 ** (0.1e1 / 0.3e1)
  t62 = t61 ** 2
  t63 = t60 * t62
  t64 = 0.1e1 / t9
  t67 = f.my_piecewise3(t5, 0.1e1 / t6, 1)
  t69 = t63 * t64 * t11 * t67
  t71 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t69
  t72 = jnp.sqrt(t69)
  t75 = t69 ** 0.15e1
  t77 = t1 ** 2
  t78 = t59 ** 2
  t79 = t77 * t78
  t80 = t79 * t61
  t81 = 0.1e1 / t14
  t83 = t67 ** 2
  t85 = t80 * t81 * t12 * t83
  t87 = 0.23615790870000000000000000000000000000000000000000e0 * t72 + 0.55771035800000000000000000000000000000000000000000e-1 * t69 + 0.12733319050000000000000000000000000000000000000000e-1 * t75 + 0.76629987700000000000000000000000000000000000000000e-2 * t85
  t89 = 0.1e1 + 0.1e1 / t87
  t90 = jnp.log(t89)
  t91 = t71 * t90
  t94 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t7, 0.2e1 * t11)
  t96 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t7, 0)
  t100 = 0.1e1 / (0.2e1 * t11 - 0.2e1)
  t101 = (t94 + t96 - 0.2e1) * t100
  t103 = 0.31090e-1 + 0.15970933000000000000000000000000000000000000000000e-2 * t69
  t108 = 0.21947830050000000000000000000000000000000000000000e0 * t72 + 0.48171623250000000000000000000000000000000000000000e-1 * t69 + 0.13081894750000000000000000000000000000000000000000e-1 * t75 + 0.48591338250000000000000000000000000000000000000000e-2 * t85
  t110 = 0.1e1 + 0.1e1 / t108
  t111 = jnp.log(t110)
  t114 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t69
  t119 = 0.17489865900000000000000000000000000000000000000000e0 * t72 + 0.30591644850000000000000000000000000000000000000000e-1 * t69 + 0.37162376550000000000000000000000000000000000000000e-2 * t75 + 0.41939708850000000000000000000000000000000000000000e-2 * t85
  t121 = 0.1e1 + 0.1e1 / t119
  t122 = jnp.log(t121)
  t123 = t114 * t122
  t132 = f.my_piecewise3(t56, 0, t57 * (-t91 + t101 * (-t103 * t111 + t91 - 0.58482233974552040708313425006184496242808878304904e0 * t123) + 0.58482233974552040708313425006184496242808878304904e0 * t101 * t123) / 0.2e1)
  t134 = 0.16e1 - 0.88888888888888888888888888888888888888888888888889e0 * t34
  t136 = 0.1e1 + 0.256e1 * t39
  t137 = jnp.sqrt(t136)
  t138 = 0.1e1 / t137
  t141 = t134 ** 2
  t142 = 0.1e1 / t136
  t145 = 0.2606e0 - 0.9608e0 * t134 * t138 + 0.9023e0 * t141 * t142
  t146 = t132 * t145
  t147 = 0.1e1 / r0
  t148 = s0 * t147
  t149 = 0.1e1 / tau0
  t152 = 0.1e1 - t148 * t149 / 0.8e1
  t156 = t60 * t62 * t64
  t158 = 0.62182e-1 + 0.33220733500000000000000000000000000000000000000000e-2 * t156
  t159 = jnp.sqrt(t156)
  t162 = t156 ** 0.15e1
  t165 = t79 * t61 * t81
  t167 = 0.23615790870000000000000000000000000000000000000000e0 * t159 + 0.55771035800000000000000000000000000000000000000000e-1 * t156 + 0.12733319050000000000000000000000000000000000000000e-1 * t162 + 0.76629987700000000000000000000000000000000000000000e-2 * t165
  t169 = 0.1e1 + 0.1e1 / t167
  t170 = jnp.log(t169)
  t174 = (0.2e1 * t8 - 0.2e1) * t100
  t176 = 0.33774e-1 + 0.93933937500000000000000000000000000000000000000000e-3 * t156
  t181 = 0.17489865900000000000000000000000000000000000000000e0 * t159 + 0.30591644850000000000000000000000000000000000000000e-1 * t156 + 0.37162376550000000000000000000000000000000000000000e-2 * t162 + 0.41939708850000000000000000000000000000000000000000e-2 * t165
  t183 = 0.1e1 + 0.1e1 / t181
  t184 = jnp.log(t183)
  t189 = -t158 * t170 + 0.58482233974552040708313425006184496242808878304904e0 * t174 * t176 * t184 - 0.2e1 * t132
  t191 = 0.14e0 - 0.77777777777777777777777777777777777777777777777778e-1 * t34
  t193 = 0.1e1 + 0.196e-1 * t39
  t194 = jnp.sqrt(t193)
  t195 = 0.1e1 / t194
  t198 = t191 ** 2
  t199 = 0.1e1 / t193
  t202 = 0.12033e1 - 0.22717e1 * t191 * t195 + 0.9596e0 * t198 * t199
  t218 = (-0.5e1 / 0.3e1 * t13 * t21 + t18 / t14 / t19 / r0 / 0.3e1 + 0.5e1 / 0.12e2 * t24 * t21) * t28
  t225 = t36 / t42 / t41 * t38
  t226 = t218 * t33
  t229 = t36 * t47
  t232 = t41 ** 2
  t235 = t46 / t232 * t38
  t243 = 0.1e1 / t9 / r0
  t244 = t243 * t11
  t248 = 0.11073577833333333333333333333333333333333333333333e-2 * t63 * t244 * t67 * t90
  t249 = t87 ** 2
  t255 = t62 * t243
  t256 = t11 * t67
  t257 = t255 * t256
  t258 = 0.1e1 / t72 * t1 * t59 * t257
  t261 = t63 * t244 * t67
  t263 = t69 ** 0.5e0
  t266 = t263 * t1 * t59 * t257
  t268 = t16 * t12
  t270 = t80 * t268 * t83
  t275 = t71 / t249 * (-0.39359651450000000000000000000000000000000000000000e-1 * t258 - 0.18590345266666666666666666666666666666666666666667e-1 * t261 - 0.63666595250000000000000000000000000000000000000000e-2 * t266 - 0.51086658466666666666666666666666666666666666666667e-2 * t270) / t89
  t280 = t108 ** 2
  t295 = t119 ** 2
  t296 = 0.1e1 / t295
  t302 = -0.29149776500000000000000000000000000000000000000000e-1 * t258 - 0.10197214950000000000000000000000000000000000000000e-1 * t261 - 0.18581188275000000000000000000000000000000000000000e-2 * t266 - 0.27959805900000000000000000000000000000000000000000e-2 * t270
  t303 = 0.1e1 / t121
  t322 = f.my_piecewise3(t56, 0, t57 * (t248 + t275 + t101 * (0.53236443333333333333333333333333333333333333333333e-3 * t63 * t244 * t67 * t111 + t103 / t280 * (-0.36579716750000000000000000000000000000000000000000e-1 * t258 - 0.16057207750000000000000000000000000000000000000000e-1 * t261 - 0.65409473750000000000000000000000000000000000000000e-2 * t266 - 0.32394225500000000000000000000000000000000000000000e-2 * t270) / t110 - t248 - t275 + 0.18311555036753159941307229983139571945136646663793e-3 * t63 * t244 * t67 * t122 + 0.58482233974552040708313425006184496242808878304904e0 * t114 * t296 * t302 * t303) - 0.18311555036753159941307229983139571945136646663793e-3 * t101 * t60 * t255 * t256 * t122 - 0.58482233974552040708313425006184496242808878304904e0 * t101 * t114 * t296 * t302 * t303) / 0.2e1)
  t332 = t134 / t137 / t136 * t38
  t335 = t134 * t142
  t338 = t136 ** 2
  t341 = t141 / t338 * t38
  t356 = t167 ** 2
  t361 = t59 * t62
  t362 = t361 * t243
  t363 = 0.1e1 / t159 * t1 * t362
  t365 = t60 * t255
  t367 = t156 ** 0.5e0
  t369 = t367 * t1 * t362
  t372 = t79 * t61 * t16
  t384 = t181 ** 2
  t405 = t191 / t194 / t193 * t38
  t408 = t191 * t199
  t411 = t193 ** 2
  t414 = t198 / t411 * t38
  vrho_0_ = -0.3e1 / 0.4e1 * t4 * t10 * t50 + 0.2e1 * t146 * t152 + t189 * t202 + r0 * (-t4 * t8 * t81 * t50 / 0.4e1 - 0.3e1 / 0.4e1 * t4 * t10 * (-0.40834444444444444444444444444444444444444444444444e-1 * t218 * t33 * t43 + 0.44917888888888888888888888888888888888888888888887e-2 * t225 * t226 - 0.17355555555555555555555555555555555555555555555555e-1 * t229 * t226 + 0.19091111111111111111111111111111111111111111111110e-2 * t235 * t226) + 0.2e1 * t322 * t145 * t152 + 0.2e1 * t132 * (0.85404444444444444444444444444444444444444444444445e0 * t218 * t33 * t138 - 0.13664711111111111111111111111111111111111111111111e1 * t332 * t226 - 0.16040888888888888888888888888888888888888888888889e1 * t335 * t226 + 0.25665422222222222222222222222222222222222222222222e1 * t341 * t226) * t152 + t146 * s0 / t19 * t149 / 0.4e1 + (0.11073577833333333333333333333333333333333333333333e-2 * t60 * t255 * t170 + t158 / t356 * (-0.39359651450000000000000000000000000000000000000000e-1 * t363 - 0.18590345266666666666666666666666666666666666666667e-1 * t365 - 0.63666595250000000000000000000000000000000000000000e-2 * t369 - 0.51086658466666666666666666666666666666666666666667e-2 * t372) / t169 - 0.18311555036753159941307229983139571945136646663793e-3 * t174 * t1 * t361 * t243 * t184 - 0.58482233974552040708313425006184496242808878304904e0 * t174 * t176 / t384 * (-0.29149776500000000000000000000000000000000000000000e-1 * t363 - 0.10197214950000000000000000000000000000000000000000e-1 * t365 - 0.18581188275000000000000000000000000000000000000000e-2 * t369 - 0.27959805900000000000000000000000000000000000000000e-2 * t372) / t183 - 0.2e1 * t322) * t202 + t189 * (0.17668777777777777777777777777777777777777777777778e0 * t218 * t33 * t195 - 0.24736288888888888888888888888888888888888888888889e-1 * t405 * t226 - 0.14927111111111111111111111111111111111111111111112e0 * t408 * t226 + 0.20897955555555555555555555555555555555555555555556e-1 * t414 * t226))
  t421 = t12 * t21
  t422 = t28 * t33
  t423 = t422 * t43
  t426 = t421 * t422
  t429 = t229 * t12
  t431 = t21 * t28 * t33
  t440 = t422 * t138
  t445 = t335 * t12
  t457 = t422 * t195
  t462 = t408 * t12
  vsigma_0_ = r0 * (-0.3e1 / 0.4e1 * t4 * t10 * (0.51043055555555555555555555555555555555555555555556e-2 * t421 * t423 - 0.56147361111111111111111111111111111111111111111113e-3 * t225 * t426 + 0.21694444444444444444444444444444444444444444444445e-2 * t429 * t431 - 0.23863888888888888888888888888888888888888888888890e-3 * t235 * t426) + 0.2e1 * t132 * (-0.10675555555555555555555555555555555555555555555555e0 * t421 * t440 + 0.17080888888888888888888888888888888888888888888889e0 * t332 * t426 + 0.20051111111111111111111111111111111111111111111111e0 * t445 * t431 - 0.32081777777777777777777777777777777777777777777778e0 * t341 * t426) * t152 - t146 * t147 * t149 / 0.4e1 + t189 * (-0.22085972222222222222222222222222222222222222222222e-1 * t421 * t457 + 0.30920361111111111111111111111111111111111111111111e-2 * t405 * t426 + 0.18658888888888888888888888888888888888888888888888e-1 * t462 * t431 - 0.26122444444444444444444444444444444444444444444444e-2 * t414 * t426))
  t470 = t268 * t423
  t472 = t268 * t422
  t473 = t225 * t472
  t476 = t16 * t28 * t33
  t477 = t429 * t476
  t479 = t235 * t472
  t485 = t268 * t440
  t487 = t332 * t472
  t489 = t445 * t476
  t491 = t341 * t472
  t497 = t268 * t457
  t499 = t405 * t472
  t501 = t462 * t476
  t503 = t414 * t472
  vlapl_0_ = r0 * (-0.3e1 / 0.4e1 * t4 * t10 * (0.10208611111111111111111111111111111111111111111111e-1 * t470 - 0.11229472222222222222222222222222222222222222222223e-2 * t473 + 0.43388888888888888888888888888888888888888888888890e-2 * t477 - 0.47727777777777777777777777777777777777777777777778e-3 * t479) + 0.2e1 * t132 * (-0.21351111111111111111111111111111111111111111111111e0 * t485 + 0.34161777777777777777777777777777777777777777777778e0 * t487 + 0.40102222222222222222222222222222222222222222222222e0 * t489 - 0.64163555555555555555555555555555555555555555555555e0 * t491) * t152 + t189 * (-0.44171944444444444444444444444444444444444444444443e-1 * t497 + 0.61840722222222222222222222222222222222222222222222e-2 * t499 + 0.37317777777777777777777777777777777777777777777777e-1 * t501 - 0.52244888888888888888888888888888888888888888888888e-2 * t503))
  t524 = tau0 ** 2
  vtau_0_ = r0 * (-0.3e1 / 0.4e1 * t4 * t10 * (-0.40834444444444444444444444444444444444444444444444e-1 * t470 + 0.44917888888888888888888888888888888888888888888887e-2 * t473 - 0.17355555555555555555555555555555555555555555555555e-1 * t477 + 0.19091111111111111111111111111111111111111111111110e-2 * t479) + 0.2e1 * t132 * (0.85404444444444444444444444444444444444444444444445e0 * t485 - 0.13664711111111111111111111111111111111111111111111e1 * t487 - 0.16040888888888888888888888888888888888888888888889e1 * t489 + 0.25665422222222222222222222222222222222222222222222e1 * t491) * t152 + t146 * t148 / t524 / 0.4e1 + t189 * (0.17668777777777777777777777777777777777777777777778e0 * t497 - 0.24736288888888888888888888888888888888888888888889e-1 * t499 - 0.14927111111111111111111111111111111111111111111112e0 * t501 + 0.20897955555555555555555555555555555555555555555556e-1 * t503))
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = jnp.pi ** (0.1e1 / 0.3e1)
  t4 = t1 / t2
  t5 = 0.1e1 <= f.p.zeta_threshold
  t6 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t7 = t6 * f.p.zeta_threshold
  t8 = f.my_piecewise3(t5, t7, 1)
  t9 = r0 ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t11 = 0.1e1 / t10
  t12 = t8 * t11
  t13 = 2 ** (0.1e1 / 0.3e1)
  t14 = t13 ** 2
  t15 = tau0 * t14
  t17 = 0.1e1 / t10 / r0
  t19 = s0 * t14
  t20 = r0 ** 2
  t22 = 0.1e1 / t10 / t20
  t25 = l0 * t14
  t29 = 6 ** (0.1e1 / 0.3e1)
  t31 = jnp.pi ** 2
  t32 = t31 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t34 = 0.1e1 / t33
  t37 = 0.1e1 - 0.5e1 / 0.9e1 * (t15 * t17 - t19 * t22 / 0.8e1 - t25 * t17 / 0.4e1) * t29 * t34
  t38 = t37 ** 2
  t40 = 0.1e1 + 0.121e-1 * t38
  t41 = jnp.sqrt(t40)
  t42 = 0.1e1 / t41
  t45 = 0.1e1 / t40
  t48 = 0.8085e0 + 0.73502e-1 * t37 * t42 + 0.171820e-2 * t38 * t45
  t52 = t8 * t9
  t55 = t20 * r0
  t57 = 0.1e1 / t10 / t55
  t62 = -0.5e1 / 0.3e1 * t15 * t22 + t19 * t57 / 0.3e1 + 0.5e1 / 0.12e2 * t25 * t22
  t63 = t62 * t29
  t64 = t34 * t42
  t68 = 0.1e1 / t41 / t40
  t69 = t38 * t68
  t70 = t63 * t34
  t73 = t37 * t45
  t76 = t38 * t37
  t77 = t40 ** 2
  t78 = 0.1e1 / t77
  t79 = t76 * t78
  t82 = -0.40834444444444444444444444444444444444444444444444e-1 * t63 * t64 + 0.49409677777777777777777777777777777777777777777776e-3 * t69 * t70 - 0.19091111111111111111111111111111111111111111111111e-2 * t73 * t70 + 0.23100244444444444444444444444444444444444444444444e-4 * t79 * t70
  t88 = r0 / 0.2e1 <= f.p.dens_threshold or t5
  t89 = f.my_piecewise3(t5, f.p.zeta_threshold, 1)
  t91 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t92 = t1 * t91
  t93 = 4 ** (0.1e1 / 0.3e1)
  t94 = t93 ** 2
  t95 = t92 * t94
  t97 = 0.1e1 / t9 / r0
  t98 = t97 * t13
  t100 = f.my_piecewise3(t5, 0.1e1 / t6, 1)
  t101 = 0.1e1 / t9
  t104 = t95 * t101 * t13 * t100
  t105 = jnp.sqrt(t104)
  t108 = t104 ** 0.15e1
  t110 = t1 ** 2
  t111 = t91 ** 2
  t112 = t110 * t111
  t113 = t112 * t93
  t115 = t100 ** 2
  t117 = t113 * t11 * t14 * t115
  t119 = 0.37978500000000000000000000000000000000000000000000e1 * t105 + 0.89690000000000000000000000000000000000000000000000e0 * t104 + 0.20477500000000000000000000000000000000000000000000e0 * t108 + 0.12323500000000000000000000000000000000000000000000e0 * t117
  t122 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t119
  t123 = jnp.log(t122)
  t124 = t100 * t123
  t127 = 0.11073577833333333333333333333333333333333333333333e-2 * t95 * t98 * t124
  t129 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t104
  t130 = t119 ** 2
  t131 = 0.1e1 / t130
  t132 = t129 * t131
  t135 = 0.1e1 / t105 * t1 * t91
  t136 = t94 * t97
  t137 = t13 * t100
  t138 = t136 * t137
  t139 = t135 * t138
  t141 = t98 * t100
  t142 = t95 * t141
  t144 = t104 ** 0.5e0
  t146 = t144 * t1 * t91
  t147 = t146 * t138
  t151 = t113 * t17 * t14 * t115
  t153 = -0.63297500000000000000000000000000000000000000000000e0 * t139 - 0.29896666666666666666666666666666666666666666666667e0 * t142 - 0.10238750000000000000000000000000000000000000000000e0 * t147 - 0.82156666666666666666666666666666666666666666666667e-1 * t151
  t154 = 0.1e1 / t122
  t157 = 0.10000000000000000000000000000000000000000000000000e1 * t132 * t153 * t154
  t160 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t7, 0.2e1 * t13)
  t162 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t7, 0)
  t166 = 0.1e1 / (0.2e1 * t13 - 0.2e1)
  t167 = (t160 + t162 - 0.2e1) * t166
  t172 = 0.70594500000000000000000000000000000000000000000000e1 * t105 + 0.15494250000000000000000000000000000000000000000000e1 * t104 + 0.42077500000000000000000000000000000000000000000000e0 * t108 + 0.15629250000000000000000000000000000000000000000000e0 * t117
  t175 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t172
  t176 = jnp.log(t175)
  t177 = t100 * t176
  t182 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t104
  t183 = t172 ** 2
  t184 = 0.1e1 / t183
  t185 = t182 * t184
  t190 = -0.11765750000000000000000000000000000000000000000000e1 * t139 - 0.51647500000000000000000000000000000000000000000000e0 * t142 - 0.21038750000000000000000000000000000000000000000000e0 * t147 - 0.10419500000000000000000000000000000000000000000000e0 * t151
  t191 = 0.1e1 / t175
  t199 = 0.51785000000000000000000000000000000000000000000000e1 * t105 + 0.90577500000000000000000000000000000000000000000000e0 * t104 + 0.11003250000000000000000000000000000000000000000000e0 * t108 + 0.12417750000000000000000000000000000000000000000000e0 * t117
  t202 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t199
  t203 = jnp.log(t202)
  t204 = t100 * t203
  t209 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t104
  t210 = t199 ** 2
  t211 = 0.1e1 / t210
  t212 = t209 * t211
  t217 = -0.86308333333333333333333333333333333333333333333334e0 * t139 - 0.30192500000000000000000000000000000000000000000000e0 * t142 - 0.55016250000000000000000000000000000000000000000000e-1 * t147 - 0.82785000000000000000000000000000000000000000000000e-1 * t151
  t218 = 0.1e1 / t202
  t224 = t167 * t92
  t225 = t137 * t203
  t229 = t167 * t209
  t231 = t211 * t217 * t218
  t237 = f.my_piecewise3(t88, 0, t89 * (t127 + t157 + t167 * (0.53236443333333333333333333333333333333333333333332e-3 * t95 * t98 * t177 + 0.99999999999999999999999999999999999999999999999999e0 * t185 * t190 * t191 - t127 - t157 + 0.18311555036753159941307229983139571945136646663793e-3 * t95 * t98 * t204 + 0.58482233974552040708313425006184496242808878304903e0 * t212 * t217 * t218) - 0.18311555036753159941307229983139571945136646663793e-3 * t224 * t136 * t225 - 0.58482233974552040708313425006184496242808878304903e0 * t229 * t231) / 0.2e1)
  t239 = 0.1e1 + 0.256e1 * t38
  t240 = jnp.sqrt(t239)
  t241 = 0.1e1 / t240
  t244 = 0.1e1 / t239
  t247 = 0.2606e0 - 0.153728e1 * t37 * t241 + 0.2309888e1 * t38 * t244
  t248 = t237 * t247
  t251 = 0.1e1 / tau0
  t254 = 0.1e1 - s0 / r0 * t251 / 0.8e1
  t258 = 0.62182e-1 * t129 * t123
  t261 = t209 * t203
  t270 = f.my_piecewise3(t88, 0, t89 * (-t258 + t167 * (-0.31090e-1 * t182 * t176 + t258 - 0.19751789702565206228825776161588751761046270558698e-1 * t261) + 0.19751789702565206228825776161588751761046270558698e-1 * t167 * t261) / 0.2e1)
  t271 = t34 * t241
  t275 = 0.1e1 / t240 / t239
  t276 = t38 * t275
  t279 = t37 * t244
  t282 = t239 ** 2
  t283 = 0.1e1 / t282
  t284 = t76 * t283
  t287 = 0.85404444444444444444444444444444444444444444444445e0 * t63 * t271 - 0.21863537777777777777777777777777777777777777777777e1 * t276 * t70 - 0.25665422222222222222222222222222222222222222222222e1 * t279 * t70 + 0.65703480888888888888888888888888888888888888888888e1 * t284 * t70
  t288 = t270 * t287
  t291 = t270 * t247
  t294 = s0 / t20 * t251
  t298 = t92 * t94 * t101
  t299 = jnp.sqrt(t298)
  t302 = t298 ** 0.15e1
  t305 = t112 * t93 * t11
  t307 = 0.37978500000000000000000000000000000000000000000000e1 * t299 + 0.89690000000000000000000000000000000000000000000000e0 * t298 + 0.20477500000000000000000000000000000000000000000000e0 * t302 + 0.12323500000000000000000000000000000000000000000000e0 * t305
  t310 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t307
  t311 = jnp.log(t310)
  t316 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t298
  t317 = t307 ** 2
  t318 = 0.1e1 / t317
  t319 = t316 * t318
  t321 = 0.1e1 / t299 * t1
  t322 = t91 * t94
  t323 = t322 * t97
  t324 = t321 * t323
  t326 = t92 * t136
  t328 = t298 ** 0.5e0
  t329 = t328 * t1
  t330 = t329 * t323
  t333 = t112 * t93 * t17
  t335 = -0.63297500000000000000000000000000000000000000000000e0 * t324 - 0.29896666666666666666666666666666666666666666666667e0 * t326 - 0.10238750000000000000000000000000000000000000000000e0 * t330 - 0.82156666666666666666666666666666666666666666666667e-1 * t333
  t336 = 0.1e1 / t310
  t337 = t335 * t336
  t342 = (0.2e1 * t8 - 0.2e1) * t166
  t343 = t342 * t1
  t348 = 0.51785000000000000000000000000000000000000000000000e1 * t299 + 0.90577500000000000000000000000000000000000000000000e0 * t298 + 0.11003250000000000000000000000000000000000000000000e0 * t302 + 0.12417750000000000000000000000000000000000000000000e0 * t305
  t351 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t348
  t352 = jnp.log(t351)
  t358 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t298
  t359 = t342 * t358
  t360 = t348 ** 2
  t361 = 0.1e1 / t360
  t366 = -0.86308333333333333333333333333333333333333333333334e0 * t324 - 0.30192500000000000000000000000000000000000000000000e0 * t326 - 0.55016250000000000000000000000000000000000000000000e-1 * t330 - 0.82785000000000000000000000000000000000000000000000e-1 * t333
  t368 = 0.1e1 / t351
  t369 = t361 * t366 * t368
  t373 = 0.11073577833333333333333333333333333333333333333333e-2 * t92 * t136 * t311 + 0.10000000000000000000000000000000000000000000000000e1 * t319 * t337 - 0.18311555036753159941307229983139571945136646663793e-3 * t343 * t322 * t97 * t352 - 0.58482233974552040708313425006184496242808878304903e0 * t359 * t369 - 0.2e1 * t237
  t375 = 0.1e1 + 0.196e-1 * t38
  t376 = jnp.sqrt(t375)
  t377 = 0.1e1 / t376
  t380 = 0.1e1 / t375
  t383 = 0.12033e1 - 0.318038e0 * t37 * t377 + 0.1880816e-1 * t38 * t380
  t392 = -0.62182e-1 * t316 * t311 + 0.19751789702565206228825776161588751761046270558698e-1 * t342 * t358 * t352 - 0.2e1 * t270
  t393 = t34 * t377
  t397 = 0.1e1 / t376 / t375
  t398 = t38 * t397
  t401 = t37 * t380
  t404 = t375 ** 2
  t405 = 0.1e1 / t404
  t406 = t76 * t405
  t409 = 0.17668777777777777777777777777777777777777777777778e0 * t63 * t393 - 0.34630804444444444444444444444444444444444444444445e-2 * t398 * t70 - 0.20897955555555555555555555555555555555555555555556e-1 * t401 * t70 + 0.40959992888888888888888888888888888888888888888889e-3 * t406 * t70
  t421 = t20 ** 2
  t429 = (0.40e2 / 0.9e1 * t15 * t57 - 0.11e2 / 0.9e1 * t19 / t10 / t421 - 0.10e2 / 0.9e1 * t25 * t57) * t29
  t432 = t62 ** 2
  t433 = t29 ** 2
  t434 = t432 * t433
  t436 = 0.1e1 / t32 / t31
  t444 = t434 * t436
  t447 = t429 * t34
  t458 = t38 ** 2
  t471 = 0.1e1 / t9 / t20
  t472 = t471 * t13
  t475 = 0.14764770444444444444444444444444444444444444444444e-2 * t95 * t472 * t124
  t480 = 0.35616666666666666666666666666666666666666666666666e-1 * t326 * t137 * t131 * t153 * t154
  t484 = t153 ** 2
  t487 = 0.20000000000000000000000000000000000000000000000000e1 * t129 / t130 / t119 * t484 * t154
  t492 = t93 * t22
  t494 = t492 * t14 * t115
  t495 = 0.1e1 / t105 / t104 * t110 * t111 * t494
  t497 = t94 * t471
  t498 = t497 * t137
  t499 = t135 * t498
  t502 = t95 * t472 * t100
  t504 = t104 ** (-0.5e0)
  t507 = t504 * t110 * t111 * t494
  t509 = t146 * t498
  t513 = t113 * t22 * t14 * t115
  t518 = 0.10000000000000000000000000000000000000000000000000e1 * t132 * (-0.42198333333333333333333333333333333333333333333333e0 * t495 + 0.84396666666666666666666666666666666666666666666666e0 * t499 + 0.39862222222222222222222222222222222222222222222223e0 * t502 + 0.68258333333333333333333333333333333333333333333333e-1 * t507 + 0.13651666666666666666666666666666666666666666666667e0 * t509 + 0.13692777777777777777777777777777777777777777777778e0 * t513) * t154
  t519 = t130 ** 2
  t522 = t122 ** 2
  t526 = 0.16081824322151104821330931780901225435013347914188e2 * t129 / t519 * t484 / t522
  t538 = t190 ** 2
  t552 = t183 ** 2
  t555 = t175 ** 2
  t567 = 0.1e1 / t210 / t199
  t569 = t217 ** 2
  t579 = -0.57538888888888888888888888888888888888888888888889e0 * t495 + 0.11507777777777777777777777777777777777777777777778e1 * t499 + 0.40256666666666666666666666666666666666666666666667e0 * t502 + 0.36677500000000000000000000000000000000000000000000e-1 * t507 + 0.73355000000000000000000000000000000000000000000000e-1 * t509 + 0.13797500000000000000000000000000000000000000000000e0 * t513
  t583 = t210 ** 2
  t584 = 0.1e1 / t583
  t586 = t202 ** 2
  t587 = 0.1e1 / t586
  t591 = -0.70981924444444444444444444444444444444444444444442e-3 * t95 * t472 * t177 - 0.34246666666666666666666666666666666666666666666666e-1 * t326 * t137 * t184 * t190 * t191 - 0.20000000000000000000000000000000000000000000000000e1 * t182 / t183 / t172 * t538 * t191 + 0.99999999999999999999999999999999999999999999999999e0 * t185 * (-0.78438333333333333333333333333333333333333333333333e0 * t495 + 0.15687666666666666666666666666666666666666666666667e1 * t499 + 0.68863333333333333333333333333333333333333333333333e0 * t502 + 0.14025833333333333333333333333333333333333333333333e0 * t507 + 0.28051666666666666666666666666666666666666666666667e0 * t509 + 0.17365833333333333333333333333333333333333333333333e0 * t513) * t191 + 0.32164683177870697973624959794146027661627532968800e2 * t182 / t552 * t538 / t555 + t475 + t480 + t487 - t518 - t526 - 0.24415406715670879921742973310852762593515528885057e-3 * t95 * t472 * t204 - 0.10843580882781524214666447553230042011687479519034e-1 * t326 * t137 * t231 - 0.11696446794910408141662685001236899248561775660981e1 * t209 * t567 * t569 * t218 + 0.58482233974552040708313425006184496242808878304903e0 * t212 * t579 * t218 + 0.17315755899375863299672358916972966258900005419821e2 * t209 * t584 * t569 * t587
  t612 = -t475 - t480 - t487 + t518 + t526 + t167 * t591 + 0.24415406715670879921742973310852762593515528885057e-3 * t224 * t497 * t225 + 0.10843580882781524214666447553230042011687479519034e-1 * t167 * t95 * t141 * t231 + 0.11696446794910408141662685001236899248561775660981e1 * t229 * t567 * t569 * t218 - 0.58482233974552040708313425006184496242808878304903e0 * t229 * t211 * t579 * t218 - 0.17315755899375863299672358916972966258900005419821e2 * t229 * t584 * t569 * t587
  t615 = f.my_piecewise3(t88, 0, t89 * t612 / 0.2e1)
  t673 = t335 ** 2
  t681 = t111 * t93 * t22
  t682 = 0.1e1 / t299 / t298 * t110 * t681
  t684 = t322 * t471
  t685 = t321 * t684
  t687 = t92 * t497
  t689 = t298 ** (-0.5e0)
  t691 = t689 * t110 * t681
  t693 = t329 * t684
  t695 = t112 * t492
  t701 = t317 ** 2
  t704 = t310 ** 2
  t719 = t366 ** 2
  t735 = t360 ** 2
  t738 = t351 ** 2
  t744 = -0.14764770444444444444444444444444444444444444444444e-2 * t92 * t497 * t311 - 0.35616666666666666666666666666666666666666666666666e-1 * t95 * t97 * t318 * t337 - 0.20000000000000000000000000000000000000000000000000e1 * t316 / t317 / t307 * t673 * t336 + 0.10000000000000000000000000000000000000000000000000e1 * t319 * (-0.42198333333333333333333333333333333333333333333333e0 * t682 + 0.84396666666666666666666666666666666666666666666666e0 * t685 + 0.39862222222222222222222222222222222222222222222223e0 * t687 + 0.68258333333333333333333333333333333333333333333333e-1 * t691 + 0.13651666666666666666666666666666666666666666666667e0 * t693 + 0.13692777777777777777777777777777777777777777777778e0 * t695) * t336 + 0.16081824322151104821330931780901225435013347914188e2 * t316 / t701 * t673 / t704 + 0.24415406715670879921742973310852762593515528885057e-3 * t343 * t322 * t471 * t352 + 0.10843580882781524214666447553230042011687479519034e-1 * t342 * t92 * t136 * t369 + 0.11696446794910408141662685001236899248561775660981e1 * t359 / t360 / t348 * t719 * t368 - 0.58482233974552040708313425006184496242808878304903e0 * t359 * t361 * (-0.57538888888888888888888888888888888888888888888889e0 * t682 + 0.11507777777777777777777777777777777777777777777778e1 * t685 + 0.40256666666666666666666666666666666666666666666667e0 * t687 + 0.36677500000000000000000000000000000000000000000000e-1 * t691 + 0.73355000000000000000000000000000000000000000000000e-1 * t693 + 0.13797500000000000000000000000000000000000000000000e0 * t695) * t368 - 0.17315755899375863299672358916972966258900005419821e2 * t359 / t735 * t719 / t738 - 0.2e1 * t615
  t778 = t4 * t8 * t17 * t48 / 0.6e1 - t4 * t12 * t82 / 0.2e1 - 0.3e1 / 0.4e1 * t4 * t52 * (-0.40834444444444444444444444444444444444444444444444e-1 * t429 * t64 - 0.82349462962962962962962962962962962962962962962960e-3 * t434 * t436 * t68 * t37 + 0.99642850185185185185185185185185185185185185185178e-5 * t76 / t41 / t77 * t444 + 0.49409677777777777777777777777777777777777777777776e-3 * t69 * t447 + 0.10606172839506172839506172839506172839506172839506e-2 * t434 * t436 * t45 - 0.64167345679012345679012345679012345679012345679011e-4 * t38 * t78 * t444 - 0.19091111111111111111111111111111111111111111111111e-2 * t73 * t447 + 0.62113990617283950617283950617283950617283950617281e-6 * t458 / t77 / t40 * t444 + 0.23100244444444444444444444444444444444444444444444e-4 * t79 * t447) + 0.2e1 * t615 * t247 * t254 + 0.4e1 * t237 * t287 * t254 + t248 * t294 / 0.2e1 + 0.2e1 * t270 * (0.85404444444444444444444444444444444444444444444445e0 * t429 * t271 + 0.36439229629629629629629629629629629629629629629629e1 * t434 * t436 * t275 * t37 - 0.93284427851851851851851851851851851851851851851847e1 * t76 / t240 / t282 * t444 - 0.21863537777777777777777777777777777777777777777777e1 * t276 * t447 + 0.14258567901234567901234567901234567901234567901234e1 * t434 * t436 * t244 - 0.18250966913580246913580246913580246913580246913580e2 * t38 * t283 * t444 - 0.25665422222222222222222222222222222222222222222222e1 * t279 * t447 + 0.37377980239012345679012345679012345679012345679011e2 * t458 / t282 / t239 * t444 + 0.65703480888888888888888888888888888888888888888888e1 * t284 * t447) * t254 + t288 * t294 / 0.2e1 - t291 * s0 / t55 * t251 / 0.2e1 + t744 * t383 + 0.2e1 * t373 * t409 + t392 * (0.17668777777777777777777777777777777777777777777778e0 * t429 * t393 + 0.57718007407407407407407407407407407407407407407409e-2 * t434 * t436 * t397 * t37 - 0.11312729451851851851851851851851851851851851851852e-3 * t76 / t376 / t404 * t444 - 0.34630804444444444444444444444444444444444444444445e-2 * t398 * t447 + 0.11609975308641975308641975308641975308641975308642e-1 * t434 * t436 * t380 - 0.11377775802469135802469135802469135802469135802469e-2 * t38 * t405 * t444 - 0.20897955555555555555555555555555555555555555555556e-1 * t401 * t447 + 0.17840352458271604938271604938271604938271604938272e-4 * t458 / t404 / t375 * t444 + 0.40959992888888888888888888888888888888888888888889e-3 * t406 * t447)
  v2rho2_0_ = -t4 * t12 * t48 / 0.2e1 - 0.3e1 / 0.2e1 * t4 * t52 * t82 + 0.4e1 * t248 * t254 + 0.4e1 * t288 * t254 + t291 * t294 / 0.2e1 + 0.2e1 * t373 * t383 + 0.2e1 * t392 * t409 + r0 * t778
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** (0.1e1 / 0.3e1)
  t8 = 0.1e1 / t7
  t10 = t4 * t6 * t8
  t12 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t10
  t13 = jnp.sqrt(t10)
  t16 = t10 ** 0.15e1
  t18 = t1 ** 2
  t19 = t3 ** 2
  t20 = t18 * t19
  t21 = t7 ** 2
  t22 = 0.1e1 / t21
  t24 = t20 * t5 * t22
  t26 = 0.37978500000000000000000000000000000000000000000000e1 * t13 + 0.89690000000000000000000000000000000000000000000000e0 * t10 + 0.20477500000000000000000000000000000000000000000000e0 * t16 + 0.12323500000000000000000000000000000000000000000000e0 * t24
  t29 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t26
  t30 = jnp.log(t29)
  t33 = 0.1e1 <= f.p.zeta_threshold
  t34 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t35 = t34 * f.p.zeta_threshold
  t36 = f.my_piecewise3(t33, t35, 1)
  t39 = 2 ** (0.1e1 / 0.3e1)
  t42 = 0.1e1 / (0.2e1 * t39 - 0.2e1)
  t43 = (0.2e1 * t36 - 0.2e1) * t42
  t45 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t10
  t50 = 0.51785000000000000000000000000000000000000000000000e1 * t13 + 0.90577500000000000000000000000000000000000000000000e0 * t10 + 0.11003250000000000000000000000000000000000000000000e0 * t16 + 0.12417750000000000000000000000000000000000000000000e0 * t24
  t53 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t50
  t54 = jnp.log(t53)
  t60 = r0 / 0.2e1 <= f.p.dens_threshold or t33
  t61 = f.my_piecewise3(t33, f.p.zeta_threshold, 1)
  t62 = t4 * t6
  t65 = f.my_piecewise3(t33, 0.1e1 / t34, 1)
  t67 = t62 * t8 * t39 * t65
  t69 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t67
  t70 = jnp.sqrt(t67)
  t73 = t67 ** 0.15e1
  t75 = t20 * t5
  t76 = t39 ** 2
  t78 = t65 ** 2
  t80 = t75 * t22 * t76 * t78
  t82 = 0.37978500000000000000000000000000000000000000000000e1 * t70 + 0.89690000000000000000000000000000000000000000000000e0 * t67 + 0.20477500000000000000000000000000000000000000000000e0 * t73 + 0.12323500000000000000000000000000000000000000000000e0 * t80
  t85 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t82
  t86 = jnp.log(t85)
  t88 = 0.62182e-1 * t69 * t86
  t91 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t35, 0.2e1 * t39)
  t93 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t35, 0)
  t95 = (t91 + t93 - 0.2e1) * t42
  t97 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t67
  t102 = 0.70594500000000000000000000000000000000000000000000e1 * t70 + 0.15494250000000000000000000000000000000000000000000e1 * t67 + 0.42077500000000000000000000000000000000000000000000e0 * t73 + 0.15629250000000000000000000000000000000000000000000e0 * t80
  t105 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t102
  t106 = jnp.log(t105)
  t110 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t67
  t115 = 0.51785000000000000000000000000000000000000000000000e1 * t70 + 0.90577500000000000000000000000000000000000000000000e0 * t67 + 0.11003250000000000000000000000000000000000000000000e0 * t73 + 0.12417750000000000000000000000000000000000000000000e0 * t80
  t118 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t115
  t119 = jnp.log(t118)
  t120 = t110 * t119
  t129 = f.my_piecewise3(t60, 0, t61 * (-t88 + t95 * (-0.31090e-1 * t97 * t106 + t88 - 0.19751789702565206228825776161588751761046270558698e-1 * t120) + 0.19751789702565206228825776161588751761046270558698e-1 * t95 * t120) / 0.2e1)
  t131 = -0.62182e-1 * t12 * t30 + 0.19751789702565206228825776161588751761046270558698e-1 * t43 * t45 * t54 - 0.2e1 * t129
  t132 = tau0 * t76
  t133 = r0 ** 2
  t134 = t133 * r0
  t136 = 0.1e1 / t21 / t134
  t139 = s0 * t76
  t140 = t133 ** 2
  t142 = 0.1e1 / t21 / t140
  t145 = l0 * t76
  t148 = 0.40e2 / 0.9e1 * t132 * t136 - 0.11e2 / 0.9e1 * t139 * t142 - 0.10e2 / 0.9e1 * t145 * t136
  t149 = 6 ** (0.1e1 / 0.3e1)
  t150 = t148 * t149
  t151 = jnp.pi ** 2
  t152 = t151 ** (0.1e1 / 0.3e1)
  t153 = t152 ** 2
  t154 = 0.1e1 / t153
  t156 = 0.1e1 / t21 / r0
  t159 = 0.1e1 / t21 / t133
  t168 = 0.1e1 - 0.5e1 / 0.9e1 * (t132 * t156 - t139 * t159 / 0.8e1 - t145 * t156 / 0.4e1) * t149 * t154
  t169 = t168 ** 2
  t171 = 0.1e1 + 0.196e-1 * t169
  t172 = jnp.sqrt(t171)
  t173 = 0.1e1 / t172
  t174 = t154 * t173
  t183 = -0.5e1 / 0.3e1 * t132 * t159 + t139 * t136 / 0.3e1 + 0.5e1 / 0.12e2 * t145 * t159
  t184 = t183 ** 2
  t185 = t149 ** 2
  t186 = t184 * t185
  t188 = 0.1e1 / t152 / t151
  t190 = 0.1e1 / t172 / t171
  t195 = t169 * t168
  t196 = t171 ** 2
  t198 = 0.1e1 / t172 / t196
  t199 = t195 * t198
  t200 = t186 * t188
  t203 = t169 * t190
  t204 = t150 * t154
  t207 = 0.1e1 / t171
  t208 = t188 * t207
  t211 = 0.1e1 / t196
  t212 = t169 * t211
  t215 = t168 * t207
  t218 = t169 ** 2
  t219 = t196 * t171
  t220 = 0.1e1 / t219
  t221 = t218 * t220
  t224 = t195 * t211
  t227 = 0.17668777777777777777777777777777777777777777777778e0 * t150 * t174 + 0.57718007407407407407407407407407407407407407407409e-2 * t186 * t188 * t190 * t168 - 0.11312729451851851851851851851851851851851851851852e-3 * t199 * t200 - 0.34630804444444444444444444444444444444444444444445e-2 * t203 * t204 + 0.11609975308641975308641975308641975308641975308642e-1 * t186 * t208 - 0.11377775802469135802469135802469135802469135802469e-2 * t212 * t200 - 0.20897955555555555555555555555555555555555555555556e-1 * t215 * t204 + 0.17840352458271604938271604938271604938271604938272e-4 * t221 * t200 + 0.40959992888888888888888888888888888888888888888889e-3 * t224 * t204
  t230 = jnp.pi ** (0.1e1 / 0.3e1)
  t232 = t1 / t230
  t233 = t36 * t22
  t234 = t183 * t149
  t236 = 0.1e1 + 0.121e-1 * t169
  t237 = jnp.sqrt(t236)
  t238 = 0.1e1 / t237
  t239 = t154 * t238
  t243 = 0.1e1 / t237 / t236
  t244 = t169 * t243
  t245 = t234 * t154
  t248 = 0.1e1 / t236
  t249 = t168 * t248
  t252 = t236 ** 2
  t253 = 0.1e1 / t252
  t254 = t195 * t253
  t257 = -0.40834444444444444444444444444444444444444444444444e-1 * t234 * t239 + 0.49409677777777777777777777777777777777777777777776e-3 * t244 * t245 - 0.19091111111111111111111111111111111111111111111111e-2 * t249 * t245 + 0.23100244444444444444444444444444444444444444444444e-4 * t254 * t245
  t261 = t36 * t7
  t269 = 0.1e1 / t237 / t252
  t270 = t195 * t269
  t275 = t188 * t248
  t278 = t169 * t253
  t283 = t252 * t236
  t284 = 0.1e1 / t283
  t285 = t218 * t284
  t290 = -0.40834444444444444444444444444444444444444444444444e-1 * t150 * t239 - 0.82349462962962962962962962962962962962962962962960e-3 * t186 * t188 * t243 * t168 + 0.99642850185185185185185185185185185185185185185178e-5 * t270 * t200 + 0.49409677777777777777777777777777777777777777777776e-3 * t244 * t204 + 0.10606172839506172839506172839506172839506172839506e-2 * t186 * t275 - 0.64167345679012345679012345679012345679012345679011e-4 * t278 * t200 - 0.19091111111111111111111111111111111111111111111111e-2 * t249 * t204 + 0.62113990617283950617283950617283950617283950617281e-6 * t285 * t200 + 0.23100244444444444444444444444444444444444444444444e-4 * t254 * t204
  t294 = t36 * t156
  t299 = 0.8085e0 + 0.73502e-1 * t168 * t238 + 0.171820e-2 * t169 * t248
  t304 = 0.1e1 / t7 / r0
  t305 = t6 * t304
  t309 = t26 ** 2
  t310 = 0.1e1 / t309
  t311 = t12 * t310
  t313 = 0.1e1 / t13 * t1
  t314 = t3 * t6
  t315 = t314 * t304
  t316 = t313 * t315
  t318 = t4 * t305
  t320 = t10 ** 0.5e0
  t321 = t320 * t1
  t322 = t321 * t315
  t325 = t20 * t5 * t156
  t327 = -0.63297500000000000000000000000000000000000000000000e0 * t316 - 0.29896666666666666666666666666666666666666666666667e0 * t318 - 0.10238750000000000000000000000000000000000000000000e0 * t322 - 0.82156666666666666666666666666666666666666666666667e-1 * t325
  t328 = 0.1e1 / t29
  t329 = t327 * t328
  t332 = t43 * t1
  t337 = t43 * t45
  t338 = t50 ** 2
  t339 = 0.1e1 / t338
  t344 = -0.86308333333333333333333333333333333333333333333334e0 * t316 - 0.30192500000000000000000000000000000000000000000000e0 * t318 - 0.55016250000000000000000000000000000000000000000000e-1 * t322 - 0.82785000000000000000000000000000000000000000000000e-1 * t325
  t346 = 0.1e1 / t53
  t347 = t339 * t344 * t346
  t350 = t304 * t39
  t351 = t65 * t86
  t354 = 0.11073577833333333333333333333333333333333333333333e-2 * t62 * t350 * t351
  t355 = t82 ** 2
  t356 = 0.1e1 / t355
  t357 = t69 * t356
  t360 = 0.1e1 / t70 * t1 * t3
  t361 = t39 * t65
  t362 = t305 * t361
  t363 = t360 * t362
  t365 = t350 * t65
  t366 = t62 * t365
  t368 = t67 ** 0.5e0
  t370 = t368 * t1 * t3
  t371 = t370 * t362
  t375 = t75 * t156 * t76 * t78
  t377 = -0.63297500000000000000000000000000000000000000000000e0 * t363 - 0.29896666666666666666666666666666666666666666666667e0 * t366 - 0.10238750000000000000000000000000000000000000000000e0 * t371 - 0.82156666666666666666666666666666666666666666666667e-1 * t375
  t378 = 0.1e1 / t85
  t379 = t377 * t378
  t381 = 0.10000000000000000000000000000000000000000000000000e1 * t357 * t379
  t382 = t65 * t106
  t386 = t102 ** 2
  t387 = 0.1e1 / t386
  t388 = t97 * t387
  t393 = -0.11765750000000000000000000000000000000000000000000e1 * t363 - 0.51647500000000000000000000000000000000000000000000e0 * t366 - 0.21038750000000000000000000000000000000000000000000e0 * t371 - 0.10419500000000000000000000000000000000000000000000e0 * t375
  t394 = 0.1e1 / t105
  t395 = t393 * t394
  t398 = t65 * t119
  t402 = t115 ** 2
  t403 = 0.1e1 / t402
  t404 = t110 * t403
  t409 = -0.86308333333333333333333333333333333333333333333334e0 * t363 - 0.30192500000000000000000000000000000000000000000000e0 * t366 - 0.55016250000000000000000000000000000000000000000000e-1 * t371 - 0.82785000000000000000000000000000000000000000000000e-1 * t375
  t410 = 0.1e1 / t118
  t411 = t409 * t410
  t416 = t95 * t4
  t417 = t361 * t119
  t421 = t95 * t110
  t423 = t403 * t409 * t410
  t429 = f.my_piecewise3(t60, 0, t61 * (t354 + t381 + t95 * (0.53236443333333333333333333333333333333333333333332e-3 * t62 * t350 * t382 + 0.99999999999999999999999999999999999999999999999999e0 * t388 * t395 - t354 - t381 + 0.18311555036753159941307229983139571945136646663793e-3 * t62 * t350 * t398 + 0.58482233974552040708313425006184496242808878304903e0 * t404 * t411) - 0.18311555036753159941307229983139571945136646663793e-3 * t416 * t305 * t417 - 0.58482233974552040708313425006184496242808878304903e0 * t421 * t423) / 0.2e1)
  t431 = 0.11073577833333333333333333333333333333333333333333e-2 * t4 * t305 * t30 + 0.10000000000000000000000000000000000000000000000000e1 * t311 * t329 - 0.18311555036753159941307229983139571945136646663793e-3 * t332 * t314 * t304 * t54 - 0.58482233974552040708313425006184496242808878304903e0 * t337 * t347 - 0.2e1 * t429
  t440 = 0.17668777777777777777777777777777777777777777777778e0 * t234 * t174 - 0.34630804444444444444444444444444444444444444444445e-2 * t203 * t245 - 0.20897955555555555555555555555555555555555555555556e-1 * t215 * t245 + 0.40959992888888888888888888888888888888888888888889e-3 * t224 * t245
  t444 = 0.1e1 / t7 / t133
  t445 = t6 * t444
  t449 = t304 * t310
  t454 = 0.1e1 / t309 / t26
  t455 = t12 * t454
  t456 = t327 ** 2
  t457 = t456 * t328
  t462 = 0.1e1 / t13 / t10 * t18
  t463 = t19 * t5
  t464 = t463 * t159
  t465 = t462 * t464
  t467 = t314 * t444
  t468 = t313 * t467
  t470 = t4 * t445
  t472 = t10 ** (-0.5e0)
  t473 = t472 * t18
  t474 = t473 * t464
  t476 = t321 * t467
  t478 = t5 * t159
  t479 = t20 * t478
  t481 = -0.42198333333333333333333333333333333333333333333333e0 * t465 + 0.84396666666666666666666666666666666666666666666666e0 * t468 + 0.39862222222222222222222222222222222222222222222223e0 * t470 + 0.68258333333333333333333333333333333333333333333333e-1 * t474 + 0.13651666666666666666666666666666666666666666666667e0 * t476 + 0.13692777777777777777777777777777777777777777777778e0 * t479
  t482 = t481 * t328
  t485 = t309 ** 2
  t486 = 0.1e1 / t485
  t487 = t12 * t486
  t488 = t29 ** 2
  t489 = 0.1e1 / t488
  t490 = t456 * t489
  t497 = t43 * t4
  t502 = 0.1e1 / t338 / t50
  t503 = t344 ** 2
  t505 = t502 * t503 * t346
  t514 = -0.57538888888888888888888888888888888888888888888889e0 * t465 + 0.11507777777777777777777777777777777777777777777778e1 * t468 + 0.40256666666666666666666666666666666666666666666667e0 * t470 + 0.36677500000000000000000000000000000000000000000000e-1 * t474 + 0.73355000000000000000000000000000000000000000000000e-1 * t476 + 0.13797500000000000000000000000000000000000000000000e0 * t479
  t516 = t339 * t514 * t346
  t519 = t338 ** 2
  t520 = 0.1e1 / t519
  t522 = t53 ** 2
  t523 = 0.1e1 / t522
  t524 = t520 * t503 * t523
  t527 = t444 * t39
  t530 = 0.14764770444444444444444444444444444444444444444444e-2 * t62 * t527 * t351
  t533 = t361 * t356 * t377 * t378
  t535 = 0.35616666666666666666666666666666666666666666666666e-1 * t318 * t533
  t537 = 0.1e1 / t355 / t82
  t538 = t69 * t537
  t539 = t377 ** 2
  t542 = 0.20000000000000000000000000000000000000000000000000e1 * t538 * t539 * t378
  t546 = 0.1e1 / t70 / t67 * t18 * t19
  t547 = t76 * t78
  t548 = t478 * t547
  t549 = t546 * t548
  t551 = t445 * t361
  t552 = t360 * t551
  t554 = t527 * t65
  t555 = t62 * t554
  t557 = t67 ** (-0.5e0)
  t559 = t557 * t18 * t19
  t560 = t559 * t548
  t562 = t370 * t551
  t566 = t75 * t159 * t76 * t78
  t568 = -0.42198333333333333333333333333333333333333333333333e0 * t549 + 0.84396666666666666666666666666666666666666666666666e0 * t552 + 0.39862222222222222222222222222222222222222222222223e0 * t555 + 0.68258333333333333333333333333333333333333333333333e-1 * t560 + 0.13651666666666666666666666666666666666666666666667e0 * t562 + 0.13692777777777777777777777777777777777777777777778e0 * t566
  t571 = 0.10000000000000000000000000000000000000000000000000e1 * t357 * t568 * t378
  t572 = t355 ** 2
  t573 = 0.1e1 / t572
  t574 = t69 * t573
  t575 = t85 ** 2
  t576 = 0.1e1 / t575
  t579 = 0.16081824322151104821330931780901225435013347914188e2 * t574 * t539 * t576
  t585 = t361 * t387 * t393 * t394
  t589 = 0.1e1 / t386 / t102
  t590 = t97 * t589
  t591 = t393 ** 2
  t601 = -0.78438333333333333333333333333333333333333333333333e0 * t549 + 0.15687666666666666666666666666666666666666666666667e1 * t552 + 0.68863333333333333333333333333333333333333333333333e0 * t555 + 0.14025833333333333333333333333333333333333333333333e0 * t560 + 0.28051666666666666666666666666666666666666666666667e0 * t562 + 0.17365833333333333333333333333333333333333333333333e0 * t566
  t605 = t386 ** 2
  t606 = 0.1e1 / t605
  t607 = t97 * t606
  t608 = t105 ** 2
  t609 = 0.1e1 / t608
  t616 = t361 * t423
  t620 = 0.1e1 / t402 / t115
  t621 = t110 * t620
  t622 = t409 ** 2
  t632 = -0.57538888888888888888888888888888888888888888888889e0 * t549 + 0.11507777777777777777777777777777777777777777777778e1 * t552 + 0.40256666666666666666666666666666666666666666666667e0 * t555 + 0.36677500000000000000000000000000000000000000000000e-1 * t560 + 0.73355000000000000000000000000000000000000000000000e-1 * t562 + 0.13797500000000000000000000000000000000000000000000e0 * t566
  t633 = t632 * t410
  t636 = t402 ** 2
  t637 = 0.1e1 / t636
  t638 = t110 * t637
  t639 = t118 ** 2
  t640 = 0.1e1 / t639
  t644 = -0.70981924444444444444444444444444444444444444444442e-3 * t62 * t527 * t382 - 0.34246666666666666666666666666666666666666666666666e-1 * t318 * t585 - 0.20000000000000000000000000000000000000000000000000e1 * t590 * t591 * t394 + 0.99999999999999999999999999999999999999999999999999e0 * t388 * t601 * t394 + 0.32164683177870697973624959794146027661627532968800e2 * t607 * t591 * t609 + t530 + t535 + t542 - t571 - t579 - 0.24415406715670879921742973310852762593515528885057e-3 * t62 * t527 * t398 - 0.10843580882781524214666447553230042011687479519034e-1 * t318 * t616 - 0.11696446794910408141662685001236899248561775660981e1 * t621 * t622 * t410 + 0.58482233974552040708313425006184496242808878304903e0 * t404 * t633 + 0.17315755899375863299672358916972966258900005419821e2 * t638 * t622 * t640
  t649 = t95 * t62
  t654 = t620 * t622 * t410
  t658 = t403 * t632 * t410
  t662 = t637 * t622 * t640
  t665 = -t530 - t535 - t542 + t571 + t579 + t95 * t644 + 0.24415406715670879921742973310852762593515528885057e-3 * t416 * t445 * t417 + 0.10843580882781524214666447553230042011687479519034e-1 * t649 * t365 * t423 + 0.11696446794910408141662685001236899248561775660981e1 * t421 * t654 - 0.58482233974552040708313425006184496242808878304903e0 * t421 * t658 - 0.17315755899375863299672358916972966258900005419821e2 * t421 * t662
  t668 = f.my_piecewise3(t60, 0, t61 * t665 / 0.2e1)
  t670 = -0.14764770444444444444444444444444444444444444444444e-2 * t4 * t445 * t30 - 0.35616666666666666666666666666666666666666666666666e-1 * t62 * t449 * t329 - 0.20000000000000000000000000000000000000000000000000e1 * t455 * t457 + 0.10000000000000000000000000000000000000000000000000e1 * t311 * t482 + 0.16081824322151104821330931780901225435013347914188e2 * t487 * t490 + 0.24415406715670879921742973310852762593515528885057e-3 * t332 * t314 * t444 * t54 + 0.10843580882781524214666447553230042011687479519034e-1 * t497 * t305 * t347 + 0.11696446794910408141662685001236899248561775660981e1 * t337 * t505 - 0.58482233974552040708313425006184496242808878304903e0 * t337 * t516 - 0.17315755899375863299672358916972966258900005419821e2 * t337 * t524 - 0.2e1 * t668
  t675 = 0.12033e1 - 0.318038e0 * t168 * t173 + 0.1880816e-1 * t169 * t207
  t679 = 0.1e1 + 0.256e1 * t169
  t680 = jnp.sqrt(t679)
  t681 = 0.1e1 / t680
  t684 = 0.1e1 / t679
  t687 = 0.2606e0 - 0.153728e1 * t168 * t681 + 0.2309888e1 * t169 * t684
  t688 = t668 * t687
  t691 = 0.1e1 / tau0
  t694 = 0.1e1 - s0 / r0 * t691 / 0.8e1
  t697 = t154 * t681
  t701 = 0.1e1 / t680 / t679
  t702 = t169 * t701
  t705 = t168 * t684
  t708 = t679 ** 2
  t709 = 0.1e1 / t708
  t710 = t195 * t709
  t713 = 0.85404444444444444444444444444444444444444444444445e0 * t234 * t697 - 0.21863537777777777777777777777777777777777777777777e1 * t702 * t245 - 0.25665422222222222222222222222222222222222222222222e1 * t705 * t245 + 0.65703480888888888888888888888888888888888888888888e1 * t710 * t245
  t714 = t429 * t713
  t724 = 0.1e1 / t680 / t708
  t725 = t195 * t724
  t730 = t188 * t684
  t733 = t169 * t709
  t738 = t708 * t679
  t739 = 0.1e1 / t738
  t740 = t218 * t739
  t745 = 0.85404444444444444444444444444444444444444444444445e0 * t150 * t697 + 0.36439229629629629629629629629629629629629629629629e1 * t186 * t188 * t701 * t168 - 0.93284427851851851851851851851851851851851851851847e1 * t725 * t200 - 0.21863537777777777777777777777777777777777777777777e1 * t702 * t204 + 0.14258567901234567901234567901234567901234567901234e1 * t186 * t730 - 0.18250966913580246913580246913580246913580246913580e2 * t733 * t200 - 0.25665422222222222222222222222222222222222222222222e1 * t705 * t204 + 0.37377980239012345679012345679012345679012345679011e2 * t740 * t200 + 0.65703480888888888888888888888888888888888888888888e1 * t710 * t204
  t746 = t129 * t745
  t749 = t429 * t687
  t752 = s0 / t133 * t691
  t755 = t129 * t713
  t758 = t129 * t687
  t761 = s0 / t134 * t691
  t779 = t185 * t188 * t148
  t802 = (-0.440e3 / 0.27e2 * t132 * t142 + 0.154e3 / 0.27e2 * t139 / t21 / t140 / r0 + 0.110e3 / 0.27e2 * t145 * t142) * t149
  t803 = t802 * t154
  t806 = t183 * t185
  t815 = t151 ** 2
  t817 = t184 * t183 / t815
  t824 = t218 * t168
  t825 = t252 ** 2
  t842 = -0.19250203703703703703703703703703703703703703703703e-3 * t278 * t183 * t779 + 0.18634197185185185185185185185185185185185185185184e-5 * t285 * t183 * t779 - 0.24704838888888888888888888888888888888888888888888e-2 * t779 * t243 * t168 * t183 + 0.29892855055555555555555555555555555555555555555554e-4 * t270 * t183 * t779 + 0.49409677777777777777777777777777777777777777777776e-3 * t244 * t803 + 0.31818518518518518518518518518518518518518518518518e-2 * t806 * t275 * t148 - 0.19091111111111111111111111111111111111111111111111e-2 * t249 * t803 + 0.23100244444444444444444444444444444444444444444444e-4 * t254 * t803 + 0.51333876543209876543209876543209876543209876543209e-3 * t817 * t253 * t168 - 0.18634197185185185185185185185185185185185185185184e-4 * t195 * t284 * t817 + 0.15031585729382716049382716049382716049382716049381e-6 * t824 / t825 * t817 - 0.40834444444444444444444444444444444444444444444444e-1 * t802 * t239 - 0.19928570037037037037037037037037037037037037037036e-3 * t817 * t269 * t169 + 0.20094641454012345679012345679012345679012345679010e-5 * t218 / t237 / t283 * t817 + 0.27449820987654320987654320987654320987654320987653e-2 * t817 * t243
  t852 = 0.1e1 / t140
  t888 = t708 ** 2
  t906 = -0.21863537777777777777777777777777777777777777777777e1 * t702 * t803 + 0.42775703703703703703703703703703703703703703703702e1 * t806 * t730 * t148 - 0.25665422222222222222222222222222222222222222222222e1 * t705 * t803 + 0.65703480888888888888888888888888888888888888888888e1 * t710 * t803 - 0.54752900740740740740740740740740740740740740740740e2 * t733 * t183 * t779 + 0.11213394071703703703703703703703703703703703703703e3 * t740 * t183 * t779 + 0.10931768888888888888888888888888888888888888888889e2 * t779 * t701 * t168 * t183 - 0.27985328355555555555555555555555555555555555555554e2 * t725 * t183 * t779 - 0.12146409876543209876543209876543209876543209876543e2 * t817 * t701 - 0.11213394071703703703703703703703703703703703703703e4 * t195 * t739 * t817 + 0.19137525882374320987654320987654320987654320987653e4 * t824 / t888 * t817 + 0.85404444444444444444444444444444444444444444444445e0 * t802 * t697 + 0.18656885570370370370370370370370370370370370370369e3 * t817 * t724 * t169 - 0.39801355883456790123456790123456790123456790123453e3 * t218 / t680 / t738 * t817 + 0.14600773530864197530864197530864197530864197530864e3 * t817 * t709 * t168
  t910 = t539 * t377
  t913 = 0.60000000000000000000000000000000000000000000000000e1 * t574 * t910 * t378
  t916 = 0.60000000000000000000000000000000000000000000000000e1 * t538 * t379 * t568
  t920 = 0.48245472966453314463992795342703676305040043742564e2 * t574 * t568 * t576 * t377
  t922 = 0.1e1 / t7 / t134
  t923 = t922 * t39
  t926 = 0.34451131037037037037037037037037037037037037037036e-2 * t62 * t923 * t351
  t927 = t6 * t922
  t935 = 0.10685000000000000000000000000000000000000000000000e0 * t318 * t361 * t537 * t539 * t378
  t948 = t622 * t409
  t954 = 0.1e1 / t636 / t402
  t957 = 0.1e1 / t639 / t118
  t961 = t913 - t916 + t920 + t926 - 0.56969282336565386484066937725323112718202900731800e-3 * t416 * t927 * t417 + t935 - 0.32530742648344572643999342659690126035062438557102e-1 * t649 * t365 * t654 - 0.51947267698127589899017076750918898776700016259463e2 * t421 * t637 * t632 * t640 * t409 + 0.35089340384731224424988055003710697745685326982943e1 * t421 * t620 * t409 * t633 - 0.35089340384731224424988055003710697745685326982943e1 * t421 * t637 * t948 * t410 - 0.10253897021007794930818001372045340355835853271641e4 * t421 * t954 * t948 * t957
  t963 = 0.1e1 / t636 / t115
  t973 = t852 * t78 * t65
  t974 = 0.1e1 / t70 / t80 * t2 * t973 / 0.4e1
  t976 = t5 * t136
  t977 = t976 * t547
  t978 = t546 * t977
  t980 = t927 * t361
  t981 = t360 * t980
  t984 = t62 * t923 * t65
  t986 = t67 ** (-0.15e1)
  t988 = t986 * t2 * t973
  t990 = t559 * t977
  t992 = t370 * t980
  t996 = t75 * t136 * t76 * t78
  t998 = -0.69046666666666666666666666666666666666666666666667e1 * t974 + 0.23015555555555555555555555555555555555555555555556e1 * t978 - 0.26851481481481481481481481481481481481481481481482e1 * t981 - 0.93932222222222222222222222222222222222222222222223e0 * t984 + 0.14671000000000000000000000000000000000000000000000e0 * t988 - 0.14671000000000000000000000000000000000000000000000e0 * t990 - 0.17116166666666666666666666666666666666666666666667e0 * t992 - 0.36793333333333333333333333333333333333333333333333e0 * t996
  t1014 = 0.10000000000000000000000000000000000000000000000000e1 * t357 * (-0.50638000000000000000000000000000000000000000000000e1 * t974 + 0.16879333333333333333333333333333333333333333333333e1 * t978 - 0.19692555555555555555555555555555555555555555555555e1 * t981 - 0.93011851851851851851851851851851851851851851851854e0 * t984 + 0.27303333333333333333333333333333333333333333333333e0 * t988 - 0.27303333333333333333333333333333333333333333333333e0 * t990 - 0.31853888888888888888888888888888888888888888888890e0 * t992 - 0.36514074074074074074074074074074074074074074074075e0 * t996) * t378
  t1020 = 0.96490945932906628927985590685407352610080087485128e2 * t69 / t572 / t82 * t910 * t576
  t1038 = 0.71233333333333333333333333333333333333333333333333e-1 * t470 * t533
  t1043 = 0.53424999999999999999999999999999999999999999999999e-1 * t318 * t361 * t356 * t568 * t378
  t1048 = 0.85917146441092277507960503039464796886558811231548e0 * t318 * t361 * t573 * t539 * t576
  t1068 = 0.51725014705706168413145063783413931475389495076352e3 * t69 / t572 / t355 * t910 / t575 / t85
  t1072 = t591 * t393
  t1091 = 0.32530742648344572643999342659690126035062438557102e-1 * t318 * t361 * t654 + 0.10274000000000000000000000000000000000000000000000e0 * t318 * t361 * t589 * t591 * t394 - 0.16265371324172286321999671329845063017531219278551e-1 * t318 * t361 * t658 - 0.48159446095139119802213748237831062407565640073877e0 * t318 * t361 * t662 + 0.21687161765563048429332895106460084023374959038068e-1 * t470 * t616 - t1038 + t1043 + t1048 + 0.68493333333333333333333333333333333333333333333331e-1 * t470 * t585 - 0.51369999999999999999999999999999999999999999999999e-1 * t318 * t361 * t387 * t601 * t394 - 0.16522997748472177549051141846252814409778063686072e1 * t318 * t361 * t606 * t591 * t609 - t935 - t1068 - 0.19298809906722418784174975876487616596976519781280e3 * t97 / t605 / t102 * t1072 * t609 + 0.99999999999999999999999999999999999999999999999999e0 * t388 * (-0.94126000000000000000000000000000000000000000000000e1 * t974 + 0.31375333333333333333333333333333333333333333333334e1 * t978 - 0.36604555555555555555555555555555555555555555555556e1 * t981 - 0.16068111111111111111111111111111111111111111111111e1 * t984 + 0.56103333333333333333333333333333333333333333333332e0 * t988 - 0.56103333333333333333333333333333333333333333333332e0 * t990 - 0.65453888888888888888888888888888888888888888888890e0 * t992 - 0.46308888888888888888888888888888888888888888888888e0 * t996) * t394 + 0.35089340384731224424988055003710697745685326982943e1 * t638 * t948 * t410
  t1134 = 0.20691336878655965245175271659148296983999699561788e4 * t97 / t605 / t386 * t1072 / t608 / t105 - 0.10389453539625517979803415350183779755340003251893e3 * t110 * t963 * t948 * t640 + 0.58482233974552040708313425006184496242808878304903e0 * t404 * t998 * t410 + 0.10253897021007794930818001372045340355835853271641e4 * t110 * t954 * t948 * t957 + 0.60000000000000000000000000000000000000000000000000e1 * t607 * t1072 * t394 + 0.56969282336565386484066937725323112718202900731800e-3 * t62 * t923 * t398 + 0.16562449037037037037037037037037037037037037037036e-2 * t62 * t923 * t382 + t916 - t920 - 0.60000000000000000000000000000000000000000000000000e1 * t590 * t395 * t601 + 0.96494049533612093920874879382438082984882598906400e2 * t607 * t601 * t609 * t393 - 0.35089340384731224424988055003710697745685326982943e1 * t621 * t411 * t632 + 0.51947267698127589899017076750918898776700016259463e2 * t638 * t632 * t640 * t409 - t926 - t913 - t1014 + t1020
  t1146 = 0.10389453539625517979803415350183779755340003251893e3 * t421 * t963 * t948 * t640 - 0.58482233974552040708313425006184496242808878304903e0 * t421 * t403 * t998 * t410 + t1014 - t1020 + t95 * (t1091 + t1134) + 0.16265371324172286321999671329845063017531219278551e-1 * t649 * t365 * t658 + 0.48159446095139119802213748237831062407565640073877e0 * t649 * t365 * t662 - 0.21687161765563048429332895106460084023374959038068e-1 * t649 * t554 * t423 + t1068 + t1038 - t1043 - t1048
  t1150 = f.my_piecewise3(t60, 0, t61 * (t961 + t1146) / 0.2e1)
  t1164 = t456 * t327
  t1176 = t503 * t344
  t1205 = 0.48245472966453314463992795342703676305040043742564e2 * t487 * t481 * t489 * t327 - 0.60000000000000000000000000000000000000000000000000e1 * t455 * t329 * t481 + 0.60000000000000000000000000000000000000000000000000e1 * t487 * t1164 * t328 - 0.32530742648344572643999342659690126035062438557102e-1 * t497 * t305 * t505 - 0.51947267698127589899017076750918898776700016259463e2 * t337 * t520 * t514 * t523 * t344 - 0.35089340384731224424988055003710697745685326982943e1 * t337 * t520 * t1176 * t346 + 0.35089340384731224424988055003710697745685326982943e1 * t337 * t502 * t344 * t346 * t514 + 0.71233333333333333333333333333333333333333333333333e-1 * t62 * t444 * t310 * t329 - 0.53424999999999999999999999999999999999999999999999e-1 * t62 * t449 * t482 - 0.85917146441092277507960503039464796886558811231548e0 * t62 * t304 * t486 * t490 - 0.10253897021007794930818001372045340355835853271641e4 * t337 / t519 / t338 * t1176 / t522 / t53
  t1216 = 0.1e1 / t13 / t24 * t2 * t852 / 0.4e1
  t1218 = t463 * t136
  t1219 = t462 * t1218
  t1221 = t314 * t922
  t1222 = t313 * t1221
  t1224 = t4 * t927
  t1226 = t10 ** (-0.15e1)
  t1228 = t1226 * t2 * t852
  t1230 = t473 * t1218
  t1232 = t321 * t1221
  t1234 = t20 * t976
  t1288 = 0.10389453539625517979803415350183779755340003251893e3 * t337 / t519 / t50 * t1176 * t523 - 0.58482233974552040708313425006184496242808878304903e0 * t337 * t339 * (-0.34523333333333333333333333333333333333333333333333e1 * t1216 + 0.23015555555555555555555555555555555555555555555556e1 * t1219 - 0.26851481481481481481481481481481481481481481481482e1 * t1222 - 0.93932222222222222222222222222222222222222222222223e0 * t1224 + 0.73355000000000000000000000000000000000000000000000e-1 * t1228 - 0.14671000000000000000000000000000000000000000000000e0 * t1230 - 0.17116166666666666666666666666666666666666666666667e0 * t1232 - 0.36793333333333333333333333333333333333333333333333e0 * t1234) * t346 + 0.34451131037037037037037037037037037037037037037036e-2 * t4 * t927 * t30 - 0.56969282336565386484066937725323112718202900731800e-3 * t332 * t314 * t922 * t54 + 0.10685000000000000000000000000000000000000000000000e0 * t62 * t304 * t454 * t457 + 0.51725014705706168413145063783413931475389495076352e3 * t12 / t485 / t309 * t1164 / t488 / t29 - 0.96490945932906628927985590685407352610080087485128e2 * t12 / t485 / t26 * t1164 * t489 + 0.10000000000000000000000000000000000000000000000000e1 * t311 * (-0.25319000000000000000000000000000000000000000000000e1 * t1216 + 0.16879333333333333333333333333333333333333333333333e1 * t1219 - 0.19692555555555555555555555555555555555555555555555e1 * t1222 - 0.93011851851851851851851851851851851851851851851854e0 * t1224 + 0.13651666666666666666666666666666666666666666666667e0 * t1228 - 0.27303333333333333333333333333333333333333333333333e0 * t1230 - 0.31853888888888888888888888888888888888888888888890e0 * t1232 - 0.36514074074074074074074074074074074074074074074075e0 * t1234) * t328 + 0.48159446095139119802213748237831062407565640073877e0 * t497 * t305 * t524 - 0.21687161765563048429332895106460084023374959038068e-1 * t497 * t445 * t347 + 0.16265371324172286321999671329845063017531219278551e-1 * t497 * t305 * t516 - 0.2e1 * t1150
  t1322 = t196 ** 2
  t1340 = -0.20897955555555555555555555555555555555555555555556e-1 * t215 * t803 + 0.40959992888888888888888888888888888888888888888889e-3 * t224 * t803 - 0.34630804444444444444444444444444444444444444444445e-2 * t203 * t803 + 0.34829925925925925925925925925925925925925925925926e-1 * t806 * t208 * t148 - 0.19239335802469135802469135802469135802469135802470e-1 * t817 * t190 + 0.17668777777777777777777777777777777777777777777778e0 * t802 * t174 + 0.22625458903703703703703703703703703703703703703704e-2 * t817 * t198 * t169 - 0.36954916209382716049382716049382716049382716049385e-4 * t218 / t172 / t219 * t817 + 0.91022206419753086419753086419753086419753086419753e-2 * t817 * t211 * t168 - 0.53521057374814814814814814814814814814814814814816e-3 * t195 * t220 * t817 + 0.69934181636424691358024691358024691358024691358028e-5 * t824 / t1322 * t817 + 0.17315402222222222222222222222222222222222222222223e-1 * t779 * t190 * t168 * t183 - 0.33938188355555555555555555555555555555555555555556e-3 * t199 * t183 * t779 - 0.34133327407407407407407407407407407407407407407408e-2 * t212 * t183 * t779 + 0.53521057374814814814814814814814814814814814814816e-4 * t221 * t183 * t779
  t1342 = -0.5e1 / 0.18e2 * t232 * t36 * t159 * t299 + 0.3e1 / 0.4e1 * t746 * t752 + 0.3e1 / 0.2e1 * t714 * t752 + 0.3e1 / 0.4e1 * t688 * t752 - 0.3e1 / 0.4e1 * t232 * t233 * t290 - 0.3e1 / 0.4e1 * t232 * t261 * t842 + t232 * t294 * t257 / 0.2e1 + 0.6e1 * t429 * t745 * t694 + 0.3e1 / 0.2e1 * t758 * s0 * t852 * t691 - 0.3e1 / 0.2e1 * t755 * t761 - 0.3e1 / 0.2e1 * t749 * t761 + 0.2e1 * t129 * t906 * t694 + 0.2e1 * t1150 * t687 * t694 + 0.6e1 * t668 * t713 * t694 + (t1205 + t1288) * t675 + 0.3e1 * t670 * t440 + 0.3e1 * t431 * t227 + t131 * t1340
  v3rho3_0_ = 0.3e1 * t131 * t227 - 0.3e1 / 0.2e1 * t232 * t233 * t257 - 0.9e1 / 0.4e1 * t232 * t261 * t290 + t232 * t294 * t299 / 0.2e1 + 0.6e1 * t431 * t440 + 0.3e1 * t670 * t675 + 0.6e1 * t688 * t694 + 0.12e2 * t714 * t694 + 0.6e1 * t746 * t694 + 0.3e1 / 0.2e1 * t749 * t752 + 0.3e1 / 0.2e1 * t755 * t752 - 0.3e1 / 0.2e1 * t758 * t761 + r0 * t1342

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = r0 ** 2
  t8 = r0 ** (0.1e1 / 0.3e1)
  t10 = 0.1e1 / t8 / t7
  t11 = t6 * t10
  t12 = 0.1e1 / t8
  t14 = t4 * t6 * t12
  t15 = jnp.sqrt(t14)
  t18 = t14 ** 0.15e1
  t20 = t1 ** 2
  t21 = t3 ** 2
  t22 = t20 * t21
  t23 = t8 ** 2
  t24 = 0.1e1 / t23
  t26 = t22 * t5 * t24
  t28 = 0.37978500000000000000000000000000000000000000000000e1 * t15 + 0.89690000000000000000000000000000000000000000000000e0 * t14 + 0.20477500000000000000000000000000000000000000000000e0 * t18 + 0.12323500000000000000000000000000000000000000000000e0 * t26
  t31 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t28
  t32 = jnp.log(t31)
  t36 = t4 * t6
  t38 = 0.1e1 / t8 / r0
  t39 = t28 ** 2
  t40 = 0.1e1 / t39
  t41 = t38 * t40
  t43 = 0.1e1 / t15 * t1
  t44 = t3 * t6
  t45 = t44 * t38
  t46 = t43 * t45
  t48 = t6 * t38
  t49 = t4 * t48
  t51 = t14 ** 0.5e0
  t52 = t51 * t1
  t53 = t52 * t45
  t56 = 0.1e1 / t23 / r0
  t58 = t22 * t5 * t56
  t60 = -0.63297500000000000000000000000000000000000000000000e0 * t46 - 0.29896666666666666666666666666666666666666666666667e0 * t49 - 0.10238750000000000000000000000000000000000000000000e0 * t53 - 0.82156666666666666666666666666666666666666666666667e-1 * t58
  t61 = 0.1e1 / t31
  t62 = t60 * t61
  t67 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t14
  t68 = t39 * t28
  t69 = 0.1e1 / t68
  t70 = t67 * t69
  t71 = t60 ** 2
  t72 = t71 * t61
  t75 = t67 * t40
  t78 = 0.1e1 / t15 / t14 * t20
  t79 = t21 * t5
  t81 = 0.1e1 / t23 / t7
  t82 = t79 * t81
  t83 = t78 * t82
  t85 = t44 * t10
  t86 = t43 * t85
  t88 = t4 * t11
  t90 = t14 ** (-0.5e0)
  t91 = t90 * t20
  t92 = t91 * t82
  t94 = t52 * t85
  t96 = t5 * t81
  t97 = t22 * t96
  t99 = -0.42198333333333333333333333333333333333333333333333e0 * t83 + 0.84396666666666666666666666666666666666666666666666e0 * t86 + 0.39862222222222222222222222222222222222222222222223e0 * t88 + 0.68258333333333333333333333333333333333333333333333e-1 * t92 + 0.13651666666666666666666666666666666666666666666667e0 * t94 + 0.13692777777777777777777777777777777777777777777778e0 * t97
  t100 = t99 * t61
  t103 = t39 ** 2
  t104 = 0.1e1 / t103
  t105 = t67 * t104
  t106 = t31 ** 2
  t107 = 0.1e1 / t106
  t108 = t71 * t107
  t111 = 0.1e1 <= f.p.zeta_threshold
  t112 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t113 = t112 * f.p.zeta_threshold
  t114 = f.my_piecewise3(t111, t113, 1)
  t117 = 2 ** (0.1e1 / 0.3e1)
  t120 = 0.1e1 / (0.2e1 * t117 - 0.2e1)
  t121 = (0.2e1 * t114 - 0.2e1) * t120
  t122 = t121 * t1
  t127 = 0.51785000000000000000000000000000000000000000000000e1 * t15 + 0.90577500000000000000000000000000000000000000000000e0 * t14 + 0.11003250000000000000000000000000000000000000000000e0 * t18 + 0.12417750000000000000000000000000000000000000000000e0 * t26
  t130 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t127
  t131 = jnp.log(t130)
  t136 = t121 * t4
  t137 = t127 ** 2
  t138 = 0.1e1 / t137
  t143 = -0.86308333333333333333333333333333333333333333333334e0 * t46 - 0.30192500000000000000000000000000000000000000000000e0 * t49 - 0.55016250000000000000000000000000000000000000000000e-1 * t53 - 0.82785000000000000000000000000000000000000000000000e-1 * t58
  t145 = 0.1e1 / t130
  t146 = t138 * t143 * t145
  t151 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t14
  t152 = t121 * t151
  t153 = t137 * t127
  t154 = 0.1e1 / t153
  t155 = t143 ** 2
  t157 = t154 * t155 * t145
  t166 = -0.57538888888888888888888888888888888888888888888889e0 * t83 + 0.11507777777777777777777777777777777777777777777778e1 * t86 + 0.40256666666666666666666666666666666666666666666667e0 * t88 + 0.36677500000000000000000000000000000000000000000000e-1 * t92 + 0.73355000000000000000000000000000000000000000000000e-1 * t94 + 0.13797500000000000000000000000000000000000000000000e0 * t97
  t168 = t138 * t166 * t145
  t171 = t137 ** 2
  t172 = 0.1e1 / t171
  t173 = t172 * t155
  t174 = t130 ** 2
  t175 = 0.1e1 / t174
  t176 = t173 * t175
  t181 = r0 / 0.2e1 <= f.p.dens_threshold or t111
  t182 = f.my_piecewise3(t111, f.p.zeta_threshold, 1)
  t183 = t10 * t117
  t185 = f.my_piecewise3(t111, 0.1e1 / t112, 1)
  t188 = t36 * t12 * t117 * t185
  t189 = jnp.sqrt(t188)
  t192 = t188 ** 0.15e1
  t194 = t22 * t5
  t195 = t117 ** 2
  t197 = t185 ** 2
  t199 = t194 * t24 * t195 * t197
  t201 = 0.37978500000000000000000000000000000000000000000000e1 * t189 + 0.89690000000000000000000000000000000000000000000000e0 * t188 + 0.20477500000000000000000000000000000000000000000000e0 * t192 + 0.12323500000000000000000000000000000000000000000000e0 * t199
  t204 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t201
  t205 = jnp.log(t204)
  t206 = t185 * t205
  t209 = 0.14764770444444444444444444444444444444444444444444e-2 * t36 * t183 * t206
  t210 = t117 * t185
  t211 = t201 ** 2
  t212 = 0.1e1 / t211
  t215 = 0.1e1 / t189 * t1 * t3
  t216 = t48 * t210
  t217 = t215 * t216
  t219 = t38 * t117
  t220 = t219 * t185
  t221 = t36 * t220
  t223 = t188 ** 0.5e0
  t225 = t223 * t1 * t3
  t226 = t225 * t216
  t230 = t194 * t56 * t195 * t197
  t232 = -0.63297500000000000000000000000000000000000000000000e0 * t217 - 0.29896666666666666666666666666666666666666666666667e0 * t221 - 0.10238750000000000000000000000000000000000000000000e0 * t226 - 0.82156666666666666666666666666666666666666666666667e-1 * t230
  t234 = 0.1e1 / t204
  t236 = t210 * t212 * t232 * t234
  t238 = 0.35616666666666666666666666666666666666666666666666e-1 * t49 * t236
  t240 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t188
  t241 = t211 * t201
  t242 = 0.1e1 / t241
  t243 = t240 * t242
  t244 = t232 ** 2
  t245 = t244 * t234
  t247 = 0.20000000000000000000000000000000000000000000000000e1 * t243 * t245
  t248 = t240 * t212
  t252 = 0.1e1 / t189 / t188 * t20 * t21
  t253 = t195 * t197
  t254 = t96 * t253
  t255 = t252 * t254
  t257 = t11 * t210
  t258 = t215 * t257
  t260 = t183 * t185
  t261 = t36 * t260
  t263 = t188 ** (-0.5e0)
  t265 = t263 * t20 * t21
  t266 = t265 * t254
  t268 = t225 * t257
  t272 = t194 * t81 * t195 * t197
  t274 = -0.42198333333333333333333333333333333333333333333333e0 * t255 + 0.84396666666666666666666666666666666666666666666666e0 * t258 + 0.39862222222222222222222222222222222222222222222223e0 * t261 + 0.68258333333333333333333333333333333333333333333333e-1 * t266 + 0.13651666666666666666666666666666666666666666666667e0 * t268 + 0.13692777777777777777777777777777777777777777777778e0 * t272
  t277 = 0.10000000000000000000000000000000000000000000000000e1 * t248 * t274 * t234
  t278 = t211 ** 2
  t279 = 0.1e1 / t278
  t280 = t240 * t279
  t281 = t204 ** 2
  t282 = 0.1e1 / t281
  t283 = t244 * t282
  t285 = 0.16081824322151104821330931780901225435013347914188e2 * t280 * t283
  t288 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t113, 0.2e1 * t117)
  t290 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t113, 0)
  t292 = (t288 + t290 - 0.2e1) * t120
  t297 = 0.70594500000000000000000000000000000000000000000000e1 * t189 + 0.15494250000000000000000000000000000000000000000000e1 * t188 + 0.42077500000000000000000000000000000000000000000000e0 * t192 + 0.15629250000000000000000000000000000000000000000000e0 * t199
  t300 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t297
  t301 = jnp.log(t300)
  t302 = t185 * t301
  t306 = t297 ** 2
  t307 = 0.1e1 / t306
  t312 = -0.11765750000000000000000000000000000000000000000000e1 * t217 - 0.51647500000000000000000000000000000000000000000000e0 * t221 - 0.21038750000000000000000000000000000000000000000000e0 * t226 - 0.10419500000000000000000000000000000000000000000000e0 * t230
  t314 = 0.1e1 / t300
  t316 = t210 * t307 * t312 * t314
  t320 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t188
  t321 = t306 * t297
  t322 = 0.1e1 / t321
  t323 = t320 * t322
  t324 = t312 ** 2
  t325 = t324 * t314
  t328 = t320 * t307
  t335 = -0.78438333333333333333333333333333333333333333333333e0 * t255 + 0.15687666666666666666666666666666666666666666666667e1 * t258 + 0.68863333333333333333333333333333333333333333333333e0 * t261 + 0.14025833333333333333333333333333333333333333333333e0 * t266 + 0.28051666666666666666666666666666666666666666666667e0 * t268 + 0.17365833333333333333333333333333333333333333333333e0 * t272
  t339 = t306 ** 2
  t340 = 0.1e1 / t339
  t341 = t320 * t340
  t342 = t300 ** 2
  t343 = 0.1e1 / t342
  t344 = t324 * t343
  t351 = 0.51785000000000000000000000000000000000000000000000e1 * t189 + 0.90577500000000000000000000000000000000000000000000e0 * t188 + 0.11003250000000000000000000000000000000000000000000e0 * t192 + 0.12417750000000000000000000000000000000000000000000e0 * t199
  t354 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t351
  t355 = jnp.log(t354)
  t356 = t185 * t355
  t360 = t351 ** 2
  t361 = 0.1e1 / t360
  t366 = -0.86308333333333333333333333333333333333333333333334e0 * t217 - 0.30192500000000000000000000000000000000000000000000e0 * t221 - 0.55016250000000000000000000000000000000000000000000e-1 * t226 - 0.82785000000000000000000000000000000000000000000000e-1 * t230
  t368 = 0.1e1 / t354
  t369 = t361 * t366 * t368
  t370 = t210 * t369
  t374 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t188
  t375 = t360 * t351
  t376 = 0.1e1 / t375
  t377 = t374 * t376
  t378 = t366 ** 2
  t379 = t378 * t368
  t382 = t374 * t361
  t389 = -0.57538888888888888888888888888888888888888888888889e0 * t255 + 0.11507777777777777777777777777777777777777777777778e1 * t258 + 0.40256666666666666666666666666666666666666666666667e0 * t261 + 0.36677500000000000000000000000000000000000000000000e-1 * t266 + 0.73355000000000000000000000000000000000000000000000e-1 * t268 + 0.13797500000000000000000000000000000000000000000000e0 * t272
  t390 = t389 * t368
  t393 = t360 ** 2
  t394 = 0.1e1 / t393
  t395 = t374 * t394
  t396 = t354 ** 2
  t397 = 0.1e1 / t396
  t398 = t378 * t397
  t401 = -0.70981924444444444444444444444444444444444444444442e-3 * t36 * t183 * t302 - 0.34246666666666666666666666666666666666666666666666e-1 * t49 * t316 - 0.20000000000000000000000000000000000000000000000000e1 * t323 * t325 + 0.99999999999999999999999999999999999999999999999999e0 * t328 * t335 * t314 + 0.32164683177870697973624959794146027661627532968800e2 * t341 * t344 + t209 + t238 + t247 - t277 - t285 - 0.24415406715670879921742973310852762593515528885057e-3 * t36 * t183 * t356 - 0.10843580882781524214666447553230042011687479519034e-1 * t49 * t370 - 0.11696446794910408141662685001236899248561775660981e1 * t377 * t379 + 0.58482233974552040708313425006184496242808878304903e0 * t382 * t390 + 0.17315755899375863299672358916972966258900005419821e2 * t395 * t398
  t403 = t292 * t4
  t404 = t210 * t355
  t408 = t292 * t36
  t412 = t292 * t374
  t414 = t376 * t378 * t368
  t418 = t361 * t389 * t368
  t421 = t394 * t378
  t422 = t421 * t397
  t425 = -t209 - t238 - t247 + t277 + t285 + t292 * t401 + 0.24415406715670879921742973310852762593515528885057e-3 * t403 * t11 * t404 + 0.10843580882781524214666447553230042011687479519034e-1 * t408 * t220 * t369 + 0.11696446794910408141662685001236899248561775660981e1 * t412 * t414 - 0.58482233974552040708313425006184496242808878304903e0 * t412 * t418 - 0.17315755899375863299672358916972966258900005419821e2 * t412 * t422
  t428 = f.my_piecewise3(t181, 0, t182 * t425 / 0.2e1)
  t430 = -0.14764770444444444444444444444444444444444444444444e-2 * t4 * t11 * t32 - 0.35616666666666666666666666666666666666666666666666e-1 * t36 * t41 * t62 - 0.20000000000000000000000000000000000000000000000000e1 * t70 * t72 + 0.10000000000000000000000000000000000000000000000000e1 * t75 * t100 + 0.16081824322151104821330931780901225435013347914188e2 * t105 * t108 + 0.24415406715670879921742973310852762593515528885057e-3 * t122 * t44 * t10 * t131 + 0.10843580882781524214666447553230042011687479519034e-1 * t136 * t48 * t146 + 0.11696446794910408141662685001236899248561775660981e1 * t152 * t157 - 0.58482233974552040708313425006184496242808878304903e0 * t152 * t168 - 0.17315755899375863299672358916972966258900005419821e2 * t152 * t176 - 0.2e1 * t428
  t431 = tau0 * t195
  t434 = s0 * t195
  t435 = t7 * r0
  t437 = 0.1e1 / t23 / t435
  t440 = l0 * t195
  t443 = -0.5e1 / 0.3e1 * t431 * t81 + t434 * t437 / 0.3e1 + 0.5e1 / 0.12e2 * t440 * t81
  t444 = 6 ** (0.1e1 / 0.3e1)
  t445 = t443 * t444
  t446 = jnp.pi ** 2
  t447 = t446 ** (0.1e1 / 0.3e1)
  t448 = t447 ** 2
  t449 = 0.1e1 / t448
  t459 = 0.1e1 - 0.5e1 / 0.9e1 * (t431 * t56 - t434 * t81 / 0.8e1 - t440 * t56 / 0.4e1) * t444 * t449
  t460 = t459 ** 2
  t462 = 0.1e1 + 0.196e-1 * t460
  t463 = jnp.sqrt(t462)
  t464 = 0.1e1 / t463
  t465 = t449 * t464
  t469 = 0.1e1 / t463 / t462
  t470 = t460 * t469
  t471 = t445 * t449
  t474 = 0.1e1 / t462
  t475 = t459 * t474
  t478 = t460 * t459
  t479 = t462 ** 2
  t480 = 0.1e1 / t479
  t481 = t478 * t480
  t484 = 0.17668777777777777777777777777777777777777777777778e0 * t445 * t465 - 0.34630804444444444444444444444444444444444444444445e-2 * t470 * t471 - 0.20897955555555555555555555555555555555555555555556e-1 * t475 * t471 + 0.40959992888888888888888888888888888888888888888889e-3 * t481 * t471
  t500 = 0.11073577833333333333333333333333333333333333333333e-2 * t36 * t219 * t206
  t501 = t232 * t234
  t503 = 0.10000000000000000000000000000000000000000000000000e1 * t248 * t501
  t507 = t312 * t314
  t513 = t366 * t368
  t526 = f.my_piecewise3(t181, 0, t182 * (t500 + t503 + t292 * (0.53236443333333333333333333333333333333333333333332e-3 * t36 * t219 * t302 + 0.99999999999999999999999999999999999999999999999999e0 * t328 * t507 - t500 - t503 + 0.18311555036753159941307229983139571945136646663793e-3 * t36 * t219 * t356 + 0.58482233974552040708313425006184496242808878304903e0 * t382 * t513) - 0.18311555036753159941307229983139571945136646663793e-3 * t403 * t48 * t404 - 0.58482233974552040708313425006184496242808878304903e0 * t412 * t369) / 0.2e1)
  t528 = 0.11073577833333333333333333333333333333333333333333e-2 * t4 * t48 * t32 + 0.10000000000000000000000000000000000000000000000000e1 * t75 * t62 - 0.18311555036753159941307229983139571945136646663793e-3 * t122 * t44 * t38 * t131 - 0.58482233974552040708313425006184496242808878304903e0 * t152 * t146 - 0.2e1 * t526
  t531 = t7 ** 2
  t533 = 0.1e1 / t23 / t531
  t538 = 0.40e2 / 0.9e1 * t431 * t437 - 0.11e2 / 0.9e1 * t434 * t533 - 0.10e2 / 0.9e1 * t440 * t437
  t539 = t538 * t444
  t542 = t443 ** 2
  t543 = t444 ** 2
  t544 = t542 * t543
  t546 = 0.1e1 / t447 / t446
  t548 = t546 * t469 * t459
  t552 = 0.1e1 / t463 / t479
  t553 = t478 * t552
  t554 = t544 * t546
  t557 = t539 * t449
  t560 = t546 * t474
  t563 = t460 * t480
  t568 = t460 ** 2
  t569 = t479 * t462
  t570 = 0.1e1 / t569
  t571 = t568 * t570
  t576 = 0.17668777777777777777777777777777777777777777777778e0 * t539 * t465 + 0.57718007407407407407407407407407407407407407407409e-2 * t544 * t548 - 0.11312729451851851851851851851851851851851851851852e-3 * t553 * t554 - 0.34630804444444444444444444444444444444444444444445e-2 * t470 * t557 + 0.11609975308641975308641975308641975308641975308642e-1 * t544 * t560 - 0.11377775802469135802469135802469135802469135802469e-2 * t563 * t554 - 0.20897955555555555555555555555555555555555555555556e-1 * t475 * t557 + 0.17840352458271604938271604938271604938271604938272e-4 * t571 * t554 + 0.40959992888888888888888888888888888888888888888889e-3 * t481 * t557
  t579 = t99 * t107
  t586 = t71 * t60
  t587 = t586 * t61
  t594 = 0.1e1 / t171 / t137
  t595 = t155 * t143
  t598 = 0.1e1 / t174 / t130
  t599 = t594 * t595 * t598
  t603 = 0.1e1 / t171 / t127
  t605 = t603 * t595 * t175
  t611 = 0.1e1 / t15 / t26 * t2 / 0.4e1
  t612 = 0.1e1 / t531
  t613 = t611 * t612
  t615 = t79 * t437
  t616 = t78 * t615
  t619 = 0.1e1 / t8 / t435
  t620 = t44 * t619
  t621 = t43 * t620
  t623 = t6 * t619
  t624 = t4 * t623
  t626 = t14 ** (-0.15e1)
  t627 = t626 * t2
  t628 = t627 * t612
  t630 = t91 * t615
  t632 = t52 * t620
  t634 = t5 * t437
  t635 = t22 * t634
  t637 = -0.34523333333333333333333333333333333333333333333333e1 * t613 + 0.23015555555555555555555555555555555555555555555556e1 * t616 - 0.26851481481481481481481481481481481481481481481482e1 * t621 - 0.93932222222222222222222222222222222222222222222223e0 * t624 + 0.73355000000000000000000000000000000000000000000000e-1 * t628 - 0.14671000000000000000000000000000000000000000000000e0 * t630 - 0.17116166666666666666666666666666666666666666666667e0 * t632 - 0.36793333333333333333333333333333333333333333333333e0 * t635
  t639 = t138 * t637 * t145
  t643 = 0.1e1 / t103 / t39
  t644 = t67 * t643
  t646 = 0.1e1 / t106 / t31
  t647 = t586 * t646
  t651 = 0.1e1 / t103 / t28
  t652 = t67 * t651
  t653 = t586 * t107
  t664 = -0.25319000000000000000000000000000000000000000000000e1 * t613 + 0.16879333333333333333333333333333333333333333333333e1 * t616 - 0.19692555555555555555555555555555555555555555555555e1 * t621 - 0.93011851851851851851851851851851851851851851851854e0 * t624 + 0.13651666666666666666666666666666666666666666666667e0 * t628 - 0.27303333333333333333333333333333333333333333333333e0 * t630 - 0.31853888888888888888888888888888888888888888888890e0 * t632 - 0.36514074074074074074074074074074074074074074074075e0 * t635
  t665 = t664 * t61
  t672 = 0.48245472966453314463992795342703676305040043742564e2 * t105 * t579 * t60 - 0.60000000000000000000000000000000000000000000000000e1 * t70 * t62 * t99 + 0.60000000000000000000000000000000000000000000000000e1 * t105 * t587 - 0.32530742648344572643999342659690126035062438557102e-1 * t136 * t48 * t157 - 0.10253897021007794930818001372045340355835853271641e4 * t152 * t599 + 0.10389453539625517979803415350183779755340003251893e3 * t152 * t605 - 0.58482233974552040708313425006184496242808878304903e0 * t152 * t639 + 0.51725014705706168413145063783413931475389495076352e3 * t644 * t647 - 0.96490945932906628927985590685407352610080087485128e2 * t652 * t653 + 0.10000000000000000000000000000000000000000000000000e1 * t75 * t665 - 0.56969282336565386484066937725323112718202900731800e-3 * t122 * t44 * t619 * t131
  t678 = t175 * t143
  t683 = t172 * t595 * t145
  t687 = t145 * t166
  t691 = t10 * t40
  t698 = t38 * t104
  t714 = t244 * t232
  t717 = 0.60000000000000000000000000000000000000000000000000e1 * t280 * t714 * t234
  t718 = t501 * t274
  t720 = 0.60000000000000000000000000000000000000000000000000e1 * t243 * t718
  t722 = t274 * t282 * t232
  t724 = 0.48245472966453314463992795342703676305040043742564e2 * t280 * t722
  t725 = t619 * t117
  t728 = 0.34451131037037037037037037037037037037037037037036e-2 * t36 * t725 * t206
  t734 = t210 * t242 * t244 * t234
  t736 = 0.10685000000000000000000000000000000000000000000000e0 * t49 * t734
  t738 = t397 * t366
  t745 = t376 * t366
  t749 = t378 * t366
  t751 = t394 * t749 * t368
  t757 = t717 - t720 + t724 + t728 - 0.56969282336565386484066937725323112718202900731800e-3 * t403 * t623 * t404 + t736 - 0.51947267698127589899017076750918898776700016259463e2 * t412 * t394 * t389 * t738 - 0.32530742648344572643999342659690126035062438557102e-1 * t408 * t220 * t414 + 0.35089340384731224424988055003710697745685326982943e1 * t412 * t745 * t390 - 0.35089340384731224424988055003710697745685326982943e1 * t412 * t751 + 0.16265371324172286321999671329845063017531219278551e-1 * t408 * t220 * t418
  t765 = 0.1e1 / t339 / t297
  t766 = t320 * t765
  t767 = t324 * t312
  t774 = 0.1e1 / t189 / t199 * t2 / 0.4e1
  t775 = t197 * t185
  t776 = t612 * t775
  t777 = t774 * t776
  t779 = t634 * t253
  t780 = t252 * t779
  t782 = t623 * t210
  t783 = t215 * t782
  t785 = t725 * t185
  t786 = t36 * t785
  t788 = t188 ** (-0.15e1)
  t789 = t788 * t2
  t790 = t789 * t776
  t792 = t265 * t779
  t794 = t225 * t782
  t798 = t194 * t437 * t195 * t197
  t800 = -0.94126000000000000000000000000000000000000000000000e1 * t777 + 0.31375333333333333333333333333333333333333333333334e1 * t780 - 0.36604555555555555555555555555555555555555555555556e1 * t783 - 0.16068111111111111111111111111111111111111111111111e1 * t786 + 0.56103333333333333333333333333333333333333333333332e0 * t790 - 0.56103333333333333333333333333333333333333333333332e0 * t792 - 0.65453888888888888888888888888888888888888888888890e0 * t794 - 0.46308888888888888888888888888888888888888888888888e0 * t798
  t810 = t507 * t335
  t814 = t335 * t343 * t312
  t817 = t513 * t389
  t821 = t389 * t397 * t366
  t830 = t210 * t414
  t833 = -0.19298809906722418784174975876487616596976519781280e3 * t766 * t767 * t343 + 0.99999999999999999999999999999999999999999999999999e0 * t328 * t800 * t314 + 0.60000000000000000000000000000000000000000000000000e1 * t341 * t767 * t314 + 0.35089340384731224424988055003710697745685326982943e1 * t395 * t749 * t368 - t717 - t728 - 0.60000000000000000000000000000000000000000000000000e1 * t323 * t810 + 0.96494049533612093920874879382438082984882598906400e2 * t341 * t814 - 0.35089340384731224424988055003710697745685326982943e1 * t377 * t817 + 0.51947267698127589899017076750918898776700016259463e2 * t395 * t821 + t720 - t724 + 0.16562449037037037037037037037037037037037037037036e-2 * t36 * t725 * t302 + 0.56969282336565386484066937725323112718202900731800e-3 * t36 * t725 * t356 - t736 + 0.32530742648344572643999342659690126035062438557102e-1 * t49 * t830
  t836 = t210 * t322 * t324 * t314
  t839 = t210 * t418
  t842 = t210 * t422
  t848 = 0.71233333333333333333333333333333333333333333333333e-1 * t88 * t236
  t851 = t210 * t212 * t274 * t234
  t853 = 0.53424999999999999999999999999999999999999999999999e-1 * t49 * t851
  t856 = t210 * t279 * t244 * t282
  t858 = 0.85917146441092277507960503039464796886558811231548e0 * t49 * t856
  t863 = t210 * t307 * t335 * t314
  t868 = t210 * t340 * t324 * t343
  t872 = 0.1e1 / t393 / t360
  t873 = t374 * t872
  t875 = 0.1e1 / t396 / t354
  t880 = 0.1e1 / t393 / t351
  t881 = t374 * t880
  t893 = -0.69046666666666666666666666666666666666666666666667e1 * t777 + 0.23015555555555555555555555555555555555555555555556e1 * t780 - 0.26851481481481481481481481481481481481481481481482e1 * t783 - 0.93932222222222222222222222222222222222222222222223e0 * t786 + 0.14671000000000000000000000000000000000000000000000e0 * t790 - 0.14671000000000000000000000000000000000000000000000e0 * t792 - 0.17116166666666666666666666666666666666666666666667e0 * t794 - 0.36793333333333333333333333333333333333333333333333e0 * t798
  t894 = t893 * t368
  t898 = 0.1e1 / t339 / t306
  t899 = t320 * t898
  t901 = 0.1e1 / t342 / t300
  t906 = 0.1e1 / t278 / t201
  t907 = t240 * t906
  t910 = 0.96490945932906628927985590685407352610080087485128e2 * t907 * t714 * t282
  t919 = -0.50638000000000000000000000000000000000000000000000e1 * t777 + 0.16879333333333333333333333333333333333333333333333e1 * t780 - 0.19692555555555555555555555555555555555555555555555e1 * t783 - 0.93011851851851851851851851851851851851851851851854e0 * t786 + 0.27303333333333333333333333333333333333333333333333e0 * t790 - 0.27303333333333333333333333333333333333333333333333e0 * t792 - 0.31853888888888888888888888888888888888888888888890e0 * t794 - 0.36514074074074074074074074074074074074074074074075e0 * t798
  t922 = 0.10000000000000000000000000000000000000000000000000e1 * t248 * t919 * t234
  t924 = 0.1e1 / t278 / t211
  t925 = t240 * t924
  t927 = 0.1e1 / t281 / t204
  t930 = 0.51725014705706168413145063783413931475389495076352e3 * t925 * t714 * t927
  t931 = 0.10274000000000000000000000000000000000000000000000e0 * t49 * t836 - 0.16265371324172286321999671329845063017531219278551e-1 * t49 * t839 - 0.48159446095139119802213748237831062407565640073877e0 * t49 * t842 + 0.21687161765563048429332895106460084023374959038068e-1 * t88 * t370 - t848 + t853 + t858 + 0.68493333333333333333333333333333333333333333333331e-1 * t88 * t316 - 0.51369999999999999999999999999999999999999999999999e-1 * t49 * t863 - 0.16522997748472177549051141846252814409778063686072e1 * t49 * t868 + 0.10253897021007794930818001372045340355835853271641e4 * t873 * t749 * t875 - 0.10389453539625517979803415350183779755340003251893e3 * t881 * t749 * t397 + 0.58482233974552040708313425006184496242808878304903e0 * t382 * t894 + 0.20691336878655965245175271659148296983999699561788e4 * t899 * t767 * t901 + t910 - t922 - t930
  t935 = t880 * t749 * t397
  t939 = t361 * t893 * t368
  t943 = t872 * t749 * t875
  t946 = 0.48159446095139119802213748237831062407565640073877e0 * t408 * t220 * t422 - 0.21687161765563048429332895106460084023374959038068e-1 * t408 * t260 * t369 + t292 * (t833 + t931) - t910 + t922 + t930 + 0.10389453539625517979803415350183779755340003251893e3 * t412 * t935 - 0.58482233974552040708313425006184496242808878304903e0 * t412 * t939 - 0.10253897021007794930818001372045340355835853271641e4 * t412 * t943 + t848 - t853 - t858
  t950 = f.my_piecewise3(t181, 0, t182 * (t757 + t946) / 0.2e1)
  t952 = 0.10685000000000000000000000000000000000000000000000e0 * t36 * t38 * t69 * t72 - 0.51947267698127589899017076750918898776700016259463e2 * t152 * t172 * t166 * t678 - 0.35089340384731224424988055003710697745685326982943e1 * t152 * t683 + 0.35089340384731224424988055003710697745685326982943e1 * t152 * t154 * t143 * t687 + 0.71233333333333333333333333333333333333333333333333e-1 * t36 * t691 * t62 - 0.53424999999999999999999999999999999999999999999999e-1 * t36 * t41 * t100 - 0.85917146441092277507960503039464796886558811231548e0 * t36 * t698 * t108 + 0.34451131037037037037037037037037037037037037037036e-2 * t4 * t623 * t32 + 0.48159446095139119802213748237831062407565640073877e0 * t136 * t48 * t176 - 0.21687161765563048429332895106460084023374959038068e-1 * t136 * t11 * t146 + 0.16265371324172286321999671329845063017531219278551e-1 * t136 * t48 * t168 - 0.2e1 * t950
  t953 = t672 + t952
  t958 = 0.12033e1 - 0.318038e0 * t459 * t464 + 0.1880816e-1 * t460 * t474
  t961 = jnp.pi ** (0.1e1 / 0.3e1)
  t963 = t1 / t961
  t964 = t114 * t24
  t966 = 0.1e1 + 0.121e-1 * t460
  t967 = jnp.sqrt(t966)
  t968 = 0.1e1 / t967
  t969 = t449 * t968
  t973 = 0.1e1 / t967 / t966
  t975 = t546 * t973 * t459
  t978 = t966 ** 2
  t980 = 0.1e1 / t967 / t978
  t981 = t478 * t980
  t984 = t460 * t973
  t987 = 0.1e1 / t966
  t988 = t546 * t987
  t991 = 0.1e1 / t978
  t992 = t460 * t991
  t995 = t459 * t987
  t998 = t978 * t966
  t999 = 0.1e1 / t998
  t1000 = t568 * t999
  t1003 = t478 * t991
  t1006 = -0.40834444444444444444444444444444444444444444444444e-1 * t539 * t969 - 0.82349462962962962962962962962962962962962962962960e-3 * t544 * t975 + 0.99642850185185185185185185185185185185185185185178e-5 * t981 * t554 + 0.49409677777777777777777777777777777777777777777776e-3 * t984 * t557 + 0.10606172839506172839506172839506172839506172839506e-2 * t544 * t988 - 0.64167345679012345679012345679012345679012345679011e-4 * t992 * t554 - 0.19091111111111111111111111111111111111111111111111e-2 * t995 * t557 + 0.62113990617283950617283950617283950617283950617281e-6 * t1000 * t554 + 0.23100244444444444444444444444444444444444444444444e-4 * t1003 * t557
  t1010 = t114 * t8
  t1013 = t531 * r0
  t1015 = 0.1e1 / t23 / t1013
  t1020 = -0.440e3 / 0.27e2 * t431 * t533 + 0.154e3 / 0.27e2 * t434 * t1015 + 0.110e3 / 0.27e2 * t440 * t533
  t1021 = t1020 * t444
  t1022 = t1021 * t449
  t1025 = t443 * t543
  t1034 = t446 ** 2
  t1035 = 0.1e1 / t1034
  t1036 = t542 * t443 * t1035
  t1040 = t538 * t543 * t546
  t1041 = t973 * t459
  t1056 = t980 * t460
  t1060 = 0.1e1 / t967 / t998
  t1061 = t568 * t1060
  t1067 = t478 * t999
  t1070 = t568 * t459
  t1071 = t978 ** 2
  t1072 = 0.1e1 / t1071
  t1073 = t1070 * t1072
  t1076 = 0.49409677777777777777777777777777777777777777777776e-3 * t984 * t1022 + 0.31818518518518518518518518518518518518518518518518e-2 * t1025 * t988 * t538 - 0.19091111111111111111111111111111111111111111111111e-2 * t995 * t1022 + 0.23100244444444444444444444444444444444444444444444e-4 * t1003 * t1022 + 0.27449820987654320987654320987654320987654320987653e-2 * t1036 * t973 - 0.24704838888888888888888888888888888888888888888888e-2 * t1040 * t1041 * t443 + 0.29892855055555555555555555555555555555555555555554e-4 * t981 * t443 * t1040 - 0.19250203703703703703703703703703703703703703703703e-3 * t992 * t443 * t1040 + 0.18634197185185185185185185185185185185185185185184e-5 * t1000 * t443 * t1040 - 0.40834444444444444444444444444444444444444444444444e-1 * t1021 * t969 - 0.19928570037037037037037037037037037037037037037036e-3 * t1036 * t1056 + 0.20094641454012345679012345679012345679012345679010e-5 * t1061 * t1036 + 0.51333876543209876543209876543209876543209876543209e-3 * t1036 * t991 * t459 - 0.18634197185185185185185185185185185185185185185184e-4 * t1067 * t1036 + 0.15031585729382716049382716049382716049382716049381e-6 * t1073 * t1036
  t1080 = t114 * t56
  t1089 = -0.40834444444444444444444444444444444444444444444444e-1 * t445 * t969 + 0.49409677777777777777777777777777777777777777777776e-3 * t984 * t471 - 0.19091111111111111111111111111111111111111111111111e-2 * t995 * t471 + 0.23100244444444444444444444444444444444444444444444e-4 * t1003 * t471
  t1094 = 0.1e1 + 0.256e1 * t460
  t1095 = jnp.sqrt(t1094)
  t1096 = 0.1e1 / t1095
  t1099 = 0.1e1 / t1094
  t1102 = 0.2606e0 - 0.153728e1 * t459 * t1096 + 0.2309888e1 * t460 * t1099
  t1103 = t428 * t1102
  t1106 = 0.1e1 / tau0
  t1107 = s0 / t7 * t1106
  t1110 = t449 * t1096
  t1114 = 0.1e1 / t1095 / t1094
  t1115 = t460 * t1114
  t1118 = t459 * t1099
  t1121 = t1094 ** 2
  t1122 = 0.1e1 / t1121
  t1123 = t478 * t1122
  t1126 = 0.85404444444444444444444444444444444444444444444445e0 * t445 * t1110 - 0.21863537777777777777777777777777777777777777777777e1 * t1115 * t471 - 0.25665422222222222222222222222222222222222222222222e1 * t1118 * t471 + 0.65703480888888888888888888888888888888888888888888e1 * t1123 * t471
  t1127 = t526 * t1126
  t1131 = 0.62182e-1 * t240 * t205
  t1134 = t374 * t355
  t1143 = f.my_piecewise3(t181, 0, t182 * (-t1131 + t292 * (-0.31090e-1 * t320 * t301 + t1131 - 0.19751789702565206228825776161588751761046270558698e-1 * t1134) + 0.19751789702565206228825776161588751761046270558698e-1 * t292 * t1134) / 0.2e1)
  t1147 = t546 * t1114 * t459
  t1151 = 0.1e1 / t1095 / t1121
  t1152 = t478 * t1151
  t1157 = t546 * t1099
  t1160 = t460 * t1122
  t1165 = t1121 * t1094
  t1166 = 0.1e1 / t1165
  t1167 = t568 * t1166
  t1172 = 0.85404444444444444444444444444444444444444444444445e0 * t539 * t1110 + 0.36439229629629629629629629629629629629629629629629e1 * t544 * t1147 - 0.93284427851851851851851851851851851851851851851847e1 * t1152 * t554 - 0.21863537777777777777777777777777777777777777777777e1 * t1115 * t557 + 0.14258567901234567901234567901234567901234567901234e1 * t544 * t1157 - 0.18250966913580246913580246913580246913580246913580e2 * t1160 * t554 - 0.25665422222222222222222222222222222222222222222222e1 * t1118 * t557 + 0.37377980239012345679012345679012345679012345679011e2 * t1167 * t554 + 0.65703480888888888888888888888888888888888888888888e1 * t1123 * t557
  t1173 = t1143 * t1172
  t1176 = t114 * t81
  t1181 = 0.8085e0 + 0.73502e-1 * t459 * t968 + 0.171820e-2 * t460 * t987
  t1185 = t526 * t1172
  t1186 = 0.1e1 / r0
  t1190 = 0.1e1 - s0 * t1186 * t1106 / 0.8e1
  t1193 = t526 * t1102
  t1196 = s0 / t435 * t1106
  t1199 = t1143 * t1126
  t1208 = -0.62182e-1 * t67 * t32 + 0.19751789702565206228825776161588751761046270558698e-1 * t121 * t151 * t131 - 0.2e1 * t1143
  t1209 = t571 * t443
  t1213 = t469 * t459 * t443
  t1216 = t553 * t443
  t1219 = t563 * t443
  t1224 = t552 * t460
  t1228 = 0.1e1 / t463 / t569
  t1229 = t568 * t1228
  t1232 = t480 * t459
  t1235 = t478 * t570
  t1238 = t479 ** 2
  t1239 = 0.1e1 / t1238
  t1240 = t1070 * t1239
  t1254 = 0.53521057374814814814814814814814814814814814814816e-4 * t1209 * t1040 + 0.17315402222222222222222222222222222222222222222223e-1 * t1040 * t1213 - 0.33938188355555555555555555555555555555555555555556e-3 * t1216 * t1040 - 0.34133327407407407407407407407407407407407407407408e-2 * t1219 * t1040 + 0.17668777777777777777777777777777777777777777777778e0 * t1021 * t465 + 0.22625458903703703703703703703703703703703703703704e-2 * t1036 * t1224 - 0.36954916209382716049382716049382716049382716049385e-4 * t1229 * t1036 + 0.91022206419753086419753086419753086419753086419753e-2 * t1036 * t1232 - 0.53521057374814814814814814814814814814814814814816e-3 * t1235 * t1036 + 0.69934181636424691358024691358024691358024691358028e-5 * t1240 * t1036 - 0.19239335802469135802469135802469135802469135802470e-1 * t1036 * t469 + 0.34829925925925925925925925925925925925925925925926e-1 * t1025 * t560 * t538 - 0.20897955555555555555555555555555555555555555555556e-1 * t475 * t1022 + 0.40959992888888888888888888888888888888888888888889e-3 * t481 * t1022 - 0.34630804444444444444444444444444444444444444444445e-2 * t470 * t1022
  t1267 = (0.6160e4 / 0.81e2 * t431 * t1015 - 0.2618e4 / 0.81e2 * t434 / t23 / t531 / t7 - 0.1540e4 / 0.81e2 * t440 * t1015) * t444
  t1270 = t542 * t1035
  t1274 = t538 ** 2
  t1275 = t1274 * t543
  t1278 = t1275 * t546
  t1287 = t1267 * t449
  t1301 = t478 * t1166
  t1302 = t1270 * t538
  t1305 = 0.85404444444444444444444444444444444444444444444445e0 * t1267 * t1110 - 0.72878459259259259259259259259259259259259259259259e2 * t1270 * t1114 * t538 + 0.42775703703703703703703703703703703703703703703702e1 * t1275 * t1157 + 0.11213394071703703703703703703703703703703703703703e3 * t1167 * t1278 + 0.10931768888888888888888888888888888888888888888889e2 * t1275 * t1147 - 0.27985328355555555555555555555555555555555555555554e2 * t1152 * t1278 - 0.54752900740740740740740740740740740740740740740740e2 * t1160 * t1278 - 0.21863537777777777777777777777777777777777777777777e1 * t1115 * t1287 + 0.57034271604938271604938271604938271604938271604936e1 * t1025 * t1157 * t1020 + 0.87604641185185185185185185185185185185185185185184e3 * t1270 * t1122 * t538 * t459 - 0.25665422222222222222222222222222222222222222222222e1 * t1118 * t1287 + 0.65703480888888888888888888888888888888888888888888e1 * t1123 * t1287 - 0.67280364430222222222222222222222222222222222222218e4 * t1301 * t1302
  t1306 = t1121 ** 2
  t1307 = 0.1e1 / t1306
  t1308 = t1070 * t1307
  t1311 = t538 * t1035
  t1312 = t1151 * t460
  t1317 = 0.1e1 / t1095 / t1165
  t1318 = t568 * t1317
  t1321 = t542 ** 2
  t1322 = t1321 * t1035
  t1329 = t478 * t444 * t449
  t1337 = t1035 * t444 * t449
  t1340 = t459 * t1114
  t1342 = t543 * t546
  t1343 = t1342 * t443
  t1357 = t459 * t444 * t449
  t1362 = t460 * t444 * t449
  t1369 = t568 * t460
  t1376 = 0.11482515529424592592592592592592592592592592592592e5 * t1308 * t1302 + 0.11194131342222222222222222222222222222222222222222e4 * t1311 * t1312 * t542 - 0.23880813530074074074074074074074074074074074074072e4 * t1318 * t1302 - 0.81115408504801097393689986282578875171467764060356e2 * t1322 * t1122 * t444 * t449 + 0.22111864379698216735253772290809327846364883401918e4 * t1322 * t1317 * t1329 - 0.39624460968419204389574759945130315500685871056237e4 * t1070 / t1095 / t1306 * t1321 * t1337 + 0.14575691851851851851851851851851851851851851851852e2 * t1340 * t1020 * t1343 - 0.37313771140740740740740740740740740740740740740739e2 * t1152 * t1020 * t1343 - 0.73003867654320987654320987654320987654320987654320e2 * t1160 * t1020 * t1343 + 0.14951192095604938271604938271604938271604938271604e3 * t1167 * t1020 * t1343 - 0.25912341069958847736625514403292181069958847736624e3 * t1322 * t1151 * t1357 + 0.26995207950397805212620027434842249657064471879285e4 * t1322 * t1166 * t1362 - 0.14884742352957805212620027434842249657064471879286e5 * t568 * t1307 * t1321 * t1337 + 0.21774251670612560768175582990397805212620027434841e5 * t1369 / t1306 / t1094 * t1321 * t1337
  t1395 = 0.28493333333333333333333333333333333333333333333334e0 * t88 * t734
  t1397 = 0.14246666666666666666666666666666666666666666666666e0 * t88 * t851
  t1399 = 0.22161481481481481481481481481481481481481481481481e0 * t624 * t236
  t1404 = 0.68733717152873822006368402431571837509247048985239e1 * t49 * t210 * t906 * t714 * t282
  t1409 = 0.42740000000000000000000000000000000000000000000000e0 * t49 * t210 * t279 * t714 * t234
  t1414 = 0.36845452142031360632963667101718523854302450326054e2 * t49 * t210 * t924 * t714 * t927
  t1416 = 0.22911239050957940668789467477190612503082349661746e1 * t88 * t856
  t1421 = 0.71233333333333333333333333333333333333333333333332e-1 * t49 * t210 * t212 * t919 * t234
  t1432 = -0.21309037037037037037037037037037037037037037037036e0 * t624 * t316 - 0.67471169937307261780146784775653594739388761451767e-1 * t624 * t370 - 0.27397333333333333333333333333333333333333333333333e0 * t88 * t836 - 0.41096000000000000000000000000000000000000000000000e0 * t49 * t210 * t340 * t767 * t314 + 0.43374323531126096858665790212920168046749918076136e-1 * t88 * t839 + t1395 - t1397 + t1399 - t1404 + t1409 + t1414 - t1416 + t1421 + 0.12842518958703765280590332863421616642017504019700e1 * t88 * t842 - 0.86748647062252193717331580425840336093499836152272e-1 * t88 * t830 - 0.13012297059337829057599737063876050414024975422841e0 * t49 * t210 * t751 - 0.38024868119570572868450088421334803819557955882337e2 * t49 * t210 * t943
  t1458 = t2 * t1186
  t1465 = 0.1e1 / t8 / t1013
  t1466 = t197 ** 2
  t1467 = t1465 * t1466
  t1470 = t4 * t6 * t117
  t1471 = 0.1e1 / t189 / t1458 / t775 * t2 * t1467 * t1470 / 0.96e2
  t1473 = 0.1e1 / t1013
  t1474 = t1473 * t775
  t1475 = t774 * t1474
  t1477 = t5 * t533
  t1478 = t1477 * t253
  t1479 = t252 * t1478
  t1482 = 0.1e1 / t8 / t531
  t1483 = t6 * t1482
  t1484 = t1483 * t210
  t1485 = t215 * t1484
  t1487 = t1482 * t117
  t1489 = t36 * t1487 * t185
  t1491 = t188 ** (-0.25e1)
  t1494 = t1491 * t2 * t1467 * t1470
  t1496 = t789 * t1474
  t1498 = t265 * t1478
  t1500 = t225 * t1484
  t1504 = t194 * t533 * t195 * t197
  t1510 = t324 ** 2
  t1517 = t378 ** 2
  t1531 = -0.57538888888888888888888888888888888888888888888889e1 * t1471 + 0.55237333333333333333333333333333333333333333333334e2 * t1475 - 0.10229135802469135802469135802469135802469135802469e2 * t1479 + 0.89504938271604938271604938271604938271604938271607e1 * t1485 + 0.31310740740740740740740740740740740740740740740741e1 * t1489 + 0.73355000000000000000000000000000000000000000000000e-1 * t1494 - 0.11736800000000000000000000000000000000000000000000e1 * t1496 + 0.65204444444444444444444444444444444444444444444445e0 * t1498 + 0.57053888888888888888888888888888888888888888888890e0 * t1500 + 0.13490888888888888888888888888888888888888888888889e1 * t1504
  t1536 = t4 * t48 * t117
  t1540 = 0.42740000000000000000000000000000000000000000000000e0 * t1536 * t185 * t242 * t718
  t1544 = 0.34366858576436911003184201215785918754623524492620e1 * t1536 * t185 * t279 * t722
  t1552 = 0.1e1 / t393 / t375
  t1557 = t393 ** 2
  t1558 = 0.1e1 / t1557
  t1560 = t396 ** 2
  t1561 = 0.1e1 / t1560
  t1565 = -0.21687161765563048429332895106460084023374959038068e-1 * t49 * t210 * t939 + 0.13218398198777742039240913477002251527822450948858e2 * t49 * t210 * t765 * t767 * t343 + 0.38527556876111295841770998590264849926052512059102e1 * t49 * t210 * t935 + 0.13698666666666666666666666666666666666666666666666e0 * t88 * t863 - 0.14172186339420759128595382735072640214240860886520e3 * t49 * t210 * t898 * t767 * t901 + 0.44061327329259140130803044923340838426074836496192e1 * t88 * t868 - 0.68493333333333333333333333333333333333333333333332e-1 * t49 * t210 * t307 * t800 * t314 + 0.99999999999999999999999999999999999999999999999999e0 * t328 * (-0.78438333333333333333333333333333333333333333333333e1 * t1471 + 0.75300800000000000000000000000000000000000000000001e2 * t1475 - 0.13944592592592592592592592592592592592592592592593e2 * t1479 + 0.12201518518518518518518518518518518518518518518519e2 * t1485 + 0.53560370370370370370370370370370370370370370370370e1 * t1489 + 0.28051666666666666666666666666666666666666666666666e0 * t1494 - 0.44882666666666666666666666666666666666666666666666e1 * t1496 + 0.24934814814814814814814814814814814814814814814815e1 * t1498 + 0.21817962962962962962962962962962962962962962962963e1 * t1500 + 0.16979925925925925925925925925925925925925925925926e1 * t1504) * t314 + 0.11579285944033451270504985525892569958185911868768e4 * t899 * t1510 * t343 - 0.24000000000000000000000000000000000000000000000000e2 * t766 * t1510 * t314 - 0.14035736153892489769995222001484279098274130793177e2 * t881 * t1517 * t368 + 0.58482233974552040708313425006184496242808878304903e0 * t382 * t1531 * t368 - t1540 + t1544 - 0.24829604254387158294210325990977956380799639474146e5 * t320 / t339 / t321 * t1510 * t901 - 0.12304676425209353916981601646454408427003023925970e5 * t374 * t1552 * t1517 * t875 + 0.91080982599109921218848830805163797795664001346962e5 * t374 * t1558 * t1517 * t1561
  t1567 = t335 ** 2
  t1574 = t389 ** 2
  t1586 = 0.11483710345679012345679012345679012345679012345679e-1 * t36 * t1487 * t206
  t1587 = t339 ** 2
  t1590 = t342 ** 2
  t1604 = t244 ** 2
  t1607 = 0.62070017646847402095774076540096717770467394091622e4 * t240 / t278 / t241 * t1604 * t927
  t1621 = 0.10000000000000000000000000000000000000000000000000e1 * t248 * (-0.42198333333333333333333333333333333333333333333333e1 * t1471 + 0.40510400000000000000000000000000000000000000000000e2 * t1475 - 0.75019259259259259259259259259259259259259259259258e1 * t1479 + 0.65641851851851851851851851851851851851851851851850e1 * t1485 + 0.31003950617283950617283950617283950617283950617285e1 * t1489 + 0.13651666666666666666666666666666666666666666666666e0 * t1494 - 0.21842666666666666666666666666666666666666666666666e1 * t1496 + 0.12134814814814814814814814814814814814814814814815e1 * t1498 + 0.10617962962962962962962962962962962962962962962963e1 * t1500 + 0.13388493827160493827160493827160493827160493827161e1 * t1504) * t234
  t1622 = t278 ** 2
  t1625 = t281 ** 2
  t1629 = 0.24954977986735470914321699422701391789612506067521e5 * t240 / t1622 * t1604 / t1625
  t1632 = 0.57894567559743977356791354411244411566048052491077e3 * t925 * t1604 * t282
  t1635 = 0.24000000000000000000000000000000000000000000000000e2 * t907 * t1604 * t234
  t1636 = t274 ** 2
  t1639 = 0.60000000000000000000000000000000000000000000000000e1 * t243 * t1636 * t234
  t1642 = 0.48245472966453314463992795342703676305040043742564e2 * t280 * t1636 * t282
  t1647 = -0.60000000000000000000000000000000000000000000000000e1 * t323 * t1567 * t314 + 0.96494049533612093920874879382438082984882598906400e2 * t341 * t1567 * t343 - 0.35089340384731224424988055003710697745685326982943e1 * t377 * t1574 * t368 - 0.18989760778855128828022312575107704239400966910600e-2 * t36 * t1487 * t356 - 0.55208163456790123456790123456790123456790123456787e-2 * t36 * t1487 * t302 + t1586 + 0.19965908856856833623520686708731068173688999255505e6 * t320 / t1587 * t1510 / t1590 + 0.51947267698127589899017076750918898776700016259463e2 * t395 * t1574 * t397 + 0.62336721237753107878820492101102678532040019511358e3 * t873 * t1517 * t397 + t1607 - t1621 - t1629 - t1632 + t1635 + t1639 - t1642 - 0.66091990993888710196204567385011257639112254744288e1 * t1536 * t185 * t340 * t814
  t1663 = t378 * t875
  t1696 = 0.36000000000000000000000000000000000000000000000000e2 * t280 * t245 * t274
  t1699 = 0.80000000000000000000000000000000000000000000000000e1 * t243 * t501 * t919
  t1702 = 0.57894567559743977356791354411244411566048052491077e3 * t907 * t283 * t274
  t1706 = 0.64327297288604419285323727123604901740053391656752e2 * t280 * t919 * t282 * t232
  t1710 = 0.31035008823423701047887038270048358885233697045812e4 * t925 * t274 * t927 * t244
  t1711 = 0.41096000000000000000000000000000000000000000000000e0 * t1536 * t185 * t322 * t810 - 0.19263778438055647920885499295132424963026256029551e1 * t1536 * t185 * t394 * t821 + 0.13012297059337829057599737063876050414024975422841e0 * t1536 * t185 * t376 * t817 + 0.21053604230838734654992833002226418647411196189766e2 * t395 * t379 * t389 + 0.61523382126046769584908008232272042135015119629847e4 * t873 * t1663 * t389 - 0.80000000000000000000000000000000000000000000000000e1 * t323 * t507 * t800 - 0.11579285944033451270504985525892569958185911868768e4 * t766 * t344 * t335 + 0.12865873271148279189449983917658411064651013187520e3 * t341 * t800 * t343 * t312 + 0.12414802127193579147105162995488978190399819737073e5 * t899 * t335 * t901 * t324 - 0.46785787179641632566650740004947596994247102643924e1 * t377 * t513 * t893 - 0.62336721237753107878820492101102678532040019511357e3 * t881 * t398 * t389 + 0.69263023597503453198689435667891865035600021679284e2 * t395 * t893 * t397 * t366 + 0.36000000000000000000000000000000000000000000000000e2 * t341 * t325 * t335 - t1696 + t1699 + t1702 - t1706 - t1710
  t1718 = t292 * (t1432 + t1565 + t1647 + t1711) + 0.18989760778855128828022312575107704239400966910600e-2 * t403 * t1483 * t404 - t1395 + t1397 - t1399 + t1404 - t1409 - t1414 + t1416 - t1421 + t1540
  t1755 = -t1544 - 0.58482233974552040708313425006184496242808878304903e0 * t412 * t361 * t1531 * t368 - 0.91080982599109921218848830805163797795664001346962e5 * t412 * t1558 * t1517 * t1561 + 0.12304676425209353916981601646454408427003023925970e5 * t412 * t1552 * t1517 * t875 + 0.67471169937307261780146784775653594739388761451767e-1 * t408 * t785 * t369 - 0.38527556876111295841770998590264849926052512059102e1 * t408 * t220 * t935 + 0.21687161765563048429332895106460084023374959038068e-1 * t408 * t220 * t939 + 0.38024868119570572868450088421334803819557955882337e2 * t408 * t220 * t943 - 0.43374323531126096858665790212920168046749918076136e-1 * t408 * t260 * t418 - 0.12842518958703765280590332863421616642017504019700e1 * t408 * t260 * t422 + 0.86748647062252193717331580425840336093499836152272e-1 * t408 * t260 * t414 + 0.13012297059337829057599737063876050414024975422841e0 * t408 * t220 * t751
  t1762 = t292 * t1 * t45
  t1801 = -0.62336721237753107878820492101102678532040019511358e3 * t412 * t872 * t1517 * t397 + 0.19263778438055647920885499295132424963026256029551e1 * t1762 * t210 * t394 * t821 - 0.13012297059337829057599737063876050414024975422841e0 * t1762 * t210 * t376 * t817 + 0.35089340384731224424988055003710697745685326982943e1 * t412 * t376 * t1574 * t368 + 0.14035736153892489769995222001484279098274130793177e2 * t412 * t880 * t1517 * t368 - 0.51947267698127589899017076750918898776700016259463e2 * t412 * t394 * t1574 * t397 - 0.61523382126046769584908008232272042135015119629847e4 * t412 * t872 * t389 * t1663 + 0.62336721237753107878820492101102678532040019511357e3 * t412 * t880 * t389 * t398 + 0.46785787179641632566650740004947596994247102643924e1 * t412 * t745 * t894 - 0.21053604230838734654992833002226418647411196189766e2 * t412 * t421 * t390 - 0.69263023597503453198689435667891865035600021679284e2 * t412 * t394 * t893 * t738 - t1586
  t1802 = -t1607 + t1621 + t1629 + t1632 - t1635 - t1639 + t1642 + t1696 - t1699 - t1702 + t1706 + t1710
  t1807 = f.my_piecewise3(t181, 0, t182 * (t1718 + t1755 + t1801 + t1802) / 0.2e1)
  t1849 = -0.21863537777777777777777777777777777777777777777777e1 * t1115 * t1022 + 0.42775703703703703703703703703703703703703703703702e1 * t1025 * t1157 * t538 - 0.25665422222222222222222222222222222222222222222222e1 * t1118 * t1022 + 0.65703480888888888888888888888888888888888888888888e1 * t1123 * t1022 - 0.12146409876543209876543209876543209876543209876543e2 * t1036 * t1114 - 0.54752900740740740740740740740740740740740740740740e2 * t1160 * t443 * t1040 + 0.11213394071703703703703703703703703703703703703703e3 * t1167 * t443 * t1040 + 0.10931768888888888888888888888888888888888888888889e2 * t1040 * t1340 * t443 - 0.27985328355555555555555555555555555555555555555554e2 * t1152 * t443 * t1040 + 0.14600773530864197530864197530864197530864197530864e3 * t1036 * t1122 * t459 - 0.11213394071703703703703703703703703703703703703703e4 * t1301 * t1036 + 0.19137525882374320987654320987654320987654320987653e4 * t1308 * t1036 + 0.85404444444444444444444444444444444444444444444445e0 * t1021 * t1110 + 0.18656885570370370370370370370370370370370370370369e3 * t1036 * t1312 - 0.39801355883456790123456790123456790123456790123453e3 * t1318 * t1036
  t1900 = 0.94556451730824759945130315500685871056241426611783e-7 * t1070 / t967 / t1071 * t1321 * t1337 + 0.44860104334705075445816186556927297668038408779147e-4 * t1322 * t999 * t1362 - 0.11691233345075445816186556927297668038408779149519e-5 * t568 * t1072 * t1321 * t1337 + 0.80836527700235939643347050754458161865569272976668e-8 * t1369 / t1071 / t966 * t1321 * t1337 - 0.32939785185185185185185185185185185185185185185184e-2 * t1041 * t1020 * t1343 + 0.39857140074074074074074074074074074074074074074072e-4 * t981 * t1020 * t1343 - 0.25666938271604938271604938271604938271604938271604e-3 * t992 * t1020 * t1343 + 0.24845596246913580246913580246913580246913580246912e-5 * t1000 * t1020 * t1343 + 0.27678569495884773662551440329218106995884773662550e-3 * t1322 * t980 * t1357 - 0.11163689696673525377229080932784636488340192043895e-4 * t1322 * t1060 * t1329 + 0.31818518518518518518518518518518518518518518518518e-2 * t1275 * t988 + 0.16469892592592592592592592592592592592592592592592e-1 * t1270 * t973 * t538 - 0.40834444444444444444444444444444444444444444444444e-1 * t1267 * t969
  t1935 = -0.19091111111111111111111111111111111111111111111111e-2 * t995 * t1287 - 0.24704838888888888888888888888888888888888888888888e-2 * t1275 * t975 + 0.29892855055555555555555555555555555555555555555554e-4 * t981 * t1278 - 0.19250203703703703703703703703703703703703703703703e-3 * t992 * t1278 + 0.18634197185185185185185185185185185185185185185184e-5 * t1000 * t1278 + 0.42424691358024691358024691358024691358024691358024e-2 * t1025 * t988 * t1020 + 0.30800325925925925925925925925925925925925925925925e-2 * t1270 * t991 * t538 * t459 + 0.49409677777777777777777777777777777777777777777776e-3 * t984 * t1287 - 0.28518820301783264746227709190672153635116598079561e-3 * t1322 * t991 * t444 * t449 + 0.23100244444444444444444444444444444444444444444444e-4 * t1003 * t1287 - 0.11957142022222222222222222222222222222222222222222e-2 * t1311 * t1056 * t542 + 0.12056784872407407407407407407407407407407407407406e-4 * t1061 * t1302 - 0.11180518311111111111111111111111111111111111111110e-3 * t1067 * t1302 + 0.90189514376296296296296296296296296296296296296286e-6 * t1073 * t1302
  t1947 = t1143 * t1102
  t1956 = 0.2e1 * t1143 * (t1305 + t1376) * t1190 + 0.2e1 * t1807 * t1102 * t1190 - 0.6e1 * t1127 * t1196 + 0.8e1 * t526 * t1849 * t1190 + 0.8e1 * t950 * t1126 * t1190 - 0.3e1 / 0.4e1 * t963 * t1010 * (t1900 + t1935) - 0.3e1 * t1173 * t1196 - 0.10e2 / 0.9e1 * t963 * t1176 * t1089 + t963 * t1080 * t1006 - 0.6e1 * t1947 * s0 * t1473 * t1106 - t963 * t964 * t1076 + 0.3e1 * t1185 * t1107
  t1957 = t1143 * t1849
  t1961 = t428 * t1126
  t1964 = t950 * t1102
  t1967 = s0 * t612 * t1106
  t2008 = -0.50567892455418381344307270233196159122085048010974e-2 * t1322 * t480 * t444 * t449 - 0.32112634424888888888888888888888888888888888888890e-2 * t1235 * t1302 + 0.41960508981854814814814814814814814814814814814816e-4 * t1240 * t1302 + 0.13575275342222222222222222222222222222222222222222e-1 * t1311 * t1224 * t542 - 0.22172949725629629629629629629629629629629629629631e-3 * t1229 * t1302 + 0.54613323851851851851851851851851851851851851851853e-1 * t1232 * t1302 + 0.53521057374814814814814814814814814814814814814816e-4 * t571 * t1278 + 0.17315402222222222222222222222222222222222222222223e-1 * t1275 * t548 - 0.33938188355555555555555555555555555555555555555556e-3 * t553 * t1278 - 0.34133327407407407407407407407407407407407407407408e-2 * t563 * t1278 + 0.46439901234567901234567901234567901234567901234568e-1 * t1025 * t560 * t1020 - 0.20897955555555555555555555555555555555555555555556e-1 * t475 * t1287 + 0.40959992888888888888888888888888888888888888888889e-3 * t481 * t1287
  t2036 = t1342 * t1020
  t2052 = -0.34630804444444444444444444444444444444444444444445e-2 * t470 * t1287 + 0.20530509005212620027434842249657064471879286694102e-3 * t1322 * t1228 * t1329 - 0.31424248477366255144032921810699588477366255144034e-2 * t1322 * t552 * t1357 - 0.28167858355151714677640603566529492455418381344309e-5 * t1070 / t463 / t1238 * t1321 * t1337 + 0.12884698997640603566529492455418381344307270233196e-2 * t1322 * t570 * t1362 - 0.54393252383885871056241426611796982167352537722910e-4 * t568 * t1239 * t1321 * t1337 + 0.60920442669952175582990397805212620027434842249661e-6 * t1369 / t1238 / t462 * t1321 * t1337 + 0.71361409833086419753086419753086419753086419753088e-4 * t1209 * t2036 + 0.23087202962962962962962962962962962962962962962964e-1 * t2036 * t1213 - 0.45250917807407407407407407407407407407407407407408e-3 * t1216 * t2036 - 0.45511103209876543209876543209876543209876543209878e-2 * t1219 * t2036 - 0.11543601481481481481481481481481481481481481481482e0 * t1311 * t469 * t542 + 0.17668777777777777777777777777777777777777777777778e0 * t1267 * t465 + 0.34829925925925925925925925925925925925925925925926e-1 * t1275 * t560
  t2096 = -0.43374323531126096858665790212920168046749918076136e-1 * t136 * t11 * t168 - 0.38527556876111295841770998590264849926052512059102e1 * t136 * t48 * t605 + 0.38024868119570572868450088421334803819557955882337e2 * t136 * t48 * t599 + 0.21687161765563048429332895106460084023374959038068e-1 * t136 * t48 * t639 + 0.67471169937307261780146784775653594739388761451767e-1 * t136 * t623 * t146 - 0.12842518958703765280590332863421616642017504019700e1 * t136 * t11 * t176 + 0.86748647062252193717331580425840336093499836152272e-1 * t136 * t11 * t157 + 0.13012297059337829057599737063876050414024975422841e0 * t136 * t48 * t683 - 0.34366858576436911003184201215785918754623524492620e1 * t49 * t104 * t99 * t107 * t60 + 0.42740000000000000000000000000000000000000000000000e0 * t49 * t69 * t60 * t100 - 0.21053604230838734654992833002226418647411196189766e2 * t152 * t173 * t687
  t2103 = t175 * t166
  t2108 = t145 * t143
  t2141 = -0.61523382126046769584908008232272042135015119629847e4 * t152 * t594 * t155 * t598 * t166 + 0.62336721237753107878820492101102678532040019511357e3 * t152 * t603 * t155 * t2103 + 0.46785787179641632566650740004947596994247102643924e1 * t152 * t154 * t637 * t2108 - 0.42740000000000000000000000000000000000000000000000e0 * t36 * t698 * t587 + 0.18989760778855128828022312575107704239400966910600e-2 * t122 * t44 * t1482 * t131 - 0.28493333333333333333333333333333333333333333333334e0 * t36 * t10 * t69 * t72 + 0.64327297288604419285323727123604901740053391656752e2 * t105 * t664 * t107 * t60 - 0.80000000000000000000000000000000000000000000000000e1 * t70 * t62 * t664 - 0.2e1 * t1807 + 0.36000000000000000000000000000000000000000000000000e2 * t105 * t72 * t99 + 0.31035008823423701047887038270048358885233697045812e4 * t644 * t99 * t646 * t71 - 0.57894567559743977356791354411244411566048052491077e3 * t652 * t579 * t71
  t2169 = t121 * t36
  t2180 = t171 ** 2
  t2182 = t155 ** 2
  t2184 = t174 ** 2
  t2189 = t166 ** 2
  t2198 = -0.22161481481481481481481481481481481481481481481481e0 * t36 * t619 * t40 * t62 + 0.14246666666666666666666666666666666666666666666666e0 * t36 * t691 * t100 + 0.22911239050957940668789467477190612503082349661746e1 * t36 * t10 * t104 * t108 - 0.71233333333333333333333333333333333333333333333332e-1 * t36 * t41 * t665 - 0.69263023597503453198689435667891865035600021679284e2 * t152 * t172 * t637 * t678 - 0.36845452142031360632963667101718523854302450326054e2 * t36 * t38 * t643 * t647 + 0.68733717152873822006368402431571837509247048985239e1 * t36 * t38 * t651 * t653 + 0.19263778438055647920885499295132424963026256029551e1 * t2169 * t38 * t172 * t2103 * t143 - 0.13012297059337829057599737063876050414024975422841e0 * t2169 * t38 * t154 * t2108 * t166 - 0.91080982599109921218848830805163797795664001346962e5 * t152 / t2180 * t2182 / t2184 - 0.51947267698127589899017076750918898776700016259463e2 * t152 * t172 * t2189 * t175 + 0.14035736153892489769995222001484279098274130793177e2 * t152 * t603 * t2182 * t145
  t2218 = 0.1e1 / t15 / t1458 * t2 * t1465 * t36 / 0.48e2
  t2220 = t611 * t1473
  t2222 = t79 * t533
  t2223 = t78 * t2222
  t2225 = t44 * t1482
  t2226 = t43 * t2225
  t2228 = t4 * t1483
  t2230 = t14 ** (-0.25e1)
  t2233 = t2230 * t2 * t1465 * t36
  t2235 = t627 * t1473
  t2237 = t91 * t2222
  t2239 = t52 * t2225
  t2241 = t22 * t1477
  t2262 = t99 ** 2
  t2269 = t71 ** 2
  t2285 = t103 ** 2
  t2288 = t106 ** 2
  t2293 = 0.12304676425209353916981601646454408427003023925970e5 * t152 / t171 / t153 * t2182 * t598 - 0.62336721237753107878820492101102678532040019511358e3 * t152 * t594 * t2182 * t175 + 0.35089340384731224424988055003710697745685326982943e1 * t152 * t154 * t2189 * t145 - 0.58482233974552040708313425006184496242808878304903e0 * t152 * t138 * (-0.28769444444444444444444444444444444444444444444444e1 * t2218 + 0.27618666666666666666666666666666666666666666666667e2 * t2220 - 0.10229135802469135802469135802469135802469135802469e2 * t2223 + 0.89504938271604938271604938271604938271604938271607e1 * t2226 + 0.31310740740740740740740740740740740740740740740741e1 * t2228 + 0.36677500000000000000000000000000000000000000000000e-1 * t2233 - 0.58684000000000000000000000000000000000000000000000e0 * t2235 + 0.65204444444444444444444444444444444444444444444445e0 * t2237 + 0.57053888888888888888888888888888888888888888888890e0 * t2239 + 0.13490888888888888888888888888888888888888888888889e1 * t2241) * t145 + 0.10000000000000000000000000000000000000000000000000e1 * t75 * (-0.21099166666666666666666666666666666666666666666667e1 * t2218 + 0.20255200000000000000000000000000000000000000000000e2 * t2220 - 0.75019259259259259259259259259259259259259259259258e1 * t2223 + 0.65641851851851851851851851851851851851851851851850e1 * t2226 + 0.31003950617283950617283950617283950617283950617285e1 * t2228 + 0.68258333333333333333333333333333333333333333333335e-1 * t2233 - 0.10921333333333333333333333333333333333333333333333e1 * t2235 + 0.12134814814814814814814814814814814814814814814815e1 * t2237 + 0.10617962962962962962962962962962962962962962962963e1 * t2239 + 0.13388493827160493827160493827160493827160493827161e1 * t2241) * t61 - 0.60000000000000000000000000000000000000000000000000e1 * t70 * t2262 * t61 + 0.48245472966453314463992795342703676305040043742564e2 * t105 * t2262 * t107 + 0.57894567559743977356791354411244411566048052491077e3 * t644 * t2269 * t107 - 0.62070017646847402095774076540096717770467394091622e4 * t67 / t103 / t68 * t2269 * t646 - 0.11483710345679012345679012345679012345679012345679e-1 * t4 * t1483 * t32 - 0.24000000000000000000000000000000000000000000000000e2 * t652 * t2269 * t61 + 0.24954977986735470914321699422701391789612506067521e5 * t67 / t2285 * t2269 / t2288
  t2299 = t1957 * t1107 - 0.3e1 * t1103 * t1196 + 0.3e1 * t1961 * t1107 + t1964 * t1107 + 0.6e1 * t1199 * t1967 + 0.20e2 / 0.27e2 * t963 * t114 * t437 * t1181 + 0.6e1 * t1193 * t1967 + 0.4e1 * t528 * t1254 + t1208 * (t2008 + t2052) + 0.12e2 * t428 * t1172 * t1190 + 0.4e1 * t953 * t484 + (t2096 + t2141 + t2198 + t2293) * t958 + 0.6e1 * t430 * t576
  v4rho4_0_ = 0.12e2 * t430 * t484 + 0.12e2 * t528 * t576 + 0.4e1 * t953 * t958 - 0.3e1 * t963 * t964 * t1006 - 0.3e1 * t963 * t1010 * t1076 + 0.2e1 * t963 * t1080 * t1089 + 0.3e1 * t1103 * t1107 + 0.6e1 * t1127 * t1107 + 0.3e1 * t1173 * t1107 - 0.10e2 / 0.9e1 * t963 * t1176 * t1181 + 0.24e2 * t1185 * t1190 - 0.6e1 * t1193 * t1196 - 0.6e1 * t1199 * t1196 + 0.4e1 * t1208 * t1254 + r0 * (t1956 + t2299) + 0.8e1 * t1964 * t1190 + 0.24e2 * t1961 * t1190 + 0.6e1 * t1947 * t1967 + 0.8e1 * t1957 * t1190

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = jnp.pi ** (0.1e1 / 0.3e1)
  t4 = t1 / t2
  t5 = r0 + r1
  t6 = 0.1e1 / t5
  t7 = r0 * t6
  t9 = 0.2e1 * t7 <= f.p.zeta_threshold
  t10 = 2 ** (0.1e1 / 0.3e1)
  t11 = t10 * t6
  t12 = t7 ** (0.1e1 / 0.3e1)
  t15 = t10 * r0
  t16 = t5 ** 2
  t17 = 0.1e1 / t16
  t20 = 0.2e1 * t15 * t17 * t12
  t21 = t12 ** 2
  t22 = 0.1e1 / t21
  t23 = t6 * t22
  t25 = -r0 * t17 + t6
  t30 = f.my_piecewise3(t9, 0, 0.2e1 * t11 * t12 - t20 + 0.2e1 / 0.3e1 * t15 * t23 * t25)
  t31 = t5 ** (0.1e1 / 0.3e1)
  t32 = t30 * t31
  t33 = r0 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t36 = 0.1e1 / t34 / r0
  t38 = r0 ** 2
  t40 = 0.1e1 / t34 / t38
  t46 = 6 ** (0.1e1 / 0.3e1)
  t48 = jnp.pi ** 2
  t49 = t48 ** (0.1e1 / 0.3e1)
  t50 = t49 ** 2
  t51 = 0.1e1 / t50
  t52 = (tau0 * t36 - s0 * t40 / 0.8e1 - l0 * t36 / 0.4e1) * t46 * t51
  t54 = 0.1e1 - 0.5e1 / 0.9e1 * t52
  t55 = t54 ** 2
  t57 = 0.1e1 + 0.121e-1 * t55
  t58 = jnp.sqrt(t57)
  t59 = 0.1e1 / t58
  t62 = 0.1e1 / t57
  t65 = 0.8085e0 + 0.73502e-1 * t54 * t59 + 0.171820e-2 * t55 * t62
  t67 = t4 * t32 * t65
  t69 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t70 = t69 * f.p.zeta_threshold
  t74 = f.my_piecewise3(t9, t70, 0.2e1 * t15 * t6 * t12)
  t75 = t31 ** 2
  t76 = 0.1e1 / t75
  t77 = t74 * t76
  t80 = t4 * t77 * t65 / 0.4e1
  t81 = t74 * t31
  t84 = t38 * r0
  t86 = 0.1e1 / t34 / t84
  t91 = -0.5e1 / 0.3e1 * tau0 * t40 + s0 * t86 / 0.3e1 + 0.5e1 / 0.12e2 * l0 * t40
  t92 = t91 * t46
  t93 = t51 * t59
  t97 = 0.1e1 / t58 / t57
  t98 = t55 * t97
  t99 = t92 * t51
  t102 = t54 * t62
  t105 = t55 * t54
  t106 = t57 ** 2
  t107 = 0.1e1 / t106
  t108 = t105 * t107
  t111 = -0.40834444444444444444444444444444444444444444444444e-1 * t92 * t93 + 0.49409677777777777777777777777777777777777777777776e-3 * t98 * t99 - 0.19091111111111111111111111111111111111111111111111e-2 * t102 * t99 + 0.23100244444444444444444444444444444444444444444444e-4 * t108 * t99
  t113 = t4 * t81 * t111
  t115 = r1 * t6
  t117 = 0.2e1 * t115 <= f.p.zeta_threshold
  t118 = t10 * r1
  t119 = t115 ** (0.1e1 / 0.3e1)
  t122 = 0.2e1 * t118 * t17 * t119
  t123 = r1 ** 2
  t124 = t10 * t123
  t126 = 0.1e1 / t16 / t5
  t127 = t119 ** 2
  t128 = 0.1e1 / t127
  t133 = f.my_piecewise3(t117, 0, -t122 - 0.2e1 / 0.3e1 * t124 * t126 * t128)
  t134 = t133 * t31
  t135 = r1 ** (0.1e1 / 0.3e1)
  t136 = t135 ** 2
  t138 = 0.1e1 / t136 / r1
  t141 = 0.1e1 / t136 / t123
  t148 = (tau1 * t138 - s2 * t141 / 0.8e1 - l1 * t138 / 0.4e1) * t46 * t51
  t150 = 0.1e1 - 0.5e1 / 0.9e1 * t148
  t151 = t150 ** 2
  t153 = 0.1e1 + 0.121e-1 * t151
  t154 = jnp.sqrt(t153)
  t155 = 0.1e1 / t154
  t158 = 0.1e1 / t153
  t161 = 0.8085e0 + 0.73502e-1 * t150 * t155 + 0.171820e-2 * t151 * t158
  t163 = t4 * t134 * t161
  t168 = f.my_piecewise3(t117, t70, 0.2e1 * t118 * t6 * t119)
  t169 = t168 * t76
  t172 = t4 * t169 * t161 / 0.4e1
  t174 = r0 - r1
  t175 = t174 * t6
  t176 = 0.1e1 + t175
  t177 = t176 <= f.p.zeta_threshold
  t178 = r0 <= f.p.dens_threshold or t177
  t179 = t174 * t17
  t180 = t6 - t179
  t181 = f.my_piecewise3(t177, 0, t180)
  t183 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t184 = t1 * t183
  t185 = 4 ** (0.1e1 / 0.3e1)
  t186 = t185 ** 2
  t187 = t184 * t186
  t188 = 0.1e1 / t31
  t189 = t188 * t10
  t190 = 0.1e1 / t69
  t191 = t176 ** (0.1e1 / 0.3e1)
  t193 = f.my_piecewise3(t177, t190, 0.1e1 / t191)
  t195 = t187 * t189 * t193
  t197 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t195
  t198 = jnp.sqrt(t195)
  t201 = t195 ** 0.15e1
  t203 = t1 ** 2
  t204 = t183 ** 2
  t205 = t203 * t204
  t206 = t205 * t185
  t207 = t10 ** 2
  t208 = t76 * t207
  t209 = t193 ** 2
  t211 = t206 * t208 * t209
  t213 = 0.37978500000000000000000000000000000000000000000000e1 * t198 + 0.89690000000000000000000000000000000000000000000000e0 * t195 + 0.20477500000000000000000000000000000000000000000000e0 * t201 + 0.12323500000000000000000000000000000000000000000000e0 * t211
  t216 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t213
  t217 = jnp.log(t216)
  t219 = 0.62182e-1 * t197 * t217
  t222 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t70, 0.2e1 * t10)
  t224 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t70, 0)
  t228 = 0.1e1 / (0.2e1 * t10 - 0.2e1)
  t229 = (t222 + t224 - 0.2e1) * t228
  t231 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t195
  t236 = 0.70594500000000000000000000000000000000000000000000e1 * t198 + 0.15494250000000000000000000000000000000000000000000e1 * t195 + 0.42077500000000000000000000000000000000000000000000e0 * t201 + 0.15629250000000000000000000000000000000000000000000e0 * t211
  t239 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t236
  t240 = jnp.log(t239)
  t244 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t195
  t249 = 0.51785000000000000000000000000000000000000000000000e1 * t198 + 0.90577500000000000000000000000000000000000000000000e0 * t195 + 0.11003250000000000000000000000000000000000000000000e0 * t201 + 0.12417750000000000000000000000000000000000000000000e0 * t211
  t252 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t249
  t253 = jnp.log(t252)
  t254 = t244 * t253
  t260 = -t219 + t229 * (-0.31090e-1 * t231 * t240 + t219 - 0.19751789702565206228825776161588751761046270558698e-1 * t254) + 0.19751789702565206228825776161588751761046270558698e-1 * t229 * t254
  t262 = f.my_piecewise3(t177, f.p.zeta_threshold, t176)
  t264 = 0.1e1 / t31 / t5
  t265 = t264 * t10
  t267 = t187 * t265 * t193
  t268 = 0.17808333333333333333333333333333333333333333333333e-1 * t267
  t269 = t191 * t176
  t270 = 0.1e1 / t269
  t273 = f.my_piecewise3(t177, 0, -t270 * t180 / 0.3e1)
  t275 = t187 * t189 * t273
  t277 = -t268 + 0.53425000000000000000000000000000000000000000000000e-1 * t275
  t279 = 0.62182e-1 * t277 * t217
  t280 = t213 ** 2
  t281 = 0.1e1 / t280
  t282 = t197 * t281
  t283 = 0.1e1 / t198
  t284 = t267 / 0.3e1
  t285 = -t284 + t275
  t286 = t283 * t285
  t288 = 0.29896666666666666666666666666666666666666666666667e0 * t267
  t290 = t195 ** 0.5e0
  t291 = t290 * t285
  t294 = 0.1e1 / t75 / t5
  t295 = t294 * t207
  t297 = t206 * t295 * t209
  t298 = 0.82156666666666666666666666666666666666666666666667e-1 * t297
  t299 = t193 * t273
  t301 = t206 * t208 * t299
  t303 = 0.18989250000000000000000000000000000000000000000000e1 * t286 - t288 + 0.89690000000000000000000000000000000000000000000000e0 * t275 + 0.30716250000000000000000000000000000000000000000000e0 * t291 - t298 + 0.24647000000000000000000000000000000000000000000000e0 * t301
  t304 = 0.1e1 / t216
  t305 = t303 * t304
  t307 = 0.10000000000000000000000000000000000000000000000000e1 * t282 * t305
  t308 = 0.17123333333333333333333333333333333333333333333333e-1 * t267
  t310 = -t308 + 0.51370000000000000000000000000000000000000000000000e-1 * t275
  t313 = t236 ** 2
  t314 = 0.1e1 / t313
  t315 = t231 * t314
  t317 = 0.51647500000000000000000000000000000000000000000000e0 * t267
  t320 = 0.10419500000000000000000000000000000000000000000000e0 * t297
  t322 = 0.35297250000000000000000000000000000000000000000000e1 * t286 - t317 + 0.15494250000000000000000000000000000000000000000000e1 * t275 + 0.63116250000000000000000000000000000000000000000000e0 * t291 - t320 + 0.31258500000000000000000000000000000000000000000000e0 * t301
  t323 = 0.1e1 / t239
  t324 = t322 * t323
  t327 = 0.92708333333333333333333333333333333333333333333333e-2 * t267
  t329 = -t327 + 0.27812500000000000000000000000000000000000000000000e-1 * t275
  t330 = t329 * t253
  t332 = t249 ** 2
  t333 = 0.1e1 / t332
  t334 = t244 * t333
  t336 = 0.30192500000000000000000000000000000000000000000000e0 * t267
  t339 = 0.82785000000000000000000000000000000000000000000000e-1 * t297
  t341 = 0.25892500000000000000000000000000000000000000000000e1 * t286 - t336 + 0.90577500000000000000000000000000000000000000000000e0 * t275 + 0.16504875000000000000000000000000000000000000000000e0 * t291 - t339 + 0.24835500000000000000000000000000000000000000000000e0 * t301
  t342 = 0.1e1 / t252
  t343 = t341 * t342
  t350 = t229 * t244
  t352 = t333 * t341 * t342
  t355 = -t279 + t307 + t229 * (-0.31090e-1 * t310 * t240 + 0.99999999999999999999999999999999999999999999999999e0 * t315 * t324 + t279 - t307 - 0.19751789702565206228825776161588751761046270558698e-1 * t330 + 0.58482233974552040708313425006184496242808878304903e0 * t334 * t343) + 0.19751789702565206228825776161588751761046270558698e-1 * t229 * t330 - 0.58482233974552040708313425006184496242808878304903e0 * t350 * t352
  t359 = f.my_piecewise3(t178, 0, t181 * t260 / 0.2e1 + t262 * t355 / 0.2e1)
  t361 = 0.1e1 + 0.256e1 * t55
  t362 = jnp.sqrt(t361)
  t363 = 0.1e1 / t362
  t366 = 0.1e1 / t361
  t369 = 0.2606e0 - 0.153728e1 * t54 * t363 + 0.2309888e1 * t55 * t366
  t370 = t359 * t369
  t373 = 0.1e1 / tau0
  t376 = 0.1e1 - s0 / r0 * t373 / 0.8e1
  t377 = t370 * t376
  t381 = f.my_piecewise3(t178, 0, t262 * t260 / 0.2e1)
  t382 = t51 * t363
  t386 = 0.1e1 / t362 / t361
  t387 = t55 * t386
  t390 = t54 * t366
  t393 = t361 ** 2
  t394 = 0.1e1 / t393
  t395 = t105 * t394
  t398 = 0.85404444444444444444444444444444444444444444444445e0 * t92 * t382 - 0.21863537777777777777777777777777777777777777777777e1 * t387 * t99 - 0.25665422222222222222222222222222222222222222222222e1 * t390 * t99 + 0.65703480888888888888888888888888888888888888888888e1 * t395 * t99
  t399 = t381 * t398
  t400 = t399 * t376
  t402 = t381 * t369
  t405 = s0 / t38 * t373
  t406 = t402 * t405
  t409 = 0.1e1 - t175
  t410 = t409 <= f.p.zeta_threshold
  t411 = r1 <= f.p.dens_threshold or t410
  t412 = -t180
  t413 = f.my_piecewise3(t410, 0, t412)
  t414 = t409 ** (0.1e1 / 0.3e1)
  t416 = f.my_piecewise3(t410, t190, 0.1e1 / t414)
  t418 = t187 * t189 * t416
  t420 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t418
  t421 = jnp.sqrt(t418)
  t424 = t418 ** 0.15e1
  t426 = t416 ** 2
  t428 = t206 * t208 * t426
  t430 = 0.37978500000000000000000000000000000000000000000000e1 * t421 + 0.89690000000000000000000000000000000000000000000000e0 * t418 + 0.20477500000000000000000000000000000000000000000000e0 * t424 + 0.12323500000000000000000000000000000000000000000000e0 * t428
  t433 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t430
  t434 = jnp.log(t433)
  t436 = 0.62182e-1 * t420 * t434
  t438 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t418
  t443 = 0.70594500000000000000000000000000000000000000000000e1 * t421 + 0.15494250000000000000000000000000000000000000000000e1 * t418 + 0.42077500000000000000000000000000000000000000000000e0 * t424 + 0.15629250000000000000000000000000000000000000000000e0 * t428
  t446 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t443
  t447 = jnp.log(t446)
  t451 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t418
  t456 = 0.51785000000000000000000000000000000000000000000000e1 * t421 + 0.90577500000000000000000000000000000000000000000000e0 * t418 + 0.11003250000000000000000000000000000000000000000000e0 * t424 + 0.12417750000000000000000000000000000000000000000000e0 * t428
  t459 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t456
  t460 = jnp.log(t459)
  t461 = t451 * t460
  t467 = -t436 + t229 * (-0.31090e-1 * t438 * t447 + t436 - 0.19751789702565206228825776161588751761046270558698e-1 * t461) + 0.19751789702565206228825776161588751761046270558698e-1 * t229 * t461
  t469 = f.my_piecewise3(t410, f.p.zeta_threshold, t409)
  t471 = t187 * t265 * t416
  t472 = 0.17808333333333333333333333333333333333333333333333e-1 * t471
  t473 = t414 * t409
  t474 = 0.1e1 / t473
  t477 = f.my_piecewise3(t410, 0, -t474 * t412 / 0.3e1)
  t479 = t187 * t189 * t477
  t481 = -t472 + 0.53425000000000000000000000000000000000000000000000e-1 * t479
  t483 = 0.62182e-1 * t481 * t434
  t484 = t430 ** 2
  t485 = 0.1e1 / t484
  t486 = t420 * t485
  t487 = 0.1e1 / t421
  t488 = t471 / 0.3e1
  t489 = -t488 + t479
  t490 = t487 * t489
  t492 = 0.29896666666666666666666666666666666666666666666667e0 * t471
  t494 = t418 ** 0.5e0
  t495 = t494 * t489
  t498 = t206 * t295 * t426
  t499 = 0.82156666666666666666666666666666666666666666666667e-1 * t498
  t500 = t416 * t477
  t502 = t206 * t208 * t500
  t504 = 0.18989250000000000000000000000000000000000000000000e1 * t490 - t492 + 0.89690000000000000000000000000000000000000000000000e0 * t479 + 0.30716250000000000000000000000000000000000000000000e0 * t495 - t499 + 0.24647000000000000000000000000000000000000000000000e0 * t502
  t505 = 0.1e1 / t433
  t506 = t504 * t505
  t508 = 0.10000000000000000000000000000000000000000000000000e1 * t486 * t506
  t509 = 0.17123333333333333333333333333333333333333333333333e-1 * t471
  t511 = -t509 + 0.51370000000000000000000000000000000000000000000000e-1 * t479
  t514 = t443 ** 2
  t515 = 0.1e1 / t514
  t516 = t438 * t515
  t518 = 0.51647500000000000000000000000000000000000000000000e0 * t471
  t521 = 0.10419500000000000000000000000000000000000000000000e0 * t498
  t523 = 0.35297250000000000000000000000000000000000000000000e1 * t490 - t518 + 0.15494250000000000000000000000000000000000000000000e1 * t479 + 0.63116250000000000000000000000000000000000000000000e0 * t495 - t521 + 0.31258500000000000000000000000000000000000000000000e0 * t502
  t524 = 0.1e1 / t446
  t525 = t523 * t524
  t528 = 0.92708333333333333333333333333333333333333333333333e-2 * t471
  t530 = -t528 + 0.27812500000000000000000000000000000000000000000000e-1 * t479
  t531 = t530 * t460
  t533 = t456 ** 2
  t534 = 0.1e1 / t533
  t535 = t451 * t534
  t537 = 0.30192500000000000000000000000000000000000000000000e0 * t471
  t540 = 0.82785000000000000000000000000000000000000000000000e-1 * t498
  t542 = 0.25892500000000000000000000000000000000000000000000e1 * t490 - t537 + 0.90577500000000000000000000000000000000000000000000e0 * t479 + 0.16504875000000000000000000000000000000000000000000e0 * t495 - t540 + 0.24835500000000000000000000000000000000000000000000e0 * t502
  t543 = 0.1e1 / t459
  t544 = t542 * t543
  t551 = t229 * t451
  t553 = t534 * t542 * t543
  t556 = -t483 + t508 + t229 * (-0.31090e-1 * t511 * t447 + 0.99999999999999999999999999999999999999999999999999e0 * t516 * t525 + t483 - t508 - 0.19751789702565206228825776161588751761046270558698e-1 * t531 + 0.58482233974552040708313425006184496242808878304903e0 * t535 * t544) + 0.19751789702565206228825776161588751761046270558698e-1 * t229 * t531 - 0.58482233974552040708313425006184496242808878304903e0 * t551 * t553
  t560 = f.my_piecewise3(t411, 0, t413 * t467 / 0.2e1 + t469 * t556 / 0.2e1)
  t562 = 0.1e1 + 0.256e1 * t151
  t563 = jnp.sqrt(t562)
  t564 = 0.1e1 / t563
  t567 = 0.1e1 / t562
  t570 = 0.2606e0 - 0.153728e1 * t150 * t564 + 0.2309888e1 * t151 * t567
  t571 = t560 * t570
  t574 = 0.1e1 / tau1
  t577 = 0.1e1 - s2 / r1 * t574 / 0.8e1
  t578 = t571 * t577
  t580 = t186 * t264
  t582 = t184 * t186 * t188
  t583 = jnp.sqrt(t582)
  t586 = t582 ** 0.15e1
  t589 = t205 * t185 * t76
  t591 = 0.37978500000000000000000000000000000000000000000000e1 * t583 + 0.89690000000000000000000000000000000000000000000000e0 * t582 + 0.20477500000000000000000000000000000000000000000000e0 * t586 + 0.12323500000000000000000000000000000000000000000000e0 * t589
  t594 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t591
  t595 = jnp.log(t594)
  t598 = 0.11073577833333333333333333333333333333333333333333e-2 * t184 * t580 * t595
  t600 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t582
  t601 = t591 ** 2
  t602 = 0.1e1 / t601
  t603 = t600 * t602
  t605 = 0.1e1 / t583 * t1
  t606 = t183 * t186
  t607 = t606 * t264
  t608 = t605 * t607
  t610 = t184 * t580
  t612 = t582 ** 0.5e0
  t613 = t612 * t1
  t614 = t613 * t607
  t617 = t205 * t185 * t294
  t619 = -0.63297500000000000000000000000000000000000000000000e0 * t608 - 0.29896666666666666666666666666666666666666666666667e0 * t610 - 0.10238750000000000000000000000000000000000000000000e0 * t614 - 0.82156666666666666666666666666666666666666666666667e-1 * t617
  t620 = 0.1e1 / t594
  t621 = t619 * t620
  t623 = 0.10000000000000000000000000000000000000000000000000e1 * t603 * t621
  t624 = t174 ** 2
  t625 = t624 * t174
  t626 = t16 ** 2
  t627 = 0.1e1 / t626
  t628 = t625 * t627
  t629 = f.my_piecewise3(t177, t70, t269)
  t630 = f.my_piecewise3(t410, t70, t473)
  t632 = (t629 + t630 - 0.2e1) * t228
  t634 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t582
  t639 = 0.70594500000000000000000000000000000000000000000000e1 * t583 + 0.15494250000000000000000000000000000000000000000000e1 * t582 + 0.42077500000000000000000000000000000000000000000000e0 * t586 + 0.15629250000000000000000000000000000000000000000000e0 * t589
  t642 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t639
  t643 = jnp.log(t642)
  t647 = 0.62182e-1 * t600 * t595
  t649 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t582
  t654 = 0.51785000000000000000000000000000000000000000000000e1 * t583 + 0.90577500000000000000000000000000000000000000000000e0 * t582 + 0.11003250000000000000000000000000000000000000000000e0 * t586 + 0.12417750000000000000000000000000000000000000000000e0 * t589
  t657 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t654
  t658 = jnp.log(t657)
  t659 = t649 * t658
  t661 = -0.31090e-1 * t634 * t643 + t647 - 0.19751789702565206228825776161588751761046270558698e-1 * t659
  t662 = t632 * t661
  t664 = 0.4e1 * t628 * t662
  t665 = t624 ** 2
  t667 = 0.1e1 / t626 / t5
  t668 = t665 * t667
  t670 = 0.4e1 * t668 * t662
  t671 = t665 * t627
  t674 = f.my_piecewise3(t177, 0, 0.4e1 / 0.3e1 * t191 * t180)
  t677 = f.my_piecewise3(t410, 0, 0.4e1 / 0.3e1 * t414 * t412)
  t679 = (t674 + t677) * t228
  t680 = t679 * t661
  t685 = t639 ** 2
  t686 = 0.1e1 / t685
  t687 = t634 * t686
  t692 = -0.11765750000000000000000000000000000000000000000000e1 * t608 - 0.51647500000000000000000000000000000000000000000000e0 * t610 - 0.21038750000000000000000000000000000000000000000000e0 * t614 - 0.10419500000000000000000000000000000000000000000000e0 * t617
  t693 = 0.1e1 / t642
  t694 = t692 * t693
  t700 = t654 ** 2
  t701 = 0.1e1 / t700
  t702 = t649 * t701
  t707 = -0.86308333333333333333333333333333333333333333333334e0 * t608 - 0.30192500000000000000000000000000000000000000000000e0 * t610 - 0.55016250000000000000000000000000000000000000000000e-1 * t614 - 0.82785000000000000000000000000000000000000000000000e-1 * t617
  t708 = 0.1e1 / t657
  t709 = t707 * t708
  t712 = 0.53236443333333333333333333333333333333333333333332e-3 * t184 * t580 * t643 + 0.99999999999999999999999999999999999999999999999999e0 * t687 * t694 - t598 - t623 + 0.18311555036753159941307229983139571945136646663793e-3 * t184 * t580 * t658 + 0.58482233974552040708313425006184496242808878304903e0 * t702 * t709
  t713 = t632 * t712
  t714 = t671 * t713
  t717 = t632 * t1
  t719 = t606 * t264 * t658
  t721 = 0.18311555036753159941307229983139571945136646663793e-3 * t717 * t719
  t722 = t632 * t649
  t724 = t701 * t707 * t708
  t726 = 0.58482233974552040708313425006184496242808878304903e0 * t722 * t724
  t727 = t598 + t623 + t664 - t670 + t671 * t680 + t714 + 0.19751789702565206228825776161588751761046270558698e-1 * t679 * t659 - t721 - t726 - t359 - t560
  t730 = 0.1e1 - 0.5e1 / 0.18e2 * t52 - 0.5e1 / 0.18e2 * t148
  t731 = t730 ** 2
  t733 = 0.1e1 + 0.196e-1 * t731
  t734 = jnp.sqrt(t733)
  t735 = 0.1e1 / t734
  t738 = 0.1e1 / t733
  t741 = 0.12033e1 - 0.318038e0 * t730 * t735 + 0.1880816e-1 * t731 * t738
  t742 = t727 * t741
  t749 = f.my_piecewise3(t411, 0, t469 * t467 / 0.2e1)
  t750 = -t647 + t671 * t662 + 0.19751789702565206228825776161588751761046270558698e-1 * t632 * t659 - t381 - t749
  t751 = t51 * t735
  t755 = 0.1e1 / t734 / t733
  t756 = t731 * t755
  t759 = t730 * t738
  t762 = t731 * t730
  t763 = t733 ** 2
  t764 = 0.1e1 / t763
  t765 = t762 * t764
  t768 = 0.88343888888888888888888888888888888888888888888889e-1 * t92 * t751 - 0.17315402222222222222222222222222222222222222222222e-2 * t756 * t99 - 0.10448977777777777777777777777777777777777777777778e-1 * t759 * t99 + 0.20479996444444444444444444444444444444444444444445e-3 * t765 * t99
  t769 = t750 * t768
  t779 = 0.35616666666666666666666666666666666666666666666666e-1 * t187 * t264 * t602 * t621
  t781 = 0.1e1 / t31 / t16
  t785 = 0.24415406715670879921742973310852762593515528885057e-3 * t717 * t606 * t781 * t658
  t787 = t679 * t1 * t719
  t790 = 0.1e1 / t700 / t654
  t791 = t707 ** 2
  t795 = 0.11696446794910408141662685001236899248561775660981e1 * t722 * t790 * t791 * t708
  t796 = t700 ** 2
  t797 = 0.1e1 / t796
  t799 = t657 ** 2
  t800 = 0.1e1 / t799
  t803 = 0.17315755899375863299672358916972966258900005419821e2 * t722 * t797 * t791 * t800
  t809 = 0.1e1 / t75 / t16
  t810 = t204 * t185 * t809
  t811 = 0.1e1 / t583 / t582 * t203 * t810
  t813 = t606 * t781
  t814 = t605 * t813
  t816 = t186 * t781
  t817 = t184 * t816
  t819 = t582 ** (-0.5e0)
  t821 = t819 * t203 * t810
  t823 = t613 * t813
  t826 = t205 * t185 * t809
  t828 = -0.57538888888888888888888888888888888888888888888889e0 * t811 + 0.11507777777777777777777777777777777777777777777778e1 * t814 + 0.40256666666666666666666666666666666666666666666667e0 * t817 + 0.36677500000000000000000000000000000000000000000000e-1 * t821 + 0.73355000000000000000000000000000000000000000000000e-1 * t823 + 0.13797500000000000000000000000000000000000000000000e0 * t826
  t832 = 0.58482233974552040708313425006184496242808878304903e0 * t722 * t701 * t828 * t708
  t834 = t679 * t649 * t724
  t836 = t174 * t126
  t838 = 0.2e1 * t17 - 0.2e1 * t836
  t839 = f.my_piecewise3(t410, 0, t838)
  t843 = t781 * t10
  t845 = t187 * t843 * t416
  t846 = 0.23744444444444444444444444444444444444444444444444e-1 * t845
  t848 = t187 * t265 * t477
  t850 = t409 ** 2
  t852 = 0.1e1 / t414 / t850
  t853 = t412 ** 2
  t859 = f.my_piecewise3(t410, 0, 0.4e1 / 0.9e1 * t852 * t853 - t474 * t838 / 0.3e1)
  t861 = t187 * t189 * t859
  t865 = 0.62182e-1 * (t846 - 0.35616666666666666666666666666666666666666666666666e-1 * t848 + 0.53425000000000000000000000000000000000000000000000e-1 * t861) * t434
  t866 = t481 * t485
  t868 = 0.20000000000000000000000000000000000000000000000000e1 * t866 * t506
  t871 = t420 / t484 / t430
  t872 = t504 ** 2
  t875 = 0.20000000000000000000000000000000000000000000000000e1 * t871 * t872 * t505
  t877 = 0.1e1 / t421 / t418
  t878 = t489 ** 2
  t879 = t877 * t878
  t881 = 0.4e1 / 0.9e1 * t845
  t883 = t881 - 0.2e1 / 0.3e1 * t848 + t861
  t884 = t487 * t883
  t886 = 0.39862222222222222222222222222222222222222222222223e0 * t845
  t889 = t418 ** (-0.5e0)
  t890 = t889 * t878
  t892 = t494 * t883
  t894 = t809 * t207
  t896 = t206 * t894 * t426
  t897 = 0.13692777777777777777777777777777777777777777777778e0 * t896
  t899 = t206 * t295 * t500
  t901 = t477 ** 2
  t903 = t206 * t208 * t901
  t907 = t206 * t208 * t416 * t859
  t909 = -0.94946250000000000000000000000000000000000000000000e0 * t879 + 0.18989250000000000000000000000000000000000000000000e1 * t884 + t886 - 0.59793333333333333333333333333333333333333333333334e0 * t848 + 0.89690000000000000000000000000000000000000000000000e0 * t861 + 0.15358125000000000000000000000000000000000000000000e0 * t890 + 0.30716250000000000000000000000000000000000000000000e0 * t892 + t897 - 0.32862666666666666666666666666666666666666666666666e0 * t899 + 0.24647000000000000000000000000000000000000000000000e0 * t903 + 0.24647000000000000000000000000000000000000000000000e0 * t907
  t912 = 0.10000000000000000000000000000000000000000000000000e1 * t486 * t909 * t505
  t913 = t484 ** 2
  t915 = t420 / t913
  t916 = t433 ** 2
  t917 = 0.1e1 / t916
  t920 = 0.16081824322151104821330931780901225435013347914188e2 * t915 * t872 * t917
  t921 = 0.22831111111111111111111111111111111111111111111111e-1 * t845
  t927 = t511 * t515
  t932 = t438 / t514 / t443
  t933 = t523 ** 2
  t939 = 0.68863333333333333333333333333333333333333333333333e0 * t845
  t944 = 0.17365833333333333333333333333333333333333333333333e0 * t896
  t948 = -0.17648625000000000000000000000000000000000000000000e1 * t879 + 0.35297250000000000000000000000000000000000000000000e1 * t884 + t939 - 0.10329500000000000000000000000000000000000000000000e1 * t848 + 0.15494250000000000000000000000000000000000000000000e1 * t861 + 0.31558125000000000000000000000000000000000000000000e0 * t890 + 0.63116250000000000000000000000000000000000000000000e0 * t892 + t944 - 0.41678000000000000000000000000000000000000000000000e0 * t899 + 0.31258500000000000000000000000000000000000000000000e0 * t903 + 0.31258500000000000000000000000000000000000000000000e0 * t907
  t952 = t514 ** 2
  t954 = t438 / t952
  t955 = t446 ** 2
  t956 = 0.1e1 / t955
  t960 = 0.12361111111111111111111111111111111111111111111111e-1 * t845
  t964 = (t960 - 0.18541666666666666666666666666666666666666666666667e-1 * t848 + 0.27812500000000000000000000000000000000000000000000e-1 * t861) * t460
  t966 = t530 * t534
  t970 = 0.1e1 / t533 / t456
  t971 = t451 * t970
  t972 = t542 ** 2
  t978 = 0.40256666666666666666666666666666666666666666666667e0 * t845
  t983 = 0.13797500000000000000000000000000000000000000000000e0 * t896
  t987 = -0.12946250000000000000000000000000000000000000000000e1 * t879 + 0.25892500000000000000000000000000000000000000000000e1 * t884 + t978 - 0.60385000000000000000000000000000000000000000000000e0 * t848 + 0.90577500000000000000000000000000000000000000000000e0 * t861 + 0.82524375000000000000000000000000000000000000000000e-1 * t890 + 0.16504875000000000000000000000000000000000000000000e0 * t892 + t983 - 0.33114000000000000000000000000000000000000000000000e0 * t899 + 0.24835500000000000000000000000000000000000000000000e0 * t903 + 0.24835500000000000000000000000000000000000000000000e0 * t907
  t991 = t533 ** 2
  t992 = 0.1e1 / t991
  t993 = t451 * t992
  t994 = t459 ** 2
  t995 = 0.1e1 / t994
  t999 = -0.31090e-1 * (t921 - 0.34246666666666666666666666666666666666666666666666e-1 * t848 + 0.51370000000000000000000000000000000000000000000000e-1 * t861) * t447 + 0.20000000000000000000000000000000000000000000000000e1 * t927 * t525 - 0.20000000000000000000000000000000000000000000000000e1 * t932 * t933 * t524 + 0.99999999999999999999999999999999999999999999999999e0 * t516 * t948 * t524 + 0.32164683177870697973624959794146027661627532968800e2 * t954 * t933 * t956 + t865 - t868 + t875 - t912 - t920 - 0.19751789702565206228825776161588751761046270558698e-1 * t964 + 0.11696446794910408141662685001236899248561775660981e1 * t966 * t544 - 0.11696446794910408141662685001236899248561775660981e1 * t971 * t972 * t543 + 0.58482233974552040708313425006184496242808878304903e0 * t535 * t987 * t543 + 0.17315755899375863299672358916972966258900005419821e2 * t993 * t972 * t995
  t1003 = t229 * t530
  t1018 = -t865 + t868 - t875 + t912 + t920 + t229 * t999 + 0.19751789702565206228825776161588751761046270558698e-1 * t229 * t964 - 0.11696446794910408141662685001236899248561775660981e1 * t1003 * t553 + 0.11696446794910408141662685001236899248561775660981e1 * t551 * t970 * t972 * t543 - 0.58482233974552040708313425006184496242808878304903e0 * t551 * t534 * t987 * t543 - 0.17315755899375863299672358916972966258900005419821e2 * t551 * t992 * t972 * t995
  t1022 = f.my_piecewise3(t411, 0, t839 * t467 / 0.2e1 + t413 * t556 + t469 * t1018 / 0.2e1)
  t1024 = 0.8e1 * t628 * t713
  t1025 = t668 * t680
  t1028 = 0.8e1 * t668 * t713
  t1030 = t671 * t679 * t712
  t1032 = -t779 + t785 - 0.36623110073506319882614459966279143890273293327586e-3 * t787 + t795 - t803 - t832 - 0.11696446794910408141662685001236899248561775660981e1 * t834 - t1022 + t1024 - 0.8e1 * t1025 - t1028 + 0.2e1 * t1030
  t1033 = t628 * t680
  t1035 = t191 ** 2
  t1036 = 0.1e1 / t1035
  t1037 = t180 ** 2
  t1040 = -t838
  t1044 = f.my_piecewise3(t177, 0, 0.4e1 / 0.9e1 * t1036 * t1037 + 0.4e1 / 0.3e1 * t191 * t1040)
  t1045 = t414 ** 2
  t1046 = 0.1e1 / t1045
  t1052 = f.my_piecewise3(t410, 0, 0.4e1 / 0.9e1 * t1046 * t853 + 0.4e1 / 0.3e1 * t414 * t838)
  t1054 = (t1044 + t1052) * t228
  t1059 = 0.14764770444444444444444444444444444444444444444444e-2 * t184 * t816 * t595
  t1060 = f.my_piecewise3(t177, 0, t1040)
  t1065 = t187 * t843 * t193
  t1066 = 0.23744444444444444444444444444444444444444444444444e-1 * t1065
  t1068 = t187 * t265 * t273
  t1070 = t176 ** 2
  t1072 = 0.1e1 / t191 / t1070
  t1078 = f.my_piecewise3(t177, 0, 0.4e1 / 0.9e1 * t1072 * t1037 - t270 * t1040 / 0.3e1)
  t1080 = t187 * t189 * t1078
  t1084 = 0.62182e-1 * (t1066 - 0.35616666666666666666666666666666666666666666666666e-1 * t1068 + 0.53425000000000000000000000000000000000000000000000e-1 * t1080) * t217
  t1085 = t277 * t281
  t1087 = 0.20000000000000000000000000000000000000000000000000e1 * t1085 * t305
  t1090 = t197 / t280 / t213
  t1091 = t303 ** 2
  t1094 = 0.20000000000000000000000000000000000000000000000000e1 * t1090 * t1091 * t304
  t1096 = 0.1e1 / t198 / t195
  t1097 = t285 ** 2
  t1098 = t1096 * t1097
  t1100 = 0.4e1 / 0.9e1 * t1065
  t1102 = t1100 - 0.2e1 / 0.3e1 * t1068 + t1080
  t1103 = t283 * t1102
  t1105 = 0.39862222222222222222222222222222222222222222222223e0 * t1065
  t1108 = t195 ** (-0.5e0)
  t1109 = t1108 * t1097
  t1111 = t290 * t1102
  t1114 = t206 * t894 * t209
  t1115 = 0.13692777777777777777777777777777777777777777777778e0 * t1114
  t1117 = t206 * t295 * t299
  t1119 = t273 ** 2
  t1121 = t206 * t208 * t1119
  t1125 = t206 * t208 * t193 * t1078
  t1127 = -0.94946250000000000000000000000000000000000000000000e0 * t1098 + 0.18989250000000000000000000000000000000000000000000e1 * t1103 + t1105 - 0.59793333333333333333333333333333333333333333333334e0 * t1068 + 0.89690000000000000000000000000000000000000000000000e0 * t1080 + 0.15358125000000000000000000000000000000000000000000e0 * t1109 + 0.30716250000000000000000000000000000000000000000000e0 * t1111 + t1115 - 0.32862666666666666666666666666666666666666666666666e0 * t1117 + 0.24647000000000000000000000000000000000000000000000e0 * t1121 + 0.24647000000000000000000000000000000000000000000000e0 * t1125
  t1130 = 0.10000000000000000000000000000000000000000000000000e1 * t282 * t1127 * t304
  t1131 = t280 ** 2
  t1133 = t197 / t1131
  t1134 = t216 ** 2
  t1135 = 0.1e1 / t1134
  t1138 = 0.16081824322151104821330931780901225435013347914188e2 * t1133 * t1091 * t1135
  t1139 = 0.22831111111111111111111111111111111111111111111111e-1 * t1065
  t1145 = t310 * t314
  t1150 = t231 / t313 / t236
  t1151 = t322 ** 2
  t1157 = 0.68863333333333333333333333333333333333333333333333e0 * t1065
  t1162 = 0.17365833333333333333333333333333333333333333333333e0 * t1114
  t1166 = -0.17648625000000000000000000000000000000000000000000e1 * t1098 + 0.35297250000000000000000000000000000000000000000000e1 * t1103 + t1157 - 0.10329500000000000000000000000000000000000000000000e1 * t1068 + 0.15494250000000000000000000000000000000000000000000e1 * t1080 + 0.31558125000000000000000000000000000000000000000000e0 * t1109 + 0.63116250000000000000000000000000000000000000000000e0 * t1111 + t1162 - 0.41678000000000000000000000000000000000000000000000e0 * t1117 + 0.31258500000000000000000000000000000000000000000000e0 * t1121 + 0.31258500000000000000000000000000000000000000000000e0 * t1125
  t1170 = t313 ** 2
  t1172 = t231 / t1170
  t1173 = t239 ** 2
  t1174 = 0.1e1 / t1173
  t1178 = 0.12361111111111111111111111111111111111111111111111e-1 * t1065
  t1182 = (t1178 - 0.18541666666666666666666666666666666666666666666667e-1 * t1068 + 0.27812500000000000000000000000000000000000000000000e-1 * t1080) * t253
  t1184 = t329 * t333
  t1188 = 0.1e1 / t332 / t249
  t1189 = t244 * t1188
  t1190 = t341 ** 2
  t1196 = 0.40256666666666666666666666666666666666666666666667e0 * t1065
  t1201 = 0.13797500000000000000000000000000000000000000000000e0 * t1114
  t1205 = -0.12946250000000000000000000000000000000000000000000e1 * t1098 + 0.25892500000000000000000000000000000000000000000000e1 * t1103 + t1196 - 0.60385000000000000000000000000000000000000000000000e0 * t1068 + 0.90577500000000000000000000000000000000000000000000e0 * t1080 + 0.82524375000000000000000000000000000000000000000000e-1 * t1109 + 0.16504875000000000000000000000000000000000000000000e0 * t1111 + t1201 - 0.33114000000000000000000000000000000000000000000000e0 * t1117 + 0.24835500000000000000000000000000000000000000000000e0 * t1121 + 0.24835500000000000000000000000000000000000000000000e0 * t1125
  t1209 = t332 ** 2
  t1210 = 0.1e1 / t1209
  t1211 = t244 * t1210
  t1212 = t252 ** 2
  t1213 = 0.1e1 / t1212
  t1217 = -0.31090e-1 * (t1139 - 0.34246666666666666666666666666666666666666666666666e-1 * t1068 + 0.51370000000000000000000000000000000000000000000000e-1 * t1080) * t240 + 0.20000000000000000000000000000000000000000000000000e1 * t1145 * t324 - 0.20000000000000000000000000000000000000000000000000e1 * t1150 * t1151 * t323 + 0.99999999999999999999999999999999999999999999999999e0 * t315 * t1166 * t323 + 0.32164683177870697973624959794146027661627532968800e2 * t1172 * t1151 * t1174 + t1084 - t1087 + t1094 - t1130 - t1138 - 0.19751789702565206228825776161588751761046270558698e-1 * t1182 + 0.11696446794910408141662685001236899248561775660981e1 * t1184 * t343 - 0.11696446794910408141662685001236899248561775660981e1 * t1189 * t1190 * t342 + 0.58482233974552040708313425006184496242808878304903e0 * t334 * t1205 * t342 + 0.17315755899375863299672358916972966258900005419821e2 * t1211 * t1190 * t1213
  t1221 = t229 * t329
  t1236 = -t1084 + t1087 - t1094 + t1130 + t1138 + t229 * t1217 + 0.19751789702565206228825776161588751761046270558698e-1 * t229 * t1182 - 0.11696446794910408141662685001236899248561775660981e1 * t1221 * t352 + 0.11696446794910408141662685001236899248561775660981e1 * t350 * t1188 * t1190 * t342 - 0.58482233974552040708313425006184496242808878304903e0 * t350 * t333 * t1205 * t342 - 0.17315755899375863299672358916972966258900005419821e2 * t350 * t1210 * t1190 * t1213
  t1240 = f.my_piecewise3(t178, 0, t1060 * t260 / 0.2e1 + t181 * t355 + t262 * t1236 / 0.2e1)
  t1247 = 0.20e2 * t665 / t626 / t16 * t662
  t1250 = 0.12e2 * t624 * t627 * t662
  t1253 = 0.32e2 * t625 * t667 * t662
  t1264 = t692 ** 2
  t1278 = t685 ** 2
  t1281 = t642 ** 2
  t1289 = t619 ** 2
  t1292 = 0.20000000000000000000000000000000000000000000000000e1 * t600 / t601 / t591 * t1289 * t620
  t1302 = 0.10000000000000000000000000000000000000000000000000e1 * t603 * (-0.42198333333333333333333333333333333333333333333333e0 * t811 + 0.84396666666666666666666666666666666666666666666666e0 * t814 + 0.39862222222222222222222222222222222222222222222223e0 * t817 + 0.68258333333333333333333333333333333333333333333333e-1 * t821 + 0.13651666666666666666666666666666666666666666666667e0 * t823 + 0.13692777777777777777777777777777777777777777777778e0 * t826) * t620
  t1303 = t601 ** 2
  t1306 = t594 ** 2
  t1310 = 0.16081824322151104821330931780901225435013347914188e2 * t600 / t1303 * t1289 / t1306
  t1329 = -0.70981924444444444444444444444444444444444444444442e-3 * t184 * t816 * t643 - 0.34246666666666666666666666666666666666666666666666e-1 * t187 * t264 * t686 * t694 - 0.20000000000000000000000000000000000000000000000000e1 * t634 / t685 / t639 * t1264 * t693 + 0.99999999999999999999999999999999999999999999999999e0 * t687 * (-0.78438333333333333333333333333333333333333333333333e0 * t811 + 0.15687666666666666666666666666666666666666666666667e1 * t814 + 0.68863333333333333333333333333333333333333333333333e0 * t817 + 0.14025833333333333333333333333333333333333333333333e0 * t821 + 0.28051666666666666666666666666666666666666666666667e0 * t823 + 0.17365833333333333333333333333333333333333333333333e0 * t826) * t693 + 0.32164683177870697973624959794146027661627532968800e2 * t634 / t1278 * t1264 / t1281 + t1059 + t779 + t1292 - t1302 - t1310 - 0.24415406715670879921742973310852762593515528885057e-3 * t184 * t816 * t658 - 0.10843580882781524214666447553230042011687479519034e-1 * t187 * t264 * t701 * t709 - 0.11696446794910408141662685001236899248561775660981e1 * t649 * t790 * t791 * t708 + 0.58482233974552040708313425006184496242808878304903e0 * t702 * t828 * t708 + 0.17315755899375863299672358916972966258900005419821e2 * t649 * t797 * t791 * t800
  t1331 = t671 * t632 * t1329
  t1335 = 0.10843580882781524214666447553230042011687479519034e-1 * t632 * t184 * t580 * t724
  t1336 = 0.8e1 * t1033 + t671 * t1054 * t661 - t1059 - t1240 + 0.19751789702565206228825776161588751761046270558698e-1 * t1054 * t659 + t1247 + t1250 - t1253 + t1331 - t1292 + t1302 + t1310 + t1335
  t1347 = 0.4e1 * t118 * t126 * t119
  t1349 = t124 * t627 * t128
  t1351 = t123 * r1
  t1354 = 0.1e1 / t127 / t115
  t1359 = f.my_piecewise3(t117, 0, t1347 + 0.8e1 / 0.3e1 * t1349 - 0.4e1 / 0.9e1 * t10 * t1351 * t667 * t1354)
  t1365 = t4 * t77 * t111
  t1369 = t38 ** 2
  t1377 = (0.40e2 / 0.9e1 * tau0 * t86 - 0.11e2 / 0.9e1 * s0 / t34 / t1369 - 0.10e2 / 0.9e1 * l0 * t86) * t46
  t1380 = t91 ** 2
  t1381 = t46 ** 2
  t1382 = t1380 * t1381
  t1384 = 0.1e1 / t49 / t48
  t1392 = t1382 * t1384
  t1395 = t1377 * t51
  t1406 = t55 ** 2
  t1418 = t10 * t17
  t1419 = t1418 * t12
  t1426 = 0.4e1 * t15 * t126 * t12
  t1429 = t15 * t17 * t22 * t25
  t1432 = 0.1e1 / t21 / t7
  t1434 = t25 ** 2
  t1445 = f.my_piecewise3(t9, 0, -0.4e1 * t1419 + 0.4e1 / 0.3e1 * t11 * t22 * t25 + t1426 - 0.4e1 / 0.3e1 * t1429 - 0.4e1 / 0.9e1 * t15 * t6 * t1432 * t1434 + 0.2e1 / 0.3e1 * t15 * t23 * (0.2e1 * r0 * t126 - 0.2e1 * t17))
  t1455 = t4 * t30 * t76 * t65
  t1460 = t4 * t74 * t294 * t65 / 0.12e2
  t1463 = t4 * t133 * t76 * t161
  t1468 = t4 * t168 * t294 * t161 / 0.12e2
  t1508 = t1384 * t755 * t730
  t1513 = t762 / t734 / t763
  t1518 = t1384 * t738
  t1521 = t731 * t764
  t1526 = t731 ** 2
  t1529 = t1526 / t763 / t733
  t1538 = -t402 * s0 / t84 * t373 / 0.4e1 + (t1032 + t1336) * t741 + t1240 * t369 * t376 + t370 * t405 / 0.4e1 + t399 * t405 / 0.4e1 - 0.3e1 / 0.8e1 * t4 * t1359 * t31 * t161 - t1365 / 0.4e1 - 0.3e1 / 0.8e1 * t4 * t81 * (-0.40834444444444444444444444444444444444444444444444e-1 * t1377 * t93 - 0.82349462962962962962962962962962962962962962962960e-3 * t1382 * t1384 * t97 * t54 + 0.99642850185185185185185185185185185185185185185178e-5 * t105 / t58 / t106 * t1392 + 0.49409677777777777777777777777777777777777777777776e-3 * t98 * t1395 + 0.10606172839506172839506172839506172839506172839506e-2 * t1382 * t1384 * t62 - 0.64167345679012345679012345679012345679012345679011e-4 * t55 * t107 * t1392 - 0.19091111111111111111111111111111111111111111111111e-2 * t102 * t1395 + 0.62113990617283950617283950617283950617283950617281e-6 * t1406 / t106 / t57 * t1392 + 0.23100244444444444444444444444444444444444444444444e-4 * t108 * t1395) - 0.3e1 / 0.8e1 * t4 * t1445 * t31 * t65 - 0.3e1 / 0.4e1 * t4 * t32 * t111 - t1455 / 0.4e1 + t1460 - t1463 / 0.4e1 + t1468 + 0.2e1 * t359 * t398 * t376 + t381 * (0.85404444444444444444444444444444444444444444444445e0 * t1377 * t382 + 0.36439229629629629629629629629629629629629629629629e1 * t1382 * t1384 * t386 * t54 - 0.93284427851851851851851851851851851851851851851847e1 * t105 / t362 / t393 * t1392 - 0.21863537777777777777777777777777777777777777777777e1 * t387 * t1395 + 0.14258567901234567901234567901234567901234567901234e1 * t1382 * t1384 * t366 - 0.18250966913580246913580246913580246913580246913580e2 * t55 * t394 * t1392 - 0.25665422222222222222222222222222222222222222222222e1 * t390 * t1395 + 0.37377980239012345679012345679012345679012345679011e2 * t1406 / t393 / t361 * t1392 + 0.65703480888888888888888888888888888888888888888888e1 * t395 * t1395) * t376 + t1022 * t570 * t577 + t750 * (0.88343888888888888888888888888888888888888888888889e-1 * t1377 * t751 + 0.14429501851851851851851851851851851851851851851852e-2 * t1382 * t1508 - 0.28281823629629629629629629629629629629629629629630e-4 * t1513 * t1392 - 0.17315402222222222222222222222222222222222222222222e-2 * t756 * t1395 + 0.29024938271604938271604938271604938271604938271606e-2 * t1382 * t1518 - 0.28444439506172839506172839506172839506172839506173e-3 * t1521 * t1392 - 0.10448977777777777777777777777777777777777777777778e-1 * t759 * t1395 + 0.44600881145679012345679012345679012345679012345681e-5 * t1529 * t1392 + 0.20479996444444444444444444444444444444444444444445e-3 * t765 * t1395) + 0.2e1 * t727 * t768
  d11 = -0.3e1 / 0.4e1 * t67 - t80 - 0.3e1 / 0.4e1 * t113 - 0.3e1 / 0.4e1 * t163 - t172 + 0.2e1 * t377 + 0.2e1 * t400 + t406 / 0.4e1 + 0.2e1 * t578 + 0.2e1 * t742 + 0.2e1 * t769 + t5 * t1538
  t1545 = t10 * t38
  t1546 = t126 * t22
  t1550 = f.my_piecewise3(t9, 0, -t20 - 0.2e1 / 0.3e1 * t1545 * t1546)
  t1551 = t1550 * t31
  t1553 = t4 * t1551 * t65
  t1557 = t6 * t128
  t1559 = -r1 * t17 + t6
  t1564 = f.my_piecewise3(t117, 0, 0.2e1 * t11 * t119 - t122 + 0.2e1 / 0.3e1 * t118 * t1557 * t1559)
  t1565 = t1564 * t31
  t1567 = t4 * t1565 * t161
  t1569 = t168 * t31
  t1573 = 0.1e1 / t136 / t1351
  t1578 = -0.5e1 / 0.3e1 * tau1 * t141 + s2 * t1573 / 0.3e1 + 0.5e1 / 0.12e2 * l1 * t141
  t1579 = t1578 * t46
  t1580 = t51 * t155
  t1584 = 0.1e1 / t154 / t153
  t1585 = t151 * t1584
  t1586 = t1579 * t51
  t1589 = t150 * t158
  t1592 = t151 * t150
  t1593 = t153 ** 2
  t1594 = 0.1e1 / t1593
  t1595 = t1592 * t1594
  t1598 = -0.40834444444444444444444444444444444444444444444444e-1 * t1579 * t1580 + 0.49409677777777777777777777777777777777777777777776e-3 * t1585 * t1586 - 0.19091111111111111111111111111111111111111111111111e-2 * t1589 * t1586 + 0.23100244444444444444444444444444444444444444444444e-4 * t1595 * t1586
  t1600 = t4 * t1569 * t1598
  t1602 = -t6 - t179
  t1603 = f.my_piecewise3(t177, 0, t1602)
  t1607 = f.my_piecewise3(t177, 0, -t270 * t1602 / 0.3e1)
  t1609 = t187 * t189 * t1607
  t1611 = -t268 + 0.53425000000000000000000000000000000000000000000000e-1 * t1609
  t1613 = 0.62182e-1 * t1611 * t217
  t1614 = -t284 + t1609
  t1615 = t283 * t1614
  t1618 = t290 * t1614
  t1620 = t193 * t1607
  t1622 = t206 * t208 * t1620
  t1624 = 0.18989250000000000000000000000000000000000000000000e1 * t1615 - t288 + 0.89690000000000000000000000000000000000000000000000e0 * t1609 + 0.30716250000000000000000000000000000000000000000000e0 * t1618 - t298 + 0.24647000000000000000000000000000000000000000000000e0 * t1622
  t1625 = t1624 * t304
  t1627 = 0.10000000000000000000000000000000000000000000000000e1 * t282 * t1625
  t1629 = -t308 + 0.51370000000000000000000000000000000000000000000000e-1 * t1609
  t1636 = 0.35297250000000000000000000000000000000000000000000e1 * t1615 - t317 + 0.15494250000000000000000000000000000000000000000000e1 * t1609 + 0.63116250000000000000000000000000000000000000000000e0 * t1618 - t320 + 0.31258500000000000000000000000000000000000000000000e0 * t1622
  t1637 = t1636 * t323
  t1641 = -t327 + 0.27812500000000000000000000000000000000000000000000e-1 * t1609
  t1642 = t1641 * t253
  t1648 = 0.25892500000000000000000000000000000000000000000000e1 * t1615 - t336 + 0.90577500000000000000000000000000000000000000000000e0 * t1609 + 0.16504875000000000000000000000000000000000000000000e0 * t1618 - t339 + 0.24835500000000000000000000000000000000000000000000e0 * t1622
  t1649 = t1648 * t342
  t1657 = t333 * t1648 * t342
  t1660 = -t1613 + t1627 + t229 * (-0.31090e-1 * t1629 * t240 + 0.99999999999999999999999999999999999999999999999999e0 * t315 * t1637 + t1613 - t1627 - 0.19751789702565206228825776161588751761046270558698e-1 * t1642 + 0.58482233974552040708313425006184496242808878304903e0 * t334 * t1649) + 0.19751789702565206228825776161588751761046270558698e-1 * t229 * t1642 - 0.58482233974552040708313425006184496242808878304903e0 * t350 * t1657
  t1664 = f.my_piecewise3(t178, 0, t1603 * t260 / 0.2e1 + t262 * t1660 / 0.2e1)
  t1665 = t1664 * t369
  t1666 = t1665 * t376
  t1667 = -t1602
  t1668 = f.my_piecewise3(t410, 0, t1667)
  t1672 = f.my_piecewise3(t410, 0, -t474 * t1667 / 0.3e1)
  t1674 = t187 * t189 * t1672
  t1676 = -t472 + 0.53425000000000000000000000000000000000000000000000e-1 * t1674
  t1678 = 0.62182e-1 * t1676 * t434
  t1679 = -t488 + t1674
  t1680 = t487 * t1679
  t1683 = t494 * t1679
  t1685 = t416 * t1672
  t1687 = t206 * t208 * t1685
  t1689 = 0.18989250000000000000000000000000000000000000000000e1 * t1680 - t492 + 0.89690000000000000000000000000000000000000000000000e0 * t1674 + 0.30716250000000000000000000000000000000000000000000e0 * t1683 - t499 + 0.24647000000000000000000000000000000000000000000000e0 * t1687
  t1690 = t1689 * t505
  t1692 = 0.10000000000000000000000000000000000000000000000000e1 * t486 * t1690
  t1694 = -t509 + 0.51370000000000000000000000000000000000000000000000e-1 * t1674
  t1701 = 0.35297250000000000000000000000000000000000000000000e1 * t1680 - t518 + 0.15494250000000000000000000000000000000000000000000e1 * t1674 + 0.63116250000000000000000000000000000000000000000000e0 * t1683 - t521 + 0.31258500000000000000000000000000000000000000000000e0 * t1687
  t1702 = t1701 * t524
  t1706 = -t528 + 0.27812500000000000000000000000000000000000000000000e-1 * t1674
  t1707 = t1706 * t460
  t1713 = 0.25892500000000000000000000000000000000000000000000e1 * t1680 - t537 + 0.90577500000000000000000000000000000000000000000000e0 * t1674 + 0.16504875000000000000000000000000000000000000000000e0 * t1683 - t540 + 0.24835500000000000000000000000000000000000000000000e0 * t1687
  t1714 = t1713 * t543
  t1722 = t534 * t1713 * t543
  t1725 = -t1678 + t1692 + t229 * (-0.31090e-1 * t1694 * t447 + 0.99999999999999999999999999999999999999999999999999e0 * t516 * t1702 + t1678 - t1692 - 0.19751789702565206228825776161588751761046270558698e-1 * t1707 + 0.58482233974552040708313425006184496242808878304903e0 * t535 * t1714) + 0.19751789702565206228825776161588751761046270558698e-1 * t229 * t1707 - 0.58482233974552040708313425006184496242808878304903e0 * t551 * t1722
  t1729 = f.my_piecewise3(t411, 0, t1668 * t467 / 0.2e1 + t469 * t1725 / 0.2e1)
  t1730 = t1729 * t570
  t1731 = t1730 * t577
  t1732 = t51 * t564
  t1736 = 0.1e1 / t563 / t562
  t1737 = t151 * t1736
  t1740 = t150 * t567
  t1743 = t562 ** 2
  t1744 = 0.1e1 / t1743
  t1745 = t1592 * t1744
  t1748 = 0.85404444444444444444444444444444444444444444444445e0 * t1579 * t1732 - 0.21863537777777777777777777777777777777777777777777e1 * t1737 * t1586 - 0.25665422222222222222222222222222222222222222222222e1 * t1740 * t1586 + 0.65703480888888888888888888888888888888888888888888e1 * t1745 * t1586
  t1749 = t749 * t1748
  t1750 = t1749 * t577
  t1751 = t749 * t570
  t1754 = s2 / t123 * t574
  t1755 = t1751 * t1754
  t1759 = f.my_piecewise3(t177, 0, 0.4e1 / 0.3e1 * t191 * t1602)
  t1762 = f.my_piecewise3(t410, 0, 0.4e1 / 0.3e1 * t414 * t1667)
  t1764 = (t1759 + t1762) * t228
  t1765 = t1764 * t661
  t1769 = t598 + t623 - t664 - t670 + t671 * t1765 + t714 + 0.19751789702565206228825776161588751761046270558698e-1 * t1764 * t659 - t721 - t726 - t1664 - t1729
  t1770 = t1769 * t741
  t1779 = 0.88343888888888888888888888888888888888888888888889e-1 * t1579 * t751 - 0.17315402222222222222222222222222222222222222222222e-2 * t756 * t1586 - 0.10448977777777777777777777777777777777777777777778e-1 * t759 * t1586 + 0.20479996444444444444444444444444444444444444444445e-3 * t765 * t1586
  t1780 = t750 * t1779
  t1786 = t1545 * t627 * t22
  t1793 = f.my_piecewise3(t9, 0, -0.2e1 * t1419 + t1426 - 0.2e1 / 0.3e1 * t1429 - 0.4e1 / 0.3e1 * t15 * t1546 + 0.2e1 * t1786 + 0.4e1 / 0.9e1 * t1545 * t126 * t1432 * t25)
  t1800 = t4 * t1550 * t76 * t65
  t1807 = t1418 * t119
  t1816 = t118 * t17 * t128 * t1559
  t1822 = r1 * t126
  t1829 = f.my_piecewise3(t117, 0, -0.2e1 * t1807 - 0.2e1 / 0.3e1 * t10 * t126 * t128 * r1 + t1347 + 0.2e1 / 0.3e1 * t1349 - 0.2e1 / 0.3e1 * t1816 + 0.4e1 / 0.9e1 * t124 * t126 * t1354 * t1559 + 0.2e1 / 0.3e1 * t118 * t1557 * (-t17 + 0.2e1 * t1822))
  t1836 = t4 * t1564 * t76 * t161
  t1842 = -0.3e1 / 0.8e1 * t4 * t1793 * t31 * t65 - t1800 / 0.8e1 - 0.3e1 / 0.8e1 * t4 * t1551 * t111 - t1455 / 0.8e1 + t1460 - t1365 / 0.8e1 - 0.3e1 / 0.8e1 * t4 * t1829 * t31 * t161 - t1836 / 0.8e1 - t1463 / 0.8e1 + t1468 - 0.3e1 / 0.8e1 * t4 * t134 * t1598
  t1844 = t4 * t169 * t1598
  t1846 = 0.2e1 * t836
  t1847 = f.my_piecewise3(t177, 0, t1846)
  t1853 = t187 * t265 * t1607
  t1862 = f.my_piecewise3(t177, 0, 0.4e1 / 0.9e1 * t1072 * t1602 * t180 - 0.2e1 / 0.3e1 * t270 * t174 * t126)
  t1864 = t187 * t189 * t1862
  t1868 = 0.62182e-1 * (t1066 - 0.17808333333333333333333333333333333333333333333333e-1 * t1068 - 0.17808333333333333333333333333333333333333333333333e-1 * t1853 + 0.53425000000000000000000000000000000000000000000000e-1 * t1864) * t217
  t1869 = t1611 * t281
  t1871 = 0.10000000000000000000000000000000000000000000000000e1 * t1869 * t305
  t1873 = 0.10000000000000000000000000000000000000000000000000e1 * t1085 * t1625
  t1876 = 0.20000000000000000000000000000000000000000000000000e1 * t1090 * t1625 * t303
  t1878 = t1096 * t1614 * t285
  t1882 = t1100 - t1068 / 0.3e1 - t1853 / 0.3e1 + t1864
  t1883 = t283 * t1882
  t1889 = t1108 * t1614 * t285
  t1891 = t290 * t1882
  t1895 = t206 * t295 * t1620
  t1899 = t206 * t208 * t273 * t1607
  t1903 = t206 * t208 * t193 * t1862
  t1905 = -0.94946250000000000000000000000000000000000000000000e0 * t1878 + 0.18989250000000000000000000000000000000000000000000e1 * t1883 + t1105 - 0.29896666666666666666666666666666666666666666666667e0 * t1068 - 0.29896666666666666666666666666666666666666666666667e0 * t1853 + 0.89690000000000000000000000000000000000000000000000e0 * t1864 + 0.15358125000000000000000000000000000000000000000000e0 * t1889 + 0.30716250000000000000000000000000000000000000000000e0 * t1891 + t1115 - 0.16431333333333333333333333333333333333333333333333e0 * t1117 - 0.16431333333333333333333333333333333333333333333333e0 * t1895 + 0.24647000000000000000000000000000000000000000000000e0 * t1899 + 0.24647000000000000000000000000000000000000000000000e0 * t1903
  t1908 = 0.10000000000000000000000000000000000000000000000000e1 * t282 * t1905 * t304
  t1912 = 0.16081824322151104821330931780901225435013347914188e2 * t1133 * t1624 * t1135 * t303
  t1919 = t1629 * t314
  t1938 = -0.17648625000000000000000000000000000000000000000000e1 * t1878 + 0.35297250000000000000000000000000000000000000000000e1 * t1883 + t1157 - 0.51647500000000000000000000000000000000000000000000e0 * t1068 - 0.51647500000000000000000000000000000000000000000000e0 * t1853 + 0.15494250000000000000000000000000000000000000000000e1 * t1864 + 0.31558125000000000000000000000000000000000000000000e0 * t1889 + 0.63116250000000000000000000000000000000000000000000e0 * t1891 + t1162 - 0.20839000000000000000000000000000000000000000000000e0 * t1117 - 0.20839000000000000000000000000000000000000000000000e0 * t1895 + 0.31258500000000000000000000000000000000000000000000e0 * t1899 + 0.31258500000000000000000000000000000000000000000000e0 * t1903
  t1950 = (t1178 - 0.92708333333333333333333333333333333333333333333333e-2 * t1068 - 0.92708333333333333333333333333333333333333333333333e-2 * t1853 + 0.27812500000000000000000000000000000000000000000000e-1 * t1864) * t253
  t1952 = t1641 * t333
  t1971 = -0.12946250000000000000000000000000000000000000000000e1 * t1878 + 0.25892500000000000000000000000000000000000000000000e1 * t1883 + t1196 - 0.30192500000000000000000000000000000000000000000000e0 * t1068 - 0.30192500000000000000000000000000000000000000000000e0 * t1853 + 0.90577500000000000000000000000000000000000000000000e0 * t1864 + 0.82524375000000000000000000000000000000000000000000e-1 * t1889 + 0.16504875000000000000000000000000000000000000000000e0 * t1891 + t1201 - 0.16557000000000000000000000000000000000000000000000e0 * t1117 - 0.16557000000000000000000000000000000000000000000000e0 * t1895 + 0.24835500000000000000000000000000000000000000000000e0 * t1899 + 0.24835500000000000000000000000000000000000000000000e0 * t1903
  t1979 = -0.31090e-1 * (t1139 - 0.17123333333333333333333333333333333333333333333333e-1 * t1068 - 0.17123333333333333333333333333333333333333333333333e-1 * t1853 + 0.51370000000000000000000000000000000000000000000000e-1 * t1864) * t240 + 0.99999999999999999999999999999999999999999999999999e0 * t1919 * t324 + 0.99999999999999999999999999999999999999999999999999e0 * t1145 * t1637 - 0.20000000000000000000000000000000000000000000000000e1 * t1150 * t1637 * t322 + 0.99999999999999999999999999999999999999999999999999e0 * t315 * t1938 * t323 + 0.32164683177870697973624959794146027661627532968800e2 * t1172 * t1636 * t1174 * t322 + t1868 - t1871 - t1873 + t1876 - t1908 - t1912 - 0.19751789702565206228825776161588751761046270558698e-1 * t1950 + 0.58482233974552040708313425006184496242808878304903e0 * t1952 * t343 + 0.58482233974552040708313425006184496242808878304903e0 * t1184 * t1649 - 0.11696446794910408141662685001236899248561775660981e1 * t1189 * t1649 * t341 + 0.58482233974552040708313425006184496242808878304903e0 * t334 * t1971 * t342 + 0.17315755899375863299672358916972966258900005419821e2 * t1211 * t1648 * t1213 * t341
  t1983 = t229 * t1641
  t2001 = -t1868 + t1871 + t1873 - t1876 + t1908 + t1912 + t229 * t1979 + 0.19751789702565206228825776161588751761046270558698e-1 * t229 * t1950 - 0.58482233974552040708313425006184496242808878304903e0 * t1983 * t352 - 0.58482233974552040708313425006184496242808878304903e0 * t1221 * t1657 + 0.11696446794910408141662685001236899248561775660981e1 * t350 * t1188 * t1648 * t343 - 0.58482233974552040708313425006184496242808878304903e0 * t350 * t333 * t1971 * t342 - 0.17315755899375863299672358916972966258900005419821e2 * t350 * t1210 * t1648 * t1213 * t341
  t2005 = f.my_piecewise3(t178, 0, t1603 * t355 / 0.2e1 + t181 * t1660 / 0.2e1 + t1847 * t260 / 0.2e1 + t262 * t2001 / 0.2e1)
  t2012 = f.my_piecewise3(t410, 0, -t1846)
  t2018 = t187 * t265 * t1672
  t2027 = f.my_piecewise3(t410, 0, 0.4e1 / 0.9e1 * t852 * t1667 * t412 + 0.2e1 / 0.3e1 * t474 * t174 * t126)
  t2029 = t187 * t189 * t2027
  t2033 = 0.62182e-1 * (t846 - 0.17808333333333333333333333333333333333333333333333e-1 * t848 - 0.17808333333333333333333333333333333333333333333333e-1 * t2018 + 0.53425000000000000000000000000000000000000000000000e-1 * t2029) * t434
  t2034 = t1676 * t485
  t2036 = 0.10000000000000000000000000000000000000000000000000e1 * t2034 * t506
  t2038 = 0.10000000000000000000000000000000000000000000000000e1 * t866 * t1690
  t2041 = 0.20000000000000000000000000000000000000000000000000e1 * t871 * t1690 * t504
  t2043 = t877 * t1679 * t489
  t2047 = t881 - t848 / 0.3e1 - t2018 / 0.3e1 + t2029
  t2048 = t487 * t2047
  t2054 = t889 * t1679 * t489
  t2056 = t494 * t2047
  t2060 = t206 * t295 * t1685
  t2064 = t206 * t208 * t477 * t1672
  t2068 = t206 * t208 * t416 * t2027
  t2070 = -0.94946250000000000000000000000000000000000000000000e0 * t2043 + 0.18989250000000000000000000000000000000000000000000e1 * t2048 + t886 - 0.29896666666666666666666666666666666666666666666667e0 * t848 - 0.29896666666666666666666666666666666666666666666667e0 * t2018 + 0.89690000000000000000000000000000000000000000000000e0 * t2029 + 0.15358125000000000000000000000000000000000000000000e0 * t2054 + 0.30716250000000000000000000000000000000000000000000e0 * t2056 + t897 - 0.16431333333333333333333333333333333333333333333333e0 * t899 - 0.16431333333333333333333333333333333333333333333333e0 * t2060 + 0.24647000000000000000000000000000000000000000000000e0 * t2064 + 0.24647000000000000000000000000000000000000000000000e0 * t2068
  t2073 = 0.10000000000000000000000000000000000000000000000000e1 * t486 * t2070 * t505
  t2077 = 0.16081824322151104821330931780901225435013347914188e2 * t915 * t1689 * t917 * t504
  t2084 = t1694 * t515
  t2103 = -0.17648625000000000000000000000000000000000000000000e1 * t2043 + 0.35297250000000000000000000000000000000000000000000e1 * t2048 + t939 - 0.51647500000000000000000000000000000000000000000000e0 * t848 - 0.51647500000000000000000000000000000000000000000000e0 * t2018 + 0.15494250000000000000000000000000000000000000000000e1 * t2029 + 0.31558125000000000000000000000000000000000000000000e0 * t2054 + 0.63116250000000000000000000000000000000000000000000e0 * t2056 + t944 - 0.20839000000000000000000000000000000000000000000000e0 * t899 - 0.20839000000000000000000000000000000000000000000000e0 * t2060 + 0.31258500000000000000000000000000000000000000000000e0 * t2064 + 0.31258500000000000000000000000000000000000000000000e0 * t2068
  t2115 = (t960 - 0.92708333333333333333333333333333333333333333333333e-2 * t848 - 0.92708333333333333333333333333333333333333333333333e-2 * t2018 + 0.27812500000000000000000000000000000000000000000000e-1 * t2029) * t460
  t2117 = t1706 * t534
  t2136 = -0.12946250000000000000000000000000000000000000000000e1 * t2043 + 0.25892500000000000000000000000000000000000000000000e1 * t2048 + t978 - 0.30192500000000000000000000000000000000000000000000e0 * t848 - 0.30192500000000000000000000000000000000000000000000e0 * t2018 + 0.90577500000000000000000000000000000000000000000000e0 * t2029 + 0.82524375000000000000000000000000000000000000000000e-1 * t2054 + 0.16504875000000000000000000000000000000000000000000e0 * t2056 + t983 - 0.16557000000000000000000000000000000000000000000000e0 * t899 - 0.16557000000000000000000000000000000000000000000000e0 * t2060 + 0.24835500000000000000000000000000000000000000000000e0 * t2064 + 0.24835500000000000000000000000000000000000000000000e0 * t2068
  t2144 = -0.31090e-1 * (t921 - 0.17123333333333333333333333333333333333333333333333e-1 * t848 - 0.17123333333333333333333333333333333333333333333333e-1 * t2018 + 0.51370000000000000000000000000000000000000000000000e-1 * t2029) * t447 + 0.99999999999999999999999999999999999999999999999999e0 * t2084 * t525 + 0.99999999999999999999999999999999999999999999999999e0 * t927 * t1702 - 0.20000000000000000000000000000000000000000000000000e1 * t932 * t1702 * t523 + 0.99999999999999999999999999999999999999999999999999e0 * t516 * t2103 * t524 + 0.32164683177870697973624959794146027661627532968800e2 * t954 * t1701 * t956 * t523 + t2033 - t2036 - t2038 + t2041 - t2073 - t2077 - 0.19751789702565206228825776161588751761046270558698e-1 * t2115 + 0.58482233974552040708313425006184496242808878304903e0 * t2117 * t544 + 0.58482233974552040708313425006184496242808878304903e0 * t966 * t1714 - 0.11696446794910408141662685001236899248561775660981e1 * t971 * t1714 * t542 + 0.58482233974552040708313425006184496242808878304903e0 * t535 * t2136 * t543 + 0.17315755899375863299672358916972966258900005419821e2 * t993 * t1713 * t995 * t542
  t2148 = t229 * t1706
  t2166 = -t2033 + t2036 + t2038 - t2041 + t2073 + t2077 + t229 * t2144 + 0.19751789702565206228825776161588751761046270558698e-1 * t229 * t2115 - 0.58482233974552040708313425006184496242808878304903e0 * t2148 * t553 - 0.58482233974552040708313425006184496242808878304903e0 * t1003 * t1722 + 0.11696446794910408141662685001236899248561775660981e1 * t551 * t970 * t1713 * t544 - 0.58482233974552040708313425006184496242808878304903e0 * t551 * t534 * t2136 * t543 - 0.17315755899375863299672358916972966258900005419821e2 * t551 * t992 * t1713 * t995 * t542
  t2170 = f.my_piecewise3(t411, 0, t1668 * t556 / 0.2e1 + t413 * t1725 / 0.2e1 + t2012 * t467 / 0.2e1 + t469 * t2166 / 0.2e1)
  t2184 = f.my_piecewise3(t177, 0, 0.4e1 / 0.9e1 * t1036 * t1602 * t180 + 0.8e1 / 0.3e1 * t191 * t174 * t126)
  t2192 = f.my_piecewise3(t410, 0, 0.4e1 / 0.9e1 * t1046 * t1667 * t412 - 0.8e1 / 0.3e1 * t414 * t174 * t126)
  t2194 = (t2184 + t2192) * t228
  t2198 = t671 * t1764 * t712
  t2202 = t1764 * t1 * t719
  t2204 = t628 * t1765
  t2206 = t668 * t1765
  t2209 = t1764 * t649 * t724
  t2211 = t671 * t2194 * t661 + t2198 - t779 + t785 - 0.18311555036753159941307229983139571945136646663793e-3 * t787 + t795 - t803 - t832 - 0.58482233974552040708313425006184496242808878304903e0 * t834 - 0.18311555036753159941307229983139571945136646663793e-3 * t2202 - t2005 + 0.4e1 * t2204 - 0.4e1 * t2206 - 0.58482233974552040708313425006184496242808878304903e0 * t2209
  t2216 = -t2170 - 0.4e1 * t1025 - t1028 + t1030 - 0.4e1 * t1033 - t1059 + 0.19751789702565206228825776161588751761046270558698e-1 * t2194 * t659 + t1247 - t1250 + t1331 - t1292 + t1302 + t1310 + t1335
  t2229 = t1381 * t1384 * t91
  t2244 = -t1844 / 0.8e1 + t2005 * t369 * t376 + t1664 * t398 * t376 + t1665 * t405 / 0.8e1 + t2170 * t570 * t577 + t560 * t1748 * t577 + t571 * t1754 / 0.8e1 + (t2211 + t2216) * t741 + t1769 * t768 + t727 * t1779 + t750 * (0.14429501851851851851851851851851851851851851851852e-2 * t1578 * t1381 * t1384 * t755 * t730 * t91 - 0.28281823629629629629629629629629629629629629629630e-4 * t1513 * t1578 * t2229 + 0.29024938271604938271604938271604938271604938271606e-2 * t91 * t1381 * t1518 * t1578 - 0.28444439506172839506172839506172839506172839506173e-3 * t1521 * t1578 * t2229 + 0.44600881145679012345679012345679012345679012345681e-5 * t1529 * t1578 * t2229)
  t2247 = t769 - 0.3e1 / 0.8e1 * t1553 - 0.3e1 / 0.8e1 * t1567 - 0.3e1 / 0.8e1 * t1600 + t1666 + t1731 + t1750 + t1755 / 0.8e1 + t1770 + t1780 + t5 * (t1842 + t2244)
  d12 = -0.3e1 / 0.8e1 * t67 - t80 - 0.3e1 / 0.8e1 * t113 - 0.3e1 / 0.8e1 * t163 - t172 + t377 + t400 + t406 / 0.8e1 + t578 + t742 + t2247
  t2259 = t123 ** 2
  t2267 = (0.40e2 / 0.9e1 * tau1 * t1573 - 0.11e2 / 0.9e1 * s2 / t136 / t2259 - 0.10e2 / 0.9e1 * l1 * t1573) * t46
  t2270 = t1578 ** 2
  t2271 = t2270 * t1381
  t2279 = t2271 * t1384
  t2282 = t2267 * t51
  t2293 = t151 ** 2
  t2326 = t1602 ** 2
  t2330 = 0.2e1 * t17 + 0.2e1 * t836
  t2334 = f.my_piecewise3(t177, 0, 0.4e1 / 0.9e1 * t1036 * t2326 + 0.4e1 / 0.3e1 * t191 * t2330)
  t2335 = t1667 ** 2
  t2338 = -t2330
  t2342 = f.my_piecewise3(t410, 0, 0.4e1 / 0.9e1 * t1046 * t2335 + 0.4e1 / 0.3e1 * t414 * t2338)
  t2344 = (t2334 + t2342) * t228
  t2348 = f.my_piecewise3(t177, 0, t2330)
  t2358 = f.my_piecewise3(t177, 0, 0.4e1 / 0.9e1 * t1072 * t2326 - t270 * t2330 / 0.3e1)
  t2360 = t187 * t189 * t2358
  t2364 = 0.62182e-1 * (t1066 - 0.35616666666666666666666666666666666666666666666666e-1 * t1853 + 0.53425000000000000000000000000000000000000000000000e-1 * t2360) * t217
  t2366 = 0.20000000000000000000000000000000000000000000000000e1 * t1869 * t1625
  t2367 = t1624 ** 2
  t2370 = 0.20000000000000000000000000000000000000000000000000e1 * t1090 * t2367 * t304
  t2371 = t1614 ** 2
  t2372 = t1096 * t2371
  t2375 = t1100 - 0.2e1 / 0.3e1 * t1853 + t2360
  t2376 = t283 * t2375
  t2380 = t1108 * t2371
  t2382 = t290 * t2375
  t2385 = t1607 ** 2
  t2387 = t206 * t208 * t2385
  t2391 = t206 * t208 * t193 * t2358
  t2393 = -0.94946250000000000000000000000000000000000000000000e0 * t2372 + 0.18989250000000000000000000000000000000000000000000e1 * t2376 + t1105 - 0.59793333333333333333333333333333333333333333333334e0 * t1853 + 0.89690000000000000000000000000000000000000000000000e0 * t2360 + 0.15358125000000000000000000000000000000000000000000e0 * t2380 + 0.30716250000000000000000000000000000000000000000000e0 * t2382 + t1115 - 0.32862666666666666666666666666666666666666666666666e0 * t1895 + 0.24647000000000000000000000000000000000000000000000e0 * t2387 + 0.24647000000000000000000000000000000000000000000000e0 * t2391
  t2396 = 0.10000000000000000000000000000000000000000000000000e1 * t282 * t2393 * t304
  t2399 = 0.16081824322151104821330931780901225435013347914188e2 * t1133 * t2367 * t1135
  t2407 = t1636 ** 2
  t2420 = -0.17648625000000000000000000000000000000000000000000e1 * t2372 + 0.35297250000000000000000000000000000000000000000000e1 * t2376 + t1157 - 0.10329500000000000000000000000000000000000000000000e1 * t1853 + 0.15494250000000000000000000000000000000000000000000e1 * t2360 + 0.31558125000000000000000000000000000000000000000000e0 * t2380 + 0.63116250000000000000000000000000000000000000000000e0 * t2382 + t1162 - 0.41678000000000000000000000000000000000000000000000e0 * t1895 + 0.31258500000000000000000000000000000000000000000000e0 * t2387 + 0.31258500000000000000000000000000000000000000000000e0 * t2391
  t2430 = (t1178 - 0.18541666666666666666666666666666666666666666666667e-1 * t1853 + 0.27812500000000000000000000000000000000000000000000e-1 * t2360) * t253
  t2434 = t1648 ** 2
  t2447 = -0.12946250000000000000000000000000000000000000000000e1 * t2372 + 0.25892500000000000000000000000000000000000000000000e1 * t2376 + t1196 - 0.60385000000000000000000000000000000000000000000000e0 * t1853 + 0.90577500000000000000000000000000000000000000000000e0 * t2360 + 0.82524375000000000000000000000000000000000000000000e-1 * t2380 + 0.16504875000000000000000000000000000000000000000000e0 * t2382 + t1201 - 0.33114000000000000000000000000000000000000000000000e0 * t1895 + 0.24835500000000000000000000000000000000000000000000e0 * t2387 + 0.24835500000000000000000000000000000000000000000000e0 * t2391
  t2454 = -0.31090e-1 * (t1139 - 0.34246666666666666666666666666666666666666666666666e-1 * t1853 + 0.51370000000000000000000000000000000000000000000000e-1 * t2360) * t240 + 0.20000000000000000000000000000000000000000000000000e1 * t1919 * t1637 - 0.20000000000000000000000000000000000000000000000000e1 * t1150 * t2407 * t323 + 0.99999999999999999999999999999999999999999999999999e0 * t315 * t2420 * t323 + 0.32164683177870697973624959794146027661627532968800e2 * t1172 * t2407 * t1174 + t2364 - t2366 + t2370 - t2396 - t2399 - 0.19751789702565206228825776161588751761046270558698e-1 * t2430 + 0.11696446794910408141662685001236899248561775660981e1 * t1952 * t1649 - 0.11696446794910408141662685001236899248561775660981e1 * t1189 * t2434 * t342 + 0.58482233974552040708313425006184496242808878304903e0 * t334 * t2447 * t342 + 0.17315755899375863299672358916972966258900005419821e2 * t1211 * t2434 * t1213
  t2472 = -t2364 + t2366 - t2370 + t2396 + t2399 + t229 * t2454 + 0.19751789702565206228825776161588751761046270558698e-1 * t229 * t2430 - 0.11696446794910408141662685001236899248561775660981e1 * t1983 * t1657 + 0.11696446794910408141662685001236899248561775660981e1 * t350 * t1188 * t2434 * t342 - 0.58482233974552040708313425006184496242808878304903e0 * t350 * t333 * t2447 * t342 - 0.17315755899375863299672358916972966258900005419821e2 * t350 * t1210 * t2434 * t1213
  t2476 = f.my_piecewise3(t178, 0, t2348 * t260 / 0.2e1 + t1603 * t1660 + t262 * t2472 / 0.2e1)
  t2478 = f.my_piecewise3(t410, 0, t2338)
  t2488 = f.my_piecewise3(t410, 0, 0.4e1 / 0.9e1 * t852 * t2335 - t474 * t2338 / 0.3e1)
  t2490 = t187 * t189 * t2488
  t2494 = 0.62182e-1 * (t846 - 0.35616666666666666666666666666666666666666666666666e-1 * t2018 + 0.53425000000000000000000000000000000000000000000000e-1 * t2490) * t434
  t2496 = 0.20000000000000000000000000000000000000000000000000e1 * t2034 * t1690
  t2497 = t1689 ** 2
  t2500 = 0.20000000000000000000000000000000000000000000000000e1 * t871 * t2497 * t505
  t2501 = t1679 ** 2
  t2502 = t877 * t2501
  t2505 = t881 - 0.2e1 / 0.3e1 * t2018 + t2490
  t2506 = t487 * t2505
  t2510 = t889 * t2501
  t2512 = t494 * t2505
  t2515 = t1672 ** 2
  t2517 = t206 * t208 * t2515
  t2521 = t206 * t208 * t416 * t2488
  t2523 = -0.94946250000000000000000000000000000000000000000000e0 * t2502 + 0.18989250000000000000000000000000000000000000000000e1 * t2506 + t886 - 0.59793333333333333333333333333333333333333333333334e0 * t2018 + 0.89690000000000000000000000000000000000000000000000e0 * t2490 + 0.15358125000000000000000000000000000000000000000000e0 * t2510 + 0.30716250000000000000000000000000000000000000000000e0 * t2512 + t897 - 0.32862666666666666666666666666666666666666666666666e0 * t2060 + 0.24647000000000000000000000000000000000000000000000e0 * t2517 + 0.24647000000000000000000000000000000000000000000000e0 * t2521
  t2526 = 0.10000000000000000000000000000000000000000000000000e1 * t486 * t2523 * t505
  t2529 = 0.16081824322151104821330931780901225435013347914188e2 * t915 * t2497 * t917
  t2537 = t1701 ** 2
  t2550 = -0.17648625000000000000000000000000000000000000000000e1 * t2502 + 0.35297250000000000000000000000000000000000000000000e1 * t2506 + t939 - 0.10329500000000000000000000000000000000000000000000e1 * t2018 + 0.15494250000000000000000000000000000000000000000000e1 * t2490 + 0.31558125000000000000000000000000000000000000000000e0 * t2510 + 0.63116250000000000000000000000000000000000000000000e0 * t2512 + t944 - 0.41678000000000000000000000000000000000000000000000e0 * t2060 + 0.31258500000000000000000000000000000000000000000000e0 * t2517 + 0.31258500000000000000000000000000000000000000000000e0 * t2521
  t2560 = (t960 - 0.18541666666666666666666666666666666666666666666667e-1 * t2018 + 0.27812500000000000000000000000000000000000000000000e-1 * t2490) * t460
  t2564 = t1713 ** 2
  t2577 = -0.12946250000000000000000000000000000000000000000000e1 * t2502 + 0.25892500000000000000000000000000000000000000000000e1 * t2506 + t978 - 0.60385000000000000000000000000000000000000000000000e0 * t2018 + 0.90577500000000000000000000000000000000000000000000e0 * t2490 + 0.82524375000000000000000000000000000000000000000000e-1 * t2510 + 0.16504875000000000000000000000000000000000000000000e0 * t2512 + t983 - 0.33114000000000000000000000000000000000000000000000e0 * t2060 + 0.24835500000000000000000000000000000000000000000000e0 * t2517 + 0.24835500000000000000000000000000000000000000000000e0 * t2521
  t2584 = -0.31090e-1 * (t921 - 0.34246666666666666666666666666666666666666666666666e-1 * t2018 + 0.51370000000000000000000000000000000000000000000000e-1 * t2490) * t447 + 0.20000000000000000000000000000000000000000000000000e1 * t2084 * t1702 - 0.20000000000000000000000000000000000000000000000000e1 * t932 * t2537 * t524 + 0.99999999999999999999999999999999999999999999999999e0 * t516 * t2550 * t524 + 0.32164683177870697973624959794146027661627532968800e2 * t954 * t2537 * t956 + t2494 - t2496 + t2500 - t2526 - t2529 - 0.19751789702565206228825776161588751761046270558698e-1 * t2560 + 0.11696446794910408141662685001236899248561775660981e1 * t2117 * t1714 - 0.11696446794910408141662685001236899248561775660981e1 * t971 * t2564 * t543 + 0.58482233974552040708313425006184496242808878304903e0 * t535 * t2577 * t543 + 0.17315755899375863299672358916972966258900005419821e2 * t993 * t2564 * t995
  t2602 = -t2494 + t2496 - t2500 + t2526 + t2529 + t229 * t2584 + 0.19751789702565206228825776161588751761046270558698e-1 * t229 * t2560 - 0.11696446794910408141662685001236899248561775660981e1 * t2148 * t1722 + 0.11696446794910408141662685001236899248561775660981e1 * t551 * t970 * t2564 * t543 - 0.58482233974552040708313425006184496242808878304903e0 * t551 * t534 * t2577 * t543 - 0.17315755899375863299672358916972966258900005419821e2 * t551 * t992 * t2564 * t995
  t2606 = f.my_piecewise3(t411, 0, t2478 * t467 / 0.2e1 + t1668 * t1725 + t469 * t2602 / 0.2e1)
  t2610 = t671 * t2344 * t661 + 0.2e1 * t2198 - t2476 - t779 + t785 + t795 - t803 - t832 - 0.36623110073506319882614459966279143890273293327586e-3 * t2202 - t2606 + 0.19751789702565206228825776161588751761046270558698e-1 * t2344 * t659 - 0.8e1 * t2204
  t2613 = -0.8e1 * t2206 - 0.11696446794910408141662685001236899248561775660981e1 * t2209 - t1024 - t1028 - t1059 + t1247 + t1250 + t1253 + t1331 - t1292 + t1302 + t1310 + t1335
  t2669 = f.my_piecewise3(t9, 0, t1426 + 0.8e1 / 0.3e1 * t1786 - 0.4e1 / 0.9e1 * t10 * t84 * t667 * t1432)
  t2680 = t1559 ** 2
  t2690 = f.my_piecewise3(t117, 0, -0.4e1 * t1807 + 0.4e1 / 0.3e1 * t11 * t128 * t1559 + t1347 - 0.4e1 / 0.3e1 * t1816 - 0.4e1 / 0.9e1 * t118 * t6 * t1354 * t2680 + 0.2e1 / 0.3e1 * t118 * t1557 * (-0.2e1 * t17 + 0.2e1 * t1822))
  t2702 = t749 * (0.85404444444444444444444444444444444444444444444445e0 * t2267 * t1732 + 0.36439229629629629629629629629629629629629629629629e1 * t2271 * t1384 * t1736 * t150 - 0.93284427851851851851851851851851851851851851851847e1 * t1592 / t563 / t1743 * t2279 - 0.21863537777777777777777777777777777777777777777777e1 * t1737 * t2282 + 0.14258567901234567901234567901234567901234567901234e1 * t2271 * t1384 * t567 - 0.18250966913580246913580246913580246913580246913580e2 * t151 * t1744 * t2279 - 0.25665422222222222222222222222222222222222222222222e1 * t1740 * t2282 + 0.37377980239012345679012345679012345679012345679011e2 * t2293 / t1743 / t562 * t2279 + 0.65703480888888888888888888888888888888888888888888e1 * t1745 * t2282) * t577 + t750 * (0.88343888888888888888888888888888888888888888888889e-1 * t2267 * t751 + 0.14429501851851851851851851851851851851851851851852e-2 * t2271 * t1508 - 0.28281823629629629629629629629629629629629629629630e-4 * t1513 * t2279 - 0.17315402222222222222222222222222222222222222222222e-2 * t756 * t2282 + 0.29024938271604938271604938271604938271604938271606e-2 * t2271 * t1518 - 0.28444439506172839506172839506172839506172839506173e-3 * t1521 * t2279 - 0.10448977777777777777777777777777777777777777777778e-1 * t759 * t2282 + 0.44600881145679012345679012345679012345679012345681e-5 * t1529 * t2279 + 0.20479996444444444444444444444444444444444444444445e-3 * t765 * t2282) + 0.2e1 * t1769 * t1779 + (t2610 + t2613) * t741 + 0.2e1 * t1729 * t1748 * t577 + t2606 * t570 * t577 + t2476 * t369 * t376 - t1800 / 0.4e1 + t1460 - t1836 / 0.4e1 + t1468 + t1730 * t1754 / 0.4e1 - 0.3e1 / 0.4e1 * t4 * t1565 * t1598 - t1844 / 0.4e1 - 0.3e1 / 0.8e1 * t4 * t1569 * (-0.40834444444444444444444444444444444444444444444444e-1 * t2267 * t1580 - 0.82349462962962962962962962962962962962962962962960e-3 * t2271 * t1384 * t1584 * t150 + 0.99642850185185185185185185185185185185185185185178e-5 * t1592 / t154 / t1593 * t2279 + 0.49409677777777777777777777777777777777777777777776e-3 * t1585 * t2282 + 0.10606172839506172839506172839506172839506172839506e-2 * t2271 * t1384 * t158 - 0.64167345679012345679012345679012345679012345679011e-4 * t151 * t1594 * t2279 - 0.19091111111111111111111111111111111111111111111111e-2 * t1589 * t2282 + 0.62113990617283950617283950617283950617283950617281e-6 * t2293 / t1593 / t153 * t2279 + 0.23100244444444444444444444444444444444444444444444e-4 * t1595 * t2282) - 0.3e1 / 0.8e1 * t4 * t2669 * t31 * t65 - 0.3e1 / 0.8e1 * t4 * t2690 * t31 * t161 - t1751 * s2 / t1351 * t574 / 0.4e1 + t1749 * t1754 / 0.4e1
  d22 = -0.3e1 / 0.4e1 * t1553 - t80 - 0.3e1 / 0.4e1 * t1567 - t172 - 0.3e1 / 0.4e1 * t1600 + 0.2e1 * t1666 + 0.2e1 * t1731 + 0.2e1 * t1750 + t1755 / 0.4e1 + 0.2e1 * t1770 + 0.2e1 * t1780 + t5 * t2702
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = 3 ** (0.1e1 / 0.3e1)
  t2 = 0.1e1 / jnp.pi
  t3 = t2 ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t7 = t4 * t6
  t8 = r0 + r1
  t9 = t8 ** (0.1e1 / 0.3e1)
  t11 = 0.1e1 / t9 / t8
  t12 = 0.1e1 / t9
  t14 = t4 * t6 * t12
  t15 = jnp.sqrt(t14)
  t18 = t14 ** 0.15e1
  t20 = t1 ** 2
  t21 = t3 ** 2
  t22 = t20 * t21
  t23 = t9 ** 2
  t24 = 0.1e1 / t23
  t26 = t22 * t5 * t24
  t28 = 0.37978500000000000000000000000000000000000000000000e1 * t15 + 0.89690000000000000000000000000000000000000000000000e0 * t14 + 0.20477500000000000000000000000000000000000000000000e0 * t18 + 0.12323500000000000000000000000000000000000000000000e0 * t26
  t29 = t28 ** 2
  t30 = 0.1e1 / t29
  t31 = t11 * t30
  t33 = 0.1e1 / t15 * t1
  t34 = t3 * t6
  t35 = t34 * t11
  t36 = t33 * t35
  t38 = t6 * t11
  t39 = t4 * t38
  t41 = t14 ** 0.5e0
  t42 = t41 * t1
  t43 = t42 * t35
  t46 = 0.1e1 / t23 / t8
  t48 = t22 * t5 * t46
  t50 = -0.63297500000000000000000000000000000000000000000000e0 * t36 - 0.29896666666666666666666666666666666666666666666667e0 * t39 - 0.10238750000000000000000000000000000000000000000000e0 * t43 - 0.82156666666666666666666666666666666666666666666667e-1 * t48
  t53 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t28
  t54 = 0.1e1 / t53
  t55 = t50 * t54
  t58 = 0.35616666666666666666666666666666666666666666666666e-1 * t7 * t31 * t55
  t59 = r0 - r1
  t60 = 0.1e1 / t8
  t61 = t59 * t60
  t62 = 0.1e1 + t61
  t63 = t62 <= f.p.zeta_threshold
  t64 = f.p.zeta_threshold ** (0.1e1 / 0.3e1)
  t65 = t64 * f.p.zeta_threshold
  t66 = t62 ** (0.1e1 / 0.3e1)
  t67 = t66 * t62
  t68 = f.my_piecewise3(t63, t65, t67)
  t69 = 0.1e1 - t61
  t70 = t69 <= f.p.zeta_threshold
  t71 = t69 ** (0.1e1 / 0.3e1)
  t72 = t71 * t69
  t73 = f.my_piecewise3(t70, t65, t72)
  t75 = 2 ** (0.1e1 / 0.3e1)
  t78 = 0.1e1 / (0.2e1 * t75 - 0.2e1)
  t79 = (t68 + t73 - 0.2e1) * t78
  t80 = t79 * t1
  t81 = t8 ** 2
  t83 = 0.1e1 / t9 / t81
  t88 = 0.51785000000000000000000000000000000000000000000000e1 * t15 + 0.90577500000000000000000000000000000000000000000000e0 * t14 + 0.11003250000000000000000000000000000000000000000000e0 * t18 + 0.12417750000000000000000000000000000000000000000000e0 * t26
  t91 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t88
  t92 = jnp.log(t91)
  t94 = t34 * t83 * t92
  t97 = 0.1e1 / t81
  t99 = -t59 * t97 + t60
  t102 = f.my_piecewise3(t63, 0, 0.4e1 / 0.3e1 * t66 * t99)
  t103 = -t99
  t106 = f.my_piecewise3(t70, 0, 0.4e1 / 0.3e1 * t71 * t103)
  t108 = (t102 + t106) * t78
  t109 = t108 * t1
  t111 = t34 * t11 * t92
  t114 = t59 ** 2
  t115 = t114 * t59
  t116 = t81 ** 2
  t117 = 0.1e1 / t116
  t118 = t115 * t117
  t123 = 0.70594500000000000000000000000000000000000000000000e1 * t15 + 0.15494250000000000000000000000000000000000000000000e1 * t14 + 0.42077500000000000000000000000000000000000000000000e0 * t18 + 0.15629250000000000000000000000000000000000000000000e0 * t26
  t126 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t123
  t127 = jnp.log(t126)
  t132 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t14
  t133 = t123 ** 2
  t134 = 0.1e1 / t133
  t135 = t132 * t134
  t140 = -0.11765750000000000000000000000000000000000000000000e1 * t36 - 0.51647500000000000000000000000000000000000000000000e0 * t39 - 0.21038750000000000000000000000000000000000000000000e0 * t43 - 0.10419500000000000000000000000000000000000000000000e0 * t48
  t141 = 0.1e1 / t126
  t142 = t140 * t141
  t145 = jnp.log(t53)
  t148 = 0.11073577833333333333333333333333333333333333333333e-2 * t4 * t38 * t145
  t150 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t14
  t151 = t150 * t30
  t153 = 0.10000000000000000000000000000000000000000000000000e1 * t151 * t55
  t158 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t14
  t159 = t88 ** 2
  t160 = 0.1e1 / t159
  t161 = t158 * t160
  t166 = -0.86308333333333333333333333333333333333333333333334e0 * t36 - 0.30192500000000000000000000000000000000000000000000e0 * t39 - 0.55016250000000000000000000000000000000000000000000e-1 * t43 - 0.82785000000000000000000000000000000000000000000000e-1 * t48
  t167 = 0.1e1 / t91
  t168 = t166 * t167
  t171 = 0.53236443333333333333333333333333333333333333333332e-3 * t4 * t38 * t127 + 0.99999999999999999999999999999999999999999999999999e0 * t135 * t142 - t148 - t153 + 0.18311555036753159941307229983139571945136646663793e-3 * t4 * t38 * t92 + 0.58482233974552040708313425006184496242808878304903e0 * t161 * t168
  t172 = t79 * t171
  t175 = t114 ** 2
  t177 = 0.1e1 / t116 / t81
  t178 = t175 * t177
  t182 = 0.62182e-1 * t150 * t145
  t183 = t158 * t92
  t185 = -0.31090e-1 * t132 * t127 + t182 - 0.19751789702565206228825776161588751761046270558698e-1 * t183
  t186 = t79 * t185
  t189 = t114 * t117
  t193 = 0.1e1 / t116 / t8
  t194 = t115 * t193
  t197 = t79 * t4
  t199 = t160 * t166 * t167
  t200 = t38 * t199
  t203 = t66 ** 2
  t204 = 0.1e1 / t203
  t205 = t99 ** 2
  t208 = t81 * t8
  t209 = 0.1e1 / t208
  t212 = 0.2e1 * t59 * t209 - 0.2e1 * t97
  t216 = f.my_piecewise3(t63, 0, 0.4e1 / 0.9e1 * t204 * t205 + 0.4e1 / 0.3e1 * t66 * t212)
  t217 = t71 ** 2
  t218 = 0.1e1 / t217
  t219 = t103 ** 2
  t222 = -t212
  t226 = f.my_piecewise3(t70, 0, 0.4e1 / 0.9e1 * t218 * t219 + 0.4e1 / 0.3e1 * t71 * t222)
  t228 = (t216 + t226) * t78
  t231 = t108 * t185
  t234 = t175 * t193
  t237 = t175 * t117
  t238 = t108 * t171
  t241 = -t58 + 0.24415406715670879921742973310852762593515528885057e-3 * t80 * t94 - 0.36623110073506319882614459966279143890273293327586e-3 * t109 * t111 + 0.8e1 * t118 * t172 + 0.20e2 * t178 * t186 + 0.12e2 * t189 * t186 - 0.32e2 * t194 * t186 + 0.10843580882781524214666447553230042011687479519034e-1 * t197 * t200 + 0.19751789702565206228825776161588751761046270558698e-1 * t228 * t183 + 0.8e1 * t118 * t231 - 0.8e1 * t234 * t172 + 0.2e1 * t237 * t238
  t242 = t228 * t185
  t246 = t79 * t158
  t247 = t159 ** 2
  t248 = 0.1e1 / t247
  t249 = t166 ** 2
  t251 = t91 ** 2
  t252 = 0.1e1 / t251
  t253 = t248 * t249 * t252
  t258 = 0.1e1 / t15 / t14 * t20
  t259 = t21 * t5
  t261 = 0.1e1 / t23 / t81
  t262 = t259 * t261
  t263 = t258 * t262
  t265 = t34 * t83
  t266 = t33 * t265
  t268 = t6 * t83
  t269 = t4 * t268
  t271 = t14 ** (-0.5e0)
  t272 = t271 * t20
  t273 = t272 * t262
  t275 = t42 * t265
  t278 = t22 * t5 * t261
  t280 = -0.57538888888888888888888888888888888888888888888889e0 * t263 + 0.11507777777777777777777777777777777777777777777778e1 * t266 + 0.40256666666666666666666666666666666666666666666667e0 * t269 + 0.36677500000000000000000000000000000000000000000000e-1 * t273 + 0.73355000000000000000000000000000000000000000000000e-1 * t275 + 0.13797500000000000000000000000000000000000000000000e0 * t278
  t282 = t160 * t280 * t167
  t285 = t108 * t158
  t290 = 0.14764770444444444444444444444444444444444444444444e-2 * t4 * t268 * t145
  t292 = 0.1e1 / t159 / t88
  t294 = t292 * t249 * t167
  t298 = r1 <= f.p.dens_threshold or t70
  t299 = f.my_piecewise3(t70, 0, t222)
  t300 = t12 * t75
  t301 = 0.1e1 / t64
  t303 = f.my_piecewise3(t70, t301, 0.1e1 / t71)
  t305 = t7 * t300 * t303
  t307 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t305
  t308 = jnp.sqrt(t305)
  t311 = t305 ** 0.15e1
  t313 = t22 * t5
  t314 = t75 ** 2
  t315 = t24 * t314
  t316 = t303 ** 2
  t318 = t313 * t315 * t316
  t320 = 0.37978500000000000000000000000000000000000000000000e1 * t308 + 0.89690000000000000000000000000000000000000000000000e0 * t305 + 0.20477500000000000000000000000000000000000000000000e0 * t311 + 0.12323500000000000000000000000000000000000000000000e0 * t318
  t323 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t320
  t324 = jnp.log(t323)
  t326 = 0.62182e-1 * t307 * t324
  t329 = f.my_piecewise3(0.2e1 <= f.p.zeta_threshold, t65, 0.2e1 * t75)
  t331 = f.my_piecewise3(0.0e0 <= f.p.zeta_threshold, t65, 0)
  t333 = (t329 + t331 - 0.2e1) * t78
  t335 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t305
  t340 = 0.70594500000000000000000000000000000000000000000000e1 * t308 + 0.15494250000000000000000000000000000000000000000000e1 * t305 + 0.42077500000000000000000000000000000000000000000000e0 * t311 + 0.15629250000000000000000000000000000000000000000000e0 * t318
  t343 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t340
  t344 = jnp.log(t343)
  t348 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t305
  t353 = 0.51785000000000000000000000000000000000000000000000e1 * t308 + 0.90577500000000000000000000000000000000000000000000e0 * t305 + 0.11003250000000000000000000000000000000000000000000e0 * t311 + 0.12417750000000000000000000000000000000000000000000e0 * t318
  t356 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t353
  t357 = jnp.log(t356)
  t358 = t348 * t357
  t364 = -t326 + t333 * (-0.31090e-1 * t335 * t344 + t326 - 0.19751789702565206228825776161588751761046270558698e-1 * t358) + 0.19751789702565206228825776161588751761046270558698e-1 * t333 * t358
  t367 = f.my_piecewise3(t70, 0, t103)
  t368 = t11 * t75
  t370 = t7 * t368 * t303
  t372 = 0.1e1 / t72
  t375 = f.my_piecewise3(t70, 0, -t372 * t103 / 0.3e1)
  t377 = t7 * t300 * t375
  t379 = -0.17808333333333333333333333333333333333333333333333e-1 * t370 + 0.53425000000000000000000000000000000000000000000000e-1 * t377
  t381 = 0.62182e-1 * t379 * t324
  t382 = t320 ** 2
  t383 = 0.1e1 / t382
  t384 = t307 * t383
  t385 = 0.1e1 / t308
  t387 = -t370 / 0.3e1 + t377
  t388 = t385 * t387
  t392 = t305 ** 0.5e0
  t393 = t392 * t387
  t395 = t46 * t314
  t397 = t313 * t395 * t316
  t399 = t303 * t375
  t401 = t313 * t315 * t399
  t403 = 0.18989250000000000000000000000000000000000000000000e1 * t388 - 0.29896666666666666666666666666666666666666666666667e0 * t370 + 0.89690000000000000000000000000000000000000000000000e0 * t377 + 0.30716250000000000000000000000000000000000000000000e0 * t393 - 0.82156666666666666666666666666666666666666666666667e-1 * t397 + 0.24647000000000000000000000000000000000000000000000e0 * t401
  t404 = 0.1e1 / t323
  t405 = t403 * t404
  t407 = 0.10000000000000000000000000000000000000000000000000e1 * t384 * t405
  t410 = -0.17123333333333333333333333333333333333333333333333e-1 * t370 + 0.51370000000000000000000000000000000000000000000000e-1 * t377
  t413 = t340 ** 2
  t414 = 0.1e1 / t413
  t415 = t335 * t414
  t422 = 0.35297250000000000000000000000000000000000000000000e1 * t388 - 0.51647500000000000000000000000000000000000000000000e0 * t370 + 0.15494250000000000000000000000000000000000000000000e1 * t377 + 0.63116250000000000000000000000000000000000000000000e0 * t393 - 0.10419500000000000000000000000000000000000000000000e0 * t397 + 0.31258500000000000000000000000000000000000000000000e0 * t401
  t423 = 0.1e1 / t343
  t424 = t422 * t423
  t429 = -0.92708333333333333333333333333333333333333333333333e-2 * t370 + 0.27812500000000000000000000000000000000000000000000e-1 * t377
  t430 = t429 * t357
  t432 = t353 ** 2
  t433 = 0.1e1 / t432
  t434 = t348 * t433
  t441 = 0.25892500000000000000000000000000000000000000000000e1 * t388 - 0.30192500000000000000000000000000000000000000000000e0 * t370 + 0.90577500000000000000000000000000000000000000000000e0 * t377 + 0.16504875000000000000000000000000000000000000000000e0 * t393 - 0.82785000000000000000000000000000000000000000000000e-1 * t397 + 0.24835500000000000000000000000000000000000000000000e0 * t401
  t442 = 0.1e1 / t356
  t443 = t441 * t442
  t450 = t333 * t348
  t452 = t433 * t441 * t442
  t455 = -t381 + t407 + t333 * (-0.31090e-1 * t410 * t344 + 0.99999999999999999999999999999999999999999999999999e0 * t415 * t424 + t381 - t407 - 0.19751789702565206228825776161588751761046270558698e-1 * t430 + 0.58482233974552040708313425006184496242808878304903e0 * t434 * t443) + 0.19751789702565206228825776161588751761046270558698e-1 * t333 * t430 - 0.58482233974552040708313425006184496242808878304903e0 * t450 * t452
  t457 = f.my_piecewise3(t70, f.p.zeta_threshold, t69)
  t458 = t83 * t75
  t460 = t7 * t458 * t303
  t463 = t7 * t368 * t375
  t465 = t69 ** 2
  t467 = 0.1e1 / t71 / t465
  t473 = f.my_piecewise3(t70, 0, 0.4e1 / 0.9e1 * t467 * t219 - t372 * t222 / 0.3e1)
  t475 = t7 * t300 * t473
  t477 = 0.23744444444444444444444444444444444444444444444444e-1 * t460 - 0.35616666666666666666666666666666666666666666666666e-1 * t463 + 0.53425000000000000000000000000000000000000000000000e-1 * t475
  t479 = 0.62182e-1 * t477 * t324
  t480 = t379 * t383
  t482 = 0.20000000000000000000000000000000000000000000000000e1 * t480 * t405
  t484 = 0.1e1 / t382 / t320
  t485 = t307 * t484
  t486 = t403 ** 2
  t487 = t486 * t404
  t489 = 0.20000000000000000000000000000000000000000000000000e1 * t485 * t487
  t491 = 0.1e1 / t308 / t305
  t492 = t387 ** 2
  t493 = t491 * t492
  t497 = 0.4e1 / 0.9e1 * t460 - 0.2e1 / 0.3e1 * t463 + t475
  t498 = t385 * t497
  t503 = t305 ** (-0.5e0)
  t504 = t503 * t492
  t506 = t392 * t497
  t508 = t261 * t314
  t510 = t313 * t508 * t316
  t513 = t313 * t395 * t399
  t515 = t375 ** 2
  t517 = t313 * t315 * t515
  t519 = t303 * t473
  t521 = t313 * t315 * t519
  t523 = -0.94946250000000000000000000000000000000000000000000e0 * t493 + 0.18989250000000000000000000000000000000000000000000e1 * t498 + 0.39862222222222222222222222222222222222222222222223e0 * t460 - 0.59793333333333333333333333333333333333333333333334e0 * t463 + 0.89690000000000000000000000000000000000000000000000e0 * t475 + 0.15358125000000000000000000000000000000000000000000e0 * t504 + 0.30716250000000000000000000000000000000000000000000e0 * t506 + 0.13692777777777777777777777777777777777777777777778e0 * t510 - 0.32862666666666666666666666666666666666666666666666e0 * t513 + 0.24647000000000000000000000000000000000000000000000e0 * t517 + 0.24647000000000000000000000000000000000000000000000e0 * t521
  t524 = t523 * t404
  t526 = 0.10000000000000000000000000000000000000000000000000e1 * t384 * t524
  t527 = t382 ** 2
  t528 = 0.1e1 / t527
  t529 = t307 * t528
  t530 = t323 ** 2
  t531 = 0.1e1 / t530
  t532 = t486 * t531
  t534 = 0.16081824322151104821330931780901225435013347914188e2 * t529 * t532
  t538 = 0.22831111111111111111111111111111111111111111111111e-1 * t460 - 0.34246666666666666666666666666666666666666666666666e-1 * t463 + 0.51370000000000000000000000000000000000000000000000e-1 * t475
  t541 = t410 * t414
  t545 = 0.1e1 / t413 / t340
  t546 = t335 * t545
  t547 = t422 ** 2
  t548 = t547 * t423
  t562 = -0.17648625000000000000000000000000000000000000000000e1 * t493 + 0.35297250000000000000000000000000000000000000000000e1 * t498 + 0.68863333333333333333333333333333333333333333333333e0 * t460 - 0.10329500000000000000000000000000000000000000000000e1 * t463 + 0.15494250000000000000000000000000000000000000000000e1 * t475 + 0.31558125000000000000000000000000000000000000000000e0 * t504 + 0.63116250000000000000000000000000000000000000000000e0 * t506 + 0.17365833333333333333333333333333333333333333333333e0 * t510 - 0.41678000000000000000000000000000000000000000000000e0 * t513 + 0.31258500000000000000000000000000000000000000000000e0 * t517 + 0.31258500000000000000000000000000000000000000000000e0 * t521
  t563 = t562 * t423
  t566 = t413 ** 2
  t567 = 0.1e1 / t566
  t568 = t335 * t567
  t569 = t343 ** 2
  t570 = 0.1e1 / t569
  t571 = t547 * t570
  t577 = 0.12361111111111111111111111111111111111111111111111e-1 * t460 - 0.18541666666666666666666666666666666666666666666667e-1 * t463 + 0.27812500000000000000000000000000000000000000000000e-1 * t475
  t578 = t577 * t357
  t580 = t429 * t433
  t584 = 0.1e1 / t432 / t353
  t585 = t348 * t584
  t586 = t441 ** 2
  t587 = t586 * t442
  t601 = -0.12946250000000000000000000000000000000000000000000e1 * t493 + 0.25892500000000000000000000000000000000000000000000e1 * t498 + 0.40256666666666666666666666666666666666666666666667e0 * t460 - 0.60385000000000000000000000000000000000000000000000e0 * t463 + 0.90577500000000000000000000000000000000000000000000e0 * t475 + 0.82524375000000000000000000000000000000000000000000e-1 * t504 + 0.16504875000000000000000000000000000000000000000000e0 * t506 + 0.13797500000000000000000000000000000000000000000000e0 * t510 - 0.33114000000000000000000000000000000000000000000000e0 * t513 + 0.24835500000000000000000000000000000000000000000000e0 * t517 + 0.24835500000000000000000000000000000000000000000000e0 * t521
  t602 = t601 * t442
  t605 = t432 ** 2
  t606 = 0.1e1 / t605
  t607 = t348 * t606
  t608 = t356 ** 2
  t609 = 0.1e1 / t608
  t610 = t586 * t609
  t613 = -0.31090e-1 * t538 * t344 + 0.20000000000000000000000000000000000000000000000000e1 * t541 * t424 - 0.20000000000000000000000000000000000000000000000000e1 * t546 * t548 + 0.99999999999999999999999999999999999999999999999999e0 * t415 * t563 + 0.32164683177870697973624959794146027661627532968800e2 * t568 * t571 + t479 - t482 + t489 - t526 - t534 - 0.19751789702565206228825776161588751761046270558698e-1 * t578 + 0.11696446794910408141662685001236899248561775660981e1 * t580 * t443 - 0.11696446794910408141662685001236899248561775660981e1 * t585 * t587 + 0.58482233974552040708313425006184496242808878304903e0 * t434 * t602 + 0.17315755899375863299672358916972966258900005419821e2 * t607 * t610
  t617 = t333 * t429
  t621 = t584 * t586 * t442
  t625 = t433 * t601 * t442
  t629 = t606 * t586 * t609
  t632 = -t479 + t482 - t489 + t526 + t534 + t333 * t613 + 0.19751789702565206228825776161588751761046270558698e-1 * t333 * t578 - 0.11696446794910408141662685001236899248561775660981e1 * t617 * t452 + 0.11696446794910408141662685001236899248561775660981e1 * t450 * t621 - 0.58482233974552040708313425006184496242808878304903e0 * t450 * t625 - 0.17315755899375863299672358916972966258900005419821e2 * t450 * t629
  t636 = f.my_piecewise3(t298, 0, t299 * t364 / 0.2e1 + t367 * t455 + t457 * t632 / 0.2e1)
  t638 = r0 <= f.p.dens_threshold or t63
  t639 = f.my_piecewise3(t63, 0, t212)
  t641 = f.my_piecewise3(t63, t301, 0.1e1 / t66)
  t643 = t7 * t300 * t641
  t645 = 0.1e1 + 0.53425000000000000000000000000000000000000000000000e-1 * t643
  t646 = jnp.sqrt(t643)
  t649 = t643 ** 0.15e1
  t651 = t641 ** 2
  t653 = t313 * t315 * t651
  t655 = 0.37978500000000000000000000000000000000000000000000e1 * t646 + 0.89690000000000000000000000000000000000000000000000e0 * t643 + 0.20477500000000000000000000000000000000000000000000e0 * t649 + 0.12323500000000000000000000000000000000000000000000e0 * t653
  t658 = 0.1e1 + 0.16081824322151104821330931780901225435013347914188e2 / t655
  t659 = jnp.log(t658)
  t661 = 0.62182e-1 * t645 * t659
  t663 = 0.1e1 + 0.51370000000000000000000000000000000000000000000000e-1 * t643
  t668 = 0.70594500000000000000000000000000000000000000000000e1 * t646 + 0.15494250000000000000000000000000000000000000000000e1 * t643 + 0.42077500000000000000000000000000000000000000000000e0 * t649 + 0.15629250000000000000000000000000000000000000000000e0 * t653
  t671 = 0.1e1 + 0.32164683177870697973624959794146027661627532968800e2 / t668
  t672 = jnp.log(t671)
  t676 = 0.1e1 + 0.27812500000000000000000000000000000000000000000000e-1 * t643
  t681 = 0.51785000000000000000000000000000000000000000000000e1 * t646 + 0.90577500000000000000000000000000000000000000000000e0 * t643 + 0.11003250000000000000000000000000000000000000000000e0 * t649 + 0.12417750000000000000000000000000000000000000000000e0 * t653
  t684 = 0.1e1 + 0.29608574643216675549239059631669331438384556167466e2 / t681
  t685 = jnp.log(t684)
  t686 = t676 * t685
  t692 = -t661 + t333 * (-0.31090e-1 * t663 * t672 + t661 - 0.19751789702565206228825776161588751761046270558698e-1 * t686) + 0.19751789702565206228825776161588751761046270558698e-1 * t333 * t686
  t695 = f.my_piecewise3(t63, 0, t99)
  t697 = t7 * t368 * t641
  t699 = 0.1e1 / t67
  t702 = f.my_piecewise3(t63, 0, -t699 * t99 / 0.3e1)
  t704 = t7 * t300 * t702
  t706 = -0.17808333333333333333333333333333333333333333333333e-1 * t697 + 0.53425000000000000000000000000000000000000000000000e-1 * t704
  t708 = 0.62182e-1 * t706 * t659
  t709 = t655 ** 2
  t710 = 0.1e1 / t709
  t711 = t645 * t710
  t712 = 0.1e1 / t646
  t714 = -t697 / 0.3e1 + t704
  t715 = t712 * t714
  t719 = t643 ** 0.5e0
  t720 = t719 * t714
  t723 = t313 * t395 * t651
  t725 = t641 * t702
  t727 = t313 * t315 * t725
  t729 = 0.18989250000000000000000000000000000000000000000000e1 * t715 - 0.29896666666666666666666666666666666666666666666667e0 * t697 + 0.89690000000000000000000000000000000000000000000000e0 * t704 + 0.30716250000000000000000000000000000000000000000000e0 * t720 - 0.82156666666666666666666666666666666666666666666667e-1 * t723 + 0.24647000000000000000000000000000000000000000000000e0 * t727
  t730 = 0.1e1 / t658
  t731 = t729 * t730
  t733 = 0.10000000000000000000000000000000000000000000000000e1 * t711 * t731
  t736 = -0.17123333333333333333333333333333333333333333333333e-1 * t697 + 0.51370000000000000000000000000000000000000000000000e-1 * t704
  t739 = t668 ** 2
  t740 = 0.1e1 / t739
  t741 = t663 * t740
  t748 = 0.35297250000000000000000000000000000000000000000000e1 * t715 - 0.51647500000000000000000000000000000000000000000000e0 * t697 + 0.15494250000000000000000000000000000000000000000000e1 * t704 + 0.63116250000000000000000000000000000000000000000000e0 * t720 - 0.10419500000000000000000000000000000000000000000000e0 * t723 + 0.31258500000000000000000000000000000000000000000000e0 * t727
  t749 = 0.1e1 / t671
  t750 = t748 * t749
  t755 = -0.92708333333333333333333333333333333333333333333333e-2 * t697 + 0.27812500000000000000000000000000000000000000000000e-1 * t704
  t756 = t755 * t685
  t758 = t681 ** 2
  t759 = 0.1e1 / t758
  t760 = t676 * t759
  t767 = 0.25892500000000000000000000000000000000000000000000e1 * t715 - 0.30192500000000000000000000000000000000000000000000e0 * t697 + 0.90577500000000000000000000000000000000000000000000e0 * t704 + 0.16504875000000000000000000000000000000000000000000e0 * t720 - 0.82785000000000000000000000000000000000000000000000e-1 * t723 + 0.24835500000000000000000000000000000000000000000000e0 * t727
  t768 = 0.1e1 / t684
  t769 = t767 * t768
  t776 = t333 * t676
  t778 = t759 * t767 * t768
  t781 = -t708 + t733 + t333 * (-0.31090e-1 * t736 * t672 + 0.99999999999999999999999999999999999999999999999999e0 * t741 * t750 + t708 - t733 - 0.19751789702565206228825776161588751761046270558698e-1 * t756 + 0.58482233974552040708313425006184496242808878304903e0 * t760 * t769) + 0.19751789702565206228825776161588751761046270558698e-1 * t333 * t756 - 0.58482233974552040708313425006184496242808878304903e0 * t776 * t778
  t783 = f.my_piecewise3(t63, f.p.zeta_threshold, t62)
  t785 = t7 * t458 * t641
  t788 = t7 * t368 * t702
  t790 = t62 ** 2
  t792 = 0.1e1 / t66 / t790
  t798 = f.my_piecewise3(t63, 0, 0.4e1 / 0.9e1 * t792 * t205 - t699 * t212 / 0.3e1)
  t800 = t7 * t300 * t798
  t802 = 0.23744444444444444444444444444444444444444444444444e-1 * t785 - 0.35616666666666666666666666666666666666666666666666e-1 * t788 + 0.53425000000000000000000000000000000000000000000000e-1 * t800
  t804 = 0.62182e-1 * t802 * t659
  t805 = t706 * t710
  t807 = 0.20000000000000000000000000000000000000000000000000e1 * t805 * t731
  t809 = 0.1e1 / t709 / t655
  t810 = t645 * t809
  t811 = t729 ** 2
  t812 = t811 * t730
  t814 = 0.20000000000000000000000000000000000000000000000000e1 * t810 * t812
  t816 = 0.1e1 / t646 / t643
  t817 = t714 ** 2
  t818 = t816 * t817
  t822 = 0.4e1 / 0.9e1 * t785 - 0.2e1 / 0.3e1 * t788 + t800
  t823 = t712 * t822
  t828 = t643 ** (-0.5e0)
  t829 = t828 * t817
  t831 = t719 * t822
  t834 = t313 * t508 * t651
  t837 = t313 * t395 * t725
  t839 = t702 ** 2
  t841 = t313 * t315 * t839
  t843 = t641 * t798
  t845 = t313 * t315 * t843
  t847 = -0.94946250000000000000000000000000000000000000000000e0 * t818 + 0.18989250000000000000000000000000000000000000000000e1 * t823 + 0.39862222222222222222222222222222222222222222222223e0 * t785 - 0.59793333333333333333333333333333333333333333333334e0 * t788 + 0.89690000000000000000000000000000000000000000000000e0 * t800 + 0.15358125000000000000000000000000000000000000000000e0 * t829 + 0.30716250000000000000000000000000000000000000000000e0 * t831 + 0.13692777777777777777777777777777777777777777777778e0 * t834 - 0.32862666666666666666666666666666666666666666666666e0 * t837 + 0.24647000000000000000000000000000000000000000000000e0 * t841 + 0.24647000000000000000000000000000000000000000000000e0 * t845
  t848 = t847 * t730
  t850 = 0.10000000000000000000000000000000000000000000000000e1 * t711 * t848
  t851 = t709 ** 2
  t852 = 0.1e1 / t851
  t853 = t645 * t852
  t854 = t658 ** 2
  t855 = 0.1e1 / t854
  t856 = t811 * t855
  t858 = 0.16081824322151104821330931780901225435013347914188e2 * t853 * t856
  t862 = 0.22831111111111111111111111111111111111111111111111e-1 * t785 - 0.34246666666666666666666666666666666666666666666666e-1 * t788 + 0.51370000000000000000000000000000000000000000000000e-1 * t800
  t865 = t736 * t740
  t869 = 0.1e1 / t739 / t668
  t870 = t663 * t869
  t871 = t748 ** 2
  t872 = t871 * t749
  t886 = -0.17648625000000000000000000000000000000000000000000e1 * t818 + 0.35297250000000000000000000000000000000000000000000e1 * t823 + 0.68863333333333333333333333333333333333333333333333e0 * t785 - 0.10329500000000000000000000000000000000000000000000e1 * t788 + 0.15494250000000000000000000000000000000000000000000e1 * t800 + 0.31558125000000000000000000000000000000000000000000e0 * t829 + 0.63116250000000000000000000000000000000000000000000e0 * t831 + 0.17365833333333333333333333333333333333333333333333e0 * t834 - 0.41678000000000000000000000000000000000000000000000e0 * t837 + 0.31258500000000000000000000000000000000000000000000e0 * t841 + 0.31258500000000000000000000000000000000000000000000e0 * t845
  t887 = t886 * t749
  t890 = t739 ** 2
  t891 = 0.1e1 / t890
  t892 = t663 * t891
  t893 = t671 ** 2
  t894 = 0.1e1 / t893
  t895 = t871 * t894
  t901 = 0.12361111111111111111111111111111111111111111111111e-1 * t785 - 0.18541666666666666666666666666666666666666666666667e-1 * t788 + 0.27812500000000000000000000000000000000000000000000e-1 * t800
  t902 = t901 * t685
  t904 = t755 * t759
  t908 = 0.1e1 / t758 / t681
  t909 = t676 * t908
  t910 = t767 ** 2
  t911 = t910 * t768
  t925 = -0.12946250000000000000000000000000000000000000000000e1 * t818 + 0.25892500000000000000000000000000000000000000000000e1 * t823 + 0.40256666666666666666666666666666666666666666666667e0 * t785 - 0.60385000000000000000000000000000000000000000000000e0 * t788 + 0.90577500000000000000000000000000000000000000000000e0 * t800 + 0.82524375000000000000000000000000000000000000000000e-1 * t829 + 0.16504875000000000000000000000000000000000000000000e0 * t831 + 0.13797500000000000000000000000000000000000000000000e0 * t834 - 0.33114000000000000000000000000000000000000000000000e0 * t837 + 0.24835500000000000000000000000000000000000000000000e0 * t841 + 0.24835500000000000000000000000000000000000000000000e0 * t845
  t926 = t925 * t768
  t929 = t758 ** 2
  t930 = 0.1e1 / t929
  t931 = t676 * t930
  t932 = t684 ** 2
  t933 = 0.1e1 / t932
  t934 = t910 * t933
  t937 = -0.31090e-1 * t862 * t672 + 0.20000000000000000000000000000000000000000000000000e1 * t865 * t750 - 0.20000000000000000000000000000000000000000000000000e1 * t870 * t872 + 0.99999999999999999999999999999999999999999999999999e0 * t741 * t887 + 0.32164683177870697973624959794146027661627532968800e2 * t892 * t895 + t804 - t807 + t814 - t850 - t858 - 0.19751789702565206228825776161588751761046270558698e-1 * t902 + 0.11696446794910408141662685001236899248561775660981e1 * t904 * t769 - 0.11696446794910408141662685001236899248561775660981e1 * t909 * t911 + 0.58482233974552040708313425006184496242808878304903e0 * t760 * t926 + 0.17315755899375863299672358916972966258900005419821e2 * t931 * t934
  t941 = t333 * t755
  t945 = t908 * t910 * t768
  t949 = t759 * t925 * t768
  t953 = t930 * t910 * t933
  t956 = -t804 + t807 - t814 + t850 + t858 + t333 * t937 + 0.19751789702565206228825776161588751761046270558698e-1 * t333 * t902 - 0.11696446794910408141662685001236899248561775660981e1 * t941 * t778 + 0.11696446794910408141662685001236899248561775660981e1 * t776 * t945 - 0.58482233974552040708313425006184496242808878304903e0 * t776 * t949 - 0.17315755899375863299672358916972966258900005419821e2 * t776 * t953
  t960 = f.my_piecewise3(t638, 0, t639 * t692 / 0.2e1 + t695 * t781 + t783 * t956 / 0.2e1)
  t962 = 0.1e1 / t29 / t28
  t963 = t150 * t962
  t964 = t50 ** 2
  t965 = t964 * t54
  t967 = 0.20000000000000000000000000000000000000000000000000e1 * t963 * t965
  t974 = -0.42198333333333333333333333333333333333333333333333e0 * t263 + 0.84396666666666666666666666666666666666666666666666e0 * t266 + 0.39862222222222222222222222222222222222222222222223e0 * t269 + 0.68258333333333333333333333333333333333333333333333e-1 * t273 + 0.13651666666666666666666666666666666666666666666667e0 * t275 + 0.13692777777777777777777777777777777777777777777778e0 * t278
  t975 = t974 * t54
  t977 = 0.10000000000000000000000000000000000000000000000000e1 * t151 * t975
  t978 = t29 ** 2
  t979 = 0.1e1 / t978
  t980 = t150 * t979
  t981 = t53 ** 2
  t982 = 0.1e1 / t981
  t983 = t964 * t982
  t985 = 0.16081824322151104821330931780901225435013347914188e2 * t980 * t983
  t989 = t11 * t134
  t994 = 0.1e1 / t133 / t123
  t995 = t132 * t994
  t996 = t140 ** 2
  t997 = t996 * t141
  t1006 = -0.78438333333333333333333333333333333333333333333333e0 * t263 + 0.15687666666666666666666666666666666666666666666667e1 * t266 + 0.68863333333333333333333333333333333333333333333333e0 * t269 + 0.14025833333333333333333333333333333333333333333333e0 * t273 + 0.28051666666666666666666666666666666666666666666667e0 * t275 + 0.17365833333333333333333333333333333333333333333333e0 * t278
  t1007 = t1006 * t141
  t1010 = t133 ** 2
  t1011 = 0.1e1 / t1010
  t1012 = t132 * t1011
  t1013 = t126 ** 2
  t1014 = 0.1e1 / t1013
  t1015 = t996 * t1014
  t1021 = t11 * t160
  t1025 = t158 * t292
  t1026 = t249 * t167
  t1029 = t280 * t167
  t1032 = t158 * t248
  t1033 = t249 * t252
  t1036 = -0.70981924444444444444444444444444444444444444444442e-3 * t4 * t268 * t127 - 0.34246666666666666666666666666666666666666666666666e-1 * t7 * t989 * t142 - 0.20000000000000000000000000000000000000000000000000e1 * t995 * t997 + 0.99999999999999999999999999999999999999999999999999e0 * t135 * t1007 + 0.32164683177870697973624959794146027661627532968800e2 * t1012 * t1015 + t290 + t58 + t967 - t977 - t985 - 0.24415406715670879921742973310852762593515528885057e-3 * t4 * t268 * t92 - 0.10843580882781524214666447553230042011687479519034e-1 * t7 * t1021 * t168 - 0.11696446794910408141662685001236899248561775660981e1 * t1025 * t1026 + 0.58482233974552040708313425006184496242808878304903e0 * t161 * t1029 + 0.17315755899375863299672358916972966258900005419821e2 * t1032 * t1033
  t1037 = t79 * t1036
  t1039 = t237 * t242 - 0.8e1 * t234 * t231 - 0.17315755899375863299672358916972966258900005419821e2 * t246 * t253 - 0.58482233974552040708313425006184496242808878304903e0 * t246 * t282 - 0.11696446794910408141662685001236899248561775660981e1 * t285 * t199 - t290 + 0.11696446794910408141662685001236899248561775660981e1 * t246 * t294 - t636 - t960 - t967 + t977 + t985 + t237 * t1037
  t1040 = t241 + t1039
  t1041 = r0 ** (0.1e1 / 0.3e1)
  t1042 = t1041 ** 2
  t1044 = 0.1e1 / t1042 / r0
  t1046 = r0 ** 2
  t1048 = 0.1e1 / t1042 / t1046
  t1054 = 6 ** (0.1e1 / 0.3e1)
  t1056 = jnp.pi ** 2
  t1057 = t1056 ** (0.1e1 / 0.3e1)
  t1058 = t1057 ** 2
  t1059 = 0.1e1 / t1058
  t1060 = (tau0 * t1044 - s0 * t1048 / 0.8e1 - l0 * t1044 / 0.4e1) * t1054 * t1059
  t1062 = r1 ** (0.1e1 / 0.3e1)
  t1063 = t1062 ** 2
  t1065 = 0.1e1 / t1063 / r1
  t1067 = r1 ** 2
  t1076 = (tau1 * t1065 - s2 / t1063 / t1067 / 0.8e1 - l1 * t1065 / 0.4e1) * t1054 * t1059
  t1078 = 0.1e1 - 0.5e1 / 0.18e2 * t1060 - 0.5e1 / 0.18e2 * t1076
  t1079 = t1078 ** 2
  t1081 = 0.1e1 + 0.196e-1 * t1079
  t1082 = jnp.sqrt(t1081)
  t1083 = 0.1e1 / t1082
  t1086 = 0.1e1 / t1081
  t1089 = 0.12033e1 - 0.318038e0 * t1078 * t1083 + 0.1880816e-1 * t1079 * t1086
  t1097 = f.my_piecewise3(t638, 0, t783 * t692 / 0.2e1)
  t1100 = f.my_piecewise3(t298, 0, t457 * t364 / 0.2e1)
  t1101 = -t182 + t237 * t186 + 0.19751789702565206228825776161588751761046270558698e-1 * t79 * t183 - t1097 - t1100
  t1102 = t1046 * r0
  t1104 = 0.1e1 / t1042 / t1102
  t1107 = t1046 ** 2
  t1109 = 0.1e1 / t1042 / t1107
  t1114 = 0.40e2 / 0.9e1 * tau0 * t1104 - 0.11e2 / 0.9e1 * s0 * t1109 - 0.10e2 / 0.9e1 * l0 * t1104
  t1115 = t1114 * t1054
  t1116 = t1059 * t1083
  t1125 = -0.5e1 / 0.3e1 * tau0 * t1048 + s0 * t1104 / 0.3e1 + 0.5e1 / 0.12e2 * l0 * t1048
  t1126 = t1125 ** 2
  t1127 = t1054 ** 2
  t1128 = t1126 * t1127
  t1130 = 0.1e1 / t1057 / t1056
  t1132 = 0.1e1 / t1082 / t1081
  t1137 = t1079 * t1078
  t1138 = t1081 ** 2
  t1140 = 0.1e1 / t1082 / t1138
  t1141 = t1137 * t1140
  t1142 = t1128 * t1130
  t1145 = t1079 * t1132
  t1146 = t1115 * t1059
  t1149 = t1130 * t1086
  t1152 = 0.1e1 / t1138
  t1153 = t1079 * t1152
  t1156 = t1078 * t1086
  t1159 = t1079 ** 2
  t1160 = t1138 * t1081
  t1161 = 0.1e1 / t1160
  t1162 = t1159 * t1161
  t1165 = t1137 * t1152
  t1168 = 0.88343888888888888888888888888888888888888888888889e-1 * t1115 * t1116 + 0.14429501851851851851851851851851851851851851851852e-2 * t1128 * t1130 * t1132 * t1078 - 0.28281823629629629629629629629629629629629629629630e-4 * t1141 * t1142 - 0.17315402222222222222222222222222222222222222222222e-2 * t1145 * t1146 + 0.29024938271604938271604938271604938271604938271606e-2 * t1128 * t1149 - 0.28444439506172839506172839506172839506172839506173e-3 * t1153 * t1142 - 0.10448977777777777777777777777777777777777777777778e-1 * t1156 * t1146 + 0.44600881145679012345679012345679012345679012345681e-5 * t1162 * t1142 + 0.20479996444444444444444444444444444444444444444445e-3 * t1165 * t1146
  t1172 = 0.1e1 - 0.5e1 / 0.9e1 * t1060
  t1173 = t1172 ** 2
  t1175 = 0.1e1 + 0.256e1 * t1173
  t1176 = jnp.sqrt(t1175)
  t1177 = 0.1e1 / t1176
  t1178 = t1059 * t1177
  t1182 = 0.1e1 / t1176 / t1175
  t1187 = t1173 * t1172
  t1188 = t1175 ** 2
  t1190 = 0.1e1 / t1176 / t1188
  t1191 = t1187 * t1190
  t1194 = t1173 * t1182
  t1197 = 0.1e1 / t1175
  t1198 = t1130 * t1197
  t1201 = 0.1e1 / t1188
  t1202 = t1173 * t1201
  t1205 = t1172 * t1197
  t1208 = t1173 ** 2
  t1209 = t1188 * t1175
  t1210 = 0.1e1 / t1209
  t1211 = t1208 * t1210
  t1214 = t1187 * t1201
  t1217 = 0.85404444444444444444444444444444444444444444444445e0 * t1115 * t1178 + 0.36439229629629629629629629629629629629629629629629e1 * t1128 * t1130 * t1182 * t1172 - 0.93284427851851851851851851851851851851851851851847e1 * t1191 * t1142 - 0.21863537777777777777777777777777777777777777777777e1 * t1194 * t1146 + 0.14258567901234567901234567901234567901234567901234e1 * t1128 * t1198 - 0.18250966913580246913580246913580246913580246913580e2 * t1202 * t1142 - 0.25665422222222222222222222222222222222222222222222e1 * t1205 * t1146 + 0.37377980239012345679012345679012345679012345679011e2 * t1211 * t1142 + 0.65703480888888888888888888888888888888888888888888e1 * t1214 * t1146
  t1218 = t1097 * t1217
  t1221 = 0.1e1 / tau0
  t1222 = s0 / t1046 * t1221
  t1225 = jnp.pi ** (0.1e1 / 0.3e1)
  t1227 = t1 / t1225
  t1228 = r0 * t60
  t1230 = 0.2e1 * t1228 <= f.p.zeta_threshold
  t1231 = t75 * t60
  t1232 = t1228 ** (0.1e1 / 0.3e1)
  t1235 = t75 * r0
  t1239 = t1232 ** 2
  t1240 = 0.1e1 / t1239
  t1241 = t60 * t1240
  t1243 = -r0 * t97 + t60
  t1248 = f.my_piecewise3(t1230, 0, 0.2e1 * t1231 * t1232 - 0.2e1 * t1235 * t97 * t1232 + 0.2e1 / 0.3e1 * t1235 * t1241 * t1243)
  t1249 = t1248 * t9
  t1251 = 0.1e1 + 0.121e-1 * t1173
  t1252 = jnp.sqrt(t1251)
  t1253 = 0.1e1 / t1252
  t1254 = t1059 * t1253
  t1258 = 0.1e1 / t1252 / t1251
  t1263 = t1251 ** 2
  t1265 = 0.1e1 / t1252 / t1263
  t1266 = t1187 * t1265
  t1269 = t1173 * t1258
  t1272 = 0.1e1 / t1251
  t1273 = t1130 * t1272
  t1276 = 0.1e1 / t1263
  t1277 = t1173 * t1276
  t1280 = t1172 * t1272
  t1283 = t1263 * t1251
  t1284 = 0.1e1 / t1283
  t1285 = t1208 * t1284
  t1288 = t1187 * t1276
  t1291 = -0.40834444444444444444444444444444444444444444444444e-1 * t1115 * t1254 - 0.82349462962962962962962962962962962962962962962960e-3 * t1128 * t1130 * t1258 * t1172 + 0.99642850185185185185185185185185185185185185185178e-5 * t1266 * t1142 + 0.49409677777777777777777777777777777777777777777776e-3 * t1269 * t1146 + 0.10606172839506172839506172839506172839506172839506e-2 * t1128 * t1273 - 0.64167345679012345679012345679012345679012345679011e-4 * t1277 * t1142 - 0.19091111111111111111111111111111111111111111111111e-2 * t1280 * t1146 + 0.62113990617283950617283950617283950617283950617281e-6 * t1285 * t1142 + 0.23100244444444444444444444444444444444444444444444e-4 * t1288 * t1146
  t1295 = r1 * t60
  t1297 = 0.2e1 * t1295 <= f.p.zeta_threshold
  t1298 = t75 * r1
  t1299 = t1295 ** (0.1e1 / 0.3e1)
  t1303 = t75 * t1067
  t1304 = t1299 ** 2
  t1305 = 0.1e1 / t1304
  t1310 = f.my_piecewise3(t1297, 0, -0.2e1 * t1298 * t97 * t1299 - 0.2e1 / 0.3e1 * t1303 * t209 * t1305)
  t1313 = 0.1e1 - 0.5e1 / 0.9e1 * t1076
  t1314 = t1313 ** 2
  t1316 = 0.1e1 + 0.121e-1 * t1314
  t1317 = jnp.sqrt(t1316)
  t1324 = 0.8085e0 + 0.73502e-1 * t1313 / t1317 + 0.171820e-2 * t1314 / t1316
  t1332 = f.my_piecewise3(t638, 0, t695 * t692 / 0.2e1 + t783 * t781 / 0.2e1)
  t1337 = 0.2606e0 - 0.153728e1 * t1172 * t1177 + 0.2309888e1 * t1173 * t1197
  t1338 = t1332 * t1337
  t1341 = s0 / t1102 * t1221
  t1344 = t1125 * t1054
  t1347 = t1344 * t1059
  t1354 = 0.85404444444444444444444444444444444444444444444445e0 * t1344 * t1178 - 0.21863537777777777777777777777777777777777777777777e1 * t1194 * t1347 - 0.25665422222222222222222222222222222222222222222222e1 * t1205 * t1347 + 0.65703480888888888888888888888888888888888888888888e1 * t1214 * t1347
  t1355 = t1097 * t1354
  t1365 = t75 * t1067 * r1
  t1367 = 0.1e1 / t1304 / t1295
  t1371 = t1067 ** 2
  t1374 = 0.1e1 / t116 / t208
  t1382 = f.my_piecewise3(t1297, 0, -0.12e2 * t1298 * t117 * t1299 - 0.12e2 * t1303 * t193 * t1305 + 0.4e1 * t1365 * t177 * t1367 - 0.20e2 / 0.27e2 * t75 * t1371 * t1374 / t1304 / t1067 / t97)
  t1390 = f.my_piecewise3(t1230, t65, 0.2e1 * t1235 * t60 * t1232)
  t1391 = t1390 * t24
  t1395 = t1390 * t9
  t1398 = t1127 * t1130 * t1114
  t1421 = (-0.440e3 / 0.27e2 * tau0 * t1109 + 0.154e3 / 0.27e2 * s0 / t1042 / t1107 / r0 + 0.110e3 / 0.27e2 * l0 * t1109) * t1054
  t1422 = t1421 * t1059
  t1427 = t1125 * t1127
  t1436 = t1056 ** 2
  t1438 = t1126 * t1125 / t1436
  t1453 = t1208 * t1172
  t1454 = t1263 ** 2
  t1461 = -0.19250203703703703703703703703703703703703703703703e-3 * t1277 * t1125 * t1398 + 0.18634197185185185185185185185185185185185185185184e-5 * t1285 * t1125 * t1398 - 0.24704838888888888888888888888888888888888888888888e-2 * t1398 * t1258 * t1172 * t1125 + 0.29892855055555555555555555555555555555555555555554e-4 * t1266 * t1125 * t1398 + 0.23100244444444444444444444444444444444444444444444e-4 * t1288 * t1422 + 0.49409677777777777777777777777777777777777777777776e-3 * t1269 * t1422 + 0.31818518518518518518518518518518518518518518518518e-2 * t1427 * t1273 * t1114 - 0.19091111111111111111111111111111111111111111111111e-2 * t1280 * t1422 - 0.40834444444444444444444444444444444444444444444444e-1 * t1421 * t1254 - 0.19928570037037037037037037037037037037037037037036e-3 * t1438 * t1265 * t1173 + 0.20094641454012345679012345679012345679012345679010e-5 * t1208 / t1252 / t1283 * t1438 + 0.51333876543209876543209876543209876543209876543209e-3 * t1438 * t1276 * t1172 - 0.18634197185185185185185185185185185185185185185184e-4 * t1187 * t1284 * t1438 + 0.15031585729382716049382716049382716049382716049381e-6 * t1453 / t1454 * t1438 + 0.27449820987654320987654320987654320987654320987653e-2 * t1438 * t1258
  t1465 = t1332 * t1354
  t1476 = 0.88343888888888888888888888888888888888888888888889e-1 * t1344 * t1116 - 0.17315402222222222222222222222222222222222222222222e-2 * t1145 * t1347 - 0.10448977777777777777777777777777777777777777777778e-1 * t1156 * t1347 + 0.20479996444444444444444444444444444444444444444445e-3 * t1165 * t1347
  t1479 = t59 * t117
  t1481 = -0.6e1 * t209 + 0.6e1 * t1479
  t1482 = f.my_piecewise3(t70, 0, t1481)
  t1490 = 0.1e1 / t9 / t208
  t1491 = t1490 * t75
  t1493 = t7 * t1491 * t303
  t1496 = t7 * t458 * t375
  t1499 = t7 * t368 * t473
  t1504 = t219 * t103
  t1513 = f.my_piecewise3(t70, 0, -0.28e2 / 0.27e2 / t71 / t465 / t69 * t1504 + 0.4e1 / 0.3e1 * t467 * t103 * t222 - t372 * t1481 / 0.3e1)
  t1515 = t7 * t300 * t1513
  t1519 = 0.62182e-1 * (-0.55403703703703703703703703703703703703703703703703e-1 * t1493 + 0.71233333333333333333333333333333333333333333333332e-1 * t1496 - 0.53424999999999999999999999999999999999999999999999e-1 * t1499 + 0.53425000000000000000000000000000000000000000000000e-1 * t1515) * t324
  t1521 = 0.1e1 / t605 / t353
  t1522 = t586 * t441
  t1530 = t492 * t387
  t1531 = 0.1e1 / t308 / t318 * t1530 / 0.4e1
  t1534 = t491 * t387 * t497
  t1538 = -0.28e2 / 0.27e2 * t1493 + 0.4e1 / 0.3e1 * t1496 - t1499 + t1515
  t1539 = t385 * t1538
  t1545 = t305 ** (-0.15e1)
  t1546 = t1545 * t1530
  t1549 = t503 * t387 * t497
  t1551 = t392 * t1538
  t1554 = 0.1e1 / t23 / t208
  t1555 = t1554 * t314
  t1557 = t313 * t1555 * t316
  t1560 = t313 * t508 * t399
  t1563 = t313 * t395 * t515
  t1566 = t313 * t395 * t519
  t1570 = t313 * t315 * t375 * t473
  t1574 = t313 * t315 * t303 * t1513
  t1576 = 0.19419375000000000000000000000000000000000000000000e1 * t1531 - 0.38838750000000000000000000000000000000000000000000e1 * t1534 + 0.25892500000000000000000000000000000000000000000000e1 * t1539 - 0.93932222222222222222222222222222222222222222222223e0 * t1493 + 0.12077000000000000000000000000000000000000000000000e1 * t1496 - 0.90577500000000000000000000000000000000000000000000e0 * t1499 + 0.90577500000000000000000000000000000000000000000000e0 * t1515 - 0.41262187500000000000000000000000000000000000000000e-1 * t1546 + 0.24757312500000000000000000000000000000000000000000e0 * t1549 + 0.16504875000000000000000000000000000000000000000000e0 * t1551 - 0.36793333333333333333333333333333333333333333333333e0 * t1557 + 0.82785000000000000000000000000000000000000000000000e0 * t1560 - 0.49671000000000000000000000000000000000000000000000e0 * t1563 - 0.49671000000000000000000000000000000000000000000000e0 * t1566 + 0.74506500000000000000000000000000000000000000000000e0 * t1570 + 0.24835500000000000000000000000000000000000000000000e0 * t1574
  t1586 = (-0.28842592592592592592592592592592592592592592592592e-1 * t1493 + 0.37083333333333333333333333333333333333333333333334e-1 * t1496 - 0.27812500000000000000000000000000000000000000000000e-1 * t1499 + 0.27812500000000000000000000000000000000000000000000e-1 * t1515) * t357
  t1598 = 0.60000000000000000000000000000000000000000000000000e1 * t485 * t405 * t523
  t1602 = 0.48245472966453314463992795342703676305040043742564e2 * t529 * t523 * t531 * t403
  t1621 = t486 * t403
  t1626 = 0.51725014705706168413145063783413931475389495076352e3 * t307 / t527 / t382 * t1621 / t530 / t323
  t1635 = 0.96490945932906628927985590685407352610080087485128e2 * t307 / t527 / t320 * t1621 * t531
  t1638 = 0.60000000000000000000000000000000000000000000000000e1 * t379 * t484 * t487
  t1641 = 0.60000000000000000000000000000000000000000000000000e1 * t529 * t1621 * t404
  t1645 = t547 * t422
  t1649 = -0.35089340384731224424988055003710697745685326982943e1 * t585 * t443 * t601 + 0.51947267698127589899017076750918898776700016259463e2 * t607 * t601 * t609 * t441 + t1598 - t1602 - 0.60000000000000000000000000000000000000000000000000e1 * t546 * t424 * t562 + 0.96494049533612093920874879382438082984882598906400e2 * t568 * t562 * t570 * t422 - 0.31090e-1 * (-0.53272592592592592592592592592592592592592592592592e-1 * t1493 + 0.68493333333333333333333333333333333333333333333332e-1 * t1496 - 0.51369999999999999999999999999999999999999999999999e-1 * t1499 + 0.51370000000000000000000000000000000000000000000000e-1 * t1515) * t344 - 0.19751789702565206228825776161588751761046270558698e-1 * t1586 + t1519 - t1626 + 0.30000000000000000000000000000000000000000000000000e1 * t538 * t414 * t424 + t1635 + t1638 - t1641 - 0.60000000000000000000000000000000000000000000000000e1 * t410 * t545 * t548 + 0.60000000000000000000000000000000000000000000000000e1 * t568 * t1645 * t423
  t1688 = 0.26472937500000000000000000000000000000000000000000e1 * t1531 - 0.52945875000000000000000000000000000000000000000000e1 * t1534 + 0.35297250000000000000000000000000000000000000000000e1 * t1539 - 0.16068111111111111111111111111111111111111111111111e1 * t1493 + 0.20659000000000000000000000000000000000000000000000e1 * t1496 - 0.15494250000000000000000000000000000000000000000000e1 * t1499 + 0.15494250000000000000000000000000000000000000000000e1 * t1515 - 0.15779062500000000000000000000000000000000000000000e0 * t1546 + 0.94674375000000000000000000000000000000000000000000e0 * t1549 + 0.63116250000000000000000000000000000000000000000000e0 * t1551 - 0.46308888888888888888888888888888888888888888888888e0 * t1557 + 0.10419500000000000000000000000000000000000000000000e1 * t1560 - 0.62517000000000000000000000000000000000000000000000e0 * t1563 - 0.62517000000000000000000000000000000000000000000000e0 * t1566 + 0.93775500000000000000000000000000000000000000000000e0 * t1570 + 0.31258500000000000000000000000000000000000000000000e0 * t1574
  t1701 = 0.48245472966453314463992795342703676305040043742564e2 * t379 * t528 * t532
  t1727 = 0.14241937500000000000000000000000000000000000000000e1 * t1531 - 0.28483875000000000000000000000000000000000000000000e1 * t1534 + 0.18989250000000000000000000000000000000000000000000e1 * t1539 - 0.93011851851851851851851851851851851851851851851854e0 * t1493 + 0.11958666666666666666666666666666666666666666666667e1 * t1496 - 0.89690000000000000000000000000000000000000000000001e0 * t1499 + 0.89690000000000000000000000000000000000000000000000e0 * t1515 - 0.76790625000000000000000000000000000000000000000000e-1 * t1546 + 0.46074375000000000000000000000000000000000000000000e0 * t1549 + 0.30716250000000000000000000000000000000000000000000e0 * t1551 - 0.36514074074074074074074074074074074074074074074075e0 * t1557 + 0.82156666666666666666666666666666666666666666666666e0 * t1560 - 0.49293999999999999999999999999999999999999999999999e0 * t1563 - 0.49293999999999999999999999999999999999999999999999e0 * t1566 + 0.73941000000000000000000000000000000000000000000000e0 * t1570 + 0.24647000000000000000000000000000000000000000000000e0 * t1574
  t1730 = 0.10000000000000000000000000000000000000000000000000e1 * t384 * t1727 * t404
  t1732 = 0.1e1 / t605 / t432
  t1735 = 0.1e1 / t608 / t356
  t1743 = 0.30000000000000000000000000000000000000000000000000e1 * t477 * t383 * t405
  t1745 = 0.30000000000000000000000000000000000000000000000000e1 * t480 * t524
  t1746 = 0.17544670192365612212494027501855348872842663491471e1 * t577 * t433 * t443 + 0.17544670192365612212494027501855348872842663491471e1 * t580 * t602 + 0.20691336878655965245175271659148296983999699561788e4 * t335 / t566 / t413 * t1645 / t569 / t343 + 0.96494049533612093920874879382438082984882598906400e2 * t410 * t567 * t571 - 0.19298809906722418784174975876487616596976519781280e3 * t335 / t566 / t340 * t1645 * t570 + 0.99999999999999999999999999999999999999999999999999e0 * t415 * t1688 * t423 + 0.51947267698127589899017076750918898776700016259464e2 * t429 * t606 * t610 - 0.10389453539625517979803415350183779755340003251893e3 * t348 * t1521 * t1522 * t609 - t1701 + 0.58482233974552040708313425006184496242808878304903e0 * t434 * t1576 * t442 - 0.35089340384731224424988055003710697745685326982943e1 * t429 * t584 * t587 + 0.35089340384731224424988055003710697745685326982943e1 * t607 * t1522 * t442 - t1730 + 0.10253897021007794930818001372045340355835853271641e4 * t348 * t1732 * t1522 * t1735 + 0.30000000000000000000000000000000000000000000000000e1 * t541 * t563 - t1743 - t1745
  t1749 = -t1519 + 0.10389453539625517979803415350183779755340003251893e3 * t450 * t1521 * t1522 * t609 - 0.58482233974552040708313425006184496242808878304903e0 * t450 * t433 * t1576 * t442 + 0.19751789702565206228825776161588751761046270558698e-1 * t333 * t1586 + t333 * (t1649 + t1746) + t1730 + t1626 + t1743 + t1745 + t1701 - t1635
  t1776 = -t1638 + t1641 - t1598 + t1602 - 0.35089340384731224424988055003710697745685326982943e1 * t450 * t606 * t1522 * t442 + 0.35089340384731224424988055003710697745685326982943e1 * t450 * t584 * t441 * t602 - 0.51947267698127589899017076750918898776700016259463e2 * t450 * t606 * t601 * t609 * t441 - 0.17544670192365612212494027501855348872842663491471e1 * t333 * t577 * t452 - 0.17544670192365612212494027501855348872842663491471e1 * t617 * t625 - 0.51947267698127589899017076750918898776700016259464e2 * t617 * t629 - 0.10253897021007794930818001372045340355835853271641e4 * t450 * t1732 * t1522 * t1735 + 0.35089340384731224424988055003710697745685326982943e1 * t617 * t621
  t1781 = f.my_piecewise3(t298, 0, t1482 * t364 / 0.2e1 + 0.3e1 / 0.2e1 * t299 * t455 + 0.3e1 / 0.2e1 * t367 * t632 + t457 * (t1749 + t1776) / 0.2e1)
  t1783 = 0.1e1 + 0.256e1 * t1314
  t1784 = jnp.sqrt(t1783)
  t1791 = 0.2606e0 - 0.153728e1 * t1313 / t1784 + 0.2309888e1 * t1314 / t1783
  t1798 = 0.1e1 - s2 / r1 / tau1 / 0.8e1
  t1805 = t964 * t50
  t1810 = 0.51725014705706168413145063783413931475389495076352e3 * t150 / t978 / t29 * t1805 / t981 / t53
  t1818 = t252 * t280
  t1843 = 0.96490945932906628927985590685407352610080087485128e2 * t150 / t978 / t28 * t1805 * t982
  t1845 = 0.1e1 / t247 / t88
  t1847 = t249 * t166
  t1853 = 0.60000000000000000000000000000000000000000000000000e1 * t963 * t975 * t50
  t1854 = t996 * t140
  t1860 = 0.60000000000000000000000000000000000000000000000000e1 * t980 * t1805 * t54
  t1870 = t6 * t1490
  t1881 = 0.1e1 / t15 / t26 * t2 * t117 / 0.4e1
  t1883 = t259 * t1554
  t1884 = t258 * t1883
  t1886 = t34 * t1490
  t1887 = t33 * t1886
  t1889 = t4 * t1870
  t1891 = t14 ** (-0.15e1)
  t1893 = t1891 * t2 * t117
  t1895 = t272 * t1883
  t1897 = t42 * t1886
  t1900 = t22 * t5 * t1554
  t1902 = -0.34523333333333333333333333333333333333333333333333e1 * t1881 + 0.23015555555555555555555555555555555555555555555556e1 * t1884 - 0.26851481481481481481481481481481481481481481481482e1 * t1887 - 0.93932222222222222222222222222222222222222222222223e0 * t1889 + 0.73355000000000000000000000000000000000000000000000e-1 * t1893 - 0.14671000000000000000000000000000000000000000000000e0 * t1895 - 0.17116166666666666666666666666666666666666666666667e0 * t1897 - 0.36793333333333333333333333333333333333333333333333e0 * t1900
  t1933 = -t1810 - 0.35089340384731224424988055003710697745685326982943e1 * t1025 * t168 * t280 + t1843 - 0.10389453539625517979803415350183779755340003251893e3 * t158 * t1845 * t1847 * t252 + t1853 + 0.60000000000000000000000000000000000000000000000000e1 * t1012 * t1854 * t141 - t1860 - 0.19298809906722418784174975876487616596976519781280e3 * t132 / t1010 / t123 * t1854 * t1014 + 0.51947267698127589899017076750918898776700016259463e2 * t1032 * t1818 * t166 + 0.56969282336565386484066937725323112718202900731800e-3 * t4 * t1870 * t92 + 0.16562449037037037037037037037037037037037037037036e-2 * t4 * t1870 * t127 + 0.58482233974552040708313425006184496242808878304903e0 * t161 * t1902 * t167 + 0.20691336878655965245175271659148296983999699561788e4 * t132 / t1010 / t133 * t1854 / t1013 / t126 + 0.99999999999999999999999999999999999999999999999999e0 * t135 * (-0.47063000000000000000000000000000000000000000000000e1 * t1881 + 0.31375333333333333333333333333333333333333333333334e1 * t1884 - 0.36604555555555555555555555555555555555555555555556e1 * t1887 - 0.16068111111111111111111111111111111111111111111111e1 * t1889 + 0.28051666666666666666666666666666666666666666666666e0 * t1893 - 0.56103333333333333333333333333333333333333333333332e0 * t1895 - 0.65453888888888888888888888888888888888888888888890e0 * t1897 - 0.46308888888888888888888888888888888888888888888888e0 * t1900) * t141 + 0.96494049533612093920874879382438082984882598906400e2 * t1012 * t1006 * t1014 * t140 - 0.60000000000000000000000000000000000000000000000000e1 * t995 * t142 * t1006
  t1945 = 0.10000000000000000000000000000000000000000000000000e1 * t151 * (-0.25319000000000000000000000000000000000000000000000e1 * t1881 + 0.16879333333333333333333333333333333333333333333333e1 * t1884 - 0.19692555555555555555555555555555555555555555555555e1 * t1887 - 0.93011851851851851851851851851851851851851851851854e0 * t1889 + 0.13651666666666666666666666666666666666666666666667e0 * t1893 - 0.27303333333333333333333333333333333333333333333333e0 * t1895 - 0.31853888888888888888888888888888888888888888888890e0 * t1897 - 0.36514074074074074074074074074074074074074074074075e0 * t1900) * t54
  t1947 = 0.1e1 / t247 / t159
  t1950 = 0.1e1 / t251 / t91
  t1957 = 0.48245472966453314463992795342703676305040043742564e2 * t980 * t974 * t982 * t50
  t1960 = 0.34451131037037037037037037037037037037037037037036e-2 * t4 * t1870 * t145
  t1978 = 0.10685000000000000000000000000000000000000000000000e0 * t7 * t11 * t962 * t965
  t1992 = 0.53424999999999999999999999999999999999999999999999e-1 * t7 * t31 * t975
  t1996 = 0.85917146441092277507960503039464796886558811231548e0 * t7 * t11 * t979 * t983
  t2000 = 0.71233333333333333333333333333333333333333333333333e-1 * t7 * t83 * t30 * t55
  t2009 = -t1945 + 0.10253897021007794930818001372045340355835853271641e4 * t158 * t1947 * t1847 * t1950 - t1957 - t1960 + 0.35089340384731224424988055003710697745685326982943e1 * t1032 * t1847 * t167 + 0.21687161765563048429332895106460084023374959038068e-1 * t7 * t83 * t160 * t168 - 0.16265371324172286321999671329845063017531219278551e-1 * t7 * t1021 * t1029 - 0.48159446095139119802213748237831062407565640073877e0 * t7 * t11 * t248 * t1033 - t1978 + 0.68493333333333333333333333333333333333333333333331e-1 * t7 * t83 * t134 * t142 - 0.51369999999999999999999999999999999999999999999999e-1 * t7 * t989 * t1007 - 0.16522997748472177549051141846252814409778063686072e1 * t7 * t11 * t1011 * t1015 + t1992 + t1996 - t2000 + 0.10274000000000000000000000000000000000000000000000e0 * t7 * t11 * t994 * t997 + 0.32530742648344572643999342659690126035062438557102e-1 * t7 * t11 * t292 * t1026
  t2019 = -0.12e2 * t234 * t1037 + t1810 + 0.36e2 * t189 * t172 + 0.35089340384731224424988055003710697745685326982943e1 * t246 * t292 * t166 * t1029 - 0.51947267698127589899017076750918898776700016259463e2 * t246 * t248 * t166 * t1818 + 0.12e2 * t118 * t1037 + 0.24e2 * t1479 * t186 - 0.144e3 * t114 * t193 * t186 + 0.240e3 * t115 * t177 * t186 - 0.120e3 * t175 * t1374 * t186 + t237 * t79 * (t1933 + t2009) + 0.48159446095139119802213748237831062407565640073877e0 * t197 * t38 * t253 + 0.16265371324172286321999671329845063017531219278551e-1 * t197 * t38 * t282
  t2031 = t205 * t99
  t2037 = -t1481
  t2041 = f.my_piecewise3(t63, 0, -0.8e1 / 0.27e2 / t203 / t62 * t2031 + 0.4e1 / 0.3e1 * t204 * t99 * t212 + 0.4e1 / 0.3e1 * t66 * t2037)
  t2052 = f.my_piecewise3(t70, 0, -0.8e1 / 0.27e2 / t217 / t69 * t1504 + 0.4e1 / 0.3e1 * t218 * t103 * t222 + 0.4e1 / 0.3e1 * t71 * t1481)
  t2054 = (t2041 + t2052) * t78
  t2078 = 0.32530742648344572643999342659690126035062438557102e-1 * t108 * t4 * t200 - 0.21687161765563048429332895106460084023374959038068e-1 * t197 * t268 * t199 - 0.32530742648344572643999342659690126035062438557102e-1 * t197 * t38 * t294 + t237 * t2054 * t185 + 0.19751789702565206228825776161588751761046270558698e-1 * t2054 * t183 + 0.3e1 * t237 * t228 * t171 - 0.51947267698127589899017076750918898776700016259464e2 * t285 * t253 - 0.58482233974552040708313425006184496242808878304903e0 * t246 * t160 * t1902 * t167 - 0.10253897021007794930818001372045340355835853271641e4 * t246 * t1947 * t1847 * t1950 - 0.17544670192365612212494027501855348872842663491471e1 * t285 * t282 + 0.10389453539625517979803415350183779755340003251893e3 * t246 * t1845 * t1847 * t252 - t1843 - t1853
  t2080 = f.my_piecewise3(t63, 0, t2037)
  t2087 = t910 * t767
  t2098 = 0.60000000000000000000000000000000000000000000000000e1 * t706 * t809 * t812
  t2099 = t811 * t729
  t2102 = 0.60000000000000000000000000000000000000000000000000e1 * t853 * t2099 * t730
  t2105 = 0.60000000000000000000000000000000000000000000000000e1 * t810 * t731 * t847
  t2109 = 0.48245472966453314463992795342703676305040043742564e2 * t853 * t847 * t855 * t729
  t2112 = 0.30000000000000000000000000000000000000000000000000e1 * t802 * t710 * t731
  t2114 = 0.30000000000000000000000000000000000000000000000000e1 * t805 * t848
  t2117 = 0.48245472966453314463992795342703676305040043742564e2 * t706 * t852 * t856
  t2119 = t7 * t1491 * t641
  t2122 = t7 * t458 * t702
  t2125 = t7 * t368 * t798
  t2138 = f.my_piecewise3(t63, 0, -0.28e2 / 0.27e2 / t66 / t790 / t62 * t2031 + 0.4e1 / 0.3e1 * t792 * t99 * t212 - t699 * t2037 / 0.3e1)
  t2140 = t7 * t300 * t2138
  t2144 = 0.62182e-1 * (-0.55403703703703703703703703703703703703703703703703e-1 * t2119 + 0.71233333333333333333333333333333333333333333333332e-1 * t2122 - 0.53424999999999999999999999999999999999999999999999e-1 * t2125 + 0.53425000000000000000000000000000000000000000000000e-1 * t2140) * t659
  t2150 = 0.96490945932906628927985590685407352610080087485128e2 * t645 / t851 / t655 * t2099 * t855
  t2151 = -0.35089340384731224424988055003710697745685326982943e1 * t776 * t930 * t2087 * t768 + 0.35089340384731224424988055003710697745685326982943e1 * t776 * t908 * t767 * t926 - t2098 + t2102 - t2105 + t2109 + t2112 + t2114 + t2117 - t2144 - t2150
  t2155 = t817 * t714
  t2156 = 0.1e1 / t646 / t653 * t2155 / 0.4e1
  t2159 = t816 * t714 * t822
  t2163 = -0.28e2 / 0.27e2 * t2119 + 0.4e1 / 0.3e1 * t2122 - t2125 + t2140
  t2164 = t712 * t2163
  t2170 = t643 ** (-0.15e1)
  t2171 = t2170 * t2155
  t2174 = t828 * t714 * t822
  t2176 = t719 * t2163
  t2179 = t313 * t1555 * t651
  t2182 = t313 * t508 * t725
  t2185 = t313 * t395 * t839
  t2188 = t313 * t395 * t843
  t2192 = t313 * t315 * t702 * t798
  t2196 = t313 * t315 * t641 * t2138
  t2198 = 0.14241937500000000000000000000000000000000000000000e1 * t2156 - 0.28483875000000000000000000000000000000000000000000e1 * t2159 + 0.18989250000000000000000000000000000000000000000000e1 * t2164 - 0.93011851851851851851851851851851851851851851851854e0 * t2119 + 0.11958666666666666666666666666666666666666666666667e1 * t2122 - 0.89690000000000000000000000000000000000000000000001e0 * t2125 + 0.89690000000000000000000000000000000000000000000000e0 * t2140 - 0.76790625000000000000000000000000000000000000000000e-1 * t2171 + 0.46074375000000000000000000000000000000000000000000e0 * t2174 + 0.30716250000000000000000000000000000000000000000000e0 * t2176 - 0.36514074074074074074074074074074074074074074074075e0 * t2179 + 0.82156666666666666666666666666666666666666666666666e0 * t2182 - 0.49293999999999999999999999999999999999999999999999e0 * t2185 - 0.49293999999999999999999999999999999999999999999999e0 * t2188 + 0.73941000000000000000000000000000000000000000000000e0 * t2192 + 0.24647000000000000000000000000000000000000000000000e0 * t2196
  t2201 = 0.10000000000000000000000000000000000000000000000000e1 * t711 * t2198 * t730
  t2209 = 0.51725014705706168413145063783413931475389495076352e3 * t645 / t851 / t709 * t2099 / t854 / t658
  t2211 = 0.1e1 / t929 / t681
  t2232 = 0.19419375000000000000000000000000000000000000000000e1 * t2156 - 0.38838750000000000000000000000000000000000000000000e1 * t2159 + 0.25892500000000000000000000000000000000000000000000e1 * t2164 - 0.93932222222222222222222222222222222222222222222223e0 * t2119 + 0.12077000000000000000000000000000000000000000000000e1 * t2122 - 0.90577500000000000000000000000000000000000000000000e0 * t2125 + 0.90577500000000000000000000000000000000000000000000e0 * t2140 - 0.41262187500000000000000000000000000000000000000000e-1 * t2171 + 0.24757312500000000000000000000000000000000000000000e0 * t2174 + 0.16504875000000000000000000000000000000000000000000e0 * t2176 - 0.36793333333333333333333333333333333333333333333333e0 * t2179 + 0.82785000000000000000000000000000000000000000000000e0 * t2182 - 0.49671000000000000000000000000000000000000000000000e0 * t2185 - 0.49671000000000000000000000000000000000000000000000e0 * t2188 + 0.74506500000000000000000000000000000000000000000000e0 * t2192 + 0.24835500000000000000000000000000000000000000000000e0 * t2196
  t2261 = (-0.28842592592592592592592592592592592592592592592592e-1 * t2119 + 0.37083333333333333333333333333333333333333333333334e-1 * t2122 - 0.27812500000000000000000000000000000000000000000000e-1 * t2125 + 0.27812500000000000000000000000000000000000000000000e-1 * t2140) * t685
  t2269 = t871 * t748
  t2289 = 0.26472937500000000000000000000000000000000000000000e1 * t2156 - 0.52945875000000000000000000000000000000000000000000e1 * t2159 + 0.35297250000000000000000000000000000000000000000000e1 * t2164 - 0.16068111111111111111111111111111111111111111111111e1 * t2119 + 0.20659000000000000000000000000000000000000000000000e1 * t2122 - 0.15494250000000000000000000000000000000000000000000e1 * t2125 + 0.15494250000000000000000000000000000000000000000000e1 * t2140 - 0.15779062500000000000000000000000000000000000000000e0 * t2171 + 0.94674375000000000000000000000000000000000000000000e0 * t2174 + 0.63116250000000000000000000000000000000000000000000e0 * t2176 - 0.46308888888888888888888888888888888888888888888888e0 * t2179 + 0.10419500000000000000000000000000000000000000000000e1 * t2182 - 0.62517000000000000000000000000000000000000000000000e0 * t2185 - 0.62517000000000000000000000000000000000000000000000e0 * t2188 + 0.93775500000000000000000000000000000000000000000000e0 * t2192 + 0.31258500000000000000000000000000000000000000000000e0 * t2196
  t2310 = 0.1e1 / t929 / t758
  t2313 = 0.1e1 / t932 / t684
  t2334 = -0.31090e-1 * (-0.53272592592592592592592592592592592592592592592592e-1 * t2119 + 0.68493333333333333333333333333333333333333333333332e-1 * t2122 - 0.51369999999999999999999999999999999999999999999999e-1 * t2125 + 0.51370000000000000000000000000000000000000000000000e-1 * t2140) * t672 - 0.19751789702565206228825776161588751761046270558698e-1 * t2261 + 0.96494049533612093920874879382438082984882598906400e2 * t736 * t891 * t895 - 0.19298809906722418784174975876487616596976519781280e3 * t663 / t890 / t668 * t2269 * t894 + 0.99999999999999999999999999999999999999999999999999e0 * t741 * t2289 * t749 + 0.17544670192365612212494027501855348872842663491471e1 * t901 * t759 * t769 + 0.17544670192365612212494027501855348872842663491471e1 * t904 * t926 + 0.51947267698127589899017076750918898776700016259464e2 * t755 * t930 * t934 + 0.20691336878655965245175271659148296983999699561788e4 * t663 / t890 / t739 * t2269 / t893 / t671 + 0.10253897021007794930818001372045340355835853271641e4 * t676 * t2310 * t2087 * t2313 - 0.60000000000000000000000000000000000000000000000000e1 * t736 * t869 * t872 + 0.60000000000000000000000000000000000000000000000000e1 * t892 * t2269 * t749 + 0.30000000000000000000000000000000000000000000000000e1 * t862 * t740 * t750 + 0.30000000000000000000000000000000000000000000000000e1 * t865 * t887 - 0.35089340384731224424988055003710697745685326982943e1 * t755 * t908 * t911 + 0.35089340384731224424988055003710697745685326982943e1 * t931 * t2087 * t768
  t2356 = -t2114 - t2117 + t2150 - t2201 - t2209 - 0.10389453539625517979803415350183779755340003251893e3 * t676 * t2211 * t2087 * t933 + 0.58482233974552040708313425006184496242808878304903e0 * t760 * t2232 * t768 + t2098 - t2102 - t2112 + t2144 + t2105 - t2109 + 0.51947267698127589899017076750918898776700016259463e2 * t931 * t925 * t933 * t767 - 0.60000000000000000000000000000000000000000000000000e1 * t870 * t750 * t886 + 0.96494049533612093920874879382438082984882598906400e2 * t892 * t886 * t894 * t748 - 0.35089340384731224424988055003710697745685326982943e1 * t909 * t769 * t925
  t2367 = t2201 + t2209 + 0.10389453539625517979803415350183779755340003251893e3 * t776 * t2211 * t2087 * t933 - 0.58482233974552040708313425006184496242808878304903e0 * t776 * t759 * t2232 * t768 - 0.51947267698127589899017076750918898776700016259464e2 * t941 * t953 - 0.17544670192365612212494027501855348872842663491471e1 * t333 * t901 * t778 - 0.17544670192365612212494027501855348872842663491471e1 * t941 * t949 - 0.51947267698127589899017076750918898776700016259463e2 * t776 * t930 * t925 * t933 * t767 + t333 * (t2334 + t2356) + 0.19751789702565206228825776161588751761046270558698e-1 * t333 * t2261 + 0.35089340384731224424988055003710697745685326982943e1 * t941 * t945 - 0.10253897021007794930818001372045340355835853271641e4 * t776 * t2310 * t2087 * t2313
  t2372 = f.my_piecewise3(t638, 0, t2080 * t692 / 0.2e1 + 0.3e1 / 0.2e1 * t639 * t781 + 0.3e1 / 0.2e1 * t695 * t956 + t783 * (t2151 + t2367) / 0.2e1)
  t2396 = -t2372 - 0.17544670192365612212494027501855348872842663491471e1 * t228 * t158 * t199 - 0.35089340384731224424988055003710697745685326982943e1 * t246 * t248 * t1847 * t167 + 0.35089340384731224424988055003710697745685326982943e1 * t285 * t294 + t1860 - 0.96e2 * t194 * t172 + 0.24e2 * t118 * t238 + 0.12e2 * t118 * t242 - 0.12e2 * t234 * t242 - 0.96e2 * t194 * t231 + 0.60e2 * t178 * t231 + 0.36e2 * t189 * t231 + t1945
  t2413 = t1957 + t1960 + 0.3e1 * t237 * t108 * t1036 - t1781 + 0.60e2 * t178 * t172 - 0.24e2 * t234 * t238 + t1978 - t1992 - t1996 + t2000 + 0.73246220147012639765228919932558287780546586655172e-3 * t109 * t94 - 0.54934665110259479823921689949418715835409939991379e-3 * t228 * t1 * t111 - 0.56969282336565386484066937725323112718202900731800e-3 * t80 * t34 * t1490 * t92
  t2427 = f.my_piecewise3(t1297, 0, 0.4e1 * t1298 * t209 * t1299 + 0.8e1 / 0.3e1 * t1303 * t117 * t1305 - 0.4e1 / 0.9e1 * t1365 * t193 * t1367)
  t2432 = t75 * t97
  t2435 = t1240 * t1243
  t2441 = t97 * t1240
  t2446 = 0.1e1 / t1239 / t1228
  t2448 = t1243 ** 2
  t2454 = 0.2e1 * r0 * t209 - 0.2e1 * t97
  t2459 = f.my_piecewise3(t1230, 0, -0.4e1 * t2432 * t1232 + 0.4e1 / 0.3e1 * t1231 * t2435 + 0.4e1 * t1235 * t209 * t1232 - 0.4e1 / 0.3e1 * t1235 * t2441 * t1243 - 0.4e1 / 0.9e1 * t1235 * t60 * t2446 * t2448 + 0.2e1 / 0.3e1 * t1235 * t1241 * t2454)
  t2465 = 0.8085e0 + 0.73502e-1 * t1172 * t1253 + 0.171820e-2 * t1173 * t1272
  t2469 = 0.3e1 / 0.8e1 * t1218 * t1222 - 0.9e1 / 0.8e1 * t1227 * t1249 * t1291 + t1227 * t1310 * t46 * t1324 / 0.4e1 - 0.3e1 / 0.4e1 * t1338 * t1341 - 0.3e1 / 0.4e1 * t1355 * t1341 - 0.3e1 / 0.8e1 * t1227 * t1382 * t9 * t1324 - 0.3e1 / 0.8e1 * t1227 * t1391 * t1291 - 0.3e1 / 0.8e1 * t1227 * t1395 * t1461 + 0.3e1 / 0.4e1 * t1465 * t1222 + 0.3e1 * t1040 * t1476 + t1781 * t1791 * t1798 + (t2019 + t2078 + t2396 + t2413) * t1089 - 0.3e1 / 0.8e1 * t1227 * t2427 * t24 * t1324 - 0.3e1 / 0.8e1 * t1227 * t2459 * t24 * t2465
  t2470 = t1248 * t24
  t2479 = -0.40834444444444444444444444444444444444444444444444e-1 * t1344 * t1254 + 0.49409677777777777777777777777777777777777777777776e-3 * t1269 * t1347 - 0.19091111111111111111111111111111111111111111111111e-2 * t1280 * t1347 + 0.23100244444444444444444444444444444444444444444444e-4 * t1288 * t1347
  t2483 = t1390 * t46
  t2531 = 0.12e2 * t75 * t209 * t1232 - 0.4e1 * t2432 * t2435 - 0.4e1 / 0.3e1 * t1231 * t2446 * t2448 + 0.2e1 * t1231 * t1240 * t2454 - 0.12e2 * t1235 * t117 * t1232 + 0.4e1 * t1235 * t209 * t1240 * t1243 + 0.4e1 / 0.3e1 * t1235 * t97 * t2446 * t2448 - 0.2e1 * t1235 * t2441 * t2454 + 0.20e2 / 0.27e2 * t1235 * t60 / t1239 / t1046 / t97 * t2448 * t1243 - 0.4e1 / 0.3e1 * t1235 * t60 * t2446 * t1243 * t2454 + 0.2e1 / 0.3e1 * t1235 * t1241 * (-0.6e1 * r0 * t117 + 0.6e1 * t209)
  t2532 = f.my_piecewise3(t1230, 0, t2531)
  t2537 = t2459 * t9
  t2544 = f.my_piecewise3(t1297, t65, 0.2e1 * t1298 * t60 * t1299)
  t2557 = t1097 * t1337
  t2563 = t960 * t1337
  t2582 = f.my_piecewise3(t298, 0, t367 * t364 / 0.2e1 + t457 * t455 / 0.2e1)
  t2583 = t148 + t153 + 0.4e1 * t118 * t186 - 0.4e1 * t234 * t186 + t237 * t231 + t237 * t172 + 0.19751789702565206228825776161588751761046270558698e-1 * t108 * t183 - 0.18311555036753159941307229983139571945136646663793e-3 * t80 * t111 - 0.58482233974552040708313425006184496242808878304903e0 * t246 * t199 - t1332 - t2582
  t2602 = t1138 ** 2
  t2632 = 0.13380264343703703703703703703703703703703703703704e-4 * t1162 * t1125 * t1398 - 0.17315402222222222222222222222222222222222222222222e-2 * t1145 * t1422 + 0.87074814814814814814814814814814814814814814814818e-2 * t1427 * t1149 * t1114 - 0.10448977777777777777777777777777777777777777777778e-1 * t1156 * t1422 + 0.20479996444444444444444444444444444444444444444445e-3 * t1165 * t1422 - 0.66901321718518518518518518518518518518518518518521e-4 * t1137 * t1161 * t1438 + 0.87417727045530864197530864197530864197530864197535e-6 * t1159 * t1078 / t2602 * t1438 + 0.88343888888888888888888888888888888888888888888889e-1 * t1421 * t1116 + 0.28281823629629629629629629629629629629629629629630e-3 * t1438 * t1140 * t1079 - 0.46193645261728395061728395061728395061728395061731e-5 * t1159 / t1082 / t1160 * t1438 + 0.11377775802469135802469135802469135802469135802469e-2 * t1438 * t1152 * t1078 + 0.43288505555555555555555555555555555555555555555556e-2 * t1398 * t1132 * t1078 * t1125 - 0.84845470888888888888888888888888888888888888888890e-4 * t1141 * t1125 * t1398 - 0.85333318518518518518518518518518518518518518518519e-3 * t1153 * t1125 * t1398 - 0.24049169753086419753086419753086419753086419753087e-2 * t1438 * t1132
  t2639 = 0.1e1 - s0 / r0 * t1221 / 0.8e1
  t2685 = t1188 ** 2
  t2690 = -0.21863537777777777777777777777777777777777777777777e1 * t1194 * t1422 + 0.42775703703703703703703703703703703703703703703702e1 * t1427 * t1198 * t1114 - 0.25665422222222222222222222222222222222222222222222e1 * t1205 * t1422 + 0.65703480888888888888888888888888888888888888888888e1 * t1214 * t1422 - 0.12146409876543209876543209876543209876543209876543e2 * t1438 * t1182 + 0.10931768888888888888888888888888888888888888888889e2 * t1398 * t1182 * t1172 * t1125 - 0.27985328355555555555555555555555555555555555555554e2 * t1191 * t1125 * t1398 - 0.54752900740740740740740740740740740740740740740740e2 * t1202 * t1125 * t1398 + 0.11213394071703703703703703703703703703703703703703e3 * t1211 * t1125 * t1398 + 0.85404444444444444444444444444444444444444444444445e0 * t1421 * t1178 + 0.18656885570370370370370370370370370370370370370369e3 * t1438 * t1190 * t1173 - 0.39801355883456790123456790123456790123456790123453e3 * t1208 / t1176 / t1209 * t1438 + 0.14600773530864197530864197530864197530864197530864e3 * t1438 * t1201 * t1172 - 0.11213394071703703703703703703703703703703703703703e4 * t1187 * t1210 * t1438 + 0.19137525882374320987654320987654320987654320987653e4 * t1453 / t2685 * t1438
  t2695 = -0.3e1 / 0.4e1 * t1227 * t2470 * t2479 + t1227 * t2483 * t2479 / 0.4e1 - 0.3e1 / 0.8e1 * t1227 * t2532 * t9 * t2465 - 0.9e1 / 0.8e1 * t1227 * t2537 * t2479 - 0.5e1 / 0.36e2 * t1227 * t2544 * t261 * t1324 + t1227 * t1248 * t46 * t2465 / 0.4e1 - 0.5e1 / 0.36e2 * t1227 * t1390 * t261 * t2465 + 0.3e1 / 0.4e1 * t2557 * s0 / t1107 * t1221 + 0.3e1 / 0.8e1 * t2563 * t1222 + 0.3e1 * t2583 * t1168 + t1101 * t2632 + 0.3e1 * t1332 * t1217 * t2639 + 0.3e1 * t960 * t1354 * t2639 + t1097 * t2690 * t2639 + t2372 * t1337 * t2639
  d111 = 0.3e1 * t1040 * t1089 + 0.3e1 * t1101 * t1168 + t8 * (t2469 + t2695) - 0.3e1 / 0.4e1 * t2557 * t1341 + 0.3e1 * t1218 * t2639 + 0.3e1 * t636 * t1791 * t1798 - 0.3e1 / 0.4e1 * t1227 * t1391 * t2479 - 0.9e1 / 0.8e1 * t1227 * t1395 * t1291 - 0.9e1 / 0.8e1 * t1227 * t2427 * t9 * t1324 + 0.3e1 / 0.4e1 * t1338 * t1222 - 0.9e1 / 0.4e1 * t1227 * t1249 * t2479 + 0.6e1 * t2583 * t1476 + 0.3e1 / 0.4e1 * t1355 * t1222 - 0.3e1 / 0.4e1 * t1227 * t2470 * t2465 + t1227 * t2483 * t2465 / 0.4e1 - 0.9e1 / 0.8e1 * t1227 * t2537 * t2465 - 0.3e1 / 0.4e1 * t1227 * t1310 * t24 * t1324 + t1227 * t2544 * t46 * t1324 / 0.4e1 + 0.3e1 * t2563 * t2639 + 0.6e1 * t1465 * t2639

  res = {'v3rho3': d111}
  return res
