"""Generated from mgga_xc_zlp.mpl."""

import jax
import jax.lax as lax
import jax.numpy as jnp
import numpy as np
from jax.numpy import array as array
from jax.numpy import int32 as int32
from jax.numpy import nan as nan
from typing import Callable, Optional
from jxc.functionals.utils import *

def pol(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t11 = r0 + r1
  t12 = t11 ** 2
  t13 = t11 ** (0.1e1 / 0.3e1)
  t14 = t13 ** 2
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t25 = (r0 - r1) / t11
  t27 = 0.1e1 / 0.2e1 + t25 / 0.2e1
  t28 = t27 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t32 = r1 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t38 = 0.1e1 / 0.2e1 - t25 / 0.2e1
  t39 = t38 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t52 = jnp.log(0.1e1 + 0.48849425066691677572300812805583684682823125513224e3 / t13)
  t57 = t1 ** 2
  res = -(0.207108 * t4 * t6 + 0.5387725e-2 * t4 * t6 * ((s0 + 0.2e1 * s1 + s2) / t14 / t12 / 0.8e1 - l0 / t19 / r0 * t29 * t27 / 0.8e1 - l1 / t33 / r1 * t40 * t38 / 0.8e1)) * (0.1e1 - 0.2047107e-2 * t52 * t13) * t57 / t3 * t5 * t13 / 0.3e1
  return res

def unpol(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t9 = r0 ** 2
  t10 = r0 ** (0.1e1 / 0.3e1)
  t11 = t10 ** 2
  t27 = jnp.log(0.1e1 + 0.48849425066691677572300812805583684682823125513224e3 / t10)
  t32 = t1 ** 2
  res = -(0.207108 * t4 * t6 + 0.5387725e-2 * t4 * t6 * (s0 / t11 / t9 / 0.8e1 - l0 / t11 / r0 / 0.8e1)) * (0.1e1 - 0.2047107e-2 * t27 * t10) * t32 / t3 * t5 * t10 / 0.3e1
  return res

def unpol_fxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  
  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t3 = 0.1e1 / t2
  t4 = 3 ** (0.1e1 / 0.3e1)
  t6 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t7 = t4 * t6
  t8 = 4 ** (0.1e1 / 0.3e1)
  t9 = t8 ** 2
  t12 = r0 ** 2
  t14 = 0.1e1 / t2 / t12
  t17 = 0.1e1 / t2 / r0
  t24 = 0.20710800000000000000000000000000000000000000000000e0 * t7 * t9 + 0.53877250000000000000000000000000000000000000000000e-2 * t7 * t9 * (-l0 * t17 / 0.8e1 + s0 * t14 / 0.8e1)
  t28 = 0.1e1 + 0.48849425066691677572300812805583684682823125513224e3 / t1
  t29 = jnp.log(t28)
  t32 = 0.1e1 - 0.20471070000000000000000000000000000000000000000000e-2 * t29 * t1
  t34 = t4 ** 2
  t37 = t34 / t6 * t8
  t42 = 0.1e1 / t2 / t12 / r0
  t47 = -s0 * t42 / 0.3e1 + 0.5e1 / 0.24e2 * l0 * t14
  t53 = 0.1e1 / t28
  t58 = 0.33333333333333333333333333333333333333333333333334e0 / r0 * t53 - 0.68236900000000000000000000000000000000000000000000e-3 * t29 * t3
  t62 = t1 * r0
  t63 = t12 ** 2
  t83 = t28 ** 2
  v2rho2_0_ = -0.4e1 / 0.27e2 * t3 * t24 * t32 * t37 - 0.57469066666666666666666666666666666666666666666666e-1 * t1 * t47 * t32 - 0.8e1 / 0.9e1 * t1 * t24 * t58 * t37 - 0.21550900000000000000000000000000000000000000000000e-1 * t62 * (0.11e2 / 0.9e1 * s0 / t2 / t63 - 0.5e1 / 0.9e1 * l0 * t42) * t32 - 0.43101800000000000000000000000000000000000000000000e-1 * t62 * t47 * t58 - t62 * t24 * (-0.22222222222222222222222222222222222222222222222223e0 / t12 * t53 + 0.54277138962990752858112014228426316314247917236918e2 / t1 / t12 / t83 + 0.45491266666666666666666666666666666666666666666667e-3 * t29 * t17) * t37 / 0.3e1
  res = {'v2rho2': v2rho2_0_}
  return res

def unpol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t4 = 0.1e1 / t2 / r0
  t5 = 3 ** (0.1e1 / 0.3e1)
  t7 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t8 = t5 * t7
  t9 = 4 ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t13 = r0 ** 2
  t15 = 0.1e1 / t2 / t13
  t23 = 0.20710800000000000000000000000000000000000000000000e0 * t8 * t10 + 0.53877250000000000000000000000000000000000000000000e-2 * t8 * t10 * (-l0 * t4 / 0.8e1 + s0 * t15 / 0.8e1)
  t27 = 0.1e1 + 0.48849425066691677572300812805583684682823125513224e3 / t1
  t28 = jnp.log(t27)
  t31 = 0.1e1 - 0.20471070000000000000000000000000000000000000000000e-2 * t28 * t1
  t33 = t5 ** 2
  t36 = t33 / t7 * t9
  t39 = 0.1e1 / t2
  t40 = t13 * r0
  t42 = 0.1e1 / t2 / t40
  t47 = -s0 * t42 / 0.3e1 + 0.5e1 / 0.24e2 * l0 * t15
  t53 = 0.1e1 / t27
  t58 = 0.33333333333333333333333333333333333333333333333334e0 / r0 * t53 - 0.68236900000000000000000000000000000000000000000000e-3 * t28 * t39
  t62 = t13 ** 2
  t64 = 0.1e1 / t2 / t62
  t69 = 0.11e2 / 0.9e1 * s0 * t64 - 0.5e1 / 0.9e1 * l0 * t42
  t82 = t27 ** 2
  t83 = 0.1e1 / t82
  t88 = -0.22222222222222222222222222222222222222222222222223e0 / t13 * t53 + 0.54277138962990752858112014228426316314247917236918e2 / t1 / t13 * t83 + 0.45491266666666666666666666666666666666666666666667e-3 * t28 * t4
  t92 = t1 * r0
  v3rho3_0_ = 0.8e1 / 0.81e2 * t4 * t23 * t31 * t36 - 0.28734533333333333333333333333333333333333333333333e-1 * t39 * t47 * t31 - 0.4e1 / 0.9e1 * t39 * t23 * t58 * t36 - 0.86203599999999999999999999999999999999999999999999e-1 * t1 * t69 * t31 - 0.17240720000000000000000000000000000000000000000000e0 * t1 * t47 * t58 - 0.4e1 / 0.3e1 * t1 * t23 * t88 * t36 - 0.21550900000000000000000000000000000000000000000000e-1 * t92 * (-0.154e3 / 0.27e2 * s0 / t2 / t62 / r0 + 0.55e2 / 0.27e2 * l0 * t64) * t31 - 0.64652700000000000000000000000000000000000000000000e-1 * t92 * t69 * t58 - 0.64652700000000000000000000000000000000000000000000e-1 * t92 * t47 * t88 - t92 * t23 * (0.37037037037037037037037037037037037037037037037038e0 / t40 * t53 - 0.16283141688897225857433604268527894894274375171076e3 / t1 / t40 * t83 + 0.17676046884046853391350823130211339323981898108540e5 * t42 / t82 / t27 - 0.75818777777777777777777777777777777777777777777778e-3 * t28 * t15) * t36 / 0.3e1

  res = {'v3rho3': v3rho3_0_}
  return res

def unpol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau

  t1 = r0 ** (0.1e1 / 0.3e1)
  t2 = t1 ** 2
  t4 = 0.1e1 / t2 / r0
  t5 = r0 ** 2
  t6 = t5 * r0
  t8 = 0.1e1 / t2 / t6
  t12 = 0.1e1 / t2 / t5
  t15 = -s0 * t8 / 0.3e1 + 0.5e1 / 0.24e2 * l0 * t12
  t19 = 0.1e1 + 0.48849425066691677572300812805583684682823125513224e3 / t1
  t20 = jnp.log(t19)
  t23 = 0.1e1 - 0.20471070000000000000000000000000000000000000000000e-2 * t20 * t1
  t26 = 0.1e1 / t2
  t27 = t5 ** 2
  t29 = 0.1e1 / t2 / t27
  t34 = 0.11e2 / 0.9e1 * s0 * t29 - 0.5e1 / 0.9e1 * l0 * t8
  t40 = 0.1e1 / t19
  t45 = 0.33333333333333333333333333333333333333333333333334e0 / r0 * t40 - 0.68236900000000000000000000000000000000000000000000e-3 * t20 * t26
  t48 = t27 * r0
  t50 = 0.1e1 / t2 / t48
  t55 = -0.154e3 / 0.27e2 * s0 * t50 + 0.55e2 / 0.27e2 * l0 * t29
  t68 = t19 ** 2
  t69 = 0.1e1 / t68
  t74 = -0.22222222222222222222222222222222222222222222222223e0 / t5 * t40 + 0.54277138962990752858112014228426316314247917236918e2 / t1 / t5 * t69 + 0.45491266666666666666666666666666666666666666666667e-3 * t20 * t4
  t77 = t1 * r0
  t104 = 0.1e1 / t68 / t19
  t109 = 0.37037037037037037037037037037037037037037037037038e0 / t6 * t40 - 0.16283141688897225857433604268527894894274375171076e3 / t1 / t6 * t69 + 0.17676046884046853391350823130211339323981898108540e5 * t8 * t104 - 0.75818777777777777777777777777777777777777777777778e-3 * t20 * t12
  t112 = 3 ** (0.1e1 / 0.3e1)
  t114 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t115 = t112 * t114
  t116 = 4 ** (0.1e1 / 0.3e1)
  t117 = t116 ** 2
  t127 = 0.20710800000000000000000000000000000000000000000000e0 * t115 * t117 + 0.53877250000000000000000000000000000000000000000000e-2 * t115 * t117 * (-l0 * t4 / 0.8e1 + s0 * t12 / 0.8e1)
  t130 = t112 ** 2
  t133 = t130 / t114 * t116
  t155 = t68 ** 2
  v4rho4_0_ = 0.25541807407407407407407407407407407407407407407407e-1 * t4 * t15 * t23 - 0.57469066666666666666666666666666666666666666666666e-1 * t26 * t34 * t23 - 0.11493813333333333333333333333333333333333333333333e0 * t26 * t15 * t45 - 0.11493813333333333333333333333333333333333333333333e0 * t1 * t55 * t23 - 0.34481440000000000000000000000000000000000000000000e0 * t1 * t34 * t45 - 0.34481440000000000000000000000000000000000000000000e0 * t1 * t15 * t74 - 0.21550900000000000000000000000000000000000000000000e-1 * t77 * (0.2618e4 / 0.81e2 * s0 / t2 / t27 / t5 - 0.770e3 / 0.81e2 * l0 * t50) * t23 - 0.86203600000000000000000000000000000000000000000000e-1 * t77 * t55 * t45 - 0.12930540000000000000000000000000000000000000000000e0 * t77 * t34 * t74 - 0.86203600000000000000000000000000000000000000000000e-1 * t77 * t15 * t109 + 0.32e2 / 0.81e2 * t4 * t127 * t45 * t133 - 0.8e1 / 0.9e1 * t26 * t127 * t74 * t133 - 0.16e2 / 0.9e1 * t1 * t127 * t109 * t133 - t77 * t127 * (-0.98765432098765432098765432098765432098765432098764e0 / t27 * t40 + 0.60307932181100836509013349142695907015831019152133e3 / t1 / t27 * t69 - 0.11784031256031235594233882086807559549321265405694e6 * t29 * t104 + 0.86346472773757568077051288135946676573241643492696e7 / t48 / t155 + 0.20218340740740740740740740740740740740740740740741e-2 * t20 * t8) * t133 / 0.3e1 - 0.40e2 / 0.243e3 * t12 * t127 * t23 * t133

  res = {'v4rho4': v4rho4_0_}
  return res

def pol_fxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  
  t1 = r0 + r1
  t2 = t1 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t4 = 0.1e1 / t3
  t5 = 3 ** (0.1e1 / 0.3e1)
  t7 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t8 = t5 * t7
  t9 = 4 ** (0.1e1 / 0.3e1)
  t10 = t9 ** 2
  t14 = s0 + 0.2e1 * s1 + s2
  t15 = t1 ** 2
  t19 = r0 ** (0.1e1 / 0.3e1)
  t20 = t19 ** 2
  t23 = l0 / t20 / r0
  t24 = r0 - r1
  t25 = 0.1e1 / t1
  t26 = t24 * t25
  t28 = 0.1e1 / 0.2e1 + t26 / 0.2e1
  t29 = t28 ** (0.1e1 / 0.3e1)
  t30 = t29 ** 2
  t31 = t30 * t28
  t33 = r1 ** (0.1e1 / 0.3e1)
  t34 = t33 ** 2
  t37 = l1 / t34 / r1
  t39 = 0.1e1 / 0.2e1 - t26 / 0.2e1
  t40 = t39 ** (0.1e1 / 0.3e1)
  t41 = t40 ** 2
  t42 = t41 * t39
  t49 = 0.20710800000000000000000000000000000000000000000000e0 * t8 * t10 + 0.53877250000000000000000000000000000000000000000000e-2 * t8 * t10 * (t14 / t3 / t15 / 0.8e1 - t23 * t31 / 0.8e1 - t37 * t42 / 0.8e1)
  t53 = 0.1e1 + 0.48849425066691677572300812805583684682823125513224e3 / t2
  t54 = jnp.log(t53)
  t57 = 0.1e1 - 0.20471070000000000000000000000000000000000000000000e-2 * t54 * t2
  t59 = t5 ** 2
  t62 = t59 / t7 * t9
  t64 = 0.4e1 / 0.27e2 * t4 * t49 * t57 * t62
  t65 = t15 * t1
  t69 = t14 / t3 / t65 / 0.3e1
  t70 = r0 ** 2
  t73 = l0 / t20 / t70
  t76 = 0.1e1 / t15
  t77 = t24 * t76
  t79 = t25 / 0.2e1 - t77 / 0.2e1
  t80 = t30 * t79
  t83 = -t79
  t84 = t41 * t83
  t87 = -t69 + 0.5e1 / 0.24e2 * t73 * t31 - 0.5e1 / 0.24e2 * t23 * t80 - 0.5e1 / 0.24e2 * t37 * t84
  t89 = t2 * t87 * t57
  t92 = 0.1e1 / t53
  t97 = 0.33333333333333333333333333333333333333333333333334e0 * t25 * t92 - 0.68236900000000000000000000000000000000000000000000e-3 * t54 * t4
  t100 = 0.8e1 / 0.9e1 * t2 * t49 * t97 * t62
  t101 = t2 * t1
  t102 = t15 ** 2
  t106 = 0.11e2 / 0.9e1 * t14 / t3 / t102
  t115 = 0.1e1 / t29
  t116 = t79 ** 2
  t120 = 0.1e1 / t65
  t121 = t24 * t120
  t122 = -t76 + t121
  t126 = 0.1e1 / t40
  t127 = t83 ** 2
  t140 = t101 * t87 * t97
  t147 = t53 ** 2
  t158 = t101 * t49 * (-0.22222222222222222222222222222222222222222222222223e0 * t76 * t92 + 0.54277138962990752858112014228426316314247917236918e2 / t2 / t15 / t147 + 0.45491266666666666666666666666666666666666666666667e-3 * t54 / t3 / t1) * t62 / 0.3e1
  d11 = -t64 - 0.57469066666666666666666666666666666666666666666666e-1 * t89 - t100 - 0.21550900000000000000000000000000000000000000000000e-1 * t101 * (t106 - 0.5e1 / 0.9e1 * l0 / t20 / t70 / r0 * t31 + 0.25e2 / 0.36e2 * t73 * t80 - 0.5e1 / 0.36e2 * t23 * t115 * t116 - 0.5e1 / 0.24e2 * t23 * t30 * t122 - 0.5e1 / 0.36e2 * t37 * t126 * t127 + 0.5e1 / 0.24e2 * t37 * t41 * t122) * t57 - 0.43101800000000000000000000000000000000000000000000e-1 * t140 - t158
  t161 = -t25 / 0.2e1 - t77 / 0.2e1
  t162 = t30 * t161
  t165 = r1 ** 2
  t168 = l1 / t34 / t165
  t171 = -t161
  t172 = t41 * t171
  t175 = -t69 - 0.5e1 / 0.24e2 * t23 * t162 + 0.5e1 / 0.24e2 * t168 * t42 - 0.5e1 / 0.24e2 * t37 * t172
  t177 = t2 * t175 * t57
  t204 = t101 * t175 * t97
  d12 = -t64 - 0.28734533333333333333333333333333333333333333333333e-1 * t89 - t100 - 0.28734533333333333333333333333333333333333333333333e-1 * t177 - 0.21550900000000000000000000000000000000000000000000e-1 * t101 * (t106 + 0.25e2 / 0.72e2 * t73 * t162 - 0.5e1 / 0.36e2 * t23 * t115 * t161 * t79 - 0.5e1 / 0.24e2 * t23 * t30 * t24 * t120 + 0.25e2 / 0.72e2 * t168 * t84 - 0.5e1 / 0.36e2 * t37 * t126 * t171 * t83 + 0.5e1 / 0.24e2 * t37 * t41 * t24 * t120) * t57 - 0.21550900000000000000000000000000000000000000000000e-1 * t204 - 0.21550900000000000000000000000000000000000000000000e-1 * t140 - t158
  t208 = t161 ** 2
  t212 = t76 + t121
  t224 = t171 ** 2
  d22 = -t64 - 0.57469066666666666666666666666666666666666666666666e-1 * t177 - t100 - 0.21550900000000000000000000000000000000000000000000e-1 * t101 * (t106 - 0.5e1 / 0.36e2 * t23 * t115 * t208 - 0.5e1 / 0.24e2 * t23 * t30 * t212 - 0.5e1 / 0.9e1 * l1 / t34 / t165 / r1 * t42 + 0.25e2 / 0.36e2 * t168 * t172 - 0.5e1 / 0.36e2 * t37 * t126 * t224 + 0.5e1 / 0.24e2 * t37 * t41 * t212) * t57 - 0.43101800000000000000000000000000000000000000000000e-1 * t204 - t158
  res = {'v2rho2': jnp.stack([d11, d12, d22], axis=-1) if 'd12' in locals() else d11}
  return res

def pol_kxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 + r1
  t2 = t1 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t5 = 0.1e1 / t3 / t1
  t6 = 3 ** (0.1e1 / 0.3e1)
  t8 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t9 = t6 * t8
  t10 = 4 ** (0.1e1 / 0.3e1)
  t11 = t10 ** 2
  t15 = s0 + 0.2e1 * s1 + s2
  t16 = t1 ** 2
  t18 = 0.1e1 / t3 / t16
  t20 = r0 ** (0.1e1 / 0.3e1)
  t21 = t20 ** 2
  t24 = l0 / t21 / r0
  t25 = r0 - r1
  t26 = 0.1e1 / t1
  t27 = t25 * t26
  t29 = 0.1e1 / 0.2e1 + t27 / 0.2e1
  t30 = t29 ** (0.1e1 / 0.3e1)
  t31 = t30 ** 2
  t32 = t31 * t29
  t34 = r1 ** (0.1e1 / 0.3e1)
  t35 = t34 ** 2
  t38 = l1 / t35 / r1
  t40 = 0.1e1 / 0.2e1 - t27 / 0.2e1
  t41 = t40 ** (0.1e1 / 0.3e1)
  t42 = t41 ** 2
  t50 = 0.20710800000000000000000000000000000000000000000000e0 * t9 * t11 + 0.53877250000000000000000000000000000000000000000000e-2 * t9 * t11 * (-t38 * t42 * t40 / 0.8e1 + t15 * t18 / 0.8e1 - t24 * t32 / 0.8e1)
  t54 = 0.1e1 + 0.48849425066691677572300812805583684682823125513224e3 / t2
  t55 = jnp.log(t54)
  t58 = 0.1e1 - 0.20471070000000000000000000000000000000000000000000e-2 * t55 * t2
  t60 = t6 ** 2
  t63 = t60 / t8 * t10
  t66 = 0.1e1 / t3
  t67 = t16 * t1
  t69 = 0.1e1 / t3 / t67
  t72 = r0 ** 2
  t75 = l0 / t21 / t72
  t78 = 0.1e1 / t16
  t81 = -t25 * t78 / 0.2e1 + t26 / 0.2e1
  t82 = t31 * t81
  t85 = -t81
  t89 = -t15 * t69 / 0.3e1 + 0.5e1 / 0.24e2 * t75 * t32 - 0.5e1 / 0.24e2 * t24 * t82 - 0.5e1 / 0.24e2 * t38 * t42 * t85
  t94 = 0.1e1 / t54
  t99 = 0.33333333333333333333333333333333333333333333333334e0 * t26 * t94 - 0.68236900000000000000000000000000000000000000000000e-3 * t55 * t66
  t103 = t16 ** 2
  t111 = l0 / t21 / t72 / r0
  t116 = 0.1e1 / t30
  t117 = t81 ** 2
  t118 = t116 * t117
  t121 = 0.1e1 / t67
  t123 = t25 * t121 - t78
  t124 = t31 * t123
  t127 = 0.1e1 / t41
  t128 = t85 ** 2
  t132 = -t123
  t136 = 0.11e2 / 0.9e1 * t15 / t3 / t103 - 0.5e1 / 0.9e1 * t111 * t32 + 0.25e2 / 0.36e2 * t75 * t82 - 0.5e1 / 0.36e2 * t24 * t118 - 0.5e1 / 0.24e2 * t24 * t124 - 0.5e1 / 0.36e2 * t38 * t127 * t128 - 0.5e1 / 0.24e2 * t38 * t42 * t132
  t148 = t54 ** 2
  t149 = 0.1e1 / t148
  t154 = -0.22222222222222222222222222222222222222222222222223e0 * t78 * t94 + 0.54277138962990752858112014228426316314247917236918e2 / t2 / t16 * t149 + 0.45491266666666666666666666666666666666666666666667e-3 * t55 * t5
  t158 = t2 * t1
  t164 = t72 ** 2
  t189 = 0.3e1 * t121 - 0.3e1 * t25 / t103
  t207 = -0.154e3 / 0.27e2 * t15 / t3 / t103 / t1 + 0.55e2 / 0.27e2 * l0 / t21 / t164 * t32 - 0.25e2 / 0.9e1 * t111 * t82 + 0.25e2 / 0.36e2 * t75 * t118 + 0.25e2 / 0.24e2 * t75 * t124 + 0.5e1 / 0.108e3 * t24 / t30 / t29 * t117 * t81 - 0.5e1 / 0.12e2 * t24 * t116 * t81 * t123 - 0.5e1 / 0.24e2 * t24 * t31 * t189 + 0.5e1 / 0.108e3 * t38 / t41 / t40 * t128 * t85 - 0.5e1 / 0.12e2 * t38 * t127 * t85 * t132 + 0.5e1 / 0.24e2 * t38 * t42 * t189
  d111 = 0.8e1 / 0.81e2 * t5 * t50 * t58 * t63 - 0.28734533333333333333333333333333333333333333333333e-1 * t66 * t89 * t58 - 0.4e1 / 0.9e1 * t66 * t50 * t99 * t63 - 0.86203599999999999999999999999999999999999999999999e-1 * t2 * t136 * t58 - 0.17240720000000000000000000000000000000000000000000e0 * t2 * t89 * t99 - 0.4e1 / 0.3e1 * t2 * t50 * t154 * t63 - 0.21550900000000000000000000000000000000000000000000e-1 * t158 * t207 * t58 - 0.64652700000000000000000000000000000000000000000000e-1 * t158 * t136 * t99 - 0.64652700000000000000000000000000000000000000000000e-1 * t158 * t89 * t154 - t158 * t50 * (0.37037037037037037037037037037037037037037037037038e0 * t121 * t94 - 0.16283141688897225857433604268527894894274375171076e3 / t2 / t67 * t149 + 0.17676046884046853391350823130211339323981898108540e5 * t69 / t148 / t54 - 0.75818777777777777777777777777777777777777777777778e-3 * t55 * t18) * t63 / 0.3e1

  res = {'v3rho3': d111}
  return res

def pol_lxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  (r0, r1) = r
  s0 = s[0] if s is not None else None
  s1 = s[1] if s is not None else None
  s2 = s[2] if s is not None else None
  l0 = l[0] if l is not None else None
  l1 = l[1] if l is not None else None
  tau0 = tau[0] if tau is not None else None
  tau1 = tau[1] if tau is not None else None

  t1 = r0 + r1
  t2 = t1 ** (0.1e1 / 0.3e1)
  t3 = t2 ** 2
  t5 = 0.1e1 / t3 / t1
  t7 = s0 + 0.2e1 * s1 + s2
  t8 = t1 ** 2
  t9 = t8 * t1
  t11 = 0.1e1 / t3 / t9
  t14 = r0 ** 2
  t15 = r0 ** (0.1e1 / 0.3e1)
  t16 = t15 ** 2
  t19 = l0 / t16 / t14
  t20 = r0 - r1
  t21 = 0.1e1 / t1
  t22 = t20 * t21
  t24 = 0.1e1 / 0.2e1 + t22 / 0.2e1
  t25 = t24 ** (0.1e1 / 0.3e1)
  t26 = t25 ** 2
  t27 = t26 * t24
  t32 = l0 / t16 / r0
  t33 = 0.1e1 / t8
  t36 = -t20 * t33 / 0.2e1 + t21 / 0.2e1
  t37 = t26 * t36
  t40 = r1 ** (0.1e1 / 0.3e1)
  t41 = t40 ** 2
  t44 = l1 / t41 / r1
  t46 = 0.1e1 / 0.2e1 - t22 / 0.2e1
  t47 = t46 ** (0.1e1 / 0.3e1)
  t48 = t47 ** 2
  t49 = -t36
  t53 = -t7 * t11 / 0.3e1 + 0.5e1 / 0.24e2 * t19 * t27 - 0.5e1 / 0.24e2 * t32 * t37 - 0.5e1 / 0.24e2 * t44 * t48 * t49
  t57 = 0.1e1 + 0.48849425066691677572300812805583684682823125513224e3 / t2
  t58 = jnp.log(t57)
  t61 = 0.1e1 - 0.20471070000000000000000000000000000000000000000000e-2 * t58 * t2
  t64 = 0.1e1 / t3
  t65 = t8 ** 2
  t67 = 0.1e1 / t3 / t65
  t73 = l0 / t16 / t14 / r0
  t78 = 0.1e1 / t25
  t79 = t36 ** 2
  t80 = t78 * t79
  t83 = 0.1e1 / t9
  t85 = t20 * t83 - t33
  t86 = t26 * t85
  t89 = 0.1e1 / t47
  t90 = t49 ** 2
  t94 = -t85
  t98 = 0.11e2 / 0.9e1 * t7 * t67 - 0.5e1 / 0.9e1 * t73 * t27 + 0.25e2 / 0.36e2 * t19 * t37 - 0.5e1 / 0.36e2 * t32 * t80 - 0.5e1 / 0.24e2 * t32 * t86 - 0.5e1 / 0.36e2 * t44 * t89 * t90 - 0.5e1 / 0.24e2 * t44 * t48 * t94
  t103 = 0.1e1 / t57
  t108 = 0.33333333333333333333333333333333333333333333333334e0 * t21 * t103 - 0.68236900000000000000000000000000000000000000000000e-3 * t58 * t64
  t111 = t65 * t1
  t116 = t14 ** 2
  t119 = l0 / t16 / t116
  t129 = 0.1e1 / t25 / t24
  t131 = t129 * t79 * t36
  t134 = t78 * t36
  t135 = t134 * t85
  t138 = 0.1e1 / t65
  t141 = -0.3e1 * t20 * t138 + 0.3e1 * t83
  t142 = t26 * t141
  t146 = 0.1e1 / t47 / t46
  t151 = t89 * t49
  t155 = -t141
  t159 = -0.154e3 / 0.27e2 * t7 / t3 / t111 + 0.55e2 / 0.27e2 * t119 * t27 - 0.25e2 / 0.9e1 * t73 * t37 + 0.25e2 / 0.36e2 * t19 * t80 + 0.25e2 / 0.24e2 * t19 * t86 + 0.5e1 / 0.108e3 * t32 * t131 - 0.5e1 / 0.12e2 * t32 * t135 - 0.5e1 / 0.24e2 * t32 * t142 + 0.5e1 / 0.108e3 * t44 * t146 * t90 * t49 - 0.5e1 / 0.12e2 * t44 * t151 * t94 - 0.5e1 / 0.24e2 * t44 * t48 * t155
  t171 = t57 ** 2
  t172 = 0.1e1 / t171
  t177 = -0.22222222222222222222222222222222222222222222222223e0 * t33 * t103 + 0.54277138962990752858112014228426316314247917236918e2 / t2 / t8 * t172 + 0.45491266666666666666666666666666666666666666666667e-3 * t58 * t5
  t180 = t2 * t1
  t187 = t24 ** 2
  t190 = t79 ** 2
  t198 = t85 ** 2
  t205 = t46 ** 2
  t208 = t90 ** 2
  t216 = t94 ** 2
  t235 = 0.1e1 / t111
  t238 = 0.12e2 * t20 * t235 - 0.12e2 * t138
  t251 = -0.100e3 / 0.27e2 * t73 * t80 - 0.25e2 / 0.81e2 * t19 * t131 + 0.25e2 / 0.9e1 * t19 * t135 - 0.5e1 / 0.81e2 * t32 / t25 / t187 * t190 + 0.5e1 / 0.18e2 * t32 * t129 * t79 * t85 - 0.5e1 / 0.12e2 * t32 * t78 * t198 - 0.5e1 / 0.9e1 * t32 * t134 * t141 - 0.5e1 / 0.81e2 * t44 / t47 / t205 * t208 + 0.5e1 / 0.18e2 * t44 * t146 * t90 * t94 - 0.5e1 / 0.12e2 * t44 * t89 * t216 - 0.5e1 / 0.9e1 * t44 * t151 * t155 - 0.770e3 / 0.81e2 * l0 / t16 / t116 / r0 * t27 + 0.1100e4 / 0.81e2 * t119 * t37 - 0.50e2 / 0.9e1 * t73 * t86 + 0.25e2 / 0.18e2 * t19 * t142 - 0.5e1 / 0.24e2 * t32 * t26 * t238 + 0.5e1 / 0.24e2 * t44 * t48 * t238 + 0.2618e4 / 0.81e2 * t7 / t3 / t65 / t8
  t269 = 0.1e1 / t171 / t57
  t273 = 0.1e1 / t3 / t8
  t276 = 0.37037037037037037037037037037037037037037037037038e0 * t83 * t103 - 0.16283141688897225857433604268527894894274375171076e3 / t2 / t9 * t172 + 0.17676046884046853391350823130211339323981898108540e5 * t11 * t269 - 0.75818777777777777777777777777777777777777777777778e-3 * t58 * t273
  t279 = 3 ** (0.1e1 / 0.3e1)
  t281 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t282 = t279 * t281
  t283 = 4 ** (0.1e1 / 0.3e1)
  t284 = t283 ** 2
  t296 = 0.20710800000000000000000000000000000000000000000000e0 * t282 * t284 + 0.53877250000000000000000000000000000000000000000000e-2 * t282 * t284 * (-t44 * t48 * t46 / 0.8e1 - t32 * t27 / 0.8e1 + t7 * t273 / 0.8e1)
  t299 = t279 ** 2
  t302 = t299 / t281 * t283
  t322 = t171 ** 2
  d1111 = 0.25541807407407407407407407407407407407407407407407e-1 * t5 * t53 * t61 - 0.57469066666666666666666666666666666666666666666666e-1 * t64 * t98 * t61 - 0.11493813333333333333333333333333333333333333333333e0 * t64 * t53 * t108 - 0.11493813333333333333333333333333333333333333333333e0 * t2 * t159 * t61 - 0.34481440000000000000000000000000000000000000000000e0 * t2 * t98 * t108 - 0.34481440000000000000000000000000000000000000000000e0 * t2 * t53 * t177 - 0.21550900000000000000000000000000000000000000000000e-1 * t180 * t251 * t61 - 0.86203600000000000000000000000000000000000000000000e-1 * t180 * t159 * t108 - 0.12930540000000000000000000000000000000000000000000e0 * t180 * t98 * t177 - 0.86203600000000000000000000000000000000000000000000e-1 * t180 * t53 * t276 + 0.32e2 / 0.81e2 * t5 * t296 * t108 * t302 - 0.8e1 / 0.9e1 * t64 * t296 * t177 * t302 - 0.16e2 / 0.9e1 * t2 * t296 * t276 * t302 - t180 * t296 * (-0.98765432098765432098765432098765432098765432098764e0 * t138 * t103 + 0.60307932181100836509013349142695907015831019152133e3 / t2 / t65 * t172 - 0.11784031256031235594233882086807559549321265405694e6 * t67 * t269 + 0.86346472773757568077051288135946676573241643492696e7 * t235 / t322 + 0.20218340740740740740740740740740740740740740740741e-2 * t58 * t11) * t302 / 0.3e1 - 0.40e2 / 0.243e3 * t273 * t296 * t61 * t302

  res = {'v4rho4': d1111}
  return res

def pol_vxc(p, r, s=(None, None, None), l=(None, None), tau=(None, None)):
  f = funcs(p)
  params = f.params
  (r0, r1), (s0, s1, s2), (l0, l1), (tau0, tau1) = r, s, l, tau
  zlp_c = 0.828432 * f.RS_FACTOR

  zlp_d = 0.0215509 * f.RS_FACTOR

  zlp_k = 0.002047107 * f.RS_FACTOR

  zlp_f = lambda rs, z, xt, us0, us1: -(zlp_c + zlp_d * f.t_vw(z, xt, us0, us1)) * (1 - zlp_k * jnp.log(1 + rs / zlp_k) / rs) / rs

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0=None, ts1=None: zlp_f(rs, z, xt, us0, us1)

  # Guard denominators in zlp_f (use log1p for stability)
  _den_rs = lambda rs: jnp.maximum(rs, 1e-18)
  zlp_f = lambda rs, z, xt, us0, us1: -(zlp_c + zlp_d * f.t_vw(z, xt, us0, us1)) * (1 - zlp_k * jnp.log1p(rs / zlp_k) / _den_rs(rs)) / _den_rs(rs)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t10 = s0 + 0.2e1 * s1 + s2
  t11 = r0 + r1
  t12 = t11 ** 2
  t13 = t11 ** (0.1e1 / 0.3e1)
  t14 = t13 ** 2
  t18 = r0 ** (0.1e1 / 0.3e1)
  t19 = t18 ** 2
  t21 = 0.1e1 / t19 / r0
  t22 = l0 * t21
  t23 = r0 - r1
  t24 = 0.1e1 / t11
  t25 = t23 * t24
  t27 = 0.1e1 / 0.2e1 + t25 / 0.2e1
  t28 = t27 ** (0.1e1 / 0.3e1)
  t29 = t28 ** 2
  t30 = t29 * t27
  t32 = r1 ** (0.1e1 / 0.3e1)
  t33 = t32 ** 2
  t35 = 0.1e1 / t33 / r1
  t36 = l1 * t35
  t38 = 0.1e1 / 0.2e1 - t25 / 0.2e1
  t39 = t38 ** (0.1e1 / 0.3e1)
  t40 = t39 ** 2
  t41 = t40 * t38
  t48 = 0.20710800000000000000000000000000000000000000000000e0 * t4 * t6 + 0.53877250000000000000000000000000000000000000000000e-2 * t4 * t6 * (t10 / t14 / t12 / 0.8e1 - t22 * t30 / 0.8e1 - t36 * t41 / 0.8e1)
  t51 = 0.1e1 + 0.48849425066691677572300812805583684682823125513224e3 / t13
  t52 = jnp.log(t51)
  t55 = 0.1e1 - 0.20471070000000000000000000000000000000000000000000e-2 * t52 * t13
  t57 = t1 ** 2
  t59 = 0.1e1 / t3
  t63 = 0.4e1 / 0.9e1 * t48 * t55 * t57 * t59 * t5 * t13
  t64 = t13 * t11
  t69 = t10 / t14 / t12 / t11 / 0.3e1
  t70 = r0 ** 2
  t77 = t23 / t12
  t79 = t24 / 0.2e1 - t77 / 0.2e1
  t103 = t64 * t48 * (0.33333333333333333333333333333333333333333333333334e0 * t24 / t51 - 0.68236900000000000000000000000000000000000000000000e-3 * t52 / t14) * t57 * t59 * t5 / 0.3e1
  vrho_0_ = -t63 - 0.21550900000000000000000000000000000000000000000000e-1 * t64 * (-t69 + 0.5e1 / 0.24e2 * l0 / t19 / t70 * t30 - 0.5e1 / 0.24e2 * t22 * t29 * t79 + 0.5e1 / 0.24e2 * t36 * t40 * t79) * t55 - t103
  t105 = -t24 / 0.2e1 - t77 / 0.2e1
  t109 = r1 ** 2
  vrho_1_ = -t63 - 0.21550900000000000000000000000000000000000000000000e-1 * t64 * (-t69 - 0.5e1 / 0.24e2 * t22 * t29 * t105 + 0.5e1 / 0.24e2 * l1 / t33 / t109 * t41 + 0.5e1 / 0.24e2 * t36 * t40 * t105) * t55 - t103
  t124 = 0.1e1 / t64 * t55
  vsigma_0_ = -0.26938625000000000000000000000000000000000000000000e-2 * t124
  vsigma_1_ = -0.53877250000000000000000000000000000000000000000000e-2 * t124
  vsigma_2_ = vsigma_0_
  vlapl_0_ = 0.26938625000000000000000000000000000000000000000000e-2 * t64 * t21 * t30 * t55
  vlapl_1_ = 0.26938625000000000000000000000000000000000000000000e-2 * t64 * t35 * t41 * t55
  vtau_0_ = 0.0e0
  vtau_1_ = 0.0e0
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vrho_1_ = _b(vrho_1_)
  vsigma_0_ = _b(vsigma_0_)
  vsigma_1_ = _b(vsigma_1_)
  vsigma_2_ = _b(vsigma_2_)
  vlapl_0_ = _b(vlapl_0_)
  vlapl_1_ = _b(vlapl_1_)
  vtau_0_ = _b(vtau_0_)
  vtau_1_ = _b(vtau_1_)
  res = {'vrho': jnp.stack([vrho_0_, vrho_1_], axis=-1), 'vsigma': jnp.stack([vsigma_0_, vsigma_1_, vsigma_2_], axis=-1), 'vlapl': jnp.stack([vlapl_0_, vlapl_1_], axis=-1), 'vtau':  jnp.stack([vtau_0_, vtau_1_], axis=-1)}
  return res

def unpol_vxc(p, r, s=None, l=None, tau=None):
  f = funcs(p)
  params = f.params
  r0, s0, l0, tau0 = r, s, l, tau
  zlp_c = 0.828432 * f.RS_FACTOR

  zlp_d = 0.0215509 * f.RS_FACTOR

  zlp_k = 0.002047107 * f.RS_FACTOR

  zlp_f = lambda rs, z, xt, us0, us1: -(zlp_c + zlp_d * f.t_vw(z, xt, us0, us1)) * (1 - zlp_k * jnp.log(1 + rs / zlp_k) / rs) / rs

  functional_body = lambda rs, z, xt, xs0, xs1, us0, us1, ts0=None, ts1=None: zlp_f(rs, z, xt, us0, us1)

  # Guard denominators in zlp_f (use log1p for stability)
  _den_rs = lambda rs: jnp.maximum(rs, 1e-18)
  zlp_f = lambda rs, z, xt, us0, us1: -(zlp_c + zlp_d * f.t_vw(z, xt, us0, us1)) * (1 - zlp_k * jnp.log1p(rs / zlp_k) / _den_rs(rs)) / _den_rs(rs)

  t1 = 3 ** (0.1e1 / 0.3e1)
  t3 = (0.1e1 / jnp.pi) ** (0.1e1 / 0.3e1)
  t4 = t1 * t3
  t5 = 4 ** (0.1e1 / 0.3e1)
  t6 = t5 ** 2
  t9 = r0 ** 2
  t10 = r0 ** (0.1e1 / 0.3e1)
  t11 = t10 ** 2
  t13 = 0.1e1 / t11 / t9
  t23 = 0.20710800000000000000000000000000000000000000000000e0 * t4 * t6 + 0.53877250000000000000000000000000000000000000000000e-2 * t4 * t6 * (s0 * t13 / 0.8e1 - l0 / t11 / r0 / 0.8e1)
  t24 = 0.1e1 / t10
  t26 = 0.1e1 + 0.48849425066691677572300812805583684682823125513224e3 * t24
  t27 = jnp.log(t26)
  t30 = 0.1e1 - 0.20471070000000000000000000000000000000000000000000e-2 * t27 * t10
  t32 = t1 ** 2
  t34 = 0.1e1 / t3
  t39 = t10 * r0
  vrho_0_ = -0.4e1 / 0.9e1 * t23 * t30 * t32 * t34 * t5 * t10 - 0.21550900000000000000000000000000000000000000000000e-1 * t39 * (-s0 / t11 / t9 / r0 / 0.3e1 + 0.5e1 / 0.24e2 * l0 * t13) * t30 - t39 * t23 * (0.33333333333333333333333333333333333333333333333334e0 / r0 / t26 - 0.68236900000000000000000000000000000000000000000000e-3 * t27 / t11) * t32 * t34 * t5 / 0.3e1
  vsigma_0_ = -0.26938625000000000000000000000000000000000000000000e-2 / t39 * t30
  vlapl_0_ = 0.26938625000000000000000000000000000000000000000000e-2 * t24 * t30
  vtau_0_ = 0.0e0
  _b = lambda x: (jnp.asarray(x) + jnp.zeros_like(r0))
  vrho_0_ = _b(vrho_0_)
  vsigma_0_ = _b(vsigma_0_)
  vlapl_0_ = _b(vlapl_0_)
  vtau_0_ = _b(vtau_0_)
  res = {'vrho': vrho_0_, 'vsigma': vsigma_0_, 'vlapl': vlapl_0_, 'vtau':  vtau_0_}
  return res

