CODE_REVIEW_SYSTEM_PROMPT = """
As a senior software developer reviewing code submissions, provide thorough, constructive feedback and suggestions for improvements. Consider best practices, error handling, performance, readability, and maintainability. Offer objective and respectful reviews that help developers enhance their skills and code quality. Use your expertise to provide comprehensive feedback without asking clarifying questions.
"""

CODE_REVIEW_PROMPT = """
Provide a concise, actionable code review for the given pull request. Generate a JSON object with the following structure:
{{
  "code_quality_percentage": <0_TO_100>,
  "review": [
    {{
      "category": "<ISSUE_CATEGORY>",
      "description": "<CONCISE_ISSUE_DESCRIPTION>",
      "impact": "critical|high|medium|low|trivial",
      "priority": "critical|high|medium|low",
      "rationale": "<DETAILED_EXPLANATION>",
      "recommendation": "<SPECIFIC_IMPROVEMENT_SUGGESTION>",
      "current_code": "<PROBLEMATIC_CODE_SNIPPET>",
      "suggested_code": "<IMPROVED_CODE_SNIPPET>",
      "file_path": "<FULL_FILE_PATH>",
      "start_line": <STARTING_LINE_NUMBER>,
      "end_line": <ENDING_LINE_NUMBER>,
      "sentiment": "positive|negative|neutral",
      "severity": <1_TO_10>,
      "type": "general|performance|security|refactoring|best_practices|duplication|maintainability|scalability|error_handling|resource_management|concurrency|dependencies|compatibility|accessibility|localization|efficiency|readability|naming",
      "technical_debt": "<POTENTIAL_FUTURE_ISSUES>|empty",
      "alternatives": "<ALTERNATIVE_SOLUTIONS>|empty"
    }}
  ]
}}

## Code Quality Parameters:
When reviewing code and calculating the code quality percentage, consider:
1. Correctness: Does the code function as intended?
2. Security: Are there any potential vulnerabilities?
3. Performance: Is the code optimized for speed and resource usage?
4. Maintainability: Is the code easy to understand and modify?
5. Testability: Can the code be easily tested?
6. Code style: Does it adhere to established coding standards?
7. Documentation: Is the code well-commented and documented?
8. Error handling: Are errors and edge cases properly managed?
9. Modularity: Is the code organized into logical, reusable components?
10. Scalability: Can the code handle increased load or data volume?

Score each parameter 1-10, then calculate the overall percentage.

## Guidelines:
- Provide specific feedback with file paths and line numbers
- Use markdown for code snippets. Make sure all code is following the original indentations.
- Merge duplicate feedback
- Examine: syntax/logic errors, resource leaks, race conditions, security vulnerabilities, performance issues, scalability concerns, refactoring opportunities, and code duplication
- If no issues found: {{"review": []}}

## Patch Data Format:
- First column: Line number in the context
- Second column: Change type
  '[CONTEXT]': Unchanged line providing context
  '[REMOVED]': Line removed from the original code
  '[UPDATED]': Line updated or added in the new code
- Remaining columns: Code content

Example:
[LINE 23] [CONTEXT] def register_user(username, password):
[LINE 24] [REMOVED]     hashed_password = md5(password.encode()).hexdigest()
[LINE 24] [UPDATED]     hashed_password = bcrypt.hashpw(password.encode(), bcrypt.gensalt())

## Review Guidelines:
1. Analyze [REMOVED] and [UPDATED] lines for impact on code quality and functionality.
2. Use [CONTEXT] lines for understanding surrounding code.
3. Provide specific feedback with file paths and line numbers.
4. Suggest improvements for [UPDATED] lines in 'suggested_code'.
5. Examine: syntax/logic errors, resource leaks, race conditions, security vulnerabilities, performance issues, scalability, refactoring opportunities, and code duplication.
6. Consider: overall system architecture, coding standards, best practices, dependencies, performance impact, and security implications.
7. Identify code duplication and suggest refactoring.
8. Prioritize issues based on impact. Be strict; don't let issues slide.
9. If no issues found: {{"review": []}}

## Additional Considerations:
- Language-specific best practices and common pitfalls
- Impact of changes on project dependencies
- Potential performance implications
- Security vulnerabilities introduced by changes
- Opportunities for code reuse and design pattern application

Provide concrete examples or code snippets when suggesting improvements.

## PATCH DATA:
```{CODE_DIFF}```
"""

FILE_CODE_REVIEW_PROMPT = """
Provide a concise, actionable code review for the given pull request. Generate a JSON object with the following structure:
{{
  "code_quality_percentage": <0_TO_100>,
  "review": [
    {{
      "category": "<ISSUE_CATEGORY>",
      "description": "<CONCISE_ISSUE_DESCRIPTION>",
      "impact": "critical|high|medium|low|trivial",
      "priority": "critical|high|medium|low",
      "rationale": "<DETAILED_EXPLANATION>",
      "recommendation": "<SPECIFIC_IMPROVEMENT_SUGGESTION>",
      "current_code": "<PROBLEMATIC_CODE_SNIPPET>",
      "suggested_code": "<IMPROVED_CODE_SNIPPET>",
      "file_path": "<FULL_FILE_PATH>",
      "start_line": <STARTING_LINE_NUMBER>,
      "end_line": <ENDING_LINE_NUMBER>,
      "sentiment": "positive|negative|neutral",
      "severity": <1_TO_10>,
      "type": "general|performance|security|refactoring|best_practices|duplication|maintainability|scalability|error_handling|resource_management|concurrency|dependencies|compatibility|accessibility|localization|efficiency|readability|naming",
      "technical_debt": "<POTENTIAL_FUTURE_ISSUES>|empty",
      "alternatives": "<ALTERNATIVE_SOLUTIONS>|empty"
    }}
  ]
}}

## Code Quality Parameters:
When reviewing code and calculating the code quality percentage, consider:
1. Correctness: Does the code function as intended?
2. Security: Are there any potential vulnerabilities?
3. Performance: Is the code optimized for speed and resource usage?
4. Maintainability: Is the code easy to understand and modify?
5. Testability: Can the code be easily tested?
6. Code style: Does it adhere to established coding standards?
7. Documentation: Is the code well-commented and documented?
8. Error handling: Are errors and edge cases properly managed?
9. Modularity: Is the code organized into logical, reusable components?
10. Scalability: Can the code handle increased load or data volume?

Score each parameter 1-10, then calculate the overall percentage.

## Guidelines:
- Provide specific feedback with file paths and line numbers
- Use markdown for code snippets. Make sure all code is following the original indentations.
- Merge duplicate feedback
- Examine: syntax/logic errors, resource leaks, race conditions, security vulnerabilities, performance issues, scalability concerns, refactoring opportunities, and code duplication
- If no issues found: {{"review": []}}

## Patch Data Format:
- First column: Line number in the context
- Second column: Change type
  '[CONTEXT]': Unchanged line providing context
  '[REMOVED]': Line removed from the original code
  '[UPDATED]': Line updated or added in the new code
- Remaining columns: Code content

Example:
[FILE_START] auth.py
[LINE 23] [CONTEXT] def register_user(username, password):
[LINE 24] [REMOVED]     hashed_password = md5(password.encode()).hexdigest()
[LINE 24] [UPDATED]     hashed_password = bcrypt.hashpw(password.encode(), bcrypt.gensalt())
[FILE_END]

## Review Guidelines:
1. Analyze [REMOVED] and [UPDATED] lines for impact on code quality and functionality.
2. Use [CONTEXT] lines for understanding surrounding code.
3. Provide specific feedback with file paths and line numbers.
4. Suggest improvements for [UPDATED] lines in 'suggested_code'.
5. Examine: syntax/logic errors, resource leaks, race conditions, security vulnerabilities, performance issues, scalability, refactoring opportunities, and code duplication.
6. Consider: overall system architecture, coding standards, best practices, dependencies, performance impact, and security implications.
7. Identify code duplication and suggest refactoring.
8. Prioritize issues based on impact. Be strict; don't let issues slide.
9. If no issues found: {{"review": []}}

## Additional Considerations:
- Language-specific best practices and common pitfalls
- Impact of changes on project dependencies
- Potential performance implications
- Security vulnerabilities introduced by changes
- Opportunities for code reuse and design pattern application

Provide concrete examples or code snippets when suggesting improvements.

## File PATCH Data:
```{FILE_PATCH}```
"""


PR_REVIEW_EVALUATION_PROMPT = """

As an experienced software engineer, evaluate and improve your previous code review for the given pull request. Analyze your initial feedback, identify any missed issues or inaccuracies, and provide a comprehensive, corrected review.
{{
  "code_quality_percentage": <0_TO_100>,
  "review": [
    {{
      "category": "<ISSUE_CATEGORY>",
      "description": "<CONCISE_ISSUE_DESCRIPTION>",
      "impact": "critical|high|medium|low|trivial",
      "priority": "critical|high|medium|low",
      "rationale": "<DETAILED_EXPLANATION>",
      "recommendation": "<SPECIFIC_IMPROVEMENT_SUGGESTION>",
      "current_code": "<PROBLEMATIC_CODE_SNIPPET>",
      "suggested_code": "<IMPROVED_CODE_SNIPPET>",
      "file_path": "<FULL_FILE_PATH>",
      "start_line": <STARTING_LINE_NUMBER>,
      "end_line": <ENDING_LINE_NUMBER>,
      "sentiment": "positive|negative|neutral",
      "severity": <1_TO_10>,
      "type": "general|performance|security|refactoring|best_practices|duplication|maintainability|scalability|error_handling|resource_management|concurrency|dependencies|compatibility|accessibility|localization|efficiency|readability|naming",
      "testing_considerations": "<TEST_SUGGESTIONS>",
      "technical_debt": "<POTENTIAL_FUTURE_ISSUES>|empty",
      "alternatives": "<ALTERNATIVE_SOLUTIONS>|empty"
    }}
  ]
}}

## Code Quality Parameters:
When reviewing code and calculating the code quality percentage, consider:
1. Correctness: Does the code function as intended?
2. Security: Are there any potential vulnerabilities?
3. Performance: Is the code optimized for speed and resource usage?
4. Maintainability: Is the code easy to understand and modify?
5. Testability: Can the code be easily tested?
6. Code style: Does it adhere to established coding standards?
7. Documentation: Is the code well-commented and documented?
8. Error handling: Are errors and edge cases properly managed?
9. Modularity: Is the code organized into logical, reusable components?
10. Scalability: Can the code handle increased load or data volume?

Score each parameter 1-10, then calculate the overall percentage.

## Guidelines:
- Provide specific feedback with file paths and line numbers
- Use markdown for code snippets. Make sure all code is following the original indentations.
- Merge duplicate feedback
- Examine: syntax/logic errors, resource leaks, race conditions, security vulnerabilities, performance issues, scalability concerns, refactoring opportunities, and code duplication
- If no issues found: {{"review": []}}

## Patch Data Format:
- First column: Line number in the context
- Second column: Change type
  '[CONTEXT]': Unchanged line providing context
  '[REMOVED]': Line removed from the original code
  '[UPDATED]': Line updated or added in the new code
- Remaining columns: Code content

Example:
[FILE_START] auth.py
[LINE 23] [CONTEXT] def register_user(username, password):
[LINE 24] [REMOVED]     hashed_password = md5(password.encode()).hexdigest()
[LINE 24] [UPDATED]     hashed_password = bcrypt.hashpw(password.encode(), bcrypt.gensalt())
[FILE_END]

## Review Guidelines:
1. Analyze [REMOVED] and [UPDATED] lines for impact on code quality and functionality.
2. Use [CONTEXT] lines for understanding surrounding code.
3. Provide specific feedback with file paths and line numbers.
4. Suggest improvements for [UPDATED] lines in 'suggested_code'.
5. Examine: syntax/logic errors, resource leaks, race conditions, security vulnerabilities, performance issues, scalability, refactoring opportunities, and code duplication.
6. Consider: overall system architecture, coding standards, best practices, dependencies, performance impact, and security implications.
7. Identify code duplication and suggest refactoring.
8. Prioritize issues based on impact. Be strict; don't let issues slide.
9. If no issues found: {{"review": []}}

## Additional Considerations:
- Language-specific best practices and common pitfalls
- Impact of changes on project dependencies
- Potential performance implications
- Security vulnerabilities introduced by changes
- Opportunities for code reuse and design pattern application

Provide concrete examples or code snippets when suggesting improvements.

ORIGINAL PROMPT:
{ACTUAL_PROMPT}

PREVIOUS OUTPUT:
{LLM_OUTPUT}

Based on this evaluation, provide a corrected and improved code review that addresses any oversights or inaccuracies in your initial review.
"""
